/*-------------------------------------------------------------------------
 |                                                                         
 |             SAS SUPPLEMENTAL SYNTAX FILE FOR  
 |        TREATMENT EPISODE DATA SET -- DISCHARGES (TEDS-D), 2014
 |
 | This SAS program is provided for optional use with the SAS transport
 | version of this data file as distributed. The metadata
 | provided below are not stored in the SAS transport version of this data
 | collection.  Users need to use SAS PROC CIMPORT to import the SAS
 | transport file to a SAS data set on their system. This program can
 | then be used in conjunction with the SAS system data file.
 |
 | DATA:  begins a SAS data step and names an output SAS data set. Users
 | should replace "SAS-dataset" with their name for the SAS data set copied
 | from the SAS transport file. Users can add a SAS libname statement
 | and an output SAS data set name to make a permanent SAS data set.
 |
 | MISSING VALUE RECODES:  sets user-defined numeric missing values to
 | missing as interpreted by the SAS system. Only variables with
 | user-defined missing values are included in this section.
 |
 | If any variables have more than one missing value, they are assigned
 | to the standard missing value of a single period (.) in the statement
 | below. To maintain the original meaning of missing codes, users may want
 | to take advantage of the SAS missing values (the letters A-Z or an
 | underscore preceded by a period).
 |
 | An example of a standard missing value recode:
 |
 |   IF (RELATION = 98 OR RELATION = 99) THEN RELATION = .;
 |
 | The same example using special missing value recodes:
 |
 |    IF RELATION = 98 THEN RELATION = .A;
 |    IF RELATION = 99 THEN RELATION = .B;
 |
 | NOTE:  Users should modify this file to suit their specific needs.
 | The MISSING VALUE RECODES section has been commented out (i.e., '/*').
 | To make this section active in the program, users should remove the SAS
 | comment indicators from this section.
 |
 |------------------------------------------------------------------------*/

* SAS DATA STEP;
DATA;
SET SAS-dataset ;


* USER-DEFINED MISSING VALUES RECODE TO SAS SYSMIS;

/*
 IF (CASEID  <= -9) THEN CASEID  = .;
 IF (DISYR  <= -9) THEN DISYR  = .;
 IF (AGE  <= -9) THEN AGE  = .;
 IF (GENDER  <= -9) THEN GENDER  = .;
 IF (RACE  <= -9) THEN RACE  = .;
 IF (ETHNIC  <= -9) THEN ETHNIC  = .;
 IF (MARSTAT  <= -9) THEN MARSTAT  = .;
 IF (EDUC  <= -9) THEN EDUC  = .;
 IF (EMPLOY  <= -9) THEN EMPLOY  = .;
 IF (DETNLF  <= -9) THEN DETNLF  = .;
 IF (PREG  <= -9) THEN PREG  = .;
 IF (VET  <= -9) THEN VET  = .;
 IF (LIVARAG  <= -9) THEN LIVARAG  = .;
 IF (PRIMINC  <= -9) THEN PRIMINC  = .;
 IF (ARRESTS  <= -9) THEN ARRESTS  = .;
 IF (STFIPS  <= -9) THEN STFIPS  = .;
 IF (CBSA  <= -9) THEN CBSA  = .;
 IF (REGION  <= -9) THEN REGION  = .;
 IF (DIVISION  <= -9) THEN DIVISION  = .;
 IF (SERVSETD  <= -9) THEN SERVSETD  = .;
 IF (METHUSE  <= -9) THEN METHUSE  = .;
 IF (DAYWAIT  <= -9) THEN DAYWAIT  = .;
 IF (REASON  <= -9) THEN REASON  = .;
 IF (LOS  <= -9) THEN LOS  = .;
 IF (PSOURCE  <= -9) THEN PSOURCE  = .;
 IF (DETCRIM  <= -9) THEN DETCRIM  = .;
 IF (NOPRIOR  <= -9) THEN NOPRIOR  = .;
 IF (SUB1  <= -9) THEN SUB1  = .;
 IF (ROUTE1  <= -9) THEN ROUTE1  = .;
 IF (FREQ1  <= -9) THEN FREQ1  = .;
 IF (FRSTUSE1  <= -9) THEN FRSTUSE1  = .;
 IF (SUB2  <= -9) THEN SUB2  = .;
 IF (ROUTE2  <= -9) THEN ROUTE2  = .;
 IF (FREQ2  <= -9) THEN FREQ2  = .;
 IF (FRSTUSE2  <= -9) THEN FRSTUSE2  = .;
 IF (SUB3  <= -9) THEN SUB3  = .;
 IF (ROUTE3  <= -9) THEN ROUTE3  = .;
 IF (FREQ3  <= -9) THEN FREQ3  = .;
 IF (FRSTUSE3  <= -9) THEN FRSTUSE3  = .;
 IF (NUMSUBS  <= -9) THEN NUMSUBS  = .;
 IF (IDU  <= -9) THEN IDU  = .;
 IF (ALCFLG  <= -9) THEN ALCFLG  = .;
 IF (COKEFLG  <= -9) THEN COKEFLG  = .;
 IF (MARFLG  <= -9) THEN MARFLG  = .;
 IF (HERFLG  <= -9) THEN HERFLG  = .;
 IF (METHFLG  <= -9) THEN METHFLG  = .;
 IF (OPSYNFLG  <= -9) THEN OPSYNFLG  = .;
 IF (PCPFLG  <= -9) THEN PCPFLG  = .;
 IF (HALLFLG  <= -9) THEN HALLFLG  = .;
 IF (MTHAMFLG  <= -9) THEN MTHAMFLG  = .;
 IF (AMPHFLG  <= -9) THEN AMPHFLG  = .;
 IF (STIMFLG  <= -9) THEN STIMFLG  = .;
 IF (BENZFLG  <= -9) THEN BENZFLG  = .;
 IF (TRNQFLG  <= -9) THEN TRNQFLG  = .;
 IF (BARBFLG  <= -9) THEN BARBFLG  = .;
 IF (SEDHPFLG  <= -9) THEN SEDHPFLG  = .;
 IF (INHFLG  <= -9) THEN INHFLG  = .;
 IF (OTCFLG  <= -9) THEN OTCFLG  = .;
 IF (OTHERFLG  <= -9) THEN OTHERFLG  = .;
 IF (ALCDRUG  <= -9) THEN ALCDRUG  = .;
 IF (DSMCRIT  <= -9) THEN DSMCRIT  = .;
 IF (PSYPROB  <= -9) THEN PSYPROB  = .;
 IF (HLTHINS  <= -9) THEN HLTHINS  = .;
 IF (PRIMPAY  <= -9) THEN PRIMPAY  = .;
*/

RUN ;
