*-------------------------------------------------------------------------*
*                                                                          
*                     SPSS SETUP FILE FOR ICPSR 29901
*         TREATMENT EPISODE DATA SET -- DISCHARGES (TEDS-D), 2008
*                             (DATASET 0001: )
* 
*
*  SPSS setup sections are provided for the ASCII version of this data
*  collection.  These sections are listed below:
*
*  DATA LIST:  assigns the name, type, decimal specification (if any),
*  and specifies the beginning and ending column locations for each
*  variable in the data file. Users must replace the "data-filename"
*  in the DATA LIST statement with a filename specifying the directory
*  on the user's computer system in which the downloaded and unzipped
*  data file is physically located (e.g., "c:\temp\29901-0001-data.txt").
*
*  VARIABLE LABELS:  assigns descriptive labels to all variables.
*  Labels and variable names may be identical for some data files.
*
*  MISSING VALUES: declares user-defined missing values. Not all
*  variables in this data set necessarily have user-defined missing
*  values. These values can be treated specially in data transformations,
*  statistical calculations, and case selection.
*
*  VALUE LABELS: assigns descriptive labels to codes found in the data
*  file.  Not all codes necessarily have assigned value labels.
*
*  NOTE:  Users should modify this setup file to suit their specific 
*  needs. The MISSING VALUES section has been commented out (i.e., '*').
*  To include the MISSING VALUES section in the final SPSS setup, remove 
*  the comment indicators from the desired section.
*
*  CREATING A PERMANENT SPSS DATA FILE: If users wish to create and save
*  an SPSS data file for further analysis using SPSS for Windows, the
*  necessary "SAVE OUTFILE" command is provided in the last line of
*  this file.  To activate the command, users must delete the leading
*  asterisk (*) and replace "spss-filename" with a filename specifying
*  the location on the user's computer system to which the new data file
*  will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\da29901-0001.sav").
*
*-------------------------------------------------------------------------.

* SPSS FILE HANDLE AND DATA LIST COMMANDS.

FILE HANDLE DATA / NAME="data-filename" LRECL=127.
DATA LIST FILE=DATA /
              CASEID 1-8              DISYR 9-12               AGE 13-14
            GENDER 15-16              RACE 17-18            ETHNIC 19-20
           MARSTAT 21-22              EDUC 23-24            EMPLOY 25-26
            DETNLF 27-28              PREG 29-30               VET 31-32
           LIVARAG 33-34           PRIMINC 35-36           ARRESTS 37-38
            STFIPS 39-40              CBSA 41-45              PMSA 46-49
            REGION 50-51          DIVISION 52-53          SERVSETD 54-55
           METHUSE 56-57           DAYWAIT 58-60            REASON 61-62
               LOS 63-65           PSOURCE 66-67           DETCRIM 68-69
           NOPRIOR 70-71              SUB1 72-73            ROUTE1 74-75
             FREQ1 76-77          FRSTUSE1 78-79              SUB2 80-81
            ROUTE2 82-83             FREQ2 84-85          FRSTUSE2 86-87
              SUB3 88-89            ROUTE3 90-91             FREQ3 92-93
          FRSTUSE3 94-95           NUMSUBS 96-97               IDU 98-99
              ALCFLG 100             COKEFLG 101              MARFLG 102
              HERFLG 103             METHFLG 104            OPSYNFLG 105
              PCPFLG 106             HALLFLG 107            MTHAMFLG 108
             AMPHFLG 109             STIMFLG 110             BENZFLG 111
             TRNQFLG 112             BARBFLG 113            SEDHPFLG 114
              INHFLG 115              OTCFLG 116            OTHERFLG 117
         ALCDRUG 118-119         DSMCRIT 120-121         PSYPROB 122-123
         HLTHINS 124-125         PRIMPAY 126-127
   .

* SPSS VARIABLE LABELS COMMAND.

VARIABLE LABELS
   CASEID    'CASE IDENTIFICATION NUMBER' /
   DISYR     'YEAR OF DISCHARGE' /
   AGE       'AGE (RECODED)' /
   GENDER    'SEX' /
   RACE      'RACE' /
   ETHNIC    'ETHNICITY (HISPANIC ORIGIN)' /
   MARSTAT   'MARITAL STATUS' /
   EDUC      'EDUCATION' /
   EMPLOY    'EMPLOYMENT STATUS' /
   DETNLF    'DETAILED ''NOT IN LABOR FORCE'' CATEGORY' /
   PREG      'PREGNANT AT TIME OF ADMISSION' /
   VET       'VETERAN STATUS' /
   LIVARAG   'LIVING ARRANGEMENTS' /
   PRIMINC   'SOURCE OF INCOME/SUPPORT' /
   ARRESTS   'NUMBER OF ARRESTS IN 30 DAYS PRIOR TO ADMISSION' /
   STFIPS    'CENSUS STATE FIPS CODE' /
   CBSA      'FIPS 2000 CBSA CODE' /
   PMSA      'FIPS 1990 MSA CODE' /
   REGION    'CENSUS REGION' /
   DIVISION  'CENSUS DIVISION' /
   SERVSETD  'SERVICE SETTING AT DISCHARGE' /
   METHUSE   'MEDICATION-ASSISTED OPIOID THERAPY' /
   DAYWAIT   'DAYS WAITING TO ENTER TREATMENT' /
   REASON    'REASON FOR DISCHARGE' /
   LOS       'LENGTH OF STAY' /
   PSOURCE   'PRINCIPAL SOURCE OF REFERRAL' /
   DETCRIM   'DETAILED CRIMINAL JUSTICE REFERRAL' /
   NOPRIOR   'NUMBER OF PRIOR TREATMENT EPISODES' /
   SUB1      'SUBSTANCE PROBLEM CODE (PRIMARY)' /
   ROUTE1    'USUAL ROUTE OF ADMINISTRATION (PRIMARY)' /
   FREQ1     'FREQUENCY OF USE (PRIMARY)' /
   FRSTUSE1  'AGE AT FIRST USE (PRIMARY)' /
   SUB2      'SUBSTANCE PROBLEM CODE (SECONDARY)' /
   ROUTE2    'USUAL ROUTE OF ADMINISTRATION (SECONDARY)' /
   FREQ2     'FREQUENCY OF USE (SECONDARY)' /
   FRSTUSE2  'AGE AT FIRST USE (SECONDARY)' /
   SUB3      'SUBSTANCE PROBLEM CODE (TERTIARY)' /
   ROUTE3    'USUAL ROUTE OF ADMINISTRATION (TERTIARY)' /
   FREQ3     'FREQUENCY OF USE (TERTIARY)' /
   FRSTUSE3  'AGE AT FIRST USE (TERTIARY)' /
   NUMSUBS   'NUMBER OF SUBSTANCES REPORTED AT ADM.' /
   IDU       'CURRENT IV DRUG USE REPORTED AT ADM.' /
   ALCFLG    'ALCOHOL REPORTED AT ADM.' /
   COKEFLG   'COCAINE/CRACK REPORTED AT ADM.' /
   MARFLG    'MARIJUANA/HASHISH REPORTED AT ADM.' /
   HERFLG    'HEROIN REPORTED AT ADM.' /
   METHFLG   'NON-RX METHADONE REPORTED AT ADM.' /
   OPSYNFLG  'OTHER OPIATES/SYNTHETICS REPORTED AT ADM.' /
   PCPFLG    'PCP REPORTED AT ADM.' /
   HALLFLG   'OTHER HALLUCINOGENS REPORTED AT ADM.' /
   MTHAMFLG  'METHAMPHETAMINE REPORTED AT ADM.' /
   AMPHFLG   'OTHER AMPHETAMINES REPORTED AT ADM.' /
   STIMFLG   'OTHER STIMULANTS REPORTED AT ADM.' /
   BENZFLG   'BENZODIAZEPINES REPORTED AT ADM.' /
   TRNQFLG   'OTHER NON-BENZODIAZEPINE TRANQUILIZERS REPORTED AT ADM.' /
   BARBFLG   'BARBITURATES REPORTED AT ADM.' /
   SEDHPFLG  'OTHER NON-BARBITURATE SEDATIVES/HYPNOTICS REPORTED AT ADM.' /
   INHFLG    'INHALANTS REPORTED AT ADM.' /
   OTCFLG    'OVER-THE-COUNTER MEDICATION REPORTED AT ADM.' /
   OTHERFLG  'OTHER DRUG REPORTED AT ADM.' /
   ALCDRUG   'SUBSTANCE ABUSE TYPE' /
   DSMCRIT   'DSM DIAGNOSIS' /
   PSYPROB   'PSYCHIATRIC PROBLEM IN ADDITION TO ALCOHOL/DRUG PROBLEM' /
   HLTHINS   'HEALTH INSURANCE' /
   PRIMPAY   'EXPECTED/ACTUAL PRIMARY SOURCE OF PAYMENT' /
   .


* SPSS VALUE LABELS COMMAND.

VALUE LABELS
   DISYR     -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' /
   AGE       2 '12-14' 3 '15-17' 4 '18-20' 5 '21-24' 6 '25-29' 7 '30-34'
             8 '35-39' 9 '40-44' 10 '45-49' 11 '50-54' 12 '55 AND OVER' /
   GENDER    -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'MALE' 2 'FEMALE' /
   RACE      -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             1 'ALASKA NATIVE (ALEUT, ESKIMO, INDIAN)'
             2 'AMERICAN INDIAN (OTHER THAN ALASKA NATIVE)'
             3 'ASIAN OR PACIFIC ISLANDER' 4 'BLACK OR AFRICAN AMERICAN'
             5 'WHITE' 13 'ASIAN' 20 'OTHER SINGLE RACE'
             21 'TWO OR MORE RACES'
             23 'NATIVE HAWAIIAN OR OTHER PACIFIC ISLANDER' /
   ETHNIC    -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'PUERTO RICAN'
             2 'MEXICAN' 3 'CUBAN' 4 'OTHER SPECIFIC HISPANIC'
             5 'NOT OF HISPANIC ORIGIN'
             6 'HISPANIC, SPECIFIC ORIGIN NOT SPECIFIED' /
   MARSTAT   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'NEVER MARRIED'
             2 'NOW MARRIED' 3 'SEPARATED' 4 'DIVORCED, WIDOWED' /
   EDUC      -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 '8 YEARS OR LESS'
             2 '9-11' 3 '12' 4 '13-15' 5 '16 OR MORE' /
   EMPLOY    -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'FULL TIME'
             2 'PART TIME' 3 'UNEMPLOYED' 4 'NOT IN LABOR FORCE' /
   DETNLF    -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'HOMEMAKER'
             2 'STUDENT' 3 'RETIRED, DISABLED' 5 'INMATE OF INSTITUTION'
             6 'OTHER' /
   PREG      -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'YES' 2 'NO' /
   VET       -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'YES' 2 'NO' /
   LIVARAG   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'HOMELESS'
             2 'DEPENDENT LIVING' 3 'INDEPENDENT LIVING' /
   PRIMINC   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'WAGES/SALARY'
             2 'PUBLIC ASSISTANCE' 3 'RETIREMENT/PENSION, DISABILITY'
             20 'OTHER' 21 'NONE' /
   ARRESTS   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 0 'NONE' 1 'ONCE'
             2 '2 OR MORE TIMES' /
   STFIPS    -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'ALABAMA'
             2 'ALASKA' 4 'ARIZONA' 5 'ARKANSAS' 6 'CALIFORNIA' 8 'COLORADO'
             9 'CONNECTICUT' 10 'DELAWARE' 11 'DISTRICT OF COLUMBIA'
             12 'FLORIDA' 13 'GEORGIA' 15 'HAWAII' 16 'IDAHO' 17 'ILLINOIS'
             18 'INDIANA' 19 'IOWA' 20 'KANSAS' 21 'KENTUCKY' 22 'LOUISIANA'
             23 'MAINE' 24 'MARYLAND' 25 'MASSACHUSETTS' 26 'MICHIGAN'
             27 'MINNESOTA' 28 'MISSISSIPPI' 29 'MISSOURI' 30 'MONTANA'
             31 'NEBRASKA' 32 'NEVADA' 33 'NEW HAMPSHIRE' 34 'NEW JERSEY'
             35 'NEW MEXICO' 36 'NEW YORK' 37 'NORTH CAROLINA'
             38 'NORTH DAKOTA' 39 'OHIO' 40 'OKLAHOMA' 41 'OREGON'
             42 'PENNSYLVANIA' 44 'RHODE ISLAND' 45 'SOUTH CAROLINA'
             46 'SOUTH DAKOTA' 47 'TENNESSEE' 48 'TEXAS' 49 'UTAH'
             50 'VERMONT' 51 'VIRGINIA' 53 'WASHINGTON' 54 'WEST VIRGINIA'
             55 'WISCONSIN' 56 'WYOMING' 72 'PUERTO RICO' /
   CBSA      -9 'UNDESIGNATED AREA/MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             10020 'ABBEVILLE, LA MICRO' 10100 'ABERDEEN, SD MICRO'
             10140 'ABERDEEN, WA MICRO' 10180 'ABILENE, TX METRO'
             10220 'ADA, OK MICRO' 10260 'ADJUNTAS, PR MICRO'
             10300 'ADRIAN, MI MICRO'
             10380 'AGUADILLA-ISABELA-SAN SEBASTIAN, PR METRO'
             10420 'AKRON, OH METRO' 10460 'ALAMOGORDO, NM MICRO'
             10500 'ALBANY, GA METRO' 10540 'ALBANY-LEBANON, OR MICRO'
             10580 'ALBANY-SCHENECTADY-TROY, NY METRO'
             10620 'ALBEMARLE, NC MICRO' 10660 'ALBERT LEA, MN MICRO'
             10700 'ALBERTVILLE, AL MICRO' 10740 'ALBUQUERQUE, NM METRO'
             10780 'ALEXANDRIA, LA METRO' 10820 'ALEXANDRIA, MN MICRO'
             10860 'ALICE, TX MICRO' 10880 'ALLEGAN, MI MICRO'
             10900 'ALLENTOWN-BETHLEHEM-EASTON, PA-NJ METRO'
             10940 'ALMA, MI MICRO' 10980 'ALPENA, MI MICRO'
             11020 'ALTOONA, PA METRO' 11060 'ALTUS, OK MICRO'
             11100 'AMARILLO, TX METRO' 11140 'AMERICUS, GA MICRO'
             11180 'AMES, IA METRO' 11220 'AMSTERDAM, NY MICRO'
             11260 'ANCHORAGE, AK METRO' 11300 'ANDERSON, IN METRO'
             11340 'ANDERSON, SC METRO' 11380 'ANDREWS, TX MICRO'
             11420 'ANGOLA, IN MICRO' 11460 'ANN ARBOR, MI METRO'
             11500 'ANNISTON-OXFORD, AL METRO' 11540 'APPLETON, WI METRO'
             11580 'ARCADIA, FL MICRO' 11620 'ARDMORE, OK MICRO'
             11660 'ARKADELPHIA, AR MICRO' 11700 'ASHEVILLE, NC METRO'
             11740 'ASHLAND, OH MICRO' 11780 'ASHTABULA, OH MICRO'
             11820 'ASTORIA, OR MICRO' 11860 'ATCHISON, KS MICRO'
             11900 'ATHENS, OH MICRO' 11940 'ATHENS, TN MICRO'
             11980 'ATHENS, TX MICRO' 12020 'ATHENS-CLARKE COUNTY, GA METRO'
             12060 'ATLANTA-SANDY SPRINGS-MARIETTA, GA METRO'
             12100 'ATLANTIC CITY, NJ METRO' 12140 'AUBURN, IN MICRO'
             12180 'AUBURN, NY MICRO' 12220 'AUBURN-OPELIKA, AL METRO'
             12260 'AUGUSTA-RICHMOND COUNTY, GA-SC METRO'
             12300 'AUGUSTA-WATERVILLE, ME MICRO' 12380 'AUSTIN, MN MICRO'
             12420 'AUSTIN-ROUND ROCK, TX METRO' 12460 'BAINBRIDGE, GA MICRO'
             12540 'BAKERSFIELD, CA METRO' 12580 'BALTIMORE-TOWSON, MD METRO'
             12620 'BANGOR, ME METRO' 12660 'BARABOO, WI MICRO'
             12700 'BARNSTABLE TOWN, MA METRO' 12740 'BARRE, VT MICRO'
             12780 'BARTLESVILLE, OK MICRO' 12820 'BASTROP, LA MICRO'
             12860 'BATAVIA, NY MICRO' 12900 'BATESVILLE, AR MICRO'
             12940 'BATON ROUGE, LA METRO' 12980 'BATTLE CREEK, MI METRO'
             13020 'BAY CITY, MI METRO' 13060 'BAY CITY, TX MICRO'
             13100 'BEATRICE, NE MICRO'
             13140 'BEAUMONT-PORT ARTHUR, TX METRO'
             13180 'BEAVER DAM, WI MICRO' 13220 'BECKLEY, WV MICRO'
             13260 'BEDFORD, IN MICRO' 13300 'BEEVILLE, TX MICRO'
             13340 'BELLEFONTAINE, OH MICRO' 13380 'BELLINGHAM, WA METRO'
             13420 'BEMIDJI, MN MICRO' 13460 'BEND, OR METRO'
             13500 'BENNETTSVILLE, SC MICRO' 13540 'BENNINGTON, VT MICRO'
             13620 'BERLIN, NH-VT MICRO' 13660 'BIG RAPIDS, MI MICRO'
             13700 'BIG DPRING, TX MICRO' 13740 'BILLINGS, MT METRO'
             13780 'BINGHAMTON, NY METRO' 13820 'BIRMINGHAM-HOOVER, AL METRO'
             13860 'BISHOP, CA MICRO' 13900 'BISMARCK, ND METRO'
             13940 'BLACKFOOT, ID MICRO'
             13980 'BLACKSBURG-CHRISTIANSBURG-RADFORD, VA METRO'
             14020 'BLOOMINGTON, IN METRO'
             14060 'BLOOMINGTON-NORMAL, IL METRO'
             14100 'BLOOMSBURG-BERWICK, PA MICRO'
             14140 'BLUEFIELD, WV-VA MICRO' 14180 'BLYTHEVILLE, AR MICRO'
             14220 'BOGALUSA, LA MICRO' 14260 'BOISE CITY-NAMPA, ID METRO'
             14340 'BOONE, IA MICRO' 14380 'BOONE, NC MICRO'
             14420 'BORGER, TX MICRO'
             14460 'BOSTON-CAMBRIDGE-QUNICY, MA-NH METRO'
             14500 'BOULDER, CO METRO' 14540 'BOWLING GREEN, KY METRO'
             14580 'BOZEMAN, MT MICRO' 14620 'BRADFORD, PA MICRO'
             14660 'BRAINERD, MN MICRO' 14700 'BRANSON, MO MICRO'
             14740 'BREMERTON-SILVERDALE, WA METRO' 14780 'BRENHAM, TX MICRO'
             14820 'BREVARD, NC MICRO'
             14860 'BRIDGEPORT-STAMFORD-NORWALK, CT METRO'
             14940 'BOX ELDER, UT MICRO' 14980 'BRISTOL, VA METRO'
             15020 'BROOKHAVEN, MS MICRO' 15060 'BROOKINGS, OR MICRO'
             15100 'BROOKINGS, SD MICRO' 15140 'BROWNSVILLE, TN MICRO'
             15180 'BROWNSVILLE-HARLINGEN, TX METRO'
             15220 'BROWNWOOD, TX MICRO' 15260 'BRUNSWICK, GA METRO'
             15340 'BUCYRUS, OH MICRO'
             15380 'BUFFALO-CHEEKTOWAGA-TONAWANDA, NY METRO'
             15420 'BURLEY, ID MICRO' 15460 'BURLINGTON, IA-IL MICRO'
             15500 'BURLINGTON, NC METRO'
             15540 'BURLINGTON-SOUTH BURLINGTON, VT METRO'
             15580 'BUTTE-SILVER BOW, MT MICRO' 15620 'CADILLAC, MI MICRO'
             15660 'CALHOUN, GA MICRO' 15700 'CAMBRIDGE, MD MICRO'
             15740 'CAMBRIDGE, OH MICRO' 15780 'CAMDEN, AR MICRO'
             15820 'CAMPBELLSVILLE, KY MICRO' 15860 'CANON CITY, CO MICRO'
             15900 'CANTON, IL MICRO' 15940 'CANTON-MASSILLON, OH METRO'
             15980 'CAPE CORAL-FORT MYERS, FL METRO'
             16020 'CAPE GIRARDEAU-JACKSON, MO-IL MICRO'
             16060 'CARBONDALE, IL MICRO' 16100 'CARLSBAD-ARTESIA, NM MICRO'
             16180 'CARSON CITY, NV METRO' 16220 'CASPER, WY METRO'
             16260 'CEDAR CITY, UT MICRO' 16300 'CEDAR RAPIDS, IA METRO'
             16340 'CEDARTOWN, GA MICRO' 16380 'CELINA, OH MICRO'
             16420 'CENTRAL CITY, KS MICRO' 16460 'CENTRALIA, IL MICRO'
             16500 'CENTRALIA, WA MICRO' 16540 'CHAMBERSBURG, PA MICRO'
             16580 'CHAMPAIGN-URBANA, IL METRO' 16620 'CHARLESTON, WV METRO'
             16660 'CHARLESTON-MATTOON, IL MICRO'
             16700 'CHARLESTON-NORTH CHARLESTON, SC METRO'
             16740 'CHARLOTTE-GASTONIA-CONCORD, NC-SC METRO'
             16820 'CHARLOTTESVILLE, VA METRO'
             16860 'CHATTANOOGA, TN-GA METRO' 16900 'CHESTER, SC MICRO'
             16940 'CHEYENNE, WY METRO'
             16980 'CHICAGO-NAPERVILLE-JOLIET, IL-IN-WI METRO'
             17020 'CHICO, CA METRO' 17060 'CHILLICOTHE, OH MICRO'
             17140 'CINCINNATI-MIDDLETOWN, OH-KY-IN METRO'
             17180 'CITY OF THE DALLES, OR MICRO'
             17220 'CLARKSBURG, WV MICRO' 17260 'CLARKSDALE, MS MICRO'
             17300 'CLARKSVILLE, TN-KY METRO' 17340 'CLEARLAKE, CA MICRO'
             17380 'CLEVELAND, MS MICRO' 17420 'CLEVELAND, TN METRO'
             17460 'CLEVELAND-ELYRIA-MENTOR, OH METRO'
             17500 'CLEWISTON, FL MICRO' 17540 'CLINTON, IA MICRO'
             17580 'CLOVIS, NM MICRO' 17620 'COAMO, PR MICRO'
             17660 'COEUR D''ALENE, ID METRO' 17700 'COFFEYVILLE, KS MICRO'
             17740 'COLDWATER, MI MICRO'
             17780 'COLLEGE STATION-BRYAN, TX METRO'
             17820 'COLORADO SPRINGS, CO METRO' 17860 'COLUMBIA, MO METRO'
             17900 'COLUMBIA, SC METRO' 17940 'COLUMBIA, TN MICRO'
             17980 'COLUMBUS, GA-AL METRO' 18020 'COLUMBUS, IN METRO'
             18060 'COLUMBUS, MS MICRO' 18100 'COLUMBUS, NE MICRO'
             18140 'COLUMBUS, OH METRO' 18180 'CONCORD, NH MICRO'
             18220 'CONNERSVILLE, IN MICRO' 18260 'COOKEVILLE, TN MICRO'
             18300 'COOS BAY, OR MICRO' 18340 'CORBIN, KY MICRO'
             18380 'CORDELE, GA MICRO' 18420 'CORINTH, MS MICRO'
             18460 'CORNELIA, GA MICRO' 18500 'CORNING, NY MICRO'
             18580 'CORPUS CHRISTI, TX METRO' 18620 'CORSICANA, TX MICRO'
             18660 'CORTLAND, NY MICRO' 18700 'CORVALLIS, OR METRO'
             18740 'COSHOCTON, OH MICRO' 18820 'CRAWSFORDSVILLE, IN MICRO'
             18860 'CRESCENT CITY NORTH, CA MICRO'
             18900 'CROSSVILLE, TN MICRO' 18940 'CROWLEY, LA MICRO'
             18980 'CULLMAN, AL MICRO' 19060 'CUMBERLAND, MD-WV METRO'
             19100 'DALLAS-FORT WORTH-ARLINGTON, TX METRO'
             19140 'DALTON, GA METRO' 19180 'DANVILLE, IL METRO'
             19220 'DANVILLE, KY MICRO' 19260 'DANVILLE, VA METRO'
             19300 'DAPHNE-FAIRHOPE, AL MICRO'
             19340 'DAVENPORT-MOLINE-ROCK ISLAND, IA-IL METRO'
             19380 'DAYTON, OH METRO' 19460 'DECATUR, AL METRO'
             19500 'DECATUR, IL METRO' 19540 'DECATUR, IN MICRO'
             19580 'DEFIANCE, OH MICRO' 19620 'DEL RIO, TX MICRO'
             19660 'DELTONA-DAYTONA BEACH-ORMOND BEACH, FL METRO'
             19700 'DEMING, NM MICRO' 19740 'DENVER-AURORA, CO METRO'
             19760 'DE RIDDER, LA MICRO' 19780 'DES MOINES, IA METRO'
             19820 'DETROIT-WARREN-LIVONIA, MI METRO'
             19860 'DICKINSON, ND MICRO' 19900 'DILLON, SC MICRO'
             19940 'DIXON, IL MICRO' 19980 'DODGE CITY, KS MICRO'
             20020 'DOTHAN, AL METRO' 20060 'DOUGLAS, GA MICRO'
             20100 'DOVER, DE METRO' 20140 'DUBLIN, GA MICRO'
             20180 'DUBOIS, PA MICRO' 20220 'DUBUQUE, IA METRO'
             20260 'DULUTH, MN-WI METRO' 20300 'DUMAS, TX MICRO'
             20340 'DUNCAN, OK MICRO' 20380 'DUNN, NC MICRO'
             20420 'DURANGO, CO MICRO' 20460 'DURANT, OK MICRO'
             20500 'DURHAM, NC METRO' 20540 'DYERSBURG, TN MICRO'
             20580 'EAGLE PASS, TX MICRO'
             20620 'EAST LIVERPOOL-SALEM, OH MICRO' 20660 'EASTON, MD MICRO'
             20700 'EAST STROUDSBURG, PA MICRO' 20740 'EAU CLAIRE, WI METRO'
             20780 'EDWARDS, CO MICRO' 20820 'EFFINGHAM, IL MICRO'
             20900 'EL CAMPO, TX MICRO' 20940 'EL CENTRO, CA METRO'
             20980 'EL DORADO, AR MICRO' 21020 'ELIZABETH CITY, NC MICRO'
             21060 'ELIZABETHTOWN, KY METRO' 21140 'ELKHART-GOSHEN, IN METRO'
             21220 'ELKO, NV MICRO' 21260 'ELLENSBURG, WA MICRO'
             21300 'ELMIRA, NY METRO' 21340 'EL PASO, TX METRO'
             21380 'EMPORIA, KS MICRO' 21420 'ENID, OK MICRO'
             21460 'ENTERPRISE-OZARK, AL MICRO' 21500 'ERIE, PA METRO'
             21540 'ESCANABA, MI MICRO' 21580 'ESPANOLA, NM MICRO'
             21660 'EUGENE-SPRINGFIELD, OR METRO'
             21700 'EUREKA-ARCATA-FORTUNA, CA MICRO'
             21780 'EVANSVILLE, IN-KY METRO' 21820 'FAIRBANKS, AK METRO'
             21860 'FAIRMONT, MN MICRO' 21900 'FAIRMONT, WV MICRO'
             21940 'FAJARDO, PR METRO' 21980 'FALLON, NV MICRO'
             22020 'FARGO, ND-MN METRO'
             22060 'FARIBAULT-NORTHFIELD, MN MICRO'
             22100 'FARMINGTON, MO MICRO' 22140 'FARMINGTON, NM METRO'
             22180 'FAYETTEVILLE, NC METRO'
             22220 'FAYETTEVILLE-SPRINGDALE-ROGERS, AR-MO METRO'
             22260 'FERGUS FALLS, MN MICRO' 22300 'FINDLAY, OH MICRO'
             22340 'FITZGERALD, GA MICRO' 22380 'FLAGSTAFF, AZ METRO'
             22420 'FLINT, MI METRO' 22460 'FLORENCE, AL METRO'
             22500 'FLORENCE, SC METRO' 22540 'FOND DU LAC, WI METRO'
             22580 'FOREST CITY, NC MICRO' 22620 'FORREST CITY, AR MICRO'
             22660 'FORT COLLINS-LOVELAND, CO METRO'
             22700 'FORT DODGE, IA MICRO' 22780 'FORT LEONARD WOOD, MO MICRO'
             22820 'FORT MORGAN, CO MICRO' 22860 'FORT POLK SOUTH, LA MICRO'
             22900 'FORT SMITH, AR-OK METRO' 22980 'FORT VALLEY, GA MICRO'
             23020 'FORT WALTON BEACH-CRESTVIEW-DESTIN, FL METRO'
             23060 'FORT WAYNE, IN METRO' 23140 'FRANKFORT, IN MICRO'
             23180 'FRANKFORT, KY MICRO' 23300 'FREEPORT, IL MICRO'
             23340 'FREMONT, NE MICRO' 23380 'FREMONT, OH MICRO'
             23420 'FRESNO, CA METRO' 23460 'GADSDEN, AL METRO'
             23500 'GAFFNEY, SC MICRO' 23540 'GAINESVILLE, FL METRO'
             23580 'GAINESVILLE, GA METRO' 23620 'GAINESVILLE, TX MICRO'
             23660 'GALESBURG, IL MICRO' 23700 'GALLUP, NM MICRO'
             23780 'GARDEN CITY, KS MICRO'
             23820 'GARDNERVILLE RANCHOS, NV MICRO'
             23860 'GEORGETOWN, SC MICRO' 23900 'GETTYSBURG, PA MICRO'
             23940 'GILLETTE, WY MICRO' 23980 'GLASGOW, KY MICRO'
             24020 'GLENS FALLS, NY METRO' 24100 'GOLVERSVILLE, NY MICRO'
             24140 'GOLDSBORO, NC METRO' 24180 'GRANBURY, TX MICRO'
             24220 'GRAND FORKS, ND-MN METRO' 24260 'GRAND ISLAND, NE MICRO'
             24300 'GRAND JUNCTION, CO METRO'
             24340 'GRAND RAPIDS-WYOMING, MI METRO' 24380 'GRANTS, NM MICRO'
             24420 'GRANTS PASS, OR MICRO' 24460 'GREAT BEND, KS MICRO'
             24500 'GREAT FALLS, MT METRO' 24540 'GREELEY, CO METRO'
             24580 'GREEN BAY, WI METRO' 24620 'GREENEVILLE, TN MICRO'
             24660 'GREENSBORO-HIGH POINT, NC METRO'
             24700 'GREENSBURG, IN MICRO' 24740 'GREENVILLE, MS MICRO'
             24780 'GREENVILLE, NC METRO' 24820 'GREENVILLE, OH MICRO'
             24860 'GREENVILLE, SC METRO' 24900 'GREENWOOD, MS MICRO'
             24940 'GREENWOOD, SC MICRO' 24980 'GRENADA, MS MICRO'
             25020 'GUAYAMA, PR METRO' 25060 'GULFPORT-BILOXI, MS METRO'
             25100 'GUYMON, OK MICRO'
             25180 'HAGERSTOWN-MARTINSBURG, MD-WV METRO'
             25220 'HAMMOND, LA MICRO' 25260 'HANFORD-CORCORAN, CA METRO'
             25300 'HANNIBAL, MO MICRO' 25340 'HARRIMAN, TN MICRO'
             25380 'HARRISBURG, IL MICRO'
             25420 'HARRISBURG-CARLISLE, PA METRO' 25460 'HARRISON, AR MICRO'
             25500 'HARRISONBURG, VA METRO'
             25540 'HARTFORD-WEST HARTFORD-EAST HARTFORD, CT METRO'
             25580 'HASTINGS, NE MICRO' 25620 'HATTIESBURG, MS METRO'
             25660 'HAVRE, MT MICRO' 25700 'HAYS, KS MICRO'
             25740 'HELENA, MT MICRO' 25780 'HENDERSON, NC MICRO'
             25820 'HEREFORD, TX MICRO'
             25860 'HICKORY-MORGANTON-LENOIR, NC METRO'
             25900 'HILO, HI MICRO'
             25940 'HILTON HEAD ISLAND-BEAUFORT, SC MICRO'
             25980 'HINESVILLE-FORT STEWART, GA METRO'
             26020 'HOBBS, NM MICRO' 26100 'HOLLAND-GRAND HAVEN, MI METRO'
             26140 'HOMOSASSA SPRINGS, FL MICRO' 26180 'HONOLULU, HI METRO'
             26220 'HOOD RIVER, OR MICRO' 26260 'HOPE, AR MICRO'
             26300 'HOT SPRINGS, AR METRO' 26340 'HOUGHTON, MI MICRO'
             26380 'HOUMA-BAYOU CANE-THIBODAUX, LA METRO'
             26420 'HOUSTON-BAYTOWN-SUGAR LAND, TX METRO'
             26460 'HUDSON, NY MICRO' 26500 'HUNTINGDON, PA MICRO'
             26540 'HUNTINGTON, IN MICRO'
             26580 'HUNTINGTON-ASHLAND, WV-KY-OH METRO'
             26620 'HUNTSVILLE, AL METRO' 26660 'HUNTSVILLE, TX MICRO'
             26700 'HURON, SD MICRO' 26740 'HUTCHINSON, KS MICRO'
             26780 'HUTCHINSON, MN MICRO' 26820 'IDAHO FALLS, ID METRO'
             26860 'INDIANA, PA MICRO' 26900 'INDIANAPOLIS, IN METRO'
             26940 'INDIANOLA, MS MICRO' 26980 'IOWA CITY, IA METRO'
             27020 'IRON MOUNTAIN, MI-WI MICRO' 27060 'ITHACA, NY METRO'
             27100 'JACKSON, MI METRO' 27140 'JACKSON, MS METRO'
             27180 'JACKSON, TN METRO' 27220 'JACKSON, WY-ID MICRO'
             27260 'JACKSONVILLE, FL METRO' 27300 'JACKSONVILLE, IL MICRO'
             27340 'JACKSONVILLE, NC METRO' 27380 'JACKSONVILLE, TX MICRO'
             27420 'JAMESTOWN, ND MICRO'
             27460 'JAMESTOWN-DUNKIRK-FREDONIA, NY MICRO'
             27500 'JANESVILLE, WI METRO' 27540 'JASPER, IN MICRO'
             27580 'JAYUYA, PR MICRO' 27620 'JEFFERSON CITY, MO METRO'
             27660 'JENNINGS, LA MICRO' 27700 'JESUP, GA MICRO'
             27740 'JOHNSON, CITYTN METRO' 27780 'JOHNSTOWN, PA METRO'
             27860 'JONESBORO, AR METRO' 27900 'JOPLIN, MO METRO'
             27940 'JUNEAU, AK MICRO' 27980 'KAHULUI-WAILUKU, HI MICRO'
             28020 'KALAMAZOO-PORTAGE, MI METRO' 28060 'KALISPELL, MT MICRO'
             28100 'KANKAKEE-BRADLEY, IL METRO'
             28140 'KANSAS CITY, MO-KS METRO' 28180 'KAPAA, HI MICRO'
             28260 'KEARNEY, NE MICRO' 28300 'KEENE, NH MICRO'
             28340 'KENDALLVILLE, IN MICRO' 28380 'KENNETT, MO MICRO'
             28420 'KENNEWICK-RICHLAND-PASCO, WA METRO'
             28460 'KEOKUK-FORT MADISON, IA-MO MICRO'
             28500 'KERRVILLE, TX MICRO' 28540 'KETCHIKAN, AK MICRO'
             28580 'KEY WEST-MARATHON, FL MICRO'
             28620 'KILL DEVIL HILLS, NC MICRO'
             28660 'KILLEEN-TEMPLE-FORT HOOD, TX METRO'
             28700 'KINGSPORT-BRISTOL, TN-VA METRO'
             28740 'KINGSTON, NY METRO' 28780 'KINGSVILLE, TX MICRO'
             28820 'KINSTON, NC MICRO' 28860 'KIRKSVILLE, MO MICRO'
             28900 'KLAMATH FALLS, OR MICRO' 28940 'KNOXVILLE, TN METRO'
             28980 'KODIAK, AK MICRO' 29020 'KOKOMO, IN METRO'
             29060 'LACONIA, NH MICRO' 29100 'LA CROSSE, WI-MN METRO'
             29140 'LAFAYETTE, IN METRO' 29180 'LAFAYETTE, LA METRO'
             29220 'LA FOLLETTE, TN MICRO' 29260 'LA GRANDE, OR MICRO'
             29300 'LAGRANGE, GA MICRO' 29340 'LAKE CHARLES, LA METRO'
             29380 'LAKE CITY, FL MICRO'
             29420 'LAKE HAVASU CITY-KINGMAN, AZ MICRO'
             29460 'LAKELAND-WINTER HAVEN, FL METRO' 29500 'LAMESA, TX MICRO'
             29540 'LANCASTER, PA METRO' 29580 'LANCASTER, SC MICRO'
             29620 'LANSING-EAST LANSING, MI METRO' 29660 'LARAMIE, WY MICRO'
             29700 'LAREDO, TX METRO' 29740 'LAS CRUCES, NM METRO'
             29780 'LAS VEGAS, NM MICRO' 29820 'LAS VEGAS-PARADISE, NV METRO'
             29860 'LAUREL, MS MICRO' 29900 'LAURINBURG, NC MICRO'
             29940 'LAWRENCE, KS METRO' 29980 'LAWRENCEBURG, TN MICRO'
             30020 'LAWTON, OK METRO' 30060 'LEBANON, MO MICRO'
             30100 'LEBANON, NH-VT MICRO' 30140 'LEBANON, PA METRO'
             30220 'LEVELLAND, TX MICRO' 30260 'LEWISBURG, PA MICRO'
             30300 'LEWISTON, ID-WA METRO' 30340 'LEWISTON-AUBURN, ME METRO'
             30380 'LEWISTON, PA MICRO' 30420 'LEXINGTON, NE MICRO'
             30460 'LEXINGTON-FAYETTE, KY METRO'
             30500 'LEXINGTON PARK, MD MICRO'
             30540 'LEXINGTON-THOMASVILLE, NC MICRO'
             30580 'LIBERAL, KS MICRO' 30620 'LIMA, OH METRO'
             30660 'LINCOLN, IL MICRO' 30700 'LINCOLN, NE METRO'
             30740 'LINCOLNTON, NC MICRO'
             30780 'LITTLE ROCK-NORTH LITTLE ROCK, AR METRO'
             30820 'LOCK HAVEN, PA MICRO' 30860 'LOGAN, UT-ID METRO'
             30900 'LOGANSPORT, IN MICRO' 30940 'LONDON, KY MICRO'
             30980 'LONGVIEW, TX METRO' 31020 'LONGVIEW-KELSO, WA METRO'
             31060 'LOS ALAMOS, NM MICRO'
             31100 'LOS ANGELES-LONG BEACH-SANTA ANA, CA METRO'
             31140 'LOUISVILLE, KY-IN METRO' 31180 'LUBBOCK, TX METRO'
             31260 'LUFKIN, TX MICRO' 31300 'LUMBERTON, NC MICRO'
             31340 'LYNCHBURG, VA METRO' 31380 'MACOMB, IL MICRO'
             31420 'MACON, GA METRO' 31460 'MADERA, CA METRO'
             31500 'MADISON, IN MICRO' 31540 'MADISON, WI METRO'
             31580 'MADISONVILLE, KY MICRO' 31620 'MAGNOLIA, AR MICRO'
             31660 'MALONE, NY MICRO' 31700 'MANCHESTER-NASHUA, NH METRO'
             31740 'MANHATTAN, KS MICRO' 31820 'MANITOWOC, WI MICRO'
             31860 'MANKATO-NORTH MANKATO, MN MICRO'
             31900 'MANSFIELD, OH METRO' 31940 'MARINETTE, WI-MI MICRO'
             31980 'MARION, IN MICRO' 32020 'MARION, OH MICRO'
             32060 'MARION-HERRIN, IL MICRO' 32100 'MARQUETTE, MI MICRO'
             32140 'MARSHALL, MN MICRO' 32180 'MARSHALL, MO MICRO'
             32220 'MARSHALL, TX MICRO' 32260 'MARSHALLTOWN, IA MICRO'
             32300 'MARTINSVILLE, VA MICRO' 32340 'MARYVILLE, MO MICRO'
             32380 'MASON CITY, IA MICRO' 32420 'MAYAGUEZ, PR METRO'
             32460 'MAYFIELD, KY MICRO' 32500 'MAYSVILLE, KY MICRO'
             32540 'MCALESTER, OK MICRO'
             32580 'MCALLEN-EDINBURG-PHARR, TX METRO'
             32620 'MCCOMB, MS MICRO' 32660 'MCMINNVILLE, TN MICRO'
             32700 'MCPHERSON, KS MICRO' 32740 'MEADVILLE, PA MICRO'
             32780 'MEDFORD, OR METRO' 32820 'MEMPHIS, TN-MS-AR METRO'
             32860 'MENOMONIE, WI MICRO' 32900 'MERCED, CA METRO'
             32940 'MERIDIAN, MS MICRO' 32980 'MERRILL, WI MICRO'
             33020 'MEXICO, MO MICRO' 33060 'MIAMI, OK MICRO'
             33100 'MIAMI-FORT LAUDERDALE-MIAMI BEACH, FL METRO'
             33140 'MICHIGAN CITY-LA PORTE, IN METRO'
             33180 'MIDDLESBOROUGH, KY MICRO' 33220 'MIDLAND, MI MICRO'
             33260 'MIDLAND, TX METRO' 33300 'MILLEDGEVILLE, GA MICRO'
             33340 'MILWAUKEE-WAUKESHA-WEST ALLIS, WI METRO'
             33380 'MINDEN, LA MICRO' 33420 'MINERAL WELLS, TX MICRO'
             33460 'MINNEAPOLIS-ST. PAUL-BLOOMINGTON, MN-WI METRO'
             33500 'MINOT, ND MICRO' 33540 'MISSOULA, MT METRO'
             33580 'MITCHELL, SD MICRO' 33620 'MOBERLY, MO MICRO'
             33660 'MOBILE, AL METRO' 33700 'MODESTO, CA METRO'
             33740 'MONROE, LA METRO' 33780 'MONROE, MI METRO'
             33820 'MONROE, WI MICRO' 33860 'MONTGOMERY, AL METRO'
             33940 'MONTROSE, CO MICRO' 33980 'MOREHEAD CITY, NC MICRO'
             34020 'MORGAN CITY, LA MICRO' 34060 'MORGANTOWN, WV METRO'
             34100 'MORRISTOWN, TN METRO' 34140 'MOSCOW, ID MICRO'
             34180 'MOSES LAKE, WA MICRO' 34220 'MOULTRIE, GA MICRO'
             34260 'MOUNTAIN HOME, AR MICRO' 34300 'MOUNTAIN HOME, ID MICRO'
             34340 'MOUNT AIRY, NC MICRO' 34380 'MOUNT PLEASANT, MI MICRO'
             34420 'MOUNT PLEASANT, TX MICRO'
             34460 'MOUNT STERLING, KY MICRO' 34500 'MOUNT VERNON, IL MICRO'
             34540 'MOUNT VERNON, OH MICRO'
             34580 'MOUNT VERNON-ANACORTES, WA METRO'
             34620 'MUNCIE, IN METRO' 34660 'MURRAY, KY MICRO'
             34700 'MUSCATINE, IA MICRO'
             34740 'MUSKEGON-NORTON SHORES, MI METRO'
             34780 'MUSKOGEE, OK MICRO'
             34820 'MYRTLE BEACH-CONWAY-NORTH MYRTLE BEACH, SC METRO'
             34860 'NACOGDOCHES, TX MICRO' 34900 'NAPA, CA METRO'
             34940 'NAPLES-MARCO ISLAND, FL METRO'
             34980 'NASHVILLE-DAVIDSON--MURFREESBORO, TN METRO'
             35020 'NATCHEZ, MS-LA MICRO' 35060 'NATCHITOCHES, LA MICRO'
             35100 'NEW BERN, NC MICRO' 35140 'NEWBERRY, SC MICRO'
             35220 'NEW CASTLE, IN MICRO' 35260 'NEW CASTLE, PA MICRO'
             35300 'NEW HAVEN-MILFORD, CT METRO' 35340 'NEW IBERIA, LA MICRO'
             35380 'NEW ORLEANS-METAIRIE-KENNER, LA METRO'
             35420 'NEW PHILADELPHIA-DOVER, OH MICRO'
             35460 'NEWPORT, TN MICRO' 35500 'NEWTON, IA MICRO'
             35580 'NEW ULM, MN MICRO'
             35620 'NEW YORK-NEWARK-EDISON, NY-NJ-PA METRO'
             35660 'NILES-BENTON HARBOR, MI METRO' 35700 'NOGALES, AZ MICRO'
             35740 'NORFOLK, NE MICRO' 35820 'NORTH PLATTE, NE MICRO'
             35860 'NORTH VERNON, IN MICRO'
             35900 'NORTH WILKESBORO, NC MICRO' 35940 'NORWALK, OH MICRO'
             35980 'NORWICH-NEW LONDON, CT METRO'
             36020 'OAK HARBOR, WA MICRO' 36060 'OAK HILL, WV MICRO'
             36100 'OCALA, FL METRO' 36140 'OCEAN CITY, NJ METRO'
             36180 'OCEAN PINES, MD MICRO' 36220 'ODESSA, TX METRO'
             36260 'OGDEN-CLEARFIELD, UT METRO'
             36300 'OGDENSBURG-MASSENA, NY MICRO' 36340 'OIL CITY, PA MICRO'
             36380 'OKEECHOBEE, FL MICRO' 36420 'OKLAHOMA CITY, OK METRO'
             36460 'OLEAN, NY MICRO' 36500 'OLYMPIA, WA METRO'
             36540 'OMAHA-COUNCIL BLUFFS, NE-IA METRO'
             36580 'ONEONTA, NY MICRO' 36620 'ONTARIO, OR-ID MICRO'
             36660 'OPELOUSAS-EUNICE, LA MICRO' 36700 'ORANGEBURG, SC MICRO'
             36740 'ORLANDO, FL METRO' 36780 'OSHKOSH-NEENAH, WI METRO'
             36820 'OSKALOOSA, IA MICRO' 36860 'OTTAWA-STREATOR, IL MICRO'
             36900 'OTTUMWA, IA MICRO' 36940 'OWATONNA, MN MICRO'
             36980 'OWENSBORO, KY METRO' 37020 'OWOSSO, MI MICRO'
             37060 'OXFORD, MS MICRO'
             37100 'OXNARD-VENTURA-THOUSAND OAKS VENTURA, CA METRO'
             37140 'PADUCAH, KY-IL MICRO' 37220 'PAHRUMP, NV MICRO'
             37260 'PALATKA, FL MICRO' 37300 'PALESTINE, TX MICRO'
             37340 'PALM BAY-MELBOURNE-TITUSVILLE, FL METRO'
             37380 'PALM COAST, FL MICRO' 37420 'PAMPA, TX MICRO'
             37460 'PANAMA CITY-LYNN HAVEN, FL METRO'
             37500 'PARAGOULD, AR MICRO' 37540 'PARIS, TN MICRO'
             37580 'PARIS, TX MICRO'
             37620 'PARKERSBURG-MARIETTA, WV-OH METRO'
             37660 'PARSONS, KS MICRO' 37700 'PASCAGOULA, MS METRO'
             37740 'PAYSON, AZ MICRO' 37780 'PECOS, TX MICRO'
             37820 'PENDLETON-HERMISTON, OR MICRO'
             37860 'PENSACOLA-FERRY PASS-BRENT, FL METRO'
             37900 'PEORIA, IL METRO' 37940 'PERU, IN MICRO'
             37980 'PHILADELPHIA-CAMDEN-WILMINGTON, PA-NJ-DE-M METRO'
             38020 'PHOENIX LAKE-CEDAR RIDGE, CA MICRO'
             38060 'PHOENIX-MESA-SCOTTSDALE, AZ METRO'
             38100 'PICAYUNE, MS MICRO' 38180 'PIERRE, SD MICRO'
             38200 'PIERRE PART, LA MICRO' 38220 'PINE BLUFF, AR METRO'
             38260 'PITTSBURG, KS MICRO' 38300 'PITTSBURGH, PA METRO'
             38340 'PITTTSFIELD, MA METRO' 38380 'PLAINVIEW, TX MICRO'
             38420 'PLATTEVILLE, WI MICRO' 38460 'PLATTSBURGH, NY MICRO'
             38500 'PLYMOUTH, IN MICRO' 38540 'POCATELLO, ID METRO'
             38580 'POINT PLEASANT, WV-OH MICRO' 38620 'PONCA CITY, OK MICRO'
             38660 'PONCE, PR METRO' 38700 'PONTIAC, IL MICRO'
             38740 'POPLAR BLUFF, MO MICRO' 38780 'PORTALES, NM MICRO'
             38820 'PORT ANGELES, WA MICRO'
             38860 'PORTLAND-SOUTH PORTLAND, ME METRO'
             38900 'PORTLAND-VANCOUVER-BEAVERTON, OR-WA METRO'
             38940 'PORT ST. LUCIE, FL METRO' 39020 'PORTSMOUTH, OH MICRO'
             39060 'POTTSVILLE, PA MICRO'
             39100 'POUGHKEEPSIE-NEWBURGH-MIDDLETOWN, NY METRO'
             39140 'PRESCOTT, AZ METRO' 39220 'PRICE, UT MICRO'
             39260 'PRINEVILLE, OR MICRO'
             39300 'PROVIDENCE-NEW BEDFORD-FALL RIVER, RI-MA METRO'
             39340 'PROVO-OREM, UT METRO' 39380 'PUEBLO, CO METRO'
             39420 'PULLMAN, WA MICRO' 39460 'PUNTA GORDA, FL METRO'
             39500 'QUINCY, MO-IL MICRO' 39540 'RACINE, WI METRO'
             39580 'RALEIGH-CARY, NC METRO' 39660 'RAPID CITY, SD METRO'
             39700 'RAYMONDVILLE, TX MICRO' 39740 'READING, PA METRO'
             39780 'RED BLUFF, CA MICRO' 39820 'REDDING, CA METRO'
             39860 'RED WING, MN MICRO' 39900 'RENO-SPARKS, NV METRO'
             39940 'REXBURG, ID MICRO' 39980 'RICHMOND, IN MICRO'
             40020 'RICHMOND, KY MICRO' 40060 'RICHMOND, VA METRO'
             40100 'RIO GRANDE CITY, TX MICRO'
             40140 'RIVERSIDE-SAN BERNARDINO-ONTARIO, CA METRO'
             40180 'RIVERTON, WY MICRO' 40220 'ROANOKE, VA METRO'
             40260 'ROANOKE RAPIDS, NC MICRO' 40300 'ROCHELLE, IL MICRO'
             40340 'ROCHESTER, MN METRO' 40380 'ROCHESTER, NY METRO'
             40420 'ROCKFORD, IL METRO' 40460 'ROCKINGHAM, NC MICRO'
             40500 'ROCKLAND, ME MICRO' 40540 'ROCK SPRINGS, WY MICRO'
             40580 'ROCKY MOUNT, NC METRO' 40620 'ROLLA, MO MICRO'
             40660 'ROME, GA METRO' 40700 'ROSEBURG, OR MICRO'
             40740 'ROSWELL, NM MICRO' 40780 'RUSSELLVILLE, AR MICRO'
             40820 'RUSTON, LA MICRO' 40860 'RUTLAND, VT MICRO'
             40900 'SACRAMENTO--ARDEN-ARCADE--ROSEVILLE, CA METRO'
             40940 'SAFFORD, AZ MICRO'
             40980 'SAGINAW-SAGINZW TOWNSHIP NORTH, MI METRO'
             41060 'SAINT CLOUD, MN METRO' 41100 'SAINT GEORGE, UT METRO'
             41140 'SAINT JOSEPH, MO-KS METRO'
             41180 'SAINT LOUIS, MO-IL METRO' 41220 'SAINT MARYS, GA MICRO'
             41260 'SAINT MARYS, PA MICRO' 41420 'SALEM, OR METRO'
             41460 'SALINA, KS MICRO' 41500 'SALINAS, CA METRO'
             41540 'SALISBURY, MD METRO' 41580 'SALISBURY, NC MICRO'
             41620 'SALT LAKE CITY, UT METRO' 41660 'SAN ANGELO, TX METRO'
             41700 'SAN ANTONIO, TX METRO'
             41740 'SAN DIEGO-CARLSBAD-SAN MARCOS, CA METRO'
             41780 'SANDUSKY, OH METRO' 41820 'SANFORD, NC MICRO'
             41860 'SAN FRANCISCO-OAKLAND-FREMONT, CA METRO'
             41900 'SAN GERMAN-CABO ROJO, PR METRO'
             41940 'SAN JOSE-SUNNYVALE-SANTA CLARA, CA METRO'
             41980 'SAN JUAN-CAGUAS-GUAYNABO, PR METRO'
             42020 'SAN LUIS OBISPO-PASO ROBLES, CA METRO'
             42060 'SANTA BARBARA-SANTA MARIA-GOLETA, CA METRO'
             42100 'SANTA CRUZ-WATSONVILLE, CA METRO'
             42140 'SANTA FE, NM METRO' 42180 'SANTA ISABEL, PR MICRO'
             42220 'SANTA ROSA, CA METRO'
             42260 'SARASOTA-BRADENTON-VENICE, FL METRO'
             42300 'SAULT SAINTE MARIE, MI MICRO' 42340 'SAVANNAH, GA METRO'
             42380 'SAYRE, PA MICRO' 42420 'SCOTTSBLUFF, NE MICRO'
             42460 'SCOTTSBORO, AL MICRO' 42500 'SCOTTSBURG, IN MICRO'
             42540 'SCRANTON--WILKES-BARRE-, PA METRO'
             42580 'SEAFORD, DE MICRO' 42620 'SEARCY, AR MICRO'
             42660 'SEATTLE-TACOMA-BELLEVUE, WA METRO'
             42700 'SEBRING, FL MICRO' 42740 'SEDALIA, MO MICRO'
             42780 'SELINSGROVE, PA MICRO' 42820 'SELMA, AL MICRO'
             42860 'SENECA, SC MICRO' 42900 'SENECA FALLS, NY MICRO'
             42940 'SEVIERVILLE, TN MICRO' 42980 'SEYMOUR, IN MICRO'
             43060 'SHAWNEE, OK MICRO' 43100 'SHEBOYGAN, WI METRO'
             43140 'SHELBY, NC MICRO' 43180 'SHELBYVILLE, TN MICRO'
             43220 'SHELTON, WA MICRO' 43260 'SHERIDAN, WY MICRO'
             43300 'SHERMAN-DENISON, TX METRO'
             43340 'SHREVEPORT-BOSSIER CITY, LA METRO'
             43380 'SIDNEY, OH MICRO' 43420 'SIERRA VISTA-DOUGLAS, AZ MICRO'
             43460 'SIKESTON, MO MICRO' 43500 'SILVER CITY, NM MICRO'
             43540 'SILVERTHORNE, CO MICRO'
             43580 'SIOUX CITY, IA-NE-SD METRO' 43620 'SIOUX FALLS, SD METRO'
             43660 'SNYDER, TX MICRO' 43700 'SOMERSET, KY MICRO'
             43740 'SOMERSET, PA MICRO'
             43780 'SOUTH BEND-MISHAWAKA, IN-MI METRO'
             43860 'SOUTHERN PINES, NC MICRO' 43900 'SPARTANBURG, SC METRO'
             43940 'SPEARFISH, SD MICRO' 43980 'SPENCER, IA MICRO'
             44020 'SPIRIT LAKE, IA MICRO' 44060 'SPOKANE, WA METRO'
             44100 'SPRINGFIELD, IL METRO' 44140 'SPRINGFIELD, MA METRO'
             44180 'SPRINGFIELD, MO METRO' 44220 'SPRINGFIELD, OH METRO'
             44260 'STARKVILLE, MS MICRO' 44300 'STATE COLLEGE, PA METRO'
             44340 'STATESBORO, GA MICRO'
             44380 'STATESVILLE-MOORESVILLE, NC MICRO'
             44420 'STAUNTON-WAYNESBORO, VA MICRO'
             44500 'STEPHENVILLE, TX MICRO' 44540 'STERLING, CO MICRO'
             44580 'STERLING, IL MICRO' 44620 'STEVENS POINT, WI MICRO'
             44660 'STILLWATER, OK MICRO' 44700 'STOCKTON, CA METRO'
             44740 'STORM LAKE, IA MICRO' 44780 'STURGIS, MI MICRO'
             44860 'SULPHUR SPRINGS, TX MICRO' 44900 'SUMMERVILLE, GA MICRO'
             44940 'SUMTER, SC METRO' 44980 'SUNBURY, PA MICRO'
             45020 'SWEETWATER, TX MICRO' 45060 'SYRACUSE, NY METRO'
             45140 'TAHLEQUAH, OK MICRO'
             45180 'TALLADEGA-SYLACAUGA, AL MICRO'
             45220 'TALLAHASSEE, FL METRO' 45260 'TALLULAH, LA MICRO'
             45300 'TAMPA-ST. PETERSBURG-CLEARWATER, FL METRO'
             45340 'TAOS, NM MICRO' 45380 'TAYLORVILLE, IL MICRO'
             45460 'TERRE HAUTE, IN METRO'
             45500 'TEXARKANA TX-TEXARKANA, AR METRO'
             45540 'THE VILLAGES, FL MICRO' 45580 'THOMASTON, GA MICRO'
             45620 'THOMASVILLE, GA MICRO' 45660 'TIFFIN-FOSTORIA, OH MICRO'
             45700 'TIFTON, GA MICRO' 45740 'TOCCOA, GA MICRO'
             45780 'TOLEDO, OH METRO' 45820 'TOPEKA, KS METRO'
             45860 'TORRINGTON, CT MICRO' 45900 'TRAVERSE CITY, MI MICRO'
             45940 'TRENTON-EWING, NJ METRO' 45980 'TROY, AL MICRO'
             46020 'TRUCKEE-GRASS VALLEY, CA MICRO' 46060 'TUCSON, AZ METRO'
             46100 'TULLAHOMA, TN MICRO' 46140 'TULSA, OK METRO'
             46180 'TUPELO, MS MICRO' 46220 'TUSCALOOSA, AL METRO'
             46260 'TUSKEGEE, AL MICRO' 46300 'TWIN FALLS, ID MICRO'
             46340 'TYLER, TX METRO' 46380 'UKIAH, CA MICRO'
             46420 'UNION, SC MICRO' 46460 'UNION CITY, TN-KY MICRO'
             46500 'URBANA, OH MICRO' 46540 'UTICA-ROME, NY METRO'
             46580 'UTUADO, PR MICRO' 46620 'UVALDE, TX MICRO'
             46660 'VALDOSTA, GA METRO' 46700 'VALLEJO-FAIRFIELD, CA METRO'
             46740 'VALLEY, AL MICRO' 46780 'VAN WERT, OH MICRO'
             46820 'VERMILLION, SD MICRO' 46860 'VERNAL, UT MICRO'
             46900 'VERNON, TX MICRO' 46940 'VERO BEACH, FL METRO'
             46980 'VICKSBURG, MS MICRO' 47020 'VICTORIA, TX METRO'
             47180 'VINCENNES, IN MICRO'
             47220 'VINELAND-MILLVILLE-BRIDGETON, NJ METRO'
             47260 'VIRGINIA BEACH-NORFOLK-NEWPORT NEWS, VA-NC METRO'
             47300 'VISALIA-PORTERVILLE, CA METRO' 47340 'WABASH, IN MICRO'
             47360 'WACO, TX METRO' 47420 'WAHPETON, ND-MN MICRO'
             47460 'WALLA WALLA, WA MICRO' 47500 'WALTERBORO, SC MICRO'
             47540 'WAPAKONETA, OH MICRO' 47580 'WARNER ROBINS, GA METRO'
             47620 'WARREN, PA MICRO' 47660 'WARRENSBURG, MO MICRO'
             47700 'WARSAW, IN MICRO' 47780 'WASHINGTON, IN MICRO'
             47820 'WASHINGTON, NC MICRO' 47860 'WASHINGTON, OH MICRO'
             47900 'WASHINGTON-ARLINGTIN-ALEXANDRIA, DC-VA-MD-W METRO'
             47940 'WATERLOO-CEDAR FALLS, IA METRO'
             47980 'WATERTOWN, SD MICRO'
             48020 'WATERTOWN-FORT ATKINSON, WI MICRO'
             48060 'WATERTOWN-FORT DRUM, NY MICRO' 48100 'WAUCHULA, FL MICRO'
             48140 'WAUSAU, WI METRO' 48180 'WAYCROSS, GA MICRO'
             48260 'WEIRTON-STEUBENVILLE, WV-OH METRO'
             48300 'WENATCHEE, WA METRO' 48340 'WEST HELENA, AR MICRO'
             48460 'WEST PLAINS, MO MICRO' 48540 'WHEELING, WV-OH METRO'
             48580 'WHITEWATER, WI MICRO' 48620 'WICHITA, KS METRO'
             48660 'WICHITA FALLS, TX METRO' 48700 'WILLIAMSPORT, PA METRO'
             48740 'WILLIMANTIC, CT MICRO' 48780 'WILLISTON, ND MICRO'
             48820 'WILLMAR, MN MICRO' 48900 'WILMINGTON, NC METRO'
             48940 'WILMINGTON, OH MICRO' 48980 'WILSON, NC MICRO'
             49020 'WINCHESTER, VA-WV METRO' 49060 'WINFIELD, KS MICRO'
             49100 'WINONA, MN MICRO' 49180 'WINSTON-SALEM, NC METRO'
             49220 'WISCONSIN RAPIDS-MARSHFIELD, WI MICRO'
             49260 'WOODWARD, OK MICRO' 49300 'WOOSTER, OH MICRO'
             49340 'WORCESTER, MA METRO' 49380 'WORTHINGTON, MN MICRO'
             49420 'YAKIMA, WA METRO' 49460 'YANKTON, SD MICRO'
             49500 'YAUCO, PR METRO' 49540 'YAZOO CITY, MS MICRO'
             49620 'YORK-HANOVER, PA METRO'
             49660 'YOUNGSTOWN-WARREN-BOARDMAN, OH-PA METRO'
             49700 'YUBA CITY-MARYSVILLE, CA METRO' 49740 'YUMA, AZ METRO'
             49780 'ZANESVILLE, OH MICRO' /
   PMSA      -9 'UNDESIGNATED AREA/MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             40 'ABILENE, TX MSA' 60 'AGUADILLA, PR MSA' 80 'AKRON, OH PMSA'
             120 'ALBANY, GA MSA' 160 'ALBANY-SCHENECTADY-TROY, NY MSA'
             200 'ALBUQUERQUE, NM MSA' 220 'ALEXANDRIA, LA MSA'
             240 'ALLENTOWN-BETHLEHEM-EASTON, PA MSA' 280 'ALTOONA, PA MSA'
             320 'AMARILLO, TX MSA' 380 'ANCHORAGE, AK MSA'
             440 'ANN ARBOR, MI PMSA' 450 'ANNISTON, AL MSA'
             460 'APPLETON-OSHKOSH-NEENAH, WI MSA' 470 'ARECIBO, PR PMSA'
             480 'ASHEVILLE, NC MSA' 500 'ATHENS, GA MSA'
             520 'ATLANTA, GA MSA' 560 'ATLANTIC-CAPE MAY, NJ PMSA'
             580 'AUBURN-OPELIKA, AL MSA' 600 'AUGUSTA-AIKEN, GA-SC MSA'
             640 'AUSTIN-SAN MARCOS, TX MSA' 680 'BAKERSFIELD, CA MSA'
             720 'BALTIMORE, MD PMSA' 733 'BANGOR, ME NECMA'
             743 'BARNSTABLE-YARMOUTH, MA NECMA' 760 'BATON ROUGE, LA MSA'
             840 'BEAUMONT-PORT ARTHUR, TX MSA' 860 'BELLINGHAM, WA MSA'
             870 'BENTON HARBOR, MI MSA' 875 'BERGEN-PASSAIC, NJ PMSA'
             880 'BILLINGS, MT MSA' 920 'BILOXI-GULFPORT-PASCAGOULA, MS MSA'
             960 'BINGHAMTON, NY MSA' 1000 'BIRMINGHAM, AL MSA'
             1010 'BISMARCK, ND MSA' 1020 'BLOOMINGTON, IN MSA'
             1040 'BLOOMINGTON-NORMAL, IL MSA' 1080 'BOISE CITY, ID MSA'
             1123 'BOSTON-WORCESTER-LAWRENCE-LOWELL-BROCKTON, MA-NH NECMA'
             1125 'BOULDER-LONGMONT, CO PMSA' 1145 'BRAZORIA, TX PMSA'
             1150 'BREMERTON, WA PMSA' 1160 'BRIDGEPORT-MILFORD, CT PMSA'
             1240 'BROWNSVILLE-HARLINGEN-SAN BENITO, TX MSA'
             1260 'BRYAN-COLLEGE STATION, TX MSA'
             1280 'BUFFALO-NIAGARA FALLS, NY MSA' 1303 'BURLINGTON, VT NECMA'
             1310 'CAGUAS, PR PMSA' 1320 'CANTON-MASSILLON, OH MSA'
             1350 'CASPER, WY MSA' 1360 'CEDAR RAPIDS, IA MSA'
             1400 'CHAMPAIGN-URBANA, IL MSA'
             1440 'CHARLESTON-NORTH CHARLESTON, SC MSA'
             1480 'CHARLESTON, WV MSA'
             1520 'CHARLOTTE-GASTONIA-ROCK HILL, NC-SC MSA'
             1540 'CHARLOTTESVILLE, VA MSA' 1560 'CHATTANOOGA, TN-GA MSA'
             1580 'CHEYENNE, WY MSA' 1600 'CHICAGO, IL PMSA'
             1620 'CHICO-PARADISE, CA MSA' 1640 'CINCINNATI, OH-KY-IN PMSA'
             1660 'CLARKSVILLE-HOPKINSVILLE, TN-KY MSA'
             1680 'CLEVELAND-LORAIN-ELYRIA, OH PMSA'
             1720 'COLORADO SPRINGS, CO MSA' 1740 'COLUMBIA, MO MSA'
             1760 'COLUMBIA, SC MSA' 1800 'COLUMBUS, GA-AL MSA'
             1840 'COLUMBUS, OH MSA' 1880 'CORPUS CHRISTI, TX MSA'
             1890 'CORVALLIS, OR MSA' 1900 'CUMBERLAND, MD-WV MSA'
             1920 'DALLAS, TX PMSA' 1930 'DANBURY, CT PMSR'
             1950 'DANVILLE, VA MSA'
             1960 'DAVENPORT-MOLINE-ROCK ISLAND, IA-IL MSA'
             2000 'DAYTON-SPRINGFIELD, OH MSA' 2020 'DAYTONA BEACH, FL MSA'
             2030 'DECATUR, AL MSA' 2040 'DECATUR, IL MSA'
             2080 'DENVER, CO PMSA' 2120 'DES MOINES, IA MSA'
             2160 'DETROIT, MI PMSA' 2180 'DOTHAN, AL MSA'
             2190 'DOVER, DE MSA' 2200 'DUBUQUE, IA MSA'
             2240 'DULUTH-SUPERIOR, MN-WI MSA'
             2281 'DUTCHESS COUNTY, NY PMSA' 2290 'EAU CLAIRE, WI MSA'
             2320 'EL PASO, TX MSA' 2330 'ELKHART-GOSHEN, IN MSA'
             2335 'ELMIRA, NY MSA' 2340 'ENID, OK MSA' 2360 'ERIE, PA MSA'
             2400 'EUGENE-SPRINGFIELD, OR MSA'
             2440 'EVANSVILLE-HENDERSON, IN-KY MSA'
             2520 'FARGO-MOORHEAD, ND-MN MSA' 2560 'FAYETTEVILLE, NC MSA'
             2580 'FAYETTEVILLE-SPRINGDALE-ROGERS, AR MSA'
             2640 'FLINT, MI PMSA' 2650 'FLORENCE, AL MSA'
             2655 'FLORENCE, SC MSA' 2670 'FORT COLLINS-LOVELAND, CO MSA'
             2680 'FORT LAUDERDALE, FL PMSA'
             2700 'FORT MYERS-CAPE CORAL, FL MSA'
             2710 'FORT PIERCE-PORT ST. LUCIE, FL MSA'
             2720 'FORT SMITH, AR-OK MSA' 2750 'FORT WALTON BEACH, FL MSA'
             2760 'FORT WAYNE, IN MSA' 2800 'FORT WORTH-ARLINGTON, TX PMSA'
             2840 'FRESNO, CA MSA' 2880 'GADSDEN, AL MSA'
             2900 'GAINESVILLE, FL MSA' 2920 'GALVESTON-TEXAS CITY, TX PMSA'
             2960 'GARY, IN PMSA' 2975 'GLENS FALLS, NY MSA'
             2980 'GOLDSBORO, NC MSA' 2985 'GRAND FORKS, ND-MN MSA'
             2995 'GRAND JUNCTION, CO MSA'
             3000 'GRAND RAPIDS-MUSKEGON-HOLLAND, MI MSA'
             3040 'GREAT FALLS, MT MSA' 3060 'GREELEY, CO PMSA'
             3080 'GREEN BAY, WI MSA'
             3120 'GREENSBORO--WINSTON-SALEM--HIGH POINT, NC MSA'
             3150 'GREENVILLE, NC MSA'
             3160 'GREENVILLE-SPARTANBURG-ANDERSON, SC MSA'
             3180 'HAGERSTOWN, MD PMSA' 3200 'HAMILTON-MIDDLETOWN, OH PMSA'
             3240 'HARRISBURG-LEBANON-CARLISLE, PA MSA'
             3280 'HARTFORD, CT PMSA' 3283 'HARTFORD, CT NECMA'
             3285 'HATTIESBURG, MS MSA' 3290 'HICKORY-MORGANTON, NC MSA'
             3320 'HONOLULU, HI MSA' 3350 'HOUMA, LA MSA'
             3360 'HOUSTON, TX PMSA' 3400 'HUNTINGTON-ASHLAND, WV-KY-OH MSA'
             3440 'HUNTSVILLE, AL MSA' 3480 'INDIANAPOLIS, IN MSA'
             3500 'IOWA CITY, IA MSA' 3520 'JACKSON, MI MSA'
             3560 'JACKSON, MS MSA' 3580 'JACKSON, TN MSA'
             3600 'JACKSONVILLE, FL MSA' 3605 'JACKSONVILLE, NC MSA'
             3610 'JAMESTOWN, NY MSA' 3620 'JANESVILLE-BELOIT, WI MSA'
             3640 'JERSEY CITY, NJ PMSA'
             3660 'JOHNSON CITY-KINGSPORT-BRISTOL, TN-VA MSA'
             3680 'JOHNSTOWN, PA MSA' 3710 'JOPLIN, MO MSA'
             3720 'KALAMAZOO-BATTLE CREEK, MI MSA' 3740 'KANKAKEE, IL PMSA'
             3760 'KANSAS CITY, MO-KS MSA' 3800 'KENOSHA, WI PMSA'
             3810 'KILLEEN-TEMPLE, TX MSA' 3840 'KNOXVILLE, TN MSA'
             3850 'KOKOMO, IN MSA' 3870 'LA CROSSE, WI-MN MSA'
             3880 'LAFAYETTE, LA MSA' 3920 'LAFAYETTE, IN MSA'
             3960 'LAKE CHARLES, LA MSA' 3980 'LAKELAND-WINTER HAVEN, FL MSA'
             4000 'LANCASTER, PA MSA' 4040 'LANSING-EAST LANSING, MI MSA'
             4080 'LAREDO, TX MSA' 4100 'LAS CRUCES, NM MSA'
             4120 'LAS VEGAS, NV-AZ MSA' 4150 'LAWRENCE, KS MSA'
             4200 'LAWTON, OK MSA' 4243 'LEWISTON-AUBURN, ME NECMA'
             4280 'LEXINGTON, KY MSA' 4320 'LIMA, OH MSA'
             4360 'LINCOLN, NE MSA'
             4400 'LITTLE ROCK-NORTH LITTLE ROCK, AR MSA'
             4420 'LONGVIEW-MARSHALL, TX MSA'
             4480 'LOS ANGELES-LONG BEACH, CA PMSA'
             4520 'LOUISVILLE, KY-IN MSA' 4600 'LUBBOCK, TX MSA'
             4640 'LYNCHBURG, VA MSA' 4680 'MACON, GA MSA'
             4720 'MADISON, WI MSA' 4800 'MANSFIELD, OH MSA'
             4840 'MAYAGUEZ, PR MSA' 4880 'MCALLEN-EDINBURG-MISSION, TX MSA'
             4890 'MEDFORD-ASHLAND, OR MSA'
             4900 'MELBOURNE-TITUSVILLE-PALM BAY, FL MSA'
             4920 'MEMPHIS, TN-AR-MS MSA' 4940 'MERCED, CA MSA'
             5000 'MIAMI, FL PMSA'
             5015 'MIDDLESEX-SOMERSET-HUNTERDON, NJ PMSA'
             5080 'MILWAUKEE-WAUKESHA, WI PMSA'
             5120 'MINNEAPOLIS-ST. PAUL, MN-WI MSA' 5140 'MISSOULA, MT MSA'
             5160 'MOBILE, AL MSA' 5170 'MODESTO, CA MSA'
             5190 'MONMOUTH-OCEAN, NJ PMSA' 5200 'MONROE, LA MSA'
             5240 'MONTGOMERY, AL MSA' 5280 'MUNCIE, IN MSA'
             5330 'MYRTLE BEACH, SC MSA' 5345 'NAPLES, FL MSA'
             5360 'NASHVILLE, TN MSA' 5380 'NASSAU-SUFFOLK, NY PMSA'
             5480 'NEW HAVEN-MERIDEN, CT MSA'
             5483 'NEW HAVEN-BRIDGEPORT-STAMFORD-WATERBURY-DANBURY, CT NECMA'
             5523 'NEW LONDON-NORWICH, CT NECMA' 5560 'NEW ORLEANS, LA MSA'
             5600 'NEW YORK, NY PMSA' 5640 'NEWARK, NJ PMSA'
             5660 'NEWBURGH, NY-PA PMSA'
             5720 'NORFOLK-VIRGINIA BEACH-NEWPORT NEWS, VA-NC MSA'
             5775 'OAKLAND, CA PMSA' 5790 'OCALA, FL MSA'
             5800 'ODESSA-MIDLAND, TX MSA' 5880 'OKLAHOMA CITY, OK MSA'
             5910 'OLYMPIA, WA PMSA' 5920 'OMAHA, NE-IA MSA'
             5945 'ORANGE COUNTY, CA PMSA' 5960 'ORLANDO, FL MSA'
             5990 'OWENSBORO, KY MSA' 6015 'PANAMA CITY, FL MSA'
             6020 'PARKERSBURG-MARIETTA, WV-OH MSA' 6080 'PENSACOLA, FL MSA'
             6120 'PEORIA-PEKIN, IL MSA' 6160 'PHILADELPHIA, PA-NJ PMSA'
             6240 'PINE BLUFF, AR MSA' 6280 'PITTSBURGH, PA MSA'
             6323 'PITTSFIELD, MA NECMA' 6340 'POCATELLO, ID MSA'
             6360 'PONCE, PR MSA' 6403 'PORTLAND, ME NECMA'
             6440 'PORTLAND-VANCOUVER, OR-WA PMSA'
             6483 'PROVIDENCE-WARWICK-PAWTUCKET, RI NECMA'
             6520 'PROVO-OREM, UT MSA' 6560 'PUEBLO, CO MSA'
             6580 'PUNTA GORDA, FL MSA' 6600 'RACINE, WI PMSA'
             6640 'RALEIGH-DURHAM-CHAPEL HILL, NC MSA'
             6660 'RAPID CITY, SD MSA' 6680 'READING, PA MSA'
             6690 'REDDING, CA MSA' 6720 'RENO, NV MSA'
             6740 'RICHLAND-KENNEWICK-PASCO, WA MSA'
             6760 'RICHMOND-PETERSBURG, VA MSA'
             6780 'RIVERSIDE-SAN BERNARDINO, CA PMSA' 6800 'ROANOKE, VA MSA'
             6820 'ROCHESTER, MN MSA' 6840 'ROCHESTER, NY MSA'
             6880 'ROCKFORD, IL MSA' 6895 'ROCKY MOUNT, NC MSA'
             6920 'SACRAMENTO, CA PMSA'
             6960 'SAGINAW-BAY CITY-MIDLAND, MI MSA' 6980 'ST. CLOUD, MN MSA'
             7000 'ST. JOSEPH, MO MSA' 7040 'ST. LOUIS, MO-IL MSA'
             7080 'SALEM, OR PMSA' 7120 'SALINAS, CA MSA'
             7160 'SALT LAKE CITY-OGDEN, UT MSA' 7200 'SAN ANGELO, TX MSA'
             7240 'SAN ANTONIO, TX MSA' 7320 'SAN DIEGO, CA MSA'
             7360 'SAN FRANCISCO, CA PMSA' 7400 'SAN JOSE, CA PMSA'
             7440 'SAN JUAN-BAYAMON, PR PMSA'
             7460 'SAN LUIS OBISPO-ATASCADERO-PASO ROBLES, CA MSA'
             7480 'SANTA BARBARA-SANTA MARIA-LOMPOC, CA MSA'
             7485 'SANTA CRUZ-WATSONVILLE, CA PMSA' 7490 'SANTA FE, NM MSA'
             7500 'SANTA ROSA, CA PMSA' 7510 'SARASOTA-BRADENTON, FL MSA'
             7520 'SAVANNAH, GA MSA'
             7560 'SCRANTON--WILKES-BARRE--HAZLETON, PA MSA'
             7600 'SEATTLE-BELLEVUE-EVERETT, WA PMSA' 7610 'SHARON, PA MSA'
             7620 'SHEBOYGAN, WI MSA' 7640 'SHERMAN-DENISON, TX MSA'
             7680 'SHREVEPORT-BOSSIER CITY, LA MSA'
             7720 'SIOUX CITY, IA-NE MSA' 7760 'SIOUX FALLS, SD MSA'
             7800 'SOUTH BEND, IN MSA' 7840 'SPOKANE, WA MSA'
             7880 'SPRINGFIELD, IL MSA' 7920 'SPRINGFIELD, MO MSA'
             8003 'SPRINGFIELD, MA NECMA' 8050 'STATE COLLEGE, PA MSA'
             8080 'STEUBENVILLE-WEIRTON, OH-WV MSA'
             8120 'STOCKTON-LODI, CA MSA' 8140 'SUMTER, SC MSA'
             8160 'SYRACUSE, NY MSA' 8200 'TACOMA, WA PMSA'
             8240 'TALLAHASSEE, FL MSA'
             8280 'TAMPA-ST. PETERSBURG-CLEARWATER, FL MSA'
             8320 'TERRE HAUTE, IN MSA'
             8360 'TEXARKANA, TX-TEXARKANA, AR MSA' 8400 'TOLEDO, OH MSA'
             8440 'TOPEKA, KS MSA' 8480 'TRENTON, NJ PMSA'
             8560 'TULSA, OK MSA' 8600 'TUSCALOOSA, AL MSA'
             8640 'TYLER, TX MSA' 8680 'UTICA-ROME, NY MSA'
             8720 'VALLEJO-FAIRFIELD-NAPA, CA PMSA' 8735 'VENTURA, CA PMSA'
             8750 'VICTORIA, TX MSA'
             8760 'VINELAND-MILLVILLE-BRIDGETON, NJ PMSA'
             8780 'VISALIA-TULARE-PORTERVILLE, CA MSA' 8800 'WACO, TX MSA'
             8840 'WASHINGTON, DC-MD-VA-WV PMSA'
             8920 'WATERLOO-CEDAR FALLS, IA MSA' 8940 'WAUSAU, WI MSA'
             8960 'WEST PALM BEACH-BOCA RATON, FL MSA'
             9000 'WHEELING, WV-OH MSA' 9040 'WICHITA, KS MSA'
             9080 'WICHITA FALLS, TX MSA' 9140 'WILLIAMSPORT, PA MSA'
             9160 'WILMINGTON-NEWARK, DE-MD PMSA' 9200 'WILMINGTON, NC MSA'
             9260 'YAKIMA, WA MSA' 9270 'YOLO, CA PMSA' 9280 'YORK, PA MSA'
             9320 'YOUNGSTOWN-WARREN, OH MSA' 9340 'YUBA CITY, CA MSA' /
   REGION    -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 0 'U.S. TERRITORIES'
             1 'NORTHEAST' 2 'MIDWEST' 3 'SOUTH' 4 'WEST' /
   DIVISION  -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 0 'U.S. TERRITORIES'
             1 'NEW ENGLAND' 2 'MIDDLE ATLANTIC' 3 'EAST NORTH CENTRAL'
             4 'WEST NORTH CENTRAL' 5 'SOUTH ATLANTIC' 6 'EAST SOUTH CENTRAL'
             7 'WEST SOUTH CENTRAL' 8 'MOUNTAIN' 9 'PACIFIC' /
   SERVSETD  -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             1 'DETOX, 24 HR, HOSPITAL INPATIENT'
             2 'DETOX, 24 HR, FREE-STANDING RESIDENTIAL'
             3 'REHAB/RES, HOSPITAL (NON-DETOX)'
             4 'REHAB/RES, SHORT TERM (30 DAYS OR FEWER)'
             5 'REHAB/RES, LONG TERM (MORE THAN 30 DAYS)'
             6 'AMBULATORY, INTENSIVE OUTPATIENT'
             7 'AMBULATORY, NON-INTENSIVE OUTPATIENT.'
             8 'AMBULATORY, DETOXIFICATION' /
   METHUSE   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'YES' 2 'NO' /
   DAYWAIT   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' /
   REASON    -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             1 'TREATMENT COMPLETED' 2 'LEFT AGAINST PROFESSIONAL ADVICE'
             3 'TERMINATED BY FACILITY'
             4 'TRANSFERRED TO ANOTHER TREATMENT PROGRAM OR FACILITY'
             5 'INCARCERATED' 6 'DEATH' 7 'OTHER' 8 'UNKNOWN' /
   LOS       -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 31 '31 TO 45 DAYS'
             32 '46 TO 60 DAYS' 33 '61 TO 90 DAYS' 34 '91 TO 120 DAYS'
             35 '121 TO 180 DAYS' 36 '181 TO 365 DAYS' 37 'MORE THAN A YEAR'
             /
   PSOURCE   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             1 'INDIVIDUAL (INCLUDES SELF-REFERRAL)'
             2 'ALCOHOL/DRUG ABUSE CARE PROVIDER'
             3 'OTHER HEALTH CARE PROVIDER' 4 'SCHOOL (EDUCATIONAL)'
             5 'EMPLOYER/EAP' 6 'OTHER COMMUNITY REFERRAL'
             7 'COURT / CRIMINAL JUSTICE REFERRAL / DUI/DWI' /
   DETCRIM   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             1 'STATE/FEDERAL COURT, OTHER COURT' 3 'PROBATION/PAROLE'
             5 'DIVERSIONARY PROGRAM' 6 'PRISON' 7 'DUI/DWI'
             8 'OTHER RECOGNIZED LEGAL ENTITY, OTHER' /
   NOPRIOR   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             0 'NO PRIOR TREATMENT EPISODES' 1 '1 PRIOR TREATMENT EPISODES'
             2 '2 PRIOR TREATMENT EPISODES' 3 '3 PRIOR TREATMENT EPISODES'
             4 '4 PRIOR TREATMENT EPISODES'
             5 '5 OR MORE PRIOR TREATMENT EPISODES' /
   SUB1      -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'NONE' 2 'ALCOHOL'
             3 'COCAINE/CRACK' 4 'MARIJUANA/HASHISH' 5 'HEROIN'
             6 'NON-PRESCRIPTION METHADONE' 7 'OTHER OPIATES AND SYNTHETICS'
             8 'PCP' 9 'OTHER HALLUCINOGENS' 10 'METHAMPHETAMINE'
             11 'OTHER AMPHETAMINES' 12 'OTHER STIMULANTS'
             13 'BENZODIAZEPINES' 14 'OTHER NON-BENZODIAZEPINE TRANQUILIZERS'
             15 'BARBITURATES'
             16 'OTHER NON-BARBITURATE SEDATIVES OR HYPNOTICS' 17 'INHALANTS'
             18 'OVER-THE-COUNTER MEDICATIONS' 20 'OTHER' /
   ROUTE1    -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'ORAL' 2 'SMOKING'
             3 'INHALATION' 4 'INJECTION (IV OR INTRAMUSCULAR)' 20 'OTHER' /
   FREQ1     -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             1 'NO USE IN THE PAST MONTH' 2 '1-3 TIMES IN THE PAST MONTH'
             3 '1-2 TIMES IN THE PAST WEEK' 4 '3-6 TIMES IN THE PAST WEEK'
             5 'DAILY' /
   FRSTUSE1  -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 '11 AND UNDER'
             2 '12-14' 3 '15-17' 4 '18-20' 5 '21-24' 6 '25-29' 7 '30-34'
             8 '35-39' 9 '40-44' 10 '45-49' 11 '50-54' 12 '55 AND OVER' /
   SUB2      -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'NONE' 2 'ALCOHOL'
             3 'COCAINE/CRACK' 4 'MARIJUANA/HASHISH' 5 'HEROIN'
             6 'NON-PRESCRIPTION METHADONE' 7 'OTHER OPIATES AND SYNTHETICS'
             8 'PCP' 9 'OTHER HALLUCINOGENS' 10 'METHAMPHETAMINE'
             11 'OTHER AMPHETAMINES' 12 'OTHER STIMULANTS'
             13 'BENZODIAZEPINES' 14 'OTHER NON-BENZODIAZEPINE TRANQUILIZERS'
             15 'BARBITURATES'
             16 'OTHER NON-BARBITURATE SEDATIVES OR HYPNOTICS' 17 'INHALANTS'
             18 'OVER-THE-COUNTER MEDICATIONS' 20 'OTHER' /
   ROUTE2    -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'ORAL' 2 'SMOKING'
             3 'INHALATION' 4 'INJECTION (IV OR INTRAMUSCULAR)' 20 'OTHER' /
   FREQ2     -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             1 'NO USE IN THE PAST MONTH' 2 '1-3 TIMES IN THE PAST MONTH'
             3 '1-2 TIMES IN THE PAST WEEK' 4 '3-6 TIMES IN THE PAST WEEK'
             5 'DAILY' /
   FRSTUSE2  -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 '11 AND UNDER'
             2 '12-14' 3 '15-17' 4 '18-20' 5 '21-24' 6 '25-29' 7 '30-34'
             8 '35-39' 9 '40-44' 10 '45-49' 11 '50-54' 12 '55 AND OVER' /
   SUB3      -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'NONE' 2 'ALCOHOL'
             3 'COCAINE/CRACK' 4 'MARIJUANA/HASHISH' 5 'HEROIN'
             6 'NON-PRESCRIPTION METHADONE' 7 'OTHER OPIATES AND SYNTHETICS'
             8 'PCP' 9 'OTHER HALLUCINOGENS' 10 'METHAMPHETAMINE'
             11 'OTHER AMPHETAMINES' 12 'OTHER STIMULANTS'
             13 'BENZODIAZEPINES' 14 'OTHER NON-BENZODIAZEPINE TRANQUILIZERS'
             15 'BARBITURATES'
             16 'OTHER NON-BARBITURATE SEDATIVES OR HYPNOTICS' 17 'INHALANTS'
             18 'OVER-THE-COUNTER MEDICATIONS' 20 'OTHER' /
   ROUTE3    -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'ORAL' 2 'SMOKING'
             3 'INHALATION' 4 'INJECTION (IV OR INTRAMUSCULAR)' 20 'OTHER' /
   FREQ3     -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             1 'NO USE IN THE PAST MONTH' 2 '1-3 TIMES IN THE PAST MONTH'
             3 '1-2 TIMES IN THE PAST WEEK' 4 '3-6 TIMES IN THE PAST WEEK'
             5 'DAILY' /
   FRSTUSE3  -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 '11 AND UNDER'
             2 '12-14' 3 '15-17' 4 '18-20' 5 '21-24' 6 '25-29' 7 '30-34'
             8 '35-39' 9 '40-44' 10 '45-49' 11 '50-54' 12 '55 AND OVER' /
   IDU       -9 'DRUGS USED; NO ROUTES REPORTED' -8 'NO SUBSTANCES REPORTED'
             0 'NO IDU REPORTED' 1 'IDU REPORTED' /
   ALCFLG    0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   COKEFLG   0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   MARFLG    0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   HERFLG    0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   METHFLG   0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   OPSYNFLG  0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   PCPFLG    0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   HALLFLG   0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   MTHAMFLG  0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   AMPHFLG   0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   STIMFLG   0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   BENZFLG   0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   TRNQFLG   0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   BARBFLG   0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   SEDHPFLG  0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   INHFLG    0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   OTCFLG    0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   OTHERFLG  0 'SUBSTANCE NOT REPORTED' 1 'SUBSTANCE REPORTED' /
   ALCDRUG   0 'NONE' 1 'ALCOHOL ONLY' 2 'OTHER DRUGS ONLY'
             3 'ALCOHOL AND OTHER DRUGS' /
   DSMCRIT   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 0 'NO DIAGNOSIS'
             1 'ALCOHOL-INDUCED DISORDER' 2 'SUBSTANCE-INDUCED DISORDER'
             3 'ALCOHOL INTOXICATION' 4 'ALCOHOL DEPENDENCE'
             5 'OPIOID DEPENDENCE' 6 'COCAINE DEPENDENCE'
             7 'CANNABIS DEPENDENCE' 8 'OTHER SUBSTANCE DEPENDENCE'
             9 'ALCOHOL ABUSE' 10 'CANNABIS ABUSE' 11 'OTHER SUBSTANCE ABUSE'
             12 'OPIOID ABUSE' 13 'COCAINE ABUSE' 14 'ANXIETY DISORDERS'
             15 'DEPRESSIVE DISORDERS'
             16 'SCHIZOPHRENIA / OTHER PSYCHOTIC DISORDERS'
             17 'BIPOLAR DISORDERS'
             18 'ATTENTION DEFICIT / DISRUPTIVE BEHAVIOR DISORDERS'
             19 'OTHER MENTAL HEALTH CONDITION' 20 'OTHER CONDITION' /
   PSYPROB   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'YES' 2 'NO' /
   HLTHINS   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID'
             1 'PRIVATE INSURANCE, BC/BS, HMO' 2 'MEDICAID'
             3 'MEDICARE, OTHER (E.G. TRICARE, CHAMPUS)' 4 'NONE' /
   PRIMPAY   -9 'MISSING/UNKNOWN/NOT COLLECTED/INVALID' 1 'SELF-PAY'
             2 'BLUE CROSS/BLUE SHIELD, OTHER HEALTH INSURANCE COMPANIES'
             3 'MEDICARE, WORKER''S COMPENSATION' 4 'MEDICAID'
             5 'OTHER GOVERNMENT PAYMENTS'
             8 'NO CHARGE (FREE, CHARITY, SPECIAL RESEARCH, TEACHING)'
             9 'OTHER' /
   .

* SPSS MISSING VALUES COMMAND.

* MISSING VALUES
     DISYR (-9) /
     GENDER (-9) /
     RACE (-9) /
     ETHNIC (-9) /
     MARSTAT (-9) /
     EDUC (-9) /
     EMPLOY (-9) /
     DETNLF (-9) /
     PREG (-9) /
     VET (-9) /
     LIVARAG (-9) /
     PRIMINC (-9) /
     ARRESTS (-9) /
     STFIPS (-9) /
     CBSA (-9) /
     PMSA (-9) /
     REGION (-9) /
     DIVISION (-9) /
     SERVSETD (-9) /
     METHUSE (-9) /
     DAYWAIT (-9) /
     REASON (-9) /
     LOS (-9) /
     PSOURCE (-9) /
     DETCRIM (-9) /
     NOPRIOR (-9) /
     SUB1 (-9) /
     ROUTE1 (-9) /
     FREQ1 (-9) /
     FRSTUSE1 (-9) /
     SUB2 (-9) /
     ROUTE2 (-9) /
     FREQ2 (-9) /
     FRSTUSE2 (-9) /
     SUB3 (-9) /
     ROUTE3 (-9) /
     FREQ3 (-9) /
     FRSTUSE3 (-9) /
     IDU (low thru -8) /
     ALCDRUG (low thru -9) /
     DSMCRIT (-9) /
     PSYPROB (-9) /
     HLTHINS (-9) /
     PRIMPAY (-9) /
   .

EXECUTE.

* Create SPSS system file.

*SAVE OUTFILE="spss-filename.sav".
