/*-------------------------------------------------------------------------
 |                                                                         
 |                    SAS SETUP FILE FOR 
 |        TREATMENT EPISODE DATA SET -- ADMISSIONS (TEDS-A) - 2013
 |
 | This SAS program is provided for optional use with the SAS transport
 | version of this data file as distributed. The metadata
 | provided below are not stored in the SAS transport version of this data
 | collection.  Users need to use SAS PROC CIMPORT to import the SAS
 | transport file to a SAS data set on their system. This program can
 | then be used in conjunction with the SAS system data file.
 |
 | DATA:  begins a SAS data step and names an output SAS data set. Users
 | should replace 'SAS-dataset' with their name for the SAS data set copied
 | from the SAS transport file. Users can add a SAS libname statement
 | and an output SAS data set name to make a permanent SAS data set.
 |
 | MISSING VALUE RECODES:  sets user-defined numeric missing values to
 | missing as interpreted by the SAS system. Only variables with
 | user-defined missing values are included in this section.
 |
 | If any variables have more than one missing value, they are assigned
 | to the standard missing value of a single period (.) in the statement
 | below. To maintain the original meaning of missing codes, users may want
 | to take advantage of the SAS missing values (the letters A-Z or an
 | underscore preceded by a period).
 |
 | An example of a standard missing value recode:
 |
 |   IF (RELATION = 98 OR RELATION = 99) THEN RELATION = .;
 |
 | The same example using special missing value recodes:
 |
 |    IF RELATION = 98 THEN RELATION = .A;
 |    IF RELATION = 99 THEN RELATION = .B;
 |
 | NOTE:  Users should modify this file to suit their specific needs.
 | The MISSING VALUE RECODES section has been commented out (i.e., '/*').
 | To make this section active in the program, users should remove the SAS
 | comment indicators from this section.
 |
 |------------------------------------------------------------------------*/

* SAS DATA STEP;
DATA;
SET SAS-dataset ;

* USER-DEFINED MISSING VALUES RECODE TO SAS SYSMIS;

/*
    IF (ADMYR  <= -9) THEN ADMYR  = .;
    IF (CASEID  <= -9) THEN CASEID  = .;
    IF (STFIPS  <= -9) THEN STFIPS  = .;
    IF (CBSA2010  <= -9) THEN CBSA2010  = .;
    IF (EDUC  <= -9) THEN EDUC  = .;
    IF (MARSTAT  <= -9) THEN MARSTAT  = .;
    IF (SERVICES  <= -9) THEN SERVICES  = .;
    IF (DETCRIM  <= -9) THEN DETCRIM  = .;
    IF (NOPRIOR  <= -9) THEN NOPRIOR  = .;
    IF (PSOURCE  <= -9) THEN PSOURCE  = .;
    IF (ARRESTS  <= -9) THEN ARRESTS  = .;
    IF (EMPLOY  <= -9) THEN EMPLOY  = .;
    IF (METHUSE  <= -9) THEN METHUSE  = .;
    IF (PSYPROB  <= -9) THEN PSYPROB  = .;
    IF (PREG  <= -9) THEN PREG  = .;
    IF (GENDER  <= -9) THEN GENDER  = .;
    IF (VET  <= -9) THEN VET  = .;
    IF (LIVARAG  <= -9) THEN LIVARAG  = .;
    IF (DAYWAIT  <= -9) THEN DAYWAIT  = .;
    IF (DSMCRIT  <= -9) THEN DSMCRIT  = .;
    IF (AGE  <= -9) THEN AGE  = .;
    IF (RACE  <= -9) THEN RACE  = .;
    IF (ETHNIC  <= -9) THEN ETHNIC  = .;
    IF (DETNLF  <= -9) THEN DETNLF  = .;
    IF (PRIMINC  <= -9) THEN PRIMINC  = .;
    IF (SUB1  <= -9) THEN SUB1  = .;
    IF (SUB2  <= -9) THEN SUB2  = .;
    IF (SUB3  <= -9) THEN SUB3  = .;
    IF (ROUTE1  <= -9) THEN ROUTE1  = .;
    IF (ROUTE2  <= -9) THEN ROUTE2  = .;
    IF (ROUTE3  <= -9) THEN ROUTE3  = .;
    IF (FREQ1  <= -9) THEN FREQ1  = .;
    IF (FREQ2  <= -9) THEN FREQ2  = .;
    IF (FREQ3  <= -9) THEN FREQ3  = .;
    IF (FRSTUSE1  <= -9) THEN FRSTUSE1  = .;
    IF (FRSTUSE2  <= -9) THEN FRSTUSE2  = .;
    IF (FRSTUSE3  <= -9) THEN FRSTUSE3  = .;
    IF (HLTHINS  <= -9) THEN HLTHINS  = .;
    IF (PRIMPAY  <= -9) THEN PRIMPAY  = .;
    IF (FREQ_ATND_SELF_HELP  <= -9) THEN FREQ_ATND_SELF_HELP  = .;
    IF (ALCFLG  <= -9) THEN ALCFLG  = .;
    IF (COKEFLG  <= -9) THEN COKEFLG  = .;
    IF (MARFLG  <= -9) THEN MARFLG  = .;
    IF (HERFLG  <= -9) THEN HERFLG  = .;
    IF (METHFLG  <= -9) THEN METHFLG  = .;
    IF (OPSYNFLG  <= -9) THEN OPSYNFLG  = .;
    IF (PCPFLG  <= -9) THEN PCPFLG  = .;
    IF (HALLFLG  <= -9) THEN HALLFLG  = .;
    IF (MTHAMFLG  <= -9) THEN MTHAMFLG  = .;
    IF (AMPHFLG  <= -9) THEN AMPHFLG  = .;
    IF (STIMFLG  <= -9) THEN STIMFLG  = .;
    IF (BENZFLG  <= -9) THEN BENZFLG  = .;
    IF (TRNQFLG  <= -9) THEN TRNQFLG  = .;
    IF (BARBFLG  <= -9) THEN BARBFLG  = .;
    IF (SEDHPFLG  <= -9) THEN SEDHPFLG  = .;
    IF (INHFLG  <= -9) THEN INHFLG  = .;
    IF (OTCFLG  <= -9) THEN OTCFLG  = .;
    IF (OTHERFLG  <= -9) THEN OTHERFLG  = .;
    IF (DIVISION  <= -9) THEN DIVISION  = .;
    IF (REGION  <= -9) THEN REGION  = .;
    IF (IDU  <= -9) THEN IDU  = .;
    IF (ALCDRUG  <= -9) THEN ALCDRUG  = .;
*/

RUN;
