/*-------------------------------------------------------------------------
 |                                                                         
 |                    SAS SUPPLEMENTAL SYNTAX FILE FOR 
 |              NATIONAL SURVEY ON DRUG USE AND HEALTH, 2016
 |                        (DATASET: puf2016_022818)
 |
 | This SAS program is provided for optional use with the SAS transport
 | version of this data file. The metadata
 | provided below are not stored in the SAS transport version of this data
 | collection.  Users need to use SAS PROC CIMPORT to import the SAS
 | transport file to a SAS data set on their system. This program can
 | then be used in conjunction with the SAS system data file.
 |
 | DATA:  begins a SAS data step and names an output SAS data set. Users
 | should replace "SAS-dataset" with their name for the SAS data set copied
 | from the SAS transport file. Users can add a SAS libname statement
 | and an output SAS data set name to make a permanent SAS data set.
 |
 | MISSING VALUE RECODES:  sets user-defined numeric missing values to
 | missing as interpreted by the SAS system. Only variables with
 | user-defined missing values are included in this section.
 |
 | If any variables have more than one missing value, they are assigned
 | to the standard missing value of a single period (.) in the statement
 | below. To maintain the original meaning of missing codes, users may want
 | to take advantage of the SAS missing values (the letters A-Z or an
 | underscore preceded by a period).
 |
 | An example of a standard missing value recode:
 |
 |   IF (RELATION = 98 OR RELATION = 99) THEN RELATION = .;
 |
 | The same example using special missing value recodes:
 |
 |    IF RELATION = 98 THEN RELATION = .A;
 |    IF RELATION = 99 THEN RELATION = .B;
 |
 | NOTE:  Users should modify this file to suit their specific needs.
 | The MISSING VALUE RECODES section has been commented out (i.e., '/*').
 | To make this section active in the program, users should remove the SAS
 | comment indicators from this section.
 |
 |------------------------------------------------------------------------*/

RUN;

* SAS DATA STEP;
DATA;
SET SAS-dataset ;


* USER-DEFINED MISSING VALUES RECODE TO SAS SYSMIS;

/*
 IF (AALTMDE  >= . ) THEN AALTMDE  = .;
 IF (ABUPOSHAL  >= . ) THEN ABUPOSHAL  = .;
 IF (ABUPOSINH  >= . ) THEN ABUPOSINH  = .;
 IF (ABUPOSMTH  >= . ) THEN ABUPOSMTH  = .;
 IF (ABUPOSPNR  >= . ) THEN ABUPOSPNR  = .;
 IF (ABUPOSSED  >= . ) THEN ABUPOSSED  = .;
 IF (ABUPOSSTM  >= . ) THEN ABUPOSSTM  = .;
 IF (ABUPOSTRQ  >= . ) THEN ABUPOSTRQ  = .;
 IF (ACOUNMDE  >= . ) THEN ACOUNMDE  = .;
 IF (ACTD2001  >= 85 ) THEN ACTD2001  = .;
 IF (ACTD7590  >= 85 ) THEN ACTD7590  = .;
 IF (ACTD9001  >= 85 ) THEN ACTD9001  = .;
 IF (ACTDEVER  >= 85 ) THEN ACTDEVER  = .;
 IF (ACTDPRIV  >= 85 ) THEN ACTDPRIV  = .;
 IF (ACTDVIET  >= 85 ) THEN ACTDVIET  = .;
 IF (ADCOUNS  >= 94 ) THEN ADCOUNS  = .;
 IF (ADDPDISC  >= 85 ) THEN ADDPDISC  = .;
 IF (ADDPLSIN  >= 85 ) THEN ADDPLSIN  = .;
 IF (ADDPPROB  >= 94 ) THEN ADDPPROB  = .;
 IF (ADDPR2WK  >= 85 ) THEN ADDPR2WK  = .;
 IF (ADDPREV  >= 85 ) THEN ADDPREV  = .;
 IF (ADDSCEV  >= 89 ) THEN ADDSCEV  = .;
 IF (ADDSLSIN  >= 94 ) THEN ADDSLSIN  = .;
 IF (ADFAMDOC  >= 85 ) THEN ADFAMDOC  = .;
 IF (ADHERBAL  >= 94 ) THEN ADHERBAL  = .;
 IF (ADLOSEV  >= 89 ) THEN ADLOSEV  = .;
 IF (ADLSI2WK  >= 94 ) THEN ADLSI2WK  = .;
 IF (ADNURSE  >= 94 ) THEN ADNURSE  = .;
 IF (ADOCMDE  >= . ) THEN ADOCMDE  = .;
 IF (ADOTHDOC  >= 94 ) THEN ADOTHDOC  = .;
 IF (ADOTHHLP  >= 94 ) THEN ADOTHHLP  = .;
 IF (ADOTHMHP  >= 94 ) THEN ADOTHMHP  = .;
 IF (ADPB2WK  >= 85 ) THEN ADPB2WK  = .;
 IF (ADPBAGE  >= 985 ) THEN ADPBAGE  = .;
 IF (ADPBDLYA  >= 94 ) THEN ADPBDLYA  = .;
 IF (ADPBINTF  >= 94 ) THEN ADPBINTF  = .;
 IF (ADPBNUM  >= 9994 ) THEN ADPBNUM  = .;
 IF (ADPBRMBR  >= 94 ) THEN ADPBRMBR  = .;
 IF (ADPSDAYS  >= 985 ) THEN ADPSDAYS  = .;
 IF (ADPSHMGT  >= 85 ) THEN ADPSHMGT  = .;
 IF (ADPSRELS  >= 85 ) THEN ADPSRELS  = .;
 IF (ADPSSOC  >= 85 ) THEN ADPSSOC  = .;
 IF (ADPSWORK  >= 85 ) THEN ADPSWORK  = .;
 IF (ADPSYCH  >= 94 ) THEN ADPSYCH  = .;
 IF (ADPSYMD  >= 94 ) THEN ADPSYMD  = .;
 IF (ADRELIG  >= 94 ) THEN ADRELIG  = .;
 IF (ADRX12MO  >= 85 ) THEN ADRX12MO  = .;
 IF (ADRXHLP  >= 85 ) THEN ADRXHLP  = .;
 IF (ADRXNOW  >= 97 ) THEN ADRXNOW  = .;
 IF (ADSEEDOC  >= 85 ) THEN ADSEEDOC  = .;
 IF (ADSMMDEA  >= 94 ) THEN ADSMMDEA  = .;
 IF (ADSOCWRK  >= 94 ) THEN ADSOCWRK  = .;
 IF (ADTMTHLP  >= 85 ) THEN ADTMTHLP  = .;
 IF (ADTMTNOW  >= 94 ) THEN ADTMTNOW  = .;
 IF (ADWRAGE  >= 985 ) THEN ADWRAGE  = .;
 IF (ADWRCHR  >= 94 ) THEN ADWRCHR  = .;
 IF (ADWRCONC  >= 94 ) THEN ADWRCONC  = .;
 IF (ADWRDBTR  >= 94 ) THEN ADWRDBTR  = .;
 IF (ADWRDCSN  >= 94 ) THEN ADWRDCSN  = .;
 IF (ADWRDEPR  >= 94 ) THEN ADWRDEPR  = .;
 IF (ADWRDIET  >= 94 ) THEN ADWRDIET  = .;
 IF (ADWRDISC  >= 94 ) THEN ADWRDISC  = .;
 IF (ADWRDLOT  >= 94 ) THEN ADWRDLOT  = .;
 IF (ADWRDST  >= 94 ) THEN ADWRDST  = .;
 IF (ADWRELES  >= 94 ) THEN ADWRELES  = .;
 IF (ADWREMOR  >= 94 ) THEN ADWREMOR  = .;
 IF (ADWRENRG  >= 94 ) THEN ADWRENRG  = .;
 IF (ADWRGAIN  >= 94 ) THEN ADWRGAIN  = .;
 IF (ADWRGNL2  >= 994 ) THEN ADWRGNL2  = .;
 IF (ADWRGROW  >= 94 ) THEN ADWRGROW  = .;
 IF (ADWRHRS  >= 85 ) THEN ADWRHRS  = .;
 IF (ADWRIMP  >= 94 ) THEN ADWRIMP  = .;
 IF (ADWRJINO  >= 94 ) THEN ADWRJINO  = .;
 IF (ADWRJITT  >= 94 ) THEN ADWRJITT  = .;
 IF (ADWRLOSE  >= 94 ) THEN ADWRLOSE  = .;
 IF (ADWRLSIN  >= 94 ) THEN ADWRLSIN  = .;
 IF (ADWRLSL2  >= 994 ) THEN ADWRLSL2  = .;
 IF (ADWRNOGD  >= 94 ) THEN ADWRNOGD  = .;
 IF (ADWRPLSR  >= 94 ) THEN ADWRPLSR  = .;
 IF (ADWRPREG  >= 98 ) THEN ADWRPREG  = .;
 IF (ADWRPROB  >= 94 ) THEN ADWRPROB  = .;
 IF (ADWRSATP  >= 94 ) THEN ADWRSATP  = .;
 IF (ADWRSLEP  >= 94 ) THEN ADWRSLEP  = .;
 IF (ADWRSLNO  >= 94 ) THEN ADWRSLNO  = .;
 IF (ADWRSLOW  >= 94 ) THEN ADWRSLOW  = .;
 IF (ADWRSMOR  >= 94 ) THEN ADWRSMOR  = .;
 IF (ADWRSPLN  >= 94 ) THEN ADWRSPLN  = .;
 IF (ADWRSTHK  >= 94 ) THEN ADWRSTHK  = .;
 IF (ADWRTHOT  >= 94 ) THEN ADWRTHOT  = .;
 IF (ADWRWRTH  >= 94 ) THEN ADWRWRTH  = .;
 IF (AD_MDEA1  >= 94 ) THEN AD_MDEA1  = .;
 IF (AD_MDEA2  >= 94 ) THEN AD_MDEA2  = .;
 IF (AD_MDEA3  >= 94 ) THEN AD_MDEA3  = .;
 IF (AD_MDEA4  >= 94 ) THEN AD_MDEA4  = .;
 IF (AD_MDEA5  >= 94 ) THEN AD_MDEA5  = .;
 IF (AD_MDEA6  >= 94 ) THEN AD_MDEA6  = .;
 IF (AD_MDEA7  >= 94 ) THEN AD_MDEA7  = .;
 IF (AD_MDEA8  >= 94 ) THEN AD_MDEA8  = .;
 IF (AD_MDEA9  >= 94 ) THEN AD_MDEA9  = .;
 IF (AHBCHMDE  >= . ) THEN AHBCHMDE  = .;
 IF (AHLTMDE  >= . ) THEN AHLTMDE  = .;
 IF (AIRDUSTER  >= 85 ) THEN AIRDUSTER  = .;
 IF (AL30EST  >= 85 ) THEN AL30EST  = .;
 IF (ALBSTWAY  >= 85 ) THEN ALBSTWAY  = .;
 IF (ALCAGLST  >= 985 ) THEN ALCAGLST  = .;
 IF (ALCBNG30D  >= 85 ) THEN ALCBNG30D  = .;
 IF (ALCCUT1X  >= 83 ) THEN ALCCUT1X  = .;
 IF (ALCCUTDN  >= 83 ) THEN ALCCUTDN  = .;
 IF (ALCCUTEV  >= 83 ) THEN ALCCUTEV  = .;
 IF (ALCDAYS  >= 85 ) THEN ALCDAYS  = .;
 IF (ALCEMCTD  >= 83 ) THEN ALCEMCTD  = .;
 IF (ALCEMOPB  >= 83 ) THEN ALCEMOPB  = .;
 IF (ALCEVER  >= 94 ) THEN ALCEVER  = .;
 IF (ALCFMCTD  >= 83 ) THEN ALCFMCTD  = .;
 IF (ALCFMFPB  >= 83 ) THEN ALCFMFPB  = .;
 IF (ALCGTOVR  >= 83 ) THEN ALCGTOVR  = .;
 IF (ALCKPLMT  >= 83 ) THEN ALCKPLMT  = .;
 IF (ALCLAWTR  >= 83 ) THEN ALCLAWTR  = .;
 IF (ALCLIMIT  >= 83 ) THEN ALCLIMIT  = .;
 IF (ALCLOTTM  >= 83 ) THEN ALCLOTTM  = .;
 IF (ALCLSACT  >= 83 ) THEN ALCLSACT  = .;
 IF (ALCLSEFX  >= 83 ) THEN ALCLSEFX  = .;
 IF (ALCMFU  >= 85 ) THEN ALCMFU  = .;
 IF (ALCMLU  >= 85 ) THEN ALCMLU  = .;
 IF (ALCNDMOR  >= 83 ) THEN ALCNDMOR  = .;
 IF (ALCNUMDKPM  >= . ) THEN ALCNUMDKPM  = .;
 IF (ALCPDANG  >= 83 ) THEN ALCPDANG  = .;
 IF (ALCPHCTD  >= 83 ) THEN ALCPHCTD  = .;
 IF (ALCPHLPB  >= 83 ) THEN ALCPHLPB  = .;
 IF (ALCREC  >= 91 ) THEN ALCREC  = .;
 IF (ALCSERPB  >= 83 ) THEN ALCSERPB  = .;
 IF (ALCTRY  >= 985 ) THEN ALCTRY  = .;
 IF (ALCUS30D  >= 985 ) THEN ALCUS30D  = .;
 IF (ALCWD2SX  >= 83 ) THEN ALCWD2SX  = .;
 IF (ALCWDSMT  >= 83 ) THEN ALCWDSMT  = .;
 IF (ALCYFU  >= 9985 ) THEN ALCYFU  = .;
 IF (ALCYLU  >= 9985 ) THEN ALCYLU  = .;
 IF (ALCYRBFR  >= 85 ) THEN ALCYRBFR  = .;
 IF (ALCYRTOT  >= 985 ) THEN ALCYRTOT  = .;
 IF (ALDAYPMO  >= 85 ) THEN ALDAYPMO  = .;
 IF (ALDAYPWK  >= 85 ) THEN ALDAYPWK  = .;
 IF (ALDAYPYR  >= 985 ) THEN ALDAYPYR  = .;
 IF (ALDYSFG  >= 98 ) THEN ALDYSFG  = .;
 IF (ALFQFLG  >= 98 ) THEN ALFQFLG  = .;
 IF (ALTOTFG  >= 98 ) THEN ALTOTFG  = .;
 IF (AMDEHARX  >= . ) THEN AMDEHARX  = .;
 IF (AMDEHPO  >= . ) THEN AMDEHPO  = .;
 IF (AMDEHPRX  >= . ) THEN AMDEHPRX  = .;
 IF (AMDEIMP  >= . ) THEN AMDEIMP  = .;
 IF (AMDELT  >= . ) THEN AMDELT  = .;
 IF (AMDERXO2  >= . ) THEN AMDERXO2  = .;
 IF (AMDETXRX  >= . ) THEN AMDETXRX  = .;
 IF (AMDEY2_U  >= . ) THEN AMDEY2_U  = .;
 IF (AMDEYR  >= . ) THEN AMDEYR  = .;
 IF (AMHINP2  >= . ) THEN AMHINP2  = .;
 IF (AMHOUTP3  >= . ) THEN AMHOUTP3  = .;
 IF (AMHRX2  >= . ) THEN AMHRX2  = .;
 IF (AMHSVNO  >= . ) THEN AMHSVNO  = .;
 IF (AMHSVTYP  >= . ) THEN AMHSVTYP  = .;
 IF (AMHTXAND  >= . ) THEN AMHTXAND  = .;
 IF (AMHTXND2  >= . ) THEN AMHTXND2  = .;
 IF (AMHTXRC3  >= . ) THEN AMHTXRC3  = .;
 IF (AMISUDPY  >= . ) THEN AMISUDPY  = .;
 IF (AMIYR_U  >= . ) THEN AMIYR_U  = .;
 IF (AMYLNIT  >= 85 ) THEN AMYLNIT  = .;
 IF (ANURSMDE  >= . ) THEN ANURSMDE  = .;
 IF (ANYEDUC3  >= . ) THEN ANYEDUC3  = .;
 IF (ANYHLTI2  >= 94 ) THEN ANYHLTI2  = .;
 IF (ANYMHED2  >= . ) THEN ANYMHED2  = .;
 IF (ANYMHIN2  >= . ) THEN ANYMHIN2  = .;
 IF (ANYMHOUT  >= . ) THEN ANYMHOUT  = .;
 IF (ANYNDLREC  >= 81 ) THEN ANYNDLREC  = .;
 IF (ANYNSMH  >= . ) THEN ANYNSMH  = .;
 IF (ANYSEDMF  >= . ) THEN ANYSEDMF  = .;
 IF (ANYSMH2  >= . ) THEN ANYSMH2  = .;
 IF (AOMDMDE  >= . ) THEN AOMDMDE  = .;
 IF (AOMHMDE  >= . ) THEN AOMHMDE  = .;
 IF (AOTHMDE  >= . ) THEN AOTHMDE  = .;
 IF (APPDRGMON  >= 85 ) THEN APPDRGMON  = .;
 IF (APPDRGMON2  >= . ) THEN APPDRGMON2  = .;
 IF (APSY1MDE  >= . ) THEN APSY1MDE  = .;
 IF (APSY2MDE  >= . ) THEN APSY2MDE  = .;
 IF (ARELMDE  >= . ) THEN ARELMDE  = .;
 IF (ARGUPAR  >= . ) THEN ARGUPAR  = .;
 IF (ARXMDEYR  >= . ) THEN ARXMDEYR  = .;
 IF (ASDSHOM2  >= . ) THEN ASDSHOM2  = .;
 IF (ASDSOVL2  >= . ) THEN ASDSOVL2  = .;
 IF (ASDSREL2  >= . ) THEN ASDSREL2  = .;
 IF (ASDSSOC2  >= . ) THEN ASDSSOC2  = .;
 IF (ASDSWRK2  >= . ) THEN ASDSWRK2  = .;
 IF (ASOCMDE  >= . ) THEN ASOCMDE  = .;
 IF (ASTHMAAGE  >= 985 ) THEN ASTHMAAGE  = .;
 IF (ASTHMAEVR  >= 85 ) THEN ASTHMAEVR  = .;
 IF (ASTHMANOW  >= 85 ) THEN ASTHMANOW  = .;
 IF (ATXMDEYR  >= . ) THEN ATXMDEYR  = .;
 IF (AUALACUP  >= 85 ) THEN AUALACUP  = .;
 IF (AUALCHIR  >= 94 ) THEN AUALCHIR  = .;
 IF (AUALHERB  >= 94 ) THEN AUALHERB  = .;
 IF (AUALHLIN  >= 94 ) THEN AUALHLIN  = .;
 IF (AUALINET  >= 94 ) THEN AUALINET  = .;
 IF (AUALMASG  >= 94 ) THEN AUALMASG  = .;
 IF (AUALOTH  >= 94 ) THEN AUALOTH  = .;
 IF (AUALOTS2  >= 85 ) THEN AUALOTS2  = .;
 IF (AUALRELG  >= 94 ) THEN AUALRELG  = .;
 IF (AUALSGRP  >= 94 ) THEN AUALSGRP  = .;
 IF (AUALTYR  >= 85 ) THEN AUALTYR  = .;
 IF (AUINAHSP  >= 94 ) THEN AUINAHSP  = .;
 IF (AUINMEDU  >= 94 ) THEN AUINMEDU  = .;
 IF (AUINPGEN  >= 94 ) THEN AUINPGEN  = .;
 IF (AUINPSYH  >= 85 ) THEN AUINPSYH  = .;
 IF (AUINPYR  >= 85 ) THEN AUINPYR  = .;
 IF (AUINRESD  >= 94 ) THEN AUINRESD  = .;
 IF (AUINSFAC  >= 94 ) THEN AUINSFAC  = .;
 IF (AUMOTVYR  >= 85 ) THEN AUMOTVYR  = .;
 IF (AUNMAHS2  >= 994 ) THEN AUNMAHS2  = .;
 IF (AUNMCLN2  >= 994 ) THEN AUNMCLN2  = .;
 IF (AUNMDOC2  >= 994 ) THEN AUNMDOC2  = .;
 IF (AUNMDTM2  >= 994 ) THEN AUNMDTM2  = .;
 IF (AUNMMED2  >= 994 ) THEN AUNMMED2  = .;
 IF (AUNMMEN2  >= 985 ) THEN AUNMMEN2  = .;
 IF (AUNMOTO2  >= 994 ) THEN AUNMOTO2  = .;
 IF (AUNMPGE2  >= 994 ) THEN AUNMPGE2  = .;
 IF (AUNMPSY2  >= 985 ) THEN AUNMPSY2  = .;
 IF (AUNMRES2  >= 997 ) THEN AUNMRES2  = .;
 IF (AUNMSFA2  >= 994 ) THEN AUNMSFA2  = .;
 IF (AUNMTHE2  >= 985 ) THEN AUNMTHE2  = .;
 IF (AUOPCLNC  >= 94 ) THEN AUOPCLNC  = .;
 IF (AUOPDOC  >= 94 ) THEN AUOPDOC  = .;
 IF (AUOPDTMT  >= 94 ) THEN AUOPDTMT  = .;
 IF (AUOPMENT  >= 85 ) THEN AUOPMENT  = .;
 IF (AUOPOTOP  >= 94 ) THEN AUOPOTOP  = .;
 IF (AUOPTHER  >= 85 ) THEN AUOPTHER  = .;
 IF (AUOPTYR  >= 85 ) THEN AUOPTYR  = .;
 IF (AUOPYRS2  >= 85 ) THEN AUOPYRS2  = .;
 IF (AUPINEMP  >= 94 ) THEN AUPINEMP  = .;
 IF (AUPINFM2  >= 85 ) THEN AUPINFM2  = .;
 IF (AUPINFRE  >= 94 ) THEN AUPINFRE  = .;
 IF (AUPINMCD  >= 94 ) THEN AUPINMCD  = .;
 IF (AUPINMCR  >= 94 ) THEN AUPINMCR  = .;
 IF (AUPINMIL  >= 94 ) THEN AUPINMIL  = .;
 IF (AUPINOFM  >= 94 ) THEN AUPINOFM  = .;
 IF (AUPINPHI  >= 94 ) THEN AUPINPHI  = .;
 IF (AUPINPRV  >= 94 ) THEN AUPINPRV  = .;
 IF (AUPINPUB  >= 94 ) THEN AUPINPUB  = .;
 IF (AUPINREH  >= 94 ) THEN AUPINREH  = .;
 IF (AUPINSLF  >= 85 ) THEN AUPINSLF  = .;
 IF (AUPOPAMT  >= 85 ) THEN AUPOPAMT  = .;
 IF (AUPOPEMP  >= 94 ) THEN AUPOPEMP  = .;
 IF (AUPOPFRE  >= 94 ) THEN AUPOPFRE  = .;
 IF (AUPOPMCD  >= 94 ) THEN AUPOPMCD  = .;
 IF (AUPOPMCR  >= 94 ) THEN AUPOPMCR  = .;
 IF (AUPOPMIL  >= 94 ) THEN AUPOPMIL  = .;
 IF (AUPOPMOS  >= 97 ) THEN AUPOPMOS  = .;
 IF (AUPOPOFM  >= 94 ) THEN AUPOPOFM  = .;
 IF (AUPOPPHI  >= 94 ) THEN AUPOPPHI  = .;
 IF (AUPOPPRV  >= 94 ) THEN AUPOPPRV  = .;
 IF (AUPOPPUB  >= 94 ) THEN AUPOPPUB  = .;
 IF (AUPOPREH  >= 94 ) THEN AUPOPREH  = .;
 IF (AUPOPSLF  >= 85 ) THEN AUPOPSLF  = .;
 IF (AURXYR  >= 85 ) THEN AURXYR  = .;
 IF (AUUNBUSY  >= 94 ) THEN AUUNBUSY  = .;
 IF (AUUNCFID  >= 94 ) THEN AUUNCFID  = .;
 IF (AUUNCMIT  >= 85 ) THEN AUUNCMIT  = .;
 IF (AUUNCOST  >= 85 ) THEN AUUNCOST  = .;
 IF (AUUNENUF  >= 94 ) THEN AUUNENUF  = .;
 IF (AUUNFOUT  >= 94 ) THEN AUUNFOUT  = .;
 IF (AUUNHNDL  >= 94 ) THEN AUUNHNDL  = .;
 IF (AUUNJOB  >= 94 ) THEN AUUNJOB  = .;
 IF (AUUNMTYR  >= 85 ) THEN AUUNMTYR  = .;
 IF (AUUNNBR  >= 94 ) THEN AUUNNBR  = .;
 IF (AUUNNCOV  >= 94 ) THEN AUUNNCOV  = .;
 IF (AUUNNHLP  >= 94 ) THEN AUUNNHLP  = .;
 IF (AUUNNOND  >= 94 ) THEN AUUNNOND  = .;
 IF (AUUNNTSP  >= 94 ) THEN AUUNNTSP  = .;
 IF (AUUNRIM2  >= 85 ) THEN AUUNRIM2  = .;
 IF (AUUNSOR  >= 94 ) THEN AUUNSOR  = .;
 IF (AUUNWHER  >= 85 ) THEN AUUNWHER  = .;
 IF (AVGGRADE  >= . ) THEN AVGGRADE  = .;
 IF (BKARSON  >= 85 ) THEN BKARSON  = .;
 IF (BKBURGL  >= 85 ) THEN BKBURGL  = .;
 IF (BKDRUG  >= 85 ) THEN BKDRUG  = .;
 IF (BKDRUNK  >= 85 ) THEN BKDRUNK  = .;
 IF (BKDRVINF  >= 85 ) THEN BKDRVINF  = .;
 IF (BKFRAUD  >= 85 ) THEN BKFRAUD  = .;
 IF (BKLARCNY  >= 85 ) THEN BKLARCNY  = .;
 IF (BKMVTHFT  >= 85 ) THEN BKMVTHFT  = .;
 IF (BKOTH  >= 85 ) THEN BKOTH  = .;
 IF (BKOTHOF2  >= 85 ) THEN BKOTHOF2  = .;
 IF (BKPOSTOB  >= 89 ) THEN BKPOSTOB  = .;
 IF (BKROB  >= 85 ) THEN BKROB  = .;
 IF (BKSEXNR  >= 85 ) THEN BKSEXNR  = .;
 IF (BKSMASLT  >= 85 ) THEN BKSMASLT  = .;
 IF (BKSRVIOL  >= 85 ) THEN BKSRVIOL  = .;
 IF (BLNT30C1  >= 98 ) THEN BLNT30C1  = .;
 IF (BLNT30C2  >= 98 ) THEN BLNT30C2  = .;
 IF (BLNT30DY  >= 91 ) THEN BLNT30DY  = .;
 IF (BLNTAGE  >= 981 ) THEN BLNTAGE  = .;
 IF (BLNTEVER  >= 94 ) THEN BLNTEVER  = .;
 IF (BLNTMFU  >= 81 ) THEN BLNTMFU  = .;
 IF (BLNTNOMJ  >= 91 ) THEN BLNTNOMJ  = .;
 IF (BLNTREC  >= 81 ) THEN BLNTREC  = .;
 IF (BLNTYFU  >= 9981 ) THEN BLNTYFU  = .;
 IF (BLRECFL2  >= 98 ) THEN BLRECFL2  = .;
 IF (BMI2  >= . ) THEN BMI2  = .;
 IF (BOOKED  >= 94 ) THEN BOOKED  = .;
 IF (CABINGAGE  >= 985 ) THEN CABINGAGE  = .;
 IF (CABINGEVR  >= 85 ) THEN CABINGEVR  = .;
 IF (CABINGFLG  >= 85 ) THEN CABINGFLG  = .;
 IF (CABINGMFU  >= 85 ) THEN CABINGMFU  = .;
 IF (CABINGYFU  >= 9985 ) THEN CABINGYFU  = .;
 IF (CABLADDER  >= 85 ) THEN CABLADDER  = .;
 IF (CABLOLEULYM  >= 85 ) THEN CABLOLEULYM  = .;
 IF (CABPLACE  >= 91 ) THEN CABPLACE  = .;
 IF (CABREAST  >= 85 ) THEN CABREAST  = .;
 IF (CABUNDAG  >= 91 ) THEN CABUNDAG  = .;
 IF (CABUYFRE  >= 91 ) THEN CABUYFRE  = .;
 IF (CABUYWHO  >= 91 ) THEN CABUYWHO  = .;
 IF (CACERVIX  >= 85 ) THEN CACERVIX  = .;
 IF (CACOLNRECT  >= 85 ) THEN CACOLNRECT  = .;
 IF (CADRBAR  >= 91 ) THEN CADRBAR  = .;
 IF (CADRCAR  >= 91 ) THEN CADRCAR  = .;
 IF (CADREVNT  >= 91 ) THEN CADREVNT  = .;
 IF (CADRHOME  >= 91 ) THEN CADRHOME  = .;
 IF (CADRKCOCN  >= 91 ) THEN CADRKCOCN  = .;
 IF (CADRKCOCN2  >= . ) THEN CADRKCOCN2  = .;
 IF (CADRKDRUG  >= 91 ) THEN CADRKDRUG  = .;
 IF (CADRKHALL  >= 91 ) THEN CADRKHALL  = .;
 IF (CADRKHALL2  >= . ) THEN CADRKHALL2  = .;
 IF (CADRKHERN  >= 91 ) THEN CADRKHERN  = .;
 IF (CADRKHERN2  >= . ) THEN CADRKHERN2  = .;
 IF (CADRKINHL  >= 91 ) THEN CADRKINHL  = .;
 IF (CADRKINHL2  >= . ) THEN CADRKINHL2  = .;
 IF (CADRKMARJ  >= 91 ) THEN CADRKMARJ  = .;
 IF (CADRKMARJ2  >= . ) THEN CADRKMARJ2  = .;
 IF (CADRKMETH  >= 91 ) THEN CADRKMETH  = .;
 IF (CADRKMETH2  >= . ) THEN CADRKMETH2  = .;
 IF (CADRLAST  >= 985 ) THEN CADRLAST  = .;
 IF (CADROTH  >= 91 ) THEN CADROTH  = .;
 IF (CADROTHM  >= 91 ) THEN CADROTHM  = .;
 IF (CADROTS2  >= 85 ) THEN CADROTS2  = .;
 IF (CADRPEOP  >= 91 ) THEN CADRPEOP  = .;
 IF (CADRPUBL  >= 91 ) THEN CADRPUBL  = .;
 IF (CADRSCHL  >= 91 ) THEN CADRSCHL  = .;
 IF (CAESOPSTOM  >= 85 ) THEN CAESOPSTOM  = .;
 IF (CAFRESP2  >= 85 ) THEN CAFRESP2  = .;
 IF (CAFREWHO  >= 91 ) THEN CAFREWHO  = .;
 IF (CAGALLIVPAN  >= 85 ) THEN CAGALLIVPAN  = .;
 IF (CAGVMONY  >= 91 ) THEN CAGVMONY  = .;
 IF (CAGVWHO  >= 91 ) THEN CAGVWHO  = .;
 IF (CAIDCHIP  >= 85 ) THEN CAIDCHIP  = .;
 IF (CAKIDNEY  >= 85 ) THEN CAKIDNEY  = .;
 IF (CALARYLUNG  >= 85 ) THEN CALARYLUNG  = .;
 IF (CAMELANOM  >= 85 ) THEN CAMELANOM  = .;
 IF (CAMOUTTHRO  >= 85 ) THEN CAMOUTTHRO  = .;
 IF (CANCEREVR  >= 85 ) THEN CANCEREVR  = .;
 IF (CANCERYR  >= 85 ) THEN CANCERYR  = .;
 IF (CAOTHER2  >= 85 ) THEN CAOTHER2  = .;
 IF (CAOVARY  >= 85 ) THEN CAOVARY  = .;
 IF (CAPROSTEST  >= 85 ) THEN CAPROSTEST  = .;
 IF (CASKINDK  >= 85 ) THEN CASKINDK  = .;
 IF (CASKINOTH  >= 85 ) THEN CASKINOTH  = .;
 IF (CATHYROID  >= 85 ) THEN CATHYROID  = .;
 IF (CAUTERUS  >= 85 ) THEN CAUTERUS  = .;
 IF (CC30EST  >= 91 ) THEN CC30EST  = .;
 IF (CCBSTWAY  >= 85 ) THEN CCBSTWAY  = .;
 IF (CCDAYPMO  >= 85 ) THEN CCDAYPMO  = .;
 IF (CCDAYPWK  >= 85 ) THEN CCDAYPWK  = .;
 IF (CCDAYPYR  >= 985 ) THEN CCDAYPYR  = .;
 IF (CCFQFLG  >= 98 ) THEN CCFQFLG  = .;
 IF (CCTOTFG  >= 98 ) THEN CCTOTFG  = .;
 IF (CELLNOTCL  >= 85 ) THEN CELLNOTCL  = .;
 IF (CELLWRKNG  >= 85 ) THEN CELLWRKNG  = .;
 IF (CG30EST  >= 91 ) THEN CG30EST  = .;
 IF (CGR30BR2  >= 9991 ) THEN CGR30BR2  = .;
 IF (CGR30USE  >= 91 ) THEN CGR30USE  = .;
 IF (CGRAGLST  >= 985 ) THEN CGRAGLST  = .;
 IF (CHAMPUS  >= 85 ) THEN CHAMPUS  = .;
 IF (CHMNDLREC  >= 91 ) THEN CHMNDLREC  = .;
 IF (CI30EST  >= 91 ) THEN CI30EST  = .;
 IF (CIG100LF  >= 91 ) THEN CIG100LF  = .;
 IF (CIG1PACK  >= . ) THEN CIG1PACK  = .;
 IF (CIG30AV  >= 91 ) THEN CIG30AV  = .;
 IF (CIG30BR2  >= 9991 ) THEN CIG30BR2  = .;
 IF (CIG30MEN  >= 91 ) THEN CIG30MEN  = .;
 IF (CIG30MLN  >= 91 ) THEN CIG30MLN  = .;
 IF (CIG30RO2  >= 91 ) THEN CIG30RO2  = .;
 IF (CIG30TPE  >= 91 ) THEN CIG30TPE  = .;
 IF (CIG30USE  >= 91 ) THEN CIG30USE  = .;
 IF (CIGAGE  >= 985 ) THEN CIGAGE  = .;
 IF (CIGAGLST  >= 985 ) THEN CIGAGLST  = .;
 IF (CIGAREVR  >= 94 ) THEN CIGAREVR  = .;
 IF (CIGARMFU  >= 85 ) THEN CIGARMFU  = .;
 IF (CIGARMLU  >= 85 ) THEN CIGARMLU  = .;
 IF (CIGARREC  >= 91 ) THEN CIGARREC  = .;
 IF (CIGARTRY  >= 985 ) THEN CIGARTRY  = .;
 IF (CIGARYFU  >= 9985 ) THEN CIGARYFU  = .;
 IF (CIGARYLU  >= 9985 ) THEN CIGARYLU  = .;
 IF (CIGAVGD  >= . ) THEN CIGAVGD  = .;
 IF (CIGAVGM  >= . ) THEN CIGAVGM  = .;
 IF (CIGAVOID  >= 91 ) THEN CIGAVOID  = .;
 IF (CIGCRAGP  >= 91 ) THEN CIGCRAGP  = .;
 IF (CIGCRAVE  >= 91 ) THEN CIGCRAVE  = .;
 IF (CIGDLLST  >= 985 ) THEN CIGDLLST  = .;
 IF (CIGDLMFU  >= 85 ) THEN CIGDLMFU  = .;
 IF (CIGDLMLU  >= 85 ) THEN CIGDLMLU  = .;
 IF (CIGDLYFU  >= 9985 ) THEN CIGDLYFU  = .;
 IF (CIGDLYLU  >= 9985 ) THEN CIGDLYLU  = .;
 IF (CIGDLYMO  >= 91 ) THEN CIGDLYMO  = .;
 IF (CIGFNLKE  >= 91 ) THEN CIGFNLKE  = .;
 IF (CIGFNSMK  >= 91 ) THEN CIGFNSMK  = .;
 IF (CIGINCRS  >= 91 ) THEN CIGINCRS  = .;
 IF (CIGINCTL  >= 91 ) THEN CIGINCTL  = .;
 IF (CIGINFLU  >= 91 ) THEN CIGINFLU  = .;
 IF (CIGIRTBL  >= 91 ) THEN CIGIRTBL  = .;
 IF (CIGLOTMR  >= 91 ) THEN CIGLOTMR  = .;
 IF (CIGMFU  >= 85 ) THEN CIGMFU  = .;
 IF (CIGMLU  >= 85 ) THEN CIGMLU  = .;
 IF (CIGNMCHG  >= 91 ) THEN CIGNMCHG  = .;
 IF (CIGNOINF  >= 91 ) THEN CIGNOINF  = .;
 IF (CIGOFRSM  >= 94 ) THEN CIGOFRSM  = .;
 IF (CIGPLANE  >= 91 ) THEN CIGPLANE  = .;
 IF (CIGREC  >= 91 ) THEN CIGREC  = .;
 IF (CIGREGDY  >= 91 ) THEN CIGREGDY  = .;
 IF (CIGREGNM  >= 91 ) THEN CIGREGNM  = .;
 IF (CIGREGWK  >= 91 ) THEN CIGREGWK  = .;
 IF (CIGRNOUT  >= 91 ) THEN CIGRNOUT  = .;
 IF (CIGSATIS  >= 91 ) THEN CIGSATIS  = .;
 IF (CIGSVLHR  >= 91 ) THEN CIGSVLHR  = .;
 IF (CIGTRY  >= 985 ) THEN CIGTRY  = .;
 IF (CIGWAKE  >= 91 ) THEN CIGWAKE  = .;
 IF (CIGWILYR  >= 94 ) THEN CIGWILYR  = .;
 IF (CIGYFU  >= 9985 ) THEN CIGYFU  = .;
 IF (CIGYLU  >= 9985 ) THEN CIGYLU  = .;
 IF (CIGYRBFR  >= 91 ) THEN CIGYRBFR  = .;
 IF (CIRROSAGE  >= 985 ) THEN CIRROSAGE  = .;
 IF (CIRROSEVR  >= 85 ) THEN CIRROSEVR  = .;
 IF (CLEFLU  >= 85 ) THEN CLEFLU  = .;
 IF (CLINVST  >= . ) THEN CLINVST  = .;
 IF (COCAGE  >= 985 ) THEN COCAGE  = .;
 IF (COCAGLST  >= 985 ) THEN COCAGLST  = .;
 IF (COCCUT1X  >= 91 ) THEN COCCUT1X  = .;
 IF (COCCUTDN  >= 91 ) THEN COCCUTDN  = .;
 IF (COCCUTEV  >= 91 ) THEN COCCUTEV  = .;
 IF (COCEMCTD  >= 91 ) THEN COCEMCTD  = .;
 IF (COCEMOPB  >= 91 ) THEN COCEMOPB  = .;
 IF (COCEVER  >= 94 ) THEN COCEVER  = .;
 IF (COCFLBLU  >= 91 ) THEN COCFLBLU  = .;
 IF (COCFMCTD  >= 91 ) THEN COCFMCTD  = .;
 IF (COCFMFPB  >= 91 ) THEN COCFMFPB  = .;
 IF (COCGTOVR  >= 91 ) THEN COCGTOVR  = .;
 IF (COCKPLMT  >= 91 ) THEN COCKPLMT  = .;
 IF (COCLAWTR  >= 91 ) THEN COCLAWTR  = .;
 IF (COCLIMIT  >= 91 ) THEN COCLIMIT  = .;
 IF (COCLOTTM  >= 91 ) THEN COCLOTTM  = .;
 IF (COCLSACT  >= 91 ) THEN COCLSACT  = .;
 IF (COCLSEFX  >= 91 ) THEN COCLSEFX  = .;
 IF (COCMFU  >= 85 ) THEN COCMFU  = .;
 IF (COCMLU  >= 85 ) THEN COCMLU  = .;
 IF (COCNDMOR  >= 91 ) THEN COCNDMOR  = .;
 IF (COCNEEDL  >= 91 ) THEN COCNEEDL  = .;
 IF (COCPDANG  >= 91 ) THEN COCPDANG  = .;
 IF (COCPHCTD  >= 91 ) THEN COCPHCTD  = .;
 IF (COCPHLPB  >= 91 ) THEN COCPHLPB  = .;
 IF (COCREC  >= 91 ) THEN COCREC  = .;
 IF (COCSERPB  >= 91 ) THEN COCSERPB  = .;
 IF (COCUS30A  >= 85 ) THEN COCUS30A  = .;
 IF (COCWD2SX  >= 91 ) THEN COCWD2SX  = .;
 IF (COCWDSMT  >= 91 ) THEN COCWDSMT  = .;
 IF (COCYFU  >= 9985 ) THEN COCYFU  = .;
 IF (COCYLU  >= 9985 ) THEN COCYLU  = .;
 IF (COCYRBFR  >= 85 ) THEN COCYRBFR  = .;
 IF (COCYRTOT  >= 985 ) THEN COCYRTOT  = .;
 IF (COLDMEDS  >= 94 ) THEN COLDMEDS  = .;
 IF (COLDREC  >= 91 ) THEN COLDREC  = .;
 IF (COLLENRLFT  >= . ) THEN COLLENRLFT  = .;
 IF (COLLENRLST  >= . ) THEN COLLENRLST  = .;
 IF (COMBATPY  >= 85 ) THEN COMBATPY  = .;
 IF (CONDLREC  >= 91 ) THEN CONDLREC  = .;
 IF (COPDAGE  >= 985 ) THEN COPDAGE  = .;
 IF (COPDEVER  >= 85 ) THEN COPDEVER  = .;
 IF (CR30EST  >= 91 ) THEN CR30EST  = .;
 IF (CRAKREC  >= 91 ) THEN CRAKREC  = .;
 IF (CRBSTWAY  >= 91 ) THEN CRBSTWAY  = .;
 IF (CRDAYPMO  >= 91 ) THEN CRDAYPMO  = .;
 IF (CRDAYPWK  >= 91 ) THEN CRDAYPWK  = .;
 IF (CRDAYPYR  >= 989 ) THEN CRDAYPYR  = .;
 IF (CRFQFLG  >= 98 ) THEN CRFQFLG  = .;
 IF (CRKAGE  >= 985 ) THEN CRKAGE  = .;
 IF (CRKAGLST  >= 985 ) THEN CRKAGLST  = .;
 IF (CRKEVER  >= 91 ) THEN CRKEVER  = .;
 IF (CRKMFU  >= 85 ) THEN CRKMFU  = .;
 IF (CRKMLU  >= 85 ) THEN CRKMLU  = .;
 IF (CRKUS30A  >= 85 ) THEN CRKUS30A  = .;
 IF (CRKYFU  >= 9985 ) THEN CRKYFU  = .;
 IF (CRKYLU  >= 9985 ) THEN CRKYLU  = .;
 IF (CRKYRTOT  >= 991 ) THEN CRKYRTOT  = .;
 IF (CRTOTFG  >= 98 ) THEN CRTOTFG  = .;
 IF (DAMTFXREC  >= 91 ) THEN DAMTFXREC  = .;
 IF (DEPENDHAL  >= . ) THEN DEPENDHAL  = .;
 IF (DEPENDINH  >= . ) THEN DEPENDINH  = .;
 IF (DEPENDMTH  >= . ) THEN DEPENDMTH  = .;
 IF (DEPENDPNR  >= . ) THEN DEPENDPNR  = .;
 IF (DEPENDSED  >= . ) THEN DEPENDSED  = .;
 IF (DEPENDSTM  >= . ) THEN DEPENDSTM  = .;
 IF (DEPENDTRQ  >= . ) THEN DEPENDTRQ  = .;
 IF (DIABETEAG  >= 985 ) THEN DIABETEAG  = .;
 IF (DIABETEVR  >= 85 ) THEN DIABETEVR  = .;
 IF (DIFFDRESS  >= 85 ) THEN DIFFDRESS  = .;
 IF (DIFFERAND  >= 94 ) THEN DIFFERAND  = .;
 IF (DIFFHEAR  >= 85 ) THEN DIFFHEAR  = .;
 IF (DIFFSEE  >= 85 ) THEN DIFFSEE  = .;
 IF (DIFFTHINK  >= 85 ) THEN DIFFTHINK  = .;
 IF (DIFFWALK  >= 85 ) THEN DIFFWALK  = .;
 IF (DIFGETCOC  >= 94 ) THEN DIFGETCOC  = .;
 IF (DIFGETCRK  >= 94 ) THEN DIFGETCRK  = .;
 IF (DIFGETHER  >= 94 ) THEN DIFGETHER  = .;
 IF (DIFGETLSD  >= 94 ) THEN DIFGETLSD  = .;
 IF (DIFGETMRJ  >= 94 ) THEN DIFGETMRJ  = .;
 IF (DIFOBTCOC  >= . ) THEN DIFOBTCOC  = .;
 IF (DIFOBTCRK  >= . ) THEN DIFOBTCRK  = .;
 IF (DIFOBTHER  >= . ) THEN DIFOBTHER  = .;
 IF (DIFOBTLSD  >= . ) THEN DIFOBTLSD  = .;
 IF (DIFOBTMRJ  >= . ) THEN DIFOBTMRJ  = .;
 IF (DMTAMTFXY  >= 91 ) THEN DMTAMTFXY  = .;
 IF (DRPRVME3  >= . ) THEN DRPRVME3  = .;
 IF (DRVINALCO  >= 85 ) THEN DRVINALCO  = .;
 IF (DRVINALCO2  >= . ) THEN DRVINALCO2  = .;
 IF (DRVINALDRG  >= . ) THEN DRVINALDRG  = .;
 IF (DRVINALON  >= 91 ) THEN DRVINALON  = .;
 IF (DRVINCOCN  >= 91 ) THEN DRVINCOCN  = .;
 IF (DRVINDRG  >= . ) THEN DRVINDRG  = .;
 IF (DRVINDROTMJ  >= . ) THEN DRVINDROTMJ  = .;
 IF (DRVINHALL  >= 91 ) THEN DRVINHALL  = .;
 IF (DRVINHERN  >= 91 ) THEN DRVINHERN  = .;
 IF (DRVININHL  >= 85 ) THEN DRVININHL  = .;
 IF (DRVINMARJ  >= 85 ) THEN DRVINMARJ  = .;
 IF (DRVINMARJ2  >= . ) THEN DRVINMARJ2  = .;
 IF (DRVINMETH  >= 85 ) THEN DRVINMETH  = .;
 IF (DSTCHR12  >= 85 ) THEN DSTCHR12  = .;
 IF (DSTCHR30  >= 85 ) THEN DSTCHR30  = .;
 IF (DSTEFF12  >= 85 ) THEN DSTEFF12  = .;
 IF (DSTEFF30  >= 85 ) THEN DSTEFF30  = .;
 IF (DSTHOP12  >= 85 ) THEN DSTHOP12  = .;
 IF (DSTHOP30  >= 85 ) THEN DSTHOP30  = .;
 IF (DSTNGD12  >= 85 ) THEN DSTNGD12  = .;
 IF (DSTNGD30  >= 85 ) THEN DSTNGD30  = .;
 IF (DSTNRV12  >= 85 ) THEN DSTNRV12  = .;
 IF (DSTNRV30  >= 85 ) THEN DSTNRV30  = .;
 IF (DSTRST12  >= 85 ) THEN DSTRST12  = .;
 IF (DSTRST30  >= 85 ) THEN DSTRST30  = .;
 IF (DSTWORST  >= 85 ) THEN DSTWORST  = .;
 IF (DYTXVST  >= . ) THEN DYTXVST  = .;
 IF (ECSTMOAGE  >= 985 ) THEN ECSTMOAGE  = .;
 IF (ECSTMOAGL  >= 985 ) THEN ECSTMOAGL  = .;
 IF (ECSTMOLLY  >= 91 ) THEN ECSTMOLLY  = .;
 IF (ECSTMOMFU  >= 85 ) THEN ECSTMOMFU  = .;
 IF (ECSTMOMLU  >= 85 ) THEN ECSTMOMLU  = .;
 IF (ECSTMOREC  >= 91 ) THEN ECSTMOREC  = .;
 IF (ECSTMOYFU  >= 9985 ) THEN ECSTMOYFU  = .;
 IF (ECSTMOYLU  >= 9985 ) THEN ECSTMOYLU  = .;
 IF (EDFAM18  >= 98 ) THEN EDFAM18  = .;
 IF (EDUFULPAR  >= 94 ) THEN EDUFULPAR  = .;
 IF (EDUSCHGRD2  >= 98 ) THEN EDUSCHGRD2  = .;
 IF (EDUSCHLGO  >= 85 ) THEN EDUSCHLGO  = .;
 IF (EDUSCKMON  >= 94 ) THEN EDUSCKMON  = .;
 IF (EDUSKPMON  >= 94 ) THEN EDUSKPMON  = .;
 IF (ETHER  >= 85 ) THEN ETHER  = .;
 IF (FDOCANGR  >= . ) THEN FDOCANGR  = .;
 IF (FDOCBRK  >= . ) THEN FDOCBRK  = .;
 IF (FDOCDPR  >= . ) THEN FDOCDPR  = .;
 IF (FDOCEAT  >= . ) THEN FDOCEAT  = .;
 IF (FDOCFEA  >= . ) THEN FDOCFEA  = .;
 IF (FDOCFITE  >= . ) THEN FDOCFITE  = .;
 IF (FDOCFMLY  >= . ) THEN FDOCFMLY  = .;
 IF (FDOCFRND  >= . ) THEN FDOCFRND  = .;
 IF (FDOCMEND  >= . ) THEN FDOCMEND  = .;
 IF (FDOCOTH2  >= . ) THEN FDOCOTH2  = .;
 IF (FDOCOTPP  >= . ) THEN FDOCOTPP  = .;
 IF (FDOCSCHL  >= . ) THEN FDOCSCHL  = .;
 IF (FDOCSUI  >= . ) THEN FDOCSUI  = .;
 IF (FELTMARKR  >= 85 ) THEN FELTMARKR  = .;
 IF (FOSTVST  >= . ) THEN FOSTVST  = .;
 IF (FRDADLY2  >= . ) THEN FRDADLY2  = .;
 IF (FRDMEVR2  >= . ) THEN FRDMEVR2  = .;
 IF (FRDMJMON  >= . ) THEN FRDMJMON  = .;
 IF (FRDPCIG2  >= . ) THEN FRDPCIG2  = .;
 IF (GAS  >= 85 ) THEN GAS  = .;
 IF (GHB  >= 94 ) THEN GHB  = .;
 IF (GHBREC  >= 91 ) THEN GHBREC  = .;
 IF (GLUE  >= 85 ) THEN GLUE  = .;
 IF (GNNDCLEN  >= 89 ) THEN GNNDCLEN  = .;
 IF (GNNDGET2  >= 89 ) THEN GNNDGET2  = .;
 IF (GNNDLSH1  >= 89 ) THEN GNNDLSH1  = .;
 IF (GNNDLSH2  >= 89 ) THEN GNNDLSH2  = .;
 IF (GNNDREUS  >= 89 ) THEN GNNDREUS  = .;
 IF (GRPCNSL2  >= . ) THEN GRPCNSL2  = .;
 IF (GRPHLTIN  >= 85 ) THEN GRPHLTIN  = .;
 IF (GRSKBNGDLY  >= . ) THEN GRSKBNGDLY  = .;
 IF (GRSKBNGWK  >= . ) THEN GRSKBNGWK  = .;
 IF (GRSKCIGPKD  >= . ) THEN GRSKCIGPKD  = .;
 IF (GRSKCOCMON  >= . ) THEN GRSKCOCMON  = .;
 IF (GRSKCOCWK  >= . ) THEN GRSKCOCWK  = .;
 IF (GRSKHERTRY  >= . ) THEN GRSKHERTRY  = .;
 IF (GRSKHERWK  >= . ) THEN GRSKHERWK  = .;
 IF (GRSKLSDTRY  >= . ) THEN GRSKLSDTRY  = .;
 IF (GRSKLSDWK  >= . ) THEN GRSKLSDWK  = .;
 IF (GRSKMRJMON  >= . ) THEN GRSKMRJMON  = .;
 IF (GRSKMRJWK  >= . ) THEN GRSKMRJWK  = .;
 IF (HALFQFLG  >= 98 ) THEN HALFQFLG  = .;
 IF (HALLAGLST  >= 985 ) THEN HALLAGLST  = .;
 IF (HALLDYPMO  >= 85 ) THEN HALLDYPMO  = .;
 IF (HALLDYPWK  >= 91 ) THEN HALLDYPWK  = .;
 IF (HALLDYSYR  >= 985 ) THEN HALLDYSYR  = .;
 IF (HALLEASWY  >= 85 ) THEN HALLEASWY  = .;
 IF (HALLMOLST  >= 85 ) THEN HALLMOLST  = .;
 IF (HALLUC30E  >= 91 ) THEN HALLUC30E  = .;
 IF (HALLUC30N  >= 85 ) THEN HALLUC30N  = .;
 IF (HALLUCAGE  >= 985 ) THEN HALLUCAGE  = .;
 IF (HALLUCEVR  >= 91 ) THEN HALLUCEVR  = .;
 IF (HALLUCMFU  >= 85 ) THEN HALLUCMFU  = .;
 IF (HALLUCOT1  >= 9985 ) THEN HALLUCOT1  = .;
 IF (HALLUCOT2  >= 9985 ) THEN HALLUCOT2  = .;
 IF (HALLUCOT3  >= 9991 ) THEN HALLUCOT3  = .;
 IF (HALLUCOT4  >= 9991 ) THEN HALLUCOT4  = .;
 IF (HALLUCOT5  >= 9991 ) THEN HALLUCOT5  = .;
 IF (HALLUCOTH  >= 91 ) THEN HALLUCOTH  = .;
 IF (HALLUCREC  >= 91 ) THEN HALLUCREC  = .;
 IF (HALLUCYFQ  >= 985 ) THEN HALLUCYFQ  = .;
 IF (HALLUCYFU  >= 9985 ) THEN HALLUCYFU  = .;
 IF (HALLYRLST  >= 9985 ) THEN HALLYRLST  = .;
 IF (HALTOTFG  >= 98 ) THEN HALTOTFG  = .;
 IF (HALUCUTDN  >= 91 ) THEN HALUCUTDN  = .;
 IF (HALUCUTEV  >= 91 ) THEN HALUCUTEV  = .;
 IF (HALUEMCTD  >= 91 ) THEN HALUEMCTD  = .;
 IF (HALUEMOPB  >= 91 ) THEN HALUEMOPB  = .;
 IF (HALUFMCTD  >= 91 ) THEN HALUFMCTD  = .;
 IF (HALUFMFPB  >= 91 ) THEN HALUFMFPB  = .;
 IF (HALUGTOVR  >= 91 ) THEN HALUGTOVR  = .;
 IF (HALUKPLMT  >= 91 ) THEN HALUKPLMT  = .;
 IF (HALULAWTR  >= 91 ) THEN HALULAWTR  = .;
 IF (HALULIMIT  >= 91 ) THEN HALULIMIT  = .;
 IF (HALULOTTM  >= 91 ) THEN HALULOTTM  = .;
 IF (HALULSACT  >= 91 ) THEN HALULSACT  = .;
 IF (HALULSEFX  >= 91 ) THEN HALULSEFX  = .;
 IF (HALUNDMOR  >= 91 ) THEN HALUNDMOR  = .;
 IF (HALUPDANG  >= 91 ) THEN HALUPDANG  = .;
 IF (HALUPHCTD  >= 91 ) THEN HALUPHCTD  = .;
 IF (HALUPHLPB  >= 91 ) THEN HALUPHLPB  = .;
 IF (HALUSERPB  >= 91 ) THEN HALUSERPB  = .;
 IF (HEALTH  >= 94 ) THEN HEALTH  = .;
 IF (HEALTH2  >= . ) THEN HEALTH2  = .;
 IF (HEOTNDL  >= 91 ) THEN HEOTNDL  = .;
 IF (HEOTOTH  >= 91 ) THEN HEOTOTH  = .;
 IF (HEOTSMK  >= 91 ) THEN HEOTSMK  = .;
 IF (HEOTSNF  >= 91 ) THEN HEOTSNF  = .;
 IF (HEOTSP  >= 85 ) THEN HEOTSP  = .;
 IF (HEPBCAGE  >= 985 ) THEN HEPBCAGE  = .;
 IF (HEPBCEVER  >= 85 ) THEN HEPBCEVER  = .;
 IF (HER30USE  >= 85 ) THEN HER30USE  = .;
 IF (HERAGE  >= 985 ) THEN HERAGE  = .;
 IF (HERAGLST  >= 985 ) THEN HERAGLST  = .;
 IF (HERCUT1X  >= 91 ) THEN HERCUT1X  = .;
 IF (HERCUTDN  >= 91 ) THEN HERCUTDN  = .;
 IF (HERCUTEV  >= 91 ) THEN HERCUTEV  = .;
 IF (HEREMCTD  >= 91 ) THEN HEREMCTD  = .;
 IF (HEREMOPB  >= 91 ) THEN HEREMOPB  = .;
 IF (HEREVER  >= 94 ) THEN HEREVER  = .;
 IF (HERFMCTD  >= 91 ) THEN HERFMCTD  = .;
 IF (HERFMFPB  >= 91 ) THEN HERFMFPB  = .;
 IF (HERGTOVR  >= 91 ) THEN HERGTOVR  = .;
 IF (HERKPLMT  >= 91 ) THEN HERKPLMT  = .;
 IF (HERLAWTR  >= 91 ) THEN HERLAWTR  = .;
 IF (HERLIMIT  >= 91 ) THEN HERLIMIT  = .;
 IF (HERLOTTM  >= 91 ) THEN HERLOTTM  = .;
 IF (HERLSACT  >= 91 ) THEN HERLSACT  = .;
 IF (HERLSEFX  >= 91 ) THEN HERLSEFX  = .;
 IF (HERMFU  >= 85 ) THEN HERMFU  = .;
 IF (HERMLU  >= 85 ) THEN HERMLU  = .;
 IF (HERNDMOR  >= 91 ) THEN HERNDMOR  = .;
 IF (HERNEEDL  >= 91 ) THEN HERNEEDL  = .;
 IF (HERPDANG  >= 91 ) THEN HERPDANG  = .;
 IF (HERPHCTD  >= 91 ) THEN HERPHCTD  = .;
 IF (HERPHLPB  >= 91 ) THEN HERPHLPB  = .;
 IF (HERREC  >= 91 ) THEN HERREC  = .;
 IF (HERSERPB  >= 91 ) THEN HERSERPB  = .;
 IF (HERSMOKE  >= 91 ) THEN HERSMOKE  = .;
 IF (HERSNIFF  >= 91 ) THEN HERSNIFF  = .;
 IF (HERWD3SX  >= 91 ) THEN HERWD3SX  = .;
 IF (HERWDSMT  >= 91 ) THEN HERWDSMT  = .;
 IF (HERYFU  >= 9985 ) THEN HERYFU  = .;
 IF (HERYLU  >= 9985 ) THEN HERYLU  = .;
 IF (HERYRTOT  >= 985 ) THEN HERYRTOT  = .;
 IF (HIGHBPAGE  >= 985 ) THEN HIGHBPAGE  = .;
 IF (HIGHBPEVR  >= 85 ) THEN HIGHBPEVR  = .;
 IF (HIGHBPMED  >= 85 ) THEN HIGHBPMED  = .;
 IF (HIVAIDSAG  >= 985 ) THEN HIVAIDSAG  = .;
 IF (HIVAIDSEV  >= 85 ) THEN HIVAIDSEV  = .;
 IF (HLCALL99  >= 98 ) THEN HLCALL99  = .;
 IF (HLCALLFG  >= 98 ) THEN HLCALLFG  = .;
 IF (HLCLAST  >= 85 ) THEN HLCLAST  = .;
 IF (HLCNOTMO  >= 94 ) THEN HLCNOTMO  = .;
 IF (HLCNOTYR  >= 85 ) THEN HLCNOTYR  = .;
 IF (HLLOSRSN  >= 85 ) THEN HLLOSRSN  = .;
 IF (HLNVCOST  >= 94 ) THEN HLNVCOST  = .;
 IF (HLNVNEED  >= 85 ) THEN HLNVNEED  = .;
 IF (HLNVOFFR  >= 94 ) THEN HLNVOFFR  = .;
 IF (HLNVREF  >= 85 ) THEN HLNVREF  = .;
 IF (HLNVSOR  >= 94 ) THEN HLNVSOR  = .;
 IF (HLTINALC  >= 85 ) THEN HLTINALC  = .;
 IF (HLTINDRG  >= 85 ) THEN HLTINDRG  = .;
 IF (HLTINMNT  >= 85 ) THEN HLTINMNT  = .;
 IF (HLTINNOS  >= 85 ) THEN HLTINNOS  = .;
 IF (HOMEVST  >= . ) THEN HOMEVST  = .;
 IF (HOSPVST  >= . ) THEN HOSPVST  = .;
 IF (HPALCAMT  >= 85 ) THEN HPALCAMT  = .;
 IF (HPALCCUT  >= 91 ) THEN HPALCCUT  = .;
 IF (HPALCFRQ  >= 85 ) THEN HPALCFRQ  = .;
 IF (HPALCNOT  >= 85 ) THEN HPALCNOT  = .;
 IF (HPALCPRB  >= 91 ) THEN HPALCPRB  = .;
 IF (HPALCTX  >= 91 ) THEN HPALCTX  = .;
 IF (HPDRGTALK  >= 85 ) THEN HPDRGTALK  = .;
 IF (HPQTTOB  >= 91 ) THEN HPQTTOB  = .;
 IF (HPUSEALC  >= 85 ) THEN HPUSEALC  = .;
 IF (HPUSEDRG  >= 85 ) THEN HPUSEDRG  = .;
 IF (HPUSETOB  >= 85 ) THEN HPUSETOB  = .;
 IF (HR30EST  >= 91 ) THEN HR30EST  = .;
 IF (HRBSTWAY  >= 85 ) THEN HRBSTWAY  = .;
 IF (HRDAYPMO  >= 85 ) THEN HRDAYPMO  = .;
 IF (HRDAYPWK  >= 85 ) THEN HRDAYPWK  = .;
 IF (HRDAYPYR  >= 989 ) THEN HRDAYPYR  = .;
 IF (HRFQFLG  >= 98 ) THEN HRFQFLG  = .;
 IF (HRNDLREC  >= 91 ) THEN HRNDLREC  = .;
 IF (HRSMKREC  >= 91 ) THEN HRSMKREC  = .;
 IF (HRSNFREC  >= 91 ) THEN HRSNFREC  = .;
 IF (HRTCONDAG  >= 985 ) THEN HRTCONDAG  = .;
 IF (HRTCONDEV  >= 85 ) THEN HRTCONDEV  = .;
 IF (HRTCONDYR  >= 85 ) THEN HRTCONDYR  = .;
 IF (HRTOTFG  >= 98 ) THEN HRTOTFG  = .;
 IF (HTANSWER  >= 94 ) THEN HTANSWER  = .;
 IF (HTINCHE2  >= 985 ) THEN HTINCHE2  = .;
 IF (IICGAVD  >= 98 ) THEN IICGAVD  = .;
 IF (IICGCRGP  >= 98 ) THEN IICGCRGP  = .;
 IF (IICGCRV  >= 98 ) THEN IICGCRV  = .;
 IF (IICGINCR  >= 98 ) THEN IICGINCR  = .;
 IF (IICGINFL  >= 98 ) THEN IICGINFL  = .;
 IF (IICGIRTB  >= 98 ) THEN IICGIRTB  = .;
 IF (IICGLMR  >= 98 ) THEN IICGLMR  = .;
 IF (IICGNCG  >= 98 ) THEN IICGNCG  = .;
 IF (IICGNCTL  >= 98 ) THEN IICGNCTL  = .;
 IF (IICGNINF  >= 98 ) THEN IICGNINF  = .;
 IF (IICGPLN  >= 98 ) THEN IICGPLN  = .;
 IF (IICGRGDY  >= 98 ) THEN IICGRGDY  = .;
 IF (IICGRGNM  >= 98 ) THEN IICGRGNM  = .;
 IF (IICGRGWK  >= 98 ) THEN IICGRGWK  = .;
 IF (IICGROUT  >= 98 ) THEN IICGROUT  = .;
 IF (IICGSAT  >= 98 ) THEN IICGSAT  = .;
 IF (IICGSLHR  >= 98 ) THEN IICGSLHR  = .;
 IF (IMPCONCN  >= 85 ) THEN IMPCONCN  = .;
 IF (IMPDYFRQ  >= 85 ) THEN IMPDYFRQ  = .;
 IF (IMPGOUT  >= 85 ) THEN IMPGOUT  = .;
 IF (IMPGOUTM  >= 94 ) THEN IMPGOUTM  = .;
 IF (IMPHHLD  >= 85 ) THEN IMPHHLD  = .;
 IF (IMPHHLDM  >= 94 ) THEN IMPHHLDM  = .;
 IF (IMPPEOP  >= 85 ) THEN IMPPEOP  = .;
 IF (IMPPEOPM  >= 94 ) THEN IMPPEOPM  = .;
 IF (IMPREMEM  >= 85 ) THEN IMPREMEM  = .;
 IF (IMPRESP  >= 85 ) THEN IMPRESP  = .;
 IF (IMPRESPM  >= 94 ) THEN IMPRESPM  = .;
 IF (IMPSOC  >= 85 ) THEN IMPSOC  = .;
 IF (IMPSOCM  >= 94 ) THEN IMPSOCM  = .;
 IF (IMPWEEKS  >= 85 ) THEN IMPWEEKS  = .;
 IF (IMPWORK  >= 85 ) THEN IMPWORK  = .;
 IF (IMPYDAYS  >= 985 ) THEN IMPYDAYS  = .;
 IF (INHAL30ES  >= 91 ) THEN INHAL30ES  = .;
 IF (INHAL30N  >= 85 ) THEN INHAL30N  = .;
 IF (INHALAGE  >= 985 ) THEN INHALAGE  = .;
 IF (INHALEVER  >= 91 ) THEN INHALEVER  = .;
 IF (INHALMFU  >= 85 ) THEN INHALMFU  = .;
 IF (INHALOT1  >= 9985 ) THEN INHALOT1  = .;
 IF (INHALOT2  >= 9985 ) THEN INHALOT2  = .;
 IF (INHALOT3  >= 9985 ) THEN INHALOT3  = .;
 IF (INHALOT4  >= 9991 ) THEN INHALOT4  = .;
 IF (INHALOT5  >= 9991 ) THEN INHALOT5  = .;
 IF (INHALOTH  >= 85 ) THEN INHALOTH  = .;
 IF (INHALREC  >= 85 ) THEN INHALREC  = .;
 IF (INHALYFQ  >= 985 ) THEN INHALYFQ  = .;
 IF (INHALYFU  >= 9985 ) THEN INHALYFU  = .;
 IF (INHDYPMO  >= 85 ) THEN INHDYPMO  = .;
 IF (INHDYPWK  >= 85 ) THEN INHDYPWK  = .;
 IF (INHDYSYR  >= 985 ) THEN INHDYSYR  = .;
 IF (INHEASWY  >= 85 ) THEN INHEASWY  = .;
 IF (INHFQFLG  >= 98 ) THEN INHFQFLG  = .;
 IF (INHLAGLST  >= 985 ) THEN INHLAGLST  = .;
 IF (INHLCUTDN  >= 85 ) THEN INHLCUTDN  = .;
 IF (INHLCUTEV  >= 85 ) THEN INHLCUTEV  = .;
 IF (INHLEMCTD  >= 85 ) THEN INHLEMCTD  = .;
 IF (INHLEMOPB  >= 85 ) THEN INHLEMOPB  = .;
 IF (INHLFMCTD  >= 91 ) THEN INHLFMCTD  = .;
 IF (INHLFMFPB  >= 85 ) THEN INHLFMFPB  = .;
 IF (INHLGTOVR  >= 85 ) THEN INHLGTOVR  = .;
 IF (INHLKPLMT  >= 91 ) THEN INHLKPLMT  = .;
 IF (INHLLAWTR  >= 85 ) THEN INHLLAWTR  = .;
 IF (INHLLIMIT  >= 85 ) THEN INHLLIMIT  = .;
 IF (INHLLOTTM  >= 85 ) THEN INHLLOTTM  = .;
 IF (INHLLSACT  >= 85 ) THEN INHLLSACT  = .;
 IF (INHLLSEFX  >= 85 ) THEN INHLLSEFX  = .;
 IF (INHLMOLST  >= 85 ) THEN INHLMOLST  = .;
 IF (INHLNDMOR  >= 85 ) THEN INHLNDMOR  = .;
 IF (INHLPDANG  >= 85 ) THEN INHLPDANG  = .;
 IF (INHLPHCTD  >= 91 ) THEN INHLPHCTD  = .;
 IF (INHLPHLPB  >= 85 ) THEN INHLPHLPB  = .;
 IF (INHLSERPB  >= 85 ) THEN INHLSERPB  = .;
 IF (INHLYRLST  >= 9985 ) THEN INHLYRLST  = .;
 IF (INHOSPYR  >= 85 ) THEN INHOSPYR  = .;
 IF (INHTOTFG  >= 98 ) THEN INHTOTFG  = .;
 IF (IRABUPOSHAL  >= 91 ) THEN IRABUPOSHAL  = .;
 IF (IRABUPOSINH  >= 91 ) THEN IRABUPOSINH  = .;
 IF (IRABUPOSMTH  >= 91 ) THEN IRABUPOSMTH  = .;
 IF (IRABUPOSPNR  >= 91 ) THEN IRABUPOSPNR  = .;
 IF (IRABUPOSSED  >= 91 ) THEN IRABUPOSSED  = .;
 IF (IRABUPOSSTM  >= 91 ) THEN IRABUPOSSTM  = .;
 IF (IRABUPOSTRQ  >= 91 ) THEN IRABUPOSTRQ  = .;
 IF (IRALCAGE  >= 991 ) THEN IRALCAGE  = .;
 IF (IRALCBNG30D  >= 91 ) THEN IRALCBNG30D  = .;
 IF (IRALCFM  >= 91 ) THEN IRALCFM  = .;
 IF (IRALCFY  >= 991 ) THEN IRALCFY  = .;
 IF (IRALCYFU  >= 9999 ) THEN IRALCYFU  = .;
 IF (IRCD2YFU  >= 9993 ) THEN IRCD2YFU  = .;
 IF (IRCDUAGE  >= 991 ) THEN IRCDUAGE  = .;
 IF (IRCGRAGE  >= 991 ) THEN IRCGRAGE  = .;
 IF (IRCGRFM  >= 91 ) THEN IRCGRFM  = .;
 IF (IRCGRYFU  >= 9999 ) THEN IRCGRYFU  = .;
 IF (IRCIGAGE  >= 991 ) THEN IRCIGAGE  = .;
 IF (IRCIGFM  >= 91 ) THEN IRCIGFM  = .;
 IF (IRCIGYFU  >= 9999 ) THEN IRCIGYFU  = .;
 IF (IRCOCAGE  >= 991 ) THEN IRCOCAGE  = .;
 IF (IRCOCFM  >= 91 ) THEN IRCOCFM  = .;
 IF (IRCOCFY  >= 991 ) THEN IRCOCFY  = .;
 IF (IRCOCYFU  >= 9999 ) THEN IRCOCYFU  = .;
 IF (IRCRKAGE  >= 991 ) THEN IRCRKAGE  = .;
 IF (IRCRKFM  >= 91 ) THEN IRCRKFM  = .;
 IF (IRCRKFY  >= 991 ) THEN IRCRKFY  = .;
 IF (IRCRKYFU  >= 9999 ) THEN IRCRKYFU  = .;
 IF (IRDEPENDHAL  >= 91 ) THEN IRDEPENDHAL  = .;
 IF (IRDEPENDINH  >= 91 ) THEN IRDEPENDINH  = .;
 IF (IRDEPENDMTH  >= 91 ) THEN IRDEPENDMTH  = .;
 IF (IRDEPENDPNR  >= 91 ) THEN IRDEPENDPNR  = .;
 IF (IRDEPENDSED  >= 91 ) THEN IRDEPENDSED  = .;
 IF (IRDEPENDSTM  >= 91 ) THEN IRDEPENDSTM  = .;
 IF (IRDEPENDTRQ  >= 91 ) THEN IRDEPENDTRQ  = .;
 IF (IRECSTMOAGE  >= 991 ) THEN IRECSTMOAGE  = .;
 IF (IRECSTMOYFU  >= 9999 ) THEN IRECSTMOYFU  = .;
 IF (IRHALLUC30N  >= 91 ) THEN IRHALLUC30N  = .;
 IF (IRHALLUCAGE  >= 991 ) THEN IRHALLUCAGE  = .;
 IF (IRHALLUCYFQ  >= 991 ) THEN IRHALLUCYFQ  = .;
 IF (IRHALLUCYFU  >= 9999 ) THEN IRHALLUCYFU  = .;
 IF (IRHERAGE  >= 991 ) THEN IRHERAGE  = .;
 IF (IRHERFM  >= 91 ) THEN IRHERFM  = .;
 IF (IRHERFY  >= 991 ) THEN IRHERFY  = .;
 IF (IRHERYFU  >= 9999 ) THEN IRHERYFU  = .;
 IF (IRINHAL30N  >= 91 ) THEN IRINHAL30N  = .;
 IF (IRINHALAGE  >= 991 ) THEN IRINHALAGE  = .;
 IF (IRINHALYFQ  >= 991 ) THEN IRINHALYFQ  = .;
 IF (IRINHALYFU  >= 9999 ) THEN IRINHALYFU  = .;
 IF (IRLSDAGE  >= 991 ) THEN IRLSDAGE  = .;
 IF (IRLSDYFU  >= 9999 ) THEN IRLSDYFU  = .;
 IF (IRMARIT  >= 99 ) THEN IRMARIT  = .;
 IF (IRMETHAM30N  >= 91 ) THEN IRMETHAM30N  = .;
 IF (IRMETHAMAGE  >= 991 ) THEN IRMETHAMAGE  = .;
 IF (IRMETHAMYFQ  >= 991 ) THEN IRMETHAMYFQ  = .;
 IF (IRMETHAMYFU  >= 9999 ) THEN IRMETHAMYFU  = .;
 IF (IRMJAGE  >= 991 ) THEN IRMJAGE  = .;
 IF (IRMJFM  >= 91 ) THEN IRMJFM  = .;
 IF (IRMJFY  >= 991 ) THEN IRMJFY  = .;
 IF (IRMJYFU  >= 9999 ) THEN IRMJYFU  = .;
 IF (IROTHHLT  >= 99 ) THEN IROTHHLT  = .;
 IF (IRPCPAGE  >= 991 ) THEN IRPCPAGE  = .;
 IF (IRPCPYFU  >= 9999 ) THEN IRPCPYFU  = .;
 IF (IRPNRNM30FQ  >= 91 ) THEN IRPNRNM30FQ  = .;
 IF (IRPNRNMAGE  >= 993 ) THEN IRPNRNMAGE  = .;
 IF (IRPNRNMINIT  >= 91 ) THEN IRPNRNMINIT  = .;
 IF (IRPNRNMYFU  >= 9993 ) THEN IRPNRNMYFU  = .;
 IF (IRSEDNM30FQ  >= 91 ) THEN IRSEDNM30FQ  = .;
 IF (IRSEDNMAGE  >= 993 ) THEN IRSEDNMAGE  = .;
 IF (IRSEDNMINIT  >= 91 ) THEN IRSEDNMINIT  = .;
 IF (IRSEDNMYFU  >= 9993 ) THEN IRSEDNMYFU  = .;
 IF (IRSMKLSS30N  >= 91 ) THEN IRSMKLSS30N  = .;
 IF (IRSMKLSSTRY  >= 991 ) THEN IRSMKLSSTRY  = .;
 IF (IRSMKLSSYFU  >= 9999 ) THEN IRSMKLSSYFU  = .;
 IF (IRSTMNM30FQ  >= 91 ) THEN IRSTMNM30FQ  = .;
 IF (IRSTMNMAGE  >= 993 ) THEN IRSTMNMAGE  = .;
 IF (IRSTMNMINIT  >= 91 ) THEN IRSTMNMINIT  = .;
 IF (IRSTMNMYFU  >= 9993 ) THEN IRSTMNMYFU  = .;
 IF (IRTRQNM30FQ  >= 91 ) THEN IRTRQNM30FQ  = .;
 IF (IRTRQNMAGE  >= 993 ) THEN IRTRQNMAGE  = .;
 IF (IRTRQNMINIT  >= 91 ) THEN IRTRQNMINIT  = .;
 IF (IRTRQNMYFU  >= 9993 ) THEN IRTRQNMYFU  = .;
 IF (IRWELMOS  >= 99 ) THEN IRWELMOS  = .;
 IF (IRWRKSTAT  >= 99 ) THEN IRWRKSTAT  = .;
 IF (IRWRKSTAT18  >= 99 ) THEN IRWRKSTAT18  = .;
 IF (K6SCMAX  >= . ) THEN K6SCMAX  = .;
 IF (K6SCMON  >= . ) THEN K6SCMON  = .;
 IF (K6SCYR  >= . ) THEN K6SCYR  = .;
 IF (KETMINESK  >= 91 ) THEN KETMINESK  = .;
 IF (KETMINREC  >= 91 ) THEN KETMINREC  = .;
 IF (KIDNYDSAG  >= 985 ) THEN KIDNYDSAG  = .;
 IF (KIDNYDSEV  >= 85 ) THEN KIDNYDSEV  = .;
 IF (LGAS  >= 85 ) THEN LGAS  = .;
 IF (LMIYR_U  >= . ) THEN LMIYR_U  = .;
 IF (LMMISUDPY  >= . ) THEN LMMISUDPY  = .;
 IF (LMMIYRU  >= . ) THEN LMMIYRU  = .;
 IF (LSD  >= 91 ) THEN LSD  = .;
 IF (LSDAGE  >= 985 ) THEN LSDAGE  = .;
 IF (LSDAGLST  >= 985 ) THEN LSDAGLST  = .;
 IF (LSDMFU  >= 85 ) THEN LSDMFU  = .;
 IF (LSDMLU  >= 85 ) THEN LSDMLU  = .;
 IF (LSDREC  >= 91 ) THEN LSDREC  = .;
 IF (LSDYFU  >= 9985 ) THEN LSDYFU  = .;
 IF (LSDYLU  >= 9985 ) THEN LSDYLU  = .;
 IF (MDEIMPY  >= . ) THEN MDEIMPY  = .;
 IF (MEDICARE  >= 85 ) THEN MEDICARE  = .;
 IF (MEDMJALL  >= 91 ) THEN MEDMJALL  = .;
 IF (MEDMJYR  >= 91 ) THEN MEDMJYR  = .;
 IF (MEFQFLG  >= 98 ) THEN MEFQFLG  = .;
 IF (MESC  >= 91 ) THEN MESC  = .;
 IF (METHAGLST  >= 985 ) THEN METHAGLST  = .;
 IF (METHAM30E  >= 91 ) THEN METHAM30E  = .;
 IF (METHAM30N  >= 85 ) THEN METHAM30N  = .;
 IF (METHAMAGE  >= 985 ) THEN METHAMAGE  = .;
 IF (METHAMEVR  >= 85 ) THEN METHAMEVR  = .;
 IF (METHAMMFU  >= 85 ) THEN METHAMMFU  = .;
 IF (METHAMREC  >= 85 ) THEN METHAMREC  = .;
 IF (METHAMYFQ  >= 985 ) THEN METHAMYFQ  = .;
 IF (METHAMYFU  >= 9985 ) THEN METHAMYFU  = .;
 IF (METHCUT1X  >= 85 ) THEN METHCUT1X  = .;
 IF (METHCUTDN  >= 85 ) THEN METHCUTDN  = .;
 IF (METHCUTEV  >= 91 ) THEN METHCUTEV  = .;
 IF (METHDYPMO  >= 85 ) THEN METHDYPMO  = .;
 IF (METHDYPWK  >= 85 ) THEN METHDYPWK  = .;
 IF (METHDYSYR  >= 985 ) THEN METHDYSYR  = .;
 IF (METHEASWY  >= 85 ) THEN METHEASWY  = .;
 IF (METHEMCTD  >= 85 ) THEN METHEMCTD  = .;
 IF (METHEMOPB  >= 85 ) THEN METHEMOPB  = .;
 IF (METHFLBLU  >= 85 ) THEN METHFLBLU  = .;
 IF (METHFMCTD  >= 85 ) THEN METHFMCTD  = .;
 IF (METHFMFPB  >= 85 ) THEN METHFMFPB  = .;
 IF (METHGTOVR  >= 85 ) THEN METHGTOVR  = .;
 IF (METHKPLMT  >= 85 ) THEN METHKPLMT  = .;
 IF (METHLAWTR  >= 85 ) THEN METHLAWTR  = .;
 IF (METHLIMIT  >= 85 ) THEN METHLIMIT  = .;
 IF (METHLOTTM  >= 85 ) THEN METHLOTTM  = .;
 IF (METHLSACT  >= 85 ) THEN METHLSACT  = .;
 IF (METHLSEFX  >= 91 ) THEN METHLSEFX  = .;
 IF (METHMOLST  >= 85 ) THEN METHMOLST  = .;
 IF (METHNDLRC  >= 91 ) THEN METHNDLRC  = .;
 IF (METHNDMOR  >= 85 ) THEN METHNDMOR  = .;
 IF (METHNEEDL  >= 85 ) THEN METHNEEDL  = .;
 IF (METHPDANG  >= 85 ) THEN METHPDANG  = .;
 IF (METHPHCTD  >= 85 ) THEN METHPHCTD  = .;
 IF (METHPHLPB  >= 85 ) THEN METHPHLPB  = .;
 IF (METHSERPB  >= 85 ) THEN METHSERPB  = .;
 IF (METHWD2SX  >= 91 ) THEN METHWD2SX  = .;
 IF (METHWDSMT  >= 91 ) THEN METHWDSMT  = .;
 IF (METHYRLST  >= 9985 ) THEN METHYRLST  = .;
 IF (METOTFG  >= 98 ) THEN METOTFG  = .;
 IF (MHLCLNC3  >= . ) THEN MHLCLNC3  = .;
 IF (MHLDOC3  >= . ) THEN MHLDOC3  = .;
 IF (MHLDTMT3  >= . ) THEN MHLDTMT3  = .;
 IF (MHLMNT3  >= . ) THEN MHLMNT3  = .;
 IF (MHLOTH3  >= . ) THEN MHLOTH3  = .;
 IF (MHLSCHL3  >= . ) THEN MHLSCHL3  = .;
 IF (MHLTHER3  >= . ) THEN MHLTHER3  = .;
 IF (MHPDEMP2  >= . ) THEN MHPDEMP2  = .;
 IF (MHPDFRE2  >= . ) THEN MHPDFRE2  = .;
 IF (MHPDMCD2  >= . ) THEN MHPDMCD2  = .;
 IF (MHPDMCR2  >= . ) THEN MHPDMCR2  = .;
 IF (MHPDMIL2  >= . ) THEN MHPDMIL2  = .;
 IF (MHPDOFM2  >= . ) THEN MHPDOFM2  = .;
 IF (MHPDPHI2  >= . ) THEN MHPDPHI2  = .;
 IF (MHPDPRV2  >= . ) THEN MHPDPRV2  = .;
 IF (MHPDPUB2  >= . ) THEN MHPDPUB2  = .;
 IF (MHPDREH2  >= . ) THEN MHPDREH2  = .;
 IF (MHPDSLF2  >= . ) THEN MHPDSLF2  = .;
 IF (MHRCFID2  >= . ) THEN MHRCFID2  = .;
 IF (MHRCMIT2  >= . ) THEN MHRCMIT2  = .;
 IF (MHRCOST2  >= . ) THEN MHRCOST2  = .;
 IF (MHRENUF2  >= . ) THEN MHRENUF2  = .;
 IF (MHRFOUT2  >= . ) THEN MHRFOUT2  = .;
 IF (MHRHAND2  >= . ) THEN MHRHAND2  = .;
 IF (MHRJOBS2  >= . ) THEN MHRJOBS2  = .;
 IF (MHRNBRS2  >= . ) THEN MHRNBRS2  = .;
 IF (MHRNCOV2  >= . ) THEN MHRNCOV2  = .;
 IF (MHRNOHP2  >= . ) THEN MHRNOHP2  = .;
 IF (MHRNOND2  >= . ) THEN MHRNOND2  = .;
 IF (MHRSOTH2  >= . ) THEN MHRSOTH2  = .;
 IF (MHRTIME2  >= . ) THEN MHRTIME2  = .;
 IF (MHRTRAN2  >= . ) THEN MHRTRAN2  = .;
 IF (MHRWHER2  >= . ) THEN MHRWHER2  = .;
 IF (MHSUIPLN  >= . ) THEN MHSUIPLN  = .;
 IF (MHSUITHK  >= . ) THEN MHSUITHK  = .;
 IF (MHSUITRY  >= . ) THEN MHSUITRY  = .;
 IF (MHSUTK_U  >= . ) THEN MHSUTK_U  = .;
 IF (MILSTAT  >= 85 ) THEN MILSTAT  = .;
 IF (MILTCHLDR  >= 85 ) THEN MILTCHLDR  = .;
 IF (MILTFAMLY  >= 85 ) THEN MILTFAMLY  = .;
 IF (MILTPARNT  >= 85 ) THEN MILTPARNT  = .;
 IF (MILTSIBLN  >= 85 ) THEN MILTSIBLN  = .;
 IF (MILTSPPAR  >= 85 ) THEN MILTSPPAR  = .;
 IF (MI_CAT_U  >= . ) THEN MI_CAT_U  = .;
 IF (MJAGE  >= 985 ) THEN MJAGE  = .;
 IF (MJDAY30A  >= 85 ) THEN MJDAY30A  = .;
 IF (MJEVER  >= 85 ) THEN MJEVER  = .;
 IF (MJFQFLG  >= 98 ) THEN MJFQFLG  = .;
 IF (MJMFU  >= 85 ) THEN MJMFU  = .;
 IF (MJREC  >= 85 ) THEN MJREC  = .;
 IF (MJYFU  >= 9985 ) THEN MJYFU  = .;
 IF (MJYRTOT  >= 985 ) THEN MJYRTOT  = .;
 IF (MMIYR_U  >= . ) THEN MMIYR_U  = .;
 IF (MOVSINPYR2  >= 985 ) THEN MOVSINPYR2  = .;
 IF (MR30EST  >= 91 ) THEN MR30EST  = .;
 IF (MRBSTWAY  >= 85 ) THEN MRBSTWAY  = .;
 IF (MRDAYPMO  >= 85 ) THEN MRDAYPMO  = .;
 IF (MRDAYPWK  >= 85 ) THEN MRDAYPWK  = .;
 IF (MRDAYPYR  >= 985 ) THEN MRDAYPYR  = .;
 IF (MRJAGLST  >= 985 ) THEN MRJAGLST  = .;
 IF (MRJCUTDN  >= 83 ) THEN MRJCUTDN  = .;
 IF (MRJCUTEV  >= 83 ) THEN MRJCUTEV  = .;
 IF (MRJEMCTD  >= 83 ) THEN MRJEMCTD  = .;
 IF (MRJEMOPB  >= 83 ) THEN MRJEMOPB  = .;
 IF (MRJFMCTD  >= 83 ) THEN MRJFMCTD  = .;
 IF (MRJFMFPB  >= 83 ) THEN MRJFMFPB  = .;
 IF (MRJGTOVR  >= 83 ) THEN MRJGTOVR  = .;
 IF (MRJKPLMT  >= 83 ) THEN MRJKPLMT  = .;
 IF (MRJLAWTR  >= 83 ) THEN MRJLAWTR  = .;
 IF (MRJLIMIT  >= 83 ) THEN MRJLIMIT  = .;
 IF (MRJLOTTM  >= 83 ) THEN MRJLOTTM  = .;
 IF (MRJLSACT  >= 83 ) THEN MRJLSACT  = .;
 IF (MRJLSEFX  >= 83 ) THEN MRJLSEFX  = .;
 IF (MRJMLU  >= 85 ) THEN MRJMLU  = .;
 IF (MRJNDMOR  >= 83 ) THEN MRJNDMOR  = .;
 IF (MRJPDANG  >= 83 ) THEN MRJPDANG  = .;
 IF (MRJPHCTD  >= 83 ) THEN MRJPHCTD  = .;
 IF (MRJPHLPB  >= 83 ) THEN MRJPHLPB  = .;
 IF (MRJSERPB  >= 83 ) THEN MRJSERPB  = .;
 IF (MRJYLU  >= 9985 ) THEN MRJYLU  = .;
 IF (MRJYRBFR  >= 85 ) THEN MRJYRBFR  = .;
 IF (MRTOTFG  >= 98 ) THEN MRTOTFG  = .;
 IF (MXMJPNLT  >= 85 ) THEN MXMJPNLT  = .;
 IF (NDMORTALC  >= 91 ) THEN NDMORTALC  = .;
 IF (NDMORTCOC  >= 91 ) THEN NDMORTCOC  = .;
 IF (NDMORTHAL  >= 91 ) THEN NDMORTHAL  = .;
 IF (NDMORTHER  >= 91 ) THEN NDMORTHER  = .;
 IF (NDMORTINH  >= 91 ) THEN NDMORTINH  = .;
 IF (NDMORTMRJ  >= 91 ) THEN NDMORTMRJ  = .;
 IF (NDMORTMTH  >= 91 ) THEN NDMORTMTH  = .;
 IF (NDMORTOTH  >= 91 ) THEN NDMORTOTH  = .;
 IF (NDMORTPNR  >= 91 ) THEN NDMORTPNR  = .;
 IF (NDMORTSED  >= 91 ) THEN NDMORTSED  = .;
 IF (NDMORTSTM  >= 91 ) THEN NDMORTSTM  = .;
 IF (NDMORTTRQ  >= 91 ) THEN NDMORTTRQ  = .;
 IF (NDMORTXYR  >= 91 ) THEN NDMORTXYR  = .;
 IF (NDMRDKWHR  >= 91 ) THEN NDMRDKWHR  = .;
 IF (NDMREFFRT  >= 91 ) THEN NDMREFFRT  = .;
 IF (NDMRFNDOU  >= 91 ) THEN NDMRFNDOU  = .;
 IF (NDMRHANDL  >= 91 ) THEN NDMRHANDL  = .;
 IF (NDMRJOBNG  >= 91 ) THEN NDMRJOBNG  = .;
 IF (NDMRMIMPT  >= 85 ) THEN NDMRMIMPT  = .;
 IF (NDMRNBRNG  >= 91 ) THEN NDMRNBRNG  = .;
 IF (NDMRNOCOV  >= 91 ) THEN NDMRNOCOV  = .;
 IF (NDMRNOHLP  >= 91 ) THEN NDMRNOHLP  = .;
 IF (NDMRNONED  >= 91 ) THEN NDMRNONED  = .;
 IF (NDMRNOTPY  >= 91 ) THEN NDMRNOTPY  = .;
 IF (NDMRNSTOP  >= 91 ) THEN NDMRNSTOP  = .;
 IF (NDMRNTIME  >= 91 ) THEN NDMRNTIME  = .;
 IF (NDMROTRSN  >= 91 ) THEN NDMROTRSN  = .;
 IF (NDMRPFULL  >= 91 ) THEN NDMRPFULL  = .;
 IF (NDMRTSPHR  >= 91 ) THEN NDMRTSPHR  = .;
 IF (NDMRWANTD  >= 91 ) THEN NDMRWANTD  = .;
 IF (NDSSANSP  >= . ) THEN NDSSANSP  = .;
 IF (NDTRNDKWHR  >= . ) THEN NDTRNDKWHR  = .;
 IF (NDTRNFNDOU  >= . ) THEN NDTRNFNDOU  = .;
 IF (NDTRNHANDL  >= . ) THEN NDTRNHANDL  = .;
 IF (NDTRNJOBNG  >= . ) THEN NDTRNJOBNG  = .;
 IF (NDTRNMIMPT  >= . ) THEN NDTRNMIMPT  = .;
 IF (NDTRNNBRNG  >= . ) THEN NDTRNNBRNG  = .;
 IF (NDTRNNOCOV  >= . ) THEN NDTRNNOCOV  = .;
 IF (NDTRNNOHLP  >= . ) THEN NDTRNNOHLP  = .;
 IF (NDTRNNONED  >= . ) THEN NDTRNNONED  = .;
 IF (NDTRNNOTPY  >= . ) THEN NDTRNNOTPY  = .;
 IF (NDTRNNSTOP  >= . ) THEN NDTRNNSTOP  = .;
 IF (NDTRNNTIME  >= . ) THEN NDTRNNTIME  = .;
 IF (NDTRNPFULL  >= . ) THEN NDTRNPFULL  = .;
 IF (NDTRNTSPHR  >= . ) THEN NDTRNTSPHR  = .;
 IF (NDTRNWANTD  >= . ) THEN NDTRNWANTD  = .;
 IF (NDTXDKWHR  >= 91 ) THEN NDTXDKWHR  = .;
 IF (NDTXEFFRT  >= 85 ) THEN NDTXEFFRT  = .;
 IF (NDTXFNDOU  >= 91 ) THEN NDTXFNDOU  = .;
 IF (NDTXHANDL  >= 91 ) THEN NDTXHANDL  = .;
 IF (NDTXJOBNG  >= 91 ) THEN NDTXJOBNG  = .;
 IF (NDTXMIMPT  >= 85 ) THEN NDTXMIMPT  = .;
 IF (NDTXNBRNG  >= 91 ) THEN NDTXNBRNG  = .;
 IF (NDTXNOCOV  >= 91 ) THEN NDTXNOCOV  = .;
 IF (NDTXNOHLP  >= 91 ) THEN NDTXNOHLP  = .;
 IF (NDTXNONED  >= 91 ) THEN NDTXNONED  = .;
 IF (NDTXNOTPY  >= 91 ) THEN NDTXNOTPY  = .;
 IF (NDTXNSTOP  >= 85 ) THEN NDTXNSTOP  = .;
 IF (NDTXNTIME  >= 91 ) THEN NDTXNTIME  = .;
 IF (NDTXOTRSN  >= 91 ) THEN NDTXOTRSN  = .;
 IF (NDTXPFULL  >= 91 ) THEN NDTXPFULL  = .;
 IF (NDTXTSPHR  >= 91 ) THEN NDTXTSPHR  = .;
 IF (NDTXWANTD  >= 91 ) THEN NDTXWANTD  = .;
 IF (NDTXYOTH1  >= 9985 ) THEN NDTXYOTH1  = .;
 IF (NDTXYOTH2  >= 9985 ) THEN NDTXYOTH2  = .;
 IF (NDTXYOTH3  >= 9985 ) THEN NDTXYOTH3  = .;
 IF (NDTXYOTH4  >= 9985 ) THEN NDTXYOTH4  = .;
 IF (NDTXYOTH5  >= 9985 ) THEN NDTXYOTH5  = .;
 IF (NDTXYRADG  >= 85 ) THEN NDTXYRADG  = .;
 IF (NDTXYRALC  >= 91 ) THEN NDTXYRALC  = .;
 IF (NDTXYRCOC  >= 91 ) THEN NDTXYRCOC  = .;
 IF (NDTXYRHAL  >= 91 ) THEN NDTXYRHAL  = .;
 IF (NDTXYRHER  >= 91 ) THEN NDTXYRHER  = .;
 IF (NDTXYRINH  >= 91 ) THEN NDTXYRINH  = .;
 IF (NDTXYRMRJ  >= 91 ) THEN NDTXYRMRJ  = .;
 IF (NDTXYRMTH  >= 91 ) THEN NDTXYRMTH  = .;
 IF (NDTXYROTH  >= 85 ) THEN NDTXYROTH  = .;
 IF (NDTXYRPNR  >= 85 ) THEN NDTXYRPNR  = .;
 IF (NDTXYRSED  >= 85 ) THEN NDTXYRSED  = .;
 IF (NDTXYRSTM  >= 85 ) THEN NDTXYRSTM  = .;
 IF (NDTXYRTRQ  >= 85 ) THEN NDTXYRTRQ  = .;
 IF (NITOXID  >= 85 ) THEN NITOXID  = .;
 IF (NMERTMT2  >= 985 ) THEN NMERTMT2  = .;
 IF (NMNGTHS2  >= 985 ) THEN NMNGTHS2  = .;
 IF (NMVSOEST  >= 94 ) THEN NMVSOEST  = .;
 IF (NMVSOPT2  >= 985 ) THEN NMVSOPT2  = .;
 IF (NOBOOKY2  >= 985 ) THEN NOBOOKY2  = .;
 IF (NOMARR2  >= 94 ) THEN NOMARR2  = .;
 IF (NONABOVEV  >= 85 ) THEN NONABOVEV  = .;
 IF (NRCH17_2  >= . ) THEN NRCH17_2  = .;
 IF (OTCFLAG  >= 98 ) THEN OTCFLAG  = .;
 IF (OTDGNDLA  >= 9985 ) THEN OTDGNDLA  = .;
 IF (OTDGNDLB  >= 9985 ) THEN OTDGNDLB  = .;
 IF (OTDGNDLC  >= 9985 ) THEN OTDGNDLC  = .;
 IF (OTDGNDLD  >= 9985 ) THEN OTDGNDLD  = .;
 IF (OTDGNDLE  >= 9985 ) THEN OTDGNDLE  = .;
 IF (OTDGNDLRC  >= 81 ) THEN OTDGNDLRC  = .;
 IF (OTDGNEDL  >= 94 ) THEN OTDGNEDL  = .;
 IF (OTHAEROS  >= 85 ) THEN OTHAEROS  = .;
 IF (OXCNANYYR  >= 81 ) THEN OXCNANYYR  = .;
 IF (OXCNNMAGE  >= 991 ) THEN OXCNNMAGE  = .;
 IF (OXCNNMMFU  >= 85 ) THEN OXCNNMMFU  = .;
 IF (OXCNNMYFU  >= 9985 ) THEN OXCNNMYFU  = .;
 IF (OXCNNMYR  >= 91 ) THEN OXCNNMYR  = .;
 IF (PARCHKHW  >= . ) THEN PARCHKHW  = .;
 IF (PARHLPHW  >= . ) THEN PARHLPHW  = .;
 IF (PARLMTSN  >= . ) THEN PARLMTSN  = .;
 IF (PAROL  >= . ) THEN PAROL  = .;
 IF (PAROLREL  >= 85 ) THEN PAROLREL  = .;
 IF (PCP  >= 91 ) THEN PCP  = .;
 IF (PCPAGE  >= 985 ) THEN PCPAGE  = .;
 IF (PCPAGLST  >= 985 ) THEN PCPAGLST  = .;
 IF (PCPMFU  >= 85 ) THEN PCPMFU  = .;
 IF (PCPMLU  >= 85 ) THEN PCPMLU  = .;
 IF (PCPREC  >= 91 ) THEN PCPREC  = .;
 IF (PCPYFU  >= 9985 ) THEN PCPYFU  = .;
 IF (PCPYLU  >= 9989 ) THEN PCPYLU  = .;
 IF (PEYOTE  >= 91 ) THEN PEYOTE  = .;
 IF (PIPE30DY  >= 91 ) THEN PIPE30DY  = .;
 IF (PIPEVER  >= 94 ) THEN PIPEVER  = .;
 IF (PNRANYLIF  >= 94 ) THEN PNRANYLIF  = .;
 IF (PNRANYREC  >= 83 ) THEN PNRANYREC  = .;
 IF (PNRLCUT1X  >= 83 ) THEN PNRLCUT1X  = .;
 IF (PNRLCUTDN  >= 83 ) THEN PNRLCUTDN  = .;
 IF (PNRLCUTEV  >= 83 ) THEN PNRLCUTEV  = .;
 IF (PNRLEMCTD  >= 83 ) THEN PNRLEMCTD  = .;
 IF (PNRLEMOPB  >= 83 ) THEN PNRLEMOPB  = .;
 IF (PNRLFMCTD  >= 83 ) THEN PNRLFMCTD  = .;
 IF (PNRLFMFPB  >= 83 ) THEN PNRLFMFPB  = .;
 IF (PNRLGTOVR  >= 83 ) THEN PNRLGTOVR  = .;
 IF (PNRLKPLMT  >= 83 ) THEN PNRLKPLMT  = .;
 IF (PNRLLAWTR  >= 83 ) THEN PNRLLAWTR  = .;
 IF (PNRLLIMIT  >= 83 ) THEN PNRLLIMIT  = .;
 IF (PNRLLOTTM  >= 83 ) THEN PNRLLOTTM  = .;
 IF (PNRLLSACT  >= 83 ) THEN PNRLLSACT  = .;
 IF (PNRLLSEFX  >= 83 ) THEN PNRLLSEFX  = .;
 IF (PNRLNDMOR  >= 83 ) THEN PNRLNDMOR  = .;
 IF (PNRLPDANG  >= 83 ) THEN PNRLPDANG  = .;
 IF (PNRLPHCTD  >= 83 ) THEN PNRLPHCTD  = .;
 IF (PNRLPHLPB  >= 83 ) THEN PNRLPHLPB  = .;
 IF (PNRLSERPB  >= 83 ) THEN PNRLSERPB  = .;
 IF (PNRLWD3SX  >= 83 ) THEN PNRLWD3SX  = .;
 IF (PNRLWDSMT  >= 83 ) THEN PNRLWDSMT  = .;
 IF (PNRMAINRSN  >= . ) THEN PNRMAINRSN  = .;
 IF (PNRNM30AL  >= 83 ) THEN PNRNM30AL  = .;
 IF (PNRNM30D  >= 83 ) THEN PNRNM30D  = .;
 IF (PNRNM30ES  >= 91 ) THEN PNRNM30ES  = .;
 IF (PNRNM30FQ  >= 83 ) THEN PNRNM30FQ  = .;
 IF (PNRNMAGE  >= 983 ) THEN PNRNMAGE  = .;
 IF (PNRNMINIT  >= 83 ) THEN PNRNMINIT  = .;
 IF (PNRNMLAS1  >= 83 ) THEN PNRNMLAS1  = .;
 IF (PNRNMLIF  >= 85 ) THEN PNRNMLIF  = .;
 IF (PNRNMMFU  >= 83 ) THEN PNRNMMFU  = .;
 IF (PNRNMREC  >= 83 ) THEN PNRNMREC  = .;
 IF (PNRNMYFU  >= 9983 ) THEN PNRNMYFU  = .;
 IF (PNRNORXFG  >= 98 ) THEN PNRNORXFG  = .;
 IF (PNRRSDGFX  >= 83 ) THEN PNRRSDGFX  = .;
 IF (PNRRSEMOT  >= 83 ) THEN PNRRSEMOT  = .;
 IF (PNRRSEXPT  >= 83 ) THEN PNRRSEXPT  = .;
 IF (PNRRSHIGH  >= 83 ) THEN PNRRSHIGH  = .;
 IF (PNRRSHOOK  >= 83 ) THEN PNRRSHOOK  = .;
 IF (PNRRSMAIN  >= 83 ) THEN PNRRSMAIN  = .;
 IF (PNRRSOTRS2  >= 983 ) THEN PNRRSOTRS2  = .;
 IF (PNRRSPAIN  >= 83 ) THEN PNRRSPAIN  = .;
 IF (PNRRSRELX  >= 83 ) THEN PNRRSRELX  = .;
 IF (PNRRSSLEP  >= 83 ) THEN PNRRSSLEP  = .;
 IF (PNRRSSOR  >= 83 ) THEN PNRRSSOR  = .;
 IF (PNRWYGAMT  >= 83 ) THEN PNRWYGAMT  = .;
 IF (PNRWYLNGR  >= 83 ) THEN PNRWYLNGR  = .;
 IF (PNRWYNORX  >= 83 ) THEN PNRWYNORX  = .;
 IF (PNRWYOFTN  >= 83 ) THEN PNRWYOFTN  = .;
 IF (PNRWYOTWY  >= 83 ) THEN PNRWYOTWY  = .;
 IF (POVERTY3  >= . ) THEN POVERTY3  = .;
 IF (PRALDLY2  >= . ) THEN PRALDLY2  = .;
 IF (PRBSOLV2  >= . ) THEN PRBSOLV2  = .;
 IF (PRCHORE2  >= . ) THEN PRCHORE2  = .;
 IF (PREG2  >= . ) THEN PREG2  = .;
 IF (PREGNANT  >= 89 ) THEN PREGNANT  = .;
 IF (PREGPGM2  >= . ) THEN PREGPGM2  = .;
 IF (PREVIOL2  >= . ) THEN PREVIOL2  = .;
 IF (PRGDJOB2  >= . ) THEN PRGDJOB2  = .;
 IF (PRLMTTV2  >= . ) THEN PRLMTTV2  = .;
 IF (PRMJEVR2  >= . ) THEN PRMJEVR2  = .;
 IF (PRMJMO  >= . ) THEN PRMJMO  = .;
 IF (PROB  >= . ) THEN PROB  = .;
 IF (PROBATON  >= 85 ) THEN PROBATON  = .;
 IF (PRPKCIG2  >= . ) THEN PRPKCIG2  = .;
 IF (PRPROUD2  >= . ) THEN PRPROUD2  = .;
 IF (PRTALK3  >= . ) THEN PRTALK3  = .;
 IF (PRVDRGO2  >= . ) THEN PRVDRGO2  = .;
 IF (PRVHLTIN  >= 85 ) THEN PRVHLTIN  = .;
 IF (PRXRETRY  >= 94 ) THEN PRXRETRY  = .;
 IF (PRXYDATA  >= 94 ) THEN PRXYDATA  = .;
 IF (PSILCY  >= 91 ) THEN PSILCY  = .;
 IF (RCVMHASPTX  >= . ) THEN RCVMHASPTX  = .;
 IF (RCVMHNSPTX  >= . ) THEN RCVMHNSPTX  = .;
 IF (RCVMHOSPTX  >= . ) THEN RCVMHOSPTX  = .;
 IF (RCVSPTXNMH  >= . ) THEN RCVSPTXNMH  = .;
 IF (RESIDVST  >= . ) THEN RESIDVST  = .;
 IF (RKFQDBLT  >= 94 ) THEN RKFQDBLT  = .;
 IF (RKFQPBLT  >= 94 ) THEN RKFQPBLT  = .;
 IF (RLGATTD  >= . ) THEN RLGATTD  = .;
 IF (RLGDCSN  >= . ) THEN RLGDCSN  = .;
 IF (RLGFRND  >= . ) THEN RLGFRND  = .;
 IF (RLGIMPT  >= . ) THEN RLGIMPT  = .;
 IF (RSKBNGDLY  >= 94 ) THEN RSKBNGDLY  = .;
 IF (RSKBNGWK  >= 94 ) THEN RSKBNGWK  = .;
 IF (RSKCIGPKD  >= 94 ) THEN RSKCIGPKD  = .;
 IF (RSKCOCMON  >= 94 ) THEN RSKCOCMON  = .;
 IF (RSKCOCWK  >= 94 ) THEN RSKCOCWK  = .;
 IF (RSKHERTRY  >= 94 ) THEN RSKHERTRY  = .;
 IF (RSKHERWK  >= 94 ) THEN RSKHERWK  = .;
 IF (RSKLSDTRY  >= 94 ) THEN RSKLSDTRY  = .;
 IF (RSKLSDWK  >= 94 ) THEN RSKLSDWK  = .;
 IF (RSKMRJMON  >= 94 ) THEN RSKMRJMON  = .;
 IF (RSKMRJWK  >= 94 ) THEN RSKMRJWK  = .;
 IF (RSKYFQDGR  >= 94 ) THEN RSKYFQDGR  = .;
 IF (RSKYFQTES  >= 94 ) THEN RSKYFQTES  = .;
 IF (RSNMRJMO  >= 94 ) THEN RSNMRJMO  = .;
 IF (RSNOMRJ  >= 97 ) THEN RSNOMRJ  = .;
 IF (SALVIADIV  >= 91 ) THEN SALVIADIV  = .;
 IF (SALVIAREC  >= 91 ) THEN SALVIAREC  = .;
 IF (SCHFELT  >= . ) THEN SCHFELT  = .;
 IF (SEDANYLIF  >= 94 ) THEN SEDANYLIF  = .;
 IF (SEDANYREC  >= 83 ) THEN SEDANYREC  = .;
 IF (SEDMAINRSN  >= . ) THEN SEDMAINRSN  = .;
 IF (SEDNM30AL  >= 91 ) THEN SEDNM30AL  = .;
 IF (SEDNM30D  >= 83 ) THEN SEDNM30D  = .;
 IF (SEDNM30ES  >= 91 ) THEN SEDNM30ES  = .;
 IF (SEDNM30FQ  >= 83 ) THEN SEDNM30FQ  = .;
 IF (SEDNMAGE  >= 983 ) THEN SEDNMAGE  = .;
 IF (SEDNMINIT  >= 83 ) THEN SEDNMINIT  = .;
 IF (SEDNMLAST  >= 83 ) THEN SEDNMLAST  = .;
 IF (SEDNMLIF  >= 85 ) THEN SEDNMLIF  = .;
 IF (SEDNMMFU  >= 83 ) THEN SEDNMMFU  = .;
 IF (SEDNMREC  >= 83 ) THEN SEDNMREC  = .;
 IF (SEDNMYFU  >= 9983 ) THEN SEDNMYFU  = .;
 IF (SEDNORXFG  >= 98 ) THEN SEDNORXFG  = .;
 IF (SEDRSDGFX  >= 91 ) THEN SEDRSDGFX  = .;
 IF (SEDRSEMOT  >= 83 ) THEN SEDRSEMOT  = .;
 IF (SEDRSEXPT  >= 85 ) THEN SEDRSEXPT  = .;
 IF (SEDRSHIGH  >= 91 ) THEN SEDRSHIGH  = .;
 IF (SEDRSHOOK  >= 91 ) THEN SEDRSHOOK  = .;
 IF (SEDRSMAIN  >= 83 ) THEN SEDRSMAIN  = .;
 IF (SEDRSOTRS2  >= 985 ) THEN SEDRSOTRS2  = .;
 IF (SEDRSRELX  >= 83 ) THEN SEDRSRELX  = .;
 IF (SEDRSSLEP  >= 83 ) THEN SEDRSSLEP  = .;
 IF (SEDRSSOR  >= 91 ) THEN SEDRSSOR  = .;
 IF (SEDVCUT1X  >= 83 ) THEN SEDVCUT1X  = .;
 IF (SEDVCUTDN  >= 83 ) THEN SEDVCUTDN  = .;
 IF (SEDVCUTEV  >= 83 ) THEN SEDVCUTEV  = .;
 IF (SEDVEMCTD  >= 83 ) THEN SEDVEMCTD  = .;
 IF (SEDVEMOPB  >= 83 ) THEN SEDVEMOPB  = .;
 IF (SEDVFMCTD  >= 83 ) THEN SEDVFMCTD  = .;
 IF (SEDVFMFPB  >= 83 ) THEN SEDVFMFPB  = .;
 IF (SEDVGTOVR  >= 83 ) THEN SEDVGTOVR  = .;
 IF (SEDVKPLMT  >= 83 ) THEN SEDVKPLMT  = .;
 IF (SEDVLAWTR  >= 83 ) THEN SEDVLAWTR  = .;
 IF (SEDVLIMIT  >= 83 ) THEN SEDVLIMIT  = .;
 IF (SEDVLOTTM  >= 83 ) THEN SEDVLOTTM  = .;
 IF (SEDVLSACT  >= 83 ) THEN SEDVLSACT  = .;
 IF (SEDVLSEFX  >= 83 ) THEN SEDVLSEFX  = .;
 IF (SEDVNDMOR  >= 83 ) THEN SEDVNDMOR  = .;
 IF (SEDVPDANG  >= 83 ) THEN SEDVPDANG  = .;
 IF (SEDVPHCTD  >= 83 ) THEN SEDVPHCTD  = .;
 IF (SEDVPHLPB  >= 83 ) THEN SEDVPHLPB  = .;
 IF (SEDVSERPB  >= 83 ) THEN SEDVSERPB  = .;
 IF (SEDVWD1SX  >= 83 ) THEN SEDVWD1SX  = .;
 IF (SEDVWDSMT  >= 83 ) THEN SEDVWDSMT  = .;
 IF (SEDWYGAMT  >= 83 ) THEN SEDWYGAMT  = .;
 IF (SEDWYLNGR  >= 85 ) THEN SEDWYLNGR  = .;
 IF (SEDWYNORX  >= 83 ) THEN SEDWYNORX  = .;
 IF (SEDWYOFTN  >= 83 ) THEN SEDWYOFTN  = .;
 IF (SEDWYOTWY  >= 83 ) THEN SEDWYOTWY  = .;
 IF (SERVICE  >= 85 ) THEN SERVICE  = .;
 IF (SEXATRACT  >= 89 ) THEN SEXATRACT  = .;
 IF (SEXIDENT  >= 89 ) THEN SEXIDENT  = .;
 IF (SHSWANGR  >= . ) THEN SHSWANGR  = .;
 IF (SHSWBRK  >= . ) THEN SHSWBRK  = .;
 IF (SHSWDPR  >= . ) THEN SHSWDPR  = .;
 IF (SHSWEAT  >= . ) THEN SHSWEAT  = .;
 IF (SHSWFEA  >= . ) THEN SHSWFEA  = .;
 IF (SHSWFITE  >= . ) THEN SHSWFITE  = .;
 IF (SHSWFMLY  >= . ) THEN SHSWFMLY  = .;
 IF (SHSWFRND  >= . ) THEN SHSWFRND  = .;
 IF (SHSWMEND  >= . ) THEN SHSWMEND  = .;
 IF (SHSWOTH2  >= . ) THEN SHSWOTH2  = .;
 IF (SHSWOTPP  >= . ) THEN SHSWOTPP  = .;
 IF (SHSWSCHL  >= . ) THEN SHSWSCHL  = .;
 IF (SHSWSUI  >= . ) THEN SHSWSUI  = .;
 IF (SIMHANG2  >= . ) THEN SIMHANG2  = .;
 IF (SIMHBRK2  >= . ) THEN SIMHBRK2  = .;
 IF (SIMHDPR2  >= . ) THEN SIMHDPR2  = .;
 IF (SIMHEAT2  >= . ) THEN SIMHEAT2  = .;
 IF (SIMHFEA2  >= . ) THEN SIMHFEA2  = .;
 IF (SIMHFIT2  >= . ) THEN SIMHFIT2  = .;
 IF (SIMHFML2  >= . ) THEN SIMHFML2  = .;
 IF (SIMHFRD2  >= . ) THEN SIMHFRD2  = .;
 IF (SIMHMEN2  >= . ) THEN SIMHMEN2  = .;
 IF (SIMHOTH3  >= . ) THEN SIMHOTH3  = .;
 IF (SIMHOTP2  >= . ) THEN SIMHOTP2  = .;
 IF (SIMHSCH2  >= . ) THEN SIMHSCH2  = .;
 IF (SIMHSUI2  >= . ) THEN SIMHSUI2  = .;
 IF (SMHANGR2  >= . ) THEN SMHANGR2  = .;
 IF (SMHBRK2  >= . ) THEN SMHBRK2  = .;
 IF (SMHDPR2  >= . ) THEN SMHDPR2  = .;
 IF (SMHEAT2  >= . ) THEN SMHEAT2  = .;
 IF (SMHFEA2  >= . ) THEN SMHFEA2  = .;
 IF (SMHFITE2  >= . ) THEN SMHFITE2  = .;
 IF (SMHFMLY2  >= . ) THEN SMHFMLY2  = .;
 IF (SMHFRND2  >= . ) THEN SMHFRND2  = .;
 IF (SMHMEND2  >= . ) THEN SMHMEND2  = .;
 IF (SMHOTH3  >= . ) THEN SMHOTH3  = .;
 IF (SMHOTPP2  >= . ) THEN SMHOTPP2  = .;
 IF (SMHSCHL2  >= . ) THEN SMHSCHL2  = .;
 IF (SMHSUI2  >= . ) THEN SMHSUI2  = .;
 IF (SMHVST2  >= . ) THEN SMHVST2  = .;
 IF (SMIPP_U  >= . ) THEN SMIPP_U  = .;
 IF (SMISUDPY  >= . ) THEN SMISUDPY  = .;
 IF (SMIYR_U  >= . ) THEN SMIYR_U  = .;
 IF (SMKAGLAST  >= 985 ) THEN SMKAGLAST  = .;
 IF (SMKLSS30E  >= 91 ) THEN SMKLSS30E  = .;
 IF (SMKLSS30N  >= 91 ) THEN SMKLSS30N  = .;
 IF (SMKLSSEVR  >= 94 ) THEN SMKLSSEVR  = .;
 IF (SMKLSSMFU  >= 85 ) THEN SMKLSSMFU  = .;
 IF (SMKLSSREC  >= 91 ) THEN SMKLSSREC  = .;
 IF (SMKLSSTRY  >= 985 ) THEN SMKLSSTRY  = .;
 IF (SMKLSSYFU  >= 9985 ) THEN SMKLSSYFU  = .;
 IF (SMKMOLAST  >= 85 ) THEN SMKMOLAST  = .;
 IF (SMKYRLAST  >= 9985 ) THEN SMKYRLAST  = .;
 IF (SMMIYR_U  >= . ) THEN SMMIYR_U  = .;
 IF (SNFAMJEV  >= 85 ) THEN SNFAMJEV  = .;
 IF (SNRLDCSN  >= 85 ) THEN SNRLDCSN  = .;
 IF (SNRLFRND  >= 85 ) THEN SNRLFRND  = .;
 IF (SNRLGIMP  >= 85 ) THEN SNRLGIMP  = .;
 IF (SNRLGSVC  >= 85 ) THEN SNRLGSVC  = .;
 IF (SNYATTAK  >= 85 ) THEN SNYATTAK  = .;
 IF (SNYSELL  >= 85 ) THEN SNYSELL  = .;
 IF (SNYSTOLE  >= 85 ) THEN SNYSTOLE  = .;
 IF (SOLVENT  >= 85 ) THEN SOLVENT  = .;
 IF (SOMHANGR  >= . ) THEN SOMHANGR  = .;
 IF (SOMHBRK  >= . ) THEN SOMHBRK  = .;
 IF (SOMHDPR  >= . ) THEN SOMHDPR  = .;
 IF (SOMHEAT  >= . ) THEN SOMHEAT  = .;
 IF (SOMHFEA  >= . ) THEN SOMHFEA  = .;
 IF (SOMHFITE  >= . ) THEN SOMHFITE  = .;
 IF (SOMHFMLY  >= . ) THEN SOMHFMLY  = .;
 IF (SOMHFRND  >= . ) THEN SOMHFRND  = .;
 IF (SOMHMEND  >= . ) THEN SOMHMEND  = .;
 IF (SOMHOTH2  >= . ) THEN SOMHOTH2  = .;
 IF (SOMHOTPP  >= . ) THEN SOMHOTPP  = .;
 IF (SOMHSCHL  >= . ) THEN SOMHSCHL  = .;
 IF (SOMHSUI  >= . ) THEN SOMHSUI  = .;
 IF (SPDMON  >= . ) THEN SPDMON  = .;
 IF (SPDYR  >= . ) THEN SPDYR  = .;
 IF (SPEAKENGL  >= 85 ) THEN SPEAKENGL  = .;
 IF (SPINVST2  >= . ) THEN SPINVST2  = .;
 IF (SPOUTVST  >= . ) THEN SPOUTVST  = .;
 IF (SPPAINT  >= 85 ) THEN SPPAINT  = .;
 IF (SRCCLFRPNR  >= . ) THEN SRCCLFRPNR  = .;
 IF (SRCCLFRSED  >= . ) THEN SRCCLFRSED  = .;
 IF (SRCCLFRSTM  >= . ) THEN SRCCLFRSTM  = .;
 IF (SRCCLFRTRQ  >= . ) THEN SRCCLFRTRQ  = .;
 IF (SRCFRPNRNM  >= . ) THEN SRCFRPNRNM  = .;
 IF (SRCFRSEDNM  >= . ) THEN SRCFRSEDNM  = .;
 IF (SRCFRSTMNM  >= . ) THEN SRCFRSTMNM  = .;
 IF (SRCFRTRQNM  >= . ) THEN SRCFRTRQNM  = .;
 IF (SRCPNRNM2  >= . ) THEN SRCPNRNM2  = .;
 IF (SRCSEDNM2  >= . ) THEN SRCSEDNM2  = .;
 IF (SRCSTMNM2  >= . ) THEN SRCSTMNM2  = .;
 IF (SRCTRQNM2  >= . ) THEN SRCTRQNM2  = .;
 IF (STDANYYR  >= 85 ) THEN STDANYYR  = .;
 IF (STIMCUT1X  >= 83 ) THEN STIMCUT1X  = .;
 IF (STIMCUTDN  >= 83 ) THEN STIMCUTDN  = .;
 IF (STIMCUTEV  >= 83 ) THEN STIMCUTEV  = .;
 IF (STIMEMCTD  >= 83 ) THEN STIMEMCTD  = .;
 IF (STIMEMOPB  >= 83 ) THEN STIMEMOPB  = .;
 IF (STIMFLBLU  >= 83 ) THEN STIMFLBLU  = .;
 IF (STIMFMCTD  >= 83 ) THEN STIMFMCTD  = .;
 IF (STIMFMFPB  >= 83 ) THEN STIMFMFPB  = .;
 IF (STIMGTOVR  >= 83 ) THEN STIMGTOVR  = .;
 IF (STIMKPLMT  >= 83 ) THEN STIMKPLMT  = .;
 IF (STIMLAWTR  >= 83 ) THEN STIMLAWTR  = .;
 IF (STIMLIMIT  >= 83 ) THEN STIMLIMIT  = .;
 IF (STIMLOTTM  >= 83 ) THEN STIMLOTTM  = .;
 IF (STIMLSACT  >= 83 ) THEN STIMLSACT  = .;
 IF (STIMLSEFX  >= 83 ) THEN STIMLSEFX  = .;
 IF (STIMNDMOR  >= 83 ) THEN STIMNDMOR  = .;
 IF (STIMPDANG  >= 83 ) THEN STIMPDANG  = .;
 IF (STIMPHCTD  >= 83 ) THEN STIMPHCTD  = .;
 IF (STIMPHLPB  >= 83 ) THEN STIMPHLPB  = .;
 IF (STIMSERPB  >= 83 ) THEN STIMSERPB  = .;
 IF (STIMWD2SX  >= 83 ) THEN STIMWD2SX  = .;
 IF (STIMWDSMT  >= 83 ) THEN STIMWDSMT  = .;
 IF (STMANYLIF  >= 94 ) THEN STMANYLIF  = .;
 IF (STMANYREC  >= 83 ) THEN STMANYREC  = .;
 IF (STMMAINRSN  >= . ) THEN STMMAINRSN  = .;
 IF (STMNDLREC  >= 85 ) THEN STMNDLREC  = .;
 IF (STMNDLYR  >= 83 ) THEN STMNDLYR  = .;
 IF (STMNM30AL  >= 83 ) THEN STMNM30AL  = .;
 IF (STMNM30D  >= 83 ) THEN STMNM30D  = .;
 IF (STMNM30ES  >= 91 ) THEN STMNM30ES  = .;
 IF (STMNM30FQ  >= 83 ) THEN STMNM30FQ  = .;
 IF (STMNMAGE  >= 983 ) THEN STMNMAGE  = .;
 IF (STMNMINIT  >= 83 ) THEN STMNMINIT  = .;
 IF (STMNMLAS1  >= 83 ) THEN STMNMLAS1  = .;
 IF (STMNMLIF  >= 85 ) THEN STMNMLIF  = .;
 IF (STMNMMFU  >= 83 ) THEN STMNMMFU  = .;
 IF (STMNMREC  >= 83 ) THEN STMNMREC  = .;
 IF (STMNMYFU  >= 9983 ) THEN STMNMYFU  = .;
 IF (STMNORXFG  >= 98 ) THEN STMNORXFG  = .;
 IF (STMRSALRT  >= 83 ) THEN STMRSALRT  = .;
 IF (STMRSCONC  >= 83 ) THEN STMRSCONC  = .;
 IF (STMRSDGFX  >= 83 ) THEN STMRSDGFX  = .;
 IF (STMRSEXPT  >= 91 ) THEN STMRSEXPT  = .;
 IF (STMRSHIGH  >= 85 ) THEN STMRSHIGH  = .;
 IF (STMRSHOOK  >= 85 ) THEN STMRSHOOK  = .;
 IF (STMRSMAIN  >= 83 ) THEN STMRSMAIN  = .;
 IF (STMRSOTRS2  >= 985 ) THEN STMRSOTRS2  = .;
 IF (STMRSSOR  >= 91 ) THEN STMRSSOR  = .;
 IF (STMRSSTDY  >= 91 ) THEN STMRSSTDY  = .;
 IF (STMRSWGHT  >= 83 ) THEN STMRSWGHT  = .;
 IF (STMWYGAMT  >= 83 ) THEN STMWYGAMT  = .;
 IF (STMWYLNGR  >= 83 ) THEN STMWYLNGR  = .;
 IF (STMWYNORX  >= 83 ) THEN STMWYNORX  = .;
 IF (STMWYOFTN  >= 83 ) THEN STMWYOFTN  = .;
 IF (STMWYOTWY  >= 83 ) THEN STMWYOTWY  = .;
 IF (STNDALC  >= . ) THEN STNDALC  = .;
 IF (STNDDNK  >= . ) THEN STNDDNK  = .;
 IF (STNDSCIG  >= . ) THEN STNDSCIG  = .;
 IF (STNDSMJ  >= . ) THEN STNDSMJ  = .;
 IF (SUICPLAN  >= 85 ) THEN SUICPLAN  = .;
 IF (SUICTHNK  >= 85 ) THEN SUICTHNK  = .;
 IF (SUICTRY  >= 85 ) THEN SUICTRY  = .;
 IF (TALKPROB  >= . ) THEN TALKPROB  = .;
 IF (TCHGJOB  >= . ) THEN TCHGJOB  = .;
 IF (THERVST  >= . ) THEN THERVST  = .;
 IF (TOOLONG  >= 98 ) THEN TOOLONG  = .;
 IF (TRIMEST  >= . ) THEN TRIMEST  = .;
 IF (TROUBUND  >= 98 ) THEN TROUBUND  = .;
 IF (TRQANYLIF  >= 94 ) THEN TRQANYLIF  = .;
 IF (TRQANYREC  >= 83 ) THEN TRQANYREC  = .;
 IF (TRQLCUTDN  >= 83 ) THEN TRQLCUTDN  = .;
 IF (TRQLCUTEV  >= 83 ) THEN TRQLCUTEV  = .;
 IF (TRQLEMCTD  >= 83 ) THEN TRQLEMCTD  = .;
 IF (TRQLEMOPB  >= 83 ) THEN TRQLEMOPB  = .;
 IF (TRQLFMCTD  >= 83 ) THEN TRQLFMCTD  = .;
 IF (TRQLFMFPB  >= 83 ) THEN TRQLFMFPB  = .;
 IF (TRQLGTOVR  >= 83 ) THEN TRQLGTOVR  = .;
 IF (TRQLKPLMT  >= 83 ) THEN TRQLKPLMT  = .;
 IF (TRQLLAWTR  >= 83 ) THEN TRQLLAWTR  = .;
 IF (TRQLLIMIT  >= 83 ) THEN TRQLLIMIT  = .;
 IF (TRQLLOTTM  >= 83 ) THEN TRQLLOTTM  = .;
 IF (TRQLLSACT  >= 83 ) THEN TRQLLSACT  = .;
 IF (TRQLLSEFT  >= 83 ) THEN TRQLLSEFT  = .;
 IF (TRQLNDMOR  >= 83 ) THEN TRQLNDMOR  = .;
 IF (TRQLPDANG  >= 83 ) THEN TRQLPDANG  = .;
 IF (TRQLPHCTD  >= 83 ) THEN TRQLPHCTD  = .;
 IF (TRQLPHLPB  >= 83 ) THEN TRQLPHLPB  = .;
 IF (TRQLSERPB  >= 83 ) THEN TRQLSERPB  = .;
 IF (TRQMAINRSN  >= . ) THEN TRQMAINRSN  = .;
 IF (TRQNM30AL  >= 91 ) THEN TRQNM30AL  = .;
 IF (TRQNM30D  >= 83 ) THEN TRQNM30D  = .;
 IF (TRQNM30ES  >= 91 ) THEN TRQNM30ES  = .;
 IF (TRQNM30FQ  >= 83 ) THEN TRQNM30FQ  = .;
 IF (TRQNMAGE  >= 983 ) THEN TRQNMAGE  = .;
 IF (TRQNMINIT  >= 83 ) THEN TRQNMINIT  = .;
 IF (TRQNMLAS1  >= 83 ) THEN TRQNMLAS1  = .;
 IF (TRQNMLIF  >= 85 ) THEN TRQNMLIF  = .;
 IF (TRQNMMFU  >= 83 ) THEN TRQNMMFU  = .;
 IF (TRQNMREC  >= 83 ) THEN TRQNMREC  = .;
 IF (TRQNMYFU  >= 9983 ) THEN TRQNMYFU  = .;
 IF (TRQNORXFG  >= 98 ) THEN TRQNORXFG  = .;
 IF (TRQRSDGFX  >= 83 ) THEN TRQRSDGFX  = .;
 IF (TRQRSEMOT  >= 83 ) THEN TRQRSEMOT  = .;
 IF (TRQRSEXPT  >= 83 ) THEN TRQRSEXPT  = .;
 IF (TRQRSHIGH  >= 83 ) THEN TRQRSHIGH  = .;
 IF (TRQRSHOOK  >= 83 ) THEN TRQRSHOOK  = .;
 IF (TRQRSMAIN  >= 91 ) THEN TRQRSMAIN  = .;
 IF (TRQRSOTRS2  >= 985 ) THEN TRQRSOTRS2  = .;
 IF (TRQRSRELX  >= 83 ) THEN TRQRSRELX  = .;
 IF (TRQRSSLEP  >= 83 ) THEN TRQRSSLEP  = .;
 IF (TRQRSSOR  >= 83 ) THEN TRQRSSOR  = .;
 IF (TRQWYGAMT  >= 83 ) THEN TRQWYGAMT  = .;
 IF (TRQWYLNGR  >= 83 ) THEN TRQWYLNGR  = .;
 IF (TRQWYNORX  >= 83 ) THEN TRQWYNORX  = .;
 IF (TRQWYOFTN  >= 83 ) THEN TRQWYOFTN  = .;
 IF (TRQWYOTWY  >= 83 ) THEN TRQWYOTWY  = .;
 IF (TXALCDAGE  >= 991 ) THEN TXALCDAGE  = .;
 IF (TXALCDRGU  >= 91 ) THEN TXALCDRGU  = .;
 IF (TXALCONAG  >= 991 ) THEN TXALCONAG  = .;
 IF (TXALCONLY  >= 91 ) THEN TXALCONLY  = .;
 IF (TXCURRENT  >= 85 ) THEN TXCURRENT  = .;
 IF (TXDRGAAGE  >= 991 ) THEN TXDRGAAGE  = .;
 IF (TXDRGALCU  >= 91 ) THEN TXDRGALCU  = .;
 IF (TXDRGONAG  >= 991 ) THEN TXDRGONAG  = .;
 IF (TXDRGONLY  >= 91 ) THEN TXDRGONLY  = .;
 IF (TXENRLOCT  >= 91 ) THEN TXENRLOCT  = .;
 IF (TXEVRRCVD  >= 85 ) THEN TXEVRRCVD  = .;
 IF (TXFGADAGE  >= 91 ) THEN TXFGADAGE  = .;
 IF (TXFGALAGE  >= 91 ) THEN TXFGALAGE  = .;
 IF (TXFGDGAGE  >= 91 ) THEN TXFGDGAGE  = .;
 IF (TXLTYALCO  >= 85 ) THEN TXLTYALCO  = .;
 IF (TXLTYCOCN  >= 91 ) THEN TXLTYCOCN  = .;
 IF (TXLTYDAYS2  >= 99985 ) THEN TXLTYDAYS2  = .;
 IF (TXLTYHALL  >= 89 ) THEN TXLTYHALL  = .;
 IF (TXLTYHERN  >= 91 ) THEN TXLTYHERN  = .;
 IF (TXLTYINHL  >= 89 ) THEN TXLTYINHL  = .;
 IF (TXLTYMAIN2  >= 85 ) THEN TXLTYMAIN2  = .;
 IF (TXLTYMETH  >= 91 ) THEN TXLTYMETH  = .;
 IF (TXLTYMNPL2  >= 985 ) THEN TXLTYMNPL2  = .;
 IF (TXLTYMRJH  >= 85 ) THEN TXLTYMRJH  = .;
 IF (TXLTYOCOM2  >= 85 ) THEN TXLTYOCOM2  = .;
 IF (TXLTYOTHR  >= 85 ) THEN TXLTYOTHR  = .;
 IF (TXLTYPNRL  >= 89 ) THEN TXLTYPNRL  = .;
 IF (TXLTYSEDV  >= 91 ) THEN TXLTYSEDV  = .;
 IF (TXLTYSTIM  >= 91 ) THEN TXLTYSTIM  = .;
 IF (TXLTYTRQL  >= 91 ) THEN TXLTYTRQL  = .;
 IF (TXPAYBOSS  >= 85 ) THEN TXPAYBOSS  = .;
 IF (TXPAYCOUR  >= 85 ) THEN TXPAYCOUR  = .;
 IF (TXPAYFAML  >= 85 ) THEN TXPAYFAML  = .;
 IF (TXPAYFREE  >= 91 ) THEN TXPAYFREE  = .;
 IF (TXPAYHINS  >= 85 ) THEN TXPAYHINS  = .;
 IF (TXPAYMCAD  >= 85 ) THEN TXPAYMCAD  = .;
 IF (TXPAYMCRE  >= 85 ) THEN TXPAYMCRE  = .;
 IF (TXPAYMILT  >= 85 ) THEN TXPAYMILT  = .;
 IF (TXPAYOTHR  >= 85 ) THEN TXPAYOTHR  = .;
 IF (TXPAYOTSP2  >= 85 ) THEN TXPAYOTSP2  = .;
 IF (TXPAYPUBL  >= 85 ) THEN TXPAYPUBL  = .;
 IF (TXPAYSVNG  >= 85 ) THEN TXPAYSVNG  = .;
 IF (TXRCVDREC  >= 91 ) THEN TXRCVDREC  = .;
 IF (TXSHGALDB  >= 91 ) THEN TXSHGALDB  = .;
 IF (TXSHGFLAG  >= 91 ) THEN TXSHGFLAG  = .;
 IF (TXSHGWENT  >= 85 ) THEN TXSHGWENT  = .;
 IF (TXYALDAAG  >= 991 ) THEN TXYALDAAG  = .;
 IF (TXYALDDAG  >= 985 ) THEN TXYALDDAG  = .;
 IF (TXYALODAG  >= 985 ) THEN TXYALODAG  = .;
 IF (TXYALODRG  >= 91 ) THEN TXYALODRG  = .;
 IF (TXYALONAG  >= 985 ) THEN TXYALONAG  = .;
 IF (TXYDROAAG  >= 991 ) THEN TXYDROAAG  = .;
 IF (TXYDROALC  >= 91 ) THEN TXYDROALC  = .;
 IF (TXYDRONAG  >= 985 ) THEN TXYDRONAG  = .;
 IF (TXYRALDGB  >= 85 ) THEN TXYRALDGB  = .;
 IF (TXYRDRPAD  >= 91 ) THEN TXYRDRPAD  = .;
 IF (TXYRDRPRV  >= 85 ) THEN TXYRDRPRV  = .;
 IF (TXYREMRAD  >= 91 ) THEN TXYREMRAD  = .;
 IF (TXYREMRGN  >= 85 ) THEN TXYREMRGN  = .;
 IF (TXYRERDRG  >= 85 ) THEN TXYRERDRG  = .;
 IF (TXYRERNUM2  >= 985 ) THEN TXYRERNUM2  = .;
 IF (TXYRHOSAD  >= 91 ) THEN TXYRHOSAD  = .;
 IF (TXYRHOSOV  >= 85 ) THEN TXYRHOSOV  = .;
 IF (TXYRMHCAD  >= 91 ) THEN TXYRMHCAD  = .;
 IF (TXYRMHCOP  >= 85 ) THEN TXYRMHCOP  = .;
 IF (TXYRONDTX  >= 91 ) THEN TXYRONDTX  = .;
 IF (TXYROTHAD  >= 91 ) THEN TXYROTHAD  = .;
 IF (TXYROTHER  >= 85 ) THEN TXYROTHER  = .;
 IF (TXYROTHSP2  >= 985 ) THEN TXYROTHSP2  = .;
 IF (TXYROUTAD  >= 91 ) THEN TXYROUTAD  = .;
 IF (TXYROUTPT  >= 85 ) THEN TXYROUTPT  = .;
 IF (TXYRPRIAD  >= 91 ) THEN TXYRPRIAD  = .;
 IF (TXYRPRISN  >= 85 ) THEN TXYRPRISN  = .;
 IF (TXYRRECVD  >= 91 ) THEN TXYRRECVD  = .;
 IF (TXYRRESAD  >= 91 ) THEN TXYRRESAD  = .;
 IF (TXYRRESOV  >= 85 ) THEN TXYRRESOV  = .;
 IF (TXYRSLFAD  >= 91 ) THEN TXYRSLFAD  = .;
 IF (TXYRSLFHP  >= 85 ) THEN TXYRSLFHP  = .;
 IF (UADBAR  >= . ) THEN UADBAR  = .;
 IF (UADBUND  >= . ) THEN UADBUND  = .;
 IF (UADBWHO  >= . ) THEN UADBWHO  = .;
 IF (UADCAG  >= . ) THEN UADCAG  = .;
 IF (UADCAR  >= . ) THEN UADCAR  = .;
 IF (UADEVNT  >= . ) THEN UADEVNT  = .;
 IF (UADFRD  >= . ) THEN UADFRD  = .;
 IF (UADFWHO  >= . ) THEN UADFWHO  = .;
 IF (UADHOME  >= . ) THEN UADHOME  = .;
 IF (UADMONY  >= . ) THEN UADMONY  = .;
 IF (UADOTHM  >= . ) THEN UADOTHM  = .;
 IF (UADOTSP  >= . ) THEN UADOTSP  = .;
 IF (UADPAID  >= . ) THEN UADPAID  = .;
 IF (UADPEOP  >= . ) THEN UADPEOP  = .;
 IF (UADPLACE  >= . ) THEN UADPLACE  = .;
 IF (UADPUBL  >= . ) THEN UADPUBL  = .;
 IF (UADROTH  >= . ) THEN UADROTH  = .;
 IF (UADSCHL  >= . ) THEN UADSCHL  = .;
 IF (WHODASC2  >= . ) THEN WHODASC2  = .;
 IF (WHODASC3  >= . ) THEN WHODASC3  = .;
 IF (WRK35WKUS  >= 85 ) THEN WRK35WKUS  = .;
 IF (WRKDHRSWK2  >= 985 ) THEN WRKDHRSWK2  = .;
 IF (WRKDPSTWK  >= 85 ) THEN WRKDPSTWK  = .;
 IF (WRKDPSTYR  >= 94 ) THEN WRKDPSTYR  = .;
 IF (WRKDRGALB  >= 85 ) THEN WRKDRGALB  = .;
 IF (WRKDRGEDU  >= 85 ) THEN WRKDRGEDU  = .;
 IF (WRKDRGHLP  >= 85 ) THEN WRKDRGHLP  = .;
 IF (WRKDRGPOL  >= 85 ) THEN WRKDRGPOL  = .;
 IF (WRKEFFORT  >= 94 ) THEN WRKEFFORT  = .;
 IF (WRKHADJOB  >= 94 ) THEN WRKHADJOB  = .;
 IF (WRKLASTYR2  >= 9985 ) THEN WRKLASTYR2  = .;
 IF (WRKNJBPYR  >= 85 ) THEN WRKNJBPYR  = .;
 IF (WRKNJBWKS  >= 85 ) THEN WRKNJBWKS  = .;
 IF (WRKNUMJOB2  >= 85 ) THEN WRKNUMJOB2  = .;
 IF (WRKOKPREH  >= 85 ) THEN WRKOKPREH  = .;
 IF (WRKOKRAND  >= 85 ) THEN WRKOKRAND  = .;
 IF (WRKRSNJOB  >= 994 ) THEN WRKRSNJOB  = .;
 IF (WRKRSNNOT  >= 994 ) THEN WRKRSNNOT  = .;
 IF (WRKSELFEM  >= 85 ) THEN WRKSELFEM  = .;
 IF (WRKSICKMO  >= 85 ) THEN WRKSICKMO  = .;
 IF (WRKSKIPMO  >= 85 ) THEN WRKSKIPMO  = .;
 IF (WRKSTATWK2  >= 98 ) THEN WRKSTATWK2  = .;
 IF (WRKTST1ST  >= 85 ) THEN WRKTST1ST  = .;
 IF (WRKTSTALC  >= 85 ) THEN WRKTSTALC  = .;
 IF (WRKTSTDRG  >= 85 ) THEN WRKTSTDRG  = .;
 IF (WRKTSTHIR  >= 85 ) THEN WRKTSTHIR  = .;
 IF (WRKTSTRDM  >= 85 ) THEN WRKTSTRDM  = .;
 IF (WSPDSC2  >= . ) THEN WSPDSC2  = .;
 IF (WTANSWER  >= 94 ) THEN WTANSWER  = .;
 IF (WTPOUND2  >= 9985 ) THEN WTPOUND2  = .;
 IF (YALTMDE  >= . ) THEN YALTMDE  = .;
 IF (YCLIN  >= . ) THEN YCLIN  = .;
 IF (YCOUNMDE  >= . ) THEN YCOUNMDE  = .;
 IF (YDAYTRT  >= . ) THEN YDAYTRT  = .;
 IF (YDOCMDE  >= . ) THEN YDOCMDE  = .;
 IF (YEATNDYR  >= 85 ) THEN YEATNDYR  = .;
 IF (YECOMACT  >= 85 ) THEN YECOMACT  = .;
 IF (YEDECLAS  >= 85 ) THEN YEDECLAS  = .;
 IF (YEDERGLR  >= 85 ) THEN YEDERGLR  = .;
 IF (YEDESPCL  >= 85 ) THEN YEDESPCL  = .;
 IF (YEDGPRGP  >= 85 ) THEN YEDGPRGP  = .;
 IF (YEFAIACT  >= 85 ) THEN YEFAIACT  = .;
 IF (YEFALDLY  >= 85 ) THEN YEFALDLY  = .;
 IF (YEFMJEVR  >= 85 ) THEN YEFMJEVR  = .;
 IF (YEFMJMO  >= 85 ) THEN YEFMJMO  = .;
 IF (YEFPKCIG  >= 85 ) THEN YEFPKCIG  = .;
 IF (YEGALDLY  >= 85 ) THEN YEGALDLY  = .;
 IF (YEGMJEVR  >= 85 ) THEN YEGMJEVR  = .;
 IF (YEGMJMO  >= 85 ) THEN YEGMJMO  = .;
 IF (YEGPKCIG  >= 85 ) THEN YEGPKCIG  = .;
 IF (YEHMSLYR  >= 85 ) THEN YEHMSLYR  = .;
 IF (YELSTGRD  >= 85 ) THEN YELSTGRD  = .;
 IF (YEOTHACT  >= 85 ) THEN YEOTHACT  = .;
 IF (YEPALDLY  >= 85 ) THEN YEPALDLY  = .;
 IF (YEPCHKHW  >= 85 ) THEN YEPCHKHW  = .;
 IF (YEPCHORE  >= 85 ) THEN YEPCHORE  = .;
 IF (YEPGDJOB  >= 85 ) THEN YEPGDJOB  = .;
 IF (YEPHLPHW  >= 85 ) THEN YEPHLPHW  = .;
 IF (YEPLMTSN  >= 85 ) THEN YEPLMTSN  = .;
 IF (YEPLMTTV  >= 85 ) THEN YEPLMTTV  = .;
 IF (YEPMJEVR  >= 85 ) THEN YEPMJEVR  = .;
 IF (YEPMJMO  >= 85 ) THEN YEPMJMO  = .;
 IF (YEPPKCIG  >= 85 ) THEN YEPPKCIG  = .;
 IF (YEPPROUD  >= 85 ) THEN YEPPROUD  = .;
 IF (YEPRBSLV  >= 85 ) THEN YEPRBSLV  = .;
 IF (YEPRGSTD  >= 85 ) THEN YEPRGSTD  = .;
 IF (YEPRTDNG  >= 85 ) THEN YEPRTDNG  = .;
 IF (YEPVNTYR  >= 85 ) THEN YEPVNTYR  = .;
 IF (YERLDCSN  >= 85 ) THEN YERLDCSN  = .;
 IF (YERLFRND  >= 85 ) THEN YERLFRND  = .;
 IF (YERLGIMP  >= 85 ) THEN YERLGIMP  = .;
 IF (YERLGSVC  >= 85 ) THEN YERLGSVC  = .;
 IF (YESCHACT  >= 85 ) THEN YESCHACT  = .;
 IF (YESCHFLT  >= 85 ) THEN YESCHFLT  = .;
 IF (YESCHIMP  >= 85 ) THEN YESCHIMP  = .;
 IF (YESCHINT  >= 85 ) THEN YESCHINT  = .;
 IF (YESCHWRK  >= 85 ) THEN YESCHWRK  = .;
 IF (YESLFHLP  >= 85 ) THEN YESLFHLP  = .;
 IF (YESTSALC  >= 85 ) THEN YESTSALC  = .;
 IF (YESTSCIG  >= 85 ) THEN YESTSCIG  = .;
 IF (YESTSDNK  >= 85 ) THEN YESTSDNK  = .;
 IF (YESTSMJ  >= 85 ) THEN YESTSMJ  = .;
 IF (YETCGJOB  >= 85 ) THEN YETCGJOB  = .;
 IF (YETLKBGF  >= 94 ) THEN YETLKBGF  = .;
 IF (YETLKNON  >= 85 ) THEN YETLKNON  = .;
 IF (YETLKOTA  >= 94 ) THEN YETLKOTA  = .;
 IF (YETLKPAR  >= 85 ) THEN YETLKPAR  = .;
 IF (YETLKSOP  >= 94 ) THEN YETLKSOP  = .;
 IF (YEVIOPRV  >= 85 ) THEN YEVIOPRV  = .;
 IF (YEYARGUP  >= 85 ) THEN YEYARGUP  = .;
 IF (YEYATTAK  >= 85 ) THEN YEYATTAK  = .;
 IF (YEYFGTGP  >= 85 ) THEN YEYFGTGP  = .;
 IF (YEYFGTSW  >= 85 ) THEN YEYFGTSW  = .;
 IF (YEYHGUN  >= 85 ) THEN YEYHGUN  = .;
 IF (YEYSELL  >= 85 ) THEN YEYSELL  = .;
 IF (YEYSTOLE  >= 85 ) THEN YEYSTOLE  = .;
 IF (YFLADLY2  >= . ) THEN YFLADLY2  = .;
 IF (YFLMJMO  >= . ) THEN YFLMJMO  = .;
 IF (YFLPKCG2  >= . ) THEN YFLPKCG2  = .;
 IF (YFLTMRJ2  >= . ) THEN YFLTMRJ2  = .;
 IF (YFOST  >= . ) THEN YFOST  = .;
 IF (YHBCHMDE  >= . ) THEN YHBCHMDE  = .;
 IF (YHLTMDE  >= . ) THEN YHLTMDE  = .;
 IF (YHOME  >= . ) THEN YHOME  = .;
 IF (YHOSP  >= . ) THEN YHOSP  = .;
 IF (YJAIL  >= . ) THEN YJAIL  = .;
 IF (YMDEHARX  >= . ) THEN YMDEHARX  = .;
 IF (YMDEHPO  >= . ) THEN YMDEHPO  = .;
 IF (YMDEHPRX  >= . ) THEN YMDEHPRX  = .;
 IF (YMDEIMUDPY  >= . ) THEN YMDEIMUDPY  = .;
 IF (YMDELT  >= . ) THEN YMDELT  = .;
 IF (YMDERXO2  >= . ) THEN YMDERXO2  = .;
 IF (YMDETXRX  >= . ) THEN YMDETXRX  = .;
 IF (YMDEUDPY  >= . ) THEN YMDEUDPY  = .;
 IF (YMDEYR  >= . ) THEN YMDEYR  = .;
 IF (YMHASPTX  >= . ) THEN YMHASPTX  = .;
 IF (YMHNSPTX  >= . ) THEN YMHNSPTX  = .;
 IF (YMHOSPTX  >= . ) THEN YMHOSPTX  = .;
 IF (YNURSMDE  >= . ) THEN YNURSMDE  = .;
 IF (YOATTAK2  >= . ) THEN YOATTAK2  = .;
 IF (YOCOUNS  >= 94 ) THEN YOCOUNS  = .;
 IF (YODPDISC  >= 85 ) THEN YODPDISC  = .;
 IF (YODPLSIN  >= 85 ) THEN YODPLSIN  = .;
 IF (YODPPROB  >= 94 ) THEN YODPPROB  = .;
 IF (YODPR2WK  >= 85 ) THEN YODPR2WK  = .;
 IF (YODPREV  >= 85 ) THEN YODPREV  = .;
 IF (YODSCEV  >= 94 ) THEN YODSCEV  = .;
 IF (YODSLSIN  >= 94 ) THEN YODSLSIN  = .;
 IF (YODSMMDE  >= 94 ) THEN YODSMMDE  = .;
 IF (YOFAMDOC  >= 94 ) THEN YOFAMDOC  = .;
 IF (YOFIGHT2  >= . ) THEN YOFIGHT2  = .;
 IF (YOGRPFT2  >= . ) THEN YOGRPFT2  = .;
 IF (YOHERBAL  >= 94 ) THEN YOHERBAL  = .;
 IF (YOHGUN2  >= . ) THEN YOHGUN2  = .;
 IF (YOLOSEV  >= 94 ) THEN YOLOSEV  = .;
 IF (YOLSI2WK  >= 94 ) THEN YOLSI2WK  = .;
 IF (YOMDMDE  >= . ) THEN YOMDMDE  = .;
 IF (YOMHMDE  >= . ) THEN YOMHMDE  = .;
 IF (YONURSE  >= 94 ) THEN YONURSE  = .;
 IF (YOOTHDOC  >= 94 ) THEN YOOTHDOC  = .;
 IF (YOOTHHLP  >= 94 ) THEN YOOTHHLP  = .;
 IF (YOOTHMHP  >= 94 ) THEN YOOTHMHP  = .;
 IF (YOPB2WK  >= 94 ) THEN YOPB2WK  = .;
 IF (YOPBAGE  >= 994 ) THEN YOPBAGE  = .;
 IF (YOPBDLYA  >= 94 ) THEN YOPBDLYA  = .;
 IF (YOPBINTF  >= 94 ) THEN YOPBINTF  = .;
 IF (YOPBNUM  >= 9994 ) THEN YOPBNUM  = .;
 IF (YOPBRMBR  >= 94 ) THEN YOPBRMBR  = .;
 IF (YOPSDAYS  >= 994 ) THEN YOPSDAYS  = .;
 IF (YOPSHMGT  >= 94 ) THEN YOPSHMGT  = .;
 IF (YOPSRELS  >= 94 ) THEN YOPSRELS  = .;
 IF (YOPSSOC  >= 94 ) THEN YOPSSOC  = .;
 IF (YOPSWORK  >= 94 ) THEN YOPSWORK  = .;
 IF (YOPSYCH  >= 94 ) THEN YOPSYCH  = .;
 IF (YOPSYMD  >= 94 ) THEN YOPSYMD  = .;
 IF (YORELIG  >= 94 ) THEN YORELIG  = .;
 IF (YORX12MO  >= 94 ) THEN YORX12MO  = .;
 IF (YORXHLP  >= 94 ) THEN YORXHLP  = .;
 IF (YORXNOW  >= 94 ) THEN YORXNOW  = .;
 IF (YOSEEDOC  >= 94 ) THEN YOSEEDOC  = .;
 IF (YOSELL2  >= . ) THEN YOSELL2  = .;
 IF (YOSOCWRK  >= 94 ) THEN YOSOCWRK  = .;
 IF (YOSTOLE2  >= . ) THEN YOSTOLE2  = .;
 IF (YOTHMDE  >= . ) THEN YOTHMDE  = .;
 IF (YOTMTHLP  >= 94 ) THEN YOTMTHLP  = .;
 IF (YOTMTNOW  >= 97 ) THEN YOTMTNOW  = .;
 IF (YOWRAGE  >= 994 ) THEN YOWRAGE  = .;
 IF (YOWRCHR  >= 94 ) THEN YOWRCHR  = .;
 IF (YOWRCONC  >= 94 ) THEN YOWRCONC  = .;
 IF (YOWRDBTR  >= 94 ) THEN YOWRDBTR  = .;
 IF (YOWRDCSN  >= 94 ) THEN YOWRDCSN  = .;
 IF (YOWRDEPR  >= 94 ) THEN YOWRDEPR  = .;
 IF (YOWRDIET  >= 94 ) THEN YOWRDIET  = .;
 IF (YOWRDISC  >= 94 ) THEN YOWRDISC  = .;
 IF (YOWRDLOT  >= 94 ) THEN YOWRDLOT  = .;
 IF (YOWRDST  >= 94 ) THEN YOWRDST  = .;
 IF (YOWRELES  >= 94 ) THEN YOWRELES  = .;
 IF (YOWREMOR  >= 94 ) THEN YOWREMOR  = .;
 IF (YOWRENRG  >= 94 ) THEN YOWRENRG  = .;
 IF (YOWRGAIN  >= 94 ) THEN YOWRGAIN  = .;
 IF (YOWRGNL2  >= 994 ) THEN YOWRGNL2  = .;
 IF (YOWRGROW  >= 94 ) THEN YOWRGROW  = .;
 IF (YOWRHRS  >= 85 ) THEN YOWRHRS  = .;
 IF (YOWRIMP  >= 94 ) THEN YOWRIMP  = .;
 IF (YOWRJINO  >= 94 ) THEN YOWRJINO  = .;
 IF (YOWRJITT  >= 94 ) THEN YOWRJITT  = .;
 IF (YOWRLOSE  >= 94 ) THEN YOWRLOSE  = .;
 IF (YOWRLSIN  >= 94 ) THEN YOWRLSIN  = .;
 IF (YOWRLSL2  >= 994 ) THEN YOWRLSL2  = .;
 IF (YOWRNOGD  >= 94 ) THEN YOWRNOGD  = .;
 IF (YOWRPLSR  >= 94 ) THEN YOWRPLSR  = .;
 IF (YOWRPREG  >= 94 ) THEN YOWRPREG  = .;
 IF (YOWRPROB  >= 94 ) THEN YOWRPROB  = .;
 IF (YOWRSATP  >= 94 ) THEN YOWRSATP  = .;
 IF (YOWRSLEP  >= 94 ) THEN YOWRSLEP  = .;
 IF (YOWRSLNO  >= 94 ) THEN YOWRSLNO  = .;
 IF (YOWRSLOW  >= 94 ) THEN YOWRSLOW  = .;
 IF (YOWRSMOR  >= 94 ) THEN YOWRSMOR  = .;
 IF (YOWRSPLN  >= 94 ) THEN YOWRSPLN  = .;
 IF (YOWRSTHK  >= 94 ) THEN YOWRSTHK  = .;
 IF (YOWRTHOT  >= 94 ) THEN YOWRTHOT  = .;
 IF (YOWRWRTH  >= 94 ) THEN YOWRWRTH  = .;
 IF (YO_MDEA1  >= 94 ) THEN YO_MDEA1  = .;
 IF (YO_MDEA2  >= 94 ) THEN YO_MDEA2  = .;
 IF (YO_MDEA3  >= 94 ) THEN YO_MDEA3  = .;
 IF (YO_MDEA4  >= 94 ) THEN YO_MDEA4  = .;
 IF (YO_MDEA5  >= 94 ) THEN YO_MDEA5  = .;
 IF (YO_MDEA6  >= 94 ) THEN YO_MDEA6  = .;
 IF (YO_MDEA7  >= 94 ) THEN YO_MDEA7  = .;
 IF (YO_MDEA8  >= 94 ) THEN YO_MDEA8  = .;
 IF (YO_MDEA9  >= 94 ) THEN YO_MDEA9  = .;
 IF (YPED  >= . ) THEN YPED  = .;
 IF (YPSY1MDE  >= . ) THEN YPSY1MDE  = .;
 IF (YPSY2MDE  >= . ) THEN YPSY2MDE  = .;
 IF (YRELMDE  >= . ) THEN YRELMDE  = .;
 IF (YRESID  >= . ) THEN YRESID  = .;
 IF (YRXMDEYR  >= . ) THEN YRXMDEYR  = .;
 IF (YSDSHOME  >= . ) THEN YSDSHOME  = .;
 IF (YSDSOVRL  >= . ) THEN YSDSOVRL  = .;
 IF (YSDSREL  >= . ) THEN YSDSREL  = .;
 IF (YSDSSOC  >= . ) THEN YSDSSOC  = .;
 IF (YSDSWRK  >= . ) THEN YSDSWRK  = .;
 IF (YSHSW  >= . ) THEN YSHSW  = .;
 IF (YSOCMDE  >= . ) THEN YSOCMDE  = .;
 IF (YSPEC  >= . ) THEN YSPEC  = .;
 IF (YSPTXNMH  >= . ) THEN YSPTXNMH  = .;
 IF (YTHACT2  >= . ) THEN YTHACT2  = .;
 IF (YTHER  >= . ) THEN YTHER  = .;
 IF (YTXMDEYR  >= . ) THEN YTXMDEYR  = .;
 IF (YUDYANGR  >= 94 ) THEN YUDYANGR  = .;
 IF (YUDYBKRU  >= 94 ) THEN YUDYBKRU  = .;
 IF (YUDYDEPR  >= 94 ) THEN YUDYDEPR  = .;
 IF (YUDYEATP  >= 94 ) THEN YUDYEATP  = .;
 IF (YUDYFEAR  >= 94 ) THEN YUDYFEAR  = .;
 IF (YUDYFITE  >= 94 ) THEN YUDYFITE  = .;
 IF (YUDYFMLY  >= 94 ) THEN YUDYFMLY  = .;
 IF (YUDYFRND  >= 94 ) THEN YUDYFRND  = .;
 IF (YUDYOTPP  >= 94 ) THEN YUDYOTPP  = .;
 IF (YUDYSCHL  >= 94 ) THEN YUDYSCHL  = .;
 IF (YUDYSOR  >= 94 ) THEN YUDYSOR  = .;
 IF (YUDYSUIC  >= 85 ) THEN YUDYSUIC  = .;
 IF (YUDYTXN2  >= 985 ) THEN YUDYTXN2  = .;
 IF (YUDYTXYR  >= 85 ) THEN YUDYTXYR  = .;
 IF (YUFCANGR  >= 94 ) THEN YUFCANGR  = .;
 IF (YUFCARN2  >= 985 ) THEN YUFCARN2  = .;
 IF (YUFCARYR  >= 85 ) THEN YUFCARYR  = .;
 IF (YUFCBKRU  >= 94 ) THEN YUFCBKRU  = .;
 IF (YUFCDEPR  >= 94 ) THEN YUFCDEPR  = .;
 IF (YUFCEATP  >= 94 ) THEN YUFCEATP  = .;
 IF (YUFCFEAR  >= 94 ) THEN YUFCFEAR  = .;
 IF (YUFCFITE  >= 94 ) THEN YUFCFITE  = .;
 IF (YUFCFMLY  >= 94 ) THEN YUFCFMLY  = .;
 IF (YUFCFRND  >= 94 ) THEN YUFCFRND  = .;
 IF (YUFCOTPP  >= 94 ) THEN YUFCOTPP  = .;
 IF (YUFCSCHL  >= 94 ) THEN YUFCSCHL  = .;
 IF (YUFCSOR  >= 94 ) THEN YUFCSOR  = .;
 IF (YUFCSUIC  >= 85 ) THEN YUFCSUIC  = .;
 IF (YUFDANGR  >= 94 ) THEN YUFDANGR  = .;
 IF (YUFDBKRU  >= 94 ) THEN YUFDBKRU  = .;
 IF (YUFDDEPR  >= 94 ) THEN YUFDDEPR  = .;
 IF (YUFDEATP  >= 94 ) THEN YUFDEATP  = .;
 IF (YUFDFEAR  >= 94 ) THEN YUFDFEAR  = .;
 IF (YUFDFITE  >= 94 ) THEN YUFDFITE  = .;
 IF (YUFDFMLY  >= 94 ) THEN YUFDFMLY  = .;
 IF (YUFDFRND  >= 94 ) THEN YUFDFRND  = .;
 IF (YUFDOCN2  >= 985 ) THEN YUFDOCN2  = .;
 IF (YUFDOCYR  >= 85 ) THEN YUFDOCYR  = .;
 IF (YUFDOTPP  >= 94 ) THEN YUFDOTPP  = .;
 IF (YUFDSCHL  >= 94 ) THEN YUFDSCHL  = .;
 IF (YUFDSOR  >= 94 ) THEN YUFDSOR  = .;
 IF (YUFDSUIC  >= 85 ) THEN YUFDSUIC  = .;
 IF (YUHOANGR  >= 94 ) THEN YUHOANGR  = .;
 IF (YUHOBKRU  >= 94 ) THEN YUHOBKRU  = .;
 IF (YUHODEPR  >= 94 ) THEN YUHODEPR  = .;
 IF (YUHOEATP  >= 94 ) THEN YUHOEATP  = .;
 IF (YUHOFEAR  >= 94 ) THEN YUHOFEAR  = .;
 IF (YUHOFITE  >= 94 ) THEN YUHOFITE  = .;
 IF (YUHOFMLY  >= 94 ) THEN YUHOFMLY  = .;
 IF (YUHOFRND  >= 94 ) THEN YUHOFRND  = .;
 IF (YUHOOTPP  >= 94 ) THEN YUHOOTPP  = .;
 IF (YUHOSCHL  >= 94 ) THEN YUHOSCHL  = .;
 IF (YUHOSOR  >= 94 ) THEN YUHOSOR  = .;
 IF (YUHOSPN2  >= 985 ) THEN YUHOSPN2  = .;
 IF (YUHOSPYR  >= 85 ) THEN YUHOSPYR  = .;
 IF (YUHOSUIC  >= 85 ) THEN YUHOSUIC  = .;
 IF (YUIHANGR  >= 94 ) THEN YUIHANGR  = .;
 IF (YUIHBKRU  >= 94 ) THEN YUIHBKRU  = .;
 IF (YUIHDEPR  >= 94 ) THEN YUIHDEPR  = .;
 IF (YUIHEATP  >= 94 ) THEN YUIHEATP  = .;
 IF (YUIHFEAR  >= 94 ) THEN YUIHFEAR  = .;
 IF (YUIHFITE  >= 94 ) THEN YUIHFITE  = .;
 IF (YUIHFMLY  >= 94 ) THEN YUIHFMLY  = .;
 IF (YUIHFRND  >= 94 ) THEN YUIHFRND  = .;
 IF (YUIHOTPP  >= 94 ) THEN YUIHOTPP  = .;
 IF (YUIHSCHL  >= 94 ) THEN YUIHSCHL  = .;
 IF (YUIHSOR  >= 94 ) THEN YUIHSOR  = .;
 IF (YUIHSUIC  >= 85 ) THEN YUIHSUIC  = .;
 IF (YUIHTPN2  >= 985 ) THEN YUIHTPN2  = .;
 IF (YUIHTPYR  >= 85 ) THEN YUIHTPYR  = .;
 IF (YUJVDTN2  >= 985 ) THEN YUJVDTN2  = .;
 IF (YUJVDTON  >= 85 ) THEN YUJVDTON  = .;
 IF (YUJVDTYR  >= 85 ) THEN YUJVDTYR  = .;
 IF (YUMHANGR  >= 94 ) THEN YUMHANGR  = .;
 IF (YUMHBKRU  >= 94 ) THEN YUMHBKRU  = .;
 IF (YUMHCRN2  >= 985 ) THEN YUMHCRN2  = .;
 IF (YUMHCRYR  >= 85 ) THEN YUMHCRYR  = .;
 IF (YUMHDEPR  >= 94 ) THEN YUMHDEPR  = .;
 IF (YUMHEATP  >= 94 ) THEN YUMHEATP  = .;
 IF (YUMHFEAR  >= 94 ) THEN YUMHFEAR  = .;
 IF (YUMHFITE  >= 94 ) THEN YUMHFITE  = .;
 IF (YUMHFMLY  >= 94 ) THEN YUMHFMLY  = .;
 IF (YUMHFRND  >= 94 ) THEN YUMHFRND  = .;
 IF (YUMHOTPP  >= 94 ) THEN YUMHOTPP  = .;
 IF (YUMHSCHL  >= 94 ) THEN YUMHSCHL  = .;
 IF (YUMHSOR  >= 94 ) THEN YUMHSOR  = .;
 IF (YUMHSUIC  >= 85 ) THEN YUMHSUIC  = .;
 IF (YURSANGR  >= 94 ) THEN YURSANGR  = .;
 IF (YURSBKRU  >= 94 ) THEN YURSBKRU  = .;
 IF (YURSDEPR  >= 94 ) THEN YURSDEPR  = .;
 IF (YURSEATP  >= 94 ) THEN YURSEATP  = .;
 IF (YURSFEAR  >= 94 ) THEN YURSFEAR  = .;
 IF (YURSFITE  >= 94 ) THEN YURSFITE  = .;
 IF (YURSFMLY  >= 94 ) THEN YURSFMLY  = .;
 IF (YURSFRND  >= 94 ) THEN YURSFRND  = .;
 IF (YURSIDN2  >= 985 ) THEN YURSIDN2  = .;
 IF (YURSIDYR  >= 85 ) THEN YURSIDYR  = .;
 IF (YURSOTPP  >= 94 ) THEN YURSOTPP  = .;
 IF (YURSSCHL  >= 94 ) THEN YURSSCHL  = .;
 IF (YURSSOR  >= 94 ) THEN YURSSOR  = .;
 IF (YURSSUIC  >= 85 ) THEN YURSSUIC  = .;
 IF (YUSCEMYR  >= 85 ) THEN YUSCEMYR  = .;
 IF (YUSCPGYR  >= 94 ) THEN YUSCPGYR  = .;
 IF (YUSWANGR  >= 94 ) THEN YUSWANGR  = .;
 IF (YUSWBKRU  >= 94 ) THEN YUSWBKRU  = .;
 IF (YUSWDEPR  >= 94 ) THEN YUSWDEPR  = .;
 IF (YUSWEATP  >= 94 ) THEN YUSWEATP  = .;
 IF (YUSWFEAR  >= 94 ) THEN YUSWFEAR  = .;
 IF (YUSWFITE  >= 94 ) THEN YUSWFITE  = .;
 IF (YUSWFMLY  >= 94 ) THEN YUSWFMLY  = .;
 IF (YUSWFRND  >= 94 ) THEN YUSWFRND  = .;
 IF (YUSWOTPP  >= 94 ) THEN YUSWOTPP  = .;
 IF (YUSWSCHL  >= 94 ) THEN YUSWSCHL  = .;
 IF (YUSWSCYR  >= 85 ) THEN YUSWSCYR  = .;
 IF (YUSWSOR  >= 94 ) THEN YUSWSOR  = .;
 IF (YUSWSUIC  >= 85 ) THEN YUSWSUIC  = .;
 IF (YUTPANGR  >= 94 ) THEN YUTPANGR  = .;
 IF (YUTPBKRU  >= 94 ) THEN YUTPBKRU  = .;
 IF (YUTPDEPR  >= 94 ) THEN YUTPDEPR  = .;
 IF (YUTPEATP  >= 94 ) THEN YUTPEATP  = .;
 IF (YUTPFEAR  >= 94 ) THEN YUTPFEAR  = .;
 IF (YUTPFITE  >= 94 ) THEN YUTPFITE  = .;
 IF (YUTPFMLY  >= 94 ) THEN YUTPFMLY  = .;
 IF (YUTPFRND  >= 94 ) THEN YUTPFRND  = .;
 IF (YUTPOTPP  >= 94 ) THEN YUTPOTPP  = .;
 IF (YUTPSCHL  >= 94 ) THEN YUTPSCHL  = .;
 IF (YUTPSOR  >= 94 ) THEN YUTPSOR  = .;
 IF (YUTPSTN2  >= 985 ) THEN YUTPSTN2  = .;
 IF (YUTPSTYR  >= 85 ) THEN YUTPSTYR  = .;
 IF (YUTPSUIC  >= 85 ) THEN YUTPSUIC  = .;
*/
RUN ;
