/*-------------------------------------------------------------------------
 |                                                                         
 |                    SAS SUPPLEMENTAL SYNTAX FILE FOR 
 |              NATIONAL SURVEY ON DRUG USE AND HEALTH, 2011
 |                        (DATASET: PUF2011_090718)
 |
 | This SAS program is provided for optional use with the SAS transport
 | version of this data file. The metadata
 | provided below are not stored in the SAS transport version of this data
 | collection.  Users need to use SAS PROC CIMPORT to import the SAS
 | transport file to a SAS data set on their system. This program can
 | then be used in conjunction with the SAS system data file.
 |
 | DATA:  begins a SAS data step and names an output SAS data set. Users
 | should replace "SAS-dataset" with their name for the SAS data set copied
 | from the SAS transport file. Users can add a SAS libname statement
 | and an output SAS data set name to make a permanent SAS data set.
 |
 | MISSING VALUE RECODES:  sets user-defined numeric missing values to
 | missing as interpreted by the SAS system. Only variables with
 | user-defined missing values are included in this section.
 |
 | If any variables have more than one missing value, they are assigned
 | to the standard missing value of a single period (.) in the statement
 | below. To maintain the original meaning of missing codes, users may want
 | to take advantage of the SAS missing values (the letters A-Z or an
 | underscore preceded by a period).
 |
 | An example of a standard missing value recode:
 |
 |   IF (RELATION = 98 OR RELATION = 99) THEN RELATION = .;
 |
 | The same example using special missing value recodes:
 |
 |    IF RELATION = 98 THEN RELATION = .A;
 |    IF RELATION = 99 THEN RELATION = .B;
 |
 | NOTE:  Users should modify this file to suit their specific needs.
 | The MISSING VALUE RECODES section has been commented out (i.e., '/*').
 | To make this section active in the program, users should remove the SAS
 | comment indicators from this section.
 |
 |------------------------------------------------------------------------*/

RUN;

* SAS DATA STEP;
DATA;
SET SAS-dataset ;


* USER-DEFINED MISSING VALUES RECODE TO SAS SYSMIS;

/*
 IF (ADCOUNS  >= 94 ) THEN ADCOUNS  = .;
 IF (ADDERALL  >= 94 ) THEN ADDERALL  = .;
 IF (ADDEREC  >= 91 ) THEN ADDEREC  = .;
 IF (ADDPDISC  >= 85 ) THEN ADDPDISC  = .;
 IF (ADDPLSIN  >= 85 ) THEN ADDPLSIN  = .;
 IF (ADDPPROB  >= 94 ) THEN ADDPPROB  = .;
 IF (ADDPR2WK  >= 85 ) THEN ADDPR2WK  = .;
 IF (ADDPREV  >= 85 ) THEN ADDPREV  = .;
 IF (ADDSCEV  >= 94 ) THEN ADDSCEV  = .;
 IF (ADDSLSIN  >= 94 ) THEN ADDSLSIN  = .;
 IF (ADFAMDOC  >= 94 ) THEN ADFAMDOC  = .;
 IF (ADHERBAL  >= 94 ) THEN ADHERBAL  = .;
 IF (ADLOSEV  >= 94 ) THEN ADLOSEV  = .;
 IF (ADLSI2WK  >= 94 ) THEN ADLSI2WK  = .;
 IF (ADNURSE  >= 94 ) THEN ADNURSE  = .;
 IF (ADOTHDOC  >= 94 ) THEN ADOTHDOC  = .;
 IF (ADOTHHLP  >= 94 ) THEN ADOTHHLP  = .;
 IF (ADOTHMHP  >= 94 ) THEN ADOTHMHP  = .;
 IF (ADPB2WK  >= 94 ) THEN ADPB2WK  = .;
 IF (ADPBAGE  >= 985 ) THEN ADPBAGE  = .;
 IF (ADPBDLYA  >= 94 ) THEN ADPBDLYA  = .;
 IF (ADPBINTF  >= 94 ) THEN ADPBINTF  = .;
 IF (ADPBNUM  >= 9994 ) THEN ADPBNUM  = .;
 IF (ADPBRMBR  >= 94 ) THEN ADPBRMBR  = .;
 IF (ADPSDAYS  >= 994 ) THEN ADPSDAYS  = .;
 IF (ADPSHMGT  >= 94 ) THEN ADPSHMGT  = .;
 IF (ADPSRELS  >= 94 ) THEN ADPSRELS  = .;
 IF (ADPSSOC  >= 94 ) THEN ADPSSOC  = .;
 IF (ADPSWORK  >= 94 ) THEN ADPSWORK  = .;
 IF (ADPSYCH  >= 94 ) THEN ADPSYCH  = .;
 IF (ADPSYMD  >= 94 ) THEN ADPSYMD  = .;
 IF (ADRELIG  >= 94 ) THEN ADRELIG  = .;
 IF (ADRX12MO  >= 94 ) THEN ADRX12MO  = .;
 IF (ADRXHLP  >= 94 ) THEN ADRXHLP  = .;
 IF (ADRXNOW  >= 97 ) THEN ADRXNOW  = .;
 IF (ADSEEDOC  >= 94 ) THEN ADSEEDOC  = .;
 IF (ADSMMDEA  >= 94 ) THEN ADSMMDEA  = .;
 IF (ADSOCWRK  >= 94 ) THEN ADSOCWRK  = .;
 IF (ADTMTHLP  >= 94 ) THEN ADTMTHLP  = .;
 IF (ADTMTNOW  >= 94 ) THEN ADTMTNOW  = .;
 IF (ADWRAGE  >= 985 ) THEN ADWRAGE  = .;
 IF (ADWRCHR  >= 94 ) THEN ADWRCHR  = .;
 IF (ADWRCONC  >= 94 ) THEN ADWRCONC  = .;
 IF (ADWRDBTR  >= 94 ) THEN ADWRDBTR  = .;
 IF (ADWRDCSN  >= 94 ) THEN ADWRDCSN  = .;
 IF (ADWRDEPR  >= 94 ) THEN ADWRDEPR  = .;
 IF (ADWRDIET  >= 94 ) THEN ADWRDIET  = .;
 IF (ADWRDISC  >= 94 ) THEN ADWRDISC  = .;
 IF (ADWRDLOT  >= 94 ) THEN ADWRDLOT  = .;
 IF (ADWRDST  >= 94 ) THEN ADWRDST  = .;
 IF (ADWRELES  >= 94 ) THEN ADWRELES  = .;
 IF (ADWREMOR  >= 94 ) THEN ADWREMOR  = .;
 IF (ADWRENRG  >= 94 ) THEN ADWRENRG  = .;
 IF (ADWRGAIN  >= 94 ) THEN ADWRGAIN  = .;
 IF (ADWRGNL2  >= 994 ) THEN ADWRGNL2  = .;
 IF (ADWRGROW  >= 94 ) THEN ADWRGROW  = .;
 IF (ADWRHRS  >= 85 ) THEN ADWRHRS  = .;
 IF (ADWRIMP  >= 94 ) THEN ADWRIMP  = .;
 IF (ADWRJINO  >= 94 ) THEN ADWRJINO  = .;
 IF (ADWRJITT  >= 94 ) THEN ADWRJITT  = .;
 IF (ADWRLOSE  >= 94 ) THEN ADWRLOSE  = .;
 IF (ADWRLSIN  >= 94 ) THEN ADWRLSIN  = .;
 IF (ADWRLSL2  >= 994 ) THEN ADWRLSL2  = .;
 IF (ADWRNOGD  >= 94 ) THEN ADWRNOGD  = .;
 IF (ADWRPLSR  >= 94 ) THEN ADWRPLSR  = .;
 IF (ADWRPREG  >= 94 ) THEN ADWRPREG  = .;
 IF (ADWRPROB  >= 94 ) THEN ADWRPROB  = .;
 IF (ADWRSATP  >= 97 ) THEN ADWRSATP  = .;
 IF (ADWRSLEP  >= 94 ) THEN ADWRSLEP  = .;
 IF (ADWRSLNO  >= 94 ) THEN ADWRSLNO  = .;
 IF (ADWRSLOW  >= 94 ) THEN ADWRSLOW  = .;
 IF (ADWRSMOR  >= 94 ) THEN ADWRSMOR  = .;
 IF (ADWRSPLN  >= 97 ) THEN ADWRSPLN  = .;
 IF (ADWRSTHK  >= 94 ) THEN ADWRSTHK  = .;
 IF (ADWRTHOT  >= 94 ) THEN ADWRTHOT  = .;
 IF (ADWRWRTH  >= 94 ) THEN ADWRWRTH  = .;
 IF (AD_MDEA1  >= 94 ) THEN AD_MDEA1  = .;
 IF (AD_MDEA2  >= 94 ) THEN AD_MDEA2  = .;
 IF (AD_MDEA3  >= 94 ) THEN AD_MDEA3  = .;
 IF (AD_MDEA4  >= 94 ) THEN AD_MDEA4  = .;
 IF (AD_MDEA5  >= 94 ) THEN AD_MDEA5  = .;
 IF (AD_MDEA6  >= 94 ) THEN AD_MDEA6  = .;
 IF (AD_MDEA7  >= 94 ) THEN AD_MDEA7  = .;
 IF (AD_MDEA8  >= 94 ) THEN AD_MDEA8  = .;
 IF (AD_MDEA9  >= 94 ) THEN AD_MDEA9  = .;
 IF (AEROS  >= 85 ) THEN AEROS  = .;
 IF (AL30EST  >= 85 ) THEN AL30EST  = .;
 IF (ALBSTWAY  >= 85 ) THEN ALBSTWAY  = .;
 IF (ALCAGLST  >= 985 ) THEN ALCAGLST  = .;
 IF (ALCCUT1X  >= 83 ) THEN ALCCUT1X  = .;
 IF (ALCCUTDN  >= 83 ) THEN ALCCUTDN  = .;
 IF (ALCCUTEV  >= 83 ) THEN ALCCUTEV  = .;
 IF (ALCDAYS  >= 85 ) THEN ALCDAYS  = .;
 IF (ALCEMCTD  >= 83 ) THEN ALCEMCTD  = .;
 IF (ALCEMOPB  >= 83 ) THEN ALCEMOPB  = .;
 IF (ALCEVER  >= 94 ) THEN ALCEVER  = .;
 IF (ALCFMCTD  >= 83 ) THEN ALCFMCTD  = .;
 IF (ALCFMFPB  >= 83 ) THEN ALCFMFPB  = .;
 IF (ALCGTOVR  >= 83 ) THEN ALCGTOVR  = .;
 IF (ALCKPLMT  >= 83 ) THEN ALCKPLMT  = .;
 IF (ALCLAWTR  >= 83 ) THEN ALCLAWTR  = .;
 IF (ALCLIMIT  >= 83 ) THEN ALCLIMIT  = .;
 IF (ALCLOTTM  >= 83 ) THEN ALCLOTTM  = .;
 IF (ALCLSACT  >= 83 ) THEN ALCLSACT  = .;
 IF (ALCLSEFX  >= 83 ) THEN ALCLSEFX  = .;
 IF (ALCMFU  >= 85 ) THEN ALCMFU  = .;
 IF (ALCMLU  >= 85 ) THEN ALCMLU  = .;
 IF (ALCNDMOR  >= 83 ) THEN ALCNDMOR  = .;
 IF (ALCPDANG  >= 83 ) THEN ALCPDANG  = .;
 IF (ALCPHCTD  >= 83 ) THEN ALCPHCTD  = .;
 IF (ALCPHLPB  >= 83 ) THEN ALCPHLPB  = .;
 IF (ALCREC  >= 91 ) THEN ALCREC  = .;
 IF (ALCSERPB  >= 83 ) THEN ALCSERPB  = .;
 IF (ALCTRY  >= 985 ) THEN ALCTRY  = .;
 IF (ALCWD2SX  >= 83 ) THEN ALCWD2SX  = .;
 IF (ALCWDSMT  >= 83 ) THEN ALCWDSMT  = .;
 IF (ALCYFU  >= 9985 ) THEN ALCYFU  = .;
 IF (ALCYLU  >= 9985 ) THEN ALCYLU  = .;
 IF (ALCYRBFR  >= 85 ) THEN ALCYRBFR  = .;
 IF (ALCYRTOT  >= 985 ) THEN ALCYRTOT  = .;
 IF (ALDAYPMO  >= 85 ) THEN ALDAYPMO  = .;
 IF (ALDAYPWK  >= 85 ) THEN ALDAYPWK  = .;
 IF (ALDAYPYR  >= 985 ) THEN ALDAYPYR  = .;
 IF (ALDYSFG  >= 98 ) THEN ALDYSFG  = .;
 IF (ALFQFLG  >= 98 ) THEN ALFQFLG  = .;
 IF (ALTOTFG  >= 98 ) THEN ALTOTFG  = .;
 IF (AMBIEN  >= 94 ) THEN AMBIEN  = .;
 IF (AMBIREC  >= 91 ) THEN AMBIREC  = .;
 IF (AMYLNIT  >= 85 ) THEN AMYLNIT  = .;
 IF (AMYTAL  >= 81 ) THEN AMYTAL  = .;
 IF (ANALAGE  >= 981 ) THEN ANALAGE  = .;
 IF (ANALMFU  >= 81 ) THEN ANALMFU  = .;
 IF (ANALMLU  >= 81 ) THEN ANALMLU  = .;
 IF (ANALNEWA  >= 9981 ) THEN ANALNEWA  = .;
 IF (ANALNEWB  >= 9981 ) THEN ANALNEWB  = .;
 IF (ANALNEWC  >= 9981 ) THEN ANALNEWC  = .;
 IF (ANALNEWD  >= 9981 ) THEN ANALNEWD  = .;
 IF (ANALNEWE  >= 9981 ) THEN ANALNEWE  = .;
 IF (ANALREC  >= 81 ) THEN ANALREC  = .;
 IF (ANALYFU  >= 9981 ) THEN ANALYFU  = .;
 IF (ANALYLU  >= 9981 ) THEN ANALYLU  = .;
 IF (ANLAGLST  >= 981 ) THEN ANLAGLST  = .;
 IF (ANLCARD  >= 81 ) THEN ANLCARD  = .;
 IF (ANLCUT1X  >= 81 ) THEN ANLCUT1X  = .;
 IF (ANLCUTDN  >= 81 ) THEN ANLCUTDN  = .;
 IF (ANLCUTEV  >= 81 ) THEN ANLCUTEV  = .;
 IF (ANLDEALR  >= 81 ) THEN ANLDEALR  = .;
 IF (ANLEMCTD  >= 81 ) THEN ANLEMCTD  = .;
 IF (ANLEMOPB  >= 81 ) THEN ANLEMOPB  = .;
 IF (ANLEVER  >= 81 ) THEN ANLEVER  = .;
 IF (ANLFF1DR  >= 81 ) THEN ANLFF1DR  = .;
 IF (ANLFFAKE  >= 81 ) THEN ANLFFAKE  = .;
 IF (ANLFFBOT  >= 81 ) THEN ANLFFBOT  = .;
 IF (ANLFFDLR  >= 81 ) THEN ANLFFDLR  = .;
 IF (ANLFFDRS  >= 81 ) THEN ANLFFDRS  = .;
 IF (ANLFFLAS  >= 81 ) THEN ANLFFLAS  = .;
 IF (ANLFFLSP  >= 81 ) THEN ANLFFLSP  = .;
 IF (ANLFFNET  >= 81 ) THEN ANLFFNET  = .;
 IF (ANLFFOSP  >= 81 ) THEN ANLFFOSP  = .;
 IF (ANLFFOTH  >= 81 ) THEN ANLFFOTH  = .;
 IF (ANLFFREE  >= 81 ) THEN ANLFFREE  = .;
 IF (ANLFFSTL  >= 81 ) THEN ANLFFSTL  = .;
 IF (ANLFFTAK  >= 81 ) THEN ANLFFTAK  = .;
 IF (ANLFMCTD  >= 81 ) THEN ANLFMCTD  = .;
 IF (ANLFMFPB  >= 81 ) THEN ANLFMFPB  = .;
 IF (ANLFRBUY  >= 81 ) THEN ANLFRBUY  = .;
 IF (ANLFRFRE  >= 81 ) THEN ANLFRFRE  = .;
 IF (ANLFRTKE  >= 81 ) THEN ANLFRTKE  = .;
 IF (ANLGTLA2  >= 81 ) THEN ANLGTLA2  = .;
 IF (ANLGTOS2  >= 81 ) THEN ANLGTOS2  = .;
 IF (ANLGTOVR  >= 81 ) THEN ANLGTOVR  = .;
 IF (ANLINET  >= 81 ) THEN ANLINET  = .;
 IF (ANLKPLMT  >= 81 ) THEN ANLKPLMT  = .;
 IF (ANLLAWTR  >= 81 ) THEN ANLLAWTR  = .;
 IF (ANLLIMIT  >= 81 ) THEN ANLLIMIT  = .;
 IF (ANLLOTTM  >= 81 ) THEN ANLLOTTM  = .;
 IF (ANLLSACT  >= 81 ) THEN ANLLSACT  = .;
 IF (ANLLSEFX  >= 81 ) THEN ANLLSEFX  = .;
 IF (ANLNDMOR  >= 81 ) THEN ANLNDMOR  = .;
 IF (ANLNOLST  >= 81 ) THEN ANLNOLST  = .;
 IF (ANLOTHS2  >= 81 ) THEN ANLOTHS2  = .;
 IF (ANLOTHWY  >= 81 ) THEN ANLOTHWY  = .;
 IF (ANLPDANG  >= 81 ) THEN ANLPDANG  = .;
 IF (ANLPHCTD  >= 81 ) THEN ANLPHCTD  = .;
 IF (ANLPHLPB  >= 81 ) THEN ANLPHLPB  = .;
 IF (ANLRX1DR  >= 81 ) THEN ANLRX1DR  = .;
 IF (ANLRXDRS  >= 81 ) THEN ANLRXDRS  = .;
 IF (ANLRXFAK  >= 81 ) THEN ANLRXFAK  = .;
 IF (ANLSERPB  >= 81 ) THEN ANLSERPB  = .;
 IF (ANLSTOLE  >= 81 ) THEN ANLSTOLE  = .;
 IF (ANLWD3SX  >= 81 ) THEN ANLWD3SX  = .;
 IF (ANLWDSMT  >= 81 ) THEN ANLWDSMT  = .;
 IF (ANLYRTOT  >= 981 ) THEN ANLYRTOT  = .;
 IF (ANYHLTI2  >= 94 ) THEN ANYHLTI2  = .;
 IF (ATARAX  >= 81 ) THEN ATARAX  = .;
 IF (AUALACUP  >= 85 ) THEN AUALACUP  = .;
 IF (AUALCHIR  >= 94 ) THEN AUALCHIR  = .;
 IF (AUALHERB  >= 94 ) THEN AUALHERB  = .;
 IF (AUALHLIN  >= 94 ) THEN AUALHLIN  = .;
 IF (AUALINET  >= 94 ) THEN AUALINET  = .;
 IF (AUALMASG  >= 94 ) THEN AUALMASG  = .;
 IF (AUALOTH  >= 94 ) THEN AUALOTH  = .;
 IF (AUALOTS2  >= 85 ) THEN AUALOTS2  = .;
 IF (AUALRELG  >= 94 ) THEN AUALRELG  = .;
 IF (AUALSGRP  >= 94 ) THEN AUALSGRP  = .;
 IF (AUALTYR  >= 85 ) THEN AUALTYR  = .;
 IF (AUINAHSP  >= 85 ) THEN AUINAHSP  = .;
 IF (AUINMEDU  >= 85 ) THEN AUINMEDU  = .;
 IF (AUINPGEN  >= 85 ) THEN AUINPGEN  = .;
 IF (AUINPSYH  >= 85 ) THEN AUINPSYH  = .;
 IF (AUINPYR  >= 85 ) THEN AUINPYR  = .;
 IF (AUINRESD  >= 85 ) THEN AUINRESD  = .;
 IF (AUINSFAC  >= 85 ) THEN AUINSFAC  = .;
 IF (AUMOTVYR  >= 85 ) THEN AUMOTVYR  = .;
 IF (AUNMAHS2  >= 985 ) THEN AUNMAHS2  = .;
 IF (AUNMCLN2  >= 994 ) THEN AUNMCLN2  = .;
 IF (AUNMDOC2  >= 994 ) THEN AUNMDOC2  = .;
 IF (AUNMDTM2  >= 994 ) THEN AUNMDTM2  = .;
 IF (AUNMMED2  >= 985 ) THEN AUNMMED2  = .;
 IF (AUNMMEN2  >= 985 ) THEN AUNMMEN2  = .;
 IF (AUNMOTO2  >= 994 ) THEN AUNMOTO2  = .;
 IF (AUNMPGE2  >= 985 ) THEN AUNMPGE2  = .;
 IF (AUNMPSY2  >= 985 ) THEN AUNMPSY2  = .;
 IF (AUNMRES2  >= 985 ) THEN AUNMRES2  = .;
 IF (AUNMSFA2  >= 985 ) THEN AUNMSFA2  = .;
 IF (AUNMTHE2  >= 994 ) THEN AUNMTHE2  = .;
 IF (AUOPCLNC  >= 94 ) THEN AUOPCLNC  = .;
 IF (AUOPDOC  >= 94 ) THEN AUOPDOC  = .;
 IF (AUOPDTMT  >= 94 ) THEN AUOPDTMT  = .;
 IF (AUOPMENT  >= 85 ) THEN AUOPMENT  = .;
 IF (AUOPOTOP  >= 94 ) THEN AUOPOTOP  = .;
 IF (AUOPTHER  >= 94 ) THEN AUOPTHER  = .;
 IF (AUOPTYR  >= 85 ) THEN AUOPTYR  = .;
 IF (AUOPYRS2  >= 85 ) THEN AUOPYRS2  = .;
 IF (AUPINEMP  >= 94 ) THEN AUPINEMP  = .;
 IF (AUPINFM2  >= 85 ) THEN AUPINFM2  = .;
 IF (AUPINFRE  >= 94 ) THEN AUPINFRE  = .;
 IF (AUPINMCD  >= 94 ) THEN AUPINMCD  = .;
 IF (AUPINMCR  >= 94 ) THEN AUPINMCR  = .;
 IF (AUPINMIL  >= 94 ) THEN AUPINMIL  = .;
 IF (AUPINOFM  >= 94 ) THEN AUPINOFM  = .;
 IF (AUPINPHI  >= 94 ) THEN AUPINPHI  = .;
 IF (AUPINPRV  >= 94 ) THEN AUPINPRV  = .;
 IF (AUPINPUB  >= 94 ) THEN AUPINPUB  = .;
 IF (AUPINREH  >= 94 ) THEN AUPINREH  = .;
 IF (AUPINSLF  >= 85 ) THEN AUPINSLF  = .;
 IF (AUPOPAMT  >= 85 ) THEN AUPOPAMT  = .;
 IF (AUPOPEMP  >= 94 ) THEN AUPOPEMP  = .;
 IF (AUPOPFRE  >= 94 ) THEN AUPOPFRE  = .;
 IF (AUPOPMCD  >= 94 ) THEN AUPOPMCD  = .;
 IF (AUPOPMCR  >= 94 ) THEN AUPOPMCR  = .;
 IF (AUPOPMIL  >= 94 ) THEN AUPOPMIL  = .;
 IF (AUPOPMOS  >= 97 ) THEN AUPOPMOS  = .;
 IF (AUPOPOFM  >= 94 ) THEN AUPOPOFM  = .;
 IF (AUPOPPHI  >= 94 ) THEN AUPOPPHI  = .;
 IF (AUPOPPRV  >= 94 ) THEN AUPOPPRV  = .;
 IF (AUPOPPUB  >= 94 ) THEN AUPOPPUB  = .;
 IF (AUPOPREH  >= 94 ) THEN AUPOPREH  = .;
 IF (AUPOPSLF  >= 85 ) THEN AUPOPSLF  = .;
 IF (AURXYR  >= 85 ) THEN AURXYR  = .;
 IF (AUUNBUSY  >= 94 ) THEN AUUNBUSY  = .;
 IF (AUUNCFID  >= 94 ) THEN AUUNCFID  = .;
 IF (AUUNCMIT  >= 94 ) THEN AUUNCMIT  = .;
 IF (AUUNCOST  >= 85 ) THEN AUUNCOST  = .;
 IF (AUUNENUF  >= 94 ) THEN AUUNENUF  = .;
 IF (AUUNFOUT  >= 94 ) THEN AUUNFOUT  = .;
 IF (AUUNHNDL  >= 94 ) THEN AUUNHNDL  = .;
 IF (AUUNJOB  >= 94 ) THEN AUUNJOB  = .;
 IF (AUUNMTYR  >= 85 ) THEN AUUNMTYR  = .;
 IF (AUUNNBR  >= 94 ) THEN AUUNNBR  = .;
 IF (AUUNNCOV  >= 94 ) THEN AUUNNCOV  = .;
 IF (AUUNNHLP  >= 94 ) THEN AUUNNHLP  = .;
 IF (AUUNNOND  >= 94 ) THEN AUUNNOND  = .;
 IF (AUUNNTSP  >= 94 ) THEN AUUNNTSP  = .;
 IF (AUUNRIM2  >= 85 ) THEN AUUNRIM2  = .;
 IF (AUUNSOR  >= 94 ) THEN AUUNSOR  = .;
 IF (AUUNWHER  >= 94 ) THEN AUUNWHER  = .;
 IF (BKARSON  >= 85 ) THEN BKARSON  = .;
 IF (BKBURGL  >= 85 ) THEN BKBURGL  = .;
 IF (BKDRUG  >= 85 ) THEN BKDRUG  = .;
 IF (BKDRUNK  >= 85 ) THEN BKDRUNK  = .;
 IF (BKDRVINF  >= 85 ) THEN BKDRVINF  = .;
 IF (BKFRAUD  >= 85 ) THEN BKFRAUD  = .;
 IF (BKLARCNY  >= 85 ) THEN BKLARCNY  = .;
 IF (BKMVTHFT  >= 85 ) THEN BKMVTHFT  = .;
 IF (BKOTH  >= 85 ) THEN BKOTH  = .;
 IF (BKOTHOF2  >= 85 ) THEN BKOTHOF2  = .;
 IF (BKPOSTOB  >= 85 ) THEN BKPOSTOB  = .;
 IF (BKROB  >= 85 ) THEN BKROB  = .;
 IF (BKSEXNR  >= 85 ) THEN BKSEXNR  = .;
 IF (BKSMASLT  >= 85 ) THEN BKSMASLT  = .;
 IF (BKSRVIOL  >= 85 ) THEN BKSRVIOL  = .;
 IF (BLNT30C1  >= 85 ) THEN BLNT30C1  = .;
 IF (BLNT30C2  >= 94 ) THEN BLNT30C2  = .;
 IF (BLNT30DY  >= 91 ) THEN BLNT30DY  = .;
 IF (BLNTAGE  >= 981 ) THEN BLNTAGE  = .;
 IF (BLNTEVER  >= 85 ) THEN BLNTEVER  = .;
 IF (BLNTMFU  >= 81 ) THEN BLNTMFU  = .;
 IF (BLNTNOMJ  >= 91 ) THEN BLNTNOMJ  = .;
 IF (BLNTREC  >= 81 ) THEN BLNTREC  = .;
 IF (BLNTYFU  >= 9981 ) THEN BLNTYFU  = .;
 IF (BLRECFL2  >= 98 ) THEN BLRECFL2  = .;
 IF (BOOKED  >= 85 ) THEN BOOKED  = .;
 IF (BUSPAR  >= 81 ) THEN BUSPAR  = .;
 IF (BUTISOL  >= 81 ) THEN BUTISOL  = .;
 IF (CA4FDAGE  >= 985 ) THEN CA4FDAGE  = .;
 IF (CA4FDDYS  >= 85 ) THEN CA4FDDYS  = .;
 IF (CA4FDEV  >= 91 ) THEN CA4FDEV  = .;
 IF (CA4FDMFU  >= 85 ) THEN CA4FDMFU  = .;
 IF (CA4FDYFU  >= 9985 ) THEN CA4FDYFU  = .;
 IF (CABNGAGE  >= 985 ) THEN CABNGAGE  = .;
 IF (CABNGEV  >= 91 ) THEN CABNGEV  = .;
 IF (CABNGMFU  >= 85 ) THEN CABNGMFU  = .;
 IF (CABNGYFU  >= 9985 ) THEN CABNGYFU  = .;
 IF (CABPLACE  >= 85 ) THEN CABPLACE  = .;
 IF (CABUNDAG  >= 91 ) THEN CABUNDAG  = .;
 IF (CABUYFRE  >= 85 ) THEN CABUYFRE  = .;
 IF (CABUYWHO  >= 85 ) THEN CABUYWHO  = .;
 IF (CADRBAR  >= 91 ) THEN CADRBAR  = .;
 IF (CADRCAR  >= 85 ) THEN CADRCAR  = .;
 IF (CADREVNT  >= 91 ) THEN CADREVNT  = .;
 IF (CADRHOME  >= 85 ) THEN CADRHOME  = .;
 IF (CADRKANL  >= 89 ) THEN CADRKANL  = .;
 IF (CADRKCOC  >= 89 ) THEN CADRKCOC  = .;
 IF (CADRKDRG  >= 83 ) THEN CADRKDRG  = .;
 IF (CADRKHAL  >= 91 ) THEN CADRKHAL  = .;
 IF (CADRKHER  >= 89 ) THEN CADRKHER  = .;
 IF (CADRKINH  >= 89 ) THEN CADRKINH  = .;
 IF (CADRKMRJ  >= 91 ) THEN CADRKMRJ  = .;
 IF (CADRKMTH  >= 89 ) THEN CADRKMTH  = .;
 IF (CADRKSED  >= 89 ) THEN CADRKSED  = .;
 IF (CADRKSTM  >= 89 ) THEN CADRKSTM  = .;
 IF (CADRKTRN  >= 89 ) THEN CADRKTRN  = .;
 IF (CADRLAST  >= 985 ) THEN CADRLAST  = .;
 IF (CADROTH  >= 91 ) THEN CADROTH  = .;
 IF (CADROTHM  >= 89 ) THEN CADROTHM  = .;
 IF (CADROTS2  >= 85 ) THEN CADROTS2  = .;
 IF (CADRPEOP  >= 85 ) THEN CADRPEOP  = .;
 IF (CADRPUBL  >= 91 ) THEN CADRPUBL  = .;
 IF (CADRSCHL  >= 91 ) THEN CADRSCHL  = .;
 IF (CAFRESP2  >= 85 ) THEN CAFRESP2  = .;
 IF (CAFREWHO  >= 85 ) THEN CAFREWHO  = .;
 IF (CAGVMONY  >= 85 ) THEN CAGVMONY  = .;
 IF (CAGVWHO  >= 91 ) THEN CAGVWHO  = .;
 IF (CAIDCHIP  >= 85 ) THEN CAIDCHIP  = .;
 IF (CC30EST  >= 91 ) THEN CC30EST  = .;
 IF (CCBSTWAY  >= 85 ) THEN CCBSTWAY  = .;
 IF (CCDAYPMO  >= 85 ) THEN CCDAYPMO  = .;
 IF (CCDAYPWK  >= 85 ) THEN CCDAYPWK  = .;
 IF (CCDAYPYR  >= 985 ) THEN CCDAYPYR  = .;
 IF (CCFQFLG  >= 98 ) THEN CCFQFLG  = .;
 IF (CCTOTFG  >= 98 ) THEN CCTOTFG  = .;
 IF (CG30EST  >= 91 ) THEN CG30EST  = .;
 IF (CGR30BR2  >= 9991 ) THEN CGR30BR2  = .;
 IF (CGR30USE  >= 91 ) THEN CGR30USE  = .;
 IF (CGRAGLST  >= 985 ) THEN CGRAGLST  = .;
 IF (CH30EST  >= 91 ) THEN CH30EST  = .;
 IF (CHAMPUS  >= 85 ) THEN CHAMPUS  = .;
 IF (CHEWEVER  >= 94 ) THEN CHEWEVER  = .;
 IF (CHEWMFU  >= 85 ) THEN CHEWMFU  = .;
 IF (CHEWMLU  >= 85 ) THEN CHEWMLU  = .;
 IF (CHEWREC  >= 91 ) THEN CHEWREC  = .;
 IF (CHEWTRY  >= 985 ) THEN CHEWTRY  = .;
 IF (CHEWYFU  >= 9985 ) THEN CHEWYFU  = .;
 IF (CHEWYLU  >= 9985 ) THEN CHEWYLU  = .;
 IF (CHHYD  >= 81 ) THEN CHHYD  = .;
 IF (CHW30BR2  >= 9991 ) THEN CHW30BR2  = .;
 IF (CHW30USE  >= 91 ) THEN CHW30USE  = .;
 IF (CHWAGLST  >= 985 ) THEN CHWAGLST  = .;
 IF (CI30EST  >= 91 ) THEN CI30EST  = .;
 IF (CIG100LF  >= 91 ) THEN CIG100LF  = .;
 IF (CIG30AV  >= 91 ) THEN CIG30AV  = .;
 IF (CIG30BR2  >= 9991 ) THEN CIG30BR2  = .;
 IF (CIG30MEN  >= 91 ) THEN CIG30MEN  = .;
 IF (CIG30MLN  >= 91 ) THEN CIG30MLN  = .;
 IF (CIG30RO2  >= 91 ) THEN CIG30RO2  = .;
 IF (CIG30TPE  >= 91 ) THEN CIG30TPE  = .;
 IF (CIG30USE  >= 91 ) THEN CIG30USE  = .;
 IF (CIGAGE  >= 985 ) THEN CIGAGE  = .;
 IF (CIGAGLST  >= 985 ) THEN CIGAGLST  = .;
 IF (CIGAREVR  >= 94 ) THEN CIGAREVR  = .;
 IF (CIGARMFU  >= 85 ) THEN CIGARMFU  = .;
 IF (CIGARMLU  >= 85 ) THEN CIGARMLU  = .;
 IF (CIGARREC  >= 91 ) THEN CIGARREC  = .;
 IF (CIGARTRY  >= 985 ) THEN CIGARTRY  = .;
 IF (CIGARYFU  >= 9985 ) THEN CIGARYFU  = .;
 IF (CIGARYLU  >= 9985 ) THEN CIGARYLU  = .;
 IF (CIGAVOID  >= 85 ) THEN CIGAVOID  = .;
 IF (CIGCRAGP  >= 85 ) THEN CIGCRAGP  = .;
 IF (CIGCRAVE  >= 85 ) THEN CIGCRAVE  = .;
 IF (CIGDLLST  >= 985 ) THEN CIGDLLST  = .;
 IF (CIGDLMFU  >= 85 ) THEN CIGDLMFU  = .;
 IF (CIGDLMLU  >= 85 ) THEN CIGDLMLU  = .;
 IF (CIGDLYFU  >= 9985 ) THEN CIGDLYFU  = .;
 IF (CIGDLYLU  >= 9985 ) THEN CIGDLYLU  = .;
 IF (CIGDLYMO  >= 91 ) THEN CIGDLYMO  = .;
 IF (CIGFNLKE  >= 85 ) THEN CIGFNLKE  = .;
 IF (CIGFNSMK  >= 85 ) THEN CIGFNSMK  = .;
 IF (CIGINCRS  >= 85 ) THEN CIGINCRS  = .;
 IF (CIGINCTL  >= 85 ) THEN CIGINCTL  = .;
 IF (CIGINFLU  >= 85 ) THEN CIGINFLU  = .;
 IF (CIGIRTBL  >= 85 ) THEN CIGIRTBL  = .;
 IF (CIGLOTMR  >= 85 ) THEN CIGLOTMR  = .;
 IF (CIGMFU  >= 85 ) THEN CIGMFU  = .;
 IF (CIGMLU  >= 85 ) THEN CIGMLU  = .;
 IF (CIGNMCHG  >= 85 ) THEN CIGNMCHG  = .;
 IF (CIGNOINF  >= 85 ) THEN CIGNOINF  = .;
 IF (CIGOFRSM  >= 94 ) THEN CIGOFRSM  = .;
 IF (CIGPLANE  >= 85 ) THEN CIGPLANE  = .;
 IF (CIGREC  >= 91 ) THEN CIGREC  = .;
 IF (CIGREGDY  >= 85 ) THEN CIGREGDY  = .;
 IF (CIGREGNM  >= 85 ) THEN CIGREGNM  = .;
 IF (CIGREGWK  >= 85 ) THEN CIGREGWK  = .;
 IF (CIGRNOUT  >= 85 ) THEN CIGRNOUT  = .;
 IF (CIGSATIS  >= 85 ) THEN CIGSATIS  = .;
 IF (CIGSVLHR  >= 85 ) THEN CIGSVLHR  = .;
 IF (CIGTRY  >= 985 ) THEN CIGTRY  = .;
 IF (CIGWAKE  >= 85 ) THEN CIGWAKE  = .;
 IF (CIGWILYR  >= 94 ) THEN CIGWILYR  = .;
 IF (CIGYFU  >= 9985 ) THEN CIGYFU  = .;
 IF (CIGYLU  >= 9985 ) THEN CIGYLU  = .;
 IF (CIGYRBFR  >= 85 ) THEN CIGYRBFR  = .;
 IF (CLEFLU  >= 85 ) THEN CLEFLU  = .;
 IF (COCAGE  >= 985 ) THEN COCAGE  = .;
 IF (COCAGLST  >= 985 ) THEN COCAGLST  = .;
 IF (COCCUT1X  >= 91 ) THEN COCCUT1X  = .;
 IF (COCCUTDN  >= 85 ) THEN COCCUTDN  = .;
 IF (COCCUTEV  >= 85 ) THEN COCCUTEV  = .;
 IF (COCEMCTD  >= 85 ) THEN COCEMCTD  = .;
 IF (COCEMOPB  >= 85 ) THEN COCEMOPB  = .;
 IF (COCEVER  >= 94 ) THEN COCEVER  = .;
 IF (COCFLBLU  >= 85 ) THEN COCFLBLU  = .;
 IF (COCFMCTD  >= 85 ) THEN COCFMCTD  = .;
 IF (COCFMFPB  >= 85 ) THEN COCFMFPB  = .;
 IF (COCGTOVR  >= 91 ) THEN COCGTOVR  = .;
 IF (COCKPLMT  >= 85 ) THEN COCKPLMT  = .;
 IF (COCLAWTR  >= 85 ) THEN COCLAWTR  = .;
 IF (COCLIMIT  >= 85 ) THEN COCLIMIT  = .;
 IF (COCLOTTM  >= 85 ) THEN COCLOTTM  = .;
 IF (COCLSACT  >= 85 ) THEN COCLSACT  = .;
 IF (COCLSEFX  >= 91 ) THEN COCLSEFX  = .;
 IF (COCMFU  >= 85 ) THEN COCMFU  = .;
 IF (COCMLU  >= 85 ) THEN COCMLU  = .;
 IF (COCNDMOR  >= 85 ) THEN COCNDMOR  = .;
 IF (COCNEEDL  >= 91 ) THEN COCNEEDL  = .;
 IF (COCPDANG  >= 85 ) THEN COCPDANG  = .;
 IF (COCPHCTD  >= 91 ) THEN COCPHCTD  = .;
 IF (COCPHLPB  >= 91 ) THEN COCPHLPB  = .;
 IF (COCREC  >= 91 ) THEN COCREC  = .;
 IF (COCSERPB  >= 85 ) THEN COCSERPB  = .;
 IF (COCUS30A  >= 85 ) THEN COCUS30A  = .;
 IF (COCWD2SX  >= 85 ) THEN COCWD2SX  = .;
 IF (COCWDSMT  >= 85 ) THEN COCWDSMT  = .;
 IF (COCYFU  >= 9985 ) THEN COCYFU  = .;
 IF (COCYLU  >= 9985 ) THEN COCYLU  = .;
 IF (COCYRBFR  >= 91 ) THEN COCYRBFR  = .;
 IF (COCYRTOT  >= 985 ) THEN COCYRTOT  = .;
 IF (CODEINE  >= 81 ) THEN CODEINE  = .;
 IF (COLDMEDS  >= 94 ) THEN COLDMEDS  = .;
 IF (COLDREC  >= 91 ) THEN COLDREC  = .;
 IF (CONDLREC  >= 91 ) THEN CONDLREC  = .;
 IF (CR30EST  >= 91 ) THEN CR30EST  = .;
 IF (CRAKREC  >= 91 ) THEN CRAKREC  = .;
 IF (CRBSTWAY  >= 85 ) THEN CRBSTWAY  = .;
 IF (CRDAYPMO  >= 91 ) THEN CRDAYPMO  = .;
 IF (CRDAYPWK  >= 91 ) THEN CRDAYPWK  = .;
 IF (CRDAYPYR  >= 985 ) THEN CRDAYPYR  = .;
 IF (CRFQFLG  >= 98 ) THEN CRFQFLG  = .;
 IF (CRKAGE  >= 985 ) THEN CRKAGE  = .;
 IF (CRKAGLST  >= 985 ) THEN CRKAGLST  = .;
 IF (CRKEVER  >= 91 ) THEN CRKEVER  = .;
 IF (CRKMFU  >= 85 ) THEN CRKMFU  = .;
 IF (CRKMLU  >= 85 ) THEN CRKMLU  = .;
 IF (CRKUS30A  >= 85 ) THEN CRKUS30A  = .;
 IF (CRKYFU  >= 9985 ) THEN CRKYFU  = .;
 IF (CRKYLU  >= 9985 ) THEN CRKYLU  = .;
 IF (CRKYRTOT  >= 985 ) THEN CRKYRTOT  = .;
 IF (CRTOTFG  >= 98 ) THEN CRTOTFG  = .;
 IF (CYLERT  >= 81 ) THEN CYLERT  = .;
 IF (DALMANE  >= 81 ) THEN DALMANE  = .;
 IF (DARVTYLC  >= 81 ) THEN DARVTYLC  = .;
 IF (DEMEROL  >= 81 ) THEN DEMEROL  = .;
 IF (DETAMP  >= 81 ) THEN DETAMP  = .;
 IF (DEXED  >= 81 ) THEN DEXED  = .;
 IF (DIDREX  >= 81 ) THEN DIDREX  = .;
 IF (DIETPILS  >= 81 ) THEN DIETPILS  = .;
 IF (DILAUD  >= 81 ) THEN DILAUD  = .;
 IF (DR5DAY  >= 85 ) THEN DR5DAY  = .;
 IF (DRGPLCY  >= 85 ) THEN DRGPLCY  = .;
 IF (DRGPRGM  >= 85 ) THEN DRGPRGM  = .;
 IF (DRVALDR  >= 81 ) THEN DRVALDR  = .;
 IF (DRVAONLY  >= 81 ) THEN DRVAONLY  = .;
 IF (DRVDONLY  >= 81 ) THEN DRVDONLY  = .;
 IF (DRVFLAG  >= 98 ) THEN DRVFLAG  = .;
 IF (DSTCHR12  >= 85 ) THEN DSTCHR12  = .;
 IF (DSTCHR30  >= 85 ) THEN DSTCHR30  = .;
 IF (DSTEFF12  >= 85 ) THEN DSTEFF12  = .;
 IF (DSTEFF30  >= 85 ) THEN DSTEFF30  = .;
 IF (DSTHOP12  >= 85 ) THEN DSTHOP12  = .;
 IF (DSTHOP30  >= 85 ) THEN DSTHOP30  = .;
 IF (DSTNGD12  >= 85 ) THEN DSTNGD12  = .;
 IF (DSTNGD30  >= 85 ) THEN DSTNGD30  = .;
 IF (DSTNRV12  >= 85 ) THEN DSTNRV12  = .;
 IF (DSTNRV30  >= 85 ) THEN DSTNRV30  = .;
 IF (DSTRST12  >= 85 ) THEN DSTRST12  = .;
 IF (DSTRST30  >= 85 ) THEN DSTRST30  = .;
 IF (DSTWORST  >= 85 ) THEN DSTWORST  = .;
 IF (ECSAGE  >= 985 ) THEN ECSAGE  = .;
 IF (ECSAGLST  >= 985 ) THEN ECSAGLST  = .;
 IF (ECSMFU  >= 85 ) THEN ECSMFU  = .;
 IF (ECSMLU  >= 85 ) THEN ECSMLU  = .;
 IF (ECSREC  >= 91 ) THEN ECSREC  = .;
 IF (ECSTASY  >= 91 ) THEN ECSTASY  = .;
 IF (ECSYFU  >= 9985 ) THEN ECSYFU  = .;
 IF (ECSYLU  >= 9985 ) THEN ECSYLU  = .;
 IF (ED4FLAG  >= 85 ) THEN ED4FLAG  = .;
 IF (EDFAM18  >= 98 ) THEN EDFAM18  = .;
 IF (EDUCATN2  >= 98 ) THEN EDUCATN2  = .;
 IF (EMPSTAT4  >= 99 ) THEN EMPSTAT4  = .;
 IF (EMPSTATY  >= 99 ) THEN EMPSTATY  = .;
 IF (EQUANIL  >= 81 ) THEN EQUANIL  = .;
 IF (ESKAT  >= 81 ) THEN ESKAT  = .;
 IF (ETHER  >= 85 ) THEN ETHER  = .;
 IF (FIORICET  >= 81 ) THEN FIORICET  = .;
 IF (FIORINAL  >= 81 ) THEN FIORINAL  = .;
 IF (FIRSTPOS  >= 85 ) THEN FIRSTPOS  = .;
 IF (FLEXERIL  >= 81 ) THEN FLEXERIL  = .;
 IF (GAS  >= 85 ) THEN GAS  = .;
 IF (GHB  >= 94 ) THEN GHB  = .;
 IF (GHBREC  >= 91 ) THEN GHBREC  = .;
 IF (GLUE  >= 85 ) THEN GLUE  = .;
 IF (GNNDCLEN  >= 94 ) THEN GNNDCLEN  = .;
 IF (GNNDGET2  >= 94 ) THEN GNNDGET2  = .;
 IF (GNNDLSH1  >= 94 ) THEN GNNDLSH1  = .;
 IF (GNNDLSH2  >= 94 ) THEN GNNDLSH2  = .;
 IF (GNNDREUS  >= 94 ) THEN GNNDREUS  = .;
 IF (GRPHLTIN  >= 85 ) THEN GRPHLTIN  = .;
 IF (HAL30USE  >= 85 ) THEN HAL30USE  = .;
 IF (HALAGLST  >= 985 ) THEN HALAGLST  = .;
 IF (HALCION  >= 81 ) THEN HALCION  = .;
 IF (HALCUTDN  >= 85 ) THEN HALCUTDN  = .;
 IF (HALCUTEV  >= 85 ) THEN HALCUTEV  = .;
 IF (HALDAFLG  >= 98 ) THEN HALDAFLG  = .;
 IF (HALEMCTD  >= 85 ) THEN HALEMCTD  = .;
 IF (HALEMOPB  >= 85 ) THEN HALEMOPB  = .;
 IF (HALFMCTD  >= 85 ) THEN HALFMCTD  = .;
 IF (HALFMFPB  >= 85 ) THEN HALFMFPB  = .;
 IF (HALGTOVR  >= 91 ) THEN HALGTOVR  = .;
 IF (HALKPLMT  >= 85 ) THEN HALKPLMT  = .;
 IF (HALLAGE  >= 985 ) THEN HALLAGE  = .;
 IF (HALLAWTR  >= 85 ) THEN HALLAWTR  = .;
 IF (HALLIMIT  >= 85 ) THEN HALLIMIT  = .;
 IF (HALLOTTM  >= 85 ) THEN HALLOTTM  = .;
 IF (HALLREC  >= 91 ) THEN HALLREC  = .;
 IF (HALLSACT  >= 85 ) THEN HALLSACT  = .;
 IF (HALLSEFX  >= 91 ) THEN HALLSEFX  = .;
 IF (HALMFU  >= 85 ) THEN HALMFU  = .;
 IF (HALMLU  >= 85 ) THEN HALMLU  = .;
 IF (HALNDMOR  >= 85 ) THEN HALNDMOR  = .;
 IF (HALNEWA  >= 9985 ) THEN HALNEWA  = .;
 IF (HALNEWB  >= 9985 ) THEN HALNEWB  = .;
 IF (HALNEWC  >= 9985 ) THEN HALNEWC  = .;
 IF (HALNEWD  >= 9985 ) THEN HALNEWD  = .;
 IF (HALNEWE  >= 9985 ) THEN HALNEWE  = .;
 IF (HALNOLST  >= 91 ) THEN HALNOLST  = .;
 IF (HALPDANG  >= 85 ) THEN HALPDANG  = .;
 IF (HALPHCTD  >= 91 ) THEN HALPHCTD  = .;
 IF (HALPHLPB  >= 91 ) THEN HALPHLPB  = .;
 IF (HALSERPB  >= 85 ) THEN HALSERPB  = .;
 IF (HALYFU  >= 9985 ) THEN HALYFU  = .;
 IF (HALYLU  >= 9985 ) THEN HALYLU  = .;
 IF (HALYRTOT  >= 985 ) THEN HALYRTOT  = .;
 IF (HEALTH  >= 94 ) THEN HEALTH  = .;
 IF (HEOTNDL  >= 91 ) THEN HEOTNDL  = .;
 IF (HEOTOTH  >= 91 ) THEN HEOTOTH  = .;
 IF (HEOTSMK  >= 91 ) THEN HEOTSMK  = .;
 IF (HEOTSNF  >= 91 ) THEN HEOTSNF  = .;
 IF (HEOTSP  >= 85 ) THEN HEOTSP  = .;
 IF (HER30USE  >= 85 ) THEN HER30USE  = .;
 IF (HERAGE  >= 985 ) THEN HERAGE  = .;
 IF (HERAGLST  >= 985 ) THEN HERAGLST  = .;
 IF (HERCUT1X  >= 91 ) THEN HERCUT1X  = .;
 IF (HERCUTDN  >= 91 ) THEN HERCUTDN  = .;
 IF (HERCUTEV  >= 91 ) THEN HERCUTEV  = .;
 IF (HEREMCTD  >= 91 ) THEN HEREMCTD  = .;
 IF (HEREMOPB  >= 91 ) THEN HEREMOPB  = .;
 IF (HEREVER  >= 94 ) THEN HEREVER  = .;
 IF (HERFMCTD  >= 91 ) THEN HERFMCTD  = .;
 IF (HERFMFPB  >= 91 ) THEN HERFMFPB  = .;
 IF (HERGTOVR  >= 91 ) THEN HERGTOVR  = .;
 IF (HERKPLMT  >= 91 ) THEN HERKPLMT  = .;
 IF (HERLAWTR  >= 91 ) THEN HERLAWTR  = .;
 IF (HERLIMIT  >= 91 ) THEN HERLIMIT  = .;
 IF (HERLOTTM  >= 91 ) THEN HERLOTTM  = .;
 IF (HERLSACT  >= 91 ) THEN HERLSACT  = .;
 IF (HERLSEFX  >= 91 ) THEN HERLSEFX  = .;
 IF (HERMFU  >= 85 ) THEN HERMFU  = .;
 IF (HERMLU  >= 85 ) THEN HERMLU  = .;
 IF (HERNDMOR  >= 91 ) THEN HERNDMOR  = .;
 IF (HERNEEDL  >= 91 ) THEN HERNEEDL  = .;
 IF (HERPDANG  >= 91 ) THEN HERPDANG  = .;
 IF (HERPHCTD  >= 91 ) THEN HERPHCTD  = .;
 IF (HERPHLPB  >= 91 ) THEN HERPHLPB  = .;
 IF (HERREC  >= 91 ) THEN HERREC  = .;
 IF (HERSERPB  >= 91 ) THEN HERSERPB  = .;
 IF (HERSMOKE  >= 91 ) THEN HERSMOKE  = .;
 IF (HERSNIFF  >= 91 ) THEN HERSNIFF  = .;
 IF (HERWD3SX  >= 91 ) THEN HERWD3SX  = .;
 IF (HERWDSMT  >= 91 ) THEN HERWDSMT  = .;
 IF (HERYFU  >= 9985 ) THEN HERYFU  = .;
 IF (HERYLU  >= 9985 ) THEN HERYLU  = .;
 IF (HERYRTOT  >= 985 ) THEN HERYRTOT  = .;
 IF (HL30EST  >= 85 ) THEN HL30EST  = .;
 IF (HLBSTWAY  >= 85 ) THEN HLBSTWAY  = .;
 IF (HLCALL99  >= 98 ) THEN HLCALL99  = .;
 IF (HLCALLFG  >= 98 ) THEN HLCALLFG  = .;
 IF (HLCLAST  >= 85 ) THEN HLCLAST  = .;
 IF (HLCNOTMO  >= 85 ) THEN HLCNOTMO  = .;
 IF (HLCNOTYR  >= 85 ) THEN HLCNOTYR  = .;
 IF (HLDAYPMO  >= 85 ) THEN HLDAYPMO  = .;
 IF (HLDAYPWK  >= 85 ) THEN HLDAYPWK  = .;
 IF (HLDAYPYR  >= 985 ) THEN HLDAYPYR  = .;
 IF (HLFQFLG  >= 98 ) THEN HLFQFLG  = .;
 IF (HLLOSRSN  >= 85 ) THEN HLLOSRSN  = .;
 IF (HLNVCOST  >= 85 ) THEN HLNVCOST  = .;
 IF (HLNVNEED  >= 94 ) THEN HLNVNEED  = .;
 IF (HLNVOFFR  >= 94 ) THEN HLNVOFFR  = .;
 IF (HLNVREF  >= 94 ) THEN HLNVREF  = .;
 IF (HLNVSOR  >= 94 ) THEN HLNVSOR  = .;
 IF (HLTINALC  >= 85 ) THEN HLTINALC  = .;
 IF (HLTINDRG  >= 85 ) THEN HLTINDRG  = .;
 IF (HLTINMNT  >= 85 ) THEN HLTINMNT  = .;
 IF (HLTINNOS  >= 85 ) THEN HLTINNOS  = .;
 IF (HLTOTFG  >= 98 ) THEN HLTOTFG  = .;
 IF (HR30EST  >= 91 ) THEN HR30EST  = .;
 IF (HRBSTWAY  >= 85 ) THEN HRBSTWAY  = .;
 IF (HRDAYPMO  >= 85 ) THEN HRDAYPMO  = .;
 IF (HRDAYPWK  >= 85 ) THEN HRDAYPWK  = .;
 IF (HRDAYPYR  >= 985 ) THEN HRDAYPYR  = .;
 IF (HRFQFLG  >= 98 ) THEN HRFQFLG  = .;
 IF (HRNDLREC  >= 91 ) THEN HRNDLREC  = .;
 IF (HRSMKREC  >= 91 ) THEN HRSMKREC  = .;
 IF (HRSNFREC  >= 91 ) THEN HRSNFREC  = .;
 IF (HRTOTFG  >= 98 ) THEN HRTOTFG  = .;
 IF (HSDIPLMA  >= 89 ) THEN HSDIPLMA  = .;
 IF (HSGED  >= 89 ) THEN HSGED  = .;
 IF (HYDROCOD  >= 81 ) THEN HYDROCOD  = .;
 IF (IEMAGE  >= 991 ) THEN IEMAGE  = .;
 IF (IEMYFU  >= 9999 ) THEN IEMYFU  = .;
 IF (IICGAVD  >= 98 ) THEN IICGAVD  = .;
 IF (IICGCRGP  >= 98 ) THEN IICGCRGP  = .;
 IF (IICGCRV  >= 98 ) THEN IICGCRV  = .;
 IF (IICGINCR  >= 98 ) THEN IICGINCR  = .;
 IF (IICGINFL  >= 98 ) THEN IICGINFL  = .;
 IF (IICGIRTB  >= 98 ) THEN IICGIRTB  = .;
 IF (IICGLMR  >= 98 ) THEN IICGLMR  = .;
 IF (IICGNCG  >= 98 ) THEN IICGNCG  = .;
 IF (IICGNCTL  >= 98 ) THEN IICGNCTL  = .;
 IF (IICGNINF  >= 98 ) THEN IICGNINF  = .;
 IF (IICGPLN  >= 98 ) THEN IICGPLN  = .;
 IF (IICGRGDY  >= 98 ) THEN IICGRGDY  = .;
 IF (IICGRGNM  >= 98 ) THEN IICGRGNM  = .;
 IF (IICGRGWK  >= 98 ) THEN IICGRGWK  = .;
 IF (IICGROUT  >= 98 ) THEN IICGROUT  = .;
 IF (IICGSAT  >= 98 ) THEN IICGSAT  = .;
 IF (IICGSLHR  >= 98 ) THEN IICGSLHR  = .;
 IF (IMPAIR  >= 85 ) THEN IMPAIR  = .;
 IF (IMPCONCN  >= 85 ) THEN IMPCONCN  = .;
 IF (IMPDYFRQ  >= 94 ) THEN IMPDYFRQ  = .;
 IF (IMPGOUT  >= 85 ) THEN IMPGOUT  = .;
 IF (IMPGOUTM  >= 94 ) THEN IMPGOUTM  = .;
 IF (IMPHHLD  >= 85 ) THEN IMPHHLD  = .;
 IF (IMPHHLDM  >= 94 ) THEN IMPHHLDM  = .;
 IF (IMPPEOP  >= 85 ) THEN IMPPEOP  = .;
 IF (IMPPEOPM  >= 94 ) THEN IMPPEOPM  = .;
 IF (IMPREMEM  >= 85 ) THEN IMPREMEM  = .;
 IF (IMPRESP  >= 85 ) THEN IMPRESP  = .;
 IF (IMPRESPM  >= 94 ) THEN IMPRESPM  = .;
 IF (IMPSOC  >= 85 ) THEN IMPSOC  = .;
 IF (IMPSOCM  >= 94 ) THEN IMPSOCM  = .;
 IF (IMPWEEKS  >= 94 ) THEN IMPWEEKS  = .;
 IF (IMPWORK  >= 85 ) THEN IMPWORK  = .;
 IF (IMPYDAYS  >= 994 ) THEN IMPYDAYS  = .;
 IF (IN30EST  >= 91 ) THEN IN30EST  = .;
 IF (INBSTWAY  >= 85 ) THEN INBSTWAY  = .;
 IF (INDAYPMO  >= 89 ) THEN INDAYPMO  = .;
 IF (INDAYPWK  >= 85 ) THEN INDAYPWK  = .;
 IF (INDAYPYR  >= 985 ) THEN INDAYPYR  = .;
 IF (INFQFLG  >= 98 ) THEN INFQFLG  = .;
 IF (INHAGE  >= 985 ) THEN INHAGE  = .;
 IF (INHAGLST  >= 985 ) THEN INHAGLST  = .;
 IF (INHCUTDN  >= 85 ) THEN INHCUTDN  = .;
 IF (INHCUTEV  >= 91 ) THEN INHCUTEV  = .;
 IF (INHDY30A  >= 85 ) THEN INHDY30A  = .;
 IF (INHEMCTD  >= 91 ) THEN INHEMCTD  = .;
 IF (INHEMOPB  >= 85 ) THEN INHEMOPB  = .;
 IF (INHEVER  >= 91 ) THEN INHEVER  = .;
 IF (INHFMCTD  >= 91 ) THEN INHFMCTD  = .;
 IF (INHFMFPB  >= 85 ) THEN INHFMFPB  = .;
 IF (INHGTOVR  >= 85 ) THEN INHGTOVR  = .;
 IF (INHKPLMT  >= 91 ) THEN INHKPLMT  = .;
 IF (INHLAWTR  >= 85 ) THEN INHLAWTR  = .;
 IF (INHLIMIT  >= 85 ) THEN INHLIMIT  = .;
 IF (INHLOTTM  >= 85 ) THEN INHLOTTM  = .;
 IF (INHLSACT  >= 85 ) THEN INHLSACT  = .;
 IF (INHLSEFX  >= 85 ) THEN INHLSEFX  = .;
 IF (INHMFU  >= 85 ) THEN INHMFU  = .;
 IF (INHMLU  >= 85 ) THEN INHMLU  = .;
 IF (INHNDMOR  >= 85 ) THEN INHNDMOR  = .;
 IF (INHNEWA  >= 9985 ) THEN INHNEWA  = .;
 IF (INHNEWB  >= 9985 ) THEN INHNEWB  = .;
 IF (INHNEWC  >= 9985 ) THEN INHNEWC  = .;
 IF (INHNEWD  >= 9991 ) THEN INHNEWD  = .;
 IF (INHNEWE  >= 9991 ) THEN INHNEWE  = .;
 IF (INHNOLST  >= 85 ) THEN INHNOLST  = .;
 IF (INHOSPYR  >= 85 ) THEN INHOSPYR  = .;
 IF (INHPDANG  >= 85 ) THEN INHPDANG  = .;
 IF (INHPHCTD  >= 91 ) THEN INHPHCTD  = .;
 IF (INHPHLPB  >= 85 ) THEN INHPHLPB  = .;
 IF (INHREC  >= 85 ) THEN INHREC  = .;
 IF (INHSERPB  >= 85 ) THEN INHSERPB  = .;
 IF (INHYFU  >= 9985 ) THEN INHYFU  = .;
 IF (INHYLU  >= 9985 ) THEN INHYLU  = .;
 IF (INHYRTOT  >= 985 ) THEN INHYRTOT  = .;
 IF (INTOTFG  >= 98 ) THEN INTOTFG  = .;
 IF (IONAMIN  >= 81 ) THEN IONAMIN  = .;
 IF (IRALCAGE  >= 991 ) THEN IRALCAGE  = .;
 IF (IRALCD5  >= 91 ) THEN IRALCD5  = .;
 IF (IRALCFM  >= 91 ) THEN IRALCFM  = .;
 IF (IRALCFY  >= 991 ) THEN IRALCFY  = .;
 IF (IRALCYFU  >= 9999 ) THEN IRALCYFU  = .;
 IF (IRANLAGE  >= 991 ) THEN IRANLAGE  = .;
 IF (IRANLFY  >= 991 ) THEN IRANLFY  = .;
 IF (IRANLYFU  >= 9999 ) THEN IRANLYFU  = .;
 IF (IRCD2YFU  >= 9993 ) THEN IRCD2YFU  = .;
 IF (IRCDUAGE  >= 991 ) THEN IRCDUAGE  = .;
 IF (IRCGRAGE  >= 991 ) THEN IRCGRAGE  = .;
 IF (IRCGRFM  >= 91 ) THEN IRCGRFM  = .;
 IF (IRCGRYFU  >= 9999 ) THEN IRCGRYFU  = .;
 IF (IRCHWAGE  >= 991 ) THEN IRCHWAGE  = .;
 IF (IRCHWFM  >= 91 ) THEN IRCHWFM  = .;
 IF (IRCHWYFU  >= 9999 ) THEN IRCHWYFU  = .;
 IF (IRCIGAGE  >= 991 ) THEN IRCIGAGE  = .;
 IF (IRCIGFM  >= 91 ) THEN IRCIGFM  = .;
 IF (IRCIGYFU  >= 9999 ) THEN IRCIGYFU  = .;
 IF (IRCOCAGE  >= 991 ) THEN IRCOCAGE  = .;
 IF (IRCOCFM  >= 91 ) THEN IRCOCFM  = .;
 IF (IRCOCFY  >= 991 ) THEN IRCOCFY  = .;
 IF (IRCOCYFU  >= 9999 ) THEN IRCOCYFU  = .;
 IF (IRCRKAGE  >= 991 ) THEN IRCRKAGE  = .;
 IF (IRCRKFM  >= 91 ) THEN IRCRKFM  = .;
 IF (IRCRKFY  >= 991 ) THEN IRCRKFY  = .;
 IF (IRCRKYFU  >= 9999 ) THEN IRCRKYFU  = .;
 IF (IRECSAGE  >= 991 ) THEN IRECSAGE  = .;
 IF (IRECSYFU  >= 9999 ) THEN IRECSYFU  = .;
 IF (IRHALAGE  >= 991 ) THEN IRHALAGE  = .;
 IF (IRHALFM  >= 91 ) THEN IRHALFM  = .;
 IF (IRHALFY  >= 991 ) THEN IRHALFY  = .;
 IF (IRHALYFU  >= 9999 ) THEN IRHALYFU  = .;
 IF (IRHERAGE  >= 991 ) THEN IRHERAGE  = .;
 IF (IRHERFM  >= 91 ) THEN IRHERFM  = .;
 IF (IRHERFY  >= 991 ) THEN IRHERFY  = .;
 IF (IRHERYFU  >= 9999 ) THEN IRHERYFU  = .;
 IF (IRINHAGE  >= 991 ) THEN IRINHAGE  = .;
 IF (IRINHFM  >= 91 ) THEN IRINHFM  = .;
 IF (IRINHFY  >= 991 ) THEN IRINHFY  = .;
 IF (IRINHYFU  >= 9999 ) THEN IRINHYFU  = .;
 IF (IRLSDAGE  >= 991 ) THEN IRLSDAGE  = .;
 IF (IRLSDYFU  >= 9999 ) THEN IRLSDYFU  = .;
 IF (IRMARIT  >= 99 ) THEN IRMARIT  = .;
 IF (IRMJAGE  >= 991 ) THEN IRMJAGE  = .;
 IF (IRMJFM  >= 91 ) THEN IRMJFM  = .;
 IF (IRMJFY  >= 991 ) THEN IRMJFY  = .;
 IF (IRMJYFU  >= 9999 ) THEN IRMJYFU  = .;
 IF (IRMTHAGE  >= 991 ) THEN IRMTHAGE  = .;
 IF (IRMTHFY  >= 991 ) THEN IRMTHFY  = .;
 IF (IRMTHYFU  >= 9999 ) THEN IRMTHYFU  = .;
 IF (IROTHHLT  >= 99 ) THEN IROTHHLT  = .;
 IF (IROXYAGE  >= 991 ) THEN IROXYAGE  = .;
 IF (IROXYFY  >= 991 ) THEN IROXYFY  = .;
 IF (IROXYYFU  >= 9999 ) THEN IROXYYFU  = .;
 IF (IRPCPAGE  >= 991 ) THEN IRPCPAGE  = .;
 IF (IRPCPYFU  >= 9999 ) THEN IRPCPYFU  = .;
 IF (IRSEDAGE  >= 991 ) THEN IRSEDAGE  = .;
 IF (IRSEDFY  >= 991 ) THEN IRSEDFY  = .;
 IF (IRSEDYFU  >= 9999 ) THEN IRSEDYFU  = .;
 IF (IRSLTAGE  >= 991 ) THEN IRSLTAGE  = .;
 IF (IRSLTYFU  >= 9999 ) THEN IRSLTYFU  = .;
 IF (IRSNFAGE  >= 991 ) THEN IRSNFAGE  = .;
 IF (IRSNFFM  >= 91 ) THEN IRSNFFM  = .;
 IF (IRSNFYFU  >= 9999 ) THEN IRSNFYFU  = .;
 IF (IRSTMAGE  >= 991 ) THEN IRSTMAGE  = .;
 IF (IRSTMFY  >= 991 ) THEN IRSTMFY  = .;
 IF (IRSTMYFU  >= 9999 ) THEN IRSTMYFU  = .;
 IF (IRTRNAGE  >= 991 ) THEN IRTRNAGE  = .;
 IF (IRTRNFY  >= 991 ) THEN IRTRNFY  = .;
 IF (IRTRNYFU  >= 9999 ) THEN IRTRNYFU  = .;
 IF (IRWELMOS  >= 99 ) THEN IRWELMOS  = .;
 IF (JBSTATR2  >= 98 ) THEN JBSTATR2  = .;
 IF (KETAMINE  >= 94 ) THEN KETAMINE  = .;
 IF (KETAREC  >= 91 ) THEN KETAREC  = .;
 IF (KLONOPIN  >= 81 ) THEN KLONOPIN  = .;
 IF (LFSCHWH2  >= 994 ) THEN LFSCHWH2  = .;
 IF (LFTSCHA2  >= 985 ) THEN LFTSCHA2  = .;
 IF (LGAS  >= 85 ) THEN LGAS  = .;
 IF (LIBRIUM  >= 81 ) THEN LIBRIUM  = .;
 IF (LIFANXD  >= 85 ) THEN LIFANXD  = .;
 IF (LIFASMA  >= 85 ) THEN LIFASMA  = .;
 IF (LIFBRONC  >= 85 ) THEN LIFBRONC  = .;
 IF (LIFCIRR  >= 85 ) THEN LIFCIRR  = .;
 IF (LIFDEPRS  >= 85 ) THEN LIFDEPRS  = .;
 IF (LIFDIAB  >= 85 ) THEN LIFDIAB  = .;
 IF (LIFHARTD  >= 85 ) THEN LIFHARTD  = .;
 IF (LIFHBP  >= 85 ) THEN LIFHBP  = .;
 IF (LIFHEPAT  >= 85 ) THEN LIFHEPAT  = .;
 IF (LIFHIV  >= 85 ) THEN LIFHIV  = .;
 IF (LIFLUNCA  >= 85 ) THEN LIFLUNCA  = .;
 IF (LIFNONE  >= 85 ) THEN LIFNONE  = .;
 IF (LIFPANCR  >= 85 ) THEN LIFPANCR  = .;
 IF (LIFPNEU  >= 85 ) THEN LIFPNEU  = .;
 IF (LIFSINUS  >= 85 ) THEN LIFSINUS  = .;
 IF (LIFSLPAP  >= 85 ) THEN LIFSLPAP  = .;
 IF (LIFSTDS  >= 85 ) THEN LIFSTDS  = .;
 IF (LIFSTROK  >= 85 ) THEN LIFSTROK  = .;
 IF (LIFTINN  >= 85 ) THEN LIFTINN  = .;
 IF (LIFTUBRC  >= 85 ) THEN LIFTUBRC  = .;
 IF (LIFULCER  >= 85 ) THEN LIFULCER  = .;
 IF (LIMBTROL  >= 81 ) THEN LIMBTROL  = .;
 IF (LOCSIZE  >= 85 ) THEN LOCSIZE  = .;
 IF (LSD  >= 91 ) THEN LSD  = .;
 IF (LSDAGE  >= 985 ) THEN LSDAGE  = .;
 IF (LSDAGLST  >= 985 ) THEN LSDAGLST  = .;
 IF (LSDMFU  >= 85 ) THEN LSDMFU  = .;
 IF (LSDMLU  >= 85 ) THEN LSDMLU  = .;
 IF (LSDREC  >= 91 ) THEN LSDREC  = .;
 IF (LSDYFU  >= 9985 ) THEN LSDYFU  = .;
 IF (LSDYLU  >= 9985 ) THEN LSDYLU  = .;
 IF (MAZANOR  >= 81 ) THEN MAZANOR  = .;
 IF (MEDICARE  >= 85 ) THEN MEDICARE  = .;
 IF (MEPROB  >= 81 ) THEN MEPROB  = .;
 IF (MESC  >= 91 ) THEN MESC  = .;
 IF (METHAGE  >= 981 ) THEN METHAGE  = .;
 IF (METHAQ  >= 81 ) THEN METHAQ  = .;
 IF (METHDES  >= 81 ) THEN METHDES  = .;
 IF (METHDON  >= 81 ) THEN METHDON  = .;
 IF (METHMFU  >= 81 ) THEN METHMFU  = .;
 IF (METHMLU  >= 81 ) THEN METHMLU  = .;
 IF (METHREC  >= 81 ) THEN METHREC  = .;
 IF (METHYFU  >= 9981 ) THEN METHYFU  = .;
 IF (METHYLU  >= 9981 ) THEN METHYLU  = .;
 IF (MILSTAT  >= 85 ) THEN MILSTAT  = .;
 IF (MILTOWN  >= 81 ) THEN MILTOWN  = .;
 IF (MJAGE  >= 985 ) THEN MJAGE  = .;
 IF (MJDAY30A  >= 85 ) THEN MJDAY30A  = .;
 IF (MJEVER  >= 94 ) THEN MJEVER  = .;
 IF (MJFQFLG  >= 98 ) THEN MJFQFLG  = .;
 IF (MJMFU  >= 85 ) THEN MJMFU  = .;
 IF (MJREC  >= 91 ) THEN MJREC  = .;
 IF (MJYFU  >= 9985 ) THEN MJYFU  = .;
 IF (MJYRTOT  >= 985 ) THEN MJYRTOT  = .;
 IF (MMBATJOB  >= 85 ) THEN MMBATJOB  = .;
 IF (MMBCLOSE  >= 85 ) THEN MMBCLOSE  = .;
 IF (MMBGIVE  >= 85 ) THEN MMBGIVE  = .;
 IF (MMBPLACE  >= 85 ) THEN MMBPLACE  = .;
 IF (MMBPLOS2  >= 85 ) THEN MMBPLOS2  = .;
 IF (MMBSELL  >= 85 ) THEN MMBSELL  = .;
 IF (MMBT30DY  >= 85 ) THEN MMBT30DY  = .;
 IF (MMBTPYR  >= 91 ) THEN MMBTPYR  = .;
 IF (MMBTREC1  >= 85 ) THEN MMBTREC1  = .;
 IF (MMBTREC2  >= 91 ) THEN MMBTREC2  = .;
 IF (MMBUYWHO  >= 85 ) THEN MMBUYWHO  = .;
 IF (MMFCLOSE  >= 91 ) THEN MMFCLOSE  = .;
 IF (MMFGIVE  >= 91 ) THEN MMFGIVE  = .;
 IF (MMFKEEP  >= 91 ) THEN MMFKEEP  = .;
 IF (MMFPLACE  >= 91 ) THEN MMFPLACE  = .;
 IF (MMFPLOS2  >= 85 ) THEN MMFPLOS2  = .;
 IF (MMFREWHO  >= 91 ) THEN MMFREWHO  = .;
 IF (MMFSELL  >= 91 ) THEN MMFSELL  = .;
 IF (MMGETMJ  >= 85 ) THEN MMGETMJ  = .;
 IF (MMGGIVE  >= 91 ) THEN MMGGIVE  = .;
 IF (MMGKEEP  >= 91 ) THEN MMGKEEP  = .;
 IF (MMGSELL  >= 91 ) THEN MMGSELL  = .;
 IF (MMJNPCAT  >= 985 ) THEN MMJNPCAT  = .;
 IF (MMJNPCTB  >= 85 ) THEN MMJNPCTB  = .;
 IF (MMJNTLOO  >= 85 ) THEN MMJNTLOO  = .;
 IF (MMJNTNUM  >= 985 ) THEN MMJNTNUM  = .;
 IF (MMLS10GM  >= 991 ) THEN MMLS10GM  = .;
 IF (MMLS5LBS  >= 991 ) THEN MMLS5LBS  = .;
 IF (MMLSGMS  >= 91 ) THEN MMLSGMS  = .;
 IF (MMLSLBS  >= 91 ) THEN MMLSLBS  = .;
 IF (MMLSOZS  >= 91 ) THEN MMLSOZS  = .;
 IF (MMLSPCAT  >= 991 ) THEN MMLSPCAT  = .;
 IF (MMLSPCTB  >= 91 ) THEN MMLSPCTB  = .;
 IF (MMLSUNIT  >= 91 ) THEN MMLSUNIT  = .;
 IF (MMT30FRQ  >= 91 ) THEN MMT30FRQ  = .;
 IF (MMTCLOSE  >= 91 ) THEN MMTCLOSE  = .;
 IF (MMTGIVE  >= 91 ) THEN MMTGIVE  = .;
 IF (MMTJNTLS  >= 91 ) THEN MMTJNTLS  = .;
 IF (MMTJNTNM  >= 991 ) THEN MMTJNTNM  = .;
 IF (MMTJWRCB  >= 91 ) THEN MMTJWRCB  = .;
 IF (MMTJWRTH  >= 991 ) THEN MMTJWRTH  = .;
 IF (MMTKEEP  >= 91 ) THEN MMTKEEP  = .;
 IF (MMTLGMS  >= 91 ) THEN MMTLGMS  = .;
 IF (MMTLOZS  >= 91 ) THEN MMTLOZS  = .;
 IF (MMTLUNIT  >= 91 ) THEN MMTLUNIT  = .;
 IF (MMTLWRCB  >= 91 ) THEN MMTLWRCB  = .;
 IF (MMTLWRTH  >= 991 ) THEN MMTLWRTH  = .;
 IF (MMTPLACE  >= 91 ) THEN MMTPLACE  = .;
 IF (MMTPLOS2  >= 85 ) THEN MMTPLOS2  = .;
 IF (MMTRADE  >= 91 ) THEN MMTRADE  = .;
 IF (MMTRD30D  >= 91 ) THEN MMTRD30D  = .;
 IF (MMTRDREC  >= 91 ) THEN MMTRDREC  = .;
 IF (MMTRDWHO  >= 91 ) THEN MMTRDWHO  = .;
 IF (MMTSELL  >= 91 ) THEN MMTSELL  = .;
 IF (MORPHINE  >= 81 ) THEN MORPHINE  = .;
 IF (MOVESPY2  >= 985 ) THEN MOVESPY2  = .;
 IF (MOVYRFLG  >= 98 ) THEN MOVYRFLG  = .;
 IF (MR30EST  >= 91 ) THEN MR30EST  = .;
 IF (MRBSTWAY  >= 85 ) THEN MRBSTWAY  = .;
 IF (MRDAYPMO  >= 85 ) THEN MRDAYPMO  = .;
 IF (MRDAYPWK  >= 85 ) THEN MRDAYPWK  = .;
 IF (MRDAYPYR  >= 985 ) THEN MRDAYPYR  = .;
 IF (MRJAGLST  >= 985 ) THEN MRJAGLST  = .;
 IF (MRJCUTDN  >= 83 ) THEN MRJCUTDN  = .;
 IF (MRJCUTEV  >= 83 ) THEN MRJCUTEV  = .;
 IF (MRJEMCTD  >= 83 ) THEN MRJEMCTD  = .;
 IF (MRJEMOPB  >= 83 ) THEN MRJEMOPB  = .;
 IF (MRJFMCTD  >= 83 ) THEN MRJFMCTD  = .;
 IF (MRJFMFPB  >= 83 ) THEN MRJFMFPB  = .;
 IF (MRJGTOVR  >= 83 ) THEN MRJGTOVR  = .;
 IF (MRJKPLMT  >= 83 ) THEN MRJKPLMT  = .;
 IF (MRJLAWTR  >= 83 ) THEN MRJLAWTR  = .;
 IF (MRJLIMIT  >= 83 ) THEN MRJLIMIT  = .;
 IF (MRJLOTTM  >= 83 ) THEN MRJLOTTM  = .;
 IF (MRJLSACT  >= 83 ) THEN MRJLSACT  = .;
 IF (MRJLSEFX  >= 83 ) THEN MRJLSEFX  = .;
 IF (MRJMLU  >= 85 ) THEN MRJMLU  = .;
 IF (MRJNDMOR  >= 83 ) THEN MRJNDMOR  = .;
 IF (MRJPDANG  >= 83 ) THEN MRJPDANG  = .;
 IF (MRJPHCTD  >= 83 ) THEN MRJPHCTD  = .;
 IF (MRJPHLPB  >= 83 ) THEN MRJPHLPB  = .;
 IF (MRJSERPB  >= 83 ) THEN MRJSERPB  = .;
 IF (MRJYLU  >= 9985 ) THEN MRJYLU  = .;
 IF (MRJYRBFR  >= 85 ) THEN MRJYRBFR  = .;
 IF (MRTOTFG  >= 98 ) THEN MRTOTFG  = .;
 IF (MTABSTWY  >= 81 ) THEN MTABSTWY  = .;
 IF (MTADYPMO  >= 81 ) THEN MTADYPMO  = .;
 IF (MTADYPWK  >= 81 ) THEN MTADYPWK  = .;
 IF (MTADYPYR  >= 981 ) THEN MTADYPYR  = .;
 IF (MTAFQFLG  >= 98 ) THEN MTAFQFLG  = .;
 IF (MTANDLRC  >= 81 ) THEN MTANDLRC  = .;
 IF (MTBSTWAY  >= 81 ) THEN MTBSTWAY  = .;
 IF (MTDAYPMO  >= 81 ) THEN MTDAYPMO  = .;
 IF (MTDAYPWK  >= 81 ) THEN MTDAYPWK  = .;
 IF (MTDAYPYR  >= 981 ) THEN MTDAYPYR  = .;
 IF (MTFQFLG  >= 98 ) THEN MTFQFLG  = .;
 IF (MTHAAGE  >= 981 ) THEN MTHAAGE  = .;
 IF (MTHAGLST  >= 981 ) THEN MTHAGLST  = .;
 IF (MTHAMFU  >= 81 ) THEN MTHAMFU  = .;
 IF (MTHAMP  >= 85 ) THEN MTHAMP  = .;
 IF (MTHANEDL  >= 81 ) THEN MTHANEDL  = .;
 IF (MTHAREC  >= 81 ) THEN MTHAREC  = .;
 IF (MTHAYFU  >= 9981 ) THEN MTHAYFU  = .;
 IF (MTHAYTOT  >= 981 ) THEN MTHAYTOT  = .;
 IF (MTHDEALR  >= 81 ) THEN MTHDEALR  = .;
 IF (MTHEVCK  >= 85 ) THEN MTHEVCK  = .;
 IF (MTHFFBOT  >= 81 ) THEN MTHFFBOT  = .;
 IF (MTHFFDLR  >= 81 ) THEN MTHFFDLR  = .;
 IF (MTHFFLAS  >= 91 ) THEN MTHFFLAS  = .;
 IF (MTHFFLSP  >= 85 ) THEN MTHFFLSP  = .;
 IF (MTHFFNET  >= 81 ) THEN MTHFFNET  = .;
 IF (MTHFFOSP  >= 81 ) THEN MTHFFOSP  = .;
 IF (MTHFFOTH  >= 81 ) THEN MTHFFOTH  = .;
 IF (MTHFFREE  >= 81 ) THEN MTHFFREE  = .;
 IF (MTHFFTAK  >= 81 ) THEN MTHFFTAK  = .;
 IF (MTHFRBUY  >= 81 ) THEN MTHFRBUY  = .;
 IF (MTHFRFRE  >= 81 ) THEN MTHFRFRE  = .;
 IF (MTHFRTKE  >= 81 ) THEN MTHFRTKE  = .;
 IF (MTHGTLA2  >= 81 ) THEN MTHGTLA2  = .;
 IF (MTHGTOS2  >= 81 ) THEN MTHGTOS2  = .;
 IF (MTHINET  >= 81 ) THEN MTHINET  = .;
 IF (MTHNCFLG  >= 98 ) THEN MTHNCFLG  = .;
 IF (MTHNEEDL  >= 81 ) THEN MTHNEEDL  = .;
 IF (MTHNORSN  >= 94 ) THEN MTHNORSN  = .;
 IF (MTHNOSP  >= 94 ) THEN MTHNOSP  = .;
 IF (MTHOTHS2  >= 81 ) THEN MTHOTHS2  = .;
 IF (MTHOTHWY  >= 81 ) THEN MTHOTHWY  = .;
 IF (MTHYRTOT  >= 981 ) THEN MTHYRTOT  = .;
 IF (MTNDLREC  >= 81 ) THEN MTNDLREC  = .;
 IF (MTTOTFG  >= 98 ) THEN MTTOTFG  = .;
 IF (MXMJPNLT  >= 85 ) THEN MXMJPNLT  = .;
 IF (NDLREC06  >= 81 ) THEN NDLREC06  = .;
 IF (NDMRBUSY  >= 81 ) THEN NDMRBUSY  = .;
 IF (NDMRFOUT  >= 81 ) THEN NDMRFOUT  = .;
 IF (NDMRHNDL  >= 81 ) THEN NDMRHNDL  = .;
 IF (NDMRJOB  >= 81 ) THEN NDMRJOB  = .;
 IF (NDMRLMCV  >= 81 ) THEN NDMRLMCV  = .;
 IF (NDMRNBR  >= 81 ) THEN NDMRNBR  = .;
 IF (NDMRNHCV  >= 81 ) THEN NDMRNHCV  = .;
 IF (NDMRNHLP  >= 81 ) THEN NDMRNHLP  = .;
 IF (NDMRNOND  >= 81 ) THEN NDMRNOND  = .;
 IF (NDMRNTSP  >= 81 ) THEN NDMRNTSP  = .;
 IF (NDMROPEN  >= 81 ) THEN NDMROPEN  = .;
 IF (NDMRREDY  >= 81 ) THEN NDMRREDY  = .;
 IF (NDMRSOR  >= 81 ) THEN NDMRSOR  = .;
 IF (NDMRTYPE  >= 81 ) THEN NDMRTYPE  = .;
 IF (NDMRWHER  >= 81 ) THEN NDMRWHER  = .;
 IF (NDTMRALC  >= 81 ) THEN NDTMRALC  = .;
 IF (NDTMRANL  >= 81 ) THEN NDTMRANL  = .;
 IF (NDTMRCOC  >= 81 ) THEN NDTMRCOC  = .;
 IF (NDTMREFT  >= 81 ) THEN NDTMREFT  = .;
 IF (NDTMRHAL  >= 81 ) THEN NDTMRHAL  = .;
 IF (NDTMRHER  >= 81 ) THEN NDTMRHER  = .;
 IF (NDTMRINH  >= 81 ) THEN NDTMRINH  = .;
 IF (NDTMRMJ  >= 81 ) THEN NDTMRMJ  = .;
 IF (NDTMROTH  >= 81 ) THEN NDTMROTH  = .;
 IF (NDTMRSED  >= 81 ) THEN NDTMRSED  = .;
 IF (NDTMRSTM  >= 81 ) THEN NDTMRSTM  = .;
 IF (NDTMRTRN  >= 81 ) THEN NDTMRTRN  = .;
 IF (NDTXALCR  >= 81 ) THEN NDTXALCR  = .;
 IF (NDTXANLR  >= 81 ) THEN NDTXANLR  = .;
 IF (NDTXBUSY  >= 81 ) THEN NDTXBUSY  = .;
 IF (NDTXCOCR  >= 81 ) THEN NDTXCOCR  = .;
 IF (NDTXDG1R  >= 9981 ) THEN NDTXDG1R  = .;
 IF (NDTXDG2R  >= 9981 ) THEN NDTXDG2R  = .;
 IF (NDTXDG3R  >= 9981 ) THEN NDTXDG3R  = .;
 IF (NDTXDG4R  >= 9981 ) THEN NDTXDG4R  = .;
 IF (NDTXDG5R  >= 9981 ) THEN NDTXDG5R  = .;
 IF (NDTXEFTR  >= 81 ) THEN NDTXEFTR  = .;
 IF (NDTXFOUT  >= 81 ) THEN NDTXFOUT  = .;
 IF (NDTXHALR  >= 81 ) THEN NDTXHALR  = .;
 IF (NDTXHERR  >= 81 ) THEN NDTXHERR  = .;
 IF (NDTXHNDL  >= 81 ) THEN NDTXHNDL  = .;
 IF (NDTXINHR  >= 81 ) THEN NDTXINHR  = .;
 IF (NDTXJOB  >= 81 ) THEN NDTXJOB  = .;
 IF (NDTXLMCV  >= 81 ) THEN NDTXLMCV  = .;
 IF (NDTXMJR  >= 81 ) THEN NDTXMJR  = .;
 IF (NDTXMORE  >= 81 ) THEN NDTXMORE  = .;
 IF (NDTXNBR  >= 81 ) THEN NDTXNBR  = .;
 IF (NDTXNEDR  >= 81 ) THEN NDTXNEDR  = .;
 IF (NDTXNHCV  >= 81 ) THEN NDTXNHCV  = .;
 IF (NDTXNHLP  >= 81 ) THEN NDTXNHLP  = .;
 IF (NDTXNOND  >= 81 ) THEN NDTXNOND  = .;
 IF (NDTXNTSP  >= 81 ) THEN NDTXNTSP  = .;
 IF (NDTXOPEN  >= 81 ) THEN NDTXOPEN  = .;
 IF (NDTXREDY  >= 81 ) THEN NDTXREDY  = .;
 IF (NDTXSEDR  >= 81 ) THEN NDTXSEDR  = .;
 IF (NDTXSODR  >= 81 ) THEN NDTXSODR  = .;
 IF (NDTXSOR  >= 81 ) THEN NDTXSOR  = .;
 IF (NDTXSTMR  >= 81 ) THEN NDTXSTMR  = .;
 IF (NDTXTRNR  >= 81 ) THEN NDTXTRNR  = .;
 IF (NDTXTYPE  >= 81 ) THEN NDTXTYPE  = .;
 IF (NDTXWHER  >= 81 ) THEN NDTXWHER  = .;
 IF (NEDLRECR  >= 81 ) THEN NEDLRECR  = .;
 IF (NEMBBARB  >= 81 ) THEN NEMBBARB  = .;
 IF (NITOXID  >= 85 ) THEN NITOXID  = .;
 IF (NMERTMT2  >= 985 ) THEN NMERTMT2  = .;
 IF (NMNGTHS2  >= 985 ) THEN NMNGTHS2  = .;
 IF (NOBOOKY2  >= 985 ) THEN NOBOOKY2  = .;
 IF (NODR30A  >= 985 ) THEN NODR30A  = .;
 IF (NOMARR2  >= 94 ) THEN NOMARR2  = .;
 IF (OBLA  >= 81 ) THEN OBLA  = .;
 IF (OSTNEEDL  >= 81 ) THEN OSTNEEDL  = .;
 IF (OSTNLREC  >= 81 ) THEN OSTNLREC  = .;
 IF (OTCFLAG  >= 98 ) THEN OTCFLAG  = .;
 IF (OTDGNDLA  >= 9985 ) THEN OTDGNDLA  = .;
 IF (OTDGNDLB  >= 9985 ) THEN OTDGNDLB  = .;
 IF (OTDGNDLC  >= 9997 ) THEN OTDGNDLC  = .;
 IF (OTDGNDLD  >= 9985 ) THEN OTDGNDLD  = .;
 IF (OTDGNDLE  >= 9985 ) THEN OTDGNDLE  = .;
 IF (OTDGNEDL  >= 94 ) THEN OTDGNEDL  = .;
 IF (OXBSTWAY  >= 81 ) THEN OXBSTWAY  = .;
 IF (OXDAYPMO  >= 81 ) THEN OXDAYPMO  = .;
 IF (OXDAYPWK  >= 81 ) THEN OXDAYPWK  = .;
 IF (OXDAYPYR  >= 981 ) THEN OXDAYPYR  = .;
 IF (OXFQFLG  >= 98 ) THEN OXFQFLG  = .;
 IF (OXTOTFG  >= 98 ) THEN OXTOTFG  = .;
 IF (OXYAGLST  >= 981 ) THEN OXYAGLST  = .;
 IF (OXYCAGE  >= 981 ) THEN OXYCAGE  = .;
 IF (OXYCMFU  >= 81 ) THEN OXYCMFU  = .;
 IF (OXYCMLU  >= 81 ) THEN OXYCMLU  = .;
 IF (OXYCONTN  >= 81 ) THEN OXYCONTN  = .;
 IF (OXYCREC  >= 81 ) THEN OXYCREC  = .;
 IF (OXYCYFU  >= 9981 ) THEN OXYCYFU  = .;
 IF (OXYCYLU  >= 9981 ) THEN OXYCYLU  = .;
 IF (OXYYRTOT  >= 981 ) THEN OXYYRTOT  = .;
 IF (PAROLREL  >= 85 ) THEN PAROLREL  = .;
 IF (PCP  >= 91 ) THEN PCP  = .;
 IF (PCPAGE  >= 985 ) THEN PCPAGE  = .;
 IF (PCPAGLST  >= 985 ) THEN PCPAGLST  = .;
 IF (PCPMFU  >= 85 ) THEN PCPMFU  = .;
 IF (PCPMLU  >= 85 ) THEN PCPMLU  = .;
 IF (PCPREC  >= 91 ) THEN PCPREC  = .;
 IF (PCPYFU  >= 9985 ) THEN PCPYFU  = .;
 IF (PCPYLU  >= 9985 ) THEN PCPYLU  = .;
 IF (PERCTYLX  >= 81 ) THEN PERCTYLX  = .;
 IF (PEYOTE  >= 91 ) THEN PEYOTE  = .;
 IF (PHENCOD  >= 81 ) THEN PHENCOD  = .;
 IF (PHENOBAR  >= 81 ) THEN PHENOBAR  = .;
 IF (PIPE30DY  >= 91 ) THEN PIPE30DY  = .;
 IF (PIPEVER  >= 94 ) THEN PIPEVER  = .;
 IF (PLACIDYL  >= 81 ) THEN PLACIDYL  = .;
 IF (PLCYCOV  >= 85 ) THEN PLCYCOV  = .;
 IF (PLEGINE  >= 81 ) THEN PLEGINE  = .;
 IF (PRBSTWAY  >= 81 ) THEN PRBSTWAY  = .;
 IF (PRDAYPMO  >= 81 ) THEN PRDAYPMO  = .;
 IF (PRDAYPWK  >= 81 ) THEN PRDAYPWK  = .;
 IF (PRDAYPYR  >= 981 ) THEN PRDAYPYR  = .;
 IF (PREGNANT  >= 94 ) THEN PREGNANT  = .;
 IF (PRELUDIN  >= 81 ) THEN PRELUDIN  = .;
 IF (PRFQFLG  >= 98 ) THEN PRFQFLG  = .;
 IF (PROBATON  >= 85 ) THEN PROBATON  = .;
 IF (PROPOXY  >= 81 ) THEN PROPOXY  = .;
 IF (PRTOTFG  >= 98 ) THEN PRTOTFG  = .;
 IF (PRVHLTIN  >= 85 ) THEN PRVHLTIN  = .;
 IF (PRXYDATA  >= 94 ) THEN PRXYDATA  = .;
 IF (PSILCY  >= 91 ) THEN PSILCY  = .;
 IF (PSYAGE2  >= 991 ) THEN PSYAGE2  = .;
 IF (PSYYFU2  >= 9999 ) THEN PSYYFU2  = .;
 IF (RESTTMAZ  >= 81 ) THEN RESTTMAZ  = .;
 IF (RITMPHEN  >= 81 ) THEN RITMPHEN  = .;
 IF (RK5ALDLY  >= 85 ) THEN RK5ALDLY  = .;
 IF (RK5ALWK  >= 85 ) THEN RK5ALWK  = .;
 IF (RKCOCOCC  >= 85 ) THEN RKCOCOCC  = .;
 IF (RKCOCREG  >= 85 ) THEN RKCOCREG  = .;
 IF (RKDIFCOC  >= 85 ) THEN RKDIFCOC  = .;
 IF (RKDIFCRK  >= 85 ) THEN RKDIFCRK  = .;
 IF (RKDIFHER  >= 85 ) THEN RKDIFHER  = .;
 IF (RKDIFLSD  >= 85 ) THEN RKDIFLSD  = .;
 IF (RKFQDBLT  >= 85 ) THEN RKFQDBLT  = .;
 IF (RKFQDNGR  >= 85 ) THEN RKFQDNGR  = .;
 IF (RKFQPBLT  >= 85 ) THEN RKFQPBLT  = .;
 IF (RKFQRSKY  >= 85 ) THEN RKFQRSKY  = .;
 IF (RKHERREG  >= 85 ) THEN RKHERREG  = .;
 IF (RKLSDREG  >= 85 ) THEN RKLSDREG  = .;
 IF (RKTRYHER  >= 85 ) THEN RKTRYHER  = .;
 IF (RKTRYLSD  >= 85 ) THEN RKTRYLSD  = .;
 IF (ROHYPNOL  >= 81 ) THEN ROHYPNOL  = .;
 IF (RSKDIFMJ  >= 85 ) THEN RSKDIFMJ  = .;
 IF (RSKMJOCC  >= 85 ) THEN RSKMJOCC  = .;
 IF (RSKMJREG  >= 85 ) THEN RSKMJREG  = .;
 IF (RSKPKCIG  >= 85 ) THEN RSKPKCIG  = .;
 IF (RSKSELL  >= 85 ) THEN RSKSELL  = .;
 IF (RSNMRJMO  >= 94 ) THEN RSNMRJMO  = .;
 IF (RSNOMRJ  >= 98 ) THEN RSNOMRJ  = .;
 IF (SALVDIV  >= 94 ) THEN SALVDIV  = .;
 IF (SALVREC  >= 91 ) THEN SALVREC  = .;
 IF (SANOREX  >= 81 ) THEN SANOREX  = .;
 IF (SCHDSICK  >= 85 ) THEN SCHDSICK  = .;
 IF (SCHDSKIP  >= 85 ) THEN SCHDSKIP  = .;
 IF (SCHENRL  >= 85 ) THEN SCHENRL  = .;
 IF (SDNTFTPT  >= 85 ) THEN SDNTFTPT  = .;
 IF (SEDAGE  >= 981 ) THEN SEDAGE  = .;
 IF (SEDAGLST  >= 981 ) THEN SEDAGLST  = .;
 IF (SEDCARD  >= 81 ) THEN SEDCARD  = .;
 IF (SEDCUT1X  >= 81 ) THEN SEDCUT1X  = .;
 IF (SEDCUTDN  >= 81 ) THEN SEDCUTDN  = .;
 IF (SEDCUTEV  >= 81 ) THEN SEDCUTEV  = .;
 IF (SEDDAFLG  >= 98 ) THEN SEDDAFLG  = .;
 IF (SEDDEALR  >= 81 ) THEN SEDDEALR  = .;
 IF (SEDEMCTD  >= 81 ) THEN SEDEMCTD  = .;
 IF (SEDEMOPB  >= 81 ) THEN SEDEMOPB  = .;
 IF (SEDEVER  >= 81 ) THEN SEDEVER  = .;
 IF (SEDFF1DR  >= 81 ) THEN SEDFF1DR  = .;
 IF (SEDFFAKE  >= 81 ) THEN SEDFFAKE  = .;
 IF (SEDFFBOT  >= 81 ) THEN SEDFFBOT  = .;
 IF (SEDFFDLR  >= 81 ) THEN SEDFFDLR  = .;
 IF (SEDFFDRS  >= 81 ) THEN SEDFFDRS  = .;
 IF (SEDFFLAS  >= 81 ) THEN SEDFFLAS  = .;
 IF (SEDFFLSP  >= 81 ) THEN SEDFFLSP  = .;
 IF (SEDFFNET  >= 81 ) THEN SEDFFNET  = .;
 IF (SEDFFOSP  >= 81 ) THEN SEDFFOSP  = .;
 IF (SEDFFOTH  >= 81 ) THEN SEDFFOTH  = .;
 IF (SEDFFREE  >= 81 ) THEN SEDFFREE  = .;
 IF (SEDFFSTL  >= 81 ) THEN SEDFFSTL  = .;
 IF (SEDFFTAK  >= 81 ) THEN SEDFFTAK  = .;
 IF (SEDFMCTD  >= 81 ) THEN SEDFMCTD  = .;
 IF (SEDFMFPB  >= 81 ) THEN SEDFMFPB  = .;
 IF (SEDFRBUY  >= 81 ) THEN SEDFRBUY  = .;
 IF (SEDFRFRE  >= 81 ) THEN SEDFRFRE  = .;
 IF (SEDFRTKE  >= 81 ) THEN SEDFRTKE  = .;
 IF (SEDGTLA2  >= 81 ) THEN SEDGTLA2  = .;
 IF (SEDGTOS2  >= 81 ) THEN SEDGTOS2  = .;
 IF (SEDGTOVR  >= 81 ) THEN SEDGTOVR  = .;
 IF (SEDINET  >= 81 ) THEN SEDINET  = .;
 IF (SEDKPLMT  >= 81 ) THEN SEDKPLMT  = .;
 IF (SEDLAWTR  >= 81 ) THEN SEDLAWTR  = .;
 IF (SEDLIMIT  >= 81 ) THEN SEDLIMIT  = .;
 IF (SEDLOTTM  >= 81 ) THEN SEDLOTTM  = .;
 IF (SEDLSACT  >= 81 ) THEN SEDLSACT  = .;
 IF (SEDLSEFX  >= 81 ) THEN SEDLSEFX  = .;
 IF (SEDMFU  >= 81 ) THEN SEDMFU  = .;
 IF (SEDMLU  >= 81 ) THEN SEDMLU  = .;
 IF (SEDNDMOR  >= 81 ) THEN SEDNDMOR  = .;
 IF (SEDNEWA  >= 9981 ) THEN SEDNEWA  = .;
 IF (SEDNEWB  >= 9981 ) THEN SEDNEWB  = .;
 IF (SEDNEWC  >= 9981 ) THEN SEDNEWC  = .;
 IF (SEDNEWD  >= 9981 ) THEN SEDNEWD  = .;
 IF (SEDNEWE  >= 9981 ) THEN SEDNEWE  = .;
 IF (SEDNOLST  >= 81 ) THEN SEDNOLST  = .;
 IF (SEDOTHS2  >= 81 ) THEN SEDOTHS2  = .;
 IF (SEDOTHWY  >= 81 ) THEN SEDOTHWY  = .;
 IF (SEDPDANG  >= 81 ) THEN SEDPDANG  = .;
 IF (SEDPHCTD  >= 81 ) THEN SEDPHCTD  = .;
 IF (SEDPHLPB  >= 81 ) THEN SEDPHLPB  = .;
 IF (SEDREC  >= 81 ) THEN SEDREC  = .;
 IF (SEDRX1DR  >= 81 ) THEN SEDRX1DR  = .;
 IF (SEDRXDRS  >= 81 ) THEN SEDRXDRS  = .;
 IF (SEDRXFAK  >= 81 ) THEN SEDRXFAK  = .;
 IF (SEDSERPB  >= 81 ) THEN SEDSERPB  = .;
 IF (SEDSTOLE  >= 81 ) THEN SEDSTOLE  = .;
 IF (SEDWD1SX  >= 81 ) THEN SEDWD1SX  = .;
 IF (SEDWDSMT  >= 81 ) THEN SEDWDSMT  = .;
 IF (SEDYFU  >= 9981 ) THEN SEDYFU  = .;
 IF (SEDYLU  >= 9981 ) THEN SEDYLU  = .;
 IF (SEDYRTOT  >= 981 ) THEN SEDYRTOT  = .;
 IF (SERAX  >= 81 ) THEN SERAX  = .;
 IF (SERVICE  >= 85 ) THEN SERVICE  = .;
 IF (SK65A  >= 81 ) THEN SK65A  = .;
 IF (SLT30BR2  >= 9985 ) THEN SLT30BR2  = .;
 IF (SLT30FAV  >= 91 ) THEN SLT30FAV  = .;
 IF (SLTMFU  >= 85 ) THEN SLTMFU  = .;
 IF (SLTREC  >= 91 ) THEN SLTREC  = .;
 IF (SLTTRY  >= 985 ) THEN SLTTRY  = .;
 IF (SLTYFU  >= 9985 ) THEN SLTYFU  = .;
 IF (SN30EST  >= 91 ) THEN SN30EST  = .;
 IF (SNF30BR2  >= 9985 ) THEN SNF30BR2  = .;
 IF (SNF30USE  >= 91 ) THEN SNF30USE  = .;
 IF (SNFAGLST  >= 985 ) THEN SNFAGLST  = .;
 IF (SNFAMJEV  >= 85 ) THEN SNFAMJEV  = .;
 IF (SNFEVER  >= 85 ) THEN SNFEVER  = .;
 IF (SNFREC  >= 85 ) THEN SNFREC  = .;
 IF (SNMOV5Y2  >= 985 ) THEN SNMOV5Y2  = .;
 IF (SNRLDCSN  >= 85 ) THEN SNRLDCSN  = .;
 IF (SNRLFRND  >= 85 ) THEN SNRLFRND  = .;
 IF (SNRLGIMP  >= 85 ) THEN SNRLGIMP  = .;
 IF (SNRLGSVC  >= 85 ) THEN SNRLGSVC  = .;
 IF (SNUFMFU  >= 85 ) THEN SNUFMFU  = .;
 IF (SNUFMLU  >= 85 ) THEN SNUFMLU  = .;
 IF (SNUFTRY  >= 985 ) THEN SNUFTRY  = .;
 IF (SNUFYFU  >= 9985 ) THEN SNUFYFU  = .;
 IF (SNUFYLU  >= 9985 ) THEN SNUFYLU  = .;
 IF (SNYATTAK  >= 85 ) THEN SNYATTAK  = .;
 IF (SNYSELL  >= 85 ) THEN SNYSELL  = .;
 IF (SNYSTOLE  >= 85 ) THEN SNYSTOLE  = .;
 IF (SOLVENT  >= 85 ) THEN SOLVENT  = .;
 IF (SOMA  >= 81 ) THEN SOMA  = .;
 IF (SPPAINT  >= 85 ) THEN SPPAINT  = .;
 IF (STADOL  >= 81 ) THEN STADOL  = .;
 IF (STBSTWAY  >= 81 ) THEN STBSTWAY  = .;
 IF (STDAYPMO  >= 81 ) THEN STDAYPMO  = .;
 IF (STDAYPWK  >= 81 ) THEN STDAYPWK  = .;
 IF (STDAYPYR  >= 981 ) THEN STDAYPYR  = .;
 IF (STFQFLG  >= 98 ) THEN STFQFLG  = .;
 IF (STIMAGE  >= 981 ) THEN STIMAGE  = .;
 IF (STIMMFU  >= 81 ) THEN STIMMFU  = .;
 IF (STIMMLU  >= 81 ) THEN STIMMLU  = .;
 IF (STIMNEWA  >= 9981 ) THEN STIMNEWA  = .;
 IF (STIMNEWB  >= 9981 ) THEN STIMNEWB  = .;
 IF (STIMNEWC  >= 9981 ) THEN STIMNEWC  = .;
 IF (STIMNEWD  >= 9981 ) THEN STIMNEWD  = .;
 IF (STIMNEWE  >= 9981 ) THEN STIMNEWE  = .;
 IF (STIMREC  >= 81 ) THEN STIMREC  = .;
 IF (STIMYFU  >= 9981 ) THEN STIMYFU  = .;
 IF (STIMYLU  >= 9981 ) THEN STIMYLU  = .;
 IF (STMAGLST  >= 981 ) THEN STMAGLST  = .;
 IF (STMCARD  >= 81 ) THEN STMCARD  = .;
 IF (STMCUT1X  >= 81 ) THEN STMCUT1X  = .;
 IF (STMCUTDN  >= 81 ) THEN STMCUTDN  = .;
 IF (STMCUTEV  >= 81 ) THEN STMCUTEV  = .;
 IF (STMDAFLG  >= 98 ) THEN STMDAFLG  = .;
 IF (STMDEALR  >= 81 ) THEN STMDEALR  = .;
 IF (STMEMCTD  >= 81 ) THEN STMEMCTD  = .;
 IF (STMEMOPB  >= 81 ) THEN STMEMOPB  = .;
 IF (STMEVER  >= 81 ) THEN STMEVER  = .;
 IF (STMFF1DR  >= 81 ) THEN STMFF1DR  = .;
 IF (STMFFAKE  >= 81 ) THEN STMFFAKE  = .;
 IF (STMFFBOT  >= 81 ) THEN STMFFBOT  = .;
 IF (STMFFDLR  >= 81 ) THEN STMFFDLR  = .;
 IF (STMFFDRS  >= 81 ) THEN STMFFDRS  = .;
 IF (STMFFLAS  >= 81 ) THEN STMFFLAS  = .;
 IF (STMFFLSP  >= 81 ) THEN STMFFLSP  = .;
 IF (STMFFNET  >= 81 ) THEN STMFFNET  = .;
 IF (STMFFOSP  >= 81 ) THEN STMFFOSP  = .;
 IF (STMFFOTH  >= 81 ) THEN STMFFOTH  = .;
 IF (STMFFREE  >= 81 ) THEN STMFFREE  = .;
 IF (STMFFSTL  >= 81 ) THEN STMFFSTL  = .;
 IF (STMFFTAK  >= 81 ) THEN STMFFTAK  = .;
 IF (STMFLBLU  >= 81 ) THEN STMFLBLU  = .;
 IF (STMFMCTD  >= 81 ) THEN STMFMCTD  = .;
 IF (STMFMFPB  >= 81 ) THEN STMFMFPB  = .;
 IF (STMFRBUY  >= 81 ) THEN STMFRBUY  = .;
 IF (STMFRFRE  >= 81 ) THEN STMFRFRE  = .;
 IF (STMFRTKE  >= 81 ) THEN STMFRTKE  = .;
 IF (STMGTLA2  >= 81 ) THEN STMGTLA2  = .;
 IF (STMGTOS2  >= 81 ) THEN STMGTOS2  = .;
 IF (STMGTOVR  >= 81 ) THEN STMGTOVR  = .;
 IF (STMINET  >= 81 ) THEN STMINET  = .;
 IF (STMKPLMT  >= 81 ) THEN STMKPLMT  = .;
 IF (STMLAWTR  >= 81 ) THEN STMLAWTR  = .;
 IF (STMLIMIT  >= 81 ) THEN STMLIMIT  = .;
 IF (STMLOTTM  >= 81 ) THEN STMLOTTM  = .;
 IF (STMLSACT  >= 81 ) THEN STMLSACT  = .;
 IF (STMLSEFX  >= 81 ) THEN STMLSEFX  = .;
 IF (STMNDMOR  >= 81 ) THEN STMNDMOR  = .;
 IF (STMNOLST  >= 81 ) THEN STMNOLST  = .;
 IF (STMOTHS2  >= 81 ) THEN STMOTHS2  = .;
 IF (STMOTHWY  >= 81 ) THEN STMOTHWY  = .;
 IF (STMPDANG  >= 81 ) THEN STMPDANG  = .;
 IF (STMPHCTD  >= 81 ) THEN STMPHCTD  = .;
 IF (STMPHLPB  >= 81 ) THEN STMPHLPB  = .;
 IF (STMRX1DR  >= 81 ) THEN STMRX1DR  = .;
 IF (STMRXDRS  >= 81 ) THEN STMRXDRS  = .;
 IF (STMRXFAK  >= 81 ) THEN STMRXFAK  = .;
 IF (STMSERPB  >= 81 ) THEN STMSERPB  = .;
 IF (STMSTOLE  >= 81 ) THEN STMSTOLE  = .;
 IF (STMWD2SX  >= 81 ) THEN STMWD2SX  = .;
 IF (STMWDSMT  >= 81 ) THEN STMWDSMT  = .;
 IF (STMYRTOT  >= 981 ) THEN STMYRTOT  = .;
 IF (STNEDL06  >= 81 ) THEN STNEDL06  = .;
 IF (STNEEDLR  >= 81 ) THEN STNEEDLR  = .;
 IF (STNLRC06  >= 81 ) THEN STNLRC06  = .;
 IF (STNLRECR  >= 81 ) THEN STNLRECR  = .;
 IF (STTOTFG  >= 98 ) THEN STTOTFG  = .;
 IF (SUICPLAN  >= 85 ) THEN SUICPLAN  = .;
 IF (SUICTHNK  >= 85 ) THEN SUICTHNK  = .;
 IF (SUICTRY  >= 85 ) THEN SUICTRY  = .;
 IF (SUMAGE  >= 991 ) THEN SUMAGE  = .;
 IF (SUMYFU  >= 9999 ) THEN SUMYFU  = .;
 IF (SVBSTWAY  >= 81 ) THEN SVBSTWAY  = .;
 IF (SVDAYPMO  >= 81 ) THEN SVDAYPMO  = .;
 IF (SVDAYPWK  >= 81 ) THEN SVDAYPWK  = .;
 IF (SVDAYPYR  >= 981 ) THEN SVDAYPYR  = .;
 IF (SVFQFLG  >= 98 ) THEN SVFQFLG  = .;
 IF (SVTOTFG  >= 98 ) THEN SVTOTFG  = .;
 IF (TALACEN  >= 81 ) THEN TALACEN  = .;
 IF (TALWIN  >= 81 ) THEN TALWIN  = .;
 IF (TALWINNX  >= 81 ) THEN TALWINNX  = .;
 IF (TELNO2  >= 85 ) THEN TELNO2  = .;
 IF (TENUATE  >= 81 ) THEN TENUATE  = .;
 IF (TRAMADOL  >= 81 ) THEN TRAMADOL  = .;
 IF (TRANAGE  >= 981 ) THEN TRANAGE  = .;
 IF (TRANMFU  >= 81 ) THEN TRANMFU  = .;
 IF (TRANMLU  >= 81 ) THEN TRANMLU  = .;
 IF (TRANREC  >= 81 ) THEN TRANREC  = .;
 IF (TRANXENE  >= 81 ) THEN TRANXENE  = .;
 IF (TRANYFU  >= 9981 ) THEN TRANYFU  = .;
 IF (TRANYLU  >= 9981 ) THEN TRANYLU  = .;
 IF (TRBSTWAY  >= 81 ) THEN TRBSTWAY  = .;
 IF (TRDAYPMO  >= 81 ) THEN TRDAYPMO  = .;
 IF (TRDAYPWK  >= 81 ) THEN TRDAYPWK  = .;
 IF (TRDAYPYR  >= 981 ) THEN TRDAYPYR  = .;
 IF (TRFQFLG  >= 98 ) THEN TRFQFLG  = .;
 IF (TRNAGLST  >= 981 ) THEN TRNAGLST  = .;
 IF (TRNCARD  >= 81 ) THEN TRNCARD  = .;
 IF (TRNCUTDN  >= 81 ) THEN TRNCUTDN  = .;
 IF (TRNCUTEV  >= 81 ) THEN TRNCUTEV  = .;
 IF (TRNDEALR  >= 81 ) THEN TRNDEALR  = .;
 IF (TRNEMCTD  >= 81 ) THEN TRNEMCTD  = .;
 IF (TRNEMOPB  >= 81 ) THEN TRNEMOPB  = .;
 IF (TRNEVER  >= 81 ) THEN TRNEVER  = .;
 IF (TRNEWA  >= 9981 ) THEN TRNEWA  = .;
 IF (TRNEWB  >= 9981 ) THEN TRNEWB  = .;
 IF (TRNEWC  >= 9981 ) THEN TRNEWC  = .;
 IF (TRNEWD  >= 9981 ) THEN TRNEWD  = .;
 IF (TRNEWE  >= 9981 ) THEN TRNEWE  = .;
 IF (TRNFF1DR  >= 81 ) THEN TRNFF1DR  = .;
 IF (TRNFFAKE  >= 81 ) THEN TRNFFAKE  = .;
 IF (TRNFFBOT  >= 81 ) THEN TRNFFBOT  = .;
 IF (TRNFFDLR  >= 81 ) THEN TRNFFDLR  = .;
 IF (TRNFFDRS  >= 81 ) THEN TRNFFDRS  = .;
 IF (TRNFFLAS  >= 81 ) THEN TRNFFLAS  = .;
 IF (TRNFFLSP  >= 81 ) THEN TRNFFLSP  = .;
 IF (TRNFFNET  >= 81 ) THEN TRNFFNET  = .;
 IF (TRNFFOSP  >= 81 ) THEN TRNFFOSP  = .;
 IF (TRNFFOTH  >= 81 ) THEN TRNFFOTH  = .;
 IF (TRNFFREE  >= 81 ) THEN TRNFFREE  = .;
 IF (TRNFFSTL  >= 81 ) THEN TRNFFSTL  = .;
 IF (TRNFFTAK  >= 81 ) THEN TRNFFTAK  = .;
 IF (TRNFMCTD  >= 81 ) THEN TRNFMCTD  = .;
 IF (TRNFMFPB  >= 81 ) THEN TRNFMFPB  = .;
 IF (TRNFRBUY  >= 81 ) THEN TRNFRBUY  = .;
 IF (TRNFRFRE  >= 81 ) THEN TRNFRFRE  = .;
 IF (TRNFRTKE  >= 81 ) THEN TRNFRTKE  = .;
 IF (TRNGTLA2  >= 81 ) THEN TRNGTLA2  = .;
 IF (TRNGTOS2  >= 81 ) THEN TRNGTOS2  = .;
 IF (TRNGTOVR  >= 81 ) THEN TRNGTOVR  = .;
 IF (TRNINET  >= 81 ) THEN TRNINET  = .;
 IF (TRNKPLMT  >= 81 ) THEN TRNKPLMT  = .;
 IF (TRNLAWTR  >= 81 ) THEN TRNLAWTR  = .;
 IF (TRNLIMIT  >= 81 ) THEN TRNLIMIT  = .;
 IF (TRNLOTTM  >= 81 ) THEN TRNLOTTM  = .;
 IF (TRNLSACT  >= 81 ) THEN TRNLSACT  = .;
 IF (TRNLSEFX  >= 81 ) THEN TRNLSEFX  = .;
 IF (TRNNDMOR  >= 81 ) THEN TRNNDMOR  = .;
 IF (TRNOLST  >= 81 ) THEN TRNOLST  = .;
 IF (TRNOTHS2  >= 81 ) THEN TRNOTHS2  = .;
 IF (TRNOTHWY  >= 81 ) THEN TRNOTHWY  = .;
 IF (TRNPDANG  >= 81 ) THEN TRNPDANG  = .;
 IF (TRNPHCTD  >= 81 ) THEN TRNPHCTD  = .;
 IF (TRNPHLPB  >= 81 ) THEN TRNPHLPB  = .;
 IF (TRNRX1DR  >= 81 ) THEN TRNRX1DR  = .;
 IF (TRNRXDRS  >= 81 ) THEN TRNRXDRS  = .;
 IF (TRNRXFAK  >= 81 ) THEN TRNRXFAK  = .;
 IF (TRNSERPB  >= 81 ) THEN TRNSERPB  = .;
 IF (TRNSTOLE  >= 81 ) THEN TRNSTOLE  = .;
 IF (TRNYRTOT  >= 981 ) THEN TRNYRTOT  = .;
 IF (TRTOTFG  >= 98 ) THEN TRTOTFG  = .;
 IF (TRYPREC  >= 91 ) THEN TRYPREC  = .;
 IF (TRYPTMN  >= 94 ) THEN TRYPTMN  = .;
 IF (TSTHIRE  >= 85 ) THEN TSTHIRE  = .;
 IF (TSTRAND  >= 85 ) THEN TSTRAND  = .;
 IF (TUINAL  >= 81 ) THEN TUINAL  = .;
 IF (TX12MSHG  >= 81 ) THEN TX12MSHG  = .;
 IF (TX12SGAD  >= 81 ) THEN TX12SGAD  = .;
 IF (TXALCDAG  >= 981 ) THEN TXALCDAG  = .;
 IF (TXALCDEV  >= 81 ) THEN TXALCDEV  = .;
 IF (TXALONAG  >= 981 ) THEN TXALONAG  = .;
 IF (TXALONEV  >= 81 ) THEN TXALONEV  = .;
 IF (TXDRGAAG  >= 981 ) THEN TXDRGAAG  = .;
 IF (TXDRGAEV  >= 81 ) THEN TXDRGAEV  = .;
 IF (TXDRONAG  >= 981 ) THEN TXDRONAG  = .;
 IF (TXDRONEV  >= 81 ) THEN TXDRONEV  = .;
 IF (TXENROLL  >= 81 ) THEN TXENROLL  = .;
 IF (TXEVER  >= 81 ) THEN TXEVER  = .;
 IF (TXFGADAG  >= 81 ) THEN TXFGADAG  = .;
 IF (TXFGALAG  >= 81 ) THEN TXFGALAG  = .;
 IF (TXFGDGAG  >= 81 ) THEN TXFGDGAG  = .;
 IF (TXLASREC  >= 81 ) THEN TXLASREC  = .;
 IF (TXLTYALC  >= 81 ) THEN TXLTYALC  = .;
 IF (TXLTYANL  >= 81 ) THEN TXLTYANL  = .;
 IF (TXLTYCOC  >= 81 ) THEN TXLTYCOC  = .;
 IF (TXLTYDU2  >= 99981 ) THEN TXLTYDU2  = .;
 IF (TXLTYHAL  >= 81 ) THEN TXLTYHAL  = .;
 IF (TXLTYHER  >= 81 ) THEN TXLTYHER  = .;
 IF (TXLTYINH  >= 81 ) THEN TXLTYINH  = .;
 IF (TXLTYMJ  >= 81 ) THEN TXLTYMJ  = .;
 IF (TXLTYMN2  >= 981 ) THEN TXLTYMN2  = .;
 IF (TXLTYOU2  >= 81 ) THEN TXLTYOU2  = .;
 IF (TXLTYSED  >= 81 ) THEN TXLTYSED  = .;
 IF (TXLTYSOD  >= 81 ) THEN TXLTYSOD  = .;
 IF (TXLTYSTM  >= 81 ) THEN TXLTYSTM  = .;
 IF (TXLTYTRN  >= 81 ) THEN TXLTYTRN  = .;
 IF (TXPYCAID  >= 81 ) THEN TXPYCAID  = .;
 IF (TXPYCARE  >= 81 ) THEN TXPYCARE  = .;
 IF (TXPYCORT  >= 81 ) THEN TXPYCORT  = .;
 IF (TXPYEMPL  >= 81 ) THEN TXPYEMPL  = .;
 IF (TXPYFMLY  >= 81 ) THEN TXPYFMLY  = .;
 IF (TXPYFRE  >= 81 ) THEN TXPYFRE  = .;
 IF (TXPYINS  >= 81 ) THEN TXPYINS  = .;
 IF (TXPYMILC  >= 81 ) THEN TXPYMILC  = .;
 IF (TXPYPUBP  >= 81 ) THEN TXPYPUBP  = .;
 IF (TXPYSAVE  >= 81 ) THEN TXPYSAVE  = .;
 IF (TXPYSOS  >= 81 ) THEN TXPYSOS  = .;
 IF (TXPYSP2  >= 81 ) THEN TXPYSP2  = .;
 IF (TXRCVNOW  >= 81 ) THEN TXRCVNOW  = .;
 IF (TXSHGFLG  >= 81 ) THEN TXSHGFLG  = .;
 IF (TXYADAAG  >= 981 ) THEN TXYADAAG  = .;
 IF (TXYADDAG  >= 981 ) THEN TXYADDAG  = .;
 IF (TXYALAGE  >= 981 ) THEN TXYALAGE  = .;
 IF (TXYALDAG  >= 981 ) THEN TXYALDAG  = .;
 IF (TXYALDRG  >= 81 ) THEN TXYALDRG  = .;
 IF (TXYDRAAG  >= 981 ) THEN TXYDRAAG  = .;
 IF (TXYDRAGE  >= 981 ) THEN TXYDRAGE  = .;
 IF (TXYDRALC  >= 81 ) THEN TXYDRALC  = .;
 IF (TXYRADG  >= 81 ) THEN TXYRADG  = .;
 IF (TXYRDCAD  >= 81 ) THEN TXYRDCAD  = .;
 IF (TXYRDOC  >= 81 ) THEN TXYRDOC  = .;
 IF (TXYRDTXO  >= 81 ) THEN TXYRDTXO  = .;
 IF (TXYRERAD  >= 81 ) THEN TXYRERAD  = .;
 IF (TXYREVER  >= 81 ) THEN TXYREVER  = .;
 IF (TXYRHOSP  >= 81 ) THEN TXYRHOSP  = .;
 IF (TXYRHPAD  >= 81 ) THEN TXYRHPAD  = .;
 IF (TXYRINAD  >= 81 ) THEN TXYRINAD  = .;
 IF (TXYRJAIL  >= 81 ) THEN TXYRJAIL  = .;
 IF (TXYRJLAD  >= 81 ) THEN TXYRJLAD  = .;
 IF (TXYRMHAD  >= 81 ) THEN TXYRMHAD  = .;
 IF (TXYRMHC  >= 81 ) THEN TXYRMHC  = .;
 IF (TXYRNME2  >= 981 ) THEN TXYRNME2  = .;
 IF (TXYROTAD  >= 81 ) THEN TXYROTAD  = .;
 IF (TXYROTS2  >= 981 ) THEN TXYROTS2  = .;
 IF (TXYRPOAD  >= 81 ) THEN TXYRPOAD  = .;
 IF (TXYRRFIN  >= 81 ) THEN TXYRRFIN  = .;
 IF (TXYRRFOP  >= 81 ) THEN TXYRRFOP  = .;
 IF (TXYRSGAD  >= 81 ) THEN TXYRSGAD  = .;
 IF (TXYRSHG  >= 81 ) THEN TXYRSHG  = .;
 IF (TXYRSOP  >= 81 ) THEN TXYRSOP  = .;
 IF (TXYRTXER  >= 81 ) THEN TXYRTXER  = .;
 IF (TXYRVSER  >= 81 ) THEN TXYRVSER  = .;
 IF (ULTRAM  >= 81 ) THEN ULTRAM  = .;
 IF (USALCTST  >= 85 ) THEN USALCTST  = .;
 IF (USDRGTST  >= 85 ) THEN USDRGTST  = .;
 IF (USEACM  >= 85 ) THEN USEACM  = .;
 IF (USEALCG  >= 89 ) THEN USEALCG  = .;
 IF (USEALMJ  >= 91 ) THEN USEALMJ  = .;
 IF (USEMJCG  >= 89 ) THEN USEMJCG  = .;
 IF (USENEXT  >= 85 ) THEN USENEXT  = .;
 IF (VALMDIAZ  >= 81 ) THEN VALMDIAZ  = .;
 IF (VICOLOR  >= 81 ) THEN VICOLOR  = .;
 IF (VISTAR  >= 81 ) THEN VISTAR  = .;
 IF (WKDRGED  >= 85 ) THEN WKDRGED  = .;
 IF (WORKBLAH  >= 85 ) THEN WORKBLAH  = .;
 IF (WORKDAYS  >= 85 ) THEN WORKDAYS  = .;
 IF (WORKRAND  >= 85 ) THEN WORKRAND  = .;
 IF (WRKBZCA2  >= 85 ) THEN WRKBZCA2  = .;
 IF (WRKBZCY2  >= 94 ) THEN WRKBZCY2  = .;
 IF (WRKEDYR  >= 85 ) THEN WRKEDYR  = .;
 IF (WRKHAVJB  >= 85 ) THEN WRKHAVJB  = .;
 IF (WRKHIRE  >= 85 ) THEN WRKHIRE  = .;
 IF (WRKHRSW2  >= 985 ) THEN WRKHRSW2  = .;
 IF (WRKIDST2  >= 9994 ) THEN WRKIDST2  = .;
 IF (WRKIDSY2  >= 9994 ) THEN WRKIDSY2  = .;
 IF (WRKJOBS2  >= 85 ) THEN WRKJOBS2  = .;
 IF (WRKLSTY2  >= 9985 ) THEN WRKLSTY2  = .;
 IF (WRKOCUP2  >= 9994 ) THEN WRKOCUP2  = .;
 IF (WRKOCUY2  >= 9997 ) THEN WRKOCUY2  = .;
 IF (WRKSLFEM  >= 85 ) THEN WRKSLFEM  = .;
 IF (WRKUNEMP  >= 85 ) THEN WRKUNEMP  = .;
 IF (WRKUNWKS  >= 85 ) THEN WRKUNWKS  = .;
 IF (XNAXATVN  >= 81 ) THEN XNAXATVN  = .;
 IF (YEATNDYR  >= 85 ) THEN YEATNDYR  = .;
 IF (YECOMACT  >= 85 ) THEN YECOMACT  = .;
 IF (YEDECLAS  >= 85 ) THEN YEDECLAS  = .;
 IF (YEDERGLR  >= 85 ) THEN YEDERGLR  = .;
 IF (YEDESPCL  >= 85 ) THEN YEDESPCL  = .;
 IF (YEDGPRGP  >= 85 ) THEN YEDGPRGP  = .;
 IF (YEFAIACT  >= 85 ) THEN YEFAIACT  = .;
 IF (YEFALDLY  >= 85 ) THEN YEFALDLY  = .;
 IF (YEFMJEVR  >= 85 ) THEN YEFMJEVR  = .;
 IF (YEFMJMO  >= 85 ) THEN YEFMJMO  = .;
 IF (YEFPKCIG  >= 85 ) THEN YEFPKCIG  = .;
 IF (YEGALDLY  >= 85 ) THEN YEGALDLY  = .;
 IF (YEGMJEVR  >= 85 ) THEN YEGMJEVR  = .;
 IF (YEGMJMO  >= 85 ) THEN YEGMJMO  = .;
 IF (YEGPKCIG  >= 85 ) THEN YEGPKCIG  = .;
 IF (YEHMSLYR  >= 85 ) THEN YEHMSLYR  = .;
 IF (YELSTGRD  >= 85 ) THEN YELSTGRD  = .;
 IF (YEMOV5Y2  >= 985 ) THEN YEMOV5Y2  = .;
 IF (YEOTHACT  >= 85 ) THEN YEOTHACT  = .;
 IF (YEPALDLY  >= 85 ) THEN YEPALDLY  = .;
 IF (YEPCHKHW  >= 85 ) THEN YEPCHKHW  = .;
 IF (YEPCHORE  >= 85 ) THEN YEPCHORE  = .;
 IF (YEPGDJOB  >= 85 ) THEN YEPGDJOB  = .;
 IF (YEPHLPHW  >= 85 ) THEN YEPHLPHW  = .;
 IF (YEPLMTSN  >= 85 ) THEN YEPLMTSN  = .;
 IF (YEPLMTTV  >= 85 ) THEN YEPLMTTV  = .;
 IF (YEPMJEVR  >= 85 ) THEN YEPMJEVR  = .;
 IF (YEPMJMO  >= 85 ) THEN YEPMJMO  = .;
 IF (YEPPKCIG  >= 85 ) THEN YEPPKCIG  = .;
 IF (YEPPROUD  >= 85 ) THEN YEPPROUD  = .;
 IF (YEPRBSLV  >= 85 ) THEN YEPRBSLV  = .;
 IF (YEPRGSTD  >= 85 ) THEN YEPRGSTD  = .;
 IF (YEPRTDNG  >= 85 ) THEN YEPRTDNG  = .;
 IF (YEPVNTYR  >= 85 ) THEN YEPVNTYR  = .;
 IF (YERLDCSN  >= 85 ) THEN YERLDCSN  = .;
 IF (YERLFRND  >= 85 ) THEN YERLFRND  = .;
 IF (YERLGIMP  >= 85 ) THEN YERLGIMP  = .;
 IF (YERLGSVC  >= 85 ) THEN YERLGSVC  = .;
 IF (YESCHACT  >= 85 ) THEN YESCHACT  = .;
 IF (YESCHFLT  >= 85 ) THEN YESCHFLT  = .;
 IF (YESCHIMP  >= 85 ) THEN YESCHIMP  = .;
 IF (YESCHINT  >= 85 ) THEN YESCHINT  = .;
 IF (YESCHWRK  >= 85 ) THEN YESCHWRK  = .;
 IF (YESLFHLP  >= 85 ) THEN YESLFHLP  = .;
 IF (YESTSALC  >= 85 ) THEN YESTSALC  = .;
 IF (YESTSCIG  >= 85 ) THEN YESTSCIG  = .;
 IF (YESTSDNK  >= 85 ) THEN YESTSDNK  = .;
 IF (YESTSMJ  >= 85 ) THEN YESTSMJ  = .;
 IF (YETCGJOB  >= 85 ) THEN YETCGJOB  = .;
 IF (YETLKBGF  >= 94 ) THEN YETLKBGF  = .;
 IF (YETLKNON  >= 85 ) THEN YETLKNON  = .;
 IF (YETLKOTA  >= 94 ) THEN YETLKOTA  = .;
 IF (YETLKPAR  >= 85 ) THEN YETLKPAR  = .;
 IF (YETLKSOP  >= 94 ) THEN YETLKSOP  = .;
 IF (YEVIOPRV  >= 85 ) THEN YEVIOPRV  = .;
 IF (YEYARGUP  >= 85 ) THEN YEYARGUP  = .;
 IF (YEYATTAK  >= 85 ) THEN YEYATTAK  = .;
 IF (YEYFGTGP  >= 85 ) THEN YEYFGTGP  = .;
 IF (YEYFGTSW  >= 85 ) THEN YEYFGTSW  = .;
 IF (YEYHGUN  >= 85 ) THEN YEYHGUN  = .;
 IF (YEYSELL  >= 85 ) THEN YEYSELL  = .;
 IF (YEYSTOLE  >= 85 ) THEN YEYSTOLE  = .;
 IF (YOCOUNS  >= 94 ) THEN YOCOUNS  = .;
 IF (YODPDISC  >= 85 ) THEN YODPDISC  = .;
 IF (YODPLSIN  >= 85 ) THEN YODPLSIN  = .;
 IF (YODPPROB  >= 94 ) THEN YODPPROB  = .;
 IF (YODPR2WK  >= 85 ) THEN YODPR2WK  = .;
 IF (YODPREV  >= 85 ) THEN YODPREV  = .;
 IF (YODSCEV  >= 94 ) THEN YODSCEV  = .;
 IF (YODSLSIN  >= 94 ) THEN YODSLSIN  = .;
 IF (YODSMMDE  >= 94 ) THEN YODSMMDE  = .;
 IF (YOFAMDOC  >= 94 ) THEN YOFAMDOC  = .;
 IF (YOHERBAL  >= 94 ) THEN YOHERBAL  = .;
 IF (YOLOSEV  >= 94 ) THEN YOLOSEV  = .;
 IF (YOLSI2WK  >= 94 ) THEN YOLSI2WK  = .;
 IF (YONURSE  >= 94 ) THEN YONURSE  = .;
 IF (YOOTHDOC  >= 94 ) THEN YOOTHDOC  = .;
 IF (YOOTHHLP  >= 94 ) THEN YOOTHHLP  = .;
 IF (YOOTHMHP  >= 94 ) THEN YOOTHMHP  = .;
 IF (YOPB2WK  >= 94 ) THEN YOPB2WK  = .;
 IF (YOPBAGE  >= 994 ) THEN YOPBAGE  = .;
 IF (YOPBDLYA  >= 94 ) THEN YOPBDLYA  = .;
 IF (YOPBINTF  >= 94 ) THEN YOPBINTF  = .;
 IF (YOPBNUM  >= 9994 ) THEN YOPBNUM  = .;
 IF (YOPBRMBR  >= 94 ) THEN YOPBRMBR  = .;
 IF (YOPSDAYS  >= 994 ) THEN YOPSDAYS  = .;
 IF (YOPSHMGT  >= 94 ) THEN YOPSHMGT  = .;
 IF (YOPSRELS  >= 94 ) THEN YOPSRELS  = .;
 IF (YOPSSOC  >= 94 ) THEN YOPSSOC  = .;
 IF (YOPSWORK  >= 94 ) THEN YOPSWORK  = .;
 IF (YOPSYCH  >= 94 ) THEN YOPSYCH  = .;
 IF (YOPSYMD  >= 94 ) THEN YOPSYMD  = .;
 IF (YORELIG  >= 94 ) THEN YORELIG  = .;
 IF (YORX12MO  >= 94 ) THEN YORX12MO  = .;
 IF (YORXHLP  >= 97 ) THEN YORXHLP  = .;
 IF (YORXNOW  >= 97 ) THEN YORXNOW  = .;
 IF (YOSEEDOC  >= 94 ) THEN YOSEEDOC  = .;
 IF (YOSOCWRK  >= 94 ) THEN YOSOCWRK  = .;
 IF (YOTMTHLP  >= 94 ) THEN YOTMTHLP  = .;
 IF (YOTMTNOW  >= 94 ) THEN YOTMTNOW  = .;
 IF (YOWRAGE  >= 994 ) THEN YOWRAGE  = .;
 IF (YOWRCHR  >= 94 ) THEN YOWRCHR  = .;
 IF (YOWRCONC  >= 94 ) THEN YOWRCONC  = .;
 IF (YOWRDBTR  >= 94 ) THEN YOWRDBTR  = .;
 IF (YOWRDCSN  >= 94 ) THEN YOWRDCSN  = .;
 IF (YOWRDEPR  >= 94 ) THEN YOWRDEPR  = .;
 IF (YOWRDIET  >= 94 ) THEN YOWRDIET  = .;
 IF (YOWRDISC  >= 94 ) THEN YOWRDISC  = .;
 IF (YOWRDLOT  >= 94 ) THEN YOWRDLOT  = .;
 IF (YOWRDST  >= 94 ) THEN YOWRDST  = .;
 IF (YOWRELES  >= 94 ) THEN YOWRELES  = .;
 IF (YOWREMOR  >= 94 ) THEN YOWREMOR  = .;
 IF (YOWRENRG  >= 94 ) THEN YOWRENRG  = .;
 IF (YOWRGAIN  >= 94 ) THEN YOWRGAIN  = .;
 IF (YOWRGNL2  >= 994 ) THEN YOWRGNL2  = .;
 IF (YOWRGROW  >= 94 ) THEN YOWRGROW  = .;
 IF (YOWRHRS  >= 85 ) THEN YOWRHRS  = .;
 IF (YOWRIMP  >= 94 ) THEN YOWRIMP  = .;
 IF (YOWRJINO  >= 94 ) THEN YOWRJINO  = .;
 IF (YOWRJITT  >= 94 ) THEN YOWRJITT  = .;
 IF (YOWRLOSE  >= 94 ) THEN YOWRLOSE  = .;
 IF (YOWRLSIN  >= 94 ) THEN YOWRLSIN  = .;
 IF (YOWRLSL2  >= 994 ) THEN YOWRLSL2  = .;
 IF (YOWRNOGD  >= 94 ) THEN YOWRNOGD  = .;
 IF (YOWRPLSR  >= 94 ) THEN YOWRPLSR  = .;
 IF (YOWRPREG  >= 94 ) THEN YOWRPREG  = .;
 IF (YOWRPROB  >= 94 ) THEN YOWRPROB  = .;
 IF (YOWRSATP  >= 94 ) THEN YOWRSATP  = .;
 IF (YOWRSLEP  >= 94 ) THEN YOWRSLEP  = .;
 IF (YOWRSLNO  >= 94 ) THEN YOWRSLNO  = .;
 IF (YOWRSLOW  >= 94 ) THEN YOWRSLOW  = .;
 IF (YOWRSMOR  >= 94 ) THEN YOWRSMOR  = .;
 IF (YOWRSPLN  >= 94 ) THEN YOWRSPLN  = .;
 IF (YOWRSTHK  >= 94 ) THEN YOWRSTHK  = .;
 IF (YOWRTHOT  >= 94 ) THEN YOWRTHOT  = .;
 IF (YOWRWRTH  >= 94 ) THEN YOWRWRTH  = .;
 IF (YO_MDEA1  >= 94 ) THEN YO_MDEA1  = .;
 IF (YO_MDEA2  >= 94 ) THEN YO_MDEA2  = .;
 IF (YO_MDEA3  >= 94 ) THEN YO_MDEA3  = .;
 IF (YO_MDEA4  >= 94 ) THEN YO_MDEA4  = .;
 IF (YO_MDEA5  >= 94 ) THEN YO_MDEA5  = .;
 IF (YO_MDEA6  >= 94 ) THEN YO_MDEA6  = .;
 IF (YO_MDEA7  >= 94 ) THEN YO_MDEA7  = .;
 IF (YO_MDEA8  >= 94 ) THEN YO_MDEA8  = .;
 IF (YO_MDEA9  >= 94 ) THEN YO_MDEA9  = .;
 IF (YRANXD  >= 85 ) THEN YRANXD  = .;
 IF (YRASMA  >= 85 ) THEN YRASMA  = .;
 IF (YRBRONC  >= 85 ) THEN YRBRONC  = .;
 IF (YRCIRR  >= 85 ) THEN YRCIRR  = .;
 IF (YRDEPRS  >= 85 ) THEN YRDEPRS  = .;
 IF (YRDIAB  >= 85 ) THEN YRDIAB  = .;
 IF (YRHARTD  >= 85 ) THEN YRHARTD  = .;
 IF (YRHBP  >= 85 ) THEN YRHBP  = .;
 IF (YRHEPAT  >= 85 ) THEN YRHEPAT  = .;
 IF (YRHIV  >= 85 ) THEN YRHIV  = .;
 IF (YRLUNCA  >= 85 ) THEN YRLUNCA  = .;
 IF (YRNONE  >= 85 ) THEN YRNONE  = .;
 IF (YRPANCR  >= 85 ) THEN YRPANCR  = .;
 IF (YRPNEU  >= 85 ) THEN YRPNEU  = .;
 IF (YRSINUS  >= 85 ) THEN YRSINUS  = .;
 IF (YRSLPAP  >= 85 ) THEN YRSLPAP  = .;
 IF (YRSTDS  >= 85 ) THEN YRSTDS  = .;
 IF (YRSTROK  >= 85 ) THEN YRSTROK  = .;
 IF (YRTINN  >= 85 ) THEN YRTINN  = .;
 IF (YRTUBRC  >= 85 ) THEN YRTUBRC  = .;
 IF (YRULCER  >= 85 ) THEN YRULCER  = .;
 IF (YUDYANGR  >= 94 ) THEN YUDYANGR  = .;
 IF (YUDYBKRU  >= 94 ) THEN YUDYBKRU  = .;
 IF (YUDYDEPR  >= 94 ) THEN YUDYDEPR  = .;
 IF (YUDYEATP  >= 94 ) THEN YUDYEATP  = .;
 IF (YUDYFEAR  >= 94 ) THEN YUDYFEAR  = .;
 IF (YUDYFITE  >= 94 ) THEN YUDYFITE  = .;
 IF (YUDYFMLY  >= 94 ) THEN YUDYFMLY  = .;
 IF (YUDYFRND  >= 94 ) THEN YUDYFRND  = .;
 IF (YUDYOTPP  >= 94 ) THEN YUDYOTPP  = .;
 IF (YUDYSCHL  >= 94 ) THEN YUDYSCHL  = .;
 IF (YUDYSOR  >= 94 ) THEN YUDYSOR  = .;
 IF (YUDYSUIC  >= 85 ) THEN YUDYSUIC  = .;
 IF (YUDYTXN2  >= 985 ) THEN YUDYTXN2  = .;
 IF (YUDYTXYR  >= 85 ) THEN YUDYTXYR  = .;
 IF (YUFCANGR  >= 94 ) THEN YUFCANGR  = .;
 IF (YUFCARN2  >= 985 ) THEN YUFCARN2  = .;
 IF (YUFCARYR  >= 85 ) THEN YUFCARYR  = .;
 IF (YUFCBKRU  >= 94 ) THEN YUFCBKRU  = .;
 IF (YUFCDEPR  >= 94 ) THEN YUFCDEPR  = .;
 IF (YUFCEATP  >= 94 ) THEN YUFCEATP  = .;
 IF (YUFCFEAR  >= 94 ) THEN YUFCFEAR  = .;
 IF (YUFCFITE  >= 94 ) THEN YUFCFITE  = .;
 IF (YUFCFMLY  >= 94 ) THEN YUFCFMLY  = .;
 IF (YUFCFRND  >= 94 ) THEN YUFCFRND  = .;
 IF (YUFCOTPP  >= 94 ) THEN YUFCOTPP  = .;
 IF (YUFCSCHL  >= 94 ) THEN YUFCSCHL  = .;
 IF (YUFCSOR  >= 94 ) THEN YUFCSOR  = .;
 IF (YUFCSUIC  >= 85 ) THEN YUFCSUIC  = .;
 IF (YUFDANGR  >= 94 ) THEN YUFDANGR  = .;
 IF (YUFDBKRU  >= 94 ) THEN YUFDBKRU  = .;
 IF (YUFDDEPR  >= 94 ) THEN YUFDDEPR  = .;
 IF (YUFDEATP  >= 94 ) THEN YUFDEATP  = .;
 IF (YUFDFEAR  >= 94 ) THEN YUFDFEAR  = .;
 IF (YUFDFITE  >= 94 ) THEN YUFDFITE  = .;
 IF (YUFDFMLY  >= 94 ) THEN YUFDFMLY  = .;
 IF (YUFDFRND  >= 94 ) THEN YUFDFRND  = .;
 IF (YUFDOCN2  >= 985 ) THEN YUFDOCN2  = .;
 IF (YUFDOCYR  >= 85 ) THEN YUFDOCYR  = .;
 IF (YUFDOTPP  >= 94 ) THEN YUFDOTPP  = .;
 IF (YUFDSCHL  >= 94 ) THEN YUFDSCHL  = .;
 IF (YUFDSOR  >= 94 ) THEN YUFDSOR  = .;
 IF (YUFDSUIC  >= 85 ) THEN YUFDSUIC  = .;
 IF (YUHOANGR  >= 94 ) THEN YUHOANGR  = .;
 IF (YUHOBKRU  >= 94 ) THEN YUHOBKRU  = .;
 IF (YUHODEPR  >= 94 ) THEN YUHODEPR  = .;
 IF (YUHOEATP  >= 94 ) THEN YUHOEATP  = .;
 IF (YUHOFEAR  >= 94 ) THEN YUHOFEAR  = .;
 IF (YUHOFITE  >= 94 ) THEN YUHOFITE  = .;
 IF (YUHOFMLY  >= 94 ) THEN YUHOFMLY  = .;
 IF (YUHOFRND  >= 94 ) THEN YUHOFRND  = .;
 IF (YUHOOTPP  >= 94 ) THEN YUHOOTPP  = .;
 IF (YUHOSCHL  >= 94 ) THEN YUHOSCHL  = .;
 IF (YUHOSOR  >= 94 ) THEN YUHOSOR  = .;
 IF (YUHOSPN2  >= 985 ) THEN YUHOSPN2  = .;
 IF (YUHOSPYR  >= 85 ) THEN YUHOSPYR  = .;
 IF (YUHOSUIC  >= 85 ) THEN YUHOSUIC  = .;
 IF (YUIHANGR  >= 94 ) THEN YUIHANGR  = .;
 IF (YUIHBKRU  >= 94 ) THEN YUIHBKRU  = .;
 IF (YUIHDEPR  >= 94 ) THEN YUIHDEPR  = .;
 IF (YUIHEATP  >= 94 ) THEN YUIHEATP  = .;
 IF (YUIHFEAR  >= 94 ) THEN YUIHFEAR  = .;
 IF (YUIHFITE  >= 94 ) THEN YUIHFITE  = .;
 IF (YUIHFMLY  >= 94 ) THEN YUIHFMLY  = .;
 IF (YUIHFRND  >= 94 ) THEN YUIHFRND  = .;
 IF (YUIHOTPP  >= 94 ) THEN YUIHOTPP  = .;
 IF (YUIHSCHL  >= 94 ) THEN YUIHSCHL  = .;
 IF (YUIHSOR  >= 94 ) THEN YUIHSOR  = .;
 IF (YUIHSUIC  >= 85 ) THEN YUIHSUIC  = .;
 IF (YUIHTPN2  >= 985 ) THEN YUIHTPN2  = .;
 IF (YUIHTPYR  >= 85 ) THEN YUIHTPYR  = .;
 IF (YUJVDTN2  >= 985 ) THEN YUJVDTN2  = .;
 IF (YUJVDTON  >= 85 ) THEN YUJVDTON  = .;
 IF (YUJVDTYR  >= 85 ) THEN YUJVDTYR  = .;
 IF (YUMHANGR  >= 94 ) THEN YUMHANGR  = .;
 IF (YUMHBKRU  >= 94 ) THEN YUMHBKRU  = .;
 IF (YUMHCRN2  >= 985 ) THEN YUMHCRN2  = .;
 IF (YUMHCRYR  >= 85 ) THEN YUMHCRYR  = .;
 IF (YUMHDEPR  >= 94 ) THEN YUMHDEPR  = .;
 IF (YUMHEATP  >= 94 ) THEN YUMHEATP  = .;
 IF (YUMHFEAR  >= 94 ) THEN YUMHFEAR  = .;
 IF (YUMHFITE  >= 94 ) THEN YUMHFITE  = .;
 IF (YUMHFMLY  >= 94 ) THEN YUMHFMLY  = .;
 IF (YUMHFRND  >= 94 ) THEN YUMHFRND  = .;
 IF (YUMHOTPP  >= 94 ) THEN YUMHOTPP  = .;
 IF (YUMHSCHL  >= 94 ) THEN YUMHSCHL  = .;
 IF (YUMHSOR  >= 94 ) THEN YUMHSOR  = .;
 IF (YUMHSUIC  >= 85 ) THEN YUMHSUIC  = .;
 IF (YURSANGR  >= 94 ) THEN YURSANGR  = .;
 IF (YURSBKRU  >= 94 ) THEN YURSBKRU  = .;
 IF (YURSDEPR  >= 94 ) THEN YURSDEPR  = .;
 IF (YURSEATP  >= 94 ) THEN YURSEATP  = .;
 IF (YURSFEAR  >= 94 ) THEN YURSFEAR  = .;
 IF (YURSFITE  >= 94 ) THEN YURSFITE  = .;
 IF (YURSFMLY  >= 94 ) THEN YURSFMLY  = .;
 IF (YURSFRND  >= 94 ) THEN YURSFRND  = .;
 IF (YURSIDN2  >= 985 ) THEN YURSIDN2  = .;
 IF (YURSIDYR  >= 85 ) THEN YURSIDYR  = .;
 IF (YURSOTPP  >= 94 ) THEN YURSOTPP  = .;
 IF (YURSSCHL  >= 94 ) THEN YURSSCHL  = .;
 IF (YURSSOR  >= 94 ) THEN YURSSOR  = .;
 IF (YURSSUIC  >= 85 ) THEN YURSSUIC  = .;
 IF (YUSCEMYR  >= 85 ) THEN YUSCEMYR  = .;
 IF (YUSCPGYR  >= 94 ) THEN YUSCPGYR  = .;
 IF (YUSWANGR  >= 94 ) THEN YUSWANGR  = .;
 IF (YUSWBKRU  >= 94 ) THEN YUSWBKRU  = .;
 IF (YUSWDEPR  >= 94 ) THEN YUSWDEPR  = .;
 IF (YUSWEATP  >= 94 ) THEN YUSWEATP  = .;
 IF (YUSWFEAR  >= 94 ) THEN YUSWFEAR  = .;
 IF (YUSWFITE  >= 94 ) THEN YUSWFITE  = .;
 IF (YUSWFMLY  >= 94 ) THEN YUSWFMLY  = .;
 IF (YUSWFRND  >= 94 ) THEN YUSWFRND  = .;
 IF (YUSWOTPP  >= 94 ) THEN YUSWOTPP  = .;
 IF (YUSWSCHL  >= 94 ) THEN YUSWSCHL  = .;
 IF (YUSWSCYR  >= 85 ) THEN YUSWSCYR  = .;
 IF (YUSWSOR  >= 94 ) THEN YUSWSOR  = .;
 IF (YUSWSUIC  >= 85 ) THEN YUSWSUIC  = .;
 IF (YUTPANGR  >= 94 ) THEN YUTPANGR  = .;
 IF (YUTPBKRU  >= 94 ) THEN YUTPBKRU  = .;
 IF (YUTPDEPR  >= 94 ) THEN YUTPDEPR  = .;
 IF (YUTPEATP  >= 94 ) THEN YUTPEATP  = .;
 IF (YUTPFEAR  >= 94 ) THEN YUTPFEAR  = .;
 IF (YUTPFITE  >= 94 ) THEN YUTPFITE  = .;
 IF (YUTPFMLY  >= 94 ) THEN YUTPFMLY  = .;
 IF (YUTPFRND  >= 94 ) THEN YUTPFRND  = .;
 IF (YUTPOTPP  >= 94 ) THEN YUTPOTPP  = .;
 IF (YUTPSCHL  >= 94 ) THEN YUTPSCHL  = .;
 IF (YUTPSOR  >= 94 ) THEN YUTPSOR  = .;
 IF (YUTPSTN2  >= 985 ) THEN YUTPSTN2  = .;
 IF (YUTPSTYR  >= 85 ) THEN YUTPSTYR  = .;
 IF (YUTPSUIC  >= 85 ) THEN YUTPSUIC  = .;
*/
RUN ;
