/**************************************************************************
 |                                                                         
 |                    STATA SETUP FILE FOR ICPSR 03262
 |             NATIONAL HOUSEHOLD SURVEY ON DRUG ABUSE, 2000
 |
 |
 |  Please edit this file as instructed below.
 |  To execute, start Stata, change to the directory containing:
 |       - this do file
 |       - the ASCII data file
 |       - the dictionary file
 |
 |  Then execute the do file (e.g., do 03262-0001-statasetup.do)
 |
 **************************************************************************/

set mem 300m  /* Allocating 300 megabyte(s) of RAM for Stata SE to read the
                 data file into memory. */


set more off  /* This prevents the Stata output viewer from pausing the
                 process */

/****************************************************

Section 1: File Specifications
   This section assigns local macros to the necessary files.
   Please edit:
        "data-filename" ==> The name of data file downloaded from ICPSR
        "dictionary-filename" ==> The name of the dictionary file downloaded.
        "stata-datafile" ==> The name you wish to call your Stata data file.

   Note:  We assume that the raw data, dictionary, and setup (this do file) all
          reside in the same directory (or folder).  If that is not the case
          you will need to include paths as well as filenames in the macros.

********************************************************/

local raw_data "data-filename"
local dict "dictionary-filename"
local outfile "stata-datafile"

/********************************************************

Section 2: Infile Command

This section reads the raw data into Stata format.  If Section 1 was defined
properly, there should be no reason to modify this section.  These macros
should inflate automatically.

**********************************************************/

infile using `dict', using (`raw_data') clear


/*********************************************************

Section 3: Value Label Definitions
This section defines labels for the individual values of each variable.
We suggest that users do not modify this section.

**********************************************************/


label data "National Household Survey on Drug Abuse, 2000, Dataset 0001"

#delimit ;
label define CIGEVER   1 "Yes" 2 "No" ;
label define CIGOFRSM  1 "Definitely Yes" 2 "Probably Yes" 3 "Probably Not"
                       4 "Definitely Not" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define CIGWILYR  1 "Definitely Yes" 2 "Probably Yes" 3 "Probably Not"
                       4 "Definitely Not" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGTRY    985 "BAD DATA Logically assigned"
                       991 "NEVER USED CIGARETTES" 994 "DON'T KNOW"
                       997 "REFUSED" ;
label define CIGYFU    9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assn"
                       9991 "NEVER USED CIGARETTES" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define CIGMFU    1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assn"
                       91 "NEVER USED CIGARETTES" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGREC    1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago but within the past 3 yrs"
                       4 "More than 3 years ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       14 "Used more than 12 months ago LOG ASSN"
                       19 "Used more than 30 days ago LOG ASSN"
                       91 "NEVER USED CIGARETTES" ;
label define CIG30USE  85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CG30EST   1 "1 or 2 days" 2 "3 to 5 days" 3 "6 to 9 days"
                       4 "10 to 19 days" 5 "20 to 29 days" 6 "All 30 days"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIG30AV   1 "Less than one cigarette per day"
                       2 "1 cigarette per day" 3 "2 to 5 cigarettes per day"
                       4 "6 to 15 cigarettes per day (about 1/2 pack)"
                       5 "16 to 25 cigarettes per day (about 1 pack)"
                       6 "26 to 35 cigarettes per day (about 1 1/2 packs)"
                       7 "More than 35 cigs per day (abt 2 packs or more)"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIG30BR2  101 "Basic" 102 "Benson & Hedges" 103 "Cambridge"
                       104 "Camel" 105 "Capri" 106 "Carlton" 107 "Doral"
                       109 "GPC" 110 "Kent" 111 "Kool" 112 "Marlboro"
                       113 "Merit" 114 "Misty" 115 "Monarch" 116 "Montclair"
                       117 "More" 118 "Newport" 119 "Pall Mall"
                       120 "Parliament" 121 "Private Label" 122 "Salem"
                       123 "Vantage" 124 "Viceroy" 125 "Virginia Slims"
                       126 "Winston" 127 "Alpine" 129 "Belair"
                       130 "Best Value" 132 "Bugler (roll-your-own)"
                       137 "Eve" 142 "Lucky Strike" 144 "Maverick" 146 "Now"
                       147 "Old Gold" 149 "Pyramid" 150 "Raleigh"
                       152 "Saratoga" 157 "Tareyton"
                       158 "Top (roll-your-own)" 160 "True"
                       161 "American Spirit" 162 "Austin" 169 "Bronson"
                       171 "Checkers" 173 "Clove; brand unspecified"
                       174 "Daves" 175 "Djarum cigarettes"
                       176 "Drum rolling tobacco" 178 "Dunhill cigarettes"
                       179 "Eagle" 183 "First Class"
                       185 "Generic cigarettes; brand unspecified"
                       188 "Gunsmoke" 189 "Hi-Value" 190 "Jacks"
                       193 "Kamel Red" 196 "Mainstreet" 404 "Black & Mild"
                       423 "Swisher Sweets" 445 "Corona; brand unspecified"
                       1001 "Nat Sherman cigarettes" 1005 "Private Stock"
                       1006 "Quality Smokes" 1011 "Sampoerna" 1017 "Sundance"
                       1018 "USA Gold" 1019 "Vegas cigarettes" 1020 "Waves"
                       1022 "Bailey" 1023 "Sport" 1029 "Tourney" 1037 "DTC"
                       1040 "Smokin Joes cigarettes" 1044 "Worth"
                       1047 "New York New York cigarettes" 1048 "Carnival"
                       1050 "USA" 1055 "Geranimo" 1083 "Liggett Select"
                       1999 "Other cigarette brand or unspecified"
                       3999 "Other snuff brand or unspecified"
                       4999 "Other cigar/cigarillo brand or unspecified"
                       5999 "Other pipe tobacco brand or unspecified"
                       7999 "Not a tobacco product"
                       9000 "Did not confirm after 3 passes thru brand Qs"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED CIGARETTES"
                       9993 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       9994 "DON'T KNOW" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" ;
label define CIG30TYP  1 "Lights" 2 "Ultra Lights" 3 "Full Flavor"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIG30MEN  1 "Menthol" 2 "Regular"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIG30RO2  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIGDLYMO  1 "Yes" 2 "No"
                       5 "Yes LOGICALLY ASSIGNED (from skip pattern)"
                       91 "NEVER USED CIGARETTES" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIGAGE    985 "BAD DATA Logically assigned"
                       991 "NEVER USED CIGARETTES" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP (NEVER USED CIGS EVERYDAY)" ;
label define CIG100LF  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       5 "Yes LOGICALLY ASSIGNED (from skip pattern)"
                       91 "NEVER USED CIGARETTES" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CHEWEVER  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED" ;
label define CHEWTRY   985 "BAD DATA Logically assigned"
                       991 "NEVER USED CHEWING TOBACCO" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define CHEWYFU   9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED CHEWING TOBACCO" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define CHEWMFU   1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CHEWING TOBACCO" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CHEWREC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago but within the past 3 yrs"
                       4 "More than 3 years ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       14 "Used more than 12 months ago LOG ASSN"
                       19 "Used more than 30 days ago LOG ASSN"
                       91 "NEVER USED CHEWING TOBACCO" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define CHW30USE  85 "BAD DATA Logically assigned"
                       91 "NEVER USED CHEWING TOBACCO"
                       93 "DID NOT USE CHEWING TOBACCO PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CH30EST   1 "1 or 2 days" 2 "3 to 5 days" 3 "6 to 9 days"
                       4 "10 to 19 days" 5 "20 to 29 days" 6 "All 30 days"
                       91 "NEVER USED CHEWING TOBACCO"
                       93 "DID NOT USE CHEWING TOBACCO IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CHW30BR2  201 "Beech-Nut" 202 "Chattanooga Chew"
                       203 "Day's Work" 204 "Granger" 206 "Levi Garrett"
                       207 "Red Fox" 208 "Red Man" 209 "Taylors Pride"
                       211 "Work Horse" 221 "Mail Pouch" 301 "Copenhagen"
                       304 "Hawken" 305 "Kodiak" 307 "Silver Creek"
                       308 "Skoal" 309 "Timber Wolf" 312 "Cougar"
                       316 "Red Seal" 317 "Rooster"
                       1999 "Other cigarette brand or unspecified"
                       2999 "Other chewing tobacco brand or unspecified"
                       3999 "Other snuff brand or unspecified"
                       4999 "Other cigar/cigarillo brand or unspecified"
                       5999 "Other pipe tobacco brand or unspecified"
                       8999 "Tobacco replacement or tobacco-like product"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED CHEWING TOBACCO"
                       9993 "DID NOT USE CHEWING TOBACCO IN THE PAST 30 DAYS"
                       9994 "DON'T KNOW" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" ;
label define SNFEVER   1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED" ;
label define SNUFTRY   985 "BAD DATA Logically assigned"
                       991 "NEVER USED SNUFF" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" ;
label define SNUFYFU   9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED SNUFF" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define SNUFMFU   1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned" 91 "NEVER USED SNUFF"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNFREC    1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago but within the past 3 yrs"
                       4 "More than 3 years ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       14 "Used more than 12 months ago LOG ASSN"
                       19 "Used more than 30 days ago LOG ASSN"
                       91 "NEVER USED SMOKELESS TOBACCO" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define SNF30USE  85 "BAD DATA Logically assigned" 91 "NEVER USED SNUFF"
                       93 "DID NOT USE SNUFF IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SN30EST   1 "1 or 2 days" 2 "3 to 5 days" 3 "6 to 9 days"
                       4 "10 to 19 days" 5 "20 to 29 days" 6 "All 30 days"
                       91 "NEVER USED SNUFF"
                       93 "DID NOT USE SNUFF IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNF30BR2  208 "Red Man" 301 "Copenhagen" 302 "Gold River"
                       303 "Happy Days" 304 "Hawken" 305 "Kodiak"
                       306 "Redwood" 307 "Silver Creek" 308 "Skoal"
                       309 "Timber Wolf" 312 "Cougar" 316 "Red Seal"
                       317 "Rooster" 321 "W. Garrett snuff"
                       2999 "Other chewing tobacco brand or unspecified"
                       3999 "Other snuff brand or unspecified"
                       7999 "Not a tobacco product"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED SNUFF"
                       9993 "DID NOT USE SNUFF IN THE PAST 30 DAYS"
                       9994 "DON'T KNOW" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" ;
label define SLTTRY    985 "BAD DATA Logically assigned"
                       991 "NEVER USED SMOKELESS TOBACCO" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define SLTYFU    9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED SMOKELESS TOBACCO" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define SLTMFU    1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SMOKELESS TOBACCO" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SLTREC    1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago but within the past 3 yrs"
                       4 "More than 3 years ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       14 "Used more than 12 months ago LOG ASSN"
                       19 "Used more than 30 days ago LOG ASSN"
                       91 "NEVER USED SMOKELESS TOBACCO" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define SLT30BR2  201 "Beech-Nut" 202 "Chattanooga Chew"
                       203 "Day's Work" 204 "Granger" 206 "Levi Garrett"
                       207 "Red Fox" 208 "Red Man" 209 "Taylors Pride"
                       211 "Work Horse" 301 "Copenhagen" 304 "Hawken"
                       305 "Kodiak" 306 "Redwood" 307 "Silver Creek"
                       308 "Skoal" 309 "Timber Wolf" 312 "Cougar"
                       316 "Red Seal" 317 "Rooster" 321 "W. Garrett snuff"
                       1999 "Other cigarette brand or unspecified"
                       2999 "Other chewing tobacco brand or unspecified"
                       3999 "Other snuff brand or unspecified"
                       4999 "Other cigar/cigarillo brand or unspecified"
                       5999 "Other pipe tobacco brand or unspecified"
                       7999 "Not a tobacco product"
                       8999 "Tobacco replacement or tobacco-like product"
                       9991 "NEVER USED SMOKELESS TOBACCO"
                       9993 "DID NOT USE SMOKELESS TOBACCO IN THE PAST 30 DAYS"
                       9994 "DON'T KNOW" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" ;
label define SLT30FAV  1 "Brand reported from CHW30BR2"
                       2 "Brand reported from SNF30BR2"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SMOKELESS TOBACCO"
                       93 "DID NOT USE SMOKELESS TOBACCO IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIGAREVR  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED" ;
label define CIGARTRY  985 "BAD DATA Logically assigned"
                       991 "NEVER USED CIGARS" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" ;
label define CIGARYFU  9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED CIGARS" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define CIGARMFU  1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARS" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define CIGARREC  1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago but within the past 3 yrs"
                       4 "More than 3 years ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       14 "Used more than 12 months ago LOG ASSN"
                       19 "Used more than 30 days ago LOG ASSN"
                       91 "NEVER USED CIGARS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define CGR30USE  85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARS"
                       93 "DID NOT USE CIGARS IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CI30EST   1 "1 or 2 days" 2 "3 to 5 days" 3 "6 to 9 days"
                       4 "10 to 19 days" 5 "20 to 29 days" 6 "All 30 days"
                       91 "NEVER USED CIGARS"
                       93 "DID NOT USE CIGARS PAST 30 DAYS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CGR30BR2  112 "Marlboro" 118 "Newport" 401 "Antonio y Cleopatra"
                       402 "Backwoods" 403 "Bering" 404 "Black & Mild"
                       405 "Captain Black" 406 "Casa Silva" 407 "Cuesta-Rey"
                       408 "Dutch Masters" 409 "El Producto"
                       411 "Garcia y Vega" 412 "Havatampa" 413 "King Edward"
                       414 "La Corona" 415 "Little Nippers" 416 "Macanudos"
                       417 "Muriel" 418 "Partagas" 419 "Phillies"
                       420 "Rigoletto" 421 "Robert Burns" 422 "Roi-Tan"
                       423 "Swisher Sweets" 424 "Tijuana Smalls"
                       426 "White Owl" 427 "William Penn" 428 "Winchester"
                       429 "Al Capone" 431 "Arturo Fuente" 432 "Ashton"
                       434 "Baccarat" 443 "Cohiba"
                       445 "Corona; brand unspecified"
                       448 "Cuban; brand unspecified" 451 "Davidoff"
                       452 "Don Diego" 462 "Grenadiers" 464 "H. Upmann"
                       465 "Habana/Havana; brand unspecified"
                       486 "Montecristo" 488 "Optimo" 490 "Padron"
                       491 "Parodi Cella" 492 "Primetime" 494 "Punch"
                       496 "Romeo y Julieta"
                       1999 "Other cigarette brand or unspecified"
                       4005 "Thompson" 4006 "Tiparillo"
                       4016 "Dominican; brand unspecified"
                       4041 "Miami Suites" 4050 "Fuente" 4051 "Avo"
                       4999 "Other cigar/cigarillo brand or unspecified"
                       7999 "Not a tobacco product"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED CIGARS"
                       9993 "DID NOT USE CIGARS IN THE PAST 30 DAYS"
                       9994 "DON'T KNOW" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" ;
label define PIPEVER   1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED" ;
label define PIPE30DY  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED PIPE TOBACCO" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALCEVER   1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED" ;
label define ALCTRY    985 "BAD DATA Logically assigned"
                       991 "NEVER USED ALCOHOL" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define ALCYFU    9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED ALCOHOL" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define ALCMFU    1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define ALCREC    1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       91 "NEVER USED ALCOHOL" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define ALCYRTOT  985 "BAD DATA Logically assigned"
                       991 "NEVER USED ALCOHOL"
                       993 "DID NOT USE ALCOHOL IN THE PAST 12 MONTHS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define ALTOTFG   1 "Trimmed to 365 days (no further editing)"
                       2 "Trimmed relative to the 30-day freq"
                       98 "BLANK (NO ANSWER)" ;
label define ALFQFLG   1 "Trimmed to be consistent with mo/yr of 1st use"
                       98 "BLANK (NO ANSWER)" ;
label define ALBSTWAY  1 "Prefer to answer in days per week"
                       2 "Prefer to answer in days per month"
                       3 "Prefer to answer in days per year"
                       11 "Prefer to ans in days per wk LOG ASSN"
                       12 "Prefer to ans in days per mo LOG ASSN"
                       13 "Prefer to ans in days per yr LOG ASSN"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALCOHOL IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALDAYPYR  985 "BAD DATA Logically assigned"
                       989 "LEGITIMATE SKIP Logically assigned"
                       991 "NEVER USED ALCOHOL"
                       993 "DID NOT USE ALCOHOL IN THE PAST 12 MONTHS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define ALDAYPMO  85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALCOHOL IN THE PAST 12 MONTHS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALDAYPWK  85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALCOHOL IN THE PAST 12 MONTHS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCDAYS   85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALCOHOL IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define AL30EST   1 "1 or 2 days" 2 "3 to 5 days" 3 "6 to 9 days"
                       4 "10 to 19 days" 5 "20 to 29 days" 6 "All 30 days"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALCOHOL IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALDYSFG   1 "Edited for consistency with ALCYRTOT or DR5DAY"
                       98 "BLANK (NO ANSWER)" ;
label define NODR30A   975 "AT LEAST 5 Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED ALCOHOL"
                       993 "DID NOT USE ALCOHOL IN THE PAST 30 DAYS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define DR5DAY    80 "NO OCCAS OF 5+ DRINKS PST 30 DAYS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALCOHOL IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MJEVER    1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED" ;
label define MJAGE     985 "BAD DATA Logically assigned"
                       991 "NEVER USED MARIJUANA" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define MJYFU     9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED MARIJUANA" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define MJMFU     1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define MJREC     1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       91 "NEVER USED MARIJUANA" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define MJYRTOT   985 "BAD DATA Logically assigned"
                       991 "NEVER USED MARIJUANA"
                       993 "DID NOT USE MARIJUANA IN THE PAST 12 MONTHS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define MRTOTFG   1 "Trimmed to 365 days (no further editing)"
                       2 "Trimmed relative to the 30-day freq"
                       98 "BLANK (NO ANSWER)" ;
label define MJFQFLG   1 "Trimmed to be consistent with mo/yr of 1st use"
                       98 "BLANK (NO ANSWER)" ;
label define MRBSTWAY  1 "Prefer to answer in days per week"
                       2 "Prefer to answer in days per month"
                       3 "Prefer to answer in days per year"
                       11 "Prefer to ans in days per wk LOG ASSN"
                       12 "Prefer to ans in days per mo LOG ASSN"
                       13 "Prefer to ans in days per yr LOG ASSN"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MARIJUANA IN THE PAST 12 MONTHS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MRDAYPYR  985 "BAD DATA Logically assigned"
                       989 "LEGITIMATE SKIP Logically assigned"
                       991 "NEVER USED MARIJUANA"
                       993 "DID NOT USE MARIJUANA IN THE PAST 12 MONTHS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define MRDAYPMO  85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MARIJUANA IN THE PAST 12 MONTHS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MRDAYPWK  85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MARIJUANA IN THE PAST 12 MONTHS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MJDAY30A  85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MARIJUANA IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MR30EST   1 "1 or 2 days" 2 "3 to 5 days" 3 "6 to 9 days"
                       4 "10 to 19 days" 5 "20 to 29 days" 6 "All 30 days"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MARIJUANA IN THE PAST 12 MONTHS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define COCEVER   1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED" ;
label define COCAGE    985 "BAD DATA Logically assigned"
                       991 "NEVER USED COCAINE" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define COCYFU    9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assn"
                       9991 "NEVER USED COCAINE" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define COCMFU    1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assn"
                       91 "NEVER USED COCAINE" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define COCREC    1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       11 "Used in the past 30 days LOGICALLY ASSIGNED"
                       12 "Used >30 days ago but within pst 12 mos LOG ASSN"
                       91 "NEVER USED COCAINE" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define COCYRTOT  985 "BAD DATA Logically assigned"
                       991 "NEVER USED COCAINE"
                       993 "DID NOT USE COCAINE IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define CCTOTFG   2 "Trimmed relative to the 30-day freq"
                       98 "BLANK (NO ANSWER)" ;
label define CCFQFLG   1 "Trimmed to be consistent with mo/yr of 1st use"
                       98 "BLANK (NO ANSWER)" ;
label define CCBSTWAY  1 "Prefer to answer in days per week"
                       2 "Prefer to answer in days per month"
                       3 "Prefer to answer in days per year"
                       11 "Prefer to ans in days per wk LOG ASSN"
                       12 "Prefer to ans in days per mo LOG ASSN"
                       13 "Prefer to ans in days per yr LOG ASSN"
                       21 "Prefer to ans in days per wk (CRBSTWAY=1,11)"
                       22 "Prefer to ans in days per mo (CRBSTWAY=2,12)"
                       23 "Prefer to ans in days per yr (CRBSTWAY=3,13)"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CCDAYPYR  985 "BAD DATA Logically assigned"
                       989 "LEGITIMATE SKIP Logically assigned"
                       991 "NEVER USED COCAINE"
                       993 "DID NOT USE COCAINE IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define CCDAYPMO  89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CCDAYPWK  85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define COCUS30A  85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CC30EST   2 "3 to 5 days" 3 "6 to 9 days" 5 "20 to 29 days"
                       6 "All 30 days" 91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE IN THE PAST 30 DAYS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CRKEVER   1 "Yes" 2 "No" 91 "NEVER USED COCAINE (COCEVER=2)"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CRKAGE    985 "BAD DATA Logically assigned"
                       991 "NEVER USED CRACK" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" ;
label define CRKYFU    9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED CRACK" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define CRKMFU    1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned" 91 "NEVER USED CRACK"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CRAKREC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       91 "NEVER USED CRACK" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define CRKYRTOT  985 "BAD DATA Logically assigned"
                       991 "NEVER USED CRACK"
                       993 "DID NOT USE CRACK IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define CRTOTFG   2 "Trimmed relative to the 30-day freq"
                       98 "BLANK (NO ANSWER)" ;
label define CRFQFLG   1 "Trimmed to be consistent with mo/yr of 1st use"
                       98 "BLANK (NO ANSWER)" ;
label define CRBSTWAY  1 "Prefer to answer in days per week"
                       2 "Prefer to answer in days per month"
                       3 "Prefer to answer in days per year"
                       11 "Prefer to ans in days per wk LOG ASSN"
                       12 "Prefer to ans in days per mo LOG ASSN"
                       13 "Prefer to ans in days per yr LOG ASSN"
                       85 "BAD DATA Logically assigned" 91 "NEVER USED CRACK"
                       93 "DID NOT USE CRACK IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CRDAYPYR  989 "LEGITIMATE SKIP Logically assigned"
                       991 "NEVER USED CRACK"
                       993 "DID NOT USE CRACK IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define CRDAYPMO  85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED CRACK"
                       93 "DID NOT USE CRACK IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CRDAYPWK  85 "BAD DATA Logically assigned" 91 "NEVER USED CRACK"
                       93 "DID NOT USE CRACK IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CRKUS30A  85 "BAD DATA Logically assigned" 91 "NEVER USED CRACK"
                       93 "DID NOT USE CRACK IN THE PAST 30 DAYS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CR30EST   4 "10 to 19 days" 91 "NEVER USED CRACK"
                       93 "DID NOT USE CRACK IN THE PAST 30 DAYS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HEREVER   1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED" ;
label define HERAGE    985 "BAD DATA Logically assigned"
                       991 "NEVER USED HEROIN" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" ;
label define HERYFU    9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED HEROIN" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define HERMFU    1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HEROIN" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HERREC    1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       91 "NEVER USED HEROIN" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define HERYRTOT  985 "BAD DATA Logically assigned"
                       991 "NEVER USED HEROIN"
                       993 "DID NOT USE HEROIN IN THE PAST 12 MOS"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define HRTOTFG   2 "Trimmed relative to the 30-day freq"
                       98 "BLANK (NO ANSWER)" ;
label define HRFQFLG   1 "Trimmed to be consistent with mo/yr of 1st use"
                       98 "BLANK (NO ANSWER)" ;
label define HRBSTWAY  1 "Prefer to answer in days per week"
                       2 "Prefer to answer in days per month"
                       3 "Prefer to answer in days per year"
                       11 "Prefer to ans in days per wk LOG ASSN"
                       13 "Prefer to ans in days per yr LOG ASSN"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PAST 12 MONTHS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define HRDAYPYR  989 "LEGITIMATE SKIP Logically assigned"
                       991 "NEVER USED HEROIN"
                       993 "DID NOT USE HEROIN PAST 12 MOS" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define HRDAYPMO  85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PAST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HRDAYPWK  85 "BAD DATA Logically assigned"
                       91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PAST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HER30USE  85 "BAD DATA Logically assigned"
                       91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN IN THE PAST 30 DAYS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HR30EST   91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PAST 30 DAYS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define LSD       1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       91 "NEVER USED HALLUCINOGENS" 94 "DON'T KNOW"
                       97 "REFUSED" ;
label define PCP       1 "Yes" 2 "No" 91 "NEVER USED HALLUCINOGENS"
                       94 "DON'T KNOW" 97 "REFUSED" ;
label define PEYOTE    1 "Yes" 2 "No" 91 "NEVER USED HALLUCINOGENS"
                       94 "DON'T KNOW" 97 "REFUSED" ;
label define MESC      1 "Yes" 2 "No" 91 "NEVER USED HALLUCINOGENS"
                       94 "DON'T KNOW" 97 "REFUSED" ;
label define PSILCY    1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       91 "NEVER USED HALLUCINOGENS" 94 "DON'T KNOW"
                       97 "REFUSED" ;
label define ECSTASY   1 "Yes" 2 "No" 91 "NEVER USED HALLUCINOGENS"
                       94 "DON'T KNOW" 97 "REFUSED" ;
label define HALNOLST  1 "Yes" 2 "No" 91 "NEVER USED HALLUCINOGENS"
                       94 "DON'T KNOW" 97 "REFUSED" ;
label define HALNEWA   112 "Restoril, Temazepam"
                       116 "Methaqualone, Quaalude, Sopor"
                       120 "Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED"
                       142 "Belladona" 201 "Valium, Diazepam" 267 "Marezine"
                       268 "Rohypnol, Roche, roofies" 280 "Ketaset"
                       292 "Serzone" 318 "Ritalin, Methylphenidate"
                       322 "Methamphetamine ('ice' or 'crank'), Meth"
                       324 "Uppers; OTHER Stimulant, NOT OTHERWISE SPECIFIED"
                       326 "White cross" 332 "Ephedrine" 348 "Crystal"
                       353 "No-Doz <OTC>" 355 "Crystal meth" 415 "Codeine"
                       417 "Morphine, Roxanol"
                       434 "Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin"
                       501 "Gasoline or lighter fluids" 502 "Spray paints"
                       503 "Other aerosol sprays"
                       504 "Shoeshine liquid, glue, or toluene"
                       506 "Amyl nitrite,'poppers,'locker room odorizer,'rush'"
                       507 "Halothane, ether, or other anesthetics; chloroform"
                       508 "Nitrous oxide, 'whippets,' dentist gas"
                       510 "OTHER Inhalant, NOT OTHERWISE SPECIFIED"
                       511 "Markers, felt-tip pens, ink pens"
                       516 "Freon, refrigerant" 519 "Helium"
                       520 "Old paint, paint" 521 "Propane" 524 "White-Out"
                       525 "Butane" 540 "PAM"
                       566 "Smoked tea from Lipton tea bag"
                       592 "Computer air duster, computer cleaner, dust-off"
                       601 "LSD ('acid')" 602 "Peyote" 603 "Mescaline"
                       604 "Psilocybin (mushrooms), shrooms"
                       605 "PCP ('angel dust,' phencyclidine)"
                       607 "OTHER Hallucinogen, NOT OTHERWISE SPECIFIED"
                       609 "Jimson weed"
                       612 "Happy stick, sherm, sherman, shermstick"
                       614 "MDA, Methylenedioxy amphetamine"
                       615 "Homemade drugs"
                       616 "DET, Dimethyltryptamine, DMT"
                       617 "Morning glory seeds, morning glory tendrils"
                       618 "Acid paper, blotter (acid)" 619 "Tic"
                       622 "Microdot(s), green microdot, purple microdot"
                       624 "Orange sunshine, sunshine, yellow sunshine"
                       625 "Window, window pane, 4-way pane"
                       627 "Hawaiian wood rose, Hawaiian Woodrow seeds"
                       633 "Mr. Natural" 636 "DOM, STP" 637 "Purple haze"
                       639 "Nutmeg, Mace"
                       650 "Datura stramonium, daytura, thorn apple"
                       658 "Special K, Ketamine" 660 "Toad, Toad licking"
                       678 "Banana peels" 683 "Yage" 695 "Angel's trumpet"
                       698 "Nexus, 2C-B"
                       701 "OTHER Opiates, NOT OTHERWISE SPECIFIED"
                       703 "Opium" 802 "THC, cannabinol, marinol"
                       803 "Marijuana, MarrJane, Mary Jane, MJ, pot, weed"
                       806 "Crack, rock" 809 "Pills" 828 "Tetracycline"
                       829 "Robitussin DM <OTC>"
                       843 "Antihistamine, cold medicine, cold tablets <OTC>"
                       847 "GHB, NSC"
                       852 "Formaldehyde, wak, whack (embalming fluid)"
                       883 "Dextromethorphan Hydrobromide <OTC>"
                       1002 "Dramamine, seasick/motion sickness pill <OTC>"
                       2002 "Muscle Relaxers" 3023 "Adderall"
                       3052 "Speed; otherwise unspecified"
                       3064 "Ephedra, Ma Huang <OTC>"
                       5022 "Carbon dioxide, CO2, dry ice hits"
                       5028 "Carburetor cleaner, engine cleaner"
                       6005 "Sassafras tea" 6029 "DXM" 6037 "Fry"
                       6038 "Triplets, Trips" 6043 "Salviadivinorum"
                       6044 "Gel caps, gel tabs" 6055 "Liberty caps"
                       6056 "Wet" 6062 "Madderwort, Wormwood" 6063 "Foxglove"
                       6073 "Rolls" 6074 "LSA" 6077 "San Pedro"
                       6078 "Trumpet flowers" 6079 "Sugar cubes"
                       6083 "CCC, Triple 'C'" 6085 "Dips" 6089 "Cake"
                       6090 "Heaven" 6092 "TCP"
                       6094 "Mushrooms, specifically not psilocybin"
                       6095 "Super cool, Super kool" 6096 "Bananadine"
                       6097 "Banana slug slime" 6099 "Katmandue Temple Kiff"
                       8011 "Herb, flower, plant; type unspecified"
                       8012 "Coriciden <OTC>"
                       8058 "Cough medicine/syrup; type unspecified"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED HALLUCINOGENS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define HALNEWB   142 "Belladona" 201 "Valium, Diazepam"
                       322 "Methamphetamine ('ice' or 'crank'), Meth"
                       345 "Black Molly"
                       435 "Tylenol, Tylenol Extra-Strength <OTC>"
                       501 "Gasoline or lighter fluids"
                       504 "Shoeshine liquid, glue, or toluene"
                       505 "Lacquer thinner or other paint solvents"
                       506 "Amyl nitrite,'poppers,'locker room odorizer,'rush'"
                       508 "Nitrous oxide, 'whippets,' dentist gas"
                       511 "Markers, felt-tip pens, ink pens"
                       520 "Old paint, paint"
                       566 "Smoked tea from Lipton tea bag"
                       601 "LSD ('acid')" 603 "Mescaline"
                       604 "Psilocybin (mushrooms), shrooms"
                       607 "OTHER Hallucinogen, NOT OTHERWISE SPECIFIED"
                       612 "Happy stick, sherm, sherman, shermstick"
                       614 "MDA, Methylenedioxy amphetamine"
                       616 "DET, Dimethyltryptamine, DMT"
                       617 "Morning glory seeds, morning glory tendrils"
                       618 "Acid paper, blotter (acid)"
                       622 "Microdot(s), green microdot, purple microdot"
                       624 "Orange sunshine, sunshine, yellow sunshine"
                       636 "DOM, STP" 639 "Nutmeg, Mace"
                       658 "Special K, Ketamine" 678 "Banana peels"
                       695 "Angel's trumpet" 703 "Opium"
                       802 "THC, cannabinol, marinol" 809 "Pills"
                       829 "Robitussin DM <OTC>" 847 "GHB, NSC" 6029 "DXM"
                       6031 "Strychnine" 6079 "Sugar cubes"
                       6080 "Purple passion" 6086 "Flakes" 6087 "Ibogaine"
                       8011 "Herb, flower, plant; type unspecified"
                       8012 "Coriciden <OTC>"
                       8058 "Cough medicine/syrup; type unspecified"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED HALLUCINOGENS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define HALNEWC   355 "Crystal meth" 503 "Other aerosol sprays"
                       524 "White-Out" 566 "Smoked tea from Lipton tea bag"
                       601 "LSD ('acid')"
                       604 "Psilocybin (mushrooms), shrooms"
                       609 "Jimson weed" 616 "DET, Dimethyltryptamine, DMT"
                       847 "GHB, NSC"
                       1002 "Dramamine, seasick/motion sickness pill <OTC>"
                       6029 "DXM" 6091 "Ergot, rye mold" 6092 "TCP"
                       6098 "Dust; not otherwise specified"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED HALLUCINOGENS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define HALNEWD   268 "Rohypnol, Roche, roofies"
                       501 "Gasoline or lighter fluids"
                       503 "Other aerosol sprays" 520 "Old paint, paint"
                       601 "LSD ('acid')"
                       607 "OTHER Hallucinogen, NOT OTHERWISE SPECIFIED"
                       617 "Morning glory seeds, morning glory tendrils"
                       627 "Hawaiian wood rose, Hawaiian Woodrow seeds"
                       6029 "DXM" 6078 "Trumpet flowers"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED HALLUCINOGENS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define HALNEWE
                       506 "Amyl nitrite,'poppers,'locker room odorizer,'rush'"
                       528 "Whipped-cream can"
                       617 "Morning glory seeds, morning glory tendrils"
                       6084 "Devil dust" 9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED HALLUCINOGENS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define HALLAGE   985 "BAD DATA Logically assigned"
                       991 "NEVER USED HALLUCINOGENS" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define HALYFU    9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assn"
                       9991 "NEVER USED HALLUCINOGENS" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define HALMFU    1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assn"
                       91 "NEVER USED HALLUCINOGENS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HALLREC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in lifetime LOG ASSN"
                       11 "Used in the past 30 days LOGICALLY ASSIGNED"
                       12 "Used >30 days ago but within pst 12 mos LOG ASSN"
                       91 "NEVER USED HALLUCINOGENS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define HALYRTOT  985 "BAD DATA Logically assigned"
                       991 "NEVER USED HALLUCINOGENS"
                       993 "DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define HLTOTFG   2 "Trimmed relative to the 30-day freq"
                       98 "BLANK (NO ANSWER)" ;
label define HLFQFLG   1 "Trimmed to be consistent with mo/yr of 1st use"
                       98 "BLANK (NO ANSWER)" ;
label define HLBSTWAY  1 "Prefer to answer in days per week"
                       2 "Prefer to answer in days per month"
                       3 "Prefer to answer in days per year"
                       11 "Prefer to ans in days per wk LOG ASSN"
                       12 "Prefer to ans in days per mo LOG ASSN"
                       13 "Prefer to ans in days per yr LOG ASSN"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PAST 12 MONTHS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HLDAYPYR  985 "BAD DATA Logically assigned"
                       989 "LEGITIMATE SKIP Logically assigned"
                       991 "NEVER USED HALLUCINOGENS"
                       993 "DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define HLDAYPMO  85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HLDAYPWK  85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HAL30USE  85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HL30EST   1 "1 or 2 days" 3 "6 to 9 days"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PAST 30 DAYS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define LSDAGE    985 "BAD DATA Logically assigned" 991 "NEVER USED LSD"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define LSDYFU    9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assigned"
                       9991 "NEVER USED LSD" 9994 "DON'T KNOW" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define LSDMFU    1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assn"
                       91 "NEVER USED LSD" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define LSDREC    1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       91 "NEVER USED LSD" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define PCPAGE    985 "BAD DATA Logically assigned" 991 "NEVER USED PCP"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define PCPYFU    9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assigned"
                       9991 "NEVER USED PCP" 9994 "DON'T KNOW" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define PCPMFU    1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assn"
                       91 "NEVER USED PCP" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define PCPREC    1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in the lifetime LOG ASSN"
                       91 "NEVER USED PCP" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define AMYLNIT   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       91 "NEVER USED INHALANTS" 94 "DON'T KNOW" 97 "REFUSED" ;
label define CLEFLU    1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       91 "NEVER USED INHALANTS" 94 "DON'T KNOW" 97 "REFUSED" ;
label define GAS       1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       91 "NEVER USED INHALANTS" 94 "DON'T KNOW" 97 "REFUSED" ;
label define GLUE      1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       91 "NEVER USED INHALANTS" 94 "DON'T KNOW" 97 "REFUSED" ;
label define ETHER     1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       94 "DON'T KNOW" 97 "REFUSED" ;
label define SOLVENT   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       91 "NEVER USED INHALANTS" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define LGAS      1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       91 "NEVER USED INHALANTS" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define NITOXID   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       91 "NEVER USED INHALANTS" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define SPPAINT   1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define AEROS     1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       91 "NEVER USED INHALANTS" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define INHNOLST  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INHNEWA   110 "Tuinal" 304 "Benzedrine"
                       318 "Ritalin, Methylphenidate"
                       322 "Methamphetamine ('ice' or 'crank'), Meth"
                       348 "Crystal" 377 "Albuterol, Proventil, Ventolin"
                       501 "Gasoline or lighter fluids" 502 "Spray paints"
                       503 "Other aerosol sprays"
                       504 "Shoeshine liquid, glue, or toluene"
                       505 "Lacquer thinner or other paint solvents"
                       506 "Amyl nitrite,'poppers,'locker room odorizer,'rush'"
                       507 "Halothane, ether, or other anesthetics; chloroform"
                       508 "Nitrous oxide, 'whippets,' dentist gas"
                       509 "Correction fluids, degreasers, cleaning fluids"
                       510 "OTHER Inhalant, NOT OTHERWISE SPECIFIED"
                       511 "Markers, felt-tip pens, ink pens" 512 "Incense"
                       516 "Freon, refrigerant"
                       518 "Acetone, nail polish remover" 519 "Helium"
                       520 "Old paint, paint" 524 "White-Out" 525 "Butane"
                       526 "Nail polish" 528 "Whipped-cream can"
                       531 "Candy, powdered candy, sugar" 534 "Deodorant"
                       539 "ScotchGard" 540 "PAM"
                       546 "Leather protector, suede protector"
                       548 "Cologne, isopropanol vapors, rubbing alcohol"
                       560 "Laundry detergent, soap" 567 "Pertussin spray"
                       580 "Medusa" 590 "Canned air, compressed air"
                       592 "Computer air duster, computer cleaner, dust-off"
                       599 "Potpourri" 658 "Special K, Ketamine"
                       803 "Marijuana, MarrJane, Mary Jane, MJ, pot, weed"
                       815 "Coffee <OTC>" 829 "Robitussin DM <OTC>"
                       847 "GHB, NSC" 3052 "Speed; otherwise unspecified"
                       3053 "Maxair, Pirbuterol"
                       5017 "Oil, lubricant; otherwise unspecified"
                       5021 "Octane booster"
                       5022 "Carbon dioxide, CO2, dry ice hits"
                       5035 "Brake cleaner" 5037 "Wood filler" 5039 "Acetate"
                       5042 "Fuels other than gasoline" 5043 "Carbona"
                       5045 "Cleaner; not otherwise specified"
                       5046 "Glass/window cleaner" 5047 "Tetrafluorethylene"
                       6047 "Water" 8009 "Allergy pills; type unspecified"
                       8024 "Asthma inhaler,asthma medication,bronchial dilator"
                       8054 "Beconase" 9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED INHALANTS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define INHNEWB   501 "Gasoline or lighter fluids"
                       503 "Other aerosol sprays"
                       504 "Shoeshine liquid, glue, or toluene"
                       508 "Nitrous oxide, 'whippets,' dentist gas"
                       510 "OTHER Inhalant, NOT OTHERWISE SPECIFIED"
                       511 "Markers, felt-tip pens, ink pens"
                       516 "Freon, refrigerant"
                       518 "Acetone, nail polish remover" 519 "Helium"
                       520 "Old paint, paint" 524 "White-Out"
                       526 "Nail polish" 528 "Whipped-cream can"
                       539 "ScotchGard" 540 "PAM"
                       592 "Computer air duster, computer cleaner, dust-off"
                       5041 "Wood alcohol" 5043 "Carbona"
                       5044 "Powdered cleansers; e.g. Ajax, Comet, Borax"
                       8024 "Asthma inhaler,asthma medication,bronchial dilator"
                       8055 "Flonase" 9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED INHALANTS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define INHNEWC   504 "Shoeshine liquid, glue, or toluene"
                       505 "Lacquer thinner or other paint solvents"
                       511 "Markers, felt-tip pens, ink pens"
                       518 "Acetone, nail polish remover"
                       520 "Old paint, paint" 524 "White-Out"
                       548 "Cologne, isopropanol vapors, rubbing alcohol"
                       8024 "Asthma inhaler,asthma medication,bronchial dilator"
                       9991 "NEVER USED INHALANTS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define INHNEWD   503 "Other aerosol sprays" 524 "White-Out"
                       526 "Nail polish" 9991 "NEVER USED INHALANTS"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define INHNEWE   518 "Acetone, nail polish remover"
                       9991 "NEVER USED INHALANTS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define INHAGE    985 "BAD DATA Logically assigned"
                       991 "NEVER USED INHALANTS" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define INHYFU    9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED INHALANTS" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define INHMFU    1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED INHALANTS" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define INHREC    1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in lifetime LOG ASSN"
                       91 "NEVER USED INHALANTS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define INHYRTOT  985 "BAD DATA Logically assigned"
                       991 "NEVER USED INHALANTS"
                       993 "DID NOT USE INHALANTS IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define INTOTFG   2 "Trimmed relative to the 30-day freq"
                       98 "BLANK (NO ANSWER)" ;
label define INFQFLG   1 "Trimmed to be consistent with mo/yr of 1st use"
                       98 "BLANK (NO ANSWER)" ;
label define INBSTWAY  1 "Prefer to answer in days per week"
                       2 "Prefer to answer in days per month"
                       3 "Prefer to answer in days per year"
                       11 "Prefer to ans in days per wk LOG ASSN"
                       12 "Prefer to ans in days per mo LOG ASSN"
                       13 "Prefer to ans in days per yr LOG ASSN"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INDAYPYR  985 "BAD DATA Logically assigned"
                       989 "LEGITIMATE SKIP Logically assigned"
                       991 "NEVER USED INHALANTS"
                       993 "DID NOT USE INHALANTS IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define INDAYPMO  89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define INDAYPWK  85 "BAD DATA Logically assigned"
                       91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define INHDY30A  85 "BAD DATA Logically assigned"
                       91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define IN30EST   1 "1 or 2 days" 2 "3 to 5 days" 3 "6 to 9 days"
                       6 "All 30 days" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define DARVTYLC  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define PERCTYLX  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define VICOLOR   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANLCARD   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CODEINE   1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define DEMEROL   1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define DILAUD    1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define FIORICET  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define FIORINAL  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HYDROCOD  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define METHDON   1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MORPHINE  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define OXYCONTN  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define PHENCOD   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define PROPOXY   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SK65A     1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define STADOL    1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TALACEN   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TALWIN    1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TALWINNX  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TRAMADOL  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ULTRAM    1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANLNOLST  1 "Yes" 2 "No" 4 "No LOGICALLY ASSIGNED"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANALNEWA  105 "Placidyl" 109 "Seconal" 110 "Tuinal"
                       112 "Restoril, Temazepam" 113 "Halcion"
                       115 "Phenobarbital"
                       116 "Methaqualone, Quaalude, Sopor"
                       120 "Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED"
                       124 "Yellow jackets" 129 "Reds"
                       130 "Phenergan, Promethazine" 138 "Mandrakes"
                       157 "Barbiturates" 174 "Ambien, Zolpidem"
                       201 "Valium, Diazepam" 209 "Xanax, Alprazolam"
                       211 "Buspar" 212 "Miltown"
                       223 "Carbacot, Marbaxin, Methocarbamol, Robaxin"
                       225 "Desyrel, Trazodone hydrochloride" 227 "Thorazine"
                       228 "Amitriptyline, Elavil"
                       234 "Cyclobenzaprine, Flexeril"
                       240 "Lithium carbonate, Lithonate" 241 "Prozac"
                       246 "Clonazepam, Klonopin, Rivotril"
                       268 "Rohypnol, Roche, roofies" 271 "Zoloft"
                       283 "Paroxetine, Paxil" 301 "Dexedrine"
                       318 "Ritalin, Methylphenidate"
                       322 "Methamphetamine ('ice' or 'crank'), Meth"
                       334 "Crossroads, cross tops" 352 "Lemons" 356 "Dexies"
                       401 "Darvon" 406 "Percodan" 407 "Demerol"
                       408 "Dilaudid"
                       409 "Tylenol with Codeine, Tylenol 3, Tylenol 4"
                       415 "Codeine" 417 "Morphine, Roxanol"
                       418 "Dolophine, Methadone"
                       420 "OTHER Analgesic, NOT OTHERWISE SPECIFIED"
                       421 "USED ANALGESIC, DON'T KNOW NAME" 422 "Motrin"
                       423 "Percocet" 425 "Advil <OTC>" 426 "Fiorinal"
                       427 "Darvocet" 430 "Aspirin, Ecotrin, Empirin <OTC>"
                       431 "Tylox" 433 "Paregoric"
                       434 "Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin"
                       435 "Tylenol, Tylenol Extra-Strength <OTC>"
                       438 "Anaprox, Naprosyn, Naproxen" 442 "Ibuprofen"
                       450 "Acetaminophen <OTC>" 454 "Novocain, Procaine"
                       458 "Mepergan, Mepergan Fortis, Meprozine"
                       465 "Fentanyl, Duragesic, Sublimaze"
                       472 "Indocin, Indomethacin"
                       476 "Duradrin, Isocom, Midrin"
                       477 "Melumbrina, Neo-Melumbrina"
                       481 "Acular, Ketorolac tromethamine, Toradol"
                       490 "Nubain" 496 "Ultram"
                       635 "Ginseng seeds, ginseng weed"
                       802 "THC, cannabinol, marinol" 820 "Penicillin"
                       821 "Amoxicillin, Ampicillin" 824 "Steroids"
                       825 "Theo-Dur" 828 "Tetracycline" 846 "Erythromycin"
                       858 "Antibiotic" 895 "Tagamet, Cimetidine"
                       896 "Catapres, Clonidine" 2001 "Carisoprodol, Soma"
                       2002 "Muscle Relaxers" 3023 "Adderall"
                       3027 "Energy pills"
                       3052 "Speed; otherwise unspecified"
                       4001 "Actron, Ketoprofen, Orudis, Oruvail"
                       4002 "Imitrex, Sumatriptan" 4005 "Etodolac, Lodine"
                       4029 "Feldine, Piroxicam"
                       4031 "Cough medicine with codeine" 4033 "Vicoprofen"
                       4034 "Lilly red" 4035 "Nabumetone, Relafin"
                       4037 "MS Contin" 4039 "Daypro" 4044 "Hydrocodone"
                       4046 "Oxycodone" 4047 "Roxicet" 4052 "Endocet"
                       4053 "Codydramol" 4054 "Zomax" 4055 "Vioxx"
                       4058 "Totem poles" 6076 "Lemon 714" 8002 "Zantac"
                       8007 "Gabapentin, Neurontin"
                       8008 "Antidepressant; type unspecified"
                       8010 "Zyrtec, cetirizine" 8018 "Claritromicina"
                       8020 "Allegra"
                       8024 "Asthma inhaler,asthma medication,bronchial dilator"
                       8025 "Claritin, Claritin D" 8032 "Prilosec"
                       8035 "Prednisone" 8052 "Bactrim, Septra"
                       8057 "Natacyn, Natamycin ophthalmic"
                       8058 "Cough medicine/syrup; type unspecified"
                       9981 "NEVER USED PAIN RELIEVERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assigned"
                       9991 "NEVER USED PAIN RELIEVERS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define ANALNEWB  108 "Nembutal" 110 "Tuinal" 112 "Restoril, Temazepam"
                       116 "Methaqualone, Quaalude, Sopor"
                       120 "Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED"
                       130 "Phenergan, Promethazine" 138 "Mandrakes"
                       186 "Butalbital" 201 "Valium, Diazepam" 205 "Serax"
                       209 "Xanax, Alprazolam" 211 "Buspar"
                       223 "Carbacot, Marbaxin, Methocarbamol, Robaxin"
                       225 "Desyrel, Trazodone hydrochloride"
                       234 "Cyclobenzaprine, Flexeril"
                       240 "Lithium carbonate, Lithonate" 241 "Prozac"
                       268 "Rohypnol, Roche, roofies" 283 "Paroxetine, Paxil"
                       292 "Serzone" 301 "Dexedrine"
                       318 "Ritalin, Methylphenidate" 335 "Dexatrim <OTC>"
                       356 "Dexies" 406 "Percodan" 407 "Demerol"
                       409 "Tylenol with Codeine, Tylenol 3, Tylenol 4"
                       415 "Codeine"
                       420 "OTHER Analgesic, NOT OTHERWISE SPECIFIED"
                       421 "USED ANALGESIC, DON'T KNOW NAME" 422 "Motrin"
                       425 "Advil <OTC>" 427 "Darvocet"
                       430 "Aspirin, Ecotrin, Empirin <OTC>" 433 "Paregoric"
                       434 "Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin"
                       435 "Tylenol, Tylenol Extra-Strength <OTC>"
                       438 "Anaprox, Naprosyn, Naproxen" 442 "Ibuprofen"
                       458 "Mepergan, Mepergan Fortis, Meprozine"
                       481 "Acular, Ketorolac tromethamine, Toradol"
                       496 "Ultram" 858 "Antibiotic"
                       894 "Depakene, Depakote, Valproic Acid"
                       900 "Not a drug" 2001 "Carisoprodol, Soma"
                       3023 "Adderall" 4035 "Nabumetone, Relafin"
                       4044 "Hydrocodone" 4051 "Celebrex" 4058 "Totem poles"
                       8002 "Zantac" 8043 "Accolate" 8044 "Cephelaxin"
                       8051 "Sinex <OTC>"
                       9981 "NEVER USED PAIN RELIEVERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assigned"
                       9991 "NEVER USED PAIN RELIEVERS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define ANALNEWC  110 "Tuinal" 171 "NyQuil <OTC>" 174 "Ambien, Zolpidem"
                       201 "Valium, Diazepam" 209 "Xanax, Alprazolam"
                       211 "Buspar" 241 "Prozac" 271 "Zoloft"
                       318 "Ritalin, Methylphenidate" 336 "Diet pills"
                       356 "Dexies" 407 "Demerol"
                       409 "Tylenol with Codeine, Tylenol 3, Tylenol 4"
                       415 "Codeine" 421 "USED ANALGESIC, DON'T KNOW NAME"
                       423 "Percocet" 425 "Advil <OTC>"
                       430 "Aspirin, Ecotrin, Empirin <OTC>"
                       434 "Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin"
                       442 "Ibuprofen" 2001 "Carisoprodol, Soma" 4027 "Rorer"
                       4059 "Zomig, Zolmitriptan" 8020 "Allegra"
                       9981 "NEVER USED PAIN RELIEVERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assigned"
                       9991 "NEVER USED PAIN RELIEVERS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define ANALNEWD  109 "Seconal" 110 "Tuinal" 115 "Phenobarbital"
                       137 "7-14" 234 "Cyclobenzaprine, Flexeril"
                       268 "Rohypnol, Roche, roofies" 271 "Zoloft"
                       318 "Ritalin, Methylphenidate"
                       409 "Tylenol with Codeine, Tylenol 3, Tylenol 4"
                       415 "Codeine" 421 "USED ANALGESIC, DON'T KNOW NAME"
                       422 "Motrin" 427 "Darvocet" 431 "Tylox"
                       442 "Ibuprofen" 2001 "Carisoprodol, Soma"
                       3015 "Fen-Phen (fenfluramine and phentermine)"
                       3017 "Dayquil <OTC>" 4047 "Roxicet"
                       8025 "Claritin, Claritin D"
                       9981 "NEVER USED PAIN RELIEVERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assigned"
                       9991 "NEVER USED PAIN RELIEVERS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define ANALNEWE  112 "Restoril, Temazepam" 201 "Valium, Diazepam"
                       207 "Ativan, Lorazapam"
                       240 "Lithium carbonate, Lithonate" 415 "Codeine"
                       466 "Midol <OTC>" 658 "Special K, Ketamine"
                       2001 "Carisoprodol, Soma" 4046 "Oxycodone"
                       9981 "NEVER USED PAIN RELIEVERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED PAIN RELIEVERS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define ANALAGE   981 "NEVER USED PAIN RELIEVERS Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED PAIN RELIEVERS" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define ANALYFU   9981 "NEVER USED PAIN RELIEVERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED PAIN RELIEVERS" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define ANALMFU   1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANALREC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in lifetime LOG ASSN"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define ANLYRTOT  981 "NEVER USED PAIN RELIEVERS Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED PAIN RELIEVERS"
                       993 "DID NOT USE PAIN RELIEVERS IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define PRTOTFG   98 "BLANK (NO ANSWER)" ;
label define PRFQFLG   1 "Trimmed to be consistent with mo/yr of 1st use"
                       98 "BLANK (NO ANSWER)" ;
label define PRBSTWAY  1 "Prefer to answer in days per week"
                       2 "Prefer to answer in days per month"
                       3 "Prefer to answer in days per year"
                       11 "Prefer to ans in days per wk LOG ASSN"
                       12 "Prefer to ans in days per mo LOG ASSN"
                       13 "Prefer to ans in days per yr LOG ASSN"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS IN PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define PRDAYPYR  981 "NEVER USED PAIN RELIEVERS Logically assigned"
                       985 "BAD DATA Logically assigned"
                       989 "LEGITIMATE SKIP Logically assigned"
                       991 "NEVER USED PAIN RELIEVERS"
                       993 "DID NOT USE PAIN RELIEVERS IN PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define PRDAYPMO  81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS IN PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define PRDAYPWK  81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS IN PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define KLONOPIN  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define XNAXATVN  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define VALMDIAZ  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNCARD   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ATARAX    1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BUSPAR    1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define EQUANIL   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define FLEXERIL  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define LIBRIUM   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define LIMBTROL  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MEPROB    1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MILTOWN   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ROHYPNOL  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SERAX     1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SOMA      1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TRANXENE  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define VISTAR    1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TRNOLST   1 "Yes" 2 "No" 4 "No LOGICALLY ASSIGNED"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNEWA    108 "Nembutal" 109 "Seconal" 110 "Tuinal"
                       113 "Halcion" 115 "Phenobarbital"
                       116 "Methaqualone, Quaalude, Sopor"
                       120 "Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED"
                       129 "Reds" 131 "Haldol, Haloperidol"
                       174 "Ambien, Zolpidem" 186 "Butalbital"
                       201 "Valium, Diazepam" 207 "Ativan, Lorazapam"
                       209 "Xanax, Alprazolam" 216 "Atarax, Hydroxyzine"
                       221 "OTHER Tranquilizer, NOT OTHERWISE SPECIFIED"
                       222 "USED TRANQUILIZER, DON'T KNOW NAME"
                       223 "Carbacot, Marbaxin, Methocarbamol, Robaxin"
                       224 "Triavil" 225 "Desyrel, Trazodone hydrochloride"
                       227 "Thorazine" 228 "Amitriptyline, Elavil"
                       232 "Mellaril" 234 "Cyclobenzaprine, Flexeril"
                       240 "Lithium carbonate, Lithonate" 241 "Prozac"
                       268 "Rohypnol, Roche, roofies" 271 "Zoloft"
                       283 "Paroxetine, Paxil" 289 "Olanzapine, Zyprexa"
                       290 "Skelaxin" 318 "Ritalin, Methylphenidate"
                       351 "Cathinone, Q'at, Cat" 408 "Dilaudid"
                       417 "Morphine, Roxanol"
                       420 "OTHER Analgesic, NOT OTHERWISE SPECIFIED"
                       423 "Percocet" 427 "Darvocet"
                       434 "Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin"
                       438 "Anaprox, Naprosyn, Naproxen"
                       658 "Special K, Ketamine"
                       663 "Animal tranquilizer, horse tranquilizer"
                       847 "GHB, NSC" 2001 "Carisoprodol, Soma"
                       2002 "Muscle Relaxers" 3023 "Adderall"
                       4001 "Actron, Ketoprofen, Orudis, Oruvail"
                       4039 "Daypro" 4049 "Headache power <OTC>"
                       8002 "Zantac"
                       9981 "NEVER USED TRANQUILIZERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assigned"
                       9991 "NEVER USED TRANQUILIZERS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define TRNEWB    109 "Seconal" 137 "7-14" 201 "Valium, Diazepam"
                       202 "Librium, Chlordiazepoxide HCl"
                       209 "Xanax, Alprazolam"
                       221 "OTHER Tranquilizer, NOT OTHERWISE SPECIFIED"
                       222 "USED TRANQUILIZER, DON'T KNOW NAME"
                       225 "Desyrel, Trazodone hydrochloride"
                       268 "Rohypnol, Roche, roofies"
                       318 "Ritalin, Methylphenidate" 415 "Codeine"
                       417 "Morphine, Roxanol"
                       663 "Animal tranquilizer, horse tranquilizer"
                       4049 "Headache power <OTC>"
                       9981 "NEVER USED TRANQUILIZERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED TRANQUILIZERS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define TRNEWC    131 "Haldol, Haloperidol"
                       268 "Rohypnol, Roche, roofies"
                       8009 "Allergy pills; type unspecified"
                       9981 "NEVER USED TRANQUILIZERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED TRANQUILIZERS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define TRNEWD    435 "Tylenol, Tylenol Extra-Strength <OTC>"
                       9981 "NEVER USED TRANQUILIZERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED TRANQUILIZERS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define TRNEWE    9981 "NEVER USED TRANQUILIZERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED TRANQUILIZERS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define TRANAGE   981 "NEVER USED TRANQUILIZERS Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED TRANQUILIZERS" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define TRANYFU   9981 "NEVER USED TRANQUILIZERS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED TRANQUILIZERS" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define TRANMFU   1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TRANREC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in lifetime LOG ASSN"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define TRNYRTOT  981 "NEVER USED TRANQUILIZERS Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED TRANQUILIZERS"
                       993 "DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define TRTOTFG   98 "BLANK (NO ANSWER)" ;
label define TRFQFLG   1 "Trimmed to be consistent with mo/yr of 1st use"
                       98 "BLANK (NO ANSWER)" ;
label define TRBSTWAY  1 "Prefer to answer in days per week"
                       2 "Prefer to answer in days per month"
                       3 "Prefer to answer in days per year"
                       11 "Prefer to ans in days per wk LOG ASSN"
                       12 "Prefer to ans in days per mo LOG ASSN"
                       13 "Prefer to ans in days per yr LOG ASSN"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRDAYPYR  981 "NEVER USED TRANQUILIZERS Logically assigned"
                       985 "BAD DATA Logically assigned"
                       989 "LEGITIMATE SKIP Logically assigned"
                       991 "NEVER USED TRANQUILIZERS"
                       993 "DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define TRDAYPMO  81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TRDAYPWK  81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define METHDES   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define DIETPILS  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define RITMPHEN  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STMCARD   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CYLERT    1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define DEXED     1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define DETAMP    1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define DIDREX    1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ESKAT     1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define IONAMIN   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MAZANOR   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define OBLA      1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define PLEGINE   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define PRELUDIN  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SANOREX   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TENUATE   1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define STMNOLST  1 "Yes" 2 "No" 4 "No LOGICALLY ASSIGNED"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STIMNEWA  115 "Phenobarbital"
                       116 "Methaqualone, Quaalude, Sopor"
                       124 "Yellow jackets" 174 "Ambien, Zolpidem"
                       207 "Ativan, Lorazapam" 209 "Xanax, Alprazolam"
                       225 "Desyrel, Trazodone hydrochloride"
                       240 "Lithium carbonate, Lithonate" 241 "Prozac"
                       247 "Adapin, Doxepin, Sinequan"
                       268 "Rohypnol, Roche, roofies" 271 "Zoloft"
                       283 "Paroxetine, Paxil" 302 "Dexamyl" 304 "Benzedrine"
                       305 "Biphetamine" 307 "Tenuate, Diethylpropion"
                       311 "Preludin" 313 "Adipex-P, Fastin, Phentermine"
                       318 "Ritalin, Methylphenidate"
                       322 "Methamphetamine ('ice' or 'crank'), Meth"
                       324 "Uppers; OTHER Stimulant, NOT OTHERWISE SPECIFIED"
                       325 "USED STIMULANT, DON'T KNOW NAME"
                       326 "White cross" 327 "Black beauties, Black beauty"
                       329 "Bird's eggs, Robin's eggs, speckled eggs"
                       330 "Blue birds, blue jays, blue robins, speckled bird"
                       331 "Blancs, Whites" 332 "Ephedrine"
                       334 "Crossroads, cross tops" 335 "Dexatrim <OTC>"
                       336 "Diet pills" 344 "Bennies" 345 "Black Molly"
                       348 "Crystal" 352 "Lemons" 355 "Crystal meth"
                       356 "Dexies" 364 "Pseudoephedrine"
                       374 "Christmas tree(s)" 387 "Pink football"
                       417 "Morphine, Roxanol"
                       509 "Correction fluids, degreasers, cleaning fluids"
                       635 "Ginseng seeds, ginseng weed" 806 "Crack, rock"
                       897 "Synthroid, Levothyroxine" 3004 "Black cadillac"
                       3015 "Fen-Phen (fenfluramine and phentermine)"
                       3023 "Adderall" 3026 "Bupropion, Wellbutrin, Zyban"
                       3036 "Ripped fuel <OTC>" 3049 "Truck drivers speed"
                       3050 "Mini Thins" 3052 "Speed; otherwise unspecified"
                       3055 "Clenbuterol" 3062 "Homemade Stimulants"
                       8012 "Coriciden <OTC>" 8026 "Powder"
                       8048 "Theophylline"
                       9981 "NEVER USED STIMULANTS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assigned"
                       9991 "NEVER USED STIMULANTS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define STIMNEWB  137 "7-14" 271 "Zoloft" 301 "Dexedrine"
                       318 "Ritalin, Methylphenidate"
                       324 "Uppers; OTHER Stimulant, NOT OTHERWISE SPECIFIED"
                       325 "USED STIMULANT, DON'T KNOW NAME"
                       326 "White cross" 327 "Black beauties, Black beauty"
                       328 "Pink hearts"
                       330 "Blue birds, blue jays, blue robins, speckled bird"
                       332 "Ephedrine" 333 "357 Magnum, Magnum 44 <OTC>"
                       334 "Crossroads, cross tops" 336 "Diet pills"
                       345 "Black Molly" 374 "Christmas tree(s)"
                       614 "MDA, Methylenedioxy amphetamine"
                       894 "Depakene, Depakote, Valproic Acid"
                       3023 "Adderall" 3052 "Speed; otherwise unspecified"
                       3058 "Metabolift <OTC>" 3067 "Spancap"
                       9981 "NEVER USED STIMULANTS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assigned"
                       9991 "NEVER USED STIMULANTS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define STIMNEWC  124 "Yellow jackets"
                       330 "Blue birds, blue jays, blue robins, speckled bird"
                       334 "Crossroads, cross tops" 374 "Christmas tree(s)"
                       3004 "Black cadillac" 3033 "Metabolife <OTC>"
                       3047 "Sudafed <OTC>"
                       9981 "NEVER USED STIMULANTS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assigned"
                       9991 "NEVER USED STIMULANTS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define STIMNEWD  3056 "Xenadrine <OTC>"
                       9981 "NEVER USED STIMULANTS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED STIMULANTS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define STIMNEWE  9981 "NEVER USED STIMULANTS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED STIMULANTS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define STIMAGE   981 "NEVER USED STIMULANTS Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED STIMULANTS" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define STIMYFU   9981 "NEVER USED STIMULANTS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assn"
                       9991 "NEVER USED STIMULANTS" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define STIMMFU   1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assn"
                       91 "NEVER USED STIMULANTS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define STIMREC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in lifetime LOG ASSN"
                       11 "Used in the past 30 days LOGICALLY ASSIGNED"
                       12 "Used >30 days ago but within pst 12 mos LOG ASSN"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define STMYRTOT  981 "NEVER USED STIMULANTS Logically assigned"
                       983 "DID NOT USE STIMULANTS PAST 12 MOS Log assn"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED STIMULANTS"
                       993 "DID NOT USE STIMULANTS IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define STTOTFG   98 "BLANK (NO ANSWER)" ;
label define STFQFLG   1 "Trimmed to be consistent with mo/yr of 1st use"
                       98 "BLANK (NO ANSWER)" ;
label define STBSTWAY  1 "Prefer to answer in days per week"
                       2 "Prefer to answer in days per month"
                       3 "Prefer to answer in days per year"
                       11 "Prefer to ans in days per wk LOG ASSN"
                       12 "Prefer to ans in days per mo LOG ASSN"
                       13 "Prefer to ans in days per yr LOG ASSN"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       83 "DID NOT USE STIMULANTS PAST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STDAYPYR  981 "NEVER USED STIMULANTS Logically assigned"
                       983 "DID NOT USE STIMULANTS PAST 12 MOS Log assn"
                       989 "LEGITIMATE SKIP Logically assigned"
                       991 "NEVER USED STIMULANTS"
                       993 "DID NOT USE STIMULANTS IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define STDAYPMO  81 "NEVER USED STIMULANTS Logically assigned"
                       83 "DID NOT USE STIMULANTS PAST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define STDAYPWK  81 "NEVER USED STIMULANTS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define METHAGE   981 "NEVER USED METHAMPHETAMINES Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED METHAMPHETAMINES" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define METHYFU   9981 "NEVER USED METHAMPHETAMINES Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED METHAMPHETAMINES" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define METHMFU   1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       81 "NEVER USED METHAMPHETAMINES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED METHAMPHETAMINES" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define METHREC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in lifetime LOG ASSN"
                       81 "NEVER USED METHAMPHETAMINES Logically assigned"
                       91 "NEVER USED METHAMPHETAMINES" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define METHAQ    1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define NEMBBARB  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RESTTMAZ  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define SEDCARD   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define AMYTAL    1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define BUTISOL   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define CHHYD     1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define DALMANE   1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HALCION   1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define PHENOBAR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define PLACIDYL  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TUINAL    1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define SEDNOLST  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define SEDNEWA   105 "Placidyl" 110 "Tuinal" 111 "Dalmane, Flurazepam"
                       113 "Halcion" 115 "Phenobarbital"
                       116 "Methaqualone, Quaalude, Sopor"
                       120 "Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED"
                       121 "USED SEDATIVE, DON'T KNOW NAME" 129 "Reds"
                       138 "Mandrakes" 146 "Bentyl, Dicyclomine"
                       174 "Ambien, Zolpidem" 188 "Estazolam"
                       201 "Valium, Diazepam"
                       225 "Desyrel, Trazodone hydrochloride"
                       228 "Amitriptyline, Elavil"
                       246 "Clonazepam, Klonopin, Rivotril"
                       247 "Adapin, Doxepin, Sinequan"
                       268 "Rohypnol, Roche, roofies" 271 "Zoloft"
                       283 "Paroxetine, Paxil" 295 "Mirtazapine, Remeron"
                       355 "Crystal meth" 457 "T's and blues"
                       658 "Special K, Ketamine"
                       802 "THC, cannabinol, marinol"
                       2001 "Carisoprodol, Soma" 4044 "Hydrocodone"
                       8010 "Zyrtec, cetirizine" 8049 "Sorbitol"
                       9981 "NEVER USED SEDATIVES Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED SEDATIVES" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define SEDNEWB   120 "Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED"
                       121 "USED SEDATIVE, DON'T KNOW NAME"
                       174 "Ambien, Zolpidem"
                       225 "Desyrel, Trazodone hydrochloride"
                       9981 "NEVER USED SEDATIVES Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED SEDATIVES" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define SEDNEWC   174 "Ambien, Zolpidem"
                       9981 "NEVER USED SEDATIVES Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED SEDATIVES" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define SEDNEWD   174 "Ambien, Zolpidem"
                       9981 "NEVER USED SEDATIVES Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED SEDATIVES" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define SEDNEWE   174 "Ambien, Zolpidem"
                       9981 "NEVER USED SEDATIVES Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED SEDATIVES" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define SEDAGE    981 "NEVER USED SEDATIVES Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED SEDATIVES" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define SEDYFU    9981 "NEVER USED SEDATIVES Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED SEDATIVES" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define SEDMFU    1 "January" 2 "February" 3 "March" 4 "April" 5 "May"
                       6 "June" 7 "July" 8 "August" 9 "September"
                       10 "October" 11 "November" 12 "December"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define SEDREC    1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       8 "Used at some point in the past 12 mos LOG ASSN"
                       9 "Used at some point in lifetime LOG ASSN"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define SEDYRTOT  981 "NEVER USED SEDATIVES Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED SEDATIVES"
                       993 "DID NOT USE SEDATIVES IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define SVTOTFG   98 "BLANK (NO ANSWER)" ;
label define SVFQFLG   1 "Trimmed to be consistent with mo/yr of 1st use"
                       98 "BLANK (NO ANSWER)" ;
label define SVBSTWAY  1 "Prefer to answer in days per week"
                       2 "Prefer to answer in days per month"
                       3 "Prefer to answer in days per year"
                       12 "Prefer to ans in days per mo LOG ASSN"
                       13 "Prefer to ans in days per yr LOG ASSN"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SVDAYPYR  981 "NEVER USED SEDATIVES Logically assigned"
                       985 "BAD DATA Logically assigned"
                       989 "LEGITIMATE SKIP Logically assigned"
                       991 "NEVER USED SEDATIVES"
                       993 "DID NOT USE SEDATIVES IN THE PAST 12 MOS"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define SVDAYPMO  81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SVDAYPWK  81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES IN THE PAST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define IRCIGRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago but within the past 3 yrs"
                       4 "More than 3 years ago" 9 "Never smoked cigarettes" ;
label define IICIGRC   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2CIGRC  1 "Questionnaire data" 2 "Logically imputed data"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8"
                       6 "Statistically imputed data - edited recency=19"
                       7 "Statistically imputed data - edited recency=14" ;
label define IRCGRRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago but within the past 3 yrs"
                       4 "More than 3 years ago" 9 "Never smoked cigars" ;
label define IICGRRC   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2CGRRC  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8"
                       6 "Statistically imputed data - edited recency=19"
                       7 "Statistically imputed data - edited recency=14" ;
label define IRPIPLF   1 "Ever used pipes" 9 "Never smoked pipes" ;
label define IIPIPLF   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRPIPMN   1 "Within the past 30 days"
                       2 "More than 30 days ago but within lifetime"
                       9 "Never smoked pipes" ;
label define IIPIPMN   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRSLTRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago but within the past 3 yrs"
                       4 "More than 3 years ago"
                       9 "Never used smokeless tobacco" ;
label define IISLTRC   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2SLTRC  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8"
                       6 "Statistically imputed data - edited recency=19"
                       7 "Statistically imputed data - edited recency=14" ;
label define IRCHWRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago but within the past 3 yrs"
                       4 "More than 3 years ago"
                       9 "Never used chewing tobacco" ;
label define IICHWRC   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2CHWRC  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8"
                       6 "Statistically imputed data - edited recency=19"
                       7 "Statistically imputed data - edited recency=14" ;
label define IRSNFRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago but within the past 3 yrs"
                       4 "More than 3 years ago" 9 "Never used snuff" ;
label define IISNFRC   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2SNFRC  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8"
                       6 "Statistically imputed data - edited recency=19"
                       7 "Statistically imputed data - edited recency=14" ;
label define IRALCRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 9 "Never used alcohol" ;
label define IIALCRC   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2ALCRC  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRMJRC    1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 9 "Never used marijuana" ;
label define IIMJRC    1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2MJRC   1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRCOCRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 9 "Never used cocaine" ;
label define IICOCRC   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2COCRC  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRCRKRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 9 "Never used crack" ;
label define IICRKRC   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2CRKRC  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRHERRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 9 "Never used heroin" ;
label define IIHERRC   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2HERRC  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRHALRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       9 "Never used hallucinogens" ;
label define IIHALRC   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2HALRC  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRLSDRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 9 "Never used LSD" ;
label define IILSDRC   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2LSDRC  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRPCPRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 9 "Never used PCP" ;
label define IIPCPRC   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2PCPRC  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRINHRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 9 "Never used inhalants" ;
label define IIINHRC   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2INHRC  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRANLRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       9 "Never used pain relievers" ;
label define IIANLRC   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2ANLRC  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRTRNRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       9 "Never used tranquilizers" ;
label define IITRNRC   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2TRNRC  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRSTMRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 9 "Never used stimulants" ;
label define IISTMRC   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2STMRC  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRMTHRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       9 "Never used methamphetamines" ;
label define IIMTHRC   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2MTHRC  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRSEDRC   1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 9 "Never used sedatives" ;
label define IISEDRC   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2SEDRC  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - edited recency=9"
                       5 "Statistically imputed data - edited recency=8" ;
label define IRALCFY   991 "NEVER USED ALCOHOL"
                       993 "DID NOT USE ALCOHOL PAST YEAR" ;
label define IIALCFY   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2ALCFY  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRMJFY    991 "NEVER USED MARIJUANA"
                       993 "DID NOT USE MARIJUANA PAST YEAR" ;
label define IIMJFY    1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2MJFY   1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRCOCFY   991 "NEVER USED COCAINE"
                       993 "DID NOT USE COCAINE PAST YEAR" ;
label define IICOCFY   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2COCFY  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRCRKFY   991 "NEVER USED CRACK"
                       993 "DID NOT USE CRACK PAST YEAR" ;
label define IICRKFY   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2CRKFY  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRHERFY   991 "NEVER USED HEROIN"
                       993 "DID NOT USE HEROIN PAST YEAR" ;
label define IIHERFY   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2HERFY  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRHALFY   991 "NEVER USED HALLUCINOGENS"
                       993 "DID NOT USE HALLUCINOGENS PAST YEAR" ;
label define IIHALFY   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2HALFY  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRINHFY   991 "NEVER USED INHALANTS"
                       993 "DID NOT USE INHALANTS PAST YEAR" ;
label define IIINHFY   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2INHFY  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRANLFY   991 "NEVER USED PAIN RELIEVER"
                       993 "DID NOT USE PAIN RELIEVER PAST YEAR" ;
label define IIANLFY   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2ANLFY  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRTRNFY   991 "NEVER USED TRANQUILIZERS"
                       993 "DID NOT USE TRANQUILIZERS PAST YEAR" ;
label define IITRNFY   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2TRNFY  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRSTMFY   991 "NEVER USED STIMULANTS"
                       993 "DID NOT USE STIMULANTS PAST YEAR" ;
label define IISTMFY   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2STMFY  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRSEDFY   991 "NEVER USED SEDATIVES"
                       993 "DID NOT USE SEDATIVES PAST YEAR" ;
label define IISEDFY   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2SEDFY  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRCIGFM   91.00 "NEVER USED"
                       93.00 "DID NOT USE CIGARETTES PAST MONTH" ;
label define IICIGFM   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2CIGFM  1 "Questionnaire data" 2 "Logically imputed data"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRCGRFM   91.00 "NEVER SMOKED CIGARS"
                       93.00 "DID NOT SMOKE CIGARS PAST MONTH" ;
label define IICGRFM   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2CGRFM  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRCHWFM   91.00 "NEVER USED CHEWING TOBACCO"
                       93.00 "DID NOT USE CHEWING TOBACCO PAST MONTH" ;
label define IICHWFM   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2CHWFM  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRSNFFM   91.00 "NEVER USED SNUFF"
                       93.00 "DID NOT USE SNUFF PAST MONTH" ;
label define IISNFFM   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2SNFFM  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRALCFM   91.00 "NEVER USED ALCOHOL"
                       93.00 "DID NOT USE ALCOHOL PAST MONTH" ;
label define IIALCFM   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2ALCFM  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRALCD5   91 "NEVER USED ALCOHOL"
                       93 "DID NOT HAVE 5+ ALC DRNKS PAST MONTH" ;
label define IIALCD5   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2ALCD5  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRMJFM    91.00 "NEVER USED MARIJUANA"
                       93.00 "DID NOT USE MARIJUANA PAST MONTH" ;
label define IIMJFM    1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2MJFM   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRCOCFM   91.00 "NEVER USED COCAINE"
                       93.00 "DID NOT USE COCAINE PAST MONTH" ;
label define IICOCFM   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2COCFM  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRCRKFM   91.00 "NEVER USED CRACK"
                       93.00 "DID NOT USE CRACK PAST MONTH" ;
label define IICRKFM   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2CRKFM  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRHERFM   91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PAST MONTH" ;
label define IIHERFM   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define II2HERFM  1 "Questionnaire data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRHALFM   91.00 "NEVER USED HALLUCINOGENS"
                       93.00 "DID NOT USE HALLUCINOGENS PAST MONTH" ;
label define IIHALFM   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2HALFM  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRINHFM   91.00 "NEVER USED INHALANTS"
                       93.00 "DID NOT USE INHALANTS PAST MONTH" ;
label define IIINHFM   1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define II2INHFM  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data - lifetime use imputed"
                       4 "Statistically imputed data - lifetime use known" ;
label define IRCIGAGE  991 "NEVER USED" ;
label define IICIGAGE  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRCIGYFU  9999 "NEVER USED" ;
label define IICIGYFU  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRCDUAGE  991 "Never Used" 993 "Never a daily user" ;
label define IICDUAGE  1 "Questionnaire Data" 3 "Statistically imputed data" ;
label define IRCDUYFU  9993 "NEVER A DAILY USER" 9999 "NEVER USED" ;
label define IICDUYFU  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRCGRAGE  991 "NEVER USED" ;
label define IICGRAGE  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRCGRYFU  9999 "NEVER USED" ;
label define IICGRYFU  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRSNFAGE  991 "Never Used" ;
label define IISNFAGE  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRSNFYFU  9999 "NEVER USED" ;
label define IISNFYFU  1 "Questionnaire Data" 3 "Statistical Imputation" ;
label define IRCHWAGE  991 "NEVER USED" ;
label define IICHWAGE  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRCHWYFU  9999 "Never Used" ;
label define IICHWYFU  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRSLTAGE  991 "Never Used" ;
label define IISLTAGE  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRSLTYFU  9999 "Never Used" ;
label define IISLTYFU  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRALCAGE  991 "Never Used" ;
label define IIALCAGE  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRALCYFU  9999 "NEVER USED" ;
label define IIALCYFU  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRMJAGE   991 "Never Used" ;
label define IIMJAGE   1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRMJYFU   9999 "Never Used" ;
label define IIMJYFU   1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRCOCAGE  991 "Never Used" ;
label define IICOCAGE  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRCOCYFU  9999 "Never Used" ;
label define IICOCYFU  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRCRKAGE  991 "Never Used" ;
label define IICRKAGE  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically Imputed Data" ;
label define IRCRKYFU  9999 "Never Used" ;
label define IICRKYFU  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRHERAGE  991 "Never Used" ;
label define IIHERAGE  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRHERYFU  9999 "Never Used" ;
label define IIHERYFU  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRHALAGE  991 "Never Used" ;
label define IIHALAGE  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRHALYFU  9999 "Never Used" ;
label define IIHALYFU  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRLSDAGE  991 "Never Used" ;
label define IILSDAGE  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically imputed data" ;
label define IRLSDYFU  9999 "NEVER USED" ;
label define IILSDYFU  1 "Questionnaire Data" 3 "Statistically imputed data" ;
label define IRPCPAGE  991 "Never Used" ;
label define IIPCPAGE  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically imputed data" ;
label define IRPCPYFU  9999 "NEVER USED" ;
label define IIPCPYFU  1 "Questionnaire Data" 3 "Statistically imputed data" ;
label define IRINHAGE  991 "Never Used" ;
label define IIINHAGE  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRINHYFU  9999 "Never Used" ;
label define IIINHYFU  1 "Questionnaire Data" 3 "Statistically Imputed Data" ;
label define IRANLAGE  991 "Never Used" ;
label define IIANLAGE  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically Imputed Data" ;
label define IRANLYFU  9999 "Never Used" ;
label define IIANLYFU  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically Imputed Data" ;
label define IRTRNAGE  991 "Never Used" ;
label define IITRNAGE  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically Imputed Data" ;
label define IRTRNYFU  9999 "Never Used" ;
label define IITRNYFU  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically Imputed Data" ;
label define IRSTMAGE  991 "Never Used" ;
label define IISTMAGE  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically Imputed Data" ;
label define IRSTMYFU  9999 "Never Used" ;
label define IISTMYFU  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically Imputed Data" ;
label define IRMTHAGE  991 "Never Used" ;
label define IIMTHAGE  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically Imputed Data" ;
label define IRMTHYFU  9999 "Never Used" ;
label define IIMTHYFU  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically Imputed Data" ;
label define IRSEDAGE  991 "Never Used" ;
label define IISEDAGE  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically Imputed Data" ;
label define IRSEDYFU  9999 "Never Used" ;
label define IISEDYFU  1 "Questionnaire Data" 2 "Logical Edited Data"
                       3 "Statistically Imputed Data" ;
label define CIGFLAG   0 "Never used (IRCIGRC = 9)"
                       1 "Ever used (IRCIGRC = 1-4)" ;
label define CIGYR     0 "Did not use in the past year (IRCIGRC = 3,4,9)"
                       1 "Used within the past year (IRCIGRC = 1,2)" ;
label define CIGMON    0 "Did not use in the past month (IRCIGRC = 2-4,9)"
                       1 "Used within the past month (IRCIGRC = 1)" ;
label define CGRFLAG   0 "Never used (IRCGRRC = 9)"
                       1 "Ever used (IRCGRRC = 1-4)" ;
label define CGRYR     0 "Did not use in the past year (IRCGRRC = 3,4,9)"
                       1 "Used within the past year (IRCGRRC = 1,2)" ;
label define CGRMON    0 "Did not use in the past month (IRCGRRC = 2-4,9)"
                       1 "Used within the past month (IRCGRRC = 1)" ;
label define PIPFLAG   0 "Never Used (IRPIPLF=9)" 1 "Ever Used (IRPIPLF=1)" ;
label define PIPMON    0 "Did not use in the past month (IRPIPMN=2,9)"
                       1 "Used within the past month (IRPIPMN=1)" ;
label define SMKFLAG   0 "Never used (IRSLTRC = 9)"
                       1 "Ever used (IRSLTRC = 1-4)" ;
label define SMKYR     0 "Did not use in the past year (IRSLTRC = 3,4,9)"
                       1 "Used within the past year (IRSLTRC = 1,2)" ;
label define SMKMON    0 "Did not use in the past month (IRSLTRC = 2-4,9)"
                       1 "Used within the past month (IRSLTRC = 1)" ;
label define CHWFLAG   0 "Never Used (IRCHWRC=9)" 1 "Ever Used (IRCHWRC=1-4)" ;
label define CHWYR     0 "Did not use in the past year (IRCHWRC=3,4,9)"
                       1 "Used within the past year (IRCHWRC=1,2)" ;
label define CHWMON    0 "Did not use in the past month (IRCHWRC=2-4,9)"
                       1 "Used within the past month (IRCHWRC=1)" ;
label define SNFFLAG   0 "Never used (IRSNFRC = 9)"
                       1 "Ever used (IRSNFRC = 1-4)" ;
label define SNFYR     0 "Did not use in the past year (IRSNFRC = 3,4,9)"
                       1 "Used within the past year (IRSNFRC = 1,2)" ;
label define SNFMON    0 "Did not use in the past month (IRSNFRC = 2-4,9)"
                       1 "Used within the past month (IRSNFRC = 1)" ;
label define TOBFLAG   0 "Never Used (all source vars=9)"
                       1 "Ever Used (any source var=1-4)" ;
label define TOBYR     0 "Never use pst yr(IRPIPMN=2,9 &oth src vars=3,4,9)"
                       1 "Used pst yr(IRPIPMN=1 or any oth src var=1,2)" ;
label define TOBMON    0 "Did not use in pst month (all source vars=2-4,9)"
                       1 "Used in past month (any source var=1)" ;
label define CIGBRND2  -9 "Not Past Month Cigarette User (CIGMON=0)"
                       1 "Marlboro (CIG30BR2=112)" 2 "Newport (CIG30BR2=118)"
                       3 "Camel (CIG30BR2=104)" 4 "Basic (CIG30BR2=101)"
                       5 "Doral (CIG30BR2=107)" 6 "Winston (CIG30BR2=126)"
                       7 "GPC (CIG30BR2=109)"
                       8 "Virginia Slims (CIG30BR2=125)"
                       9 "Kool (CIG30BR2=111)" 10 "Salem (CIG30BR2=122)"
                       11 "Benson & Hedges (CIG30BR2=102)"
                       12 "Merit (CIG30BR2=113)" 13 "Misty (CIG30BR2=114)"
                       14 "Capri (CIG30BR2=105)"
                       15 "Parliament (CIG30BR2=120)"
                       16 "Carlton (CIG30BR2=106)"
                       17 "Other Brnd (CIG30BR2=other 100-199,1001-1999)"
                       18 "Unkwn Brnd (CIG30BR2=200-999,4039,4999,9000-9998)" ;
label define CGRBRND2  -9 "Not Past Month Cigar User (CGRMON=0)"
                       1 "Black and Mild (CGR30BR2 = 404)"
                       2 "Swisher Sweets (CGR30BR2 = 423)"
                       3 "Macanudos (CGR30BR2 = 416)"
                       4 "Phillies (CGR30BR2 = 419)"
                       5 "Garcia Y Vega (CGR30BR2 = 411)"
                       6 "Backwoods (CGR30BR2 = 402)"
                       7 "Havatampa (CGR30BR2 = 412)"
                       8 "Dutch Masters (CGR30BR2 = 408)"
                       9 "Cohiba (CGR30BR2 = 443)"
                       10 "King Edward (CGR30BR2 = 413)"
                       11 "Antonio Y Cleopatra (CGR30BR2 = 401)"
                       12 "Partagas (CGR30BR2 = 418)"
                       13 "Romeo & Julieta (CGR30BR2 = 496)"
                       14 "White Owl (CGR30BR2 = 426)"
                       15 "Arturo Fuentes (CGR30BR2 = 431)"
                       16 "Other Brnd (CGR30BR2 =other 400-499,4000-4999)"
                       17 "Unkwn Brnd (CGR30BR2=<399,701,1020,1077,9000-9998)" ;
label define SMKBRND2  -9 "Not Past Month Smokeless Tobacco User (SMKMON=0)"
                       1 "Skoal (SLT30BR2=308)" 2 "Copenhagen (SLT30BR2=301)"
                       3 "Red Man (SLT30BR2=208)" 4 "Kodiak (SLT30BR2=305)"
                       5 "Beech-Nut (SLT30BR2=201)"
                       6 "Levi Garrett (SLT30BR2=206)"
                       7 "Timber Wolf (SLT30BR2=309)"
                       8 "Red Seal (SLT30BR2=316)"
                       9 "Silver Creek (SLT30BR2=307)"
                       10 "Other Brand (SLT30BR2=other 200-399,2999-3999)"
                       11 "Unkwn Brnd (SLT30BR2=<200,400-899,5999,9000-9998)" ;
label define CIGCMPNY  1 "Philip Morris" 2 "R.J. Reynolds" 3 "Lorillard"
                       4 "Brown and Williamson" 5 "Liggett"
                       6 "Commonwealth Brands"
                       7 "Santa Fe Natural Tobacco Company"
                       70 "SOME OTHER BRAND/COMPANY"
                       80 "CIG BRAND/COMPANY NOT SPECIFIED"
                       85 "BAD DATA Log assn (CIG30BR2=9985)"
                       90 "NOT A CIGARETTE BRAND" 91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW (CIG30BR2=9994)"
                       97 "REFUSED (CIG30BR2=9997)"
                       98 "BLANK (CIG30BR2=9998)" ;
label define ALCFLAG   0 "Never used (IRALCRC = 9)"
                       1 "Ever used (IRALCRC = 1-3)" ;
label define ALCYR     0 "Did not use in the past year (IRALCRC = 3,9)"
                       1 "Used within the past year (IRALCRC = 1,2)" ;
label define ALCMON    0 "Did not use in the past month (IRALCRC = 2-3,9)"
                       1 "Used within the past month (IRALCRC = 1)" ;
label define MRJFLAG   0 "Never used (IRMJRC = 9)"
                       1 "Ever used (IRMJRC = 1-3)" ;
label define MRJYR     0 "Did not use in the past year (IRMJRC = 3,9)"
                       1 "Used within the past year (IRMJRC = 1,2)" ;
label define MRJMON    0 "Did not use in the past month (IRMJRC = 2-3,9)"
                       1 "Used within the past month (IRMJRC = 1)" ;
label define COCFLAG   0 "Never used (IRCOCRC = 9)"
                       1 "Ever used (IRCOCRC = 1-3)" ;
label define COCYR     0 "Did not use in the past year (IRCOCRC = 3,9)"
                       1 "Used within the past year (IRCOCRC = 1,2)" ;
label define COCMON    0 "Did not use in the past month (IRCOCRC = 2-3,9)"
                       1 "Used within the past month (IRCOCRC = 1)" ;
label define CRKFLAG   0 "Never used (IRCRKRC = 9)"
                       1 "Ever used (IRCRKRC = 1-3)" ;
label define CRKYR     0 "Did not use in the past year (IRCRKRC = 3,9)"
                       1 "Used within the past year (IRCRKRC = 1,2)" ;
label define CRKMON    0 "Did not use in the past month (IRCRKRC = 2-3,9)"
                       1 "Used within the past month (IRCRKRC = 1)" ;
label define HERFLAG   0 "Never used (IRHERRC = 9)"
                       1 "Ever used (IRHERRC = 1-3)" ;
label define HERYR     0 "Did not use in the past year (IRHERRC = 3,9)"
                       1 "Used within the past year (IRHERRC = 1,2)" ;
label define HERMON    0 "Did not use in the past month (IRHERRC = 2-3,9)"
                       1 "Used within the past month (IRHERRC = 1)" ;
label define HALFLAG   0 "Never used (IRHALRC = 9)"
                       1 "Ever used (IRHALRC = 1-3)" ;
label define HALYR     0 "Did not use in the past year (IRHALRC = 3,9)"
                       1 "Used within the past year (IRHALRC = 1,2)" ;
label define HALMON    0 "Did not use in the past month (IRHALRC = 2-3,9)"
                       1 "Used within the past month (IRHALRC = 1)" ;
label define LSDFLAG   0 "Never used (IRLSDRC = 9)"
                       1 "Ever used (IRLSDRC = 1-3)" ;
label define LSDYR     0 "Did not use in the past year (IRLSDRC = 3,9)"
                       1 "Used within the past year (IRLSDRC = 1,2)" ;
label define LSDMON    0 "Did not use in the past month (IRLSDRC = 2-3,9)"
                       1 "Used within the past month (IRLSDRC = 1)" ;
label define PCPFLAG   0 "Never used (IRPCPRC = 9)"
                       1 "Ever used (IRPCPRC = 1-3)" ;
label define PCPYR     0 "Did not use in the past year (IRPCPRC = 3,9)"
                       1 "Used within the past year (IRPCPRC = 1,2)" ;
label define PCPMON    0 "Did not use in the past month (IRPCPRC = 2-3,9)"
                       1 "Used within the past month (IRPCPRC = 1)" ;
label define INHFLAG   0 "Never used (IRINHRC = 9)"
                       1 "Ever used (IRINHRC = 1-3)" ;
label define INHYR     0 "Did not use in the past year (IRINHRC = 3,9)"
                       1 "Used within the past year (IRINHRC = 1,2)" ;
label define INHMON    0 "Did not use in the past month (IRINHRC = 2-3,9)"
                       1 "Used within the past month (IRINHRC = 1)" ;
label define ANLFLAG   0 "Never used (IRANLRC = 9)"
                       1 "Ever used (IRANLRC = 1-3)" ;
label define ANLYR     0 "Did not use in the past year (IRANLRC = 3,9)"
                       1 "Used within the past year (IRANLRC = 1,2)" ;
label define ANLMON    0 "Did not use in the past month (IRANLRC = 2-3,9)"
                       1 "Used within the past month (IRANLRC = 1)" ;
label define TRQFLAG   0 "Never used (IRTRNRC = 9)"
                       1 "Ever used (IRTRNRC = 1-3)" ;
label define TRQYR     0 "Did not use in the past year (IRTRNRC = 3,9)"
                       1 "Used within the past year (IRTRNRC = 1,2)" ;
label define TRQMON    0 "Did not use in the past month (IRTRNRC = 2-3,9)"
                       1 "Used within the past month (IRTRNRC = 1)" ;
label define STMFLAG   0 "Never used (IRSTMRC = 9)"
                       1 "Ever used (IRSTMRC = 1-3)" ;
label define STMYR     0 "Did not use in the past year (IRSTMRC = 3,9)"
                       1 "Used within the past year (IRSTMRC = 1,2)" ;
label define STMMON    0 "Did not use in the past month (IRSTMRC = 2-3,9)"
                       1 "Used within the past month (IRSTMRC = 1)" ;
label define MTHFLAG   0 "Never Used (IRMTHRC=9)" 1 "Ever Used (IRMTHRC=1-3)" ;
label define MTHYR     0 "Did not use in the past year (IRMTHRC=3,9)"
                       1 "Used within the past year (IRMTHRC=1,2)" ;
label define MTHMON    0 "Did not use in the past month (IRMTHRC=2-3,9)"
                       1 "Used within the past month (IRMTHRC=1)" ;
label define SEDFLAG   0 "Never used (IRSEDRC = 9)"
                       1 "Ever used (IRSEDRC = 1-3)" ;
label define SEDYR     0 "Did not use in the past year (IRSEDRC = 3,9)"
                       1 "Used within the past year (IRSEDRC = 1,2)" ;
label define SEDMON    0 "Did not use in the past month (IRSEDRC = 2-3,9)"
                       1 "Used within the past month (IRSEDRC = 1)" ;
label define PSYFLAG2  0 "Never used (ALL SOURCE VARIABLES = 9)"
                       1 "Ever used (ANY SOURCE VARIABLE < 9)" ;
label define PSYYR2    0 "Did not use within past year (ALL SOURCE VARS > 2)"
                       1 "Used in past year (ANY SOURCE VARIABLE < 3)" ;
label define PSYMON2   0 "Did not use in past month (ALL SOURCE VARS > 1)"
                       1 "Used in past month (ANY SOURCE VARIABLE = 1)" ;
label define SUMFLAG   0 "Never used (ALL SOURCE VARIABLES = 0)"
                       1 "Ever used (ANY SOURCE VARIABLE = 1)" ;
label define SUMYR     0 "Did not use in past year (ALL SOURCE VARS =0)"
                       1 "Used in past year (ANY SOURCE VARIABLE = 1)" ;
label define SUMMON    0 "Did not use in past month (ALL SOURCE VARS = 0)"
                       1 "Used in past month (ANY SOURCE VARIABLE = 1)" ;
label define MJOFLAG   0 "Never used MJ/has used both MJ & anothr illct drug"
                       1 "Marijuana is only (illicit) drug ever used" ;
label define MJOYR2    0 "MJ not used past yr/Used MJ & othr drug past yr"
                       1 "Marijuana is only (illicit) drug in past year" ;
label define MJOMON2   0 "MJ not used past mnth/Used MJ & othr drug past mo"
                       1 "Marijuana only (illicit) drug in past month" ;
label define IEMFLAG   0 "Never used drug/used only marijuana"
                       1 "Illicit drug except for marijuana are ever used" ;
label define IEMYR     0 "Never used drug/used only marijuana past year"
                       1 "Illicit drug except for marijuana used past year" ;
label define IEMMON    0 "Never used drug/used only marijuana past month"
                       1 "Illicit drug except for marijuana used past month" ;
label define BINGEDRK  0 "Never/No 'Binge' alcohol use (IRALCD5 = 0)"
                       1 "'Binge' alcohol use (IRALCD5 = 1-30)" ;
label define HVYDRK2   0 "Never/No heavy alcohol use (IRALCD5 = 0-4)"
                       1 "Heavy alcohol use (IRALCD5 = 5-30)" ;
label define BINGEHVY  1 "Heavy Alcohol Use (HVYDRK2=1)"
                       2 "'Binge' But Not Heavy Use (BINGEDRK=1 & HVYDRK2=0)"
                       3 "Past Month But Not 'Binge' (ALCMON=1 & BINGEDRK=0)"
                       4 "Did Not Use Alcohol in Pst Month (All source=0)" ;
label define PEYOTE2   0 "No/Unknown (PEYOTE=2,85,91,94,97)"
                       1 "Yes (PEYOTE=1)" ;
label define MESC2     0 "No/Unknown (MESC=2,85,91,94,97)" 1 "Yes (MESC=1)" ;
label define PSILCY2   0 "No/Unknown (PSILCY=2,85,91,94,97)"
                       1 "Yes (PSILCY=1,3)" ;
label define ECSTASY2  0 "No/Unknown (ECSTASY=2,85,91,94,97)"
                       1 "Yes (ECSTASY=1)" ;
label define AMYLNIT2  0 "No/Unknown (AMYLNIT=2,91,94,97)"
                       1 "Yes (AMYLNIT=1,3)" ;
label define CLEFLU2   0 "No/Unknown (CLEFLU=2,91,94,97)"
                       1 "Yes (CLEFLU=1,3)" ;
label define GAS2      0 "No/Unknown (GAS=2,91,94,97)" 1 "Yes (GAS=1,3)" ;
label define GLUE2     0 "No/Unknown (GLUE=2,91,94,97)" 1 "Yes (GLUE=1,3)" ;
label define ETHER2    0 "No/Unknown (ETHER=2,91,94,97)" 1 "Yes (ETHER=1)" ;
label define SOLVENT2  0 "No/Unknown (SOLVENT=2,91,94,97,98)"
                       1 "Yes (SOLVENT=1,3)" ;
label define LGAS2     0 "No/Unknown (LGAS=2,91,94,97,98)" 1 "Yes (LGAS=1,3)" ;
label define NITOXID2  0 "No/Unknown (NITOXID=2,91,94,97,98)"
                       1 "Yes (NITOXID=1,3)" ;
label define SPPAINT2  0 "No/Unknown (SPPAINT=2,91,94,97,98)"
                       1 "Yes (SPPAINT=1)" ;
label define AEROS2    0 "No/Unknown (AEROS=2,91,94,97,98)"
                       1 "Yes (AEROS=1,3)" ;
label define DARVTYL2  0 "No/Unknown (DARVTYLC=2,81,85,91,94,97,98)"
                       1 "Yes (DARVTYLC=1,3)" ;
label define PERCTYL2  0 "No/Unknown (PERCTYLX=2,81,85,91,94,97,98)"
                       1 "Yes (PERCTYLX=1,3)" ;
label define VICOLOR2  0 "No/Unknown (VICOLOR=2,81,85,91,94,97,98)"
                       1 "Yes (VICOLOR=1,3)" ;
label define CODEINE2  0 "No/Unknown (CODEINE=6,81,85,91,94,97,98,99)"
                       1 "Yes (CODEINE=1,3)" ;
label define DEMEROL2  0 "No/Unknown (DEMEROL=6,81,85,91,94,97,98,99)"
                       1 "Yes (DEMEROL=1,3)" ;
label define DILAUD2   0 "No/Unknown (DILAUD=6,81,85,91,94,97,98,99)"
                       1 "Yes (DILAUD = 1,3)" ;
label define FIORICT2  0 "No/Unknown (FIORICET=6,81,85,91,94,97,98,99)"
                       1 "Yes (FIORICET=1)" ;
label define FIORINL2  0 "No/Unknown (FIORINAL= 6,81,85,91,94,97,98,99)"
                       1 "Yes (FIORINAL=1,3)" ;
label define HYDROCD2  0 "No/Unknown (HYDROCOD= 6,81,85,91,94,97,98,99)"
                       1 "Yes (HYDROCOD=1,3)" ;
label define METHDON2  0 "No/Unknown (METHDON=6,81,85,91,94,97,98,99)"
                       1 "Yes (METHDON = 1,3)" ;
label define MORPHIN2  0 "No/Unknown (MORPHINE=6,81,85,91,94,97,98,99)"
                       1 "Yes (MORPHINE = 1,3)" ;
label define OXYCONT2  0 "No/Unknown (OXYCONTN=6,81,85,91,94,97,98,99)"
                       1 "Yes (OXYCONTN = 1,3)" ;
label define PHENCOD2  0 "No/Unknown (PHENCOD=6,81,85,91,94,97,98,99)"
                       1 "Yes (PHENCOD = 1,3)" ;
label define PROPOXY2  0 "No/Unknown (PROPOXY=6,81,85,91,94,97,98,99)"
                       1 "Yes (PROPOXY = 1)" ;
label define SK65A2    0 "No/Unknown (SK65A=6,81,85,91,94,97,98,99)"
                       1 "Yes (SK65A = 1)" ;
label define STADOL2   0 "No/Unknown (STADOL=6,81,85,91,94,97,98,99)"
                       1 "Yes (STADOL = 1)" ;
label define TALACEN2  0 "No/Unknown (TALACEN=6,81,85,91,94,97,98,99)"
                       1 "Yes (TALACEN = 1)" ;
label define TALWIN2   0 "No/Unknown (TALWIN=6,81,85,91,94,97,98,99)"
                       1 "Yes (TALWIN = 1)" ;
label define TALWINX2  0 "No/Unknown (TALWINNX=6,81,85,91,94,97,98,99)"
                       1 "Yes (TALWINNX = 1,3)" ;
label define TRAMADL2  0 "No/Unknown (TRAMADOL=6,81,85,91,94,97,98,99)"
                       1 "Yes (TRAMADOL = 1)" ;
label define ULTRAM2   0 "No/Unknown (ULTRAM=6,81,85,91,94,97,98,99)"
                       1 "Yes (ULTRAM = 1,3)" ;
label define OTHANL    0 "No/Unknwn (ANLCARD/ANLNOLST=2,4,81,85,91,94,97,98)"
                       1 "Yes (ANLCARD or ANLNOLST = 1,3)" ;
label define KLONOPI2  0 "No/Unknown (KLONOPIN=2,81,85,91,94,97,98)"
                       1 "Yes (KLONOPIN=1)" ;
label define XNAXATV2  0 "No/Unknown (XNAXATVN=2,81,85,91,94,97,98)"
                       1 "Yes (XNAXATVN=1,3)" ;
label define VALMDIA2  0 "No/Unknown (VALMDIAZ=2,81,85,91,94,97,98)"
                       1 "Yes (VALMDIAZ=1,3)" ;
label define ATARAX2   0 "No/Unknown (ATARAX=6,81,85,91,94,97,98,99)"
                       1 "Yes (ATARAX = 1,3)" ;
label define BUSPAR2   0 "No/Unknown (BUSPAR=6,81,85,91,94,97,98,99)"
                       1 "Yes (BUSPAR = 1)" ;
label define EQUANIL2  0 "No/Unknown (EQUANIL=6,81,85,91,94,97,98,99)"
                       1 "Yes (EQUANIL = 1,3)" ;
label define FLEXERL2  0 "No/Unknown (FLEXERIL=6,81,85,91,94,97,98,99)"
                       1 "Yes (FLEXERIL = 1,3)" ;
label define LIBRIUM2  0 "No/Unknown (LIBRIUM=6,81,85,91,94,97,98,99)"
                       1 "Yes (LIBRIUM = 1)" ;
label define LIMBTRL2  0 "No/Unknown (LIMBTROL=6,81,85,91,94,97,98,99)"
                       1 "Yes (LIMBTROL = 1)" ;
label define MEPROB2   0 "No/Unknown (MEPROB=6,81,91,94,97,98,99)"
                       1 "Yes (MEPROB = 1)" ;
label define MILTOWN2  0 "No/Unknown (MILTOWN=6,81,91,94,97,98,99)"
                       1 "Yes (MILTOWN = 1)" ;
label define ROHYPNL2  0 "No/Unknown (ROHYPNOL=6,81,85,91,94,97,98,99)"
                       1 "Yes (ROHYPNOL = 1,3)" ;
label define SERAX2    0 "No/Unknown (SERAX=6,81,85,91,94,97,98,99)"
                       1 "Yes (SERAX = 1)" ;
label define SOMA2     0 "No/Unknown (SOMA=6,81,85,91,94,97,98,99)"
                       1 "Yes (SOMA = 1,3)" ;
label define TRANXEN2  0 "No/Unknown (TRANXENE=6,81,85,91,94,97,98,99)"
                       1 "Yes (TRANXENE = 1)" ;
label define VISTAR2   0 "No/Unknown (VISTAR=6,81,85,91,94,97,98,99)"
                       1 "Yes (VISTAR = 1)" ;
label define OTHTRN    0 "No/Unknwn (TRNCARD/TRNNOLST=2,4,81,85,91,94,97,98)"
                       1 "Yes (TRNCARD or TRNNOLST = 1,3)" ;
label define METHDES2  0 "No/Unknown (METHDES=2,81,85,91,94,97,98)"
                       1 "Yes (METHDES=1,3)" ;
label define DIETPIL2  0 "No/Unknown (DIETPILS=2,81,85,91,94,97,98)"
                       1 "Yes (DIETPILS=1,3)" ;
label define RITMPHE2  0 "No/Unknown (RITMPHEN=2,81,85,91,94,97,98)"
                       1 "Yes (RITMPHEN=1,3)" ;
label define CYLERT2   0 "No/ Unknown (CYLERT=6,81,85,91,94,97,98,99)"
                       1 "Yes (CYLERT = 1,3)" ;
label define DEXED2    0 "No/ Unknown (DEXED=6,81,85,91,94,97,98,99)"
                       1 "Yes (DEXED = 1)" ;
label define DETAMP2   0 "No/ Unknown (DETAMP=6,81,85,91,94,97,98,99)"
                       1 "Yes (DETAMP = 1)" ;
label define DIDREX2   0 "No/ Unknown (DIDREX=6,81,85,91,94,97,98,99)"
                       1 "Yes (DIDREX = 1,3)" ;
label define ESKAT2    0 "No/ Unknown (ESKAT=6,81,85,91,94,97,98,99)"
                       1 "Yes (ESKAT = 1,3)" ;
label define IONAMIN2  0 "No/ Unknown (IONAMIN=6,81,85,91,94,97,98,99)"
                       1 "Yes (IONAMIN = 1)" ;
label define MAZANOR2  0 "No/Unknown (MAZANOR=6,81,85,91,94,97,98,99)"
                       1 "Yes (MAZANOR = 1)" ;
label define OBLA2     0 "No/Unknown (OBLA=6,81,85,91,94,97,98,99)"
                       1 "Yes (OBLA = 1)" ;
label define PLEGINE2  0 "No/Unknown (PLEGINE=6,81,85,91,94,97,98,99)"
                       1 "Yes (PLEGINE = 1)" ;
label define PRELUDN2  0 "No/Unknown (PRELUDIN=6,81,85,91,94,97,98,99)"
                       1 "Yes (PRELUDIN = 1,3)" ;
label define SANOREX2  0 "No/ Unknown (SANOREX=6,81,85,91,94,97,98,99)"
                       1 "Yes (SANOREX = 1)" ;
label define TENUATE2  0 "No/ Unknown (TENUATE=6,81,85,91,94,97,98,99)"
                       1 "Yes (TENUATE = 1,3)" ;
label define OTHSTM    0 "No/Unknwn (STMCARD/STMNOLST=2,4,81,85,91,94,97,98)"
                       1 "Yes (STMCARD or STMNOLST = 1,3)" ;
label define METHAQ2   0 "No/Unknown (METHAQ=2,81,85,91,94,97,98)"
                       1 "Yes (METHAQ=1)" ;
label define NEMBBAR2  0 "No/Unknown (NEMBBARB=2,81,85,91,94,97,98)"
                       1 "Yes (NEMBBARB=1)" ;
label define RESTTMA2  0 "No/Unknown (RESTTMAZ=2,81,85,91,94,97,98)"
                       1 "Yes (RESTTMAZ=1)" ;
label define AMYTAL2   0 "No/Unknown (AMYTAL=6,81,85,91,94,97,98,99)"
                       1 "Yes (AMYTAL= 1)" ;
label define BUTISOL2  0 "No/Unknown (BUTISOL=6,81,85,91,94,97,98,99)"
                       1 "Yes (BUTISOL= 1)" ;
label define CHHYD2    0 "No/Unknown (CHHYD=6,81,85,91,94,97,98,99)"
                       1 "Yes (CHHYD= 1)" ;
label define DALMANE2  0 "No/Unknown (DALMANE=6,81,85,91,94,97,98,99)"
                       1 "Yes (DALMANE=1,3)" ;
label define HALCION2  0 "No/Unknown (HALCION=6,81,85,91,94,97,98,99)"
                       1 "Yes (HALCION=1,3)" ;
label define PHENOBR2  0 "No/Unknown (PHENOBAR=6,81,85,91,94,97,98,99)"
                       1 "Yes (PHENOBAR=1,3)" ;
label define PLACIDY2  0 "No/Unknown (PLACIDYL=6,81,85,91,94,97,98,99)"
                       1 "Yes (PLACIDYL= 1,3)" ;
label define TUINAL2   0 "No/Unknown (TUINAL=6,81,85,91,94,97,98,99)"
                       1 "Yes (TUINAL=1,3)" ;
label define OTHSED    0 "No/Unknwn (SEDCARD/SEDNOLST=2,4,81,85,91,94,97,98)"
                       1 "Yes (SEDCARD or SEDNOLST = 1,3)" ;
label define ALCAFU    1 "14 Years or Younger (IRALCAGE=1-14)"
                       2 "15-17 Years Old (IRALCAGE=15-17)"
                       3 "18 Years or Older (IRALCAGE=18+)"
                       4 "Non Users (IRALCAGE = 991)" ;
label define MJAFU     1 "14 Years or Younger (IRMJAGE=1-14)"
                       2 "15-17 Years Old (IRMJAGE=15-17)"
                       3 "18 Years or Older (IRMJAGE=18+)"
                       4 "Non Users (IRMJAGE = 991)" ;
label define COCAFU    1 "14 Years or Younger (IRCOCAGE=1-14)"
                       2 "15-17 Years Old (IRCOCAGE=15-17)"
                       3 "18 Years or Older (IRCOCAGE=18+)"
                       4 "Non Users (IRCOCAGE = 991)" ;
label define HERAFU    1 "14 Years or Younger (IRHERAGE=1-14)"
                       2 "15-17 Years Old (IRHERAGE=15-17)"
                       3 "18 Years or Older (IRHERAGE=18+)"
                       4 "Non Users (IRHERAGE = 991)" ;
label define HALAFU    1 "14 Years or Younger (IRHALAGE=1-14)"
                       2 "15-17 Years Old (IRHALAGE=15-17)"
                       3 "18 Years or Older (IRHALAGE=18+)"
                       4 "Non Users (IRHALAGE = 991)" ;
label define INHAFU    1 "14 Years or Younger (IRINHAGE=1-14)"
                       2 "15-17 Years Old (IRINHAGE=15-17)"
                       3 "18 Years or Older (IRINHAGE=18+)"
                       4 "Non Users (IRINHAGE = 991)" ;
label define ANLAFU    1 "14 Years or Younger (IRANLAGE=1-14)"
                       2 "15-17 Years Old (IRANLAGE=15-17)"
                       3 "18 Years or Older (IRANLAGE=18+)"
                       4 "Non Users (IRANLAGE = 991)" ;
label define TRNAFU    1 "14 Years or Younger (IRTRNAGE=1-14)"
                       2 "15-17 Years Old (IRTRNAGE=15-17)"
                       3 "18 Years or Older (IRTRNAGE=18+)"
                       4 "Non Users (IRTRNAGE = 991)" ;
label define STMAFU    1 "14 Years or Younger (IRSTMAGE=1-14)"
                       2 "15-17 Years Old (IRSTMAGE=15-17)"
                       3 "18 Years or Older (IRSTMAGE=18+)"
                       4 "Non Users (IRSTMAGE = 991)" ;
label define SEDAFU    1 "14 Years or Younger (IRSEDAGE=1-14)"
                       2 "15-17 Years Old (IRSEDAGE=15-17)"
                       3 "18 Years or Older (IRSEDAGE=18+)"
                       4 "Non Users (IRSEDAGE = 991)" ;
label define CIGAFU    1 "14 Years or Younger (IRCIGAGE=1-14)"
                       2 "15-17 Years Old (IRCIGAGE=15-17)"
                       3 "18 Years or Older (IRCIGAGE=18+)"
                       4 "Non Users (IRCIGAGE = 991)" ;
label define CGRAFU    1 "14 Years or Younger (IRCGRAGE=1-14)"
                       2 "15-17 Years Old (IRCGRAGE=15-17)"
                       3 "18 Years or Older (IRCGRAGE=18+)"
                       4 "Non Users (IRCGRAGE = 991)" ;
label define SLTAFU    1 "14 Years or Younger (IRSLTAGE=1-14)"
                       2 "15-17 Years Old (IRSLTAGE=15-17)"
                       3 "18 Years or Older (IRSLTAGE=18+)"
                       4 "Non Users (IRSLTAGE = 991)" ;
label define MRJYDAYS  1 "1-11 Days (IRMJFY=1-11)"
                       2 "12-49 Days (IRMJFY=12-49)"
                       3 "50-99 Days (IRMJFY=50-99)"
                       4 "100-299 Days (IRMJFY=100-299)"
                       5 "300-365 Days (IRMJFY=300-365)"
                       6 "No Past Year Use (IRMJFY=991,993)" ;
label define COCYDAYS  1 "1-11 Days (IRCOCFY=1-11)"
                       2 "12-49 Days (IRCOCFY=12-49)"
                       3 "50-99 Days (IRCOCFY=50-99)"
                       4 "100-299 Days (IRCOCFY=100-299)"
                       5 "300-365 Days (IRCOCFY=300-365)"
                       6 "No Past Year Use (IRCOCFY=991,993)" ;
label define HALYDAYS  1 "1-11 Days (IRHALFY=1-11)"
                       2 "12-49 Days (IRHALFY=12-49)"
                       3 "50-99 Days (IRHALFY=50-99)"
                       4 "100-299 Days (IRHALFY=100-299)"
                       5 "300-365 Days (IRHALFY=300-365)"
                       6 "No Past Year Use (IRHALFY=991,993)" ;
label define INHYDAYS  1 "1-11 Days (IRINHFY=1-11)"
                       2 "12-49 Days (IRINHFY=12-49)"
                       3 "50-99 Days (IRINHFY=50-99)"
                       4 "100-299 Days (IRINHFY=100-299)"
                       5 "300-365 Days (IRINHFY=300-365)"
                       6 "No Past Year Use (IRINHFY=991,993)" ;
label define ALCYDAYS  1 "1-11 Days (IRALCFY=1-11)"
                       2 "12-49 Days (IRALCFY=12-49)"
                       3 "50-99 Days (IRALCFY=50-99)"
                       4 "100-299 Days (IRALCFY=100-299)"
                       5 "300-365 Days (IRALCFY=300-365)"
                       6 "No Past Year Use (IRALCFY=991,993)" ;
label define MRJMDAYS  1 "1-2 Days (IRMJFM=1-2)" 2 "3-5 Days (IRMJFM=3-5)"
                       3 "6-19 Days (IRMJFM=6-19)"
                       4 "20-30 Days (IRMJFM=20-30)"
                       5 "No Past Month Use (IRMJFM=91,93)" ;
label define COCMDAYS  1 "1-2 Days (IRCOCFM=1-2)" 2 "3-5 Days (IRCOCFM=3-5)"
                       3 "6-19 Days (IRCOCFM=6-19)"
                       4 "20-30 Days (IRCOCFM=20-30)"
                       5 "No Past Month Use (IRCOCFM=91,93)" ;
label define HALMDAYS  1 "1-2 Days (IRHALFM=1-2)" 2 "3-5 Days (IRHALFM=3-5)"
                       3 "6-19 Days (IRHALFM=6-19)"
                       4 "20-30 Days (IRHALFM=20-30)"
                       5 "No Past Month Use (IRHALFM=91,93)" ;
label define INHMDAYS  1 "1-2 Days (IRINHFM=1-2)" 2 "3-5 Days (IRINHFM=3-5)"
                       3 "6-19 Days (IRINHFM=6-19)"
                       4 "20-30 Days (IRINHFM=20-30)"
                       5 "No Past Month Use (IRINHFM=91,93)" ;
label define ALCMDAYS  1 "1-2 Days (IRALCFM=1-2)" 2 "3-5 Days (IRALCFM=3-5)"
                       3 "6-19 Days (IRALCFM=6-19)"
                       4 "20-30 Days (IRALCFM=20-30)"
                       5 "No Past Month Use (IRALCFM=91,93)" ;
label define CIGMDAYS  1 "1-2 Days (IRCIGFM=1,2)" 2 "3-5 Days (IRCIGFM=3-5)"
                       3 "6-19 Days (IRCIGFM=6-19)"
                       4 "20-29 Days (IRCIGFM=20-29)"
                       5 "30 Days (IRCIGFM=30)"
                       6 "No Past Month Use (IRCIGFM=91,93)" ;
label define CIGPDAY   1 "Fewer Than 6 (CIG30AV=1,2,3 AND IRCIGFM=30)"
                       2 "6-15 (CIG30AV=4 AND IRCIGFM=30)"
                       3 "16-25 (CIG30AV=5 AND IRCIGFM=30)"
                       4 "26 or More (CIG30AV=6,7 AND IRCIGFM=30)"
                       5 "Not Reported (CIG30AV=85,94,97,98 AND IRCIGFM=30)"
                       6 "No Daily Use(CIG30AV=91,93 OR IRCIGFM=1-29,91,93)" ;
label define CG05      1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CG06      1 "More than 30 days ago but within the past 12 mos"
                       2 "More than 12 months ago but within the past 3 yrs"
                       3 "More than 3 years ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CG06DK    1 "More than 30 days ago but within the past 12 mos"
                       2 "More than 12 months ago but within the past 3 yrs"
                       3 "More than 3 years ago" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define CG06RE    1 "More than 30 days ago but within the past 12 mos"
                       2 "More than 12 months ago but within the past 3 yrs"
                       3 "More than 3 years ago" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define CG19      1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CG20      1 "More than 30 days ago but within the past 12 mos"
                       2 "More than 12 months ago but within the past 3 yrs"
                       3 "More than 3 years ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CG20DK    1 "More than 30 days ago but within the past 12 mos"
                       2 "More than 12 months ago but within the past 3 yrs"
                       3 "More than 3 years ago" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define CG20RE    1 "More than 30 days ago but within the past 12 mos"
                       3 "More than 3 years ago" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define CG27      1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CG28      1 "More than 30 days ago but within the past 12 mos"
                       2 "More than 12 months ago but within the past 3 yrs"
                       3 "More than 3 years ago" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define CG28DK    2 "More than 12 months ago but within the past 3 yrs"
                       3 "More than 3 years ago" 94 "DON'T KNOW"
                       98 "BLANK (NO ANSWER)" ;
label define CG28RE    94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CG36      1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CG37      1 "More than 30 days ago but within the past 12 mos"
                       2 "More than 12 months ago but within the past 3 yrs"
                       3 "More than 3 years ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CG37DK    1 "More than 30 days ago but within the past 12 mos"
                       2 "More than 12 months ago but within the past 3 yrs"
                       3 "More than 3 years ago" 94 "DON'T KNOW"
                       98 "BLANK (NO ANSWER)" ;
label define CG37RE    1 "More than 30 days ago but within the past 12 mos"
                       2 "More than 12 months ago but within the past 3 yrs"
                       3 "More than 3 years ago" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define CG43      1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 98 "BLANK (NO ANSWER)" ;
label define ALLAST3   1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALRECDK   1 "Within the past 30 days --that is, since DATEFILL"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       98 "BLANK (NO ANSWER)" ;
label define ALRECRE   1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TOTDRINK  985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define ALFRAME3  1 "Avg num of days per week during pst 12 mos"
                       2 "Avg num of days per month during pst 12 mos"
                       3 "Total number of days during the past 12 months"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALYRAVE   985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define ALMONAVE  85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALWKAVE   85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MJLAST3   1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 month"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MJRECDK   1 "DATEFILL"
                       2 "More than 30 days ago but within the pst 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MJRECRE   1 "DATEFILL"
                       2 "More than 30 days ago but within the pst 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TOTMJ     985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define MJFRAME3  1 "Avg num of days per week during pst 12 mos"
                       2 "Avg num of days per month during pst 12 mos"
                       3 "Total number of days during the past 12 months"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MJYRAVE   994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define MJMONAVE  85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MJWKAVE   85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CCLAST3   1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 month"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CCRECDK   3 "More than 12 months ago" 94 "DON'T KNOW"
                       98 "BLANK (NO ANSWER)" ;
label define CCRECRE   1 "DATEFILL"
                       2 "More than 30 days ago but within the pst 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TOTCOKE   985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define CCFRAME3  1 "Avg num of days per week during pst 12 mos"
                       2 "Avg num of days per month during pst 12 mos"
                       3 "Total number of days during the past 12 months"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CCYRAVE   985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define CCMONAVE  94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CCWKAVE   94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CKLAST3   1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 month"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CKRECDK   1 "DATEFILL"
                       2 "More than 30 days ago but within the pst 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       98 "BLANK (NO ANSWER)" ;
label define CKRECRE   97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TOTCRACK  994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define CKFRAME3  1 "Avg num of days per week during pst 12 mos"
                       2 "Avg num of days per month during pst 12 mos"
                       3 "Total number of days during the past 12 months"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CKYRAVE   994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define CKMONAVE  94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CKWKAVE   94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HELAST3   1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 month"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HERECDK   2 "More than 30 days ago but within the pst 12 mos"
                       94 "DON'T KNOW" 98 "BLANK (NO ANSWER)" ;
label define HERECRE   97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TOTHERO   998 "BLANK (NO ANSWER)" ;
label define HEFRAME3  1 "Avg num of days per week during pst 12 mos"
                       2 "Avg num of days per month during pst 12 mos"
                       3 "Total number of days during the past 12 months"
                       94 "DON'T KNOW" 98 "BLANK (NO ANSWER)" ;
label define HEYRAVE   994 "DON'T KNOW" 998 "BLANK (NO ANSWER)" ;
label define HEMONAVE  94 "DON'T KNOW" 98 "BLANK (NO ANSWER)" ;
label define HEWKAVE   98 "BLANK (NO ANSWER)" ;
label define LSLAST    1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define LSRECDK   2 "More than 30 days ago but within the pst 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define LSRECRE   1 "Within the past 30 days -- that is, since[DATEFILL"
                       2 "More than 30 days ago but within the pst 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TOTHALL   985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define LSFRAME3  1 "Avg num of days per week during pst 12 mos"
                       2 "Avg num of days per month during pst 12 mos"
                       3 "Total number of days during the past 12 months"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define LSYRAVE   985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define LSMONAVE  94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define LSWKAVE   94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define LS10      1 "Within the past 30 days - that is, since DATEFILL"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define LS16      1 "Within the past 30 days -- that is, since DATEFILL"
                       2 "More than 30 days ago but within the pst 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INLAST    1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INRECDK   1 "Within the past 30 days -- that is, since DATEFILL"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INRECRE   1 "Within the past 30 days -- that is, since DATEFILL"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TOTINHAL  994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define INFRAME3  1 "Avg num of days per week during pst 12 mos"
                       2 "Avg num of days per month during pst 12 mos"
                       3 "Total number of days during the past 12 months"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INYRAVE   994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define INMONAVE  94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INWKAVE   94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define PR09      1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define PRRECDK   1 "Within the past 30 days -- that is, since DATEFILL"
                       2 "More than 30 days ago but within the past 12 month"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define PRRECRE   1 "Within the past 30 days -- that is, since DATEFILL"
                       2 "More than 30 days ago but within the past 12 month"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define PR10      1 "Avg num of days per week during pst 12 mos"
                       2 "Avg num of days per month during pst 12 mos"
                       3 "Total number of days during the past 12 months"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define PR11      985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define PR12      85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define PR13      85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TR09      1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRRECDK   1 "Within the past 30 days -- that is, since DATEFILL"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRRECRE   2 "More than 30 days ago but within the past 12 mos"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TR10      1 "Avg num of days per week during pst 12 mos"
                       2 "Avg num of days per month during pst 12 mos"
                       3 "Total number of days during the past 12 months"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TR11      985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define TR12      85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TR13      85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ST09      1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STRECDK   1 "Within the past 30 days -- that is, since DATEFILL"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STRECRE   1 "Within the past 30 days -- that is, since DATEFILL"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ST10      1 "Avg num of days per week during pst 12 mos"
                       2 "Avg num of days per month during pst 12 mos"
                       3 "Total number of days during the past 12 months"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ST11      994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define ST12      94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ST13      94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ST19      1 "Within the past 30 days - that is, since DATEFILL"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SV09      1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SVRECDK   3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       98 "BLANK (NO ANSWER)" ;
label define SVRECRE   3 "More than 12 months ago"
                       85 "BAD DATA Logically assigned" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define SV10      1 "Avg num of days per week during pst 12 mos"
                       2 "Avg num of days per month during pst 12 mos"
                       3 "Total number of days during the past 12 months"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SV11      985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define SV12      85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SV13      85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HERSMOKE  1 "Yes" 2 "No" 91 "NEVER USED HEROIN" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define HRSMKREC  1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 91 "NEVER USED HEROIN"
                       93 "USED HEROIN BUT NEVER SMOKED IT" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define HERSNIFF  1 "Yes" 2 "No" 91 "NEVER USED HEROIN" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define HRSNFREC  1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       9 "At some point in the lifetime LOG ASSN"
                       91 "NEVER USED HEROIN"
                       93 "USED HEROIN BUT NEVER SNIFFED IT" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define GNNDLLIF  1 "Yes" 2 "No" 4 "No LOGICALLY ASSIGNED"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define COCNEEDL  1 "Yes" 2 "No" 91 "NEVER USED COCAINE" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (GNNDLLIF = 2)" ;
label define CONDLREC  1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       9 "At some point in the lifetime LOG ASSN"
                       91 "NEVER USED COCAINE"
                       93 "USED COCAINE BUT NEVER WITH A NEEDLE" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (GNNDLLIF = 2)" ;
label define HERNEEDL  1 "Yes" 2 "No" 91 "NEVER USED HEROIN" 97 "REFUSED"
                       99 "LEGITIMATE SKIP (GNNDLLIF = 2)" ;
label define HRNDLREC  1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 91 "NEVER USED HEROIN"
                       93 "USED HEROIN BUT NEVER WITH A NEEDLE" 97 "REFUSED"
                       99 "LEGITIMATE SKIP (GNNDLLIF = 2)" ;
label define STNEEDLE  1 "Yes" 2 "No" 91 "NEVER USED STIMULANTS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (GNNDLLIF = 2)" ;
label define STNDLREC  1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago" 91 "NEVER USED STIMULANTS"
                       93 "USED STIMULANTS BUT NEVER WITH A NEEDLE"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (GNNDLLIF = 2)" ;
label define GNNDREUS  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (GNNDLLIF = 2)" ;
label define GNNDLSH1  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (GNNDLLIF = 2)" ;
label define GNNDCLEN  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (GNNDLLIF = 2)" ;
label define GNNDLSH2  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (GNNDLLIF = 2)" ;
label define GNNDGET2  1 "Bought the needle from a pharmacy"
                       2 "Got the needle from a needle exchange"
                       3 "Bought the needle on the street"
                       4 "Got the needle in a shooting gallery"
                       5 "Got the needle some other way"
                       41 "Given by, stolen from a friend/acquaint of friend"
                       42 "Given by, stolen from a relative"
                       43 "Given by, stolen from someone, relation unspecifd"
                       45 "Found it/got from a waste can"
                       46 "Given by, stolen from medical facility/professionl"
                       49 "Bought, given, stolen from place/location unspecd"
                       54 "Shared needle with friends/other acquaintances"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned (GNNDLLIF=4)"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (GNNDLLIF=2)" ;
label define NEDLRECC  1 "Within the past 30 days"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       9 "At some point in the lifetime LOG ASSN"
                       91 "NEVER USED COC/HER/STM WITH A NEEDLE" 97 "REFUSED"
                       98 "MISSING (BUT NOT REFUSED)" ;
label define NEDFLAG4  0 "Never used (GNNDLLIF=2,4,94,97,98)"
                       1 "Ever Used (GNNDLLIF=1)" ;
label define HERSMOK2  0 "No/Unknown (HERSMOKE=2,91,97,98)"
                       1 "Yes (HERSMOKE=1)" ;
label define HERSNIF2  0 "No/Unknown (HERSNIFF=2,91,97,98)"
                       1 "Yes (HERSNIFF=1)" ;
label define NEDHER    0 "No (HERNEEDL=2,91,97,99)" 1 "Yes (HERNEEDL=1)" ;
label define NEDCOC    0 "No (COCNEEDL=2,91,97,98,99)" 1 "Yes (COCNEEDL=1)" ;
label define NEDSTM    0 "No (STNNEEDL=2,91,94,97,98,99)"
                       1 "Yes (STNNEEDL=1)" ;
label define RSKPKCIG  1 "No risk" 2 "Slight risk" 3 "Moderate risk"
                       4 "Great risk" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RSKMJOCC  1 "No risk" 2 "Slight risk" 3 "Moderate risk"
                       4 "Great risk" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RSKMJREG  1 "No risk" 2 "Slight risk" 3 "Moderate risk"
                       4 "Great risk" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RKTRYLSD  1 "No risk" 2 "Slight risk" 3 "Moderate risk"
                       4 "Great risk" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RKLSDREG  1 "No risk" 2 "Slight risk" 3 "Moderate risk"
                       4 "Great risk" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RKTRYHER  1 "No risk" 2 "Slight risk" 3 "Moderate risk"
                       4 "Great risk" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RKHERREG  1 "No risk" 2 "Slight risk" 3 "Moderate risk"
                       4 "Great risk" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RKCOCOCC  1 "No risk" 2 "Slight risk" 3 "Moderate risk"
                       4 "Great risk" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RKCOCREG  1 "No risk" 2 "Slight risk" 3 "Moderate risk"
                       4 "Great risk" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RK5ALDLY  1 "No risk" 2 "Slight risk" 3 "Moderate risk"
                       4 "Great risk" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RK5ALWK   1 "No risk" 2 "Slight risk" 3 "Moderate risk"
                       4 "Great risk" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RSKDIFMJ  1 "Probably impossible" 2 "Very difficult"
                       3 "Fairly difficult" 4 "Fairly easy" 5 "Very easy"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define RKDIFLSD  1 "Probably impossible" 2 "Very difficult"
                       3 "Fairly difficult" 4 "Fairly easy" 5 "Very easy"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define RKDIFCOC  1 "Probably impossible" 2 "Very difficult"
                       3 "Fairly difficult" 4 "Fairly easy" 5 "Very easy"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define RKDIFCRK  1 "Probably impossible" 2 "Very difficult"
                       3 "Fairly difficult" 4 "Fairly easy" 5 "Very easy"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define RKDIFHER  1 "Probably impossible" 2 "Very difficult"
                       3 "Fairly difficult" 4 "Fairly easy" 5 "Very easy"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define RSKSELL   1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define RKFQDNGR  1 "Never" 2 "Seldom" 3 "Sometimes" 4 "Always"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define RKFQRSKY  1 "Never" 2 "Seldom" 3 "Sometimes" 4 "Always"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define RKFQPBLT  1 "Never" 2 "Seldom" 3 "Sometimes" 4 "Always"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define RKFQDBLT  1 "Never" 2 "Seldom" 3 "Sometimes" 4 "Always"
                       5 "I don't drive" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define GRSKPKCG  -9 "Unknown (RSKPKCIG = 94,97,98)"
                       0 "Otherwise (RSKPKCIG = 1,2,3)"
                       1 "Great Risk (RSKPKCIG = 4)" ;
label define GRSKCREG  -9 "Unknown (RKCOCREG = 94,97,98)"
                       0 "Otherwise (RKCOCREG = 1,2,3)"
                       1 "Great Risk (RKCOCREG = 4)" ;
label define GRSKCOCC  -9 "Unknown (RKCOCOCC = 94,97,98)"
                       0 "Otherwise (RKCOCOCC = 1,2,3)"
                       1 "Great Risk (RKCOCOCC = 4)" ;
label define GRSKMREG  -9 "Unknown (RSKMJREG = 94,97,98)"
                       0 "Otherwise (RSKMJREG = 1,2,3)"
                       1 "Great Risk (RSKMJREG = 4)" ;
label define GRSKMOCC  -9 "Unknown (RSKMJOCC = 94,97,98)"
                       0 "Otherwise (RSKMJOCC = 1,2,3)"
                       1 "Great Risk (RSKMJOCC = 4)" ;
label define GRSKHTRY  -9 "Unknown (RKTRYHER = 94,97,98)"
                       0 "Otherwise (RKTRYHER = 1,2,3)"
                       1 "Great Risk (RKTRYHER = 4)" ;
label define GRSKHREG  -9 "Unknown (RKHERREG = 94,97,98)"
                       0 "Otherwise (RKHERREG = 1,2,3)"
                       1 "Great Risk (RKHERREG = 4)" ;
label define GRSKLTRY  -9 "Unknown (RKTRYLSD = 94,97,98)"
                       0 "Otherwise (RKTRYLSD = 1,2,3)"
                       1 "Great Risk (RKTRYLSD=4)" ;
label define GRSKLREG  -9 "Unknown (RKLSDREG = 94,97,98)"
                       0 "Otherwise (RKLSDREG = 1,2,3)"
                       1 "Great Risk (RKLSDREG = 4)" ;
label define GRSKD4_5  -9 "Unknown (RK5ALDLY = 94,97,98)"
                       0 "Otherwise (RK5ALDLY = 1,2,3)"
                       1 "Great Risk (RK5ALDLY = 4)" ;
label define GRSKD5WK  -9 "Unknown (RK5ALWK = 94,97,98)"
                       0 "Otherwise (RK5ALWK = 1,2,3)"
                       1 "Great Risk (RK5ALWK = 4)" ;
label define RDIFMJ    -9 "Unknown (RSKDIFMJ = 94,97,98)"
                       0 "Otherwise (RSKDIFMJ = 1,2,3)"
                       1 "Fairly or very easy (RSKDIFMJ = 4,5)" ;
label define RDIFCOC   -9 "Unknown (RKDIFCOC = 94,97,98)"
                       0 "Otherwise (RKDIFCOC = 1,2,3)"
                       1 "Fairly or very easy (RKDIFCOC = 4,5)" ;
label define RDIFHER   -9 "Unknown (RKDIFHER = 94,97,98)"
                       0 "Otherwise (RKDIFHER = 1,2,3)"
                       1 "Fairly or very easy (RKDIFHER = 4,5)" ;
label define RDIFLSD   -9 "Unknown (RKDIFLSD = 94,97,98)"
                       0 "Otherwise (RKDIFLSD = 1,2,3)"
                       1 "Fairly or very easy (RKDIFLSD = 4,5)" ;
label define RDIFCRK   -9 "Unknown (RKDIFCRK = 94,97,98)"
                       0 "Otherwise (RKDIFCRK = 1,2,3)"
                       1 "Fairly or very easy (RKDIFCRK = 4,5)" ;
label define APPSELDG  -9 "Unknown (RSKSELL = 85,94,97,98)"
                       0 "No (RSKSELL = 2)" 1 "Yes (RSKSELL = 1)" ;
label define CIGLOTTM  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIGLIMIT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIGKPLMT  1 "Usually kept to the limits set"
                       2 "Often smoked more than intended"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGNDMOR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIGLSEFX  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGCUTDN  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIGCUTEV  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGCUT1X  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGWD4SX  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       90 "NOT ASKED THE QUESTION Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGWDSMT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       90 "NOT ASKED THE QUESTION Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGEMOPB  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIGEMCTD  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGPHLPB  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGPHCTD  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGLSACT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define CIGPKCRT  1 "Pack" 2 "Carton" 85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGPDPAK  1 "Less than $1.00" 2 "$1.00 - $1.50"
                       3 "$1.51 - $2.00" 4 "$2.01 - $2.50" 5 "$2.51 - $3.00"
                       6 "$3.01 - $3.50" 7 "$3.51 - $4.00" 8 "$4.01 - $4.50"
                       9 "$4.51 - $5.00" 10 "More than $5.00"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define CIGPDCRT  1 "Less than $10.00" 2 "$10.00 - $10.99"
                       3 "$11.00 - $11.99" 4 "$12.00 - $12.99"
                       5 "$13.00 - $13.99" 6 "$14.00 - $14.99"
                       7 "$15.00 - $15.99" 8 "$16.00 - $16.99"
                       9 "$17.00 - $17.99" 10 "$18.00 - $18.99"
                       11 "$19.00 - $19.99" 12 "$20.00 - $20.99"
                       13 "$21.00 - $21.99" 14 "$22.00 - $22.99"
                       15 "$23.00 or more" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCLOTTM  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALCGTOVR  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCLIMIT  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALCKPLMT  1 "Usually kept to the limits set"
                       2 "Often drank more than intended"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCNDMOR  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALCLSEFX  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCCUTDN  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALCCUTEV  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCCUT1X  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCWD2SX  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCWDSMT  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCEMOPB  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALCEMCTD  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCPHLPB  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCPHCTD  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ALCLSACT  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALCSERPB  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALCPDANG  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALCLAWTR  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALCFMFPB  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ALCFMCTD  1 "Yes" 2 "No"
                       83 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn"
                       91 "NEVER USED ALCOHOL"
                       93 "DID NOT USE ALC PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MRJLOTTM  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MRJGTOVR  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MRJLIMIT  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MRJKPLMT  1 "Usually kept to the limits set"
                       2 "Often used more than intended"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MRJNDMOR  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MRJLSEFX  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MRJCUTDN  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MRJCUTEV  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MRJEMOPB  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MRJEMCTD  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MRJPHLPB  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MRJPHCTD  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define MRJLSACT  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MRJSERPB  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MRJPDANG  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MRJLAWTR  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MRJFMFPB  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define MRJFMCTD  1 "Yes" 2 "No"
                       83 "DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn"
                       91 "NEVER USED MARIJUANA"
                       93 "DID NOT USE MJ PST 12 MOS OR USED <6 DYS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define COCLOTTM  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define COCGTOVR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define COCLIMIT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define COCKPLMT  1 "Usually kept to the limits set"
                       2 "Often used more than intended"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define COCNDMOR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define COCLSEFX  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define COCCUTDN  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define COCCUTEV  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define COCCUT1X  1 "Yes" 2 "No" 91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define COCFLBLU  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define COCWD2SX  1 "Yes" 2 "No" 91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define COCWDSMT  1 "Yes" 2 "No" 91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define COCEMOPB  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define COCEMCTD  1 "Yes" 2 "No" 91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define COCPHLPB  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define COCPHCTD  1 "Yes" 2 "No" 91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define COCLSACT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define COCSERPB  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define COCPDANG  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define COCLAWTR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define COCFMFPB  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define COCFMCTD  1 "Yes" 2 "No" 91 "NEVER USED COCAINE"
                       93 "DID NOT USE COCAINE PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HERLOTTM  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HERGTOVR  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HERLIMIT  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HERKPLMT  1 "Usually kept to the limits set"
                       2 "Often used more than intended"
                       91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HERNDMOR  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HERLSEFX  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HERCUTDN  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HERCUTEV  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HERCUT1X  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HERWD3SX  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HERWDSMT  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HEREMOPB  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HEREMCTD  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HERPHLPB  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HERPHCTD  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HERLSACT  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HERSERPB  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HERPDANG  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HERLAWTR  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HERFMFPB  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HERFMCTD  1 "Yes" 2 "No" 91 "NEVER USED HEROIN"
                       93 "DID NOT USE HEROIN PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HALLOTTM  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HALGTOVR  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HALLIMIT  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HALKPLMT  1 "Usually kept to the limits set"
                       2 "Often used more than intended"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HALNDMOR  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HALLSEFX  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HALCUTDN  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HALCUTEV  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HALEMOPB  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HALEMCTD  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HALPHLPB  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HALPHCTD  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HALLSACT  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HALSERPB  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HALPDANG  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HALLAWTR  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HALFMFPB  1 "Yes" 2 "No"
                       83 "DID NOT USE HALLUCINOGENS PST 12 MOS Log assn"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define HALFMCTD  1 "Yes" 2 "No" 91 "NEVER USED HALLUCINOGENS"
                       93 "DID NOT USE HALLUCINOGENS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define INHLOTTM  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INHGTOVR  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define INHLIMIT  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INHKPLMT  1 "Usually kept to the limits set"
                       2 "Often used more than intended"
                       91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define INHNDMOR  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INHLSEFX  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define INHCUTDN  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INHCUTEV  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define INHEMOPB  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INHEMCTD  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define INHPHLPB  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define INHPHCTD  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define INHLSACT  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INHSERPB  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INHPDANG  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INHLAWTR  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INHFMFPB  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define INHFMCTD  1 "Yes" 2 "No" 91 "NEVER USED INHALANTS"
                       93 "DID NOT USE INHALANTS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define ANLLOTTM  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANLGTOVR  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANLLIMIT  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANLKPLMT  1 "Usually kept to the limits set"
                       2 "Often used more than intended"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANLNDMOR  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANLLSEFX  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANLCUTDN  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANLCUTEV  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANLCUT1X  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANLWD3SX  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANLWDSMT  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANLEMOPB  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANLEMCTD  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANLPHLPB  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANLPHCTD  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define ANLLSACT  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANLSERPB  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANLPDANG  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANLLAWTR  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANLFMFPB  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define ANLFMCTD  1 "Yes" 2 "No"
                       81 "NEVER USED PAIN RELIEVERS Logically assigned"
                       91 "NEVER USED PAIN RELIEVERS"
                       93 "DID NOT USE PAIN RELIEVERS PST 12 MOS"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TRNLOTTM  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNGTOVR  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TRNLIMIT  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNKPLMT  1 "Usually kept to the limits set"
                       2 "Often used more than intended"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TRNNDMOR  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNLSEFX  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TRNCUTDN  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNCUTEV  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TRNEMOPB  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNEMCTD  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TRNPHLPB  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TRNPHCTD  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TRNLSACT  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNSERPB  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNPDANG  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNLAWTR  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNFMFPB  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TRNFMCTD  1 "Yes" 2 "No"
                       81 "NEVER USED TRANQUILIZERS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED TRANQUILIZERS"
                       93 "DID NOT USE TRANQUILIZERS PST 12 MOS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define STMLOTTM  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STMGTOVR  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define STMLIMIT  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STMKPLMT  1 "Usually kept to the limits set"
                       2 "Often used more than intended"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define STMNDMOR  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STMLSEFX  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define STMCUTDN  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STMCUTEV  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define STMCUT1X  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define STMFLBLU  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define STMWD2SX  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define STMWDSMT  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define STMEMOPB  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STMEMCTD  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define STMPHLPB  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define STMPHCTD  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define STMLSACT  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STMSERPB  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STMPDANG  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STMLAWTR  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STMFMFPB  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define STMFMCTD  1 "Yes" 2 "No"
                       81 "NEVER USED STIMULANTS Logically assigned"
                       91 "NEVER USED STIMULANTS"
                       93 "DID NOT USE STIMULANTS PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define SEDLOTTM  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SEDGTOVR  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SEDLIMIT  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SEDKPLMT  1 "Usually kept to the limits set"
                       2 "Often used more than intended"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SEDNDMOR  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SEDLSEFX  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SEDCUTDN  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SEDCUTEV  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define SEDCUT1X  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define SEDWD1SX  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define SEDWDSMT  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define SEDEMOPB  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SEDEMCTD  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define SEDPHLPB  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SEDPHCTD  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define SEDLSACT  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SEDSERPB  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define SEDPDANG  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define SEDLAWTR  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SEDFMFPB  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define SEDFMCTD  1 "Yes" 2 "No"
                       81 "NEVER USED SEDATIVES Logically assigned"
                       91 "NEVER USED SEDATIVES"
                       93 "DID NOT USE SEDATIVES PST 12 MOS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define DEPNDALC  0 "No / Unknown (Otherwise)"
                       1 "Yes (See comment above)" ;
label define DEPNDANL  0 "No / Unknown (Otherwise)"
                       1 "Yes (See comment above)" ;
label define DEPNDCIG  0 "No / Unknown (Otherwise)"
                       1 "Yes (See comment above)" ;
label define DEPNDCOC  0 "No / Unknown (Otherwise)"
                       1 "Yes (See comment above)" ;
label define DEPNDHAL  0 "No / Unknown (Otherwise)"
                       1 "Yes (See comment above)" ;
label define DEPNDHER  0 "No / Unknown (Otherwise)"
                       1 "Yes (See comment above)" ;
label define DEPNDINH  0 "No / Unknown (Otherwise)"
                       1 "Yes (See comment above)" ;
label define DEPNDMRJ  0 "No / Unknown (Otherwise)"
                       1 "Yes (See comment above)" ;
label define DEPNDSED  0 "No / Unknown (Otherwise)"
                       1 "Yes (See comment above)" ;
label define DEPNDSTM  0 "No / Unknown (Otherwise)"
                       1 "Yes (See comment above)" ;
label define DEPNDTRN  0 "No / Unknown (Otherwise)"
                       1 "Yes (See comment above)" ;
label define DEPNDILL  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any source variable listed above=1)" ;
label define DEPNDIEM  0 "No / Unknown (Otherwise)"
                       1 "Yes (any of the source variables=1)" ;
label define DEPNDXMJ  0 "No / Unknown (Otherwise)"
                       1 "Yes (DEPNDMRJ=0 and any other source var=1)" ;
label define DEPNDPSY  0 "No / Unknown (Otherwise)"
                       1 "Yes (DEPNDTRN, DEPNDANL, DEPNDSTM, OR DEPNDSED=1)" ;
label define DPILLALC  0 "No / Unknown (DEPNDILL=0 and DEPNDALC=0)"
                       1 "Yes (DEPNDILL=1 or DEPNDALC=1)" ;
label define DPILANAL  0 "No / Unknown (DEPNDILL=0 or DEPNDALC=0)"
                       1 "Yes (DEPNDILL=1 and DEPNDALC=1)" ;
label define ABUSEALC  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any one of above criteria and DEPNDALC=0)" ;
label define ABUSEANL  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any one of above criteria and DEPNDANL=0)" ;
label define ABUSECOC  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any one of above criteria and DEPNDCOC=0)" ;
label define ABUSEHAL  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any one of above criteria and DEPNDHAL=0)" ;
label define ABUSEHER  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any one of above criteria and DEPNDHER=0)" ;
label define ABUSEINH  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any one of above criteria and DEPNDINH=0)" ;
label define ABUSEMRJ  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any one of above criteria and DEPNDMRJ=0)" ;
label define ABUSESED  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any one of above criteria and DEPNDSED=0)" ;
label define ABUSESTM  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any one of above criteria and DEPNDSTM=0)" ;
label define ABUSETRN  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any one of above criteria and DEPNDTRN=0)" ;
label define ABUSEILL  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any source variable above =1 & DEPNDILL=0)" ;
label define ABUSEIEM  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any above source var=1 & DEPNDIEM=0)" ;
label define ABUSEXMJ  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any above var=1 & ABUSEMRJ=0 & DEPNDXMJ=0)" ;
label define ABUSEPSY  0 "No / Unknown (Otherwise)"
                       1 "Yes (Any source variable above & DEPNDPSY=0)" ;
label define ABILLALC  0 "No / Unknown (ABUSEILL=0 AND ABUSEALC=0)"
                       1 "Yes (ABUSEILL=1 or ABUSEALC=1)" ;
label define ABILANAL  0 "No / Unknown (Otherwise)"
                       1 "Yes (ABUSEILL=1 & ABUSEALC=1 & DPILLALC=0)" ;
label define ABODALC   0 "No / Unknown (ABUSEALC=0 and DEPNDALC=0)"
                       1 "Yes (ABUSEALC=1 or DEPNDALC=1)" ;
label define ABODANL   0 "No / Unknown (ABUSEANL=0 and DEPNDANL=0)"
                       1 "Yes (ABUSEANL=1 or DEPNDANL=1)" ;
label define ABODCOC   0 "No / Unknown (ABUSECOC=0 and DEPNDCOC=0)"
                       1 "Yes (ABUSECOC=1 or DEPNDCOC=1)" ;
label define ABODHAL   0 "No / Unknown (ABUSEHAL=0 and DEPNDHAL=0)"
                       1 "Yes (ABUSEHAL=1 or DEPNDHAL=1)" ;
label define ABODHER   0 "No / Unknown (ABUSEHER=0 and DEPNDHER=0)"
                       1 "Yes (ABUSEHER=1 or DEPNDHER=1)" ;
label define ABODINH   0 "No / Unknown (ABUSEINH=0 and DEPNDINH=0)"
                       1 "Yes (ABUSEINH=1 or DEPNDINH=1)" ;
label define ABODMRJ   0 "No / Unknown (ABUSEMRJ=0 and DEPNDMRJ=0)"
                       1 "Yes (ABUSEMRJ=1 or DEPNDMRJ=1)" ;
label define ABODSED   0 "No / Unknown (ABUSESED=0 and DEPNDSED=0)"
                       1 "Yes (ABUSESED=1 or DEPNDSED=1)" ;
label define ABODSTM   0 "No / Unknown (ABUSESTM=0 and DEPNDSTM=0)"
                       1 "Yes (ABUSESTM=1 or DEPNDSTM=1)" ;
label define ABODTRN   0 "No / Unknown (ABUSETRN=0 and DEPNDTRN=0)"
                       1 "Yes (ABUSETRN=1 or DEPNDTRN=1)" ;
label define ABODILL   0 "No / Unknown (ABUSEILL=0 and DEPNDILL=0)"
                       1 "Yes (ABUSEILL=1 or DEPNDILL=1)" ;
label define ABODPSY   0 "No / Unknown (ABUSEPSY=0 and DEPNDPSY=0)"
                       1 "Yes (ABUSEPSY=1 or DEPNDPSY=1)" ;
label define ABODILAL  0 "No / Unknown (ABILLALC=0 and DPILLALC=0)"
                       1 "Yes (ABILLALC=1 or DPILLALC=1)" ;
label define ABDILAAL  0 "No / Unknown (ABODILL=0 or ABODALC=0)"
                       1 "Yes (ABODILL=1 and ABODALC=1)" ;
label define BOOKED    1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define NOBOOKY2  0 "None" 1 "One time" 2 "Two times"
                       3 "Three or more times"
                       985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP (BOOKED=2)" ;
label define BKMVTHFT  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define BKLARCNY  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define BKBURGL   1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKAGASLT  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKSMASLT  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKROB     1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKRAPE    1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKMURDER  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKARSON   1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKDRVINF  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKDRUNK   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKPOSTOB  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKDRUG    1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKPROS    1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKSEXOFF  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKFRAUD   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKOTH     1 "Yes" 2 "No" 5 "Offense unknown"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define BKOTHOF2  1 "Larceny or theft"
                       2 "Burglary or breaking and entering"
                       4 "Other assault, such as simple assault or battery"
                       5 "Motor vehicle theft" 6 "Robbery"
                       10 "Driving under the influence"
                       11 "Drunkenness or other liquor law violation"
                       13 "Prostitution or commercialized sex"
                       14 "Oth proprty offns: fraud, poss stln goods, vndlsm"
                       15 "Other offense, not categorized elsewhere"
                       16 "Weapons law violations"
                       17 "Counterfeiting/Forgery"
                       18 "Violation of court order, parole, probation"
                       19 "Disorderly conduct" 20 "Juvenile status offenses"
                       21 "All oth offns: crimes agnst persons/prprty/society"
                       22 "Traffic violations" 23 "Bad checks"
                       24 "Curfew/loitering/vagrancy violations"
                       25 "Trespass of real property" 26 "Runaway"
                       27 "Family offenses, nonviolent" 28 "Intimidation"
                       29 "Non-forcible sex offenses"
                       31 "Tobacco law/code violation"
                       38 "Evading/hindering/obstructing police"
                       39 "False report/statement/alarm"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define PROBATON  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define PAROLREL  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define DRVALDR   1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define DRVAONLY  1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define DRVDONLY  1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define DRIVALC   1 "Yes (DRVALDR=1 OR DRVAONLY=1)"
                       2 "No (DRVALDR=2 AND DRVAONLY=2)"
                       3 "Unknown (OTHERWISE)"
                       4 "Never/No Use (DRVALDR AND DRVAONLY=81,89,91,99)" ;
label define DRIVDRG   1 "Yes (DRVALDR=1 OR DRVDONLY=1)"
                       2 "No (DRVALDR=2 AND DRVDONLY=2)"
                       3 "Unknown (OTHERWISE)"
                       4 "Never/No Use (DRVALDR AND DRVDONLY=81,89,91,99)" ;
label define DRIVALD   1 "Yes (DRIVALC=1 OR DRIVDRG=1)"
                       2 "No (DRIVALC=2 AND DRIVDRG=2)"
                       3 "Unknown (OTHERWISE)"
                       4 "Never/No Use (DRIVALC AND DRIVDRG=4)" ;
label define PAROL     -9 "Unknown Status (PAROLREL=85,94,97,98)"
                       1 "On Parole/Supervised Release (PAROLREL=1)"
                       2 "Not on Parole/Supervised Release (PAROLREL=2)" ;
label define PROB      -9 "Unknown Probation Status (PROBATON=85,94,97,98)"
                       1 "On Probation (PROBATON=1)"
                       2 "Not on Probation (PROBATON=2)" ;
label define TXEVER    1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TXYREVER  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2)" ;
label define TXYRADG   1 "Alcohol use only" 2 "Drug use only"
                       3 "Both alcohol and drug use"
                       4 "Alcohol (drug trmt unknown) LOGICALLY ASSIGNED"
                       6 "Both alcohol and drug use LOGICALLY ASSIGNED"
                       11 "Alcohol only (but last tmt for drugs reported)"
                       12 "Drugs only (but last tmt for alc reported)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXYRHOSP  1 "Yes" 2 "No"
                       5 "Yes LOGICALLY ASSIGNED (from TXLTYMN2)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXYRHPAD  1 "Alcohol use" 2 "Drug use"
                       3 "Both alcohol and drug use"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRRFIN  1 "Yes" 2 "No"
                       5 "Yes LOGICALLY ASSIGNED (from TXLTYMN2)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXYRINAD  1 "Alcohol use" 2 "Drug use"
                       3 "Both alcohol and drug use"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRRFOP  1 "Yes" 2 "No"
                       5 "Yes LOGICALLY ASSIGNED (from TXLTYMN2)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXYRPOAD  1 "Alcohol use" 2 "Drug use"
                       3 "Both alcohol and drug use"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRMHC   1 "Yes" 2 "No"
                       5 "Yes LOGICALLY ASSIGNED (from TXLTYMN2)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXYRMHAD  1 "Alcohol use" 2 "Drug use"
                       3 "Both alcohol and drug use"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRTXER  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       5 "Yes LOGICALLY ASSIGNED (from TXLTYMN2)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRERAD  1 "Alcohol use" 2 "Drug use"
                       3 "Both alcohol and drug use"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRDOC   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       5 "Yes LOGICALLY ASSIGNED (from TXLTYMN2)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXYRDCAD  1 "Alcohol use" 2 "Drug use"
                       3 "Both alcohol and drug use"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRJAIL  1 "Yes" 2 "No"
                       5 "Yes LOGICALLY ASSIGNED (from TXLTYMN2)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRJLAD  1 "Alcohol use" 2 "Drug use"
                       3 "Both alcohol and drug use"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRSHG   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       5 "Yes LOGICALLY ASSIGNED (from TXLTYMN2)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRSGAD  1 "Alcohol use" 2 "Drug use"
                       3 "Both alcohol and drug use"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRSOP   1 "Yes" 2 "No"
                       5 "Yes LOGICALLY ASSIGNED (from TXLTYMN2)"
                       7 "Treatment location unknown, LOG ASSN"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXYROTS2  9 "Some other place, not categorized elsewhere"
                       23 "Drug or alcohol rehab facility as outpatient"
                       26 "Private doctor's office" 27 "Prison or jail"
                       28 "Self-help group" 40 "Home, family, friends"
                       41 "School, college"
                       42 "Church/religious/spiritual influence"
                       44 "Halfway house/group home"
                       47 "Community/city/county/state program, unspecified"
                       48 "Counselor, therapist, psychologist"
                       49 "Court-mandated/sponsored program"
                       51 "Alcohol/drug class, location unspecified"
                       52 "Military/VA Hospital"
                       53 "Hospital, patient status unspecified"
                       55 "Youth-oriented facility/organization/program"
                       56 "Mental health centerfacility, ptnt status unspcfd"
                       63 "Medical clinic" 64 "Methadone clinic/program"
                       65 "Name of facility/program given"
                       981 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED ALCOHOL OR DRUGS" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define TXYROTAD  1 "Alcohol use" 2 "Drug use"
                       3 "Both alcohol and drug use"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRVSER  1 "Yes" 2 "No" 6 "NEVER USED RELEVANT DRUGS"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXYRNME2  31 "31 or more"
                       981 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED ALCOHOL OR DRUGS" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define TXRCVNOW  1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTXNEDR  1 "Yes" 2 "No" 11 "Yes (TXYREVER=3)"
                       12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define NDTXMORE  1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMRALC  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMRMJ   1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMRCOC  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMRHER  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMRHAL  6 "Response not entered"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMRINH  6 "Response not entered"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMRANL  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMRTRN  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMRSTM  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMRSED  6 "Response not entered"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMROTH  1 "Response entered" 6 "Response not entered"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTXALCR  1 "Yes" 2 "No" 11 "Yes (TXYREVER=3)"
                       12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define NDTXMJR   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       11 "Yes (TXYREVER=3)" 12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTXCOCR  1 "Yes" 2 "No" 11 "Yes (TXYREVER=3)"
                       12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTXHERR  1 "Yes" 2 "No" 11 "Yes (TXYREVER=3)"
                       12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define NDTXHALR  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       11 "Yes (TXYREVER=3)" 12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define NDTXINHR  1 "Yes" 2 "No" 11 "Yes (TXYREVER=3)"
                       12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define NDTXANLR  1 "Yes" 2 "No" 11 "Yes (TXYREVER=3)"
                       12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTXTRNR  1 "Yes" 2 "No" 11 "Yes (TXYREVER=3)"
                       12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTXSTMR  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       11 "Yes (TXYREVER=3)" 12 "No (TXYREVER=3)"
                       13 "Yes LOGICALLY ASSIGNED (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTXSEDR  1 "Yes" 2 "No" 11 "Yes (TXYREVER=3)"
                       12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define NDTXSODR  1 "Yes" 2 "No" 5 "Drug Unknown LOGICALLY ASSIGNED"
                       11 "Yes (TXYREVER=3)" 12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTXDG1R  103 "Amytal"
                       322 "Methamphetamine ('ice' or 'crank'), Meth"
                       355 "Crystal meth" 658 "Special K, Ketamine"
                       702 "Heroin"
                       803 "Marijuana, MarrJane, Mary Jane, MJ, pot, weed"
                       805 "Cocaine, coca, cocaina, coke"
                       807 "Alcohol, beer, ethanol, EtOH, pink champagne"
                       900 "Not a drug"
                       9981 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       9985 "BAD DATA Logically assigned"
                       9991 "NEVER USED ALCOHOL OR DRUGS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define NDTXDG2R  803 "Marijuana, MarrJane, Mary Jane, MJ, pot, weed"
                       806 "Crack, rock"
                       807 "Alcohol, beer, ethanol, EtOH, pink champagne"
                       9981 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       9991 "NEVER USED ALCOHOL OR DRUGS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define NDTXDG3R  703 "Opium"
                       807 "Alcohol, beer, ethanol, EtOH, pink champagne"
                       6096 "Bananadine"
                       9981 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       9991 "NEVER USED ALCOHOL OR DRUGS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define NDTXDG4R  604 "Psilocybin (mushrooms), shrooms" 804 "Hashish"
                       9981 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       9991 "NEVER USED ALCOHOL OR DRUGS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define NDTXDG5R  601 "LSD ('acid')"
                       9981 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       9991 "NEVER USED ALCOHOL OR DRUGS" 9997 "REFUSED"
                       9998 "BLANK (NO ANSWER)" 9999 "LEGITIMATE SKIP" ;
label define NDTXEFTR  1 "Yes" 2 "No" 11 "Yes (TXYREVER=3)"
                       12 "No (TXYREVER=3)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NDTMREFT  1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXLASREC  1 "Within the past 30 days -- since 30 day ref date"
                       2 "More than 30 days ago but within the past 12 mos"
                       3 "More than 12 months ago"
                       7 "Still in treatment LOG ASSN (TXRCVNOW=1)"
                       8 "Treatment in past year LOGICALLY ASSIGNED"
                       9 "Treatment in lifetime LOGICALLY ASSIGNED"
                       13 "Treatment > 12 mos ago LOG ASSN (TXYREVER=2)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXLTYMN2  1 "A hospital overnight as an inpatient"
                       2 "A res drug/alcohol rehab facility overnight"
                       3 "A drug or alcohol rehab facility as an outpatient"
                       4 "A mental health center or facility as outpatient"
                       5 "An emergency room" 6 "A private doctor's office"
                       7 "A prison or jail" 8 "A self-help group"
                       9 "Some other place" 40 "Home, family, friends"
                       41 "School, college"
                       42 "Church/religious/spiritual influence"
                       47 "Community/city/county/state program, unspecified"
                       48 "Counselor, therapist, psychologist"
                       49 "Court-mandated/sponsored program"
                       51 "Alcohol/drug class, location unspecified"
                       52 "Military/VA Hospital"
                       55 "Youth-oriented facility/organization/program"
                       64 "Methadone clinic/program"
                       65 "Name of facility/program given"
                       981 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       985 "BAD DATA Logically assigned"
                       991 "NEVER USED ALCOHOL OR DRUGS" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define TXLTYALC  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       5 "Yes LOG ASSN (TXYRADG = 1)"
                       6 "NEVER USED ALCOHOL (TXEVER = 1)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)" ;
label define TXLTYMJ   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       6 "NEVER USED MARIJUANA (TXEVER = 1)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)" ;
label define TXLTYCOC  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       6 "NEVER USED COCAINE (TXEVER = 1)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)" ;
label define TXLTYHER  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       6 "NEVER USED HEROIN (TXEVER = 1)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)" ;
label define TXLTYHAL  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       6 "NEVER USED HALLUCINOGENS (TXEVER = 1)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)" ;
label define TXLTYINH  1 "Yes" 2 "No" 6 "NEVER USED INHALANTS (TXEVER = 1)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)" ;
label define TXLTYANL  1 "Yes" 2 "No"
                       6 "NEVER USED PAIN RELIEVERS (TXEVER = 1)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)" ;
label define TXLTYTRN  1 "Yes" 2 "No"
                       6 "NEVER USED TRANQUILIZERS (TXEVER = 1)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)" ;
label define TXLTYSTM  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       6 "NEVER USED STIMULANTS (TXEVER = 1)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)" ;
label define TXLTYSED  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       6 "NEVER USED SEDATIVES (TXEVER = 1)"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)" ;
label define TXLTYSOD  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       5 "Treatment drug unknown, LOGICALLY ASSIGNED"
                       7 "Treatment drug/alc unknown LOG ASSN"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXLTYOU2  1 "You are still in treatment"
                       2 "You successfully completed treatment"
                       3 "You left because you had a problem with program"
                       4 "You left b/c you couldn't afford to continue"
                       5 "You left because your family needed you"
                       6 "You left because you began using drugs again"
                       7 "Your last treatment had some other outcome"
                       41 "You left because you didn't need/want treatment"
                       48 "Discontinued treatment, success unknown"
                       49 "Completed treatment, outcome unknown"
                       50 "You had other problems to deal with"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXLTYDU2  31 "31 or more"
                       99981 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       99985 "BAD DATA Logically assigned"
                       99991 "NEVER USED ALCOHOL OR DRUGS" 99994 "DON'T KNOW"
                       99997 "REFUSED" 99998 "BLANK (NO ANSWER)"
                       99999 "LEGITIMATE SKIP" ;
label define TXPYINS   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXPYCARE  1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXPYCAID  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXPYPUBP  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXPYSAVE  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXPYFMLY  1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXPYCORT  1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXPYMILC  1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXPYEMPL  1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXPYSOS   1 "Yes" 2 "No" 4 "No LOG ASSN (free trmt specified)"
                       5 "Yes, payment source not specified LOG ASSN"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXPYSP2   1 "Private health insurance" 3 "Medicaid"
                       4 "Public assistance program other than Medicaid"
                       5 "Own savings or earnings" 6 "Family members"
                       7 "Courts" 10 "Free" 11 "Some other source"
                       12 "Friend/sponsor" 14 "School"
                       19 "Public assistance, unspecified"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define TXPYFRE   1 "Yes" 2 "No" 3 "Yes LOGICALLY ASSIGNED"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TXENROLL  1 "Yes" 2 "No"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (TXEVER=2)" ;
label define TXYRDTXO  1 "Yes" 2 "No" 4 "No LOGICALLY ASSIGNED"
                       81 "NEVER USED ALCOHOL OR DRUGS Logically assigned"
                       91 "NEVER USED ALCOHOL OR DRUGS" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SPECTILL  0 "No/Unknown (Otherwise)" 1 "Yes (See comment above)" ;
label define SPECTALC  0 "No/Unknown (Otherwise)" 1 "Yes (See comment above)" ;
label define SPILLALC  0 "No/Unknown (Otherwise)" 1 "Yes (See comment above)" ;
label define ILLNEED   0 "No/Unknown (Otherwise)" 1 "Yes (See comment above)" ;
label define TXNOSPEC  0 "No/Unknown (Otherwise)"
                       1 "Yes (ILLNEED=1 and SPECTILL=0)" ;
label define ALCTRMT   0 "No/Unknown (TXYRADG=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXYRADG=1,3,4,6,11,12)" ;
label define ILLTRMT   0 "No/Unknown (TXYRADG=1,4,81,85,91,94,97,98,99)"
                       1 "Yes (TXYRADG=2,3,6,11,12)" ;
label define TXILLALC  0 "No/Unknown (TXYREVER=2,4,81,85,91,94,97,98,99)"
                       1 "Yes (TXYREVER=1,3)" ;
label define TXILANAL  0 "No/Unknown (TXYRADG=1,2,4,81,85,91,94,97,98,99)"
                       1 "Yes (TXYRADG=3,6,11,12)" ;
label define TXLTALC2  0 "No/Unknown (TXLTYALC=2,6,81,85,91,94,97,98,99)"
                       1 "Yes (TXLTYALC=1,3,5)" ;
label define TXLTANL2  0 "No/Unknown (TXLTYANL=2,6,81,85,91,94,97,98,99)"
                       1 "Yes (TXLTYANL=1)" ;
label define TXLTCOC2  0 "No/Unknown (TXLTYCOC=2,6,81,91,94,97,98,99)"
                       1 "Yes (TXLTYCOC=1,3)" ;
label define TXLTHAL2  0 "No/Unknown (TXLTYHAL=2,6,81,91,94,97,98,99)"
                       1 "Yes (TXLTYHAL=1,3)" ;
label define TXLTHER2  0 "No/Unknown (TXLTYHER=2,6,81,91,97,98,99)"
                       1 "Yes (TXLTYHER=1,3)" ;
label define TXLTINH2  0 "No/Unknown (TXLTYINH=2,6,81,91,94,97,98,99)"
                       1 "Yes (TXLTYINH=1)" ;
label define TXLTMJ2   0 "No/Unknown (TXLTYMJ=2,6,81,91,94,97,98,99)"
                       1 "Yes (TXLTYMJ=1,3)" ;
label define TXLTSED2  0 "No/Unknown (TXLTYSED=2,6,81,91,94,97,98,99)"
                       1 "Yes (TXLTYSED=1,3)" ;
label define TXLTSTM2  0 "No/Unknown (TXLTYSTM=2,6,81,91,94,97,98,99)"
                       1 "Yes (TXLTYSTM=1,3)" ;
label define TXLTTRN2  0 "No/Unknown (TXLTYTRN=2,6,81,91,94,97,98,99)"
                       1 "Yes (TXLTYTRN=1)" ;
label define TXLTILL2  0 "No/Unknown (Otherwise)"
                       1 "Yes (ANY SOURCE VARIABLE=1)" ;
label define TXPINS2   0 "No/Unknown (TXPYINS=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXPYINS=1,3)" ;
label define TXPCARE2  0 "No/Unknown (TXPYCARE=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXPYCARE=1)" ;
label define TXPCAID2  0 "No/Unknown (TXPYCAID=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXPYCAID=1,3)" ;
label define TXPPUBP2  0 "No/Unknown (TXPYPUBP=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXPYPUBP=1,3)" ;
label define TXPSAVE2  0 "No/Unknown (TXPYSAVE=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXPYSAVE=1,3)" ;
label define TXPFMLY2  0 "No/Unknown (TXPYFMLY=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXPYFMLY=1,3)" ;
label define TXPCORT2  0 "No/Unknown (TXPYCORT=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXPYCORT=1,3)" ;
label define TXPMILC2  0 "No/Unknown (TXPYMILC=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXPYMILC=1)" ;
label define TXPEMPL2  0 "No/Unknown (TXPYEMPL=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXPYEMPL=1)" ;
label define ILLPINS   0 "No/Unknown (TXLTILL2=0 OR TXPINS2=0)"
                       1 "Yes (TXLTILL2=1 AND TXPINS2=1)" ;
label define ILLPCARE  0 "No/Unknown (TXLTILL2=0 OR TXPCARE2=0)"
                       1 "Yes (TXLTILL2=1 AND TXPCARE2=1)" ;
label define ILLPCAID  0 "No/Unknown (TXLTILL2=0 OR TXPCAID2=0)"
                       1 "Yes (TXLTILL2=1 AND TXPCAID2=0)" ;
label define ILLPPUBP  0 "No/Unknown (TXLTILL2=0 OR TXPPUBP2=0)"
                       1 "Yes (TXLTILL2=1 AND TXPPUBP2=1)" ;
label define ILLPSAVE  0 "No/Unknown (TXLTILL2=0 OR TXPSAVE2=0)"
                       1 "Yes (TXLTILL2=1 AND TXPSAVE2=1)" ;
label define ILLPFMLY  0 "No/Unknown (TXLTILL2=0 OR TXPFMLY2=0)"
                       1 "Yes (TXLTILL2=1 AND TXPFMLY2=1)" ;
label define ILLPCORT  0 "No/Unknown (TXLTILL2=0 OR TXPCORT2=0)"
                       1 "Yes (TXLTILL2=1 AND TXPCORT2=1)" ;
label define ILLPMILC  0 "No/Unknown (TXLTILL2=0 OR TXPMILC2=0)"
                       1 "Yes (TXLTILL2=1 AND TXPMILC2=1)" ;
label define ILLPEMPL  0 "No/Unknown (TXLTILL2=0 OR TXPEMPL2=0)"
                       1 "Yes (TXLTILL2=1 AND TXPEMPL2=1)" ;
label define ALCPINS   0 "No/Unknown (TXLTALC2=0 OR TXPINS2=0)"
                       1 "Yes (TXLTALC2=1 AND TXPINS2=1)" ;
label define ALCPCARE  0 "No/Unknown (TXLTALC2=0 OR TXPCARE2=0)"
                       1 "Yes (TXLTALC2=1 AND TXPCARE2=1)" ;
label define ALCPCAID  0 "No/Unknown (TXLTALC2=0 OR TXPCAID2=0)"
                       1 "Yes (TXLTALC2=1 AND TXPCAID2=1)" ;
label define ALCPPUBP  0 "No/Unknown (TXLTALC2=0 OR TXPPUBP2=0)"
                       1 "Yes (TXLTALC2=1 AND TXPPUBP2=1)" ;
label define ALCPSAVE  0 "No/Unknown (TXLTALC2=0 OR TXPSAVE2=0)"
                       1 "Yes (TXLTALC2=1 AND TXPSAVE2=1)" ;
label define ALCPFMLY  0 "No/Unknown (TXLTALC2=0 OR TXPFMLY2=0)"
                       1 "Yes (TXLTALC2=1 AND TXPFMLY2=1)" ;
label define ALCPCORT  0 "No/Unknown (TXLTALC2=0 OR TXPCORT2=0)"
                       1 "Yes (TXLTALC2=1 AND TXPCORT2=1)" ;
label define ALCPMILC  0 "No/Unknown (TXLTALC2=0 OR TXPMILC2=0)"
                       1 "Yes (TXLTALC2=1 AND TXPMILC2=1)" ;
label define ALCPEMPL  0 "No/Unknown (TXLTALC2=0 OR TXPEMPL2=0)"
                       1 "Yes (TXLTALC2=1 AND TXPEMPL2=1)" ;
label define LOCHOSP   0 "No/Unknown (TXYRHOSP=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXYRHOSP=1,5)" ;
label define LOCRFIN   0 "No/Unknown (TXYRRFIN=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXYRRFIN=1,3,5)" ;
label define LOCRFOP   0 "No/Unknown (TXYRRFOP=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXYRRFOP=1,5)" ;
label define LOCMHC    0 "No/Unknown (TXYRMHC=2,81,85,91,94,97,98,99)"
                       1 "Yes (TXYRMHC=1,5)" ;
label define LOCTXER   0 "No/Unknown (TXYRTXER=2,81,85,91,97,98,99)"
                       1 "Yes (TXYRTXER=1,3,5)" ;
label define LOCDOC    0 "No/Unknown (TXYRDOC=2,81,85,91,94,97,98,99"
                       1 "Yes (TXYRDOC=1,3,5)" ;
label define LOCJAIL   0 "No/Unknown (TXYRJAIL=2,81,85,91,97,98,99)"
                       1 "Yes (TXYRJAIL=1,5)" ;
label define LOCSHG    0 "No/Unknown (TXYRSHG=2,81,85,91,97,98,99)"
                       1 "Yes (TXYRSHG=1,3,5)" ;
label define DRGHOSP   0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRHOSP=1 AND TXYRHPAD=2,3)" ;
label define DRGRFIN   0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRRFIN=1 AND TXYRINAD=2,3)" ;
label define DRGRFOP   0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRRFOP=1 AND TXYRPOAD=2,3)" ;
label define DRGMHC    0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRMHC=1 AND TXYRMHAD=2,3)" ;
label define DRGTXER   0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRTXER=1 AND TXYRERAD=2,3)" ;
label define DRGDOC    0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRDOC=1 AND TXYRDCAD=2,3)" ;
label define DRGJAIL   0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRJAIL=1 AND TXYRJLAD=2,3)" ;
label define DRGSHG    0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRSHG=1 AND TXYRSGAD=2,3)" ;
label define ALCHOSP   0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRHOSP=1 AND TXYRHPAD=1,3)" ;
label define ALCRFIN   0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRRFIN=1 AND TXYRINAD=1,3)" ;
label define ALCRFOP   0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRRFOP=1 AND TXYRPOAD=1,3)" ;
label define ALCMHC    0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRMHC=1 AND TXYRMHAD=1,3)" ;
label define ALCTXER   0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRTXER=1 AND TXYRERAD=1,3)" ;
label define ALCDOC    0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRDOC=1 AND TXYRDCAD=1,3)" ;
label define ALCJAIL   0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRJAIL=1 AND TXYRJLAD=1,3)" ;
label define ALCSHG    0 "No/Unknown (Otherwise)"
                       1 "Yes (TXYRSHG=1 AND TXYRSGAD=1,3)" ;
label define AUINPYR   1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUINPSYH  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUINPGEN  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUINMEDU  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUINAHSP  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUINRESD  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUINSFAC  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUNMPSY2  31 "31 or more" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define AUNMPGE2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define AUNMMEDU  994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define AUNMAHSP  994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define AUNMRESD  994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define AUNMSFA2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define AUPINSLF  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define AUPINOFM  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPINPHI  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPINMCR  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPINMCD  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPINREH  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPINEMP  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPINMIL  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPINPUB  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPINPRV  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPINFRE  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPINAMT  1 "Less than $100" 2 "$100 to $200" 3 "$201 to $500"
                       4 "$501 to $900" 5 "$901 to $1,500"
                       6 "$1,501 to $2,000" 7 "$2,001 to $5,000"
                       8 "More than $5,000" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define AUOPTYR   1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUOPMENT  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUOPTHER  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUOPDOC   1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUOPCLNC  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUOPDTMT  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUOPOTOP  1 "Response entered" 6 "Response not entered"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUOPYRS2  1 "An outpatient mental health clinic or center"
                       2 "Non-clinic therapist/psychologist/counselor"
                       3 "A doctor's office that was not part of a clinic"
                       4 "An outpatient medical clinic"
                       5 "A partial day hospital or day treatment program"
                       6 "Some other place, not categorized elsewhere"
                       7 "Friend(s)/parent of friend"
                       8 "Family member(s)/home"
                       9 "School or university setting/clinic/center"
                       10 "Church/clergy/religious influence"
                       11 "Support group/self-help group/group counseling"
                       12 "Clinic or center counseling; mental/health unspcfd"
                       13 "Therapist/psychologist/counselor; locale unspecfd"
                       14 "A doctor's office; location unspecified"
                       15 "Work/parents' work/Employee Assistance Program"
                       18 "Military facility/VA"
                       22 "Health professional, not a Dr; non-mental health"
                       24 "Clinic/center, type unspecified"
                       70 "Name of facility/description of facility given"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUNMMEN2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define AUNMTHE2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define AUNMDOC2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define AUNMCLN2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define AUNMDTM2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define AUNMOTO2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define AUPOPSLF  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define AUPOPOFM  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPOPPHI  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPOPMCR  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPOPMCD  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define AUPOPREH  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPOPEMP  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define AUPOPMIL  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPOPPUB  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define AUPOPPRV  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define AUPOPFRE  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define AUPOPMOS  1 "Self or a family member living with you"
                       2 "A family member who does not live with you"
                       3 "Private health insurance" 4 "Medicare" 5 "Medicaid"
                       7 "Employer" 8 "VA or other military program"
                       9 "Other public source" 10 "Other private source"
                       11 "No one paid because the treatment was free"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUPOPAMT  1 "Less than $100" 2 "$100 to $200" 3 "$201 to $500"
                       4 "$501 to $900" 5 "$901 to $1,500"
                       6 "$1,501 to $2,000" 7 "$2,001 to $5,000"
                       8 "More than $5,000" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define AURXYR    1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUUNMTYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AUUNMTRS  1 "Couldn't afford it" 2 "Some other reason"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define AMHINP    1 "Yes (AUINPYR=1)" 2 "No (AUINPYR=2)"
                       3 "Unknown (AUINPYR=85,94,97,98)"
                       4 "Aged 12-17(AUINPYR=89,99)" ;
label define AMHOUTP   1 "Yes (AUOPTYR=1)" 2 "No (AUOPTYR=2)"
                       3 "Unknown (AUOPTYR=85,94,97,98)"
                       4 "Aged 12-17(AUOPTYR=89,99)" ;
label define AMHRX     1 "Yes (AURXYR=1)" 2 "No (AURXYR=2)"
                       3 "Unknown (AURXYR=85,94,97,98)"
                       4 "Aged 12-17(AURXYR=89,99)" ;
label define AMHTXREC  1 "Yes (AMHINP=1 OR AMHOUTP=1 OR AMHRX=1)"
                       2 "No (AMHINP=2 AND AMHOUTP=2 AND AMHRX=2)"
                       3 "Unknown (OTHERWISE)"
                       4 "Aged 12-17 (AMHINP=4 AND AMHOUTP=4 AND AMHRX=4)" ;
label define AMHTRTND  1 "Yes (AUUNMTYR=1)" 2 "No (AUUNMTYR=2)"
                       3 "Unknown (AUUNMTYR=85,94,97,98)"
                       4 "Aged 12-17(AUUNMTYR=89,99)" ;
label define SNCRIME   1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNSELLDG  1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNPPVAL   1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNSTFGT   1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNEMTBLD  1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNPPHLP   1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNGRAFTI  1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNPPVSIT  1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNPPMOVE  1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNMOV5Y2  0 "None" 1 "One time" 2 "Two times" 3 "Three times"
                       4 "Four times" 5 "Five times" 6 "Six or more times"
                       989 "LEGITIMATE SKIP Logically assigned"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define SNSPOUSE  1 "Yes" 2 "No" 89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNSPACTV  1 "0 times" 2 "1 or 2 times" 3 "A few times"
                       4 "Many times" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNSPANGR  1 "0 times" 2 "1 or 2 times" 3 "A few times"
                       4 "Many times" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNSPHITU  1 "0 times" 2 "1 or 2 times" 3 "A few times"
                       4 "Many times" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNYHITSP  1 "0 times" 2 "1 or 2 times" 3 "A few times"
                       4 "Many times" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNSPCRIT  1 "Always" 2 "Sometimes" 3 "Seldom" 4 "Never"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNSPCONC  1 "Always" 2 "Sometimes" 3 "Seldom" 4 "Never"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNFRCONC  1 "None" 2 "One" 3 "2 or 3" 4 "4 to 5" 5 "More than 5"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNFRACTV  1 "None" 2 "One" 3 "2 or 3" 4 "4 to 5" 5 "More than 5"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNFRCARE  1 "None" 2 "One" 3 "2 or 3" 4 "4 to 5" 5 "More than 5"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNYSELL   1 "0 times" 2 "1 or 2 times" 3 "3 to 5 times"
                       4 "6 to 9 times" 5 "10 or more times"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNYSTOLE  1 "0 times" 2 "1 or 2 times" 3 "3 to 5 times"
                       4 "6 to 9 times" 5 "10 or more times"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNYATTAK  1 "0 times" 2 "1 or 2 times" 3 "3 to 5 times"
                       4 "6 to 9 times" 5 "10 or more times"
                       85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNFACIG   1 "Neither approve nor disapprove"
                       2 "Somewhat disapprove" 3 "Strongly disapprove"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNFAMJEV  1 "Neither approve nor disapprove"
                       2 "Somewhat disapprove" 3 "Strongly disapprove"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNFAALDY  1 "Neither approve nor disapprove"
                       2 "Somewhat disapprove" 3 "Strongly disapprove"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SNFAALDV  1 "Neither approve nor disapprove"
                       2 "Somewhat disapprove" 3 "Strongly disapprove"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECRIME   1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YESELLDG  1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPPHLP   1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YESTFGT   1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEEMTBLD  1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPPVSIT  1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEGRAFTI  1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPPMOVE  1 "Strongly Agree" 2 "Somewhat Agree"
                       3 "Somewhat Disagree" 4 "Strongly Disagree"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEMOV5Y2  0 "None" 1 "One time" 2 "Two times" 3 "Three times"
                       4 "Four times" 5 "Five times" 6 "Six or more times"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define YEENRLYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YELSTGRD  1 "An 'A+', 'A' or 'A-minus' average"
                       2 "A 'B+', 'B' or 'B-minus' average"
                       3 "A 'C+', 'C' or 'C-minus' average"
                       4 "A 'D' or less than a 'D' average"
                       5 "My school does not give these grades"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEYFGTSW  1 "0 times" 2 "1 or 2 times" 3 "3 to 5 times"
                       4 "6 to 9 times" 5 "10 or more times"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEYFGTGP  1 "0 times" 2 "1 or 2 times" 3 "3 to 5 times"
                       4 "6 to 9 times" 5 "10 or more times"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEYHGUN   1 "0 times" 2 "1 or 2 times" 3 "3 to 5 times"
                       4 "6 to 9 times" 5 "10 or more times"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEYSELL   1 "0 times" 2 "1 or 2 times" 3 "3 to 5 times"
                       4 "6 to 9 times" 5 "10 or more times"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEYSTOLE  1 "0 times" 2 "1 or 2 times" 3 "3 to 5 times"
                       4 "6 to 9 times" 5 "10 or more times"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEYATTAK  1 "0 times" 2 "1 or 2 times" 3 "3 to 5 times"
                       4 "6 to 9 times" 5 "10 or more times"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPPKCIG  1 "Neither approve nor disapprove"
                       2 "Somewhat disapprove" 3 "Strongly disapprove"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPMJEVR  1 "Neither Approve or Disapprove"
                       2 "Somewhat Disapprove" 3 "Strongly Disapprove"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPALDLY  1 "Neither Approve or Disapprove"
                       2 "Somewhat Disapprove" 3 "Strongly Disapprove"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEGPKCIG  1 "Neither approve nor disapprove"
                       2 "Somewhat disapprove" 3 "Strongly disapprove"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEGMJEVR  1 "Neither approve nor disapprove"
                       2 "Somewhat disapprove" 3 "Strongly disapprove"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEGALDLY  1 "Neither approve nor disapprove"
                       2 "Somewhat disapprove" 3 "Strongly disapprove"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YETLKNON  1 "Response entered" 6 "Response not entered"
                       11 "Response entered (& other responses entered)"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YETLKPAR  1 "Response entered" 6 "Response not entered"
                       11 "Response entered (YETLKNON=11)" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YETLKSOP  1 "Response entered" 6 "Response not entered"
                       11 "Response entered (YETLKNON=11)" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPRTDNG  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEBIGBRO  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPRBSLV  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEVIOPRV  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEYMCA    1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YESCOUTS  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPRVLES  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEDGPRGP  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YETEMSPT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YE4HCLUB  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YESLFHLP  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEBAND    1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YESCHCLB  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEVOLUNT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YESTGOVT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPRGSTD  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEJBSKIL  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECHOIR   1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEDECLAS  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEDERGLR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEDESPCL  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPVNTYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGFRND  1 "0 times" 2 "1 time" 3 "2 times" 4 "3 to 5 times"
                       5 "6 to 9 times" 6 "10 or more times"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGVEND  1 "0 times" 2 "1 time" 3 "2 times" 4 "3 to 5 times"
                       5 "6 to 9 times" 6 "10 or more times"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGMAI2  1 "0 times" 2 "1 time" 3 "2 times" 4 "3 to 5 times"
                       5 "6 or more times" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGCHKO  1 "0 times" 2 "1 time" 3 "2 times" 4 "3 to 5 times"
                       5 "6 to 9 times" 6 "10 or more times"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGCLRK  1 "0 times" 2 "1 time" 3 "2 times" 4 "3 to 5 times"
                       5 "6 to 9 times" 6 "10 or more times"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGINET  1 "0 times" 2 "1 time" 3 "2 times" 4 "3 to 5 times"
                       6 "10 or more times" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGSMKT  1 "0 times" 2 "1 time" 3 "2 times" 4 "3 to 5 times"
                       5 "6 to 9 times" 6 "10 or more times"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGDSTO  1 "0 times" 2 "1 time" 3 "2 times" 4 "3 to 5 times"
                       5 "6 to 9 times" 6 "10 or more times"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGCONV  1 "0 times" 2 "1 time" 3 "2 times" 4 "3 to 5 times"
                       5 "6 to 9 times" 6 "10 or more times"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGINDV  1 "0 times" 2 "1 time" 3 "2 times" 4 "3 to 5 times"
                       5 "6 to 9 times" 6 "10 or more times"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGPRUF  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGSUCC  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPKCRTN  1 "Pack" 2 "Carton" 85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPDPACK  1 "Less than $1.00" 2 "$1.00 - $1.50"
                       3 "$1.51 - $2.00" 4 "$2.01 - $2.50" 5 "$2.51 - $3.00"
                       6 "$3.01 - $3.50" 7 "$3.51 - $4.00" 8 "$4.01 - $4.50"
                       9 "$4.51 - $5.00" 10 "More than $5.00"
                       85 "BAD DATA Logically assigned"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEPDCRTN  1 "Less than $10.00" 2 "$10.00 - $10.99"
                       3 "$11.00 - $11.99" 4 "$12.00 - $12.99"
                       5 "$13.00 - $13.99" 6 "$14.00 - $14.99"
                       7 "$15.00 - $15.99" 8 "$16.00 - $16.99"
                       9 "$17.00 - $17.99" 10 "$18.00 - $18.99"
                       11 "$19.00 - $19.99" 15 "$23.00 or more"
                       91 "NEVER USED CIGARETTES"
                       93 "DID NOT USE CIGARETTES IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEBLNTEV  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YEBLNT30  1 "Yes" 2 "No" 11 "Yes (YEBL30FQ=0)"
                       85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YEBL30FQ  94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YECGRWMJ  1 "Yes" 2 "No" 91 "NEVER USED CIGARS"
                       93 "DID NOT USE CIGARS IN THE PAST 30 DAYS"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define NGHCRIM2  -9 "OTHERWISE (YECRIME = 94,97,98,99)"
                       1 "STRONGLY OR SOMEWHAT AGREE (YECRIME = 1,2)"
                       2 "SOMEWHAT OR STRONGLY DISAGREE (YECRIME = 3,4)" ;
label define NGHSELL2  -9 "OTHERWISE (YESLLDG = 94,97,98,99)"
                       1 "STRONGLY OR SOMEWHAT AGREE (YESLLDG = 1,2)"
                       2 "SOMEWHAT OR STRONGLY DISAGREE (YESLLDG = 3,4)" ;
label define NGHHELP2  -9 "OTHERWISE (YEPPHLP = 94,97,98,99)"
                       1 "STRONGLY OR SOMEWHAT AGREE (YEPPHLP = 1,2)"
                       2 "SOMEWHAT OR STRONGLY DISAGREE (YEPPHLP = 3,4)" ;
label define NGHFGHT2  -9 "OTHERWISE (YESTFGT = 94,97,98,99)"
                       1 "STRONGLY OR SOMEWHAT AGREE (YESTFGT = 1,2)"
                       2 "SOMEWHAT OR STRONGLY DISAGREE (YESTFGT = 3,4)" ;
label define NGHBLDG2  -9 "OTHERWISE (YEEMTBLD = 94,97,98,99)"
                       1 "STRONGLY OR SOMEWHAT AGREE (YEEMTBLD = 1,2)"
                       2 "SOMEWHAT OR STRONGLY DISAGREE (YEEMTBLD = 3,4)" ;
label define NGHVSIT2  -9 "OTHERWISE (YEPPVSIT = 94,97,98,99)"
                       1 "STRONGLY OR SOMEWHAT AGREE (YEPPVSIT = 1,2)"
                       2 "SOMEWHAT OR STRONGLY DISAGREE (YEPPVSIT = 3,4)" ;
label define NGHGRAF2  -9 "OTHERWISE (YEGRAFTI = 94,97,98,99)"
                       1 "STRONGLY OR SOMEWHAT AGREE (YEGRAFTI = 1,2)"
                       2 "SOMEWHAT OR STRONGLY DISAGREE (YEGRAFTI = 3,4)" ;
label define NGHMOVE2  -9 "OTHERWISE (YEPPMOVE = 94,97,98,99)"
                       1 "STRONGLY OR SOMEWHAT AGREE (YEPPMOVE = 1,2)"
                       2 "SOMEWHAT OR STRONGLY DISAGREE (YEPPMOVE = 3,4)" ;
label define MVIN5YR2  -9 "OTHERWISE (YEMOV5Y2 = 994,997,998,999)"
                       1 "MORE THAN 1 TIME (YEMOV5Y2 = 2-6)"
                       2 "NONE OR ONE TIME (YEMOV5Y2 = 0,1 )" ;
label define PRPKCIG2  -9 "OTHERWISE (YEPPKCIG = 94,97,98,99)"
                       1 "STRONGLY DISAPPROVE (YEPPKCIG = 3)"
                       2 "SOMEWHAT DISAPPROVE OR NEITHER (YEPPKCIG = 1,2)" ;
label define PRMJEVR2  -9 "OTHERWISE (YEPMJEVR = 94,97,98,99)"
                       1 "STRONGLY DISAPPROVE (YEPMJEVR = 3)"
                       2 "SOMEWHAT DISAPPROVE OR NEITHER (YEPMJEVR = 1,2)" ;
label define PRALDLY2  -9 "OTHERWISE (YEPALDLY = 94,97,98,99)"
                       1 "STRONGLY DISAPPROVE (YEPALDLY = 3)"
                       2 "SOMEWHAT DISAPPROVE OR NEITHER (YEPALDLY = 1,2)" ;
label define PRTALK3   -9 "OTHERWISE (YEPRTDNG = 85,94,97,98,99)"
                       1 "YES (YEPRTDNG = 1)" 2 "NO (YEPRTDNG = 2)" ;
label define YOFIGHT2  -9 "OTHERWISE (YEYFGTSW = 85,94,97,98,99)"
                       1 "ONE OR MORE TIMES (YEYFGTSW = 2,3,4,5)"
                       2 "NONE (YEYFGTSW = 1)" ;
label define YOGRPFT2  -9 "OTHERWISE (YEYFGTGP = 85,94,97,98,99)"
                       1 "ONE OR MORE TIMES (YEYFGTGP = 2,3,4,5)"
                       2 "NONE (YEYFGTGP = 1)" ;
label define YOHGUN2   -9 "OTHERWISE (YEYHGUN = 85,94,97,98,99)"
                       1 "ONE OR MORE TIMES (YEYHGUN = 2,3,4,5)"
                       2 "NONE (YEYHGUN = 1)" ;
label define YOSELL2   -9 "OTHERWISE (YEYSELL = 85,94,97,98,99)"
                       1 "ONE OR MORE TIMES (YEYSELL = 2,3,4,5)"
                       2 "NONE (YEYSELL = 1)" ;
label define YOSTOLE2  -9 "OTHERWISE (YEYSTOLE = 85,94,97,98,99)"
                       1 "ONE OR MORE TIMES (YEYSTOLE = 2,3,4,5)"
                       2 "NONE (YEYSTOLE = 1)" ;
label define YOATTAK2  -9 "OTHERWISE (YEYATTAK = 85,94,97,98,99)"
                       1 "ONE OR MORE TIMES (YEYATTAK = 2,3,4,5)"
                       2 "NONE (YEYATTAK = 1)" ;
label define YFLPKCG2  -9 "OTHERWISE (YEGPKCIG = 94,97,98,99)"
                       1 "SOMEWHAT OR STRONGLY DISAPPROVE (YEGPKCIG = 2,3)"
                       2 "NEITHER APPROVE OR DISAPPROVE (YEGPKCIG = 1)" ;
label define YFLTMRJ2  -9 "OTHERWISE (YEGMJEVR = 94,97,98,99)"
                       1 "SOMEWHAT OR STRONGLY DISAPPROVE (YEGMJEVR = 2,3)"
                       2 "NEITHER APPROVE OR DISAPPROVE (YEGMJEVR = 1)" ;
label define YFLADLY2  -9 "OTHERWISE (YEGALDLY = 94,97,98,99)"
                       1 "SOMEWHAT OR STRONGLY DISAPPROVE (YEGALDLY = 2,3)"
                       2 "NEITHER APPROVE OR DISAPPROVE (YEGALDLY = 1)" ;
label define YOUTHACT  -9 "OTHERWISE" 1 "NONE OR ONE ACTIVITY WAS MARKED"
                       2 "TWO OR MORE ACTIVITIES WERE MARKED" ;
label define PRBSOLV2  -9 "OTHERWISE (YEPRBSLV = 85,94,97,98,99)"
                       1 "YES (YEPRBSLV = 1)" 2 "NO (YEPRBSLV = 2)" ;
label define PREVIOL2  -9 "OTHERWISE (YEVIOPRV = 85,94,97,98,99)"
                       1 "YES (YEVIOPRV = 1)" 2 "NO (YEVIOPRV = 2)" ;
label define PRVDRGO2  -9 "OTHERWISE (YEDGPRGP = 85,94,97,98,99)"
                       1 "YES (YEDGPRGP = 1)" 2 "NO (YEDGPRGP = 2)" ;
label define GRPCNSL2  -9 "OTHERWISE (YESLFHLP = 85,94,97,98,99)"
                       1 "YES (YESLFHLP = 1)" 2 "NO (YESLFHLP = 2)" ;
label define PREGPGM2  -9 "OTHERWISE (YEPRGSTD = 85,94,97,98,99)"
                       1 "YES (YEPRGSTD= 1)" 2 "NO (YEPRGSTD = 2)" ;
label define DGSPCLS2  -9 "OTHERWISE (YEDECLAS = 85,94,97,98,99)"
                       1 "YES (YEDECLAS = 1)" 2 "NO (YEDECLAS = 2)" ;
label define DGRGCLS2  -9 "OTHERWISE (YEDERGLR = 85,94,97,98,99)"
                       1 "YES (YEDERGLR = 1)" 2 "NO (YEDERGLR = 2)" ;
label define DRGLECT2  -9 "OTHERWISE (YEDESPCL = 85,94,97,98,99)"
                       1 "YES (YEDESPCL = 1)" 2 "NO (YEDESPCL = 2)" ;
label define DRPRVME3  -9 "OTHERWISE (YEPVNTYR = 85,94,97,98,99)"
                       1 "YES (YEPVNTYR = 1)" 2 "NO (YEPVNTYR = 2)" ;
label define ANYEDUC3  -9 "OTHERWISE"
                       1 "YES (DGSPCLS2 = 1 OR DGRGCLS2 = 1 OR DRGLECT2 = 1)"
                       2 "NO (DGSPCLS2 = 2 & DGRGCLS2 = 2 & DRGLECT2 = 2)" ;
label define CIGFRND   0 "Otherwise (YECGFRND=1,85,91,93,94,97,98,99)"
                       1 "Yes (YECGFRND=2,3,4,5,6)" ;
label define CIGVEND   0 "Otherwise (YECGVEND=1,85,91,93,94,97,98,99)"
                       1 "Yes (YECGVEND=2,3,4,5,6)" ;
label define CIGMAIL   0 "Otherwise (YECGMAI2=1,85,91,93,94,97,98,99)"
                       1 "At least 1 time (YECGMAI2=2,3,4,5)" ;
label define CIGCKOUT  0 "Otherwise (YECGCHKO=1,85,91,93,94,97,98,99)"
                       1 "Yes (YECGCHKO=2,3,4,5,6)" ;
label define CIGCLERK  0 "Otherwise (YECGCLRK=1,85,91,93,94,97,98,99)"
                       1 "Yes (YECGCLRK=2,3,4,5,6)" ;
label define CIGINET   0 "Otherwise (YECGINET=1,85,91,93,94,97,98,99)"
                       1 "Yes (YECGINET=2,3,4,5,6)" ;
label define CIGSMKT   0 "Otherwise (YECGSMKT=1,85,91,93,94,97,98,99)"
                       1 "Yes (YECGSMKT=2,3,4,5,6)" ;
label define CIGDSTO   0 "Otherwise (YECGDSTO=1,85,91,93,94,97,98,99)"
                       1 "Yes (YECGDSTO=2,3,4,5,6)" ;
label define CIGCONV   0 "Otherwise (YECGCONV=1,85,91,93,94,97,98,99)"
                       1 "Yes (YECGCONV=2,3,4,5,6)" ;
label define CIGINDIV  0 "Otherwise (YECGINDV=1,85,91,93,94,97,98,99)"
                       1 "Yes (YECGINDV=2,3,4,5,6)" ;
label define YTHBGHT   0 "Otherwise" 1 "Yes (ANY SOURCE VARIABLE=1)" ;
label define YMSPGRUP  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMSPFNTP  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMSAHOME  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMSAACHE  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMSABDRM  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMSASLEP  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMSAABDN  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMSAUPLV  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMSAHMSK  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMAGOHSF  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMAGCRWD  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMAGTRAV  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMAGBRDG  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMPAATAK  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMPASUFC  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMGAWORY  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMGAHDAC  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMGAPAIN  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YMGATNSE  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YMPHANML  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMPHHIGH  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMPHDARK  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMPHNEDL  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMPHBLOD  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMPHBRDG  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMPHELEV  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMOCCOUN  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMOCWASH  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMOCCHCK  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMOCGERM  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMOCTHOT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMEATHIN  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMEAFAT   1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMEATHFD  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMEABING  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMELWTBD  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMELWTPT  1 "Yes" 2 "No" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMELSOIL  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YMMDNINT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMMDLSEG  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMMDNOGD  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMMDTHKL  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMMDTYKL  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMMDTIRD  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMMDTHNK  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMMABDMD  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMMARSLS  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMMATALK  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMMASPAB  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMMAMDRC  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMADCONC  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMADFRGT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMADFCUS  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMADMEDS  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMADAVAT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMADERRO  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMODHURT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMODRFUS  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMODANOY  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMODMEAN  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMODBLMO  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMODTANY  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMODSWOR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMCDEXPL  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMCDSHPL  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMCDLIED  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMCDSNAT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMCDVAND  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMCDSTOL  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMCDCRUA  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YMCDBKNT  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUHOSPYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUHOSPN2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define YUHOSUIC  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUHODEPR  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUHOFEAR  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUHOBKRU  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUHOEATP  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUHOSOR   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YURSIDYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YURSIDN2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define YURSSUIC  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YURSDEPR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YURSFEAR  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YURSBKRU  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YURSEATP  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YURSSOR   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUFCARYR  1 "Yes" 2 "No" 4 "No LOGICALLY ASSIGNED"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUFCARN2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define YUFCSUIC  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUFCDEPR  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUFCFEAR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUFCBKRU  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUFCEATP  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUFCSOR   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUDYTXYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUDYTXN2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define YUDYSUIC  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUDYDEPR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUDYFEAR  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUDYBKRU  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUDYEATP  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUDYSOR   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUMHCRYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUMHCRN2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define YUMHSUIC  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUMHDEPR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUMHFEAR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUMHBKRU  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUMHEATP  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUMHSOR   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUTPSTYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUTPSTN2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define YUTPSUIC  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUTPDEPR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUTPFEAR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUTPBKRU  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUTPEATP  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUTPSOR   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUIHTPYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUIHTPN2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define YUIHSUIC  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUIHDEPR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUIHFEAR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUIHBKRU  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUIHEATP  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUIHSOR   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUFDOCYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUFDOCN2  31 "31 or more" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define YUFDSUIC  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUFDDEPR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUFDFEAR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUFDBKRU  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUFDEATP  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUFDSOR   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUSPEDYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUSHCNYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUSHSUIC  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUSHDEPR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUSHFEAR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUSHBKRU  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUSHEATP  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUSHSOR   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define YUJAILEV  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define YUFCAREV  1 "Yes" 2 "No"
                       5 "Yes LOGICALLY ASSIGNED (from skip pattern)"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define IRHHSIZ2  1 "One person in household"
                       2 "Two people in household"
                       3 "Three people in household"
                       4 "Four people in household"
                       5 "Five people in household"
                       6 "6 to 25 people in household" ;
label define IIHHSIZ2  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRHH65_2  1 "No people 65 or older in household"
                       2 "One person 65 or older in household"
                       3 "Two or more people 65 or older in household" ;
label define IIHH65_2  1 "Questionnaire data" 2 "Logically imputed data"
                       3 "Statistically imputed data" ;
label define IRKI17_2  1 "No children under 18" 2 "One child under 18"
                       3 "Two children under 18"
                       4 "Three or more children under 18" ;
label define IIKI17_2  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IMOTHER   1 "R is 12-17, mother in hh"
                       2 "R is 12-17, no mother in hh"
                       3 "R is 12-17, don't know whether mother is in hh"
                       4 "R is 18 or older" ;
label define IFATHER   1 "R is 12-17, father in hh"
                       2 "R is 12-17, no father in hh"
                       3 "R is 12-17, don't know whether father is in hh"
                       4 "R is 18 or older" ;
label define NRCH17_2  -9 "Missing" 3 "3 or more" ;
label define PREGNANT  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define NMERTMT2  31 "31 or more" 985 "BAD DATA Logically assigned"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)" ;
label define INHOSPYR  1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define NMNGTHS2  31 "31 or more" 985 "BAD DATA Logically assigned"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define PROXANS2  1 "Yes" 2 "No" 7 "Unclear LOGICALLY ASSIGNED"
                       89 "LEGITIMATE SKIP Logically assigned" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (Respondent answering)" ;
label define PREG      0 "Otherwise"
                       1 "Pregnant Females Aged 12-44 (PREGNANT=1)" ;
label define PREG2     -9 "Unknown (PREGNANT = 94,97,98)"
                       1 "Pregnant (PREGNANT=1)"
                       2 "Not Pregnant (PREGNANT=2)"
                       3 "Males/Females not age 12-44 (PREGNANT=99)" ;
label define TRIMEST   -9 "Unknown" 1 "1st 3 months of pregnancy"
                       2 "2nd 3 months of pregnancy"
                       3 "Last 3 months of pregnancy"
                       4 "Males/Not Pregnant Females" ;
label define IRPSOC    1 "Yes" 2 "No" ;
label define IIPSOC    1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRFAMSOC  1 "Yes" 2 "No" ;
label define IIFAMSOC  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRPSSI    1 "Yes" 2 "No" ;
label define IIPSSI    1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRFAMSSI  1 "Yes" 2 "No" ;
label define IIFAMSSI  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRFSTAMP  1 "Yes" 2 "No" ;
label define IIFSTAMP  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRPPMT    1 "Yes" 2 "No" ;
label define IIPPMT    1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRFAMPMT  1 "Yes" 2 "No" ;
label define IIFAMPMT  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRPSVC    1 "Yes" 2 "No" ;
label define IIPSVC    1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRFAMSVC  1 "Yes" 2 "No" ;
label define IIFAMSVC  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRWELMOS  99 "LEGITIMATE SKIP" ;
label define IIWELMOS  1 "Questionnaire data" 3 "Statistically imputed data"
                       9 "Legitimate skip" ;
label define IRPINT    1 "Yes" 2 "No" ;
label define IIPINT    1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRFAMINT  1 "Yes" 2 "No" ;
label define IIFAMINT  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRPCHD    1 "Yes" 2 "No" ;
label define IIPCHD    1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRFAMCHD  1 "Yes" 2 "No" ;
label define IIFAMCHD  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRPWAG    1 "Yes" 2 "No" ;
label define IIPWAG    1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRFAMWAG  1 "Yes" 2 "No" ;
label define IIFAMWAG  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRPOTH    1 "Yes" 2 "No" ;
label define IIPOTH    1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRFAMOTH  1 "Yes" 2 "No" ;
label define IIFAMOTH  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRPINC3   1 "$0 - $9,999 (Including Loss)" 2 "$10,000 - $19,999"
                       3 "$20,000 - $29,999" 4 "$30,000 - $39,999"
                       5 "$40,000 - $49,999" 6 "$50,000 - $74,999"
                       7 "$75,000 or more" ;
label define IIPINC3   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRFAMIN3  1 "$0 - $9,999 (Including Loss)" 2 "$10,000 - $19,999"
                       3 "$20,000 - $29,999" 4 "$30,000 - $39,999"
                       5 "$40,000 - $49,999" 6 "$50,000 - $74,999"
                       7 "$75,000 or more" ;
label define IIFAMIN3  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define GOVTPROG  1 "YES (ANY SOURCE VARIABLE=1)"
                       2 "NO (ALL SOURCE VARIABLES=2)" ;
label define HLCALLFG  1 "Answered yes to all current health insurance Qs"
                       98 "BLANK (NO ANSWER)" ;
label define HLCALL99  1 "Yes" 98 "BLANK (NO ANSWER)" ;
label define MEDICARE  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define MEDICAID  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define CHAMPUS   1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define OGOVTINS  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define OGOVINS2  1 "Medicare" 2 "Medicaid or Medical Assistance"
                       3 "Military Health Care (CHAMPUS, TRICARE, VA)"
                       4 "State AIDS Drug Assistance Program"
                       5 "SCHIP (State Children's Health Insurance Plan)"
                       6 "Public Health Service/Indian health hospital/clinc"
                       7 "Temp Assistance for Needy Families; formerly AFDC"
                       8 "State govt prgm; Chronically Ill/Disabled Children"
                       9 "State govt program; prescription assistance"
                       11 "Migrant/community/rural health center"
                       12 "Local/state hlth dept;social/human servcs; unspcfd"
                       13 "School/college/univ health services; govt unspecfd"
                       15 "WIC/Suppl Nutrition Prgm Women, Infants,& Children"
                       16 "Sliding scale/subsidized health care; unspecified"
                       17 "Non-Medicaid state govt low-income health assistnc"
                       19 "Social Security; type unspecified"
                       20 "Workman's Compensation"
                       21 "Welfare/social welfare; not otherwise specified"
                       22 "State Health program; type unspecified"
                       23 "Other gov't coverage, not classified elsewhere"
                       60 "Private ins provider; govt affiliation unspecified"
                       61 "Civilian govt employee private health insurance"
                       62 "Health care coverage outside of the US"
                       63 "Medical/health care/wellness coverage; unspecified"
                       65 "Private, not-for-profit foundation"
                       70 "Non-health care insurance coverage"
                       72 "Supplemental Social Income (SSI)"
                       73 "Other non-gov't insurance/not a type of insurance"
                       985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP (OGOVTINS=2)" ;
label define PRVHLTIN  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define GRPHLTIN  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (PRVHLTIN = 2)" ;
label define HLTINALC  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (PRVHLTIN = 2)" ;
label define HLTINDRG  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (PRVHLTIN = 2)" ;
label define HLTINMNT  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP (PRVHLTIN = 2)" ;
label define OTHLTINS  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define OTHLINS2  1 "Medicare" 2 "Medicaid or Medical Assistance"
                       3 "Military Health Care (CHAMPUS, TRICARE, VA)"
                       4 "Private health insurance"
                       5 "Public Health Service/Indian health hospital/clinc"
                       6 "Health care coverage outside of USA"
                       7 "School/sport-related health care coverage"
                       8 "Non-government medical assistance"
                       9 "Temp Assistance for Needy Families; formerly AFDC"
                       10 "Dental/vision/prescription/chiro/alt med insurance"
                       13 "Cancer/heart insurance coverage"
                       14 "Long term/nursing home care insurance"
                       15 "Hospitalization/catastrophic/major illness insurnc"
                       17 "Local/state hlth dept;social.human servcs; unspcfd"
                       18 "Medical/insurance; type unspecified"
                       19 "SCHIP (State Children's Health Insurance Plan)"
                       20 "Family member coverage; type unspecified"
                       21 "Secondary/supplemental insurance; private unspecfd"
                       22 "Employee Assistance Program"
                       23 "State health program; type unspecified"
                       25 "Sliding scale/subsidized health care; unspecified"
                       30 "Foreign exchange student program insurance"
                       31 "Accident/injury insurance"
                       32 "Other health insurance, not classified elsewhere"
                       50 "All types/combined/other; hlth ins coverage unspcd"
                       60 "Non-health care insurance/coverage"
                       985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP (OTHLTINS=2)" ;
label define HLCNOTYR  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLCNOTMO  94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HLCLAST   1 "Within the past 6 months"
                       2 "More than 6 months ago, but within the past year"
                       3 "More than 1 year ago, but within the past 3 years"
                       4 "More than 3 years ago" 5 "Never had coverage"
                       11 "Within the past 6 months (see NOTE)"
                       12 "More than 6 mos ago but w/in pst yr (see NOTE)"
                       13 "More than 1 yr ago but w/in pst 3 yr (see NOTE)"
                       14 "More than 3 years ago (see NOTE)"
                       15 "Never had coverage (see NOTE)" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HLCPRIVT  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLCMCAID  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLCMILT   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HLCMCARE  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLCOGOVT  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLCOTHER  1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HLCOTHS2  1 "Private health insurance"
                       2 "Medicaid or medical assistance" 4 "Medicare"
                       5 "Some other government program"
                       6 "Some other kind of coverage"
                       8 "Health care coverage outside of USA"
                       9 "School/sport-related health care coverage"
                       11 "Medical, type unspecified"
                       14 "Workman's compensation" 60 "Paid out of pocket"
                       61 "Does not have medical insurance"
                       90 "NEVER HAD HEALTH CARE COVERAGE"
                       985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define HLLLOSJB  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLLMAJOB  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       11 "Response entered (potl incons w/last coverage)"
                       13 "Response entered LOG ASSN (potl incons)"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HLLMASOR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered"
                       11 "Response entered (potl incons w/last coverage)"
                       13 "Response entered LOG ASSN (potl incons)"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HLLCOST   1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLLINELG  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLLNOFFR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLLDIVOR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLLDEATH  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLLREFUS  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLLNONED  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLLSOR    1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HLLSORS2  1 "Person in family w/ ins lost job/chngd employers"
                       2 "Lost Medicaid or med assist cov b/c new job/income"
                       3 "Lost Medicaid or med assist cov for other reason"
                       4 "Cost is too high/can't afford premiums"
                       5 "Became ineligible b/c of age or leaving school"
                       6 "Employer doesn't offer cov/not eligible for cov"
                       7 "Got divorced or separated from person w/ ins"
                       8 "Death of spouse or parent"
                       9 "Insurance company refused coverage"
                       10 "Don't need it" 11 "Some other reason"
                       12 "Have not applied or reapplied for ins coverage"
                       13 "Applied ins/Medicaid,waiting for activation/eligib"
                       14 "Ineligible b/c moved out of parents home/got marri"
                       15 "Don't know how to obtain/trying to obtain"
                       16 "Non-us citizen"
                       19 "Self-employed/parents self-employed"
                       20 "Dissatisfied with previous/available coverage"
                       22 "Had ins in another country before moving to US"
                       23 "Moved/don't have same coverage"
                       24 "Parents/guardians got divorced/separated"
                       25 "Don't qualify, no reason specified"
                       26 "Dropped coverage, no reason specified"
                       28 "Don't qualify for partner's/family member's policy"
                       32 "Ineligible, some other reason"
                       35 "Too complicated to get health insurance coverage"
                       39 "Employer/respondent is changing insurance plans"
                       41 "Parent/guardian doesn't/won't provide coverage"
                       42 "Ins co didn't receive payment/paperwork in time"
                       44 "Student/becoming stdnt(elg for oth cov unk)"
                       45 "Ineligible because part-time student"
                       90 "CURRENTLY COVERED BY HEALTH INSURANCE"
                       985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define HLNVCOST  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLNVOFFR  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLNVREF   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HLNVNEED  1 "Response entered"
                       3 "Response entered LOGICALLY ASSIGNED"
                       6 "Response not entered" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HLNVSOR   1 "Response entered" 6 "Response not entered"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HLNVSP2   1 "Cost is too high/can't afford premiums"
                       2 "Employer doesn't offer cov/not eligible for cov"
                       4 "Don't need it" 5 "Some other reason"
                       7 "Have never applied for/thought about ins covrg"
                       8 "Religious beliefs/don't trust medical prof/ins co"
                       9 "Didn't know available or how to obtain ins"
                       10 "Currently looking for insurance coverage"
                       12 "Non-US citizen" 14 "Prefer to pay cash"
                       15 "Never had insurance, no reason specified"
                       16 "Parent/guardian don't/won't provide coverage"
                       17 "Ineligible, other reasons"
                       90 "CURRENTLY COVERED BY HEALTH INSURANCE"
                       91 "ASSISTANCE PROVIDED BY CHURCH/COMMUNITY"
                       92 "HAVE BEEN COVERED BY HEALTH INSURANCE IN PAST"
                       985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define IRPINSUR  1 "Yes, respondent does have private health insurance"
                       2 "No, respondent does not have private health insur" ;
label define IIPINSUR  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRINSUR   1 "Yes, respondent does have health insurance"
                       2 "No, respondent does not have health insurance" ;
label define IIINSUR   1 "Questionnaire data" 3 "Statistically imputed data" ;
label define IRINSUR2  1 "Yes, respondent does have health insurance"
                       2 "No, respondent does not have health insurance" ;
label define IIINSUR2  1 "Questionnaire data" 3 "Statistically imputed data" ;
label define LANGVER   1 "English" 2 "Spanish" 98 "BLANK (NO ANSWER)" ;
label define QUARTER   1 "Quarter 1" 2 "Quarter 2" 3 "Quarter 3"
                       4 "Quarter 4" ;
label define GQTYPE    -9 "Not a Group Quarter" 1 "Halfway House"
                       2 "Boarding House" 3 "College Dorm" 4 "Shelter"
                       5 "Other" ;
label define AGE2      1 "Respondent is 12 years old"
                       2 "Respondent is 13 years old"
                       3 "Respondent is 14 years old"
                       4 "Respondent is 15 years old"
                       5 "Respondent is 16 years old"
                       6 "Respondent is 17 years old"
                       7 "Respondent is 18 years old"
                       8 "Respondent is 19 years old"
                       9 "Respondent is 20 years old"
                       10 "Respondent is 21 years old"
                       11 "Respondent is 22 or 23 years old"
                       12 "Respondent is 24 or 25 years old"
                       13 "Respondent is between 26 and 29 years old"
                       14 "Respondent is between 30 and 34 years old"
                       15 "Respondent is between 35 and 49 years old"
                       16 "Respondent is between 50 and 64 years old"
                       17 "Respondent is 65 years old or older" ;
label define NOMARR2   1 "One time" 2 "Two or more times" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SERVICE   1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       99 "LEGITIMATE SKIP" ;
label define MILSTAT   2 "In a reserves component"
                       3 "Now separated/retired from reserves/active duty"
                       94 "DON'T KNOW" 97 "REFUSED" 99 "LEGITIMATE SKIP" ;
label define HEALTH    1 "Excellent" 2 "Very good" 3 "Good" 4 "Fair" 5 "Poor"
                       94 "DON'T KNOW" 97 "REFUSED" ;
label define IRSEX     1 "Male" 2 "Female" ;
label define IISEX     1 "Sex from questionnaire" 2 "Sex from screener" ;
label define IRMARIT   1 "Married" 2 "Widowed" 3 "Divorced or Separated"
                       4 "Never Been Married"
                       99 "LEGITIMATE SKIP Respondent is <= 14 years old" ;
label define IIMARIT   1 "Marital status from questionnaire"
                       3 "Marital status statistically imputed"
                       9 "LEGITIMATE SKIP Respondent is <= 14 years old" ;
label define IREDUC2   1 "Fifth grade or less" 2 "Sixth grade"
                       3 "Seventh grade" 4 "Eighth grade" 5 "Ninth grade"
                       6 "Tenth grade" 7 "Eleventh grade" 8 "Twelfth grade"
                       9 "Freshman/13th year"
                       10 "Sophomore/14th year or Junior/15th year"
                       11 "Senior/16th year or GradProf School (or higher)" ;
label define IIEDUC2   1 "Education from questionnaire"
                       3 "Education statistically imputed" ;
label define EMPSTAT3  1 "Employed full time" 2 "Employed part time"
                       3 "Unemployed" 4 "Other" 5 "12-17 year olds" ;
label define IIEMPST3  1 "Employment status from questionnaire"
                       3 "Employment statistically imputed"
                       4 "12-17 years old" ;
label define EMPSTATY  1 "Employed full time" 2 "Employed part time"
                       3 "Unemployed" 4 "Other (incl. not in labor force)"
                       5 "12-14 year olds" ;
label define IIEMPSTY  1 "Employment status from questionnaire"
                       3 "Employment statistically imputed"
                       4 "12-14 years old" ;
label define EMPSTAT4  1 "Employed full time" 2 "Employed part time"
                       3 "Unemployed" 4 "Other (incl. not in labor force)"
                       5 "12-17 year olds" ;
label define IIEMPST4  1 "Employment status from questionnaire"
                       3 "Employment statistically imputed"
                       4 "12-17 years old" ;
label define MOVESPY2  0 "None" 1 "One time" 2 "Two times"
                       3 "Three or more times" 994 "DON'T KNOW" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" ;
label define ENROLED   1 "Yes" 2 "No"
                       3 "Yes LOGICALLY ASSIGNED (LFSCHWH2=777,778)"
                       5 "Yes LOGICALLY ASSIGNED (LFSCHWH2=601)"
                       11 "Yes (SCHDSKIP = 30)"
                       52 "Summer interview (not enrolled & HSDIPLMA=4)"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define EDUCNOW2  1 "5th Grade or lower" 2 "6th Grade" 3 "7th Grade"
                       4 "8th Grade" 5 "9th Grade" 6 "10th Grade"
                       7 "11th Grade" 8 "12th Grade"
                       9 "College or university/1st year"
                       10 "College or university/2nd Year, 3rd year"
                       11 "College or university/4th Year, 5th or higher year"
                       12 "Missing" 13 "LEGITIMATE SKIP" ;
label define STUDNT    1 "FULL-TIME" 2 "PART-TIME" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SCHDSICK  0 "None" 85 "BAD DATA Logically assigned"
                       90 "SCHOOL NOT IN SESSION" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define SCHDSKIP  0 "None" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define HSDIPLMA  1 "Yes" 2 "No" 3 "Yes LOG ASSN"
                       4 "No LOGICALLY ASSIGNED"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define HSGED     1 "Yes" 2 "No" 3 "Yes LOG ASSN (LFSCHWH2=606)"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define LFSCHWH2  1 "School was boring or I didn't want to be there"
                       2 "I got pregnant"
                       3 "I got in trouble or expelled for selling drugs"
                       4 "I got in trouble or expelled for using drugs"
                       5 "I got in trouble or expelled for some other reason"
                       6 "I often got into trouble"
                       7 "I had to get a job (or work more hours)"
                       8 "I was getting bad grades"
                       9 "I wasn't learning anything"
                       10 "I got married (or moved in with my boy/girlfriend)"
                       11 "I moved here from another country/didn't enroll"
                       12 "I was treated badly at school"
                       13 "I became ill (or injured)"
                       14 "I went to jail/prison"
                       15 "I had responsibilities at home/personal problems"
                       16 "Other reason"
                       41 "Family member became ill/sick/died"
                       42 "I wasn't admitted/couldn't attend school of choice"
                       43 "Parents/guardian/partner wouldn't allow me to"
                       44 "Ran away from/put out of/placed out of home"
                       45 "Too stressful/couldn't adjust"
                       46 "Learning disabled"
                       50 "Moved away/didn't re-enroll"
                       51 "Skipping school/excessive absenteeism"
                       52 "Too expensive/couldn't afford"
                       54 "No transportation/school too far away"
                       56 "Grade,credit discrepancies/lacked credits/document"
                       58 "All the schooling/preferred that was available"
                       59 "Wasn't required/didn't have to/not needed/customs"
                       60 "Against my religion/beliefs"
                       63 "I was stupid/foolish" 66 "Too old"
                       67 "Wanted to work/do apprenticeship instead"
                       69 "Just quit; reason unspecified"
                       71 "Didn't pass/take end of grade/school test"
                       73 "Held back/school didn't think I was capable"
                       601 "Home schooled"
                       602 "Went to technical school/community college"
                       605 "Completed HS/certificate, general"
                       606 "Received GED"
                       607 "Pursuing GED/proficiency exam/re-enrolling"
                       777 "Summer/school not in session"
                       778 "I am still in school"
                       985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define LFTSCHA2  10 "Left at age 10 or younger"
                       19 "Left at age 19 or older"
                       985 "BAD DATA Logically assigned" 994 "DON'T KNOW"
                       997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define RLGSVCYR  1 "0 times" 2 "1 to 2 times" 3 "3 to 5 times"
                       4 "6 to 24 times" 5 "25 to 52 times"
                       6 "More than 52 times" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RLGIMPRT  1 "Strongly disagree" 2 "Disagree" 3 "Agree"
                       4 "Strongly agree" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RLGDECSN  1 "Strongly disagree" 2 "Disagree" 3 "Agree"
                       4 "Strongly agree" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define RLGFRNDS  1 "Strongly disagree" 2 "Disagree" 3 "Agree"
                       4 "Strongly agree" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" ;
label define TELNO2    0 "None" 1 "One" 2 "Two or more" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)" ;
label define TUCHTONE  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define COLLEGE2  -9 "Unknwn Enrollment, Aged 18-22(ENROLED=94,97,98)"
                       1 "Full-Time College Student Aged 18-22"
                       2 "Part-Time College Student Aged 18-22"
                       3 "Not Enrolled (ENROLED=2)"
                       4 "Others Persons Aged 18-22"
                       5 "Persons Aged 12-17, or 23 or Older" ;
label define CATAGE    1 "12-17 Years Old" 2 "18-25 Years Old"
                       3 "26-34 Years Old" 4 "35 or Older" ;
label define CATAG2    1 "12-17 Years Old" 2 "18-25 Years Old"
                       3 "26 or Older" ;
label define CATAG3    1 "12-17 Years Old" 2 "18-25 Years Old"
                       3 "26-34 Years Old" 4 "35-49 Years Old"
                       5 "50 or Older" ;
label define CATAG7    1 "12-13 Years Old" 2 "14-15 Years Old"
                       3 "16-17 Years Old" 4 "18-20 Years Old"
                       5 "21-25 Years Old" 6 "26-34 Years Old"
                       7 "35 or Older" ;
label define NEWRACE2  1 "NonHisp White" 2 "NonHisp Black/Afr Am"
                       3 "NonHisp Native Am/AK Native"
                       4 "NonHisp Native HI/Other Pac Isl" 5 "NonHisp Asian"
                       6 "NonHisp more than one race" 7 "Hispanic" ;
label define EDUCCAT2  1 "Less than high school" 2 "High school graduate"
                       3 "Some college" 4 "College graduate"
                       5 "12 to 17 year olds (1<=AGE2<=6)" ;
label define JOBSTAT2  1 "Worked at full-time job, past week"
                       2 "Worked at part time job, past week"
                       3 "Has job or volunteer worker, did not work past wk"
                       4 "Unemployed/on layoff, looking for work"
                       5 "Disabled" 6 "Keeping house full-time"
                       7 "In school/training" 8 "Retired"
                       9 "Does not have a job, some other reason"
                       10 "MISSING" 11 "LEGITIMATE SKIP" ;
label define JBSTATR2  1 "Worked at full-time job, past week"
                       2 "Worked at part time job, past week"
                       3 "Has job or volunteer worker, did not work past wk"
                       4 "Unemployed/on layoff, looking for work"
                       5 "Disabled" 6 "Keeping house full-time"
                       7 "In school/training" 8 "Retired"
                       9 "Does not have a job, some other reason"
                       10 "MISSING" 11 "LEGITIMATE SKIP" ;
label define WRKHAVJB  1 "Yes" 2 "No" 89 "LEGITIMATE SKIP Logically assigned"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define WRKHRSWK  994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define WRKINDU2  1 "Agriculture, Forestry, and Fisheries" 2 "Mining"
                       3 "Construction" 4 "Manufacturing - Nondurable Goods"
                       5 "Manufacturing - Durable Goods"
                       6 "Trans/Commun/and Other Public Utilities"
                       7 "Wholesale Trade - Durable Goods"
                       8 "Wholesale Trade - Nondurable Goods"
                       9 "Retail Trade"
                       10 "Finance, Insurance, and Real Estate"
                       11 "Business and Repair Services"
                       12 "Personal Services"
                       13 "Entertainment and Recreation Services"
                       14 "Professional and Related Services"
                       15 "Public Administration" 16 "Military Duty"
                       985 "BAD DATA Logically assigned"
                       992 "Last worked 1984 or earlier" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define WRKOCCU2  1 "Executive/Administrative/Managerial Occupations"
                       2 "Professional Specialty Occupations"
                       3 "Technicians and Related Support Occupations"
                       4 "Sales Occupations"
                       5 "Administrative Support Occupations, Inc Clerical"
                       6 "Private Household Occupations"
                       7 "Protective Service Occupations"
                       8 "Service Occups, Except Protective/Private Househol"
                       9 "Farming, Forestry, and Fishing occupations"
                       10 "Mechanics and repairers" 11 "Construction trades"
                       12 "Extractive Occupations"
                       13 "Machine Operators, Assemblers, and Inspectors"
                       14 "Transportation and Material Moving Occupations"
                       15 "Handlers/Equipment Cleaners/Helpers/Laborers"
                       16 "Military" 909 "Last worked 1984 or earlier"
                       985 "BAD DATA Logically assigned" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define WRKBZCA2  1 "Private for-profit company or business"
                       2 "Private not-for-profit company or business"
                       3 "Local government (city, county, etc.)"
                       4 "State government"
                       5 "Federal/Foreign government or international"
                       6 "Self-employed in an incorporated business"
                       7 "Self-employed in an unincorporated business"
                       8 "Working without pay in a family business/farm"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define WRKEFFRT  1 "Yes" 2 "No" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define WRKEDYR   1 "Yes" 2 "No" 85 "BAD DATA Logically assigned"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define WRKSLFEM  1 "Yes" 2 "No"
                       3 "Yes LOGICALLY ASSIGNED (raw var not blank)"
                       5 "Yes LOGICALLY ASSIGNED (from skip pattern)"
                       89 "LEGITIMATE SKIP Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define WRKJOBS2  1 "One" 2 "Two" 3 "Three" 4 "Four or more"
                       975 "At least one LOGICALLY ASSIGNED"
                       989 "LEGITIMATE SKIP Logically assigned"
                       994 "DON'T KNOW" 997 "REFUSED" 998 "BLANK (NO ANSWER)"
                       999 "LEGITIMATE SKIP" ;
label define WRKUNEMP  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define WRKUNWKS  85 "BAD DATA Logically assigned" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define WRKLASY2  1960 "1960 or earlier"
                       9985 "BAD DATA Logically assigned"
                       9989 "LEGITIMATE SKIP Logically assigned"
                       9991 "NEVER WORKED FOR PAY" 9994 "DON'T KNOW"
                       9997 "REFUSED" 9998 "BLANK (NO ANSWER)"
                       9999 "LEGITIMATE SKIP" ;
label define WRKINDY2  1 "Agriculture, Forestry, and Fisheries" 2 "Mining"
                       3 "Construction" 4 "Manufacturing - Nondurable Goods"
                       5 "Manufacturing - Durable Goods"
                       6 "Trans/Commun/and Other Public Utilities"
                       7 "Wholesale Trade - Durable Goods"
                       8 "Wholesale Trade - Nondurable Goods"
                       9 "Retail Trade"
                       10 "Finance, Insurance, and Real Estate"
                       11 "Business and Repair Services"
                       12 "Personal Services"
                       13 "Entertainment and Recreation Services"
                       14 "Professional and Related Services"
                       15 "Public Administration" 16 "Military Duty"
                       985 "BAD DATA Logically assigned"
                       989 "LEGITIMATE SKIP Logically assigned"
                       992 "Last worked 1984 or earlier" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define WRKOCCY2  1 "Executive/Administrative/Managerial Occupations"
                       2 "Professional Specialty Occupations"
                       3 "Technicians and Related Support Occupations"
                       4 "Sales Occupations"
                       5 "Administrative Support Occupations, Inc Clerical"
                       6 "Private Household Occupations"
                       7 "Protective Service Occupations"
                       8 "Service Occups, Except Protective/Private Househol"
                       9 "Farming, Forestry, and Fishing occupations"
                       10 "Mechanics and repairers" 11 "Construction trades"
                       12 "Extractive Occupations"
                       13 "Machine Operators, Assemblers, and Inspectors"
                       14 "Transportation and Material Moving Occupations"
                       15 "Handlers/Equipment Cleaners/Helpers/Laborers"
                       16 "Military" 909 "Last worked 1984 or earlier"
                       985 "BAD DATA Logically assigned"
                       989 "LEGITIMATE SKIP Logically assigned" 997 "REFUSED"
                       998 "BLANK (NO ANSWER)" 999 "LEGITIMATE SKIP" ;
label define WORKDAYS  0 "None" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define WORKBLAH  0 "None" 85 "BAD DATA Logically assigned"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define LOCSIZE   1 "Less than 10 people" 2 "10-24 people"
                       3 "25-99 people" 4 "100-499 people"
                       5 "500 people or more" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define DRGPLCY   1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define PLCYCOV   1 "Only alcohol" 2 "Only drugs"
                       3 "Both alcohol and drugs" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define WKDRGED   1 "Yes" 2 "No" 3 "Don't remember" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define DRGPRGM   1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define USALCTST  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define USDRGTST  1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TSTHIRE   1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define TSTRAND   1 "Yes" 2 "No" 94 "DON'T KNOW" 97 "REFUSED"
                       98 "BLANK (NO ANSWER)" 99 "LEGITIMATE SKIP" ;
label define FIRSTPOS  1 "Handled on indiv basis/policy does not spec what"
                       2 "Employee is fired"
                       3 "Employee is referred for treatment or counseling"
                       4 "Nothing happens" 5 "Something else happens"
                       94 "DON'T KNOW" 97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define WRKHIRE   1 "More likely" 2 "Less likely"
                       3 "Would it make no difference to you" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define WORKRAND  1 "More likely" 2 "Less likely"
                       3 "Would make no difference" 94 "DON'T KNOW"
                       97 "REFUSED" 98 "BLANK (NO ANSWER)"
                       99 "LEGITIMATE SKIP" ;
label define FIEXP99   1 "Yes" 2 "No" ;
label define PDEN      1 "Segment in a MSA with 1 million or more persons"
                       2 "Segment in a MSA with fewer than 1 million persons"
                       3 "Segment not in a MSA" ;


#delimit cr


/***************************************************************************

 Section 4: Missing Values

 This section will replace numeric missing values (i.e., -9) with generic
 system missing ".".  By default the code in this section is commented out.
 Users wishing to apply the generic missing values should remove the comment
 at the beginning and end of this section.  Note that Stata allows you to
 specify up to 27 unique missing value codes.

****************************************************************/

/*
replace CIGOFRSM = . if (CIGOFRSM >= 81 )
replace CIGWILYR = . if (CIGWILYR >= 81 )
replace CIGTRY = . if (CIGTRY >= 981 )
replace CIGYFU = . if (CIGYFU >= 9981 )
replace CIGMFU = . if (CIGMFU >= 81 )
replace CIGREC = . if (CIGREC >= 81 )
replace CIG30USE = . if (CIG30USE >= 81 )
replace CG30EST = . if (CG30EST >= 81 )
replace CIG30AV = . if (CIG30AV >= 81 )
replace CIG30BR2 = . if (CIG30BR2 >= 9981 )
replace CIG30TYP = . if (CIG30TYP >= 81 )
replace CIG30MEN = . if (CIG30MEN >= 81 )
replace CIG30RO2 = . if (CIG30RO2 >= 81 )
replace CIGDLYMO = . if (CIGDLYMO >= 81 )
replace CIGAGE = . if (CIGAGE >= 981 )
replace CIG100LF = . if (CIG100LF >= 81 )
replace CHEWEVER = . if (CHEWEVER >= 81 )
replace CHEWTRY = . if (CHEWTRY >= 981 )
replace CHEWYFU = . if (CHEWYFU >= 9981 )
replace CHEWMFU = . if (CHEWMFU >= 81 )
replace CHEWREC = . if (CHEWREC >= 81 )
replace CHW30USE = . if (CHW30USE >= 81 )
replace CH30EST = . if (CH30EST >= 81 )
replace CHW30BR2 = . if (CHW30BR2 >= 9981 )
replace SNFEVER = . if (SNFEVER >= 81 )
replace SNUFTRY = . if (SNUFTRY >= 981 )
replace SNUFYFU = . if (SNUFYFU >= 9981 )
replace SNUFMFU = . if (SNUFMFU >= 81 )
replace SNFREC = . if (SNFREC >= 81 )
replace SNF30USE = . if (SNF30USE >= 81 )
replace SN30EST = . if (SN30EST >= 81 )
replace SNF30BR2 = . if (SNF30BR2 >= 9981 )
replace SLTTRY = . if (SLTTRY >= 981 )
replace SLTYFU = . if (SLTYFU >= 9981 )
replace SLTMFU = . if (SLTMFU >= 81 )
replace SLTREC = . if (SLTREC >= 81 )
replace SLT30BR2 = . if (SLT30BR2 >= 9981 )
replace SLT30FAV = . if (SLT30FAV >= 81 )
replace CIGAREVR = . if (CIGAREVR >= 81 )
replace CIGARTRY = . if (CIGARTRY >= 981 )
replace CIGARYFU = . if (CIGARYFU >= 9981 )
replace CIGARMFU = . if (CIGARMFU >= 81 )
replace CIGARREC = . if (CIGARREC >= 81 )
replace CGR30USE = . if (CGR30USE >= 81 )
replace CI30EST = . if (CI30EST >= 81 )
replace CGR30BR2 = . if (CGR30BR2 >= 9981 )
replace PIPEVER = . if (PIPEVER >= 81 )
replace PIPE30DY = . if (PIPE30DY >= 81 )
replace ALCEVER = . if (ALCEVER >= 81 )
replace ALCTRY = . if (ALCTRY >= 981 )
replace ALCYFU = . if (ALCYFU >= 9981 )
replace ALCMFU = . if (ALCMFU >= 81 )
replace ALCREC = . if (ALCREC >= 81 )
replace ALCYRTOT = . if (ALCYRTOT >= 981 )
replace ALTOTFG = . if (ALTOTFG >= 81 )
replace ALFQFLG = . if (ALFQFLG >= 81 )
replace ALBSTWAY = . if (ALBSTWAY >= 81 )
replace ALDAYPYR = . if (ALDAYPYR >= 981 )
replace ALDAYPMO = . if (ALDAYPMO >= 81 )
replace ALDAYPWK = . if (ALDAYPWK >= 81 )
replace ALCDAYS = . if (ALCDAYS >= 81 )
replace AL30EST = . if (AL30EST >= 81 )
replace ALDYSFG = . if (ALDYSFG >= 81 )
replace NODR30A = . if (NODR30A >= 981 )
replace DR5DAY = . if (DR5DAY >= 80 )
replace MJEVER = . if (MJEVER >= 81 )
replace MJAGE = . if (MJAGE >= 981 )
replace MJYFU = . if (MJYFU >= 9981 )
replace MJMFU = . if (MJMFU >= 81 )
replace MJREC = . if (MJREC >= 81 )
replace MJYRTOT = . if (MJYRTOT >= 981 )
replace MRTOTFG = . if (MRTOTFG >= 81 )
replace MJFQFLG = . if (MJFQFLG >= 81 )
replace MRBSTWAY = . if (MRBSTWAY >= 81 )
replace MRDAYPYR = . if (MRDAYPYR >= 981 )
replace MRDAYPMO = . if (MRDAYPMO >= 81 )
replace MRDAYPWK = . if (MRDAYPWK >= 81 )
replace MJDAY30A = . if (MJDAY30A >= 81 )
replace MR30EST = . if (MR30EST >= 81 )
replace COCEVER = . if (COCEVER >= 81 )
replace COCAGE = . if (COCAGE >= 981 )
replace COCYFU = . if (COCYFU >= 9981 )
replace COCMFU = . if (COCMFU >= 81 )
replace COCREC = . if (COCREC >= 81 )
replace COCYRTOT = . if (COCYRTOT >= 981 )
replace CCTOTFG = . if (CCTOTFG >= 81 )
replace CCFQFLG = . if (CCFQFLG >= 81 )
replace CCBSTWAY = . if (CCBSTWAY >= 81 )
replace CCDAYPYR = . if (CCDAYPYR >= 981 )
replace CCDAYPMO = . if (CCDAYPMO >= 81 )
replace CCDAYPWK = . if (CCDAYPWK >= 81 )
replace COCUS30A = . if (COCUS30A >= 81 )
replace CC30EST = . if (CC30EST >= 81 )
replace CRKEVER = . if (CRKEVER >= 81 )
replace CRKAGE = . if (CRKAGE >= 981 )
replace CRKYFU = . if (CRKYFU >= 9981 )
replace CRKMFU = . if (CRKMFU >= 81 )
replace CRAKREC = . if (CRAKREC >= 81 )
replace CRKYRTOT = . if (CRKYRTOT >= 981 )
replace CRTOTFG = . if (CRTOTFG >= 81 )
replace CRFQFLG = . if (CRFQFLG >= 81 )
replace CRBSTWAY = . if (CRBSTWAY >= 81 )
replace CRDAYPYR = . if (CRDAYPYR >= 981 )
replace CRDAYPMO = . if (CRDAYPMO >= 81 )
replace CRDAYPWK = . if (CRDAYPWK >= 81 )
replace CRKUS30A = . if (CRKUS30A >= 81 )
replace CR30EST = . if (CR30EST >= 81 )
replace HEREVER = . if (HEREVER >= 81 )
replace HERAGE = . if (HERAGE >= 981 )
replace HERYFU = . if (HERYFU >= 9981 )
replace HERMFU = . if (HERMFU >= 81 )
replace HERREC = . if (HERREC >= 81 )
replace HERYRTOT = . if (HERYRTOT >= 981 )
replace HRTOTFG = . if (HRTOTFG >= 81 )
replace HRFQFLG = . if (HRFQFLG >= 81 )
replace HRBSTWAY = . if (HRBSTWAY >= 81 )
replace HRDAYPYR = . if (HRDAYPYR >= 981 )
replace HRDAYPMO = . if (HRDAYPMO >= 81 )
replace HRDAYPWK = . if (HRDAYPWK >= 81 )
replace HER30USE = . if (HER30USE >= 81 )
replace HR30EST = . if (HR30EST >= 81 )
replace LSD = . if (LSD >= 81 )
replace PCP = . if (PCP >= 81 )
replace PEYOTE = . if (PEYOTE >= 81 )
replace MESC = . if (MESC >= 81 )
replace PSILCY = . if (PSILCY >= 81 )
replace ECSTASY = . if (ECSTASY >= 81 )
replace HALNOLST = . if (HALNOLST >= 81 )
replace HALNEWA = . if (HALNEWA >= 9981 )
replace HALNEWB = . if (HALNEWB >= 9981 )
replace HALNEWC = . if (HALNEWC >= 9981 )
replace HALNEWD = . if (HALNEWD >= 9981 )
replace HALNEWE = . if (HALNEWE >= 9981 )
replace HALLAGE = . if (HALLAGE >= 981 )
replace HALYFU = . if (HALYFU >= 9981 )
replace HALMFU = . if (HALMFU >= 81 )
replace HALLREC = . if (HALLREC >= 81 )
replace HALYRTOT = . if (HALYRTOT >= 981 )
replace HLTOTFG = . if (HLTOTFG >= 81 )
replace HLFQFLG = . if (HLFQFLG >= 81 )
replace HLBSTWAY = . if (HLBSTWAY >= 81 )
replace HLDAYPYR = . if (HLDAYPYR >= 981 )
replace HLDAYPMO = . if (HLDAYPMO >= 81 )
replace HLDAYPWK = . if (HLDAYPWK >= 81 )
replace HAL30USE = . if (HAL30USE >= 81 )
replace HL30EST = . if (HL30EST >= 81 )
replace LSDAGE = . if (LSDAGE >= 981 )
replace LSDYFU = . if (LSDYFU >= 9981 )
replace LSDMFU = . if (LSDMFU >= 81 )
replace LSDREC = . if (LSDREC >= 81 )
replace PCPAGE = . if (PCPAGE >= 981 )
replace PCPYFU = . if (PCPYFU >= 9981 )
replace PCPMFU = . if (PCPMFU >= 81 )
replace PCPREC = . if (PCPREC >= 81 )
replace AMYLNIT = . if (AMYLNIT >= 81 )
replace CLEFLU = . if (CLEFLU >= 81 )
replace GAS = . if (GAS >= 81 )
replace GLUE = . if (GLUE >= 81 )
replace ETHER = . if (ETHER >= 81 )
replace SOLVENT = . if (SOLVENT >= 81 )
replace LGAS = . if (LGAS >= 81 )
replace NITOXID = . if (NITOXID >= 81 )
replace SPPAINT = . if (SPPAINT >= 81 )
replace AEROS = . if (AEROS >= 81 )
replace INHNOLST = . if (INHNOLST >= 81 )
replace INHNEWA = . if (INHNEWA >= 9981 )
replace INHNEWB = . if (INHNEWB >= 9981 )
replace INHNEWC = . if (INHNEWC >= 9981 )
replace INHNEWD = . if (INHNEWD >= 9981 )
replace INHNEWE = . if (INHNEWE >= 9981 )
replace INHAGE = . if (INHAGE >= 981 )
replace INHYFU = . if (INHYFU >= 9981 )
replace INHMFU = . if (INHMFU >= 81 )
replace INHREC = . if (INHREC >= 81 )
replace INHYRTOT = . if (INHYRTOT >= 981 )
replace INTOTFG = . if (INTOTFG >= 81 )
replace INFQFLG = . if (INFQFLG >= 81 )
replace INBSTWAY = . if (INBSTWAY >= 81 )
replace INDAYPYR = . if (INDAYPYR >= 981 )
replace INDAYPMO = . if (INDAYPMO >= 81 )
replace INDAYPWK = . if (INDAYPWK >= 81 )
replace INHDY30A = . if (INHDY30A >= 81 )
replace IN30EST = . if (IN30EST >= 81 )
replace DARVTYLC = . if (DARVTYLC >= 81 )
replace PERCTYLX = . if (PERCTYLX >= 81 )
replace VICOLOR = . if (VICOLOR >= 81 )
replace ANLCARD = . if (ANLCARD >= 81 )
replace CODEINE = . if (CODEINE >= 81 )
replace DEMEROL = . if (DEMEROL >= 81 )
replace DILAUD = . if (DILAUD >= 81 )
replace FIORICET = . if (FIORICET >= 81 )
replace FIORINAL = . if (FIORINAL >= 81 )
replace HYDROCOD = . if (HYDROCOD >= 81 )
replace METHDON = . if (METHDON >= 81 )
replace MORPHINE = . if (MORPHINE >= 81 )
replace OXYCONTN = . if (OXYCONTN >= 81 )
replace PHENCOD = . if (PHENCOD >= 81 )
replace PROPOXY = . if (PROPOXY >= 81 )
replace SK65A = . if (SK65A >= 81 )
replace STADOL = . if (STADOL >= 81 )
replace TALACEN = . if (TALACEN >= 81 )
replace TALWIN = . if (TALWIN >= 81 )
replace TALWINNX = . if (TALWINNX >= 81 )
replace TRAMADOL = . if (TRAMADOL >= 81 )
replace ULTRAM = . if (ULTRAM >= 81 )
replace ANLNOLST = . if (ANLNOLST >= 81 )
replace ANALNEWA = . if (ANALNEWA >= 9981 )
replace ANALNEWB = . if (ANALNEWB >= 9981 )
replace ANALNEWC = . if (ANALNEWC >= 9981 )
replace ANALNEWD = . if (ANALNEWD >= 9981 )
replace ANALNEWE = . if (ANALNEWE >= 9981 )
replace ANALAGE = . if (ANALAGE >= 981 )
replace ANALYFU = . if (ANALYFU >= 9981 )
replace ANALMFU = . if (ANALMFU >= 81 )
replace ANALREC = . if (ANALREC >= 81 )
replace ANLYRTOT = . if (ANLYRTOT >= 981 )
replace PRTOTFG = . if (PRTOTFG >= 81 )
replace PRFQFLG = . if (PRFQFLG >= 81 )
replace PRBSTWAY = . if (PRBSTWAY >= 81 )
replace PRDAYPYR = . if (PRDAYPYR >= 981 )
replace PRDAYPMO = . if (PRDAYPMO >= 81 )
replace PRDAYPWK = . if (PRDAYPWK >= 81 )
replace KLONOPIN = . if (KLONOPIN >= 81 )
replace XNAXATVN = . if (XNAXATVN >= 81 )
replace VALMDIAZ = . if (VALMDIAZ >= 81 )
replace TRNCARD = . if (TRNCARD >= 81 )
replace ATARAX = . if (ATARAX >= 81 )
replace BUSPAR = . if (BUSPAR >= 81 )
replace EQUANIL = . if (EQUANIL >= 81 )
replace FLEXERIL = . if (FLEXERIL >= 81 )
replace LIBRIUM = . if (LIBRIUM >= 81 )
replace LIMBTROL = . if (LIMBTROL >= 81 )
replace MEPROB = . if (MEPROB >= 81 )
replace MILTOWN = . if (MILTOWN >= 81 )
replace ROHYPNOL = . if (ROHYPNOL >= 81 )
replace SERAX = . if (SERAX >= 81 )
replace SOMA = . if (SOMA >= 81 )
replace TRANXENE = . if (TRANXENE >= 81 )
replace VISTAR = . if (VISTAR >= 81 )
replace TRNOLST = . if (TRNOLST >= 81 )
replace TRNEWA = . if (TRNEWA >= 9981 )
replace TRNEWB = . if (TRNEWB >= 9981 )
replace TRNEWC = . if (TRNEWC >= 9981 )
replace TRNEWD = . if (TRNEWD >= 9981 )
replace TRNEWE = . if (TRNEWE >= 9981 )
replace TRANAGE = . if (TRANAGE >= 981 )
replace TRANYFU = . if (TRANYFU >= 9981 )
replace TRANMFU = . if (TRANMFU >= 81 )
replace TRANREC = . if (TRANREC >= 81 )
replace TRNYRTOT = . if (TRNYRTOT >= 981 )
replace TRTOTFG = . if (TRTOTFG >= 81 )
replace TRFQFLG = . if (TRFQFLG >= 81 )
replace TRBSTWAY = . if (TRBSTWAY >= 81 )
replace TRDAYPYR = . if (TRDAYPYR >= 981 )
replace TRDAYPMO = . if (TRDAYPMO >= 81 )
replace TRDAYPWK = . if (TRDAYPWK >= 81 )
replace METHDES = . if (METHDES >= 81 )
replace DIETPILS = . if (DIETPILS >= 81 )
replace RITMPHEN = . if (RITMPHEN >= 81 )
replace STMCARD = . if (STMCARD >= 81 )
replace CYLERT = . if (CYLERT >= 81 )
replace DEXED = . if (DEXED >= 81 )
replace DETAMP = . if (DETAMP >= 81 )
replace DIDREX = . if (DIDREX >= 81 )
replace ESKAT = . if (ESKAT >= 81 )
replace IONAMIN = . if (IONAMIN >= 81 )
replace MAZANOR = . if (MAZANOR >= 81 )
replace OBLA = . if (OBLA >= 81 )
replace PLEGINE = . if (PLEGINE >= 81 )
replace PRELUDIN = . if (PRELUDIN >= 81 )
replace SANOREX = . if (SANOREX >= 81 )
replace TENUATE = . if (TENUATE >= 81 )
replace STMNOLST = . if (STMNOLST >= 81 )
replace STIMNEWA = . if (STIMNEWA >= 9981 )
replace STIMNEWB = . if (STIMNEWB >= 9981 )
replace STIMNEWC = . if (STIMNEWC >= 9981 )
replace STIMNEWD = . if (STIMNEWD >= 9981 )
replace STIMNEWE = . if (STIMNEWE >= 9981 )
replace STIMAGE = . if (STIMAGE >= 981 )
replace STIMYFU = . if (STIMYFU >= 9981 )
replace STIMMFU = . if (STIMMFU >= 81 )
replace STIMREC = . if (STIMREC >= 81 )
replace STMYRTOT = . if (STMYRTOT >= 981 )
replace STTOTFG = . if (STTOTFG >= 81 )
replace STFQFLG = . if (STFQFLG >= 81 )
replace STBSTWAY = . if (STBSTWAY >= 81 )
replace STDAYPYR = . if (STDAYPYR >= 981 )
replace STDAYPMO = . if (STDAYPMO >= 81 )
replace STDAYPWK = . if (STDAYPWK >= 81 )
replace METHAGE = . if (METHAGE >= 981 )
replace METHYFU = . if (METHYFU >= 9981 )
replace METHMFU = . if (METHMFU >= 81 )
replace METHREC = . if (METHREC >= 81 )
replace METHAQ = . if (METHAQ >= 81 )
replace NEMBBARB = . if (NEMBBARB >= 81 )
replace RESTTMAZ = . if (RESTTMAZ >= 81 )
replace SEDCARD = . if (SEDCARD >= 81 )
replace AMYTAL = . if (AMYTAL >= 81 )
replace BUTISOL = . if (BUTISOL >= 81 )
replace CHHYD = . if (CHHYD >= 81 )
replace DALMANE = . if (DALMANE >= 81 )
replace HALCION = . if (HALCION >= 81 )
replace PHENOBAR = . if (PHENOBAR >= 81 )
replace PLACIDYL = . if (PLACIDYL >= 81 )
replace TUINAL = . if (TUINAL >= 81 )
replace SEDNOLST = . if (SEDNOLST >= 81 )
replace SEDNEWA = . if (SEDNEWA >= 9981 )
replace SEDNEWB = . if (SEDNEWB >= 9981 )
replace SEDNEWC = . if (SEDNEWC >= 9981 )
replace SEDNEWD = . if (SEDNEWD >= 9981 )
replace SEDNEWE = . if (SEDNEWE >= 9981 )
replace SEDAGE = . if (SEDAGE >= 981 )
replace SEDYFU = . if (SEDYFU >= 9981 )
replace SEDMFU = . if (SEDMFU >= 81 )
replace SEDREC = . if (SEDREC >= 81 )
replace SEDYRTOT = . if (SEDYRTOT >= 981 )
replace SVTOTFG = . if (SVTOTFG >= 81 )
replace SVFQFLG = . if (SVFQFLG >= 81 )
replace SVBSTWAY = . if (SVBSTWAY >= 81 )
replace SVDAYPYR = . if (SVDAYPYR >= 981 )
replace SVDAYPMO = . if (SVDAYPMO >= 81 )
replace SVDAYPWK = . if (SVDAYPWK >= 81 )
replace IRCIGRC = . if (IRCIGRC == 9)
replace IRCGRRC = . if (IRCGRRC == 9)
replace IRPIPLF = . if (IRPIPLF == 9)
replace IRPIPMN = . if (IRPIPMN == 9)
replace IRSLTRC = . if (IRSLTRC == 9)
replace IRCHWRC = . if (IRCHWRC == 9)
replace IRSNFRC = . if (IRSNFRC == 9)
replace IRALCRC = . if (IRALCRC == 9)
replace IRMJRC = . if (IRMJRC == 9)
replace IRCOCRC = . if (IRCOCRC == 9)
replace IRCRKRC = . if (IRCRKRC == 9)
replace IRHERRC = . if (IRHERRC == 9)
replace IRHALRC = . if (IRHALRC == 9)
replace IRLSDRC = . if (IRLSDRC == 9)
replace IRPCPRC = . if (IRPCPRC == 9)
replace IRINHRC = . if (IRINHRC == 9)
replace IRANLRC = . if (IRANLRC == 9)
replace IRTRNRC = . if (IRTRNRC == 9)
replace IRSTMRC = . if (IRSTMRC == 9)
replace IRMTHRC = . if (IRMTHRC == 9)
replace IRSEDRC = . if (IRSEDRC == 9)
replace IRALCFY = . if (IRALCFY >= 981 )
replace IRMJFY = . if (IRMJFY >= 981 )
replace IRCOCFY = . if (IRCOCFY >= 981 )
replace IRCRKFY = . if (IRCRKFY >= 981 )
replace IRHERFY = . if (IRHERFY >= 981 )
replace IRHALFY = . if (IRHALFY >= 981 )
replace IRINHFY = . if (IRINHFY >= 981 )
replace IRANLFY = . if (IRANLFY >= 981 )
replace IRTRNFY = . if (IRTRNFY >= 981 )
replace IRSTMFY = . if (IRSTMFY >= 981 )
replace IRSEDFY = . if (IRSEDFY >= 981 )
replace IRCIGFM = . if (IRCIGFM >= 81.00 )
replace IRCGRFM = . if (IRCGRFM >= 81.00 )
replace IRCHWFM = . if (IRCHWFM >= 81.00 )
replace IRSNFFM = . if (IRSNFFM >= 81.00 )
replace IRALCFM = . if (IRALCFM >= 81.00 )
replace IRALCD5 = . if (IRALCD5 >= 81 )
replace IRMJFM = . if (IRMJFM >= 81.00 )
replace IRCOCFM = . if (IRCOCFM >= 81.00 )
replace IRCRKFM = . if (IRCRKFM >= 81.00 )
replace IRHERFM = . if (IRHERFM >= 81 )
replace IRHALFM = . if (IRHALFM >= 81.00 )
replace IRINHFM = . if (IRINHFM >= 81.00 )
replace IRCIGAGE = . if (IRCIGAGE >= 981 )
replace IRCIGYFU = . if (IRCIGYFU >= 9981 )
replace IRCDUAGE = . if (IRCDUAGE >= 981 )
replace IICDUAGE = . if (IICDUAGE == 9)
replace IRCDUYFU = . if (IRCDUYFU >= 9981 )
replace IRCGRAGE = . if (IRCGRAGE >= 981 )
replace IRCGRYFU = . if (IRCGRYFU >= 9981 )
replace IRSNFAGE = . if (IRSNFAGE >= 981 )
replace IRSNFYFU = . if (IRSNFYFU >= 9981 )
replace IRCHWAGE = . if (IRCHWAGE >= 981 )
replace IRCHWYFU = . if (IRCHWYFU >= 9981 )
replace IRSLTAGE = . if (IRSLTAGE >= 981 )
replace IRSLTYFU = . if (IRSLTYFU >= 9981 )
replace IRALCAGE = . if (IRALCAGE >= 981 )
replace IRALCYFU = . if (IRALCYFU >= 9981 )
replace IRMJAGE = . if (IRMJAGE >= 981 )
replace IRMJYFU = . if (IRMJYFU >= 9981 )
replace IRCOCAGE = . if (IRCOCAGE >= 981 )
replace IRCOCYFU = . if (IRCOCYFU >= 9981 )
replace IRCRKAGE = . if (IRCRKAGE >= 981 )
replace IRCRKYFU = . if (IRCRKYFU >= 9981 )
replace IRHERAGE = . if (IRHERAGE >= 981 )
replace IRHERYFU = . if (IRHERYFU >= 9981 )
replace IRHALAGE = . if (IRHALAGE >= 981 )
replace IRHALYFU = . if (IRHALYFU >= 9981 )
replace IRLSDAGE = . if (IRLSDAGE >= 981 )
replace IRLSDYFU = . if (IRLSDYFU >= 9981 )
replace IRPCPAGE = . if (IRPCPAGE >= 981 )
replace IRPCPYFU = . if (IRPCPYFU >= 9981 )
replace IRINHAGE = . if (IRINHAGE >= 981 )
replace IRINHYFU = . if (IRINHYFU >= 9981 )
replace IRANLAGE = . if (IRANLAGE >= 981 )
replace IRANLYFU = . if (IRANLYFU >= 9981 )
replace IRTRNAGE = . if (IRTRNAGE >= 981 )
replace IRTRNYFU = . if (IRTRNYFU >= 9981 )
replace IRSTMAGE = . if (IRSTMAGE >= 981 )
replace IRSTMYFU = . if (IRSTMYFU >= 9981 )
replace IRMTHAGE = . if (IRMTHAGE >= 981 )
replace IRMTHYFU = . if (IRMTHYFU >= 9981 )
replace IRSEDAGE = . if (IRSEDAGE >= 981 )
replace IRSEDYFU = . if (IRSEDYFU >= 9981 )
replace CIGBRND2 = . if (CIGBRND2 == -9)
replace CGRBRND2 = . if (CGRBRND2 == -9)
replace SMKBRND2 = . if (SMKBRND2 == -9)
replace CIGCMPNY = . if (CIGCMPNY >= 81 )
replace ALCAFU = . if (ALCAFU == 4)
replace MJAFU = . if (MJAFU == 4)
replace COCAFU = . if (COCAFU == 4)
replace HERAFU = . if (HERAFU == 4)
replace HALAFU = . if (HALAFU == 4)
replace INHAFU = . if (INHAFU == 4)
replace ANLAFU = . if (ANLAFU == 4)
replace TRNAFU = . if (TRNAFU == 4)
replace STMAFU = . if (STMAFU == 4)
replace SEDAFU = . if (SEDAFU == 4)
replace CIGAFU = . if (CIGAFU == 4)
replace CGRAFU = . if (CGRAFU == 4)
replace SLTAFU = . if (SLTAFU == 4)
replace MRJYDAYS = . if (MRJYDAYS == 6)
replace COCYDAYS = . if (COCYDAYS == 6)
replace HALYDAYS = . if (HALYDAYS == 6)
replace INHYDAYS = . if (INHYDAYS == 6)
replace ALCYDAYS = . if (ALCYDAYS == 6)
replace MRJMDAYS = . if (MRJMDAYS == 6)
replace COCMDAYS = . if (COCMDAYS == 6)
replace HALMDAYS = . if (HALMDAYS == 6)
replace INHMDAYS = . if (INHMDAYS == 6)
replace ALCMDAYS = . if (ALCMDAYS == 6)
replace CIGMDAYS = . if (CIGMDAYS == 6)
replace CIGPDAY = . if (CIGPDAY == 6)
replace CG05 = . if (CG05 >= 81 )
replace CG06 = . if (CG06 >= 81 )
replace CG06DK = . if (CG06DK >= 81 )
replace CG06RE = . if (CG06RE >= 81 )
replace CG19 = . if (CG19 >= 81 )
replace CG20 = . if (CG20 >= 81 )
replace CG20DK = . if (CG20DK >= 81 )
replace CG20RE = . if (CG20RE >= 81 )
replace CG27 = . if (CG27 >= 81 )
replace CG28 = . if (CG28 >= 81 )
replace CG28DK = . if (CG28DK >= 81 )
replace CG28RE = . if (CG28RE >= 81 )
replace CG36 = . if (CG36 >= 81 )
replace CG37 = . if (CG37 >= 81 )
replace CG37DK = . if (CG37DK >= 81 )
replace CG37RE = . if (CG37RE >= 81 )
replace CG43 = . if (CG43 >= 81 )
replace ALLAST3 = . if (ALLAST3 >= 81 )
replace ALRECDK = . if (ALRECDK >= 81 )
replace ALRECRE = . if (ALRECRE >= 81 )
replace TOTDRINK = . if (TOTDRINK >= 981 )
replace ALFRAME3 = . if (ALFRAME3 >= 81 )
replace ALYRAVE = . if (ALYRAVE >= 981 )
replace ALMONAVE = . if (ALMONAVE >= 81 )
replace ALWKAVE = . if (ALWKAVE >= 81 )
replace MJLAST3 = . if (MJLAST3 >= 81 )
replace MJRECDK = . if (MJRECDK >= 81 )
replace MJRECRE = . if (MJRECRE >= 81 )
replace TOTMJ = . if (TOTMJ >= 981 )
replace MJFRAME3 = . if (MJFRAME3 >= 81 )
replace MJYRAVE = . if (MJYRAVE >= 981 )
replace MJMONAVE = . if (MJMONAVE >= 81 )
replace MJWKAVE = . if (MJWKAVE >= 81 )
replace CCLAST3 = . if (CCLAST3 >= 81 )
replace CCRECDK = . if (CCRECDK >= 81 )
replace CCRECRE = . if (CCRECRE >= 81 )
replace TOTCOKE = . if (TOTCOKE >= 981 )
replace CCFRAME3 = . if (CCFRAME3 >= 81 )
replace CCYRAVE = . if (CCYRAVE >= 981 )
replace CCMONAVE = . if (CCMONAVE >= 81 )
replace CCWKAVE = . if (CCWKAVE >= 81 )
replace CKLAST3 = . if (CKLAST3 >= 81 )
replace CKRECDK = . if (CKRECDK >= 81 )
replace CKRECRE = . if (CKRECRE >= 81 )
replace TOTCRACK = . if (TOTCRACK >= 981 )
replace CKFRAME3 = . if (CKFRAME3 >= 81 )
replace CKYRAVE = . if (CKYRAVE >= 981 )
replace CKMONAVE = . if (CKMONAVE >= 81 )
replace CKWKAVE = . if (CKWKAVE >= 81 )
replace HELAST3 = . if (HELAST3 >= 81 )
replace HERECDK = . if (HERECDK >= 81 )
replace HERECRE = . if (HERECRE >= 81 )
replace TOTHERO = . if (TOTHERO >= 981 )
replace HEFRAME3 = . if (HEFRAME3 >= 81 )
replace HEYRAVE = . if (HEYRAVE >= 981 )
replace HEMONAVE = . if (HEMONAVE >= 81 )
replace HEWKAVE = . if (HEWKAVE >= 81 )
replace LSLAST = . if (LSLAST >= 81 )
replace LSRECDK = . if (LSRECDK >= 81 )
replace LSRECRE = . if (LSRECRE >= 81 )
replace TOTHALL = . if (TOTHALL >= 981 )
replace LSFRAME3 = . if (LSFRAME3 >= 81 )
replace LSYRAVE = . if (LSYRAVE >= 981 )
replace LSMONAVE = . if (LSMONAVE >= 81 )
replace LSWKAVE = . if (LSWKAVE >= 81 )
replace LS10 = . if (LS10 >= 81 )
replace LS16 = . if (LS16 >= 81 )
replace INLAST = . if (INLAST >= 81 )
replace INRECDK = . if (INRECDK >= 81 )
replace INRECRE = . if (INRECRE >= 81 )
replace TOTINHAL = . if (TOTINHAL >= 981 )
replace INFRAME3 = . if (INFRAME3 >= 81 )
replace INYRAVE = . if (INYRAVE >= 981 )
replace INMONAVE = . if (INMONAVE >= 81 )
replace INWKAVE = . if (INWKAVE >= 81 )
replace PR09 = . if (PR09 >= 81 )
replace PRRECDK = . if (PRRECDK >= 81 )
replace PRRECRE = . if (PRRECRE >= 81 )
replace PR10 = . if (PR10 >= 81 )
replace PR11 = . if (PR11 >= 981 )
replace PR12 = . if (PR12 >= 81 )
replace PR13 = . if (PR13 >= 81 )
replace TR09 = . if (TR09 >= 81 )
replace TRRECDK = . if (TRRECDK >= 81 )
replace TRRECRE = . if (TRRECRE >= 81 )
replace TR10 = . if (TR10 >= 81 )
replace TR11 = . if (TR11 >= 981 )
replace TR12 = . if (TR12 >= 81 )
replace TR13 = . if (TR13 >= 81 )
replace ST09 = . if (ST09 >= 81 )
replace STRECDK = . if (STRECDK >= 81 )
replace STRECRE = . if (STRECRE >= 81 )
replace ST10 = . if (ST10 >= 81 )
replace ST11 = . if (ST11 >= 981 )
replace ST12 = . if (ST12 >= 81 )
replace ST13 = . if (ST13 >= 81 )
replace ST19 = . if (ST19 >= 81 )
replace SV09 = . if (SV09 >= 81 )
replace SVRECDK = . if (SVRECDK >= 81 )
replace SVRECRE = . if (SVRECRE >= 81 )
replace SV10 = . if (SV10 >= 81 )
replace SV11 = . if (SV11 >= 981 )
replace SV12 = . if (SV12 >= 81 )
replace SV13 = . if (SV13 >= 81 )
replace HERSMOKE = . if (HERSMOKE >= 81 )
replace HRSMKREC = . if (HRSMKREC >= 81 )
replace HERSNIFF = . if (HERSNIFF >= 81 )
replace HRSNFREC = . if (HRSNFREC >= 81 )
replace GNNDLLIF = . if (GNNDLLIF >= 81 )
replace COCNEEDL = . if (COCNEEDL >= 81 )
replace CONDLREC = . if (CONDLREC >= 81 )
replace HERNEEDL = . if (HERNEEDL >= 81 )
replace HRNDLREC = . if (HRNDLREC >= 81 )
replace STNEEDLE = . if (STNEEDLE >= 81 )
replace STNDLREC = . if (STNDLREC >= 81 )
replace GNNDREUS = . if (GNNDREUS >= 81 )
replace GNNDLSH1 = . if (GNNDLSH1 >= 81 )
replace GNNDCLEN = . if (GNNDCLEN >= 81 )
replace GNNDLSH2 = . if (GNNDLSH2 >= 81 )
replace GNNDGET2 = . if (GNNDGET2 >= 81 )
replace NEDLRECC = . if (NEDLRECC >= 81 )
replace RSKPKCIG = . if (RSKPKCIG >= 81 )
replace RSKMJOCC = . if (RSKMJOCC >= 81 )
replace RSKMJREG = . if (RSKMJREG >= 81 )
replace RKTRYLSD = . if (RKTRYLSD >= 81 )
replace RKLSDREG = . if (RKLSDREG >= 81 )
replace RKTRYHER = . if (RKTRYHER >= 81 )
replace RKHERREG = . if (RKHERREG >= 81 )
replace RKCOCOCC = . if (RKCOCOCC >= 81 )
replace RKCOCREG = . if (RKCOCREG >= 81 )
replace RK5ALDLY = . if (RK5ALDLY >= 81 )
replace RK5ALWK = . if (RK5ALWK >= 81 )
replace RSKDIFMJ = . if (RSKDIFMJ >= 81 )
replace RKDIFLSD = . if (RKDIFLSD >= 81 )
replace RKDIFCOC = . if (RKDIFCOC >= 81 )
replace RKDIFCRK = . if (RKDIFCRK >= 81 )
replace RKDIFHER = . if (RKDIFHER >= 81 )
replace RSKSELL = . if (RSKSELL >= 81 )
replace RKFQDNGR = . if (RKFQDNGR >= 81 )
replace RKFQRSKY = . if (RKFQRSKY >= 81 )
replace RKFQPBLT = . if (RKFQPBLT >= 81 )
replace RKFQDBLT = . if (RKFQDBLT >= 81 )
replace GRSKPKCG = . if (GRSKPKCG == -9)
replace GRSKCREG = . if (GRSKCREG == -9)
replace GRSKCOCC = . if (GRSKCOCC == -9)
replace GRSKMREG = . if (GRSKMREG == -9)
replace GRSKMOCC = . if (GRSKMOCC == -9)
replace GRSKHTRY = . if (GRSKHTRY == -9)
replace GRSKHREG = . if (GRSKHREG == -9)
replace GRSKLTRY = . if (GRSKLTRY == -9)
replace GRSKLREG = . if (GRSKLREG == -9)
replace GRSKD4_5 = . if (GRSKD4_5 == -9)
replace GRSKD5WK = . if (GRSKD5WK == -9)
replace RDIFMJ = . if (RDIFMJ == -9)
replace RDIFCOC = . if (RDIFCOC == -9)
replace RDIFHER = . if (RDIFHER == -9)
replace RDIFLSD = . if (RDIFLSD == -9)
replace RDIFCRK = . if (RDIFCRK == -9)
replace APPSELDG = . if (APPSELDG == -9)
replace CIGLOTTM = . if (CIGLOTTM >= 81 )
replace CIGLIMIT = . if (CIGLIMIT >= 81 )
replace CIGKPLMT = . if (CIGKPLMT >= 81 )
replace CIGNDMOR = . if (CIGNDMOR >= 81 )
replace CIGLSEFX = . if (CIGLSEFX >= 81 )
replace CIGCUTDN = . if (CIGCUTDN >= 81 )
replace CIGCUTEV = . if (CIGCUTEV >= 81 )
replace CIGCUT1X = . if (CIGCUT1X >= 81 )
replace CIGWD4SX = . if (CIGWD4SX >= 81 )
replace CIGWDSMT = . if (CIGWDSMT >= 81 )
replace CIGEMOPB = . if (CIGEMOPB >= 81 )
replace CIGEMCTD = . if (CIGEMCTD >= 81 )
replace CIGPHLPB = . if (CIGPHLPB >= 81 )
replace CIGPHCTD = . if (CIGPHCTD >= 81 )
replace CIGLSACT = . if (CIGLSACT >= 81 )
replace CIGPKCRT = . if (CIGPKCRT >= 81 )
replace CIGPDPAK = . if (CIGPDPAK >= 81 )
replace CIGPDCRT = . if (CIGPDCRT >= 81 )
replace ALCLOTTM = . if (ALCLOTTM >= 81 )
replace ALCGTOVR = . if (ALCGTOVR >= 81 )
replace ALCLIMIT = . if (ALCLIMIT >= 81 )
replace ALCKPLMT = . if (ALCKPLMT >= 81 )
replace ALCNDMOR = . if (ALCNDMOR >= 81 )
replace ALCLSEFX = . if (ALCLSEFX >= 81 )
replace ALCCUTDN = . if (ALCCUTDN >= 81 )
replace ALCCUTEV = . if (ALCCUTEV >= 81 )
replace ALCCUT1X = . if (ALCCUT1X >= 81 )
replace ALCWD2SX = . if (ALCWD2SX >= 81 )
replace ALCWDSMT = . if (ALCWDSMT >= 81 )
replace ALCEMOPB = . if (ALCEMOPB >= 81 )
replace ALCEMCTD = . if (ALCEMCTD >= 81 )
replace ALCPHLPB = . if (ALCPHLPB >= 81 )
replace ALCPHCTD = . if (ALCPHCTD >= 81 )
replace ALCLSACT = . if (ALCLSACT >= 81 )
replace ALCSERPB = . if (ALCSERPB >= 81 )
replace ALCPDANG = . if (ALCPDANG >= 81 )
replace ALCLAWTR = . if (ALCLAWTR >= 81 )
replace ALCFMFPB = . if (ALCFMFPB >= 81 )
replace ALCFMCTD = . if (ALCFMCTD >= 81 )
replace MRJLOTTM = . if (MRJLOTTM >= 81 )
replace MRJGTOVR = . if (MRJGTOVR >= 81 )
replace MRJLIMIT = . if (MRJLIMIT >= 81 )
replace MRJKPLMT = . if (MRJKPLMT >= 81 )
replace MRJNDMOR = . if (MRJNDMOR >= 81 )
replace MRJLSEFX = . if (MRJLSEFX >= 81 )
replace MRJCUTDN = . if (MRJCUTDN >= 81 )
replace MRJCUTEV = . if (MRJCUTEV >= 81 )
replace MRJEMOPB = . if (MRJEMOPB >= 81 )
replace MRJEMCTD = . if (MRJEMCTD >= 81 )
replace MRJPHLPB = . if (MRJPHLPB >= 81 )
replace MRJPHCTD = . if (MRJPHCTD >= 81 )
replace MRJLSACT = . if (MRJLSACT >= 81 )
replace MRJSERPB = . if (MRJSERPB >= 81 )
replace MRJPDANG = . if (MRJPDANG >= 81 )
replace MRJLAWTR = . if (MRJLAWTR >= 81 )
replace MRJFMFPB = . if (MRJFMFPB >= 81 )
replace MRJFMCTD = . if (MRJFMCTD >= 81 )
replace COCLOTTM = . if (COCLOTTM >= 81 )
replace COCGTOVR = . if (COCGTOVR >= 81 )
replace COCLIMIT = . if (COCLIMIT >= 81 )
replace COCKPLMT = . if (COCKPLMT >= 81 )
replace COCNDMOR = . if (COCNDMOR >= 81 )
replace COCLSEFX = . if (COCLSEFX >= 81 )
replace COCCUTDN = . if (COCCUTDN >= 81 )
replace COCCUTEV = . if (COCCUTEV >= 81 )
replace COCCUT1X = . if (COCCUT1X >= 81 )
replace COCFLBLU = . if (COCFLBLU >= 81 )
replace COCWD2SX = . if (COCWD2SX >= 81 )
replace COCWDSMT = . if (COCWDSMT >= 81 )
replace COCEMOPB = . if (COCEMOPB >= 81 )
replace COCEMCTD = . if (COCEMCTD >= 81 )
replace COCPHLPB = . if (COCPHLPB >= 81 )
replace COCPHCTD = . if (COCPHCTD >= 81 )
replace COCLSACT = . if (COCLSACT >= 81 )
replace COCSERPB = . if (COCSERPB >= 81 )
replace COCPDANG = . if (COCPDANG >= 81 )
replace COCLAWTR = . if (COCLAWTR >= 81 )
replace COCFMFPB = . if (COCFMFPB >= 81 )
replace COCFMCTD = . if (COCFMCTD >= 81 )
replace HERLOTTM = . if (HERLOTTM >= 81 )
replace HERGTOVR = . if (HERGTOVR >= 81 )
replace HERLIMIT = . if (HERLIMIT >= 81 )
replace HERKPLMT = . if (HERKPLMT >= 81 )
replace HERNDMOR = . if (HERNDMOR >= 81 )
replace HERLSEFX = . if (HERLSEFX >= 81 )
replace HERCUTDN = . if (HERCUTDN >= 81 )
replace HERCUTEV = . if (HERCUTEV >= 81 )
replace HERCUT1X = . if (HERCUT1X >= 81 )
replace HERWD3SX = . if (HERWD3SX >= 81 )
replace HERWDSMT = . if (HERWDSMT >= 81 )
replace HEREMOPB = . if (HEREMOPB >= 81 )
replace HEREMCTD = . if (HEREMCTD >= 81 )
replace HERPHLPB = . if (HERPHLPB >= 81 )
replace HERPHCTD = . if (HERPHCTD >= 81 )
replace HERLSACT = . if (HERLSACT >= 81 )
replace HERSERPB = . if (HERSERPB >= 81 )
replace HERPDANG = . if (HERPDANG >= 81 )
replace HERLAWTR = . if (HERLAWTR >= 81 )
replace HERFMFPB = . if (HERFMFPB >= 81 )
replace HERFMCTD = . if (HERFMCTD >= 81 )
replace HALLOTTM = . if (HALLOTTM >= 81 )
replace HALGTOVR = . if (HALGTOVR >= 81 )
replace HALLIMIT = . if (HALLIMIT >= 81 )
replace HALKPLMT = . if (HALKPLMT >= 81 )
replace HALNDMOR = . if (HALNDMOR >= 81 )
replace HALLSEFX = . if (HALLSEFX >= 81 )
replace HALCUTDN = . if (HALCUTDN >= 81 )
replace HALCUTEV = . if (HALCUTEV >= 81 )
replace HALEMOPB = . if (HALEMOPB >= 81 )
replace HALEMCTD = . if (HALEMCTD >= 81 )
replace HALPHLPB = . if (HALPHLPB >= 81 )
replace HALPHCTD = . if (HALPHCTD >= 81 )
replace HALLSACT = . if (HALLSACT >= 81 )
replace HALSERPB = . if (HALSERPB >= 81 )
replace HALPDANG = . if (HALPDANG >= 81 )
replace HALLAWTR = . if (HALLAWTR >= 81 )
replace HALFMFPB = . if (HALFMFPB >= 81 )
replace HALFMCTD = . if (HALFMCTD >= 81 )
replace INHLOTTM = . if (INHLOTTM >= 81 )
replace INHGTOVR = . if (INHGTOVR >= 81 )
replace INHLIMIT = . if (INHLIMIT >= 81 )
replace INHKPLMT = . if (INHKPLMT >= 81 )
replace INHNDMOR = . if (INHNDMOR >= 81 )
replace INHLSEFX = . if (INHLSEFX >= 81 )
replace INHCUTDN = . if (INHCUTDN >= 81 )
replace INHCUTEV = . if (INHCUTEV >= 81 )
replace INHEMOPB = . if (INHEMOPB >= 81 )
replace INHEMCTD = . if (INHEMCTD >= 81 )
replace INHPHLPB = . if (INHPHLPB >= 81 )
replace INHPHCTD = . if (INHPHCTD >= 81 )
replace INHLSACT = . if (INHLSACT >= 81 )
replace INHSERPB = . if (INHSERPB >= 81 )
replace INHPDANG = . if (INHPDANG >= 81 )
replace INHLAWTR = . if (INHLAWTR >= 81 )
replace INHFMFPB = . if (INHFMFPB >= 81 )
replace INHFMCTD = . if (INHFMCTD >= 81 )
replace ANLLOTTM = . if (ANLLOTTM >= 81 )
replace ANLGTOVR = . if (ANLGTOVR >= 81 )
replace ANLLIMIT = . if (ANLLIMIT >= 81 )
replace ANLKPLMT = . if (ANLKPLMT >= 81 )
replace ANLNDMOR = . if (ANLNDMOR >= 81 )
replace ANLLSEFX = . if (ANLLSEFX >= 81 )
replace ANLCUTDN = . if (ANLCUTDN >= 81 )
replace ANLCUTEV = . if (ANLCUTEV >= 81 )
replace ANLCUT1X = . if (ANLCUT1X >= 81 )
replace ANLWD3SX = . if (ANLWD3SX >= 81 )
replace ANLWDSMT = . if (ANLWDSMT >= 81 )
replace ANLEMOPB = . if (ANLEMOPB >= 81 )
replace ANLEMCTD = . if (ANLEMCTD >= 81 )
replace ANLPHLPB = . if (ANLPHLPB >= 81 )
replace ANLPHCTD = . if (ANLPHCTD >= 81 )
replace ANLLSACT = . if (ANLLSACT >= 81 )
replace ANLSERPB = . if (ANLSERPB >= 81 )
replace ANLPDANG = . if (ANLPDANG >= 81 )
replace ANLLAWTR = . if (ANLLAWTR >= 81 )
replace ANLFMFPB = . if (ANLFMFPB >= 81 )
replace ANLFMCTD = . if (ANLFMCTD >= 81 )
replace TRNLOTTM = . if (TRNLOTTM >= 81 )
replace TRNGTOVR = . if (TRNGTOVR >= 81 )
replace TRNLIMIT = . if (TRNLIMIT >= 81 )
replace TRNKPLMT = . if (TRNKPLMT >= 81 )
replace TRNNDMOR = . if (TRNNDMOR >= 81 )
replace TRNLSEFX = . if (TRNLSEFX >= 81 )
replace TRNCUTDN = . if (TRNCUTDN >= 81 )
replace TRNCUTEV = . if (TRNCUTEV >= 81 )
replace TRNEMOPB = . if (TRNEMOPB >= 81 )
replace TRNEMCTD = . if (TRNEMCTD >= 81 )
replace TRNPHLPB = . if (TRNPHLPB >= 81 )
replace TRNPHCTD = . if (TRNPHCTD >= 81 )
replace TRNLSACT = . if (TRNLSACT >= 81 )
replace TRNSERPB = . if (TRNSERPB >= 81 )
replace TRNPDANG = . if (TRNPDANG >= 81 )
replace TRNLAWTR = . if (TRNLAWTR >= 81 )
replace TRNFMFPB = . if (TRNFMFPB >= 81 )
replace TRNFMCTD = . if (TRNFMCTD >= 81 )
replace STMLOTTM = . if (STMLOTTM >= 81 )
replace STMGTOVR = . if (STMGTOVR >= 81 )
replace STMLIMIT = . if (STMLIMIT >= 81 )
replace STMKPLMT = . if (STMKPLMT >= 81 )
replace STMNDMOR = . if (STMNDMOR >= 81 )
replace STMLSEFX = . if (STMLSEFX >= 81 )
replace STMCUTDN = . if (STMCUTDN >= 81 )
replace STMCUTEV = . if (STMCUTEV >= 81 )
replace STMCUT1X = . if (STMCUT1X >= 81 )
replace STMFLBLU = . if (STMFLBLU >= 81 )
replace STMWD2SX = . if (STMWD2SX >= 81 )
replace STMWDSMT = . if (STMWDSMT >= 81 )
replace STMEMOPB = . if (STMEMOPB >= 81 )
replace STMEMCTD = . if (STMEMCTD >= 81 )
replace STMPHLPB = . if (STMPHLPB >= 81 )
replace STMPHCTD = . if (STMPHCTD >= 81 )
replace STMLSACT = . if (STMLSACT >= 81 )
replace STMSERPB = . if (STMSERPB >= 81 )
replace STMPDANG = . if (STMPDANG >= 81 )
replace STMLAWTR = . if (STMLAWTR >= 81 )
replace STMFMFPB = . if (STMFMFPB >= 81 )
replace STMFMCTD = . if (STMFMCTD >= 81 )
replace SEDLOTTM = . if (SEDLOTTM >= 81 )
replace SEDGTOVR = . if (SEDGTOVR >= 81 )
replace SEDLIMIT = . if (SEDLIMIT >= 81 )
replace SEDKPLMT = . if (SEDKPLMT >= 81 )
replace SEDNDMOR = . if (SEDNDMOR >= 81 )
replace SEDLSEFX = . if (SEDLSEFX >= 81 )
replace SEDCUTDN = . if (SEDCUTDN >= 81 )
replace SEDCUTEV = . if (SEDCUTEV >= 81 )
replace SEDCUT1X = . if (SEDCUT1X >= 81 )
replace SEDWD1SX = . if (SEDWD1SX >= 81 )
replace SEDWDSMT = . if (SEDWDSMT >= 81 )
replace SEDEMOPB = . if (SEDEMOPB >= 81 )
replace SEDEMCTD = . if (SEDEMCTD >= 81 )
replace SEDPHLPB = . if (SEDPHLPB >= 81 )
replace SEDPHCTD = . if (SEDPHCTD >= 81 )
replace SEDLSACT = . if (SEDLSACT >= 81 )
replace SEDSERPB = . if (SEDSERPB >= 81 )
replace SEDPDANG = . if (SEDPDANG >= 81 )
replace SEDLAWTR = . if (SEDLAWTR >= 81 )
replace SEDFMFPB = . if (SEDFMFPB >= 81 )
replace SEDFMCTD = . if (SEDFMCTD >= 81 )
replace BOOKED = . if (BOOKED >= 81 )
replace NOBOOKY2 = . if (NOBOOKY2 >= 981 )
replace BKMVTHFT = . if (BKMVTHFT >= 81 )
replace BKLARCNY = . if (BKLARCNY >= 81 )
replace BKBURGL = . if (BKBURGL >= 81 )
replace BKAGASLT = . if (BKAGASLT >= 81 )
replace BKSMASLT = . if (BKSMASLT >= 81 )
replace BKROB = . if (BKROB >= 81 )
replace BKRAPE = . if (BKRAPE >= 81 )
replace BKMURDER = . if (BKMURDER >= 81 )
replace BKARSON = . if (BKARSON >= 81 )
replace BKDRVINF = . if (BKDRVINF >= 81 )
replace BKDRUNK = . if (BKDRUNK >= 81 )
replace BKPOSTOB = . if (BKPOSTOB >= 81 )
replace BKDRUG = . if (BKDRUG >= 81 )
replace BKPROS = . if (BKPROS >= 81 )
replace BKSEXOFF = . if (BKSEXOFF >= 81 )
replace BKFRAUD = . if (BKFRAUD >= 81 )
replace BKOTH = . if (BKOTH >= 81 )
replace BKOTHOF2 = . if (BKOTHOF2 >= 81 )
replace PROBATON = . if (PROBATON >= 81 )
replace PAROLREL = . if (PAROLREL >= 81 )
replace DRVALDR = . if (DRVALDR >= 81 )
replace DRVAONLY = . if (DRVAONLY >= 81 )
replace DRVDONLY = . if (DRVDONLY >= 81 )
replace DRIVALC = . if (DRIVALC >= 3 )
replace DRIVDRG = . if (DRIVDRG >= 3 )
replace DRIVALD = . if (DRIVALD >= 3 )
replace PAROL = . if (PAROL == -9)
replace PROB = . if (PROB == -9)
replace TXEVER = . if (TXEVER >= 81 )
replace TXYREVER = . if (TXYREVER >= 81 )
replace TXYRADG = . if (TXYRADG >= 81 )
replace TXYRHOSP = . if (TXYRHOSP >= 81 )
replace TXYRHPAD = . if (TXYRHPAD >= 81 )
replace TXYRRFIN = . if (TXYRRFIN >= 81 )
replace TXYRINAD = . if (TXYRINAD >= 81 )
replace TXYRRFOP = . if (TXYRRFOP >= 81 )
replace TXYRPOAD = . if (TXYRPOAD >= 81 )
replace TXYRMHC = . if (TXYRMHC >= 81 )
replace TXYRMHAD = . if (TXYRMHAD >= 81 )
replace TXYRTXER = . if (TXYRTXER >= 81 )
replace TXYRERAD = . if (TXYRERAD >= 81 )
replace TXYRDOC = . if (TXYRDOC >= 81 )
replace TXYRDCAD = . if (TXYRDCAD >= 81 )
replace TXYRJAIL = . if (TXYRJAIL >= 81 )
replace TXYRJLAD = . if (TXYRJLAD >= 81 )
replace TXYRSHG = . if (TXYRSHG >= 81 )
replace TXYRSGAD = . if (TXYRSGAD >= 81 )
replace TXYRSOP = . if (TXYRSOP >= 81 )
replace TXYROTS2 = . if (TXYROTS2 >= 981 )
replace TXYROTAD = . if (TXYROTAD >= 81 )
replace TXYRVSER = . if (TXYRVSER >= 81 )
replace TXYRNME2 = . if (TXYRNME2 >= 981 )
replace TXRCVNOW = . if (TXRCVNOW >= 81 )
replace NDTXNEDR = . if (NDTXNEDR >= 81 )
replace NDTXMORE = . if (NDTXMORE >= 81 )
replace NDTMRALC = . if (NDTMRALC >= 81 )
replace NDTMRMJ = . if (NDTMRMJ >= 81 )
replace NDTMRCOC = . if (NDTMRCOC >= 81 )
replace NDTMRHER = . if (NDTMRHER >= 81 )
replace NDTMRHAL = . if (NDTMRHAL >= 81 )
replace NDTMRINH = . if (NDTMRINH >= 81 )
replace NDTMRANL = . if (NDTMRANL >= 81 )
replace NDTMRTRN = . if (NDTMRTRN >= 81 )
replace NDTMRSTM = . if (NDTMRSTM >= 81 )
replace NDTMRSED = . if (NDTMRSED >= 81 )
replace NDTMROTH = . if (NDTMROTH >= 81 )
replace NDTXALCR = . if (NDTXALCR >= 81 )
replace NDTXMJR = . if (NDTXMJR >= 81 )
replace NDTXCOCR = . if (NDTXCOCR >= 81 )
replace NDTXHERR = . if (NDTXHERR >= 81 )
replace NDTXHALR = . if (NDTXHALR >= 81 )
replace NDTXINHR = . if (NDTXINHR >= 81 )
replace NDTXANLR = . if (NDTXANLR >= 81 )
replace NDTXTRNR = . if (NDTXTRNR >= 81 )
replace NDTXSTMR = . if (NDTXSTMR >= 81 )
replace NDTXSEDR = . if (NDTXSEDR >= 81 )
replace NDTXSODR = . if (NDTXSODR >= 81 )
replace NDTXDG1R = . if (NDTXDG1R >= 9981 )
replace NDTXDG2R = . if (NDTXDG2R >= 9981 )
replace NDTXDG3R = . if (NDTXDG3R >= 9981 )
replace NDTXDG4R = . if (NDTXDG4R >= 9981 )
replace NDTXDG5R = . if (NDTXDG5R >= 9981 )
replace NDTXEFTR = . if (NDTXEFTR >= 81 )
replace NDTMREFT = . if (NDTMREFT >= 81 )
replace TXLASREC = . if (TXLASREC >= 81 )
replace TXLTYMN2 = . if (TXLTYMN2 >= 981 )
replace TXLTYALC = . if (TXLTYALC >= 81 )
replace TXLTYMJ = . if (TXLTYMJ >= 81 )
replace TXLTYCOC = . if (TXLTYCOC >= 81 )
replace TXLTYHER = . if (TXLTYHER >= 81 )
replace TXLTYHAL = . if (TXLTYHAL >= 81 )
replace TXLTYINH = . if (TXLTYINH >= 81 )
replace TXLTYANL = . if (TXLTYANL >= 81 )
replace TXLTYTRN = . if (TXLTYTRN >= 81 )
replace TXLTYSTM = . if (TXLTYSTM >= 81 )
replace TXLTYSED = . if (TXLTYSED >= 81 )
replace TXLTYSOD = . if (TXLTYSOD >= 81 )
replace TXLTYOU2 = . if (TXLTYOU2 >= 81 )
replace TXLTYDU2 = . if (TXLTYDU2 >= 99981 )
replace TXPYINS = . if (TXPYINS >= 81 )
replace TXPYCARE = . if (TXPYCARE >= 81 )
replace TXPYCAID = . if (TXPYCAID >= 81 )
replace TXPYPUBP = . if (TXPYPUBP >= 81 )
replace TXPYSAVE = . if (TXPYSAVE >= 81 )
replace TXPYFMLY = . if (TXPYFMLY >= 81 )
replace TXPYCORT = . if (TXPYCORT >= 81 )
replace TXPYMILC = . if (TXPYMILC >= 81 )
replace TXPYEMPL = . if (TXPYEMPL >= 81 )
replace TXPYSOS = . if (TXPYSOS >= 81 )
replace TXPYSP2 = . if (TXPYSP2 >= 81 )
replace TXPYFRE = . if (TXPYFRE >= 81 )
replace TXENROLL = . if (TXENROLL >= 81 )
replace TXYRDTXO = . if (TXYRDTXO >= 81 )
replace AUINPYR = . if (AUINPYR >= 81 )
replace AUINPSYH = . if (AUINPSYH >= 81 )
replace AUINPGEN = . if (AUINPGEN >= 81 )
replace AUINMEDU = . if (AUINMEDU >= 81 )
replace AUINAHSP = . if (AUINAHSP >= 81 )
replace AUINRESD = . if (AUINRESD >= 81 )
replace AUINSFAC = . if (AUINSFAC >= 81 )
replace AUNMPSY2 = . if (AUNMPSY2 >= 981 )
replace AUNMPGE2 = . if (AUNMPGE2 >= 981 )
replace AUNMMEDU = . if (AUNMMEDU >= 981 )
replace AUNMAHSP = . if (AUNMAHSP >= 981 )
replace AUNMRESD = . if (AUNMRESD >= 981 )
replace AUNMSFA2 = . if (AUNMSFA2 >= 981 )
replace AUPINSLF = . if (AUPINSLF >= 81 )
replace AUPINOFM = . if (AUPINOFM >= 81 )
replace AUPINPHI = . if (AUPINPHI >= 81 )
replace AUPINMCR = . if (AUPINMCR >= 81 )
replace AUPINMCD = . if (AUPINMCD >= 81 )
replace AUPINREH = . if (AUPINREH >= 81 )
replace AUPINEMP = . if (AUPINEMP >= 81 )
replace AUPINMIL = . if (AUPINMIL >= 81 )
replace AUPINPUB = . if (AUPINPUB >= 81 )
replace AUPINPRV = . if (AUPINPRV >= 81 )
replace AUPINFRE = . if (AUPINFRE >= 81 )
replace AUPINAMT = . if (AUPINAMT >= 81 )
replace AUOPTYR = . if (AUOPTYR >= 81 )
replace AUOPMENT = . if (AUOPMENT >= 81 )
replace AUOPTHER = . if (AUOPTHER >= 81 )
replace AUOPDOC = . if (AUOPDOC >= 81 )
replace AUOPCLNC = . if (AUOPCLNC >= 81 )
replace AUOPDTMT = . if (AUOPDTMT >= 81 )
replace AUOPOTOP = . if (AUOPOTOP >= 81 )
replace AUOPYRS2 = . if (AUOPYRS2 >= 81 )
replace AUNMMEN2 = . if (AUNMMEN2 >= 981 )
replace AUNMTHE2 = . if (AUNMTHE2 >= 981 )
replace AUNMDOC2 = . if (AUNMDOC2 >= 981 )
replace AUNMCLN2 = . if (AUNMCLN2 >= 981 )
replace AUNMDTM2 = . if (AUNMDTM2 >= 981 )
replace AUNMOTO2 = . if (AUNMOTO2 >= 981 )
replace AUPOPSLF = . if (AUPOPSLF >= 81 )
replace AUPOPOFM = . if (AUPOPOFM >= 81 )
replace AUPOPPHI = . if (AUPOPPHI >= 81 )
replace AUPOPMCR = . if (AUPOPMCR >= 81 )
replace AUPOPMCD = . if (AUPOPMCD >= 81 )
replace AUPOPREH = . if (AUPOPREH >= 81 )
replace AUPOPEMP = . if (AUPOPEMP >= 81 )
replace AUPOPMIL = . if (AUPOPMIL >= 81 )
replace AUPOPPUB = . if (AUPOPPUB >= 81 )
replace AUPOPPRV = . if (AUPOPPRV >= 81 )
replace AUPOPFRE = . if (AUPOPFRE >= 81 )
replace AUPOPMOS = . if (AUPOPMOS >= 81 )
replace AUPOPAMT = . if (AUPOPAMT >= 81 )
replace AURXYR = . if (AURXYR >= 81 )
replace AUUNMTYR = . if (AUUNMTYR >= 81 )
replace AUUNMTRS = . if (AUUNMTRS >= 81 )
replace AMHINP = . if (AMHINP >= 3 )
replace AMHOUTP = . if (AMHOUTP >= 3 )
replace AMHRX = . if (AMHRX >= 3 )
replace AMHTXREC = . if (AMHTXREC >= 3 )
replace AMHTRTND = . if (AMHTRTND >= 3 )
replace SNCRIME = . if (SNCRIME >= 81 )
replace SNSELLDG = . if (SNSELLDG >= 81 )
replace SNPPVAL = . if (SNPPVAL >= 81 )
replace SNSTFGT = . if (SNSTFGT >= 81 )
replace SNEMTBLD = . if (SNEMTBLD >= 81 )
replace SNPPHLP = . if (SNPPHLP >= 81 )
replace SNGRAFTI = . if (SNGRAFTI >= 81 )
replace SNPPVSIT = . if (SNPPVSIT >= 81 )
replace SNPPMOVE = . if (SNPPMOVE >= 81 )
replace SNMOV5Y2 = . if (SNMOV5Y2 >= 981 )
replace SNSPOUSE = . if (SNSPOUSE >= 81 )
replace SNSPACTV = . if (SNSPACTV >= 81 )
replace SNSPANGR = . if (SNSPANGR >= 81 )
replace SNSPHITU = . if (SNSPHITU >= 81 )
replace SNYHITSP = . if (SNYHITSP >= 81 )
replace SNSPCRIT = . if (SNSPCRIT >= 81 )
replace SNSPCONC = . if (SNSPCONC >= 81 )
replace SNFRCONC = . if (SNFRCONC >= 81 )
replace SNFRACTV = . if (SNFRACTV >= 81 )
replace SNFRCARE = . if (SNFRCARE >= 81 )
replace SNYSELL = . if (SNYSELL >= 81 )
replace SNYSTOLE = . if (SNYSTOLE >= 81 )
replace SNYATTAK = . if (SNYATTAK >= 81 )
replace SNFACIG = . if (SNFACIG >= 81 )
replace SNFAMJEV = . if (SNFAMJEV >= 81 )
replace SNFAALDY = . if (SNFAALDY >= 81 )
replace SNFAALDV = . if (SNFAALDV >= 81 )
replace YECRIME = . if (YECRIME >= 81 )
replace YESELLDG = . if (YESELLDG >= 81 )
replace YEPPHLP = . if (YEPPHLP >= 81 )
replace YESTFGT = . if (YESTFGT >= 81 )
replace YEEMTBLD = . if (YEEMTBLD >= 81 )
replace YEPPVSIT = . if (YEPPVSIT >= 81 )
replace YEGRAFTI = . if (YEGRAFTI >= 81 )
replace YEPPMOVE = . if (YEPPMOVE >= 81 )
replace YEMOV5Y2 = . if (YEMOV5Y2 >= 981 )
replace YEENRLYR = . if (YEENRLYR >= 81 )
replace YELSTGRD = . if (YELSTGRD >= 81 )
replace YEYFGTSW = . if (YEYFGTSW >= 81 )
replace YEYFGTGP = . if (YEYFGTGP >= 81 )
replace YEYHGUN = . if (YEYHGUN >= 81 )
replace YEYSELL = . if (YEYSELL >= 81 )
replace YEYSTOLE = . if (YEYSTOLE >= 81 )
replace YEYATTAK = . if (YEYATTAK >= 81 )
replace YEPPKCIG = . if (YEPPKCIG >= 81 )
replace YEPMJEVR = . if (YEPMJEVR >= 81 )
replace YEPALDLY = . if (YEPALDLY >= 81 )
replace YEGPKCIG = . if (YEGPKCIG >= 81 )
replace YEGMJEVR = . if (YEGMJEVR >= 81 )
replace YEGALDLY = . if (YEGALDLY >= 81 )
replace YETLKNON = . if (YETLKNON >= 81 )
replace YETLKPAR = . if (YETLKPAR >= 81 )
replace YETLKSOP = . if (YETLKSOP >= 81 )
replace YEPRTDNG = . if (YEPRTDNG >= 81 )
replace YEBIGBRO = . if (YEBIGBRO >= 81 )
replace YEPRBSLV = . if (YEPRBSLV >= 81 )
replace YEVIOPRV = . if (YEVIOPRV >= 81 )
replace YEYMCA = . if (YEYMCA >= 81 )
replace YESCOUTS = . if (YESCOUTS >= 81 )
replace YEPRVLES = . if (YEPRVLES >= 81 )
replace YEDGPRGP = . if (YEDGPRGP >= 81 )
replace YETEMSPT = . if (YETEMSPT >= 81 )
replace YE4HCLUB = . if (YE4HCLUB >= 81 )
replace YESLFHLP = . if (YESLFHLP >= 81 )
replace YEBAND = . if (YEBAND >= 81 )
replace YESCHCLB = . if (YESCHCLB >= 81 )
replace YEVOLUNT = . if (YEVOLUNT >= 81 )
replace YESTGOVT = . if (YESTGOVT >= 81 )
replace YEPRGSTD = . if (YEPRGSTD >= 81 )
replace YEJBSKIL = . if (YEJBSKIL >= 81 )
replace YECHOIR = . if (YECHOIR >= 81 )
replace YEDECLAS = . if (YEDECLAS >= 81 )
replace YEDERGLR = . if (YEDERGLR >= 81 )
replace YEDESPCL = . if (YEDESPCL >= 81 )
replace YEPVNTYR = . if (YEPVNTYR >= 81 )
replace YECGFRND = . if (YECGFRND >= 81 )
replace YECGVEND = . if (YECGVEND >= 81 )
replace YECGMAI2 = . if (YECGMAI2 >= 81 )
replace YECGCHKO = . if (YECGCHKO >= 81 )
replace YECGCLRK = . if (YECGCLRK >= 81 )
replace YECGINET = . if (YECGINET >= 81 )
replace YECGSMKT = . if (YECGSMKT >= 81 )
replace YECGDSTO = . if (YECGDSTO >= 81 )
replace YECGCONV = . if (YECGCONV >= 81 )
replace YECGINDV = . if (YECGINDV >= 81 )
replace YECGPRUF = . if (YECGPRUF >= 81 )
replace YECGSUCC = . if (YECGSUCC >= 81 )
replace YEPKCRTN = . if (YEPKCRTN >= 81 )
replace YEPDPACK = . if (YEPDPACK >= 81 )
replace YEPDCRTN = . if (YEPDCRTN >= 81 )
replace YEBLNTEV = . if (YEBLNTEV >= 81 )
replace YEBLNT30 = . if (YEBLNT30 >= 81 )
replace YEBL30FQ = . if (YEBL30FQ >= 81 )
replace YECGRWMJ = . if (YECGRWMJ >= 81 )
replace NGHCRIM2 = . if (NGHCRIM2 == -9)
replace NGHSELL2 = . if (NGHSELL2 == -9)
replace NGHHELP2 = . if (NGHHELP2 == -9)
replace NGHFGHT2 = . if (NGHFGHT2 == -9)
replace NGHBLDG2 = . if (NGHBLDG2 == -9)
replace NGHVSIT2 = . if (NGHVSIT2 == -9)
replace NGHGRAF2 = . if (NGHGRAF2 == -9)
replace NGHMOVE2 = . if (NGHMOVE2 == -9)
replace MVIN5YR2 = . if (MVIN5YR2 == -9)
replace PRPKCIG2 = . if (PRPKCIG2 == -9)
replace PRMJEVR2 = . if (PRMJEVR2 == -9)
replace PRALDLY2 = . if (PRALDLY2 == -9)
replace PRTALK3 = . if (PRTALK3 == -9)
replace YOFIGHT2 = . if (YOFIGHT2 == -9)
replace YOGRPFT2 = . if (YOGRPFT2 == -9)
replace YOHGUN2 = . if (YOHGUN2 == -9)
replace YOSELL2 = . if (YOSELL2 == -9)
replace YOSTOLE2 = . if (YOSTOLE2 == -9)
replace YOATTAK2 = . if (YOATTAK2 == -9)
replace YFLPKCG2 = . if (YFLPKCG2 == -9)
replace YFLTMRJ2 = . if (YFLTMRJ2 == -9)
replace YFLADLY2 = . if (YFLADLY2 == -9)
replace YOUTHACT = . if (YOUTHACT == -9)
replace PRBSOLV2 = . if (PRBSOLV2 == -9)
replace PREVIOL2 = . if (PREVIOL2 == -9)
replace PRVDRGO2 = . if (PRVDRGO2 == -9)
replace GRPCNSL2 = . if (GRPCNSL2 == -9)
replace PREGPGM2 = . if (PREGPGM2 == -9)
replace DGSPCLS2 = . if (DGSPCLS2 == -9)
replace DGRGCLS2 = . if (DGRGCLS2 == -9)
replace DRGLECT2 = . if (DRGLECT2 == -9)
replace DRPRVME3 = . if (DRPRVME3 == -9)
replace ANYEDUC3 = . if (ANYEDUC3 == -9)
replace YMSPGRUP = . if (YMSPGRUP >= 81 )
replace YMSPFNTP = . if (YMSPFNTP >= 81 )
replace YMSAHOME = . if (YMSAHOME >= 81 )
replace YMSAACHE = . if (YMSAACHE >= 81 )
replace YMSABDRM = . if (YMSABDRM >= 81 )
replace YMSASLEP = . if (YMSASLEP >= 81 )
replace YMSAABDN = . if (YMSAABDN >= 81 )
replace YMSAUPLV = . if (YMSAUPLV >= 81 )
replace YMSAHMSK = . if (YMSAHMSK >= 81 )
replace YMAGOHSF = . if (YMAGOHSF >= 81 )
replace YMAGCRWD = . if (YMAGCRWD >= 81 )
replace YMAGTRAV = . if (YMAGTRAV >= 81 )
replace YMAGBRDG = . if (YMAGBRDG >= 81 )
replace YMPAATAK = . if (YMPAATAK >= 81 )
replace YMPASUFC = . if (YMPASUFC >= 81 )
replace YMGAWORY = . if (YMGAWORY >= 81 )
replace YMGAHDAC = . if (YMGAHDAC >= 81 )
replace YMGAPAIN = . if (YMGAPAIN >= 81 )
replace YMGATNSE = . if (YMGATNSE >= 81 )
replace YMPHANML = . if (YMPHANML >= 81 )
replace YMPHHIGH = . if (YMPHHIGH >= 81 )
replace YMPHDARK = . if (YMPHDARK >= 81 )
replace YMPHNEDL = . if (YMPHNEDL >= 81 )
replace YMPHBLOD = . if (YMPHBLOD >= 81 )
replace YMPHBRDG = . if (YMPHBRDG >= 81 )
replace YMPHELEV = . if (YMPHELEV >= 81 )
replace YMOCCOUN = . if (YMOCCOUN >= 81 )
replace YMOCWASH = . if (YMOCWASH >= 81 )
replace YMOCCHCK = . if (YMOCCHCK >= 81 )
replace YMOCGERM = . if (YMOCGERM >= 81 )
replace YMOCTHOT = . if (YMOCTHOT >= 81 )
replace YMEATHIN = . if (YMEATHIN >= 81 )
replace YMEAFAT = . if (YMEAFAT >= 81 )
replace YMEATHFD = . if (YMEATHFD >= 81 )
replace YMEABING = . if (YMEABING >= 81 )
replace YMELWTBD = . if (YMELWTBD >= 81 )
replace YMELWTPT = . if (YMELWTPT >= 81 )
replace YMELSOIL = . if (YMELSOIL >= 81 )
replace YMMDNINT = . if (YMMDNINT >= 81 )
replace YMMDLSEG = . if (YMMDLSEG >= 81 )
replace YMMDNOGD = . if (YMMDNOGD >= 81 )
replace YMMDTHKL = . if (YMMDTHKL >= 81 )
replace YMMDTYKL = . if (YMMDTYKL >= 81 )
replace YMMDTIRD = . if (YMMDTIRD >= 81 )
replace YMMDTHNK = . if (YMMDTHNK >= 81 )
replace YMMABDMD = . if (YMMABDMD >= 81 )
replace YMMARSLS = . if (YMMARSLS >= 81 )
replace YMMATALK = . if (YMMATALK >= 81 )
replace YMMASPAB = . if (YMMASPAB >= 81 )
replace YMMAMDRC = . if (YMMAMDRC >= 81 )
replace YMADCONC = . if (YMADCONC >= 81 )
replace YMADFRGT = . if (YMADFRGT >= 81 )
replace YMADFCUS = . if (YMADFCUS >= 81 )
replace YMADMEDS = . if (YMADMEDS >= 81 )
replace YMADAVAT = . if (YMADAVAT >= 81 )
replace YMADERRO = . if (YMADERRO >= 81 )
replace YMODHURT = . if (YMODHURT >= 81 )
replace YMODRFUS = . if (YMODRFUS >= 81 )
replace YMODANOY = . if (YMODANOY >= 81 )
replace YMODMEAN = . if (YMODMEAN >= 81 )
replace YMODBLMO = . if (YMODBLMO >= 81 )
replace YMODTANY = . if (YMODTANY >= 81 )
replace YMODSWOR = . if (YMODSWOR >= 81 )
replace YMCDEXPL = . if (YMCDEXPL >= 81 )
replace YMCDSHPL = . if (YMCDSHPL >= 81 )
replace YMCDLIED = . if (YMCDLIED >= 81 )
replace YMCDSNAT = . if (YMCDSNAT >= 81 )
replace YMCDVAND = . if (YMCDVAND >= 81 )
replace YMCDSTOL = . if (YMCDSTOL >= 81 )
replace YMCDCRUA = . if (YMCDCRUA >= 81 )
replace YMCDBKNT = . if (YMCDBKNT >= 81 )
replace YUHOSPYR = . if (YUHOSPYR >= 81 )
replace YUHOSPN2 = . if (YUHOSPN2 >= 981 )
replace YUHOSUIC = . if (YUHOSUIC >= 81 )
replace YUHODEPR = . if (YUHODEPR >= 81 )
replace YUHOFEAR = . if (YUHOFEAR >= 81 )
replace YUHOBKRU = . if (YUHOBKRU >= 81 )
replace YUHOEATP = . if (YUHOEATP >= 81 )
replace YUHOSOR = . if (YUHOSOR >= 81 )
replace YURSIDYR = . if (YURSIDYR >= 81 )
replace YURSIDN2 = . if (YURSIDN2 >= 981 )
replace YURSSUIC = . if (YURSSUIC >= 81 )
replace YURSDEPR = . if (YURSDEPR >= 81 )
replace YURSFEAR = . if (YURSFEAR >= 81 )
replace YURSBKRU = . if (YURSBKRU >= 81 )
replace YURSEATP = . if (YURSEATP >= 81 )
replace YURSSOR = . if (YURSSOR >= 81 )
replace YUFCARYR = . if (YUFCARYR >= 81 )
replace YUFCARN2 = . if (YUFCARN2 >= 981 )
replace YUFCSUIC = . if (YUFCSUIC >= 81 )
replace YUFCDEPR = . if (YUFCDEPR >= 81 )
replace YUFCFEAR = . if (YUFCFEAR >= 81 )
replace YUFCBKRU = . if (YUFCBKRU >= 81 )
replace YUFCEATP = . if (YUFCEATP >= 81 )
replace YUFCSOR = . if (YUFCSOR >= 81 )
replace YUDYTXYR = . if (YUDYTXYR >= 81 )
replace YUDYTXN2 = . if (YUDYTXN2 >= 981 )
replace YUDYSUIC = . if (YUDYSUIC >= 81 )
replace YUDYDEPR = . if (YUDYDEPR >= 81 )
replace YUDYFEAR = . if (YUDYFEAR >= 81 )
replace YUDYBKRU = . if (YUDYBKRU >= 81 )
replace YUDYEATP = . if (YUDYEATP >= 81 )
replace YUDYSOR = . if (YUDYSOR >= 81 )
replace YUMHCRYR = . if (YUMHCRYR >= 81 )
replace YUMHCRN2 = . if (YUMHCRN2 >= 981 )
replace YUMHSUIC = . if (YUMHSUIC >= 81 )
replace YUMHDEPR = . if (YUMHDEPR >= 81 )
replace YUMHFEAR = . if (YUMHFEAR >= 81 )
replace YUMHBKRU = . if (YUMHBKRU >= 81 )
replace YUMHEATP = . if (YUMHEATP >= 81 )
replace YUMHSOR = . if (YUMHSOR >= 81 )
replace YUTPSTYR = . if (YUTPSTYR >= 81 )
replace YUTPSTN2 = . if (YUTPSTN2 >= 981 )
replace YUTPSUIC = . if (YUTPSUIC >= 81 )
replace YUTPDEPR = . if (YUTPDEPR >= 81 )
replace YUTPFEAR = . if (YUTPFEAR >= 81 )
replace YUTPBKRU = . if (YUTPBKRU >= 81 )
replace YUTPEATP = . if (YUTPEATP >= 81 )
replace YUTPSOR = . if (YUTPSOR >= 81 )
replace YUIHTPYR = . if (YUIHTPYR >= 81 )
replace YUIHTPN2 = . if (YUIHTPN2 >= 981 )
replace YUIHSUIC = . if (YUIHSUIC >= 81 )
replace YUIHDEPR = . if (YUIHDEPR >= 81 )
replace YUIHFEAR = . if (YUIHFEAR >= 81 )
replace YUIHBKRU = . if (YUIHBKRU >= 81 )
replace YUIHEATP = . if (YUIHEATP >= 81 )
replace YUIHSOR = . if (YUIHSOR >= 81 )
replace YUFDOCYR = . if (YUFDOCYR >= 81 )
replace YUFDOCN2 = . if (YUFDOCN2 >= 981 )
replace YUFDSUIC = . if (YUFDSUIC >= 81 )
replace YUFDDEPR = . if (YUFDDEPR >= 81 )
replace YUFDFEAR = . if (YUFDFEAR >= 81 )
replace YUFDBKRU = . if (YUFDBKRU >= 81 )
replace YUFDEATP = . if (YUFDEATP >= 81 )
replace YUFDSOR = . if (YUFDSOR >= 81 )
replace YUSPEDYR = . if (YUSPEDYR >= 81 )
replace YUSHCNYR = . if (YUSHCNYR >= 81 )
replace YUSHSUIC = . if (YUSHSUIC >= 81 )
replace YUSHDEPR = . if (YUSHDEPR >= 81 )
replace YUSHFEAR = . if (YUSHFEAR >= 81 )
replace YUSHBKRU = . if (YUSHBKRU >= 81 )
replace YUSHEATP = . if (YUSHEATP >= 81 )
replace YUSHSOR = . if (YUSHSOR >= 81 )
replace YUJAILEV = . if (YUJAILEV >= 81 )
replace YUFCAREV = . if (YUFCAREV >= 81 )
replace NRCH17_2 = . if (NRCH17_2 == -9)
replace PREGNANT = . if (PREGNANT >= 81 )
replace NMERTMT2 = . if (NMERTMT2 >= 981 )
replace INHOSPYR = . if (INHOSPYR >= 81 )
replace NMNGTHS2 = . if (NMNGTHS2 >= 981 )
replace PROXANS2 = . if (PROXANS2 >= 81 )
replace PREG2 = . if (PREG2 == -9)
replace TRIMEST = . if (TRIMEST == -9)
replace IRWELMOS = . if (IRWELMOS >= 81 )
replace IIWELMOS = . if (IIWELMOS == 9)
replace HLCALLFG = . if (HLCALLFG >= 81 )
replace HLCALL99 = . if (HLCALL99 >= 81 )
replace MEDICARE = . if (MEDICARE >= 81 )
replace MEDICAID = . if (MEDICAID >= 81 )
replace CHAMPUS = . if (CHAMPUS >= 81 )
replace OGOVTINS = . if (OGOVTINS >= 81 )
replace OGOVINS2 = . if (OGOVINS2 >= 981 )
replace PRVHLTIN = . if (PRVHLTIN >= 81 )
replace GRPHLTIN = . if (GRPHLTIN >= 81 )
replace HLTINALC = . if (HLTINALC >= 81 )
replace HLTINDRG = . if (HLTINDRG >= 81 )
replace HLTINMNT = . if (HLTINMNT >= 81 )
replace OTHLTINS = . if (OTHLTINS >= 81 )
replace OTHLINS2 = . if (OTHLINS2 >= 981 )
replace HLCNOTYR = . if (HLCNOTYR >= 81 )
replace HLCNOTMO = . if (HLCNOTMO >= 81 )
replace HLCLAST = . if (HLCLAST >= 81 )
replace HLCPRIVT = . if (HLCPRIVT >= 81 )
replace HLCMCAID = . if (HLCMCAID >= 81 )
replace HLCMILT = . if (HLCMILT >= 81 )
replace HLCMCARE = . if (HLCMCARE >= 81 )
replace HLCOGOVT = . if (HLCOGOVT >= 81 )
replace HLCOTHER = . if (HLCOTHER >= 81 )
replace HLCOTHS2 = . if (HLCOTHS2 >= 90 )
replace HLLLOSJB = . if (HLLLOSJB >= 81 )
replace HLLMAJOB = . if (HLLMAJOB >= 81 )
replace HLLMASOR = . if (HLLMASOR >= 81 )
replace HLLCOST = . if (HLLCOST >= 81 )
replace HLLINELG = . if (HLLINELG >= 81 )
replace HLLNOFFR = . if (HLLNOFFR >= 81 )
replace HLLDIVOR = . if (HLLDIVOR >= 81 )
replace HLLDEATH = . if (HLLDEATH >= 81 )
replace HLLREFUS = . if (HLLREFUS >= 81 )
replace HLLNONED = . if (HLLNONED >= 81 )
replace HLLSOR = . if (HLLSOR >= 81 )
replace HLLSORS2 = . if (HLLSORS2 >= 90 )
replace HLNVCOST = . if (HLNVCOST >= 81 )
replace HLNVOFFR = . if (HLNVOFFR >= 81 )
replace HLNVREF = . if (HLNVREF >= 81 )
replace HLNVNEED = . if (HLNVNEED >= 81 )
replace HLNVSOR = . if (HLNVSOR >= 81 )
replace HLNVSP2 = . if (HLNVSP2 >= 90 )
replace LANGVER = . if (LANGVER >= 81 )
replace GQTYPE = . if (GQTYPE == -9)
replace AGE2 = . if (AGE2 >= 81 )
replace NOMARR2 = . if (NOMARR2 >= 81 )
replace SERVICE = . if (SERVICE >= 81 )
replace MILSTAT = . if (MILSTAT >= 81 )
replace HEALTH = . if (HEALTH >= 81 )
replace IRMARIT = . if (IRMARIT >= 81 )
replace IIMARIT = . if (IIMARIT == 9)
replace IREDUC2 = . if (IREDUC2 >= 81 )
replace MOVESPY2 = . if (MOVESPY2 >= 981 )
replace ENROLED = . if (ENROLED >= 81 )
replace EDUCNOW2 = . if (EDUCNOW2 >= 12 )
replace STUDNT = . if (STUDNT >= 81 )
replace SCHDSICK = . if (SCHDSICK >= 81 )
replace SCHDSKIP = . if (SCHDSKIP >= 81 )
replace HSDIPLMA = . if (HSDIPLMA >= 81 )
replace HSGED = . if (HSGED >= 81 )
replace LFSCHWH2 = . if (LFSCHWH2 >= 981 )
replace LFTSCHA2 = . if (LFTSCHA2 >= 981 )
replace RLGSVCYR = . if (RLGSVCYR >= 81 )
replace RLGIMPRT = . if (RLGIMPRT >= 81 )
replace RLGDECSN = . if (RLGDECSN >= 81 )
replace RLGFRNDS = . if (RLGFRNDS >= 81 )
replace TELNO2 = . if (TELNO2 >= 81 )
replace TUCHTONE = . if (TUCHTONE >= 81 )
replace COLLEGE2 = . if (COLLEGE2 == -9)
replace JOBSTAT2 = . if (JOBSTAT2 >= 10 )
replace JBSTATR2 = . if (JBSTATR2 >= 10 )
replace WRKHAVJB = . if (WRKHAVJB >= 81 )
replace WRKHRSWK = . if (WRKHRSWK >= 981 )
replace WRKINDU2 = . if (WRKINDU2 >= 981 )
replace WRKOCCU2 = . if (WRKOCCU2 >= 981 )
replace WRKBZCA2 = . if (WRKBZCA2 >= 81 )
replace WRKEFFRT = . if (WRKEFFRT >= 81 )
replace WRKEDYR = . if (WRKEDYR >= 81 )
replace WRKSLFEM = . if (WRKSLFEM >= 81 )
replace WRKJOBS2 = . if (WRKJOBS2 >= 981 )
replace WRKUNEMP = . if (WRKUNEMP >= 81 )
replace WRKUNWKS = . if (WRKUNWKS >= 81 )
replace WRKLASY2 = . if (WRKLASY2 >= 9981 )
replace WRKINDY2 = . if (WRKINDY2 >= 981 )
replace WRKOCCY2 = . if (WRKOCCY2 >= 981 )
replace WORKDAYS = . if (WORKDAYS >= 81 )
replace WORKBLAH = . if (WORKBLAH >= 81 )
replace LOCSIZE = . if (LOCSIZE >= 81 )
replace DRGPLCY = . if (DRGPLCY >= 81 )
replace PLCYCOV = . if (PLCYCOV >= 81 )
replace WKDRGED = . if (WKDRGED >= 81 )
replace DRGPRGM = . if (DRGPRGM >= 81 )
replace USALCTST = . if (USALCTST >= 81 )
replace USDRGTST = . if (USDRGTST >= 81 )
replace TSTHIRE = . if (TSTHIRE >= 81 )
replace TSTRAND = . if (TSTRAND >= 81 )
replace FIRSTPOS = . if (FIRSTPOS >= 81 )
replace WRKHIRE = . if (WRKHIRE >= 81 )
replace WORKRAND = . if (WORKRAND >= 81 )
replace VESTR = . if (VESTR >= 99981 )


*/
/********************************************************************

 Section 5: Save Outfile

  This section saves out a Stata system format file.  There is no reason to
  modify it if the macros in Section 1 were specified correctly.

*********************************************************************/

save `outfile', replace

