*-------------------------------------------------------------------------*
*                                                                          
*                     SPSS SETUP FILE FOR ICPSR 03262
*              NATIONAL HOUSEHOLD SURVEY ON DRUG ABUSE, 2000
* 
*
*  SPSS setup sections are provided for the ASCII version of this data
*  collection.  These sections are listed below:
*
*  DATA LIST:  assigns the name, type, decimal specification (if any),
*  and specifies the beginning and ending column locations for each
*  variable in the data file. Users must replace the "data-filename"
*  in the DATA LIST statement with a filename specifying the directory
*  on the user's computer system in which the downloaded and unzipped
*  data file is physically located (e.g., "c:\temp\03262-0001-data.txt").
*
*  VARIABLE LABELS:  assigns descriptive labels to all variables.
*  Labels and variable names may be identical for some data files.
*
*  MISSING VALUES: declares user-defined missing values. Not all
*  variables in this data set necessarily have user-defined missing
*  values. These values can be treated specially in data transformations,
*  statistical calculations, and case selection.
*
*  VALUE LABELS: assigns descriptive labels to codes found in the data
*  file.  Not all codes necessarily have assigned value labels.
*
*  NOTE:  Users should modify this setup file to suit their specific 
*  needs. The MISSING VALUES section has been commented out (i.e., '*').
*  To include the MISSING VALUES section in the final SPSS setup, remove 
*  the comment indicators from the desired section.
*
*  CREATING A PERMANENT SPSS DATA FILE: If users wish to create and save
*  an SPSS data file for further analysis using SPSS for Windows, the
*  necessary "SAVE OUTFILE" command is provided in the last line of
*  this file.  To activate the command, users must delete the leading
*  asterisk (*) and replace "spss-filename" with a filename specifying
*  the location on the user's computer system to which the new data file
*  will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\da03262-0001.sav").
*
*-------------------------------------------------------------------------.

* SPSS FILE HANDLE AND DATA LIST COMMANDS.

FILE HANDLE DATA / NAME="data-filename" LRECL=4074.
DATA LIST FILE=DATA /
              CASEID 1-5            QUESTID 6-12           CIGEVER 13-14
          CIGOFRSM 15-16          CIGWILYR 17-18            CIGTRY 19-21
            CIGYFU 22-25            CIGMFU 26-27            CIGREC 28-29
          CIG30USE 30-31           CG30EST 32-33           CIG30AV 34-35
          CIG30BR2 36-39          CIG30TYP 40-41          CIG30MEN 42-43
          CIG30RO2 44-45          CIGDLYMO 46-47            CIGAGE 48-50
          CIG100LF 51-52          CHEWEVER 53-54           CHEWTRY 55-57
           CHEWYFU 58-61           CHEWMFU 62-63           CHEWREC 64-65
          CHW30USE 66-67           CH30EST 68-69          CHW30BR2 70-73
           SNFEVER 74-75           SNUFTRY 76-78           SNUFYFU 79-82
           SNUFMFU 83-84            SNFREC 85-86          SNF30USE 87-88
           SN30EST 89-90          SNF30BR2 91-94            SLTTRY 95-97
           SLTYFU 98-101          SLTMFU 102-103          SLTREC 104-105
        SLT30BR2 106-109        SLT30FAV 110-111        CIGAREVR 112-113
        CIGARTRY 114-116        CIGARYFU 117-120        CIGARMFU 121-122
        CIGARREC 123-124        CGR30USE 125-126         CI30EST 127-128
        CGR30BR2 129-132         PIPEVER 133-134        PIPE30DY 135-136
         ALCEVER 137-138          ALCTRY 139-141          ALCYFU 142-145
          ALCMFU 146-147          ALCREC 148-149        ALCYRTOT 150-152
         ALTOTFG 153-154         ALFQFLG 155-156        ALBSTWAY 157-158
        ALDAYPYR 159-161        ALDAYPMO 162-163        ALDAYPWK 164-165
         ALCDAYS 166-167         AL30EST 168-169         ALDYSFG 170-171
         NODR30A 172-174          DR5DAY 175-176          MJEVER 177-178
           MJAGE 179-181           MJYFU 182-185           MJMFU 186-187
           MJREC 188-189         MJYRTOT 190-192         MRTOTFG 193-194
         MJFQFLG 195-196        MRBSTWAY 197-198        MRDAYPYR 199-201
        MRDAYPMO 202-203        MRDAYPWK 204-205        MJDAY30A 206-207
         MR30EST 208-209         COCEVER 210-211          COCAGE 212-214
          COCYFU 215-218          COCMFU 219-220          COCREC 221-222
        COCYRTOT 223-225         CCTOTFG 226-227         CCFQFLG 228-229
        CCBSTWAY 230-231        CCDAYPYR 232-234        CCDAYPMO 235-236
        CCDAYPWK 237-238        COCUS30A 239-240         CC30EST 241-242
         CRKEVER 243-244          CRKAGE 245-247          CRKYFU 248-251
          CRKMFU 252-253         CRAKREC 254-255        CRKYRTOT 256-258
         CRTOTFG 259-260         CRFQFLG 261-262        CRBSTWAY 263-264
        CRDAYPYR 265-267        CRDAYPMO 268-269        CRDAYPWK 270-271
        CRKUS30A 272-273         CR30EST 274-275         HEREVER 276-277
          HERAGE 278-280          HERYFU 281-284          HERMFU 285-286
          HERREC 287-288        HERYRTOT 289-291         HRTOTFG 292-293
         HRFQFLG 294-295        HRBSTWAY 296-297        HRDAYPYR 298-300
        HRDAYPMO 301-302        HRDAYPWK 303-304        HER30USE 305-306
         HR30EST 307-308             LSD 309-310             PCP 311-312
          PEYOTE 313-314            MESC 315-316          PSILCY 317-318
         ECSTASY 319-320        HALNOLST 321-322         HALNEWA 323-326
         HALNEWB 327-330         HALNEWC 331-334         HALNEWD 335-338
         HALNEWE 339-342         HALLAGE 343-345          HALYFU 346-349
          HALMFU 350-351         HALLREC 352-353        HALYRTOT 354-356
         HLTOTFG 357-358         HLFQFLG 359-360        HLBSTWAY 361-362
        HLDAYPYR 363-365        HLDAYPMO 366-367        HLDAYPWK 368-369
        HAL30USE 370-371         HL30EST 372-373          LSDAGE 374-376
          LSDYFU 377-380          LSDMFU 381-382          LSDREC 383-384
          PCPAGE 385-387          PCPYFU 388-391          PCPMFU 392-393
          PCPREC 394-395         AMYLNIT 396-397          CLEFLU 398-399
             GAS 400-401            GLUE 402-403           ETHER 404-405
         SOLVENT 406-407            LGAS 408-409         NITOXID 410-411
         SPPAINT 412-413           AEROS 414-415        INHNOLST 416-417
         INHNEWA 418-421         INHNEWB 422-425         INHNEWC 426-429
         INHNEWD 430-433         INHNEWE 434-437          INHAGE 438-440
          INHYFU 441-444          INHMFU 445-446          INHREC 447-448
        INHYRTOT 449-451         INTOTFG 452-453         INFQFLG 454-455
        INBSTWAY 456-457        INDAYPYR 458-460        INDAYPMO 461-462
        INDAYPWK 463-464        INHDY30A 465-466         IN30EST 467-468
        DARVTYLC 469-470        PERCTYLX 471-472         VICOLOR 473-474
         ANLCARD 475-476         CODEINE 477-478         DEMEROL 479-480
          DILAUD 481-482        FIORICET 483-484        FIORINAL 485-486
        HYDROCOD 487-488         METHDON 489-490        MORPHINE 491-492
        OXYCONTN 493-494         PHENCOD 495-496         PROPOXY 497-498
           SK65A 499-500          STADOL 501-502         TALACEN 503-504
          TALWIN 505-506        TALWINNX 507-508        TRAMADOL 509-510
          ULTRAM 511-512        ANLNOLST 513-514        ANALNEWA 515-518
        ANALNEWB 519-522        ANALNEWC 523-526        ANALNEWD 527-530
        ANALNEWE 531-534         ANALAGE 535-537         ANALYFU 538-541
         ANALMFU 542-543         ANALREC 544-545        ANLYRTOT 546-548
         PRTOTFG 549-550         PRFQFLG 551-552        PRBSTWAY 553-554
        PRDAYPYR 555-557        PRDAYPMO 558-559        PRDAYPWK 560-561
        KLONOPIN 562-563        XNAXATVN 564-565        VALMDIAZ 566-567
         TRNCARD 568-569          ATARAX 570-571          BUSPAR 572-573
         EQUANIL 574-575        FLEXERIL 576-577         LIBRIUM 578-579
        LIMBTROL 580-581          MEPROB 582-583         MILTOWN 584-585
        ROHYPNOL 586-587           SERAX 588-589            SOMA 590-591
        TRANXENE 592-593          VISTAR 594-595         TRNOLST 596-597
          TRNEWA 598-601          TRNEWB 602-605          TRNEWC 606-609
          TRNEWD 610-613          TRNEWE 614-617         TRANAGE 618-620
         TRANYFU 621-624         TRANMFU 625-626         TRANREC 627-628
        TRNYRTOT 629-631         TRTOTFG 632-633         TRFQFLG 634-635
        TRBSTWAY 636-637        TRDAYPYR 638-640        TRDAYPMO 641-642
        TRDAYPWK 643-644         METHDES 645-646        DIETPILS 647-648
        RITMPHEN 649-650         STMCARD 651-652          CYLERT 653-654
           DEXED 655-656          DETAMP 657-658          DIDREX 659-660
           ESKAT 661-662         IONAMIN 663-664         MAZANOR 665-666
            OBLA 667-668         PLEGINE 669-670        PRELUDIN 671-672
         SANOREX 673-674         TENUATE 675-676        STMNOLST 677-678
        STIMNEWA 679-682        STIMNEWB 683-686        STIMNEWC 687-690
        STIMNEWD 691-694        STIMNEWE 695-698         STIMAGE 699-701
         STIMYFU 702-705         STIMMFU 706-707         STIMREC 708-709
        STMYRTOT 710-712         STTOTFG 713-714         STFQFLG 715-716
        STBSTWAY 717-718        STDAYPYR 719-721        STDAYPMO 722-723
        STDAYPWK 724-725         METHAGE 726-728         METHYFU 729-732
         METHMFU 733-734         METHREC 735-736          METHAQ 737-738
        NEMBBARB 739-740        RESTTMAZ 741-742         SEDCARD 743-744
          AMYTAL 745-746         BUTISOL 747-748           CHHYD 749-750
         DALMANE 751-752         HALCION 753-754        PHENOBAR 755-756
        PLACIDYL 757-758          TUINAL 759-760        SEDNOLST 761-762
         SEDNEWA 763-766         SEDNEWB 767-770         SEDNEWC 771-774
         SEDNEWD 775-778         SEDNEWE 779-782          SEDAGE 783-785
          SEDYFU 786-789          SEDMFU 790-791          SEDREC 792-793
        SEDYRTOT 794-796         SVTOTFG 797-798         SVFQFLG 799-800
        SVBSTWAY 801-802        SVDAYPYR 803-805        SVDAYPMO 806-807
        SVDAYPWK 808-809         IRCIGRC 810-811         IICIGRC 812-813
        II2CIGRC 814-815         IRCGRRC 816-817         IICGRRC 818-819
        II2CGRRC 820-821         IRPIPLF 822-823         IIPIPLF 824-825
         IRPIPMN 826-827         IIPIPMN 828-829         IRSLTRC 830-831
         IISLTRC 832-833        II2SLTRC 834-835         IRCHWRC 836-837
         IICHWRC 838-839        II2CHWRC 840-841         IRSNFRC 842-843
         IISNFRC 844-845        II2SNFRC 846-847         IRALCRC 848-849
         IIALCRC 850-851        II2ALCRC 852-853          IRMJRC 854-855
          IIMJRC 856-857         II2MJRC 858-859         IRCOCRC 860-861
         IICOCRC 862-863        II2COCRC 864-865         IRCRKRC 866-867
         IICRKRC 868-869        II2CRKRC 870-871         IRHERRC 872-873
         IIHERRC 874-875        II2HERRC 876-877         IRHALRC 878-879
         IIHALRC 880-881        II2HALRC 882-883         IRLSDRC 884-885
         IILSDRC 886-887        II2LSDRC 888-889         IRPCPRC 890-891
         IIPCPRC 892-893        II2PCPRC 894-895         IRINHRC 896-897
         IIINHRC 898-899        II2INHRC 900-901         IRANLRC 902-903
         IIANLRC 904-905        II2ANLRC 906-907         IRTRNRC 908-909
         IITRNRC 910-911        II2TRNRC 912-913         IRSTMRC 914-915
         IISTMRC 916-917        II2STMRC 918-919         IRMTHRC 920-921
         IIMTHRC 922-923        II2MTHRC 924-925         IRSEDRC 926-927
         IISEDRC 928-929        II2SEDRC 930-931         IRALCFY 932-934
         IIALCFY 935-936        II2ALCFY 937-938          IRMJFY 939-941
          IIMJFY 942-943         II2MJFY 944-945         IRCOCFY 946-948
         IICOCFY 949-950        II2COCFY 951-952         IRCRKFY 953-955
         IICRKFY 956-957        II2CRKFY 958-959         IRHERFY 960-962
         IIHERFY 963-964        II2HERFY 965-966         IRHALFY 967-969
         IIHALFY 970-971        II2HALFY 972-973         IRINHFY 974-976
         IIINHFY 977-978        II2INHFY 979-980         IRANLFY 981-983
         IIANLFY 984-985        II2ANLFY 986-987         IRTRNFY 988-990
         IITRNFY 991-992        II2TRNFY 993-994         IRSTMFY 995-997
         IISTMFY 998-999      II2STMFY 1000-1001       IRSEDFY 1002-1004
       IISEDFY 1005-1006      II2SEDFY 1007-1008   IRCIGFM 1009-1013 (2)
       IICIGFM 1014-1015      II2CIGFM 1016-1017   IRCGRFM 1018-1022 (2)
       IICGRFM 1023-1024      II2CGRFM 1025-1026   IRCHWFM 1027-1031 (2)
       IICHWFM 1032-1033      II2CHWFM 1034-1035   IRSNFFM 1036-1040 (2)
       IISNFFM 1041-1042      II2SNFFM 1043-1044   IRALCFM 1045-1049 (2)
       IIALCFM 1050-1051      II2ALCFM 1052-1053       IRALCD5 1054-1055
       IIALCD5 1056-1057      II2ALCD5 1058-1059    IRMJFM 1060-1064 (2)
        IIMJFM 1065-1066       II2MJFM 1067-1068   IRCOCFM 1069-1073 (2)
       IICOCFM 1074-1075      II2COCFM 1076-1077   IRCRKFM 1078-1082 (2)
       IICRKFM 1083-1084      II2CRKFM 1085-1086       IRHERFM 1087-1088
       IIHERFM 1089-1090      II2HERFM 1091-1092   IRHALFM 1093-1097 (2)
       IIHALFM 1098-1099      II2HALFM 1100-1101   IRINHFM 1102-1106 (2)
       IIINHFM 1107-1108      II2INHFM 1109-1110      IRCIGAGE 1111-1113
      IICIGAGE 1114-1115      IRCIGYFU 1116-1119      IICIGYFU 1120-1121
      IRCDUAGE 1122-1124      IICDUAGE 1125-1126      IRCDUYFU 1127-1130
      IICDUYFU 1131-1132      IRCGRAGE 1133-1135      IICGRAGE 1136-1137
      IRCGRYFU 1138-1141      IICGRYFU 1142-1143      IRSNFAGE 1144-1146
      IISNFAGE 1147-1148      IRSNFYFU 1149-1152      IISNFYFU 1153-1154
      IRCHWAGE 1155-1157      IICHWAGE 1158-1159      IRCHWYFU 1160-1163
      IICHWYFU 1164-1165      IRSLTAGE 1166-1168      IISLTAGE 1169-1170
      IRSLTYFU 1171-1174      IISLTYFU 1175-1176      IRALCAGE 1177-1179
      IIALCAGE 1180-1181      IRALCYFU 1182-1185      IIALCYFU 1186-1187
       IRMJAGE 1188-1190       IIMJAGE 1191-1192       IRMJYFU 1193-1196
       IIMJYFU 1197-1198      IRCOCAGE 1199-1201      IICOCAGE 1202-1203
      IRCOCYFU 1204-1207      IICOCYFU 1208-1209      IRCRKAGE 1210-1212
      IICRKAGE 1213-1214      IRCRKYFU 1215-1218      IICRKYFU 1219-1220
      IRHERAGE 1221-1223      IIHERAGE 1224-1225      IRHERYFU 1226-1229
      IIHERYFU 1230-1231      IRHALAGE 1232-1234      IIHALAGE 1235-1236
      IRHALYFU 1237-1240      IIHALYFU 1241-1242      IRLSDAGE 1243-1245
      IILSDAGE 1246-1247      IRLSDYFU 1248-1251      IILSDYFU 1252-1253
      IRPCPAGE 1254-1256      IIPCPAGE 1257-1258      IRPCPYFU 1259-1262
      IIPCPYFU 1263-1264      IRINHAGE 1265-1267      IIINHAGE 1268-1269
      IRINHYFU 1270-1273      IIINHYFU 1274-1275      IRANLAGE 1276-1278
      IIANLAGE 1279-1280      IRANLYFU 1281-1284      IIANLYFU 1285-1286
      IRTRNAGE 1287-1289      IITRNAGE 1290-1291      IRTRNYFU 1292-1295
      IITRNYFU 1296-1297      IRSTMAGE 1298-1300      IISTMAGE 1301-1302
      IRSTMYFU 1303-1306      IISTMYFU 1307-1308      IRMTHAGE 1309-1311
      IIMTHAGE 1312-1313      IRMTHYFU 1314-1317      IIMTHYFU 1318-1319
      IRSEDAGE 1320-1322      IISEDAGE 1323-1324      IRSEDYFU 1325-1328
      IISEDYFU 1329-1330       CIGFLAG 1331-1332         CIGYR 1333-1334
        CIGMON 1335-1336       CGRFLAG 1337-1338         CGRYR 1339-1340
        CGRMON 1341-1342       PIPFLAG 1343-1344        PIPMON 1345-1346
       SMKFLAG 1347-1348         SMKYR 1349-1350        SMKMON 1351-1352
       CHWFLAG 1353-1354         CHWYR 1355-1356        CHWMON 1357-1358
       SNFFLAG 1359-1360         SNFYR 1361-1362        SNFMON 1363-1364
       TOBFLAG 1365-1366         TOBYR 1367-1368        TOBMON 1369-1370
      CIGBRND2 1371-1372      CGRBRND2 1373-1374      SMKBRND2 1375-1376
      CIGCMPNY 1377-1378       ALCFLAG 1379-1380         ALCYR 1381-1382
        ALCMON 1383-1384       MRJFLAG 1385-1386         MRJYR 1387-1388
        MRJMON 1389-1390       COCFLAG 1391-1392         COCYR 1393-1394
        COCMON 1395-1396       CRKFLAG 1397-1398         CRKYR 1399-1400
        CRKMON 1401-1402       HERFLAG 1403-1404         HERYR 1405-1406
        HERMON 1407-1408       HALFLAG 1409-1410         HALYR 1411-1412
        HALMON 1413-1414       LSDFLAG 1415-1416         LSDYR 1417-1418
        LSDMON 1419-1420       PCPFLAG 1421-1422         PCPYR 1423-1424
        PCPMON 1425-1426       INHFLAG 1427-1428         INHYR 1429-1430
        INHMON 1431-1432       ANLFLAG 1433-1434         ANLYR 1435-1436
        ANLMON 1437-1438       TRQFLAG 1439-1440         TRQYR 1441-1442
        TRQMON 1443-1444       STMFLAG 1445-1446         STMYR 1447-1448
        STMMON 1449-1450       MTHFLAG 1451-1452         MTHYR 1453-1454
        MTHMON 1455-1456       SEDFLAG 1457-1458         SEDYR 1459-1460
        SEDMON 1461-1462      PSYFLAG2 1463-1464        PSYYR2 1465-1466
       PSYMON2 1467-1468       SUMFLAG 1469-1470         SUMYR 1471-1472
        SUMMON 1473-1474       MJOFLAG 1475-1476        MJOYR2 1477-1478
       MJOMON2 1479-1480       IEMFLAG 1481-1482         IEMYR 1483-1484
        IEMMON 1485-1486      BINGEDRK 1487-1488       HVYDRK2 1489-1490
      BINGEHVY 1491-1492       PEYOTE2 1493-1494         MESC2 1495-1496
       PSILCY2 1497-1498      ECSTASY2 1499-1500      AMYLNIT2 1501-1502
       CLEFLU2 1503-1504          GAS2 1505-1506         GLUE2 1507-1508
        ETHER2 1509-1510      SOLVENT2 1511-1512         LGAS2 1513-1514
      NITOXID2 1515-1516      SPPAINT2 1517-1518        AEROS2 1519-1520
      DARVTYL2 1521-1522      PERCTYL2 1523-1524      VICOLOR2 1525-1526
      CODEINE2 1527-1528      DEMEROL2 1529-1530       DILAUD2 1531-1532
      FIORICT2 1533-1534      FIORINL2 1535-1536      HYDROCD2 1537-1538
      METHDON2 1539-1540      MORPHIN2 1541-1542      OXYCONT2 1543-1544
      PHENCOD2 1545-1546      PROPOXY2 1547-1548        SK65A2 1549-1550
       STADOL2 1551-1552      TALACEN2 1553-1554       TALWIN2 1555-1556
      TALWINX2 1557-1558      TRAMADL2 1559-1560       ULTRAM2 1561-1562
        OTHANL 1563-1564      KLONOPI2 1565-1566      XNAXATV2 1567-1568
      VALMDIA2 1569-1570       ATARAX2 1571-1572       BUSPAR2 1573-1574
      EQUANIL2 1575-1576      FLEXERL2 1577-1578      LIBRIUM2 1579-1580
      LIMBTRL2 1581-1582       MEPROB2 1583-1584      MILTOWN2 1585-1586
      ROHYPNL2 1587-1588        SERAX2 1589-1590         SOMA2 1591-1592
      TRANXEN2 1593-1594       VISTAR2 1595-1596        OTHTRN 1597-1598
      METHDES2 1599-1600      DIETPIL2 1601-1602      RITMPHE2 1603-1604
       CYLERT2 1605-1606        DEXED2 1607-1608       DETAMP2 1609-1610
       DIDREX2 1611-1612        ESKAT2 1613-1614      IONAMIN2 1615-1616
      MAZANOR2 1617-1618         OBLA2 1619-1620      PLEGINE2 1621-1622
      PRELUDN2 1623-1624      SANOREX2 1625-1626      TENUATE2 1627-1628
        OTHSTM 1629-1630       METHAQ2 1631-1632      NEMBBAR2 1633-1634
      RESTTMA2 1635-1636       AMYTAL2 1637-1638      BUTISOL2 1639-1640
        CHHYD2 1641-1642      DALMANE2 1643-1644      HALCION2 1645-1646
      PHENOBR2 1647-1648      PLACIDY2 1649-1650       TUINAL2 1651-1652
        OTHSED 1653-1654        ALCAFU 1655-1656         MJAFU 1657-1658
        COCAFU 1659-1660        HERAFU 1661-1662        HALAFU 1663-1664
        INHAFU 1665-1666        ANLAFU 1667-1668        TRNAFU 1669-1670
        STMAFU 1671-1672        SEDAFU 1673-1674        CIGAFU 1675-1676
        CGRAFU 1677-1678        SLTAFU 1679-1680      MRJYDAYS 1681-1682
      COCYDAYS 1683-1684      HALYDAYS 1685-1686      INHYDAYS 1687-1688
      ALCYDAYS 1689-1690      MRJMDAYS 1691-1692      COCMDAYS 1693-1694
      HALMDAYS 1695-1696      INHMDAYS 1697-1698      ALCMDAYS 1699-1700
      CIGMDAYS 1701-1702       CIGPDAY 1703-1704          CG05 1705-1706
          CG06 1707-1708        CG06DK 1709-1710        CG06RE 1711-1712
          CG19 1713-1714          CG20 1715-1716        CG20DK 1717-1718
        CG20RE 1719-1720          CG27 1721-1722          CG28 1723-1724
        CG28DK 1725-1726        CG28RE 1727-1728          CG36 1729-1730
          CG37 1731-1732        CG37DK 1733-1734        CG37RE 1735-1736
          CG43 1737-1738       ALLAST3 1739-1740       ALRECDK 1741-1742
       ALRECRE 1743-1744      TOTDRINK 1745-1747      ALFRAME3 1748-1749
       ALYRAVE 1750-1752      ALMONAVE 1753-1754       ALWKAVE 1755-1756
       MJLAST3 1757-1758       MJRECDK 1759-1760       MJRECRE 1761-1762
         TOTMJ 1763-1765      MJFRAME3 1766-1767       MJYRAVE 1768-1770
      MJMONAVE 1771-1772       MJWKAVE 1773-1774       CCLAST3 1775-1776
       CCRECDK 1777-1778       CCRECRE 1779-1780       TOTCOKE 1781-1783
      CCFRAME3 1784-1785       CCYRAVE 1786-1788      CCMONAVE 1789-1790
       CCWKAVE 1791-1792       CKLAST3 1793-1794       CKRECDK 1795-1796
       CKRECRE 1797-1798      TOTCRACK 1799-1801      CKFRAME3 1802-1803
       CKYRAVE 1804-1806      CKMONAVE 1807-1808       CKWKAVE 1809-1810
       HELAST3 1811-1812       HERECDK 1813-1814       HERECRE 1815-1816
       TOTHERO 1817-1819      HEFRAME3 1820-1821       HEYRAVE 1822-1824
      HEMONAVE 1825-1826       HEWKAVE 1827-1828        LSLAST 1829-1830
       LSRECDK 1831-1832       LSRECRE 1833-1834       TOTHALL 1835-1837
      LSFRAME3 1838-1839       LSYRAVE 1840-1842      LSMONAVE 1843-1844
       LSWKAVE 1845-1846          LS10 1847-1848          LS16 1849-1850
        INLAST 1851-1852       INRECDK 1853-1854       INRECRE 1855-1856
      TOTINHAL 1857-1859      INFRAME3 1860-1861       INYRAVE 1862-1864
      INMONAVE 1865-1866       INWKAVE 1867-1868          PR09 1869-1870
       PRRECDK 1871-1872       PRRECRE 1873-1874          PR10 1875-1876
          PR11 1877-1879          PR12 1880-1881          PR13 1882-1883
          TR09 1884-1885       TRRECDK 1886-1887       TRRECRE 1888-1889
          TR10 1890-1891          TR11 1892-1894          TR12 1895-1896
          TR13 1897-1898          ST09 1899-1900       STRECDK 1901-1902
       STRECRE 1903-1904          ST10 1905-1906          ST11 1907-1909
          ST12 1910-1911          ST13 1912-1913          ST19 1914-1915
          SV09 1916-1917       SVRECDK 1918-1919       SVRECRE 1920-1921
          SV10 1922-1923          SV11 1924-1926          SV12 1927-1928
          SV13 1929-1930      HERSMOKE 1931-1932      HRSMKREC 1933-1934
      HERSNIFF 1935-1936      HRSNFREC 1937-1938      GNNDLLIF 1939-1940
      COCNEEDL 1941-1942      CONDLREC 1943-1944      HERNEEDL 1945-1946
      HRNDLREC 1947-1948      STNEEDLE 1949-1950      STNDLREC 1951-1952
      GNNDREUS 1953-1954      GNNDLSH1 1955-1956      GNNDCLEN 1957-1958
      GNNDLSH2 1959-1960      GNNDGET2 1961-1962      NEDLRECC 1963-1964
      NEDFLAG4 1965-1966      HERSMOK2 1967-1968      HERSNIF2 1969-1970
        NEDHER 1971-1972        NEDCOC 1973-1974        NEDSTM 1975-1976
      RSKPKCIG 1977-1978      RSKMJOCC 1979-1980      RSKMJREG 1981-1982
      RKTRYLSD 1983-1984      RKLSDREG 1985-1986      RKTRYHER 1987-1988
      RKHERREG 1989-1990      RKCOCOCC 1991-1992      RKCOCREG 1993-1994
      RK5ALDLY 1995-1996       RK5ALWK 1997-1998      RSKDIFMJ 1999-2000
      RKDIFLSD 2001-2002      RKDIFCOC 2003-2004      RKDIFCRK 2005-2006
      RKDIFHER 2007-2008       RSKSELL 2009-2010      RKFQDNGR 2011-2012
      RKFQRSKY 2013-2014      RKFQPBLT 2015-2016      RKFQDBLT 2017-2018
      GRSKPKCG 2019-2020      GRSKCREG 2021-2022      GRSKCOCC 2023-2024
      GRSKMREG 2025-2026      GRSKMOCC 2027-2028      GRSKHTRY 2029-2030
      GRSKHREG 2031-2032      GRSKLTRY 2033-2034      GRSKLREG 2035-2036
      GRSKD4_5 2037-2038      GRSKD5WK 2039-2040        RDIFMJ 2041-2042
       RDIFCOC 2043-2044       RDIFHER 2045-2046       RDIFLSD 2047-2048
       RDIFCRK 2049-2050      APPSELDG 2051-2052      CIGLOTTM 2053-2054
      CIGLIMIT 2055-2056      CIGKPLMT 2057-2058      CIGNDMOR 2059-2060
      CIGLSEFX 2061-2062      CIGCUTDN 2063-2064      CIGCUTEV 2065-2066
      CIGCUT1X 2067-2068      CIGWD4SX 2069-2070      CIGWDSMT 2071-2072
      CIGEMOPB 2073-2074      CIGEMCTD 2075-2076      CIGPHLPB 2077-2078
      CIGPHCTD 2079-2080      CIGLSACT 2081-2082      CIGPKCRT 2083-2084
      CIGPDPAK 2085-2086      CIGPDCRT 2087-2088      ALCLOTTM 2089-2090
      ALCGTOVR 2091-2092      ALCLIMIT 2093-2094      ALCKPLMT 2095-2096
      ALCNDMOR 2097-2098      ALCLSEFX 2099-2100      ALCCUTDN 2101-2102
      ALCCUTEV 2103-2104      ALCCUT1X 2105-2106      ALCWD2SX 2107-2108
      ALCWDSMT 2109-2110      ALCEMOPB 2111-2112      ALCEMCTD 2113-2114
      ALCPHLPB 2115-2116      ALCPHCTD 2117-2118      ALCLSACT 2119-2120
      ALCSERPB 2121-2122      ALCPDANG 2123-2124      ALCLAWTR 2125-2126
      ALCFMFPB 2127-2128      ALCFMCTD 2129-2130      MRJLOTTM 2131-2132
      MRJGTOVR 2133-2134      MRJLIMIT 2135-2136      MRJKPLMT 2137-2138
      MRJNDMOR 2139-2140      MRJLSEFX 2141-2142      MRJCUTDN 2143-2144
      MRJCUTEV 2145-2146      MRJEMOPB 2147-2148      MRJEMCTD 2149-2150
      MRJPHLPB 2151-2152      MRJPHCTD 2153-2154      MRJLSACT 2155-2156
      MRJSERPB 2157-2158      MRJPDANG 2159-2160      MRJLAWTR 2161-2162
      MRJFMFPB 2163-2164      MRJFMCTD 2165-2166      COCLOTTM 2167-2168
      COCGTOVR 2169-2170      COCLIMIT 2171-2172      COCKPLMT 2173-2174
      COCNDMOR 2175-2176      COCLSEFX 2177-2178      COCCUTDN 2179-2180
      COCCUTEV 2181-2182      COCCUT1X 2183-2184      COCFLBLU 2185-2186
      COCWD2SX 2187-2188      COCWDSMT 2189-2190      COCEMOPB 2191-2192
      COCEMCTD 2193-2194      COCPHLPB 2195-2196      COCPHCTD 2197-2198
      COCLSACT 2199-2200      COCSERPB 2201-2202      COCPDANG 2203-2204
      COCLAWTR 2205-2206      COCFMFPB 2207-2208      COCFMCTD 2209-2210
      HERLOTTM 2211-2212      HERGTOVR 2213-2214      HERLIMIT 2215-2216
      HERKPLMT 2217-2218      HERNDMOR 2219-2220      HERLSEFX 2221-2222
      HERCUTDN 2223-2224      HERCUTEV 2225-2226      HERCUT1X 2227-2228
      HERWD3SX 2229-2230      HERWDSMT 2231-2232      HEREMOPB 2233-2234
      HEREMCTD 2235-2236      HERPHLPB 2237-2238      HERPHCTD 2239-2240
      HERLSACT 2241-2242      HERSERPB 2243-2244      HERPDANG 2245-2246
      HERLAWTR 2247-2248      HERFMFPB 2249-2250      HERFMCTD 2251-2252
      HALLOTTM 2253-2254      HALGTOVR 2255-2256      HALLIMIT 2257-2258
      HALKPLMT 2259-2260      HALNDMOR 2261-2262      HALLSEFX 2263-2264
      HALCUTDN 2265-2266      HALCUTEV 2267-2268      HALEMOPB 2269-2270
      HALEMCTD 2271-2272      HALPHLPB 2273-2274      HALPHCTD 2275-2276
      HALLSACT 2277-2278      HALSERPB 2279-2280      HALPDANG 2281-2282
      HALLAWTR 2283-2284      HALFMFPB 2285-2286      HALFMCTD 2287-2288
      INHLOTTM 2289-2290      INHGTOVR 2291-2292      INHLIMIT 2293-2294
      INHKPLMT 2295-2296      INHNDMOR 2297-2298      INHLSEFX 2299-2300
      INHCUTDN 2301-2302      INHCUTEV 2303-2304      INHEMOPB 2305-2306
      INHEMCTD 2307-2308      INHPHLPB 2309-2310      INHPHCTD 2311-2312
      INHLSACT 2313-2314      INHSERPB 2315-2316      INHPDANG 2317-2318
      INHLAWTR 2319-2320      INHFMFPB 2321-2322      INHFMCTD 2323-2324
      ANLLOTTM 2325-2326      ANLGTOVR 2327-2328      ANLLIMIT 2329-2330
      ANLKPLMT 2331-2332      ANLNDMOR 2333-2334      ANLLSEFX 2335-2336
      ANLCUTDN 2337-2338      ANLCUTEV 2339-2340      ANLCUT1X 2341-2342
      ANLWD3SX 2343-2344      ANLWDSMT 2345-2346      ANLEMOPB 2347-2348
      ANLEMCTD 2349-2350      ANLPHLPB 2351-2352      ANLPHCTD 2353-2354
      ANLLSACT 2355-2356      ANLSERPB 2357-2358      ANLPDANG 2359-2360
      ANLLAWTR 2361-2362      ANLFMFPB 2363-2364      ANLFMCTD 2365-2366
      TRNLOTTM 2367-2368      TRNGTOVR 2369-2370      TRNLIMIT 2371-2372
      TRNKPLMT 2373-2374      TRNNDMOR 2375-2376      TRNLSEFX 2377-2378
      TRNCUTDN 2379-2380      TRNCUTEV 2381-2382      TRNEMOPB 2383-2384
      TRNEMCTD 2385-2386      TRNPHLPB 2387-2388      TRNPHCTD 2389-2390
      TRNLSACT 2391-2392      TRNSERPB 2393-2394      TRNPDANG 2395-2396
      TRNLAWTR 2397-2398      TRNFMFPB 2399-2400      TRNFMCTD 2401-2402
      STMLOTTM 2403-2404      STMGTOVR 2405-2406      STMLIMIT 2407-2408
      STMKPLMT 2409-2410      STMNDMOR 2411-2412      STMLSEFX 2413-2414
      STMCUTDN 2415-2416      STMCUTEV 2417-2418      STMCUT1X 2419-2420
      STMFLBLU 2421-2422      STMWD2SX 2423-2424      STMWDSMT 2425-2426
      STMEMOPB 2427-2428      STMEMCTD 2429-2430      STMPHLPB 2431-2432
      STMPHCTD 2433-2434      STMLSACT 2435-2436      STMSERPB 2437-2438
      STMPDANG 2439-2440      STMLAWTR 2441-2442      STMFMFPB 2443-2444
      STMFMCTD 2445-2446      SEDLOTTM 2447-2448      SEDGTOVR 2449-2450
      SEDLIMIT 2451-2452      SEDKPLMT 2453-2454      SEDNDMOR 2455-2456
      SEDLSEFX 2457-2458      SEDCUTDN 2459-2460      SEDCUTEV 2461-2462
      SEDCUT1X 2463-2464      SEDWD1SX 2465-2466      SEDWDSMT 2467-2468
      SEDEMOPB 2469-2470      SEDEMCTD 2471-2472      SEDPHLPB 2473-2474
      SEDPHCTD 2475-2476      SEDLSACT 2477-2478      SEDSERPB 2479-2480
      SEDPDANG 2481-2482      SEDLAWTR 2483-2484      SEDFMFPB 2485-2486
      SEDFMCTD 2487-2488      DEPNDALC 2489-2490      DEPNDANL 2491-2492
      DEPNDCIG 2493-2494      DEPNDCOC 2495-2496      DEPNDHAL 2497-2498
      DEPNDHER 2499-2500      DEPNDINH 2501-2502      DEPNDMRJ 2503-2504
      DEPNDSED 2505-2506      DEPNDSTM 2507-2508      DEPNDTRN 2509-2510
      DEPNDILL 2511-2512      DEPNDIEM 2513-2514      DEPNDXMJ 2515-2516
      DEPNDPSY 2517-2518      DPILLALC 2519-2520      DPILANAL 2521-2522
      ABUSEALC 2523-2524      ABUSEANL 2525-2526      ABUSECOC 2527-2528
      ABUSEHAL 2529-2530      ABUSEHER 2531-2532      ABUSEINH 2533-2534
      ABUSEMRJ 2535-2536      ABUSESED 2537-2538      ABUSESTM 2539-2540
      ABUSETRN 2541-2542      ABUSEILL 2543-2544      ABUSEIEM 2545-2546
      ABUSEXMJ 2547-2548      ABUSEPSY 2549-2550      ABILLALC 2551-2552
      ABILANAL 2553-2554       ABODALC 2555-2556       ABODANL 2557-2558
       ABODCOC 2559-2560       ABODHAL 2561-2562       ABODHER 2563-2564
       ABODINH 2565-2566       ABODMRJ 2567-2568       ABODSED 2569-2570
       ABODSTM 2571-2572       ABODTRN 2573-2574       ABODILL 2575-2576
       ABODPSY 2577-2578      ABODILAL 2579-2580      ABDILAAL 2581-2582
        BOOKED 2583-2584      NOBOOKY2 2585-2587      BKMVTHFT 2588-2589
      BKLARCNY 2590-2591       BKBURGL 2592-2593      BKAGASLT 2594-2595
      BKSMASLT 2596-2597         BKROB 2598-2599        BKRAPE 2600-2601
      BKMURDER 2602-2603       BKARSON 2604-2605      BKDRVINF 2606-2607
       BKDRUNK 2608-2609      BKPOSTOB 2610-2611        BKDRUG 2612-2613
        BKPROS 2614-2615      BKSEXOFF 2616-2617       BKFRAUD 2618-2619
         BKOTH 2620-2621      BKOTHOF2 2622-2623      PROBATON 2624-2625
      PAROLREL 2626-2627       DRVALDR 2628-2629      DRVAONLY 2630-2631
      DRVDONLY 2632-2633       DRIVALC 2634-2635       DRIVDRG 2636-2637
       DRIVALD 2638-2639         PAROL 2640-2641          PROB 2642-2643
        TXEVER 2644-2645      TXYREVER 2646-2647       TXYRADG 2648-2649
      TXYRHOSP 2650-2651      TXYRHPAD 2652-2653      TXYRRFIN 2654-2655
      TXYRINAD 2656-2657      TXYRRFOP 2658-2659      TXYRPOAD 2660-2661
       TXYRMHC 2662-2663      TXYRMHAD 2664-2665      TXYRTXER 2666-2667
      TXYRERAD 2668-2669       TXYRDOC 2670-2671      TXYRDCAD 2672-2673
      TXYRJAIL 2674-2675      TXYRJLAD 2676-2677       TXYRSHG 2678-2679
      TXYRSGAD 2680-2681       TXYRSOP 2682-2683      TXYROTS2 2684-2686
      TXYROTAD 2687-2688      TXYRVSER 2689-2690      TXYRNME2 2691-2693
      TXRCVNOW 2694-2695      NDTXNEDR 2696-2697      NDTXMORE 2698-2699
      NDTMRALC 2700-2701       NDTMRMJ 2702-2703      NDTMRCOC 2704-2705
      NDTMRHER 2706-2707      NDTMRHAL 2708-2709      NDTMRINH 2710-2711
      NDTMRANL 2712-2713      NDTMRTRN 2714-2715      NDTMRSTM 2716-2717
      NDTMRSED 2718-2719      NDTMROTH 2720-2721      NDTXALCR 2722-2723
       NDTXMJR 2724-2725      NDTXCOCR 2726-2727      NDTXHERR 2728-2729
      NDTXHALR 2730-2731      NDTXINHR 2732-2733      NDTXANLR 2734-2735
      NDTXTRNR 2736-2737      NDTXSTMR 2738-2739      NDTXSEDR 2740-2741
      NDTXSODR 2742-2743      NDTXDG1R 2744-2747      NDTXDG2R 2748-2751
      NDTXDG3R 2752-2755      NDTXDG4R 2756-2759      NDTXDG5R 2760-2763
      NDTXEFTR 2764-2765      NDTMREFT 2766-2767      TXLASREC 2768-2769
      TXLTYMN2 2770-2772      TXLTYALC 2773-2774       TXLTYMJ 2775-2776
      TXLTYCOC 2777-2778      TXLTYHER 2779-2780      TXLTYHAL 2781-2782
      TXLTYINH 2783-2784      TXLTYANL 2785-2786      TXLTYTRN 2787-2788
      TXLTYSTM 2789-2790      TXLTYSED 2791-2792      TXLTYSOD 2793-2794
      TXLTYOU2 2795-2796      TXLTYDU2 2797-2801       TXPYINS 2802-2803
      TXPYCARE 2804-2805      TXPYCAID 2806-2807      TXPYPUBP 2808-2809
      TXPYSAVE 2810-2811      TXPYFMLY 2812-2813      TXPYCORT 2814-2815
      TXPYMILC 2816-2817      TXPYEMPL 2818-2819       TXPYSOS 2820-2821
       TXPYSP2 2822-2823       TXPYFRE 2824-2825      TXENROLL 2826-2827
      TXYRDTXO 2828-2829      SPECTILL 2830-2831      SPECTALC 2832-2833
      SPILLALC 2834-2835       ILLNEED 2836-2837      TXNOSPEC 2838-2839
       ALCTRMT 2840-2841       ILLTRMT 2842-2843      TXILLALC 2844-2845
      TXILANAL 2846-2847      TXLTALC2 2848-2849      TXLTANL2 2850-2851
      TXLTCOC2 2852-2853      TXLTHAL2 2854-2855      TXLTHER2 2856-2857
      TXLTINH2 2858-2859       TXLTMJ2 2860-2861      TXLTSED2 2862-2863
      TXLTSTM2 2864-2865      TXLTTRN2 2866-2867      TXLTILL2 2868-2869
       TXPINS2 2870-2871      TXPCARE2 2872-2873      TXPCAID2 2874-2875
      TXPPUBP2 2876-2877      TXPSAVE2 2878-2879      TXPFMLY2 2880-2881
      TXPCORT2 2882-2883      TXPMILC2 2884-2885      TXPEMPL2 2886-2887
       ILLPINS 2888-2889      ILLPCARE 2890-2891      ILLPCAID 2892-2893
      ILLPPUBP 2894-2895      ILLPSAVE 2896-2897      ILLPFMLY 2898-2899
      ILLPCORT 2900-2901      ILLPMILC 2902-2903      ILLPEMPL 2904-2905
       ALCPINS 2906-2907      ALCPCARE 2908-2909      ALCPCAID 2910-2911
      ALCPPUBP 2912-2913      ALCPSAVE 2914-2915      ALCPFMLY 2916-2917
      ALCPCORT 2918-2919      ALCPMILC 2920-2921      ALCPEMPL 2922-2923
       LOCHOSP 2924-2925       LOCRFIN 2926-2927       LOCRFOP 2928-2929
        LOCMHC 2930-2931       LOCTXER 2932-2933        LOCDOC 2934-2935
       LOCJAIL 2936-2937        LOCSHG 2938-2939       DRGHOSP 2940-2941
       DRGRFIN 2942-2943       DRGRFOP 2944-2945        DRGMHC 2946-2947
       DRGTXER 2948-2949        DRGDOC 2950-2951       DRGJAIL 2952-2953
        DRGSHG 2954-2955       ALCHOSP 2956-2957       ALCRFIN 2958-2959
       ALCRFOP 2960-2961        ALCMHC 2962-2963       ALCTXER 2964-2965
        ALCDOC 2966-2967       ALCJAIL 2968-2969        ALCSHG 2970-2971
       AUINPYR 2972-2973      AUINPSYH 2974-2975      AUINPGEN 2976-2977
      AUINMEDU 2978-2979      AUINAHSP 2980-2981      AUINRESD 2982-2983
      AUINSFAC 2984-2985      AUNMPSY2 2986-2988      AUNMPGE2 2989-2991
      AUNMMEDU 2992-2994      AUNMAHSP 2995-2997      AUNMRESD 2998-3000
      AUNMSFA2 3001-3003      AUPINSLF 3004-3005      AUPINOFM 3006-3007
      AUPINPHI 3008-3009      AUPINMCR 3010-3011      AUPINMCD 3012-3013
      AUPINREH 3014-3015      AUPINEMP 3016-3017      AUPINMIL 3018-3019
      AUPINPUB 3020-3021      AUPINPRV 3022-3023      AUPINFRE 3024-3025
      AUPINAMT 3026-3027       AUOPTYR 3028-3029      AUOPMENT 3030-3031
      AUOPTHER 3032-3033       AUOPDOC 3034-3035      AUOPCLNC 3036-3037
      AUOPDTMT 3038-3039      AUOPOTOP 3040-3041      AUOPYRS2 3042-3043
      AUNMMEN2 3044-3046      AUNMTHE2 3047-3049      AUNMDOC2 3050-3052
      AUNMCLN2 3053-3055      AUNMDTM2 3056-3058      AUNMOTO2 3059-3061
      AUPOPSLF 3062-3063      AUPOPOFM 3064-3065      AUPOPPHI 3066-3067
      AUPOPMCR 3068-3069      AUPOPMCD 3070-3071      AUPOPREH 3072-3073
      AUPOPEMP 3074-3075      AUPOPMIL 3076-3077      AUPOPPUB 3078-3079
      AUPOPPRV 3080-3081      AUPOPFRE 3082-3083      AUPOPMOS 3084-3085
      AUPOPAMT 3086-3087        AURXYR 3088-3089      AUUNMTYR 3090-3091
      AUUNMTRS 3092-3093        AMHINP 3094-3095       AMHOUTP 3096-3097
         AMHRX 3098-3099      AMHTXREC 3100-3101      AMHTRTND 3102-3103
       SNCRIME 3104-3105      SNSELLDG 3106-3107       SNPPVAL 3108-3109
       SNSTFGT 3110-3111      SNEMTBLD 3112-3113       SNPPHLP 3114-3115
      SNGRAFTI 3116-3117      SNPPVSIT 3118-3119      SNPPMOVE 3120-3121
      SNMOV5Y2 3122-3124      SNSPOUSE 3125-3126      SNSPACTV 3127-3128
      SNSPANGR 3129-3130      SNSPHITU 3131-3132      SNYHITSP 3133-3134
      SNSPCRIT 3135-3136      SNSPCONC 3137-3138      SNFRCONC 3139-3140
      SNFRACTV 3141-3142      SNFRCARE 3143-3144       SNYSELL 3145-3146
      SNYSTOLE 3147-3148      SNYATTAK 3149-3150       SNFACIG 3151-3152
      SNFAMJEV 3153-3154      SNFAALDY 3155-3156      SNFAALDV 3157-3158
       YECRIME 3159-3160      YESELLDG 3161-3162       YEPPHLP 3163-3164
       YESTFGT 3165-3166      YEEMTBLD 3167-3168      YEPPVSIT 3169-3170
      YEGRAFTI 3171-3172      YEPPMOVE 3173-3174      YEMOV5Y2 3175-3177
      YEENRLYR 3178-3179      YELSTGRD 3180-3181      YEYFGTSW 3182-3183
      YEYFGTGP 3184-3185       YEYHGUN 3186-3187       YEYSELL 3188-3189
      YEYSTOLE 3190-3191      YEYATTAK 3192-3193      YEPPKCIG 3194-3195
      YEPMJEVR 3196-3197      YEPALDLY 3198-3199      YEGPKCIG 3200-3201
      YEGMJEVR 3202-3203      YEGALDLY 3204-3205      YETLKNON 3206-3207
      YETLKPAR 3208-3209      YETLKSOP 3210-3211      YEPRTDNG 3212-3213
      YEBIGBRO 3214-3215      YEPRBSLV 3216-3217      YEVIOPRV 3218-3219
        YEYMCA 3220-3221      YESCOUTS 3222-3223      YEPRVLES 3224-3225
      YEDGPRGP 3226-3227      YETEMSPT 3228-3229      YE4HCLUB 3230-3231
      YESLFHLP 3232-3233        YEBAND 3234-3235      YESCHCLB 3236-3237
      YEVOLUNT 3238-3239      YESTGOVT 3240-3241      YEPRGSTD 3242-3243
      YEJBSKIL 3244-3245       YECHOIR 3246-3247      YEDECLAS 3248-3249
      YEDERGLR 3250-3251      YEDESPCL 3252-3253      YEPVNTYR 3254-3255
      YECGFRND 3256-3257      YECGVEND 3258-3259      YECGMAI2 3260-3261
      YECGCHKO 3262-3263      YECGCLRK 3264-3265      YECGINET 3266-3267
      YECGSMKT 3268-3269      YECGDSTO 3270-3271      YECGCONV 3272-3273
      YECGINDV 3274-3275      YECGPRUF 3276-3277      YECGSUCC 3278-3279
      YEPKCRTN 3280-3281      YEPDPACK 3282-3283      YEPDCRTN 3284-3285
      YEBLNTEV 3286-3287      YEBLNT30 3288-3289      YEBL30FQ 3290-3291
      YECGRWMJ 3292-3293      NGHCRIM2 3294-3295      NGHSELL2 3296-3297
      NGHHELP2 3298-3299      NGHFGHT2 3300-3301      NGHBLDG2 3302-3303
      NGHVSIT2 3304-3305      NGHGRAF2 3306-3307      NGHMOVE2 3308-3309
      MVIN5YR2 3310-3311      PRPKCIG2 3312-3313      PRMJEVR2 3314-3315
      PRALDLY2 3316-3317       PRTALK3 3318-3319      YOFIGHT2 3320-3321
      YOGRPFT2 3322-3323       YOHGUN2 3324-3325       YOSELL2 3326-3327
      YOSTOLE2 3328-3329      YOATTAK2 3330-3331      YFLPKCG2 3332-3333
      YFLTMRJ2 3334-3335      YFLADLY2 3336-3337      YOUTHACT 3338-3339
      PRBSOLV2 3340-3341      PREVIOL2 3342-3343      PRVDRGO2 3344-3345
      GRPCNSL2 3346-3347      PREGPGM2 3348-3349      DGSPCLS2 3350-3351
      DGRGCLS2 3352-3353      DRGLECT2 3354-3355      DRPRVME3 3356-3357
      ANYEDUC3 3358-3359       CIGFRND 3360-3361       CIGVEND 3362-3363
       CIGMAIL 3364-3365      CIGCKOUT 3366-3367      CIGCLERK 3368-3369
       CIGINET 3370-3371       CIGSMKT 3372-3373       CIGDSTO 3374-3375
       CIGCONV 3376-3377      CIGINDIV 3378-3379       YTHBGHT 3380-3381
      YMSPGRUP 3382-3383      YMSPFNTP 3384-3385      YMSAHOME 3386-3387
      YMSAACHE 3388-3389      YMSABDRM 3390-3391      YMSASLEP 3392-3393
      YMSAABDN 3394-3395      YMSAUPLV 3396-3397      YMSAHMSK 3398-3399
      YMAGOHSF 3400-3401      YMAGCRWD 3402-3403      YMAGTRAV 3404-3405
      YMAGBRDG 3406-3407      YMPAATAK 3408-3409      YMPASUFC 3410-3411
      YMGAWORY 3412-3413      YMGAHDAC 3414-3415      YMGAPAIN 3416-3417
      YMGATNSE 3418-3419      YMPHANML 3420-3421      YMPHHIGH 3422-3423
      YMPHDARK 3424-3425      YMPHNEDL 3426-3427      YMPHBLOD 3428-3429
      YMPHBRDG 3430-3431      YMPHELEV 3432-3433      YMOCCOUN 3434-3435
      YMOCWASH 3436-3437      YMOCCHCK 3438-3439      YMOCGERM 3440-3441
      YMOCTHOT 3442-3443      YMEATHIN 3444-3445       YMEAFAT 3446-3447
      YMEATHFD 3448-3449      YMEABING 3450-3451      YMELWTBD 3452-3453
      YMELWTPT 3454-3455      YMELSOIL 3456-3457      YMMDNINT 3458-3459
      YMMDLSEG 3460-3461      YMMDNOGD 3462-3463      YMMDTHKL 3464-3465
      YMMDTYKL 3466-3467      YMMDTIRD 3468-3469      YMMDTHNK 3470-3471
      YMMABDMD 3472-3473      YMMARSLS 3474-3475      YMMATALK 3476-3477
      YMMASPAB 3478-3479      YMMAMDRC 3480-3481      YMADCONC 3482-3483
      YMADFRGT 3484-3485      YMADFCUS 3486-3487      YMADMEDS 3488-3489
      YMADAVAT 3490-3491      YMADERRO 3492-3493      YMODHURT 3494-3495
      YMODRFUS 3496-3497      YMODANOY 3498-3499      YMODMEAN 3500-3501
      YMODBLMO 3502-3503      YMODTANY 3504-3505      YMODSWOR 3506-3507
      YMCDEXPL 3508-3509      YMCDSHPL 3510-3511      YMCDLIED 3512-3513
      YMCDSNAT 3514-3515      YMCDVAND 3516-3517      YMCDSTOL 3518-3519
      YMCDCRUA 3520-3521      YMCDBKNT 3522-3523      YUHOSPYR 3524-3525
      YUHOSPN2 3526-3528      YUHOSUIC 3529-3530      YUHODEPR 3531-3532
      YUHOFEAR 3533-3534      YUHOBKRU 3535-3536      YUHOEATP 3537-3538
       YUHOSOR 3539-3540      YURSIDYR 3541-3542      YURSIDN2 3543-3545
      YURSSUIC 3546-3547      YURSDEPR 3548-3549      YURSFEAR 3550-3551
      YURSBKRU 3552-3553      YURSEATP 3554-3555       YURSSOR 3556-3557
      YUFCARYR 3558-3559      YUFCARN2 3560-3562      YUFCSUIC 3563-3564
      YUFCDEPR 3565-3566      YUFCFEAR 3567-3568      YUFCBKRU 3569-3570
      YUFCEATP 3571-3572       YUFCSOR 3573-3574      YUDYTXYR 3575-3576
      YUDYTXN2 3577-3579      YUDYSUIC 3580-3581      YUDYDEPR 3582-3583
      YUDYFEAR 3584-3585      YUDYBKRU 3586-3587      YUDYEATP 3588-3589
       YUDYSOR 3590-3591      YUMHCRYR 3592-3593      YUMHCRN2 3594-3596
      YUMHSUIC 3597-3598      YUMHDEPR 3599-3600      YUMHFEAR 3601-3602
      YUMHBKRU 3603-3604      YUMHEATP 3605-3606       YUMHSOR 3607-3608
      YUTPSTYR 3609-3610      YUTPSTN2 3611-3613      YUTPSUIC 3614-3615
      YUTPDEPR 3616-3617      YUTPFEAR 3618-3619      YUTPBKRU 3620-3621
      YUTPEATP 3622-3623       YUTPSOR 3624-3625      YUIHTPYR 3626-3627
      YUIHTPN2 3628-3630      YUIHSUIC 3631-3632      YUIHDEPR 3633-3634
      YUIHFEAR 3635-3636      YUIHBKRU 3637-3638      YUIHEATP 3639-3640
       YUIHSOR 3641-3642      YUFDOCYR 3643-3644      YUFDOCN2 3645-3647
      YUFDSUIC 3648-3649      YUFDDEPR 3650-3651      YUFDFEAR 3652-3653
      YUFDBKRU 3654-3655      YUFDEATP 3656-3657       YUFDSOR 3658-3659
      YUSPEDYR 3660-3661      YUSHCNYR 3662-3663      YUSHSUIC 3664-3665
      YUSHDEPR 3666-3667      YUSHFEAR 3668-3669      YUSHBKRU 3670-3671
      YUSHEATP 3672-3673       YUSHSOR 3674-3675      YUJAILEV 3676-3677
      YUFCAREV 3678-3679      IRHHSIZ2 3680-3681      IIHHSIZ2 3682-3683
      IRHH65_2 3684-3685      IIHH65_2 3686-3687      IRKI17_2 3688-3689
      IIKI17_2 3690-3691       IMOTHER 3692-3693       IFATHER 3694-3695
      NRCH17_2 3696-3697      PREGNANT 3698-3699      NMERTMT2 3700-3702
      INHOSPYR 3703-3704      NMNGTHS2 3705-3707      PROXANS2 3708-3709
          PREG 3710-3711         PREG2 3712-3713       TRIMEST 3714-3715
        IRPSOC 3716-3717        IIPSOC 3718-3719      IRFAMSOC 3720-3721
      IIFAMSOC 3722-3723        IRPSSI 3724-3725        IIPSSI 3726-3727
      IRFAMSSI 3728-3729      IIFAMSSI 3730-3731      IRFSTAMP 3732-3733
      IIFSTAMP 3734-3735        IRPPMT 3736-3737        IIPPMT 3738-3739
      IRFAMPMT 3740-3741      IIFAMPMT 3742-3743        IRPSVC 3744-3745
        IIPSVC 3746-3747      IRFAMSVC 3748-3749      IIFAMSVC 3750-3751
      IRWELMOS 3752-3753      IIWELMOS 3754-3755        IRPINT 3756-3757
        IIPINT 3758-3759      IRFAMINT 3760-3761      IIFAMINT 3762-3763
        IRPCHD 3764-3765        IIPCHD 3766-3767      IRFAMCHD 3768-3769
      IIFAMCHD 3770-3771        IRPWAG 3772-3773        IIPWAG 3774-3775
      IRFAMWAG 3776-3777      IIFAMWAG 3778-3779        IRPOTH 3780-3781
        IIPOTH 3782-3783      IRFAMOTH 3784-3785      IIFAMOTH 3786-3787
       IRPINC3 3788-3789       IIPINC3 3790-3791      IRFAMIN3 3792-3793
      IIFAMIN3 3794-3795      GOVTPROG 3796-3797      HLCALLFG 3798-3799
      HLCALL99 3800-3801      MEDICARE 3802-3803      MEDICAID 3804-3805
       CHAMPUS 3806-3807      OGOVTINS 3808-3809      OGOVINS2 3810-3812
      PRVHLTIN 3813-3814      GRPHLTIN 3815-3816      HLTINALC 3817-3818
      HLTINDRG 3819-3820      HLTINMNT 3821-3822      OTHLTINS 3823-3824
      OTHLINS2 3825-3827      HLCNOTYR 3828-3829      HLCNOTMO 3830-3831
       HLCLAST 3832-3833      HLCPRIVT 3834-3835      HLCMCAID 3836-3837
       HLCMILT 3838-3839      HLCMCARE 3840-3841      HLCOGOVT 3842-3843
      HLCOTHER 3844-3845      HLCOTHS2 3846-3848      HLLLOSJB 3849-3850
      HLLMAJOB 3851-3852      HLLMASOR 3853-3854       HLLCOST 3855-3856
      HLLINELG 3857-3858      HLLNOFFR 3859-3860      HLLDIVOR 3861-3862
      HLLDEATH 3863-3864      HLLREFUS 3865-3866      HLLNONED 3867-3868
        HLLSOR 3869-3870      HLLSORS2 3871-3873      HLNVCOST 3874-3875
      HLNVOFFR 3876-3877       HLNVREF 3878-3879      HLNVNEED 3880-3881
       HLNVSOR 3882-3883       HLNVSP2 3884-3886      IRPINSUR 3887-3888
      IIPINSUR 3889-3890       IRINSUR 3891-3892       IIINSUR 3893-3894
      IRINSUR2 3895-3896      IIINSUR2 3897-3898       LANGVER 3899-3900
       QUARTER 3901-3902        GQTYPE 3903-3904          AGE2 3905-3906
       NOMARR2 3907-3908       SERVICE 3909-3910       MILSTAT 3911-3912
        HEALTH 3913-3914         IRSEX 3915-3916         IISEX 3917-3918
       IRMARIT 3919-3920       IIMARIT 3921-3922       IREDUC2 3923-3924
       IIEDUC2 3925-3926      EMPSTAT3 3927-3928      IIEMPST3 3929-3930
      EMPSTATY 3931-3932      IIEMPSTY 3933-3934      EMPSTAT4 3935-3936
      IIEMPST4 3937-3938      MOVESPY2 3939-3941       ENROLED 3942-3943
      EDUCNOW2 3944-3945        STUDNT 3946-3947      SCHDSICK 3948-3949
      SCHDSKIP 3950-3951      HSDIPLMA 3952-3953         HSGED 3954-3955
      LFSCHWH2 3956-3958      LFTSCHA2 3959-3961      RLGSVCYR 3962-3963
      RLGIMPRT 3964-3965      RLGDECSN 3966-3967      RLGFRNDS 3968-3969
        TELNO2 3970-3971      TUCHTONE 3972-3973      COLLEGE2 3974-3975
        CATAGE 3976-3977        CATAG2 3978-3979        CATAG3 3980-3981
        CATAG7 3982-3983      NEWRACE2 3984-3985      EDUCCAT2 3986-3987
      JOBSTAT2 3988-3989      JBSTATR2 3990-3991      WRKHAVJB 3992-3993
      WRKHRSWK 3994-3996      WRKINDU2 3997-3999      WRKOCCU2 4000-4002
      WRKBZCA2 4003-4004      WRKEFFRT 4005-4006       WRKEDYR 4007-4008
      WRKSLFEM 4009-4010      WRKJOBS2 4011-4013      WRKUNEMP 4014-4015
      WRKUNWKS 4016-4017      WRKLASY2 4018-4021      WRKINDY2 4022-4024
      WRKOCCY2 4025-4027      WORKDAYS 4028-4029      WORKBLAH 4030-4031
       LOCSIZE 4032-4033       DRGPLCY 4034-4035       PLCYCOV 4036-4037
       WKDRGED 4038-4039       DRGPRGM 4040-4041      USALCTST 4042-4043
      USDRGTST 4044-4045       TSTHIRE 4046-4047       TSTRAND 4048-4049
      FIRSTPOS 4050-4051       WRKHIRE 4052-4053      WORKRAND 4054-4055
       FIEXP99 4056-4057          PDEN 4058-4059         VESTR 4060-4064
         VEREP 4065-4066  ANALWT_C 4067-4074 (2)
   .

* SPSS VARIABLE LABELS COMMAND.

VARIABLE LABELS
   CASEID    'CASE IDENTIFICATION NUMBER' /
   QUESTID   'RESPONDENT IDENTIFICATION' /
   CIGEVER   'EVER SMOKED A CIGARETTE' /
   CIGOFRSM  'IF BEST FRIEND OFFERED, WOULD YOU SMOKE CIG' /
   CIGWILYR  'DO YOU THINK YOU''LL SMOKE CIG IN NEXT 12 MOS' /
   CIGTRY    'AGE WHEN FIRST SMOKED A CIGARETTE' /
   CIGYFU    'YEAR OF FIRST CIGARETTE USE - RECODE' /
   CIGMFU    'MONTH OF FIRST CIGARETTE USE - RECODE' /
   CIGREC    'TIME SINCE LAST SMOKED CIGARETTES' /
   CIG30USE  'HOW MANY DAYS SMOKED CIG IN PAST 30 DAYS' /
   CG30EST   'BEST EST. # DAYS SMOKED CIG PAST 30 DAYS' /
   CIG30AV   'AVG # CIGS SMOKED PER DAY/ON DAY SMOKED' /
   CIG30BR2  'CIG BRAND USED MOST OFTEN PAST MO - RECODE' /
   CIG30TYP  'WHAT TYPE OF CIG SMOKED MOST PAST 30 DAYS' /
   CIG30MEN  'MENTHOL OR REG CIG SMOKED MOST PAST 30 DAYS' /
   CIG30RO2  'HAVE YOU SMOKED ROLL-OWN CIG IN PAST 30 DAYS' /
   CIGDLYMO  'EVER SMOKED CIG EVERY DAY FOR 30 DAYS' /
   CIGAGE    'AGE WHEN FIRST STARTED SMOKING CIGARETTES EVERYDAY' /
   CIG100LF  'HAVE YOU SMOKED 100 CIGS IN YOUR LIFE' /
   CHEWEVER  'EVER USED CHEW EVEN ONCE' /
   CHEWTRY   'AGE WHEN FIRST USED CHEW' /
   CHEWYFU   'YEAR OF FIRST CHEWING TOBACCO USE - RECODE' /
   CHEWMFU   'MONTH OF FIRST CHEWING TOBACCO USE - RECODE' /
   CHEWREC   'TIME SINCE LAST USED CHEWING TOBACCO' /
   CHW30USE  'HOW MANY DAYS USED CHEW IN PAST 30 DAYS' /
   CH30EST   'PAST 30 DAY ESTIMATE OF CHEWING TOBACCO' /
   CHW30BR2  'CHEW BRAND USED MOST OFTEN PAST MO - RECODE' /
   SNFEVER   'EVER USED SNUFF' /
   SNUFTRY   'AGE WHEN FIRST USED SNUFF' /
   SNUFYFU   'YEAR OF FIRST SNUFF USE - RECODE' /
   SNUFMFU   'MONTH OF FIRST SNUFF USE - RECODE' /
   SNFREC    'TIME SINCE LAST USED SNUFF' /
   SNF30USE  'HOW MANY DAYS USED SNUFF PAST 30 DAYS' /
   SN30EST   'BEST EST. HOW MANY DAYS USED SNUFF PST 30 DAYS' /
   SNF30BR2  'SNUFF BRAND USED MOST OFTEN PAST MO - RECODE' /
   SLTTRY    'AGE WHEN FIRST USED ANY SMOKLESS TOB - RECODE' /
   SLTYFU    'YEAR OF FIRST SMOKELESS TOBACCO USE - RECODE' /
   SLTMFU    'MONTH OF FIRST SMOKELESS TOBACCO USE - RECODE' /
   SLTREC    'TIME SINCE LAST USED ANY SMOKLESS TOB - RECODE' /
   SLT30BR2  'SMKLSS TOB BRAND USED MOST OFTEN PAST MO - RECODE' /
   SLT30FAV  'WHICH BRAND CHEW OR SNUFF USED MOST' /
   CIGAREVR  'EVER SMOKED PART OR ALL OF CIGAR' /
   CIGARTRY  'AGE WHEN FIRST SMOKED CIGAR' /
   CIGARYFU  'YEAR OF FIRST CIGAR USE - RECODE' /
   CIGARMFU  'MONTH OF FIRST CIGAR USE - RECODE' /
   CIGARREC  'TIME SINCE LAST SMOKED CIGAR' /
   CGR30USE  'HOW MANY DAYS SMOKED CIGAR IN PAST 30 DAYS' /
   CI30EST   'BEST EST. # DAYS SMOKED CIGAR PAST 30 DAYS' /
   CGR30BR2  'CIGAR BRAND USED MOST OFTEN PAST MO - RECODE' /
   PIPEVER   'EVER SMOKED PIPE TOBACCO' /
   PIPE30DY  'HAVE YOU SMOKED PIPE TOBACCO IN PAST 30 DAYS' /
   ALCEVER   'EVER HAD DRINK OF ALCOHOLIC BEVERAGE' /
   ALCTRY    'AGE WHEN FIRST DRANK ALCOHOLIC BEVERAGE' /
   ALCYFU    'YEAR OF FIRST ALCOHOL USE - RECODE' /
   ALCMFU    'MONTH OF FIRST ALCOHOL USE - RECODE' /
   ALCREC    'TIME SINCE LAST DRANK ALCOHOLIC BEVERAGE' /
   ALCYRTOT  'TOTAL # OF DAYS USED ALCOHOL IN PAST 12 MOS' /
   ALTOTFG   'TRIMMING INDICATOR FOR ALCYRTOT' /
   ALFQFLG   'TRIMMED ALCYRTOT IF R USED < 12 MOS' /
   ALBSTWAY  'EASIEST WAY TO TELL US # DAYS DRANK ALCOHOL' /
   ALDAYPYR  'NUMBER DAYS DRANK ALCOHOL IN PAST 12 MOS' /
   ALDAYPMO  '# DAYS PER MONTH DRANK ALCOHOL IN PAST 12 MOS' /
   ALDAYPWK  '# DAYS PER WEEK DRANK ALCOHOL IN PAST 12 MOS' /
   ALCDAYS   '# DAYS HAD ONE OR MORE DRINKS PAST 30 DAYS' /
   AL30EST   'BEST ESTIMATE # DAYS HAD ONE OR MORE DRINKS' /
   ALDYSFG   'REVISION INDICATOR FOR ALCDAYS' /
   NODR30A   'USUAL # OF DRINKS PER DAY PAST 30 DAYS' /
   DR5DAY    '# DAYS HAD FIVE OR MORE DRINKS PAST 30 DAYS' /
   MJEVER    'EVER USED MARIJUANA/HASHISH' /
   MJAGE     'AGE WHEN FIRST USED MARIJUANA/HASHISH' /
   MJYFU     'YEAR OF FIRST MARIJUANA/HASHISH USE - RECODE' /
   MJMFU     'MONTH OF FIRST MARIJUANA/HASHISH USE - RECODE' /
   MJREC     'TIME SINCE LAST USED MARIJUANA/HASHISH' /
   MJYRTOT   'TOTAL # OF DAYS USED MARIJUANA IN PAST 12 MOS' /
   MRTOTFG   'TRIMMING INDICATOR FOR MRJYRTOT' /
   MJFQFLG   'TRIMMED MJYRTOT IF R USED < 12 MOS' /
   MRBSTWAY  'EASIEST WAY TO TELL US # DAYS USED MARIJUANA/HASH' /
   MRDAYPYR  '# DAYS USED MARIJUANA/HASHISH PAST 12 MONTHS' /
   MRDAYPMO  '# DAYS PER MO USED MARIJUANA/HASHISH PAST 12 MOS' /
   MRDAYPWK  '# DAYS PER WEEK USED MARIJUANA/HASHISH PAST 12 MOS' /
   MJDAY30A  '# DAYS USED MARIJUANA/HASHISH PAST 30 DAYS' /
   MR30EST   'BEST EST. # DAYS USED MARIJUANA PAST 30 DAYS' /
   COCEVER   'EVER USED COCAINE' /
   COCAGE    'AGE WHEN FIRST USED COCAINE' /
   COCYFU    'YEAR OF FIRST COCAINE USE - RECODE' /
   COCMFU    'MONTH OF FIRST COCAINE USE - RECODE' /
   COCREC    'TIME SINCE LAST USED COCAINE' /
   COCYRTOT  'TOTAL # OF DAYS USED COCAINE IN PAST 12 MONTHS' /
   CCTOTFG   'TRIMMING INDICATOR FOR COCYRTOT' /
   CCFQFLG   'TRIMMED COCYRTOT IF R USED < 12 MOS' /
   CCBSTWAY  'EASIEST WAY TO TELL US # DAYS USED COCAINE' /
   CCDAYPYR  '# DAYS USED COCAINE PAST 12 MONTHS' /
   CCDAYPMO  '# DAYS PER MONTH USED COCAINE PAST 12 MONTHS' /
   CCDAYPWK  '# DAYS PER WEEK USE COCAINE PAST 12 MONTHS' /
   COCUS30A  '# DAYS USED COCAINE PAST 30 DAYS' /
   CC30EST   'BEST ESTIMATE # DAYS USED COCAINE PAST 30 DAYS' /
   CRKEVER   'EVER USED CRACK' /
   CRKAGE    'AGE WHEN FIRST USED CRACK' /
   CRKYFU    'YEAR OF FIRST CRACK USE - RECODE' /
   CRKMFU    'MONTH OF FIRST CRACK USE - RECODE' /
   CRAKREC   'TIME SINCE LAST USED CRACK' /
   CRKYRTOT  'TOTAL # DAYS USED CRACK IN PAST 12 MONTHS' /
   CRTOTFG   'TRIMMING INDICATOR FOR CRKYRTOT' /
   CRFQFLG   'TRIMMED CRKYRTOT IF R USED < 12 MOS' /
   CRBSTWAY  'EASIEST WAY TO TELL US # DAYS USED CRACK' /
   CRDAYPYR  '# DAYS USED CRACK PAST 12 MONTHS' /
   CRDAYPMO  '# DAYS PER MONTH USED CRACK PAST 12 MONTHS' /
   CRDAYPWK  '# DAYS PER WEEK USED CRACK PAST 12 MONTHS' /
   CRKUS30A  '# DAYS USED CRACK PAST 30 DAYS' /
   CR30EST   'BEST ESTIMATE # DAYS USED CRACK PAST 30 DAYS' /
   HEREVER   'EVER USED HEROIN' /
   HERAGE    'AGE WHEN FIRST USED HEROIN' /
   HERYFU    'YEAR OF FIRST HEROIN USE - RECODE' /
   HERMFU    'MONTH OF FIRST HEROIN USE - RECODE' /
   HERREC    'TIME SINCE LAST USED HEROIN' /
   HERYRTOT  'TOTAL # OF DAYS USED HEROIN IN PAST 12 MONTHS' /
   HRTOTFG   'TRIMMING INDICATOR FOR HERYRTOT' /
   HRFQFLG   'TRIMMED HERYRTOT IF R USED < 12 MOS' /
   HRBSTWAY  'EASIEST WAY TO TELL US # DAYS USED HEROIN' /
   HRDAYPYR  '# DAYS USED HEROIN PAST 12 MONTHS' /
   HRDAYPMO  '# DAYS PER MONTH USED HEROIN PAST 12 MONTHS' /
   HRDAYPWK  '# DAYS PER WEEK USED HEROIN PAST 12 MONTHS' /
   HER30USE  '# DAYS USED HEROIN PAST 30 DAYS' /
   HR30EST   'BEST EST. # DAYS USED HEROIN PAST 30 DAYS' /
   LSD       'EVER USED LSD ("ACID")' /
   PCP       'EVER USED PCP ("ANGEL DUST," PHENCYCLIDINE)' /
   PEYOTE    'EVER USED PEYOTE' /
   MESC      'EVER USED MESCALINE' /
   PSILCY    'EVER USED PSILOCYBIN (MUSHROOMS)' /
   ECSTASY   'EVER USED "ECSTASY" (MDMA)' /
   HALNOLST  'EVER USED OTHER HALLUCINOGEN' /
   HALNEWA   'OTHER HALLUCINOGEN - SPECIFY 1' /
   HALNEWB   'OTHER HALLUCINOGEN - SPECIFY 2' /
   HALNEWC   'OTHER HALLUCINOGEN - SPECIFY 3' /
   HALNEWD   'OTHER HALLUCINOGEN - SPECIFY 4' /
   HALNEWE   'OTHER HALLUCINOGEN - SPECIFY 5' /
   HALLAGE   'AGE WHEN FIRST USED HALLUCINOGENS' /
   HALYFU    'YEAR OF FIRST HALLUCINOGEN USE - RECODE' /
   HALMFU    'MONTH OF FIRST HALLUCINOGEN USE - RECODE' /
   HALLREC   'TIME SINCE LAST USED HALLUCINOGENS' /
   HALYRTOT  'TOTAL # OF DAYS USED HALLUCINOGENS IN PAST 12 MOS' /
   HLTOTFG   'TRIMMING INDICATOR FOR HALYRTOT' /
   HLFQFLG   'TRIMMED HALYRTOT IF R USED < 12 MOS' /
   HLBSTWAY  'EASIEST WAY TO TELL US # DAYS USED HALLUCINOGEN' /
   HLDAYPYR  '# DAYS USED HALLUCINOGEN PAST 12 MONTHS' /
   HLDAYPMO  '# DAYS PER MONTH USED HALLUCINOGEN PAST 12 MONTHS' /
   HLDAYPWK  '# DAYS PER WEEK USED HALLUCINOGEN PAST 12 MONTHS' /
   HAL30USE  '# DAYS USED HALLUCINOGEN PAST 30 DAYS' /
   HL30EST   'BEST EST. # DAYS USED HALLUCINOGENS PAST 30 DAYS' /
   LSDAGE    'AGE WHEN FIRST USED LSD' /
   LSDYFU    'YEAR OF FIRST LSD USE - RECODE' /
   LSDMFU    'MONTH OF FIRST LSD USE - RECODE' /
   LSDREC    'TIME SINCE LAST USED LSD' /
   PCPAGE    'AGE WHEN FIRST USED PCP' /
   PCPYFU    'YEAR OF FIRST PCP USE - RECODE' /
   PCPMFU    'MONTH OF FIRST PCP USE - RECODE' /
   PCPREC    'TIME SINCE LAST USED PCP' /
   AMYLNIT   'EVER INHALED AMYL NITRITE, "POPPERS," RUSH, ETC.' /
   CLEFLU    'EVER INHALED CORRECTION FLUID, DEGREASER, ETC.' /
   GAS       'EVER INHALED GASOLINE OR LIGHTER FLUID' /
   GLUE      'EVER INHALED GLUE, SHOE POLISH, OR TOLUENE' /
   ETHER     'EVER INHALED HALOTHANE, ETHER, OR OTHER ANESTHETIC' /
   SOLVENT   'EVER INHALED LACQUER THINNER, OTHER PAINT SOLVENTS' /
   LGAS      'EVER INHALED LIGHTER GASES (BUTANE, PROPANE)' /
   NITOXID   'EVER INHALED NITROUS OXIDE OR "WHIPPETS"' /
   SPPAINT   'EVER INHALED SPRAY PAINTS' /
   AEROS     'EVER INHALED OTHER AEROSOL SPRAYS' /
   INHNOLST  'EVER USED OTHER INHALANTS' /
   INHNEWA   'OTHER INHALANT - SPECIFY 1' /
   INHNEWB   'OTHER INHALANT - SPECIFY 2' /
   INHNEWC   'OTHER INHALANT - SPECIFY 3' /
   INHNEWD   'OTHER INHALANT - SPECIFY 4' /
   INHNEWE   'OTHER INHALANT - SPECIFY 5' /
   INHAGE    'AGE WHEN FIRST USED INHALANTS' /
   INHYFU    'YEAR OF FIRST INHALANT USE - RECODE' /
   INHMFU    'MONTH OF FIRST INHALANT USE - RECODE' /
   INHREC    'TIME SINCE LAST USED INHALANTS' /
   INHYRTOT  'TOTAL # OF DAYS USED INHALANT PAST 12 MONTHS' /
   INTOTFG   'TRIMMING INDICATOR FOR INHYRTOT' /
   INFQFLG   'TRIMMED INHYRTOT IF R USED < 12 MOS' /
   INBSTWAY  'EASIEST WAY TO TELL US # DAYS USED INHALANTS' /
   INDAYPYR  '# DAYS USED INHALANT PAST 12 MONTHS' /
   INDAYPMO  '# DAYS PER MONTH USED INHALANT PAST 12 MONTHS' /
   INDAYPWK  '# DAYS PER WEEK USED INHALANT PAST 12 MONTHS' /
   INHDY30A  '# DAYS USED INHALANT PAST 30 DAYS' /
   IN30EST   'BEST ESTIMATE # DAYS USED INHALANTS PAST 30 DAYS' /
   DARVTYLC  'EVER USED DARVOCET, DARVON, OR TYLENOL W/ CODEINE' /
   PERCTYLX  'EVER USED PERCOCET, PERCODAN, OR TYLOX' /
   VICOLOR   'EVER USED VICODIN, LORTAB, OR LORCET' /
   ANLCARD   'EVER USED PAIN RELIEVER BELOW RED LINE ON CARD A' /
   CODEINE   'EVER USED CODEINE "NONMEDICALLY"' /
   DEMEROL   'EVER USED DEMEROL "NONMEDICALLY"' /
   DILAUD    'EVER USED DILAUDID "NONMEDICALLY"' /
   FIORICET  'EVER USED FIORICET "NONMEDICALLY"' /
   FIORINAL  'EVER USED FIORINAL "NONMEDICALLY"' /
   HYDROCOD  'EVER USED HYDROCODONE "NONMEDICALLY"' /
   METHDON   'EVER USED METHADONE "NONMEDICALLY"' /
   MORPHINE  'EVER USED MORPHINE "NONMEDICALLY"' /
   OXYCONTN  'EVER USED OXYCONTIN "NONMEDICALLY"' /
   PHENCOD   'EVER USED PHENAPHEN WITH CODEINE "NONMEDICALLY"' /
   PROPOXY   'EVER USED PROPOXYPHENE "NONMEDICALLY"' /
   SK65A     'EVER USED SK65 "NONMEDICALLY"' /
   STADOL    'EVER USED STADOL "NONMEDICALLY"' /
   TALACEN   'EVER USED TALACEN "NONMEDICALLY"' /
   TALWIN    'EVER USED TALWIN "NONMEDICALLY"' /
   TALWINNX  'EVER USED TALWIN NX "NONMEDICALLY"' /
   TRAMADOL  'EVER USED TRAMADOL "NONMEDICALLY"' /
   ULTRAM    'EVER USED ULTRAM "NONMEDICALLY"' /
   ANLNOLST  'EVER USED ANY OTHER PAIN RELIEVER "NONMEDICALLY"' /
   ANALNEWA  'OTHER PAIN RELIEVER - SPECIFY 1' /
   ANALNEWB  'OTHER PAIN RELIEVER - SPECIFY 2' /
   ANALNEWC  'OTHER PAIN RELIEVER - SPECIFY 3' /
   ANALNEWD  'OTHER PAIN RELIEVER - SPECIFY 4' /
   ANALNEWE  'OTHER PAIN RELIEVER - SPECIFY 5' /
   ANALAGE   'AGE WHEN FIRST USED PAIN RELIEVERS "NONMEDICALLY"' /
   ANALYFU   'YEAR OF FIRST PAIN RELIEVER USE - RECODE' /
   ANALMFU   'MONTH OF FIRST PAIN RELIEVER USE - RECODE' /
   ANALREC   'TIME SINCE LAST USED PAIN RELIEVER "NONMEDICALLY"' /
   ANLYRTOT  'TOTAL # DAYS USED PAIN RELIEVER PAST 12 MONTHS' /
   PRTOTFG   'TRIMMING INDICATOR FOR ANLYRTOT' /
   PRFQFLG   'TRIMMED ANLYRTOT IF R USED < 12 MOS' /
   PRBSTWAY  'EASIEST WAY TO TELL US # DAYS USED PAIN RELIEVER' /
   PRDAYPYR  '# DAYS USED PAIN RELIEVER "NM" PAST 12 MONTHS' /
   PRDAYPMO  '# DAYS PER MO USED PAIN RELIEVER "NM" PAST 12 MOS' /
   PRDAYPWK  '# DAYS PER WK USED PAIN RELIEVER "NM" PAST 12 MOS' /
   KLONOPIN  'EVER USED KLONOPIN OR CLONAZEPAM' /
   XNAXATVN  'EVER USED XANAX, ALPRAZOLAM, ATIVAN, OR LORAZEPAM' /
   VALMDIAZ  'EVER USED VALIUM OR DIAZEPAM' /
   TRNCARD   'EVER USED ANY TRANQ BELOW RED LINE ON CARD B' /
   ATARAX    'EVER USED ATARAX "NONMEDICALLY"' /
   BUSPAR    'EVER USED BUSPAR "NONMEDICALLY"' /
   EQUANIL   'EVER USED EQUANIL "NONMEDICALLY"' /
   FLEXERIL  'EVER USED FLEXERIL "NONMEDICALLY"' /
   LIBRIUM   'EVER USED LIBRIUM "NONMEDICALLY"' /
   LIMBTROL  'EVER USED LIMBITROL "NONMEDICALLY"' /
   MEPROB    'EVER USED MEPROBAMATE "NONMEDICALLY"' /
   MILTOWN   'EVER USED MILTOWN "NONMEDICALLY"' /
   ROHYPNOL  'EVER USED ROHYPNOL "NONMEDICALLY"' /
   SERAX     'EVER USED SERAX "NONMEDICALLY"' /
   SOMA      'EVER USED SOMA "NONMEDICALLY"' /
   TRANXENE  'EVER USED TRANXENE "NONMEDICALLY"' /
   VISTAR    'EVER USED VISTARIL "NONMEDICALLY"' /
   TRNOLST   'EVER USED ANY OTHER TRANQUILIZER "NONMEDICALLY"' /
   TRNEWA    'OTHER TRANQUILIZER - SPECIFY 1' /
   TRNEWB    'OTHER TRANQUILIZER - SPECIFY 2' /
   TRNEWC    'OTHER TRANQUILIZER - SPECIFY 3' /
   TRNEWD    'OTHER TRANQUILIZER - SPECIFY 4' /
   TRNEWE    'OTHER TRANQUILIZER - SPECIFY 5' /
   TRANAGE   'AGE WHEN FIRST USED TRANQUILIZERS "NONMEDICALLY"' /
   TRANYFU   'YEAR OF FIRST TRANQUILIZER USE - RECODE' /
   TRANMFU   'MONTH OF FIRST TRANQUILIZER USE - RECODE' /
   TRANREC   'TIME SINCE LAST USED TRANQUILIZERS "NONMEDICALLY"' /
   TRNYRTOT  'TOTAL # DAYS USED TRANQUILIZERS PAST 12 MONTHS' /
   TRTOTFG   'TRIMMING INDICATOR FOR TRNYRTOT' /
   TRFQFLG   'TRIMMED TRNYRTOT IF R USED < 12 MOS' /
   TRBSTWAY  'EASIEST WAY TO TELL US # DAYS USED TRANQUILIZER' /
   TRDAYPYR  '# DAYS USED TRANQUILIZERS "NM" PAST 12 MONTHS' /
   TRDAYPMO  '# DAYS PER MO USED TRANQUILIZERS "NM" PAST 12 MOS' /
   TRDAYPWK  '# DAYS USED PER WK TRANQUILIZERS "NM" PAST 12 MOS' /
   METHDES   'EVER USED METHAMPHETAMINE, DESOXYN, OR METHEDRINE' /
   DIETPILS  'EVER USED DIET PILLS SUCH AS AMPHETAMINES, ETC' /
   RITMPHEN  'EVER USED RITALIN OR METHYLPHENIDATE' /
   STMCARD   'EVER USED ANY STIMULANT BELOW RED LINE ON CARD C' /
   CYLERT    'EVER USED CYLERT "NONMEDICALLY"' /
   DEXED     'EVER USED DEXEDRINE "NONMEDICALLY"' /
   DETAMP    'EVER USED DEXTROAMPHET "NONMEDICALLY"' /
   DIDREX    'EVER USED DIDREX "NONMEDICALLY"' /
   ESKAT     'EVER USED ESKATROL "NONMEDICALLY"' /
   IONAMIN   'EVER USED IONAMIN "NONMEDICALLY"' /
   MAZANOR   'EVER USED MAZANOR "NONMEDICALLY"' /
   OBLA      'EVER USED OBEDRIN-LA "NONMEDICALLY"' /
   PLEGINE   'EVER USED PLEGINE "NONMEDICALLY"' /
   PRELUDIN  'EVER USED PRELUDIN "NONMEDICALLY"' /
   SANOREX   'EVER USED SANOREX "NONMEDICALLY"' /
   TENUATE   'EVER USED TENUATE "NONMEDICALLY"' /
   STMNOLST  'EVER USED ANY OTHER STIMULANT "NONMEDICALLY"' /
   STIMNEWA  'OTHER STIMULANT - SPECIFY 1' /
   STIMNEWB  'OTHER STIMULANT - SPECIFY 2' /
   STIMNEWC  'OTHER STIMULANT - SPECIFY 3' /
   STIMNEWD  'OTHER STIMULANT - SPECIFY 4' /
   STIMNEWE  'OTHER STIMULANT - SPECIFY 5' /
   STIMAGE   'AGE WHEN FIRST USED STIMULANTS "NONMEDICALLY"' /
   STIMYFU   'YEAR OF FIRST STIMULANT USE - RECODE' /
   STIMMFU   'MONTH OF FIRST STIMULANT USE - RECODE' /
   STIMREC   'TIME SINCE LAST USED STIMULANTS "NONMEDICALLY"' /
   STMYRTOT  'TOTAL # DAYS USED STIMULANTS PAST 12 MONTHS' /
   STTOTFG   'TRIMMING INDICATOR FOR STMYRTOT' /
   STFQFLG   'TRIMMED STMYRTOT IF R USED < 12 MOS' /
   STBSTWAY  'EASIEST WAY TO TELL US # DAYS USED STIMULANT' /
   STDAYPYR  '# DAYS USED STIMULANT "NM" PAST 12 MONTHS' /
   STDAYPMO  '# DAYS PER MO USED STIMULANT "NM" PAST 12 MONTHS' /
   STDAYPWK  '# DAYS PER WEEK USED STIMULANT "NM" PAST 12 MONTHS' /
   METHAGE   'AGE WHEN 1ST USED METHAMPH, DESOXYN, METHEDRINE' /
   METHYFU   'YEAR OF FIRST METHAMPHETAMINE USE - RECODE' /
   METHMFU   'MONTH OF FIRST METHAMPHETAMINE USE - RECODE' /
   METHREC   'TIME SINCE LAST USED METHAMPHETAMINES' /
   METHAQ    'EVER USED METHAQUALONE, SOPOR, OR QUAALUDE' /
   NEMBBARB  'EVER USED BARBITURATES SUCH AS NEMBUTAL, ETC' /
   RESTTMAZ  'EVER USED RESTORIL OR TEMAZEPAM' /
   SEDCARD   'EVER USED ANY SEDATIVES BELOW RED LINE ON CARD D' /
   AMYTAL    'EVER USED AMYTAL "NONMEDICALLY"' /
   BUTISOL   'EVER USED BUTISOL "NONMEDICALLY"' /
   CHHYD     'EVER USED CHLORAL HYDRATE "NONMEDICALLY"' /
   DALMANE   'EVER USED DALMANE "NONMEDICALLY"' /
   HALCION   'EVER USED HALCION "NONMEDICALLY"' /
   PHENOBAR  'EVER USED PHENOBARBITAL "NONMEDICALLY"' /
   PLACIDYL  'EVER USED PLACIDYL "NONMEDICALLY"' /
   TUINAL    'EVER USED TUINAL "NONMEDICALLY"' /
   SEDNOLST  'EVER USED ANY OTHER SEDATIVE "NONMEDICALLY"' /
   SEDNEWA   'OTHER SEDATIVES - SPECIFY 1' /
   SEDNEWB   'OTHER SEDATIVES - SPECIFY 2' /
   SEDNEWC   'OTHER SEDATIVES - SPECIFY 3' /
   SEDNEWD   'OTHER SEDATIVES - SPECIFY 4' /
   SEDNEWE   'OTHER SEDATIVES - SPECIFY 5' /
   SEDAGE    'AGE WHEN FIRST USED SEDATIVES "NONMEDICALLY"' /
   SEDYFU    'YEAR OF FIRST SEDATIVE USE - RECODE' /
   SEDMFU    'MONTH OF FIRST SEDATIVE USE - RECODE' /
   SEDREC    'TIME SINCE LAST USED SEDATIVES "NONMEDICALLY"' /
   SEDYRTOT  'TOTAL # OF DAYS USED SEDATIVES PAST 12 MONTHS' /
   SVTOTFG   'TRIMMING INDICATOR FOR SEDYRTOT' /
   SVFQFLG   'TRIMMED SEDYRTOT IF R USED < 12 MOS' /
   SVBSTWAY  'EASIEST WAY TO TELL US # DAYS USED SEDATIVE' /
   SVDAYPYR  '# DAYS USED SEDATIVE "NM" PAST 12 MONTHS' /
   SVDAYPMO  '# DAYS PER MONTH USED SEDATIVE "NM" PAST 12 MONTHS' /
   SVDAYPWK  '# DAYS PER WEEK USED SEDATIVE "NM" PAST 12 MONTHS' /
   IRCIGRC   'CIGARETTE RECENCY - IMPUTATION REVISED' /
   IICIGRC   'CIGARETTE RECENCY - IMPUTATION INDICATOR' /
   II2CIGRC  'CIGARETTE RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRCGRRC   'CIGAR RECENCY - IMPUTATION REVISED' /
   IICGRRC   'CIGAR - IMPUTATION INDICATOR' /
   II2CGRRC  'CIGAR RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRPIPLF   'LIFETIME PIPE USE - IMPUTATION REVISED' /
   IIPIPLF   'LIFETIME PIPE USE - IMPUTATION INDICATOR' /
   IRPIPMN   'PAST MONTH PIPE USE - IMPUTATION REVISED' /
   IIPIPMN   'PAST MONTH PIPE USE - IMPUTATION INDICATOR' /
   IRSLTRC   'SMOKELESS TOBACCO RECENCY-IMPUTATION REVISED' /
   IISLTRC   'SMOKELESS TOBACCO RECENCY-IMPUTATION INDICATOR' /
   II2SLTRC  'SMOKELESS TOBACCO RECENCY-DETAILED IMP INDICATOR' /
   IRCHWRC   'CHEWING TOBACCO RECENCY - IMPUTATION REVISED' /
   IICHWRC   'CHEWING TOBACCO RECENCY - IMPUTATION INDICATOR' /
   II2CHWRC  'CHEWING TOBACCO RECENCY-DETAILED IMP INDICATOR' /
   IRSNFRC   'SNUFF RECENCY - IMPUTATION REVISED' /
   IISNFRC   'SNUFF RECENCY - IMPUTATION INDICATOR' /
   II2SNFRC  'SNUFF RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRALCRC   'ALCOHOL RECENCY - IMPUTATION REVISED' /
   IIALCRC   'ALCOHOL RECENCY - IMPUTATION INDICATOR' /
   II2ALCRC  'ALCOHOL RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRMJRC    'MARIJUANA RECENCY - IMPUTATION REVISED' /
   IIMJRC    'MARIJUANA RECENCY - IMPUTATION INDICATOR' /
   II2MJRC   'MARIJUANA RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRCOCRC   'COCAINE RECENCY - IMPUTATION REVISED' /
   IICOCRC   'COCAINE RECENCY - IMPUTATION INDICATOR' /
   II2COCRC  'COCAINE RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRCRKRC   'CRACK RECENCY - IMPUTATION REVISED' /
   IICRKRC   'CRACK RECENCY - IMPUTATION INDICATOR' /
   II2CRKRC  'CRACK RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRHERRC   'HEROIN RECENCY - IMPUTATION REVISED' /
   IIHERRC   'HEROIN RECENCY - IMPUTATION INDICATOR' /
   II2HERRC  'HEROIN RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRHALRC   'HALLUCINOGEN RECENCY - IMPUTATION REVISED' /
   IIHALRC   'HALLUCINOGEN RECENCY - IMPUTATION INDICATOR' /
   II2HALRC  'HALLUCINOGEN RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRLSDRC   'LSD RECENCY - IMPUTATION REVISED' /
   IILSDRC   'LSD RECENCY - IMPUTATION INDICATOR' /
   II2LSDRC  'LSD RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRPCPRC   'PCP RECENCY - IMPUTATION REVISED' /
   IIPCPRC   'PCP RECENCY - IMPUTATION INDICATOR' /
   II2PCPRC  'PCP RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRINHRC   'INHALANT RECENCY - IMPUTATION REVISED' /
   IIINHRC   'INHALANT RECENCY - IMPUTATION INDICATOR' /
   II2INHRC  'INHALANT RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRANLRC   'PAIN RELIEVER RECENCY - IMPUTATION REVISED' /
   IIANLRC   'PAIN RELIEVER RECENCY - IMPUTATION INDICATOR' /
   II2ANLRC  'PAIN RELIEVER RECENCY-DETAILED IMP INDICATOR' /
   IRTRNRC   'TRANQUILIZER RECENCY - IMPUTATION REVISED' /
   IITRNRC   'TRANQUILIZER RECENCY - IMPUTATION INDICATOR' /
   II2TRNRC  'TRANQUILIZER RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRSTMRC   'STIMULANT RECENCY - IMPUTATION REVISED' /
   IISTMRC   'STIMULANT RECENCY - IMPUTATION INDICATOR' /
   II2STMRC  'STIMULANT RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRMTHRC   'METHAMPHETAMINE RECENCY-IMPUTATION REVISED' /
   IIMTHRC   'METHAMPHETAMINE - IMPUTATION INDICATOR' /
   II2MTHRC  'METHAMPHETAMINE RECENCY-DETAILED IMP INDICATOR' /
   IRSEDRC   'SEDATIVE RECENCY - IMPUTATION REVISED' /
   IISEDRC   'SEDATIVE RECENCY - IMPUTATION INDICATOR' /
   II2SEDRC  'SEDATIVE RECENCY-DETAILED IMPUTATION INDICATOR' /
   IRALCFY   'ALCOHOL FREQUENCY PAST YEAR - IMPUTATION REVISED' /
   IIALCFY   'ALCOHOL FREQUENCY PAST YEAR - IMPUTATION INDICATOR' /
   II2ALCFY  'ALCOHOL FREQ PAST YEAR - DETAILED IMP INDICATOR' /
   IRMJFY    'MARIJUANA FREQUENCY PAST YEAR - IMPUTATION REVISED' /
   IIMJFY    'MARIJUANA FREQUENCY PAST YEAR - IMP INDICATOR' /
   II2MJFY   'MARIJUANA FREQ PAST YEAR - DETAILED IMP INDICATOR' /
   IRCOCFY   'COCAINE FREQUENCY PAST YEAR - IMPUTATION REVISED' /
   IICOCFY   'COCAINE FREQUENCY PAST YEAR - IMPUTATION INDICATOR' /
   II2COCFY  'COCAINE FREQ PAST YEAR - DETAILED IMP INDICATOR' /
   IRCRKFY   'CRACK FREQUENCY PAST YEAR - IMPUTATION REVISED' /
   IICRKFY   'CRACK FREQUENCY PAST YEAR - IMPUTATION INDICATOR' /
   II2CRKFY  'CRACK FREQ PAST YEAR - DETAILED IMP INDICATOR' /
   IRHERFY   'HEROIN FREQUENCY PAST YEAR - IMPUTATION REVISED' /
   IIHERFY   'HEROIN FREQUENCY PAST YEAR - IMPUTATION INDICATOR' /
   II2HERFY  'HEROIN FREQ PAST YEAR - DETAILED IMP INDICATOR' /
   IRHALFY   'HALL FREQUENCY PAST YEAR - IMPUTATION REVISED' /
   IIHALFY   'HALL FREQUENCY PAST YEAR - IMPUTATION INDICATOR' /
   II2HALFY  'HALL FREQ PAST YEAR - DETAILED IMP INDICATOR' /
   IRINHFY   'INHALANT FREQUENCY PAST YEAR - IMPUTATION REVISED' /
   IIINHFY   'INHALANT FREQUENCY PAST YEAR - IMP INDICATOR' /
   II2INHFY  'INHALANT FREQ PAST YEAR - DETAILED IMP INDICATOR' /
   IRANLFY   'PAIN RELIEVER FREQ PAST YEAR-IMPUTATION REVISED' /
   IIANLFY   'PAIN RELIEVER FREQ PAST YEAR - IMP INDICATOR' /
   II2ANLFY  'PAIN RELIEVER FREQ PAST YR-DETAILED IMP INDICATOR' /
   IRTRNFY   'TRANQUILIZER FREQ PAST YEAR-IMPUTATION REVISED' /
   IITRNFY   'TRAN FREQUENCY PAST YEAR - IMPUTATION INDICATOR' /
   II2TRNFY  'TRAN FREQ PAST YEAR - DETAILED IMP INDICATOR' /
   IRSTMFY   'STIMULANT FREQUENCY PAST YEAR-IMPUTATION REVISED' /
   IISTMFY   'STIM FREQUENCY PAST YEAR - IMPUTATION INDICATOR' /
   II2STMFY  'STIM FREQ PAST YEAR - DETAILED IMP INDICATOR' /
   IRSEDFY   'SEDATIVE FREQUENCY PAST YEAR-IMPUTATION REVISED' /
   IISEDFY   'SEDATIVE FREQUENCY PAST YEAR - IMP INDICATOR' /
   II2SEDFY  'SEDATIVE FREQ PAST YEAR - DETAILED IMP INDICATOR' /
   IRCIGFM   'CIGARETTE FREQ PAST MONTH - IMPUTATION REVISED' /
   IICIGFM   'CIGARETTE FREQ PAST MONTH - IMPUTATION INDICATOR' /
   II2CIGFM  'CIGARETTE FREQ PAST MONTH - DETAILED IMP INDICATOR' /
   IRCGRFM   'CIGAR FREQUENCY PAST MONTH - IMPUTATION REVISED' /
   IICGRFM   'CIGAR FREQUENCY PAST MONTH - IMPUTATION INDICATOR' /
   II2CGRFM  'CIGAR FREQUENCY PST MONTH - DETAILED IMP INDICATOR' /
   IRCHWFM   'CHEWING TOB FREQUENCY PST MON - IMPUTATION REVISED' /
   IICHWFM   'CHEWING TOB FREQ PAST MONTH-IMPUTATION INDICATOR' /
   II2CHWFM  'CHEWING TOB FREQ PST MONTH-DETAILED IMP INDICATOR' /
   IRSNFFM   'SNUFF FREQUENCY PAST MONTH - IMPUTATION REVISED' /
   IISNFFM   'SNUFF FREQUENCY PAST MONTH - IMPUTATION INDICATOR' /
   II2SNFFM  'SNUFF FREQUENCY PST MONTH - DETAILED IMP INDICATOR' /
   IRALCFM   'ALCOHOL FREQUENCY PAST MONTH - IMPUTATION REVISED' /
   IIALCFM   'ALCOHOL FREQ PAST MONTH - IMPUTATION INDICATOR' /
   II2ALCFM  'ALCOHOL FREQ PST MONTH - DETAILED IMP INDICATOR' /
   IRALCD5   '5+ ALC DRNKS PAST MONTH - IMP REVISED (DR5DAY)' /
   IIALCD5   '5+ ALC DRNKS PAST MONTH - IMPUTATION INDICATOR' /
   II2ALCD5  '5+ ALC DRINKS PAST MONTH - DETAILED IMP INDICATOR' /
   IRMJFM    'MARIJUANA FREQUENCY PAST MONTH - IMP REVISED' /
   IIMJFM    'MARIJUANA FREQUENCY PAST MONTH - IMP INDICATOR' /
   II2MJFM   'MARIJUANA FREQ PAST MONTH - DETAILED IMP INDICATOR' /
   IRCOCFM   'COCAINE FREQUENCY PAST MONTH - IMPUTATION REVISED' /
   IICOCFM   'COCAINE FREQ PAST MONTH - IMPUTATION INDICATOR' /
   II2COCFM  'COCAINE FREQ PAST MONTH - DETAILED IMP INDICATOR' /
   IRCRKFM   'CRACK FREQUENCY PAST MONTH - IMPUTATION REVISED' /
   IICRKFM   'CRACK FREQUENCY PAST MONTH - IMPUTATION INDICATOR' /
   II2CRKFM  'CRACK FREQ PAST MONTH - DETAILED IMP INDICATOR' /
   IRHERFM   'HEROIN FREQUENCY PAST MONTH - IMPUTATION REVISED' /
   IIHERFM   'HEROIN FREQUENCY PAST MONTH - IMPUTATION INDICATOR' /
   II2HERFM  'HEROIN FREQ PAST MONTH - DETAILED IMP INDICATOR' /
   IRHALFM   'HALLUCINOGEN FREQ PAST MONTH - IMPUTATION REVISED' /
   IIHALFM   'HALL FREQUENCY PAST MONTH - IMPUTATION INDICATOR' /
   II2HALFM  'HALL FREQ PAST MONTH - DETAILED IMP INDICATOR' /
   IRINHFM   'INHALANT FREQUENCY PAST MONTH - IMP REVISED' /
   IIINHFM   'INHALANT FREQUENCY PAST MONTH - IMP INDICATOR' /
   II2INHFM  'INHALANT FREQ PAST MONTH - DETAILED IMP INDICATOR' /
   IRCIGAGE  'IMPUTATION-REVISED CIGARETTE AGE OF FIRST USE' /
   IICIGAGE  'IRCIGAGE IMPUTATION INDICATOR' /
   IRCIGYFU  'IMPUTATION-REVISED CIGARETTE YEAR OF FIRST USE' /
   IICIGYFU  'IRCIGYFU IMPUTATION INDICATOR' /
   IRCDUAGE  'IMPUTATION-REVISED DAILY CIG AGE OF FIRST USE' /
   IICDUAGE  'IRCDUAGE IMPUTATION INDICATOR' /
   IRCDUYFU  'IMPUTATION-REVISED DAILY CIG YEAR OF FIRST USE' /
   IICDUYFU  'IRCDUYFU IMPUTATION INDICATOR' /
   IRCGRAGE  'IMPUTATION-REVISED CIGAR AGE OF FIRST USE' /
   IICGRAGE  'IRCGRAGE IMPUTATION INDICATOR' /
   IRCGRYFU  'IMPUTATION-REVISED CIGAR YEAR OF FIRST USE' /
   IICGRYFU  'IRCGRYFU IMPUTATION INDICATOR' /
   IRSNFAGE  'IMPUTATION-REVISED SNUFF AGE OF FIRST USE' /
   IISNFAGE  'IRSNFAGE IMPUTATION INDICATOR' /
   IRSNFYFU  'IMPUTATION-REVISED SNUFF YEAR OF FIRST USE' /
   IISNFYFU  'IRSNFYFU IMPUTATION INDICATOR' /
   IRCHWAGE  'IMPUTATION-REVISED CHEWING TOB AGE FIRST USE' /
   IICHWAGE  'IRCHWAGE IMPUTATION INDICATOR' /
   IRCHWYFU  'IMPUTATION-REVISED CHEWING TOB YEAR FIRST USE' /
   IICHWYFU  'IRCHWYFU IMPUTATION INDICATOR' /
   IRSLTAGE  'IMPUTATION-REVISED SMOKELESS TOB AGE FIRST USE' /
   IISLTAGE  'IRSLTAGE IMPUTATION INDICATOR' /
   IRSLTYFU  'IMPUTATION-REVISED SMOKELESS TOB YEAR OF FIRST USE' /
   IISLTYFU  'IRSNFYFU IMPUTATION INDICATOR' /
   IRALCAGE  'IMPUTATION-REVISED ALCOHOL AGE OF FIRST USE' /
   IIALCAGE  'IRALCAGE IMPUTATION INDICATOR' /
   IRALCYFU  'IMPUTATION-REVISED ALCOHOL YEAR OF FIRST USE' /
   IIALCYFU  'IRALCYFU IMPUTATION INDICATOR' /
   IRMJAGE   'IMPUTATION-REVISED MARIJUANA AGE OF FIRST USE' /
   IIMJAGE   'IRMJAGE IMPUTATION INDICATOR' /
   IRMJYFU   'IMPUTATION-REVISED MARIJUANA YEAR OF FIRST USE' /
   IIMJYFU   'IRMJYFU IMPUTATION INDICATOR' /
   IRCOCAGE  'IMPUTATION-REVISED COCAINE AGE OF FIRST USE' /
   IICOCAGE  'IRCOCAGE IMPUTATION INDICATOR' /
   IRCOCYFU  'IMPUTATION-REVISED COCAINE YEAR OF FIRST USE' /
   IICOCYFU  'IRCOCYFU IMPUTATION INDICATOR' /
   IRCRKAGE  'IMPUTATION-REVISED CRACK AGE OF FIRST USE' /
   IICRKAGE  'IRCRKAGE IMPUTATION INDICATOR' /
   IRCRKYFU  'IMPUTATION-REVISED CRACK YEAR OF FIRST USE' /
   IICRKYFU  'IRCRKYFU IMPUTATION INDICATOR' /
   IRHERAGE  'IMPUTATION-REVISED HEROIN AGE OF FIRST USE' /
   IIHERAGE  'IRHERAGE IMPUTATION INDICATOR' /
   IRHERYFU  'IMPUTATION-REVISED HEROIN YEAR OF FIRST USE' /
   IIHERYFU  'IRHERYFU IMPUTATION INDICATOR' /
   IRHALAGE  'IMPUTATION-REVISED HALLUCINOGEN AGE OF FIRST USE' /
   IIHALAGE  'IRHALAGE IMPUTATION INDICATOR' /
   IRHALYFU  'IMPUTATION-REVISED HALLUCINOGEN YEAR OF FIRST USE' /
   IIHALYFU  'IRHALYFU IMPUTATION INDICATOR' /
   IRLSDAGE  'IMPUTATION-REVISED LSD AGE OF FIRST USE' /
   IILSDAGE  'IRLSDAGE IMPUTATION INDICATOR' /
   IRLSDYFU  'IMPUTATION-REVISED LSD YEAR OF FIRST USE' /
   IILSDYFU  'IRLSDYFU IMPUTATION INDICATOR' /
   IRPCPAGE  'IMPUTATION-REVISED PCP AGE OF FIRST USE' /
   IIPCPAGE  'IRPCPAGE IMPUTATION INDICATOR' /
   IRPCPYFU  'IMPUTATION-REVISED PCP YEAR OF FIRST USE' /
   IIPCPYFU  'IRPCPYFU IMPUTATION INDICATOR' /
   IRINHAGE  'IMPUTATION-REVISED INHALANT AGE OF FIRST USE' /
   IIINHAGE  'IRINHAGE IMPUTATION INDICATOR' /
   IRINHYFU  'IMPUTATION-REVISED INHALANT YEAR OF FIRST USE' /
   IIINHYFU  'IRINHYFU IMPUTATION INDICATOR' /
   IRANLAGE  'IMPUTATION-REVISED PAIN RELIEVERS AGE OF FIRST USE' /
   IIANLAGE  'IRANLAGE IMPUTATION INDICATOR' /
   IRANLYFU  'IMPUTATION-REVISED PAIN RELIEVER YEAR OF FIRST USE' /
   IIANLYFU  'IRANLYFU IMPUTATION INDICATOR' /
   IRTRNAGE  'IMPUTATION-REVISED TRANQUILIZER AGE OF FIRST USE' /
   IITRNAGE  'IRTRNAGE IMPUTATION INDICATOR' /
   IRTRNYFU  'IMPUTATION-REVISED TRANQUILIZER YEAR OF FIRST USE' /
   IITRNYFU  'IRTRNYFU IMPUTATION INDICATOR' /
   IRSTMAGE  'IMPUTATION-REVISED STIMULANTS AGE OF FIRST USE' /
   IISTMAGE  'IRSTMAGE IMPUTATION INDICATOR' /
   IRSTMYFU  'IMPUTATION-REVISED STIMULANTS YEAR OF FIRST USE' /
   IISTMYFU  'IRSTMYFU IMPUTATION INDICATOR' /
   IRMTHAGE  'IMPUTATION-REVISED METHAMPHETAMINE AGE FIRST USE' /
   IIMTHAGE  'IRMTHAGE IMPUTATION INDICATOR' /
   IRMTHYFU  'IMPUTATION-REVISED METHAMPHETAMINE YEAR FIRST USE' /
   IIMTHYFU  'IRMTHYFU IMPUTATION INDICATOR' /
   IRSEDAGE  'IMPUTATION-REVISED SEDATIVES AGE OF FIRST USE' /
   IISEDAGE  'IRSEDAGE IMPUTATION INDICATOR' /
   IRSEDYFU  'IMPUTATION-REVISED SEDATIVES YEAR OF FIRST USE' /
   IISEDYFU  'IRSEDYFU IMPUTATION INDICATOR' /
   CIGFLAG   'CIGARETTES - EVER USED' /
   CIGYR     'CIGARETTES - PAST YEAR USE' /
   CIGMON    'CIGARETTES - PAST MONTH USE' /
   CGRFLAG   'CIGAR - EVER USED' /
   CGRYR     'CIGAR - PAST YEAR USE' /
   CGRMON    'CIGAR - PAST MONTH USE' /
   PIPFLAG   'PIPES - EVER USED' /
   PIPMON    'PIPES - PAST MONTH USE' /
   SMKFLAG   'SMOKELESS TOBACCO - EVER USED' /
   SMKYR     'SMOKELESS TOBACCO - PAST YEAR USE' /
   SMKMON    'SMOKELESS TOBACCO - PAST MONTH USE' /
   CHWFLAG   'CHEWING TOBACCO - EVER USED' /
   CHWYR     'CHEWING TOBACCO - PAST YEAR USE' /
   CHWMON    'CHEWING TOBACCO - PAST MONTH USE' /
   SNFFLAG   'SNUFF - EVER USED' /
   SNFYR     'SNUFF - PAST YEAR USE' /
   SNFMON    'SNUFF - PAST MONTH USE' /
   TOBFLAG   'ANY TOBACCO - EVER USED' /
   TOBYR     'ANY TOBACCO - PAST YEAR USE' /
   TOBMON    'ANY TOBACCO - PAST MONTH USE' /
   CIGBRND2  'CIGARETTE BRAND USED MOST OFTEN IN PAST MONTH' /
   CGRBRND2  'CIGAR BRAND USED MOST OFTEN IN PAST MONTH' /
   SMKBRND2  'SMOKELESS TOBACCO BRAND USED MOST OFTEN IN PST MON' /
   CIGCMPNY  'CIG COMPANY FOR BRAND PAST 30 DYS - RECODE' /
   ALCFLAG   'ALCOHOL - EVER USED' /
   ALCYR     'ALCOHOL - PAST YEAR USE' /
   ALCMON    'ALCOHOL - PAST MONTH USE' /
   MRJFLAG   'MARIJUANA - EVER USED' /
   MRJYR     'MARIJUANA - PAST YEAR USE' /
   MRJMON    'MARIJUANA - PAST MONTH USE' /
   COCFLAG   'COCAINE - EVER USED' /
   COCYR     'COCAINE - PAST YEAR USE' /
   COCMON    'COCAINE - PAST MONTH USE' /
   CRKFLAG   '"CRACK" - EVER USED' /
   CRKYR     '"CRACK" - PAST YEAR USE' /
   CRKMON    '"CRACK" - PAST MONTH USE' /
   HERFLAG   'HEROIN - EVER USED' /
   HERYR     'HEROIN - PAST YEAR USE' /
   HERMON    'HEROIN - PAST MONTH USE' /
   HALFLAG   'HALLUCINOGENS - EVER USED' /
   HALYR     'HALLUCINOGENS - PAST YEAR USE' /
   HALMON    'HALLUCINOGENS - PAST MONTH USE' /
   LSDFLAG   'LSD - EVER USED' /
   LSDYR     'LSD - PAST YEAR USE' /
   LSDMON    'LSD - PAST MONTH USE' /
   PCPFLAG   'PCP - EVER USED' /
   PCPYR     'PCP - PAST YEAR USE' /
   PCPMON    'PCP - PAST MONTH USE' /
   INHFLAG   'INHALANTS - EVER USED' /
   INHYR     'INHALANTS - PAST YEAR USE' /
   INHMON    'INHALANTS - PAST MONTH USE' /
   ANLFLAG   'PAIN RELIEVERS - EVER USED' /
   ANLYR     'PAIN RELIEVERS - PAST YEAR USE' /
   ANLMON    'PAIN RELIEVERS - PAST MONTH USE' /
   TRQFLAG   'TRANQUILIZERS - EVER USED' /
   TRQYR     'TRANQUILIZERS - PAST YEAR USE' /
   TRQMON    'TRANQUILIZERS - PAST MONTH USE' /
   STMFLAG   'STIMULANTS - EVER USED' /
   STMYR     'STIMULANTS - PAST YEAR USE' /
   STMMON    'STIMULANTS - PAST MONTH USE' /
   MTHFLAG   'METHAMPHETAMINES-EVER USED' /
   MTHYR     'METHAMPHETAMINES - PAST YEAR USE' /
   MTHMON    'METHAMPHETAMINES - PAST MONTH USE' /
   SEDFLAG   'SEDATIVES - EVER USED' /
   SEDYR     'SEDATIVES - PAST YEAR USE' /
   SEDMON    'SEDATIVES - PAST MONTH USE' /
   PSYFLAG2  'ANY PSYCHOTHERAPEUTICS - EVER USED' /
   PSYYR2    'ANY PSYCHOTHERAPEUTICS - PAST YEAR USE' /
   PSYMON2   'ANY PSYCHOTHERAPEUTICS - PAST MONTH USE' /
   SUMFLAG   'ANY ILLICIT DRUG - EVER USED' /
   SUMYR     'ANY ILLICIT DRUG - PAST YEAR USE' /
   SUMMON    'ANY ILLICIT DRUG - PAST MONTH USE' /
   MJOFLAG   'MARIJUANA ONLY - EVER USED' /
   MJOYR2    'MARIJUANA ONLY - PAST YEAR USE' /
   MJOMON2   'MARIJUANA ONLY - PAST MONTH USE' /
   IEMFLAG   'ILLICIT DRUG EXCEPT FOR MARIJUANA - EVER USED' /
   IEMYR     'ILLICIT DRUG EXCEPT FOR MARIJUANA - PAST YEAR USED' /
   IEMMON    'ILLICIT DRUG EXCEPT FOR MARIJUANA-PAST MONTH USED' /
   BINGEDRK  'BINGE ALCOHOL USE PAST 30 DAYS' /
   HVYDRK2   'HEAVY ALCOHOL USE PAST 30 DAYS' /
   BINGEHVY  'LEVEL OF ALCOHOL USE PAST MONTH' /
   PEYOTE2   'EVER USED PEYOTE' /
   MESC2     'EVER USED MESCALINE' /
   PSILCY2   'EVER USED PSILOCYBIN (MUSHROOMS)' /
   ECSTASY2  'EVER USED "ECSTASY" (MDMA)' /
   AMYLNIT2  'EVER INHALED AMYL NITRITE, "POPPERS," RUSH, ETC.' /
   CLEFLU2   'EVER INHALED CORRECTION FLUID, DEGREASER, ETC.' /
   GAS2      'EVER INHALED GASOLINE OR LIGHTER FLUID' /
   GLUE2     'EVER INHALED GLUE, SHOE POLISH, OR TOLUENE' /
   ETHER2    'EVER INHALED HALOTHANE, ETHER, OR OTHER ANESTHETIC' /
   SOLVENT2  'EVER INHALED LACQUER THINNER, OTHER PAINT SOLVENTS' /
   LGAS2     'EVER INHALED LIGHTER GASES (BUTANE, PROPANE)' /
   NITOXID2  'EVER INHALED NITROUS OXIDE OR "WHIPPETS"' /
   SPPAINT2  'EVER INHALED SPRAY PAINTS' /
   AEROS2    'EVER INHALED OTHER AEROSOL SPRAYS' /
   DARVTYL2  'EVER USED DARVOCET, DARVON, TYLENOL W/CODEINE' /
   PERCTYL2  'EVER USED PERCOCET, PERCODAN, TYLOX' /
   VICOLOR2  'EVER USED VICODIN, LORTAB, LORCET' /
   CODEINE2  'EVER USED CODEINE' /
   DEMEROL2  'EVER USED DEMEROL' /
   DILAUD2   'EVER USED DILAUDID' /
   FIORICT2  'EVER USED FIORICET' /
   FIORINL2  'EVER USED FIORINAL' /
   HYDROCD2  'EVER USED HYDROCODONE' /
   METHDON2  'EVER USED METHADONE' /
   MORPHIN2  'EVER USED MORPHINE' /
   OXYCONT2  'EVER USED OXYCONTIN' /
   PHENCOD2  'EVER USED PHENAPHEN WITH CODEINE' /
   PROPOXY2  'EVER USED PROPOXYPHENE' /
   SK65A2    'EVER USED SK65' /
   STADOL2   'EVER USED STADOL' /
   TALACEN2  'EVER USED TALACEN' /
   TALWIN2   'EVER USED TALWIN' /
   TALWINX2  'EVER USED TALWIN NX' /
   TRAMADL2  'EVER USED TRAMADOL' /
   ULTRAM2   'EVER USED ULTRAM' /
   OTHANL    'EVER USED OTHER PAIN RELIEVERS' /
   KLONOPI2  'EVER USED KLONOPIN OR CLONAZEPAM' /
   XNAXATV2  'EVER USED XANAX, ALPRAZOLAM, ATVIAN' /
   VALMDIA2  'EVER USED VALIUM OR DIAZEPAM FOR FEELING' /
   ATARAX2   'EVER USED ATARAX' /
   BUSPAR2   'EVER USED BUSPAR' /
   EQUANIL2  'EVER USED EQUANIL' /
   FLEXERL2  'EVER USED FLEXERIL' /
   LIBRIUM2  'EVER USED LIBRIUM' /
   LIMBTRL2  'EVER USED LIMBITROL' /
   MEPROB2   'EVER USED MEPROBAMATE' /
   MILTOWN2  'EVER USED MILTOWN' /
   ROHYPNL2  'EVER USED ROHYPNOL' /
   SERAX2    'EVER USED SERAX' /
   SOMA2     'EVER USED SOMA' /
   TRANXEN2  'EVER USED TRANXENE' /
   VISTAR2   'EVER USED VISTARIL' /
   OTHTRN    'EVER USED OTHER TRANQUILIZERS' /
   METHDES2  'EVER USED METHAMPHETAMINE, DESOXYN, OR METHEDRINE' /
   DIETPIL2  'EVER USED DIET PILLS FOR FEELING CAUSED' /
   RITMPHE2  'EVER USED RITALIN FOR FEELING CAUSED' /
   CYLERT2   'EVER USED CYLERT' /
   DEXED2    'EVER USED DEXEDRINE' /
   DETAMP2   'EVER USED DEXTROAMPHETAMINE' /
   DIDREX2   'EVER USED DIDREX' /
   ESKAT2    'EVER USED ESKATROL' /
   IONAMIN2  'EVER USED IONAMIN' /
   MAZANOR2  'EVER USED MAZANOR' /
   OBLA2     'EVER USED OBEDRIN-LA' /
   PLEGINE2  'EVER USED PLEGINE' /
   PRELUDN2  'EVER USED PRELUDIN' /
   SANOREX2  'EVER USED SANOREX' /
   TENUATE2  'EVER USED TENUATE' /
   OTHSTM    'EVER USED OTHER STIMULANTS' /
   METHAQ2   'EVER USED METHAQUALONE, SOPOR, QUALLUDE' /
   NEMBBAR2  'EVER USED BARBITURATES FOR FEELING' /
   RESTTMA2  'EVER USED RESTORIL OR TEMAZEPAM' /
   AMYTAL2   'EVER USED AMYTAL' /
   BUTISOL2  'EVER USED BUTISOL' /
   CHHYD2    'EVER USED CHLORAL HYDRATE' /
   DALMANE2  'EVER USED DALMANE' /
   HALCION2  'EVER USED HALCION' /
   PHENOBR2  'EVER USED PHENOBARBITAL' /
   PLACIDY2  'EVER USED PLACIDYL' /
   TUINAL2   'EVER USED TUINAL' /
   OTHSED    'EVER USED OTHER SEDATIVES' /
   ALCAFU    'ALCOHOL AGE OF FIRST USE - CATEGORIZED RECODE' /
   MJAFU     'MARIJUANA AGE OF FIRST USE - CATEGORIZED RECODE' /
   COCAFU    'COCAINE AGE OF FIRST USE - CATEGORIZED RECODE' /
   HERAFU    'HEROIN AGE OF FIRST USE - CATEGORIZED RECODE' /
   HALAFU    'HALLUCINOGEN AGE OF FIRST USE - CATEGORIZED RECODE' /
   INHAFU    'INHALANT AGE OF FIRST USE - CATEGORIZED RECODE' /
   ANLAFU    'PAIN RELIEVER AGE OF FIRST USE - CATEGORIZED RECOD' /
   TRNAFU    'TRANQUILIZER AGE OF FIRST USE - CATEGORIZED RECODE' /
   STMAFU    'STIMULANT AGE OF FIRST USE - CATEGORIZED RECODE' /
   SEDAFU    'SEDATIVE AGE OF FIRST USE - CATEGORIZED RECODE' /
   CIGAFU    'CIGARETTE AGE OF FIRST USE - CATEGORIZED RECODE' /
   CGRAFU    'CIGAR AGE OF FIRST USE - CATEGORIZED RECODE' /
   SLTAFU    'SMOKELSS TOB AGE OF FIRST USE - CATEGORIZED RECODE' /
   MRJYDAYS  '# OF DAYS USED MARIJUANA IN PAST YEAR' /
   COCYDAYS  '# OF DAYS USED COCAINE IN PAST YEAR' /
   HALYDAYS  '# OF DAYS USED HALLUCINOGENS IN PAST YEAR' /
   INHYDAYS  '# OF DAYS USED INHALANTS IN PAST YEAR' /
   ALCYDAYS  '# OF DAYS USED ALCOHOL IN PAST YEAR' /
   MRJMDAYS  '# OF DAYS USED MARIJUANA PAST MONTH' /
   COCMDAYS  '# OF DAYS USED COCAINE IN PAST MONTH' /
   HALMDAYS  '# OF DAYS USED HALLUCINOGENS IN PAST MONTH' /
   INHMDAYS  '# OF DAYS USED INHALANTS IN PAST MONTH' /
   ALCMDAYS  '# OF DAYS USED ALCOHOL IN PAST MONTH' /
   CIGMDAYS  '# OF DAYS USED CIG IN PAST MONTH' /
   CIGPDAY   '# OF CIGARETTES SMOKED PER DAY AMONG DAILY SMOKERS' /
   CG05      'HAVE YOU SMOKED CIG IN PAST 30 DAYS' /
   CG06      'TIME SINCE LAST SMOKE A CIG (IF NOT PAST MO)' /
   CG06DK    'BEST GUESS TIME SINCE LAST SMOKE A CIGARETTE' /
   CG06RE    'RECONSIDER ANSWERING TIME SINCE LAST SMOKE A CIG' /
   CG19      'HAVE YOU USED CHEW IN PAST 30 DAYS' /
   CG20      'TIME SINCE LAST USED CHEW (IF NOT PAST MO)' /
   CG20DK    'BEST GUESS HOW LONG SINCE USED CHEWING TOBACCO' /
   CG20RE    'PLEASE ANSWER HOW LONG SINCE USED CHEWING TOBACCO' /
   CG27      'HAVE YOU USED SNUFF IN PAST 30 DAYS' /
   CG28      'TIME SINCE LAST USE SNUFF (IF NOT PAST MO)' /
   CG28DK    'BEST GUESS TIME SINCE LAST USE SNUFF' /
   CG28RE    'RECONSIDER ANSWERING TIME SINCE LAST USE SNUFF' /
   CG36      'HAVE YOU SMOKED CIGAR IN PAST 30 DAYS' /
   CG37      'TIME SINCE LAST SMOKED CIGAR (IF NOT PAST MO)' /
   CG37DK    'BEST GUESS TIME SINCE LAST SMOKED CIGAR' /
   CG37RE    'RECONSIDER ANSWERING TIME SINCE LAST SMOKED CIGAR' /
   CG43      'HAVE YOU SMOKED PIPE TOBACCO IN PAST 30 DAYS' /
   ALLAST3   'TIME SINCE LAST DRANK ALCOHOLIC BEVERAGE' /
   ALRECDK   'BEST GUESS TIME SINCE LAST DRANK ALCOHOLIC BEV' /
   ALRECRE   'RECONSIDER ANSWERING TIME SINCE LST DRANK ALC BEV' /
   TOTDRINK  'TOTAL # OF DAYS USED ALCOHOL IN PAST 12 MOS' /
   ALFRAME3  'EASIEST WAY TO TELL US # DAYS DRANK ALCOHOL' /
   ALYRAVE   'NUMBER DAYS DRANK ALCOHOL IN PAST 12 MOS' /
   ALMONAVE  '# DAYS PER MONTH DRANK ALCOHOL IN PAST 12 MOS' /
   ALWKAVE   '# DAYS PER WEEK DRANK ALCOHOL IN  PAST 12 MOS' /
   MJLAST3   'TIME SINCE LAST USED MARIJUANA/HASHISH' /
   MJRECDK   'BEST GUESS TIME SINCE LAST USED MARIJUANA/HASHISH' /
   MJRECRE   'RECONSIDER TIME SINCE LAST USED MARIJUANA/HASHISH' /
   TOTMJ     'TOTAL # OF DAYS USED MARIJUANA IN PAST 12 MOS' /
   MJFRAME3  'EASIEST WAY TO TELL US # DAYS USED MARIJUANA/HASH' /
   MJYRAVE   '# DAYS USED MARIJUANA/HASHISH PAST 12 MONTHS' /
   MJMONAVE  '# DAYS PER MOS USED MARIJUANA/HASHISH PAST 12 MOS' /
   MJWKAVE   '# DAYS PER WEEK USED MARIJUANA/HASHISH PAST 12 MOS' /
   CCLAST3   'TIME SINCE LAST USED COCAINE' /
   CCRECDK   'BEST GUESS TIME SINCE LAST USED COCAINE' /
   CCRECRE   'RECONSIDER ANSWERING TIME SINCE LAST USED COCAINE' /
   TOTCOKE   'TOTAL # OF DAYS USED COCAINE IN PAST 12 MONTHS' /
   CCFRAME3  'EASIEST WAY TO TELL US # DAYS USED COCAINE' /
   CCYRAVE   '# DAYS USED COCAINE PAST 12 MONTHS' /
   CCMONAVE  '# DAYS PER MONTH USED COCAINE PAST 12 MONTHS' /
   CCWKAVE   '# DAYS PER WEEK USED COCAINE PAST 12 MONTHS' /
   CKLAST3   'TIME SINCE LAST USED CRACK' /
   CKRECDK   'BEST GUESS TIME SINCE LAST USED CRACK' /
   CKRECRE   'RECONSIDER TIME SINCE LAST USED CRACK' /
   TOTCRACK  'TOTAL # DAYS USED CRACK IN PAST 12 MONTHS' /
   CKFRAME3  'EASIEST WAY TO TELL US # DAYS USED CRACK' /
   CKYRAVE   '# DAYS USED CRACK PAST 12 MONTHS' /
   CKMONAVE  '# DAYS PER MONTH USED CRACK PAST 12 MONTHS' /
   CKWKAVE   '# DAYS PER WEEK USED CRACK PAST 12 MONTHS' /
   HELAST3   'TIME SINCE LAST USED HEROIN' /
   HERECDK   'BEST GUESS TIME SINCE LAST USED HEROIN' /
   HERECRE   'RECONSIDER ANSWERING TIME SINCE LAST USED HEROIN' /
   TOTHERO   'TOTAL # OF DAYS USED HEROIN IN PAST 12 MONTHS' /
   HEFRAME3  'EASIEST WAY TO TELL US # DAYS USED HEROIN' /
   HEYRAVE   '# DAYS USED HEROIN PAST 12 MONTHS' /
   HEMONAVE  '# DAYS PER MONTH USED HEROIN PAST 12 MONTHS' /
   HEWKAVE   '# DAYS PER WEEK USED HEROIN PAST 12 MONTHS' /
   LSLAST    'TIME SINCE LAST USED HALLUCINOGEN' /
   LSRECDK   'BEST GUESS TIME SINCE LAST USED HALLUCINOGEN' /
   LSRECRE   'RECONSIDER TIME SINCE LAST USED HALLUCINOGEN' /
   TOTHALL   'TOTAL # OF DAYS USED HALLUCINOGENS IN PAST 12 MOS' /
   LSFRAME3  'EASIEST WAY TO TELL US # DAYS USED HALLUCINOGEN' /
   LSYRAVE   '# DAYS USED HALLUCINOGEN PAST 12 MONTHS' /
   LSMONAVE  '# DAYS PER MONTH USED HALLUCINOGEN PAST 12 MONTHS' /
   LSWKAVE   '# DAYS PER WEEK USED HALLUCINOGEN PAST 12 MONTHS' /
   LS10      'TIME SINCE USED LSD LAST' /
   LS16      'HOW LONG SINCE USED PCP' /
   INLAST    'TIME SINCE LAST USED INHALANT' /
   INRECDK   'BEST GUESS HOW LONG SINCE LAST USED INHALANTS' /
   INRECRE   'RECONSIDER HOW LONG SINCE LAST USED INHALANTS' /
   TOTINHAL  'TOTAL # OF DAYS USED INHALANT PAST 12 MONTHS' /
   INFRAME3  'EASIEST WAY TO TELL US # DAYS USED INHALANT' /
   INYRAVE   '# DAYS USED INHALANT PAST 12 MONTHS' /
   INMONAVE  '# DAYS PER MONTH USED INHALANT PAST 12 MONTHS' /
   INWKAVE   '# DAYS PER WEEK USED INHALANT PAST 12 MONTHS' /
   PR09      'TIME SINCE LAST USED PAIN RELIEVER "NONMEDICALLY"' /
   PRRECDK   'BEST GUESS LAST USED PAIN RELIEVER "NONMEDICALLY"' /
   PRRECRE   'RECONSIDER LAST USED PAIN RELIEVER "NONMEDICALLY"' /
   PR10      'EASIEST WAY TO TELL US # DAYS USED PAIN RELIEVER' /
   PR11      '# DAYS USED PAIN RELIEVER "NM" PAST 12 MONTHS' /
   PR12      '# DAYS PER MO USED PAIN RELIEVER "NM" PAST 12 MOS' /
   PR13      '# DAYS PER WK USED PAIN RELIEVER "NM" PAST 12 MOS' /
   TR09      'TIME SINCE LAST USED TRANQUILIZER "NONMEDICALLY"' /
   TRRECDK   'BEST GUESS HOW LONG SINCE USD TRANQUILIZER "NM"' /
   TRRECRE   'RECONSIDER HOW LONG SINCE USD TRANQUILIZER "NM"' /
   TR10      'EASIEST WAY TO TELL US # DAYS USED TRANQUILIZER' /
   TR11      '# DAYS USED TRANQUILIZERS "NM" PAST 12 MONTHS' /
   TR12      '# DAYS PER MO USED TRANQUILIZERS "NM" PAST 12 MOS' /
   TR13      '# DAYS USED PER WK TRANQUILIZERS "NM" PAST 12 MOS' /
   ST09      'TIME SINCE LAST USED STIMULANT "NONMEDICALLY"' /
   STRECDK   'BEST GUESS TIME SINCE LAST USED STIMULANTS "NM"' /
   STRECRE   'RECONSIDER TIME SINCE LAST USED STIMULANTS "NM"' /
   ST10      'EASIEST WAY TO TELL US # DAYS USED STIMULANT' /
   ST11      '# DAYS USED STIMULANT "NM" PAST 12 MONTHS' /
   ST12      '# DAYS PER MO USED STIMULANT "NM" PAST 12 MONTHS' /
   ST13      '# DAYS PER WEEK USED STIMULANT "NM" PAST 12 MONTHS' /
   ST19      'HOW LONG SINCE USED METHAMPH, DESOXYN, METHEDRINE' /
   SV09      'TIME SINCE LAST USED SEDATIVE "NONMEDICALLY"' /
   SVRECDK   'BEST GUESS TIME SINCE LAST USED SEDATIVE "NM"' /
   SVRECRE   'RECONSIDER TIME SINCE LAST USED SEDATIVE "NM"' /
   SV10      'EASIEST WAY TO TELL US # DAYS USED SEDATIVE' /
   SV11      '# DAYS USED SEDATIVE "NM" PAST 12 MONTHS' /
   SV12      '# DAYS PER MONTH USED SEDATIVE "NM" PAST 12 MONTHS' /
   SV13      '# DAYS PER WEEK USED SEDATIVE "NM" PAST 12 MONTHS' /
   HERSMOKE  'EVER SMOKED HEROIN' /
   HRSMKREC  'TIME SINCE LAST SMOKED HEROIN' /
   HERSNIFF  'EVER SNIFFED HEROIN' /
   HRSNFREC  'TIME SINCE LAST SNIFFED HEROIN' /
   GNNDLLIF  'EVER USED A NEEDLE TO INJECT DRUGS NOT PRESCRIBED' /
   COCNEEDL  'EVER USED NEEDLE TO INJECT COCAINE' /
   CONDLREC  'TIME SINCE LAST USED NEEDLE TO INJECT COCAINE' /
   HERNEEDL  'EVER USED NEEDLE TO INJECT HEROIN' /
   HRNDLREC  'TIME SINCE LAST USED NEEDLE TO INJECT HEROIN' /
   STNEEDLE  'EVER USED NEEDLE TO INJECT STIMULANT' /
   STNDLREC  'TIME SINCE LAST USED NEEDLE TO INJECT STIMULANT' /
   GNNDREUS  'LAST TIME REUSED NEEDLE USED BEFORE' /
   GNNDLSH1  'LAST NEEDLE HAD BEEN USED BY SOMEONE ELSE' /
   GNNDCLEN  'USED BLEACH TO CLEAN LAST NEEDLE BEFORE USE' /
   GNNDLSH2  'SOMEONE ELSE USED LAST NEEDLE AFTER YOU' /
   GNNDGET2  'HOW DID YOU GET THE NEEDLE LAST TIME' /
   NEDLRECC  'MOST RECENT TIME USED COC/HER/STM WITH A NEEDLE' /
   NEDFLAG4  'NEEDLE USE (ANY DRUG) - EVER USED' /
   HERSMOK2  'EVER SMOKED HEROIN' /
   HERSNIF2  'EVER SNIFFED HEROIN' /
   NEDHER    'EVER USED A NEEDLE TO INJECT HEROIN' /
   NEDCOC    'EVER USED A NEEDLE TO INJECT COCAINE' /
   NEDSTM    'EVER USED A NEEDLE TO INJECT STIMULANT' /
   RSKPKCIG  'RISK SMOKING 1 OR MORE PACKS CIGARETTES PER DAY' /
   RSKMJOCC  'RISK SMOKING MARIJUANA ONCE A MONTH' /
   RSKMJREG  'RISK SMOKING MARIJUANA ONCE OR TWICE A WEEK' /
   RKTRYLSD  'RISK TRYING LSD ONCE OR TWICE' /
   RKLSDREG  'RISK USING LSD ONCE OR TWICE A WEEK' /
   RKTRYHER  'RISK TRYING HEROIN ONCE OR TWICE' /
   RKHERREG  'RISK USING HEROIN ONCE OR TWICE A WEEK' /
   RKCOCOCC  'RISK USING COCAINE ONCE A MONTH' /
   RKCOCREG  'RISK USING COCAINE ONCE OR TWICE A WEEK' /
   RK5ALDLY  'RISK HAVING 4 OR 5 DRINKS NEARLY EVERY DAY' /
   RK5ALWK   'RISK HAVING 5 OR MORE DRINKS ONCE OR TWICE A WEEK' /
   RSKDIFMJ  'HOW DIFFICULT TO GET MARIJUANA' /
   RKDIFLSD  'HOW DIFFICULT TO GET LSD' /
   RKDIFCOC  'HOW DIFFICULT TO GET COCAINE' /
   RKDIFCRK  'HOW DIFFICULT TO GET "CRACK"' /
   RKDIFHER  'HOW DIFFICULT TO GET HEROIN' /
   RSKSELL   'APPROACHED BY SOMEONE SELLING ILL DRUG PST 30 DYS' /
   RKFQDNGR  'GET A REAL KICK OUT OF DOING DANGEROUS THINGS' /
   RKFQRSKY  'LIKE TO TEST YOURSELF BY DOING RISKY THINGS' /
   RKFQPBLT  'WEAR A SEATBELT WHEN RIDE FRONT PASS SEAT OF CAR' /
   RKFQDBLT  'WEAR A SEATBELT WHEN YOU DRIVE A CAR' /
   GRSKPKCG  'GREAT RISK:  SMOKE 1+ PACKS CIGARETTES PER DAY' /
   GRSKCREG  'GREAT RISK:  USE COCAINE 1-2 TIMES PER WEEK' /
   GRSKCOCC  'GREAT RISK:  USE COCAINE ONCE A MONTH' /
   GRSKMREG  'GREAT RISK:  USE MARIJUANA 1-2 TIMES PER WEEK' /
   GRSKMOCC  'GREAT RISK:  USE MARIJUANA ONCE A MONTH' /
   GRSKHTRY  'GREAT RISK:  TRYING HEROIN ONCE OR TWICE' /
   GRSKHREG  'GREAT RISK:  USE HEROIN 1-2 TIMES PER WEEK' /
   GRSKLTRY  'GREAT RISK:  TRYING LSD ONCE OR TWICE' /
   GRSKLREG  'GREAT RISK:  USE LSD 1-2 TIMES PER WEEK' /
   GRSKD4_5  'GREAT RISK:  HAVE 4-5 ALC DRINKS PER DAY' /
   GRSKD5WK  'GREAT RISK:  HAVE 5+ ALC DRINKS 1-2 TIMES PER WEEK' /
   RDIFMJ    'MARIJUANA FAIRLY OR EASY TO OBTAIN' /
   RDIFCOC   'COCAINE FAIRLY OR EASY TO OBTAIN' /
   RDIFHER   'HEROIN FAIRLY OR EASY TO OBTAIN' /
   RDIFLSD   'LSD FAIRLY OR EASY TO OBTAIN' /
   RDIFCRK   'CRACK FAIRLY OR EASY TO OBTAIN' /
   APPSELDG  'APPROACHED BY SOMEONE SELLING DRUGS' /
   CIGLOTTM  'SPENT MONTH/MORE GETTING/SMKG CIGS PAST 12 MOS' /
   CIGLIMIT  'SET LIMITS ON CIG USE PAST 12 MONTHS' /
   CIGKPLMT  'ABLE TO KEEP LIMITS OR SMOKE MORE PAST 12 MOS' /
   CIGNDMOR  'NEEDED MORE CIGS TO GET SAME EFFECT PAST 12 MOS' /
   CIGLSEFX  'SMKG SAME # CIGS HAD LESS EFFECT PAST 12 MOS' /
   CIGCUTDN  'WANT/TRY TO CUT DOWN/STOP SMKG PAST 12 MOS' /
   CIGCUTEV  'ABLE TO CUT/STOP CIGS EVERY TIME PAST 12 MOS' /
   CIGCUT1X  'CUT DOWN OR STOP SMKG AT LEAST ONCE PAST 12 MOS' /
   CIGWD4SX  'HAD 4+ CIG WITHDRAW SYMPTOMS PST 12 MOS' /
   CIGWDSMT  'HAD 4+ CIG WDRAW SYM AT SAME TIME PST 12 MOS' /
   CIGEMOPB  'CIG CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS' /
   CIGEMCTD  'CONTD TO SMOKE CIGS DESPITE EMOT PRBS' /
   CIGPHLPB  'ANY PHYS PRBS CAUSED/WORSND BY CIGS PST 12 MOS' /
   CIGPHCTD  'CONTD TO SMOKE CIGS DESPITE PHYS PRBS' /
   CIGLSACT  'LESS ACTIVITIES B/C OF CIG USE PAST 12 MOS' /
   CIGPKCRT  'BUY CIGARETTES BY PACK OR CARTON' /
   CIGPDPAK  'PRICE PAID FOR LAST PACK OF CIGS' /
   CIGPDCRT  'PRICE PAID FOR LAST CARTON OF CIGS' /
   ALCLOTTM  'SPENT MONTH/MORE GETTING/DRNKG ALC PAST 12 MOS' /
   ALCGTOVR  'MONTH+ SPENT GETTING OVER ALC EFFECTS PST 12 MOS' /
   ALCLIMIT  'SET LIMITS ON ALCOHOL USE PAST 12 MONTHS' /
   ALCKPLMT  'ABLE TO KEEP LIMITS OR DRANK MORE PAST 12 MOS' /
   ALCNDMOR  'NEEDED MORE ALC TO GET SAME EFFECT PST 12 MOS' /
   ALCLSEFX  'DRNKG SAME AMT ALC HAD LESS EFFECT PAST 12 MOS' /
   ALCCUTDN  'WANT/TRY TO CUT DOWN/STOP DRNKG PAST 12 MOS' /
   ALCCUTEV  'ABLE TO CUT/STOP DRNKG EVERY TIME PAST 12 MOS' /
   ALCCUT1X  'CUT DOWN OR STOP DRNKG AT LEAST ONCE PAST 12 MOS' /
   ALCWD2SX  'HAD 2+ ALC WITHDRAWAL SYMPTOMS PST 12 MOS' /
   ALCWDSMT  'HAD 2+ ALC WDRAW SYM AT SAME TIME PST 12 MOS' /
   ALCEMOPB  'ALC CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS' /
   ALCEMCTD  'CONTD TO DRINK ALC DESPITE EMOT PRBS' /
   ALCPHLPB  'ANY PHYS PRBS CAUSED/WORSND BY ALC PST 12 MOS' /
   ALCPHCTD  'CONTD TO DRINK ALC DESPITE PHYS PRBS' /
   ALCLSACT  'LESS ACTIVITIES B/C OF ALC USE PAST 12 MOS' /
   ALCSERPB  'ALC CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS' /
   ALCPDANG  'DRNK ALC AND DO DANGEROUS ACTIVITIES PST 12 MOS' /
   ALCLAWTR  'DRNK ALC CAUSE PRBS WITH LAW PAST 12 MOS' /
   ALCFMFPB  'DRNK ALC CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS' /
   ALCFMCTD  'CONTD TO DRINK ALC DESPITE PRBS W/ FAM/FRNDS' /
   MRJLOTTM  'SPENT MONTH/MORE GETTING/USING MJ PAST 12 MOS' /
   MRJGTOVR  'MONTH+ SPENT GETTING OVER MJ EFFECTS PST 12 MOS' /
   MRJLIMIT  'SET LIMITS ON MARIJUANA USE PAST 12 MONTHS' /
   MRJKPLMT  'ABLE TO KEEP LIMITS OR USE MORE MJ PAST 12 MOS' /
   MRJNDMOR  'NEEDED MORE MJ TO GET SAME EFFECT PST 12 MOS' /
   MRJLSEFX  'USING SAME AMT MJ HAD LESS EFFECT PAST 12 MOS' /
   MRJCUTDN  'WANT/TRY TO CUT DOWN/STOP USING MJ PST 12 MOS' /
   MRJCUTEV  'ABLE TO CUT/STOP USING MJ EVERY TIME PST 12 MOS' /
   MRJEMOPB  'MJ CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS' /
   MRJEMCTD  'CONTD USING MARIJUANA DESPITE EMOT PRBS' /
   MRJPHLPB  'ANY PHYS PRBS CAUSED/WORSND BY MJ PST 12 MOS' /
   MRJPHCTD  'CONTD TO USE MARIJUANA DESPITE PHYS PRBS' /
   MRJLSACT  'LESS ACTIVITIES B/C OF MJ USE PAST 12 MOS' /
   MRJSERPB  'MJ CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS' /
   MRJPDANG  'USING MJ AND DO DANGEROUS ACTIVITIES PST 12 MOS' /
   MRJLAWTR  'USING MJ CAUSE PRBS WITH LAW PAST 12 MOS' /
   MRJFMFPB  'USING MJ CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS' /
   MRJFMCTD  'CONTD TO USE MJ DESPITE PRBS W/ FAM/FRNDS' /
   COCLOTTM  'SPENT MONTH/MORE GETTING/USING COC PAST 12 MOS' /
   COCGTOVR  'MONTH+ SPENT GETTING OVER COC EFFECTS PST 12 MOS' /
   COCLIMIT  'SET LIMITS ON COCAINE USE PAST 12 MONTHS' /
   COCKPLMT  'ABLE TO KEEP LIMITS OR USED MORE COC PST 12 MOS' /
   COCNDMOR  'NEEDED MORE COC TO GET SAME EFFECT PST 12 MOS' /
   COCLSEFX  'USING SAME AMT COC HAD LESS EFFECT PAST 12 MOS' /
   COCCUTDN  'WANT/TRY TO CUT DOWN/STOP USING COC PAST 12 MOS' /
   COCCUTEV  'ABLE TO CUT/STOP USING COC EVERY TIME PAST 12 MOS' /
   COCCUT1X  'CUT DOWN/STOP USING COC AT LEAST 1X PST 12 MOS' /
   COCFLBLU  'WHEN CUT DOWN ON COC, FELT BLUE PAST 12 MONTHS' /
   COCWD2SX  'HAD 2+ COC WITHDRAWAL SYMPTOMS PST 12 MOS' /
   COCWDSMT  'HAD 2+ COC WDRAW SYM AT SAME TIME PAST 12 MOS' /
   COCEMOPB  'COC CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS' /
   COCEMCTD  'CONTD TO USE COC DESPITE EMOT PRBS' /
   COCPHLPB  'ANY PHYS PRBS CAUSED/WORSND BY COC PST 12 MOS' /
   COCPHCTD  'CONTD TO USE COC DESPITE PHYS PRBS' /
   COCLSACT  'LESS ACTIVITIES B/C OF COC USE PAST 12 MOS' /
   COCSERPB  'COC CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS' /
   COCPDANG  'USING COC AND DO DANGEROUS ACTIVITIES PST 12 MOS' /
   COCLAWTR  'USING COC CAUSE PRBS WITH LAW PAST 12 MOS' /
   COCFMFPB  'USING COC CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS' /
   COCFMCTD  'CONTD TO USE COC DESPITE PRBS W/ FAM/FRNDS' /
   HERLOTTM  'SPENT MON/MORE GETTING/USING HEROIN PST 12 MOS' /
   HERGTOVR  'MONTH+ SPENT GETTING OVR HEROIN EFFECTS PST 12 MO' /
   HERLIMIT  'SET LIMITS ON HEROIN USE PAST 12 MONTHS' /
   HERKPLMT  'ABLE TO KEEP LIMT OR USE MORE HEROIN PST 12 MOS' /
   HERNDMOR  'NEEDED MORE HEROIN TO GET SME EFFECT PST 12 MOS' /
   HERLSEFX  'USING SME AMT HEROIN HAD LESS EFFECT PST 12 MOS' /
   HERCUTDN  'WANT/TRY CUT DOWN/STOP USNG HEROIN PST 12 MOS' /
   HERCUTEV  'ABLE TO CUT/STOP USNG HEROIN EVRY TIME PST 12 MOS' /
   HERCUT1X  'CUT DOWN/STOP USNG HEROIN AT LEAST 1X PST 12 MOS' /
   HERWD3SX  'HAD 3+ HEROIN WITHDRAWAL SYMPTOMS PST 12 MOS' /
   HERWDSMT  'HAD 3+ HEROIN WDRAW SYM SAME TIME PST 12 MOS' /
   HEREMOPB  'HEROIN CAUSE PRBS W/EMOT/NERVES PAST 12 MOS' /
   HEREMCTD  'CONTD TO USE HEROIN DESPITE EMOT PRBS' /
   HERPHLPB  'ANY PHYS PRBS CAUSED/WORSND BY HEROIN PST 12 MOS' /
   HERPHCTD  'CONTD TO USE HEROIN DESPITE PHYS PRBS' /
   HERLSACT  'LESS ACTIVITIES B/C OF HEROIN USE PAST 12 MOS' /
   HERSERPB  'HEROIN CAUSE SER PRB AT HOM/WRK/SCH PST 12 MOS' /
   HERPDANG  'USING HEROIN & DO DANGEROUS ACTIVS PST 12 MOS' /
   HERLAWTR  'USING HEROIN CAUSE PRBS WITH LAW PAST 12 MOS' /
   HERFMFPB  'USING HEROIN CAUSE PRBS W/FAM/FRNDS PST 12 MOS' /
   HERFMCTD  'CONTD TO USE HEROIN DESPITE PRBS W/FAM/FRNDS' /
   HALLOTTM  'SPENT MON/MORE GETTING/USING HALLUC PST 12 MOS' /
   HALGTOVR  'MONTH+ SPENT GETTING OVR HALLUC EFFECTS PST 12 MO' /
   HALLIMIT  'SET LIMITS ON HALLUCINOGEN USE PAST 12 MONTHS' /
   HALKPLMT  'ABLE TO KEEP LIMT OR USE MORE HALLUC PST 12 MOS' /
   HALNDMOR  'NEEDED MORE HALLUC TO GET SME EFFECT PST 12 MOS' /
   HALLSEFX  'USING SME AMT HALLUC HAD LESS EFFECT PAST 12 MOS' /
   HALCUTDN  'WANT/TRY CUT DOWN/STOP USING HALLUC PST 12 MOS' /
   HALCUTEV  'ABLE TO CUT/STOP USING HALLUC EVRY TIME PST 12 MO' /
   HALEMOPB  'HALLUC CAUSE PRBS W/EMOT/NERVES PAST 12 MOS' /
   HALEMCTD  'CONTD TO USE HALLUC DESPITE EMOT PRBS' /
   HALPHLPB  'ANY PHYS PRBS CAUSED/WORSND BY HALLUC PST 12 MOS' /
   HALPHCTD  'CONTD TO USE HALLUC DESPITE PHYS PRBS' /
   HALLSACT  'LESS ACTIVITES B/C OF HALLUC USE PAST 12 MOS' /
   HALSERPB  'HALLUC CAUSE SER PRBS AT HOM/WRK/SCH PST 12 MOS' /
   HALPDANG  'USING HALLUC & DO DANGEROUS ACTIVS PST 12 MOS' /
   HALLAWTR  'USING HALLUC CAUSE PRBS WITH LAW PAST 12 MOS' /
   HALFMFPB  'USING HALLUC CAUSE PRBS W/FAM/FRNDS PST 12 MOS' /
   HALFMCTD  'CONTD TO USE HALLUC DESPITE PRBS W/FAM/FRNDS' /
   INHLOTTM  'SPENT MONTH/MORE GETTING/USING INH PAST 12 MOS' /
   INHGTOVR  'MONTH+ SPENT GETTING OVER INH EFFECTS PST 12 MOS' /
   INHLIMIT  'SET LIMITS ON INHALANT USE PAST 12 MONTHS' /
   INHKPLMT  'ABLE TO KEEP LIMITS OR USE MORE INH PAST 12 MOS' /
   INHNDMOR  'NEEDED MORE INH TO GET SAME EFFECT PST 12 MOS' /
   INHLSEFX  'USING SAME AMT INH HAD LESS EFFECT PAST 12 MOS' /
   INHCUTDN  'WANT/TRY TO CUT DOWN/STOP USING INH PAST 12 MOS' /
   INHCUTEV  'ABLE TO CUT/STOP USING INH EVERY TIME PAST 12 MOS' /
   INHEMOPB  'INH CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS' /
   INHEMCTD  'CONTD TO USE INHALANTS DESPITE EMOT PRBS' /
   INHPHLPB  'ANY PHYS PRBS CAUSED/WORSND BY INH PST 12 MOS' /
   INHPHCTD  'CONTD TO USE INHALANTS DESPITE PHYS PRBS' /
   INHLSACT  'LESS ACTIVITIES B/C OF INH USE PAST 12 MOS' /
   INHSERPB  'INH CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS' /
   INHPDANG  'USING INH AND DO DANGEROUS ACTIVITIES PST 12 MOS' /
   INHLAWTR  'USING INH CAUSE PRBS WITH LAW PAST 12 MOS' /
   INHFMFPB  'USING INH CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS' /
   INHFMCTD  'CONTD TO USE INH DESPITE PRBS W/ FAM/FRNDS' /
   ANLLOTTM  'SPENT MON/MORE GETTNG/USNG PN RLVR PST 12 MOS' /
   ANLGTOVR  'MON+ SPNT GETTING OVER PN RLVR EFFECTS PST 12 MOS' /
   ANLLIMIT  'SET LIMITS ON PAIN RELIEVER USE PAST 12 MONTHS' /
   ANLKPLMT  'ABLE TO KEEP LIMT/USE MORE PN RLVR PST 12 MOS' /
   ANLNDMOR  'NEEDED MORE PN RLVR TO GET SME EFFECT PST 12 MOS' /
   ANLLSEFX  'USING SME AMT PN RLVR HAD LESS EFFECT PST 12 MOS' /
   ANLCUTDN  'WANT/TRY CUT DOWN/STOP USNG PN RLVR PST 12 MOS' /
   ANLCUTEV  'ABLE TO CUT/STOP USNG PN RLVR EVRY TIME PST 12 MO' /
   ANLCUT1X  'CUT DOWN/STOP USNG PN RLVR AT LEAST 1X PST 12 MOS' /
   ANLWD3SX  'HAD 3+ PN RLVR WITHDRAWAL SYMPTOMS PST 12 MOS' /
   ANLWDSMT  'HAD 3+ PN RLVR WDRAW SYM SAME TIME PST 12 MOS' /
   ANLEMOPB  'PN RLVR CAUSE PRBS W/EMOT/NERVES PST 12 MOS' /
   ANLEMCTD  'CONTD TO USE PN RLVR DESPITE EMOT PRBS' /
   ANLPHLPB  'ANY PHYS PRBS CAUSD/WORSND BY PN RLVR PST 12 MOS' /
   ANLPHCTD  'CONTD TO USE PN RLVR DESPITE PHYS PRBS' /
   ANLLSACT  'LESS ACTIVITIES B/C OF PN RLVR USE PAST 12 MOS' /
   ANLSERPB  'PN RLVR CAUSE SER PRB AT HOM/WRK/SCH PST 12 MOS' /
   ANLPDANG  'USING PN RLVR & DO DANGEROUS ACTIVS PST 12 MOS' /
   ANLLAWTR  'USING PN RLVR CAUSE PRBS WITH LAW PAST 12 MOS' /
   ANLFMFPB  'USING PN RLVR CAUSE PRBS W/FAM/FRNDS PST 12 MOS' /
   ANLFMCTD  'CONTD TO USE PN RLVR DESPITE PRBS W/FAM/FRNDS' /
   TRNLOTTM  'SPENT MONTH/MORE GETTING/USING TRN PAST 12 MOS' /
   TRNGTOVR  'MONTH+ SPENT GETTING OVER TRN EFFECTS PST 12 MOS' /
   TRNLIMIT  'SET LIMITS ON TRANQUILIZER USE PAST 12 MONTHS' /
   TRNKPLMT  'ABLE TO KEEP LIMITS OR USE MORE TRN PAST 12 MOS' /
   TRNNDMOR  'NEEDED MORE TRN TO GET SAME EFFECT PST 12 MOS' /
   TRNLSEFX  'USING SAME AMT TRN HAD LESS EFFECT PAST 12 MOS' /
   TRNCUTDN  'WANT/TRY TO CUT DOWN/STOP USING TRN PAST 12 MOS' /
   TRNCUTEV  'ABLE TO CUT/STOP USING TRN EVERY TIME PAST 12 MOS' /
   TRNEMOPB  'TRN CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS' /
   TRNEMCTD  'CONTD TO USE TRN DESPITE EMOT PRBS' /
   TRNPHLPB  'ANY PHYS PRBS CAUSED/WORSND BY TRN PST 12 MOS' /
   TRNPHCTD  'CONTD TO USE TRN DESPITE PHYS PRBS' /
   TRNLSACT  'LESS ACTIVITIES B/C OF TRN USE PAST 12 MOS' /
   TRNSERPB  'TRN CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS' /
   TRNPDANG  'USING TRN AND DO DANGEROUS ACTIVITIES PST 12 MOS' /
   TRNLAWTR  'USING TRN CAUSE PRBS WITH LAW PAST 12 MOS' /
   TRNFMFPB  'USING TRN CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS' /
   TRNFMCTD  'CONTD TO USE TRN DESPITE PRBS W/ FAM/FRNDS' /
   STMLOTTM  'SPENT MONTH/MORE GETTING/USING STM PAST 12 MOS' /
   STMGTOVR  'MONTH+ SPENT GETTING OVER STM EFFECTS PST 12 MOS' /
   STMLIMIT  'SET LIMITS ON STIMULANT USE PAST 12 MONTHS' /
   STMKPLMT  'ABLE TO KEEP LIMITS OR USE MORE STM PAST 12 MOS' /
   STMNDMOR  'NEEDED MORE STM TO GET SAME EFFECT PST 12 MOS' /
   STMLSEFX  'USING SAME AMT STM HAD LESS EFFECT PAST 12 MOS' /
   STMCUTDN  'WANT/TRY TO CUT DOWN/STOP USING STM PAST 12 MOS' /
   STMCUTEV  'ABLE TO CUT/STOP USING STM EVERY TIME PAST 12 MOS' /
   STMCUT1X  'CUT DOWN OR STOP USING STM AT LEAST 1X PST 12 MOS' /
   STMFLBLU  'WHEN CUT DOWN ON STM, FELT BLUE PAST 12 MONTHS' /
   STMWD2SX  'HAD 2+ STM WITHDRAWAL SYMPTOMS PST 12 MOS' /
   STMWDSMT  'HAD 2+ STM WDRAW SYM AT SAME TIME PAST 12 MOS' /
   STMEMOPB  'STM CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS' /
   STMEMCTD  'CONTD TO USE STM DESPITE EMOT PRBS' /
   STMPHLPB  'ANY PHYS PRBS CAUSED/WORSND BY STM PST 12 MOS' /
   STMPHCTD  'CONTD TO USE STM DESPITE PHYS PRBS' /
   STMLSACT  'LESS ACTIVITIES B/C OF STM USE PAST 12 MOS' /
   STMSERPB  'STM CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS' /
   STMPDANG  'USING STM AND DO DANGEROUS ACTIVITIES PST 12 MOS' /
   STMLAWTR  'USING STM CAUSE PRBS WITH LAW PAST 12 MOS' /
   STMFMFPB  'USING STM CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS' /
   STMFMCTD  'CONTD TO USE STM DESPITE PRBS W/ FAM/FRNDS' /
   SEDLOTTM  'SPENT MONTH/MORE GETTING/USING SED PAST 12 MOS' /
   SEDGTOVR  'MONTH+ SPENT GETTING OVER SED EFFECTS PST 12 MOS' /
   SEDLIMIT  'SET LIMITS ON SEDATIVE USE PAST 12 MONTHS' /
   SEDKPLMT  'ABLE TO KEEP LIMITS OR USE MORE SED PAST 12 MOS' /
   SEDNDMOR  'NEEDED MORE SED TO GET SAME EFFECT PST 12 MOS' /
   SEDLSEFX  'USING SAME AMT SED HAD LESS EFFECT PAST 12 MOS' /
   SEDCUTDN  'WANT/TRY TO CUT DOWN/STOP USING SED PAST 12 MOS' /
   SEDCUTEV  'ABLE TO CUT/STOP USING SED EVERY TIME PAST 12 MOS' /
   SEDCUT1X  'CUT DOWN OR STOP USING SED AT LEAST 1X PST 12 MOS' /
   SEDWD1SX  'HAD 1+ SED WITHDRAWAL SYMPTOM PST 12 MOS' /
   SEDWDSMT  'HAD 1+ SED WDRAW SYM AT SAME TIME PAST 12 MOS' /
   SEDEMOPB  'SED CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS' /
   SEDEMCTD  'CONTD TO USE SED DESPITE EMOT PRBS' /
   SEDPHLPB  'ANY PHYS PRBS CAUSED/WORSND BY SED PST 12 MOS' /
   SEDPHCTD  'CONTD TO USE SED DESPITE PHYS PRBS' /
   SEDLSACT  'LESS ACTIVITIES B/C OF SED USE PAST 12 MOS' /
   SEDSERPB  'SED CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS' /
   SEDPDANG  'USING SED AND DO DANGEROUS ACTIVITIES PST 12 MOS' /
   SEDLAWTR  'USING SED CAUSE PRBS WITH LAW PAST 12 MOS' /
   SEDFMFPB  'USING SED CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS' /
   SEDFMCTD  'CONTD TO USE SED DESPITE PRBS W/ FAM/FRNDS' /
   DEPNDALC  'ALCOHOL DEPENDENCE IN THE PAST YEAR' /
   DEPNDANL  'PAIN RELIEVER DEPENDENCE IN THE PAST YEAR' /
   DEPNDCIG  'CIGARETTE DEPENDENCE IN THE PAST YEAR' /
   DEPNDCOC  'COCAINE DEPENDENCE IN THE PAST YEAR' /
   DEPNDHAL  'HALLUCINOGEN DEPENDENCE IN THE PAST YEAR' /
   DEPNDHER  'HEROIN DEPENDENCE IN THE PAST YEAR' /
   DEPNDINH  'INHALANT DEPENDENCE IN THE PAST YEAR' /
   DEPNDMRJ  'MARIJUANA DEPENDENCE IN THE PAST YEAR' /
   DEPNDSED  'SEDATIVE DEPENDENCE IN THE PAST YEAR' /
   DEPNDSTM  'STIMULANT DEPENDENCE IN THE PAST YEAR' /
   DEPNDTRN  'TRANQUILIZER DEPENDENCE IN THE PAST YEAR' /
   DEPNDILL  'ILLICIT DRUG DEPENDENCE IN THE PAST YEAR' /
   DEPNDIEM  'ILLICIT DRUG OTHER THAN MARIJUANA DEP IN PAST YR' /
   DEPNDXMJ  'ILLICIT DRUG EXCLUDING MARIJUANA DEP IN PAST YR' /
   DEPNDPSY  'PSYCHOTHERAPEUTIC DEPENDENCE IN THE PAST YR' /
   DPILLALC  'ILLICIT DRUG OR ALCOHOL DEPENDENCE IN PAST YR' /
   DPILANAL  'ILLICIT DRUGS AND ALCOHOL DEPENDENCE IN PAST YR' /
   ABUSEALC  'ALCOHOL ABUSE - PAST YEAR' /
   ABUSEANL  'PRESCRIPTION PAIN RELIEVER ABUSE - PAST YEAR' /
   ABUSECOC  'COCAINE ABUSE - PAST YEAR' /
   ABUSEHAL  'HALLUCINOGEN ABUSE - PAST YEAR' /
   ABUSEHER  'HEROIN ABUSE - PAST YEAR' /
   ABUSEINH  'INHALANT ABUSE - PAST YEAR' /
   ABUSEMRJ  'MARIJUANA ABUSE - PAST YEAR' /
   ABUSESED  'SEDATIVE ABUSE - PAST YEAR' /
   ABUSESTM  'STIMULANT ABUSE - PAST YEAR' /
   ABUSETRN  'TRANQUILIZER ABUSE - PAST YEAR' /
   ABUSEILL  'ANY ILLICIT DRUG ABUSE - PAST YEAR' /
   ABUSEIEM  'ANY ILLICIT DRG OTHER THAN MARIJUANA ABUSE-PST YR' /
   ABUSEXMJ  'ANY ILLICIT DRG EXCLUDING MARIJUANA ABUSE-PST YR' /
   ABUSEPSY  'NON-MEDICAL PSYCHOTHERAPEUTIC DRUG ABUSE - PST YR' /
   ABILLALC  'ANY ILLICIT DRUG OR ALCOHOL ABUSE - PAST YEAR' /
   ABILANAL  'ANY ILLICIT DRUG AND ALCOHOL ABUSE - PAST YEAR' /
   ABODALC   'ALCOHOL ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODANL   'PAIN RELIEVER ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODCOC   'COCAINE ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODHAL   'HALLUCINOGEN ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODHER   'HEROIN ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODINH   'INHALANT ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODMRJ   'MARIJUANA ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODSED   'SEDATIVE ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODSTM   'STIMULANT ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODTRN   'TRANQUILIZER ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODILL   'ANY ILLICIT DRUG ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODPSY   'PSYCHOTHERAPEUTIC ABUSE OR DEPENDENCE - PAST YEAR' /
   ABODILAL  'ANY ILLICIT DRUG OR ALCOHOL ABUSE OR DEP - PST YR' /
   ABDILAAL  'ANY ILLICIT DRUG AND ALCOHOL ABUSE OR DEP - PST YR' /
   BOOKED    'EVER ARRESTED AND BOOKED FOR BREAKING THE LAW' /
   NOBOOKY2  '# TIMES ARRESTED AND BOOKED PAST 12 MONTHS' /
   BKMVTHFT  'ARRSTD & BOOKED FOR MOT VEH THEFT PAST 12 MONTHS' /
   BKLARCNY  'ARRSTD & BOOKED FOR LARCENY/THEFT PAST 12 MONTHS' /
   BKBURGL   'ARRSTD & BOOKED FOR BURGLARY/B & E PAST 12 MOS' /
   BKAGASLT  'ARRSTD & BOOKED FOR AGGRAVATED ASSAULT PAST 12 MOS' /
   BKSMASLT  'ARRSTD & BOOKED FOR OTHER ASSAULT PAST 12 MONTHS' /
   BKROB     'ARRSTD & BOOKED FOR ROBBERY PAST 12 MONTHS' /
   BKRAPE    'ARRSTD & BOOKED FOR FORCIBLE RAPE PAST 12 MONTHS' /
   BKMURDER  'ARRSTD & BOOKED FOR MURDER/HOMICIDE PAST 12 MONTHS' /
   BKARSON   'ARRSTD & BOOKED FOR ARSON PAST 12 MONTHS' /
   BKDRVINF  'ARRSTD & BOOKED FOR DUI PAST 12 MONTHS' /
   BKDRUNK   'ARRSTD & BOOKED FOR DRUNKENNESS PAST 12 MONTHS' /
   BKPOSTOB  'ARRSTD & BOOKED FOR POSSES OF TOB PAST 12 MOS' /
   BKDRUG    'ARRSTD & BOOKED FOR POSSES/SALE DRUGS  PAST 12 MOS' /
   BKPROS    'ARRSTD & BOOKED FOR PROSTITUTION PAST 12 MONTHS' /
   BKSEXOFF  'ARRSTD & BOOKED FOR OTH SEX OFFENSE PST 12 MOS' /
   BKFRAUD   'ARRSTD & BOOKED FOR FRAUD/STOL GOODS PAST 12 MOS' /
   BKOTH     'ARRSTD & BOOKED FOR SOME OTHER OFF PAST 12 MOS' /
   BKOTHOF2  'OTHER OFFENSE PAST 12 MONTHS - SPECIFY' /
   PROBATON  'ON PROBATION AT ANY TIME PAST 12 MONTHS' /
   PAROLREL  'ON PAROLE/SUPRV RELEASE PAST 12 MONTHS' /
   DRVALDR   'DROVE UNDER INFLU OF ALC & ILL DRUGS PAST 12 MOS' /
   DRVAONLY  'DROVE UNDER INFLU OF ALC/ALC ONLY PST 12 MOS' /
   DRVDONLY  'DROVE UNDER INFLU OF DRUGS/DRUGS ONLY PST 12 MOS' /
   DRIVALC   'DROVE VEHICLE WHILE UNDER INFLUENCE OF ALCOHOL' /
   DRIVDRG   'DROVE VEHICLE UNDER INFLUENCE OF ILLICIT DRUGS' /
   DRIVALD   'DROVE VEHICLE UNDER INFLUENCE OF ALC OR ILL DRUGS' /
   PAROL     'PAROLE/SUPERVISED RELEASE STATUS IN THE PAST YEAR' /
   PROB      'PROBATION STATUS IN THE PAST YEAR' /
   TXEVER    'EVER RECEIVED ALCOHOL OR DRUG TREATMENT' /
   TXYREVER  'EVER RECEIVED ALCOHOL OR DRUG TRMT PAST 12 MOS' /
   TXYRADG   'TRMT FOR ALC, DRUG OR BOTH PAST 12 MONTHS' /
   TXYRHOSP  'RCVD TXFILL1 TRMT IN HOSP/OVERNIGHT PST 12 MOS' /
   TXYRHPAD  'HOSP/OVERNIGHT TRMT FOR ALC, DRUGS, OR BOTH' /
   TXYRRFIN  'RCVD TXFILL1 TRMT REHAB CENTR/OVERNIGHT PST 12 MO' /
   TXYRINAD  'RES ALC/DRG REH TRMT FOR ALC, DRUGS, OR BOTH' /
   TXYRRFOP  'RCVD TXFILL1 TRMT REHAB CENTR/OUTPT PST 12 MOS' /
   TXYRPOAD  'OUTPATIENT TRMT FOR ALC, DRUGS, OR BOTH' /
   TXYRMHC   'RCVD TXFILL1 TRMT MNT HEALTH CNTR/OUTPT PST 12 MO' /
   TXYRMHAD  'MNT HEALTH CNTR TRMT FOR ALC, DRUGS, OR BOTH' /
   TXYRTXER  'RCVD TXFILL1 TRMT IN EMERGENCY ROOM PAST 12 MOS' /
   TXYRERAD  'EMERGENCY ROOM TRMT FOR ALC, DRUGS, OR BOTH' /
   TXYRDOC   'RCVD TXFILL1 TRMT IN PRIV DR.''S OFFICE PST 12 MOS' /
   TXYRDCAD  'PRIV DR.''S OFFICE TRMT FOR ALC, DRUGS, OR BOTH' /
   TXYRJAIL  'RCVD TXFILL1 TRMT IN PRISON/JAIL PAST 12 MONTHS' /
   TXYRJLAD  'PRISON/JAIL TRMT FOR ALC, DRUGS, OR BOTH' /
   TXYRSHG   'RCVD TXFILL1 TRMT IN SELF-HELP GROUP PAST 12 MOS' /
   TXYRSGAD  'SELF-HELP GROUP TRMT FOR ALC, DRUGS, OR BOTH' /
   TXYRSOP   'RCVD TXFILL1 TRMT IN SOME OTHER PLACE PAST 12 MOS' /
   TXYROTS2  'OTHER PLACE RECEIVED TRMT PAST 12 MONTHS' /
   TXYROTAD  'OTHER PLACE TRMT FOR ALC, DRUGS, OR BOTH' /
   TXYRVSER  'EVER VISIT EMER RM FOR TRMT OF ILL DRUG PST 12 MO' /
   TXYRNME2  '# TIMES EMER RM FOR TRMT OF ILL DRUGS PST 12 MOS' /
   TXRCVNOW  'CURRENTLY RECEIVING TRMT/COUNSELING FOR TXFILL1' /
   NDTXNEDR  'NEED TRMT FOR USE OF ALCOHOL OR DRUG PAST 12 MOS' /
   NDTXMORE  'NEED ADDL TRMT FOR USE OF ALCOHOL/DRUG PST 12 MOS' /
   NDTMRALC  'NEED ADDL TRMT FOR USE OF ALCOHOL PAST 12 MOS' /
   NDTMRMJ   'NEED ADDL TRMT FOR USE OF MJ/HASH PAST 12 MOS' /
   NDTMRCOC  'NEED ADDL TRMT FOR USE OF COC/CRACK PAST 12 MOS' /
   NDTMRHER  'NEED ADDL TRMT FOR USE OF HEROIN PAST 12 MOS' /
   NDTMRHAL  'NEED ADDL TRMT FOR USE OF HALLUC PAST 12 MOS' /
   NDTMRINH  'NEED ADDL TRMT FOR USE OF INHALANTS PAST 12 MOS' /
   NDTMRANL  'NEED ADDL TRMT FOR USE OF PAIN REL PST 12 MOS' /
   NDTMRTRN  'NEED ADDL TRMT FOR USE OF TRAN PAST 12 MOS' /
   NDTMRSTM  'NEED ADDL TRMT FOR USE OF STIMULANTS PST 12 MOS' /
   NDTMRSED  'NEED ADDL TRMT FOR USE OF SEDATIVES PST 12 MOS' /
   NDTMROTH  'NEED ADDL TRMT FOR USE OF SOME OTH DRG PST 12 MOS' /
   NDTXALCR  'NEED TRMT FOR USE OF ALCOHOL PAST 12 MONTHS' /
   NDTXMJR   'NEED TRMT FOR USE OF MARIJUANA/HASHISH PAST 12 MOS' /
   NDTXCOCR  'NEED TRMT FOR USE OF COCAINE/CRACK PAST 12 MONTHS' /
   NDTXHERR  'NEED TRMT FOR USE OF HEROIN PAST 12 MONTHS' /
   NDTXHALR  'NEED TRMT FOR USE OF HALLUCINOGENS PAST 12 MONTHS' /
   NDTXINHR  'NEED TRMT FOR USE OF INHALANTS PAST 12 MONTHS' /
   NDTXANLR  'NEED TRMT FOR USE OF RX PAIN RELIEVERS PST 12 MOS' /
   NDTXTRNR  'NEED TRMT FOR USE OF RX TRANQUILIZERS PST 12 MOS' /
   NDTXSTMR  'NEED TRMT FOR USE OF RX STIMULANTS PST 12 MOS' /
   NDTXSEDR  'NEED TRMT FOR USE OF RX SEDATIVES PST 12 MOS' /
   NDTXSODR  'NEED TRMT FOR USE OF SOME OTHER DRUG PAST 12 MOS' /
   NDTXDG1R  'OTHER DRUG NEEDED TRMT FOR PST 12 MOS - SPECIFY 1' /
   NDTXDG2R  'OTHER DRUG NEEDED TRMT FOR PST 12 MOS - SPECIFY 2' /
   NDTXDG3R  'OTHER DRUG NEEDED TRMT FOR PST 12 MOS - SPECIFY 3' /
   NDTXDG4R  'OTHER DRUG NEEDED TRMT FOR PST 12 MOS - SPECIFY 4' /
   NDTXDG5R  'OTHER DRUG NEEDED TRMT FOR PST 12 MOS - SPECIFY 5' /
   NDTXEFTR  'MAKE EFFORT FOR TRMT OF TXFILL2 PAST 12 MONTHS' /
   NDTMREFT  'MAKE EFFORT FOR ADDL TRMT FOR ALC/DRG PST 12 MOS' /
   TXLASREC  'TIME SINCE LAST RCVD ALCOHOL OR DRUG TREATMENT' /
   TXLTYMN2  'MAIN PLACE RCV TRMT LAST TIME/CURRENTLY' /
   TXLTYALC  'LAST/CURRENT TREATMENT FOR ALCOHOL' /
   TXLTYMJ   'LAST/CURRENT TREATMENT FOR MARIJUANA/HASHISH' /
   TXLTYCOC  'LAST/CURRENT TREATMENT FOR COCAINE/CRACK' /
   TXLTYHER  'LAST/CURRENT TREATMENT FOR HEROIN' /
   TXLTYHAL  'LAST/CURRENT TREATMENT FOR HALLUCINOGENS' /
   TXLTYINH  'LAST/CURRENT TREATMENT FOR INHALANTS' /
   TXLTYANL  'LAST/CURRENT TRMT FOR PRESCRIPTION PAIN RELIEVERS' /
   TXLTYTRN  'LAST/CURRENT TRMT FOR PRESCRIPTION TRANQUILIZERS' /
   TXLTYSTM  'LAST/CURRENT TRMT FOR PRESCRIPTION STIMULANTS' /
   TXLTYSED  'LAST/CURRENT TRMT FOR PRESCRIPTION SEDATIVES' /
   TXLTYSOD  'LAST/CURRENT TRMT FOR SOME OTHER DRUG' /
   TXLTYOU2  'OUTCOME OF LAST/CURRENT TREATMENT' /
   TXLTYDU2  '# DAYS IN ALC/DRG TMT SO FAR/LAST TIME - RECODE' /
   TXPYINS   'HEALTH INSURANCE PAY FOR LAST/CURRENT TRMT' /
   TXPYCARE  'MEDICARE PAY FOR LAST/CURRENT TRMT' /
   TXPYCAID  'MEDICAID PAY FOR LAST/CURRENT TRMT' /
   TXPYPUBP  'OTH PUBLIC ASSIST PAY FOR LAST/CURRENT TRMT' /
   TXPYSAVE  'OWN SAVINGS PAY FOR LAST/CURRENT TRMT' /
   TXPYFMLY  'FAMILY MEMBERS PAY FOR LAST/CURRENT TRMT' /
   TXPYCORT  'COURTS PAY FOR LAST/CURRENT TRMT' /
   TXPYMILC  'MILITARY HLTH CARE PAY FOR LAST/CURRENT TRMT' /
   TXPYEMPL  'EMPLOYER PAY FOR LAST/CURRENT TRMT' /
   TXPYSOS   'SOME OTHER SOURCE PAY FOR LAST/CURRENT TRMT' /
   TXPYSP2   'OTHER PAY FOR LAST/CURRENT TRMT - SPECIFY' /
   TXPYFRE   'LAST/CURRENT TREATMENT WAS/IS FREE' /
   TXENROLL  'ENROLLED IN TREATMENT PROGRAM ON OCT.1 1999' /
   TXYRDTXO  'WAS DETOX THE ONLY TRMT RCVD PAST 12 MONTHS' /
   SPECTILL  'RCVD TRMT AT SPEC FAC FOR ILL DRG-PST YR' /
   SPECTALC  'RCVD TRMT AT SPEC FAC FOR ALC USE-PST YR' /
   SPILLALC  'RCVD TRMT SPEC FAC FOR ALC OR DRG-PST YR' /
   ILLNEED   'NEEDED TRMT FOR ILL DRUG USE-PST YR' /
   TXNOSPEC  'NEED ILL DRG TRMT, NOT RCVD TRMT SPC FAC' /
   ALCTRMT   'RCVD TRMT AT ANY LOC FOR ALC USE-PST YR' /
   ILLTRMT   'RCVD TRMT ANY LOC FOR ILL DRG USE-PST YR' /
   TXILLALC  'RCVD TRMT ANY LOC FOR ALC OR DRG-PST YR' /
   TXILANAL  'RCVD TRMT ANY LOC FOR ALC AND DRG-PST YR' /
   TXLTALC2  'RECEIVED LAST/CURRENT TREATMENT FOR ALCOHOL' /
   TXLTANL2  'RECEIVED LAST/CURRENT TREATMENT FOR PAIN RELIEVERS' /
   TXLTCOC2  'RECEIVED LAST/CURRENT TREATMENT FOR COCAINE' /
   TXLTHAL2  'RECEIVED LAST/CURRENT TREATMENT FOR HALLUCINOGENS' /
   TXLTHER2  'RECEIVED LAST/CURRENT TREATMENT FOR HEROIN' /
   TXLTINH2  'RECEIVED LAST/CURRENT TREATMENT FOR INHALANTS' /
   TXLTMJ2   'RECEIVED LAST/CURRENT TREATMENT FOR MARIJUANA' /
   TXLTSED2  'RECEIVED LAST/CURRENT TREATMENT FOR SEDATIVES' /
   TXLTSTM2  'RECEIVED LAST/CURRENT TREATMENT FOR STIMULANTS' /
   TXLTTRN2  'RECEIVED LAST/CURRENT TREATMENT FOR TRANQUILIZERS' /
   TXLTILL2  'RECEIVED LAST/CURRENT TREATMENT FOR ILLICIT DRUGS' /
   TXPINS2   'LAST/CURRENT ILL DRG/ALC TRT PAID FOR BY INSURANCE' /
   TXPCARE2  'LAST/CURR ILL DRG/ALC TRT PAID FOR BY MEDICARE' /
   TXPCAID2  'LAST/CURRENT ILL DRG/ALC TRT PAID FOR BY MEDICAID' /
   TXPPUBP2  'LAST/CURR ILL DRG/ALC TRT PAID FOR BY PUBLIC ASST' /
   TXPSAVE2  'LAST/CURR ILL DRG/ALC TRT PAID FOR BY OWN SAVINGS' /
   TXPFMLY2  'LAST/CURR ILL DRG/ALC TRT PAID FOR BY FAM MEMBERS' /
   TXPCORT2  'LAST/CURRENT ILL DRG/ALC TRT PAID FOR BY COURTS' /
   TXPMILC2  'LAST/CURR ILL DRG/ALC TRT PAID FOR BY MILT HC' /
   TXPEMPL2  'LAST/CURR ILL DRG/ALC TRT PAID FOR BY EMPLOYER' /
   ILLPINS   'LAST/CURRENT ILL DRUG TRT PAID FOR BY INSURANCE' /
   ILLPCARE  'LAST/CURRENT ILL DRUG TRT PAID FOR BY MEDICARE' /
   ILLPCAID  'LAST/CURRENT ILLICIT DRUG TRT PAID FOR BY MEDICAID' /
   ILLPPUBP  'LAST/CURRENT ILL DRUG TRT PAID FOR BY PUBLIC ASST' /
   ILLPSAVE  'LAST/CURRENT ILL DRUG TRT PAID FOR BY OWN SAVINGS' /
   ILLPFMLY  'LAST/CURRENT ILL DRUG TRT PAID FOR BY FAMLY MEMBR' /
   ILLPCORT  'LAST/CURRENT ILL DRUG TREATMENT PAID FOR BY COURTS' /
   ILLPMILC  'LAST/CURRENT ILL DRUG TRT PAID FOR BY MILT HLTCARE' /
   ILLPEMPL  'LAST/CURRENT ILLICIT DRUG TRT PAID FOR BY EMPLOYER' /
   ALCPINS   'LAST/CURRENT ALC TREATMENT PAID FOR BY INSURANCE' /
   ALCPCARE  'LAST/CURRENT ALC TREATMENT PAID FOR BY MEDICARE' /
   ALCPCAID  'LAST/CURRENT ALC TREATMENT PAID FOR BY MEDICAID' /
   ALCPPUBP  'LAST/CURRENT ALC TRTMNT PAID FOR BY PUBLIC ASST' /
   ALCPSAVE  'LAST/CURRENT ALC TRTMNT PAID FOR BY OWN SAVINGS' /
   ALCPFMLY  'LAST/CURRENT ALC TRTMNT PAID FOR BY FAMILY MEMBERS' /
   ALCPCORT  'LAST/CURRENT ALCOHOL TREATMENT PAID FOR BY COURTS' /
   ALCPMILC  'LAST/CURRENT ALC TRT PAID FOR BY MILT HLTH CARE' /
   ALCPEMPL  'LAST/CURRENT ALC TREATMENT PAID FOR BY EMPLOYER' /
   LOCHOSP   'RCVD ILL DRUG OR ALC TRT AT A HOSPITAL IN PAST YR' /
   LOCRFIN   'RCVD ILL DRUG/ALC TRT AT INP REHAB FAC IN PAST YR' /
   LOCRFOP   'RCVD ILL DRUG/ALC TRT AT OUTP REHAB FAC IN PAST YR' /
   LOCMHC    'RCVD ILL DRUG/ALC TRT AT MNTL HLTH CNTR IN PAST YR' /
   LOCTXER   'RCVD ILL DRUG OR ALC TRT AT AN ER IN PAST YR' /
   LOCDOC    'RCVD ILL DRUG OR ALC TRT AT DR''S OFFICE IN PAST YR' /
   LOCJAIL   'RCVD ILL DRUG OR ALC TRT AT PRISON/JAIL IN PAST YR' /
   LOCSHG    'RCVD ILL DRUG/ALC TRT AT SELF-HELP GRP IN PAST YR' /
   DRGHOSP   'RCVD ILL DRUG TREATMENT AT A HOSPITAL IN PAST YEAR' /
   DRGRFIN   'RCVD ILL DRUG TRT AT AN INP REHAB FAC IN PAST YEAR' /
   DRGRFOP   'RCVD ILL DRUG TRT AT AN OUTP REHAB FAC IN PAST YR' /
   DRGMHC    'RCVD ILL DRUG TRT AT A MENTAL HLTH CNTR IN PST YR' /
   DRGTXER   'RCVD ILL DRUG TRT AT AN EMERGENCY ROOM IN PAST YR' /
   DRGDOC    'RECEIVED ILL DRUG TRT AT A DR''S OFFICE IN PAST YR' /
   DRGJAIL   'RCVD ILL DRUG TRT AT A PRISON/JAIL IN THE PAST YR' /
   DRGSHG    'RCVD ILL DRUG TRT AT A SELF-HELP GROUP IN PAST YR' /
   ALCHOSP   'RECEIVED ALC TRT AT A HOSPITAL IN THE PAST YEAR' /
   ALCRFIN   'RCVD ALC TRT AT INP REHAB FAC IN THE PAST YEAR' /
   ALCRFOP   'RCVD ALC TRT AT AN OUTP REHAB FAC IN THE PAST YR' /
   ALCMHC    'RCVD ALC TRT AT A MENTAL HEALTH CENTER IN PAST YR' /
   ALCTXER   'RCVD ALC TRT AT AN EMERGENCY ROOM IN PAST YR' /
   ALCDOC    'RECEIVED ALC TRT AT A DOCTOR''S OFFICE IN PAST YR' /
   ALCJAIL   'RECEIVED ALC TRT AT A PRISON/JAIL IN THE PAST YEAR' /
   ALCSHG    'RCVD ALC TRT AT A SELF-HELP GROUP IN PAST YR' /
   AUINPYR   'STAY OVNT IN HOSP FOR MH TRMT PST 12 MOS' /
   AUINPSYH  'MH TRMT IN PRIV/PUB PSYCH HOSP PST 12 MOS' /
   AUINPGEN  'MH TRMT IN PSYCH UNIT OF GEN HOSP PST 12 MOS' /
   AUINMEDU  'MH TRMT IN MED UNIT OF GEN HOSP PST 12 MOS' /
   AUINAHSP  'MH TRMT IN ANOTHER TYPE HOSP PST 12 MOS' /
   AUINRESD  'MH TRMT IN RESID TRMT CENTER PST 12 MOS' /
   AUINSFAC  'MH TRMT IN SOME OTHER FACIL PST 12 MOS' /
   AUNMPSY2  '# NIGHTS IN PRIV/PUB PSYCH HOSP PST 12 MOS' /
   AUNMPGE2  '# NIGHTS IN PSYCH UNIT OF GEN HOSP PST 12 MOS' /
   AUNMMEDU  '# NIGHTS IN MED UNIT OF GEN HOSP PST 12 MOS' /
   AUNMAHSP  '# NIGHTS IN ANOTHER TYPE OF HOSP PST 12 MOS' /
   AUNMRESD  '# NIGHTS IN RESID TRMT CENTER PST 12 MOS' /
   AUNMSFA2  '# NIGHTS IN SOME OTHER FACIL PST 12 MOS' /
   AUPINSLF  'INPAT MH CARE PYMNT: SELF OR LIVE-IN FAM MBR' /
   AUPINOFM  'INPAT MH CARE PYMNT: FAM MBR NOT LIVING W/YOU' /
   AUPINPHI  'INPAT MH CARE PYMNT: PRIVATE HEALTH INSUR' /
   AUPINMCR  'INPATIENT MH CARE PAYMENT: MEDICARE' /
   AUPINMCD  'INPATIENT MH CARE PAYMENT: MEDICAID' /
   AUPINREH  'INPAT MH CARE PYMNT: REHABILITATION PROG' /
   AUPINEMP  'INPATIENT MH CARE PAYMENT: EMPLOYER' /
   AUPINMIL  'INPATIENT MH CARE PAYMENT: MILITARY SOURCE' /
   AUPINPUB  'INPAT MH CARE PYMNT: OTHER PUBLIC SOURCE' /
   AUPINPRV  'INPAT MH CARE PYMNT: OTHER PRIVATE SOURCE' /
   AUPINFRE  'INPATIENT MENTAL HEALTH CARE WAS FREE' /
   AUPINAMT  'AMT YOU/FAMILY PAID FOR INPAT MH CARE' /
   AUOPTYR   'RCVD OUTPATIENT MH TRMT PST 12 MOS' /
   AUOPMENT  'MH TRMT IN OUTPATIENT MH CNTR PST 12 MOS' /
   AUOPTHER  'MH TRMT IN PRIV THERAPIST''S OFC PST 12 MOS' /
   AUOPDOC   'MH TRMT IN NON-CLINIC DR.''S OFC PST 12 MOS' /
   AUOPCLNC  'MH TRMT IN OUTPAT MED CLINIC PST 12 MOS' /
   AUOPDTMT  'MH TRMT IN DAY TREATMENT PGM PST 12 MOS' /
   AUOPOTOP  'MH TRMT IN OTHER OUTPAT PLACE PST 12 MOS' /
   AUOPYRS2  'OTH FACIL RCVD OUTPAT MH TRMT PAST 12 MOS' /
   AUNMMEN2  '# VISITS TO OUTPATIENT MH CNTR PST 12 MOS' /
   AUNMTHE2  '# VISITS TO PRIV THERAPIST''S OFC PST 12 MOS' /
   AUNMDOC2  '# VISITS TO NON-CLINIC DR.''S OFC PST 12 MOS' /
   AUNMCLN2  '# VISITS TO OUTPAT MED CLINIC PST 12 MOS' /
   AUNMDTM2  '# VISITS TO DAY TREATMENT PGM PST 12 MOS' /
   AUNMOTO2  '# VISIT OTPT SOME OTHER FACILITY PST 12 MOS' /
   AUPOPSLF  'OUPAT MH CARE PYMNT: SELF OR LIVE-IN FAM MBR' /
   AUPOPOFM  'OUPAT MH CARE PYMNT: FAM MBR NOT LIVING W/YOU' /
   AUPOPPHI  'OUPAT MH CARE PYMNT: PRIVATE HEALTH INSUR' /
   AUPOPMCR  'OUTPATIENT MH CARE PAYMENT: MEDICARE' /
   AUPOPMCD  'OUTPATIENT MH CARE PAYMENT: MEDICAID' /
   AUPOPREH  'OUPAT MH CARE PYMNT: REHABILITATION PROG' /
   AUPOPEMP  'OUTPATIENT MH CARE PAYMENT: EMPLOYER' /
   AUPOPMIL  'OUTPATIENT MH CARE PAYMENT: MILITARY SOURCE' /
   AUPOPPUB  'OUPAT MH CARE PYMNT: OTHER PUBLIC SOURCE' /
   AUPOPPRV  'OUPAT MH CARE PYMNT: OTHER PRIVATE SOURCE' /
   AUPOPFRE  'OUTPATIENT MENTAL HEALTH CARE WAS FREE' /
   AUPOPMOS  'PAYMENT FOR MOST OF OUTPATIENT MH CARE' /
   AUPOPAMT  'AMT YOU/FAMILY PAID FOR OUPAT MH CARE' /
   AURXYR    'TOOK ANY PRESCRIP MED FOR MH COND PAST 12 MOS' /
   AUUNMTYR  'NEEDED MH TRMT BUT DIDN''T GET IT PAST 12 MOS' /
   AUUNMTRS  'REASON DIDN''T GET MH TRMT PAST 12 MOS' /
   AMHINP    'ADULT REC INPATIENT MENTAL HEALTH TRT IN PAST YEAR' /
   AMHOUTP   'ADULT REC OUTPATIENT MENTAL HEALTH TRT IN PAST YR' /
   AMHRX     'ADULT REC PRESC MED FOR MENTAL HLTH TRT IN PST YR' /
   AMHTXREC  'ADULT REC ANY MENTAL HEALTH TRT IN PAST YEAR' /
   AMHTRTND  'ADULT PERCEIVED NEED/DID NOT REC MH TRT PST YR' /
   SNCRIME   'THERE IS A LOT OF CRIME IN NEIGHBORHOOD' /
   SNSELLDG  'A LOT OF DRUG SELLING GOES ON IN NEIGHBORHOOD' /
   SNPPVAL   'PEOPLE IN NEIGHBORHOOD SHARE THE SAME VALUES' /
   SNSTFGT   'LOTS OF STREET FIGHTS IN NEIGHBORHOOD' /
   SNEMTBLD  'MANY EMPTY/ABANDONED BLDGS IN NEIGHBORHOOD' /
   SNPPHLP   'PEOPLE IN NEIGHBORHOOD OFTEN HELP EACH OTHER' /
   SNGRAFTI  'THERE IS A LOT OF GRAFFITI IN NEIGHBORHOOD' /
   SNPPVSIT  'PEOPLE IN NBHD OFTEN VISIT IN EACH OTHERS HOMES' /
   SNPPMOVE  'PEOPLE MOVE IN AND OUT OF NEIGHBORHOOD OFTEN' /
   SNMOV5Y2  '# TIMES MOVED IN PAST 5 YEARS' /
   SNSPOUSE  'CURRENTLY LIVING WITH A SPOUSE/PARTNER' /
   SNSPACTV  'YOU AND SPOUSE SPENT 1+ HR IN ACTIV YOU ENJOY' /
   SNSPANGR  'YOU AND SPOUSE WERE ANGRY WITH EACH OTHER' /
   SNSPHITU  'YOUR SPOUSE/PARTNER HIT/THREATENED TO HIT YOU' /
   SNYHITSP  'YOU HIT/THREATENED TO HIT YOUR SPOUSE/PARTNER' /
   SNSPCRIT  'HOW OFTEN IS SPOUSE/PARTNER CRITICAL OF YOU' /
   SNSPCONC  'HOW OFTEN SPOUSE/PRTNER SHOWS CONCERN FEELINGS' /
   SNFRCONC  '#FRIENDS WHO YOU SHARE PERS ISSUES/CONCERNS WITH' /
   SNFRACTV  '#FRIENDS WHO YOU SPEND TIME WITH' /
   SNFRCARE  '#FRIENDS WHO REALLY LIKE/CARE ABOUT YOU' /
   SNYSELL   'SOLD ILLEGAL DRUGS' /
   SNYSTOLE  'STOLEN/TRIED TO STEAL ANYTHING WORTH > $50' /
   SNYATTAK  'ATTACKED SOMEONE W/INTENT TO SERIOUSLY HURT THEM' /
   SNFACIG   'HOW YOU FEEL: ADLTS SMOKING 1+ PK CIGS/DAY' /
   SNFAMJEV  'HOW YOU FEEL: ADLTS TRYING MJ/HASH' /
   SNFAALDY  'HOW YOU FEEL: ADLTS DRINKING ALC DLY' /
   SNFAALDV  'HOW YOU FEEL: ADLTS DRIVING AFT 1-2 DRINKS' /
   YECRIME   'THERE IS A LOT OF CRIME IN NEIGHBORHOOD' /
   YESELLDG  'A LOT OF DRUG SELLING IN NEIGHBORHOOD' /
   YEPPHLP   'PEOPLE IN NEIGHBORHOOD HELP EACH OTHER OUT' /
   YESTFGT   'THERE ARE LOTS OF STREET FIGHTS IN NEIGHBORHOOD' /
   YEEMTBLD  'THERE ARE EMPTY/ABANDONED BLDGS IN NEIGHBORHOOD' /
   YEPPVSIT  'PEOPLE IN NEIGHBORHOOD OFTEN VISIT IN EA OTH HOME' /
   YEGRAFTI  'THERE IS A LOT OF GRAFFITI IN NEIGHBORHOOD' /
   YEPPMOVE  'PEOPLE MOVE IN AND OUT OF NEIGHBORHOOD OFTEN' /
   YEMOV5Y2  '# TIMES MOVED IN PAST 5 YEARS' /
   YEENRLYR  'BEEN ENROLLED IN ANY SCHOOL PAST 12 MONTHS' /
   YELSTGRD  'GRADES FOR LAST SEMESTER/GRADING PERIOD COMPLETED' /
   YEYFGTSW  'GOTTEN INTO A SERIOUS FIGHT AT SCHOOL/WORK' /
   YEYFGTGP  'TAKEN PART IN FIGHT WHERE GROUP FIGHTS GROUP' /
   YEYHGUN   'CARRIED A HANDGUN' /
   YEYSELL   'SOLD ILLEGAL DRUGS' /
   YEYSTOLE  'STOLEN/TRIED TO STEAL ANYTHING WORTH >$50' /
   YEYATTAK  'ATTACKED SOMEONE W/INTENT TO SERIOUSLY HURT THEM' /
   YEPPKCIG  'HOW PRNTS WLD FEEL: YOU SMOKING 1+ PACK CIGS/DAY' /
   YEPMJEVR  'HOW PRNTS WLD FEEL: YOU TRYING MJ/HASH' /
   YEPALDLY  'HOW PRNTS WLD FEEL: YOU DRINKING ALC DAILY' /
   YEGPKCIG  'HOW YOU FEEL S/ONE YOUR AGE SMOKG 1+ PK CIGS/DY' /
   YEGMJEVR  'HOW YOU FEEL S/ONE YOUR AGE TRYING MJ/HASH' /
   YEGALDLY  'HOW YOU FEEL S/ONE YOUR AGE DRINKING ALC DLY' /
   YETLKNON  'THERE IS NOBODY I CAN TALK TO ABOUT SERIOUS PROBS' /
   YETLKPAR  'MY MOTHER/FATHER/GUARDIAN' /
   YETLKSOP  'SOME OTHER PERSON' /
   YEPRTDNG  'HAVE YOU TALKED W/PARENT(S) ABT DANGER OF TOB/ALC' /
   YEBIGBRO  'BIG BROTHER/BIG SISTER/BIG BUDDY PROGRAM' /
   YEPRBSLV  'PRBLM SOLVING/COMMUNICATION SKILLS/SELF-ESTEEM GR' /
   YEVIOPRV  'VIOLENCE PREVENTION PROGRAMS' /
   YEYMCA    'YOUTH CENTER ACTIVITIES/YMCA/YWCA' /
   YESCOUTS  'BOY SCOUTS/GIRL SCOUTS' /
   YEPRVLES  'PRIVATE LESSONS' /
   YEDGPRGP  'ALCOHOL/TOBACCO/DRUG PREV PGMS OUTSIDE SCHL' /
   YETEMSPT  'TEAM SPORTS' /
   YE4HCLUB  '14-H CLUB' /
   YESLFHLP  'AA/ALATEEN/INDIVIDUAL OR GROUP COUNSELING' /
   YEBAND    'SCHOOL BAND, ORCHESTRA, CHOIR' /
   YESCHCLB  'SCHOOL-RELATED CLUBS' /
   YEVOLUNT  'VOLUNTEER/COMMUNITY WORK' /
   YESTGOVT  'STUDENT GOVERNMENT' /
   YEPRGSTD  'PREGNANCY OR SEXUALLY TRANSMITTED DISEASE PGMS' /
   YEJBSKIL  'JOB SKILLS OR JOB TRAINING' /
   YECHOIR   'CHURCH CHOIR' /
   YEDECLAS  'A SPECIAL CLASS ABOUT DRUGS OR ALCOHOL' /
   YEDERGLR  'FILMS/LECTURES/DISCUS/INFO ABOUT DRG/ALC IN CLASS' /
   YEDESPCL  'FILMS/LECTURES/DISCUS/INFO ABOUT DRG/ALC OUT CLAS' /
   YEPVNTYR  'SEEN/HEARD ALC/DRG PREV MESSAGES FRM SOURC OUT SC' /
   YECGFRND  '# TIMES FRND/RELAT BGT CIGS FOR YOU PAST 30 DAYS' /
   YECGVEND  '# TIMES BOUGHT CIGS FR VENDING MACH PAST 30 DAYS' /
   YECGMAI2  '# TIMES BOUGHT CIGS THRU MAIL PAST 30 DAYS' /
   YECGCHKO  '# TIMES BGT CIGS/BROUGHT TO CHKOUT PST 30 DAYS' /
   YECGCLRK  '# TIMES BGT CIGS WHERE CLERK GAVE PAST 30 DAYS' /
   YECGINET  '# TIMES BOUGHT CIGS THRU INTERNET PAST 30 DAYS' /
   YECGSMKT  '# TIMES BOUGHT CIGS IN SUPERMKT PAST 30 DAYS' /
   YECGDSTO  '# TIMES BOUGHT CIGS IN DRUG STORE PST 30 DAYS' /
   YECGCONV  '# TIMES BGT CIGS SML GROC/CONV ST PST 30 DAYS' /
   YECGINDV  '# TIMES BOUGHT CIGS FROM INDIV PAST 30 DAYS' /
   YECGPRUF  'ASKED FOR ID LAST TIME TRIED TO BUY CIGS' /
   YECGSUCC  'SUCCESSFUL LAST TIME TRIED TO BUY CIGS' /
   YEPKCRTN  'BUY CIGS BY PACK OR CARTON' /
   YEPDPACK  'PRICE PAID FOR LAST PACK OF CIGS' /
   YEPDCRTN  'PRICE PAID FOR LAST CARTON OF CIGS' /
   YEBLNTEV  'EVER SMOKED CIGAR WITH MJ' /
   YEBLNT30  'SMOKED CIGAR WITH MJ PAST 30 DAYS' /
   YEBL30FQ  '# DAYS SMKD CIGAR WITH MJ PAST 30 DAYS' /
   YECGRWMJ  'REPLACE TOBACCO WITH MJ IN CIGAR PAST 30 DAYS' /
   NGHCRIM2  'A LOT OF CRIME IN YOUTH NEIGHBORHOOD' /
   NGHSELL2  'A LOT OF DRUG SELLING IN YOUTH NGHD' /
   NGHHELP2  'PEOPLE HELP EACH OTHER IN YOUTH NGHD' /
   NGHFGHT2  'MANY STREET FIGHTS IN YOUTH NGHD' /
   NGHBLDG2  'MANY EMPTY BUILDINGS IN YOUTH NGHD' /
   NGHVSIT2  'PEOPLE VISIT EACH OTHER IN YOUTH NGHD' /
   NGHGRAF2  'LOT OF GRAFFITI IN YOUTH NEIGHBORHOOD' /
   NGHMOVE2  'PEOPLE OFTEN MOVE IN/OUT IN YOUTH NGHD' /
   MVIN5YR2  'NUM OF TIMES YOUTH MOVED IN PAST 5 YRS' /
   PRPKCIG2  'HOW PARENTS FEEL: YOUTH SMOKE PACK/DAY CIG' /
   PRMJEVR2  'HOW PARENTS FEEL: YOUTH TRY MJ/HASH' /
   PRALDLY2  'HOW PARENTS FEEL: YOUTH DRNK 1+ ALC BEV/DAY' /
   PRTALK3   'TALKED W/PARENT ABT DANGER TOB/ALC/DRG' /
   YOFIGHT2  'YOUTH HAD SERIOUS FIGHT AT SCHOOL/WORK' /
   YOGRPFT2  'YOUTH FOUGHT W/GROUP VS OTHER GROUP' /
   YOHGUN2   'YOUTH CARRIED A HANDGUN' /
   YOSELL2   'YOUTH SOLD ILLEGAL DRUGS' /
   YOSTOLE2  'YOUTH STOLE/TRIED TO STEAL ITEM >$50' /
   YOATTAK2  'YOUTH ATTACKED W/INTENT TO SERIOUSLY HARM' /
   YFLPKCG2  'HOW YTH FEELS: PEERS SMOKE PACK/DAY CIG' /
   YFLTMRJ2  'HOW YTH FEELS: PEERS TRY MJ/HASH' /
   YFLADLY2  'HOW YTH FEELS: PEERS DRNK 1+ALC BEV/DAY' /
   YOUTHACT  'RESP PARTICIPATED IN YOUTH ACTIVITIES' /
   PRBSOLV2  'PARTICIPATED IN PRBSLV/COMMSKILL/SELFESTEEM GROUP' /
   PREVIOL2  'PARTICIPATED IN VIOLENCE PREVENTION PROGRAM' /
   PRVDRGO2  'PARTICIPATED IN DRUG PREV PROGRAM OUTSIDE SCHOOL' /
   GRPCNSL2  'PARTICIPATED IN PROGRAM TO HELP DRUG ABUSE' /
   PREGPGM2  'PARTICIPATED IN PREG/STD PREV PROGRAM' /
   DGSPCLS2  'YOUTH TAKEN SPECIAL CLASS ABOUT DRUGS' /
   DGRGCLS2  'YOUTH DRUG EDUC IN REGULAR CLASS' /
   DRGLECT2  'YOUTH DRUG EDUC OUTSIDE REG CLASS' /
   DRPRVME3  'YOUTH SEEN DRUG PREV MSG OUTSIDE SCH' /
   ANYEDUC3  'YOUTH HAD ANY DRUG EDUC IN SCHOOL' /
   CIGFRND   'FRIEND OR RELATIVE BOUGHT YOUTH CIG IN PAST MONTH' /
   CIGVEND   'YOUTH BOUGHT CIG AT VENDING MACH IN PAST MONTH' /
   CIGMAIL   'YOUTH BOUGHT CIGARETTES THROUGH MAIL IN PAST MONTH' /
   CIGCKOUT  'YOUTH TOOK CIG TO COUNTER FOR PURCH IN PAST MON' /
   CIGCLERK  'YTH BOUGHT CIG WHERE CLERK HANDS THEM IN PAST MON' /
   CIGINET   'YOUTH BOUGHT CIG THROUGH INTERNET IN PAST MONTH' /
   CIGSMKT   'YTH BOUGHT CIG AT A BIG SUPERMARKET IN PAST MONTH' /
   CIGDSTO   'YOUTH BOUGHT CIGARETTES AT DRUG STORE IN PAST MON' /
   CIGCONV   'YTH BOUGHT CIG AT CONVENIENCE STORE IN PAST MONTH' /
   CIGINDIV  'YOUTH BOUGHT CIG FROM AN INDIVIDUAL IN PAST MONTH' /
   YTHBGHT   'YOUTH PERSONALLY BOUGHT CIGARETTES IN PAST MONTH' /
   YMSPGRUP  'OFTEN NERVOUS WHEN W/GRP OF PEOPLE PAST 12 MOS' /
   YMSPFNTP  'OFTEN NERVOUS IN FRONT OF PEOPLE PST 12 MOS' /
   YMSAHOME  'OFTEN WANTED TO STAY HOME W/MOM/DAD PST 12 MOS' /
   YMSAACHE  'HEAD/STOMACHACHES WHEN NOT W/MOM/DAD PST 12 MOS' /
   YMSABDRM  'LOT OF BAD DREAMS/NIGHTMARES PAST 12 MONTHS' /
   YMSASLEP  'OFT WANT MOM/DAD NEAR TO FALL ASLEEP PST 12 MOS' /
   YMSAABDN  'WORRY MOM/DAD GO AWY/NOT COME BACK PST 12 MOS' /
   YMSAUPLV  'OFTEN UPSET WHEN MOM/DAD GO OUT PAST 12 MONTHS' /
   YMSAHMSK  'HOMESICK FOR MOM/DAD PAST 12 MONTHS' /
   YMAGOHSF  'OFTEN AFRAID TO GO OUT OF HOUSE ALONE PST 12 MOS' /
   YMAGCRWD  'OFTEN FELT AFRAID OF CROWDS PAST 12 MONTHS' /
   YMAGTRAV  'OFTEN AFRAID OF TRAVEL IN CAR/BUS/TRAIN PST 12 MOS' /
   YMAGBRDG  'OFTEN AFRAID IN BRIDGES/TUNNELS PAST 12 MONTHS' /
   YMPAATAK  'HAD SUDN ATTACK FELT AFRAID/STRANGE PST 12 MOS' /
   YMPASUFC  'SUDDENLY FELT LIKE SUFFOCATING PAST 12 MONTHS' /
   YMGAWORY  'OFTEN WORRIED BEFORE SPORT/GAME PAST 12 MONTHS' /
   YMGAHDAC  'HAD A LOT OF HEADACHES PAST 12 MONTHS' /
   YMGAPAIN  'HAD A LOT OF OTHER ACHES/PAINS PAST 12 MONTHS' /
   YMGATNSE  'OFTEN BEEN TENSE/NOT RELAXED PAST 12 MONTHS' /
   YMPHANML  'AFRAID OF DOGS/BIRDS/INSECTS/SNAKES/ETC PST 12 MOS' /
   YMPHHIGH  'AFRAID OF BEING HIGH UP PAST 12 MONTHS' /
   YMPHDARK  'AFRAID OF THE DARK PAST 12 MONTHS' /
   YMPHNEDL  'AFRAID OF NEEDLS/SHOTS MORE THAN OTHRS PST 12 MOS' /
   YMPHBLOD  'AFRAID OF SIGHT OF BLOOD PAST 12 MONTHS' /
   YMPHBRDG  'AFRAID OF BEING ON/IN TUNNEL/BRIDGE PST 12 MOS' /
   YMPHELEV  'AFRAID OF ELEVATOR/ESCALATOR PAST 12 MONTHS' /
   YMOCCOUN  'COUNT/DO THINGS OVER & OVER PAST 12 MONTHS' /
   YMOCWASH  'OFT WASH HANDS/CHNG CLOTHES DAILY PST 12 MOS' /
   YMOCCHCK  'OFTEN CHECK ON THINGS OVER & OVER PST 12 MOS' /
   YMOCGERM  'OFTEN WORRY ABOUT DIRT/GERMS PST 12 MOS' /
   YMOCTHOT  'HAD THOTS YOU COULDN''T GET RID OF PST 12 MOS' /
   YMEATHIN  'ANYONE WORRIED YOU''RE MUCH TOO THIN PST 12 MOS' /
   YMEAFAT   'OFTEN FELT BAD THOUGHT YOU''RE FAT PST 12 MOS' /
   YMEATHFD  'THOUGHT ABOUT FOOD ALL OF THE TIME PST 12 MONTHS' /
   YMEABING  'HAD AN EATING BINGE PAST 12 MONTHS' /
   YMELWTBD  'HAVE YOU WET THE BED PAST 12 MONTHS' /
   YMELWTPT  'WET YOUR PANTS DURING DAY PAST 12 MONTHS' /
   YMELSOIL  'SOILED YOURSELF (POOPED PANTS) PST 12 MOS' /
   YMMDNINT  'HAD A TIME WHEN NOTHING WAS FUN PST 12 MOS' /
   YMMDLSEG  'HAD A TIME WHEN HAD LESS ENERGY PST 12 MOS' /
   YMMDNOGD  'FELT COULDN''T DO ANYTHING WELL PST 12 MOS' /
   YMMDTHKL  'SERIOUSLY THOT ABOUT KILLING SELF PST 12 MOS' /
   YMMDTYKL  'TRIED TO KILL YOURSELF PAST 12 MONTHS' /
   YMMDTIRD  'TIME WHN LITTLE THINGS MADE YOU TIRED PST 12 MOS' /
   YMMDTHNK  'TIME WHN YOU COULDN''T THINK CLEARLY PST 12 MOS' /
   YMMABDMD  'TIME WHEN GROUCHY/ANGRY PAST 12 MONTHS' /
   YMMARSLS  'TIME WHEN RESTLESS PAST 12 MONTHS' /
   YMMATALK  'TIME WHEN TALKED TOO MUCH/QUICKLY PAST 12 MONTHS' /
   YMMASPAB  'TIME THOUGHT HAD SPECIAL POWERS PAST 12 MONTHS' /
   YMMAMDRC  'TIME WHEN MIND WAS RACING QUICKLY PAST 12 MONTHS' /
   YMADCONC  'OFTEN HAD HARD TIME CONCENTRATING PAST 12 MONTHS' /
   YMADFRGT  'OFTEN FORGOT WHAT TO BE DOING PAST 12 MONTHS' /
   YMADFCUS  'OFTEN HARD TO KEEP MIND FOCUSED PAST 12 MONTHS' /
   YMADMEDS  'TAKEN MED FOR BEING OVERACTIVE PAST 12 MONTHS' /
   YMADAVAT  'TRIED NOT TO DO THGS THAT REQ ATTENTN PST 12 MOS' /
   YMADERRO  'OFTEN MAKE A LOT OF MISTAKES PAST 12 MONTHS' /
   YMODHURT  'GOTTEN EVEN WITH PEOPLE PAST 12 MONTHS' /
   YMODRFUS  'REFUSED WHAT PARENTS/TCHRS TOLD YOU PST 12 MOS' /
   YMODANOY  'GROUCHY/EASILY ANNOYED PAST 12 MONTHS' /
   YMODMEAN  'DONE MEAN THINGS TO PEOPLE PAST 12 MONTHS' /
   YMODBLMO  'BLAMED SOMEONE ELSE FOR MISTAKES PAST 12 MONTHS' /
   YMODTANY  'DONE THINGS TO ANNOY PEOPLE PAST 12 MONTHS' /
   YMODSWOR  'PEOPLE COMPLAINED B/C YOU SWORE PST 12 MOS' /
   YMCDEXPL  'EXPELLED FOR MISBEHAVIOR PAST 12 MONTHS' /
   YMCDSHPL  'SHOPLIFTED PAST 12 MONTHS' /
   YMCDLIED  'LIED TO GET MONEY/SOMETHING ELSE PAST 12 MONTHS' /
   YMCDSNAT  'SNATCHED A PURSE/JEWELRY PAST 12 MONTHS' /
   YMCDVAND  'BROKE/MESSED UP STHING ON PURPOSE PST 12 MOS' /
   YMCDSTOL  'STOLE FR OTHRS WHN THEY WEREN''T AROUND PST 12 MOS' /
   YMCDCRUA  'CRUEL TO ANIMAL ON PURPOSE PAST 12 MONTHS' /
   YMCDBKNT  'BROKEN INTO A HOUSE/CAR PAST 12 MONTHS' /
   YUHOSPYR  'STAY OVNT IN HOSP FOR EMOT TRMT PST 12 MOS' /
   YUHOSPN2  '# NIGHTS STAYED IN HOSP FOR EMOT TRMT PST 12 MOS' /
   YUHOSUIC  'STAYED IN HOSP BEC THOUGHT/TRIED TO KILL SELF' /
   YUHODEPR  'STAYED IN HOSP BEC YOU FELT DEPRESSED' /
   YUHOFEAR  'STAYED IN HOSP BEC YOU FELT AFRAID/TENSE' /
   YUHOBKRU  'STAYED IN HOSP BEC BREAKING RULES/ACTING OUT' /
   YUHOEATP  'STAYED IN HOSP BEC YOU HAD EATING PROBS' /
   YUHOSOR   'STAYED IN HOSP FOR SOME OTHER REASON' /
   YURSIDYR  'STAYED IN RESID CTR FOR EMOT TRMT PST 12 MOS' /
   YURSIDN2  '# NIGHTS IN RESID CTR FOR EMOT TRMT PST 12 MOS' /
   YURSSUIC  'STAYED IN RESID CTR BEC THOT/TRIED TO KILL SELF' /
   YURSDEPR  'STAYED IN RESID CTR BEC YOU FELT DEPRESSED' /
   YURSFEAR  'STAYED IN RESID CTR BEC YOU FELT AFRAID/TENSE' /
   YURSBKRU  'STAYED IN RESID CTR BEC BRKING RULES/ACT OUT' /
   YURSEATP  'STAYED IN RESID CTR BEC YOU HAD EATING PROBS' /
   YURSSOR   'STAYED IN RESID CTR FOR SOME OTHER REASON' /
   YUFCARYR  'SPENT TIME IN FOST CARE FOR EMOT PROB PST 12 MOS' /
   YUFCARN2  '# NIGHTS IN FOST CARE FOR EMOT PROB PST 12 MOS' /
   YUFCSUIC  'STAYED IN FOST CARE BEC THOT/TRIED TO KILL SELF' /
   YUFCDEPR  'STAYED IN FOST CARE BEC YOU FELT DEPRESSED' /
   YUFCFEAR  'STAYED IN FOST CARE BEC YOU FELT AFRAID/TENSE' /
   YUFCBKRU  'STAYED IN FOST CARE BEC BRKING RULES/ACT OUT' /
   YUFCEATP  'STAYED IN FOST CARE BEC YOU HAD EATING PROBS' /
   YUFCSOR   'STAYED IN FOST CARE FOR SOME OTHER REASON' /
   YUDYTXYR  'SPENT TIME IN DAY TRMT PROG PAST 12 MOS' /
   YUDYTXN2  '# TIMES VISITED DAY TRMT PROG PAST 12 MOS' /
   YUDYSUIC  'VISITED DAY TRMT BEC THOT/TRIED TO KILL SELF' /
   YUDYDEPR  'VISITED DAY TRMT BEC YOU FELT DEPRESSED' /
   YUDYFEAR  'VISITED DAY TRMT BEC YOU FELT AFRAID/TENSE' /
   YUDYBKRU  'VISITED DAY TRMT BEC BRKING RULES/ACT OUT' /
   YUDYEATP  'VISITED DAY TRMT BEC YOU HAD EATING PROBS' /
   YUDYSOR   'VISITED DAY TRMT FOR SOME OTHER REASON' /
   YUMHCRYR  'RCVD EMOT TRMT IN MENT HLTH CLNC PST 12 MOS' /
   YUMHCRN2  '# TIMES VISITED MENT HLTH CLNC PST 12 MOS' /
   YUMHSUIC  'VISITED MH CLNC BEC THOUGHT/TRIED TO KILL SELF' /
   YUMHDEPR  'VISITED MH CLNC BEC YOU FELT DEPRESSED' /
   YUMHFEAR  'VISITED MH CLNC BEC YOU FELT AFRAID/TENSE' /
   YUMHBKRU  'VISITED MH CLNC BEC BREAKING RULES/ACTING OUT' /
   YUMHEATP  'VISITED MH CLNC BEC YOU HAD EATING PROBS' /
   YUMHSOR   'VISITED MH CLNC FOR SOME OTHER REASON' /
   YUTPSTYR  'RCVD EMOT TRMT FROM THERAPIST PST 12 MOS' /
   YUTPSTN2  '# TIMES VISITED THERAPIST PAST 12 MONTHS' /
   YUTPSUIC  'VISITED THERAPIST BEC THOT/TRIED TO KILL SELF' /
   YUTPDEPR  'VISITED THERAPIST BEC YOU FELT DEPRESSED' /
   YUTPFEAR  'VISITED THERAPIST BEC YOU FELT AFRAID/TENSE' /
   YUTPBKRU  'VISITED THERAPIST BEC BRKING RULES/ACT OUT' /
   YUTPEATP  'VISITED THERAPIST BEC YOU HAD EATING PROBS' /
   YUTPSOR   'VISITED THERAPIST FOR SOME OTHER REASON' /
   YUIHTPYR  'RCVD EMOT TRMT FROM IN HOME COUNS PST 12 MOS' /
   YUIHTPN2  '# TIMES RCVD TRMT FR IN HOME COUNS PST 12 MOS' /
   YUIHSUIC  'SAW IN HOME COUNS BEC THOT/TRIED TO KILL SELF' /
   YUIHDEPR  'SAW IN HOME COUNS BEC YOU FELT DEPRESSED' /
   YUIHFEAR  'SAW IN HOME COUNS BEC YOU FELT AFRAID/TENSE' /
   YUIHBKRU  'SAW IN HOME COUNS BEC BRKING RULES/ACT OUT' /
   YUIHEATP  'SAW IN HOME COUNS BEC YOU HAD EATING PROBS' /
   YUIHSOR   'SAW IN HOME COUNS FOR SOME OTHER REASON' /
   YUFDOCYR  'RCVD EMOT TRMT FROM FAMLY DOC PST 12 MOS' /
   YUFDOCN2  '# TIMES RCVD TRMT FROM FAMLY DOC PST 12 MOS' /
   YUFDSUIC  'SAW FAMLY DOC BEC THOUGHT/TRIED TO KILL SELF' /
   YUFDDEPR  'SAW FAMLY DOC BEC YOU FELT DEPRESSED' /
   YUFDFEAR  'SAW FAMLY DOC BEC YOU FELT AFRAID/TENSE' /
   YUFDBKRU  'SAW FAMLY DOC BEC BREAKING RULES/ACTING OUT' /
   YUFDEATP  'SAW FAMLY DOC BEC YOU HAD EATING PROBS' /
   YUFDSOR   'SAW FAMLY DOC FOR SOME OTHER REASON' /
   YUSPEDYR  'SPECIAL EDUC SVCS FOR EMOT PROB PST 12 MOS' /
   YUSHCNYR  'TALKED W/SCH COUNS FOR EMOT PROB PST 12 MOS' /
   YUSHSUIC  'TLKED W/SCH COUNS BEC THOT/TRIED TO KILL SELF' /
   YUSHDEPR  'TLKED W/SCH COUNS BEC YOU FELT DEPRESSED' /
   YUSHFEAR  'TLKED W/SCH COUNS BEC YOU FELT AFRAID/TENSE' /
   YUSHBKRU  'TLKED W/SCH COUNS BEC BRKING RULES/ACT OUT' /
   YUSHEATP  'TLKED W/SCH COUNS BEC YOU HAD EATING PROBS' /
   YUSHSOR   'TLKED W/SCH COUNS FOR SOME OTHER REASON' /
   YUJAILEV  'EVER BEEN IN JAIL OR DETENTION CENTER' /
   YUFCAREV  'EVER BEEN IN FOSTER CARE' /
   IRHHSIZ2  'RECODE - IMPUTATION-REVISED # PERSONS IN HH' /
   IIHHSIZ2  'IRHHSIZ2-IMPUTATION INDICATOR' /
   IRHH65_2  'REC - IMPUTATION-REVISED # OF PER IN HH AGED>=65' /
   IIHH65_2  'IRHH65_2-IMPUTATION INDICATOR' /
   IRKI17_2  'RECODE - IMPUTATION-REVISED # KIDS AGED<18 IN HH' /
   IIKI17_2  'IRKI17_2-IMPUTATION INDICATOR' /
   IMOTHER   'MOTHER IN HH' /
   IFATHER   'FATHER IN HH' /
   NRCH17_2  '# R''S CHILDREN < 18 IN HOUSEHOLD' /
   PREGNANT  'ARE YOU PREGNANT' /
   NMERTMT2  '# OF TIMES BEEN TREATED IN EMER ROOM PAST 12 MOS' /
   INHOSPYR  'STAYED OVERNIGHT AS INPNT IN HOSP PAST 12 MOS' /
   NMNGTHS2  '# NIGHTS STAYED IN HOSPITAL OVERNIGHT OR LONGER' /
   PROXANS2  'IS PROXY ANSWERING INSURANCE/INCOME QS' /
   PREG      'PREGNANT FEMALES AGED 12-44' /
   PREG2     'PREGNANCY STATUS OF FEMALES AGED 12-44' /
   TRIMEST   'CURRENT TRIMESTER OF PREGNANCY - FEMALES AGE 12-44' /
   IRPSOC    'IMP. REVISED- RESP RECEIVE SS OR RR PAYMENTS' /
   IIPSOC    'IRPSOC - IMPUTATION INDICATOR' /
   IRFAMSOC  'IMP. REVISED-FAM RECEIVE SS OR RR PAYMENTS' /
   IIFAMSOC  'IRFAMSOC-IMPUTATION INDICATOR' /
   IRPSSI    'IMP. REVISED- RESP RECEIVE SSI' /
   IIPSSI    'IRPSSI - IMPUTATION INDICATOR' /
   IRFAMSSI  'IMP. REVISED- FAM RECEIVE SSI' /
   IIFAMSSI  'IRFAMSSI-IMPUTATION INDICATOR' /
   IRFSTAMP  'IMP. REVISED-RESP/OTH FAM MEM REC FOOD STAMPS' /
   IIFSTAMP  'IRFSTAMP-IMPUTATION INDICATOR' /
   IRPPMT    'IMP. REVISED-RESP RECEIVE PUBLIC ASSIST' /
   IIPPMT    'IRPPMT - IMPUTATION INDICATOR' /
   IRFAMPMT  'IMP. REVISED-FAM RECEIVE PUBLIC ASSIST' /
   IIFAMPMT  'IRFAMPMT -IMPUTATION INDICATOR' /
   IRPSVC    'IMP. REVISED- RESP REC WELFARE/JOB PL/CHILD CARE' /
   IIPSVC    'IRPSVC - IMPUTATION INDICATOR' /
   IRFAMSVC  'IMP. REVISED- FAM REC WELFARE/JOB PL/CHILDCARE' /
   IIFAMSVC  'IRFAMSVC-IMPUTATION INDICATOR' /
   IRWELMOS  'IMP. REVISED- NO.OF MONTHS ON WELFARE' /
   IIWELMOS  'IRWELMOS-IMPUTATION INDICATOR' /
   IRPINT    'IMP.REVISED-RESP REC INTEREST SAVING/DIVIDEND' /
   IIPINT    'IRPINT - IMPUTATION INDICATOR' /
   IRFAMINT  'IMP. REV-FAM REC INTEREST SAVING/DIVIDEND' /
   IIFAMINT  'IRFAMINT-IMPUTATION INDICATOR' /
   IRPCHD    'IMP. REVISED-RESP REC CHILD SUPPORT PAYMENTS' /
   IIPCHD    'IRPCHD - IMPUTATION INDICATOR' /
   IRFAMCHD  'IMP. REVISED-FAM REC CHILD SUPPORT PAYMENTS' /
   IIFAMCHD  'IRFAMCHD -IMPUTATION INDICATOR' /
   IRPWAG    'IMP. REVISED-RESP RECEIVE INCOME FROM JOB' /
   IIPWAG    'IRPWAG - IMPUTATION INDICATOR' /
   IRFAMWAG  'IMP. REVISED-FAM REC INCOME FROM JOB' /
   IIFAMWAG  'IRFAMWAG -IMPUTATION INDICATOR' /
   IRPOTH    'IMP.REVISED-RESP REC OTH INCOME FROM OTH SOURCE' /
   IIPOTH    'IRPOTH - IMPUTATION INDICATOR' /
   IRFAMOTH  'IMP. REVISED-FAM REC OTH INC FR OTH SOURCE' /
   IIFAMOTH  'IRFAMOTH -IMPUTATION INDICATOR' /
   IRPINC3   'RECODE - IMP.REVISED-RESP''S TOT INC' /
   IIPINC3   'IRPINC3 - IMPUTATION INDICATOR' /
   IRFAMIN3  'RECODE - IMP.REVISED -TOT FAM INCOME' /
   IIFAMIN3  'IRFAMIN3 -IMPUTATION INDICATOR' /
   GOVTPROG  'PARTICIPATED IN ONE OR MORE GOVT ASSIST PROGRAMS' /
   HLCALLFG  'FLAG IF EVERY FORM OF HEALTH INS REPORTED' /
   HLCALL99  'YES TO MEDICARE/MEDICAID/CHAMPUS/PRVHLTIN' /
   MEDICARE  'COVERED BY MEDICARE' /
   MEDICAID  'COVERED BY MEDICAID' /
   CHAMPUS   'COVERED BY CHAMPUS, CHAMPVA, VA, MILITARY' /
   OGOVTINS  'COVERED BY OTHER GOVT SPONSORED PROGRAM' /
   OGOVINS2  'OTHER GOVT SPONSORED COVERAGE - SPECIFY' /
   PRVHLTIN  'COVERED BY PRIVATE INSURANCE' /
   GRPHLTIN  'PRIVATE PLAN OFFERED THROUGH EMPLOYER OR UNION' /
   HLTINALC  'ALCOHOL ABUSE OR ALCOHOLISM' /
   HLTINDRG  'DRUG ABUSE' /
   HLTINMNT  'MENTAL OR EMOTIONAL DIFFICULTIES' /
   OTHLTINS  'COVERED BY OTHER TYPE OF HEALTH INSURANCE' /
   OTHLINS2  'OTHER TYPE OF HEALTH INSURANCE - SPECIFY' /
   HLCNOTYR  'ANYTIME DID NOT HAVE HEALTH INS/COVER PAST 12 MOS' /
   HLCNOTMO  'PAST 12 MOS, HOW MANY MOS W/O COVERAGE' /
   HLCLAST   'TIME SINCE LAST HAD HEALTH CARE COVERAGE' /
   HLCPRIVT  'PRIVATE HEALTH INSURANCE' /
   HLCMCAID  'MEDICAID OR MEDICAL ASSISTANCE' /
   HLCMILT   'MILITARY HEALTH CARE (CHAMPUS,TRICARE,CHAMPVA,VA)' /
   HLCMCARE  'MEDICARE' /
   HLCOGOVT  'SOME OTHER GOVERNMENT PROGRAM' /
   HLCOTHER  'SOME OTHER KIND OF COVERAGE (SPECIFY)' /
   HLCOTHS2  'LAST KIND OF HEALTH COVERAGE SPECIFIED' /
   HLLLOSJB  'PERS IN FAM W/HEALTH INS LOST JOB/CHANGED EMP' /
   HLLMAJOB  'LOST MEDICAID/MED ASSIST B/C NEW JOB/PAY INCREASE' /
   HLLMASOR  'LOST MEDICAID/MED ASSIST FOR SOME OTH REASON' /
   HLLCOST   'COST TOO HIGH/CAN''T AFFORD PREMIUMS' /
   HLLINELG  'BECAME INELIGIBLE B/C AGE OR LEAVING SCHOOL' /
   HLLNOFFR  'EMPLOYER DOES NOT OFFER COVERAGE/NOT ELIGIBLE' /
   HLLDIVOR  'DIVORCED/SEPARATED FROM PERSON W/INSURANCE' /
   HLLDEATH  'DEATH OF SPOUSE OR PARENT' /
   HLLREFUS  'INSURANCE COMPANY REFUSED COVERAGE' /
   HLLNONED  'DON''T NEED IT' /
   HLLSOR    'LOST HEALTH INSURANCE FOR SOME OTHER REASON' /
   HLLSORS2  'OTHER REASON FOR LOSING HLTH INS - SPECIFY' /
   HLNVCOST  'COST TOO HIGH' /
   HLNVOFFR  'EMPLOYER DOESN''T OFFER' /
   HLNVREF   'INSURANCE COMPANY REFUSED COVERAGE' /
   HLNVNEED  'DON''T NEED IT' /
   HLNVSOR   'NEVER HAD HLTH INS SOME OTHER REASON' /
   HLNVSP2   'OTHER REASON NEVER HAD HLTH INS - SPECIFY' /
   IRPINSUR  'IMPUTATION-REVISED PRIVATE HEALTH INSURANCE' /
   IIPINSUR  'IMPUTATION - INDICATOR IRPINSUR' /
   IRINSUR   'IMPUTATION-REVISED HEALTH INSURANCE' /
   IIINSUR   'IMPUTATION-INDICATOR IRINSUR' /
   IRINSUR2  'IMPUTATION-REVISED HEALTH INSURANCE' /
   IIINSUR2  'IMPUTATION-INDICATOR IRINSUR' /
   LANGVER   'LANGUAGE VERSION' /
   QUARTER   'QUARTER INDICATOR' /
   GQTYPE    'TYPE OF GROUP QUARTER' /
   AGE2      'RECODE - FINAL EDITED AGE' /
   NOMARR2   'NUMBER OF TIMES MARRIED' /
   SERVICE   'EVER BEEN IN THE US ARMED FORCES' /
   MILSTAT   'CURRENT MILITARY STATUS' /
   HEALTH    'OVERALL HEALTH' /
   IRSEX     'IMPUTATION REVISED GENDER' /
   IISEX     'IMPUTATION REVISED GENDER INDICATOR' /
   IRMARIT   'IMPUTATION REVISED MARITAL STATUS' /
   IIMARIT   'IMPUTATION REVISED MARITAL STATUS INDICATOR' /
   IREDUC2   'RECODE - IMPUTATION REVISED EDUCATION' /
   IIEDUC2   'IMPUTATION REVISED EDUCATION INDICATOR' /
   EMPSTAT3  'IMPUTATION REVISED EMPLOYMENT STATUS' /
   IIEMPST3  'IMPUTATION REVISED EMPLOYMENT STATUS INDICATOR' /
   EMPSTATY  'IMPUTATION REVISED EMPLOYMENT STATUS' /
   IIEMPSTY  'IMPUTATION REVISED EMPLOYMENT STATUS INDICATOR' /
   EMPSTAT4  'IMP. REV. WORK STATUS CPS NO OTH. SPEC.' /
   IIEMPST4  'IMPUTATION REVISED EMPLOYMENT STATUS INDICATOR' /
   MOVESPY2  '# TIMES MOVED PAST 12 MONTHS' /
   ENROLED   'NOW ENROLLED IN ANY SCHOOL' /
   EDUCNOW2  'RECODE- WHAT GRADE IN NOW' /
   STUDNT    'FULL OR PART TIME' /
   SCHDSICK  'HOW MANY DAYS MISSED SCHOOL FROM SICK' /
   SCHDSKIP  'HOW MANY DAYS MISSED SCHOOL FROM SKIPPING' /
   HSDIPLMA  'RECEIVED DIPLOMA' /
   HSGED     'RECEIVED GED' /
   LFSCHWH2  'WHY YOU LEFT SCHOOL' /
   LFTSCHA2  'AGE WHEN STOPPED ATTENDING SCHOOL' /
   RLGSVCYR  'PAST 12 MOS, HOW MANY RELIG. SERVICES' /
   RLGIMPRT  'MY RELIGIOUS BELIEFS ARE VERY IMPORTANT' /
   RLGDECSN  'MY RELIGIOUS BELIEFS INFLUENCE MY DECISIONS' /
   RLGFRNDS  'IT IS IMPORTANT THAT MY FRIENDS SHARE REL BELIEFS' /
   TELNO2    '# OF TELEPHONE LINES IN HOUSEHOLD' /
   TUCHTONE  'ANY PHONES TOUCHTONE' /
   COLLEGE2  'COLLEGE ENROLLMENT' /
   CATAGE    'AGE CATEGORY' /
   CATAG2    'AGE CATEGORY RECODE (3 LEVELS)' /
   CATAG3    'AGE CATEGORY RECODE (5 LEVELS)' /
   CATAG7    'AGE CATEGORY RECODE (7 LEVELS)' /
   NEWRACE2  'RACE/HISPANICITY RECODE (7 LEVELS)' /
   EDUCCAT2  'EDUCATION RECODE' /
   JOBSTAT2  'WORK SITUATION IN PAST WEEK - RECODE' /
   JBSTATR2  'WORK SITUATION IN PAST WEEK - RECODE' /
   WRKHAVJB  'DID YOU HAVE A JOB OR BUSINESS' /
   WRKHRSWK  'HOW MANY HOURS WORKED LAST WEEK' /
   WRKINDU2  'TYPE OF BUSINESS OR INDUSTRY' /
   WRKOCCU2  'KIND OF WORK/JOB TITLE PRIMARY JOB' /
   WRKBZCA2  'CATEG THAT BEST DESCR BUSINESS YOU WORK IN' /
   WRKEFFRT  'PAST 30 DAYS, MAKE EFFORT TO FIND WORK' /
   WRKEDYR   'PAST 12 MOS, WORKED AT ANY JOB' /
   WRKSLFEM  'PAST 12 MOS, SELF EMPLOYED' /
   WRKJOBS2  'PAST 12 MOS, HOW MANY EMPLOYERS' /
   WRKUNEMP  'PAST 12 MOS, TIME WITH NO JOB' /
   WRKUNWKS  'HOW MANY WKS W/O JOB IN PAST 12 MOS' /
   WRKLASY2  'WHAT YEAR LAST WORKED' /
   WRKINDY2  'TYPE OF BUSINESS OR INDUSTRY' /
   WRKOCCY2  'KIND OF WORK/JOB TITLE PRIMARY JOB' /
   WORKDAYS  '# DAYS MISSED WORK FOR INJURY/ILLNESS PAST 30 DAYS' /
   WORKBLAH  '# DAYS SKIPPED WORK PAST 30 DAYS' /
   LOCSIZE   '# PEOPLE THAT WORK FOR EMPLOYER - RESP''S LOCATION' /
   DRGPLCY   'WORKPLACE HAVE WRITTEN POLICY DRUG/ALCOHOL USE' /
   PLCYCOV   'DID POLICY COVER ALCOHOL, DRUGS, OR  BOTH' /
   WKDRGED   'AT WORK, GIVEN EDUCATION ON DRUGS/ALC' /
   DRGPRGM   'ANY ASSISTANCE PROGRAM OFFERED THROUGH WRK' /
   USALCTST  'WORKPLACE TESTS FOR ALCOHOL USAGE' /
   USDRGTST  'WORKPLACE TESTS FOR DRUG USAGE' /
   TSTHIRE   'TEST FOR DRUG/ALC AS HIRING PROCESS' /
   TSTRAND   'TEST ON RANDOM BASIS' /
   FIRSTPOS  'WHAT HAPPENS FIRST TIME CAUGHT' /
   WRKHIRE   'WOULD YOU WORK FOR EMP DOES DRUG TEST PRE-HIRE' /
   WORKRAND  'WOULD YOU WORK FOR EMP DOES DRUG/ALC TEST RANDOMLY' /
   FIEXP99   'COMPLETED SOME INTERVIEWS IN 1999' /
   PDEN      'POPULATION DENSITY' /
   VESTR     'ANALYSIS STRATUM' /
   VEREP     'ANALYSIS REPLICATE' /
   ANALWT_C  'FIN PRSN-LEVEL SMPLE WGHT' /
   .


* SPSS VALUE LABELS COMMAND.

VALUE LABELS
   CIGEVER   1 'Yes' 2 'No' /
   CIGOFRSM  1 'Definitely Yes' 2 'Probably Yes' 3 'Probably Not'
             4 'Definitely Not' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGWILYR  1 'Definitely Yes' 2 'Probably Yes' 3 'Probably Not'
             4 'Definitely Not' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   CIGTRY    985 'BAD DATA Logically assigned' 991 'NEVER USED CIGARETTES'
             994 'DON''T KNOW' 997 'REFUSED' /
   CIGYFU    9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assn'
             9991 'NEVER USED CIGARETTES' 9994 'DON''T KNOW' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   CIGMFU    1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assn' 91 'NEVER USED CIGARETTES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   CIGREC    1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago but within the past 3 yrs'
             4 'More than 3 years ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             14 'Used more than 12 months ago LOG ASSN'
             19 'Used more than 30 days ago LOG ASSN'
             91 'NEVER USED CIGARETTES' /
   CIG30USE  85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CG30EST   1 '1 or 2 days' 2 '3 to 5 days' 3 '6 to 9 days'
             4 '10 to 19 days' 5 '20 to 29 days' 6 'All 30 days'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIG30AV   1 'Less than one cigarette per day' 2 '1 cigarette per day'
             3 '2 to 5 cigarettes per day'
             4 '6 to 15 cigarettes per day (about 1/2 pack)'
             5 '16 to 25 cigarettes per day (about 1 pack)'
             6 '26 to 35 cigarettes per day (about 1 1/2 packs)'
             7 'More than 35 cigs per day (abt 2 packs or more)'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CIG30BR2  101 'Basic' 102 'Benson & Hedges' 103 'Cambridge' 104 'Camel'
             105 'Capri' 106 'Carlton' 107 'Doral' 109 'GPC' 110 'Kent'
             111 'Kool' 112 'Marlboro' 113 'Merit' 114 'Misty' 115 'Monarch'
             116 'Montclair' 117 'More' 118 'Newport' 119 'Pall Mall'
             120 'Parliament' 121 'Private Label' 122 'Salem' 123 'Vantage'
             124 'Viceroy' 125 'Virginia Slims' 126 'Winston' 127 'Alpine'
             129 'Belair' 130 'Best Value' 132 'Bugler (roll-your-own)'
             137 'Eve' 142 'Lucky Strike' 144 'Maverick' 146 'Now'
             147 'Old Gold' 149 'Pyramid' 150 'Raleigh' 152 'Saratoga'
             157 'Tareyton' 158 'Top (roll-your-own)' 160 'True'
             161 'American Spirit' 162 'Austin' 169 'Bronson' 171 'Checkers'
             173 'Clove; brand unspecified' 174 'Daves'
             175 'Djarum cigarettes' 176 'Drum rolling tobacco'
             178 'Dunhill cigarettes' 179 'Eagle' 183 'First Class'
             185 'Generic cigarettes; brand unspecified' 188 'Gunsmoke'
             189 'Hi-Value' 190 'Jacks' 193 'Kamel Red' 196 'Mainstreet'
             404 'Black & Mild' 423 'Swisher Sweets'
             445 'Corona; brand unspecified' 1001 'Nat Sherman cigarettes'
             1005 'Private Stock' 1006 'Quality Smokes' 1011 'Sampoerna'
             1017 'Sundance' 1018 'USA Gold' 1019 'Vegas cigarettes'
             1020 'Waves' 1022 'Bailey' 1023 'Sport' 1029 'Tourney'
             1037 'DTC' 1040 'Smokin Joes cigarettes' 1044 'Worth'
             1047 'New York New York cigarettes' 1048 'Carnival' 1050 'USA'
             1055 'Geranimo' 1083 'Liggett Select'
             1999 'Other cigarette brand or unspecified'
             3999 'Other snuff brand or unspecified'
             4999 'Other cigar/cigarillo brand or unspecified'
             5999 'Other pipe tobacco brand or unspecified'
             7999 'Not a tobacco product'
             9000 'Did not confirm after 3 passes thru brand Qs'
             9985 'BAD DATA Logically assigned' 9991 'NEVER USED CIGARETTES'
             9993 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)' /
   CIG30TYP  1 'Lights' 2 'Ultra Lights' 3 'Full Flavor'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CIG30MEN  1 'Menthol' 2 'Regular' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CIG30RO2  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CIGDLYMO  1 'Yes' 2 'No' 5 'Yes LOGICALLY ASSIGNED (from skip pattern)'
             91 'NEVER USED CIGARETTES' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CIGAGE    985 'BAD DATA Logically assigned' 991 'NEVER USED CIGARETTES'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP (NEVER USED CIGS EVERYDAY)' /
   CIG100LF  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             5 'Yes LOGICALLY ASSIGNED (from skip pattern)'
             91 'NEVER USED CIGARETTES' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CHEWEVER  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED' /
   CHEWTRY   985 'BAD DATA Logically assigned'
             991 'NEVER USED CHEWING TOBACCO' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' /
   CHEWYFU   9985 'BAD DATA Logically assigned'
             9991 'NEVER USED CHEWING TOBACCO' 9994 'DON''T KNOW'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   CHEWMFU   1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CHEWING TOBACCO' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CHEWREC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago but within the past 3 yrs'
             4 'More than 3 years ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             14 'Used more than 12 months ago LOG ASSN'
             19 'Used more than 30 days ago LOG ASSN'
             91 'NEVER USED CHEWING TOBACCO' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CHW30USE  85 'BAD DATA Logically assigned' 91 'NEVER USED CHEWING TOBACCO'
             93 'DID NOT USE CHEWING TOBACCO PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CH30EST   1 '1 or 2 days' 2 '3 to 5 days' 3 '6 to 9 days'
             4 '10 to 19 days' 5 '20 to 29 days' 6 'All 30 days'
             91 'NEVER USED CHEWING TOBACCO'
             93 'DID NOT USE CHEWING TOBACCO IN THE PAST 30 DAYS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   CHW30BR2  201 'Beech-Nut' 202 'Chattanooga Chew' 203 'Day''s Work'
             204 'Granger' 206 'Levi Garrett' 207 'Red Fox' 208 'Red Man'
             209 'Taylors Pride' 211 'Work Horse' 221 'Mail Pouch'
             301 'Copenhagen' 304 'Hawken' 305 'Kodiak' 307 'Silver Creek'
             308 'Skoal' 309 'Timber Wolf' 312 'Cougar' 316 'Red Seal'
             317 'Rooster' 1999 'Other cigarette brand or unspecified'
             2999 'Other chewing tobacco brand or unspecified'
             3999 'Other snuff brand or unspecified'
             4999 'Other cigar/cigarillo brand or unspecified'
             5999 'Other pipe tobacco brand or unspecified'
             8999 'Tobacco replacement or tobacco-like product'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED CHEWING TOBACCO'
             9993 'DID NOT USE CHEWING TOBACCO IN THE PAST 30 DAYS'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)' /
   SNFEVER   1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED' /
   SNUFTRY   985 'BAD DATA Logically assigned' 991 'NEVER USED SNUFF'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   SNUFYFU   9985 'BAD DATA Logically assigned' 9991 'NEVER USED SNUFF'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)'
             9999 'LEGITIMATE SKIP' /
   SNUFMFU   1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             91 'NEVER USED SNUFF' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNFREC    1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago but within the past 3 yrs'
             4 'More than 3 years ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             14 'Used more than 12 months ago LOG ASSN'
             19 'Used more than 30 days ago LOG ASSN'
             91 'NEVER USED SMOKELESS TOBACCO' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   SNF30USE  85 'BAD DATA Logically assigned' 91 'NEVER USED SNUFF'
             93 'DID NOT USE SNUFF IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SN30EST   1 '1 or 2 days' 2 '3 to 5 days' 3 '6 to 9 days'
             4 '10 to 19 days' 5 '20 to 29 days' 6 'All 30 days'
             91 'NEVER USED SNUFF' 93 'DID NOT USE SNUFF IN THE PAST 30 DAYS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNF30BR2  208 'Red Man' 301 'Copenhagen' 302 'Gold River' 303 'Happy Days'
             304 'Hawken' 305 'Kodiak' 306 'Redwood' 307 'Silver Creek'
             308 'Skoal' 309 'Timber Wolf' 312 'Cougar' 316 'Red Seal'
             317 'Rooster' 321 'W. Garrett snuff'
             2999 'Other chewing tobacco brand or unspecified'
             3999 'Other snuff brand or unspecified'
             7999 'Not a tobacco product' 9985 'BAD DATA Logically assigned'
             9991 'NEVER USED SNUFF'
             9993 'DID NOT USE SNUFF IN THE PAST 30 DAYS' 9994 'DON''T KNOW'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' /
   SLTTRY    985 'BAD DATA Logically assigned'
             991 'NEVER USED SMOKELESS TOBACCO' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   SLTYFU    9985 'BAD DATA Logically assigned'
             9991 'NEVER USED SMOKELESS TOBACCO' 9994 'DON''T KNOW'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   SLTMFU    1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             91 'NEVER USED SMOKELESS TOBACCO' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SLTREC    1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago but within the past 3 yrs'
             4 'More than 3 years ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             14 'Used more than 12 months ago LOG ASSN'
             19 'Used more than 30 days ago LOG ASSN'
             91 'NEVER USED SMOKELESS TOBACCO' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   SLT30BR2  201 'Beech-Nut' 202 'Chattanooga Chew' 203 'Day''s Work'
             204 'Granger' 206 'Levi Garrett' 207 'Red Fox' 208 'Red Man'
             209 'Taylors Pride' 211 'Work Horse' 301 'Copenhagen'
             304 'Hawken' 305 'Kodiak' 306 'Redwood' 307 'Silver Creek'
             308 'Skoal' 309 'Timber Wolf' 312 'Cougar' 316 'Red Seal'
             317 'Rooster' 321 'W. Garrett snuff'
             1999 'Other cigarette brand or unspecified'
             2999 'Other chewing tobacco brand or unspecified'
             3999 'Other snuff brand or unspecified'
             4999 'Other cigar/cigarillo brand or unspecified'
             5999 'Other pipe tobacco brand or unspecified'
             7999 'Not a tobacco product'
             8999 'Tobacco replacement or tobacco-like product'
             9991 'NEVER USED SMOKELESS TOBACCO'
             9993 'DID NOT USE SMOKELESS TOBACCO IN THE PAST 30 DAYS'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)' /
   SLT30FAV  1 'Brand reported from CHW30BR2'
             2 'Brand reported from SNF30BR2'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED SMOKELESS TOBACCO'
             93 'DID NOT USE SMOKELESS TOBACCO IN THE PAST 30 DAYS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CIGAREVR  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED' /
   CIGARTRY  985 'BAD DATA Logically assigned' 991 'NEVER USED CIGARS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   CIGARYFU  9985 'BAD DATA Logically assigned' 9991 'NEVER USED CIGARS'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)'
             9999 'LEGITIMATE SKIP' /
   CIGARMFU  1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGARREC  1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago but within the past 3 yrs'
             4 'More than 3 years ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             14 'Used more than 12 months ago LOG ASSN'
             19 'Used more than 30 days ago LOG ASSN' 91 'NEVER USED CIGARS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CGR30USE  85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARS'
             93 'DID NOT USE CIGARS IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CI30EST   1 '1 or 2 days' 2 '3 to 5 days' 3 '6 to 9 days'
             4 '10 to 19 days' 5 '20 to 29 days' 6 'All 30 days'
             91 'NEVER USED CIGARS' 93 'DID NOT USE CIGARS PAST 30 DAYS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   CGR30BR2  112 'Marlboro' 118 'Newport' 401 'Antonio y Cleopatra'
             402 'Backwoods' 403 'Bering' 404 'Black & Mild'
             405 'Captain Black' 406 'Casa Silva' 407 'Cuesta-Rey'
             408 'Dutch Masters' 409 'El Producto' 411 'Garcia y Vega'
             412 'Havatampa' 413 'King Edward' 414 'La Corona'
             415 'Little Nippers' 416 'Macanudos' 417 'Muriel' 418 'Partagas'
             419 'Phillies' 420 'Rigoletto' 421 'Robert Burns' 422 'Roi-Tan'
             423 'Swisher Sweets' 424 'Tijuana Smalls' 426 'White Owl'
             427 'William Penn' 428 'Winchester' 429 'Al Capone'
             431 'Arturo Fuente' 432 'Ashton' 434 'Baccarat' 443 'Cohiba'
             445 'Corona; brand unspecified' 448 'Cuban; brand unspecified'
             451 'Davidoff' 452 'Don Diego' 462 'Grenadiers' 464 'H. Upmann'
             465 'Habana/Havana; brand unspecified' 486 'Montecristo'
             488 'Optimo' 490 'Padron' 491 'Parodi Cella' 492 'Primetime'
             494 'Punch' 496 'Romeo y Julieta'
             1999 'Other cigarette brand or unspecified' 4005 'Thompson'
             4006 'Tiparillo' 4016 'Dominican; brand unspecified'
             4041 'Miami Suites' 4050 'Fuente' 4051 'Avo'
             4999 'Other cigar/cigarillo brand or unspecified'
             7999 'Not a tobacco product' 9985 'BAD DATA Logically assigned'
             9991 'NEVER USED CIGARS'
             9993 'DID NOT USE CIGARS IN THE PAST 30 DAYS' 9994 'DON''T KNOW'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' /
   PIPEVER   1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED' /
   PIPE30DY  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED PIPE TOBACCO' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   ALCEVER   1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED' /
   ALCTRY    985 'BAD DATA Logically assigned' 991 'NEVER USED ALCOHOL'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   ALCYFU    9985 'BAD DATA Logically assigned' 9991 'NEVER USED ALCOHOL'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)'
             9999 'LEGITIMATE SKIP' /
   ALCMFU    1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCREC    1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             91 'NEVER USED ALCOHOL' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALCYRTOT  985 'BAD DATA Logically assigned' 991 'NEVER USED ALCOHOL'
             993 'DID NOT USE ALCOHOL IN THE PAST 12 MONTHS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   ALTOTFG   1 'Trimmed to 365 days (no further editing)'
             2 'Trimmed relative to the 30-day freq' 98 'BLANK (NO ANSWER)' /
   ALFQFLG   1 'Trimmed to be consistent with mo/yr of 1st use'
             98 'BLANK (NO ANSWER)' /
   ALBSTWAY  1 'Prefer to answer in days per week'
             2 'Prefer to answer in days per month'
             3 'Prefer to answer in days per year'
             11 'Prefer to ans in days per wk LOG ASSN'
             12 'Prefer to ans in days per mo LOG ASSN'
             13 'Prefer to ans in days per yr LOG ASSN'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALCOHOL IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALDAYPYR  985 'BAD DATA Logically assigned'
             989 'LEGITIMATE SKIP Logically assigned'
             991 'NEVER USED ALCOHOL'
             993 'DID NOT USE ALCOHOL IN THE PAST 12 MONTHS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   ALDAYPMO  85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALCOHOL IN THE PAST 12 MONTHS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALDAYPWK  85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALCOHOL IN THE PAST 12 MONTHS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCDAYS   85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALCOHOL IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   AL30EST   1 '1 or 2 days' 2 '3 to 5 days' 3 '6 to 9 days'
             4 '10 to 19 days' 5 '20 to 29 days' 6 'All 30 days'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALCOHOL IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALDYSFG   1 'Edited for consistency with ALCYRTOT or DR5DAY'
             98 'BLANK (NO ANSWER)' /
   NODR30A   975 'AT LEAST 5 Logically assigned'
             985 'BAD DATA Logically assigned' 991 'NEVER USED ALCOHOL'
             993 'DID NOT USE ALCOHOL IN THE PAST 30 DAYS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   DR5DAY    80 'NO OCCAS OF 5+ DRINKS PST 30 DAYS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALCOHOL IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MJEVER    1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED' /
   MJAGE     985 'BAD DATA Logically assigned' 991 'NEVER USED MARIJUANA'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   MJYFU     9985 'BAD DATA Logically assigned' 9991 'NEVER USED MARIJUANA'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)'
             9999 'LEGITIMATE SKIP' /
   MJMFU     1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             91 'NEVER USED MARIJUANA' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   MJREC     1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             91 'NEVER USED MARIJUANA' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MJYRTOT   985 'BAD DATA Logically assigned' 991 'NEVER USED MARIJUANA'
             993 'DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   MRTOTFG   1 'Trimmed to 365 days (no further editing)'
             2 'Trimmed relative to the 30-day freq' 98 'BLANK (NO ANSWER)' /
   MJFQFLG   1 'Trimmed to be consistent with mo/yr of 1st use'
             98 'BLANK (NO ANSWER)' /
   MRBSTWAY  1 'Prefer to answer in days per week'
             2 'Prefer to answer in days per month'
             3 'Prefer to answer in days per year'
             11 'Prefer to ans in days per wk LOG ASSN'
             12 'Prefer to ans in days per mo LOG ASSN'
             13 'Prefer to ans in days per yr LOG ASSN'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MRDAYPYR  985 'BAD DATA Logically assigned'
             989 'LEGITIMATE SKIP Logically assigned'
             991 'NEVER USED MARIJUANA'
             993 'DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   MRDAYPMO  85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   MRDAYPWK  85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   MJDAY30A  85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MARIJUANA IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MR30EST   1 '1 or 2 days' 2 '3 to 5 days' 3 '6 to 9 days'
             4 '10 to 19 days' 5 '20 to 29 days' 6 'All 30 days'
             91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   COCEVER   1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED' /
   COCAGE    985 'BAD DATA Logically assigned' 991 'NEVER USED COCAINE'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   COCYFU    9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assn' 9991 'NEVER USED COCAINE'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)'
             9999 'LEGITIMATE SKIP' /
   COCMFU    1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assn' 91 'NEVER USED COCAINE'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   COCREC    1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             11 'Used in the past 30 days LOGICALLY ASSIGNED'
             12 'Used >30 days ago but within pst 12 mos LOG ASSN'
             91 'NEVER USED COCAINE' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCYRTOT  985 'BAD DATA Logically assigned' 991 'NEVER USED COCAINE'
             993 'DID NOT USE COCAINE IN THE PAST 12 MOS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   CCTOTFG   2 'Trimmed relative to the 30-day freq' 98 'BLANK (NO ANSWER)' /
   CCFQFLG   1 'Trimmed to be consistent with mo/yr of 1st use'
             98 'BLANK (NO ANSWER)' /
   CCBSTWAY  1 'Prefer to answer in days per week'
             2 'Prefer to answer in days per month'
             3 'Prefer to answer in days per year'
             11 'Prefer to ans in days per wk LOG ASSN'
             12 'Prefer to ans in days per mo LOG ASSN'
             13 'Prefer to ans in days per yr LOG ASSN'
             21 'Prefer to ans in days per wk (CRBSTWAY=1,11)'
             22 'Prefer to ans in days per mo (CRBSTWAY=2,12)'
             23 'Prefer to ans in days per yr (CRBSTWAY=3,13)'
             85 'BAD DATA Logically assigned' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CCDAYPYR  985 'BAD DATA Logically assigned'
             989 'LEGITIMATE SKIP Logically assigned'
             991 'NEVER USED COCAINE'
             993 'DID NOT USE COCAINE IN THE PAST 12 MOS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   CCDAYPMO  89 'LEGITIMATE SKIP Logically assigned' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CCDAYPWK  85 'BAD DATA Logically assigned' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   COCUS30A  85 'BAD DATA Logically assigned' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CC30EST   2 '3 to 5 days' 3 '6 to 9 days' 5 '20 to 29 days'
             6 'All 30 days' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE IN THE PAST 30 DAYS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CRKEVER   1 'Yes' 2 'No' 91 'NEVER USED COCAINE (COCEVER=2)'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CRKAGE    985 'BAD DATA Logically assigned' 991 'NEVER USED CRACK'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   CRKYFU    9985 'BAD DATA Logically assigned' 9991 'NEVER USED CRACK'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)'
             9999 'LEGITIMATE SKIP' /
   CRKMFU    1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CRACK' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CRAKREC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             91 'NEVER USED CRACK' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CRKYRTOT  985 'BAD DATA Logically assigned' 991 'NEVER USED CRACK'
             993 'DID NOT USE CRACK IN THE PAST 12 MOS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   CRTOTFG   2 'Trimmed relative to the 30-day freq' 98 'BLANK (NO ANSWER)' /
   CRFQFLG   1 'Trimmed to be consistent with mo/yr of 1st use'
             98 'BLANK (NO ANSWER)' /
   CRBSTWAY  1 'Prefer to answer in days per week'
             2 'Prefer to answer in days per month'
             3 'Prefer to answer in days per year'
             11 'Prefer to ans in days per wk LOG ASSN'
             12 'Prefer to ans in days per mo LOG ASSN'
             13 'Prefer to ans in days per yr LOG ASSN'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CRACK'
             93 'DID NOT USE CRACK IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CRDAYPYR  989 'LEGITIMATE SKIP Logically assigned' 991 'NEVER USED CRACK'
             993 'DID NOT USE CRACK IN THE PAST 12 MOS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   CRDAYPMO  85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned' 91 'NEVER USED CRACK'
             93 'DID NOT USE CRACK IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CRDAYPWK  85 'BAD DATA Logically assigned' 91 'NEVER USED CRACK'
             93 'DID NOT USE CRACK IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CRKUS30A  85 'BAD DATA Logically assigned' 91 'NEVER USED CRACK'
             93 'DID NOT USE CRACK IN THE PAST 30 DAYS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CR30EST   4 '10 to 19 days' 91 'NEVER USED CRACK'
             93 'DID NOT USE CRACK IN THE PAST 30 DAYS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HEREVER   1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED' /
   HERAGE    985 'BAD DATA Logically assigned' 991 'NEVER USED HEROIN'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   HERYFU    9985 'BAD DATA Logically assigned' 9991 'NEVER USED HEROIN'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)'
             9999 'LEGITIMATE SKIP' /
   HERMFU    1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             91 'NEVER USED HEROIN' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HERREC    1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             91 'NEVER USED HEROIN' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HERYRTOT  985 'BAD DATA Logically assigned' 991 'NEVER USED HEROIN'
             993 'DID NOT USE HEROIN IN THE PAST 12 MOS' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' /
   HRTOTFG   2 'Trimmed relative to the 30-day freq' 98 'BLANK (NO ANSWER)' /
   HRFQFLG   1 'Trimmed to be consistent with mo/yr of 1st use'
             98 'BLANK (NO ANSWER)' /
   HRBSTWAY  1 'Prefer to answer in days per week'
             2 'Prefer to answer in days per month'
             3 'Prefer to answer in days per year'
             11 'Prefer to ans in days per wk LOG ASSN'
             13 'Prefer to ans in days per yr LOG ASSN'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PAST 12 MONTHS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HRDAYPYR  989 'LEGITIMATE SKIP Logically assigned' 991 'NEVER USED HEROIN'
             993 'DID NOT USE HEROIN PAST 12 MOS' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   HRDAYPMO  85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PAST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HRDAYPWK  85 'BAD DATA Logically assigned' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PAST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HER30USE  85 'BAD DATA Logically assigned' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN IN THE PAST 30 DAYS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HR30EST   91 'NEVER USED HEROIN' 93 'DID NOT USE HEROIN PAST 30 DAYS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   LSD       1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             91 'NEVER USED HALLUCINOGENS' 94 'DON''T KNOW' 97 'REFUSED' /
   PCP       1 'Yes' 2 'No' 91 'NEVER USED HALLUCINOGENS' 94 'DON''T KNOW'
             97 'REFUSED' /
   PEYOTE    1 'Yes' 2 'No' 91 'NEVER USED HALLUCINOGENS' 94 'DON''T KNOW'
             97 'REFUSED' /
   MESC      1 'Yes' 2 'No' 91 'NEVER USED HALLUCINOGENS' 94 'DON''T KNOW'
             97 'REFUSED' /
   PSILCY    1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             91 'NEVER USED HALLUCINOGENS' 94 'DON''T KNOW' 97 'REFUSED' /
   ECSTASY   1 'Yes' 2 'No' 91 'NEVER USED HALLUCINOGENS' 94 'DON''T KNOW'
             97 'REFUSED' /
   HALNOLST  1 'Yes' 2 'No' 91 'NEVER USED HALLUCINOGENS' 94 'DON''T KNOW'
             97 'REFUSED' /
   HALNEWA   112 'Restoril, Temazepam' 116 'Methaqualone, Quaalude, Sopor'
             120 'Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
             142 'Belladona' 201 'Valium, Diazepam' 267 'Marezine'
             268 'Rohypnol, Roche, roofies' 280 'Ketaset' 292 'Serzone'
             318 'Ritalin, Methylphenidate'
             322 'Methamphetamine ("ice" or "crank"), Meth'
             324 'Uppers; OTHER Stimulant, NOT OTHERWISE SPECIFIED'
             326 'White cross' 332 'Ephedrine' 348 'Crystal'
             353 'No-Doz <OTC>' 355 'Crystal meth' 415 'Codeine'
             417 'Morphine, Roxanol'
             434 'Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin'
             501 'Gasoline or lighter fluids' 502 'Spray paints'
             503 'Other aerosol sprays'
             504 'Shoeshine liquid, glue, or toluene'
             506 'Amyl nitrite,"poppers,"locker room odorizer,"rush"'
             507 'Halothane, ether, or other anesthetics; chloroform'
             508 'Nitrous oxide, "whippets," dentist gas'
             510 'OTHER Inhalant, NOT OTHERWISE SPECIFIED'
             511 'Markers, felt-tip pens, ink pens' 516 'Freon, refrigerant'
             519 'Helium' 520 'Old paint, paint' 521 'Propane'
             524 'White-Out' 525 'Butane' 540 'PAM'
             566 'Smoked tea from Lipton tea bag'
             592 'Computer air duster, computer cleaner, dust-off'
             601 'LSD ("acid")' 602 'Peyote' 603 'Mescaline'
             604 'Psilocybin (mushrooms), shrooms'
             605 'PCP ("angel dust," phencyclidine)'
             607 'OTHER Hallucinogen, NOT OTHERWISE SPECIFIED'
             609 'Jimson weed' 612 'Happy stick, sherm, sherman, shermstick'
             614 'MDA, Methylenedioxy amphetamine' 615 'Homemade drugs'
             616 'DET, Dimethyltryptamine, DMT'
             617 'Morning glory seeds, morning glory tendrils'
             618 'Acid paper, blotter (acid)' 619 'Tic'
             622 'Microdot(s), green microdot, purple microdot'
             624 'Orange sunshine, sunshine, yellow sunshine'
             625 'Window, window pane, 4-way pane'
             627 'Hawaiian wood rose, Hawaiian Woodrow seeds'
             633 'Mr. Natural' 636 'DOM, STP' 637 'Purple haze'
             639 'Nutmeg, Mace' 650 'Datura stramonium, daytura, thorn apple'
             658 'Special K, Ketamine' 660 'Toad, Toad licking'
             678 'Banana peels' 683 'Yage' 695 'Angel''s trumpet'
             698 'Nexus, 2C-B' 701 'OTHER Opiates, NOT OTHERWISE SPECIFIED'
             703 'Opium' 802 'THC, cannabinol, marinol'
             803 'Marijuana, MarrJane, Mary Jane, MJ, pot, weed'
             806 'Crack, rock' 809 'Pills' 828 'Tetracycline'
             829 'Robitussin DM <OTC>'
             843 'Antihistamine, cold medicine, cold tablets <OTC>'
             847 'GHB, NSC' 852 'Formaldehyde, wak, whack (embalming fluid)'
             883 'Dextromethorphan Hydrobromide <OTC>'
             1002 'Dramamine, seasick/motion sickness pill <OTC>'
             2002 'Muscle Relaxers' 3023 'Adderall'
             3052 'Speed; otherwise unspecified'
             3064 'Ephedra, Ma Huang <OTC>'
             5022 'Carbon dioxide, CO2, dry ice hits'
             5028 'Carburetor cleaner, engine cleaner' 6005 'Sassafras tea'
             6029 'DXM' 6037 'Fry' 6038 'Triplets, Trips'
             6043 'Salviadivinorum' 6044 'Gel caps, gel tabs'
             6055 'Liberty caps' 6056 'Wet' 6062 'Madderwort, Wormwood'
             6063 'Foxglove' 6073 'Rolls' 6074 'LSA' 6077 'San Pedro'
             6078 'Trumpet flowers' 6079 'Sugar cubes' 6083 'CCC, Triple "C"'
             6085 'Dips' 6089 'Cake' 6090 'Heaven' 6092 'TCP'
             6094 'Mushrooms, specifically not psilocybin'
             6095 'Super cool, Super kool' 6096 'Bananadine'
             6097 'Banana slug slime' 6099 'Katmandue Temple Kiff'
             8011 'Herb, flower, plant; type unspecified'
             8012 'Coriciden <OTC>'
             8058 'Cough medicine/syrup; type unspecified'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED HALLUCINOGENS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   HALNEWB   142 'Belladona' 201 'Valium, Diazepam'
             322 'Methamphetamine ("ice" or "crank"), Meth' 345 'Black Molly'
             435 'Tylenol, Tylenol Extra-Strength <OTC>'
             501 'Gasoline or lighter fluids'
             504 'Shoeshine liquid, glue, or toluene'
             505 'Lacquer thinner or other paint solvents'
             506 'Amyl nitrite,"poppers,"locker room odorizer,"rush"'
             508 'Nitrous oxide, "whippets," dentist gas'
             511 'Markers, felt-tip pens, ink pens' 520 'Old paint, paint'
             566 'Smoked tea from Lipton tea bag' 601 'LSD ("acid")'
             603 'Mescaline' 604 'Psilocybin (mushrooms), shrooms'
             607 'OTHER Hallucinogen, NOT OTHERWISE SPECIFIED'
             612 'Happy stick, sherm, sherman, shermstick'
             614 'MDA, Methylenedioxy amphetamine'
             616 'DET, Dimethyltryptamine, DMT'
             617 'Morning glory seeds, morning glory tendrils'
             618 'Acid paper, blotter (acid)'
             622 'Microdot(s), green microdot, purple microdot'
             624 'Orange sunshine, sunshine, yellow sunshine' 636 'DOM, STP'
             639 'Nutmeg, Mace' 658 'Special K, Ketamine' 678 'Banana peels'
             695 'Angel''s trumpet' 703 'Opium'
             802 'THC, cannabinol, marinol' 809 'Pills'
             829 'Robitussin DM <OTC>' 847 'GHB, NSC' 6029 'DXM'
             6031 'Strychnine' 6079 'Sugar cubes' 6080 'Purple passion'
             6086 'Flakes' 6087 'Ibogaine'
             8011 'Herb, flower, plant; type unspecified'
             8012 'Coriciden <OTC>'
             8058 'Cough medicine/syrup; type unspecified'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED HALLUCINOGENS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   HALNEWC   355 'Crystal meth' 503 'Other aerosol sprays' 524 'White-Out'
             566 'Smoked tea from Lipton tea bag' 601 'LSD ("acid")'
             604 'Psilocybin (mushrooms), shrooms' 609 'Jimson weed'
             616 'DET, Dimethyltryptamine, DMT' 847 'GHB, NSC'
             1002 'Dramamine, seasick/motion sickness pill <OTC>' 6029 'DXM'
             6091 'Ergot, rye mold' 6092 'TCP'
             6098 'Dust; not otherwise specified'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED HALLUCINOGENS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   HALNEWD   268 'Rohypnol, Roche, roofies' 501 'Gasoline or lighter fluids'
             503 'Other aerosol sprays' 520 'Old paint, paint'
             601 'LSD ("acid")'
             607 'OTHER Hallucinogen, NOT OTHERWISE SPECIFIED'
             617 'Morning glory seeds, morning glory tendrils'
             627 'Hawaiian wood rose, Hawaiian Woodrow seeds' 6029 'DXM'
             6078 'Trumpet flowers' 9985 'BAD DATA Logically assigned'
             9991 'NEVER USED HALLUCINOGENS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   HALNEWE   506 'Amyl nitrite,"poppers,"locker room odorizer,"rush"'
             528 'Whipped-cream can'
             617 'Morning glory seeds, morning glory tendrils'
             6084 'Devil dust' 9985 'BAD DATA Logically assigned'
             9991 'NEVER USED HALLUCINOGENS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   HALLAGE   985 'BAD DATA Logically assigned' 991 'NEVER USED HALLUCINOGENS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   HALYFU    9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assn'
             9991 'NEVER USED HALLUCINOGENS' 9994 'DON''T KNOW'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   HALMFU    1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assn'
             91 'NEVER USED HALLUCINOGENS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HALLREC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in lifetime LOG ASSN'
             11 'Used in the past 30 days LOGICALLY ASSIGNED'
             12 'Used >30 days ago but within pst 12 mos LOG ASSN'
             91 'NEVER USED HALLUCINOGENS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HALYRTOT  985 'BAD DATA Logically assigned' 991 'NEVER USED HALLUCINOGENS'
             993 'DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   HLTOTFG   2 'Trimmed relative to the 30-day freq' 98 'BLANK (NO ANSWER)' /
   HLFQFLG   1 'Trimmed to be consistent with mo/yr of 1st use'
             98 'BLANK (NO ANSWER)' /
   HLBSTWAY  1 'Prefer to answer in days per week'
             2 'Prefer to answer in days per month'
             3 'Prefer to answer in days per year'
             11 'Prefer to ans in days per wk LOG ASSN'
             12 'Prefer to ans in days per mo LOG ASSN'
             13 'Prefer to ans in days per yr LOG ASSN'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PAST 12 MONTHS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HLDAYPYR  985 'BAD DATA Logically assigned'
             989 'LEGITIMATE SKIP Logically assigned'
             991 'NEVER USED HALLUCINOGENS'
             993 'DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   HLDAYPMO  85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   HLDAYPWK  85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   HAL30USE  85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS IN THE PAST 30 DAYS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HL30EST   1 '1 or 2 days' 3 '6 to 9 days' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PAST 30 DAYS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   LSDAGE    985 'BAD DATA Logically assigned' 991 'NEVER USED LSD'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   LSDYFU    9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assigned' 9991 'NEVER USED LSD'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)'
             9999 'LEGITIMATE SKIP' /
   LSDMFU    1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assn' 91 'NEVER USED LSD'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   LSDREC    1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             91 'NEVER USED LSD' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   PCPAGE    985 'BAD DATA Logically assigned' 991 'NEVER USED PCP'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   PCPYFU    9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assigned' 9991 'NEVER USED PCP'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)'
             9999 'LEGITIMATE SKIP' /
   PCPMFU    1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assn' 91 'NEVER USED PCP'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   PCPREC    1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in the lifetime LOG ASSN'
             91 'NEVER USED PCP' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   AMYLNIT   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             91 'NEVER USED INHALANTS' 94 'DON''T KNOW' 97 'REFUSED' /
   CLEFLU    1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             91 'NEVER USED INHALANTS' 94 'DON''T KNOW' 97 'REFUSED' /
   GAS       1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             91 'NEVER USED INHALANTS' 94 'DON''T KNOW' 97 'REFUSED' /
   GLUE      1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             91 'NEVER USED INHALANTS' 94 'DON''T KNOW' 97 'REFUSED' /
   ETHER     1 'Yes' 2 'No' 91 'NEVER USED INHALANTS' 94 'DON''T KNOW'
             97 'REFUSED' /
   SOLVENT   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             91 'NEVER USED INHALANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   LGAS      1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             91 'NEVER USED INHALANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   NITOXID   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             91 'NEVER USED INHALANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   SPPAINT   1 'Yes' 2 'No' 91 'NEVER USED INHALANTS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   AEROS     1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             91 'NEVER USED INHALANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   INHNOLST  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHNEWA   110 'Tuinal' 304 'Benzedrine' 318 'Ritalin, Methylphenidate'
             322 'Methamphetamine ("ice" or "crank"), Meth' 348 'Crystal'
             377 'Albuterol, Proventil, Ventolin'
             501 'Gasoline or lighter fluids' 502 'Spray paints'
             503 'Other aerosol sprays'
             504 'Shoeshine liquid, glue, or toluene'
             505 'Lacquer thinner or other paint solvents'
             506 'Amyl nitrite,"poppers,"locker room odorizer,"rush"'
             507 'Halothane, ether, or other anesthetics; chloroform'
             508 'Nitrous oxide, "whippets," dentist gas'
             509 'Correction fluids, degreasers, cleaning fluids'
             510 'OTHER Inhalant, NOT OTHERWISE SPECIFIED'
             511 'Markers, felt-tip pens, ink pens' 512 'Incense'
             516 'Freon, refrigerant' 518 'Acetone, nail polish remover'
             519 'Helium' 520 'Old paint, paint' 524 'White-Out' 525 'Butane'
             526 'Nail polish' 528 'Whipped-cream can'
             531 'Candy, powdered candy, sugar' 534 'Deodorant'
             539 'ScotchGard' 540 'PAM'
             546 'Leather protector, suede protector'
             548 'Cologne, isopropanol vapors, rubbing alcohol'
             560 'Laundry detergent, soap' 567 'Pertussin spray' 580 'Medusa'
             590 'Canned air, compressed air'
             592 'Computer air duster, computer cleaner, dust-off'
             599 'Potpourri' 658 'Special K, Ketamine'
             803 'Marijuana, MarrJane, Mary Jane, MJ, pot, weed'
             815 'Coffee <OTC>' 829 'Robitussin DM <OTC>' 847 'GHB, NSC'
             3052 'Speed; otherwise unspecified' 3053 'Maxair, Pirbuterol'
             5017 'Oil, lubricant; otherwise unspecified'
             5021 'Octane booster' 5022 'Carbon dioxide, CO2, dry ice hits'
             5035 'Brake cleaner' 5037 'Wood filler' 5039 'Acetate'
             5042 'Fuels other than gasoline' 5043 'Carbona'
             5045 'Cleaner; not otherwise specified'
             5046 'Glass/window cleaner' 5047 'Tetrafluorethylene'
             6047 'Water' 8009 'Allergy pills; type unspecified'
             8024 'Asthma inhaler,asthma medication,bronchial dilator'
             8054 'Beconase' 9985 'BAD DATA Logically assigned'
             9991 'NEVER USED INHALANTS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   INHNEWB   501 'Gasoline or lighter fluids' 503 'Other aerosol sprays'
             504 'Shoeshine liquid, glue, or toluene'
             508 'Nitrous oxide, "whippets," dentist gas'
             510 'OTHER Inhalant, NOT OTHERWISE SPECIFIED'
             511 'Markers, felt-tip pens, ink pens' 516 'Freon, refrigerant'
             518 'Acetone, nail polish remover' 519 'Helium'
             520 'Old paint, paint' 524 'White-Out' 526 'Nail polish'
             528 'Whipped-cream can' 539 'ScotchGard' 540 'PAM'
             592 'Computer air duster, computer cleaner, dust-off'
             5041 'Wood alcohol' 5043 'Carbona'
             5044 'Powdered cleansers; e.g. Ajax, Comet, Borax'
             8024 'Asthma inhaler,asthma medication,bronchial dilator'
             8055 'Flonase' 9985 'BAD DATA Logically assigned'
             9991 'NEVER USED INHALANTS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   INHNEWC   504 'Shoeshine liquid, glue, or toluene'
             505 'Lacquer thinner or other paint solvents'
             511 'Markers, felt-tip pens, ink pens'
             518 'Acetone, nail polish remover' 520 'Old paint, paint'
             524 'White-Out'
             548 'Cologne, isopropanol vapors, rubbing alcohol'
             8024 'Asthma inhaler,asthma medication,bronchial dilator'
             9991 'NEVER USED INHALANTS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   INHNEWD   503 'Other aerosol sprays' 524 'White-Out' 526 'Nail polish'
             9991 'NEVER USED INHALANTS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   INHNEWE   518 'Acetone, nail polish remover' 9991 'NEVER USED INHALANTS'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   INHAGE    985 'BAD DATA Logically assigned' 991 'NEVER USED INHALANTS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   INHYFU    9985 'BAD DATA Logically assigned' 9991 'NEVER USED INHALANTS'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)'
             9999 'LEGITIMATE SKIP' /
   INHMFU    1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 85 'BAD DATA Logically assigned'
             91 'NEVER USED INHALANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   INHREC    1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in lifetime LOG ASSN'
             91 'NEVER USED INHALANTS' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHYRTOT  985 'BAD DATA Logically assigned' 991 'NEVER USED INHALANTS'
             993 'DID NOT USE INHALANTS IN THE PAST 12 MOS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   INTOTFG   2 'Trimmed relative to the 30-day freq' 98 'BLANK (NO ANSWER)' /
   INFQFLG   1 'Trimmed to be consistent with mo/yr of 1st use'
             98 'BLANK (NO ANSWER)' /
   INBSTWAY  1 'Prefer to answer in days per week'
             2 'Prefer to answer in days per month'
             3 'Prefer to answer in days per year'
             11 'Prefer to ans in days per wk LOG ASSN'
             12 'Prefer to ans in days per mo LOG ASSN'
             13 'Prefer to ans in days per yr LOG ASSN'
             85 'BAD DATA Logically assigned' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INDAYPYR  985 'BAD DATA Logically assigned'
             989 'LEGITIMATE SKIP Logically assigned'
             991 'NEVER USED INHALANTS'
             993 'DID NOT USE INHALANTS IN THE PAST 12 MOS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   INDAYPMO  89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   INDAYPWK  85 'BAD DATA Logically assigned' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   INHDY30A  85 'BAD DATA Logically assigned' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   IN30EST   1 '1 or 2 days' 2 '3 to 5 days' 3 '6 to 9 days' 6 'All 30 days'
             91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   DARVTYLC  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   PERCTYLX  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   VICOLOR   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLCARD   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CODEINE   1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   DEMEROL   1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   DILAUD    1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   FIORICET  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   FIORINAL  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   HYDROCOD  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   METHDON   1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   MORPHINE  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   OXYCONTN  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   PHENCOD   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   PROPOXY   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SK65A     1 'Response entered' 6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   STADOL    1 'Response entered' 6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   TALACEN   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   TALWIN    1 'Response entered' 6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   TALWINNX  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   TRAMADOL  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   ULTRAM    1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   ANLNOLST  1 'Yes' 2 'No' 4 'No LOGICALLY ASSIGNED'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANALNEWA  105 'Placidyl' 109 'Seconal' 110 'Tuinal'
             112 'Restoril, Temazepam' 113 'Halcion' 115 'Phenobarbital'
             116 'Methaqualone, Quaalude, Sopor'
             120 'Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
             124 'Yellow jackets' 129 'Reds' 130 'Phenergan, Promethazine'
             138 'Mandrakes' 157 'Barbiturates' 174 'Ambien, Zolpidem'
             201 'Valium, Diazepam' 209 'Xanax, Alprazolam' 211 'Buspar'
             212 'Miltown' 223 'Carbacot, Marbaxin, Methocarbamol, Robaxin'
             225 'Desyrel, Trazodone hydrochloride' 227 'Thorazine'
             228 'Amitriptyline, Elavil' 234 'Cyclobenzaprine, Flexeril'
             240 'Lithium carbonate, Lithonate' 241 'Prozac'
             246 'Clonazepam, Klonopin, Rivotril'
             268 'Rohypnol, Roche, roofies' 271 'Zoloft'
             283 'Paroxetine, Paxil' 301 'Dexedrine'
             318 'Ritalin, Methylphenidate'
             322 'Methamphetamine ("ice" or "crank"), Meth'
             334 'Crossroads, cross tops' 352 'Lemons' 356 'Dexies'
             401 'Darvon' 406 'Percodan' 407 'Demerol' 408 'Dilaudid'
             409 'Tylenol with Codeine, Tylenol 3, Tylenol 4' 415 'Codeine'
             417 'Morphine, Roxanol' 418 'Dolophine, Methadone'
             420 'OTHER Analgesic, NOT OTHERWISE SPECIFIED'
             421 'USED ANALGESIC, DON''T KNOW NAME' 422 'Motrin'
             423 'Percocet' 425 'Advil <OTC>' 426 'Fiorinal' 427 'Darvocet'
             430 'Aspirin, Ecotrin, Empirin <OTC>' 431 'Tylox'
             433 'Paregoric'
             434 'Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin'
             435 'Tylenol, Tylenol Extra-Strength <OTC>'
             438 'Anaprox, Naprosyn, Naproxen' 442 'Ibuprofen'
             450 'Acetaminophen <OTC>' 454 'Novocain, Procaine'
             458 'Mepergan, Mepergan Fortis, Meprozine'
             465 'Fentanyl, Duragesic, Sublimaze' 472 'Indocin, Indomethacin'
             476 'Duradrin, Isocom, Midrin' 477 'Melumbrina, Neo-Melumbrina'
             481 'Acular, Ketorolac tromethamine, Toradol' 490 'Nubain'
             496 'Ultram' 635 'Ginseng seeds, ginseng weed'
             802 'THC, cannabinol, marinol' 820 'Penicillin'
             821 'Amoxicillin, Ampicillin' 824 'Steroids' 825 'Theo-Dur'
             828 'Tetracycline' 846 'Erythromycin' 858 'Antibiotic'
             895 'Tagamet, Cimetidine' 896 'Catapres, Clonidine'
             2001 'Carisoprodol, Soma' 2002 'Muscle Relaxers' 3023 'Adderall'
             3027 'Energy pills' 3052 'Speed; otherwise unspecified'
             4001 'Actron, Ketoprofen, Orudis, Oruvail'
             4002 'Imitrex, Sumatriptan' 4005 'Etodolac, Lodine'
             4029 'Feldine, Piroxicam' 4031 'Cough medicine with codeine'
             4033 'Vicoprofen' 4034 'Lilly red' 4035 'Nabumetone, Relafin'
             4037 'MS Contin' 4039 'Daypro' 4044 'Hydrocodone'
             4046 'Oxycodone' 4047 'Roxicet' 4052 'Endocet' 4053 'Codydramol'
             4054 'Zomax' 4055 'Vioxx' 4058 'Totem poles' 6076 'Lemon 714'
             8002 'Zantac' 8007 'Gabapentin, Neurontin'
             8008 'Antidepressant; type unspecified'
             8010 'Zyrtec, cetirizine' 8018 'Claritromicina' 8020 'Allegra'
             8024 'Asthma inhaler,asthma medication,bronchial dilator'
             8025 'Claritin, Claritin D' 8032 'Prilosec' 8035 'Prednisone'
             8052 'Bactrim, Septra' 8057 'Natacyn, Natamycin ophthalmic'
             8058 'Cough medicine/syrup; type unspecified'
             9981 'NEVER USED PAIN RELIEVERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assigned'
             9991 'NEVER USED PAIN RELIEVERS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   ANALNEWB  108 'Nembutal' 110 'Tuinal' 112 'Restoril, Temazepam'
             116 'Methaqualone, Quaalude, Sopor'
             120 'Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
             130 'Phenergan, Promethazine' 138 'Mandrakes' 186 'Butalbital'
             201 'Valium, Diazepam' 205 'Serax' 209 'Xanax, Alprazolam'
             211 'Buspar' 223 'Carbacot, Marbaxin, Methocarbamol, Robaxin'
             225 'Desyrel, Trazodone hydrochloride'
             234 'Cyclobenzaprine, Flexeril'
             240 'Lithium carbonate, Lithonate' 241 'Prozac'
             268 'Rohypnol, Roche, roofies' 283 'Paroxetine, Paxil'
             292 'Serzone' 301 'Dexedrine' 318 'Ritalin, Methylphenidate'
             335 'Dexatrim <OTC>' 356 'Dexies' 406 'Percodan' 407 'Demerol'
             409 'Tylenol with Codeine, Tylenol 3, Tylenol 4' 415 'Codeine'
             420 'OTHER Analgesic, NOT OTHERWISE SPECIFIED'
             421 'USED ANALGESIC, DON''T KNOW NAME' 422 'Motrin'
             425 'Advil <OTC>' 427 'Darvocet'
             430 'Aspirin, Ecotrin, Empirin <OTC>' 433 'Paregoric'
             434 'Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin'
             435 'Tylenol, Tylenol Extra-Strength <OTC>'
             438 'Anaprox, Naprosyn, Naproxen' 442 'Ibuprofen'
             458 'Mepergan, Mepergan Fortis, Meprozine'
             481 'Acular, Ketorolac tromethamine, Toradol' 496 'Ultram'
             858 'Antibiotic' 894 'Depakene, Depakote, Valproic Acid'
             900 'Not a drug' 2001 'Carisoprodol, Soma' 3023 'Adderall'
             4035 'Nabumetone, Relafin' 4044 'Hydrocodone' 4051 'Celebrex'
             4058 'Totem poles' 8002 'Zantac' 8043 'Accolate'
             8044 'Cephelaxin' 8051 'Sinex <OTC>'
             9981 'NEVER USED PAIN RELIEVERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assigned'
             9991 'NEVER USED PAIN RELIEVERS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   ANALNEWC  110 'Tuinal' 171 'NyQuil <OTC>' 174 'Ambien, Zolpidem'
             201 'Valium, Diazepam' 209 'Xanax, Alprazolam' 211 'Buspar'
             241 'Prozac' 271 'Zoloft' 318 'Ritalin, Methylphenidate'
             336 'Diet pills' 356 'Dexies' 407 'Demerol'
             409 'Tylenol with Codeine, Tylenol 3, Tylenol 4' 415 'Codeine'
             421 'USED ANALGESIC, DON''T KNOW NAME' 423 'Percocet'
             425 'Advil <OTC>' 430 'Aspirin, Ecotrin, Empirin <OTC>'
             434 'Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin'
             442 'Ibuprofen' 2001 'Carisoprodol, Soma' 4027 'Rorer'
             4059 'Zomig, Zolmitriptan' 8020 'Allegra'
             9981 'NEVER USED PAIN RELIEVERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assigned'
             9991 'NEVER USED PAIN RELIEVERS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   ANALNEWD  109 'Seconal' 110 'Tuinal' 115 'Phenobarbital' 137 '7-14'
             234 'Cyclobenzaprine, Flexeril' 268 'Rohypnol, Roche, roofies'
             271 'Zoloft' 318 'Ritalin, Methylphenidate'
             409 'Tylenol with Codeine, Tylenol 3, Tylenol 4' 415 'Codeine'
             421 'USED ANALGESIC, DON''T KNOW NAME' 422 'Motrin'
             427 'Darvocet' 431 'Tylox' 442 'Ibuprofen'
             2001 'Carisoprodol, Soma'
             3015 'Fen-Phen (fenfluramine and phentermine)'
             3017 'Dayquil <OTC>' 4047 'Roxicet' 8025 'Claritin, Claritin D'
             9981 'NEVER USED PAIN RELIEVERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assigned'
             9991 'NEVER USED PAIN RELIEVERS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   ANALNEWE  112 'Restoril, Temazepam' 201 'Valium, Diazepam'
             207 'Ativan, Lorazapam' 240 'Lithium carbonate, Lithonate'
             415 'Codeine' 466 'Midol <OTC>' 658 'Special K, Ketamine'
             2001 'Carisoprodol, Soma' 4046 'Oxycodone'
             9981 'NEVER USED PAIN RELIEVERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED PAIN RELIEVERS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   ANALAGE   981 'NEVER USED PAIN RELIEVERS Logically assigned'
             985 'BAD DATA Logically assigned'
             991 'NEVER USED PAIN RELIEVERS' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' /
   ANALYFU   9981 'NEVER USED PAIN RELIEVERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED PAIN RELIEVERS' 9994 'DON''T KNOW'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   ANALMFU   1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   ANALREC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in lifetime LOG ASSN'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLYRTOT  981 'NEVER USED PAIN RELIEVERS Logically assigned'
             985 'BAD DATA Logically assigned'
             991 'NEVER USED PAIN RELIEVERS'
             993 'DID NOT USE PAIN RELIEVERS IN THE PAST 12 MOS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   PRTOTFG   98 'BLANK (NO ANSWER)' /
   PRFQFLG   1 'Trimmed to be consistent with mo/yr of 1st use'
             98 'BLANK (NO ANSWER)' /
   PRBSTWAY  1 'Prefer to answer in days per week'
             2 'Prefer to answer in days per month'
             3 'Prefer to answer in days per year'
             11 'Prefer to ans in days per wk LOG ASSN'
             12 'Prefer to ans in days per mo LOG ASSN'
             13 'Prefer to ans in days per yr LOG ASSN'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS IN PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   PRDAYPYR  981 'NEVER USED PAIN RELIEVERS Logically assigned'
             985 'BAD DATA Logically assigned'
             989 'LEGITIMATE SKIP Logically assigned'
             991 'NEVER USED PAIN RELIEVERS'
             993 'DID NOT USE PAIN RELIEVERS IN PAST 12 MOS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   PRDAYPMO  81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS IN PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   PRDAYPWK  81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS IN PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   KLONOPIN  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   XNAXATVN  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   VALMDIAZ  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNCARD   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ATARAX    1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   BUSPAR    1 'Response entered' 6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   EQUANIL   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   FLEXERIL  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   LIBRIUM   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   LIMBTROL  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   MEPROB    1 'Response entered' 6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   MILTOWN   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   ROHYPNOL  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SERAX     1 'Response entered' 6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SOMA      1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   TRANXENE  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   VISTAR    1 'Response entered' 6 'Response not entered'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   TRNOLST   1 'Yes' 2 'No' 4 'No LOGICALLY ASSIGNED'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNEWA    108 'Nembutal' 109 'Seconal' 110 'Tuinal' 113 'Halcion'
             115 'Phenobarbital' 116 'Methaqualone, Quaalude, Sopor'
             120 'Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
             129 'Reds' 131 'Haldol, Haloperidol' 174 'Ambien, Zolpidem'
             186 'Butalbital' 201 'Valium, Diazepam' 207 'Ativan, Lorazapam'
             209 'Xanax, Alprazolam' 216 'Atarax, Hydroxyzine'
             221 'OTHER Tranquilizer, NOT OTHERWISE SPECIFIED'
             222 'USED TRANQUILIZER, DON''T KNOW NAME'
             223 'Carbacot, Marbaxin, Methocarbamol, Robaxin' 224 'Triavil'
             225 'Desyrel, Trazodone hydrochloride' 227 'Thorazine'
             228 'Amitriptyline, Elavil' 232 'Mellaril'
             234 'Cyclobenzaprine, Flexeril'
             240 'Lithium carbonate, Lithonate' 241 'Prozac'
             268 'Rohypnol, Roche, roofies' 271 'Zoloft'
             283 'Paroxetine, Paxil' 289 'Olanzapine, Zyprexa' 290 'Skelaxin'
             318 'Ritalin, Methylphenidate' 351 'Cathinone, Q''at, Cat'
             408 'Dilaudid' 417 'Morphine, Roxanol'
             420 'OTHER Analgesic, NOT OTHERWISE SPECIFIED' 423 'Percocet'
             427 'Darvocet'
             434 'Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin'
             438 'Anaprox, Naprosyn, Naproxen' 658 'Special K, Ketamine'
             663 'Animal tranquilizer, horse tranquilizer' 847 'GHB, NSC'
             2001 'Carisoprodol, Soma' 2002 'Muscle Relaxers' 3023 'Adderall'
             4001 'Actron, Ketoprofen, Orudis, Oruvail' 4039 'Daypro'
             4049 'Headache power <OTC>' 8002 'Zantac'
             9981 'NEVER USED TRANQUILIZERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assigned'
             9991 'NEVER USED TRANQUILIZERS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   TRNEWB    109 'Seconal' 137 '7-14' 201 'Valium, Diazepam'
             202 'Librium, Chlordiazepoxide HCl' 209 'Xanax, Alprazolam'
             221 'OTHER Tranquilizer, NOT OTHERWISE SPECIFIED'
             222 'USED TRANQUILIZER, DON''T KNOW NAME'
             225 'Desyrel, Trazodone hydrochloride'
             268 'Rohypnol, Roche, roofies' 318 'Ritalin, Methylphenidate'
             415 'Codeine' 417 'Morphine, Roxanol'
             663 'Animal tranquilizer, horse tranquilizer'
             4049 'Headache power <OTC>'
             9981 'NEVER USED TRANQUILIZERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED TRANQUILIZERS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   TRNEWC    131 'Haldol, Haloperidol' 268 'Rohypnol, Roche, roofies'
             8009 'Allergy pills; type unspecified'
             9981 'NEVER USED TRANQUILIZERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED TRANQUILIZERS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   TRNEWD    435 'Tylenol, Tylenol Extra-Strength <OTC>'
             9981 'NEVER USED TRANQUILIZERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED TRANQUILIZERS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   TRNEWE    9981 'NEVER USED TRANQUILIZERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED TRANQUILIZERS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   TRANAGE   981 'NEVER USED TRANQUILIZERS Logically assigned'
             985 'BAD DATA Logically assigned' 991 'NEVER USED TRANQUILIZERS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   TRANYFU   9981 'NEVER USED TRANQUILIZERS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED TRANQUILIZERS' 9994 'DON''T KNOW'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   TRANMFU   1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   TRANREC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in lifetime LOG ASSN'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNYRTOT  981 'NEVER USED TRANQUILIZERS Logically assigned'
             985 'BAD DATA Logically assigned' 991 'NEVER USED TRANQUILIZERS'
             993 'DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   TRTOTFG   98 'BLANK (NO ANSWER)' /
   TRFQFLG   1 'Trimmed to be consistent with mo/yr of 1st use'
             98 'BLANK (NO ANSWER)' /
   TRBSTWAY  1 'Prefer to answer in days per week'
             2 'Prefer to answer in days per month'
             3 'Prefer to answer in days per year'
             11 'Prefer to ans in days per wk LOG ASSN'
             12 'Prefer to ans in days per mo LOG ASSN'
             13 'Prefer to ans in days per yr LOG ASSN'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRDAYPYR  981 'NEVER USED TRANQUILIZERS Logically assigned'
             985 'BAD DATA Logically assigned'
             989 'LEGITIMATE SKIP Logically assigned'
             991 'NEVER USED TRANQUILIZERS'
             993 'DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   TRDAYPMO  81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   TRDAYPWK  81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   METHDES   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   DIETPILS  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   RITMPHEN  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   STMCARD   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CYLERT    1 'Response entered' 6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   DEXED     1 'Response entered' 6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   DETAMP    1 'Response entered' 6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   DIDREX    1 'Response entered' 6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ESKAT     1 'Response entered' 6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   IONAMIN   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   MAZANOR   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   OBLA      1 'Response entered' 6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   PLEGINE   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   PRELUDIN  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SANOREX   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TENUATE   1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMNOLST  1 'Yes' 2 'No' 4 'No LOGICALLY ASSIGNED'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   STIMNEWA  115 'Phenobarbital' 116 'Methaqualone, Quaalude, Sopor'
             124 'Yellow jackets' 174 'Ambien, Zolpidem'
             207 'Ativan, Lorazapam' 209 'Xanax, Alprazolam'
             225 'Desyrel, Trazodone hydrochloride'
             240 'Lithium carbonate, Lithonate' 241 'Prozac'
             247 'Adapin, Doxepin, Sinequan' 268 'Rohypnol, Roche, roofies'
             271 'Zoloft' 283 'Paroxetine, Paxil' 302 'Dexamyl'
             304 'Benzedrine' 305 'Biphetamine' 307 'Tenuate, Diethylpropion'
             311 'Preludin' 313 'Adipex-P, Fastin, Phentermine'
             318 'Ritalin, Methylphenidate'
             322 'Methamphetamine ("ice" or "crank"), Meth'
             324 'Uppers; OTHER Stimulant, NOT OTHERWISE SPECIFIED'
             325 'USED STIMULANT, DON''T KNOW NAME' 326 'White cross'
             327 'Black beauties, Black beauty'
             329 'Bird''s eggs, Robin''s eggs, speckled eggs'
             330 'Blue birds, blue jays, blue robins, speckled bird'
             331 'Blancs, Whites' 332 'Ephedrine'
             334 'Crossroads, cross tops' 335 'Dexatrim <OTC>'
             336 'Diet pills' 344 'Bennies' 345 'Black Molly' 348 'Crystal'
             352 'Lemons' 355 'Crystal meth' 356 'Dexies'
             364 'Pseudoephedrine' 374 'Christmas tree(s)'
             387 'Pink football' 417 'Morphine, Roxanol'
             509 'Correction fluids, degreasers, cleaning fluids'
             635 'Ginseng seeds, ginseng weed' 806 'Crack, rock'
             897 'Synthroid, Levothyroxine' 3004 'Black cadillac'
             3015 'Fen-Phen (fenfluramine and phentermine)' 3023 'Adderall'
             3026 'Bupropion, Wellbutrin, Zyban' 3036 'Ripped fuel <OTC>'
             3049 'Truck drivers speed' 3050 'Mini Thins'
             3052 'Speed; otherwise unspecified' 3055 'Clenbuterol'
             3062 'Homemade Stimulants' 8012 'Coriciden <OTC>' 8026 'Powder'
             8048 'Theophylline'
             9981 'NEVER USED STIMULANTS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assigned'
             9991 'NEVER USED STIMULANTS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   STIMNEWB  137 '7-14' 271 'Zoloft' 301 'Dexedrine'
             318 'Ritalin, Methylphenidate'
             324 'Uppers; OTHER Stimulant, NOT OTHERWISE SPECIFIED'
             325 'USED STIMULANT, DON''T KNOW NAME' 326 'White cross'
             327 'Black beauties, Black beauty' 328 'Pink hearts'
             330 'Blue birds, blue jays, blue robins, speckled bird'
             332 'Ephedrine' 333 '357 Magnum, Magnum 44 <OTC>'
             334 'Crossroads, cross tops' 336 'Diet pills' 345 'Black Molly'
             374 'Christmas tree(s)' 614 'MDA, Methylenedioxy amphetamine'
             894 'Depakene, Depakote, Valproic Acid' 3023 'Adderall'
             3052 'Speed; otherwise unspecified' 3058 'Metabolift <OTC>'
             3067 'Spancap' 9981 'NEVER USED STIMULANTS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assigned'
             9991 'NEVER USED STIMULANTS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   STIMNEWC  124 'Yellow jackets'
             330 'Blue birds, blue jays, blue robins, speckled bird'
             334 'Crossroads, cross tops' 374 'Christmas tree(s)'
             3004 'Black cadillac' 3033 'Metabolife <OTC>'
             3047 'Sudafed <OTC>'
             9981 'NEVER USED STIMULANTS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assigned'
             9991 'NEVER USED STIMULANTS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   STIMNEWD  3056 'Xenadrine <OTC>'
             9981 'NEVER USED STIMULANTS Logically assigned'
             9985 'BAD DATA Logically assigned' 9991 'NEVER USED STIMULANTS'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   STIMNEWE  9981 'NEVER USED STIMULANTS Logically assigned'
             9985 'BAD DATA Logically assigned' 9991 'NEVER USED STIMULANTS'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   STIMAGE   981 'NEVER USED STIMULANTS Logically assigned'
             985 'BAD DATA Logically assigned' 991 'NEVER USED STIMULANTS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   STIMYFU   9981 'NEVER USED STIMULANTS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assn'
             9991 'NEVER USED STIMULANTS' 9994 'DON''T KNOW' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   STIMMFU   1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 81 'NEVER USED STIMULANTS Logically assigned'
             85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assn' 91 'NEVER USED STIMULANTS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   STIMREC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in lifetime LOG ASSN'
             11 'Used in the past 30 days LOGICALLY ASSIGNED'
             12 'Used >30 days ago but within pst 12 mos LOG ASSN'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STMYRTOT  981 'NEVER USED STIMULANTS Logically assigned'
             983 'DID NOT USE STIMULANTS PAST 12 MOS Log assn'
             985 'BAD DATA Logically assigned' 991 'NEVER USED STIMULANTS'
             993 'DID NOT USE STIMULANTS IN THE PAST 12 MOS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   STTOTFG   98 'BLANK (NO ANSWER)' /
   STFQFLG   1 'Trimmed to be consistent with mo/yr of 1st use'
             98 'BLANK (NO ANSWER)' /
   STBSTWAY  1 'Prefer to answer in days per week'
             2 'Prefer to answer in days per month'
             3 'Prefer to answer in days per year'
             11 'Prefer to ans in days per wk LOG ASSN'
             12 'Prefer to ans in days per mo LOG ASSN'
             13 'Prefer to ans in days per yr LOG ASSN'
             81 'NEVER USED STIMULANTS Logically assigned'
             83 'DID NOT USE STIMULANTS PAST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STDAYPYR  981 'NEVER USED STIMULANTS Logically assigned'
             983 'DID NOT USE STIMULANTS PAST 12 MOS Log assn'
             989 'LEGITIMATE SKIP Logically assigned'
             991 'NEVER USED STIMULANTS'
             993 'DID NOT USE STIMULANTS IN THE PAST 12 MOS'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   STDAYPMO  81 'NEVER USED STIMULANTS Logically assigned'
             83 'DID NOT USE STIMULANTS PAST 12 MOS Log assn'
             85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STDAYPWK  81 'NEVER USED STIMULANTS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   METHAGE   981 'NEVER USED METHAMPHETAMINES Logically assigned'
             985 'BAD DATA Logically assigned'
             991 'NEVER USED METHAMPHETAMINES' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   METHYFU   9981 'NEVER USED METHAMPHETAMINES Logically assigned'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED METHAMPHETAMINES' 9994 'DON''T KNOW'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   METHMFU   1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December'
             81 'NEVER USED METHAMPHETAMINES Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED METHAMPHETAMINES' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   METHREC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in lifetime LOG ASSN'
             81 'NEVER USED METHAMPHETAMINES Logically assigned'
             91 'NEVER USED METHAMPHETAMINES' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   METHAQ    1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   NEMBBARB  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RESTTMAZ  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SEDCARD   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   AMYTAL    1 'Response entered' 6 'Response not entered'
             81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   BUTISOL   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   CHHYD     1 'Response entered' 6 'Response not entered'
             81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   DALMANE   1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   HALCION   1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   PHENOBAR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   PLACIDYL  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   TUINAL    1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SEDNOLST  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SEDNEWA   105 'Placidyl' 110 'Tuinal' 111 'Dalmane, Flurazepam'
             113 'Halcion' 115 'Phenobarbital'
             116 'Methaqualone, Quaalude, Sopor'
             120 'Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
             121 'USED SEDATIVE, DON''T KNOW NAME' 129 'Reds' 138 'Mandrakes'
             146 'Bentyl, Dicyclomine' 174 'Ambien, Zolpidem' 188 'Estazolam'
             201 'Valium, Diazepam' 225 'Desyrel, Trazodone hydrochloride'
             228 'Amitriptyline, Elavil' 246 'Clonazepam, Klonopin, Rivotril'
             247 'Adapin, Doxepin, Sinequan' 268 'Rohypnol, Roche, roofies'
             271 'Zoloft' 283 'Paroxetine, Paxil' 295 'Mirtazapine, Remeron'
             355 'Crystal meth' 457 'T''s and blues'
             658 'Special K, Ketamine' 802 'THC, cannabinol, marinol'
             2001 'Carisoprodol, Soma' 4044 'Hydrocodone'
             8010 'Zyrtec, cetirizine' 8049 'Sorbitol'
             9981 'NEVER USED SEDATIVES Logically assigned'
             9985 'BAD DATA Logically assigned' 9991 'NEVER USED SEDATIVES'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   SEDNEWB   120 'Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
             121 'USED SEDATIVE, DON''T KNOW NAME' 174 'Ambien, Zolpidem'
             225 'Desyrel, Trazodone hydrochloride'
             9981 'NEVER USED SEDATIVES Logically assigned'
             9985 'BAD DATA Logically assigned' 9991 'NEVER USED SEDATIVES'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   SEDNEWC   174 'Ambien, Zolpidem'
             9981 'NEVER USED SEDATIVES Logically assigned'
             9985 'BAD DATA Logically assigned' 9991 'NEVER USED SEDATIVES'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   SEDNEWD   174 'Ambien, Zolpidem'
             9981 'NEVER USED SEDATIVES Logically assigned'
             9985 'BAD DATA Logically assigned' 9991 'NEVER USED SEDATIVES'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   SEDNEWE   174 'Ambien, Zolpidem'
             9981 'NEVER USED SEDATIVES Logically assigned'
             9985 'BAD DATA Logically assigned' 9991 'NEVER USED SEDATIVES'
             9997 'REFUSED' 9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   SEDAGE    981 'NEVER USED SEDATIVES Logically assigned'
             985 'BAD DATA Logically assigned' 991 'NEVER USED SEDATIVES'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   SEDYFU    9981 'NEVER USED SEDATIVES Logically assigned'
             9985 'BAD DATA Logically assigned' 9991 'NEVER USED SEDATIVES'
             9994 'DON''T KNOW' 9997 'REFUSED' 9998 'BLANK (NO ANSWER)'
             9999 'LEGITIMATE SKIP' /
   SEDMFU    1 'January' 2 'February' 3 'March' 4 'April' 5 'May' 6 'June'
             7 'July' 8 'August' 9 'September' 10 'October' 11 'November'
             12 'December' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SEDREC    1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             8 'Used at some point in the past 12 mos LOG ASSN'
             9 'Used at some point in lifetime LOG ASSN'
             81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SEDYRTOT  981 'NEVER USED SEDATIVES Logically assigned'
             985 'BAD DATA Logically assigned' 991 'NEVER USED SEDATIVES'
             993 'DID NOT USE SEDATIVES IN THE PAST 12 MOS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   SVTOTFG   98 'BLANK (NO ANSWER)' /
   SVFQFLG   1 'Trimmed to be consistent with mo/yr of 1st use'
             98 'BLANK (NO ANSWER)' /
   SVBSTWAY  1 'Prefer to answer in days per week'
             2 'Prefer to answer in days per month'
             3 'Prefer to answer in days per year'
             12 'Prefer to ans in days per mo LOG ASSN'
             13 'Prefer to ans in days per yr LOG ASSN'
             81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SVDAYPYR  981 'NEVER USED SEDATIVES Logically assigned'
             985 'BAD DATA Logically assigned'
             989 'LEGITIMATE SKIP Logically assigned'
             991 'NEVER USED SEDATIVES'
             993 'DID NOT USE SEDATIVES IN THE PAST 12 MOS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   SVDAYPMO  81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SVDAYPWK  81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES IN THE PAST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   IRCIGRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago but within the past 3 yrs'
             4 'More than 3 years ago' 9 'Never smoked cigarettes' /
   IICIGRC   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2CIGRC  1 'Questionnaire data' 2 'Logically imputed data'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8'
             6 'Statistically imputed data - edited recency=19'
             7 'Statistically imputed data - edited recency=14' /
   IRCGRRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago but within the past 3 yrs'
             4 'More than 3 years ago' 9 'Never smoked cigars' /
   IICGRRC   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2CGRRC  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8'
             6 'Statistically imputed data - edited recency=19'
             7 'Statistically imputed data - edited recency=14' /
   IRPIPLF   1 'Ever used pipes' 9 'Never smoked pipes' /
   IIPIPLF   1 'Questionnaire data' 3 'Statistically imputed data' /
   IRPIPMN   1 'Within the past 30 days'
             2 'More than 30 days ago but within lifetime'
             9 'Never smoked pipes' /
   IIPIPMN   1 'Questionnaire data' 3 'Statistically imputed data' /
   IRSLTRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago but within the past 3 yrs'
             4 'More than 3 years ago' 9 'Never used smokeless tobacco' /
   IISLTRC   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2SLTRC  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8'
             6 'Statistically imputed data - edited recency=19'
             7 'Statistically imputed data - edited recency=14' /
   IRCHWRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago but within the past 3 yrs'
             4 'More than 3 years ago' 9 'Never used chewing tobacco' /
   IICHWRC   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2CHWRC  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8'
             6 'Statistically imputed data - edited recency=19'
             7 'Statistically imputed data - edited recency=14' /
   IRSNFRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago but within the past 3 yrs'
             4 'More than 3 years ago' 9 'Never used snuff' /
   IISNFRC   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2SNFRC  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8'
             6 'Statistically imputed data - edited recency=19'
             7 'Statistically imputed data - edited recency=14' /
   IRALCRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used alcohol' /
   IIALCRC   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2ALCRC  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRMJRC    1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used marijuana' /
   IIMJRC    1 'Questionnaire data' 3 'Statistically imputed data' /
   II2MJRC   1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRCOCRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used cocaine' /
   IICOCRC   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2COCRC  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRCRKRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used crack' /
   IICRKRC   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2CRKRC  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRHERRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used heroin' /
   IIHERRC   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2HERRC  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRHALRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used hallucinogens' /
   IIHALRC   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2HALRC  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRLSDRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used LSD' /
   IILSDRC   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2LSDRC  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRPCPRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used PCP' /
   IIPCPRC   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2PCPRC  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRINHRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used inhalants' /
   IIINHRC   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2INHRC  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRANLRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used pain relievers' /
   IIANLRC   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2ANLRC  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRTRNRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used tranquilizers' /
   IITRNRC   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2TRNRC  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRSTMRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used stimulants' /
   IISTMRC   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2STMRC  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRMTHRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used methamphetamines' /
   IIMTHRC   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2MTHRC  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRSEDRC   1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 9 'Never used sedatives' /
   IISEDRC   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2SEDRC  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - edited recency=9'
             5 'Statistically imputed data - edited recency=8' /
   IRALCFY   991 'NEVER USED ALCOHOL' 993 'DID NOT USE ALCOHOL PAST YEAR' /
   IIALCFY   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2ALCFY  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRMJFY    991 'NEVER USED MARIJUANA' 993 'DID NOT USE MARIJUANA PAST YEAR'
             /
   IIMJFY    1 'Questionnaire data' 3 'Statistically imputed data' /
   II2MJFY   1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRCOCFY   991 'NEVER USED COCAINE' 993 'DID NOT USE COCAINE PAST YEAR' /
   IICOCFY   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2COCFY  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRCRKFY   991 'NEVER USED CRACK' 993 'DID NOT USE CRACK PAST YEAR' /
   IICRKFY   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2CRKFY  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRHERFY   991 'NEVER USED HEROIN' 993 'DID NOT USE HEROIN PAST YEAR' /
   IIHERFY   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2HERFY  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRHALFY   991 'NEVER USED HALLUCINOGENS'
             993 'DID NOT USE HALLUCINOGENS PAST YEAR' /
   IIHALFY   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2HALFY  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRINHFY   991 'NEVER USED INHALANTS' 993 'DID NOT USE INHALANTS PAST YEAR'
             /
   IIINHFY   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2INHFY  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRANLFY   991 'NEVER USED PAIN RELIEVER'
             993 'DID NOT USE PAIN RELIEVER PAST YEAR' /
   IIANLFY   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2ANLFY  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRTRNFY   991 'NEVER USED TRANQUILIZERS'
             993 'DID NOT USE TRANQUILIZERS PAST YEAR' /
   IITRNFY   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2TRNFY  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRSTMFY   991 'NEVER USED STIMULANTS'
             993 'DID NOT USE STIMULANTS PAST YEAR' /
   IISTMFY   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2STMFY  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRSEDFY   991 'NEVER USED SEDATIVES' 993 'DID NOT USE SEDATIVES PAST YEAR'
             /
   IISEDFY   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2SEDFY  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRCIGFM   91.00 'NEVER USED' 93.00 'DID NOT USE CIGARETTES PAST MONTH' /
   IICIGFM   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2CIGFM  1 'Questionnaire data' 2 'Logically imputed data'
             4 'Statistically imputed data - lifetime use known' /
   IRCGRFM   91.00 'NEVER SMOKED CIGARS'
             93.00 'DID NOT SMOKE CIGARS PAST MONTH' /
   IICGRFM   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2CGRFM  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRCHWFM   91.00 'NEVER USED CHEWING TOBACCO'
             93.00 'DID NOT USE CHEWING TOBACCO PAST MONTH' /
   IICHWFM   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2CHWFM  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRSNFFM   91.00 'NEVER USED SNUFF' 93.00 'DID NOT USE SNUFF PAST MONTH' /
   IISNFFM   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2SNFFM  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRALCFM   91.00 'NEVER USED ALCOHOL'
             93.00 'DID NOT USE ALCOHOL PAST MONTH' /
   IIALCFM   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2ALCFM  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRALCD5   91 'NEVER USED ALCOHOL'
             93 'DID NOT HAVE 5+ ALC DRNKS PAST MONTH' /
   IIALCD5   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2ALCD5  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRMJFM    91.00 'NEVER USED MARIJUANA'
             93.00 'DID NOT USE MARIJUANA PAST MONTH' /
   IIMJFM    1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2MJFM   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRCOCFM   91.00 'NEVER USED COCAINE'
             93.00 'DID NOT USE COCAINE PAST MONTH' /
   IICOCFM   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2COCFM  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRCRKFM   91.00 'NEVER USED CRACK' 93.00 'DID NOT USE CRACK PAST MONTH' /
   IICRKFM   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2CRKFM  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRHERFM   91 'NEVER USED HEROIN' 93 'DID NOT USE HEROIN PAST MONTH' /
   IIHERFM   1 'Questionnaire data' 3 'Statistically imputed data' /
   II2HERFM  1 'Questionnaire data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRHALFM   91.00 'NEVER USED HALLUCINOGENS'
             93.00 'DID NOT USE HALLUCINOGENS PAST MONTH' /
   IIHALFM   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2HALFM  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRINHFM   91.00 'NEVER USED INHALANTS'
             93.00 'DID NOT USE INHALANTS PAST MONTH' /
   IIINHFM   1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   II2INHFM  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data - lifetime use imputed'
             4 'Statistically imputed data - lifetime use known' /
   IRCIGAGE  991 'NEVER USED' /
   IICIGAGE  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRCIGYFU  9999 'NEVER USED' /
   IICIGYFU  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRCDUAGE  991 'Never Used' 993 'Never a daily user' /
   IICDUAGE  1 'Questionnaire Data' 3 'Statistically imputed data' /
   IRCDUYFU  9993 'NEVER A DAILY USER' 9999 'NEVER USED' /
   IICDUYFU  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRCGRAGE  991 'NEVER USED' /
   IICGRAGE  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRCGRYFU  9999 'NEVER USED' /
   IICGRYFU  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRSNFAGE  991 'Never Used' /
   IISNFAGE  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRSNFYFU  9999 'NEVER USED' /
   IISNFYFU  1 'Questionnaire Data' 3 'Statistical Imputation' /
   IRCHWAGE  991 'NEVER USED' /
   IICHWAGE  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRCHWYFU  9999 'Never Used' /
   IICHWYFU  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRSLTAGE  991 'Never Used' /
   IISLTAGE  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRSLTYFU  9999 'Never Used' /
   IISLTYFU  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRALCAGE  991 'Never Used' /
   IIALCAGE  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRALCYFU  9999 'NEVER USED' /
   IIALCYFU  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRMJAGE   991 'Never Used' /
   IIMJAGE   1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRMJYFU   9999 'Never Used' /
   IIMJYFU   1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRCOCAGE  991 'Never Used' /
   IICOCAGE  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRCOCYFU  9999 'Never Used' /
   IICOCYFU  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRCRKAGE  991 'Never Used' /
   IICRKAGE  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically Imputed Data' /
   IRCRKYFU  9999 'Never Used' /
   IICRKYFU  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRHERAGE  991 'Never Used' /
   IIHERAGE  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRHERYFU  9999 'Never Used' /
   IIHERYFU  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRHALAGE  991 'Never Used' /
   IIHALAGE  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRHALYFU  9999 'Never Used' /
   IIHALYFU  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRLSDAGE  991 'Never Used' /
   IILSDAGE  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically imputed data' /
   IRLSDYFU  9999 'NEVER USED' /
   IILSDYFU  1 'Questionnaire Data' 3 'Statistically imputed data' /
   IRPCPAGE  991 'Never Used' /
   IIPCPAGE  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically imputed data' /
   IRPCPYFU  9999 'NEVER USED' /
   IIPCPYFU  1 'Questionnaire Data' 3 'Statistically imputed data' /
   IRINHAGE  991 'Never Used' /
   IIINHAGE  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRINHYFU  9999 'Never Used' /
   IIINHYFU  1 'Questionnaire Data' 3 'Statistically Imputed Data' /
   IRANLAGE  991 'Never Used' /
   IIANLAGE  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically Imputed Data' /
   IRANLYFU  9999 'Never Used' /
   IIANLYFU  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically Imputed Data' /
   IRTRNAGE  991 'Never Used' /
   IITRNAGE  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically Imputed Data' /
   IRTRNYFU  9999 'Never Used' /
   IITRNYFU  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically Imputed Data' /
   IRSTMAGE  991 'Never Used' /
   IISTMAGE  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically Imputed Data' /
   IRSTMYFU  9999 'Never Used' /
   IISTMYFU  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically Imputed Data' /
   IRMTHAGE  991 'Never Used' /
   IIMTHAGE  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically Imputed Data' /
   IRMTHYFU  9999 'Never Used' /
   IIMTHYFU  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically Imputed Data' /
   IRSEDAGE  991 'Never Used' /
   IISEDAGE  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically Imputed Data' /
   IRSEDYFU  9999 'Never Used' /
   IISEDYFU  1 'Questionnaire Data' 2 'Logical Edited Data'
             3 'Statistically Imputed Data' /
   CIGFLAG   0 'Never used (IRCIGRC = 9)' 1 'Ever used (IRCIGRC = 1-4)' /
   CIGYR     0 'Did not use in the past year (IRCIGRC = 3,4,9)'
             1 'Used within the past year (IRCIGRC = 1,2)' /
   CIGMON    0 'Did not use in the past month (IRCIGRC = 2-4,9)'
             1 'Used within the past month (IRCIGRC = 1)' /
   CGRFLAG   0 'Never used (IRCGRRC = 9)' 1 'Ever used (IRCGRRC = 1-4)' /
   CGRYR     0 'Did not use in the past year (IRCGRRC = 3,4,9)'
             1 'Used within the past year (IRCGRRC = 1,2)' /
   CGRMON    0 'Did not use in the past month (IRCGRRC = 2-4,9)'
             1 'Used within the past month (IRCGRRC = 1)' /
   PIPFLAG   0 'Never Used (IRPIPLF=9)' 1 'Ever Used (IRPIPLF=1)' /
   PIPMON    0 'Did not use in the past month (IRPIPMN=2,9)'
             1 'Used within the past month (IRPIPMN=1)' /
   SMKFLAG   0 'Never used (IRSLTRC = 9)' 1 'Ever used (IRSLTRC = 1-4)' /
   SMKYR     0 'Did not use in the past year (IRSLTRC = 3,4,9)'
             1 'Used within the past year (IRSLTRC = 1,2)' /
   SMKMON    0 'Did not use in the past month (IRSLTRC = 2-4,9)'
             1 'Used within the past month (IRSLTRC = 1)' /
   CHWFLAG   0 'Never Used (IRCHWRC=9)' 1 'Ever Used (IRCHWRC=1-4)' /
   CHWYR     0 'Did not use in the past year (IRCHWRC=3,4,9)'
             1 'Used within the past year (IRCHWRC=1,2)' /
   CHWMON    0 'Did not use in the past month (IRCHWRC=2-4,9)'
             1 'Used within the past month (IRCHWRC=1)' /
   SNFFLAG   0 'Never used (IRSNFRC = 9)' 1 'Ever used (IRSNFRC = 1-4)' /
   SNFYR     0 'Did not use in the past year (IRSNFRC = 3,4,9)'
             1 'Used within the past year (IRSNFRC = 1,2)' /
   SNFMON    0 'Did not use in the past month (IRSNFRC = 2-4,9)'
             1 'Used within the past month (IRSNFRC = 1)' /
   TOBFLAG   0 'Never Used (all source vars=9)'
             1 'Ever Used (any source var=1-4)' /
   TOBYR     0 'Never use pst yr(IRPIPMN=2,9 &oth src vars=3,4,9)'
             1 'Used pst yr(IRPIPMN=1 or any oth src var=1,2)' /
   TOBMON    0 'Did not use in pst month (all source vars=2-4,9)'
             1 'Used in past month (any source var=1)' /
   CIGBRND2  -9 'Not Past Month Cigarette User (CIGMON=0)'
             1 'Marlboro (CIG30BR2=112)' 2 'Newport (CIG30BR2=118)'
             3 'Camel (CIG30BR2=104)' 4 'Basic (CIG30BR2=101)'
             5 'Doral (CIG30BR2=107)' 6 'Winston (CIG30BR2=126)'
             7 'GPC (CIG30BR2=109)' 8 'Virginia Slims (CIG30BR2=125)'
             9 'Kool (CIG30BR2=111)' 10 'Salem (CIG30BR2=122)'
             11 'Benson & Hedges (CIG30BR2=102)' 12 'Merit (CIG30BR2=113)'
             13 'Misty (CIG30BR2=114)' 14 'Capri (CIG30BR2=105)'
             15 'Parliament (CIG30BR2=120)' 16 'Carlton (CIG30BR2=106)'
             17 'Other Brnd (CIG30BR2=other 100-199,1001-1999)'
             18 'Unkwn Brnd (CIG30BR2=200-999,4039,4999,9000-9998)' /
   CGRBRND2  -9 'Not Past Month Cigar User (CGRMON=0)'
             1 'Black and Mild (CGR30BR2 = 404)'
             2 'Swisher Sweets (CGR30BR2 = 423)'
             3 'Macanudos (CGR30BR2 = 416)' 4 'Phillies (CGR30BR2 = 419)'
             5 'Garcia Y Vega (CGR30BR2 = 411)'
             6 'Backwoods (CGR30BR2 = 402)' 7 'Havatampa (CGR30BR2 = 412)'
             8 'Dutch Masters (CGR30BR2 = 408)' 9 'Cohiba (CGR30BR2 = 443)'
             10 'King Edward (CGR30BR2 = 413)'
             11 'Antonio Y Cleopatra (CGR30BR2 = 401)'
             12 'Partagas (CGR30BR2 = 418)'
             13 'Romeo & Julieta (CGR30BR2 = 496)'
             14 'White Owl (CGR30BR2 = 426)'
             15 'Arturo Fuentes (CGR30BR2 = 431)'
             16 'Other Brnd (CGR30BR2 =other 400-499,4000-4999)'
             17 'Unkwn Brnd (CGR30BR2=<399,701,1020,1077,9000-9998)' /
   SMKBRND2  -9 'Not Past Month Smokeless Tobacco User (SMKMON=0)'
             1 'Skoal (SLT30BR2=308)' 2 'Copenhagen (SLT30BR2=301)'
             3 'Red Man (SLT30BR2=208)' 4 'Kodiak (SLT30BR2=305)'
             5 'Beech-Nut (SLT30BR2=201)' 6 'Levi Garrett (SLT30BR2=206)'
             7 'Timber Wolf (SLT30BR2=309)' 8 'Red Seal (SLT30BR2=316)'
             9 'Silver Creek (SLT30BR2=307)'
             10 'Other Brand (SLT30BR2=other 200-399,2999-3999)'
             11 'Unkwn Brnd (SLT30BR2=<200,400-899,5999,9000-9998)' /
   CIGCMPNY  1 'Philip Morris' 2 'R.J. Reynolds' 3 'Lorillard'
             4 'Brown and Williamson' 5 'Liggett' 6 'Commonwealth Brands'
             7 'Santa Fe Natural Tobacco Company'
             70 'SOME OTHER BRAND/COMPANY'
             80 'CIG BRAND/COMPANY NOT SPECIFIED'
             85 'BAD DATA Log assn (CIG30BR2=9985)'
             90 'NOT A CIGARETTE BRAND' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
             94 'DON''T KNOW (CIG30BR2=9994)' 97 'REFUSED (CIG30BR2=9997)'
             98 'BLANK (CIG30BR2=9998)' /
   ALCFLAG   0 'Never used (IRALCRC = 9)' 1 'Ever used (IRALCRC = 1-3)' /
   ALCYR     0 'Did not use in the past year (IRALCRC = 3,9)'
             1 'Used within the past year (IRALCRC = 1,2)' /
   ALCMON    0 'Did not use in the past month (IRALCRC = 2-3,9)'
             1 'Used within the past month (IRALCRC = 1)' /
   MRJFLAG   0 'Never used (IRMJRC = 9)' 1 'Ever used (IRMJRC = 1-3)' /
   MRJYR     0 'Did not use in the past year (IRMJRC = 3,9)'
             1 'Used within the past year (IRMJRC = 1,2)' /
   MRJMON    0 'Did not use in the past month (IRMJRC = 2-3,9)'
             1 'Used within the past month (IRMJRC = 1)' /
   COCFLAG   0 'Never used (IRCOCRC = 9)' 1 'Ever used (IRCOCRC = 1-3)' /
   COCYR     0 'Did not use in the past year (IRCOCRC = 3,9)'
             1 'Used within the past year (IRCOCRC = 1,2)' /
   COCMON    0 'Did not use in the past month (IRCOCRC = 2-3,9)'
             1 'Used within the past month (IRCOCRC = 1)' /
   CRKFLAG   0 'Never used (IRCRKRC = 9)' 1 'Ever used (IRCRKRC = 1-3)' /
   CRKYR     0 'Did not use in the past year (IRCRKRC = 3,9)'
             1 'Used within the past year (IRCRKRC = 1,2)' /
   CRKMON    0 'Did not use in the past month (IRCRKRC = 2-3,9)'
             1 'Used within the past month (IRCRKRC = 1)' /
   HERFLAG   0 'Never used (IRHERRC = 9)' 1 'Ever used (IRHERRC = 1-3)' /
   HERYR     0 'Did not use in the past year (IRHERRC = 3,9)'
             1 'Used within the past year (IRHERRC = 1,2)' /
   HERMON    0 'Did not use in the past month (IRHERRC = 2-3,9)'
             1 'Used within the past month (IRHERRC = 1)' /
   HALFLAG   0 'Never used (IRHALRC = 9)' 1 'Ever used (IRHALRC = 1-3)' /
   HALYR     0 'Did not use in the past year (IRHALRC = 3,9)'
             1 'Used within the past year (IRHALRC = 1,2)' /
   HALMON    0 'Did not use in the past month (IRHALRC = 2-3,9)'
             1 'Used within the past month (IRHALRC = 1)' /
   LSDFLAG   0 'Never used (IRLSDRC = 9)' 1 'Ever used (IRLSDRC = 1-3)' /
   LSDYR     0 'Did not use in the past year (IRLSDRC = 3,9)'
             1 'Used within the past year (IRLSDRC = 1,2)' /
   LSDMON    0 'Did not use in the past month (IRLSDRC = 2-3,9)'
             1 'Used within the past month (IRLSDRC = 1)' /
   PCPFLAG   0 'Never used (IRPCPRC = 9)' 1 'Ever used (IRPCPRC = 1-3)' /
   PCPYR     0 'Did not use in the past year (IRPCPRC = 3,9)'
             1 'Used within the past year (IRPCPRC = 1,2)' /
   PCPMON    0 'Did not use in the past month (IRPCPRC = 2-3,9)'
             1 'Used within the past month (IRPCPRC = 1)' /
   INHFLAG   0 'Never used (IRINHRC = 9)' 1 'Ever used (IRINHRC = 1-3)' /
   INHYR     0 'Did not use in the past year (IRINHRC = 3,9)'
             1 'Used within the past year (IRINHRC = 1,2)' /
   INHMON    0 'Did not use in the past month (IRINHRC = 2-3,9)'
             1 'Used within the past month (IRINHRC = 1)' /
   ANLFLAG   0 'Never used (IRANLRC = 9)' 1 'Ever used (IRANLRC = 1-3)' /
   ANLYR     0 'Did not use in the past year (IRANLRC = 3,9)'
             1 'Used within the past year (IRANLRC = 1,2)' /
   ANLMON    0 'Did not use in the past month (IRANLRC = 2-3,9)'
             1 'Used within the past month (IRANLRC = 1)' /
   TRQFLAG   0 'Never used (IRTRNRC = 9)' 1 'Ever used (IRTRNRC = 1-3)' /
   TRQYR     0 'Did not use in the past year (IRTRNRC = 3,9)'
             1 'Used within the past year (IRTRNRC = 1,2)' /
   TRQMON    0 'Did not use in the past month (IRTRNRC = 2-3,9)'
             1 'Used within the past month (IRTRNRC = 1)' /
   STMFLAG   0 'Never used (IRSTMRC = 9)' 1 'Ever used (IRSTMRC = 1-3)' /
   STMYR     0 'Did not use in the past year (IRSTMRC = 3,9)'
             1 'Used within the past year (IRSTMRC = 1,2)' /
   STMMON    0 'Did not use in the past month (IRSTMRC = 2-3,9)'
             1 'Used within the past month (IRSTMRC = 1)' /
   MTHFLAG   0 'Never Used (IRMTHRC=9)' 1 'Ever Used (IRMTHRC=1-3)' /
   MTHYR     0 'Did not use in the past year (IRMTHRC=3,9)'
             1 'Used within the past year (IRMTHRC=1,2)' /
   MTHMON    0 'Did not use in the past month (IRMTHRC=2-3,9)'
             1 'Used within the past month (IRMTHRC=1)' /
   SEDFLAG   0 'Never used (IRSEDRC = 9)' 1 'Ever used (IRSEDRC = 1-3)' /
   SEDYR     0 'Did not use in the past year (IRSEDRC = 3,9)'
             1 'Used within the past year (IRSEDRC = 1,2)' /
   SEDMON    0 'Did not use in the past month (IRSEDRC = 2-3,9)'
             1 'Used within the past month (IRSEDRC = 1)' /
   PSYFLAG2  0 'Never used (ALL SOURCE VARIABLES = 9)'
             1 'Ever used (ANY SOURCE VARIABLE < 9)' /
   PSYYR2    0 'Did not use within past year (ALL SOURCE VARS > 2)'
             1 'Used in past year (ANY SOURCE VARIABLE < 3)' /
   PSYMON2   0 'Did not use in past month (ALL SOURCE VARS > 1)'
             1 'Used in past month (ANY SOURCE VARIABLE = 1)' /
   SUMFLAG   0 'Never used (ALL SOURCE VARIABLES = 0)'
             1 'Ever used (ANY SOURCE VARIABLE = 1)' /
   SUMYR     0 'Did not use in past year (ALL SOURCE VARS =0)'
             1 'Used in past year (ANY SOURCE VARIABLE = 1)' /
   SUMMON    0 'Did not use in past month (ALL SOURCE VARS = 0)'
             1 'Used in past month (ANY SOURCE VARIABLE = 1)' /
   MJOFLAG   0 'Never used MJ/has used both MJ & anothr illct drug'
             1 'Marijuana is only (illicit) drug ever used' /
   MJOYR2    0 'MJ not used past yr/Used MJ & othr drug past yr'
             1 'Marijuana is only (illicit) drug in past year' /
   MJOMON2   0 'MJ not used past mnth/Used MJ & othr drug past mo'
             1 'Marijuana only (illicit) drug in past month' /
   IEMFLAG   0 'Never used drug/used only marijuana'
             1 'Illicit drug except for marijuana are ever used' /
   IEMYR     0 'Never used drug/used only marijuana past year'
             1 'Illicit drug except for marijuana used past year' /
   IEMMON    0 'Never used drug/used only marijuana past month'
             1 'Illicit drug except for marijuana used past month' /
   BINGEDRK  0 'Never/No "Binge" alcohol use (IRALCD5 = 0)'
             1 '"Binge" alcohol use (IRALCD5 = 1-30)' /
   HVYDRK2   0 'Never/No heavy alcohol use (IRALCD5 = 0-4)'
             1 'Heavy alcohol use (IRALCD5 = 5-30)' /
   BINGEHVY  1 'Heavy Alcohol Use (HVYDRK2=1)'
             2 '"Binge" But Not Heavy Use (BINGEDRK=1 & HVYDRK2=0)'
             3 'Past Month But Not "Binge" (ALCMON=1 & BINGEDRK=0)'
             4 'Did Not Use Alcohol in Pst Month (All source=0)' /
   PEYOTE2   0 'No/Unknown (PEYOTE=2,85,91,94,97)' 1 'Yes (PEYOTE=1)' /
   MESC2     0 'No/Unknown (MESC=2,85,91,94,97)' 1 'Yes (MESC=1)' /
   PSILCY2   0 'No/Unknown (PSILCY=2,85,91,94,97)' 1 'Yes (PSILCY=1,3)' /
   ECSTASY2  0 'No/Unknown (ECSTASY=2,85,91,94,97)' 1 'Yes (ECSTASY=1)' /
   AMYLNIT2  0 'No/Unknown (AMYLNIT=2,91,94,97)' 1 'Yes (AMYLNIT=1,3)' /
   CLEFLU2   0 'No/Unknown (CLEFLU=2,91,94,97)' 1 'Yes (CLEFLU=1,3)' /
   GAS2      0 'No/Unknown (GAS=2,91,94,97)' 1 'Yes (GAS=1,3)' /
   GLUE2     0 'No/Unknown (GLUE=2,91,94,97)' 1 'Yes (GLUE=1,3)' /
   ETHER2    0 'No/Unknown (ETHER=2,91,94,97)' 1 'Yes (ETHER=1)' /
   SOLVENT2  0 'No/Unknown (SOLVENT=2,91,94,97,98)' 1 'Yes (SOLVENT=1,3)' /
   LGAS2     0 'No/Unknown (LGAS=2,91,94,97,98)' 1 'Yes (LGAS=1,3)' /
   NITOXID2  0 'No/Unknown (NITOXID=2,91,94,97,98)' 1 'Yes (NITOXID=1,3)' /
   SPPAINT2  0 'No/Unknown (SPPAINT=2,91,94,97,98)' 1 'Yes (SPPAINT=1)' /
   AEROS2    0 'No/Unknown (AEROS=2,91,94,97,98)' 1 'Yes (AEROS=1,3)' /
   DARVTYL2  0 'No/Unknown (DARVTYLC=2,81,85,91,94,97,98)'
             1 'Yes (DARVTYLC=1,3)' /
   PERCTYL2  0 'No/Unknown (PERCTYLX=2,81,85,91,94,97,98)'
             1 'Yes (PERCTYLX=1,3)' /
   VICOLOR2  0 'No/Unknown (VICOLOR=2,81,85,91,94,97,98)'
             1 'Yes (VICOLOR=1,3)' /
   CODEINE2  0 'No/Unknown (CODEINE=6,81,85,91,94,97,98,99)'
             1 'Yes (CODEINE=1,3)' /
   DEMEROL2  0 'No/Unknown (DEMEROL=6,81,85,91,94,97,98,99)'
             1 'Yes (DEMEROL=1,3)' /
   DILAUD2   0 'No/Unknown (DILAUD=6,81,85,91,94,97,98,99)'
             1 'Yes (DILAUD = 1,3)' /
   FIORICT2  0 'No/Unknown (FIORICET=6,81,85,91,94,97,98,99)'
             1 'Yes (FIORICET=1)' /
   FIORINL2  0 'No/Unknown (FIORINAL= 6,81,85,91,94,97,98,99)'
             1 'Yes (FIORINAL=1,3)' /
   HYDROCD2  0 'No/Unknown (HYDROCOD= 6,81,85,91,94,97,98,99)'
             1 'Yes (HYDROCOD=1,3)' /
   METHDON2  0 'No/Unknown (METHDON=6,81,85,91,94,97,98,99)'
             1 'Yes (METHDON = 1,3)' /
   MORPHIN2  0 'No/Unknown (MORPHINE=6,81,85,91,94,97,98,99)'
             1 'Yes (MORPHINE = 1,3)' /
   OXYCONT2  0 'No/Unknown (OXYCONTN=6,81,85,91,94,97,98,99)'
             1 'Yes (OXYCONTN = 1,3)' /
   PHENCOD2  0 'No/Unknown (PHENCOD=6,81,85,91,94,97,98,99)'
             1 'Yes (PHENCOD = 1,3)' /
   PROPOXY2  0 'No/Unknown (PROPOXY=6,81,85,91,94,97,98,99)'
             1 'Yes (PROPOXY = 1)' /
   SK65A2    0 'No/Unknown (SK65A=6,81,85,91,94,97,98,99)'
             1 'Yes (SK65A = 1)' /
   STADOL2   0 'No/Unknown (STADOL=6,81,85,91,94,97,98,99)'
             1 'Yes (STADOL = 1)' /
   TALACEN2  0 'No/Unknown (TALACEN=6,81,85,91,94,97,98,99)'
             1 'Yes (TALACEN = 1)' /
   TALWIN2   0 'No/Unknown (TALWIN=6,81,85,91,94,97,98,99)'
             1 'Yes (TALWIN = 1)' /
   TALWINX2  0 'No/Unknown (TALWINNX=6,81,85,91,94,97,98,99)'
             1 'Yes (TALWINNX = 1,3)' /
   TRAMADL2  0 'No/Unknown (TRAMADOL=6,81,85,91,94,97,98,99)'
             1 'Yes (TRAMADOL = 1)' /
   ULTRAM2   0 'No/Unknown (ULTRAM=6,81,85,91,94,97,98,99)'
             1 'Yes (ULTRAM = 1,3)' /
   OTHANL    0 'No/Unknwn (ANLCARD/ANLNOLST=2,4,81,85,91,94,97,98)'
             1 'Yes (ANLCARD or ANLNOLST = 1,3)' /
   KLONOPI2  0 'No/Unknown (KLONOPIN=2,81,85,91,94,97,98)'
             1 'Yes (KLONOPIN=1)' /
   XNAXATV2  0 'No/Unknown (XNAXATVN=2,81,85,91,94,97,98)'
             1 'Yes (XNAXATVN=1,3)' /
   VALMDIA2  0 'No/Unknown (VALMDIAZ=2,81,85,91,94,97,98)'
             1 'Yes (VALMDIAZ=1,3)' /
   ATARAX2   0 'No/Unknown (ATARAX=6,81,85,91,94,97,98,99)'
             1 'Yes (ATARAX = 1,3)' /
   BUSPAR2   0 'No/Unknown (BUSPAR=6,81,85,91,94,97,98,99)'
             1 'Yes (BUSPAR = 1)' /
   EQUANIL2  0 'No/Unknown (EQUANIL=6,81,85,91,94,97,98,99)'
             1 'Yes (EQUANIL = 1,3)' /
   FLEXERL2  0 'No/Unknown (FLEXERIL=6,81,85,91,94,97,98,99)'
             1 'Yes (FLEXERIL = 1,3)' /
   LIBRIUM2  0 'No/Unknown (LIBRIUM=6,81,85,91,94,97,98,99)'
             1 'Yes (LIBRIUM = 1)' /
   LIMBTRL2  0 'No/Unknown (LIMBTROL=6,81,85,91,94,97,98,99)'
             1 'Yes (LIMBTROL = 1)' /
   MEPROB2   0 'No/Unknown (MEPROB=6,81,91,94,97,98,99)' 1 'Yes (MEPROB = 1)'
             /
   MILTOWN2  0 'No/Unknown (MILTOWN=6,81,91,94,97,98,99)'
             1 'Yes (MILTOWN = 1)' /
   ROHYPNL2  0 'No/Unknown (ROHYPNOL=6,81,85,91,94,97,98,99)'
             1 'Yes (ROHYPNOL = 1,3)' /
   SERAX2    0 'No/Unknown (SERAX=6,81,85,91,94,97,98,99)'
             1 'Yes (SERAX = 1)' /
   SOMA2     0 'No/Unknown (SOMA=6,81,85,91,94,97,98,99)'
             1 'Yes (SOMA = 1,3)' /
   TRANXEN2  0 'No/Unknown (TRANXENE=6,81,85,91,94,97,98,99)'
             1 'Yes (TRANXENE = 1)' /
   VISTAR2   0 'No/Unknown (VISTAR=6,81,85,91,94,97,98,99)'
             1 'Yes (VISTAR = 1)' /
   OTHTRN    0 'No/Unknwn (TRNCARD/TRNNOLST=2,4,81,85,91,94,97,98)'
             1 'Yes (TRNCARD or TRNNOLST = 1,3)' /
   METHDES2  0 'No/Unknown (METHDES=2,81,85,91,94,97,98)'
             1 'Yes (METHDES=1,3)' /
   DIETPIL2  0 'No/Unknown (DIETPILS=2,81,85,91,94,97,98)'
             1 'Yes (DIETPILS=1,3)' /
   RITMPHE2  0 'No/Unknown (RITMPHEN=2,81,85,91,94,97,98)'
             1 'Yes (RITMPHEN=1,3)' /
   CYLERT2   0 'No/ Unknown (CYLERT=6,81,85,91,94,97,98,99)'
             1 'Yes (CYLERT = 1,3)' /
   DEXED2    0 'No/ Unknown (DEXED=6,81,85,91,94,97,98,99)'
             1 'Yes (DEXED = 1)' /
   DETAMP2   0 'No/ Unknown (DETAMP=6,81,85,91,94,97,98,99)'
             1 'Yes (DETAMP = 1)' /
   DIDREX2   0 'No/ Unknown (DIDREX=6,81,85,91,94,97,98,99)'
             1 'Yes (DIDREX = 1,3)' /
   ESKAT2    0 'No/ Unknown (ESKAT=6,81,85,91,94,97,98,99)'
             1 'Yes (ESKAT = 1,3)' /
   IONAMIN2  0 'No/ Unknown (IONAMIN=6,81,85,91,94,97,98,99)'
             1 'Yes (IONAMIN = 1)' /
   MAZANOR2  0 'No/Unknown (MAZANOR=6,81,85,91,94,97,98,99)'
             1 'Yes (MAZANOR = 1)' /
   OBLA2     0 'No/Unknown (OBLA=6,81,85,91,94,97,98,99)' 1 'Yes (OBLA = 1)'
             /
   PLEGINE2  0 'No/Unknown (PLEGINE=6,81,85,91,94,97,98,99)'
             1 'Yes (PLEGINE = 1)' /
   PRELUDN2  0 'No/Unknown (PRELUDIN=6,81,85,91,94,97,98,99)'
             1 'Yes (PRELUDIN = 1,3)' /
   SANOREX2  0 'No/ Unknown (SANOREX=6,81,85,91,94,97,98,99)'
             1 'Yes (SANOREX = 1)' /
   TENUATE2  0 'No/ Unknown (TENUATE=6,81,85,91,94,97,98,99)'
             1 'Yes (TENUATE = 1,3)' /
   OTHSTM    0 'No/Unknwn (STMCARD/STMNOLST=2,4,81,85,91,94,97,98)'
             1 'Yes (STMCARD or STMNOLST = 1,3)' /
   METHAQ2   0 'No/Unknown (METHAQ=2,81,85,91,94,97,98)' 1 'Yes (METHAQ=1)' /
   NEMBBAR2  0 'No/Unknown (NEMBBARB=2,81,85,91,94,97,98)'
             1 'Yes (NEMBBARB=1)' /
   RESTTMA2  0 'No/Unknown (RESTTMAZ=2,81,85,91,94,97,98)'
             1 'Yes (RESTTMAZ=1)' /
   AMYTAL2   0 'No/Unknown (AMYTAL=6,81,85,91,94,97,98,99)'
             1 'Yes (AMYTAL= 1)' /
   BUTISOL2  0 'No/Unknown (BUTISOL=6,81,85,91,94,97,98,99)'
             1 'Yes (BUTISOL= 1)' /
   CHHYD2    0 'No/Unknown (CHHYD=6,81,85,91,94,97,98,99)' 1 'Yes (CHHYD= 1)'
             /
   DALMANE2  0 'No/Unknown (DALMANE=6,81,85,91,94,97,98,99)'
             1 'Yes (DALMANE=1,3)' /
   HALCION2  0 'No/Unknown (HALCION=6,81,85,91,94,97,98,99)'
             1 'Yes (HALCION=1,3)' /
   PHENOBR2  0 'No/Unknown (PHENOBAR=6,81,85,91,94,97,98,99)'
             1 'Yes (PHENOBAR=1,3)' /
   PLACIDY2  0 'No/Unknown (PLACIDYL=6,81,85,91,94,97,98,99)'
             1 'Yes (PLACIDYL= 1,3)' /
   TUINAL2   0 'No/Unknown (TUINAL=6,81,85,91,94,97,98,99)'
             1 'Yes (TUINAL=1,3)' /
   OTHSED    0 'No/Unknwn (SEDCARD/SEDNOLST=2,4,81,85,91,94,97,98)'
             1 'Yes (SEDCARD or SEDNOLST = 1,3)' /
   ALCAFU    1 '14 Years or Younger (IRALCAGE=1-14)'
             2 '15-17 Years Old (IRALCAGE=15-17)'
             3 '18 Years or Older (IRALCAGE=18+)'
             4 'Non Users (IRALCAGE = 991)' /
   MJAFU     1 '14 Years or Younger (IRMJAGE=1-14)'
             2 '15-17 Years Old (IRMJAGE=15-17)'
             3 '18 Years or Older (IRMJAGE=18+)'
             4 'Non Users (IRMJAGE = 991)' /
   COCAFU    1 '14 Years or Younger (IRCOCAGE=1-14)'
             2 '15-17 Years Old (IRCOCAGE=15-17)'
             3 '18 Years or Older (IRCOCAGE=18+)'
             4 'Non Users (IRCOCAGE = 991)' /
   HERAFU    1 '14 Years or Younger (IRHERAGE=1-14)'
             2 '15-17 Years Old (IRHERAGE=15-17)'
             3 '18 Years or Older (IRHERAGE=18+)'
             4 'Non Users (IRHERAGE = 991)' /
   HALAFU    1 '14 Years or Younger (IRHALAGE=1-14)'
             2 '15-17 Years Old (IRHALAGE=15-17)'
             3 '18 Years or Older (IRHALAGE=18+)'
             4 'Non Users (IRHALAGE = 991)' /
   INHAFU    1 '14 Years or Younger (IRINHAGE=1-14)'
             2 '15-17 Years Old (IRINHAGE=15-17)'
             3 '18 Years or Older (IRINHAGE=18+)'
             4 'Non Users (IRINHAGE = 991)' /
   ANLAFU    1 '14 Years or Younger (IRANLAGE=1-14)'
             2 '15-17 Years Old (IRANLAGE=15-17)'
             3 '18 Years or Older (IRANLAGE=18+)'
             4 'Non Users (IRANLAGE = 991)' /
   TRNAFU    1 '14 Years or Younger (IRTRNAGE=1-14)'
             2 '15-17 Years Old (IRTRNAGE=15-17)'
             3 '18 Years or Older (IRTRNAGE=18+)'
             4 'Non Users (IRTRNAGE = 991)' /
   STMAFU    1 '14 Years or Younger (IRSTMAGE=1-14)'
             2 '15-17 Years Old (IRSTMAGE=15-17)'
             3 '18 Years or Older (IRSTMAGE=18+)'
             4 'Non Users (IRSTMAGE = 991)' /
   SEDAFU    1 '14 Years or Younger (IRSEDAGE=1-14)'
             2 '15-17 Years Old (IRSEDAGE=15-17)'
             3 '18 Years or Older (IRSEDAGE=18+)'
             4 'Non Users (IRSEDAGE = 991)' /
   CIGAFU    1 '14 Years or Younger (IRCIGAGE=1-14)'
             2 '15-17 Years Old (IRCIGAGE=15-17)'
             3 '18 Years or Older (IRCIGAGE=18+)'
             4 'Non Users (IRCIGAGE = 991)' /
   CGRAFU    1 '14 Years or Younger (IRCGRAGE=1-14)'
             2 '15-17 Years Old (IRCGRAGE=15-17)'
             3 '18 Years or Older (IRCGRAGE=18+)'
             4 'Non Users (IRCGRAGE = 991)' /
   SLTAFU    1 '14 Years or Younger (IRSLTAGE=1-14)'
             2 '15-17 Years Old (IRSLTAGE=15-17)'
             3 '18 Years or Older (IRSLTAGE=18+)'
             4 'Non Users (IRSLTAGE = 991)' /
   MRJYDAYS  1 '1-11 Days (IRMJFY=1-11)' 2 '12-49 Days (IRMJFY=12-49)'
             3 '50-99 Days (IRMJFY=50-99)' 4 '100-299 Days (IRMJFY=100-299)'
             5 '300-365 Days (IRMJFY=300-365)'
             6 'No Past Year Use (IRMJFY=991,993)' /
   COCYDAYS  1 '1-11 Days (IRCOCFY=1-11)' 2 '12-49 Days (IRCOCFY=12-49)'
             3 '50-99 Days (IRCOCFY=50-99)'
             4 '100-299 Days (IRCOCFY=100-299)'
             5 '300-365 Days (IRCOCFY=300-365)'
             6 'No Past Year Use (IRCOCFY=991,993)' /
   HALYDAYS  1 '1-11 Days (IRHALFY=1-11)' 2 '12-49 Days (IRHALFY=12-49)'
             3 '50-99 Days (IRHALFY=50-99)'
             4 '100-299 Days (IRHALFY=100-299)'
             5 '300-365 Days (IRHALFY=300-365)'
             6 'No Past Year Use (IRHALFY=991,993)' /
   INHYDAYS  1 '1-11 Days (IRINHFY=1-11)' 2 '12-49 Days (IRINHFY=12-49)'
             3 '50-99 Days (IRINHFY=50-99)'
             4 '100-299 Days (IRINHFY=100-299)'
             5 '300-365 Days (IRINHFY=300-365)'
             6 'No Past Year Use (IRINHFY=991,993)' /
   ALCYDAYS  1 '1-11 Days (IRALCFY=1-11)' 2 '12-49 Days (IRALCFY=12-49)'
             3 '50-99 Days (IRALCFY=50-99)'
             4 '100-299 Days (IRALCFY=100-299)'
             5 '300-365 Days (IRALCFY=300-365)'
             6 'No Past Year Use (IRALCFY=991,993)' /
   MRJMDAYS  1 '1-2 Days (IRMJFM=1-2)' 2 '3-5 Days (IRMJFM=3-5)'
             3 '6-19 Days (IRMJFM=6-19)' 4 '20-30 Days (IRMJFM=20-30)'
             5 'No Past Month Use (IRMJFM=91,93)' /
   COCMDAYS  1 '1-2 Days (IRCOCFM=1-2)' 2 '3-5 Days (IRCOCFM=3-5)'
             3 '6-19 Days (IRCOCFM=6-19)' 4 '20-30 Days (IRCOCFM=20-30)'
             5 'No Past Month Use (IRCOCFM=91,93)' /
   HALMDAYS  1 '1-2 Days (IRHALFM=1-2)' 2 '3-5 Days (IRHALFM=3-5)'
             3 '6-19 Days (IRHALFM=6-19)' 4 '20-30 Days (IRHALFM=20-30)'
             5 'No Past Month Use (IRHALFM=91,93)' /
   INHMDAYS  1 '1-2 Days (IRINHFM=1-2)' 2 '3-5 Days (IRINHFM=3-5)'
             3 '6-19 Days (IRINHFM=6-19)' 4 '20-30 Days (IRINHFM=20-30)'
             5 'No Past Month Use (IRINHFM=91,93)' /
   ALCMDAYS  1 '1-2 Days (IRALCFM=1-2)' 2 '3-5 Days (IRALCFM=3-5)'
             3 '6-19 Days (IRALCFM=6-19)' 4 '20-30 Days (IRALCFM=20-30)'
             5 'No Past Month Use (IRALCFM=91,93)' /
   CIGMDAYS  1 '1-2 Days (IRCIGFM=1,2)' 2 '3-5 Days (IRCIGFM=3-5)'
             3 '6-19 Days (IRCIGFM=6-19)' 4 '20-29 Days (IRCIGFM=20-29)'
             5 '30 Days (IRCIGFM=30)' 6 'No Past Month Use (IRCIGFM=91,93)' /
   CIGPDAY   1 'Fewer Than 6 (CIG30AV=1,2,3 AND IRCIGFM=30)'
             2 '6-15 (CIG30AV=4 AND IRCIGFM=30)'
             3 '16-25 (CIG30AV=5 AND IRCIGFM=30)'
             4 '26 or More (CIG30AV=6,7 AND IRCIGFM=30)'
             5 'Not Reported (CIG30AV=85,94,97,98 AND IRCIGFM=30)'
             6 'No Daily Use(CIG30AV=91,93 OR IRCIGFM=1-29,91,93)' /
   CG05      1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CG06      1 'More than 30 days ago but within the past 12 mos'
             2 'More than 12 months ago but within the past 3 yrs'
             3 'More than 3 years ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CG06DK    1 'More than 30 days ago but within the past 12 mos'
             2 'More than 12 months ago but within the past 3 yrs'
             3 'More than 3 years ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CG06RE    1 'More than 30 days ago but within the past 12 mos'
             2 'More than 12 months ago but within the past 3 yrs'
             3 'More than 3 years ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CG19      1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CG20      1 'More than 30 days ago but within the past 12 mos'
             2 'More than 12 months ago but within the past 3 yrs'
             3 'More than 3 years ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CG20DK    1 'More than 30 days ago but within the past 12 mos'
             2 'More than 12 months ago but within the past 3 yrs'
             3 'More than 3 years ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CG20RE    1 'More than 30 days ago but within the past 12 mos'
             3 'More than 3 years ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CG27      1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CG28      1 'More than 30 days ago but within the past 12 mos'
             2 'More than 12 months ago but within the past 3 yrs'
             3 'More than 3 years ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CG28DK    2 'More than 12 months ago but within the past 3 yrs'
             3 'More than 3 years ago' 94 'DON''T KNOW'
             98 'BLANK (NO ANSWER)' /
   CG28RE    94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CG36      1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CG37      1 'More than 30 days ago but within the past 12 mos'
             2 'More than 12 months ago but within the past 3 yrs'
             3 'More than 3 years ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CG37DK    1 'More than 30 days ago but within the past 12 mos'
             2 'More than 12 months ago but within the past 3 yrs'
             3 'More than 3 years ago' 94 'DON''T KNOW'
             98 'BLANK (NO ANSWER)' /
   CG37RE    1 'More than 30 days ago but within the past 12 mos'
             2 'More than 12 months ago but within the past 3 yrs'
             3 'More than 3 years ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CG43      1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             98 'BLANK (NO ANSWER)' /
   ALLAST3   1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALRECDK   1 'Within the past 30 days --that is, since DATEFILL'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW'
             98 'BLANK (NO ANSWER)' /
   ALRECRE   1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   TOTDRINK  985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   ALFRAME3  1 'Avg num of days per week during pst 12 mos'
             2 'Avg num of days per month during pst 12 mos'
             3 'Total number of days during the past 12 months'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   ALYRAVE   985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   ALMONAVE  85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   ALWKAVE   85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   MJLAST3   1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 month'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MJRECDK   1 'DATEFILL' 2 'More than 30 days ago but within the pst 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   MJRECRE   1 'DATEFILL' 2 'More than 30 days ago but within the pst 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   TOTMJ     985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   MJFRAME3  1 'Avg num of days per week during pst 12 mos'
             2 'Avg num of days per month during pst 12 mos'
             3 'Total number of days during the past 12 months'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   MJYRAVE   994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   MJMONAVE  85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   MJWKAVE   85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CCLAST3   1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 month'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CCRECDK   3 'More than 12 months ago' 94 'DON''T KNOW'
             98 'BLANK (NO ANSWER)' /
   CCRECRE   1 'DATEFILL' 2 'More than 30 days ago but within the pst 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   TOTCOKE   985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   CCFRAME3  1 'Avg num of days per week during pst 12 mos'
             2 'Avg num of days per month during pst 12 mos'
             3 'Total number of days during the past 12 months'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CCYRAVE   985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   CCMONAVE  94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CCWKAVE   94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CKLAST3   1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 month'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CKRECDK   1 'DATEFILL' 2 'More than 30 days ago but within the pst 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW'
             98 'BLANK (NO ANSWER)' /
   CKRECRE   97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TOTCRACK  994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   CKFRAME3  1 'Avg num of days per week during pst 12 mos'
             2 'Avg num of days per month during pst 12 mos'
             3 'Total number of days during the past 12 months'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CKYRAVE   994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   CKMONAVE  94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CKWKAVE   94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HELAST3   1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 month'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERECDK   2 'More than 30 days ago but within the pst 12 mos'
             94 'DON''T KNOW' 98 'BLANK (NO ANSWER)' /
   HERECRE   97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TOTHERO   998 'BLANK (NO ANSWER)' /
   HEFRAME3  1 'Avg num of days per week during pst 12 mos'
             2 'Avg num of days per month during pst 12 mos'
             3 'Total number of days during the past 12 months'
             94 'DON''T KNOW' 98 'BLANK (NO ANSWER)' /
   HEYRAVE   994 'DON''T KNOW' 998 'BLANK (NO ANSWER)' /
   HEMONAVE  94 'DON''T KNOW' 98 'BLANK (NO ANSWER)' /
   HEWKAVE   98 'BLANK (NO ANSWER)' /
   LSLAST    1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   LSRECDK   2 'More than 30 days ago but within the pst 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   LSRECRE   1 'Within the past 30 days -- that is, since[DATEFILL'
             2 'More than 30 days ago but within the pst 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   TOTHALL   985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   LSFRAME3  1 'Avg num of days per week during pst 12 mos'
             2 'Avg num of days per month during pst 12 mos'
             3 'Total number of days during the past 12 months'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   LSYRAVE   985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   LSMONAVE  94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   LSWKAVE   94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   LS10      1 'Within the past 30 days - that is, since DATEFILL'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   LS16      1 'Within the past 30 days -- that is, since DATEFILL'
             2 'More than 30 days ago but within the pst 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   INLAST    1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INRECDK   1 'Within the past 30 days -- that is, since DATEFILL'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   INRECRE   1 'Within the past 30 days -- that is, since DATEFILL'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   TOTINHAL  994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   INFRAME3  1 'Avg num of days per week during pst 12 mos'
             2 'Avg num of days per month during pst 12 mos'
             3 'Total number of days during the past 12 months'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INYRAVE   994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   INMONAVE  94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INWKAVE   94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   PR09      1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   PRRECDK   1 'Within the past 30 days -- that is, since DATEFILL'
             2 'More than 30 days ago but within the past 12 month'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   PRRECRE   1 'Within the past 30 days -- that is, since DATEFILL'
             2 'More than 30 days ago but within the past 12 month'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   PR10      1 'Avg num of days per week during pst 12 mos'
             2 'Avg num of days per month during pst 12 mos'
             3 'Total number of days during the past 12 months'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   PR11      985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   PR12      85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   PR13      85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   TR09      1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRRECDK   1 'Within the past 30 days -- that is, since DATEFILL'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRRECRE   2 'More than 30 days ago but within the past 12 mos'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   TR10      1 'Avg num of days per week during pst 12 mos'
             2 'Avg num of days per month during pst 12 mos'
             3 'Total number of days during the past 12 months'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   TR11      985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   TR12      85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   TR13      85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   ST09      1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   STRECDK   1 'Within the past 30 days -- that is, since DATEFILL'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   STRECRE   1 'Within the past 30 days -- that is, since DATEFILL'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   ST10      1 'Avg num of days per week during pst 12 mos'
             2 'Avg num of days per month during pst 12 mos'
             3 'Total number of days during the past 12 months'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ST11      994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   ST12      94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ST13      94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ST19      1 'Within the past 30 days - that is, since DATEFILL'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   SV09      1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SVRECDK   3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 98 'BLANK (NO ANSWER)' /
   SVRECRE   3 'More than 12 months ago' 85 'BAD DATA Logically assigned'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SV10      1 'Avg num of days per week during pst 12 mos'
             2 'Avg num of days per month during pst 12 mos'
             3 'Total number of days during the past 12 months'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   SV11      985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   SV12      85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   SV13      85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERSMOKE  1 'Yes' 2 'No' 91 'NEVER USED HEROIN' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HRSMKREC  1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 91 'NEVER USED HEROIN'
             93 'USED HEROIN BUT NEVER SMOKED IT' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERSNIFF  1 'Yes' 2 'No' 91 'NEVER USED HEROIN' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HRSNFREC  1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             9 'At some point in the lifetime LOG ASSN'
             91 'NEVER USED HEROIN' 93 'USED HEROIN BUT NEVER SNIFFED IT'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   GNNDLLIF  1 'Yes' 2 'No' 4 'No LOGICALLY ASSIGNED' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCNEEDL  1 'Yes' 2 'No' 91 'NEVER USED COCAINE' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP (GNNDLLIF = 2)' /
   CONDLREC  1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             9 'At some point in the lifetime LOG ASSN'
             91 'NEVER USED COCAINE'
             93 'USED COCAINE BUT NEVER WITH A NEEDLE' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP (GNNDLLIF = 2)' /
   HERNEEDL  1 'Yes' 2 'No' 91 'NEVER USED HEROIN' 97 'REFUSED'
             99 'LEGITIMATE SKIP (GNNDLLIF = 2)' /
   HRNDLREC  1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 91 'NEVER USED HEROIN'
             93 'USED HEROIN BUT NEVER WITH A NEEDLE' 97 'REFUSED'
             99 'LEGITIMATE SKIP (GNNDLLIF = 2)' /
   STNEEDLE  1 'Yes' 2 'No' 91 'NEVER USED STIMULANTS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (GNNDLLIF = 2)' /
   STNDLREC  1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago' 91 'NEVER USED STIMULANTS'
             93 'USED STIMULANTS BUT NEVER WITH A NEEDLE' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP (GNNDLLIF = 2)' /
   GNNDREUS  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (GNNDLLIF = 2)' /
   GNNDLSH1  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (GNNDLLIF = 2)' /
   GNNDCLEN  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (GNNDLLIF = 2)' /
   GNNDLSH2  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (GNNDLLIF = 2)' /
   GNNDGET2  1 'Bought the needle from a pharmacy'
             2 'Got the needle from a needle exchange'
             3 'Bought the needle on the street'
             4 'Got the needle in a shooting gallery'
             5 'Got the needle some other way'
             41 'Given by, stolen from a friend/acquaint of friend'
             42 'Given by, stolen from a relative'
             43 'Given by, stolen from someone, relation unspecifd'
             45 'Found it/got from a waste can'
             46 'Given by, stolen from medical facility/professionl'
             49 'Bought, given, stolen from place/location unspecd'
             54 'Shared needle with friends/other acquaintances'
             85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned (GNNDLLIF=4)'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (GNNDLLIF=2)' /
   NEDLRECC  1 'Within the past 30 days'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             9 'At some point in the lifetime LOG ASSN'
             91 'NEVER USED COC/HER/STM WITH A NEEDLE' 97 'REFUSED'
             98 'MISSING (BUT NOT REFUSED)' /
   NEDFLAG4  0 'Never used (GNNDLLIF=2,4,94,97,98)'
             1 'Ever Used (GNNDLLIF=1)' /
   HERSMOK2  0 'No/Unknown (HERSMOKE=2,91,97,98)' 1 'Yes (HERSMOKE=1)' /
   HERSNIF2  0 'No/Unknown (HERSNIFF=2,91,97,98)' 1 'Yes (HERSNIFF=1)' /
   NEDHER    0 'No (HERNEEDL=2,91,97,99)' 1 'Yes (HERNEEDL=1)' /
   NEDCOC    0 'No (COCNEEDL=2,91,97,98,99)' 1 'Yes (COCNEEDL=1)' /
   NEDSTM    0 'No (STNNEEDL=2,91,94,97,98,99)' 1 'Yes (STNNEEDL=1)' /
   RSKPKCIG  1 'No risk' 2 'Slight risk' 3 'Moderate risk' 4 'Great risk'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RSKMJOCC  1 'No risk' 2 'Slight risk' 3 'Moderate risk' 4 'Great risk'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RSKMJREG  1 'No risk' 2 'Slight risk' 3 'Moderate risk' 4 'Great risk'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RKTRYLSD  1 'No risk' 2 'Slight risk' 3 'Moderate risk' 4 'Great risk'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RKLSDREG  1 'No risk' 2 'Slight risk' 3 'Moderate risk' 4 'Great risk'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RKTRYHER  1 'No risk' 2 'Slight risk' 3 'Moderate risk' 4 'Great risk'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RKHERREG  1 'No risk' 2 'Slight risk' 3 'Moderate risk' 4 'Great risk'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RKCOCOCC  1 'No risk' 2 'Slight risk' 3 'Moderate risk' 4 'Great risk'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RKCOCREG  1 'No risk' 2 'Slight risk' 3 'Moderate risk' 4 'Great risk'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RK5ALDLY  1 'No risk' 2 'Slight risk' 3 'Moderate risk' 4 'Great risk'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RK5ALWK   1 'No risk' 2 'Slight risk' 3 'Moderate risk' 4 'Great risk'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RSKDIFMJ  1 'Probably impossible' 2 'Very difficult' 3 'Fairly difficult'
             4 'Fairly easy' 5 'Very easy' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   RKDIFLSD  1 'Probably impossible' 2 'Very difficult' 3 'Fairly difficult'
             4 'Fairly easy' 5 'Very easy' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   RKDIFCOC  1 'Probably impossible' 2 'Very difficult' 3 'Fairly difficult'
             4 'Fairly easy' 5 'Very easy' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   RKDIFCRK  1 'Probably impossible' 2 'Very difficult' 3 'Fairly difficult'
             4 'Fairly easy' 5 'Very easy' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   RKDIFHER  1 'Probably impossible' 2 'Very difficult' 3 'Fairly difficult'
             4 'Fairly easy' 5 'Very easy' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   RSKSELL   1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RKFQDNGR  1 'Never' 2 'Seldom' 3 'Sometimes' 4 'Always' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RKFQRSKY  1 'Never' 2 'Seldom' 3 'Sometimes' 4 'Always' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RKFQPBLT  1 'Never' 2 'Seldom' 3 'Sometimes' 4 'Always' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RKFQDBLT  1 'Never' 2 'Seldom' 3 'Sometimes' 4 'Always' 5 'I don''t drive'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   GRSKPKCG  -9 'Unknown (RSKPKCIG = 94,97,98)'
             0 'Otherwise (RSKPKCIG = 1,2,3)' 1 'Great Risk (RSKPKCIG = 4)' /
   GRSKCREG  -9 'Unknown (RKCOCREG = 94,97,98)'
             0 'Otherwise (RKCOCREG = 1,2,3)' 1 'Great Risk (RKCOCREG = 4)' /
   GRSKCOCC  -9 'Unknown (RKCOCOCC = 94,97,98)'
             0 'Otherwise (RKCOCOCC = 1,2,3)' 1 'Great Risk (RKCOCOCC = 4)' /
   GRSKMREG  -9 'Unknown (RSKMJREG = 94,97,98)'
             0 'Otherwise (RSKMJREG = 1,2,3)' 1 'Great Risk (RSKMJREG = 4)' /
   GRSKMOCC  -9 'Unknown (RSKMJOCC = 94,97,98)'
             0 'Otherwise (RSKMJOCC = 1,2,3)' 1 'Great Risk (RSKMJOCC = 4)' /
   GRSKHTRY  -9 'Unknown (RKTRYHER = 94,97,98)'
             0 'Otherwise (RKTRYHER = 1,2,3)' 1 'Great Risk (RKTRYHER = 4)' /
   GRSKHREG  -9 'Unknown (RKHERREG = 94,97,98)'
             0 'Otherwise (RKHERREG = 1,2,3)' 1 'Great Risk (RKHERREG = 4)' /
   GRSKLTRY  -9 'Unknown (RKTRYLSD = 94,97,98)'
             0 'Otherwise (RKTRYLSD = 1,2,3)' 1 'Great Risk (RKTRYLSD=4)' /
   GRSKLREG  -9 'Unknown (RKLSDREG = 94,97,98)'
             0 'Otherwise (RKLSDREG = 1,2,3)' 1 'Great Risk (RKLSDREG = 4)' /
   GRSKD4_5  -9 'Unknown (RK5ALDLY = 94,97,98)'
             0 'Otherwise (RK5ALDLY = 1,2,3)' 1 'Great Risk (RK5ALDLY = 4)' /
   GRSKD5WK  -9 'Unknown (RK5ALWK = 94,97,98)'
             0 'Otherwise (RK5ALWK = 1,2,3)' 1 'Great Risk (RK5ALWK = 4)' /
   RDIFMJ    -9 'Unknown (RSKDIFMJ = 94,97,98)'
             0 'Otherwise (RSKDIFMJ = 1,2,3)'
             1 'Fairly or very easy (RSKDIFMJ = 4,5)' /
   RDIFCOC   -9 'Unknown (RKDIFCOC = 94,97,98)'
             0 'Otherwise (RKDIFCOC = 1,2,3)'
             1 'Fairly or very easy (RKDIFCOC = 4,5)' /
   RDIFHER   -9 'Unknown (RKDIFHER = 94,97,98)'
             0 'Otherwise (RKDIFHER = 1,2,3)'
             1 'Fairly or very easy (RKDIFHER = 4,5)' /
   RDIFLSD   -9 'Unknown (RKDIFLSD = 94,97,98)'
             0 'Otherwise (RKDIFLSD = 1,2,3)'
             1 'Fairly or very easy (RKDIFLSD = 4,5)' /
   RDIFCRK   -9 'Unknown (RKDIFCRK = 94,97,98)'
             0 'Otherwise (RKDIFCRK = 1,2,3)'
             1 'Fairly or very easy (RKDIFCRK = 4,5)' /
   APPSELDG  -9 'Unknown (RSKSELL = 85,94,97,98)' 0 'No (RSKSELL = 2)'
             1 'Yes (RSKSELL = 1)' /
   CIGLOTTM  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CIGLIMIT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CIGKPLMT  1 'Usually kept to the limits set'
             2 'Often smoked more than intended'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGNDMOR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CIGLSEFX  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGCUTDN  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CIGCUTEV  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGCUT1X  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGWD4SX  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             90 'NOT ASKED THE QUESTION Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGWDSMT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             90 'NOT ASKED THE QUESTION Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGEMOPB  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CIGEMCTD  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGPHLPB  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGPHCTD  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGLSACT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   CIGPKCRT  1 'Pack' 2 'Carton' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGPDPAK  1 'Less than $1.00' 2 '$1.00 - $1.50' 3 '$1.51 - $2.00'
             4 '$2.01 - $2.50' 5 '$2.51 - $3.00' 6 '$3.01 - $3.50'
             7 '$3.51 - $4.00' 8 '$4.01 - $4.50' 9 '$4.51 - $5.00'
             10 'More than $5.00' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   CIGPDCRT  1 'Less than $10.00' 2 '$10.00 - $10.99' 3 '$11.00 - $11.99'
             4 '$12.00 - $12.99' 5 '$13.00 - $13.99' 6 '$14.00 - $14.99'
             7 '$15.00 - $15.99' 8 '$16.00 - $16.99' 9 '$17.00 - $17.99'
             10 '$18.00 - $18.99' 11 '$19.00 - $19.99' 12 '$20.00 - $20.99'
             13 '$21.00 - $21.99' 14 '$22.00 - $22.99' 15 '$23.00 or more'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCLOTTM  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALCGTOVR  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCLIMIT  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALCKPLMT  1 'Usually kept to the limits set'
             2 'Often drank more than intended'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCNDMOR  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALCLSEFX  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCCUTDN  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALCCUTEV  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCCUT1X  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCWD2SX  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCWDSMT  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCEMOPB  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALCEMCTD  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCPHLPB  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCPHCTD  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ALCLSACT  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALCSERPB  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALCPDANG  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALCLAWTR  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALCFMFPB  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ALCFMCTD  1 'Yes' 2 'No'
             83 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
             91 'NEVER USED ALCOHOL'
             93 'DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   MRJLOTTM  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MRJGTOVR  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   MRJLIMIT  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MRJKPLMT  1 'Usually kept to the limits set'
             2 'Often used more than intended'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   MRJNDMOR  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MRJLSEFX  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   MRJCUTDN  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MRJCUTEV  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   MRJEMOPB  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MRJEMCTD  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   MRJPHLPB  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   MRJPHCTD  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   MRJLSACT  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MRJSERPB  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MRJPDANG  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MRJLAWTR  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MRJFMFPB  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   MRJFMCTD  1 'Yes' 2 'No'
             83 'DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
             91 'NEVER USED MARIJUANA'
             93 'DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   COCLOTTM  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCGTOVR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   COCLIMIT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCKPLMT  1 'Usually kept to the limits set'
             2 'Often used more than intended' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   COCNDMOR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCLSEFX  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   COCCUTDN  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCCUTEV  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   COCCUT1X  1 'Yes' 2 'No' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   COCFLBLU  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   COCWD2SX  1 'Yes' 2 'No' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   COCWDSMT  1 'Yes' 2 'No' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   COCEMOPB  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCEMCTD  1 'Yes' 2 'No' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   COCPHLPB  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   COCPHCTD  1 'Yes' 2 'No' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   COCLSACT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCSERPB  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCPDANG  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCLAWTR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCFMFPB  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED COCAINE' 93 'DID NOT USE COCAINE PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   COCFMCTD  1 'Yes' 2 'No' 91 'NEVER USED COCAINE'
             93 'DID NOT USE COCAINE PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HERLOTTM  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERGTOVR  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HERLIMIT  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERKPLMT  1 'Usually kept to the limits set'
             2 'Often used more than intended' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HERNDMOR  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERLSEFX  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HERCUTDN  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERCUTEV  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HERCUT1X  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HERWD3SX  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HERWDSMT  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HEREMOPB  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HEREMCTD  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HERPHLPB  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HERPHCTD  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HERLSACT  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERSERPB  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERPDANG  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERLAWTR  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERFMFPB  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   HERFMCTD  1 'Yes' 2 'No' 91 'NEVER USED HEROIN'
             93 'DID NOT USE HEROIN PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HALLOTTM  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HALGTOVR  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HALLIMIT  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HALKPLMT  1 'Usually kept to the limits set'
             2 'Often used more than intended'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HALNDMOR  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HALLSEFX  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HALCUTDN  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HALCUTEV  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HALEMOPB  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HALEMCTD  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HALPHLPB  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HALPHCTD  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HALLSACT  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HALSERPB  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HALPDANG  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HALLAWTR  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HALFMFPB  1 'Yes' 2 'No'
             83 'DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
             85 'BAD DATA Logically assigned' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   HALFMCTD  1 'Yes' 2 'No' 91 'NEVER USED HALLUCINOGENS'
             93 'DID NOT USE HALLUCINOGENS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   INHLOTTM  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHGTOVR  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   INHLIMIT  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHKPLMT  1 'Usually kept to the limits set'
             2 'Often used more than intended' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   INHNDMOR  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHLSEFX  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   INHCUTDN  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHCUTEV  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   INHEMOPB  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHEMCTD  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   INHPHLPB  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   INHPHCTD  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   INHLSACT  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHSERPB  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHPDANG  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHLAWTR  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHFMFPB  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   INHFMCTD  1 'Yes' 2 'No' 91 'NEVER USED INHALANTS'
             93 'DID NOT USE INHALANTS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ANLLOTTM  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLGTOVR  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ANLLIMIT  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLKPLMT  1 'Usually kept to the limits set'
             2 'Often used more than intended'
             81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ANLNDMOR  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLLSEFX  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ANLCUTDN  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLCUTEV  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ANLCUT1X  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ANLWD3SX  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ANLWDSMT  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ANLEMOPB  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLEMCTD  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ANLPHLPB  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ANLPHCTD  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   ANLLSACT  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLSERPB  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLPDANG  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLLAWTR  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLFMFPB  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   ANLFMCTD  1 'Yes' 2 'No' 81 'NEVER USED PAIN RELIEVERS Logically assigned'
             91 'NEVER USED PAIN RELIEVERS'
             93 'DID NOT USE PAIN RELIEVERS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TRNLOTTM  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNGTOVR  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TRNLIMIT  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNKPLMT  1 'Usually kept to the limits set'
             2 'Often used more than intended'
             81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TRNNDMOR  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNLSEFX  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TRNCUTDN  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNCUTEV  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TRNEMOPB  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNEMCTD  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TRNPHLPB  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TRNPHCTD  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TRNLSACT  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNSERPB  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNPDANG  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNLAWTR  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNFMFPB  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TRNFMCTD  1 'Yes' 2 'No' 81 'NEVER USED TRANQUILIZERS Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED TRANQUILIZERS'
             93 'DID NOT USE TRANQUILIZERS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMLOTTM  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STMGTOVR  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMLIMIT  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STMKPLMT  1 'Usually kept to the limits set'
             2 'Often used more than intended'
             81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMNDMOR  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STMLSEFX  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMCUTDN  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STMCUTEV  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMCUT1X  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMFLBLU  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMWD2SX  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMWDSMT  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMEMOPB  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STMEMCTD  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMPHLPB  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMPHCTD  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   STMLSACT  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STMSERPB  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STMPDANG  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STMLAWTR  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STMFMFPB  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   STMFMCTD  1 'Yes' 2 'No' 81 'NEVER USED STIMULANTS Logically assigned'
             91 'NEVER USED STIMULANTS'
             93 'DID NOT USE STIMULANTS PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SEDLOTTM  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SEDGTOVR  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SEDLIMIT  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SEDKPLMT  1 'Usually kept to the limits set'
             2 'Often used more than intended'
             81 'NEVER USED SEDATIVES Logically assigned'
             91 'NEVER USED SEDATIVES' 93 'DID NOT USE SEDATIVES PST 12 MOS'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SEDNDMOR  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SEDLSEFX  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SEDCUTDN  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SEDCUTEV  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             91 'NEVER USED SEDATIVES' 93 'DID NOT USE SEDATIVES PST 12 MOS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SEDCUT1X  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SEDWD1SX  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             91 'NEVER USED SEDATIVES' 93 'DID NOT USE SEDATIVES PST 12 MOS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SEDWDSMT  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             91 'NEVER USED SEDATIVES' 93 'DID NOT USE SEDATIVES PST 12 MOS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SEDEMOPB  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SEDEMCTD  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             91 'NEVER USED SEDATIVES' 93 'DID NOT USE SEDATIVES PST 12 MOS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SEDPHLPB  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SEDPHCTD  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             91 'NEVER USED SEDATIVES' 93 'DID NOT USE SEDATIVES PST 12 MOS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SEDLSACT  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SEDSERPB  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   SEDPDANG  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   SEDLAWTR  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SEDFMFPB  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             85 'BAD DATA Logically assigned' 91 'NEVER USED SEDATIVES'
             93 'DID NOT USE SEDATIVES PST 12 MOS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   SEDFMCTD  1 'Yes' 2 'No' 81 'NEVER USED SEDATIVES Logically assigned'
             91 'NEVER USED SEDATIVES' 93 'DID NOT USE SEDATIVES PST 12 MOS'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   DEPNDALC  0 'No / Unknown (Otherwise)' 1 'Yes (See comment above)' /
   DEPNDANL  0 'No / Unknown (Otherwise)' 1 'Yes (See comment above)' /
   DEPNDCIG  0 'No / Unknown (Otherwise)' 1 'Yes (See comment above)' /
   DEPNDCOC  0 'No / Unknown (Otherwise)' 1 'Yes (See comment above)' /
   DEPNDHAL  0 'No / Unknown (Otherwise)' 1 'Yes (See comment above)' /
   DEPNDHER  0 'No / Unknown (Otherwise)' 1 'Yes (See comment above)' /
   DEPNDINH  0 'No / Unknown (Otherwise)' 1 'Yes (See comment above)' /
   DEPNDMRJ  0 'No / Unknown (Otherwise)' 1 'Yes (See comment above)' /
   DEPNDSED  0 'No / Unknown (Otherwise)' 1 'Yes (See comment above)' /
   DEPNDSTM  0 'No / Unknown (Otherwise)' 1 'Yes (See comment above)' /
   DEPNDTRN  0 'No / Unknown (Otherwise)' 1 'Yes (See comment above)' /
   DEPNDILL  0 'No / Unknown (Otherwise)'
             1 'Yes (Any source variable listed above=1)' /
   DEPNDIEM  0 'No / Unknown (Otherwise)'
             1 'Yes (any of the source variables=1)' /
   DEPNDXMJ  0 'No / Unknown (Otherwise)'
             1 'Yes (DEPNDMRJ=0 and any other source var=1)' /
   DEPNDPSY  0 'No / Unknown (Otherwise)'
             1 'Yes (DEPNDTRN, DEPNDANL, DEPNDSTM, OR DEPNDSED=1)' /
   DPILLALC  0 'No / Unknown (DEPNDILL=0 and DEPNDALC=0)'
             1 'Yes (DEPNDILL=1 or DEPNDALC=1)' /
   DPILANAL  0 'No / Unknown (DEPNDILL=0 or DEPNDALC=0)'
             1 'Yes (DEPNDILL=1 and DEPNDALC=1)' /
   ABUSEALC  0 'No / Unknown (Otherwise)'
             1 'Yes (Any one of above criteria and DEPNDALC=0)' /
   ABUSEANL  0 'No / Unknown (Otherwise)'
             1 'Yes (Any one of above criteria and DEPNDANL=0)' /
   ABUSECOC  0 'No / Unknown (Otherwise)'
             1 'Yes (Any one of above criteria and DEPNDCOC=0)' /
   ABUSEHAL  0 'No / Unknown (Otherwise)'
             1 'Yes (Any one of above criteria and DEPNDHAL=0)' /
   ABUSEHER  0 'No / Unknown (Otherwise)'
             1 'Yes (Any one of above criteria and DEPNDHER=0)' /
   ABUSEINH  0 'No / Unknown (Otherwise)'
             1 'Yes (Any one of above criteria and DEPNDINH=0)' /
   ABUSEMRJ  0 'No / Unknown (Otherwise)'
             1 'Yes (Any one of above criteria and DEPNDMRJ=0)' /
   ABUSESED  0 'No / Unknown (Otherwise)'
             1 'Yes (Any one of above criteria and DEPNDSED=0)' /
   ABUSESTM  0 'No / Unknown (Otherwise)'
             1 'Yes (Any one of above criteria and DEPNDSTM=0)' /
   ABUSETRN  0 'No / Unknown (Otherwise)'
             1 'Yes (Any one of above criteria and DEPNDTRN=0)' /
   ABUSEILL  0 'No / Unknown (Otherwise)'
             1 'Yes (Any source variable above =1 & DEPNDILL=0)' /
   ABUSEIEM  0 'No / Unknown (Otherwise)'
             1 'Yes (Any above source var=1 & DEPNDIEM=0)' /
   ABUSEXMJ  0 'No / Unknown (Otherwise)'
             1 'Yes (Any above var=1 & ABUSEMRJ=0 & DEPNDXMJ=0)' /
   ABUSEPSY  0 'No / Unknown (Otherwise)'
             1 'Yes (Any source variable above & DEPNDPSY=0)' /
   ABILLALC  0 'No / Unknown (ABUSEILL=0 AND ABUSEALC=0)'
             1 'Yes (ABUSEILL=1 or ABUSEALC=1)' /
   ABILANAL  0 'No / Unknown (Otherwise)'
             1 'Yes (ABUSEILL=1 & ABUSEALC=1 & DPILLALC=0)' /
   ABODALC   0 'No / Unknown (ABUSEALC=0 and DEPNDALC=0)'
             1 'Yes (ABUSEALC=1 or DEPNDALC=1)' /
   ABODANL   0 'No / Unknown (ABUSEANL=0 and DEPNDANL=0)'
             1 'Yes (ABUSEANL=1 or DEPNDANL=1)' /
   ABODCOC   0 'No / Unknown (ABUSECOC=0 and DEPNDCOC=0)'
             1 'Yes (ABUSECOC=1 or DEPNDCOC=1)' /
   ABODHAL   0 'No / Unknown (ABUSEHAL=0 and DEPNDHAL=0)'
             1 'Yes (ABUSEHAL=1 or DEPNDHAL=1)' /
   ABODHER   0 'No / Unknown (ABUSEHER=0 and DEPNDHER=0)'
             1 'Yes (ABUSEHER=1 or DEPNDHER=1)' /
   ABODINH   0 'No / Unknown (ABUSEINH=0 and DEPNDINH=0)'
             1 'Yes (ABUSEINH=1 or DEPNDINH=1)' /
   ABODMRJ   0 'No / Unknown (ABUSEMRJ=0 and DEPNDMRJ=0)'
             1 'Yes (ABUSEMRJ=1 or DEPNDMRJ=1)' /
   ABODSED   0 'No / Unknown (ABUSESED=0 and DEPNDSED=0)'
             1 'Yes (ABUSESED=1 or DEPNDSED=1)' /
   ABODSTM   0 'No / Unknown (ABUSESTM=0 and DEPNDSTM=0)'
             1 'Yes (ABUSESTM=1 or DEPNDSTM=1)' /
   ABODTRN   0 'No / Unknown (ABUSETRN=0 and DEPNDTRN=0)'
             1 'Yes (ABUSETRN=1 or DEPNDTRN=1)' /
   ABODILL   0 'No / Unknown (ABUSEILL=0 and DEPNDILL=0)'
             1 'Yes (ABUSEILL=1 or DEPNDILL=1)' /
   ABODPSY   0 'No / Unknown (ABUSEPSY=0 and DEPNDPSY=0)'
             1 'Yes (ABUSEPSY=1 or DEPNDPSY=1)' /
   ABODILAL  0 'No / Unknown (ABILLALC=0 and DPILLALC=0)'
             1 'Yes (ABILLALC=1 or DPILLALC=1)' /
   ABDILAAL  0 'No / Unknown (ABODILL=0 or ABODALC=0)'
             1 'Yes (ABODILL=1 and ABODALC=1)' /
   BOOKED    1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   NOBOOKY2  0 'None' 1 'One time' 2 'Two times' 3 'Three or more times'
             985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP (BOOKED=2)' /
   BKMVTHFT  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKLARCNY  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKBURGL   1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKAGASLT  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKSMASLT  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKROB     1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKRAPE    1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKMURDER  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKARSON   1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKDRVINF  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKDRUNK   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKPOSTOB  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKDRUG    1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKPROS    1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKSEXOFF  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKFRAUD   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKOTH     1 'Yes' 2 'No' 5 'Offense unknown'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   BKOTHOF2  1 'Larceny or theft' 2 'Burglary or breaking and entering'
             4 'Other assault, such as simple assault or battery'
             5 'Motor vehicle theft' 6 'Robbery'
             10 'Driving under the influence'
             11 'Drunkenness or other liquor law violation'
             13 'Prostitution or commercialized sex'
             14 'Oth proprty offns: fraud, poss stln goods, vndlsm'
             15 'Other offense, not categorized elsewhere'
             16 'Weapons law violations' 17 'Counterfeiting/Forgery'
             18 'Violation of court order, parole, probation'
             19 'Disorderly conduct' 20 'Juvenile status offenses'
             21 'All oth offns: crimes agnst persons/prprty/society'
             22 'Traffic violations' 23 'Bad checks'
             24 'Curfew/loitering/vagrancy violations'
             25 'Trespass of real property' 26 'Runaway'
             27 'Family offenses, nonviolent' 28 'Intimidation'
             29 'Non-forcible sex offenses' 31 'Tobacco law/code violation'
             38 'Evading/hindering/obstructing police'
             39 'False report/statement/alarm'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   PROBATON  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   PAROLREL  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   DRVALDR   1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   DRVAONLY  1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   DRVDONLY  1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   DRIVALC   1 'Yes (DRVALDR=1 OR DRVAONLY=1)'
             2 'No (DRVALDR=2 AND DRVAONLY=2)' 3 'Unknown (OTHERWISE)'
             4 'Never/No Use (DRVALDR AND DRVAONLY=81,89,91,99)' /
   DRIVDRG   1 'Yes (DRVALDR=1 OR DRVDONLY=1)'
             2 'No (DRVALDR=2 AND DRVDONLY=2)' 3 'Unknown (OTHERWISE)'
             4 'Never/No Use (DRVALDR AND DRVDONLY=81,89,91,99)' /
   DRIVALD   1 'Yes (DRIVALC=1 OR DRIVDRG=1)'
             2 'No (DRIVALC=2 AND DRIVDRG=2)' 3 'Unknown (OTHERWISE)'
             4 'Never/No Use (DRIVALC AND DRIVDRG=4)' /
   PAROL     -9 'Unknown Status (PAROLREL=85,94,97,98)'
             1 'On Parole/Supervised Release (PAROLREL=1)'
             2 'Not on Parole/Supervised Release (PAROLREL=2)' /
   PROB      -9 'Unknown Probation Status (PROBATON=85,94,97,98)'
             1 'On Probation (PROBATON=1)' 2 'Not on Probation (PROBATON=2)'
             /
   TXEVER    1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   TXYREVER  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP (TXEVER=2)' /
   TXYRADG   1 'Alcohol use only' 2 'Drug use only'
             3 'Both alcohol and drug use'
             4 'Alcohol (drug trmt unknown) LOGICALLY ASSIGNED'
             6 'Both alcohol and drug use LOGICALLY ASSIGNED'
             11 'Alcohol only (but last tmt for drugs reported)'
             12 'Drugs only (but last tmt for alc reported)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRHOSP  1 'Yes' 2 'No' 5 'Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRHPAD  1 'Alcohol use' 2 'Drug use' 3 'Both alcohol and drug use'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRRFIN  1 'Yes' 2 'No' 5 'Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRINAD  1 'Alcohol use' 2 'Drug use' 3 'Both alcohol and drug use'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRRFOP  1 'Yes' 2 'No' 5 'Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRPOAD  1 'Alcohol use' 2 'Drug use' 3 'Both alcohol and drug use'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRMHC   1 'Yes' 2 'No' 5 'Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRMHAD  1 'Alcohol use' 2 'Drug use' 3 'Both alcohol and drug use'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRTXER  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             5 'Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRERAD  1 'Alcohol use' 2 'Drug use' 3 'Both alcohol and drug use'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRDOC   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             5 'Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRDCAD  1 'Alcohol use' 2 'Drug use' 3 'Both alcohol and drug use'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRJAIL  1 'Yes' 2 'No' 5 'Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRJLAD  1 'Alcohol use' 2 'Drug use' 3 'Both alcohol and drug use'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRSHG   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             5 'Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRSGAD  1 'Alcohol use' 2 'Drug use' 3 'Both alcohol and drug use'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRSOP   1 'Yes' 2 'No' 5 'Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
             7 'Treatment location unknown, LOG ASSN'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYROTS2  9 'Some other place, not categorized elsewhere'
             23 'Drug or alcohol rehab facility as outpatient'
             26 'Private doctor''s office' 27 'Prison or jail'
             28 'Self-help group' 40 'Home, family, friends'
             41 'School, college' 42 'Church/religious/spiritual influence'
             44 'Halfway house/group home'
             47 'Community/city/county/state program, unspecified'
             48 'Counselor, therapist, psychologist'
             49 'Court-mandated/sponsored program'
             51 'Alcohol/drug class, location unspecified'
             52 'Military/VA Hospital'
             53 'Hospital, patient status unspecified'
             55 'Youth-oriented facility/organization/program'
             56 'Mental health centerfacility, ptnt status unspcfd'
             63 'Medical clinic' 64 'Methadone clinic/program'
             65 'Name of facility/program given'
             981 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             985 'BAD DATA Logically assigned'
             991 'NEVER USED ALCOHOL OR DRUGS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   TXYROTAD  1 'Alcohol use' 2 'Drug use' 3 'Both alcohol and drug use'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRVSER  1 'Yes' 2 'No' 6 'NEVER USED RELEVANT DRUGS'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXYRNME2  31 '31 or more'
             981 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             985 'BAD DATA Logically assigned'
             991 'NEVER USED ALCOHOL OR DRUGS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   TXRCVNOW  1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXNEDR  1 'Yes' 2 'No' 11 'Yes (TXYREVER=3)' 12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXMORE  1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMRALC  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMRMJ   1 'Response entered' 6 'Response not entered'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMRCOC  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMRHER  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMRHAL  6 'Response not entered'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMRINH  6 'Response not entered'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMRANL  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMRTRN  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMRSTM  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMRSED  6 'Response not entered'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMROTH  1 'Response entered' 6 'Response not entered'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXALCR  1 'Yes' 2 'No' 11 'Yes (TXYREVER=3)' 12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXMJR   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED' 11 'Yes (TXYREVER=3)'
             12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXCOCR  1 'Yes' 2 'No' 11 'Yes (TXYREVER=3)' 12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXHERR  1 'Yes' 2 'No' 11 'Yes (TXYREVER=3)' 12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXHALR  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED' 11 'Yes (TXYREVER=3)'
             12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXINHR  1 'Yes' 2 'No' 11 'Yes (TXYREVER=3)' 12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXANLR  1 'Yes' 2 'No' 11 'Yes (TXYREVER=3)' 12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXTRNR  1 'Yes' 2 'No' 11 'Yes (TXYREVER=3)' 12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXSTMR  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED' 11 'Yes (TXYREVER=3)'
             12 'No (TXYREVER=3)' 13 'Yes LOGICALLY ASSIGNED (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXSEDR  1 'Yes' 2 'No' 11 'Yes (TXYREVER=3)' 12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXSODR  1 'Yes' 2 'No' 5 'Drug Unknown LOGICALLY ASSIGNED'
             11 'Yes (TXYREVER=3)' 12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTXDG1R  103 'Amytal' 322 'Methamphetamine ("ice" or "crank"), Meth'
             355 'Crystal meth' 658 'Special K, Ketamine' 702 'Heroin'
             803 'Marijuana, MarrJane, Mary Jane, MJ, pot, weed'
             805 'Cocaine, coca, cocaina, coke'
             807 'Alcohol, beer, ethanol, EtOH, pink champagne'
             900 'Not a drug'
             9981 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             9985 'BAD DATA Logically assigned'
             9991 'NEVER USED ALCOHOL OR DRUGS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   NDTXDG2R  803 'Marijuana, MarrJane, Mary Jane, MJ, pot, weed'
             806 'Crack, rock'
             807 'Alcohol, beer, ethanol, EtOH, pink champagne'
             9981 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             9991 'NEVER USED ALCOHOL OR DRUGS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   NDTXDG3R  703 'Opium' 807 'Alcohol, beer, ethanol, EtOH, pink champagne'
             6096 'Bananadine'
             9981 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             9991 'NEVER USED ALCOHOL OR DRUGS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   NDTXDG4R  604 'Psilocybin (mushrooms), shrooms' 804 'Hashish'
             9981 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             9991 'NEVER USED ALCOHOL OR DRUGS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   NDTXDG5R  601 'LSD ("acid")'
             9981 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             9991 'NEVER USED ALCOHOL OR DRUGS' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   NDTXEFTR  1 'Yes' 2 'No' 11 'Yes (TXYREVER=3)' 12 'No (TXYREVER=3)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NDTMREFT  1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXLASREC  1 'Within the past 30 days -- since 30 day ref date'
             2 'More than 30 days ago but within the past 12 mos'
             3 'More than 12 months ago'
             7 'Still in treatment LOG ASSN (TXRCVNOW=1)'
             8 'Treatment in past year LOGICALLY ASSIGNED'
             9 'Treatment in lifetime LOGICALLY ASSIGNED'
             13 'Treatment > 12 mos ago LOG ASSN (TXYREVER=2)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXLTYMN2  1 'A hospital overnight as an inpatient'
             2 'A res drug/alcohol rehab facility overnight'
             3 'A drug or alcohol rehab facility as an outpatient'
             4 'A mental health center or facility as outpatient'
             5 'An emergency room' 6 'A private doctor''s office'
             7 'A prison or jail' 8 'A self-help group' 9 'Some other place'
             40 'Home, family, friends' 41 'School, college'
             42 'Church/religious/spiritual influence'
             47 'Community/city/county/state program, unspecified'
             48 'Counselor, therapist, psychologist'
             49 'Court-mandated/sponsored program'
             51 'Alcohol/drug class, location unspecified'
             52 'Military/VA Hospital'
             55 'Youth-oriented facility/organization/program'
             64 'Methadone clinic/program'
             65 'Name of facility/program given'
             981 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             985 'BAD DATA Logically assigned'
             991 'NEVER USED ALCOHOL OR DRUGS' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   TXLTYALC  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             5 'Yes LOG ASSN (TXYRADG = 1)'
             6 'NEVER USED ALCOHOL (TXEVER = 1)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' /
   TXLTYMJ   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             6 'NEVER USED MARIJUANA (TXEVER = 1)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' /
   TXLTYCOC  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             6 'NEVER USED COCAINE (TXEVER = 1)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' /
   TXLTYHER  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             6 'NEVER USED HEROIN (TXEVER = 1)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' /
   TXLTYHAL  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             6 'NEVER USED HALLUCINOGENS (TXEVER = 1)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' /
   TXLTYINH  1 'Yes' 2 'No' 6 'NEVER USED INHALANTS (TXEVER = 1)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' /
   TXLTYANL  1 'Yes' 2 'No' 6 'NEVER USED PAIN RELIEVERS (TXEVER = 1)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' /
   TXLTYTRN  1 'Yes' 2 'No' 6 'NEVER USED TRANQUILIZERS (TXEVER = 1)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' /
   TXLTYSTM  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             6 'NEVER USED STIMULANTS (TXEVER = 1)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' /
   TXLTYSED  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             6 'NEVER USED SEDATIVES (TXEVER = 1)'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' /
   TXLTYSOD  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             5 'Treatment drug unknown, LOGICALLY ASSIGNED'
             7 'Treatment drug/alc unknown LOG ASSN'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXLTYOU2  1 'You are still in treatment'
             2 'You successfully completed treatment'
             3 'You left because you had a problem with program'
             4 'You left b/c you couldn''t afford to continue'
             5 'You left because your family needed you'
             6 'You left because you began using drugs again'
             7 'Your last treatment had some other outcome'
             41 'You left because you didn''t need/want treatment'
             48 'Discontinued treatment, success unknown'
             49 'Completed treatment, outcome unknown'
             50 'You had other problems to deal with'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXLTYDU2  31 '31 or more'
             99981 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             99985 'BAD DATA Logically assigned'
             99991 'NEVER USED ALCOHOL OR DRUGS' 99994 'DON''T KNOW'
             99997 'REFUSED' 99998 'BLANK (NO ANSWER)'
             99999 'LEGITIMATE SKIP' /
   TXPYINS   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXPYCARE  1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXPYCAID  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXPYPUBP  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXPYSAVE  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXPYFMLY  1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXPYCORT  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXPYMILC  1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXPYEMPL  1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXPYSOS   1 'Yes' 2 'No' 4 'No LOG ASSN (free trmt specified)'
             5 'Yes, payment source not specified LOG ASSN'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXPYSP2   1 'Private health insurance' 3 'Medicaid'
             4 'Public assistance program other than Medicaid'
             5 'Own savings or earnings' 6 'Family members' 7 'Courts'
             10 'Free' 11 'Some other source' 12 'Friend/sponsor' 14 'School'
             19 'Public assistance, unspecified'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXPYFRE   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TXENROLL  1 'Yes' 2 'No'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP (TXEVER=2)' /
   TXYRDTXO  1 'Yes' 2 'No' 4 'No LOGICALLY ASSIGNED'
             81 'NEVER USED ALCOHOL OR DRUGS Logically assigned'
             91 'NEVER USED ALCOHOL OR DRUGS' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SPECTILL  0 'No/Unknown (Otherwise)' 1 'Yes (See comment above)' /
   SPECTALC  0 'No/Unknown (Otherwise)' 1 'Yes (See comment above)' /
   SPILLALC  0 'No/Unknown (Otherwise)' 1 'Yes (See comment above)' /
   ILLNEED   0 'No/Unknown (Otherwise)' 1 'Yes (See comment above)' /
   TXNOSPEC  0 'No/Unknown (Otherwise)' 1 'Yes (ILLNEED=1 and SPECTILL=0)' /
   ALCTRMT   0 'No/Unknown (TXYRADG=2,81,85,91,94,97,98,99)'
             1 'Yes (TXYRADG=1,3,4,6,11,12)' /
   ILLTRMT   0 'No/Unknown (TXYRADG=1,4,81,85,91,94,97,98,99)'
             1 'Yes (TXYRADG=2,3,6,11,12)' /
   TXILLALC  0 'No/Unknown (TXYREVER=2,4,81,85,91,94,97,98,99)'
             1 'Yes (TXYREVER=1,3)' /
   TXILANAL  0 'No/Unknown (TXYRADG=1,2,4,81,85,91,94,97,98,99)'
             1 'Yes (TXYRADG=3,6,11,12)' /
   TXLTALC2  0 'No/Unknown (TXLTYALC=2,6,81,85,91,94,97,98,99)'
             1 'Yes (TXLTYALC=1,3,5)' /
   TXLTANL2  0 'No/Unknown (TXLTYANL=2,6,81,85,91,94,97,98,99)'
             1 'Yes (TXLTYANL=1)' /
   TXLTCOC2  0 'No/Unknown (TXLTYCOC=2,6,81,91,94,97,98,99)'
             1 'Yes (TXLTYCOC=1,3)' /
   TXLTHAL2  0 'No/Unknown (TXLTYHAL=2,6,81,91,94,97,98,99)'
             1 'Yes (TXLTYHAL=1,3)' /
   TXLTHER2  0 'No/Unknown (TXLTYHER=2,6,81,91,97,98,99)'
             1 'Yes (TXLTYHER=1,3)' /
   TXLTINH2  0 'No/Unknown (TXLTYINH=2,6,81,91,94,97,98,99)'
             1 'Yes (TXLTYINH=1)' /
   TXLTMJ2   0 'No/Unknown (TXLTYMJ=2,6,81,91,94,97,98,99)'
             1 'Yes (TXLTYMJ=1,3)' /
   TXLTSED2  0 'No/Unknown (TXLTYSED=2,6,81,91,94,97,98,99)'
             1 'Yes (TXLTYSED=1,3)' /
   TXLTSTM2  0 'No/Unknown (TXLTYSTM=2,6,81,91,94,97,98,99)'
             1 'Yes (TXLTYSTM=1,3)' /
   TXLTTRN2  0 'No/Unknown (TXLTYTRN=2,6,81,91,94,97,98,99)'
             1 'Yes (TXLTYTRN=1)' /
   TXLTILL2  0 'No/Unknown (Otherwise)' 1 'Yes (ANY SOURCE VARIABLE=1)' /
   TXPINS2   0 'No/Unknown (TXPYINS=2,81,85,91,94,97,98,99)'
             1 'Yes (TXPYINS=1,3)' /
   TXPCARE2  0 'No/Unknown (TXPYCARE=2,81,85,91,94,97,98,99)'
             1 'Yes (TXPYCARE=1)' /
   TXPCAID2  0 'No/Unknown (TXPYCAID=2,81,85,91,94,97,98,99)'
             1 'Yes (TXPYCAID=1,3)' /
   TXPPUBP2  0 'No/Unknown (TXPYPUBP=2,81,85,91,94,97,98,99)'
             1 'Yes (TXPYPUBP=1,3)' /
   TXPSAVE2  0 'No/Unknown (TXPYSAVE=2,81,85,91,94,97,98,99)'
             1 'Yes (TXPYSAVE=1,3)' /
   TXPFMLY2  0 'No/Unknown (TXPYFMLY=2,81,85,91,94,97,98,99)'
             1 'Yes (TXPYFMLY=1,3)' /
   TXPCORT2  0 'No/Unknown (TXPYCORT=2,81,85,91,94,97,98,99)'
             1 'Yes (TXPYCORT=1,3)' /
   TXPMILC2  0 'No/Unknown (TXPYMILC=2,81,85,91,94,97,98,99)'
             1 'Yes (TXPYMILC=1)' /
   TXPEMPL2  0 'No/Unknown (TXPYEMPL=2,81,85,91,94,97,98,99)'
             1 'Yes (TXPYEMPL=1)' /
   ILLPINS   0 'No/Unknown (TXLTILL2=0 OR TXPINS2=0)'
             1 'Yes (TXLTILL2=1 AND TXPINS2=1)' /
   ILLPCARE  0 'No/Unknown (TXLTILL2=0 OR TXPCARE2=0)'
             1 'Yes (TXLTILL2=1 AND TXPCARE2=1)' /
   ILLPCAID  0 'No/Unknown (TXLTILL2=0 OR TXPCAID2=0)'
             1 'Yes (TXLTILL2=1 AND TXPCAID2=0)' /
   ILLPPUBP  0 'No/Unknown (TXLTILL2=0 OR TXPPUBP2=0)'
             1 'Yes (TXLTILL2=1 AND TXPPUBP2=1)' /
   ILLPSAVE  0 'No/Unknown (TXLTILL2=0 OR TXPSAVE2=0)'
             1 'Yes (TXLTILL2=1 AND TXPSAVE2=1)' /
   ILLPFMLY  0 'No/Unknown (TXLTILL2=0 OR TXPFMLY2=0)'
             1 'Yes (TXLTILL2=1 AND TXPFMLY2=1)' /
   ILLPCORT  0 'No/Unknown (TXLTILL2=0 OR TXPCORT2=0)'
             1 'Yes (TXLTILL2=1 AND TXPCORT2=1)' /
   ILLPMILC  0 'No/Unknown (TXLTILL2=0 OR TXPMILC2=0)'
             1 'Yes (TXLTILL2=1 AND TXPMILC2=1)' /
   ILLPEMPL  0 'No/Unknown (TXLTILL2=0 OR TXPEMPL2=0)'
             1 'Yes (TXLTILL2=1 AND TXPEMPL2=1)' /
   ALCPINS   0 'No/Unknown (TXLTALC2=0 OR TXPINS2=0)'
             1 'Yes (TXLTALC2=1 AND TXPINS2=1)' /
   ALCPCARE  0 'No/Unknown (TXLTALC2=0 OR TXPCARE2=0)'
             1 'Yes (TXLTALC2=1 AND TXPCARE2=1)' /
   ALCPCAID  0 'No/Unknown (TXLTALC2=0 OR TXPCAID2=0)'
             1 'Yes (TXLTALC2=1 AND TXPCAID2=1)' /
   ALCPPUBP  0 'No/Unknown (TXLTALC2=0 OR TXPPUBP2=0)'
             1 'Yes (TXLTALC2=1 AND TXPPUBP2=1)' /
   ALCPSAVE  0 'No/Unknown (TXLTALC2=0 OR TXPSAVE2=0)'
             1 'Yes (TXLTALC2=1 AND TXPSAVE2=1)' /
   ALCPFMLY  0 'No/Unknown (TXLTALC2=0 OR TXPFMLY2=0)'
             1 'Yes (TXLTALC2=1 AND TXPFMLY2=1)' /
   ALCPCORT  0 'No/Unknown (TXLTALC2=0 OR TXPCORT2=0)'
             1 'Yes (TXLTALC2=1 AND TXPCORT2=1)' /
   ALCPMILC  0 'No/Unknown (TXLTALC2=0 OR TXPMILC2=0)'
             1 'Yes (TXLTALC2=1 AND TXPMILC2=1)' /
   ALCPEMPL  0 'No/Unknown (TXLTALC2=0 OR TXPEMPL2=0)'
             1 'Yes (TXLTALC2=1 AND TXPEMPL2=1)' /
   LOCHOSP   0 'No/Unknown (TXYRHOSP=2,81,85,91,94,97,98,99)'
             1 'Yes (TXYRHOSP=1,5)' /
   LOCRFIN   0 'No/Unknown (TXYRRFIN=2,81,85,91,94,97,98,99)'
             1 'Yes (TXYRRFIN=1,3,5)' /
   LOCRFOP   0 'No/Unknown (TXYRRFOP=2,81,85,91,94,97,98,99)'
             1 'Yes (TXYRRFOP=1,5)' /
   LOCMHC    0 'No/Unknown (TXYRMHC=2,81,85,91,94,97,98,99)'
             1 'Yes (TXYRMHC=1,5)' /
   LOCTXER   0 'No/Unknown (TXYRTXER=2,81,85,91,97,98,99)'
             1 'Yes (TXYRTXER=1,3,5)' /
   LOCDOC    0 'No/Unknown (TXYRDOC=2,81,85,91,94,97,98,99'
             1 'Yes (TXYRDOC=1,3,5)' /
   LOCJAIL   0 'No/Unknown (TXYRJAIL=2,81,85,91,97,98,99)'
             1 'Yes (TXYRJAIL=1,5)' /
   LOCSHG    0 'No/Unknown (TXYRSHG=2,81,85,91,97,98,99)'
             1 'Yes (TXYRSHG=1,3,5)' /
   DRGHOSP   0 'No/Unknown (Otherwise)' 1 'Yes (TXYRHOSP=1 AND TXYRHPAD=2,3)'
             /
   DRGRFIN   0 'No/Unknown (Otherwise)' 1 'Yes (TXYRRFIN=1 AND TXYRINAD=2,3)'
             /
   DRGRFOP   0 'No/Unknown (Otherwise)' 1 'Yes (TXYRRFOP=1 AND TXYRPOAD=2,3)'
             /
   DRGMHC    0 'No/Unknown (Otherwise)' 1 'Yes (TXYRMHC=1 AND TXYRMHAD=2,3)'
             /
   DRGTXER   0 'No/Unknown (Otherwise)' 1 'Yes (TXYRTXER=1 AND TXYRERAD=2,3)'
             /
   DRGDOC    0 'No/Unknown (Otherwise)' 1 'Yes (TXYRDOC=1 AND TXYRDCAD=2,3)'
             /
   DRGJAIL   0 'No/Unknown (Otherwise)' 1 'Yes (TXYRJAIL=1 AND TXYRJLAD=2,3)'
             /
   DRGSHG    0 'No/Unknown (Otherwise)' 1 'Yes (TXYRSHG=1 AND TXYRSGAD=2,3)'
             /
   ALCHOSP   0 'No/Unknown (Otherwise)' 1 'Yes (TXYRHOSP=1 AND TXYRHPAD=1,3)'
             /
   ALCRFIN   0 'No/Unknown (Otherwise)' 1 'Yes (TXYRRFIN=1 AND TXYRINAD=1,3)'
             /
   ALCRFOP   0 'No/Unknown (Otherwise)' 1 'Yes (TXYRRFOP=1 AND TXYRPOAD=1,3)'
             /
   ALCMHC    0 'No/Unknown (Otherwise)' 1 'Yes (TXYRMHC=1 AND TXYRMHAD=1,3)'
             /
   ALCTXER   0 'No/Unknown (Otherwise)' 1 'Yes (TXYRTXER=1 AND TXYRERAD=1,3)'
             /
   ALCDOC    0 'No/Unknown (Otherwise)' 1 'Yes (TXYRDOC=1 AND TXYRDCAD=1,3)'
             /
   ALCJAIL   0 'No/Unknown (Otherwise)' 1 'Yes (TXYRJAIL=1 AND TXYRJLAD=1,3)'
             /
   ALCSHG    0 'No/Unknown (Otherwise)' 1 'Yes (TXYRSHG=1 AND TXYRSGAD=1,3)'
             /
   AUINPYR   1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUINPSYH  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUINPGEN  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUINMEDU  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUINAHSP  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUINRESD  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUINSFAC  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUNMPSY2  31 '31 or more' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   AUNMPGE2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   AUNMMEDU  994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   AUNMAHSP  994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   AUNMRESD  994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   AUNMSFA2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   AUPINSLF  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPINOFM  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPINPHI  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPINMCR  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPINMCD  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPINREH  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPINEMP  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPINMIL  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPINPUB  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPINPRV  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPINFRE  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPINAMT  1 'Less than $100' 2 '$100 to $200' 3 '$201 to $500'
             4 '$501 to $900' 5 '$901 to $1,500' 6 '$1,501 to $2,000'
             7 '$2,001 to $5,000' 8 'More than $5,000' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUOPTYR   1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUOPMENT  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   AUOPTHER  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   AUOPDOC   1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   AUOPCLNC  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   AUOPDTMT  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   AUOPOTOP  1 'Response entered' 6 'Response not entered'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUOPYRS2  1 'An outpatient mental health clinic or center'
             2 'Non-clinic therapist/psychologist/counselor'
             3 'A doctor''s office that was not part of a clinic'
             4 'An outpatient medical clinic'
             5 'A partial day hospital or day treatment program'
             6 'Some other place, not categorized elsewhere'
             7 'Friend(s)/parent of friend' 8 'Family member(s)/home'
             9 'School or university setting/clinic/center'
             10 'Church/clergy/religious influence'
             11 'Support group/self-help group/group counseling'
             12 'Clinic or center counseling; mental/health unspcfd'
             13 'Therapist/psychologist/counselor; locale unspecfd'
             14 'A doctor''s office; location unspecified'
             15 'Work/parents'' work/Employee Assistance Program'
             18 'Military facility/VA'
             22 'Health professional, not a Dr; non-mental health'
             24 'Clinic/center, type unspecified'
             70 'Name of facility/description of facility given'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUNMMEN2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   AUNMTHE2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   AUNMDOC2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   AUNMCLN2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   AUNMDTM2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   AUNMOTO2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   AUPOPSLF  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPOFM  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPPHI  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPMCR  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPMCD  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPREH  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPEMP  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPMIL  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPPUB  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPPRV  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPFRE  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPMOS  1 'Self or a family member living with you'
             2 'A family member who does not live with you'
             3 'Private health insurance' 4 'Medicare' 5 'Medicaid'
             7 'Employer' 8 'VA or other military program'
             9 'Other public source' 10 'Other private source'
             11 'No one paid because the treatment was free' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUPOPAMT  1 'Less than $100' 2 '$100 to $200' 3 '$201 to $500'
             4 '$501 to $900' 5 '$901 to $1,500' 6 '$1,501 to $2,000'
             7 '$2,001 to $5,000' 8 'More than $5,000' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AURXYR    1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUUNMTYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AUUNMTRS  1 'Couldn''t afford it' 2 'Some other reason'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   AMHINP    1 'Yes (AUINPYR=1)' 2 'No (AUINPYR=2)'
             3 'Unknown (AUINPYR=85,94,97,98)' 4 'Aged 12-17(AUINPYR=89,99)'
             /
   AMHOUTP   1 'Yes (AUOPTYR=1)' 2 'No (AUOPTYR=2)'
             3 'Unknown (AUOPTYR=85,94,97,98)' 4 'Aged 12-17(AUOPTYR=89,99)'
             /
   AMHRX     1 'Yes (AURXYR=1)' 2 'No (AURXYR=2)'
             3 'Unknown (AURXYR=85,94,97,98)' 4 'Aged 12-17(AURXYR=89,99)' /
   AMHTXREC  1 'Yes (AMHINP=1 OR AMHOUTP=1 OR AMHRX=1)'
             2 'No (AMHINP=2 AND AMHOUTP=2 AND AMHRX=2)'
             3 'Unknown (OTHERWISE)'
             4 'Aged 12-17 (AMHINP=4 AND AMHOUTP=4 AND AMHRX=4)' /
   AMHTRTND  1 'Yes (AUUNMTYR=1)' 2 'No (AUUNMTYR=2)'
             3 'Unknown (AUUNMTYR=85,94,97,98)'
             4 'Aged 12-17(AUUNMTYR=89,99)' /
   SNCRIME   1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNSELLDG  1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNPPVAL   1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNSTFGT   1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNEMTBLD  1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNPPHLP   1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNGRAFTI  1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNPPVSIT  1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNPPMOVE  1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNMOV5Y2  0 'None' 1 'One time' 2 'Two times' 3 'Three times'
             4 'Four times' 5 'Five times' 6 'Six or more times'
             989 'LEGITIMATE SKIP Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   SNSPOUSE  1 'Yes' 2 'No' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNSPACTV  1 '0 times' 2 '1 or 2 times' 3 'A few times' 4 'Many times'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNSPANGR  1 '0 times' 2 '1 or 2 times' 3 'A few times' 4 'Many times'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNSPHITU  1 '0 times' 2 '1 or 2 times' 3 'A few times' 4 'Many times'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNYHITSP  1 '0 times' 2 '1 or 2 times' 3 'A few times' 4 'Many times'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNSPCRIT  1 'Always' 2 'Sometimes' 3 'Seldom' 4 'Never' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNSPCONC  1 'Always' 2 'Sometimes' 3 'Seldom' 4 'Never' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNFRCONC  1 'None' 2 'One' 3 '2 or 3' 4 '4 to 5' 5 'More than 5'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNFRACTV  1 'None' 2 'One' 3 '2 or 3' 4 '4 to 5' 5 'More than 5'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNFRCARE  1 'None' 2 'One' 3 '2 or 3' 4 '4 to 5' 5 'More than 5'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNYSELL   1 '0 times' 2 '1 or 2 times' 3 '3 to 5 times' 4 '6 to 9 times'
             5 '10 or more times' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNYSTOLE  1 '0 times' 2 '1 or 2 times' 3 '3 to 5 times' 4 '6 to 9 times'
             5 '10 or more times' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNYATTAK  1 '0 times' 2 '1 or 2 times' 3 '3 to 5 times' 4 '6 to 9 times'
             5 '10 or more times' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SNFACIG   1 'Neither approve nor disapprove' 2 'Somewhat disapprove'
             3 'Strongly disapprove' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNFAMJEV  1 'Neither approve nor disapprove' 2 'Somewhat disapprove'
             3 'Strongly disapprove' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNFAALDY  1 'Neither approve nor disapprove' 2 'Somewhat disapprove'
             3 'Strongly disapprove' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   SNFAALDV  1 'Neither approve nor disapprove' 2 'Somewhat disapprove'
             3 'Strongly disapprove' 89 'LEGITIMATE SKIP Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   YECRIME   1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YESELLDG  1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPPHLP   1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YESTFGT   1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEEMTBLD  1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPPVSIT  1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEGRAFTI  1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPPMOVE  1 'Strongly Agree' 2 'Somewhat Agree' 3 'Somewhat Disagree'
             4 'Strongly Disagree' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEMOV5Y2  0 'None' 1 'One time' 2 'Two times' 3 'Three times'
             4 'Four times' 5 'Five times' 6 'Six or more times'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   YEENRLYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YELSTGRD  1 'An "A+", "A" or "A-minus" average'
             2 'A "B+", "B" or "B-minus" average'
             3 'A "C+", "C" or "C-minus" average'
             4 'A "D" or less than a "D" average'
             5 'My school does not give these grades'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEYFGTSW  1 '0 times' 2 '1 or 2 times' 3 '3 to 5 times' 4 '6 to 9 times'
             5 '10 or more times' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   YEYFGTGP  1 '0 times' 2 '1 or 2 times' 3 '3 to 5 times' 4 '6 to 9 times'
             5 '10 or more times' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   YEYHGUN   1 '0 times' 2 '1 or 2 times' 3 '3 to 5 times' 4 '6 to 9 times'
             5 '10 or more times' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   YEYSELL   1 '0 times' 2 '1 or 2 times' 3 '3 to 5 times' 4 '6 to 9 times'
             5 '10 or more times' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   YEYSTOLE  1 '0 times' 2 '1 or 2 times' 3 '3 to 5 times' 4 '6 to 9 times'
             5 '10 or more times' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   YEYATTAK  1 '0 times' 2 '1 or 2 times' 3 '3 to 5 times' 4 '6 to 9 times'
             5 '10 or more times' 85 'BAD DATA Logically assigned'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   YEPPKCIG  1 'Neither approve nor disapprove' 2 'Somewhat disapprove'
             3 'Strongly disapprove' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPMJEVR  1 'Neither Approve or Disapprove' 2 'Somewhat Disapprove'
             3 'Strongly Disapprove' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPALDLY  1 'Neither Approve or Disapprove' 2 'Somewhat Disapprove'
             3 'Strongly Disapprove' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEGPKCIG  1 'Neither approve nor disapprove' 2 'Somewhat disapprove'
             3 'Strongly disapprove' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEGMJEVR  1 'Neither approve nor disapprove' 2 'Somewhat disapprove'
             3 'Strongly disapprove' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEGALDLY  1 'Neither approve nor disapprove' 2 'Somewhat disapprove'
             3 'Strongly disapprove' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YETLKNON  1 'Response entered' 6 'Response not entered'
             11 'Response entered (& other responses entered)'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   YETLKPAR  1 'Response entered' 6 'Response not entered'
             11 'Response entered (YETLKNON=11)' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YETLKSOP  1 'Response entered' 6 'Response not entered'
             11 'Response entered (YETLKNON=11)' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPRTDNG  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEBIGBRO  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPRBSLV  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEVIOPRV  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEYMCA    1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YESCOUTS  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPRVLES  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEDGPRGP  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YETEMSPT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YE4HCLUB  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YESLFHLP  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEBAND    1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YESCHCLB  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEVOLUNT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YESTGOVT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPRGSTD  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEJBSKIL  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECHOIR   1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEDECLAS  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEDERGLR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEDESPCL  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPVNTYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGFRND  1 '0 times' 2 '1 time' 3 '2 times' 4 '3 to 5 times'
             5 '6 to 9 times' 6 '10 or more times'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGVEND  1 '0 times' 2 '1 time' 3 '2 times' 4 '3 to 5 times'
             5 '6 to 9 times' 6 '10 or more times'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGMAI2  1 '0 times' 2 '1 time' 3 '2 times' 4 '3 to 5 times'
             5 '6 or more times' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGCHKO  1 '0 times' 2 '1 time' 3 '2 times' 4 '3 to 5 times'
             5 '6 to 9 times' 6 '10 or more times'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGCLRK  1 '0 times' 2 '1 time' 3 '2 times' 4 '3 to 5 times'
             5 '6 to 9 times' 6 '10 or more times'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGINET  1 '0 times' 2 '1 time' 3 '2 times' 4 '3 to 5 times'
             6 '10 or more times' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGSMKT  1 '0 times' 2 '1 time' 3 '2 times' 4 '3 to 5 times'
             5 '6 to 9 times' 6 '10 or more times'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGDSTO  1 '0 times' 2 '1 time' 3 '2 times' 4 '3 to 5 times'
             5 '6 to 9 times' 6 '10 or more times'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGCONV  1 '0 times' 2 '1 time' 3 '2 times' 4 '3 to 5 times'
             5 '6 to 9 times' 6 '10 or more times'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGINDV  1 '0 times' 2 '1 time' 3 '2 times' 4 '3 to 5 times'
             5 '6 to 9 times' 6 '10 or more times'
             85 'BAD DATA Logically assigned' 91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGPRUF  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YECGSUCC  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPKCRTN  1 'Pack' 2 'Carton' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPDPACK  1 'Less than $1.00' 2 '$1.00 - $1.50' 3 '$1.51 - $2.00'
             4 '$2.01 - $2.50' 5 '$2.51 - $3.00' 6 '$3.01 - $3.50'
             7 '$3.51 - $4.00' 8 '$4.01 - $4.50' 9 '$4.51 - $5.00'
             10 'More than $5.00' 85 'BAD DATA Logically assigned'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEPDCRTN  1 'Less than $10.00' 2 '$10.00 - $10.99' 3 '$11.00 - $11.99'
             4 '$12.00 - $12.99' 5 '$13.00 - $13.99' 6 '$14.00 - $14.99'
             7 '$15.00 - $15.99' 8 '$16.00 - $16.99' 9 '$17.00 - $17.99'
             10 '$18.00 - $18.99' 11 '$19.00 - $19.99' 15 '$23.00 or more'
             91 'NEVER USED CIGARETTES'
             93 'DID NOT USE CIGARETTES IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEBLNTEV  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEBLNT30  1 'Yes' 2 'No' 11 'Yes (YEBL30FQ=0)'
             85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YEBL30FQ  94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   YECGRWMJ  1 'Yes' 2 'No' 91 'NEVER USED CIGARS'
             93 'DID NOT USE CIGARS IN THE PAST 30 DAYS' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NGHCRIM2  -9 'OTHERWISE (YECRIME = 94,97,98,99)'
             1 'STRONGLY OR SOMEWHAT AGREE (YECRIME = 1,2)'
             2 'SOMEWHAT OR STRONGLY DISAGREE (YECRIME = 3,4)' /
   NGHSELL2  -9 'OTHERWISE (YESLLDG = 94,97,98,99)'
             1 'STRONGLY OR SOMEWHAT AGREE (YESLLDG = 1,2)'
             2 'SOMEWHAT OR STRONGLY DISAGREE (YESLLDG = 3,4)' /
   NGHHELP2  -9 'OTHERWISE (YEPPHLP = 94,97,98,99)'
             1 'STRONGLY OR SOMEWHAT AGREE (YEPPHLP = 1,2)'
             2 'SOMEWHAT OR STRONGLY DISAGREE (YEPPHLP = 3,4)' /
   NGHFGHT2  -9 'OTHERWISE (YESTFGT = 94,97,98,99)'
             1 'STRONGLY OR SOMEWHAT AGREE (YESTFGT = 1,2)'
             2 'SOMEWHAT OR STRONGLY DISAGREE (YESTFGT = 3,4)' /
   NGHBLDG2  -9 'OTHERWISE (YEEMTBLD = 94,97,98,99)'
             1 'STRONGLY OR SOMEWHAT AGREE (YEEMTBLD = 1,2)'
             2 'SOMEWHAT OR STRONGLY DISAGREE (YEEMTBLD = 3,4)' /
   NGHVSIT2  -9 'OTHERWISE (YEPPVSIT = 94,97,98,99)'
             1 'STRONGLY OR SOMEWHAT AGREE (YEPPVSIT = 1,2)'
             2 'SOMEWHAT OR STRONGLY DISAGREE (YEPPVSIT = 3,4)' /
   NGHGRAF2  -9 'OTHERWISE (YEGRAFTI = 94,97,98,99)'
             1 'STRONGLY OR SOMEWHAT AGREE (YEGRAFTI = 1,2)'
             2 'SOMEWHAT OR STRONGLY DISAGREE (YEGRAFTI = 3,4)' /
   NGHMOVE2  -9 'OTHERWISE (YEPPMOVE = 94,97,98,99)'
             1 'STRONGLY OR SOMEWHAT AGREE (YEPPMOVE = 1,2)'
             2 'SOMEWHAT OR STRONGLY DISAGREE (YEPPMOVE = 3,4)' /
   MVIN5YR2  -9 'OTHERWISE (YEMOV5Y2 = 994,997,998,999)'
             1 'MORE THAN 1 TIME (YEMOV5Y2 = 2-6)'
             2 'NONE OR ONE TIME (YEMOV5Y2 = 0,1 )' /
   PRPKCIG2  -9 'OTHERWISE (YEPPKCIG = 94,97,98,99)'
             1 'STRONGLY DISAPPROVE (YEPPKCIG = 3)'
             2 'SOMEWHAT DISAPPROVE OR NEITHER (YEPPKCIG = 1,2)' /
   PRMJEVR2  -9 'OTHERWISE (YEPMJEVR = 94,97,98,99)'
             1 'STRONGLY DISAPPROVE (YEPMJEVR = 3)'
             2 'SOMEWHAT DISAPPROVE OR NEITHER (YEPMJEVR = 1,2)' /
   PRALDLY2  -9 'OTHERWISE (YEPALDLY = 94,97,98,99)'
             1 'STRONGLY DISAPPROVE (YEPALDLY = 3)'
             2 'SOMEWHAT DISAPPROVE OR NEITHER (YEPALDLY = 1,2)' /
   PRTALK3   -9 'OTHERWISE (YEPRTDNG = 85,94,97,98,99)'
             1 'YES (YEPRTDNG = 1)' 2 'NO (YEPRTDNG = 2)' /
   YOFIGHT2  -9 'OTHERWISE (YEYFGTSW = 85,94,97,98,99)'
             1 'ONE OR MORE TIMES (YEYFGTSW = 2,3,4,5)'
             2 'NONE (YEYFGTSW = 1)' /
   YOGRPFT2  -9 'OTHERWISE (YEYFGTGP = 85,94,97,98,99)'
             1 'ONE OR MORE TIMES (YEYFGTGP = 2,3,4,5)'
             2 'NONE (YEYFGTGP = 1)' /
   YOHGUN2   -9 'OTHERWISE (YEYHGUN = 85,94,97,98,99)'
             1 'ONE OR MORE TIMES (YEYHGUN = 2,3,4,5)' 2 'NONE (YEYHGUN = 1)'
             /
   YOSELL2   -9 'OTHERWISE (YEYSELL = 85,94,97,98,99)'
             1 'ONE OR MORE TIMES (YEYSELL = 2,3,4,5)' 2 'NONE (YEYSELL = 1)'
             /
   YOSTOLE2  -9 'OTHERWISE (YEYSTOLE = 85,94,97,98,99)'
             1 'ONE OR MORE TIMES (YEYSTOLE = 2,3,4,5)'
             2 'NONE (YEYSTOLE = 1)' /
   YOATTAK2  -9 'OTHERWISE (YEYATTAK = 85,94,97,98,99)'
             1 'ONE OR MORE TIMES (YEYATTAK = 2,3,4,5)'
             2 'NONE (YEYATTAK = 1)' /
   YFLPKCG2  -9 'OTHERWISE (YEGPKCIG = 94,97,98,99)'
             1 'SOMEWHAT OR STRONGLY DISAPPROVE (YEGPKCIG = 2,3)'
             2 'NEITHER APPROVE OR DISAPPROVE (YEGPKCIG = 1)' /
   YFLTMRJ2  -9 'OTHERWISE (YEGMJEVR = 94,97,98,99)'
             1 'SOMEWHAT OR STRONGLY DISAPPROVE (YEGMJEVR = 2,3)'
             2 'NEITHER APPROVE OR DISAPPROVE (YEGMJEVR = 1)' /
   YFLADLY2  -9 'OTHERWISE (YEGALDLY = 94,97,98,99)'
             1 'SOMEWHAT OR STRONGLY DISAPPROVE (YEGALDLY = 2,3)'
             2 'NEITHER APPROVE OR DISAPPROVE (YEGALDLY = 1)' /
   YOUTHACT  -9 'OTHERWISE' 1 'NONE OR ONE ACTIVITY WAS MARKED'
             2 'TWO OR MORE ACTIVITIES WERE MARKED' /
   PRBSOLV2  -9 'OTHERWISE (YEPRBSLV = 85,94,97,98,99)'
             1 'YES (YEPRBSLV = 1)' 2 'NO (YEPRBSLV = 2)' /
   PREVIOL2  -9 'OTHERWISE (YEVIOPRV = 85,94,97,98,99)'
             1 'YES (YEVIOPRV = 1)' 2 'NO (YEVIOPRV = 2)' /
   PRVDRGO2  -9 'OTHERWISE (YEDGPRGP = 85,94,97,98,99)'
             1 'YES (YEDGPRGP = 1)' 2 'NO (YEDGPRGP = 2)' /
   GRPCNSL2  -9 'OTHERWISE (YESLFHLP = 85,94,97,98,99)'
             1 'YES (YESLFHLP = 1)' 2 'NO (YESLFHLP = 2)' /
   PREGPGM2  -9 'OTHERWISE (YEPRGSTD = 85,94,97,98,99)' 1 'YES (YEPRGSTD= 1)'
             2 'NO (YEPRGSTD = 2)' /
   DGSPCLS2  -9 'OTHERWISE (YEDECLAS = 85,94,97,98,99)'
             1 'YES (YEDECLAS = 1)' 2 'NO (YEDECLAS = 2)' /
   DGRGCLS2  -9 'OTHERWISE (YEDERGLR = 85,94,97,98,99)'
             1 'YES (YEDERGLR = 1)' 2 'NO (YEDERGLR = 2)' /
   DRGLECT2  -9 'OTHERWISE (YEDESPCL = 85,94,97,98,99)'
             1 'YES (YEDESPCL = 1)' 2 'NO (YEDESPCL = 2)' /
   DRPRVME3  -9 'OTHERWISE (YEPVNTYR = 85,94,97,98,99)'
             1 'YES (YEPVNTYR = 1)' 2 'NO (YEPVNTYR = 2)' /
   ANYEDUC3  -9 'OTHERWISE'
             1 'YES (DGSPCLS2 = 1 OR DGRGCLS2 = 1 OR DRGLECT2 = 1)'
             2 'NO (DGSPCLS2 = 2 & DGRGCLS2 = 2 & DRGLECT2 = 2)' /
   CIGFRND   0 'Otherwise (YECGFRND=1,85,91,93,94,97,98,99)'
             1 'Yes (YECGFRND=2,3,4,5,6)' /
   CIGVEND   0 'Otherwise (YECGVEND=1,85,91,93,94,97,98,99)'
             1 'Yes (YECGVEND=2,3,4,5,6)' /
   CIGMAIL   0 'Otherwise (YECGMAI2=1,85,91,93,94,97,98,99)'
             1 'At least 1 time (YECGMAI2=2,3,4,5)' /
   CIGCKOUT  0 'Otherwise (YECGCHKO=1,85,91,93,94,97,98,99)'
             1 'Yes (YECGCHKO=2,3,4,5,6)' /
   CIGCLERK  0 'Otherwise (YECGCLRK=1,85,91,93,94,97,98,99)'
             1 'Yes (YECGCLRK=2,3,4,5,6)' /
   CIGINET   0 'Otherwise (YECGINET=1,85,91,93,94,97,98,99)'
             1 'Yes (YECGINET=2,3,4,5,6)' /
   CIGSMKT   0 'Otherwise (YECGSMKT=1,85,91,93,94,97,98,99)'
             1 'Yes (YECGSMKT=2,3,4,5,6)' /
   CIGDSTO   0 'Otherwise (YECGDSTO=1,85,91,93,94,97,98,99)'
             1 'Yes (YECGDSTO=2,3,4,5,6)' /
   CIGCONV   0 'Otherwise (YECGCONV=1,85,91,93,94,97,98,99)'
             1 'Yes (YECGCONV=2,3,4,5,6)' /
   CIGINDIV  0 'Otherwise (YECGINDV=1,85,91,93,94,97,98,99)'
             1 'Yes (YECGINDV=2,3,4,5,6)' /
   YTHBGHT   0 'Otherwise' 1 'Yes (ANY SOURCE VARIABLE=1)' /
   YMSPGRUP  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMSPFNTP  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMSAHOME  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMSAACHE  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMSABDRM  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMSASLEP  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMSAABDN  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMSAUPLV  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMSAHMSK  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMAGOHSF  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMAGCRWD  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMAGTRAV  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMAGBRDG  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMPAATAK  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMPASUFC  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMGAWORY  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMGAHDAC  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMGAPAIN  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMGATNSE  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMPHANML  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMPHHIGH  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMPHDARK  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMPHNEDL  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMPHBLOD  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMPHBRDG  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMPHELEV  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMOCCOUN  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMOCWASH  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMOCCHCK  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMOCGERM  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMOCTHOT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMEATHIN  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMEAFAT   1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMEATHFD  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMEABING  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMELWTBD  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMELWTPT  1 'Yes' 2 'No' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   YMELSOIL  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMDNINT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMDLSEG  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMDNOGD  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMDTHKL  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMDTYKL  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMDTIRD  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMDTHNK  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMABDMD  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMARSLS  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMATALK  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMASPAB  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMMAMDRC  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMADCONC  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMADFRGT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMADFCUS  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMADMEDS  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMADAVAT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMADERRO  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMODHURT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMODRFUS  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMODANOY  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMODMEAN  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMODBLMO  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMODTANY  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMODSWOR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMCDEXPL  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMCDSHPL  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMCDLIED  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMCDSNAT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMCDVAND  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMCDSTOL  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMCDCRUA  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YMCDBKNT  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUHOSPYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUHOSPN2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   YUHOSUIC  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUHODEPR  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUHOFEAR  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUHOBKRU  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUHOEATP  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUHOSOR   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YURSIDYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YURSIDN2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   YURSSUIC  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YURSDEPR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YURSFEAR  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YURSBKRU  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YURSEATP  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YURSSOR   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFCARYR  1 'Yes' 2 'No' 4 'No LOGICALLY ASSIGNED' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFCARN2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   YUFCSUIC  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFCDEPR  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFCFEAR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFCBKRU  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFCEATP  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFCSOR   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUDYTXYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUDYTXN2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   YUDYSUIC  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUDYDEPR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUDYFEAR  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUDYBKRU  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUDYEATP  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUDYSOR   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUMHCRYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUMHCRN2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   YUMHSUIC  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUMHDEPR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUMHFEAR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUMHBKRU  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUMHEATP  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUMHSOR   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUTPSTYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUTPSTN2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   YUTPSUIC  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUTPDEPR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUTPFEAR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUTPBKRU  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUTPEATP  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUTPSOR   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUIHTPYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUIHTPN2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   YUIHSUIC  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUIHDEPR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUIHFEAR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUIHBKRU  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUIHEATP  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUIHSOR   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFDOCYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFDOCN2  31 '31 or more' 994 'DON''T KNOW' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   YUFDSUIC  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFDDEPR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFDFEAR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFDBKRU  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFDEATP  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFDSOR   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUSPEDYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUSHCNYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUSHSUIC  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUSHDEPR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUSHFEAR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUSHBKRU  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUSHEATP  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUSHSOR   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUJAILEV  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   YUFCAREV  1 'Yes' 2 'No' 5 'Yes LOGICALLY ASSIGNED (from skip pattern)'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   IRHHSIZ2  1 'One person in household' 2 'Two people in household'
             3 'Three people in household' 4 'Four people in household'
             5 'Five people in household' 6 '6 to 25 people in household' /
   IIHHSIZ2  1 'Questionnaire data' 3 'Statistically imputed data' /
   IRHH65_2  1 'No people 65 or older in household'
             2 'One person 65 or older in household'
             3 'Two or more people 65 or older in household' /
   IIHH65_2  1 'Questionnaire data' 2 'Logically imputed data'
             3 'Statistically imputed data' /
   IRKI17_2  1 'No children under 18' 2 'One child under 18'
             3 'Two children under 18' 4 'Three or more children under 18' /
   IIKI17_2  1 'Questionnaire data' 3 'Statistically imputed data' /
   IMOTHER   1 'R is 12-17, mother in hh' 2 'R is 12-17, no mother in hh'
             3 'R is 12-17, don''t know whether mother is in hh'
             4 'R is 18 or older' /
   IFATHER   1 'R is 12-17, father in hh' 2 'R is 12-17, no father in hh'
             3 'R is 12-17, don''t know whether father is in hh'
             4 'R is 18 or older' /
   NRCH17_2  -9 'Missing' 3 '3 or more' /
   PREGNANT  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   NMERTMT2  31 '31 or more' 985 'BAD DATA Logically assigned'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   INHOSPYR  1 'Yes' 2 'No' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   NMNGTHS2  31 '31 or more' 985 'BAD DATA Logically assigned'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   PROXANS2  1 'Yes' 2 'No' 7 'Unclear LOGICALLY ASSIGNED'
             89 'LEGITIMATE SKIP Logically assigned' 97 'REFUSED'
             98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP (Respondent answering)' /
   PREG      0 'Otherwise' 1 'Pregnant Females Aged 12-44 (PREGNANT=1)' /
   PREG2     -9 'Unknown (PREGNANT = 94,97,98)' 1 'Pregnant (PREGNANT=1)'
             2 'Not Pregnant (PREGNANT=2)'
             3 'Males/Females not age 12-44 (PREGNANT=99)' /
   TRIMEST   -9 'Unknown' 1 '1st 3 months of pregnancy'
             2 '2nd 3 months of pregnancy' 3 'Last 3 months of pregnancy'
             4 'Males/Not Pregnant Females' /
   IRPSOC    1 'Yes' 2 'No' /
   IIPSOC    1 'Questionnaire data' 3 'Statistically imputed data' /
   IRFAMSOC  1 'Yes' 2 'No' /
   IIFAMSOC  1 'Questionnaire data' 3 'Statistically imputed data' /
   IRPSSI    1 'Yes' 2 'No' /
   IIPSSI    1 'Questionnaire data' 3 'Statistically imputed data' /
   IRFAMSSI  1 'Yes' 2 'No' /
   IIFAMSSI  1 'Questionnaire data' 3 'Statistically imputed data' /
   IRFSTAMP  1 'Yes' 2 'No' /
   IIFSTAMP  1 'Questionnaire data' 3 'Statistically imputed data' /
   IRPPMT    1 'Yes' 2 'No' /
   IIPPMT    1 'Questionnaire data' 3 'Statistically imputed data' /
   IRFAMPMT  1 'Yes' 2 'No' /
   IIFAMPMT  1 'Questionnaire data' 3 'Statistically imputed data' /
   IRPSVC    1 'Yes' 2 'No' /
   IIPSVC    1 'Questionnaire data' 3 'Statistically imputed data' /
   IRFAMSVC  1 'Yes' 2 'No' /
   IIFAMSVC  1 'Questionnaire data' 3 'Statistically imputed data' /
   IRWELMOS  99 'LEGITIMATE SKIP' /
   IIWELMOS  1 'Questionnaire data' 3 'Statistically imputed data'
             9 'Legitimate skip' /
   IRPINT    1 'Yes' 2 'No' /
   IIPINT    1 'Questionnaire data' 3 'Statistically imputed data' /
   IRFAMINT  1 'Yes' 2 'No' /
   IIFAMINT  1 'Questionnaire data' 3 'Statistically imputed data' /
   IRPCHD    1 'Yes' 2 'No' /
   IIPCHD    1 'Questionnaire data' 3 'Statistically imputed data' /
   IRFAMCHD  1 'Yes' 2 'No' /
   IIFAMCHD  1 'Questionnaire data' 3 'Statistically imputed data' /
   IRPWAG    1 'Yes' 2 'No' /
   IIPWAG    1 'Questionnaire data' 3 'Statistically imputed data' /
   IRFAMWAG  1 'Yes' 2 'No' /
   IIFAMWAG  1 'Questionnaire data' 3 'Statistically imputed data' /
   IRPOTH    1 'Yes' 2 'No' /
   IIPOTH    1 'Questionnaire data' 3 'Statistically imputed data' /
   IRFAMOTH  1 'Yes' 2 'No' /
   IIFAMOTH  1 'Questionnaire data' 3 'Statistically imputed data' /
   IRPINC3   1 '$0 - $9,999 (Including Loss)' 2 '$10,000 - $19,999'
             3 '$20,000 - $29,999' 4 '$30,000 - $39,999'
             5 '$40,000 - $49,999' 6 '$50,000 - $74,999' 7 '$75,000 or more'
             /
   IIPINC3   1 'Questionnaire data' 3 'Statistically imputed data' /
   IRFAMIN3  1 '$0 - $9,999 (Including Loss)' 2 '$10,000 - $19,999'
             3 '$20,000 - $29,999' 4 '$30,000 - $39,999'
             5 '$40,000 - $49,999' 6 '$50,000 - $74,999' 7 '$75,000 or more'
             /
   IIFAMIN3  1 'Questionnaire data' 3 'Statistically imputed data' /
   GOVTPROG  1 'YES (ANY SOURCE VARIABLE=1)' 2 'NO (ALL SOURCE VARIABLES=2)'
             /
   HLCALLFG  1 'Answered yes to all current health insurance Qs'
             98 'BLANK (NO ANSWER)' /
   HLCALL99  1 'Yes' 98 'BLANK (NO ANSWER)' /
   MEDICARE  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   MEDICAID  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   CHAMPUS   1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   OGOVTINS  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   OGOVINS2  1 'Medicare' 2 'Medicaid or Medical Assistance'
             3 'Military Health Care (CHAMPUS, TRICARE, VA)'
             4 'State AIDS Drug Assistance Program'
             5 'SCHIP (State Children''s Health Insurance Plan)'
             6 'Public Health Service/Indian health hospital/clinc'
             7 'Temp Assistance for Needy Families; formerly AFDC'
             8 'State govt prgm; Chronically Ill/Disabled Children'
             9 'State govt program; prescription assistance'
             11 'Migrant/community/rural health center'
             12 'Local/state hlth dept;social/human servcs; unspcfd'
             13 'School/college/univ health services; govt unspecfd'
             15 'WIC/Suppl Nutrition Prgm Women, Infants,& Children'
             16 'Sliding scale/subsidized health care; unspecified'
             17 'Non-Medicaid state govt low-income health assistnc'
             19 'Social Security; type unspecified'
             20 'Workman''s Compensation'
             21 'Welfare/social welfare; not otherwise specified'
             22 'State Health program; type unspecified'
             23 'Other gov''t coverage, not classified elsewhere'
             60 'Private ins provider; govt affiliation unspecified'
             61 'Civilian govt employee private health insurance'
             62 'Health care coverage outside of the US'
             63 'Medical/health care/wellness coverage; unspecified'
             65 'Private, not-for-profit foundation'
             70 'Non-health care insurance coverage'
             72 'Supplemental Social Income (SSI)'
             73 'Other non-gov''t insurance/not a type of insurance'
             985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP (OGOVTINS=2)' /
   PRVHLTIN  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   GRPHLTIN  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP (PRVHLTIN = 2)' /
   HLTINALC  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP (PRVHLTIN = 2)' /
   HLTINDRG  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP (PRVHLTIN = 2)' /
   HLTINMNT  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP (PRVHLTIN = 2)' /
   OTHLTINS  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   OTHLINS2  1 'Medicare' 2 'Medicaid or Medical Assistance'
             3 'Military Health Care (CHAMPUS, TRICARE, VA)'
             4 'Private health insurance'
             5 'Public Health Service/Indian health hospital/clinc'
             6 'Health care coverage outside of USA'
             7 'School/sport-related health care coverage'
             8 'Non-government medical assistance'
             9 'Temp Assistance for Needy Families; formerly AFDC'
             10 'Dental/vision/prescription/chiro/alt med insurance'
             13 'Cancer/heart insurance coverage'
             14 'Long term/nursing home care insurance'
             15 'Hospitalization/catastrophic/major illness insurnc'
             17 'Local/state hlth dept;social.human servcs; unspcfd'
             18 'Medical/insurance; type unspecified'
             19 'SCHIP (State Children''s Health Insurance Plan)'
             20 'Family member coverage; type unspecified'
             21 'Secondary/supplemental insurance; private unspecfd'
             22 'Employee Assistance Program'
             23 'State health program; type unspecified'
             25 'Sliding scale/subsidized health care; unspecified'
             30 'Foreign exchange student program insurance'
             31 'Accident/injury insurance'
             32 'Other health insurance, not classified elsewhere'
             50 'All types/combined/other; hlth ins coverage unspcd'
             60 'Non-health care insurance/coverage'
             985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP (OTHLTINS=2)' /
   HLCNOTYR  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLCNOTMO  94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   HLCLAST   1 'Within the past 6 months'
             2 'More than 6 months ago, but within the past year'
             3 'More than 1 year ago, but within the past 3 years'
             4 'More than 3 years ago' 5 'Never had coverage'
             11 'Within the past 6 months (see NOTE)'
             12 'More than 6 mos ago but w/in pst yr (see NOTE)'
             13 'More than 1 yr ago but w/in pst 3 yr (see NOTE)'
             14 'More than 3 years ago (see NOTE)'
             15 'Never had coverage (see NOTE)' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLCPRIVT  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLCMCAID  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLCMILT   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLCMCARE  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLCOGOVT  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLCOTHER  1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLCOTHS2  1 'Private health insurance' 2 'Medicaid or medical assistance'
             4 'Medicare' 5 'Some other government program'
             6 'Some other kind of coverage'
             8 'Health care coverage outside of USA'
             9 'School/sport-related health care coverage'
             11 'Medical, type unspecified' 14 'Workman''s compensation'
             60 'Paid out of pocket' 61 'Does not have medical insurance'
             90 'NEVER HAD HEALTH CARE COVERAGE'
             985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   HLLLOSJB  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLLMAJOB  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             11 'Response entered (potl incons w/last coverage)'
             13 'Response entered LOG ASSN (potl incons)' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLLMASOR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered'
             11 'Response entered (potl incons w/last coverage)'
             13 'Response entered LOG ASSN (potl incons)' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLLCOST   1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLLINELG  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLLNOFFR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLLDIVOR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLLDEATH  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLLREFUS  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLLNONED  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLLSOR    1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLLSORS2  1 'Person in family w/ ins lost job/chngd employers'
             2 'Lost Medicaid or med assist cov b/c new job/income'
             3 'Lost Medicaid or med assist cov for other reason'
             4 'Cost is too high/can''t afford premiums'
             5 'Became ineligible b/c of age or leaving school'
             6 'Employer doesn''t offer cov/not eligible for cov'
             7 'Got divorced or separated from person w/ ins'
             8 'Death of spouse or parent'
             9 'Insurance company refused coverage' 10 'Don''t need it'
             11 'Some other reason'
             12 'Have not applied or reapplied for ins coverage'
             13 'Applied ins/Medicaid,waiting for activation/eligib'
             14 'Ineligible b/c moved out of parents home/got marri'
             15 'Don''t know how to obtain/trying to obtain'
             16 'Non-us citizen' 19 'Self-employed/parents self-employed'
             20 'Dissatisfied with previous/available coverage'
             22 'Had ins in another country before moving to US'
             23 'Moved/don''t have same coverage'
             24 'Parents/guardians got divorced/separated'
             25 'Don''t qualify, no reason specified'
             26 'Dropped coverage, no reason specified'
             28 'Don''t qualify for partner''s/family member''s policy'
             32 'Ineligible, some other reason'
             35 'Too complicated to get health insurance coverage'
             39 'Employer/respondent is changing insurance plans'
             41 'Parent/guardian doesn''t/won''t provide coverage'
             42 'Ins co didn''t receive payment/paperwork in time'
             44 'Student/becoming stdnt(elg for oth cov unk)'
             45 'Ineligible because part-time student'
             90 'CURRENTLY COVERED BY HEALTH INSURANCE'
             985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   HLNVCOST  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLNVOFFR  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLNVREF   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLNVNEED  1 'Response entered' 3 'Response entered LOGICALLY ASSIGNED'
             6 'Response not entered' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLNVSOR   1 'Response entered' 6 'Response not entered' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HLNVSP2   1 'Cost is too high/can''t afford premiums'
             2 'Employer doesn''t offer cov/not eligible for cov'
             4 'Don''t need it' 5 'Some other reason'
             7 'Have never applied for/thought about ins covrg'
             8 'Religious beliefs/don''t trust medical prof/ins co'
             9 'Didn''t know available or how to obtain ins'
             10 'Currently looking for insurance coverage'
             12 'Non-US citizen' 14 'Prefer to pay cash'
             15 'Never had insurance, no reason specified'
             16 'Parent/guardian don''t/won''t provide coverage'
             17 'Ineligible, other reasons'
             90 'CURRENTLY COVERED BY HEALTH INSURANCE'
             91 'ASSISTANCE PROVIDED BY CHURCH/COMMUNITY'
             92 'HAVE BEEN COVERED BY HEALTH INSURANCE IN PAST'
             985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   IRPINSUR  1 'Yes, respondent does have private health insurance'
             2 'No, respondent does not have private health insur' /
   IIPINSUR  1 'Questionnaire data' 3 'Statistically imputed data' /
   IRINSUR   1 'Yes, respondent does have health insurance'
             2 'No, respondent does not have health insurance' /
   IIINSUR   1 'Questionnaire data' 3 'Statistically imputed data' /
   IRINSUR2  1 'Yes, respondent does have health insurance'
             2 'No, respondent does not have health insurance' /
   IIINSUR2  1 'Questionnaire data' 3 'Statistically imputed data' /
   LANGVER   1 'English' 2 'Spanish' 98 'BLANK (NO ANSWER)' /
   QUARTER   1 'Quarter 1' 2 'Quarter 2' 3 'Quarter 3' 4 'Quarter 4' /
   GQTYPE    -9 'Not a Group Quarter' 1 'Halfway House' 2 'Boarding House'
             3 'College Dorm' 4 'Shelter' 5 'Other' /
   AGE2      1 'Respondent is 12 years old' 2 'Respondent is 13 years old'
             3 'Respondent is 14 years old' 4 'Respondent is 15 years old'
             5 'Respondent is 16 years old' 6 'Respondent is 17 years old'
             7 'Respondent is 18 years old' 8 'Respondent is 19 years old'
             9 'Respondent is 20 years old' 10 'Respondent is 21 years old'
             11 'Respondent is 22 or 23 years old'
             12 'Respondent is 24 or 25 years old'
             13 'Respondent is between 26 and 29 years old'
             14 'Respondent is between 30 and 34 years old'
             15 'Respondent is between 35 and 49 years old'
             16 'Respondent is between 50 and 64 years old'
             17 'Respondent is 65 years old or older' /
   NOMARR2   1 'One time' 2 'Two or more times' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SERVICE   1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             99 'LEGITIMATE SKIP' /
   MILSTAT   2 'In a reserves component'
             3 'Now separated/retired from reserves/active duty'
             94 'DON''T KNOW' 97 'REFUSED' 99 'LEGITIMATE SKIP' /
   HEALTH    1 'Excellent' 2 'Very good' 3 'Good' 4 'Fair' 5 'Poor'
             94 'DON''T KNOW' 97 'REFUSED' /
   IRSEX     1 'Male' 2 'Female' /
   IISEX     1 'Sex from questionnaire' 2 'Sex from screener' /
   IRMARIT   1 'Married' 2 'Widowed' 3 'Divorced or Separated'
             4 'Never Been Married'
             99 'LEGITIMATE SKIP Respondent is <= 14 years old' /
   IIMARIT   1 'Marital status from questionnaire'
             3 'Marital status statistically imputed'
             9 'LEGITIMATE SKIP Respondent is <= 14 years old' /
   IREDUC2   1 'Fifth grade or less' 2 'Sixth grade' 3 'Seventh grade'
             4 'Eighth grade' 5 'Ninth grade' 6 'Tenth grade'
             7 'Eleventh grade' 8 'Twelfth grade' 9 'Freshman/13th year'
             10 'Sophomore/14th year or Junior/15th year'
             11 'Senior/16th year or GradProf School (or higher)' /
   IIEDUC2   1 'Education from questionnaire'
             3 'Education statistically imputed' /
   EMPSTAT3  1 'Employed full time' 2 'Employed part time' 3 'Unemployed'
             4 'Other' 5 '12-17 year olds' /
   IIEMPST3  1 'Employment status from questionnaire'
             3 'Employment statistically imputed' 4 '12-17 years old' /
   EMPSTATY  1 'Employed full time' 2 'Employed part time' 3 'Unemployed'
             4 'Other (incl. not in labor force)' 5 '12-14 year olds' /
   IIEMPSTY  1 'Employment status from questionnaire'
             3 'Employment statistically imputed' 4 '12-14 years old' /
   EMPSTAT4  1 'Employed full time' 2 'Employed part time' 3 'Unemployed'
             4 'Other (incl. not in labor force)' 5 '12-17 year olds' /
   IIEMPST4  1 'Employment status from questionnaire'
             3 'Employment statistically imputed' 4 '12-17 years old' /
   MOVESPY2  0 'None' 1 'One time' 2 'Two times' 3 'Three or more times'
             994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)' /
   ENROLED   1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED (LFSCHWH2=777,778)'
             5 'Yes LOGICALLY ASSIGNED (LFSCHWH2=601)'
             11 'Yes (SCHDSKIP = 30)'
             52 'Summer interview (not enrolled & HSDIPLMA=4)'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   EDUCNOW2  1 '5th Grade or lower' 2 '6th Grade' 3 '7th Grade' 4 '8th Grade'
             5 '9th Grade' 6 '10th Grade' 7 '11th Grade' 8 '12th Grade'
             9 'College or university/1st year'
             10 'College or university/2nd Year, 3rd year'
             11 'College or university/4th Year, 5th or higher year'
             12 'Missing' 13 'LEGITIMATE SKIP' /
   STUDNT    1 'FULL-TIME' 2 'PART-TIME' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SCHDSICK  0 'None' 85 'BAD DATA Logically assigned'
             90 'SCHOOL NOT IN SESSION' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   SCHDSKIP  0 'None' 94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   HSDIPLMA  1 'Yes' 2 'No' 3 'Yes LOG ASSN' 4 'No LOGICALLY ASSIGNED'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   HSGED     1 'Yes' 2 'No' 3 'Yes LOG ASSN (LFSCHWH2=606)'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   LFSCHWH2  1 'School was boring or I didn''t want to be there'
             2 'I got pregnant'
             3 'I got in trouble or expelled for selling drugs'
             4 'I got in trouble or expelled for using drugs'
             5 'I got in trouble or expelled for some other reason'
             6 'I often got into trouble'
             7 'I had to get a job (or work more hours)'
             8 'I was getting bad grades' 9 'I wasn''t learning anything'
             10 'I got married (or moved in with my boy/girlfriend)'
             11 'I moved here from another country/didn''t enroll'
             12 'I was treated badly at school'
             13 'I became ill (or injured)' 14 'I went to jail/prison'
             15 'I had responsibilities at home/personal problems'
             16 'Other reason' 41 'Family member became ill/sick/died'
             42 'I wasn''t admitted/couldn''t attend school of choice'
             43 'Parents/guardian/partner wouldn''t allow me to'
             44 'Ran away from/put out of/placed out of home'
             45 'Too stressful/couldn''t adjust' 46 'Learning disabled'
             50 'Moved away/didn''t re-enroll'
             51 'Skipping school/excessive absenteeism'
             52 'Too expensive/couldn''t afford'
             54 'No transportation/school too far away'
             56 'Grade,credit discrepancies/lacked credits/document'
             58 'All the schooling/preferred that was available'
             59 'Wasn''t required/didn''t have to/not needed/customs'
             60 'Against my religion/beliefs' 63 'I was stupid/foolish'
             66 'Too old' 67 'Wanted to work/do apprenticeship instead'
             69 'Just quit; reason unspecified'
             71 'Didn''t pass/take end of grade/school test'
             73 'Held back/school didn''t think I was capable'
             601 'Home schooled'
             602 'Went to technical school/community college'
             605 'Completed HS/certificate, general' 606 'Received GED'
             607 'Pursuing GED/proficiency exam/re-enrolling'
             777 'Summer/school not in session' 778 'I am still in school'
             985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   LFTSCHA2  10 'Left at age 10 or younger' 19 'Left at age 19 or older'
             985 'BAD DATA Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   RLGSVCYR  1 '0 times' 2 '1 to 2 times' 3 '3 to 5 times' 4 '6 to 24 times'
             5 '25 to 52 times' 6 'More than 52 times' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RLGIMPRT  1 'Strongly disagree' 2 'Disagree' 3 'Agree' 4 'Strongly agree'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RLGDECSN  1 'Strongly disagree' 2 'Disagree' 3 'Agree' 4 'Strongly agree'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   RLGFRNDS  1 'Strongly disagree' 2 'Disagree' 3 'Agree' 4 'Strongly agree'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)' /
   TELNO2    0 'None' 1 'One' 2 'Two or more' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' /
   TUCHTONE  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   COLLEGE2  -9 'Unknwn Enrollment, Aged 18-22(ENROLED=94,97,98)'
             1 'Full-Time College Student Aged 18-22'
             2 'Part-Time College Student Aged 18-22'
             3 'Not Enrolled (ENROLED=2)' 4 'Others Persons Aged 18-22'
             5 'Persons Aged 12-17, or 23 or Older' /
   CATAGE    1 '12-17 Years Old' 2 '18-25 Years Old' 3 '26-34 Years Old'
             4 '35 or Older' /
   CATAG2    1 '12-17 Years Old' 2 '18-25 Years Old' 3 '26 or Older' /
   CATAG3    1 '12-17 Years Old' 2 '18-25 Years Old' 3 '26-34 Years Old'
             4 '35-49 Years Old' 5 '50 or Older' /
   CATAG7    1 '12-13 Years Old' 2 '14-15 Years Old' 3 '16-17 Years Old'
             4 '18-20 Years Old' 5 '21-25 Years Old' 6 '26-34 Years Old'
             7 '35 or Older' /
   NEWRACE2  1 'NonHisp White' 2 'NonHisp Black/Afr Am'
             3 'NonHisp Native Am/AK Native'
             4 'NonHisp Native HI/Other Pac Isl' 5 'NonHisp Asian'
             6 'NonHisp more than one race' 7 'Hispanic' /
   EDUCCAT2  1 'Less than high school' 2 'High school graduate'
             3 'Some college' 4 'College graduate'
             5 '12 to 17 year olds (1<=AGE2<=6)' /
   JOBSTAT2  1 'Worked at full-time job, past week'
             2 'Worked at part time job, past week'
             3 'Has job or volunteer worker, did not work past wk'
             4 'Unemployed/on layoff, looking for work' 5 'Disabled'
             6 'Keeping house full-time' 7 'In school/training' 8 'Retired'
             9 'Does not have a job, some other reason' 10 'MISSING'
             11 'LEGITIMATE SKIP' /
   JBSTATR2  1 'Worked at full-time job, past week'
             2 'Worked at part time job, past week'
             3 'Has job or volunteer worker, did not work past wk'
             4 'Unemployed/on layoff, looking for work' 5 'Disabled'
             6 'Keeping house full-time' 7 'In school/training' 8 'Retired'
             9 'Does not have a job, some other reason' 10 'MISSING'
             11 'LEGITIMATE SKIP' /
   WRKHAVJB  1 'Yes' 2 'No' 89 'LEGITIMATE SKIP Logically assigned'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   WRKHRSWK  994 'DON''T KNOW' 997 'REFUSED' 998 'BLANK (NO ANSWER)'
             999 'LEGITIMATE SKIP' /
   WRKINDU2  1 'Agriculture, Forestry, and Fisheries' 2 'Mining'
             3 'Construction' 4 'Manufacturing - Nondurable Goods'
             5 'Manufacturing - Durable Goods'
             6 'Trans/Commun/and Other Public Utilities'
             7 'Wholesale Trade - Durable Goods'
             8 'Wholesale Trade - Nondurable Goods' 9 'Retail Trade'
             10 'Finance, Insurance, and Real Estate'
             11 'Business and Repair Services' 12 'Personal Services'
             13 'Entertainment and Recreation Services'
             14 'Professional and Related Services'
             15 'Public Administration' 16 'Military Duty'
             985 'BAD DATA Logically assigned'
             992 'Last worked 1984 or earlier' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   WRKOCCU2  1 'Executive/Administrative/Managerial Occupations'
             2 'Professional Specialty Occupations'
             3 'Technicians and Related Support Occupations'
             4 'Sales Occupations'
             5 'Administrative Support Occupations, Inc Clerical'
             6 'Private Household Occupations'
             7 'Protective Service Occupations'
             8 'Service Occups, Except Protective/Private Househol'
             9 'Farming, Forestry, and Fishing occupations'
             10 'Mechanics and repairers' 11 'Construction trades'
             12 'Extractive Occupations'
             13 'Machine Operators, Assemblers, and Inspectors'
             14 'Transportation and Material Moving Occupations'
             15 'Handlers/Equipment Cleaners/Helpers/Laborers' 16 'Military'
             909 'Last worked 1984 or earlier'
             985 'BAD DATA Logically assigned' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   WRKBZCA2  1 'Private for-profit company or business'
             2 'Private not-for-profit company or business'
             3 'Local government (city, county, etc.)' 4 'State government'
             5 'Federal/Foreign government or international'
             6 'Self-employed in an incorporated business'
             7 'Self-employed in an unincorporated business'
             8 'Working without pay in a family business/farm'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   WRKEFFRT  1 'Yes' 2 'No' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   WRKEDYR   1 'Yes' 2 'No' 85 'BAD DATA Logically assigned'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   WRKSLFEM  1 'Yes' 2 'No' 3 'Yes LOGICALLY ASSIGNED (raw var not blank)'
             5 'Yes LOGICALLY ASSIGNED (from skip pattern)'
             89 'LEGITIMATE SKIP Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   WRKJOBS2  1 'One' 2 'Two' 3 'Three' 4 'Four or more'
             975 'At least one LOGICALLY ASSIGNED'
             989 'LEGITIMATE SKIP Logically assigned' 994 'DON''T KNOW'
             997 'REFUSED' 998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   WRKUNEMP  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   WRKUNWKS  85 'BAD DATA Logically assigned' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   WRKLASY2  1960 '1960 or earlier' 9985 'BAD DATA Logically assigned'
             9989 'LEGITIMATE SKIP Logically assigned'
             9991 'NEVER WORKED FOR PAY' 9994 'DON''T KNOW' 9997 'REFUSED'
             9998 'BLANK (NO ANSWER)' 9999 'LEGITIMATE SKIP' /
   WRKINDY2  1 'Agriculture, Forestry, and Fisheries' 2 'Mining'
             3 'Construction' 4 'Manufacturing - Nondurable Goods'
             5 'Manufacturing - Durable Goods'
             6 'Trans/Commun/and Other Public Utilities'
             7 'Wholesale Trade - Durable Goods'
             8 'Wholesale Trade - Nondurable Goods' 9 'Retail Trade'
             10 'Finance, Insurance, and Real Estate'
             11 'Business and Repair Services' 12 'Personal Services'
             13 'Entertainment and Recreation Services'
             14 'Professional and Related Services'
             15 'Public Administration' 16 'Military Duty'
             985 'BAD DATA Logically assigned'
             989 'LEGITIMATE SKIP Logically assigned'
             992 'Last worked 1984 or earlier' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   WRKOCCY2  1 'Executive/Administrative/Managerial Occupations'
             2 'Professional Specialty Occupations'
             3 'Technicians and Related Support Occupations'
             4 'Sales Occupations'
             5 'Administrative Support Occupations, Inc Clerical'
             6 'Private Household Occupations'
             7 'Protective Service Occupations'
             8 'Service Occups, Except Protective/Private Househol'
             9 'Farming, Forestry, and Fishing occupations'
             10 'Mechanics and repairers' 11 'Construction trades'
             12 'Extractive Occupations'
             13 'Machine Operators, Assemblers, and Inspectors'
             14 'Transportation and Material Moving Occupations'
             15 'Handlers/Equipment Cleaners/Helpers/Laborers' 16 'Military'
             909 'Last worked 1984 or earlier'
             985 'BAD DATA Logically assigned'
             989 'LEGITIMATE SKIP Logically assigned' 997 'REFUSED'
             998 'BLANK (NO ANSWER)' 999 'LEGITIMATE SKIP' /
   WORKDAYS  0 'None' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   WORKBLAH  0 'None' 85 'BAD DATA Logically assigned' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   LOCSIZE   1 'Less than 10 people' 2 '10-24 people' 3 '25-99 people'
             4 '100-499 people' 5 '500 people or more' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   DRGPLCY   1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   PLCYCOV   1 'Only alcohol' 2 'Only drugs' 3 'Both alcohol and drugs'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   WKDRGED   1 'Yes' 2 'No' 3 'Don''t remember' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   DRGPRGM   1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   USALCTST  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   USDRGTST  1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TSTHIRE   1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   TSTRAND   1 'Yes' 2 'No' 94 'DON''T KNOW' 97 'REFUSED'
             98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   FIRSTPOS  1 'Handled on indiv basis/policy does not spec what'
             2 'Employee is fired'
             3 'Employee is referred for treatment or counseling'
             4 'Nothing happens' 5 'Something else happens' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   WRKHIRE   1 'More likely' 2 'Less likely'
             3 'Would it make no difference to you' 94 'DON''T KNOW'
             97 'REFUSED' 98 'BLANK (NO ANSWER)' 99 'LEGITIMATE SKIP' /
   WORKRAND  1 'More likely' 2 'Less likely' 3 'Would make no difference'
             94 'DON''T KNOW' 97 'REFUSED' 98 'BLANK (NO ANSWER)'
             99 'LEGITIMATE SKIP' /
   FIEXP99   1 'Yes' 2 'No' /
   PDEN      1 'Segment in a MSA with 1 million or more persons'
             2 'Segment in a MSA with fewer than 1 million persons'
             3 'Segment not in a MSA' /
   .

* SPSS MISSING VALUES COMMAND.

* MISSING VALUES
   CIGOFRSM (81 THRU HI)
   CIGWILYR (81 THRU HI)
   CIGTRY (981 THRU HI)
   CIGYFU (9981 THRU HI)
   CIGMFU (81 THRU HI)
   CIGREC (81 THRU HI)
   CIG30USE (81 THRU HI)
   CG30EST (81 THRU HI)
   CIG30AV (81 THRU HI)
   CIG30BR2 (9981 THRU HI)
   CIG30TYP (81 THRU HI)
   CIG30MEN (81 THRU HI)
   CIG30RO2 (81 THRU HI)
   CIGDLYMO (81 THRU HI)
   CIGAGE (981 THRU HI)
   CIG100LF (81 THRU HI)
   CHEWEVER (81 THRU HI)
   CHEWTRY (981 THRU HI)
   CHEWYFU (9981 THRU HI)
   CHEWMFU (81 THRU HI)
   CHEWREC (81 THRU HI)
   CHW30USE (81 THRU HI)
   CH30EST (81 THRU HI)
   CHW30BR2 (9981 THRU HI)
   SNFEVER (81 THRU HI)
   SNUFTRY (981 THRU HI)
   SNUFYFU (9981 THRU HI)
   SNUFMFU (81 THRU HI)
   SNFREC (81 THRU HI)
   SNF30USE (81 THRU HI)
   SN30EST (81 THRU HI)
   SNF30BR2 (9981 THRU HI)
   SLTTRY (981 THRU HI)
   SLTYFU (9981 THRU HI)
   SLTMFU (81 THRU HI)
   SLTREC (81 THRU HI)
   SLT30BR2 (9981 THRU HI)
   SLT30FAV (81 THRU HI)
   CIGAREVR (81 THRU HI)
   CIGARTRY (981 THRU HI)
   CIGARYFU (9981 THRU HI)
   CIGARMFU (81 THRU HI)
   CIGARREC (81 THRU HI)
   CGR30USE (81 THRU HI)
   CI30EST (81 THRU HI)
   CGR30BR2 (9981 THRU HI)
   PIPEVER (81 THRU HI)
   PIPE30DY (81 THRU HI)
   ALCEVER (81 THRU HI)
   ALCTRY (981 THRU HI)
   ALCYFU (9981 THRU HI)
   ALCMFU (81 THRU HI)
   ALCREC (81 THRU HI)
   ALCYRTOT (981 THRU HI)
   ALTOTFG (81 THRU HI)
   ALFQFLG (81 THRU HI)
   ALBSTWAY (81 THRU HI)
   ALDAYPYR (981 THRU HI)
   ALDAYPMO (81 THRU HI)
   ALDAYPWK (81 THRU HI)
   ALCDAYS (81 THRU HI)
   AL30EST (81 THRU HI)
   ALDYSFG (81 THRU HI)
   NODR30A (981 THRU HI)
   DR5DAY (80 THRU HI)
   MJEVER (81 THRU HI)
   MJAGE (981 THRU HI)
   MJYFU (9981 THRU HI)
   MJMFU (81 THRU HI)
   MJREC (81 THRU HI)
   MJYRTOT (981 THRU HI)
   MRTOTFG (81 THRU HI)
   MJFQFLG (81 THRU HI)
   MRBSTWAY (81 THRU HI)
   MRDAYPYR (981 THRU HI)
   MRDAYPMO (81 THRU HI)
   MRDAYPWK (81 THRU HI)
   MJDAY30A (81 THRU HI)
   MR30EST (81 THRU HI)
   COCEVER (81 THRU HI)
   COCAGE (981 THRU HI)
   COCYFU (9981 THRU HI)
   COCMFU (81 THRU HI)
   COCREC (81 THRU HI)
   COCYRTOT (981 THRU HI)
   CCTOTFG (81 THRU HI)
   CCFQFLG (81 THRU HI)
   CCBSTWAY (81 THRU HI)
   CCDAYPYR (981 THRU HI)
   CCDAYPMO (81 THRU HI)
   CCDAYPWK (81 THRU HI)
   COCUS30A (81 THRU HI)
   CC30EST (81 THRU HI)
   CRKEVER (81 THRU HI)
   CRKAGE (981 THRU HI)
   CRKYFU (9981 THRU HI)
   CRKMFU (81 THRU HI)
   CRAKREC (81 THRU HI)
   CRKYRTOT (981 THRU HI)
   CRTOTFG (81 THRU HI)
   CRFQFLG (81 THRU HI)
   CRBSTWAY (81 THRU HI)
   CRDAYPYR (981 THRU HI)
   CRDAYPMO (81 THRU HI)
   CRDAYPWK (81 THRU HI)
   CRKUS30A (81 THRU HI)
   CR30EST (81 THRU HI)
   HEREVER (81 THRU HI)
   HERAGE (981 THRU HI)
   HERYFU (9981 THRU HI)
   HERMFU (81 THRU HI)
   HERREC (81 THRU HI)
   HERYRTOT (981 THRU HI)
   HRTOTFG (81 THRU HI)
   HRFQFLG (81 THRU HI)
   HRBSTWAY (81 THRU HI)
   HRDAYPYR (981 THRU HI)
   HRDAYPMO (81 THRU HI)
   HRDAYPWK (81 THRU HI)
   HER30USE (81 THRU HI)
   HR30EST (81 THRU HI)
   LSD (81 THRU HI)
   PCP (81 THRU HI)
   PEYOTE (81 THRU HI)
   MESC (81 THRU HI)
   PSILCY (81 THRU HI)
   ECSTASY (81 THRU HI)
   HALNOLST (81 THRU HI)
   HALNEWA (9981 THRU HI)
   HALNEWB (9981 THRU HI)
   HALNEWC (9981 THRU HI)
   HALNEWD (9981 THRU HI)
   HALNEWE (9981 THRU HI)
   HALLAGE (981 THRU HI)
   HALYFU (9981 THRU HI)
   HALMFU (81 THRU HI)
   HALLREC (81 THRU HI)
   HALYRTOT (981 THRU HI)
   HLTOTFG (81 THRU HI)
   HLFQFLG (81 THRU HI)
   HLBSTWAY (81 THRU HI)
   HLDAYPYR (981 THRU HI)
   HLDAYPMO (81 THRU HI)
   HLDAYPWK (81 THRU HI)
   HAL30USE (81 THRU HI)
   HL30EST (81 THRU HI)
   LSDAGE (981 THRU HI)
   LSDYFU (9981 THRU HI)
   LSDMFU (81 THRU HI)
   LSDREC (81 THRU HI)
   PCPAGE (981 THRU HI)
   PCPYFU (9981 THRU HI)
   PCPMFU (81 THRU HI)
   PCPREC (81 THRU HI)
   AMYLNIT (81 THRU HI)
   CLEFLU (81 THRU HI)
   GAS (81 THRU HI)
   GLUE (81 THRU HI)
   ETHER (81 THRU HI)
   SOLVENT (81 THRU HI)
   LGAS (81 THRU HI)
   NITOXID (81 THRU HI)
   SPPAINT (81 THRU HI)
   AEROS (81 THRU HI)
   INHNOLST (81 THRU HI)
   INHNEWA (9981 THRU HI)
   INHNEWB (9981 THRU HI)
   INHNEWC (9981 THRU HI)
   INHNEWD (9981 THRU HI)
   INHNEWE (9981 THRU HI)
   INHAGE (981 THRU HI)
   INHYFU (9981 THRU HI)
   INHMFU (81 THRU HI)
   INHREC (81 THRU HI)
   INHYRTOT (981 THRU HI)
   INTOTFG (81 THRU HI)
   INFQFLG (81 THRU HI)
   INBSTWAY (81 THRU HI)
   INDAYPYR (981 THRU HI)
   INDAYPMO (81 THRU HI)
   INDAYPWK (81 THRU HI)
   INHDY30A (81 THRU HI)
   IN30EST (81 THRU HI)
   DARVTYLC (81 THRU HI)
   PERCTYLX (81 THRU HI)
   VICOLOR (81 THRU HI)
   ANLCARD (81 THRU HI)
   CODEINE (81 THRU HI)
   DEMEROL (81 THRU HI)
   DILAUD (81 THRU HI)
   FIORICET (81 THRU HI)
   FIORINAL (81 THRU HI)
   HYDROCOD (81 THRU HI)
   METHDON (81 THRU HI)
   MORPHINE (81 THRU HI)
   OXYCONTN (81 THRU HI)
   PHENCOD (81 THRU HI)
   PROPOXY (81 THRU HI)
   SK65A (81 THRU HI)
   STADOL (81 THRU HI)
   TALACEN (81 THRU HI)
   TALWIN (81 THRU HI)
   TALWINNX (81 THRU HI)
   TRAMADOL (81 THRU HI)
   ULTRAM (81 THRU HI)
   ANLNOLST (81 THRU HI)
   ANALNEWA (9981 THRU HI)
   ANALNEWB (9981 THRU HI)
   ANALNEWC (9981 THRU HI)
   ANALNEWD (9981 THRU HI)
   ANALNEWE (9981 THRU HI)
   ANALAGE (981 THRU HI)
   ANALYFU (9981 THRU HI)
   ANALMFU (81 THRU HI)
   ANALREC (81 THRU HI)
   ANLYRTOT (981 THRU HI)
   PRTOTFG (81 THRU HI)
   PRFQFLG (81 THRU HI)
   PRBSTWAY (81 THRU HI)
   PRDAYPYR (981 THRU HI)
   PRDAYPMO (81 THRU HI)
   PRDAYPWK (81 THRU HI)
   KLONOPIN (81 THRU HI)
   XNAXATVN (81 THRU HI)
   VALMDIAZ (81 THRU HI)
   TRNCARD (81 THRU HI)
   ATARAX (81 THRU HI)
   BUSPAR (81 THRU HI)
   EQUANIL (81 THRU HI)
   FLEXERIL (81 THRU HI)
   LIBRIUM (81 THRU HI)
   LIMBTROL (81 THRU HI)
   MEPROB (81 THRU HI)
   MILTOWN (81 THRU HI)
   ROHYPNOL (81 THRU HI)
   SERAX (81 THRU HI)
   SOMA (81 THRU HI)
   TRANXENE (81 THRU HI)
   VISTAR (81 THRU HI)
   TRNOLST (81 THRU HI)
   TRNEWA (9981 THRU HI)
   TRNEWB (9981 THRU HI)
   TRNEWC (9981 THRU HI)
   TRNEWD (9981 THRU HI)
   TRNEWE (9981 THRU HI)
   TRANAGE (981 THRU HI)
   TRANYFU (9981 THRU HI)
   TRANMFU (81 THRU HI)
   TRANREC (81 THRU HI)
   TRNYRTOT (981 THRU HI)
   TRTOTFG (81 THRU HI)
   TRFQFLG (81 THRU HI)
   TRBSTWAY (81 THRU HI)
   TRDAYPYR (981 THRU HI)
   TRDAYPMO (81 THRU HI)
   TRDAYPWK (81 THRU HI)
   METHDES (81 THRU HI)
   DIETPILS (81 THRU HI)
   RITMPHEN (81 THRU HI)
   STMCARD (81 THRU HI)
   CYLERT (81 THRU HI)
   DEXED (81 THRU HI)
   DETAMP (81 THRU HI)
   DIDREX (81 THRU HI)
   ESKAT (81 THRU HI)
   IONAMIN (81 THRU HI)
   MAZANOR (81 THRU HI)
   OBLA (81 THRU HI)
   PLEGINE (81 THRU HI)
   PRELUDIN (81 THRU HI)
   SANOREX (81 THRU HI)
   TENUATE (81 THRU HI)
   STMNOLST (81 THRU HI)
   STIMNEWA (9981 THRU HI)
   STIMNEWB (9981 THRU HI)
   STIMNEWC (9981 THRU HI)
   STIMNEWD (9981 THRU HI)
   STIMNEWE (9981 THRU HI)
   STIMAGE (981 THRU HI)
   STIMYFU (9981 THRU HI)
   STIMMFU (81 THRU HI)
   STIMREC (81 THRU HI)
   STMYRTOT (981 THRU HI)
   STTOTFG (81 THRU HI)
   STFQFLG (81 THRU HI)
   STBSTWAY (81 THRU HI)
   STDAYPYR (981 THRU HI)
   STDAYPMO (81 THRU HI)
   STDAYPWK (81 THRU HI)
   METHAGE (981 THRU HI)
   METHYFU (9981 THRU HI)
   METHMFU (81 THRU HI)
   METHREC (81 THRU HI)
   METHAQ (81 THRU HI)
   NEMBBARB (81 THRU HI)
   RESTTMAZ (81 THRU HI)
   SEDCARD (81 THRU HI)
   AMYTAL (81 THRU HI)
   BUTISOL (81 THRU HI)
   CHHYD (81 THRU HI)
   DALMANE (81 THRU HI)
   HALCION (81 THRU HI)
   PHENOBAR (81 THRU HI)
   PLACIDYL (81 THRU HI)
   TUINAL (81 THRU HI)
   SEDNOLST (81 THRU HI)
   SEDNEWA (9981 THRU HI)
   SEDNEWB (9981 THRU HI)
   SEDNEWC (9981 THRU HI)
   SEDNEWD (9981 THRU HI)
   SEDNEWE (9981 THRU HI)
   SEDAGE (981 THRU HI)
   SEDYFU (9981 THRU HI)
   SEDMFU (81 THRU HI)
   SEDREC (81 THRU HI)
   SEDYRTOT (981 THRU HI)
   SVTOTFG (81 THRU HI)
   SVFQFLG (81 THRU HI)
   SVBSTWAY (81 THRU HI)
   SVDAYPYR (981 THRU HI)
   SVDAYPMO (81 THRU HI)
   SVDAYPWK (81 THRU HI)
   IRCIGRC (9)
   IRCGRRC (9)
   IRPIPLF (9)
   IRPIPMN (9)
   IRSLTRC (9)
   IRCHWRC (9)
   IRSNFRC (9)
   IRALCRC (9)
   IRMJRC (9)
   IRCOCRC (9)
   IRCRKRC (9)
   IRHERRC (9)
   IRHALRC (9)
   IRLSDRC (9)
   IRPCPRC (9)
   IRINHRC (9)
   IRANLRC (9)
   IRTRNRC (9)
   IRSTMRC (9)
   IRMTHRC (9)
   IRSEDRC (9)
   IRALCFY (981 THRU HI)
   IRMJFY (981 THRU HI)
   IRCOCFY (981 THRU HI)
   IRCRKFY (981 THRU HI)
   IRHERFY (981 THRU HI)
   IRHALFY (981 THRU HI)
   IRINHFY (981 THRU HI)
   IRANLFY (981 THRU HI)
   IRTRNFY (981 THRU HI)
   IRSTMFY (981 THRU HI)
   IRSEDFY (981 THRU HI)
   IRCIGFM (81.00 THRU HI)
   IRCGRFM (81.00 THRU HI)
   IRCHWFM (81.00 THRU HI)
   IRSNFFM (81.00 THRU HI)
   IRALCFM (81.00 THRU HI)
   IRALCD5 (81 THRU HI)
   IRMJFM (81.00 THRU HI)
   IRCOCFM (81.00 THRU HI)
   IRCRKFM (81.00 THRU HI)
   IRHERFM (81 THRU HI)
   IRHALFM (81.00 THRU HI)
   IRINHFM (81.00 THRU HI)
   IRCIGAGE (981 THRU HI)
   IRCIGYFU (9981 THRU HI)
   IRCDUAGE (981 THRU HI)
   IICDUAGE (9)
   IRCDUYFU (9981 THRU HI)
   IRCGRAGE (981 THRU HI)
   IRCGRYFU (9981 THRU HI)
   IRSNFAGE (981 THRU HI)
   IRSNFYFU (9981 THRU HI)
   IRCHWAGE (981 THRU HI)
   IRCHWYFU (9981 THRU HI)
   IRSLTAGE (981 THRU HI)
   IRSLTYFU (9981 THRU HI)
   IRALCAGE (981 THRU HI)
   IRALCYFU (9981 THRU HI)
   IRMJAGE (981 THRU HI)
   IRMJYFU (9981 THRU HI)
   IRCOCAGE (981 THRU HI)
   IRCOCYFU (9981 THRU HI)
   IRCRKAGE (981 THRU HI)
   IRCRKYFU (9981 THRU HI)
   IRHERAGE (981 THRU HI)
   IRHERYFU (9981 THRU HI)
   IRHALAGE (981 THRU HI)
   IRHALYFU (9981 THRU HI)
   IRLSDAGE (981 THRU HI)
   IRLSDYFU (9981 THRU HI)
   IRPCPAGE (981 THRU HI)
   IRPCPYFU (9981 THRU HI)
   IRINHAGE (981 THRU HI)
   IRINHYFU (9981 THRU HI)
   IRANLAGE (981 THRU HI)
   IRANLYFU (9981 THRU HI)
   IRTRNAGE (981 THRU HI)
   IRTRNYFU (9981 THRU HI)
   IRSTMAGE (981 THRU HI)
   IRSTMYFU (9981 THRU HI)
   IRMTHAGE (981 THRU HI)
   IRMTHYFU (9981 THRU HI)
   IRSEDAGE (981 THRU HI)
   IRSEDYFU (9981 THRU HI)
   CIGBRND2 (-9)
   CGRBRND2 (-9)
   SMKBRND2 (-9)
   CIGCMPNY (81 THRU HI)
   ALCAFU (4)
   MJAFU (4)
   COCAFU (4)
   HERAFU (4)
   HALAFU (4)
   INHAFU (4)
   ANLAFU (4)
   TRNAFU (4)
   STMAFU (4)
   SEDAFU (4)
   CIGAFU (4)
   CGRAFU (4)
   SLTAFU (4)
   MRJYDAYS (6)
   COCYDAYS (6)
   HALYDAYS (6)
   INHYDAYS (6)
   ALCYDAYS (6)
   MRJMDAYS (6)
   COCMDAYS (6)
   HALMDAYS (6)
   INHMDAYS (6)
   ALCMDAYS (6)
   CIGMDAYS (6)
   CIGPDAY (6)
   CG05 (81 THRU HI)
   CG06 (81 THRU HI)
   CG06DK (81 THRU HI)
   CG06RE (81 THRU HI)
   CG19 (81 THRU HI)
   CG20 (81 THRU HI)
   CG20DK (81 THRU HI)
   CG20RE (81 THRU HI)
   CG27 (81 THRU HI)
   CG28 (81 THRU HI)
   CG28DK (81 THRU HI)
   CG28RE (81 THRU HI)
   CG36 (81 THRU HI)
   CG37 (81 THRU HI)
   CG37DK (81 THRU HI)
   CG37RE (81 THRU HI)
   CG43 (81 THRU HI)
   ALLAST3 (81 THRU HI)
   ALRECDK (81 THRU HI)
   ALRECRE (81 THRU HI)
   TOTDRINK (981 THRU HI)
   ALFRAME3 (81 THRU HI)
   ALYRAVE (981 THRU HI)
   ALMONAVE (81 THRU HI)
   ALWKAVE (81 THRU HI)
   MJLAST3 (81 THRU HI)
   MJRECDK (81 THRU HI)
   MJRECRE (81 THRU HI)
   TOTMJ (981 THRU HI)
   MJFRAME3 (81 THRU HI)
   MJYRAVE (981 THRU HI)
   MJMONAVE (81 THRU HI)
   MJWKAVE (81 THRU HI)
   CCLAST3 (81 THRU HI)
   CCRECDK (81 THRU HI)
   CCRECRE (81 THRU HI)
   TOTCOKE (981 THRU HI)
   CCFRAME3 (81 THRU HI)
   CCYRAVE (981 THRU HI)
   CCMONAVE (81 THRU HI)
   CCWKAVE (81 THRU HI)
   CKLAST3 (81 THRU HI)
   CKRECDK (81 THRU HI)
   CKRECRE (81 THRU HI)
   TOTCRACK (981 THRU HI)
   CKFRAME3 (81 THRU HI)
   CKYRAVE (981 THRU HI)
   CKMONAVE (81 THRU HI)
   CKWKAVE (81 THRU HI)
   HELAST3 (81 THRU HI)
   HERECDK (81 THRU HI)
   HERECRE (81 THRU HI)
   TOTHERO (981 THRU HI)
   HEFRAME3 (81 THRU HI)
   HEYRAVE (981 THRU HI)
   HEMONAVE (81 THRU HI)
   HEWKAVE (81 THRU HI)
   LSLAST (81 THRU HI)
   LSRECDK (81 THRU HI)
   LSRECRE (81 THRU HI)
   TOTHALL (981 THRU HI)
   LSFRAME3 (81 THRU HI)
   LSYRAVE (981 THRU HI)
   LSMONAVE (81 THRU HI)
   LSWKAVE (81 THRU HI)
   LS10 (81 THRU HI)
   LS16 (81 THRU HI)
   INLAST (81 THRU HI)
   INRECDK (81 THRU HI)
   INRECRE (81 THRU HI)
   TOTINHAL (981 THRU HI)
   INFRAME3 (81 THRU HI)
   INYRAVE (981 THRU HI)
   INMONAVE (81 THRU HI)
   INWKAVE (81 THRU HI)
   PR09 (81 THRU HI)
   PRRECDK (81 THRU HI)
   PRRECRE (81 THRU HI)
   PR10 (81 THRU HI)
   PR11 (981 THRU HI)
   PR12 (81 THRU HI)
   PR13 (81 THRU HI)
   TR09 (81 THRU HI)
   TRRECDK (81 THRU HI)
   TRRECRE (81 THRU HI)
   TR10 (81 THRU HI)
   TR11 (981 THRU HI)
   TR12 (81 THRU HI)
   TR13 (81 THRU HI)
   ST09 (81 THRU HI)
   STRECDK (81 THRU HI)
   STRECRE (81 THRU HI)
   ST10 (81 THRU HI)
   ST11 (981 THRU HI)
   ST12 (81 THRU HI)
   ST13 (81 THRU HI)
   ST19 (81 THRU HI)
   SV09 (81 THRU HI)
   SVRECDK (81 THRU HI)
   SVRECRE (81 THRU HI)
   SV10 (81 THRU HI)
   SV11 (981 THRU HI)
   SV12 (81 THRU HI)
   SV13 (81 THRU HI)
   HERSMOKE (81 THRU HI)
   HRSMKREC (81 THRU HI)
   HERSNIFF (81 THRU HI)
   HRSNFREC (81 THRU HI)
   GNNDLLIF (81 THRU HI)
   COCNEEDL (81 THRU HI)
   CONDLREC (81 THRU HI)
   HERNEEDL (81 THRU HI)
   HRNDLREC (81 THRU HI)
   STNEEDLE (81 THRU HI)
   STNDLREC (81 THRU HI)
   GNNDREUS (81 THRU HI)
   GNNDLSH1 (81 THRU HI)
   GNNDCLEN (81 THRU HI)
   GNNDLSH2 (81 THRU HI)
   GNNDGET2 (81 THRU HI)
   NEDLRECC (81 THRU HI)
   RSKPKCIG (81 THRU HI)
   RSKMJOCC (81 THRU HI)
   RSKMJREG (81 THRU HI)
   RKTRYLSD (81 THRU HI)
   RKLSDREG (81 THRU HI)
   RKTRYHER (81 THRU HI)
   RKHERREG (81 THRU HI)
   RKCOCOCC (81 THRU HI)
   RKCOCREG (81 THRU HI)
   RK5ALDLY (81 THRU HI)
   RK5ALWK (81 THRU HI)
   RSKDIFMJ (81 THRU HI)
   RKDIFLSD (81 THRU HI)
   RKDIFCOC (81 THRU HI)
   RKDIFCRK (81 THRU HI)
   RKDIFHER (81 THRU HI)
   RSKSELL (81 THRU HI)
   RKFQDNGR (81 THRU HI)
   RKFQRSKY (81 THRU HI)
   RKFQPBLT (81 THRU HI)
   RKFQDBLT (81 THRU HI)
   GRSKPKCG (-9)
   GRSKCREG (-9)
   GRSKCOCC (-9)
   GRSKMREG (-9)
   GRSKMOCC (-9)
   GRSKHTRY (-9)
   GRSKHREG (-9)
   GRSKLTRY (-9)
   GRSKLREG (-9)
   GRSKD4_5 (-9)
   GRSKD5WK (-9)
   RDIFMJ (-9)
   RDIFCOC (-9)
   RDIFHER (-9)
   RDIFLSD (-9)
   RDIFCRK (-9)
   APPSELDG (-9)
   CIGLOTTM (81 THRU HI)
   CIGLIMIT (81 THRU HI)
   CIGKPLMT (81 THRU HI)
   CIGNDMOR (81 THRU HI)
   CIGLSEFX (81 THRU HI)
   CIGCUTDN (81 THRU HI)
   CIGCUTEV (81 THRU HI)
   CIGCUT1X (81 THRU HI)
   CIGWD4SX (81 THRU HI)
   CIGWDSMT (81 THRU HI)
   CIGEMOPB (81 THRU HI)
   CIGEMCTD (81 THRU HI)
   CIGPHLPB (81 THRU HI)
   CIGPHCTD (81 THRU HI)
   CIGLSACT (81 THRU HI)
   CIGPKCRT (81 THRU HI)
   CIGPDPAK (81 THRU HI)
   CIGPDCRT (81 THRU HI)
   ALCLOTTM (81 THRU HI)
   ALCGTOVR (81 THRU HI)
   ALCLIMIT (81 THRU HI)
   ALCKPLMT (81 THRU HI)
   ALCNDMOR (81 THRU HI)
   ALCLSEFX (81 THRU HI)
   ALCCUTDN (81 THRU HI)
   ALCCUTEV (81 THRU HI)
   ALCCUT1X (81 THRU HI)
   ALCWD2SX (81 THRU HI)
   ALCWDSMT (81 THRU HI)
   ALCEMOPB (81 THRU HI)
   ALCEMCTD (81 THRU HI)
   ALCPHLPB (81 THRU HI)
   ALCPHCTD (81 THRU HI)
   ALCLSACT (81 THRU HI)
   ALCSERPB (81 THRU HI)
   ALCPDANG (81 THRU HI)
   ALCLAWTR (81 THRU HI)
   ALCFMFPB (81 THRU HI)
   ALCFMCTD (81 THRU HI)
   MRJLOTTM (81 THRU HI)
   MRJGTOVR (81 THRU HI)
   MRJLIMIT (81 THRU HI)
   MRJKPLMT (81 THRU HI)
   MRJNDMOR (81 THRU HI)
   MRJLSEFX (81 THRU HI)
   MRJCUTDN (81 THRU HI)
   MRJCUTEV (81 THRU HI)
   MRJEMOPB (81 THRU HI)
   MRJEMCTD (81 THRU HI)
   MRJPHLPB (81 THRU HI)
   MRJPHCTD (81 THRU HI)
   MRJLSACT (81 THRU HI)
   MRJSERPB (81 THRU HI)
   MRJPDANG (81 THRU HI)
   MRJLAWTR (81 THRU HI)
   MRJFMFPB (81 THRU HI)
   MRJFMCTD (81 THRU HI)
   COCLOTTM (81 THRU HI)
   COCGTOVR (81 THRU HI)
   COCLIMIT (81 THRU HI)
   COCKPLMT (81 THRU HI)
   COCNDMOR (81 THRU HI)
   COCLSEFX (81 THRU HI)
   COCCUTDN (81 THRU HI)
   COCCUTEV (81 THRU HI)
   COCCUT1X (81 THRU HI)
   COCFLBLU (81 THRU HI)
   COCWD2SX (81 THRU HI)
   COCWDSMT (81 THRU HI)
   COCEMOPB (81 THRU HI)
   COCEMCTD (81 THRU HI)
   COCPHLPB (81 THRU HI)
   COCPHCTD (81 THRU HI)
   COCLSACT (81 THRU HI)
   COCSERPB (81 THRU HI)
   COCPDANG (81 THRU HI)
   COCLAWTR (81 THRU HI)
   COCFMFPB (81 THRU HI)
   COCFMCTD (81 THRU HI)
   HERLOTTM (81 THRU HI)
   HERGTOVR (81 THRU HI)
   HERLIMIT (81 THRU HI)
   HERKPLMT (81 THRU HI)
   HERNDMOR (81 THRU HI)
   HERLSEFX (81 THRU HI)
   HERCUTDN (81 THRU HI)
   HERCUTEV (81 THRU HI)
   HERCUT1X (81 THRU HI)
   HERWD3SX (81 THRU HI)
   HERWDSMT (81 THRU HI)
   HEREMOPB (81 THRU HI)
   HEREMCTD (81 THRU HI)
   HERPHLPB (81 THRU HI)
   HERPHCTD (81 THRU HI)
   HERLSACT (81 THRU HI)
   HERSERPB (81 THRU HI)
   HERPDANG (81 THRU HI)
   HERLAWTR (81 THRU HI)
   HERFMFPB (81 THRU HI)
   HERFMCTD (81 THRU HI)
   HALLOTTM (81 THRU HI)
   HALGTOVR (81 THRU HI)
   HALLIMIT (81 THRU HI)
   HALKPLMT (81 THRU HI)
   HALNDMOR (81 THRU HI)
   HALLSEFX (81 THRU HI)
   HALCUTDN (81 THRU HI)
   HALCUTEV (81 THRU HI)
   HALEMOPB (81 THRU HI)
   HALEMCTD (81 THRU HI)
   HALPHLPB (81 THRU HI)
   HALPHCTD (81 THRU HI)
   HALLSACT (81 THRU HI)
   HALSERPB (81 THRU HI)
   HALPDANG (81 THRU HI)
   HALLAWTR (81 THRU HI)
   HALFMFPB (81 THRU HI)
   HALFMCTD (81 THRU HI)
   INHLOTTM (81 THRU HI)
   INHGTOVR (81 THRU HI)
   INHLIMIT (81 THRU HI)
   INHKPLMT (81 THRU HI)
   INHNDMOR (81 THRU HI)
   INHLSEFX (81 THRU HI)
   INHCUTDN (81 THRU HI)
   INHCUTEV (81 THRU HI)
   INHEMOPB (81 THRU HI)
   INHEMCTD (81 THRU HI)
   INHPHLPB (81 THRU HI)
   INHPHCTD (81 THRU HI)
   INHLSACT (81 THRU HI)
   INHSERPB (81 THRU HI)
   INHPDANG (81 THRU HI)
   INHLAWTR (81 THRU HI)
   INHFMFPB (81 THRU HI)
   INHFMCTD (81 THRU HI)
   ANLLOTTM (81 THRU HI)
   ANLGTOVR (81 THRU HI)
   ANLLIMIT (81 THRU HI)
   ANLKPLMT (81 THRU HI)
   ANLNDMOR (81 THRU HI)
   ANLLSEFX (81 THRU HI)
   ANLCUTDN (81 THRU HI)
   ANLCUTEV (81 THRU HI)
   ANLCUT1X (81 THRU HI)
   ANLWD3SX (81 THRU HI)
   ANLWDSMT (81 THRU HI)
   ANLEMOPB (81 THRU HI)
   ANLEMCTD (81 THRU HI)
   ANLPHLPB (81 THRU HI)
   ANLPHCTD (81 THRU HI)
   ANLLSACT (81 THRU HI)
   ANLSERPB (81 THRU HI)
   ANLPDANG (81 THRU HI)
   ANLLAWTR (81 THRU HI)
   ANLFMFPB (81 THRU HI)
   ANLFMCTD (81 THRU HI)
   TRNLOTTM (81 THRU HI)
   TRNGTOVR (81 THRU HI)
   TRNLIMIT (81 THRU HI)
   TRNKPLMT (81 THRU HI)
   TRNNDMOR (81 THRU HI)
   TRNLSEFX (81 THRU HI)
   TRNCUTDN (81 THRU HI)
   TRNCUTEV (81 THRU HI)
   TRNEMOPB (81 THRU HI)
   TRNEMCTD (81 THRU HI)
   TRNPHLPB (81 THRU HI)
   TRNPHCTD (81 THRU HI)
   TRNLSACT (81 THRU HI)
   TRNSERPB (81 THRU HI)
   TRNPDANG (81 THRU HI)
   TRNLAWTR (81 THRU HI)
   TRNFMFPB (81 THRU HI)
   TRNFMCTD (81 THRU HI)
   STMLOTTM (81 THRU HI)
   STMGTOVR (81 THRU HI)
   STMLIMIT (81 THRU HI)
   STMKPLMT (81 THRU HI)
   STMNDMOR (81 THRU HI)
   STMLSEFX (81 THRU HI)
   STMCUTDN (81 THRU HI)
   STMCUTEV (81 THRU HI)
   STMCUT1X (81 THRU HI)
   STMFLBLU (81 THRU HI)
   STMWD2SX (81 THRU HI)
   STMWDSMT (81 THRU HI)
   STMEMOPB (81 THRU HI)
   STMEMCTD (81 THRU HI)
   STMPHLPB (81 THRU HI)
   STMPHCTD (81 THRU HI)
   STMLSACT (81 THRU HI)
   STMSERPB (81 THRU HI)
   STMPDANG (81 THRU HI)
   STMLAWTR (81 THRU HI)
   STMFMFPB (81 THRU HI)
   STMFMCTD (81 THRU HI)
   SEDLOTTM (81 THRU HI)
   SEDGTOVR (81 THRU HI)
   SEDLIMIT (81 THRU HI)
   SEDKPLMT (81 THRU HI)
   SEDNDMOR (81 THRU HI)
   SEDLSEFX (81 THRU HI)
   SEDCUTDN (81 THRU HI)
   SEDCUTEV (81 THRU HI)
   SEDCUT1X (81 THRU HI)
   SEDWD1SX (81 THRU HI)
   SEDWDSMT (81 THRU HI)
   SEDEMOPB (81 THRU HI)
   SEDEMCTD (81 THRU HI)
   SEDPHLPB (81 THRU HI)
   SEDPHCTD (81 THRU HI)
   SEDLSACT (81 THRU HI)
   SEDSERPB (81 THRU HI)
   SEDPDANG (81 THRU HI)
   SEDLAWTR (81 THRU HI)
   SEDFMFPB (81 THRU HI)
   SEDFMCTD (81 THRU HI)
   BOOKED (81 THRU HI)
   NOBOOKY2 (981 THRU HI)
   BKMVTHFT (81 THRU HI)
   BKLARCNY (81 THRU HI)
   BKBURGL (81 THRU HI)
   BKAGASLT (81 THRU HI)
   BKSMASLT (81 THRU HI)
   BKROB (81 THRU HI)
   BKRAPE (81 THRU HI)
   BKMURDER (81 THRU HI)
   BKARSON (81 THRU HI)
   BKDRVINF (81 THRU HI)
   BKDRUNK (81 THRU HI)
   BKPOSTOB (81 THRU HI)
   BKDRUG (81 THRU HI)
   BKPROS (81 THRU HI)
   BKSEXOFF (81 THRU HI)
   BKFRAUD (81 THRU HI)
   BKOTH (81 THRU HI)
   BKOTHOF2 (81 THRU HI)
   PROBATON (81 THRU HI)
   PAROLREL (81 THRU HI)
   DRVALDR (81 THRU HI)
   DRVAONLY (81 THRU HI)
   DRVDONLY (81 THRU HI)
   DRIVALC (3 THRU HI)
   DRIVDRG (3 THRU HI)
   DRIVALD (3 THRU HI)
   PAROL (-9)
   PROB (-9)
   TXEVER (81 THRU HI)
   TXYREVER (81 THRU HI)
   TXYRADG (81 THRU HI)
   TXYRHOSP (81 THRU HI)
   TXYRHPAD (81 THRU HI)
   TXYRRFIN (81 THRU HI)
   TXYRINAD (81 THRU HI)
   TXYRRFOP (81 THRU HI)
   TXYRPOAD (81 THRU HI)
   TXYRMHC (81 THRU HI)
   TXYRMHAD (81 THRU HI)
   TXYRTXER (81 THRU HI)
   TXYRERAD (81 THRU HI)
   TXYRDOC (81 THRU HI)
   TXYRDCAD (81 THRU HI)
   TXYRJAIL (81 THRU HI)
   TXYRJLAD (81 THRU HI)
   TXYRSHG (81 THRU HI)
   TXYRSGAD (81 THRU HI)
   TXYRSOP (81 THRU HI)
   TXYROTS2 (981 THRU HI)
   TXYROTAD (81 THRU HI)
   TXYRVSER (81 THRU HI)
   TXYRNME2 (981 THRU HI)
   TXRCVNOW (81 THRU HI)
   NDTXNEDR (81 THRU HI)
   NDTXMORE (81 THRU HI)
   NDTMRALC (81 THRU HI)
   NDTMRMJ (81 THRU HI)
   NDTMRCOC (81 THRU HI)
   NDTMRHER (81 THRU HI)
   NDTMRHAL (81 THRU HI)
   NDTMRINH (81 THRU HI)
   NDTMRANL (81 THRU HI)
   NDTMRTRN (81 THRU HI)
   NDTMRSTM (81 THRU HI)
   NDTMRSED (81 THRU HI)
   NDTMROTH (81 THRU HI)
   NDTXALCR (81 THRU HI)
   NDTXMJR (81 THRU HI)
   NDTXCOCR (81 THRU HI)
   NDTXHERR (81 THRU HI)
   NDTXHALR (81 THRU HI)
   NDTXINHR (81 THRU HI)
   NDTXANLR (81 THRU HI)
   NDTXTRNR (81 THRU HI)
   NDTXSTMR (81 THRU HI)
   NDTXSEDR (81 THRU HI)
   NDTXSODR (81 THRU HI)
   NDTXDG1R (9981 THRU HI)
   NDTXDG2R (9981 THRU HI)
   NDTXDG3R (9981 THRU HI)
   NDTXDG4R (9981 THRU HI)
   NDTXDG5R (9981 THRU HI)
   NDTXEFTR (81 THRU HI)
   NDTMREFT (81 THRU HI)
   TXLASREC (81 THRU HI)
   TXLTYMN2 (981 THRU HI)
   TXLTYALC (81 THRU HI)
   TXLTYMJ (81 THRU HI)
   TXLTYCOC (81 THRU HI)
   TXLTYHER (81 THRU HI)
   TXLTYHAL (81 THRU HI)
   TXLTYINH (81 THRU HI)
   TXLTYANL (81 THRU HI)
   TXLTYTRN (81 THRU HI)
   TXLTYSTM (81 THRU HI)
   TXLTYSED (81 THRU HI)
   TXLTYSOD (81 THRU HI)
   TXLTYOU2 (81 THRU HI)
   TXLTYDU2 (99981 THRU HI)
   TXPYINS (81 THRU HI)
   TXPYCARE (81 THRU HI)
   TXPYCAID (81 THRU HI)
   TXPYPUBP (81 THRU HI)
   TXPYSAVE (81 THRU HI)
   TXPYFMLY (81 THRU HI)
   TXPYCORT (81 THRU HI)
   TXPYMILC (81 THRU HI)
   TXPYEMPL (81 THRU HI)
   TXPYSOS (81 THRU HI)
   TXPYSP2 (81 THRU HI)
   TXPYFRE (81 THRU HI)
   TXENROLL (81 THRU HI)
   TXYRDTXO (81 THRU HI)
   AUINPYR (81 THRU HI)
   AUINPSYH (81 THRU HI)
   AUINPGEN (81 THRU HI)
   AUINMEDU (81 THRU HI)
   AUINAHSP (81 THRU HI)
   AUINRESD (81 THRU HI)
   AUINSFAC (81 THRU HI)
   AUNMPSY2 (981 THRU HI)
   AUNMPGE2 (981 THRU HI)
   AUNMMEDU (981 THRU HI)
   AUNMAHSP (981 THRU HI)
   AUNMRESD (981 THRU HI)
   AUNMSFA2 (981 THRU HI)
   AUPINSLF (81 THRU HI)
   AUPINOFM (81 THRU HI)
   AUPINPHI (81 THRU HI)
   AUPINMCR (81 THRU HI)
   AUPINMCD (81 THRU HI)
   AUPINREH (81 THRU HI)
   AUPINEMP (81 THRU HI)
   AUPINMIL (81 THRU HI)
   AUPINPUB (81 THRU HI)
   AUPINPRV (81 THRU HI)
   AUPINFRE (81 THRU HI)
   AUPINAMT (81 THRU HI)
   AUOPTYR (81 THRU HI)
   AUOPMENT (81 THRU HI)
   AUOPTHER (81 THRU HI)
   AUOPDOC (81 THRU HI)
   AUOPCLNC (81 THRU HI)
   AUOPDTMT (81 THRU HI)
   AUOPOTOP (81 THRU HI)
   AUOPYRS2 (81 THRU HI)
   AUNMMEN2 (981 THRU HI)
   AUNMTHE2 (981 THRU HI)
   AUNMDOC2 (981 THRU HI)
   AUNMCLN2 (981 THRU HI)
   AUNMDTM2 (981 THRU HI)
   AUNMOTO2 (981 THRU HI)
   AUPOPSLF (81 THRU HI)
   AUPOPOFM (81 THRU HI)
   AUPOPPHI (81 THRU HI)
   AUPOPMCR (81 THRU HI)
   AUPOPMCD (81 THRU HI)
   AUPOPREH (81 THRU HI)
   AUPOPEMP (81 THRU HI)
   AUPOPMIL (81 THRU HI)
   AUPOPPUB (81 THRU HI)
   AUPOPPRV (81 THRU HI)
   AUPOPFRE (81 THRU HI)
   AUPOPMOS (81 THRU HI)
   AUPOPAMT (81 THRU HI)
   AURXYR (81 THRU HI)
   AUUNMTYR (81 THRU HI)
   AUUNMTRS (81 THRU HI)
   AMHINP (3 THRU HI)
   AMHOUTP (3 THRU HI)
   AMHRX (3 THRU HI)
   AMHTXREC (3 THRU HI)
   AMHTRTND (3 THRU HI)
   SNCRIME (81 THRU HI)
   SNSELLDG (81 THRU HI)
   SNPPVAL (81 THRU HI)
   SNSTFGT (81 THRU HI)
   SNEMTBLD (81 THRU HI)
   SNPPHLP (81 THRU HI)
   SNGRAFTI (81 THRU HI)
   SNPPVSIT (81 THRU HI)
   SNPPMOVE (81 THRU HI)
   SNMOV5Y2 (981 THRU HI)
   SNSPOUSE (81 THRU HI)
   SNSPACTV (81 THRU HI)
   SNSPANGR (81 THRU HI)
   SNSPHITU (81 THRU HI)
   SNYHITSP (81 THRU HI)
   SNSPCRIT (81 THRU HI)
   SNSPCONC (81 THRU HI)
   SNFRCONC (81 THRU HI)
   SNFRACTV (81 THRU HI)
   SNFRCARE (81 THRU HI)
   SNYSELL (81 THRU HI)
   SNYSTOLE (81 THRU HI)
   SNYATTAK (81 THRU HI)
   SNFACIG (81 THRU HI)
   SNFAMJEV (81 THRU HI)
   SNFAALDY (81 THRU HI)
   SNFAALDV (81 THRU HI)
   YECRIME (81 THRU HI)
   YESELLDG (81 THRU HI)
   YEPPHLP (81 THRU HI)
   YESTFGT (81 THRU HI)
   YEEMTBLD (81 THRU HI)
   YEPPVSIT (81 THRU HI)
   YEGRAFTI (81 THRU HI)
   YEPPMOVE (81 THRU HI)
   YEMOV5Y2 (981 THRU HI)
   YEENRLYR (81 THRU HI)
   YELSTGRD (81 THRU HI)
   YEYFGTSW (81 THRU HI)
   YEYFGTGP (81 THRU HI)
   YEYHGUN (81 THRU HI)
   YEYSELL (81 THRU HI)
   YEYSTOLE (81 THRU HI)
   YEYATTAK (81 THRU HI)
   YEPPKCIG (81 THRU HI)
   YEPMJEVR (81 THRU HI)
   YEPALDLY (81 THRU HI)
   YEGPKCIG (81 THRU HI)
   YEGMJEVR (81 THRU HI)
   YEGALDLY (81 THRU HI)
   YETLKNON (81 THRU HI)
   YETLKPAR (81 THRU HI)
   YETLKSOP (81 THRU HI)
   YEPRTDNG (81 THRU HI)
   YEBIGBRO (81 THRU HI)
   YEPRBSLV (81 THRU HI)
   YEVIOPRV (81 THRU HI)
   YEYMCA (81 THRU HI)
   YESCOUTS (81 THRU HI)
   YEPRVLES (81 THRU HI)
   YEDGPRGP (81 THRU HI)
   YETEMSPT (81 THRU HI)
   YE4HCLUB (81 THRU HI)
   YESLFHLP (81 THRU HI)
   YEBAND (81 THRU HI)
   YESCHCLB (81 THRU HI)
   YEVOLUNT (81 THRU HI)
   YESTGOVT (81 THRU HI)
   YEPRGSTD (81 THRU HI)
   YEJBSKIL (81 THRU HI)
   YECHOIR (81 THRU HI)
   YEDECLAS (81 THRU HI)
   YEDERGLR (81 THRU HI)
   YEDESPCL (81 THRU HI)
   YEPVNTYR (81 THRU HI)
   YECGFRND (81 THRU HI)
   YECGVEND (81 THRU HI)
   YECGMAI2 (81 THRU HI)
   YECGCHKO (81 THRU HI)
   YECGCLRK (81 THRU HI)
   YECGINET (81 THRU HI)
   YECGSMKT (81 THRU HI)
   YECGDSTO (81 THRU HI)
   YECGCONV (81 THRU HI)
   YECGINDV (81 THRU HI)
   YECGPRUF (81 THRU HI)
   YECGSUCC (81 THRU HI)
   YEPKCRTN (81 THRU HI)
   YEPDPACK (81 THRU HI)
   YEPDCRTN (81 THRU HI)
   YEBLNTEV (81 THRU HI)
   YEBLNT30 (81 THRU HI)
   YEBL30FQ (81 THRU HI)
   YECGRWMJ (81 THRU HI)
   NGHCRIM2 (-9)
   NGHSELL2 (-9)
   NGHHELP2 (-9)
   NGHFGHT2 (-9)
   NGHBLDG2 (-9)
   NGHVSIT2 (-9)
   NGHGRAF2 (-9)
   NGHMOVE2 (-9)
   MVIN5YR2 (-9)
   PRPKCIG2 (-9)
   PRMJEVR2 (-9)
   PRALDLY2 (-9)
   PRTALK3 (-9)
   YOFIGHT2 (-9)
   YOGRPFT2 (-9)
   YOHGUN2 (-9)
   YOSELL2 (-9)
   YOSTOLE2 (-9)
   YOATTAK2 (-9)
   YFLPKCG2 (-9)
   YFLTMRJ2 (-9)
   YFLADLY2 (-9)
   YOUTHACT (-9)
   PRBSOLV2 (-9)
   PREVIOL2 (-9)
   PRVDRGO2 (-9)
   GRPCNSL2 (-9)
   PREGPGM2 (-9)
   DGSPCLS2 (-9)
   DGRGCLS2 (-9)
   DRGLECT2 (-9)
   DRPRVME3 (-9)
   ANYEDUC3 (-9)
   YMSPGRUP (81 THRU HI)
   YMSPFNTP (81 THRU HI)
   YMSAHOME (81 THRU HI)
   YMSAACHE (81 THRU HI)
   YMSABDRM (81 THRU HI)
   YMSASLEP (81 THRU HI)
   YMSAABDN (81 THRU HI)
   YMSAUPLV (81 THRU HI)
   YMSAHMSK (81 THRU HI)
   YMAGOHSF (81 THRU HI)
   YMAGCRWD (81 THRU HI)
   YMAGTRAV (81 THRU HI)
   YMAGBRDG (81 THRU HI)
   YMPAATAK (81 THRU HI)
   YMPASUFC (81 THRU HI)
   YMGAWORY (81 THRU HI)
   YMGAHDAC (81 THRU HI)
   YMGAPAIN (81 THRU HI)
   YMGATNSE (81 THRU HI)
   YMPHANML (81 THRU HI)
   YMPHHIGH (81 THRU HI)
   YMPHDARK (81 THRU HI)
   YMPHNEDL (81 THRU HI)
   YMPHBLOD (81 THRU HI)
   YMPHBRDG (81 THRU HI)
   YMPHELEV (81 THRU HI)
   YMOCCOUN (81 THRU HI)
   YMOCWASH (81 THRU HI)
   YMOCCHCK (81 THRU HI)
   YMOCGERM (81 THRU HI)
   YMOCTHOT (81 THRU HI)
   YMEATHIN (81 THRU HI)
   YMEAFAT (81 THRU HI)
   YMEATHFD (81 THRU HI)
   YMEABING (81 THRU HI)
   YMELWTBD (81 THRU HI)
   YMELWTPT (81 THRU HI)
   YMELSOIL (81 THRU HI)
   YMMDNINT (81 THRU HI)
   YMMDLSEG (81 THRU HI)
   YMMDNOGD (81 THRU HI)
   YMMDTHKL (81 THRU HI)
   YMMDTYKL (81 THRU HI)
   YMMDTIRD (81 THRU HI)
   YMMDTHNK (81 THRU HI)
   YMMABDMD (81 THRU HI)
   YMMARSLS (81 THRU HI)
   YMMATALK (81 THRU HI)
   YMMASPAB (81 THRU HI)
   YMMAMDRC (81 THRU HI)
   YMADCONC (81 THRU HI)
   YMADFRGT (81 THRU HI)
   YMADFCUS (81 THRU HI)
   YMADMEDS (81 THRU HI)
   YMADAVAT (81 THRU HI)
   YMADERRO (81 THRU HI)
   YMODHURT (81 THRU HI)
   YMODRFUS (81 THRU HI)
   YMODANOY (81 THRU HI)
   YMODMEAN (81 THRU HI)
   YMODBLMO (81 THRU HI)
   YMODTANY (81 THRU HI)
   YMODSWOR (81 THRU HI)
   YMCDEXPL (81 THRU HI)
   YMCDSHPL (81 THRU HI)
   YMCDLIED (81 THRU HI)
   YMCDSNAT (81 THRU HI)
   YMCDVAND (81 THRU HI)
   YMCDSTOL (81 THRU HI)
   YMCDCRUA (81 THRU HI)
   YMCDBKNT (81 THRU HI)
   YUHOSPYR (81 THRU HI)
   YUHOSPN2 (981 THRU HI)
   YUHOSUIC (81 THRU HI)
   YUHODEPR (81 THRU HI)
   YUHOFEAR (81 THRU HI)
   YUHOBKRU (81 THRU HI)
   YUHOEATP (81 THRU HI)
   YUHOSOR (81 THRU HI)
   YURSIDYR (81 THRU HI)
   YURSIDN2 (981 THRU HI)
   YURSSUIC (81 THRU HI)
   YURSDEPR (81 THRU HI)
   YURSFEAR (81 THRU HI)
   YURSBKRU (81 THRU HI)
   YURSEATP (81 THRU HI)
   YURSSOR (81 THRU HI)
   YUFCARYR (81 THRU HI)
   YUFCARN2 (981 THRU HI)
   YUFCSUIC (81 THRU HI)
   YUFCDEPR (81 THRU HI)
   YUFCFEAR (81 THRU HI)
   YUFCBKRU (81 THRU HI)
   YUFCEATP (81 THRU HI)
   YUFCSOR (81 THRU HI)
   YUDYTXYR (81 THRU HI)
   YUDYTXN2 (981 THRU HI)
   YUDYSUIC (81 THRU HI)
   YUDYDEPR (81 THRU HI)
   YUDYFEAR (81 THRU HI)
   YUDYBKRU (81 THRU HI)
   YUDYEATP (81 THRU HI)
   YUDYSOR (81 THRU HI)
   YUMHCRYR (81 THRU HI)
   YUMHCRN2 (981 THRU HI)
   YUMHSUIC (81 THRU HI)
   YUMHDEPR (81 THRU HI)
   YUMHFEAR (81 THRU HI)
   YUMHBKRU (81 THRU HI)
   YUMHEATP (81 THRU HI)
   YUMHSOR (81 THRU HI)
   YUTPSTYR (81 THRU HI)
   YUTPSTN2 (981 THRU HI)
   YUTPSUIC (81 THRU HI)
   YUTPDEPR (81 THRU HI)
   YUTPFEAR (81 THRU HI)
   YUTPBKRU (81 THRU HI)
   YUTPEATP (81 THRU HI)
   YUTPSOR (81 THRU HI)
   YUIHTPYR (81 THRU HI)
   YUIHTPN2 (981 THRU HI)
   YUIHSUIC (81 THRU HI)
   YUIHDEPR (81 THRU HI)
   YUIHFEAR (81 THRU HI)
   YUIHBKRU (81 THRU HI)
   YUIHEATP (81 THRU HI)
   YUIHSOR (81 THRU HI)
   YUFDOCYR (81 THRU HI)
   YUFDOCN2 (981 THRU HI)
   YUFDSUIC (81 THRU HI)
   YUFDDEPR (81 THRU HI)
   YUFDFEAR (81 THRU HI)
   YUFDBKRU (81 THRU HI)
   YUFDEATP (81 THRU HI)
   YUFDSOR (81 THRU HI)
   YUSPEDYR (81 THRU HI)
   YUSHCNYR (81 THRU HI)
   YUSHSUIC (81 THRU HI)
   YUSHDEPR (81 THRU HI)
   YUSHFEAR (81 THRU HI)
   YUSHBKRU (81 THRU HI)
   YUSHEATP (81 THRU HI)
   YUSHSOR (81 THRU HI)
   YUJAILEV (81 THRU HI)
   YUFCAREV (81 THRU HI)
   NRCH17_2 (-9)
   PREGNANT (81 THRU HI)
   NMERTMT2 (981 THRU HI)
   INHOSPYR (81 THRU HI)
   NMNGTHS2 (981 THRU HI)
   PROXANS2 (81 THRU HI)
   PREG2 (-9)
   TRIMEST (-9)
   IRWELMOS (81 THRU HI)
   IIWELMOS (9)
   HLCALLFG (81 THRU HI)
   HLCALL99 (81 THRU HI)
   MEDICARE (81 THRU HI)
   MEDICAID (81 THRU HI)
   CHAMPUS (81 THRU HI)
   OGOVTINS (81 THRU HI)
   OGOVINS2 (981 THRU HI)
   PRVHLTIN (81 THRU HI)
   GRPHLTIN (81 THRU HI)
   HLTINALC (81 THRU HI)
   HLTINDRG (81 THRU HI)
   HLTINMNT (81 THRU HI)
   OTHLTINS (81 THRU HI)
   OTHLINS2 (981 THRU HI)
   HLCNOTYR (81 THRU HI)
   HLCNOTMO (81 THRU HI)
   HLCLAST (81 THRU HI)
   HLCPRIVT (81 THRU HI)
   HLCMCAID (81 THRU HI)
   HLCMILT (81 THRU HI)
   HLCMCARE (81 THRU HI)
   HLCOGOVT (81 THRU HI)
   HLCOTHER (81 THRU HI)
   HLCOTHS2 (90 THRU HI)
   HLLLOSJB (81 THRU HI)
   HLLMAJOB (81 THRU HI)
   HLLMASOR (81 THRU HI)
   HLLCOST (81 THRU HI)
   HLLINELG (81 THRU HI)
   HLLNOFFR (81 THRU HI)
   HLLDIVOR (81 THRU HI)
   HLLDEATH (81 THRU HI)
   HLLREFUS (81 THRU HI)
   HLLNONED (81 THRU HI)
   HLLSOR (81 THRU HI)
   HLLSORS2 (90 THRU HI)
   HLNVCOST (81 THRU HI)
   HLNVOFFR (81 THRU HI)
   HLNVREF (81 THRU HI)
   HLNVNEED (81 THRU HI)
   HLNVSOR (81 THRU HI)
   HLNVSP2 (90 THRU HI)
   LANGVER (81 THRU HI)
   GQTYPE (-9)
   AGE2 (81 THRU HI)
   NOMARR2 (81 THRU HI)
   SERVICE (81 THRU HI)
   MILSTAT (81 THRU HI)
   HEALTH (81 THRU HI)
   IRMARIT (81 THRU HI)
   IIMARIT (9)
   IREDUC2 (81 THRU HI)
   MOVESPY2 (981 THRU HI)
   ENROLED (81 THRU HI)
   EDUCNOW2 (12 THRU HI)
   STUDNT (81 THRU HI)
   SCHDSICK (81 THRU HI)
   SCHDSKIP (81 THRU HI)
   HSDIPLMA (81 THRU HI)
   HSGED (81 THRU HI)
   LFSCHWH2 (981 THRU HI)
   LFTSCHA2 (981 THRU HI)
   RLGSVCYR (81 THRU HI)
   RLGIMPRT (81 THRU HI)
   RLGDECSN (81 THRU HI)
   RLGFRNDS (81 THRU HI)
   TELNO2 (81 THRU HI)
   TUCHTONE (81 THRU HI)
   COLLEGE2 (-9)
   JOBSTAT2 (10 THRU HI)
   JBSTATR2 (10 THRU HI)
   WRKHAVJB (81 THRU HI)
   WRKHRSWK (981 THRU HI)
   WRKINDU2 (981 THRU HI)
   WRKOCCU2 (981 THRU HI)
   WRKBZCA2 (81 THRU HI)
   WRKEFFRT (81 THRU HI)
   WRKEDYR (81 THRU HI)
   WRKSLFEM (81 THRU HI)
   WRKJOBS2 (981 THRU HI)
   WRKUNEMP (81 THRU HI)
   WRKUNWKS (81 THRU HI)
   WRKLASY2 (9981 THRU HI)
   WRKINDY2 (981 THRU HI)
   WRKOCCY2 (981 THRU HI)
   WORKDAYS (81 THRU HI)
   WORKBLAH (81 THRU HI)
   LOCSIZE (81 THRU HI)
   DRGPLCY (81 THRU HI)
   PLCYCOV (81 THRU HI)
   WKDRGED (81 THRU HI)
   DRGPRGM (81 THRU HI)
   USALCTST (81 THRU HI)
   USDRGTST (81 THRU HI)
   TSTHIRE (81 THRU HI)
   TSTRAND (81 THRU HI)
   FIRSTPOS (81 THRU HI)
   WRKHIRE (81 THRU HI)
   WORKRAND (81 THRU HI)
   VESTR (99981 THRU HI)
   .

EXECUTE.

* Create SPSS system file.

*SAVE OUTFILE="spss-filename.sav".
