*-------------------------------------------------------------------------*
 |                                                                         
 |                    SAS SETUP FILE FOR ICPSR 03262
 |             NATIONAL HOUSEHOLD SURVEY ON DRUG ABUSE, 2000
 |
 |
 | SAS setup sections are provided for the ASCII version of this data
 | collection.  These sections are listed below:
 |
 | PROC FORMAT:  creates user-defined formats for the variables. Formats
 | replace original value codes with value code descriptions. Only
 | variables with user-defined formats are included in this section.
 |
 | DATA:  begins a SAS data step and names an output SAS data set.
 |
 | INFILE:  identifies the input file to be read with the input statement.
 | Users must replace the "data-filename" with a filename specifying the
 | directory on the user's computer system in which the downloaded and
 | unzipped data file is physically located (e.g.,
 | "c:\temp\03262-0001-data.txt").
 |
 | INPUT:  assigns the name, type, decimal specification (if any), and
 | specifies the beginning and ending column locations for each variable
 | in the data file.
 |
 | LABEL:  assigns descriptive labels to all variables. Variable labels
 | and variable names may be identical for some variables.
 |
 | MISSING VALUE RECODES:  sets user-defined numeric missing values to
 | missing as interpreted by the SAS system. Only variables with
 | user-defined missing values are included in this section.
 |
 | FORMAT:  associates the formats created by the PROC FORMAT step with
 | the variables named in the INPUT statement.
 |
 | NOTE:  Users should modify this setup file to suit their specific needs.
 | Sections for PROC FORMAT, FORMAT, and MISSING VALUE RECODES have been
 | commented out (i.e., '/*'). To include these sections in the final SAS
 | setup, users should remove the SAS comment indicators from the desired
 | section(s).
 |
 *------------------------------------------------------------------------;

* SAS PROC FORMAT;

/*
PROC FORMAT;
  VALUE cigever   1='(1) Yes' 2='(2) No' ;
  VALUE cigofrsm  1='(1) Definitely Yes' 2='(2) Probably Yes' 3='(3) Probably Not'
                  4='(4) Definitely Not' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigwilyr  1='(1) Definitely Yes' 2='(2) Probably Yes' 3='(3) Probably Not'
                  4='(4) Definitely Not' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE cigtry    985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED CIGARETTES' 994='(994) DON''T KNOW' 997='(997) REFUSED' ;
  VALUE cigyfu    9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assn'
                  9991='(9991) NEVER USED CIGARETTES' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE cigmfu    1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assn'
                  91='(91) NEVER USED CIGARETTES' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigrec    1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago but within the past 3 yrs'
                  4='(4) More than 3 years ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  14='(14) Used more than 12 months ago LOG ASSN'
                  19='(19) Used more than 30 days ago LOG ASSN'
                  91='(91) NEVER USED CIGARETTES' ;
  VALUE cig30use  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cg30est   1='(1) 1 or 2 days' 2='(2) 3 to 5 days' 3='(3) 6 to 9 days'
                  4='(4) 10 to 19 days' 5='(5) 20 to 29 days' 6='(6) All 30 days'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE cig30av   1='(1) Less than one cigarette per day' 2='(2) 1 cigarette per day'
                  3='(3) 2 to 5 cigarettes per day'
                  4='(4) 6 to 15 cigarettes per day (about 1/2 pack)'
                  5='(5) 16 to 25 cigarettes per day (about 1 pack)'
                  6='(6) 26 to 35 cigarettes per day (about 1 1/2 packs)'
                  7='(7) More than 35 cigs per day (abt 2 packs or more)'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cig30brf  101='(101) Basic' 102='(102) Benson & Hedges' 103='(103) Cambridge'
                  104='(104) Camel' 105='(105) Capri' 106='(106) Carlton' 107='(107) Doral' 109='(109) GPC'
                  110='(110) Kent' 111='(111) Kool' 112='(112) Marlboro' 113='(113) Merit'
                  114='(114) Misty' 115='(115) Monarch' 116='(116) Montclair' 117='(117) More'
                  118='(118) Newport' 119='(119) Pall Mall' 120='(120) Parliament'
                  121='(121) Private Label' 122='(122) Salem' 123='(123) Vantage' 124='(124) Viceroy'
                  125='(125) Virginia Slims' 126='(126) Winston' 127='(127) Alpine'
                  129='(129) Belair' 130='(130) Best Value' 132='(132) Bugler (roll-your-own)'
                  137='(137) Eve' 142='(142) Lucky Strike' 144='(144) Maverick' 146='(146) Now'
                  147='(147) Old Gold' 149='(149) Pyramid' 150='(150) Raleigh' 152='(152) Saratoga'
                  157='(157) Tareyton' 158='(158) Top (roll-your-own)' 160='(160) True'
                  161='(161) American Spirit' 162='(162) Austin' 169='(169) Bronson'
                  171='(171) Checkers' 173='(173) Clove; brand unspecified' 174='(174) Daves'
                  175='(175) Djarum cigarettes' 176='(176) Drum rolling tobacco'
                  178='(178) Dunhill cigarettes' 179='(179) Eagle' 183='(183) First Class'
                  185='(185) Generic cigarettes; brand unspecified' 188='(188) Gunsmoke'
                  189='(189) Hi-Value' 190='(190) Jacks' 193='(193) Kamel Red' 196='(196) Mainstreet'
                  404='(404) Black & Mild' 423='(423) Swisher Sweets'
                  445='(445) Corona; brand unspecified'
                  1001='(1001) Nat Sherman cigarettes' 1005='(1005) Private Stock'
                  1006='(1006) Quality Smokes' 1011='(1011) Sampoerna' 1017='(1017) Sundance'
                  1018='(1018) USA Gold' 1019='(1019) Vegas cigarettes' 1020='(1020) Waves'
                  1022='(1022) Bailey' 1023='(1023) Sport' 1029='(1029) Tourney' 1037='(1037) DTC'
                  1040='(1040) Smokin Joes cigarettes' 1044='(1044) Worth'
                  1047='(1047) New York New York cigarettes' 1048='(1048) Carnival'
                  1050='(1050) USA' 1055='(1055) Geranimo' 1083='(1083) Liggett Select'
                  1999='(1999) Other cigarette brand or unspecified'
                  3999='(3999) Other snuff brand or unspecified'
                  4999='(4999) Other cigar/cigarillo brand or unspecified'
                  5999='(5999) Other pipe tobacco brand or unspecified'
                  7999='(7999) Not a tobacco product'
                  9000='(9000) Did not confirm after 3 passes thru brand Qs'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED CIGARETTES'
                  9993='(9993) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  9994='(9994) DON''T KNOW' 9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)' ;
  VALUE cig30typ  1='(1) Lights' 2='(2) Ultra Lights' 3='(3) Full Flavor'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cig30men  1='(1) Menthol' 2='(2) Regular' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cig30rof  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cigdlymo  1='(1) Yes' 2='(2) No'
                  5='(5) Yes LOGICALLY ASSIGNED (from skip pattern)'
                  91='(91) NEVER USED CIGARETTES' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE cigage    985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED CIGARETTES' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP (NEVER USED CIGS EVERYDAY)' ;
  VALUE cig100lf  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  5='(5) Yes LOGICALLY ASSIGNED (from skip pattern)'
                  91='(91) NEVER USED CIGARETTES' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE chewever  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE chewtry   985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED CHEWING TOBACCO' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE chewyfu   9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED CHEWING TOBACCO' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE chewmfu   1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CHEWING TOBACCO' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE chewrec   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago but within the past 3 yrs'
                  4='(4) More than 3 years ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  14='(14) Used more than 12 months ago LOG ASSN'
                  19='(19) Used more than 30 days ago LOG ASSN'
                  91='(91) NEVER USED CHEWING TOBACCO' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE chw30use  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CHEWING TOBACCO'
                  93='(93) DID NOT USE CHEWING TOBACCO PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ch30est   1='(1) 1 or 2 days' 2='(2) 3 to 5 days' 3='(3) 6 to 9 days'
                  4='(4) 10 to 19 days' 5='(5) 20 to 29 days' 6='(6) All 30 days'
                  91='(91) NEVER USED CHEWING TOBACCO'
                  93='(93) DID NOT USE CHEWING TOBACCO IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE chw30brf  201='(201) Beech-Nut' 202='(202) Chattanooga Chew' 203='(203) Day''s Work'
                  204='(204) Granger' 206='(206) Levi Garrett' 207='(207) Red Fox'
                  208='(208) Red Man' 209='(209) Taylors Pride' 211='(211) Work Horse'
                  221='(221) Mail Pouch' 301='(301) Copenhagen' 304='(304) Hawken' 305='(305) Kodiak'
                  307='(307) Silver Creek' 308='(308) Skoal' 309='(309) Timber Wolf'
                  312='(312) Cougar' 316='(316) Red Seal' 317='(317) Rooster'
                  1999='(1999) Other cigarette brand or unspecified'
                  2999='(2999) Other chewing tobacco brand or unspecified'
                  3999='(3999) Other snuff brand or unspecified'
                  4999='(4999) Other cigar/cigarillo brand or unspecified'
                  5999='(5999) Other pipe tobacco brand or unspecified'
                  8999='(8999) Tobacco replacement or tobacco-like product'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED CHEWING TOBACCO'
                  9993='(9993) DID NOT USE CHEWING TOBACCO IN THE PAST 30 DAYS'
                  9994='(9994) DON''T KNOW' 9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)' ;
  VALUE snfever   1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE snuftry   985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED SNUFF'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE snufyfu   9985='(9985) BAD DATA Logically assigned' 9991='(9991) NEVER USED SNUFF'
                  9994='(9994) DON''T KNOW' 9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE snufmfu   1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SNUFF'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE snfrec    1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago but within the past 3 yrs'
                  4='(4) More than 3 years ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  14='(14) Used more than 12 months ago LOG ASSN'
                  19='(19) Used more than 30 days ago LOG ASSN'
                  91='(91) NEVER USED SMOKELESS TOBACCO' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE snf30use  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SNUFF'
                  93='(93) DID NOT USE SNUFF IN THE PAST 30 DAYS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sn30est   1='(1) 1 or 2 days' 2='(2) 3 to 5 days' 3='(3) 6 to 9 days'
                  4='(4) 10 to 19 days' 5='(5) 20 to 29 days' 6='(6) All 30 days'
                  91='(91) NEVER USED SNUFF'
                  93='(93) DID NOT USE SNUFF IN THE PAST 30 DAYS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snf30brf  208='(208) Red Man' 301='(301) Copenhagen' 302='(302) Gold River'
                  303='(303) Happy Days' 304='(304) Hawken' 305='(305) Kodiak' 306='(306) Redwood'
                  307='(307) Silver Creek' 308='(308) Skoal' 309='(309) Timber Wolf'
                  312='(312) Cougar' 316='(316) Red Seal' 317='(317) Rooster'
                  321='(321) W. Garrett snuff'
                  2999='(2999) Other chewing tobacco brand or unspecified'
                  3999='(3999) Other snuff brand or unspecified'
                  7999='(7999) Not a tobacco product'
                  9985='(9985) BAD DATA Logically assigned' 9991='(9991) NEVER USED SNUFF'
                  9993='(9993) DID NOT USE SNUFF IN THE PAST 30 DAYS'
                  9994='(9994) DON''T KNOW' 9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)' ;
  VALUE slttry    985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED SMOKELESS TOBACCO' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE sltyfu    9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED SMOKELESS TOBACCO' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE sltmfu    1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED SMOKELESS TOBACCO' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sltrec    1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago but within the past 3 yrs'
                  4='(4) More than 3 years ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  14='(14) Used more than 12 months ago LOG ASSN'
                  19='(19) Used more than 30 days ago LOG ASSN'
                  91='(91) NEVER USED SMOKELESS TOBACCO' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE slt30brf  201='(201) Beech-Nut' 202='(202) Chattanooga Chew' 203='(203) Day''s Work'
                  204='(204) Granger' 206='(206) Levi Garrett' 207='(207) Red Fox'
                  208='(208) Red Man' 209='(209) Taylors Pride' 211='(211) Work Horse'
                  301='(301) Copenhagen' 304='(304) Hawken' 305='(305) Kodiak' 306='(306) Redwood'
                  307='(307) Silver Creek' 308='(308) Skoal' 309='(309) Timber Wolf'
                  312='(312) Cougar' 316='(316) Red Seal' 317='(317) Rooster'
                  321='(321) W. Garrett snuff'
                  1999='(1999) Other cigarette brand or unspecified'
                  2999='(2999) Other chewing tobacco brand or unspecified'
                  3999='(3999) Other snuff brand or unspecified'
                  4999='(4999) Other cigar/cigarillo brand or unspecified'
                  5999='(5999) Other pipe tobacco brand or unspecified'
                  7999='(7999) Not a tobacco product'
                  8999='(8999) Tobacco replacement or tobacco-like product'
                  9991='(9991) NEVER USED SMOKELESS TOBACCO'
                  9993='(9993) DID NOT USE SMOKELESS TOBACCO IN THE PAST 30 DAYS'
                  9994='(9994) DON''T KNOW' 9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)' ;
  VALUE slt30fav  1='(1) Brand reported from CHW30BR2'
                  2='(2) Brand reported from SNF30BR2'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED SMOKELESS TOBACCO'
                  93='(93) DID NOT USE SMOKELESS TOBACCO IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cigarevr  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE cigartry  985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED CIGARS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE cigaryfu  9985='(9985) BAD DATA Logically assigned' 9991='(9991) NEVER USED CIGARS'
                  9994='(9994) DON''T KNOW' 9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE cigarmfu  1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE cigarrec  1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago but within the past 3 yrs'
                  4='(4) More than 3 years ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  14='(14) Used more than 12 months ago LOG ASSN'
                  19='(19) Used more than 30 days ago LOG ASSN'
                  91='(91) NEVER USED CIGARS' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cgr30use  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARS'
                  93='(93) DID NOT USE CIGARS IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ci30est   1='(1) 1 or 2 days' 2='(2) 3 to 5 days' 3='(3) 6 to 9 days'
                  4='(4) 10 to 19 days' 5='(5) 20 to 29 days' 6='(6) All 30 days'
                  91='(91) NEVER USED CIGARS' 93='(93) DID NOT USE CIGARS PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE cgr30brf  112='(112) Marlboro' 118='(118) Newport' 401='(401) Antonio y Cleopatra'
                  402='(402) Backwoods' 403='(403) Bering' 404='(404) Black & Mild'
                  405='(405) Captain Black' 406='(406) Casa Silva' 407='(407) Cuesta-Rey'
                  408='(408) Dutch Masters' 409='(409) El Producto' 411='(411) Garcia y Vega'
                  412='(412) Havatampa' 413='(413) King Edward' 414='(414) La Corona'
                  415='(415) Little Nippers' 416='(416) Macanudos' 417='(417) Muriel'
                  418='(418) Partagas' 419='(419) Phillies' 420='(420) Rigoletto'
                  421='(421) Robert Burns' 422='(422) Roi-Tan' 423='(423) Swisher Sweets'
                  424='(424) Tijuana Smalls' 426='(426) White Owl' 427='(427) William Penn'
                  428='(428) Winchester' 429='(429) Al Capone' 431='(431) Arturo Fuente'
                  432='(432) Ashton' 434='(434) Baccarat' 443='(443) Cohiba'
                  445='(445) Corona; brand unspecified'
                  448='(448) Cuban; brand unspecified' 451='(451) Davidoff'
                  452='(452) Don Diego' 462='(462) Grenadiers' 464='(464) H. Upmann'
                  465='(465) Habana/Havana; brand unspecified' 486='(486) Montecristo'
                  488='(488) Optimo' 490='(490) Padron' 491='(491) Parodi Cella'
                  492='(492) Primetime' 494='(494) Punch' 496='(496) Romeo y Julieta'
                  1999='(1999) Other cigarette brand or unspecified' 4005='(4005) Thompson'
                  4006='(4006) Tiparillo' 4016='(4016) Dominican; brand unspecified'
                  4041='(4041) Miami Suites' 4050='(4050) Fuente' 4051='(4051) Avo'
                  4999='(4999) Other cigar/cigarillo brand or unspecified'
                  7999='(7999) Not a tobacco product'
                  9985='(9985) BAD DATA Logically assigned' 9991='(9991) NEVER USED CIGARS'
                  9993='(9993) DID NOT USE CIGARS IN THE PAST 30 DAYS'
                  9994='(9994) DON''T KNOW' 9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)' ;
  VALUE pipever   1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE pipe30dy  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PIPE TOBACCO' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE alcever   1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE alctry    985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED ALCOHOL'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE alcyfu    9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED ALCOHOL' 9994='(9994) DON''T KNOW' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE alcmfu    1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE alcrec    1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  91='(91) NEVER USED ALCOHOL' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alcyrtot  985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED ALCOHOL'
                  993='(993) DID NOT USE ALCOHOL IN THE PAST 12 MONTHS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE altotfg   1='(1) Trimmed to 365 days (no further editing)'
                  2='(2) Trimmed relative to the 30-day freq'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE alfqflg   1='(1) Trimmed to be consistent with mo/yr of 1st use'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE albstway  1='(1) Prefer to answer in days per week'
                  2='(2) Prefer to answer in days per month'
                  3='(3) Prefer to answer in days per year'
                  11='(11) Prefer to ans in days per wk LOG ASSN'
                  12='(12) Prefer to ans in days per mo LOG ASSN'
                  13='(13) Prefer to ans in days per yr LOG ASSN'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALCOHOL IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE aldaypyr  985='(985) BAD DATA Logically assigned'
                  989='(989) LEGITIMATE SKIP Logically assigned'
                  991='(991) NEVER USED ALCOHOL'
                  993='(993) DID NOT USE ALCOHOL IN THE PAST 12 MONTHS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE aldaypmo  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALCOHOL IN THE PAST 12 MONTHS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aldaypwk  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALCOHOL IN THE PAST 12 MONTHS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE alcdays   85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALCOHOL IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE al30est   1='(1) 1 or 2 days' 2='(2) 3 to 5 days' 3='(3) 6 to 9 days'
                  4='(4) 10 to 19 days' 5='(5) 20 to 29 days' 6='(6) All 30 days'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALCOHOL IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aldysfg   1='(1) Edited for consistency with ALCYRTOT or DR5DAY'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE nodr30a   975='(975) AT LEAST 5 Logically assigned'
                  985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED ALCOHOL'
                  993='(993) DID NOT USE ALCOHOL IN THE PAST 30 DAYS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE dr5day    80='(80) NO OCCAS OF 5+ DRINKS PST 30 DAYS Log assn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALCOHOL IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mjever    1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE mjage     985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED MARIJUANA' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' ;
  VALUE mjyfu     9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED MARIJUANA' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE mjmfu     1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE mjrec     1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  91='(91) NEVER USED MARIJUANA' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE mjyrtot   985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED MARIJUANA'
                  993='(993) DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE mrtotfg   1='(1) Trimmed to 365 days (no further editing)'
                  2='(2) Trimmed relative to the 30-day freq'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE mjfqflg   1='(1) Trimmed to be consistent with mo/yr of 1st use'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE mrbstway  1='(1) Prefer to answer in days per week'
                  2='(2) Prefer to answer in days per month'
                  3='(3) Prefer to answer in days per year'
                  11='(11) Prefer to ans in days per wk LOG ASSN'
                  12='(12) Prefer to ans in days per mo LOG ASSN'
                  13='(13) Prefer to ans in days per yr LOG ASSN'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mrdaypyr  985='(985) BAD DATA Logically assigned'
                  989='(989) LEGITIMATE SKIP Logically assigned'
                  991='(991) NEVER USED MARIJUANA'
                  993='(993) DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE mrdaypmo  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE mrdaypwk  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE mjday30a  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MARIJUANA IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mr30est   1='(1) 1 or 2 days' 2='(2) 3 to 5 days' 3='(3) 6 to 9 days'
                  4='(4) 10 to 19 days' 5='(5) 20 to 29 days' 6='(6) All 30 days'
                  91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MARIJUANA IN THE PAST 12 MONTHS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE cocever   1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE cocage    985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED COCAINE'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE cocyfu    9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assn'
                  9991='(9991) NEVER USED COCAINE' 9994='(9994) DON''T KNOW' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE cocmfu    1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assn' 91='(91) NEVER USED COCAINE'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE cocrec    1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  11='(11) Used in the past 30 days LOGICALLY ASSIGNED'
                  12='(12) Used >30 days ago but within pst 12 mos LOG ASSN'
                  91='(91) NEVER USED COCAINE' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cocyrtot  985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED COCAINE'
                  993='(993) DID NOT USE COCAINE IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE cctotfg   2='(2) Trimmed relative to the 30-day freq'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE ccfqflg   1='(1) Trimmed to be consistent with mo/yr of 1st use'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE ccbstway  1='(1) Prefer to answer in days per week'
                  2='(2) Prefer to answer in days per month'
                  3='(3) Prefer to answer in days per year'
                  11='(11) Prefer to ans in days per wk LOG ASSN'
                  12='(12) Prefer to ans in days per mo LOG ASSN'
                  13='(13) Prefer to ans in days per yr LOG ASSN'
                  21='(21) Prefer to ans in days per wk (CRBSTWAY=1,11)'
                  22='(22) Prefer to ans in days per mo (CRBSTWAY=2,12)'
                  23='(23) Prefer to ans in days per yr (CRBSTWAY=3,13)'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ccdaypyr  985='(985) BAD DATA Logically assigned'
                  989='(989) LEGITIMATE SKIP Logically assigned'
                  991='(991) NEVER USED COCAINE'
                  993='(993) DID NOT USE COCAINE IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE ccdaypmo  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ccdaypwk  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE cocus30a  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cc30est   2='(2) 3 to 5 days' 3='(3) 6 to 9 days' 5='(5) 20 to 29 days'
                  6='(6) All 30 days' 91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE IN THE PAST 30 DAYS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE crkever   1='(1) Yes' 2='(2) No' 91='(91) NEVER USED COCAINE (COCEVER=2)'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE crkage    985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED CRACK'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE crkyfu    9985='(9985) BAD DATA Logically assigned' 9991='(9991) NEVER USED CRACK'
                  9994='(9994) DON''T KNOW' 9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE crkmfu    1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CRACK'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE crakrec   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  91='(91) NEVER USED CRACK' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE crkyrtot  985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED CRACK'
                  993='(993) DID NOT USE CRACK IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE crtotfg   2='(2) Trimmed relative to the 30-day freq'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE crfqflg   1='(1) Trimmed to be consistent with mo/yr of 1st use'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE crbstway  1='(1) Prefer to answer in days per week'
                  2='(2) Prefer to answer in days per month'
                  3='(3) Prefer to answer in days per year'
                  11='(11) Prefer to ans in days per wk LOG ASSN'
                  12='(12) Prefer to ans in days per mo LOG ASSN'
                  13='(13) Prefer to ans in days per yr LOG ASSN'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CRACK'
                  93='(93) DID NOT USE CRACK IN THE PAST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE crdaypyr  989='(989) LEGITIMATE SKIP Logically assigned'
                  991='(991) NEVER USED CRACK'
                  993='(993) DID NOT USE CRACK IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE crdaypmo  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED CRACK'
                  93='(93) DID NOT USE CRACK IN THE PAST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE crdaypwk  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CRACK'
                  93='(93) DID NOT USE CRACK IN THE PAST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE crkus30a  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CRACK'
                  93='(93) DID NOT USE CRACK IN THE PAST 30 DAYS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE cr30est   4='(4) 10 to 19 days' 91='(91) NEVER USED CRACK'
                  93='(93) DID NOT USE CRACK IN THE PAST 30 DAYS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE herever   1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE herage    985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED HEROIN'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE heryfu    9985='(9985) BAD DATA Logically assigned' 9991='(9991) NEVER USED HEROIN'
                  9994='(9994) DON''T KNOW' 9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE hermfu    1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED HEROIN'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE herrec    1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  91='(91) NEVER USED HEROIN' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE heryrtot  985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED HEROIN'
                  993='(993) DID NOT USE HEROIN IN THE PAST 12 MOS' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' ;
  VALUE hrtotfg   2='(2) Trimmed relative to the 30-day freq'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE hrfqflg   1='(1) Trimmed to be consistent with mo/yr of 1st use'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE hrbstway  1='(1) Prefer to answer in days per week'
                  2='(2) Prefer to answer in days per month'
                  3='(3) Prefer to answer in days per year'
                  11='(11) Prefer to ans in days per wk LOG ASSN'
                  13='(13) Prefer to ans in days per yr LOG ASSN'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PAST 12 MONTHS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE hrdaypyr  989='(989) LEGITIMATE SKIP Logically assigned'
                  991='(991) NEVER USED HEROIN'
                  993='(993) DID NOT USE HEROIN PAST 12 MOS' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE hrdaypmo  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED HEROIN' 93='(93) DID NOT USE HEROIN PAST 12 MOS'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hrdaypwk  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PAST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE her30use  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN IN THE PAST 30 DAYS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE hr30est   91='(91) NEVER USED HEROIN' 93='(93) DID NOT USE HEROIN PAST 30 DAYS'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE lsd       1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  91='(91) NEVER USED HALLUCINOGENS' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE pcp       1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HALLUCINOGENS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE peyote    1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HALLUCINOGENS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE mesc      1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HALLUCINOGENS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE psilcy    1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  91='(91) NEVER USED HALLUCINOGENS' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE ecstasy   1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HALLUCINOGENS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE halnolst  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HALLUCINOGENS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE halnewa   112='(112) Restoril, Temazepam'
                  116='(116) Methaqualone, Quaalude, Sopor'
                  120='(120) Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
                  142='(142) Belladona' 201='(201) Valium, Diazepam' 267='(267) Marezine'
                  268='(268) Rohypnol, Roche, roofies' 280='(280) Ketaset' 292='(292) Serzone'
                  318='(318) Ritalin, Methylphenidate'
                  322='(322) Methamphetamine ("ice" or "crank"), Meth'
                  324='(324) Uppers; OTHER Stimulant, NOT OTHERWISE SPECIFIED'
                  326='(326) White cross' 332='(332) Ephedrine' 348='(348) Crystal'
                  353='(353) No-Doz <OTC>' 355='(355) Crystal meth' 415='(415) Codeine'
                  417='(417) Morphine, Roxanol'
                  434='(434) Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin'
                  501='(501) Gasoline or lighter fluids' 502='(502) Spray paints'
                  503='(503) Other aerosol sprays'
                  504='(504) Shoeshine liquid, glue, or toluene'
                  506='(506) Amyl nitrite,"poppers,"locker room odorizer,"rush"'
                  507='(507) Halothane, ether, or other anesthetics; chloroform'
                  508='(508) Nitrous oxide, "whippets," dentist gas'
                  510='(510) OTHER Inhalant, NOT OTHERWISE SPECIFIED'
                  511='(511) Markers, felt-tip pens, ink pens'
                  516='(516) Freon, refrigerant' 519='(519) Helium'
                  520='(520) Old paint, paint' 521='(521) Propane' 524='(524) White-Out'
                  525='(525) Butane' 540='(540) PAM' 566='(566) Smoked tea from Lipton tea bag'
                  592='(592) Computer air duster, computer cleaner, dust-off'
                  601='(601) LSD ("acid")' 602='(602) Peyote' 603='(603) Mescaline'
                  604='(604) Psilocybin (mushrooms), shrooms'
                  605='(605) PCP ("angel dust," phencyclidine)'
                  607='(607) OTHER Hallucinogen, NOT OTHERWISE SPECIFIED'
                  609='(609) Jimson weed'
                  612='(612) Happy stick, sherm, sherman, shermstick'
                  614='(614) MDA, Methylenedioxy amphetamine' 615='(615) Homemade drugs'
                  616='(616) DET, Dimethyltryptamine, DMT'
                  617='(617) Morning glory seeds, morning glory tendrils'
                  618='(618) Acid paper, blotter (acid)' 619='(619) Tic'
                  622='(622) Microdot(s), green microdot, purple microdot'
                  624='(624) Orange sunshine, sunshine, yellow sunshine'
                  625='(625) Window, window pane, 4-way pane'
                  627='(627) Hawaiian wood rose, Hawaiian Woodrow seeds'
                  633='(633) Mr. Natural' 636='(636) DOM, STP' 637='(637) Purple haze'
                  639='(639) Nutmeg, Mace'
                  650='(650) Datura stramonium, daytura, thorn apple'
                  658='(658) Special K, Ketamine' 660='(660) Toad, Toad licking'
                  678='(678) Banana peels' 683='(683) Yage' 695='(695) Angel''s trumpet'
                  698='(698) Nexus, 2C-B'
                  701='(701) OTHER Opiates, NOT OTHERWISE SPECIFIED' 703='(703) Opium'
                  802='(802) THC, cannabinol, marinol'
                  803='(803) Marijuana, MarrJane, Mary Jane, MJ, pot, weed'
                  806='(806) Crack, rock' 809='(809) Pills' 828='(828) Tetracycline'
                  829='(829) Robitussin DM <OTC>'
                  843='(843) Antihistamine, cold medicine, cold tablets <OTC>'
                  847='(847) GHB, NSC'
                  852='(852) Formaldehyde, wak, whack (embalming fluid)'
                  883='(883) Dextromethorphan Hydrobromide <OTC>'
                  1002='(1002) Dramamine, seasick/motion sickness pill <OTC>'
                  2002='(2002) Muscle Relaxers' 3023='(3023) Adderall'
                  3052='(3052) Speed; otherwise unspecified'
                  3064='(3064) Ephedra, Ma Huang <OTC>'
                  5022='(5022) Carbon dioxide, CO2, dry ice hits'
                  5028='(5028) Carburetor cleaner, engine cleaner'
                  6005='(6005) Sassafras tea' 6029='(6029) DXM' 6037='(6037) Fry'
                  6038='(6038) Triplets, Trips' 6043='(6043) Salviadivinorum'
                  6044='(6044) Gel caps, gel tabs' 6055='(6055) Liberty caps' 6056='(6056) Wet'
                  6062='(6062) Madderwort, Wormwood' 6063='(6063) Foxglove' 6073='(6073) Rolls'
                  6074='(6074) LSA' 6077='(6077) San Pedro' 6078='(6078) Trumpet flowers'
                  6079='(6079) Sugar cubes' 6083='(6083) CCC, Triple "C"' 6085='(6085) Dips'
                  6089='(6089) Cake' 6090='(6090) Heaven' 6092='(6092) TCP'
                  6094='(6094) Mushrooms, specifically not psilocybin'
                  6095='(6095) Super cool, Super kool' 6096='(6096) Bananadine'
                  6097='(6097) Banana slug slime' 6099='(6099) Katmandue Temple Kiff'
                  8011='(8011) Herb, flower, plant; type unspecified'
                  8012='(8012) Coriciden <OTC>'
                  8058='(8058) Cough medicine/syrup; type unspecified'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED HALLUCINOGENS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE halnewb   142='(142) Belladona' 201='(201) Valium, Diazepam'
                  322='(322) Methamphetamine ("ice" or "crank"), Meth'
                  345='(345) Black Molly'
                  435='(435) Tylenol, Tylenol Extra-Strength <OTC>'
                  501='(501) Gasoline or lighter fluids'
                  504='(504) Shoeshine liquid, glue, or toluene'
                  505='(505) Lacquer thinner or other paint solvents'
                  506='(506) Amyl nitrite,"poppers,"locker room odorizer,"rush"'
                  508='(508) Nitrous oxide, "whippets," dentist gas'
                  511='(511) Markers, felt-tip pens, ink pens'
                  520='(520) Old paint, paint' 566='(566) Smoked tea from Lipton tea bag'
                  601='(601) LSD ("acid")' 603='(603) Mescaline'
                  604='(604) Psilocybin (mushrooms), shrooms'
                  607='(607) OTHER Hallucinogen, NOT OTHERWISE SPECIFIED'
                  612='(612) Happy stick, sherm, sherman, shermstick'
                  614='(614) MDA, Methylenedioxy amphetamine'
                  616='(616) DET, Dimethyltryptamine, DMT'
                  617='(617) Morning glory seeds, morning glory tendrils'
                  618='(618) Acid paper, blotter (acid)'
                  622='(622) Microdot(s), green microdot, purple microdot'
                  624='(624) Orange sunshine, sunshine, yellow sunshine'
                  636='(636) DOM, STP' 639='(639) Nutmeg, Mace' 658='(658) Special K, Ketamine'
                  678='(678) Banana peels' 695='(695) Angel''s trumpet' 703='(703) Opium'
                  802='(802) THC, cannabinol, marinol' 809='(809) Pills'
                  829='(829) Robitussin DM <OTC>' 847='(847) GHB, NSC' 6029='(6029) DXM'
                  6031='(6031) Strychnine' 6079='(6079) Sugar cubes' 6080='(6080) Purple passion'
                  6086='(6086) Flakes' 6087='(6087) Ibogaine'
                  8011='(8011) Herb, flower, plant; type unspecified'
                  8012='(8012) Coriciden <OTC>'
                  8058='(8058) Cough medicine/syrup; type unspecified'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED HALLUCINOGENS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE halnewc   355='(355) Crystal meth' 503='(503) Other aerosol sprays'
                  524='(524) White-Out' 566='(566) Smoked tea from Lipton tea bag'
                  601='(601) LSD ("acid")' 604='(604) Psilocybin (mushrooms), shrooms'
                  609='(609) Jimson weed' 616='(616) DET, Dimethyltryptamine, DMT'
                  847='(847) GHB, NSC'
                  1002='(1002) Dramamine, seasick/motion sickness pill <OTC>'
                  6029='(6029) DXM' 6091='(6091) Ergot, rye mold' 6092='(6092) TCP'
                  6098='(6098) Dust; not otherwise specified'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED HALLUCINOGENS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE halnewd   268='(268) Rohypnol, Roche, roofies'
                  501='(501) Gasoline or lighter fluids' 503='(503) Other aerosol sprays'
                  520='(520) Old paint, paint' 601='(601) LSD ("acid")'
                  607='(607) OTHER Hallucinogen, NOT OTHERWISE SPECIFIED'
                  617='(617) Morning glory seeds, morning glory tendrils'
                  627='(627) Hawaiian wood rose, Hawaiian Woodrow seeds' 6029='(6029) DXM'
                  6078='(6078) Trumpet flowers' 9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED HALLUCINOGENS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE halnewe   506='(506) Amyl nitrite,"poppers,"locker room odorizer,"rush"'
                  528='(528) Whipped-cream can'
                  617='(617) Morning glory seeds, morning glory tendrils'
                  6084='(6084) Devil dust' 9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED HALLUCINOGENS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE hallage   985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED HALLUCINOGENS' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE halyfu    9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assn'
                  9991='(9991) NEVER USED HALLUCINOGENS' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE halmfu    1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assn'
                  91='(91) NEVER USED HALLUCINOGENS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hallrec   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in lifetime LOG ASSN'
                  11='(11) Used in the past 30 days LOGICALLY ASSIGNED'
                  12='(12) Used >30 days ago but within pst 12 mos LOG ASSN'
                  91='(91) NEVER USED HALLUCINOGENS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE halyrtot  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED HALLUCINOGENS'
                  993='(993) DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE hltotfg   2='(2) Trimmed relative to the 30-day freq'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE hlfqflg   1='(1) Trimmed to be consistent with mo/yr of 1st use'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE hlbstway  1='(1) Prefer to answer in days per week'
                  2='(2) Prefer to answer in days per month'
                  3='(3) Prefer to answer in days per year'
                  11='(11) Prefer to ans in days per wk LOG ASSN'
                  12='(12) Prefer to ans in days per mo LOG ASSN'
                  13='(13) Prefer to ans in days per yr LOG ASSN'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PAST 12 MONTHS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE hldaypyr  985='(985) BAD DATA Logically assigned'
                  989='(989) LEGITIMATE SKIP Logically assigned'
                  991='(991) NEVER USED HALLUCINOGENS'
                  993='(993) DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE hldaypmo  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE hldaypwk  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE hal30use  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE hl30est   1='(1) 1 or 2 days' 3='(3) 6 to 9 days'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PAST 30 DAYS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE lsdage    985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED LSD'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE lsdyfu    9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assigned'
                  9991='(9991) NEVER USED LSD' 9994='(9994) DON''T KNOW' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE lsdmfu    1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assn' 91='(91) NEVER USED LSD'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE lsdrec    1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  91='(91) NEVER USED LSD' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE pcpage    985='(985) BAD DATA Logically assigned' 991='(991) NEVER USED PCP'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE pcpyfu    9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assigned'
                  9991='(9991) NEVER USED PCP' 9994='(9994) DON''T KNOW' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE pcpmfu    1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assn' 91='(91) NEVER USED PCP'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE pcprec    1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in the lifetime LOG ASSN'
                  91='(91) NEVER USED PCP' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE amylnit   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  91='(91) NEVER USED INHALANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE cleflu    1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  91='(91) NEVER USED INHALANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE gas       1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  91='(91) NEVER USED INHALANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE glue      1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  91='(91) NEVER USED INHALANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE ether     1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' ;
  VALUE solvent   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  91='(91) NEVER USED INHALANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE lgas      1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  91='(91) NEVER USED INHALANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE nitoxid   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  91='(91) NEVER USED INHALANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE sppaint   1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE aeros     1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  91='(91) NEVER USED INHALANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE inhnolst  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inhnewa   110='(110) Tuinal' 304='(304) Benzedrine'
                  318='(318) Ritalin, Methylphenidate'
                  322='(322) Methamphetamine ("ice" or "crank"), Meth'
                  348='(348) Crystal' 377='(377) Albuterol, Proventil, Ventolin'
                  501='(501) Gasoline or lighter fluids' 502='(502) Spray paints'
                  503='(503) Other aerosol sprays'
                  504='(504) Shoeshine liquid, glue, or toluene'
                  505='(505) Lacquer thinner or other paint solvents'
                  506='(506) Amyl nitrite,"poppers,"locker room odorizer,"rush"'
                  507='(507) Halothane, ether, or other anesthetics; chloroform'
                  508='(508) Nitrous oxide, "whippets," dentist gas'
                  509='(509) Correction fluids, degreasers, cleaning fluids'
                  510='(510) OTHER Inhalant, NOT OTHERWISE SPECIFIED'
                  511='(511) Markers, felt-tip pens, ink pens' 512='(512) Incense'
                  516='(516) Freon, refrigerant' 518='(518) Acetone, nail polish remover'
                  519='(519) Helium' 520='(520) Old paint, paint' 524='(524) White-Out'
                  525='(525) Butane' 526='(526) Nail polish' 528='(528) Whipped-cream can'
                  531='(531) Candy, powdered candy, sugar' 534='(534) Deodorant'
                  539='(539) ScotchGard' 540='(540) PAM'
                  546='(546) Leather protector, suede protector'
                  548='(548) Cologne, isopropanol vapors, rubbing alcohol'
                  560='(560) Laundry detergent, soap' 567='(567) Pertussin spray'
                  580='(580) Medusa' 590='(590) Canned air, compressed air'
                  592='(592) Computer air duster, computer cleaner, dust-off'
                  599='(599) Potpourri' 658='(658) Special K, Ketamine'
                  803='(803) Marijuana, MarrJane, Mary Jane, MJ, pot, weed'
                  815='(815) Coffee <OTC>' 829='(829) Robitussin DM <OTC>' 847='(847) GHB, NSC'
                  3052='(3052) Speed; otherwise unspecified'
                  3053='(3053) Maxair, Pirbuterol'
                  5017='(5017) Oil, lubricant; otherwise unspecified'
                  5021='(5021) Octane booster'
                  5022='(5022) Carbon dioxide, CO2, dry ice hits'
                  5035='(5035) Brake cleaner' 5037='(5037) Wood filler' 5039='(5039) Acetate'
                  5042='(5042) Fuels other than gasoline' 5043='(5043) Carbona'
                  5045='(5045) Cleaner; not otherwise specified'
                  5046='(5046) Glass/window cleaner' 5047='(5047) Tetrafluorethylene'
                  6047='(6047) Water' 8009='(8009) Allergy pills; type unspecified'
                  8024='(8024) Asthma inhaler,asthma medication,bronchial dilator'
                  8054='(8054) Beconase' 9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED INHALANTS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE inhnewb   501='(501) Gasoline or lighter fluids' 503='(503) Other aerosol sprays'
                  504='(504) Shoeshine liquid, glue, or toluene'
                  508='(508) Nitrous oxide, "whippets," dentist gas'
                  510='(510) OTHER Inhalant, NOT OTHERWISE SPECIFIED'
                  511='(511) Markers, felt-tip pens, ink pens'
                  516='(516) Freon, refrigerant' 518='(518) Acetone, nail polish remover'
                  519='(519) Helium' 520='(520) Old paint, paint' 524='(524) White-Out'
                  526='(526) Nail polish' 528='(528) Whipped-cream can' 539='(539) ScotchGard'
                  540='(540) PAM'
                  592='(592) Computer air duster, computer cleaner, dust-off'
                  5041='(5041) Wood alcohol' 5043='(5043) Carbona'
                  5044='(5044) Powdered cleansers; e.g. Ajax, Comet, Borax'
                  8024='(8024) Asthma inhaler,asthma medication,bronchial dilator'
                  8055='(8055) Flonase' 9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED INHALANTS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE inhnewc   504='(504) Shoeshine liquid, glue, or toluene'
                  505='(505) Lacquer thinner or other paint solvents'
                  511='(511) Markers, felt-tip pens, ink pens'
                  518='(518) Acetone, nail polish remover' 520='(520) Old paint, paint'
                  524='(524) White-Out'
                  548='(548) Cologne, isopropanol vapors, rubbing alcohol'
                  8024='(8024) Asthma inhaler,asthma medication,bronchial dilator'
                  9991='(9991) NEVER USED INHALANTS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE inhnewd   503='(503) Other aerosol sprays' 524='(524) White-Out'
                  526='(526) Nail polish' 9991='(9991) NEVER USED INHALANTS'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE inhnewe   518='(518) Acetone, nail polish remover'
                  9991='(9991) NEVER USED INHALANTS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE inhage    985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED INHALANTS' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' ;
  VALUE inhyfu    9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED INHALANTS' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE inhmfu    1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED INHALANTS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE inhrec    1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in lifetime LOG ASSN'
                  91='(91) NEVER USED INHALANTS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE inhyrtot  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED INHALANTS'
                  993='(993) DID NOT USE INHALANTS IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE intotfg   2='(2) Trimmed relative to the 30-day freq'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE infqflg   1='(1) Trimmed to be consistent with mo/yr of 1st use'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE inbstway  1='(1) Prefer to answer in days per week'
                  2='(2) Prefer to answer in days per month'
                  3='(3) Prefer to answer in days per year'
                  11='(11) Prefer to ans in days per wk LOG ASSN'
                  12='(12) Prefer to ans in days per mo LOG ASSN'
                  13='(13) Prefer to ans in days per yr LOG ASSN'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE indaypyr  985='(985) BAD DATA Logically assigned'
                  989='(989) LEGITIMATE SKIP Logically assigned'
                  991='(991) NEVER USED INHALANTS'
                  993='(993) DID NOT USE INHALANTS IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE indaypmo  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE indaypwk  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE inhdy30a  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE in30est   1='(1) 1 or 2 days' 2='(2) 3 to 5 days' 3='(3) 6 to 9 days'
                  6='(6) All 30 days' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE darvtylc  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE perctylx  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE vicolor   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE anlcard   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE codeine   1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE demerol   1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE dilaud    1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE fioricet  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE fiorinal  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hydrocod  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE methdon   1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE morphine  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE oxycontn  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE phencod   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE propoxy   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sk65a     1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stadol    1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE talacen   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE talwin    1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE talwinnx  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE tramadol  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ultram    1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anlnolst  1='(1) Yes' 2='(2) No' 4='(4) No LOGICALLY ASSIGNED'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE analnewa  105='(105) Placidyl' 109='(109) Seconal' 110='(110) Tuinal'
                  112='(112) Restoril, Temazepam' 113='(113) Halcion' 115='(115) Phenobarbital'
                  116='(116) Methaqualone, Quaalude, Sopor'
                  120='(120) Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
                  124='(124) Yellow jackets' 129='(129) Reds'
                  130='(130) Phenergan, Promethazine' 138='(138) Mandrakes'
                  157='(157) Barbiturates' 174='(174) Ambien, Zolpidem'
                  201='(201) Valium, Diazepam' 209='(209) Xanax, Alprazolam' 211='(211) Buspar'
                  212='(212) Miltown'
                  223='(223) Carbacot, Marbaxin, Methocarbamol, Robaxin'
                  225='(225) Desyrel, Trazodone hydrochloride' 227='(227) Thorazine'
                  228='(228) Amitriptyline, Elavil' 234='(234) Cyclobenzaprine, Flexeril'
                  240='(240) Lithium carbonate, Lithonate' 241='(241) Prozac'
                  246='(246) Clonazepam, Klonopin, Rivotril'
                  268='(268) Rohypnol, Roche, roofies' 271='(271) Zoloft'
                  283='(283) Paroxetine, Paxil' 301='(301) Dexedrine'
                  318='(318) Ritalin, Methylphenidate'
                  322='(322) Methamphetamine ("ice" or "crank"), Meth'
                  334='(334) Crossroads, cross tops' 352='(352) Lemons' 356='(356) Dexies'
                  401='(401) Darvon' 406='(406) Percodan' 407='(407) Demerol' 408='(408) Dilaudid'
                  409='(409) Tylenol with Codeine, Tylenol 3, Tylenol 4'
                  415='(415) Codeine' 417='(417) Morphine, Roxanol'
                  418='(418) Dolophine, Methadone'
                  420='(420) OTHER Analgesic, NOT OTHERWISE SPECIFIED'
                  421='(421) USED ANALGESIC, DON''T KNOW NAME' 422='(422) Motrin'
                  423='(423) Percocet' 425='(425) Advil <OTC>' 426='(426) Fiorinal'
                  427='(427) Darvocet' 430='(430) Aspirin, Ecotrin, Empirin <OTC>'
                  431='(431) Tylox' 433='(433) Paregoric'
                  434='(434) Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin'
                  435='(435) Tylenol, Tylenol Extra-Strength <OTC>'
                  438='(438) Anaprox, Naprosyn, Naproxen' 442='(442) Ibuprofen'
                  450='(450) Acetaminophen <OTC>' 454='(454) Novocain, Procaine'
                  458='(458) Mepergan, Mepergan Fortis, Meprozine'
                  465='(465) Fentanyl, Duragesic, Sublimaze'
                  472='(472) Indocin, Indomethacin' 476='(476) Duradrin, Isocom, Midrin'
                  477='(477) Melumbrina, Neo-Melumbrina'
                  481='(481) Acular, Ketorolac tromethamine, Toradol' 490='(490) Nubain'
                  496='(496) Ultram' 635='(635) Ginseng seeds, ginseng weed'
                  802='(802) THC, cannabinol, marinol' 820='(820) Penicillin'
                  821='(821) Amoxicillin, Ampicillin' 824='(824) Steroids' 825='(825) Theo-Dur'
                  828='(828) Tetracycline' 846='(846) Erythromycin' 858='(858) Antibiotic'
                  895='(895) Tagamet, Cimetidine' 896='(896) Catapres, Clonidine'
                  2001='(2001) Carisoprodol, Soma' 2002='(2002) Muscle Relaxers'
                  3023='(3023) Adderall' 3027='(3027) Energy pills'
                  3052='(3052) Speed; otherwise unspecified'
                  4001='(4001) Actron, Ketoprofen, Orudis, Oruvail'
                  4002='(4002) Imitrex, Sumatriptan' 4005='(4005) Etodolac, Lodine'
                  4029='(4029) Feldine, Piroxicam'
                  4031='(4031) Cough medicine with codeine' 4033='(4033) Vicoprofen'
                  4034='(4034) Lilly red' 4035='(4035) Nabumetone, Relafin'
                  4037='(4037) MS Contin' 4039='(4039) Daypro' 4044='(4044) Hydrocodone'
                  4046='(4046) Oxycodone' 4047='(4047) Roxicet' 4052='(4052) Endocet'
                  4053='(4053) Codydramol' 4054='(4054) Zomax' 4055='(4055) Vioxx'
                  4058='(4058) Totem poles' 6076='(6076) Lemon 714' 8002='(8002) Zantac'
                  8007='(8007) Gabapentin, Neurontin'
                  8008='(8008) Antidepressant; type unspecified'
                  8010='(8010) Zyrtec, cetirizine' 8018='(8018) Claritromicina'
                  8020='(8020) Allegra'
                  8024='(8024) Asthma inhaler,asthma medication,bronchial dilator'
                  8025='(8025) Claritin, Claritin D' 8032='(8032) Prilosec'
                  8035='(8035) Prednisone' 8052='(8052) Bactrim, Septra'
                  8057='(8057) Natacyn, Natamycin ophthalmic'
                  8058='(8058) Cough medicine/syrup; type unspecified'
                  9981='(9981) NEVER USED PAIN RELIEVERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assigned'
                  9991='(9991) NEVER USED PAIN RELIEVERS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE analnewb  108='(108) Nembutal' 110='(110) Tuinal' 112='(112) Restoril, Temazepam'
                  116='(116) Methaqualone, Quaalude, Sopor'
                  120='(120) Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
                  130='(130) Phenergan, Promethazine' 138='(138) Mandrakes'
                  186='(186) Butalbital' 201='(201) Valium, Diazepam' 205='(205) Serax'
                  209='(209) Xanax, Alprazolam' 211='(211) Buspar'
                  223='(223) Carbacot, Marbaxin, Methocarbamol, Robaxin'
                  225='(225) Desyrel, Trazodone hydrochloride'
                  234='(234) Cyclobenzaprine, Flexeril'
                  240='(240) Lithium carbonate, Lithonate' 241='(241) Prozac'
                  268='(268) Rohypnol, Roche, roofies' 283='(283) Paroxetine, Paxil'
                  292='(292) Serzone' 301='(301) Dexedrine'
                  318='(318) Ritalin, Methylphenidate' 335='(335) Dexatrim <OTC>'
                  356='(356) Dexies' 406='(406) Percodan' 407='(407) Demerol'
                  409='(409) Tylenol with Codeine, Tylenol 3, Tylenol 4'
                  415='(415) Codeine'
                  420='(420) OTHER Analgesic, NOT OTHERWISE SPECIFIED'
                  421='(421) USED ANALGESIC, DON''T KNOW NAME' 422='(422) Motrin'
                  425='(425) Advil <OTC>' 427='(427) Darvocet'
                  430='(430) Aspirin, Ecotrin, Empirin <OTC>' 433='(433) Paregoric'
                  434='(434) Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin'
                  435='(435) Tylenol, Tylenol Extra-Strength <OTC>'
                  438='(438) Anaprox, Naprosyn, Naproxen' 442='(442) Ibuprofen'
                  458='(458) Mepergan, Mepergan Fortis, Meprozine'
                  481='(481) Acular, Ketorolac tromethamine, Toradol' 496='(496) Ultram'
                  858='(858) Antibiotic' 894='(894) Depakene, Depakote, Valproic Acid'
                  900='(900) Not a drug' 2001='(2001) Carisoprodol, Soma' 3023='(3023) Adderall'
                  4035='(4035) Nabumetone, Relafin' 4044='(4044) Hydrocodone'
                  4051='(4051) Celebrex' 4058='(4058) Totem poles' 8002='(8002) Zantac'
                  8043='(8043) Accolate' 8044='(8044) Cephelaxin' 8051='(8051) Sinex <OTC>'
                  9981='(9981) NEVER USED PAIN RELIEVERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assigned'
                  9991='(9991) NEVER USED PAIN RELIEVERS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE analnewc  110='(110) Tuinal' 171='(171) NyQuil <OTC>' 174='(174) Ambien, Zolpidem'
                  201='(201) Valium, Diazepam' 209='(209) Xanax, Alprazolam' 211='(211) Buspar'
                  241='(241) Prozac' 271='(271) Zoloft' 318='(318) Ritalin, Methylphenidate'
                  336='(336) Diet pills' 356='(356) Dexies' 407='(407) Demerol'
                  409='(409) Tylenol with Codeine, Tylenol 3, Tylenol 4'
                  415='(415) Codeine' 421='(421) USED ANALGESIC, DON''T KNOW NAME'
                  423='(423) Percocet' 425='(425) Advil <OTC>'
                  430='(430) Aspirin, Ecotrin, Empirin <OTC>'
                  434='(434) Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin'
                  442='(442) Ibuprofen' 2001='(2001) Carisoprodol, Soma' 4027='(4027) Rorer'
                  4059='(4059) Zomig, Zolmitriptan' 8020='(8020) Allegra'
                  9981='(9981) NEVER USED PAIN RELIEVERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assigned'
                  9991='(9991) NEVER USED PAIN RELIEVERS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE analnewd  109='(109) Seconal' 110='(110) Tuinal' 115='(115) Phenobarbital' 137='(137) 7-14'
                  234='(234) Cyclobenzaprine, Flexeril'
                  268='(268) Rohypnol, Roche, roofies' 271='(271) Zoloft'
                  318='(318) Ritalin, Methylphenidate'
                  409='(409) Tylenol with Codeine, Tylenol 3, Tylenol 4'
                  415='(415) Codeine' 421='(421) USED ANALGESIC, DON''T KNOW NAME'
                  422='(422) Motrin' 427='(427) Darvocet' 431='(431) Tylox' 442='(442) Ibuprofen'
                  2001='(2001) Carisoprodol, Soma'
                  3015='(3015) Fen-Phen (fenfluramine and phentermine)'
                  3017='(3017) Dayquil <OTC>' 4047='(4047) Roxicet'
                  8025='(8025) Claritin, Claritin D'
                  9981='(9981) NEVER USED PAIN RELIEVERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assigned'
                  9991='(9991) NEVER USED PAIN RELIEVERS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE analnewe  112='(112) Restoril, Temazepam' 201='(201) Valium, Diazepam'
                  207='(207) Ativan, Lorazapam' 240='(240) Lithium carbonate, Lithonate'
                  415='(415) Codeine' 466='(466) Midol <OTC>' 658='(658) Special K, Ketamine'
                  2001='(2001) Carisoprodol, Soma' 4046='(4046) Oxycodone'
                  9981='(9981) NEVER USED PAIN RELIEVERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED PAIN RELIEVERS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE analage   981='(981) NEVER USED PAIN RELIEVERS Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED PAIN RELIEVERS' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE analyfu   9981='(9981) NEVER USED PAIN RELIEVERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED PAIN RELIEVERS' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE analmfu   1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE analrec   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in lifetime LOG ASSN'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE anlyrtot  981='(981) NEVER USED PAIN RELIEVERS Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED PAIN RELIEVERS'
                  993='(993) DID NOT USE PAIN RELIEVERS IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE prtotfg   98='(98) BLANK (NO ANSWER)' ;
  VALUE prfqflg   1='(1) Trimmed to be consistent with mo/yr of 1st use'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE prbstway  1='(1) Prefer to answer in days per week'
                  2='(2) Prefer to answer in days per month'
                  3='(3) Prefer to answer in days per year'
                  11='(11) Prefer to ans in days per wk LOG ASSN'
                  12='(12) Prefer to ans in days per mo LOG ASSN'
                  13='(13) Prefer to ans in days per yr LOG ASSN'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS IN PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE prdaypyr  981='(981) NEVER USED PAIN RELIEVERS Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  989='(989) LEGITIMATE SKIP Logically assigned'
                  991='(991) NEVER USED PAIN RELIEVERS'
                  993='(993) DID NOT USE PAIN RELIEVERS IN PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE prdaypmo  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS IN PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE prdaypwk  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS IN PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE klonopin  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE xnaxatvn  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE valmdiaz  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE trncard   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE atarax    1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE buspar    1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE equanil   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE flexeril  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE librium   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE limbtrol  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE meprob    1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE miltown   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE rohypnol  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE serax     1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE soma      1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE tranxene  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE vistar    1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE trnolst   1='(1) Yes' 2='(2) No' 4='(4) No LOGICALLY ASSIGNED'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE trnewa    108='(108) Nembutal' 109='(109) Seconal' 110='(110) Tuinal' 113='(113) Halcion'
                  115='(115) Phenobarbital' 116='(116) Methaqualone, Quaalude, Sopor'
                  120='(120) Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
                  129='(129) Reds' 131='(131) Haldol, Haloperidol' 174='(174) Ambien, Zolpidem'
                  186='(186) Butalbital' 201='(201) Valium, Diazepam'
                  207='(207) Ativan, Lorazapam' 209='(209) Xanax, Alprazolam'
                  216='(216) Atarax, Hydroxyzine'
                  221='(221) OTHER Tranquilizer, NOT OTHERWISE SPECIFIED'
                  222='(222) USED TRANQUILIZER, DON''T KNOW NAME'
                  223='(223) Carbacot, Marbaxin, Methocarbamol, Robaxin'
                  224='(224) Triavil' 225='(225) Desyrel, Trazodone hydrochloride'
                  227='(227) Thorazine' 228='(228) Amitriptyline, Elavil' 232='(232) Mellaril'
                  234='(234) Cyclobenzaprine, Flexeril'
                  240='(240) Lithium carbonate, Lithonate' 241='(241) Prozac'
                  268='(268) Rohypnol, Roche, roofies' 271='(271) Zoloft'
                  283='(283) Paroxetine, Paxil' 289='(289) Olanzapine, Zyprexa'
                  290='(290) Skelaxin' 318='(318) Ritalin, Methylphenidate'
                  351='(351) Cathinone, Q''at, Cat' 408='(408) Dilaudid'
                  417='(417) Morphine, Roxanol'
                  420='(420) OTHER Analgesic, NOT OTHERWISE SPECIFIED'
                  423='(423) Percocet' 427='(427) Darvocet'
                  434='(434) Anexsia, Co-Gesic, Lorcet,Lortab,Tussionex,Vicodin'
                  438='(438) Anaprox, Naprosyn, Naproxen' 658='(658) Special K, Ketamine'
                  663='(663) Animal tranquilizer, horse tranquilizer'
                  847='(847) GHB, NSC' 2001='(2001) Carisoprodol, Soma'
                  2002='(2002) Muscle Relaxers' 3023='(3023) Adderall'
                  4001='(4001) Actron, Ketoprofen, Orudis, Oruvail' 4039='(4039) Daypro'
                  4049='(4049) Headache power <OTC>' 8002='(8002) Zantac'
                  9981='(9981) NEVER USED TRANQUILIZERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assigned'
                  9991='(9991) NEVER USED TRANQUILIZERS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE trnewb    109='(109) Seconal' 137='(137) 7-14' 201='(201) Valium, Diazepam'
                  202='(202) Librium, Chlordiazepoxide HCl' 209='(209) Xanax, Alprazolam'
                  221='(221) OTHER Tranquilizer, NOT OTHERWISE SPECIFIED'
                  222='(222) USED TRANQUILIZER, DON''T KNOW NAME'
                  225='(225) Desyrel, Trazodone hydrochloride'
                  268='(268) Rohypnol, Roche, roofies'
                  318='(318) Ritalin, Methylphenidate' 415='(415) Codeine'
                  417='(417) Morphine, Roxanol'
                  663='(663) Animal tranquilizer, horse tranquilizer'
                  4049='(4049) Headache power <OTC>'
                  9981='(9981) NEVER USED TRANQUILIZERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED TRANQUILIZERS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE trnewc    131='(131) Haldol, Haloperidol' 268='(268) Rohypnol, Roche, roofies'
                  8009='(8009) Allergy pills; type unspecified'
                  9981='(9981) NEVER USED TRANQUILIZERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED TRANQUILIZERS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE trnewd    435='(435) Tylenol, Tylenol Extra-Strength <OTC>'
                  9981='(9981) NEVER USED TRANQUILIZERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED TRANQUILIZERS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE trnewe    9981='(9981) NEVER USED TRANQUILIZERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED TRANQUILIZERS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE tranage   981='(981) NEVER USED TRANQUILIZERS Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED TRANQUILIZERS' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE tranyfu   9981='(9981) NEVER USED TRANQUILIZERS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED TRANQUILIZERS' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE tranmfu   1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE tranrec   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in lifetime LOG ASSN'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE trnyrtot  981='(981) NEVER USED TRANQUILIZERS Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED TRANQUILIZERS'
                  993='(993) DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE trtotfg   98='(98) BLANK (NO ANSWER)' ;
  VALUE trfqflg   1='(1) Trimmed to be consistent with mo/yr of 1st use'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE trbstway  1='(1) Prefer to answer in days per week'
                  2='(2) Prefer to answer in days per month'
                  3='(3) Prefer to answer in days per year'
                  11='(11) Prefer to ans in days per wk LOG ASSN'
                  12='(12) Prefer to ans in days per mo LOG ASSN'
                  13='(13) Prefer to ans in days per yr LOG ASSN'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trdaypyr  981='(981) NEVER USED TRANQUILIZERS Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  989='(989) LEGITIMATE SKIP Logically assigned'
                  991='(991) NEVER USED TRANQUILIZERS'
                  993='(993) DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE trdaypmo  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE trdaypwk  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE methdes   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE dietpils  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE ritmphen  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE stmcard   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE cylert    1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE dexed     1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE detamp    1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE didrex    1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE eskat     1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ionamin   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE mazanor   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE obla      1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE plegine   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE preludin  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sanorex   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE tenuate   1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmnolst  1='(1) Yes' 2='(2) No' 4='(4) No LOGICALLY ASSIGNED'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE stimnewa  115='(115) Phenobarbital' 116='(116) Methaqualone, Quaalude, Sopor'
                  124='(124) Yellow jackets' 174='(174) Ambien, Zolpidem'
                  207='(207) Ativan, Lorazapam' 209='(209) Xanax, Alprazolam'
                  225='(225) Desyrel, Trazodone hydrochloride'
                  240='(240) Lithium carbonate, Lithonate' 241='(241) Prozac'
                  247='(247) Adapin, Doxepin, Sinequan'
                  268='(268) Rohypnol, Roche, roofies' 271='(271) Zoloft'
                  283='(283) Paroxetine, Paxil' 302='(302) Dexamyl' 304='(304) Benzedrine'
                  305='(305) Biphetamine' 307='(307) Tenuate, Diethylpropion'
                  311='(311) Preludin' 313='(313) Adipex-P, Fastin, Phentermine'
                  318='(318) Ritalin, Methylphenidate'
                  322='(322) Methamphetamine ("ice" or "crank"), Meth'
                  324='(324) Uppers; OTHER Stimulant, NOT OTHERWISE SPECIFIED'
                  325='(325) USED STIMULANT, DON''T KNOW NAME' 326='(326) White cross'
                  327='(327) Black beauties, Black beauty'
                  329='(329) Bird''s eggs, Robin''s eggs, speckled eggs'
                  330='(330) Blue birds, blue jays, blue robins, speckled bird'
                  331='(331) Blancs, Whites' 332='(332) Ephedrine'
                  334='(334) Crossroads, cross tops' 335='(335) Dexatrim <OTC>'
                  336='(336) Diet pills' 344='(344) Bennies' 345='(345) Black Molly'
                  348='(348) Crystal' 352='(352) Lemons' 355='(355) Crystal meth' 356='(356) Dexies'
                  364='(364) Pseudoephedrine' 374='(374) Christmas tree(s)'
                  387='(387) Pink football' 417='(417) Morphine, Roxanol'
                  509='(509) Correction fluids, degreasers, cleaning fluids'
                  635='(635) Ginseng seeds, ginseng weed' 806='(806) Crack, rock'
                  897='(897) Synthroid, Levothyroxine' 3004='(3004) Black cadillac'
                  3015='(3015) Fen-Phen (fenfluramine and phentermine)'
                  3023='(3023) Adderall' 3026='(3026) Bupropion, Wellbutrin, Zyban'
                  3036='(3036) Ripped fuel <OTC>' 3049='(3049) Truck drivers speed'
                  3050='(3050) Mini Thins' 3052='(3052) Speed; otherwise unspecified'
                  3055='(3055) Clenbuterol' 3062='(3062) Homemade Stimulants'
                  8012='(8012) Coriciden <OTC>' 8026='(8026) Powder' 8048='(8048) Theophylline'
                  9981='(9981) NEVER USED STIMULANTS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assigned'
                  9991='(9991) NEVER USED STIMULANTS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE stimnewb  137='(137) 7-14' 271='(271) Zoloft' 301='(301) Dexedrine'
                  318='(318) Ritalin, Methylphenidate'
                  324='(324) Uppers; OTHER Stimulant, NOT OTHERWISE SPECIFIED'
                  325='(325) USED STIMULANT, DON''T KNOW NAME' 326='(326) White cross'
                  327='(327) Black beauties, Black beauty' 328='(328) Pink hearts'
                  330='(330) Blue birds, blue jays, blue robins, speckled bird'
                  332='(332) Ephedrine' 333='(333) 357 Magnum, Magnum 44 <OTC>'
                  334='(334) Crossroads, cross tops' 336='(336) Diet pills'
                  345='(345) Black Molly' 374='(374) Christmas tree(s)'
                  614='(614) MDA, Methylenedioxy amphetamine'
                  894='(894) Depakene, Depakote, Valproic Acid' 3023='(3023) Adderall'
                  3052='(3052) Speed; otherwise unspecified' 3058='(3058) Metabolift <OTC>'
                  3067='(3067) Spancap'
                  9981='(9981) NEVER USED STIMULANTS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assigned'
                  9991='(9991) NEVER USED STIMULANTS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE stimnewc  124='(124) Yellow jackets'
                  330='(330) Blue birds, blue jays, blue robins, speckled bird'
                  334='(334) Crossroads, cross tops' 374='(374) Christmas tree(s)'
                  3004='(3004) Black cadillac' 3033='(3033) Metabolife <OTC>'
                  3047='(3047) Sudafed <OTC>'
                  9981='(9981) NEVER USED STIMULANTS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assigned'
                  9991='(9991) NEVER USED STIMULANTS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE stimnewd  3056='(3056) Xenadrine <OTC>'
                  9981='(9981) NEVER USED STIMULANTS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED STIMULANTS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE stimnewe  9981='(9981) NEVER USED STIMULANTS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED STIMULANTS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE stimage   981='(981) NEVER USED STIMULANTS Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED STIMULANTS' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' ;
  VALUE stimyfu   9981='(9981) NEVER USED STIMULANTS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assn'
                  9991='(9991) NEVER USED STIMULANTS' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE stimmfu   1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assn'
                  91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stimrec   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in lifetime LOG ASSN'
                  11='(11) Used in the past 30 days LOGICALLY ASSIGNED'
                  12='(12) Used >30 days ago but within pst 12 mos LOG ASSN'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE stmyrtot  981='(981) NEVER USED STIMULANTS Logically assigned'
                  983='(983) DID NOT USE STIMULANTS PAST 12 MOS Log assn'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED STIMULANTS'
                  993='(993) DID NOT USE STIMULANTS IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE sttotfg   98='(98) BLANK (NO ANSWER)' ;
  VALUE stfqflg   1='(1) Trimmed to be consistent with mo/yr of 1st use'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE stbstway  1='(1) Prefer to answer in days per week'
                  2='(2) Prefer to answer in days per month'
                  3='(3) Prefer to answer in days per year'
                  11='(11) Prefer to ans in days per wk LOG ASSN'
                  12='(12) Prefer to ans in days per mo LOG ASSN'
                  13='(13) Prefer to ans in days per yr LOG ASSN'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  83='(83) DID NOT USE STIMULANTS PAST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE stdaypyr  981='(981) NEVER USED STIMULANTS Logically assigned'
                  983='(983) DID NOT USE STIMULANTS PAST 12 MOS Log assn'
                  989='(989) LEGITIMATE SKIP Logically assigned'
                  991='(991) NEVER USED STIMULANTS'
                  993='(993) DID NOT USE STIMULANTS IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE stdaypmo  81='(81) NEVER USED STIMULANTS Logically assigned'
                  83='(83) DID NOT USE STIMULANTS PAST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE stdaypwk  81='(81) NEVER USED STIMULANTS Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE methage   981='(981) NEVER USED METHAMPHETAMINES Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED METHAMPHETAMINES' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE methyfu   9981='(9981) NEVER USED METHAMPHETAMINES Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED METHAMPHETAMINES' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE methmfu   1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  81='(81) NEVER USED METHAMPHETAMINES Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED METHAMPHETAMINES' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE methrec   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in lifetime LOG ASSN'
                  81='(81) NEVER USED METHAMPHETAMINES Logically assigned'
                  91='(91) NEVER USED METHAMPHETAMINES' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE methaq    1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE nembbarb  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE resttmaz  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sedcard   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE amytal    1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE butisol   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE chhyd     1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE dalmane   1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE halcion   1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE phenobar  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE placidyl  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE tuinal    1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE sednolst  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sednewa   105='(105) Placidyl' 110='(110) Tuinal' 111='(111) Dalmane, Flurazepam'
                  113='(113) Halcion' 115='(115) Phenobarbital'
                  116='(116) Methaqualone, Quaalude, Sopor'
                  120='(120) Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
                  121='(121) USED SEDATIVE, DON''T KNOW NAME' 129='(129) Reds'
                  138='(138) Mandrakes' 146='(146) Bentyl, Dicyclomine'
                  174='(174) Ambien, Zolpidem' 188='(188) Estazolam'
                  201='(201) Valium, Diazepam'
                  225='(225) Desyrel, Trazodone hydrochloride'
                  228='(228) Amitriptyline, Elavil'
                  246='(246) Clonazepam, Klonopin, Rivotril'
                  247='(247) Adapin, Doxepin, Sinequan'
                  268='(268) Rohypnol, Roche, roofies' 271='(271) Zoloft'
                  283='(283) Paroxetine, Paxil' 295='(295) Mirtazapine, Remeron'
                  355='(355) Crystal meth' 457='(457) T''s and blues'
                  658='(658) Special K, Ketamine' 802='(802) THC, cannabinol, marinol'
                  2001='(2001) Carisoprodol, Soma' 4044='(4044) Hydrocodone'
                  8010='(8010) Zyrtec, cetirizine' 8049='(8049) Sorbitol'
                  9981='(9981) NEVER USED SEDATIVES Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED SEDATIVES' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE sednewb   120='(120) Downers; OTHER Sedative, NOT OTHERWISE SPECIFIED'
                  121='(121) USED SEDATIVE, DON''T KNOW NAME'
                  174='(174) Ambien, Zolpidem'
                  225='(225) Desyrel, Trazodone hydrochloride'
                  9981='(9981) NEVER USED SEDATIVES Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED SEDATIVES' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE sednewc   174='(174) Ambien, Zolpidem'
                  9981='(9981) NEVER USED SEDATIVES Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED SEDATIVES' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE sednewd   174='(174) Ambien, Zolpidem'
                  9981='(9981) NEVER USED SEDATIVES Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED SEDATIVES' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE sednewe   174='(174) Ambien, Zolpidem'
                  9981='(9981) NEVER USED SEDATIVES Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED SEDATIVES' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE sedage    981='(981) NEVER USED SEDATIVES Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED SEDATIVES' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' ;
  VALUE sedyfu    9981='(9981) NEVER USED SEDATIVES Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED SEDATIVES' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE sedmfu    1='(1) January' 2='(2) February' 3='(3) March' 4='(4) April' 5='(5) May'
                  6='(6) June' 7='(7) July' 8='(8) August' 9='(9) September' 10='(10) October'
                  11='(11) November' 12='(12) December'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE sedrec    1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  8='(8) Used at some point in the past 12 mos LOG ASSN'
                  9='(9) Used at some point in lifetime LOG ASSN'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sedyrtot  981='(981) NEVER USED SEDATIVES Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED SEDATIVES'
                  993='(993) DID NOT USE SEDATIVES IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE svtotfg   98='(98) BLANK (NO ANSWER)' ;
  VALUE svfqflg   1='(1) Trimmed to be consistent with mo/yr of 1st use'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE svbstway  1='(1) Prefer to answer in days per week'
                  2='(2) Prefer to answer in days per month'
                  3='(3) Prefer to answer in days per year'
                  12='(12) Prefer to ans in days per mo LOG ASSN'
                  13='(13) Prefer to ans in days per yr LOG ASSN'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE svdaypyr  981='(981) NEVER USED SEDATIVES Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  989='(989) LEGITIMATE SKIP Logically assigned'
                  991='(991) NEVER USED SEDATIVES'
                  993='(993) DID NOT USE SEDATIVES IN THE PAST 12 MOS'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE svdaypmo  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE svdaypwk  81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES IN THE PAST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ircigrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago but within the past 3 yrs'
                  4='(4) More than 3 years ago' 9='(9) Never smoked cigarettes' ;
  VALUE iicigrc   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2cigrc  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8'
                  6='(6) Statistically imputed data - edited recency=19'
                  7='(7) Statistically imputed data - edited recency=14' ;
  VALUE ircgrrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago but within the past 3 yrs'
                  4='(4) More than 3 years ago' 9='(9) Never smoked cigars' ;
  VALUE iicgrrc   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2cgrrc  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8'
                  6='(6) Statistically imputed data - edited recency=19'
                  7='(7) Statistically imputed data - edited recency=14' ;
  VALUE irpiplf   1='(1) Ever used pipes' 9='(9) Never smoked pipes' ;
  VALUE iipiplf   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irpipmn   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within lifetime'
                  9='(9) Never smoked pipes' ;
  VALUE iipipmn   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irsltrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago but within the past 3 yrs'
                  4='(4) More than 3 years ago' 9='(9) Never used smokeless tobacco' ;
  VALUE iisltrc   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2sltrc  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8'
                  6='(6) Statistically imputed data - edited recency=19'
                  7='(7) Statistically imputed data - edited recency=14' ;
  VALUE irchwrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago but within the past 3 yrs'
                  4='(4) More than 3 years ago' 9='(9) Never used chewing tobacco' ;
  VALUE iichwrc   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2chwrc  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8'
                  6='(6) Statistically imputed data - edited recency=19'
                  7='(7) Statistically imputed data - edited recency=14' ;
  VALUE irsnfrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago but within the past 3 yrs'
                  4='(4) More than 3 years ago' 9='(9) Never used snuff' ;
  VALUE iisnfrc   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2snfrc  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8'
                  6='(6) Statistically imputed data - edited recency=19'
                  7='(7) Statistically imputed data - edited recency=14' ;
  VALUE iralcrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used alcohol' ;
  VALUE iialcrc   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2alcrc  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE irmjrc    1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used marijuana' ;
  VALUE iimjrc    1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2mjrc   1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE ircocrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used cocaine' ;
  VALUE iicocrc   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2cocrc  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE ircrkrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used crack' ;
  VALUE iicrkrc   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2crkrc  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE irherrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used heroin' ;
  VALUE iiherrc   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2herrc  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE irhalrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used hallucinogens' ;
  VALUE iihalrc   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2halrc  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE irlsdrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used LSD' ;
  VALUE iilsdrc   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2lsdrc  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE irpcprc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used PCP' ;
  VALUE iipcprc   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2pcprc  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE irinhrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used inhalants' ;
  VALUE iiinhrc   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2inhrc  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE iranlrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used pain relievers' ;
  VALUE iianlrc   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2anlrc  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE irtrnrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used tranquilizers' ;
  VALUE iitrnrc   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2trnrc  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE irstmrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used stimulants' ;
  VALUE iistmrc   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2stmrc  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE irmthrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used methamphetamines' ;
  VALUE iimthrc   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2mthrc  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE irsedrc   1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 9='(9) Never used sedatives' ;
  VALUE iisedrc   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2sedrc  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - edited recency=9'
                  5='(5) Statistically imputed data - edited recency=8' ;
  VALUE iralcfy   991='(991) NEVER USED ALCOHOL'
                  993='(993) DID NOT USE ALCOHOL PAST YEAR' ;
  VALUE iialcfy   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2alcfy  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irmjfy    991='(991) NEVER USED MARIJUANA'
                  993='(993) DID NOT USE MARIJUANA PAST YEAR' ;
  VALUE iimjfy    1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2mjfy   1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE ircocfy   991='(991) NEVER USED COCAINE'
                  993='(993) DID NOT USE COCAINE PAST YEAR' ;
  VALUE iicocfy   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2cocfy  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE ircrkfy   991='(991) NEVER USED CRACK' 993='(993) DID NOT USE CRACK PAST YEAR' ;
  VALUE iicrkfy   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2crkfy  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irherfy   991='(991) NEVER USED HEROIN' 993='(993) DID NOT USE HEROIN PAST YEAR' ;
  VALUE iiherfy   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2herfy  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irhalfy   991='(991) NEVER USED HALLUCINOGENS'
                  993='(993) DID NOT USE HALLUCINOGENS PAST YEAR' ;
  VALUE iihalfy   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2halfy  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irinhfy   991='(991) NEVER USED INHALANTS'
                  993='(993) DID NOT USE INHALANTS PAST YEAR' ;
  VALUE iiinhfy   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2inhfy  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE iranlfy   991='(991) NEVER USED PAIN RELIEVER'
                  993='(993) DID NOT USE PAIN RELIEVER PAST YEAR' ;
  VALUE iianlfy   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2anlfy  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irtrnfy   991='(991) NEVER USED TRANQUILIZERS'
                  993='(993) DID NOT USE TRANQUILIZERS PAST YEAR' ;
  VALUE iitrnfy   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2trnfy  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irstmfy   991='(991) NEVER USED STIMULANTS'
                  993='(993) DID NOT USE STIMULANTS PAST YEAR' ;
  VALUE iistmfy   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2stmfy  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irsedfy   991='(991) NEVER USED SEDATIVES'
                  993='(993) DID NOT USE SEDATIVES PAST YEAR' ;
  VALUE iisedfy   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2sedfy  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE ircigfm   91.00='(91.00) NEVER USED'
                  93.00='(93.00) DID NOT USE CIGARETTES PAST MONTH' ;
  VALUE iicigfm   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2cigfm  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE ircgrfm   91.00='(91.00) NEVER SMOKED CIGARS'
                  93.00='(93.00) DID NOT SMOKE CIGARS PAST MONTH' ;
  VALUE iicgrfm   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2cgrfm  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irchwfm   91.00='(91.00) NEVER USED CHEWING TOBACCO'
                  93.00='(93.00) DID NOT USE CHEWING TOBACCO PAST MONTH' ;
  VALUE iichwfm   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2chwfm  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irsnffm   91.00='(91.00) NEVER USED SNUFF'
                  93.00='(93.00) DID NOT USE SNUFF PAST MONTH' ;
  VALUE iisnffm   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2snffm  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE iralcfm   91.00='(91.00) NEVER USED ALCOHOL'
                  93.00='(93.00) DID NOT USE ALCOHOL PAST MONTH' ;
  VALUE iialcfm   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2alcfm  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE iralcd5f  91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT HAVE 5+ ALC DRNKS PAST MONTH' ;
  VALUE iialcd5f  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2alcdf  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irmjfm    91.00='(91.00) NEVER USED MARIJUANA'
                  93.00='(93.00) DID NOT USE MARIJUANA PAST MONTH' ;
  VALUE iimjfm    1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2mjfm   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE ircocfm   91.00='(91.00) NEVER USED COCAINE'
                  93.00='(93.00) DID NOT USE COCAINE PAST MONTH' ;
  VALUE iicocfm   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2cocfm  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE ircrkfm   91.00='(91.00) NEVER USED CRACK'
                  93.00='(93.00) DID NOT USE CRACK PAST MONTH' ;
  VALUE iicrkfm   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2crkfm  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irherfm   91='(91) NEVER USED HEROIN' 93='(93) DID NOT USE HEROIN PAST MONTH' ;
  VALUE iiherfm   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE ii2herfm  1='(1) Questionnaire data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irhalfm   91.00='(91.00) NEVER USED HALLUCINOGENS'
                  93.00='(93.00) DID NOT USE HALLUCINOGENS PAST MONTH' ;
  VALUE iihalfm   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2halfm  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE irinhfm   91.00='(91.00) NEVER USED INHALANTS'
                  93.00='(93.00) DID NOT USE INHALANTS PAST MONTH' ;
  VALUE iiinhfm   1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE ii2inhfm  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data - lifetime use imputed'
                  4='(4) Statistically imputed data - lifetime use known' ;
  VALUE ircigage  991='(991) NEVER USED' ;
  VALUE iicigage  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE ircigyfu  9999='(9999) NEVER USED' ;
  VALUE iicigyfu  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE ircduage  991='(991) Never Used' 993='(993) Never a daily user' ;
  VALUE iicduage  1='(1) Questionnaire Data' 3='(3) Statistically imputed data' ;
  VALUE ircduyfu  9993='(9993) NEVER A DAILY USER' 9999='(9999) NEVER USED' ;
  VALUE iicduyfu  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE ircgrage  991='(991) NEVER USED' ;
  VALUE iicgrage  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE ircgryfu  9999='(9999) NEVER USED' ;
  VALUE iicgryfu  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irsnfage  991='(991) Never Used' ;
  VALUE iisnfage  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irsnfyfu  9999='(9999) NEVER USED' ;
  VALUE iisnfyfu  1='(1) Questionnaire Data' 3='(3) Statistical Imputation' ;
  VALUE irchwage  991='(991) NEVER USED' ;
  VALUE iichwage  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irchwyfu  9999='(9999) Never Used' ;
  VALUE iichwyfu  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irsltage  991='(991) Never Used' ;
  VALUE iisltage  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irsltyfu  9999='(9999) Never Used' ;
  VALUE iisltyfu  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE iralcage  991='(991) Never Used' ;
  VALUE iialcage  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE iralcyfu  9999='(9999) NEVER USED' ;
  VALUE iialcyfu  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irmjage   991='(991) Never Used' ;
  VALUE iimjage   1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irmjyfu   9999='(9999) Never Used' ;
  VALUE iimjyfu   1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE ircocage  991='(991) Never Used' ;
  VALUE iicocage  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE ircocyfu  9999='(9999) Never Used' ;
  VALUE iicocyfu  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE ircrkage  991='(991) Never Used' ;
  VALUE iicrkage  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically Imputed Data' ;
  VALUE ircrkyfu  9999='(9999) Never Used' ;
  VALUE iicrkyfu  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irherage  991='(991) Never Used' ;
  VALUE iiherage  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irheryfu  9999='(9999) Never Used' ;
  VALUE iiheryfu  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irhalage  991='(991) Never Used' ;
  VALUE iihalage  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irhalyfu  9999='(9999) Never Used' ;
  VALUE iihalyfu  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irlsdage  991='(991) Never Used' ;
  VALUE iilsdage  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically imputed data' ;
  VALUE irlsdyfu  9999='(9999) NEVER USED' ;
  VALUE iilsdyfu  1='(1) Questionnaire Data' 3='(3) Statistically imputed data' ;
  VALUE irpcpage  991='(991) Never Used' ;
  VALUE iipcpage  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically imputed data' ;
  VALUE irpcpyfu  9999='(9999) NEVER USED' ;
  VALUE iipcpyfu  1='(1) Questionnaire Data' 3='(3) Statistically imputed data' ;
  VALUE irinhage  991='(991) Never Used' ;
  VALUE iiinhage  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE irinhyfu  9999='(9999) Never Used' ;
  VALUE iiinhyfu  1='(1) Questionnaire Data' 3='(3) Statistically Imputed Data' ;
  VALUE iranlage  991='(991) Never Used' ;
  VALUE iianlage  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically Imputed Data' ;
  VALUE iranlyfu  9999='(9999) Never Used' ;
  VALUE iianlyfu  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically Imputed Data' ;
  VALUE irtrnage  991='(991) Never Used' ;
  VALUE iitrnage  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically Imputed Data' ;
  VALUE irtrnyfu  9999='(9999) Never Used' ;
  VALUE iitrnyfu  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically Imputed Data' ;
  VALUE irstmage  991='(991) Never Used' ;
  VALUE iistmage  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically Imputed Data' ;
  VALUE irstmyfu  9999='(9999) Never Used' ;
  VALUE iistmyfu  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically Imputed Data' ;
  VALUE irmthage  991='(991) Never Used' ;
  VALUE iimthage  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically Imputed Data' ;
  VALUE irmthyfu  9999='(9999) Never Used' ;
  VALUE iimthyfu  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically Imputed Data' ;
  VALUE irsedage  991='(991) Never Used' ;
  VALUE iisedage  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically Imputed Data' ;
  VALUE irsedyfu  9999='(9999) Never Used' ;
  VALUE iisedyfu  1='(1) Questionnaire Data' 2='(2) Logical Edited Data'
                  3='(3) Statistically Imputed Data' ;
  VALUE cigflag   0='(0) Never used (IRCIGRC = 9)' 1='(1) Ever used (IRCIGRC = 1-4)' ;
  VALUE cigyr     0='(0) Did not use in the past year (IRCIGRC = 3,4,9)'
                  1='(1) Used within the past year (IRCIGRC = 1,2)' ;
  VALUE cigmon    0='(0) Did not use in the past month (IRCIGRC = 2-4,9)'
                  1='(1) Used within the past month (IRCIGRC = 1)' ;
  VALUE cgrflag   0='(0) Never used (IRCGRRC = 9)' 1='(1) Ever used (IRCGRRC = 1-4)' ;
  VALUE cgryr     0='(0) Did not use in the past year (IRCGRRC = 3,4,9)'
                  1='(1) Used within the past year (IRCGRRC = 1,2)' ;
  VALUE cgrmon    0='(0) Did not use in the past month (IRCGRRC = 2-4,9)'
                  1='(1) Used within the past month (IRCGRRC = 1)' ;
  VALUE pipflag   0='(0) Never Used (IRPIPLF=9)' 1='(1) Ever Used (IRPIPLF=1)' ;
  VALUE pipmon    0='(0) Did not use in the past month (IRPIPMN=2,9)'
                  1='(1) Used within the past month (IRPIPMN=1)' ;
  VALUE smkflag   0='(0) Never used (IRSLTRC = 9)' 1='(1) Ever used (IRSLTRC = 1-4)' ;
  VALUE smkyr     0='(0) Did not use in the past year (IRSLTRC = 3,4,9)'
                  1='(1) Used within the past year (IRSLTRC = 1,2)' ;
  VALUE smkmon    0='(0) Did not use in the past month (IRSLTRC = 2-4,9)'
                  1='(1) Used within the past month (IRSLTRC = 1)' ;
  VALUE chwflag   0='(0) Never Used (IRCHWRC=9)' 1='(1) Ever Used (IRCHWRC=1-4)' ;
  VALUE chwyr     0='(0) Did not use in the past year (IRCHWRC=3,4,9)'
                  1='(1) Used within the past year (IRCHWRC=1,2)' ;
  VALUE chwmon    0='(0) Did not use in the past month (IRCHWRC=2-4,9)'
                  1='(1) Used within the past month (IRCHWRC=1)' ;
  VALUE snfflag   0='(0) Never used (IRSNFRC = 9)' 1='(1) Ever used (IRSNFRC = 1-4)' ;
  VALUE snfyr     0='(0) Did not use in the past year (IRSNFRC = 3,4,9)'
                  1='(1) Used within the past year (IRSNFRC = 1,2)' ;
  VALUE snfmon    0='(0) Did not use in the past month (IRSNFRC = 2-4,9)'
                  1='(1) Used within the past month (IRSNFRC = 1)' ;
  VALUE tobflag   0='(0) Never Used (all source vars=9)'
                  1='(1) Ever Used (any source var=1-4)' ;
  VALUE tobyr     0='(0) Never use pst yr(IRPIPMN=2,9 &oth src vars=3,4,9)'
                  1='(1) Used pst yr(IRPIPMN=1 or any oth src var=1,2)' ;
  VALUE tobmon    0='(0) Did not use in pst month (all source vars=2-4,9)'
                  1='(1) Used in past month (any source var=1)' ;
  VALUE cigbrndf  -9='Not Past Month Cigarette User (CIGMON=0)'
                  1='(1) Marlboro (CIG30BR2=112)' 2='(2) Newport (CIG30BR2=118)'
                  3='(3) Camel (CIG30BR2=104)' 4='(4) Basic (CIG30BR2=101)'
                  5='(5) Doral (CIG30BR2=107)' 6='(6) Winston (CIG30BR2=126)'
                  7='(7) GPC (CIG30BR2=109)' 8='(8) Virginia Slims (CIG30BR2=125)'
                  9='(9) Kool (CIG30BR2=111)' 10='(10) Salem (CIG30BR2=122)'
                  11='(11) Benson & Hedges (CIG30BR2=102)'
                  12='(12) Merit (CIG30BR2=113)' 13='(13) Misty (CIG30BR2=114)'
                  14='(14) Capri (CIG30BR2=105)' 15='(15) Parliament (CIG30BR2=120)'
                  16='(16) Carlton (CIG30BR2=106)'
                  17='(17) Other Brnd (CIG30BR2=other 100-199,1001-1999)'
                  18='(18) Unkwn Brnd (CIG30BR2=200-999,4039,4999,9000-9998)' ;
  VALUE cgrbrndf  -9='Not Past Month Cigar User (CGRMON=0)'
                  1='(1) Black and Mild (CGR30BR2 = 404)'
                  2='(2) Swisher Sweets (CGR30BR2 = 423)'
                  3='(3) Macanudos (CGR30BR2 = 416)'
                  4='(4) Phillies (CGR30BR2 = 419)'
                  5='(5) Garcia Y Vega (CGR30BR2 = 411)'
                  6='(6) Backwoods (CGR30BR2 = 402)'
                  7='(7) Havatampa (CGR30BR2 = 412)'
                  8='(8) Dutch Masters (CGR30BR2 = 408)'
                  9='(9) Cohiba (CGR30BR2 = 443)'
                  10='(10) King Edward (CGR30BR2 = 413)'
                  11='(11) Antonio Y Cleopatra (CGR30BR2 = 401)'
                  12='(12) Partagas (CGR30BR2 = 418)'
                  13='(13) Romeo & Julieta (CGR30BR2 = 496)'
                  14='(14) White Owl (CGR30BR2 = 426)'
                  15='(15) Arturo Fuentes (CGR30BR2 = 431)'
                  16='(16) Other Brnd (CGR30BR2 =other 400-499,4000-4999)'
                  17='(17) Unkwn Brnd (CGR30BR2=<399,701,1020,1077,9000-9998)' ;
  VALUE smkbrndf  -9='Not Past Month Smokeless Tobacco User (SMKMON=0)'
                  1='(1) Skoal (SLT30BR2=308)' 2='(2) Copenhagen (SLT30BR2=301)'
                  3='(3) Red Man (SLT30BR2=208)' 4='(4) Kodiak (SLT30BR2=305)'
                  5='(5) Beech-Nut (SLT30BR2=201)'
                  6='(6) Levi Garrett (SLT30BR2=206)'
                  7='(7) Timber Wolf (SLT30BR2=309)' 8='(8) Red Seal (SLT30BR2=316)'
                  9='(9) Silver Creek (SLT30BR2=307)'
                  10='(10) Other Brand (SLT30BR2=other 200-399,2999-3999)'
                  11='(11) Unkwn Brnd (SLT30BR2=<200,400-899,5999,9000-9998)' ;
  VALUE cigcmpny  1='(1) Philip Morris' 2='(2) R.J. Reynolds' 3='(3) Lorillard'
                  4='(4) Brown and Williamson' 5='(5) Liggett'
                  6='(6) Commonwealth Brands'
                  7='(7) Santa Fe Natural Tobacco Company'
                  70='(70) SOME OTHER BRAND/COMPANY'
                  80='(80) CIG BRAND/COMPANY NOT SPECIFIED'
                  85='(85) BAD DATA Log assn (CIG30BR2=9985)'
                  90='(90) NOT A CIGARETTE BRAND' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW (CIG30BR2=9994)'
                  97='(97) REFUSED (CIG30BR2=9997)' 98='(98) BLANK (CIG30BR2=9998)' ;
  VALUE alcflag   0='(0) Never used (IRALCRC = 9)' 1='(1) Ever used (IRALCRC = 1-3)' ;
  VALUE alcyr     0='(0) Did not use in the past year (IRALCRC = 3,9)'
                  1='(1) Used within the past year (IRALCRC = 1,2)' ;
  VALUE alcmon    0='(0) Did not use in the past month (IRALCRC = 2-3,9)'
                  1='(1) Used within the past month (IRALCRC = 1)' ;
  VALUE mrjflag   0='(0) Never used (IRMJRC = 9)' 1='(1) Ever used (IRMJRC = 1-3)' ;
  VALUE mrjyr     0='(0) Did not use in the past year (IRMJRC = 3,9)'
                  1='(1) Used within the past year (IRMJRC = 1,2)' ;
  VALUE mrjmon    0='(0) Did not use in the past month (IRMJRC = 2-3,9)'
                  1='(1) Used within the past month (IRMJRC = 1)' ;
  VALUE cocflag   0='(0) Never used (IRCOCRC = 9)' 1='(1) Ever used (IRCOCRC = 1-3)' ;
  VALUE cocyr     0='(0) Did not use in the past year (IRCOCRC = 3,9)'
                  1='(1) Used within the past year (IRCOCRC = 1,2)' ;
  VALUE cocmon    0='(0) Did not use in the past month (IRCOCRC = 2-3,9)'
                  1='(1) Used within the past month (IRCOCRC = 1)' ;
  VALUE crkflag   0='(0) Never used (IRCRKRC = 9)' 1='(1) Ever used (IRCRKRC = 1-3)' ;
  VALUE crkyr     0='(0) Did not use in the past year (IRCRKRC = 3,9)'
                  1='(1) Used within the past year (IRCRKRC = 1,2)' ;
  VALUE crkmon    0='(0) Did not use in the past month (IRCRKRC = 2-3,9)'
                  1='(1) Used within the past month (IRCRKRC = 1)' ;
  VALUE herflag   0='(0) Never used (IRHERRC = 9)' 1='(1) Ever used (IRHERRC = 1-3)' ;
  VALUE heryr     0='(0) Did not use in the past year (IRHERRC = 3,9)'
                  1='(1) Used within the past year (IRHERRC = 1,2)' ;
  VALUE hermon    0='(0) Did not use in the past month (IRHERRC = 2-3,9)'
                  1='(1) Used within the past month (IRHERRC = 1)' ;
  VALUE halflag   0='(0) Never used (IRHALRC = 9)' 1='(1) Ever used (IRHALRC = 1-3)' ;
  VALUE halyr     0='(0) Did not use in the past year (IRHALRC = 3,9)'
                  1='(1) Used within the past year (IRHALRC = 1,2)' ;
  VALUE halmon    0='(0) Did not use in the past month (IRHALRC = 2-3,9)'
                  1='(1) Used within the past month (IRHALRC = 1)' ;
  VALUE lsdflag   0='(0) Never used (IRLSDRC = 9)' 1='(1) Ever used (IRLSDRC = 1-3)' ;
  VALUE lsdyr     0='(0) Did not use in the past year (IRLSDRC = 3,9)'
                  1='(1) Used within the past year (IRLSDRC = 1,2)' ;
  VALUE lsdmon    0='(0) Did not use in the past month (IRLSDRC = 2-3,9)'
                  1='(1) Used within the past month (IRLSDRC = 1)' ;
  VALUE pcpflag   0='(0) Never used (IRPCPRC = 9)' 1='(1) Ever used (IRPCPRC = 1-3)' ;
  VALUE pcpyr     0='(0) Did not use in the past year (IRPCPRC = 3,9)'
                  1='(1) Used within the past year (IRPCPRC = 1,2)' ;
  VALUE pcpmon    0='(0) Did not use in the past month (IRPCPRC = 2-3,9)'
                  1='(1) Used within the past month (IRPCPRC = 1)' ;
  VALUE inhflag   0='(0) Never used (IRINHRC = 9)' 1='(1) Ever used (IRINHRC = 1-3)' ;
  VALUE inhyr     0='(0) Did not use in the past year (IRINHRC = 3,9)'
                  1='(1) Used within the past year (IRINHRC = 1,2)' ;
  VALUE inhmon    0='(0) Did not use in the past month (IRINHRC = 2-3,9)'
                  1='(1) Used within the past month (IRINHRC = 1)' ;
  VALUE anlflag   0='(0) Never used (IRANLRC = 9)' 1='(1) Ever used (IRANLRC = 1-3)' ;
  VALUE anlyr     0='(0) Did not use in the past year (IRANLRC = 3,9)'
                  1='(1) Used within the past year (IRANLRC = 1,2)' ;
  VALUE anlmon    0='(0) Did not use in the past month (IRANLRC = 2-3,9)'
                  1='(1) Used within the past month (IRANLRC = 1)' ;
  VALUE trqflag   0='(0) Never used (IRTRNRC = 9)' 1='(1) Ever used (IRTRNRC = 1-3)' ;
  VALUE trqyr     0='(0) Did not use in the past year (IRTRNRC = 3,9)'
                  1='(1) Used within the past year (IRTRNRC = 1,2)' ;
  VALUE trqmon    0='(0) Did not use in the past month (IRTRNRC = 2-3,9)'
                  1='(1) Used within the past month (IRTRNRC = 1)' ;
  VALUE stmflag   0='(0) Never used (IRSTMRC = 9)' 1='(1) Ever used (IRSTMRC = 1-3)' ;
  VALUE stmyr     0='(0) Did not use in the past year (IRSTMRC = 3,9)'
                  1='(1) Used within the past year (IRSTMRC = 1,2)' ;
  VALUE stmmon    0='(0) Did not use in the past month (IRSTMRC = 2-3,9)'
                  1='(1) Used within the past month (IRSTMRC = 1)' ;
  VALUE mthflag   0='(0) Never Used (IRMTHRC=9)' 1='(1) Ever Used (IRMTHRC=1-3)' ;
  VALUE mthyr     0='(0) Did not use in the past year (IRMTHRC=3,9)'
                  1='(1) Used within the past year (IRMTHRC=1,2)' ;
  VALUE mthmon    0='(0) Did not use in the past month (IRMTHRC=2-3,9)'
                  1='(1) Used within the past month (IRMTHRC=1)' ;
  VALUE sedflag   0='(0) Never used (IRSEDRC = 9)' 1='(1) Ever used (IRSEDRC = 1-3)' ;
  VALUE sedyr     0='(0) Did not use in the past year (IRSEDRC = 3,9)'
                  1='(1) Used within the past year (IRSEDRC = 1,2)' ;
  VALUE sedmon    0='(0) Did not use in the past month (IRSEDRC = 2-3,9)'
                  1='(1) Used within the past month (IRSEDRC = 1)' ;
  VALUE psyflagf  0='(0) Never used (ALL SOURCE VARIABLES = 9)'
                  1='(1) Ever used (ANY SOURCE VARIABLE < 9)' ;
  VALUE psyyr2ff  0='(0) Did not use within past year (ALL SOURCE VARS > 2)'
                  1='(1) Used in past year (ANY SOURCE VARIABLE < 3)' ;
  VALUE psymon2f  0='(0) Did not use in past month (ALL SOURCE VARS > 1)'
                  1='(1) Used in past month (ANY SOURCE VARIABLE = 1)' ;
  VALUE sumflag   0='(0) Never used (ALL SOURCE VARIABLES = 0)'
                  1='(1) Ever used (ANY SOURCE VARIABLE = 1)' ;
  VALUE sumyr     0='(0) Did not use in past year (ALL SOURCE VARS =0)'
                  1='(1) Used in past year (ANY SOURCE VARIABLE = 1)' ;
  VALUE summon    0='(0) Did not use in past month (ALL SOURCE VARS = 0)'
                  1='(1) Used in past month (ANY SOURCE VARIABLE = 1)' ;
  VALUE mjoflag   0='(0) Never used MJ/has used both MJ & anothr illct drug'
                  1='(1) Marijuana is only (illicit) drug ever used' ;
  VALUE mjoyr2ff  0='(0) MJ not used past yr/Used MJ & othr drug past yr'
                  1='(1) Marijuana is only (illicit) drug in past year' ;
  VALUE mjomon2f  0='(0) MJ not used past mnth/Used MJ & othr drug past mo'
                  1='(1) Marijuana only (illicit) drug in past month' ;
  VALUE iemflag   0='(0) Never used drug/used only marijuana'
                  1='(1) Illicit drug except for marijuana are ever used' ;
  VALUE iemyr     0='(0) Never used drug/used only marijuana past year'
                  1='(1) Illicit drug except for marijuana used past year' ;
  VALUE iemmon    0='(0) Never used drug/used only marijuana past month'
                  1='(1) Illicit drug except for marijuana used past month' ;
  VALUE bingedrk  0='(0) Never/No "Binge" alcohol use (IRALCD5 = 0)'
                  1='(1) "Binge" alcohol use (IRALCD5 = 1-30)' ;
  VALUE hvydrk2f  0='(0) Never/No heavy alcohol use (IRALCD5 = 0-4)'
                  1='(1) Heavy alcohol use (IRALCD5 = 5-30)' ;
  VALUE bingehvy  1='(1) Heavy Alcohol Use (HVYDRK2=1)'
                  2='(2) "Binge" But Not Heavy Use (BINGEDRK=1 & HVYDRK2=0)'
                  3='(3) Past Month But Not "Binge" (ALCMON=1 & BINGEDRK=0)'
                  4='(4) Did Not Use Alcohol in Pst Month (All source=0)' ;
  VALUE peyote2f  0='(0) No/Unknown (PEYOTE=2,85,91,94,97)' 1='(1) Yes (PEYOTE=1)' ;
  VALUE mesc2fff  0='(0) No/Unknown (MESC=2,85,91,94,97)' 1='(1) Yes (MESC=1)' ;
  VALUE psilcy2f  0='(0) No/Unknown (PSILCY=2,85,91,94,97)' 1='(1) Yes (PSILCY=1,3)' ;
  VALUE ecstasyf  0='(0) No/Unknown (ECSTASY=2,85,91,94,97)' 1='(1) Yes (ECSTASY=1)' ;
  VALUE amylnitf  0='(0) No/Unknown (AMYLNIT=2,91,94,97)' 1='(1) Yes (AMYLNIT=1,3)' ;
  VALUE cleflu2f  0='(0) No/Unknown (CLEFLU=2,91,94,97)' 1='(1) Yes (CLEFLU=1,3)' ;
  VALUE gas2ffff  0='(0) No/Unknown (GAS=2,91,94,97)' 1='(1) Yes (GAS=1,3)' ;
  VALUE glue2fff  0='(0) No/Unknown (GLUE=2,91,94,97)' 1='(1) Yes (GLUE=1,3)' ;
  VALUE ether2ff  0='(0) No/Unknown (ETHER=2,91,94,97)' 1='(1) Yes (ETHER=1)' ;
  VALUE solventf  0='(0) No/Unknown (SOLVENT=2,91,94,97,98)'
                  1='(1) Yes (SOLVENT=1,3)' ;
  VALUE lgas2fff  0='(0) No/Unknown (LGAS=2,91,94,97,98)' 1='(1) Yes (LGAS=1,3)' ;
  VALUE nitoxidf  0='(0) No/Unknown (NITOXID=2,91,94,97,98)'
                  1='(1) Yes (NITOXID=1,3)' ;
  VALUE sppaintf  0='(0) No/Unknown (SPPAINT=2,91,94,97,98)' 1='(1) Yes (SPPAINT=1)' ;
  VALUE aeros2ff  0='(0) No/Unknown (AEROS=2,91,94,97,98)' 1='(1) Yes (AEROS=1,3)' ;
  VALUE darvtylf  0='(0) No/Unknown (DARVTYLC=2,81,85,91,94,97,98)'
                  1='(1) Yes (DARVTYLC=1,3)' ;
  VALUE perctylf  0='(0) No/Unknown (PERCTYLX=2,81,85,91,94,97,98)'
                  1='(1) Yes (PERCTYLX=1,3)' ;
  VALUE vicolorf  0='(0) No/Unknown (VICOLOR=2,81,85,91,94,97,98)'
                  1='(1) Yes (VICOLOR=1,3)' ;
  VALUE codeinef  0='(0) No/Unknown (CODEINE=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (CODEINE=1,3)' ;
  VALUE demerolf  0='(0) No/Unknown (DEMEROL=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (DEMEROL=1,3)' ;
  VALUE dilaud2f  0='(0) No/Unknown (DILAUD=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (DILAUD = 1,3)' ;
  VALUE fiorictf  0='(0) No/Unknown (FIORICET=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (FIORICET=1)' ;
  VALUE fiorinlf  0='(0) No/Unknown (FIORINAL= 6,81,85,91,94,97,98,99)'
                  1='(1) Yes (FIORINAL=1,3)' ;
  VALUE hydrocdf  0='(0) No/Unknown (HYDROCOD= 6,81,85,91,94,97,98,99)'
                  1='(1) Yes (HYDROCOD=1,3)' ;
  VALUE methdonf  0='(0) No/Unknown (METHDON=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (METHDON = 1,3)' ;
  VALUE morphinf  0='(0) No/Unknown (MORPHINE=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (MORPHINE = 1,3)' ;
  VALUE oxycontf  0='(0) No/Unknown (OXYCONTN=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (OXYCONTN = 1,3)' ;
  VALUE phencodf  0='(0) No/Unknown (PHENCOD=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (PHENCOD = 1,3)' ;
  VALUE propoxyf  0='(0) No/Unknown (PROPOXY=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (PROPOXY = 1)' ;
  VALUE sk65a2ff  0='(0) No/Unknown (SK65A=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (SK65A = 1)' ;
  VALUE stadol2f  0='(0) No/Unknown (STADOL=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (STADOL = 1)' ;
  VALUE talacenf  0='(0) No/Unknown (TALACEN=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (TALACEN = 1)' ;
  VALUE talwin2f  0='(0) No/Unknown (TALWIN=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (TALWIN = 1)' ;
  VALUE talwinxf  0='(0) No/Unknown (TALWINNX=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (TALWINNX = 1,3)' ;
  VALUE tramadlf  0='(0) No/Unknown (TRAMADOL=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (TRAMADOL = 1)' ;
  VALUE ultram2f  0='(0) No/Unknown (ULTRAM=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (ULTRAM = 1,3)' ;
  VALUE othanl    0='(0) No/Unknwn (ANLCARD/ANLNOLST=2,4,81,85,91,94,97,98)'
                  1='(1) Yes (ANLCARD or ANLNOLST = 1,3)' ;
  VALUE klonopif  0='(0) No/Unknown (KLONOPIN=2,81,85,91,94,97,98)'
                  1='(1) Yes (KLONOPIN=1)' ;
  VALUE xnaxatvf  0='(0) No/Unknown (XNAXATVN=2,81,85,91,94,97,98)'
                  1='(1) Yes (XNAXATVN=1,3)' ;
  VALUE valmdiaf  0='(0) No/Unknown (VALMDIAZ=2,81,85,91,94,97,98)'
                  1='(1) Yes (VALMDIAZ=1,3)' ;
  VALUE atarax2f  0='(0) No/Unknown (ATARAX=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (ATARAX = 1,3)' ;
  VALUE buspar2f  0='(0) No/Unknown (BUSPAR=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (BUSPAR = 1)' ;
  VALUE equanilf  0='(0) No/Unknown (EQUANIL=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (EQUANIL = 1,3)' ;
  VALUE flexerlf  0='(0) No/Unknown (FLEXERIL=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (FLEXERIL = 1,3)' ;
  VALUE libriumf  0='(0) No/Unknown (LIBRIUM=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (LIBRIUM = 1)' ;
  VALUE limbtrlf  0='(0) No/Unknown (LIMBTROL=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (LIMBTROL = 1)' ;
  VALUE meprob2f  0='(0) No/Unknown (MEPROB=6,81,91,94,97,98,99)'
                  1='(1) Yes (MEPROB = 1)' ;
  VALUE miltownf  0='(0) No/Unknown (MILTOWN=6,81,91,94,97,98,99)'
                  1='(1) Yes (MILTOWN = 1)' ;
  VALUE rohypnlf  0='(0) No/Unknown (ROHYPNOL=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (ROHYPNOL = 1,3)' ;
  VALUE serax2ff  0='(0) No/Unknown (SERAX=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (SERAX = 1)' ;
  VALUE soma2fff  0='(0) No/Unknown (SOMA=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (SOMA = 1,3)' ;
  VALUE tranxenf  0='(0) No/Unknown (TRANXENE=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (TRANXENE = 1)' ;
  VALUE vistar2f  0='(0) No/Unknown (VISTAR=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (VISTAR = 1)' ;
  VALUE othtrn    0='(0) No/Unknwn (TRNCARD/TRNNOLST=2,4,81,85,91,94,97,98)'
                  1='(1) Yes (TRNCARD or TRNNOLST = 1,3)' ;
  VALUE methdesf  0='(0) No/Unknown (METHDES=2,81,85,91,94,97,98)'
                  1='(1) Yes (METHDES=1,3)' ;
  VALUE dietpilf  0='(0) No/Unknown (DIETPILS=2,81,85,91,94,97,98)'
                  1='(1) Yes (DIETPILS=1,3)' ;
  VALUE ritmphef  0='(0) No/Unknown (RITMPHEN=2,81,85,91,94,97,98)'
                  1='(1) Yes (RITMPHEN=1,3)' ;
  VALUE cylert2f  0='(0) No/ Unknown (CYLERT=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (CYLERT = 1,3)' ;
  VALUE dexed2ff  0='(0) No/ Unknown (DEXED=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (DEXED = 1)' ;
  VALUE detamp2f  0='(0) No/ Unknown (DETAMP=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (DETAMP = 1)' ;
  VALUE didrex2f  0='(0) No/ Unknown (DIDREX=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (DIDREX = 1,3)' ;
  VALUE eskat2ff  0='(0) No/ Unknown (ESKAT=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (ESKAT = 1,3)' ;
  VALUE ionaminf  0='(0) No/ Unknown (IONAMIN=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (IONAMIN = 1)' ;
  VALUE mazanorf  0='(0) No/Unknown (MAZANOR=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (MAZANOR = 1)' ;
  VALUE obla2fff  0='(0) No/Unknown (OBLA=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (OBLA = 1)' ;
  VALUE pleginef  0='(0) No/Unknown (PLEGINE=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (PLEGINE = 1)' ;
  VALUE preludnf  0='(0) No/Unknown (PRELUDIN=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (PRELUDIN = 1,3)' ;
  VALUE sanorexf  0='(0) No/ Unknown (SANOREX=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (SANOREX = 1)' ;
  VALUE tenuatef  0='(0) No/ Unknown (TENUATE=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (TENUATE = 1,3)' ;
  VALUE othstm    0='(0) No/Unknwn (STMCARD/STMNOLST=2,4,81,85,91,94,97,98)'
                  1='(1) Yes (STMCARD or STMNOLST = 1,3)' ;
  VALUE methaq2f  0='(0) No/Unknown (METHAQ=2,81,85,91,94,97,98)'
                  1='(1) Yes (METHAQ=1)' ;
  VALUE nembbarf  0='(0) No/Unknown (NEMBBARB=2,81,85,91,94,97,98)'
                  1='(1) Yes (NEMBBARB=1)' ;
  VALUE resttmaf  0='(0) No/Unknown (RESTTMAZ=2,81,85,91,94,97,98)'
                  1='(1) Yes (RESTTMAZ=1)' ;
  VALUE amytal2f  0='(0) No/Unknown (AMYTAL=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (AMYTAL= 1)' ;
  VALUE butisolf  0='(0) No/Unknown (BUTISOL=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (BUTISOL= 1)' ;
  VALUE chhyd2ff  0='(0) No/Unknown (CHHYD=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (CHHYD= 1)' ;
  VALUE dalmanef  0='(0) No/Unknown (DALMANE=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (DALMANE=1,3)' ;
  VALUE halcionf  0='(0) No/Unknown (HALCION=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (HALCION=1,3)' ;
  VALUE phenobrf  0='(0) No/Unknown (PHENOBAR=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (PHENOBAR=1,3)' ;
  VALUE placidyf  0='(0) No/Unknown (PLACIDYL=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (PLACIDYL= 1,3)' ;
  VALUE tuinal2f  0='(0) No/Unknown (TUINAL=6,81,85,91,94,97,98,99)'
                  1='(1) Yes (TUINAL=1,3)' ;
  VALUE othsed    0='(0) No/Unknwn (SEDCARD/SEDNOLST=2,4,81,85,91,94,97,98)'
                  1='(1) Yes (SEDCARD or SEDNOLST = 1,3)' ;
  VALUE alcafu    1='(1) 14 Years or Younger (IRALCAGE=1-14)'
                  2='(2) 15-17 Years Old (IRALCAGE=15-17)'
                  3='(3) 18 Years or Older (IRALCAGE=18+)'
                  4='(4) Non Users (IRALCAGE = 991)' ;
  VALUE mjafu     1='(1) 14 Years or Younger (IRMJAGE=1-14)'
                  2='(2) 15-17 Years Old (IRMJAGE=15-17)'
                  3='(3) 18 Years or Older (IRMJAGE=18+)'
                  4='(4) Non Users (IRMJAGE = 991)' ;
  VALUE cocafu    1='(1) 14 Years or Younger (IRCOCAGE=1-14)'
                  2='(2) 15-17 Years Old (IRCOCAGE=15-17)'
                  3='(3) 18 Years or Older (IRCOCAGE=18+)'
                  4='(4) Non Users (IRCOCAGE = 991)' ;
  VALUE herafu    1='(1) 14 Years or Younger (IRHERAGE=1-14)'
                  2='(2) 15-17 Years Old (IRHERAGE=15-17)'
                  3='(3) 18 Years or Older (IRHERAGE=18+)'
                  4='(4) Non Users (IRHERAGE = 991)' ;
  VALUE halafu    1='(1) 14 Years or Younger (IRHALAGE=1-14)'
                  2='(2) 15-17 Years Old (IRHALAGE=15-17)'
                  3='(3) 18 Years or Older (IRHALAGE=18+)'
                  4='(4) Non Users (IRHALAGE = 991)' ;
  VALUE inhafu    1='(1) 14 Years or Younger (IRINHAGE=1-14)'
                  2='(2) 15-17 Years Old (IRINHAGE=15-17)'
                  3='(3) 18 Years or Older (IRINHAGE=18+)'
                  4='(4) Non Users (IRINHAGE = 991)' ;
  VALUE anlafu    1='(1) 14 Years or Younger (IRANLAGE=1-14)'
                  2='(2) 15-17 Years Old (IRANLAGE=15-17)'
                  3='(3) 18 Years or Older (IRANLAGE=18+)'
                  4='(4) Non Users (IRANLAGE = 991)' ;
  VALUE trnafu    1='(1) 14 Years or Younger (IRTRNAGE=1-14)'
                  2='(2) 15-17 Years Old (IRTRNAGE=15-17)'
                  3='(3) 18 Years or Older (IRTRNAGE=18+)'
                  4='(4) Non Users (IRTRNAGE = 991)' ;
  VALUE stmafu    1='(1) 14 Years or Younger (IRSTMAGE=1-14)'
                  2='(2) 15-17 Years Old (IRSTMAGE=15-17)'
                  3='(3) 18 Years or Older (IRSTMAGE=18+)'
                  4='(4) Non Users (IRSTMAGE = 991)' ;
  VALUE sedafu    1='(1) 14 Years or Younger (IRSEDAGE=1-14)'
                  2='(2) 15-17 Years Old (IRSEDAGE=15-17)'
                  3='(3) 18 Years or Older (IRSEDAGE=18+)'
                  4='(4) Non Users (IRSEDAGE = 991)' ;
  VALUE cigafu    1='(1) 14 Years or Younger (IRCIGAGE=1-14)'
                  2='(2) 15-17 Years Old (IRCIGAGE=15-17)'
                  3='(3) 18 Years or Older (IRCIGAGE=18+)'
                  4='(4) Non Users (IRCIGAGE = 991)' ;
  VALUE cgrafu    1='(1) 14 Years or Younger (IRCGRAGE=1-14)'
                  2='(2) 15-17 Years Old (IRCGRAGE=15-17)'
                  3='(3) 18 Years or Older (IRCGRAGE=18+)'
                  4='(4) Non Users (IRCGRAGE = 991)' ;
  VALUE sltafu    1='(1) 14 Years or Younger (IRSLTAGE=1-14)'
                  2='(2) 15-17 Years Old (IRSLTAGE=15-17)'
                  3='(3) 18 Years or Older (IRSLTAGE=18+)'
                  4='(4) Non Users (IRSLTAGE = 991)' ;
  VALUE mrjydays  1='(1) 1-11 Days (IRMJFY=1-11)' 2='(2) 12-49 Days (IRMJFY=12-49)'
                  3='(3) 50-99 Days (IRMJFY=50-99)'
                  4='(4) 100-299 Days (IRMJFY=100-299)'
                  5='(5) 300-365 Days (IRMJFY=300-365)'
                  6='(6) No Past Year Use (IRMJFY=991,993)' ;
  VALUE cocydays  1='(1) 1-11 Days (IRCOCFY=1-11)' 2='(2) 12-49 Days (IRCOCFY=12-49)'
                  3='(3) 50-99 Days (IRCOCFY=50-99)'
                  4='(4) 100-299 Days (IRCOCFY=100-299)'
                  5='(5) 300-365 Days (IRCOCFY=300-365)'
                  6='(6) No Past Year Use (IRCOCFY=991,993)' ;
  VALUE halydays  1='(1) 1-11 Days (IRHALFY=1-11)' 2='(2) 12-49 Days (IRHALFY=12-49)'
                  3='(3) 50-99 Days (IRHALFY=50-99)'
                  4='(4) 100-299 Days (IRHALFY=100-299)'
                  5='(5) 300-365 Days (IRHALFY=300-365)'
                  6='(6) No Past Year Use (IRHALFY=991,993)' ;
  VALUE inhydays  1='(1) 1-11 Days (IRINHFY=1-11)' 2='(2) 12-49 Days (IRINHFY=12-49)'
                  3='(3) 50-99 Days (IRINHFY=50-99)'
                  4='(4) 100-299 Days (IRINHFY=100-299)'
                  5='(5) 300-365 Days (IRINHFY=300-365)'
                  6='(6) No Past Year Use (IRINHFY=991,993)' ;
  VALUE alcydays  1='(1) 1-11 Days (IRALCFY=1-11)' 2='(2) 12-49 Days (IRALCFY=12-49)'
                  3='(3) 50-99 Days (IRALCFY=50-99)'
                  4='(4) 100-299 Days (IRALCFY=100-299)'
                  5='(5) 300-365 Days (IRALCFY=300-365)'
                  6='(6) No Past Year Use (IRALCFY=991,993)' ;
  VALUE mrjmdays  1='(1) 1-2 Days (IRMJFM=1-2)' 2='(2) 3-5 Days (IRMJFM=3-5)'
                  3='(3) 6-19 Days (IRMJFM=6-19)' 4='(4) 20-30 Days (IRMJFM=20-30)'
                  5='(5) No Past Month Use (IRMJFM=91,93)' ;
  VALUE cocmdays  1='(1) 1-2 Days (IRCOCFM=1-2)' 2='(2) 3-5 Days (IRCOCFM=3-5)'
                  3='(3) 6-19 Days (IRCOCFM=6-19)' 4='(4) 20-30 Days (IRCOCFM=20-30)'
                  5='(5) No Past Month Use (IRCOCFM=91,93)' ;
  VALUE halmdays  1='(1) 1-2 Days (IRHALFM=1-2)' 2='(2) 3-5 Days (IRHALFM=3-5)'
                  3='(3) 6-19 Days (IRHALFM=6-19)' 4='(4) 20-30 Days (IRHALFM=20-30)'
                  5='(5) No Past Month Use (IRHALFM=91,93)' ;
  VALUE inhmdays  1='(1) 1-2 Days (IRINHFM=1-2)' 2='(2) 3-5 Days (IRINHFM=3-5)'
                  3='(3) 6-19 Days (IRINHFM=6-19)' 4='(4) 20-30 Days (IRINHFM=20-30)'
                  5='(5) No Past Month Use (IRINHFM=91,93)' ;
  VALUE alcmdays  1='(1) 1-2 Days (IRALCFM=1-2)' 2='(2) 3-5 Days (IRALCFM=3-5)'
                  3='(3) 6-19 Days (IRALCFM=6-19)' 4='(4) 20-30 Days (IRALCFM=20-30)'
                  5='(5) No Past Month Use (IRALCFM=91,93)' ;
  VALUE cigmdays  1='(1) 1-2 Days (IRCIGFM=1,2)' 2='(2) 3-5 Days (IRCIGFM=3-5)'
                  3='(3) 6-19 Days (IRCIGFM=6-19)' 4='(4) 20-29 Days (IRCIGFM=20-29)'
                  5='(5) 30 Days (IRCIGFM=30)'
                  6='(6) No Past Month Use (IRCIGFM=91,93)' ;
  VALUE cigpday   1='(1) Fewer Than 6 (CIG30AV=1,2,3 AND IRCIGFM=30)'
                  2='(2) 6-15 (CIG30AV=4 AND IRCIGFM=30)'
                  3='(3) 16-25 (CIG30AV=5 AND IRCIGFM=30)'
                  4='(4) 26 or More (CIG30AV=6,7 AND IRCIGFM=30)'
                  5='(5) Not Reported (CIG30AV=85,94,97,98 AND IRCIGFM=30)'
                  6='(6) No Daily Use(CIG30AV=91,93 OR IRCIGFM=1-29,91,93)' ;
  VALUE cg05ffff  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cg06ffff  1='(1) More than 30 days ago but within the past 12 mos'
                  2='(2) More than 12 months ago but within the past 3 yrs'
                  3='(3) More than 3 years ago' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cg06dk    1='(1) More than 30 days ago but within the past 12 mos'
                  2='(2) More than 12 months ago but within the past 3 yrs'
                  3='(3) More than 3 years ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE cg06re    1='(1) More than 30 days ago but within the past 12 mos'
                  2='(2) More than 12 months ago but within the past 3 yrs'
                  3='(3) More than 3 years ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE cg19ffff  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cg20ffff  1='(1) More than 30 days ago but within the past 12 mos'
                  2='(2) More than 12 months ago but within the past 3 yrs'
                  3='(3) More than 3 years ago' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cg20dk    1='(1) More than 30 days ago but within the past 12 mos'
                  2='(2) More than 12 months ago but within the past 3 yrs'
                  3='(3) More than 3 years ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE cg20re    1='(1) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 3 years ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE cg27ffff  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cg28ffff  1='(1) More than 30 days ago but within the past 12 mos'
                  2='(2) More than 12 months ago but within the past 3 yrs'
                  3='(3) More than 3 years ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE cg28dk    2='(2) More than 12 months ago but within the past 3 yrs'
                  3='(3) More than 3 years ago' 94='(94) DON''T KNOW'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE cg28re    94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cg36ffff  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cg37ffff  1='(1) More than 30 days ago but within the past 12 mos'
                  2='(2) More than 12 months ago but within the past 3 yrs'
                  3='(3) More than 3 years ago' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cg37dk    1='(1) More than 30 days ago but within the past 12 mos'
                  2='(2) More than 12 months ago but within the past 3 yrs'
                  3='(3) More than 3 years ago' 94='(94) DON''T KNOW'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE cg37re    1='(1) More than 30 days ago but within the past 12 mos'
                  2='(2) More than 12 months ago but within the past 3 yrs'
                  3='(3) More than 3 years ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE cg43ffff  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 98='(98) BLANK (NO ANSWER)' ;
  VALUE allast3f  1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alrecdk   1='(1) Within the past 30 days --that is, since DATEFILL'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE alrecre   1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE totdrink  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE alframef  1='(1) Avg num of days per week during pst 12 mos'
                  2='(2) Avg num of days per month during pst 12 mos'
                  3='(3) Total number of days during the past 12 months'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alyrave   985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE almonave  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alwkave   85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mjlast3f  1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 month'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mjrecdk   1='(1) DATEFILL'
                  2='(2) More than 30 days ago but within the pst 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE mjrecre   1='(1) DATEFILL'
                  2='(2) More than 30 days ago but within the pst 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE totmj     985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE mjframef  1='(1) Avg num of days per week during pst 12 mos'
                  2='(2) Avg num of days per month during pst 12 mos'
                  3='(3) Total number of days during the past 12 months'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mjyrave   994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE mjmonave  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mjwkave   85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cclast3f  1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 month'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ccrecdk   3='(3) More than 12 months ago' 94='(94) DON''T KNOW'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE ccrecre   1='(1) DATEFILL'
                  2='(2) More than 30 days ago but within the pst 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE totcoke   985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE ccframef  1='(1) Avg num of days per week during pst 12 mos'
                  2='(2) Avg num of days per month during pst 12 mos'
                  3='(3) Total number of days during the past 12 months'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ccyrave   985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE ccmonave  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ccwkave   94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cklast3f  1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 month'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE ckrecdk   1='(1) DATEFILL'
                  2='(2) More than 30 days ago but within the pst 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE ckrecre   97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE totcrack  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE ckframef  1='(1) Avg num of days per week during pst 12 mos'
                  2='(2) Avg num of days per month during pst 12 mos'
                  3='(3) Total number of days during the past 12 months'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ckyrave   994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE ckmonave  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ckwkave   94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE helast3f  1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 month'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE herecdk   2='(2) More than 30 days ago but within the pst 12 mos'
                  94='(94) DON''T KNOW' 98='(98) BLANK (NO ANSWER)' ;
  VALUE herecre   97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE tothero   998='(998) BLANK (NO ANSWER)' ;
  VALUE heframef  1='(1) Avg num of days per week during pst 12 mos'
                  2='(2) Avg num of days per month during pst 12 mos'
                  3='(3) Total number of days during the past 12 months'
                  94='(94) DON''T KNOW' 98='(98) BLANK (NO ANSWER)' ;
  VALUE heyrave   994='(994) DON''T KNOW' 998='(998) BLANK (NO ANSWER)' ;
  VALUE hemonave  94='(94) DON''T KNOW' 98='(98) BLANK (NO ANSWER)' ;
  VALUE hewkave   98='(98) BLANK (NO ANSWER)' ;
  VALUE lslast    1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE lsrecdk   2='(2) More than 30 days ago but within the pst 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE lsrecre   1='(1) Within the past 30 days -- that is, since[DATEFILL'
                  2='(2) More than 30 days ago but within the pst 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE tothall   985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE lsframef  1='(1) Avg num of days per week during pst 12 mos'
                  2='(2) Avg num of days per month during pst 12 mos'
                  3='(3) Total number of days during the past 12 months'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE lsyrave   985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE lsmonave  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE lswkave   94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ls10ffff  1='(1) Within the past 30 days - that is, since DATEFILL'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ls16ffff  1='(1) Within the past 30 days -- that is, since DATEFILL'
                  2='(2) More than 30 days ago but within the pst 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE inlast    1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inrecdk   1='(1) Within the past 30 days -- that is, since DATEFILL'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE inrecre   1='(1) Within the past 30 days -- that is, since DATEFILL'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE totinhal  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE inframef  1='(1) Avg num of days per week during pst 12 mos'
                  2='(2) Avg num of days per month during pst 12 mos'
                  3='(3) Total number of days during the past 12 months'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inyrave   994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE inmonave  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inwkave   94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE pr09ffff  1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE prrecdk   1='(1) Within the past 30 days -- that is, since DATEFILL'
                  2='(2) More than 30 days ago but within the past 12 month'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE prrecre   1='(1) Within the past 30 days -- that is, since DATEFILL'
                  2='(2) More than 30 days ago but within the past 12 month'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE pr10ffff  1='(1) Avg num of days per week during pst 12 mos'
                  2='(2) Avg num of days per month during pst 12 mos'
                  3='(3) Total number of days during the past 12 months'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE pr11ffff  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE pr12ffff  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE pr13ffff  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE tr09ffff  1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trrecdk   1='(1) Within the past 30 days -- that is, since DATEFILL'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trrecre   2='(2) More than 30 days ago but within the past 12 mos'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE tr10ffff  1='(1) Avg num of days per week during pst 12 mos'
                  2='(2) Avg num of days per month during pst 12 mos'
                  3='(3) Total number of days during the past 12 months'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE tr11ffff  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE tr12ffff  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE tr13ffff  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE st09ffff  1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE strecdk   1='(1) Within the past 30 days -- that is, since DATEFILL'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE strecre   1='(1) Within the past 30 days -- that is, since DATEFILL'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE st10ffff  1='(1) Avg num of days per week during pst 12 mos'
                  2='(2) Avg num of days per month during pst 12 mos'
                  3='(3) Total number of days during the past 12 months'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE st11ffff  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE st12ffff  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE st13ffff  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE st19ffff  1='(1) Within the past 30 days - that is, since DATEFILL'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE sv09ffff  1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE svrecdk   3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE svrecre   3='(3) More than 12 months ago'
                  85='(85) BAD DATA Logically assigned' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE sv10ffff  1='(1) Avg num of days per week during pst 12 mos'
                  2='(2) Avg num of days per month during pst 12 mos'
                  3='(3) Total number of days during the past 12 months'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sv11ffff  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE sv12ffff  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sv13ffff  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE hersmoke  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE hrsmkrec  1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 91='(91) NEVER USED HEROIN'
                  93='(93) USED HEROIN BUT NEVER SMOKED IT' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE hersniff  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE hrsnfrec  1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  9='(9) At some point in the lifetime LOG ASSN'
                  91='(91) NEVER USED HEROIN'
                  93='(93) USED HEROIN BUT NEVER SNIFFED IT' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE gnndllif  1='(1) Yes' 2='(2) No' 4='(4) No LOGICALLY ASSIGNED' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cocneedl  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED COCAINE' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP (GNNDLLIF = 2)' ;
  VALUE condlrec  1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  9='(9) At some point in the lifetime LOG ASSN'
                  91='(91) NEVER USED COCAINE'
                  93='(93) USED COCAINE BUT NEVER WITH A NEEDLE' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP (GNNDLLIF = 2)' ;
  VALUE herneedl  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN' 97='(97) REFUSED'
                  99='(99) LEGITIMATE SKIP (GNNDLLIF = 2)' ;
  VALUE hrndlrec  1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 91='(91) NEVER USED HEROIN'
                  93='(93) USED HEROIN BUT NEVER WITH A NEEDLE' 97='(97) REFUSED'
                  99='(99) LEGITIMATE SKIP (GNNDLLIF = 2)' ;
  VALUE stneedle  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED STIMULANTS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (GNNDLLIF = 2)' ;
  VALUE stndlrec  1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago' 91='(91) NEVER USED STIMULANTS'
                  93='(93) USED STIMULANTS BUT NEVER WITH A NEEDLE' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP (GNNDLLIF = 2)' ;
  VALUE gnndreus  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (GNNDLLIF = 2)' ;
  VALUE gnndlshf  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (GNNDLLIF = 2)' ;
  VALUE gnndclen  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (GNNDLLIF = 2)' ;
  VALUE gnndls0f  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned (GNNDLLIF = 4)'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (GNNDLLIF = 2)' ;
  VALUE gnndgetf  1='(1) Bought the needle from a pharmacy'
                  2='(2) Got the needle from a needle exchange'
                  3='(3) Bought the needle on the street'
                  4='(4) Got the needle in a shooting gallery'
                  5='(5) Got the needle some other way'
                  41='(41) Given by, stolen from a friend/acquaint of friend'
                  42='(42) Given by, stolen from a relative'
                  43='(43) Given by, stolen from someone, relation unspecifd'
                  45='(45) Found it/got from a waste can'
                  46='(46) Given by, stolen from medical facility/professionl'
                  49='(49) Bought, given, stolen from place/location unspecd'
                  54='(54) Shared needle with friends/other acquaintances'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned (GNNDLLIF=4)'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (GNNDLLIF=2)' ;
  VALUE nedlrecc  1='(1) Within the past 30 days'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  9='(9) At some point in the lifetime LOG ASSN'
                  91='(91) NEVER USED COC/HER/STM WITH A NEEDLE' 97='(97) REFUSED'
                  98='(98) MISSING (BUT NOT REFUSED)' ;
  VALUE nedflagf  0='(0) Never used (GNNDLLIF=2,4,94,97,98)'
                  1='(1) Ever Used (GNNDLLIF=1)' ;
  VALUE hersmokf  0='(0) No/Unknown (HERSMOKE=2,91,97,98)' 1='(1) Yes (HERSMOKE=1)' ;
  VALUE hersni0f  0='(0) No/Unknown (HERSNIFF=2,91,97,98)' 1='(1) Yes (HERSNIFF=1)' ;
  VALUE nedher    0='(0) No (HERNEEDL=2,91,97,99)' 1='(1) Yes (HERNEEDL=1)' ;
  VALUE nedcoc    0='(0) No (COCNEEDL=2,91,97,98,99)' 1='(1) Yes (COCNEEDL=1)' ;
  VALUE nedstm    0='(0) No (STNNEEDL=2,91,94,97,98,99)' 1='(1) Yes (STNNEEDL=1)' ;
  VALUE rskpkcig  1='(1) No risk' 2='(2) Slight risk' 3='(3) Moderate risk'
                  4='(4) Great risk' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rskmjocc  1='(1) No risk' 2='(2) Slight risk' 3='(3) Moderate risk'
                  4='(4) Great risk' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rskmjreg  1='(1) No risk' 2='(2) Slight risk' 3='(3) Moderate risk'
                  4='(4) Great risk' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rktrylsd  1='(1) No risk' 2='(2) Slight risk' 3='(3) Moderate risk'
                  4='(4) Great risk' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rklsdreg  1='(1) No risk' 2='(2) Slight risk' 3='(3) Moderate risk'
                  4='(4) Great risk' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rktryher  1='(1) No risk' 2='(2) Slight risk' 3='(3) Moderate risk'
                  4='(4) Great risk' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rkherreg  1='(1) No risk' 2='(2) Slight risk' 3='(3) Moderate risk'
                  4='(4) Great risk' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rkcococc  1='(1) No risk' 2='(2) Slight risk' 3='(3) Moderate risk'
                  4='(4) Great risk' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rkcocreg  1='(1) No risk' 2='(2) Slight risk' 3='(3) Moderate risk'
                  4='(4) Great risk' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rk5aldly  1='(1) No risk' 2='(2) Slight risk' 3='(3) Moderate risk'
                  4='(4) Great risk' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rk5alwk   1='(1) No risk' 2='(2) Slight risk' 3='(3) Moderate risk'
                  4='(4) Great risk' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rskdifmj  1='(1) Probably impossible' 2='(2) Very difficult'
                  3='(3) Fairly difficult' 4='(4) Fairly easy' 5='(5) Very easy'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE rkdiflsd  1='(1) Probably impossible' 2='(2) Very difficult'
                  3='(3) Fairly difficult' 4='(4) Fairly easy' 5='(5) Very easy'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE rkdifcoc  1='(1) Probably impossible' 2='(2) Very difficult'
                  3='(3) Fairly difficult' 4='(4) Fairly easy' 5='(5) Very easy'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE rkdifcrk  1='(1) Probably impossible' 2='(2) Very difficult'
                  3='(3) Fairly difficult' 4='(4) Fairly easy' 5='(5) Very easy'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE rkdifher  1='(1) Probably impossible' 2='(2) Very difficult'
                  3='(3) Fairly difficult' 4='(4) Fairly easy' 5='(5) Very easy'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE rsksell   1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE rkfqdngr  1='(1) Never' 2='(2) Seldom' 3='(3) Sometimes' 4='(4) Always'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE rkfqrsky  1='(1) Never' 2='(2) Seldom' 3='(3) Sometimes' 4='(4) Always'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE rkfqpblt  1='(1) Never' 2='(2) Seldom' 3='(3) Sometimes' 4='(4) Always'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE rkfqdblt  1='(1) Never' 2='(2) Seldom' 3='(3) Sometimes' 4='(4) Always'
                  5='(5) I don''t drive' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE grskpkcg  -9='Unknown (RSKPKCIG = 94,97,98)'
                  0='(0) Otherwise (RSKPKCIG = 1,2,3)'
                  1='(1) Great Risk (RSKPKCIG = 4)' ;
  VALUE grskcreg  -9='Unknown (RKCOCREG = 94,97,98)'
                  0='(0) Otherwise (RKCOCREG = 1,2,3)'
                  1='(1) Great Risk (RKCOCREG = 4)' ;
  VALUE grskcocc  -9='Unknown (RKCOCOCC = 94,97,98)'
                  0='(0) Otherwise (RKCOCOCC = 1,2,3)'
                  1='(1) Great Risk (RKCOCOCC = 4)' ;
  VALUE grskmreg  -9='Unknown (RSKMJREG = 94,97,98)'
                  0='(0) Otherwise (RSKMJREG = 1,2,3)'
                  1='(1) Great Risk (RSKMJREG = 4)' ;
  VALUE grskmocc  -9='Unknown (RSKMJOCC = 94,97,98)'
                  0='(0) Otherwise (RSKMJOCC = 1,2,3)'
                  1='(1) Great Risk (RSKMJOCC = 4)' ;
  VALUE grskhtry  -9='Unknown (RKTRYHER = 94,97,98)'
                  0='(0) Otherwise (RKTRYHER = 1,2,3)'
                  1='(1) Great Risk (RKTRYHER = 4)' ;
  VALUE grskhreg  -9='Unknown (RKHERREG = 94,97,98)'
                  0='(0) Otherwise (RKHERREG = 1,2,3)'
                  1='(1) Great Risk (RKHERREG = 4)' ;
  VALUE grskltry  -9='Unknown (RKTRYLSD = 94,97,98)'
                  0='(0) Otherwise (RKTRYLSD = 1,2,3)'
                  1='(1) Great Risk (RKTRYLSD=4)' ;
  VALUE grsklreg  -9='Unknown (RKLSDREG = 94,97,98)'
                  0='(0) Otherwise (RKLSDREG = 1,2,3)'
                  1='(1) Great Risk (RKLSDREG = 4)' ;
  VALUE grskd4_f  -9='Unknown (RK5ALDLY = 94,97,98)'
                  0='(0) Otherwise (RK5ALDLY = 1,2,3)'
                  1='(1) Great Risk (RK5ALDLY = 4)' ;
  VALUE grskd5wk  -9='Unknown (RK5ALWK = 94,97,98)'
                  0='(0) Otherwise (RK5ALWK = 1,2,3)'
                  1='(1) Great Risk (RK5ALWK = 4)' ;
  VALUE rdifmj    -9='Unknown (RSKDIFMJ = 94,97,98)'
                  0='(0) Otherwise (RSKDIFMJ = 1,2,3)'
                  1='(1) Fairly or very easy (RSKDIFMJ = 4,5)' ;
  VALUE rdifcoc   -9='Unknown (RKDIFCOC = 94,97,98)'
                  0='(0) Otherwise (RKDIFCOC = 1,2,3)'
                  1='(1) Fairly or very easy (RKDIFCOC = 4,5)' ;
  VALUE rdifher   -9='Unknown (RKDIFHER = 94,97,98)'
                  0='(0) Otherwise (RKDIFHER = 1,2,3)'
                  1='(1) Fairly or very easy (RKDIFHER = 4,5)' ;
  VALUE rdiflsd   -9='Unknown (RKDIFLSD = 94,97,98)'
                  0='(0) Otherwise (RKDIFLSD = 1,2,3)'
                  1='(1) Fairly or very easy (RKDIFLSD = 4,5)' ;
  VALUE rdifcrk   -9='Unknown (RKDIFCRK = 94,97,98)'
                  0='(0) Otherwise (RKDIFCRK = 1,2,3)'
                  1='(1) Fairly or very easy (RKDIFCRK = 4,5)' ;
  VALUE appseldg  -9='Unknown (RSKSELL = 85,94,97,98)' 0='(0) No (RSKSELL = 2)'
                  1='(1) Yes (RSKSELL = 1)' ;
  VALUE ciglottm  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ciglimit  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cigkplmt  1='(1) Usually kept to the limits set'
                  2='(2) Often smoked more than intended'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigndmor  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE ciglsefx  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigcutdn  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cigcutev  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigcut1x  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigwd4sx  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  90='(90) NOT ASKED THE QUESTION Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigwdsmt  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  90='(90) NOT ASKED THE QUESTION Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigemopb  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cigemctd  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigphlpb  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigphctd  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ciglsact  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cigpkcrt  1='(1) Pack' 2='(2) Carton' 85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigpdpak  1='(1) Less than $1.00' 2='(2) $1.00 - $1.50' 3='(3) $1.51 - $2.00'
                  4='(4) $2.01 - $2.50' 5='(5) $2.51 - $3.00' 6='(6) $3.01 - $3.50'
                  7='(7) $3.51 - $4.00' 8='(8) $4.01 - $4.50' 9='(9) $4.51 - $5.00'
                  10='(10) More than $5.00' 85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cigpdcrt  1='(1) Less than $10.00' 2='(2) $10.00 - $10.99'
                  3='(3) $11.00 - $11.99' 4='(4) $12.00 - $12.99' 5='(5) $13.00 - $13.99'
                  6='(6) $14.00 - $14.99' 7='(7) $15.00 - $15.99' 8='(8) $16.00 - $16.99'
                  9='(9) $17.00 - $17.99' 10='(10) $18.00 - $18.99'
                  11='(11) $19.00 - $19.99' 12='(12) $20.00 - $20.99'
                  13='(13) $21.00 - $21.99' 14='(14) $22.00 - $22.99'
                  15='(15) $23.00 or more' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE alclottm  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alcgtovr  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE alclimit  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alckplmt  1='(1) Usually kept to the limits set'
                  2='(2) Often drank more than intended'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE alcndmor  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alclsefx  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE alccutdn  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alccutev  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE alccut1x  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE alcwd2sx  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE alcwdsmt  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE alcemopb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alcemctd  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE alcphlpb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE alcphctd  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE alclsact  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alcserpb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alcpdang  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alclawtr  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alcfmfpb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE alcfmctd  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE ALC PST 12 MOS OR USED <6 DYS Log asn'
                  91='(91) NEVER USED ALCOHOL'
                  93='(93) DID NOT USE ALC PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE mrjlottm  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DYS Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mrjgtovr  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE mrjlimit  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mrjkplmt  1='(1) Usually kept to the limits set'
                  2='(2) Often used more than intended'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE mrjndmor  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mrjlsefx  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE mrjcutdn  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mrjcutev  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE mrjemopb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mrjemctd  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE mrjphlpb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE mrjphctd  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE mrjlsact  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mrjserpb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mrjpdang  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mrjlawtr  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mrjfmfpb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE mrjfmctd  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE MJ PST 12 MOS OR USED <6 DAY Log asn'
                  91='(91) NEVER USED MARIJUANA'
                  93='(93) DID NOT USE MJ PST 12 MOS OR USED <6 DYS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE coclottm  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cocgtovr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE coclimit  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cockplmt  1='(1) Usually kept to the limits set'
                  2='(2) Often used more than intended' 91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cocndmor  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE coclsefx  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE coccutdn  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE coccutev  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE coccut1x  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cocflblu  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cocwd2sx  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cocwdsmt  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cocemopb  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cocemctd  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE cocphlpb  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE cocphctd  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE coclsact  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cocserpb  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cocpdang  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE coclawtr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cocfmfpb  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED COCAINE' 93='(93) DID NOT USE COCAINE PST 12 MOS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE cocfmctd  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED COCAINE'
                  93='(93) DID NOT USE COCAINE PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE herlottm  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE hergtovr  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE herlimit  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE herkplmt  1='(1) Usually kept to the limits set'
                  2='(2) Often used more than intended' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE herndmor  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE herlsefx  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hercutdn  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE hercutev  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hercut1x  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE herwd3sx  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE herwdsmt  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE heremopb  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE heremctd  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE herphlpb  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE herphctd  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE herlsact  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE herserpb  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE herpdang  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE herlawtr  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE herfmfpb  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE herfmctd  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HEROIN'
                  93='(93) DID NOT USE HEROIN PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hallottm  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE halgtovr  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hallimit  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE halkplmt  1='(1) Usually kept to the limits set'
                  2='(2) Often used more than intended'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE halndmor  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE hallsefx  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE halcutdn  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE halcutev  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE halemopb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE halemctd  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE halphlpb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE halphctd  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hallsact  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE halserpb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE halpdang  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE hallawtr  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE halfmfpb  1='(1) Yes' 2='(2) No'
                  83='(83) DID NOT USE HALLUCINOGENS PST 12 MOS Log assn'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE halfmctd  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED HALLUCINOGENS'
                  93='(93) DID NOT USE HALLUCINOGENS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE inhlottm  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inhgtovr  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE inhlimit  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inhkplmt  1='(1) Usually kept to the limits set'
                  2='(2) Often used more than intended' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE inhndmor  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inhlsefx  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE inhcutdn  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inhcutev  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE inhemopb  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inhemctd  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE inhphlpb  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE inhphctd  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE inhlsact  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inhserpb  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inhpdang  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inhlawtr  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inhfmfpb  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE inhfmctd  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED INHALANTS'
                  93='(93) DID NOT USE INHALANTS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anllottm  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE anlgtovr  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anllimit  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE anlkplmt  1='(1) Usually kept to the limits set'
                  2='(2) Often used more than intended'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anlndmor  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE anllsefx  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anlcutdn  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE anlcutev  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anlcut1x  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anlwd3sx  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anlwdsmt  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anlemopb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE anlemctd  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anlphlpb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anlphctd  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE anllsact  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE anlserpb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE anlpdang  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE anllawtr  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE anlfmfpb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE anlfmctd  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED PAIN RELIEVERS Logically assigned'
                  91='(91) NEVER USED PAIN RELIEVERS'
                  93='(93) DID NOT USE PAIN RELIEVERS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE trnlottm  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trngtovr  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE trnlimit  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trnkplmt  1='(1) Usually kept to the limits set'
                  2='(2) Often used more than intended'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE trnndmor  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trnlsefx  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE trncutdn  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trncutev  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE trnemopb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trnemctd  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE trnphlpb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE trnphctd  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE trnlsact  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trnserpb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trnpdang  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trnlawtr  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trnfmfpb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE trnfmctd  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED TRANQUILIZERS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED TRANQUILIZERS'
                  93='(93) DID NOT USE TRANQUILIZERS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmlottm  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE stmgtovr  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmlimit  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE stmkplmt  1='(1) Usually kept to the limits set'
                  2='(2) Often used more than intended'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmndmor  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE stmlsefx  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmcutdn  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE stmcutev  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmcut1x  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmflblu  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmwd2sx  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmwdsmt  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmemopb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE stmemctd  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmphlpb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmphctd  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE stmlsact  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE stmserpb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE stmpdang  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE stmlawtr  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE stmfmfpb  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE stmfmctd  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED STIMULANTS Logically assigned'
                  91='(91) NEVER USED STIMULANTS'
                  93='(93) DID NOT USE STIMULANTS PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sedlottm  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sedgtovr  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sedlimit  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sedkplmt  1='(1) Usually kept to the limits set'
                  2='(2) Often used more than intended'
                  81='(81) NEVER USED SEDATIVES Logically assigned'
                  91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sedndmor  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sedlsefx  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sedcutdn  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sedcutev  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sedcut1x  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sedwd1sx  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sedwdsmt  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sedemopb  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sedemctd  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sedphlpb  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sedphctd  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sedlsact  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sedserpb  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE sedpdang  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE sedlawtr  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sedfmfpb  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE sedfmctd  1='(1) Yes' 2='(2) No' 81='(81) NEVER USED SEDATIVES Logically assigned'
                  91='(91) NEVER USED SEDATIVES'
                  93='(93) DID NOT USE SEDATIVES PST 12 MOS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE depndalc  0='(0) No / Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE depndanl  0='(0) No / Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE depndcig  0='(0) No / Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE depndcoc  0='(0) No / Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE depndhal  0='(0) No / Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE depndher  0='(0) No / Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE depndinh  0='(0) No / Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE depndmrj  0='(0) No / Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE depndsed  0='(0) No / Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE depndstm  0='(0) No / Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE depndtrn  0='(0) No / Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE depndill  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any source variable listed above=1)' ;
  VALUE depndiem  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (any of the source variables=1)' ;
  VALUE depndxmj  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (DEPNDMRJ=0 and any other source var=1)' ;
  VALUE depndpsy  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (DEPNDTRN, DEPNDANL, DEPNDSTM, OR DEPNDSED=1)' ;
  VALUE dpillalc  0='(0) No / Unknown (DEPNDILL=0 and DEPNDALC=0)'
                  1='(1) Yes (DEPNDILL=1 or DEPNDALC=1)' ;
  VALUE dpilanal  0='(0) No / Unknown (DEPNDILL=0 or DEPNDALC=0)'
                  1='(1) Yes (DEPNDILL=1 and DEPNDALC=1)' ;
  VALUE abusealc  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any one of above criteria and DEPNDALC=0)' ;
  VALUE abuseanl  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any one of above criteria and DEPNDANL=0)' ;
  VALUE abusecoc  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any one of above criteria and DEPNDCOC=0)' ;
  VALUE abusehal  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any one of above criteria and DEPNDHAL=0)' ;
  VALUE abuseher  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any one of above criteria and DEPNDHER=0)' ;
  VALUE abuseinh  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any one of above criteria and DEPNDINH=0)' ;
  VALUE abusemrj  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any one of above criteria and DEPNDMRJ=0)' ;
  VALUE abusesed  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any one of above criteria and DEPNDSED=0)' ;
  VALUE abusestm  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any one of above criteria and DEPNDSTM=0)' ;
  VALUE abusetrn  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any one of above criteria and DEPNDTRN=0)' ;
  VALUE abuseill  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any source variable above =1 & DEPNDILL=0)' ;
  VALUE abuseiem  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any above source var=1 & DEPNDIEM=0)' ;
  VALUE abusexmj  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any above var=1 & ABUSEMRJ=0 & DEPNDXMJ=0)' ;
  VALUE abusepsy  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (Any source variable above & DEPNDPSY=0)' ;
  VALUE abillalc  0='(0) No / Unknown (ABUSEILL=0 AND ABUSEALC=0)'
                  1='(1) Yes (ABUSEILL=1 or ABUSEALC=1)' ;
  VALUE abilanal  0='(0) No / Unknown (Otherwise)'
                  1='(1) Yes (ABUSEILL=1 & ABUSEALC=1 & DPILLALC=0)' ;
  VALUE abodalc   0='(0) No / Unknown (ABUSEALC=0 and DEPNDALC=0)'
                  1='(1) Yes (ABUSEALC=1 or DEPNDALC=1)' ;
  VALUE abodanl   0='(0) No / Unknown (ABUSEANL=0 and DEPNDANL=0)'
                  1='(1) Yes (ABUSEANL=1 or DEPNDANL=1)' ;
  VALUE abodcoc   0='(0) No / Unknown (ABUSECOC=0 and DEPNDCOC=0)'
                  1='(1) Yes (ABUSECOC=1 or DEPNDCOC=1)' ;
  VALUE abodhal   0='(0) No / Unknown (ABUSEHAL=0 and DEPNDHAL=0)'
                  1='(1) Yes (ABUSEHAL=1 or DEPNDHAL=1)' ;
  VALUE abodher   0='(0) No / Unknown (ABUSEHER=0 and DEPNDHER=0)'
                  1='(1) Yes (ABUSEHER=1 or DEPNDHER=1)' ;
  VALUE abodinh   0='(0) No / Unknown (ABUSEINH=0 and DEPNDINH=0)'
                  1='(1) Yes (ABUSEINH=1 or DEPNDINH=1)' ;
  VALUE abodmrj   0='(0) No / Unknown (ABUSEMRJ=0 and DEPNDMRJ=0)'
                  1='(1) Yes (ABUSEMRJ=1 or DEPNDMRJ=1)' ;
  VALUE abodsed   0='(0) No / Unknown (ABUSESED=0 and DEPNDSED=0)'
                  1='(1) Yes (ABUSESED=1 or DEPNDSED=1)' ;
  VALUE abodstm   0='(0) No / Unknown (ABUSESTM=0 and DEPNDSTM=0)'
                  1='(1) Yes (ABUSESTM=1 or DEPNDSTM=1)' ;
  VALUE abodtrn   0='(0) No / Unknown (ABUSETRN=0 and DEPNDTRN=0)'
                  1='(1) Yes (ABUSETRN=1 or DEPNDTRN=1)' ;
  VALUE abodill   0='(0) No / Unknown (ABUSEILL=0 and DEPNDILL=0)'
                  1='(1) Yes (ABUSEILL=1 or DEPNDILL=1)' ;
  VALUE abodpsy   0='(0) No / Unknown (ABUSEPSY=0 and DEPNDPSY=0)'
                  1='(1) Yes (ABUSEPSY=1 or DEPNDPSY=1)' ;
  VALUE abodilal  0='(0) No / Unknown (ABILLALC=0 and DPILLALC=0)'
                  1='(1) Yes (ABILLALC=1 or DPILLALC=1)' ;
  VALUE abdilaal  0='(0) No / Unknown (ABODILL=0 or ABODALC=0)'
                  1='(1) Yes (ABODILL=1 and ABODALC=1)' ;
  VALUE booked    1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE nobookyf  0='(0) None' 1='(1) One time' 2='(2) Two times' 3='(3) Three or more times'
                  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP (BOOKED=2)' ;
  VALUE bkmvthft  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bklarcny  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bkburgl   1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bkagaslt  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bksmaslt  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bkrob     1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bkrape    1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE bkmurder  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE bkarson   1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE bkdrvinf  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bkdrunk   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bkpostob  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bkdrug    1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bkpros    1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bksexoff  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bkfraud   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bkoth     1='(1) Yes' 2='(2) No' 5='(5) Offense unknown'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE bkothoff  1='(1) Larceny or theft' 2='(2) Burglary or breaking and entering'
                  4='(4) Other assault, such as simple assault or battery'
                  5='(5) Motor vehicle theft' 6='(6) Robbery'
                  10='(10) Driving under the influence'
                  11='(11) Drunkenness or other liquor law violation'
                  13='(13) Prostitution or commercialized sex'
                  14='(14) Oth proprty offns: fraud, poss stln goods, vndlsm'
                  15='(15) Other offense, not categorized elsewhere'
                  16='(16) Weapons law violations' 17='(17) Counterfeiting/Forgery'
                  18='(18) Violation of court order, parole, probation'
                  19='(19) Disorderly conduct' 20='(20) Juvenile status offenses'
                  21='(21) All oth offns: crimes agnst persons/prprty/society'
                  22='(22) Traffic violations' 23='(23) Bad checks'
                  24='(24) Curfew/loitering/vagrancy violations'
                  25='(25) Trespass of real property' 26='(26) Runaway'
                  27='(27) Family offenses, nonviolent' 28='(28) Intimidation'
                  29='(29) Non-forcible sex offenses'
                  31='(31) Tobacco law/code violation'
                  38='(38) Evading/hindering/obstructing police'
                  39='(39) False report/statement/alarm'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE probaton  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE parolrel  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE drvaldr   1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE drvaonly  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE drvdonly  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE drivalc   1='(1) Yes (DRVALDR=1 OR DRVAONLY=1)'
                  2='(2) No (DRVALDR=2 AND DRVAONLY=2)' 3='(3) Unknown (OTHERWISE)'
                  4='(4) Never/No Use (DRVALDR AND DRVAONLY=81,89,91,99)' ;
  VALUE drivdrg   1='(1) Yes (DRVALDR=1 OR DRVDONLY=1)'
                  2='(2) No (DRVALDR=2 AND DRVDONLY=2)' 3='(3) Unknown (OTHERWISE)'
                  4='(4) Never/No Use (DRVALDR AND DRVDONLY=81,89,91,99)' ;
  VALUE drivald   1='(1) Yes (DRIVALC=1 OR DRIVDRG=1)'
                  2='(2) No (DRIVALC=2 AND DRIVDRG=2)' 3='(3) Unknown (OTHERWISE)'
                  4='(4) Never/No Use (DRIVALC AND DRIVDRG=4)' ;
  VALUE parol     -9='Unknown Status (PAROLREL=85,94,97,98)'
                  1='(1) On Parole/Supervised Release (PAROLREL=1)'
                  2='(2) Not on Parole/Supervised Release (PAROLREL=2)' ;
  VALUE prob      -9='Unknown Probation Status (PROBATON=85,94,97,98)'
                  1='(1) On Probation (PROBATON=1)'
                  2='(2) Not on Probation (PROBATON=2)' ;
  VALUE txever    1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE txyrever  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2)' ;
  VALUE txyradg   1='(1) Alcohol use only' 2='(2) Drug use only'
                  3='(3) Both alcohol and drug use'
                  4='(4) Alcohol (drug trmt unknown) LOGICALLY ASSIGNED'
                  6='(6) Both alcohol and drug use LOGICALLY ASSIGNED'
                  11='(11) Alcohol only (but last tmt for drugs reported)'
                  12='(12) Drugs only (but last tmt for alc reported)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrhosp  1='(1) Yes' 2='(2) No' 5='(5) Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrhpad  1='(1) Alcohol use' 2='(2) Drug use' 3='(3) Both alcohol and drug use'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrrfin  1='(1) Yes' 2='(2) No' 5='(5) Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrinad  1='(1) Alcohol use' 2='(2) Drug use' 3='(3) Both alcohol and drug use'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrrfop  1='(1) Yes' 2='(2) No' 5='(5) Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrpoad  1='(1) Alcohol use' 2='(2) Drug use' 3='(3) Both alcohol and drug use'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrmhc   1='(1) Yes' 2='(2) No' 5='(5) Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrmhad  1='(1) Alcohol use' 2='(2) Drug use' 3='(3) Both alcohol and drug use'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrtxer  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  5='(5) Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrerad  1='(1) Alcohol use' 2='(2) Drug use' 3='(3) Both alcohol and drug use'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrdoc   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  5='(5) Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrdcad  1='(1) Alcohol use' 2='(2) Drug use' 3='(3) Both alcohol and drug use'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrjail  1='(1) Yes' 2='(2) No' 5='(5) Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrjlad  1='(1) Alcohol use' 2='(2) Drug use' 3='(3) Both alcohol and drug use'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrshg   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  5='(5) Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrsgad  1='(1) Alcohol use' 2='(2) Drug use' 3='(3) Both alcohol and drug use'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrsop   1='(1) Yes' 2='(2) No' 5='(5) Yes LOGICALLY ASSIGNED (from TXLTYMN2)'
                  7='(7) Treatment location unknown, LOG ASSN'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrotsf  9='(9) Some other place, not categorized elsewhere'
                  23='(23) Drug or alcohol rehab facility as outpatient'
                  26='(26) Private doctor''s office' 27='(27) Prison or jail'
                  28='(28) Self-help group' 40='(40) Home, family, friends'
                  41='(41) School, college'
                  42='(42) Church/religious/spiritual influence'
                  44='(44) Halfway house/group home'
                  47='(47) Community/city/county/state program, unspecified'
                  48='(48) Counselor, therapist, psychologist'
                  49='(49) Court-mandated/sponsored program'
                  51='(51) Alcohol/drug class, location unspecified'
                  52='(52) Military/VA Hospital'
                  53='(53) Hospital, patient status unspecified'
                  55='(55) Youth-oriented facility/organization/program'
                  56='(56) Mental health centerfacility, ptnt status unspcfd'
                  63='(63) Medical clinic' 64='(64) Methadone clinic/program'
                  65='(65) Name of facility/program given'
                  981='(981) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED ALCOHOL OR DRUGS' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE txyrotad  1='(1) Alcohol use' 2='(2) Drug use' 3='(3) Both alcohol and drug use'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrvser  1='(1) Yes' 2='(2) No' 6='(6) NEVER USED RELEVANT DRUGS'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txyrnmef  31='(31) 31 or more'
                  981='(981) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED ALCOHOL OR DRUGS' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE txrcvnow  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxnedr  1='(1) Yes' 2='(2) No' 11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxmore  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmralc  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmrmj   1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmrcoc  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmrher  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmrhal  6='(6) Response not entered'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmrinh  6='(6) Response not entered'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmranl  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmrtrn  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmrstm  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmrsed  6='(6) Response not entered'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmroth  1='(1) Response entered' 6='(6) Response not entered'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxalcr  1='(1) Yes' 2='(2) No' 11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxmjr   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxcocr  1='(1) Yes' 2='(2) No' 11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxherr  1='(1) Yes' 2='(2) No' 11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxhalr  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxinhr  1='(1) Yes' 2='(2) No' 11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxanlr  1='(1) Yes' 2='(2) No' 11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxtrnr  1='(1) Yes' 2='(2) No' 11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxstmr  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  13='(13) Yes LOGICALLY ASSIGNED (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxsedr  1='(1) Yes' 2='(2) No' 11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxsodr  1='(1) Yes' 2='(2) No' 5='(5) Drug Unknown LOGICALLY ASSIGNED'
                  11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtxdg1r  103='(103) Amytal' 322='(322) Methamphetamine ("ice" or "crank"), Meth'
                  355='(355) Crystal meth' 658='(658) Special K, Ketamine' 702='(702) Heroin'
                  803='(803) Marijuana, MarrJane, Mary Jane, MJ, pot, weed'
                  805='(805) Cocaine, coca, cocaina, coke'
                  807='(807) Alcohol, beer, ethanol, EtOH, pink champagne'
                  900='(900) Not a drug'
                  9981='(9981) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  9985='(9985) BAD DATA Logically assigned'
                  9991='(9991) NEVER USED ALCOHOL OR DRUGS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE ndtxdg2r  803='(803) Marijuana, MarrJane, Mary Jane, MJ, pot, weed'
                  806='(806) Crack, rock'
                  807='(807) Alcohol, beer, ethanol, EtOH, pink champagne'
                  9981='(9981) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  9991='(9991) NEVER USED ALCOHOL OR DRUGS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE ndtxdg3r  703='(703) Opium'
                  807='(807) Alcohol, beer, ethanol, EtOH, pink champagne'
                  6096='(6096) Bananadine'
                  9981='(9981) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  9991='(9991) NEVER USED ALCOHOL OR DRUGS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE ndtxdg4r  604='(604) Psilocybin (mushrooms), shrooms' 804='(804) Hashish'
                  9981='(9981) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  9991='(9991) NEVER USED ALCOHOL OR DRUGS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE ndtxdg5r  601='(601) LSD ("acid")'
                  9981='(9981) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  9991='(9991) NEVER USED ALCOHOL OR DRUGS' 9997='(9997) REFUSED'
                  9998='(9998) BLANK (NO ANSWER)' 9999='(9999) LEGITIMATE SKIP' ;
  VALUE ndtxeftr  1='(1) Yes' 2='(2) No' 11='(11) Yes (TXYREVER=3)' 12='(12) No (TXYREVER=3)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ndtmreft  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txlasrec  1='(1) Within the past 30 days -- since 30 day ref date'
                  2='(2) More than 30 days ago but within the past 12 mos'
                  3='(3) More than 12 months ago'
                  7='(7) Still in treatment LOG ASSN (TXRCVNOW=1)'
                  8='(8) Treatment in past year LOGICALLY ASSIGNED'
                  9='(9) Treatment in lifetime LOGICALLY ASSIGNED'
                  13='(13) Treatment > 12 mos ago LOG ASSN (TXYREVER=2)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txltymnf  1='(1) A hospital overnight as an inpatient'
                  2='(2) A res drug/alcohol rehab facility overnight'
                  3='(3) A drug or alcohol rehab facility as an outpatient'
                  4='(4) A mental health center or facility as outpatient'
                  5='(5) An emergency room' 6='(6) A private doctor''s office'
                  7='(7) A prison or jail' 8='(8) A self-help group'
                  9='(9) Some other place' 40='(40) Home, family, friends'
                  41='(41) School, college'
                  42='(42) Church/religious/spiritual influence'
                  47='(47) Community/city/county/state program, unspecified'
                  48='(48) Counselor, therapist, psychologist'
                  49='(49) Court-mandated/sponsored program'
                  51='(51) Alcohol/drug class, location unspecified'
                  52='(52) Military/VA Hospital'
                  55='(55) Youth-oriented facility/organization/program'
                  64='(64) Methadone clinic/program'
                  65='(65) Name of facility/program given'
                  981='(981) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  985='(985) BAD DATA Logically assigned'
                  991='(991) NEVER USED ALCOHOL OR DRUGS' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE txltyalc  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  5='(5) Yes LOG ASSN (TXYRADG = 1)'
                  6='(6) NEVER USED ALCOHOL (TXEVER = 1)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' ;
  VALUE txltymj   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  6='(6) NEVER USED MARIJUANA (TXEVER = 1)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' ;
  VALUE txltycoc  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  6='(6) NEVER USED COCAINE (TXEVER = 1)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' ;
  VALUE txltyher  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  6='(6) NEVER USED HEROIN (TXEVER = 1)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' ;
  VALUE txltyhal  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  6='(6) NEVER USED HALLUCINOGENS (TXEVER = 1)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' ;
  VALUE txltyinh  1='(1) Yes' 2='(2) No' 6='(6) NEVER USED INHALANTS (TXEVER = 1)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' ;
  VALUE txltyanl  1='(1) Yes' 2='(2) No' 6='(6) NEVER USED PAIN RELIEVERS (TXEVER = 1)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' ;
  VALUE txltytrn  1='(1) Yes' 2='(2) No' 6='(6) NEVER USED TRANQUILIZERS (TXEVER = 1)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' ;
  VALUE txltystm  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  6='(6) NEVER USED STIMULANTS (TXEVER = 1)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' ;
  VALUE txltysed  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  6='(6) NEVER USED SEDATIVES (TXEVER = 1)'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2/TXYREVER=2,4)' ;
  VALUE txltysod  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  5='(5) Treatment drug unknown, LOGICALLY ASSIGNED'
                  7='(7) Treatment drug/alc unknown LOG ASSN'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txltyouf  1='(1) You are still in treatment'
                  2='(2) You successfully completed treatment'
                  3='(3) You left because you had a problem with program'
                  4='(4) You left b/c you couldn''t afford to continue'
                  5='(5) You left because your family needed you'
                  6='(6) You left because you began using drugs again'
                  7='(7) Your last treatment had some other outcome'
                  41='(41) You left because you didn''t need/want treatment'
                  48='(48) Discontinued treatment, success unknown'
                  49='(49) Completed treatment, outcome unknown'
                  50='(50) You had other problems to deal with'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txltyduf  31='(31) 31 or more'
                  99981='(99981) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  99985='(99985) BAD DATA Logically assigned'
                  99991='(99991) NEVER USED ALCOHOL OR DRUGS' 99994='(99994) DON''T KNOW'
                  99997='(99997) REFUSED' 99998='(99998) BLANK (NO ANSWER)'
                  99999='(99999) LEGITIMATE SKIP' ;
  VALUE txpyins   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txpycare  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txpycaid  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txpypubp  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txpysave  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txpyfmly  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txpycort  1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txpymilc  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txpyempl  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txpysos   1='(1) Yes' 2='(2) No' 4='(4) No LOG ASSN (free trmt specified)'
                  5='(5) Yes, payment source not specified LOG ASSN'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txpysp2f  1='(1) Private health insurance' 3='(3) Medicaid'
                  4='(4) Public assistance program other than Medicaid'
                  5='(5) Own savings or earnings' 6='(6) Family members' 7='(7) Courts'
                  10='(10) Free' 11='(11) Some other source' 12='(12) Friend/sponsor'
                  14='(14) School' 19='(19) Public assistance, unspecified'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txpyfre   1='(1) Yes' 2='(2) No' 3='(3) Yes LOGICALLY ASSIGNED'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE txenroll  1='(1) Yes' 2='(2) No'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (TXEVER=2)' ;
  VALUE txyrdtxo  1='(1) Yes' 2='(2) No' 4='(4) No LOGICALLY ASSIGNED'
                  81='(81) NEVER USED ALCOHOL OR DRUGS Logically assigned'
                  91='(91) NEVER USED ALCOHOL OR DRUGS' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE spectill  0='(0) No/Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE spectalc  0='(0) No/Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE spillalc  0='(0) No/Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE illneed   0='(0) No/Unknown (Otherwise)' 1='(1) Yes (See comment above)' ;
  VALUE txnospec  0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (ILLNEED=1 and SPECTILL=0)' ;
  VALUE alctrmt   0='(0) No/Unknown (TXYRADG=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXYRADG=1,3,4,6,11,12)' ;
  VALUE illtrmt   0='(0) No/Unknown (TXYRADG=1,4,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXYRADG=2,3,6,11,12)' ;
  VALUE txillalc  0='(0) No/Unknown (TXYREVER=2,4,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXYREVER=1,3)' ;
  VALUE txilanal  0='(0) No/Unknown (TXYRADG=1,2,4,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXYRADG=3,6,11,12)' ;
  VALUE txltalcf  0='(0) No/Unknown (TXLTYALC=2,6,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXLTYALC=1,3,5)' ;
  VALUE txltanlf  0='(0) No/Unknown (TXLTYANL=2,6,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXLTYANL=1)' ;
  VALUE txltcocf  0='(0) No/Unknown (TXLTYCOC=2,6,81,91,94,97,98,99)'
                  1='(1) Yes (TXLTYCOC=1,3)' ;
  VALUE txlthalf  0='(0) No/Unknown (TXLTYHAL=2,6,81,91,94,97,98,99)'
                  1='(1) Yes (TXLTYHAL=1,3)' ;
  VALUE txltherf  0='(0) No/Unknown (TXLTYHER=2,6,81,91,97,98,99)'
                  1='(1) Yes (TXLTYHER=1,3)' ;
  VALUE txltinhf  0='(0) No/Unknown (TXLTYINH=2,6,81,91,94,97,98,99)'
                  1='(1) Yes (TXLTYINH=1)' ;
  VALUE txltmj2f  0='(0) No/Unknown (TXLTYMJ=2,6,81,91,94,97,98,99)'
                  1='(1) Yes (TXLTYMJ=1,3)' ;
  VALUE txltsedf  0='(0) No/Unknown (TXLTYSED=2,6,81,91,94,97,98,99)'
                  1='(1) Yes (TXLTYSED=1,3)' ;
  VALUE txltstmf  0='(0) No/Unknown (TXLTYSTM=2,6,81,91,94,97,98,99)'
                  1='(1) Yes (TXLTYSTM=1,3)' ;
  VALUE txlttrnf  0='(0) No/Unknown (TXLTYTRN=2,6,81,91,94,97,98,99)'
                  1='(1) Yes (TXLTYTRN=1)' ;
  VALUE txltillf  0='(0) No/Unknown (Otherwise)' 1='(1) Yes (ANY SOURCE VARIABLE=1)' ;
  VALUE txpins2f  0='(0) No/Unknown (TXPYINS=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXPYINS=1,3)' ;
  VALUE txpcaref  0='(0) No/Unknown (TXPYCARE=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXPYCARE=1)' ;
  VALUE txpcaidf  0='(0) No/Unknown (TXPYCAID=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXPYCAID=1,3)' ;
  VALUE txppubpf  0='(0) No/Unknown (TXPYPUBP=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXPYPUBP=1,3)' ;
  VALUE txpsavef  0='(0) No/Unknown (TXPYSAVE=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXPYSAVE=1,3)' ;
  VALUE txpfmlyf  0='(0) No/Unknown (TXPYFMLY=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXPYFMLY=1,3)' ;
  VALUE txpcortf  0='(0) No/Unknown (TXPYCORT=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXPYCORT=1,3)' ;
  VALUE txpmilcf  0='(0) No/Unknown (TXPYMILC=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXPYMILC=1)' ;
  VALUE txpemplf  0='(0) No/Unknown (TXPYEMPL=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXPYEMPL=1)' ;
  VALUE illpins   0='(0) No/Unknown (TXLTILL2=0 OR TXPINS2=0)'
                  1='(1) Yes (TXLTILL2=1 AND TXPINS2=1)' ;
  VALUE illpcare  0='(0) No/Unknown (TXLTILL2=0 OR TXPCARE2=0)'
                  1='(1) Yes (TXLTILL2=1 AND TXPCARE2=1)' ;
  VALUE illpcaid  0='(0) No/Unknown (TXLTILL2=0 OR TXPCAID2=0)'
                  1='(1) Yes (TXLTILL2=1 AND TXPCAID2=0)' ;
  VALUE illppubp  0='(0) No/Unknown (TXLTILL2=0 OR TXPPUBP2=0)'
                  1='(1) Yes (TXLTILL2=1 AND TXPPUBP2=1)' ;
  VALUE illpsave  0='(0) No/Unknown (TXLTILL2=0 OR TXPSAVE2=0)'
                  1='(1) Yes (TXLTILL2=1 AND TXPSAVE2=1)' ;
  VALUE illpfmly  0='(0) No/Unknown (TXLTILL2=0 OR TXPFMLY2=0)'
                  1='(1) Yes (TXLTILL2=1 AND TXPFMLY2=1)' ;
  VALUE illpcort  0='(0) No/Unknown (TXLTILL2=0 OR TXPCORT2=0)'
                  1='(1) Yes (TXLTILL2=1 AND TXPCORT2=1)' ;
  VALUE illpmilc  0='(0) No/Unknown (TXLTILL2=0 OR TXPMILC2=0)'
                  1='(1) Yes (TXLTILL2=1 AND TXPMILC2=1)' ;
  VALUE illpempl  0='(0) No/Unknown (TXLTILL2=0 OR TXPEMPL2=0)'
                  1='(1) Yes (TXLTILL2=1 AND TXPEMPL2=1)' ;
  VALUE alcpins   0='(0) No/Unknown (TXLTALC2=0 OR TXPINS2=0)'
                  1='(1) Yes (TXLTALC2=1 AND TXPINS2=1)' ;
  VALUE alcpcare  0='(0) No/Unknown (TXLTALC2=0 OR TXPCARE2=0)'
                  1='(1) Yes (TXLTALC2=1 AND TXPCARE2=1)' ;
  VALUE alcpcaid  0='(0) No/Unknown (TXLTALC2=0 OR TXPCAID2=0)'
                  1='(1) Yes (TXLTALC2=1 AND TXPCAID2=1)' ;
  VALUE alcppubp  0='(0) No/Unknown (TXLTALC2=0 OR TXPPUBP2=0)'
                  1='(1) Yes (TXLTALC2=1 AND TXPPUBP2=1)' ;
  VALUE alcpsave  0='(0) No/Unknown (TXLTALC2=0 OR TXPSAVE2=0)'
                  1='(1) Yes (TXLTALC2=1 AND TXPSAVE2=1)' ;
  VALUE alcpfmly  0='(0) No/Unknown (TXLTALC2=0 OR TXPFMLY2=0)'
                  1='(1) Yes (TXLTALC2=1 AND TXPFMLY2=1)' ;
  VALUE alcpcort  0='(0) No/Unknown (TXLTALC2=0 OR TXPCORT2=0)'
                  1='(1) Yes (TXLTALC2=1 AND TXPCORT2=1)' ;
  VALUE alcpmilc  0='(0) No/Unknown (TXLTALC2=0 OR TXPMILC2=0)'
                  1='(1) Yes (TXLTALC2=1 AND TXPMILC2=1)' ;
  VALUE alcpempl  0='(0) No/Unknown (TXLTALC2=0 OR TXPEMPL2=0)'
                  1='(1) Yes (TXLTALC2=1 AND TXPEMPL2=1)' ;
  VALUE lochosp   0='(0) No/Unknown (TXYRHOSP=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXYRHOSP=1,5)' ;
  VALUE locrfin   0='(0) No/Unknown (TXYRRFIN=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXYRRFIN=1,3,5)' ;
  VALUE locrfop   0='(0) No/Unknown (TXYRRFOP=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXYRRFOP=1,5)' ;
  VALUE locmhc    0='(0) No/Unknown (TXYRMHC=2,81,85,91,94,97,98,99)'
                  1='(1) Yes (TXYRMHC=1,5)' ;
  VALUE loctxer   0='(0) No/Unknown (TXYRTXER=2,81,85,91,97,98,99)'
                  1='(1) Yes (TXYRTXER=1,3,5)' ;
  VALUE locdoc    0='(0) No/Unknown (TXYRDOC=2,81,85,91,94,97,98,99'
                  1='(1) Yes (TXYRDOC=1,3,5)' ;
  VALUE locjail   0='(0) No/Unknown (TXYRJAIL=2,81,85,91,97,98,99)'
                  1='(1) Yes (TXYRJAIL=1,5)' ;
  VALUE locshg    0='(0) No/Unknown (TXYRSHG=2,81,85,91,97,98,99)'
                  1='(1) Yes (TXYRSHG=1,3,5)' ;
  VALUE drghosp   0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRHOSP=1 AND TXYRHPAD=2,3)' ;
  VALUE drgrfin   0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRRFIN=1 AND TXYRINAD=2,3)' ;
  VALUE drgrfop   0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRRFOP=1 AND TXYRPOAD=2,3)' ;
  VALUE drgmhc    0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRMHC=1 AND TXYRMHAD=2,3)' ;
  VALUE drgtxer   0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRTXER=1 AND TXYRERAD=2,3)' ;
  VALUE drgdoc    0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRDOC=1 AND TXYRDCAD=2,3)' ;
  VALUE drgjail   0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRJAIL=1 AND TXYRJLAD=2,3)' ;
  VALUE drgshg    0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRSHG=1 AND TXYRSGAD=2,3)' ;
  VALUE alchosp   0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRHOSP=1 AND TXYRHPAD=1,3)' ;
  VALUE alcrfin   0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRRFIN=1 AND TXYRINAD=1,3)' ;
  VALUE alcrfop   0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRRFOP=1 AND TXYRPOAD=1,3)' ;
  VALUE alcmhc    0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRMHC=1 AND TXYRMHAD=1,3)' ;
  VALUE alctxer   0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRTXER=1 AND TXYRERAD=1,3)' ;
  VALUE alcdoc    0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRDOC=1 AND TXYRDCAD=1,3)' ;
  VALUE alcjail   0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRJAIL=1 AND TXYRJLAD=1,3)' ;
  VALUE alcshg    0='(0) No/Unknown (Otherwise)'
                  1='(1) Yes (TXYRSHG=1 AND TXYRSGAD=1,3)' ;
  VALUE auinpyr   1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE auinpsyh  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE auinpgen  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE auinmedu  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE auinahsp  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE auinresd  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE auinsfac  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aunmpsyf  31='(31) 31 or more' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE aunmpgef  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE aunmmedu  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE aunmahsp  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE aunmresd  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE aunmsfaf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE aupinslf  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE aupinofm  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupinphi  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupinmcr  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupinmcd  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupinreh  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupinemp  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupinmil  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupinpub  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupinprv  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupinfre  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupinamt  1='(1) Less than $100' 2='(2) $100 to $200' 3='(3) $201 to $500'
                  4='(4) $501 to $900' 5='(5) $901 to $1,500' 6='(6) $1,501 to $2,000'
                  7='(7) $2,001 to $5,000' 8='(8) More than $5,000' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE auoptyr   1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE auopment  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE auopther  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE auopdoc   1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE auopclnc  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE auopdtmt  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE auopotop  1='(1) Response entered' 6='(6) Response not entered'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE auopyrsf  1='(1) An outpatient mental health clinic or center'
                  2='(2) Non-clinic therapist/psychologist/counselor'
                  3='(3) A doctor''s office that was not part of a clinic'
                  4='(4) An outpatient medical clinic'
                  5='(5) A partial day hospital or day treatment program'
                  6='(6) Some other place, not categorized elsewhere'
                  7='(7) Friend(s)/parent of friend' 8='(8) Family member(s)/home'
                  9='(9) School or university setting/clinic/center'
                  10='(10) Church/clergy/religious influence'
                  11='(11) Support group/self-help group/group counseling'
                  12='(12) Clinic or center counseling; mental/health unspcfd'
                  13='(13) Therapist/psychologist/counselor; locale unspecfd'
                  14='(14) A doctor''s office; location unspecified'
                  15='(15) Work/parents'' work/Employee Assistance Program'
                  18='(18) Military facility/VA'
                  22='(22) Health professional, not a Dr; non-mental health'
                  24='(24) Clinic/center, type unspecified'
                  70='(70) Name of facility/description of facility given'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE aunmmenf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE aunmthef  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE aunmdocf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE aunmclnf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE aunmdtmf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE aunmotof  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE aupopslf  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE aupopofm  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupopphi  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupopmcr  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupopmcd  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE aupopreh  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupopemp  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE aupopmil  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupoppub  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE aupopprv  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE aupopfre  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE aupopmos  1='(1) Self or a family member living with you'
                  2='(2) A family member who does not live with you'
                  3='(3) Private health insurance' 4='(4) Medicare' 5='(5) Medicaid'
                  7='(7) Employer' 8='(8) VA or other military program'
                  9='(9) Other public source' 10='(10) Other private source'
                  11='(11) No one paid because the treatment was free'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE aupopamt  1='(1) Less than $100' 2='(2) $100 to $200' 3='(3) $201 to $500'
                  4='(4) $501 to $900' 5='(5) $901 to $1,500' 6='(6) $1,501 to $2,000'
                  7='(7) $2,001 to $5,000' 8='(8) More than $5,000' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE aurxyr    1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE auunmtyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE auunmtrs  1='(1) Couldn''t afford it' 2='(2) Some other reason'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE amhinp    1='(1) Yes (AUINPYR=1)' 2='(2) No (AUINPYR=2)'
                  3='(3) Unknown (AUINPYR=85,94,97,98)'
                  4='(4) Aged 12-17(AUINPYR=89,99)' ;
  VALUE amhoutp   1='(1) Yes (AUOPTYR=1)' 2='(2) No (AUOPTYR=2)'
                  3='(3) Unknown (AUOPTYR=85,94,97,98)'
                  4='(4) Aged 12-17(AUOPTYR=89,99)' ;
  VALUE amhrx     1='(1) Yes (AURXYR=1)' 2='(2) No (AURXYR=2)'
                  3='(3) Unknown (AURXYR=85,94,97,98)'
                  4='(4) Aged 12-17(AURXYR=89,99)' ;
  VALUE amhtxrec  1='(1) Yes (AMHINP=1 OR AMHOUTP=1 OR AMHRX=1)'
                  2='(2) No (AMHINP=2 AND AMHOUTP=2 AND AMHRX=2)'
                  3='(3) Unknown (OTHERWISE)'
                  4='(4) Aged 12-17 (AMHINP=4 AND AMHOUTP=4 AND AMHRX=4)' ;
  VALUE amhtrtnd  1='(1) Yes (AUUNMTYR=1)' 2='(2) No (AUUNMTYR=2)'
                  3='(3) Unknown (AUUNMTYR=85,94,97,98)'
                  4='(4) Aged 12-17(AUUNMTYR=89,99)' ;
  VALUE sncrime   1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snselldg  1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snppval   1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snstfgt   1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snemtbld  1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snpphlp   1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE sngrafti  1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snppvsit  1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snppmove  1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snmov5yf  0='(0) None' 1='(1) One time' 2='(2) Two times' 3='(3) Three times'
                  4='(4) Four times' 5='(5) Five times' 6='(6) Six or more times'
                  989='(989) LEGITIMATE SKIP Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE snspouse  1='(1) Yes' 2='(2) No' 89='(89) LEGITIMATE SKIP Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE snspactv  1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) A few times' 4='(4) Many times'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snspangr  1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) A few times' 4='(4) Many times'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snsphitu  1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) A few times' 4='(4) Many times'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snyhitsp  1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) A few times' 4='(4) Many times'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snspcrit  1='(1) Always' 2='(2) Sometimes' 3='(3) Seldom' 4='(4) Never'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE snspconc  1='(1) Always' 2='(2) Sometimes' 3='(3) Seldom' 4='(4) Never'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE snfrconc  1='(1) None' 2='(2) One' 3='(3) 2 or 3' 4='(4) 4 to 5' 5='(5) More than 5'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snfractv  1='(1) None' 2='(2) One' 3='(3) 2 or 3' 4='(4) 4 to 5' 5='(5) More than 5'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snfrcare  1='(1) None' 2='(2) One' 3='(3) 2 or 3' 4='(4) 4 to 5' 5='(5) More than 5'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snysell   1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) 3 to 5 times'
                  4='(4) 6 to 9 times' 5='(5) 10 or more times'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snystole  1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) 3 to 5 times'
                  4='(4) 6 to 9 times' 5='(5) 10 or more times'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snyattak  1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) 3 to 5 times'
                  4='(4) 6 to 9 times' 5='(5) 10 or more times'
                  85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snfacig   1='(1) Neither approve nor disapprove' 2='(2) Somewhat disapprove'
                  3='(3) Strongly disapprove'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snfamjev  1='(1) Neither approve nor disapprove' 2='(2) Somewhat disapprove'
                  3='(3) Strongly disapprove'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snfaaldy  1='(1) Neither approve nor disapprove' 2='(2) Somewhat disapprove'
                  3='(3) Strongly disapprove'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE snfaaldv  1='(1) Neither approve nor disapprove' 2='(2) Somewhat disapprove'
                  3='(3) Strongly disapprove'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yecrime   1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeselldg  1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yepphlp   1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yestfgt   1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeemtbld  1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeppvsit  1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yegrafti  1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeppmove  1='(1) Strongly Agree' 2='(2) Somewhat Agree' 3='(3) Somewhat Disagree'
                  4='(4) Strongly Disagree' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yemov5yf  0='(0) None' 1='(1) One time' 2='(2) Two times' 3='(3) Three times'
                  4='(4) Four times' 5='(5) Five times' 6='(6) Six or more times'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE yeenrlyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yelstgrd  1='(1) An "A+", "A" or "A-minus" average'
                  2='(2) A "B+", "B" or "B-minus" average'
                  3='(3) A "C+", "C" or "C-minus" average'
                  4='(4) A "D" or less than a "D" average'
                  5='(5) My school does not give these grades'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeyfgtsw  1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) 3 to 5 times'
                  4='(4) 6 to 9 times' 5='(5) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeyfgtgp  1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) 3 to 5 times'
                  4='(4) 6 to 9 times' 5='(5) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeyhgun   1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) 3 to 5 times'
                  4='(4) 6 to 9 times' 5='(5) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeysell   1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) 3 to 5 times'
                  4='(4) 6 to 9 times' 5='(5) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeystole  1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) 3 to 5 times'
                  4='(4) 6 to 9 times' 5='(5) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeyattak  1='(1) 0 times' 2='(2) 1 or 2 times' 3='(3) 3 to 5 times'
                  4='(4) 6 to 9 times' 5='(5) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeppkcig  1='(1) Neither approve nor disapprove' 2='(2) Somewhat disapprove'
                  3='(3) Strongly disapprove' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yepmjevr  1='(1) Neither Approve or Disapprove' 2='(2) Somewhat Disapprove'
                  3='(3) Strongly Disapprove' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yepaldly  1='(1) Neither Approve or Disapprove' 2='(2) Somewhat Disapprove'
                  3='(3) Strongly Disapprove' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yegpkcig  1='(1) Neither approve nor disapprove' 2='(2) Somewhat disapprove'
                  3='(3) Strongly disapprove' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yegmjevr  1='(1) Neither approve nor disapprove' 2='(2) Somewhat disapprove'
                  3='(3) Strongly disapprove' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yegaldly  1='(1) Neither approve nor disapprove' 2='(2) Somewhat disapprove'
                  3='(3) Strongly disapprove' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yetlknon  1='(1) Response entered' 6='(6) Response not entered'
                  11='(11) Response entered (& other responses entered)'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yetlkpar  1='(1) Response entered' 6='(6) Response not entered'
                  11='(11) Response entered (YETLKNON=11)' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yetlksop  1='(1) Response entered' 6='(6) Response not entered'
                  11='(11) Response entered (YETLKNON=11)' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeprtdng  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yebigbro  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yeprbslv  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yevioprv  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yeymca    1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yescouts  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yeprvles  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yedgprgp  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yetemspt  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ye4hclub  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yeslfhlp  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yeband    1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yeschclb  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yevolunt  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yestgovt  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yeprgstd  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yejbskil  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yechoir   1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yedeclas  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yederglr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yedespcl  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yepvntyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgfrnd  1='(1) 0 times' 2='(2) 1 time' 3='(3) 2 times' 4='(4) 3 to 5 times'
                  5='(5) 6 to 9 times' 6='(6) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgvend  1='(1) 0 times' 2='(2) 1 time' 3='(3) 2 times' 4='(4) 3 to 5 times'
                  5='(5) 6 to 9 times' 6='(6) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgmaif  1='(1) 0 times' 2='(2) 1 time' 3='(3) 2 times' 4='(4) 3 to 5 times'
                  5='(5) 6 or more times' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgchko  1='(1) 0 times' 2='(2) 1 time' 3='(3) 2 times' 4='(4) 3 to 5 times'
                  5='(5) 6 to 9 times' 6='(6) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgclrk  1='(1) 0 times' 2='(2) 1 time' 3='(3) 2 times' 4='(4) 3 to 5 times'
                  5='(5) 6 to 9 times' 6='(6) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecginet  1='(1) 0 times' 2='(2) 1 time' 3='(3) 2 times' 4='(4) 3 to 5 times'
                  6='(6) 10 or more times' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgsmkt  1='(1) 0 times' 2='(2) 1 time' 3='(3) 2 times' 4='(4) 3 to 5 times'
                  5='(5) 6 to 9 times' 6='(6) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgdsto  1='(1) 0 times' 2='(2) 1 time' 3='(3) 2 times' 4='(4) 3 to 5 times'
                  5='(5) 6 to 9 times' 6='(6) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgconv  1='(1) 0 times' 2='(2) 1 time' 3='(3) 2 times' 4='(4) 3 to 5 times'
                  5='(5) 6 to 9 times' 6='(6) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgindv  1='(1) 0 times' 2='(2) 1 time' 3='(3) 2 times' 4='(4) 3 to 5 times'
                  5='(5) 6 to 9 times' 6='(6) 10 or more times'
                  85='(85) BAD DATA Logically assigned' 91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgpruf  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgsucc  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yepkcrtn  1='(1) Pack' 2='(2) Carton' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yepdpack  1='(1) Less than $1.00' 2='(2) $1.00 - $1.50' 3='(3) $1.51 - $2.00'
                  4='(4) $2.01 - $2.50' 5='(5) $2.51 - $3.00' 6='(6) $3.01 - $3.50'
                  7='(7) $3.51 - $4.00' 8='(8) $4.01 - $4.50' 9='(9) $4.51 - $5.00'
                  10='(10) More than $5.00' 85='(85) BAD DATA Logically assigned'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yepdcrtn  1='(1) Less than $10.00' 2='(2) $10.00 - $10.99'
                  3='(3) $11.00 - $11.99' 4='(4) $12.00 - $12.99' 5='(5) $13.00 - $13.99'
                  6='(6) $14.00 - $14.99' 7='(7) $15.00 - $15.99' 8='(8) $16.00 - $16.99'
                  9='(9) $17.00 - $17.99' 10='(10) $18.00 - $18.99'
                  11='(11) $19.00 - $19.99' 15='(15) $23.00 or more'
                  91='(91) NEVER USED CIGARETTES'
                  93='(93) DID NOT USE CIGARETTES IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yeblntev  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yeblnt3f  1='(1) Yes' 2='(2) No' 11='(11) Yes (YEBL30FQ=0)'
                  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yebl30fq  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yecgrwmj  1='(1) Yes' 2='(2) No' 91='(91) NEVER USED CIGARS'
                  93='(93) DID NOT USE CIGARS IN THE PAST 30 DAYS'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE nghcrimf  -9='OTHERWISE (YECRIME = 94,97,98,99)'
                  1='(1) STRONGLY OR SOMEWHAT AGREE (YECRIME = 1,2)'
                  2='(2) SOMEWHAT OR STRONGLY DISAGREE (YECRIME = 3,4)' ;
  VALUE nghsellf  -9='OTHERWISE (YESLLDG = 94,97,98,99)'
                  1='(1) STRONGLY OR SOMEWHAT AGREE (YESLLDG = 1,2)'
                  2='(2) SOMEWHAT OR STRONGLY DISAGREE (YESLLDG = 3,4)' ;
  VALUE nghhelpf  -9='OTHERWISE (YEPPHLP = 94,97,98,99)'
                  1='(1) STRONGLY OR SOMEWHAT AGREE (YEPPHLP = 1,2)'
                  2='(2) SOMEWHAT OR STRONGLY DISAGREE (YEPPHLP = 3,4)' ;
  VALUE nghfghtf  -9='OTHERWISE (YESTFGT = 94,97,98,99)'
                  1='(1) STRONGLY OR SOMEWHAT AGREE (YESTFGT = 1,2)'
                  2='(2) SOMEWHAT OR STRONGLY DISAGREE (YESTFGT = 3,4)' ;
  VALUE nghbldgf  -9='OTHERWISE (YEEMTBLD = 94,97,98,99)'
                  1='(1) STRONGLY OR SOMEWHAT AGREE (YEEMTBLD = 1,2)'
                  2='(2) SOMEWHAT OR STRONGLY DISAGREE (YEEMTBLD = 3,4)' ;
  VALUE nghvsitf  -9='OTHERWISE (YEPPVSIT = 94,97,98,99)'
                  1='(1) STRONGLY OR SOMEWHAT AGREE (YEPPVSIT = 1,2)'
                  2='(2) SOMEWHAT OR STRONGLY DISAGREE (YEPPVSIT = 3,4)' ;
  VALUE nghgraff  -9='OTHERWISE (YEGRAFTI = 94,97,98,99)'
                  1='(1) STRONGLY OR SOMEWHAT AGREE (YEGRAFTI = 1,2)'
                  2='(2) SOMEWHAT OR STRONGLY DISAGREE (YEGRAFTI = 3,4)' ;
  VALUE nghmovef  -9='OTHERWISE (YEPPMOVE = 94,97,98,99)'
                  1='(1) STRONGLY OR SOMEWHAT AGREE (YEPPMOVE = 1,2)'
                  2='(2) SOMEWHAT OR STRONGLY DISAGREE (YEPPMOVE = 3,4)' ;
  VALUE mvin5yrf  -9='OTHERWISE (YEMOV5Y2 = 994,997,998,999)'
                  1='(1) MORE THAN 1 TIME (YEMOV5Y2 = 2-6)'
                  2='(2) NONE OR ONE TIME (YEMOV5Y2 = 0,1 )' ;
  VALUE prpkcigf  -9='OTHERWISE (YEPPKCIG = 94,97,98,99)'
                  1='(1) STRONGLY DISAPPROVE (YEPPKCIG = 3)'
                  2='(2) SOMEWHAT DISAPPROVE OR NEITHER (YEPPKCIG = 1,2)' ;
  VALUE prmjevrf  -9='OTHERWISE (YEPMJEVR = 94,97,98,99)'
                  1='(1) STRONGLY DISAPPROVE (YEPMJEVR = 3)'
                  2='(2) SOMEWHAT DISAPPROVE OR NEITHER (YEPMJEVR = 1,2)' ;
  VALUE praldlyf  -9='OTHERWISE (YEPALDLY = 94,97,98,99)'
                  1='(1) STRONGLY DISAPPROVE (YEPALDLY = 3)'
                  2='(2) SOMEWHAT DISAPPROVE OR NEITHER (YEPALDLY = 1,2)' ;
  VALUE prtalk3f  -9='OTHERWISE (YEPRTDNG = 85,94,97,98,99)'
                  1='(1) YES (YEPRTDNG = 1)' 2='(2) NO (YEPRTDNG = 2)' ;
  VALUE yofightf  -9='OTHERWISE (YEYFGTSW = 85,94,97,98,99)'
                  1='(1) ONE OR MORE TIMES (YEYFGTSW = 2,3,4,5)'
                  2='(2) NONE (YEYFGTSW = 1)' ;
  VALUE yogrpftf  -9='OTHERWISE (YEYFGTGP = 85,94,97,98,99)'
                  1='(1) ONE OR MORE TIMES (YEYFGTGP = 2,3,4,5)'
                  2='(2) NONE (YEYFGTGP = 1)' ;
  VALUE yohgun2f  -9='OTHERWISE (YEYHGUN = 85,94,97,98,99)'
                  1='(1) ONE OR MORE TIMES (YEYHGUN = 2,3,4,5)'
                  2='(2) NONE (YEYHGUN = 1)' ;
  VALUE yosell2f  -9='OTHERWISE (YEYSELL = 85,94,97,98,99)'
                  1='(1) ONE OR MORE TIMES (YEYSELL = 2,3,4,5)'
                  2='(2) NONE (YEYSELL = 1)' ;
  VALUE yostolef  -9='OTHERWISE (YEYSTOLE = 85,94,97,98,99)'
                  1='(1) ONE OR MORE TIMES (YEYSTOLE = 2,3,4,5)'
                  2='(2) NONE (YEYSTOLE = 1)' ;
  VALUE yoattakf  -9='OTHERWISE (YEYATTAK = 85,94,97,98,99)'
                  1='(1) ONE OR MORE TIMES (YEYATTAK = 2,3,4,5)'
                  2='(2) NONE (YEYATTAK = 1)' ;
  VALUE yflpkcgf  -9='OTHERWISE (YEGPKCIG = 94,97,98,99)'
                  1='(1) SOMEWHAT OR STRONGLY DISAPPROVE (YEGPKCIG = 2,3)'
                  2='(2) NEITHER APPROVE OR DISAPPROVE (YEGPKCIG = 1)' ;
  VALUE yfltmrjf  -9='OTHERWISE (YEGMJEVR = 94,97,98,99)'
                  1='(1) SOMEWHAT OR STRONGLY DISAPPROVE (YEGMJEVR = 2,3)'
                  2='(2) NEITHER APPROVE OR DISAPPROVE (YEGMJEVR = 1)' ;
  VALUE yfladlyf  -9='OTHERWISE (YEGALDLY = 94,97,98,99)'
                  1='(1) SOMEWHAT OR STRONGLY DISAPPROVE (YEGALDLY = 2,3)'
                  2='(2) NEITHER APPROVE OR DISAPPROVE (YEGALDLY = 1)' ;
  VALUE youthact  -9='OTHERWISE' 1='(1) NONE OR ONE ACTIVITY WAS MARKED'
                  2='(2) TWO OR MORE ACTIVITIES WERE MARKED' ;
  VALUE prbsolvf  -9='OTHERWISE (YEPRBSLV = 85,94,97,98,99)'
                  1='(1) YES (YEPRBSLV = 1)' 2='(2) NO (YEPRBSLV = 2)' ;
  VALUE previolf  -9='OTHERWISE (YEVIOPRV = 85,94,97,98,99)'
                  1='(1) YES (YEVIOPRV = 1)' 2='(2) NO (YEVIOPRV = 2)' ;
  VALUE prvdrgof  -9='OTHERWISE (YEDGPRGP = 85,94,97,98,99)'
                  1='(1) YES (YEDGPRGP = 1)' 2='(2) NO (YEDGPRGP = 2)' ;
  VALUE grpcnslf  -9='OTHERWISE (YESLFHLP = 85,94,97,98,99)'
                  1='(1) YES (YESLFHLP = 1)' 2='(2) NO (YESLFHLP = 2)' ;
  VALUE pregpgmf  -9='OTHERWISE (YEPRGSTD = 85,94,97,98,99)'
                  1='(1) YES (YEPRGSTD= 1)' 2='(2) NO (YEPRGSTD = 2)' ;
  VALUE dgspclsf  -9='OTHERWISE (YEDECLAS = 85,94,97,98,99)'
                  1='(1) YES (YEDECLAS = 1)' 2='(2) NO (YEDECLAS = 2)' ;
  VALUE dgrgclsf  -9='OTHERWISE (YEDERGLR = 85,94,97,98,99)'
                  1='(1) YES (YEDERGLR = 1)' 2='(2) NO (YEDERGLR = 2)' ;
  VALUE drglectf  -9='OTHERWISE (YEDESPCL = 85,94,97,98,99)'
                  1='(1) YES (YEDESPCL = 1)' 2='(2) NO (YEDESPCL = 2)' ;
  VALUE drprvmef  -9='OTHERWISE (YEPVNTYR = 85,94,97,98,99)'
                  1='(1) YES (YEPVNTYR = 1)' 2='(2) NO (YEPVNTYR = 2)' ;
  VALUE anyeducf  -9='OTHERWISE'
                  1='(1) YES (DGSPCLS2 = 1 OR DGRGCLS2 = 1 OR DRGLECT2 = 1)'
                  2='(2) NO (DGSPCLS2 = 2 & DGRGCLS2 = 2 & DRGLECT2 = 2)' ;
  VALUE cigfrnd   0='(0) Otherwise (YECGFRND=1,85,91,93,94,97,98,99)'
                  1='(1) Yes (YECGFRND=2,3,4,5,6)' ;
  VALUE cigvend   0='(0) Otherwise (YECGVEND=1,85,91,93,94,97,98,99)'
                  1='(1) Yes (YECGVEND=2,3,4,5,6)' ;
  VALUE cigmail   0='(0) Otherwise (YECGMAI2=1,85,91,93,94,97,98,99)'
                  1='(1) At least 1 time (YECGMAI2=2,3,4,5)' ;
  VALUE cigckout  0='(0) Otherwise (YECGCHKO=1,85,91,93,94,97,98,99)'
                  1='(1) Yes (YECGCHKO=2,3,4,5,6)' ;
  VALUE cigclerk  0='(0) Otherwise (YECGCLRK=1,85,91,93,94,97,98,99)'
                  1='(1) Yes (YECGCLRK=2,3,4,5,6)' ;
  VALUE ciginet   0='(0) Otherwise (YECGINET=1,85,91,93,94,97,98,99)'
                  1='(1) Yes (YECGINET=2,3,4,5,6)' ;
  VALUE cigsmkt   0='(0) Otherwise (YECGSMKT=1,85,91,93,94,97,98,99)'
                  1='(1) Yes (YECGSMKT=2,3,4,5,6)' ;
  VALUE cigdsto   0='(0) Otherwise (YECGDSTO=1,85,91,93,94,97,98,99)'
                  1='(1) Yes (YECGDSTO=2,3,4,5,6)' ;
  VALUE cigconv   0='(0) Otherwise (YECGCONV=1,85,91,93,94,97,98,99)'
                  1='(1) Yes (YECGCONV=2,3,4,5,6)' ;
  VALUE cigindiv  0='(0) Otherwise (YECGINDV=1,85,91,93,94,97,98,99)'
                  1='(1) Yes (YECGINDV=2,3,4,5,6)' ;
  VALUE ythbght   0='(0) Otherwise' 1='(1) Yes (ANY SOURCE VARIABLE=1)' ;
  VALUE ymspgrup  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymspfntp  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymsahome  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymsaache  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymsabdrm  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymsaslep  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymsaabdn  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymsauplv  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymsahmsk  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymagohsf  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymagcrwd  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymagtrav  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymagbrdg  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ympaatak  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ympasufc  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymgawory  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymgahdac  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymgapain  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ymgatnse  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ymphanml  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymphhigh  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymphdark  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymphnedl  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymphblod  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymphbrdg  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymphelev  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymoccoun  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymocwash  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymocchck  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymocgerm  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymocthot  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymeathin  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymeafat   1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymeathfd  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymeabing  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymelwtbd  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymelwtpt  1='(1) Yes' 2='(2) No' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymelsoil  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE ymmdnint  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymmdlseg  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymmdnogd  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymmdthkl  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymmdtykl  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymmdtird  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymmdthnk  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymmabdmd  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymmarsls  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymmatalk  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymmaspab  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymmamdrc  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymadconc  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymadfrgt  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymadfcus  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymadmeds  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymadavat  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymaderro  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymodhurt  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymodrfus  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymodanoy  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymodmean  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymodblmo  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymodtany  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymodswor  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymcdexpl  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymcdshpl  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymcdlied  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymcdsnat  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymcdvand  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymcdstol  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymcdcrua  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE ymcdbknt  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yuhospyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yuhospnf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE yuhosuic  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yuhodepr  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yuhofear  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yuhobkru  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yuhoeatp  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yuhosor   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yursidyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yursidnf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE yurssuic  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yursdepr  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yursfear  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yursbkru  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yurseatp  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yurssor   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yufcaryr  1='(1) Yes' 2='(2) No' 4='(4) No LOGICALLY ASSIGNED' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yufcarnf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE yufcsuic  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yufcdepr  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yufcfear  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yufcbkru  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yufceatp  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yufcsor   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yudytxyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yudytxnf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE yudysuic  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yudydepr  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yudyfear  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yudybkru  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yudyeatp  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yudysor   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yumhcryr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yumhcrnf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE yumhsuic  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yumhdepr  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yumhfear  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yumhbkru  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yumheatp  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yumhsor   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yutpstyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yutpstnf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE yutpsuic  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yutpdepr  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yutpfear  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yutpbkru  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yutpeatp  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yutpsor   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yuihtpyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yuihtpnf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE yuihsuic  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yuihdepr  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yuihfear  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yuihbkru  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yuiheatp  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yuihsor   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yufdocyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yufdocnf  31='(31) 31 or more' 994='(994) DON''T KNOW' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE yufdsuic  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yufddepr  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yufdfear  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yufdbkru  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yufdeatp  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yufdsor   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yuspedyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yushcnyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yushsuic  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yushdepr  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yushfear  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yushbkru  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yusheatp  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yushsor   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE yujailev  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE yufcarev  1='(1) Yes' 2='(2) No'
                  5='(5) Yes LOGICALLY ASSIGNED (from skip pattern)'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE irhhsizf  1='(1) One person in household' 2='(2) Two people in household'
                  3='(3) Three people in household' 4='(4) Four people in household'
                  5='(5) Five people in household'
                  6='(6) 6 to 25 people in household' ;
  VALUE iihhsizf  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irhh65_f  1='(1) No people 65 or older in household'
                  2='(2) One person 65 or older in household'
                  3='(3) Two or more people 65 or older in household' ;
  VALUE iihh65_f  1='(1) Questionnaire data' 2='(2) Logically imputed data'
                  3='(3) Statistically imputed data' ;
  VALUE irki17_f  1='(1) No children under 18' 2='(2) One child under 18'
                  3='(3) Two children under 18'
                  4='(4) Three or more children under 18' ;
  VALUE iiki17_f  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE imother   1='(1) R is 12-17, mother in hh'
                  2='(2) R is 12-17, no mother in hh'
                  3='(3) R is 12-17, don''t know whether mother is in hh'
                  4='(4) R is 18 or older' ;
  VALUE ifather   1='(1) R is 12-17, father in hh'
                  2='(2) R is 12-17, no father in hh'
                  3='(3) R is 12-17, don''t know whether father is in hh'
                  4='(4) R is 18 or older' ;
  VALUE nrch17_f  -9='Missing' 3='(3) 3 or more' ;
  VALUE pregnant  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE nmertmtf  31='(31) 31 or more' 985='(985) BAD DATA Logically assigned'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE inhospyr  1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE nmngthsf  31='(31) 31 or more' 985='(985) BAD DATA Logically assigned'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE proxansf  1='(1) Yes' 2='(2) No' 7='(7) Unclear LOGICALLY ASSIGNED'
                  89='(89) LEGITIMATE SKIP Logically assigned' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP (Respondent answering)' ;
  VALUE preg      0='(0) Otherwise' 1='(1) Pregnant Females Aged 12-44 (PREGNANT=1)' ;
  VALUE preg2fff  -9='Unknown (PREGNANT = 94,97,98)'
                  1='(1) Pregnant (PREGNANT=1)' 2='(2) Not Pregnant (PREGNANT=2)'
                  3='(3) Males/Females not age 12-44 (PREGNANT=99)' ;
  VALUE trimest   -9='Unknown' 1='(1) 1st 3 months of pregnancy'
                  2='(2) 2nd 3 months of pregnancy'
                  3='(3) Last 3 months of pregnancy'
                  4='(4) Males/Not Pregnant Females' ;
  VALUE irpsoc    1='(1) Yes' 2='(2) No' ;
  VALUE iipsoc    1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irfamsoc  1='(1) Yes' 2='(2) No' ;
  VALUE iifamsoc  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irpssi    1='(1) Yes' 2='(2) No' ;
  VALUE iipssi    1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irfamssi  1='(1) Yes' 2='(2) No' ;
  VALUE iifamssi  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irfstamp  1='(1) Yes' 2='(2) No' ;
  VALUE iifstamp  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irppmt    1='(1) Yes' 2='(2) No' ;
  VALUE iippmt    1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irfampmt  1='(1) Yes' 2='(2) No' ;
  VALUE iifampmt  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irpsvc    1='(1) Yes' 2='(2) No' ;
  VALUE iipsvc    1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irfamsvc  1='(1) Yes' 2='(2) No' ;
  VALUE iifamsvc  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irwelmos  99='(99) LEGITIMATE SKIP' ;
  VALUE iiwelmos  1='(1) Questionnaire data' 3='(3) Statistically imputed data'
                  9='(9) Legitimate skip' ;
  VALUE irpint    1='(1) Yes' 2='(2) No' ;
  VALUE iipint    1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irfamint  1='(1) Yes' 2='(2) No' ;
  VALUE iifamint  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irpchd    1='(1) Yes' 2='(2) No' ;
  VALUE iipchd    1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irfamchd  1='(1) Yes' 2='(2) No' ;
  VALUE iifamchd  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irpwag    1='(1) Yes' 2='(2) No' ;
  VALUE iipwag    1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irfamwag  1='(1) Yes' 2='(2) No' ;
  VALUE iifamwag  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irpoth    1='(1) Yes' 2='(2) No' ;
  VALUE iipoth    1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irfamoth  1='(1) Yes' 2='(2) No' ;
  VALUE iifamoth  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irpinc3f  1='(1) $0 - $9,999 (Including Loss)' 2='(2) $10,000 - $19,999'
                  3='(3) $20,000 - $29,999' 4='(4) $30,000 - $39,999'
                  5='(5) $40,000 - $49,999' 6='(6) $50,000 - $74,999'
                  7='(7) $75,000 or more' ;
  VALUE iipinc3f  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irfaminf  1='(1) $0 - $9,999 (Including Loss)' 2='(2) $10,000 - $19,999'
                  3='(3) $20,000 - $29,999' 4='(4) $30,000 - $39,999'
                  5='(5) $40,000 - $49,999' 6='(6) $50,000 - $74,999'
                  7='(7) $75,000 or more' ;
  VALUE iifaminf  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE govtprog  1='(1) YES (ANY SOURCE VARIABLE=1)'
                  2='(2) NO (ALL SOURCE VARIABLES=2)' ;
  VALUE hlcallfg  1='(1) Answered yes to all current health insurance Qs'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE hlcall9f  1='(1) Yes' 98='(98) BLANK (NO ANSWER)' ;
  VALUE medicare  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE medicaid  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE champus   1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE ogovtins  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE ogovinsf  1='(1) Medicare' 2='(2) Medicaid or Medical Assistance'
                  3='(3) Military Health Care (CHAMPUS, TRICARE, VA)'
                  4='(4) State AIDS Drug Assistance Program'
                  5='(5) SCHIP (State Children''s Health Insurance Plan)'
                  6='(6) Public Health Service/Indian health hospital/clinc'
                  7='(7) Temp Assistance for Needy Families; formerly AFDC'
                  8='(8) State govt prgm; Chronically Ill/Disabled Children'
                  9='(9) State govt program; prescription assistance'
                  11='(11) Migrant/community/rural health center'
                  12='(12) Local/state hlth dept;social/human servcs; unspcfd'
                  13='(13) School/college/univ health services; govt unspecfd'
                  15='(15) WIC/Suppl Nutrition Prgm Women, Infants,& Children'
                  16='(16) Sliding scale/subsidized health care; unspecified'
                  17='(17) Non-Medicaid state govt low-income health assistnc'
                  19='(19) Social Security; type unspecified'
                  20='(20) Workman''s Compensation'
                  21='(21) Welfare/social welfare; not otherwise specified'
                  22='(22) State Health program; type unspecified'
                  23='(23) Other gov''t coverage, not classified elsewhere'
                  60='(60) Private ins provider; govt affiliation unspecified'
                  61='(61) Civilian govt employee private health insurance'
                  62='(62) Health care coverage outside of the US'
                  63='(63) Medical/health care/wellness coverage; unspecified'
                  65='(65) Private, not-for-profit foundation'
                  70='(70) Non-health care insurance coverage'
                  72='(72) Supplemental Social Income (SSI)'
                  73='(73) Other non-gov''t insurance/not a type of insurance'
                  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP (OGOVTINS=2)' ;
  VALUE prvhltin  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE grphltin  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP (PRVHLTIN = 2)' ;
  VALUE hltinalc  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP (PRVHLTIN = 2)' ;
  VALUE hltindrg  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP (PRVHLTIN = 2)' ;
  VALUE hltinmnt  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP (PRVHLTIN = 2)' ;
  VALUE othltins  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE othlinsf  1='(1) Medicare' 2='(2) Medicaid or Medical Assistance'
                  3='(3) Military Health Care (CHAMPUS, TRICARE, VA)'
                  4='(4) Private health insurance'
                  5='(5) Public Health Service/Indian health hospital/clinc'
                  6='(6) Health care coverage outside of USA'
                  7='(7) School/sport-related health care coverage'
                  8='(8) Non-government medical assistance'
                  9='(9) Temp Assistance for Needy Families; formerly AFDC'
                  10='(10) Dental/vision/prescription/chiro/alt med insurance'
                  13='(13) Cancer/heart insurance coverage'
                  14='(14) Long term/nursing home care insurance'
                  15='(15) Hospitalization/catastrophic/major illness insurnc'
                  17='(17) Local/state hlth dept;social.human servcs; unspcfd'
                  18='(18) Medical/insurance; type unspecified'
                  19='(19) SCHIP (State Children''s Health Insurance Plan)'
                  20='(20) Family member coverage; type unspecified'
                  21='(21) Secondary/supplemental insurance; private unspecfd'
                  22='(22) Employee Assistance Program'
                  23='(23) State health program; type unspecified'
                  25='(25) Sliding scale/subsidized health care; unspecified'
                  30='(30) Foreign exchange student program insurance'
                  31='(31) Accident/injury insurance'
                  32='(32) Other health insurance, not classified elsewhere'
                  50='(50) All types/combined/other; hlth ins coverage unspcd'
                  60='(60) Non-health care insurance/coverage'
                  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP (OTHLTINS=2)' ;
  VALUE hlcnotyr  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hlcnotmo  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE hlclast   1='(1) Within the past 6 months'
                  2='(2) More than 6 months ago, but within the past year'
                  3='(3) More than 1 year ago, but within the past 3 years'
                  4='(4) More than 3 years ago' 5='(5) Never had coverage'
                  11='(11) Within the past 6 months (see NOTE)'
                  12='(12) More than 6 mos ago but w/in pst yr (see NOTE)'
                  13='(13) More than 1 yr ago but w/in pst 3 yr (see NOTE)'
                  14='(14) More than 3 years ago (see NOTE)'
                  15='(15) Never had coverage (see NOTE)' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hlcprivt  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hlcmcaid  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hlcmilt   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE hlcmcare  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hlcogovt  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hlcother  1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE hlcothsf  1='(1) Private health insurance'
                  2='(2) Medicaid or medical assistance' 4='(4) Medicare'
                  5='(5) Some other government program'
                  6='(6) Some other kind of coverage'
                  8='(8) Health care coverage outside of USA'
                  9='(9) School/sport-related health care coverage'
                  11='(11) Medical, type unspecified' 14='(14) Workman''s compensation'
                  60='(60) Paid out of pocket'
                  61='(61) Does not have medical insurance'
                  90='(90) NEVER HAD HEALTH CARE COVERAGE'
                  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE hlllosjb  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hllmajob  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  11='(11) Response entered (potl incons w/last coverage)'
                  13='(13) Response entered LOG ASSN (potl incons)'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE hllmasor  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered'
                  11='(11) Response entered (potl incons w/last coverage)'
                  13='(13) Response entered LOG ASSN (potl incons)'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE hllcost   1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hllinelg  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hllnoffr  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hlldivor  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hlldeath  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hllrefus  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hllnoned  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hllsor    1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE hllsorsf  1='(1) Person in family w/ ins lost job/chngd employers'
                  2='(2) Lost Medicaid or med assist cov b/c new job/income'
                  3='(3) Lost Medicaid or med assist cov for other reason'
                  4='(4) Cost is too high/can''t afford premiums'
                  5='(5) Became ineligible b/c of age or leaving school'
                  6='(6) Employer doesn''t offer cov/not eligible for cov'
                  7='(7) Got divorced or separated from person w/ ins'
                  8='(8) Death of spouse or parent'
                  9='(9) Insurance company refused coverage' 10='(10) Don''t need it'
                  11='(11) Some other reason'
                  12='(12) Have not applied or reapplied for ins coverage'
                  13='(13) Applied ins/Medicaid,waiting for activation/eligib'
                  14='(14) Ineligible b/c moved out of parents home/got marri'
                  15='(15) Don''t know how to obtain/trying to obtain'
                  16='(16) Non-us citizen'
                  19='(19) Self-employed/parents self-employed'
                  20='(20) Dissatisfied with previous/available coverage'
                  22='(22) Had ins in another country before moving to US'
                  23='(23) Moved/don''t have same coverage'
                  24='(24) Parents/guardians got divorced/separated'
                  25='(25) Don''t qualify, no reason specified'
                  26='(26) Dropped coverage, no reason specified'
                  28='(28) Don''t qualify for partner''s/family member''s policy'
                  32='(32) Ineligible, some other reason'
                  35='(35) Too complicated to get health insurance coverage'
                  39='(39) Employer/respondent is changing insurance plans'
                  41='(41) Parent/guardian doesn''t/won''t provide coverage'
                  42='(42) Ins co didn''t receive payment/paperwork in time'
                  44='(44) Student/becoming stdnt(elg for oth cov unk)'
                  45='(45) Ineligible because part-time student'
                  90='(90) CURRENTLY COVERED BY HEALTH INSURANCE'
                  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE hlnvcost  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hlnvoffr  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hlnvref   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE hlnvneed  1='(1) Response entered'
                  3='(3) Response entered LOGICALLY ASSIGNED'
                  6='(6) Response not entered' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hlnvsor   1='(1) Response entered' 6='(6) Response not entered'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE hlnvsp2f  1='(1) Cost is too high/can''t afford premiums'
                  2='(2) Employer doesn''t offer cov/not eligible for cov'
                  4='(4) Don''t need it' 5='(5) Some other reason'
                  7='(7) Have never applied for/thought about ins covrg'
                  8='(8) Religious beliefs/don''t trust medical prof/ins co'
                  9='(9) Didn''t know available or how to obtain ins'
                  10='(10) Currently looking for insurance coverage'
                  12='(12) Non-US citizen' 14='(14) Prefer to pay cash'
                  15='(15) Never had insurance, no reason specified'
                  16='(16) Parent/guardian don''t/won''t provide coverage'
                  17='(17) Ineligible, other reasons'
                  90='(90) CURRENTLY COVERED BY HEALTH INSURANCE'
                  91='(91) ASSISTANCE PROVIDED BY CHURCH/COMMUNITY'
                  92='(92) HAVE BEEN COVERED BY HEALTH INSURANCE IN PAST'
                  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE irpinsur  1='(1) Yes, respondent does have private health insurance'
                  2='(2) No, respondent does not have private health insur' ;
  VALUE iipinsur  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irinsur   1='(1) Yes, respondent does have health insurance'
                  2='(2) No, respondent does not have health insurance' ;
  VALUE iiinsur   1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE irinsurf  1='(1) Yes, respondent does have health insurance'
                  2='(2) No, respondent does not have health insurance' ;
  VALUE iiinsurf  1='(1) Questionnaire data' 3='(3) Statistically imputed data' ;
  VALUE langver   1='(1) English' 2='(2) Spanish' 98='(98) BLANK (NO ANSWER)' ;
  VALUE quarter   1='(1) Quarter 1' 2='(2) Quarter 2' 3='(3) Quarter 3' 4='(4) Quarter 4' ;
  VALUE gqtype    -9='Not a Group Quarter' 1='(1) Halfway House'
                  2='(2) Boarding House' 3='(3) College Dorm' 4='(4) Shelter' 5='(5) Other' ;
  VALUE age2ffff  1='(1) Respondent is 12 years old'
                  2='(2) Respondent is 13 years old'
                  3='(3) Respondent is 14 years old'
                  4='(4) Respondent is 15 years old'
                  5='(5) Respondent is 16 years old'
                  6='(6) Respondent is 17 years old'
                  7='(7) Respondent is 18 years old'
                  8='(8) Respondent is 19 years old'
                  9='(9) Respondent is 20 years old'
                  10='(10) Respondent is 21 years old'
                  11='(11) Respondent is 22 or 23 years old'
                  12='(12) Respondent is 24 or 25 years old'
                  13='(13) Respondent is between 26 and 29 years old'
                  14='(14) Respondent is between 30 and 34 years old'
                  15='(15) Respondent is between 35 and 49 years old'
                  16='(16) Respondent is between 50 and 64 years old'
                  17='(17) Respondent is 65 years old or older' ;
  VALUE nomarr2f  1='(1) One time' 2='(2) Two or more times' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE service   1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE milstat   2='(2) In a reserves component'
                  3='(3) Now separated/retired from reserves/active duty'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 99='(99) LEGITIMATE SKIP' ;
  VALUE health    1='(1) Excellent' 2='(2) Very good' 3='(3) Good' 4='(4) Fair' 5='(5) Poor'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' ;
  VALUE irsex     1='(1) Male' 2='(2) Female' ;
  VALUE iisex     1='(1) Sex from questionnaire' 2='(2) Sex from screener' ;
  VALUE irmarit   1='(1) Married' 2='(2) Widowed' 3='(3) Divorced or Separated'
                  4='(4) Never Been Married'
                  99='(99) LEGITIMATE SKIP Respondent is <= 14 years old' ;
  VALUE iimarit   1='(1) Marital status from questionnaire'
                  3='(3) Marital status statistically imputed'
                  9='(9) LEGITIMATE SKIP Respondent is <= 14 years old' ;
  VALUE ireduc2f  1='(1) Fifth grade or less' 2='(2) Sixth grade' 3='(3) Seventh grade'
                  4='(4) Eighth grade' 5='(5) Ninth grade' 6='(6) Tenth grade'
                  7='(7) Eleventh grade' 8='(8) Twelfth grade' 9='(9) Freshman/13th year'
                  10='(10) Sophomore/14th year or Junior/15th year'
                  11='(11) Senior/16th year or GradProf School (or higher)' ;
  VALUE iieduc2f  1='(1) Education from questionnaire'
                  3='(3) Education statistically imputed' ;
  VALUE empstatf  1='(1) Employed full time' 2='(2) Employed part time'
                  3='(3) Unemployed' 4='(4) Other' 5='(5) 12-17 year olds' ;
  VALUE iiempstf  1='(1) Employment status from questionnaire'
                  3='(3) Employment statistically imputed' 4='(4) 12-17 years old' ;
  VALUE empstaty  1='(1) Employed full time' 2='(2) Employed part time'
                  3='(3) Unemployed' 4='(4) Other (incl. not in labor force)'
                  5='(5) 12-14 year olds' ;
  VALUE iiempsty  1='(1) Employment status from questionnaire'
                  3='(3) Employment statistically imputed' 4='(4) 12-14 years old' ;
  VALUE empsta0f  1='(1) Employed full time' 2='(2) Employed part time'
                  3='(3) Unemployed' 4='(4) Other (incl. not in labor force)'
                  5='(5) 12-17 year olds' ;
  VALUE iiemps0f  1='(1) Employment status from questionnaire'
                  3='(3) Employment statistically imputed' 4='(4) 12-17 years old' ;
  VALUE movespyf  0='(0) None' 1='(1) One time' 2='(2) Two times' 3='(3) Three or more times'
                  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' ;
  VALUE enroled   1='(1) Yes' 2='(2) No'
                  3='(3) Yes LOGICALLY ASSIGNED (LFSCHWH2=777,778)'
                  5='(5) Yes LOGICALLY ASSIGNED (LFSCHWH2=601)'
                  11='(11) Yes (SCHDSKIP = 30)'
                  52='(52) Summer interview (not enrolled & HSDIPLMA=4)'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE educnowf  1='(1) 5th Grade or lower' 2='(2) 6th Grade' 3='(3) 7th Grade'
                  4='(4) 8th Grade' 5='(5) 9th Grade' 6='(6) 10th Grade' 7='(7) 11th Grade'
                  8='(8) 12th Grade' 9='(9) College or university/1st year'
                  10='(10) College or university/2nd Year, 3rd year'
                  11='(11) College or university/4th Year, 5th or higher year'
                  12='(12) Missing' 13='(13) LEGITIMATE SKIP' ;
  VALUE studnt    1='(1) FULL-TIME' 2='(2) PART-TIME' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE schdsick  0='(0) None' 85='(85) BAD DATA Logically assigned'
                  90='(90) SCHOOL NOT IN SESSION' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE schdskip  0='(0) None' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hsdiplma  1='(1) Yes' 2='(2) No' 3='(3) Yes LOG ASSN' 4='(4) No LOGICALLY ASSIGNED'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE hsged     1='(1) Yes' 2='(2) No' 3='(3) Yes LOG ASSN (LFSCHWH2=606)'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE lfschwhf  1='(1) School was boring or I didn''t want to be there'
                  2='(2) I got pregnant'
                  3='(3) I got in trouble or expelled for selling drugs'
                  4='(4) I got in trouble or expelled for using drugs'
                  5='(5) I got in trouble or expelled for some other reason'
                  6='(6) I often got into trouble'
                  7='(7) I had to get a job (or work more hours)'
                  8='(8) I was getting bad grades'
                  9='(9) I wasn''t learning anything'
                  10='(10) I got married (or moved in with my boy/girlfriend)'
                  11='(11) I moved here from another country/didn''t enroll'
                  12='(12) I was treated badly at school'
                  13='(13) I became ill (or injured)' 14='(14) I went to jail/prison'
                  15='(15) I had responsibilities at home/personal problems'
                  16='(16) Other reason' 41='(41) Family member became ill/sick/died'
                  42='(42) I wasn''t admitted/couldn''t attend school of choice'
                  43='(43) Parents/guardian/partner wouldn''t allow me to'
                  44='(44) Ran away from/put out of/placed out of home'
                  45='(45) Too stressful/couldn''t adjust' 46='(46) Learning disabled'
                  50='(50) Moved away/didn''t re-enroll'
                  51='(51) Skipping school/excessive absenteeism'
                  52='(52) Too expensive/couldn''t afford'
                  54='(54) No transportation/school too far away'
                  56='(56) Grade,credit discrepancies/lacked credits/document'
                  58='(58) All the schooling/preferred that was available'
                  59='(59) Wasn''t required/didn''t have to/not needed/customs'
                  60='(60) Against my religion/beliefs' 63='(63) I was stupid/foolish'
                  66='(66) Too old' 67='(67) Wanted to work/do apprenticeship instead'
                  69='(69) Just quit; reason unspecified'
                  71='(71) Didn''t pass/take end of grade/school test'
                  73='(73) Held back/school didn''t think I was capable'
                  601='(601) Home schooled'
                  602='(602) Went to technical school/community college'
                  605='(605) Completed HS/certificate, general' 606='(606) Received GED'
                  607='(607) Pursuing GED/proficiency exam/re-enrolling'
                  777='(777) Summer/school not in session'
                  778='(778) I am still in school'
                  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE lftschaf  10='(10) Left at age 10 or younger' 19='(19) Left at age 19 or older'
                  985='(985) BAD DATA Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE rlgsvcyr  1='(1) 0 times' 2='(2) 1 to 2 times' 3='(3) 3 to 5 times'
                  4='(4) 6 to 24 times' 5='(5) 25 to 52 times' 6='(6) More than 52 times'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE rlgimprt  1='(1) Strongly disagree' 2='(2) Disagree' 3='(3) Agree'
                  4='(4) Strongly agree' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rlgdecsn  1='(1) Strongly disagree' 2='(2) Disagree' 3='(3) Agree'
                  4='(4) Strongly agree' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE rlgfrnds  1='(1) Strongly disagree' 2='(2) Disagree' 3='(3) Agree'
                  4='(4) Strongly agree' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' ;
  VALUE telno2ff  0='(0) None' 1='(1) One' 2='(2) Two or more' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' ;
  VALUE tuchtone  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE collegef  -9='Unknwn Enrollment, Aged 18-22(ENROLED=94,97,98)'
                  1='(1) Full-Time College Student Aged 18-22'
                  2='(2) Part-Time College Student Aged 18-22'
                  3='(3) Not Enrolled (ENROLED=2)' 4='(4) Others Persons Aged 18-22'
                  5='(5) Persons Aged 12-17, or 23 or Older' ;
  VALUE catage    1='(1) 12-17 Years Old' 2='(2) 18-25 Years Old' 3='(3) 26-34 Years Old'
                  4='(4) 35 or Older' ;
  VALUE catag2ff  1='(1) 12-17 Years Old' 2='(2) 18-25 Years Old' 3='(3) 26 or Older' ;
  VALUE catag3ff  1='(1) 12-17 Years Old' 2='(2) 18-25 Years Old' 3='(3) 26-34 Years Old'
                  4='(4) 35-49 Years Old' 5='(5) 50 or Older' ;
  VALUE catag7ff  1='(1) 12-13 Years Old' 2='(2) 14-15 Years Old' 3='(3) 16-17 Years Old'
                  4='(4) 18-20 Years Old' 5='(5) 21-25 Years Old' 6='(6) 26-34 Years Old'
                  7='(7) 35 or Older' ;
  VALUE newracef  1='(1) NonHisp White' 2='(2) NonHisp Black/Afr Am'
                  3='(3) NonHisp Native Am/AK Native'
                  4='(4) NonHisp Native HI/Other Pac Isl' 5='(5) NonHisp Asian'
                  6='(6) NonHisp more than one race' 7='(7) Hispanic' ;
  VALUE educcatf  1='(1) Less than high school' 2='(2) High school graduate'
                  3='(3) Some college' 4='(4) College graduate'
                  5='(5) 12 to 17 year olds (1<=AGE2<=6)' ;
  VALUE jobstatf  1='(1) Worked at full-time job, past week'
                  2='(2) Worked at part time job, past week'
                  3='(3) Has job or volunteer worker, did not work past wk'
                  4='(4) Unemployed/on layoff, looking for work' 5='(5) Disabled'
                  6='(6) Keeping house full-time' 7='(7) In school/training'
                  8='(8) Retired' 9='(9) Does not have a job, some other reason'
                  10='(10) MISSING' 11='(11) LEGITIMATE SKIP' ;
  VALUE jbstatrf  1='(1) Worked at full-time job, past week'
                  2='(2) Worked at part time job, past week'
                  3='(3) Has job or volunteer worker, did not work past wk'
                  4='(4) Unemployed/on layoff, looking for work' 5='(5) Disabled'
                  6='(6) Keeping house full-time' 7='(7) In school/training'
                  8='(8) Retired' 9='(9) Does not have a job, some other reason'
                  10='(10) MISSING' 11='(11) LEGITIMATE SKIP' ;
  VALUE wrkhavjb  1='(1) Yes' 2='(2) No' 89='(89) LEGITIMATE SKIP Logically assigned'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE wrkhrswk  994='(994) DON''T KNOW' 997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)'
                  999='(999) LEGITIMATE SKIP' ;
  VALUE wrkinduf  1='(1) Agriculture, Forestry, and Fisheries' 2='(2) Mining'
                  3='(3) Construction' 4='(4) Manufacturing - Nondurable Goods'
                  5='(5) Manufacturing - Durable Goods'
                  6='(6) Trans/Commun/and Other Public Utilities'
                  7='(7) Wholesale Trade - Durable Goods'
                  8='(8) Wholesale Trade - Nondurable Goods' 9='(9) Retail Trade'
                  10='(10) Finance, Insurance, and Real Estate'
                  11='(11) Business and Repair Services' 12='(12) Personal Services'
                  13='(13) Entertainment and Recreation Services'
                  14='(14) Professional and Related Services'
                  15='(15) Public Administration' 16='(16) Military Duty'
                  985='(985) BAD DATA Logically assigned'
                  992='(992) Last worked 1984 or earlier' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE wrkoccuf  1='(1) Executive/Administrative/Managerial Occupations'
                  2='(2) Professional Specialty Occupations'
                  3='(3) Technicians and Related Support Occupations'
                  4='(4) Sales Occupations'
                  5='(5) Administrative Support Occupations, Inc Clerical'
                  6='(6) Private Household Occupations'
                  7='(7) Protective Service Occupations'
                  8='(8) Service Occups, Except Protective/Private Househol'
                  9='(9) Farming, Forestry, and Fishing occupations'
                  10='(10) Mechanics and repairers' 11='(11) Construction trades'
                  12='(12) Extractive Occupations'
                  13='(13) Machine Operators, Assemblers, and Inspectors'
                  14='(14) Transportation and Material Moving Occupations'
                  15='(15) Handlers/Equipment Cleaners/Helpers/Laborers'
                  16='(16) Military' 909='(909) Last worked 1984 or earlier'
                  985='(985) BAD DATA Logically assigned' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE wrkbzcaf  1='(1) Private for-profit company or business'
                  2='(2) Private not-for-profit company or business'
                  3='(3) Local government (city, county, etc.)'
                  4='(4) State government'
                  5='(5) Federal/Foreign government or international'
                  6='(6) Self-employed in an incorporated business'
                  7='(7) Self-employed in an unincorporated business'
                  8='(8) Working without pay in a family business/farm'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE wrkeffrt  1='(1) Yes' 2='(2) No' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE wrkedyr   1='(1) Yes' 2='(2) No' 85='(85) BAD DATA Logically assigned'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE wrkslfem  1='(1) Yes' 2='(2) No'
                  3='(3) Yes LOGICALLY ASSIGNED (raw var not blank)'
                  5='(5) Yes LOGICALLY ASSIGNED (from skip pattern)'
                  89='(89) LEGITIMATE SKIP Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE wrkjobsf  1='(1) One' 2='(2) Two' 3='(3) Three' 4='(4) Four or more'
                  975='(975) At least one LOGICALLY ASSIGNED'
                  989='(989) LEGITIMATE SKIP Logically assigned' 994='(994) DON''T KNOW'
                  997='(997) REFUSED' 998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE wrkunemp  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE wrkunwks  85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE wrklasyf  1960='(1960) 1960 or earlier' 9985='(9985) BAD DATA Logically assigned'
                  9989='(9989) LEGITIMATE SKIP Logically assigned'
                  9991='(9991) NEVER WORKED FOR PAY' 9994='(9994) DON''T KNOW'
                  9997='(9997) REFUSED' 9998='(9998) BLANK (NO ANSWER)'
                  9999='(9999) LEGITIMATE SKIP' ;
  VALUE wrkindyf  1='(1) Agriculture, Forestry, and Fisheries' 2='(2) Mining'
                  3='(3) Construction' 4='(4) Manufacturing - Nondurable Goods'
                  5='(5) Manufacturing - Durable Goods'
                  6='(6) Trans/Commun/and Other Public Utilities'
                  7='(7) Wholesale Trade - Durable Goods'
                  8='(8) Wholesale Trade - Nondurable Goods' 9='(9) Retail Trade'
                  10='(10) Finance, Insurance, and Real Estate'
                  11='(11) Business and Repair Services' 12='(12) Personal Services'
                  13='(13) Entertainment and Recreation Services'
                  14='(14) Professional and Related Services'
                  15='(15) Public Administration' 16='(16) Military Duty'
                  985='(985) BAD DATA Logically assigned'
                  989='(989) LEGITIMATE SKIP Logically assigned'
                  992='(992) Last worked 1984 or earlier' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE wrkoccyf  1='(1) Executive/Administrative/Managerial Occupations'
                  2='(2) Professional Specialty Occupations'
                  3='(3) Technicians and Related Support Occupations'
                  4='(4) Sales Occupations'
                  5='(5) Administrative Support Occupations, Inc Clerical'
                  6='(6) Private Household Occupations'
                  7='(7) Protective Service Occupations'
                  8='(8) Service Occups, Except Protective/Private Househol'
                  9='(9) Farming, Forestry, and Fishing occupations'
                  10='(10) Mechanics and repairers' 11='(11) Construction trades'
                  12='(12) Extractive Occupations'
                  13='(13) Machine Operators, Assemblers, and Inspectors'
                  14='(14) Transportation and Material Moving Occupations'
                  15='(15) Handlers/Equipment Cleaners/Helpers/Laborers'
                  16='(16) Military' 909='(909) Last worked 1984 or earlier'
                  985='(985) BAD DATA Logically assigned'
                  989='(989) LEGITIMATE SKIP Logically assigned' 997='(997) REFUSED'
                  998='(998) BLANK (NO ANSWER)' 999='(999) LEGITIMATE SKIP' ;
  VALUE workdays  0='(0) None' 85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE workblah  0='(0) None' 85='(85) BAD DATA Logically assigned' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE locsize   1='(1) Less than 10 people' 2='(2) 10-24 people' 3='(3) 25-99 people'
                  4='(4) 100-499 people' 5='(5) 500 people or more' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE drgplcy   1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE plcycov   1='(1) Only alcohol' 2='(2) Only drugs' 3='(3) Both alcohol and drugs'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE wkdrged   1='(1) Yes' 2='(2) No' 3='(3) Don''t remember' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE drgprgm   1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE usalctst  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE usdrgtst  1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE tsthire   1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE tstrand   1='(1) Yes' 2='(2) No' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE firstpos  1='(1) Handled on indiv basis/policy does not spec what'
                  2='(2) Employee is fired'
                  3='(3) Employee is referred for treatment or counseling'
                  4='(4) Nothing happens' 5='(5) Something else happens'
                  94='(94) DON''T KNOW' 97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)'
                  99='(99) LEGITIMATE SKIP' ;
  VALUE wrkhire   1='(1) More likely' 2='(2) Less likely'
                  3='(3) Would it make no difference to you' 94='(94) DON''T KNOW'
                  97='(97) REFUSED' 98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE workrand  1='(1) More likely' 2='(2) Less likely'
                  3='(3) Would make no difference' 94='(94) DON''T KNOW' 97='(97) REFUSED'
                  98='(98) BLANK (NO ANSWER)' 99='(99) LEGITIMATE SKIP' ;
  VALUE fiexp99f  1='(1) Yes' 2='(2) No' ;
  VALUE pden      1='(1) Segment in a MSA with 1 million or more persons'
                  2='(2) Segment in a MSA with fewer than 1 million persons'
                  3='(3) Segment not in a MSA' ;
*/


* SAS DATA, INFILE, INPUT STATEMENTS;

DATA;
INFILE "data-filename" LRECL=4074;
INPUT
        CASEID 1-5              QUESTID 6-12            CIGEVER 13-14
        CIGOFRSM 15-16          CIGWILYR 17-18          CIGTRY 19-21
        CIGYFU 22-25            CIGMFU 26-27            CIGREC 28-29
        CIG30USE 30-31          CG30EST 32-33           CIG30AV 34-35
        CIG30BR2 36-39          CIG30TYP 40-41          CIG30MEN 42-43
        CIG30RO2 44-45          CIGDLYMO 46-47          CIGAGE 48-50
        CIG100LF 51-52          CHEWEVER 53-54          CHEWTRY 55-57
        CHEWYFU 58-61           CHEWMFU 62-63           CHEWREC 64-65
        CHW30USE 66-67          CH30EST 68-69           CHW30BR2 70-73
        SNFEVER 74-75           SNUFTRY 76-78           SNUFYFU 79-82
        SNUFMFU 83-84           SNFREC 85-86            SNF30USE 87-88
        SN30EST 89-90           SNF30BR2 91-94          SLTTRY 95-97
        SLTYFU 98-101           SLTMFU 102-103          SLTREC 104-105
        SLT30BR2 106-109        SLT30FAV 110-111        CIGAREVR 112-113
        CIGARTRY 114-116        CIGARYFU 117-120        CIGARMFU 121-122
        CIGARREC 123-124        CGR30USE 125-126        CI30EST 127-128
        CGR30BR2 129-132        PIPEVER 133-134         PIPE30DY 135-136
        ALCEVER 137-138         ALCTRY 139-141          ALCYFU 142-145
        ALCMFU 146-147          ALCREC 148-149          ALCYRTOT 150-152
        ALTOTFG 153-154         ALFQFLG 155-156         ALBSTWAY 157-158
        ALDAYPYR 159-161        ALDAYPMO 162-163        ALDAYPWK 164-165
        ALCDAYS 166-167         AL30EST 168-169         ALDYSFG 170-171
        NODR30A 172-174         DR5DAY 175-176          MJEVER 177-178
        MJAGE 179-181           MJYFU 182-185           MJMFU 186-187
        MJREC 188-189           MJYRTOT 190-192         MRTOTFG 193-194
        MJFQFLG 195-196         MRBSTWAY 197-198        MRDAYPYR 199-201
        MRDAYPMO 202-203        MRDAYPWK 204-205        MJDAY30A 206-207
        MR30EST 208-209         COCEVER 210-211         COCAGE 212-214
        COCYFU 215-218          COCMFU 219-220          COCREC 221-222
        COCYRTOT 223-225        CCTOTFG 226-227         CCFQFLG 228-229
        CCBSTWAY 230-231        CCDAYPYR 232-234        CCDAYPMO 235-236
        CCDAYPWK 237-238        COCUS30A 239-240        CC30EST 241-242
        CRKEVER 243-244         CRKAGE 245-247          CRKYFU 248-251
        CRKMFU 252-253          CRAKREC 254-255         CRKYRTOT 256-258
        CRTOTFG 259-260         CRFQFLG 261-262         CRBSTWAY 263-264
        CRDAYPYR 265-267        CRDAYPMO 268-269        CRDAYPWK 270-271
        CRKUS30A 272-273        CR30EST 274-275         HEREVER 276-277
        HERAGE 278-280          HERYFU 281-284          HERMFU 285-286
        HERREC 287-288          HERYRTOT 289-291        HRTOTFG 292-293
        HRFQFLG 294-295         HRBSTWAY 296-297        HRDAYPYR 298-300
        HRDAYPMO 301-302        HRDAYPWK 303-304        HER30USE 305-306
        HR30EST 307-308         LSD 309-310             PCP 311-312
        PEYOTE 313-314          MESC 315-316            PSILCY 317-318
        ECSTASY 319-320         HALNOLST 321-322        HALNEWA 323-326
        HALNEWB 327-330         HALNEWC 331-334         HALNEWD 335-338
        HALNEWE 339-342         HALLAGE 343-345         HALYFU 346-349
        HALMFU 350-351          HALLREC 352-353         HALYRTOT 354-356
        HLTOTFG 357-358         HLFQFLG 359-360         HLBSTWAY 361-362
        HLDAYPYR 363-365        HLDAYPMO 366-367        HLDAYPWK 368-369
        HAL30USE 370-371        HL30EST 372-373         LSDAGE 374-376
        LSDYFU 377-380          LSDMFU 381-382          LSDREC 383-384
        PCPAGE 385-387          PCPYFU 388-391          PCPMFU 392-393
        PCPREC 394-395          AMYLNIT 396-397         CLEFLU 398-399
        GAS 400-401             GLUE 402-403            ETHER 404-405
        SOLVENT 406-407         LGAS 408-409            NITOXID 410-411
        SPPAINT 412-413         AEROS 414-415           INHNOLST 416-417
        INHNEWA 418-421         INHNEWB 422-425         INHNEWC 426-429
        INHNEWD 430-433         INHNEWE 434-437         INHAGE 438-440
        INHYFU 441-444          INHMFU 445-446          INHREC 447-448
        INHYRTOT 449-451        INTOTFG 452-453         INFQFLG 454-455
        INBSTWAY 456-457        INDAYPYR 458-460        INDAYPMO 461-462
        INDAYPWK 463-464        INHDY30A 465-466        IN30EST 467-468
        DARVTYLC 469-470        PERCTYLX 471-472        VICOLOR 473-474
        ANLCARD 475-476         CODEINE 477-478         DEMEROL 479-480
        DILAUD 481-482          FIORICET 483-484        FIORINAL 485-486
        HYDROCOD 487-488        METHDON 489-490         MORPHINE 491-492
        OXYCONTN 493-494        PHENCOD 495-496         PROPOXY 497-498
        SK65A 499-500           STADOL 501-502          TALACEN 503-504
        TALWIN 505-506          TALWINNX 507-508        TRAMADOL 509-510
        ULTRAM 511-512          ANLNOLST 513-514        ANALNEWA 515-518
        ANALNEWB 519-522        ANALNEWC 523-526        ANALNEWD 527-530
        ANALNEWE 531-534        ANALAGE 535-537         ANALYFU 538-541
        ANALMFU 542-543         ANALREC 544-545         ANLYRTOT 546-548
        PRTOTFG 549-550         PRFQFLG 551-552         PRBSTWAY 553-554
        PRDAYPYR 555-557        PRDAYPMO 558-559        PRDAYPWK 560-561
        KLONOPIN 562-563        XNAXATVN 564-565        VALMDIAZ 566-567
        TRNCARD 568-569         ATARAX 570-571          BUSPAR 572-573
        EQUANIL 574-575         FLEXERIL 576-577        LIBRIUM 578-579
        LIMBTROL 580-581        MEPROB 582-583          MILTOWN 584-585
        ROHYPNOL 586-587        SERAX 588-589           SOMA 590-591
        TRANXENE 592-593        VISTAR 594-595          TRNOLST 596-597
        TRNEWA 598-601          TRNEWB 602-605          TRNEWC 606-609
        TRNEWD 610-613          TRNEWE 614-617          TRANAGE 618-620
        TRANYFU 621-624         TRANMFU 625-626         TRANREC 627-628
        TRNYRTOT 629-631        TRTOTFG 632-633         TRFQFLG 634-635
        TRBSTWAY 636-637        TRDAYPYR 638-640        TRDAYPMO 641-642
        TRDAYPWK 643-644        METHDES 645-646         DIETPILS 647-648
        RITMPHEN 649-650        STMCARD 651-652         CYLERT 653-654
        DEXED 655-656           DETAMP 657-658          DIDREX 659-660
        ESKAT 661-662           IONAMIN 663-664         MAZANOR 665-666
        OBLA 667-668            PLEGINE 669-670         PRELUDIN 671-672
        SANOREX 673-674         TENUATE 675-676         STMNOLST 677-678
        STIMNEWA 679-682        STIMNEWB 683-686        STIMNEWC 687-690
        STIMNEWD 691-694        STIMNEWE 695-698        STIMAGE 699-701
        STIMYFU 702-705         STIMMFU 706-707         STIMREC 708-709
        STMYRTOT 710-712        STTOTFG 713-714         STFQFLG 715-716
        STBSTWAY 717-718        STDAYPYR 719-721        STDAYPMO 722-723
        STDAYPWK 724-725        METHAGE 726-728         METHYFU 729-732
        METHMFU 733-734         METHREC 735-736         METHAQ 737-738
        NEMBBARB 739-740        RESTTMAZ 741-742        SEDCARD 743-744
        AMYTAL 745-746          BUTISOL 747-748         CHHYD 749-750
        DALMANE 751-752         HALCION 753-754         PHENOBAR 755-756
        PLACIDYL 757-758        TUINAL 759-760          SEDNOLST 761-762
        SEDNEWA 763-766         SEDNEWB 767-770         SEDNEWC 771-774
        SEDNEWD 775-778         SEDNEWE 779-782         SEDAGE 783-785
        SEDYFU 786-789          SEDMFU 790-791          SEDREC 792-793
        SEDYRTOT 794-796        SVTOTFG 797-798         SVFQFLG 799-800
        SVBSTWAY 801-802        SVDAYPYR 803-805        SVDAYPMO 806-807
        SVDAYPWK 808-809        IRCIGRC 810-811         IICIGRC 812-813
        II2CIGRC 814-815        IRCGRRC 816-817         IICGRRC 818-819
        II2CGRRC 820-821        IRPIPLF 822-823         IIPIPLF 824-825
        IRPIPMN 826-827         IIPIPMN 828-829         IRSLTRC 830-831
        IISLTRC 832-833         II2SLTRC 834-835        IRCHWRC 836-837
        IICHWRC 838-839         II2CHWRC 840-841        IRSNFRC 842-843
        IISNFRC 844-845         II2SNFRC 846-847        IRALCRC 848-849
        IIALCRC 850-851         II2ALCRC 852-853        IRMJRC 854-855
        IIMJRC 856-857          II2MJRC 858-859         IRCOCRC 860-861
        IICOCRC 862-863         II2COCRC 864-865        IRCRKRC 866-867
        IICRKRC 868-869         II2CRKRC 870-871        IRHERRC 872-873
        IIHERRC 874-875         II2HERRC 876-877        IRHALRC 878-879
        IIHALRC 880-881         II2HALRC 882-883        IRLSDRC 884-885
        IILSDRC 886-887         II2LSDRC 888-889        IRPCPRC 890-891
        IIPCPRC 892-893         II2PCPRC 894-895        IRINHRC 896-897
        IIINHRC 898-899         II2INHRC 900-901        IRANLRC 902-903
        IIANLRC 904-905         II2ANLRC 906-907        IRTRNRC 908-909
        IITRNRC 910-911         II2TRNRC 912-913        IRSTMRC 914-915
        IISTMRC 916-917         II2STMRC 918-919        IRMTHRC 920-921
        IIMTHRC 922-923         II2MTHRC 924-925        IRSEDRC 926-927
        IISEDRC 928-929         II2SEDRC 930-931        IRALCFY 932-934
        IIALCFY 935-936         II2ALCFY 937-938        IRMJFY 939-941
        IIMJFY 942-943          II2MJFY 944-945         IRCOCFY 946-948
        IICOCFY 949-950         II2COCFY 951-952        IRCRKFY 953-955
        IICRKFY 956-957         II2CRKFY 958-959        IRHERFY 960-962
        IIHERFY 963-964         II2HERFY 965-966        IRHALFY 967-969
        IIHALFY 970-971         II2HALFY 972-973        IRINHFY 974-976
        IIINHFY 977-978         II2INHFY 979-980        IRANLFY 981-983
        IIANLFY 984-985         II2ANLFY 986-987        IRTRNFY 988-990
        IITRNFY 991-992         II2TRNFY 993-994        IRSTMFY 995-997
        IISTMFY 998-999         II2STMFY 1000-1001      IRSEDFY 1002-1004
        IISEDFY 1005-1006       II2SEDFY 1007-1008      IRCIGFM 1009-1013 .2
        IICIGFM 1014-1015       II2CIGFM 1016-1017      IRCGRFM 1018-1022 .2
        IICGRFM 1023-1024       II2CGRFM 1025-1026      IRCHWFM 1027-1031 .2
        IICHWFM 1032-1033       II2CHWFM 1034-1035      IRSNFFM 1036-1040 .2
        IISNFFM 1041-1042       II2SNFFM 1043-1044      IRALCFM 1045-1049 .2
        IIALCFM 1050-1051       II2ALCFM 1052-1053      IRALCD5 1054-1055
        IIALCD5 1056-1057       II2ALCD5 1058-1059      IRMJFM 1060-1064 .2
        IIMJFM 1065-1066        II2MJFM 1067-1068       IRCOCFM 1069-1073 .2
        IICOCFM 1074-1075       II2COCFM 1076-1077      IRCRKFM 1078-1082 .2
        IICRKFM 1083-1084       II2CRKFM 1085-1086      IRHERFM 1087-1088
        IIHERFM 1089-1090       II2HERFM 1091-1092      IRHALFM 1093-1097 .2
        IIHALFM 1098-1099       II2HALFM 1100-1101      IRINHFM 1102-1106 .2
        IIINHFM 1107-1108       II2INHFM 1109-1110      IRCIGAGE 1111-1113
        IICIGAGE 1114-1115      IRCIGYFU 1116-1119      IICIGYFU 1120-1121
        IRCDUAGE 1122-1124      IICDUAGE 1125-1126      IRCDUYFU 1127-1130
        IICDUYFU 1131-1132      IRCGRAGE 1133-1135      IICGRAGE 1136-1137
        IRCGRYFU 1138-1141      IICGRYFU 1142-1143      IRSNFAGE 1144-1146
        IISNFAGE 1147-1148      IRSNFYFU 1149-1152      IISNFYFU 1153-1154
        IRCHWAGE 1155-1157      IICHWAGE 1158-1159      IRCHWYFU 1160-1163
        IICHWYFU 1164-1165      IRSLTAGE 1166-1168      IISLTAGE 1169-1170
        IRSLTYFU 1171-1174      IISLTYFU 1175-1176      IRALCAGE 1177-1179
        IIALCAGE 1180-1181      IRALCYFU 1182-1185      IIALCYFU 1186-1187
        IRMJAGE 1188-1190       IIMJAGE 1191-1192       IRMJYFU 1193-1196
        IIMJYFU 1197-1198       IRCOCAGE 1199-1201      IICOCAGE 1202-1203
        IRCOCYFU 1204-1207      IICOCYFU 1208-1209      IRCRKAGE 1210-1212
        IICRKAGE 1213-1214      IRCRKYFU 1215-1218      IICRKYFU 1219-1220
        IRHERAGE 1221-1223      IIHERAGE 1224-1225      IRHERYFU 1226-1229
        IIHERYFU 1230-1231      IRHALAGE 1232-1234      IIHALAGE 1235-1236
        IRHALYFU 1237-1240      IIHALYFU 1241-1242      IRLSDAGE 1243-1245
        IILSDAGE 1246-1247      IRLSDYFU 1248-1251      IILSDYFU 1252-1253
        IRPCPAGE 1254-1256      IIPCPAGE 1257-1258      IRPCPYFU 1259-1262
        IIPCPYFU 1263-1264      IRINHAGE 1265-1267      IIINHAGE 1268-1269
        IRINHYFU 1270-1273      IIINHYFU 1274-1275      IRANLAGE 1276-1278
        IIANLAGE 1279-1280      IRANLYFU 1281-1284      IIANLYFU 1285-1286
        IRTRNAGE 1287-1289      IITRNAGE 1290-1291      IRTRNYFU 1292-1295
        IITRNYFU 1296-1297      IRSTMAGE 1298-1300      IISTMAGE 1301-1302
        IRSTMYFU 1303-1306      IISTMYFU 1307-1308      IRMTHAGE 1309-1311
        IIMTHAGE 1312-1313      IRMTHYFU 1314-1317      IIMTHYFU 1318-1319
        IRSEDAGE 1320-1322      IISEDAGE 1323-1324      IRSEDYFU 1325-1328
        IISEDYFU 1329-1330      CIGFLAG 1331-1332       CIGYR 1333-1334
        CIGMON 1335-1336        CGRFLAG 1337-1338       CGRYR 1339-1340
        CGRMON 1341-1342        PIPFLAG 1343-1344       PIPMON 1345-1346
        SMKFLAG 1347-1348       SMKYR 1349-1350         SMKMON 1351-1352
        CHWFLAG 1353-1354       CHWYR 1355-1356         CHWMON 1357-1358
        SNFFLAG 1359-1360       SNFYR 1361-1362         SNFMON 1363-1364
        TOBFLAG 1365-1366       TOBYR 1367-1368         TOBMON 1369-1370
        CIGBRND2 1371-1372      CGRBRND2 1373-1374      SMKBRND2 1375-1376
        CIGCMPNY 1377-1378      ALCFLAG 1379-1380       ALCYR 1381-1382
        ALCMON 1383-1384        MRJFLAG 1385-1386       MRJYR 1387-1388
        MRJMON 1389-1390        COCFLAG 1391-1392       COCYR 1393-1394
        COCMON 1395-1396        CRKFLAG 1397-1398       CRKYR 1399-1400
        CRKMON 1401-1402        HERFLAG 1403-1404       HERYR 1405-1406
        HERMON 1407-1408        HALFLAG 1409-1410       HALYR 1411-1412
        HALMON 1413-1414        LSDFLAG 1415-1416       LSDYR 1417-1418
        LSDMON 1419-1420        PCPFLAG 1421-1422       PCPYR 1423-1424
        PCPMON 1425-1426        INHFLAG 1427-1428       INHYR 1429-1430
        INHMON 1431-1432        ANLFLAG 1433-1434       ANLYR 1435-1436
        ANLMON 1437-1438        TRQFLAG 1439-1440       TRQYR 1441-1442
        TRQMON 1443-1444        STMFLAG 1445-1446       STMYR 1447-1448
        STMMON 1449-1450        MTHFLAG 1451-1452       MTHYR 1453-1454
        MTHMON 1455-1456        SEDFLAG 1457-1458       SEDYR 1459-1460
        SEDMON 1461-1462        PSYFLAG2 1463-1464      PSYYR2 1465-1466
        PSYMON2 1467-1468       SUMFLAG 1469-1470       SUMYR 1471-1472
        SUMMON 1473-1474        MJOFLAG 1475-1476       MJOYR2 1477-1478
        MJOMON2 1479-1480       IEMFLAG 1481-1482       IEMYR 1483-1484
        IEMMON 1485-1486        BINGEDRK 1487-1488      HVYDRK2 1489-1490
        BINGEHVY 1491-1492      PEYOTE2 1493-1494       MESC2 1495-1496
        PSILCY2 1497-1498       ECSTASY2 1499-1500      AMYLNIT2 1501-1502
        CLEFLU2 1503-1504       GAS2 1505-1506          GLUE2 1507-1508
        ETHER2 1509-1510        SOLVENT2 1511-1512      LGAS2 1513-1514
        NITOXID2 1515-1516      SPPAINT2 1517-1518      AEROS2 1519-1520
        DARVTYL2 1521-1522      PERCTYL2 1523-1524      VICOLOR2 1525-1526
        CODEINE2 1527-1528      DEMEROL2 1529-1530      DILAUD2 1531-1532
        FIORICT2 1533-1534      FIORINL2 1535-1536      HYDROCD2 1537-1538
        METHDON2 1539-1540      MORPHIN2 1541-1542      OXYCONT2 1543-1544
        PHENCOD2 1545-1546      PROPOXY2 1547-1548      SK65A2 1549-1550
        STADOL2 1551-1552       TALACEN2 1553-1554      TALWIN2 1555-1556
        TALWINX2 1557-1558      TRAMADL2 1559-1560      ULTRAM2 1561-1562
        OTHANL 1563-1564        KLONOPI2 1565-1566      XNAXATV2 1567-1568
        VALMDIA2 1569-1570      ATARAX2 1571-1572       BUSPAR2 1573-1574
        EQUANIL2 1575-1576      FLEXERL2 1577-1578      LIBRIUM2 1579-1580
        LIMBTRL2 1581-1582      MEPROB2 1583-1584       MILTOWN2 1585-1586
        ROHYPNL2 1587-1588      SERAX2 1589-1590        SOMA2 1591-1592
        TRANXEN2 1593-1594      VISTAR2 1595-1596       OTHTRN 1597-1598
        METHDES2 1599-1600      DIETPIL2 1601-1602      RITMPHE2 1603-1604
        CYLERT2 1605-1606       DEXED2 1607-1608        DETAMP2 1609-1610
        DIDREX2 1611-1612       ESKAT2 1613-1614        IONAMIN2 1615-1616
        MAZANOR2 1617-1618      OBLA2 1619-1620         PLEGINE2 1621-1622
        PRELUDN2 1623-1624      SANOREX2 1625-1626      TENUATE2 1627-1628
        OTHSTM 1629-1630        METHAQ2 1631-1632       NEMBBAR2 1633-1634
        RESTTMA2 1635-1636      AMYTAL2 1637-1638       BUTISOL2 1639-1640
        CHHYD2 1641-1642        DALMANE2 1643-1644      HALCION2 1645-1646
        PHENOBR2 1647-1648      PLACIDY2 1649-1650      TUINAL2 1651-1652
        OTHSED 1653-1654        ALCAFU 1655-1656        MJAFU 1657-1658
        COCAFU 1659-1660        HERAFU 1661-1662        HALAFU 1663-1664
        INHAFU 1665-1666        ANLAFU 1667-1668        TRNAFU 1669-1670
        STMAFU 1671-1672        SEDAFU 1673-1674        CIGAFU 1675-1676
        CGRAFU 1677-1678        SLTAFU 1679-1680        MRJYDAYS 1681-1682
        COCYDAYS 1683-1684      HALYDAYS 1685-1686      INHYDAYS 1687-1688
        ALCYDAYS 1689-1690      MRJMDAYS 1691-1692      COCMDAYS 1693-1694
        HALMDAYS 1695-1696      INHMDAYS 1697-1698      ALCMDAYS 1699-1700
        CIGMDAYS 1701-1702      CIGPDAY 1703-1704       CG05 1705-1706
        CG06 1707-1708          CG06DK 1709-1710        CG06RE 1711-1712
        CG19 1713-1714          CG20 1715-1716          CG20DK 1717-1718
        CG20RE 1719-1720        CG27 1721-1722          CG28 1723-1724
        CG28DK 1725-1726        CG28RE 1727-1728        CG36 1729-1730
        CG37 1731-1732          CG37DK 1733-1734        CG37RE 1735-1736
        CG43 1737-1738          ALLAST3 1739-1740       ALRECDK 1741-1742
        ALRECRE 1743-1744       TOTDRINK 1745-1747      ALFRAME3 1748-1749
        ALYRAVE 1750-1752       ALMONAVE 1753-1754      ALWKAVE 1755-1756
        MJLAST3 1757-1758       MJRECDK 1759-1760       MJRECRE 1761-1762
        TOTMJ 1763-1765         MJFRAME3 1766-1767      MJYRAVE 1768-1770
        MJMONAVE 1771-1772      MJWKAVE 1773-1774       CCLAST3 1775-1776
        CCRECDK 1777-1778       CCRECRE 1779-1780       TOTCOKE 1781-1783
        CCFRAME3 1784-1785      CCYRAVE 1786-1788       CCMONAVE 1789-1790
        CCWKAVE 1791-1792       CKLAST3 1793-1794       CKRECDK 1795-1796
        CKRECRE 1797-1798       TOTCRACK 1799-1801      CKFRAME3 1802-1803
        CKYRAVE 1804-1806       CKMONAVE 1807-1808      CKWKAVE 1809-1810
        HELAST3 1811-1812       HERECDK 1813-1814       HERECRE 1815-1816
        TOTHERO 1817-1819       HEFRAME3 1820-1821      HEYRAVE 1822-1824
        HEMONAVE 1825-1826      HEWKAVE 1827-1828       LSLAST 1829-1830
        LSRECDK 1831-1832       LSRECRE 1833-1834       TOTHALL 1835-1837
        LSFRAME3 1838-1839      LSYRAVE 1840-1842       LSMONAVE 1843-1844
        LSWKAVE 1845-1846       LS10 1847-1848          LS16 1849-1850
        INLAST 1851-1852        INRECDK 1853-1854       INRECRE 1855-1856
        TOTINHAL 1857-1859      INFRAME3 1860-1861      INYRAVE 1862-1864
        INMONAVE 1865-1866      INWKAVE 1867-1868       PR09 1869-1870
        PRRECDK 1871-1872       PRRECRE 1873-1874       PR10 1875-1876
        PR11 1877-1879          PR12 1880-1881          PR13 1882-1883
        TR09 1884-1885          TRRECDK 1886-1887       TRRECRE 1888-1889
        TR10 1890-1891          TR11 1892-1894          TR12 1895-1896
        TR13 1897-1898          ST09 1899-1900          STRECDK 1901-1902
        STRECRE 1903-1904       ST10 1905-1906          ST11 1907-1909
        ST12 1910-1911          ST13 1912-1913          ST19 1914-1915
        SV09 1916-1917          SVRECDK 1918-1919       SVRECRE 1920-1921
        SV10 1922-1923          SV11 1924-1926          SV12 1927-1928
        SV13 1929-1930          HERSMOKE 1931-1932      HRSMKREC 1933-1934
        HERSNIFF 1935-1936      HRSNFREC 1937-1938      GNNDLLIF 1939-1940
        COCNEEDL 1941-1942      CONDLREC 1943-1944      HERNEEDL 1945-1946
        HRNDLREC 1947-1948      STNEEDLE 1949-1950      STNDLREC 1951-1952
        GNNDREUS 1953-1954      GNNDLSH1 1955-1956      GNNDCLEN 1957-1958
        GNNDLSH2 1959-1960      GNNDGET2 1961-1962      NEDLRECC 1963-1964
        NEDFLAG4 1965-1966      HERSMOK2 1967-1968      HERSNIF2 1969-1970
        NEDHER 1971-1972        NEDCOC 1973-1974        NEDSTM 1975-1976
        RSKPKCIG 1977-1978      RSKMJOCC 1979-1980      RSKMJREG 1981-1982
        RKTRYLSD 1983-1984      RKLSDREG 1985-1986      RKTRYHER 1987-1988
        RKHERREG 1989-1990      RKCOCOCC 1991-1992      RKCOCREG 1993-1994
        RK5ALDLY 1995-1996      RK5ALWK 1997-1998       RSKDIFMJ 1999-2000
        RKDIFLSD 2001-2002      RKDIFCOC 2003-2004      RKDIFCRK 2005-2006
        RKDIFHER 2007-2008      RSKSELL 2009-2010       RKFQDNGR 2011-2012
        RKFQRSKY 2013-2014      RKFQPBLT 2015-2016      RKFQDBLT 2017-2018
        GRSKPKCG 2019-2020      GRSKCREG 2021-2022      GRSKCOCC 2023-2024
        GRSKMREG 2025-2026      GRSKMOCC 2027-2028      GRSKHTRY 2029-2030
        GRSKHREG 2031-2032      GRSKLTRY 2033-2034      GRSKLREG 2035-2036
        GRSKD4_5 2037-2038      GRSKD5WK 2039-2040      RDIFMJ 2041-2042
        RDIFCOC 2043-2044       RDIFHER 2045-2046       RDIFLSD 2047-2048
        RDIFCRK 2049-2050       APPSELDG 2051-2052      CIGLOTTM 2053-2054
        CIGLIMIT 2055-2056      CIGKPLMT 2057-2058      CIGNDMOR 2059-2060
        CIGLSEFX 2061-2062      CIGCUTDN 2063-2064      CIGCUTEV 2065-2066
        CIGCUT1X 2067-2068      CIGWD4SX 2069-2070      CIGWDSMT 2071-2072
        CIGEMOPB 2073-2074      CIGEMCTD 2075-2076      CIGPHLPB 2077-2078
        CIGPHCTD 2079-2080      CIGLSACT 2081-2082      CIGPKCRT 2083-2084
        CIGPDPAK 2085-2086      CIGPDCRT 2087-2088      ALCLOTTM 2089-2090
        ALCGTOVR 2091-2092      ALCLIMIT 2093-2094      ALCKPLMT 2095-2096
        ALCNDMOR 2097-2098      ALCLSEFX 2099-2100      ALCCUTDN 2101-2102
        ALCCUTEV 2103-2104      ALCCUT1X 2105-2106      ALCWD2SX 2107-2108
        ALCWDSMT 2109-2110      ALCEMOPB 2111-2112      ALCEMCTD 2113-2114
        ALCPHLPB 2115-2116      ALCPHCTD 2117-2118      ALCLSACT 2119-2120
        ALCSERPB 2121-2122      ALCPDANG 2123-2124      ALCLAWTR 2125-2126
        ALCFMFPB 2127-2128      ALCFMCTD 2129-2130      MRJLOTTM 2131-2132
        MRJGTOVR 2133-2134      MRJLIMIT 2135-2136      MRJKPLMT 2137-2138
        MRJNDMOR 2139-2140      MRJLSEFX 2141-2142      MRJCUTDN 2143-2144
        MRJCUTEV 2145-2146      MRJEMOPB 2147-2148      MRJEMCTD 2149-2150
        MRJPHLPB 2151-2152      MRJPHCTD 2153-2154      MRJLSACT 2155-2156
        MRJSERPB 2157-2158      MRJPDANG 2159-2160      MRJLAWTR 2161-2162
        MRJFMFPB 2163-2164      MRJFMCTD 2165-2166      COCLOTTM 2167-2168
        COCGTOVR 2169-2170      COCLIMIT 2171-2172      COCKPLMT 2173-2174
        COCNDMOR 2175-2176      COCLSEFX 2177-2178      COCCUTDN 2179-2180
        COCCUTEV 2181-2182      COCCUT1X 2183-2184      COCFLBLU 2185-2186
        COCWD2SX 2187-2188      COCWDSMT 2189-2190      COCEMOPB 2191-2192
        COCEMCTD 2193-2194      COCPHLPB 2195-2196      COCPHCTD 2197-2198
        COCLSACT 2199-2200      COCSERPB 2201-2202      COCPDANG 2203-2204
        COCLAWTR 2205-2206      COCFMFPB 2207-2208      COCFMCTD 2209-2210
        HERLOTTM 2211-2212      HERGTOVR 2213-2214      HERLIMIT 2215-2216
        HERKPLMT 2217-2218      HERNDMOR 2219-2220      HERLSEFX 2221-2222
        HERCUTDN 2223-2224      HERCUTEV 2225-2226      HERCUT1X 2227-2228
        HERWD3SX 2229-2230      HERWDSMT 2231-2232      HEREMOPB 2233-2234
        HEREMCTD 2235-2236      HERPHLPB 2237-2238      HERPHCTD 2239-2240
        HERLSACT 2241-2242      HERSERPB 2243-2244      HERPDANG 2245-2246
        HERLAWTR 2247-2248      HERFMFPB 2249-2250      HERFMCTD 2251-2252
        HALLOTTM 2253-2254      HALGTOVR 2255-2256      HALLIMIT 2257-2258
        HALKPLMT 2259-2260      HALNDMOR 2261-2262      HALLSEFX 2263-2264
        HALCUTDN 2265-2266      HALCUTEV 2267-2268      HALEMOPB 2269-2270
        HALEMCTD 2271-2272      HALPHLPB 2273-2274      HALPHCTD 2275-2276
        HALLSACT 2277-2278      HALSERPB 2279-2280      HALPDANG 2281-2282
        HALLAWTR 2283-2284      HALFMFPB 2285-2286      HALFMCTD 2287-2288
        INHLOTTM 2289-2290      INHGTOVR 2291-2292      INHLIMIT 2293-2294
        INHKPLMT 2295-2296      INHNDMOR 2297-2298      INHLSEFX 2299-2300
        INHCUTDN 2301-2302      INHCUTEV 2303-2304      INHEMOPB 2305-2306
        INHEMCTD 2307-2308      INHPHLPB 2309-2310      INHPHCTD 2311-2312
        INHLSACT 2313-2314      INHSERPB 2315-2316      INHPDANG 2317-2318
        INHLAWTR 2319-2320      INHFMFPB 2321-2322      INHFMCTD 2323-2324
        ANLLOTTM 2325-2326      ANLGTOVR 2327-2328      ANLLIMIT 2329-2330
        ANLKPLMT 2331-2332      ANLNDMOR 2333-2334      ANLLSEFX 2335-2336
        ANLCUTDN 2337-2338      ANLCUTEV 2339-2340      ANLCUT1X 2341-2342
        ANLWD3SX 2343-2344      ANLWDSMT 2345-2346      ANLEMOPB 2347-2348
        ANLEMCTD 2349-2350      ANLPHLPB 2351-2352      ANLPHCTD 2353-2354
        ANLLSACT 2355-2356      ANLSERPB 2357-2358      ANLPDANG 2359-2360
        ANLLAWTR 2361-2362      ANLFMFPB 2363-2364      ANLFMCTD 2365-2366
        TRNLOTTM 2367-2368      TRNGTOVR 2369-2370      TRNLIMIT 2371-2372
        TRNKPLMT 2373-2374      TRNNDMOR 2375-2376      TRNLSEFX 2377-2378
        TRNCUTDN 2379-2380      TRNCUTEV 2381-2382      TRNEMOPB 2383-2384
        TRNEMCTD 2385-2386      TRNPHLPB 2387-2388      TRNPHCTD 2389-2390
        TRNLSACT 2391-2392      TRNSERPB 2393-2394      TRNPDANG 2395-2396
        TRNLAWTR 2397-2398      TRNFMFPB 2399-2400      TRNFMCTD 2401-2402
        STMLOTTM 2403-2404      STMGTOVR 2405-2406      STMLIMIT 2407-2408
        STMKPLMT 2409-2410      STMNDMOR 2411-2412      STMLSEFX 2413-2414
        STMCUTDN 2415-2416      STMCUTEV 2417-2418      STMCUT1X 2419-2420
        STMFLBLU 2421-2422      STMWD2SX 2423-2424      STMWDSMT 2425-2426
        STMEMOPB 2427-2428      STMEMCTD 2429-2430      STMPHLPB 2431-2432
        STMPHCTD 2433-2434      STMLSACT 2435-2436      STMSERPB 2437-2438
        STMPDANG 2439-2440      STMLAWTR 2441-2442      STMFMFPB 2443-2444
        STMFMCTD 2445-2446      SEDLOTTM 2447-2448      SEDGTOVR 2449-2450
        SEDLIMIT 2451-2452      SEDKPLMT 2453-2454      SEDNDMOR 2455-2456
        SEDLSEFX 2457-2458      SEDCUTDN 2459-2460      SEDCUTEV 2461-2462
        SEDCUT1X 2463-2464      SEDWD1SX 2465-2466      SEDWDSMT 2467-2468
        SEDEMOPB 2469-2470      SEDEMCTD 2471-2472      SEDPHLPB 2473-2474
        SEDPHCTD 2475-2476      SEDLSACT 2477-2478      SEDSERPB 2479-2480
        SEDPDANG 2481-2482      SEDLAWTR 2483-2484      SEDFMFPB 2485-2486
        SEDFMCTD 2487-2488      DEPNDALC 2489-2490      DEPNDANL 2491-2492
        DEPNDCIG 2493-2494      DEPNDCOC 2495-2496      DEPNDHAL 2497-2498
        DEPNDHER 2499-2500      DEPNDINH 2501-2502      DEPNDMRJ 2503-2504
        DEPNDSED 2505-2506      DEPNDSTM 2507-2508      DEPNDTRN 2509-2510
        DEPNDILL 2511-2512      DEPNDIEM 2513-2514      DEPNDXMJ 2515-2516
        DEPNDPSY 2517-2518      DPILLALC 2519-2520      DPILANAL 2521-2522
        ABUSEALC 2523-2524      ABUSEANL 2525-2526      ABUSECOC 2527-2528
        ABUSEHAL 2529-2530      ABUSEHER 2531-2532      ABUSEINH 2533-2534
        ABUSEMRJ 2535-2536      ABUSESED 2537-2538      ABUSESTM 2539-2540
        ABUSETRN 2541-2542      ABUSEILL 2543-2544      ABUSEIEM 2545-2546
        ABUSEXMJ 2547-2548      ABUSEPSY 2549-2550      ABILLALC 2551-2552
        ABILANAL 2553-2554      ABODALC 2555-2556       ABODANL 2557-2558
        ABODCOC 2559-2560       ABODHAL 2561-2562       ABODHER 2563-2564
        ABODINH 2565-2566       ABODMRJ 2567-2568       ABODSED 2569-2570
        ABODSTM 2571-2572       ABODTRN 2573-2574       ABODILL 2575-2576
        ABODPSY 2577-2578       ABODILAL 2579-2580      ABDILAAL 2581-2582
        BOOKED 2583-2584        NOBOOKY2 2585-2587      BKMVTHFT 2588-2589
        BKLARCNY 2590-2591      BKBURGL 2592-2593       BKAGASLT 2594-2595
        BKSMASLT 2596-2597      BKROB 2598-2599         BKRAPE 2600-2601
        BKMURDER 2602-2603      BKARSON 2604-2605       BKDRVINF 2606-2607
        BKDRUNK 2608-2609       BKPOSTOB 2610-2611      BKDRUG 2612-2613
        BKPROS 2614-2615        BKSEXOFF 2616-2617      BKFRAUD 2618-2619
        BKOTH 2620-2621         BKOTHOF2 2622-2623      PROBATON 2624-2625
        PAROLREL 2626-2627      DRVALDR 2628-2629       DRVAONLY 2630-2631
        DRVDONLY 2632-2633      DRIVALC 2634-2635       DRIVDRG 2636-2637
        DRIVALD 2638-2639       PAROL 2640-2641         PROB 2642-2643
        TXEVER 2644-2645        TXYREVER 2646-2647      TXYRADG 2648-2649
        TXYRHOSP 2650-2651      TXYRHPAD 2652-2653      TXYRRFIN 2654-2655
        TXYRINAD 2656-2657      TXYRRFOP 2658-2659      TXYRPOAD 2660-2661
        TXYRMHC 2662-2663       TXYRMHAD 2664-2665      TXYRTXER 2666-2667
        TXYRERAD 2668-2669      TXYRDOC 2670-2671       TXYRDCAD 2672-2673
        TXYRJAIL 2674-2675      TXYRJLAD 2676-2677      TXYRSHG 2678-2679
        TXYRSGAD 2680-2681      TXYRSOP 2682-2683       TXYROTS2 2684-2686
        TXYROTAD 2687-2688      TXYRVSER 2689-2690      TXYRNME2 2691-2693
        TXRCVNOW 2694-2695      NDTXNEDR 2696-2697      NDTXMORE 2698-2699
        NDTMRALC 2700-2701      NDTMRMJ 2702-2703       NDTMRCOC 2704-2705
        NDTMRHER 2706-2707      NDTMRHAL 2708-2709      NDTMRINH 2710-2711
        NDTMRANL 2712-2713      NDTMRTRN 2714-2715      NDTMRSTM 2716-2717
        NDTMRSED 2718-2719      NDTMROTH 2720-2721      NDTXALCR 2722-2723
        NDTXMJR 2724-2725       NDTXCOCR 2726-2727      NDTXHERR 2728-2729
        NDTXHALR 2730-2731      NDTXINHR 2732-2733      NDTXANLR 2734-2735
        NDTXTRNR 2736-2737      NDTXSTMR 2738-2739      NDTXSEDR 2740-2741
        NDTXSODR 2742-2743      NDTXDG1R 2744-2747      NDTXDG2R 2748-2751
        NDTXDG3R 2752-2755      NDTXDG4R 2756-2759      NDTXDG5R 2760-2763
        NDTXEFTR 2764-2765      NDTMREFT 2766-2767      TXLASREC 2768-2769
        TXLTYMN2 2770-2772      TXLTYALC 2773-2774      TXLTYMJ 2775-2776
        TXLTYCOC 2777-2778      TXLTYHER 2779-2780      TXLTYHAL 2781-2782
        TXLTYINH 2783-2784      TXLTYANL 2785-2786      TXLTYTRN 2787-2788
        TXLTYSTM 2789-2790      TXLTYSED 2791-2792      TXLTYSOD 2793-2794
        TXLTYOU2 2795-2796      TXLTYDU2 2797-2801      TXPYINS 2802-2803
        TXPYCARE 2804-2805      TXPYCAID 2806-2807      TXPYPUBP 2808-2809
        TXPYSAVE 2810-2811      TXPYFMLY 2812-2813      TXPYCORT 2814-2815
        TXPYMILC 2816-2817      TXPYEMPL 2818-2819      TXPYSOS 2820-2821
        TXPYSP2 2822-2823       TXPYFRE 2824-2825       TXENROLL 2826-2827
        TXYRDTXO 2828-2829      SPECTILL 2830-2831      SPECTALC 2832-2833
        SPILLALC 2834-2835      ILLNEED 2836-2837       TXNOSPEC 2838-2839
        ALCTRMT 2840-2841       ILLTRMT 2842-2843       TXILLALC 2844-2845
        TXILANAL 2846-2847      TXLTALC2 2848-2849      TXLTANL2 2850-2851
        TXLTCOC2 2852-2853      TXLTHAL2 2854-2855      TXLTHER2 2856-2857
        TXLTINH2 2858-2859      TXLTMJ2 2860-2861       TXLTSED2 2862-2863
        TXLTSTM2 2864-2865      TXLTTRN2 2866-2867      TXLTILL2 2868-2869
        TXPINS2 2870-2871       TXPCARE2 2872-2873      TXPCAID2 2874-2875
        TXPPUBP2 2876-2877      TXPSAVE2 2878-2879      TXPFMLY2 2880-2881
        TXPCORT2 2882-2883      TXPMILC2 2884-2885      TXPEMPL2 2886-2887
        ILLPINS 2888-2889       ILLPCARE 2890-2891      ILLPCAID 2892-2893
        ILLPPUBP 2894-2895      ILLPSAVE 2896-2897      ILLPFMLY 2898-2899
        ILLPCORT 2900-2901      ILLPMILC 2902-2903      ILLPEMPL 2904-2905
        ALCPINS 2906-2907       ALCPCARE 2908-2909      ALCPCAID 2910-2911
        ALCPPUBP 2912-2913      ALCPSAVE 2914-2915      ALCPFMLY 2916-2917
        ALCPCORT 2918-2919      ALCPMILC 2920-2921      ALCPEMPL 2922-2923
        LOCHOSP 2924-2925       LOCRFIN 2926-2927       LOCRFOP 2928-2929
        LOCMHC 2930-2931        LOCTXER 2932-2933       LOCDOC 2934-2935
        LOCJAIL 2936-2937       LOCSHG 2938-2939        DRGHOSP 2940-2941
        DRGRFIN 2942-2943       DRGRFOP 2944-2945       DRGMHC 2946-2947
        DRGTXER 2948-2949       DRGDOC 2950-2951        DRGJAIL 2952-2953
        DRGSHG 2954-2955        ALCHOSP 2956-2957       ALCRFIN 2958-2959
        ALCRFOP 2960-2961       ALCMHC 2962-2963        ALCTXER 2964-2965
        ALCDOC 2966-2967        ALCJAIL 2968-2969       ALCSHG 2970-2971
        AUINPYR 2972-2973       AUINPSYH 2974-2975      AUINPGEN 2976-2977
        AUINMEDU 2978-2979      AUINAHSP 2980-2981      AUINRESD 2982-2983
        AUINSFAC 2984-2985      AUNMPSY2 2986-2988      AUNMPGE2 2989-2991
        AUNMMEDU 2992-2994      AUNMAHSP 2995-2997      AUNMRESD 2998-3000
        AUNMSFA2 3001-3003      AUPINSLF 3004-3005      AUPINOFM 3006-3007
        AUPINPHI 3008-3009      AUPINMCR 3010-3011      AUPINMCD 3012-3013
        AUPINREH 3014-3015      AUPINEMP 3016-3017      AUPINMIL 3018-3019
        AUPINPUB 3020-3021      AUPINPRV 3022-3023      AUPINFRE 3024-3025
        AUPINAMT 3026-3027      AUOPTYR 3028-3029       AUOPMENT 3030-3031
        AUOPTHER 3032-3033      AUOPDOC 3034-3035       AUOPCLNC 3036-3037
        AUOPDTMT 3038-3039      AUOPOTOP 3040-3041      AUOPYRS2 3042-3043
        AUNMMEN2 3044-3046      AUNMTHE2 3047-3049      AUNMDOC2 3050-3052
        AUNMCLN2 3053-3055      AUNMDTM2 3056-3058      AUNMOTO2 3059-3061
        AUPOPSLF 3062-3063      AUPOPOFM 3064-3065      AUPOPPHI 3066-3067
        AUPOPMCR 3068-3069      AUPOPMCD 3070-3071      AUPOPREH 3072-3073
        AUPOPEMP 3074-3075      AUPOPMIL 3076-3077      AUPOPPUB 3078-3079
        AUPOPPRV 3080-3081      AUPOPFRE 3082-3083      AUPOPMOS 3084-3085
        AUPOPAMT 3086-3087      AURXYR 3088-3089        AUUNMTYR 3090-3091
        AUUNMTRS 3092-3093      AMHINP 3094-3095        AMHOUTP 3096-3097
        AMHRX 3098-3099         AMHTXREC 3100-3101      AMHTRTND 3102-3103
        SNCRIME 3104-3105       SNSELLDG 3106-3107      SNPPVAL 3108-3109
        SNSTFGT 3110-3111       SNEMTBLD 3112-3113      SNPPHLP 3114-3115
        SNGRAFTI 3116-3117      SNPPVSIT 3118-3119      SNPPMOVE 3120-3121
        SNMOV5Y2 3122-3124      SNSPOUSE 3125-3126      SNSPACTV 3127-3128
        SNSPANGR 3129-3130      SNSPHITU 3131-3132      SNYHITSP 3133-3134
        SNSPCRIT 3135-3136      SNSPCONC 3137-3138      SNFRCONC 3139-3140
        SNFRACTV 3141-3142      SNFRCARE 3143-3144      SNYSELL 3145-3146
        SNYSTOLE 3147-3148      SNYATTAK 3149-3150      SNFACIG 3151-3152
        SNFAMJEV 3153-3154      SNFAALDY 3155-3156      SNFAALDV 3157-3158
        YECRIME 3159-3160       YESELLDG 3161-3162      YEPPHLP 3163-3164
        YESTFGT 3165-3166       YEEMTBLD 3167-3168      YEPPVSIT 3169-3170
        YEGRAFTI 3171-3172      YEPPMOVE 3173-3174      YEMOV5Y2 3175-3177
        YEENRLYR 3178-3179      YELSTGRD 3180-3181      YEYFGTSW 3182-3183
        YEYFGTGP 3184-3185      YEYHGUN 3186-3187       YEYSELL 3188-3189
        YEYSTOLE 3190-3191      YEYATTAK 3192-3193      YEPPKCIG 3194-3195
        YEPMJEVR 3196-3197      YEPALDLY 3198-3199      YEGPKCIG 3200-3201
        YEGMJEVR 3202-3203      YEGALDLY 3204-3205      YETLKNON 3206-3207
        YETLKPAR 3208-3209      YETLKSOP 3210-3211      YEPRTDNG 3212-3213
        YEBIGBRO 3214-3215      YEPRBSLV 3216-3217      YEVIOPRV 3218-3219
        YEYMCA 3220-3221        YESCOUTS 3222-3223      YEPRVLES 3224-3225
        YEDGPRGP 3226-3227      YETEMSPT 3228-3229      YE4HCLUB 3230-3231
        YESLFHLP 3232-3233      YEBAND 3234-3235        YESCHCLB 3236-3237
        YEVOLUNT 3238-3239      YESTGOVT 3240-3241      YEPRGSTD 3242-3243
        YEJBSKIL 3244-3245      YECHOIR 3246-3247       YEDECLAS 3248-3249
        YEDERGLR 3250-3251      YEDESPCL 3252-3253      YEPVNTYR 3254-3255
        YECGFRND 3256-3257      YECGVEND 3258-3259      YECGMAI2 3260-3261
        YECGCHKO 3262-3263      YECGCLRK 3264-3265      YECGINET 3266-3267
        YECGSMKT 3268-3269      YECGDSTO 3270-3271      YECGCONV 3272-3273
        YECGINDV 3274-3275      YECGPRUF 3276-3277      YECGSUCC 3278-3279
        YEPKCRTN 3280-3281      YEPDPACK 3282-3283      YEPDCRTN 3284-3285
        YEBLNTEV 3286-3287      YEBLNT30 3288-3289      YEBL30FQ 3290-3291
        YECGRWMJ 3292-3293      NGHCRIM2 3294-3295      NGHSELL2 3296-3297
        NGHHELP2 3298-3299      NGHFGHT2 3300-3301      NGHBLDG2 3302-3303
        NGHVSIT2 3304-3305      NGHGRAF2 3306-3307      NGHMOVE2 3308-3309
        MVIN5YR2 3310-3311      PRPKCIG2 3312-3313      PRMJEVR2 3314-3315
        PRALDLY2 3316-3317      PRTALK3 3318-3319       YOFIGHT2 3320-3321
        YOGRPFT2 3322-3323      YOHGUN2 3324-3325       YOSELL2 3326-3327
        YOSTOLE2 3328-3329      YOATTAK2 3330-3331      YFLPKCG2 3332-3333
        YFLTMRJ2 3334-3335      YFLADLY2 3336-3337      YOUTHACT 3338-3339
        PRBSOLV2 3340-3341      PREVIOL2 3342-3343      PRVDRGO2 3344-3345
        GRPCNSL2 3346-3347      PREGPGM2 3348-3349      DGSPCLS2 3350-3351
        DGRGCLS2 3352-3353      DRGLECT2 3354-3355      DRPRVME3 3356-3357
        ANYEDUC3 3358-3359      CIGFRND 3360-3361       CIGVEND 3362-3363
        CIGMAIL 3364-3365       CIGCKOUT 3366-3367      CIGCLERK 3368-3369
        CIGINET 3370-3371       CIGSMKT 3372-3373       CIGDSTO 3374-3375
        CIGCONV 3376-3377       CIGINDIV 3378-3379      YTHBGHT 3380-3381
        YMSPGRUP 3382-3383      YMSPFNTP 3384-3385      YMSAHOME 3386-3387
        YMSAACHE 3388-3389      YMSABDRM 3390-3391      YMSASLEP 3392-3393
        YMSAABDN 3394-3395      YMSAUPLV 3396-3397      YMSAHMSK 3398-3399
        YMAGOHSF 3400-3401      YMAGCRWD 3402-3403      YMAGTRAV 3404-3405
        YMAGBRDG 3406-3407      YMPAATAK 3408-3409      YMPASUFC 3410-3411
        YMGAWORY 3412-3413      YMGAHDAC 3414-3415      YMGAPAIN 3416-3417
        YMGATNSE 3418-3419      YMPHANML 3420-3421      YMPHHIGH 3422-3423
        YMPHDARK 3424-3425      YMPHNEDL 3426-3427      YMPHBLOD 3428-3429
        YMPHBRDG 3430-3431      YMPHELEV 3432-3433      YMOCCOUN 3434-3435
        YMOCWASH 3436-3437      YMOCCHCK 3438-3439      YMOCGERM 3440-3441
        YMOCTHOT 3442-3443      YMEATHIN 3444-3445      YMEAFAT 3446-3447
        YMEATHFD 3448-3449      YMEABING 3450-3451      YMELWTBD 3452-3453
        YMELWTPT 3454-3455      YMELSOIL 3456-3457      YMMDNINT 3458-3459
        YMMDLSEG 3460-3461      YMMDNOGD 3462-3463      YMMDTHKL 3464-3465
        YMMDTYKL 3466-3467      YMMDTIRD 3468-3469      YMMDTHNK 3470-3471
        YMMABDMD 3472-3473      YMMARSLS 3474-3475      YMMATALK 3476-3477
        YMMASPAB 3478-3479      YMMAMDRC 3480-3481      YMADCONC 3482-3483
        YMADFRGT 3484-3485      YMADFCUS 3486-3487      YMADMEDS 3488-3489
        YMADAVAT 3490-3491      YMADERRO 3492-3493      YMODHURT 3494-3495
        YMODRFUS 3496-3497      YMODANOY 3498-3499      YMODMEAN 3500-3501
        YMODBLMO 3502-3503      YMODTANY 3504-3505      YMODSWOR 3506-3507
        YMCDEXPL 3508-3509      YMCDSHPL 3510-3511      YMCDLIED 3512-3513
        YMCDSNAT 3514-3515      YMCDVAND 3516-3517      YMCDSTOL 3518-3519
        YMCDCRUA 3520-3521      YMCDBKNT 3522-3523      YUHOSPYR 3524-3525
        YUHOSPN2 3526-3528      YUHOSUIC 3529-3530      YUHODEPR 3531-3532
        YUHOFEAR 3533-3534      YUHOBKRU 3535-3536      YUHOEATP 3537-3538
        YUHOSOR 3539-3540       YURSIDYR 3541-3542      YURSIDN2 3543-3545
        YURSSUIC 3546-3547      YURSDEPR 3548-3549      YURSFEAR 3550-3551
        YURSBKRU 3552-3553      YURSEATP 3554-3555      YURSSOR 3556-3557
        YUFCARYR 3558-3559      YUFCARN2 3560-3562      YUFCSUIC 3563-3564
        YUFCDEPR 3565-3566      YUFCFEAR 3567-3568      YUFCBKRU 3569-3570
        YUFCEATP 3571-3572      YUFCSOR 3573-3574       YUDYTXYR 3575-3576
        YUDYTXN2 3577-3579      YUDYSUIC 3580-3581      YUDYDEPR 3582-3583
        YUDYFEAR 3584-3585      YUDYBKRU 3586-3587      YUDYEATP 3588-3589
        YUDYSOR 3590-3591       YUMHCRYR 3592-3593      YUMHCRN2 3594-3596
        YUMHSUIC 3597-3598      YUMHDEPR 3599-3600      YUMHFEAR 3601-3602
        YUMHBKRU 3603-3604      YUMHEATP 3605-3606      YUMHSOR 3607-3608
        YUTPSTYR 3609-3610      YUTPSTN2 3611-3613      YUTPSUIC 3614-3615
        YUTPDEPR 3616-3617      YUTPFEAR 3618-3619      YUTPBKRU 3620-3621
        YUTPEATP 3622-3623      YUTPSOR 3624-3625       YUIHTPYR 3626-3627
        YUIHTPN2 3628-3630      YUIHSUIC 3631-3632      YUIHDEPR 3633-3634
        YUIHFEAR 3635-3636      YUIHBKRU 3637-3638      YUIHEATP 3639-3640
        YUIHSOR 3641-3642       YUFDOCYR 3643-3644      YUFDOCN2 3645-3647
        YUFDSUIC 3648-3649      YUFDDEPR 3650-3651      YUFDFEAR 3652-3653
        YUFDBKRU 3654-3655      YUFDEATP 3656-3657      YUFDSOR 3658-3659
        YUSPEDYR 3660-3661      YUSHCNYR 3662-3663      YUSHSUIC 3664-3665
        YUSHDEPR 3666-3667      YUSHFEAR 3668-3669      YUSHBKRU 3670-3671
        YUSHEATP 3672-3673      YUSHSOR 3674-3675       YUJAILEV 3676-3677
        YUFCAREV 3678-3679      IRHHSIZ2 3680-3681      IIHHSIZ2 3682-3683
        IRHH65_2 3684-3685      IIHH65_2 3686-3687      IRKI17_2 3688-3689
        IIKI17_2 3690-3691      IMOTHER 3692-3693       IFATHER 3694-3695
        NRCH17_2 3696-3697      PREGNANT 3698-3699      NMERTMT2 3700-3702
        INHOSPYR 3703-3704      NMNGTHS2 3705-3707      PROXANS2 3708-3709
        PREG 3710-3711          PREG2 3712-3713         TRIMEST 3714-3715
        IRPSOC 3716-3717        IIPSOC 3718-3719        IRFAMSOC 3720-3721
        IIFAMSOC 3722-3723      IRPSSI 3724-3725        IIPSSI 3726-3727
        IRFAMSSI 3728-3729      IIFAMSSI 3730-3731      IRFSTAMP 3732-3733
        IIFSTAMP 3734-3735      IRPPMT 3736-3737        IIPPMT 3738-3739
        IRFAMPMT 3740-3741      IIFAMPMT 3742-3743      IRPSVC 3744-3745
        IIPSVC 3746-3747        IRFAMSVC 3748-3749      IIFAMSVC 3750-3751
        IRWELMOS 3752-3753      IIWELMOS 3754-3755      IRPINT 3756-3757
        IIPINT 3758-3759        IRFAMINT 3760-3761      IIFAMINT 3762-3763
        IRPCHD 3764-3765        IIPCHD 3766-3767        IRFAMCHD 3768-3769
        IIFAMCHD 3770-3771      IRPWAG 3772-3773        IIPWAG 3774-3775
        IRFAMWAG 3776-3777      IIFAMWAG 3778-3779      IRPOTH 3780-3781
        IIPOTH 3782-3783        IRFAMOTH 3784-3785      IIFAMOTH 3786-3787
        IRPINC3 3788-3789       IIPINC3 3790-3791       IRFAMIN3 3792-3793
        IIFAMIN3 3794-3795      GOVTPROG 3796-3797      HLCALLFG 3798-3799
        HLCALL99 3800-3801      MEDICARE 3802-3803      MEDICAID 3804-3805
        CHAMPUS 3806-3807       OGOVTINS 3808-3809      OGOVINS2 3810-3812
        PRVHLTIN 3813-3814      GRPHLTIN 3815-3816      HLTINALC 3817-3818
        HLTINDRG 3819-3820      HLTINMNT 3821-3822      OTHLTINS 3823-3824
        OTHLINS2 3825-3827      HLCNOTYR 3828-3829      HLCNOTMO 3830-3831
        HLCLAST 3832-3833       HLCPRIVT 3834-3835      HLCMCAID 3836-3837
        HLCMILT 3838-3839       HLCMCARE 3840-3841      HLCOGOVT 3842-3843
        HLCOTHER 3844-3845      HLCOTHS2 3846-3848      HLLLOSJB 3849-3850
        HLLMAJOB 3851-3852      HLLMASOR 3853-3854      HLLCOST 3855-3856
        HLLINELG 3857-3858      HLLNOFFR 3859-3860      HLLDIVOR 3861-3862
        HLLDEATH 3863-3864      HLLREFUS 3865-3866      HLLNONED 3867-3868
        HLLSOR 3869-3870        HLLSORS2 3871-3873      HLNVCOST 3874-3875
        HLNVOFFR 3876-3877      HLNVREF 3878-3879       HLNVNEED 3880-3881
        HLNVSOR 3882-3883       HLNVSP2 3884-3886       IRPINSUR 3887-3888
        IIPINSUR 3889-3890      IRINSUR 3891-3892       IIINSUR 3893-3894
        IRINSUR2 3895-3896      IIINSUR2 3897-3898      LANGVER 3899-3900
        QUARTER 3901-3902       GQTYPE 3903-3904        AGE2 3905-3906
        NOMARR2 3907-3908       SERVICE 3909-3910       MILSTAT 3911-3912
        HEALTH 3913-3914        IRSEX 3915-3916         IISEX 3917-3918
        IRMARIT 3919-3920       IIMARIT 3921-3922       IREDUC2 3923-3924
        IIEDUC2 3925-3926       EMPSTAT3 3927-3928      IIEMPST3 3929-3930
        EMPSTATY 3931-3932      IIEMPSTY 3933-3934      EMPSTAT4 3935-3936
        IIEMPST4 3937-3938      MOVESPY2 3939-3941      ENROLED 3942-3943
        EDUCNOW2 3944-3945      STUDNT 3946-3947        SCHDSICK 3948-3949
        SCHDSKIP 3950-3951      HSDIPLMA 3952-3953      HSGED 3954-3955
        LFSCHWH2 3956-3958      LFTSCHA2 3959-3961      RLGSVCYR 3962-3963
        RLGIMPRT 3964-3965      RLGDECSN 3966-3967      RLGFRNDS 3968-3969
        TELNO2 3970-3971        TUCHTONE 3972-3973      COLLEGE2 3974-3975
        CATAGE 3976-3977        CATAG2 3978-3979        CATAG3 3980-3981
        CATAG7 3982-3983        NEWRACE2 3984-3985      EDUCCAT2 3986-3987
        JOBSTAT2 3988-3989      JBSTATR2 3990-3991      WRKHAVJB 3992-3993
        WRKHRSWK 3994-3996      WRKINDU2 3997-3999      WRKOCCU2 4000-4002
        WRKBZCA2 4003-4004      WRKEFFRT 4005-4006      WRKEDYR 4007-4008
        WRKSLFEM 4009-4010      WRKJOBS2 4011-4013      WRKUNEMP 4014-4015
        WRKUNWKS 4016-4017      WRKLASY2 4018-4021      WRKINDY2 4022-4024
        WRKOCCY2 4025-4027      WORKDAYS 4028-4029      WORKBLAH 4030-4031
        LOCSIZE 4032-4033       DRGPLCY 4034-4035       PLCYCOV 4036-4037
        WKDRGED 4038-4039       DRGPRGM 4040-4041       USALCTST 4042-4043
        USDRGTST 4044-4045      TSTHIRE 4046-4047       TSTRAND 4048-4049
        FIRSTPOS 4050-4051      WRKHIRE 4052-4053       WORKRAND 4054-4055
        FIEXP99 4056-4057       PDEN 4058-4059          VESTR 4060-4064
        VEREP 4065-4066         ANALWT_C 4067-4074 .2   ;


* SAS LABEL STATEMENT;

LABEL
   CASEID  = 'CASE IDENTIFICATION NUMBER'
   QUESTID = 'RESPONDENT IDENTIFICATION'
   CIGEVER = 'EVER SMOKED A CIGARETTE'
   CIGOFRSM= 'IF BEST FRIEND OFFERED, WOULD YOU SMOKE CIG'
   CIGWILYR= 'DO YOU THINK YOU''LL SMOKE CIG IN NEXT 12 MOS'
   CIGTRY  = 'AGE WHEN FIRST SMOKED A CIGARETTE'
   CIGYFU  = 'YEAR OF FIRST CIGARETTE USE - RECODE'
   CIGMFU  = 'MONTH OF FIRST CIGARETTE USE - RECODE'
   CIGREC  = 'TIME SINCE LAST SMOKED CIGARETTES'
   CIG30USE= 'HOW MANY DAYS SMOKED CIG IN PAST 30 DAYS'
   CG30EST = 'BEST EST. # DAYS SMOKED CIG PAST 30 DAYS'
   CIG30AV = 'AVG # CIGS SMOKED PER DAY/ON DAY SMOKED'
   CIG30BR2= 'CIG BRAND USED MOST OFTEN PAST MO - RECODE'
   CIG30TYP= 'WHAT TYPE OF CIG SMOKED MOST PAST 30 DAYS'
   CIG30MEN= 'MENTHOL OR REG CIG SMOKED MOST PAST 30 DAYS'
   CIG30RO2= 'HAVE YOU SMOKED ROLL-OWN CIG IN PAST 30 DAYS'
   CIGDLYMO= 'EVER SMOKED CIG EVERY DAY FOR 30 DAYS'
   CIGAGE  = 'AGE WHEN FIRST STARTED SMOKING CIGARETTES EVERYDAY'
   CIG100LF= 'HAVE YOU SMOKED 100 CIGS IN YOUR LIFE'
   CHEWEVER= 'EVER USED CHEW EVEN ONCE'
   CHEWTRY = 'AGE WHEN FIRST USED CHEW'
   CHEWYFU = 'YEAR OF FIRST CHEWING TOBACCO USE - RECODE'
   CHEWMFU = 'MONTH OF FIRST CHEWING TOBACCO USE - RECODE'
   CHEWREC = 'TIME SINCE LAST USED CHEWING TOBACCO'
   CHW30USE= 'HOW MANY DAYS USED CHEW IN PAST 30 DAYS'
   CH30EST = 'PAST 30 DAY ESTIMATE OF CHEWING TOBACCO'
   CHW30BR2= 'CHEW BRAND USED MOST OFTEN PAST MO - RECODE'
   SNFEVER = 'EVER USED SNUFF'
   SNUFTRY = 'AGE WHEN FIRST USED SNUFF'
   SNUFYFU = 'YEAR OF FIRST SNUFF USE - RECODE'
   SNUFMFU = 'MONTH OF FIRST SNUFF USE - RECODE'
   SNFREC  = 'TIME SINCE LAST USED SNUFF'
   SNF30USE= 'HOW MANY DAYS USED SNUFF PAST 30 DAYS'
   SN30EST = 'BEST EST. HOW MANY DAYS USED SNUFF PST 30 DAYS'
   SNF30BR2= 'SNUFF BRAND USED MOST OFTEN PAST MO - RECODE'
   SLTTRY  = 'AGE WHEN FIRST USED ANY SMOKLESS TOB - RECODE'
   SLTYFU  = 'YEAR OF FIRST SMOKELESS TOBACCO USE - RECODE'
   SLTMFU  = 'MONTH OF FIRST SMOKELESS TOBACCO USE - RECODE'
   SLTREC  = 'TIME SINCE LAST USED ANY SMOKLESS TOB - RECODE'
   SLT30BR2= 'SMKLSS TOB BRAND USED MOST OFTEN PAST MO - RECODE'
   SLT30FAV= 'WHICH BRAND CHEW OR SNUFF USED MOST'
   CIGAREVR= 'EVER SMOKED PART OR ALL OF CIGAR'
   CIGARTRY= 'AGE WHEN FIRST SMOKED CIGAR'
   CIGARYFU= 'YEAR OF FIRST CIGAR USE - RECODE'
   CIGARMFU= 'MONTH OF FIRST CIGAR USE - RECODE'
   CIGARREC= 'TIME SINCE LAST SMOKED CIGAR'
   CGR30USE= 'HOW MANY DAYS SMOKED CIGAR IN PAST 30 DAYS'
   CI30EST = 'BEST EST. # DAYS SMOKED CIGAR PAST 30 DAYS'
   CGR30BR2= 'CIGAR BRAND USED MOST OFTEN PAST MO - RECODE'
   PIPEVER = 'EVER SMOKED PIPE TOBACCO'
   PIPE30DY= 'HAVE YOU SMOKED PIPE TOBACCO IN PAST 30 DAYS'
   ALCEVER = 'EVER HAD DRINK OF ALCOHOLIC BEVERAGE'
   ALCTRY  = 'AGE WHEN FIRST DRANK ALCOHOLIC BEVERAGE'
   ALCYFU  = 'YEAR OF FIRST ALCOHOL USE - RECODE'
   ALCMFU  = 'MONTH OF FIRST ALCOHOL USE - RECODE'
   ALCREC  = 'TIME SINCE LAST DRANK ALCOHOLIC BEVERAGE'
   ALCYRTOT= 'TOTAL # OF DAYS USED ALCOHOL IN PAST 12 MOS'
   ALTOTFG = 'TRIMMING INDICATOR FOR ALCYRTOT'
   ALFQFLG = 'TRIMMED ALCYRTOT IF R USED < 12 MOS'
   ALBSTWAY= 'EASIEST WAY TO TELL US # DAYS DRANK ALCOHOL'
   ALDAYPYR= 'NUMBER DAYS DRANK ALCOHOL IN PAST 12 MOS'
   ALDAYPMO= '# DAYS PER MONTH DRANK ALCOHOL IN PAST 12 MOS'
   ALDAYPWK= '# DAYS PER WEEK DRANK ALCOHOL IN PAST 12 MOS'
   ALCDAYS = '# DAYS HAD ONE OR MORE DRINKS PAST 30 DAYS'
   AL30EST = 'BEST ESTIMATE # DAYS HAD ONE OR MORE DRINKS'
   ALDYSFG = 'REVISION INDICATOR FOR ALCDAYS'
   NODR30A = 'USUAL # OF DRINKS PER DAY PAST 30 DAYS'
   DR5DAY  = '# DAYS HAD FIVE OR MORE DRINKS PAST 30 DAYS'
   MJEVER  = 'EVER USED MARIJUANA/HASHISH'
   MJAGE   = 'AGE WHEN FIRST USED MARIJUANA/HASHISH'
   MJYFU   = 'YEAR OF FIRST MARIJUANA/HASHISH USE - RECODE'
   MJMFU   = 'MONTH OF FIRST MARIJUANA/HASHISH USE - RECODE'
   MJREC   = 'TIME SINCE LAST USED MARIJUANA/HASHISH'
   MJYRTOT = 'TOTAL # OF DAYS USED MARIJUANA IN PAST 12 MOS'
   MRTOTFG = 'TRIMMING INDICATOR FOR MRJYRTOT'
   MJFQFLG = 'TRIMMED MJYRTOT IF R USED < 12 MOS'
   MRBSTWAY= 'EASIEST WAY TO TELL US # DAYS USED MARIJUANA/HASH'
   MRDAYPYR= '# DAYS USED MARIJUANA/HASHISH PAST 12 MONTHS'
   MRDAYPMO= '# DAYS PER MO USED MARIJUANA/HASHISH PAST 12 MOS'
   MRDAYPWK= '# DAYS PER WEEK USED MARIJUANA/HASHISH PAST 12 MOS'
   MJDAY30A= '# DAYS USED MARIJUANA/HASHISH PAST 30 DAYS'
   MR30EST = 'BEST EST. # DAYS USED MARIJUANA PAST 30 DAYS'
   COCEVER = 'EVER USED COCAINE'
   COCAGE  = 'AGE WHEN FIRST USED COCAINE'
   COCYFU  = 'YEAR OF FIRST COCAINE USE - RECODE'
   COCMFU  = 'MONTH OF FIRST COCAINE USE - RECODE'
   COCREC  = 'TIME SINCE LAST USED COCAINE'
   COCYRTOT= 'TOTAL # OF DAYS USED COCAINE IN PAST 12 MONTHS'
   CCTOTFG = 'TRIMMING INDICATOR FOR COCYRTOT'
   CCFQFLG = 'TRIMMED COCYRTOT IF R USED < 12 MOS'
   CCBSTWAY= 'EASIEST WAY TO TELL US # DAYS USED COCAINE'
   CCDAYPYR= '# DAYS USED COCAINE PAST 12 MONTHS'
   CCDAYPMO= '# DAYS PER MONTH USED COCAINE PAST 12 MONTHS'
   CCDAYPWK= '# DAYS PER WEEK USE COCAINE PAST 12 MONTHS'
   COCUS30A= '# DAYS USED COCAINE PAST 30 DAYS'
   CC30EST = 'BEST ESTIMATE # DAYS USED COCAINE PAST 30 DAYS'
   CRKEVER = 'EVER USED CRACK'
   CRKAGE  = 'AGE WHEN FIRST USED CRACK'
   CRKYFU  = 'YEAR OF FIRST CRACK USE - RECODE'
   CRKMFU  = 'MONTH OF FIRST CRACK USE - RECODE'
   CRAKREC = 'TIME SINCE LAST USED CRACK'
   CRKYRTOT= 'TOTAL # DAYS USED CRACK IN PAST 12 MONTHS'
   CRTOTFG = 'TRIMMING INDICATOR FOR CRKYRTOT'
   CRFQFLG = 'TRIMMED CRKYRTOT IF R USED < 12 MOS'
   CRBSTWAY= 'EASIEST WAY TO TELL US # DAYS USED CRACK'
   CRDAYPYR= '# DAYS USED CRACK PAST 12 MONTHS'
   CRDAYPMO= '# DAYS PER MONTH USED CRACK PAST 12 MONTHS'
   CRDAYPWK= '# DAYS PER WEEK USED CRACK PAST 12 MONTHS'
   CRKUS30A= '# DAYS USED CRACK PAST 30 DAYS'
   CR30EST = 'BEST ESTIMATE # DAYS USED CRACK PAST 30 DAYS'
   HEREVER = 'EVER USED HEROIN'
   HERAGE  = 'AGE WHEN FIRST USED HEROIN'
   HERYFU  = 'YEAR OF FIRST HEROIN USE - RECODE'
   HERMFU  = 'MONTH OF FIRST HEROIN USE - RECODE'
   HERREC  = 'TIME SINCE LAST USED HEROIN'
   HERYRTOT= 'TOTAL # OF DAYS USED HEROIN IN PAST 12 MONTHS'
   HRTOTFG = 'TRIMMING INDICATOR FOR HERYRTOT'
   HRFQFLG = 'TRIMMED HERYRTOT IF R USED < 12 MOS'
   HRBSTWAY= 'EASIEST WAY TO TELL US # DAYS USED HEROIN'
   HRDAYPYR= '# DAYS USED HEROIN PAST 12 MONTHS'
   HRDAYPMO= '# DAYS PER MONTH USED HEROIN PAST 12 MONTHS'
   HRDAYPWK= '# DAYS PER WEEK USED HEROIN PAST 12 MONTHS'
   HER30USE= '# DAYS USED HEROIN PAST 30 DAYS'
   HR30EST = 'BEST EST. # DAYS USED HEROIN PAST 30 DAYS'
   LSD     = 'EVER USED LSD ("ACID")'
   PCP     = 'EVER USED PCP ("ANGEL DUST," PHENCYCLIDINE)'
   PEYOTE  = 'EVER USED PEYOTE'
   MESC    = 'EVER USED MESCALINE'
   PSILCY  = 'EVER USED PSILOCYBIN (MUSHROOMS)'
   ECSTASY = 'EVER USED "ECSTASY" (MDMA)'
   HALNOLST= 'EVER USED OTHER HALLUCINOGEN'
   HALNEWA = 'OTHER HALLUCINOGEN - SPECIFY 1'
   HALNEWB = 'OTHER HALLUCINOGEN - SPECIFY 2'
   HALNEWC = 'OTHER HALLUCINOGEN - SPECIFY 3'
   HALNEWD = 'OTHER HALLUCINOGEN - SPECIFY 4'
   HALNEWE = 'OTHER HALLUCINOGEN - SPECIFY 5'
   HALLAGE = 'AGE WHEN FIRST USED HALLUCINOGENS'
   HALYFU  = 'YEAR OF FIRST HALLUCINOGEN USE - RECODE'
   HALMFU  = 'MONTH OF FIRST HALLUCINOGEN USE - RECODE'
   HALLREC = 'TIME SINCE LAST USED HALLUCINOGENS'
   HALYRTOT= 'TOTAL # OF DAYS USED HALLUCINOGENS IN PAST 12 MOS'
   HLTOTFG = 'TRIMMING INDICATOR FOR HALYRTOT'
   HLFQFLG = 'TRIMMED HALYRTOT IF R USED < 12 MOS'
   HLBSTWAY= 'EASIEST WAY TO TELL US # DAYS USED HALLUCINOGEN'
   HLDAYPYR= '# DAYS USED HALLUCINOGEN PAST 12 MONTHS'
   HLDAYPMO= '# DAYS PER MONTH USED HALLUCINOGEN PAST 12 MONTHS'
   HLDAYPWK= '# DAYS PER WEEK USED HALLUCINOGEN PAST 12 MONTHS'
   HAL30USE= '# DAYS USED HALLUCINOGEN PAST 30 DAYS'
   HL30EST = 'BEST EST. # DAYS USED HALLUCINOGENS PAST 30 DAYS'
   LSDAGE  = 'AGE WHEN FIRST USED LSD'
   LSDYFU  = 'YEAR OF FIRST LSD USE - RECODE'
   LSDMFU  = 'MONTH OF FIRST LSD USE - RECODE'
   LSDREC  = 'TIME SINCE LAST USED LSD'
   PCPAGE  = 'AGE WHEN FIRST USED PCP'
   PCPYFU  = 'YEAR OF FIRST PCP USE - RECODE'
   PCPMFU  = 'MONTH OF FIRST PCP USE - RECODE'
   PCPREC  = 'TIME SINCE LAST USED PCP'
   AMYLNIT = 'EVER INHALED AMYL NITRITE, "POPPERS," RUSH, ETC.'
   CLEFLU  = 'EVER INHALED CORRECTION FLUID, DEGREASER, ETC.'
   GAS     = 'EVER INHALED GASOLINE OR LIGHTER FLUID'
   GLUE    = 'EVER INHALED GLUE, SHOE POLISH, OR TOLUENE'
   ETHER   = 'EVER INHALED HALOTHANE, ETHER, OR OTHER ANESTHETIC'
   SOLVENT = 'EVER INHALED LACQUER THINNER, OTHER PAINT SOLVENTS'
   LGAS    = 'EVER INHALED LIGHTER GASES (BUTANE, PROPANE)'
   NITOXID = 'EVER INHALED NITROUS OXIDE OR "WHIPPETS"'
   SPPAINT = 'EVER INHALED SPRAY PAINTS'
   AEROS   = 'EVER INHALED OTHER AEROSOL SPRAYS'
   INHNOLST= 'EVER USED OTHER INHALANTS'
   INHNEWA = 'OTHER INHALANT - SPECIFY 1'
   INHNEWB = 'OTHER INHALANT - SPECIFY 2'
   INHNEWC = 'OTHER INHALANT - SPECIFY 3'
   INHNEWD = 'OTHER INHALANT - SPECIFY 4'
   INHNEWE = 'OTHER INHALANT - SPECIFY 5'
   INHAGE  = 'AGE WHEN FIRST USED INHALANTS'
   INHYFU  = 'YEAR OF FIRST INHALANT USE - RECODE'
   INHMFU  = 'MONTH OF FIRST INHALANT USE - RECODE'
   INHREC  = 'TIME SINCE LAST USED INHALANTS'
   INHYRTOT= 'TOTAL # OF DAYS USED INHALANT PAST 12 MONTHS'
   INTOTFG = 'TRIMMING INDICATOR FOR INHYRTOT'
   INFQFLG = 'TRIMMED INHYRTOT IF R USED < 12 MOS'
   INBSTWAY= 'EASIEST WAY TO TELL US # DAYS USED INHALANTS'
   INDAYPYR= '# DAYS USED INHALANT PAST 12 MONTHS'
   INDAYPMO= '# DAYS PER MONTH USED INHALANT PAST 12 MONTHS'
   INDAYPWK= '# DAYS PER WEEK USED INHALANT PAST 12 MONTHS'
   INHDY30A= '# DAYS USED INHALANT PAST 30 DAYS'
   IN30EST = 'BEST ESTIMATE # DAYS USED INHALANTS PAST 30 DAYS'
   DARVTYLC= 'EVER USED DARVOCET, DARVON, OR TYLENOL W/ CODEINE'
   PERCTYLX= 'EVER USED PERCOCET, PERCODAN, OR TYLOX'
   VICOLOR = 'EVER USED VICODIN, LORTAB, OR LORCET'
   ANLCARD = 'EVER USED PAIN RELIEVER BELOW RED LINE ON CARD A'
   CODEINE = 'EVER USED CODEINE "NONMEDICALLY"'
   DEMEROL = 'EVER USED DEMEROL "NONMEDICALLY"'
   DILAUD  = 'EVER USED DILAUDID "NONMEDICALLY"'
   FIORICET= 'EVER USED FIORICET "NONMEDICALLY"'
   FIORINAL= 'EVER USED FIORINAL "NONMEDICALLY"'
   HYDROCOD= 'EVER USED HYDROCODONE "NONMEDICALLY"'
   METHDON = 'EVER USED METHADONE "NONMEDICALLY"'
   MORPHINE= 'EVER USED MORPHINE "NONMEDICALLY"'
   OXYCONTN= 'EVER USED OXYCONTIN "NONMEDICALLY"'
   PHENCOD = 'EVER USED PHENAPHEN WITH CODEINE "NONMEDICALLY"'
   PROPOXY = 'EVER USED PROPOXYPHENE "NONMEDICALLY"'
   SK65A   = 'EVER USED SK65 "NONMEDICALLY"'
   STADOL  = 'EVER USED STADOL "NONMEDICALLY"'
   TALACEN = 'EVER USED TALACEN "NONMEDICALLY"'
   TALWIN  = 'EVER USED TALWIN "NONMEDICALLY"'
   TALWINNX= 'EVER USED TALWIN NX "NONMEDICALLY"'
   TRAMADOL= 'EVER USED TRAMADOL "NONMEDICALLY"'
   ULTRAM  = 'EVER USED ULTRAM "NONMEDICALLY"'
   ANLNOLST= 'EVER USED ANY OTHER PAIN RELIEVER "NONMEDICALLY"'
   ANALNEWA= 'OTHER PAIN RELIEVER - SPECIFY 1'
   ANALNEWB= 'OTHER PAIN RELIEVER - SPECIFY 2'
   ANALNEWC= 'OTHER PAIN RELIEVER - SPECIFY 3'
   ANALNEWD= 'OTHER PAIN RELIEVER - SPECIFY 4'
   ANALNEWE= 'OTHER PAIN RELIEVER - SPECIFY 5'
   ANALAGE = 'AGE WHEN FIRST USED PAIN RELIEVERS "NONMEDICALLY"'
   ANALYFU = 'YEAR OF FIRST PAIN RELIEVER USE - RECODE'
   ANALMFU = 'MONTH OF FIRST PAIN RELIEVER USE - RECODE'
   ANALREC = 'TIME SINCE LAST USED PAIN RELIEVER "NONMEDICALLY"'
   ANLYRTOT= 'TOTAL # DAYS USED PAIN RELIEVER PAST 12 MONTHS'
   PRTOTFG = 'TRIMMING INDICATOR FOR ANLYRTOT'
   PRFQFLG = 'TRIMMED ANLYRTOT IF R USED < 12 MOS'
   PRBSTWAY= 'EASIEST WAY TO TELL US # DAYS USED PAIN RELIEVER'
   PRDAYPYR= '# DAYS USED PAIN RELIEVER "NM" PAST 12 MONTHS'
   PRDAYPMO= '# DAYS PER MO USED PAIN RELIEVER "NM" PAST 12 MOS'
   PRDAYPWK= '# DAYS PER WK USED PAIN RELIEVER "NM" PAST 12 MOS'
   KLONOPIN= 'EVER USED KLONOPIN OR CLONAZEPAM'
   XNAXATVN= 'EVER USED XANAX, ALPRAZOLAM, ATIVAN, OR LORAZEPAM'
   VALMDIAZ= 'EVER USED VALIUM OR DIAZEPAM'
   TRNCARD = 'EVER USED ANY TRANQ BELOW RED LINE ON CARD B'
   ATARAX  = 'EVER USED ATARAX "NONMEDICALLY"'
   BUSPAR  = 'EVER USED BUSPAR "NONMEDICALLY"'
   EQUANIL = 'EVER USED EQUANIL "NONMEDICALLY"'
   FLEXERIL= 'EVER USED FLEXERIL "NONMEDICALLY"'
   LIBRIUM = 'EVER USED LIBRIUM "NONMEDICALLY"'
   LIMBTROL= 'EVER USED LIMBITROL "NONMEDICALLY"'
   MEPROB  = 'EVER USED MEPROBAMATE "NONMEDICALLY"'
   MILTOWN = 'EVER USED MILTOWN "NONMEDICALLY"'
   ROHYPNOL= 'EVER USED ROHYPNOL "NONMEDICALLY"'
   SERAX   = 'EVER USED SERAX "NONMEDICALLY"'
   SOMA    = 'EVER USED SOMA "NONMEDICALLY"'
   TRANXENE= 'EVER USED TRANXENE "NONMEDICALLY"'
   VISTAR  = 'EVER USED VISTARIL "NONMEDICALLY"'
   TRNOLST = 'EVER USED ANY OTHER TRANQUILIZER "NONMEDICALLY"'
   TRNEWA  = 'OTHER TRANQUILIZER - SPECIFY 1'
   TRNEWB  = 'OTHER TRANQUILIZER - SPECIFY 2'
   TRNEWC  = 'OTHER TRANQUILIZER - SPECIFY 3'
   TRNEWD  = 'OTHER TRANQUILIZER - SPECIFY 4'
   TRNEWE  = 'OTHER TRANQUILIZER - SPECIFY 5'
   TRANAGE = 'AGE WHEN FIRST USED TRANQUILIZERS "NONMEDICALLY"'
   TRANYFU = 'YEAR OF FIRST TRANQUILIZER USE - RECODE'
   TRANMFU = 'MONTH OF FIRST TRANQUILIZER USE - RECODE'
   TRANREC = 'TIME SINCE LAST USED TRANQUILIZERS "NONMEDICALLY"'
   TRNYRTOT= 'TOTAL # DAYS USED TRANQUILIZERS PAST 12 MONTHS'
   TRTOTFG = 'TRIMMING INDICATOR FOR TRNYRTOT'
   TRFQFLG = 'TRIMMED TRNYRTOT IF R USED < 12 MOS'
   TRBSTWAY= 'EASIEST WAY TO TELL US # DAYS USED TRANQUILIZER'
   TRDAYPYR= '# DAYS USED TRANQUILIZERS "NM" PAST 12 MONTHS'
   TRDAYPMO= '# DAYS PER MO USED TRANQUILIZERS "NM" PAST 12 MOS'
   TRDAYPWK= '# DAYS USED PER WK TRANQUILIZERS "NM" PAST 12 MOS'
   METHDES = 'EVER USED METHAMPHETAMINE, DESOXYN, OR METHEDRINE'
   DIETPILS= 'EVER USED DIET PILLS SUCH AS AMPHETAMINES, ETC'
   RITMPHEN= 'EVER USED RITALIN OR METHYLPHENIDATE'
   STMCARD = 'EVER USED ANY STIMULANT BELOW RED LINE ON CARD C'
   CYLERT  = 'EVER USED CYLERT "NONMEDICALLY"'
   DEXED   = 'EVER USED DEXEDRINE "NONMEDICALLY"'
   DETAMP  = 'EVER USED DEXTROAMPHET "NONMEDICALLY"'
   DIDREX  = 'EVER USED DIDREX "NONMEDICALLY"'
   ESKAT   = 'EVER USED ESKATROL "NONMEDICALLY"'
   IONAMIN = 'EVER USED IONAMIN "NONMEDICALLY"'
   MAZANOR = 'EVER USED MAZANOR "NONMEDICALLY"'
   OBLA    = 'EVER USED OBEDRIN-LA "NONMEDICALLY"'
   PLEGINE = 'EVER USED PLEGINE "NONMEDICALLY"'
   PRELUDIN= 'EVER USED PRELUDIN "NONMEDICALLY"'
   SANOREX = 'EVER USED SANOREX "NONMEDICALLY"'
   TENUATE = 'EVER USED TENUATE "NONMEDICALLY"'
   STMNOLST= 'EVER USED ANY OTHER STIMULANT "NONMEDICALLY"'
   STIMNEWA= 'OTHER STIMULANT - SPECIFY 1'
   STIMNEWB= 'OTHER STIMULANT - SPECIFY 2'
   STIMNEWC= 'OTHER STIMULANT - SPECIFY 3'
   STIMNEWD= 'OTHER STIMULANT - SPECIFY 4'
   STIMNEWE= 'OTHER STIMULANT - SPECIFY 5'
   STIMAGE = 'AGE WHEN FIRST USED STIMULANTS "NONMEDICALLY"'
   STIMYFU = 'YEAR OF FIRST STIMULANT USE - RECODE'
   STIMMFU = 'MONTH OF FIRST STIMULANT USE - RECODE'
   STIMREC = 'TIME SINCE LAST USED STIMULANTS "NONMEDICALLY"'
   STMYRTOT= 'TOTAL # DAYS USED STIMULANTS PAST 12 MONTHS'
   STTOTFG = 'TRIMMING INDICATOR FOR STMYRTOT'
   STFQFLG = 'TRIMMED STMYRTOT IF R USED < 12 MOS'
   STBSTWAY= 'EASIEST WAY TO TELL US # DAYS USED STIMULANT'
   STDAYPYR= '# DAYS USED STIMULANT "NM" PAST 12 MONTHS'
   STDAYPMO= '# DAYS PER MO USED STIMULANT "NM" PAST 12 MONTHS'
   STDAYPWK= '# DAYS PER WEEK USED STIMULANT "NM" PAST 12 MONTHS'
   METHAGE = 'AGE WHEN 1ST USED METHAMPH, DESOXYN, METHEDRINE'
   METHYFU = 'YEAR OF FIRST METHAMPHETAMINE USE - RECODE'
   METHMFU = 'MONTH OF FIRST METHAMPHETAMINE USE - RECODE'
   METHREC = 'TIME SINCE LAST USED METHAMPHETAMINES'
   METHAQ  = 'EVER USED METHAQUALONE, SOPOR, OR QUAALUDE'
   NEMBBARB= 'EVER USED BARBITURATES SUCH AS NEMBUTAL, ETC'
   RESTTMAZ= 'EVER USED RESTORIL OR TEMAZEPAM'
   SEDCARD = 'EVER USED ANY SEDATIVES BELOW RED LINE ON CARD D'
   AMYTAL  = 'EVER USED AMYTAL "NONMEDICALLY"'
   BUTISOL = 'EVER USED BUTISOL "NONMEDICALLY"'
   CHHYD   = 'EVER USED CHLORAL HYDRATE "NONMEDICALLY"'
   DALMANE = 'EVER USED DALMANE "NONMEDICALLY"'
   HALCION = 'EVER USED HALCION "NONMEDICALLY"'
   PHENOBAR= 'EVER USED PHENOBARBITAL "NONMEDICALLY"'
   PLACIDYL= 'EVER USED PLACIDYL "NONMEDICALLY"'
   TUINAL  = 'EVER USED TUINAL "NONMEDICALLY"'
   SEDNOLST= 'EVER USED ANY OTHER SEDATIVE "NONMEDICALLY"'
   SEDNEWA = 'OTHER SEDATIVES - SPECIFY 1'
   SEDNEWB = 'OTHER SEDATIVES - SPECIFY 2'
   SEDNEWC = 'OTHER SEDATIVES - SPECIFY 3'
   SEDNEWD = 'OTHER SEDATIVES - SPECIFY 4'
   SEDNEWE = 'OTHER SEDATIVES - SPECIFY 5'
   SEDAGE  = 'AGE WHEN FIRST USED SEDATIVES "NONMEDICALLY"'
   SEDYFU  = 'YEAR OF FIRST SEDATIVE USE - RECODE'
   SEDMFU  = 'MONTH OF FIRST SEDATIVE USE - RECODE'
   SEDREC  = 'TIME SINCE LAST USED SEDATIVES "NONMEDICALLY"'
   SEDYRTOT= 'TOTAL # OF DAYS USED SEDATIVES PAST 12 MONTHS'
   SVTOTFG = 'TRIMMING INDICATOR FOR SEDYRTOT'
   SVFQFLG = 'TRIMMED SEDYRTOT IF R USED < 12 MOS'
   SVBSTWAY= 'EASIEST WAY TO TELL US # DAYS USED SEDATIVE'
   SVDAYPYR= '# DAYS USED SEDATIVE "NM" PAST 12 MONTHS'
   SVDAYPMO= '# DAYS PER MONTH USED SEDATIVE "NM" PAST 12 MONTHS'
   SVDAYPWK= '# DAYS PER WEEK USED SEDATIVE "NM" PAST 12 MONTHS'
   IRCIGRC = 'CIGARETTE RECENCY - IMPUTATION REVISED'
   IICIGRC = 'CIGARETTE RECENCY - IMPUTATION INDICATOR'
   II2CIGRC= 'CIGARETTE RECENCY-DETAILED IMPUTATION INDICATOR'
   IRCGRRC = 'CIGAR RECENCY - IMPUTATION REVISED'
   IICGRRC = 'CIGAR - IMPUTATION INDICATOR'
   II2CGRRC= 'CIGAR RECENCY-DETAILED IMPUTATION INDICATOR'
   IRPIPLF = 'LIFETIME PIPE USE - IMPUTATION REVISED'
   IIPIPLF = 'LIFETIME PIPE USE - IMPUTATION INDICATOR'
   IRPIPMN = 'PAST MONTH PIPE USE - IMPUTATION REVISED'
   IIPIPMN = 'PAST MONTH PIPE USE - IMPUTATION INDICATOR'
   IRSLTRC = 'SMOKELESS TOBACCO RECENCY-IMPUTATION REVISED'
   IISLTRC = 'SMOKELESS TOBACCO RECENCY-IMPUTATION INDICATOR'
   II2SLTRC= 'SMOKELESS TOBACCO RECENCY-DETAILED IMP INDICATOR'
   IRCHWRC = 'CHEWING TOBACCO RECENCY - IMPUTATION REVISED'
   IICHWRC = 'CHEWING TOBACCO RECENCY - IMPUTATION INDICATOR'
   II2CHWRC= 'CHEWING TOBACCO RECENCY-DETAILED IMP INDICATOR'
   IRSNFRC = 'SNUFF RECENCY - IMPUTATION REVISED'
   IISNFRC = 'SNUFF RECENCY - IMPUTATION INDICATOR'
   II2SNFRC= 'SNUFF RECENCY-DETAILED IMPUTATION INDICATOR'
   IRALCRC = 'ALCOHOL RECENCY - IMPUTATION REVISED'
   IIALCRC = 'ALCOHOL RECENCY - IMPUTATION INDICATOR'
   II2ALCRC= 'ALCOHOL RECENCY-DETAILED IMPUTATION INDICATOR'
   IRMJRC  = 'MARIJUANA RECENCY - IMPUTATION REVISED'
   IIMJRC  = 'MARIJUANA RECENCY - IMPUTATION INDICATOR'
   II2MJRC = 'MARIJUANA RECENCY-DETAILED IMPUTATION INDICATOR'
   IRCOCRC = 'COCAINE RECENCY - IMPUTATION REVISED'
   IICOCRC = 'COCAINE RECENCY - IMPUTATION INDICATOR'
   II2COCRC= 'COCAINE RECENCY-DETAILED IMPUTATION INDICATOR'
   IRCRKRC = 'CRACK RECENCY - IMPUTATION REVISED'
   IICRKRC = 'CRACK RECENCY - IMPUTATION INDICATOR'
   II2CRKRC= 'CRACK RECENCY-DETAILED IMPUTATION INDICATOR'
   IRHERRC = 'HEROIN RECENCY - IMPUTATION REVISED'
   IIHERRC = 'HEROIN RECENCY - IMPUTATION INDICATOR'
   II2HERRC= 'HEROIN RECENCY-DETAILED IMPUTATION INDICATOR'
   IRHALRC = 'HALLUCINOGEN RECENCY - IMPUTATION REVISED'
   IIHALRC = 'HALLUCINOGEN RECENCY - IMPUTATION INDICATOR'
   II2HALRC= 'HALLUCINOGEN RECENCY-DETAILED IMPUTATION INDICATOR'
   IRLSDRC = 'LSD RECENCY - IMPUTATION REVISED'
   IILSDRC = 'LSD RECENCY - IMPUTATION INDICATOR'
   II2LSDRC= 'LSD RECENCY-DETAILED IMPUTATION INDICATOR'
   IRPCPRC = 'PCP RECENCY - IMPUTATION REVISED'
   IIPCPRC = 'PCP RECENCY - IMPUTATION INDICATOR'
   II2PCPRC= 'PCP RECENCY-DETAILED IMPUTATION INDICATOR'
   IRINHRC = 'INHALANT RECENCY - IMPUTATION REVISED'
   IIINHRC = 'INHALANT RECENCY - IMPUTATION INDICATOR'
   II2INHRC= 'INHALANT RECENCY-DETAILED IMPUTATION INDICATOR'
   IRANLRC = 'PAIN RELIEVER RECENCY - IMPUTATION REVISED'
   IIANLRC = 'PAIN RELIEVER RECENCY - IMPUTATION INDICATOR'
   II2ANLRC= 'PAIN RELIEVER RECENCY-DETAILED IMP INDICATOR'
   IRTRNRC = 'TRANQUILIZER RECENCY - IMPUTATION REVISED'
   IITRNRC = 'TRANQUILIZER RECENCY - IMPUTATION INDICATOR'
   II2TRNRC= 'TRANQUILIZER RECENCY-DETAILED IMPUTATION INDICATOR'
   IRSTMRC = 'STIMULANT RECENCY - IMPUTATION REVISED'
   IISTMRC = 'STIMULANT RECENCY - IMPUTATION INDICATOR'
   II2STMRC= 'STIMULANT RECENCY-DETAILED IMPUTATION INDICATOR'
   IRMTHRC = 'METHAMPHETAMINE RECENCY-IMPUTATION REVISED'
   IIMTHRC = 'METHAMPHETAMINE - IMPUTATION INDICATOR'
   II2MTHRC= 'METHAMPHETAMINE RECENCY-DETAILED IMP INDICATOR'
   IRSEDRC = 'SEDATIVE RECENCY - IMPUTATION REVISED'
   IISEDRC = 'SEDATIVE RECENCY - IMPUTATION INDICATOR'
   II2SEDRC= 'SEDATIVE RECENCY-DETAILED IMPUTATION INDICATOR'
   IRALCFY = 'ALCOHOL FREQUENCY PAST YEAR - IMPUTATION REVISED'
   IIALCFY = 'ALCOHOL FREQUENCY PAST YEAR - IMPUTATION INDICATOR'
   II2ALCFY= 'ALCOHOL FREQ PAST YEAR - DETAILED IMP INDICATOR'
   IRMJFY  = 'MARIJUANA FREQUENCY PAST YEAR - IMPUTATION REVISED'
   IIMJFY  = 'MARIJUANA FREQUENCY PAST YEAR - IMP INDICATOR'
   II2MJFY = 'MARIJUANA FREQ PAST YEAR - DETAILED IMP INDICATOR'
   IRCOCFY = 'COCAINE FREQUENCY PAST YEAR - IMPUTATION REVISED'
   IICOCFY = 'COCAINE FREQUENCY PAST YEAR - IMPUTATION INDICATOR'
   II2COCFY= 'COCAINE FREQ PAST YEAR - DETAILED IMP INDICATOR'
   IRCRKFY = 'CRACK FREQUENCY PAST YEAR - IMPUTATION REVISED'
   IICRKFY = 'CRACK FREQUENCY PAST YEAR - IMPUTATION INDICATOR'
   II2CRKFY= 'CRACK FREQ PAST YEAR - DETAILED IMP INDICATOR'
   IRHERFY = 'HEROIN FREQUENCY PAST YEAR - IMPUTATION REVISED'
   IIHERFY = 'HEROIN FREQUENCY PAST YEAR - IMPUTATION INDICATOR'
   II2HERFY= 'HEROIN FREQ PAST YEAR - DETAILED IMP INDICATOR'
   IRHALFY = 'HALL FREQUENCY PAST YEAR - IMPUTATION REVISED'
   IIHALFY = 'HALL FREQUENCY PAST YEAR - IMPUTATION INDICATOR'
   II2HALFY= 'HALL FREQ PAST YEAR - DETAILED IMP INDICATOR'
   IRINHFY = 'INHALANT FREQUENCY PAST YEAR - IMPUTATION REVISED'
   IIINHFY = 'INHALANT FREQUENCY PAST YEAR - IMP INDICATOR'
   II2INHFY= 'INHALANT FREQ PAST YEAR - DETAILED IMP INDICATOR'
   IRANLFY = 'PAIN RELIEVER FREQ PAST YEAR-IMPUTATION REVISED'
   IIANLFY = 'PAIN RELIEVER FREQ PAST YEAR - IMP INDICATOR'
   II2ANLFY= 'PAIN RELIEVER FREQ PAST YR-DETAILED IMP INDICATOR'
   IRTRNFY = 'TRANQUILIZER FREQ PAST YEAR-IMPUTATION REVISED'
   IITRNFY = 'TRAN FREQUENCY PAST YEAR - IMPUTATION INDICATOR'
   II2TRNFY= 'TRAN FREQ PAST YEAR - DETAILED IMP INDICATOR'
   IRSTMFY = 'STIMULANT FREQUENCY PAST YEAR-IMPUTATION REVISED'
   IISTMFY = 'STIM FREQUENCY PAST YEAR - IMPUTATION INDICATOR'
   II2STMFY= 'STIM FREQ PAST YEAR - DETAILED IMP INDICATOR'
   IRSEDFY = 'SEDATIVE FREQUENCY PAST YEAR-IMPUTATION REVISED'
   IISEDFY = 'SEDATIVE FREQUENCY PAST YEAR - IMP INDICATOR'
   II2SEDFY= 'SEDATIVE FREQ PAST YEAR - DETAILED IMP INDICATOR'
   IRCIGFM = 'CIGARETTE FREQ PAST MONTH - IMPUTATION REVISED'
   IICIGFM = 'CIGARETTE FREQ PAST MONTH - IMPUTATION INDICATOR'
   II2CIGFM= 'CIGARETTE FREQ PAST MONTH - DETAILED IMP INDICATOR'
   IRCGRFM = 'CIGAR FREQUENCY PAST MONTH - IMPUTATION REVISED'
   IICGRFM = 'CIGAR FREQUENCY PAST MONTH - IMPUTATION INDICATOR'
   II2CGRFM= 'CIGAR FREQUENCY PST MONTH - DETAILED IMP INDICATOR'
   IRCHWFM = 'CHEWING TOB FREQUENCY PST MON - IMPUTATION REVISED'
   IICHWFM = 'CHEWING TOB FREQ PAST MONTH-IMPUTATION INDICATOR'
   II2CHWFM= 'CHEWING TOB FREQ PST MONTH-DETAILED IMP INDICATOR'
   IRSNFFM = 'SNUFF FREQUENCY PAST MONTH - IMPUTATION REVISED'
   IISNFFM = 'SNUFF FREQUENCY PAST MONTH - IMPUTATION INDICATOR'
   II2SNFFM= 'SNUFF FREQUENCY PST MONTH - DETAILED IMP INDICATOR'
   IRALCFM = 'ALCOHOL FREQUENCY PAST MONTH - IMPUTATION REVISED'
   IIALCFM = 'ALCOHOL FREQ PAST MONTH - IMPUTATION INDICATOR'
   II2ALCFM= 'ALCOHOL FREQ PST MONTH - DETAILED IMP INDICATOR'
   IRALCD5 = '5+ ALC DRNKS PAST MONTH - IMP REVISED (DR5DAY)'
   IIALCD5 = '5+ ALC DRNKS PAST MONTH - IMPUTATION INDICATOR'
   II2ALCD5= '5+ ALC DRINKS PAST MONTH - DETAILED IMP INDICATOR'
   IRMJFM  = 'MARIJUANA FREQUENCY PAST MONTH - IMP REVISED'
   IIMJFM  = 'MARIJUANA FREQUENCY PAST MONTH - IMP INDICATOR'
   II2MJFM = 'MARIJUANA FREQ PAST MONTH - DETAILED IMP INDICATOR'
   IRCOCFM = 'COCAINE FREQUENCY PAST MONTH - IMPUTATION REVISED'
   IICOCFM = 'COCAINE FREQ PAST MONTH - IMPUTATION INDICATOR'
   II2COCFM= 'COCAINE FREQ PAST MONTH - DETAILED IMP INDICATOR'
   IRCRKFM = 'CRACK FREQUENCY PAST MONTH - IMPUTATION REVISED'
   IICRKFM = 'CRACK FREQUENCY PAST MONTH - IMPUTATION INDICATOR'
   II2CRKFM= 'CRACK FREQ PAST MONTH - DETAILED IMP INDICATOR'
   IRHERFM = 'HEROIN FREQUENCY PAST MONTH - IMPUTATION REVISED'
   IIHERFM = 'HEROIN FREQUENCY PAST MONTH - IMPUTATION INDICATOR'
   II2HERFM= 'HEROIN FREQ PAST MONTH - DETAILED IMP INDICATOR'
   IRHALFM = 'HALLUCINOGEN FREQ PAST MONTH - IMPUTATION REVISED'
   IIHALFM = 'HALL FREQUENCY PAST MONTH - IMPUTATION INDICATOR'
   II2HALFM= 'HALL FREQ PAST MONTH - DETAILED IMP INDICATOR'
   IRINHFM = 'INHALANT FREQUENCY PAST MONTH - IMP REVISED'
   IIINHFM = 'INHALANT FREQUENCY PAST MONTH - IMP INDICATOR'
   II2INHFM= 'INHALANT FREQ PAST MONTH - DETAILED IMP INDICATOR'
   IRCIGAGE= 'IMPUTATION-REVISED CIGARETTE AGE OF FIRST USE'
   IICIGAGE= 'IRCIGAGE IMPUTATION INDICATOR'
   IRCIGYFU= 'IMPUTATION-REVISED CIGARETTE YEAR OF FIRST USE'
   IICIGYFU= 'IRCIGYFU IMPUTATION INDICATOR'
   IRCDUAGE= 'IMPUTATION-REVISED DAILY CIG AGE OF FIRST USE'
   IICDUAGE= 'IRCDUAGE IMPUTATION INDICATOR'
   IRCDUYFU= 'IMPUTATION-REVISED DAILY CIG YEAR OF FIRST USE'
   IICDUYFU= 'IRCDUYFU IMPUTATION INDICATOR'
   IRCGRAGE= 'IMPUTATION-REVISED CIGAR AGE OF FIRST USE'
   IICGRAGE= 'IRCGRAGE IMPUTATION INDICATOR'
   IRCGRYFU= 'IMPUTATION-REVISED CIGAR YEAR OF FIRST USE'
   IICGRYFU= 'IRCGRYFU IMPUTATION INDICATOR'
   IRSNFAGE= 'IMPUTATION-REVISED SNUFF AGE OF FIRST USE'
   IISNFAGE= 'IRSNFAGE IMPUTATION INDICATOR'
   IRSNFYFU= 'IMPUTATION-REVISED SNUFF YEAR OF FIRST USE'
   IISNFYFU= 'IRSNFYFU IMPUTATION INDICATOR'
   IRCHWAGE= 'IMPUTATION-REVISED CHEWING TOB AGE FIRST USE'
   IICHWAGE= 'IRCHWAGE IMPUTATION INDICATOR'
   IRCHWYFU= 'IMPUTATION-REVISED CHEWING TOB YEAR FIRST USE'
   IICHWYFU= 'IRCHWYFU IMPUTATION INDICATOR'
   IRSLTAGE= 'IMPUTATION-REVISED SMOKELESS TOB AGE FIRST USE'
   IISLTAGE= 'IRSLTAGE IMPUTATION INDICATOR'
   IRSLTYFU= 'IMPUTATION-REVISED SMOKELESS TOB YEAR OF FIRST USE'
   IISLTYFU= 'IRSNFYFU IMPUTATION INDICATOR'
   IRALCAGE= 'IMPUTATION-REVISED ALCOHOL AGE OF FIRST USE'
   IIALCAGE= 'IRALCAGE IMPUTATION INDICATOR'
   IRALCYFU= 'IMPUTATION-REVISED ALCOHOL YEAR OF FIRST USE'
   IIALCYFU= 'IRALCYFU IMPUTATION INDICATOR'
   IRMJAGE = 'IMPUTATION-REVISED MARIJUANA AGE OF FIRST USE'
   IIMJAGE = 'IRMJAGE IMPUTATION INDICATOR'
   IRMJYFU = 'IMPUTATION-REVISED MARIJUANA YEAR OF FIRST USE'
   IIMJYFU = 'IRMJYFU IMPUTATION INDICATOR'
   IRCOCAGE= 'IMPUTATION-REVISED COCAINE AGE OF FIRST USE'
   IICOCAGE= 'IRCOCAGE IMPUTATION INDICATOR'
   IRCOCYFU= 'IMPUTATION-REVISED COCAINE YEAR OF FIRST USE'
   IICOCYFU= 'IRCOCYFU IMPUTATION INDICATOR'
   IRCRKAGE= 'IMPUTATION-REVISED CRACK AGE OF FIRST USE'
   IICRKAGE= 'IRCRKAGE IMPUTATION INDICATOR'
   IRCRKYFU= 'IMPUTATION-REVISED CRACK YEAR OF FIRST USE'
   IICRKYFU= 'IRCRKYFU IMPUTATION INDICATOR'
   IRHERAGE= 'IMPUTATION-REVISED HEROIN AGE OF FIRST USE'
   IIHERAGE= 'IRHERAGE IMPUTATION INDICATOR'
   IRHERYFU= 'IMPUTATION-REVISED HEROIN YEAR OF FIRST USE'
   IIHERYFU= 'IRHERYFU IMPUTATION INDICATOR'
   IRHALAGE= 'IMPUTATION-REVISED HALLUCINOGEN AGE OF FIRST USE'
   IIHALAGE= 'IRHALAGE IMPUTATION INDICATOR'
   IRHALYFU= 'IMPUTATION-REVISED HALLUCINOGEN YEAR OF FIRST USE'
   IIHALYFU= 'IRHALYFU IMPUTATION INDICATOR'
   IRLSDAGE= 'IMPUTATION-REVISED LSD AGE OF FIRST USE'
   IILSDAGE= 'IRLSDAGE IMPUTATION INDICATOR'
   IRLSDYFU= 'IMPUTATION-REVISED LSD YEAR OF FIRST USE'
   IILSDYFU= 'IRLSDYFU IMPUTATION INDICATOR'
   IRPCPAGE= 'IMPUTATION-REVISED PCP AGE OF FIRST USE'
   IIPCPAGE= 'IRPCPAGE IMPUTATION INDICATOR'
   IRPCPYFU= 'IMPUTATION-REVISED PCP YEAR OF FIRST USE'
   IIPCPYFU= 'IRPCPYFU IMPUTATION INDICATOR'
   IRINHAGE= 'IMPUTATION-REVISED INHALANT AGE OF FIRST USE'
   IIINHAGE= 'IRINHAGE IMPUTATION INDICATOR'
   IRINHYFU= 'IMPUTATION-REVISED INHALANT YEAR OF FIRST USE'
   IIINHYFU= 'IRINHYFU IMPUTATION INDICATOR'
   IRANLAGE= 'IMPUTATION-REVISED PAIN RELIEVERS AGE OF FIRST USE'
   IIANLAGE= 'IRANLAGE IMPUTATION INDICATOR'
   IRANLYFU= 'IMPUTATION-REVISED PAIN RELIEVER YEAR OF FIRST USE'
   IIANLYFU= 'IRANLYFU IMPUTATION INDICATOR'
   IRTRNAGE= 'IMPUTATION-REVISED TRANQUILIZER AGE OF FIRST USE'
   IITRNAGE= 'IRTRNAGE IMPUTATION INDICATOR'
   IRTRNYFU= 'IMPUTATION-REVISED TRANQUILIZER YEAR OF FIRST USE'
   IITRNYFU= 'IRTRNYFU IMPUTATION INDICATOR'
   IRSTMAGE= 'IMPUTATION-REVISED STIMULANTS AGE OF FIRST USE'
   IISTMAGE= 'IRSTMAGE IMPUTATION INDICATOR'
   IRSTMYFU= 'IMPUTATION-REVISED STIMULANTS YEAR OF FIRST USE'
   IISTMYFU= 'IRSTMYFU IMPUTATION INDICATOR'
   IRMTHAGE= 'IMPUTATION-REVISED METHAMPHETAMINE AGE FIRST USE'
   IIMTHAGE= 'IRMTHAGE IMPUTATION INDICATOR'
   IRMTHYFU= 'IMPUTATION-REVISED METHAMPHETAMINE YEAR FIRST USE'
   IIMTHYFU= 'IRMTHYFU IMPUTATION INDICATOR'
   IRSEDAGE= 'IMPUTATION-REVISED SEDATIVES AGE OF FIRST USE'
   IISEDAGE= 'IRSEDAGE IMPUTATION INDICATOR'
   IRSEDYFU= 'IMPUTATION-REVISED SEDATIVES YEAR OF FIRST USE'
   IISEDYFU= 'IRSEDYFU IMPUTATION INDICATOR'
   CIGFLAG = 'CIGARETTES - EVER USED'
   CIGYR   = 'CIGARETTES - PAST YEAR USE'
   CIGMON  = 'CIGARETTES - PAST MONTH USE'
   CGRFLAG = 'CIGAR - EVER USED'
   CGRYR   = 'CIGAR - PAST YEAR USE'
   CGRMON  = 'CIGAR - PAST MONTH USE'
   PIPFLAG = 'PIPES - EVER USED'
   PIPMON  = 'PIPES - PAST MONTH USE'
   SMKFLAG = 'SMOKELESS TOBACCO - EVER USED'
   SMKYR   = 'SMOKELESS TOBACCO - PAST YEAR USE'
   SMKMON  = 'SMOKELESS TOBACCO - PAST MONTH USE'
   CHWFLAG = 'CHEWING TOBACCO - EVER USED'
   CHWYR   = 'CHEWING TOBACCO - PAST YEAR USE'
   CHWMON  = 'CHEWING TOBACCO - PAST MONTH USE'
   SNFFLAG = 'SNUFF - EVER USED'
   SNFYR   = 'SNUFF - PAST YEAR USE'
   SNFMON  = 'SNUFF - PAST MONTH USE'
   TOBFLAG = 'ANY TOBACCO - EVER USED'
   TOBYR   = 'ANY TOBACCO - PAST YEAR USE'
   TOBMON  = 'ANY TOBACCO - PAST MONTH USE'
   CIGBRND2= 'CIGARETTE BRAND USED MOST OFTEN IN PAST MONTH'
   CGRBRND2= 'CIGAR BRAND USED MOST OFTEN IN PAST MONTH'
   SMKBRND2= 'SMOKELESS TOBACCO BRAND USED MOST OFTEN IN PST MON'
   CIGCMPNY= 'CIG COMPANY FOR BRAND PAST 30 DYS - RECODE'
   ALCFLAG = 'ALCOHOL - EVER USED'
   ALCYR   = 'ALCOHOL - PAST YEAR USE'
   ALCMON  = 'ALCOHOL - PAST MONTH USE'
   MRJFLAG = 'MARIJUANA - EVER USED'
   MRJYR   = 'MARIJUANA - PAST YEAR USE'
   MRJMON  = 'MARIJUANA - PAST MONTH USE'
   COCFLAG = 'COCAINE - EVER USED'
   COCYR   = 'COCAINE - PAST YEAR USE'
   COCMON  = 'COCAINE - PAST MONTH USE'
   CRKFLAG = '"CRACK" - EVER USED'
   CRKYR   = '"CRACK" - PAST YEAR USE'
   CRKMON  = '"CRACK" - PAST MONTH USE'
   HERFLAG = 'HEROIN - EVER USED'
   HERYR   = 'HEROIN - PAST YEAR USE'
   HERMON  = 'HEROIN - PAST MONTH USE'
   HALFLAG = 'HALLUCINOGENS - EVER USED'
   HALYR   = 'HALLUCINOGENS - PAST YEAR USE'
   HALMON  = 'HALLUCINOGENS - PAST MONTH USE'
   LSDFLAG = 'LSD - EVER USED'
   LSDYR   = 'LSD - PAST YEAR USE'
   LSDMON  = 'LSD - PAST MONTH USE'
   PCPFLAG = 'PCP - EVER USED'
   PCPYR   = 'PCP - PAST YEAR USE'
   PCPMON  = 'PCP - PAST MONTH USE'
   INHFLAG = 'INHALANTS - EVER USED'
   INHYR   = 'INHALANTS - PAST YEAR USE'
   INHMON  = 'INHALANTS - PAST MONTH USE'
   ANLFLAG = 'PAIN RELIEVERS - EVER USED'
   ANLYR   = 'PAIN RELIEVERS - PAST YEAR USE'
   ANLMON  = 'PAIN RELIEVERS - PAST MONTH USE'
   TRQFLAG = 'TRANQUILIZERS - EVER USED'
   TRQYR   = 'TRANQUILIZERS - PAST YEAR USE'
   TRQMON  = 'TRANQUILIZERS - PAST MONTH USE'
   STMFLAG = 'STIMULANTS - EVER USED'
   STMYR   = 'STIMULANTS - PAST YEAR USE'
   STMMON  = 'STIMULANTS - PAST MONTH USE'
   MTHFLAG = 'METHAMPHETAMINES-EVER USED'
   MTHYR   = 'METHAMPHETAMINES - PAST YEAR USE'
   MTHMON  = 'METHAMPHETAMINES - PAST MONTH USE'
   SEDFLAG = 'SEDATIVES - EVER USED'
   SEDYR   = 'SEDATIVES - PAST YEAR USE'
   SEDMON  = 'SEDATIVES - PAST MONTH USE'
   PSYFLAG2= 'ANY PSYCHOTHERAPEUTICS - EVER USED'
   PSYYR2  = 'ANY PSYCHOTHERAPEUTICS - PAST YEAR USE'
   PSYMON2 = 'ANY PSYCHOTHERAPEUTICS - PAST MONTH USE'
   SUMFLAG = 'ANY ILLICIT DRUG - EVER USED'
   SUMYR   = 'ANY ILLICIT DRUG - PAST YEAR USE'
   SUMMON  = 'ANY ILLICIT DRUG - PAST MONTH USE'
   MJOFLAG = 'MARIJUANA ONLY - EVER USED'
   MJOYR2  = 'MARIJUANA ONLY - PAST YEAR USE'
   MJOMON2 = 'MARIJUANA ONLY - PAST MONTH USE'
   IEMFLAG = 'ILLICIT DRUG EXCEPT FOR MARIJUANA - EVER USED'
   IEMYR   = 'ILLICIT DRUG EXCEPT FOR MARIJUANA - PAST YEAR USED'
   IEMMON  = 'ILLICIT DRUG EXCEPT FOR MARIJUANA-PAST MONTH USED'
   BINGEDRK= 'BINGE ALCOHOL USE PAST 30 DAYS'
   HVYDRK2 = 'HEAVY ALCOHOL USE PAST 30 DAYS'
   BINGEHVY= 'LEVEL OF ALCOHOL USE PAST MONTH'
   PEYOTE2 = 'EVER USED PEYOTE'
   MESC2   = 'EVER USED MESCALINE'
   PSILCY2 = 'EVER USED PSILOCYBIN (MUSHROOMS)'
   ECSTASY2= 'EVER USED "ECSTASY" (MDMA)'
   AMYLNIT2= 'EVER INHALED AMYL NITRITE, "POPPERS," RUSH, ETC.'
   CLEFLU2 = 'EVER INHALED CORRECTION FLUID, DEGREASER, ETC.'
   GAS2    = 'EVER INHALED GASOLINE OR LIGHTER FLUID'
   GLUE2   = 'EVER INHALED GLUE, SHOE POLISH, OR TOLUENE'
   ETHER2  = 'EVER INHALED HALOTHANE, ETHER, OR OTHER ANESTHETIC'
   SOLVENT2= 'EVER INHALED LACQUER THINNER, OTHER PAINT SOLVENTS'
   LGAS2   = 'EVER INHALED LIGHTER GASES (BUTANE, PROPANE)'
   NITOXID2= 'EVER INHALED NITROUS OXIDE OR "WHIPPETS"'
   SPPAINT2= 'EVER INHALED SPRAY PAINTS'
   AEROS2  = 'EVER INHALED OTHER AEROSOL SPRAYS'
   DARVTYL2= 'EVER USED DARVOCET, DARVON, TYLENOL W/CODEINE'
   PERCTYL2= 'EVER USED PERCOCET, PERCODAN, TYLOX'
   VICOLOR2= 'EVER USED VICODIN, LORTAB, LORCET'
   CODEINE2= 'EVER USED CODEINE'
   DEMEROL2= 'EVER USED DEMEROL'
   DILAUD2 = 'EVER USED DILAUDID'
   FIORICT2= 'EVER USED FIORICET'
   FIORINL2= 'EVER USED FIORINAL'
   HYDROCD2= 'EVER USED HYDROCODONE'
   METHDON2= 'EVER USED METHADONE'
   MORPHIN2= 'EVER USED MORPHINE'
   OXYCONT2= 'EVER USED OXYCONTIN'
   PHENCOD2= 'EVER USED PHENAPHEN WITH CODEINE'
   PROPOXY2= 'EVER USED PROPOXYPHENE'
   SK65A2  = 'EVER USED SK65'
   STADOL2 = 'EVER USED STADOL'
   TALACEN2= 'EVER USED TALACEN'
   TALWIN2 = 'EVER USED TALWIN'
   TALWINX2= 'EVER USED TALWIN NX'
   TRAMADL2= 'EVER USED TRAMADOL'
   ULTRAM2 = 'EVER USED ULTRAM'
   OTHANL  = 'EVER USED OTHER PAIN RELIEVERS'
   KLONOPI2= 'EVER USED KLONOPIN OR CLONAZEPAM'
   XNAXATV2= 'EVER USED XANAX, ALPRAZOLAM, ATVIAN'
   VALMDIA2= 'EVER USED VALIUM OR DIAZEPAM FOR FEELING'
   ATARAX2 = 'EVER USED ATARAX'
   BUSPAR2 = 'EVER USED BUSPAR'
   EQUANIL2= 'EVER USED EQUANIL'
   FLEXERL2= 'EVER USED FLEXERIL'
   LIBRIUM2= 'EVER USED LIBRIUM'
   LIMBTRL2= 'EVER USED LIMBITROL'
   MEPROB2 = 'EVER USED MEPROBAMATE'
   MILTOWN2= 'EVER USED MILTOWN'
   ROHYPNL2= 'EVER USED ROHYPNOL'
   SERAX2  = 'EVER USED SERAX'
   SOMA2   = 'EVER USED SOMA'
   TRANXEN2= 'EVER USED TRANXENE'
   VISTAR2 = 'EVER USED VISTARIL'
   OTHTRN  = 'EVER USED OTHER TRANQUILIZERS'
   METHDES2= 'EVER USED METHAMPHETAMINE, DESOXYN, OR METHEDRINE'
   DIETPIL2= 'EVER USED DIET PILLS FOR FEELING CAUSED'
   RITMPHE2= 'EVER USED RITALIN FOR FEELING CAUSED'
   CYLERT2 = 'EVER USED CYLERT'
   DEXED2  = 'EVER USED DEXEDRINE'
   DETAMP2 = 'EVER USED DEXTROAMPHETAMINE'
   DIDREX2 = 'EVER USED DIDREX'
   ESKAT2  = 'EVER USED ESKATROL'
   IONAMIN2= 'EVER USED IONAMIN'
   MAZANOR2= 'EVER USED MAZANOR'
   OBLA2   = 'EVER USED OBEDRIN-LA'
   PLEGINE2= 'EVER USED PLEGINE'
   PRELUDN2= 'EVER USED PRELUDIN'
   SANOREX2= 'EVER USED SANOREX'
   TENUATE2= 'EVER USED TENUATE'
   OTHSTM  = 'EVER USED OTHER STIMULANTS'
   METHAQ2 = 'EVER USED METHAQUALONE, SOPOR, QUALLUDE'
   NEMBBAR2= 'EVER USED BARBITURATES FOR FEELING'
   RESTTMA2= 'EVER USED RESTORIL OR TEMAZEPAM'
   AMYTAL2 = 'EVER USED AMYTAL'
   BUTISOL2= 'EVER USED BUTISOL'
   CHHYD2  = 'EVER USED CHLORAL HYDRATE'
   DALMANE2= 'EVER USED DALMANE'
   HALCION2= 'EVER USED HALCION'
   PHENOBR2= 'EVER USED PHENOBARBITAL'
   PLACIDY2= 'EVER USED PLACIDYL'
   TUINAL2 = 'EVER USED TUINAL'
   OTHSED  = 'EVER USED OTHER SEDATIVES'
   ALCAFU  = 'ALCOHOL AGE OF FIRST USE - CATEGORIZED RECODE'
   MJAFU   = 'MARIJUANA AGE OF FIRST USE - CATEGORIZED RECODE'
   COCAFU  = 'COCAINE AGE OF FIRST USE - CATEGORIZED RECODE'
   HERAFU  = 'HEROIN AGE OF FIRST USE - CATEGORIZED RECODE'
   HALAFU  = 'HALLUCINOGEN AGE OF FIRST USE - CATEGORIZED RECODE'
   INHAFU  = 'INHALANT AGE OF FIRST USE - CATEGORIZED RECODE'
   ANLAFU  = 'PAIN RELIEVER AGE OF FIRST USE - CATEGORIZED RECOD'
   TRNAFU  = 'TRANQUILIZER AGE OF FIRST USE - CATEGORIZED RECODE'
   STMAFU  = 'STIMULANT AGE OF FIRST USE - CATEGORIZED RECODE'
   SEDAFU  = 'SEDATIVE AGE OF FIRST USE - CATEGORIZED RECODE'
   CIGAFU  = 'CIGARETTE AGE OF FIRST USE - CATEGORIZED RECODE'
   CGRAFU  = 'CIGAR AGE OF FIRST USE - CATEGORIZED RECODE'
   SLTAFU  = 'SMOKELSS TOB AGE OF FIRST USE - CATEGORIZED RECODE'
   MRJYDAYS= '# OF DAYS USED MARIJUANA IN PAST YEAR'
   COCYDAYS= '# OF DAYS USED COCAINE IN PAST YEAR'
   HALYDAYS= '# OF DAYS USED HALLUCINOGENS IN PAST YEAR'
   INHYDAYS= '# OF DAYS USED INHALANTS IN PAST YEAR'
   ALCYDAYS= '# OF DAYS USED ALCOHOL IN PAST YEAR'
   MRJMDAYS= '# OF DAYS USED MARIJUANA PAST MONTH'
   COCMDAYS= '# OF DAYS USED COCAINE IN PAST MONTH'
   HALMDAYS= '# OF DAYS USED HALLUCINOGENS IN PAST MONTH'
   INHMDAYS= '# OF DAYS USED INHALANTS IN PAST MONTH'
   ALCMDAYS= '# OF DAYS USED ALCOHOL IN PAST MONTH'
   CIGMDAYS= '# OF DAYS USED CIG IN PAST MONTH'
   CIGPDAY = '# OF CIGARETTES SMOKED PER DAY AMONG DAILY SMOKERS'
   CG05    = 'HAVE YOU SMOKED CIG IN PAST 30 DAYS'
   CG06    = 'TIME SINCE LAST SMOKE A CIG (IF NOT PAST MO)'
   CG06DK  = 'BEST GUESS TIME SINCE LAST SMOKE A CIGARETTE'
   CG06RE  = 'RECONSIDER ANSWERING TIME SINCE LAST SMOKE A CIG'
   CG19    = 'HAVE YOU USED CHEW IN PAST 30 DAYS'
   CG20    = 'TIME SINCE LAST USED CHEW (IF NOT PAST MO)'
   CG20DK  = 'BEST GUESS HOW LONG SINCE USED CHEWING TOBACCO'
   CG20RE  = 'PLEASE ANSWER HOW LONG SINCE USED CHEWING TOBACCO'
   CG27    = 'HAVE YOU USED SNUFF IN PAST 30 DAYS'
   CG28    = 'TIME SINCE LAST USE SNUFF (IF NOT PAST MO)'
   CG28DK  = 'BEST GUESS TIME SINCE LAST USE SNUFF'
   CG28RE  = 'RECONSIDER ANSWERING TIME SINCE LAST USE SNUFF'
   CG36    = 'HAVE YOU SMOKED CIGAR IN PAST 30 DAYS'
   CG37    = 'TIME SINCE LAST SMOKED CIGAR (IF NOT PAST MO)'
   CG37DK  = 'BEST GUESS TIME SINCE LAST SMOKED CIGAR'
   CG37RE  = 'RECONSIDER ANSWERING TIME SINCE LAST SMOKED CIGAR'
   CG43    = 'HAVE YOU SMOKED PIPE TOBACCO IN PAST 30 DAYS'
   ALLAST3 = 'TIME SINCE LAST DRANK ALCOHOLIC BEVERAGE'
   ALRECDK = 'BEST GUESS TIME SINCE LAST DRANK ALCOHOLIC BEV'
   ALRECRE = 'RECONSIDER ANSWERING TIME SINCE LST DRANK ALC BEV'
   TOTDRINK= 'TOTAL # OF DAYS USED ALCOHOL IN PAST 12 MOS'
   ALFRAME3= 'EASIEST WAY TO TELL US # DAYS DRANK ALCOHOL'
   ALYRAVE = 'NUMBER DAYS DRANK ALCOHOL IN PAST 12 MOS'
   ALMONAVE= '# DAYS PER MONTH DRANK ALCOHOL IN PAST 12 MOS'
   ALWKAVE = '# DAYS PER WEEK DRANK ALCOHOL IN  PAST 12 MOS'
   MJLAST3 = 'TIME SINCE LAST USED MARIJUANA/HASHISH'
   MJRECDK = 'BEST GUESS TIME SINCE LAST USED MARIJUANA/HASHISH'
   MJRECRE = 'RECONSIDER TIME SINCE LAST USED MARIJUANA/HASHISH'
   TOTMJ   = 'TOTAL # OF DAYS USED MARIJUANA IN PAST 12 MOS'
   MJFRAME3= 'EASIEST WAY TO TELL US # DAYS USED MARIJUANA/HASH'
   MJYRAVE = '# DAYS USED MARIJUANA/HASHISH PAST 12 MONTHS'
   MJMONAVE= '# DAYS PER MOS USED MARIJUANA/HASHISH PAST 12 MOS'
   MJWKAVE = '# DAYS PER WEEK USED MARIJUANA/HASHISH PAST 12 MOS'
   CCLAST3 = 'TIME SINCE LAST USED COCAINE'
   CCRECDK = 'BEST GUESS TIME SINCE LAST USED COCAINE'
   CCRECRE = 'RECONSIDER ANSWERING TIME SINCE LAST USED COCAINE'
   TOTCOKE = 'TOTAL # OF DAYS USED COCAINE IN PAST 12 MONTHS'
   CCFRAME3= 'EASIEST WAY TO TELL US # DAYS USED COCAINE'
   CCYRAVE = '# DAYS USED COCAINE PAST 12 MONTHS'
   CCMONAVE= '# DAYS PER MONTH USED COCAINE PAST 12 MONTHS'
   CCWKAVE = '# DAYS PER WEEK USED COCAINE PAST 12 MONTHS'
   CKLAST3 = 'TIME SINCE LAST USED CRACK'
   CKRECDK = 'BEST GUESS TIME SINCE LAST USED CRACK'
   CKRECRE = 'RECONSIDER TIME SINCE LAST USED CRACK'
   TOTCRACK= 'TOTAL # DAYS USED CRACK IN PAST 12 MONTHS'
   CKFRAME3= 'EASIEST WAY TO TELL US # DAYS USED CRACK'
   CKYRAVE = '# DAYS USED CRACK PAST 12 MONTHS'
   CKMONAVE= '# DAYS PER MONTH USED CRACK PAST 12 MONTHS'
   CKWKAVE = '# DAYS PER WEEK USED CRACK PAST 12 MONTHS'
   HELAST3 = 'TIME SINCE LAST USED HEROIN'
   HERECDK = 'BEST GUESS TIME SINCE LAST USED HEROIN'
   HERECRE = 'RECONSIDER ANSWERING TIME SINCE LAST USED HEROIN'
   TOTHERO = 'TOTAL # OF DAYS USED HEROIN IN PAST 12 MONTHS'
   HEFRAME3= 'EASIEST WAY TO TELL US # DAYS USED HEROIN'
   HEYRAVE = '# DAYS USED HEROIN PAST 12 MONTHS'
   HEMONAVE= '# DAYS PER MONTH USED HEROIN PAST 12 MONTHS'
   HEWKAVE = '# DAYS PER WEEK USED HEROIN PAST 12 MONTHS'
   LSLAST  = 'TIME SINCE LAST USED HALLUCINOGEN'
   LSRECDK = 'BEST GUESS TIME SINCE LAST USED HALLUCINOGEN'
   LSRECRE = 'RECONSIDER TIME SINCE LAST USED HALLUCINOGEN'
   TOTHALL = 'TOTAL # OF DAYS USED HALLUCINOGENS IN PAST 12 MOS'
   LSFRAME3= 'EASIEST WAY TO TELL US # DAYS USED HALLUCINOGEN'
   LSYRAVE = '# DAYS USED HALLUCINOGEN PAST 12 MONTHS'
   LSMONAVE= '# DAYS PER MONTH USED HALLUCINOGEN PAST 12 MONTHS'
   LSWKAVE = '# DAYS PER WEEK USED HALLUCINOGEN PAST 12 MONTHS'
   LS10    = 'TIME SINCE USED LSD LAST'
   LS16    = 'HOW LONG SINCE USED PCP'
   INLAST  = 'TIME SINCE LAST USED INHALANT'
   INRECDK = 'BEST GUESS HOW LONG SINCE LAST USED INHALANTS'
   INRECRE = 'RECONSIDER HOW LONG SINCE LAST USED INHALANTS'
   TOTINHAL= 'TOTAL # OF DAYS USED INHALANT PAST 12 MONTHS'
   INFRAME3= 'EASIEST WAY TO TELL US # DAYS USED INHALANT'
   INYRAVE = '# DAYS USED INHALANT PAST 12 MONTHS'
   INMONAVE= '# DAYS PER MONTH USED INHALANT PAST 12 MONTHS'
   INWKAVE = '# DAYS PER WEEK USED INHALANT PAST 12 MONTHS'
   PR09    = 'TIME SINCE LAST USED PAIN RELIEVER "NONMEDICALLY"'
   PRRECDK = 'BEST GUESS LAST USED PAIN RELIEVER "NONMEDICALLY"'
   PRRECRE = 'RECONSIDER LAST USED PAIN RELIEVER "NONMEDICALLY"'
   PR10    = 'EASIEST WAY TO TELL US # DAYS USED PAIN RELIEVER'
   PR11    = '# DAYS USED PAIN RELIEVER "NM" PAST 12 MONTHS'
   PR12    = '# DAYS PER MO USED PAIN RELIEVER "NM" PAST 12 MOS'
   PR13    = '# DAYS PER WK USED PAIN RELIEVER "NM" PAST 12 MOS'
   TR09    = 'TIME SINCE LAST USED TRANQUILIZER "NONMEDICALLY"'
   TRRECDK = 'BEST GUESS HOW LONG SINCE USD TRANQUILIZER "NM"'
   TRRECRE = 'RECONSIDER HOW LONG SINCE USD TRANQUILIZER "NM"'
   TR10    = 'EASIEST WAY TO TELL US # DAYS USED TRANQUILIZER'
   TR11    = '# DAYS USED TRANQUILIZERS "NM" PAST 12 MONTHS'
   TR12    = '# DAYS PER MO USED TRANQUILIZERS "NM" PAST 12 MOS'
   TR13    = '# DAYS USED PER WK TRANQUILIZERS "NM" PAST 12 MOS'
   ST09    = 'TIME SINCE LAST USED STIMULANT "NONMEDICALLY"'
   STRECDK = 'BEST GUESS TIME SINCE LAST USED STIMULANTS "NM"'
   STRECRE = 'RECONSIDER TIME SINCE LAST USED STIMULANTS "NM"'
   ST10    = 'EASIEST WAY TO TELL US # DAYS USED STIMULANT'
   ST11    = '# DAYS USED STIMULANT "NM" PAST 12 MONTHS'
   ST12    = '# DAYS PER MO USED STIMULANT "NM" PAST 12 MONTHS'
   ST13    = '# DAYS PER WEEK USED STIMULANT "NM" PAST 12 MONTHS'
   ST19    = 'HOW LONG SINCE USED METHAMPH, DESOXYN, METHEDRINE'
   SV09    = 'TIME SINCE LAST USED SEDATIVE "NONMEDICALLY"'
   SVRECDK = 'BEST GUESS TIME SINCE LAST USED SEDATIVE "NM"'
   SVRECRE = 'RECONSIDER TIME SINCE LAST USED SEDATIVE "NM"'
   SV10    = 'EASIEST WAY TO TELL US # DAYS USED SEDATIVE'
   SV11    = '# DAYS USED SEDATIVE "NM" PAST 12 MONTHS'
   SV12    = '# DAYS PER MONTH USED SEDATIVE "NM" PAST 12 MONTHS'
   SV13    = '# DAYS PER WEEK USED SEDATIVE "NM" PAST 12 MONTHS'
   HERSMOKE= 'EVER SMOKED HEROIN'
   HRSMKREC= 'TIME SINCE LAST SMOKED HEROIN'
   HERSNIFF= 'EVER SNIFFED HEROIN'
   HRSNFREC= 'TIME SINCE LAST SNIFFED HEROIN'
   GNNDLLIF= 'EVER USED A NEEDLE TO INJECT DRUGS NOT PRESCRIBED'
   COCNEEDL= 'EVER USED NEEDLE TO INJECT COCAINE'
   CONDLREC= 'TIME SINCE LAST USED NEEDLE TO INJECT COCAINE'
   HERNEEDL= 'EVER USED NEEDLE TO INJECT HEROIN'
   HRNDLREC= 'TIME SINCE LAST USED NEEDLE TO INJECT HEROIN'
   STNEEDLE= 'EVER USED NEEDLE TO INJECT STIMULANT'
   STNDLREC= 'TIME SINCE LAST USED NEEDLE TO INJECT STIMULANT'
   GNNDREUS= 'LAST TIME REUSED NEEDLE USED BEFORE'
   GNNDLSH1= 'LAST NEEDLE HAD BEEN USED BY SOMEONE ELSE'
   GNNDCLEN= 'USED BLEACH TO CLEAN LAST NEEDLE BEFORE USE'
   GNNDLSH2= 'SOMEONE ELSE USED LAST NEEDLE AFTER YOU'
   GNNDGET2= 'HOW DID YOU GET THE NEEDLE LAST TIME'
   NEDLRECC= 'MOST RECENT TIME USED COC/HER/STM WITH A NEEDLE'
   NEDFLAG4= 'NEEDLE USE (ANY DRUG) - EVER USED'
   HERSMOK2= 'EVER SMOKED HEROIN'
   HERSNIF2= 'EVER SNIFFED HEROIN'
   NEDHER  = 'EVER USED A NEEDLE TO INJECT HEROIN'
   NEDCOC  = 'EVER USED A NEEDLE TO INJECT COCAINE'
   NEDSTM  = 'EVER USED A NEEDLE TO INJECT STIMULANT'
   RSKPKCIG= 'RISK SMOKING 1 OR MORE PACKS CIGARETTES PER DAY'
   RSKMJOCC= 'RISK SMOKING MARIJUANA ONCE A MONTH'
   RSKMJREG= 'RISK SMOKING MARIJUANA ONCE OR TWICE A WEEK'
   RKTRYLSD= 'RISK TRYING LSD ONCE OR TWICE'
   RKLSDREG= 'RISK USING LSD ONCE OR TWICE A WEEK'
   RKTRYHER= 'RISK TRYING HEROIN ONCE OR TWICE'
   RKHERREG= 'RISK USING HEROIN ONCE OR TWICE A WEEK'
   RKCOCOCC= 'RISK USING COCAINE ONCE A MONTH'
   RKCOCREG= 'RISK USING COCAINE ONCE OR TWICE A WEEK'
   RK5ALDLY= 'RISK HAVING 4 OR 5 DRINKS NEARLY EVERY DAY'
   RK5ALWK = 'RISK HAVING 5 OR MORE DRINKS ONCE OR TWICE A WEEK'
   RSKDIFMJ= 'HOW DIFFICULT TO GET MARIJUANA'
   RKDIFLSD= 'HOW DIFFICULT TO GET LSD'
   RKDIFCOC= 'HOW DIFFICULT TO GET COCAINE'
   RKDIFCRK= 'HOW DIFFICULT TO GET "CRACK"'
   RKDIFHER= 'HOW DIFFICULT TO GET HEROIN'
   RSKSELL = 'APPROACHED BY SOMEONE SELLING ILL DRUG PST 30 DYS'
   RKFQDNGR= 'GET A REAL KICK OUT OF DOING DANGEROUS THINGS'
   RKFQRSKY= 'LIKE TO TEST YOURSELF BY DOING RISKY THINGS'
   RKFQPBLT= 'WEAR A SEATBELT WHEN RIDE FRONT PASS SEAT OF CAR'
   RKFQDBLT= 'WEAR A SEATBELT WHEN YOU DRIVE A CAR'
   GRSKPKCG= 'GREAT RISK:  SMOKE 1+ PACKS CIGARETTES PER DAY'
   GRSKCREG= 'GREAT RISK:  USE COCAINE 1-2 TIMES PER WEEK'
   GRSKCOCC= 'GREAT RISK:  USE COCAINE ONCE A MONTH'
   GRSKMREG= 'GREAT RISK:  USE MARIJUANA 1-2 TIMES PER WEEK'
   GRSKMOCC= 'GREAT RISK:  USE MARIJUANA ONCE A MONTH'
   GRSKHTRY= 'GREAT RISK:  TRYING HEROIN ONCE OR TWICE'
   GRSKHREG= 'GREAT RISK:  USE HEROIN 1-2 TIMES PER WEEK'
   GRSKLTRY= 'GREAT RISK:  TRYING LSD ONCE OR TWICE'
   GRSKLREG= 'GREAT RISK:  USE LSD 1-2 TIMES PER WEEK'
   GRSKD4_5= 'GREAT RISK:  HAVE 4-5 ALC DRINKS PER DAY'
   GRSKD5WK= 'GREAT RISK:  HAVE 5+ ALC DRINKS 1-2 TIMES PER WEEK'
   RDIFMJ  = 'MARIJUANA FAIRLY OR EASY TO OBTAIN'
   RDIFCOC = 'COCAINE FAIRLY OR EASY TO OBTAIN'
   RDIFHER = 'HEROIN FAIRLY OR EASY TO OBTAIN'
   RDIFLSD = 'LSD FAIRLY OR EASY TO OBTAIN'
   RDIFCRK = 'CRACK FAIRLY OR EASY TO OBTAIN'
   APPSELDG= 'APPROACHED BY SOMEONE SELLING DRUGS'
   CIGLOTTM= 'SPENT MONTH/MORE GETTING/SMKG CIGS PAST 12 MOS'
   CIGLIMIT= 'SET LIMITS ON CIG USE PAST 12 MONTHS'
   CIGKPLMT= 'ABLE TO KEEP LIMITS OR SMOKE MORE PAST 12 MOS'
   CIGNDMOR= 'NEEDED MORE CIGS TO GET SAME EFFECT PAST 12 MOS'
   CIGLSEFX= 'SMKG SAME # CIGS HAD LESS EFFECT PAST 12 MOS'
   CIGCUTDN= 'WANT/TRY TO CUT DOWN/STOP SMKG PAST 12 MOS'
   CIGCUTEV= 'ABLE TO CUT/STOP CIGS EVERY TIME PAST 12 MOS'
   CIGCUT1X= 'CUT DOWN OR STOP SMKG AT LEAST ONCE PAST 12 MOS'
   CIGWD4SX= 'HAD 4+ CIG WITHDRAW SYMPTOMS PST 12 MOS'
   CIGWDSMT= 'HAD 4+ CIG WDRAW SYM AT SAME TIME PST 12 MOS'
   CIGEMOPB= 'CIG CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS'
   CIGEMCTD= 'CONTD TO SMOKE CIGS DESPITE EMOT PRBS'
   CIGPHLPB= 'ANY PHYS PRBS CAUSED/WORSND BY CIGS PST 12 MOS'
   CIGPHCTD= 'CONTD TO SMOKE CIGS DESPITE PHYS PRBS'
   CIGLSACT= 'LESS ACTIVITIES B/C OF CIG USE PAST 12 MOS'
   CIGPKCRT= 'BUY CIGARETTES BY PACK OR CARTON'
   CIGPDPAK= 'PRICE PAID FOR LAST PACK OF CIGS'
   CIGPDCRT= 'PRICE PAID FOR LAST CARTON OF CIGS'
   ALCLOTTM= 'SPENT MONTH/MORE GETTING/DRNKG ALC PAST 12 MOS'
   ALCGTOVR= 'MONTH+ SPENT GETTING OVER ALC EFFECTS PST 12 MOS'
   ALCLIMIT= 'SET LIMITS ON ALCOHOL USE PAST 12 MONTHS'
   ALCKPLMT= 'ABLE TO KEEP LIMITS OR DRANK MORE PAST 12 MOS'
   ALCNDMOR= 'NEEDED MORE ALC TO GET SAME EFFECT PST 12 MOS'
   ALCLSEFX= 'DRNKG SAME AMT ALC HAD LESS EFFECT PAST 12 MOS'
   ALCCUTDN= 'WANT/TRY TO CUT DOWN/STOP DRNKG PAST 12 MOS'
   ALCCUTEV= 'ABLE TO CUT/STOP DRNKG EVERY TIME PAST 12 MOS'
   ALCCUT1X= 'CUT DOWN OR STOP DRNKG AT LEAST ONCE PAST 12 MOS'
   ALCWD2SX= 'HAD 2+ ALC WITHDRAWAL SYMPTOMS PST 12 MOS'
   ALCWDSMT= 'HAD 2+ ALC WDRAW SYM AT SAME TIME PST 12 MOS'
   ALCEMOPB= 'ALC CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS'
   ALCEMCTD= 'CONTD TO DRINK ALC DESPITE EMOT PRBS'
   ALCPHLPB= 'ANY PHYS PRBS CAUSED/WORSND BY ALC PST 12 MOS'
   ALCPHCTD= 'CONTD TO DRINK ALC DESPITE PHYS PRBS'
   ALCLSACT= 'LESS ACTIVITIES B/C OF ALC USE PAST 12 MOS'
   ALCSERPB= 'ALC CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS'
   ALCPDANG= 'DRNK ALC AND DO DANGEROUS ACTIVITIES PST 12 MOS'
   ALCLAWTR= 'DRNK ALC CAUSE PRBS WITH LAW PAST 12 MOS'
   ALCFMFPB= 'DRNK ALC CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS'
   ALCFMCTD= 'CONTD TO DRINK ALC DESPITE PRBS W/ FAM/FRNDS'
   MRJLOTTM= 'SPENT MONTH/MORE GETTING/USING MJ PAST 12 MOS'
   MRJGTOVR= 'MONTH+ SPENT GETTING OVER MJ EFFECTS PST 12 MOS'
   MRJLIMIT= 'SET LIMITS ON MARIJUANA USE PAST 12 MONTHS'
   MRJKPLMT= 'ABLE TO KEEP LIMITS OR USE MORE MJ PAST 12 MOS'
   MRJNDMOR= 'NEEDED MORE MJ TO GET SAME EFFECT PST 12 MOS'
   MRJLSEFX= 'USING SAME AMT MJ HAD LESS EFFECT PAST 12 MOS'
   MRJCUTDN= 'WANT/TRY TO CUT DOWN/STOP USING MJ PST 12 MOS'
   MRJCUTEV= 'ABLE TO CUT/STOP USING MJ EVERY TIME PST 12 MOS'
   MRJEMOPB= 'MJ CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS'
   MRJEMCTD= 'CONTD USING MARIJUANA DESPITE EMOT PRBS'
   MRJPHLPB= 'ANY PHYS PRBS CAUSED/WORSND BY MJ PST 12 MOS'
   MRJPHCTD= 'CONTD TO USE MARIJUANA DESPITE PHYS PRBS'
   MRJLSACT= 'LESS ACTIVITIES B/C OF MJ USE PAST 12 MOS'
   MRJSERPB= 'MJ CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS'
   MRJPDANG= 'USING MJ AND DO DANGEROUS ACTIVITIES PST 12 MOS'
   MRJLAWTR= 'USING MJ CAUSE PRBS WITH LAW PAST 12 MOS'
   MRJFMFPB= 'USING MJ CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS'
   MRJFMCTD= 'CONTD TO USE MJ DESPITE PRBS W/ FAM/FRNDS'
   COCLOTTM= 'SPENT MONTH/MORE GETTING/USING COC PAST 12 MOS'
   COCGTOVR= 'MONTH+ SPENT GETTING OVER COC EFFECTS PST 12 MOS'
   COCLIMIT= 'SET LIMITS ON COCAINE USE PAST 12 MONTHS'
   COCKPLMT= 'ABLE TO KEEP LIMITS OR USED MORE COC PST 12 MOS'
   COCNDMOR= 'NEEDED MORE COC TO GET SAME EFFECT PST 12 MOS'
   COCLSEFX= 'USING SAME AMT COC HAD LESS EFFECT PAST 12 MOS'
   COCCUTDN= 'WANT/TRY TO CUT DOWN/STOP USING COC PAST 12 MOS'
   COCCUTEV= 'ABLE TO CUT/STOP USING COC EVERY TIME PAST 12 MOS'
   COCCUT1X= 'CUT DOWN/STOP USING COC AT LEAST 1X PST 12 MOS'
   COCFLBLU= 'WHEN CUT DOWN ON COC, FELT BLUE PAST 12 MONTHS'
   COCWD2SX= 'HAD 2+ COC WITHDRAWAL SYMPTOMS PST 12 MOS'
   COCWDSMT= 'HAD 2+ COC WDRAW SYM AT SAME TIME PAST 12 MOS'
   COCEMOPB= 'COC CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS'
   COCEMCTD= 'CONTD TO USE COC DESPITE EMOT PRBS'
   COCPHLPB= 'ANY PHYS PRBS CAUSED/WORSND BY COC PST 12 MOS'
   COCPHCTD= 'CONTD TO USE COC DESPITE PHYS PRBS'
   COCLSACT= 'LESS ACTIVITIES B/C OF COC USE PAST 12 MOS'
   COCSERPB= 'COC CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS'
   COCPDANG= 'USING COC AND DO DANGEROUS ACTIVITIES PST 12 MOS'
   COCLAWTR= 'USING COC CAUSE PRBS WITH LAW PAST 12 MOS'
   COCFMFPB= 'USING COC CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS'
   COCFMCTD= 'CONTD TO USE COC DESPITE PRBS W/ FAM/FRNDS'
   HERLOTTM= 'SPENT MON/MORE GETTING/USING HEROIN PST 12 MOS'
   HERGTOVR= 'MONTH+ SPENT GETTING OVR HEROIN EFFECTS PST 12 MO'
   HERLIMIT= 'SET LIMITS ON HEROIN USE PAST 12 MONTHS'
   HERKPLMT= 'ABLE TO KEEP LIMT OR USE MORE HEROIN PST 12 MOS'
   HERNDMOR= 'NEEDED MORE HEROIN TO GET SME EFFECT PST 12 MOS'
   HERLSEFX= 'USING SME AMT HEROIN HAD LESS EFFECT PST 12 MOS'
   HERCUTDN= 'WANT/TRY CUT DOWN/STOP USNG HEROIN PST 12 MOS'
   HERCUTEV= 'ABLE TO CUT/STOP USNG HEROIN EVRY TIME PST 12 MOS'
   HERCUT1X= 'CUT DOWN/STOP USNG HEROIN AT LEAST 1X PST 12 MOS'
   HERWD3SX= 'HAD 3+ HEROIN WITHDRAWAL SYMPTOMS PST 12 MOS'
   HERWDSMT= 'HAD 3+ HEROIN WDRAW SYM SAME TIME PST 12 MOS'
   HEREMOPB= 'HEROIN CAUSE PRBS W/EMOT/NERVES PAST 12 MOS'
   HEREMCTD= 'CONTD TO USE HEROIN DESPITE EMOT PRBS'
   HERPHLPB= 'ANY PHYS PRBS CAUSED/WORSND BY HEROIN PST 12 MOS'
   HERPHCTD= 'CONTD TO USE HEROIN DESPITE PHYS PRBS'
   HERLSACT= 'LESS ACTIVITIES B/C OF HEROIN USE PAST 12 MOS'
   HERSERPB= 'HEROIN CAUSE SER PRB AT HOM/WRK/SCH PST 12 MOS'
   HERPDANG= 'USING HEROIN & DO DANGEROUS ACTIVS PST 12 MOS'
   HERLAWTR= 'USING HEROIN CAUSE PRBS WITH LAW PAST 12 MOS'
   HERFMFPB= 'USING HEROIN CAUSE PRBS W/FAM/FRNDS PST 12 MOS'
   HERFMCTD= 'CONTD TO USE HEROIN DESPITE PRBS W/FAM/FRNDS'
   HALLOTTM= 'SPENT MON/MORE GETTING/USING HALLUC PST 12 MOS'
   HALGTOVR= 'MONTH+ SPENT GETTING OVR HALLUC EFFECTS PST 12 MO'
   HALLIMIT= 'SET LIMITS ON HALLUCINOGEN USE PAST 12 MONTHS'
   HALKPLMT= 'ABLE TO KEEP LIMT OR USE MORE HALLUC PST 12 MOS'
   HALNDMOR= 'NEEDED MORE HALLUC TO GET SME EFFECT PST 12 MOS'
   HALLSEFX= 'USING SME AMT HALLUC HAD LESS EFFECT PAST 12 MOS'
   HALCUTDN= 'WANT/TRY CUT DOWN/STOP USING HALLUC PST 12 MOS'
   HALCUTEV= 'ABLE TO CUT/STOP USING HALLUC EVRY TIME PST 12 MO'
   HALEMOPB= 'HALLUC CAUSE PRBS W/EMOT/NERVES PAST 12 MOS'
   HALEMCTD= 'CONTD TO USE HALLUC DESPITE EMOT PRBS'
   HALPHLPB= 'ANY PHYS PRBS CAUSED/WORSND BY HALLUC PST 12 MOS'
   HALPHCTD= 'CONTD TO USE HALLUC DESPITE PHYS PRBS'
   HALLSACT= 'LESS ACTIVITES B/C OF HALLUC USE PAST 12 MOS'
   HALSERPB= 'HALLUC CAUSE SER PRBS AT HOM/WRK/SCH PST 12 MOS'
   HALPDANG= 'USING HALLUC & DO DANGEROUS ACTIVS PST 12 MOS'
   HALLAWTR= 'USING HALLUC CAUSE PRBS WITH LAW PAST 12 MOS'
   HALFMFPB= 'USING HALLUC CAUSE PRBS W/FAM/FRNDS PST 12 MOS'
   HALFMCTD= 'CONTD TO USE HALLUC DESPITE PRBS W/FAM/FRNDS'
   INHLOTTM= 'SPENT MONTH/MORE GETTING/USING INH PAST 12 MOS'
   INHGTOVR= 'MONTH+ SPENT GETTING OVER INH EFFECTS PST 12 MOS'
   INHLIMIT= 'SET LIMITS ON INHALANT USE PAST 12 MONTHS'
   INHKPLMT= 'ABLE TO KEEP LIMITS OR USE MORE INH PAST 12 MOS'
   INHNDMOR= 'NEEDED MORE INH TO GET SAME EFFECT PST 12 MOS'
   INHLSEFX= 'USING SAME AMT INH HAD LESS EFFECT PAST 12 MOS'
   INHCUTDN= 'WANT/TRY TO CUT DOWN/STOP USING INH PAST 12 MOS'
   INHCUTEV= 'ABLE TO CUT/STOP USING INH EVERY TIME PAST 12 MOS'
   INHEMOPB= 'INH CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS'
   INHEMCTD= 'CONTD TO USE INHALANTS DESPITE EMOT PRBS'
   INHPHLPB= 'ANY PHYS PRBS CAUSED/WORSND BY INH PST 12 MOS'
   INHPHCTD= 'CONTD TO USE INHALANTS DESPITE PHYS PRBS'
   INHLSACT= 'LESS ACTIVITIES B/C OF INH USE PAST 12 MOS'
   INHSERPB= 'INH CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS'
   INHPDANG= 'USING INH AND DO DANGEROUS ACTIVITIES PST 12 MOS'
   INHLAWTR= 'USING INH CAUSE PRBS WITH LAW PAST 12 MOS'
   INHFMFPB= 'USING INH CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS'
   INHFMCTD= 'CONTD TO USE INH DESPITE PRBS W/ FAM/FRNDS'
   ANLLOTTM= 'SPENT MON/MORE GETTNG/USNG PN RLVR PST 12 MOS'
   ANLGTOVR= 'MON+ SPNT GETTING OVER PN RLVR EFFECTS PST 12 MOS'
   ANLLIMIT= 'SET LIMITS ON PAIN RELIEVER USE PAST 12 MONTHS'
   ANLKPLMT= 'ABLE TO KEEP LIMT/USE MORE PN RLVR PST 12 MOS'
   ANLNDMOR= 'NEEDED MORE PN RLVR TO GET SME EFFECT PST 12 MOS'
   ANLLSEFX= 'USING SME AMT PN RLVR HAD LESS EFFECT PST 12 MOS'
   ANLCUTDN= 'WANT/TRY CUT DOWN/STOP USNG PN RLVR PST 12 MOS'
   ANLCUTEV= 'ABLE TO CUT/STOP USNG PN RLVR EVRY TIME PST 12 MO'
   ANLCUT1X= 'CUT DOWN/STOP USNG PN RLVR AT LEAST 1X PST 12 MOS'
   ANLWD3SX= 'HAD 3+ PN RLVR WITHDRAWAL SYMPTOMS PST 12 MOS'
   ANLWDSMT= 'HAD 3+ PN RLVR WDRAW SYM SAME TIME PST 12 MOS'
   ANLEMOPB= 'PN RLVR CAUSE PRBS W/EMOT/NERVES PST 12 MOS'
   ANLEMCTD= 'CONTD TO USE PN RLVR DESPITE EMOT PRBS'
   ANLPHLPB= 'ANY PHYS PRBS CAUSD/WORSND BY PN RLVR PST 12 MOS'
   ANLPHCTD= 'CONTD TO USE PN RLVR DESPITE PHYS PRBS'
   ANLLSACT= 'LESS ACTIVITIES B/C OF PN RLVR USE PAST 12 MOS'
   ANLSERPB= 'PN RLVR CAUSE SER PRB AT HOM/WRK/SCH PST 12 MOS'
   ANLPDANG= 'USING PN RLVR & DO DANGEROUS ACTIVS PST 12 MOS'
   ANLLAWTR= 'USING PN RLVR CAUSE PRBS WITH LAW PAST 12 MOS'
   ANLFMFPB= 'USING PN RLVR CAUSE PRBS W/FAM/FRNDS PST 12 MOS'
   ANLFMCTD= 'CONTD TO USE PN RLVR DESPITE PRBS W/FAM/FRNDS'
   TRNLOTTM= 'SPENT MONTH/MORE GETTING/USING TRN PAST 12 MOS'
   TRNGTOVR= 'MONTH+ SPENT GETTING OVER TRN EFFECTS PST 12 MOS'
   TRNLIMIT= 'SET LIMITS ON TRANQUILIZER USE PAST 12 MONTHS'
   TRNKPLMT= 'ABLE TO KEEP LIMITS OR USE MORE TRN PAST 12 MOS'
   TRNNDMOR= 'NEEDED MORE TRN TO GET SAME EFFECT PST 12 MOS'
   TRNLSEFX= 'USING SAME AMT TRN HAD LESS EFFECT PAST 12 MOS'
   TRNCUTDN= 'WANT/TRY TO CUT DOWN/STOP USING TRN PAST 12 MOS'
   TRNCUTEV= 'ABLE TO CUT/STOP USING TRN EVERY TIME PAST 12 MOS'
   TRNEMOPB= 'TRN CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS'
   TRNEMCTD= 'CONTD TO USE TRN DESPITE EMOT PRBS'
   TRNPHLPB= 'ANY PHYS PRBS CAUSED/WORSND BY TRN PST 12 MOS'
   TRNPHCTD= 'CONTD TO USE TRN DESPITE PHYS PRBS'
   TRNLSACT= 'LESS ACTIVITIES B/C OF TRN USE PAST 12 MOS'
   TRNSERPB= 'TRN CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS'
   TRNPDANG= 'USING TRN AND DO DANGEROUS ACTIVITIES PST 12 MOS'
   TRNLAWTR= 'USING TRN CAUSE PRBS WITH LAW PAST 12 MOS'
   TRNFMFPB= 'USING TRN CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS'
   TRNFMCTD= 'CONTD TO USE TRN DESPITE PRBS W/ FAM/FRNDS'
   STMLOTTM= 'SPENT MONTH/MORE GETTING/USING STM PAST 12 MOS'
   STMGTOVR= 'MONTH+ SPENT GETTING OVER STM EFFECTS PST 12 MOS'
   STMLIMIT= 'SET LIMITS ON STIMULANT USE PAST 12 MONTHS'
   STMKPLMT= 'ABLE TO KEEP LIMITS OR USE MORE STM PAST 12 MOS'
   STMNDMOR= 'NEEDED MORE STM TO GET SAME EFFECT PST 12 MOS'
   STMLSEFX= 'USING SAME AMT STM HAD LESS EFFECT PAST 12 MOS'
   STMCUTDN= 'WANT/TRY TO CUT DOWN/STOP USING STM PAST 12 MOS'
   STMCUTEV= 'ABLE TO CUT/STOP USING STM EVERY TIME PAST 12 MOS'
   STMCUT1X= 'CUT DOWN OR STOP USING STM AT LEAST 1X PST 12 MOS'
   STMFLBLU= 'WHEN CUT DOWN ON STM, FELT BLUE PAST 12 MONTHS'
   STMWD2SX= 'HAD 2+ STM WITHDRAWAL SYMPTOMS PST 12 MOS'
   STMWDSMT= 'HAD 2+ STM WDRAW SYM AT SAME TIME PAST 12 MOS'
   STMEMOPB= 'STM CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS'
   STMEMCTD= 'CONTD TO USE STM DESPITE EMOT PRBS'
   STMPHLPB= 'ANY PHYS PRBS CAUSED/WORSND BY STM PST 12 MOS'
   STMPHCTD= 'CONTD TO USE STM DESPITE PHYS PRBS'
   STMLSACT= 'LESS ACTIVITIES B/C OF STM USE PAST 12 MOS'
   STMSERPB= 'STM CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS'
   STMPDANG= 'USING STM AND DO DANGEROUS ACTIVITIES PST 12 MOS'
   STMLAWTR= 'USING STM CAUSE PRBS WITH LAW PAST 12 MOS'
   STMFMFPB= 'USING STM CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS'
   STMFMCTD= 'CONTD TO USE STM DESPITE PRBS W/ FAM/FRNDS'
   SEDLOTTM= 'SPENT MONTH/MORE GETTING/USING SED PAST 12 MOS'
   SEDGTOVR= 'MONTH+ SPENT GETTING OVER SED EFFECTS PST 12 MOS'
   SEDLIMIT= 'SET LIMITS ON SEDATIVE USE PAST 12 MONTHS'
   SEDKPLMT= 'ABLE TO KEEP LIMITS OR USE MORE SED PAST 12 MOS'
   SEDNDMOR= 'NEEDED MORE SED TO GET SAME EFFECT PST 12 MOS'
   SEDLSEFX= 'USING SAME AMT SED HAD LESS EFFECT PAST 12 MOS'
   SEDCUTDN= 'WANT/TRY TO CUT DOWN/STOP USING SED PAST 12 MOS'
   SEDCUTEV= 'ABLE TO CUT/STOP USING SED EVERY TIME PAST 12 MOS'
   SEDCUT1X= 'CUT DOWN OR STOP USING SED AT LEAST 1X PST 12 MOS'
   SEDWD1SX= 'HAD 1+ SED WITHDRAWAL SYMPTOM PST 12 MOS'
   SEDWDSMT= 'HAD 1+ SED WDRAW SYM AT SAME TIME PAST 12 MOS'
   SEDEMOPB= 'SED CAUSE PRBS WITH EMOT/NERVES PAST 12 MOS'
   SEDEMCTD= 'CONTD TO USE SED DESPITE EMOT PRBS'
   SEDPHLPB= 'ANY PHYS PRBS CAUSED/WORSND BY SED PST 12 MOS'
   SEDPHCTD= 'CONTD TO USE SED DESPITE PHYS PRBS'
   SEDLSACT= 'LESS ACTIVITIES B/C OF SED USE PAST 12 MOS'
   SEDSERPB= 'SED CAUSE SERS PRBS AT HOME/WORK/SCH PST 12 MOS'
   SEDPDANG= 'USING SED AND DO DANGEROUS ACTIVITIES PST 12 MOS'
   SEDLAWTR= 'USING SED CAUSE PRBS WITH LAW PAST 12 MOS'
   SEDFMFPB= 'USING SED CAUSE PRBS W/FAMILY/FRIENDS PST 12 MOS'
   SEDFMCTD= 'CONTD TO USE SED DESPITE PRBS W/ FAM/FRNDS'
   DEPNDALC= 'ALCOHOL DEPENDENCE IN THE PAST YEAR'
   DEPNDANL= 'PAIN RELIEVER DEPENDENCE IN THE PAST YEAR'
   DEPNDCIG= 'CIGARETTE DEPENDENCE IN THE PAST YEAR'
   DEPNDCOC= 'COCAINE DEPENDENCE IN THE PAST YEAR'
   DEPNDHAL= 'HALLUCINOGEN DEPENDENCE IN THE PAST YEAR'
   DEPNDHER= 'HEROIN DEPENDENCE IN THE PAST YEAR'
   DEPNDINH= 'INHALANT DEPENDENCE IN THE PAST YEAR'
   DEPNDMRJ= 'MARIJUANA DEPENDENCE IN THE PAST YEAR'
   DEPNDSED= 'SEDATIVE DEPENDENCE IN THE PAST YEAR'
   DEPNDSTM= 'STIMULANT DEPENDENCE IN THE PAST YEAR'
   DEPNDTRN= 'TRANQUILIZER DEPENDENCE IN THE PAST YEAR'
   DEPNDILL= 'ILLICIT DRUG DEPENDENCE IN THE PAST YEAR'
   DEPNDIEM= 'ILLICIT DRUG OTHER THAN MARIJUANA DEP IN PAST YR'
   DEPNDXMJ= 'ILLICIT DRUG EXCLUDING MARIJUANA DEP IN PAST YR'
   DEPNDPSY= 'PSYCHOTHERAPEUTIC DEPENDENCE IN THE PAST YR'
   DPILLALC= 'ILLICIT DRUG OR ALCOHOL DEPENDENCE IN PAST YR'
   DPILANAL= 'ILLICIT DRUGS AND ALCOHOL DEPENDENCE IN PAST YR'
   ABUSEALC= 'ALCOHOL ABUSE - PAST YEAR'
   ABUSEANL= 'PRESCRIPTION PAIN RELIEVER ABUSE - PAST YEAR'
   ABUSECOC= 'COCAINE ABUSE - PAST YEAR'
   ABUSEHAL= 'HALLUCINOGEN ABUSE - PAST YEAR'
   ABUSEHER= 'HEROIN ABUSE - PAST YEAR'
   ABUSEINH= 'INHALANT ABUSE - PAST YEAR'
   ABUSEMRJ= 'MARIJUANA ABUSE - PAST YEAR'
   ABUSESED= 'SEDATIVE ABUSE - PAST YEAR'
   ABUSESTM= 'STIMULANT ABUSE - PAST YEAR'
   ABUSETRN= 'TRANQUILIZER ABUSE - PAST YEAR'
   ABUSEILL= 'ANY ILLICIT DRUG ABUSE - PAST YEAR'
   ABUSEIEM= 'ANY ILLICIT DRG OTHER THAN MARIJUANA ABUSE-PST YR'
   ABUSEXMJ= 'ANY ILLICIT DRG EXCLUDING MARIJUANA ABUSE-PST YR'
   ABUSEPSY= 'NON-MEDICAL PSYCHOTHERAPEUTIC DRUG ABUSE - PST YR'
   ABILLALC= 'ANY ILLICIT DRUG OR ALCOHOL ABUSE - PAST YEAR'
   ABILANAL= 'ANY ILLICIT DRUG AND ALCOHOL ABUSE - PAST YEAR'
   ABODALC = 'ALCOHOL ABUSE OR DEPENDENCE - PAST YEAR'
   ABODANL = 'PAIN RELIEVER ABUSE OR DEPENDENCE - PAST YEAR'
   ABODCOC = 'COCAINE ABUSE OR DEPENDENCE - PAST YEAR'
   ABODHAL = 'HALLUCINOGEN ABUSE OR DEPENDENCE - PAST YEAR'
   ABODHER = 'HEROIN ABUSE OR DEPENDENCE - PAST YEAR'
   ABODINH = 'INHALANT ABUSE OR DEPENDENCE - PAST YEAR'
   ABODMRJ = 'MARIJUANA ABUSE OR DEPENDENCE - PAST YEAR'
   ABODSED = 'SEDATIVE ABUSE OR DEPENDENCE - PAST YEAR'
   ABODSTM = 'STIMULANT ABUSE OR DEPENDENCE - PAST YEAR'
   ABODTRN = 'TRANQUILIZER ABUSE OR DEPENDENCE - PAST YEAR'
   ABODILL = 'ANY ILLICIT DRUG ABUSE OR DEPENDENCE - PAST YEAR'
   ABODPSY = 'PSYCHOTHERAPEUTIC ABUSE OR DEPENDENCE - PAST YEAR'
   ABODILAL= 'ANY ILLICIT DRUG OR ALCOHOL ABUSE OR DEP - PST YR'
   ABDILAAL= 'ANY ILLICIT DRUG AND ALCOHOL ABUSE OR DEP - PST YR'
   BOOKED  = 'EVER ARRESTED AND BOOKED FOR BREAKING THE LAW'
   NOBOOKY2= '# TIMES ARRESTED AND BOOKED PAST 12 MONTHS'
   BKMVTHFT= 'ARRSTD & BOOKED FOR MOT VEH THEFT PAST 12 MONTHS'
   BKLARCNY= 'ARRSTD & BOOKED FOR LARCENY/THEFT PAST 12 MONTHS'
   BKBURGL = 'ARRSTD & BOOKED FOR BURGLARY/B & E PAST 12 MOS'
   BKAGASLT= 'ARRSTD & BOOKED FOR AGGRAVATED ASSAULT PAST 12 MOS'
   BKSMASLT= 'ARRSTD & BOOKED FOR OTHER ASSAULT PAST 12 MONTHS'
   BKROB   = 'ARRSTD & BOOKED FOR ROBBERY PAST 12 MONTHS'
   BKRAPE  = 'ARRSTD & BOOKED FOR FORCIBLE RAPE PAST 12 MONTHS'
   BKMURDER= 'ARRSTD & BOOKED FOR MURDER/HOMICIDE PAST 12 MONTHS'
   BKARSON = 'ARRSTD & BOOKED FOR ARSON PAST 12 MONTHS'
   BKDRVINF= 'ARRSTD & BOOKED FOR DUI PAST 12 MONTHS'
   BKDRUNK = 'ARRSTD & BOOKED FOR DRUNKENNESS PAST 12 MONTHS'
   BKPOSTOB= 'ARRSTD & BOOKED FOR POSSES OF TOB PAST 12 MOS'
   BKDRUG  = 'ARRSTD & BOOKED FOR POSSES/SALE DRUGS  PAST 12 MOS'
   BKPROS  = 'ARRSTD & BOOKED FOR PROSTITUTION PAST 12 MONTHS'
   BKSEXOFF= 'ARRSTD & BOOKED FOR OTH SEX OFFENSE PST 12 MOS'
   BKFRAUD = 'ARRSTD & BOOKED FOR FRAUD/STOL GOODS PAST 12 MOS'
   BKOTH   = 'ARRSTD & BOOKED FOR SOME OTHER OFF PAST 12 MOS'
   BKOTHOF2= 'OTHER OFFENSE PAST 12 MONTHS - SPECIFY'
   PROBATON= 'ON PROBATION AT ANY TIME PAST 12 MONTHS'
   PAROLREL= 'ON PAROLE/SUPRV RELEASE PAST 12 MONTHS'
   DRVALDR = 'DROVE UNDER INFLU OF ALC & ILL DRUGS PAST 12 MOS'
   DRVAONLY= 'DROVE UNDER INFLU OF ALC/ALC ONLY PST 12 MOS'
   DRVDONLY= 'DROVE UNDER INFLU OF DRUGS/DRUGS ONLY PST 12 MOS'
   DRIVALC = 'DROVE VEHICLE WHILE UNDER INFLUENCE OF ALCOHOL'
   DRIVDRG = 'DROVE VEHICLE UNDER INFLUENCE OF ILLICIT DRUGS'
   DRIVALD = 'DROVE VEHICLE UNDER INFLUENCE OF ALC OR ILL DRUGS'
   PAROL   = 'PAROLE/SUPERVISED RELEASE STATUS IN THE PAST YEAR'
   PROB    = 'PROBATION STATUS IN THE PAST YEAR'
   TXEVER  = 'EVER RECEIVED ALCOHOL OR DRUG TREATMENT'
   TXYREVER= 'EVER RECEIVED ALCOHOL OR DRUG TRMT PAST 12 MOS'
   TXYRADG = 'TRMT FOR ALC, DRUG OR BOTH PAST 12 MONTHS'
   TXYRHOSP= 'RCVD TXFILL1 TRMT IN HOSP/OVERNIGHT PST 12 MOS'
   TXYRHPAD= 'HOSP/OVERNIGHT TRMT FOR ALC, DRUGS, OR BOTH'
   TXYRRFIN= 'RCVD TXFILL1 TRMT REHAB CENTR/OVERNIGHT PST 12 MO'
   TXYRINAD= 'RES ALC/DRG REH TRMT FOR ALC, DRUGS, OR BOTH'
   TXYRRFOP= 'RCVD TXFILL1 TRMT REHAB CENTR/OUTPT PST 12 MOS'
   TXYRPOAD= 'OUTPATIENT TRMT FOR ALC, DRUGS, OR BOTH'
   TXYRMHC = 'RCVD TXFILL1 TRMT MNT HEALTH CNTR/OUTPT PST 12 MO'
   TXYRMHAD= 'MNT HEALTH CNTR TRMT FOR ALC, DRUGS, OR BOTH'
   TXYRTXER= 'RCVD TXFILL1 TRMT IN EMERGENCY ROOM PAST 12 MOS'
   TXYRERAD= 'EMERGENCY ROOM TRMT FOR ALC, DRUGS, OR BOTH'
   TXYRDOC = 'RCVD TXFILL1 TRMT IN PRIV DR.''S OFFICE PST 12 MOS'
   TXYRDCAD= 'PRIV DR.''S OFFICE TRMT FOR ALC, DRUGS, OR BOTH'
   TXYRJAIL= 'RCVD TXFILL1 TRMT IN PRISON/JAIL PAST 12 MONTHS'
   TXYRJLAD= 'PRISON/JAIL TRMT FOR ALC, DRUGS, OR BOTH'
   TXYRSHG = 'RCVD TXFILL1 TRMT IN SELF-HELP GROUP PAST 12 MOS'
   TXYRSGAD= 'SELF-HELP GROUP TRMT FOR ALC, DRUGS, OR BOTH'
   TXYRSOP = 'RCVD TXFILL1 TRMT IN SOME OTHER PLACE PAST 12 MOS'
   TXYROTS2= 'OTHER PLACE RECEIVED TRMT PAST 12 MONTHS'
   TXYROTAD= 'OTHER PLACE TRMT FOR ALC, DRUGS, OR BOTH'
   TXYRVSER= 'EVER VISIT EMER RM FOR TRMT OF ILL DRUG PST 12 MO'
   TXYRNME2= '# TIMES EMER RM FOR TRMT OF ILL DRUGS PST 12 MOS'
   TXRCVNOW= 'CURRENTLY RECEIVING TRMT/COUNSELING FOR TXFILL1'
   NDTXNEDR= 'NEED TRMT FOR USE OF ALCOHOL OR DRUG PAST 12 MOS'
   NDTXMORE= 'NEED ADDL TRMT FOR USE OF ALCOHOL/DRUG PST 12 MOS'
   NDTMRALC= 'NEED ADDL TRMT FOR USE OF ALCOHOL PAST 12 MOS'
   NDTMRMJ = 'NEED ADDL TRMT FOR USE OF MJ/HASH PAST 12 MOS'
   NDTMRCOC= 'NEED ADDL TRMT FOR USE OF COC/CRACK PAST 12 MOS'
   NDTMRHER= 'NEED ADDL TRMT FOR USE OF HEROIN PAST 12 MOS'
   NDTMRHAL= 'NEED ADDL TRMT FOR USE OF HALLUC PAST 12 MOS'
   NDTMRINH= 'NEED ADDL TRMT FOR USE OF INHALANTS PAST 12 MOS'
   NDTMRANL= 'NEED ADDL TRMT FOR USE OF PAIN REL PST 12 MOS'
   NDTMRTRN= 'NEED ADDL TRMT FOR USE OF TRAN PAST 12 MOS'
   NDTMRSTM= 'NEED ADDL TRMT FOR USE OF STIMULANTS PST 12 MOS'
   NDTMRSED= 'NEED ADDL TRMT FOR USE OF SEDATIVES PST 12 MOS'
   NDTMROTH= 'NEED ADDL TRMT FOR USE OF SOME OTH DRG PST 12 MOS'
   NDTXALCR= 'NEED TRMT FOR USE OF ALCOHOL PAST 12 MONTHS'
   NDTXMJR = 'NEED TRMT FOR USE OF MARIJUANA/HASHISH PAST 12 MOS'
   NDTXCOCR= 'NEED TRMT FOR USE OF COCAINE/CRACK PAST 12 MONTHS'
   NDTXHERR= 'NEED TRMT FOR USE OF HEROIN PAST 12 MONTHS'
   NDTXHALR= 'NEED TRMT FOR USE OF HALLUCINOGENS PAST 12 MONTHS'
   NDTXINHR= 'NEED TRMT FOR USE OF INHALANTS PAST 12 MONTHS'
   NDTXANLR= 'NEED TRMT FOR USE OF RX PAIN RELIEVERS PST 12 MOS'
   NDTXTRNR= 'NEED TRMT FOR USE OF RX TRANQUILIZERS PST 12 MOS'
   NDTXSTMR= 'NEED TRMT FOR USE OF RX STIMULANTS PST 12 MOS'
   NDTXSEDR= 'NEED TRMT FOR USE OF RX SEDATIVES PST 12 MOS'
   NDTXSODR= 'NEED TRMT FOR USE OF SOME OTHER DRUG PAST 12 MOS'
   NDTXDG1R= 'OTHER DRUG NEEDED TRMT FOR PST 12 MOS - SPECIFY 1'
   NDTXDG2R= 'OTHER DRUG NEEDED TRMT FOR PST 12 MOS - SPECIFY 2'
   NDTXDG3R= 'OTHER DRUG NEEDED TRMT FOR PST 12 MOS - SPECIFY 3'
   NDTXDG4R= 'OTHER DRUG NEEDED TRMT FOR PST 12 MOS - SPECIFY 4'
   NDTXDG5R= 'OTHER DRUG NEEDED TRMT FOR PST 12 MOS - SPECIFY 5'
   NDTXEFTR= 'MAKE EFFORT FOR TRMT OF TXFILL2 PAST 12 MONTHS'
   NDTMREFT= 'MAKE EFFORT FOR ADDL TRMT FOR ALC/DRG PST 12 MOS'
   TXLASREC= 'TIME SINCE LAST RCVD ALCOHOL OR DRUG TREATMENT'
   TXLTYMN2= 'MAIN PLACE RCV TRMT LAST TIME/CURRENTLY'
   TXLTYALC= 'LAST/CURRENT TREATMENT FOR ALCOHOL'
   TXLTYMJ = 'LAST/CURRENT TREATMENT FOR MARIJUANA/HASHISH'
   TXLTYCOC= 'LAST/CURRENT TREATMENT FOR COCAINE/CRACK'
   TXLTYHER= 'LAST/CURRENT TREATMENT FOR HEROIN'
   TXLTYHAL= 'LAST/CURRENT TREATMENT FOR HALLUCINOGENS'
   TXLTYINH= 'LAST/CURRENT TREATMENT FOR INHALANTS'
   TXLTYANL= 'LAST/CURRENT TRMT FOR PRESCRIPTION PAIN RELIEVERS'
   TXLTYTRN= 'LAST/CURRENT TRMT FOR PRESCRIPTION TRANQUILIZERS'
   TXLTYSTM= 'LAST/CURRENT TRMT FOR PRESCRIPTION STIMULANTS'
   TXLTYSED= 'LAST/CURRENT TRMT FOR PRESCRIPTION SEDATIVES'
   TXLTYSOD= 'LAST/CURRENT TRMT FOR SOME OTHER DRUG'
   TXLTYOU2= 'OUTCOME OF LAST/CURRENT TREATMENT'
   TXLTYDU2= '# DAYS IN ALC/DRG TMT SO FAR/LAST TIME - RECODE'
   TXPYINS = 'HEALTH INSURANCE PAY FOR LAST/CURRENT TRMT'
   TXPYCARE= 'MEDICARE PAY FOR LAST/CURRENT TRMT'
   TXPYCAID= 'MEDICAID PAY FOR LAST/CURRENT TRMT'
   TXPYPUBP= 'OTH PUBLIC ASSIST PAY FOR LAST/CURRENT TRMT'
   TXPYSAVE= 'OWN SAVINGS PAY FOR LAST/CURRENT TRMT'
   TXPYFMLY= 'FAMILY MEMBERS PAY FOR LAST/CURRENT TRMT'
   TXPYCORT= 'COURTS PAY FOR LAST/CURRENT TRMT'
   TXPYMILC= 'MILITARY HLTH CARE PAY FOR LAST/CURRENT TRMT'
   TXPYEMPL= 'EMPLOYER PAY FOR LAST/CURRENT TRMT'
   TXPYSOS = 'SOME OTHER SOURCE PAY FOR LAST/CURRENT TRMT'
   TXPYSP2 = 'OTHER PAY FOR LAST/CURRENT TRMT - SPECIFY'
   TXPYFRE = 'LAST/CURRENT TREATMENT WAS/IS FREE'
   TXENROLL= 'ENROLLED IN TREATMENT PROGRAM ON OCT.1 1999'
   TXYRDTXO= 'WAS DETOX THE ONLY TRMT RCVD PAST 12 MONTHS'
   SPECTILL= 'RCVD TRMT AT SPEC FAC FOR ILL DRG-PST YR'
   SPECTALC= 'RCVD TRMT AT SPEC FAC FOR ALC USE-PST YR'
   SPILLALC= 'RCVD TRMT SPEC FAC FOR ALC OR DRG-PST YR'
   ILLNEED = 'NEEDED TRMT FOR ILL DRUG USE-PST YR'
   TXNOSPEC= 'NEED ILL DRG TRMT, NOT RCVD TRMT SPC FAC'
   ALCTRMT = 'RCVD TRMT AT ANY LOC FOR ALC USE-PST YR'
   ILLTRMT = 'RCVD TRMT ANY LOC FOR ILL DRG USE-PST YR'
   TXILLALC= 'RCVD TRMT ANY LOC FOR ALC OR DRG-PST YR'
   TXILANAL= 'RCVD TRMT ANY LOC FOR ALC AND DRG-PST YR'
   TXLTALC2= 'RECEIVED LAST/CURRENT TREATMENT FOR ALCOHOL'
   TXLTANL2= 'RECEIVED LAST/CURRENT TREATMENT FOR PAIN RELIEVERS'
   TXLTCOC2= 'RECEIVED LAST/CURRENT TREATMENT FOR COCAINE'
   TXLTHAL2= 'RECEIVED LAST/CURRENT TREATMENT FOR HALLUCINOGENS'
   TXLTHER2= 'RECEIVED LAST/CURRENT TREATMENT FOR HEROIN'
   TXLTINH2= 'RECEIVED LAST/CURRENT TREATMENT FOR INHALANTS'
   TXLTMJ2 = 'RECEIVED LAST/CURRENT TREATMENT FOR MARIJUANA'
   TXLTSED2= 'RECEIVED LAST/CURRENT TREATMENT FOR SEDATIVES'
   TXLTSTM2= 'RECEIVED LAST/CURRENT TREATMENT FOR STIMULANTS'
   TXLTTRN2= 'RECEIVED LAST/CURRENT TREATMENT FOR TRANQUILIZERS'
   TXLTILL2= 'RECEIVED LAST/CURRENT TREATMENT FOR ILLICIT DRUGS'
   TXPINS2 = 'LAST/CURRENT ILL DRG/ALC TRT PAID FOR BY INSURANCE'
   TXPCARE2= 'LAST/CURR ILL DRG/ALC TRT PAID FOR BY MEDICARE'
   TXPCAID2= 'LAST/CURRENT ILL DRG/ALC TRT PAID FOR BY MEDICAID'
   TXPPUBP2= 'LAST/CURR ILL DRG/ALC TRT PAID FOR BY PUBLIC ASST'
   TXPSAVE2= 'LAST/CURR ILL DRG/ALC TRT PAID FOR BY OWN SAVINGS'
   TXPFMLY2= 'LAST/CURR ILL DRG/ALC TRT PAID FOR BY FAM MEMBERS'
   TXPCORT2= 'LAST/CURRENT ILL DRG/ALC TRT PAID FOR BY COURTS'
   TXPMILC2= 'LAST/CURR ILL DRG/ALC TRT PAID FOR BY MILT HC'
   TXPEMPL2= 'LAST/CURR ILL DRG/ALC TRT PAID FOR BY EMPLOYER'
   ILLPINS = 'LAST/CURRENT ILL DRUG TRT PAID FOR BY INSURANCE'
   ILLPCARE= 'LAST/CURRENT ILL DRUG TRT PAID FOR BY MEDICARE'
   ILLPCAID= 'LAST/CURRENT ILLICIT DRUG TRT PAID FOR BY MEDICAID'
   ILLPPUBP= 'LAST/CURRENT ILL DRUG TRT PAID FOR BY PUBLIC ASST'
   ILLPSAVE= 'LAST/CURRENT ILL DRUG TRT PAID FOR BY OWN SAVINGS'
   ILLPFMLY= 'LAST/CURRENT ILL DRUG TRT PAID FOR BY FAMLY MEMBR'
   ILLPCORT= 'LAST/CURRENT ILL DRUG TREATMENT PAID FOR BY COURTS'
   ILLPMILC= 'LAST/CURRENT ILL DRUG TRT PAID FOR BY MILT HLTCARE'
   ILLPEMPL= 'LAST/CURRENT ILLICIT DRUG TRT PAID FOR BY EMPLOYER'
   ALCPINS = 'LAST/CURRENT ALC TREATMENT PAID FOR BY INSURANCE'
   ALCPCARE= 'LAST/CURRENT ALC TREATMENT PAID FOR BY MEDICARE'
   ALCPCAID= 'LAST/CURRENT ALC TREATMENT PAID FOR BY MEDICAID'
   ALCPPUBP= 'LAST/CURRENT ALC TRTMNT PAID FOR BY PUBLIC ASST'
   ALCPSAVE= 'LAST/CURRENT ALC TRTMNT PAID FOR BY OWN SAVINGS'
   ALCPFMLY= 'LAST/CURRENT ALC TRTMNT PAID FOR BY FAMILY MEMBERS'
   ALCPCORT= 'LAST/CURRENT ALCOHOL TREATMENT PAID FOR BY COURTS'
   ALCPMILC= 'LAST/CURRENT ALC TRT PAID FOR BY MILT HLTH CARE'
   ALCPEMPL= 'LAST/CURRENT ALC TREATMENT PAID FOR BY EMPLOYER'
   LOCHOSP = 'RCVD ILL DRUG OR ALC TRT AT A HOSPITAL IN PAST YR'
   LOCRFIN = 'RCVD ILL DRUG/ALC TRT AT INP REHAB FAC IN PAST YR'
   LOCRFOP = 'RCVD ILL DRUG/ALC TRT AT OUTP REHAB FAC IN PAST YR'
   LOCMHC  = 'RCVD ILL DRUG/ALC TRT AT MNTL HLTH CNTR IN PAST YR'
   LOCTXER = 'RCVD ILL DRUG OR ALC TRT AT AN ER IN PAST YR'
   LOCDOC  = 'RCVD ILL DRUG OR ALC TRT AT DR''S OFFICE IN PAST YR'
   LOCJAIL = 'RCVD ILL DRUG OR ALC TRT AT PRISON/JAIL IN PAST YR'
   LOCSHG  = 'RCVD ILL DRUG/ALC TRT AT SELF-HELP GRP IN PAST YR'
   DRGHOSP = 'RCVD ILL DRUG TREATMENT AT A HOSPITAL IN PAST YEAR'
   DRGRFIN = 'RCVD ILL DRUG TRT AT AN INP REHAB FAC IN PAST YEAR'
   DRGRFOP = 'RCVD ILL DRUG TRT AT AN OUTP REHAB FAC IN PAST YR'
   DRGMHC  = 'RCVD ILL DRUG TRT AT A MENTAL HLTH CNTR IN PST YR'
   DRGTXER = 'RCVD ILL DRUG TRT AT AN EMERGENCY ROOM IN PAST YR'
   DRGDOC  = 'RECEIVED ILL DRUG TRT AT A DR''S OFFICE IN PAST YR'
   DRGJAIL = 'RCVD ILL DRUG TRT AT A PRISON/JAIL IN THE PAST YR'
   DRGSHG  = 'RCVD ILL DRUG TRT AT A SELF-HELP GROUP IN PAST YR'
   ALCHOSP = 'RECEIVED ALC TRT AT A HOSPITAL IN THE PAST YEAR'
   ALCRFIN = 'RCVD ALC TRT AT INP REHAB FAC IN THE PAST YEAR'
   ALCRFOP = 'RCVD ALC TRT AT AN OUTP REHAB FAC IN THE PAST YR'
   ALCMHC  = 'RCVD ALC TRT AT A MENTAL HEALTH CENTER IN PAST YR'
   ALCTXER = 'RCVD ALC TRT AT AN EMERGENCY ROOM IN PAST YR'
   ALCDOC  = 'RECEIVED ALC TRT AT A DOCTOR''S OFFICE IN PAST YR'
   ALCJAIL = 'RECEIVED ALC TRT AT A PRISON/JAIL IN THE PAST YEAR'
   ALCSHG  = 'RCVD ALC TRT AT A SELF-HELP GROUP IN PAST YR'
   AUINPYR = 'STAY OVNT IN HOSP FOR MH TRMT PST 12 MOS'
   AUINPSYH= 'MH TRMT IN PRIV/PUB PSYCH HOSP PST 12 MOS'
   AUINPGEN= 'MH TRMT IN PSYCH UNIT OF GEN HOSP PST 12 MOS'
   AUINMEDU= 'MH TRMT IN MED UNIT OF GEN HOSP PST 12 MOS'
   AUINAHSP= 'MH TRMT IN ANOTHER TYPE HOSP PST 12 MOS'
   AUINRESD= 'MH TRMT IN RESID TRMT CENTER PST 12 MOS'
   AUINSFAC= 'MH TRMT IN SOME OTHER FACIL PST 12 MOS'
   AUNMPSY2= '# NIGHTS IN PRIV/PUB PSYCH HOSP PST 12 MOS'
   AUNMPGE2= '# NIGHTS IN PSYCH UNIT OF GEN HOSP PST 12 MOS'
   AUNMMEDU= '# NIGHTS IN MED UNIT OF GEN HOSP PST 12 MOS'
   AUNMAHSP= '# NIGHTS IN ANOTHER TYPE OF HOSP PST 12 MOS'
   AUNMRESD= '# NIGHTS IN RESID TRMT CENTER PST 12 MOS'
   AUNMSFA2= '# NIGHTS IN SOME OTHER FACIL PST 12 MOS'
   AUPINSLF= 'INPAT MH CARE PYMNT: SELF OR LIVE-IN FAM MBR'
   AUPINOFM= 'INPAT MH CARE PYMNT: FAM MBR NOT LIVING W/YOU'
   AUPINPHI= 'INPAT MH CARE PYMNT: PRIVATE HEALTH INSUR'
   AUPINMCR= 'INPATIENT MH CARE PAYMENT: MEDICARE'
   AUPINMCD= 'INPATIENT MH CARE PAYMENT: MEDICAID'
   AUPINREH= 'INPAT MH CARE PYMNT: REHABILITATION PROG'
   AUPINEMP= 'INPATIENT MH CARE PAYMENT: EMPLOYER'
   AUPINMIL= 'INPATIENT MH CARE PAYMENT: MILITARY SOURCE'
   AUPINPUB= 'INPAT MH CARE PYMNT: OTHER PUBLIC SOURCE'
   AUPINPRV= 'INPAT MH CARE PYMNT: OTHER PRIVATE SOURCE'
   AUPINFRE= 'INPATIENT MENTAL HEALTH CARE WAS FREE'
   AUPINAMT= 'AMT YOU/FAMILY PAID FOR INPAT MH CARE'
   AUOPTYR = 'RCVD OUTPATIENT MH TRMT PST 12 MOS'
   AUOPMENT= 'MH TRMT IN OUTPATIENT MH CNTR PST 12 MOS'
   AUOPTHER= 'MH TRMT IN PRIV THERAPIST''S OFC PST 12 MOS'
   AUOPDOC = 'MH TRMT IN NON-CLINIC DR.''S OFC PST 12 MOS'
   AUOPCLNC= 'MH TRMT IN OUTPAT MED CLINIC PST 12 MOS'
   AUOPDTMT= 'MH TRMT IN DAY TREATMENT PGM PST 12 MOS'
   AUOPOTOP= 'MH TRMT IN OTHER OUTPAT PLACE PST 12 MOS'
   AUOPYRS2= 'OTH FACIL RCVD OUTPAT MH TRMT PAST 12 MOS'
   AUNMMEN2= '# VISITS TO OUTPATIENT MH CNTR PST 12 MOS'
   AUNMTHE2= '# VISITS TO PRIV THERAPIST''S OFC PST 12 MOS'
   AUNMDOC2= '# VISITS TO NON-CLINIC DR.''S OFC PST 12 MOS'
   AUNMCLN2= '# VISITS TO OUTPAT MED CLINIC PST 12 MOS'
   AUNMDTM2= '# VISITS TO DAY TREATMENT PGM PST 12 MOS'
   AUNMOTO2= '# VISIT OTPT SOME OTHER FACILITY PST 12 MOS'
   AUPOPSLF= 'OUPAT MH CARE PYMNT: SELF OR LIVE-IN FAM MBR'
   AUPOPOFM= 'OUPAT MH CARE PYMNT: FAM MBR NOT LIVING W/YOU'
   AUPOPPHI= 'OUPAT MH CARE PYMNT: PRIVATE HEALTH INSUR'
   AUPOPMCR= 'OUTPATIENT MH CARE PAYMENT: MEDICARE'
   AUPOPMCD= 'OUTPATIENT MH CARE PAYMENT: MEDICAID'
   AUPOPREH= 'OUPAT MH CARE PYMNT: REHABILITATION PROG'
   AUPOPEMP= 'OUTPATIENT MH CARE PAYMENT: EMPLOYER'
   AUPOPMIL= 'OUTPATIENT MH CARE PAYMENT: MILITARY SOURCE'
   AUPOPPUB= 'OUPAT MH CARE PYMNT: OTHER PUBLIC SOURCE'
   AUPOPPRV= 'OUPAT MH CARE PYMNT: OTHER PRIVATE SOURCE'
   AUPOPFRE= 'OUTPATIENT MENTAL HEALTH CARE WAS FREE'
   AUPOPMOS= 'PAYMENT FOR MOST OF OUTPATIENT MH CARE'
   AUPOPAMT= 'AMT YOU/FAMILY PAID FOR OUPAT MH CARE'
   AURXYR  = 'TOOK ANY PRESCRIP MED FOR MH COND PAST 12 MOS'
   AUUNMTYR= 'NEEDED MH TRMT BUT DIDN''T GET IT PAST 12 MOS'
   AUUNMTRS= 'REASON DIDN''T GET MH TRMT PAST 12 MOS'
   AMHINP  = 'ADULT REC INPATIENT MENTAL HEALTH TRT IN PAST YEAR'
   AMHOUTP = 'ADULT REC OUTPATIENT MENTAL HEALTH TRT IN PAST YR'
   AMHRX   = 'ADULT REC PRESC MED FOR MENTAL HLTH TRT IN PST YR'
   AMHTXREC= 'ADULT REC ANY MENTAL HEALTH TRT IN PAST YEAR'
   AMHTRTND= 'ADULT PERCEIVED NEED/DID NOT REC MH TRT PST YR'
   SNCRIME = 'THERE IS A LOT OF CRIME IN NEIGHBORHOOD'
   SNSELLDG= 'A LOT OF DRUG SELLING GOES ON IN NEIGHBORHOOD'
   SNPPVAL = 'PEOPLE IN NEIGHBORHOOD SHARE THE SAME VALUES'
   SNSTFGT = 'LOTS OF STREET FIGHTS IN NEIGHBORHOOD'
   SNEMTBLD= 'MANY EMPTY/ABANDONED BLDGS IN NEIGHBORHOOD'
   SNPPHLP = 'PEOPLE IN NEIGHBORHOOD OFTEN HELP EACH OTHER'
   SNGRAFTI= 'THERE IS A LOT OF GRAFFITI IN NEIGHBORHOOD'
   SNPPVSIT= 'PEOPLE IN NBHD OFTEN VISIT IN EACH OTHERS HOMES'
   SNPPMOVE= 'PEOPLE MOVE IN AND OUT OF NEIGHBORHOOD OFTEN'
   SNMOV5Y2= '# TIMES MOVED IN PAST 5 YEARS'
   SNSPOUSE= 'CURRENTLY LIVING WITH A SPOUSE/PARTNER'
   SNSPACTV= 'YOU AND SPOUSE SPENT 1+ HR IN ACTIV YOU ENJOY'
   SNSPANGR= 'YOU AND SPOUSE WERE ANGRY WITH EACH OTHER'
   SNSPHITU= 'YOUR SPOUSE/PARTNER HIT/THREATENED TO HIT YOU'
   SNYHITSP= 'YOU HIT/THREATENED TO HIT YOUR SPOUSE/PARTNER'
   SNSPCRIT= 'HOW OFTEN IS SPOUSE/PARTNER CRITICAL OF YOU'
   SNSPCONC= 'HOW OFTEN SPOUSE/PRTNER SHOWS CONCERN FEELINGS'
   SNFRCONC= '#FRIENDS WHO YOU SHARE PERS ISSUES/CONCERNS WITH'
   SNFRACTV= '#FRIENDS WHO YOU SPEND TIME WITH'
   SNFRCARE= '#FRIENDS WHO REALLY LIKE/CARE ABOUT YOU'
   SNYSELL = 'SOLD ILLEGAL DRUGS'
   SNYSTOLE= 'STOLEN/TRIED TO STEAL ANYTHING WORTH > $50'
   SNYATTAK= 'ATTACKED SOMEONE W/INTENT TO SERIOUSLY HURT THEM'
   SNFACIG = 'HOW YOU FEEL: ADLTS SMOKING 1+ PK CIGS/DAY'
   SNFAMJEV= 'HOW YOU FEEL: ADLTS TRYING MJ/HASH'
   SNFAALDY= 'HOW YOU FEEL: ADLTS DRINKING ALC DLY'
   SNFAALDV= 'HOW YOU FEEL: ADLTS DRIVING AFT 1-2 DRINKS'
   YECRIME = 'THERE IS A LOT OF CRIME IN NEIGHBORHOOD'
   YESELLDG= 'A LOT OF DRUG SELLING IN NEIGHBORHOOD'
   YEPPHLP = 'PEOPLE IN NEIGHBORHOOD HELP EACH OTHER OUT'
   YESTFGT = 'THERE ARE LOTS OF STREET FIGHTS IN NEIGHBORHOOD'
   YEEMTBLD= 'THERE ARE EMPTY/ABANDONED BLDGS IN NEIGHBORHOOD'
   YEPPVSIT= 'PEOPLE IN NEIGHBORHOOD OFTEN VISIT IN EA OTH HOME'
   YEGRAFTI= 'THERE IS A LOT OF GRAFFITI IN NEIGHBORHOOD'
   YEPPMOVE= 'PEOPLE MOVE IN AND OUT OF NEIGHBORHOOD OFTEN'
   YEMOV5Y2= '# TIMES MOVED IN PAST 5 YEARS'
   YEENRLYR= 'BEEN ENROLLED IN ANY SCHOOL PAST 12 MONTHS'
   YELSTGRD= 'GRADES FOR LAST SEMESTER/GRADING PERIOD COMPLETED'
   YEYFGTSW= 'GOTTEN INTO A SERIOUS FIGHT AT SCHOOL/WORK'
   YEYFGTGP= 'TAKEN PART IN FIGHT WHERE GROUP FIGHTS GROUP'
   YEYHGUN = 'CARRIED A HANDGUN'
   YEYSELL = 'SOLD ILLEGAL DRUGS'
   YEYSTOLE= 'STOLEN/TRIED TO STEAL ANYTHING WORTH >$50'
   YEYATTAK= 'ATTACKED SOMEONE W/INTENT TO SERIOUSLY HURT THEM'
   YEPPKCIG= 'HOW PRNTS WLD FEEL: YOU SMOKING 1+ PACK CIGS/DAY'
   YEPMJEVR= 'HOW PRNTS WLD FEEL: YOU TRYING MJ/HASH'
   YEPALDLY= 'HOW PRNTS WLD FEEL: YOU DRINKING ALC DAILY'
   YEGPKCIG= 'HOW YOU FEEL S/ONE YOUR AGE SMOKG 1+ PK CIGS/DY'
   YEGMJEVR= 'HOW YOU FEEL S/ONE YOUR AGE TRYING MJ/HASH'
   YEGALDLY= 'HOW YOU FEEL S/ONE YOUR AGE DRINKING ALC DLY'
   YETLKNON= 'THERE IS NOBODY I CAN TALK TO ABOUT SERIOUS PROBS'
   YETLKPAR= 'MY MOTHER/FATHER/GUARDIAN'
   YETLKSOP= 'SOME OTHER PERSON'
   YEPRTDNG= 'HAVE YOU TALKED W/PARENT(S) ABT DANGER OF TOB/ALC'
   YEBIGBRO= 'BIG BROTHER/BIG SISTER/BIG BUDDY PROGRAM'
   YEPRBSLV= 'PRBLM SOLVING/COMMUNICATION SKILLS/SELF-ESTEEM GR'
   YEVIOPRV= 'VIOLENCE PREVENTION PROGRAMS'
   YEYMCA  = 'YOUTH CENTER ACTIVITIES/YMCA/YWCA'
   YESCOUTS= 'BOY SCOUTS/GIRL SCOUTS'
   YEPRVLES= 'PRIVATE LESSONS'
   YEDGPRGP= 'ALCOHOL/TOBACCO/DRUG PREV PGMS OUTSIDE SCHL'
   YETEMSPT= 'TEAM SPORTS'
   YE4HCLUB= '14-H CLUB'
   YESLFHLP= 'AA/ALATEEN/INDIVIDUAL OR GROUP COUNSELING'
   YEBAND  = 'SCHOOL BAND, ORCHESTRA, CHOIR'
   YESCHCLB= 'SCHOOL-RELATED CLUBS'
   YEVOLUNT= 'VOLUNTEER/COMMUNITY WORK'
   YESTGOVT= 'STUDENT GOVERNMENT'
   YEPRGSTD= 'PREGNANCY OR SEXUALLY TRANSMITTED DISEASE PGMS'
   YEJBSKIL= 'JOB SKILLS OR JOB TRAINING'
   YECHOIR = 'CHURCH CHOIR'
   YEDECLAS= 'A SPECIAL CLASS ABOUT DRUGS OR ALCOHOL'
   YEDERGLR= 'FILMS/LECTURES/DISCUS/INFO ABOUT DRG/ALC IN CLASS'
   YEDESPCL= 'FILMS/LECTURES/DISCUS/INFO ABOUT DRG/ALC OUT CLAS'
   YEPVNTYR= 'SEEN/HEARD ALC/DRG PREV MESSAGES FRM SOURC OUT SC'
   YECGFRND= '# TIMES FRND/RELAT BGT CIGS FOR YOU PAST 30 DAYS'
   YECGVEND= '# TIMES BOUGHT CIGS FR VENDING MACH PAST 30 DAYS'
   YECGMAI2= '# TIMES BOUGHT CIGS THRU MAIL PAST 30 DAYS'
   YECGCHKO= '# TIMES BGT CIGS/BROUGHT TO CHKOUT PST 30 DAYS'
   YECGCLRK= '# TIMES BGT CIGS WHERE CLERK GAVE PAST 30 DAYS'
   YECGINET= '# TIMES BOUGHT CIGS THRU INTERNET PAST 30 DAYS'
   YECGSMKT= '# TIMES BOUGHT CIGS IN SUPERMKT PAST 30 DAYS'
   YECGDSTO= '# TIMES BOUGHT CIGS IN DRUG STORE PST 30 DAYS'
   YECGCONV= '# TIMES BGT CIGS SML GROC/CONV ST PST 30 DAYS'
   YECGINDV= '# TIMES BOUGHT CIGS FROM INDIV PAST 30 DAYS'
   YECGPRUF= 'ASKED FOR ID LAST TIME TRIED TO BUY CIGS'
   YECGSUCC= 'SUCCESSFUL LAST TIME TRIED TO BUY CIGS'
   YEPKCRTN= 'BUY CIGS BY PACK OR CARTON'
   YEPDPACK= 'PRICE PAID FOR LAST PACK OF CIGS'
   YEPDCRTN= 'PRICE PAID FOR LAST CARTON OF CIGS'
   YEBLNTEV= 'EVER SMOKED CIGAR WITH MJ'
   YEBLNT30= 'SMOKED CIGAR WITH MJ PAST 30 DAYS'
   YEBL30FQ= '# DAYS SMKD CIGAR WITH MJ PAST 30 DAYS'
   YECGRWMJ= 'REPLACE TOBACCO WITH MJ IN CIGAR PAST 30 DAYS'
   NGHCRIM2= 'A LOT OF CRIME IN YOUTH NEIGHBORHOOD'
   NGHSELL2= 'A LOT OF DRUG SELLING IN YOUTH NGHD'
   NGHHELP2= 'PEOPLE HELP EACH OTHER IN YOUTH NGHD'
   NGHFGHT2= 'MANY STREET FIGHTS IN YOUTH NGHD'
   NGHBLDG2= 'MANY EMPTY BUILDINGS IN YOUTH NGHD'
   NGHVSIT2= 'PEOPLE VISIT EACH OTHER IN YOUTH NGHD'
   NGHGRAF2= 'LOT OF GRAFFITI IN YOUTH NEIGHBORHOOD'
   NGHMOVE2= 'PEOPLE OFTEN MOVE IN/OUT IN YOUTH NGHD'
   MVIN5YR2= 'NUM OF TIMES YOUTH MOVED IN PAST 5 YRS'
   PRPKCIG2= 'HOW PARENTS FEEL: YOUTH SMOKE PACK/DAY CIG'
   PRMJEVR2= 'HOW PARENTS FEEL: YOUTH TRY MJ/HASH'
   PRALDLY2= 'HOW PARENTS FEEL: YOUTH DRNK 1+ ALC BEV/DAY'
   PRTALK3 = 'TALKED W/PARENT ABT DANGER TOB/ALC/DRG'
   YOFIGHT2= 'YOUTH HAD SERIOUS FIGHT AT SCHOOL/WORK'
   YOGRPFT2= 'YOUTH FOUGHT W/GROUP VS OTHER GROUP'
   YOHGUN2 = 'YOUTH CARRIED A HANDGUN'
   YOSELL2 = 'YOUTH SOLD ILLEGAL DRUGS'
   YOSTOLE2= 'YOUTH STOLE/TRIED TO STEAL ITEM >$50'
   YOATTAK2= 'YOUTH ATTACKED W/INTENT TO SERIOUSLY HARM'
   YFLPKCG2= 'HOW YTH FEELS: PEERS SMOKE PACK/DAY CIG'
   YFLTMRJ2= 'HOW YTH FEELS: PEERS TRY MJ/HASH'
   YFLADLY2= 'HOW YTH FEELS: PEERS DRNK 1+ALC BEV/DAY'
   YOUTHACT= 'RESP PARTICIPATED IN YOUTH ACTIVITIES'
   PRBSOLV2= 'PARTICIPATED IN PRBSLV/COMMSKILL/SELFESTEEM GROUP'
   PREVIOL2= 'PARTICIPATED IN VIOLENCE PREVENTION PROGRAM'
   PRVDRGO2= 'PARTICIPATED IN DRUG PREV PROGRAM OUTSIDE SCHOOL'
   GRPCNSL2= 'PARTICIPATED IN PROGRAM TO HELP DRUG ABUSE'
   PREGPGM2= 'PARTICIPATED IN PREG/STD PREV PROGRAM'
   DGSPCLS2= 'YOUTH TAKEN SPECIAL CLASS ABOUT DRUGS'
   DGRGCLS2= 'YOUTH DRUG EDUC IN REGULAR CLASS'
   DRGLECT2= 'YOUTH DRUG EDUC OUTSIDE REG CLASS'
   DRPRVME3= 'YOUTH SEEN DRUG PREV MSG OUTSIDE SCH'
   ANYEDUC3= 'YOUTH HAD ANY DRUG EDUC IN SCHOOL'
   CIGFRND = 'FRIEND OR RELATIVE BOUGHT YOUTH CIG IN PAST MONTH'
   CIGVEND = 'YOUTH BOUGHT CIG AT VENDING MACH IN PAST MONTH'
   CIGMAIL = 'YOUTH BOUGHT CIGARETTES THROUGH MAIL IN PAST MONTH'
   CIGCKOUT= 'YOUTH TOOK CIG TO COUNTER FOR PURCH IN PAST MON'
   CIGCLERK= 'YTH BOUGHT CIG WHERE CLERK HANDS THEM IN PAST MON'
   CIGINET = 'YOUTH BOUGHT CIG THROUGH INTERNET IN PAST MONTH'
   CIGSMKT = 'YTH BOUGHT CIG AT A BIG SUPERMARKET IN PAST MONTH'
   CIGDSTO = 'YOUTH BOUGHT CIGARETTES AT DRUG STORE IN PAST MON'
   CIGCONV = 'YTH BOUGHT CIG AT CONVENIENCE STORE IN PAST MONTH'
   CIGINDIV= 'YOUTH BOUGHT CIG FROM AN INDIVIDUAL IN PAST MONTH'
   YTHBGHT = 'YOUTH PERSONALLY BOUGHT CIGARETTES IN PAST MONTH'
   YMSPGRUP= 'OFTEN NERVOUS WHEN W/GRP OF PEOPLE PAST 12 MOS'
   YMSPFNTP= 'OFTEN NERVOUS IN FRONT OF PEOPLE PST 12 MOS'
   YMSAHOME= 'OFTEN WANTED TO STAY HOME W/MOM/DAD PST 12 MOS'
   YMSAACHE= 'HEAD/STOMACHACHES WHEN NOT W/MOM/DAD PST 12 MOS'
   YMSABDRM= 'LOT OF BAD DREAMS/NIGHTMARES PAST 12 MONTHS'
   YMSASLEP= 'OFT WANT MOM/DAD NEAR TO FALL ASLEEP PST 12 MOS'
   YMSAABDN= 'WORRY MOM/DAD GO AWY/NOT COME BACK PST 12 MOS'
   YMSAUPLV= 'OFTEN UPSET WHEN MOM/DAD GO OUT PAST 12 MONTHS'
   YMSAHMSK= 'HOMESICK FOR MOM/DAD PAST 12 MONTHS'
   YMAGOHSF= 'OFTEN AFRAID TO GO OUT OF HOUSE ALONE PST 12 MOS'
   YMAGCRWD= 'OFTEN FELT AFRAID OF CROWDS PAST 12 MONTHS'
   YMAGTRAV= 'OFTEN AFRAID OF TRAVEL IN CAR/BUS/TRAIN PST 12 MOS'
   YMAGBRDG= 'OFTEN AFRAID IN BRIDGES/TUNNELS PAST 12 MONTHS'
   YMPAATAK= 'HAD SUDN ATTACK FELT AFRAID/STRANGE PST 12 MOS'
   YMPASUFC= 'SUDDENLY FELT LIKE SUFFOCATING PAST 12 MONTHS'
   YMGAWORY= 'OFTEN WORRIED BEFORE SPORT/GAME PAST 12 MONTHS'
   YMGAHDAC= 'HAD A LOT OF HEADACHES PAST 12 MONTHS'
   YMGAPAIN= 'HAD A LOT OF OTHER ACHES/PAINS PAST 12 MONTHS'
   YMGATNSE= 'OFTEN BEEN TENSE/NOT RELAXED PAST 12 MONTHS'
   YMPHANML= 'AFRAID OF DOGS/BIRDS/INSECTS/SNAKES/ETC PST 12 MOS'
   YMPHHIGH= 'AFRAID OF BEING HIGH UP PAST 12 MONTHS'
   YMPHDARK= 'AFRAID OF THE DARK PAST 12 MONTHS'
   YMPHNEDL= 'AFRAID OF NEEDLS/SHOTS MORE THAN OTHRS PST 12 MOS'
   YMPHBLOD= 'AFRAID OF SIGHT OF BLOOD PAST 12 MONTHS'
   YMPHBRDG= 'AFRAID OF BEING ON/IN TUNNEL/BRIDGE PST 12 MOS'
   YMPHELEV= 'AFRAID OF ELEVATOR/ESCALATOR PAST 12 MONTHS'
   YMOCCOUN= 'COUNT/DO THINGS OVER & OVER PAST 12 MONTHS'
   YMOCWASH= 'OFT WASH HANDS/CHNG CLOTHES DAILY PST 12 MOS'
   YMOCCHCK= 'OFTEN CHECK ON THINGS OVER & OVER PST 12 MOS'
   YMOCGERM= 'OFTEN WORRY ABOUT DIRT/GERMS PST 12 MOS'
   YMOCTHOT= 'HAD THOTS YOU COULDN''T GET RID OF PST 12 MOS'
   YMEATHIN= 'ANYONE WORRIED YOU''RE MUCH TOO THIN PST 12 MOS'
   YMEAFAT = 'OFTEN FELT BAD THOUGHT YOU''RE FAT PST 12 MOS'
   YMEATHFD= 'THOUGHT ABOUT FOOD ALL OF THE TIME PST 12 MONTHS'
   YMEABING= 'HAD AN EATING BINGE PAST 12 MONTHS'
   YMELWTBD= 'HAVE YOU WET THE BED PAST 12 MONTHS'
   YMELWTPT= 'WET YOUR PANTS DURING DAY PAST 12 MONTHS'
   YMELSOIL= 'SOILED YOURSELF (POOPED PANTS) PST 12 MOS'
   YMMDNINT= 'HAD A TIME WHEN NOTHING WAS FUN PST 12 MOS'
   YMMDLSEG= 'HAD A TIME WHEN HAD LESS ENERGY PST 12 MOS'
   YMMDNOGD= 'FELT COULDN''T DO ANYTHING WELL PST 12 MOS'
   YMMDTHKL= 'SERIOUSLY THOT ABOUT KILLING SELF PST 12 MOS'
   YMMDTYKL= 'TRIED TO KILL YOURSELF PAST 12 MONTHS'
   YMMDTIRD= 'TIME WHN LITTLE THINGS MADE YOU TIRED PST 12 MOS'
   YMMDTHNK= 'TIME WHN YOU COULDN''T THINK CLEARLY PST 12 MOS'
   YMMABDMD= 'TIME WHEN GROUCHY/ANGRY PAST 12 MONTHS'
   YMMARSLS= 'TIME WHEN RESTLESS PAST 12 MONTHS'
   YMMATALK= 'TIME WHEN TALKED TOO MUCH/QUICKLY PAST 12 MONTHS'
   YMMASPAB= 'TIME THOUGHT HAD SPECIAL POWERS PAST 12 MONTHS'
   YMMAMDRC= 'TIME WHEN MIND WAS RACING QUICKLY PAST 12 MONTHS'
   YMADCONC= 'OFTEN HAD HARD TIME CONCENTRATING PAST 12 MONTHS'
   YMADFRGT= 'OFTEN FORGOT WHAT TO BE DOING PAST 12 MONTHS'
   YMADFCUS= 'OFTEN HARD TO KEEP MIND FOCUSED PAST 12 MONTHS'
   YMADMEDS= 'TAKEN MED FOR BEING OVERACTIVE PAST 12 MONTHS'
   YMADAVAT= 'TRIED NOT TO DO THGS THAT REQ ATTENTN PST 12 MOS'
   YMADERRO= 'OFTEN MAKE A LOT OF MISTAKES PAST 12 MONTHS'
   YMODHURT= 'GOTTEN EVEN WITH PEOPLE PAST 12 MONTHS'
   YMODRFUS= 'REFUSED WHAT PARENTS/TCHRS TOLD YOU PST 12 MOS'
   YMODANOY= 'GROUCHY/EASILY ANNOYED PAST 12 MONTHS'
   YMODMEAN= 'DONE MEAN THINGS TO PEOPLE PAST 12 MONTHS'
   YMODBLMO= 'BLAMED SOMEONE ELSE FOR MISTAKES PAST 12 MONTHS'
   YMODTANY= 'DONE THINGS TO ANNOY PEOPLE PAST 12 MONTHS'
   YMODSWOR= 'PEOPLE COMPLAINED B/C YOU SWORE PST 12 MOS'
   YMCDEXPL= 'EXPELLED FOR MISBEHAVIOR PAST 12 MONTHS'
   YMCDSHPL= 'SHOPLIFTED PAST 12 MONTHS'
   YMCDLIED= 'LIED TO GET MONEY/SOMETHING ELSE PAST 12 MONTHS'
   YMCDSNAT= 'SNATCHED A PURSE/JEWELRY PAST 12 MONTHS'
   YMCDVAND= 'BROKE/MESSED UP STHING ON PURPOSE PST 12 MOS'
   YMCDSTOL= 'STOLE FR OTHRS WHN THEY WEREN''T AROUND PST 12 MOS'
   YMCDCRUA= 'CRUEL TO ANIMAL ON PURPOSE PAST 12 MONTHS'
   YMCDBKNT= 'BROKEN INTO A HOUSE/CAR PAST 12 MONTHS'
   YUHOSPYR= 'STAY OVNT IN HOSP FOR EMOT TRMT PST 12 MOS'
   YUHOSPN2= '# NIGHTS STAYED IN HOSP FOR EMOT TRMT PST 12 MOS'
   YUHOSUIC= 'STAYED IN HOSP BEC THOUGHT/TRIED TO KILL SELF'
   YUHODEPR= 'STAYED IN HOSP BEC YOU FELT DEPRESSED'
   YUHOFEAR= 'STAYED IN HOSP BEC YOU FELT AFRAID/TENSE'
   YUHOBKRU= 'STAYED IN HOSP BEC BREAKING RULES/ACTING OUT'
   YUHOEATP= 'STAYED IN HOSP BEC YOU HAD EATING PROBS'
   YUHOSOR = 'STAYED IN HOSP FOR SOME OTHER REASON'
   YURSIDYR= 'STAYED IN RESID CTR FOR EMOT TRMT PST 12 MOS'
   YURSIDN2= '# NIGHTS IN RESID CTR FOR EMOT TRMT PST 12 MOS'
   YURSSUIC= 'STAYED IN RESID CTR BEC THOT/TRIED TO KILL SELF'
   YURSDEPR= 'STAYED IN RESID CTR BEC YOU FELT DEPRESSED'
   YURSFEAR= 'STAYED IN RESID CTR BEC YOU FELT AFRAID/TENSE'
   YURSBKRU= 'STAYED IN RESID CTR BEC BRKING RULES/ACT OUT'
   YURSEATP= 'STAYED IN RESID CTR BEC YOU HAD EATING PROBS'
   YURSSOR = 'STAYED IN RESID CTR FOR SOME OTHER REASON'
   YUFCARYR= 'SPENT TIME IN FOST CARE FOR EMOT PROB PST 12 MOS'
   YUFCARN2= '# NIGHTS IN FOST CARE FOR EMOT PROB PST 12 MOS'
   YUFCSUIC= 'STAYED IN FOST CARE BEC THOT/TRIED TO KILL SELF'
   YUFCDEPR= 'STAYED IN FOST CARE BEC YOU FELT DEPRESSED'
   YUFCFEAR= 'STAYED IN FOST CARE BEC YOU FELT AFRAID/TENSE'
   YUFCBKRU= 'STAYED IN FOST CARE BEC BRKING RULES/ACT OUT'
   YUFCEATP= 'STAYED IN FOST CARE BEC YOU HAD EATING PROBS'
   YUFCSOR = 'STAYED IN FOST CARE FOR SOME OTHER REASON'
   YUDYTXYR= 'SPENT TIME IN DAY TRMT PROG PAST 12 MOS'
   YUDYTXN2= '# TIMES VISITED DAY TRMT PROG PAST 12 MOS'
   YUDYSUIC= 'VISITED DAY TRMT BEC THOT/TRIED TO KILL SELF'
   YUDYDEPR= 'VISITED DAY TRMT BEC YOU FELT DEPRESSED'
   YUDYFEAR= 'VISITED DAY TRMT BEC YOU FELT AFRAID/TENSE'
   YUDYBKRU= 'VISITED DAY TRMT BEC BRKING RULES/ACT OUT'
   YUDYEATP= 'VISITED DAY TRMT BEC YOU HAD EATING PROBS'
   YUDYSOR = 'VISITED DAY TRMT FOR SOME OTHER REASON'
   YUMHCRYR= 'RCVD EMOT TRMT IN MENT HLTH CLNC PST 12 MOS'
   YUMHCRN2= '# TIMES VISITED MENT HLTH CLNC PST 12 MOS'
   YUMHSUIC= 'VISITED MH CLNC BEC THOUGHT/TRIED TO KILL SELF'
   YUMHDEPR= 'VISITED MH CLNC BEC YOU FELT DEPRESSED'
   YUMHFEAR= 'VISITED MH CLNC BEC YOU FELT AFRAID/TENSE'
   YUMHBKRU= 'VISITED MH CLNC BEC BREAKING RULES/ACTING OUT'
   YUMHEATP= 'VISITED MH CLNC BEC YOU HAD EATING PROBS'
   YUMHSOR = 'VISITED MH CLNC FOR SOME OTHER REASON'
   YUTPSTYR= 'RCVD EMOT TRMT FROM THERAPIST PST 12 MOS'
   YUTPSTN2= '# TIMES VISITED THERAPIST PAST 12 MONTHS'
   YUTPSUIC= 'VISITED THERAPIST BEC THOT/TRIED TO KILL SELF'
   YUTPDEPR= 'VISITED THERAPIST BEC YOU FELT DEPRESSED'
   YUTPFEAR= 'VISITED THERAPIST BEC YOU FELT AFRAID/TENSE'
   YUTPBKRU= 'VISITED THERAPIST BEC BRKING RULES/ACT OUT'
   YUTPEATP= 'VISITED THERAPIST BEC YOU HAD EATING PROBS'
   YUTPSOR = 'VISITED THERAPIST FOR SOME OTHER REASON'
   YUIHTPYR= 'RCVD EMOT TRMT FROM IN HOME COUNS PST 12 MOS'
   YUIHTPN2= '# TIMES RCVD TRMT FR IN HOME COUNS PST 12 MOS'
   YUIHSUIC= 'SAW IN HOME COUNS BEC THOT/TRIED TO KILL SELF'
   YUIHDEPR= 'SAW IN HOME COUNS BEC YOU FELT DEPRESSED'
   YUIHFEAR= 'SAW IN HOME COUNS BEC YOU FELT AFRAID/TENSE'
   YUIHBKRU= 'SAW IN HOME COUNS BEC BRKING RULES/ACT OUT'
   YUIHEATP= 'SAW IN HOME COUNS BEC YOU HAD EATING PROBS'
   YUIHSOR = 'SAW IN HOME COUNS FOR SOME OTHER REASON'
   YUFDOCYR= 'RCVD EMOT TRMT FROM FAMLY DOC PST 12 MOS'
   YUFDOCN2= '# TIMES RCVD TRMT FROM FAMLY DOC PST 12 MOS'
   YUFDSUIC= 'SAW FAMLY DOC BEC THOUGHT/TRIED TO KILL SELF'
   YUFDDEPR= 'SAW FAMLY DOC BEC YOU FELT DEPRESSED'
   YUFDFEAR= 'SAW FAMLY DOC BEC YOU FELT AFRAID/TENSE'
   YUFDBKRU= 'SAW FAMLY DOC BEC BREAKING RULES/ACTING OUT'
   YUFDEATP= 'SAW FAMLY DOC BEC YOU HAD EATING PROBS'
   YUFDSOR = 'SAW FAMLY DOC FOR SOME OTHER REASON'
   YUSPEDYR= 'SPECIAL EDUC SVCS FOR EMOT PROB PST 12 MOS'
   YUSHCNYR= 'TALKED W/SCH COUNS FOR EMOT PROB PST 12 MOS'
   YUSHSUIC= 'TLKED W/SCH COUNS BEC THOT/TRIED TO KILL SELF'
   YUSHDEPR= 'TLKED W/SCH COUNS BEC YOU FELT DEPRESSED'
   YUSHFEAR= 'TLKED W/SCH COUNS BEC YOU FELT AFRAID/TENSE'
   YUSHBKRU= 'TLKED W/SCH COUNS BEC BRKING RULES/ACT OUT'
   YUSHEATP= 'TLKED W/SCH COUNS BEC YOU HAD EATING PROBS'
   YUSHSOR = 'TLKED W/SCH COUNS FOR SOME OTHER REASON'
   YUJAILEV= 'EVER BEEN IN JAIL OR DETENTION CENTER'
   YUFCAREV= 'EVER BEEN IN FOSTER CARE'
   IRHHSIZ2= 'RECODE - IMPUTATION-REVISED # PERSONS IN HH'
   IIHHSIZ2= 'IRHHSIZ2-IMPUTATION INDICATOR'
   IRHH65_2= 'REC - IMPUTATION-REVISED # OF PER IN HH AGED>=65'
   IIHH65_2= 'IRHH65_2-IMPUTATION INDICATOR'
   IRKI17_2= 'RECODE - IMPUTATION-REVISED # KIDS AGED<18 IN HH'
   IIKI17_2= 'IRKI17_2-IMPUTATION INDICATOR'
   IMOTHER = 'MOTHER IN HH'
   IFATHER = 'FATHER IN HH'
   NRCH17_2= '# R''S CHILDREN < 18 IN HOUSEHOLD'
   PREGNANT= 'ARE YOU PREGNANT'
   NMERTMT2= '# OF TIMES BEEN TREATED IN EMER ROOM PAST 12 MOS'
   INHOSPYR= 'STAYED OVERNIGHT AS INPNT IN HOSP PAST 12 MOS'
   NMNGTHS2= '# NIGHTS STAYED IN HOSPITAL OVERNIGHT OR LONGER'
   PROXANS2= 'IS PROXY ANSWERING INSURANCE/INCOME QS'
   PREG    = 'PREGNANT FEMALES AGED 12-44'
   PREG2   = 'PREGNANCY STATUS OF FEMALES AGED 12-44'
   TRIMEST = 'CURRENT TRIMESTER OF PREGNANCY - FEMALES AGE 12-44'
   IRPSOC  = 'IMP. REVISED- RESP RECEIVE SS OR RR PAYMENTS'
   IIPSOC  = 'IRPSOC - IMPUTATION INDICATOR'
   IRFAMSOC= 'IMP. REVISED-FAM RECEIVE SS OR RR PAYMENTS'
   IIFAMSOC= 'IRFAMSOC-IMPUTATION INDICATOR'
   IRPSSI  = 'IMP. REVISED- RESP RECEIVE SSI'
   IIPSSI  = 'IRPSSI - IMPUTATION INDICATOR'
   IRFAMSSI= 'IMP. REVISED- FAM RECEIVE SSI'
   IIFAMSSI= 'IRFAMSSI-IMPUTATION INDICATOR'
   IRFSTAMP= 'IMP. REVISED-RESP/OTH FAM MEM REC FOOD STAMPS'
   IIFSTAMP= 'IRFSTAMP-IMPUTATION INDICATOR'
   IRPPMT  = 'IMP. REVISED-RESP RECEIVE PUBLIC ASSIST'
   IIPPMT  = 'IRPPMT - IMPUTATION INDICATOR'
   IRFAMPMT= 'IMP. REVISED-FAM RECEIVE PUBLIC ASSIST'
   IIFAMPMT= 'IRFAMPMT -IMPUTATION INDICATOR'
   IRPSVC  = 'IMP. REVISED- RESP REC WELFARE/JOB PL/CHILD CARE'
   IIPSVC  = 'IRPSVC - IMPUTATION INDICATOR'
   IRFAMSVC= 'IMP. REVISED- FAM REC WELFARE/JOB PL/CHILDCARE'
   IIFAMSVC= 'IRFAMSVC-IMPUTATION INDICATOR'
   IRWELMOS= 'IMP. REVISED- NO.OF MONTHS ON WELFARE'
   IIWELMOS= 'IRWELMOS-IMPUTATION INDICATOR'
   IRPINT  = 'IMP.REVISED-RESP REC INTEREST SAVING/DIVIDEND'
   IIPINT  = 'IRPINT - IMPUTATION INDICATOR'
   IRFAMINT= 'IMP. REV-FAM REC INTEREST SAVING/DIVIDEND'
   IIFAMINT= 'IRFAMINT-IMPUTATION INDICATOR'
   IRPCHD  = 'IMP. REVISED-RESP REC CHILD SUPPORT PAYMENTS'
   IIPCHD  = 'IRPCHD - IMPUTATION INDICATOR'
   IRFAMCHD= 'IMP. REVISED-FAM REC CHILD SUPPORT PAYMENTS'
   IIFAMCHD= 'IRFAMCHD -IMPUTATION INDICATOR'
   IRPWAG  = 'IMP. REVISED-RESP RECEIVE INCOME FROM JOB'
   IIPWAG  = 'IRPWAG - IMPUTATION INDICATOR'
   IRFAMWAG= 'IMP. REVISED-FAM REC INCOME FROM JOB'
   IIFAMWAG= 'IRFAMWAG -IMPUTATION INDICATOR'
   IRPOTH  = 'IMP.REVISED-RESP REC OTH INCOME FROM OTH SOURCE'
   IIPOTH  = 'IRPOTH - IMPUTATION INDICATOR'
   IRFAMOTH= 'IMP. REVISED-FAM REC OTH INC FR OTH SOURCE'
   IIFAMOTH= 'IRFAMOTH -IMPUTATION INDICATOR'
   IRPINC3 = 'RECODE - IMP.REVISED-RESP''S TOT INC'
   IIPINC3 = 'IRPINC3 - IMPUTATION INDICATOR'
   IRFAMIN3= 'RECODE - IMP.REVISED -TOT FAM INCOME'
   IIFAMIN3= 'IRFAMIN3 -IMPUTATION INDICATOR'
   GOVTPROG= 'PARTICIPATED IN ONE OR MORE GOVT ASSIST PROGRAMS'
   HLCALLFG= 'FLAG IF EVERY FORM OF HEALTH INS REPORTED'
   HLCALL99= 'YES TO MEDICARE/MEDICAID/CHAMPUS/PRVHLTIN'
   MEDICARE= 'COVERED BY MEDICARE'
   MEDICAID= 'COVERED BY MEDICAID'
   CHAMPUS = 'COVERED BY CHAMPUS, CHAMPVA, VA, MILITARY'
   OGOVTINS= 'COVERED BY OTHER GOVT SPONSORED PROGRAM'
   OGOVINS2= 'OTHER GOVT SPONSORED COVERAGE - SPECIFY'
   PRVHLTIN= 'COVERED BY PRIVATE INSURANCE'
   GRPHLTIN= 'PRIVATE PLAN OFFERED THROUGH EMPLOYER OR UNION'
   HLTINALC= 'ALCOHOL ABUSE OR ALCOHOLISM'
   HLTINDRG= 'DRUG ABUSE'
   HLTINMNT= 'MENTAL OR EMOTIONAL DIFFICULTIES'
   OTHLTINS= 'COVERED BY OTHER TYPE OF HEALTH INSURANCE'
   OTHLINS2= 'OTHER TYPE OF HEALTH INSURANCE - SPECIFY'
   HLCNOTYR= 'ANYTIME DID NOT HAVE HEALTH INS/COVER PAST 12 MOS'
   HLCNOTMO= 'PAST 12 MOS, HOW MANY MOS W/O COVERAGE'
   HLCLAST = 'TIME SINCE LAST HAD HEALTH CARE COVERAGE'
   HLCPRIVT= 'PRIVATE HEALTH INSURANCE'
   HLCMCAID= 'MEDICAID OR MEDICAL ASSISTANCE'
   HLCMILT = 'MILITARY HEALTH CARE (CHAMPUS,TRICARE,CHAMPVA,VA)'
   HLCMCARE= 'MEDICARE'
   HLCOGOVT= 'SOME OTHER GOVERNMENT PROGRAM'
   HLCOTHER= 'SOME OTHER KIND OF COVERAGE (SPECIFY)'
   HLCOTHS2= 'LAST KIND OF HEALTH COVERAGE SPECIFIED'
   HLLLOSJB= 'PERS IN FAM W/HEALTH INS LOST JOB/CHANGED EMP'
   HLLMAJOB= 'LOST MEDICAID/MED ASSIST B/C NEW JOB/PAY INCREASE'
   HLLMASOR= 'LOST MEDICAID/MED ASSIST FOR SOME OTH REASON'
   HLLCOST = 'COST TOO HIGH/CAN''T AFFORD PREMIUMS'
   HLLINELG= 'BECAME INELIGIBLE B/C AGE OR LEAVING SCHOOL'
   HLLNOFFR= 'EMPLOYER DOES NOT OFFER COVERAGE/NOT ELIGIBLE'
   HLLDIVOR= 'DIVORCED/SEPARATED FROM PERSON W/INSURANCE'
   HLLDEATH= 'DEATH OF SPOUSE OR PARENT'
   HLLREFUS= 'INSURANCE COMPANY REFUSED COVERAGE'
   HLLNONED= 'DON''T NEED IT'
   HLLSOR  = 'LOST HEALTH INSURANCE FOR SOME OTHER REASON'
   HLLSORS2= 'OTHER REASON FOR LOSING HLTH INS - SPECIFY'
   HLNVCOST= 'COST TOO HIGH'
   HLNVOFFR= 'EMPLOYER DOESN''T OFFER'
   HLNVREF = 'INSURANCE COMPANY REFUSED COVERAGE'
   HLNVNEED= 'DON''T NEED IT'
   HLNVSOR = 'NEVER HAD HLTH INS SOME OTHER REASON'
   HLNVSP2 = 'OTHER REASON NEVER HAD HLTH INS - SPECIFY'
   IRPINSUR= 'IMPUTATION-REVISED PRIVATE HEALTH INSURANCE'
   IIPINSUR= 'IMPUTATION - INDICATOR IRPINSUR'
   IRINSUR = 'IMPUTATION-REVISED HEALTH INSURANCE'
   IIINSUR = 'IMPUTATION-INDICATOR IRINSUR'
   IRINSUR2= 'IMPUTATION-REVISED HEALTH INSURANCE'
   IIINSUR2= 'IMPUTATION-INDICATOR IRINSUR'
   LANGVER = 'LANGUAGE VERSION'
   QUARTER = 'QUARTER INDICATOR'
   GQTYPE  = 'TYPE OF GROUP QUARTER'
   AGE2    = 'RECODE - FINAL EDITED AGE'
   NOMARR2 = 'NUMBER OF TIMES MARRIED'
   SERVICE = 'EVER BEEN IN THE US ARMED FORCES'
   MILSTAT = 'CURRENT MILITARY STATUS'
   HEALTH  = 'OVERALL HEALTH'
   IRSEX   = 'IMPUTATION REVISED GENDER'
   IISEX   = 'IMPUTATION REVISED GENDER INDICATOR'
   IRMARIT = 'IMPUTATION REVISED MARITAL STATUS'
   IIMARIT = 'IMPUTATION REVISED MARITAL STATUS INDICATOR'
   IREDUC2 = 'RECODE - IMPUTATION REVISED EDUCATION'
   IIEDUC2 = 'IMPUTATION REVISED EDUCATION INDICATOR'
   EMPSTAT3= 'IMPUTATION REVISED EMPLOYMENT STATUS'
   IIEMPST3= 'IMPUTATION REVISED EMPLOYMENT STATUS INDICATOR'
   EMPSTATY= 'IMPUTATION REVISED EMPLOYMENT STATUS'
   IIEMPSTY= 'IMPUTATION REVISED EMPLOYMENT STATUS INDICATOR'
   EMPSTAT4= 'IMP. REV. WORK STATUS CPS NO OTH. SPEC.'
   IIEMPST4= 'IMPUTATION REVISED EMPLOYMENT STATUS INDICATOR'
   MOVESPY2= '# TIMES MOVED PAST 12 MONTHS'
   ENROLED = 'NOW ENROLLED IN ANY SCHOOL'
   EDUCNOW2= 'RECODE- WHAT GRADE IN NOW'
   STUDNT  = 'FULL OR PART TIME'
   SCHDSICK= 'HOW MANY DAYS MISSED SCHOOL FROM SICK'
   SCHDSKIP= 'HOW MANY DAYS MISSED SCHOOL FROM SKIPPING'
   HSDIPLMA= 'RECEIVED DIPLOMA'
   HSGED   = 'RECEIVED GED'
   LFSCHWH2= 'WHY YOU LEFT SCHOOL'
   LFTSCHA2= 'AGE WHEN STOPPED ATTENDING SCHOOL'
   RLGSVCYR= 'PAST 12 MOS, HOW MANY RELIG. SERVICES'
   RLGIMPRT= 'MY RELIGIOUS BELIEFS ARE VERY IMPORTANT'
   RLGDECSN= 'MY RELIGIOUS BELIEFS INFLUENCE MY DECISIONS'
   RLGFRNDS= 'IT IS IMPORTANT THAT MY FRIENDS SHARE REL BELIEFS'
   TELNO2  = '# OF TELEPHONE LINES IN HOUSEHOLD'
   TUCHTONE= 'ANY PHONES TOUCHTONE'
   COLLEGE2= 'COLLEGE ENROLLMENT'
   CATAGE  = 'AGE CATEGORY'
   CATAG2  = 'AGE CATEGORY RECODE (3 LEVELS)'
   CATAG3  = 'AGE CATEGORY RECODE (5 LEVELS)'
   CATAG7  = 'AGE CATEGORY RECODE (7 LEVELS)'
   NEWRACE2= 'RACE/HISPANICITY RECODE (7 LEVELS)'
   EDUCCAT2= 'EDUCATION RECODE'
   JOBSTAT2= 'WORK SITUATION IN PAST WEEK - RECODE'
   JBSTATR2= 'WORK SITUATION IN PAST WEEK - RECODE'
   WRKHAVJB= 'DID YOU HAVE A JOB OR BUSINESS'
   WRKHRSWK= 'HOW MANY HOURS WORKED LAST WEEK'
   WRKINDU2= 'TYPE OF BUSINESS OR INDUSTRY'
   WRKOCCU2= 'KIND OF WORK/JOB TITLE PRIMARY JOB'
   WRKBZCA2= 'CATEG THAT BEST DESCR BUSINESS YOU WORK IN'
   WRKEFFRT= 'PAST 30 DAYS, MAKE EFFORT TO FIND WORK'
   WRKEDYR = 'PAST 12 MOS, WORKED AT ANY JOB'
   WRKSLFEM= 'PAST 12 MOS, SELF EMPLOYED'
   WRKJOBS2= 'PAST 12 MOS, HOW MANY EMPLOYERS'
   WRKUNEMP= 'PAST 12 MOS, TIME WITH NO JOB'
   WRKUNWKS= 'HOW MANY WKS W/O JOB IN PAST 12 MOS'
   WRKLASY2= 'WHAT YEAR LAST WORKED'
   WRKINDY2= 'TYPE OF BUSINESS OR INDUSTRY'
   WRKOCCY2= 'KIND OF WORK/JOB TITLE PRIMARY JOB'
   WORKDAYS= '# DAYS MISSED WORK FOR INJURY/ILLNESS PAST 30 DAYS'
   WORKBLAH= '# DAYS SKIPPED WORK PAST 30 DAYS'
   LOCSIZE = '# PEOPLE THAT WORK FOR EMPLOYER - RESP''S LOCATION'
   DRGPLCY = 'WORKPLACE HAVE WRITTEN POLICY DRUG/ALCOHOL USE'
   PLCYCOV = 'DID POLICY COVER ALCOHOL, DRUGS, OR  BOTH'
   WKDRGED = 'AT WORK, GIVEN EDUCATION ON DRUGS/ALC'
   DRGPRGM = 'ANY ASSISTANCE PROGRAM OFFERED THROUGH WRK'
   USALCTST= 'WORKPLACE TESTS FOR ALCOHOL USAGE'
   USDRGTST= 'WORKPLACE TESTS FOR DRUG USAGE'
   TSTHIRE = 'TEST FOR DRUG/ALC AS HIRING PROCESS'
   TSTRAND = 'TEST ON RANDOM BASIS'
   FIRSTPOS= 'WHAT HAPPENS FIRST TIME CAUGHT'
   WRKHIRE = 'WOULD YOU WORK FOR EMP DOES DRUG TEST PRE-HIRE'
   WORKRAND= 'WOULD YOU WORK FOR EMP DOES DRUG/ALC TEST RANDOMLY'
   FIEXP99 = 'COMPLETED SOME INTERVIEWS IN 1999'
   PDEN    = 'POPULATION DENSITY'
   VESTR   = 'ANALYSIS STRATUM'
   VEREP   = 'ANALYSIS REPLICATE'
   ANALWT_C= 'FIN PRSN-LEVEL SMPLE WGHT'
        ;


* USER-DEFINED MISSING VALUES RECODE TO SAS SYSMIS;

/*
   IF (CIGOFRSM >= 81) THEN CIGOFRSM = .;
   IF (CIGWILYR >= 81) THEN CIGWILYR = .;
   IF (CIGTRY >= 981) THEN CIGTRY = .;
   IF (CIGYFU >= 9981) THEN CIGYFU = .;
   IF (CIGMFU >= 81) THEN CIGMFU = .;
   IF (CIGREC >= 81) THEN CIGREC = .;
   IF (CIG30USE >= 81) THEN CIG30USE = .;
   IF (CG30EST >= 81) THEN CG30EST = .;
   IF (CIG30AV >= 81) THEN CIG30AV = .;
   IF (CIG30BR2 >= 9981) THEN CIG30BR2 = .;
   IF (CIG30TYP >= 81) THEN CIG30TYP = .;
   IF (CIG30MEN >= 81) THEN CIG30MEN = .;
   IF (CIG30RO2 >= 81) THEN CIG30RO2 = .;
   IF (CIGDLYMO >= 81) THEN CIGDLYMO = .;
   IF (CIGAGE >= 981) THEN CIGAGE = .;
   IF (CIG100LF >= 81) THEN CIG100LF = .;
   IF (CHEWEVER >= 81) THEN CHEWEVER = .;
   IF (CHEWTRY >= 981) THEN CHEWTRY = .;
   IF (CHEWYFU >= 9981) THEN CHEWYFU = .;
   IF (CHEWMFU >= 81) THEN CHEWMFU = .;
   IF (CHEWREC >= 81) THEN CHEWREC = .;
   IF (CHW30USE >= 81) THEN CHW30USE = .;
   IF (CH30EST >= 81) THEN CH30EST = .;
   IF (CHW30BR2 >= 9981) THEN CHW30BR2 = .;
   IF (SNFEVER >= 81) THEN SNFEVER = .;
   IF (SNUFTRY >= 981) THEN SNUFTRY = .;
   IF (SNUFYFU >= 9981) THEN SNUFYFU = .;
   IF (SNUFMFU >= 81) THEN SNUFMFU = .;
   IF (SNFREC >= 81) THEN SNFREC = .;
   IF (SNF30USE >= 81) THEN SNF30USE = .;
   IF (SN30EST >= 81) THEN SN30EST = .;
   IF (SNF30BR2 >= 9981) THEN SNF30BR2 = .;
   IF (SLTTRY >= 981) THEN SLTTRY = .;
   IF (SLTYFU >= 9981) THEN SLTYFU = .;
   IF (SLTMFU >= 81) THEN SLTMFU = .;
   IF (SLTREC >= 81) THEN SLTREC = .;
   IF (SLT30BR2 >= 9981) THEN SLT30BR2 = .;
   IF (SLT30FAV >= 81) THEN SLT30FAV = .;
   IF (CIGAREVR >= 81) THEN CIGAREVR = .;
   IF (CIGARTRY >= 981) THEN CIGARTRY = .;
   IF (CIGARYFU >= 9981) THEN CIGARYFU = .;
   IF (CIGARMFU >= 81) THEN CIGARMFU = .;
   IF (CIGARREC >= 81) THEN CIGARREC = .;
   IF (CGR30USE >= 81) THEN CGR30USE = .;
   IF (CI30EST >= 81) THEN CI30EST = .;
   IF (CGR30BR2 >= 9981) THEN CGR30BR2 = .;
   IF (PIPEVER >= 81) THEN PIPEVER = .;
   IF (PIPE30DY >= 81) THEN PIPE30DY = .;
   IF (ALCEVER >= 81) THEN ALCEVER = .;
   IF (ALCTRY >= 981) THEN ALCTRY = .;
   IF (ALCYFU >= 9981) THEN ALCYFU = .;
   IF (ALCMFU >= 81) THEN ALCMFU = .;
   IF (ALCREC >= 81) THEN ALCREC = .;
   IF (ALCYRTOT >= 981) THEN ALCYRTOT = .;
   IF (ALTOTFG >= 81) THEN ALTOTFG = .;
   IF (ALFQFLG >= 81) THEN ALFQFLG = .;
   IF (ALBSTWAY >= 81) THEN ALBSTWAY = .;
   IF (ALDAYPYR >= 981) THEN ALDAYPYR = .;
   IF (ALDAYPMO >= 81) THEN ALDAYPMO = .;
   IF (ALDAYPWK >= 81) THEN ALDAYPWK = .;
   IF (ALCDAYS >= 81) THEN ALCDAYS = .;
   IF (AL30EST >= 81) THEN AL30EST = .;
   IF (ALDYSFG >= 81) THEN ALDYSFG = .;
   IF (NODR30A >= 981) THEN NODR30A = .;
   IF (DR5DAY >= 80) THEN DR5DAY = .;
   IF (MJEVER >= 81) THEN MJEVER = .;
   IF (MJAGE >= 981) THEN MJAGE = .;
   IF (MJYFU >= 9981) THEN MJYFU = .;
   IF (MJMFU >= 81) THEN MJMFU = .;
   IF (MJREC >= 81) THEN MJREC = .;
   IF (MJYRTOT >= 981) THEN MJYRTOT = .;
   IF (MRTOTFG >= 81) THEN MRTOTFG = .;
   IF (MJFQFLG >= 81) THEN MJFQFLG = .;
   IF (MRBSTWAY >= 81) THEN MRBSTWAY = .;
   IF (MRDAYPYR >= 981) THEN MRDAYPYR = .;
   IF (MRDAYPMO >= 81) THEN MRDAYPMO = .;
   IF (MRDAYPWK >= 81) THEN MRDAYPWK = .;
   IF (MJDAY30A >= 81) THEN MJDAY30A = .;
   IF (MR30EST >= 81) THEN MR30EST = .;
   IF (COCEVER >= 81) THEN COCEVER = .;
   IF (COCAGE >= 981) THEN COCAGE = .;
   IF (COCYFU >= 9981) THEN COCYFU = .;
   IF (COCMFU >= 81) THEN COCMFU = .;
   IF (COCREC >= 81) THEN COCREC = .;
   IF (COCYRTOT >= 981) THEN COCYRTOT = .;
   IF (CCTOTFG >= 81) THEN CCTOTFG = .;
   IF (CCFQFLG >= 81) THEN CCFQFLG = .;
   IF (CCBSTWAY >= 81) THEN CCBSTWAY = .;
   IF (CCDAYPYR >= 981) THEN CCDAYPYR = .;
   IF (CCDAYPMO >= 81) THEN CCDAYPMO = .;
   IF (CCDAYPWK >= 81) THEN CCDAYPWK = .;
   IF (COCUS30A >= 81) THEN COCUS30A = .;
   IF (CC30EST >= 81) THEN CC30EST = .;
   IF (CRKEVER >= 81) THEN CRKEVER = .;
   IF (CRKAGE >= 981) THEN CRKAGE = .;
   IF (CRKYFU >= 9981) THEN CRKYFU = .;
   IF (CRKMFU >= 81) THEN CRKMFU = .;
   IF (CRAKREC >= 81) THEN CRAKREC = .;
   IF (CRKYRTOT >= 981) THEN CRKYRTOT = .;
   IF (CRTOTFG >= 81) THEN CRTOTFG = .;
   IF (CRFQFLG >= 81) THEN CRFQFLG = .;
   IF (CRBSTWAY >= 81) THEN CRBSTWAY = .;
   IF (CRDAYPYR >= 981) THEN CRDAYPYR = .;
   IF (CRDAYPMO >= 81) THEN CRDAYPMO = .;
   IF (CRDAYPWK >= 81) THEN CRDAYPWK = .;
   IF (CRKUS30A >= 81) THEN CRKUS30A = .;
   IF (CR30EST >= 81) THEN CR30EST = .;
   IF (HEREVER >= 81) THEN HEREVER = .;
   IF (HERAGE >= 981) THEN HERAGE = .;
   IF (HERYFU >= 9981) THEN HERYFU = .;
   IF (HERMFU >= 81) THEN HERMFU = .;
   IF (HERREC >= 81) THEN HERREC = .;
   IF (HERYRTOT >= 981) THEN HERYRTOT = .;
   IF (HRTOTFG >= 81) THEN HRTOTFG = .;
   IF (HRFQFLG >= 81) THEN HRFQFLG = .;
   IF (HRBSTWAY >= 81) THEN HRBSTWAY = .;
   IF (HRDAYPYR >= 981) THEN HRDAYPYR = .;
   IF (HRDAYPMO >= 81) THEN HRDAYPMO = .;
   IF (HRDAYPWK >= 81) THEN HRDAYPWK = .;
   IF (HER30USE >= 81) THEN HER30USE = .;
   IF (HR30EST >= 81) THEN HR30EST = .;
   IF (LSD >= 81) THEN LSD = .;
   IF (PCP >= 81) THEN PCP = .;
   IF (PEYOTE >= 81) THEN PEYOTE = .;
   IF (MESC >= 81) THEN MESC = .;
   IF (PSILCY >= 81) THEN PSILCY = .;
   IF (ECSTASY >= 81) THEN ECSTASY = .;
   IF (HALNOLST >= 81) THEN HALNOLST = .;
   IF (HALNEWA >= 9981) THEN HALNEWA = .;
   IF (HALNEWB >= 9981) THEN HALNEWB = .;
   IF (HALNEWC >= 9981) THEN HALNEWC = .;
   IF (HALNEWD >= 9981) THEN HALNEWD = .;
   IF (HALNEWE >= 9981) THEN HALNEWE = .;
   IF (HALLAGE >= 981) THEN HALLAGE = .;
   IF (HALYFU >= 9981) THEN HALYFU = .;
   IF (HALMFU >= 81) THEN HALMFU = .;
   IF (HALLREC >= 81) THEN HALLREC = .;
   IF (HALYRTOT >= 981) THEN HALYRTOT = .;
   IF (HLTOTFG >= 81) THEN HLTOTFG = .;
   IF (HLFQFLG >= 81) THEN HLFQFLG = .;
   IF (HLBSTWAY >= 81) THEN HLBSTWAY = .;
   IF (HLDAYPYR >= 981) THEN HLDAYPYR = .;
   IF (HLDAYPMO >= 81) THEN HLDAYPMO = .;
   IF (HLDAYPWK >= 81) THEN HLDAYPWK = .;
   IF (HAL30USE >= 81) THEN HAL30USE = .;
   IF (HL30EST >= 81) THEN HL30EST = .;
   IF (LSDAGE >= 981) THEN LSDAGE = .;
   IF (LSDYFU >= 9981) THEN LSDYFU = .;
   IF (LSDMFU >= 81) THEN LSDMFU = .;
   IF (LSDREC >= 81) THEN LSDREC = .;
   IF (PCPAGE >= 981) THEN PCPAGE = .;
   IF (PCPYFU >= 9981) THEN PCPYFU = .;
   IF (PCPMFU >= 81) THEN PCPMFU = .;
   IF (PCPREC >= 81) THEN PCPREC = .;
   IF (AMYLNIT >= 81) THEN AMYLNIT = .;
   IF (CLEFLU >= 81) THEN CLEFLU = .;
   IF (GAS >= 81) THEN GAS = .;
   IF (GLUE >= 81) THEN GLUE = .;
   IF (ETHER >= 81) THEN ETHER = .;
   IF (SOLVENT >= 81) THEN SOLVENT = .;
   IF (LGAS >= 81) THEN LGAS = .;
   IF (NITOXID >= 81) THEN NITOXID = .;
   IF (SPPAINT >= 81) THEN SPPAINT = .;
   IF (AEROS >= 81) THEN AEROS = .;
   IF (INHNOLST >= 81) THEN INHNOLST = .;
   IF (INHNEWA >= 9981) THEN INHNEWA = .;
   IF (INHNEWB >= 9981) THEN INHNEWB = .;
   IF (INHNEWC >= 9981) THEN INHNEWC = .;
   IF (INHNEWD >= 9981) THEN INHNEWD = .;
   IF (INHNEWE >= 9981) THEN INHNEWE = .;
   IF (INHAGE >= 981) THEN INHAGE = .;
   IF (INHYFU >= 9981) THEN INHYFU = .;
   IF (INHMFU >= 81) THEN INHMFU = .;
   IF (INHREC >= 81) THEN INHREC = .;
   IF (INHYRTOT >= 981) THEN INHYRTOT = .;
   IF (INTOTFG >= 81) THEN INTOTFG = .;
   IF (INFQFLG >= 81) THEN INFQFLG = .;
   IF (INBSTWAY >= 81) THEN INBSTWAY = .;
   IF (INDAYPYR >= 981) THEN INDAYPYR = .;
   IF (INDAYPMO >= 81) THEN INDAYPMO = .;
   IF (INDAYPWK >= 81) THEN INDAYPWK = .;
   IF (INHDY30A >= 81) THEN INHDY30A = .;
   IF (IN30EST >= 81) THEN IN30EST = .;
   IF (DARVTYLC >= 81) THEN DARVTYLC = .;
   IF (PERCTYLX >= 81) THEN PERCTYLX = .;
   IF (VICOLOR >= 81) THEN VICOLOR = .;
   IF (ANLCARD >= 81) THEN ANLCARD = .;
   IF (CODEINE >= 81) THEN CODEINE = .;
   IF (DEMEROL >= 81) THEN DEMEROL = .;
   IF (DILAUD >= 81) THEN DILAUD = .;
   IF (FIORICET >= 81) THEN FIORICET = .;
   IF (FIORINAL >= 81) THEN FIORINAL = .;
   IF (HYDROCOD >= 81) THEN HYDROCOD = .;
   IF (METHDON >= 81) THEN METHDON = .;
   IF (MORPHINE >= 81) THEN MORPHINE = .;
   IF (OXYCONTN >= 81) THEN OXYCONTN = .;
   IF (PHENCOD >= 81) THEN PHENCOD = .;
   IF (PROPOXY >= 81) THEN PROPOXY = .;
   IF (SK65A >= 81) THEN SK65A = .;
   IF (STADOL >= 81) THEN STADOL = .;
   IF (TALACEN >= 81) THEN TALACEN = .;
   IF (TALWIN >= 81) THEN TALWIN = .;
   IF (TALWINNX >= 81) THEN TALWINNX = .;
   IF (TRAMADOL >= 81) THEN TRAMADOL = .;
   IF (ULTRAM >= 81) THEN ULTRAM = .;
   IF (ANLNOLST >= 81) THEN ANLNOLST = .;
   IF (ANALNEWA >= 9981) THEN ANALNEWA = .;
   IF (ANALNEWB >= 9981) THEN ANALNEWB = .;
   IF (ANALNEWC >= 9981) THEN ANALNEWC = .;
   IF (ANALNEWD >= 9981) THEN ANALNEWD = .;
   IF (ANALNEWE >= 9981) THEN ANALNEWE = .;
   IF (ANALAGE >= 981) THEN ANALAGE = .;
   IF (ANALYFU >= 9981) THEN ANALYFU = .;
   IF (ANALMFU >= 81) THEN ANALMFU = .;
   IF (ANALREC >= 81) THEN ANALREC = .;
   IF (ANLYRTOT >= 981) THEN ANLYRTOT = .;
   IF (PRTOTFG >= 81) THEN PRTOTFG = .;
   IF (PRFQFLG >= 81) THEN PRFQFLG = .;
   IF (PRBSTWAY >= 81) THEN PRBSTWAY = .;
   IF (PRDAYPYR >= 981) THEN PRDAYPYR = .;
   IF (PRDAYPMO >= 81) THEN PRDAYPMO = .;
   IF (PRDAYPWK >= 81) THEN PRDAYPWK = .;
   IF (KLONOPIN >= 81) THEN KLONOPIN = .;
   IF (XNAXATVN >= 81) THEN XNAXATVN = .;
   IF (VALMDIAZ >= 81) THEN VALMDIAZ = .;
   IF (TRNCARD >= 81) THEN TRNCARD = .;
   IF (ATARAX >= 81) THEN ATARAX = .;
   IF (BUSPAR >= 81) THEN BUSPAR = .;
   IF (EQUANIL >= 81) THEN EQUANIL = .;
   IF (FLEXERIL >= 81) THEN FLEXERIL = .;
   IF (LIBRIUM >= 81) THEN LIBRIUM = .;
   IF (LIMBTROL >= 81) THEN LIMBTROL = .;
   IF (MEPROB >= 81) THEN MEPROB = .;
   IF (MILTOWN >= 81) THEN MILTOWN = .;
   IF (ROHYPNOL >= 81) THEN ROHYPNOL = .;
   IF (SERAX >= 81) THEN SERAX = .;
   IF (SOMA >= 81) THEN SOMA = .;
   IF (TRANXENE >= 81) THEN TRANXENE = .;
   IF (VISTAR >= 81) THEN VISTAR = .;
   IF (TRNOLST >= 81) THEN TRNOLST = .;
   IF (TRNEWA >= 9981) THEN TRNEWA = .;
   IF (TRNEWB >= 9981) THEN TRNEWB = .;
   IF (TRNEWC >= 9981) THEN TRNEWC = .;
   IF (TRNEWD >= 9981) THEN TRNEWD = .;
   IF (TRNEWE >= 9981) THEN TRNEWE = .;
   IF (TRANAGE >= 981) THEN TRANAGE = .;
   IF (TRANYFU >= 9981) THEN TRANYFU = .;
   IF (TRANMFU >= 81) THEN TRANMFU = .;
   IF (TRANREC >= 81) THEN TRANREC = .;
   IF (TRNYRTOT >= 981) THEN TRNYRTOT = .;
   IF (TRTOTFG >= 81) THEN TRTOTFG = .;
   IF (TRFQFLG >= 81) THEN TRFQFLG = .;
   IF (TRBSTWAY >= 81) THEN TRBSTWAY = .;
   IF (TRDAYPYR >= 981) THEN TRDAYPYR = .;
   IF (TRDAYPMO >= 81) THEN TRDAYPMO = .;
   IF (TRDAYPWK >= 81) THEN TRDAYPWK = .;
   IF (METHDES >= 81) THEN METHDES = .;
   IF (DIETPILS >= 81) THEN DIETPILS = .;
   IF (RITMPHEN >= 81) THEN RITMPHEN = .;
   IF (STMCARD >= 81) THEN STMCARD = .;
   IF (CYLERT >= 81) THEN CYLERT = .;
   IF (DEXED >= 81) THEN DEXED = .;
   IF (DETAMP >= 81) THEN DETAMP = .;
   IF (DIDREX >= 81) THEN DIDREX = .;
   IF (ESKAT >= 81) THEN ESKAT = .;
   IF (IONAMIN >= 81) THEN IONAMIN = .;
   IF (MAZANOR >= 81) THEN MAZANOR = .;
   IF (OBLA >= 81) THEN OBLA = .;
   IF (PLEGINE >= 81) THEN PLEGINE = .;
   IF (PRELUDIN >= 81) THEN PRELUDIN = .;
   IF (SANOREX >= 81) THEN SANOREX = .;
   IF (TENUATE >= 81) THEN TENUATE = .;
   IF (STMNOLST >= 81) THEN STMNOLST = .;
   IF (STIMNEWA >= 9981) THEN STIMNEWA = .;
   IF (STIMNEWB >= 9981) THEN STIMNEWB = .;
   IF (STIMNEWC >= 9981) THEN STIMNEWC = .;
   IF (STIMNEWD >= 9981) THEN STIMNEWD = .;
   IF (STIMNEWE >= 9981) THEN STIMNEWE = .;
   IF (STIMAGE >= 981) THEN STIMAGE = .;
   IF (STIMYFU >= 9981) THEN STIMYFU = .;
   IF (STIMMFU >= 81) THEN STIMMFU = .;
   IF (STIMREC >= 81) THEN STIMREC = .;
   IF (STMYRTOT >= 981) THEN STMYRTOT = .;
   IF (STTOTFG >= 81) THEN STTOTFG = .;
   IF (STFQFLG >= 81) THEN STFQFLG = .;
   IF (STBSTWAY >= 81) THEN STBSTWAY = .;
   IF (STDAYPYR >= 981) THEN STDAYPYR = .;
   IF (STDAYPMO >= 81) THEN STDAYPMO = .;
   IF (STDAYPWK >= 81) THEN STDAYPWK = .;
   IF (METHAGE >= 981) THEN METHAGE = .;
   IF (METHYFU >= 9981) THEN METHYFU = .;
   IF (METHMFU >= 81) THEN METHMFU = .;
   IF (METHREC >= 81) THEN METHREC = .;
   IF (METHAQ >= 81) THEN METHAQ = .;
   IF (NEMBBARB >= 81) THEN NEMBBARB = .;
   IF (RESTTMAZ >= 81) THEN RESTTMAZ = .;
   IF (SEDCARD >= 81) THEN SEDCARD = .;
   IF (AMYTAL >= 81) THEN AMYTAL = .;
   IF (BUTISOL >= 81) THEN BUTISOL = .;
   IF (CHHYD >= 81) THEN CHHYD = .;
   IF (DALMANE >= 81) THEN DALMANE = .;
   IF (HALCION >= 81) THEN HALCION = .;
   IF (PHENOBAR >= 81) THEN PHENOBAR = .;
   IF (PLACIDYL >= 81) THEN PLACIDYL = .;
   IF (TUINAL >= 81) THEN TUINAL = .;
   IF (SEDNOLST >= 81) THEN SEDNOLST = .;
   IF (SEDNEWA >= 9981) THEN SEDNEWA = .;
   IF (SEDNEWB >= 9981) THEN SEDNEWB = .;
   IF (SEDNEWC >= 9981) THEN SEDNEWC = .;
   IF (SEDNEWD >= 9981) THEN SEDNEWD = .;
   IF (SEDNEWE >= 9981) THEN SEDNEWE = .;
   IF (SEDAGE >= 981) THEN SEDAGE = .;
   IF (SEDYFU >= 9981) THEN SEDYFU = .;
   IF (SEDMFU >= 81) THEN SEDMFU = .;
   IF (SEDREC >= 81) THEN SEDREC = .;
   IF (SEDYRTOT >= 981) THEN SEDYRTOT = .;
   IF (SVTOTFG >= 81) THEN SVTOTFG = .;
   IF (SVFQFLG >= 81) THEN SVFQFLG = .;
   IF (SVBSTWAY >= 81) THEN SVBSTWAY = .;
   IF (SVDAYPYR >= 981) THEN SVDAYPYR = .;
   IF (SVDAYPMO >= 81) THEN SVDAYPMO = .;
   IF (SVDAYPWK >= 81) THEN SVDAYPWK = .;
   IF (IRCIGRC = 9) THEN IRCIGRC = .;
   IF (IRCGRRC = 9) THEN IRCGRRC = .;
   IF (IRPIPLF = 9) THEN IRPIPLF = .;
   IF (IRPIPMN = 9) THEN IRPIPMN = .;
   IF (IRSLTRC = 9) THEN IRSLTRC = .;
   IF (IRCHWRC = 9) THEN IRCHWRC = .;
   IF (IRSNFRC = 9) THEN IRSNFRC = .;
   IF (IRALCRC = 9) THEN IRALCRC = .;
   IF (IRMJRC = 9) THEN IRMJRC = .;
   IF (IRCOCRC = 9) THEN IRCOCRC = .;
   IF (IRCRKRC = 9) THEN IRCRKRC = .;
   IF (IRHERRC = 9) THEN IRHERRC = .;
   IF (IRHALRC = 9) THEN IRHALRC = .;
   IF (IRLSDRC = 9) THEN IRLSDRC = .;
   IF (IRPCPRC = 9) THEN IRPCPRC = .;
   IF (IRINHRC = 9) THEN IRINHRC = .;
   IF (IRANLRC = 9) THEN IRANLRC = .;
   IF (IRTRNRC = 9) THEN IRTRNRC = .;
   IF (IRSTMRC = 9) THEN IRSTMRC = .;
   IF (IRMTHRC = 9) THEN IRMTHRC = .;
   IF (IRSEDRC = 9) THEN IRSEDRC = .;
   IF (IRALCFY >= 981) THEN IRALCFY = .;
   IF (IRMJFY >= 981) THEN IRMJFY = .;
   IF (IRCOCFY >= 981) THEN IRCOCFY = .;
   IF (IRCRKFY >= 981) THEN IRCRKFY = .;
   IF (IRHERFY >= 981) THEN IRHERFY = .;
   IF (IRHALFY >= 981) THEN IRHALFY = .;
   IF (IRINHFY >= 981) THEN IRINHFY = .;
   IF (IRANLFY >= 981) THEN IRANLFY = .;
   IF (IRTRNFY >= 981) THEN IRTRNFY = .;
   IF (IRSTMFY >= 981) THEN IRSTMFY = .;
   IF (IRSEDFY >= 981) THEN IRSEDFY = .;
   IF (IRCIGFM >= 81.00) THEN IRCIGFM = .;
   IF (IRCGRFM >= 81.00) THEN IRCGRFM = .;
   IF (IRCHWFM >= 81.00) THEN IRCHWFM = .;
   IF (IRSNFFM >= 81.00) THEN IRSNFFM = .;
   IF (IRALCFM >= 81.00) THEN IRALCFM = .;
   IF (IRALCD5 >= 81) THEN IRALCD5 = .;
   IF (IRMJFM >= 81.00) THEN IRMJFM = .;
   IF (IRCOCFM >= 81.00) THEN IRCOCFM = .;
   IF (IRCRKFM >= 81.00) THEN IRCRKFM = .;
   IF (IRHERFM >= 81) THEN IRHERFM = .;
   IF (IRHALFM >= 81.00) THEN IRHALFM = .;
   IF (IRINHFM >= 81.00) THEN IRINHFM = .;
   IF (IRCIGAGE >= 981) THEN IRCIGAGE = .;
   IF (IRCIGYFU >= 9981) THEN IRCIGYFU = .;
   IF (IRCDUAGE >= 981) THEN IRCDUAGE = .;
   IF (IICDUAGE = 9) THEN IICDUAGE = .;
   IF (IRCDUYFU >= 9981) THEN IRCDUYFU = .;
   IF (IRCGRAGE >= 981) THEN IRCGRAGE = .;
   IF (IRCGRYFU >= 9981) THEN IRCGRYFU = .;
   IF (IRSNFAGE >= 981) THEN IRSNFAGE = .;
   IF (IRSNFYFU >= 9981) THEN IRSNFYFU = .;
   IF (IRCHWAGE >= 981) THEN IRCHWAGE = .;
   IF (IRCHWYFU >= 9981) THEN IRCHWYFU = .;
   IF (IRSLTAGE >= 981) THEN IRSLTAGE = .;
   IF (IRSLTYFU >= 9981) THEN IRSLTYFU = .;
   IF (IRALCAGE >= 981) THEN IRALCAGE = .;
   IF (IRALCYFU >= 9981) THEN IRALCYFU = .;
   IF (IRMJAGE >= 981) THEN IRMJAGE = .;
   IF (IRMJYFU >= 9981) THEN IRMJYFU = .;
   IF (IRCOCAGE >= 981) THEN IRCOCAGE = .;
   IF (IRCOCYFU >= 9981) THEN IRCOCYFU = .;
   IF (IRCRKAGE >= 981) THEN IRCRKAGE = .;
   IF (IRCRKYFU >= 9981) THEN IRCRKYFU = .;
   IF (IRHERAGE >= 981) THEN IRHERAGE = .;
   IF (IRHERYFU >= 9981) THEN IRHERYFU = .;
   IF (IRHALAGE >= 981) THEN IRHALAGE = .;
   IF (IRHALYFU >= 9981) THEN IRHALYFU = .;
   IF (IRLSDAGE >= 981) THEN IRLSDAGE = .;
   IF (IRLSDYFU >= 9981) THEN IRLSDYFU = .;
   IF (IRPCPAGE >= 981) THEN IRPCPAGE = .;
   IF (IRPCPYFU >= 9981) THEN IRPCPYFU = .;
   IF (IRINHAGE >= 981) THEN IRINHAGE = .;
   IF (IRINHYFU >= 9981) THEN IRINHYFU = .;
   IF (IRANLAGE >= 981) THEN IRANLAGE = .;
   IF (IRANLYFU >= 9981) THEN IRANLYFU = .;
   IF (IRTRNAGE >= 981) THEN IRTRNAGE = .;
   IF (IRTRNYFU >= 9981) THEN IRTRNYFU = .;
   IF (IRSTMAGE >= 981) THEN IRSTMAGE = .;
   IF (IRSTMYFU >= 9981) THEN IRSTMYFU = .;
   IF (IRMTHAGE >= 981) THEN IRMTHAGE = .;
   IF (IRMTHYFU >= 9981) THEN IRMTHYFU = .;
   IF (IRSEDAGE >= 981) THEN IRSEDAGE = .;
   IF (IRSEDYFU >= 9981) THEN IRSEDYFU = .;
   IF (CIGBRND2 = -9) THEN CIGBRND2 = .;
   IF (CGRBRND2 = -9) THEN CGRBRND2 = .;
   IF (SMKBRND2 = -9) THEN SMKBRND2 = .;
   IF (CIGCMPNY >= 81) THEN CIGCMPNY = .;
   IF (ALCAFU = 4) THEN ALCAFU = .;
   IF (MJAFU = 4) THEN MJAFU = .;
   IF (COCAFU = 4) THEN COCAFU = .;
   IF (HERAFU = 4) THEN HERAFU = .;
   IF (HALAFU = 4) THEN HALAFU = .;
   IF (INHAFU = 4) THEN INHAFU = .;
   IF (ANLAFU = 4) THEN ANLAFU = .;
   IF (TRNAFU = 4) THEN TRNAFU = .;
   IF (STMAFU = 4) THEN STMAFU = .;
   IF (SEDAFU = 4) THEN SEDAFU = .;
   IF (CIGAFU = 4) THEN CIGAFU = .;
   IF (CGRAFU = 4) THEN CGRAFU = .;
   IF (SLTAFU = 4) THEN SLTAFU = .;
   IF (MRJYDAYS = 6) THEN MRJYDAYS = .;
   IF (COCYDAYS = 6) THEN COCYDAYS = .;
   IF (HALYDAYS = 6) THEN HALYDAYS = .;
   IF (INHYDAYS = 6) THEN INHYDAYS = .;
   IF (ALCYDAYS = 6) THEN ALCYDAYS = .;
   IF (MRJMDAYS = 6) THEN MRJMDAYS = .;
   IF (COCMDAYS = 6) THEN COCMDAYS = .;
   IF (HALMDAYS = 6) THEN HALMDAYS = .;
   IF (INHMDAYS = 6) THEN INHMDAYS = .;
   IF (ALCMDAYS = 6) THEN ALCMDAYS = .;
   IF (CIGMDAYS = 6) THEN CIGMDAYS = .;
   IF (CIGPDAY = 6) THEN CIGPDAY = .;
   IF (CG05 >= 81) THEN CG05 = .;
   IF (CG06 >= 81) THEN CG06 = .;
   IF (CG06DK >= 81) THEN CG06DK = .;
   IF (CG06RE >= 81) THEN CG06RE = .;
   IF (CG19 >= 81) THEN CG19 = .;
   IF (CG20 >= 81) THEN CG20 = .;
   IF (CG20DK >= 81) THEN CG20DK = .;
   IF (CG20RE >= 81) THEN CG20RE = .;
   IF (CG27 >= 81) THEN CG27 = .;
   IF (CG28 >= 81) THEN CG28 = .;
   IF (CG28DK >= 81) THEN CG28DK = .;
   IF (CG28RE >= 81) THEN CG28RE = .;
   IF (CG36 >= 81) THEN CG36 = .;
   IF (CG37 >= 81) THEN CG37 = .;
   IF (CG37DK >= 81) THEN CG37DK = .;
   IF (CG37RE >= 81) THEN CG37RE = .;
   IF (CG43 >= 81) THEN CG43 = .;
   IF (ALLAST3 >= 81) THEN ALLAST3 = .;
   IF (ALRECDK >= 81) THEN ALRECDK = .;
   IF (ALRECRE >= 81) THEN ALRECRE = .;
   IF (TOTDRINK >= 981) THEN TOTDRINK = .;
   IF (ALFRAME3 >= 81) THEN ALFRAME3 = .;
   IF (ALYRAVE >= 981) THEN ALYRAVE = .;
   IF (ALMONAVE >= 81) THEN ALMONAVE = .;
   IF (ALWKAVE >= 81) THEN ALWKAVE = .;
   IF (MJLAST3 >= 81) THEN MJLAST3 = .;
   IF (MJRECDK >= 81) THEN MJRECDK = .;
   IF (MJRECRE >= 81) THEN MJRECRE = .;
   IF (TOTMJ >= 981) THEN TOTMJ = .;
   IF (MJFRAME3 >= 81) THEN MJFRAME3 = .;
   IF (MJYRAVE >= 981) THEN MJYRAVE = .;
   IF (MJMONAVE >= 81) THEN MJMONAVE = .;
   IF (MJWKAVE >= 81) THEN MJWKAVE = .;
   IF (CCLAST3 >= 81) THEN CCLAST3 = .;
   IF (CCRECDK >= 81) THEN CCRECDK = .;
   IF (CCRECRE >= 81) THEN CCRECRE = .;
   IF (TOTCOKE >= 981) THEN TOTCOKE = .;
   IF (CCFRAME3 >= 81) THEN CCFRAME3 = .;
   IF (CCYRAVE >= 981) THEN CCYRAVE = .;
   IF (CCMONAVE >= 81) THEN CCMONAVE = .;
   IF (CCWKAVE >= 81) THEN CCWKAVE = .;
   IF (CKLAST3 >= 81) THEN CKLAST3 = .;
   IF (CKRECDK >= 81) THEN CKRECDK = .;
   IF (CKRECRE >= 81) THEN CKRECRE = .;
   IF (TOTCRACK >= 981) THEN TOTCRACK = .;
   IF (CKFRAME3 >= 81) THEN CKFRAME3 = .;
   IF (CKYRAVE >= 981) THEN CKYRAVE = .;
   IF (CKMONAVE >= 81) THEN CKMONAVE = .;
   IF (CKWKAVE >= 81) THEN CKWKAVE = .;
   IF (HELAST3 >= 81) THEN HELAST3 = .;
   IF (HERECDK >= 81) THEN HERECDK = .;
   IF (HERECRE >= 81) THEN HERECRE = .;
   IF (TOTHERO >= 981) THEN TOTHERO = .;
   IF (HEFRAME3 >= 81) THEN HEFRAME3 = .;
   IF (HEYRAVE >= 981) THEN HEYRAVE = .;
   IF (HEMONAVE >= 81) THEN HEMONAVE = .;
   IF (HEWKAVE >= 81) THEN HEWKAVE = .;
   IF (LSLAST >= 81) THEN LSLAST = .;
   IF (LSRECDK >= 81) THEN LSRECDK = .;
   IF (LSRECRE >= 81) THEN LSRECRE = .;
   IF (TOTHALL >= 981) THEN TOTHALL = .;
   IF (LSFRAME3 >= 81) THEN LSFRAME3 = .;
   IF (LSYRAVE >= 981) THEN LSYRAVE = .;
   IF (LSMONAVE >= 81) THEN LSMONAVE = .;
   IF (LSWKAVE >= 81) THEN LSWKAVE = .;
   IF (LS10 >= 81) THEN LS10 = .;
   IF (LS16 >= 81) THEN LS16 = .;
   IF (INLAST >= 81) THEN INLAST = .;
   IF (INRECDK >= 81) THEN INRECDK = .;
   IF (INRECRE >= 81) THEN INRECRE = .;
   IF (TOTINHAL >= 981) THEN TOTINHAL = .;
   IF (INFRAME3 >= 81) THEN INFRAME3 = .;
   IF (INYRAVE >= 981) THEN INYRAVE = .;
   IF (INMONAVE >= 81) THEN INMONAVE = .;
   IF (INWKAVE >= 81) THEN INWKAVE = .;
   IF (PR09 >= 81) THEN PR09 = .;
   IF (PRRECDK >= 81) THEN PRRECDK = .;
   IF (PRRECRE >= 81) THEN PRRECRE = .;
   IF (PR10 >= 81) THEN PR10 = .;
   IF (PR11 >= 981) THEN PR11 = .;
   IF (PR12 >= 81) THEN PR12 = .;
   IF (PR13 >= 81) THEN PR13 = .;
   IF (TR09 >= 81) THEN TR09 = .;
   IF (TRRECDK >= 81) THEN TRRECDK = .;
   IF (TRRECRE >= 81) THEN TRRECRE = .;
   IF (TR10 >= 81) THEN TR10 = .;
   IF (TR11 >= 981) THEN TR11 = .;
   IF (TR12 >= 81) THEN TR12 = .;
   IF (TR13 >= 81) THEN TR13 = .;
   IF (ST09 >= 81) THEN ST09 = .;
   IF (STRECDK >= 81) THEN STRECDK = .;
   IF (STRECRE >= 81) THEN STRECRE = .;
   IF (ST10 >= 81) THEN ST10 = .;
   IF (ST11 >= 981) THEN ST11 = .;
   IF (ST12 >= 81) THEN ST12 = .;
   IF (ST13 >= 81) THEN ST13 = .;
   IF (ST19 >= 81) THEN ST19 = .;
   IF (SV09 >= 81) THEN SV09 = .;
   IF (SVRECDK >= 81) THEN SVRECDK = .;
   IF (SVRECRE >= 81) THEN SVRECRE = .;
   IF (SV10 >= 81) THEN SV10 = .;
   IF (SV11 >= 981) THEN SV11 = .;
   IF (SV12 >= 81) THEN SV12 = .;
   IF (SV13 >= 81) THEN SV13 = .;
   IF (HERSMOKE >= 81) THEN HERSMOKE = .;
   IF (HRSMKREC >= 81) THEN HRSMKREC = .;
   IF (HERSNIFF >= 81) THEN HERSNIFF = .;
   IF (HRSNFREC >= 81) THEN HRSNFREC = .;
   IF (GNNDLLIF >= 81) THEN GNNDLLIF = .;
   IF (COCNEEDL >= 81) THEN COCNEEDL = .;
   IF (CONDLREC >= 81) THEN CONDLREC = .;
   IF (HERNEEDL >= 81) THEN HERNEEDL = .;
   IF (HRNDLREC >= 81) THEN HRNDLREC = .;
   IF (STNEEDLE >= 81) THEN STNEEDLE = .;
   IF (STNDLREC >= 81) THEN STNDLREC = .;
   IF (GNNDREUS >= 81) THEN GNNDREUS = .;
   IF (GNNDLSH1 >= 81) THEN GNNDLSH1 = .;
   IF (GNNDCLEN >= 81) THEN GNNDCLEN = .;
   IF (GNNDLSH2 >= 81) THEN GNNDLSH2 = .;
   IF (GNNDGET2 >= 81) THEN GNNDGET2 = .;
   IF (NEDLRECC >= 81) THEN NEDLRECC = .;
   IF (RSKPKCIG >= 81) THEN RSKPKCIG = .;
   IF (RSKMJOCC >= 81) THEN RSKMJOCC = .;
   IF (RSKMJREG >= 81) THEN RSKMJREG = .;
   IF (RKTRYLSD >= 81) THEN RKTRYLSD = .;
   IF (RKLSDREG >= 81) THEN RKLSDREG = .;
   IF (RKTRYHER >= 81) THEN RKTRYHER = .;
   IF (RKHERREG >= 81) THEN RKHERREG = .;
   IF (RKCOCOCC >= 81) THEN RKCOCOCC = .;
   IF (RKCOCREG >= 81) THEN RKCOCREG = .;
   IF (RK5ALDLY >= 81) THEN RK5ALDLY = .;
   IF (RK5ALWK >= 81) THEN RK5ALWK = .;
   IF (RSKDIFMJ >= 81) THEN RSKDIFMJ = .;
   IF (RKDIFLSD >= 81) THEN RKDIFLSD = .;
   IF (RKDIFCOC >= 81) THEN RKDIFCOC = .;
   IF (RKDIFCRK >= 81) THEN RKDIFCRK = .;
   IF (RKDIFHER >= 81) THEN RKDIFHER = .;
   IF (RSKSELL >= 81) THEN RSKSELL = .;
   IF (RKFQDNGR >= 81) THEN RKFQDNGR = .;
   IF (RKFQRSKY >= 81) THEN RKFQRSKY = .;
   IF (RKFQPBLT >= 81) THEN RKFQPBLT = .;
   IF (RKFQDBLT >= 81) THEN RKFQDBLT = .;
   IF (GRSKPKCG = -9) THEN GRSKPKCG = .;
   IF (GRSKCREG = -9) THEN GRSKCREG = .;
   IF (GRSKCOCC = -9) THEN GRSKCOCC = .;
   IF (GRSKMREG = -9) THEN GRSKMREG = .;
   IF (GRSKMOCC = -9) THEN GRSKMOCC = .;
   IF (GRSKHTRY = -9) THEN GRSKHTRY = .;
   IF (GRSKHREG = -9) THEN GRSKHREG = .;
   IF (GRSKLTRY = -9) THEN GRSKLTRY = .;
   IF (GRSKLREG = -9) THEN GRSKLREG = .;
   IF (GRSKD4_5 = -9) THEN GRSKD4_5 = .;
   IF (GRSKD5WK = -9) THEN GRSKD5WK = .;
   IF (RDIFMJ = -9) THEN RDIFMJ = .;
   IF (RDIFCOC = -9) THEN RDIFCOC = .;
   IF (RDIFHER = -9) THEN RDIFHER = .;
   IF (RDIFLSD = -9) THEN RDIFLSD = .;
   IF (RDIFCRK = -9) THEN RDIFCRK = .;
   IF (APPSELDG = -9) THEN APPSELDG = .;
   IF (CIGLOTTM >= 81) THEN CIGLOTTM = .;
   IF (CIGLIMIT >= 81) THEN CIGLIMIT = .;
   IF (CIGKPLMT >= 81) THEN CIGKPLMT = .;
   IF (CIGNDMOR >= 81) THEN CIGNDMOR = .;
   IF (CIGLSEFX >= 81) THEN CIGLSEFX = .;
   IF (CIGCUTDN >= 81) THEN CIGCUTDN = .;
   IF (CIGCUTEV >= 81) THEN CIGCUTEV = .;
   IF (CIGCUT1X >= 81) THEN CIGCUT1X = .;
   IF (CIGWD4SX >= 81) THEN CIGWD4SX = .;
   IF (CIGWDSMT >= 81) THEN CIGWDSMT = .;
   IF (CIGEMOPB >= 81) THEN CIGEMOPB = .;
   IF (CIGEMCTD >= 81) THEN CIGEMCTD = .;
   IF (CIGPHLPB >= 81) THEN CIGPHLPB = .;
   IF (CIGPHCTD >= 81) THEN CIGPHCTD = .;
   IF (CIGLSACT >= 81) THEN CIGLSACT = .;
   IF (CIGPKCRT >= 81) THEN CIGPKCRT = .;
   IF (CIGPDPAK >= 81) THEN CIGPDPAK = .;
   IF (CIGPDCRT >= 81) THEN CIGPDCRT = .;
   IF (ALCLOTTM >= 81) THEN ALCLOTTM = .;
   IF (ALCGTOVR >= 81) THEN ALCGTOVR = .;
   IF (ALCLIMIT >= 81) THEN ALCLIMIT = .;
   IF (ALCKPLMT >= 81) THEN ALCKPLMT = .;
   IF (ALCNDMOR >= 81) THEN ALCNDMOR = .;
   IF (ALCLSEFX >= 81) THEN ALCLSEFX = .;
   IF (ALCCUTDN >= 81) THEN ALCCUTDN = .;
   IF (ALCCUTEV >= 81) THEN ALCCUTEV = .;
   IF (ALCCUT1X >= 81) THEN ALCCUT1X = .;
   IF (ALCWD2SX >= 81) THEN ALCWD2SX = .;
   IF (ALCWDSMT >= 81) THEN ALCWDSMT = .;
   IF (ALCEMOPB >= 81) THEN ALCEMOPB = .;
   IF (ALCEMCTD >= 81) THEN ALCEMCTD = .;
   IF (ALCPHLPB >= 81) THEN ALCPHLPB = .;
   IF (ALCPHCTD >= 81) THEN ALCPHCTD = .;
   IF (ALCLSACT >= 81) THEN ALCLSACT = .;
   IF (ALCSERPB >= 81) THEN ALCSERPB = .;
   IF (ALCPDANG >= 81) THEN ALCPDANG = .;
   IF (ALCLAWTR >= 81) THEN ALCLAWTR = .;
   IF (ALCFMFPB >= 81) THEN ALCFMFPB = .;
   IF (ALCFMCTD >= 81) THEN ALCFMCTD = .;
   IF (MRJLOTTM >= 81) THEN MRJLOTTM = .;
   IF (MRJGTOVR >= 81) THEN MRJGTOVR = .;
   IF (MRJLIMIT >= 81) THEN MRJLIMIT = .;
   IF (MRJKPLMT >= 81) THEN MRJKPLMT = .;
   IF (MRJNDMOR >= 81) THEN MRJNDMOR = .;
   IF (MRJLSEFX >= 81) THEN MRJLSEFX = .;
   IF (MRJCUTDN >= 81) THEN MRJCUTDN = .;
   IF (MRJCUTEV >= 81) THEN MRJCUTEV = .;
   IF (MRJEMOPB >= 81) THEN MRJEMOPB = .;
   IF (MRJEMCTD >= 81) THEN MRJEMCTD = .;
   IF (MRJPHLPB >= 81) THEN MRJPHLPB = .;
   IF (MRJPHCTD >= 81) THEN MRJPHCTD = .;
   IF (MRJLSACT >= 81) THEN MRJLSACT = .;
   IF (MRJSERPB >= 81) THEN MRJSERPB = .;
   IF (MRJPDANG >= 81) THEN MRJPDANG = .;
   IF (MRJLAWTR >= 81) THEN MRJLAWTR = .;
   IF (MRJFMFPB >= 81) THEN MRJFMFPB = .;
   IF (MRJFMCTD >= 81) THEN MRJFMCTD = .;
   IF (COCLOTTM >= 81) THEN COCLOTTM = .;
   IF (COCGTOVR >= 81) THEN COCGTOVR = .;
   IF (COCLIMIT >= 81) THEN COCLIMIT = .;
   IF (COCKPLMT >= 81) THEN COCKPLMT = .;
   IF (COCNDMOR >= 81) THEN COCNDMOR = .;
   IF (COCLSEFX >= 81) THEN COCLSEFX = .;
   IF (COCCUTDN >= 81) THEN COCCUTDN = .;
   IF (COCCUTEV >= 81) THEN COCCUTEV = .;
   IF (COCCUT1X >= 81) THEN COCCUT1X = .;
   IF (COCFLBLU >= 81) THEN COCFLBLU = .;
   IF (COCWD2SX >= 81) THEN COCWD2SX = .;
   IF (COCWDSMT >= 81) THEN COCWDSMT = .;
   IF (COCEMOPB >= 81) THEN COCEMOPB = .;
   IF (COCEMCTD >= 81) THEN COCEMCTD = .;
   IF (COCPHLPB >= 81) THEN COCPHLPB = .;
   IF (COCPHCTD >= 81) THEN COCPHCTD = .;
   IF (COCLSACT >= 81) THEN COCLSACT = .;
   IF (COCSERPB >= 81) THEN COCSERPB = .;
   IF (COCPDANG >= 81) THEN COCPDANG = .;
   IF (COCLAWTR >= 81) THEN COCLAWTR = .;
   IF (COCFMFPB >= 81) THEN COCFMFPB = .;
   IF (COCFMCTD >= 81) THEN COCFMCTD = .;
   IF (HERLOTTM >= 81) THEN HERLOTTM = .;
   IF (HERGTOVR >= 81) THEN HERGTOVR = .;
   IF (HERLIMIT >= 81) THEN HERLIMIT = .;
   IF (HERKPLMT >= 81) THEN HERKPLMT = .;
   IF (HERNDMOR >= 81) THEN HERNDMOR = .;
   IF (HERLSEFX >= 81) THEN HERLSEFX = .;
   IF (HERCUTDN >= 81) THEN HERCUTDN = .;
   IF (HERCUTEV >= 81) THEN HERCUTEV = .;
   IF (HERCUT1X >= 81) THEN HERCUT1X = .;
   IF (HERWD3SX >= 81) THEN HERWD3SX = .;
   IF (HERWDSMT >= 81) THEN HERWDSMT = .;
   IF (HEREMOPB >= 81) THEN HEREMOPB = .;
   IF (HEREMCTD >= 81) THEN HEREMCTD = .;
   IF (HERPHLPB >= 81) THEN HERPHLPB = .;
   IF (HERPHCTD >= 81) THEN HERPHCTD = .;
   IF (HERLSACT >= 81) THEN HERLSACT = .;
   IF (HERSERPB >= 81) THEN HERSERPB = .;
   IF (HERPDANG >= 81) THEN HERPDANG = .;
   IF (HERLAWTR >= 81) THEN HERLAWTR = .;
   IF (HERFMFPB >= 81) THEN HERFMFPB = .;
   IF (HERFMCTD >= 81) THEN HERFMCTD = .;
   IF (HALLOTTM >= 81) THEN HALLOTTM = .;
   IF (HALGTOVR >= 81) THEN HALGTOVR = .;
   IF (HALLIMIT >= 81) THEN HALLIMIT = .;
   IF (HALKPLMT >= 81) THEN HALKPLMT = .;
   IF (HALNDMOR >= 81) THEN HALNDMOR = .;
   IF (HALLSEFX >= 81) THEN HALLSEFX = .;
   IF (HALCUTDN >= 81) THEN HALCUTDN = .;
   IF (HALCUTEV >= 81) THEN HALCUTEV = .;
   IF (HALEMOPB >= 81) THEN HALEMOPB = .;
   IF (HALEMCTD >= 81) THEN HALEMCTD = .;
   IF (HALPHLPB >= 81) THEN HALPHLPB = .;
   IF (HALPHCTD >= 81) THEN HALPHCTD = .;
   IF (HALLSACT >= 81) THEN HALLSACT = .;
   IF (HALSERPB >= 81) THEN HALSERPB = .;
   IF (HALPDANG >= 81) THEN HALPDANG = .;
   IF (HALLAWTR >= 81) THEN HALLAWTR = .;
   IF (HALFMFPB >= 81) THEN HALFMFPB = .;
   IF (HALFMCTD >= 81) THEN HALFMCTD = .;
   IF (INHLOTTM >= 81) THEN INHLOTTM = .;
   IF (INHGTOVR >= 81) THEN INHGTOVR = .;
   IF (INHLIMIT >= 81) THEN INHLIMIT = .;
   IF (INHKPLMT >= 81) THEN INHKPLMT = .;
   IF (INHNDMOR >= 81) THEN INHNDMOR = .;
   IF (INHLSEFX >= 81) THEN INHLSEFX = .;
   IF (INHCUTDN >= 81) THEN INHCUTDN = .;
   IF (INHCUTEV >= 81) THEN INHCUTEV = .;
   IF (INHEMOPB >= 81) THEN INHEMOPB = .;
   IF (INHEMCTD >= 81) THEN INHEMCTD = .;
   IF (INHPHLPB >= 81) THEN INHPHLPB = .;
   IF (INHPHCTD >= 81) THEN INHPHCTD = .;
   IF (INHLSACT >= 81) THEN INHLSACT = .;
   IF (INHSERPB >= 81) THEN INHSERPB = .;
   IF (INHPDANG >= 81) THEN INHPDANG = .;
   IF (INHLAWTR >= 81) THEN INHLAWTR = .;
   IF (INHFMFPB >= 81) THEN INHFMFPB = .;
   IF (INHFMCTD >= 81) THEN INHFMCTD = .;
   IF (ANLLOTTM >= 81) THEN ANLLOTTM = .;
   IF (ANLGTOVR >= 81) THEN ANLGTOVR = .;
   IF (ANLLIMIT >= 81) THEN ANLLIMIT = .;
   IF (ANLKPLMT >= 81) THEN ANLKPLMT = .;
   IF (ANLNDMOR >= 81) THEN ANLNDMOR = .;
   IF (ANLLSEFX >= 81) THEN ANLLSEFX = .;
   IF (ANLCUTDN >= 81) THEN ANLCUTDN = .;
   IF (ANLCUTEV >= 81) THEN ANLCUTEV = .;
   IF (ANLCUT1X >= 81) THEN ANLCUT1X = .;
   IF (ANLWD3SX >= 81) THEN ANLWD3SX = .;
   IF (ANLWDSMT >= 81) THEN ANLWDSMT = .;
   IF (ANLEMOPB >= 81) THEN ANLEMOPB = .;
   IF (ANLEMCTD >= 81) THEN ANLEMCTD = .;
   IF (ANLPHLPB >= 81) THEN ANLPHLPB = .;
   IF (ANLPHCTD >= 81) THEN ANLPHCTD = .;
   IF (ANLLSACT >= 81) THEN ANLLSACT = .;
   IF (ANLSERPB >= 81) THEN ANLSERPB = .;
   IF (ANLPDANG >= 81) THEN ANLPDANG = .;
   IF (ANLLAWTR >= 81) THEN ANLLAWTR = .;
   IF (ANLFMFPB >= 81) THEN ANLFMFPB = .;
   IF (ANLFMCTD >= 81) THEN ANLFMCTD = .;
   IF (TRNLOTTM >= 81) THEN TRNLOTTM = .;
   IF (TRNGTOVR >= 81) THEN TRNGTOVR = .;
   IF (TRNLIMIT >= 81) THEN TRNLIMIT = .;
   IF (TRNKPLMT >= 81) THEN TRNKPLMT = .;
   IF (TRNNDMOR >= 81) THEN TRNNDMOR = .;
   IF (TRNLSEFX >= 81) THEN TRNLSEFX = .;
   IF (TRNCUTDN >= 81) THEN TRNCUTDN = .;
   IF (TRNCUTEV >= 81) THEN TRNCUTEV = .;
   IF (TRNEMOPB >= 81) THEN TRNEMOPB = .;
   IF (TRNEMCTD >= 81) THEN TRNEMCTD = .;
   IF (TRNPHLPB >= 81) THEN TRNPHLPB = .;
   IF (TRNPHCTD >= 81) THEN TRNPHCTD = .;
   IF (TRNLSACT >= 81) THEN TRNLSACT = .;
   IF (TRNSERPB >= 81) THEN TRNSERPB = .;
   IF (TRNPDANG >= 81) THEN TRNPDANG = .;
   IF (TRNLAWTR >= 81) THEN TRNLAWTR = .;
   IF (TRNFMFPB >= 81) THEN TRNFMFPB = .;
   IF (TRNFMCTD >= 81) THEN TRNFMCTD = .;
   IF (STMLOTTM >= 81) THEN STMLOTTM = .;
   IF (STMGTOVR >= 81) THEN STMGTOVR = .;
   IF (STMLIMIT >= 81) THEN STMLIMIT = .;
   IF (STMKPLMT >= 81) THEN STMKPLMT = .;
   IF (STMNDMOR >= 81) THEN STMNDMOR = .;
   IF (STMLSEFX >= 81) THEN STMLSEFX = .;
   IF (STMCUTDN >= 81) THEN STMCUTDN = .;
   IF (STMCUTEV >= 81) THEN STMCUTEV = .;
   IF (STMCUT1X >= 81) THEN STMCUT1X = .;
   IF (STMFLBLU >= 81) THEN STMFLBLU = .;
   IF (STMWD2SX >= 81) THEN STMWD2SX = .;
   IF (STMWDSMT >= 81) THEN STMWDSMT = .;
   IF (STMEMOPB >= 81) THEN STMEMOPB = .;
   IF (STMEMCTD >= 81) THEN STMEMCTD = .;
   IF (STMPHLPB >= 81) THEN STMPHLPB = .;
   IF (STMPHCTD >= 81) THEN STMPHCTD = .;
   IF (STMLSACT >= 81) THEN STMLSACT = .;
   IF (STMSERPB >= 81) THEN STMSERPB = .;
   IF (STMPDANG >= 81) THEN STMPDANG = .;
   IF (STMLAWTR >= 81) THEN STMLAWTR = .;
   IF (STMFMFPB >= 81) THEN STMFMFPB = .;
   IF (STMFMCTD >= 81) THEN STMFMCTD = .;
   IF (SEDLOTTM >= 81) THEN SEDLOTTM = .;
   IF (SEDGTOVR >= 81) THEN SEDGTOVR = .;
   IF (SEDLIMIT >= 81) THEN SEDLIMIT = .;
   IF (SEDKPLMT >= 81) THEN SEDKPLMT = .;
   IF (SEDNDMOR >= 81) THEN SEDNDMOR = .;
   IF (SEDLSEFX >= 81) THEN SEDLSEFX = .;
   IF (SEDCUTDN >= 81) THEN SEDCUTDN = .;
   IF (SEDCUTEV >= 81) THEN SEDCUTEV = .;
   IF (SEDCUT1X >= 81) THEN SEDCUT1X = .;
   IF (SEDWD1SX >= 81) THEN SEDWD1SX = .;
   IF (SEDWDSMT >= 81) THEN SEDWDSMT = .;
   IF (SEDEMOPB >= 81) THEN SEDEMOPB = .;
   IF (SEDEMCTD >= 81) THEN SEDEMCTD = .;
   IF (SEDPHLPB >= 81) THEN SEDPHLPB = .;
   IF (SEDPHCTD >= 81) THEN SEDPHCTD = .;
   IF (SEDLSACT >= 81) THEN SEDLSACT = .;
   IF (SEDSERPB >= 81) THEN SEDSERPB = .;
   IF (SEDPDANG >= 81) THEN SEDPDANG = .;
   IF (SEDLAWTR >= 81) THEN SEDLAWTR = .;
   IF (SEDFMFPB >= 81) THEN SEDFMFPB = .;
   IF (SEDFMCTD >= 81) THEN SEDFMCTD = .;
   IF (BOOKED >= 81) THEN BOOKED = .;
   IF (NOBOOKY2 >= 981) THEN NOBOOKY2 = .;
   IF (BKMVTHFT >= 81) THEN BKMVTHFT = .;
   IF (BKLARCNY >= 81) THEN BKLARCNY = .;
   IF (BKBURGL >= 81) THEN BKBURGL = .;
   IF (BKAGASLT >= 81) THEN BKAGASLT = .;
   IF (BKSMASLT >= 81) THEN BKSMASLT = .;
   IF (BKROB >= 81) THEN BKROB = .;
   IF (BKRAPE >= 81) THEN BKRAPE = .;
   IF (BKMURDER >= 81) THEN BKMURDER = .;
   IF (BKARSON >= 81) THEN BKARSON = .;
   IF (BKDRVINF >= 81) THEN BKDRVINF = .;
   IF (BKDRUNK >= 81) THEN BKDRUNK = .;
   IF (BKPOSTOB >= 81) THEN BKPOSTOB = .;
   IF (BKDRUG >= 81) THEN BKDRUG = .;
   IF (BKPROS >= 81) THEN BKPROS = .;
   IF (BKSEXOFF >= 81) THEN BKSEXOFF = .;
   IF (BKFRAUD >= 81) THEN BKFRAUD = .;
   IF (BKOTH >= 81) THEN BKOTH = .;
   IF (BKOTHOF2 >= 81) THEN BKOTHOF2 = .;
   IF (PROBATON >= 81) THEN PROBATON = .;
   IF (PAROLREL >= 81) THEN PAROLREL = .;
   IF (DRVALDR >= 81) THEN DRVALDR = .;
   IF (DRVAONLY >= 81) THEN DRVAONLY = .;
   IF (DRVDONLY >= 81) THEN DRVDONLY = .;
   IF (DRIVALC >= 3) THEN DRIVALC = .;
   IF (DRIVDRG >= 3) THEN DRIVDRG = .;
   IF (DRIVALD >= 3) THEN DRIVALD = .;
   IF (PAROL = -9) THEN PAROL = .;
   IF (PROB = -9) THEN PROB = .;
   IF (TXEVER >= 81) THEN TXEVER = .;
   IF (TXYREVER >= 81) THEN TXYREVER = .;
   IF (TXYRADG >= 81) THEN TXYRADG = .;
   IF (TXYRHOSP >= 81) THEN TXYRHOSP = .;
   IF (TXYRHPAD >= 81) THEN TXYRHPAD = .;
   IF (TXYRRFIN >= 81) THEN TXYRRFIN = .;
   IF (TXYRINAD >= 81) THEN TXYRINAD = .;
   IF (TXYRRFOP >= 81) THEN TXYRRFOP = .;
   IF (TXYRPOAD >= 81) THEN TXYRPOAD = .;
   IF (TXYRMHC >= 81) THEN TXYRMHC = .;
   IF (TXYRMHAD >= 81) THEN TXYRMHAD = .;
   IF (TXYRTXER >= 81) THEN TXYRTXER = .;
   IF (TXYRERAD >= 81) THEN TXYRERAD = .;
   IF (TXYRDOC >= 81) THEN TXYRDOC = .;
   IF (TXYRDCAD >= 81) THEN TXYRDCAD = .;
   IF (TXYRJAIL >= 81) THEN TXYRJAIL = .;
   IF (TXYRJLAD >= 81) THEN TXYRJLAD = .;
   IF (TXYRSHG >= 81) THEN TXYRSHG = .;
   IF (TXYRSGAD >= 81) THEN TXYRSGAD = .;
   IF (TXYRSOP >= 81) THEN TXYRSOP = .;
   IF (TXYROTS2 >= 981) THEN TXYROTS2 = .;
   IF (TXYROTAD >= 81) THEN TXYROTAD = .;
   IF (TXYRVSER >= 81) THEN TXYRVSER = .;
   IF (TXYRNME2 >= 981) THEN TXYRNME2 = .;
   IF (TXRCVNOW >= 81) THEN TXRCVNOW = .;
   IF (NDTXNEDR >= 81) THEN NDTXNEDR = .;
   IF (NDTXMORE >= 81) THEN NDTXMORE = .;
   IF (NDTMRALC >= 81) THEN NDTMRALC = .;
   IF (NDTMRMJ >= 81) THEN NDTMRMJ = .;
   IF (NDTMRCOC >= 81) THEN NDTMRCOC = .;
   IF (NDTMRHER >= 81) THEN NDTMRHER = .;
   IF (NDTMRHAL >= 81) THEN NDTMRHAL = .;
   IF (NDTMRINH >= 81) THEN NDTMRINH = .;
   IF (NDTMRANL >= 81) THEN NDTMRANL = .;
   IF (NDTMRTRN >= 81) THEN NDTMRTRN = .;
   IF (NDTMRSTM >= 81) THEN NDTMRSTM = .;
   IF (NDTMRSED >= 81) THEN NDTMRSED = .;
   IF (NDTMROTH >= 81) THEN NDTMROTH = .;
   IF (NDTXALCR >= 81) THEN NDTXALCR = .;
   IF (NDTXMJR >= 81) THEN NDTXMJR = .;
   IF (NDTXCOCR >= 81) THEN NDTXCOCR = .;
   IF (NDTXHERR >= 81) THEN NDTXHERR = .;
   IF (NDTXHALR >= 81) THEN NDTXHALR = .;
   IF (NDTXINHR >= 81) THEN NDTXINHR = .;
   IF (NDTXANLR >= 81) THEN NDTXANLR = .;
   IF (NDTXTRNR >= 81) THEN NDTXTRNR = .;
   IF (NDTXSTMR >= 81) THEN NDTXSTMR = .;
   IF (NDTXSEDR >= 81) THEN NDTXSEDR = .;
   IF (NDTXSODR >= 81) THEN NDTXSODR = .;
   IF (NDTXDG1R >= 9981) THEN NDTXDG1R = .;
   IF (NDTXDG2R >= 9981) THEN NDTXDG2R = .;
   IF (NDTXDG3R >= 9981) THEN NDTXDG3R = .;
   IF (NDTXDG4R >= 9981) THEN NDTXDG4R = .;
   IF (NDTXDG5R >= 9981) THEN NDTXDG5R = .;
   IF (NDTXEFTR >= 81) THEN NDTXEFTR = .;
   IF (NDTMREFT >= 81) THEN NDTMREFT = .;
   IF (TXLASREC >= 81) THEN TXLASREC = .;
   IF (TXLTYMN2 >= 981) THEN TXLTYMN2 = .;
   IF (TXLTYALC >= 81) THEN TXLTYALC = .;
   IF (TXLTYMJ >= 81) THEN TXLTYMJ = .;
   IF (TXLTYCOC >= 81) THEN TXLTYCOC = .;
   IF (TXLTYHER >= 81) THEN TXLTYHER = .;
   IF (TXLTYHAL >= 81) THEN TXLTYHAL = .;
   IF (TXLTYINH >= 81) THEN TXLTYINH = .;
   IF (TXLTYANL >= 81) THEN TXLTYANL = .;
   IF (TXLTYTRN >= 81) THEN TXLTYTRN = .;
   IF (TXLTYSTM >= 81) THEN TXLTYSTM = .;
   IF (TXLTYSED >= 81) THEN TXLTYSED = .;
   IF (TXLTYSOD >= 81) THEN TXLTYSOD = .;
   IF (TXLTYOU2 >= 81) THEN TXLTYOU2 = .;
   IF (TXLTYDU2 >= 99981) THEN TXLTYDU2 = .;
   IF (TXPYINS >= 81) THEN TXPYINS = .;
   IF (TXPYCARE >= 81) THEN TXPYCARE = .;
   IF (TXPYCAID >= 81) THEN TXPYCAID = .;
   IF (TXPYPUBP >= 81) THEN TXPYPUBP = .;
   IF (TXPYSAVE >= 81) THEN TXPYSAVE = .;
   IF (TXPYFMLY >= 81) THEN TXPYFMLY = .;
   IF (TXPYCORT >= 81) THEN TXPYCORT = .;
   IF (TXPYMILC >= 81) THEN TXPYMILC = .;
   IF (TXPYEMPL >= 81) THEN TXPYEMPL = .;
   IF (TXPYSOS >= 81) THEN TXPYSOS = .;
   IF (TXPYSP2 >= 81) THEN TXPYSP2 = .;
   IF (TXPYFRE >= 81) THEN TXPYFRE = .;
   IF (TXENROLL >= 81) THEN TXENROLL = .;
   IF (TXYRDTXO >= 81) THEN TXYRDTXO = .;
   IF (AUINPYR >= 81) THEN AUINPYR = .;
   IF (AUINPSYH >= 81) THEN AUINPSYH = .;
   IF (AUINPGEN >= 81) THEN AUINPGEN = .;
   IF (AUINMEDU >= 81) THEN AUINMEDU = .;
   IF (AUINAHSP >= 81) THEN AUINAHSP = .;
   IF (AUINRESD >= 81) THEN AUINRESD = .;
   IF (AUINSFAC >= 81) THEN AUINSFAC = .;
   IF (AUNMPSY2 >= 981) THEN AUNMPSY2 = .;
   IF (AUNMPGE2 >= 981) THEN AUNMPGE2 = .;
   IF (AUNMMEDU >= 981) THEN AUNMMEDU = .;
   IF (AUNMAHSP >= 981) THEN AUNMAHSP = .;
   IF (AUNMRESD >= 981) THEN AUNMRESD = .;
   IF (AUNMSFA2 >= 981) THEN AUNMSFA2 = .;
   IF (AUPINSLF >= 81) THEN AUPINSLF = .;
   IF (AUPINOFM >= 81) THEN AUPINOFM = .;
   IF (AUPINPHI >= 81) THEN AUPINPHI = .;
   IF (AUPINMCR >= 81) THEN AUPINMCR = .;
   IF (AUPINMCD >= 81) THEN AUPINMCD = .;
   IF (AUPINREH >= 81) THEN AUPINREH = .;
   IF (AUPINEMP >= 81) THEN AUPINEMP = .;
   IF (AUPINMIL >= 81) THEN AUPINMIL = .;
   IF (AUPINPUB >= 81) THEN AUPINPUB = .;
   IF (AUPINPRV >= 81) THEN AUPINPRV = .;
   IF (AUPINFRE >= 81) THEN AUPINFRE = .;
   IF (AUPINAMT >= 81) THEN AUPINAMT = .;
   IF (AUOPTYR >= 81) THEN AUOPTYR = .;
   IF (AUOPMENT >= 81) THEN AUOPMENT = .;
   IF (AUOPTHER >= 81) THEN AUOPTHER = .;
   IF (AUOPDOC >= 81) THEN AUOPDOC = .;
   IF (AUOPCLNC >= 81) THEN AUOPCLNC = .;
   IF (AUOPDTMT >= 81) THEN AUOPDTMT = .;
   IF (AUOPOTOP >= 81) THEN AUOPOTOP = .;
   IF (AUOPYRS2 >= 81) THEN AUOPYRS2 = .;
   IF (AUNMMEN2 >= 981) THEN AUNMMEN2 = .;
   IF (AUNMTHE2 >= 981) THEN AUNMTHE2 = .;
   IF (AUNMDOC2 >= 981) THEN AUNMDOC2 = .;
   IF (AUNMCLN2 >= 981) THEN AUNMCLN2 = .;
   IF (AUNMDTM2 >= 981) THEN AUNMDTM2 = .;
   IF (AUNMOTO2 >= 981) THEN AUNMOTO2 = .;
   IF (AUPOPSLF >= 81) THEN AUPOPSLF = .;
   IF (AUPOPOFM >= 81) THEN AUPOPOFM = .;
   IF (AUPOPPHI >= 81) THEN AUPOPPHI = .;
   IF (AUPOPMCR >= 81) THEN AUPOPMCR = .;
   IF (AUPOPMCD >= 81) THEN AUPOPMCD = .;
   IF (AUPOPREH >= 81) THEN AUPOPREH = .;
   IF (AUPOPEMP >= 81) THEN AUPOPEMP = .;
   IF (AUPOPMIL >= 81) THEN AUPOPMIL = .;
   IF (AUPOPPUB >= 81) THEN AUPOPPUB = .;
   IF (AUPOPPRV >= 81) THEN AUPOPPRV = .;
   IF (AUPOPFRE >= 81) THEN AUPOPFRE = .;
   IF (AUPOPMOS >= 81) THEN AUPOPMOS = .;
   IF (AUPOPAMT >= 81) THEN AUPOPAMT = .;
   IF (AURXYR >= 81) THEN AURXYR = .;
   IF (AUUNMTYR >= 81) THEN AUUNMTYR = .;
   IF (AUUNMTRS >= 81) THEN AUUNMTRS = .;
   IF (AMHINP >= 3) THEN AMHINP = .;
   IF (AMHOUTP >= 3) THEN AMHOUTP = .;
   IF (AMHRX >= 3) THEN AMHRX = .;
   IF (AMHTXREC >= 3) THEN AMHTXREC = .;
   IF (AMHTRTND >= 3) THEN AMHTRTND = .;
   IF (SNCRIME >= 81) THEN SNCRIME = .;
   IF (SNSELLDG >= 81) THEN SNSELLDG = .;
   IF (SNPPVAL >= 81) THEN SNPPVAL = .;
   IF (SNSTFGT >= 81) THEN SNSTFGT = .;
   IF (SNEMTBLD >= 81) THEN SNEMTBLD = .;
   IF (SNPPHLP >= 81) THEN SNPPHLP = .;
   IF (SNGRAFTI >= 81) THEN SNGRAFTI = .;
   IF (SNPPVSIT >= 81) THEN SNPPVSIT = .;
   IF (SNPPMOVE >= 81) THEN SNPPMOVE = .;
   IF (SNMOV5Y2 >= 981) THEN SNMOV5Y2 = .;
   IF (SNSPOUSE >= 81) THEN SNSPOUSE = .;
   IF (SNSPACTV >= 81) THEN SNSPACTV = .;
   IF (SNSPANGR >= 81) THEN SNSPANGR = .;
   IF (SNSPHITU >= 81) THEN SNSPHITU = .;
   IF (SNYHITSP >= 81) THEN SNYHITSP = .;
   IF (SNSPCRIT >= 81) THEN SNSPCRIT = .;
   IF (SNSPCONC >= 81) THEN SNSPCONC = .;
   IF (SNFRCONC >= 81) THEN SNFRCONC = .;
   IF (SNFRACTV >= 81) THEN SNFRACTV = .;
   IF (SNFRCARE >= 81) THEN SNFRCARE = .;
   IF (SNYSELL >= 81) THEN SNYSELL = .;
   IF (SNYSTOLE >= 81) THEN SNYSTOLE = .;
   IF (SNYATTAK >= 81) THEN SNYATTAK = .;
   IF (SNFACIG >= 81) THEN SNFACIG = .;
   IF (SNFAMJEV >= 81) THEN SNFAMJEV = .;
   IF (SNFAALDY >= 81) THEN SNFAALDY = .;
   IF (SNFAALDV >= 81) THEN SNFAALDV = .;
   IF (YECRIME >= 81) THEN YECRIME = .;
   IF (YESELLDG >= 81) THEN YESELLDG = .;
   IF (YEPPHLP >= 81) THEN YEPPHLP = .;
   IF (YESTFGT >= 81) THEN YESTFGT = .;
   IF (YEEMTBLD >= 81) THEN YEEMTBLD = .;
   IF (YEPPVSIT >= 81) THEN YEPPVSIT = .;
   IF (YEGRAFTI >= 81) THEN YEGRAFTI = .;
   IF (YEPPMOVE >= 81) THEN YEPPMOVE = .;
   IF (YEMOV5Y2 >= 981) THEN YEMOV5Y2 = .;
   IF (YEENRLYR >= 81) THEN YEENRLYR = .;
   IF (YELSTGRD >= 81) THEN YELSTGRD = .;
   IF (YEYFGTSW >= 81) THEN YEYFGTSW = .;
   IF (YEYFGTGP >= 81) THEN YEYFGTGP = .;
   IF (YEYHGUN >= 81) THEN YEYHGUN = .;
   IF (YEYSELL >= 81) THEN YEYSELL = .;
   IF (YEYSTOLE >= 81) THEN YEYSTOLE = .;
   IF (YEYATTAK >= 81) THEN YEYATTAK = .;
   IF (YEPPKCIG >= 81) THEN YEPPKCIG = .;
   IF (YEPMJEVR >= 81) THEN YEPMJEVR = .;
   IF (YEPALDLY >= 81) THEN YEPALDLY = .;
   IF (YEGPKCIG >= 81) THEN YEGPKCIG = .;
   IF (YEGMJEVR >= 81) THEN YEGMJEVR = .;
   IF (YEGALDLY >= 81) THEN YEGALDLY = .;
   IF (YETLKNON >= 81) THEN YETLKNON = .;
   IF (YETLKPAR >= 81) THEN YETLKPAR = .;
   IF (YETLKSOP >= 81) THEN YETLKSOP = .;
   IF (YEPRTDNG >= 81) THEN YEPRTDNG = .;
   IF (YEBIGBRO >= 81) THEN YEBIGBRO = .;
   IF (YEPRBSLV >= 81) THEN YEPRBSLV = .;
   IF (YEVIOPRV >= 81) THEN YEVIOPRV = .;
   IF (YEYMCA >= 81) THEN YEYMCA = .;
   IF (YESCOUTS >= 81) THEN YESCOUTS = .;
   IF (YEPRVLES >= 81) THEN YEPRVLES = .;
   IF (YEDGPRGP >= 81) THEN YEDGPRGP = .;
   IF (YETEMSPT >= 81) THEN YETEMSPT = .;
   IF (YE4HCLUB >= 81) THEN YE4HCLUB = .;
   IF (YESLFHLP >= 81) THEN YESLFHLP = .;
   IF (YEBAND >= 81) THEN YEBAND = .;
   IF (YESCHCLB >= 81) THEN YESCHCLB = .;
   IF (YEVOLUNT >= 81) THEN YEVOLUNT = .;
   IF (YESTGOVT >= 81) THEN YESTGOVT = .;
   IF (YEPRGSTD >= 81) THEN YEPRGSTD = .;
   IF (YEJBSKIL >= 81) THEN YEJBSKIL = .;
   IF (YECHOIR >= 81) THEN YECHOIR = .;
   IF (YEDECLAS >= 81) THEN YEDECLAS = .;
   IF (YEDERGLR >= 81) THEN YEDERGLR = .;
   IF (YEDESPCL >= 81) THEN YEDESPCL = .;
   IF (YEPVNTYR >= 81) THEN YEPVNTYR = .;
   IF (YECGFRND >= 81) THEN YECGFRND = .;
   IF (YECGVEND >= 81) THEN YECGVEND = .;
   IF (YECGMAI2 >= 81) THEN YECGMAI2 = .;
   IF (YECGCHKO >= 81) THEN YECGCHKO = .;
   IF (YECGCLRK >= 81) THEN YECGCLRK = .;
   IF (YECGINET >= 81) THEN YECGINET = .;
   IF (YECGSMKT >= 81) THEN YECGSMKT = .;
   IF (YECGDSTO >= 81) THEN YECGDSTO = .;
   IF (YECGCONV >= 81) THEN YECGCONV = .;
   IF (YECGINDV >= 81) THEN YECGINDV = .;
   IF (YECGPRUF >= 81) THEN YECGPRUF = .;
   IF (YECGSUCC >= 81) THEN YECGSUCC = .;
   IF (YEPKCRTN >= 81) THEN YEPKCRTN = .;
   IF (YEPDPACK >= 81) THEN YEPDPACK = .;
   IF (YEPDCRTN >= 81) THEN YEPDCRTN = .;
   IF (YEBLNTEV >= 81) THEN YEBLNTEV = .;
   IF (YEBLNT30 >= 81) THEN YEBLNT30 = .;
   IF (YEBL30FQ >= 81) THEN YEBL30FQ = .;
   IF (YECGRWMJ >= 81) THEN YECGRWMJ = .;
   IF (NGHCRIM2 = -9) THEN NGHCRIM2 = .;
   IF (NGHSELL2 = -9) THEN NGHSELL2 = .;
   IF (NGHHELP2 = -9) THEN NGHHELP2 = .;
   IF (NGHFGHT2 = -9) THEN NGHFGHT2 = .;
   IF (NGHBLDG2 = -9) THEN NGHBLDG2 = .;
   IF (NGHVSIT2 = -9) THEN NGHVSIT2 = .;
   IF (NGHGRAF2 = -9) THEN NGHGRAF2 = .;
   IF (NGHMOVE2 = -9) THEN NGHMOVE2 = .;
   IF (MVIN5YR2 = -9) THEN MVIN5YR2 = .;
   IF (PRPKCIG2 = -9) THEN PRPKCIG2 = .;
   IF (PRMJEVR2 = -9) THEN PRMJEVR2 = .;
   IF (PRALDLY2 = -9) THEN PRALDLY2 = .;
   IF (PRTALK3 = -9) THEN PRTALK3 = .;
   IF (YOFIGHT2 = -9) THEN YOFIGHT2 = .;
   IF (YOGRPFT2 = -9) THEN YOGRPFT2 = .;
   IF (YOHGUN2 = -9) THEN YOHGUN2 = .;
   IF (YOSELL2 = -9) THEN YOSELL2 = .;
   IF (YOSTOLE2 = -9) THEN YOSTOLE2 = .;
   IF (YOATTAK2 = -9) THEN YOATTAK2 = .;
   IF (YFLPKCG2 = -9) THEN YFLPKCG2 = .;
   IF (YFLTMRJ2 = -9) THEN YFLTMRJ2 = .;
   IF (YFLADLY2 = -9) THEN YFLADLY2 = .;
   IF (YOUTHACT = -9) THEN YOUTHACT = .;
   IF (PRBSOLV2 = -9) THEN PRBSOLV2 = .;
   IF (PREVIOL2 = -9) THEN PREVIOL2 = .;
   IF (PRVDRGO2 = -9) THEN PRVDRGO2 = .;
   IF (GRPCNSL2 = -9) THEN GRPCNSL2 = .;
   IF (PREGPGM2 = -9) THEN PREGPGM2 = .;
   IF (DGSPCLS2 = -9) THEN DGSPCLS2 = .;
   IF (DGRGCLS2 = -9) THEN DGRGCLS2 = .;
   IF (DRGLECT2 = -9) THEN DRGLECT2 = .;
   IF (DRPRVME3 = -9) THEN DRPRVME3 = .;
   IF (ANYEDUC3 = -9) THEN ANYEDUC3 = .;
   IF (YMSPGRUP >= 81) THEN YMSPGRUP = .;
   IF (YMSPFNTP >= 81) THEN YMSPFNTP = .;
   IF (YMSAHOME >= 81) THEN YMSAHOME = .;
   IF (YMSAACHE >= 81) THEN YMSAACHE = .;
   IF (YMSABDRM >= 81) THEN YMSABDRM = .;
   IF (YMSASLEP >= 81) THEN YMSASLEP = .;
   IF (YMSAABDN >= 81) THEN YMSAABDN = .;
   IF (YMSAUPLV >= 81) THEN YMSAUPLV = .;
   IF (YMSAHMSK >= 81) THEN YMSAHMSK = .;
   IF (YMAGOHSF >= 81) THEN YMAGOHSF = .;
   IF (YMAGCRWD >= 81) THEN YMAGCRWD = .;
   IF (YMAGTRAV >= 81) THEN YMAGTRAV = .;
   IF (YMAGBRDG >= 81) THEN YMAGBRDG = .;
   IF (YMPAATAK >= 81) THEN YMPAATAK = .;
   IF (YMPASUFC >= 81) THEN YMPASUFC = .;
   IF (YMGAWORY >= 81) THEN YMGAWORY = .;
   IF (YMGAHDAC >= 81) THEN YMGAHDAC = .;
   IF (YMGAPAIN >= 81) THEN YMGAPAIN = .;
   IF (YMGATNSE >= 81) THEN YMGATNSE = .;
   IF (YMPHANML >= 81) THEN YMPHANML = .;
   IF (YMPHHIGH >= 81) THEN YMPHHIGH = .;
   IF (YMPHDARK >= 81) THEN YMPHDARK = .;
   IF (YMPHNEDL >= 81) THEN YMPHNEDL = .;
   IF (YMPHBLOD >= 81) THEN YMPHBLOD = .;
   IF (YMPHBRDG >= 81) THEN YMPHBRDG = .;
   IF (YMPHELEV >= 81) THEN YMPHELEV = .;
   IF (YMOCCOUN >= 81) THEN YMOCCOUN = .;
   IF (YMOCWASH >= 81) THEN YMOCWASH = .;
   IF (YMOCCHCK >= 81) THEN YMOCCHCK = .;
   IF (YMOCGERM >= 81) THEN YMOCGERM = .;
   IF (YMOCTHOT >= 81) THEN YMOCTHOT = .;
   IF (YMEATHIN >= 81) THEN YMEATHIN = .;
   IF (YMEAFAT >= 81) THEN YMEAFAT = .;
   IF (YMEATHFD >= 81) THEN YMEATHFD = .;
   IF (YMEABING >= 81) THEN YMEABING = .;
   IF (YMELWTBD >= 81) THEN YMELWTBD = .;
   IF (YMELWTPT >= 81) THEN YMELWTPT = .;
   IF (YMELSOIL >= 81) THEN YMELSOIL = .;
   IF (YMMDNINT >= 81) THEN YMMDNINT = .;
   IF (YMMDLSEG >= 81) THEN YMMDLSEG = .;
   IF (YMMDNOGD >= 81) THEN YMMDNOGD = .;
   IF (YMMDTHKL >= 81) THEN YMMDTHKL = .;
   IF (YMMDTYKL >= 81) THEN YMMDTYKL = .;
   IF (YMMDTIRD >= 81) THEN YMMDTIRD = .;
   IF (YMMDTHNK >= 81) THEN YMMDTHNK = .;
   IF (YMMABDMD >= 81) THEN YMMABDMD = .;
   IF (YMMARSLS >= 81) THEN YMMARSLS = .;
   IF (YMMATALK >= 81) THEN YMMATALK = .;
   IF (YMMASPAB >= 81) THEN YMMASPAB = .;
   IF (YMMAMDRC >= 81) THEN YMMAMDRC = .;
   IF (YMADCONC >= 81) THEN YMADCONC = .;
   IF (YMADFRGT >= 81) THEN YMADFRGT = .;
   IF (YMADFCUS >= 81) THEN YMADFCUS = .;
   IF (YMADMEDS >= 81) THEN YMADMEDS = .;
   IF (YMADAVAT >= 81) THEN YMADAVAT = .;
   IF (YMADERRO >= 81) THEN YMADERRO = .;
   IF (YMODHURT >= 81) THEN YMODHURT = .;
   IF (YMODRFUS >= 81) THEN YMODRFUS = .;
   IF (YMODANOY >= 81) THEN YMODANOY = .;
   IF (YMODMEAN >= 81) THEN YMODMEAN = .;
   IF (YMODBLMO >= 81) THEN YMODBLMO = .;
   IF (YMODTANY >= 81) THEN YMODTANY = .;
   IF (YMODSWOR >= 81) THEN YMODSWOR = .;
   IF (YMCDEXPL >= 81) THEN YMCDEXPL = .;
   IF (YMCDSHPL >= 81) THEN YMCDSHPL = .;
   IF (YMCDLIED >= 81) THEN YMCDLIED = .;
   IF (YMCDSNAT >= 81) THEN YMCDSNAT = .;
   IF (YMCDVAND >= 81) THEN YMCDVAND = .;
   IF (YMCDSTOL >= 81) THEN YMCDSTOL = .;
   IF (YMCDCRUA >= 81) THEN YMCDCRUA = .;
   IF (YMCDBKNT >= 81) THEN YMCDBKNT = .;
   IF (YUHOSPYR >= 81) THEN YUHOSPYR = .;
   IF (YUHOSPN2 >= 981) THEN YUHOSPN2 = .;
   IF (YUHOSUIC >= 81) THEN YUHOSUIC = .;
   IF (YUHODEPR >= 81) THEN YUHODEPR = .;
   IF (YUHOFEAR >= 81) THEN YUHOFEAR = .;
   IF (YUHOBKRU >= 81) THEN YUHOBKRU = .;
   IF (YUHOEATP >= 81) THEN YUHOEATP = .;
   IF (YUHOSOR >= 81) THEN YUHOSOR = .;
   IF (YURSIDYR >= 81) THEN YURSIDYR = .;
   IF (YURSIDN2 >= 981) THEN YURSIDN2 = .;
   IF (YURSSUIC >= 81) THEN YURSSUIC = .;
   IF (YURSDEPR >= 81) THEN YURSDEPR = .;
   IF (YURSFEAR >= 81) THEN YURSFEAR = .;
   IF (YURSBKRU >= 81) THEN YURSBKRU = .;
   IF (YURSEATP >= 81) THEN YURSEATP = .;
   IF (YURSSOR >= 81) THEN YURSSOR = .;
   IF (YUFCARYR >= 81) THEN YUFCARYR = .;
   IF (YUFCARN2 >= 981) THEN YUFCARN2 = .;
   IF (YUFCSUIC >= 81) THEN YUFCSUIC = .;
   IF (YUFCDEPR >= 81) THEN YUFCDEPR = .;
   IF (YUFCFEAR >= 81) THEN YUFCFEAR = .;
   IF (YUFCBKRU >= 81) THEN YUFCBKRU = .;
   IF (YUFCEATP >= 81) THEN YUFCEATP = .;
   IF (YUFCSOR >= 81) THEN YUFCSOR = .;
   IF (YUDYTXYR >= 81) THEN YUDYTXYR = .;
   IF (YUDYTXN2 >= 981) THEN YUDYTXN2 = .;
   IF (YUDYSUIC >= 81) THEN YUDYSUIC = .;
   IF (YUDYDEPR >= 81) THEN YUDYDEPR = .;
   IF (YUDYFEAR >= 81) THEN YUDYFEAR = .;
   IF (YUDYBKRU >= 81) THEN YUDYBKRU = .;
   IF (YUDYEATP >= 81) THEN YUDYEATP = .;
   IF (YUDYSOR >= 81) THEN YUDYSOR = .;
   IF (YUMHCRYR >= 81) THEN YUMHCRYR = .;
   IF (YUMHCRN2 >= 981) THEN YUMHCRN2 = .;
   IF (YUMHSUIC >= 81) THEN YUMHSUIC = .;
   IF (YUMHDEPR >= 81) THEN YUMHDEPR = .;
   IF (YUMHFEAR >= 81) THEN YUMHFEAR = .;
   IF (YUMHBKRU >= 81) THEN YUMHBKRU = .;
   IF (YUMHEATP >= 81) THEN YUMHEATP = .;
   IF (YUMHSOR >= 81) THEN YUMHSOR = .;
   IF (YUTPSTYR >= 81) THEN YUTPSTYR = .;
   IF (YUTPSTN2 >= 981) THEN YUTPSTN2 = .;
   IF (YUTPSUIC >= 81) THEN YUTPSUIC = .;
   IF (YUTPDEPR >= 81) THEN YUTPDEPR = .;
   IF (YUTPFEAR >= 81) THEN YUTPFEAR = .;
   IF (YUTPBKRU >= 81) THEN YUTPBKRU = .;
   IF (YUTPEATP >= 81) THEN YUTPEATP = .;
   IF (YUTPSOR >= 81) THEN YUTPSOR = .;
   IF (YUIHTPYR >= 81) THEN YUIHTPYR = .;
   IF (YUIHTPN2 >= 981) THEN YUIHTPN2 = .;
   IF (YUIHSUIC >= 81) THEN YUIHSUIC = .;
   IF (YUIHDEPR >= 81) THEN YUIHDEPR = .;
   IF (YUIHFEAR >= 81) THEN YUIHFEAR = .;
   IF (YUIHBKRU >= 81) THEN YUIHBKRU = .;
   IF (YUIHEATP >= 81) THEN YUIHEATP = .;
   IF (YUIHSOR >= 81) THEN YUIHSOR = .;
   IF (YUFDOCYR >= 81) THEN YUFDOCYR = .;
   IF (YUFDOCN2 >= 981) THEN YUFDOCN2 = .;
   IF (YUFDSUIC >= 81) THEN YUFDSUIC = .;
   IF (YUFDDEPR >= 81) THEN YUFDDEPR = .;
   IF (YUFDFEAR >= 81) THEN YUFDFEAR = .;
   IF (YUFDBKRU >= 81) THEN YUFDBKRU = .;
   IF (YUFDEATP >= 81) THEN YUFDEATP = .;
   IF (YUFDSOR >= 81) THEN YUFDSOR = .;
   IF (YUSPEDYR >= 81) THEN YUSPEDYR = .;
   IF (YUSHCNYR >= 81) THEN YUSHCNYR = .;
   IF (YUSHSUIC >= 81) THEN YUSHSUIC = .;
   IF (YUSHDEPR >= 81) THEN YUSHDEPR = .;
   IF (YUSHFEAR >= 81) THEN YUSHFEAR = .;
   IF (YUSHBKRU >= 81) THEN YUSHBKRU = .;
   IF (YUSHEATP >= 81) THEN YUSHEATP = .;
   IF (YUSHSOR >= 81) THEN YUSHSOR = .;
   IF (YUJAILEV >= 81) THEN YUJAILEV = .;
   IF (YUFCAREV >= 81) THEN YUFCAREV = .;
   IF (NRCH17_2 = -9) THEN NRCH17_2 = .;
   IF (PREGNANT >= 81) THEN PREGNANT = .;
   IF (NMERTMT2 >= 981) THEN NMERTMT2 = .;
   IF (INHOSPYR >= 81) THEN INHOSPYR = .;
   IF (NMNGTHS2 >= 981) THEN NMNGTHS2 = .;
   IF (PROXANS2 >= 81) THEN PROXANS2 = .;
   IF (PREG2 = -9) THEN PREG2 = .;
   IF (TRIMEST = -9) THEN TRIMEST = .;
   IF (IRWELMOS >= 81) THEN IRWELMOS = .;
   IF (IIWELMOS = 9) THEN IIWELMOS = .;
   IF (HLCALLFG >= 81) THEN HLCALLFG = .;
   IF (HLCALL99 >= 81) THEN HLCALL99 = .;
   IF (MEDICARE >= 81) THEN MEDICARE = .;
   IF (MEDICAID >= 81) THEN MEDICAID = .;
   IF (CHAMPUS >= 81) THEN CHAMPUS = .;
   IF (OGOVTINS >= 81) THEN OGOVTINS = .;
   IF (OGOVINS2 >= 981) THEN OGOVINS2 = .;
   IF (PRVHLTIN >= 81) THEN PRVHLTIN = .;
   IF (GRPHLTIN >= 81) THEN GRPHLTIN = .;
   IF (HLTINALC >= 81) THEN HLTINALC = .;
   IF (HLTINDRG >= 81) THEN HLTINDRG = .;
   IF (HLTINMNT >= 81) THEN HLTINMNT = .;
   IF (OTHLTINS >= 81) THEN OTHLTINS = .;
   IF (OTHLINS2 >= 981) THEN OTHLINS2 = .;
   IF (HLCNOTYR >= 81) THEN HLCNOTYR = .;
   IF (HLCNOTMO >= 81) THEN HLCNOTMO = .;
   IF (HLCLAST >= 81) THEN HLCLAST = .;
   IF (HLCPRIVT >= 81) THEN HLCPRIVT = .;
   IF (HLCMCAID >= 81) THEN HLCMCAID = .;
   IF (HLCMILT >= 81) THEN HLCMILT = .;
   IF (HLCMCARE >= 81) THEN HLCMCARE = .;
   IF (HLCOGOVT >= 81) THEN HLCOGOVT = .;
   IF (HLCOTHER >= 81) THEN HLCOTHER = .;
   IF (HLCOTHS2 >= 90) THEN HLCOTHS2 = .;
   IF (HLLLOSJB >= 81) THEN HLLLOSJB = .;
   IF (HLLMAJOB >= 81) THEN HLLMAJOB = .;
   IF (HLLMASOR >= 81) THEN HLLMASOR = .;
   IF (HLLCOST >= 81) THEN HLLCOST = .;
   IF (HLLINELG >= 81) THEN HLLINELG = .;
   IF (HLLNOFFR >= 81) THEN HLLNOFFR = .;
   IF (HLLDIVOR >= 81) THEN HLLDIVOR = .;
   IF (HLLDEATH >= 81) THEN HLLDEATH = .;
   IF (HLLREFUS >= 81) THEN HLLREFUS = .;
   IF (HLLNONED >= 81) THEN HLLNONED = .;
   IF (HLLSOR >= 81) THEN HLLSOR = .;
   IF (HLLSORS2 >= 90) THEN HLLSORS2 = .;
   IF (HLNVCOST >= 81) THEN HLNVCOST = .;
   IF (HLNVOFFR >= 81) THEN HLNVOFFR = .;
   IF (HLNVREF >= 81) THEN HLNVREF = .;
   IF (HLNVNEED >= 81) THEN HLNVNEED = .;
   IF (HLNVSOR >= 81) THEN HLNVSOR = .;
   IF (HLNVSP2 >= 90) THEN HLNVSP2 = .;
   IF (LANGVER >= 81) THEN LANGVER = .;
   IF (GQTYPE = -9) THEN GQTYPE = .;
   IF (AGE2 >= 81) THEN AGE2 = .;
   IF (NOMARR2 >= 81) THEN NOMARR2 = .;
   IF (SERVICE >= 81) THEN SERVICE = .;
   IF (MILSTAT >= 81) THEN MILSTAT = .;
   IF (HEALTH >= 81) THEN HEALTH = .;
   IF (IRMARIT >= 81) THEN IRMARIT = .;
   IF (IIMARIT = 9) THEN IIMARIT = .;
   IF (IREDUC2 >= 81) THEN IREDUC2 = .;
   IF (MOVESPY2 >= 981) THEN MOVESPY2 = .;
   IF (ENROLED >= 81) THEN ENROLED = .;
   IF (EDUCNOW2 >= 12) THEN EDUCNOW2 = .;
   IF (STUDNT >= 81) THEN STUDNT = .;
   IF (SCHDSICK >= 81) THEN SCHDSICK = .;
   IF (SCHDSKIP >= 81) THEN SCHDSKIP = .;
   IF (HSDIPLMA >= 81) THEN HSDIPLMA = .;
   IF (HSGED >= 81) THEN HSGED = .;
   IF (LFSCHWH2 >= 981) THEN LFSCHWH2 = .;
   IF (LFTSCHA2 >= 981) THEN LFTSCHA2 = .;
   IF (RLGSVCYR >= 81) THEN RLGSVCYR = .;
   IF (RLGIMPRT >= 81) THEN RLGIMPRT = .;
   IF (RLGDECSN >= 81) THEN RLGDECSN = .;
   IF (RLGFRNDS >= 81) THEN RLGFRNDS = .;
   IF (TELNO2 >= 81) THEN TELNO2 = .;
   IF (TUCHTONE >= 81) THEN TUCHTONE = .;
   IF (COLLEGE2 = -9) THEN COLLEGE2 = .;
   IF (JOBSTAT2 >= 10) THEN JOBSTAT2 = .;
   IF (JBSTATR2 >= 10) THEN JBSTATR2 = .;
   IF (WRKHAVJB >= 81) THEN WRKHAVJB = .;
   IF (WRKHRSWK >= 981) THEN WRKHRSWK = .;
   IF (WRKINDU2 >= 981) THEN WRKINDU2 = .;
   IF (WRKOCCU2 >= 981) THEN WRKOCCU2 = .;
   IF (WRKBZCA2 >= 81) THEN WRKBZCA2 = .;
   IF (WRKEFFRT >= 81) THEN WRKEFFRT = .;
   IF (WRKEDYR >= 81) THEN WRKEDYR = .;
   IF (WRKSLFEM >= 81) THEN WRKSLFEM = .;
   IF (WRKJOBS2 >= 981) THEN WRKJOBS2 = .;
   IF (WRKUNEMP >= 81) THEN WRKUNEMP = .;
   IF (WRKUNWKS >= 81) THEN WRKUNWKS = .;
   IF (WRKLASY2 >= 9981) THEN WRKLASY2 = .;
   IF (WRKINDY2 >= 981) THEN WRKINDY2 = .;
   IF (WRKOCCY2 >= 981) THEN WRKOCCY2 = .;
   IF (WORKDAYS >= 81) THEN WORKDAYS = .;
   IF (WORKBLAH >= 81) THEN WORKBLAH = .;
   IF (LOCSIZE >= 81) THEN LOCSIZE = .;
   IF (DRGPLCY >= 81) THEN DRGPLCY = .;
   IF (PLCYCOV >= 81) THEN PLCYCOV = .;
   IF (WKDRGED >= 81) THEN WKDRGED = .;
   IF (DRGPRGM >= 81) THEN DRGPRGM = .;
   IF (USALCTST >= 81) THEN USALCTST = .;
   IF (USDRGTST >= 81) THEN USDRGTST = .;
   IF (TSTHIRE >= 81) THEN TSTHIRE = .;
   IF (TSTRAND >= 81) THEN TSTRAND = .;
   IF (FIRSTPOS >= 81) THEN FIRSTPOS = .;
   IF (WRKHIRE >= 81) THEN WRKHIRE = .;
   IF (WORKRAND >= 81) THEN WORKRAND = .;
   IF (VESTR >= 99981) THEN VESTR = .;
*/


* SAS FORMAT STATEMENT;

/*
  FORMAT CIGEVER cigever. CIGOFRSM cigofrsm. CIGWILYR cigwilyr.
         CIGTRY cigtry. CIGYFU cigyfu. CIGMFU cigmfu.
         CIGREC cigrec. CIG30USE cig30use. CG30EST cg30est.
         CIG30AV cig30av. CIG30BR2 cig30brf. CIG30TYP cig30typ.
         CIG30MEN cig30men. CIG30RO2 cig30rof. CIGDLYMO cigdlymo.
         CIGAGE cigage. CIG100LF cig100lf. CHEWEVER chewever.
         CHEWTRY chewtry. CHEWYFU chewyfu. CHEWMFU chewmfu.
         CHEWREC chewrec. CHW30USE chw30use. CH30EST ch30est.
         CHW30BR2 chw30brf. SNFEVER snfever. SNUFTRY snuftry.
         SNUFYFU snufyfu. SNUFMFU snufmfu. SNFREC snfrec.
         SNF30USE snf30use. SN30EST sn30est. SNF30BR2 snf30brf.
         SLTTRY slttry. SLTYFU sltyfu. SLTMFU sltmfu.
         SLTREC sltrec. SLT30BR2 slt30brf. SLT30FAV slt30fav.
         CIGAREVR cigarevr. CIGARTRY cigartry. CIGARYFU cigaryfu.
         CIGARMFU cigarmfu. CIGARREC cigarrec. CGR30USE cgr30use.
         CI30EST ci30est. CGR30BR2 cgr30brf. PIPEVER pipever.
         PIPE30DY pipe30dy. ALCEVER alcever. ALCTRY alctry.
         ALCYFU alcyfu. ALCMFU alcmfu. ALCREC alcrec.
         ALCYRTOT alcyrtot. ALTOTFG altotfg. ALFQFLG alfqflg.
         ALBSTWAY albstway. ALDAYPYR aldaypyr. ALDAYPMO aldaypmo.
         ALDAYPWK aldaypwk. ALCDAYS alcdays. AL30EST al30est.
         ALDYSFG aldysfg. NODR30A nodr30a. DR5DAY dr5day.
         MJEVER mjever. MJAGE mjage. MJYFU mjyfu.
         MJMFU mjmfu. MJREC mjrec. MJYRTOT mjyrtot.
         MRTOTFG mrtotfg. MJFQFLG mjfqflg. MRBSTWAY mrbstway.
         MRDAYPYR mrdaypyr. MRDAYPMO mrdaypmo. MRDAYPWK mrdaypwk.
         MJDAY30A mjday30a. MR30EST mr30est. COCEVER cocever.
         COCAGE cocage. COCYFU cocyfu. COCMFU cocmfu.
         COCREC cocrec. COCYRTOT cocyrtot. CCTOTFG cctotfg.
         CCFQFLG ccfqflg. CCBSTWAY ccbstway. CCDAYPYR ccdaypyr.
         CCDAYPMO ccdaypmo. CCDAYPWK ccdaypwk. COCUS30A cocus30a.
         CC30EST cc30est. CRKEVER crkever. CRKAGE crkage.
         CRKYFU crkyfu. CRKMFU crkmfu. CRAKREC crakrec.
         CRKYRTOT crkyrtot. CRTOTFG crtotfg. CRFQFLG crfqflg.
         CRBSTWAY crbstway. CRDAYPYR crdaypyr. CRDAYPMO crdaypmo.
         CRDAYPWK crdaypwk. CRKUS30A crkus30a. CR30EST cr30est.
         HEREVER herever. HERAGE herage. HERYFU heryfu.
         HERMFU hermfu. HERREC herrec. HERYRTOT heryrtot.
         HRTOTFG hrtotfg. HRFQFLG hrfqflg. HRBSTWAY hrbstway.
         HRDAYPYR hrdaypyr. HRDAYPMO hrdaypmo. HRDAYPWK hrdaypwk.
         HER30USE her30use. HR30EST hr30est. LSD lsd.
         PCP pcp. PEYOTE peyote. MESC mesc.
         PSILCY psilcy. ECSTASY ecstasy. HALNOLST halnolst.
         HALNEWA halnewa. HALNEWB halnewb. HALNEWC halnewc.
         HALNEWD halnewd. HALNEWE halnewe. HALLAGE hallage.
         HALYFU halyfu. HALMFU halmfu. HALLREC hallrec.
         HALYRTOT halyrtot. HLTOTFG hltotfg. HLFQFLG hlfqflg.
         HLBSTWAY hlbstway. HLDAYPYR hldaypyr. HLDAYPMO hldaypmo.
         HLDAYPWK hldaypwk. HAL30USE hal30use. HL30EST hl30est.
         LSDAGE lsdage. LSDYFU lsdyfu. LSDMFU lsdmfu.
         LSDREC lsdrec. PCPAGE pcpage. PCPYFU pcpyfu.
         PCPMFU pcpmfu. PCPREC pcprec. AMYLNIT amylnit.
         CLEFLU cleflu. GAS gas. GLUE glue.
         ETHER ether. SOLVENT solvent. LGAS lgas.
         NITOXID nitoxid. SPPAINT sppaint. AEROS aeros.
         INHNOLST inhnolst. INHNEWA inhnewa. INHNEWB inhnewb.
         INHNEWC inhnewc. INHNEWD inhnewd. INHNEWE inhnewe.
         INHAGE inhage. INHYFU inhyfu. INHMFU inhmfu.
         INHREC inhrec. INHYRTOT inhyrtot. INTOTFG intotfg.
         INFQFLG infqflg. INBSTWAY inbstway. INDAYPYR indaypyr.
         INDAYPMO indaypmo. INDAYPWK indaypwk. INHDY30A inhdy30a.
         IN30EST in30est. DARVTYLC darvtylc. PERCTYLX perctylx.
         VICOLOR vicolor. ANLCARD anlcard. CODEINE codeine.
         DEMEROL demerol. DILAUD dilaud. FIORICET fioricet.
         FIORINAL fiorinal. HYDROCOD hydrocod. METHDON methdon.
         MORPHINE morphine. OXYCONTN oxycontn. PHENCOD phencod.
         PROPOXY propoxy. SK65A sk65a. STADOL stadol.
         TALACEN talacen. TALWIN talwin. TALWINNX talwinnx.
         TRAMADOL tramadol. ULTRAM ultram. ANLNOLST anlnolst.
         ANALNEWA analnewa. ANALNEWB analnewb. ANALNEWC analnewc.
         ANALNEWD analnewd. ANALNEWE analnewe. ANALAGE analage.
         ANALYFU analyfu. ANALMFU analmfu. ANALREC analrec.
         ANLYRTOT anlyrtot. PRTOTFG prtotfg. PRFQFLG prfqflg.
         PRBSTWAY prbstway. PRDAYPYR prdaypyr. PRDAYPMO prdaypmo.
         PRDAYPWK prdaypwk. KLONOPIN klonopin. XNAXATVN xnaxatvn.
         VALMDIAZ valmdiaz. TRNCARD trncard. ATARAX atarax.
         BUSPAR buspar. EQUANIL equanil. FLEXERIL flexeril.
         LIBRIUM librium. LIMBTROL limbtrol. MEPROB meprob.
         MILTOWN miltown. ROHYPNOL rohypnol. SERAX serax.
         SOMA soma. TRANXENE tranxene. VISTAR vistar.
         TRNOLST trnolst. TRNEWA trnewa. TRNEWB trnewb.
         TRNEWC trnewc. TRNEWD trnewd. TRNEWE trnewe.
         TRANAGE tranage. TRANYFU tranyfu. TRANMFU tranmfu.
         TRANREC tranrec. TRNYRTOT trnyrtot. TRTOTFG trtotfg.
         TRFQFLG trfqflg. TRBSTWAY trbstway. TRDAYPYR trdaypyr.
         TRDAYPMO trdaypmo. TRDAYPWK trdaypwk. METHDES methdes.
         DIETPILS dietpils. RITMPHEN ritmphen. STMCARD stmcard.
         CYLERT cylert. DEXED dexed. DETAMP detamp.
         DIDREX didrex. ESKAT eskat. IONAMIN ionamin.
         MAZANOR mazanor. OBLA obla. PLEGINE plegine.
         PRELUDIN preludin. SANOREX sanorex. TENUATE tenuate.
         STMNOLST stmnolst. STIMNEWA stimnewa. STIMNEWB stimnewb.
         STIMNEWC stimnewc. STIMNEWD stimnewd. STIMNEWE stimnewe.
         STIMAGE stimage. STIMYFU stimyfu. STIMMFU stimmfu.
         STIMREC stimrec. STMYRTOT stmyrtot. STTOTFG sttotfg.
         STFQFLG stfqflg. STBSTWAY stbstway. STDAYPYR stdaypyr.
         STDAYPMO stdaypmo. STDAYPWK stdaypwk. METHAGE methage.
         METHYFU methyfu. METHMFU methmfu. METHREC methrec.
         METHAQ methaq. NEMBBARB nembbarb. RESTTMAZ resttmaz.
         SEDCARD sedcard. AMYTAL amytal. BUTISOL butisol.
         CHHYD chhyd. DALMANE dalmane. HALCION halcion.
         PHENOBAR phenobar. PLACIDYL placidyl. TUINAL tuinal.
         SEDNOLST sednolst. SEDNEWA sednewa. SEDNEWB sednewb.
         SEDNEWC sednewc. SEDNEWD sednewd. SEDNEWE sednewe.
         SEDAGE sedage. SEDYFU sedyfu. SEDMFU sedmfu.
         SEDREC sedrec. SEDYRTOT sedyrtot. SVTOTFG svtotfg.
         SVFQFLG svfqflg. SVBSTWAY svbstway. SVDAYPYR svdaypyr.
         SVDAYPMO svdaypmo. SVDAYPWK svdaypwk. IRCIGRC ircigrc.
         IICIGRC iicigrc. II2CIGRC ii2cigrc. IRCGRRC ircgrrc.
         IICGRRC iicgrrc. II2CGRRC ii2cgrrc. IRPIPLF irpiplf.
         IIPIPLF iipiplf. IRPIPMN irpipmn. IIPIPMN iipipmn.
         IRSLTRC irsltrc. IISLTRC iisltrc. II2SLTRC ii2sltrc.
         IRCHWRC irchwrc. IICHWRC iichwrc. II2CHWRC ii2chwrc.
         IRSNFRC irsnfrc. IISNFRC iisnfrc. II2SNFRC ii2snfrc.
         IRALCRC iralcrc. IIALCRC iialcrc. II2ALCRC ii2alcrc.
         IRMJRC irmjrc. IIMJRC iimjrc. II2MJRC ii2mjrc.
         IRCOCRC ircocrc. IICOCRC iicocrc. II2COCRC ii2cocrc.
         IRCRKRC ircrkrc. IICRKRC iicrkrc. II2CRKRC ii2crkrc.
         IRHERRC irherrc. IIHERRC iiherrc. II2HERRC ii2herrc.
         IRHALRC irhalrc. IIHALRC iihalrc. II2HALRC ii2halrc.
         IRLSDRC irlsdrc. IILSDRC iilsdrc. II2LSDRC ii2lsdrc.
         IRPCPRC irpcprc. IIPCPRC iipcprc. II2PCPRC ii2pcprc.
         IRINHRC irinhrc. IIINHRC iiinhrc. II2INHRC ii2inhrc.
         IRANLRC iranlrc. IIANLRC iianlrc. II2ANLRC ii2anlrc.
         IRTRNRC irtrnrc. IITRNRC iitrnrc. II2TRNRC ii2trnrc.
         IRSTMRC irstmrc. IISTMRC iistmrc. II2STMRC ii2stmrc.
         IRMTHRC irmthrc. IIMTHRC iimthrc. II2MTHRC ii2mthrc.
         IRSEDRC irsedrc. IISEDRC iisedrc. II2SEDRC ii2sedrc.
         IRALCFY iralcfy. IIALCFY iialcfy. II2ALCFY ii2alcfy.
         IRMJFY irmjfy. IIMJFY iimjfy. II2MJFY ii2mjfy.
         IRCOCFY ircocfy. IICOCFY iicocfy. II2COCFY ii2cocfy.
         IRCRKFY ircrkfy. IICRKFY iicrkfy. II2CRKFY ii2crkfy.
         IRHERFY irherfy. IIHERFY iiherfy. II2HERFY ii2herfy.
         IRHALFY irhalfy. IIHALFY iihalfy. II2HALFY ii2halfy.
         IRINHFY irinhfy. IIINHFY iiinhfy. II2INHFY ii2inhfy.
         IRANLFY iranlfy. IIANLFY iianlfy. II2ANLFY ii2anlfy.
         IRTRNFY irtrnfy. IITRNFY iitrnfy. II2TRNFY ii2trnfy.
         IRSTMFY irstmfy. IISTMFY iistmfy. II2STMFY ii2stmfy.
         IRSEDFY irsedfy. IISEDFY iisedfy. II2SEDFY ii2sedfy.
         IRCIGFM ircigfm. IICIGFM iicigfm. II2CIGFM ii2cigfm.
         IRCGRFM ircgrfm. IICGRFM iicgrfm. II2CGRFM ii2cgrfm.
         IRCHWFM irchwfm. IICHWFM iichwfm. II2CHWFM ii2chwfm.
         IRSNFFM irsnffm. IISNFFM iisnffm. II2SNFFM ii2snffm.
         IRALCFM iralcfm. IIALCFM iialcfm. II2ALCFM ii2alcfm.
         IRALCD5 iralcd5f. IIALCD5 iialcd5f. II2ALCD5 ii2alcdf.
         IRMJFM irmjfm. IIMJFM iimjfm. II2MJFM ii2mjfm.
         IRCOCFM ircocfm. IICOCFM iicocfm. II2COCFM ii2cocfm.
         IRCRKFM ircrkfm. IICRKFM iicrkfm. II2CRKFM ii2crkfm.
         IRHERFM irherfm. IIHERFM iiherfm. II2HERFM ii2herfm.
         IRHALFM irhalfm. IIHALFM iihalfm. II2HALFM ii2halfm.
         IRINHFM irinhfm. IIINHFM iiinhfm. II2INHFM ii2inhfm.
         IRCIGAGE ircigage. IICIGAGE iicigage. IRCIGYFU ircigyfu.
         IICIGYFU iicigyfu. IRCDUAGE ircduage. IICDUAGE iicduage.
         IRCDUYFU ircduyfu. IICDUYFU iicduyfu. IRCGRAGE ircgrage.
         IICGRAGE iicgrage. IRCGRYFU ircgryfu. IICGRYFU iicgryfu.
         IRSNFAGE irsnfage. IISNFAGE iisnfage. IRSNFYFU irsnfyfu.
         IISNFYFU iisnfyfu. IRCHWAGE irchwage. IICHWAGE iichwage.
         IRCHWYFU irchwyfu. IICHWYFU iichwyfu. IRSLTAGE irsltage.
         IISLTAGE iisltage. IRSLTYFU irsltyfu. IISLTYFU iisltyfu.
         IRALCAGE iralcage. IIALCAGE iialcage. IRALCYFU iralcyfu.
         IIALCYFU iialcyfu. IRMJAGE irmjage. IIMJAGE iimjage.
         IRMJYFU irmjyfu. IIMJYFU iimjyfu. IRCOCAGE ircocage.
         IICOCAGE iicocage. IRCOCYFU ircocyfu. IICOCYFU iicocyfu.
         IRCRKAGE ircrkage. IICRKAGE iicrkage. IRCRKYFU ircrkyfu.
         IICRKYFU iicrkyfu. IRHERAGE irherage. IIHERAGE iiherage.
         IRHERYFU irheryfu. IIHERYFU iiheryfu. IRHALAGE irhalage.
         IIHALAGE iihalage. IRHALYFU irhalyfu. IIHALYFU iihalyfu.
         IRLSDAGE irlsdage. IILSDAGE iilsdage. IRLSDYFU irlsdyfu.
         IILSDYFU iilsdyfu. IRPCPAGE irpcpage. IIPCPAGE iipcpage.
         IRPCPYFU irpcpyfu. IIPCPYFU iipcpyfu. IRINHAGE irinhage.
         IIINHAGE iiinhage. IRINHYFU irinhyfu. IIINHYFU iiinhyfu.
         IRANLAGE iranlage. IIANLAGE iianlage. IRANLYFU iranlyfu.
         IIANLYFU iianlyfu. IRTRNAGE irtrnage. IITRNAGE iitrnage.
         IRTRNYFU irtrnyfu. IITRNYFU iitrnyfu. IRSTMAGE irstmage.
         IISTMAGE iistmage. IRSTMYFU irstmyfu. IISTMYFU iistmyfu.
         IRMTHAGE irmthage. IIMTHAGE iimthage. IRMTHYFU irmthyfu.
         IIMTHYFU iimthyfu. IRSEDAGE irsedage. IISEDAGE iisedage.
         IRSEDYFU irsedyfu. IISEDYFU iisedyfu. CIGFLAG cigflag.
         CIGYR cigyr. CIGMON cigmon. CGRFLAG cgrflag.
         CGRYR cgryr. CGRMON cgrmon. PIPFLAG pipflag.
         PIPMON pipmon. SMKFLAG smkflag. SMKYR smkyr.
         SMKMON smkmon. CHWFLAG chwflag. CHWYR chwyr.
         CHWMON chwmon. SNFFLAG snfflag. SNFYR snfyr.
         SNFMON snfmon. TOBFLAG tobflag. TOBYR tobyr.
         TOBMON tobmon. CIGBRND2 cigbrndf. CGRBRND2 cgrbrndf.
         SMKBRND2 smkbrndf. CIGCMPNY cigcmpny. ALCFLAG alcflag.
         ALCYR alcyr. ALCMON alcmon. MRJFLAG mrjflag.
         MRJYR mrjyr. MRJMON mrjmon. COCFLAG cocflag.
         COCYR cocyr. COCMON cocmon. CRKFLAG crkflag.
         CRKYR crkyr. CRKMON crkmon. HERFLAG herflag.
         HERYR heryr. HERMON hermon. HALFLAG halflag.
         HALYR halyr. HALMON halmon. LSDFLAG lsdflag.
         LSDYR lsdyr. LSDMON lsdmon. PCPFLAG pcpflag.
         PCPYR pcpyr. PCPMON pcpmon. INHFLAG inhflag.
         INHYR inhyr. INHMON inhmon. ANLFLAG anlflag.
         ANLYR anlyr. ANLMON anlmon. TRQFLAG trqflag.
         TRQYR trqyr. TRQMON trqmon. STMFLAG stmflag.
         STMYR stmyr. STMMON stmmon. MTHFLAG mthflag.
         MTHYR mthyr. MTHMON mthmon. SEDFLAG sedflag.
         SEDYR sedyr. SEDMON sedmon. PSYFLAG2 psyflagf.
         PSYYR2 psyyr2ff. PSYMON2 psymon2f. SUMFLAG sumflag.
         SUMYR sumyr. SUMMON summon. MJOFLAG mjoflag.
         MJOYR2 mjoyr2ff. MJOMON2 mjomon2f. IEMFLAG iemflag.
         IEMYR iemyr. IEMMON iemmon. BINGEDRK bingedrk.
         HVYDRK2 hvydrk2f. BINGEHVY bingehvy. PEYOTE2 peyote2f.
         MESC2 mesc2fff. PSILCY2 psilcy2f. ECSTASY2 ecstasyf.
         AMYLNIT2 amylnitf. CLEFLU2 cleflu2f. GAS2 gas2ffff.
         GLUE2 glue2fff. ETHER2 ether2ff. SOLVENT2 solventf.
         LGAS2 lgas2fff. NITOXID2 nitoxidf. SPPAINT2 sppaintf.
         AEROS2 aeros2ff. DARVTYL2 darvtylf. PERCTYL2 perctylf.
         VICOLOR2 vicolorf. CODEINE2 codeinef. DEMEROL2 demerolf.
         DILAUD2 dilaud2f. FIORICT2 fiorictf. FIORINL2 fiorinlf.
         HYDROCD2 hydrocdf. METHDON2 methdonf. MORPHIN2 morphinf.
         OXYCONT2 oxycontf. PHENCOD2 phencodf. PROPOXY2 propoxyf.
         SK65A2 sk65a2ff. STADOL2 stadol2f. TALACEN2 talacenf.
         TALWIN2 talwin2f. TALWINX2 talwinxf. TRAMADL2 tramadlf.
         ULTRAM2 ultram2f. OTHANL othanl. KLONOPI2 klonopif.
         XNAXATV2 xnaxatvf. VALMDIA2 valmdiaf. ATARAX2 atarax2f.
         BUSPAR2 buspar2f. EQUANIL2 equanilf. FLEXERL2 flexerlf.
         LIBRIUM2 libriumf. LIMBTRL2 limbtrlf. MEPROB2 meprob2f.
         MILTOWN2 miltownf. ROHYPNL2 rohypnlf. SERAX2 serax2ff.
         SOMA2 soma2fff. TRANXEN2 tranxenf. VISTAR2 vistar2f.
         OTHTRN othtrn. METHDES2 methdesf. DIETPIL2 dietpilf.
         RITMPHE2 ritmphef. CYLERT2 cylert2f. DEXED2 dexed2ff.
         DETAMP2 detamp2f. DIDREX2 didrex2f. ESKAT2 eskat2ff.
         IONAMIN2 ionaminf. MAZANOR2 mazanorf. OBLA2 obla2fff.
         PLEGINE2 pleginef. PRELUDN2 preludnf. SANOREX2 sanorexf.
         TENUATE2 tenuatef. OTHSTM othstm. METHAQ2 methaq2f.
         NEMBBAR2 nembbarf. RESTTMA2 resttmaf. AMYTAL2 amytal2f.
         BUTISOL2 butisolf. CHHYD2 chhyd2ff. DALMANE2 dalmanef.
         HALCION2 halcionf. PHENOBR2 phenobrf. PLACIDY2 placidyf.
         TUINAL2 tuinal2f. OTHSED othsed. ALCAFU alcafu.
         MJAFU mjafu. COCAFU cocafu. HERAFU herafu.
         HALAFU halafu. INHAFU inhafu. ANLAFU anlafu.
         TRNAFU trnafu. STMAFU stmafu. SEDAFU sedafu.
         CIGAFU cigafu. CGRAFU cgrafu. SLTAFU sltafu.
         MRJYDAYS mrjydays. COCYDAYS cocydays. HALYDAYS halydays.
         INHYDAYS inhydays. ALCYDAYS alcydays. MRJMDAYS mrjmdays.
         COCMDAYS cocmdays. HALMDAYS halmdays. INHMDAYS inhmdays.
         ALCMDAYS alcmdays. CIGMDAYS cigmdays. CIGPDAY cigpday.
         CG05 cg05ffff. CG06 cg06ffff. CG06DK cg06dk.
         CG06RE cg06re. CG19 cg19ffff. CG20 cg20ffff.
         CG20DK cg20dk. CG20RE cg20re. CG27 cg27ffff.
         CG28 cg28ffff. CG28DK cg28dk. CG28RE cg28re.
         CG36 cg36ffff. CG37 cg37ffff. CG37DK cg37dk.
         CG37RE cg37re. CG43 cg43ffff. ALLAST3 allast3f.
         ALRECDK alrecdk. ALRECRE alrecre. TOTDRINK totdrink.
         ALFRAME3 alframef. ALYRAVE alyrave. ALMONAVE almonave.
         ALWKAVE alwkave. MJLAST3 mjlast3f. MJRECDK mjrecdk.
         MJRECRE mjrecre. TOTMJ totmj. MJFRAME3 mjframef.
         MJYRAVE mjyrave. MJMONAVE mjmonave. MJWKAVE mjwkave.
         CCLAST3 cclast3f. CCRECDK ccrecdk. CCRECRE ccrecre.
         TOTCOKE totcoke. CCFRAME3 ccframef. CCYRAVE ccyrave.
         CCMONAVE ccmonave. CCWKAVE ccwkave. CKLAST3 cklast3f.
         CKRECDK ckrecdk. CKRECRE ckrecre. TOTCRACK totcrack.
         CKFRAME3 ckframef. CKYRAVE ckyrave. CKMONAVE ckmonave.
         CKWKAVE ckwkave. HELAST3 helast3f. HERECDK herecdk.
         HERECRE herecre. TOTHERO tothero. HEFRAME3 heframef.
         HEYRAVE heyrave. HEMONAVE hemonave. HEWKAVE hewkave.
         LSLAST lslast. LSRECDK lsrecdk. LSRECRE lsrecre.
         TOTHALL tothall. LSFRAME3 lsframef. LSYRAVE lsyrave.
         LSMONAVE lsmonave. LSWKAVE lswkave. LS10 ls10ffff.
         LS16 ls16ffff. INLAST inlast. INRECDK inrecdk.
         INRECRE inrecre. TOTINHAL totinhal. INFRAME3 inframef.
         INYRAVE inyrave. INMONAVE inmonave. INWKAVE inwkave.
         PR09 pr09ffff. PRRECDK prrecdk. PRRECRE prrecre.
         PR10 pr10ffff. PR11 pr11ffff. PR12 pr12ffff.
         PR13 pr13ffff. TR09 tr09ffff. TRRECDK trrecdk.
         TRRECRE trrecre. TR10 tr10ffff. TR11 tr11ffff.
         TR12 tr12ffff. TR13 tr13ffff. ST09 st09ffff.
         STRECDK strecdk. STRECRE strecre. ST10 st10ffff.
         ST11 st11ffff. ST12 st12ffff. ST13 st13ffff.
         ST19 st19ffff. SV09 sv09ffff. SVRECDK svrecdk.
         SVRECRE svrecre. SV10 sv10ffff. SV11 sv11ffff.
         SV12 sv12ffff. SV13 sv13ffff. HERSMOKE hersmoke.
         HRSMKREC hrsmkrec. HERSNIFF hersniff. HRSNFREC hrsnfrec.
         GNNDLLIF gnndllif. COCNEEDL cocneedl. CONDLREC condlrec.
         HERNEEDL herneedl. HRNDLREC hrndlrec. STNEEDLE stneedle.
         STNDLREC stndlrec. GNNDREUS gnndreus. GNNDLSH1 gnndlshf.
         GNNDCLEN gnndclen. GNNDLSH2 gnndls0f. GNNDGET2 gnndgetf.
         NEDLRECC nedlrecc. NEDFLAG4 nedflagf. HERSMOK2 hersmokf.
         HERSNIF2 hersni0f. NEDHER nedher. NEDCOC nedcoc.
         NEDSTM nedstm. RSKPKCIG rskpkcig. RSKMJOCC rskmjocc.
         RSKMJREG rskmjreg. RKTRYLSD rktrylsd. RKLSDREG rklsdreg.
         RKTRYHER rktryher. RKHERREG rkherreg. RKCOCOCC rkcococc.
         RKCOCREG rkcocreg. RK5ALDLY rk5aldly. RK5ALWK rk5alwk.
         RSKDIFMJ rskdifmj. RKDIFLSD rkdiflsd. RKDIFCOC rkdifcoc.
         RKDIFCRK rkdifcrk. RKDIFHER rkdifher. RSKSELL rsksell.
         RKFQDNGR rkfqdngr. RKFQRSKY rkfqrsky. RKFQPBLT rkfqpblt.
         RKFQDBLT rkfqdblt. GRSKPKCG grskpkcg. GRSKCREG grskcreg.
         GRSKCOCC grskcocc. GRSKMREG grskmreg. GRSKMOCC grskmocc.
         GRSKHTRY grskhtry. GRSKHREG grskhreg. GRSKLTRY grskltry.
         GRSKLREG grsklreg. GRSKD4_5 grskd4_f. GRSKD5WK grskd5wk.
         RDIFMJ rdifmj. RDIFCOC rdifcoc. RDIFHER rdifher.
         RDIFLSD rdiflsd. RDIFCRK rdifcrk. APPSELDG appseldg.
         CIGLOTTM ciglottm. CIGLIMIT ciglimit. CIGKPLMT cigkplmt.
         CIGNDMOR cigndmor. CIGLSEFX ciglsefx. CIGCUTDN cigcutdn.
         CIGCUTEV cigcutev. CIGCUT1X cigcut1x. CIGWD4SX cigwd4sx.
         CIGWDSMT cigwdsmt. CIGEMOPB cigemopb. CIGEMCTD cigemctd.
         CIGPHLPB cigphlpb. CIGPHCTD cigphctd. CIGLSACT ciglsact.
         CIGPKCRT cigpkcrt. CIGPDPAK cigpdpak. CIGPDCRT cigpdcrt.
         ALCLOTTM alclottm. ALCGTOVR alcgtovr. ALCLIMIT alclimit.
         ALCKPLMT alckplmt. ALCNDMOR alcndmor. ALCLSEFX alclsefx.
         ALCCUTDN alccutdn. ALCCUTEV alccutev. ALCCUT1X alccut1x.
         ALCWD2SX alcwd2sx. ALCWDSMT alcwdsmt. ALCEMOPB alcemopb.
         ALCEMCTD alcemctd. ALCPHLPB alcphlpb. ALCPHCTD alcphctd.
         ALCLSACT alclsact. ALCSERPB alcserpb. ALCPDANG alcpdang.
         ALCLAWTR alclawtr. ALCFMFPB alcfmfpb. ALCFMCTD alcfmctd.
         MRJLOTTM mrjlottm. MRJGTOVR mrjgtovr. MRJLIMIT mrjlimit.
         MRJKPLMT mrjkplmt. MRJNDMOR mrjndmor. MRJLSEFX mrjlsefx.
         MRJCUTDN mrjcutdn. MRJCUTEV mrjcutev. MRJEMOPB mrjemopb.
         MRJEMCTD mrjemctd. MRJPHLPB mrjphlpb. MRJPHCTD mrjphctd.
         MRJLSACT mrjlsact. MRJSERPB mrjserpb. MRJPDANG mrjpdang.
         MRJLAWTR mrjlawtr. MRJFMFPB mrjfmfpb. MRJFMCTD mrjfmctd.
         COCLOTTM coclottm. COCGTOVR cocgtovr. COCLIMIT coclimit.
         COCKPLMT cockplmt. COCNDMOR cocndmor. COCLSEFX coclsefx.
         COCCUTDN coccutdn. COCCUTEV coccutev. COCCUT1X coccut1x.
         COCFLBLU cocflblu. COCWD2SX cocwd2sx. COCWDSMT cocwdsmt.
         COCEMOPB cocemopb. COCEMCTD cocemctd. COCPHLPB cocphlpb.
         COCPHCTD cocphctd. COCLSACT coclsact. COCSERPB cocserpb.
         COCPDANG cocpdang. COCLAWTR coclawtr. COCFMFPB cocfmfpb.
         COCFMCTD cocfmctd. HERLOTTM herlottm. HERGTOVR hergtovr.
         HERLIMIT herlimit. HERKPLMT herkplmt. HERNDMOR herndmor.
         HERLSEFX herlsefx. HERCUTDN hercutdn. HERCUTEV hercutev.
         HERCUT1X hercut1x. HERWD3SX herwd3sx. HERWDSMT herwdsmt.
         HEREMOPB heremopb. HEREMCTD heremctd. HERPHLPB herphlpb.
         HERPHCTD herphctd. HERLSACT herlsact. HERSERPB herserpb.
         HERPDANG herpdang. HERLAWTR herlawtr. HERFMFPB herfmfpb.
         HERFMCTD herfmctd. HALLOTTM hallottm. HALGTOVR halgtovr.
         HALLIMIT hallimit. HALKPLMT halkplmt. HALNDMOR halndmor.
         HALLSEFX hallsefx. HALCUTDN halcutdn. HALCUTEV halcutev.
         HALEMOPB halemopb. HALEMCTD halemctd. HALPHLPB halphlpb.
         HALPHCTD halphctd. HALLSACT hallsact. HALSERPB halserpb.
         HALPDANG halpdang. HALLAWTR hallawtr. HALFMFPB halfmfpb.
         HALFMCTD halfmctd. INHLOTTM inhlottm. INHGTOVR inhgtovr.
         INHLIMIT inhlimit. INHKPLMT inhkplmt. INHNDMOR inhndmor.
         INHLSEFX inhlsefx. INHCUTDN inhcutdn. INHCUTEV inhcutev.
         INHEMOPB inhemopb. INHEMCTD inhemctd. INHPHLPB inhphlpb.
         INHPHCTD inhphctd. INHLSACT inhlsact. INHSERPB inhserpb.
         INHPDANG inhpdang. INHLAWTR inhlawtr. INHFMFPB inhfmfpb.
         INHFMCTD inhfmctd. ANLLOTTM anllottm. ANLGTOVR anlgtovr.
         ANLLIMIT anllimit. ANLKPLMT anlkplmt. ANLNDMOR anlndmor.
         ANLLSEFX anllsefx. ANLCUTDN anlcutdn. ANLCUTEV anlcutev.
         ANLCUT1X anlcut1x. ANLWD3SX anlwd3sx. ANLWDSMT anlwdsmt.
         ANLEMOPB anlemopb. ANLEMCTD anlemctd. ANLPHLPB anlphlpb.
         ANLPHCTD anlphctd. ANLLSACT anllsact. ANLSERPB anlserpb.
         ANLPDANG anlpdang. ANLLAWTR anllawtr. ANLFMFPB anlfmfpb.
         ANLFMCTD anlfmctd. TRNLOTTM trnlottm. TRNGTOVR trngtovr.
         TRNLIMIT trnlimit. TRNKPLMT trnkplmt. TRNNDMOR trnndmor.
         TRNLSEFX trnlsefx. TRNCUTDN trncutdn. TRNCUTEV trncutev.
         TRNEMOPB trnemopb. TRNEMCTD trnemctd. TRNPHLPB trnphlpb.
         TRNPHCTD trnphctd. TRNLSACT trnlsact. TRNSERPB trnserpb.
         TRNPDANG trnpdang. TRNLAWTR trnlawtr. TRNFMFPB trnfmfpb.
         TRNFMCTD trnfmctd. STMLOTTM stmlottm. STMGTOVR stmgtovr.
         STMLIMIT stmlimit. STMKPLMT stmkplmt. STMNDMOR stmndmor.
         STMLSEFX stmlsefx. STMCUTDN stmcutdn. STMCUTEV stmcutev.
         STMCUT1X stmcut1x. STMFLBLU stmflblu. STMWD2SX stmwd2sx.
         STMWDSMT stmwdsmt. STMEMOPB stmemopb. STMEMCTD stmemctd.
         STMPHLPB stmphlpb. STMPHCTD stmphctd. STMLSACT stmlsact.
         STMSERPB stmserpb. STMPDANG stmpdang. STMLAWTR stmlawtr.
         STMFMFPB stmfmfpb. STMFMCTD stmfmctd. SEDLOTTM sedlottm.
         SEDGTOVR sedgtovr. SEDLIMIT sedlimit. SEDKPLMT sedkplmt.
         SEDNDMOR sedndmor. SEDLSEFX sedlsefx. SEDCUTDN sedcutdn.
         SEDCUTEV sedcutev. SEDCUT1X sedcut1x. SEDWD1SX sedwd1sx.
         SEDWDSMT sedwdsmt. SEDEMOPB sedemopb. SEDEMCTD sedemctd.
         SEDPHLPB sedphlpb. SEDPHCTD sedphctd. SEDLSACT sedlsact.
         SEDSERPB sedserpb. SEDPDANG sedpdang. SEDLAWTR sedlawtr.
         SEDFMFPB sedfmfpb. SEDFMCTD sedfmctd. DEPNDALC depndalc.
         DEPNDANL depndanl. DEPNDCIG depndcig. DEPNDCOC depndcoc.
         DEPNDHAL depndhal. DEPNDHER depndher. DEPNDINH depndinh.
         DEPNDMRJ depndmrj. DEPNDSED depndsed. DEPNDSTM depndstm.
         DEPNDTRN depndtrn. DEPNDILL depndill. DEPNDIEM depndiem.
         DEPNDXMJ depndxmj. DEPNDPSY depndpsy. DPILLALC dpillalc.
         DPILANAL dpilanal. ABUSEALC abusealc. ABUSEANL abuseanl.
         ABUSECOC abusecoc. ABUSEHAL abusehal. ABUSEHER abuseher.
         ABUSEINH abuseinh. ABUSEMRJ abusemrj. ABUSESED abusesed.
         ABUSESTM abusestm. ABUSETRN abusetrn. ABUSEILL abuseill.
         ABUSEIEM abuseiem. ABUSEXMJ abusexmj. ABUSEPSY abusepsy.
         ABILLALC abillalc. ABILANAL abilanal. ABODALC abodalc.
         ABODANL abodanl. ABODCOC abodcoc. ABODHAL abodhal.
         ABODHER abodher. ABODINH abodinh. ABODMRJ abodmrj.
         ABODSED abodsed. ABODSTM abodstm. ABODTRN abodtrn.
         ABODILL abodill. ABODPSY abodpsy. ABODILAL abodilal.
         ABDILAAL abdilaal. BOOKED booked. NOBOOKY2 nobookyf.
         BKMVTHFT bkmvthft. BKLARCNY bklarcny. BKBURGL bkburgl.
         BKAGASLT bkagaslt. BKSMASLT bksmaslt. BKROB bkrob.
         BKRAPE bkrape. BKMURDER bkmurder. BKARSON bkarson.
         BKDRVINF bkdrvinf. BKDRUNK bkdrunk. BKPOSTOB bkpostob.
         BKDRUG bkdrug. BKPROS bkpros. BKSEXOFF bksexoff.
         BKFRAUD bkfraud. BKOTH bkoth. BKOTHOF2 bkothoff.
         PROBATON probaton. PAROLREL parolrel. DRVALDR drvaldr.
         DRVAONLY drvaonly. DRVDONLY drvdonly. DRIVALC drivalc.
         DRIVDRG drivdrg. DRIVALD drivald. PAROL parol.
         PROB prob. TXEVER txever. TXYREVER txyrever.
         TXYRADG txyradg. TXYRHOSP txyrhosp. TXYRHPAD txyrhpad.
         TXYRRFIN txyrrfin. TXYRINAD txyrinad. TXYRRFOP txyrrfop.
         TXYRPOAD txyrpoad. TXYRMHC txyrmhc. TXYRMHAD txyrmhad.
         TXYRTXER txyrtxer. TXYRERAD txyrerad. TXYRDOC txyrdoc.
         TXYRDCAD txyrdcad. TXYRJAIL txyrjail. TXYRJLAD txyrjlad.
         TXYRSHG txyrshg. TXYRSGAD txyrsgad. TXYRSOP txyrsop.
         TXYROTS2 txyrotsf. TXYROTAD txyrotad. TXYRVSER txyrvser.
         TXYRNME2 txyrnmef. TXRCVNOW txrcvnow. NDTXNEDR ndtxnedr.
         NDTXMORE ndtxmore. NDTMRALC ndtmralc. NDTMRMJ ndtmrmj.
         NDTMRCOC ndtmrcoc. NDTMRHER ndtmrher. NDTMRHAL ndtmrhal.
         NDTMRINH ndtmrinh. NDTMRANL ndtmranl. NDTMRTRN ndtmrtrn.
         NDTMRSTM ndtmrstm. NDTMRSED ndtmrsed. NDTMROTH ndtmroth.
         NDTXALCR ndtxalcr. NDTXMJR ndtxmjr. NDTXCOCR ndtxcocr.
         NDTXHERR ndtxherr. NDTXHALR ndtxhalr. NDTXINHR ndtxinhr.
         NDTXANLR ndtxanlr. NDTXTRNR ndtxtrnr. NDTXSTMR ndtxstmr.
         NDTXSEDR ndtxsedr. NDTXSODR ndtxsodr. NDTXDG1R ndtxdg1r.
         NDTXDG2R ndtxdg2r. NDTXDG3R ndtxdg3r. NDTXDG4R ndtxdg4r.
         NDTXDG5R ndtxdg5r. NDTXEFTR ndtxeftr. NDTMREFT ndtmreft.
         TXLASREC txlasrec. TXLTYMN2 txltymnf. TXLTYALC txltyalc.
         TXLTYMJ txltymj. TXLTYCOC txltycoc. TXLTYHER txltyher.
         TXLTYHAL txltyhal. TXLTYINH txltyinh. TXLTYANL txltyanl.
         TXLTYTRN txltytrn. TXLTYSTM txltystm. TXLTYSED txltysed.
         TXLTYSOD txltysod. TXLTYOU2 txltyouf. TXLTYDU2 txltyduf.
         TXPYINS txpyins. TXPYCARE txpycare. TXPYCAID txpycaid.
         TXPYPUBP txpypubp. TXPYSAVE txpysave. TXPYFMLY txpyfmly.
         TXPYCORT txpycort. TXPYMILC txpymilc. TXPYEMPL txpyempl.
         TXPYSOS txpysos. TXPYSP2 txpysp2f. TXPYFRE txpyfre.
         TXENROLL txenroll. TXYRDTXO txyrdtxo. SPECTILL spectill.
         SPECTALC spectalc. SPILLALC spillalc. ILLNEED illneed.
         TXNOSPEC txnospec. ALCTRMT alctrmt. ILLTRMT illtrmt.
         TXILLALC txillalc. TXILANAL txilanal. TXLTALC2 txltalcf.
         TXLTANL2 txltanlf. TXLTCOC2 txltcocf. TXLTHAL2 txlthalf.
         TXLTHER2 txltherf. TXLTINH2 txltinhf. TXLTMJ2 txltmj2f.
         TXLTSED2 txltsedf. TXLTSTM2 txltstmf. TXLTTRN2 txlttrnf.
         TXLTILL2 txltillf. TXPINS2 txpins2f. TXPCARE2 txpcaref.
         TXPCAID2 txpcaidf. TXPPUBP2 txppubpf. TXPSAVE2 txpsavef.
         TXPFMLY2 txpfmlyf. TXPCORT2 txpcortf. TXPMILC2 txpmilcf.
         TXPEMPL2 txpemplf. ILLPINS illpins. ILLPCARE illpcare.
         ILLPCAID illpcaid. ILLPPUBP illppubp. ILLPSAVE illpsave.
         ILLPFMLY illpfmly. ILLPCORT illpcort. ILLPMILC illpmilc.
         ILLPEMPL illpempl. ALCPINS alcpins. ALCPCARE alcpcare.
         ALCPCAID alcpcaid. ALCPPUBP alcppubp. ALCPSAVE alcpsave.
         ALCPFMLY alcpfmly. ALCPCORT alcpcort. ALCPMILC alcpmilc.
         ALCPEMPL alcpempl. LOCHOSP lochosp. LOCRFIN locrfin.
         LOCRFOP locrfop. LOCMHC locmhc. LOCTXER loctxer.
         LOCDOC locdoc. LOCJAIL locjail. LOCSHG locshg.
         DRGHOSP drghosp. DRGRFIN drgrfin. DRGRFOP drgrfop.
         DRGMHC drgmhc. DRGTXER drgtxer. DRGDOC drgdoc.
         DRGJAIL drgjail. DRGSHG drgshg. ALCHOSP alchosp.
         ALCRFIN alcrfin. ALCRFOP alcrfop. ALCMHC alcmhc.
         ALCTXER alctxer. ALCDOC alcdoc. ALCJAIL alcjail.
         ALCSHG alcshg. AUINPYR auinpyr. AUINPSYH auinpsyh.
         AUINPGEN auinpgen. AUINMEDU auinmedu. AUINAHSP auinahsp.
         AUINRESD auinresd. AUINSFAC auinsfac. AUNMPSY2 aunmpsyf.
         AUNMPGE2 aunmpgef. AUNMMEDU aunmmedu. AUNMAHSP aunmahsp.
         AUNMRESD aunmresd. AUNMSFA2 aunmsfaf. AUPINSLF aupinslf.
         AUPINOFM aupinofm. AUPINPHI aupinphi. AUPINMCR aupinmcr.
         AUPINMCD aupinmcd. AUPINREH aupinreh. AUPINEMP aupinemp.
         AUPINMIL aupinmil. AUPINPUB aupinpub. AUPINPRV aupinprv.
         AUPINFRE aupinfre. AUPINAMT aupinamt. AUOPTYR auoptyr.
         AUOPMENT auopment. AUOPTHER auopther. AUOPDOC auopdoc.
         AUOPCLNC auopclnc. AUOPDTMT auopdtmt. AUOPOTOP auopotop.
         AUOPYRS2 auopyrsf. AUNMMEN2 aunmmenf. AUNMTHE2 aunmthef.
         AUNMDOC2 aunmdocf. AUNMCLN2 aunmclnf. AUNMDTM2 aunmdtmf.
         AUNMOTO2 aunmotof. AUPOPSLF aupopslf. AUPOPOFM aupopofm.
         AUPOPPHI aupopphi. AUPOPMCR aupopmcr. AUPOPMCD aupopmcd.
         AUPOPREH aupopreh. AUPOPEMP aupopemp. AUPOPMIL aupopmil.
         AUPOPPUB aupoppub. AUPOPPRV aupopprv. AUPOPFRE aupopfre.
         AUPOPMOS aupopmos. AUPOPAMT aupopamt. AURXYR aurxyr.
         AUUNMTYR auunmtyr. AUUNMTRS auunmtrs. AMHINP amhinp.
         AMHOUTP amhoutp. AMHRX amhrx. AMHTXREC amhtxrec.
         AMHTRTND amhtrtnd. SNCRIME sncrime. SNSELLDG snselldg.
         SNPPVAL snppval. SNSTFGT snstfgt. SNEMTBLD snemtbld.
         SNPPHLP snpphlp. SNGRAFTI sngrafti. SNPPVSIT snppvsit.
         SNPPMOVE snppmove. SNMOV5Y2 snmov5yf. SNSPOUSE snspouse.
         SNSPACTV snspactv. SNSPANGR snspangr. SNSPHITU snsphitu.
         SNYHITSP snyhitsp. SNSPCRIT snspcrit. SNSPCONC snspconc.
         SNFRCONC snfrconc. SNFRACTV snfractv. SNFRCARE snfrcare.
         SNYSELL snysell. SNYSTOLE snystole. SNYATTAK snyattak.
         SNFACIG snfacig. SNFAMJEV snfamjev. SNFAALDY snfaaldy.
         SNFAALDV snfaaldv. YECRIME yecrime. YESELLDG yeselldg.
         YEPPHLP yepphlp. YESTFGT yestfgt. YEEMTBLD yeemtbld.
         YEPPVSIT yeppvsit. YEGRAFTI yegrafti. YEPPMOVE yeppmove.
         YEMOV5Y2 yemov5yf. YEENRLYR yeenrlyr. YELSTGRD yelstgrd.
         YEYFGTSW yeyfgtsw. YEYFGTGP yeyfgtgp. YEYHGUN yeyhgun.
         YEYSELL yeysell. YEYSTOLE yeystole. YEYATTAK yeyattak.
         YEPPKCIG yeppkcig. YEPMJEVR yepmjevr. YEPALDLY yepaldly.
         YEGPKCIG yegpkcig. YEGMJEVR yegmjevr. YEGALDLY yegaldly.
         YETLKNON yetlknon. YETLKPAR yetlkpar. YETLKSOP yetlksop.
         YEPRTDNG yeprtdng. YEBIGBRO yebigbro. YEPRBSLV yeprbslv.
         YEVIOPRV yevioprv. YEYMCA yeymca. YESCOUTS yescouts.
         YEPRVLES yeprvles. YEDGPRGP yedgprgp. YETEMSPT yetemspt.
         YE4HCLUB ye4hclub. YESLFHLP yeslfhlp. YEBAND yeband.
         YESCHCLB yeschclb. YEVOLUNT yevolunt. YESTGOVT yestgovt.
         YEPRGSTD yeprgstd. YEJBSKIL yejbskil. YECHOIR yechoir.
         YEDECLAS yedeclas. YEDERGLR yederglr. YEDESPCL yedespcl.
         YEPVNTYR yepvntyr. YECGFRND yecgfrnd. YECGVEND yecgvend.
         YECGMAI2 yecgmaif. YECGCHKO yecgchko. YECGCLRK yecgclrk.
         YECGINET yecginet. YECGSMKT yecgsmkt. YECGDSTO yecgdsto.
         YECGCONV yecgconv. YECGINDV yecgindv. YECGPRUF yecgpruf.
         YECGSUCC yecgsucc. YEPKCRTN yepkcrtn. YEPDPACK yepdpack.
         YEPDCRTN yepdcrtn. YEBLNTEV yeblntev. YEBLNT30 yeblnt3f.
         YEBL30FQ yebl30fq. YECGRWMJ yecgrwmj. NGHCRIM2 nghcrimf.
         NGHSELL2 nghsellf. NGHHELP2 nghhelpf. NGHFGHT2 nghfghtf.
         NGHBLDG2 nghbldgf. NGHVSIT2 nghvsitf. NGHGRAF2 nghgraff.
         NGHMOVE2 nghmovef. MVIN5YR2 mvin5yrf. PRPKCIG2 prpkcigf.
         PRMJEVR2 prmjevrf. PRALDLY2 praldlyf. PRTALK3 prtalk3f.
         YOFIGHT2 yofightf. YOGRPFT2 yogrpftf. YOHGUN2 yohgun2f.
         YOSELL2 yosell2f. YOSTOLE2 yostolef. YOATTAK2 yoattakf.
         YFLPKCG2 yflpkcgf. YFLTMRJ2 yfltmrjf. YFLADLY2 yfladlyf.
         YOUTHACT youthact. PRBSOLV2 prbsolvf. PREVIOL2 previolf.
         PRVDRGO2 prvdrgof. GRPCNSL2 grpcnslf. PREGPGM2 pregpgmf.
         DGSPCLS2 dgspclsf. DGRGCLS2 dgrgclsf. DRGLECT2 drglectf.
         DRPRVME3 drprvmef. ANYEDUC3 anyeducf. CIGFRND cigfrnd.
         CIGVEND cigvend. CIGMAIL cigmail. CIGCKOUT cigckout.
         CIGCLERK cigclerk. CIGINET ciginet. CIGSMKT cigsmkt.
         CIGDSTO cigdsto. CIGCONV cigconv. CIGINDIV cigindiv.
         YTHBGHT ythbght. YMSPGRUP ymspgrup. YMSPFNTP ymspfntp.
         YMSAHOME ymsahome. YMSAACHE ymsaache. YMSABDRM ymsabdrm.
         YMSASLEP ymsaslep. YMSAABDN ymsaabdn. YMSAUPLV ymsauplv.
         YMSAHMSK ymsahmsk. YMAGOHSF ymagohsf. YMAGCRWD ymagcrwd.
         YMAGTRAV ymagtrav. YMAGBRDG ymagbrdg. YMPAATAK ympaatak.
         YMPASUFC ympasufc. YMGAWORY ymgawory. YMGAHDAC ymgahdac.
         YMGAPAIN ymgapain. YMGATNSE ymgatnse. YMPHANML ymphanml.
         YMPHHIGH ymphhigh. YMPHDARK ymphdark. YMPHNEDL ymphnedl.
         YMPHBLOD ymphblod. YMPHBRDG ymphbrdg. YMPHELEV ymphelev.
         YMOCCOUN ymoccoun. YMOCWASH ymocwash. YMOCCHCK ymocchck.
         YMOCGERM ymocgerm. YMOCTHOT ymocthot. YMEATHIN ymeathin.
         YMEAFAT ymeafat. YMEATHFD ymeathfd. YMEABING ymeabing.
         YMELWTBD ymelwtbd. YMELWTPT ymelwtpt. YMELSOIL ymelsoil.
         YMMDNINT ymmdnint. YMMDLSEG ymmdlseg. YMMDNOGD ymmdnogd.
         YMMDTHKL ymmdthkl. YMMDTYKL ymmdtykl. YMMDTIRD ymmdtird.
         YMMDTHNK ymmdthnk. YMMABDMD ymmabdmd. YMMARSLS ymmarsls.
         YMMATALK ymmatalk. YMMASPAB ymmaspab. YMMAMDRC ymmamdrc.
         YMADCONC ymadconc. YMADFRGT ymadfrgt. YMADFCUS ymadfcus.
         YMADMEDS ymadmeds. YMADAVAT ymadavat. YMADERRO ymaderro.
         YMODHURT ymodhurt. YMODRFUS ymodrfus. YMODANOY ymodanoy.
         YMODMEAN ymodmean. YMODBLMO ymodblmo. YMODTANY ymodtany.
         YMODSWOR ymodswor. YMCDEXPL ymcdexpl. YMCDSHPL ymcdshpl.
         YMCDLIED ymcdlied. YMCDSNAT ymcdsnat. YMCDVAND ymcdvand.
         YMCDSTOL ymcdstol. YMCDCRUA ymcdcrua. YMCDBKNT ymcdbknt.
         YUHOSPYR yuhospyr. YUHOSPN2 yuhospnf. YUHOSUIC yuhosuic.
         YUHODEPR yuhodepr. YUHOFEAR yuhofear. YUHOBKRU yuhobkru.
         YUHOEATP yuhoeatp. YUHOSOR yuhosor. YURSIDYR yursidyr.
         YURSIDN2 yursidnf. YURSSUIC yurssuic. YURSDEPR yursdepr.
         YURSFEAR yursfear. YURSBKRU yursbkru. YURSEATP yurseatp.
         YURSSOR yurssor. YUFCARYR yufcaryr. YUFCARN2 yufcarnf.
         YUFCSUIC yufcsuic. YUFCDEPR yufcdepr. YUFCFEAR yufcfear.
         YUFCBKRU yufcbkru. YUFCEATP yufceatp. YUFCSOR yufcsor.
         YUDYTXYR yudytxyr. YUDYTXN2 yudytxnf. YUDYSUIC yudysuic.
         YUDYDEPR yudydepr. YUDYFEAR yudyfear. YUDYBKRU yudybkru.
         YUDYEATP yudyeatp. YUDYSOR yudysor. YUMHCRYR yumhcryr.
         YUMHCRN2 yumhcrnf. YUMHSUIC yumhsuic. YUMHDEPR yumhdepr.
         YUMHFEAR yumhfear. YUMHBKRU yumhbkru. YUMHEATP yumheatp.
         YUMHSOR yumhsor. YUTPSTYR yutpstyr. YUTPSTN2 yutpstnf.
         YUTPSUIC yutpsuic. YUTPDEPR yutpdepr. YUTPFEAR yutpfear.
         YUTPBKRU yutpbkru. YUTPEATP yutpeatp. YUTPSOR yutpsor.
         YUIHTPYR yuihtpyr. YUIHTPN2 yuihtpnf. YUIHSUIC yuihsuic.
         YUIHDEPR yuihdepr. YUIHFEAR yuihfear. YUIHBKRU yuihbkru.
         YUIHEATP yuiheatp. YUIHSOR yuihsor. YUFDOCYR yufdocyr.
         YUFDOCN2 yufdocnf. YUFDSUIC yufdsuic. YUFDDEPR yufddepr.
         YUFDFEAR yufdfear. YUFDBKRU yufdbkru. YUFDEATP yufdeatp.
         YUFDSOR yufdsor. YUSPEDYR yuspedyr. YUSHCNYR yushcnyr.
         YUSHSUIC yushsuic. YUSHDEPR yushdepr. YUSHFEAR yushfear.
         YUSHBKRU yushbkru. YUSHEATP yusheatp. YUSHSOR yushsor.
         YUJAILEV yujailev. YUFCAREV yufcarev. IRHHSIZ2 irhhsizf.
         IIHHSIZ2 iihhsizf. IRHH65_2 irhh65_f. IIHH65_2 iihh65_f.
         IRKI17_2 irki17_f. IIKI17_2 iiki17_f. IMOTHER imother.
         IFATHER ifather. NRCH17_2 nrch17_f. PREGNANT pregnant.
         NMERTMT2 nmertmtf. INHOSPYR inhospyr. NMNGTHS2 nmngthsf.
         PROXANS2 proxansf. PREG preg. PREG2 preg2fff.
         TRIMEST trimest. IRPSOC irpsoc. IIPSOC iipsoc.
         IRFAMSOC irfamsoc. IIFAMSOC iifamsoc. IRPSSI irpssi.
         IIPSSI iipssi. IRFAMSSI irfamssi. IIFAMSSI iifamssi.
         IRFSTAMP irfstamp. IIFSTAMP iifstamp. IRPPMT irppmt.
         IIPPMT iippmt. IRFAMPMT irfampmt. IIFAMPMT iifampmt.
         IRPSVC irpsvc. IIPSVC iipsvc. IRFAMSVC irfamsvc.
         IIFAMSVC iifamsvc. IRWELMOS irwelmos. IIWELMOS iiwelmos.
         IRPINT irpint. IIPINT iipint. IRFAMINT irfamint.
         IIFAMINT iifamint. IRPCHD irpchd. IIPCHD iipchd.
         IRFAMCHD irfamchd. IIFAMCHD iifamchd. IRPWAG irpwag.
         IIPWAG iipwag. IRFAMWAG irfamwag. IIFAMWAG iifamwag.
         IRPOTH irpoth. IIPOTH iipoth. IRFAMOTH irfamoth.
         IIFAMOTH iifamoth. IRPINC3 irpinc3f. IIPINC3 iipinc3f.
         IRFAMIN3 irfaminf. IIFAMIN3 iifaminf. GOVTPROG govtprog.
         HLCALLFG hlcallfg. HLCALL99 hlcall9f. MEDICARE medicare.
         MEDICAID medicaid. CHAMPUS champus. OGOVTINS ogovtins.
         OGOVINS2 ogovinsf. PRVHLTIN prvhltin. GRPHLTIN grphltin.
         HLTINALC hltinalc. HLTINDRG hltindrg. HLTINMNT hltinmnt.
         OTHLTINS othltins. OTHLINS2 othlinsf. HLCNOTYR hlcnotyr.
         HLCNOTMO hlcnotmo. HLCLAST hlclast. HLCPRIVT hlcprivt.
         HLCMCAID hlcmcaid. HLCMILT hlcmilt. HLCMCARE hlcmcare.
         HLCOGOVT hlcogovt. HLCOTHER hlcother. HLCOTHS2 hlcothsf.
         HLLLOSJB hlllosjb. HLLMAJOB hllmajob. HLLMASOR hllmasor.
         HLLCOST hllcost. HLLINELG hllinelg. HLLNOFFR hllnoffr.
         HLLDIVOR hlldivor. HLLDEATH hlldeath. HLLREFUS hllrefus.
         HLLNONED hllnoned. HLLSOR hllsor. HLLSORS2 hllsorsf.
         HLNVCOST hlnvcost. HLNVOFFR hlnvoffr. HLNVREF hlnvref.
         HLNVNEED hlnvneed. HLNVSOR hlnvsor. HLNVSP2 hlnvsp2f.
         IRPINSUR irpinsur. IIPINSUR iipinsur. IRINSUR irinsur.
         IIINSUR iiinsur. IRINSUR2 irinsurf. IIINSUR2 iiinsurf.
         LANGVER langver. QUARTER quarter. GQTYPE gqtype.
         AGE2 age2ffff. NOMARR2 nomarr2f. SERVICE service.
         MILSTAT milstat. HEALTH health. IRSEX irsex.
         IISEX iisex. IRMARIT irmarit. IIMARIT iimarit.
         IREDUC2 ireduc2f. IIEDUC2 iieduc2f. EMPSTAT3 empstatf.
         IIEMPST3 iiempstf. EMPSTATY empstaty. IIEMPSTY iiempsty.
         EMPSTAT4 empsta0f. IIEMPST4 iiemps0f. MOVESPY2 movespyf.
         ENROLED enroled. EDUCNOW2 educnowf. STUDNT studnt.
         SCHDSICK schdsick. SCHDSKIP schdskip. HSDIPLMA hsdiplma.
         HSGED hsged. LFSCHWH2 lfschwhf. LFTSCHA2 lftschaf.
         RLGSVCYR rlgsvcyr. RLGIMPRT rlgimprt. RLGDECSN rlgdecsn.
         RLGFRNDS rlgfrnds. TELNO2 telno2ff. TUCHTONE tuchtone.
         COLLEGE2 collegef. CATAGE catage. CATAG2 catag2ff.
         CATAG3 catag3ff. CATAG7 catag7ff. NEWRACE2 newracef.
         EDUCCAT2 educcatf. JOBSTAT2 jobstatf. JBSTATR2 jbstatrf.
         WRKHAVJB wrkhavjb. WRKHRSWK wrkhrswk. WRKINDU2 wrkinduf.
         WRKOCCU2 wrkoccuf. WRKBZCA2 wrkbzcaf. WRKEFFRT wrkeffrt.
         WRKEDYR wrkedyr. WRKSLFEM wrkslfem. WRKJOBS2 wrkjobsf.
         WRKUNEMP wrkunemp. WRKUNWKS wrkunwks. WRKLASY2 wrklasyf.
         WRKINDY2 wrkindyf. WRKOCCY2 wrkoccyf. WORKDAYS workdays.
         WORKBLAH workblah. LOCSIZE locsize. DRGPLCY drgplcy.
         PLCYCOV plcycov. WKDRGED wkdrged. DRGPRGM drgprgm.
         USALCTST usalctst. USDRGTST usdrgtst. TSTHIRE tsthire.
         TSTRAND tstrand. FIRSTPOS firstpos. WRKHIRE wrkhire.
         WORKRAND workrand. FIEXP99 fiexp99f. PDEN pden.
          ;
*/

RUN ;
