/*-------------------------------------------------------------------------
 |                                                                         
 |                    SAS SETUP FILE FOR 
 |        MENTAL HEALTH CLIENT-LEVEL DATA (MH-CLD) - 2014
 |
 | This SAS program is provided for optional use with the SAS transport
 | version of this data file as distributed. The metadata
 | provided below are not stored in the SAS transport version of this data
 | collection.  Users need to use SAS PROC CIMPORT to import the SAS
 | transport file to a SAS data set on their system. This program can
 | then be used in conjunction with the SAS system data file.
 |
 | DATA:  begins a SAS data step and names an output SAS data set. Users
 | should replace 'SAS-dataset' with their name for the SAS data set copied
 | from the SAS transport file. Users can add a SAS libname statement
 | and an output SAS data set name to make a permanent SAS data set.
 |
 | MISSING VALUE RECODES:  sets user-defined numeric missing values to
 | missing as interpreted by the SAS system. Only variables with
 | user-defined missing values are included in this section.
 |
 | If any variables have more than one missing value, they are assigned
 | to the standard missing value of a single period (.) in the statement
 | below. To maintain the original meaning of missing codes, users may want
 | to take advantage of the SAS missing values (the letters A-Z or an
 | underscore preceded by a period).
 |
 | An example of a standard missing value recode:
 |
 |   IF (RELATION = 98 OR RELATION = 99) THEN RELATION = .;
 |
 | The same example using special missing value recodes:
 |
 |    IF RELATION = 98 THEN RELATION = .A;
 |    IF RELATION = 99 THEN RELATION = .B;
 |
 | NOTE:  Users should modify this file to suit their specific needs.
 | The MISSING VALUE RECODES section has been commented out (i.e., '/*').
 | To make this section active in the program, users should remove the SAS
 | comment indicators from this section.
 |
 |------------------------------------------------------------------------*/

* SAS DATA STEP;
DATA;
SET SAS-dataset ;

* USER-DEFINED MISSING VALUES RECODE TO SAS SYSMIS;

/*
    IF (YEAR  <= -9) THEN YEAR  = .;
    IF (AGE  <= -9) THEN AGE  = .;
    IF (EDUC  <= -9) THEN EDUC  = .;
    IF (ETHNIC  <= -9) THEN ETHNIC  = .;
    IF (RACE  <= -9) THEN RACE  = .;
    IF (GENDER  <= -9) THEN GENDER  = .;
    IF (SPHSERVICE  <= -9) THEN SPHSERVICE  = .;
    IF (CMPSERVICE  <= -9) THEN CMPSERVICE  = .;
    IF (OPISERVICE  <= -9) THEN OPISERVICE  = .;
    IF (RTCSERVICE  <= -9) THEN RTCSERVICE  = .;
    IF (IJSSERVICE  <= -9) THEN IJSSERVICE  = .;
    IF (MH1  <= -9) THEN MH1  = .;
    IF (MH2  <= -9) THEN MH2  = .;
    IF (MH3  <= -9) THEN MH3  = .;
    IF (SUB  <= -9) THEN SUB  = .;
    IF (MARSTAT  <= -9) THEN MARSTAT  = .;
    IF (SMISED  <= -9) THEN SMISED  = .;
    IF (SAP  <= -9) THEN SAP  = .;
    IF (EMPLOY  <= -9) THEN EMPLOY  = .;
    IF (DETNLF  <= -9) THEN DETNLF  = .;
    IF (VETERAN  <= -9) THEN VETERAN  = .;
    IF (LIVARAG  <= -9) THEN LIVARAG  = .;
    IF (NUMMHS  <= -9) THEN NUMMHS  = .;
    IF (TRAUSTREFLG  <= -9) THEN TRAUSTREFLG  = .;
    IF (ANXIETYFLG  <= -9) THEN ANXIETYFLG  = .;
    IF (ADHDFLG  <= -9) THEN ADHDFLG  = .;
    IF (CONDUCTFLG  <= -9) THEN CONDUCTFLG  = .;
    IF (DELIRDEMFLG  <= -9) THEN DELIRDEMFLG  = .;
    IF (BIPOLARFLG  <= -9) THEN BIPOLARFLG  = .;
    IF (DEPRESSFLG  <= -9) THEN DEPRESSFLG  = .;
    IF (ODDFLG  <= -9) THEN ODDFLG  = .;
    IF (PDDFLG  <= -9) THEN PDDFLG  = .;
    IF (PERSONFLG  <= -9) THEN PERSONFLG  = .;
    IF (SCHIZOFLG  <= -9) THEN SCHIZOFLG  = .;
    IF (ALCSUBFLG  <= -9) THEN ALCSUBFLG  = .;
    IF (OTHERDISFLG  <= -9) THEN OTHERDISFLG  = .;
    IF (STATEFIP  <= -9) THEN STATEFIP  = .;
    IF (DIVISION  <= -9) THEN DIVISION  = .;
    IF (REGION  <= -9) THEN REGION  = .;
    IF (CASEID  <= -9) THEN CASEID  = .;
*/

RUN;
