/**************************************************************************
 |                                                                         
 |                    STATA SETUP FILE FOR ICPSR 02834
 |                DRUG ABUSE WARNING NETWORK (DAWN), 1997
 |
 |
 |  Please edit this file as instructed below.
 |  To execute, start Stata, change to the directory containing:
 |       - this do file
 |       - the ASCII data file
 |       - the dictionary file
 |
 |  Then execute the do file (e.g., do 02834-0001-statasetup.do)
 |
 **************************************************************************/

set mem 60m  /* Allocating 60 megabyte(s) of RAM for Stata SE to read the
                 data file into memory. */


set more off  /* This prevents the Stata output viewer from pausing the
                 process */

/****************************************************

Section 1: File Specifications
   This section assigns local macros to the necessary files.
   Please edit:
        "data-filename" ==> The name of data file downloaded from ICPSR
        "dictionary-filename" ==> The name of the dictionary file downloaded.
        "stata-datafile" ==> The name you wish to call your Stata data file.

   Note:  We assume that the raw data, dictionary, and setup (this do file) all
          reside in the same directory (or folder).  If that is not the case
          you will need to include paths as well as filenames in the macros.

********************************************************/

local raw_data "data-filename"
local dict "dictionary-filename"
local outfile "stata-datafile"

/********************************************************

Section 2: Infile Command

This section reads the raw data into Stata format.  If Section 1 was defined
properly, there should be no reason to modify this section.  These macros
should inflate automatically.

**********************************************************/

infile using `dict', using (`raw_data') clear


/*********************************************************

Section 3: Value Label Definitions
This section defines labels for the individual values of each variable.
We suggest that users do not modify this section.\n
**********************************************************/


label data "Drug Abuse Warning Network (DAWN), 1997, Dataset 0001"

#delimit ;
label define MOTIVE    -1 "MISSING" 2 "DEPENDENCE" 3 "SUICIDE" 5 "OTHER"
                       6 "RECREATIONAL USE" 7 "PSYCHO EFFECTS" ;
label define REASON    -2 "NO RESPONSE" -1 "MISSING" 1 "UNEXPECTD REACTN"
                       2 "OVERDOSE" 3 "WITHDRAWL" 4 "CHRONIC EFFECTS"
                       6 "OTHER" 7 "SEEKING DETOXFTN" 8 "ACCIDENT/INJURY" ;
label define DISPOSTN  -1 "MISSING" 1 "TREATED, RELEASE" 2 "ADMITTED"
                       3 "LEFT AGNST ADVIC" 4 "DIED" ;
label define DAWNQTR   1 "FIRST QUARTER" 2 "SECOND QUARTER" 3 "THIRD QUARTER"
                       4 "FOURTH QUARTER" ;
label define DAWNAREA  1 "ATLANTA" 2 "BALTIMORE" 3 "BOSTON" 4 "BUFFALO"
                       5 "CHICAGO" 6 "DALLAS" 7 "DENVER" 8 "DETROIT"
                       9 "LA-LONG BEACH" 10 "MIAMI-HIALEAH"
                       11 "MINNEAPOLIS-ST PAUL" 12 "NEW ORLEANS"
                       13 "NEW YORK" 14 "NEWARK" 15 "PHILADELPHIA"
                       16 "PHOENIX" 17 "ST. LOUIS" 18 "SAN DIEGO"
                       19 "SAN FRANCISCO" 20 "SEATTLE" 21 "WASHINGTON, DC"
                       22 "NATIONAL PANEL" ;
label define AGE       -1 "MISSING" 1 "6-11" 2 "12-17" 3 "18-20" 4 "21-25"
                       5 "26-29" 6 "30-34" 7 "35-44" 8 "45-54"
                       9 "55 AND OVER" ;
label define RACE      -1 "MISSING" 1 "WHITE" 2 "BLACK" 3 "HISPANIC"
                       4 "AMER IND/ALASKN" 5 "OTHER" ;
label define SEX       -1 "MISSING" 1 "MALE" 2 "FEMALE" ;
label define DAY       1 "SUNDAY" 2 "MONDAY" 3 "TUESDAY" 4 "WEDNESDAY"
                       5 "THURSDAY" 6 "FRIDAY" 7 "SATURDAY" ;
label define DRUG01    0 "Did not use ACETAMINOPHEN" 1 "Used ACETAMINOPHEN" ;
label define DRUG02    0 "Did not use ALCOHOL-IN-COMBO"
                       1 "Used ALCOHOL-IN-COMBO" ;
label define DRUG03    0 "Did not use ALPRAZOLAM" 1 "Used ALPRAZOLAM" ;
label define DRUG04    0 "Did not use AMITRIPTYLINE" 1 "Used AMITRIPTYLINE" ;
label define DRUG05    0 "Did not use AMITRIPTYLN COMB"
                       1 "Used AMITRIPTYLN COMB" ;
label define DRUG06    0 "Did not use AMPHETAMINE" 1 "Used AMPHETAMINE" ;
label define DRUG07    0 "Did not use ASPIRIN" 1 "Used ASPIRIN" ;
label define DRUG08    0 "Did not use BUTALBITAL COMBO"
                       1 "Used BUTALBITAL COMBO" ;
label define DRUG09    0 "Did not use CHLORAL HYDRATE"
                       1 "Used CHLORAL HYDRATE" ;
label define DRUG10    0 "Did not use CHLORDIAZEPOXIDE"
                       1 "Used CHLORDIAZEPOXIDE" ;
label define DRUG11    0 "Did not use CHLORPROMAZINE" 1 "Used CHLORPROMAZINE" ;
label define DRUG12    0 "Did not use CLORAZEPATE" 1 "Used CLORAZEPATE" ;
label define DRUG13    0 "Did not use COCAINE" 1 "Used COCAINE" ;
label define DRUG14    0 "Did not use CODEINE" 1 "Used CODEINE" ;
label define DRUG15    0 "Did not use CODEINE COMBO" 1 "Used 1 CODEINE COMBO"
                       2 "Used 2 CODEINE COMBO" ;
label define DRUG16    0 "Did not use d-PROPOXYPHENE" 1 "Used d-PROPOXYPHENE" ;
label define DRUG17    0 "Did not use DESIPRAMINE" 1 "Used DESIPRAMINE" ;
label define DRUG18    0 "Did not use DIAZEPAM" 1 "Used DIAZEPAM" ;
label define DRUG19    0 "Did not use DIPHENHYDRAMINE"
                       1 "Used DIPHENHYDRAMINE" ;
label define DRUG20    0 "Did not use DIPHENYL" 1 "Used DIPHENYLHYDANTO" ;
label define DRUG21    0 "Did not use DOXEPIN" 1 "Used DOXEPIN" ;
label define DRUG22    0 "Did not use ETHCHLORVYNOL" 1 "Used ETHCHLORVYNOL" ;
label define DRUG23    0 "Did not use FLUOXETINE" 1 "Used FLUOXETINE" ;
label define DRUG24    0 "Did not use FLURAZEPAM" 1 "Used FLURAZEPAM" ;
label define DRUG25    0 "Did not use GLUTETHIMIDE" 1 "Used GLUTETHIMIDE" ;
label define DRUG26    0 "Did not use HALOPERIDOL" 1 "Used HALOPERIDOL" ;
label define DRUG27    0 "Did not use HEROIN/MORPHINE"
                       1 "Used HEROIN/MORPHINE" ;
label define DRUG28    0 "Did not use HYDROMORPHONE" 1 "Used HYDROMORPHONE" ;
label define DRUG29    0 "Did not use IMIPRAMINE" 1 "Used IMIPRAMINE" ;
label define DRUG30    0 "Did not use INHLNT/SOLV/AERO"
                       1 "Used 1 INHLNT/SOLV/AERO"
                       2 "Used 2 INHLNT/SOLV/AERO"
                       3 "Used 3 INHLNT/SOLV/AERO"
                       4 "Used 4 INHLNT/SOLV/AERO" ;
label define DRUG31    0 "Did not use LORAZEPAM" 1 "Used LORAZEPAM" ;
label define DRUG32    0 "Did not use LSD" 1 "Used LSD" ;
label define DRUG33    0 "Did not use MARIJUANA/HASHISH"
                       1 "Used MARIJUANA/HASHISH" ;
label define DRUG34    0 "Did not use MEPERIDINE HCL" 1 "Used MEPERIDINE HCL" ;
label define DRUG35    0 "Did not use MEPROBAMATE" 1 "Used MEPROBAMATE" ;
label define DRUG36    0 "Did not use METHADONE" 1 "Used METHADONE" ;
label define DRUG37    0 "Did not use METHAMPHETAMINE"
                       1 "Used METHAMPHETAMINE" ;
label define DRUG38    0 "Did not use METHAQUALONE" 1 "Used METHAQUALONE" ;
label define DRUG39    0 "Did not use METHYLPHENIDATE"
                       1 "Used METHYLPHENIDATE" ;
label define DRUG40    0 "Did not use OTC DIET AIDS" 1 "Used OTC DIET AIDS" ;
label define DRUG41    0 "Did not use OTC SLEEP AIDS" 1 "Used OTC SLEEP AIDS" ;
label define DRUG42    0 "Did not use OXYCODONE" 1 "Used OXYCODONE" ;
label define DRUG43    0 "Did not use PCP/PCP COMBO" 1 "Used PCP/PCP COMBO" ;
label define DRUG44    0 "Did not use PENTAZOCINE" 1 "Used PENTAZOCINE" ;
label define DRUG45    0 "Did not use PENTOBARBITAL" 1 "Used PENTOBARBITAL" ;
label define DRUG46    0 "Did not use PHENOBARBITAL" 1 "Used PHENOBARBITAL" ;
label define DRUG47    0 "Did not use SECOBARBITAL" 1 "Used SECOBARBITAL" ;
label define DRUG48    0 "Did not use SECOBAR" 1 "Used SECOBARBTL/AMOBA" ;
label define DRUG49    0 "Did not use THIORIDAZINE" 1 "Used THIORIDAZINE" ;
label define DRUG50    0 "Did not use TRIFLUOPERAZINE"
                       1 "Used TRIFLUOPERAZINE" ;
label define DRUG51    0 "Did not use DRUG,OTHER CAT"
                       1 "Used 1 DRUG,OTHER CAT" 2 "Used 2 DRUGS, OTHER CAT"
                       3 "Used 3 DRUGS, OTHER CAT"
                       4 "Used 4 DRUGS, OTHER CAT" ;
label define DRUG52    0 "Did not use DRUG, UNKNOWN" 1 "Used 1 DRUG, UNKNOWN"
                       2 "Used 2 DRUGS, UNKNOWN" ;
label define ROUTE01   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE02   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE03   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE04   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE05   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE06   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE07   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE08   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE09   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE10   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE11   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE12   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE13   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE14   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE15   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE16   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE17   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE18   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE19   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE20   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE21   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE22   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE23   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE24   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE25   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE26   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE27   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE28   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE29   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE30   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE31   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE32   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE33   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE34   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE35   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE36   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE37   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE38   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE39   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE40   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE41   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE42   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE43   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE44   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE45   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE46   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE47   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE48   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE49   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE50   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE51   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define ROUTE52   -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "ORAL" 2 "INJECTED" 3 "INHALE"
                       4 "SMOKE" 5 "SNIFF/SNORT" 7 "OTHER" ;
label define FORM01    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 2 "AEROSOL"
                       3 "LIQUID/ORAL" 4 "POWDER" 7 "CIGARETTE" 10 "OTHER" ;
label define FORM02    0 "Did not use drug" 3 "LIQUID/ORAL" ;
label define FORM03    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 2 "AEROSOL" 3 "LIQUID/ORAL"
                       10 "OTHER" 11 "PIECES/CHUNKS" ;
label define FORM04    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 2 "AEROSOL"
                       3 "LIQUID/ORAL" 6 "LIQUID/INJECT" ;
label define FORM05    -1 "MISSING" 0 "Did not use drug" 1 "TABL/CAP/PILL" ;
label define FORM06    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 2 "AEROSOL"
                       3 "LIQUID/ORAL" 4 "POWDER" 6 "LIQUID/INJECT"
                       7 "CIGARETTE" 8 "PLANT MATERIAL" 10 "OTHER"
                       11 "PIECES/CHUNKS" ;
label define FORM07    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 3 "LIQUID/ORAL"
                       4 "POWDER" 10 "OTHER" ;
label define FORM08    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" ;
label define FORM09    -1 "MISSING" 0 "Did not use drug" 1 "TABL/CAP/PILL"
                       3 "LIQUID/ORAL" ;
label define FORM10    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" ;
label define FORM11    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" ;
label define FORM12    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" ;
label define FORM13    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 3 "LIQUID/ORAL"
                       4 "POWDER" 5 "PAPER" 6 "LIQUID/INJECT" 7 "CIGARETTE"
                       8 "PLANT MATERIAL" 10 "OTHER" 11 "PIECES/CHUNKS" ;
label define FORM14    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" 4 "POWDER"
                       6 "LIQUID/INJECT" ;
label define FORM15    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" ;
label define FORM16    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 10 "OTHER" ;
label define FORM17    -1 "MISSING" 0 "Did not use drug" 1 "TABL/CAP/PILL" ;
label define FORM18    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 2 "AEROSOL" 3 "LIQUID/ORAL"
                       6 "LIQUID/INJECT" 8 "PLANT MATERIAL"
                       11 "PIECES/CHUNKS" ;
label define FORM19    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 2 "AEROSOL" 3 "LIQUID/ORAL"
                       6 "LIQUID/INJECT" ;
label define FORM20    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" ;
label define FORM21    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" ;
label define FORM22    -1 "MISSING" 0 "Did not use drug" 1 "TABL/CAP/PILL" ;
label define FORM23    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 2 "AEROSOL" 3 "LIQUID/ORAL"
                       6 "LIQUID/INJECT" ;
label define FORM24    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" ;
label define FORM25    0 "Did not use drug" 1 "TABL/CAP/PILL" ;
label define FORM26    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 2 "AEROSOL" 3 "LIQUID/ORAL"
                       6 "LIQUID/INJECT" ;
label define FORM27    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 2 "AEROSOL"
                       3 "LIQUID/ORAL" 4 "POWDER" 5 "PAPER" 6 "LIQUID/INJECT"
                       7 "CIGARETTE" 8 "PLANT MATERIAL" 10 "OTHER"
                       11 "PIECES/CHUNKS" ;
label define FORM28    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" 6 "LIQUID/INJECT"
                       10 "OTHER" ;
label define FORM29    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" ;
label define FORM30    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 2 "AEROSOL"
                       3 "LIQUID/ORAL" 4 "POWDER" 6 "LIQUID/INJECT"
                       7 "CIGARETTE" 8 "PLANT MATERIAL" 10 "OTHER"
                       11 "PIECES/CHUNKS" ;
label define FORM31    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 2 "AEROSOL"
                       3 "LIQUID/ORAL" ;
label define FORM32    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" 4 "POWDER" 5 "PAPER"
                       7 "CIGARETTE" 8 "PLANT MATERIAL" 10 "OTHER"
                       11 "PIECES/CHUNKS" ;
label define FORM33    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 2 "AEROSOL"
                       3 "LIQUID/ORAL" 4 "POWDER" 5 "PAPER" 6 "LIQUID/INJECT"
                       7 "CIGARETTE" 8 "PLANT MATERIAL" 10 "OTHER"
                       11 "PIECES/CHUNKS" ;
label define FORM34    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" 6 "LIQUID/INJECT"
                       10 "OTHER" ;
label define FORM35    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" ;
label define FORM36    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 2 "AEROSOL" 3 "LIQUID/ORAL"
                       4 "POWDER" 6 "LIQUID/INJECT" 8 "PLANT MATERIAL"
                       10 "OTHER" ;
label define FORM37    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 3 "LIQUID/ORAL"
                       4 "POWDER" 5 "PAPER" 6 "LIQUID/INJECT" 7 "CIGARETTE"
                       8 "PLANT MATERIAL" 10 "OTHER" 11 "PIECES/CHUNKS" ;
label define FORM38    -1 "MISSING" 0 "Did not use drug" 1 "TABL/CAP/PILL"
                       2 "AEROSOL" ;
label define FORM39    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 4 "POWDER" 6 "LIQUID/INJECT" ;
label define FORM40    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" ;
label define FORM41    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 2 "AEROSOL"
                       3 "LIQUID/ORAL" 4 "POWDER" ;
label define FORM42    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 2 "AEROSOL" 3 "LIQUID/ORAL" ;
label define FORM43    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 3 "LIQUID/ORAL"
                       4 "POWDER" 5 "PAPER" 6 "LIQUID/INJECT" 7 "CIGARETTE"
                       8 "PLANT MATERIAL" 10 "OTHER" 11 "PIECES/CHUNKS" ;
label define FORM44    -1 "MISSING" 0 "Did not use drug" 1 "TABL/CAP/PILL" ;
label define FORM45    -1 "MISSING" 0 "Did not use drug" 1 "TABL/CAP/PILL" ;
label define FORM46    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" ;
label define FORM47    -1 "MISSING" 0 "Did not use drug" 1 "TABL/CAP/PILL" ;
label define FORM48    0 "Did not use drug" 1 "TABL/CAP/PILL" ;
label define FORM49    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" 3 "LIQUID/ORAL" ;
label define FORM50    -2 "NO RESPONSE" -1 "MISSING" 0 "Did not use drug"
                       1 "TABL/CAP/PILL" ;
label define FORM51    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 2 "AEROSOL"
                       3 "LIQUID/ORAL" 4 "POWDER" 5 "PAPER" 6 "LIQUID/INJECT"
                       7 "CIGARETTE" 8 "PLANT MATERIAL" 10 "OTHER"
                       11 "PIECES/CHUNKS" ;
label define FORM52    -3 "MULT RESPONSE" -2 "NO RESPONSE" -1 "MISSING"
                       0 "Did not use drug" 1 "TABL/CAP/PILL" 2 "AEROSOL"
                       3 "LIQUID/ORAL" 4 "POWDER" 5 "PAPER" 6 "LIQUID/INJECT"
                       7 "CIGARETTE" 8 "PLANT MATERIAL" 10 "OTHER"
                       11 "PIECES/CHUNKS" ;


#delimit cr


/***************************************************************************

 Section 4: Missing Values

 This section will replace numeric missing values (i.e., -9) with generic
 system missing ".".  By default the code in this section is commented out.
 Users wishing to apply the generic missing values should remove the comment
 at the beginning and end of this section.  Note that Stata allows you to
 specify up to 27 unique missing value codes.

****************************************************************/

/*
replace CASEID = . if (CASEID <= -1 )
replace YEAR = . if (YEAR <= -1 )
replace MOTIVE = . if (MOTIVE <= -1 )
replace REASON = . if (REASON <= -1 )
replace DISPOSTN = . if (DISPOSTN <= -1 )
replace TOTMENS = . if (TOTMENS <= -1 )
replace DAWNQTR = . if (DAWNQTR <= -1 )
replace UNIQMENS = . if (UNIQMENS <= -1 )
replace STRATUM = . if (STRATUM <= -1 )
replace HOSPID = . if (HOSPID <= -1 )
replace FWEIGHT = . if (FWEIGHT <= -1.0000 )
replace DAWNAREA = . if (DAWNAREA <= -1 )
replace AGE = . if (AGE <= -1 )
replace RACE = . if (RACE <= -1 )
replace SEX = . if (SEX <= -1 )
replace DAY = . if (DAY <= -1 )
replace DRUG01 = . if (DRUG01 <= -1 )
replace DRUG02 = . if (DRUG02 <= -1 )
replace DRUG03 = . if (DRUG03 <= -1 )
replace DRUG04 = . if (DRUG04 <= -1 )
replace DRUG05 = . if (DRUG05 <= -1 )
replace DRUG06 = . if (DRUG06 <= -1 )
replace DRUG07 = . if (DRUG07 <= -1 )
replace DRUG08 = . if (DRUG08 <= -1 )
replace DRUG09 = . if (DRUG09 <= -1 )
replace DRUG10 = . if (DRUG10 <= -1 )
replace DRUG11 = . if (DRUG11 <= -1 )
replace DRUG12 = . if (DRUG12 <= -1 )
replace DRUG13 = . if (DRUG13 <= -1 )
replace DRUG14 = . if (DRUG14 <= -1 )
replace DRUG15 = . if (DRUG15 <= -1 )
replace DRUG16 = . if (DRUG16 <= -1 )
replace DRUG17 = . if (DRUG17 <= -1 )
replace DRUG18 = . if (DRUG18 <= -1 )
replace DRUG19 = . if (DRUG19 <= -1 )
replace DRUG20 = . if (DRUG20 <= -1 )
replace DRUG21 = . if (DRUG21 <= -1 )
replace DRUG22 = . if (DRUG22 <= -1 )
replace DRUG23 = . if (DRUG23 <= -1 )
replace DRUG24 = . if (DRUG24 <= -1 )
replace DRUG25 = . if (DRUG25 <= -1 )
replace DRUG26 = . if (DRUG26 <= -1 )
replace DRUG27 = . if (DRUG27 <= -1 )
replace DRUG28 = . if (DRUG28 <= -1 )
replace DRUG29 = . if (DRUG29 <= -1 )
replace DRUG30 = . if (DRUG30 <= -1 )
replace DRUG31 = . if (DRUG31 <= -1 )
replace DRUG32 = . if (DRUG32 <= -1 )
replace DRUG33 = . if (DRUG33 <= -1 )
replace DRUG34 = . if (DRUG34 <= -1 )
replace DRUG35 = . if (DRUG35 <= -1 )
replace DRUG36 = . if (DRUG36 <= -1 )
replace DRUG37 = . if (DRUG37 <= -1 )
replace DRUG38 = . if (DRUG38 <= -1 )
replace DRUG39 = . if (DRUG39 <= -1 )
replace DRUG40 = . if (DRUG40 <= -1 )
replace DRUG41 = . if (DRUG41 <= -1 )
replace DRUG42 = . if (DRUG42 <= -1 )
replace DRUG43 = . if (DRUG43 <= -1 )
replace DRUG44 = . if (DRUG44 <= -1 )
replace DRUG45 = . if (DRUG45 <= -1 )
replace DRUG46 = . if (DRUG46 <= -1 )
replace DRUG47 = . if (DRUG47 <= -1 )
replace DRUG48 = . if (DRUG48 <= -1 )
replace DRUG49 = . if (DRUG49 <= -1 )
replace DRUG50 = . if (DRUG50 <= -1 )
replace DRUG51 = . if (DRUG51 <= -1 )
replace DRUG52 = . if (DRUG52 <= -1 )
replace ROUTE01 = . if (ROUTE01 <= -1 )
replace ROUTE02 = . if (ROUTE02 <= -1 )
replace ROUTE03 = . if (ROUTE03 <= -1 )
replace ROUTE04 = . if (ROUTE04 <= -1 )
replace ROUTE05 = . if (ROUTE05 <= -1 )
replace ROUTE06 = . if (ROUTE06 <= -1 )
replace ROUTE07 = . if (ROUTE07 <= -1 )
replace ROUTE08 = . if (ROUTE08 <= -1 )
replace ROUTE09 = . if (ROUTE09 <= -1 )
replace ROUTE10 = . if (ROUTE10 <= -1 )
replace ROUTE11 = . if (ROUTE11 <= -1 )
replace ROUTE12 = . if (ROUTE12 <= -1 )
replace ROUTE13 = . if (ROUTE13 <= -1 )
replace ROUTE14 = . if (ROUTE14 <= -1 )
replace ROUTE15 = . if (ROUTE15 <= -1 )
replace ROUTE16 = . if (ROUTE16 <= -1 )
replace ROUTE17 = . if (ROUTE17 <= -1 )
replace ROUTE18 = . if (ROUTE18 <= -1 )
replace ROUTE19 = . if (ROUTE19 <= -1 )
replace ROUTE20 = . if (ROUTE20 <= -1 )
replace ROUTE21 = . if (ROUTE21 <= -1 )
replace ROUTE22 = . if (ROUTE22 <= -1 )
replace ROUTE23 = . if (ROUTE23 <= -1 )
replace ROUTE24 = . if (ROUTE24 <= -1 )
replace ROUTE25 = . if (ROUTE25 <= -1 )
replace ROUTE26 = . if (ROUTE26 <= -1 )
replace ROUTE27 = . if (ROUTE27 <= -1 )
replace ROUTE28 = . if (ROUTE28 <= -1 )
replace ROUTE29 = . if (ROUTE29 <= -1 )
replace ROUTE30 = . if (ROUTE30 <= -1 )
replace ROUTE31 = . if (ROUTE31 <= -1 )
replace ROUTE32 = . if (ROUTE32 <= -1 )
replace ROUTE33 = . if (ROUTE33 <= -1 )
replace ROUTE34 = . if (ROUTE34 <= -1 )
replace ROUTE35 = . if (ROUTE35 <= -1 )
replace ROUTE36 = . if (ROUTE36 <= -1 )
replace ROUTE37 = . if (ROUTE37 <= -1 )
replace ROUTE38 = . if (ROUTE38 <= -1 )
replace ROUTE39 = . if (ROUTE39 <= -1 )
replace ROUTE40 = . if (ROUTE40 <= -1 )
replace ROUTE41 = . if (ROUTE41 <= -1 )
replace ROUTE42 = . if (ROUTE42 <= -1 )
replace ROUTE43 = . if (ROUTE43 <= -1 )
replace ROUTE44 = . if (ROUTE44 <= -1 )
replace ROUTE45 = . if (ROUTE45 <= -1 )
replace ROUTE46 = . if (ROUTE46 <= -1 )
replace ROUTE47 = . if (ROUTE47 <= -1 )
replace ROUTE48 = . if (ROUTE48 <= -1 )
replace ROUTE49 = . if (ROUTE49 <= -1 )
replace ROUTE50 = . if (ROUTE50 <= -1 )
replace ROUTE51 = . if (ROUTE51 <= -1 )
replace ROUTE52 = . if (ROUTE52 <= -1 )
replace FORM01 = . if (FORM01 <= -1 )
replace FORM02 = . if (FORM02 <= -1 )
replace FORM03 = . if (FORM03 <= -1 )
replace FORM04 = . if (FORM04 <= -1 )
replace FORM05 = . if (FORM05 <= -1 )
replace FORM06 = . if (FORM06 <= -1 )
replace FORM07 = . if (FORM07 <= -1 )
replace FORM08 = . if (FORM08 <= -1 )
replace FORM09 = . if (FORM09 <= -1 )
replace FORM10 = . if (FORM10 <= -1 )
replace FORM11 = . if (FORM11 <= -1 )
replace FORM12 = . if (FORM12 <= -1 )
replace FORM13 = . if (FORM13 <= -1 )
replace FORM14 = . if (FORM14 <= -1 )
replace FORM15 = . if (FORM15 <= -1 )
replace FORM16 = . if (FORM16 <= -1 )
replace FORM17 = . if (FORM17 <= -1 )
replace FORM18 = . if (FORM18 <= -1 )
replace FORM19 = . if (FORM19 <= -1 )
replace FORM20 = . if (FORM20 <= -1 )
replace FORM21 = . if (FORM21 <= -1 )
replace FORM22 = . if (FORM22 <= -1 )
replace FORM23 = . if (FORM23 <= -1 )
replace FORM24 = . if (FORM24 <= -1 )
replace FORM25 = . if (FORM25 <= -1 )
replace FORM26 = . if (FORM26 <= -1 )
replace FORM27 = . if (FORM27 <= -1 )
replace FORM28 = . if (FORM28 <= -1 )
replace FORM29 = . if (FORM29 <= -1 )
replace FORM30 = . if (FORM30 <= -1 )
replace FORM31 = . if (FORM31 <= -1 )
replace FORM32 = . if (FORM32 <= -1 )
replace FORM33 = . if (FORM33 <= -1 )
replace FORM34 = . if (FORM34 <= -1 )
replace FORM35 = . if (FORM35 <= -1 )
replace FORM36 = . if (FORM36 <= -1 )
replace FORM37 = . if (FORM37 <= -1 )
replace FORM38 = . if (FORM38 <= -1 )
replace FORM39 = . if (FORM39 <= -1 )
replace FORM40 = . if (FORM40 <= -1 )
replace FORM41 = . if (FORM41 <= -1 )
replace FORM42 = . if (FORM42 <= -1 )
replace FORM43 = . if (FORM43 <= -1 )
replace FORM44 = . if (FORM44 <= -1 )
replace FORM45 = . if (FORM45 <= -1 )
replace FORM46 = . if (FORM46 <= -1 )
replace FORM47 = . if (FORM47 <= -1 )
replace FORM48 = . if (FORM48 <= -1 )
replace FORM49 = . if (FORM49 <= -1 )
replace FORM50 = . if (FORM50 <= -1 )
replace FORM51 = . if (FORM51 <= -1 )
replace FORM52 = . if (FORM52 <= -1 )


*/
/********************************************************************

 Section 5: Save Outfile

  This section saves out a Stata system format file.  There is no reason to
  modify it if the macros in Section 1 were specified correctly.

*********************************************************************/

save `outfile', replace

