*-------------------------------------------------------------------------*
*                                                                          
*                     SPSS SETUP FILE FOR ICPSR 02834
*                 DRUG ABUSE WARNING NETWORK (DAWN), 1997
* 
*
*  SPSS setup sections are provided for the ASCII version of this data
*  collection.  These sections are listed below:
*
*  DATA LIST:  assigns the name, type, decimal specification (if any),
*  and specifies the beginning and ending column locations for each
*  variable in the data file. Users must replace the "data-filename"
*  in the DATA LIST statement with a filename specifying the directory
*  on the user's computer system in which the downloaded and unzipped
*  data file is physically located (e.g., "c:\temp\02834-0001-data.txt").
*
*  VARIABLE LABELS:  assigns descriptive labels to all variables.
*  Labels and variable names may be identical for some data files.
*
*  MISSING VALUES: declares user-defined missing values. Not all
*  variables in this data set necessarily have user-defined missing
*  values. These values can be treated specially in data transformations,
*  statistical calculations, and case selection.
*
*  VALUE LABELS: assigns descriptive labels to codes found in the data
*  file.  Not all codes necessarily have assigned value labels.
*
*  NOTE:  Users should modify this setup file to suit their specific 
*  needs. The MISSING VALUES section has been commented out (i.e., '*').
*  To include the MISSING VALUES section in the final SPSS setup, remove 
*  the comment indicators from the desired section.
*
*  CREATING A PERMANENT SPSS DATA FILE: If users wish to create and save
*  an SPSS data file for further analysis using SPSS for Windows, the
*  necessary "SAVE OUTFILE" command is provided in the last line of
*  this file.  To activate the command, users must delete the leading
*  asterisk (*) and replace "spss-filename" with a filename specifying
*  the location on the user's computer system to which the new data file
*  will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\da02834-0001.sav").
*
*-------------------------------------------------------------------------.

* SPSS FILE HANDLE AND DATA LIST COMMANDS.

FILE HANDLE DATA / NAME="data-filename" LRECL=296.
DATA LIST FILE=DATA /
              CASEID 1-6                YEAR 7-8             MOTIVE 9-10
            REASON 11-12          DISPOSTN 13-14              TOTMENS 15
              DAWNQTR 16             UNIQMENS 17              STRATUM 18
            HOSPID 19-26       FWEIGHT 27-33 (4)          DAWNAREA 34-35
               AGE 36-37              RACE 38-39               SEX 40-41
                  DAY 42               DRUG01 43               DRUG02 44
               DRUG03 45               DRUG04 46               DRUG05 47
               DRUG06 48               DRUG07 49               DRUG08 50
               DRUG09 51               DRUG10 52               DRUG11 53
               DRUG12 54               DRUG13 55               DRUG14 56
               DRUG15 57               DRUG16 58               DRUG17 59
               DRUG18 60               DRUG19 61               DRUG20 62
               DRUG21 63               DRUG22 64               DRUG23 65
               DRUG24 66               DRUG25 67               DRUG26 68
               DRUG27 69               DRUG28 70               DRUG29 71
               DRUG30 72               DRUG31 73               DRUG32 74
               DRUG33 75               DRUG34 76               DRUG35 77
               DRUG36 78               DRUG37 79               DRUG38 80
               DRUG39 81               DRUG40 82               DRUG41 83
               DRUG42 84               DRUG43 85               DRUG44 86
               DRUG45 87               DRUG46 88               DRUG47 89
               DRUG48 90               DRUG49 91               DRUG50 92
               DRUG51 93               DRUG52 94           ROUTE01 95-96
              ROUTE02 97           ROUTE03 98-99         ROUTE04 100-101
         ROUTE05 102-103         ROUTE06 104-105         ROUTE07 106-107
         ROUTE08 108-109         ROUTE09 110-111         ROUTE10 112-113
         ROUTE11 114-115         ROUTE12 116-117         ROUTE13 118-119
         ROUTE14 120-121         ROUTE15 122-123         ROUTE16 124-125
         ROUTE17 126-127         ROUTE18 128-129         ROUTE19 130-131
         ROUTE20 132-133         ROUTE21 134-135         ROUTE22 136-137
         ROUTE23 138-139         ROUTE24 140-141             ROUTE25 142
         ROUTE26 143-144         ROUTE27 145-146         ROUTE28 147-148
         ROUTE29 149-150         ROUTE30 151-152         ROUTE31 153-154
         ROUTE32 155-156         ROUTE33 157-158         ROUTE34 159-160
         ROUTE35 161-162         ROUTE36 163-164         ROUTE37 165-166
         ROUTE38 167-168         ROUTE39 169-170         ROUTE40 171-172
         ROUTE41 173-174         ROUTE42 175-176         ROUTE43 177-178
         ROUTE44 179-180         ROUTE45 181-182         ROUTE46 183-184
         ROUTE47 185-186             ROUTE48 187         ROUTE49 188-189
         ROUTE50 190-191         ROUTE51 192-193         ROUTE52 194-195
          FORM01 196-197              FORM02 198          FORM03 199-200
          FORM04 201-202          FORM05 203-204          FORM06 205-206
          FORM07 207-208          FORM08 209-210          FORM09 211-212
          FORM10 213-214          FORM11 215-216          FORM12 217-218
          FORM13 219-220          FORM14 221-222          FORM15 223-224
          FORM16 225-226          FORM17 227-228          FORM18 229-230
          FORM19 231-232          FORM20 233-234          FORM21 235-236
          FORM22 237-238          FORM23 239-240          FORM24 241-242
              FORM25 243          FORM26 244-245          FORM27 246-247
          FORM28 248-249          FORM29 250-251          FORM30 252-253
          FORM31 254-255          FORM32 256-257          FORM33 258-259
          FORM34 260-261          FORM35 262-263          FORM36 264-265
          FORM37 266-267          FORM38 268-269          FORM39 270-271
          FORM40 272-273          FORM41 274-275          FORM42 276-277
          FORM43 278-279          FORM44 280-281          FORM45 282-283
          FORM46 284-285          FORM47 286-287              FORM48 288
          FORM49 289-290          FORM50 291-292          FORM51 293-294
          FORM52 295-296
   .

* SPSS VARIABLE LABELS COMMAND.

VARIABLE LABELS
   CASEID    'Unique identifier for each episode' /
   YEAR      'YEAR EPISODE OCCURRED' /
   MOTIVE    'DRUG USE MOTIVE' /
   REASON    'REASON FOR ER VISIT' /
   DISPOSTN  'PATIENT DISPOSITION' /
   TOTMENS   'TOTAL MENTIONS IN EPISODE (W/ DUPS)' /
   DAWNQTR   'ABSOLUTE QUARTER NUMBER IN DAWN' /
   UNIQMENS  'UNIQUE MENTIONS IN EPISODE (S/ DUPS)' /
   STRATUM   'Modified stratum' /
   HOSPID    'Unique identifier for each hospital' /
   FWEIGHT   'Episode weight' /
   DAWNAREA  'NEW SAMPLE PMSA CODE' /
   AGE       'AGE OF PATIENT' /
   RACE      'PATIENT RACE/ETHNICITY' /
   SEX       'SEX OF PATIENT' /
   DAY       'Day of the week' /
   DRUG01    'ACETAMINOPHEN' /
   DRUG02    'ALCOHOL-IN-COMBO' /
   DRUG03    'ALPRAZOLAM' /
   DRUG04    'AMITRIPTYLINE' /
   DRUG05    'AMITRIPTYLN COMB' /
   DRUG06    'AMPHETAMINE' /
   DRUG07    'ASPIRIN' /
   DRUG08    'BUTALBITAL COMBO' /
   DRUG09    'CHLORAL HYDRATE' /
   DRUG10    'CHLORDIAZEPOXIDE' /
   DRUG11    'CHLORPROMAZINE' /
   DRUG12    'CLORAZEPATE' /
   DRUG13    'COCAINE' /
   DRUG14    'CODEINE' /
   DRUG15    'CODEINE COMBO' /
   DRUG16    'd-PROPOXYPHENE' /
   DRUG17    'DESIPRAMINE' /
   DRUG18    'DIAZEPAM' /
   DRUG19    'DIPHENHYDRAMINE' /
   DRUG20    'DIPHENYLHYDANTOIN SODIUM' /
   DRUG21    'DOXEPIN' /
   DRUG22    'ETHCHLORVYNOL' /
   DRUG23    'FLUOXETINE' /
   DRUG24    'FLURAZEPAM' /
   DRUG25    'GLUTETHIMIDE' /
   DRUG26    'HALOPERIDOL' /
   DRUG27    'HEROIN/MORPHINE' /
   DRUG28    'HYDROMORPHONE' /
   DRUG29    'IMIPRAMINE' /
   DRUG30    'INHLNT/SOL/AER' /
   DRUG31    'LORAZEPAM' /
   DRUG32    'LSD' /
   DRUG33    'MARIJUANA/HASHISH' /
   DRUG34    'MEPERIDINE HCL' /
   DRUG35    'MEPROBAMATE' /
   DRUG36    'METHADONE' /
   DRUG37    'METHAMPHETAMINE' /
   DRUG38    'METHAQUALONE' /
   DRUG39    'METHYLPHENIDATE' /
   DRUG40    'OTC DIET AIDS' /
   DRUG41    'OTC SLEEP AIDS' /
   DRUG42    'OXYCODONE' /
   DRUG43    'PCP/PCP COMBO' /
   DRUG44    'PENTAZOCINE' /
   DRUG45    'PENTOBARBITAL' /
   DRUG46    'PHENOBARBITAL' /
   DRUG47    'SECOBARBITAL' /
   DRUG48    'SECOBARBTL/AMOBARBITAL' /
   DRUG49    'THIORIDAZINE' /
   DRUG50    'TRIFLUOPERAZINE' /
   DRUG51    'DRUGS, OTH CAT' /
   DRUG52    'DRUGS, UNKNOWN' /
   ROUTE01   'Route for ACETAMINOPHEN' /
   ROUTE02   'Route for ALCOHOL-IN-COMBO' /
   ROUTE03   'Route for ALPRAZOLAM' /
   ROUTE04   'Route for AMITRIPTYLINE' /
   ROUTE05   'Route for AMITRIPTYLN COMB' /
   ROUTE06   'Route for AMPHETAMINE' /
   ROUTE07   'Route for ASPIRIN' /
   ROUTE08   'Route for BUTALBITAL COMBO' /
   ROUTE09   'Route for CHLORAL HYDRATE' /
   ROUTE10   'Route for CHLORDIAZEPOXIDE' /
   ROUTE11   'Route for CHLORPROMAZINE' /
   ROUTE12   'Route for CLORAZEPATE' /
   ROUTE13   'Route for COCAINE' /
   ROUTE14   'Route for CODEINE' /
   ROUTE15   'Route for CODEINE COMBO' /
   ROUTE16   'Route for d-PROPOXYPHENE' /
   ROUTE17   'Route for DESIPRAMINE' /
   ROUTE18   'Route for DIAZEPAM' /
   ROUTE19   'Route for DIPHENHYDRAMINE' /
   ROUTE20   'Route for DIPHENYLHYDANTOIN SODIUM' /
   ROUTE21   'Route for DOXEPIN' /
   ROUTE22   'Route for ETHCHLORVYNOL' /
   ROUTE23   'Route for FLUOXETINE' /
   ROUTE24   'Route for FLURAZEPAM' /
   ROUTE25   'Route for GLUTETHIMIDE' /
   ROUTE26   'Route for HALOPERIDOL' /
   ROUTE27   'Route for HEROIN/MORPHINE' /
   ROUTE28   'Route for HYDROMORPHONE' /
   ROUTE29   'Route for IMIPRAMINE' /
   ROUTE30   'Route for INHLNT/SOL/AER' /
   ROUTE31   'Route for LORAZEPAM' /
   ROUTE32   'Route for LSD' /
   ROUTE33   'Route for MARIJUANA/HASHISH' /
   ROUTE34   'Route for MEPERIDINE HCL' /
   ROUTE35   'Route for MEPROBAMATE' /
   ROUTE36   'Route for METHADONE' /
   ROUTE37   'Route for METHAMPHETAMINE' /
   ROUTE38   'Route for METHAQUALONE' /
   ROUTE39   'Route for METHYLPHENIDATE' /
   ROUTE40   'Route for OTC DIET AIDS' /
   ROUTE41   'Route for OTC SLEEP AIDS' /
   ROUTE42   'Route for OXYCODONE' /
   ROUTE43   'Route for PCP/PCP COMBO' /
   ROUTE44   'Route for PENTAZOCINE' /
   ROUTE45   'Route for PENTOBARBITAL' /
   ROUTE46   'Route for PHENOBARBITAL' /
   ROUTE47   'Route for SECOBARBITAL' /
   ROUTE48   'Route for SECOBARBTL/AMOBARBITAL' /
   ROUTE49   'Route for THIORIDAZINE' /
   ROUTE50   'Route for TRIFLUOPERAZINE' /
   ROUTE51   'Route for DRUGS in OTH CAT' /
   ROUTE52   'Route for DRUGS, UNKNOWN' /
   FORM01    'Form of ACETAMINOPHEN' /
   FORM02    'Form of ALCOHOL-IN-COMBO' /
   FORM03    'Form of ALPRAZOLAM' /
   FORM04    'Form of AMITRIPTYLINE' /
   FORM05    'Form of AMITRIPTYLN COMB' /
   FORM06    'Form of AMPHETAMINE' /
   FORM07    'Form of ASPIRIN' /
   FORM08    'Form of BUTALBITAL COMBO' /
   FORM09    'Form of CHLORAL HYDRATE' /
   FORM10    'Form of CHLORDIAZEPOXIDE' /
   FORM11    'Form of CHLORPROMAZINE' /
   FORM12    'Form of CLORAZEPATE' /
   FORM13    'Form of COCAINE' /
   FORM14    'Form of CODEINE' /
   FORM15    'Form of CODEINE COMBO' /
   FORM16    'Form of d-PROPOXYPHENE' /
   FORM17    'Form of DESIPRAMINE' /
   FORM18    'Form of DIAZEPAM' /
   FORM19    'Form of DIPHENHYDRAMINE' /
   FORM20    'Form of DIPHENYLHYDANTOIN SODIUM' /
   FORM21    'Form of DOXEPIN' /
   FORM22    'Form of ETHCHLORVYNOL' /
   FORM23    'Form of FLUOXETINE' /
   FORM24    'Form of FLURAZEPAM' /
   FORM25    'Form of GLUTETHIMIDE' /
   FORM26    'Form of HALOPERIDOL' /
   FORM27    'Form of HEROIN/MORPHINE' /
   FORM28    'Form of HYDROMORPHONE' /
   FORM29    'Form of IMIPRAMINE' /
   FORM30    'Form of INHLNT/SOL/AER' /
   FORM31    'Form of LORAZEPAM' /
   FORM32    'Form of LSD' /
   FORM33    'Form of MARIJUANA/HASHISH' /
   FORM34    'Form of MEPERIDINE HCL' /
   FORM35    'Form of MEPROBAMATE' /
   FORM36    'Form of METHADONE' /
   FORM37    'Form of METHAMPHETAMINE' /
   FORM38    'Form of METHAQUALONE' /
   FORM39    'Form of METHYLPHENIDATE' /
   FORM40    'Form of OTC DIET AIDS' /
   FORM41    'Form of OTC SLEEP AIDS' /
   FORM42    'Form of OXYCODONE' /
   FORM43    'Form of PCP/PCP COMBO' /
   FORM44    'Form of PENTAZOCINE' /
   FORM45    'Form of PENTOBARBITAL' /
   FORM46    'Form of PHENOBARBITAL' /
   FORM47    'Form of SECOBARBITAL' /
   FORM48    'Form of SECOBARBTL/AMOBARBITAL' /
   FORM49    'Form of THIORIDAZINE' /
   FORM50    'Form of TRIFLUOPERAZINE' /
   FORM51    'Form of DRUGS in OTH CAT' /
   FORM52    'Form of DRUGS, UNKNOWN' /
   .


* SPSS VALUE LABELS COMMAND.

VALUE LABELS
   MOTIVE    -1 'MISSING' 2 'DEPENDENCE' 3 'SUICIDE' 5 'OTHER'
             6 'RECREATIONAL USE' 7 'PSYCHO EFFECTS' /
   REASON    -2 'NO RESPONSE' -1 'MISSING' 1 'UNEXPECTD REACTN' 2 'OVERDOSE'
             3 'WITHDRAWL' 4 'CHRONIC EFFECTS' 6 'OTHER' 7 'SEEKING DETOXFTN'
             8 'ACCIDENT/INJURY' /
   DISPOSTN  -1 'MISSING' 1 'TREATED, RELEASE' 2 'ADMITTED'
             3 'LEFT AGNST ADVIC' 4 'DIED' /
   DAWNQTR   1 'FIRST QUARTER' 2 'SECOND QUARTER' 3 'THIRD QUARTER'
             4 'FOURTH QUARTER' /
   DAWNAREA  1 'ATLANTA' 2 'BALTIMORE' 3 'BOSTON' 4 'BUFFALO' 5 'CHICAGO'
             6 'DALLAS' 7 'DENVER' 8 'DETROIT' 9 'LA-LONG BEACH'
             10 'MIAMI-HIALEAH' 11 'MINNEAPOLIS-ST PAUL' 12 'NEW ORLEANS'
             13 'NEW YORK' 14 'NEWARK' 15 'PHILADELPHIA' 16 'PHOENIX'
             17 'ST. LOUIS' 18 'SAN DIEGO' 19 'SAN FRANCISCO' 20 'SEATTLE'
             21 'WASHINGTON, DC' 22 'NATIONAL PANEL' /
   AGE       -1 'MISSING' 1 '6-11' 2 '12-17' 3 '18-20' 4 '21-25' 5 '26-29'
             6 '30-34' 7 '35-44' 8 '45-54' 9 '55 AND OVER' /
   RACE      -1 'MISSING' 1 'WHITE' 2 'BLACK' 3 'HISPANIC'
             4 'AMER IND/ALASKN' 5 'OTHER' /
   SEX       -1 'MISSING' 1 'MALE' 2 'FEMALE' /
   DAY       1 'SUNDAY' 2 'MONDAY' 3 'TUESDAY' 4 'WEDNESDAY' 5 'THURSDAY'
             6 'FRIDAY' 7 'SATURDAY' /
   DRUG01    0 'Did not use ACETAMINOPHEN' 1 'Used ACETAMINOPHEN' /
   DRUG02    0 'Did not use ALCOHOL-IN-COMBO' 1 'Used ALCOHOL-IN-COMBO' /
   DRUG03    0 'Did not use ALPRAZOLAM' 1 'Used ALPRAZOLAM' /
   DRUG04    0 'Did not use AMITRIPTYLINE' 1 'Used AMITRIPTYLINE' /
   DRUG05    0 'Did not use AMITRIPTYLN COMB' 1 'Used AMITRIPTYLN COMB' /
   DRUG06    0 'Did not use AMPHETAMINE' 1 'Used AMPHETAMINE' /
   DRUG07    0 'Did not use ASPIRIN' 1 'Used ASPIRIN' /
   DRUG08    0 'Did not use BUTALBITAL COMBO' 1 'Used BUTALBITAL COMBO' /
   DRUG09    0 'Did not use CHLORAL HYDRATE' 1 'Used CHLORAL HYDRATE' /
   DRUG10    0 'Did not use CHLORDIAZEPOXIDE' 1 'Used CHLORDIAZEPOXIDE' /
   DRUG11    0 'Did not use CHLORPROMAZINE' 1 'Used CHLORPROMAZINE' /
   DRUG12    0 'Did not use CLORAZEPATE' 1 'Used CLORAZEPATE' /
   DRUG13    0 'Did not use COCAINE' 1 'Used COCAINE' /
   DRUG14    0 'Did not use CODEINE' 1 'Used CODEINE' /
   DRUG15    0 'Did not use CODEINE COMBO' 1 'Used 1 CODEINE COMBO'
             2 'Used 2 CODEINE COMBO' /
   DRUG16    0 'Did not use d-PROPOXYPHENE' 1 'Used d-PROPOXYPHENE' /
   DRUG17    0 'Did not use DESIPRAMINE' 1 'Used DESIPRAMINE' /
   DRUG18    0 'Did not use DIAZEPAM' 1 'Used DIAZEPAM' /
   DRUG19    0 'Did not use DIPHENHYDRAMINE' 1 'Used DIPHENHYDRAMINE' /
   DRUG20    0 'Did not use DIPHENYL' 1 'Used DIPHENYLHYDANTO' /
   DRUG21    0 'Did not use DOXEPIN' 1 'Used DOXEPIN' /
   DRUG22    0 'Did not use ETHCHLORVYNOL' 1 'Used ETHCHLORVYNOL' /
   DRUG23    0 'Did not use FLUOXETINE' 1 'Used FLUOXETINE' /
   DRUG24    0 'Did not use FLURAZEPAM' 1 'Used FLURAZEPAM' /
   DRUG25    0 'Did not use GLUTETHIMIDE' 1 'Used GLUTETHIMIDE' /
   DRUG26    0 'Did not use HALOPERIDOL' 1 'Used HALOPERIDOL' /
   DRUG27    0 'Did not use HEROIN/MORPHINE' 1 'Used HEROIN/MORPHINE' /
   DRUG28    0 'Did not use HYDROMORPHONE' 1 'Used HYDROMORPHONE' /
   DRUG29    0 'Did not use IMIPRAMINE' 1 'Used IMIPRAMINE' /
   DRUG30    0 'Did not use INHLNT/SOLV/AERO' 1 'Used 1 INHLNT/SOLV/AERO'
             2 'Used 2 INHLNT/SOLV/AERO' 3 'Used 3 INHLNT/SOLV/AERO'
             4 'Used 4 INHLNT/SOLV/AERO' /
   DRUG31    0 'Did not use LORAZEPAM' 1 'Used LORAZEPAM' /
   DRUG32    0 'Did not use LSD' 1 'Used LSD' /
   DRUG33    0 'Did not use MARIJUANA/HASHISH' 1 'Used MARIJUANA/HASHISH' /
   DRUG34    0 'Did not use MEPERIDINE HCL' 1 'Used MEPERIDINE HCL' /
   DRUG35    0 'Did not use MEPROBAMATE' 1 'Used MEPROBAMATE' /
   DRUG36    0 'Did not use METHADONE' 1 'Used METHADONE' /
   DRUG37    0 'Did not use METHAMPHETAMINE' 1 'Used METHAMPHETAMINE' /
   DRUG38    0 'Did not use METHAQUALONE' 1 'Used METHAQUALONE' /
   DRUG39    0 'Did not use METHYLPHENIDATE' 1 'Used METHYLPHENIDATE' /
   DRUG40    0 'Did not use OTC DIET AIDS' 1 'Used OTC DIET AIDS' /
   DRUG41    0 'Did not use OTC SLEEP AIDS' 1 'Used OTC SLEEP AIDS' /
   DRUG42    0 'Did not use OXYCODONE' 1 'Used OXYCODONE' /
   DRUG43    0 'Did not use PCP/PCP COMBO' 1 'Used PCP/PCP COMBO' /
   DRUG44    0 'Did not use PENTAZOCINE' 1 'Used PENTAZOCINE' /
   DRUG45    0 'Did not use PENTOBARBITAL' 1 'Used PENTOBARBITAL' /
   DRUG46    0 'Did not use PHENOBARBITAL' 1 'Used PHENOBARBITAL' /
   DRUG47    0 'Did not use SECOBARBITAL' 1 'Used SECOBARBITAL' /
   DRUG48    0 'Did not use SECOBAR' 1 'Used SECOBARBTL/AMOBA' /
   DRUG49    0 'Did not use THIORIDAZINE' 1 'Used THIORIDAZINE' /
   DRUG50    0 'Did not use TRIFLUOPERAZINE' 1 'Used TRIFLUOPERAZINE' /
   DRUG51    0 'Did not use DRUG,OTHER CAT' 1 'Used 1 DRUG,OTHER CAT'
             2 'Used 2 DRUGS, OTHER CAT' 3 'Used 3 DRUGS, OTHER CAT'
             4 'Used 4 DRUGS, OTHER CAT' /
   DRUG52    0 'Did not use DRUG, UNKNOWN' 1 'Used 1 DRUG, UNKNOWN'
             2 'Used 2 DRUGS, UNKNOWN' /
   ROUTE01   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE02   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE03   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE04   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE05   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE06   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE07   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE08   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE09   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE10   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE11   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE12   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE13   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE14   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE15   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE16   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE17   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE18   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE19   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE20   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE21   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE22   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE23   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE24   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE25   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE26   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE27   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE28   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE29   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE30   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE31   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE32   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE33   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE34   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE35   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE36   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE37   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE38   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE39   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE40   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE41   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE42   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE43   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE44   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE45   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE46   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE47   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE48   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE49   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE50   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE51   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE52   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   FORM01    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 7 'CIGARETTE' 10 'OTHER' /
   FORM02    0 'Did not use drug' 3 'LIQUID/ORAL' /
   FORM03    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' 10 'OTHER'
             11 'PIECES/CHUNKS' /
   FORM04    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 6 'LIQUID/INJECT' /
   FORM05    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM06    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 6 'LIQUID/INJECT' 7 'CIGARETTE'
             8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM07    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL'
             4 'POWDER' 10 'OTHER' /
   FORM08    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM09    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL'
             3 'LIQUID/ORAL' /
   FORM10    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM11    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM12    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM13    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL'
             4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT' 7 'CIGARETTE'
             8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM14    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' 4 'POWDER' 6 'LIQUID/INJECT' /
   FORM15    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM16    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 10 'OTHER' /
   FORM17    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM18    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' 6 'LIQUID/INJECT'
             8 'PLANT MATERIAL' 11 'PIECES/CHUNKS' /
   FORM19    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' 6 'LIQUID/INJECT'
             /
   FORM20    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM21    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM22    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM23    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' 6 'LIQUID/INJECT'
             /
   FORM24    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM25    0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM26    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' 6 'LIQUID/INJECT'
             /
   FORM27    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT'
             7 'CIGARETTE' 8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM28    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' 6 'LIQUID/INJECT' 10 'OTHER' /
   FORM29    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM30    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 6 'LIQUID/INJECT' 7 'CIGARETTE'
             8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM31    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' /
   FORM32    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' 4 'POWDER' 5 'PAPER'
             7 'CIGARETTE' 8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM33    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT'
             7 'CIGARETTE' 8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM34    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' 6 'LIQUID/INJECT' 10 'OTHER' /
   FORM35    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM36    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' 4 'POWDER'
             6 'LIQUID/INJECT' 8 'PLANT MATERIAL' 10 'OTHER' /
   FORM37    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL'
             4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT' 7 'CIGARETTE'
             8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM38    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             /
   FORM39    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 4 'POWDER' 6 'LIQUID/INJECT' /
   FORM40    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM41    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' /
   FORM42    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' /
   FORM43    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL'
             4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT' 7 'CIGARETTE'
             8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM44    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM45    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM46    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM47    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM48    0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM49    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM50    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM51    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT'
             7 'CIGARETTE' 8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM52    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT'
             7 'CIGARETTE' 8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   .

* SPSS MISSING VALUES COMMAND.

* MISSING VALUES
     CASEID
     YEAR
     MOTIVE
     REASON
     DISPOSTN
     TOTMENS
     DAWNQTR
     UNIQMENS
     STRATUM
     HOSPID
     DAWNAREA
     AGE
     RACE
     SEX
     DAY
     DRUG01
     DRUG02
     DRUG03
     DRUG04
     DRUG05
     DRUG06
     DRUG07
     DRUG08
     DRUG09
     DRUG10
     DRUG11
     DRUG12
     DRUG13
     DRUG14
     DRUG15
     DRUG16
     DRUG17
     DRUG18
     DRUG19
     DRUG20
     DRUG21
     DRUG22
     DRUG23
     DRUG24
     DRUG25
     DRUG26
     DRUG27
     DRUG28
     DRUG29
     DRUG30
     DRUG31
     DRUG32
     DRUG33
     DRUG34
     DRUG35
     DRUG36
     DRUG37
     DRUG38
     DRUG39
     DRUG40
     DRUG41
     DRUG42
     DRUG43
     DRUG44
     DRUG45
     DRUG46
     DRUG47
     DRUG48
     DRUG49
     DRUG50
     DRUG51
     DRUG52
     ROUTE01
     ROUTE02
     ROUTE03
     ROUTE04
     ROUTE05
     ROUTE06
     ROUTE07
     ROUTE08
     ROUTE09
     ROUTE10
     ROUTE11
     ROUTE12
     ROUTE13
     ROUTE14
     ROUTE15
     ROUTE16
     ROUTE17
     ROUTE18
     ROUTE19
     ROUTE20
     ROUTE21
     ROUTE22
     ROUTE23
     ROUTE24
     ROUTE25
     ROUTE26
     ROUTE27
     ROUTE28
     ROUTE29
     ROUTE30
     ROUTE31
     ROUTE32
     ROUTE33
     ROUTE34
     ROUTE35
     ROUTE36
     ROUTE37
     ROUTE38
     ROUTE39
     ROUTE40
     ROUTE41
     ROUTE42
     ROUTE43
     ROUTE44
     ROUTE45
     ROUTE46
     ROUTE47
     ROUTE48
     ROUTE49
     ROUTE50
     ROUTE51
     ROUTE52
     FORM01
     FORM02
     FORM03
     FORM04
     FORM05
     FORM06
     FORM07
     FORM08
     FORM09
     FORM10
     FORM11
     FORM12
     FORM13
     FORM14
     FORM15
     FORM16
     FORM17
     FORM18
     FORM19
     FORM20
     FORM21
     FORM22
     FORM23
     FORM24
     FORM25
     FORM26
     FORM27
     FORM28
     FORM29
     FORM30
     FORM31
     FORM32
     FORM33
     FORM34
     FORM35
     FORM36
     FORM37
     FORM38
     FORM39
     FORM40
     FORM41
     FORM42
     FORM43
     FORM44
     FORM45
     FORM46
     FORM47
     FORM48
     FORM49
     FORM50
     FORM51
     FORM52 (LO THRU -1) /
     FWEIGHT (LO THRU -1.0000) /
   .

EXECUTE.

* Create SPSS system file.

*SAVE OUTFILE="spss-filename.sav".
