/*-------------------------------------------------------------------------
 |                                                                         
 |             SAS SUPPLEMENTAL SYNTAX FILE FOR ICPSR 02756
 |                DRUG ABUSE WARNING NETWORK (DAWN), 1994
 |
 | This SAS program is provided for optional use with the SAS transport
 | version of this data file as distributed by ICPSR. The metadata
 | provided below are not stored in the SAS transport version of this data
 | collection.  Users need to use SAS PROC CIMPORT to import the SAS
 | transport file to a SAS data set on their system. This program can
 | then be used in conjunction with the SAS system data file.
 |
 | PROC FORMAT:  creates user-defined formats for the variables. Formats
 | replace original value codes with value code descriptions.  Only
 | variables with user-defined formats are included in this section.
 |
 | DATA:  begins a SAS data step and names an output SAS data set. Users
 | should replace "SAS-dataset" with their name for the SAS data set copied
 | from the SAS transport file. Users can add a SAS libname statement
 | and an output SAS data set name to make a permanent SAS data set.
 |
 | MISSING VALUE RECODES:  sets user-defined numeric missing values to
 | missing as interpreted by the SAS system. Only variables with
 | user-defined missing values are included in this section.
 |
 | If any variables have more than one missing value, they are assigned
 | to the standard missing value of a single period (.) in the statement
 | below. To maintain the original meaning of missing codes, users may want
 | to take advantage of the SAS missing values (the letters A-Z or an
 | underscore preceded by a period).
 |
 | An example of a standard missing value recode:
 |
 |   IF (RELATION = 98 OR RELATION = 99) THEN RELATION = .;
 |
 | The same example using special missing value recodes:
 |
 |    IF RELATION = 98 THEN RELATION = .A;
 |    IF RELATION = 99 THEN RELATION = .B;
 |
 | FORMAT:  associates the formats created by the PROC FORMAT step with
 | the variables stored in the SAS data set. Users can refer to their
 | SAS manual for information on how to permanently store formats in a
 | SAS catalog.
 |
 | NOTE:  Users should modify this file to suit their specific needs.
 | The MISSING VALUE RECODES section has been commented out (i.e., '/*').
 | To make this section active in the program, users should remove the SAS
 | comment indicators from this section.
 |
 |------------------------------------------------------------------------*/

* SAS PROC FORMAT;

PROC FORMAT;
  VALUE motive    -1='(-1) MISSING' 2='(2) DEPENDENCE' 3='(3) SUICIDE' 5='(5) OTHER'
                  6='(6) RECREATIONAL USE' 7='(7) PSYCHO EFFECTS' ;
  VALUE reason    -2='(-2) NO RESPONSE' -1='(-1) MISSING' 1='(1) UNEXPECTD REACTN'
                  2='(2) OVERDOSE' 3='(3) WITHDRAWL' 4='(4) CHRONIC EFFECTS' 6='(6) OTHER'
                  7='(7) SEEKING DETOXFTN' 8='(8) ACCIDENT/INJURY' ;
  VALUE dispostn  -1='(-1) MISSING' 1='(1) TREATED, RELEASE' 2='(2) ADMITTED'
                  3='(3) LEFT AGNST ADVIC' 4='(4) DIED' ;
  VALUE dawnqtr   1='(1) FIRST QUARTER' 2='(2) SECOND QUARTER' 3='(3) THIRD QUARTER'
                  4='(4) FOURTH QUARTER' ;
  VALUE dawnarea  1='(1) ATLANTA' 2='(2) BALTIMORE' 3='(3) BOSTON' 4='(4) BUFFALO'
                  5='(5) CHICAGO' 6='(6) DALLAS' 7='(7) DENVER' 8='(8) DETROIT'
                  9='(9) LA-LONG BEACH' 10='(10) MIAMI-HIALEAH'
                  11='(11) MINNEAPOLIS-ST PAUL' 12='(12) NEW ORLEANS' 13='(13) NEW YORK'
                  14='(14) NEWARK' 15='(15) PHILADELPHIA' 16='(16) PHOENIX' 17='(17) ST. LOUIS'
                  18='(18) SAN DIEGO' 19='(19) SAN FRANCISCO' 20='(20) SEATTLE'
                  21='(21) WASHINGTON, DC' 22='(22) NATIONAL PANEL' ;
  VALUE age       -1='(-1) MISSING' 1='(1) 6-11' 2='(2) 12-17' 3='(3) 18-20' 4='(4) 21-25'
                  5='(5) 26-29' 6='(6) 30-34' 7='(7) 35-44' 8='(8) 45-54' 9='(9) 55 AND OVER' ;
  VALUE race      -1='(-1) MISSING' 1='(1) WHITE' 2='(2) BLACK' 3='(3) HISPANIC'
                  4='(4) AMER IND/ALASKN' 5='(5) OTHER' ;
  VALUE sex       -1='(-1) MISSING' 1='(1) MALE' 2='(2) FEMALE' ;
  VALUE drug01ff  0='(0) Did not use ACETAMINOPHEN' 1='(1) Used ACETAMINOPHEN' ;
  VALUE drug02ff  0='(0) Did not use ALCOHOL-IN-COMBO' 1='(1) Used ALCOHOL-IN-COMBO' ;
  VALUE drug03ff  0='(0) Did not use ALPRAZOLAM' 1='(1) Used ALPRAZOLAM' ;
  VALUE drug04ff  0='(0) Did not use AMITRIPTYLINE' 1='(1) Used AMITRIPTYLINE' ;
  VALUE drug05ff  0='(0) Did not use AMITRIPTYLN COMB' 1='(1) Used AMITRIPTYLN COMB' ;
  VALUE drug06ff  0='(0) Did not use AMPHETAMINE' 1='(1) Used AMPHETAMINE' ;
  VALUE drug07ff  0='(0) Did not use ASPIRIN' 1='(1) Used ASPIRIN' ;
  VALUE drug08ff  0='(0) Did not use BUTALBITAL COMBO' 1='(1) Used BUTALBITAL COMBO' ;
  VALUE drug09ff  0='(0) Did not use CHLORAL HYDRATE' 1='(1) Used CHLORAL HYDRATE' ;
  VALUE drug10ff  0='(0) Did not use CHLORDIAZEPOXIDE' 1='(1) Used CHLORDIAZEPOXIDE' ;
  VALUE drug11ff  0='(0) Did not use CHLORPROMAZINE' 1='(1) Used CHLORPROMAZINE' ;
  VALUE drug12ff  0='(0) Did not use CLORAZEPATE' 1='(1) Used CLORAZEPATE' ;
  VALUE drug13ff  0='(0) Did not use COCAINE' 1='(1) Used COCAINE' ;
  VALUE drug14ff  0='(0) Did not use CODEINE' 1='(1) Used CODEINE' ;
  VALUE drug15ff  0='(0) Did not use CODEINE COMBO' 1='(1) Used 1 CODEINE COMBO'
                  2='(2) Used 2 CODEINE COMBO' ;
  VALUE drug16ff  0='(0) Did not use d-PROPOXYPHENE' 1='(1) Used d-PROPOXYPHENE' ;
  VALUE drug17ff  0='(0) Did not use DESIPRAMINE' 1='(1) Used DESIPRAMINE' ;
  VALUE drug18ff  0='(0) Did not use DIAZEPAM' 1='(1) Used DIAZEPAM' ;
  VALUE drug19ff  0='(0) Did not use DIPHENHYDRAMINE' 1='(1) Used DIPHENHYDRAMINE' ;
  VALUE drug20ff  0='(0) Did not use DIPHENYLHYDANTOIN SODIUM'
                  1='(1) Used DIPHENYLHYDANTOIN SODIUM' ;
  VALUE drug21ff  0='(0) Did not use DOXEPIN' 1='(1) Used DOXEPIN' ;
  VALUE drug22ff  0='(0) Did not use ETHCHLORVYNOL' 1='(1) Used ETHCHLORVYNOL' ;
  VALUE drug23ff  0='(0) Did not use FLUOXETINE' 1='(1) Used FLUOXETINE' ;
  VALUE drug24ff  0='(0) Did not use FLURAZEPAM' 1='(1) Used FLURAZEPAM' ;
  VALUE drug25ff  0='(0) Did not use GLUTETHIMIDE' 1='(1) Used GLUTETHIMIDE' ;
  VALUE drug26ff  0='(0) Did not use HALOPERIDOL' 1='(1) Used HALOPERIDOL' ;
  VALUE drug27ff  0='(0) Did not use HEROIN/MORPHINE' 1='(1) Used HEROIN/MORPHINE' ;
  VALUE drug28ff  0='(0) Did not use HYDROMORPHONE' 1='(1) Used HYDROMORPHONE' ;
  VALUE drug29ff  0='(0) Did not use IMIPRAMINE' 1='(1) Used IMIPRAMINE' ;
  VALUE drug30ff  0='(0) Did not use INHLNT/SOLV/AERO'
                  1='(1) Used 1 INHLNT/SOLV/AERO' 2='(2) Used 2 INHLNT/SOLV/AERO' ;
  VALUE drug31ff  0='(0) Did not use LORAZEPAM' 1='(1) Used LORAZEPAM' ;
  VALUE drug32ff  0='(0) Did not use LSD' 1='(1) Used LSD' ;
  VALUE drug33ff  0='(0) Did not use MARIJUANA/HASHISH'
                  1='(1) Used MARIJUANA/HASHISH' ;
  VALUE drug34ff  0='(0) Did not use MEPERIDINE HCL' 1='(1) Used MEPERIDINE HCL' ;
  VALUE drug35ff  0='(0) Did not use MEPROBAMATE' 1='(1) Used MEPROBAMATE' ;
  VALUE drug36ff  0='(0) Did not use METHADONE' 1='(1) Used METHADONE' ;
  VALUE drug37ff  0='(0) Did not use METHAMPHETAMINE' 1='(1) Used METHAMPHETAMINE' ;
  VALUE drug38ff  0='(0) Did not use METHAQUALONE' 1='(1) Used METHAQUALONE' ;
  VALUE drug39ff  0='(0) Did not use METHYLPHENIDATE' 1='(1) Used METHYLPHENIDATE' ;
  VALUE drug40ff  0='(0) Did not use OTC DIET AIDS' 1='(1) Used OTC DIET AIDS' ;
  VALUE drug41ff  0='(0) Did not use OTC SLEEP AIDS' 1='(1) Used OTC SLEEP AIDS' ;
  VALUE drug42ff  0='(0) Did not use OXYCODONE' 1='(1) Used OXYCODONE' ;
  VALUE drug43ff  0='(0) Did not use PCP/PCP COMBO' 1='(1) Used PCP/PCP COMBO' ;
  VALUE drug44ff  0='(0) Did not use PENTAZOCINE' 1='(1) Used PENTAZOCINE' ;
  VALUE drug45ff  0='(0) Did not use PENTOBARBITAL' 1='(1) Used PENTOBARBITAL' ;
  VALUE drug46ff  0='(0) Did not use PHENOBARBITAL' 1='(1) Used PHENOBARBITAL' ;
  VALUE drug47ff  0='(0) Did not use SECOBARBITAL' 1='(1) Used SECOBARBITAL' ;
  VALUE drug48ff  0='(0) Did not use SECOBARBTL/AMOBARBITAL'
                  1='(1) Used SECOBARBTL/AMOBARBITAL' ;
  VALUE drug49ff  0='(0) Did not use THIORIDAZINE' 1='(1) Used THIORIDAZINE' ;
  VALUE drug50ff  0='(0) Did not use TRIFLUOPERAZINE' 1='(1) Used TRIFLUOPERAZINE' ;
  VALUE drug51ff  0='(0) Did not use DRUG,OTHER CAT' 1='(1) Used 1 DRUG,OTHER CAT'
                  2='(2) Used 2 DRUGS, OTHER CAT' 3='(3) Used 3 DRUGS, OTHER CAT'
                  4='(4) Used 4 DRUGS, OTHER CAT' ;
  VALUE drug52ff  0='(0) Did not use DRUG, UNKNOWN' 1='(1) Used 1 DRUG, UNKNOWN'
                  2='(2) Used 2 DRUGS, UNKNOWN' ;
  VALUE form01ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  3='(3) LIQUID/ORAL' 4='(4) POWDER' 6='(6) LIQUID/INJECT'
                  8='(8) PLANT MATERIAL' 11='(11) PIECES/CHUNKS' ;
  VALUE form02ff  0='(0) Did not use drug' 3='(3) LIQUID/ORAL' ;
  VALUE form03ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' 2='(2) AEROSOL' 3='(3) LIQUID/ORAL' 4='(4) POWDER'
                  11='(11) PIECES/CHUNKS' ;
  VALUE form04ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  4='(4) POWDER' 8='(8) PLANT MATERIAL' ;
  VALUE form05ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' ;
  VALUE form06ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  3='(3) LIQUID/ORAL' 4='(4) POWDER' 6='(6) LIQUID/INJECT' 7='(7) CIGARETTE'
                  8='(8) PLANT MATERIAL' 10='(10) OTHER' 11='(11) PIECES/CHUNKS' ;
  VALUE form07ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  3='(3) LIQUID/ORAL' 4='(4) POWDER' 5='(5) PAPER' 10='(10) OTHER' ;
  VALUE form08ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 3='(3) LIQUID/ORAL' ;
  VALUE form09ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' 3='(3) LIQUID/ORAL' ;
  VALUE form10ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 3='(3) LIQUID/ORAL' ;
  VALUE form11ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' 3='(3) LIQUID/ORAL' 4='(4) POWDER' ;
  VALUE form12ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' ;
  VALUE form13ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  3='(3) LIQUID/ORAL' 4='(4) POWDER' 5='(5) PAPER' 6='(6) LIQUID/INJECT'
                  7='(7) CIGARETTE' 8='(8) PLANT MATERIAL' 10='(10) OTHER'
                  11='(11) PIECES/CHUNKS' ;
  VALUE form14ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' 2='(2) AEROSOL' 3='(3) LIQUID/ORAL' 4='(4) POWDER'
                  6='(6) LIQUID/INJECT' 11='(11) PIECES/CHUNKS' ;
  VALUE form15ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 3='(3) LIQUID/ORAL' ;
  VALUE form16ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' ;
  VALUE form17ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 8='(8) PLANT MATERIAL'
                  10='(10) OTHER' ;
  VALUE form18ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  3='(3) LIQUID/ORAL' 4='(4) POWDER' 6='(6) LIQUID/INJECT' 7='(7) CIGARETTE' ;
  VALUE form19ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 3='(3) LIQUID/ORAL'
                  6='(6) LIQUID/INJECT' 10='(10) OTHER' ;
  VALUE form20ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' 2='(2) AEROSOL' 3='(3) LIQUID/ORAL' ;
  VALUE form21ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' ;
  VALUE form22ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' 4='(4) POWDER' ;
  VALUE form23ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' ;
  VALUE form24ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' ;
  VALUE form25ff  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' ;
  VALUE form26ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' 2='(2) AEROSOL' 3='(3) LIQUID/ORAL' ;
  VALUE form27ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  3='(3) LIQUID/ORAL' 4='(4) POWDER' 5='(5) PAPER' 6='(6) LIQUID/INJECT'
                  7='(7) CIGARETTE' 8='(8) PLANT MATERIAL' 10='(10) OTHER'
                  11='(11) PIECES/CHUNKS' ;
  VALUE form28ff  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) TABL/CAP/PILL'
                  6='(6) LIQUID/INJECT' ;
  VALUE form29ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' ;
  VALUE form30ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  3='(3) LIQUID/ORAL' 4='(4) POWDER' 6='(6) LIQUID/INJECT'
                  8='(8) PLANT MATERIAL' 10='(10) OTHER' ;
  VALUE form31ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  4='(4) POWDER' ;
  VALUE form32ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' 2='(2) AEROSOL' 3='(3) LIQUID/ORAL' 4='(4) POWDER'
                  5='(5) PAPER' 6='(6) LIQUID/INJECT' 7='(7) CIGARETTE'
                  8='(8) PLANT MATERIAL' 10='(10) OTHER' 11='(11) PIECES/CHUNKS' ;
  VALUE form33ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  3='(3) LIQUID/ORAL' 4='(4) POWDER' 5='(5) PAPER' 6='(6) LIQUID/INJECT'
                  7='(7) CIGARETTE' 8='(8) PLANT MATERIAL' 10='(10) OTHER'
                  11='(11) PIECES/CHUNKS' ;
  VALUE form34ff  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) TABL/CAP/PILL'
                  2='(2) AEROSOL' 3='(3) LIQUID/ORAL' 6='(6) LIQUID/INJECT' ;
  VALUE form35ff  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' ;
  VALUE form36ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' 2='(2) AEROSOL' 3='(3) LIQUID/ORAL' 4='(4) POWDER'
                  5='(5) PAPER' 6='(6) LIQUID/INJECT' 8='(8) PLANT MATERIAL' 10='(10) OTHER'
                  11='(11) PIECES/CHUNKS' ;
  VALUE form37ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 3='(3) LIQUID/ORAL'
                  4='(4) POWDER' 5='(5) PAPER' 6='(6) LIQUID/INJECT' 7='(7) CIGARETTE'
                  8='(8) PLANT MATERIAL' 10='(10) OTHER' 11='(11) PIECES/CHUNKS' ;
  VALUE form38ff  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' ;
  VALUE form39ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' 6='(6) LIQUID/INJECT' ;
  VALUE form40ff  -3='(-3) MULT RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' ;
  VALUE form41ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 3='(3) LIQUID/ORAL' ;
  VALUE form42ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' ;
  VALUE form43ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 3='(3) LIQUID/ORAL'
                  4='(4) POWDER' 5='(5) PAPER' 6='(6) LIQUID/INJECT' 7='(7) CIGARETTE'
                  8='(8) PLANT MATERIAL' 10='(10) OTHER' 11='(11) PIECES/CHUNKS' ;
  VALUE form44ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' ;
  VALUE form45ff  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) TABL/CAP/PILL'
                  6='(6) LIQUID/INJECT' 10='(10) OTHER' ;
  VALUE form46ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' 2='(2) AEROSOL' 3='(3) LIQUID/ORAL'
                  6='(6) LIQUID/INJECT' ;
  VALUE form47ff  -3='(-3) MULT RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' ;
  VALUE form48ff  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' ;
  VALUE form49ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  3='(3) LIQUID/ORAL' 6='(6) LIQUID/INJECT' ;
  VALUE form50ff  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) TABL/CAP/PILL' ;
  VALUE form51ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  3='(3) LIQUID/ORAL' 4='(4) POWDER' 5='(5) PAPER' 6='(6) LIQUID/INJECT'
                  7='(7) CIGARETTE' 8='(8) PLANT MATERIAL' 10='(10) OTHER'
                  11='(11) PIECES/CHUNKS' ;
  VALUE form52ff  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) TABL/CAP/PILL' 2='(2) AEROSOL'
                  3='(3) LIQUID/ORAL' 4='(4) POWDER' 5='(5) PAPER' 6='(6) LIQUID/INJECT'
                  7='(7) CIGARETTE' 8='(8) PLANT MATERIAL' 10='(10) OTHER'
                  11='(11) PIECES/CHUNKS' ;
  VALUE route01f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 4='(4) SMOKE'
                  5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE route02f  0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route03f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  2='(2) INJECTED' 4='(4) SMOKE' ;
  VALUE route04f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 5='(5) SNIFF/SNORT' ;
  VALUE route05f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route06f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE'
                  4='(4) SMOKE' 5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE route07f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE'
                  4='(4) SMOKE' 7='(7) OTHER' ;
  VALUE route08f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route09f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  2='(2) INJECTED' ;
  VALUE route10f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route11f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  5='(5) SNIFF/SNORT' ;
  VALUE route12f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  2='(2) INJECTED' ;
  VALUE route13f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE'
                  4='(4) SMOKE' 5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE route14f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  2='(2) INJECTED' 4='(4) SMOKE' 5='(5) SNIFF/SNORT' ;
  VALUE route15f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' ;
  VALUE route16f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 4='(4) SMOKE' ;
  VALUE route17f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  7='(7) OTHER' ;
  VALUE route18f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 4='(4) SMOKE'
                  5='(5) SNIFF/SNORT' ;
  VALUE route19f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE' ;
  VALUE route20f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  2='(2) INJECTED' 7='(7) OTHER' ;
  VALUE route21f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route22f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  2='(2) INJECTED' ;
  VALUE route23f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 5='(5) SNIFF/SNORT' ;
  VALUE route24f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route25f  0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route26f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  2='(2) INJECTED' 5='(5) SNIFF/SNORT' ;
  VALUE route27f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE'
                  4='(4) SMOKE' 5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE route28f  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' ;
  VALUE route29f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route30f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE'
                  4='(4) SMOKE' 5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE route31f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' ;
  VALUE route32f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  2='(2) INJECTED' 3='(3) INHALE' 4='(4) SMOKE' 5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE route33f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE'
                  4='(4) SMOKE' 5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE route34f  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' ;
  VALUE route35f  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route36f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  2='(2) INJECTED' 3='(3) INHALE' 4='(4) SMOKE' 5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE route37f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE'
                  4='(4) SMOKE' 5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE route38f  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route39f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  2='(2) INJECTED' 5='(5) SNIFF/SNORT' ;
  VALUE route40f  -3='(-3) MULT RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) ORAL' ;
  VALUE route41f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' ;
  VALUE route42f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 5='(5) SNIFF/SNORT' ;
  VALUE route43f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE'
                  4='(4) SMOKE' 5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE route44f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route45f  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED'
                  7='(7) OTHER' ;
  VALUE route46f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL'
                  2='(2) INJECTED' ;
  VALUE route47f  -3='(-3) MULT RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug'
                  1='(1) ORAL' ;
  VALUE route48f  -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route49f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE' ;
  VALUE route50f  -2='(-2) NO RESPONSE' -1='(-1) MISSING' 0='(0) Did not use drug' 1='(1) ORAL' ;
  VALUE route51f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE'
                  4='(4) SMOKE' 5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE route52f  -3='(-3) MULT RESPONSE' -2='(-2) NO RESPONSE' -1='(-1) MISSING'
                  0='(0) Did not use drug' 1='(1) ORAL' 2='(2) INJECTED' 3='(3) INHALE'
                  4='(4) SMOKE' 5='(5) SNIFF/SNORT' 7='(7) OTHER' ;
  VALUE dayfffff  1='(1) SUNDAY' 2='(2) MONDAY' 3='(3) TUESDAY' 4='(4) WEDNESDAY'
                  5='(5) THURSDAY' 6='(6) FRIDAY' 7='(7) SATURDAY' ;
RUN;

* SAS DATA STEP;
DATA;
SET SAS-dataset ;


* USER-DEFINED MISSING VALUES RECODE TO SAS SYSMIS;

/*
   IF (CASEID <= -1) THEN CASEID = .;
   IF (YEAR <= -1) THEN YEAR = .;
   IF (MOTIVE <= -1) THEN MOTIVE = .;
   IF (REASON <= -1) THEN REASON = .;
   IF (DISPOSTN <= -1) THEN DISPOSTN = .;
   IF (TOTMENS <= -1) THEN TOTMENS = .;
   IF (DAWNQTR <= -1) THEN DAWNQTR = .;
   IF (UNIQMENS <= -1) THEN UNIQMENS = .;
   IF (STRATUM <= -1) THEN STRATUM = .;
   IF (HOSPID <= -1) THEN HOSPID = .;
   IF (FWEIGHT <= -1.0000) THEN FWEIGHT = .;
   IF (DAWNAREA <= -1) THEN DAWNAREA = .;
   IF (AGE <= -1) THEN AGE = .;
   IF (RACE <= -1) THEN RACE = .;
   IF (SEX <= -1) THEN SEX = .;
   IF (DRUG01 <= -1) THEN DRUG01 = .;
   IF (DRUG02 <= -1) THEN DRUG02 = .;
   IF (DRUG03 <= -1) THEN DRUG03 = .;
   IF (DRUG04 <= -1) THEN DRUG04 = .;
   IF (DRUG05 <= -1) THEN DRUG05 = .;
   IF (DRUG06 <= -1) THEN DRUG06 = .;
   IF (DRUG07 <= -1) THEN DRUG07 = .;
   IF (DRUG08 <= -1) THEN DRUG08 = .;
   IF (DRUG09 <= -1) THEN DRUG09 = .;
   IF (DRUG10 <= -1) THEN DRUG10 = .;
   IF (DRUG11 <= -1) THEN DRUG11 = .;
   IF (DRUG12 <= -1) THEN DRUG12 = .;
   IF (DRUG13 <= -1) THEN DRUG13 = .;
   IF (DRUG14 <= -1) THEN DRUG14 = .;
   IF (DRUG15 <= -1) THEN DRUG15 = .;
   IF (DRUG16 <= -1) THEN DRUG16 = .;
   IF (DRUG17 <= -1) THEN DRUG17 = .;
   IF (DRUG18 <= -1) THEN DRUG18 = .;
   IF (DRUG19 <= -1) THEN DRUG19 = .;
   IF (DRUG20 <= -1) THEN DRUG20 = .;
   IF (DRUG21 <= -1) THEN DRUG21 = .;
   IF (DRUG22 <= -1) THEN DRUG22 = .;
   IF (DRUG23 <= -1) THEN DRUG23 = .;
   IF (DRUG24 <= -1) THEN DRUG24 = .;
   IF (DRUG25 <= -1) THEN DRUG25 = .;
   IF (DRUG26 <= -1) THEN DRUG26 = .;
   IF (DRUG27 <= -1) THEN DRUG27 = .;
   IF (DRUG28 <= -1) THEN DRUG28 = .;
   IF (DRUG29 <= -1) THEN DRUG29 = .;
   IF (DRUG30 <= -1) THEN DRUG30 = .;
   IF (DRUG31 <= -1) THEN DRUG31 = .;
   IF (DRUG32 <= -1) THEN DRUG32 = .;
   IF (DRUG33 <= -1) THEN DRUG33 = .;
   IF (DRUG34 <= -1) THEN DRUG34 = .;
   IF (DRUG35 <= -1) THEN DRUG35 = .;
   IF (DRUG36 <= -1) THEN DRUG36 = .;
   IF (DRUG37 <= -1) THEN DRUG37 = .;
   IF (DRUG38 <= -1) THEN DRUG38 = .;
   IF (DRUG39 <= -1) THEN DRUG39 = .;
   IF (DRUG40 <= -1) THEN DRUG40 = .;
   IF (DRUG41 <= -1) THEN DRUG41 = .;
   IF (DRUG42 <= -1) THEN DRUG42 = .;
   IF (DRUG43 <= -1) THEN DRUG43 = .;
   IF (DRUG44 <= -1) THEN DRUG44 = .;
   IF (DRUG45 <= -1) THEN DRUG45 = .;
   IF (DRUG46 <= -1) THEN DRUG46 = .;
   IF (DRUG47 <= -1) THEN DRUG47 = .;
   IF (DRUG48 <= -1) THEN DRUG48 = .;
   IF (DRUG49 <= -1) THEN DRUG49 = .;
   IF (DRUG50 <= -1) THEN DRUG50 = .;
   IF (DRUG51 <= -1) THEN DRUG51 = .;
   IF (DRUG52 <= -1) THEN DRUG52 = .;
   IF (FORM01 <= -1) THEN FORM01 = .;
   IF (FORM02 <= -1) THEN FORM02 = .;
   IF (FORM03 <= -1) THEN FORM03 = .;
   IF (FORM04 <= -1) THEN FORM04 = .;
   IF (FORM05 <= -1) THEN FORM05 = .;
   IF (FORM06 <= -1) THEN FORM06 = .;
   IF (FORM07 <= -1) THEN FORM07 = .;
   IF (FORM08 <= -1) THEN FORM08 = .;
   IF (FORM09 <= -1) THEN FORM09 = .;
   IF (FORM10 <= -1) THEN FORM10 = .;
   IF (FORM11 <= -1) THEN FORM11 = .;
   IF (FORM12 <= -1) THEN FORM12 = .;
   IF (FORM13 <= -1) THEN FORM13 = .;
   IF (FORM14 <= -1) THEN FORM14 = .;
   IF (FORM15 <= -1) THEN FORM15 = .;
   IF (FORM16 <= -1) THEN FORM16 = .;
   IF (FORM17 <= -1) THEN FORM17 = .;
   IF (FORM18 <= -1) THEN FORM18 = .;
   IF (FORM19 <= -1) THEN FORM19 = .;
   IF (FORM20 <= -1) THEN FORM20 = .;
   IF (FORM21 <= -1) THEN FORM21 = .;
   IF (FORM22 <= -1) THEN FORM22 = .;
   IF (FORM23 <= -1) THEN FORM23 = .;
   IF (FORM24 <= -1) THEN FORM24 = .;
   IF (FORM25 <= -1) THEN FORM25 = .;
   IF (FORM26 <= -1) THEN FORM26 = .;
   IF (FORM27 <= -1) THEN FORM27 = .;
   IF (FORM28 <= -1) THEN FORM28 = .;
   IF (FORM29 <= -1) THEN FORM29 = .;
   IF (FORM30 <= -1) THEN FORM30 = .;
   IF (FORM31 <= -1) THEN FORM31 = .;
   IF (FORM32 <= -1) THEN FORM32 = .;
   IF (FORM33 <= -1) THEN FORM33 = .;
   IF (FORM34 <= -1) THEN FORM34 = .;
   IF (FORM35 <= -1) THEN FORM35 = .;
   IF (FORM36 <= -1) THEN FORM36 = .;
   IF (FORM37 <= -1) THEN FORM37 = .;
   IF (FORM38 <= -1) THEN FORM38 = .;
   IF (FORM39 <= -1) THEN FORM39 = .;
   IF (FORM40 <= -1) THEN FORM40 = .;
   IF (FORM41 <= -1) THEN FORM41 = .;
   IF (FORM42 <= -1) THEN FORM42 = .;
   IF (FORM43 <= -1) THEN FORM43 = .;
   IF (FORM44 <= -1) THEN FORM44 = .;
   IF (FORM45 <= -1) THEN FORM45 = .;
   IF (FORM46 <= -1) THEN FORM46 = .;
   IF (FORM47 <= -1) THEN FORM47 = .;
   IF (FORM48 <= -1) THEN FORM48 = .;
   IF (FORM49 <= -1) THEN FORM49 = .;
   IF (FORM50 <= -1) THEN FORM50 = .;
   IF (FORM51 <= -1) THEN FORM51 = .;
   IF (FORM52 <= -1) THEN FORM52 = .;
   IF (ROUTE01 <= -1) THEN ROUTE01 = .;
   IF (ROUTE02 <= -1) THEN ROUTE02 = .;
   IF (ROUTE03 <= -1) THEN ROUTE03 = .;
   IF (ROUTE04 <= -1) THEN ROUTE04 = .;
   IF (ROUTE05 <= -1) THEN ROUTE05 = .;
   IF (ROUTE06 <= -1) THEN ROUTE06 = .;
   IF (ROUTE07 <= -1) THEN ROUTE07 = .;
   IF (ROUTE08 <= -1) THEN ROUTE08 = .;
   IF (ROUTE09 <= -1) THEN ROUTE09 = .;
   IF (ROUTE10 <= -1) THEN ROUTE10 = .;
   IF (ROUTE11 <= -1) THEN ROUTE11 = .;
   IF (ROUTE12 <= -1) THEN ROUTE12 = .;
   IF (ROUTE13 <= -1) THEN ROUTE13 = .;
   IF (ROUTE14 <= -1) THEN ROUTE14 = .;
   IF (ROUTE15 <= -1) THEN ROUTE15 = .;
   IF (ROUTE16 <= -1) THEN ROUTE16 = .;
   IF (ROUTE17 <= -1) THEN ROUTE17 = .;
   IF (ROUTE18 <= -1) THEN ROUTE18 = .;
   IF (ROUTE19 <= -1) THEN ROUTE19 = .;
   IF (ROUTE20 <= -1) THEN ROUTE20 = .;
   IF (ROUTE21 <= -1) THEN ROUTE21 = .;
   IF (ROUTE22 <= -1) THEN ROUTE22 = .;
   IF (ROUTE23 <= -1) THEN ROUTE23 = .;
   IF (ROUTE24 <= -1) THEN ROUTE24 = .;
   IF (ROUTE25 <= -1) THEN ROUTE25 = .;
   IF (ROUTE26 <= -1) THEN ROUTE26 = .;
   IF (ROUTE27 <= -1) THEN ROUTE27 = .;
   IF (ROUTE28 <= -1) THEN ROUTE28 = .;
   IF (ROUTE29 <= -1) THEN ROUTE29 = .;
   IF (ROUTE30 <= -1) THEN ROUTE30 = .;
   IF (ROUTE31 <= -1) THEN ROUTE31 = .;
   IF (ROUTE32 <= -1) THEN ROUTE32 = .;
   IF (ROUTE33 <= -1) THEN ROUTE33 = .;
   IF (ROUTE34 <= -1) THEN ROUTE34 = .;
   IF (ROUTE35 <= -1) THEN ROUTE35 = .;
   IF (ROUTE36 <= -1) THEN ROUTE36 = .;
   IF (ROUTE37 <= -1) THEN ROUTE37 = .;
   IF (ROUTE38 <= -1) THEN ROUTE38 = .;
   IF (ROUTE39 <= -1) THEN ROUTE39 = .;
   IF (ROUTE40 <= -1) THEN ROUTE40 = .;
   IF (ROUTE41 <= -1) THEN ROUTE41 = .;
   IF (ROUTE42 <= -1) THEN ROUTE42 = .;
   IF (ROUTE43 <= -1) THEN ROUTE43 = .;
   IF (ROUTE44 <= -1) THEN ROUTE44 = .;
   IF (ROUTE45 <= -1) THEN ROUTE45 = .;
   IF (ROUTE46 <= -1) THEN ROUTE46 = .;
   IF (ROUTE47 <= -1) THEN ROUTE47 = .;
   IF (ROUTE48 <= -1) THEN ROUTE48 = .;
   IF (ROUTE49 <= -1) THEN ROUTE49 = .;
   IF (ROUTE50 <= -1) THEN ROUTE50 = .;
   IF (ROUTE51 <= -1) THEN ROUTE51 = .;
   IF (ROUTE52 <= -1) THEN ROUTE52 = .;
   IF (DAY <= -1) THEN DAY = .;
*/

* SAS FORMAT STATEMENT;

  FORMAT MOTIVE motive. REASON reason. DISPOSTN dispostn.
         DAWNQTR dawnqtr. DAWNAREA dawnarea. AGE age.
         RACE race. SEX sex. DRUG01 drug01ff.
         DRUG02 drug02ff. DRUG03 drug03ff. DRUG04 drug04ff.
         DRUG05 drug05ff. DRUG06 drug06ff. DRUG07 drug07ff.
         DRUG08 drug08ff. DRUG09 drug09ff. DRUG10 drug10ff.
         DRUG11 drug11ff. DRUG12 drug12ff. DRUG13 drug13ff.
         DRUG14 drug14ff. DRUG15 drug15ff. DRUG16 drug16ff.
         DRUG17 drug17ff. DRUG18 drug18ff. DRUG19 drug19ff.
         DRUG20 drug20ff. DRUG21 drug21ff. DRUG22 drug22ff.
         DRUG23 drug23ff. DRUG24 drug24ff. DRUG25 drug25ff.
         DRUG26 drug26ff. DRUG27 drug27ff. DRUG28 drug28ff.
         DRUG29 drug29ff. DRUG30 drug30ff. DRUG31 drug31ff.
         DRUG32 drug32ff. DRUG33 drug33ff. DRUG34 drug34ff.
         DRUG35 drug35ff. DRUG36 drug36ff. DRUG37 drug37ff.
         DRUG38 drug38ff. DRUG39 drug39ff. DRUG40 drug40ff.
         DRUG41 drug41ff. DRUG42 drug42ff. DRUG43 drug43ff.
         DRUG44 drug44ff. DRUG45 drug45ff. DRUG46 drug46ff.
         DRUG47 drug47ff. DRUG48 drug48ff. DRUG49 drug49ff.
         DRUG50 drug50ff. DRUG51 drug51ff. DRUG52 drug52ff.
         FORM01 form01ff. FORM02 form02ff. FORM03 form03ff.
         FORM04 form04ff. FORM05 form05ff. FORM06 form06ff.
         FORM07 form07ff. FORM08 form08ff. FORM09 form09ff.
         FORM10 form10ff. FORM11 form11ff. FORM12 form12ff.
         FORM13 form13ff. FORM14 form14ff. FORM15 form15ff.
         FORM16 form16ff. FORM17 form17ff. FORM18 form18ff.
         FORM19 form19ff. FORM20 form20ff. FORM21 form21ff.
         FORM22 form22ff. FORM23 form23ff. FORM24 form24ff.
         FORM25 form25ff. FORM26 form26ff. FORM27 form27ff.
         FORM28 form28ff. FORM29 form29ff. FORM30 form30ff.
         FORM31 form31ff. FORM32 form32ff. FORM33 form33ff.
         FORM34 form34ff. FORM35 form35ff. FORM36 form36ff.
         FORM37 form37ff. FORM38 form38ff. FORM39 form39ff.
         FORM40 form40ff. FORM41 form41ff. FORM42 form42ff.
         FORM43 form43ff. FORM44 form44ff. FORM45 form45ff.
         FORM46 form46ff. FORM47 form47ff. FORM48 form48ff.
         FORM49 form49ff. FORM50 form50ff. FORM51 form51ff.
         FORM52 form52ff. ROUTE01 route01f. ROUTE02 route02f.
         ROUTE03 route03f. ROUTE04 route04f. ROUTE05 route05f.
         ROUTE06 route06f. ROUTE07 route07f. ROUTE08 route08f.
         ROUTE09 route09f. ROUTE10 route10f. ROUTE11 route11f.
         ROUTE12 route12f. ROUTE13 route13f. ROUTE14 route14f.
         ROUTE15 route15f. ROUTE16 route16f. ROUTE17 route17f.
         ROUTE18 route18f. ROUTE19 route19f. ROUTE20 route20f.
         ROUTE21 route21f. ROUTE22 route22f. ROUTE23 route23f.
         ROUTE24 route24f. ROUTE25 route25f. ROUTE26 route26f.
         ROUTE27 route27f. ROUTE28 route28f. ROUTE29 route29f.
         ROUTE30 route30f. ROUTE31 route31f. ROUTE32 route32f.
         ROUTE33 route33f. ROUTE34 route34f. ROUTE35 route35f.
         ROUTE36 route36f. ROUTE37 route37f. ROUTE38 route38f.
         ROUTE39 route39f. ROUTE40 route40f. ROUTE41 route41f.
         ROUTE42 route42f. ROUTE43 route43f. ROUTE44 route44f.
         ROUTE45 route45f. ROUTE46 route46f. ROUTE47 route47f.
         ROUTE48 route48f. ROUTE49 route49f. ROUTE50 route50f.
         ROUTE51 route51f. ROUTE52 route52f. DAY dayfffff.
          ;

RUN ;
