*-------------------------------------------------------------------------*
*                                                                          
*                     SPSS SETUP FILE FOR ICPSR 02756
*                 DRUG ABUSE WARNING NETWORK (DAWN), 1994
* 
*
*  SPSS setup sections are provided for the ASCII version of this data
*  collection.  These sections are listed below:
*
*  DATA LIST:  assigns the name, type, decimal specification (if any),
*  and specifies the beginning and ending column locations for each
*  variable in the data file. Users must replace the "data-filename"
*  in the DATA LIST statement with a filename specifying the directory
*  on the user's computer system in which the downloaded and unzipped
*  data file is physically located (e.g., "c:\temp\02756-0001-data.txt").
*
*  VARIABLE LABELS:  assigns descriptive labels to all variables.
*  Labels and variable names may be identical for some data files.
*
*  MISSING VALUES: declares user-defined missing values. Not all
*  variables in this data set necessarily have user-defined missing
*  values. These values can be treated specially in data transformations,
*  statistical calculations, and case selection.
*
*  VALUE LABELS: assigns descriptive labels to codes found in the data
*  file.  Not all codes necessarily have assigned value labels.
*
*  NOTE:  Users should modify this setup file to suit their specific 
*  needs. The MISSING VALUES section has been commented out (i.e., '*').
*  To include the MISSING VALUES section in the final SPSS setup, remove 
*  the comment indicators from the desired section.
*
*  CREATING A PERMANENT SPSS DATA FILE: If users wish to create and save
*  an SPSS data file for further analysis using SPSS for Windows, the
*  necessary "SAVE OUTFILE" command is provided in the last line of
*  this file.  To activate the command, users must delete the leading
*  asterisk (*) and replace "spss-filename" with a filename specifying
*  the location on the user's computer system to which the new data file
*  will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\da02756-0001.sav").
*
*-------------------------------------------------------------------------.

* SPSS FILE HANDLE AND DATA LIST COMMANDS.

FILE HANDLE DATA / NAME="data-filename" LRECL=298.
DATA LIST FILE=DATA /
              CASEID 1-6                YEAR 7-8             MOTIVE 9-10
            REASON 11-12          DISPOSTN 13-14              TOTMENS 15
              DAWNQTR 16             UNIQMENS 17              STRATUM 18
            HOSPID 19-26       FWEIGHT 27-33 (4)          DAWNAREA 34-35
               AGE 36-37              RACE 38-39               SEX 40-41
               DRUG01 42               DRUG02 43               DRUG03 44
               DRUG04 45               DRUG05 46               DRUG06 47
               DRUG07 48               DRUG08 49               DRUG09 50
               DRUG10 51               DRUG11 52               DRUG12 53
               DRUG13 54               DRUG14 55               DRUG15 56
               DRUG16 57               DRUG17 58               DRUG18 59
               DRUG19 60               DRUG20 61               DRUG21 62
               DRUG22 63               DRUG23 64               DRUG24 65
               DRUG25 66               DRUG26 67               DRUG27 68
               DRUG28 69               DRUG29 70               DRUG30 71
               DRUG31 72               DRUG32 73               DRUG33 74
               DRUG34 75               DRUG35 76               DRUG36 77
               DRUG37 78               DRUG38 79               DRUG39 80
               DRUG40 81               DRUG41 82               DRUG42 83
               DRUG43 84               DRUG44 85               DRUG45 86
               DRUG46 87               DRUG47 88               DRUG48 89
               DRUG49 90               DRUG50 91               DRUG51 92
               DRUG52 93            FORM01 94-95               FORM02 96
            FORM03 97-98           FORM04 99-100          FORM05 101-102
          FORM06 103-104          FORM07 105-106          FORM08 107-108
          FORM09 109-110          FORM10 111-112          FORM11 113-114
          FORM12 115-116          FORM13 117-118          FORM14 119-120
          FORM15 121-122          FORM16 123-124          FORM17 125-126
          FORM18 127-128          FORM19 129-130          FORM20 131-132
          FORM21 133-134          FORM22 135-136          FORM23 137-138
          FORM24 139-140              FORM25 141          FORM26 142-143
          FORM27 144-145          FORM28 146-147          FORM29 148-149
          FORM30 150-151          FORM31 152-153          FORM32 154-155
          FORM33 156-157          FORM34 158-159          FORM35 160-161
          FORM36 162-163          FORM37 164-165          FORM38 166-167
          FORM39 168-169          FORM40 170-171          FORM41 172-173
          FORM42 174-175          FORM43 176-177          FORM44 178-179
          FORM45 180-181          FORM46 182-183          FORM47 184-185
          FORM48 186-187          FORM49 188-189          FORM50 190-191
          FORM51 192-193          FORM52 194-195         ROUTE01 196-197
             ROUTE02 198         ROUTE03 199-200         ROUTE04 201-202
         ROUTE05 203-204         ROUTE06 205-206         ROUTE07 207-208
         ROUTE08 209-210         ROUTE09 211-212         ROUTE10 213-214
         ROUTE11 215-216         ROUTE12 217-218         ROUTE13 219-220
         ROUTE14 221-222         ROUTE15 223-224         ROUTE16 225-226
         ROUTE17 227-228         ROUTE18 229-230         ROUTE19 231-232
         ROUTE20 233-234         ROUTE21 235-236         ROUTE22 237-238
         ROUTE23 239-240         ROUTE24 241-242             ROUTE25 243
         ROUTE26 244-245         ROUTE27 246-247         ROUTE28 248-249
         ROUTE29 250-251         ROUTE30 252-253         ROUTE31 254-255
         ROUTE32 256-257         ROUTE33 258-259         ROUTE34 260-261
         ROUTE35 262-263         ROUTE36 264-265         ROUTE37 266-267
         ROUTE38 268-269         ROUTE39 270-271         ROUTE40 272-273
         ROUTE41 274-275         ROUTE42 276-277         ROUTE43 278-279
         ROUTE44 280-281         ROUTE45 282-283         ROUTE46 284-285
         ROUTE47 286-287         ROUTE48 288-289         ROUTE49 290-291
         ROUTE50 292-293         ROUTE51 294-295         ROUTE52 296-297
                 DAY 298
   .

* SPSS VARIABLE LABELS COMMAND.

VARIABLE LABELS
   CASEID    'UNIQUE IDENTIFIER FOR EACH EPISODE' /
   YEAR      'YEAR EPISODE OCCURRED' /
   MOTIVE    'DRUG USE MOTIVE' /
   REASON    'REASON FOR ER VISIT' /
   DISPOSTN  'PATIENT DISPOSITION' /
   TOTMENS   'TOTAL MENTIONS IN EPISODE (W/ DUPS)' /
   DAWNQTR   'ABSOLUTE QUARTER NUMBER IN DAWN' /
   UNIQMENS  'UNIQUE MENTIONS IN EPISODE (S/ DUPS)' /
   STRATUM   'MODIFIED STRATUM' /
   HOSPID    'UNIQUE IDENTIFIER FOR EACH HOSPITAL' /
   FWEIGHT   'EPISODE WEIGHT' /
   DAWNAREA  'NEW SAMPLE PMSA CODE' /
   AGE       'AGE OF PATIENT' /
   RACE      'PATIENT RACE/ETHNICITY' /
   SEX       'SEX OF PATIENT' /
   DRUG01    'ACETAMINOPHEN' /
   DRUG02    'ALCOHOL-IN-COMBO' /
   DRUG03    'ALPRAZOLAM' /
   DRUG04    'AMITRIPTYLINE' /
   DRUG05    'AMITRIPTYLN COMB' /
   DRUG06    'AMPHETAMINE' /
   DRUG07    'ASPIRIN' /
   DRUG08    'BUTALBITAL COMBO' /
   DRUG09    'CHLORAL HYDRATE' /
   DRUG10    'CHLORDIAZEPOXIDE' /
   DRUG11    'CHLORPROMAZINE' /
   DRUG12    'CLORAZEPATE' /
   DRUG13    'COCAINE' /
   DRUG14    'CODEINE' /
   DRUG15    'CODEINE COMBO' /
   DRUG16    'd-PROPOXYPHENE' /
   DRUG17    'DESIPRAMINE' /
   DRUG18    'DIAZEPAM' /
   DRUG19    'DIPHENHYDRAMINE' /
   DRUG20    'DIPHENYLHYDANTOIN SODIUM' /
   DRUG21    'DOXEPIN' /
   DRUG22    'ETHCHLORVYNOL' /
   DRUG23    'FLUOXETINE' /
   DRUG24    'FLURAZEPAM' /
   DRUG25    'GLUTETHIMIDE' /
   DRUG26    'HALOPERIDOL' /
   DRUG27    'HEROIN/MORPHINE' /
   DRUG28    'HYDROMORPHONE' /
   DRUG29    'IMIPRAMINE' /
   DRUG30    'INHLNT/SOL/AER' /
   DRUG31    'LORAZEPAM' /
   DRUG32    'LSD' /
   DRUG33    'MARIJUANA/HASHISH' /
   DRUG34    'MEPERIDINE HCL' /
   DRUG35    'MEPROBAMATE' /
   DRUG36    'METHADONE' /
   DRUG37    'METHAMPHETAMINE' /
   DRUG38    'METHAQUALONE' /
   DRUG39    'METHYLPHENIDATE' /
   DRUG40    'OTC DIET AIDS' /
   DRUG41    'OTC SLEEP AIDS' /
   DRUG42    'OXYCODONE' /
   DRUG43    'PCP/PCP COMBO' /
   DRUG44    'PENTAZOCINE' /
   DRUG45    'PENTOBARBITAL' /
   DRUG46    'PHENOBARBITAL' /
   DRUG47    'SECOBARBITAL' /
   DRUG48    'SECOBARBTL/AMOBARBITAL' /
   DRUG49    'THIORIDAZINE' /
   DRUG50    'TRIFLUOPERAZINE' /
   DRUG51    'DRUGS, OTH CAT' /
   DRUG52    'DRUGS, UNKNOWN' /
   FORM01    'Form of ACETAMINOPHEN' /
   FORM02    'Form of ALCOHOL-IN-COMBO' /
   FORM03    'Form of ALPRAZOLAM' /
   FORM04    'Form of AMITRIPTYLINE' /
   FORM05    'Form of AMITRIPTYLN COMB' /
   FORM06    'Form of AMPHETAMINE' /
   FORM07    'Form of ASPIRIN' /
   FORM08    'Form of BUTALBITAL COMBO' /
   FORM09    'Form of CHLORAL HYDRATE' /
   FORM10    'Form of CHLORDIAZEPOXIDE' /
   FORM11    'Form of CHLORPROMAZINE' /
   FORM12    'Form of CLORAZEPATE' /
   FORM13    'Form of COCAINE' /
   FORM14    'Form of CODEINE' /
   FORM15    'Form of CODEINE COMBO' /
   FORM16    'Form of d-PROPOXYPHENE' /
   FORM17    'Form of DESIPRAMINE' /
   FORM18    'Form of DIAZEPAM' /
   FORM19    'Form of DIPHENHYDRAMINE' /
   FORM20    'Form of DIPHENYLHYDANTOIN SODIUM' /
   FORM21    'Form of DOXEPIN' /
   FORM22    'Form of ETHCHLORVYNOL' /
   FORM23    'Form of FLUOXETINE' /
   FORM24    'Form of FLURAZEPAM' /
   FORM25    'Form of GLUTETHIMIDE' /
   FORM26    'Form of HALOPERIDOL' /
   FORM27    'Form of HEROIN/MORPHINE' /
   FORM28    'Form of HYDROMORPHONE' /
   FORM29    'Form of IMIPRAMINE' /
   FORM30    'Form of INHLNT/SOL/AER' /
   FORM31    'Form of LORAZEPAM' /
   FORM32    'Form of LSD' /
   FORM33    'Form of MARIJUANA/HASHISH' /
   FORM34    'Form of MEPERIDINE HCL' /
   FORM35    'Form of MEPROBAMATE' /
   FORM36    'Form of METHADONE' /
   FORM37    'Form of METHAMPHETAMINE' /
   FORM38    'Form of METHAQUALONE' /
   FORM39    'Form of METHYLPHENIDATE' /
   FORM40    'Form of OTC DIET AIDS' /
   FORM41    'Form of OTC SLEEP AIDS' /
   FORM42    'Form of OXYCODONE' /
   FORM43    'Form of PCP/PCP COMBO' /
   FORM44    'Form of PENTAZOCINE' /
   FORM45    'Form of PENTOBARBITAL' /
   FORM46    'Form of PHENOBARBITAL' /
   FORM47    'Form of SECOBARBITAL' /
   FORM48    'Form of SECOBARBTL/AMOBARBITAL' /
   FORM49    'Form of THIORIDAZINE' /
   FORM50    'Form of TRIFLUOPERAZINE' /
   FORM51    'Form of DRUGS in OTH CAT' /
   FORM52    'Form of DRUGS, UNKNOWN' /
   ROUTE01   'Route for ACETAMINOPHEN' /
   ROUTE02   'Route for ALCOHOL-IN-COMBO' /
   ROUTE03   'Route for ALPRAZOLAM' /
   ROUTE04   'Route for AMITRIPTYLINE' /
   ROUTE05   'Route for AMITRIPTYLN COMB' /
   ROUTE06   'Route for AMPHETAMINE' /
   ROUTE07   'Route for ASPIRIN' /
   ROUTE08   'Route for BUTALBITAL COMBO' /
   ROUTE09   'Route for CHLORAL HYDRATE' /
   ROUTE10   'Route for CHLORDIAZEPOXIDE' /
   ROUTE11   'Route for CHLORPROMAZINE' /
   ROUTE12   'Route for CLORAZEPATE' /
   ROUTE13   'Route for COCAINE' /
   ROUTE14   'Route for CODEINE' /
   ROUTE15   'Route for CODEINE COMBO' /
   ROUTE16   'Route for d-PROPOXYPHENE' /
   ROUTE17   'Route for DESIPRAMINE' /
   ROUTE18   'Route for DIAZEPAM' /
   ROUTE19   'Route for DIPHENHYDRAMINE' /
   ROUTE20   'Route for DIPHENYLHYDANTOIN SODIUM' /
   ROUTE21   'Route for DOXEPIN' /
   ROUTE22   'Route for ETHCHLORVYNOL' /
   ROUTE23   'Route for FLUOXETINE' /
   ROUTE24   'Route for FLURAZEPAM' /
   ROUTE25   'Route for GLUTETHIMIDE' /
   ROUTE26   'Route for HALOPERIDOL' /
   ROUTE27   'Route for HEROIN/MORPHINE' /
   ROUTE28   'Route for HYDROMORPHONE' /
   ROUTE29   'Route for IMIPRAMINE' /
   ROUTE30   'Route for INHLNT/SOL/AER' /
   ROUTE31   'Route for LORAZEPAM' /
   ROUTE32   'Route for LSD' /
   ROUTE33   'Route for MARIJUANA/HASHISH' /
   ROUTE34   'Route for MEPERIDINE HCL' /
   ROUTE35   'Route for MEPROBAMATE' /
   ROUTE36   'Route for METHADONE' /
   ROUTE37   'Route for METHAMPHETAMINE' /
   ROUTE38   'Route for METHAQUALONE' /
   ROUTE39   'Route for METHYLPHENIDATE' /
   ROUTE40   'Route for OTC DIET AIDS' /
   ROUTE41   'Route for OTC SLEEP AIDS' /
   ROUTE42   'Route for OXYCODONE' /
   ROUTE43   'Route for PCP/PCP COMBO' /
   ROUTE44   'Route for PENTAZOCINE' /
   ROUTE45   'Route for PENTOBARBITAL' /
   ROUTE46   'Route for PHENOBARBITAL' /
   ROUTE47   'Route for SECOBARBITAL' /
   ROUTE48   'Route for SECOBARBTL/AMOBARBITAL' /
   ROUTE49   'Route for THIORIDAZINE' /
   ROUTE50   'Route for TRIFLUOPERAZINE' /
   ROUTE51   'Route for DRUGS in OTH CAT' /
   ROUTE52   'Route for DRUGS, UNKNOWN' /
   DAY       'DAY OF THE WEEK' /
   .


* SPSS VALUE LABELS COMMAND.

VALUE LABELS
   MOTIVE    -1 'MISSING' 2 'DEPENDENCE' 3 'SUICIDE' 5 'OTHER'
             6 'RECREATIONAL USE' 7 'PSYCHO EFFECTS' /
   REASON    -2 'NO RESPONSE' -1 'MISSING' 1 'UNEXPECTD REACTN' 2 'OVERDOSE'
             3 'WITHDRAWL' 4 'CHRONIC EFFECTS' 6 'OTHER' 7 'SEEKING DETOXFTN'
             8 'ACCIDENT/INJURY' /
   DISPOSTN  -1 'MISSING' 1 'TREATED, RELEASE' 2 'ADMITTED'
             3 'LEFT AGNST ADVIC' 4 'DIED' /
   DAWNQTR   1 'FIRST QUARTER' 2 'SECOND QUARTER' 3 'THIRD QUARTER'
             4 'FOURTH QUARTER' /
   DAWNAREA  1 'ATLANTA' 2 'BALTIMORE' 3 'BOSTON' 4 'BUFFALO' 5 'CHICAGO'
             6 'DALLAS' 7 'DENVER' 8 'DETROIT' 9 'LA-LONG BEACH'
             10 'MIAMI-HIALEAH' 11 'MINNEAPOLIS-ST PAUL' 12 'NEW ORLEANS'
             13 'NEW YORK' 14 'NEWARK' 15 'PHILADELPHIA' 16 'PHOENIX'
             17 'ST. LOUIS' 18 'SAN DIEGO' 19 'SAN FRANCISCO' 20 'SEATTLE'
             21 'WASHINGTON, DC' 22 'NATIONAL PANEL' /
   AGE       -1 'MISSING' 1 '6-11' 2 '12-17' 3 '18-20' 4 '21-25' 5 '26-29'
             6 '30-34' 7 '35-44' 8 '45-54' 9 '55 AND OVER' /
   RACE      -1 'MISSING' 1 'WHITE' 2 'BLACK' 3 'HISPANIC'
             4 'AMER IND/ALASKN' 5 'OTHER' /
   SEX       -1 'MISSING' 1 'MALE' 2 'FEMALE' /
   DRUG01    0 'Did not use ACETAMINOPHEN' 1 'Used ACETAMINOPHEN' /
   DRUG02    0 'Did not use ALCOHOL-IN-COMBO' 1 'Used ALCOHOL-IN-COMBO' /
   DRUG03    0 'Did not use ALPRAZOLAM' 1 'Used ALPRAZOLAM' /
   DRUG04    0 'Did not use AMITRIPTYLINE' 1 'Used AMITRIPTYLINE' /
   DRUG05    0 'Did not use AMITRIPTYLN COMB' 1 'Used AMITRIPTYLN COMB' /
   DRUG06    0 'Did not use AMPHETAMINE' 1 'Used AMPHETAMINE' /
   DRUG07    0 'Did not use ASPIRIN' 1 'Used ASPIRIN' /
   DRUG08    0 'Did not use BUTALBITAL COMBO' 1 'Used BUTALBITAL COMBO' /
   DRUG09    0 'Did not use CHLORAL HYDRATE' 1 'Used CHLORAL HYDRATE' /
   DRUG10    0 'Did not use CHLORDIAZEPOXIDE' 1 'Used CHLORDIAZEPOXIDE' /
   DRUG11    0 'Did not use CHLORPROMAZINE' 1 'Used CHLORPROMAZINE' /
   DRUG12    0 'Did not use CLORAZEPATE' 1 'Used CLORAZEPATE' /
   DRUG13    0 'Did not use COCAINE' 1 'Used COCAINE' /
   DRUG14    0 'Did not use CODEINE' 1 'Used CODEINE' /
   DRUG15    0 'Did not use CODEINE COMBO' 1 'Used 1 CODEINE COMBO'
             2 'Used 2 CODEINE COMBO' /
   DRUG16    0 'Did not use d-PROPOXYPHENE' 1 'Used d-PROPOXYPHENE' /
   DRUG17    0 'Did not use DESIPRAMINE' 1 'Used DESIPRAMINE' /
   DRUG18    0 'Did not use DIAZEPAM' 1 'Used DIAZEPAM' /
   DRUG19    0 'Did not use DIPHENHYDRAMINE' 1 'Used DIPHENHYDRAMINE' /
   DRUG20    0 'Did not use DIPHENYLHYDANTOIN SODIUM'
             1 'Used DIPHENYLHYDANTOIN SODIUM' /
   DRUG21    0 'Did not use DOXEPIN' 1 'Used DOXEPIN' /
   DRUG22    0 'Did not use ETHCHLORVYNOL' 1 'Used ETHCHLORVYNOL' /
   DRUG23    0 'Did not use FLUOXETINE' 1 'Used FLUOXETINE' /
   DRUG24    0 'Did not use FLURAZEPAM' 1 'Used FLURAZEPAM' /
   DRUG25    0 'Did not use GLUTETHIMIDE' 1 'Used GLUTETHIMIDE' /
   DRUG26    0 'Did not use HALOPERIDOL' 1 'Used HALOPERIDOL' /
   DRUG27    0 'Did not use HEROIN/MORPHINE' 1 'Used HEROIN/MORPHINE' /
   DRUG28    0 'Did not use HYDROMORPHONE' 1 'Used HYDROMORPHONE' /
   DRUG29    0 'Did not use IMIPRAMINE' 1 'Used IMIPRAMINE' /
   DRUG30    0 'Did not use INHLNT/SOLV/AERO' 1 'Used 1 INHLNT/SOLV/AERO'
             2 'Used 2 INHLNT/SOLV/AERO' /
   DRUG31    0 'Did not use LORAZEPAM' 1 'Used LORAZEPAM' /
   DRUG32    0 'Did not use LSD' 1 'Used LSD' /
   DRUG33    0 'Did not use MARIJUANA/HASHISH' 1 'Used MARIJUANA/HASHISH' /
   DRUG34    0 'Did not use MEPERIDINE HCL' 1 'Used MEPERIDINE HCL' /
   DRUG35    0 'Did not use MEPROBAMATE' 1 'Used MEPROBAMATE' /
   DRUG36    0 'Did not use METHADONE' 1 'Used METHADONE' /
   DRUG37    0 'Did not use METHAMPHETAMINE' 1 'Used METHAMPHETAMINE' /
   DRUG38    0 'Did not use METHAQUALONE' 1 'Used METHAQUALONE' /
   DRUG39    0 'Did not use METHYLPHENIDATE' 1 'Used METHYLPHENIDATE' /
   DRUG40    0 'Did not use OTC DIET AIDS' 1 'Used OTC DIET AIDS' /
   DRUG41    0 'Did not use OTC SLEEP AIDS' 1 'Used OTC SLEEP AIDS' /
   DRUG42    0 'Did not use OXYCODONE' 1 'Used OXYCODONE' /
   DRUG43    0 'Did not use PCP/PCP COMBO' 1 'Used PCP/PCP COMBO' /
   DRUG44    0 'Did not use PENTAZOCINE' 1 'Used PENTAZOCINE' /
   DRUG45    0 'Did not use PENTOBARBITAL' 1 'Used PENTOBARBITAL' /
   DRUG46    0 'Did not use PHENOBARBITAL' 1 'Used PHENOBARBITAL' /
   DRUG47    0 'Did not use SECOBARBITAL' 1 'Used SECOBARBITAL' /
   DRUG48    0 'Did not use SECOBARBTL/AMOBARBITAL'
             1 'Used SECOBARBTL/AMOBARBITAL' /
   DRUG49    0 'Did not use THIORIDAZINE' 1 'Used THIORIDAZINE' /
   DRUG50    0 'Did not use TRIFLUOPERAZINE' 1 'Used TRIFLUOPERAZINE' /
   DRUG51    0 'Did not use DRUG,OTHER CAT' 1 'Used 1 DRUG,OTHER CAT'
             2 'Used 2 DRUGS, OTHER CAT' 3 'Used 3 DRUGS, OTHER CAT'
             4 'Used 4 DRUGS, OTHER CAT' /
   DRUG52    0 'Did not use DRUG, UNKNOWN' 1 'Used 1 DRUG, UNKNOWN'
             2 'Used 2 DRUGS, UNKNOWN' /
   FORM01    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 6 'LIQUID/INJECT' 8 'PLANT MATERIAL'
             11 'PIECES/CHUNKS' /
   FORM02    0 'Did not use drug' 3 'LIQUID/ORAL' /
   FORM03    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' 4 'POWDER'
             11 'PIECES/CHUNKS' /
   FORM04    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL' 4 'POWDER'
             8 'PLANT MATERIAL' /
   FORM05    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM06    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 6 'LIQUID/INJECT' 7 'CIGARETTE'
             8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM07    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 5 'PAPER' 10 'OTHER' /
   FORM08    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM09    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM10    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM11    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' 4 'POWDER' /
   FORM12    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM13    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT'
             7 'CIGARETTE' 8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM14    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' 4 'POWDER'
             6 'LIQUID/INJECT' 11 'PIECES/CHUNKS' /
   FORM15    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM16    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM17    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 8 'PLANT MATERIAL'
             10 'OTHER' /
   FORM18    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 6 'LIQUID/INJECT' 7 'CIGARETTE' /
   FORM19    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL'
             6 'LIQUID/INJECT' 10 'OTHER' /
   FORM20    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' /
   FORM21    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM22    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 4 'POWDER' /
   FORM23    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM24    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM25    0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM26    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' /
   FORM27    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT'
             7 'CIGARETTE' 8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM28    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL'
             6 'LIQUID/INJECT' /
   FORM29    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM30    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 6 'LIQUID/INJECT' 8 'PLANT MATERIAL'
             10 'OTHER' /
   FORM31    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL' 4 'POWDER' /
   FORM32    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' 4 'POWDER'
             5 'PAPER' 6 'LIQUID/INJECT' 7 'CIGARETTE' 8 'PLANT MATERIAL'
             10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM33    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT'
             7 'CIGARETTE' 8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM34    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 6 'LIQUID/INJECT' /
   FORM35    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM36    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' 4 'POWDER'
             5 'PAPER' 6 'LIQUID/INJECT' 8 'PLANT MATERIAL' 10 'OTHER'
             11 'PIECES/CHUNKS' /
   FORM37    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL'
             4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT' 7 'CIGARETTE'
             8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM38    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM39    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 6 'LIQUID/INJECT' /
   FORM40    -3 'MULT RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM41    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL' /
   FORM42    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM43    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 3 'LIQUID/ORAL'
             4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT' 7 'CIGARETTE'
             8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM44    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM45    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL'
             6 'LIQUID/INJECT' 10 'OTHER' /
   FORM46    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' 2 'AEROSOL' 3 'LIQUID/ORAL' 6 'LIQUID/INJECT'
             /
   FORM47    -3 'MULT RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM48    -1 'MISSING' 0 'Did not use drug' 1 'TABL/CAP/PILL' /
   FORM49    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 6 'LIQUID/INJECT' /
   FORM50    -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug'
             1 'TABL/CAP/PILL' /
   FORM51    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT'
             7 'CIGARETTE' 8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   FORM52    -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'TABL/CAP/PILL' 2 'AEROSOL'
             3 'LIQUID/ORAL' 4 'POWDER' 5 'PAPER' 6 'LIQUID/INJECT'
             7 'CIGARETTE' 8 'PLANT MATERIAL' 10 'OTHER' 11 'PIECES/CHUNKS' /
   ROUTE01   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE02   0 'Did not use drug' 1 'ORAL' /
   ROUTE03   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             2 'INJECTED' 4 'SMOKE' /
   ROUTE04   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 5 'SNIFF/SNORT' /
   ROUTE05   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL' /
   ROUTE06   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE07   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             7 'OTHER' /
   ROUTE08   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' /
   ROUTE09   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             2 'INJECTED' /
   ROUTE10   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' /
   ROUTE11   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             5 'SNIFF/SNORT' /
   ROUTE12   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             2 'INJECTED' /
   ROUTE13   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE14   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             2 'INJECTED' 4 'SMOKE' 5 'SNIFF/SNORT' /
   ROUTE15   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' /
   ROUTE16   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 4 'SMOKE' /
   ROUTE17   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             7 'OTHER' /
   ROUTE18   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 4 'SMOKE'
             5 'SNIFF/SNORT' /
   ROUTE19   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' /
   ROUTE20   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             2 'INJECTED' 7 'OTHER' /
   ROUTE21   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL' /
   ROUTE22   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             2 'INJECTED' /
   ROUTE23   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 5 'SNIFF/SNORT' /
   ROUTE24   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL' /
   ROUTE25   0 'Did not use drug' 1 'ORAL' /
   ROUTE26   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             2 'INJECTED' 5 'SNIFF/SNORT' /
   ROUTE27   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE28   -1 'MISSING' 0 'Did not use drug' 1 'ORAL' 2 'INJECTED' /
   ROUTE29   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL' /
   ROUTE30   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE31   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' /
   ROUTE32   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             2 'INJECTED' 3 'INHALE' 4 'SMOKE' 5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE33   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE34   -1 'MISSING' 0 'Did not use drug' 1 'ORAL' 2 'INJECTED' /
   ROUTE35   -1 'MISSING' 0 'Did not use drug' 1 'ORAL' /
   ROUTE36   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             2 'INJECTED' 3 'INHALE' 4 'SMOKE' 5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE37   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE38   -1 'MISSING' 0 'Did not use drug' 1 'ORAL' /
   ROUTE39   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             2 'INJECTED' 5 'SNIFF/SNORT' /
   ROUTE40   -3 'MULT RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL' /
   ROUTE41   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' /
   ROUTE42   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 5 'SNIFF/SNORT' /
   ROUTE43   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE44   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL' /
   ROUTE45   -1 'MISSING' 0 'Did not use drug' 1 'ORAL' 2 'INJECTED'
             7 'OTHER' /
   ROUTE46   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL'
             2 'INJECTED' /
   ROUTE47   -3 'MULT RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL' /
   ROUTE48   -1 'MISSING' 0 'Did not use drug' 1 'ORAL' /
   ROUTE49   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' /
   ROUTE50   -2 'NO RESPONSE' -1 'MISSING' 0 'Did not use drug' 1 'ORAL' /
   ROUTE51   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   ROUTE52   -3 'MULT RESPONSE' -2 'NO RESPONSE' -1 'MISSING'
             0 'Did not use drug' 1 'ORAL' 2 'INJECTED' 3 'INHALE' 4 'SMOKE'
             5 'SNIFF/SNORT' 7 'OTHER' /
   DAY       1 'SUNDAY' 2 'MONDAY' 3 'TUESDAY' 4 'WEDNESDAY' 5 'THURSDAY'
             6 'FRIDAY' 7 'SATURDAY' /
   .

* SPSS MISSING VALUES COMMAND.

* MISSING VALUES
     CASEID
     YEAR
     MOTIVE
     REASON
     DISPOSTN
     TOTMENS
     DAWNQTR
     UNIQMENS
     STRATUM
     HOSPID
     DAWNAREA
     AGE
     RACE
     SEX
     DRUG01
     DRUG02
     DRUG03
     DRUG04
     DRUG05
     DRUG06
     DRUG07
     DRUG08
     DRUG09
     DRUG10
     DRUG11
     DRUG12
     DRUG13
     DRUG14
     DRUG15
     DRUG16
     DRUG17
     DRUG18
     DRUG19
     DRUG20
     DRUG21
     DRUG22
     DRUG23
     DRUG24
     DRUG25
     DRUG26
     DRUG27
     DRUG28
     DRUG29
     DRUG30
     DRUG31
     DRUG32
     DRUG33
     DRUG34
     DRUG35
     DRUG36
     DRUG37
     DRUG38
     DRUG39
     DRUG40
     DRUG41
     DRUG42
     DRUG43
     DRUG44
     DRUG45
     DRUG46
     DRUG47
     DRUG48
     DRUG49
     DRUG50
     DRUG51
     DRUG52
     FORM01
     FORM02
     FORM03
     FORM04
     FORM05
     FORM06
     FORM07
     FORM08
     FORM09
     FORM10
     FORM11
     FORM12
     FORM13
     FORM14
     FORM15
     FORM16
     FORM17
     FORM18
     FORM19
     FORM20
     FORM21
     FORM22
     FORM23
     FORM24
     FORM25
     FORM26
     FORM27
     FORM28
     FORM29
     FORM30
     FORM31
     FORM32
     FORM33
     FORM34
     FORM35
     FORM36
     FORM37
     FORM38
     FORM39
     FORM40
     FORM41
     FORM42
     FORM43
     FORM44
     FORM45
     FORM46
     FORM47
     FORM48
     FORM49
     FORM50
     FORM51
     FORM52
     ROUTE01
     ROUTE02
     ROUTE03
     ROUTE04
     ROUTE05
     ROUTE06
     ROUTE07
     ROUTE08
     ROUTE09
     ROUTE10
     ROUTE11
     ROUTE12
     ROUTE13
     ROUTE14
     ROUTE15
     ROUTE16
     ROUTE17
     ROUTE18
     ROUTE19
     ROUTE20
     ROUTE21
     ROUTE22
     ROUTE23
     ROUTE24
     ROUTE25
     ROUTE26
     ROUTE27
     ROUTE28
     ROUTE29
     ROUTE30
     ROUTE31
     ROUTE32
     ROUTE33
     ROUTE34
     ROUTE35
     ROUTE36
     ROUTE37
     ROUTE38
     ROUTE39
     ROUTE40
     ROUTE41
     ROUTE42
     ROUTE43
     ROUTE44
     ROUTE45
     ROUTE46
     ROUTE47
     ROUTE48
     ROUTE49
     ROUTE50
     ROUTE51
     ROUTE52
     DAY (LO THRU -1) /
     FWEIGHT (LO THRU -1.0000) /
   .

EXECUTE.

* Create SPSS system file.

*SAVE OUTFILE="spss-filename.sav".
