*-------------------------------------------------------------------------*
*                                                                          
*                     SPSS SETUP FILE FOR ICPSR 31264
*                 DRUG ABUSE WARNING NETWORK (DAWN), 2008
* 
*
*  SPSS setup sections are provided for the ASCII version of this data
*  collection.  These sections are listed below:
*
*  DATA LIST:  assigns the name, type, decimal specification (if any),
*  and specifies the beginning and ending column locations for each
*  variable in the data file. Users must replace the "data-filename"
*  in the DATA LIST statement with a filename specifying the directory
*  on the user's computer system in which the downloaded and unzipped
*  data file is physically located (e.g., "c:\temp\31264-0001-data.txt").
*
*  VARIABLE LABELS:  assigns descriptive labels to all variables.
*  Labels and variable names may be identical for some data files.
*
*  MISSING VALUES: declares user-defined missing values. Not all
*  variables in this data set necessarily have user-defined missing
*  values. These values can be treated specially in data transformations,
*  statistical calculations, and case selection.
*
*  VALUE LABELS: assigns descriptive labels to codes found in the data
*  file.  Not all codes necessarily have assigned value labels.
*
*  VARIABLE LEVEL: assigns measurement level to each variable (scale,
*  nominal, or ordinal).
*
*  NOTE:  Users should modify this setup file to suit their specific
*  needs. The MISSING VALUES section has been commented out (i.e., '*').
*  To include the MISSING VALUES section in the final SPSS setup, remove
*  the comment indicators from the desired section.
*
*  CREATING A PERMANENT SPSS DATA FILE: If users wish to create and save
*  an SPSS data file for further analysis using SPSS for Windows, the
*  necessary "SAVE OUTFILE" command is provided in the last line of
*  this file.  To activate the command, users must delete the leading
*  asterisk (*) and replace "spss-filename" with a filename specifying
*  the location on the user's computer system to which the new data file
*  will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\da31264-0001.sav").
*
*-------------------------------------------------------------------------.

* SPSS FILE HANDLE AND DATA LIST COMMANDS.

FILE HANDLE DATA / NAME="data-filename" LRECL=903.
DATA LIST FILE=DATA /
              CASEID 1-6               METRO 7-8             STRATA 9-10
               PSU 11-13            REPLICATE 14      CASEWGT 15-29 (10)
          PSUFRAME 30-33            AGECAT 34-35               SEX 36-37
              RACE 38-39              YEAR 40-43              QUARTER 44
              DAYPART 45           NUMSUBS 46-47          DRUGID_1 48-51
         CATID_1_1 52-55         CATID_2_1 56-59         CATID_3_1 60-63
           ROUTE_1 64-65         TOXTEST_1 66-67         SDLED_1_1 68-69
     SDLED_2_1 70-74 (2)     SDLED_3_1 75-79 (2)     SDLED_4_1 80-86 (4)
     SDLED_5_1 87-93 (4)    SDLED_6_1 94-100 (4)        DRUGID_2 101-104
       CATID_1_2 105-108       CATID_2_2 109-112       CATID_3_2 113-116
         ROUTE_2 117-118       TOXTEST_2 119-120       SDLED_1_2 121-122
   SDLED_2_2 123-127 (2)   SDLED_3_2 128-132 (2)   SDLED_4_2 133-139 (4)
   SDLED_5_2 140-146 (4)   SDLED_6_2 147-153 (4)        DRUGID_3 154-157
       CATID_1_3 158-161       CATID_2_3 162-165       CATID_3_3 166-169
         ROUTE_3 170-171       TOXTEST_3 172-173       SDLED_1_3 174-175
   SDLED_2_3 176-180 (2)   SDLED_3_3 181-185 (2)   SDLED_4_3 186-192 (4)
   SDLED_5_3 193-199 (4)   SDLED_6_3 200-206 (4)        DRUGID_4 207-210
       CATID_1_4 211-214       CATID_2_4 215-218       CATID_3_4 219-222
         ROUTE_4 223-224       TOXTEST_4 225-226       SDLED_1_4 227-228
   SDLED_2_4 229-233 (2)   SDLED_3_4 234-238 (2)   SDLED_4_4 239-245 (4)
   SDLED_5_4 246-252 (4)   SDLED_6_4 253-259 (4)        DRUGID_5 260-263
       CATID_1_5 264-267       CATID_2_5 268-271       CATID_3_5 272-275
         ROUTE_5 276-277       TOXTEST_5 278-279       SDLED_1_5 280-281
   SDLED_2_5 282-286 (2)   SDLED_3_5 287-291 (2)   SDLED_4_5 292-298 (4)
   SDLED_5_5 299-305 (4)   SDLED_6_5 306-312 (4)        DRUGID_6 313-316
       CATID_1_6 317-320       CATID_2_6 321-324       CATID_3_6 325-328
         ROUTE_6 329-330       TOXTEST_6 331-332       SDLED_1_6 333-334
   SDLED_2_6 335-339 (2)   SDLED_3_6 340-344 (2)   SDLED_4_6 345-351 (4)
   SDLED_5_6 352-358 (4)   SDLED_6_6 359-365 (4)        DRUGID_7 366-369
       CATID_1_7 370-373       CATID_2_7 374-377       CATID_3_7 378-381
         ROUTE_7 382-383       TOXTEST_7 384-385       SDLED_1_7 386-387
   SDLED_2_7 388-392 (2)   SDLED_3_7 393-397 (2)   SDLED_4_7 398-404 (4)
   SDLED_5_7 405-411 (4)   SDLED_6_7 412-418 (4)        DRUGID_8 419-422
       CATID_1_8 423-426       CATID_2_8 427-430       CATID_3_8 431-434
         ROUTE_8 435-436       TOXTEST_8 437-438       SDLED_1_8 439-440
   SDLED_2_8 441-445 (2)   SDLED_3_8 446-450 (2)   SDLED_4_8 451-457 (4)
   SDLED_5_8 458-464 (4)   SDLED_6_8 465-471 (4)        DRUGID_9 472-475
       CATID_1_9 476-479       CATID_2_9 480-483       CATID_3_9 484-487
         ROUTE_9 488-489       TOXTEST_9 490-491       SDLED_1_9 492-493
   SDLED_2_9 494-498 (2)   SDLED_3_9 499-503 (2)   SDLED_4_9 504-510 (4)
   SDLED_5_9 511-517 (4)   SDLED_6_9 518-524 (4)       DRUGID_10 525-528
      CATID_1_10 529-532      CATID_2_10 533-536      CATID_3_10 537-540
        ROUTE_10 541-542      TOXTEST_10 543-544      SDLED_1_10 545-546
  SDLED_2_10 547-551 (2)  SDLED_3_10 552-556 (2)  SDLED_4_10 557-563 (4)
  SDLED_5_10 564-570 (4)  SDLED_6_10 571-577 (4)       DRUGID_11 578-581
      CATID_1_11 582-585      CATID_2_11 586-589      CATID_3_11 590-593
        ROUTE_11 594-595      TOXTEST_11 596-597      SDLED_1_11 598-599
  SDLED_2_11 600-604 (2)  SDLED_3_11 605-609 (2)  SDLED_4_11 610-616 (4)
  SDLED_5_11 617-623 (4)  SDLED_6_11 624-630 (4)       DRUGID_12 631-634
      CATID_1_12 635-638      CATID_2_12 639-642      CATID_3_12 643-646
        ROUTE_12 647-648      TOXTEST_12 649-650      SDLED_1_12 651-652
  SDLED_2_12 653-657 (2)  SDLED_3_12 658-662 (2)  SDLED_4_12 663-669 (4)
  SDLED_5_12 670-676 (4)  SDLED_6_12 677-683 (4)       DRUGID_13 684-687
      CATID_1_13 688-691      CATID_2_13 692-695      CATID_3_13 696-699
        ROUTE_13 700-701      TOXTEST_13 702-703      SDLED_1_13 704-705
  SDLED_2_13 706-710 (2)  SDLED_3_13 711-715 (2)  SDLED_4_13 716-722 (4)
  SDLED_5_13 723-729 (4)  SDLED_6_13 730-736 (4)       DRUGID_14 737-740
      CATID_1_14 741-744      CATID_2_14 745-748      CATID_3_14 749-752
        ROUTE_14 753-754      TOXTEST_14 755-756      SDLED_1_14 757-758
  SDLED_2_14 759-763 (2)  SDLED_3_14 764-768 (2)  SDLED_4_14 769-775 (4)
  SDLED_5_14 776-782 (4)  SDLED_6_14 783-789 (4)       DRUGID_15 790-793
      CATID_1_15 794-797      CATID_2_15 798-801      CATID_3_15 802-805
        ROUTE_15 806-807      TOXTEST_15 808-809      SDLED_1_15 810-811
  SDLED_2_15 812-816 (2)  SDLED_3_15 817-821 (2)  SDLED_4_15 822-828 (4)
  SDLED_5_15 829-835 (4)  SDLED_6_15 836-842 (4)       DRUGID_16 843-846
      CATID_1_16 847-850      CATID_2_16 851-854      CATID_3_16 855-858
        ROUTE_16 859-860      TOXTEST_16 861-862      SDLED_1_16 863-864
  SDLED_2_16 865-869 (2)  SDLED_3_16 870-874 (2)  SDLED_4_16 875-881 (4)
  SDLED_5_16 882-888 (4)  SDLED_6_16 889-895 (4)            CASETYPE 896
     DISPOSITION 897-898             ALCOHOL 899           NONALCILL 900
              PHARMA 901        NONMEDPHARMA 902            ALLABUSE 903
   .

* SPSS VARIABLE LABELS COMMAND

VARIABLE LABELS
   CASEID    'CASE IDENTIFICATION NUMBER' /
   METRO     'OVERSAMPLED METROPOLITAN STATISTICAL AREA (MSA)' /
   STRATA    'VARIANCE ESTIMATION STRATUM' /
   PSU       'PRIMARY SAMPLING UNIT' /
   REPLICATE 'REPLICATE' /
   CASEWGT   'CASE WEIGHT' /
   PSUFRAME  'PSU FRAME COUNT' /
   AGECAT    'AGE - CATEGORIZED' /
   SEX       'GENDER' /
   RACE      'RACE / ETHNICITY - RECODED' /
   YEAR      'YEAR OF ED VISIT' /
   QUARTER   'QUARTER OF ED VISIT' /
   DAYPART   'PART OF DAY OF ED VISIT' /
   NUMSUBS   'UNIQUE NUMBER OF DRUGS REPORTED' /
   DRUGID_1  'DRUG ID NUMBER MENTION 1' /
   CATID_1_1 'MULTUM CATEGORY 1 CODE MENTION 1' /
   CATID_2_1 'MULTUM CATEGORY 2 CODE MENTION 1' /
   CATID_3_1 'MULTUM CATEGORY 3 CODE MENTION 1' /
   ROUTE_1   'ROUTE OF ADMINISTRATION MENTION 1' /
   TOXTEST_1 'CONFIRMED BY TOXICOLOGY TEST MENTION 1' /
   SDLED_1_1 'ED STANDARD DRUG LIST 1 CODE MENTION 1' /
   SDLED_2_1 'ED STANDARD DRUG LIST 2 CODE MENTION 1' /
   SDLED_3_1 'ED STANDARD DRUG LIST 3 CODE MENTION 1' /
   SDLED_4_1 'ED STANDARD DRUG LIST 4 CODE MENTION 1' /
   SDLED_5_1 'ED STANDARD DRUG LIST 5 CODE MENTION 1' /
   SDLED_6_1 'ED STANDARD DRUG LIST 6 CODE MENTION 1' /
   DRUGID_2  'DRUG ID NUMBER MENTION 2' /
   CATID_1_2 'MULTUM CATEGORY 1 CODE MENTION 2' /
   CATID_2_2 'MULTUM CATEGORY 2 CODE MENTION 2' /
   CATID_3_2 'MULTUM CATEGORY 3 CODE MENTION 2' /
   ROUTE_2   'ROUTE OF ADMINISTRATION MENTION 2' /
   TOXTEST_2 'CONFIRMED BY TOXICOLOGY TEST MENTION 2' /
   SDLED_1_2 'ED STANDARD DRUG LIST 1 CODE MENTION 2' /
   SDLED_2_2 'ED STANDARD DRUG LIST 2 CODE MENTION 2' /
   SDLED_3_2 'ED STANDARD DRUG LIST 3 CODE MENTION 2' /
   SDLED_4_2 'ED STANDARD DRUG LIST 4 CODE MENTION 2' /
   SDLED_5_2 'ED STANDARD DRUG LIST 5 CODE MENTION 2' /
   SDLED_6_2 'ED STANDARD DRUG LIST 6 CODE MENTION 2' /
   DRUGID_3  'DRUG ID NUMBER MENTION 3' /
   CATID_1_3 'MULTUM CATEGORY 1 CODE MENTION 3' /
   CATID_2_3 'MULTUM CATEGORY 2 CODE MENTION 3' /
   CATID_3_3 'MULTUM CATEGORY 3 CODE MENTION 3' /
   ROUTE_3   'ROUTE OF ADMINISTRATION MENTION 3' /
   TOXTEST_3 'CONFIRMED BY TOXICOLOGY TEST MENTION 3' /
   SDLED_1_3 'ED STANDARD DRUG LIST 1 CODE MENTION 3' /
   SDLED_2_3 'ED STANDARD DRUG LIST 2 CODE MENTION 3' /
   SDLED_3_3 'ED STANDARD DRUG LIST 3 CODE MENTION 3' /
   SDLED_4_3 'ED STANDARD DRUG LIST 4 CODE MENTION 3' /
   SDLED_5_3 'ED STANDARD DRUG LIST 5 CODE MENTION 3' /
   SDLED_6_3 'ED STANDARD DRUG LIST 6 CODE MENTION 3' /
   DRUGID_4  'DRUG ID NUMBER MENTION 4' /
   CATID_1_4 'MULTUM CATEGORY 1 CODE MENTION 4' /
   CATID_2_4 'MULTUM CATEGORY 2 CODE MENTION 4' /
   CATID_3_4 'MULTUM CATEGORY 3 CODE MENTION 4' /
   ROUTE_4   'ROUTE OF ADMINISTRATION MENTION 4' /
   TOXTEST_4 'CONFIRMED BY TOXICOLOGY TEST MENTION 4' /
   SDLED_1_4 'ED STANDARD DRUG LIST 1 CODE MENTION 4' /
   SDLED_2_4 'ED STANDARD DRUG LIST 2 CODE MENTION 4' /
   SDLED_3_4 'ED STANDARD DRUG LIST 3 CODE MENTION 4' /
   SDLED_4_4 'ED STANDARD DRUG LIST 4 CODE MENTION 4' /
   SDLED_5_4 'ED STANDARD DRUG LIST 5 CODE MENTION 4' /
   SDLED_6_4 'ED STANDARD DRUG LIST 6 CODE MENTION 4' /
   DRUGID_5  'DRUG ID NUMBER MENTION 5' /
   CATID_1_5 'MULTUM CATEGORY 1 CODE MENTION 5' /
   CATID_2_5 'MULTUM CATEGORY 2 CODE MENTION 5' /
   CATID_3_5 'MULTUM CATEGORY 3 CODE MENTION 5' /
   ROUTE_5   'ROUTE OF ADMINISTRATION MENTION 5' /
   TOXTEST_5 'CONFIRMED BY TOXICOLOGY TEST MENTION 5' /
   SDLED_1_5 'ED STANDARD DRUG LIST 1 CODE MENTION 5' /
   SDLED_2_5 'ED STANDARD DRUG LIST 2 CODE MENTION 5' /
   SDLED_3_5 'ED STANDARD DRUG LIST 3 CODE MENTION 5' /
   SDLED_4_5 'ED STANDARD DRUG LIST 4 CODE MENTION 5' /
   SDLED_5_5 'ED STANDARD DRUG LIST 5 CODE MENTION 5' /
   SDLED_6_5 'ED STANDARD DRUG LIST 6 CODE MENTION 5' /
   DRUGID_6  'DRUG ID NUMBER MENTION 6' /
   CATID_1_6 'MULTUM CATEGORY 1 CODE MENTION 6' /
   CATID_2_6 'MULTUM CATEGORY 2 CODE MENTION 6' /
   CATID_3_6 'MULTUM CATEGORY 3 CODE MENTION 6' /
   ROUTE_6   'ROUTE OF ADMINISTRATION MENTION 6' /
   TOXTEST_6 'CONFIRMED BY TOXICOLOGY TEST MENTION 6' /
   SDLED_1_6 'ED STANDARD DRUG LIST 1 CODE MENTION 6' /
   SDLED_2_6 'ED STANDARD DRUG LIST 2 CODE MENTION 6' /
   SDLED_3_6 'ED STANDARD DRUG LIST 3 CODE MENTION 6' /
   SDLED_4_6 'ED STANDARD DRUG LIST 4 CODE MENTION 6' /
   SDLED_5_6 'ED STANDARD DRUG LIST 5 CODE MENTION 6' /
   SDLED_6_6 'ED STANDARD DRUG LIST 6 CODE MENTION 6' /
   DRUGID_7  'DRUG ID NUMBER MENTION 7' /
   CATID_1_7 'MULTUM CATEGORY 1 CODE MENTION 7' /
   CATID_2_7 'MULTUM CATEGORY 2 CODE MENTION 7' /
   CATID_3_7 'MULTUM CATEGORY 3 CODE MENTION 7' /
   ROUTE_7   'ROUTE OF ADMINISTRATION MENTION 7' /
   TOXTEST_7 'CONFIRMED BY TOXICOLOGY TEST MENTION 7' /
   SDLED_1_7 'ED STANDARD DRUG LIST 1 CODE MENTION 7' /
   SDLED_2_7 'ED STANDARD DRUG LIST 2 CODE MENTION 7' /
   SDLED_3_7 'ED STANDARD DRUG LIST 3 CODE MENTION 7' /
   SDLED_4_7 'ED STANDARD DRUG LIST 4 CODE MENTION 7' /
   SDLED_5_7 'ED STANDARD DRUG LIST 5 CODE MENTION 7' /
   SDLED_6_7 'ED STANDARD DRUG LIST 6 CODE MENTION 7' /
   DRUGID_8  'DRUG ID NUMBER MENTION 8' /
   CATID_1_8 'MULTUM CATEGORY 1 CODE MENTION 8' /
   CATID_2_8 'MULTUM CATEGORY 2 CODE MENTION 8' /
   CATID_3_8 'MULTUM CATEGORY 3 CODE MENTION 8' /
   ROUTE_8   'ROUTE OF ADMINISTRATION MENTION 8' /
   TOXTEST_8 'CONFIRMED BY TOXICOLOGY TEST MENTION 8' /
   SDLED_1_8 'ED STANDARD DRUG LIST 1 CODE MENTION 8' /
   SDLED_2_8 'ED STANDARD DRUG LIST 2 CODE MENTION 8' /
   SDLED_3_8 'ED STANDARD DRUG LIST 3 CODE MENTION 8' /
   SDLED_4_8 'ED STANDARD DRUG LIST 4 CODE MENTION 8' /
   SDLED_5_8 'ED STANDARD DRUG LIST 5 CODE MENTION 8' /
   SDLED_6_8 'ED STANDARD DRUG LIST 6 CODE MENTION 8' /
   DRUGID_9  'DRUG ID NUMBER MENTION 9' /
   CATID_1_9 'MULTUM CATEGORY 1 CODE MENTION 9' /
   CATID_2_9 'MULTUM CATEGORY 2 CODE MENTION 9' /
   CATID_3_9 'MULTUM CATEGORY 3 CODE MENTION 9' /
   ROUTE_9   'ROUTE OF ADMINISTRATION MENTION 9' /
   TOXTEST_9 'CONFIRMED BY TOXICOLOGY TEST MENTION 9' /
   SDLED_1_9 'ED STANDARD DRUG LIST 1 CODE MENTION 9' /
   SDLED_2_9 'ED STANDARD DRUG LIST 2 CODE MENTION 9' /
   SDLED_3_9 'ED STANDARD DRUG LIST 3 CODE MENTION 9' /
   SDLED_4_9 'ED STANDARD DRUG LIST 4 CODE MENTION 9' /
   SDLED_5_9 'ED STANDARD DRUG LIST 5 CODE MENTION 9' /
   SDLED_6_9 'ED STANDARD DRUG LIST 6 CODE MENTION 9' /
   DRUGID_10 'DRUG ID NUMBER MENTION 10' /
   CATID_1_10 'MULTUM CATEGORY 1 CODE MENTION 10' /
   CATID_2_10 'MULTUM CATEGORY 2 CODE MENTION 10' /
   CATID_3_10 'MULTUM CATEGORY 3 CODE MENTION 10' /
   ROUTE_10  'ROUTE OF ADMINISTRATION MENTION 10' /
   TOXTEST_10 'CONFIRMED BY TOXICOLOGY TEST MENTION 10' /
   SDLED_1_10 'ED STANDARD DRUG LIST 1 CODE MENTION 10' /
   SDLED_2_10 'ED STANDARD DRUG LIST 2 CODE MENTION 10' /
   SDLED_3_10 'ED STANDARD DRUG LIST 3 CODE MENTION 10' /
   SDLED_4_10 'ED STANDARD DRUG LIST 4 CODE MENTION 10' /
   SDLED_5_10 'ED STANDARD DRUG LIST 5 CODE MENTION 10' /
   SDLED_6_10 'ED STANDARD DRUG LIST 6 CODE MENTION 10' /
   DRUGID_11 'DRUG ID NUMBER MENTION 11' /
   CATID_1_11 'MULTUM CATEGORY 1 CODE MENTION 11' /
   CATID_2_11 'MULTUM CATEGORY 2 CODE MENTION 11' /
   CATID_3_11 'MULTUM CATEGORY 3 CODE MENTION 11' /
   ROUTE_11  'ROUTE OF ADMINISTRATION MENTION 11' /
   TOXTEST_11 'CONFIRMED BY TOXICOLOGY TEST MENTION 11' /
   SDLED_1_11 'ED STANDARD DRUG LIST 1 CODE MENTION 11' /
   SDLED_2_11 'ED STANDARD DRUG LIST 2 CODE MENTION 11' /
   SDLED_3_11 'ED STANDARD DRUG LIST 3 CODE MENTION 11' /
   SDLED_4_11 'ED STANDARD DRUG LIST 4 CODE MENTION 11' /
   SDLED_5_11 'ED STANDARD DRUG LIST 5 CODE MENTION 11' /
   SDLED_6_11 'ED STANDARD DRUG LIST 6 CODE MENTION 11' /
   DRUGID_12 'DRUG ID NUMBER MENTION 12' /
   CATID_1_12 'MULTUM CATEGORY 1 CODE MENTION 12' /
   CATID_2_12 'MULTUM CATEGORY 2 CODE MENTION 12' /
   CATID_3_12 'MULTUM CATEGORY 3 CODE MENTION 12' /
   ROUTE_12  'ROUTE OF ADMINISTRATION MENTION 12' /
   TOXTEST_12 'CONFIRMED BY TOXICOLOGY TEST MENTION 12' /
   SDLED_1_12 'ED STANDARD DRUG LIST 1 CODE MENTION 12' /
   SDLED_2_12 'ED STANDARD DRUG LIST 2 CODE MENTION 12' /
   SDLED_3_12 'ED STANDARD DRUG LIST 3 CODE MENTION 12' /
   SDLED_4_12 'ED STANDARD DRUG LIST 4 CODE MENTION 12' /
   SDLED_5_12 'ED STANDARD DRUG LIST 5 CODE MENTION 12' /
   SDLED_6_12 'ED STANDARD DRUG LIST 6 CODE MENTION 12' /
   DRUGID_13 'DRUG ID NUMBER MENTION 13' /
   CATID_1_13 'MULTUM CATEGORY 1 CODE MENTION 13' /
   CATID_2_13 'MULTUM CATEGORY 2 CODE MENTION 13' /
   CATID_3_13 'MULTUM CATEGORY 3 CODE MENTION 13' /
   ROUTE_13  'ROUTE OF ADMINISTRATION MENTION 13' /
   TOXTEST_13 'CONFIRMED BY TOXICOLOGY TEST MENTION 13' /
   SDLED_1_13 'ED STANDARD DRUG LIST 1 CODE MENTION 13' /
   SDLED_2_13 'ED STANDARD DRUG LIST 2 CODE MENTION 13' /
   SDLED_3_13 'ED STANDARD DRUG LIST 3 CODE MENTION 13' /
   SDLED_4_13 'ED STANDARD DRUG LIST 4 CODE MENTION 13' /
   SDLED_5_13 'ED STANDARD DRUG LIST 5 CODE MENTION 13' /
   SDLED_6_13 'ED STANDARD DRUG LIST 6 CODE MENTION 13' /
   DRUGID_14 'DRUG ID NUMBER MENTION 14' /
   CATID_1_14 'MULTUM CATEGORY 1 CODE MENTION 14' /
   CATID_2_14 'MULTUM CATEGORY 2 CODE MENTION 14' /
   CATID_3_14 'MULTUM CATEGORY 3 CODE MENTION 14' /
   ROUTE_14  'ROUTE OF ADMINISTRATION MENTION 14' /
   TOXTEST_14 'CONFIRMED BY TOXICOLOGY TEST MENTION 14' /
   SDLED_1_14 'ED STANDARD DRUG LIST 1 CODE MENTION 14' /
   SDLED_2_14 'ED STANDARD DRUG LIST 2 CODE MENTION 14' /
   SDLED_3_14 'ED STANDARD DRUG LIST 3 CODE MENTION 14' /
   SDLED_4_14 'ED STANDARD DRUG LIST 4 CODE MENTION 14' /
   SDLED_5_14 'ED STANDARD DRUG LIST 5 CODE MENTION 14' /
   SDLED_6_14 'ED STANDARD DRUG LIST 6 CODE MENTION 14' /
   DRUGID_15 'DRUG ID NUMBER MENTION 15' /
   CATID_1_15 'MULTUM CATEGORY 1 CODE MENTION 15' /
   CATID_2_15 'MULTUM CATEGORY 2 CODE MENTION 15' /
   CATID_3_15 'MULTUM CATEGORY 3 CODE MENTION 15' /
   ROUTE_15  'ROUTE OF ADMINISTRATION MENTION 15' /
   TOXTEST_15 'CONFIRMED BY TOXICOLOGY TEST MENTION 15' /
   SDLED_1_15 'ED STANDARD DRUG LIST 1 CODE MENTION 15' /
   SDLED_2_15 'ED STANDARD DRUG LIST 2 CODE MENTION 15' /
   SDLED_3_15 'ED STANDARD DRUG LIST 3 CODE MENTION 15' /
   SDLED_4_15 'ED STANDARD DRUG LIST 4 CODE MENTION 15' /
   SDLED_5_15 'ED STANDARD DRUG LIST 5 CODE MENTION 15' /
   SDLED_6_15 'ED STANDARD DRUG LIST 6 CODE MENTION 15' /
   DRUGID_16 'DRUG ID NUMBER MENTION 16' /
   CATID_1_16 'MULTUM CATEGORY 1 CODE MENTION 16' /
   CATID_2_16 'MULTUM CATEGORY 2 CODE MENTION 16' /
   CATID_3_16 'MULTUM CATEGORY 3 CODE MENTION 16' /
   ROUTE_16  'ROUTE OF ADMINISTRATION MENTION 16' /
   TOXTEST_16 'CONFIRMED BY TOXICOLOGY TEST MENTION 16' /
   SDLED_1_16 'ED STANDARD DRUG LIST 1 CODE MENTION 16' /
   SDLED_2_16 'ED STANDARD DRUG LIST 2 CODE MENTION 16' /
   SDLED_3_16 'ED STANDARD DRUG LIST 3 CODE MENTION 16' /
   SDLED_4_16 'ED STANDARD DRUG LIST 4 CODE MENTION 16' /
   SDLED_5_16 'ED STANDARD DRUG LIST 5 CODE MENTION 16' /
   SDLED_6_16 'ED STANDARD DRUG LIST 6 CODE MENTION 16' /
   CASETYPE  'TYPE OF VISIT' /
   DISPOSITION 'PATIENT DISPOSITION' /
   ALCOHOL   'VISIT INCLUDES ALCOHOL MENTION INDICATOR' /
   NONALCILL 'NON-ALCOHOL ILLICIT INDICATOR' /
   PHARMA    'ANY PHARMACEUTICALS INDICATOR' /
   NONMEDPHARMA 'NON-MEDICAL USE OF PHARMACEUTICALS INDICATOR' /
   ALLABUSE  'ALL MISUSE AND ABUSE INDICATOR' /
   .


* SPSS VALUE LABELS COMMAND.

VALUE LABELS
   METRO     1 'BOSTON-CAMBRIDGE-QUINCY, MA-NH MSA:(1)'
 2 'NEW YORK CITY - 5 BUROUGHS (PART OF NEW YORK- NEWARK-EDISON, NY-NJ-PA MSA):(2)'
             3 'CHICAGO-NAPERVILLE-JOLIET, IL-IN-WI MSA:(3)'
             4 'DETROIT-WARREN-LIVONIA, MI MSA:(4)'
             5 'MINNEAPOLIS-ST. PAUL-BLOOMINGTON, MN-WI MSA:(5)'
            6 'FORT LAUNDERALE DIVISION OF MIAMI-FORT LAUDERDALE, FL MSA:(6)'
             7 'DADE COUNTY DIVISION OF MIAMI-FORT LAUDERDALE, FL MSA:(7)'
             8 'HOUSTON-BAYTOWN-SUGAR LAND, TX MSA:(8)'
             9 'DENVER-AURORA, CO MSA:(9)'
             10 'PHOENIX-MESA-SCOTTSDALE, AZ MSA:(10)'
             11 'SAN DIEGO-CARLSBAD-SAN MARCOS, CA MSA:(11)'
            12 'SAN FRANCISCO DIVISION OF SAN FRANCISCO-OAKLAND, CA MSA:(12)'
             13 'SEATTLE-TACOMA-BELLEVUE, WA MSA:(13)'
             14 'ALL OTHER LOCATIONS:(14)' /
   AGECAT    -8 'NOT DOCUMENTED:(-8)' 1 'AGE 5 OR YOUNGER:(1)'
             2 '6 TO 11:(2)' 3 '12 TO 17:(3)' 4 '18 TO 20:(4)'
             5 '21 TO 24:(5)' 6 '25 TO 29:(6)' 7 '30 TO 34:(7)'
             8 '35 TO 44:(8)' 9 '45 TO 54:(9)' 10 '55 TO 64:(10)'
             11 'AGE 65 OR OLDER:(11)' /
   SEX       -8 'NOT DOCUMENTED:(-8)' 1 'MALE:(1)' 2 'FEMALE:(2)' /
   RACE      -8 'NOT DOCUMENTED:(-8)' 1 'WHITE ONLY:(1)'
             2 'BLACK OR AFRICAN AMERICAN ONLY:(2)'
             3 'ANY HISPANIC OR LATINO:(3)' 4 'ALL OTHER RACES:(4)' /
   QUARTER   1 '1ST (JANUARY TO MARCH):(1)' 2 '2ND (APRIL TO JUNE):(2)'
             3 '3RD (JULY TO SEPTEMBER):(3)'
             4 '4TH (OCTOBER TO DECEMBER):(4)' /
   DAYPART   1 'EARLY MORNING (12:00 - 5:59 A.M.):(1)'
             2 'MORNING (6:00 - 11:59 A.M.):(2)'
             3 'AFTERNOON (12:00 - 5:59 P.M.):(3)'
             4 'EVENING/NIGHT (6:00 - 11:59 P.M.):(4)' /
   DRUGID_1  -7 'NOT APPLICABLE' 1 'D00001 ACYCLOVIR' 2 'D00002 AMIODARONE'
             3 'D00003 AMPICILLIN' 4 'D00004 ATENOLOL' 5 'D00006 CAPTOPRIL'
             6 'D00007 CEFAZOLIN' 7 'D00008 CEFOTAXIME'
             8 'D00009 CEFTAZIDIME' 9 'D00010 CEFTIZOXIME'
             10 'D00011 CIPROFLOXACIN' 11 'D00012 CODEINE'
             12 'D00013 ENALAPRIL' 13 'D00014 GENTAMICIN'
             14 'D00015 IBUPROFEN' 15 'D00016 LABETALOL'
             16 'D00017 MEPERIDINE' 17 'D00018 NADOLOL' 18 'D00019 NAPROXEN'
             19 'D00020 QUINIDINE' 20 'D00021 RANITIDINE'
             21 'D00022 WARFARIN' 22 'D00023 ALLOPURINOL'
             23 'D00024 AZATHIOPRINE' 24 'D00025 CHLORAMPHENICOL'
             25 'D00026 FENOPROFEN' 26 'D00027 HALOPERIDOL'
             27 'D00028 KETOPROFEN' 28 'D00029 NAFCILLIN'
             29 'D00030 PENTAMIDINE' 30 'D00031 PROBENECID'
             31 'D00032 PROPRANOLOL' 32 'D00033 SULINDAC'
             33 'D00034 ZIDOVUDINE' 34 'D00035 CHLOROQUINE'
             35 'D00036 CYCLOPHOSPHAMIDE' 36 'D00037 DOXYCYCLINE'
             37 'D00038 FLUCYTOSINE' 38 'D00039 INDOMETHACIN'
             39 'D00040 OXAZEPAM' 40 'D00041 TETRACYCLINE'
             41 'D00042 CHLORPROPAMIDE' 42 'D00043 CLINDAMYCIN'
             43 'D00044 CLONIDINE' 44 'D00045 DILTIAZEM'
             45 'D00046 ERYTHROMYCIN' 46 'D00047 RIFAMPIN'
             47 'D00048 VERAPAMIL' 48 'D00049 ACETAMINOPHEN'
             49 'D00050 METHADONE' 50 'D00051 NIFEDIPINE'
             51 'D00052 CEFTRIAXONE' 52 'D00053 CEPHRADINE'
             53 'D00054 TOLMETIN' 54 'D00055 CEFOTETAN'
             55 'D00056 CEFUROXIME' 56 'D00057 PIPERACILLIN'
             57 'D00058 CARBAMAZEPINE' 58 'D00059 LIDOCAINE'
             59 'D00060 METHOTREXATE' 60 'D00061 LITHIUM'
             61 'D00062 CEFAMANDOLE' 62 'D00064 CHLORPROMAZINE'
             63 'D00065 FOSCARNET' 64 'D00066 GANCICLOVIR'
             65 'D00067 AZTREONAM' 66 'D00068 ETHAMBUTOL'
             67 'D00069 TOBRAMYCIN' 68 'D00070 FUROSEMIDE'
             69 'D00071 FLUCONAZOLE' 70 'D00072 CEFIXIME'
             71 'D00073 CEFPROZIL' 72 'D00074 CEFOPERAZONE'
             73 'D00075 PROCAINAMIDE' 74 'D00077 AMPHOTERICIN B'
             75 'D00078 DIDANOSINE' 76 'D00079 CYCLOSPORINE'
             77 'D00080 CEFADROXIL' 78 'D00081 CEFACLOR'
             79 'D00082 IMIPENEM-CILASTATIN' 80 'D00083 VALPROIC ACID'
             81 'D00084 PREDNISOLONE' 82 'D00085 RIBAVIRIN'
             83 'D00086 AMANTADINE' 84 'D00087 AMIKACIN'
             85 'D00088 AMOXICILLIN' 86 'D00089 AMOXICILLIN-CLAVULANATE'
             87 'D00090 AMPICILLIN-SULBACTAM' 88 'D00091 AZITHROMYCIN'
             89 'D00092 CARBENICILLIN' 90 'D00093 CEFMETAZOLE'
             91 'D00094 CEFOXITIN' 92 'D00095 CEFPODOXIME'
             93 'D00096 CEPHALEXIN' 94 'D00097 CLARITHROMYCIN'
             95 'D00098 DAPSONE' 96 'D00099 ENOXACIN'
             97 'D00100 GRISEOFULVIN' 98 'D00101 ISONIAZID'
             99 'D00102 ITRACONAZOLE' 100 'D00103 KETOCONAZOLE'
             101 'D00104 LOMEFLOXACIN' 102 'D00105 LORACARBEF'
             103 'D00106 METHENAMINE' 104 'D00107 METHICILLIN'
             105 'D00108 METRONIDAZOLE' 106 'D00109 MEZLOCILLIN'
             107 'D00110 MINOCYCLINE' 108 'D00112 NITROFURANTOIN'
             109 'D00113 NORFLOXACIN' 110 'D00114 OFLOXACIN'
             111 'D00115 OXACILLIN' 112 'D00116 PENICILLIN'
             113 'D00117 PYRAZINAMIDE' 114 'D00118 SULFADIAZINE'
             115 'D00119 SULFAMETHOXAZOLE' 116 'D00120 SULFISOXAZOLE'
             117 'D00121 TICARCILLIN' 118 'D00122 TICARCILLIN-CLAVULANATE'
             119 'D00123 TRIMETHOPRIM'
             120 'D00124 SULFAMETHOXAZOLE-TRIMETHOPRIM'
             121 'D00125 VANCOMYCIN' 122 'D00128 ACEBUTOLOL'
             123 'D00129 DIAZOXIDE' 124 'D00132 HYDRALAZINE'
             125 'D00133 METHYLDOPA' 126 'D00134 METOPROLOL'
             127 'D00135 MINOXIDIL' 128 'D00137 PINDOLOL'
             129 'D00138 PRAZOSIN' 130 'D00139 TIMOLOL'
             131 'D00140 CIMETIDINE' 132 'D00141 FAMOTIDINE'
             133 'D00142 THEOPHYLLINE' 134 'D00143 PHENYTOIN'
             135 'D00144 NORTRIPTYLINE' 136 'D00145 DESIPRAMINE'
             137 'D00146 AMITRIPTYLINE' 138 'D00147 CHLORAL HYDRATE'
             139 'D00148 DIAZEPAM' 140 'D00149 LORAZEPAM'
             141 'D00150 COLCHICINE' 142 'D00152 CLOXACILLIN'
             143 'D00153 DICLOXACILLIN' 144 'D00154 MEBENDAZOLE'
             145 'D00155 MICONAZOLE' 146 'D00157 NALIDIXIC ACID'
             147 'D00158 QUINACRINE' 148 'D00159 STREPTOMYCIN'
             149 'D00161 ACETAZOLAMIDE' 150 'D00164 ADENOSINE'
             151 'D00167 ALFENTANIL' 152 'D00168 ALPRAZOLAM'
             153 'D00169 AMILORIDE' 154 'D00170 ASPIRIN'
             155 'D00171 AMOBARBITAL' 156 'D00172 INAMRINONE'
             157 'D00173 ATRACURIUM' 158 'D00174 ATROPINE'
             159 'D00175 BENZTROPINE' 160 'D00176 BETAXOLOL'
             161 'D00177 BLEOMYCIN' 162 'D00178 BROMOCRIPTINE'
             163 'D00179 BUMETANIDE' 164 'D00180 BUPIVACAINE'
             165 'D00181 BUPROPION' 166 'D00182 BUSPIRONE'
             167 'D00183 BUSULFAN' 168 'D00184 CARBIDOPA'
             169 'D00185 CARBOPLATIN' 170 'D00186 CEPHALOTHIN'
             171 'D00187 CEPHAPIRIN' 172 'D00188 CHLORAMBUCIL'
             173 'D00189 CHLORDIAZEPOXIDE' 174 'D00190 CHLOROTHIAZIDE'
             175 'D00191 CHLORPHENIRAMINE' 176 'D00192 CHLORTHALIDONE'
             177 'D00193 CHOLESTYRAMINE' 178 'D00195 CISPLATIN'
             179 'D00197 CLONAZEPAM' 180 'D00198 CLORAZEPATE'
             181 'D00199 CLOZAPINE' 182 'D00200 CROMOLYN'
             183 'D00201 CYTARABINE' 184 'D00202 DACARBAZINE'
             185 'D00203 DACTINOMYCIN' 186 'D00204 DANAZOL'
             187 'D00205 DAUNORUBICIN' 188 'D00206 DEXAMETHASONE'
             189 'D00207 DEXTROMETHORPHAN' 190 'D00208 DIFLUNISAL'
             191 'D00209 DIGITOXIN' 192 'D00210 DIGOXIN'
             193 'D00211 DIHYDROERGOTAMINE' 194 'D00212 DIPHENHYDRAMINE'
             195 'D00213 DIPYRIDAMOLE' 196 'D00214 DISOPYRAMIDE'
             197 'D00215 DOBUTAMINE' 198 'D00216 DOPAMINE'
             199 'D00217 DOXEPIN' 200 'D00218 DOXORUBICIN'
             201 'D00219 DROPERIDOL' 202 'D00220 EDROPHONIUM'
             203 'D00222 ERGOTAMINE' 204 'D00223 EPOETIN ALFA'
             205 'D00224 ESMOLOL' 206 'D00226 ETHCHLORVYNOL'
             207 'D00227 ETHOSUXIMIDE' 208 'D00229 ETHINYL ESTRADIOL'
             209 'D00230 ETOPOSIDE' 210 'D00231 FELODIPINE'
             211 'D00233 FENTANYL' 212 'D00234 FLECAINIDE'
             213 'D00235 FLUOROURACIL' 214 'D00236 FLUOXETINE'
             215 'D00237 FLUPHENAZINE' 216 'D00238 FLURAZEPAM'
             217 'D00239 FLURBIPROFEN' 218 'D00240 FLUTAMIDE'
             219 'D00241 FOLIC ACID' 220 'D00242 FOSINOPRIL'
             221 'D00243 FURAZOLIDONE' 222 'D00245 GEMFIBROZIL'
             223 'D00246 GLIPIZIDE' 224 'D00248 GLYBURIDE'
             225 'D00250 GOLD SODIUM THIOMALATE' 226 'D00252 HEPARIN'
             227 'D00253 HYDROCHLOROTHIAZIDE' 228 'D00254 HYDROCORTISONE'
             229 'D00255 HYDROMORPHONE' 230 'D00256 IDARUBICIN'
             231 'D00257 IFOSFAMIDE' 232 'D00259 IMIPRAMINE'
             233 'D00260 INDAPAMIDE' 234 'D00262 INSULIN'
             235 'D00265 IPRATROPIUM' 236 'D00267 ISOFLURANE'
             237 'D00268 ISOSORBIDE DINITRATE'
             238 'D00269 ISOSORBIDE MONONITRATE' 239 'D00270 ISRADIPINE'
             240 'D00271 KANAMYCIN' 241 'D00272 KETAMINE'
             242 'D00273 KETOROLAC' 243 'D00275 LEUCOVORIN'
             244 'D00276 LEVAMISOLE' 245 'D00277 LEVODOPA'
             246 'D00278 LEVOTHYROXINE' 247 'D00279 LINCOMYCIN'
             248 'D00280 LOVASTATIN' 249 'D00282 MANNITOL'
             250 'D00283 MECLOFENAMATE' 251 'D00284 MEDROXYPROGESTERONE'
             252 'D00285 MEFENAMIC ACID' 253 'D00286 MEFLOQUINE'
             254 'D00287 MELPHALAN' 255 'D00288 MEPROBAMATE'
             256 'D00289 MERCAPTOPURINE' 257 'D00290 METHIMAZOLE'
             258 'D00292 METHSUXIMIDE' 259 'D00293 METHYLPREDNISOLONE'
             260 'D00295 METHYLTESTOSTERONE'
             261 'D00297 METIPRANOLOL OPHTHALMIC' 262 'D00298 METOCLOPRAMIDE'
             263 'D00299 METOLAZONE' 264 'D00300 MEXILETINE'
             265 'D00301 MIDAZOLAM' 266 'D00302 MILRINONE'
             267 'D00303 MISOPROSTOL' 268 'D00305 MITOMYCIN'
             269 'D00306 MITOXANTRONE' 270 'D00307 MORICIZINE'
             271 'D00308 MORPHINE' 272 'D00310 NABUMETONE'
             273 'D00311 NALOXONE' 274 'D00312 NEOMYCIN'
             275 'D00313 NEOSTIGMINE' 276 'D00314 NIACIN'
             277 'D00315 NICARDIPINE' 278 'D00316 NICOTINE'
             279 'D00318 NIMODIPINE' 280 'D00321 NITROGLYCERIN'
             281 'D00322 NIZATIDINE' 282 'D00323 NOREPINEPHRINE'
             283 'D00325 OMEPRAZOLE' 284 'D00328 OXYBUTYNIN'
             285 'D00329 OXYCODONE' 286 'D00330 PANCURONIUM'
             287 'D00331 PARAAMINOBENZOIC ACID' 288 'D00332 PENBUTOLOL'
             289 'D00333 PENICILLAMINE' 290 'D00334 PENTAZOCINE'
             291 'D00335 PENTOBARBITAL' 292 'D00336 PENTOXIFYLLINE'
             293 'D00337 PHENAZOPYRIDINE' 294 'D00340 PHENOBARBITAL'
             295 'D00341 PHENYLBUTAZONE' 296 'D00342 PHYSOSTIGMINE'
             297 'D00343 PIROXICAM' 298 'D00344 POLYMYXIN B SULFATE'
             299 'D00345 POTASSIUM CHLORIDE'
             300 'D00346 POVIDONE IODINE TOPICAL' 301 'D00348 PRAVASTATIN'
             302 'D00349 PRAZIQUANTEL' 303 'D00350 PREDNISONE'
             304 'D00351 PRIMAQUINE' 305 'D00352 PRIMIDONE'
             306 'D00353 PROBUCOL' 307 'D00354 PROCARBAZINE'
             308 'D00355 PROCHLORPERAZINE' 309 'D00356 PROMAZINE'
             310 'D00358 PROPAFENONE' 311 'D00359 PROPANTHELINE'
             312 'D00360 PROPOXYPHENE' 313 'D00361 PROPYLTHIOURACIL'
             314 'D00362 PROTAMINE' 315 'D00363 PYRIDOSTIGMINE'
             316 'D00364 PYRIMETHAMINE' 317 'D00365 QUINAPRIL'
             318 'D00366 QUININE' 319 'D00367 RESERPINE'
             320 'D00368 SECOBARBITAL' 321 'D00370 OCTREOTIDE'
             322 'D00371 SOTALOL' 323 'D00373 SPIRONOLACTONE'
             324 'D00374 STREPTOKINASE' 325 'D00375 STREPTOZOCIN'
             326 'D00376 SUCCINYLCHOLINE' 327 'D00377 SUCRALFATE'
             328 'D00378 SUFENTANIL' 329 'D00379 SULFASALAZINE'
             330 'D00381 TAMOXIFEN' 331 'D00384 TEMAZEPAM'
             332 'D00386 TERAZOSIN' 333 'D00387 TERFENADINE'
             334 'D00388 THIOPENTAL' 335 'D00389 THIORIDAZINE'
             336 'D00391 THIOTHIXENE' 337 'D00393 TOLAZAMIDE'
             338 'D00394 TOLBUTAMIDE' 339 'D00395 TRAZODONE'
             340 'D00396 TRIAMTERENE' 341 'D00397 TRIAZOLAM'
             342 'D00398 VASOPRESSIN' 343 'D00399 VECURONIUM'
             344 'D00400 VINBLASTINE' 345 'D00401 VINCRISTINE'
             346 'D00402 VITAMIN A' 347 'D00405 VITAMIN E'
             348 'D00409 RIBOFLAVIN' 349 'D00412 PYRIDOXINE'
             350 'D00413 CYANOCOBALAMIN' 351 'D00417 BIOFLAVONOIDS'
             352 'D00425 CALCIUM CARBONATE' 353 'D00426 ASCORBIC ACID'
             354 'D00427 POTASSIUM PHOSPHATE-SODIUM PHOSPHATE'
             355 'D00428 FLUORIDE' 356 'D00438 SODIUM CHLORIDE'
             357 'D00439 CITRIC ACID-POTASSIUM CITRATE'
             358 'D00440 SODIUM BICARBONATE' 359 'D00468 MAGNESIUM SULFATE'
             360 'D00471 SODIUM ACETATE' 361 'D00472 TROMETHAMINE'
             362 'D00475 SODIUM PHOSPHATE' 363 'D00476 AMMONIUM CHLORIDE'
             364 'D00481 AMMONIUM MOLYBDATE TETRAHYDRATE'
             365 'D00484 SELENIUM' 366 'D00485 IODINE TOPICAL'
             367 'D00487 GLUTAMIC ACID' 368 'D00488 LYSINE'
             369 'D00491 LEVOCARNITINE' 370 'D00496 INOSITOL'
             371 'D00497 OMEGA-3 POLYUNSATURATED FATTY ACIDS'
             372 'D00512 FILGRASTIM' 373 'D00513 SARGRAMOSTIM'
             374 'D00514 TICLOPIDINE' 375 'D00519 ANISINDIONE'
             376 'D00521 ALTEPLASE' 377 'D00523 UROKINASE'
             378 'D00524 ANTITHROMBIN III'
             379 'D00525 ANTIHEMOPHILIC FACTOR (OBSOLETE)'
             380 'D00526 ANTI-INHIBITOR COAGULANT COMPLEX'
             381 'D00527 FACTOR IX COMPLEX (OBSOLETE)'
             382 'D00528 AMINOCAPROIC ACID' 383 'D00529 TRANEXAMIC ACID'
             384 'D00534 ESTRONE' 385 'D00537 ESTRADIOL'
             386 'D00541 CONJUGATED ESTROGENS'
             387 'D00542 ESTERIFIED ESTROGENS' 388 'D00543 ESTROPIPATE'
             389 'D00546 DIETHYLSTILBESTROL' 390 'D00550 PROGESTERONE'
             391 'D00554 HYDROXYPROGESTERONE' 392 'D00555 NORETHINDRONE'
             393 'D00557 LEVONORGESTREL' 394 'D00558 TESTOSTERONE'
             395 'D00562 FLUOXYMESTERONE' 396 'D00563 FINASTERIDE'
             397 'D00565 STANOZOLOL' 398 'D00566 OXANDROLONE'
             399 'D00568 NANDROLONE' 400 'D00569 CLOMIPHENE'
             401 'D00570 UROFOLLITROPIN' 402 'D00571 MENOTROPINS'
             403 'D00572 CHORIONIC GONADOTROPIN (HCG)' 404 'D00574 NAFARELIN'
             405 'D00575 HISTRELIN' 406 'D00576 SOMATREM'
             407 'D00577 SOMATROPIN' 408 'D00578 ARGININE'
             409 'D00583 DESMOPRESSIN' 410 'D00584 OXYTOCIN'
             411 'D00586 ERGONOVINE' 412 'D00587 METHYLERGONOVINE'
             413 'D00589 DINOPROSTONE TOPICAL' 414 'D00592 METYRAPONE'
             415 'D00593 GLUCAGON' 416 'D00595 GLUCOSE'
             417 'D00598 CALCITONIN' 418 'D00599 ETIDRONATE'
             419 'D00601 PAMIDRONATE' 420 'D00602 GALLIUM NITRATE'
             421 'D00603 RITODRINE' 422 'D00604 CORTICOTROPIN'
             423 'D00607 COSYNTROPIN' 424 'D00608 FLUDROCORTISONE'
             425 'D00609 CORTISONE' 426 'D00620 TRIAMCINOLONE'
             427 'D00626 DEXAMETHASONE TOPICAL' 428 'D00628 BETAMETHASONE'
             429 'D00640 METHAZOLAMIDE' 430 'D00641 BENDROFLUMETHIAZIDE'
             431 'D00643 METHYCLOTHIAZIDE' 432 'D00644 BENZTHIAZIDE'
             433 'D00645 HYDROFLUMETHIAZIDE' 434 'D00646 TRICHLORMETHIAZIDE'
             435 'D00647 POLYTHIAZIDE' 436 'D00649 ETHACRYNIC ACID'
             437 'D00651 UREA TOPICAL' 438 'D00652 GLYCERIN'
             439 'D00653 ISOSORBIDE' 440 'D00655 THYROID DESICCATED'
             441 'D00658 LIOTHYRONINE' 442 'D00659 LIOTRIX'
             443 'D00666 AMYL NITRITE' 444 'D00683 LIDOCAINE TOPICAL'
             445 'D00688 BEPRIDIL' 446 'D00689 AMLODIPINE'
             447 'D00693 ISOXSUPRINE' 448 'D00695 PAPAVERINE'
             449 'D00696 ETHAVERINE' 450 'D00697 ISOPROTERENOL'
             451 'D00699 EPINEPHRINE' 452 'D00700 EPHEDRINE'
             453 'D00703 METHOXAMINE' 454 'D00704 PHENYLEPHRINE'
             455 'D00708 CARTEOLOL' 456 'D00709 BISOPROLOL'
             457 'D00717 GUANFACINE' 458 'D00726 DOXAZOSIN'
             459 'D00728 RAMIPRIL' 460 'D00730 BENAZEPRIL'
             461 'D00732 LISINOPRIL' 462 'D00733 PHENTOLAMINE'
             463 'D00734 PHENOXYBENZAMINE' 464 'D00735 METYROSINE'
             465 'D00739 MECAMYLAMINE'
             466 'D00743 SODIUM POLYSTYRENE SULFONATE'
             467 'D00744 COLESTIPOL' 468 'D00746 SIMVASTATIN'
             469 'D00747 DEXTROTHYROXINE SODIUM' 470 'D00749 ALBUTEROL'
             471 'D00750 METAPROTERENOL' 472 'D00752 TERBUTALINE'
             473 'D00755 PIRBUTEROL' 474 'D00758 AMINOPHYLLINE'
             475 'D00759 DYPHYLLINE' 476 'D00760 BECLOMETHASONE'
             477 'D00761 FLUNISOLIDE' 478 'D00762 ACETYLCYSTEINE'
             479 'D00765 CROMOLYN OPHTHALMIC'
             480 'D00767 PHENYLPROPANOLAMINE' 481 'D00769 PSEUDOEPHEDRINE'
             482 'D00771 NAPHAZOLINE OPHTHALMIC'
             483 'D00772 OXYMETAZOLINE NASAL'
             484 'D00773 TETRAHYDROZOLINE OPHTHALMIC'
             485 'D00774 XYLOMETAZOLINE NASAL'
             486 'D00775 ALPHA 1-PROTEINASE INHIBITOR'
             487 'D00780 CLEMASTINE' 488 'D00782 PYRILAMINE'
             489 'D00784 DEXCHLORPHENIRAMINE' 490 'D00785 BROMPHENIRAMINE'
             491 'D00786 TRIPROLIDINE' 492 'D00787 PROMETHAZINE'
             493 'D00788 TRIMEPRAZINE' 494 'D00789 METHDILAZINE'
             495 'D00790 CYPROHEPTADINE' 496 'D00791 AZATADINE'
             497 'D00793 PHENINDAMINE' 498 'D00796 BENZONATATE'
             499 'D00797 GUAIFENESIN' 500 'D00800 POTASSIUM IODIDE'
             501 'D00801 CAFFEINE' 502 'D00802 DOXAPRAM'
             503 'D00803 AMPHETAMINE' 504 'D00804 DEXTROAMPHETAMINE'
             505 'D00805 METHAMPHETAMINE' 506 'D00806 PHENTERMINE'
             507 'D00807 BENZPHETAMINE' 508 'D00809 PHENDIMETRAZINE'
             509 'D00810 DIETHYLPROPION' 510 'D00811 MAZINDOL'
             511 'D00812 FENFLURAMINE' 512 'D00813 BENZOCAINE TOPICAL'
             513 'D00814 METHOTRIMEPRAZINE' 514 'D00817 HYDROXYCHLOROQUINE'
             515 'D00824 OPIUM' 516 'D00825 LEVORPHANOL'
             517 'D00833 OXYMORPHONE' 518 'D00838 BUTORPHANOL'
             519 'D00839 NALBUPHINE' 520 'D00840 BUPRENORPHINE'
             521 'D00842 SALSALATE' 522 'D00846 MAGNESIUM SALICYLATE'
             523 'D00848 DICLOFENAC' 524 'D00851 ETODOLAC'
             525 'D00853 OXAPROZIN' 526 'D00855 PERPHENAZINE'
             527 'D00857 THIETHYLPERAZINE' 528 'D00858 CYCLIZINE'
             529 'D00859 MECLIZINE' 530 'D00861 DIMENHYDRINATE'
             531 'D00862 TRIMETHOBENZAMIDE' 532 'D00866 DRONABINOL'
             533 'D00867 ONDANSETRON' 534 'D00873 TRIMIPRAMINE'
             535 'D00874 AMOXAPINE' 536 'D00875 PROTRIPTYLINE'
             537 'D00876 CLOMIPRAMINE' 538 'D00877 MAPROTILINE'
             539 'D00880 SERTRALINE' 540 'D00882 ISOCARBOXAZID'
             541 'D00883 PHENELZINE' 542 'D00884 TRANYLCYPROMINE'
             543 'D00889 MESORIDAZINE' 544 'D00890 TRIFLUOPERAZINE'
             545 'D00896 MOLINDONE' 546 'D00897 LOXAPINE'
             547 'D00898 PIMOZIDE' 548 'D00900 METHYLPHENIDATE'
             549 'D00901 PEMOLINE' 550 'D00902 ERGOLOID MESYLATES'
             551 'D00907 HYDROXYZINE' 552 'D00909 CHLORMEZANONE'
             553 'D00910 ZOLPIDEM' 554 'D00911 PARALDEHYDE'
             555 'D00912 ACETYLCARBROMAL' 556 'D00915 ESTAZOLAM'
             557 'D00917 QUAZEPAM' 558 'D00919 MEPHOBARBITAL'
             559 'D00923 BUTABARBITAL' 560 'D00929 METHOHEXITAL'
             561 'D00931 ETOMIDATE' 562 'D00933 PROPOFOL'
             563 'D00934 NITROUS OXIDE' 564 'D00942 ETHOTOIN'
             565 'D00943 PHENSUXIMIDE' 566 'D00944 PARAMETHADIONE'
             567 'D00960 CARISOPRODOL' 568 'D00962 CHLORZOXAZONE'
             569 'D00963 CYCLOBENZAPRINE' 570 'D00964 METAXALONE'
             571 'D00965 METHOCARBAMOL' 572 'D00966 ORPHENADRINE'
             573 'D00967 BACLOFEN' 574 'D00968 DANTROLENE'
             575 'D00969 PROCYCLIDINE' 576 'D00970 TRIHEXYPHENIDYL'
             577 'D00972 BIPERIDEN' 578 'D00976 SELEGILINE'
             579 'D00977 PERGOLIDE' 580 'D00978 ALUMINUM HYDROXIDE'
             581 'D00980 DIHYDROXYALUMINUM SODIUM CARBONATE'
             582 'D00982 MAGNESIUM HYDROXIDE' 583 'D00984 MAGALDRATE'
             584 'D00985 HYOSCYAMINE' 585 'D00986 SCOPOLAMINE'
             586 'D00988 BELLADONNA' 587 'D00989 METHSCOPOLAMINE'
             588 'D00991 CLIDINIUM' 589 'D00992 GLYCOPYRROLATE'
             590 'D00999 DICYCLOMINE' 591 'D01002 PANCRELIPASE'
             592 'D01003 PANCREATIN' 593 'D01005 URSODIOL'
             594 'D01008 MAGNESIUM CITRATE' 595 'D01009 SODIUM BIPHOSPHATE'
             596 'D01010 CASCARA SAGRADA' 597 'D01012 PHENOLPHTHALEIN'
             598 'D01013 SENNA' 599 'D01014 CASTOR OIL'
             600 'D01015 BISACODYL' 601 'D01017 POLYCARBOPHIL'
             602 'D01018 PSYLLIUM' 603 'D01019 MINERAL OIL'
             604 'D01021 DOCUSATE'
             605 'D01023 POLYETHYLENE GLYCOL 3350 WITH ELECTROLYTES'
             606 'D01024 LACTULOSE' 607 'D01025 LOPERAMIDE'
             608 'D01026 BISMUTH SUBSALICYLATE' 609 'D01027 SIMETHICONE'
             610 'D01028 CHARCOAL' 611 'D01030 DEHYDROCHOLIC ACID'
             612 'D01031 MESALAMINE' 613 'D01032 OLSALAZINE'
             614 'D01068 DEMECLOCYCLINE' 615 'D01070 OXYTETRACYCLINE'
             616 'D01090 SULFAMETHIZOLE' 617 'D01097 RIFABUTIN'
             618 'D01100 ETHIONAMIDE' 619 'D01101 CYCLOSERINE'
             620 'D01104 PAROMOMYCIN' 621 'D01105 IODOQUINOL'
             622 'D01112 COLISTIN SULFATE OTIC' 623 'D01113 COLISTIMETHATE'
             624 'D01115 BACITRACIN' 625 'D01120 ATOVAQUONE'
             626 'D01121 CLOFAZIMINE' 627 'D01123 PYRANTEL'
             628 'D01124 PIPERAZINE' 629 'D01128 METHYLENE BLUE'
             630 'D01129 CINOXACIN' 631 'D01133 IMMUNE GLOBULIN INTRAVENOUS'
             632 'D01135 IMMUNE GLOBULIN INTRAMUSCULAR'
             633 'D01136 HEPATITIS B IMMUNE GLOBULIN'
             634 'D01138 VARICELLA ZOSTER IMMUNE GLOBULIN'
             635 'D01139 RHO (D) IMMUNE GLOBULIN'
             636 'D01141 LYMPHOCYTE IMMUNE GLOBULIN, ANTI-THY (OBS)'
             637 'D01142 DIPHTHERIA ANTITOXIN'
             638 'D01144 ANTIVENIN (CROTALIDAE) POLYVALENT'
             639 'D01146 ANTIVENIN (BLACK WIDOW SPIDER)'
             640 'D01147 RABIES VACCINE (OBSOLETE)'
             641 'D01148 RABIES IMMUNE GLOBULIN, HUMAN' 642 'D01150 BCG'
             643 'D01152 STAPHAGE LYSATE (SPL)'
             644 'D01153 MENINGOCOCCAL POLYSACCHARIDE VACCINE'
             645 'D01156 TYPHOID VACCINE, INACTIVATED'
             646 'D01158 HAEMOPHILUS B CONJUGATE VACCINE (OBSOLETE)'
             647 'D01159 MEASLES VIRUS VACCINE'
             648 'D01160 RUBELLA VIRUS VACCINE'
             649 'D01161 MUMPS VIRUS VACCINE'
             650 'D01162 POLIOVIRUS VACCINE, LIVE, TRIVALENT'
             651 'D01163 POLIOVIRUS VACCINE, INACTIVATED'
             652 'D01164 INFLUENZA VIRUS VACCINE, INACTIVATED'
             653 'D01165 YELLOW FEVER VACCINE'
             654 'D01166 HEPATITIS B VACCINE (OBSOLETE)'
             655 'D01168 TETANUS TOXOID'
             656 'D01171 TUBERCULIN PURIFIED PROTEIN DERIVATIVE'
             657 'D01184 DIPIVEFRIN OPHTHALMIC'
             658 'D01187 LEVOBUNOLOL OPHTHALMIC'
             659 'D01188 ACETYLCHOLINE OPHTHALMIC'
             660 'D01191 PILOCARPINE OPHTHALMIC'
             661 'D01195 ECHOTHIOPHATE IODIDE OPHTHALMIC'
             662 'D01199 HOMATROPINE OPHTHALMIC'
             663 'D01200 TROPICAMIDE OPHTHALMIC'
             664 'D01201 CYCLOPENTOLATE OPHTHALMIC'
             665 'D01204 SUPROFEN OPHTHALMIC'
             666 'D01208 SULFACETAMIDE SODIUM OPHTHALMIC'
             667 'D01210 YELLOW MERCURIC OXIDE OPHTHALMIC'
             668 'D01215 TRIFLURIDINE OPHTHALMIC' 669 'D01217 TETRACAINE'
             670 'D01218 PROPARACAINE OPHTHALMIC'
             671 'D01219 FLUORESCEIN OPHTHALMIC'
             672 'D01222 SODIUM HYALURONATE OPHTHALMIC'
             673 'D01225 BORIC ACID TOPICAL'
             674 'D01226 HYDROXYPROPYL METHYLCELLULOSE OPHTHALMIC'
             675 'D01227 BOTULINUM TOXIN TYPE A (OBSOLETE)'
             676 'D01231 CHLORHEXIDINE TOPICAL'
             677 'D01232 CARBAMIDE PEROXIDE TOPICAL' 678 'D01233 NYSTATIN'
             679 'D01234 BUTOCONAZOLE TOPICAL'
             680 'D01235 TIOCONAZOLE TOPICAL' 681 'D01236 CLOTRIMAZOLE'
             682 'D01238 TERCONAZOLE TOPICAL'
             683 'D01239 GENTIAN VIOLET TOPICAL'
             684 'D01240 SULFANILAMIDE TOPICAL'
             685 'D01241 CLINDAMYCIN TOPICAL'
             686 'D01242 NONOXYNOL 9 TOPICAL' 687 'D01243 OCTOXYNOL TOPICAL'
             688 'D01244 TRETINOIN TOPICAL' 689 'D01245 ISOTRETINOIN'
             690 'D01246 BENZOYL PEROXIDE TOPICAL'
             691 'D01254 ANTHRALIN TOPICAL'
             692 'D01257 NITROFURAZONE TOPICAL' 693 'D01258 MAFENIDE TOPICAL'
             694 'D01259 SILVER SULFADIAZINE TOPICAL'
             695 'D01263 PYRITHIONE ZINC TOPICAL'
             696 'D01265 SULFACETAMIDE SODIUM TOPICAL'
             697 'D01266 CHLOROXINE TOPICAL' 698 'D01267 MUPIROCIN TOPICAL'
             699 'D01271 ECONAZOLE TOPICAL' 700 'D01272 CICLOPIROX TOPICAL'
             701 'D01273 TRIACETIN TOPICAL' 702 'D01274 TOLNAFTATE TOPICAL'
             703 'D01275 SULCONAZOLE TOPICAL' 704 'D01277 NAFTIFINE TOPICAL'
             705 'D01278 LINDANE TOPICAL' 706 'D01279 PERMETHRIN TOPICAL'
             707 'D01280 CROTAMITON TOPICAL'
             708 'D01282 ALCLOMETASONE TOPICAL'
             709 'D01288 CLOBETASOL TOPICAL'
             710 'D01289 CLOCORTOLONE TOPICAL' 711 'D01290 DESONIDE TOPICAL'
             712 'D01291 DESOXIMETASONE TOPICAL'
             713 'D01292 DIFLORASONE TOPICAL'
             714 'D01293 FLUOCINOLONE TOPICAL'
             715 'D01294 FLUOCINONIDE TOPICAL'
             716 'D01295 FLURANDRENOLIDE TOPICAL' 717 'D01296 FLUTICASONE'
             718 'D01298 HALOBETASOL TOPICAL' 719 'D01300 MOMETASONE TOPICAL'
             720 'D01301 DIBUCAINE TOPICAL' 721 'D01302 BUTAMBEN TOPICAL'
             722 'D01303 PRAMOXINE TOPICAL' 723 'D01305 DYCLONINE TOPICAL'
             724 'D01306 COCAINE TOPICAL' 725 'D01307 SALICYLIC ACID TOPICAL'
             726 'D01308 PODOPHYLLUM RESIN TOPICAL'
             727 'D01309 PODOFILOX TOPICAL'
             728 'D01313 TRICHLOROACETIC ACID TOPICAL'
             729 'D01314 SUTILAINS TOPICAL' 730 'D01315 COLLAGENASE TOPICAL'
             731 'D01316 MASOPROCOL TOPICAL'
             732 'D01319 HYDROQUINONE TOPICAL'
             733 'D01320 FORMALDEHYDE TOPICAL' 734 'D01321 CAPSAICIN TOPICAL'
             735 'D01322 ALUMINUM CHLORIDE HEXAHYDRATE TOPICAL'
             736 'D01323 MONOBENZONE TOPICAL' 737 'D01325 ARNICA TOPICAL'
             738 'D01332 HEXACHLOROPHENE TOPICAL'
             739 'D01333 BENZALKONIUM CHLORIDE TOPICAL'
             740 'D01335 SODIUM HYPOCHLORITE TOPICAL'
             741 'D01338 PHYSIOLOGICAL IRRIGATING SOLUTION'
             742 'D01339 MECHLORETHAMINE' 743 'D01341 LOMUSTINE'
             744 'D01342 CARMUSTINE' 745 'D01344 FLOXURIDINE'
             746 'D01345 THIOGUANINE' 747 'D01346 FLUDARABINE'
             748 'D01348 MEGESTROL' 749 'D01351 ESTRAMUSTINE'
             750 'D01353 LEUPROLIDE' 751 'D01354 GOSERELIN'
             752 'D01356 PENTOSTATIN' 753 'D01361 PLICAMYCIN'
             754 'D01368 INTERFERON ALFA-2A' 755 'D01369 INTERFERON ALFA-2B'
             756 'D01372 ALTRETAMINE' 757 'D01373 HYDROXYUREA'
             758 'D01375 ALDESLEUKIN' 759 'D01376 PACLITAXEL'
             760 'D01378 MITOTANE' 761 'D01379 ASPARAGINASE ESCHERICHIA COLI'
             762 'D01382 ETHANOLAMINE OLEATE'
             763 'D01383 SODIUM TETRADECYL SULFATE'
             764 'D01384 MORRHUATE SODIUM' 765 'D01385 BETA-CAROTENE'
             766 'D01386 YOHIMBINE' 767 'D01387 ALPROSTADIL'
             768 'D01389 DISULFIRAM' 769 'D01393 HYALURONIDASE'
             770 'D01394 PROCAINE' 771 'D01395 CHLOROPROCAINE'
             772 'D01396 PRILOCAINE' 773 'D01398 MEPIVACAINE'
             774 'D01402 DEFEROXAMINE' 775 'D01404 SODIUM THIOSULFATE'
             776 'D01406 NALTREXONE' 777 'D01407 FLUMAZENIL'
             778 'D01409 PRALIDOXIME' 779 'D01410 DIGOXIN IMMUNE FAB'
             780 'D01411 MESNA' 781 'D01413 IPECAC' 782 'D01416 TRIENTINE'
             783 'D01417 SUCCIMER' 784 'D01420 AMBENONIUM'
             785 'D01422 GUANIDINE' 786 'D01423 POTASSIUM CITRATE'
             787 'D01424 POTASSIUM ACID PHOSPHATE' 788 'D01425 FLAVOXATE'
             789 'D01427 BETHANECHOL' 790 'D01431 DIMETHYL SULFOXIDE'
             791 'D01433 ACETOHYDROXAMIC ACID' 792 'D01434 METHOXSALEN'
             793 'D01438 IOPANOIC ACID' 794 'D01445 BARIUM SULFATE'
             795 'D01451 GADOPENTETATE DIMEGLUMINE' 796 'D01452 IODAMIDE'
             797 'D01456 IOHEXOL' 798 'D01461 IOPAMIDOL'
             799 'D01469 IOVERSOL' 800 'D01472 METRIZAMIDE'
             801 'D01473 DIATRIZOATE' 802 'D01475 IOTHALAMATE'
             803 'D01476 ETHIODIZED OIL' 804 'D01482 ISOSULFAN BLUE'
             805 'D02373 PHOSPHORATED CARBOHYDRATE SOLUTION'
             806 'D02374 DESFLURANE' 807 'D02375 PLASMA PROTEIN FRACTION'
             808 'D02376 ALBUMIN HUMAN' 809 'D02378 HETASTARCH'
             810 'D02381 POTASSIUM PERCHLORATE' 811 'D03001 CLADRIBINE'
             812 'D03003 DIPHTHERIA-TETANUS TOXOIDS (OBSOLETE)'
             813 'D03004 DIPHTHERIA/PERTUSSIS, WHOLE CELL/TETANUS'
             814 'D03006 MEASLES-RUBELLA VIRUS VACCINE'
             815 'D03007 MEASLES/MUMPS/RUBELLA VIRUS VACCINE'
             816 'D03008 INTERFERON GAMMA-1B' 817 'D03034 NORGESTREL'
             818 'D03041 ENOXAPARIN' 819 'D03050 LORATADINE'
             820 'D03051 INTERFERON BETA-1B'
             821 'D03052 HYDROCHLOROTHIAZIDE-TRIAMTERENE'
             822 'D03054 AMYLASE' 823 'D03056 ATTAPULGITE'
             824 'D03058 BENZOIC ACID' 825 'D03061 BUTALBITAL'
             826 'D03062 CASANTHRANOL' 827 'D03066 CITRIC ACID'
             828 'D03068 DICHLORALPHENAZONE' 829 'D03075 HYDROCODONE'
             830 'D03077 ISOMETHEPTENE MUCATE' 831 'D03085 PEPSIN'
             832 'D03086 PHENIRAMINE' 833 'D03089 PHENYLTOLOXAMINE'
             834 'D03094 SALICYLAMIDE' 835 'D03096 SODIUM BENZOATE'
             836 'D03097 SODIUM BORATE TOPICAL' 837 'D03098 SODIUM CITRATE'
             838 'D03109 JAPANESE ENCEPHALITIS VIRUS VACCINE NAKAYAMA'
             839 'D03110 DIPHTH/PERTUSSIS, ACEL/TETANUS (OBSOLETE)'
             840 'D03112 NEDOCROMIL'
             841 'D03113 DEXTRAN, LOW MOLECULAR WEIGHT'
             842 'D03114 DEXTRAN, HIGH MOLECULAR WEIGHT'
             843 'D03116 BISMUTH SUBGALLATE' 844 'D03118 MUROMONAB-CD3'
             845 'D03125 DIHYDROTACHYSTEROL' 846 'D03126 CALCITRIOL'
             847 'D03128 ERGOCALCIFEROL' 848 'D03129 CHOLECALCIFEROL'
             849 'D03130 THIAMINE' 850 'D03133 HYDROXOCOBALAMIN'
             851 'D03135 PHYTONADIONE' 852 'D03136 VITAMIN A & D TOPICAL'
             853 'D03137 CALCIUM-VITAMIN D' 854 'D03140 MULTIVITAMIN'
             855 'D03141 MULTIVITAMIN WITH IRON'
             856 'D03143 MULTIVITAMIN WITH FLUORIDE'
             857 'D03145 MULTIVITAMIN WITH MINERALS'
             858 'D03148 MULTIVITAMIN, PRENATAL' 859 'D03152 TRIFLUPROMAZINE'
             860 'D03154 DOXYLAMINE' 861 'D03157 PAROXETINE'
             862 'D03158 RIMANTADINE' 863 'D03159 CHOLINE'
             864 'D03160 SUMATRIPTAN' 865 'D03162 ALCOHOL (ETHANOL)'
             866 'D03165 PIPERACILLIN-TAZOBACTAM' 867 'D03166 CISAPRIDE'
             868 'D03168 DIHYDROCODEINE' 869 'D03169 TRIMETREXATE'
             870 'D03170 FELBAMATE' 871 'D03171 GRANISETRON'
             872 'D03173 DORNASE ALFA' 873 'D03176 TACRINE'
             874 'D03180 RISPERIDONE' 875 'D03181 VENLAFAXINE'
             876 'D03182 GABAPENTIN' 877 'D03183 FLUVASTATIN'
             878 'D03187 LEVOMETHADYL ACETATE' 879 'D03189 TORSEMIDE'
             880 'D03190 OXICONAZOLE TOPICAL'
             881 'D03191 TERBINAFINE TOPICAL' 882 'D03192 ZINC OXIDE TOPICAL'
             883 'D03193 AMILORIDE-HYDROCHLOROTHIAZIDE'
             884 'D03195 MICONAZOLE TOPICAL' 885 'D03196 GENTAMICIN TOPICAL'
             886 'D03197 BETAMETHASONE TOPICAL'
             887 'D03200 ERYTHROMYCIN TOPICAL' 888 'D03201 ACYCLOVIR TOPICAL'
             889 'D03202 KETOCONAZOLE TOPICAL' 890 'D03203 MINOXIDIL TOPICAL'
             891 'D03204 FLUOROURACIL TOPICAL'
             892 'D03205 HYDROCORTISONE TOPICAL'
             893 'D03206 TRIAMCINOLONE TOPICAL'
             894 'D03207 AMPHOTERICIN B TOPICAL'
             895 'D03208 METRONIDAZOLE TOPICAL'
             896 'D03210 SELENIUM SULFIDE TOPICAL'
             897 'D03211 CIPROFLOXACIN OPHTHALMIC'
             898 'D03212 ATROPINE OPHTHALMIC'
             899 'D03213 DICLOFENAC OPHTHALMIC'
             900 'D03214 KETOROLAC OPHTHALMIC'
             901 'D03221 PREDNISOLONE OPHTHALMIC'
             902 'D03222 TOBRAMYCIN OPHTHALMIC' 903 'D03224 NEOMYCIN TOPICAL'
             904 'D03226 SALIVA SUBSTITUTES'
             905 'D03227 FLUOROMETHOLONE OPHTHALMIC'
             906 'D03228 LODOXAMIDE OPHTHALMIC'
             907 'D03229 LEVOCABASTINE OPHTHALMIC'
             908 'D03231 TRIPLE SULFA TOPICAL'
             909 'D03232 VITAMINS A, D, AND E TOPICAL'
             910 'D03233 VITAMIN E TOPICAL'
             911 'D03238 ETHINYL ESTRADIOL-NORETHINDRONE'
             912 'D03240 MESTRANOL-NORETHINDRONE'
             913 'D03241 ETHINYL ESTRADIOL-NORGESTREL'
             914 'D03242 ETHINYL ESTRADIOL-LEVONORGESTREL'
             915 'D03245 ESTERIFIED ESTROGENS-METHYLTESTOSTERONE'
             916 'D03247 HYDROCHLOROTHIAZIDE-SPIRONOLACTONE'
             917 'D03251 HYDROCHLOROTHIAZIDE-RESERPINE'
             918 'D03255 BENDROFLUMETHIAZIDE-RAUWOLFIA SERPENTINA'
             919 'D03256 HYDRALAZINE/HYDROCHLOROTHIAZIDE/RESERPINE'
             920 'D03257 HYDRALAZINE-HYDROCHLOROTHIAZIDE'
             921 'D03258 ATENOLOL-CHLORTHALIDONE'
             922 'D03259 BENDROFLUMETHIAZIDE-NADOLOL'
             923 'D03260 HYDROCHLOROTHIAZIDE-TIMOLOL'
             924 'D03261 HYDROCHLOROTHIAZIDE-PROPRANOLOL'
             925 'D03263 HYDROCHLOROTHIAZIDE-METHYLDOPA'
             926 'D03264 HYDROCHLOROTHIAZIDE-METOPROLOL'
             927 'D03265 BENAZEPRIL-HYDROCHLOROTHIAZIDE'
             928 'D03266 HYDROCHLOROTHIAZIDE-LISINOPRIL'
             929 'D03267 CHLORTHALIDONE-CLONIDINE'
             930 'D03271 PHENIRAMINE-PHENYLEPHRINE NASAL'
             931 'D03273 GUAIFENESIN-THEOPHYLLINE'
             932 'D03274 AMINOPHYLLINE-GUAIFENESIN'
             933 'D03276 DYPHYLLINE-GUAIFENESIN'
             934 'D03277 POTASSIUM IODIDE-THEOPHYLLINE'
             935 'D03280 EPHEDRINE/PHENOBARBITAL/THEOPHYLLINE'
             936 'D03283 EPHEDRINE/HYDROXYZINE/THEOPHYLLINE'
             937 'D03289 ACETAMINOPHEN-PSEUDOEPHEDRINE'
             938 'D03292 IBUPROFEN-PSEUDOEPHEDRINE' 939 'D03293 APAP/ASA/PPA'
             940 'D03296 ACETAMINOPHEN-CHLORPHENIRAMINE'
             941 'D03297 ACETAMINOPHEN-PHENYLTOLOXAMINE'
             942 'D03298 CHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             943 'D03299 CHLORPHENIRAMINE-PHENYLPROPANOLAMINE'
             944 'D03300 CHLORPHENIRAMINE-PHENYLEPHRINE'
             945 'D03301 BROMPHENIRAMINE-PSEUDOEPHEDRINE'
             946 'D03302 BROMPHENIRAMINE-PHENYLPROPANOLAMINE'
             947 'D03303 CLEMASTINE-PHENYLPROPANOLAMINE'
             948 'D03306 CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             949 'D03307 CHLORPHENIRAMINE/PHENINDAMINE/PPA'
             950 'D03308 PHENIRAMINE/PPA/PHENYLTOLOXAMINE/PYRILAMINE'
             951 'D03310 CHLORPHENIRAMINE/PE/PPA/PHENYLTOLOXAMINE'
             952 'D03311 BROMPHENIRAMINE-PHENYLEPHRINE'
             953 'D03312 DIPHENHYDRAMINE-PSEUDOEPHEDRINE'
             954 'D03313 CHLORPHENIRAMINE/PHENYLEPHRINE/PYRILAMINE'
             955 'D03316 PSEUDOEPHEDRINE-TRIPROLIDINE'
             956 'D03317 PHENYLEPHRINE-PROMETHAZINE'
             957 'D03318 PHENIRAMINE/PPA/PYRILAMINE'
             958 'D03319 APAP/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             959 'D03320 APAP/CHLORPHENIRAMINE/PSEUDOEPHEDRINE'
             960 'D03321 APAP/BROMPHENIRAMINE/PSEUDOEPHEDRINE'
             961 'D03322 ASA/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             962 'D03329 ASA/DIPHENHYDRAMINE/PPA'
             963 'D03330 APAP/PSEUDOEPHEDRINE/TRIPROLIDINE'
             964 'D03331 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE'
             965 'D03336 APAP/CPM/PHENYLEPHRINE/PPA/PYRILAMINE'
             966 'D03338 CHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             967 'D03340 HOMATROPINE-HYDROCODONE'
             968 'D03341 CODEINE-PSEUDOEPHEDRINE'
             969 'D03342 APAP/DEXTROMETHORPHAN/PSEUDOEPHEDRINE'
             970 'D03347 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             971 'D03349 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PSE'
             972 'D03351 ASA/BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             973 'D03352 HYDROCODONE-PSEUDOEPHEDRINE'
             974 'D03353 HYDROCODONE-PHENYLPROPANOLAMINE'
             975 'D03354 DEXTROMETHORPHAN-PSEUDOEPHEDRINE'
             976 'D03355 DEXTROMETHORPHAN-PHENYLPROPANOLAMINE'
             977 'D03356 CHLORPHENIRAMINE-HYDROCODONE'
             978 'D03357 CODEINE-PROMETHAZINE'
             979 'D03359 CHLORPHENIRAMINE-DEXTROMETHORPHAN'
             980 'D03360 DEXTROMETHORPHAN-PROMETHAZINE'
             981 'D03361 CHLORPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             982 'D03362 CHLORPHENIRAMINE/CODEINE/PSEUDOEPHEDRINE'
             983 'D03364 CODEINE/PHENYLEPHRINE/PROMETHAZINE'
             984 'D03366 HYDROCODONE/PHENYLEPHRINE/PYRILAMINE'
             985 'D03368 BROMPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             986 'D03369 CHLORPHENIRAMINE/DEXTROMETHORP/PHENYLEPHRINE'
             987 'D03370 CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             988 'D03371 DEXTROMETHORPHAN/PHENYLEPHRINE/PYRILAMINE'
             989 'D03372 BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             990 'D03378 ACETAMINOPHEN-DEXTROMETHORPHAN'
             991 'D03379 GUAIFENESIN-PSEUDOEPHEDRINE'
             992 'D03380 EPHEDRINE-GUAIFENESIN'
             993 'D03381 GUAIFENESIN-PHENYLEPHRINE'
             994 'D03382 GUAIFENESIN-PHENYLPROPANOLAMINE'
             995 'D03383 GUAIFENESIN/PHENYLEPHRINE/PPA'
             996 'D03388 ETHINYL ESTRADIOL-ETHYNODIOL'
             997 'D03389 ESTRADIOL-TESTOSTERONE'
             998 'D03392 CHLORPHENIRAMINE/GUAIFENESIN/PHENYLEPHRINE'
             999 'D03393 CODEINE-GUAIFENESIN'
             1000 'D03396 GUAIFENESIN-HYDROCODONE'
             1001 'D03397 GUAIFENESIN-HYDROMORPHONE'
             1002 'D03398 CODEINE/GUAIFENESIN/PSE'
             1003 'D03400 DEXTROMETHORPHAN-GUAIFENESIN'
             1004 'D03403 GUAIFENESIN/HYDROCODONE/PHENYLEPHRINE'
             1005 'D03404 GUAIFENESIN/HYDROCODONE/PSEUDOEPHEDRINE'
             1006 'D03407 CODEINE/GUAIFENESIN/PHENYLPROPANOLAMINE'
             1007 'D03408 DEXTROMETHORPHAN/GUAIFENESIN/PHENYLEPHRINE'
             1008 'D03409 DEXTROMETHORPHAN/GUAIFENESIN/PSEUDOEPHEDRINE'
             1009 'D03411 DEXTROMETHORPHAN/GUAIFENESIN/PPA'
             1010 'D03416 CHLORPHENIRAMINE/HYDROCODONE/PSE'
             1011 'D03419 CHLORPHENIRAMINE/DM/GUAIFENESIN/PHENYLEPHRINE'
             1012 'D03423 ACETAMINOPHEN-CODEINE'
             1013 'D03424 ASPIRIN-CODEINE'
             1014 'D03425 APAP/BUTALBITAL/CAFFEINE/CODEINE'
             1015 'D03426 ASA/BUTALBITAL/CAFFEINE/CODEINE'
             1016 'D03428 ACETAMINOPHEN-HYDROCODONE'
             1017 'D03430 ASA/CAFFEINE/DIHYDROCODEINE'
             1018 'D03431 ACETAMINOPHEN-OXYCODONE'
             1019 'D03432 ASPIRIN-OXYCODONE'
             1020 'D03433 MEPERIDINE-PROMETHAZINE'
             1021 'D03434 ACETAMINOPHEN-PROPOXYPHENE'
             1022 'D03435 ASA/CAFFEINE/PROPOXYPHENE'
             1023 'D03436 BELLADONNA-OPIUM'
             1024 'D03437 APAP/ASA/CAFFEINE/SALICYLAMIDE'
             1025 'D03439 APAP/ASA/CAFFEINE'
             1026 'D03443 APAP/AL HYDROXIDE/ASA/CAFFEINE/MG HYDROXIDE'
             1027 'D03445 ACETAMINOPHEN-DIPHENHYDRAMINE'
             1028 'D03447 ASA/CAFFEINE/SALICYLAMIDE'
             1029 'D03448 ASPIRIN-MEPROBAMATE' 1030 'D03449 ASPIRIN-CAFFEINE'
             1031 'D03453 ASPIRIN-PHENYLTOLOXAMINE'
             1032 'D03454 MAGNESIUM SALICYLATE-PHENYLTOLOXAMINE'
             1033 'D03455 APAP/BUTALBITAL/CAFFEINE'
             1034 'D03456 ACETAMINOPHEN-BUTALBITAL'
             1035 'D03457 ASA/BUTALBITAL/CAFFEINE'
             1036 'D03459 APAP/DICHLORALPHENAZONE/ISOMETHEPTENE'
             1037 'D03462 AMITRIPTYLINE-CHLORDIAZEPOXIDE'
             1038 'D03463 AMITRIPTYLINE-PERPHENAZINE'
             1039 'D03464 DROPERIDOL-FENTANYL'
             1040 'D03468 ASPIRIN-METHOCARBAMOL'
             1041 'D03469 ASPIRIN-CARISOPRODOL'
             1042 'D03470 ASA/CARISOPRODOL/CODEINE'
             1043 'D03472 ASA/CAFFEINE/ORPHENADRINE'
             1044 'D03473 CARBIDOPA-LEVODOPA'
             1045 'D03474 ALUMINUM HYDROXIDE-MAGNESIUM HYDROXIDE'
             1046 'D03478 AL HYDROXIDE/MG HYDROXIDE/SIMETHICONE'
             1047 'D03480 CA CARBONATE/MG HYDROXIDE/SIMETHICONE'
             1048 'D03485 ATROPINE/HYOSCYAMINE/PB/SCOPOLAMINE'
             1049 'D03486 BELLADONNA-BUTABARBITAL'
             1050 'D03492 CHLORDIAZEPOXIDE-CLIDINIUM'
             1051 'D03495 BELLADONNA/ERGOTAMINE/PHENOBARBITAL'
             1052 'D03496 DOCUSATE-SENNA'
             1053 'D03497 DOCUSATE-PHENOLPHTHALEIN'
             1054 'D03498 CASANTHRANOL-DOCUSATE'
             1055 'D03505 ATROPINE-DIFENOXIN'
             1056 'D03506 ATROPINE-DIPHENOXYLATE'
             1057 'D03508 ISONIAZID-RIFAMPIN'
             1058 'D03509 ERYTHROMYCIN-SULFISOXAZOLE'
             1059 'D03511 PHENAZOPYRIDINE-SULFAMETHOXAZOLE'
             1060 'D03513 METHENAMINE-SODIUM ACID PHOSPHATE'
             1061 'D03517 BENZOIC ACID/METHENAMINE/SODIUM SALICYLATE'
             1062 'D03520 NAPHAZOLINE-PHENIRAMINE OPHTHALMIC'
             1063 'D03521 CYCLOPENTOLATE-PHENYLEPHRINE OPHTHALMIC'
             1064 'D03523 HYDROXYAMPHETAMINE-TROPICAMIDE OPHTHALMIC'
             1065 'D03524 BACITRACIN/NEOMYCIN/POLYMYXIN B TOPICAL'
             1066 'D03525 GRAMICIDIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1067 'D03526 NEOMYCIN-POLYMYXIN B SULFATE TOPICAL'
             1068 'D03527 BACITRACIN-POLYMYXIN B TOPICAL'
             1069 'D03529 POLYMYXIN B-TRIMETHOPRIM OPHTHALMIC'
             1070 'D03533 NEOMYCIN/POLYMYXIN B/PREDNISOLONE OPHTHALMIC'
             1071 'D03536 DEXAMETHASONE-TOBRAMYCIN OPHTHALMIC'
             1072 'D03537 DEXAMETHASONE/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1073 'D03541 PREDNISOLONE-SULFACETAMIDE SODIUM OPHTHALMIC'
             1074 'D03542 FLUORESCEIN-PROPARACAINE OPHTHALMIC'
             1075 'D03543 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OTIC'
             1076 'D03544 HYDROCORTISONE-POLYMYXIN B OTIC'
             1077 'D03546 HYDROCORTISONE-PRAMOXINE TOPICAL'
             1078 'D03552 CLIOQUINOL-HYDROCORTISONE TOPICAL'
             1079 'D03553 CLIOQUINOL/HYDROCORTISONE/PRAMOXINE TOPICAL'
             1080 'D03561 BETAMETHASONE-CLOTRIMAZOLE TOPICAL'
             1081 'D03562 NYSTATIN-TRIAMCINOLONE TOPICAL'
             1082 'D03566 CAPTOPRIL-HYDROCHLOROTHIAZIDE'
             1083 'D03569 CARBINOXAMINE'
             1084 'D03570 CARBINOXAMINE-PSEUDOEPHEDRINE'
             1085 'D03572 CARAMIPHEN-PHENYLPROPANOLAMINE'
             1086 'D03576 BROMODIPHENHYDRAMINE-CODEINE'
             1087 'D03577 CARBINOXAMINE/DEXTROMETHORPHAN/PSE'
             1088 'D03584 CODEINE/PHENIRAMINE/PHENYLEPHRINE/NA CITRATE'
             1089 'D03585 PAMABROM' 1090 'D03586 APAP/PAMABROM/PYRILAMINE'
             1091 'D03588 MAGNESIUM CARBONATE'
             1092 'D03591 ALGINIC ACID/AL HYDROXIDE/MG CARBONATE'
             1093 'D03596 ALGINIC ACID/AL HYDROXIDE/MG TRISILICATE'
             1094 'D03600 POTASSIUM BICARBONATE' 1095 'D03613 PSYLLIUM-SENNA'
             1096 'D03618 HYOSCYAMINE/METHENAM/M-BLUE/PHENYL SALICYL'
             1097 'D03620 ANTAZOLINE-NAPHAZOLINE OPHTHALMIC'
             1098 'D03622 BENOXINATE-FLUORESCEIN OPHTHALMIC'
             1099 'D03623 ACETIC ACID TOPICAL' 1100 'D03624 ANTIPYRINE OTIC'
             1101 'D03625 ACETIC ACID-HYDROCORTISONE OTIC'
             1102 'D03627 ANTIPYRINE-BENZOCAINE OTIC'
             1103 'D03628 ANTIPYRINE/BENZOCAINE/PHENYLEPHRINE OTIC'
             1104 'D03630 ANHYDROUS CALCIUM IODIDE-CODEINE'
             1105 'D03632 CETYLPYRIDINIUM TOPICAL'
             1106 'D03634 BENZOCAINE-CETYLPYRIDINIUM TOPICAL'
             1107 'D03640 BUDESONIDE NASAL' 1108 'D03641 PETROLATUM TOPICAL'
             1109 'D03644 LACTOBACILLUS ACIDOPHILUS'
             1110 'D03646 LACTOBACILLUS ACIDOPHILUS AND BULGARICUS'
             1111 'D03647 ISOPROPYL ALCOHOL TOPICAL'
             1112 'D03648 OPHTHALMIC IRRIGATION, INTRAOCULAR'
             1113 'D03649 BENZOIN TOPICAL'
             1114 'D03650 CANDIDA ALBICANS EXTRACT'
             1115 'D03651 CHOLINE SALICYLATE-MAGNESIUM SALICYLATE'
             1116 'D03652 COLCHICINE-PROBENECID'
             1117 'D03653 CALAMINE TOPICAL'
             1118 'D03655 LIDOCAINE-PRILOCAINE TOPICAL'
             1119 'D03656 ETHYL CHLORIDE TOPICAL'
             1120 'D03659 FIBRINOLYSIN AND DESOXYRIBONUCLEASE TOPICAL'
             1121 'D03660 MULTIVITAMIN WITH IRON AND FLUORIDE'
             1122 'D03661 DOCUSATE-FERROUS FUMARATE' 1123 'D03663 LECITHIN'
             1124 'D03664 PHENOL TOPICAL' 1125 'D03665 MENTHOL TOPICAL'
             1126 'D03666 MENTHOL-PHENOL TOPICAL' 1127 'D03667 METHACHOLINE'
             1128 'D03668 METHYL SALICYLATE TOPICAL' 1129 'D03674 PECTIN'
             1130 'D03676 NALOXONE-PENTAZOCINE'
             1131 'D03678 NAPHAZOLINE-ZINC OPHTHALMIC'
             1132 'D03680 ASA/CITRIC ACID/NA BICARB'
             1133 'D03681 OPHTHALMIC IRRIGATION, EXTRAOCULAR'
             1134 'D03682 ACETAMINOPHEN-PENTAZOCINE'
             1135 'D03684 THROMBIN TOPICAL'
             1136 'D03686 UNDECYLENIC ACID TOPICAL'
             1137 'D03687 ALUMINUM ACETATE TOPICAL'
             1138 'D03688 ALUMINUM SULFATE TOPICAL'
             1139 'D03689 CALCIUM ACETATE'
             1140 'D03690 ALUMINUM SULFATE-CALCIUM ACETATE TOPICAL'
             1141 'D03691 BENZOCAINE/PHENOL/POVIDONE IODINE TOPICAL'
             1142 'D03693 ICHTHAMMOL TOPICAL'
             1143 'D03694 MEDRYSONE OPHTHALMIC'
             1144 'D03695 PRAMOXINE-ZINC OXIDE TOPICAL'
             1145 'D03696 BENZYL BENZOATE TOPICAL'
             1146 'D03701 CORN STARCH TOPICAL' 1147 'D03702 SULFUR TOPICAL'
             1148 'D03703 COAL TAR TOPICAL'
             1149 'D03705 SALICYLIC ACID-SULFUR TOPICAL'
             1150 'D03707 ALOE VERA TOPICAL'
             1151 'D03708 LANOLIN-MINERAL OIL TOPICAL'
             1152 'D03710 ALLANTOIN/CAMPHOR/PHENOL TOPICAL'
             1153 'D03712 CAMPHOR TOPICAL'
             1154 'D03713 CAMPHOR-PHENOL TOPICAL'
             1155 'D03716 CITRIC ACID/GLUCONODELTA-LACTONE/MG CARBONATE'
             1156 'D03721 SODIUM IODIDE'
             1157 'D03724 FAT EMULSION, INTRAVENOUS'
             1158 'D03725 INTRAVENOUS ELECTROLYTE SOLUTION'
             1159 'D03735 TRIETHANOLAMINE POLYPEPTIDE OLEATE OTIC'
             1160 'D03738 TETRACYCLINE TOPICAL' 1161 'D03739 NIACINAMIDE'
             1162 'D03740 ENALAPRIL-HYDROCHLOROTHIAZIDE'
             1163 'D03743 PYRIMETHAMINE-SULFADOXINE'
             1164 'D03744 BISOPROLOL-HYDROCHLOROTHIAZIDE'
             1165 'D03750 DEXBROMPHENIRAMINE'
             1166 'D03751 DEXBROMPHENIRAMINE-PSEUDOEPHEDRINE'
             1167 'D03752 TACROLIMUS'
             1168 'D03754 ACRIVASTINE-PSEUDOEPHEDRINE'
             1169 'D03756 BACITRACIN TOPICAL' 1170 'D03759 SALMETEROL'
             1171 'D03760 DIPHENHYDRAMINE TOPICAL'
             1172 'D03761 LANOLIN TOPICAL' 1173 'D03762 WITCH HAZEL TOPICAL'
             1174 'D03763 GLYCERIN-PHENOL TOPICAL'
             1175 'D03764 GLYCERIN-WITCH HAZEL TOPICAL'
             1176 'D03766 ROCURONIUM' 1177 'D03767 IRON DEXTRAN'
             1178 'D03768 OCULAR LUBRICANT' 1179 'D03770 EMOLLIENTS, TOPICAL'
             1180 'D03773 STAVUDINE' 1181 'D03774 DOXEPIN TOPICAL'
             1182 'D03775 FAMCICLOVIR' 1183 'D03777 POTASSIUM ACETATE'
             1184 'D03780 DESOGESTREL'
             1185 'D03781 ETHINYL ESTRADIOL-NORGESTIMATE'
             1186 'D03782 DESOGESTREL-ETHINYL ESTRADIOL'
             1187 'D03783 BUPIVACAINE-EPINEPHRINE'
             1188 'D03784 EPINEPHRINE-LIDOCAINE'
             1189 'D03788 CALCIPOTRIENE TOPICAL'
             1190 'D03789 POTASSIUM GLUCONATE'
             1191 'D03790 POTASSIUM PHOSPHATE'
             1192 'D03796 MAGNESIUM CHLORIDE' 1193 'D03797 MAGNESIUM OXIDE'
             1194 'D03798 MAGNESIUM GLUCONATE' 1195 'D03799 CALCIUM CHLORIDE'
             1196 'D03800 CALCIUM GLUCONATE' 1197 'D03802 CALCIUM LACTATE'
             1198 'D03803 CALCIUM PHOSPHATE, TRIBASIC'
             1199 'D03804 FLUVOXAMINE' 1200 'D03805 DORZOLAMIDE OPHTHALMIC'
             1201 'D03806 ALBENDAZOLE' 1202 'D03807 METFORMIN'
             1203 'D03808 NEFAZODONE' 1204 'D03809 LAMOTRIGINE'
             1205 'D03810 VINORELBINE' 1206 'D03811 ABCIXIMAB'
             1207 'D03812 DALTEPARIN'
             1208 'D03818 LORATADINE-PSEUDOEPHEDRINE'
             1209 'D03819 CONJUGATED ESTROGENS-MEDROXYPROGESTERONE'
             1210 'D03821 LOSARTAN' 1211 'D03822 FERROUS GLUCONATE'
             1212 'D03823 IRON POLYSACCHARIDE' 1213 'D03824 FERROUS SULFATE'
             1214 'D03825 NISOLDIPINE' 1215 'D03826 TRAMADOL'
             1216 'D03827 CETIRIZINE' 1217 'D03828 LANSOPRAZOLE'
             1218 'D03829 AMLODIPINE-BENAZEPRIL'
             1219 'D03830 HYDROCHLOROTHIAZIDE-LOSARTAN'
             1220 'D03831 NILUTAMIDE' 1221 'D03832 VARICELLA VIRUS VACCINE'
             1222 'D03833 DIVALPROEX SODIUM' 1223 'D03834 NALMEFENE'
             1224 'D03835 MOEXIPRIL' 1225 'D03836 ACITRETIN'
             1226 'D03838 VALACYCLOVIR' 1227 'D03839 MYCOPHENOLATE MOFETIL'
             1228 'D03840 IOPROMIDE' 1229 'D03841 DEXRAZOXANE'
             1230 'D03842 EPOPROSTENOL' 1231 'D03843 GADOTERIDOL'
             1232 'D03844 DIRITHROMYCIN' 1233 'D03845 SEVOFLURANE'
             1234 'D03846 ACARBOSE' 1235 'D03847 CARVEDILOL'
             1236 'D03848 AZELAIC ACID TOPICAL' 1237 'D03849 ALENDRONATE'
             1238 'D03850 BICALUTAMIDE'
             1239 'D03857 BENZOYL PEROXIDE-ERYTHROMYCIN TOPICAL'
             1240 'D03858 LAMIVUDINE' 1241 'D03860 SAQUINAVIR'
             1242 'D03862 MAGNESIUM AMINO ACIDS CHELATE'
             1243 'D03863 TRETINOIN' 1244 'D03864 GLIMEPIRIDE'
             1245 'D03866 CALCIUM CITRATE'
             1246 'D03867 CALCIUM CARBONATE-SODIUM FLUORIDE'
             1247 'D03868 AMIFOSTINE' 1248 'D03869 RILUZOLE'
             1249 'D03870 AMPHOTERICIN B LIPID COMPLEX'
             1250 'D03872 PORFIMER' 1251 'D03873 ANASTROZOLE'
             1252 'D03874 CEFTIBUTEN' 1253 'D03877 HEROIN'
             1254 'D03878 COCAINE' 1255 'D03879 MARIJUANA'
             1256 'D03880 PHENCYCLIDINE'
             1257 'D03881 RESPIRATORY SYNCYTIAL VIRUS IMMUNE GLOBULIN'
             1258 'D03882 CEFEPIME'
             1259 'D03883 AL HYDROXIDE/ASA/CA CARBONATE/MG HYDROXIDE'
             1260 'D03884 TROLAMINE SALICYLATE TOPICAL'
             1261 'D03888 BENZOCAINE/BUTAMBEN/TETRACAINE TOPICAL'
             1262 'D03892 HISTAMINE PHOSPHATE' 1263 'D03894 KAOLIN-PECTIN'
             1264 'D03895 SINCALIDE' 1265 'D03897 LACTASE'
             1266 'D03898 SODIUM CHLORIDE, HYPERTONIC, OPHTHALMIC'
             1267 'D03904 BALSAM PERU/CASTOR OIL/TRYPSIN TOPICAL'
             1268 'D03905 ISOPROTERENOL-PHENYLEPHRINE'
             1269 'D03906 PHENIRAMINE/PHENYLTOLOXAMINE/PYRILAMINE'
             1270 'D03908 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             1271 'D03911 CHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1272 'D03913 APAP/DEXTROMETHORPHAN/PSE/PYRILAMINE'
             1273 'D03915 HYDROCODONE-POTASSIUM GUAIACOLSULFONATE'
             1274 'D03920 FERROUS FUMARATE'
             1275 'D03922 ACETAMINOPHEN-CAFFEINE'
             1276 'D03923 ACETAMINOPHEN-PHENYLEPHRINE'
             1277 'D03926 APAP/CAFFEINE/PYRILAMINE'
             1278 'D03927 BACITRACIN OPHTHALMIC'
             1279 'D03929 AMINOPHYLLINE/AMOBARBITAL/EPHEDRINE'
             1280 'D03946 ASCORBIC ACID-FERROUS FUMARATE'
             1281 'D03951 CITRIC ACID/K CITRATE/NA CITRATE'
             1282 'D03952 CITRIC ACID-SODIUM CITRATE'
             1283 'D03953 ELECTROLYTE REPLACEMENT SOLUTIONS, ORAL'
             1284 'D03954 FERROUS FUMARATE-FOLIC ACID'
             1285 'D03957 CALCIUM/FERROUS FUMARATE/VITAMIN D'
             1286 'D03962 POTASSIUM BICARBONATE-POTASSIUM CITRATE'
             1287 'D03963 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1288 'D03964 BACITRACIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1289 'D03965 BACITRACIN-POLYMYXIN B OPHTHALMIC'
             1290 'D03966 BENZOYL PEROXIDE-SULFUR TOPICAL'
             1291 'D03968 DEXAMETHASONE OPHTHALMIC'
             1292 'D03971 EPINEPHRINE OPHTHALMIC'
             1293 'D03973 ERYTHROMYCIN OPHTHALMIC'
             1294 'D03974 GENTAMICIN OPHTHALMIC'
             1295 'D03975 GLYCERIN OPHTHALMIC'
             1296 'D03976 HYDROCORTISONE OTIC'
             1297 'D03977 OFLOXACIN OPHTHALMIC'
             1298 'D03978 OXYMETAZOLINE OPHTHALMIC'
             1299 'D03979 SCOPOLAMINE OPHTHALMIC'
             1300 'D03980 SULFISOXAZOLE OPHTHALMIC'
             1301 'D03981 TETRACAINE OPHTHALMIC'
             1302 'D03982 TETRACAINE TOPICAL' 1303 'D03984 RITONAVIR'
             1304 'D03985 INDINAVIR' 1305 'D03989 BORIC ACID OPHTHALMIC'
             1306 'D03990 CARBAMIDE PEROXIDE OTIC'
             1307 'D03992 CHLORAMPHENICOL OPHTHALMIC'
             1308 'D03993 CHLORTETRACYCLINE OPHTHALMIC'
             1309 'D03994 COLLOIDAL OATMEAL TOPICAL'
             1310 'D03998 STERILE WATER'
             1311 'D04002 PIPERONYL BUTOXIDE-PYRETHRINS TOPICAL'
             1312 'D04003 HYDROGEN PEROXIDE TOPICAL'
             1313 'D04004 DOXORUBICIN LIPOSOMAL'
             1314 'D04005 AMOBARBITAL-SECOBARBITAL'
             1315 'D04006 DEXFENFLURAMINE' 1316 'D04008 TRANDOLAPRIL'
             1317 'D04009 DOCETAXEL' 1318 'D04010 GEMCITABINE'
             1319 'D04011 INTERFERON BETA-1A' 1320 'D04012 TERBINAFINE'
             1321 'D04014 TOPOTECAN' 1322 'D04015 ADAPALENE TOPICAL'
             1323 'D04016 IODIXANOL' 1324 'D04017 LATANOPROST OPHTHALMIC'
             1325 'D04021 BENZOIC ACID-SALICYLIC ACID TOPICAL'
             1326 'D04025 MIRTAZAPINE' 1327 'D04026 IRINOTECAN'
             1328 'D04027 MEROPENEM' 1329 'D04028 CIDOFOVIR'
             1330 'D04029 NEVIRAPINE' 1331 'D04031 PILOCARPINE'
             1332 'D04032 SULFACETAMIDE SODIUM-SULFUR TOPICAL'
             1333 'D04034 REMIFENTANIL'
             1334 'D04035 AMPHETAMINE-DEXTROAMPHETAMINE'
             1335 'D04036 CAFFEINE-SODIUM BENZOATE'
             1336 'D04037 TIMOLOL OPHTHALMIC'
             1337 'D04038 BETAXOLOL OPHTHALMIC'
             1338 'D04039 CARTEOLOL OPHTHALMIC' 1339 'D04040 FEXOFENADINE'
             1340 'D04041 FOSPHENYTOIN'
             1341 'D04043 FOLLICLE STIMULATING HORMONE'
             1342 'D04044 RESORCINOL TOPICAL'
             1343 'D04045 RESORCINOL-SULFUR TOPICAL' 1344 'D04047 MIDODRINE'
             1345 'D04048 BRIMONIDINE OPHTHALMIC'
             1346 'D04049 AMMONIUM LACTATE TOPICAL' 1347 'D04050 OLANZAPINE'
             1348 'D04051 ROPIVACAINE'
             1349 'D04052 PENTOSAN POLYSULFATE SODIUM'
             1350 'D04053 ZAFIRLUKAST' 1351 'D04054 PENCICLOVIR TOPICAL'
             1352 'D04056 ZINC GLUCONATE' 1353 'D04057 ZINC SULFATE'
             1354 'D04058 MELATONIN'
             1355 'D04059 HAEMOPHILUS B-HEPATITIS B VACCINE'
             1356 'D04060 DILTIAZEM-ENALAPRIL'
             1357 'D04061 BISMUTH SUBSALICYLATE/METRONIDAZOLE/TCN'
             1358 'D04062 BENTOQUATAM TOPICAL'
             1359 'D04063 BUTENAFINE TOPICAL'
             1360 'D04065 TRANDOLAPRIL-VERAPAMIL'
             1361 'D04066 ALBUTEROL-IPRATROPIUM' 1362 'D04067 RETEPLASE'
             1363 'D04068 AZELASTINE NASAL'
             1364 'D04070 SODIUM PHENYLBUTYRATE'
             1365 'D04075 CHLOROXYLENOL TOPICAL'
             1366 'D04076 CHLOROXYLENOL/HYDROCORTISONE/PRAMOXINE OTIC'
             1367 'D04083 GADODIAMIDE' 1368 'D04084 GLYCINE IRRIGATION'
             1369 'D04090 LACTIC ACID TOPICAL'
             1370 'D04093 HYDROCORTISONE-IODOQUINOL TOPICAL'
             1371 'D04095 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OPHTH'
             1372 'D04096 IMIGLUCERASE' 1373 'D04099 DONEPEZIL'
             1374 'D04100 AMPHOTERICIN B CHOLESTERYL SULFATE'
             1375 'D04101 IVERMECTIN' 1376 'D04102 TIZANIDINE'
             1377 'D04103 ZILEUTON' 1378 'D04105 ATORVASTATIN'
             1379 'D04106 FOSFOMYCIN' 1380 'D04107 AMLEXANOX TOPICAL'
             1381 'D04109 LEVOFLOXACIN' 1382 'D04110 MIGLITOL'
             1383 'D04111 GLATIRAMER' 1384 'D04112 CABERGOLINE'
             1385 'D04113 VALSARTAN' 1386 'D04115 TOPIRAMATE'
             1387 'D04116 ENALAPRIL-FELODIPINE'
             1388 'D04117 OLOPATADINE OPHTHALMIC' 1389 'D04118 NELFINAVIR'
             1390 'D04119 DELAVIRDINE' 1391 'D04120 CAFFEINE-ERGOTAMINE'
             1392 'D04121 TAMSULOSIN' 1393 'D04122 TROGLITAZONE'
             1394 'D04123 ZINC ACETATE' 1395 'D04125 IMIQUIMOD TOPICAL'
             1396 'D04126 ANAGRELIDE' 1397 'D04128 LVP SOLUTION'
             1398 'D04130 LVP SOLUTION WITH HYPERTONIC SALINE'
             1399 'D04131 PARENTERAL NUTRITION SOLUTION'
             1400 'D04132 PARENTERAL NUTRITION SOLUTION W/ELECTROLYTES'
             1401 'D04133 NEOMYCIN OPHTHALMIC'
             1402 'D04134 POLYMYXIN B OPHTHALMIC'
             1403 'D04135 PHENYLEPHRINE OPHTHALMIC' 1404 'D04137 TOREMIFENE'
             1405 'D04138 TAZAROTENE TOPICAL' 1406 'D04139 MIBEFRADIL'
             1407 'D04141 HYDROCHLOROTHIAZIDE-MOEXIPRIL'
             1408 'D04142 CHROMIUM PICOLINATE'
             1409 'D04143 ACETAMINOPHEN-PAMABROM' 1410 'D04145 PRAMIPEXOLE'
             1411 'D04147 NAPHAZOLINE NASAL' 1412 'D04150 BROMFENAC'
             1413 'D04151 BENZOCAINE-TRIMETHOBENZAMIDE'
             1414 'D04152 HYDROCODONE-PHENYLEPHRINE'
             1415 'D04153 PHENAZOPYRIDINE-SULFISOXAZOLE'
             1416 'D04155 ASPIRIN-DIPHENHYDRAMINE' 1417 'D04156 LETROZOLE'
             1418 'D04157 LOPERAMIDE-SIMETHICONE' 1419 'D04159 SORBITOL'
             1420 'D04160 SODIUM BIPHOSPHATE-SODIUM PHOSPHATE'
             1421 'D04161 SECRETIN' 1422 'D04163 FERROUS SULFATE-FOLIC ACID'
             1423 'D04166 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PSE'
             1424 'D04168 APAP/DIPHENHYDRAMINE/PSEUDOEPHEDRINE'
             1425 'D04172 CALAMINE-PRAMOXINE TOPICAL'
             1426 'D04175 DIPHENHYDRAMINE-MAGNESIUM SALICYLATE'
             1427 'D04177 FAT SUPPLEMENT, ORAL'
             1428 'D04178 CALCIUM HYDROXIDE TOPICAL'
             1429 'D04184 POTASSIUM AMINOBENZOATE'
             1430 'D04185 POTASSIUM BICARBONATE-SODIUM BICARBONATE'
             1431 'D04186 PHENYLEPHRINE NASAL'
             1432 'D04189 TRIPELENNAMINE TOPICAL'
             1433 'D04190 PAPAIN TOPICAL' 1434 'D04191 PAPAIN-UREA TOPICAL'
             1435 'D04192 COLISTIN/HC/NEOMYCIN/THONZONIUM OTIC'
             1436 'D04193 LEVMETAMFETAMINE NASAL'
             1437 'D04194 PROPYLHEXEDRINE NASAL' 1438 'D04195 CHLOROPHYLLIN'
             1439 'D04196 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B TOPICAL'
             1440 'D04197 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B TOPICAL'
             1441 'D04204 COPPER SULFATE'
             1442 'D04205 POVIDONE IODINE OPHTHALMIC'
             1443 'D04206 TETRAHYDROZOLINE NASAL'
             1444 'D04208 SILVER NITRATE TOPICAL'
             1445 'D04209 METHOXSALEN TOPICAL'
             1446 'D04210 ESTRADIOL TOPICAL' 1447 'D04214 DOLASETRON'
             1448 'D04215 ROPINIROLE' 1449 'D04217 EPINEPHRINE-PRILOCAINE'
             1450 'D04219 LAMIVUDINE-ZIDOVUDINE' 1451 'D04220 QUETIAPINE'
             1452 'D04221 TIAGABINE' 1453 'D04222 IRBESARTAN'
             1454 'D04223 MOMETASONE NASAL'
             1455 'D04224 INTERFERON ALFACON-1'
             1456 'D04225 HYDROCODONE-IBUPROFEN'
             1457 'D04226 AMINOSALICYLIC ACID' 1458 'D04228 ACETIC ACID OTIC'
             1459 'D04229 GLYCERIN OTIC' 1460 'D04231 VITAMIN A OPHTHALMIC'
             1461 'D04233 TRIAMCINOLONE NASAL'
             1462 'D04235 IPRATROPIUM NASAL' 1463 'D04236 ETHANOL TOPICAL'
             1464 'D04238 AMPHOTERICIN B LIPOSOMAL'
             1465 'D04240 HYLAN G-F 20'
             1466 'D04241 POTASSIUM CHLORIDE-SODIUM CHLORIDE'
             1467 'D04242 SODIUM CHLORIDE NASAL'
             1468 'D04243 LIDOCAINE-OXYTETRACYCLINE'
             1469 'D04245 HYDROCHLOROTHIAZIDE-IRBESARTAN'
             1470 'D04247 PEGASPARGASE' 1471 'D04248 METHYLCELLULOSE'
             1472 'D04249 CELLULOSE' 1473 'D04253 ZOLMITRIPTAN'
             1474 'D04255 RITUXIMAB' 1475 'D04256 CEFDINIR'
             1476 'D04258 CLOPIDOGREL' 1477 'D04260 SIBUTRAMINE'
             1478 'D04261 RALOXIFENE' 1479 'D04263 TROVAFLOXACIN'
             1480 'D04264 BECAPLERMIN TOPICAL' 1481 'D04265 OFLOXACIN OTIC'
             1482 'D04266 EPROSARTAN' 1483 'D04267 REPAGLINIDE'
             1484 'D04269 APAP/CAFFEINE/DIHYDROCODEINE'
             1485 'D04270 FEXOFENADINE-PSEUDOEPHEDRINE'
             1486 'D04271 DICLOFENAC-MISOPROSTOL'
             1487 'D04272 AMOXICILLIN/CLARITHROMYCIN/LANSOPRAZOLE'
             1488 'D04274 FOMEPIZOLE' 1489 'D04275 BECLOMETHASONE NASAL'
             1490 'D04276 BUDESONIDE' 1491 'D04279 FLUNISOLIDE NASAL'
             1492 'D04282 TOLCAPONE' 1493 'D04283 FLUTICASONE NASAL'
             1494 'D04284 FLUTICASONE TOPICAL' 1495 'D04285 NARATRIPTAN'
             1496 'D04286 FENOFIBRATE' 1497 'D04287 CIPROFLOXACIN OTIC'
             1498 'D04288 CIPROFLOXACIN-HYDROCORTISONE OTIC'
             1499 'D04289 MONTELUKAST'
             1500 'D04290 CALCIUM CARBONATE-MAGNESIUM HYDROXIDE'
             1501 'D04291 LEPIRUDIN' 1502 'D04292 LOTEPREDNOL OPHTHALMIC'
             1503 'D04293 HYDROCHLOROTHIAZIDE-VALSARTAN'
             1504 'D04294 TOLTERODINE' 1505 'D04295 OXYMETHOLONE'
             1506 'D04296 STARCH TOPICAL'
             1507 'D04297 PHENYLEPHRINE-PRAMOXINE TOPICAL'
             1508 'D04298 PHENYLEPHRINE TOPICAL' 1509 'D04299 SILDENAFIL'
             1510 'D04300 RISEDRONATE' 1511 'D04301 BRINZOLAMIDE OPHTHALMIC'
             1512 'D04303 DORZOLAMIDE-TIMOLOL OPHTHALMIC'
             1513 'D04305 SACROSIDASE' 1514 'D04311 CAPECITABINE'
             1515 'D04312 PARICALCITOL' 1516 'D04314 BASILIXIMAB'
             1517 'D04315 TIROFIBAN' 1518 'D04316 EPTIFIBATIDE'
             1519 'D04320 DIPHTHERIA/HAEMOPHILUS/PERTUSSIS,ACEL/TETANUS'
             1520 'D04321 INTERFERON ALFA-2B-RIBAVIRIN'
             1521 'D04322 CANDESARTAN' 1522 'D04323 PALIVIZUMAB'
             1523 'D04328 RIZATRIPTAN' 1524 'D04329 SODIUM HYALURONATE'
             1525 'D04331 THALIDOMIDE' 1526 'D04332 CITALOPRAM'
             1527 'D04334 EPHEDRINE-POTASSIUM IODIDE'
             1528 'D04339 DEXTROMETHORPHAN-POTASSIUM GUAIACOLSULFONATE'
             1529 'D04342 INFLIXIMAB' 1530 'D04344 ROTAVIRUS VACCINE'
             1531 'D04345 APAP/CAFFEINE/GUAIFENESIN/PHENYLEPHRINE'
             1532 'D04347 DOXYCYCLINE TOPICAL' 1533 'D04349 LEFLUNOMIDE'
             1534 'D04351 COAL TAR/LACTIC ACID/SALICYLIC ACID TOPICAL'
             1535 'D04355 EFAVIRENZ' 1536 'D04357 TRASTUZUMAB'
             1537 'D04360 HEMIN' 1538 'D04363 SEVELAMER'
             1539 'D04364 TELMISARTAN' 1540 'D04365 ETANERCEPT'
             1541 'D04366 SIMETHICONE COATED CELLULOSE'
             1542 'D04368 TANNIC ACID TOPICAL' 1543 'D04369 INSULIN REGULAR'
             1544 'D04370 INSULIN ISOPHANE' 1545 'D04371 INSULIN ZINC'
             1546 'D04372 INSULIN ZINC EXTENDED' 1547 'D04373 INSULIN LISPRO'
             1548 'D04374 INSULIN ISOPHANE-INSULIN REGULAR'
             1549 'D04375 ESTRADIOL-NORETHINDRONE' 1550 'D04376 ABACAVIR'
             1551 'D04377 THYROTROPIN ALPHA' 1552 'D04378 MODAFINIL'
             1553 'D04379 LYME DISEASE VACCINE' 1554 'D04380 CELECOXIB'
             1555 'D04382 CILOSTAZOL' 1556 'D04386 DENILEUKIN DIFTITOX'
             1557 'D04387 SODIUM FERRIC GLUCONATE COMPLEX'
             1558 'D04389 PENTASTARCH' 1559 'D04391 LIVER DERIVATIVE COMPLEX'
             1560 'D04393 BUTABARBITAL/HYOSCYAMINE/PHENAZOPYRIDINE'
             1561 'D04394 CROMOLYN NASAL' 1562 'D04395 CLOTRIMAZOLE TOPICAL'
             1563 'D04396 CONJUGATED ESTROGENS TOPICAL'
             1564 'D04397 FLUORIDE TOPICAL' 1565 'D04399 NYSTATIN TOPICAL'
             1566 'D04402 CILASTATIN' 1567 'D04406 TYPHOID VACCINE, LIVE'
             1568 'D04407 ECHINACEA' 1569 'D04408 ST. JOHN''S WORT'
             1570 'D04409 CHAMOMILE' 1571 'D04410 FEVERFEW'
             1572 'D04411 GARLIC' 1573 'D04412 GINSENG' 1574 'D04413 GINKGO'
             1575 'D04414 GINGER' 1576 'D04415 SAW PALMETTO'
             1577 'D04416 VALERIAN' 1578 'D04417 CREATINE'
             1579 'D04418 GLUCOSAMINE' 1580 'D04419 CHONDROITIN'
             1581 'D04420 CHONDROITIN-GLUCOSAMINE'
             1582 'D04421 EVENING PRIMROSE' 1583 'D04422 KAVA'
             1584 'D04423 GOLDENSEAL' 1585 'D04425 DEHYDROEPIANDROSTERONE'
             1586 'D04426 RED YEAST RICE' 1587 'D04427 LEVALBUTEROL'
             1588 'D04429 ORLISTAT'
             1589 'D04430 BACITRACIN/NEOMYCIN/POLYMYXIN B/PRAMOXINE TOP'
             1590 'D04431 NEOMYCIN/POLYMYXIN B/PRAMOXINE TOPICAL'
             1591 'D04432 CARBONYL IRON' 1592 'D04433 ROFECOXIB'
             1593 'D04434 ROSIGLITAZONE' 1594 'D04435 DOXERCALCIFEROL'
             1595 'D04436 MALATHION TOPICAL' 1596 'D04440 PERINDOPRIL'
             1597 'D04441 KETOTIFEN OPHTHALMIC' 1598 'D04442 PIOGLITAZONE'
             1599 'D04443 ZANAMIVIR'
             1600 'D04445 CARBETAPENTANE/CHLORPHENIRAMINE/PHENYLEPHRINE'
             1601 'D04446 PHENYLEPHRINE-PYRILAMINE' 1602 'D04447 GANIRELIX'
             1603 'D04448 RABEPRAZOLE' 1604 'D04451 TEMOZOLOMIDE'
             1605 'D04452 ZALEPLON' 1606 'D04453 SIROLIMUS'
             1607 'D04454 EPIRUBICIN' 1608 'D04457 DALFOPRISTIN-QUINUPRISTIN'
             1609 'D04458 PEMIROLAST OPHTHALMIC' 1610 'D04459 DOFETILIDE'
             1611 'D04460 ENTACAPONE' 1612 'D04461 EXEMESTANE'
             1613 'D04462 OSELTAMIVIR' 1614 'D04463 GRAPE SEED OIL'
             1615 'D04464 DONG QUAI' 1616 'D04466 MILK THISTLE'
             1617 'D04467 CAT''S CLAW' 1618 'D04469 BEE POLLEN'
             1619 'D04470 CRANBERRY' 1620 'D04472 BLACK COHOSH'
             1621 'D04473 BLUE COHOSH' 1622 'D04478 WILD YAM'
             1623 'D04479 PENNYROYAL' 1624 'D04481 ROYAL JELLY'
             1625 'D04482 DAMIANA' 1626 'D04483 DANDELION'
             1627 'D04484 SHARK CARTILAGE' 1628 'D04491 FLAX'
             1629 'D04492 FENUGREEK' 1630 'D04497 ASPIRIN-DIPYRIDAMOLE'
             1631 'D04498 NAPROXEN-PSEUDOEPHEDRINE'
             1632 'D04499 LEVETIRACETAM' 1633 'D04500 MOXIFLOXACIN'
             1634 'D04501 AMINOLEVULINIC ACID TOPICAL'
             1635 'D04503 NEDOCROMIL OPHTHALMIC' 1636 'D04504 GATIFLOXACIN'
             1637 'D04505 DEXMEDETOMIDINE'
             1638 'D04506 ESTRADIOL-NORGESTIMATE' 1639 'D04507 BEXAROTENE'
             1640 'D04508 NITRIC OXIDE'
             1641 'D04509 HYDROCHLOROTHIAZIDE-QUINAPRIL'
             1642 'D04510 INSULIN LISPRO-INSULIN LISPRO PROTAMINE'
             1643 'D04512 CEVIMELINE' 1644 'D04513 OXCARBAZEPINE'
             1645 'D04514 PANTOPRAZOLE' 1646 'D04515 GADOVERSETAMIDE'
             1647 'D04516 ALOSETRON' 1648 'D04523 UBIQUINONE'
             1649 'D04524 S-ADENOSYLMETHIONINE' 1650 'D04527 ZONISAMIDE'
             1651 'D04530 STRONTIUM-89 CHLORIDE'
             1652 'D04531 SAMARIUM SM 153 LEXIDRONAM' 1653 'D04532 MELOXICAM'
             1654 'D04533 VERTEPORFIN' 1655 'D04534 LINEZOLID'
             1656 'D04535 ARTICAINE-EPINEPHRINE' 1657 'D04536 ARTICAINE'
             1658 'D04537 RIVASTIGMINE' 1659 'D04538 INSULIN GLARGINE'
             1660 'D04539 FOSINOPRIL-HYDROCHLOROTHIAZIDE'
             1661 'D04540 GEMTUZUMAB' 1662 'D04541 AZELASTINE OPHTHALMIC'
             1663 'D04547 ATOVAQUONE-PROGUANIL' 1664 'D04557 CLOBAZAM'
             1665 'D04572 FORMOTEROL' 1666 'D04597 TETRABENAZINE'
             1667 'D04611 FLUTICASONE-SALMETEROL' 1668 'D04659 TINZAPARIN'
             1669 'D04669 VIGABATRIN'
             1670 'D04674 DIPHTH/HAEMOPHILUS/PERTUSSIS/TETANUS/POLIO'
             1671 'D04675 DIPHTHERIA/PERTUSSIS,ACEL/TETANUS/POLIO'
             1672 'D04685 HEPATITIS A-HEPATITIS B VACCINE'
             1673 'D04689 CALAMINE-DIPHENHYDRAMINE TOPICAL'
             1674 'D04694 TENECTEPLASE' 1675 'D04695 COLESEVELAM'
             1676 'D04697 INSULIN ASPART' 1677 'D04698 ARGATROBAN'
             1678 'D04700 BALSALAZIDE' 1679 'D04702 DOCOSANOL TOPICAL'
             1680 'D04703 GLYBURIDE-METFORMIN'
             1681 'D04704 EFLORNITHINE TOPICAL'
             1682 'D04705 FLUDEOXYGLUCOSE F18'
             1683 'D04707 LEVOFLOXACIN OPHTHALMIC'
             1684 'D04708 ZOLEDRONIC ACID'
             1685 'D04711 CANDESARTAN-HYDROCHLOROTHIAZIDE'
             1686 'D04716 LOPINAVIR' 1687 'D04717 LOPINAVIR-RITONAVIR'
             1688 'D04718 MIFEPRISTONE' 1689 'D04720 ARSENIC TRIOXIDE'
             1690 'D04722 DICLOFENAC TOPICAL'
             1691 'D04723 CALCIUM CARBONATE/FAMOTIDINE/MG HYDROXIDE'
             1692 'D04725 IRON SUCROSE' 1693 'D04726 5-HYDROXYTRYPTOPHAN'
             1694 'D04727 ABACAVIR/LAMIVUDINE/ZIDOVUDINE'
             1695 'D04737 HYDROCHLOROTHIAZIDE-TELMISARTAN'
             1696 'D04738 APAP/DOXYLAMINE/PSEUDOEPHEDRINE'
             1697 'D04740 TACROLIMUS TOPICAL'
             1698 'D04741 CARBETAPENTANE/GUAIFENESIN/PHENYLEPHRINE'
             1699 'D04742 BENZOYL PEROXIDE-CLINDAMYCIN TOPICAL'
             1700 'D04743 NATEGLINIDE' 1701 'D04744 BIVALIRUDIN'
             1702 'D04746 PEGINTERFERON ALFA-2B' 1703 'D04747 ZIPRASIDONE'
             1704 'D04748 CASPOFUNGIN' 1705 'D04749 ESOMEPRAZOLE'
             1706 'D04750 GALANTAMINE'
             1707 'D04752 CARBINOXAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1708 'D04753 TRAVOPROST OPHTHALMIC'
             1709 'D04754 BIMATOPROST OPHTHALMIC'
             1710 'D04755 VALGANCICLOVIR' 1711 'D04756 ALEMTUZUMAB'
             1712 'D04757 ALMOTRIPTAN' 1713 'D04758 IMATINIB'
             1714 'D04760 DROSPIRENONE-ETHINYL ESTRADIOL'
             1715 'D04761 MINOCYCLINE TOPICAL'
             1716 'D04762 METHSCOPOLAMINE-PSEUDOEPHEDRINE'
             1717 'D04763 NESIRITIDE'
             1718 'D04764 CETIRIZINE-PSEUDOEPHEDRINE'
             1719 'D04765 HYDROCORTISONE-LIDOCAINE TOPICAL'
             1720 'D04766 ACETAMINOPHEN-TRAMADOL' 1721 'D04767 CEFDITOREN'
             1722 'D04770 CARBETAPENTANE-CHLORPHENIRAMINE'
             1723 'D04771 DARBEPOETIN ALFA' 1724 'D04772 ETONOGESTREL'
             1725 'D04773 ETHINYL ESTRADIOL-ETONOGESTREL'
             1726 'D04774 TENOFOVIR' 1727 'D04775 ANAKINRA'
             1728 'D04776 FROVATRIPTAN' 1729 'D04777 DEXMETHYLPHENIDATE'
             1730 'D04778 VALDECOXIB'
             1731 'D04779 ETHINYL ESTRADIOL-NORELGESTROMIN'
             1732 'D04782 BOSENTAN' 1733 'D04783 ERTAPENEM'
             1734 'D04784 PIMECROLIMUS TOPICAL' 1735 'D04785 DESLORATADINE'
             1736 'D04786 FONDAPARINUX' 1737 'D04787 LOVASTATIN-NIACIN'
             1738 'D04788 DUTASTERIDE' 1739 'D04789 NITISINONE'
             1740 'D04790 PEGFILGRASTIM'
             1741 'D04791 FLUOCINOLONE/HYDROQUINONE/TRETINOIN TOPICAL'
             1742 'D04792 ASA/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1743 'D04793 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PE'
             1744 'D04794 CARBINOXAMINE/METHSCOPOLAMINE/PSEUDOEPHEDRINE'
             1745 'D04795 BUDESONIDE-FORMOTEROL' 1746 'D04796 PERFLUTREN'
             1747 'D04797 ALFUZOSIN' 1748 'D04798 TEGASEROD'
             1749 'D04799 FULVESTRANT' 1750 'D04800 IFOSFAMIDE-MESNA'
             1751 'D04801 OLMESARTAN' 1752 'D04802 TREPROSTINIL'
             1753 'D04803 VORICONAZOLE' 1754 'D04805 RASBURICASE'
             1755 'D04806 SODIUM OXYBATE' 1756 'D04811 OXALIPLATIN'
             1757 'D04812 ESCITALOPRAM' 1758 'D04814 ADEFOVIR'
             1759 'D04815 EPLERENONE'
             1760 'D04817 DEXCHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             1761 'D04818 DEXCHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             1762 'D04819 BUPRENORPHINE-NALOXONE'
             1763 'D04820 METFORMIN-ROSIGLITAZONE'
             1764 'D04821 PEGINTERFERON ALFA-2A'
             1765 'D04823 GLIPIZIDE-METFORMIN' 1766 'D04824 EZETIMIBE'
             1767 'D04825 ARIPIPRAZOLE' 1768 'D04826 NITAZOXANIDE'
             1769 'D04827 ATOMOXETINE' 1770 'D04828 TERIPARATIDE'
             1771 'D04829 TIOTROPIUM' 1772 'D04831 SMALLPOX VACCINE'
             1773 'D04832 DIPHTHERIA/HEPB/PERTUSSIS,ACEL/POLIO/TETANUS'
             1774 'D04834 CYTARABINE LIPOSOMAL' 1775 'D04835 ADALIMUMAB'
             1776 'D04836 CYCLOSPORINE OPHTHALMIC'
             1777 'D04838 INSULIN ASPART PROTAMINE'
             1778 'D04839 INSULIN ASPART-INSULIN ASPART PROTAMINE'
             1779 'D04843 ALEFACEPT' 1780 'D04844 CAMPHOR-MENTHOL TOPICAL'
             1781 'D04845 IBRITUMOMAB' 1782 'D04849 ELETRIPTAN'
             1783 'D04850 CARBETAPENTANE/PHENYLEPHRINE/PYRILAMINE'
             1784 'D04851 ROSUVASTATIN' 1785 'D04852 BUPIVACAINE-FENTANYL'
             1786 'D04853 ENFUVIRTIDE' 1787 'D04854 PEGVISOMANT'
             1788 'D04855 APREPITANT' 1789 'D04856 BOTULISM ANTITOXIN'
             1790 'D04857 GATIFLOXACIN OPHTHALMIC'
             1791 'D04858 ANTHRAX VACCINE ADSORBED'
             1792 'D04859 GEMIFLOXACIN' 1793 'D04860 MOXIFLOXACIN OPHTHALMIC'
             1794 'D04861 DIPHENHYDRAMINE-PHENYLEPHRINE'
             1795 'D04862 BROMPHENIRAMINE/DM/GUAIFENESIN/PSE'
             1796 'D04863 CHLORPHENIRAMINE/IBUPROFEN/PSEUDOEPHEDRINE'
             1797 'D04864 CARBETAPENTANE-PSEUDOEPHEDRINE'
             1798 'D04866 AGALSIDASE BETA' 1799 'D04868 GEFITINIB'
             1800 'D04869 CHLORPHENIRAMINE/DIHYDROCODEINE/PSE'
             1801 'D04870 DIHYDROCODEINE/GUAIFENESIN/PSEUDOEPHEDRINE'
             1802 'D04871 BORTEZOMIB' 1803 'D04875 BETAINE'
             1804 'D04877 CARBIDOPA/ENTACAPONE/LEVODOPA'
             1805 'D04878 HYDROCHLOROTHIAZIDE-OLMESARTAN'
             1806 'D04879 PHENYLEPHRINE-POTASSIUM GUAIACOLSULFONATE'
             1807 'D04880 BROMPHENIRAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1808 'D04881 OMALIZUMAB' 1809 'D04882 ATAZANAVIR'
             1810 'D04884 EMTRICITABINE' 1811 'D04885 TOSITUMOMAB'
             1812 'D04886 IODINE I 131 TOSITUMOMAB'
             1813 'D04887 BUPIVACAINE-HYDROMORPHONE'
             1814 'D04888 PALONOSETRON'
             1815 'D04890 CIPROFLOXACIN-DEXAMETHASONE OTIC'
             1816 'D04892 INFLUENZA VIRUS VACCINE, LIVE, TRIVALENT'
             1817 'D04893 VARDENAFIL' 1818 'D04894 DAPTOMYCIN'
             1819 'D04895 CARBETAPENTANE/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1820 'D04896 TADALAFIL'
             1821 'D04897 TETRAHYDROZOLINE-ZINC OPHTHALMIC'
             1822 'D04898 EPINASTINE OPHTHALMIC' 1823 'D04899 MEMANTINE'
             1824 'D04900 SALICYLIC ACID-UREA TOPICAL'
             1825 'D04901 FOSAMPRENAVIR' 1826 'D04902 EFALIZUMAB'
             1827 'D04905 BROMPHENIRAMINE/DEXTROMETHORPH/PHENYLEPHRINE'
             1828 'D04913 LANSOPRAZOLE-NAPROXEN'
             1829 'D04914 ESTRADIOL-LEVONORGESTREL'
             1830 'D04915 SERTACONAZOLE TOPICAL' 1831 'D04916 CAPSICUM'
             1832 'D04917 FLUOXETINE-OLANZAPINE'
             1833 'D04920 PNEUMOCOCCAL 7-VALENT CONJUGATE VACCINE'
             1834 'D04921 TETANUS-DIPHTH TOXOIDS (TD) ADULT/ADOL'
             1835 'D04925 DIPHENHYDRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1836 'D04929 TROSPIUM' 1837 'D04933 TELITHROMYCIN'
             1838 'D04935 TINIDAZOLE' 1839 'D04986 ACAMPROSATE'
             1840 'D04991 APOMORPHINE' 1841 'D05029 LUTROPIN ALFA'
             1842 'D05044 BETAMETHASONE-CALCIPOTRIENE TOPICAL'
             1843 'D05047 PEMETREXED' 1844 'D05048 AMLODIPINE-ATORVASTATIN'
             1845 'D05101 CETUXIMAB'
             1846 'D05117 GUAIFENESIN-POTASSIUM GUAIACOLSULFONATE'
             1847 'D05119 DEXTROMETHORPHAN/GG/K GUAIACOLSULFONATE'
             1848 'D05145 ARTEMETHER-LUMEFANTRINE'
             1849 'D05150 CARBINOXAMINE/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1850 'D05214 BEVACIZUMAB' 1851 'D05215 ZINC ACETATE TOPICAL'
             1852 'D05216 DIPHENHYDRAMINE-ZINC ACETATE TOPICAL'
             1853 'D05217 MYCOPHENOLIC ACID' 1854 'D05218 CINACALCET'
             1855 'D05232 ILOPROST' 1856 'D05234 HYALURONAN'
             1857 'D05238 BENZOYL PEROXIDE-UREA TOPICAL'
             1858 'D05262 MOMETASONE' 1859 'D05265 NEBIVOLOL'
             1860 'D05269 CADEXOMER IODINE TOPICAL'
             1861 'D05278 INSULIN GLULISINE'
             1862 'D05283 BRIMONIDINE-TIMOLOL OPHTHALMIC'
             1863 'D05292 APAP/CAFFEINE/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1864 'D05293 AZACITIDINE' 1865 'D05294 RIFAXIMIN'
             1866 'D05303 CHLORPHENIRAMINE-CODEINE'
             1867 'D05332 PITCHER PLANT'
             1868 'D05334 BROMPHENIRAMINE/CODEINE/PHENYLEPHRINE'
             1869 'D05337 PNEUMOCOCCAL 23-POLYVALENT VACCINE'
             1870 'D05338 DIPHTHERIA-TETANUS TOXOIDS (DT) PED'
             1871 'D05339 HEPATITIS A PEDIATRIC VACCINE'
             1872 'D05340 HEPATITIS A ADULT VACCINE'
             1873 'D05341 HAEMOPHILUS B CONJUGATE (HBOC) VACCINE'
             1874 'D05343 HAEMOPHILUS B CONJUGATE (PRP-T) VACCINE'
             1875 'D05346 GADOBUTROL' 1876 'D05348 EZETIMIBE-SIMVASTATIN'
             1877 'D05349 BISACODYL-PEG 3350 WITH ELECTROLYTES'
             1878 'D05350 POLYETHYLENE GLYCOL 3350'
             1879 'D05351 APAP/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1880 'D05352 EMTRICITABINE-TENOFOVIR'
             1881 'D05354 ABACAVIR-LAMIVUDINE' 1882 'D05355 DULOXETINE'
             1883 'D05357 IBANDRONATE'
             1884 'D05361 CARBETAPENTANE-GUAIFENESIN'
             1885 'D05366 APAP/DEXTROMETHORPHAN/DOXYLAMINE'
             1886 'D05383 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1887 'D05384 DEXTROMETHORPHAN/PHENIRAMINE/PHENYLEPHRINE'
             1888 'D05389 BISACODYL-MAGNESIUM CITRATE'
             1889 'D05395 LANTHANUM CARBONATE'
             1890 'D05411 CHLORPHENIRAMINE-METHSCOPOLAMINE'
             1891 'D05412 ERLOTINIB' 1892 'D05413 SOLIFENACIN'
             1893 'D05414 NATALIZUMAB' 1894 'D05415 IBUPROFEN-OXYCODONE'
             1895 'D05416 CHLORDIAZEPOXIDE-METHSCOPOLAMINE'
             1896 'D05417 PALIFERMIN' 1897 'D05418 PEGAPTANIB OPHTHALMIC'
             1898 'D05420 ALOH/DIPHENHYD/LIDOCAINE/MGOH/SIMETH TOPICAL'
             1899 'D05421 ESZOPICLONE' 1900 'D05422 DARIFENACIN'
             1901 'D05423 CLOFARABINE' 1902 'D05424 ZICONOTIDE'
             1903 'D05425 LOTEPREDNOL-TOBRAMYCIN OPHTHALMIC'
             1904 'D05426 BROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1905 'D05427 PACLITAXEL PROTEIN-BOUND'
             1906 'D05428 GADOBENATE DIMEGLUMINE'
             1907 'D05432 MENINGOCOCCAL CONJUGATE VACCINE'
             1908 'D05433 DIGESTIVE ENZYMES/HYOSCYAMINE/PHENYLTOLOXAMIN'
             1909 'D05434 BROMPHENIRAMINE/CARBETAPENTANE/PHENYLEPHRINE'
             1910 'D05436 INSULIN DETEMIR'
             1911 'D05459 POVIDONE-TETRAHYDROZOLINE OPHTHALMIC'
             1912 'D05461 SODIUM BENZOATE-SODIUM PHENYLACETATE'
             1913 'D05465 CICLESONIDE'
             1914 'D05470 ASCORBIC ACID-IRON POLYSACCHARIDE'
             1915 'D05471 ALPHA-D-GALACTOSIDASE'
             1916 'D05473 DESLORATADINE-PSEUDOEPHEDRINE'
             1917 'D05487 MICAFUNGIN' 1918 'D05488 PRAMLINTIDE'
             1919 'D05508 PREGABALIN' 1920 'D05518 BROMFENAC OPHTHALMIC'
             1921 'D05525 ENTECAVIR'
             1922 'D05526 ALENDRONATE-CHOLECALCIFEROL'
             1923 'D05527 FLUOCINOLONE OPHTHALMIC'
             1924 'D05528 TRICHOPHYTON SKIN TEST' 1925 'D05529 EXENATIDE'
             1926 'D05530 DROSPIRENONE-ESTRADIOL'
             1927 'D05535 HEME IRON POLYPEPTIDE'
             1928 'D05536 APAP/GUAIFENESIN/PSEUDOEPHEDRINE'
             1929 'D05537 TIGECYCLINE' 1930 'D05538 TIPRANAVIR'
             1931 'D05539 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1932 'D05540 HYDRALAZINE-ISOSORBIDE DINITRATE'
             1933 'D05543 DAPSONE TOPICAL'
             1934 'D05544 APAP/GUAIFENESIN/PHENYLEPHRINE'
             1935 'D05578 RAMELTEON'
             1936 'D05583 APAP/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1937 'D05612 RASAGILINE' 1938 'D05626 EVEROLIMUS'
             1939 'D05630 CALCIUM CARBONATE-RISEDRONATE'
             1940 'D05632 BISACODYL/SODIUM BIPHOSPHATE/SODIUM PHOSPHATE'
             1941 'D05633 NEPAFENAC OPHTHALMIC'
             1942 'D05635 METFORMIN-PIOGLITAZONE' 1943 'D05636 MECASERMIN'
             1944 'D05637 LACTOBACILLUS RHAMNOSUS GG'
             1945 'D05644 APAP/CAFFEINE/ISOMETHEPTENE MUCATE'
             1946 'D05645 MEASLES/MUMPS/RUBELLA/VARICELLA VIRUS VACCINE'
             1947 'D05646 SACCHAROMYCES BOULARDII LYO'
             1948 'D05647 FERRIC SUBSULFATE TOPICAL'
             1949 'D05649 CEFTRIAXONE-LIDOCAINE'
             1950 'D05651 SODIUM HYALURONATE TOPICAL'
             1951 'D05654 APAP/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1952 'D05659 DEFERASIROX'
             1953 'D05661 ACETAMINOPHEN-GUAIFENESIN'
             1954 'D05674 GLIMEPIRIDE-ROSIGLITAZONE' 1955 'D05691 SORAFENIB'
             1956 'D05692 MECASERMIN RINFABATE' 1957 'D05694 ABATACEPT'
             1958 'D05696 LENALIDOMIDE' 1959 'D05702 METHYLSULFONYLMETHANE'
             1960 'D05703 CHONDROITIN/GLUCOSAMINE/METHYLSULFONYLMETHANE'
             1961 'D05704 IMMUNE GLOBULIN SUBCUTANEOUS'
             1962 'D05717 SUNITINIB' 1963 'D05719 RANOLAZINE'
             1964 'D05722 GALLIUM CITRATE GA-67' 1965 'D05736 LUBIPROSTONE'
             1966 'D05753 MICONAZOLE-ZINC OXIDE TOPICAL'
             1967 'D05757 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PE'
             1968 'D05765 INSULIN INHALATION, RAPID ACTING'
             1969 'D05768 APAP/PHENIRAMINE/PHENYLEPHRINE'
             1970 'D05770 OMEPRAZOLE-SODIUM BICARBONATE'
             1971 'D05773 L-METHYLFOLATE'
             1972 'D05774 AMMONIUM LACTATE-UREA TOPICAL' 1973 'D05776 IODINE'
             1974 'D05777 IODINE-POTASSIUM IODIDE'
             1975 'D05778 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PE'
             1976 'D05781 TETANUS/DIPHTH/PERTUSS (TDAP) ADULT/ADOL'
             1977 'D05782 DIPHTHERIA/TETANUS/PERTUSSIS (DTAP) PED'
             1978 'D05785 RABIES VACCINE, HUMAN DIPLOID CELL'
             1979 'D05786 RABIES VACCINE, PURIFIED CHICK EMBRYO CELL'
             1980 'D05788 DECITABINE'
             1981 'D05806 FERROUS FUMARATE/FA/IRON POLYSACCHARIDE'
             1982 'D05807 VARENICLINE' 1983 'D05813 ZOSTER VACCINE LIVE'
             1984 'D05814 DEXTROMETHORPHAN-PHENYLEPHRINE'
             1985 'D05815 FLUORESCEIN'
             1986 'D05817 HUMAN PAPILLOMAVIRUS VACCINE'
             1987 'D05819 DIPHENHYDRAMINE-IBUPROFEN' 1988 'D05825 DARUNAVIR'
             1989 'D05830 FERUMOXSIL' 1990 'D05831 DASATINIB'
             1991 'D05835 RANIBIZUMAB OPHTHALMIC'
             1992 'D05847 EFAVIRENZ/EMTRICITABINE/TENOFOVIR'
             1993 'D05848 ROTIGOTINE' 1994 'D05851 LEVOCETIRIZINE'
             1995 'D05853 POSACONAZOLE' 1996 'D05855 IDURSULFASE'
             1997 'D05856 GLIMEPIRIDE-PIOGLITAZONE'
             1998 'D05864 COMPLEMENT C1 ESTERASE INHIBITOR'
             1999 'D05866 GUAR GUM'
             2000 'D05874 ANTIHEMOPHILIC FACTOR-VON WILLEBRAND FACTOR'
             2001 'D05877 DEXTROMETHORPHAN/DIPHENHYDRAMINE/PE'
             2002 'D05878 BENZALKONIUM CHLORIDE-BENZOCAINE TOPICAL'
             2003 'D05879 PANITUMUMAB' 2004 'D05891 VORINOSTAT'
             2005 'D05892 DEXCHLORPHENIRAMINE/DEXTROMETHO/PE/PYRILAMINE'
             2006 'D05893 ARFORMOTEROL'
             2007 'D05894 CALAMINE-ZINC OXIDE TOPICAL'
             2008 'D05896 SITAGLIPTIN'
             2009 'D05897 BENZOYL PEROXIDE-SALICYLIC ACID TOPICAL'
             2010 'D05899 CICLESONIDE NASAL'
             2011 'D05963 COAGULATION FACTOR IX' 2012 'D05964 ALOE VERA'
             2013 'D05973 CLINDAMYCIN-TRETINOIN TOPICAL'
             2014 'D05974 ANTIHEMOPHILIC FACTOR'
             2015 'D06008 BENZYL ALCOHOL TOPICAL'
             2016 'D06032 FLUOCINOLONE OTIC'
             2017 'D06058 DEXBROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             2018 'D06080 APAP/CAFFEINE/MAGNESIUM SALICYLATE'
             2019 'D06214 COLLAGEN' 2020 'D06227 IOXILAN'
             2021 'D06272 DIENOGEST-ESTRADIOL' 2022 'D06297 PALIPERIDONE'
             2023 'D06370 TURMERIC' 2024 'D06392 WHEAT DEXTRIN'
             2025 'D06507 CINNAMON' 2026 'D06635 MILNACIPRAN'
             2027 'D06648 ATROPINE/CPM/HYOSCYAMINE/PSE/SCOPOLAMINE'
             2028 'D06655 ALPHA-LIPOIC ACID'
             2029 'D06662 AMLODIPINE-VALSARTAN'
             2030 'D06663 LISDEXAMFETAMINE' 2031 'D06665 ALISKIREN'
             2032 'D06672 LAPATINIB' 2033 'D06673 ECULIZUMAB'
             2034 'D06720 METFORMIN-SITAGLIPTIN'
             2035 'D06831 RETAPAMULIN TOPICAL'
             2036 'D06833 ACETAMINOPHEN-ASPIRIN'
             2037 'D06834 BISMUTH SUBCITRATE POTASSIUM/METRONIDAZO/TCN'
             2038 'D06835 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             2039 'D06836 TEMSIROLIMUS' 2040 'D06841 AMBRISENTAN'
             2041 'D06842 ARMODAFINIL' 2042 'D06848 LUTEIN'
             2043 'D06851 AZITHROMYCIN OPHTHALMIC' 2044 'D06852 MARAVIROC'
             2045 'D06857 ACETIC/ANTIPYRINE/BENZOCAINE/POLYCOS OTIC'
             2046 'D06862 HELIUM' 2047 'D06864 HELIUM-OXYGEN'
             2048 'D06867 BIOTIN' 2049 'D06868 MENTHOL-ZINC OXIDE TOPICAL'
             2050 'D06872 APAP/CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             2051 'D06891 CHLOROPHYLLIN COPPER COM/PAPAIN/UREA TOPICAL'
             2052 'D06900 COLLAGEN TOPICAL'
             2053 'D06905 AMLODIPINE-OLMESARTAN'
             2054 'D06976 ASA/CHLORPHENIRAMINE/PHENYLEPHRINE'
             2055 'D07048 RALTEGRAVIR' 2056 'D07049 DORIPENEM'
             2057 'D07051 IXABEPILONE'
             2058 'D07055 CHLORPHENIRAMINE/GUAIFENESIN/METHSCOPOLAMI/PE'
             2059 'D07057 NILOTINIB'
             2060 'D07058 SULFACETAMIDE SODIUM/SULFUR/UREA TOPICAL'
             2061 'D07059 CITRIC ACID-POTASSIUM BICARBONATE'
             2062 'D07063 BROMPHENIRAMINE-DIPHENHYDRAMINE'
             2063 'D07065 BENZYL ALCOHOL-ZINC ACETATE TOPICAL'
             2064 'D07068 SAPROPTERIN' 2065 'D07069 RUFINAMIDE'
             2066 'D07075 PERMETHRIN/PIPERONYL BUTOXIDE/PYRETHR TOPICAL'
             2067 'D07076 ETRAVIRINE'
             2068 'D07077 ALISKIREN-HYDROCHLOROTHIAZIDE'
             2069 'D07110 NIACIN-SIMVASTATIN' 2070 'D07113 DESVENLAFAXINE'
             2071 'D07121 BENDAMUSTINE' 2072 'D07130 NAPROXEN-SUMATRIPTAN'
             2073 'D07131 REGADENOSON' 2074 'D07132 OLOPATADINE NASAL'
             2075 'D07134 CERTOLIZUMAB' 2076 'D07135 METHYLNALTREXONE'
             2077 'D07137 DABIGATRAN' 2078 'D07162 FESOTERODINE'
             2079 'D07292 METFORMIN-REPAGLINIDE'
             2080 'D07298 DIFLUPREDNATE OPHTHALMIC'
             2081 'D07300 CHLOPHEDIANOL/DEXCHLORPHENIRAMINE/PSE'
             2082 'D07302 CHLOPHEDIANOL/GUAIFENESIN/PSEUDOEPHEDRINE'
             2083 'D07306 BENZOCAINE-MENTHOL TOPICAL' 2084 'D07309 GENISTEIN'
             2085 'D07312 CLEVIDIPINE' 2086 'D07315 GLUTAMINE'
             2087 'D07320 ROMIPLOSTIM' 2088 'D07347 BIFIDOBACTERIUM INFANTIS'
             2089 'D07349 LACOSAMIDE'
             2090 'D07351 CARBETAPENTANE/PSEUDOEPHEDRINE/PYRILAMINE'
             2091 'D07354 SILODOSIN' 2092 'D07356 RIVAROXABAN'
             2093 'D07357 ELTROMBOPAG' 2094 'D07371 FENOFIBRIC ACID'
             2095 'D07374 BIMATOPROST TOPICAL OPHTHALMIC'
             2096 'D07382 ADAPALENE-BENZOYL PEROXIDE TOPICAL'
             2097 'D07385 HEPARIN FLUSH'
             2098 'D07387 HYDROCORTISONE/SALICYLIC ACID/SULFUR TOPICAL'
             2099 'D07395 DEXLANSOPRAZOLE' 2100 'D07396 USTEKINUMAB'
             2101 'D07397 FEBUXOSTAT'
             2102 'D07405 CARBETAPENTANE/PE/POTASSIUM GUAIACOLSULFONATE'
             2103 'D07409 PRASUGREL' 2104 'D07411 DEGARELIX'
             2105 'D07418 BENZOCAINE-RESORCINOL TOPICAL'
             2106 'D07435 GOLIMUMAB'
             2107 'D07440 AMLODIPINE/HYDROCHLOROTHIAZIDE/VALSARTAN'
             2108 'D07441 ILOPERIDONE' 2109 'D07447 TOLVAPTAN'
             2110 'D07453 TAPENTADOL' 2111 'D07458 DRONEDARONE'
             2112 'D07459 FERUMOXYTOL'
             2113 'D07464 INFLUENZA VIRUS VACCINE, H1N1, INACTIVATED'
             2114 'D07466 LIRAGLUTIDE' 2115 'D07467 SAXAGLIPTIN'
             2116 'D07472 MORPHINE-NALTREXONE' 2117 'D07473 ASENAPINE'
             2118 'D07481 POLY-L-LACTIC ACID'
             2119 'D07482 BEPOTASTINE OPHTHALMIC' 2120 'D07483 TELAVANCIN'
             2121 'D07485 INFLUENZA VIRUS VACCINE, H1N1, LIVE'
             2122 'D07486 ALISKIREN-VALSARTAN'
             2123 'D07491 DIPHENHYDRAMINE/LIDOCAINE/NYSTATIN TOPICAL'
             2124 'D07492 PRALATREXATE' 2125 'D07496 TOCILIZUMAB'
             2126 'D07498 AMLODIPINE-TELMISARTAN' 2127 'D07499 PAZOPANIB'
             2128 'D07505 COPPER' 2129 'D07509 OFATUMUMAB'
             2130 'D07518 SILVER TOPICAL' 2131 'D07546 DALFAMPRIDINE'
             2132 'D07550 DEXTROMETHORPHAN-DOXYLAMINE'
             2133 'D07565 IPILIMUMAB'
             2134 'D07586 PNEUMOCOCCAL 13-VALENT CONJUGATE VACCINE'
             2135 'D07589 BIOFLAVONOIDS-ZINC GLYCINATE'
             2136 'D07631 ESOMEPRAZOLE-NAPROXEN'
             2137 'D07634 DUTASTERIDE-TAMSULOSIN' 2138 'D07637 PITAVASTATIN'
             2139 'D07638 SIPULEUCEL-T' 2140 'D07640 DENOSUMAB'
             2141 'D07642 ANTI-THYMOCYTE GLOBULIN (RABBIT)'
             2142 'D07644 HEPATITIS B ADULT VACCINE'
             2143 'D07645 ONABOTULINUMTOXINA'
             2144 'D07646 ABOBOTULINUMTOXINA' 2145 'D07647 RACEPINEPHRINE'
             2146 'D07658 CABAZITAXEL'
             2147 'D07659 CAFFEINE-MAGNESIUM SALICYLATE'
             2148 'D07660 FORMOTEROL-MOMETASONE'
             2149 'D07668 AMLODIPINE/HYDROCHLOROTHIAZIDE/OLMESARTAN'
             2150 'D07670 ALCAFTADINE OPHTHALMIC' 2151 'D07684 ROFLUMILAST'
             2152 'D07688 PEGLOTICASE'
             2153 'D07691 MAGNESIUM/POTASSIUM/SODIUM SULFATES'
             2154 'D07692 FINGOLIMOD'
             2155 'D07697 DROSPIRENONE/ETHINYL ESTRADIOL/LEVOMEFOLATE'
             2156 'D07705 LURASIDONE' 2157 'D07706 CEFTAROLINE'
             2158 'D07709 METFORMIN-SAXAGLIPTIN' 2159 'D07715 TESAMORELIN'
             2160 'D07716 ERIBULIN' 2161 'D07727 PENICILLIN G BENZATHINE'
             2162 'D07729 PENICILLIN G POTASSIUM'
             2163 'D07730 PENICILLIN V POTASSIUM'
             2164 'D07738 BROMPHENIRAMINE/CHLOPHEDIANOL/PSE'
             2165 'D07740 VILAZODONE' 2166 'D07754 AZILSARTAN'
             2167 'D07756 BELIMUMAB'
             2168 'D07757 LIDOCAINE-SODIUM BICARBONATE'
             2169 'D07761 VANDETANIB' 2170 'D07766 ABIRATERONE'
             2171 'D07767 LINAGLIPTIN' 2172 'D07774 BOCEPREVIR'
             2173 'D07777 TELAPREVIR'
             2174 'D07796 EMTRICITABINE/RILPIVIRINE/TENOFOVIR'
             2175 'D07798 VEMURAFENIB' 2176 'I00031 XYLENE'
             2177 'I00035 TURPENTINE' 2178 'I00039 TRICHLOROETHANE'
             2179 'I00040 TOLUENE' 2180 'I00081 NAPHTHALENE'
             2181 'I00084 METHYLENE CHLORIDE' 2182 'I00088 METHANOL'
             2183 'I00102 FORMALDEHYDE' 2184 'I00106 ETHYLENE GLYCOL'
             2185 'I00108 ETHYL ETHER' 2186 'I00162 ACETONE'
             2187 'I00173 CYANOACRYLATE' 2188 'I00176 ISOBUTYL NITRITE'
             2189 'I00190 AEROSOL SPRAY-NOS' 2190 'I00196 BUTANE'
             2191 'I00198 TRICHLOROFLUOROMETHANE' 2192 'I00200 METHANE'
             2193 'I00201 PETROLEUM HYDROCARBONS'
             2194 'I00203 CARBON TETRACHLORIDE' 2195 'I00207 BUTYL ALCOHOL'
             2196 'I00209 ALPHA TERPINEOL' 2197 'I00210 FREON'
             2198 'I00211 DICHLOROBENZENE' 2199 'I00212 PROPOXUR'
             2200 'I00216 PROPANE' 2201 'I00219 PHENOLIC DISINFECTANTS'
             2202 'I00221 MINERAL SEAL OIL' 2203 'I00238 FLUORINE'
             2204 'I00240 HYDROCARBON' 2205 'I00247 CHLORINATED HYDROCARBONS'
             2206 'I00251 CRESOL' 2207 'I00256 BUTYL ACETATE'
             2208 'I00343 CLEANER/UNKNOWN COMPOSITION'
             2209 'I00345 COSMETIC/UNKNOWN COMPOSITION'
             2210 'I00348 PESTICIDE/UNKNOWN COMPOSITION'
             2211 'I00349 VOLATILE/UNKNOWN COMPONENTS'
             2212 'I00350 PAINT/UNKNOWN COMPOSITION'
             2213 'I00543 TRICHLOROETHANE/TRICHLOROETHYLENE'
             2214 'I00556 PETROLEUM HYDROCARBONS/TRICHLOROETHANE'
             2215 'I01283 ETHANOL-NP' 2216 'I01328 TRICHLOROMETHANE'
             2217 'I01336 FLUORINATED HYDROCARBONS' 2218 'I01337 ISOBUTANE'
             2219 'I01400 CHLORODIFLUOROMETHANE' 2220 'I01425 ETHYL ACETATE'
             2221 'J00001 LYSERGIC ACID DIETHYLAMIDE'
             2222 'J00002 METHYLENEDIOXYMETHAMPHETAMINE'
             2223 'J00004 FLUNITRAZEPAM' 2224 'J00020 BROMELAIN'
             2225 'J00023 NOMIFENSINE MALEATE' 2226 'J00027 MECLOZINE HCL'
             2227 'J00028 NITRAZEPAM' 2228 'J00030 ZOMEPIRAC'
             2229 'J00032 XYLAZINE' 2230 'J00033 VITAMIN K'
             2231 'J00036 L-TRYPTOPHAN' 2232 'J00049 SULFORIDAZINE'
             2233 'J00050 SULFADINE' 2234 'J00053 SALINE'
             2235 'J00061 PRAZEPAM' 2236 'J00064 PHENMETRAZINE HCL'
             2237 'J00066 PHENACETIN' 2238 'J00089 METHACYCLINE'
             2239 'J00090 MERBROMIN' 2240 'J00092 LUTREXIN'
             2241 'J00093 LORMETAZEPAM' 2242 'J00094 LACTOSE'
             2243 'J00095 KETOTIFEN FUMARATE' 2244 'J00096 INFANT FORMULA'
             2245 'J00097 HYDROXY-N-METHYLMORPHINAN'
             2246 'J00104 FENPROPOREX' 2247 'J00110 ERYTHRITYL TETRANITRATE'
             2248 'J00114 DYPYRONE' 2249 'J00120 DIHYDROMORPHINONE'
             2250 'J00122 ALDOSTERONE' 2251 'J00129 CHLOROPYRAMINE'
             2252 'J00148 CARBAMATE' 2253 'J00150 BROMAZEPAM'
             2254 'J00164 ACEPROMAZINE' 2255 'J00168 METHCATHINONE'
             2256 'J00171 CATHINONE' 2257 'J00174 METHYLENEDIOXYAMPHETAMINE'
             2258 'J00177 METHAQUALONE' 2259 'J00178 MESCALINE'
             2260 'J00179 PSILOCYBIN' 2261 'J00180 MORNING GLORY SEEDS'
             2262 'J00192 DATURA SAUVEOLENS'
             2263 'J00215 GAMMA BUTYROLACTONE' 2264 'J00248 EUCALYPTUS OIL'
             2265 'J00249 PEPPER' 2266 'J00263 DIMETHOXYMETHAMPHETAMINE'
             2267 'J00264 DATURA STRAMONIUM' 2268 'J00265 CANTHARIDINE'
             2269 'J00278 ISOPROPAMIDE IODIDE' 2270 'J00280 ALLOBARBITAL'
             2271 'J00290 CLOBENZOREX' 2272 'J00293 AMBROXOL'
             2273 'J00294 TETRAMYCIN' 2274 'J00295 RHODOMYCIN'
             2275 'J00331 ZOPICLONE' 2276 'J00336 MYCADRINE'
             2277 'J00337 POTASSIUM' 2278 'J00339 PYRETHRUM'
             2279 'J00356 ARECOLINE' 2280 'J00358 PHOSPHATIDYLETHANOLAMINE'
             2281 'J00360 CHLORPHENTERMINE' 2282 'J00362 BARBITURIC ACID'
             2283 'J00364 BARBITAL'
             2284 'J00369 BROMO-DIMETHOXYPHENETHYLAMINE'
             2285 'J00500 MARIJUANA/METHAMPHETAMINE'
             2286 'J00501 FORMALDEHYDE/MARIJUANA'
             2287 'J00502 COCAINE/METHAMPHETAMINE'
             2288 'J00504 COCAINE/MARIJUANA' 2289 'J00507 COCAINE/HEROIN'
             2290 'J00510 MARIJUANA/PHENCYCLIDINE'
             2291 'J00511 COCAINE/PHENCYCLIDINE'
             2292 'J00512 LYSERGIC ACID DIETHYLAMIDE/METHAMPHETAMINE'
             2293 'J00513 LYSERGIC ACID DIETHYLAMIDE/PHENCYCLIDINE'
             2294 'J00514 HEROIN/MARIJUANA'
             2295 'J00531 AMOBARBITAL/DEXTROAMPHETAMINE/THYROID DESICCATED'
             2296 'J00533 PENTOBARBITAL/PHENOBARBITAL'
             2297 'J00539 CAFFEINE/EPHEDRINE'
             2298 'J00540 ACETAMINOPHEN/CHLORZOXAZONE'
             2299 'J00558 ASPIRIN/CAFFEINE/CODEINE/PHENACETIN'
 2300 'J00566 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE/DEXTROMETHORPHAN/GUAIFENESIN'
             2301 'J00568 COCAINE/ETHANOL'
             2302 'J00572 SALICYLAMIDE/SCOPOLAMINE'
             2303 'J00577 CODEINE/TERPIN HYDRATE'
             2304 'J00591 ACETAMINOPHEN/CAFFEINE/CODEINE'
             2305 'J00593 AMYLASE/PROTEASE'
             2306 'J00594 ASPIRIN/CAFFEINE/CODEINE'
             2307 'J01003 ANTIFUNGALS-NOS'
             2308 'J01004 ANTIMALARIAL AGENTS-NOS'
             2309 'J01005 ANTITUBERCULOSIS AGENTS-NOS'
             2310 'J01006 ANTIVIRAL AGENTS-NOS'
             2311 'J01008 CEPHALOSPORINS-NOS' 2312 'J01010 MACROLIDES-NOS'
             2313 'J01011 ANTIBIOTICS-NOS' 2314 'J01012 PENICILLINS-NOS'
             2315 'J01013 QUINOLONES-NOS' 2316 'J01014 SULFONAMIDES-NOS'
             2317 'J01015 TETRACYCLINES-NOS'
             2318 'J01016 URINARY ANTI-INFECTIVES-NOS'
             2319 'J01017 AMINOGLYCOSIDES-NOS'
             2320 'J01018 ANTIHYPERLIPIDEMIC AGENTS-NOS'
             2321 'J01026 RADIOPHARMACEUTICALS-NOS'
             2322 'J01028 ANTITOXINS AND ANTIVENINS-NOS'
             2323 'J01029 BACTERIAL VACCINES-NOS'
             2324 'J01030 COLONY STIMULATING FACTORS-NOS'
             2325 'J01031 IMMUNE GLOBULINS-NOS'
             2326 'J01033 RECOMBINANT HUMAN ERYTHROPOIETINS-NOS'
             2327 'J01034 TOXOIDS-NOS' 2328 'J01035 VIRAL VACCINES-NOS'
             2329 'J01037 CARDIOVASCULAR AGENTS-NOS'
             2330 'J01039 ANGIOTENSIN CONVERTING ENZYME INHIBITORS-NOS'
             2331 'J01040 ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING-NOS'
             2332 'J01042 ANTIANGINAL AGENTS-NOS'
             2333 'J01043 ANTIARRHYTHMIC AGENTS-NOS'
             2334 'J01044 BETA-ADRENERGIC BLOCKING AGENTS-NOS'
             2335 'J01045 CALCIUM CHANNEL BLOCKING AGENTS-NOS'
             2336 'J01047 INOTROPIC AGENTS-NOS'
             2337 'J01049 PERIPHERAL VASODILATORS-NOS'
             2338 'J01050 VASODILATORS-NOS' 2339 'J01051 VASOPRESSORS-NOS'
             2340 'J01052 ANTIHYPERTENSIVE COMBINATIONS-NOS'
             2341 'J01053 ANGIOTENSIN II INHIBITORS-NOS'
             2342 'J01056 ANALGESICS-NOS'
             2343 'J01057 NARCOTIC ANALGESICS-NOS'
             2344 'J01058 NONSTEROIDAL ANTI-INFLAMMATORY AGENTS-NOS'
             2345 'J01059 SALICYLATES-NOS' 2346 'J01061 ANTICONVULSANTS-NOS'
             2347 'J01063 ANTIPARKINSON AGENTS-NOS'
             2348 'J01065 BARBITURATES-NOS' 2349 'J01066 BENZODIAZEPINES-NOS'
             2350 'J01067 ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS'
             2351 'J01068 CNS STIMULANTS-NOS'
             2352 'J01069 GENERAL ANESTHETICS-NOS'
             2353 'J01073 ANTIPSYCHOTICS-NOS'
             2354 'J01077 ANTICOAGULANTS-NOS'
             2355 'J01078 ANTIPLATELET AGENTS-NOS'
             2356 'J01081 THROMBOLYTICS-NOS'
             2357 'J01082 GASTROINTESTINAL AGENTS-NOS'
             2358 'J01083 ANTACIDS-NOS'
             2359 'J01084 ANTICHOLINERGICS/ANTISPASMODICS-NOS'
             2360 'J01085 ANTIDIARRHEALS-NOS'
             2361 'J01086 DIGESTIVE ENZYMES-NOS'
             2362 'J01088 GI STIMULANTS-NOS' 2363 'J01089 H2 ANTAGONISTS-NOS'
             2364 'J01090 LAXATIVES-NOS' 2365 'J01092 HORMONES-NOS'
             2366 'J01093 ADRENAL CORTICAL STEROIDS-NOS'
             2367 'J01094 ANTIDIABETIC AGENTS-NOS'
             2368 'J01096 SEX HORMONES-NOS' 2369 'J01098 THYROID DRUGS-NOS'
             2370 'J01099 IMMUNOSUPPRESSIVE AGENTS-NOS'
             2371 'J01101 ANTIDOTES-NOS' 2372 'J01102 CHELATING AGENTS-NOS'
             2373 'J01103 CHOLINERGIC MUSCLE STIMULANTS-NOS'
             2374 'J01104 LOCAL INJECTABLE ANESTHETICS-NOS'
             2375 'J01106 PSORALENS-NOS'
             2376 'J01107 RADIOCONTRAST AGENTS-NOS'
             2377 'J01108 GENITOURINARY TRACT AGENTS-NOS'
             2378 'J01111 IRON PRODUCTS-NOS'
             2379 'J01112 MINERALS AND ELECTROLYTES-NOS'
             2380 'J01113 ORAL NUTRITIONAL SUPPLEMENTS-NOS'
             2381 'J01115 VITAMIN AND MINERAL COMBINATIONS-NOS'
             2382 'J01116 INTRAVENOUS NUTRITIONAL PRODUCTS-NOS'
             2383 'J01118 ANTIHISTAMINES-NOS' 2384 'J01119 ANTITUSSIVES-NOS'
             2385 'J01120 BRONCHODILATORS-NOS'
             2386 'J01122 DECONGESTANTS-NOS' 2387 'J01123 EXPECTORANTS-NOS'
             2388 'J01124 RESPIRATORY AGENTS-NOS'
             2389 'J01125 RESPIRATORY INHALANT PRODUCTS-NOS'
             2390 'J01126 ANTIASTHMATIC COMBINATIONS-NOS'
             2391 'J01127 UPPER RESPIRATORY COMBINATIONS-NOS'
             2392 'J01129 ANORECTAL PREPARATIONS-NOS'
             2393 'J01130 ANTISEPTIC AND GERMICIDES-NOS'
             2394 'J01131 DERMATOLOGICAL AGENTS-NOS'
             2395 'J01134 TOPICAL ANESTHETICS-NOS'
             2396 'J01139 MOUTH AND THROAT PRODUCTS-NOS'
             2397 'J01143 STERILE IRRIGATING SOLUTIONS-NOS'
             2398 'J01145 PLASMA EXPANDERS-NOS'
             2399 'J01165 HMG-COA REDUCTASE INHIBITORS-NOS'
             2400 'J01170 MUSCLE RELAXANTS-NOS'
             2401 'J01174 ANDROGENS AND ANABOLIC STEROIDS-NOS'
             2402 'J01180 NARCOTIC ANALGESIC COMBINATIONS-NOS'
             2403 'J01181 ANTIRHEUMATICS-NOS'
             2404 'J01182 ANTIMIGRAINE AGENTS-NOS'
             2405 'J01183 ANTIGOUT AGENTS-NOS'
             2406 'J01206 BISPHOSPHONATES-NOS'
             2407 'J01208 NUTRACEUTICAL PRODUCTS-NOS'
             2408 'J01209 HERBAL PRODUCTS-NOS'
             2409 'J01229 FIBRIC ACID DERIVATIVES-NOS'
             2410 'J01231 LEUKOTRIENE MODIFIERS-NOS'
             2411 'J01235 NASAL PREPARATIONS-NOS'
             2412 'J01237 ANTIDEPRESSANTS-NOS' 2413 'J01241 ANOREXIANTS-NOS'
             2414 'J01243 INTERFERONS-NOS'
             2415 'J01244 MONOCLONAL ANTIBODIES-NOS'
             2416 'J01247 IMPOTENCE AGENTS-NOS'
             2417 'J01253 VAGINAL PREPARATIONS-NOS'
             2418 'J01254 ANTIPSORIATICS-NOS'
             2419 'J01256 PROTON PUMP INHIBITORS-NOS'
             2420 'J01261 DRUG UNKNOWN' 2421 'J01262 GAMMA HYDROXY BUTYRATE'
             2422 'J01271 PASSION FLOWER' 2423 'J01276 METHAPHENILENE'
             2424 'J01292 CODEINE COMBINATION-NOS'
             2425 'J01294 HALLUCINOGEN-NOS' 2426 'J01295 POLY-DRUGS'
             2427 'J01298 ANTINEOPLASTICS-NOS'
             2428 'J01300 ANTIBIOTICS/ANTINEOPLASTICS-NOS'
             2429 'J01301 HORMONES/ANTINEOPLASTICS-NOS'
             2430 'J01302 DIURETICS-NOS'
             2431 'J01303 ANTIEMETIC/ANTIVERTIGO AGENTS-NOS'
             2432 'J01305 VITAMINS-NOS'
             2433 'J01306 OPHTHALMIC PREPARATIONS-NOS'
             2434 'J01307 OTIC PREPARATIONS-NOS'
             2435 'J01308 ANALGESIC COMBINATIONS-NOS'
             2436 'J01309 COX-2 INHIBITOR-NOS'
             2437 'J01310 SSRI ANTIDEPRESSANTS-NOS'
             2438 'J01311 TRICYCLIC ANTIDEPRESSANTS-NOS'
             2439 'J01312 MONOAMINE OXIDASE INHIBITORS-NOS'
             2440 'J01313 PSYCHOTHERAPEUTIC COMBINATIONS-NOS'
             2441 'J01314 PHENOTHIAZINE ANTIPSYCHOTICS-NOS'
             2442 'J01315 ISOSORBIDE-NOS' 2443 'J01316 IMMUNIZATION-NOS'
             2444 'J01317 PHENCYCLIDINE COMBINATIONS-NOS'
             2445 'J01318 PNEUMOCOCCAL VACCINE' 2446 'J01319 FOLATE'
             2447 'J01320 PENTOBARBITAL/PHENYTOIN'
             2448 'J01322 BARBITAL SODIUM' 2449 'J01323 GADOLINIUM'
             2450 'J01324 HEPATITIS A VACCINE INACTIVATED' 2451 'J01327 ZINC'
             2452 'J01328 4-BROMO-2,5-DIMETHOXYPHENETHYLAMINE'
             2453 'J01329 2,5-DIMETHOXY-4-IODOPHENETHYLAMINE'
             2454 'J01330 AMPHETAMINE/COCAINE'
             2455 'J01331 METHANDROSTENLONE' 2456 'J01332 MARIJUANA/OPIUM'
             2457 'J01333 ALPROSTADIL/PAPAVERINE/PHENTOLAMINE'
             2458 'J01334 CYANIDE/HEROIN/STRYCHNINE'
             2459 'J01338 HYDROXYCODEINONE'
             2460 'J01340 2,5-DIMETHOXY-4-ETHYL-PHENETHYLAMINE'
             2461 'J01341 2,5-DIMETHOXY-4-(N)-PROPYLTHIOPHENETHYLAMINE'
             2462 'J01342 ANTI-RETROVIRAL AGENTS-NOS' 2463 'J01343 AROPLATIN'
             2464 'J01344 IDRAPARINUX'
             2465 'J01345 COCAINE/LYSERGIC ACID DIETHYLAMIDE'
             2466 'J01346 SALVIA DIVINORUM' 2467 'J01348 TIPIFARNIB'
             2468 'J01350 FLUOROURACIL-LEUCOVORIN'
             2469 'J01353 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE'
             2470 'J01354 CARPROFEN'
             2471 'J01355 RIFAMPIN/ISONIAZID/PYRAZINAMIDE/ETHAMBUTOL'
             2472 'J01356 THALLIUM' 2473 'J01357 POLYMYXIN B OTIC'
             2474 'J01358 ALLANTOIN/PRAMOXINE'
             2475 'J01359 COCAINE/MARIJUANA/FORMALDEHYDE'
             2476 'J01360 COCAINE/OPIUM'
            2477 'J01361 CYCLOPHOSPHAMIDE/DOXORUBICIN/VINCRISTINE/PREDNISONE'
             2478 'J01362 DIPHTHERIA/PERTUSISIS/POLIO/HAEMOPHILUS/TETANUS'
             2479 'J01363 ETORICOXIB' 2480 'J01365 FLUPENTHIXOL'
             2481 'J01366 FUSIDIC ACID' 2482 'J01367 HEROIN/METHAMPHETAMINE'
             2483 'J01368 IODINE CONTRAST AGENT'
             2484 'J01369 MARIJUANA/LYSERGIC ACID DIETHYLAMIDE'
             2485 'J01370 METHYLENEDIOXYMETHAMPHETAMINE/PSILOCYBIN'
             2486 'J01371 NEOMYCIN-POLYMYXIN B SULFATE OTIC'
             2487 'J01372 OXALIPLATIN/FLUOROURACIL/LEUCOVORIN'
             2488 'J01373 PHOSPHORUS'
             2489 'J01375 ADRENERGIC BRONCHODILATORS-NOS'
             2490 'J01379 OMEGA-6 POLYUNSATURATED FATTY ACIDS'
             2491 'J01380 TOPICAL ANTIFUNGALS-NOS'
             2492 'J01382 DEXTROMETHORPHAN COMBINATIONS-NOS'
             2493 'J01383 CLENBUTEROL' 2494 'J01386 FENTANYL/HEROIN'
             2495 'J01387 SULFONYLUREAS-NOS'
             2496 'J01388 COCAINE/FORMALDEHYDE'
             2497 'J01389 COCAINE/METHYLENEDIOXYMETHAMPHETAMINE'
             2498 'J01390 CYPROTEREONE ACETATE-ETHINYL ESTRADIOL'
             2499 'J01391 FAT DISSOLVING AGENTS-NOS'
             2500 'J01392 HEROIN/METHYLENEDIOXYMETHAMPHETAMINE'
             2501 'J01393 PROPOLIS' 2502 'J01394 SENNA COMBINATIONS-NOS'
             2503 'J01395 FENFLURAMINE/PHENTERMINE'
             2504 'J01396 ACNE AGENTS-NOS' 2505 'J01401 CLONIXIN'
             2506 'J01404 PROGESTINS-NOS' 2507 'J01405 RABIES VACCINE-NOS'
             2508 'J01411 INFLUENZA VIRUS VACCINE, H1N1-NOS'
             2509 'J01412 ACAI BERRY' 2510 'J01413 ALUM'
             2511 'J01414 AMMONIA' 2512 'J01415 BENZYLPIPERAZINE'
             2513 'J01416 BLUE GREEN ALGAE'
  2514 'J01417 CYCLOPHOSPHAMIDE/DOXORUBICIN/RITUXIMAB/VINCRISTINE/PREDNISONE'
             2515 'J01418 HOODIA' 2516 'J01419 HYALURONIC ACID'
             2517 'J01420 PAPAVERINE/PHENTOLAMINE' 2518 'J01421 STATIN-NOS'
             2519 'J01422 TEA TREE OIL'
             2520 'J01423 TRIFLUOROMETHYLPHENYLPIPERAZINE'
             2521 'J01424 4-METHYLMETHCATHINONE' 2522 'J01426 PHENAZEPAM'
             2523 'J01427 4-BROMO-3,6-DIMETHOXYBENZOCYCLOBUTEN'
             2524 'J01428 SYNTHETIC CANNABINOID' 2525 'J01429 AFATINIB'
             2526 'J01430 AMPHETAMINE/MARIJUANA' 2527 'J01431 AXITINIB'
             2528 'J01432 BLEOMYCIN/DACARBAZINE/DOXORUBICIN/VINBLASTINE'
             2529 'J01433 CAFFEINE COMBINATIONS-NOS'
             2530 'J01434 CAPECITABINE/OXALIPLATIN'
             2531 'J01435 COLLOIDAL SILVER'
             2532 'J01436 DOCETAXEL/FLUOROURACIL/OXALIPLATIN'
             2533 'J01437 DOMPERIDONE'
             2534 'J01438 FLUOROURACIL/IRINOTECAN/LEUCOVORIN'
             2535 'J01439 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE/RITUXIMAB'
             2536 'J01440 KETAMINE/MARIJUANA'
             2537 'J01441 L-TRYPTOPHAN/MELATONIN'
             2538 'J01442 MARIJUANA/OXYCODONE' 2539 'J01443 METAMIZOLE'
             2540 'J01444 3,4-METHYLENEDIOXYPYROVALERONE'
             2541 'J01445 PANOBINOSTAT' 2542 'J01446 PROBIOTICS-NOS'
             2543 'J01447 SPERMICIDES-NOS' 2544 'J01448 TILMICOSIN'
             2545 'J01449 AMPHETAMINES-NOS'
             2546 'J01450 ILLICIT COMBINATIONS-NOS' 2547 'J01451 VITAMIN D'
             2548 'J01454 TRENBOLONE'
             2549 'J01455 H. PYLORI ERADICATION AGENTS-NOS'
             2550 'J01456 SMOKING CESSATION AGENTS-NOS'
             2551 'J01457 4-BROMO-2,5-DIMETHOXYAMPHETAMINE'
             2552 'J01458 PROTEASE INHIBITORS-NOS'
             2553 'J01459 4-METHOXYMETHCATHINONE' 2554 'J01460 ELASTIN'
             2555 'J01461 TALCUM POWDER TOPICAL'
             2556 'J01462 METHYLENEDIOXYMETHAMPHETAMINE/CAFFEINE'
             2557 'J01463 ENERGY DRINK'
             2558 'J01464 CAFFEINE/MULTIVITAMIN NTA' /
   CATID_1_1 -7 'NOT APPLICABLE:(-7)' 1 'ANTI-INFECTIVES:(1)'
             20 'ANTINEOPLASTICS:(20)' 28 'BIOLOGICALS:(28)'
             40 'CARDIOVASCULAR AGENTS:(40)'
             57 'CENTRAL NERVOUS SYSTEM AGENTS:(57)'
             81 'COAGULATION MODIFIERS:(81)'
             87 'GASTROINTESTINAL AGENTS:(87)'
             97 'HORMONES/HORMONE MODIFIERS:(97)'
             105 'MISCELLANEOUS AGENTS:(105)'
             113 'GENITOURINARY TRACT AGENTS:(113)'
             115 'NUTRITIONAL PRODUCTS:(115)' 122 'RESPIRATORY AGENTS:(122)'
             133 'TOPICAL AGENTS:(133)' 153 'PLASMA EXPANDERS:(153)'
             218 'ALTERNATIVE MEDICINES:(218)'
             242 'PSYCHOTHERAPEUTIC AGENTS:(242)'
             254 'IMMUNOLOGIC AGENTS:(254)' 331 'RADIOLOGIC AGENTS:(331)'
             358 'METABOLIC AGENTS:(358)' 365 'MEDICAL GAS:(365)'
             2006 'DRUG UNKNOWN:(2006)' 2041 'NON-PHARMACEUTICAL:(2041)' /
   CATID_2_1 -7 'NOT APPLICABLE:(-7)' 2 'AMEBICIDES:(2)'
             3 'ANTHELMINTICS:(3)' 4 'ANTIFUNGALS:(4)'
             5 'ANTIMALARIAL AGENTS:(5)' 6 'ANTITUBERCULOSIS AGENTS:(6)'
             7 'ANTIVIRAL AGENTS:(7)' 8 'CARBAPENEMS:(8)'
             9 'CEPHALOSPORINS:(9)' 10 'LEPROSTATICS:(10)'
             11 'MACROLIDE DERIVATIVES:(11)'
             12 'MISCELLANEOUS ANTIBIOTICS:(12)' 13 'PENICILLINS:(13)'
             14 'QUINOLONES:(14)' 15 'SULFONAMIDES:(15)'
             16 'TETRACYCLINES:(16)' 17 'URINARY ANTI-INFECTIVES:(17)'
             18 'AMINOGLYCOSIDES:(18)' 19 'ANTIHYPERLIPIDEMIC AGENTS:(19)'
             21 'ALKYLATING AGENTS:(21)' 22 'ANTINEOPLASTIC ANTIBIOTICS:(22)'
             23 'ANTIMETABOLITES:(23)' 24 'ANTINEOPLASTIC HORMONES:(24)'
             25 'MISCELLANEOUS ANTINEOPLASTICS:(25)'
             26 'MITOTIC INHIBITORS:(26)' 27 'RADIOPHARMACEUTICALS:(27)'
             30 'ANTITOXINS AND ANTIVENINS:(30)' 33 'IMMUNE GLOBULINS:(33)'
             34 'IN VIVO DIAGNOSTIC BIOLOGICALS:(34)'
             36 'RECOMBINANT HUMAN ERYTHROPOIETINS:(36)'
             41 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(41)'
             42 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(42)'
             43 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(43)'
             44 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(44)'
             45 'ANTIANGINAL AGENTS:(45)' 46 'ANTIARRHYTHMIC AGENTS:(46)'
             47 'BETA-ADRENERGIC BLOCKING AGENTS:(47)'
             48 'CALCIUM CHANNEL BLOCKING AGENTS:(48)' 49 'DIURETICS:(49)'
             50 'INOTROPIC AGENTS:(50)'
             51 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(51)'
             52 'PERIPHERAL VASODILATORS:(52)' 53 'VASODILATORS:(53)'
             54 'VASOPRESSORS:(54)' 55 'ANTIHYPERTENSIVE COMBINATIONS:(55)'
             56 'ANGIOTENSIN II INHIBITORS:(56)' 58 'ANALGESICS:(58)'
             64 'ANTICONVULSANTS:(64)'
             65 'ANTIEMETIC/ANTIVERTIGO AGENTS:(65)'
             66 'ANTIPARKINSON AGENTS:(66)'
             67 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(67)'
             71 'CNS STIMULANTS:(71)' 72 'GENERAL ANESTHETICS:(72)'
             73 'MUSCLE RELAXANTS:(73)'
             80 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(80)'
             82 'ANTICOAGULANTS:(82)' 83 'ANTIPLATELET AGENTS:(83)'
             84 'HEPARIN ANTAGONISTS:(84)'
             85 'MISCELLANEOUS COAGULATION MODIFIERS:(85)'
             86 'THROMBOLYTICS:(86)' 88 'ANTACIDS:(88)'
             90 'ANTIDIARRHEALS:(90)' 91 'DIGESTIVE ENZYMES:(91)'
             92 'GALLSTONE SOLUBILIZING AGENTS:(92)' 93 'GI STIMULANTS:(93)'
             94 'H2 ANTAGONISTS:(94)' 95 'LAXATIVES:(95)'
             96 'MISCELLANEOUS GI AGENTS:(96)'
             98 'ADRENAL CORTICAL STEROIDS:(98)'
             99 'ANTIDIABETIC AGENTS:(99)' 100 'MISCELLANEOUS HORMONES:(100)'
             101 'SEX HORMONES:(101)' 103 'THYROID HORMONES:(103)'
             104 'IMMUNOSUPPRESSIVE AGENTS:(104)' 106 'ANTIDOTES:(106)'
             107 'CHELATING AGENTS:(107)'
             108 'CHOLINERGIC MUSCLE STIMULANTS:(108)'
             109 'LOCAL INJECTABLE ANESTHETICS:(109)'
             110 'MISCELLANEOUS UNCATEGORIZED AGENTS:(110)'
             111 'PSORALENS:(111)' 112 'RADIOCONTRAST AGENTS:(112)'
             114 'ILLICIT (STREET) DRUGS:(114)' 116 'IRON PRODUCTS:(116)'
             117 'MINERALS AND ELECTROLYTES:(117)'
             118 'ORAL NUTRITIONAL SUPPLEMENTS:(118)' 119 'VITAMINS:(119)'
             120 'VITAMIN AND MINERAL COMBINATIONS:(120)'
             121 'INTRAVENOUS NUTRITIONAL PRODUCTS:(121)'
             123 'ANTIHISTAMINES:(123)' 124 'ANTITUSSIVES:(124)'
             125 'BRONCHODILATORS:(125)' 127 'DECONGESTANTS:(127)'
             128 'EXPECTORANTS:(128)'
             129 'MISCELLANEOUS RESPIRATORY AGENTS:(129)'
             130 'RESPIRATORY INHALANT PRODUCTS:(130)'
             131 'ANTIASTHMATIC COMBINATIONS:(131)'
             132 'UPPER RESPIRATORY COMBINATIONS:(132)'
             134 'ANORECTAL PREPARATIONS:(134)'
             135 'ANTISEPTIC AND GERMICIDES:(135)'
             136 'DERMATOLOGICAL AGENTS:(136)'
             146 'MOUTH AND THROAT PRODUCTS:(146)'
             147 'OPHTHALMIC PREPARATIONS:(147)'
             148 'OTIC PREPARATIONS:(148)'
             150 'STERILE IRRIGATING SOLUTIONS:(150)'
             151 'VAGINAL PREPARATIONS:(151)' 192 'ANTIRHEUMATICS:(192)'
             194 'ANTIGOUT AGENTS:(194)' 219 'NUTRACEUTICAL PRODUCTS:(219)'
             220 'HERBAL PRODUCTS:(220)' 240 'LINCOMYCIN DERIVATIVES:(240)'
             243 'LEUKOTRIENE MODIFIERS:(243)' 247 'NASAL PREPARATIONS:(247)'
             249 'ANTIDEPRESSANTS:(249)' 251 'ANTIPSYCHOTICS:(251)'
             253 'ANOREXIANTS:(253)' 263 'IMPOTENCE AGENTS:(263)'
             264 'URINARY ANTISPASMODICS:(264)'
             265 'URINARY PH MODIFIERS:(265)'
             266 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(266)'
             270 'ANTIPSORIATICS:(270)' 272 'PROTON PUMP INHIBITORS:(272)'
             273 'LUNG SURFACTANTS:(273)' 277 '5-AMINOSALICYLATES:(277)'
             284 'VISCOSUPPLEMENTATION AGENTS:(284)'
             288 '5-ALPHA-REDUCTASE INHIBITORS:(288)'
             289 'ANTIHYPERURICEMIC AGENTS:(289)'
             293 'GLUCOSE ELEVATING AGENTS:(293)' 295 'GROWTH HORMONES:(295)'
             303 'AGENTS FOR PULMONARY HYPERTENSION:(303)'
             312 'CHOLINERGIC AGONISTS:(312)'
             313 'CHOLINESTERASE INHIBITORS:(313)' 315 'GLYCYLCYCLINES:(315)'
             318 'INSULIN-LIKE GROWTH FACTOR:(318)'
             319 'VASOPRESSIN ANTAGONISTS:(319)'
             320 'SMOKING CESSATION AGENTS:(320)'
             324 'ANTINEOPLASTIC INTERFERONS:(324)'
             325 'SCLEROSING AGENTS:(325)' 332 'RADIOLOGIC ADJUNCTS:(332)'
             340 'ALDOSTERONE RECEPTOR ANTAGONISTS:(340)'
             342 'RENIN INHIBITORS:(342)'
             354 'H. PYLORI ERADICATION AGENTS:(354)'
             355 'FUNCTIONAL BOWEL DISORDER AGENTS:(355)'
             357 'GROWTH HORMONE RECEPTOR BLOCKERS:(357)'
             359 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(359)'
             360 'LYSOSOMAL ENZYMES:(360)'
             361 'MISCELLANEOUS METABOLIC AGENTS:(361)'
             363 'PROBIOTICS:(363)' 377 'PROLACTIN INHIBITORS:(377)'
             378 'DRUGS USED IN ALCOHOL DEPENDENCE:(378)'
             383 'ANTINEOPLASTIC DETOXIFYING AGENTS:(383)'
             384 'PLATELET-STIMULATING AGENTS:(384)'
             390 'HEMATOPOIETIC STEM CELL MOBILIZER:(390)'
             397 'MULTIKINASE INHIBITORS:(397)'
             398 'BCR-ABL TYROSINE KINASE INHIBITORS:(398)'
             399 'CD52 MONOCLONAL ANTIBODIES:(399)'
             400 'CD33 MONOCLONAL ANTIBODIES:(400)'
             401 'CD20 MONOCLONAL ANTIBODIES:(401)'
             402 'VEGF/VEGFR INHIBITORS:(402)' 403 'MTOR INHIBITORS:(403)'
             404 'EGFR INHIBITORS:(404)' 405 'HER2 INHIBITORS:(405)'
             406 'GLYCOPEPTIDE ANTIBIOTICS:(406)'
             408 'HISTONE DEACETYLASE INHIBITORS:(408)'
             409 'BONE RESORPTION INHIBITORS:(409)'
             410 'ADRENAL CORTICOSTEROID INHIBITORS:(410)'
             411 'CALCITONIN:(411)' 412 'UTEROTONIC AGENTS:(412)'
             413 'ANTIGONADOTROPIC AGENTS:(413)'
             414 'ANTIDIURETIC HORMONES:(414)'
             416 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(416)'
             417 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(417)'
             418 'PARATHYROID HORMONE AND ANALOGS:(418)'
             419 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(419)'
             422 'ANTITHYROID AGENTS:(422)'
             426 'SYNTHETIC OVULATION STIMULANTS:(426)'
             427 'TOCOLYTIC AGENTS:(427)'
             428 'PROGESTERONE RECEPTOR MODULATORS:(428)'
             431 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(431)'
             433 'CATECHOLAMINES:(433)'
             435 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(435)'
             437 'IMMUNOSTIMULANTS:(437)'
             447 'CD30 MONOCLONAL ANTIBODIES:(447)' 2042 'INHALANT:(2042)'
             2051 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(2051)' /
   CATID_3_1 -7 'NOT APPLICABLE:(-7)' 31 'BACTERIAL VACCINES:(31)'
             32 'COLONY STIMULATING FACTORS:(32)' 38 'VIRAL VACCINES:(38)'
             61 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(61)'
             68 'BARBITURATES:(68)' 69 'BENZODIAZEPINES:(69)'
             70 'MISCELLANEOUS ANXIOLYTICS, SEDATIVES AND HYPNOTICS:(70)'
             74 'NEUROMUSCULAR BLOCKING AGENTS:(74)'
             76 'MISCELLANEOUS ANTIDEPRESSANTS:(76)'
             77 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(77)'
             79 'PSYCHOTHERAPEUTIC COMBINATIONS:(79)'
             89 'ANTICHOLINERGICS/ANTISPASMODICS:(89)'
             102 'CONTRACEPTIVES:(102)' 126 'METHYLXANTHINES:(126)'
             137 'TOPICAL ANTI-INFECTIVES:(137)' 138 'TOPICAL STEROIDS:(138)'
             139 'TOPICAL ANESTHETICS:(139)'
             140 'MISCELLANEOUS TOPICAL AGENTS:(140)'
             141 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(141)'
             143 'TOPICAL ACNE AGENTS:(143)'
             144 'TOPICAL ANTIPSORIATICS:(144)' 149 'SPERMICIDES:(149)'
             154 'LOOP DIURETICS:(154)'
             155 'POTASSIUM-SPARING DIURETICS:(155)'
             156 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(156)'
             157 'CARBONIC ANHYDRASE INHIBITORS:(157)'
             158 'MISCELLANEOUS DIURETICS:(158)'
             159 'FIRST GENERATION CEPHALOSPORINS:(159)'
             160 'SECOND GENERATION CEPHALOSPORINS:(160)'
             161 'THIRD GENERATION CEPHALOSPORINS:(161)'
             162 'FOURTH GENERATION CEPHALOSPORINS:(162)'
             163 'OPHTHALMIC ANTI-INFECTIVES:(163)'
             164 'OPHTHALMIC GLAUCOMA AGENTS:(164)'
             165 'OPHTHALMIC STEROIDS:(165)'
             166 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(166)'
             167 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(167)'
             168 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(168)'
             169 'MISCELLANEOUS OPHTHALMIC AGENTS:(169)'
             170 'OTIC ANTI-INFECTIVES:(170)'
             171 'OTIC STEROIDS WITH ANTI-INFECTIVES:(171)'
             172 'MISCELLANEOUS OTIC AGENTS:(172)'
             173 'HMG-COA REDUCTASE INHIBITORS:(173)'
             174 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(174)'
             175 'PROTEASE INHIBITORS:(175)' 176 'NRTIS:(176)'
             177 'MISCELLANEOUS ANTIVIRALS:(177)'
             178 'SKELETAL MUSCLE RELAXANTS:(178)'
             179 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(179)'
             180 'ADRENERGIC BRONCHODILATORS:(180)'
             181 'BRONCHODILATOR COMBINATIONS:(181)'
             182 'ANDROGENS AND ANABOLIC STEROIDS:(182)'
             183 'ESTROGENS:(183)' 184 'GONADOTROPINS:(184)'
             185 'PROGESTINS:(185)' 186 'SEX HORMONE COMBINATIONS:(186)'
             187 'MISCELLANEOUS SEX HORMONES:(187)'
             193 'ANTIMIGRAINE AGENTS:(193)'
             195 '5HT3 RECEPTOR ANTAGONISTS:(195)'
             196 'PHENOTHIAZINE ANTIEMETICS:(196)'
             197 'ANTICHOLINERGIC ANTIEMETICS:(197)'
             198 'MISCELLANEOUS ANTIEMETICS:(198)'
             199 'HYDANTOIN ANTICONVULSANTS:(199)'
             200 'SUCCINIMIDE ANTICONVULSANTS:(200)'
             201 'BARBITURATE ANTICONVULSANTS:(201)'
             202 'OXAZOLIDINEDIONE ANTICONVULSANTS:(202)'
             203 'BENZODIAZEPINE ANTICONVULSANTS:(203)'
             204 'MISCELLANEOUS ANTICONVULSANTS:(204)'
             205 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(205)'
             206 'MISCELLANEOUS ANTIPARKINSON AGENTS:(206)'
             208 'SSRI ANTIDEPRESSANTS:(208)'
             209 'TRICYCLIC ANTIDEPRESSANTS:(209)'
             210 'PHENOTHIAZINE ANTIPSYCHOTICS:(210)'
             211 'PLATELET AGGREGATION INHIBITORS:(211)'
             212 'GLYCOPROTEIN PLATELET INHIBITORS:(212)'
             213 'SULFONYLUREAS:(213)' 214 'BIGUANIDES:(214)'
             215 'INSULIN:(215)' 216 'ALPHA-GLUCOSIDASE INHIBITORS:(216)'
             217 'BISPHOSPHONATES:(217)'
             222 'PENICILLINASE RESISTANT PENICILLINS:(222)'
             223 'ANTIPSEUDOMONAL PENICILLINS:(223)'
             224 'AMINOPENICILLINS:(224)'
             225 'BETA-LACTAMASE INHIBITORS:(225)'
             226 'NATURAL PENICILLINS:(226)' 227 'NNRTIS:(227)'
             228 'ADAMANTANE ANTIVIRALS:(228)' 229 'PURINE NUCLEOSIDES:(229)'
             230 'AMINOSALICYLATES:(230)'
             231 'NICOTINIC ACID DERIVATIVES:(231)'
             232 'RIFAMYCIN DERIVATIVES:(232)'
             233 'STREPTOMYCES DERIVATIVES:(233)'
             234 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(234)'
             235 'POLYENES:(235)' 236 'AZOLE ANTIFUNGALS:(236)'
             237 'MISCELLANEOUS ANTIFUNGALS:(237)'
             238 'ANTIMALARIAL QUINOLINES:(238)'
             239 'MISCELLANEOUS ANTIMALARIALS:(239)'
             241 'FIBRIC ACID DERIVATIVES:(241)'
             244 'NASAL LUBRICANTS AND IRRIGATIONS:(244)'
             245 'NASAL STEROIDS:(245)'
             246 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(246)'
             248 'TOPICAL EMOLLIENTS:(248)'
             250 'MONOAMINE OXIDASE INHIBITORS:(250)'
             252 'BILE ACID SEQUESTRANTS:(252)' 256 'INTERFERONS:(256)'
             261 'HEPARINS:(261)' 262 'COUMARINS AND INDANEDIONES:(262)'
             267 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(267)'
             268 'VAGINAL ANTI-INFECTIVES:(268)'
             269 'MISCELLANEOUS VAGINAL AGENTS:(269)'
             271 'THIAZOLIDINEDIONES:(271)'
             274 'CARDIOSELECTIVE BETA BLOCKERS:(274)'
             275 'NON-CARDIOSELECTIVE BETA BLOCKERS:(275)'
             276 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(276)'
             278 'COX-2 INHIBITORS:(278)'
             279 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(279)'
             280 'THIOXANTHENES:(280)' 281 'NEURAMINIDASE INHIBITORS:(281)'
             282 'MEGLITINIDES:(282)' 283 'THROMBIN INHIBITORS:(283)'
             285 'FACTOR XA INHIBITORS:(285)' 286 'MYDRIATICS:(286)'
             287 'OPHTHALMIC ANESTHETICS:(287)'
             290 'TOPICAL ANTIBIOTICS:(290)' 291 'TOPICAL ANTIVIRALS:(291)'
             292 'TOPICAL ANTIFUNGALS:(292)'
             296 'INHALED CORTICOSTEROIDS:(296)' 297 'MUCOLYTICS:(297)'
             298 'MAST CELL STABILIZERS:(298)'
             299 'ANTICHOLINERGIC BRONCHODILATORS:(299)'
             300 'CORTICOTROPIN:(300)' 301 'GLUCOCORTICOIDS:(301)'
             302 'MINERALOCORTICOIDS:(302)' 304 'MACROLIDES:(304)'
             305 'KETOLIDES:(305)'
             306 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(306)'
             307 'TETRACYCLIC ANTIDEPRESSANTS:(307)'
             308 'SSNRI ANTIDEPRESSANTS:(308)'
             309 'MISCELLANEOUS ANTIDIABETIC AGENTS:(309)'
             310 'ECHINOCANDINS:(310)'
             311 'DIBENZAZEPINE ANTICONVULSANTS:(311)'
             314 'ANTIDIABETIC COMBINATIONS:(314)'
             316 'CHOLESTEROL ABSORPTION INHIBITORS:(316)'
             317 'ANTIHYPERLIPIDEMIC COMBINATIONS:(317)'
             321 'OPHTHALMIC DIAGNOSTIC AGENTS:(321)'
             322 'OPHTHALMIC SURGICAL AGENTS:(322)'
             327 'ANTIVIRAL COMBINATIONS:(327)'
             328 'ANTIMALARIAL COMBINATIONS:(328)'
             329 'ANTITUBERCULOSIS COMBINATIONS:(329)'
             330 'ANTIVIRAL INTERFERONS:(330)'
             333 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(333)'
             334 'LYMPHATIC STAINING AGENTS:(334)'
             335 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(335)'
             336 'NON-IODINATED CONTRAST MEDIA:(336)'
             337 'ULTRASOUND CONTRAST MEDIA:(337)'
             338 'DIAGNOSTIC RADIOPHARMACEUTICALS:(338)'
             339 'THERAPEUTIC RADIOPHARMACEUTICALS:(339)'
             341 'ATYPICAL ANTIPSYCHOTICS:(341)'
             345 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(345)'
             346 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(346)'
             347 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(347)'
             348 'TRIAZINE ANTICONVULSANTS:(348)'
             349 'CARBAMATE ANTICONVULSANTS:(349)'
             350 'PYRROLIDINE ANTICONVULSANTS:(350)'
             351 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(351)'
             352 'UREA ANTICONVULSANTS:(352)'
             353 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(353)'
             356 'SEROTONINERGIC NEUROENTERIC MODULATORS:(356)'
             362 'CHLORIDE CHANNEL ACTIVATORS:(362)'
             364 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(364)'
             366 'INTEGRASE STRAND TRANSFER INHIBITOR:(366)'
             368 'NON-IONIC IODINATED CONTRAST MEDIA:(368)'
             369 'IONIC IODINATED CONTRAST MEDIA:(369)'
             370 'OTIC STEROIDS:(370)'
             371 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(371)'
             372 'AMYLIN ANALOGS:(372)' 373 'INCRETIN MIMETICS:(373)'
             374 'CARDIAC STRESSING AGENTS:(374)'
             375 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(375)'
             379 'FIFTH GENERATION CEPHALOSPORINS:(379)'
             380 'TOPICAL DEBRIDING AGENTS:(380)'
             381 'TOPICAL DEPIGMENTING AGENTS:(381)'
             382 'TOPICAL ANTIHISTAMINES:(382)'
             385 'GROUP I ANTIARRHYTHMICS:(385)'
             387 'GROUP III ANTIARRHYTHMICS:(387)'
             389 'GROUP V ANTIARRHYTHMICS:(389)' 392 'OTIC ANESTHETICS:(392)'
             393 'CERUMENOLYTICS:(393)' 394 'TOPICAL ASTRINGENTS:(394)'
             395 'TOPICAL KERATOLYTICS:(395)'
             415 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(415)'
             432 'VACCINE COMBINATIONS:(432)'
             439 'OTHER IMMUNOSTIMULANTS:(439)'
             440 'THERAPEUTIC VACCINES:(440)'
             441 'CALCINEURIN INHIBITORS:(441)'
             442 'TNF ALFA INHIBITORS:(442)'
             443 'INTERLEUKIN INHIBITORS:(443)'
             444 'SELECTIVE IMMUNOSUPPRESSANTS:(444)'
             445 'OTHER IMMUNOSUPPRESSANTS:(445)'
             448 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(448)'
             2005 'ALCOHOL IN COMBINATION:(2005)'
             2007 'MISCELLANEOUS BRONCHODILATORS:(2007)'
             2008 'MISCELLANEOUS NASAL PREPARATIONS:(2008)'
             2030 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(2030)'
             2031 'MISCELLANEOUS HALLUCINOGENS:(2031)'
             2032 'ILLICIT MAJOR SUBSTANCE OF ABUSE:(2032)'
             2033 'ILLICIT COMBINATIONS:(2033)'
             2034 'ILLICIT AND OTHER COMBINATIONS:(2034)'
             2036 'MISCELLANEOUS CEPHALOSPORINS:(2036)'
             2043 'VOLATILE AGENT:(2043)' 2044 'NITRITES:(2044)'
             2045 'CHLORO-FLUORO-HYDROCARBONS:(2045)'
             2046 'MISCELLANEOUS MUSCLE RELAXANTS:(2046)'
             2047 'NARCOTIC ANALGESICS/COMBINATIONS:(2047)'
             2048 'SALICYLATES/COMBINATIONS:(2048)'
             2049 'MISCELLANEOUS ANALGESIC/COMBINATIONS:(2049)'
             2050 'ANALGESIC COMBINATIONS NTA:(2050)'
             2052 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(2052)'
             2053 'MISCELLANEOUS MACROLIDE:(2053)'
             2054 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(2054)'
             2055 'MISCELLANEOUS RADIOCONTRAST AGENTS:(2055)'
             2056 'MISCELLANEOUS RADIOPHARMACEUTICALS:(2056)' /
   ROUTE_1   -9 'MISSING:(-9)' -8 'NOT DOCUMENTED:(-8)'
             -7 'NOT APPLICABLE:(-7)' 1 'ORAL:(1)' 2 'INJECTED:(2)'
             3 'INHALED, SNIFFED, SNORTED:(3)' 4 'SMOKED:(4)' 5 'OTHER:(5)'
             6 'TRANSDERMAL:(6)' 98 'MULTIPLE ROUTES FOR THIS DRUG:(98)' /
   TOXTEST_1 -9 'MISSING:(-9)' -7 'NOT APPLICABLE:(-7)'
             1 'CONFIRMED TEST:(1)' 2 'NOT CONFIRMED:(2)' /
   SDLED_1_1 -7 'NOT APPLICABLE:(-7)' 1 'MAJOR SUBSTANCES OF ABUSE:(1)'
             17 'OTHER SUBSTANCES:(17)' /
   SDLED_2_1 -7 'NOT APPLICABLE:(-7)' 2 'ALCOHOL:(2)'
             2.5 'NON-ALCOHOL ILLICITS:(2.5)'
             18 'PSYCHOTHERAPEUTIC AGENTS:(18)' 33 'CNS AGENTS:(33)'
             50 'RESPIRATORY AGENTS:(50)' 57 'CARDIOVASCULAR AGENTS:(57)'
             63 'ALTERNATIVE MEDICINES:(63)' 64 'ANTI-INFECTIVES:(64)'
             65 'ANTINEOPLASTICS:(65)' 66 'BIOLOGICALS:(66)'
             67 'COAGULATION MODIFIERS:(67)'
             68 'GASTROINTESTINAL AGENTS:(68)'
             69 'GENITOURINARY TRACT AGENTS:(69)' 70 'HORMONES:(70)'
             71 'IMMUNOLOGIC AGENTS:(71)' 72 'MEDICAL GAS:(72)'
             73 'METABOLIC AGENTS:(73)' 74 'MISCELLANEOUS AGENTS:(74)'
             75 'NUTRITIONAL PRODUCTS:(75)' 76 'PLASMA EXPANDERS:(76)'
             77 'RADIOLOGIC AGENTS:(77)' 78 'TOPICAL AGENTS:(78)'
             79 'DRUG UNKNOWN:(79)' /
   SDLED_3_1 -7 'NOT APPLICABLEL:(-7.00)' 3 'COCAINE:(3)' 4 'HEROIN:(4)'
             5 'CANNABINOIDS:(5)' 5.5 'STIMULANTS:(5.5)'
             8 'MDMA (ECSTASY):(8)' 8.1 'GHB:(8.1)'
             8.2 'FLUNITRAZEPAM (ROHYPNOL):(8.2)' 9 'KETAMINE:(9)'
             10 'LSD:(10)' 11 'PCP:(11)'
             12 'MISCELLANEOUS HALLUCINOGENS:(12)' 15 'INHALANTS:(15)'
             16 'COMBINATIONS NTA:(16)' 19 'ANTIDEPRESSANTS:(19)'
             24 'ANTIPSYCHOTICS:(24)' 34 'ANALGESICS:(34)'
             43 'ANOREXIANTS:(43)' 44 'ANTICONVULSANTS:(44)'
             45 'ANTIEMETIC/ANTIVERTIGO AGENTS:(45)'
             46 'ANTIPARKINSON AGENTS:(46)'
             46.3 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.3)'
             46.5 'CNS STIMULANTS:(46.5)'
             46.7 'DRUGS USED IN ALCOHOL DEPENDENCE:(46.7)'
             47 'GENERAL ANESTHETICS:(47)' 48 'MUSCLE RELAXANTS:(48)'
             49 'MISCELLANEOUS CNS AGENTS:(49)' 51 'ANTIHISTAMINES:(51)'
             52 'BRONCHODILATORS:(52)' 53 'DECONGESTANTS:(53)'
             54 'EXPECTORANTS:(54)'
             54.5 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(54.5)'
             55 'UPPER RESPIRATORY COMBINATIONS:(55)'
             56 'RESPIRATORY AGENTS NTA:(56)'
             58 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(58)'
             59 'BETA-ADRENERGIC BLOCKING AGENTS:(59)'
             60 'CALCIUM CHANNEL BLOCKING AGENTS:(60)' 61 'DIURETICS:(61)'
             61.3 'RENIN INHIBITORS:(61.3)'
             61.5 'VASOPRESSIN ANTAGONISTS:(61.5)'
             62 'CARDIOVASCULAR AGENTS NTA:(62)'
             63.1 'HERBAL PRODUCTS:(63.1)'
             63.2 'NUTRACEUTICAL PRODUCTS:(63.2)' 63.3 'PROBIOTICS:(63.3)'
             64.01 'AMEBICIDES:(64.01)' 64.02 'AMINOGLYCOSIDES:(64.02)'
             64.03 'ANTHELMINTICS:(64.03)' 64.04 'ANTIFUNGALS:(64.04)'
             64.05 'ANTIMALARIAL AGENTS:(64.05)'
             64.06 'ANTITUBERCULOSIS AGENTS:(64.06)'
             64.07 'ANTIVIRAL AGENTS:(64.07)' 64.08 'CARBAPENEMS:(64.08)'
             64.09 'CEPHALOSPORINS:(64.09)'
             64.1 'GLYCOPEPTIDE ANTIBIOTICS:(64.1)'
             64.11 'GLYCYLCYCLINES:(64.11)' 64.12 'LEPROSTATICS:(64.12)'
             64.13 'LINCOMYCIN DERIVATIVES:(64.13)'
             64.14 'MACROLIDE DERIVATIVES:(64.14)'
             64.15 'PENICILLINS:(64.15)' 64.16 'QUINOLONES:(64.16)'
             64.17 'SULFONAMIDES:(64.17)' 64.18 'TETRACYCLINES:(64.18)'
             64.19 'URINARY ANTI-INFECTIVES:(64.19)'
             64.99 'MISCELLANEOUS ANTIBIOTICS:(64.99)'
             65.01 'ALKYLATING AGENTS:(65.01)'
             65.02 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(65.02)'
             65.03 'ANTIMETABOLITES:(65.03)'
             65.04 'ANTINEOPLASTIC ANTIBIOTICS:(65.04)'
             65.05 'ANTINEOPLASTIC DETOXIFYING AGENTS:(65.05)'
             65.06 'ANTINEOPLASTIC HORMONES:(65.06)'
             65.07 'ANTINEOPLASTIC INTERFERONS:(65.07)'
             65.08 'BCR-ABL TYROSINE KINASE INHIBITORS:(65.08)'
             65.09 'CD20 MONOCLONAL ANTIBODIES:(65.09)'
             65.11 'CD33 MONOCLONAL ANTIBODIES:(65.11)'
             65.12 'CD52 MONOCLONAL ANTIBODIES:(65.12)'
             65.13 'EGFR INHIBITORS:(65.13)' 65.14 'HER2 INHIBITORS:(65.14)'
             65.15 'HISTONE DEACETYLASE INHIBITORS:(65.15)'
             65.16 'MITOTIC INHIBITORS:(65.16)'
             65.17 'MTOR INHIBITORS:(65.17)'
             65.18 'MULTIKINASE INHIBITORS:(65.18)'
             65.2 'VEGF/VEGFR INHIBITORS:(65.2)'
             65.99 'MISCELLANEOUS ANTINEOPLASTICS:(65.99)'
             66.01 'ANTITOXINS AND ANTIVENINS:(66.01)'
             66.04 'IN VIVO DIAGNOSTIC BIOLOGICALS:(66.04)'
             66.05 'RECOMBINANT HUMAN ERYTHROPOIETINS:(66.05)'
             67.01 'ANTICOAGULANTS:(67.01)'
             67.02 'ANTIPLATELET AGENTS:(67.02)'
             67.03 'HEPARIN ANTAGONISTS:(67.03)'
             67.04 'PLATELET-STIMULATING AGENTS:(67.04)'
             67.05 'THROMBOLYTICS:(67.05)'
             67.06 'MISCELLANEOUS COAGULATION MODIFIERS:(67.06)'
             68.01 '5-AMINOSALICYLATES:(68.01)' 68.02 'ANTACIDS:(68.02)'
             68.04 'ANTIDIARRHEALS:(68.04)' 68.05 'DIGESTIVE ENZYMES:(68.05)'
             68.06 'FUNCTIONAL BOWEL DISORDER AGENTS:(68.06)'
             68.07 'GALLSTONE SOLUBILIZING AGENTS:(68.07)'
             68.08 'GI STIMULANTS:(68.08)'
             68.09 'H. PYLORI ERADICATION AGENTS:(68.09)'
             68.1 'H2 ANTAGONISTS:(68.1)' 68.11 'LAXATIVES:(68.11)'
             68.12 'PROTON PUMP INHIBITORS:(68.12)'
             68.13 'MISCELLANEOUS GI AGENTS:(68.13)'
             69.01 'IMPOTENCE AGENTS:(69.01)'
             69.02 'TOCOLYTIC AGENTS:(69.02)'
             69.03 'URINARY ANTISPASMODICS:(69.03)'
             69.04 'URINARY PH MODIFIERS:(69.04)'
             69.05 'UTEROTONIC AGENTS:(69.05)'
             69.99 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(69.99)'
             70.01 '5-ALPHA-REDUCTASE INHIBITORS:(70.01)'
             70.02 'ADRENAL CORTICAL STEROIDS:(70.02)'
             70.05 'ANTIDIURETIC HORMONES:(70.05)'
             70.06 'ANTIGONADOTROPIC AGENTS:(70.06)'
             70.07 'ANTITHYROID AGENTS:(70.07)' 70.09 'CALCITONIN:(70.09)'
             70.11 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(70.11)'
             70.12 'GROWTH HORMONE RECEPTOR BLOCKERS:(70.12)'
             70.13 'GROWTH HORMONES:(70.13)'
             70.15 'INSULIN-LIKE GROWTH FACTOR:(70.15)'
             70.16 'PARATHYROID HORMONE AND ANALOGS:(70.16)'
             70.17 'PROGESTERONE RECEPTOR MODULATORS:(70.17)'
             70.18 'PROLACTIN INHIBITORS:(70.18)'
             70.19 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(70.19)'
             70.2 'SEX HORMONES:(70.2)'
             70.21 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(70.21)'
             70.22 'SYNTHETIC OVULATION STIMULANTS:(70.22)'
             70.23 'THYROID HORMONES:(70.23)'
             70.99 'MISCELLANEOUS HORMONES:(70.99)'
             71.01 'IMMUNE GLOBULINS:(71.01)'
             71.02 'IMMUNOSTIMULANTS:(71.02)'
             71.03 'IMMUNOSUPPRESSIVE AGENTS:(71.03)'
             71.99 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(71.99)'
             73.01 'ANTIDIABETIC AGENTS:(73.01)'
             73.02 'ANTIGOUT AGENTS:(73.02)'
             73.03 'ANTIHYPERLIPIDEMIC AGENTS:(73.03)'
             73.04 'ANTIHYPERURICEMIC AGENTS:(73.04)'
             73.05 'BONE RESORPTION INHIBITORS:(73.05)'
             73.06 'GLUCOSE ELEVATING AGENTS:(73.06)'
             73.07 'LYSOSOMAL ENZYMES:(73.07)'
             73.08 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(73.08)'
             73.99 'MISCELLANEOUS METABOLIC AGENTS:(73.99)'
             74.01 'ANTIDOTES:(74.01)' 74.04 'ANTIPSORIATICS:(74.04)'
             74.05 'ANTIRHEUMATICS:(74.05)' 74.06 'CHELATING AGENTS:(74.06)'
             74.07 'CHOLINERGIC MUSCLE STIMULANTS:(74.07)'
             74.11 'LOCAL INJECTABLE ANESTHETICS:(74.11)'
             74.13 'PSORALENS:(74.13)'
             74.17 'SMOKING CESSATION AGENTS:(74.17)'
             74.18 'VISCOSUPPLEMENTATION AGENTS:(74.18)'
             74.19 'MISCELLANEOUS UNCATEGORIZED AGENTS:(74.19)'
             75.01 'INTRAVENOUS NUTRITIONAL PRODUCTS:(75.01)'
             75.02 'IRON PRODUCTS:(75.02)'
             75.03 'MINERALS AND ELECTROLYTES:(75.03)'
             75.04 'ORAL NUTRITIONAL SUPPLEMENTS:(75.04)'
             75.05 'VITAMIN AND MINERAL COMBINATIONS:(75.05)'
             75.06 'VITAMINS:(75.06)' 77.01 'RADIOCONTRAST AGENTS:(77.01)'
             77.02 'RADIOLOGIC ADJUNCTS:(77.02)'
             77.03 'RADIOPHARMACEUTICALS:(77.03)'
             78.01 'ANORECTAL PREPARATIONS:(78.01)'
             78.02 'ANTISEPTIC AND GERMICIDES:(78.02)'
             78.03 'DERMATOLOGICAL AGENTS:(78.03)'
             78.04 'MOUTH AND THROAT PRODUCTS:(78.04)'
             78.05 'NASAL PREPARATIONS:(78.05)'
             78.06 'OPHTHALMIC PREPARATIONS:(78.06)'
             78.07 'OTIC PREPARATIONS:(78.07)'
             78.08 'STERILE IRRIGATING SOLUTIONS:(78.08)'
             78.09 'VAGINAL PREPARATIONS:(78.09)' /
   SDLED_4_1 -7 'NOT APPLICABLE:(-7.00)' 5.01 'MARIJUANA:(5.01)'
             5.02 'SYNTHETIC CANNABINOIDS:(5.02)' 6 'AMPHETAMINES:(6)'
             7 'METHAMPHETAMINE:(7)' 7.1 'OTHER STIMULANTS:(7.1)'
             20 'MAO INHIBITORS:(20)'
             20.4 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(20.4)'
             20.7 'SSNRI ANTIDEPRESSANTS:(20.7)'
             21 'SSRI ANTIDEPRESSANTS:(21)'
             21.5 'TETRACYCLIC ANTIDEPRESSANTS:(21.5)'
             22 'TRICYCLIC ANTIDEPRESSANTS:(22)'
             23 'MISCELLANEOUS ANTIDEPRESSANTS:(23)'
             25 'ATYPICAL ANTIPSYCHOTICS:(25)'
             26 'PHENOTHIAZINE ANTIPSYCHOTICS:(26)'
             26.5 'PSYCHOTHERAPEUTIC COMBINATIONS:(26.5)'
             26.7 'THIOXANTHENES:(26.7)'
             27 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(27)'
             35 'ANTIMIGRAINE AGENTS:(35)' 36 'COX-2 INHIBITORS:(36)'
             36.5 'OPIATES/OPIOIDS:(36.5)'
             39 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(39)'
             40.5 'SALICYLATES/COMBINATIONS:(40.5)'
             41.5 'MISCELLANEOUS ANALGESICS/COMBINATIONS:(41.5)'
             42.5 'ANALGESIC COMBINATIONS NTA:(42.5)'
             43.01 'PHENYLPROPANOLAMINE:(43.01)'
             43.02 'ANOREXIANTS-NOS:(43.02)' 43.09 'ANOREXIANTS NTA:(43.09)'
             44.01 'BARBITURATE ANTICONVULSANTS:(44.01)'
             44.02 'BENZODIAZEPINE ANTICONVULSANTS:(44.02)'
             44.03 'CARBAMATE ANTICONVULSANTS:(44.03)'
             44.04 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(44.04)'
             44.05 'DIBENZAZEPINE ANTICONVULSANTS:(44.05)'
             44.06 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(44.06)'
             44.07 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(44.07)'
             44.08 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(44.08)'
             44.09 'HYDANTOIN ANTICONVULSANTS:(44.09)'
             44.11 'OXAZOLIDINEDIONE ANTICONVULSANTS:(44.11)'
             44.12 'PYRROLIDINE ANTICONVULSANTS:(44.12)'
             44.13 'SUCCINIMIDE ANTICONVULSANTS:(44.13)'
             44.14 'TRIAZINE ANTICONVULSANTS:(44.14)'
             44.99 'MISCELLANEOUS ANTICONVULSANTS:(44.99)'
             45.01 '5HT3 RECEPTOR ANTAGONISTS:(45.01)'
             45.02 'ANTICHOLINERGIC ANTIEMETICS:(45.02)'
             45.03 'PHENOTHIAZINE ANTIEMETICS:(45.03)'
             45.04 'MISCELLANEOUS ANTIEMETICS:(45.04)'
             46.01 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(46.01)'
             46.02 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(46.02)'
             46.03 'MISCELLANEOUS ANTIPARKINSON AGENTS:(46.03)'
             46.31 'BARBITURATES:(46.31)' 46.32 'BENZODIAZEPINES:(46.32)'
             46.33 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.33)'
             46.501 'AMPHETAMINE-DEXTROAMPHETAMINE:(46.501)'
             46.502 'BENZPHETAMINE:(46.502)' 46.503 'CAFFEINE:(46.503)'
             46.504 'DEXTROAMPHETAMINE:(46.504)'
             46.505 'METHYLPHENIDATE:(46.505)'
             46.509 'CNS STIMULANTS NTA:(46.509)'
             48.01 'NEUROMUSCULAR BLOCKING AGENTS:(48.01)'
             48.02 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(48.02)'
             48.03 'SKELETAL MUSCLE RELAXANTS:(48.03)'
             48.04 'MISCELLANEOUS MUSCLE RELAXANTS:(48.04)'
             49.01 'CHOLINERGIC AGONISTS:(49.01)'
             49.02 'CHOLINESTERASE INHIBITORS:(49.02)'
             49.03 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(49.03)'
             52.01 'ADRENERGIC BRONCHODILATORS:(52.01)'
             52.02 'ANTICHOLINERGIC BRONCHODILATORS:(52.02)'
             52.03 'BRONCHODILATOR COMBINATIONS:(52.03)'
             52.04 'METHYLXANTHINES:(52.04)'
             52.05 'MISCELLANEOUS BRONCHODILATORS:(52.05)'
             56.01 'ANTIASTHMATIC COMBINATIONS:(56.01)'
             56.02 'ANTITUSSIVES:(56.02)'
             56.03 'LEUKOTRIENE MODIFIERS:(56.03)'
             56.05 'RESPIRATORY INHALANT PRODUCTS:(56.05)'
             56.06 'MISCELLANEOUS RESPIRATORY AGENTS:(56.06)'
             58.01 'CLONIDINE:(58.01)'
             58.09 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING NTA:(58.09)'
             59.01 'CARDIOSELECTIVE BETA BLOCKERS:(59.01)'
             59.02 'NON-CARDIOSELECTIVE BETA BLOCKERS:(59.02)'
             59.03 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(59.03)'
             61.01 'CARBONIC ANHYDRASE INHIBITORS:(61.01)'
             61.02 'LOOP DIURETICS:(61.02)'
             61.03 'POTASSIUM-SPARING DIURETICS:(61.03)'
             61.04 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(61.04)'
             61.05 'MISCELLANEOUS DIURETICS:(61.05)'
             62.01 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(62.01)'
             62.02 'AGENTS FOR PULMONARY HYPERTENSION:(62.02)'
             62.03 'ALDOSTERONE RECEPTOR ANTAGONISTS:(62.03)'
             62.04 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(62.04)'
             62.05 'ANGIOTENSIN II INHIBITORS:(62.05)'
             62.06 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(62.06)'
             62.07 'ANTIANGINAL AGENTS:(62.07)'
             62.08 'ANTIARRHYTHMIC AGENTS:(62.08)'
             62.09 'ANTIHYPERTENSIVE COMBINATIONS:(62.09)'
             62.1 'CATECHOLAMINES:(62.1)' 62.11 'INOTROPIC AGENTS:(62.11)'
             62.12 'PERIPHERAL VASODILATORS:(62.12)'
             62.13 'SCLEROSING AGENTS:(62.13)' 62.14 'VASODILATORS:(62.14)'
             62.15 'VASOPRESSORS:(62.15)'
             62.99 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(62.99)'
             64.041 'AZOLE ANTIFUNGALS:(64.041)'
             64.042 'ECHINOCANDINS:(64.042)' 64.043 'POLYENES:(64.043)'
             64.044 'MISCELLANEOUS ANTIFUNGALS:(64.044)'
             64.051 'ANTIMALARIAL COMBINATIONS:(64.051)'
             64.052 'ANTIMALARIAL QUINOLINES:(64.052)'
             64.053 'MISCELLANEOUS ANTIMALARIALS:(64.053)'
             64.061 'AMINOSALICYLATES:(64.061)'
             64.062 'ANTITUBERCULOSIS COMBINATIONS:(64.062)'
             64.063 'NICOTINIC ACID DERIVATIVES:(64.063)'
             64.064 'RIFAMYCIN DERIVATIVES:(64.064)'
             64.065 'STREPTOMYCES DERIVATIVES:(64.065)'
             64.066 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(64.066)'
             64.0701 'ADAMANTANE ANTIVIRALS:(64.0701)'
             64.0702 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(64.0702)'
             64.0703 'ANTIVIRAL COMBINATIONS:(64.0703)'
             64.0704 'ANTIVIRAL INTERFERONS:(64.0704)'
             64.0705 'INTEGRASE STRAND TRANSFER INHIBITOR:(64.0705)'
             64.0706 'NEURAMINIDASE INHIBITORS:(64.0706)'
             64.0707 'NNRTIS:(64.0707)' 64.0708 'NRTIS:(64.0708)'
             64.0709 'PROTEASE INHIBITORS:(64.0709)'
             64.071 'PURINE NUCLEOSIDES:(64.071)'
             64.0711 'MISCELLANEOUS ANTIVIRALS:(64.0711)'
             64.091 'FIRST GENERATION CEPHALOSPORINS:(64.091)'
             64.092 'SECOND GENERATION CEPHALOSPORINS:(64.092)'
             64.093 'THIRD GENERATION CEPHALOSPORINS:(64.093)'
             64.094 'FOURTH GENERATION CEPHALOSPORINS:(64.094)'
             64.095 'FIFTH GENERATION CEPHALOSPORINS:(64.095)'
             64.096 'MISCELLANEOUS CEPHALOSPORINS:(64.096)'
             64.141 'KETOLIDES:(64.141)' 64.142 'MACROLIDES:(64.142)'
             64.143 'MISCELLANEOUS MACROLIDES:(64.143)'
             64.151 'AMINOPENICILLINS:(64.151)'
             64.152 'ANTIPSEUDOMONAL PENICILLINS:(64.152)'
             64.153 'BETA-LACTAMASE INHIBITORS:(64.153)'
             64.154 'NATURAL PENICILLINS:(64.154)'
             64.155 'PENICILLINASE RESISTANT PENICILLINS:(64.155)'
             67.011 'COUMARINS AND INDANEDIONES:(67.011)'
             67.012 'FACTOR XA INHIBITORS:(67.012)'
             67.013 'HEPARINS:(67.013)' 67.014 'THROMBIN INHIBITORS:(67.014)'
             67.021 'GLYCOPROTEIN PLATELET INHIBITORS:(67.021)'
             67.022 'PLATELET AGGREGATION INHIBITORS:(67.022)'
             68.061 'ANTICHOLINERGICS/ANTISPASMODICS:(68.061)'
             68.062 'CHLORIDE CHANNEL ACTIVATORS:(68.062)'
             68.063 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(68.063)'
             68.064 'SEROTONINERGIC NEUROENTERIC MODULATORS:(68.064)'
             70.021 'CORTICOTROPIN:(70.021)'
             70.022 'GLUCOCORTICOIDS:(70.022)'
             70.023 'MINERALOCORTICOIDS:(70.023)'
             70.029 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(70.029)'
             70.202 'ANDROGENS AND ANABOLIC STEROIDS:(70.202)'
             70.203 'CONTRACEPTIVES:(70.203)' 70.204 'ESTROGENS:(70.204)'
             70.205 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(70.205)'
             70.206 'GONADOTROPINS:(70.206)' 70.207 'PROGESTINS:(70.207)'
             70.208 'SEX HORMONE COMBINATIONS:(70.208)'
             70.209 'MISCELLANEOUS SEX HORMONES:(70.209)'
             71.021 'BACTERIAL VACCINES:(71.021)'
             71.022 'COLONY STIMULATING FACTORS:(71.022)'
             71.023 'INTERFERONS:(71.023)'
             71.025 'THERAPEUTIC VACCINES:(71.025)'
             71.026 'VACCINE COMBINATIONS:(71.026)'
             71.027 'VIRAL VACCINES:(71.027)'
             71.029 'OTHER IMMUNOSTIMULANTS:(71.029)'
             71.031 'CALCINEURIN INHIBITORS:(71.031)'
             71.032 'INTERLEUKIN INHIBITORS:(71.032)'
             71.033 'SELECTIVE IMMUNOSUPPRESSANTS:(71.033)'
             71.034 'TNF ALFA INHIBITORS:(71.034)'
             71.039 'OTHER IMMUNOSUPPRESSANTS:(71.039)'
             73.0101 'ALPHA-GLUCOSIDASE INHIBITORS:(73.0101)'
             73.0102 'AMYLIN ANALOGS:(73.0102)'
             73.0103 'ANTIDIABETIC COMBINATIONS:(73.0103)'
             73.0104 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(73.0104)'
             73.0105 'INCRETIN MIMETICS:(73.0105)'
             73.0106 'INSULIN:(73.0106)' 73.0107 'MEGLITINIDES:(73.0107)'
             73.0108 'BIGUANIDES:(73.0108)' 73.0109 'SULFONYLUREAS:(73.0109)'
             73.011 'THIAZOLIDINEDIONES:(73.011)'
             73.019 'MISCELLANEOUS ANTIDIABETIC AGENTS:(73.019)'
             73.031 'ANTIHYPERLIPIDEMIC COMBINATIONS:(73.031)'
             73.032 'BILE ACID SEQUESTRANTS:(73.032)'
             73.033 'CHOLESTEROL ABSORPTION INHIBITORS:(73.033)'
             73.034 'FIBRIC ACID DERIVATIVES:(73.034)'
             73.035 'HMG-COA REDUCTASE INHIBITORS:(73.035)'
             73.036 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(73.036)'
             73.051 'BISPHOSPHONATES:(73.051)'
             73.059 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(73.059)'
             77.011 'IONIC IODINATED CONTRAST MEDIA:(77.011)'
             77.012 'LYMPHATIC STAINING AGENTS:(77.012)'
             77.013 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(77.013)'
             77.014 'NON-IODINATED CONTRAST MEDIA:(77.014)'
             77.015 'NON-IONIC IODINATED CONTRAST MEDIA:(77.015)'
             77.016 'ULTRASOUND CONTRAST MEDIA:(77.016)'
             77.017 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(77.017)'
             77.019 'MISCELLANEOUS RADIOCONTRAST AGENTS:(77.019)'
             77.021 'CARDIAC STRESSING AGENTS:(77.021)'
             77.031 'DIAGNOSTIC RADIOPHARMACEUTICALS:(77.031)'
             77.032 'THERAPEUTIC RADIOPHARMACEUTICALS:(77.032)'
             77.033 'MISCELLANEOUS RADIOPHARMACEUTICALS:(77.033)'
             78.0301 'TOPICAL ACNE AGENTS:(78.0301)'
             78.0302 'TOPICAL ANESTHETICS:(78.0302)'
             78.0303 'TOPICAL ANTIBIOTICS:(78.0303)'
             78.0304 'TOPICAL ANTIFUNGALS:(78.0304)'
             78.0305 'TOPICAL ANTIHISTAMINES:(78.0305)'
             78.0306 'TOPICAL ANTI-INFECTIVES:(78.0306)'
             78.0307 'TOPICAL ANTIPSORIATICS:(78.0307)'
             78.0308 'TOPICAL ANTIVIRALS:(78.0308)'
             78.0309 'TOPICAL ASTRINGENTS:(78.0309)'
             78.031 'TOPICAL DEBRIDING AGENTS:(78.031)'
             78.0311 'TOPICAL DEPIGMENTING AGENTS:(78.0311)'
             78.0312 'TOPICAL EMOLLIENTS:(78.0312)'
             78.0313 'TOPICAL KERATOLYTICS:(78.0313)'
             78.0314 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(78.0314)'
             78.0315 'TOPICAL STEROIDS:(78.0315)'
             78.0316 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(78.0316)'
             78.0399 'MISCELLANEOUS TOPICAL AGENTS:(78.0399)'
             78.051 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(78.051)'
             78.053 'NASAL LUBRICANTS AND IRRIGATIONS:(78.053)'
             78.054 'NASAL STEROIDS:(78.054)'
             78.055 'MISCELLANEOUS NASAL PREPARATIONS:(78.055)'
             78.0602 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(78.0602)'
             78.061 'MYDRIATICS:(78.061)'
             78.062 'OPHTHALMIC ANESTHETICS:(78.062)'
             78.063 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(78.063)'
             78.064 'OPHTHALMIC ANTI-INFECTIVES:(78.064)'
             78.065 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(78.065)'
             78.066 'OPHTHALMIC DIAGNOSTIC AGENTS:(78.066)'
             78.067 'OPHTHALMIC GLAUCOMA AGENTS:(78.067)'
             78.068 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(78.068)'
             78.069 'OPHTHALMIC STEROIDS:(78.069)'
             78.0691 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(78.0691)'
             78.0692 'OPHTHALMIC SURGICAL AGENTS:(78.0692)'
             78.0693 'MISCELLANEOUS OPHTHALMIC AGENTS:(78.0693)'
             78.071 'CERUMENOLYTICS:(78.071)'
             78.072 'OTIC ANESTHETICS:(78.072)'
             78.073 'OTIC ANTI-INFECTIVES:(78.073)'
             78.074 'OTIC STEROIDS:(78.074)'
             78.075 'OTIC STEROIDS WITH ANTI-INFECTIVES:(78.075)'
             78.076 'MISCELLANEOUS OTIC AGENTS:(78.076)'
             78.091 'SPERMICIDES:(78.091)'
             78.092 'VAGINAL ANTI-INFECTIVES:(78.092)'
             78.093 'MISCELLANEOUS VAGINAL AGENTS:(78.093)' /
   SDLED_5_1 -7 'NOT APPLICABLE' 20.41 'NEFAZODONE:(20.41)'
             20.42 'TRAZODONE:(20.42)' 20.71 'DESVENLAFAXINE:(20.71)'
             20.72 'DULOXETINE:(20.72)' 20.73 'VENLAFAXINE:(20.73)'
             20.79 'SSNRI ANTIDEPRESSANTS NTA:(20.79)'
             21.01 'CITALOPRAM:(21.01)' 21.02 'FLUOXETINE:(21.02)'
             21.03 'FLUVOXAMINE:(21.03)' 21.04 'PAROXETINE:(21.04)'
             21.05 'SERTRALINE:(21.05)'
             21.09 'SSRI ANTIDEPRESSANTS NTA:(21.09)'
             21.51 'MAPROTILINE:(21.51)' 21.52 'MIRTAZAPINE:(21.52)'
             22.01 'AMITRIPTYLINE:(22.01)' 22.02 'DESIPRAMINE:(22.02)'
             22.03 'DOXEPIN:(22.03)' 22.04 'IMIPRAMINE:(22.04)'
             22.05 'NORTRIPTYLINE:(22.05)'
             22.06 'TRICYCLIC ANTIDEPRESSANTS-NOS:(22.06)'
             22.09 'TRICYCLIC ANTIDEPRESSANTS NTA:(22.09)'
             23.01 'BUPROPION:(23.01)' 23.06 'ANTIDEPRESSANTS-NOS:(23.06)'
             23.09 'MISCELLANEOUS ANTIDEPRESSANTS NTA:(23.09)'
             25.01 'CLOZAPINE:(25.01)' 25.02 'OLANZAPINE:(25.02)'
             25.03 'QUETIAPINE:(25.03)' 25.04 'RISPERIDONE:(25.04)'
             25.09 'ATYPICAL ANTIPSYCHOTICS NTA:(25.09)'
             26.01 'CHLORPROMAZINE:(26.01)' 26.02 'FLUPHENAZINE:(26.02)'
             26.03 'PERPHENAZINE:(26.03)' 26.04 'PROCHLORPERAZINE:(26.04)'
             26.05 'THIORIDAZINE:(26.05)' 26.06 'TRIFLUPROMAZINE:(26.06)'
             26.09 'PHENOTHIAZINE ANTIPSYCHOTICS NTA:(26.09)'
             27.01 'HALOPERIDOL:(27.01)' 27.02 'LITHIUM:(27.02)'
             27.09 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS NTA:(27.09)'
             36.75 'OPIATES/OPIOIDS, UNSPECIFIED:(36.75)'
             37.5 'NARCOTIC ANALGESICS:(37.5)'
             39.01 'IBUPROFEN/COMBINATIONS:(39.01)'
             39.02 'NAPROXEN/COMBINATIONS:(39.02)'
             39.03 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS NTA:(39.03)'
             40.501 'ASPIRIN/COMBINATIONS:(40.501)'
             40.502 'SALICYLATES-NOS:(40.502)'
             40.503 'SALICYLATES/COMBINATIONS NTA:(40.503)'
             41.501 'ACETAMINOPHEN/COMBINATIONS:(41.501)'
             41.502 'TRAMADOL/COMBINATIONS:(41.502)'
             41.505 'ANALGESICS-NOS:(41.505)'
             41.506 'MISCELLANEOUS ANALGESIC/COMBINATIONS NTA:(41.506)'
             44.041 'TOPIRAMATE:(44.041)'
           44.049 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS NTA:(44.049)'
             44.051 'CARBAMAZEPINE:(44.051)' 44.052 'OXCARBAZEPINE:(44.052)'
             44.053 'RUFINAMIDE:(44.053)' 44.061 'DIVALPROEX SODIUM:(44.061)'
             44.062 'VALPROIC ACID:(44.062)' 44.071 'GABAPENTIN:(44.071)'
             44.079 'GAMMA-AMINOBUTYRIC ACID ANALOGS NTA:(44.079)'
             44.091 'PHENYTOIN:(44.091)'
             44.099 'HYDANTOIN ANTICONVULSANTS NTA:(44.099)'
             46.011 'BENZTROPINE:(46.011)'
             46.019 'ANTICHOLINERGIC ANTIPARKINSON AGENTS NTA:(46.019)'
             46.3101 'PHENOBARBITAL:(46.3101)'
             46.3102 'BARBITURATES-NOS:(46.3102)'
             46.3109 'BARBITURATES NTA:(46.3109)'
             46.3201 'ALPRAZOLAM:(46.3201)'
             46.3202 'CHLORDIAZEPOXIDE:(46.3202)'
             46.3203 'CLONAZEPAM:(46.3203)' 46.3204 'CLORAZEPATE:(46.3204)'
             46.3205 'DIAZEPAM:(46.3205)' 46.3206 'FLURAZEPAM:(46.3206)'
             46.3207 'LORAZEPAM:(46.3207)' 46.3208 'OXAZEPAM:(46.3208)'
             46.3209 'TEMAZEPAM:(46.3209)' 46.321 'TRIAZOLAM:(46.321)'
             46.3211 'BENZODIAZEPINES-NOS:(46.3211)'
             46.3219 'BENZODIAZEPINES NTA:(46.3219)'
             46.3301 'BUSPIRONE:(46.3301)'
             46.3302 'CHLORAL HYDRATE:(46.3302)'
             46.3303 'DIPHENHYDRAMINE:(46.3303)'
             46.3304 'DOXYLAMINE:(46.3304)' 46.3305 'HYDROXYZINE:(46.3305)'
             46.3306 'ZOLPIDEM:(46.3306)'
             46.3307 'ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS:(46.3307)'
          46.3309 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS NTA:(46.3309)'
             46.5091 'CAFFEINE/MULTIVITAMIN:(46.5091)'
             46.5092 'OTHER CNS STIMULANTS NTA:(46.5092)'
             48.031 'CARISOPRODOL:(48.031)' 48.032 'CHLORZOXAZONE:(48.032)'
             48.033 'CYCLOBENZAPRINE:(48.033)' 48.034 'METAXALONE:(48.034)'
             48.035 'METHOCARBAMOL:(48.035)' 48.036 'TIZANIDINE:(48.036)'
             48.039 'SKELETAL MUSCLE RELAXANTS NTA:(48.039)'
             56.052 'INHALED CORTICOSTEROIDS:(56.052)'
             56.053 'MAST CELL STABILIZERS:(56.053)'
             56.054 'MUCOLYTICS:(56.054)'
             56.059 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(56.059)'
             59.011 'ATENOLOL:(59.011)'
             59.019 'CARDIOSELECTIVE BETA BLOCKERS NTA:(59.019)'
             59.021 'PROPRANOLOL:(59.021)'
             59.029 'NON-CARDIOSELECTIVE BETA BLOCKERS NTA:(59.029)'
             62.081 'GROUP I ANTIARRHYTHMICS:(62.081)'
             62.083 'GROUP III ANTIARRHYTHMICS:(62.083)'
             62.085 'GROUP V ANTIARRHYTHMICS:(62.085)'
             62.089 'ANTIARRHYTHMIC AGENTS NTA:(62.089)'
             62.151 'EPHEDRINE:(62.151)' 62.159 'VASOPRESSORS NTA:(62.159)' /
   SDLED_6_1 -7 'NOT APPLICABLE:(-7)'
             37.5005 'BUPRENORPHINE/COMBINATIONS:(37.5005)'
             37.501 'CODEINE/COMBINATIONS:(37.501)'
             37.502 'DIHYDROCODEINE/COMBINATIONS:(37.502)'
             37.503 'FENTANYL/COMBINATIONS:(37.503)'
             37.504 'HYDROCODONE/COMBINATIONS:(37.504)'
             37.5045 'HYDROMORPHONE/COMBINATIONS:(37.5045)'
             37.505 'MEPERIDINE/COMBINATIONS:(37.505)'
             37.506 'METHADONE:(37.506)'
             37.507 'MORPHINE/COMBINATIONS:(37.507)'
             37.508 'OPIUM/COMBINATIONS:(37.508)'
             37.509 'OXYCODONE/COMBINATIONS:(37.509)'
             37.51 'PENTAZOCINE/COMBINATIONS:(37.51)'
             37.511 'PHENACETIN/COMBINATIONS:(37.511)'
             37.512 'PROPOXYPHENE/COMBINATIONS:(37.512)'
             37.514 'ALL OTHER NARCOTIC ANALGESICS/COMBINATIONS NTA:(37.514)'
             41.503 'TRAMADOL:(41.503)'
             41.504 'ACETAMINOPHEN-TRAMADOL:(41.504)' /
   DRUGID_2  -7 'NOT APPLICABLE' 1 'D00001 ACYCLOVIR' 2 'D00002 AMIODARONE'
             3 'D00003 AMPICILLIN' 4 'D00004 ATENOLOL' 5 'D00006 CAPTOPRIL'
             6 'D00007 CEFAZOLIN' 7 'D00008 CEFOTAXIME'
             8 'D00009 CEFTAZIDIME' 9 'D00010 CEFTIZOXIME'
             10 'D00011 CIPROFLOXACIN' 11 'D00012 CODEINE'
             12 'D00013 ENALAPRIL' 13 'D00014 GENTAMICIN'
             14 'D00015 IBUPROFEN' 15 'D00016 LABETALOL'
             16 'D00017 MEPERIDINE' 17 'D00018 NADOLOL' 18 'D00019 NAPROXEN'
             19 'D00020 QUINIDINE' 20 'D00021 RANITIDINE'
             21 'D00022 WARFARIN' 22 'D00023 ALLOPURINOL'
             23 'D00024 AZATHIOPRINE' 24 'D00025 CHLORAMPHENICOL'
             25 'D00026 FENOPROFEN' 26 'D00027 HALOPERIDOL'
             27 'D00028 KETOPROFEN' 28 'D00029 NAFCILLIN'
             29 'D00030 PENTAMIDINE' 30 'D00031 PROBENECID'
             31 'D00032 PROPRANOLOL' 32 'D00033 SULINDAC'
             33 'D00034 ZIDOVUDINE' 34 'D00035 CHLOROQUINE'
             35 'D00036 CYCLOPHOSPHAMIDE' 36 'D00037 DOXYCYCLINE'
             37 'D00038 FLUCYTOSINE' 38 'D00039 INDOMETHACIN'
             39 'D00040 OXAZEPAM' 40 'D00041 TETRACYCLINE'
             41 'D00042 CHLORPROPAMIDE' 42 'D00043 CLINDAMYCIN'
             43 'D00044 CLONIDINE' 44 'D00045 DILTIAZEM'
             45 'D00046 ERYTHROMYCIN' 46 'D00047 RIFAMPIN'
             47 'D00048 VERAPAMIL' 48 'D00049 ACETAMINOPHEN'
             49 'D00050 METHADONE' 50 'D00051 NIFEDIPINE'
             51 'D00052 CEFTRIAXONE' 52 'D00053 CEPHRADINE'
             53 'D00054 TOLMETIN' 54 'D00055 CEFOTETAN'
             55 'D00056 CEFUROXIME' 56 'D00057 PIPERACILLIN'
             57 'D00058 CARBAMAZEPINE' 58 'D00059 LIDOCAINE'
             59 'D00060 METHOTREXATE' 60 'D00061 LITHIUM'
             61 'D00062 CEFAMANDOLE' 62 'D00064 CHLORPROMAZINE'
             63 'D00065 FOSCARNET' 64 'D00066 GANCICLOVIR'
             65 'D00067 AZTREONAM' 66 'D00068 ETHAMBUTOL'
             67 'D00069 TOBRAMYCIN' 68 'D00070 FUROSEMIDE'
             69 'D00071 FLUCONAZOLE' 70 'D00072 CEFIXIME'
             71 'D00073 CEFPROZIL' 72 'D00074 CEFOPERAZONE'
             73 'D00075 PROCAINAMIDE' 74 'D00077 AMPHOTERICIN B'
             75 'D00078 DIDANOSINE' 76 'D00079 CYCLOSPORINE'
             77 'D00080 CEFADROXIL' 78 'D00081 CEFACLOR'
             79 'D00082 IMIPENEM-CILASTATIN' 80 'D00083 VALPROIC ACID'
             81 'D00084 PREDNISOLONE' 82 'D00085 RIBAVIRIN'
             83 'D00086 AMANTADINE' 84 'D00087 AMIKACIN'
             85 'D00088 AMOXICILLIN' 86 'D00089 AMOXICILLIN-CLAVULANATE'
             87 'D00090 AMPICILLIN-SULBACTAM' 88 'D00091 AZITHROMYCIN'
             89 'D00092 CARBENICILLIN' 90 'D00093 CEFMETAZOLE'
             91 'D00094 CEFOXITIN' 92 'D00095 CEFPODOXIME'
             93 'D00096 CEPHALEXIN' 94 'D00097 CLARITHROMYCIN'
             95 'D00098 DAPSONE' 96 'D00099 ENOXACIN'
             97 'D00100 GRISEOFULVIN' 98 'D00101 ISONIAZID'
             99 'D00102 ITRACONAZOLE' 100 'D00103 KETOCONAZOLE'
             101 'D00104 LOMEFLOXACIN' 102 'D00105 LORACARBEF'
             103 'D00106 METHENAMINE' 104 'D00107 METHICILLIN'
             105 'D00108 METRONIDAZOLE' 106 'D00109 MEZLOCILLIN'
             107 'D00110 MINOCYCLINE' 108 'D00112 NITROFURANTOIN'
             109 'D00113 NORFLOXACIN' 110 'D00114 OFLOXACIN'
             111 'D00115 OXACILLIN' 112 'D00116 PENICILLIN'
             113 'D00117 PYRAZINAMIDE' 114 'D00118 SULFADIAZINE'
             115 'D00119 SULFAMETHOXAZOLE' 116 'D00120 SULFISOXAZOLE'
             117 'D00121 TICARCILLIN' 118 'D00122 TICARCILLIN-CLAVULANATE'
             119 'D00123 TRIMETHOPRIM'
             120 'D00124 SULFAMETHOXAZOLE-TRIMETHOPRIM'
             121 'D00125 VANCOMYCIN' 122 'D00128 ACEBUTOLOL'
             123 'D00129 DIAZOXIDE' 124 'D00132 HYDRALAZINE'
             125 'D00133 METHYLDOPA' 126 'D00134 METOPROLOL'
             127 'D00135 MINOXIDIL' 128 'D00137 PINDOLOL'
             129 'D00138 PRAZOSIN' 130 'D00139 TIMOLOL'
             131 'D00140 CIMETIDINE' 132 'D00141 FAMOTIDINE'
             133 'D00142 THEOPHYLLINE' 134 'D00143 PHENYTOIN'
             135 'D00144 NORTRIPTYLINE' 136 'D00145 DESIPRAMINE'
             137 'D00146 AMITRIPTYLINE' 138 'D00147 CHLORAL HYDRATE'
             139 'D00148 DIAZEPAM' 140 'D00149 LORAZEPAM'
             141 'D00150 COLCHICINE' 142 'D00152 CLOXACILLIN'
             143 'D00153 DICLOXACILLIN' 144 'D00154 MEBENDAZOLE'
             145 'D00155 MICONAZOLE' 146 'D00157 NALIDIXIC ACID'
             147 'D00158 QUINACRINE' 148 'D00159 STREPTOMYCIN'
             149 'D00161 ACETAZOLAMIDE' 150 'D00164 ADENOSINE'
             151 'D00167 ALFENTANIL' 152 'D00168 ALPRAZOLAM'
             153 'D00169 AMILORIDE' 154 'D00170 ASPIRIN'
             155 'D00171 AMOBARBITAL' 156 'D00172 INAMRINONE'
             157 'D00173 ATRACURIUM' 158 'D00174 ATROPINE'
             159 'D00175 BENZTROPINE' 160 'D00176 BETAXOLOL'
             161 'D00177 BLEOMYCIN' 162 'D00178 BROMOCRIPTINE'
             163 'D00179 BUMETANIDE' 164 'D00180 BUPIVACAINE'
             165 'D00181 BUPROPION' 166 'D00182 BUSPIRONE'
             167 'D00183 BUSULFAN' 168 'D00184 CARBIDOPA'
             169 'D00185 CARBOPLATIN' 170 'D00186 CEPHALOTHIN'
             171 'D00187 CEPHAPIRIN' 172 'D00188 CHLORAMBUCIL'
             173 'D00189 CHLORDIAZEPOXIDE' 174 'D00190 CHLOROTHIAZIDE'
             175 'D00191 CHLORPHENIRAMINE' 176 'D00192 CHLORTHALIDONE'
             177 'D00193 CHOLESTYRAMINE' 178 'D00195 CISPLATIN'
             179 'D00197 CLONAZEPAM' 180 'D00198 CLORAZEPATE'
             181 'D00199 CLOZAPINE' 182 'D00200 CROMOLYN'
             183 'D00201 CYTARABINE' 184 'D00202 DACARBAZINE'
             185 'D00203 DACTINOMYCIN' 186 'D00204 DANAZOL'
             187 'D00205 DAUNORUBICIN' 188 'D00206 DEXAMETHASONE'
             189 'D00207 DEXTROMETHORPHAN' 190 'D00208 DIFLUNISAL'
             191 'D00209 DIGITOXIN' 192 'D00210 DIGOXIN'
             193 'D00211 DIHYDROERGOTAMINE' 194 'D00212 DIPHENHYDRAMINE'
             195 'D00213 DIPYRIDAMOLE' 196 'D00214 DISOPYRAMIDE'
             197 'D00215 DOBUTAMINE' 198 'D00216 DOPAMINE'
             199 'D00217 DOXEPIN' 200 'D00218 DOXORUBICIN'
             201 'D00219 DROPERIDOL' 202 'D00220 EDROPHONIUM'
             203 'D00222 ERGOTAMINE' 204 'D00223 EPOETIN ALFA'
             205 'D00224 ESMOLOL' 206 'D00226 ETHCHLORVYNOL'
             207 'D00227 ETHOSUXIMIDE' 208 'D00229 ETHINYL ESTRADIOL'
             209 'D00230 ETOPOSIDE' 210 'D00231 FELODIPINE'
             211 'D00233 FENTANYL' 212 'D00234 FLECAINIDE'
             213 'D00235 FLUOROURACIL' 214 'D00236 FLUOXETINE'
             215 'D00237 FLUPHENAZINE' 216 'D00238 FLURAZEPAM'
             217 'D00239 FLURBIPROFEN' 218 'D00240 FLUTAMIDE'
             219 'D00241 FOLIC ACID' 220 'D00242 FOSINOPRIL'
             221 'D00243 FURAZOLIDONE' 222 'D00245 GEMFIBROZIL'
             223 'D00246 GLIPIZIDE' 224 'D00248 GLYBURIDE'
             225 'D00250 GOLD SODIUM THIOMALATE' 226 'D00252 HEPARIN'
             227 'D00253 HYDROCHLOROTHIAZIDE' 228 'D00254 HYDROCORTISONE'
             229 'D00255 HYDROMORPHONE' 230 'D00256 IDARUBICIN'
             231 'D00257 IFOSFAMIDE' 232 'D00259 IMIPRAMINE'
             233 'D00260 INDAPAMIDE' 234 'D00262 INSULIN'
             235 'D00265 IPRATROPIUM' 236 'D00267 ISOFLURANE'
             237 'D00268 ISOSORBIDE DINITRATE'
             238 'D00269 ISOSORBIDE MONONITRATE' 239 'D00270 ISRADIPINE'
             240 'D00271 KANAMYCIN' 241 'D00272 KETAMINE'
             242 'D00273 KETOROLAC' 243 'D00275 LEUCOVORIN'
             244 'D00276 LEVAMISOLE' 245 'D00277 LEVODOPA'
             246 'D00278 LEVOTHYROXINE' 247 'D00279 LINCOMYCIN'
             248 'D00280 LOVASTATIN' 249 'D00282 MANNITOL'
             250 'D00283 MECLOFENAMATE' 251 'D00284 MEDROXYPROGESTERONE'
             252 'D00285 MEFENAMIC ACID' 253 'D00286 MEFLOQUINE'
             254 'D00287 MELPHALAN' 255 'D00288 MEPROBAMATE'
             256 'D00289 MERCAPTOPURINE' 257 'D00290 METHIMAZOLE'
             258 'D00292 METHSUXIMIDE' 259 'D00293 METHYLPREDNISOLONE'
             260 'D00295 METHYLTESTOSTERONE'
             261 'D00297 METIPRANOLOL OPHTHALMIC' 262 'D00298 METOCLOPRAMIDE'
             263 'D00299 METOLAZONE' 264 'D00300 MEXILETINE'
             265 'D00301 MIDAZOLAM' 266 'D00302 MILRINONE'
             267 'D00303 MISOPROSTOL' 268 'D00305 MITOMYCIN'
             269 'D00306 MITOXANTRONE' 270 'D00307 MORICIZINE'
             271 'D00308 MORPHINE' 272 'D00310 NABUMETONE'
             273 'D00311 NALOXONE' 274 'D00312 NEOMYCIN'
             275 'D00313 NEOSTIGMINE' 276 'D00314 NIACIN'
             277 'D00315 NICARDIPINE' 278 'D00316 NICOTINE'
             279 'D00318 NIMODIPINE' 280 'D00321 NITROGLYCERIN'
             281 'D00322 NIZATIDINE' 282 'D00323 NOREPINEPHRINE'
             283 'D00325 OMEPRAZOLE' 284 'D00328 OXYBUTYNIN'
             285 'D00329 OXYCODONE' 286 'D00330 PANCURONIUM'
             287 'D00331 PARAAMINOBENZOIC ACID' 288 'D00332 PENBUTOLOL'
             289 'D00333 PENICILLAMINE' 290 'D00334 PENTAZOCINE'
             291 'D00335 PENTOBARBITAL' 292 'D00336 PENTOXIFYLLINE'
             293 'D00337 PHENAZOPYRIDINE' 294 'D00340 PHENOBARBITAL'
             295 'D00341 PHENYLBUTAZONE' 296 'D00342 PHYSOSTIGMINE'
             297 'D00343 PIROXICAM' 298 'D00344 POLYMYXIN B SULFATE'
             299 'D00345 POTASSIUM CHLORIDE'
             300 'D00346 POVIDONE IODINE TOPICAL' 301 'D00348 PRAVASTATIN'
             302 'D00349 PRAZIQUANTEL' 303 'D00350 PREDNISONE'
             304 'D00351 PRIMAQUINE' 305 'D00352 PRIMIDONE'
             306 'D00353 PROBUCOL' 307 'D00354 PROCARBAZINE'
             308 'D00355 PROCHLORPERAZINE' 309 'D00356 PROMAZINE'
             310 'D00358 PROPAFENONE' 311 'D00359 PROPANTHELINE'
             312 'D00360 PROPOXYPHENE' 313 'D00361 PROPYLTHIOURACIL'
             314 'D00362 PROTAMINE' 315 'D00363 PYRIDOSTIGMINE'
             316 'D00364 PYRIMETHAMINE' 317 'D00365 QUINAPRIL'
             318 'D00366 QUININE' 319 'D00367 RESERPINE'
             320 'D00368 SECOBARBITAL' 321 'D00370 OCTREOTIDE'
             322 'D00371 SOTALOL' 323 'D00373 SPIRONOLACTONE'
             324 'D00374 STREPTOKINASE' 325 'D00375 STREPTOZOCIN'
             326 'D00376 SUCCINYLCHOLINE' 327 'D00377 SUCRALFATE'
             328 'D00378 SUFENTANIL' 329 'D00379 SULFASALAZINE'
             330 'D00381 TAMOXIFEN' 331 'D00384 TEMAZEPAM'
             332 'D00386 TERAZOSIN' 333 'D00387 TERFENADINE'
             334 'D00388 THIOPENTAL' 335 'D00389 THIORIDAZINE'
             336 'D00391 THIOTHIXENE' 337 'D00393 TOLAZAMIDE'
             338 'D00394 TOLBUTAMIDE' 339 'D00395 TRAZODONE'
             340 'D00396 TRIAMTERENE' 341 'D00397 TRIAZOLAM'
             342 'D00398 VASOPRESSIN' 343 'D00399 VECURONIUM'
             344 'D00400 VINBLASTINE' 345 'D00401 VINCRISTINE'
             346 'D00402 VITAMIN A' 347 'D00405 VITAMIN E'
             348 'D00409 RIBOFLAVIN' 349 'D00412 PYRIDOXINE'
             350 'D00413 CYANOCOBALAMIN' 351 'D00417 BIOFLAVONOIDS'
             352 'D00425 CALCIUM CARBONATE' 353 'D00426 ASCORBIC ACID'
             354 'D00427 POTASSIUM PHOSPHATE-SODIUM PHOSPHATE'
             355 'D00428 FLUORIDE' 356 'D00438 SODIUM CHLORIDE'
             357 'D00439 CITRIC ACID-POTASSIUM CITRATE'
             358 'D00440 SODIUM BICARBONATE' 359 'D00468 MAGNESIUM SULFATE'
             360 'D00471 SODIUM ACETATE' 361 'D00472 TROMETHAMINE'
             362 'D00475 SODIUM PHOSPHATE' 363 'D00476 AMMONIUM CHLORIDE'
             364 'D00481 AMMONIUM MOLYBDATE TETRAHYDRATE'
             365 'D00484 SELENIUM' 366 'D00485 IODINE TOPICAL'
             367 'D00487 GLUTAMIC ACID' 368 'D00488 LYSINE'
             369 'D00491 LEVOCARNITINE' 370 'D00496 INOSITOL'
             371 'D00497 OMEGA-3 POLYUNSATURATED FATTY ACIDS'
             372 'D00512 FILGRASTIM' 373 'D00513 SARGRAMOSTIM'
             374 'D00514 TICLOPIDINE' 375 'D00519 ANISINDIONE'
             376 'D00521 ALTEPLASE' 377 'D00523 UROKINASE'
             378 'D00524 ANTITHROMBIN III'
             379 'D00525 ANTIHEMOPHILIC FACTOR (OBSOLETE)'
             380 'D00526 ANTI-INHIBITOR COAGULANT COMPLEX'
             381 'D00527 FACTOR IX COMPLEX (OBSOLETE)'
             382 'D00528 AMINOCAPROIC ACID' 383 'D00529 TRANEXAMIC ACID'
             384 'D00534 ESTRONE' 385 'D00537 ESTRADIOL'
             386 'D00541 CONJUGATED ESTROGENS'
             387 'D00542 ESTERIFIED ESTROGENS' 388 'D00543 ESTROPIPATE'
             389 'D00546 DIETHYLSTILBESTROL' 390 'D00550 PROGESTERONE'
             391 'D00554 HYDROXYPROGESTERONE' 392 'D00555 NORETHINDRONE'
             393 'D00557 LEVONORGESTREL' 394 'D00558 TESTOSTERONE'
             395 'D00562 FLUOXYMESTERONE' 396 'D00563 FINASTERIDE'
             397 'D00565 STANOZOLOL' 398 'D00566 OXANDROLONE'
             399 'D00568 NANDROLONE' 400 'D00569 CLOMIPHENE'
             401 'D00570 UROFOLLITROPIN' 402 'D00571 MENOTROPINS'
             403 'D00572 CHORIONIC GONADOTROPIN (HCG)' 404 'D00574 NAFARELIN'
             405 'D00575 HISTRELIN' 406 'D00576 SOMATREM'
             407 'D00577 SOMATROPIN' 408 'D00578 ARGININE'
             409 'D00583 DESMOPRESSIN' 410 'D00584 OXYTOCIN'
             411 'D00586 ERGONOVINE' 412 'D00587 METHYLERGONOVINE'
             413 'D00589 DINOPROSTONE TOPICAL' 414 'D00592 METYRAPONE'
             415 'D00593 GLUCAGON' 416 'D00595 GLUCOSE'
             417 'D00598 CALCITONIN' 418 'D00599 ETIDRONATE'
             419 'D00601 PAMIDRONATE' 420 'D00602 GALLIUM NITRATE'
             421 'D00603 RITODRINE' 422 'D00604 CORTICOTROPIN'
             423 'D00607 COSYNTROPIN' 424 'D00608 FLUDROCORTISONE'
             425 'D00609 CORTISONE' 426 'D00620 TRIAMCINOLONE'
             427 'D00626 DEXAMETHASONE TOPICAL' 428 'D00628 BETAMETHASONE'
             429 'D00640 METHAZOLAMIDE' 430 'D00641 BENDROFLUMETHIAZIDE'
             431 'D00643 METHYCLOTHIAZIDE' 432 'D00644 BENZTHIAZIDE'
             433 'D00645 HYDROFLUMETHIAZIDE' 434 'D00646 TRICHLORMETHIAZIDE'
             435 'D00647 POLYTHIAZIDE' 436 'D00649 ETHACRYNIC ACID'
             437 'D00651 UREA TOPICAL' 438 'D00652 GLYCERIN'
             439 'D00653 ISOSORBIDE' 440 'D00655 THYROID DESICCATED'
             441 'D00658 LIOTHYRONINE' 442 'D00659 LIOTRIX'
             443 'D00666 AMYL NITRITE' 444 'D00683 LIDOCAINE TOPICAL'
             445 'D00688 BEPRIDIL' 446 'D00689 AMLODIPINE'
             447 'D00693 ISOXSUPRINE' 448 'D00695 PAPAVERINE'
             449 'D00696 ETHAVERINE' 450 'D00697 ISOPROTERENOL'
             451 'D00699 EPINEPHRINE' 452 'D00700 EPHEDRINE'
             453 'D00703 METHOXAMINE' 454 'D00704 PHENYLEPHRINE'
             455 'D00708 CARTEOLOL' 456 'D00709 BISOPROLOL'
             457 'D00717 GUANFACINE' 458 'D00726 DOXAZOSIN'
             459 'D00728 RAMIPRIL' 460 'D00730 BENAZEPRIL'
             461 'D00732 LISINOPRIL' 462 'D00733 PHENTOLAMINE'
             463 'D00734 PHENOXYBENZAMINE' 464 'D00735 METYROSINE'
             465 'D00739 MECAMYLAMINE'
             466 'D00743 SODIUM POLYSTYRENE SULFONATE'
             467 'D00744 COLESTIPOL' 468 'D00746 SIMVASTATIN'
             469 'D00747 DEXTROTHYROXINE SODIUM' 470 'D00749 ALBUTEROL'
             471 'D00750 METAPROTERENOL' 472 'D00752 TERBUTALINE'
             473 'D00755 PIRBUTEROL' 474 'D00758 AMINOPHYLLINE'
             475 'D00759 DYPHYLLINE' 476 'D00760 BECLOMETHASONE'
             477 'D00761 FLUNISOLIDE' 478 'D00762 ACETYLCYSTEINE'
             479 'D00765 CROMOLYN OPHTHALMIC'
             480 'D00767 PHENYLPROPANOLAMINE' 481 'D00769 PSEUDOEPHEDRINE'
             482 'D00771 NAPHAZOLINE OPHTHALMIC'
             483 'D00772 OXYMETAZOLINE NASAL'
             484 'D00773 TETRAHYDROZOLINE OPHTHALMIC'
             485 'D00774 XYLOMETAZOLINE NASAL'
             486 'D00775 ALPHA 1-PROTEINASE INHIBITOR'
             487 'D00780 CLEMASTINE' 488 'D00782 PYRILAMINE'
             489 'D00784 DEXCHLORPHENIRAMINE' 490 'D00785 BROMPHENIRAMINE'
             491 'D00786 TRIPROLIDINE' 492 'D00787 PROMETHAZINE'
             493 'D00788 TRIMEPRAZINE' 494 'D00789 METHDILAZINE'
             495 'D00790 CYPROHEPTADINE' 496 'D00791 AZATADINE'
             497 'D00793 PHENINDAMINE' 498 'D00796 BENZONATATE'
             499 'D00797 GUAIFENESIN' 500 'D00800 POTASSIUM IODIDE'
             501 'D00801 CAFFEINE' 502 'D00802 DOXAPRAM'
             503 'D00803 AMPHETAMINE' 504 'D00804 DEXTROAMPHETAMINE'
             505 'D00805 METHAMPHETAMINE' 506 'D00806 PHENTERMINE'
             507 'D00807 BENZPHETAMINE' 508 'D00809 PHENDIMETRAZINE'
             509 'D00810 DIETHYLPROPION' 510 'D00811 MAZINDOL'
             511 'D00812 FENFLURAMINE' 512 'D00813 BENZOCAINE TOPICAL'
             513 'D00814 METHOTRIMEPRAZINE' 514 'D00817 HYDROXYCHLOROQUINE'
             515 'D00824 OPIUM' 516 'D00825 LEVORPHANOL'
             517 'D00833 OXYMORPHONE' 518 'D00838 BUTORPHANOL'
             519 'D00839 NALBUPHINE' 520 'D00840 BUPRENORPHINE'
             521 'D00842 SALSALATE' 522 'D00846 MAGNESIUM SALICYLATE'
             523 'D00848 DICLOFENAC' 524 'D00851 ETODOLAC'
             525 'D00853 OXAPROZIN' 526 'D00855 PERPHENAZINE'
             527 'D00857 THIETHYLPERAZINE' 528 'D00858 CYCLIZINE'
             529 'D00859 MECLIZINE' 530 'D00861 DIMENHYDRINATE'
             531 'D00862 TRIMETHOBENZAMIDE' 532 'D00866 DRONABINOL'
             533 'D00867 ONDANSETRON' 534 'D00873 TRIMIPRAMINE'
             535 'D00874 AMOXAPINE' 536 'D00875 PROTRIPTYLINE'
             537 'D00876 CLOMIPRAMINE' 538 'D00877 MAPROTILINE'
             539 'D00880 SERTRALINE' 540 'D00882 ISOCARBOXAZID'
             541 'D00883 PHENELZINE' 542 'D00884 TRANYLCYPROMINE'
             543 'D00889 MESORIDAZINE' 544 'D00890 TRIFLUOPERAZINE'
             545 'D00896 MOLINDONE' 546 'D00897 LOXAPINE'
             547 'D00898 PIMOZIDE' 548 'D00900 METHYLPHENIDATE'
             549 'D00901 PEMOLINE' 550 'D00902 ERGOLOID MESYLATES'
             551 'D00907 HYDROXYZINE' 552 'D00909 CHLORMEZANONE'
             553 'D00910 ZOLPIDEM' 554 'D00911 PARALDEHYDE'
             555 'D00912 ACETYLCARBROMAL' 556 'D00915 ESTAZOLAM'
             557 'D00917 QUAZEPAM' 558 'D00919 MEPHOBARBITAL'
             559 'D00923 BUTABARBITAL' 560 'D00929 METHOHEXITAL'
             561 'D00931 ETOMIDATE' 562 'D00933 PROPOFOL'
             563 'D00934 NITROUS OXIDE' 564 'D00942 ETHOTOIN'
             565 'D00943 PHENSUXIMIDE' 566 'D00944 PARAMETHADIONE'
             567 'D00960 CARISOPRODOL' 568 'D00962 CHLORZOXAZONE'
             569 'D00963 CYCLOBENZAPRINE' 570 'D00964 METAXALONE'
             571 'D00965 METHOCARBAMOL' 572 'D00966 ORPHENADRINE'
             573 'D00967 BACLOFEN' 574 'D00968 DANTROLENE'
             575 'D00969 PROCYCLIDINE' 576 'D00970 TRIHEXYPHENIDYL'
             577 'D00972 BIPERIDEN' 578 'D00976 SELEGILINE'
             579 'D00977 PERGOLIDE' 580 'D00978 ALUMINUM HYDROXIDE'
             581 'D00980 DIHYDROXYALUMINUM SODIUM CARBONATE'
             582 'D00982 MAGNESIUM HYDROXIDE' 583 'D00984 MAGALDRATE'
             584 'D00985 HYOSCYAMINE' 585 'D00986 SCOPOLAMINE'
             586 'D00988 BELLADONNA' 587 'D00989 METHSCOPOLAMINE'
             588 'D00991 CLIDINIUM' 589 'D00992 GLYCOPYRROLATE'
             590 'D00999 DICYCLOMINE' 591 'D01002 PANCRELIPASE'
             592 'D01003 PANCREATIN' 593 'D01005 URSODIOL'
             594 'D01008 MAGNESIUM CITRATE' 595 'D01009 SODIUM BIPHOSPHATE'
             596 'D01010 CASCARA SAGRADA' 597 'D01012 PHENOLPHTHALEIN'
             598 'D01013 SENNA' 599 'D01014 CASTOR OIL'
             600 'D01015 BISACODYL' 601 'D01017 POLYCARBOPHIL'
             602 'D01018 PSYLLIUM' 603 'D01019 MINERAL OIL'
             604 'D01021 DOCUSATE'
             605 'D01023 POLYETHYLENE GLYCOL 3350 WITH ELECTROLYTES'
             606 'D01024 LACTULOSE' 607 'D01025 LOPERAMIDE'
             608 'D01026 BISMUTH SUBSALICYLATE' 609 'D01027 SIMETHICONE'
             610 'D01028 CHARCOAL' 611 'D01030 DEHYDROCHOLIC ACID'
             612 'D01031 MESALAMINE' 613 'D01032 OLSALAZINE'
             614 'D01068 DEMECLOCYCLINE' 615 'D01070 OXYTETRACYCLINE'
             616 'D01090 SULFAMETHIZOLE' 617 'D01097 RIFABUTIN'
             618 'D01100 ETHIONAMIDE' 619 'D01101 CYCLOSERINE'
             620 'D01104 PAROMOMYCIN' 621 'D01105 IODOQUINOL'
             622 'D01112 COLISTIN SULFATE OTIC' 623 'D01113 COLISTIMETHATE'
             624 'D01115 BACITRACIN' 625 'D01120 ATOVAQUONE'
             626 'D01121 CLOFAZIMINE' 627 'D01123 PYRANTEL'
             628 'D01124 PIPERAZINE' 629 'D01128 METHYLENE BLUE'
             630 'D01129 CINOXACIN' 631 'D01133 IMMUNE GLOBULIN INTRAVENOUS'
             632 'D01135 IMMUNE GLOBULIN INTRAMUSCULAR'
             633 'D01136 HEPATITIS B IMMUNE GLOBULIN'
             634 'D01138 VARICELLA ZOSTER IMMUNE GLOBULIN'
             635 'D01139 RHO (D) IMMUNE GLOBULIN'
             636 'D01141 LYMPHOCYTE IMMUNE GLOBULIN, ANTI-THY (OBS)'
             637 'D01142 DIPHTHERIA ANTITOXIN'
             638 'D01144 ANTIVENIN (CROTALIDAE) POLYVALENT'
             639 'D01146 ANTIVENIN (BLACK WIDOW SPIDER)'
             640 'D01147 RABIES VACCINE (OBSOLETE)'
             641 'D01148 RABIES IMMUNE GLOBULIN, HUMAN' 642 'D01150 BCG'
             643 'D01152 STAPHAGE LYSATE (SPL)'
             644 'D01153 MENINGOCOCCAL POLYSACCHARIDE VACCINE'
             645 'D01156 TYPHOID VACCINE, INACTIVATED'
             646 'D01158 HAEMOPHILUS B CONJUGATE VACCINE (OBSOLETE)'
             647 'D01159 MEASLES VIRUS VACCINE'
             648 'D01160 RUBELLA VIRUS VACCINE'
             649 'D01161 MUMPS VIRUS VACCINE'
             650 'D01162 POLIOVIRUS VACCINE, LIVE, TRIVALENT'
             651 'D01163 POLIOVIRUS VACCINE, INACTIVATED'
             652 'D01164 INFLUENZA VIRUS VACCINE, INACTIVATED'
             653 'D01165 YELLOW FEVER VACCINE'
             654 'D01166 HEPATITIS B VACCINE (OBSOLETE)'
             655 'D01168 TETANUS TOXOID'
             656 'D01171 TUBERCULIN PURIFIED PROTEIN DERIVATIVE'
             657 'D01184 DIPIVEFRIN OPHTHALMIC'
             658 'D01187 LEVOBUNOLOL OPHTHALMIC'
             659 'D01188 ACETYLCHOLINE OPHTHALMIC'
             660 'D01191 PILOCARPINE OPHTHALMIC'
             661 'D01195 ECHOTHIOPHATE IODIDE OPHTHALMIC'
             662 'D01199 HOMATROPINE OPHTHALMIC'
             663 'D01200 TROPICAMIDE OPHTHALMIC'
             664 'D01201 CYCLOPENTOLATE OPHTHALMIC'
             665 'D01204 SUPROFEN OPHTHALMIC'
             666 'D01208 SULFACETAMIDE SODIUM OPHTHALMIC'
             667 'D01210 YELLOW MERCURIC OXIDE OPHTHALMIC'
             668 'D01215 TRIFLURIDINE OPHTHALMIC' 669 'D01217 TETRACAINE'
             670 'D01218 PROPARACAINE OPHTHALMIC'
             671 'D01219 FLUORESCEIN OPHTHALMIC'
             672 'D01222 SODIUM HYALURONATE OPHTHALMIC'
             673 'D01225 BORIC ACID TOPICAL'
             674 'D01226 HYDROXYPROPYL METHYLCELLULOSE OPHTHALMIC'
             675 'D01227 BOTULINUM TOXIN TYPE A (OBSOLETE)'
             676 'D01231 CHLORHEXIDINE TOPICAL'
             677 'D01232 CARBAMIDE PEROXIDE TOPICAL' 678 'D01233 NYSTATIN'
             679 'D01234 BUTOCONAZOLE TOPICAL'
             680 'D01235 TIOCONAZOLE TOPICAL' 681 'D01236 CLOTRIMAZOLE'
             682 'D01238 TERCONAZOLE TOPICAL'
             683 'D01239 GENTIAN VIOLET TOPICAL'
             684 'D01240 SULFANILAMIDE TOPICAL'
             685 'D01241 CLINDAMYCIN TOPICAL'
             686 'D01242 NONOXYNOL 9 TOPICAL' 687 'D01243 OCTOXYNOL TOPICAL'
             688 'D01244 TRETINOIN TOPICAL' 689 'D01245 ISOTRETINOIN'
             690 'D01246 BENZOYL PEROXIDE TOPICAL'
             691 'D01254 ANTHRALIN TOPICAL'
             692 'D01257 NITROFURAZONE TOPICAL' 693 'D01258 MAFENIDE TOPICAL'
             694 'D01259 SILVER SULFADIAZINE TOPICAL'
             695 'D01263 PYRITHIONE ZINC TOPICAL'
             696 'D01265 SULFACETAMIDE SODIUM TOPICAL'
             697 'D01266 CHLOROXINE TOPICAL' 698 'D01267 MUPIROCIN TOPICAL'
             699 'D01271 ECONAZOLE TOPICAL' 700 'D01272 CICLOPIROX TOPICAL'
             701 'D01273 TRIACETIN TOPICAL' 702 'D01274 TOLNAFTATE TOPICAL'
             703 'D01275 SULCONAZOLE TOPICAL' 704 'D01277 NAFTIFINE TOPICAL'
             705 'D01278 LINDANE TOPICAL' 706 'D01279 PERMETHRIN TOPICAL'
             707 'D01280 CROTAMITON TOPICAL'
             708 'D01282 ALCLOMETASONE TOPICAL'
             709 'D01288 CLOBETASOL TOPICAL'
             710 'D01289 CLOCORTOLONE TOPICAL' 711 'D01290 DESONIDE TOPICAL'
             712 'D01291 DESOXIMETASONE TOPICAL'
             713 'D01292 DIFLORASONE TOPICAL'
             714 'D01293 FLUOCINOLONE TOPICAL'
             715 'D01294 FLUOCINONIDE TOPICAL'
             716 'D01295 FLURANDRENOLIDE TOPICAL' 717 'D01296 FLUTICASONE'
             718 'D01298 HALOBETASOL TOPICAL' 719 'D01300 MOMETASONE TOPICAL'
             720 'D01301 DIBUCAINE TOPICAL' 721 'D01302 BUTAMBEN TOPICAL'
             722 'D01303 PRAMOXINE TOPICAL' 723 'D01305 DYCLONINE TOPICAL'
             724 'D01306 COCAINE TOPICAL' 725 'D01307 SALICYLIC ACID TOPICAL'
             726 'D01308 PODOPHYLLUM RESIN TOPICAL'
             727 'D01309 PODOFILOX TOPICAL'
             728 'D01313 TRICHLOROACETIC ACID TOPICAL'
             729 'D01314 SUTILAINS TOPICAL' 730 'D01315 COLLAGENASE TOPICAL'
             731 'D01316 MASOPROCOL TOPICAL'
             732 'D01319 HYDROQUINONE TOPICAL'
             733 'D01320 FORMALDEHYDE TOPICAL' 734 'D01321 CAPSAICIN TOPICAL'
             735 'D01322 ALUMINUM CHLORIDE HEXAHYDRATE TOPICAL'
             736 'D01323 MONOBENZONE TOPICAL' 737 'D01325 ARNICA TOPICAL'
             738 'D01332 HEXACHLOROPHENE TOPICAL'
             739 'D01333 BENZALKONIUM CHLORIDE TOPICAL'
             740 'D01335 SODIUM HYPOCHLORITE TOPICAL'
             741 'D01338 PHYSIOLOGICAL IRRIGATING SOLUTION'
             742 'D01339 MECHLORETHAMINE' 743 'D01341 LOMUSTINE'
             744 'D01342 CARMUSTINE' 745 'D01344 FLOXURIDINE'
             746 'D01345 THIOGUANINE' 747 'D01346 FLUDARABINE'
             748 'D01348 MEGESTROL' 749 'D01351 ESTRAMUSTINE'
             750 'D01353 LEUPROLIDE' 751 'D01354 GOSERELIN'
             752 'D01356 PENTOSTATIN' 753 'D01361 PLICAMYCIN'
             754 'D01368 INTERFERON ALFA-2A' 755 'D01369 INTERFERON ALFA-2B'
             756 'D01372 ALTRETAMINE' 757 'D01373 HYDROXYUREA'
             758 'D01375 ALDESLEUKIN' 759 'D01376 PACLITAXEL'
             760 'D01378 MITOTANE' 761 'D01379 ASPARAGINASE ESCHERICHIA COLI'
             762 'D01382 ETHANOLAMINE OLEATE'
             763 'D01383 SODIUM TETRADECYL SULFATE'
             764 'D01384 MORRHUATE SODIUM' 765 'D01385 BETA-CAROTENE'
             766 'D01386 YOHIMBINE' 767 'D01387 ALPROSTADIL'
             768 'D01389 DISULFIRAM' 769 'D01393 HYALURONIDASE'
             770 'D01394 PROCAINE' 771 'D01395 CHLOROPROCAINE'
             772 'D01396 PRILOCAINE' 773 'D01398 MEPIVACAINE'
             774 'D01402 DEFEROXAMINE' 775 'D01404 SODIUM THIOSULFATE'
             776 'D01406 NALTREXONE' 777 'D01407 FLUMAZENIL'
             778 'D01409 PRALIDOXIME' 779 'D01410 DIGOXIN IMMUNE FAB'
             780 'D01411 MESNA' 781 'D01413 IPECAC' 782 'D01416 TRIENTINE'
             783 'D01417 SUCCIMER' 784 'D01420 AMBENONIUM'
             785 'D01422 GUANIDINE' 786 'D01423 POTASSIUM CITRATE'
             787 'D01424 POTASSIUM ACID PHOSPHATE' 788 'D01425 FLAVOXATE'
             789 'D01427 BETHANECHOL' 790 'D01431 DIMETHYL SULFOXIDE'
             791 'D01433 ACETOHYDROXAMIC ACID' 792 'D01434 METHOXSALEN'
             793 'D01438 IOPANOIC ACID' 794 'D01445 BARIUM SULFATE'
             795 'D01451 GADOPENTETATE DIMEGLUMINE' 796 'D01452 IODAMIDE'
             797 'D01456 IOHEXOL' 798 'D01461 IOPAMIDOL'
             799 'D01469 IOVERSOL' 800 'D01472 METRIZAMIDE'
             801 'D01473 DIATRIZOATE' 802 'D01475 IOTHALAMATE'
             803 'D01476 ETHIODIZED OIL' 804 'D01482 ISOSULFAN BLUE'
             805 'D02373 PHOSPHORATED CARBOHYDRATE SOLUTION'
             806 'D02374 DESFLURANE' 807 'D02375 PLASMA PROTEIN FRACTION'
             808 'D02376 ALBUMIN HUMAN' 809 'D02378 HETASTARCH'
             810 'D02381 POTASSIUM PERCHLORATE' 811 'D03001 CLADRIBINE'
             812 'D03003 DIPHTHERIA-TETANUS TOXOIDS (OBSOLETE)'
             813 'D03004 DIPHTHERIA/PERTUSSIS, WHOLE CELL/TETANUS'
             814 'D03006 MEASLES-RUBELLA VIRUS VACCINE'
             815 'D03007 MEASLES/MUMPS/RUBELLA VIRUS VACCINE'
             816 'D03008 INTERFERON GAMMA-1B' 817 'D03034 NORGESTREL'
             818 'D03041 ENOXAPARIN' 819 'D03050 LORATADINE'
             820 'D03051 INTERFERON BETA-1B'
             821 'D03052 HYDROCHLOROTHIAZIDE-TRIAMTERENE'
             822 'D03054 AMYLASE' 823 'D03056 ATTAPULGITE'
             824 'D03058 BENZOIC ACID' 825 'D03061 BUTALBITAL'
             826 'D03062 CASANTHRANOL' 827 'D03066 CITRIC ACID'
             828 'D03068 DICHLORALPHENAZONE' 829 'D03075 HYDROCODONE'
             830 'D03077 ISOMETHEPTENE MUCATE' 831 'D03085 PEPSIN'
             832 'D03086 PHENIRAMINE' 833 'D03089 PHENYLTOLOXAMINE'
             834 'D03094 SALICYLAMIDE' 835 'D03096 SODIUM BENZOATE'
             836 'D03097 SODIUM BORATE TOPICAL' 837 'D03098 SODIUM CITRATE'
             838 'D03109 JAPANESE ENCEPHALITIS VIRUS VACCINE NAKAYAMA'
             839 'D03110 DIPHTH/PERTUSSIS, ACEL/TETANUS (OBSOLETE)'
             840 'D03112 NEDOCROMIL'
             841 'D03113 DEXTRAN, LOW MOLECULAR WEIGHT'
             842 'D03114 DEXTRAN, HIGH MOLECULAR WEIGHT'
             843 'D03116 BISMUTH SUBGALLATE' 844 'D03118 MUROMONAB-CD3'
             845 'D03125 DIHYDROTACHYSTEROL' 846 'D03126 CALCITRIOL'
             847 'D03128 ERGOCALCIFEROL' 848 'D03129 CHOLECALCIFEROL'
             849 'D03130 THIAMINE' 850 'D03133 HYDROXOCOBALAMIN'
             851 'D03135 PHYTONADIONE' 852 'D03136 VITAMIN A & D TOPICAL'
             853 'D03137 CALCIUM-VITAMIN D' 854 'D03140 MULTIVITAMIN'
             855 'D03141 MULTIVITAMIN WITH IRON'
             856 'D03143 MULTIVITAMIN WITH FLUORIDE'
             857 'D03145 MULTIVITAMIN WITH MINERALS'
             858 'D03148 MULTIVITAMIN, PRENATAL' 859 'D03152 TRIFLUPROMAZINE'
             860 'D03154 DOXYLAMINE' 861 'D03157 PAROXETINE'
             862 'D03158 RIMANTADINE' 863 'D03159 CHOLINE'
             864 'D03160 SUMATRIPTAN' 865 'D03162 ALCOHOL (ETHANOL)'
             866 'D03165 PIPERACILLIN-TAZOBACTAM' 867 'D03166 CISAPRIDE'
             868 'D03168 DIHYDROCODEINE' 869 'D03169 TRIMETREXATE'
             870 'D03170 FELBAMATE' 871 'D03171 GRANISETRON'
             872 'D03173 DORNASE ALFA' 873 'D03176 TACRINE'
             874 'D03180 RISPERIDONE' 875 'D03181 VENLAFAXINE'
             876 'D03182 GABAPENTIN' 877 'D03183 FLUVASTATIN'
             878 'D03187 LEVOMETHADYL ACETATE' 879 'D03189 TORSEMIDE'
             880 'D03190 OXICONAZOLE TOPICAL'
             881 'D03191 TERBINAFINE TOPICAL' 882 'D03192 ZINC OXIDE TOPICAL'
             883 'D03193 AMILORIDE-HYDROCHLOROTHIAZIDE'
             884 'D03195 MICONAZOLE TOPICAL' 885 'D03196 GENTAMICIN TOPICAL'
             886 'D03197 BETAMETHASONE TOPICAL'
             887 'D03200 ERYTHROMYCIN TOPICAL' 888 'D03201 ACYCLOVIR TOPICAL'
             889 'D03202 KETOCONAZOLE TOPICAL' 890 'D03203 MINOXIDIL TOPICAL'
             891 'D03204 FLUOROURACIL TOPICAL'
             892 'D03205 HYDROCORTISONE TOPICAL'
             893 'D03206 TRIAMCINOLONE TOPICAL'
             894 'D03207 AMPHOTERICIN B TOPICAL'
             895 'D03208 METRONIDAZOLE TOPICAL'
             896 'D03210 SELENIUM SULFIDE TOPICAL'
             897 'D03211 CIPROFLOXACIN OPHTHALMIC'
             898 'D03212 ATROPINE OPHTHALMIC'
             899 'D03213 DICLOFENAC OPHTHALMIC'
             900 'D03214 KETOROLAC OPHTHALMIC'
             901 'D03221 PREDNISOLONE OPHTHALMIC'
             902 'D03222 TOBRAMYCIN OPHTHALMIC' 903 'D03224 NEOMYCIN TOPICAL'
             904 'D03226 SALIVA SUBSTITUTES'
             905 'D03227 FLUOROMETHOLONE OPHTHALMIC'
             906 'D03228 LODOXAMIDE OPHTHALMIC'
             907 'D03229 LEVOCABASTINE OPHTHALMIC'
             908 'D03231 TRIPLE SULFA TOPICAL'
             909 'D03232 VITAMINS A, D, AND E TOPICAL'
             910 'D03233 VITAMIN E TOPICAL'
             911 'D03238 ETHINYL ESTRADIOL-NORETHINDRONE'
             912 'D03240 MESTRANOL-NORETHINDRONE'
             913 'D03241 ETHINYL ESTRADIOL-NORGESTREL'
             914 'D03242 ETHINYL ESTRADIOL-LEVONORGESTREL'
             915 'D03245 ESTERIFIED ESTROGENS-METHYLTESTOSTERONE'
             916 'D03247 HYDROCHLOROTHIAZIDE-SPIRONOLACTONE'
             917 'D03251 HYDROCHLOROTHIAZIDE-RESERPINE'
             918 'D03255 BENDROFLUMETHIAZIDE-RAUWOLFIA SERPENTINA'
             919 'D03256 HYDRALAZINE/HYDROCHLOROTHIAZIDE/RESERPINE'
             920 'D03257 HYDRALAZINE-HYDROCHLOROTHIAZIDE'
             921 'D03258 ATENOLOL-CHLORTHALIDONE'
             922 'D03259 BENDROFLUMETHIAZIDE-NADOLOL'
             923 'D03260 HYDROCHLOROTHIAZIDE-TIMOLOL'
             924 'D03261 HYDROCHLOROTHIAZIDE-PROPRANOLOL'
             925 'D03263 HYDROCHLOROTHIAZIDE-METHYLDOPA'
             926 'D03264 HYDROCHLOROTHIAZIDE-METOPROLOL'
             927 'D03265 BENAZEPRIL-HYDROCHLOROTHIAZIDE'
             928 'D03266 HYDROCHLOROTHIAZIDE-LISINOPRIL'
             929 'D03267 CHLORTHALIDONE-CLONIDINE'
             930 'D03271 PHENIRAMINE-PHENYLEPHRINE NASAL'
             931 'D03273 GUAIFENESIN-THEOPHYLLINE'
             932 'D03274 AMINOPHYLLINE-GUAIFENESIN'
             933 'D03276 DYPHYLLINE-GUAIFENESIN'
             934 'D03277 POTASSIUM IODIDE-THEOPHYLLINE'
             935 'D03280 EPHEDRINE/PHENOBARBITAL/THEOPHYLLINE'
             936 'D03283 EPHEDRINE/HYDROXYZINE/THEOPHYLLINE'
             937 'D03289 ACETAMINOPHEN-PSEUDOEPHEDRINE'
             938 'D03292 IBUPROFEN-PSEUDOEPHEDRINE' 939 'D03293 APAP/ASA/PPA'
             940 'D03296 ACETAMINOPHEN-CHLORPHENIRAMINE'
             941 'D03297 ACETAMINOPHEN-PHENYLTOLOXAMINE'
             942 'D03298 CHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             943 'D03299 CHLORPHENIRAMINE-PHENYLPROPANOLAMINE'
             944 'D03300 CHLORPHENIRAMINE-PHENYLEPHRINE'
             945 'D03301 BROMPHENIRAMINE-PSEUDOEPHEDRINE'
             946 'D03302 BROMPHENIRAMINE-PHENYLPROPANOLAMINE'
             947 'D03303 CLEMASTINE-PHENYLPROPANOLAMINE'
             948 'D03306 CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             949 'D03307 CHLORPHENIRAMINE/PHENINDAMINE/PPA'
             950 'D03308 PHENIRAMINE/PPA/PHENYLTOLOXAMINE/PYRILAMINE'
             951 'D03310 CHLORPHENIRAMINE/PE/PPA/PHENYLTOLOXAMINE'
             952 'D03311 BROMPHENIRAMINE-PHENYLEPHRINE'
             953 'D03312 DIPHENHYDRAMINE-PSEUDOEPHEDRINE'
             954 'D03313 CHLORPHENIRAMINE/PHENYLEPHRINE/PYRILAMINE'
             955 'D03316 PSEUDOEPHEDRINE-TRIPROLIDINE'
             956 'D03317 PHENYLEPHRINE-PROMETHAZINE'
             957 'D03318 PHENIRAMINE/PPA/PYRILAMINE'
             958 'D03319 APAP/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             959 'D03320 APAP/CHLORPHENIRAMINE/PSEUDOEPHEDRINE'
             960 'D03321 APAP/BROMPHENIRAMINE/PSEUDOEPHEDRINE'
             961 'D03322 ASA/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             962 'D03329 ASA/DIPHENHYDRAMINE/PPA'
             963 'D03330 APAP/PSEUDOEPHEDRINE/TRIPROLIDINE'
             964 'D03331 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE'
             965 'D03336 APAP/CPM/PHENYLEPHRINE/PPA/PYRILAMINE'
             966 'D03338 CHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             967 'D03340 HOMATROPINE-HYDROCODONE'
             968 'D03341 CODEINE-PSEUDOEPHEDRINE'
             969 'D03342 APAP/DEXTROMETHORPHAN/PSEUDOEPHEDRINE'
             970 'D03347 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             971 'D03349 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PSE'
             972 'D03351 ASA/BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             973 'D03352 HYDROCODONE-PSEUDOEPHEDRINE'
             974 'D03353 HYDROCODONE-PHENYLPROPANOLAMINE'
             975 'D03354 DEXTROMETHORPHAN-PSEUDOEPHEDRINE'
             976 'D03355 DEXTROMETHORPHAN-PHENYLPROPANOLAMINE'
             977 'D03356 CHLORPHENIRAMINE-HYDROCODONE'
             978 'D03357 CODEINE-PROMETHAZINE'
             979 'D03359 CHLORPHENIRAMINE-DEXTROMETHORPHAN'
             980 'D03360 DEXTROMETHORPHAN-PROMETHAZINE'
             981 'D03361 CHLORPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             982 'D03362 CHLORPHENIRAMINE/CODEINE/PSEUDOEPHEDRINE'
             983 'D03364 CODEINE/PHENYLEPHRINE/PROMETHAZINE'
             984 'D03366 HYDROCODONE/PHENYLEPHRINE/PYRILAMINE'
             985 'D03368 BROMPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             986 'D03369 CHLORPHENIRAMINE/DEXTROMETHORP/PHENYLEPHRINE'
             987 'D03370 CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             988 'D03371 DEXTROMETHORPHAN/PHENYLEPHRINE/PYRILAMINE'
             989 'D03372 BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             990 'D03378 ACETAMINOPHEN-DEXTROMETHORPHAN'
             991 'D03379 GUAIFENESIN-PSEUDOEPHEDRINE'
             992 'D03380 EPHEDRINE-GUAIFENESIN'
             993 'D03381 GUAIFENESIN-PHENYLEPHRINE'
             994 'D03382 GUAIFENESIN-PHENYLPROPANOLAMINE'
             995 'D03383 GUAIFENESIN/PHENYLEPHRINE/PPA'
             996 'D03388 ETHINYL ESTRADIOL-ETHYNODIOL'
             997 'D03389 ESTRADIOL-TESTOSTERONE'
             998 'D03392 CHLORPHENIRAMINE/GUAIFENESIN/PHENYLEPHRINE'
             999 'D03393 CODEINE-GUAIFENESIN'
             1000 'D03396 GUAIFENESIN-HYDROCODONE'
             1001 'D03397 GUAIFENESIN-HYDROMORPHONE'
             1002 'D03398 CODEINE/GUAIFENESIN/PSE'
             1003 'D03400 DEXTROMETHORPHAN-GUAIFENESIN'
             1004 'D03403 GUAIFENESIN/HYDROCODONE/PHENYLEPHRINE'
             1005 'D03404 GUAIFENESIN/HYDROCODONE/PSEUDOEPHEDRINE'
             1006 'D03407 CODEINE/GUAIFENESIN/PHENYLPROPANOLAMINE'
             1007 'D03408 DEXTROMETHORPHAN/GUAIFENESIN/PHENYLEPHRINE'
             1008 'D03409 DEXTROMETHORPHAN/GUAIFENESIN/PSEUDOEPHEDRINE'
             1009 'D03411 DEXTROMETHORPHAN/GUAIFENESIN/PPA'
             1010 'D03416 CHLORPHENIRAMINE/HYDROCODONE/PSE'
             1011 'D03419 CHLORPHENIRAMINE/DM/GUAIFENESIN/PHENYLEPHRINE'
             1012 'D03423 ACETAMINOPHEN-CODEINE'
             1013 'D03424 ASPIRIN-CODEINE'
             1014 'D03425 APAP/BUTALBITAL/CAFFEINE/CODEINE'
             1015 'D03426 ASA/BUTALBITAL/CAFFEINE/CODEINE'
             1016 'D03428 ACETAMINOPHEN-HYDROCODONE'
             1017 'D03430 ASA/CAFFEINE/DIHYDROCODEINE'
             1018 'D03431 ACETAMINOPHEN-OXYCODONE'
             1019 'D03432 ASPIRIN-OXYCODONE'
             1020 'D03433 MEPERIDINE-PROMETHAZINE'
             1021 'D03434 ACETAMINOPHEN-PROPOXYPHENE'
             1022 'D03435 ASA/CAFFEINE/PROPOXYPHENE'
             1023 'D03436 BELLADONNA-OPIUM'
             1024 'D03437 APAP/ASA/CAFFEINE/SALICYLAMIDE'
             1025 'D03439 APAP/ASA/CAFFEINE'
             1026 'D03443 APAP/AL HYDROXIDE/ASA/CAFFEINE/MG HYDROXIDE'
             1027 'D03445 ACETAMINOPHEN-DIPHENHYDRAMINE'
             1028 'D03447 ASA/CAFFEINE/SALICYLAMIDE'
             1029 'D03448 ASPIRIN-MEPROBAMATE' 1030 'D03449 ASPIRIN-CAFFEINE'
             1031 'D03453 ASPIRIN-PHENYLTOLOXAMINE'
             1032 'D03454 MAGNESIUM SALICYLATE-PHENYLTOLOXAMINE'
             1033 'D03455 APAP/BUTALBITAL/CAFFEINE'
             1034 'D03456 ACETAMINOPHEN-BUTALBITAL'
             1035 'D03457 ASA/BUTALBITAL/CAFFEINE'
             1036 'D03459 APAP/DICHLORALPHENAZONE/ISOMETHEPTENE'
             1037 'D03462 AMITRIPTYLINE-CHLORDIAZEPOXIDE'
             1038 'D03463 AMITRIPTYLINE-PERPHENAZINE'
             1039 'D03464 DROPERIDOL-FENTANYL'
             1040 'D03468 ASPIRIN-METHOCARBAMOL'
             1041 'D03469 ASPIRIN-CARISOPRODOL'
             1042 'D03470 ASA/CARISOPRODOL/CODEINE'
             1043 'D03472 ASA/CAFFEINE/ORPHENADRINE'
             1044 'D03473 CARBIDOPA-LEVODOPA'
             1045 'D03474 ALUMINUM HYDROXIDE-MAGNESIUM HYDROXIDE'
             1046 'D03478 AL HYDROXIDE/MG HYDROXIDE/SIMETHICONE'
             1047 'D03480 CA CARBONATE/MG HYDROXIDE/SIMETHICONE'
             1048 'D03485 ATROPINE/HYOSCYAMINE/PB/SCOPOLAMINE'
             1049 'D03486 BELLADONNA-BUTABARBITAL'
             1050 'D03492 CHLORDIAZEPOXIDE-CLIDINIUM'
             1051 'D03495 BELLADONNA/ERGOTAMINE/PHENOBARBITAL'
             1052 'D03496 DOCUSATE-SENNA'
             1053 'D03497 DOCUSATE-PHENOLPHTHALEIN'
             1054 'D03498 CASANTHRANOL-DOCUSATE'
             1055 'D03505 ATROPINE-DIFENOXIN'
             1056 'D03506 ATROPINE-DIPHENOXYLATE'
             1057 'D03508 ISONIAZID-RIFAMPIN'
             1058 'D03509 ERYTHROMYCIN-SULFISOXAZOLE'
             1059 'D03511 PHENAZOPYRIDINE-SULFAMETHOXAZOLE'
             1060 'D03513 METHENAMINE-SODIUM ACID PHOSPHATE'
             1061 'D03517 BENZOIC ACID/METHENAMINE/SODIUM SALICYLATE'
             1062 'D03520 NAPHAZOLINE-PHENIRAMINE OPHTHALMIC'
             1063 'D03521 CYCLOPENTOLATE-PHENYLEPHRINE OPHTHALMIC'
             1064 'D03523 HYDROXYAMPHETAMINE-TROPICAMIDE OPHTHALMIC'
             1065 'D03524 BACITRACIN/NEOMYCIN/POLYMYXIN B TOPICAL'
             1066 'D03525 GRAMICIDIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1067 'D03526 NEOMYCIN-POLYMYXIN B SULFATE TOPICAL'
             1068 'D03527 BACITRACIN-POLYMYXIN B TOPICAL'
             1069 'D03529 POLYMYXIN B-TRIMETHOPRIM OPHTHALMIC'
             1070 'D03533 NEOMYCIN/POLYMYXIN B/PREDNISOLONE OPHTHALMIC'
             1071 'D03536 DEXAMETHASONE-TOBRAMYCIN OPHTHALMIC'
             1072 'D03537 DEXAMETHASONE/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1073 'D03541 PREDNISOLONE-SULFACETAMIDE SODIUM OPHTHALMIC'
             1074 'D03542 FLUORESCEIN-PROPARACAINE OPHTHALMIC'
             1075 'D03543 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OTIC'
             1076 'D03544 HYDROCORTISONE-POLYMYXIN B OTIC'
             1077 'D03546 HYDROCORTISONE-PRAMOXINE TOPICAL'
             1078 'D03552 CLIOQUINOL-HYDROCORTISONE TOPICAL'
             1079 'D03553 CLIOQUINOL/HYDROCORTISONE/PRAMOXINE TOPICAL'
             1080 'D03561 BETAMETHASONE-CLOTRIMAZOLE TOPICAL'
             1081 'D03562 NYSTATIN-TRIAMCINOLONE TOPICAL'
             1082 'D03566 CAPTOPRIL-HYDROCHLOROTHIAZIDE'
             1083 'D03569 CARBINOXAMINE'
             1084 'D03570 CARBINOXAMINE-PSEUDOEPHEDRINE'
             1085 'D03572 CARAMIPHEN-PHENYLPROPANOLAMINE'
             1086 'D03576 BROMODIPHENHYDRAMINE-CODEINE'
             1087 'D03577 CARBINOXAMINE/DEXTROMETHORPHAN/PSE'
             1088 'D03584 CODEINE/PHENIRAMINE/PHENYLEPHRINE/NA CITRATE'
             1089 'D03585 PAMABROM' 1090 'D03586 APAP/PAMABROM/PYRILAMINE'
             1091 'D03588 MAGNESIUM CARBONATE'
             1092 'D03591 ALGINIC ACID/AL HYDROXIDE/MG CARBONATE'
             1093 'D03596 ALGINIC ACID/AL HYDROXIDE/MG TRISILICATE'
             1094 'D03600 POTASSIUM BICARBONATE' 1095 'D03613 PSYLLIUM-SENNA'
             1096 'D03618 HYOSCYAMINE/METHENAM/M-BLUE/PHENYL SALICYL'
             1097 'D03620 ANTAZOLINE-NAPHAZOLINE OPHTHALMIC'
             1098 'D03622 BENOXINATE-FLUORESCEIN OPHTHALMIC'
             1099 'D03623 ACETIC ACID TOPICAL' 1100 'D03624 ANTIPYRINE OTIC'
             1101 'D03625 ACETIC ACID-HYDROCORTISONE OTIC'
             1102 'D03627 ANTIPYRINE-BENZOCAINE OTIC'
             1103 'D03628 ANTIPYRINE/BENZOCAINE/PHENYLEPHRINE OTIC'
             1104 'D03630 ANHYDROUS CALCIUM IODIDE-CODEINE'
             1105 'D03632 CETYLPYRIDINIUM TOPICAL'
             1106 'D03634 BENZOCAINE-CETYLPYRIDINIUM TOPICAL'
             1107 'D03640 BUDESONIDE NASAL' 1108 'D03641 PETROLATUM TOPICAL'
             1109 'D03644 LACTOBACILLUS ACIDOPHILUS'
             1110 'D03646 LACTOBACILLUS ACIDOPHILUS AND BULGARICUS'
             1111 'D03647 ISOPROPYL ALCOHOL TOPICAL'
             1112 'D03648 OPHTHALMIC IRRIGATION, INTRAOCULAR'
             1113 'D03649 BENZOIN TOPICAL'
             1114 'D03650 CANDIDA ALBICANS EXTRACT'
             1115 'D03651 CHOLINE SALICYLATE-MAGNESIUM SALICYLATE'
             1116 'D03652 COLCHICINE-PROBENECID'
             1117 'D03653 CALAMINE TOPICAL'
             1118 'D03655 LIDOCAINE-PRILOCAINE TOPICAL'
             1119 'D03656 ETHYL CHLORIDE TOPICAL'
             1120 'D03659 FIBRINOLYSIN AND DESOXYRIBONUCLEASE TOPICAL'
             1121 'D03660 MULTIVITAMIN WITH IRON AND FLUORIDE'
             1122 'D03661 DOCUSATE-FERROUS FUMARATE' 1123 'D03663 LECITHIN'
             1124 'D03664 PHENOL TOPICAL' 1125 'D03665 MENTHOL TOPICAL'
             1126 'D03666 MENTHOL-PHENOL TOPICAL' 1127 'D03667 METHACHOLINE'
             1128 'D03668 METHYL SALICYLATE TOPICAL' 1129 'D03674 PECTIN'
             1130 'D03676 NALOXONE-PENTAZOCINE'
             1131 'D03678 NAPHAZOLINE-ZINC OPHTHALMIC'
             1132 'D03680 ASA/CITRIC ACID/NA BICARB'
             1133 'D03681 OPHTHALMIC IRRIGATION, EXTRAOCULAR'
             1134 'D03682 ACETAMINOPHEN-PENTAZOCINE'
             1135 'D03684 THROMBIN TOPICAL'
             1136 'D03686 UNDECYLENIC ACID TOPICAL'
             1137 'D03687 ALUMINUM ACETATE TOPICAL'
             1138 'D03688 ALUMINUM SULFATE TOPICAL'
             1139 'D03689 CALCIUM ACETATE'
             1140 'D03690 ALUMINUM SULFATE-CALCIUM ACETATE TOPICAL'
             1141 'D03691 BENZOCAINE/PHENOL/POVIDONE IODINE TOPICAL'
             1142 'D03693 ICHTHAMMOL TOPICAL'
             1143 'D03694 MEDRYSONE OPHTHALMIC'
             1144 'D03695 PRAMOXINE-ZINC OXIDE TOPICAL'
             1145 'D03696 BENZYL BENZOATE TOPICAL'
             1146 'D03701 CORN STARCH TOPICAL' 1147 'D03702 SULFUR TOPICAL'
             1148 'D03703 COAL TAR TOPICAL'
             1149 'D03705 SALICYLIC ACID-SULFUR TOPICAL'
             1150 'D03707 ALOE VERA TOPICAL'
             1151 'D03708 LANOLIN-MINERAL OIL TOPICAL'
             1152 'D03710 ALLANTOIN/CAMPHOR/PHENOL TOPICAL'
             1153 'D03712 CAMPHOR TOPICAL'
             1154 'D03713 CAMPHOR-PHENOL TOPICAL'
             1155 'D03716 CITRIC ACID/GLUCONODELTA-LACTONE/MG CARBONATE'
             1156 'D03721 SODIUM IODIDE'
             1157 'D03724 FAT EMULSION, INTRAVENOUS'
             1158 'D03725 INTRAVENOUS ELECTROLYTE SOLUTION'
             1159 'D03735 TRIETHANOLAMINE POLYPEPTIDE OLEATE OTIC'
             1160 'D03738 TETRACYCLINE TOPICAL' 1161 'D03739 NIACINAMIDE'
             1162 'D03740 ENALAPRIL-HYDROCHLOROTHIAZIDE'
             1163 'D03743 PYRIMETHAMINE-SULFADOXINE'
             1164 'D03744 BISOPROLOL-HYDROCHLOROTHIAZIDE'
             1165 'D03750 DEXBROMPHENIRAMINE'
             1166 'D03751 DEXBROMPHENIRAMINE-PSEUDOEPHEDRINE'
             1167 'D03752 TACROLIMUS'
             1168 'D03754 ACRIVASTINE-PSEUDOEPHEDRINE'
             1169 'D03756 BACITRACIN TOPICAL' 1170 'D03759 SALMETEROL'
             1171 'D03760 DIPHENHYDRAMINE TOPICAL'
             1172 'D03761 LANOLIN TOPICAL' 1173 'D03762 WITCH HAZEL TOPICAL'
             1174 'D03763 GLYCERIN-PHENOL TOPICAL'
             1175 'D03764 GLYCERIN-WITCH HAZEL TOPICAL'
             1176 'D03766 ROCURONIUM' 1177 'D03767 IRON DEXTRAN'
             1178 'D03768 OCULAR LUBRICANT' 1179 'D03770 EMOLLIENTS, TOPICAL'
             1180 'D03773 STAVUDINE' 1181 'D03774 DOXEPIN TOPICAL'
             1182 'D03775 FAMCICLOVIR' 1183 'D03777 POTASSIUM ACETATE'
             1184 'D03780 DESOGESTREL'
             1185 'D03781 ETHINYL ESTRADIOL-NORGESTIMATE'
             1186 'D03782 DESOGESTREL-ETHINYL ESTRADIOL'
             1187 'D03783 BUPIVACAINE-EPINEPHRINE'
             1188 'D03784 EPINEPHRINE-LIDOCAINE'
             1189 'D03788 CALCIPOTRIENE TOPICAL'
             1190 'D03789 POTASSIUM GLUCONATE'
             1191 'D03790 POTASSIUM PHOSPHATE'
             1192 'D03796 MAGNESIUM CHLORIDE' 1193 'D03797 MAGNESIUM OXIDE'
             1194 'D03798 MAGNESIUM GLUCONATE' 1195 'D03799 CALCIUM CHLORIDE'
             1196 'D03800 CALCIUM GLUCONATE' 1197 'D03802 CALCIUM LACTATE'
             1198 'D03803 CALCIUM PHOSPHATE, TRIBASIC'
             1199 'D03804 FLUVOXAMINE' 1200 'D03805 DORZOLAMIDE OPHTHALMIC'
             1201 'D03806 ALBENDAZOLE' 1202 'D03807 METFORMIN'
             1203 'D03808 NEFAZODONE' 1204 'D03809 LAMOTRIGINE'
             1205 'D03810 VINORELBINE' 1206 'D03811 ABCIXIMAB'
             1207 'D03812 DALTEPARIN'
             1208 'D03818 LORATADINE-PSEUDOEPHEDRINE'
             1209 'D03819 CONJUGATED ESTROGENS-MEDROXYPROGESTERONE'
             1210 'D03821 LOSARTAN' 1211 'D03822 FERROUS GLUCONATE'
             1212 'D03823 IRON POLYSACCHARIDE' 1213 'D03824 FERROUS SULFATE'
             1214 'D03825 NISOLDIPINE' 1215 'D03826 TRAMADOL'
             1216 'D03827 CETIRIZINE' 1217 'D03828 LANSOPRAZOLE'
             1218 'D03829 AMLODIPINE-BENAZEPRIL'
             1219 'D03830 HYDROCHLOROTHIAZIDE-LOSARTAN'
             1220 'D03831 NILUTAMIDE' 1221 'D03832 VARICELLA VIRUS VACCINE'
             1222 'D03833 DIVALPROEX SODIUM' 1223 'D03834 NALMEFENE'
             1224 'D03835 MOEXIPRIL' 1225 'D03836 ACITRETIN'
             1226 'D03838 VALACYCLOVIR' 1227 'D03839 MYCOPHENOLATE MOFETIL'
             1228 'D03840 IOPROMIDE' 1229 'D03841 DEXRAZOXANE'
             1230 'D03842 EPOPROSTENOL' 1231 'D03843 GADOTERIDOL'
             1232 'D03844 DIRITHROMYCIN' 1233 'D03845 SEVOFLURANE'
             1234 'D03846 ACARBOSE' 1235 'D03847 CARVEDILOL'
             1236 'D03848 AZELAIC ACID TOPICAL' 1237 'D03849 ALENDRONATE'
             1238 'D03850 BICALUTAMIDE'
             1239 'D03857 BENZOYL PEROXIDE-ERYTHROMYCIN TOPICAL'
             1240 'D03858 LAMIVUDINE' 1241 'D03860 SAQUINAVIR'
             1242 'D03862 MAGNESIUM AMINO ACIDS CHELATE'
             1243 'D03863 TRETINOIN' 1244 'D03864 GLIMEPIRIDE'
             1245 'D03866 CALCIUM CITRATE'
             1246 'D03867 CALCIUM CARBONATE-SODIUM FLUORIDE'
             1247 'D03868 AMIFOSTINE' 1248 'D03869 RILUZOLE'
             1249 'D03870 AMPHOTERICIN B LIPID COMPLEX'
             1250 'D03872 PORFIMER' 1251 'D03873 ANASTROZOLE'
             1252 'D03874 CEFTIBUTEN' 1253 'D03877 HEROIN'
             1254 'D03878 COCAINE' 1255 'D03879 MARIJUANA'
             1256 'D03880 PHENCYCLIDINE'
             1257 'D03881 RESPIRATORY SYNCYTIAL VIRUS IMMUNE GLOBULIN'
             1258 'D03882 CEFEPIME'
             1259 'D03883 AL HYDROXIDE/ASA/CA CARBONATE/MG HYDROXIDE'
             1260 'D03884 TROLAMINE SALICYLATE TOPICAL'
             1261 'D03888 BENZOCAINE/BUTAMBEN/TETRACAINE TOPICAL'
             1262 'D03892 HISTAMINE PHOSPHATE' 1263 'D03894 KAOLIN-PECTIN'
             1264 'D03895 SINCALIDE' 1265 'D03897 LACTASE'
             1266 'D03898 SODIUM CHLORIDE, HYPERTONIC, OPHTHALMIC'
             1267 'D03904 BALSAM PERU/CASTOR OIL/TRYPSIN TOPICAL'
             1268 'D03905 ISOPROTERENOL-PHENYLEPHRINE'
             1269 'D03906 PHENIRAMINE/PHENYLTOLOXAMINE/PYRILAMINE'
             1270 'D03908 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             1271 'D03911 CHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1272 'D03913 APAP/DEXTROMETHORPHAN/PSE/PYRILAMINE'
             1273 'D03915 HYDROCODONE-POTASSIUM GUAIACOLSULFONATE'
             1274 'D03920 FERROUS FUMARATE'
             1275 'D03922 ACETAMINOPHEN-CAFFEINE'
             1276 'D03923 ACETAMINOPHEN-PHENYLEPHRINE'
             1277 'D03926 APAP/CAFFEINE/PYRILAMINE'
             1278 'D03927 BACITRACIN OPHTHALMIC'
             1279 'D03929 AMINOPHYLLINE/AMOBARBITAL/EPHEDRINE'
             1280 'D03946 ASCORBIC ACID-FERROUS FUMARATE'
             1281 'D03951 CITRIC ACID/K CITRATE/NA CITRATE'
             1282 'D03952 CITRIC ACID-SODIUM CITRATE'
             1283 'D03953 ELECTROLYTE REPLACEMENT SOLUTIONS, ORAL'
             1284 'D03954 FERROUS FUMARATE-FOLIC ACID'
             1285 'D03957 CALCIUM/FERROUS FUMARATE/VITAMIN D'
             1286 'D03962 POTASSIUM BICARBONATE-POTASSIUM CITRATE'
             1287 'D03963 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1288 'D03964 BACITRACIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1289 'D03965 BACITRACIN-POLYMYXIN B OPHTHALMIC'
             1290 'D03966 BENZOYL PEROXIDE-SULFUR TOPICAL'
             1291 'D03968 DEXAMETHASONE OPHTHALMIC'
             1292 'D03971 EPINEPHRINE OPHTHALMIC'
             1293 'D03973 ERYTHROMYCIN OPHTHALMIC'
             1294 'D03974 GENTAMICIN OPHTHALMIC'
             1295 'D03975 GLYCERIN OPHTHALMIC'
             1296 'D03976 HYDROCORTISONE OTIC'
             1297 'D03977 OFLOXACIN OPHTHALMIC'
             1298 'D03978 OXYMETAZOLINE OPHTHALMIC'
             1299 'D03979 SCOPOLAMINE OPHTHALMIC'
             1300 'D03980 SULFISOXAZOLE OPHTHALMIC'
             1301 'D03981 TETRACAINE OPHTHALMIC'
             1302 'D03982 TETRACAINE TOPICAL' 1303 'D03984 RITONAVIR'
             1304 'D03985 INDINAVIR' 1305 'D03989 BORIC ACID OPHTHALMIC'
             1306 'D03990 CARBAMIDE PEROXIDE OTIC'
             1307 'D03992 CHLORAMPHENICOL OPHTHALMIC'
             1308 'D03993 CHLORTETRACYCLINE OPHTHALMIC'
             1309 'D03994 COLLOIDAL OATMEAL TOPICAL'
             1310 'D03998 STERILE WATER'
             1311 'D04002 PIPERONYL BUTOXIDE-PYRETHRINS TOPICAL'
             1312 'D04003 HYDROGEN PEROXIDE TOPICAL'
             1313 'D04004 DOXORUBICIN LIPOSOMAL'
             1314 'D04005 AMOBARBITAL-SECOBARBITAL'
             1315 'D04006 DEXFENFLURAMINE' 1316 'D04008 TRANDOLAPRIL'
             1317 'D04009 DOCETAXEL' 1318 'D04010 GEMCITABINE'
             1319 'D04011 INTERFERON BETA-1A' 1320 'D04012 TERBINAFINE'
             1321 'D04014 TOPOTECAN' 1322 'D04015 ADAPALENE TOPICAL'
             1323 'D04016 IODIXANOL' 1324 'D04017 LATANOPROST OPHTHALMIC'
             1325 'D04021 BENZOIC ACID-SALICYLIC ACID TOPICAL'
             1326 'D04025 MIRTAZAPINE' 1327 'D04026 IRINOTECAN'
             1328 'D04027 MEROPENEM' 1329 'D04028 CIDOFOVIR'
             1330 'D04029 NEVIRAPINE' 1331 'D04031 PILOCARPINE'
             1332 'D04032 SULFACETAMIDE SODIUM-SULFUR TOPICAL'
             1333 'D04034 REMIFENTANIL'
             1334 'D04035 AMPHETAMINE-DEXTROAMPHETAMINE'
             1335 'D04036 CAFFEINE-SODIUM BENZOATE'
             1336 'D04037 TIMOLOL OPHTHALMIC'
             1337 'D04038 BETAXOLOL OPHTHALMIC'
             1338 'D04039 CARTEOLOL OPHTHALMIC' 1339 'D04040 FEXOFENADINE'
             1340 'D04041 FOSPHENYTOIN'
             1341 'D04043 FOLLICLE STIMULATING HORMONE'
             1342 'D04044 RESORCINOL TOPICAL'
             1343 'D04045 RESORCINOL-SULFUR TOPICAL' 1344 'D04047 MIDODRINE'
             1345 'D04048 BRIMONIDINE OPHTHALMIC'
             1346 'D04049 AMMONIUM LACTATE TOPICAL' 1347 'D04050 OLANZAPINE'
             1348 'D04051 ROPIVACAINE'
             1349 'D04052 PENTOSAN POLYSULFATE SODIUM'
             1350 'D04053 ZAFIRLUKAST' 1351 'D04054 PENCICLOVIR TOPICAL'
             1352 'D04056 ZINC GLUCONATE' 1353 'D04057 ZINC SULFATE'
             1354 'D04058 MELATONIN'
             1355 'D04059 HAEMOPHILUS B-HEPATITIS B VACCINE'
             1356 'D04060 DILTIAZEM-ENALAPRIL'
             1357 'D04061 BISMUTH SUBSALICYLATE/METRONIDAZOLE/TCN'
             1358 'D04062 BENTOQUATAM TOPICAL'
             1359 'D04063 BUTENAFINE TOPICAL'
             1360 'D04065 TRANDOLAPRIL-VERAPAMIL'
             1361 'D04066 ALBUTEROL-IPRATROPIUM' 1362 'D04067 RETEPLASE'
             1363 'D04068 AZELASTINE NASAL'
             1364 'D04070 SODIUM PHENYLBUTYRATE'
             1365 'D04075 CHLOROXYLENOL TOPICAL'
             1366 'D04076 CHLOROXYLENOL/HYDROCORTISONE/PRAMOXINE OTIC'
             1367 'D04083 GADODIAMIDE' 1368 'D04084 GLYCINE IRRIGATION'
             1369 'D04090 LACTIC ACID TOPICAL'
             1370 'D04093 HYDROCORTISONE-IODOQUINOL TOPICAL'
             1371 'D04095 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OPHTH'
             1372 'D04096 IMIGLUCERASE' 1373 'D04099 DONEPEZIL'
             1374 'D04100 AMPHOTERICIN B CHOLESTERYL SULFATE'
             1375 'D04101 IVERMECTIN' 1376 'D04102 TIZANIDINE'
             1377 'D04103 ZILEUTON' 1378 'D04105 ATORVASTATIN'
             1379 'D04106 FOSFOMYCIN' 1380 'D04107 AMLEXANOX TOPICAL'
             1381 'D04109 LEVOFLOXACIN' 1382 'D04110 MIGLITOL'
             1383 'D04111 GLATIRAMER' 1384 'D04112 CABERGOLINE'
             1385 'D04113 VALSARTAN' 1386 'D04115 TOPIRAMATE'
             1387 'D04116 ENALAPRIL-FELODIPINE'
             1388 'D04117 OLOPATADINE OPHTHALMIC' 1389 'D04118 NELFINAVIR'
             1390 'D04119 DELAVIRDINE' 1391 'D04120 CAFFEINE-ERGOTAMINE'
             1392 'D04121 TAMSULOSIN' 1393 'D04122 TROGLITAZONE'
             1394 'D04123 ZINC ACETATE' 1395 'D04125 IMIQUIMOD TOPICAL'
             1396 'D04126 ANAGRELIDE' 1397 'D04128 LVP SOLUTION'
             1398 'D04130 LVP SOLUTION WITH HYPERTONIC SALINE'
             1399 'D04131 PARENTERAL NUTRITION SOLUTION'
             1400 'D04132 PARENTERAL NUTRITION SOLUTION W/ELECTROLYTES'
             1401 'D04133 NEOMYCIN OPHTHALMIC'
             1402 'D04134 POLYMYXIN B OPHTHALMIC'
             1403 'D04135 PHENYLEPHRINE OPHTHALMIC' 1404 'D04137 TOREMIFENE'
             1405 'D04138 TAZAROTENE TOPICAL' 1406 'D04139 MIBEFRADIL'
             1407 'D04141 HYDROCHLOROTHIAZIDE-MOEXIPRIL'
             1408 'D04142 CHROMIUM PICOLINATE'
             1409 'D04143 ACETAMINOPHEN-PAMABROM' 1410 'D04145 PRAMIPEXOLE'
             1411 'D04147 NAPHAZOLINE NASAL' 1412 'D04150 BROMFENAC'
             1413 'D04151 BENZOCAINE-TRIMETHOBENZAMIDE'
             1414 'D04152 HYDROCODONE-PHENYLEPHRINE'
             1415 'D04153 PHENAZOPYRIDINE-SULFISOXAZOLE'
             1416 'D04155 ASPIRIN-DIPHENHYDRAMINE' 1417 'D04156 LETROZOLE'
             1418 'D04157 LOPERAMIDE-SIMETHICONE' 1419 'D04159 SORBITOL'
             1420 'D04160 SODIUM BIPHOSPHATE-SODIUM PHOSPHATE'
             1421 'D04161 SECRETIN' 1422 'D04163 FERROUS SULFATE-FOLIC ACID'
             1423 'D04166 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PSE'
             1424 'D04168 APAP/DIPHENHYDRAMINE/PSEUDOEPHEDRINE'
             1425 'D04172 CALAMINE-PRAMOXINE TOPICAL'
             1426 'D04175 DIPHENHYDRAMINE-MAGNESIUM SALICYLATE'
             1427 'D04177 FAT SUPPLEMENT, ORAL'
             1428 'D04178 CALCIUM HYDROXIDE TOPICAL'
             1429 'D04184 POTASSIUM AMINOBENZOATE'
             1430 'D04185 POTASSIUM BICARBONATE-SODIUM BICARBONATE'
             1431 'D04186 PHENYLEPHRINE NASAL'
             1432 'D04189 TRIPELENNAMINE TOPICAL'
             1433 'D04190 PAPAIN TOPICAL' 1434 'D04191 PAPAIN-UREA TOPICAL'
             1435 'D04192 COLISTIN/HC/NEOMYCIN/THONZONIUM OTIC'
             1436 'D04193 LEVMETAMFETAMINE NASAL'
             1437 'D04194 PROPYLHEXEDRINE NASAL' 1438 'D04195 CHLOROPHYLLIN'
             1439 'D04196 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B TOPICAL'
             1440 'D04197 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B TOPICAL'
             1441 'D04204 COPPER SULFATE'
             1442 'D04205 POVIDONE IODINE OPHTHALMIC'
             1443 'D04206 TETRAHYDROZOLINE NASAL'
             1444 'D04208 SILVER NITRATE TOPICAL'
             1445 'D04209 METHOXSALEN TOPICAL'
             1446 'D04210 ESTRADIOL TOPICAL' 1447 'D04214 DOLASETRON'
             1448 'D04215 ROPINIROLE' 1449 'D04217 EPINEPHRINE-PRILOCAINE'
             1450 'D04219 LAMIVUDINE-ZIDOVUDINE' 1451 'D04220 QUETIAPINE'
             1452 'D04221 TIAGABINE' 1453 'D04222 IRBESARTAN'
             1454 'D04223 MOMETASONE NASAL'
             1455 'D04224 INTERFERON ALFACON-1'
             1456 'D04225 HYDROCODONE-IBUPROFEN'
             1457 'D04226 AMINOSALICYLIC ACID' 1458 'D04228 ACETIC ACID OTIC'
             1459 'D04229 GLYCERIN OTIC' 1460 'D04231 VITAMIN A OPHTHALMIC'
             1461 'D04233 TRIAMCINOLONE NASAL'
             1462 'D04235 IPRATROPIUM NASAL' 1463 'D04236 ETHANOL TOPICAL'
             1464 'D04238 AMPHOTERICIN B LIPOSOMAL'
             1465 'D04240 HYLAN G-F 20'
             1466 'D04241 POTASSIUM CHLORIDE-SODIUM CHLORIDE'
             1467 'D04242 SODIUM CHLORIDE NASAL'
             1468 'D04243 LIDOCAINE-OXYTETRACYCLINE'
             1469 'D04245 HYDROCHLOROTHIAZIDE-IRBESARTAN'
             1470 'D04247 PEGASPARGASE' 1471 'D04248 METHYLCELLULOSE'
             1472 'D04249 CELLULOSE' 1473 'D04253 ZOLMITRIPTAN'
             1474 'D04255 RITUXIMAB' 1475 'D04256 CEFDINIR'
             1476 'D04258 CLOPIDOGREL' 1477 'D04260 SIBUTRAMINE'
             1478 'D04261 RALOXIFENE' 1479 'D04263 TROVAFLOXACIN'
             1480 'D04264 BECAPLERMIN TOPICAL' 1481 'D04265 OFLOXACIN OTIC'
             1482 'D04266 EPROSARTAN' 1483 'D04267 REPAGLINIDE'
             1484 'D04269 APAP/CAFFEINE/DIHYDROCODEINE'
             1485 'D04270 FEXOFENADINE-PSEUDOEPHEDRINE'
             1486 'D04271 DICLOFENAC-MISOPROSTOL'
             1487 'D04272 AMOXICILLIN/CLARITHROMYCIN/LANSOPRAZOLE'
             1488 'D04274 FOMEPIZOLE' 1489 'D04275 BECLOMETHASONE NASAL'
             1490 'D04276 BUDESONIDE' 1491 'D04279 FLUNISOLIDE NASAL'
             1492 'D04282 TOLCAPONE' 1493 'D04283 FLUTICASONE NASAL'
             1494 'D04284 FLUTICASONE TOPICAL' 1495 'D04285 NARATRIPTAN'
             1496 'D04286 FENOFIBRATE' 1497 'D04287 CIPROFLOXACIN OTIC'
             1498 'D04288 CIPROFLOXACIN-HYDROCORTISONE OTIC'
             1499 'D04289 MONTELUKAST'
             1500 'D04290 CALCIUM CARBONATE-MAGNESIUM HYDROXIDE'
             1501 'D04291 LEPIRUDIN' 1502 'D04292 LOTEPREDNOL OPHTHALMIC'
             1503 'D04293 HYDROCHLOROTHIAZIDE-VALSARTAN'
             1504 'D04294 TOLTERODINE' 1505 'D04295 OXYMETHOLONE'
             1506 'D04296 STARCH TOPICAL'
             1507 'D04297 PHENYLEPHRINE-PRAMOXINE TOPICAL'
             1508 'D04298 PHENYLEPHRINE TOPICAL' 1509 'D04299 SILDENAFIL'
             1510 'D04300 RISEDRONATE' 1511 'D04301 BRINZOLAMIDE OPHTHALMIC'
             1512 'D04303 DORZOLAMIDE-TIMOLOL OPHTHALMIC'
             1513 'D04305 SACROSIDASE' 1514 'D04311 CAPECITABINE'
             1515 'D04312 PARICALCITOL' 1516 'D04314 BASILIXIMAB'
             1517 'D04315 TIROFIBAN' 1518 'D04316 EPTIFIBATIDE'
             1519 'D04320 DIPHTHERIA/HAEMOPHILUS/PERTUSSIS,ACEL/TETANUS'
             1520 'D04321 INTERFERON ALFA-2B-RIBAVIRIN'
             1521 'D04322 CANDESARTAN' 1522 'D04323 PALIVIZUMAB'
             1523 'D04328 RIZATRIPTAN' 1524 'D04329 SODIUM HYALURONATE'
             1525 'D04331 THALIDOMIDE' 1526 'D04332 CITALOPRAM'
             1527 'D04334 EPHEDRINE-POTASSIUM IODIDE'
             1528 'D04339 DEXTROMETHORPHAN-POTASSIUM GUAIACOLSULFONATE'
             1529 'D04342 INFLIXIMAB' 1530 'D04344 ROTAVIRUS VACCINE'
             1531 'D04345 APAP/CAFFEINE/GUAIFENESIN/PHENYLEPHRINE'
             1532 'D04347 DOXYCYCLINE TOPICAL' 1533 'D04349 LEFLUNOMIDE'
             1534 'D04351 COAL TAR/LACTIC ACID/SALICYLIC ACID TOPICAL'
             1535 'D04355 EFAVIRENZ' 1536 'D04357 TRASTUZUMAB'
             1537 'D04360 HEMIN' 1538 'D04363 SEVELAMER'
             1539 'D04364 TELMISARTAN' 1540 'D04365 ETANERCEPT'
             1541 'D04366 SIMETHICONE COATED CELLULOSE'
             1542 'D04368 TANNIC ACID TOPICAL' 1543 'D04369 INSULIN REGULAR'
             1544 'D04370 INSULIN ISOPHANE' 1545 'D04371 INSULIN ZINC'
             1546 'D04372 INSULIN ZINC EXTENDED' 1547 'D04373 INSULIN LISPRO'
             1548 'D04374 INSULIN ISOPHANE-INSULIN REGULAR'
             1549 'D04375 ESTRADIOL-NORETHINDRONE' 1550 'D04376 ABACAVIR'
             1551 'D04377 THYROTROPIN ALPHA' 1552 'D04378 MODAFINIL'
             1553 'D04379 LYME DISEASE VACCINE' 1554 'D04380 CELECOXIB'
             1555 'D04382 CILOSTAZOL' 1556 'D04386 DENILEUKIN DIFTITOX'
             1557 'D04387 SODIUM FERRIC GLUCONATE COMPLEX'
             1558 'D04389 PENTASTARCH' 1559 'D04391 LIVER DERIVATIVE COMPLEX'
             1560 'D04393 BUTABARBITAL/HYOSCYAMINE/PHENAZOPYRIDINE'
             1561 'D04394 CROMOLYN NASAL' 1562 'D04395 CLOTRIMAZOLE TOPICAL'
             1563 'D04396 CONJUGATED ESTROGENS TOPICAL'
             1564 'D04397 FLUORIDE TOPICAL' 1565 'D04399 NYSTATIN TOPICAL'
             1566 'D04402 CILASTATIN' 1567 'D04406 TYPHOID VACCINE, LIVE'
             1568 'D04407 ECHINACEA' 1569 'D04408 ST. JOHN''S WORT'
             1570 'D04409 CHAMOMILE' 1571 'D04410 FEVERFEW'
             1572 'D04411 GARLIC' 1573 'D04412 GINSENG' 1574 'D04413 GINKGO'
             1575 'D04414 GINGER' 1576 'D04415 SAW PALMETTO'
             1577 'D04416 VALERIAN' 1578 'D04417 CREATINE'
             1579 'D04418 GLUCOSAMINE' 1580 'D04419 CHONDROITIN'
             1581 'D04420 CHONDROITIN-GLUCOSAMINE'
             1582 'D04421 EVENING PRIMROSE' 1583 'D04422 KAVA'
             1584 'D04423 GOLDENSEAL' 1585 'D04425 DEHYDROEPIANDROSTERONE'
             1586 'D04426 RED YEAST RICE' 1587 'D04427 LEVALBUTEROL'
             1588 'D04429 ORLISTAT'
             1589 'D04430 BACITRACIN/NEOMYCIN/POLYMYXIN B/PRAMOXINE TOP'
             1590 'D04431 NEOMYCIN/POLYMYXIN B/PRAMOXINE TOPICAL'
             1591 'D04432 CARBONYL IRON' 1592 'D04433 ROFECOXIB'
             1593 'D04434 ROSIGLITAZONE' 1594 'D04435 DOXERCALCIFEROL'
             1595 'D04436 MALATHION TOPICAL' 1596 'D04440 PERINDOPRIL'
             1597 'D04441 KETOTIFEN OPHTHALMIC' 1598 'D04442 PIOGLITAZONE'
             1599 'D04443 ZANAMIVIR'
             1600 'D04445 CARBETAPENTANE/CHLORPHENIRAMINE/PHENYLEPHRINE'
             1601 'D04446 PHENYLEPHRINE-PYRILAMINE' 1602 'D04447 GANIRELIX'
             1603 'D04448 RABEPRAZOLE' 1604 'D04451 TEMOZOLOMIDE'
             1605 'D04452 ZALEPLON' 1606 'D04453 SIROLIMUS'
             1607 'D04454 EPIRUBICIN' 1608 'D04457 DALFOPRISTIN-QUINUPRISTIN'
             1609 'D04458 PEMIROLAST OPHTHALMIC' 1610 'D04459 DOFETILIDE'
             1611 'D04460 ENTACAPONE' 1612 'D04461 EXEMESTANE'
             1613 'D04462 OSELTAMIVIR' 1614 'D04463 GRAPE SEED OIL'
             1615 'D04464 DONG QUAI' 1616 'D04466 MILK THISTLE'
             1617 'D04467 CAT''S CLAW' 1618 'D04469 BEE POLLEN'
             1619 'D04470 CRANBERRY' 1620 'D04472 BLACK COHOSH'
             1621 'D04473 BLUE COHOSH' 1622 'D04478 WILD YAM'
             1623 'D04479 PENNYROYAL' 1624 'D04481 ROYAL JELLY'
             1625 'D04482 DAMIANA' 1626 'D04483 DANDELION'
             1627 'D04484 SHARK CARTILAGE' 1628 'D04491 FLAX'
             1629 'D04492 FENUGREEK' 1630 'D04497 ASPIRIN-DIPYRIDAMOLE'
             1631 'D04498 NAPROXEN-PSEUDOEPHEDRINE'
             1632 'D04499 LEVETIRACETAM' 1633 'D04500 MOXIFLOXACIN'
             1634 'D04501 AMINOLEVULINIC ACID TOPICAL'
             1635 'D04503 NEDOCROMIL OPHTHALMIC' 1636 'D04504 GATIFLOXACIN'
             1637 'D04505 DEXMEDETOMIDINE'
             1638 'D04506 ESTRADIOL-NORGESTIMATE' 1639 'D04507 BEXAROTENE'
             1640 'D04508 NITRIC OXIDE'
             1641 'D04509 HYDROCHLOROTHIAZIDE-QUINAPRIL'
             1642 'D04510 INSULIN LISPRO-INSULIN LISPRO PROTAMINE'
             1643 'D04512 CEVIMELINE' 1644 'D04513 OXCARBAZEPINE'
             1645 'D04514 PANTOPRAZOLE' 1646 'D04515 GADOVERSETAMIDE'
             1647 'D04516 ALOSETRON' 1648 'D04523 UBIQUINONE'
             1649 'D04524 S-ADENOSYLMETHIONINE' 1650 'D04527 ZONISAMIDE'
             1651 'D04530 STRONTIUM-89 CHLORIDE'
             1652 'D04531 SAMARIUM SM 153 LEXIDRONAM' 1653 'D04532 MELOXICAM'
             1654 'D04533 VERTEPORFIN' 1655 'D04534 LINEZOLID'
             1656 'D04535 ARTICAINE-EPINEPHRINE' 1657 'D04536 ARTICAINE'
             1658 'D04537 RIVASTIGMINE' 1659 'D04538 INSULIN GLARGINE'
             1660 'D04539 FOSINOPRIL-HYDROCHLOROTHIAZIDE'
             1661 'D04540 GEMTUZUMAB' 1662 'D04541 AZELASTINE OPHTHALMIC'
             1663 'D04547 ATOVAQUONE-PROGUANIL' 1664 'D04557 CLOBAZAM'
             1665 'D04572 FORMOTEROL' 1666 'D04597 TETRABENAZINE'
             1667 'D04611 FLUTICASONE-SALMETEROL' 1668 'D04659 TINZAPARIN'
             1669 'D04669 VIGABATRIN'
             1670 'D04674 DIPHTH/HAEMOPHILUS/PERTUSSIS/TETANUS/POLIO'
             1671 'D04675 DIPHTHERIA/PERTUSSIS,ACEL/TETANUS/POLIO'
             1672 'D04685 HEPATITIS A-HEPATITIS B VACCINE'
             1673 'D04689 CALAMINE-DIPHENHYDRAMINE TOPICAL'
             1674 'D04694 TENECTEPLASE' 1675 'D04695 COLESEVELAM'
             1676 'D04697 INSULIN ASPART' 1677 'D04698 ARGATROBAN'
             1678 'D04700 BALSALAZIDE' 1679 'D04702 DOCOSANOL TOPICAL'
             1680 'D04703 GLYBURIDE-METFORMIN'
             1681 'D04704 EFLORNITHINE TOPICAL'
             1682 'D04705 FLUDEOXYGLUCOSE F18'
             1683 'D04707 LEVOFLOXACIN OPHTHALMIC'
             1684 'D04708 ZOLEDRONIC ACID'
             1685 'D04711 CANDESARTAN-HYDROCHLOROTHIAZIDE'
             1686 'D04716 LOPINAVIR' 1687 'D04717 LOPINAVIR-RITONAVIR'
             1688 'D04718 MIFEPRISTONE' 1689 'D04720 ARSENIC TRIOXIDE'
             1690 'D04722 DICLOFENAC TOPICAL'
             1691 'D04723 CALCIUM CARBONATE/FAMOTIDINE/MG HYDROXIDE'
             1692 'D04725 IRON SUCROSE' 1693 'D04726 5-HYDROXYTRYPTOPHAN'
             1694 'D04727 ABACAVIR/LAMIVUDINE/ZIDOVUDINE'
             1695 'D04737 HYDROCHLOROTHIAZIDE-TELMISARTAN'
             1696 'D04738 APAP/DOXYLAMINE/PSEUDOEPHEDRINE'
             1697 'D04740 TACROLIMUS TOPICAL'
             1698 'D04741 CARBETAPENTANE/GUAIFENESIN/PHENYLEPHRINE'
             1699 'D04742 BENZOYL PEROXIDE-CLINDAMYCIN TOPICAL'
             1700 'D04743 NATEGLINIDE' 1701 'D04744 BIVALIRUDIN'
             1702 'D04746 PEGINTERFERON ALFA-2B' 1703 'D04747 ZIPRASIDONE'
             1704 'D04748 CASPOFUNGIN' 1705 'D04749 ESOMEPRAZOLE'
             1706 'D04750 GALANTAMINE'
             1707 'D04752 CARBINOXAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1708 'D04753 TRAVOPROST OPHTHALMIC'
             1709 'D04754 BIMATOPROST OPHTHALMIC'
             1710 'D04755 VALGANCICLOVIR' 1711 'D04756 ALEMTUZUMAB'
             1712 'D04757 ALMOTRIPTAN' 1713 'D04758 IMATINIB'
             1714 'D04760 DROSPIRENONE-ETHINYL ESTRADIOL'
             1715 'D04761 MINOCYCLINE TOPICAL'
             1716 'D04762 METHSCOPOLAMINE-PSEUDOEPHEDRINE'
             1717 'D04763 NESIRITIDE'
             1718 'D04764 CETIRIZINE-PSEUDOEPHEDRINE'
             1719 'D04765 HYDROCORTISONE-LIDOCAINE TOPICAL'
             1720 'D04766 ACETAMINOPHEN-TRAMADOL' 1721 'D04767 CEFDITOREN'
             1722 'D04770 CARBETAPENTANE-CHLORPHENIRAMINE'
             1723 'D04771 DARBEPOETIN ALFA' 1724 'D04772 ETONOGESTREL'
             1725 'D04773 ETHINYL ESTRADIOL-ETONOGESTREL'
             1726 'D04774 TENOFOVIR' 1727 'D04775 ANAKINRA'
             1728 'D04776 FROVATRIPTAN' 1729 'D04777 DEXMETHYLPHENIDATE'
             1730 'D04778 VALDECOXIB'
             1731 'D04779 ETHINYL ESTRADIOL-NORELGESTROMIN'
             1732 'D04782 BOSENTAN' 1733 'D04783 ERTAPENEM'
             1734 'D04784 PIMECROLIMUS TOPICAL' 1735 'D04785 DESLORATADINE'
             1736 'D04786 FONDAPARINUX' 1737 'D04787 LOVASTATIN-NIACIN'
             1738 'D04788 DUTASTERIDE' 1739 'D04789 NITISINONE'
             1740 'D04790 PEGFILGRASTIM'
             1741 'D04791 FLUOCINOLONE/HYDROQUINONE/TRETINOIN TOPICAL'
             1742 'D04792 ASA/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1743 'D04793 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PE'
             1744 'D04794 CARBINOXAMINE/METHSCOPOLAMINE/PSEUDOEPHEDRINE'
             1745 'D04795 BUDESONIDE-FORMOTEROL' 1746 'D04796 PERFLUTREN'
             1747 'D04797 ALFUZOSIN' 1748 'D04798 TEGASEROD'
             1749 'D04799 FULVESTRANT' 1750 'D04800 IFOSFAMIDE-MESNA'
             1751 'D04801 OLMESARTAN' 1752 'D04802 TREPROSTINIL'
             1753 'D04803 VORICONAZOLE' 1754 'D04805 RASBURICASE'
             1755 'D04806 SODIUM OXYBATE' 1756 'D04811 OXALIPLATIN'
             1757 'D04812 ESCITALOPRAM' 1758 'D04814 ADEFOVIR'
             1759 'D04815 EPLERENONE'
             1760 'D04817 DEXCHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             1761 'D04818 DEXCHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             1762 'D04819 BUPRENORPHINE-NALOXONE'
             1763 'D04820 METFORMIN-ROSIGLITAZONE'
             1764 'D04821 PEGINTERFERON ALFA-2A'
             1765 'D04823 GLIPIZIDE-METFORMIN' 1766 'D04824 EZETIMIBE'
             1767 'D04825 ARIPIPRAZOLE' 1768 'D04826 NITAZOXANIDE'
             1769 'D04827 ATOMOXETINE' 1770 'D04828 TERIPARATIDE'
             1771 'D04829 TIOTROPIUM' 1772 'D04831 SMALLPOX VACCINE'
             1773 'D04832 DIPHTHERIA/HEPB/PERTUSSIS,ACEL/POLIO/TETANUS'
             1774 'D04834 CYTARABINE LIPOSOMAL' 1775 'D04835 ADALIMUMAB'
             1776 'D04836 CYCLOSPORINE OPHTHALMIC'
             1777 'D04838 INSULIN ASPART PROTAMINE'
             1778 'D04839 INSULIN ASPART-INSULIN ASPART PROTAMINE'
             1779 'D04843 ALEFACEPT' 1780 'D04844 CAMPHOR-MENTHOL TOPICAL'
             1781 'D04845 IBRITUMOMAB' 1782 'D04849 ELETRIPTAN'
             1783 'D04850 CARBETAPENTANE/PHENYLEPHRINE/PYRILAMINE'
             1784 'D04851 ROSUVASTATIN' 1785 'D04852 BUPIVACAINE-FENTANYL'
             1786 'D04853 ENFUVIRTIDE' 1787 'D04854 PEGVISOMANT'
             1788 'D04855 APREPITANT' 1789 'D04856 BOTULISM ANTITOXIN'
             1790 'D04857 GATIFLOXACIN OPHTHALMIC'
             1791 'D04858 ANTHRAX VACCINE ADSORBED'
             1792 'D04859 GEMIFLOXACIN' 1793 'D04860 MOXIFLOXACIN OPHTHALMIC'
             1794 'D04861 DIPHENHYDRAMINE-PHENYLEPHRINE'
             1795 'D04862 BROMPHENIRAMINE/DM/GUAIFENESIN/PSE'
             1796 'D04863 CHLORPHENIRAMINE/IBUPROFEN/PSEUDOEPHEDRINE'
             1797 'D04864 CARBETAPENTANE-PSEUDOEPHEDRINE'
             1798 'D04866 AGALSIDASE BETA' 1799 'D04868 GEFITINIB'
             1800 'D04869 CHLORPHENIRAMINE/DIHYDROCODEINE/PSE'
             1801 'D04870 DIHYDROCODEINE/GUAIFENESIN/PSEUDOEPHEDRINE'
             1802 'D04871 BORTEZOMIB' 1803 'D04875 BETAINE'
             1804 'D04877 CARBIDOPA/ENTACAPONE/LEVODOPA'
             1805 'D04878 HYDROCHLOROTHIAZIDE-OLMESARTAN'
             1806 'D04879 PHENYLEPHRINE-POTASSIUM GUAIACOLSULFONATE'
             1807 'D04880 BROMPHENIRAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1808 'D04881 OMALIZUMAB' 1809 'D04882 ATAZANAVIR'
             1810 'D04884 EMTRICITABINE' 1811 'D04885 TOSITUMOMAB'
             1812 'D04886 IODINE I 131 TOSITUMOMAB'
             1813 'D04887 BUPIVACAINE-HYDROMORPHONE'
             1814 'D04888 PALONOSETRON'
             1815 'D04890 CIPROFLOXACIN-DEXAMETHASONE OTIC'
             1816 'D04892 INFLUENZA VIRUS VACCINE, LIVE, TRIVALENT'
             1817 'D04893 VARDENAFIL' 1818 'D04894 DAPTOMYCIN'
             1819 'D04895 CARBETAPENTANE/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1820 'D04896 TADALAFIL'
             1821 'D04897 TETRAHYDROZOLINE-ZINC OPHTHALMIC'
             1822 'D04898 EPINASTINE OPHTHALMIC' 1823 'D04899 MEMANTINE'
             1824 'D04900 SALICYLIC ACID-UREA TOPICAL'
             1825 'D04901 FOSAMPRENAVIR' 1826 'D04902 EFALIZUMAB'
             1827 'D04905 BROMPHENIRAMINE/DEXTROMETHORPH/PHENYLEPHRINE'
             1828 'D04913 LANSOPRAZOLE-NAPROXEN'
             1829 'D04914 ESTRADIOL-LEVONORGESTREL'
             1830 'D04915 SERTACONAZOLE TOPICAL' 1831 'D04916 CAPSICUM'
             1832 'D04917 FLUOXETINE-OLANZAPINE'
             1833 'D04920 PNEUMOCOCCAL 7-VALENT CONJUGATE VACCINE'
             1834 'D04921 TETANUS-DIPHTH TOXOIDS (TD) ADULT/ADOL'
             1835 'D04925 DIPHENHYDRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1836 'D04929 TROSPIUM' 1837 'D04933 TELITHROMYCIN'
             1838 'D04935 TINIDAZOLE' 1839 'D04986 ACAMPROSATE'
             1840 'D04991 APOMORPHINE' 1841 'D05029 LUTROPIN ALFA'
             1842 'D05044 BETAMETHASONE-CALCIPOTRIENE TOPICAL'
             1843 'D05047 PEMETREXED' 1844 'D05048 AMLODIPINE-ATORVASTATIN'
             1845 'D05101 CETUXIMAB'
             1846 'D05117 GUAIFENESIN-POTASSIUM GUAIACOLSULFONATE'
             1847 'D05119 DEXTROMETHORPHAN/GG/K GUAIACOLSULFONATE'
             1848 'D05145 ARTEMETHER-LUMEFANTRINE'
             1849 'D05150 CARBINOXAMINE/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1850 'D05214 BEVACIZUMAB' 1851 'D05215 ZINC ACETATE TOPICAL'
             1852 'D05216 DIPHENHYDRAMINE-ZINC ACETATE TOPICAL'
             1853 'D05217 MYCOPHENOLIC ACID' 1854 'D05218 CINACALCET'
             1855 'D05232 ILOPROST' 1856 'D05234 HYALURONAN'
             1857 'D05238 BENZOYL PEROXIDE-UREA TOPICAL'
             1858 'D05262 MOMETASONE' 1859 'D05265 NEBIVOLOL'
             1860 'D05269 CADEXOMER IODINE TOPICAL'
             1861 'D05278 INSULIN GLULISINE'
             1862 'D05283 BRIMONIDINE-TIMOLOL OPHTHALMIC'
             1863 'D05292 APAP/CAFFEINE/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1864 'D05293 AZACITIDINE' 1865 'D05294 RIFAXIMIN'
             1866 'D05303 CHLORPHENIRAMINE-CODEINE'
             1867 'D05332 PITCHER PLANT'
             1868 'D05334 BROMPHENIRAMINE/CODEINE/PHENYLEPHRINE'
             1869 'D05337 PNEUMOCOCCAL 23-POLYVALENT VACCINE'
             1870 'D05338 DIPHTHERIA-TETANUS TOXOIDS (DT) PED'
             1871 'D05339 HEPATITIS A PEDIATRIC VACCINE'
             1872 'D05340 HEPATITIS A ADULT VACCINE'
             1873 'D05341 HAEMOPHILUS B CONJUGATE (HBOC) VACCINE'
             1874 'D05343 HAEMOPHILUS B CONJUGATE (PRP-T) VACCINE'
             1875 'D05346 GADOBUTROL' 1876 'D05348 EZETIMIBE-SIMVASTATIN'
             1877 'D05349 BISACODYL-PEG 3350 WITH ELECTROLYTES'
             1878 'D05350 POLYETHYLENE GLYCOL 3350'
             1879 'D05351 APAP/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1880 'D05352 EMTRICITABINE-TENOFOVIR'
             1881 'D05354 ABACAVIR-LAMIVUDINE' 1882 'D05355 DULOXETINE'
             1883 'D05357 IBANDRONATE'
             1884 'D05361 CARBETAPENTANE-GUAIFENESIN'
             1885 'D05366 APAP/DEXTROMETHORPHAN/DOXYLAMINE'
             1886 'D05383 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1887 'D05384 DEXTROMETHORPHAN/PHENIRAMINE/PHENYLEPHRINE'
             1888 'D05389 BISACODYL-MAGNESIUM CITRATE'
             1889 'D05395 LANTHANUM CARBONATE'
             1890 'D05411 CHLORPHENIRAMINE-METHSCOPOLAMINE'
             1891 'D05412 ERLOTINIB' 1892 'D05413 SOLIFENACIN'
             1893 'D05414 NATALIZUMAB' 1894 'D05415 IBUPROFEN-OXYCODONE'
             1895 'D05416 CHLORDIAZEPOXIDE-METHSCOPOLAMINE'
             1896 'D05417 PALIFERMIN' 1897 'D05418 PEGAPTANIB OPHTHALMIC'
             1898 'D05420 ALOH/DIPHENHYD/LIDOCAINE/MGOH/SIMETH TOPICAL'
             1899 'D05421 ESZOPICLONE' 1900 'D05422 DARIFENACIN'
             1901 'D05423 CLOFARABINE' 1902 'D05424 ZICONOTIDE'
             1903 'D05425 LOTEPREDNOL-TOBRAMYCIN OPHTHALMIC'
             1904 'D05426 BROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1905 'D05427 PACLITAXEL PROTEIN-BOUND'
             1906 'D05428 GADOBENATE DIMEGLUMINE'
             1907 'D05432 MENINGOCOCCAL CONJUGATE VACCINE'
             1908 'D05433 DIGESTIVE ENZYMES/HYOSCYAMINE/PHENYLTOLOXAMIN'
             1909 'D05434 BROMPHENIRAMINE/CARBETAPENTANE/PHENYLEPHRINE'
             1910 'D05436 INSULIN DETEMIR'
             1911 'D05459 POVIDONE-TETRAHYDROZOLINE OPHTHALMIC'
             1912 'D05461 SODIUM BENZOATE-SODIUM PHENYLACETATE'
             1913 'D05465 CICLESONIDE'
             1914 'D05470 ASCORBIC ACID-IRON POLYSACCHARIDE'
             1915 'D05471 ALPHA-D-GALACTOSIDASE'
             1916 'D05473 DESLORATADINE-PSEUDOEPHEDRINE'
             1917 'D05487 MICAFUNGIN' 1918 'D05488 PRAMLINTIDE'
             1919 'D05508 PREGABALIN' 1920 'D05518 BROMFENAC OPHTHALMIC'
             1921 'D05525 ENTECAVIR'
             1922 'D05526 ALENDRONATE-CHOLECALCIFEROL'
             1923 'D05527 FLUOCINOLONE OPHTHALMIC'
             1924 'D05528 TRICHOPHYTON SKIN TEST' 1925 'D05529 EXENATIDE'
             1926 'D05530 DROSPIRENONE-ESTRADIOL'
             1927 'D05535 HEME IRON POLYPEPTIDE'
             1928 'D05536 APAP/GUAIFENESIN/PSEUDOEPHEDRINE'
             1929 'D05537 TIGECYCLINE' 1930 'D05538 TIPRANAVIR'
             1931 'D05539 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1932 'D05540 HYDRALAZINE-ISOSORBIDE DINITRATE'
             1933 'D05543 DAPSONE TOPICAL'
             1934 'D05544 APAP/GUAIFENESIN/PHENYLEPHRINE'
             1935 'D05578 RAMELTEON'
             1936 'D05583 APAP/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1937 'D05612 RASAGILINE' 1938 'D05626 EVEROLIMUS'
             1939 'D05630 CALCIUM CARBONATE-RISEDRONATE'
             1940 'D05632 BISACODYL/SODIUM BIPHOSPHATE/SODIUM PHOSPHATE'
             1941 'D05633 NEPAFENAC OPHTHALMIC'
             1942 'D05635 METFORMIN-PIOGLITAZONE' 1943 'D05636 MECASERMIN'
             1944 'D05637 LACTOBACILLUS RHAMNOSUS GG'
             1945 'D05644 APAP/CAFFEINE/ISOMETHEPTENE MUCATE'
             1946 'D05645 MEASLES/MUMPS/RUBELLA/VARICELLA VIRUS VACCINE'
             1947 'D05646 SACCHAROMYCES BOULARDII LYO'
             1948 'D05647 FERRIC SUBSULFATE TOPICAL'
             1949 'D05649 CEFTRIAXONE-LIDOCAINE'
             1950 'D05651 SODIUM HYALURONATE TOPICAL'
             1951 'D05654 APAP/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1952 'D05659 DEFERASIROX'
             1953 'D05661 ACETAMINOPHEN-GUAIFENESIN'
             1954 'D05674 GLIMEPIRIDE-ROSIGLITAZONE' 1955 'D05691 SORAFENIB'
             1956 'D05692 MECASERMIN RINFABATE' 1957 'D05694 ABATACEPT'
             1958 'D05696 LENALIDOMIDE' 1959 'D05702 METHYLSULFONYLMETHANE'
             1960 'D05703 CHONDROITIN/GLUCOSAMINE/METHYLSULFONYLMETHANE'
             1961 'D05704 IMMUNE GLOBULIN SUBCUTANEOUS'
             1962 'D05717 SUNITINIB' 1963 'D05719 RANOLAZINE'
             1964 'D05722 GALLIUM CITRATE GA-67' 1965 'D05736 LUBIPROSTONE'
             1966 'D05753 MICONAZOLE-ZINC OXIDE TOPICAL'
             1967 'D05757 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PE'
             1968 'D05765 INSULIN INHALATION, RAPID ACTING'
             1969 'D05768 APAP/PHENIRAMINE/PHENYLEPHRINE'
             1970 'D05770 OMEPRAZOLE-SODIUM BICARBONATE'
             1971 'D05773 L-METHYLFOLATE'
             1972 'D05774 AMMONIUM LACTATE-UREA TOPICAL' 1973 'D05776 IODINE'
             1974 'D05777 IODINE-POTASSIUM IODIDE'
             1975 'D05778 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PE'
             1976 'D05781 TETANUS/DIPHTH/PERTUSS (TDAP) ADULT/ADOL'
             1977 'D05782 DIPHTHERIA/TETANUS/PERTUSSIS (DTAP) PED'
             1978 'D05785 RABIES VACCINE, HUMAN DIPLOID CELL'
             1979 'D05786 RABIES VACCINE, PURIFIED CHICK EMBRYO CELL'
             1980 'D05788 DECITABINE'
             1981 'D05806 FERROUS FUMARATE/FA/IRON POLYSACCHARIDE'
             1982 'D05807 VARENICLINE' 1983 'D05813 ZOSTER VACCINE LIVE'
             1984 'D05814 DEXTROMETHORPHAN-PHENYLEPHRINE'
             1985 'D05815 FLUORESCEIN'
             1986 'D05817 HUMAN PAPILLOMAVIRUS VACCINE'
             1987 'D05819 DIPHENHYDRAMINE-IBUPROFEN' 1988 'D05825 DARUNAVIR'
             1989 'D05830 FERUMOXSIL' 1990 'D05831 DASATINIB'
             1991 'D05835 RANIBIZUMAB OPHTHALMIC'
             1992 'D05847 EFAVIRENZ/EMTRICITABINE/TENOFOVIR'
             1993 'D05848 ROTIGOTINE' 1994 'D05851 LEVOCETIRIZINE'
             1995 'D05853 POSACONAZOLE' 1996 'D05855 IDURSULFASE'
             1997 'D05856 GLIMEPIRIDE-PIOGLITAZONE'
             1998 'D05864 COMPLEMENT C1 ESTERASE INHIBITOR'
             1999 'D05866 GUAR GUM'
             2000 'D05874 ANTIHEMOPHILIC FACTOR-VON WILLEBRAND FACTOR'
             2001 'D05877 DEXTROMETHORPHAN/DIPHENHYDRAMINE/PE'
             2002 'D05878 BENZALKONIUM CHLORIDE-BENZOCAINE TOPICAL'
             2003 'D05879 PANITUMUMAB' 2004 'D05891 VORINOSTAT'
             2005 'D05892 DEXCHLORPHENIRAMINE/DEXTROMETHO/PE/PYRILAMINE'
             2006 'D05893 ARFORMOTEROL'
             2007 'D05894 CALAMINE-ZINC OXIDE TOPICAL'
             2008 'D05896 SITAGLIPTIN'
             2009 'D05897 BENZOYL PEROXIDE-SALICYLIC ACID TOPICAL'
             2010 'D05899 CICLESONIDE NASAL'
             2011 'D05963 COAGULATION FACTOR IX' 2012 'D05964 ALOE VERA'
             2013 'D05973 CLINDAMYCIN-TRETINOIN TOPICAL'
             2014 'D05974 ANTIHEMOPHILIC FACTOR'
             2015 'D06008 BENZYL ALCOHOL TOPICAL'
             2016 'D06032 FLUOCINOLONE OTIC'
             2017 'D06058 DEXBROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             2018 'D06080 APAP/CAFFEINE/MAGNESIUM SALICYLATE'
             2019 'D06214 COLLAGEN' 2020 'D06227 IOXILAN'
             2021 'D06272 DIENOGEST-ESTRADIOL' 2022 'D06297 PALIPERIDONE'
             2023 'D06370 TURMERIC' 2024 'D06392 WHEAT DEXTRIN'
             2025 'D06507 CINNAMON' 2026 'D06635 MILNACIPRAN'
             2027 'D06648 ATROPINE/CPM/HYOSCYAMINE/PSE/SCOPOLAMINE'
             2028 'D06655 ALPHA-LIPOIC ACID'
             2029 'D06662 AMLODIPINE-VALSARTAN'
             2030 'D06663 LISDEXAMFETAMINE' 2031 'D06665 ALISKIREN'
             2032 'D06672 LAPATINIB' 2033 'D06673 ECULIZUMAB'
             2034 'D06720 METFORMIN-SITAGLIPTIN'
             2035 'D06831 RETAPAMULIN TOPICAL'
             2036 'D06833 ACETAMINOPHEN-ASPIRIN'
             2037 'D06834 BISMUTH SUBCITRATE POTASSIUM/METRONIDAZO/TCN'
             2038 'D06835 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             2039 'D06836 TEMSIROLIMUS' 2040 'D06841 AMBRISENTAN'
             2041 'D06842 ARMODAFINIL' 2042 'D06848 LUTEIN'
             2043 'D06851 AZITHROMYCIN OPHTHALMIC' 2044 'D06852 MARAVIROC'
             2045 'D06857 ACETIC/ANTIPYRINE/BENZOCAINE/POLYCOS OTIC'
             2046 'D06862 HELIUM' 2047 'D06864 HELIUM-OXYGEN'
             2048 'D06867 BIOTIN' 2049 'D06868 MENTHOL-ZINC OXIDE TOPICAL'
             2050 'D06872 APAP/CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             2051 'D06891 CHLOROPHYLLIN COPPER COM/PAPAIN/UREA TOPICAL'
             2052 'D06900 COLLAGEN TOPICAL'
             2053 'D06905 AMLODIPINE-OLMESARTAN'
             2054 'D06976 ASA/CHLORPHENIRAMINE/PHENYLEPHRINE'
             2055 'D07048 RALTEGRAVIR' 2056 'D07049 DORIPENEM'
             2057 'D07051 IXABEPILONE'
             2058 'D07055 CHLORPHENIRAMINE/GUAIFENESIN/METHSCOPOLAMI/PE'
             2059 'D07057 NILOTINIB'
             2060 'D07058 SULFACETAMIDE SODIUM/SULFUR/UREA TOPICAL'
             2061 'D07059 CITRIC ACID-POTASSIUM BICARBONATE'
             2062 'D07063 BROMPHENIRAMINE-DIPHENHYDRAMINE'
             2063 'D07065 BENZYL ALCOHOL-ZINC ACETATE TOPICAL'
             2064 'D07068 SAPROPTERIN' 2065 'D07069 RUFINAMIDE'
             2066 'D07075 PERMETHRIN/PIPERONYL BUTOXIDE/PYRETHR TOPICAL'
             2067 'D07076 ETRAVIRINE'
             2068 'D07077 ALISKIREN-HYDROCHLOROTHIAZIDE'
             2069 'D07110 NIACIN-SIMVASTATIN' 2070 'D07113 DESVENLAFAXINE'
             2071 'D07121 BENDAMUSTINE' 2072 'D07130 NAPROXEN-SUMATRIPTAN'
             2073 'D07131 REGADENOSON' 2074 'D07132 OLOPATADINE NASAL'
             2075 'D07134 CERTOLIZUMAB' 2076 'D07135 METHYLNALTREXONE'
             2077 'D07137 DABIGATRAN' 2078 'D07162 FESOTERODINE'
             2079 'D07292 METFORMIN-REPAGLINIDE'
             2080 'D07298 DIFLUPREDNATE OPHTHALMIC'
             2081 'D07300 CHLOPHEDIANOL/DEXCHLORPHENIRAMINE/PSE'
             2082 'D07302 CHLOPHEDIANOL/GUAIFENESIN/PSEUDOEPHEDRINE'
             2083 'D07306 BENZOCAINE-MENTHOL TOPICAL' 2084 'D07309 GENISTEIN'
             2085 'D07312 CLEVIDIPINE' 2086 'D07315 GLUTAMINE'
             2087 'D07320 ROMIPLOSTIM' 2088 'D07347 BIFIDOBACTERIUM INFANTIS'
             2089 'D07349 LACOSAMIDE'
             2090 'D07351 CARBETAPENTANE/PSEUDOEPHEDRINE/PYRILAMINE'
             2091 'D07354 SILODOSIN' 2092 'D07356 RIVAROXABAN'
             2093 'D07357 ELTROMBOPAG' 2094 'D07371 FENOFIBRIC ACID'
             2095 'D07374 BIMATOPROST TOPICAL OPHTHALMIC'
             2096 'D07382 ADAPALENE-BENZOYL PEROXIDE TOPICAL'
             2097 'D07385 HEPARIN FLUSH'
             2098 'D07387 HYDROCORTISONE/SALICYLIC ACID/SULFUR TOPICAL'
             2099 'D07395 DEXLANSOPRAZOLE' 2100 'D07396 USTEKINUMAB'
             2101 'D07397 FEBUXOSTAT'
             2102 'D07405 CARBETAPENTANE/PE/POTASSIUM GUAIACOLSULFONATE'
             2103 'D07409 PRASUGREL' 2104 'D07411 DEGARELIX'
             2105 'D07418 BENZOCAINE-RESORCINOL TOPICAL'
             2106 'D07435 GOLIMUMAB'
             2107 'D07440 AMLODIPINE/HYDROCHLOROTHIAZIDE/VALSARTAN'
             2108 'D07441 ILOPERIDONE' 2109 'D07447 TOLVAPTAN'
             2110 'D07453 TAPENTADOL' 2111 'D07458 DRONEDARONE'
             2112 'D07459 FERUMOXYTOL'
             2113 'D07464 INFLUENZA VIRUS VACCINE, H1N1, INACTIVATED'
             2114 'D07466 LIRAGLUTIDE' 2115 'D07467 SAXAGLIPTIN'
             2116 'D07472 MORPHINE-NALTREXONE' 2117 'D07473 ASENAPINE'
             2118 'D07481 POLY-L-LACTIC ACID'
             2119 'D07482 BEPOTASTINE OPHTHALMIC' 2120 'D07483 TELAVANCIN'
             2121 'D07485 INFLUENZA VIRUS VACCINE, H1N1, LIVE'
             2122 'D07486 ALISKIREN-VALSARTAN'
             2123 'D07491 DIPHENHYDRAMINE/LIDOCAINE/NYSTATIN TOPICAL'
             2124 'D07492 PRALATREXATE' 2125 'D07496 TOCILIZUMAB'
             2126 'D07498 AMLODIPINE-TELMISARTAN' 2127 'D07499 PAZOPANIB'
             2128 'D07505 COPPER' 2129 'D07509 OFATUMUMAB'
             2130 'D07518 SILVER TOPICAL' 2131 'D07546 DALFAMPRIDINE'
             2132 'D07550 DEXTROMETHORPHAN-DOXYLAMINE'
             2133 'D07565 IPILIMUMAB'
             2134 'D07586 PNEUMOCOCCAL 13-VALENT CONJUGATE VACCINE'
             2135 'D07589 BIOFLAVONOIDS-ZINC GLYCINATE'
             2136 'D07631 ESOMEPRAZOLE-NAPROXEN'
             2137 'D07634 DUTASTERIDE-TAMSULOSIN' 2138 'D07637 PITAVASTATIN'
             2139 'D07638 SIPULEUCEL-T' 2140 'D07640 DENOSUMAB'
             2141 'D07642 ANTI-THYMOCYTE GLOBULIN (RABBIT)'
             2142 'D07644 HEPATITIS B ADULT VACCINE'
             2143 'D07645 ONABOTULINUMTOXINA'
             2144 'D07646 ABOBOTULINUMTOXINA' 2145 'D07647 RACEPINEPHRINE'
             2146 'D07658 CABAZITAXEL'
             2147 'D07659 CAFFEINE-MAGNESIUM SALICYLATE'
             2148 'D07660 FORMOTEROL-MOMETASONE'
             2149 'D07668 AMLODIPINE/HYDROCHLOROTHIAZIDE/OLMESARTAN'
             2150 'D07670 ALCAFTADINE OPHTHALMIC' 2151 'D07684 ROFLUMILAST'
             2152 'D07688 PEGLOTICASE'
             2153 'D07691 MAGNESIUM/POTASSIUM/SODIUM SULFATES'
             2154 'D07692 FINGOLIMOD'
             2155 'D07697 DROSPIRENONE/ETHINYL ESTRADIOL/LEVOMEFOLATE'
             2156 'D07705 LURASIDONE' 2157 'D07706 CEFTAROLINE'
             2158 'D07709 METFORMIN-SAXAGLIPTIN' 2159 'D07715 TESAMORELIN'
             2160 'D07716 ERIBULIN' 2161 'D07727 PENICILLIN G BENZATHINE'
             2162 'D07729 PENICILLIN G POTASSIUM'
             2163 'D07730 PENICILLIN V POTASSIUM'
             2164 'D07738 BROMPHENIRAMINE/CHLOPHEDIANOL/PSE'
             2165 'D07740 VILAZODONE' 2166 'D07754 AZILSARTAN'
             2167 'D07756 BELIMUMAB'
             2168 'D07757 LIDOCAINE-SODIUM BICARBONATE'
             2169 'D07761 VANDETANIB' 2170 'D07766 ABIRATERONE'
             2171 'D07767 LINAGLIPTIN' 2172 'D07774 BOCEPREVIR'
             2173 'D07777 TELAPREVIR'
             2174 'D07796 EMTRICITABINE/RILPIVIRINE/TENOFOVIR'
             2175 'D07798 VEMURAFENIB' 2176 'I00031 XYLENE'
             2177 'I00035 TURPENTINE' 2178 'I00039 TRICHLOROETHANE'
             2179 'I00040 TOLUENE' 2180 'I00081 NAPHTHALENE'
             2181 'I00084 METHYLENE CHLORIDE' 2182 'I00088 METHANOL'
             2183 'I00102 FORMALDEHYDE' 2184 'I00106 ETHYLENE GLYCOL'
             2185 'I00108 ETHYL ETHER' 2186 'I00162 ACETONE'
             2187 'I00173 CYANOACRYLATE' 2188 'I00176 ISOBUTYL NITRITE'
             2189 'I00190 AEROSOL SPRAY-NOS' 2190 'I00196 BUTANE'
             2191 'I00198 TRICHLOROFLUOROMETHANE' 2192 'I00200 METHANE'
             2193 'I00201 PETROLEUM HYDROCARBONS'
             2194 'I00203 CARBON TETRACHLORIDE' 2195 'I00207 BUTYL ALCOHOL'
             2196 'I00209 ALPHA TERPINEOL' 2197 'I00210 FREON'
             2198 'I00211 DICHLOROBENZENE' 2199 'I00212 PROPOXUR'
             2200 'I00216 PROPANE' 2201 'I00219 PHENOLIC DISINFECTANTS'
             2202 'I00221 MINERAL SEAL OIL' 2203 'I00238 FLUORINE'
             2204 'I00240 HYDROCARBON' 2205 'I00247 CHLORINATED HYDROCARBONS'
             2206 'I00251 CRESOL' 2207 'I00256 BUTYL ACETATE'
             2208 'I00343 CLEANER/UNKNOWN COMPOSITION'
             2209 'I00345 COSMETIC/UNKNOWN COMPOSITION'
             2210 'I00348 PESTICIDE/UNKNOWN COMPOSITION'
             2211 'I00349 VOLATILE/UNKNOWN COMPONENTS'
             2212 'I00350 PAINT/UNKNOWN COMPOSITION'
             2213 'I00543 TRICHLOROETHANE/TRICHLOROETHYLENE'
             2214 'I00556 PETROLEUM HYDROCARBONS/TRICHLOROETHANE'
             2215 'I01283 ETHANOL-NP' 2216 'I01328 TRICHLOROMETHANE'
             2217 'I01336 FLUORINATED HYDROCARBONS' 2218 'I01337 ISOBUTANE'
             2219 'I01400 CHLORODIFLUOROMETHANE' 2220 'I01425 ETHYL ACETATE'
             2221 'J00001 LYSERGIC ACID DIETHYLAMIDE'
             2222 'J00002 METHYLENEDIOXYMETHAMPHETAMINE'
             2223 'J00004 FLUNITRAZEPAM' 2224 'J00020 BROMELAIN'
             2225 'J00023 NOMIFENSINE MALEATE' 2226 'J00027 MECLOZINE HCL'
             2227 'J00028 NITRAZEPAM' 2228 'J00030 ZOMEPIRAC'
             2229 'J00032 XYLAZINE' 2230 'J00033 VITAMIN K'
             2231 'J00036 L-TRYPTOPHAN' 2232 'J00049 SULFORIDAZINE'
             2233 'J00050 SULFADINE' 2234 'J00053 SALINE'
             2235 'J00061 PRAZEPAM' 2236 'J00064 PHENMETRAZINE HCL'
             2237 'J00066 PHENACETIN' 2238 'J00089 METHACYCLINE'
             2239 'J00090 MERBROMIN' 2240 'J00092 LUTREXIN'
             2241 'J00093 LORMETAZEPAM' 2242 'J00094 LACTOSE'
             2243 'J00095 KETOTIFEN FUMARATE' 2244 'J00096 INFANT FORMULA'
             2245 'J00097 HYDROXY-N-METHYLMORPHINAN'
             2246 'J00104 FENPROPOREX' 2247 'J00110 ERYTHRITYL TETRANITRATE'
             2248 'J00114 DYPYRONE' 2249 'J00120 DIHYDROMORPHINONE'
             2250 'J00122 ALDOSTERONE' 2251 'J00129 CHLOROPYRAMINE'
             2252 'J00148 CARBAMATE' 2253 'J00150 BROMAZEPAM'
             2254 'J00164 ACEPROMAZINE' 2255 'J00168 METHCATHINONE'
             2256 'J00171 CATHINONE' 2257 'J00174 METHYLENEDIOXYAMPHETAMINE'
             2258 'J00177 METHAQUALONE' 2259 'J00178 MESCALINE'
             2260 'J00179 PSILOCYBIN' 2261 'J00180 MORNING GLORY SEEDS'
             2262 'J00192 DATURA SAUVEOLENS'
             2263 'J00215 GAMMA BUTYROLACTONE' 2264 'J00248 EUCALYPTUS OIL'
             2265 'J00249 PEPPER' 2266 'J00263 DIMETHOXYMETHAMPHETAMINE'
             2267 'J00264 DATURA STRAMONIUM' 2268 'J00265 CANTHARIDINE'
             2269 'J00278 ISOPROPAMIDE IODIDE' 2270 'J00280 ALLOBARBITAL'
             2271 'J00290 CLOBENZOREX' 2272 'J00293 AMBROXOL'
             2273 'J00294 TETRAMYCIN' 2274 'J00295 RHODOMYCIN'
             2275 'J00331 ZOPICLONE' 2276 'J00336 MYCADRINE'
             2277 'J00337 POTASSIUM' 2278 'J00339 PYRETHRUM'
             2279 'J00356 ARECOLINE' 2280 'J00358 PHOSPHATIDYLETHANOLAMINE'
             2281 'J00360 CHLORPHENTERMINE' 2282 'J00362 BARBITURIC ACID'
             2283 'J00364 BARBITAL'
             2284 'J00369 BROMO-DIMETHOXYPHENETHYLAMINE'
             2285 'J00500 MARIJUANA/METHAMPHETAMINE'
             2286 'J00501 FORMALDEHYDE/MARIJUANA'
             2287 'J00502 COCAINE/METHAMPHETAMINE'
             2288 'J00504 COCAINE/MARIJUANA' 2289 'J00507 COCAINE/HEROIN'
             2290 'J00510 MARIJUANA/PHENCYCLIDINE'
             2291 'J00511 COCAINE/PHENCYCLIDINE'
             2292 'J00512 LYSERGIC ACID DIETHYLAMIDE/METHAMPHETAMINE'
             2293 'J00513 LYSERGIC ACID DIETHYLAMIDE/PHENCYCLIDINE'
             2294 'J00514 HEROIN/MARIJUANA'
             2295 'J00531 AMOBARBITAL/DEXTROAMPHETAMINE/THYROID DESICCATED'
             2296 'J00533 PENTOBARBITAL/PHENOBARBITAL'
             2297 'J00539 CAFFEINE/EPHEDRINE'
             2298 'J00540 ACETAMINOPHEN/CHLORZOXAZONE'
             2299 'J00558 ASPIRIN/CAFFEINE/CODEINE/PHENACETIN'
 2300 'J00566 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE/DEXTROMETHORPHAN/GUAIFENESIN'
             2301 'J00568 COCAINE/ETHANOL'
             2302 'J00572 SALICYLAMIDE/SCOPOLAMINE'
             2303 'J00577 CODEINE/TERPIN HYDRATE'
             2304 'J00591 ACETAMINOPHEN/CAFFEINE/CODEINE'
             2305 'J00593 AMYLASE/PROTEASE'
             2306 'J00594 ASPIRIN/CAFFEINE/CODEINE'
             2307 'J01003 ANTIFUNGALS-NOS'
             2308 'J01004 ANTIMALARIAL AGENTS-NOS'
             2309 'J01005 ANTITUBERCULOSIS AGENTS-NOS'
             2310 'J01006 ANTIVIRAL AGENTS-NOS'
             2311 'J01008 CEPHALOSPORINS-NOS' 2312 'J01010 MACROLIDES-NOS'
             2313 'J01011 ANTIBIOTICS-NOS' 2314 'J01012 PENICILLINS-NOS'
             2315 'J01013 QUINOLONES-NOS' 2316 'J01014 SULFONAMIDES-NOS'
             2317 'J01015 TETRACYCLINES-NOS'
             2318 'J01016 URINARY ANTI-INFECTIVES-NOS'
             2319 'J01017 AMINOGLYCOSIDES-NOS'
             2320 'J01018 ANTIHYPERLIPIDEMIC AGENTS-NOS'
             2321 'J01026 RADIOPHARMACEUTICALS-NOS'
             2322 'J01028 ANTITOXINS AND ANTIVENINS-NOS'
             2323 'J01029 BACTERIAL VACCINES-NOS'
             2324 'J01030 COLONY STIMULATING FACTORS-NOS'
             2325 'J01031 IMMUNE GLOBULINS-NOS'
             2326 'J01033 RECOMBINANT HUMAN ERYTHROPOIETINS-NOS'
             2327 'J01034 TOXOIDS-NOS' 2328 'J01035 VIRAL VACCINES-NOS'
             2329 'J01037 CARDIOVASCULAR AGENTS-NOS'
             2330 'J01039 ANGIOTENSIN CONVERTING ENZYME INHIBITORS-NOS'
             2331 'J01040 ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING-NOS'
             2332 'J01042 ANTIANGINAL AGENTS-NOS'
             2333 'J01043 ANTIARRHYTHMIC AGENTS-NOS'
             2334 'J01044 BETA-ADRENERGIC BLOCKING AGENTS-NOS'
             2335 'J01045 CALCIUM CHANNEL BLOCKING AGENTS-NOS'
             2336 'J01047 INOTROPIC AGENTS-NOS'
             2337 'J01049 PERIPHERAL VASODILATORS-NOS'
             2338 'J01050 VASODILATORS-NOS' 2339 'J01051 VASOPRESSORS-NOS'
             2340 'J01052 ANTIHYPERTENSIVE COMBINATIONS-NOS'
             2341 'J01053 ANGIOTENSIN II INHIBITORS-NOS'
             2342 'J01056 ANALGESICS-NOS'
             2343 'J01057 NARCOTIC ANALGESICS-NOS'
             2344 'J01058 NONSTEROIDAL ANTI-INFLAMMATORY AGENTS-NOS'
             2345 'J01059 SALICYLATES-NOS' 2346 'J01061 ANTICONVULSANTS-NOS'
             2347 'J01063 ANTIPARKINSON AGENTS-NOS'
             2348 'J01065 BARBITURATES-NOS' 2349 'J01066 BENZODIAZEPINES-NOS'
             2350 'J01067 ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS'
             2351 'J01068 CNS STIMULANTS-NOS'
             2352 'J01069 GENERAL ANESTHETICS-NOS'
             2353 'J01073 ANTIPSYCHOTICS-NOS'
             2354 'J01077 ANTICOAGULANTS-NOS'
             2355 'J01078 ANTIPLATELET AGENTS-NOS'
             2356 'J01081 THROMBOLYTICS-NOS'
             2357 'J01082 GASTROINTESTINAL AGENTS-NOS'
             2358 'J01083 ANTACIDS-NOS'
             2359 'J01084 ANTICHOLINERGICS/ANTISPASMODICS-NOS'
             2360 'J01085 ANTIDIARRHEALS-NOS'
             2361 'J01086 DIGESTIVE ENZYMES-NOS'
             2362 'J01088 GI STIMULANTS-NOS' 2363 'J01089 H2 ANTAGONISTS-NOS'
             2364 'J01090 LAXATIVES-NOS' 2365 'J01092 HORMONES-NOS'
             2366 'J01093 ADRENAL CORTICAL STEROIDS-NOS'
             2367 'J01094 ANTIDIABETIC AGENTS-NOS'
             2368 'J01096 SEX HORMONES-NOS' 2369 'J01098 THYROID DRUGS-NOS'
             2370 'J01099 IMMUNOSUPPRESSIVE AGENTS-NOS'
             2371 'J01101 ANTIDOTES-NOS' 2372 'J01102 CHELATING AGENTS-NOS'
             2373 'J01103 CHOLINERGIC MUSCLE STIMULANTS-NOS'
             2374 'J01104 LOCAL INJECTABLE ANESTHETICS-NOS'
             2375 'J01106 PSORALENS-NOS'
             2376 'J01107 RADIOCONTRAST AGENTS-NOS'
             2377 'J01108 GENITOURINARY TRACT AGENTS-NOS'
             2378 'J01111 IRON PRODUCTS-NOS'
             2379 'J01112 MINERALS AND ELECTROLYTES-NOS'
             2380 'J01113 ORAL NUTRITIONAL SUPPLEMENTS-NOS'
             2381 'J01115 VITAMIN AND MINERAL COMBINATIONS-NOS'
             2382 'J01116 INTRAVENOUS NUTRITIONAL PRODUCTS-NOS'
             2383 'J01118 ANTIHISTAMINES-NOS' 2384 'J01119 ANTITUSSIVES-NOS'
             2385 'J01120 BRONCHODILATORS-NOS'
             2386 'J01122 DECONGESTANTS-NOS' 2387 'J01123 EXPECTORANTS-NOS'
             2388 'J01124 RESPIRATORY AGENTS-NOS'
             2389 'J01125 RESPIRATORY INHALANT PRODUCTS-NOS'
             2390 'J01126 ANTIASTHMATIC COMBINATIONS-NOS'
             2391 'J01127 UPPER RESPIRATORY COMBINATIONS-NOS'
             2392 'J01129 ANORECTAL PREPARATIONS-NOS'
             2393 'J01130 ANTISEPTIC AND GERMICIDES-NOS'
             2394 'J01131 DERMATOLOGICAL AGENTS-NOS'
             2395 'J01134 TOPICAL ANESTHETICS-NOS'
             2396 'J01139 MOUTH AND THROAT PRODUCTS-NOS'
             2397 'J01143 STERILE IRRIGATING SOLUTIONS-NOS'
             2398 'J01145 PLASMA EXPANDERS-NOS'
             2399 'J01165 HMG-COA REDUCTASE INHIBITORS-NOS'
             2400 'J01170 MUSCLE RELAXANTS-NOS'
             2401 'J01174 ANDROGENS AND ANABOLIC STEROIDS-NOS'
             2402 'J01180 NARCOTIC ANALGESIC COMBINATIONS-NOS'
             2403 'J01181 ANTIRHEUMATICS-NOS'
             2404 'J01182 ANTIMIGRAINE AGENTS-NOS'
             2405 'J01183 ANTIGOUT AGENTS-NOS'
             2406 'J01206 BISPHOSPHONATES-NOS'
             2407 'J01208 NUTRACEUTICAL PRODUCTS-NOS'
             2408 'J01209 HERBAL PRODUCTS-NOS'
             2409 'J01229 FIBRIC ACID DERIVATIVES-NOS'
             2410 'J01231 LEUKOTRIENE MODIFIERS-NOS'
             2411 'J01235 NASAL PREPARATIONS-NOS'
             2412 'J01237 ANTIDEPRESSANTS-NOS' 2413 'J01241 ANOREXIANTS-NOS'
             2414 'J01243 INTERFERONS-NOS'
             2415 'J01244 MONOCLONAL ANTIBODIES-NOS'
             2416 'J01247 IMPOTENCE AGENTS-NOS'
             2417 'J01253 VAGINAL PREPARATIONS-NOS'
             2418 'J01254 ANTIPSORIATICS-NOS'
             2419 'J01256 PROTON PUMP INHIBITORS-NOS'
             2420 'J01261 DRUG UNKNOWN' 2421 'J01262 GAMMA HYDROXY BUTYRATE'
             2422 'J01271 PASSION FLOWER' 2423 'J01276 METHAPHENILENE'
             2424 'J01292 CODEINE COMBINATION-NOS'
             2425 'J01294 HALLUCINOGEN-NOS' 2426 'J01295 POLY-DRUGS'
             2427 'J01298 ANTINEOPLASTICS-NOS'
             2428 'J01300 ANTIBIOTICS/ANTINEOPLASTICS-NOS'
             2429 'J01301 HORMONES/ANTINEOPLASTICS-NOS'
             2430 'J01302 DIURETICS-NOS'
             2431 'J01303 ANTIEMETIC/ANTIVERTIGO AGENTS-NOS'
             2432 'J01305 VITAMINS-NOS'
             2433 'J01306 OPHTHALMIC PREPARATIONS-NOS'
             2434 'J01307 OTIC PREPARATIONS-NOS'
             2435 'J01308 ANALGESIC COMBINATIONS-NOS'
             2436 'J01309 COX-2 INHIBITOR-NOS'
             2437 'J01310 SSRI ANTIDEPRESSANTS-NOS'
             2438 'J01311 TRICYCLIC ANTIDEPRESSANTS-NOS'
             2439 'J01312 MONOAMINE OXIDASE INHIBITORS-NOS'
             2440 'J01313 PSYCHOTHERAPEUTIC COMBINATIONS-NOS'
             2441 'J01314 PHENOTHIAZINE ANTIPSYCHOTICS-NOS'
             2442 'J01315 ISOSORBIDE-NOS' 2443 'J01316 IMMUNIZATION-NOS'
             2444 'J01317 PHENCYCLIDINE COMBINATIONS-NOS'
             2445 'J01318 PNEUMOCOCCAL VACCINE' 2446 'J01319 FOLATE'
             2447 'J01320 PENTOBARBITAL/PHENYTOIN'
             2448 'J01322 BARBITAL SODIUM' 2449 'J01323 GADOLINIUM'
             2450 'J01324 HEPATITIS A VACCINE INACTIVATED' 2451 'J01327 ZINC'
             2452 'J01328 4-BROMO-2,5-DIMETHOXYPHENETHYLAMINE'
             2453 'J01329 2,5-DIMETHOXY-4-IODOPHENETHYLAMINE'
             2454 'J01330 AMPHETAMINE/COCAINE'
             2455 'J01331 METHANDROSTENLONE' 2456 'J01332 MARIJUANA/OPIUM'
             2457 'J01333 ALPROSTADIL/PAPAVERINE/PHENTOLAMINE'
             2458 'J01334 CYANIDE/HEROIN/STRYCHNINE'
             2459 'J01338 HYDROXYCODEINONE'
             2460 'J01340 2,5-DIMETHOXY-4-ETHYL-PHENETHYLAMINE'
             2461 'J01341 2,5-DIMETHOXY-4-(N)-PROPYLTHIOPHENETHYLAMINE'
             2462 'J01342 ANTI-RETROVIRAL AGENTS-NOS' 2463 'J01343 AROPLATIN'
             2464 'J01344 IDRAPARINUX'
             2465 'J01345 COCAINE/LYSERGIC ACID DIETHYLAMIDE'
             2466 'J01346 SALVIA DIVINORUM' 2467 'J01348 TIPIFARNIB'
             2468 'J01350 FLUOROURACIL-LEUCOVORIN'
             2469 'J01353 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE'
             2470 'J01354 CARPROFEN'
             2471 'J01355 RIFAMPIN/ISONIAZID/PYRAZINAMIDE/ETHAMBUTOL'
             2472 'J01356 THALLIUM' 2473 'J01357 POLYMYXIN B OTIC'
             2474 'J01358 ALLANTOIN/PRAMOXINE'
             2475 'J01359 COCAINE/MARIJUANA/FORMALDEHYDE'
             2476 'J01360 COCAINE/OPIUM'
            2477 'J01361 CYCLOPHOSPHAMIDE/DOXORUBICIN/VINCRISTINE/PREDNISONE'
             2478 'J01362 DIPHTHERIA/PERTUSISIS/POLIO/HAEMOPHILUS/TETANUS'
             2479 'J01363 ETORICOXIB' 2480 'J01365 FLUPENTHIXOL'
             2481 'J01366 FUSIDIC ACID' 2482 'J01367 HEROIN/METHAMPHETAMINE'
             2483 'J01368 IODINE CONTRAST AGENT'
             2484 'J01369 MARIJUANA/LYSERGIC ACID DIETHYLAMIDE'
             2485 'J01370 METHYLENEDIOXYMETHAMPHETAMINE/PSILOCYBIN'
             2486 'J01371 NEOMYCIN-POLYMYXIN B SULFATE OTIC'
             2487 'J01372 OXALIPLATIN/FLUOROURACIL/LEUCOVORIN'
             2488 'J01373 PHOSPHORUS'
             2489 'J01375 ADRENERGIC BRONCHODILATORS-NOS'
             2490 'J01379 OMEGA-6 POLYUNSATURATED FATTY ACIDS'
             2491 'J01380 TOPICAL ANTIFUNGALS-NOS'
             2492 'J01382 DEXTROMETHORPHAN COMBINATIONS-NOS'
             2493 'J01383 CLENBUTEROL' 2494 'J01386 FENTANYL/HEROIN'
             2495 'J01387 SULFONYLUREAS-NOS'
             2496 'J01388 COCAINE/FORMALDEHYDE'
             2497 'J01389 COCAINE/METHYLENEDIOXYMETHAMPHETAMINE'
             2498 'J01390 CYPROTEREONE ACETATE-ETHINYL ESTRADIOL'
             2499 'J01391 FAT DISSOLVING AGENTS-NOS'
             2500 'J01392 HEROIN/METHYLENEDIOXYMETHAMPHETAMINE'
             2501 'J01393 PROPOLIS' 2502 'J01394 SENNA COMBINATIONS-NOS'
             2503 'J01395 FENFLURAMINE/PHENTERMINE'
             2504 'J01396 ACNE AGENTS-NOS' 2505 'J01401 CLONIXIN'
             2506 'J01404 PROGESTINS-NOS' 2507 'J01405 RABIES VACCINE-NOS'
             2508 'J01411 INFLUENZA VIRUS VACCINE, H1N1-NOS'
             2509 'J01412 ACAI BERRY' 2510 'J01413 ALUM'
             2511 'J01414 AMMONIA' 2512 'J01415 BENZYLPIPERAZINE'
             2513 'J01416 BLUE GREEN ALGAE'
  2514 'J01417 CYCLOPHOSPHAMIDE/DOXORUBICIN/RITUXIMAB/VINCRISTINE/PREDNISONE'
             2515 'J01418 HOODIA' 2516 'J01419 HYALURONIC ACID'
             2517 'J01420 PAPAVERINE/PHENTOLAMINE' 2518 'J01421 STATIN-NOS'
             2519 'J01422 TEA TREE OIL'
             2520 'J01423 TRIFLUOROMETHYLPHENYLPIPERAZINE'
             2521 'J01424 4-METHYLMETHCATHINONE' 2522 'J01426 PHENAZEPAM'
             2523 'J01427 4-BROMO-3,6-DIMETHOXYBENZOCYCLOBUTEN'
             2524 'J01428 SYNTHETIC CANNABINOID' 2525 'J01429 AFATINIB'
             2526 'J01430 AMPHETAMINE/MARIJUANA' 2527 'J01431 AXITINIB'
             2528 'J01432 BLEOMYCIN/DACARBAZINE/DOXORUBICIN/VINBLASTINE'
             2529 'J01433 CAFFEINE COMBINATIONS-NOS'
             2530 'J01434 CAPECITABINE/OXALIPLATIN'
             2531 'J01435 COLLOIDAL SILVER'
             2532 'J01436 DOCETAXEL/FLUOROURACIL/OXALIPLATIN'
             2533 'J01437 DOMPERIDONE'
             2534 'J01438 FLUOROURACIL/IRINOTECAN/LEUCOVORIN'
             2535 'J01439 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE/RITUXIMAB'
             2536 'J01440 KETAMINE/MARIJUANA'
             2537 'J01441 L-TRYPTOPHAN/MELATONIN'
             2538 'J01442 MARIJUANA/OXYCODONE' 2539 'J01443 METAMIZOLE'
             2540 'J01444 3,4-METHYLENEDIOXYPYROVALERONE'
             2541 'J01445 PANOBINOSTAT' 2542 'J01446 PROBIOTICS-NOS'
             2543 'J01447 SPERMICIDES-NOS' 2544 'J01448 TILMICOSIN'
             2545 'J01449 AMPHETAMINES-NOS'
             2546 'J01450 ILLICIT COMBINATIONS-NOS' 2547 'J01451 VITAMIN D'
             2548 'J01454 TRENBOLONE'
             2549 'J01455 H. PYLORI ERADICATION AGENTS-NOS'
             2550 'J01456 SMOKING CESSATION AGENTS-NOS'
             2551 'J01457 4-BROMO-2,5-DIMETHOXYAMPHETAMINE'
             2552 'J01458 PROTEASE INHIBITORS-NOS'
             2553 'J01459 4-METHOXYMETHCATHINONE' 2554 'J01460 ELASTIN'
             2555 'J01461 TALCUM POWDER TOPICAL'
             2556 'J01462 METHYLENEDIOXYMETHAMPHETAMINE/CAFFEINE'
             2557 'J01463 ENERGY DRINK'
             2558 'J01464 CAFFEINE/MULTIVITAMIN NTA' /
   CATID_1_2 -7 'NOT APPLICABLE:(-7)' 1 'ANTI-INFECTIVES:(1)'
             20 'ANTINEOPLASTICS:(20)' 28 'BIOLOGICALS:(28)'
             40 'CARDIOVASCULAR AGENTS:(40)'
             57 'CENTRAL NERVOUS SYSTEM AGENTS:(57)'
             81 'COAGULATION MODIFIERS:(81)'
             87 'GASTROINTESTINAL AGENTS:(87)'
             97 'HORMONES/HORMONE MODIFIERS:(97)'
             105 'MISCELLANEOUS AGENTS:(105)'
             113 'GENITOURINARY TRACT AGENTS:(113)'
             115 'NUTRITIONAL PRODUCTS:(115)' 122 'RESPIRATORY AGENTS:(122)'
             133 'TOPICAL AGENTS:(133)' 153 'PLASMA EXPANDERS:(153)'
             218 'ALTERNATIVE MEDICINES:(218)'
             242 'PSYCHOTHERAPEUTIC AGENTS:(242)'
             254 'IMMUNOLOGIC AGENTS:(254)' 331 'RADIOLOGIC AGENTS:(331)'
             358 'METABOLIC AGENTS:(358)' 365 'MEDICAL GAS:(365)'
             2006 'DRUG UNKNOWN:(2006)' 2041 'NON-PHARMACEUTICAL:(2041)' /
   CATID_2_2 -7 'NOT APPLICABLE:(-7)' 2 'AMEBICIDES:(2)'
             3 'ANTHELMINTICS:(3)' 4 'ANTIFUNGALS:(4)'
             5 'ANTIMALARIAL AGENTS:(5)' 6 'ANTITUBERCULOSIS AGENTS:(6)'
             7 'ANTIVIRAL AGENTS:(7)' 8 'CARBAPENEMS:(8)'
             9 'CEPHALOSPORINS:(9)' 10 'LEPROSTATICS:(10)'
             11 'MACROLIDE DERIVATIVES:(11)'
             12 'MISCELLANEOUS ANTIBIOTICS:(12)' 13 'PENICILLINS:(13)'
             14 'QUINOLONES:(14)' 15 'SULFONAMIDES:(15)'
             16 'TETRACYCLINES:(16)' 17 'URINARY ANTI-INFECTIVES:(17)'
             18 'AMINOGLYCOSIDES:(18)' 19 'ANTIHYPERLIPIDEMIC AGENTS:(19)'
             21 'ALKYLATING AGENTS:(21)' 22 'ANTINEOPLASTIC ANTIBIOTICS:(22)'
             23 'ANTIMETABOLITES:(23)' 24 'ANTINEOPLASTIC HORMONES:(24)'
             25 'MISCELLANEOUS ANTINEOPLASTICS:(25)'
             26 'MITOTIC INHIBITORS:(26)' 27 'RADIOPHARMACEUTICALS:(27)'
             30 'ANTITOXINS AND ANTIVENINS:(30)' 33 'IMMUNE GLOBULINS:(33)'
             34 'IN VIVO DIAGNOSTIC BIOLOGICALS:(34)'
             36 'RECOMBINANT HUMAN ERYTHROPOIETINS:(36)'
             41 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(41)'
             42 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(42)'
             43 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(43)'
             44 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(44)'
             45 'ANTIANGINAL AGENTS:(45)' 46 'ANTIARRHYTHMIC AGENTS:(46)'
             47 'BETA-ADRENERGIC BLOCKING AGENTS:(47)'
             48 'CALCIUM CHANNEL BLOCKING AGENTS:(48)' 49 'DIURETICS:(49)'
             50 'INOTROPIC AGENTS:(50)'
             51 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(51)'
             52 'PERIPHERAL VASODILATORS:(52)' 53 'VASODILATORS:(53)'
             54 'VASOPRESSORS:(54)' 55 'ANTIHYPERTENSIVE COMBINATIONS:(55)'
             56 'ANGIOTENSIN II INHIBITORS:(56)' 58 'ANALGESICS:(58)'
             64 'ANTICONVULSANTS:(64)'
             65 'ANTIEMETIC/ANTIVERTIGO AGENTS:(65)'
             66 'ANTIPARKINSON AGENTS:(66)'
             67 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(67)'
             71 'CNS STIMULANTS:(71)' 72 'GENERAL ANESTHETICS:(72)'
             73 'MUSCLE RELAXANTS:(73)'
             80 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(80)'
             82 'ANTICOAGULANTS:(82)' 83 'ANTIPLATELET AGENTS:(83)'
             84 'HEPARIN ANTAGONISTS:(84)'
             85 'MISCELLANEOUS COAGULATION MODIFIERS:(85)'
             86 'THROMBOLYTICS:(86)' 88 'ANTACIDS:(88)'
             90 'ANTIDIARRHEALS:(90)' 91 'DIGESTIVE ENZYMES:(91)'
             92 'GALLSTONE SOLUBILIZING AGENTS:(92)' 93 'GI STIMULANTS:(93)'
             94 'H2 ANTAGONISTS:(94)' 95 'LAXATIVES:(95)'
             96 'MISCELLANEOUS GI AGENTS:(96)'
             98 'ADRENAL CORTICAL STEROIDS:(98)'
             99 'ANTIDIABETIC AGENTS:(99)' 100 'MISCELLANEOUS HORMONES:(100)'
             101 'SEX HORMONES:(101)' 103 'THYROID HORMONES:(103)'
             104 'IMMUNOSUPPRESSIVE AGENTS:(104)' 106 'ANTIDOTES:(106)'
             107 'CHELATING AGENTS:(107)'
             108 'CHOLINERGIC MUSCLE STIMULANTS:(108)'
             109 'LOCAL INJECTABLE ANESTHETICS:(109)'
             110 'MISCELLANEOUS UNCATEGORIZED AGENTS:(110)'
             111 'PSORALENS:(111)' 112 'RADIOCONTRAST AGENTS:(112)'
             114 'ILLICIT (STREET) DRUGS:(114)' 116 'IRON PRODUCTS:(116)'
             117 'MINERALS AND ELECTROLYTES:(117)'
             118 'ORAL NUTRITIONAL SUPPLEMENTS:(118)' 119 'VITAMINS:(119)'
             120 'VITAMIN AND MINERAL COMBINATIONS:(120)'
             121 'INTRAVENOUS NUTRITIONAL PRODUCTS:(121)'
             123 'ANTIHISTAMINES:(123)' 124 'ANTITUSSIVES:(124)'
             125 'BRONCHODILATORS:(125)' 127 'DECONGESTANTS:(127)'
             128 'EXPECTORANTS:(128)'
             129 'MISCELLANEOUS RESPIRATORY AGENTS:(129)'
             130 'RESPIRATORY INHALANT PRODUCTS:(130)'
             131 'ANTIASTHMATIC COMBINATIONS:(131)'
             132 'UPPER RESPIRATORY COMBINATIONS:(132)'
             134 'ANORECTAL PREPARATIONS:(134)'
             135 'ANTISEPTIC AND GERMICIDES:(135)'
             136 'DERMATOLOGICAL AGENTS:(136)'
             146 'MOUTH AND THROAT PRODUCTS:(146)'
             147 'OPHTHALMIC PREPARATIONS:(147)'
             148 'OTIC PREPARATIONS:(148)'
             150 'STERILE IRRIGATING SOLUTIONS:(150)'
             151 'VAGINAL PREPARATIONS:(151)' 192 'ANTIRHEUMATICS:(192)'
             194 'ANTIGOUT AGENTS:(194)' 219 'NUTRACEUTICAL PRODUCTS:(219)'
             220 'HERBAL PRODUCTS:(220)' 240 'LINCOMYCIN DERIVATIVES:(240)'
             243 'LEUKOTRIENE MODIFIERS:(243)' 247 'NASAL PREPARATIONS:(247)'
             249 'ANTIDEPRESSANTS:(249)' 251 'ANTIPSYCHOTICS:(251)'
             253 'ANOREXIANTS:(253)' 263 'IMPOTENCE AGENTS:(263)'
             264 'URINARY ANTISPASMODICS:(264)'
             265 'URINARY PH MODIFIERS:(265)'
             266 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(266)'
             270 'ANTIPSORIATICS:(270)' 272 'PROTON PUMP INHIBITORS:(272)'
             273 'LUNG SURFACTANTS:(273)' 277 '5-AMINOSALICYLATES:(277)'
             284 'VISCOSUPPLEMENTATION AGENTS:(284)'
             288 '5-ALPHA-REDUCTASE INHIBITORS:(288)'
             289 'ANTIHYPERURICEMIC AGENTS:(289)'
             293 'GLUCOSE ELEVATING AGENTS:(293)' 295 'GROWTH HORMONES:(295)'
             303 'AGENTS FOR PULMONARY HYPERTENSION:(303)'
             312 'CHOLINERGIC AGONISTS:(312)'
             313 'CHOLINESTERASE INHIBITORS:(313)' 315 'GLYCYLCYCLINES:(315)'
             318 'INSULIN-LIKE GROWTH FACTOR:(318)'
             319 'VASOPRESSIN ANTAGONISTS:(319)'
             320 'SMOKING CESSATION AGENTS:(320)'
             324 'ANTINEOPLASTIC INTERFERONS:(324)'
             325 'SCLEROSING AGENTS:(325)' 332 'RADIOLOGIC ADJUNCTS:(332)'
             340 'ALDOSTERONE RECEPTOR ANTAGONISTS:(340)'
             342 'RENIN INHIBITORS:(342)'
             354 'H. PYLORI ERADICATION AGENTS:(354)'
             355 'FUNCTIONAL BOWEL DISORDER AGENTS:(355)'
             357 'GROWTH HORMONE RECEPTOR BLOCKERS:(357)'
             359 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(359)'
             360 'LYSOSOMAL ENZYMES:(360)'
             361 'MISCELLANEOUS METABOLIC AGENTS:(361)'
             363 'PROBIOTICS:(363)' 377 'PROLACTIN INHIBITORS:(377)'
             378 'DRUGS USED IN ALCOHOL DEPENDENCE:(378)'
             383 'ANTINEOPLASTIC DETOXIFYING AGENTS:(383)'
             384 'PLATELET-STIMULATING AGENTS:(384)'
             390 'HEMATOPOIETIC STEM CELL MOBILIZER:(390)'
             397 'MULTIKINASE INHIBITORS:(397)'
             398 'BCR-ABL TYROSINE KINASE INHIBITORS:(398)'
             399 'CD52 MONOCLONAL ANTIBODIES:(399)'
             400 'CD33 MONOCLONAL ANTIBODIES:(400)'
             401 'CD20 MONOCLONAL ANTIBODIES:(401)'
             402 'VEGF/VEGFR INHIBITORS:(402)' 403 'MTOR INHIBITORS:(403)'
             404 'EGFR INHIBITORS:(404)' 405 'HER2 INHIBITORS:(405)'
             406 'GLYCOPEPTIDE ANTIBIOTICS:(406)'
             408 'HISTONE DEACETYLASE INHIBITORS:(408)'
             409 'BONE RESORPTION INHIBITORS:(409)'
             410 'ADRENAL CORTICOSTEROID INHIBITORS:(410)'
             411 'CALCITONIN:(411)' 412 'UTEROTONIC AGENTS:(412)'
             413 'ANTIGONADOTROPIC AGENTS:(413)'
             414 'ANTIDIURETIC HORMONES:(414)'
             416 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(416)'
             417 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(417)'
             418 'PARATHYROID HORMONE AND ANALOGS:(418)'
             419 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(419)'
             422 'ANTITHYROID AGENTS:(422)'
             426 'SYNTHETIC OVULATION STIMULANTS:(426)'
             427 'TOCOLYTIC AGENTS:(427)'
             428 'PROGESTERONE RECEPTOR MODULATORS:(428)'
             431 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(431)'
             433 'CATECHOLAMINES:(433)'
             435 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(435)'
             437 'IMMUNOSTIMULANTS:(437)'
             447 'CD30 MONOCLONAL ANTIBODIES:(447)' 2042 'INHALANT:(2042)'
             2051 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(2051)' /
   CATID_3_2 -7 'NOT APPLICABLE:(-7)' 31 'BACTERIAL VACCINES:(31)'
             32 'COLONY STIMULATING FACTORS:(32)' 38 'VIRAL VACCINES:(38)'
             61 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(61)'
             68 'BARBITURATES:(68)' 69 'BENZODIAZEPINES:(69)'
             70 'MISCELLANEOUS ANXIOLYTICS, SEDATIVES AND HYPNOTICS:(70)'
             74 'NEUROMUSCULAR BLOCKING AGENTS:(74)'
             76 'MISCELLANEOUS ANTIDEPRESSANTS:(76)'
             77 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(77)'
             79 'PSYCHOTHERAPEUTIC COMBINATIONS:(79)'
             89 'ANTICHOLINERGICS/ANTISPASMODICS:(89)'
             102 'CONTRACEPTIVES:(102)' 126 'METHYLXANTHINES:(126)'
             137 'TOPICAL ANTI-INFECTIVES:(137)' 138 'TOPICAL STEROIDS:(138)'
             139 'TOPICAL ANESTHETICS:(139)'
             140 'MISCELLANEOUS TOPICAL AGENTS:(140)'
             141 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(141)'
             143 'TOPICAL ACNE AGENTS:(143)'
             144 'TOPICAL ANTIPSORIATICS:(144)' 149 'SPERMICIDES:(149)'
             154 'LOOP DIURETICS:(154)'
             155 'POTASSIUM-SPARING DIURETICS:(155)'
             156 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(156)'
             157 'CARBONIC ANHYDRASE INHIBITORS:(157)'
             158 'MISCELLANEOUS DIURETICS:(158)'
             159 'FIRST GENERATION CEPHALOSPORINS:(159)'
             160 'SECOND GENERATION CEPHALOSPORINS:(160)'
             161 'THIRD GENERATION CEPHALOSPORINS:(161)'
             162 'FOURTH GENERATION CEPHALOSPORINS:(162)'
             163 'OPHTHALMIC ANTI-INFECTIVES:(163)'
             164 'OPHTHALMIC GLAUCOMA AGENTS:(164)'
             165 'OPHTHALMIC STEROIDS:(165)'
             166 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(166)'
             167 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(167)'
             168 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(168)'
             169 'MISCELLANEOUS OPHTHALMIC AGENTS:(169)'
             170 'OTIC ANTI-INFECTIVES:(170)'
             171 'OTIC STEROIDS WITH ANTI-INFECTIVES:(171)'
             172 'MISCELLANEOUS OTIC AGENTS:(172)'
             173 'HMG-COA REDUCTASE INHIBITORS:(173)'
             174 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(174)'
             175 'PROTEASE INHIBITORS:(175)' 176 'NRTIS:(176)'
             177 'MISCELLANEOUS ANTIVIRALS:(177)'
             178 'SKELETAL MUSCLE RELAXANTS:(178)'
             179 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(179)'
             180 'ADRENERGIC BRONCHODILATORS:(180)'
             181 'BRONCHODILATOR COMBINATIONS:(181)'
             182 'ANDROGENS AND ANABOLIC STEROIDS:(182)'
             183 'ESTROGENS:(183)' 184 'GONADOTROPINS:(184)'
             185 'PROGESTINS:(185)' 186 'SEX HORMONE COMBINATIONS:(186)'
             187 'MISCELLANEOUS SEX HORMONES:(187)'
             193 'ANTIMIGRAINE AGENTS:(193)'
             195 '5HT3 RECEPTOR ANTAGONISTS:(195)'
             196 'PHENOTHIAZINE ANTIEMETICS:(196)'
             197 'ANTICHOLINERGIC ANTIEMETICS:(197)'
             198 'MISCELLANEOUS ANTIEMETICS:(198)'
             199 'HYDANTOIN ANTICONVULSANTS:(199)'
             200 'SUCCINIMIDE ANTICONVULSANTS:(200)'
             201 'BARBITURATE ANTICONVULSANTS:(201)'
             202 'OXAZOLIDINEDIONE ANTICONVULSANTS:(202)'
             203 'BENZODIAZEPINE ANTICONVULSANTS:(203)'
             204 'MISCELLANEOUS ANTICONVULSANTS:(204)'
             205 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(205)'
             206 'MISCELLANEOUS ANTIPARKINSON AGENTS:(206)'
             208 'SSRI ANTIDEPRESSANTS:(208)'
             209 'TRICYCLIC ANTIDEPRESSANTS:(209)'
             210 'PHENOTHIAZINE ANTIPSYCHOTICS:(210)'
             211 'PLATELET AGGREGATION INHIBITORS:(211)'
             212 'GLYCOPROTEIN PLATELET INHIBITORS:(212)'
             213 'SULFONYLUREAS:(213)' 214 'BIGUANIDES:(214)'
             215 'INSULIN:(215)' 216 'ALPHA-GLUCOSIDASE INHIBITORS:(216)'
             217 'BISPHOSPHONATES:(217)'
             222 'PENICILLINASE RESISTANT PENICILLINS:(222)'
             223 'ANTIPSEUDOMONAL PENICILLINS:(223)'
             224 'AMINOPENICILLINS:(224)'
             225 'BETA-LACTAMASE INHIBITORS:(225)'
             226 'NATURAL PENICILLINS:(226)' 227 'NNRTIS:(227)'
             228 'ADAMANTANE ANTIVIRALS:(228)' 229 'PURINE NUCLEOSIDES:(229)'
             230 'AMINOSALICYLATES:(230)'
             231 'NICOTINIC ACID DERIVATIVES:(231)'
             232 'RIFAMYCIN DERIVATIVES:(232)'
             233 'STREPTOMYCES DERIVATIVES:(233)'
             234 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(234)'
             235 'POLYENES:(235)' 236 'AZOLE ANTIFUNGALS:(236)'
             237 'MISCELLANEOUS ANTIFUNGALS:(237)'
             238 'ANTIMALARIAL QUINOLINES:(238)'
             239 'MISCELLANEOUS ANTIMALARIALS:(239)'
             241 'FIBRIC ACID DERIVATIVES:(241)'
             244 'NASAL LUBRICANTS AND IRRIGATIONS:(244)'
             245 'NASAL STEROIDS:(245)'
             246 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(246)'
             248 'TOPICAL EMOLLIENTS:(248)'
             250 'MONOAMINE OXIDASE INHIBITORS:(250)'
             252 'BILE ACID SEQUESTRANTS:(252)' 256 'INTERFERONS:(256)'
             261 'HEPARINS:(261)' 262 'COUMARINS AND INDANEDIONES:(262)'
             267 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(267)'
             268 'VAGINAL ANTI-INFECTIVES:(268)'
             269 'MISCELLANEOUS VAGINAL AGENTS:(269)'
             271 'THIAZOLIDINEDIONES:(271)'
             274 'CARDIOSELECTIVE BETA BLOCKERS:(274)'
             275 'NON-CARDIOSELECTIVE BETA BLOCKERS:(275)'
             276 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(276)'
             278 'COX-2 INHIBITORS:(278)'
             279 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(279)'
             280 'THIOXANTHENES:(280)' 281 'NEURAMINIDASE INHIBITORS:(281)'
             282 'MEGLITINIDES:(282)' 283 'THROMBIN INHIBITORS:(283)'
             285 'FACTOR XA INHIBITORS:(285)' 286 'MYDRIATICS:(286)'
             287 'OPHTHALMIC ANESTHETICS:(287)'
             290 'TOPICAL ANTIBIOTICS:(290)' 291 'TOPICAL ANTIVIRALS:(291)'
             292 'TOPICAL ANTIFUNGALS:(292)'
             296 'INHALED CORTICOSTEROIDS:(296)' 297 'MUCOLYTICS:(297)'
             298 'MAST CELL STABILIZERS:(298)'
             299 'ANTICHOLINERGIC BRONCHODILATORS:(299)'
             300 'CORTICOTROPIN:(300)' 301 'GLUCOCORTICOIDS:(301)'
             302 'MINERALOCORTICOIDS:(302)' 304 'MACROLIDES:(304)'
             305 'KETOLIDES:(305)'
             306 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(306)'
             307 'TETRACYCLIC ANTIDEPRESSANTS:(307)'
             308 'SSNRI ANTIDEPRESSANTS:(308)'
             309 'MISCELLANEOUS ANTIDIABETIC AGENTS:(309)'
             310 'ECHINOCANDINS:(310)'
             311 'DIBENZAZEPINE ANTICONVULSANTS:(311)'
             314 'ANTIDIABETIC COMBINATIONS:(314)'
             316 'CHOLESTEROL ABSORPTION INHIBITORS:(316)'
             317 'ANTIHYPERLIPIDEMIC COMBINATIONS:(317)'
             321 'OPHTHALMIC DIAGNOSTIC AGENTS:(321)'
             322 'OPHTHALMIC SURGICAL AGENTS:(322)'
             327 'ANTIVIRAL COMBINATIONS:(327)'
             328 'ANTIMALARIAL COMBINATIONS:(328)'
             329 'ANTITUBERCULOSIS COMBINATIONS:(329)'
             330 'ANTIVIRAL INTERFERONS:(330)'
             333 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(333)'
             334 'LYMPHATIC STAINING AGENTS:(334)'
             335 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(335)'
             336 'NON-IODINATED CONTRAST MEDIA:(336)'
             337 'ULTRASOUND CONTRAST MEDIA:(337)'
             338 'DIAGNOSTIC RADIOPHARMACEUTICALS:(338)'
             339 'THERAPEUTIC RADIOPHARMACEUTICALS:(339)'
             341 'ATYPICAL ANTIPSYCHOTICS:(341)'
             345 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(345)'
             346 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(346)'
             347 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(347)'
             348 'TRIAZINE ANTICONVULSANTS:(348)'
             349 'CARBAMATE ANTICONVULSANTS:(349)'
             350 'PYRROLIDINE ANTICONVULSANTS:(350)'
             351 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(351)'
             352 'UREA ANTICONVULSANTS:(352)'
             353 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(353)'
             356 'SEROTONINERGIC NEUROENTERIC MODULATORS:(356)'
             362 'CHLORIDE CHANNEL ACTIVATORS:(362)'
             364 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(364)'
             366 'INTEGRASE STRAND TRANSFER INHIBITOR:(366)'
             368 'NON-IONIC IODINATED CONTRAST MEDIA:(368)'
             369 'IONIC IODINATED CONTRAST MEDIA:(369)'
             370 'OTIC STEROIDS:(370)'
             371 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(371)'
             372 'AMYLIN ANALOGS:(372)' 373 'INCRETIN MIMETICS:(373)'
             374 'CARDIAC STRESSING AGENTS:(374)'
             375 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(375)'
             379 'FIFTH GENERATION CEPHALOSPORINS:(379)'
             380 'TOPICAL DEBRIDING AGENTS:(380)'
             381 'TOPICAL DEPIGMENTING AGENTS:(381)'
             382 'TOPICAL ANTIHISTAMINES:(382)'
             385 'GROUP I ANTIARRHYTHMICS:(385)'
             387 'GROUP III ANTIARRHYTHMICS:(387)'
             389 'GROUP V ANTIARRHYTHMICS:(389)' 392 'OTIC ANESTHETICS:(392)'
             393 'CERUMENOLYTICS:(393)' 394 'TOPICAL ASTRINGENTS:(394)'
             395 'TOPICAL KERATOLYTICS:(395)'
             415 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(415)'
             432 'VACCINE COMBINATIONS:(432)'
             439 'OTHER IMMUNOSTIMULANTS:(439)'
             440 'THERAPEUTIC VACCINES:(440)'
             441 'CALCINEURIN INHIBITORS:(441)'
             442 'TNF ALFA INHIBITORS:(442)'
             443 'INTERLEUKIN INHIBITORS:(443)'
             444 'SELECTIVE IMMUNOSUPPRESSANTS:(444)'
             445 'OTHER IMMUNOSUPPRESSANTS:(445)'
             448 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(448)'
             2005 'ALCOHOL IN COMBINATION:(2005)'
             2007 'MISCELLANEOUS BRONCHODILATORS:(2007)'
             2008 'MISCELLANEOUS NASAL PREPARATIONS:(2008)'
             2030 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(2030)'
             2031 'MISCELLANEOUS HALLUCINOGENS:(2031)'
             2032 'ILLICIT MAJOR SUBSTANCE OF ABUSE:(2032)'
             2033 'ILLICIT COMBINATIONS:(2033)'
             2034 'ILLICIT AND OTHER COMBINATIONS:(2034)'
             2036 'MISCELLANEOUS CEPHALOSPORINS:(2036)'
             2043 'VOLATILE AGENT:(2043)' 2044 'NITRITES:(2044)'
             2045 'CHLORO-FLUORO-HYDROCARBONS:(2045)'
             2046 'MISCELLANEOUS MUSCLE RELAXANTS:(2046)'
             2047 'NARCOTIC ANALGESICS/COMBINATIONS:(2047)'
             2048 'SALICYLATES/COMBINATIONS:(2048)'
             2049 'MISCELLANEOUS ANALGESIC/COMBINATIONS:(2049)'
             2050 'ANALGESIC COMBINATIONS NTA:(2050)'
             2052 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(2052)'
             2053 'MISCELLANEOUS MACROLIDE:(2053)'
             2054 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(2054)'
             2055 'MISCELLANEOUS RADIOCONTRAST AGENTS:(2055)'
             2056 'MISCELLANEOUS RADIOPHARMACEUTICALS:(2056)' /
   ROUTE_2   -9 'MISSING:(-9)' -8 'NOT DOCUMENTED:(-8)'
             -7 'NOT APPLICABLE:(-7)' 1 'ORAL:(1)' 2 'INJECTED:(2)'
             3 'INHALED, SNIFFED, SNORTED:(3)' 4 'SMOKED:(4)' 5 'OTHER:(5)'
             6 'TRANSDERMAL:(6)' 98 'MULTIPLE ROUTES FOR THIS DRUG:(98)' /
   TOXTEST_2 -9 'MISSING:(-9)' -7 'NOT APPLICABLE:(-7)'
             1 'CONFIRMED TEST:(1)' 2 'NOT CONFIRMED:(2)' /
   SDLED_1_2 -7 'NOT APPLICABLE:(-7)' 1 'MAJOR SUBSTANCES OF ABUSE:(1)'
             17 'OTHER SUBSTANCES:(17)' /
   SDLED_2_2 -7 'NOT APPLICABLE:(-7)' 2 'ALCOHOL:(2)'
             2.5 'NON-ALCOHOL ILLICITS:(2.5)'
             18 'PSYCHOTHERAPEUTIC AGENTS:(18)' 33 'CNS AGENTS:(33)'
             50 'RESPIRATORY AGENTS:(50)' 57 'CARDIOVASCULAR AGENTS:(57)'
             63 'ALTERNATIVE MEDICINES:(63)' 64 'ANTI-INFECTIVES:(64)'
             65 'ANTINEOPLASTICS:(65)' 66 'BIOLOGICALS:(66)'
             67 'COAGULATION MODIFIERS:(67)'
             68 'GASTROINTESTINAL AGENTS:(68)'
             69 'GENITOURINARY TRACT AGENTS:(69)' 70 'HORMONES:(70)'
             71 'IMMUNOLOGIC AGENTS:(71)' 72 'MEDICAL GAS:(72)'
             73 'METABOLIC AGENTS:(73)' 74 'MISCELLANEOUS AGENTS:(74)'
             75 'NUTRITIONAL PRODUCTS:(75)' 76 'PLASMA EXPANDERS:(76)'
             77 'RADIOLOGIC AGENTS:(77)' 78 'TOPICAL AGENTS:(78)'
             79 'DRUG UNKNOWN:(79)' /
   SDLED_3_2 -7 'NOT APPLICABLEL:(-7.00)' 3 'COCAINE:(3)' 4 'HEROIN:(4)'
             5 'CANNABINOIDS:(5)' 5.5 'STIMULANTS:(5.5)'
             8 'MDMA (ECSTASY):(8)' 8.1 'GHB:(8.1)'
             8.2 'FLUNITRAZEPAM (ROHYPNOL):(8.2)' 9 'KETAMINE:(9)'
             10 'LSD:(10)' 11 'PCP:(11)'
             12 'MISCELLANEOUS HALLUCINOGENS:(12)' 15 'INHALANTS:(15)'
             16 'COMBINATIONS NTA:(16)' 19 'ANTIDEPRESSANTS:(19)'
             24 'ANTIPSYCHOTICS:(24)' 34 'ANALGESICS:(34)'
             43 'ANOREXIANTS:(43)' 44 'ANTICONVULSANTS:(44)'
             45 'ANTIEMETIC/ANTIVERTIGO AGENTS:(45)'
             46 'ANTIPARKINSON AGENTS:(46)'
             46.3 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.3)'
             46.5 'CNS STIMULANTS:(46.5)'
             46.7 'DRUGS USED IN ALCOHOL DEPENDENCE:(46.7)'
             47 'GENERAL ANESTHETICS:(47)' 48 'MUSCLE RELAXANTS:(48)'
             49 'MISCELLANEOUS CNS AGENTS:(49)' 51 'ANTIHISTAMINES:(51)'
             52 'BRONCHODILATORS:(52)' 53 'DECONGESTANTS:(53)'
             54 'EXPECTORANTS:(54)'
             54.5 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(54.5)'
             55 'UPPER RESPIRATORY COMBINATIONS:(55)'
             56 'RESPIRATORY AGENTS NTA:(56)'
             58 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(58)'
             59 'BETA-ADRENERGIC BLOCKING AGENTS:(59)'
             60 'CALCIUM CHANNEL BLOCKING AGENTS:(60)' 61 'DIURETICS:(61)'
             61.3 'RENIN INHIBITORS:(61.3)'
             61.5 'VASOPRESSIN ANTAGONISTS:(61.5)'
             62 'CARDIOVASCULAR AGENTS NTA:(62)'
             63.1 'HERBAL PRODUCTS:(63.1)'
             63.2 'NUTRACEUTICAL PRODUCTS:(63.2)' 63.3 'PROBIOTICS:(63.3)'
             64.01 'AMEBICIDES:(64.01)' 64.02 'AMINOGLYCOSIDES:(64.02)'
             64.03 'ANTHELMINTICS:(64.03)' 64.04 'ANTIFUNGALS:(64.04)'
             64.05 'ANTIMALARIAL AGENTS:(64.05)'
             64.06 'ANTITUBERCULOSIS AGENTS:(64.06)'
             64.07 'ANTIVIRAL AGENTS:(64.07)' 64.08 'CARBAPENEMS:(64.08)'
             64.09 'CEPHALOSPORINS:(64.09)'
             64.1 'GLYCOPEPTIDE ANTIBIOTICS:(64.1)'
             64.11 'GLYCYLCYCLINES:(64.11)' 64.12 'LEPROSTATICS:(64.12)'
             64.13 'LINCOMYCIN DERIVATIVES:(64.13)'
             64.14 'MACROLIDE DERIVATIVES:(64.14)'
             64.15 'PENICILLINS:(64.15)' 64.16 'QUINOLONES:(64.16)'
             64.17 'SULFONAMIDES:(64.17)' 64.18 'TETRACYCLINES:(64.18)'
             64.19 'URINARY ANTI-INFECTIVES:(64.19)'
             64.99 'MISCELLANEOUS ANTIBIOTICS:(64.99)'
             65.01 'ALKYLATING AGENTS:(65.01)'
             65.02 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(65.02)'
             65.03 'ANTIMETABOLITES:(65.03)'
             65.04 'ANTINEOPLASTIC ANTIBIOTICS:(65.04)'
             65.05 'ANTINEOPLASTIC DETOXIFYING AGENTS:(65.05)'
             65.06 'ANTINEOPLASTIC HORMONES:(65.06)'
             65.07 'ANTINEOPLASTIC INTERFERONS:(65.07)'
             65.08 'BCR-ABL TYROSINE KINASE INHIBITORS:(65.08)'
             65.09 'CD20 MONOCLONAL ANTIBODIES:(65.09)'
             65.11 'CD33 MONOCLONAL ANTIBODIES:(65.11)'
             65.12 'CD52 MONOCLONAL ANTIBODIES:(65.12)'
             65.13 'EGFR INHIBITORS:(65.13)' 65.14 'HER2 INHIBITORS:(65.14)'
             65.15 'HISTONE DEACETYLASE INHIBITORS:(65.15)'
             65.16 'MITOTIC INHIBITORS:(65.16)'
             65.17 'MTOR INHIBITORS:(65.17)'
             65.18 'MULTIKINASE INHIBITORS:(65.18)'
             65.2 'VEGF/VEGFR INHIBITORS:(65.2)'
             65.99 'MISCELLANEOUS ANTINEOPLASTICS:(65.99)'
             66.01 'ANTITOXINS AND ANTIVENINS:(66.01)'
             66.04 'IN VIVO DIAGNOSTIC BIOLOGICALS:(66.04)'
             66.05 'RECOMBINANT HUMAN ERYTHROPOIETINS:(66.05)'
             67.01 'ANTICOAGULANTS:(67.01)'
             67.02 'ANTIPLATELET AGENTS:(67.02)'
             67.03 'HEPARIN ANTAGONISTS:(67.03)'
             67.04 'PLATELET-STIMULATING AGENTS:(67.04)'
             67.05 'THROMBOLYTICS:(67.05)'
             67.06 'MISCELLANEOUS COAGULATION MODIFIERS:(67.06)'
             68.01 '5-AMINOSALICYLATES:(68.01)' 68.02 'ANTACIDS:(68.02)'
             68.04 'ANTIDIARRHEALS:(68.04)' 68.05 'DIGESTIVE ENZYMES:(68.05)'
             68.06 'FUNCTIONAL BOWEL DISORDER AGENTS:(68.06)'
             68.07 'GALLSTONE SOLUBILIZING AGENTS:(68.07)'
             68.08 'GI STIMULANTS:(68.08)'
             68.09 'H. PYLORI ERADICATION AGENTS:(68.09)'
             68.1 'H2 ANTAGONISTS:(68.1)' 68.11 'LAXATIVES:(68.11)'
             68.12 'PROTON PUMP INHIBITORS:(68.12)'
             68.13 'MISCELLANEOUS GI AGENTS:(68.13)'
             69.01 'IMPOTENCE AGENTS:(69.01)'
             69.02 'TOCOLYTIC AGENTS:(69.02)'
             69.03 'URINARY ANTISPASMODICS:(69.03)'
             69.04 'URINARY PH MODIFIERS:(69.04)'
             69.05 'UTEROTONIC AGENTS:(69.05)'
             69.99 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(69.99)'
             70.01 '5-ALPHA-REDUCTASE INHIBITORS:(70.01)'
             70.02 'ADRENAL CORTICAL STEROIDS:(70.02)'
             70.05 'ANTIDIURETIC HORMONES:(70.05)'
             70.06 'ANTIGONADOTROPIC AGENTS:(70.06)'
             70.07 'ANTITHYROID AGENTS:(70.07)' 70.09 'CALCITONIN:(70.09)'
             70.11 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(70.11)'
             70.12 'GROWTH HORMONE RECEPTOR BLOCKERS:(70.12)'
             70.13 'GROWTH HORMONES:(70.13)'
             70.15 'INSULIN-LIKE GROWTH FACTOR:(70.15)'
             70.16 'PARATHYROID HORMONE AND ANALOGS:(70.16)'
             70.17 'PROGESTERONE RECEPTOR MODULATORS:(70.17)'
             70.18 'PROLACTIN INHIBITORS:(70.18)'
             70.19 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(70.19)'
             70.2 'SEX HORMONES:(70.2)'
             70.21 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(70.21)'
             70.22 'SYNTHETIC OVULATION STIMULANTS:(70.22)'
             70.23 'THYROID HORMONES:(70.23)'
             70.99 'MISCELLANEOUS HORMONES:(70.99)'
             71.01 'IMMUNE GLOBULINS:(71.01)'
             71.02 'IMMUNOSTIMULANTS:(71.02)'
             71.03 'IMMUNOSUPPRESSIVE AGENTS:(71.03)'
             71.99 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(71.99)'
             73.01 'ANTIDIABETIC AGENTS:(73.01)'
             73.02 'ANTIGOUT AGENTS:(73.02)'
             73.03 'ANTIHYPERLIPIDEMIC AGENTS:(73.03)'
             73.04 'ANTIHYPERURICEMIC AGENTS:(73.04)'
             73.05 'BONE RESORPTION INHIBITORS:(73.05)'
             73.06 'GLUCOSE ELEVATING AGENTS:(73.06)'
             73.07 'LYSOSOMAL ENZYMES:(73.07)'
             73.08 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(73.08)'
             73.99 'MISCELLANEOUS METABOLIC AGENTS:(73.99)'
             74.01 'ANTIDOTES:(74.01)' 74.04 'ANTIPSORIATICS:(74.04)'
             74.05 'ANTIRHEUMATICS:(74.05)' 74.06 'CHELATING AGENTS:(74.06)'
             74.07 'CHOLINERGIC MUSCLE STIMULANTS:(74.07)'
             74.11 'LOCAL INJECTABLE ANESTHETICS:(74.11)'
             74.13 'PSORALENS:(74.13)'
             74.17 'SMOKING CESSATION AGENTS:(74.17)'
             74.18 'VISCOSUPPLEMENTATION AGENTS:(74.18)'
             74.19 'MISCELLANEOUS UNCATEGORIZED AGENTS:(74.19)'
             75.01 'INTRAVENOUS NUTRITIONAL PRODUCTS:(75.01)'
             75.02 'IRON PRODUCTS:(75.02)'
             75.03 'MINERALS AND ELECTROLYTES:(75.03)'
             75.04 'ORAL NUTRITIONAL SUPPLEMENTS:(75.04)'
             75.05 'VITAMIN AND MINERAL COMBINATIONS:(75.05)'
             75.06 'VITAMINS:(75.06)' 77.01 'RADIOCONTRAST AGENTS:(77.01)'
             77.02 'RADIOLOGIC ADJUNCTS:(77.02)'
             77.03 'RADIOPHARMACEUTICALS:(77.03)'
             78.01 'ANORECTAL PREPARATIONS:(78.01)'
             78.02 'ANTISEPTIC AND GERMICIDES:(78.02)'
             78.03 'DERMATOLOGICAL AGENTS:(78.03)'
             78.04 'MOUTH AND THROAT PRODUCTS:(78.04)'
             78.05 'NASAL PREPARATIONS:(78.05)'
             78.06 'OPHTHALMIC PREPARATIONS:(78.06)'
             78.07 'OTIC PREPARATIONS:(78.07)'
             78.08 'STERILE IRRIGATING SOLUTIONS:(78.08)'
             78.09 'VAGINAL PREPARATIONS:(78.09)' /
   SDLED_4_2 -7 'NOT APPLICABLE:(-7.00)' 5.01 'MARIJUANA:(5.01)'
             5.02 'SYNTHETIC CANNABINOIDS:(5.02)' 6 'AMPHETAMINES:(6)'
             7 'METHAMPHETAMINE:(7)' 7.1 'OTHER STIMULANTS:(7.1)'
             20 'MAO INHIBITORS:(20)'
             20.4 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(20.4)'
             20.7 'SSNRI ANTIDEPRESSANTS:(20.7)'
             21 'SSRI ANTIDEPRESSANTS:(21)'
             21.5 'TETRACYCLIC ANTIDEPRESSANTS:(21.5)'
             22 'TRICYCLIC ANTIDEPRESSANTS:(22)'
             23 'MISCELLANEOUS ANTIDEPRESSANTS:(23)'
             25 'ATYPICAL ANTIPSYCHOTICS:(25)'
             26 'PHENOTHIAZINE ANTIPSYCHOTICS:(26)'
             26.5 'PSYCHOTHERAPEUTIC COMBINATIONS:(26.5)'
             26.7 'THIOXANTHENES:(26.7)'
             27 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(27)'
             35 'ANTIMIGRAINE AGENTS:(35)' 36 'COX-2 INHIBITORS:(36)'
             36.5 'OPIATES/OPIOIDS:(36.5)'
             39 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(39)'
             40.5 'SALICYLATES/COMBINATIONS:(40.5)'
             41.5 'MISCELLANEOUS ANALGESICS/COMBINATIONS:(41.5)'
             42.5 'ANALGESIC COMBINATIONS NTA:(42.5)'
             43.01 'PHENYLPROPANOLAMINE:(43.01)'
             43.02 'ANOREXIANTS-NOS:(43.02)' 43.09 'ANOREXIANTS NTA:(43.09)'
             44.01 'BARBITURATE ANTICONVULSANTS:(44.01)'
             44.02 'BENZODIAZEPINE ANTICONVULSANTS:(44.02)'
             44.03 'CARBAMATE ANTICONVULSANTS:(44.03)'
             44.04 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(44.04)'
             44.05 'DIBENZAZEPINE ANTICONVULSANTS:(44.05)'
             44.06 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(44.06)'
             44.07 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(44.07)'
             44.08 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(44.08)'
             44.09 'HYDANTOIN ANTICONVULSANTS:(44.09)'
             44.11 'OXAZOLIDINEDIONE ANTICONVULSANTS:(44.11)'
             44.12 'PYRROLIDINE ANTICONVULSANTS:(44.12)'
             44.13 'SUCCINIMIDE ANTICONVULSANTS:(44.13)'
             44.14 'TRIAZINE ANTICONVULSANTS:(44.14)'
             44.99 'MISCELLANEOUS ANTICONVULSANTS:(44.99)'
             45.01 '5HT3 RECEPTOR ANTAGONISTS:(45.01)'
             45.02 'ANTICHOLINERGIC ANTIEMETICS:(45.02)'
             45.03 'PHENOTHIAZINE ANTIEMETICS:(45.03)'
             45.04 'MISCELLANEOUS ANTIEMETICS:(45.04)'
             46.01 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(46.01)'
             46.02 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(46.02)'
             46.03 'MISCELLANEOUS ANTIPARKINSON AGENTS:(46.03)'
             46.31 'BARBITURATES:(46.31)' 46.32 'BENZODIAZEPINES:(46.32)'
             46.33 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.33)'
             46.501 'AMPHETAMINE-DEXTROAMPHETAMINE:(46.501)'
             46.502 'BENZPHETAMINE:(46.502)' 46.503 'CAFFEINE:(46.503)'
             46.504 'DEXTROAMPHETAMINE:(46.504)'
             46.505 'METHYLPHENIDATE:(46.505)'
             46.509 'CNS STIMULANTS NTA:(46.509)'
             48.01 'NEUROMUSCULAR BLOCKING AGENTS:(48.01)'
             48.02 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(48.02)'
             48.03 'SKELETAL MUSCLE RELAXANTS:(48.03)'
             48.04 'MISCELLANEOUS MUSCLE RELAXANTS:(48.04)'
             49.01 'CHOLINERGIC AGONISTS:(49.01)'
             49.02 'CHOLINESTERASE INHIBITORS:(49.02)'
             49.03 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(49.03)'
             52.01 'ADRENERGIC BRONCHODILATORS:(52.01)'
             52.02 'ANTICHOLINERGIC BRONCHODILATORS:(52.02)'
             52.03 'BRONCHODILATOR COMBINATIONS:(52.03)'
             52.04 'METHYLXANTHINES:(52.04)'
             52.05 'MISCELLANEOUS BRONCHODILATORS:(52.05)'
             56.01 'ANTIASTHMATIC COMBINATIONS:(56.01)'
             56.02 'ANTITUSSIVES:(56.02)'
             56.03 'LEUKOTRIENE MODIFIERS:(56.03)'
             56.05 'RESPIRATORY INHALANT PRODUCTS:(56.05)'
             56.06 'MISCELLANEOUS RESPIRATORY AGENTS:(56.06)'
             58.01 'CLONIDINE:(58.01)'
             58.09 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING NTA:(58.09)'
             59.01 'CARDIOSELECTIVE BETA BLOCKERS:(59.01)'
             59.02 'NON-CARDIOSELECTIVE BETA BLOCKERS:(59.02)'
             59.03 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(59.03)'
             61.01 'CARBONIC ANHYDRASE INHIBITORS:(61.01)'
             61.02 'LOOP DIURETICS:(61.02)'
             61.03 'POTASSIUM-SPARING DIURETICS:(61.03)'
             61.04 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(61.04)'
             61.05 'MISCELLANEOUS DIURETICS:(61.05)'
             62.01 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(62.01)'
             62.02 'AGENTS FOR PULMONARY HYPERTENSION:(62.02)'
             62.03 'ALDOSTERONE RECEPTOR ANTAGONISTS:(62.03)'
             62.04 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(62.04)'
             62.05 'ANGIOTENSIN II INHIBITORS:(62.05)'
             62.06 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(62.06)'
             62.07 'ANTIANGINAL AGENTS:(62.07)'
             62.08 'ANTIARRHYTHMIC AGENTS:(62.08)'
             62.09 'ANTIHYPERTENSIVE COMBINATIONS:(62.09)'
             62.1 'CATECHOLAMINES:(62.1)' 62.11 'INOTROPIC AGENTS:(62.11)'
             62.12 'PERIPHERAL VASODILATORS:(62.12)'
             62.13 'SCLEROSING AGENTS:(62.13)' 62.14 'VASODILATORS:(62.14)'
             62.15 'VASOPRESSORS:(62.15)'
             62.99 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(62.99)'
             64.041 'AZOLE ANTIFUNGALS:(64.041)'
             64.042 'ECHINOCANDINS:(64.042)' 64.043 'POLYENES:(64.043)'
             64.044 'MISCELLANEOUS ANTIFUNGALS:(64.044)'
             64.051 'ANTIMALARIAL COMBINATIONS:(64.051)'
             64.052 'ANTIMALARIAL QUINOLINES:(64.052)'
             64.053 'MISCELLANEOUS ANTIMALARIALS:(64.053)'
             64.061 'AMINOSALICYLATES:(64.061)'
             64.062 'ANTITUBERCULOSIS COMBINATIONS:(64.062)'
             64.063 'NICOTINIC ACID DERIVATIVES:(64.063)'
             64.064 'RIFAMYCIN DERIVATIVES:(64.064)'
             64.065 'STREPTOMYCES DERIVATIVES:(64.065)'
             64.066 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(64.066)'
             64.0701 'ADAMANTANE ANTIVIRALS:(64.0701)'
             64.0702 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(64.0702)'
             64.0703 'ANTIVIRAL COMBINATIONS:(64.0703)'
             64.0704 'ANTIVIRAL INTERFERONS:(64.0704)'
             64.0705 'INTEGRASE STRAND TRANSFER INHIBITOR:(64.0705)'
             64.0706 'NEURAMINIDASE INHIBITORS:(64.0706)'
             64.0707 'NNRTIS:(64.0707)' 64.0708 'NRTIS:(64.0708)'
             64.0709 'PROTEASE INHIBITORS:(64.0709)'
             64.071 'PURINE NUCLEOSIDES:(64.071)'
             64.0711 'MISCELLANEOUS ANTIVIRALS:(64.0711)'
             64.091 'FIRST GENERATION CEPHALOSPORINS:(64.091)'
             64.092 'SECOND GENERATION CEPHALOSPORINS:(64.092)'
             64.093 'THIRD GENERATION CEPHALOSPORINS:(64.093)'
             64.094 'FOURTH GENERATION CEPHALOSPORINS:(64.094)'
             64.095 'FIFTH GENERATION CEPHALOSPORINS:(64.095)'
             64.096 'MISCELLANEOUS CEPHALOSPORINS:(64.096)'
             64.141 'KETOLIDES:(64.141)' 64.142 'MACROLIDES:(64.142)'
             64.143 'MISCELLANEOUS MACROLIDES:(64.143)'
             64.151 'AMINOPENICILLINS:(64.151)'
             64.152 'ANTIPSEUDOMONAL PENICILLINS:(64.152)'
             64.153 'BETA-LACTAMASE INHIBITORS:(64.153)'
             64.154 'NATURAL PENICILLINS:(64.154)'
             64.155 'PENICILLINASE RESISTANT PENICILLINS:(64.155)'
             67.011 'COUMARINS AND INDANEDIONES:(67.011)'
             67.012 'FACTOR XA INHIBITORS:(67.012)'
             67.013 'HEPARINS:(67.013)' 67.014 'THROMBIN INHIBITORS:(67.014)'
             67.021 'GLYCOPROTEIN PLATELET INHIBITORS:(67.021)'
             67.022 'PLATELET AGGREGATION INHIBITORS:(67.022)'
             68.061 'ANTICHOLINERGICS/ANTISPASMODICS:(68.061)'
             68.062 'CHLORIDE CHANNEL ACTIVATORS:(68.062)'
             68.063 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(68.063)'
             68.064 'SEROTONINERGIC NEUROENTERIC MODULATORS:(68.064)'
             70.021 'CORTICOTROPIN:(70.021)'
             70.022 'GLUCOCORTICOIDS:(70.022)'
             70.023 'MINERALOCORTICOIDS:(70.023)'
             70.029 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(70.029)'
             70.202 'ANDROGENS AND ANABOLIC STEROIDS:(70.202)'
             70.203 'CONTRACEPTIVES:(70.203)' 70.204 'ESTROGENS:(70.204)'
             70.205 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(70.205)'
             70.206 'GONADOTROPINS:(70.206)' 70.207 'PROGESTINS:(70.207)'
             70.208 'SEX HORMONE COMBINATIONS:(70.208)'
             70.209 'MISCELLANEOUS SEX HORMONES:(70.209)'
             71.021 'BACTERIAL VACCINES:(71.021)'
             71.022 'COLONY STIMULATING FACTORS:(71.022)'
             71.023 'INTERFERONS:(71.023)'
             71.025 'THERAPEUTIC VACCINES:(71.025)'
             71.026 'VACCINE COMBINATIONS:(71.026)'
             71.027 'VIRAL VACCINES:(71.027)'
             71.029 'OTHER IMMUNOSTIMULANTS:(71.029)'
             71.031 'CALCINEURIN INHIBITORS:(71.031)'
             71.032 'INTERLEUKIN INHIBITORS:(71.032)'
             71.033 'SELECTIVE IMMUNOSUPPRESSANTS:(71.033)'
             71.034 'TNF ALFA INHIBITORS:(71.034)'
             71.039 'OTHER IMMUNOSUPPRESSANTS:(71.039)'
             73.0101 'ALPHA-GLUCOSIDASE INHIBITORS:(73.0101)'
             73.0102 'AMYLIN ANALOGS:(73.0102)'
             73.0103 'ANTIDIABETIC COMBINATIONS:(73.0103)'
             73.0104 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(73.0104)'
             73.0105 'INCRETIN MIMETICS:(73.0105)'
             73.0106 'INSULIN:(73.0106)' 73.0107 'MEGLITINIDES:(73.0107)'
             73.0108 'BIGUANIDES:(73.0108)' 73.0109 'SULFONYLUREAS:(73.0109)'
             73.011 'THIAZOLIDINEDIONES:(73.011)'
             73.019 'MISCELLANEOUS ANTIDIABETIC AGENTS:(73.019)'
             73.031 'ANTIHYPERLIPIDEMIC COMBINATIONS:(73.031)'
             73.032 'BILE ACID SEQUESTRANTS:(73.032)'
             73.033 'CHOLESTEROL ABSORPTION INHIBITORS:(73.033)'
             73.034 'FIBRIC ACID DERIVATIVES:(73.034)'
             73.035 'HMG-COA REDUCTASE INHIBITORS:(73.035)'
             73.036 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(73.036)'
             73.051 'BISPHOSPHONATES:(73.051)'
             73.059 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(73.059)'
             77.011 'IONIC IODINATED CONTRAST MEDIA:(77.011)'
             77.012 'LYMPHATIC STAINING AGENTS:(77.012)'
             77.013 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(77.013)'
             77.014 'NON-IODINATED CONTRAST MEDIA:(77.014)'
             77.015 'NON-IONIC IODINATED CONTRAST MEDIA:(77.015)'
             77.016 'ULTRASOUND CONTRAST MEDIA:(77.016)'
             77.017 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(77.017)'
             77.019 'MISCELLANEOUS RADIOCONTRAST AGENTS:(77.019)'
             77.021 'CARDIAC STRESSING AGENTS:(77.021)'
             77.031 'DIAGNOSTIC RADIOPHARMACEUTICALS:(77.031)'
             77.032 'THERAPEUTIC RADIOPHARMACEUTICALS:(77.032)'
             77.033 'MISCELLANEOUS RADIOPHARMACEUTICALS:(77.033)'
             78.0301 'TOPICAL ACNE AGENTS:(78.0301)'
             78.0302 'TOPICAL ANESTHETICS:(78.0302)'
             78.0303 'TOPICAL ANTIBIOTICS:(78.0303)'
             78.0304 'TOPICAL ANTIFUNGALS:(78.0304)'
             78.0305 'TOPICAL ANTIHISTAMINES:(78.0305)'
             78.0306 'TOPICAL ANTI-INFECTIVES:(78.0306)'
             78.0307 'TOPICAL ANTIPSORIATICS:(78.0307)'
             78.0308 'TOPICAL ANTIVIRALS:(78.0308)'
             78.0309 'TOPICAL ASTRINGENTS:(78.0309)'
             78.031 'TOPICAL DEBRIDING AGENTS:(78.031)'
             78.0311 'TOPICAL DEPIGMENTING AGENTS:(78.0311)'
             78.0312 'TOPICAL EMOLLIENTS:(78.0312)'
             78.0313 'TOPICAL KERATOLYTICS:(78.0313)'
             78.0314 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(78.0314)'
             78.0315 'TOPICAL STEROIDS:(78.0315)'
             78.0316 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(78.0316)'
             78.0399 'MISCELLANEOUS TOPICAL AGENTS:(78.0399)'
             78.051 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(78.051)'
             78.053 'NASAL LUBRICANTS AND IRRIGATIONS:(78.053)'
             78.054 'NASAL STEROIDS:(78.054)'
             78.055 'MISCELLANEOUS NASAL PREPARATIONS:(78.055)'
             78.0602 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(78.0602)'
             78.061 'MYDRIATICS:(78.061)'
             78.062 'OPHTHALMIC ANESTHETICS:(78.062)'
             78.063 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(78.063)'
             78.064 'OPHTHALMIC ANTI-INFECTIVES:(78.064)'
             78.065 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(78.065)'
             78.066 'OPHTHALMIC DIAGNOSTIC AGENTS:(78.066)'
             78.067 'OPHTHALMIC GLAUCOMA AGENTS:(78.067)'
             78.068 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(78.068)'
             78.069 'OPHTHALMIC STEROIDS:(78.069)'
             78.0691 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(78.0691)'
             78.0692 'OPHTHALMIC SURGICAL AGENTS:(78.0692)'
             78.0693 'MISCELLANEOUS OPHTHALMIC AGENTS:(78.0693)'
             78.071 'CERUMENOLYTICS:(78.071)'
             78.072 'OTIC ANESTHETICS:(78.072)'
             78.073 'OTIC ANTI-INFECTIVES:(78.073)'
             78.074 'OTIC STEROIDS:(78.074)'
             78.075 'OTIC STEROIDS WITH ANTI-INFECTIVES:(78.075)'
             78.076 'MISCELLANEOUS OTIC AGENTS:(78.076)'
             78.091 'SPERMICIDES:(78.091)'
             78.092 'VAGINAL ANTI-INFECTIVES:(78.092)'
             78.093 'MISCELLANEOUS VAGINAL AGENTS:(78.093)' /
   SDLED_5_2 -7 'NOT APPLICABLE' 20.41 'NEFAZODONE:(20.41)'
             20.42 'TRAZODONE:(20.42)' 20.71 'DESVENLAFAXINE:(20.71)'
             20.72 'DULOXETINE:(20.72)' 20.73 'VENLAFAXINE:(20.73)'
             20.79 'SSNRI ANTIDEPRESSANTS NTA:(20.79)'
             21.01 'CITALOPRAM:(21.01)' 21.02 'FLUOXETINE:(21.02)'
             21.03 'FLUVOXAMINE:(21.03)' 21.04 'PAROXETINE:(21.04)'
             21.05 'SERTRALINE:(21.05)'
             21.09 'SSRI ANTIDEPRESSANTS NTA:(21.09)'
             21.51 'MAPROTILINE:(21.51)' 21.52 'MIRTAZAPINE:(21.52)'
             22.01 'AMITRIPTYLINE:(22.01)' 22.02 'DESIPRAMINE:(22.02)'
             22.03 'DOXEPIN:(22.03)' 22.04 'IMIPRAMINE:(22.04)'
             22.05 'NORTRIPTYLINE:(22.05)'
             22.06 'TRICYCLIC ANTIDEPRESSANTS-NOS:(22.06)'
             22.09 'TRICYCLIC ANTIDEPRESSANTS NTA:(22.09)'
             23.01 'BUPROPION:(23.01)' 23.06 'ANTIDEPRESSANTS-NOS:(23.06)'
             23.09 'MISCELLANEOUS ANTIDEPRESSANTS NTA:(23.09)'
             25.01 'CLOZAPINE:(25.01)' 25.02 'OLANZAPINE:(25.02)'
             25.03 'QUETIAPINE:(25.03)' 25.04 'RISPERIDONE:(25.04)'
             25.09 'ATYPICAL ANTIPSYCHOTICS NTA:(25.09)'
             26.01 'CHLORPROMAZINE:(26.01)' 26.02 'FLUPHENAZINE:(26.02)'
             26.03 'PERPHENAZINE:(26.03)' 26.04 'PROCHLORPERAZINE:(26.04)'
             26.05 'THIORIDAZINE:(26.05)' 26.06 'TRIFLUPROMAZINE:(26.06)'
             26.09 'PHENOTHIAZINE ANTIPSYCHOTICS NTA:(26.09)'
             27.01 'HALOPERIDOL:(27.01)' 27.02 'LITHIUM:(27.02)'
             27.09 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS NTA:(27.09)'
             36.75 'OPIATES/OPIOIDS, UNSPECIFIED:(36.75)'
             37.5 'NARCOTIC ANALGESICS:(37.5)'
             39.01 'IBUPROFEN/COMBINATIONS:(39.01)'
             39.02 'NAPROXEN/COMBINATIONS:(39.02)'
             39.03 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS NTA:(39.03)'
             40.501 'ASPIRIN/COMBINATIONS:(40.501)'
             40.502 'SALICYLATES-NOS:(40.502)'
             40.503 'SALICYLATES/COMBINATIONS NTA:(40.503)'
             41.501 'ACETAMINOPHEN/COMBINATIONS:(41.501)'
             41.502 'TRAMADOL/COMBINATIONS:(41.502)'
             41.505 'ANALGESICS-NOS:(41.505)'
             41.506 'MISCELLANEOUS ANALGESIC/COMBINATIONS NTA:(41.506)'
             44.041 'TOPIRAMATE:(44.041)'
           44.049 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS NTA:(44.049)'
             44.051 'CARBAMAZEPINE:(44.051)' 44.052 'OXCARBAZEPINE:(44.052)'
             44.053 'RUFINAMIDE:(44.053)' 44.061 'DIVALPROEX SODIUM:(44.061)'
             44.062 'VALPROIC ACID:(44.062)' 44.071 'GABAPENTIN:(44.071)'
             44.079 'GAMMA-AMINOBUTYRIC ACID ANALOGS NTA:(44.079)'
             44.091 'PHENYTOIN:(44.091)'
             44.099 'HYDANTOIN ANTICONVULSANTS NTA:(44.099)'
             46.011 'BENZTROPINE:(46.011)'
             46.019 'ANTICHOLINERGIC ANTIPARKINSON AGENTS NTA:(46.019)'
             46.3101 'PHENOBARBITAL:(46.3101)'
             46.3102 'BARBITURATES-NOS:(46.3102)'
             46.3109 'BARBITURATES NTA:(46.3109)'
             46.3201 'ALPRAZOLAM:(46.3201)'
             46.3202 'CHLORDIAZEPOXIDE:(46.3202)'
             46.3203 'CLONAZEPAM:(46.3203)' 46.3204 'CLORAZEPATE:(46.3204)'
             46.3205 'DIAZEPAM:(46.3205)' 46.3206 'FLURAZEPAM:(46.3206)'
             46.3207 'LORAZEPAM:(46.3207)' 46.3208 'OXAZEPAM:(46.3208)'
             46.3209 'TEMAZEPAM:(46.3209)' 46.321 'TRIAZOLAM:(46.321)'
             46.3211 'BENZODIAZEPINES-NOS:(46.3211)'
             46.3219 'BENZODIAZEPINES NTA:(46.3219)'
             46.3301 'BUSPIRONE:(46.3301)'
             46.3302 'CHLORAL HYDRATE:(46.3302)'
             46.3303 'DIPHENHYDRAMINE:(46.3303)'
             46.3304 'DOXYLAMINE:(46.3304)' 46.3305 'HYDROXYZINE:(46.3305)'
             46.3306 'ZOLPIDEM:(46.3306)'
             46.3307 'ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS:(46.3307)'
          46.3309 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS NTA:(46.3309)'
             46.5091 'CAFFEINE/MULTIVITAMIN:(46.5091)'
             46.5092 'OTHER CNS STIMULANTS NTA:(46.5092)'
             48.031 'CARISOPRODOL:(48.031)' 48.032 'CHLORZOXAZONE:(48.032)'
             48.033 'CYCLOBENZAPRINE:(48.033)' 48.034 'METAXALONE:(48.034)'
             48.035 'METHOCARBAMOL:(48.035)' 48.036 'TIZANIDINE:(48.036)'
             48.039 'SKELETAL MUSCLE RELAXANTS NTA:(48.039)'
             56.052 'INHALED CORTICOSTEROIDS:(56.052)'
             56.053 'MAST CELL STABILIZERS:(56.053)'
             56.054 'MUCOLYTICS:(56.054)'
             56.059 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(56.059)'
             59.011 'ATENOLOL:(59.011)'
             59.019 'CARDIOSELECTIVE BETA BLOCKERS NTA:(59.019)'
             59.021 'PROPRANOLOL:(59.021)'
             59.029 'NON-CARDIOSELECTIVE BETA BLOCKERS NTA:(59.029)'
             62.081 'GROUP I ANTIARRHYTHMICS:(62.081)'
             62.083 'GROUP III ANTIARRHYTHMICS:(62.083)'
             62.085 'GROUP V ANTIARRHYTHMICS:(62.085)'
             62.089 'ANTIARRHYTHMIC AGENTS NTA:(62.089)'
             62.151 'EPHEDRINE:(62.151)' 62.159 'VASOPRESSORS NTA:(62.159)' /
   SDLED_6_2 -7 'NOT APPLICABLE:(-7)'
             37.5005 'BUPRENORPHINE/COMBINATIONS:(37.5005)'
             37.501 'CODEINE/COMBINATIONS:(37.501)'
             37.502 'DIHYDROCODEINE/COMBINATIONS:(37.502)'
             37.503 'FENTANYL/COMBINATIONS:(37.503)'
             37.504 'HYDROCODONE/COMBINATIONS:(37.504)'
             37.5045 'HYDROMORPHONE/COMBINATIONS:(37.5045)'
             37.505 'MEPERIDINE/COMBINATIONS:(37.505)'
             37.506 'METHADONE:(37.506)'
             37.507 'MORPHINE/COMBINATIONS:(37.507)'
             37.508 'OPIUM/COMBINATIONS:(37.508)'
             37.509 'OXYCODONE/COMBINATIONS:(37.509)'
             37.51 'PENTAZOCINE/COMBINATIONS:(37.51)'
             37.511 'PHENACETIN/COMBINATIONS:(37.511)'
             37.512 'PROPOXYPHENE/COMBINATIONS:(37.512)'
             37.514 'ALL OTHER NARCOTIC ANALGESICS/COMBINATIONS NTA:(37.514)'
             41.503 'TRAMADOL:(41.503)'
             41.504 'ACETAMINOPHEN-TRAMADOL:(41.504)' /
   DRUGID_3  -7 'NOT APPLICABLE' 1 'D00001 ACYCLOVIR' 2 'D00002 AMIODARONE'
             3 'D00003 AMPICILLIN' 4 'D00004 ATENOLOL' 5 'D00006 CAPTOPRIL'
             6 'D00007 CEFAZOLIN' 7 'D00008 CEFOTAXIME'
             8 'D00009 CEFTAZIDIME' 9 'D00010 CEFTIZOXIME'
             10 'D00011 CIPROFLOXACIN' 11 'D00012 CODEINE'
             12 'D00013 ENALAPRIL' 13 'D00014 GENTAMICIN'
             14 'D00015 IBUPROFEN' 15 'D00016 LABETALOL'
             16 'D00017 MEPERIDINE' 17 'D00018 NADOLOL' 18 'D00019 NAPROXEN'
             19 'D00020 QUINIDINE' 20 'D00021 RANITIDINE'
             21 'D00022 WARFARIN' 22 'D00023 ALLOPURINOL'
             23 'D00024 AZATHIOPRINE' 24 'D00025 CHLORAMPHENICOL'
             25 'D00026 FENOPROFEN' 26 'D00027 HALOPERIDOL'
             27 'D00028 KETOPROFEN' 28 'D00029 NAFCILLIN'
             29 'D00030 PENTAMIDINE' 30 'D00031 PROBENECID'
             31 'D00032 PROPRANOLOL' 32 'D00033 SULINDAC'
             33 'D00034 ZIDOVUDINE' 34 'D00035 CHLOROQUINE'
             35 'D00036 CYCLOPHOSPHAMIDE' 36 'D00037 DOXYCYCLINE'
             37 'D00038 FLUCYTOSINE' 38 'D00039 INDOMETHACIN'
             39 'D00040 OXAZEPAM' 40 'D00041 TETRACYCLINE'
             41 'D00042 CHLORPROPAMIDE' 42 'D00043 CLINDAMYCIN'
             43 'D00044 CLONIDINE' 44 'D00045 DILTIAZEM'
             45 'D00046 ERYTHROMYCIN' 46 'D00047 RIFAMPIN'
             47 'D00048 VERAPAMIL' 48 'D00049 ACETAMINOPHEN'
             49 'D00050 METHADONE' 50 'D00051 NIFEDIPINE'
             51 'D00052 CEFTRIAXONE' 52 'D00053 CEPHRADINE'
             53 'D00054 TOLMETIN' 54 'D00055 CEFOTETAN'
             55 'D00056 CEFUROXIME' 56 'D00057 PIPERACILLIN'
             57 'D00058 CARBAMAZEPINE' 58 'D00059 LIDOCAINE'
             59 'D00060 METHOTREXATE' 60 'D00061 LITHIUM'
             61 'D00062 CEFAMANDOLE' 62 'D00064 CHLORPROMAZINE'
             63 'D00065 FOSCARNET' 64 'D00066 GANCICLOVIR'
             65 'D00067 AZTREONAM' 66 'D00068 ETHAMBUTOL'
             67 'D00069 TOBRAMYCIN' 68 'D00070 FUROSEMIDE'
             69 'D00071 FLUCONAZOLE' 70 'D00072 CEFIXIME'
             71 'D00073 CEFPROZIL' 72 'D00074 CEFOPERAZONE'
             73 'D00075 PROCAINAMIDE' 74 'D00077 AMPHOTERICIN B'
             75 'D00078 DIDANOSINE' 76 'D00079 CYCLOSPORINE'
             77 'D00080 CEFADROXIL' 78 'D00081 CEFACLOR'
             79 'D00082 IMIPENEM-CILASTATIN' 80 'D00083 VALPROIC ACID'
             81 'D00084 PREDNISOLONE' 82 'D00085 RIBAVIRIN'
             83 'D00086 AMANTADINE' 84 'D00087 AMIKACIN'
             85 'D00088 AMOXICILLIN' 86 'D00089 AMOXICILLIN-CLAVULANATE'
             87 'D00090 AMPICILLIN-SULBACTAM' 88 'D00091 AZITHROMYCIN'
             89 'D00092 CARBENICILLIN' 90 'D00093 CEFMETAZOLE'
             91 'D00094 CEFOXITIN' 92 'D00095 CEFPODOXIME'
             93 'D00096 CEPHALEXIN' 94 'D00097 CLARITHROMYCIN'
             95 'D00098 DAPSONE' 96 'D00099 ENOXACIN'
             97 'D00100 GRISEOFULVIN' 98 'D00101 ISONIAZID'
             99 'D00102 ITRACONAZOLE' 100 'D00103 KETOCONAZOLE'
             101 'D00104 LOMEFLOXACIN' 102 'D00105 LORACARBEF'
             103 'D00106 METHENAMINE' 104 'D00107 METHICILLIN'
             105 'D00108 METRONIDAZOLE' 106 'D00109 MEZLOCILLIN'
             107 'D00110 MINOCYCLINE' 108 'D00112 NITROFURANTOIN'
             109 'D00113 NORFLOXACIN' 110 'D00114 OFLOXACIN'
             111 'D00115 OXACILLIN' 112 'D00116 PENICILLIN'
             113 'D00117 PYRAZINAMIDE' 114 'D00118 SULFADIAZINE'
             115 'D00119 SULFAMETHOXAZOLE' 116 'D00120 SULFISOXAZOLE'
             117 'D00121 TICARCILLIN' 118 'D00122 TICARCILLIN-CLAVULANATE'
             119 'D00123 TRIMETHOPRIM'
             120 'D00124 SULFAMETHOXAZOLE-TRIMETHOPRIM'
             121 'D00125 VANCOMYCIN' 122 'D00128 ACEBUTOLOL'
             123 'D00129 DIAZOXIDE' 124 'D00132 HYDRALAZINE'
             125 'D00133 METHYLDOPA' 126 'D00134 METOPROLOL'
             127 'D00135 MINOXIDIL' 128 'D00137 PINDOLOL'
             129 'D00138 PRAZOSIN' 130 'D00139 TIMOLOL'
             131 'D00140 CIMETIDINE' 132 'D00141 FAMOTIDINE'
             133 'D00142 THEOPHYLLINE' 134 'D00143 PHENYTOIN'
             135 'D00144 NORTRIPTYLINE' 136 'D00145 DESIPRAMINE'
             137 'D00146 AMITRIPTYLINE' 138 'D00147 CHLORAL HYDRATE'
             139 'D00148 DIAZEPAM' 140 'D00149 LORAZEPAM'
             141 'D00150 COLCHICINE' 142 'D00152 CLOXACILLIN'
             143 'D00153 DICLOXACILLIN' 144 'D00154 MEBENDAZOLE'
             145 'D00155 MICONAZOLE' 146 'D00157 NALIDIXIC ACID'
             147 'D00158 QUINACRINE' 148 'D00159 STREPTOMYCIN'
             149 'D00161 ACETAZOLAMIDE' 150 'D00164 ADENOSINE'
             151 'D00167 ALFENTANIL' 152 'D00168 ALPRAZOLAM'
             153 'D00169 AMILORIDE' 154 'D00170 ASPIRIN'
             155 'D00171 AMOBARBITAL' 156 'D00172 INAMRINONE'
             157 'D00173 ATRACURIUM' 158 'D00174 ATROPINE'
             159 'D00175 BENZTROPINE' 160 'D00176 BETAXOLOL'
             161 'D00177 BLEOMYCIN' 162 'D00178 BROMOCRIPTINE'
             163 'D00179 BUMETANIDE' 164 'D00180 BUPIVACAINE'
             165 'D00181 BUPROPION' 166 'D00182 BUSPIRONE'
             167 'D00183 BUSULFAN' 168 'D00184 CARBIDOPA'
             169 'D00185 CARBOPLATIN' 170 'D00186 CEPHALOTHIN'
             171 'D00187 CEPHAPIRIN' 172 'D00188 CHLORAMBUCIL'
             173 'D00189 CHLORDIAZEPOXIDE' 174 'D00190 CHLOROTHIAZIDE'
             175 'D00191 CHLORPHENIRAMINE' 176 'D00192 CHLORTHALIDONE'
             177 'D00193 CHOLESTYRAMINE' 178 'D00195 CISPLATIN'
             179 'D00197 CLONAZEPAM' 180 'D00198 CLORAZEPATE'
             181 'D00199 CLOZAPINE' 182 'D00200 CROMOLYN'
             183 'D00201 CYTARABINE' 184 'D00202 DACARBAZINE'
             185 'D00203 DACTINOMYCIN' 186 'D00204 DANAZOL'
             187 'D00205 DAUNORUBICIN' 188 'D00206 DEXAMETHASONE'
             189 'D00207 DEXTROMETHORPHAN' 190 'D00208 DIFLUNISAL'
             191 'D00209 DIGITOXIN' 192 'D00210 DIGOXIN'
             193 'D00211 DIHYDROERGOTAMINE' 194 'D00212 DIPHENHYDRAMINE'
             195 'D00213 DIPYRIDAMOLE' 196 'D00214 DISOPYRAMIDE'
             197 'D00215 DOBUTAMINE' 198 'D00216 DOPAMINE'
             199 'D00217 DOXEPIN' 200 'D00218 DOXORUBICIN'
             201 'D00219 DROPERIDOL' 202 'D00220 EDROPHONIUM'
             203 'D00222 ERGOTAMINE' 204 'D00223 EPOETIN ALFA'
             205 'D00224 ESMOLOL' 206 'D00226 ETHCHLORVYNOL'
             207 'D00227 ETHOSUXIMIDE' 208 'D00229 ETHINYL ESTRADIOL'
             209 'D00230 ETOPOSIDE' 210 'D00231 FELODIPINE'
             211 'D00233 FENTANYL' 212 'D00234 FLECAINIDE'
             213 'D00235 FLUOROURACIL' 214 'D00236 FLUOXETINE'
             215 'D00237 FLUPHENAZINE' 216 'D00238 FLURAZEPAM'
             217 'D00239 FLURBIPROFEN' 218 'D00240 FLUTAMIDE'
             219 'D00241 FOLIC ACID' 220 'D00242 FOSINOPRIL'
             221 'D00243 FURAZOLIDONE' 222 'D00245 GEMFIBROZIL'
             223 'D00246 GLIPIZIDE' 224 'D00248 GLYBURIDE'
             225 'D00250 GOLD SODIUM THIOMALATE' 226 'D00252 HEPARIN'
             227 'D00253 HYDROCHLOROTHIAZIDE' 228 'D00254 HYDROCORTISONE'
             229 'D00255 HYDROMORPHONE' 230 'D00256 IDARUBICIN'
             231 'D00257 IFOSFAMIDE' 232 'D00259 IMIPRAMINE'
             233 'D00260 INDAPAMIDE' 234 'D00262 INSULIN'
             235 'D00265 IPRATROPIUM' 236 'D00267 ISOFLURANE'
             237 'D00268 ISOSORBIDE DINITRATE'
             238 'D00269 ISOSORBIDE MONONITRATE' 239 'D00270 ISRADIPINE'
             240 'D00271 KANAMYCIN' 241 'D00272 KETAMINE'
             242 'D00273 KETOROLAC' 243 'D00275 LEUCOVORIN'
             244 'D00276 LEVAMISOLE' 245 'D00277 LEVODOPA'
             246 'D00278 LEVOTHYROXINE' 247 'D00279 LINCOMYCIN'
             248 'D00280 LOVASTATIN' 249 'D00282 MANNITOL'
             250 'D00283 MECLOFENAMATE' 251 'D00284 MEDROXYPROGESTERONE'
             252 'D00285 MEFENAMIC ACID' 253 'D00286 MEFLOQUINE'
             254 'D00287 MELPHALAN' 255 'D00288 MEPROBAMATE'
             256 'D00289 MERCAPTOPURINE' 257 'D00290 METHIMAZOLE'
             258 'D00292 METHSUXIMIDE' 259 'D00293 METHYLPREDNISOLONE'
             260 'D00295 METHYLTESTOSTERONE'
             261 'D00297 METIPRANOLOL OPHTHALMIC' 262 'D00298 METOCLOPRAMIDE'
             263 'D00299 METOLAZONE' 264 'D00300 MEXILETINE'
             265 'D00301 MIDAZOLAM' 266 'D00302 MILRINONE'
             267 'D00303 MISOPROSTOL' 268 'D00305 MITOMYCIN'
             269 'D00306 MITOXANTRONE' 270 'D00307 MORICIZINE'
             271 'D00308 MORPHINE' 272 'D00310 NABUMETONE'
             273 'D00311 NALOXONE' 274 'D00312 NEOMYCIN'
             275 'D00313 NEOSTIGMINE' 276 'D00314 NIACIN'
             277 'D00315 NICARDIPINE' 278 'D00316 NICOTINE'
             279 'D00318 NIMODIPINE' 280 'D00321 NITROGLYCERIN'
             281 'D00322 NIZATIDINE' 282 'D00323 NOREPINEPHRINE'
             283 'D00325 OMEPRAZOLE' 284 'D00328 OXYBUTYNIN'
             285 'D00329 OXYCODONE' 286 'D00330 PANCURONIUM'
             287 'D00331 PARAAMINOBENZOIC ACID' 288 'D00332 PENBUTOLOL'
             289 'D00333 PENICILLAMINE' 290 'D00334 PENTAZOCINE'
             291 'D00335 PENTOBARBITAL' 292 'D00336 PENTOXIFYLLINE'
             293 'D00337 PHENAZOPYRIDINE' 294 'D00340 PHENOBARBITAL'
             295 'D00341 PHENYLBUTAZONE' 296 'D00342 PHYSOSTIGMINE'
             297 'D00343 PIROXICAM' 298 'D00344 POLYMYXIN B SULFATE'
             299 'D00345 POTASSIUM CHLORIDE'
             300 'D00346 POVIDONE IODINE TOPICAL' 301 'D00348 PRAVASTATIN'
             302 'D00349 PRAZIQUANTEL' 303 'D00350 PREDNISONE'
             304 'D00351 PRIMAQUINE' 305 'D00352 PRIMIDONE'
             306 'D00353 PROBUCOL' 307 'D00354 PROCARBAZINE'
             308 'D00355 PROCHLORPERAZINE' 309 'D00356 PROMAZINE'
             310 'D00358 PROPAFENONE' 311 'D00359 PROPANTHELINE'
             312 'D00360 PROPOXYPHENE' 313 'D00361 PROPYLTHIOURACIL'
             314 'D00362 PROTAMINE' 315 'D00363 PYRIDOSTIGMINE'
             316 'D00364 PYRIMETHAMINE' 317 'D00365 QUINAPRIL'
             318 'D00366 QUININE' 319 'D00367 RESERPINE'
             320 'D00368 SECOBARBITAL' 321 'D00370 OCTREOTIDE'
             322 'D00371 SOTALOL' 323 'D00373 SPIRONOLACTONE'
             324 'D00374 STREPTOKINASE' 325 'D00375 STREPTOZOCIN'
             326 'D00376 SUCCINYLCHOLINE' 327 'D00377 SUCRALFATE'
             328 'D00378 SUFENTANIL' 329 'D00379 SULFASALAZINE'
             330 'D00381 TAMOXIFEN' 331 'D00384 TEMAZEPAM'
             332 'D00386 TERAZOSIN' 333 'D00387 TERFENADINE'
             334 'D00388 THIOPENTAL' 335 'D00389 THIORIDAZINE'
             336 'D00391 THIOTHIXENE' 337 'D00393 TOLAZAMIDE'
             338 'D00394 TOLBUTAMIDE' 339 'D00395 TRAZODONE'
             340 'D00396 TRIAMTERENE' 341 'D00397 TRIAZOLAM'
             342 'D00398 VASOPRESSIN' 343 'D00399 VECURONIUM'
             344 'D00400 VINBLASTINE' 345 'D00401 VINCRISTINE'
             346 'D00402 VITAMIN A' 347 'D00405 VITAMIN E'
             348 'D00409 RIBOFLAVIN' 349 'D00412 PYRIDOXINE'
             350 'D00413 CYANOCOBALAMIN' 351 'D00417 BIOFLAVONOIDS'
             352 'D00425 CALCIUM CARBONATE' 353 'D00426 ASCORBIC ACID'
             354 'D00427 POTASSIUM PHOSPHATE-SODIUM PHOSPHATE'
             355 'D00428 FLUORIDE' 356 'D00438 SODIUM CHLORIDE'
             357 'D00439 CITRIC ACID-POTASSIUM CITRATE'
             358 'D00440 SODIUM BICARBONATE' 359 'D00468 MAGNESIUM SULFATE'
             360 'D00471 SODIUM ACETATE' 361 'D00472 TROMETHAMINE'
             362 'D00475 SODIUM PHOSPHATE' 363 'D00476 AMMONIUM CHLORIDE'
             364 'D00481 AMMONIUM MOLYBDATE TETRAHYDRATE'
             365 'D00484 SELENIUM' 366 'D00485 IODINE TOPICAL'
             367 'D00487 GLUTAMIC ACID' 368 'D00488 LYSINE'
             369 'D00491 LEVOCARNITINE' 370 'D00496 INOSITOL'
             371 'D00497 OMEGA-3 POLYUNSATURATED FATTY ACIDS'
             372 'D00512 FILGRASTIM' 373 'D00513 SARGRAMOSTIM'
             374 'D00514 TICLOPIDINE' 375 'D00519 ANISINDIONE'
             376 'D00521 ALTEPLASE' 377 'D00523 UROKINASE'
             378 'D00524 ANTITHROMBIN III'
             379 'D00525 ANTIHEMOPHILIC FACTOR (OBSOLETE)'
             380 'D00526 ANTI-INHIBITOR COAGULANT COMPLEX'
             381 'D00527 FACTOR IX COMPLEX (OBSOLETE)'
             382 'D00528 AMINOCAPROIC ACID' 383 'D00529 TRANEXAMIC ACID'
             384 'D00534 ESTRONE' 385 'D00537 ESTRADIOL'
             386 'D00541 CONJUGATED ESTROGENS'
             387 'D00542 ESTERIFIED ESTROGENS' 388 'D00543 ESTROPIPATE'
             389 'D00546 DIETHYLSTILBESTROL' 390 'D00550 PROGESTERONE'
             391 'D00554 HYDROXYPROGESTERONE' 392 'D00555 NORETHINDRONE'
             393 'D00557 LEVONORGESTREL' 394 'D00558 TESTOSTERONE'
             395 'D00562 FLUOXYMESTERONE' 396 'D00563 FINASTERIDE'
             397 'D00565 STANOZOLOL' 398 'D00566 OXANDROLONE'
             399 'D00568 NANDROLONE' 400 'D00569 CLOMIPHENE'
             401 'D00570 UROFOLLITROPIN' 402 'D00571 MENOTROPINS'
             403 'D00572 CHORIONIC GONADOTROPIN (HCG)' 404 'D00574 NAFARELIN'
             405 'D00575 HISTRELIN' 406 'D00576 SOMATREM'
             407 'D00577 SOMATROPIN' 408 'D00578 ARGININE'
             409 'D00583 DESMOPRESSIN' 410 'D00584 OXYTOCIN'
             411 'D00586 ERGONOVINE' 412 'D00587 METHYLERGONOVINE'
             413 'D00589 DINOPROSTONE TOPICAL' 414 'D00592 METYRAPONE'
             415 'D00593 GLUCAGON' 416 'D00595 GLUCOSE'
             417 'D00598 CALCITONIN' 418 'D00599 ETIDRONATE'
             419 'D00601 PAMIDRONATE' 420 'D00602 GALLIUM NITRATE'
             421 'D00603 RITODRINE' 422 'D00604 CORTICOTROPIN'
             423 'D00607 COSYNTROPIN' 424 'D00608 FLUDROCORTISONE'
             425 'D00609 CORTISONE' 426 'D00620 TRIAMCINOLONE'
             427 'D00626 DEXAMETHASONE TOPICAL' 428 'D00628 BETAMETHASONE'
             429 'D00640 METHAZOLAMIDE' 430 'D00641 BENDROFLUMETHIAZIDE'
             431 'D00643 METHYCLOTHIAZIDE' 432 'D00644 BENZTHIAZIDE'
             433 'D00645 HYDROFLUMETHIAZIDE' 434 'D00646 TRICHLORMETHIAZIDE'
             435 'D00647 POLYTHIAZIDE' 436 'D00649 ETHACRYNIC ACID'
             437 'D00651 UREA TOPICAL' 438 'D00652 GLYCERIN'
             439 'D00653 ISOSORBIDE' 440 'D00655 THYROID DESICCATED'
             441 'D00658 LIOTHYRONINE' 442 'D00659 LIOTRIX'
             443 'D00666 AMYL NITRITE' 444 'D00683 LIDOCAINE TOPICAL'
             445 'D00688 BEPRIDIL' 446 'D00689 AMLODIPINE'
             447 'D00693 ISOXSUPRINE' 448 'D00695 PAPAVERINE'
             449 'D00696 ETHAVERINE' 450 'D00697 ISOPROTERENOL'
             451 'D00699 EPINEPHRINE' 452 'D00700 EPHEDRINE'
             453 'D00703 METHOXAMINE' 454 'D00704 PHENYLEPHRINE'
             455 'D00708 CARTEOLOL' 456 'D00709 BISOPROLOL'
             457 'D00717 GUANFACINE' 458 'D00726 DOXAZOSIN'
             459 'D00728 RAMIPRIL' 460 'D00730 BENAZEPRIL'
             461 'D00732 LISINOPRIL' 462 'D00733 PHENTOLAMINE'
             463 'D00734 PHENOXYBENZAMINE' 464 'D00735 METYROSINE'
             465 'D00739 MECAMYLAMINE'
             466 'D00743 SODIUM POLYSTYRENE SULFONATE'
             467 'D00744 COLESTIPOL' 468 'D00746 SIMVASTATIN'
             469 'D00747 DEXTROTHYROXINE SODIUM' 470 'D00749 ALBUTEROL'
             471 'D00750 METAPROTERENOL' 472 'D00752 TERBUTALINE'
             473 'D00755 PIRBUTEROL' 474 'D00758 AMINOPHYLLINE'
             475 'D00759 DYPHYLLINE' 476 'D00760 BECLOMETHASONE'
             477 'D00761 FLUNISOLIDE' 478 'D00762 ACETYLCYSTEINE'
             479 'D00765 CROMOLYN OPHTHALMIC'
             480 'D00767 PHENYLPROPANOLAMINE' 481 'D00769 PSEUDOEPHEDRINE'
             482 'D00771 NAPHAZOLINE OPHTHALMIC'
             483 'D00772 OXYMETAZOLINE NASAL'
             484 'D00773 TETRAHYDROZOLINE OPHTHALMIC'
             485 'D00774 XYLOMETAZOLINE NASAL'
             486 'D00775 ALPHA 1-PROTEINASE INHIBITOR'
             487 'D00780 CLEMASTINE' 488 'D00782 PYRILAMINE'
             489 'D00784 DEXCHLORPHENIRAMINE' 490 'D00785 BROMPHENIRAMINE'
             491 'D00786 TRIPROLIDINE' 492 'D00787 PROMETHAZINE'
             493 'D00788 TRIMEPRAZINE' 494 'D00789 METHDILAZINE'
             495 'D00790 CYPROHEPTADINE' 496 'D00791 AZATADINE'
             497 'D00793 PHENINDAMINE' 498 'D00796 BENZONATATE'
             499 'D00797 GUAIFENESIN' 500 'D00800 POTASSIUM IODIDE'
             501 'D00801 CAFFEINE' 502 'D00802 DOXAPRAM'
             503 'D00803 AMPHETAMINE' 504 'D00804 DEXTROAMPHETAMINE'
             505 'D00805 METHAMPHETAMINE' 506 'D00806 PHENTERMINE'
             507 'D00807 BENZPHETAMINE' 508 'D00809 PHENDIMETRAZINE'
             509 'D00810 DIETHYLPROPION' 510 'D00811 MAZINDOL'
             511 'D00812 FENFLURAMINE' 512 'D00813 BENZOCAINE TOPICAL'
             513 'D00814 METHOTRIMEPRAZINE' 514 'D00817 HYDROXYCHLOROQUINE'
             515 'D00824 OPIUM' 516 'D00825 LEVORPHANOL'
             517 'D00833 OXYMORPHONE' 518 'D00838 BUTORPHANOL'
             519 'D00839 NALBUPHINE' 520 'D00840 BUPRENORPHINE'
             521 'D00842 SALSALATE' 522 'D00846 MAGNESIUM SALICYLATE'
             523 'D00848 DICLOFENAC' 524 'D00851 ETODOLAC'
             525 'D00853 OXAPROZIN' 526 'D00855 PERPHENAZINE'
             527 'D00857 THIETHYLPERAZINE' 528 'D00858 CYCLIZINE'
             529 'D00859 MECLIZINE' 530 'D00861 DIMENHYDRINATE'
             531 'D00862 TRIMETHOBENZAMIDE' 532 'D00866 DRONABINOL'
             533 'D00867 ONDANSETRON' 534 'D00873 TRIMIPRAMINE'
             535 'D00874 AMOXAPINE' 536 'D00875 PROTRIPTYLINE'
             537 'D00876 CLOMIPRAMINE' 538 'D00877 MAPROTILINE'
             539 'D00880 SERTRALINE' 540 'D00882 ISOCARBOXAZID'
             541 'D00883 PHENELZINE' 542 'D00884 TRANYLCYPROMINE'
             543 'D00889 MESORIDAZINE' 544 'D00890 TRIFLUOPERAZINE'
             545 'D00896 MOLINDONE' 546 'D00897 LOXAPINE'
             547 'D00898 PIMOZIDE' 548 'D00900 METHYLPHENIDATE'
             549 'D00901 PEMOLINE' 550 'D00902 ERGOLOID MESYLATES'
             551 'D00907 HYDROXYZINE' 552 'D00909 CHLORMEZANONE'
             553 'D00910 ZOLPIDEM' 554 'D00911 PARALDEHYDE'
             555 'D00912 ACETYLCARBROMAL' 556 'D00915 ESTAZOLAM'
             557 'D00917 QUAZEPAM' 558 'D00919 MEPHOBARBITAL'
             559 'D00923 BUTABARBITAL' 560 'D00929 METHOHEXITAL'
             561 'D00931 ETOMIDATE' 562 'D00933 PROPOFOL'
             563 'D00934 NITROUS OXIDE' 564 'D00942 ETHOTOIN'
             565 'D00943 PHENSUXIMIDE' 566 'D00944 PARAMETHADIONE'
             567 'D00960 CARISOPRODOL' 568 'D00962 CHLORZOXAZONE'
             569 'D00963 CYCLOBENZAPRINE' 570 'D00964 METAXALONE'
             571 'D00965 METHOCARBAMOL' 572 'D00966 ORPHENADRINE'
             573 'D00967 BACLOFEN' 574 'D00968 DANTROLENE'
             575 'D00969 PROCYCLIDINE' 576 'D00970 TRIHEXYPHENIDYL'
             577 'D00972 BIPERIDEN' 578 'D00976 SELEGILINE'
             579 'D00977 PERGOLIDE' 580 'D00978 ALUMINUM HYDROXIDE'
             581 'D00980 DIHYDROXYALUMINUM SODIUM CARBONATE'
             582 'D00982 MAGNESIUM HYDROXIDE' 583 'D00984 MAGALDRATE'
             584 'D00985 HYOSCYAMINE' 585 'D00986 SCOPOLAMINE'
             586 'D00988 BELLADONNA' 587 'D00989 METHSCOPOLAMINE'
             588 'D00991 CLIDINIUM' 589 'D00992 GLYCOPYRROLATE'
             590 'D00999 DICYCLOMINE' 591 'D01002 PANCRELIPASE'
             592 'D01003 PANCREATIN' 593 'D01005 URSODIOL'
             594 'D01008 MAGNESIUM CITRATE' 595 'D01009 SODIUM BIPHOSPHATE'
             596 'D01010 CASCARA SAGRADA' 597 'D01012 PHENOLPHTHALEIN'
             598 'D01013 SENNA' 599 'D01014 CASTOR OIL'
             600 'D01015 BISACODYL' 601 'D01017 POLYCARBOPHIL'
             602 'D01018 PSYLLIUM' 603 'D01019 MINERAL OIL'
             604 'D01021 DOCUSATE'
             605 'D01023 POLYETHYLENE GLYCOL 3350 WITH ELECTROLYTES'
             606 'D01024 LACTULOSE' 607 'D01025 LOPERAMIDE'
             608 'D01026 BISMUTH SUBSALICYLATE' 609 'D01027 SIMETHICONE'
             610 'D01028 CHARCOAL' 611 'D01030 DEHYDROCHOLIC ACID'
             612 'D01031 MESALAMINE' 613 'D01032 OLSALAZINE'
             614 'D01068 DEMECLOCYCLINE' 615 'D01070 OXYTETRACYCLINE'
             616 'D01090 SULFAMETHIZOLE' 617 'D01097 RIFABUTIN'
             618 'D01100 ETHIONAMIDE' 619 'D01101 CYCLOSERINE'
             620 'D01104 PAROMOMYCIN' 621 'D01105 IODOQUINOL'
             622 'D01112 COLISTIN SULFATE OTIC' 623 'D01113 COLISTIMETHATE'
             624 'D01115 BACITRACIN' 625 'D01120 ATOVAQUONE'
             626 'D01121 CLOFAZIMINE' 627 'D01123 PYRANTEL'
             628 'D01124 PIPERAZINE' 629 'D01128 METHYLENE BLUE'
             630 'D01129 CINOXACIN' 631 'D01133 IMMUNE GLOBULIN INTRAVENOUS'
             632 'D01135 IMMUNE GLOBULIN INTRAMUSCULAR'
             633 'D01136 HEPATITIS B IMMUNE GLOBULIN'
             634 'D01138 VARICELLA ZOSTER IMMUNE GLOBULIN'
             635 'D01139 RHO (D) IMMUNE GLOBULIN'
             636 'D01141 LYMPHOCYTE IMMUNE GLOBULIN, ANTI-THY (OBS)'
             637 'D01142 DIPHTHERIA ANTITOXIN'
             638 'D01144 ANTIVENIN (CROTALIDAE) POLYVALENT'
             639 'D01146 ANTIVENIN (BLACK WIDOW SPIDER)'
             640 'D01147 RABIES VACCINE (OBSOLETE)'
             641 'D01148 RABIES IMMUNE GLOBULIN, HUMAN' 642 'D01150 BCG'
             643 'D01152 STAPHAGE LYSATE (SPL)'
             644 'D01153 MENINGOCOCCAL POLYSACCHARIDE VACCINE'
             645 'D01156 TYPHOID VACCINE, INACTIVATED'
             646 'D01158 HAEMOPHILUS B CONJUGATE VACCINE (OBSOLETE)'
             647 'D01159 MEASLES VIRUS VACCINE'
             648 'D01160 RUBELLA VIRUS VACCINE'
             649 'D01161 MUMPS VIRUS VACCINE'
             650 'D01162 POLIOVIRUS VACCINE, LIVE, TRIVALENT'
             651 'D01163 POLIOVIRUS VACCINE, INACTIVATED'
             652 'D01164 INFLUENZA VIRUS VACCINE, INACTIVATED'
             653 'D01165 YELLOW FEVER VACCINE'
             654 'D01166 HEPATITIS B VACCINE (OBSOLETE)'
             655 'D01168 TETANUS TOXOID'
             656 'D01171 TUBERCULIN PURIFIED PROTEIN DERIVATIVE'
             657 'D01184 DIPIVEFRIN OPHTHALMIC'
             658 'D01187 LEVOBUNOLOL OPHTHALMIC'
             659 'D01188 ACETYLCHOLINE OPHTHALMIC'
             660 'D01191 PILOCARPINE OPHTHALMIC'
             661 'D01195 ECHOTHIOPHATE IODIDE OPHTHALMIC'
             662 'D01199 HOMATROPINE OPHTHALMIC'
             663 'D01200 TROPICAMIDE OPHTHALMIC'
             664 'D01201 CYCLOPENTOLATE OPHTHALMIC'
             665 'D01204 SUPROFEN OPHTHALMIC'
             666 'D01208 SULFACETAMIDE SODIUM OPHTHALMIC'
             667 'D01210 YELLOW MERCURIC OXIDE OPHTHALMIC'
             668 'D01215 TRIFLURIDINE OPHTHALMIC' 669 'D01217 TETRACAINE'
             670 'D01218 PROPARACAINE OPHTHALMIC'
             671 'D01219 FLUORESCEIN OPHTHALMIC'
             672 'D01222 SODIUM HYALURONATE OPHTHALMIC'
             673 'D01225 BORIC ACID TOPICAL'
             674 'D01226 HYDROXYPROPYL METHYLCELLULOSE OPHTHALMIC'
             675 'D01227 BOTULINUM TOXIN TYPE A (OBSOLETE)'
             676 'D01231 CHLORHEXIDINE TOPICAL'
             677 'D01232 CARBAMIDE PEROXIDE TOPICAL' 678 'D01233 NYSTATIN'
             679 'D01234 BUTOCONAZOLE TOPICAL'
             680 'D01235 TIOCONAZOLE TOPICAL' 681 'D01236 CLOTRIMAZOLE'
             682 'D01238 TERCONAZOLE TOPICAL'
             683 'D01239 GENTIAN VIOLET TOPICAL'
             684 'D01240 SULFANILAMIDE TOPICAL'
             685 'D01241 CLINDAMYCIN TOPICAL'
             686 'D01242 NONOXYNOL 9 TOPICAL' 687 'D01243 OCTOXYNOL TOPICAL'
             688 'D01244 TRETINOIN TOPICAL' 689 'D01245 ISOTRETINOIN'
             690 'D01246 BENZOYL PEROXIDE TOPICAL'
             691 'D01254 ANTHRALIN TOPICAL'
             692 'D01257 NITROFURAZONE TOPICAL' 693 'D01258 MAFENIDE TOPICAL'
             694 'D01259 SILVER SULFADIAZINE TOPICAL'
             695 'D01263 PYRITHIONE ZINC TOPICAL'
             696 'D01265 SULFACETAMIDE SODIUM TOPICAL'
             697 'D01266 CHLOROXINE TOPICAL' 698 'D01267 MUPIROCIN TOPICAL'
             699 'D01271 ECONAZOLE TOPICAL' 700 'D01272 CICLOPIROX TOPICAL'
             701 'D01273 TRIACETIN TOPICAL' 702 'D01274 TOLNAFTATE TOPICAL'
             703 'D01275 SULCONAZOLE TOPICAL' 704 'D01277 NAFTIFINE TOPICAL'
             705 'D01278 LINDANE TOPICAL' 706 'D01279 PERMETHRIN TOPICAL'
             707 'D01280 CROTAMITON TOPICAL'
             708 'D01282 ALCLOMETASONE TOPICAL'
             709 'D01288 CLOBETASOL TOPICAL'
             710 'D01289 CLOCORTOLONE TOPICAL' 711 'D01290 DESONIDE TOPICAL'
             712 'D01291 DESOXIMETASONE TOPICAL'
             713 'D01292 DIFLORASONE TOPICAL'
             714 'D01293 FLUOCINOLONE TOPICAL'
             715 'D01294 FLUOCINONIDE TOPICAL'
             716 'D01295 FLURANDRENOLIDE TOPICAL' 717 'D01296 FLUTICASONE'
             718 'D01298 HALOBETASOL TOPICAL' 719 'D01300 MOMETASONE TOPICAL'
             720 'D01301 DIBUCAINE TOPICAL' 721 'D01302 BUTAMBEN TOPICAL'
             722 'D01303 PRAMOXINE TOPICAL' 723 'D01305 DYCLONINE TOPICAL'
             724 'D01306 COCAINE TOPICAL' 725 'D01307 SALICYLIC ACID TOPICAL'
             726 'D01308 PODOPHYLLUM RESIN TOPICAL'
             727 'D01309 PODOFILOX TOPICAL'
             728 'D01313 TRICHLOROACETIC ACID TOPICAL'
             729 'D01314 SUTILAINS TOPICAL' 730 'D01315 COLLAGENASE TOPICAL'
             731 'D01316 MASOPROCOL TOPICAL'
             732 'D01319 HYDROQUINONE TOPICAL'
             733 'D01320 FORMALDEHYDE TOPICAL' 734 'D01321 CAPSAICIN TOPICAL'
             735 'D01322 ALUMINUM CHLORIDE HEXAHYDRATE TOPICAL'
             736 'D01323 MONOBENZONE TOPICAL' 737 'D01325 ARNICA TOPICAL'
             738 'D01332 HEXACHLOROPHENE TOPICAL'
             739 'D01333 BENZALKONIUM CHLORIDE TOPICAL'
             740 'D01335 SODIUM HYPOCHLORITE TOPICAL'
             741 'D01338 PHYSIOLOGICAL IRRIGATING SOLUTION'
             742 'D01339 MECHLORETHAMINE' 743 'D01341 LOMUSTINE'
             744 'D01342 CARMUSTINE' 745 'D01344 FLOXURIDINE'
             746 'D01345 THIOGUANINE' 747 'D01346 FLUDARABINE'
             748 'D01348 MEGESTROL' 749 'D01351 ESTRAMUSTINE'
             750 'D01353 LEUPROLIDE' 751 'D01354 GOSERELIN'
             752 'D01356 PENTOSTATIN' 753 'D01361 PLICAMYCIN'
             754 'D01368 INTERFERON ALFA-2A' 755 'D01369 INTERFERON ALFA-2B'
             756 'D01372 ALTRETAMINE' 757 'D01373 HYDROXYUREA'
             758 'D01375 ALDESLEUKIN' 759 'D01376 PACLITAXEL'
             760 'D01378 MITOTANE' 761 'D01379 ASPARAGINASE ESCHERICHIA COLI'
             762 'D01382 ETHANOLAMINE OLEATE'
             763 'D01383 SODIUM TETRADECYL SULFATE'
             764 'D01384 MORRHUATE SODIUM' 765 'D01385 BETA-CAROTENE'
             766 'D01386 YOHIMBINE' 767 'D01387 ALPROSTADIL'
             768 'D01389 DISULFIRAM' 769 'D01393 HYALURONIDASE'
             770 'D01394 PROCAINE' 771 'D01395 CHLOROPROCAINE'
             772 'D01396 PRILOCAINE' 773 'D01398 MEPIVACAINE'
             774 'D01402 DEFEROXAMINE' 775 'D01404 SODIUM THIOSULFATE'
             776 'D01406 NALTREXONE' 777 'D01407 FLUMAZENIL'
             778 'D01409 PRALIDOXIME' 779 'D01410 DIGOXIN IMMUNE FAB'
             780 'D01411 MESNA' 781 'D01413 IPECAC' 782 'D01416 TRIENTINE'
             783 'D01417 SUCCIMER' 784 'D01420 AMBENONIUM'
             785 'D01422 GUANIDINE' 786 'D01423 POTASSIUM CITRATE'
             787 'D01424 POTASSIUM ACID PHOSPHATE' 788 'D01425 FLAVOXATE'
             789 'D01427 BETHANECHOL' 790 'D01431 DIMETHYL SULFOXIDE'
             791 'D01433 ACETOHYDROXAMIC ACID' 792 'D01434 METHOXSALEN'
             793 'D01438 IOPANOIC ACID' 794 'D01445 BARIUM SULFATE'
             795 'D01451 GADOPENTETATE DIMEGLUMINE' 796 'D01452 IODAMIDE'
             797 'D01456 IOHEXOL' 798 'D01461 IOPAMIDOL'
             799 'D01469 IOVERSOL' 800 'D01472 METRIZAMIDE'
             801 'D01473 DIATRIZOATE' 802 'D01475 IOTHALAMATE'
             803 'D01476 ETHIODIZED OIL' 804 'D01482 ISOSULFAN BLUE'
             805 'D02373 PHOSPHORATED CARBOHYDRATE SOLUTION'
             806 'D02374 DESFLURANE' 807 'D02375 PLASMA PROTEIN FRACTION'
             808 'D02376 ALBUMIN HUMAN' 809 'D02378 HETASTARCH'
             810 'D02381 POTASSIUM PERCHLORATE' 811 'D03001 CLADRIBINE'
             812 'D03003 DIPHTHERIA-TETANUS TOXOIDS (OBSOLETE)'
             813 'D03004 DIPHTHERIA/PERTUSSIS, WHOLE CELL/TETANUS'
             814 'D03006 MEASLES-RUBELLA VIRUS VACCINE'
             815 'D03007 MEASLES/MUMPS/RUBELLA VIRUS VACCINE'
             816 'D03008 INTERFERON GAMMA-1B' 817 'D03034 NORGESTREL'
             818 'D03041 ENOXAPARIN' 819 'D03050 LORATADINE'
             820 'D03051 INTERFERON BETA-1B'
             821 'D03052 HYDROCHLOROTHIAZIDE-TRIAMTERENE'
             822 'D03054 AMYLASE' 823 'D03056 ATTAPULGITE'
             824 'D03058 BENZOIC ACID' 825 'D03061 BUTALBITAL'
             826 'D03062 CASANTHRANOL' 827 'D03066 CITRIC ACID'
             828 'D03068 DICHLORALPHENAZONE' 829 'D03075 HYDROCODONE'
             830 'D03077 ISOMETHEPTENE MUCATE' 831 'D03085 PEPSIN'
             832 'D03086 PHENIRAMINE' 833 'D03089 PHENYLTOLOXAMINE'
             834 'D03094 SALICYLAMIDE' 835 'D03096 SODIUM BENZOATE'
             836 'D03097 SODIUM BORATE TOPICAL' 837 'D03098 SODIUM CITRATE'
             838 'D03109 JAPANESE ENCEPHALITIS VIRUS VACCINE NAKAYAMA'
             839 'D03110 DIPHTH/PERTUSSIS, ACEL/TETANUS (OBSOLETE)'
             840 'D03112 NEDOCROMIL'
             841 'D03113 DEXTRAN, LOW MOLECULAR WEIGHT'
             842 'D03114 DEXTRAN, HIGH MOLECULAR WEIGHT'
             843 'D03116 BISMUTH SUBGALLATE' 844 'D03118 MUROMONAB-CD3'
             845 'D03125 DIHYDROTACHYSTEROL' 846 'D03126 CALCITRIOL'
             847 'D03128 ERGOCALCIFEROL' 848 'D03129 CHOLECALCIFEROL'
             849 'D03130 THIAMINE' 850 'D03133 HYDROXOCOBALAMIN'
             851 'D03135 PHYTONADIONE' 852 'D03136 VITAMIN A & D TOPICAL'
             853 'D03137 CALCIUM-VITAMIN D' 854 'D03140 MULTIVITAMIN'
             855 'D03141 MULTIVITAMIN WITH IRON'
             856 'D03143 MULTIVITAMIN WITH FLUORIDE'
             857 'D03145 MULTIVITAMIN WITH MINERALS'
             858 'D03148 MULTIVITAMIN, PRENATAL' 859 'D03152 TRIFLUPROMAZINE'
             860 'D03154 DOXYLAMINE' 861 'D03157 PAROXETINE'
             862 'D03158 RIMANTADINE' 863 'D03159 CHOLINE'
             864 'D03160 SUMATRIPTAN' 865 'D03162 ALCOHOL (ETHANOL)'
             866 'D03165 PIPERACILLIN-TAZOBACTAM' 867 'D03166 CISAPRIDE'
             868 'D03168 DIHYDROCODEINE' 869 'D03169 TRIMETREXATE'
             870 'D03170 FELBAMATE' 871 'D03171 GRANISETRON'
             872 'D03173 DORNASE ALFA' 873 'D03176 TACRINE'
             874 'D03180 RISPERIDONE' 875 'D03181 VENLAFAXINE'
             876 'D03182 GABAPENTIN' 877 'D03183 FLUVASTATIN'
             878 'D03187 LEVOMETHADYL ACETATE' 879 'D03189 TORSEMIDE'
             880 'D03190 OXICONAZOLE TOPICAL'
             881 'D03191 TERBINAFINE TOPICAL' 882 'D03192 ZINC OXIDE TOPICAL'
             883 'D03193 AMILORIDE-HYDROCHLOROTHIAZIDE'
             884 'D03195 MICONAZOLE TOPICAL' 885 'D03196 GENTAMICIN TOPICAL'
             886 'D03197 BETAMETHASONE TOPICAL'
             887 'D03200 ERYTHROMYCIN TOPICAL' 888 'D03201 ACYCLOVIR TOPICAL'
             889 'D03202 KETOCONAZOLE TOPICAL' 890 'D03203 MINOXIDIL TOPICAL'
             891 'D03204 FLUOROURACIL TOPICAL'
             892 'D03205 HYDROCORTISONE TOPICAL'
             893 'D03206 TRIAMCINOLONE TOPICAL'
             894 'D03207 AMPHOTERICIN B TOPICAL'
             895 'D03208 METRONIDAZOLE TOPICAL'
             896 'D03210 SELENIUM SULFIDE TOPICAL'
             897 'D03211 CIPROFLOXACIN OPHTHALMIC'
             898 'D03212 ATROPINE OPHTHALMIC'
             899 'D03213 DICLOFENAC OPHTHALMIC'
             900 'D03214 KETOROLAC OPHTHALMIC'
             901 'D03221 PREDNISOLONE OPHTHALMIC'
             902 'D03222 TOBRAMYCIN OPHTHALMIC' 903 'D03224 NEOMYCIN TOPICAL'
             904 'D03226 SALIVA SUBSTITUTES'
             905 'D03227 FLUOROMETHOLONE OPHTHALMIC'
             906 'D03228 LODOXAMIDE OPHTHALMIC'
             907 'D03229 LEVOCABASTINE OPHTHALMIC'
             908 'D03231 TRIPLE SULFA TOPICAL'
             909 'D03232 VITAMINS A, D, AND E TOPICAL'
             910 'D03233 VITAMIN E TOPICAL'
             911 'D03238 ETHINYL ESTRADIOL-NORETHINDRONE'
             912 'D03240 MESTRANOL-NORETHINDRONE'
             913 'D03241 ETHINYL ESTRADIOL-NORGESTREL'
             914 'D03242 ETHINYL ESTRADIOL-LEVONORGESTREL'
             915 'D03245 ESTERIFIED ESTROGENS-METHYLTESTOSTERONE'
             916 'D03247 HYDROCHLOROTHIAZIDE-SPIRONOLACTONE'
             917 'D03251 HYDROCHLOROTHIAZIDE-RESERPINE'
             918 'D03255 BENDROFLUMETHIAZIDE-RAUWOLFIA SERPENTINA'
             919 'D03256 HYDRALAZINE/HYDROCHLOROTHIAZIDE/RESERPINE'
             920 'D03257 HYDRALAZINE-HYDROCHLOROTHIAZIDE'
             921 'D03258 ATENOLOL-CHLORTHALIDONE'
             922 'D03259 BENDROFLUMETHIAZIDE-NADOLOL'
             923 'D03260 HYDROCHLOROTHIAZIDE-TIMOLOL'
             924 'D03261 HYDROCHLOROTHIAZIDE-PROPRANOLOL'
             925 'D03263 HYDROCHLOROTHIAZIDE-METHYLDOPA'
             926 'D03264 HYDROCHLOROTHIAZIDE-METOPROLOL'
             927 'D03265 BENAZEPRIL-HYDROCHLOROTHIAZIDE'
             928 'D03266 HYDROCHLOROTHIAZIDE-LISINOPRIL'
             929 'D03267 CHLORTHALIDONE-CLONIDINE'
             930 'D03271 PHENIRAMINE-PHENYLEPHRINE NASAL'
             931 'D03273 GUAIFENESIN-THEOPHYLLINE'
             932 'D03274 AMINOPHYLLINE-GUAIFENESIN'
             933 'D03276 DYPHYLLINE-GUAIFENESIN'
             934 'D03277 POTASSIUM IODIDE-THEOPHYLLINE'
             935 'D03280 EPHEDRINE/PHENOBARBITAL/THEOPHYLLINE'
             936 'D03283 EPHEDRINE/HYDROXYZINE/THEOPHYLLINE'
             937 'D03289 ACETAMINOPHEN-PSEUDOEPHEDRINE'
             938 'D03292 IBUPROFEN-PSEUDOEPHEDRINE' 939 'D03293 APAP/ASA/PPA'
             940 'D03296 ACETAMINOPHEN-CHLORPHENIRAMINE'
             941 'D03297 ACETAMINOPHEN-PHENYLTOLOXAMINE'
             942 'D03298 CHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             943 'D03299 CHLORPHENIRAMINE-PHENYLPROPANOLAMINE'
             944 'D03300 CHLORPHENIRAMINE-PHENYLEPHRINE'
             945 'D03301 BROMPHENIRAMINE-PSEUDOEPHEDRINE'
             946 'D03302 BROMPHENIRAMINE-PHENYLPROPANOLAMINE'
             947 'D03303 CLEMASTINE-PHENYLPROPANOLAMINE'
             948 'D03306 CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             949 'D03307 CHLORPHENIRAMINE/PHENINDAMINE/PPA'
             950 'D03308 PHENIRAMINE/PPA/PHENYLTOLOXAMINE/PYRILAMINE'
             951 'D03310 CHLORPHENIRAMINE/PE/PPA/PHENYLTOLOXAMINE'
             952 'D03311 BROMPHENIRAMINE-PHENYLEPHRINE'
             953 'D03312 DIPHENHYDRAMINE-PSEUDOEPHEDRINE'
             954 'D03313 CHLORPHENIRAMINE/PHENYLEPHRINE/PYRILAMINE'
             955 'D03316 PSEUDOEPHEDRINE-TRIPROLIDINE'
             956 'D03317 PHENYLEPHRINE-PROMETHAZINE'
             957 'D03318 PHENIRAMINE/PPA/PYRILAMINE'
             958 'D03319 APAP/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             959 'D03320 APAP/CHLORPHENIRAMINE/PSEUDOEPHEDRINE'
             960 'D03321 APAP/BROMPHENIRAMINE/PSEUDOEPHEDRINE'
             961 'D03322 ASA/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             962 'D03329 ASA/DIPHENHYDRAMINE/PPA'
             963 'D03330 APAP/PSEUDOEPHEDRINE/TRIPROLIDINE'
             964 'D03331 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE'
             965 'D03336 APAP/CPM/PHENYLEPHRINE/PPA/PYRILAMINE'
             966 'D03338 CHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             967 'D03340 HOMATROPINE-HYDROCODONE'
             968 'D03341 CODEINE-PSEUDOEPHEDRINE'
             969 'D03342 APAP/DEXTROMETHORPHAN/PSEUDOEPHEDRINE'
             970 'D03347 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             971 'D03349 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PSE'
             972 'D03351 ASA/BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             973 'D03352 HYDROCODONE-PSEUDOEPHEDRINE'
             974 'D03353 HYDROCODONE-PHENYLPROPANOLAMINE'
             975 'D03354 DEXTROMETHORPHAN-PSEUDOEPHEDRINE'
             976 'D03355 DEXTROMETHORPHAN-PHENYLPROPANOLAMINE'
             977 'D03356 CHLORPHENIRAMINE-HYDROCODONE'
             978 'D03357 CODEINE-PROMETHAZINE'
             979 'D03359 CHLORPHENIRAMINE-DEXTROMETHORPHAN'
             980 'D03360 DEXTROMETHORPHAN-PROMETHAZINE'
             981 'D03361 CHLORPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             982 'D03362 CHLORPHENIRAMINE/CODEINE/PSEUDOEPHEDRINE'
             983 'D03364 CODEINE/PHENYLEPHRINE/PROMETHAZINE'
             984 'D03366 HYDROCODONE/PHENYLEPHRINE/PYRILAMINE'
             985 'D03368 BROMPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             986 'D03369 CHLORPHENIRAMINE/DEXTROMETHORP/PHENYLEPHRINE'
             987 'D03370 CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             988 'D03371 DEXTROMETHORPHAN/PHENYLEPHRINE/PYRILAMINE'
             989 'D03372 BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             990 'D03378 ACETAMINOPHEN-DEXTROMETHORPHAN'
             991 'D03379 GUAIFENESIN-PSEUDOEPHEDRINE'
             992 'D03380 EPHEDRINE-GUAIFENESIN'
             993 'D03381 GUAIFENESIN-PHENYLEPHRINE'
             994 'D03382 GUAIFENESIN-PHENYLPROPANOLAMINE'
             995 'D03383 GUAIFENESIN/PHENYLEPHRINE/PPA'
             996 'D03388 ETHINYL ESTRADIOL-ETHYNODIOL'
             997 'D03389 ESTRADIOL-TESTOSTERONE'
             998 'D03392 CHLORPHENIRAMINE/GUAIFENESIN/PHENYLEPHRINE'
             999 'D03393 CODEINE-GUAIFENESIN'
             1000 'D03396 GUAIFENESIN-HYDROCODONE'
             1001 'D03397 GUAIFENESIN-HYDROMORPHONE'
             1002 'D03398 CODEINE/GUAIFENESIN/PSE'
             1003 'D03400 DEXTROMETHORPHAN-GUAIFENESIN'
             1004 'D03403 GUAIFENESIN/HYDROCODONE/PHENYLEPHRINE'
             1005 'D03404 GUAIFENESIN/HYDROCODONE/PSEUDOEPHEDRINE'
             1006 'D03407 CODEINE/GUAIFENESIN/PHENYLPROPANOLAMINE'
             1007 'D03408 DEXTROMETHORPHAN/GUAIFENESIN/PHENYLEPHRINE'
             1008 'D03409 DEXTROMETHORPHAN/GUAIFENESIN/PSEUDOEPHEDRINE'
             1009 'D03411 DEXTROMETHORPHAN/GUAIFENESIN/PPA'
             1010 'D03416 CHLORPHENIRAMINE/HYDROCODONE/PSE'
             1011 'D03419 CHLORPHENIRAMINE/DM/GUAIFENESIN/PHENYLEPHRINE'
             1012 'D03423 ACETAMINOPHEN-CODEINE'
             1013 'D03424 ASPIRIN-CODEINE'
             1014 'D03425 APAP/BUTALBITAL/CAFFEINE/CODEINE'
             1015 'D03426 ASA/BUTALBITAL/CAFFEINE/CODEINE'
             1016 'D03428 ACETAMINOPHEN-HYDROCODONE'
             1017 'D03430 ASA/CAFFEINE/DIHYDROCODEINE'
             1018 'D03431 ACETAMINOPHEN-OXYCODONE'
             1019 'D03432 ASPIRIN-OXYCODONE'
             1020 'D03433 MEPERIDINE-PROMETHAZINE'
             1021 'D03434 ACETAMINOPHEN-PROPOXYPHENE'
             1022 'D03435 ASA/CAFFEINE/PROPOXYPHENE'
             1023 'D03436 BELLADONNA-OPIUM'
             1024 'D03437 APAP/ASA/CAFFEINE/SALICYLAMIDE'
             1025 'D03439 APAP/ASA/CAFFEINE'
             1026 'D03443 APAP/AL HYDROXIDE/ASA/CAFFEINE/MG HYDROXIDE'
             1027 'D03445 ACETAMINOPHEN-DIPHENHYDRAMINE'
             1028 'D03447 ASA/CAFFEINE/SALICYLAMIDE'
             1029 'D03448 ASPIRIN-MEPROBAMATE' 1030 'D03449 ASPIRIN-CAFFEINE'
             1031 'D03453 ASPIRIN-PHENYLTOLOXAMINE'
             1032 'D03454 MAGNESIUM SALICYLATE-PHENYLTOLOXAMINE'
             1033 'D03455 APAP/BUTALBITAL/CAFFEINE'
             1034 'D03456 ACETAMINOPHEN-BUTALBITAL'
             1035 'D03457 ASA/BUTALBITAL/CAFFEINE'
             1036 'D03459 APAP/DICHLORALPHENAZONE/ISOMETHEPTENE'
             1037 'D03462 AMITRIPTYLINE-CHLORDIAZEPOXIDE'
             1038 'D03463 AMITRIPTYLINE-PERPHENAZINE'
             1039 'D03464 DROPERIDOL-FENTANYL'
             1040 'D03468 ASPIRIN-METHOCARBAMOL'
             1041 'D03469 ASPIRIN-CARISOPRODOL'
             1042 'D03470 ASA/CARISOPRODOL/CODEINE'
             1043 'D03472 ASA/CAFFEINE/ORPHENADRINE'
             1044 'D03473 CARBIDOPA-LEVODOPA'
             1045 'D03474 ALUMINUM HYDROXIDE-MAGNESIUM HYDROXIDE'
             1046 'D03478 AL HYDROXIDE/MG HYDROXIDE/SIMETHICONE'
             1047 'D03480 CA CARBONATE/MG HYDROXIDE/SIMETHICONE'
             1048 'D03485 ATROPINE/HYOSCYAMINE/PB/SCOPOLAMINE'
             1049 'D03486 BELLADONNA-BUTABARBITAL'
             1050 'D03492 CHLORDIAZEPOXIDE-CLIDINIUM'
             1051 'D03495 BELLADONNA/ERGOTAMINE/PHENOBARBITAL'
             1052 'D03496 DOCUSATE-SENNA'
             1053 'D03497 DOCUSATE-PHENOLPHTHALEIN'
             1054 'D03498 CASANTHRANOL-DOCUSATE'
             1055 'D03505 ATROPINE-DIFENOXIN'
             1056 'D03506 ATROPINE-DIPHENOXYLATE'
             1057 'D03508 ISONIAZID-RIFAMPIN'
             1058 'D03509 ERYTHROMYCIN-SULFISOXAZOLE'
             1059 'D03511 PHENAZOPYRIDINE-SULFAMETHOXAZOLE'
             1060 'D03513 METHENAMINE-SODIUM ACID PHOSPHATE'
             1061 'D03517 BENZOIC ACID/METHENAMINE/SODIUM SALICYLATE'
             1062 'D03520 NAPHAZOLINE-PHENIRAMINE OPHTHALMIC'
             1063 'D03521 CYCLOPENTOLATE-PHENYLEPHRINE OPHTHALMIC'
             1064 'D03523 HYDROXYAMPHETAMINE-TROPICAMIDE OPHTHALMIC'
             1065 'D03524 BACITRACIN/NEOMYCIN/POLYMYXIN B TOPICAL'
             1066 'D03525 GRAMICIDIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1067 'D03526 NEOMYCIN-POLYMYXIN B SULFATE TOPICAL'
             1068 'D03527 BACITRACIN-POLYMYXIN B TOPICAL'
             1069 'D03529 POLYMYXIN B-TRIMETHOPRIM OPHTHALMIC'
             1070 'D03533 NEOMYCIN/POLYMYXIN B/PREDNISOLONE OPHTHALMIC'
             1071 'D03536 DEXAMETHASONE-TOBRAMYCIN OPHTHALMIC'
             1072 'D03537 DEXAMETHASONE/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1073 'D03541 PREDNISOLONE-SULFACETAMIDE SODIUM OPHTHALMIC'
             1074 'D03542 FLUORESCEIN-PROPARACAINE OPHTHALMIC'
             1075 'D03543 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OTIC'
             1076 'D03544 HYDROCORTISONE-POLYMYXIN B OTIC'
             1077 'D03546 HYDROCORTISONE-PRAMOXINE TOPICAL'
             1078 'D03552 CLIOQUINOL-HYDROCORTISONE TOPICAL'
             1079 'D03553 CLIOQUINOL/HYDROCORTISONE/PRAMOXINE TOPICAL'
             1080 'D03561 BETAMETHASONE-CLOTRIMAZOLE TOPICAL'
             1081 'D03562 NYSTATIN-TRIAMCINOLONE TOPICAL'
             1082 'D03566 CAPTOPRIL-HYDROCHLOROTHIAZIDE'
             1083 'D03569 CARBINOXAMINE'
             1084 'D03570 CARBINOXAMINE-PSEUDOEPHEDRINE'
             1085 'D03572 CARAMIPHEN-PHENYLPROPANOLAMINE'
             1086 'D03576 BROMODIPHENHYDRAMINE-CODEINE'
             1087 'D03577 CARBINOXAMINE/DEXTROMETHORPHAN/PSE'
             1088 'D03584 CODEINE/PHENIRAMINE/PHENYLEPHRINE/NA CITRATE'
             1089 'D03585 PAMABROM' 1090 'D03586 APAP/PAMABROM/PYRILAMINE'
             1091 'D03588 MAGNESIUM CARBONATE'
             1092 'D03591 ALGINIC ACID/AL HYDROXIDE/MG CARBONATE'
             1093 'D03596 ALGINIC ACID/AL HYDROXIDE/MG TRISILICATE'
             1094 'D03600 POTASSIUM BICARBONATE' 1095 'D03613 PSYLLIUM-SENNA'
             1096 'D03618 HYOSCYAMINE/METHENAM/M-BLUE/PHENYL SALICYL'
             1097 'D03620 ANTAZOLINE-NAPHAZOLINE OPHTHALMIC'
             1098 'D03622 BENOXINATE-FLUORESCEIN OPHTHALMIC'
             1099 'D03623 ACETIC ACID TOPICAL' 1100 'D03624 ANTIPYRINE OTIC'
             1101 'D03625 ACETIC ACID-HYDROCORTISONE OTIC'
             1102 'D03627 ANTIPYRINE-BENZOCAINE OTIC'
             1103 'D03628 ANTIPYRINE/BENZOCAINE/PHENYLEPHRINE OTIC'
             1104 'D03630 ANHYDROUS CALCIUM IODIDE-CODEINE'
             1105 'D03632 CETYLPYRIDINIUM TOPICAL'
             1106 'D03634 BENZOCAINE-CETYLPYRIDINIUM TOPICAL'
             1107 'D03640 BUDESONIDE NASAL' 1108 'D03641 PETROLATUM TOPICAL'
             1109 'D03644 LACTOBACILLUS ACIDOPHILUS'
             1110 'D03646 LACTOBACILLUS ACIDOPHILUS AND BULGARICUS'
             1111 'D03647 ISOPROPYL ALCOHOL TOPICAL'
             1112 'D03648 OPHTHALMIC IRRIGATION, INTRAOCULAR'
             1113 'D03649 BENZOIN TOPICAL'
             1114 'D03650 CANDIDA ALBICANS EXTRACT'
             1115 'D03651 CHOLINE SALICYLATE-MAGNESIUM SALICYLATE'
             1116 'D03652 COLCHICINE-PROBENECID'
             1117 'D03653 CALAMINE TOPICAL'
             1118 'D03655 LIDOCAINE-PRILOCAINE TOPICAL'
             1119 'D03656 ETHYL CHLORIDE TOPICAL'
             1120 'D03659 FIBRINOLYSIN AND DESOXYRIBONUCLEASE TOPICAL'
             1121 'D03660 MULTIVITAMIN WITH IRON AND FLUORIDE'
             1122 'D03661 DOCUSATE-FERROUS FUMARATE' 1123 'D03663 LECITHIN'
             1124 'D03664 PHENOL TOPICAL' 1125 'D03665 MENTHOL TOPICAL'
             1126 'D03666 MENTHOL-PHENOL TOPICAL' 1127 'D03667 METHACHOLINE'
             1128 'D03668 METHYL SALICYLATE TOPICAL' 1129 'D03674 PECTIN'
             1130 'D03676 NALOXONE-PENTAZOCINE'
             1131 'D03678 NAPHAZOLINE-ZINC OPHTHALMIC'
             1132 'D03680 ASA/CITRIC ACID/NA BICARB'
             1133 'D03681 OPHTHALMIC IRRIGATION, EXTRAOCULAR'
             1134 'D03682 ACETAMINOPHEN-PENTAZOCINE'
             1135 'D03684 THROMBIN TOPICAL'
             1136 'D03686 UNDECYLENIC ACID TOPICAL'
             1137 'D03687 ALUMINUM ACETATE TOPICAL'
             1138 'D03688 ALUMINUM SULFATE TOPICAL'
             1139 'D03689 CALCIUM ACETATE'
             1140 'D03690 ALUMINUM SULFATE-CALCIUM ACETATE TOPICAL'
             1141 'D03691 BENZOCAINE/PHENOL/POVIDONE IODINE TOPICAL'
             1142 'D03693 ICHTHAMMOL TOPICAL'
             1143 'D03694 MEDRYSONE OPHTHALMIC'
             1144 'D03695 PRAMOXINE-ZINC OXIDE TOPICAL'
             1145 'D03696 BENZYL BENZOATE TOPICAL'
             1146 'D03701 CORN STARCH TOPICAL' 1147 'D03702 SULFUR TOPICAL'
             1148 'D03703 COAL TAR TOPICAL'
             1149 'D03705 SALICYLIC ACID-SULFUR TOPICAL'
             1150 'D03707 ALOE VERA TOPICAL'
             1151 'D03708 LANOLIN-MINERAL OIL TOPICAL'
             1152 'D03710 ALLANTOIN/CAMPHOR/PHENOL TOPICAL'
             1153 'D03712 CAMPHOR TOPICAL'
             1154 'D03713 CAMPHOR-PHENOL TOPICAL'
             1155 'D03716 CITRIC ACID/GLUCONODELTA-LACTONE/MG CARBONATE'
             1156 'D03721 SODIUM IODIDE'
             1157 'D03724 FAT EMULSION, INTRAVENOUS'
             1158 'D03725 INTRAVENOUS ELECTROLYTE SOLUTION'
             1159 'D03735 TRIETHANOLAMINE POLYPEPTIDE OLEATE OTIC'
             1160 'D03738 TETRACYCLINE TOPICAL' 1161 'D03739 NIACINAMIDE'
             1162 'D03740 ENALAPRIL-HYDROCHLOROTHIAZIDE'
             1163 'D03743 PYRIMETHAMINE-SULFADOXINE'
             1164 'D03744 BISOPROLOL-HYDROCHLOROTHIAZIDE'
             1165 'D03750 DEXBROMPHENIRAMINE'
             1166 'D03751 DEXBROMPHENIRAMINE-PSEUDOEPHEDRINE'
             1167 'D03752 TACROLIMUS'
             1168 'D03754 ACRIVASTINE-PSEUDOEPHEDRINE'
             1169 'D03756 BACITRACIN TOPICAL' 1170 'D03759 SALMETEROL'
             1171 'D03760 DIPHENHYDRAMINE TOPICAL'
             1172 'D03761 LANOLIN TOPICAL' 1173 'D03762 WITCH HAZEL TOPICAL'
             1174 'D03763 GLYCERIN-PHENOL TOPICAL'
             1175 'D03764 GLYCERIN-WITCH HAZEL TOPICAL'
             1176 'D03766 ROCURONIUM' 1177 'D03767 IRON DEXTRAN'
             1178 'D03768 OCULAR LUBRICANT' 1179 'D03770 EMOLLIENTS, TOPICAL'
             1180 'D03773 STAVUDINE' 1181 'D03774 DOXEPIN TOPICAL'
             1182 'D03775 FAMCICLOVIR' 1183 'D03777 POTASSIUM ACETATE'
             1184 'D03780 DESOGESTREL'
             1185 'D03781 ETHINYL ESTRADIOL-NORGESTIMATE'
             1186 'D03782 DESOGESTREL-ETHINYL ESTRADIOL'
             1187 'D03783 BUPIVACAINE-EPINEPHRINE'
             1188 'D03784 EPINEPHRINE-LIDOCAINE'
             1189 'D03788 CALCIPOTRIENE TOPICAL'
             1190 'D03789 POTASSIUM GLUCONATE'
             1191 'D03790 POTASSIUM PHOSPHATE'
             1192 'D03796 MAGNESIUM CHLORIDE' 1193 'D03797 MAGNESIUM OXIDE'
             1194 'D03798 MAGNESIUM GLUCONATE' 1195 'D03799 CALCIUM CHLORIDE'
             1196 'D03800 CALCIUM GLUCONATE' 1197 'D03802 CALCIUM LACTATE'
             1198 'D03803 CALCIUM PHOSPHATE, TRIBASIC'
             1199 'D03804 FLUVOXAMINE' 1200 'D03805 DORZOLAMIDE OPHTHALMIC'
             1201 'D03806 ALBENDAZOLE' 1202 'D03807 METFORMIN'
             1203 'D03808 NEFAZODONE' 1204 'D03809 LAMOTRIGINE'
             1205 'D03810 VINORELBINE' 1206 'D03811 ABCIXIMAB'
             1207 'D03812 DALTEPARIN'
             1208 'D03818 LORATADINE-PSEUDOEPHEDRINE'
             1209 'D03819 CONJUGATED ESTROGENS-MEDROXYPROGESTERONE'
             1210 'D03821 LOSARTAN' 1211 'D03822 FERROUS GLUCONATE'
             1212 'D03823 IRON POLYSACCHARIDE' 1213 'D03824 FERROUS SULFATE'
             1214 'D03825 NISOLDIPINE' 1215 'D03826 TRAMADOL'
             1216 'D03827 CETIRIZINE' 1217 'D03828 LANSOPRAZOLE'
             1218 'D03829 AMLODIPINE-BENAZEPRIL'
             1219 'D03830 HYDROCHLOROTHIAZIDE-LOSARTAN'
             1220 'D03831 NILUTAMIDE' 1221 'D03832 VARICELLA VIRUS VACCINE'
             1222 'D03833 DIVALPROEX SODIUM' 1223 'D03834 NALMEFENE'
             1224 'D03835 MOEXIPRIL' 1225 'D03836 ACITRETIN'
             1226 'D03838 VALACYCLOVIR' 1227 'D03839 MYCOPHENOLATE MOFETIL'
             1228 'D03840 IOPROMIDE' 1229 'D03841 DEXRAZOXANE'
             1230 'D03842 EPOPROSTENOL' 1231 'D03843 GADOTERIDOL'
             1232 'D03844 DIRITHROMYCIN' 1233 'D03845 SEVOFLURANE'
             1234 'D03846 ACARBOSE' 1235 'D03847 CARVEDILOL'
             1236 'D03848 AZELAIC ACID TOPICAL' 1237 'D03849 ALENDRONATE'
             1238 'D03850 BICALUTAMIDE'
             1239 'D03857 BENZOYL PEROXIDE-ERYTHROMYCIN TOPICAL'
             1240 'D03858 LAMIVUDINE' 1241 'D03860 SAQUINAVIR'
             1242 'D03862 MAGNESIUM AMINO ACIDS CHELATE'
             1243 'D03863 TRETINOIN' 1244 'D03864 GLIMEPIRIDE'
             1245 'D03866 CALCIUM CITRATE'
             1246 'D03867 CALCIUM CARBONATE-SODIUM FLUORIDE'
             1247 'D03868 AMIFOSTINE' 1248 'D03869 RILUZOLE'
             1249 'D03870 AMPHOTERICIN B LIPID COMPLEX'
             1250 'D03872 PORFIMER' 1251 'D03873 ANASTROZOLE'
             1252 'D03874 CEFTIBUTEN' 1253 'D03877 HEROIN'
             1254 'D03878 COCAINE' 1255 'D03879 MARIJUANA'
             1256 'D03880 PHENCYCLIDINE'
             1257 'D03881 RESPIRATORY SYNCYTIAL VIRUS IMMUNE GLOBULIN'
             1258 'D03882 CEFEPIME'
             1259 'D03883 AL HYDROXIDE/ASA/CA CARBONATE/MG HYDROXIDE'
             1260 'D03884 TROLAMINE SALICYLATE TOPICAL'
             1261 'D03888 BENZOCAINE/BUTAMBEN/TETRACAINE TOPICAL'
             1262 'D03892 HISTAMINE PHOSPHATE' 1263 'D03894 KAOLIN-PECTIN'
             1264 'D03895 SINCALIDE' 1265 'D03897 LACTASE'
             1266 'D03898 SODIUM CHLORIDE, HYPERTONIC, OPHTHALMIC'
             1267 'D03904 BALSAM PERU/CASTOR OIL/TRYPSIN TOPICAL'
             1268 'D03905 ISOPROTERENOL-PHENYLEPHRINE'
             1269 'D03906 PHENIRAMINE/PHENYLTOLOXAMINE/PYRILAMINE'
             1270 'D03908 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             1271 'D03911 CHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1272 'D03913 APAP/DEXTROMETHORPHAN/PSE/PYRILAMINE'
             1273 'D03915 HYDROCODONE-POTASSIUM GUAIACOLSULFONATE'
             1274 'D03920 FERROUS FUMARATE'
             1275 'D03922 ACETAMINOPHEN-CAFFEINE'
             1276 'D03923 ACETAMINOPHEN-PHENYLEPHRINE'
             1277 'D03926 APAP/CAFFEINE/PYRILAMINE'
             1278 'D03927 BACITRACIN OPHTHALMIC'
             1279 'D03929 AMINOPHYLLINE/AMOBARBITAL/EPHEDRINE'
             1280 'D03946 ASCORBIC ACID-FERROUS FUMARATE'
             1281 'D03951 CITRIC ACID/K CITRATE/NA CITRATE'
             1282 'D03952 CITRIC ACID-SODIUM CITRATE'
             1283 'D03953 ELECTROLYTE REPLACEMENT SOLUTIONS, ORAL'
             1284 'D03954 FERROUS FUMARATE-FOLIC ACID'
             1285 'D03957 CALCIUM/FERROUS FUMARATE/VITAMIN D'
             1286 'D03962 POTASSIUM BICARBONATE-POTASSIUM CITRATE'
             1287 'D03963 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1288 'D03964 BACITRACIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1289 'D03965 BACITRACIN-POLYMYXIN B OPHTHALMIC'
             1290 'D03966 BENZOYL PEROXIDE-SULFUR TOPICAL'
             1291 'D03968 DEXAMETHASONE OPHTHALMIC'
             1292 'D03971 EPINEPHRINE OPHTHALMIC'
             1293 'D03973 ERYTHROMYCIN OPHTHALMIC'
             1294 'D03974 GENTAMICIN OPHTHALMIC'
             1295 'D03975 GLYCERIN OPHTHALMIC'
             1296 'D03976 HYDROCORTISONE OTIC'
             1297 'D03977 OFLOXACIN OPHTHALMIC'
             1298 'D03978 OXYMETAZOLINE OPHTHALMIC'
             1299 'D03979 SCOPOLAMINE OPHTHALMIC'
             1300 'D03980 SULFISOXAZOLE OPHTHALMIC'
             1301 'D03981 TETRACAINE OPHTHALMIC'
             1302 'D03982 TETRACAINE TOPICAL' 1303 'D03984 RITONAVIR'
             1304 'D03985 INDINAVIR' 1305 'D03989 BORIC ACID OPHTHALMIC'
             1306 'D03990 CARBAMIDE PEROXIDE OTIC'
             1307 'D03992 CHLORAMPHENICOL OPHTHALMIC'
             1308 'D03993 CHLORTETRACYCLINE OPHTHALMIC'
             1309 'D03994 COLLOIDAL OATMEAL TOPICAL'
             1310 'D03998 STERILE WATER'
             1311 'D04002 PIPERONYL BUTOXIDE-PYRETHRINS TOPICAL'
             1312 'D04003 HYDROGEN PEROXIDE TOPICAL'
             1313 'D04004 DOXORUBICIN LIPOSOMAL'
             1314 'D04005 AMOBARBITAL-SECOBARBITAL'
             1315 'D04006 DEXFENFLURAMINE' 1316 'D04008 TRANDOLAPRIL'
             1317 'D04009 DOCETAXEL' 1318 'D04010 GEMCITABINE'
             1319 'D04011 INTERFERON BETA-1A' 1320 'D04012 TERBINAFINE'
             1321 'D04014 TOPOTECAN' 1322 'D04015 ADAPALENE TOPICAL'
             1323 'D04016 IODIXANOL' 1324 'D04017 LATANOPROST OPHTHALMIC'
             1325 'D04021 BENZOIC ACID-SALICYLIC ACID TOPICAL'
             1326 'D04025 MIRTAZAPINE' 1327 'D04026 IRINOTECAN'
             1328 'D04027 MEROPENEM' 1329 'D04028 CIDOFOVIR'
             1330 'D04029 NEVIRAPINE' 1331 'D04031 PILOCARPINE'
             1332 'D04032 SULFACETAMIDE SODIUM-SULFUR TOPICAL'
             1333 'D04034 REMIFENTANIL'
             1334 'D04035 AMPHETAMINE-DEXTROAMPHETAMINE'
             1335 'D04036 CAFFEINE-SODIUM BENZOATE'
             1336 'D04037 TIMOLOL OPHTHALMIC'
             1337 'D04038 BETAXOLOL OPHTHALMIC'
             1338 'D04039 CARTEOLOL OPHTHALMIC' 1339 'D04040 FEXOFENADINE'
             1340 'D04041 FOSPHENYTOIN'
             1341 'D04043 FOLLICLE STIMULATING HORMONE'
             1342 'D04044 RESORCINOL TOPICAL'
             1343 'D04045 RESORCINOL-SULFUR TOPICAL' 1344 'D04047 MIDODRINE'
             1345 'D04048 BRIMONIDINE OPHTHALMIC'
             1346 'D04049 AMMONIUM LACTATE TOPICAL' 1347 'D04050 OLANZAPINE'
             1348 'D04051 ROPIVACAINE'
             1349 'D04052 PENTOSAN POLYSULFATE SODIUM'
             1350 'D04053 ZAFIRLUKAST' 1351 'D04054 PENCICLOVIR TOPICAL'
             1352 'D04056 ZINC GLUCONATE' 1353 'D04057 ZINC SULFATE'
             1354 'D04058 MELATONIN'
             1355 'D04059 HAEMOPHILUS B-HEPATITIS B VACCINE'
             1356 'D04060 DILTIAZEM-ENALAPRIL'
             1357 'D04061 BISMUTH SUBSALICYLATE/METRONIDAZOLE/TCN'
             1358 'D04062 BENTOQUATAM TOPICAL'
             1359 'D04063 BUTENAFINE TOPICAL'
             1360 'D04065 TRANDOLAPRIL-VERAPAMIL'
             1361 'D04066 ALBUTEROL-IPRATROPIUM' 1362 'D04067 RETEPLASE'
             1363 'D04068 AZELASTINE NASAL'
             1364 'D04070 SODIUM PHENYLBUTYRATE'
             1365 'D04075 CHLOROXYLENOL TOPICAL'
             1366 'D04076 CHLOROXYLENOL/HYDROCORTISONE/PRAMOXINE OTIC'
             1367 'D04083 GADODIAMIDE' 1368 'D04084 GLYCINE IRRIGATION'
             1369 'D04090 LACTIC ACID TOPICAL'
             1370 'D04093 HYDROCORTISONE-IODOQUINOL TOPICAL'
             1371 'D04095 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OPHTH'
             1372 'D04096 IMIGLUCERASE' 1373 'D04099 DONEPEZIL'
             1374 'D04100 AMPHOTERICIN B CHOLESTERYL SULFATE'
             1375 'D04101 IVERMECTIN' 1376 'D04102 TIZANIDINE'
             1377 'D04103 ZILEUTON' 1378 'D04105 ATORVASTATIN'
             1379 'D04106 FOSFOMYCIN' 1380 'D04107 AMLEXANOX TOPICAL'
             1381 'D04109 LEVOFLOXACIN' 1382 'D04110 MIGLITOL'
             1383 'D04111 GLATIRAMER' 1384 'D04112 CABERGOLINE'
             1385 'D04113 VALSARTAN' 1386 'D04115 TOPIRAMATE'
             1387 'D04116 ENALAPRIL-FELODIPINE'
             1388 'D04117 OLOPATADINE OPHTHALMIC' 1389 'D04118 NELFINAVIR'
             1390 'D04119 DELAVIRDINE' 1391 'D04120 CAFFEINE-ERGOTAMINE'
             1392 'D04121 TAMSULOSIN' 1393 'D04122 TROGLITAZONE'
             1394 'D04123 ZINC ACETATE' 1395 'D04125 IMIQUIMOD TOPICAL'
             1396 'D04126 ANAGRELIDE' 1397 'D04128 LVP SOLUTION'
             1398 'D04130 LVP SOLUTION WITH HYPERTONIC SALINE'
             1399 'D04131 PARENTERAL NUTRITION SOLUTION'
             1400 'D04132 PARENTERAL NUTRITION SOLUTION W/ELECTROLYTES'
             1401 'D04133 NEOMYCIN OPHTHALMIC'
             1402 'D04134 POLYMYXIN B OPHTHALMIC'
             1403 'D04135 PHENYLEPHRINE OPHTHALMIC' 1404 'D04137 TOREMIFENE'
             1405 'D04138 TAZAROTENE TOPICAL' 1406 'D04139 MIBEFRADIL'
             1407 'D04141 HYDROCHLOROTHIAZIDE-MOEXIPRIL'
             1408 'D04142 CHROMIUM PICOLINATE'
             1409 'D04143 ACETAMINOPHEN-PAMABROM' 1410 'D04145 PRAMIPEXOLE'
             1411 'D04147 NAPHAZOLINE NASAL' 1412 'D04150 BROMFENAC'
             1413 'D04151 BENZOCAINE-TRIMETHOBENZAMIDE'
             1414 'D04152 HYDROCODONE-PHENYLEPHRINE'
             1415 'D04153 PHENAZOPYRIDINE-SULFISOXAZOLE'
             1416 'D04155 ASPIRIN-DIPHENHYDRAMINE' 1417 'D04156 LETROZOLE'
             1418 'D04157 LOPERAMIDE-SIMETHICONE' 1419 'D04159 SORBITOL'
             1420 'D04160 SODIUM BIPHOSPHATE-SODIUM PHOSPHATE'
             1421 'D04161 SECRETIN' 1422 'D04163 FERROUS SULFATE-FOLIC ACID'
             1423 'D04166 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PSE'
             1424 'D04168 APAP/DIPHENHYDRAMINE/PSEUDOEPHEDRINE'
             1425 'D04172 CALAMINE-PRAMOXINE TOPICAL'
             1426 'D04175 DIPHENHYDRAMINE-MAGNESIUM SALICYLATE'
             1427 'D04177 FAT SUPPLEMENT, ORAL'
             1428 'D04178 CALCIUM HYDROXIDE TOPICAL'
             1429 'D04184 POTASSIUM AMINOBENZOATE'
             1430 'D04185 POTASSIUM BICARBONATE-SODIUM BICARBONATE'
             1431 'D04186 PHENYLEPHRINE NASAL'
             1432 'D04189 TRIPELENNAMINE TOPICAL'
             1433 'D04190 PAPAIN TOPICAL' 1434 'D04191 PAPAIN-UREA TOPICAL'
             1435 'D04192 COLISTIN/HC/NEOMYCIN/THONZONIUM OTIC'
             1436 'D04193 LEVMETAMFETAMINE NASAL'
             1437 'D04194 PROPYLHEXEDRINE NASAL' 1438 'D04195 CHLOROPHYLLIN'
             1439 'D04196 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B TOPICAL'
             1440 'D04197 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B TOPICAL'
             1441 'D04204 COPPER SULFATE'
             1442 'D04205 POVIDONE IODINE OPHTHALMIC'
             1443 'D04206 TETRAHYDROZOLINE NASAL'
             1444 'D04208 SILVER NITRATE TOPICAL'
             1445 'D04209 METHOXSALEN TOPICAL'
             1446 'D04210 ESTRADIOL TOPICAL' 1447 'D04214 DOLASETRON'
             1448 'D04215 ROPINIROLE' 1449 'D04217 EPINEPHRINE-PRILOCAINE'
             1450 'D04219 LAMIVUDINE-ZIDOVUDINE' 1451 'D04220 QUETIAPINE'
             1452 'D04221 TIAGABINE' 1453 'D04222 IRBESARTAN'
             1454 'D04223 MOMETASONE NASAL'
             1455 'D04224 INTERFERON ALFACON-1'
             1456 'D04225 HYDROCODONE-IBUPROFEN'
             1457 'D04226 AMINOSALICYLIC ACID' 1458 'D04228 ACETIC ACID OTIC'
             1459 'D04229 GLYCERIN OTIC' 1460 'D04231 VITAMIN A OPHTHALMIC'
             1461 'D04233 TRIAMCINOLONE NASAL'
             1462 'D04235 IPRATROPIUM NASAL' 1463 'D04236 ETHANOL TOPICAL'
             1464 'D04238 AMPHOTERICIN B LIPOSOMAL'
             1465 'D04240 HYLAN G-F 20'
             1466 'D04241 POTASSIUM CHLORIDE-SODIUM CHLORIDE'
             1467 'D04242 SODIUM CHLORIDE NASAL'
             1468 'D04243 LIDOCAINE-OXYTETRACYCLINE'
             1469 'D04245 HYDROCHLOROTHIAZIDE-IRBESARTAN'
             1470 'D04247 PEGASPARGASE' 1471 'D04248 METHYLCELLULOSE'
             1472 'D04249 CELLULOSE' 1473 'D04253 ZOLMITRIPTAN'
             1474 'D04255 RITUXIMAB' 1475 'D04256 CEFDINIR'
             1476 'D04258 CLOPIDOGREL' 1477 'D04260 SIBUTRAMINE'
             1478 'D04261 RALOXIFENE' 1479 'D04263 TROVAFLOXACIN'
             1480 'D04264 BECAPLERMIN TOPICAL' 1481 'D04265 OFLOXACIN OTIC'
             1482 'D04266 EPROSARTAN' 1483 'D04267 REPAGLINIDE'
             1484 'D04269 APAP/CAFFEINE/DIHYDROCODEINE'
             1485 'D04270 FEXOFENADINE-PSEUDOEPHEDRINE'
             1486 'D04271 DICLOFENAC-MISOPROSTOL'
             1487 'D04272 AMOXICILLIN/CLARITHROMYCIN/LANSOPRAZOLE'
             1488 'D04274 FOMEPIZOLE' 1489 'D04275 BECLOMETHASONE NASAL'
             1490 'D04276 BUDESONIDE' 1491 'D04279 FLUNISOLIDE NASAL'
             1492 'D04282 TOLCAPONE' 1493 'D04283 FLUTICASONE NASAL'
             1494 'D04284 FLUTICASONE TOPICAL' 1495 'D04285 NARATRIPTAN'
             1496 'D04286 FENOFIBRATE' 1497 'D04287 CIPROFLOXACIN OTIC'
             1498 'D04288 CIPROFLOXACIN-HYDROCORTISONE OTIC'
             1499 'D04289 MONTELUKAST'
             1500 'D04290 CALCIUM CARBONATE-MAGNESIUM HYDROXIDE'
             1501 'D04291 LEPIRUDIN' 1502 'D04292 LOTEPREDNOL OPHTHALMIC'
             1503 'D04293 HYDROCHLOROTHIAZIDE-VALSARTAN'
             1504 'D04294 TOLTERODINE' 1505 'D04295 OXYMETHOLONE'
             1506 'D04296 STARCH TOPICAL'
             1507 'D04297 PHENYLEPHRINE-PRAMOXINE TOPICAL'
             1508 'D04298 PHENYLEPHRINE TOPICAL' 1509 'D04299 SILDENAFIL'
             1510 'D04300 RISEDRONATE' 1511 'D04301 BRINZOLAMIDE OPHTHALMIC'
             1512 'D04303 DORZOLAMIDE-TIMOLOL OPHTHALMIC'
             1513 'D04305 SACROSIDASE' 1514 'D04311 CAPECITABINE'
             1515 'D04312 PARICALCITOL' 1516 'D04314 BASILIXIMAB'
             1517 'D04315 TIROFIBAN' 1518 'D04316 EPTIFIBATIDE'
             1519 'D04320 DIPHTHERIA/HAEMOPHILUS/PERTUSSIS,ACEL/TETANUS'
             1520 'D04321 INTERFERON ALFA-2B-RIBAVIRIN'
             1521 'D04322 CANDESARTAN' 1522 'D04323 PALIVIZUMAB'
             1523 'D04328 RIZATRIPTAN' 1524 'D04329 SODIUM HYALURONATE'
             1525 'D04331 THALIDOMIDE' 1526 'D04332 CITALOPRAM'
             1527 'D04334 EPHEDRINE-POTASSIUM IODIDE'
             1528 'D04339 DEXTROMETHORPHAN-POTASSIUM GUAIACOLSULFONATE'
             1529 'D04342 INFLIXIMAB' 1530 'D04344 ROTAVIRUS VACCINE'
             1531 'D04345 APAP/CAFFEINE/GUAIFENESIN/PHENYLEPHRINE'
             1532 'D04347 DOXYCYCLINE TOPICAL' 1533 'D04349 LEFLUNOMIDE'
             1534 'D04351 COAL TAR/LACTIC ACID/SALICYLIC ACID TOPICAL'
             1535 'D04355 EFAVIRENZ' 1536 'D04357 TRASTUZUMAB'
             1537 'D04360 HEMIN' 1538 'D04363 SEVELAMER'
             1539 'D04364 TELMISARTAN' 1540 'D04365 ETANERCEPT'
             1541 'D04366 SIMETHICONE COATED CELLULOSE'
             1542 'D04368 TANNIC ACID TOPICAL' 1543 'D04369 INSULIN REGULAR'
             1544 'D04370 INSULIN ISOPHANE' 1545 'D04371 INSULIN ZINC'
             1546 'D04372 INSULIN ZINC EXTENDED' 1547 'D04373 INSULIN LISPRO'
             1548 'D04374 INSULIN ISOPHANE-INSULIN REGULAR'
             1549 'D04375 ESTRADIOL-NORETHINDRONE' 1550 'D04376 ABACAVIR'
             1551 'D04377 THYROTROPIN ALPHA' 1552 'D04378 MODAFINIL'
             1553 'D04379 LYME DISEASE VACCINE' 1554 'D04380 CELECOXIB'
             1555 'D04382 CILOSTAZOL' 1556 'D04386 DENILEUKIN DIFTITOX'
             1557 'D04387 SODIUM FERRIC GLUCONATE COMPLEX'
             1558 'D04389 PENTASTARCH' 1559 'D04391 LIVER DERIVATIVE COMPLEX'
             1560 'D04393 BUTABARBITAL/HYOSCYAMINE/PHENAZOPYRIDINE'
             1561 'D04394 CROMOLYN NASAL' 1562 'D04395 CLOTRIMAZOLE TOPICAL'
             1563 'D04396 CONJUGATED ESTROGENS TOPICAL'
             1564 'D04397 FLUORIDE TOPICAL' 1565 'D04399 NYSTATIN TOPICAL'
             1566 'D04402 CILASTATIN' 1567 'D04406 TYPHOID VACCINE, LIVE'
             1568 'D04407 ECHINACEA' 1569 'D04408 ST. JOHN''S WORT'
             1570 'D04409 CHAMOMILE' 1571 'D04410 FEVERFEW'
             1572 'D04411 GARLIC' 1573 'D04412 GINSENG' 1574 'D04413 GINKGO'
             1575 'D04414 GINGER' 1576 'D04415 SAW PALMETTO'
             1577 'D04416 VALERIAN' 1578 'D04417 CREATINE'
             1579 'D04418 GLUCOSAMINE' 1580 'D04419 CHONDROITIN'
             1581 'D04420 CHONDROITIN-GLUCOSAMINE'
             1582 'D04421 EVENING PRIMROSE' 1583 'D04422 KAVA'
             1584 'D04423 GOLDENSEAL' 1585 'D04425 DEHYDROEPIANDROSTERONE'
             1586 'D04426 RED YEAST RICE' 1587 'D04427 LEVALBUTEROL'
             1588 'D04429 ORLISTAT'
             1589 'D04430 BACITRACIN/NEOMYCIN/POLYMYXIN B/PRAMOXINE TOP'
             1590 'D04431 NEOMYCIN/POLYMYXIN B/PRAMOXINE TOPICAL'
             1591 'D04432 CARBONYL IRON' 1592 'D04433 ROFECOXIB'
             1593 'D04434 ROSIGLITAZONE' 1594 'D04435 DOXERCALCIFEROL'
             1595 'D04436 MALATHION TOPICAL' 1596 'D04440 PERINDOPRIL'
             1597 'D04441 KETOTIFEN OPHTHALMIC' 1598 'D04442 PIOGLITAZONE'
             1599 'D04443 ZANAMIVIR'
             1600 'D04445 CARBETAPENTANE/CHLORPHENIRAMINE/PHENYLEPHRINE'
             1601 'D04446 PHENYLEPHRINE-PYRILAMINE' 1602 'D04447 GANIRELIX'
             1603 'D04448 RABEPRAZOLE' 1604 'D04451 TEMOZOLOMIDE'
             1605 'D04452 ZALEPLON' 1606 'D04453 SIROLIMUS'
             1607 'D04454 EPIRUBICIN' 1608 'D04457 DALFOPRISTIN-QUINUPRISTIN'
             1609 'D04458 PEMIROLAST OPHTHALMIC' 1610 'D04459 DOFETILIDE'
             1611 'D04460 ENTACAPONE' 1612 'D04461 EXEMESTANE'
             1613 'D04462 OSELTAMIVIR' 1614 'D04463 GRAPE SEED OIL'
             1615 'D04464 DONG QUAI' 1616 'D04466 MILK THISTLE'
             1617 'D04467 CAT''S CLAW' 1618 'D04469 BEE POLLEN'
             1619 'D04470 CRANBERRY' 1620 'D04472 BLACK COHOSH'
             1621 'D04473 BLUE COHOSH' 1622 'D04478 WILD YAM'
             1623 'D04479 PENNYROYAL' 1624 'D04481 ROYAL JELLY'
             1625 'D04482 DAMIANA' 1626 'D04483 DANDELION'
             1627 'D04484 SHARK CARTILAGE' 1628 'D04491 FLAX'
             1629 'D04492 FENUGREEK' 1630 'D04497 ASPIRIN-DIPYRIDAMOLE'
             1631 'D04498 NAPROXEN-PSEUDOEPHEDRINE'
             1632 'D04499 LEVETIRACETAM' 1633 'D04500 MOXIFLOXACIN'
             1634 'D04501 AMINOLEVULINIC ACID TOPICAL'
             1635 'D04503 NEDOCROMIL OPHTHALMIC' 1636 'D04504 GATIFLOXACIN'
             1637 'D04505 DEXMEDETOMIDINE'
             1638 'D04506 ESTRADIOL-NORGESTIMATE' 1639 'D04507 BEXAROTENE'
             1640 'D04508 NITRIC OXIDE'
             1641 'D04509 HYDROCHLOROTHIAZIDE-QUINAPRIL'
             1642 'D04510 INSULIN LISPRO-INSULIN LISPRO PROTAMINE'
             1643 'D04512 CEVIMELINE' 1644 'D04513 OXCARBAZEPINE'
             1645 'D04514 PANTOPRAZOLE' 1646 'D04515 GADOVERSETAMIDE'
             1647 'D04516 ALOSETRON' 1648 'D04523 UBIQUINONE'
             1649 'D04524 S-ADENOSYLMETHIONINE' 1650 'D04527 ZONISAMIDE'
             1651 'D04530 STRONTIUM-89 CHLORIDE'
             1652 'D04531 SAMARIUM SM 153 LEXIDRONAM' 1653 'D04532 MELOXICAM'
             1654 'D04533 VERTEPORFIN' 1655 'D04534 LINEZOLID'
             1656 'D04535 ARTICAINE-EPINEPHRINE' 1657 'D04536 ARTICAINE'
             1658 'D04537 RIVASTIGMINE' 1659 'D04538 INSULIN GLARGINE'
             1660 'D04539 FOSINOPRIL-HYDROCHLOROTHIAZIDE'
             1661 'D04540 GEMTUZUMAB' 1662 'D04541 AZELASTINE OPHTHALMIC'
             1663 'D04547 ATOVAQUONE-PROGUANIL' 1664 'D04557 CLOBAZAM'
             1665 'D04572 FORMOTEROL' 1666 'D04597 TETRABENAZINE'
             1667 'D04611 FLUTICASONE-SALMETEROL' 1668 'D04659 TINZAPARIN'
             1669 'D04669 VIGABATRIN'
             1670 'D04674 DIPHTH/HAEMOPHILUS/PERTUSSIS/TETANUS/POLIO'
             1671 'D04675 DIPHTHERIA/PERTUSSIS,ACEL/TETANUS/POLIO'
             1672 'D04685 HEPATITIS A-HEPATITIS B VACCINE'
             1673 'D04689 CALAMINE-DIPHENHYDRAMINE TOPICAL'
             1674 'D04694 TENECTEPLASE' 1675 'D04695 COLESEVELAM'
             1676 'D04697 INSULIN ASPART' 1677 'D04698 ARGATROBAN'
             1678 'D04700 BALSALAZIDE' 1679 'D04702 DOCOSANOL TOPICAL'
             1680 'D04703 GLYBURIDE-METFORMIN'
             1681 'D04704 EFLORNITHINE TOPICAL'
             1682 'D04705 FLUDEOXYGLUCOSE F18'
             1683 'D04707 LEVOFLOXACIN OPHTHALMIC'
             1684 'D04708 ZOLEDRONIC ACID'
             1685 'D04711 CANDESARTAN-HYDROCHLOROTHIAZIDE'
             1686 'D04716 LOPINAVIR' 1687 'D04717 LOPINAVIR-RITONAVIR'
             1688 'D04718 MIFEPRISTONE' 1689 'D04720 ARSENIC TRIOXIDE'
             1690 'D04722 DICLOFENAC TOPICAL'
             1691 'D04723 CALCIUM CARBONATE/FAMOTIDINE/MG HYDROXIDE'
             1692 'D04725 IRON SUCROSE' 1693 'D04726 5-HYDROXYTRYPTOPHAN'
             1694 'D04727 ABACAVIR/LAMIVUDINE/ZIDOVUDINE'
             1695 'D04737 HYDROCHLOROTHIAZIDE-TELMISARTAN'
             1696 'D04738 APAP/DOXYLAMINE/PSEUDOEPHEDRINE'
             1697 'D04740 TACROLIMUS TOPICAL'
             1698 'D04741 CARBETAPENTANE/GUAIFENESIN/PHENYLEPHRINE'
             1699 'D04742 BENZOYL PEROXIDE-CLINDAMYCIN TOPICAL'
             1700 'D04743 NATEGLINIDE' 1701 'D04744 BIVALIRUDIN'
             1702 'D04746 PEGINTERFERON ALFA-2B' 1703 'D04747 ZIPRASIDONE'
             1704 'D04748 CASPOFUNGIN' 1705 'D04749 ESOMEPRAZOLE'
             1706 'D04750 GALANTAMINE'
             1707 'D04752 CARBINOXAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1708 'D04753 TRAVOPROST OPHTHALMIC'
             1709 'D04754 BIMATOPROST OPHTHALMIC'
             1710 'D04755 VALGANCICLOVIR' 1711 'D04756 ALEMTUZUMAB'
             1712 'D04757 ALMOTRIPTAN' 1713 'D04758 IMATINIB'
             1714 'D04760 DROSPIRENONE-ETHINYL ESTRADIOL'
             1715 'D04761 MINOCYCLINE TOPICAL'
             1716 'D04762 METHSCOPOLAMINE-PSEUDOEPHEDRINE'
             1717 'D04763 NESIRITIDE'
             1718 'D04764 CETIRIZINE-PSEUDOEPHEDRINE'
             1719 'D04765 HYDROCORTISONE-LIDOCAINE TOPICAL'
             1720 'D04766 ACETAMINOPHEN-TRAMADOL' 1721 'D04767 CEFDITOREN'
             1722 'D04770 CARBETAPENTANE-CHLORPHENIRAMINE'
             1723 'D04771 DARBEPOETIN ALFA' 1724 'D04772 ETONOGESTREL'
             1725 'D04773 ETHINYL ESTRADIOL-ETONOGESTREL'
             1726 'D04774 TENOFOVIR' 1727 'D04775 ANAKINRA'
             1728 'D04776 FROVATRIPTAN' 1729 'D04777 DEXMETHYLPHENIDATE'
             1730 'D04778 VALDECOXIB'
             1731 'D04779 ETHINYL ESTRADIOL-NORELGESTROMIN'
             1732 'D04782 BOSENTAN' 1733 'D04783 ERTAPENEM'
             1734 'D04784 PIMECROLIMUS TOPICAL' 1735 'D04785 DESLORATADINE'
             1736 'D04786 FONDAPARINUX' 1737 'D04787 LOVASTATIN-NIACIN'
             1738 'D04788 DUTASTERIDE' 1739 'D04789 NITISINONE'
             1740 'D04790 PEGFILGRASTIM'
             1741 'D04791 FLUOCINOLONE/HYDROQUINONE/TRETINOIN TOPICAL'
             1742 'D04792 ASA/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1743 'D04793 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PE'
             1744 'D04794 CARBINOXAMINE/METHSCOPOLAMINE/PSEUDOEPHEDRINE'
             1745 'D04795 BUDESONIDE-FORMOTEROL' 1746 'D04796 PERFLUTREN'
             1747 'D04797 ALFUZOSIN' 1748 'D04798 TEGASEROD'
             1749 'D04799 FULVESTRANT' 1750 'D04800 IFOSFAMIDE-MESNA'
             1751 'D04801 OLMESARTAN' 1752 'D04802 TREPROSTINIL'
             1753 'D04803 VORICONAZOLE' 1754 'D04805 RASBURICASE'
             1755 'D04806 SODIUM OXYBATE' 1756 'D04811 OXALIPLATIN'
             1757 'D04812 ESCITALOPRAM' 1758 'D04814 ADEFOVIR'
             1759 'D04815 EPLERENONE'
             1760 'D04817 DEXCHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             1761 'D04818 DEXCHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             1762 'D04819 BUPRENORPHINE-NALOXONE'
             1763 'D04820 METFORMIN-ROSIGLITAZONE'
             1764 'D04821 PEGINTERFERON ALFA-2A'
             1765 'D04823 GLIPIZIDE-METFORMIN' 1766 'D04824 EZETIMIBE'
             1767 'D04825 ARIPIPRAZOLE' 1768 'D04826 NITAZOXANIDE'
             1769 'D04827 ATOMOXETINE' 1770 'D04828 TERIPARATIDE'
             1771 'D04829 TIOTROPIUM' 1772 'D04831 SMALLPOX VACCINE'
             1773 'D04832 DIPHTHERIA/HEPB/PERTUSSIS,ACEL/POLIO/TETANUS'
             1774 'D04834 CYTARABINE LIPOSOMAL' 1775 'D04835 ADALIMUMAB'
             1776 'D04836 CYCLOSPORINE OPHTHALMIC'
             1777 'D04838 INSULIN ASPART PROTAMINE'
             1778 'D04839 INSULIN ASPART-INSULIN ASPART PROTAMINE'
             1779 'D04843 ALEFACEPT' 1780 'D04844 CAMPHOR-MENTHOL TOPICAL'
             1781 'D04845 IBRITUMOMAB' 1782 'D04849 ELETRIPTAN'
             1783 'D04850 CARBETAPENTANE/PHENYLEPHRINE/PYRILAMINE'
             1784 'D04851 ROSUVASTATIN' 1785 'D04852 BUPIVACAINE-FENTANYL'
             1786 'D04853 ENFUVIRTIDE' 1787 'D04854 PEGVISOMANT'
             1788 'D04855 APREPITANT' 1789 'D04856 BOTULISM ANTITOXIN'
             1790 'D04857 GATIFLOXACIN OPHTHALMIC'
             1791 'D04858 ANTHRAX VACCINE ADSORBED'
             1792 'D04859 GEMIFLOXACIN' 1793 'D04860 MOXIFLOXACIN OPHTHALMIC'
             1794 'D04861 DIPHENHYDRAMINE-PHENYLEPHRINE'
             1795 'D04862 BROMPHENIRAMINE/DM/GUAIFENESIN/PSE'
             1796 'D04863 CHLORPHENIRAMINE/IBUPROFEN/PSEUDOEPHEDRINE'
             1797 'D04864 CARBETAPENTANE-PSEUDOEPHEDRINE'
             1798 'D04866 AGALSIDASE BETA' 1799 'D04868 GEFITINIB'
             1800 'D04869 CHLORPHENIRAMINE/DIHYDROCODEINE/PSE'
             1801 'D04870 DIHYDROCODEINE/GUAIFENESIN/PSEUDOEPHEDRINE'
             1802 'D04871 BORTEZOMIB' 1803 'D04875 BETAINE'
             1804 'D04877 CARBIDOPA/ENTACAPONE/LEVODOPA'
             1805 'D04878 HYDROCHLOROTHIAZIDE-OLMESARTAN'
             1806 'D04879 PHENYLEPHRINE-POTASSIUM GUAIACOLSULFONATE'
             1807 'D04880 BROMPHENIRAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1808 'D04881 OMALIZUMAB' 1809 'D04882 ATAZANAVIR'
             1810 'D04884 EMTRICITABINE' 1811 'D04885 TOSITUMOMAB'
             1812 'D04886 IODINE I 131 TOSITUMOMAB'
             1813 'D04887 BUPIVACAINE-HYDROMORPHONE'
             1814 'D04888 PALONOSETRON'
             1815 'D04890 CIPROFLOXACIN-DEXAMETHASONE OTIC'
             1816 'D04892 INFLUENZA VIRUS VACCINE, LIVE, TRIVALENT'
             1817 'D04893 VARDENAFIL' 1818 'D04894 DAPTOMYCIN'
             1819 'D04895 CARBETAPENTANE/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1820 'D04896 TADALAFIL'
             1821 'D04897 TETRAHYDROZOLINE-ZINC OPHTHALMIC'
             1822 'D04898 EPINASTINE OPHTHALMIC' 1823 'D04899 MEMANTINE'
             1824 'D04900 SALICYLIC ACID-UREA TOPICAL'
             1825 'D04901 FOSAMPRENAVIR' 1826 'D04902 EFALIZUMAB'
             1827 'D04905 BROMPHENIRAMINE/DEXTROMETHORPH/PHENYLEPHRINE'
             1828 'D04913 LANSOPRAZOLE-NAPROXEN'
             1829 'D04914 ESTRADIOL-LEVONORGESTREL'
             1830 'D04915 SERTACONAZOLE TOPICAL' 1831 'D04916 CAPSICUM'
             1832 'D04917 FLUOXETINE-OLANZAPINE'
             1833 'D04920 PNEUMOCOCCAL 7-VALENT CONJUGATE VACCINE'
             1834 'D04921 TETANUS-DIPHTH TOXOIDS (TD) ADULT/ADOL'
             1835 'D04925 DIPHENHYDRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1836 'D04929 TROSPIUM' 1837 'D04933 TELITHROMYCIN'
             1838 'D04935 TINIDAZOLE' 1839 'D04986 ACAMPROSATE'
             1840 'D04991 APOMORPHINE' 1841 'D05029 LUTROPIN ALFA'
             1842 'D05044 BETAMETHASONE-CALCIPOTRIENE TOPICAL'
             1843 'D05047 PEMETREXED' 1844 'D05048 AMLODIPINE-ATORVASTATIN'
             1845 'D05101 CETUXIMAB'
             1846 'D05117 GUAIFENESIN-POTASSIUM GUAIACOLSULFONATE'
             1847 'D05119 DEXTROMETHORPHAN/GG/K GUAIACOLSULFONATE'
             1848 'D05145 ARTEMETHER-LUMEFANTRINE'
             1849 'D05150 CARBINOXAMINE/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1850 'D05214 BEVACIZUMAB' 1851 'D05215 ZINC ACETATE TOPICAL'
             1852 'D05216 DIPHENHYDRAMINE-ZINC ACETATE TOPICAL'
             1853 'D05217 MYCOPHENOLIC ACID' 1854 'D05218 CINACALCET'
             1855 'D05232 ILOPROST' 1856 'D05234 HYALURONAN'
             1857 'D05238 BENZOYL PEROXIDE-UREA TOPICAL'
             1858 'D05262 MOMETASONE' 1859 'D05265 NEBIVOLOL'
             1860 'D05269 CADEXOMER IODINE TOPICAL'
             1861 'D05278 INSULIN GLULISINE'
             1862 'D05283 BRIMONIDINE-TIMOLOL OPHTHALMIC'
             1863 'D05292 APAP/CAFFEINE/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1864 'D05293 AZACITIDINE' 1865 'D05294 RIFAXIMIN'
             1866 'D05303 CHLORPHENIRAMINE-CODEINE'
             1867 'D05332 PITCHER PLANT'
             1868 'D05334 BROMPHENIRAMINE/CODEINE/PHENYLEPHRINE'
             1869 'D05337 PNEUMOCOCCAL 23-POLYVALENT VACCINE'
             1870 'D05338 DIPHTHERIA-TETANUS TOXOIDS (DT) PED'
             1871 'D05339 HEPATITIS A PEDIATRIC VACCINE'
             1872 'D05340 HEPATITIS A ADULT VACCINE'
             1873 'D05341 HAEMOPHILUS B CONJUGATE (HBOC) VACCINE'
             1874 'D05343 HAEMOPHILUS B CONJUGATE (PRP-T) VACCINE'
             1875 'D05346 GADOBUTROL' 1876 'D05348 EZETIMIBE-SIMVASTATIN'
             1877 'D05349 BISACODYL-PEG 3350 WITH ELECTROLYTES'
             1878 'D05350 POLYETHYLENE GLYCOL 3350'
             1879 'D05351 APAP/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1880 'D05352 EMTRICITABINE-TENOFOVIR'
             1881 'D05354 ABACAVIR-LAMIVUDINE' 1882 'D05355 DULOXETINE'
             1883 'D05357 IBANDRONATE'
             1884 'D05361 CARBETAPENTANE-GUAIFENESIN'
             1885 'D05366 APAP/DEXTROMETHORPHAN/DOXYLAMINE'
             1886 'D05383 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1887 'D05384 DEXTROMETHORPHAN/PHENIRAMINE/PHENYLEPHRINE'
             1888 'D05389 BISACODYL-MAGNESIUM CITRATE'
             1889 'D05395 LANTHANUM CARBONATE'
             1890 'D05411 CHLORPHENIRAMINE-METHSCOPOLAMINE'
             1891 'D05412 ERLOTINIB' 1892 'D05413 SOLIFENACIN'
             1893 'D05414 NATALIZUMAB' 1894 'D05415 IBUPROFEN-OXYCODONE'
             1895 'D05416 CHLORDIAZEPOXIDE-METHSCOPOLAMINE'
             1896 'D05417 PALIFERMIN' 1897 'D05418 PEGAPTANIB OPHTHALMIC'
             1898 'D05420 ALOH/DIPHENHYD/LIDOCAINE/MGOH/SIMETH TOPICAL'
             1899 'D05421 ESZOPICLONE' 1900 'D05422 DARIFENACIN'
             1901 'D05423 CLOFARABINE' 1902 'D05424 ZICONOTIDE'
             1903 'D05425 LOTEPREDNOL-TOBRAMYCIN OPHTHALMIC'
             1904 'D05426 BROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1905 'D05427 PACLITAXEL PROTEIN-BOUND'
             1906 'D05428 GADOBENATE DIMEGLUMINE'
             1907 'D05432 MENINGOCOCCAL CONJUGATE VACCINE'
             1908 'D05433 DIGESTIVE ENZYMES/HYOSCYAMINE/PHENYLTOLOXAMIN'
             1909 'D05434 BROMPHENIRAMINE/CARBETAPENTANE/PHENYLEPHRINE'
             1910 'D05436 INSULIN DETEMIR'
             1911 'D05459 POVIDONE-TETRAHYDROZOLINE OPHTHALMIC'
             1912 'D05461 SODIUM BENZOATE-SODIUM PHENYLACETATE'
             1913 'D05465 CICLESONIDE'
             1914 'D05470 ASCORBIC ACID-IRON POLYSACCHARIDE'
             1915 'D05471 ALPHA-D-GALACTOSIDASE'
             1916 'D05473 DESLORATADINE-PSEUDOEPHEDRINE'
             1917 'D05487 MICAFUNGIN' 1918 'D05488 PRAMLINTIDE'
             1919 'D05508 PREGABALIN' 1920 'D05518 BROMFENAC OPHTHALMIC'
             1921 'D05525 ENTECAVIR'
             1922 'D05526 ALENDRONATE-CHOLECALCIFEROL'
             1923 'D05527 FLUOCINOLONE OPHTHALMIC'
             1924 'D05528 TRICHOPHYTON SKIN TEST' 1925 'D05529 EXENATIDE'
             1926 'D05530 DROSPIRENONE-ESTRADIOL'
             1927 'D05535 HEME IRON POLYPEPTIDE'
             1928 'D05536 APAP/GUAIFENESIN/PSEUDOEPHEDRINE'
             1929 'D05537 TIGECYCLINE' 1930 'D05538 TIPRANAVIR'
             1931 'D05539 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1932 'D05540 HYDRALAZINE-ISOSORBIDE DINITRATE'
             1933 'D05543 DAPSONE TOPICAL'
             1934 'D05544 APAP/GUAIFENESIN/PHENYLEPHRINE'
             1935 'D05578 RAMELTEON'
             1936 'D05583 APAP/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1937 'D05612 RASAGILINE' 1938 'D05626 EVEROLIMUS'
             1939 'D05630 CALCIUM CARBONATE-RISEDRONATE'
             1940 'D05632 BISACODYL/SODIUM BIPHOSPHATE/SODIUM PHOSPHATE'
             1941 'D05633 NEPAFENAC OPHTHALMIC'
             1942 'D05635 METFORMIN-PIOGLITAZONE' 1943 'D05636 MECASERMIN'
             1944 'D05637 LACTOBACILLUS RHAMNOSUS GG'
             1945 'D05644 APAP/CAFFEINE/ISOMETHEPTENE MUCATE'
             1946 'D05645 MEASLES/MUMPS/RUBELLA/VARICELLA VIRUS VACCINE'
             1947 'D05646 SACCHAROMYCES BOULARDII LYO'
             1948 'D05647 FERRIC SUBSULFATE TOPICAL'
             1949 'D05649 CEFTRIAXONE-LIDOCAINE'
             1950 'D05651 SODIUM HYALURONATE TOPICAL'
             1951 'D05654 APAP/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1952 'D05659 DEFERASIROX'
             1953 'D05661 ACETAMINOPHEN-GUAIFENESIN'
             1954 'D05674 GLIMEPIRIDE-ROSIGLITAZONE' 1955 'D05691 SORAFENIB'
             1956 'D05692 MECASERMIN RINFABATE' 1957 'D05694 ABATACEPT'
             1958 'D05696 LENALIDOMIDE' 1959 'D05702 METHYLSULFONYLMETHANE'
             1960 'D05703 CHONDROITIN/GLUCOSAMINE/METHYLSULFONYLMETHANE'
             1961 'D05704 IMMUNE GLOBULIN SUBCUTANEOUS'
             1962 'D05717 SUNITINIB' 1963 'D05719 RANOLAZINE'
             1964 'D05722 GALLIUM CITRATE GA-67' 1965 'D05736 LUBIPROSTONE'
             1966 'D05753 MICONAZOLE-ZINC OXIDE TOPICAL'
             1967 'D05757 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PE'
             1968 'D05765 INSULIN INHALATION, RAPID ACTING'
             1969 'D05768 APAP/PHENIRAMINE/PHENYLEPHRINE'
             1970 'D05770 OMEPRAZOLE-SODIUM BICARBONATE'
             1971 'D05773 L-METHYLFOLATE'
             1972 'D05774 AMMONIUM LACTATE-UREA TOPICAL' 1973 'D05776 IODINE'
             1974 'D05777 IODINE-POTASSIUM IODIDE'
             1975 'D05778 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PE'
             1976 'D05781 TETANUS/DIPHTH/PERTUSS (TDAP) ADULT/ADOL'
             1977 'D05782 DIPHTHERIA/TETANUS/PERTUSSIS (DTAP) PED'
             1978 'D05785 RABIES VACCINE, HUMAN DIPLOID CELL'
             1979 'D05786 RABIES VACCINE, PURIFIED CHICK EMBRYO CELL'
             1980 'D05788 DECITABINE'
             1981 'D05806 FERROUS FUMARATE/FA/IRON POLYSACCHARIDE'
             1982 'D05807 VARENICLINE' 1983 'D05813 ZOSTER VACCINE LIVE'
             1984 'D05814 DEXTROMETHORPHAN-PHENYLEPHRINE'
             1985 'D05815 FLUORESCEIN'
             1986 'D05817 HUMAN PAPILLOMAVIRUS VACCINE'
             1987 'D05819 DIPHENHYDRAMINE-IBUPROFEN' 1988 'D05825 DARUNAVIR'
             1989 'D05830 FERUMOXSIL' 1990 'D05831 DASATINIB'
             1991 'D05835 RANIBIZUMAB OPHTHALMIC'
             1992 'D05847 EFAVIRENZ/EMTRICITABINE/TENOFOVIR'
             1993 'D05848 ROTIGOTINE' 1994 'D05851 LEVOCETIRIZINE'
             1995 'D05853 POSACONAZOLE' 1996 'D05855 IDURSULFASE'
             1997 'D05856 GLIMEPIRIDE-PIOGLITAZONE'
             1998 'D05864 COMPLEMENT C1 ESTERASE INHIBITOR'
             1999 'D05866 GUAR GUM'
             2000 'D05874 ANTIHEMOPHILIC FACTOR-VON WILLEBRAND FACTOR'
             2001 'D05877 DEXTROMETHORPHAN/DIPHENHYDRAMINE/PE'
             2002 'D05878 BENZALKONIUM CHLORIDE-BENZOCAINE TOPICAL'
             2003 'D05879 PANITUMUMAB' 2004 'D05891 VORINOSTAT'
             2005 'D05892 DEXCHLORPHENIRAMINE/DEXTROMETHO/PE/PYRILAMINE'
             2006 'D05893 ARFORMOTEROL'
             2007 'D05894 CALAMINE-ZINC OXIDE TOPICAL'
             2008 'D05896 SITAGLIPTIN'
             2009 'D05897 BENZOYL PEROXIDE-SALICYLIC ACID TOPICAL'
             2010 'D05899 CICLESONIDE NASAL'
             2011 'D05963 COAGULATION FACTOR IX' 2012 'D05964 ALOE VERA'
             2013 'D05973 CLINDAMYCIN-TRETINOIN TOPICAL'
             2014 'D05974 ANTIHEMOPHILIC FACTOR'
             2015 'D06008 BENZYL ALCOHOL TOPICAL'
             2016 'D06032 FLUOCINOLONE OTIC'
             2017 'D06058 DEXBROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             2018 'D06080 APAP/CAFFEINE/MAGNESIUM SALICYLATE'
             2019 'D06214 COLLAGEN' 2020 'D06227 IOXILAN'
             2021 'D06272 DIENOGEST-ESTRADIOL' 2022 'D06297 PALIPERIDONE'
             2023 'D06370 TURMERIC' 2024 'D06392 WHEAT DEXTRIN'
             2025 'D06507 CINNAMON' 2026 'D06635 MILNACIPRAN'
             2027 'D06648 ATROPINE/CPM/HYOSCYAMINE/PSE/SCOPOLAMINE'
             2028 'D06655 ALPHA-LIPOIC ACID'
             2029 'D06662 AMLODIPINE-VALSARTAN'
             2030 'D06663 LISDEXAMFETAMINE' 2031 'D06665 ALISKIREN'
             2032 'D06672 LAPATINIB' 2033 'D06673 ECULIZUMAB'
             2034 'D06720 METFORMIN-SITAGLIPTIN'
             2035 'D06831 RETAPAMULIN TOPICAL'
             2036 'D06833 ACETAMINOPHEN-ASPIRIN'
             2037 'D06834 BISMUTH SUBCITRATE POTASSIUM/METRONIDAZO/TCN'
             2038 'D06835 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             2039 'D06836 TEMSIROLIMUS' 2040 'D06841 AMBRISENTAN'
             2041 'D06842 ARMODAFINIL' 2042 'D06848 LUTEIN'
             2043 'D06851 AZITHROMYCIN OPHTHALMIC' 2044 'D06852 MARAVIROC'
             2045 'D06857 ACETIC/ANTIPYRINE/BENZOCAINE/POLYCOS OTIC'
             2046 'D06862 HELIUM' 2047 'D06864 HELIUM-OXYGEN'
             2048 'D06867 BIOTIN' 2049 'D06868 MENTHOL-ZINC OXIDE TOPICAL'
             2050 'D06872 APAP/CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             2051 'D06891 CHLOROPHYLLIN COPPER COM/PAPAIN/UREA TOPICAL'
             2052 'D06900 COLLAGEN TOPICAL'
             2053 'D06905 AMLODIPINE-OLMESARTAN'
             2054 'D06976 ASA/CHLORPHENIRAMINE/PHENYLEPHRINE'
             2055 'D07048 RALTEGRAVIR' 2056 'D07049 DORIPENEM'
             2057 'D07051 IXABEPILONE'
             2058 'D07055 CHLORPHENIRAMINE/GUAIFENESIN/METHSCOPOLAMI/PE'
             2059 'D07057 NILOTINIB'
             2060 'D07058 SULFACETAMIDE SODIUM/SULFUR/UREA TOPICAL'
             2061 'D07059 CITRIC ACID-POTASSIUM BICARBONATE'
             2062 'D07063 BROMPHENIRAMINE-DIPHENHYDRAMINE'
             2063 'D07065 BENZYL ALCOHOL-ZINC ACETATE TOPICAL'
             2064 'D07068 SAPROPTERIN' 2065 'D07069 RUFINAMIDE'
             2066 'D07075 PERMETHRIN/PIPERONYL BUTOXIDE/PYRETHR TOPICAL'
             2067 'D07076 ETRAVIRINE'
             2068 'D07077 ALISKIREN-HYDROCHLOROTHIAZIDE'
             2069 'D07110 NIACIN-SIMVASTATIN' 2070 'D07113 DESVENLAFAXINE'
             2071 'D07121 BENDAMUSTINE' 2072 'D07130 NAPROXEN-SUMATRIPTAN'
             2073 'D07131 REGADENOSON' 2074 'D07132 OLOPATADINE NASAL'
             2075 'D07134 CERTOLIZUMAB' 2076 'D07135 METHYLNALTREXONE'
             2077 'D07137 DABIGATRAN' 2078 'D07162 FESOTERODINE'
             2079 'D07292 METFORMIN-REPAGLINIDE'
             2080 'D07298 DIFLUPREDNATE OPHTHALMIC'
             2081 'D07300 CHLOPHEDIANOL/DEXCHLORPHENIRAMINE/PSE'
             2082 'D07302 CHLOPHEDIANOL/GUAIFENESIN/PSEUDOEPHEDRINE'
             2083 'D07306 BENZOCAINE-MENTHOL TOPICAL' 2084 'D07309 GENISTEIN'
             2085 'D07312 CLEVIDIPINE' 2086 'D07315 GLUTAMINE'
             2087 'D07320 ROMIPLOSTIM' 2088 'D07347 BIFIDOBACTERIUM INFANTIS'
             2089 'D07349 LACOSAMIDE'
             2090 'D07351 CARBETAPENTANE/PSEUDOEPHEDRINE/PYRILAMINE'
             2091 'D07354 SILODOSIN' 2092 'D07356 RIVAROXABAN'
             2093 'D07357 ELTROMBOPAG' 2094 'D07371 FENOFIBRIC ACID'
             2095 'D07374 BIMATOPROST TOPICAL OPHTHALMIC'
             2096 'D07382 ADAPALENE-BENZOYL PEROXIDE TOPICAL'
             2097 'D07385 HEPARIN FLUSH'
             2098 'D07387 HYDROCORTISONE/SALICYLIC ACID/SULFUR TOPICAL'
             2099 'D07395 DEXLANSOPRAZOLE' 2100 'D07396 USTEKINUMAB'
             2101 'D07397 FEBUXOSTAT'
             2102 'D07405 CARBETAPENTANE/PE/POTASSIUM GUAIACOLSULFONATE'
             2103 'D07409 PRASUGREL' 2104 'D07411 DEGARELIX'
             2105 'D07418 BENZOCAINE-RESORCINOL TOPICAL'
             2106 'D07435 GOLIMUMAB'
             2107 'D07440 AMLODIPINE/HYDROCHLOROTHIAZIDE/VALSARTAN'
             2108 'D07441 ILOPERIDONE' 2109 'D07447 TOLVAPTAN'
             2110 'D07453 TAPENTADOL' 2111 'D07458 DRONEDARONE'
             2112 'D07459 FERUMOXYTOL'
             2113 'D07464 INFLUENZA VIRUS VACCINE, H1N1, INACTIVATED'
             2114 'D07466 LIRAGLUTIDE' 2115 'D07467 SAXAGLIPTIN'
             2116 'D07472 MORPHINE-NALTREXONE' 2117 'D07473 ASENAPINE'
             2118 'D07481 POLY-L-LACTIC ACID'
             2119 'D07482 BEPOTASTINE OPHTHALMIC' 2120 'D07483 TELAVANCIN'
             2121 'D07485 INFLUENZA VIRUS VACCINE, H1N1, LIVE'
             2122 'D07486 ALISKIREN-VALSARTAN'
             2123 'D07491 DIPHENHYDRAMINE/LIDOCAINE/NYSTATIN TOPICAL'
             2124 'D07492 PRALATREXATE' 2125 'D07496 TOCILIZUMAB'
             2126 'D07498 AMLODIPINE-TELMISARTAN' 2127 'D07499 PAZOPANIB'
             2128 'D07505 COPPER' 2129 'D07509 OFATUMUMAB'
             2130 'D07518 SILVER TOPICAL' 2131 'D07546 DALFAMPRIDINE'
             2132 'D07550 DEXTROMETHORPHAN-DOXYLAMINE'
             2133 'D07565 IPILIMUMAB'
             2134 'D07586 PNEUMOCOCCAL 13-VALENT CONJUGATE VACCINE'
             2135 'D07589 BIOFLAVONOIDS-ZINC GLYCINATE'
             2136 'D07631 ESOMEPRAZOLE-NAPROXEN'
             2137 'D07634 DUTASTERIDE-TAMSULOSIN' 2138 'D07637 PITAVASTATIN'
             2139 'D07638 SIPULEUCEL-T' 2140 'D07640 DENOSUMAB'
             2141 'D07642 ANTI-THYMOCYTE GLOBULIN (RABBIT)'
             2142 'D07644 HEPATITIS B ADULT VACCINE'
             2143 'D07645 ONABOTULINUMTOXINA'
             2144 'D07646 ABOBOTULINUMTOXINA' 2145 'D07647 RACEPINEPHRINE'
             2146 'D07658 CABAZITAXEL'
             2147 'D07659 CAFFEINE-MAGNESIUM SALICYLATE'
             2148 'D07660 FORMOTEROL-MOMETASONE'
             2149 'D07668 AMLODIPINE/HYDROCHLOROTHIAZIDE/OLMESARTAN'
             2150 'D07670 ALCAFTADINE OPHTHALMIC' 2151 'D07684 ROFLUMILAST'
             2152 'D07688 PEGLOTICASE'
             2153 'D07691 MAGNESIUM/POTASSIUM/SODIUM SULFATES'
             2154 'D07692 FINGOLIMOD'
             2155 'D07697 DROSPIRENONE/ETHINYL ESTRADIOL/LEVOMEFOLATE'
             2156 'D07705 LURASIDONE' 2157 'D07706 CEFTAROLINE'
             2158 'D07709 METFORMIN-SAXAGLIPTIN' 2159 'D07715 TESAMORELIN'
             2160 'D07716 ERIBULIN' 2161 'D07727 PENICILLIN G BENZATHINE'
             2162 'D07729 PENICILLIN G POTASSIUM'
             2163 'D07730 PENICILLIN V POTASSIUM'
             2164 'D07738 BROMPHENIRAMINE/CHLOPHEDIANOL/PSE'
             2165 'D07740 VILAZODONE' 2166 'D07754 AZILSARTAN'
             2167 'D07756 BELIMUMAB'
             2168 'D07757 LIDOCAINE-SODIUM BICARBONATE'
             2169 'D07761 VANDETANIB' 2170 'D07766 ABIRATERONE'
             2171 'D07767 LINAGLIPTIN' 2172 'D07774 BOCEPREVIR'
             2173 'D07777 TELAPREVIR'
             2174 'D07796 EMTRICITABINE/RILPIVIRINE/TENOFOVIR'
             2175 'D07798 VEMURAFENIB' 2176 'I00031 XYLENE'
             2177 'I00035 TURPENTINE' 2178 'I00039 TRICHLOROETHANE'
             2179 'I00040 TOLUENE' 2180 'I00081 NAPHTHALENE'
             2181 'I00084 METHYLENE CHLORIDE' 2182 'I00088 METHANOL'
             2183 'I00102 FORMALDEHYDE' 2184 'I00106 ETHYLENE GLYCOL'
             2185 'I00108 ETHYL ETHER' 2186 'I00162 ACETONE'
             2187 'I00173 CYANOACRYLATE' 2188 'I00176 ISOBUTYL NITRITE'
             2189 'I00190 AEROSOL SPRAY-NOS' 2190 'I00196 BUTANE'
             2191 'I00198 TRICHLOROFLUOROMETHANE' 2192 'I00200 METHANE'
             2193 'I00201 PETROLEUM HYDROCARBONS'
             2194 'I00203 CARBON TETRACHLORIDE' 2195 'I00207 BUTYL ALCOHOL'
             2196 'I00209 ALPHA TERPINEOL' 2197 'I00210 FREON'
             2198 'I00211 DICHLOROBENZENE' 2199 'I00212 PROPOXUR'
             2200 'I00216 PROPANE' 2201 'I00219 PHENOLIC DISINFECTANTS'
             2202 'I00221 MINERAL SEAL OIL' 2203 'I00238 FLUORINE'
             2204 'I00240 HYDROCARBON' 2205 'I00247 CHLORINATED HYDROCARBONS'
             2206 'I00251 CRESOL' 2207 'I00256 BUTYL ACETATE'
             2208 'I00343 CLEANER/UNKNOWN COMPOSITION'
             2209 'I00345 COSMETIC/UNKNOWN COMPOSITION'
             2210 'I00348 PESTICIDE/UNKNOWN COMPOSITION'
             2211 'I00349 VOLATILE/UNKNOWN COMPONENTS'
             2212 'I00350 PAINT/UNKNOWN COMPOSITION'
             2213 'I00543 TRICHLOROETHANE/TRICHLOROETHYLENE'
             2214 'I00556 PETROLEUM HYDROCARBONS/TRICHLOROETHANE'
             2215 'I01283 ETHANOL-NP' 2216 'I01328 TRICHLOROMETHANE'
             2217 'I01336 FLUORINATED HYDROCARBONS' 2218 'I01337 ISOBUTANE'
             2219 'I01400 CHLORODIFLUOROMETHANE' 2220 'I01425 ETHYL ACETATE'
             2221 'J00001 LYSERGIC ACID DIETHYLAMIDE'
             2222 'J00002 METHYLENEDIOXYMETHAMPHETAMINE'
             2223 'J00004 FLUNITRAZEPAM' 2224 'J00020 BROMELAIN'
             2225 'J00023 NOMIFENSINE MALEATE' 2226 'J00027 MECLOZINE HCL'
             2227 'J00028 NITRAZEPAM' 2228 'J00030 ZOMEPIRAC'
             2229 'J00032 XYLAZINE' 2230 'J00033 VITAMIN K'
             2231 'J00036 L-TRYPTOPHAN' 2232 'J00049 SULFORIDAZINE'
             2233 'J00050 SULFADINE' 2234 'J00053 SALINE'
             2235 'J00061 PRAZEPAM' 2236 'J00064 PHENMETRAZINE HCL'
             2237 'J00066 PHENACETIN' 2238 'J00089 METHACYCLINE'
             2239 'J00090 MERBROMIN' 2240 'J00092 LUTREXIN'
             2241 'J00093 LORMETAZEPAM' 2242 'J00094 LACTOSE'
             2243 'J00095 KETOTIFEN FUMARATE' 2244 'J00096 INFANT FORMULA'
             2245 'J00097 HYDROXY-N-METHYLMORPHINAN'
             2246 'J00104 FENPROPOREX' 2247 'J00110 ERYTHRITYL TETRANITRATE'
             2248 'J00114 DYPYRONE' 2249 'J00120 DIHYDROMORPHINONE'
             2250 'J00122 ALDOSTERONE' 2251 'J00129 CHLOROPYRAMINE'
             2252 'J00148 CARBAMATE' 2253 'J00150 BROMAZEPAM'
             2254 'J00164 ACEPROMAZINE' 2255 'J00168 METHCATHINONE'
             2256 'J00171 CATHINONE' 2257 'J00174 METHYLENEDIOXYAMPHETAMINE'
             2258 'J00177 METHAQUALONE' 2259 'J00178 MESCALINE'
             2260 'J00179 PSILOCYBIN' 2261 'J00180 MORNING GLORY SEEDS'
             2262 'J00192 DATURA SAUVEOLENS'
             2263 'J00215 GAMMA BUTYROLACTONE' 2264 'J00248 EUCALYPTUS OIL'
             2265 'J00249 PEPPER' 2266 'J00263 DIMETHOXYMETHAMPHETAMINE'
             2267 'J00264 DATURA STRAMONIUM' 2268 'J00265 CANTHARIDINE'
             2269 'J00278 ISOPROPAMIDE IODIDE' 2270 'J00280 ALLOBARBITAL'
             2271 'J00290 CLOBENZOREX' 2272 'J00293 AMBROXOL'
             2273 'J00294 TETRAMYCIN' 2274 'J00295 RHODOMYCIN'
             2275 'J00331 ZOPICLONE' 2276 'J00336 MYCADRINE'
             2277 'J00337 POTASSIUM' 2278 'J00339 PYRETHRUM'
             2279 'J00356 ARECOLINE' 2280 'J00358 PHOSPHATIDYLETHANOLAMINE'
             2281 'J00360 CHLORPHENTERMINE' 2282 'J00362 BARBITURIC ACID'
             2283 'J00364 BARBITAL'
             2284 'J00369 BROMO-DIMETHOXYPHENETHYLAMINE'
             2285 'J00500 MARIJUANA/METHAMPHETAMINE'
             2286 'J00501 FORMALDEHYDE/MARIJUANA'
             2287 'J00502 COCAINE/METHAMPHETAMINE'
             2288 'J00504 COCAINE/MARIJUANA' 2289 'J00507 COCAINE/HEROIN'
             2290 'J00510 MARIJUANA/PHENCYCLIDINE'
             2291 'J00511 COCAINE/PHENCYCLIDINE'
             2292 'J00512 LYSERGIC ACID DIETHYLAMIDE/METHAMPHETAMINE'
             2293 'J00513 LYSERGIC ACID DIETHYLAMIDE/PHENCYCLIDINE'
             2294 'J00514 HEROIN/MARIJUANA'
             2295 'J00531 AMOBARBITAL/DEXTROAMPHETAMINE/THYROID DESICCATED'
             2296 'J00533 PENTOBARBITAL/PHENOBARBITAL'
             2297 'J00539 CAFFEINE/EPHEDRINE'
             2298 'J00540 ACETAMINOPHEN/CHLORZOXAZONE'
             2299 'J00558 ASPIRIN/CAFFEINE/CODEINE/PHENACETIN'
 2300 'J00566 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE/DEXTROMETHORPHAN/GUAIFENESIN'
             2301 'J00568 COCAINE/ETHANOL'
             2302 'J00572 SALICYLAMIDE/SCOPOLAMINE'
             2303 'J00577 CODEINE/TERPIN HYDRATE'
             2304 'J00591 ACETAMINOPHEN/CAFFEINE/CODEINE'
             2305 'J00593 AMYLASE/PROTEASE'
             2306 'J00594 ASPIRIN/CAFFEINE/CODEINE'
             2307 'J01003 ANTIFUNGALS-NOS'
             2308 'J01004 ANTIMALARIAL AGENTS-NOS'
             2309 'J01005 ANTITUBERCULOSIS AGENTS-NOS'
             2310 'J01006 ANTIVIRAL AGENTS-NOS'
             2311 'J01008 CEPHALOSPORINS-NOS' 2312 'J01010 MACROLIDES-NOS'
             2313 'J01011 ANTIBIOTICS-NOS' 2314 'J01012 PENICILLINS-NOS'
             2315 'J01013 QUINOLONES-NOS' 2316 'J01014 SULFONAMIDES-NOS'
             2317 'J01015 TETRACYCLINES-NOS'
             2318 'J01016 URINARY ANTI-INFECTIVES-NOS'
             2319 'J01017 AMINOGLYCOSIDES-NOS'
             2320 'J01018 ANTIHYPERLIPIDEMIC AGENTS-NOS'
             2321 'J01026 RADIOPHARMACEUTICALS-NOS'
             2322 'J01028 ANTITOXINS AND ANTIVENINS-NOS'
             2323 'J01029 BACTERIAL VACCINES-NOS'
             2324 'J01030 COLONY STIMULATING FACTORS-NOS'
             2325 'J01031 IMMUNE GLOBULINS-NOS'
             2326 'J01033 RECOMBINANT HUMAN ERYTHROPOIETINS-NOS'
             2327 'J01034 TOXOIDS-NOS' 2328 'J01035 VIRAL VACCINES-NOS'
             2329 'J01037 CARDIOVASCULAR AGENTS-NOS'
             2330 'J01039 ANGIOTENSIN CONVERTING ENZYME INHIBITORS-NOS'
             2331 'J01040 ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING-NOS'
             2332 'J01042 ANTIANGINAL AGENTS-NOS'
             2333 'J01043 ANTIARRHYTHMIC AGENTS-NOS'
             2334 'J01044 BETA-ADRENERGIC BLOCKING AGENTS-NOS'
             2335 'J01045 CALCIUM CHANNEL BLOCKING AGENTS-NOS'
             2336 'J01047 INOTROPIC AGENTS-NOS'
             2337 'J01049 PERIPHERAL VASODILATORS-NOS'
             2338 'J01050 VASODILATORS-NOS' 2339 'J01051 VASOPRESSORS-NOS'
             2340 'J01052 ANTIHYPERTENSIVE COMBINATIONS-NOS'
             2341 'J01053 ANGIOTENSIN II INHIBITORS-NOS'
             2342 'J01056 ANALGESICS-NOS'
             2343 'J01057 NARCOTIC ANALGESICS-NOS'
             2344 'J01058 NONSTEROIDAL ANTI-INFLAMMATORY AGENTS-NOS'
             2345 'J01059 SALICYLATES-NOS' 2346 'J01061 ANTICONVULSANTS-NOS'
             2347 'J01063 ANTIPARKINSON AGENTS-NOS'
             2348 'J01065 BARBITURATES-NOS' 2349 'J01066 BENZODIAZEPINES-NOS'
             2350 'J01067 ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS'
             2351 'J01068 CNS STIMULANTS-NOS'
             2352 'J01069 GENERAL ANESTHETICS-NOS'
             2353 'J01073 ANTIPSYCHOTICS-NOS'
             2354 'J01077 ANTICOAGULANTS-NOS'
             2355 'J01078 ANTIPLATELET AGENTS-NOS'
             2356 'J01081 THROMBOLYTICS-NOS'
             2357 'J01082 GASTROINTESTINAL AGENTS-NOS'
             2358 'J01083 ANTACIDS-NOS'
             2359 'J01084 ANTICHOLINERGICS/ANTISPASMODICS-NOS'
             2360 'J01085 ANTIDIARRHEALS-NOS'
             2361 'J01086 DIGESTIVE ENZYMES-NOS'
             2362 'J01088 GI STIMULANTS-NOS' 2363 'J01089 H2 ANTAGONISTS-NOS'
             2364 'J01090 LAXATIVES-NOS' 2365 'J01092 HORMONES-NOS'
             2366 'J01093 ADRENAL CORTICAL STEROIDS-NOS'
             2367 'J01094 ANTIDIABETIC AGENTS-NOS'
             2368 'J01096 SEX HORMONES-NOS' 2369 'J01098 THYROID DRUGS-NOS'
             2370 'J01099 IMMUNOSUPPRESSIVE AGENTS-NOS'
             2371 'J01101 ANTIDOTES-NOS' 2372 'J01102 CHELATING AGENTS-NOS'
             2373 'J01103 CHOLINERGIC MUSCLE STIMULANTS-NOS'
             2374 'J01104 LOCAL INJECTABLE ANESTHETICS-NOS'
             2375 'J01106 PSORALENS-NOS'
             2376 'J01107 RADIOCONTRAST AGENTS-NOS'
             2377 'J01108 GENITOURINARY TRACT AGENTS-NOS'
             2378 'J01111 IRON PRODUCTS-NOS'
             2379 'J01112 MINERALS AND ELECTROLYTES-NOS'
             2380 'J01113 ORAL NUTRITIONAL SUPPLEMENTS-NOS'
             2381 'J01115 VITAMIN AND MINERAL COMBINATIONS-NOS'
             2382 'J01116 INTRAVENOUS NUTRITIONAL PRODUCTS-NOS'
             2383 'J01118 ANTIHISTAMINES-NOS' 2384 'J01119 ANTITUSSIVES-NOS'
             2385 'J01120 BRONCHODILATORS-NOS'
             2386 'J01122 DECONGESTANTS-NOS' 2387 'J01123 EXPECTORANTS-NOS'
             2388 'J01124 RESPIRATORY AGENTS-NOS'
             2389 'J01125 RESPIRATORY INHALANT PRODUCTS-NOS'
             2390 'J01126 ANTIASTHMATIC COMBINATIONS-NOS'
             2391 'J01127 UPPER RESPIRATORY COMBINATIONS-NOS'
             2392 'J01129 ANORECTAL PREPARATIONS-NOS'
             2393 'J01130 ANTISEPTIC AND GERMICIDES-NOS'
             2394 'J01131 DERMATOLOGICAL AGENTS-NOS'
             2395 'J01134 TOPICAL ANESTHETICS-NOS'
             2396 'J01139 MOUTH AND THROAT PRODUCTS-NOS'
             2397 'J01143 STERILE IRRIGATING SOLUTIONS-NOS'
             2398 'J01145 PLASMA EXPANDERS-NOS'
             2399 'J01165 HMG-COA REDUCTASE INHIBITORS-NOS'
             2400 'J01170 MUSCLE RELAXANTS-NOS'
             2401 'J01174 ANDROGENS AND ANABOLIC STEROIDS-NOS'
             2402 'J01180 NARCOTIC ANALGESIC COMBINATIONS-NOS'
             2403 'J01181 ANTIRHEUMATICS-NOS'
             2404 'J01182 ANTIMIGRAINE AGENTS-NOS'
             2405 'J01183 ANTIGOUT AGENTS-NOS'
             2406 'J01206 BISPHOSPHONATES-NOS'
             2407 'J01208 NUTRACEUTICAL PRODUCTS-NOS'
             2408 'J01209 HERBAL PRODUCTS-NOS'
             2409 'J01229 FIBRIC ACID DERIVATIVES-NOS'
             2410 'J01231 LEUKOTRIENE MODIFIERS-NOS'
             2411 'J01235 NASAL PREPARATIONS-NOS'
             2412 'J01237 ANTIDEPRESSANTS-NOS' 2413 'J01241 ANOREXIANTS-NOS'
             2414 'J01243 INTERFERONS-NOS'
             2415 'J01244 MONOCLONAL ANTIBODIES-NOS'
             2416 'J01247 IMPOTENCE AGENTS-NOS'
             2417 'J01253 VAGINAL PREPARATIONS-NOS'
             2418 'J01254 ANTIPSORIATICS-NOS'
             2419 'J01256 PROTON PUMP INHIBITORS-NOS'
             2420 'J01261 DRUG UNKNOWN' 2421 'J01262 GAMMA HYDROXY BUTYRATE'
             2422 'J01271 PASSION FLOWER' 2423 'J01276 METHAPHENILENE'
             2424 'J01292 CODEINE COMBINATION-NOS'
             2425 'J01294 HALLUCINOGEN-NOS' 2426 'J01295 POLY-DRUGS'
             2427 'J01298 ANTINEOPLASTICS-NOS'
             2428 'J01300 ANTIBIOTICS/ANTINEOPLASTICS-NOS'
             2429 'J01301 HORMONES/ANTINEOPLASTICS-NOS'
             2430 'J01302 DIURETICS-NOS'
             2431 'J01303 ANTIEMETIC/ANTIVERTIGO AGENTS-NOS'
             2432 'J01305 VITAMINS-NOS'
             2433 'J01306 OPHTHALMIC PREPARATIONS-NOS'
             2434 'J01307 OTIC PREPARATIONS-NOS'
             2435 'J01308 ANALGESIC COMBINATIONS-NOS'
             2436 'J01309 COX-2 INHIBITOR-NOS'
             2437 'J01310 SSRI ANTIDEPRESSANTS-NOS'
             2438 'J01311 TRICYCLIC ANTIDEPRESSANTS-NOS'
             2439 'J01312 MONOAMINE OXIDASE INHIBITORS-NOS'
             2440 'J01313 PSYCHOTHERAPEUTIC COMBINATIONS-NOS'
             2441 'J01314 PHENOTHIAZINE ANTIPSYCHOTICS-NOS'
             2442 'J01315 ISOSORBIDE-NOS' 2443 'J01316 IMMUNIZATION-NOS'
             2444 'J01317 PHENCYCLIDINE COMBINATIONS-NOS'
             2445 'J01318 PNEUMOCOCCAL VACCINE' 2446 'J01319 FOLATE'
             2447 'J01320 PENTOBARBITAL/PHENYTOIN'
             2448 'J01322 BARBITAL SODIUM' 2449 'J01323 GADOLINIUM'
             2450 'J01324 HEPATITIS A VACCINE INACTIVATED' 2451 'J01327 ZINC'
             2452 'J01328 4-BROMO-2,5-DIMETHOXYPHENETHYLAMINE'
             2453 'J01329 2,5-DIMETHOXY-4-IODOPHENETHYLAMINE'
             2454 'J01330 AMPHETAMINE/COCAINE'
             2455 'J01331 METHANDROSTENLONE' 2456 'J01332 MARIJUANA/OPIUM'
             2457 'J01333 ALPROSTADIL/PAPAVERINE/PHENTOLAMINE'
             2458 'J01334 CYANIDE/HEROIN/STRYCHNINE'
             2459 'J01338 HYDROXYCODEINONE'
             2460 'J01340 2,5-DIMETHOXY-4-ETHYL-PHENETHYLAMINE'
             2461 'J01341 2,5-DIMETHOXY-4-(N)-PROPYLTHIOPHENETHYLAMINE'
             2462 'J01342 ANTI-RETROVIRAL AGENTS-NOS' 2463 'J01343 AROPLATIN'
             2464 'J01344 IDRAPARINUX'
             2465 'J01345 COCAINE/LYSERGIC ACID DIETHYLAMIDE'
             2466 'J01346 SALVIA DIVINORUM' 2467 'J01348 TIPIFARNIB'
             2468 'J01350 FLUOROURACIL-LEUCOVORIN'
             2469 'J01353 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE'
             2470 'J01354 CARPROFEN'
             2471 'J01355 RIFAMPIN/ISONIAZID/PYRAZINAMIDE/ETHAMBUTOL'
             2472 'J01356 THALLIUM' 2473 'J01357 POLYMYXIN B OTIC'
             2474 'J01358 ALLANTOIN/PRAMOXINE'
             2475 'J01359 COCAINE/MARIJUANA/FORMALDEHYDE'
             2476 'J01360 COCAINE/OPIUM'
            2477 'J01361 CYCLOPHOSPHAMIDE/DOXORUBICIN/VINCRISTINE/PREDNISONE'
             2478 'J01362 DIPHTHERIA/PERTUSISIS/POLIO/HAEMOPHILUS/TETANUS'
             2479 'J01363 ETORICOXIB' 2480 'J01365 FLUPENTHIXOL'
             2481 'J01366 FUSIDIC ACID' 2482 'J01367 HEROIN/METHAMPHETAMINE'
             2483 'J01368 IODINE CONTRAST AGENT'
             2484 'J01369 MARIJUANA/LYSERGIC ACID DIETHYLAMIDE'
             2485 'J01370 METHYLENEDIOXYMETHAMPHETAMINE/PSILOCYBIN'
             2486 'J01371 NEOMYCIN-POLYMYXIN B SULFATE OTIC'
             2487 'J01372 OXALIPLATIN/FLUOROURACIL/LEUCOVORIN'
             2488 'J01373 PHOSPHORUS'
             2489 'J01375 ADRENERGIC BRONCHODILATORS-NOS'
             2490 'J01379 OMEGA-6 POLYUNSATURATED FATTY ACIDS'
             2491 'J01380 TOPICAL ANTIFUNGALS-NOS'
             2492 'J01382 DEXTROMETHORPHAN COMBINATIONS-NOS'
             2493 'J01383 CLENBUTEROL' 2494 'J01386 FENTANYL/HEROIN'
             2495 'J01387 SULFONYLUREAS-NOS'
             2496 'J01388 COCAINE/FORMALDEHYDE'
             2497 'J01389 COCAINE/METHYLENEDIOXYMETHAMPHETAMINE'
             2498 'J01390 CYPROTEREONE ACETATE-ETHINYL ESTRADIOL'
             2499 'J01391 FAT DISSOLVING AGENTS-NOS'
             2500 'J01392 HEROIN/METHYLENEDIOXYMETHAMPHETAMINE'
             2501 'J01393 PROPOLIS' 2502 'J01394 SENNA COMBINATIONS-NOS'
             2503 'J01395 FENFLURAMINE/PHENTERMINE'
             2504 'J01396 ACNE AGENTS-NOS' 2505 'J01401 CLONIXIN'
             2506 'J01404 PROGESTINS-NOS' 2507 'J01405 RABIES VACCINE-NOS'
             2508 'J01411 INFLUENZA VIRUS VACCINE, H1N1-NOS'
             2509 'J01412 ACAI BERRY' 2510 'J01413 ALUM'
             2511 'J01414 AMMONIA' 2512 'J01415 BENZYLPIPERAZINE'
             2513 'J01416 BLUE GREEN ALGAE'
  2514 'J01417 CYCLOPHOSPHAMIDE/DOXORUBICIN/RITUXIMAB/VINCRISTINE/PREDNISONE'
             2515 'J01418 HOODIA' 2516 'J01419 HYALURONIC ACID'
             2517 'J01420 PAPAVERINE/PHENTOLAMINE' 2518 'J01421 STATIN-NOS'
             2519 'J01422 TEA TREE OIL'
             2520 'J01423 TRIFLUOROMETHYLPHENYLPIPERAZINE'
             2521 'J01424 4-METHYLMETHCATHINONE' 2522 'J01426 PHENAZEPAM'
             2523 'J01427 4-BROMO-3,6-DIMETHOXYBENZOCYCLOBUTEN'
             2524 'J01428 SYNTHETIC CANNABINOID' 2525 'J01429 AFATINIB'
             2526 'J01430 AMPHETAMINE/MARIJUANA' 2527 'J01431 AXITINIB'
             2528 'J01432 BLEOMYCIN/DACARBAZINE/DOXORUBICIN/VINBLASTINE'
             2529 'J01433 CAFFEINE COMBINATIONS-NOS'
             2530 'J01434 CAPECITABINE/OXALIPLATIN'
             2531 'J01435 COLLOIDAL SILVER'
             2532 'J01436 DOCETAXEL/FLUOROURACIL/OXALIPLATIN'
             2533 'J01437 DOMPERIDONE'
             2534 'J01438 FLUOROURACIL/IRINOTECAN/LEUCOVORIN'
             2535 'J01439 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE/RITUXIMAB'
             2536 'J01440 KETAMINE/MARIJUANA'
             2537 'J01441 L-TRYPTOPHAN/MELATONIN'
             2538 'J01442 MARIJUANA/OXYCODONE' 2539 'J01443 METAMIZOLE'
             2540 'J01444 3,4-METHYLENEDIOXYPYROVALERONE'
             2541 'J01445 PANOBINOSTAT' 2542 'J01446 PROBIOTICS-NOS'
             2543 'J01447 SPERMICIDES-NOS' 2544 'J01448 TILMICOSIN'
             2545 'J01449 AMPHETAMINES-NOS'
             2546 'J01450 ILLICIT COMBINATIONS-NOS' 2547 'J01451 VITAMIN D'
             2548 'J01454 TRENBOLONE'
             2549 'J01455 H. PYLORI ERADICATION AGENTS-NOS'
             2550 'J01456 SMOKING CESSATION AGENTS-NOS'
             2551 'J01457 4-BROMO-2,5-DIMETHOXYAMPHETAMINE'
             2552 'J01458 PROTEASE INHIBITORS-NOS'
             2553 'J01459 4-METHOXYMETHCATHINONE' 2554 'J01460 ELASTIN'
             2555 'J01461 TALCUM POWDER TOPICAL'
             2556 'J01462 METHYLENEDIOXYMETHAMPHETAMINE/CAFFEINE'
             2557 'J01463 ENERGY DRINK'
             2558 'J01464 CAFFEINE/MULTIVITAMIN NTA' /
   CATID_1_3 -7 'NOT APPLICABLE:(-7)' 1 'ANTI-INFECTIVES:(1)'
             20 'ANTINEOPLASTICS:(20)' 28 'BIOLOGICALS:(28)'
             40 'CARDIOVASCULAR AGENTS:(40)'
             57 'CENTRAL NERVOUS SYSTEM AGENTS:(57)'
             81 'COAGULATION MODIFIERS:(81)'
             87 'GASTROINTESTINAL AGENTS:(87)'
             97 'HORMONES/HORMONE MODIFIERS:(97)'
             105 'MISCELLANEOUS AGENTS:(105)'
             113 'GENITOURINARY TRACT AGENTS:(113)'
             115 'NUTRITIONAL PRODUCTS:(115)' 122 'RESPIRATORY AGENTS:(122)'
             133 'TOPICAL AGENTS:(133)' 153 'PLASMA EXPANDERS:(153)'
             218 'ALTERNATIVE MEDICINES:(218)'
             242 'PSYCHOTHERAPEUTIC AGENTS:(242)'
             254 'IMMUNOLOGIC AGENTS:(254)' 331 'RADIOLOGIC AGENTS:(331)'
             358 'METABOLIC AGENTS:(358)' 365 'MEDICAL GAS:(365)'
             2006 'DRUG UNKNOWN:(2006)' 2041 'NON-PHARMACEUTICAL:(2041)' /
   CATID_2_3 -7 'NOT APPLICABLE:(-7)' 2 'AMEBICIDES:(2)'
             3 'ANTHELMINTICS:(3)' 4 'ANTIFUNGALS:(4)'
             5 'ANTIMALARIAL AGENTS:(5)' 6 'ANTITUBERCULOSIS AGENTS:(6)'
             7 'ANTIVIRAL AGENTS:(7)' 8 'CARBAPENEMS:(8)'
             9 'CEPHALOSPORINS:(9)' 10 'LEPROSTATICS:(10)'
             11 'MACROLIDE DERIVATIVES:(11)'
             12 'MISCELLANEOUS ANTIBIOTICS:(12)' 13 'PENICILLINS:(13)'
             14 'QUINOLONES:(14)' 15 'SULFONAMIDES:(15)'
             16 'TETRACYCLINES:(16)' 17 'URINARY ANTI-INFECTIVES:(17)'
             18 'AMINOGLYCOSIDES:(18)' 19 'ANTIHYPERLIPIDEMIC AGENTS:(19)'
             21 'ALKYLATING AGENTS:(21)' 22 'ANTINEOPLASTIC ANTIBIOTICS:(22)'
             23 'ANTIMETABOLITES:(23)' 24 'ANTINEOPLASTIC HORMONES:(24)'
             25 'MISCELLANEOUS ANTINEOPLASTICS:(25)'
             26 'MITOTIC INHIBITORS:(26)' 27 'RADIOPHARMACEUTICALS:(27)'
             30 'ANTITOXINS AND ANTIVENINS:(30)' 33 'IMMUNE GLOBULINS:(33)'
             34 'IN VIVO DIAGNOSTIC BIOLOGICALS:(34)'
             36 'RECOMBINANT HUMAN ERYTHROPOIETINS:(36)'
             41 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(41)'
             42 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(42)'
             43 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(43)'
             44 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(44)'
             45 'ANTIANGINAL AGENTS:(45)' 46 'ANTIARRHYTHMIC AGENTS:(46)'
             47 'BETA-ADRENERGIC BLOCKING AGENTS:(47)'
             48 'CALCIUM CHANNEL BLOCKING AGENTS:(48)' 49 'DIURETICS:(49)'
             50 'INOTROPIC AGENTS:(50)'
             51 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(51)'
             52 'PERIPHERAL VASODILATORS:(52)' 53 'VASODILATORS:(53)'
             54 'VASOPRESSORS:(54)' 55 'ANTIHYPERTENSIVE COMBINATIONS:(55)'
             56 'ANGIOTENSIN II INHIBITORS:(56)' 58 'ANALGESICS:(58)'
             64 'ANTICONVULSANTS:(64)'
             65 'ANTIEMETIC/ANTIVERTIGO AGENTS:(65)'
             66 'ANTIPARKINSON AGENTS:(66)'
             67 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(67)'
             71 'CNS STIMULANTS:(71)' 72 'GENERAL ANESTHETICS:(72)'
             73 'MUSCLE RELAXANTS:(73)'
             80 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(80)'
             82 'ANTICOAGULANTS:(82)' 83 'ANTIPLATELET AGENTS:(83)'
             84 'HEPARIN ANTAGONISTS:(84)'
             85 'MISCELLANEOUS COAGULATION MODIFIERS:(85)'
             86 'THROMBOLYTICS:(86)' 88 'ANTACIDS:(88)'
             90 'ANTIDIARRHEALS:(90)' 91 'DIGESTIVE ENZYMES:(91)'
             92 'GALLSTONE SOLUBILIZING AGENTS:(92)' 93 'GI STIMULANTS:(93)'
             94 'H2 ANTAGONISTS:(94)' 95 'LAXATIVES:(95)'
             96 'MISCELLANEOUS GI AGENTS:(96)'
             98 'ADRENAL CORTICAL STEROIDS:(98)'
             99 'ANTIDIABETIC AGENTS:(99)' 100 'MISCELLANEOUS HORMONES:(100)'
             101 'SEX HORMONES:(101)' 103 'THYROID HORMONES:(103)'
             104 'IMMUNOSUPPRESSIVE AGENTS:(104)' 106 'ANTIDOTES:(106)'
             107 'CHELATING AGENTS:(107)'
             108 'CHOLINERGIC MUSCLE STIMULANTS:(108)'
             109 'LOCAL INJECTABLE ANESTHETICS:(109)'
             110 'MISCELLANEOUS UNCATEGORIZED AGENTS:(110)'
             111 'PSORALENS:(111)' 112 'RADIOCONTRAST AGENTS:(112)'
             114 'ILLICIT (STREET) DRUGS:(114)' 116 'IRON PRODUCTS:(116)'
             117 'MINERALS AND ELECTROLYTES:(117)'
             118 'ORAL NUTRITIONAL SUPPLEMENTS:(118)' 119 'VITAMINS:(119)'
             120 'VITAMIN AND MINERAL COMBINATIONS:(120)'
             121 'INTRAVENOUS NUTRITIONAL PRODUCTS:(121)'
             123 'ANTIHISTAMINES:(123)' 124 'ANTITUSSIVES:(124)'
             125 'BRONCHODILATORS:(125)' 127 'DECONGESTANTS:(127)'
             128 'EXPECTORANTS:(128)'
             129 'MISCELLANEOUS RESPIRATORY AGENTS:(129)'
             130 'RESPIRATORY INHALANT PRODUCTS:(130)'
             131 'ANTIASTHMATIC COMBINATIONS:(131)'
             132 'UPPER RESPIRATORY COMBINATIONS:(132)'
             134 'ANORECTAL PREPARATIONS:(134)'
             135 'ANTISEPTIC AND GERMICIDES:(135)'
             136 'DERMATOLOGICAL AGENTS:(136)'
             146 'MOUTH AND THROAT PRODUCTS:(146)'
             147 'OPHTHALMIC PREPARATIONS:(147)'
             148 'OTIC PREPARATIONS:(148)'
             150 'STERILE IRRIGATING SOLUTIONS:(150)'
             151 'VAGINAL PREPARATIONS:(151)' 192 'ANTIRHEUMATICS:(192)'
             194 'ANTIGOUT AGENTS:(194)' 219 'NUTRACEUTICAL PRODUCTS:(219)'
             220 'HERBAL PRODUCTS:(220)' 240 'LINCOMYCIN DERIVATIVES:(240)'
             243 'LEUKOTRIENE MODIFIERS:(243)' 247 'NASAL PREPARATIONS:(247)'
             249 'ANTIDEPRESSANTS:(249)' 251 'ANTIPSYCHOTICS:(251)'
             253 'ANOREXIANTS:(253)' 263 'IMPOTENCE AGENTS:(263)'
             264 'URINARY ANTISPASMODICS:(264)'
             265 'URINARY PH MODIFIERS:(265)'
             266 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(266)'
             270 'ANTIPSORIATICS:(270)' 272 'PROTON PUMP INHIBITORS:(272)'
             273 'LUNG SURFACTANTS:(273)' 277 '5-AMINOSALICYLATES:(277)'
             284 'VISCOSUPPLEMENTATION AGENTS:(284)'
             288 '5-ALPHA-REDUCTASE INHIBITORS:(288)'
             289 'ANTIHYPERURICEMIC AGENTS:(289)'
             293 'GLUCOSE ELEVATING AGENTS:(293)' 295 'GROWTH HORMONES:(295)'
             303 'AGENTS FOR PULMONARY HYPERTENSION:(303)'
             312 'CHOLINERGIC AGONISTS:(312)'
             313 'CHOLINESTERASE INHIBITORS:(313)' 315 'GLYCYLCYCLINES:(315)'
             318 'INSULIN-LIKE GROWTH FACTOR:(318)'
             319 'VASOPRESSIN ANTAGONISTS:(319)'
             320 'SMOKING CESSATION AGENTS:(320)'
             324 'ANTINEOPLASTIC INTERFERONS:(324)'
             325 'SCLEROSING AGENTS:(325)' 332 'RADIOLOGIC ADJUNCTS:(332)'
             340 'ALDOSTERONE RECEPTOR ANTAGONISTS:(340)'
             342 'RENIN INHIBITORS:(342)'
             354 'H. PYLORI ERADICATION AGENTS:(354)'
             355 'FUNCTIONAL BOWEL DISORDER AGENTS:(355)'
             357 'GROWTH HORMONE RECEPTOR BLOCKERS:(357)'
             359 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(359)'
             360 'LYSOSOMAL ENZYMES:(360)'
             361 'MISCELLANEOUS METABOLIC AGENTS:(361)'
             363 'PROBIOTICS:(363)' 377 'PROLACTIN INHIBITORS:(377)'
             378 'DRUGS USED IN ALCOHOL DEPENDENCE:(378)'
             383 'ANTINEOPLASTIC DETOXIFYING AGENTS:(383)'
             384 'PLATELET-STIMULATING AGENTS:(384)'
             390 'HEMATOPOIETIC STEM CELL MOBILIZER:(390)'
             397 'MULTIKINASE INHIBITORS:(397)'
             398 'BCR-ABL TYROSINE KINASE INHIBITORS:(398)'
             399 'CD52 MONOCLONAL ANTIBODIES:(399)'
             400 'CD33 MONOCLONAL ANTIBODIES:(400)'
             401 'CD20 MONOCLONAL ANTIBODIES:(401)'
             402 'VEGF/VEGFR INHIBITORS:(402)' 403 'MTOR INHIBITORS:(403)'
             404 'EGFR INHIBITORS:(404)' 405 'HER2 INHIBITORS:(405)'
             406 'GLYCOPEPTIDE ANTIBIOTICS:(406)'
             408 'HISTONE DEACETYLASE INHIBITORS:(408)'
             409 'BONE RESORPTION INHIBITORS:(409)'
             410 'ADRENAL CORTICOSTEROID INHIBITORS:(410)'
             411 'CALCITONIN:(411)' 412 'UTEROTONIC AGENTS:(412)'
             413 'ANTIGONADOTROPIC AGENTS:(413)'
             414 'ANTIDIURETIC HORMONES:(414)'
             416 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(416)'
             417 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(417)'
             418 'PARATHYROID HORMONE AND ANALOGS:(418)'
             419 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(419)'
             422 'ANTITHYROID AGENTS:(422)'
             426 'SYNTHETIC OVULATION STIMULANTS:(426)'
             427 'TOCOLYTIC AGENTS:(427)'
             428 'PROGESTERONE RECEPTOR MODULATORS:(428)'
             431 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(431)'
             433 'CATECHOLAMINES:(433)'
             435 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(435)'
             437 'IMMUNOSTIMULANTS:(437)'
             447 'CD30 MONOCLONAL ANTIBODIES:(447)' 2042 'INHALANT:(2042)'
             2051 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(2051)' /
   CATID_3_3 -7 'NOT APPLICABLE:(-7)' 31 'BACTERIAL VACCINES:(31)'
             32 'COLONY STIMULATING FACTORS:(32)' 38 'VIRAL VACCINES:(38)'
             61 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(61)'
             68 'BARBITURATES:(68)' 69 'BENZODIAZEPINES:(69)'
             70 'MISCELLANEOUS ANXIOLYTICS, SEDATIVES AND HYPNOTICS:(70)'
             74 'NEUROMUSCULAR BLOCKING AGENTS:(74)'
             76 'MISCELLANEOUS ANTIDEPRESSANTS:(76)'
             77 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(77)'
             79 'PSYCHOTHERAPEUTIC COMBINATIONS:(79)'
             89 'ANTICHOLINERGICS/ANTISPASMODICS:(89)'
             102 'CONTRACEPTIVES:(102)' 126 'METHYLXANTHINES:(126)'
             137 'TOPICAL ANTI-INFECTIVES:(137)' 138 'TOPICAL STEROIDS:(138)'
             139 'TOPICAL ANESTHETICS:(139)'
             140 'MISCELLANEOUS TOPICAL AGENTS:(140)'
             141 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(141)'
             143 'TOPICAL ACNE AGENTS:(143)'
             144 'TOPICAL ANTIPSORIATICS:(144)' 149 'SPERMICIDES:(149)'
             154 'LOOP DIURETICS:(154)'
             155 'POTASSIUM-SPARING DIURETICS:(155)'
             156 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(156)'
             157 'CARBONIC ANHYDRASE INHIBITORS:(157)'
             158 'MISCELLANEOUS DIURETICS:(158)'
             159 'FIRST GENERATION CEPHALOSPORINS:(159)'
             160 'SECOND GENERATION CEPHALOSPORINS:(160)'
             161 'THIRD GENERATION CEPHALOSPORINS:(161)'
             162 'FOURTH GENERATION CEPHALOSPORINS:(162)'
             163 'OPHTHALMIC ANTI-INFECTIVES:(163)'
             164 'OPHTHALMIC GLAUCOMA AGENTS:(164)'
             165 'OPHTHALMIC STEROIDS:(165)'
             166 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(166)'
             167 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(167)'
             168 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(168)'
             169 'MISCELLANEOUS OPHTHALMIC AGENTS:(169)'
             170 'OTIC ANTI-INFECTIVES:(170)'
             171 'OTIC STEROIDS WITH ANTI-INFECTIVES:(171)'
             172 'MISCELLANEOUS OTIC AGENTS:(172)'
             173 'HMG-COA REDUCTASE INHIBITORS:(173)'
             174 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(174)'
             175 'PROTEASE INHIBITORS:(175)' 176 'NRTIS:(176)'
             177 'MISCELLANEOUS ANTIVIRALS:(177)'
             178 'SKELETAL MUSCLE RELAXANTS:(178)'
             179 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(179)'
             180 'ADRENERGIC BRONCHODILATORS:(180)'
             181 'BRONCHODILATOR COMBINATIONS:(181)'
             182 'ANDROGENS AND ANABOLIC STEROIDS:(182)'
             183 'ESTROGENS:(183)' 184 'GONADOTROPINS:(184)'
             185 'PROGESTINS:(185)' 186 'SEX HORMONE COMBINATIONS:(186)'
             187 'MISCELLANEOUS SEX HORMONES:(187)'
             193 'ANTIMIGRAINE AGENTS:(193)'
             195 '5HT3 RECEPTOR ANTAGONISTS:(195)'
             196 'PHENOTHIAZINE ANTIEMETICS:(196)'
             197 'ANTICHOLINERGIC ANTIEMETICS:(197)'
             198 'MISCELLANEOUS ANTIEMETICS:(198)'
             199 'HYDANTOIN ANTICONVULSANTS:(199)'
             200 'SUCCINIMIDE ANTICONVULSANTS:(200)'
             201 'BARBITURATE ANTICONVULSANTS:(201)'
             202 'OXAZOLIDINEDIONE ANTICONVULSANTS:(202)'
             203 'BENZODIAZEPINE ANTICONVULSANTS:(203)'
             204 'MISCELLANEOUS ANTICONVULSANTS:(204)'
             205 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(205)'
             206 'MISCELLANEOUS ANTIPARKINSON AGENTS:(206)'
             208 'SSRI ANTIDEPRESSANTS:(208)'
             209 'TRICYCLIC ANTIDEPRESSANTS:(209)'
             210 'PHENOTHIAZINE ANTIPSYCHOTICS:(210)'
             211 'PLATELET AGGREGATION INHIBITORS:(211)'
             212 'GLYCOPROTEIN PLATELET INHIBITORS:(212)'
             213 'SULFONYLUREAS:(213)' 214 'BIGUANIDES:(214)'
             215 'INSULIN:(215)' 216 'ALPHA-GLUCOSIDASE INHIBITORS:(216)'
             217 'BISPHOSPHONATES:(217)'
             222 'PENICILLINASE RESISTANT PENICILLINS:(222)'
             223 'ANTIPSEUDOMONAL PENICILLINS:(223)'
             224 'AMINOPENICILLINS:(224)'
             225 'BETA-LACTAMASE INHIBITORS:(225)'
             226 'NATURAL PENICILLINS:(226)' 227 'NNRTIS:(227)'
             228 'ADAMANTANE ANTIVIRALS:(228)' 229 'PURINE NUCLEOSIDES:(229)'
             230 'AMINOSALICYLATES:(230)'
             231 'NICOTINIC ACID DERIVATIVES:(231)'
             232 'RIFAMYCIN DERIVATIVES:(232)'
             233 'STREPTOMYCES DERIVATIVES:(233)'
             234 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(234)'
             235 'POLYENES:(235)' 236 'AZOLE ANTIFUNGALS:(236)'
             237 'MISCELLANEOUS ANTIFUNGALS:(237)'
             238 'ANTIMALARIAL QUINOLINES:(238)'
             239 'MISCELLANEOUS ANTIMALARIALS:(239)'
             241 'FIBRIC ACID DERIVATIVES:(241)'
             244 'NASAL LUBRICANTS AND IRRIGATIONS:(244)'
             245 'NASAL STEROIDS:(245)'
             246 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(246)'
             248 'TOPICAL EMOLLIENTS:(248)'
             250 'MONOAMINE OXIDASE INHIBITORS:(250)'
             252 'BILE ACID SEQUESTRANTS:(252)' 256 'INTERFERONS:(256)'
             261 'HEPARINS:(261)' 262 'COUMARINS AND INDANEDIONES:(262)'
             267 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(267)'
             268 'VAGINAL ANTI-INFECTIVES:(268)'
             269 'MISCELLANEOUS VAGINAL AGENTS:(269)'
             271 'THIAZOLIDINEDIONES:(271)'
             274 'CARDIOSELECTIVE BETA BLOCKERS:(274)'
             275 'NON-CARDIOSELECTIVE BETA BLOCKERS:(275)'
             276 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(276)'
             278 'COX-2 INHIBITORS:(278)'
             279 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(279)'
             280 'THIOXANTHENES:(280)' 281 'NEURAMINIDASE INHIBITORS:(281)'
             282 'MEGLITINIDES:(282)' 283 'THROMBIN INHIBITORS:(283)'
             285 'FACTOR XA INHIBITORS:(285)' 286 'MYDRIATICS:(286)'
             287 'OPHTHALMIC ANESTHETICS:(287)'
             290 'TOPICAL ANTIBIOTICS:(290)' 291 'TOPICAL ANTIVIRALS:(291)'
             292 'TOPICAL ANTIFUNGALS:(292)'
             296 'INHALED CORTICOSTEROIDS:(296)' 297 'MUCOLYTICS:(297)'
             298 'MAST CELL STABILIZERS:(298)'
             299 'ANTICHOLINERGIC BRONCHODILATORS:(299)'
             300 'CORTICOTROPIN:(300)' 301 'GLUCOCORTICOIDS:(301)'
             302 'MINERALOCORTICOIDS:(302)' 304 'MACROLIDES:(304)'
             305 'KETOLIDES:(305)'
             306 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(306)'
             307 'TETRACYCLIC ANTIDEPRESSANTS:(307)'
             308 'SSNRI ANTIDEPRESSANTS:(308)'
             309 'MISCELLANEOUS ANTIDIABETIC AGENTS:(309)'
             310 'ECHINOCANDINS:(310)'
             311 'DIBENZAZEPINE ANTICONVULSANTS:(311)'
             314 'ANTIDIABETIC COMBINATIONS:(314)'
             316 'CHOLESTEROL ABSORPTION INHIBITORS:(316)'
             317 'ANTIHYPERLIPIDEMIC COMBINATIONS:(317)'
             321 'OPHTHALMIC DIAGNOSTIC AGENTS:(321)'
             322 'OPHTHALMIC SURGICAL AGENTS:(322)'
             327 'ANTIVIRAL COMBINATIONS:(327)'
             328 'ANTIMALARIAL COMBINATIONS:(328)'
             329 'ANTITUBERCULOSIS COMBINATIONS:(329)'
             330 'ANTIVIRAL INTERFERONS:(330)'
             333 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(333)'
             334 'LYMPHATIC STAINING AGENTS:(334)'
             335 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(335)'
             336 'NON-IODINATED CONTRAST MEDIA:(336)'
             337 'ULTRASOUND CONTRAST MEDIA:(337)'
             338 'DIAGNOSTIC RADIOPHARMACEUTICALS:(338)'
             339 'THERAPEUTIC RADIOPHARMACEUTICALS:(339)'
             341 'ATYPICAL ANTIPSYCHOTICS:(341)'
             345 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(345)'
             346 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(346)'
             347 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(347)'
             348 'TRIAZINE ANTICONVULSANTS:(348)'
             349 'CARBAMATE ANTICONVULSANTS:(349)'
             350 'PYRROLIDINE ANTICONVULSANTS:(350)'
             351 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(351)'
             352 'UREA ANTICONVULSANTS:(352)'
             353 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(353)'
             356 'SEROTONINERGIC NEUROENTERIC MODULATORS:(356)'
             362 'CHLORIDE CHANNEL ACTIVATORS:(362)'
             364 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(364)'
             366 'INTEGRASE STRAND TRANSFER INHIBITOR:(366)'
             368 'NON-IONIC IODINATED CONTRAST MEDIA:(368)'
             369 'IONIC IODINATED CONTRAST MEDIA:(369)'
             370 'OTIC STEROIDS:(370)'
             371 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(371)'
             372 'AMYLIN ANALOGS:(372)' 373 'INCRETIN MIMETICS:(373)'
             374 'CARDIAC STRESSING AGENTS:(374)'
             375 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(375)'
             379 'FIFTH GENERATION CEPHALOSPORINS:(379)'
             380 'TOPICAL DEBRIDING AGENTS:(380)'
             381 'TOPICAL DEPIGMENTING AGENTS:(381)'
             382 'TOPICAL ANTIHISTAMINES:(382)'
             385 'GROUP I ANTIARRHYTHMICS:(385)'
             387 'GROUP III ANTIARRHYTHMICS:(387)'
             389 'GROUP V ANTIARRHYTHMICS:(389)' 392 'OTIC ANESTHETICS:(392)'
             393 'CERUMENOLYTICS:(393)' 394 'TOPICAL ASTRINGENTS:(394)'
             395 'TOPICAL KERATOLYTICS:(395)'
             415 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(415)'
             432 'VACCINE COMBINATIONS:(432)'
             439 'OTHER IMMUNOSTIMULANTS:(439)'
             440 'THERAPEUTIC VACCINES:(440)'
             441 'CALCINEURIN INHIBITORS:(441)'
             442 'TNF ALFA INHIBITORS:(442)'
             443 'INTERLEUKIN INHIBITORS:(443)'
             444 'SELECTIVE IMMUNOSUPPRESSANTS:(444)'
             445 'OTHER IMMUNOSUPPRESSANTS:(445)'
             448 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(448)'
             2005 'ALCOHOL IN COMBINATION:(2005)'
             2007 'MISCELLANEOUS BRONCHODILATORS:(2007)'
             2008 'MISCELLANEOUS NASAL PREPARATIONS:(2008)'
             2030 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(2030)'
             2031 'MISCELLANEOUS HALLUCINOGENS:(2031)'
             2032 'ILLICIT MAJOR SUBSTANCE OF ABUSE:(2032)'
             2033 'ILLICIT COMBINATIONS:(2033)'
             2034 'ILLICIT AND OTHER COMBINATIONS:(2034)'
             2036 'MISCELLANEOUS CEPHALOSPORINS:(2036)'
             2043 'VOLATILE AGENT:(2043)' 2044 'NITRITES:(2044)'
             2045 'CHLORO-FLUORO-HYDROCARBONS:(2045)'
             2046 'MISCELLANEOUS MUSCLE RELAXANTS:(2046)'
             2047 'NARCOTIC ANALGESICS/COMBINATIONS:(2047)'
             2048 'SALICYLATES/COMBINATIONS:(2048)'
             2049 'MISCELLANEOUS ANALGESIC/COMBINATIONS:(2049)'
             2050 'ANALGESIC COMBINATIONS NTA:(2050)'
             2052 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(2052)'
             2053 'MISCELLANEOUS MACROLIDE:(2053)'
             2054 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(2054)'
             2055 'MISCELLANEOUS RADIOCONTRAST AGENTS:(2055)'
             2056 'MISCELLANEOUS RADIOPHARMACEUTICALS:(2056)' /
   ROUTE_3   -9 'MISSING:(-9)' -8 'NOT DOCUMENTED:(-8)'
             -7 'NOT APPLICABLE:(-7)' 1 'ORAL:(1)' 2 'INJECTED:(2)'
             3 'INHALED, SNIFFED, SNORTED:(3)' 4 'SMOKED:(4)' 5 'OTHER:(5)'
             6 'TRANSDERMAL:(6)' 98 'MULTIPLE ROUTES FOR THIS DRUG:(98)' /
   TOXTEST_3 -9 'MISSING:(-9)' -7 'NOT APPLICABLE:(-7)'
             1 'CONFIRMED TEST:(1)' 2 'NOT CONFIRMED:(2)' /
   SDLED_1_3 -7 'NOT APPLICABLE:(-7)' 1 'MAJOR SUBSTANCES OF ABUSE:(1)'
             17 'OTHER SUBSTANCES:(17)' /
   SDLED_2_3 -7 'NOT APPLICABLE:(-7)' 2 'ALCOHOL:(2)'
             2.5 'NON-ALCOHOL ILLICITS:(2.5)'
             18 'PSYCHOTHERAPEUTIC AGENTS:(18)' 33 'CNS AGENTS:(33)'
             50 'RESPIRATORY AGENTS:(50)' 57 'CARDIOVASCULAR AGENTS:(57)'
             63 'ALTERNATIVE MEDICINES:(63)' 64 'ANTI-INFECTIVES:(64)'
             65 'ANTINEOPLASTICS:(65)' 66 'BIOLOGICALS:(66)'
             67 'COAGULATION MODIFIERS:(67)'
             68 'GASTROINTESTINAL AGENTS:(68)'
             69 'GENITOURINARY TRACT AGENTS:(69)' 70 'HORMONES:(70)'
             71 'IMMUNOLOGIC AGENTS:(71)' 72 'MEDICAL GAS:(72)'
             73 'METABOLIC AGENTS:(73)' 74 'MISCELLANEOUS AGENTS:(74)'
             75 'NUTRITIONAL PRODUCTS:(75)' 76 'PLASMA EXPANDERS:(76)'
             77 'RADIOLOGIC AGENTS:(77)' 78 'TOPICAL AGENTS:(78)'
             79 'DRUG UNKNOWN:(79)' /
   SDLED_3_3 -7 'NOT APPLICABLEL:(-7.00)' 3 'COCAINE:(3)' 4 'HEROIN:(4)'
             5 'CANNABINOIDS:(5)' 5.5 'STIMULANTS:(5.5)'
             8 'MDMA (ECSTASY):(8)' 8.1 'GHB:(8.1)'
             8.2 'FLUNITRAZEPAM (ROHYPNOL):(8.2)' 9 'KETAMINE:(9)'
             10 'LSD:(10)' 11 'PCP:(11)'
             12 'MISCELLANEOUS HALLUCINOGENS:(12)' 15 'INHALANTS:(15)'
             16 'COMBINATIONS NTA:(16)' 19 'ANTIDEPRESSANTS:(19)'
             24 'ANTIPSYCHOTICS:(24)' 34 'ANALGESICS:(34)'
             43 'ANOREXIANTS:(43)' 44 'ANTICONVULSANTS:(44)'
             45 'ANTIEMETIC/ANTIVERTIGO AGENTS:(45)'
             46 'ANTIPARKINSON AGENTS:(46)'
             46.3 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.3)'
             46.5 'CNS STIMULANTS:(46.5)'
             46.7 'DRUGS USED IN ALCOHOL DEPENDENCE:(46.7)'
             47 'GENERAL ANESTHETICS:(47)' 48 'MUSCLE RELAXANTS:(48)'
             49 'MISCELLANEOUS CNS AGENTS:(49)' 51 'ANTIHISTAMINES:(51)'
             52 'BRONCHODILATORS:(52)' 53 'DECONGESTANTS:(53)'
             54 'EXPECTORANTS:(54)'
             54.5 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(54.5)'
             55 'UPPER RESPIRATORY COMBINATIONS:(55)'
             56 'RESPIRATORY AGENTS NTA:(56)'
             58 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(58)'
             59 'BETA-ADRENERGIC BLOCKING AGENTS:(59)'
             60 'CALCIUM CHANNEL BLOCKING AGENTS:(60)' 61 'DIURETICS:(61)'
             61.3 'RENIN INHIBITORS:(61.3)'
             61.5 'VASOPRESSIN ANTAGONISTS:(61.5)'
             62 'CARDIOVASCULAR AGENTS NTA:(62)'
             63.1 'HERBAL PRODUCTS:(63.1)'
             63.2 'NUTRACEUTICAL PRODUCTS:(63.2)' 63.3 'PROBIOTICS:(63.3)'
             64.01 'AMEBICIDES:(64.01)' 64.02 'AMINOGLYCOSIDES:(64.02)'
             64.03 'ANTHELMINTICS:(64.03)' 64.04 'ANTIFUNGALS:(64.04)'
             64.05 'ANTIMALARIAL AGENTS:(64.05)'
             64.06 'ANTITUBERCULOSIS AGENTS:(64.06)'
             64.07 'ANTIVIRAL AGENTS:(64.07)' 64.08 'CARBAPENEMS:(64.08)'
             64.09 'CEPHALOSPORINS:(64.09)'
             64.1 'GLYCOPEPTIDE ANTIBIOTICS:(64.1)'
             64.11 'GLYCYLCYCLINES:(64.11)' 64.12 'LEPROSTATICS:(64.12)'
             64.13 'LINCOMYCIN DERIVATIVES:(64.13)'
             64.14 'MACROLIDE DERIVATIVES:(64.14)'
             64.15 'PENICILLINS:(64.15)' 64.16 'QUINOLONES:(64.16)'
             64.17 'SULFONAMIDES:(64.17)' 64.18 'TETRACYCLINES:(64.18)'
             64.19 'URINARY ANTI-INFECTIVES:(64.19)'
             64.99 'MISCELLANEOUS ANTIBIOTICS:(64.99)'
             65.01 'ALKYLATING AGENTS:(65.01)'
             65.02 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(65.02)'
             65.03 'ANTIMETABOLITES:(65.03)'
             65.04 'ANTINEOPLASTIC ANTIBIOTICS:(65.04)'
             65.05 'ANTINEOPLASTIC DETOXIFYING AGENTS:(65.05)'
             65.06 'ANTINEOPLASTIC HORMONES:(65.06)'
             65.07 'ANTINEOPLASTIC INTERFERONS:(65.07)'
             65.08 'BCR-ABL TYROSINE KINASE INHIBITORS:(65.08)'
             65.09 'CD20 MONOCLONAL ANTIBODIES:(65.09)'
             65.11 'CD33 MONOCLONAL ANTIBODIES:(65.11)'
             65.12 'CD52 MONOCLONAL ANTIBODIES:(65.12)'
             65.13 'EGFR INHIBITORS:(65.13)' 65.14 'HER2 INHIBITORS:(65.14)'
             65.15 'HISTONE DEACETYLASE INHIBITORS:(65.15)'
             65.16 'MITOTIC INHIBITORS:(65.16)'
             65.17 'MTOR INHIBITORS:(65.17)'
             65.18 'MULTIKINASE INHIBITORS:(65.18)'
             65.2 'VEGF/VEGFR INHIBITORS:(65.2)'
             65.99 'MISCELLANEOUS ANTINEOPLASTICS:(65.99)'
             66.01 'ANTITOXINS AND ANTIVENINS:(66.01)'
             66.04 'IN VIVO DIAGNOSTIC BIOLOGICALS:(66.04)'
             66.05 'RECOMBINANT HUMAN ERYTHROPOIETINS:(66.05)'
             67.01 'ANTICOAGULANTS:(67.01)'
             67.02 'ANTIPLATELET AGENTS:(67.02)'
             67.03 'HEPARIN ANTAGONISTS:(67.03)'
             67.04 'PLATELET-STIMULATING AGENTS:(67.04)'
             67.05 'THROMBOLYTICS:(67.05)'
             67.06 'MISCELLANEOUS COAGULATION MODIFIERS:(67.06)'
             68.01 '5-AMINOSALICYLATES:(68.01)' 68.02 'ANTACIDS:(68.02)'
             68.04 'ANTIDIARRHEALS:(68.04)' 68.05 'DIGESTIVE ENZYMES:(68.05)'
             68.06 'FUNCTIONAL BOWEL DISORDER AGENTS:(68.06)'
             68.07 'GALLSTONE SOLUBILIZING AGENTS:(68.07)'
             68.08 'GI STIMULANTS:(68.08)'
             68.09 'H. PYLORI ERADICATION AGENTS:(68.09)'
             68.1 'H2 ANTAGONISTS:(68.1)' 68.11 'LAXATIVES:(68.11)'
             68.12 'PROTON PUMP INHIBITORS:(68.12)'
             68.13 'MISCELLANEOUS GI AGENTS:(68.13)'
             69.01 'IMPOTENCE AGENTS:(69.01)'
             69.02 'TOCOLYTIC AGENTS:(69.02)'
             69.03 'URINARY ANTISPASMODICS:(69.03)'
             69.04 'URINARY PH MODIFIERS:(69.04)'
             69.05 'UTEROTONIC AGENTS:(69.05)'
             69.99 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(69.99)'
             70.01 '5-ALPHA-REDUCTASE INHIBITORS:(70.01)'
             70.02 'ADRENAL CORTICAL STEROIDS:(70.02)'
             70.05 'ANTIDIURETIC HORMONES:(70.05)'
             70.06 'ANTIGONADOTROPIC AGENTS:(70.06)'
             70.07 'ANTITHYROID AGENTS:(70.07)' 70.09 'CALCITONIN:(70.09)'
             70.11 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(70.11)'
             70.12 'GROWTH HORMONE RECEPTOR BLOCKERS:(70.12)'
             70.13 'GROWTH HORMONES:(70.13)'
             70.15 'INSULIN-LIKE GROWTH FACTOR:(70.15)'
             70.16 'PARATHYROID HORMONE AND ANALOGS:(70.16)'
             70.17 'PROGESTERONE RECEPTOR MODULATORS:(70.17)'
             70.18 'PROLACTIN INHIBITORS:(70.18)'
             70.19 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(70.19)'
             70.2 'SEX HORMONES:(70.2)'
             70.21 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(70.21)'
             70.22 'SYNTHETIC OVULATION STIMULANTS:(70.22)'
             70.23 'THYROID HORMONES:(70.23)'
             70.99 'MISCELLANEOUS HORMONES:(70.99)'
             71.01 'IMMUNE GLOBULINS:(71.01)'
             71.02 'IMMUNOSTIMULANTS:(71.02)'
             71.03 'IMMUNOSUPPRESSIVE AGENTS:(71.03)'
             71.99 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(71.99)'
             73.01 'ANTIDIABETIC AGENTS:(73.01)'
             73.02 'ANTIGOUT AGENTS:(73.02)'
             73.03 'ANTIHYPERLIPIDEMIC AGENTS:(73.03)'
             73.04 'ANTIHYPERURICEMIC AGENTS:(73.04)'
             73.05 'BONE RESORPTION INHIBITORS:(73.05)'
             73.06 'GLUCOSE ELEVATING AGENTS:(73.06)'
             73.07 'LYSOSOMAL ENZYMES:(73.07)'
             73.08 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(73.08)'
             73.99 'MISCELLANEOUS METABOLIC AGENTS:(73.99)'
             74.01 'ANTIDOTES:(74.01)' 74.04 'ANTIPSORIATICS:(74.04)'
             74.05 'ANTIRHEUMATICS:(74.05)' 74.06 'CHELATING AGENTS:(74.06)'
             74.07 'CHOLINERGIC MUSCLE STIMULANTS:(74.07)'
             74.11 'LOCAL INJECTABLE ANESTHETICS:(74.11)'
             74.13 'PSORALENS:(74.13)'
             74.17 'SMOKING CESSATION AGENTS:(74.17)'
             74.18 'VISCOSUPPLEMENTATION AGENTS:(74.18)'
             74.19 'MISCELLANEOUS UNCATEGORIZED AGENTS:(74.19)'
             75.01 'INTRAVENOUS NUTRITIONAL PRODUCTS:(75.01)'
             75.02 'IRON PRODUCTS:(75.02)'
             75.03 'MINERALS AND ELECTROLYTES:(75.03)'
             75.04 'ORAL NUTRITIONAL SUPPLEMENTS:(75.04)'
             75.05 'VITAMIN AND MINERAL COMBINATIONS:(75.05)'
             75.06 'VITAMINS:(75.06)' 77.01 'RADIOCONTRAST AGENTS:(77.01)'
             77.02 'RADIOLOGIC ADJUNCTS:(77.02)'
             77.03 'RADIOPHARMACEUTICALS:(77.03)'
             78.01 'ANORECTAL PREPARATIONS:(78.01)'
             78.02 'ANTISEPTIC AND GERMICIDES:(78.02)'
             78.03 'DERMATOLOGICAL AGENTS:(78.03)'
             78.04 'MOUTH AND THROAT PRODUCTS:(78.04)'
             78.05 'NASAL PREPARATIONS:(78.05)'
             78.06 'OPHTHALMIC PREPARATIONS:(78.06)'
             78.07 'OTIC PREPARATIONS:(78.07)'
             78.08 'STERILE IRRIGATING SOLUTIONS:(78.08)'
             78.09 'VAGINAL PREPARATIONS:(78.09)' /
   SDLED_4_3 -7 'NOT APPLICABLE:(-7.00)' 5.01 'MARIJUANA:(5.01)'
             5.02 'SYNTHETIC CANNABINOIDS:(5.02)' 6 'AMPHETAMINES:(6)'
             7 'METHAMPHETAMINE:(7)' 7.1 'OTHER STIMULANTS:(7.1)'
             20 'MAO INHIBITORS:(20)'
             20.4 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(20.4)'
             20.7 'SSNRI ANTIDEPRESSANTS:(20.7)'
             21 'SSRI ANTIDEPRESSANTS:(21)'
             21.5 'TETRACYCLIC ANTIDEPRESSANTS:(21.5)'
             22 'TRICYCLIC ANTIDEPRESSANTS:(22)'
             23 'MISCELLANEOUS ANTIDEPRESSANTS:(23)'
             25 'ATYPICAL ANTIPSYCHOTICS:(25)'
             26 'PHENOTHIAZINE ANTIPSYCHOTICS:(26)'
             26.5 'PSYCHOTHERAPEUTIC COMBINATIONS:(26.5)'
             26.7 'THIOXANTHENES:(26.7)'
             27 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(27)'
             35 'ANTIMIGRAINE AGENTS:(35)' 36 'COX-2 INHIBITORS:(36)'
             36.5 'OPIATES/OPIOIDS:(36.5)'
             39 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(39)'
             40.5 'SALICYLATES/COMBINATIONS:(40.5)'
             41.5 'MISCELLANEOUS ANALGESICS/COMBINATIONS:(41.5)'
             42.5 'ANALGESIC COMBINATIONS NTA:(42.5)'
             43.01 'PHENYLPROPANOLAMINE:(43.01)'
             43.02 'ANOREXIANTS-NOS:(43.02)' 43.09 'ANOREXIANTS NTA:(43.09)'
             44.01 'BARBITURATE ANTICONVULSANTS:(44.01)'
             44.02 'BENZODIAZEPINE ANTICONVULSANTS:(44.02)'
             44.03 'CARBAMATE ANTICONVULSANTS:(44.03)'
             44.04 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(44.04)'
             44.05 'DIBENZAZEPINE ANTICONVULSANTS:(44.05)'
             44.06 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(44.06)'
             44.07 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(44.07)'
             44.08 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(44.08)'
             44.09 'HYDANTOIN ANTICONVULSANTS:(44.09)'
             44.11 'OXAZOLIDINEDIONE ANTICONVULSANTS:(44.11)'
             44.12 'PYRROLIDINE ANTICONVULSANTS:(44.12)'
             44.13 'SUCCINIMIDE ANTICONVULSANTS:(44.13)'
             44.14 'TRIAZINE ANTICONVULSANTS:(44.14)'
             44.99 'MISCELLANEOUS ANTICONVULSANTS:(44.99)'
             45.01 '5HT3 RECEPTOR ANTAGONISTS:(45.01)'
             45.02 'ANTICHOLINERGIC ANTIEMETICS:(45.02)'
             45.03 'PHENOTHIAZINE ANTIEMETICS:(45.03)'
             45.04 'MISCELLANEOUS ANTIEMETICS:(45.04)'
             46.01 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(46.01)'
             46.02 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(46.02)'
             46.03 'MISCELLANEOUS ANTIPARKINSON AGENTS:(46.03)'
             46.31 'BARBITURATES:(46.31)' 46.32 'BENZODIAZEPINES:(46.32)'
             46.33 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.33)'
             46.501 'AMPHETAMINE-DEXTROAMPHETAMINE:(46.501)'
             46.502 'BENZPHETAMINE:(46.502)' 46.503 'CAFFEINE:(46.503)'
             46.504 'DEXTROAMPHETAMINE:(46.504)'
             46.505 'METHYLPHENIDATE:(46.505)'
             46.509 'CNS STIMULANTS NTA:(46.509)'
             48.01 'NEUROMUSCULAR BLOCKING AGENTS:(48.01)'
             48.02 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(48.02)'
             48.03 'SKELETAL MUSCLE RELAXANTS:(48.03)'
             48.04 'MISCELLANEOUS MUSCLE RELAXANTS:(48.04)'
             49.01 'CHOLINERGIC AGONISTS:(49.01)'
             49.02 'CHOLINESTERASE INHIBITORS:(49.02)'
             49.03 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(49.03)'
             52.01 'ADRENERGIC BRONCHODILATORS:(52.01)'
             52.02 'ANTICHOLINERGIC BRONCHODILATORS:(52.02)'
             52.03 'BRONCHODILATOR COMBINATIONS:(52.03)'
             52.04 'METHYLXANTHINES:(52.04)'
             52.05 'MISCELLANEOUS BRONCHODILATORS:(52.05)'
             56.01 'ANTIASTHMATIC COMBINATIONS:(56.01)'
             56.02 'ANTITUSSIVES:(56.02)'
             56.03 'LEUKOTRIENE MODIFIERS:(56.03)'
             56.05 'RESPIRATORY INHALANT PRODUCTS:(56.05)'
             56.06 'MISCELLANEOUS RESPIRATORY AGENTS:(56.06)'
             58.01 'CLONIDINE:(58.01)'
             58.09 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING NTA:(58.09)'
             59.01 'CARDIOSELECTIVE BETA BLOCKERS:(59.01)'
             59.02 'NON-CARDIOSELECTIVE BETA BLOCKERS:(59.02)'
             59.03 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(59.03)'
             61.01 'CARBONIC ANHYDRASE INHIBITORS:(61.01)'
             61.02 'LOOP DIURETICS:(61.02)'
             61.03 'POTASSIUM-SPARING DIURETICS:(61.03)'
             61.04 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(61.04)'
             61.05 'MISCELLANEOUS DIURETICS:(61.05)'
             62.01 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(62.01)'
             62.02 'AGENTS FOR PULMONARY HYPERTENSION:(62.02)'
             62.03 'ALDOSTERONE RECEPTOR ANTAGONISTS:(62.03)'
             62.04 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(62.04)'
             62.05 'ANGIOTENSIN II INHIBITORS:(62.05)'
             62.06 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(62.06)'
             62.07 'ANTIANGINAL AGENTS:(62.07)'
             62.08 'ANTIARRHYTHMIC AGENTS:(62.08)'
             62.09 'ANTIHYPERTENSIVE COMBINATIONS:(62.09)'
             62.1 'CATECHOLAMINES:(62.1)' 62.11 'INOTROPIC AGENTS:(62.11)'
             62.12 'PERIPHERAL VASODILATORS:(62.12)'
             62.13 'SCLEROSING AGENTS:(62.13)' 62.14 'VASODILATORS:(62.14)'
             62.15 'VASOPRESSORS:(62.15)'
             62.99 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(62.99)'
             64.041 'AZOLE ANTIFUNGALS:(64.041)'
             64.042 'ECHINOCANDINS:(64.042)' 64.043 'POLYENES:(64.043)'
             64.044 'MISCELLANEOUS ANTIFUNGALS:(64.044)'
             64.051 'ANTIMALARIAL COMBINATIONS:(64.051)'
             64.052 'ANTIMALARIAL QUINOLINES:(64.052)'
             64.053 'MISCELLANEOUS ANTIMALARIALS:(64.053)'
             64.061 'AMINOSALICYLATES:(64.061)'
             64.062 'ANTITUBERCULOSIS COMBINATIONS:(64.062)'
             64.063 'NICOTINIC ACID DERIVATIVES:(64.063)'
             64.064 'RIFAMYCIN DERIVATIVES:(64.064)'
             64.065 'STREPTOMYCES DERIVATIVES:(64.065)'
             64.066 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(64.066)'
             64.0701 'ADAMANTANE ANTIVIRALS:(64.0701)'
             64.0702 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(64.0702)'
             64.0703 'ANTIVIRAL COMBINATIONS:(64.0703)'
             64.0704 'ANTIVIRAL INTERFERONS:(64.0704)'
             64.0705 'INTEGRASE STRAND TRANSFER INHIBITOR:(64.0705)'
             64.0706 'NEURAMINIDASE INHIBITORS:(64.0706)'
             64.0707 'NNRTIS:(64.0707)' 64.0708 'NRTIS:(64.0708)'
             64.0709 'PROTEASE INHIBITORS:(64.0709)'
             64.071 'PURINE NUCLEOSIDES:(64.071)'
             64.0711 'MISCELLANEOUS ANTIVIRALS:(64.0711)'
             64.091 'FIRST GENERATION CEPHALOSPORINS:(64.091)'
             64.092 'SECOND GENERATION CEPHALOSPORINS:(64.092)'
             64.093 'THIRD GENERATION CEPHALOSPORINS:(64.093)'
             64.094 'FOURTH GENERATION CEPHALOSPORINS:(64.094)'
             64.095 'FIFTH GENERATION CEPHALOSPORINS:(64.095)'
             64.096 'MISCELLANEOUS CEPHALOSPORINS:(64.096)'
             64.141 'KETOLIDES:(64.141)' 64.142 'MACROLIDES:(64.142)'
             64.143 'MISCELLANEOUS MACROLIDES:(64.143)'
             64.151 'AMINOPENICILLINS:(64.151)'
             64.152 'ANTIPSEUDOMONAL PENICILLINS:(64.152)'
             64.153 'BETA-LACTAMASE INHIBITORS:(64.153)'
             64.154 'NATURAL PENICILLINS:(64.154)'
             64.155 'PENICILLINASE RESISTANT PENICILLINS:(64.155)'
             67.011 'COUMARINS AND INDANEDIONES:(67.011)'
             67.012 'FACTOR XA INHIBITORS:(67.012)'
             67.013 'HEPARINS:(67.013)' 67.014 'THROMBIN INHIBITORS:(67.014)'
             67.021 'GLYCOPROTEIN PLATELET INHIBITORS:(67.021)'
             67.022 'PLATELET AGGREGATION INHIBITORS:(67.022)'
             68.061 'ANTICHOLINERGICS/ANTISPASMODICS:(68.061)'
             68.062 'CHLORIDE CHANNEL ACTIVATORS:(68.062)'
             68.063 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(68.063)'
             68.064 'SEROTONINERGIC NEUROENTERIC MODULATORS:(68.064)'
             70.021 'CORTICOTROPIN:(70.021)'
             70.022 'GLUCOCORTICOIDS:(70.022)'
             70.023 'MINERALOCORTICOIDS:(70.023)'
             70.029 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(70.029)'
             70.202 'ANDROGENS AND ANABOLIC STEROIDS:(70.202)'
             70.203 'CONTRACEPTIVES:(70.203)' 70.204 'ESTROGENS:(70.204)'
             70.205 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(70.205)'
             70.206 'GONADOTROPINS:(70.206)' 70.207 'PROGESTINS:(70.207)'
             70.208 'SEX HORMONE COMBINATIONS:(70.208)'
             70.209 'MISCELLANEOUS SEX HORMONES:(70.209)'
             71.021 'BACTERIAL VACCINES:(71.021)'
             71.022 'COLONY STIMULATING FACTORS:(71.022)'
             71.023 'INTERFERONS:(71.023)'
             71.025 'THERAPEUTIC VACCINES:(71.025)'
             71.026 'VACCINE COMBINATIONS:(71.026)'
             71.027 'VIRAL VACCINES:(71.027)'
             71.029 'OTHER IMMUNOSTIMULANTS:(71.029)'
             71.031 'CALCINEURIN INHIBITORS:(71.031)'
             71.032 'INTERLEUKIN INHIBITORS:(71.032)'
             71.033 'SELECTIVE IMMUNOSUPPRESSANTS:(71.033)'
             71.034 'TNF ALFA INHIBITORS:(71.034)'
             71.039 'OTHER IMMUNOSUPPRESSANTS:(71.039)'
             73.0101 'ALPHA-GLUCOSIDASE INHIBITORS:(73.0101)'
             73.0102 'AMYLIN ANALOGS:(73.0102)'
             73.0103 'ANTIDIABETIC COMBINATIONS:(73.0103)'
             73.0104 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(73.0104)'
             73.0105 'INCRETIN MIMETICS:(73.0105)'
             73.0106 'INSULIN:(73.0106)' 73.0107 'MEGLITINIDES:(73.0107)'
             73.0108 'BIGUANIDES:(73.0108)' 73.0109 'SULFONYLUREAS:(73.0109)'
             73.011 'THIAZOLIDINEDIONES:(73.011)'
             73.019 'MISCELLANEOUS ANTIDIABETIC AGENTS:(73.019)'
             73.031 'ANTIHYPERLIPIDEMIC COMBINATIONS:(73.031)'
             73.032 'BILE ACID SEQUESTRANTS:(73.032)'
             73.033 'CHOLESTEROL ABSORPTION INHIBITORS:(73.033)'
             73.034 'FIBRIC ACID DERIVATIVES:(73.034)'
             73.035 'HMG-COA REDUCTASE INHIBITORS:(73.035)'
             73.036 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(73.036)'
             73.051 'BISPHOSPHONATES:(73.051)'
             73.059 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(73.059)'
             77.011 'IONIC IODINATED CONTRAST MEDIA:(77.011)'
             77.012 'LYMPHATIC STAINING AGENTS:(77.012)'
             77.013 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(77.013)'
             77.014 'NON-IODINATED CONTRAST MEDIA:(77.014)'
             77.015 'NON-IONIC IODINATED CONTRAST MEDIA:(77.015)'
             77.016 'ULTRASOUND CONTRAST MEDIA:(77.016)'
             77.017 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(77.017)'
             77.019 'MISCELLANEOUS RADIOCONTRAST AGENTS:(77.019)'
             77.021 'CARDIAC STRESSING AGENTS:(77.021)'
             77.031 'DIAGNOSTIC RADIOPHARMACEUTICALS:(77.031)'
             77.032 'THERAPEUTIC RADIOPHARMACEUTICALS:(77.032)'
             77.033 'MISCELLANEOUS RADIOPHARMACEUTICALS:(77.033)'
             78.0301 'TOPICAL ACNE AGENTS:(78.0301)'
             78.0302 'TOPICAL ANESTHETICS:(78.0302)'
             78.0303 'TOPICAL ANTIBIOTICS:(78.0303)'
             78.0304 'TOPICAL ANTIFUNGALS:(78.0304)'
             78.0305 'TOPICAL ANTIHISTAMINES:(78.0305)'
             78.0306 'TOPICAL ANTI-INFECTIVES:(78.0306)'
             78.0307 'TOPICAL ANTIPSORIATICS:(78.0307)'
             78.0308 'TOPICAL ANTIVIRALS:(78.0308)'
             78.0309 'TOPICAL ASTRINGENTS:(78.0309)'
             78.031 'TOPICAL DEBRIDING AGENTS:(78.031)'
             78.0311 'TOPICAL DEPIGMENTING AGENTS:(78.0311)'
             78.0312 'TOPICAL EMOLLIENTS:(78.0312)'
             78.0313 'TOPICAL KERATOLYTICS:(78.0313)'
             78.0314 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(78.0314)'
             78.0315 'TOPICAL STEROIDS:(78.0315)'
             78.0316 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(78.0316)'
             78.0399 'MISCELLANEOUS TOPICAL AGENTS:(78.0399)'
             78.051 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(78.051)'
             78.053 'NASAL LUBRICANTS AND IRRIGATIONS:(78.053)'
             78.054 'NASAL STEROIDS:(78.054)'
             78.055 'MISCELLANEOUS NASAL PREPARATIONS:(78.055)'
             78.0602 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(78.0602)'
             78.061 'MYDRIATICS:(78.061)'
             78.062 'OPHTHALMIC ANESTHETICS:(78.062)'
             78.063 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(78.063)'
             78.064 'OPHTHALMIC ANTI-INFECTIVES:(78.064)'
             78.065 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(78.065)'
             78.066 'OPHTHALMIC DIAGNOSTIC AGENTS:(78.066)'
             78.067 'OPHTHALMIC GLAUCOMA AGENTS:(78.067)'
             78.068 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(78.068)'
             78.069 'OPHTHALMIC STEROIDS:(78.069)'
             78.0691 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(78.0691)'
             78.0692 'OPHTHALMIC SURGICAL AGENTS:(78.0692)'
             78.0693 'MISCELLANEOUS OPHTHALMIC AGENTS:(78.0693)'
             78.071 'CERUMENOLYTICS:(78.071)'
             78.072 'OTIC ANESTHETICS:(78.072)'
             78.073 'OTIC ANTI-INFECTIVES:(78.073)'
             78.074 'OTIC STEROIDS:(78.074)'
             78.075 'OTIC STEROIDS WITH ANTI-INFECTIVES:(78.075)'
             78.076 'MISCELLANEOUS OTIC AGENTS:(78.076)'
             78.091 'SPERMICIDES:(78.091)'
             78.092 'VAGINAL ANTI-INFECTIVES:(78.092)'
             78.093 'MISCELLANEOUS VAGINAL AGENTS:(78.093)' /
   SDLED_5_3 -7 'NOT APPLICABLE' 20.41 'NEFAZODONE:(20.41)'
             20.42 'TRAZODONE:(20.42)' 20.71 'DESVENLAFAXINE:(20.71)'
             20.72 'DULOXETINE:(20.72)' 20.73 'VENLAFAXINE:(20.73)'
             20.79 'SSNRI ANTIDEPRESSANTS NTA:(20.79)'
             21.01 'CITALOPRAM:(21.01)' 21.02 'FLUOXETINE:(21.02)'
             21.03 'FLUVOXAMINE:(21.03)' 21.04 'PAROXETINE:(21.04)'
             21.05 'SERTRALINE:(21.05)'
             21.09 'SSRI ANTIDEPRESSANTS NTA:(21.09)'
             21.51 'MAPROTILINE:(21.51)' 21.52 'MIRTAZAPINE:(21.52)'
             22.01 'AMITRIPTYLINE:(22.01)' 22.02 'DESIPRAMINE:(22.02)'
             22.03 'DOXEPIN:(22.03)' 22.04 'IMIPRAMINE:(22.04)'
             22.05 'NORTRIPTYLINE:(22.05)'
             22.06 'TRICYCLIC ANTIDEPRESSANTS-NOS:(22.06)'
             22.09 'TRICYCLIC ANTIDEPRESSANTS NTA:(22.09)'
             23.01 'BUPROPION:(23.01)' 23.06 'ANTIDEPRESSANTS-NOS:(23.06)'
             23.09 'MISCELLANEOUS ANTIDEPRESSANTS NTA:(23.09)'
             25.01 'CLOZAPINE:(25.01)' 25.02 'OLANZAPINE:(25.02)'
             25.03 'QUETIAPINE:(25.03)' 25.04 'RISPERIDONE:(25.04)'
             25.09 'ATYPICAL ANTIPSYCHOTICS NTA:(25.09)'
             26.01 'CHLORPROMAZINE:(26.01)' 26.02 'FLUPHENAZINE:(26.02)'
             26.03 'PERPHENAZINE:(26.03)' 26.04 'PROCHLORPERAZINE:(26.04)'
             26.05 'THIORIDAZINE:(26.05)' 26.06 'TRIFLUPROMAZINE:(26.06)'
             26.09 'PHENOTHIAZINE ANTIPSYCHOTICS NTA:(26.09)'
             27.01 'HALOPERIDOL:(27.01)' 27.02 'LITHIUM:(27.02)'
             27.09 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS NTA:(27.09)'
             36.75 'OPIATES/OPIOIDS, UNSPECIFIED:(36.75)'
             37.5 'NARCOTIC ANALGESICS:(37.5)'
             39.01 'IBUPROFEN/COMBINATIONS:(39.01)'
             39.02 'NAPROXEN/COMBINATIONS:(39.02)'
             39.03 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS NTA:(39.03)'
             40.501 'ASPIRIN/COMBINATIONS:(40.501)'
             40.502 'SALICYLATES-NOS:(40.502)'
             40.503 'SALICYLATES/COMBINATIONS NTA:(40.503)'
             41.501 'ACETAMINOPHEN/COMBINATIONS:(41.501)'
             41.502 'TRAMADOL/COMBINATIONS:(41.502)'
             41.505 'ANALGESICS-NOS:(41.505)'
             41.506 'MISCELLANEOUS ANALGESIC/COMBINATIONS NTA:(41.506)'
             44.041 'TOPIRAMATE:(44.041)'
           44.049 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS NTA:(44.049)'
             44.051 'CARBAMAZEPINE:(44.051)' 44.052 'OXCARBAZEPINE:(44.052)'
             44.053 'RUFINAMIDE:(44.053)' 44.061 'DIVALPROEX SODIUM:(44.061)'
             44.062 'VALPROIC ACID:(44.062)' 44.071 'GABAPENTIN:(44.071)'
             44.079 'GAMMA-AMINOBUTYRIC ACID ANALOGS NTA:(44.079)'
             44.091 'PHENYTOIN:(44.091)'
             44.099 'HYDANTOIN ANTICONVULSANTS NTA:(44.099)'
             46.011 'BENZTROPINE:(46.011)'
             46.019 'ANTICHOLINERGIC ANTIPARKINSON AGENTS NTA:(46.019)'
             46.3101 'PHENOBARBITAL:(46.3101)'
             46.3102 'BARBITURATES-NOS:(46.3102)'
             46.3109 'BARBITURATES NTA:(46.3109)'
             46.3201 'ALPRAZOLAM:(46.3201)'
             46.3202 'CHLORDIAZEPOXIDE:(46.3202)'
             46.3203 'CLONAZEPAM:(46.3203)' 46.3204 'CLORAZEPATE:(46.3204)'
             46.3205 'DIAZEPAM:(46.3205)' 46.3206 'FLURAZEPAM:(46.3206)'
             46.3207 'LORAZEPAM:(46.3207)' 46.3208 'OXAZEPAM:(46.3208)'
             46.3209 'TEMAZEPAM:(46.3209)' 46.321 'TRIAZOLAM:(46.321)'
             46.3211 'BENZODIAZEPINES-NOS:(46.3211)'
             46.3219 'BENZODIAZEPINES NTA:(46.3219)'
             46.3301 'BUSPIRONE:(46.3301)'
             46.3302 'CHLORAL HYDRATE:(46.3302)'
             46.3303 'DIPHENHYDRAMINE:(46.3303)'
             46.3304 'DOXYLAMINE:(46.3304)' 46.3305 'HYDROXYZINE:(46.3305)'
             46.3306 'ZOLPIDEM:(46.3306)'
             46.3307 'ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS:(46.3307)'
          46.3309 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS NTA:(46.3309)'
             46.5091 'CAFFEINE/MULTIVITAMIN:(46.5091)'
             46.5092 'OTHER CNS STIMULANTS NTA:(46.5092)'
             48.031 'CARISOPRODOL:(48.031)' 48.032 'CHLORZOXAZONE:(48.032)'
             48.033 'CYCLOBENZAPRINE:(48.033)' 48.034 'METAXALONE:(48.034)'
             48.035 'METHOCARBAMOL:(48.035)' 48.036 'TIZANIDINE:(48.036)'
             48.039 'SKELETAL MUSCLE RELAXANTS NTA:(48.039)'
             56.052 'INHALED CORTICOSTEROIDS:(56.052)'
             56.053 'MAST CELL STABILIZERS:(56.053)'
             56.054 'MUCOLYTICS:(56.054)'
             56.059 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(56.059)'
             59.011 'ATENOLOL:(59.011)'
             59.019 'CARDIOSELECTIVE BETA BLOCKERS NTA:(59.019)'
             59.021 'PROPRANOLOL:(59.021)'
             59.029 'NON-CARDIOSELECTIVE BETA BLOCKERS NTA:(59.029)'
             62.081 'GROUP I ANTIARRHYTHMICS:(62.081)'
             62.083 'GROUP III ANTIARRHYTHMICS:(62.083)'
             62.085 'GROUP V ANTIARRHYTHMICS:(62.085)'
             62.089 'ANTIARRHYTHMIC AGENTS NTA:(62.089)'
             62.151 'EPHEDRINE:(62.151)' 62.159 'VASOPRESSORS NTA:(62.159)' /
   SDLED_6_3 -7 'NOT APPLICABLE:(-7)'
             37.5005 'BUPRENORPHINE/COMBINATIONS:(37.5005)'
             37.501 'CODEINE/COMBINATIONS:(37.501)'
             37.502 'DIHYDROCODEINE/COMBINATIONS:(37.502)'
             37.503 'FENTANYL/COMBINATIONS:(37.503)'
             37.504 'HYDROCODONE/COMBINATIONS:(37.504)'
             37.5045 'HYDROMORPHONE/COMBINATIONS:(37.5045)'
             37.505 'MEPERIDINE/COMBINATIONS:(37.505)'
             37.506 'METHADONE:(37.506)'
             37.507 'MORPHINE/COMBINATIONS:(37.507)'
             37.508 'OPIUM/COMBINATIONS:(37.508)'
             37.509 'OXYCODONE/COMBINATIONS:(37.509)'
             37.51 'PENTAZOCINE/COMBINATIONS:(37.51)'
             37.511 'PHENACETIN/COMBINATIONS:(37.511)'
             37.512 'PROPOXYPHENE/COMBINATIONS:(37.512)'
             37.514 'ALL OTHER NARCOTIC ANALGESICS/COMBINATIONS NTA:(37.514)'
             41.503 'TRAMADOL:(41.503)'
             41.504 'ACETAMINOPHEN-TRAMADOL:(41.504)' /
   DRUGID_4  -7 'NOT APPLICABLE' 1 'D00001 ACYCLOVIR' 2 'D00002 AMIODARONE'
             3 'D00003 AMPICILLIN' 4 'D00004 ATENOLOL' 5 'D00006 CAPTOPRIL'
             6 'D00007 CEFAZOLIN' 7 'D00008 CEFOTAXIME'
             8 'D00009 CEFTAZIDIME' 9 'D00010 CEFTIZOXIME'
             10 'D00011 CIPROFLOXACIN' 11 'D00012 CODEINE'
             12 'D00013 ENALAPRIL' 13 'D00014 GENTAMICIN'
             14 'D00015 IBUPROFEN' 15 'D00016 LABETALOL'
             16 'D00017 MEPERIDINE' 17 'D00018 NADOLOL' 18 'D00019 NAPROXEN'
             19 'D00020 QUINIDINE' 20 'D00021 RANITIDINE'
             21 'D00022 WARFARIN' 22 'D00023 ALLOPURINOL'
             23 'D00024 AZATHIOPRINE' 24 'D00025 CHLORAMPHENICOL'
             25 'D00026 FENOPROFEN' 26 'D00027 HALOPERIDOL'
             27 'D00028 KETOPROFEN' 28 'D00029 NAFCILLIN'
             29 'D00030 PENTAMIDINE' 30 'D00031 PROBENECID'
             31 'D00032 PROPRANOLOL' 32 'D00033 SULINDAC'
             33 'D00034 ZIDOVUDINE' 34 'D00035 CHLOROQUINE'
             35 'D00036 CYCLOPHOSPHAMIDE' 36 'D00037 DOXYCYCLINE'
             37 'D00038 FLUCYTOSINE' 38 'D00039 INDOMETHACIN'
             39 'D00040 OXAZEPAM' 40 'D00041 TETRACYCLINE'
             41 'D00042 CHLORPROPAMIDE' 42 'D00043 CLINDAMYCIN'
             43 'D00044 CLONIDINE' 44 'D00045 DILTIAZEM'
             45 'D00046 ERYTHROMYCIN' 46 'D00047 RIFAMPIN'
             47 'D00048 VERAPAMIL' 48 'D00049 ACETAMINOPHEN'
             49 'D00050 METHADONE' 50 'D00051 NIFEDIPINE'
             51 'D00052 CEFTRIAXONE' 52 'D00053 CEPHRADINE'
             53 'D00054 TOLMETIN' 54 'D00055 CEFOTETAN'
             55 'D00056 CEFUROXIME' 56 'D00057 PIPERACILLIN'
             57 'D00058 CARBAMAZEPINE' 58 'D00059 LIDOCAINE'
             59 'D00060 METHOTREXATE' 60 'D00061 LITHIUM'
             61 'D00062 CEFAMANDOLE' 62 'D00064 CHLORPROMAZINE'
             63 'D00065 FOSCARNET' 64 'D00066 GANCICLOVIR'
             65 'D00067 AZTREONAM' 66 'D00068 ETHAMBUTOL'
             67 'D00069 TOBRAMYCIN' 68 'D00070 FUROSEMIDE'
             69 'D00071 FLUCONAZOLE' 70 'D00072 CEFIXIME'
             71 'D00073 CEFPROZIL' 72 'D00074 CEFOPERAZONE'
             73 'D00075 PROCAINAMIDE' 74 'D00077 AMPHOTERICIN B'
             75 'D00078 DIDANOSINE' 76 'D00079 CYCLOSPORINE'
             77 'D00080 CEFADROXIL' 78 'D00081 CEFACLOR'
             79 'D00082 IMIPENEM-CILASTATIN' 80 'D00083 VALPROIC ACID'
             81 'D00084 PREDNISOLONE' 82 'D00085 RIBAVIRIN'
             83 'D00086 AMANTADINE' 84 'D00087 AMIKACIN'
             85 'D00088 AMOXICILLIN' 86 'D00089 AMOXICILLIN-CLAVULANATE'
             87 'D00090 AMPICILLIN-SULBACTAM' 88 'D00091 AZITHROMYCIN'
             89 'D00092 CARBENICILLIN' 90 'D00093 CEFMETAZOLE'
             91 'D00094 CEFOXITIN' 92 'D00095 CEFPODOXIME'
             93 'D00096 CEPHALEXIN' 94 'D00097 CLARITHROMYCIN'
             95 'D00098 DAPSONE' 96 'D00099 ENOXACIN'
             97 'D00100 GRISEOFULVIN' 98 'D00101 ISONIAZID'
             99 'D00102 ITRACONAZOLE' 100 'D00103 KETOCONAZOLE'
             101 'D00104 LOMEFLOXACIN' 102 'D00105 LORACARBEF'
             103 'D00106 METHENAMINE' 104 'D00107 METHICILLIN'
             105 'D00108 METRONIDAZOLE' 106 'D00109 MEZLOCILLIN'
             107 'D00110 MINOCYCLINE' 108 'D00112 NITROFURANTOIN'
             109 'D00113 NORFLOXACIN' 110 'D00114 OFLOXACIN'
             111 'D00115 OXACILLIN' 112 'D00116 PENICILLIN'
             113 'D00117 PYRAZINAMIDE' 114 'D00118 SULFADIAZINE'
             115 'D00119 SULFAMETHOXAZOLE' 116 'D00120 SULFISOXAZOLE'
             117 'D00121 TICARCILLIN' 118 'D00122 TICARCILLIN-CLAVULANATE'
             119 'D00123 TRIMETHOPRIM'
             120 'D00124 SULFAMETHOXAZOLE-TRIMETHOPRIM'
             121 'D00125 VANCOMYCIN' 122 'D00128 ACEBUTOLOL'
             123 'D00129 DIAZOXIDE' 124 'D00132 HYDRALAZINE'
             125 'D00133 METHYLDOPA' 126 'D00134 METOPROLOL'
             127 'D00135 MINOXIDIL' 128 'D00137 PINDOLOL'
             129 'D00138 PRAZOSIN' 130 'D00139 TIMOLOL'
             131 'D00140 CIMETIDINE' 132 'D00141 FAMOTIDINE'
             133 'D00142 THEOPHYLLINE' 134 'D00143 PHENYTOIN'
             135 'D00144 NORTRIPTYLINE' 136 'D00145 DESIPRAMINE'
             137 'D00146 AMITRIPTYLINE' 138 'D00147 CHLORAL HYDRATE'
             139 'D00148 DIAZEPAM' 140 'D00149 LORAZEPAM'
             141 'D00150 COLCHICINE' 142 'D00152 CLOXACILLIN'
             143 'D00153 DICLOXACILLIN' 144 'D00154 MEBENDAZOLE'
             145 'D00155 MICONAZOLE' 146 'D00157 NALIDIXIC ACID'
             147 'D00158 QUINACRINE' 148 'D00159 STREPTOMYCIN'
             149 'D00161 ACETAZOLAMIDE' 150 'D00164 ADENOSINE'
             151 'D00167 ALFENTANIL' 152 'D00168 ALPRAZOLAM'
             153 'D00169 AMILORIDE' 154 'D00170 ASPIRIN'
             155 'D00171 AMOBARBITAL' 156 'D00172 INAMRINONE'
             157 'D00173 ATRACURIUM' 158 'D00174 ATROPINE'
             159 'D00175 BENZTROPINE' 160 'D00176 BETAXOLOL'
             161 'D00177 BLEOMYCIN' 162 'D00178 BROMOCRIPTINE'
             163 'D00179 BUMETANIDE' 164 'D00180 BUPIVACAINE'
             165 'D00181 BUPROPION' 166 'D00182 BUSPIRONE'
             167 'D00183 BUSULFAN' 168 'D00184 CARBIDOPA'
             169 'D00185 CARBOPLATIN' 170 'D00186 CEPHALOTHIN'
             171 'D00187 CEPHAPIRIN' 172 'D00188 CHLORAMBUCIL'
             173 'D00189 CHLORDIAZEPOXIDE' 174 'D00190 CHLOROTHIAZIDE'
             175 'D00191 CHLORPHENIRAMINE' 176 'D00192 CHLORTHALIDONE'
             177 'D00193 CHOLESTYRAMINE' 178 'D00195 CISPLATIN'
             179 'D00197 CLONAZEPAM' 180 'D00198 CLORAZEPATE'
             181 'D00199 CLOZAPINE' 182 'D00200 CROMOLYN'
             183 'D00201 CYTARABINE' 184 'D00202 DACARBAZINE'
             185 'D00203 DACTINOMYCIN' 186 'D00204 DANAZOL'
             187 'D00205 DAUNORUBICIN' 188 'D00206 DEXAMETHASONE'
             189 'D00207 DEXTROMETHORPHAN' 190 'D00208 DIFLUNISAL'
             191 'D00209 DIGITOXIN' 192 'D00210 DIGOXIN'
             193 'D00211 DIHYDROERGOTAMINE' 194 'D00212 DIPHENHYDRAMINE'
             195 'D00213 DIPYRIDAMOLE' 196 'D00214 DISOPYRAMIDE'
             197 'D00215 DOBUTAMINE' 198 'D00216 DOPAMINE'
             199 'D00217 DOXEPIN' 200 'D00218 DOXORUBICIN'
             201 'D00219 DROPERIDOL' 202 'D00220 EDROPHONIUM'
             203 'D00222 ERGOTAMINE' 204 'D00223 EPOETIN ALFA'
             205 'D00224 ESMOLOL' 206 'D00226 ETHCHLORVYNOL'
             207 'D00227 ETHOSUXIMIDE' 208 'D00229 ETHINYL ESTRADIOL'
             209 'D00230 ETOPOSIDE' 210 'D00231 FELODIPINE'
             211 'D00233 FENTANYL' 212 'D00234 FLECAINIDE'
             213 'D00235 FLUOROURACIL' 214 'D00236 FLUOXETINE'
             215 'D00237 FLUPHENAZINE' 216 'D00238 FLURAZEPAM'
             217 'D00239 FLURBIPROFEN' 218 'D00240 FLUTAMIDE'
             219 'D00241 FOLIC ACID' 220 'D00242 FOSINOPRIL'
             221 'D00243 FURAZOLIDONE' 222 'D00245 GEMFIBROZIL'
             223 'D00246 GLIPIZIDE' 224 'D00248 GLYBURIDE'
             225 'D00250 GOLD SODIUM THIOMALATE' 226 'D00252 HEPARIN'
             227 'D00253 HYDROCHLOROTHIAZIDE' 228 'D00254 HYDROCORTISONE'
             229 'D00255 HYDROMORPHONE' 230 'D00256 IDARUBICIN'
             231 'D00257 IFOSFAMIDE' 232 'D00259 IMIPRAMINE'
             233 'D00260 INDAPAMIDE' 234 'D00262 INSULIN'
             235 'D00265 IPRATROPIUM' 236 'D00267 ISOFLURANE'
             237 'D00268 ISOSORBIDE DINITRATE'
             238 'D00269 ISOSORBIDE MONONITRATE' 239 'D00270 ISRADIPINE'
             240 'D00271 KANAMYCIN' 241 'D00272 KETAMINE'
             242 'D00273 KETOROLAC' 243 'D00275 LEUCOVORIN'
             244 'D00276 LEVAMISOLE' 245 'D00277 LEVODOPA'
             246 'D00278 LEVOTHYROXINE' 247 'D00279 LINCOMYCIN'
             248 'D00280 LOVASTATIN' 249 'D00282 MANNITOL'
             250 'D00283 MECLOFENAMATE' 251 'D00284 MEDROXYPROGESTERONE'
             252 'D00285 MEFENAMIC ACID' 253 'D00286 MEFLOQUINE'
             254 'D00287 MELPHALAN' 255 'D00288 MEPROBAMATE'
             256 'D00289 MERCAPTOPURINE' 257 'D00290 METHIMAZOLE'
             258 'D00292 METHSUXIMIDE' 259 'D00293 METHYLPREDNISOLONE'
             260 'D00295 METHYLTESTOSTERONE'
             261 'D00297 METIPRANOLOL OPHTHALMIC' 262 'D00298 METOCLOPRAMIDE'
             263 'D00299 METOLAZONE' 264 'D00300 MEXILETINE'
             265 'D00301 MIDAZOLAM' 266 'D00302 MILRINONE'
             267 'D00303 MISOPROSTOL' 268 'D00305 MITOMYCIN'
             269 'D00306 MITOXANTRONE' 270 'D00307 MORICIZINE'
             271 'D00308 MORPHINE' 272 'D00310 NABUMETONE'
             273 'D00311 NALOXONE' 274 'D00312 NEOMYCIN'
             275 'D00313 NEOSTIGMINE' 276 'D00314 NIACIN'
             277 'D00315 NICARDIPINE' 278 'D00316 NICOTINE'
             279 'D00318 NIMODIPINE' 280 'D00321 NITROGLYCERIN'
             281 'D00322 NIZATIDINE' 282 'D00323 NOREPINEPHRINE'
             283 'D00325 OMEPRAZOLE' 284 'D00328 OXYBUTYNIN'
             285 'D00329 OXYCODONE' 286 'D00330 PANCURONIUM'
             287 'D00331 PARAAMINOBENZOIC ACID' 288 'D00332 PENBUTOLOL'
             289 'D00333 PENICILLAMINE' 290 'D00334 PENTAZOCINE'
             291 'D00335 PENTOBARBITAL' 292 'D00336 PENTOXIFYLLINE'
             293 'D00337 PHENAZOPYRIDINE' 294 'D00340 PHENOBARBITAL'
             295 'D00341 PHENYLBUTAZONE' 296 'D00342 PHYSOSTIGMINE'
             297 'D00343 PIROXICAM' 298 'D00344 POLYMYXIN B SULFATE'
             299 'D00345 POTASSIUM CHLORIDE'
             300 'D00346 POVIDONE IODINE TOPICAL' 301 'D00348 PRAVASTATIN'
             302 'D00349 PRAZIQUANTEL' 303 'D00350 PREDNISONE'
             304 'D00351 PRIMAQUINE' 305 'D00352 PRIMIDONE'
             306 'D00353 PROBUCOL' 307 'D00354 PROCARBAZINE'
             308 'D00355 PROCHLORPERAZINE' 309 'D00356 PROMAZINE'
             310 'D00358 PROPAFENONE' 311 'D00359 PROPANTHELINE'
             312 'D00360 PROPOXYPHENE' 313 'D00361 PROPYLTHIOURACIL'
             314 'D00362 PROTAMINE' 315 'D00363 PYRIDOSTIGMINE'
             316 'D00364 PYRIMETHAMINE' 317 'D00365 QUINAPRIL'
             318 'D00366 QUININE' 319 'D00367 RESERPINE'
             320 'D00368 SECOBARBITAL' 321 'D00370 OCTREOTIDE'
             322 'D00371 SOTALOL' 323 'D00373 SPIRONOLACTONE'
             324 'D00374 STREPTOKINASE' 325 'D00375 STREPTOZOCIN'
             326 'D00376 SUCCINYLCHOLINE' 327 'D00377 SUCRALFATE'
             328 'D00378 SUFENTANIL' 329 'D00379 SULFASALAZINE'
             330 'D00381 TAMOXIFEN' 331 'D00384 TEMAZEPAM'
             332 'D00386 TERAZOSIN' 333 'D00387 TERFENADINE'
             334 'D00388 THIOPENTAL' 335 'D00389 THIORIDAZINE'
             336 'D00391 THIOTHIXENE' 337 'D00393 TOLAZAMIDE'
             338 'D00394 TOLBUTAMIDE' 339 'D00395 TRAZODONE'
             340 'D00396 TRIAMTERENE' 341 'D00397 TRIAZOLAM'
             342 'D00398 VASOPRESSIN' 343 'D00399 VECURONIUM'
             344 'D00400 VINBLASTINE' 345 'D00401 VINCRISTINE'
             346 'D00402 VITAMIN A' 347 'D00405 VITAMIN E'
             348 'D00409 RIBOFLAVIN' 349 'D00412 PYRIDOXINE'
             350 'D00413 CYANOCOBALAMIN' 351 'D00417 BIOFLAVONOIDS'
             352 'D00425 CALCIUM CARBONATE' 353 'D00426 ASCORBIC ACID'
             354 'D00427 POTASSIUM PHOSPHATE-SODIUM PHOSPHATE'
             355 'D00428 FLUORIDE' 356 'D00438 SODIUM CHLORIDE'
             357 'D00439 CITRIC ACID-POTASSIUM CITRATE'
             358 'D00440 SODIUM BICARBONATE' 359 'D00468 MAGNESIUM SULFATE'
             360 'D00471 SODIUM ACETATE' 361 'D00472 TROMETHAMINE'
             362 'D00475 SODIUM PHOSPHATE' 363 'D00476 AMMONIUM CHLORIDE'
             364 'D00481 AMMONIUM MOLYBDATE TETRAHYDRATE'
             365 'D00484 SELENIUM' 366 'D00485 IODINE TOPICAL'
             367 'D00487 GLUTAMIC ACID' 368 'D00488 LYSINE'
             369 'D00491 LEVOCARNITINE' 370 'D00496 INOSITOL'
             371 'D00497 OMEGA-3 POLYUNSATURATED FATTY ACIDS'
             372 'D00512 FILGRASTIM' 373 'D00513 SARGRAMOSTIM'
             374 'D00514 TICLOPIDINE' 375 'D00519 ANISINDIONE'
             376 'D00521 ALTEPLASE' 377 'D00523 UROKINASE'
             378 'D00524 ANTITHROMBIN III'
             379 'D00525 ANTIHEMOPHILIC FACTOR (OBSOLETE)'
             380 'D00526 ANTI-INHIBITOR COAGULANT COMPLEX'
             381 'D00527 FACTOR IX COMPLEX (OBSOLETE)'
             382 'D00528 AMINOCAPROIC ACID' 383 'D00529 TRANEXAMIC ACID'
             384 'D00534 ESTRONE' 385 'D00537 ESTRADIOL'
             386 'D00541 CONJUGATED ESTROGENS'
             387 'D00542 ESTERIFIED ESTROGENS' 388 'D00543 ESTROPIPATE'
             389 'D00546 DIETHYLSTILBESTROL' 390 'D00550 PROGESTERONE'
             391 'D00554 HYDROXYPROGESTERONE' 392 'D00555 NORETHINDRONE'
             393 'D00557 LEVONORGESTREL' 394 'D00558 TESTOSTERONE'
             395 'D00562 FLUOXYMESTERONE' 396 'D00563 FINASTERIDE'
             397 'D00565 STANOZOLOL' 398 'D00566 OXANDROLONE'
             399 'D00568 NANDROLONE' 400 'D00569 CLOMIPHENE'
             401 'D00570 UROFOLLITROPIN' 402 'D00571 MENOTROPINS'
             403 'D00572 CHORIONIC GONADOTROPIN (HCG)' 404 'D00574 NAFARELIN'
             405 'D00575 HISTRELIN' 406 'D00576 SOMATREM'
             407 'D00577 SOMATROPIN' 408 'D00578 ARGININE'
             409 'D00583 DESMOPRESSIN' 410 'D00584 OXYTOCIN'
             411 'D00586 ERGONOVINE' 412 'D00587 METHYLERGONOVINE'
             413 'D00589 DINOPROSTONE TOPICAL' 414 'D00592 METYRAPONE'
             415 'D00593 GLUCAGON' 416 'D00595 GLUCOSE'
             417 'D00598 CALCITONIN' 418 'D00599 ETIDRONATE'
             419 'D00601 PAMIDRONATE' 420 'D00602 GALLIUM NITRATE'
             421 'D00603 RITODRINE' 422 'D00604 CORTICOTROPIN'
             423 'D00607 COSYNTROPIN' 424 'D00608 FLUDROCORTISONE'
             425 'D00609 CORTISONE' 426 'D00620 TRIAMCINOLONE'
             427 'D00626 DEXAMETHASONE TOPICAL' 428 'D00628 BETAMETHASONE'
             429 'D00640 METHAZOLAMIDE' 430 'D00641 BENDROFLUMETHIAZIDE'
             431 'D00643 METHYCLOTHIAZIDE' 432 'D00644 BENZTHIAZIDE'
             433 'D00645 HYDROFLUMETHIAZIDE' 434 'D00646 TRICHLORMETHIAZIDE'
             435 'D00647 POLYTHIAZIDE' 436 'D00649 ETHACRYNIC ACID'
             437 'D00651 UREA TOPICAL' 438 'D00652 GLYCERIN'
             439 'D00653 ISOSORBIDE' 440 'D00655 THYROID DESICCATED'
             441 'D00658 LIOTHYRONINE' 442 'D00659 LIOTRIX'
             443 'D00666 AMYL NITRITE' 444 'D00683 LIDOCAINE TOPICAL'
             445 'D00688 BEPRIDIL' 446 'D00689 AMLODIPINE'
             447 'D00693 ISOXSUPRINE' 448 'D00695 PAPAVERINE'
             449 'D00696 ETHAVERINE' 450 'D00697 ISOPROTERENOL'
             451 'D00699 EPINEPHRINE' 452 'D00700 EPHEDRINE'
             453 'D00703 METHOXAMINE' 454 'D00704 PHENYLEPHRINE'
             455 'D00708 CARTEOLOL' 456 'D00709 BISOPROLOL'
             457 'D00717 GUANFACINE' 458 'D00726 DOXAZOSIN'
             459 'D00728 RAMIPRIL' 460 'D00730 BENAZEPRIL'
             461 'D00732 LISINOPRIL' 462 'D00733 PHENTOLAMINE'
             463 'D00734 PHENOXYBENZAMINE' 464 'D00735 METYROSINE'
             465 'D00739 MECAMYLAMINE'
             466 'D00743 SODIUM POLYSTYRENE SULFONATE'
             467 'D00744 COLESTIPOL' 468 'D00746 SIMVASTATIN'
             469 'D00747 DEXTROTHYROXINE SODIUM' 470 'D00749 ALBUTEROL'
             471 'D00750 METAPROTERENOL' 472 'D00752 TERBUTALINE'
             473 'D00755 PIRBUTEROL' 474 'D00758 AMINOPHYLLINE'
             475 'D00759 DYPHYLLINE' 476 'D00760 BECLOMETHASONE'
             477 'D00761 FLUNISOLIDE' 478 'D00762 ACETYLCYSTEINE'
             479 'D00765 CROMOLYN OPHTHALMIC'
             480 'D00767 PHENYLPROPANOLAMINE' 481 'D00769 PSEUDOEPHEDRINE'
             482 'D00771 NAPHAZOLINE OPHTHALMIC'
             483 'D00772 OXYMETAZOLINE NASAL'
             484 'D00773 TETRAHYDROZOLINE OPHTHALMIC'
             485 'D00774 XYLOMETAZOLINE NASAL'
             486 'D00775 ALPHA 1-PROTEINASE INHIBITOR'
             487 'D00780 CLEMASTINE' 488 'D00782 PYRILAMINE'
             489 'D00784 DEXCHLORPHENIRAMINE' 490 'D00785 BROMPHENIRAMINE'
             491 'D00786 TRIPROLIDINE' 492 'D00787 PROMETHAZINE'
             493 'D00788 TRIMEPRAZINE' 494 'D00789 METHDILAZINE'
             495 'D00790 CYPROHEPTADINE' 496 'D00791 AZATADINE'
             497 'D00793 PHENINDAMINE' 498 'D00796 BENZONATATE'
             499 'D00797 GUAIFENESIN' 500 'D00800 POTASSIUM IODIDE'
             501 'D00801 CAFFEINE' 502 'D00802 DOXAPRAM'
             503 'D00803 AMPHETAMINE' 504 'D00804 DEXTROAMPHETAMINE'
             505 'D00805 METHAMPHETAMINE' 506 'D00806 PHENTERMINE'
             507 'D00807 BENZPHETAMINE' 508 'D00809 PHENDIMETRAZINE'
             509 'D00810 DIETHYLPROPION' 510 'D00811 MAZINDOL'
             511 'D00812 FENFLURAMINE' 512 'D00813 BENZOCAINE TOPICAL'
             513 'D00814 METHOTRIMEPRAZINE' 514 'D00817 HYDROXYCHLOROQUINE'
             515 'D00824 OPIUM' 516 'D00825 LEVORPHANOL'
             517 'D00833 OXYMORPHONE' 518 'D00838 BUTORPHANOL'
             519 'D00839 NALBUPHINE' 520 'D00840 BUPRENORPHINE'
             521 'D00842 SALSALATE' 522 'D00846 MAGNESIUM SALICYLATE'
             523 'D00848 DICLOFENAC' 524 'D00851 ETODOLAC'
             525 'D00853 OXAPROZIN' 526 'D00855 PERPHENAZINE'
             527 'D00857 THIETHYLPERAZINE' 528 'D00858 CYCLIZINE'
             529 'D00859 MECLIZINE' 530 'D00861 DIMENHYDRINATE'
             531 'D00862 TRIMETHOBENZAMIDE' 532 'D00866 DRONABINOL'
             533 'D00867 ONDANSETRON' 534 'D00873 TRIMIPRAMINE'
             535 'D00874 AMOXAPINE' 536 'D00875 PROTRIPTYLINE'
             537 'D00876 CLOMIPRAMINE' 538 'D00877 MAPROTILINE'
             539 'D00880 SERTRALINE' 540 'D00882 ISOCARBOXAZID'
             541 'D00883 PHENELZINE' 542 'D00884 TRANYLCYPROMINE'
             543 'D00889 MESORIDAZINE' 544 'D00890 TRIFLUOPERAZINE'
             545 'D00896 MOLINDONE' 546 'D00897 LOXAPINE'
             547 'D00898 PIMOZIDE' 548 'D00900 METHYLPHENIDATE'
             549 'D00901 PEMOLINE' 550 'D00902 ERGOLOID MESYLATES'
             551 'D00907 HYDROXYZINE' 552 'D00909 CHLORMEZANONE'
             553 'D00910 ZOLPIDEM' 554 'D00911 PARALDEHYDE'
             555 'D00912 ACETYLCARBROMAL' 556 'D00915 ESTAZOLAM'
             557 'D00917 QUAZEPAM' 558 'D00919 MEPHOBARBITAL'
             559 'D00923 BUTABARBITAL' 560 'D00929 METHOHEXITAL'
             561 'D00931 ETOMIDATE' 562 'D00933 PROPOFOL'
             563 'D00934 NITROUS OXIDE' 564 'D00942 ETHOTOIN'
             565 'D00943 PHENSUXIMIDE' 566 'D00944 PARAMETHADIONE'
             567 'D00960 CARISOPRODOL' 568 'D00962 CHLORZOXAZONE'
             569 'D00963 CYCLOBENZAPRINE' 570 'D00964 METAXALONE'
             571 'D00965 METHOCARBAMOL' 572 'D00966 ORPHENADRINE'
             573 'D00967 BACLOFEN' 574 'D00968 DANTROLENE'
             575 'D00969 PROCYCLIDINE' 576 'D00970 TRIHEXYPHENIDYL'
             577 'D00972 BIPERIDEN' 578 'D00976 SELEGILINE'
             579 'D00977 PERGOLIDE' 580 'D00978 ALUMINUM HYDROXIDE'
             581 'D00980 DIHYDROXYALUMINUM SODIUM CARBONATE'
             582 'D00982 MAGNESIUM HYDROXIDE' 583 'D00984 MAGALDRATE'
             584 'D00985 HYOSCYAMINE' 585 'D00986 SCOPOLAMINE'
             586 'D00988 BELLADONNA' 587 'D00989 METHSCOPOLAMINE'
             588 'D00991 CLIDINIUM' 589 'D00992 GLYCOPYRROLATE'
             590 'D00999 DICYCLOMINE' 591 'D01002 PANCRELIPASE'
             592 'D01003 PANCREATIN' 593 'D01005 URSODIOL'
             594 'D01008 MAGNESIUM CITRATE' 595 'D01009 SODIUM BIPHOSPHATE'
             596 'D01010 CASCARA SAGRADA' 597 'D01012 PHENOLPHTHALEIN'
             598 'D01013 SENNA' 599 'D01014 CASTOR OIL'
             600 'D01015 BISACODYL' 601 'D01017 POLYCARBOPHIL'
             602 'D01018 PSYLLIUM' 603 'D01019 MINERAL OIL'
             604 'D01021 DOCUSATE'
             605 'D01023 POLYETHYLENE GLYCOL 3350 WITH ELECTROLYTES'
             606 'D01024 LACTULOSE' 607 'D01025 LOPERAMIDE'
             608 'D01026 BISMUTH SUBSALICYLATE' 609 'D01027 SIMETHICONE'
             610 'D01028 CHARCOAL' 611 'D01030 DEHYDROCHOLIC ACID'
             612 'D01031 MESALAMINE' 613 'D01032 OLSALAZINE'
             614 'D01068 DEMECLOCYCLINE' 615 'D01070 OXYTETRACYCLINE'
             616 'D01090 SULFAMETHIZOLE' 617 'D01097 RIFABUTIN'
             618 'D01100 ETHIONAMIDE' 619 'D01101 CYCLOSERINE'
             620 'D01104 PAROMOMYCIN' 621 'D01105 IODOQUINOL'
             622 'D01112 COLISTIN SULFATE OTIC' 623 'D01113 COLISTIMETHATE'
             624 'D01115 BACITRACIN' 625 'D01120 ATOVAQUONE'
             626 'D01121 CLOFAZIMINE' 627 'D01123 PYRANTEL'
             628 'D01124 PIPERAZINE' 629 'D01128 METHYLENE BLUE'
             630 'D01129 CINOXACIN' 631 'D01133 IMMUNE GLOBULIN INTRAVENOUS'
             632 'D01135 IMMUNE GLOBULIN INTRAMUSCULAR'
             633 'D01136 HEPATITIS B IMMUNE GLOBULIN'
             634 'D01138 VARICELLA ZOSTER IMMUNE GLOBULIN'
             635 'D01139 RHO (D) IMMUNE GLOBULIN'
             636 'D01141 LYMPHOCYTE IMMUNE GLOBULIN, ANTI-THY (OBS)'
             637 'D01142 DIPHTHERIA ANTITOXIN'
             638 'D01144 ANTIVENIN (CROTALIDAE) POLYVALENT'
             639 'D01146 ANTIVENIN (BLACK WIDOW SPIDER)'
             640 'D01147 RABIES VACCINE (OBSOLETE)'
             641 'D01148 RABIES IMMUNE GLOBULIN, HUMAN' 642 'D01150 BCG'
             643 'D01152 STAPHAGE LYSATE (SPL)'
             644 'D01153 MENINGOCOCCAL POLYSACCHARIDE VACCINE'
             645 'D01156 TYPHOID VACCINE, INACTIVATED'
             646 'D01158 HAEMOPHILUS B CONJUGATE VACCINE (OBSOLETE)'
             647 'D01159 MEASLES VIRUS VACCINE'
             648 'D01160 RUBELLA VIRUS VACCINE'
             649 'D01161 MUMPS VIRUS VACCINE'
             650 'D01162 POLIOVIRUS VACCINE, LIVE, TRIVALENT'
             651 'D01163 POLIOVIRUS VACCINE, INACTIVATED'
             652 'D01164 INFLUENZA VIRUS VACCINE, INACTIVATED'
             653 'D01165 YELLOW FEVER VACCINE'
             654 'D01166 HEPATITIS B VACCINE (OBSOLETE)'
             655 'D01168 TETANUS TOXOID'
             656 'D01171 TUBERCULIN PURIFIED PROTEIN DERIVATIVE'
             657 'D01184 DIPIVEFRIN OPHTHALMIC'
             658 'D01187 LEVOBUNOLOL OPHTHALMIC'
             659 'D01188 ACETYLCHOLINE OPHTHALMIC'
             660 'D01191 PILOCARPINE OPHTHALMIC'
             661 'D01195 ECHOTHIOPHATE IODIDE OPHTHALMIC'
             662 'D01199 HOMATROPINE OPHTHALMIC'
             663 'D01200 TROPICAMIDE OPHTHALMIC'
             664 'D01201 CYCLOPENTOLATE OPHTHALMIC'
             665 'D01204 SUPROFEN OPHTHALMIC'
             666 'D01208 SULFACETAMIDE SODIUM OPHTHALMIC'
             667 'D01210 YELLOW MERCURIC OXIDE OPHTHALMIC'
             668 'D01215 TRIFLURIDINE OPHTHALMIC' 669 'D01217 TETRACAINE'
             670 'D01218 PROPARACAINE OPHTHALMIC'
             671 'D01219 FLUORESCEIN OPHTHALMIC'
             672 'D01222 SODIUM HYALURONATE OPHTHALMIC'
             673 'D01225 BORIC ACID TOPICAL'
             674 'D01226 HYDROXYPROPYL METHYLCELLULOSE OPHTHALMIC'
             675 'D01227 BOTULINUM TOXIN TYPE A (OBSOLETE)'
             676 'D01231 CHLORHEXIDINE TOPICAL'
             677 'D01232 CARBAMIDE PEROXIDE TOPICAL' 678 'D01233 NYSTATIN'
             679 'D01234 BUTOCONAZOLE TOPICAL'
             680 'D01235 TIOCONAZOLE TOPICAL' 681 'D01236 CLOTRIMAZOLE'
             682 'D01238 TERCONAZOLE TOPICAL'
             683 'D01239 GENTIAN VIOLET TOPICAL'
             684 'D01240 SULFANILAMIDE TOPICAL'
             685 'D01241 CLINDAMYCIN TOPICAL'
             686 'D01242 NONOXYNOL 9 TOPICAL' 687 'D01243 OCTOXYNOL TOPICAL'
             688 'D01244 TRETINOIN TOPICAL' 689 'D01245 ISOTRETINOIN'
             690 'D01246 BENZOYL PEROXIDE TOPICAL'
             691 'D01254 ANTHRALIN TOPICAL'
             692 'D01257 NITROFURAZONE TOPICAL' 693 'D01258 MAFENIDE TOPICAL'
             694 'D01259 SILVER SULFADIAZINE TOPICAL'
             695 'D01263 PYRITHIONE ZINC TOPICAL'
             696 'D01265 SULFACETAMIDE SODIUM TOPICAL'
             697 'D01266 CHLOROXINE TOPICAL' 698 'D01267 MUPIROCIN TOPICAL'
             699 'D01271 ECONAZOLE TOPICAL' 700 'D01272 CICLOPIROX TOPICAL'
             701 'D01273 TRIACETIN TOPICAL' 702 'D01274 TOLNAFTATE TOPICAL'
             703 'D01275 SULCONAZOLE TOPICAL' 704 'D01277 NAFTIFINE TOPICAL'
             705 'D01278 LINDANE TOPICAL' 706 'D01279 PERMETHRIN TOPICAL'
             707 'D01280 CROTAMITON TOPICAL'
             708 'D01282 ALCLOMETASONE TOPICAL'
             709 'D01288 CLOBETASOL TOPICAL'
             710 'D01289 CLOCORTOLONE TOPICAL' 711 'D01290 DESONIDE TOPICAL'
             712 'D01291 DESOXIMETASONE TOPICAL'
             713 'D01292 DIFLORASONE TOPICAL'
             714 'D01293 FLUOCINOLONE TOPICAL'
             715 'D01294 FLUOCINONIDE TOPICAL'
             716 'D01295 FLURANDRENOLIDE TOPICAL' 717 'D01296 FLUTICASONE'
             718 'D01298 HALOBETASOL TOPICAL' 719 'D01300 MOMETASONE TOPICAL'
             720 'D01301 DIBUCAINE TOPICAL' 721 'D01302 BUTAMBEN TOPICAL'
             722 'D01303 PRAMOXINE TOPICAL' 723 'D01305 DYCLONINE TOPICAL'
             724 'D01306 COCAINE TOPICAL' 725 'D01307 SALICYLIC ACID TOPICAL'
             726 'D01308 PODOPHYLLUM RESIN TOPICAL'
             727 'D01309 PODOFILOX TOPICAL'
             728 'D01313 TRICHLOROACETIC ACID TOPICAL'
             729 'D01314 SUTILAINS TOPICAL' 730 'D01315 COLLAGENASE TOPICAL'
             731 'D01316 MASOPROCOL TOPICAL'
             732 'D01319 HYDROQUINONE TOPICAL'
             733 'D01320 FORMALDEHYDE TOPICAL' 734 'D01321 CAPSAICIN TOPICAL'
             735 'D01322 ALUMINUM CHLORIDE HEXAHYDRATE TOPICAL'
             736 'D01323 MONOBENZONE TOPICAL' 737 'D01325 ARNICA TOPICAL'
             738 'D01332 HEXACHLOROPHENE TOPICAL'
             739 'D01333 BENZALKONIUM CHLORIDE TOPICAL'
             740 'D01335 SODIUM HYPOCHLORITE TOPICAL'
             741 'D01338 PHYSIOLOGICAL IRRIGATING SOLUTION'
             742 'D01339 MECHLORETHAMINE' 743 'D01341 LOMUSTINE'
             744 'D01342 CARMUSTINE' 745 'D01344 FLOXURIDINE'
             746 'D01345 THIOGUANINE' 747 'D01346 FLUDARABINE'
             748 'D01348 MEGESTROL' 749 'D01351 ESTRAMUSTINE'
             750 'D01353 LEUPROLIDE' 751 'D01354 GOSERELIN'
             752 'D01356 PENTOSTATIN' 753 'D01361 PLICAMYCIN'
             754 'D01368 INTERFERON ALFA-2A' 755 'D01369 INTERFERON ALFA-2B'
             756 'D01372 ALTRETAMINE' 757 'D01373 HYDROXYUREA'
             758 'D01375 ALDESLEUKIN' 759 'D01376 PACLITAXEL'
             760 'D01378 MITOTANE' 761 'D01379 ASPARAGINASE ESCHERICHIA COLI'
             762 'D01382 ETHANOLAMINE OLEATE'
             763 'D01383 SODIUM TETRADECYL SULFATE'
             764 'D01384 MORRHUATE SODIUM' 765 'D01385 BETA-CAROTENE'
             766 'D01386 YOHIMBINE' 767 'D01387 ALPROSTADIL'
             768 'D01389 DISULFIRAM' 769 'D01393 HYALURONIDASE'
             770 'D01394 PROCAINE' 771 'D01395 CHLOROPROCAINE'
             772 'D01396 PRILOCAINE' 773 'D01398 MEPIVACAINE'
             774 'D01402 DEFEROXAMINE' 775 'D01404 SODIUM THIOSULFATE'
             776 'D01406 NALTREXONE' 777 'D01407 FLUMAZENIL'
             778 'D01409 PRALIDOXIME' 779 'D01410 DIGOXIN IMMUNE FAB'
             780 'D01411 MESNA' 781 'D01413 IPECAC' 782 'D01416 TRIENTINE'
             783 'D01417 SUCCIMER' 784 'D01420 AMBENONIUM'
             785 'D01422 GUANIDINE' 786 'D01423 POTASSIUM CITRATE'
             787 'D01424 POTASSIUM ACID PHOSPHATE' 788 'D01425 FLAVOXATE'
             789 'D01427 BETHANECHOL' 790 'D01431 DIMETHYL SULFOXIDE'
             791 'D01433 ACETOHYDROXAMIC ACID' 792 'D01434 METHOXSALEN'
             793 'D01438 IOPANOIC ACID' 794 'D01445 BARIUM SULFATE'
             795 'D01451 GADOPENTETATE DIMEGLUMINE' 796 'D01452 IODAMIDE'
             797 'D01456 IOHEXOL' 798 'D01461 IOPAMIDOL'
             799 'D01469 IOVERSOL' 800 'D01472 METRIZAMIDE'
             801 'D01473 DIATRIZOATE' 802 'D01475 IOTHALAMATE'
             803 'D01476 ETHIODIZED OIL' 804 'D01482 ISOSULFAN BLUE'
             805 'D02373 PHOSPHORATED CARBOHYDRATE SOLUTION'
             806 'D02374 DESFLURANE' 807 'D02375 PLASMA PROTEIN FRACTION'
             808 'D02376 ALBUMIN HUMAN' 809 'D02378 HETASTARCH'
             810 'D02381 POTASSIUM PERCHLORATE' 811 'D03001 CLADRIBINE'
             812 'D03003 DIPHTHERIA-TETANUS TOXOIDS (OBSOLETE)'
             813 'D03004 DIPHTHERIA/PERTUSSIS, WHOLE CELL/TETANUS'
             814 'D03006 MEASLES-RUBELLA VIRUS VACCINE'
             815 'D03007 MEASLES/MUMPS/RUBELLA VIRUS VACCINE'
             816 'D03008 INTERFERON GAMMA-1B' 817 'D03034 NORGESTREL'
             818 'D03041 ENOXAPARIN' 819 'D03050 LORATADINE'
             820 'D03051 INTERFERON BETA-1B'
             821 'D03052 HYDROCHLOROTHIAZIDE-TRIAMTERENE'
             822 'D03054 AMYLASE' 823 'D03056 ATTAPULGITE'
             824 'D03058 BENZOIC ACID' 825 'D03061 BUTALBITAL'
             826 'D03062 CASANTHRANOL' 827 'D03066 CITRIC ACID'
             828 'D03068 DICHLORALPHENAZONE' 829 'D03075 HYDROCODONE'
             830 'D03077 ISOMETHEPTENE MUCATE' 831 'D03085 PEPSIN'
             832 'D03086 PHENIRAMINE' 833 'D03089 PHENYLTOLOXAMINE'
             834 'D03094 SALICYLAMIDE' 835 'D03096 SODIUM BENZOATE'
             836 'D03097 SODIUM BORATE TOPICAL' 837 'D03098 SODIUM CITRATE'
             838 'D03109 JAPANESE ENCEPHALITIS VIRUS VACCINE NAKAYAMA'
             839 'D03110 DIPHTH/PERTUSSIS, ACEL/TETANUS (OBSOLETE)'
             840 'D03112 NEDOCROMIL'
             841 'D03113 DEXTRAN, LOW MOLECULAR WEIGHT'
             842 'D03114 DEXTRAN, HIGH MOLECULAR WEIGHT'
             843 'D03116 BISMUTH SUBGALLATE' 844 'D03118 MUROMONAB-CD3'
             845 'D03125 DIHYDROTACHYSTEROL' 846 'D03126 CALCITRIOL'
             847 'D03128 ERGOCALCIFEROL' 848 'D03129 CHOLECALCIFEROL'
             849 'D03130 THIAMINE' 850 'D03133 HYDROXOCOBALAMIN'
             851 'D03135 PHYTONADIONE' 852 'D03136 VITAMIN A & D TOPICAL'
             853 'D03137 CALCIUM-VITAMIN D' 854 'D03140 MULTIVITAMIN'
             855 'D03141 MULTIVITAMIN WITH IRON'
             856 'D03143 MULTIVITAMIN WITH FLUORIDE'
             857 'D03145 MULTIVITAMIN WITH MINERALS'
             858 'D03148 MULTIVITAMIN, PRENATAL' 859 'D03152 TRIFLUPROMAZINE'
             860 'D03154 DOXYLAMINE' 861 'D03157 PAROXETINE'
             862 'D03158 RIMANTADINE' 863 'D03159 CHOLINE'
             864 'D03160 SUMATRIPTAN' 865 'D03162 ALCOHOL (ETHANOL)'
             866 'D03165 PIPERACILLIN-TAZOBACTAM' 867 'D03166 CISAPRIDE'
             868 'D03168 DIHYDROCODEINE' 869 'D03169 TRIMETREXATE'
             870 'D03170 FELBAMATE' 871 'D03171 GRANISETRON'
             872 'D03173 DORNASE ALFA' 873 'D03176 TACRINE'
             874 'D03180 RISPERIDONE' 875 'D03181 VENLAFAXINE'
             876 'D03182 GABAPENTIN' 877 'D03183 FLUVASTATIN'
             878 'D03187 LEVOMETHADYL ACETATE' 879 'D03189 TORSEMIDE'
             880 'D03190 OXICONAZOLE TOPICAL'
             881 'D03191 TERBINAFINE TOPICAL' 882 'D03192 ZINC OXIDE TOPICAL'
             883 'D03193 AMILORIDE-HYDROCHLOROTHIAZIDE'
             884 'D03195 MICONAZOLE TOPICAL' 885 'D03196 GENTAMICIN TOPICAL'
             886 'D03197 BETAMETHASONE TOPICAL'
             887 'D03200 ERYTHROMYCIN TOPICAL' 888 'D03201 ACYCLOVIR TOPICAL'
             889 'D03202 KETOCONAZOLE TOPICAL' 890 'D03203 MINOXIDIL TOPICAL'
             891 'D03204 FLUOROURACIL TOPICAL'
             892 'D03205 HYDROCORTISONE TOPICAL'
             893 'D03206 TRIAMCINOLONE TOPICAL'
             894 'D03207 AMPHOTERICIN B TOPICAL'
             895 'D03208 METRONIDAZOLE TOPICAL'
             896 'D03210 SELENIUM SULFIDE TOPICAL'
             897 'D03211 CIPROFLOXACIN OPHTHALMIC'
             898 'D03212 ATROPINE OPHTHALMIC'
             899 'D03213 DICLOFENAC OPHTHALMIC'
             900 'D03214 KETOROLAC OPHTHALMIC'
             901 'D03221 PREDNISOLONE OPHTHALMIC'
             902 'D03222 TOBRAMYCIN OPHTHALMIC' 903 'D03224 NEOMYCIN TOPICAL'
             904 'D03226 SALIVA SUBSTITUTES'
             905 'D03227 FLUOROMETHOLONE OPHTHALMIC'
             906 'D03228 LODOXAMIDE OPHTHALMIC'
             907 'D03229 LEVOCABASTINE OPHTHALMIC'
             908 'D03231 TRIPLE SULFA TOPICAL'
             909 'D03232 VITAMINS A, D, AND E TOPICAL'
             910 'D03233 VITAMIN E TOPICAL'
             911 'D03238 ETHINYL ESTRADIOL-NORETHINDRONE'
             912 'D03240 MESTRANOL-NORETHINDRONE'
             913 'D03241 ETHINYL ESTRADIOL-NORGESTREL'
             914 'D03242 ETHINYL ESTRADIOL-LEVONORGESTREL'
             915 'D03245 ESTERIFIED ESTROGENS-METHYLTESTOSTERONE'
             916 'D03247 HYDROCHLOROTHIAZIDE-SPIRONOLACTONE'
             917 'D03251 HYDROCHLOROTHIAZIDE-RESERPINE'
             918 'D03255 BENDROFLUMETHIAZIDE-RAUWOLFIA SERPENTINA'
             919 'D03256 HYDRALAZINE/HYDROCHLOROTHIAZIDE/RESERPINE'
             920 'D03257 HYDRALAZINE-HYDROCHLOROTHIAZIDE'
             921 'D03258 ATENOLOL-CHLORTHALIDONE'
             922 'D03259 BENDROFLUMETHIAZIDE-NADOLOL'
             923 'D03260 HYDROCHLOROTHIAZIDE-TIMOLOL'
             924 'D03261 HYDROCHLOROTHIAZIDE-PROPRANOLOL'
             925 'D03263 HYDROCHLOROTHIAZIDE-METHYLDOPA'
             926 'D03264 HYDROCHLOROTHIAZIDE-METOPROLOL'
             927 'D03265 BENAZEPRIL-HYDROCHLOROTHIAZIDE'
             928 'D03266 HYDROCHLOROTHIAZIDE-LISINOPRIL'
             929 'D03267 CHLORTHALIDONE-CLONIDINE'
             930 'D03271 PHENIRAMINE-PHENYLEPHRINE NASAL'
             931 'D03273 GUAIFENESIN-THEOPHYLLINE'
             932 'D03274 AMINOPHYLLINE-GUAIFENESIN'
             933 'D03276 DYPHYLLINE-GUAIFENESIN'
             934 'D03277 POTASSIUM IODIDE-THEOPHYLLINE'
             935 'D03280 EPHEDRINE/PHENOBARBITAL/THEOPHYLLINE'
             936 'D03283 EPHEDRINE/HYDROXYZINE/THEOPHYLLINE'
             937 'D03289 ACETAMINOPHEN-PSEUDOEPHEDRINE'
             938 'D03292 IBUPROFEN-PSEUDOEPHEDRINE' 939 'D03293 APAP/ASA/PPA'
             940 'D03296 ACETAMINOPHEN-CHLORPHENIRAMINE'
             941 'D03297 ACETAMINOPHEN-PHENYLTOLOXAMINE'
             942 'D03298 CHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             943 'D03299 CHLORPHENIRAMINE-PHENYLPROPANOLAMINE'
             944 'D03300 CHLORPHENIRAMINE-PHENYLEPHRINE'
             945 'D03301 BROMPHENIRAMINE-PSEUDOEPHEDRINE'
             946 'D03302 BROMPHENIRAMINE-PHENYLPROPANOLAMINE'
             947 'D03303 CLEMASTINE-PHENYLPROPANOLAMINE'
             948 'D03306 CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             949 'D03307 CHLORPHENIRAMINE/PHENINDAMINE/PPA'
             950 'D03308 PHENIRAMINE/PPA/PHENYLTOLOXAMINE/PYRILAMINE'
             951 'D03310 CHLORPHENIRAMINE/PE/PPA/PHENYLTOLOXAMINE'
             952 'D03311 BROMPHENIRAMINE-PHENYLEPHRINE'
             953 'D03312 DIPHENHYDRAMINE-PSEUDOEPHEDRINE'
             954 'D03313 CHLORPHENIRAMINE/PHENYLEPHRINE/PYRILAMINE'
             955 'D03316 PSEUDOEPHEDRINE-TRIPROLIDINE'
             956 'D03317 PHENYLEPHRINE-PROMETHAZINE'
             957 'D03318 PHENIRAMINE/PPA/PYRILAMINE'
             958 'D03319 APAP/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             959 'D03320 APAP/CHLORPHENIRAMINE/PSEUDOEPHEDRINE'
             960 'D03321 APAP/BROMPHENIRAMINE/PSEUDOEPHEDRINE'
             961 'D03322 ASA/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             962 'D03329 ASA/DIPHENHYDRAMINE/PPA'
             963 'D03330 APAP/PSEUDOEPHEDRINE/TRIPROLIDINE'
             964 'D03331 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE'
             965 'D03336 APAP/CPM/PHENYLEPHRINE/PPA/PYRILAMINE'
             966 'D03338 CHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             967 'D03340 HOMATROPINE-HYDROCODONE'
             968 'D03341 CODEINE-PSEUDOEPHEDRINE'
             969 'D03342 APAP/DEXTROMETHORPHAN/PSEUDOEPHEDRINE'
             970 'D03347 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             971 'D03349 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PSE'
             972 'D03351 ASA/BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             973 'D03352 HYDROCODONE-PSEUDOEPHEDRINE'
             974 'D03353 HYDROCODONE-PHENYLPROPANOLAMINE'
             975 'D03354 DEXTROMETHORPHAN-PSEUDOEPHEDRINE'
             976 'D03355 DEXTROMETHORPHAN-PHENYLPROPANOLAMINE'
             977 'D03356 CHLORPHENIRAMINE-HYDROCODONE'
             978 'D03357 CODEINE-PROMETHAZINE'
             979 'D03359 CHLORPHENIRAMINE-DEXTROMETHORPHAN'
             980 'D03360 DEXTROMETHORPHAN-PROMETHAZINE'
             981 'D03361 CHLORPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             982 'D03362 CHLORPHENIRAMINE/CODEINE/PSEUDOEPHEDRINE'
             983 'D03364 CODEINE/PHENYLEPHRINE/PROMETHAZINE'
             984 'D03366 HYDROCODONE/PHENYLEPHRINE/PYRILAMINE'
             985 'D03368 BROMPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             986 'D03369 CHLORPHENIRAMINE/DEXTROMETHORP/PHENYLEPHRINE'
             987 'D03370 CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             988 'D03371 DEXTROMETHORPHAN/PHENYLEPHRINE/PYRILAMINE'
             989 'D03372 BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             990 'D03378 ACETAMINOPHEN-DEXTROMETHORPHAN'
             991 'D03379 GUAIFENESIN-PSEUDOEPHEDRINE'
             992 'D03380 EPHEDRINE-GUAIFENESIN'
             993 'D03381 GUAIFENESIN-PHENYLEPHRINE'
             994 'D03382 GUAIFENESIN-PHENYLPROPANOLAMINE'
             995 'D03383 GUAIFENESIN/PHENYLEPHRINE/PPA'
             996 'D03388 ETHINYL ESTRADIOL-ETHYNODIOL'
             997 'D03389 ESTRADIOL-TESTOSTERONE'
             998 'D03392 CHLORPHENIRAMINE/GUAIFENESIN/PHENYLEPHRINE'
             999 'D03393 CODEINE-GUAIFENESIN'
             1000 'D03396 GUAIFENESIN-HYDROCODONE'
             1001 'D03397 GUAIFENESIN-HYDROMORPHONE'
             1002 'D03398 CODEINE/GUAIFENESIN/PSE'
             1003 'D03400 DEXTROMETHORPHAN-GUAIFENESIN'
             1004 'D03403 GUAIFENESIN/HYDROCODONE/PHENYLEPHRINE'
             1005 'D03404 GUAIFENESIN/HYDROCODONE/PSEUDOEPHEDRINE'
             1006 'D03407 CODEINE/GUAIFENESIN/PHENYLPROPANOLAMINE'
             1007 'D03408 DEXTROMETHORPHAN/GUAIFENESIN/PHENYLEPHRINE'
             1008 'D03409 DEXTROMETHORPHAN/GUAIFENESIN/PSEUDOEPHEDRINE'
             1009 'D03411 DEXTROMETHORPHAN/GUAIFENESIN/PPA'
             1010 'D03416 CHLORPHENIRAMINE/HYDROCODONE/PSE'
             1011 'D03419 CHLORPHENIRAMINE/DM/GUAIFENESIN/PHENYLEPHRINE'
             1012 'D03423 ACETAMINOPHEN-CODEINE'
             1013 'D03424 ASPIRIN-CODEINE'
             1014 'D03425 APAP/BUTALBITAL/CAFFEINE/CODEINE'
             1015 'D03426 ASA/BUTALBITAL/CAFFEINE/CODEINE'
             1016 'D03428 ACETAMINOPHEN-HYDROCODONE'
             1017 'D03430 ASA/CAFFEINE/DIHYDROCODEINE'
             1018 'D03431 ACETAMINOPHEN-OXYCODONE'
             1019 'D03432 ASPIRIN-OXYCODONE'
             1020 'D03433 MEPERIDINE-PROMETHAZINE'
             1021 'D03434 ACETAMINOPHEN-PROPOXYPHENE'
             1022 'D03435 ASA/CAFFEINE/PROPOXYPHENE'
             1023 'D03436 BELLADONNA-OPIUM'
             1024 'D03437 APAP/ASA/CAFFEINE/SALICYLAMIDE'
             1025 'D03439 APAP/ASA/CAFFEINE'
             1026 'D03443 APAP/AL HYDROXIDE/ASA/CAFFEINE/MG HYDROXIDE'
             1027 'D03445 ACETAMINOPHEN-DIPHENHYDRAMINE'
             1028 'D03447 ASA/CAFFEINE/SALICYLAMIDE'
             1029 'D03448 ASPIRIN-MEPROBAMATE' 1030 'D03449 ASPIRIN-CAFFEINE'
             1031 'D03453 ASPIRIN-PHENYLTOLOXAMINE'
             1032 'D03454 MAGNESIUM SALICYLATE-PHENYLTOLOXAMINE'
             1033 'D03455 APAP/BUTALBITAL/CAFFEINE'
             1034 'D03456 ACETAMINOPHEN-BUTALBITAL'
             1035 'D03457 ASA/BUTALBITAL/CAFFEINE'
             1036 'D03459 APAP/DICHLORALPHENAZONE/ISOMETHEPTENE'
             1037 'D03462 AMITRIPTYLINE-CHLORDIAZEPOXIDE'
             1038 'D03463 AMITRIPTYLINE-PERPHENAZINE'
             1039 'D03464 DROPERIDOL-FENTANYL'
             1040 'D03468 ASPIRIN-METHOCARBAMOL'
             1041 'D03469 ASPIRIN-CARISOPRODOL'
             1042 'D03470 ASA/CARISOPRODOL/CODEINE'
             1043 'D03472 ASA/CAFFEINE/ORPHENADRINE'
             1044 'D03473 CARBIDOPA-LEVODOPA'
             1045 'D03474 ALUMINUM HYDROXIDE-MAGNESIUM HYDROXIDE'
             1046 'D03478 AL HYDROXIDE/MG HYDROXIDE/SIMETHICONE'
             1047 'D03480 CA CARBONATE/MG HYDROXIDE/SIMETHICONE'
             1048 'D03485 ATROPINE/HYOSCYAMINE/PB/SCOPOLAMINE'
             1049 'D03486 BELLADONNA-BUTABARBITAL'
             1050 'D03492 CHLORDIAZEPOXIDE-CLIDINIUM'
             1051 'D03495 BELLADONNA/ERGOTAMINE/PHENOBARBITAL'
             1052 'D03496 DOCUSATE-SENNA'
             1053 'D03497 DOCUSATE-PHENOLPHTHALEIN'
             1054 'D03498 CASANTHRANOL-DOCUSATE'
             1055 'D03505 ATROPINE-DIFENOXIN'
             1056 'D03506 ATROPINE-DIPHENOXYLATE'
             1057 'D03508 ISONIAZID-RIFAMPIN'
             1058 'D03509 ERYTHROMYCIN-SULFISOXAZOLE'
             1059 'D03511 PHENAZOPYRIDINE-SULFAMETHOXAZOLE'
             1060 'D03513 METHENAMINE-SODIUM ACID PHOSPHATE'
             1061 'D03517 BENZOIC ACID/METHENAMINE/SODIUM SALICYLATE'
             1062 'D03520 NAPHAZOLINE-PHENIRAMINE OPHTHALMIC'
             1063 'D03521 CYCLOPENTOLATE-PHENYLEPHRINE OPHTHALMIC'
             1064 'D03523 HYDROXYAMPHETAMINE-TROPICAMIDE OPHTHALMIC'
             1065 'D03524 BACITRACIN/NEOMYCIN/POLYMYXIN B TOPICAL'
             1066 'D03525 GRAMICIDIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1067 'D03526 NEOMYCIN-POLYMYXIN B SULFATE TOPICAL'
             1068 'D03527 BACITRACIN-POLYMYXIN B TOPICAL'
             1069 'D03529 POLYMYXIN B-TRIMETHOPRIM OPHTHALMIC'
             1070 'D03533 NEOMYCIN/POLYMYXIN B/PREDNISOLONE OPHTHALMIC'
             1071 'D03536 DEXAMETHASONE-TOBRAMYCIN OPHTHALMIC'
             1072 'D03537 DEXAMETHASONE/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1073 'D03541 PREDNISOLONE-SULFACETAMIDE SODIUM OPHTHALMIC'
             1074 'D03542 FLUORESCEIN-PROPARACAINE OPHTHALMIC'
             1075 'D03543 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OTIC'
             1076 'D03544 HYDROCORTISONE-POLYMYXIN B OTIC'
             1077 'D03546 HYDROCORTISONE-PRAMOXINE TOPICAL'
             1078 'D03552 CLIOQUINOL-HYDROCORTISONE TOPICAL'
             1079 'D03553 CLIOQUINOL/HYDROCORTISONE/PRAMOXINE TOPICAL'
             1080 'D03561 BETAMETHASONE-CLOTRIMAZOLE TOPICAL'
             1081 'D03562 NYSTATIN-TRIAMCINOLONE TOPICAL'
             1082 'D03566 CAPTOPRIL-HYDROCHLOROTHIAZIDE'
             1083 'D03569 CARBINOXAMINE'
             1084 'D03570 CARBINOXAMINE-PSEUDOEPHEDRINE'
             1085 'D03572 CARAMIPHEN-PHENYLPROPANOLAMINE'
             1086 'D03576 BROMODIPHENHYDRAMINE-CODEINE'
             1087 'D03577 CARBINOXAMINE/DEXTROMETHORPHAN/PSE'
             1088 'D03584 CODEINE/PHENIRAMINE/PHENYLEPHRINE/NA CITRATE'
             1089 'D03585 PAMABROM' 1090 'D03586 APAP/PAMABROM/PYRILAMINE'
             1091 'D03588 MAGNESIUM CARBONATE'
             1092 'D03591 ALGINIC ACID/AL HYDROXIDE/MG CARBONATE'
             1093 'D03596 ALGINIC ACID/AL HYDROXIDE/MG TRISILICATE'
             1094 'D03600 POTASSIUM BICARBONATE' 1095 'D03613 PSYLLIUM-SENNA'
             1096 'D03618 HYOSCYAMINE/METHENAM/M-BLUE/PHENYL SALICYL'
             1097 'D03620 ANTAZOLINE-NAPHAZOLINE OPHTHALMIC'
             1098 'D03622 BENOXINATE-FLUORESCEIN OPHTHALMIC'
             1099 'D03623 ACETIC ACID TOPICAL' 1100 'D03624 ANTIPYRINE OTIC'
             1101 'D03625 ACETIC ACID-HYDROCORTISONE OTIC'
             1102 'D03627 ANTIPYRINE-BENZOCAINE OTIC'
             1103 'D03628 ANTIPYRINE/BENZOCAINE/PHENYLEPHRINE OTIC'
             1104 'D03630 ANHYDROUS CALCIUM IODIDE-CODEINE'
             1105 'D03632 CETYLPYRIDINIUM TOPICAL'
             1106 'D03634 BENZOCAINE-CETYLPYRIDINIUM TOPICAL'
             1107 'D03640 BUDESONIDE NASAL' 1108 'D03641 PETROLATUM TOPICAL'
             1109 'D03644 LACTOBACILLUS ACIDOPHILUS'
             1110 'D03646 LACTOBACILLUS ACIDOPHILUS AND BULGARICUS'
             1111 'D03647 ISOPROPYL ALCOHOL TOPICAL'
             1112 'D03648 OPHTHALMIC IRRIGATION, INTRAOCULAR'
             1113 'D03649 BENZOIN TOPICAL'
             1114 'D03650 CANDIDA ALBICANS EXTRACT'
             1115 'D03651 CHOLINE SALICYLATE-MAGNESIUM SALICYLATE'
             1116 'D03652 COLCHICINE-PROBENECID'
             1117 'D03653 CALAMINE TOPICAL'
             1118 'D03655 LIDOCAINE-PRILOCAINE TOPICAL'
             1119 'D03656 ETHYL CHLORIDE TOPICAL'
             1120 'D03659 FIBRINOLYSIN AND DESOXYRIBONUCLEASE TOPICAL'
             1121 'D03660 MULTIVITAMIN WITH IRON AND FLUORIDE'
             1122 'D03661 DOCUSATE-FERROUS FUMARATE' 1123 'D03663 LECITHIN'
             1124 'D03664 PHENOL TOPICAL' 1125 'D03665 MENTHOL TOPICAL'
             1126 'D03666 MENTHOL-PHENOL TOPICAL' 1127 'D03667 METHACHOLINE'
             1128 'D03668 METHYL SALICYLATE TOPICAL' 1129 'D03674 PECTIN'
             1130 'D03676 NALOXONE-PENTAZOCINE'
             1131 'D03678 NAPHAZOLINE-ZINC OPHTHALMIC'
             1132 'D03680 ASA/CITRIC ACID/NA BICARB'
             1133 'D03681 OPHTHALMIC IRRIGATION, EXTRAOCULAR'
             1134 'D03682 ACETAMINOPHEN-PENTAZOCINE'
             1135 'D03684 THROMBIN TOPICAL'
             1136 'D03686 UNDECYLENIC ACID TOPICAL'
             1137 'D03687 ALUMINUM ACETATE TOPICAL'
             1138 'D03688 ALUMINUM SULFATE TOPICAL'
             1139 'D03689 CALCIUM ACETATE'
             1140 'D03690 ALUMINUM SULFATE-CALCIUM ACETATE TOPICAL'
             1141 'D03691 BENZOCAINE/PHENOL/POVIDONE IODINE TOPICAL'
             1142 'D03693 ICHTHAMMOL TOPICAL'
             1143 'D03694 MEDRYSONE OPHTHALMIC'
             1144 'D03695 PRAMOXINE-ZINC OXIDE TOPICAL'
             1145 'D03696 BENZYL BENZOATE TOPICAL'
             1146 'D03701 CORN STARCH TOPICAL' 1147 'D03702 SULFUR TOPICAL'
             1148 'D03703 COAL TAR TOPICAL'
             1149 'D03705 SALICYLIC ACID-SULFUR TOPICAL'
             1150 'D03707 ALOE VERA TOPICAL'
             1151 'D03708 LANOLIN-MINERAL OIL TOPICAL'
             1152 'D03710 ALLANTOIN/CAMPHOR/PHENOL TOPICAL'
             1153 'D03712 CAMPHOR TOPICAL'
             1154 'D03713 CAMPHOR-PHENOL TOPICAL'
             1155 'D03716 CITRIC ACID/GLUCONODELTA-LACTONE/MG CARBONATE'
             1156 'D03721 SODIUM IODIDE'
             1157 'D03724 FAT EMULSION, INTRAVENOUS'
             1158 'D03725 INTRAVENOUS ELECTROLYTE SOLUTION'
             1159 'D03735 TRIETHANOLAMINE POLYPEPTIDE OLEATE OTIC'
             1160 'D03738 TETRACYCLINE TOPICAL' 1161 'D03739 NIACINAMIDE'
             1162 'D03740 ENALAPRIL-HYDROCHLOROTHIAZIDE'
             1163 'D03743 PYRIMETHAMINE-SULFADOXINE'
             1164 'D03744 BISOPROLOL-HYDROCHLOROTHIAZIDE'
             1165 'D03750 DEXBROMPHENIRAMINE'
             1166 'D03751 DEXBROMPHENIRAMINE-PSEUDOEPHEDRINE'
             1167 'D03752 TACROLIMUS'
             1168 'D03754 ACRIVASTINE-PSEUDOEPHEDRINE'
             1169 'D03756 BACITRACIN TOPICAL' 1170 'D03759 SALMETEROL'
             1171 'D03760 DIPHENHYDRAMINE TOPICAL'
             1172 'D03761 LANOLIN TOPICAL' 1173 'D03762 WITCH HAZEL TOPICAL'
             1174 'D03763 GLYCERIN-PHENOL TOPICAL'
             1175 'D03764 GLYCERIN-WITCH HAZEL TOPICAL'
             1176 'D03766 ROCURONIUM' 1177 'D03767 IRON DEXTRAN'
             1178 'D03768 OCULAR LUBRICANT' 1179 'D03770 EMOLLIENTS, TOPICAL'
             1180 'D03773 STAVUDINE' 1181 'D03774 DOXEPIN TOPICAL'
             1182 'D03775 FAMCICLOVIR' 1183 'D03777 POTASSIUM ACETATE'
             1184 'D03780 DESOGESTREL'
             1185 'D03781 ETHINYL ESTRADIOL-NORGESTIMATE'
             1186 'D03782 DESOGESTREL-ETHINYL ESTRADIOL'
             1187 'D03783 BUPIVACAINE-EPINEPHRINE'
             1188 'D03784 EPINEPHRINE-LIDOCAINE'
             1189 'D03788 CALCIPOTRIENE TOPICAL'
             1190 'D03789 POTASSIUM GLUCONATE'
             1191 'D03790 POTASSIUM PHOSPHATE'
             1192 'D03796 MAGNESIUM CHLORIDE' 1193 'D03797 MAGNESIUM OXIDE'
             1194 'D03798 MAGNESIUM GLUCONATE' 1195 'D03799 CALCIUM CHLORIDE'
             1196 'D03800 CALCIUM GLUCONATE' 1197 'D03802 CALCIUM LACTATE'
             1198 'D03803 CALCIUM PHOSPHATE, TRIBASIC'
             1199 'D03804 FLUVOXAMINE' 1200 'D03805 DORZOLAMIDE OPHTHALMIC'
             1201 'D03806 ALBENDAZOLE' 1202 'D03807 METFORMIN'
             1203 'D03808 NEFAZODONE' 1204 'D03809 LAMOTRIGINE'
             1205 'D03810 VINORELBINE' 1206 'D03811 ABCIXIMAB'
             1207 'D03812 DALTEPARIN'
             1208 'D03818 LORATADINE-PSEUDOEPHEDRINE'
             1209 'D03819 CONJUGATED ESTROGENS-MEDROXYPROGESTERONE'
             1210 'D03821 LOSARTAN' 1211 'D03822 FERROUS GLUCONATE'
             1212 'D03823 IRON POLYSACCHARIDE' 1213 'D03824 FERROUS SULFATE'
             1214 'D03825 NISOLDIPINE' 1215 'D03826 TRAMADOL'
             1216 'D03827 CETIRIZINE' 1217 'D03828 LANSOPRAZOLE'
             1218 'D03829 AMLODIPINE-BENAZEPRIL'
             1219 'D03830 HYDROCHLOROTHIAZIDE-LOSARTAN'
             1220 'D03831 NILUTAMIDE' 1221 'D03832 VARICELLA VIRUS VACCINE'
             1222 'D03833 DIVALPROEX SODIUM' 1223 'D03834 NALMEFENE'
             1224 'D03835 MOEXIPRIL' 1225 'D03836 ACITRETIN'
             1226 'D03838 VALACYCLOVIR' 1227 'D03839 MYCOPHENOLATE MOFETIL'
             1228 'D03840 IOPROMIDE' 1229 'D03841 DEXRAZOXANE'
             1230 'D03842 EPOPROSTENOL' 1231 'D03843 GADOTERIDOL'
             1232 'D03844 DIRITHROMYCIN' 1233 'D03845 SEVOFLURANE'
             1234 'D03846 ACARBOSE' 1235 'D03847 CARVEDILOL'
             1236 'D03848 AZELAIC ACID TOPICAL' 1237 'D03849 ALENDRONATE'
             1238 'D03850 BICALUTAMIDE'
             1239 'D03857 BENZOYL PEROXIDE-ERYTHROMYCIN TOPICAL'
             1240 'D03858 LAMIVUDINE' 1241 'D03860 SAQUINAVIR'
             1242 'D03862 MAGNESIUM AMINO ACIDS CHELATE'
             1243 'D03863 TRETINOIN' 1244 'D03864 GLIMEPIRIDE'
             1245 'D03866 CALCIUM CITRATE'
             1246 'D03867 CALCIUM CARBONATE-SODIUM FLUORIDE'
             1247 'D03868 AMIFOSTINE' 1248 'D03869 RILUZOLE'
             1249 'D03870 AMPHOTERICIN B LIPID COMPLEX'
             1250 'D03872 PORFIMER' 1251 'D03873 ANASTROZOLE'
             1252 'D03874 CEFTIBUTEN' 1253 'D03877 HEROIN'
             1254 'D03878 COCAINE' 1255 'D03879 MARIJUANA'
             1256 'D03880 PHENCYCLIDINE'
             1257 'D03881 RESPIRATORY SYNCYTIAL VIRUS IMMUNE GLOBULIN'
             1258 'D03882 CEFEPIME'
             1259 'D03883 AL HYDROXIDE/ASA/CA CARBONATE/MG HYDROXIDE'
             1260 'D03884 TROLAMINE SALICYLATE TOPICAL'
             1261 'D03888 BENZOCAINE/BUTAMBEN/TETRACAINE TOPICAL'
             1262 'D03892 HISTAMINE PHOSPHATE' 1263 'D03894 KAOLIN-PECTIN'
             1264 'D03895 SINCALIDE' 1265 'D03897 LACTASE'
             1266 'D03898 SODIUM CHLORIDE, HYPERTONIC, OPHTHALMIC'
             1267 'D03904 BALSAM PERU/CASTOR OIL/TRYPSIN TOPICAL'
             1268 'D03905 ISOPROTERENOL-PHENYLEPHRINE'
             1269 'D03906 PHENIRAMINE/PHENYLTOLOXAMINE/PYRILAMINE'
             1270 'D03908 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             1271 'D03911 CHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1272 'D03913 APAP/DEXTROMETHORPHAN/PSE/PYRILAMINE'
             1273 'D03915 HYDROCODONE-POTASSIUM GUAIACOLSULFONATE'
             1274 'D03920 FERROUS FUMARATE'
             1275 'D03922 ACETAMINOPHEN-CAFFEINE'
             1276 'D03923 ACETAMINOPHEN-PHENYLEPHRINE'
             1277 'D03926 APAP/CAFFEINE/PYRILAMINE'
             1278 'D03927 BACITRACIN OPHTHALMIC'
             1279 'D03929 AMINOPHYLLINE/AMOBARBITAL/EPHEDRINE'
             1280 'D03946 ASCORBIC ACID-FERROUS FUMARATE'
             1281 'D03951 CITRIC ACID/K CITRATE/NA CITRATE'
             1282 'D03952 CITRIC ACID-SODIUM CITRATE'
             1283 'D03953 ELECTROLYTE REPLACEMENT SOLUTIONS, ORAL'
             1284 'D03954 FERROUS FUMARATE-FOLIC ACID'
             1285 'D03957 CALCIUM/FERROUS FUMARATE/VITAMIN D'
             1286 'D03962 POTASSIUM BICARBONATE-POTASSIUM CITRATE'
             1287 'D03963 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1288 'D03964 BACITRACIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1289 'D03965 BACITRACIN-POLYMYXIN B OPHTHALMIC'
             1290 'D03966 BENZOYL PEROXIDE-SULFUR TOPICAL'
             1291 'D03968 DEXAMETHASONE OPHTHALMIC'
             1292 'D03971 EPINEPHRINE OPHTHALMIC'
             1293 'D03973 ERYTHROMYCIN OPHTHALMIC'
             1294 'D03974 GENTAMICIN OPHTHALMIC'
             1295 'D03975 GLYCERIN OPHTHALMIC'
             1296 'D03976 HYDROCORTISONE OTIC'
             1297 'D03977 OFLOXACIN OPHTHALMIC'
             1298 'D03978 OXYMETAZOLINE OPHTHALMIC'
             1299 'D03979 SCOPOLAMINE OPHTHALMIC'
             1300 'D03980 SULFISOXAZOLE OPHTHALMIC'
             1301 'D03981 TETRACAINE OPHTHALMIC'
             1302 'D03982 TETRACAINE TOPICAL' 1303 'D03984 RITONAVIR'
             1304 'D03985 INDINAVIR' 1305 'D03989 BORIC ACID OPHTHALMIC'
             1306 'D03990 CARBAMIDE PEROXIDE OTIC'
             1307 'D03992 CHLORAMPHENICOL OPHTHALMIC'
             1308 'D03993 CHLORTETRACYCLINE OPHTHALMIC'
             1309 'D03994 COLLOIDAL OATMEAL TOPICAL'
             1310 'D03998 STERILE WATER'
             1311 'D04002 PIPERONYL BUTOXIDE-PYRETHRINS TOPICAL'
             1312 'D04003 HYDROGEN PEROXIDE TOPICAL'
             1313 'D04004 DOXORUBICIN LIPOSOMAL'
             1314 'D04005 AMOBARBITAL-SECOBARBITAL'
             1315 'D04006 DEXFENFLURAMINE' 1316 'D04008 TRANDOLAPRIL'
             1317 'D04009 DOCETAXEL' 1318 'D04010 GEMCITABINE'
             1319 'D04011 INTERFERON BETA-1A' 1320 'D04012 TERBINAFINE'
             1321 'D04014 TOPOTECAN' 1322 'D04015 ADAPALENE TOPICAL'
             1323 'D04016 IODIXANOL' 1324 'D04017 LATANOPROST OPHTHALMIC'
             1325 'D04021 BENZOIC ACID-SALICYLIC ACID TOPICAL'
             1326 'D04025 MIRTAZAPINE' 1327 'D04026 IRINOTECAN'
             1328 'D04027 MEROPENEM' 1329 'D04028 CIDOFOVIR'
             1330 'D04029 NEVIRAPINE' 1331 'D04031 PILOCARPINE'
             1332 'D04032 SULFACETAMIDE SODIUM-SULFUR TOPICAL'
             1333 'D04034 REMIFENTANIL'
             1334 'D04035 AMPHETAMINE-DEXTROAMPHETAMINE'
             1335 'D04036 CAFFEINE-SODIUM BENZOATE'
             1336 'D04037 TIMOLOL OPHTHALMIC'
             1337 'D04038 BETAXOLOL OPHTHALMIC'
             1338 'D04039 CARTEOLOL OPHTHALMIC' 1339 'D04040 FEXOFENADINE'
             1340 'D04041 FOSPHENYTOIN'
             1341 'D04043 FOLLICLE STIMULATING HORMONE'
             1342 'D04044 RESORCINOL TOPICAL'
             1343 'D04045 RESORCINOL-SULFUR TOPICAL' 1344 'D04047 MIDODRINE'
             1345 'D04048 BRIMONIDINE OPHTHALMIC'
             1346 'D04049 AMMONIUM LACTATE TOPICAL' 1347 'D04050 OLANZAPINE'
             1348 'D04051 ROPIVACAINE'
             1349 'D04052 PENTOSAN POLYSULFATE SODIUM'
             1350 'D04053 ZAFIRLUKAST' 1351 'D04054 PENCICLOVIR TOPICAL'
             1352 'D04056 ZINC GLUCONATE' 1353 'D04057 ZINC SULFATE'
             1354 'D04058 MELATONIN'
             1355 'D04059 HAEMOPHILUS B-HEPATITIS B VACCINE'
             1356 'D04060 DILTIAZEM-ENALAPRIL'
             1357 'D04061 BISMUTH SUBSALICYLATE/METRONIDAZOLE/TCN'
             1358 'D04062 BENTOQUATAM TOPICAL'
             1359 'D04063 BUTENAFINE TOPICAL'
             1360 'D04065 TRANDOLAPRIL-VERAPAMIL'
             1361 'D04066 ALBUTEROL-IPRATROPIUM' 1362 'D04067 RETEPLASE'
             1363 'D04068 AZELASTINE NASAL'
             1364 'D04070 SODIUM PHENYLBUTYRATE'
             1365 'D04075 CHLOROXYLENOL TOPICAL'
             1366 'D04076 CHLOROXYLENOL/HYDROCORTISONE/PRAMOXINE OTIC'
             1367 'D04083 GADODIAMIDE' 1368 'D04084 GLYCINE IRRIGATION'
             1369 'D04090 LACTIC ACID TOPICAL'
             1370 'D04093 HYDROCORTISONE-IODOQUINOL TOPICAL'
             1371 'D04095 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OPHTH'
             1372 'D04096 IMIGLUCERASE' 1373 'D04099 DONEPEZIL'
             1374 'D04100 AMPHOTERICIN B CHOLESTERYL SULFATE'
             1375 'D04101 IVERMECTIN' 1376 'D04102 TIZANIDINE'
             1377 'D04103 ZILEUTON' 1378 'D04105 ATORVASTATIN'
             1379 'D04106 FOSFOMYCIN' 1380 'D04107 AMLEXANOX TOPICAL'
             1381 'D04109 LEVOFLOXACIN' 1382 'D04110 MIGLITOL'
             1383 'D04111 GLATIRAMER' 1384 'D04112 CABERGOLINE'
             1385 'D04113 VALSARTAN' 1386 'D04115 TOPIRAMATE'
             1387 'D04116 ENALAPRIL-FELODIPINE'
             1388 'D04117 OLOPATADINE OPHTHALMIC' 1389 'D04118 NELFINAVIR'
             1390 'D04119 DELAVIRDINE' 1391 'D04120 CAFFEINE-ERGOTAMINE'
             1392 'D04121 TAMSULOSIN' 1393 'D04122 TROGLITAZONE'
             1394 'D04123 ZINC ACETATE' 1395 'D04125 IMIQUIMOD TOPICAL'
             1396 'D04126 ANAGRELIDE' 1397 'D04128 LVP SOLUTION'
             1398 'D04130 LVP SOLUTION WITH HYPERTONIC SALINE'
             1399 'D04131 PARENTERAL NUTRITION SOLUTION'
             1400 'D04132 PARENTERAL NUTRITION SOLUTION W/ELECTROLYTES'
             1401 'D04133 NEOMYCIN OPHTHALMIC'
             1402 'D04134 POLYMYXIN B OPHTHALMIC'
             1403 'D04135 PHENYLEPHRINE OPHTHALMIC' 1404 'D04137 TOREMIFENE'
             1405 'D04138 TAZAROTENE TOPICAL' 1406 'D04139 MIBEFRADIL'
             1407 'D04141 HYDROCHLOROTHIAZIDE-MOEXIPRIL'
             1408 'D04142 CHROMIUM PICOLINATE'
             1409 'D04143 ACETAMINOPHEN-PAMABROM' 1410 'D04145 PRAMIPEXOLE'
             1411 'D04147 NAPHAZOLINE NASAL' 1412 'D04150 BROMFENAC'
             1413 'D04151 BENZOCAINE-TRIMETHOBENZAMIDE'
             1414 'D04152 HYDROCODONE-PHENYLEPHRINE'
             1415 'D04153 PHENAZOPYRIDINE-SULFISOXAZOLE'
             1416 'D04155 ASPIRIN-DIPHENHYDRAMINE' 1417 'D04156 LETROZOLE'
             1418 'D04157 LOPERAMIDE-SIMETHICONE' 1419 'D04159 SORBITOL'
             1420 'D04160 SODIUM BIPHOSPHATE-SODIUM PHOSPHATE'
             1421 'D04161 SECRETIN' 1422 'D04163 FERROUS SULFATE-FOLIC ACID'
             1423 'D04166 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PSE'
             1424 'D04168 APAP/DIPHENHYDRAMINE/PSEUDOEPHEDRINE'
             1425 'D04172 CALAMINE-PRAMOXINE TOPICAL'
             1426 'D04175 DIPHENHYDRAMINE-MAGNESIUM SALICYLATE'
             1427 'D04177 FAT SUPPLEMENT, ORAL'
             1428 'D04178 CALCIUM HYDROXIDE TOPICAL'
             1429 'D04184 POTASSIUM AMINOBENZOATE'
             1430 'D04185 POTASSIUM BICARBONATE-SODIUM BICARBONATE'
             1431 'D04186 PHENYLEPHRINE NASAL'
             1432 'D04189 TRIPELENNAMINE TOPICAL'
             1433 'D04190 PAPAIN TOPICAL' 1434 'D04191 PAPAIN-UREA TOPICAL'
             1435 'D04192 COLISTIN/HC/NEOMYCIN/THONZONIUM OTIC'
             1436 'D04193 LEVMETAMFETAMINE NASAL'
             1437 'D04194 PROPYLHEXEDRINE NASAL' 1438 'D04195 CHLOROPHYLLIN'
             1439 'D04196 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B TOPICAL'
             1440 'D04197 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B TOPICAL'
             1441 'D04204 COPPER SULFATE'
             1442 'D04205 POVIDONE IODINE OPHTHALMIC'
             1443 'D04206 TETRAHYDROZOLINE NASAL'
             1444 'D04208 SILVER NITRATE TOPICAL'
             1445 'D04209 METHOXSALEN TOPICAL'
             1446 'D04210 ESTRADIOL TOPICAL' 1447 'D04214 DOLASETRON'
             1448 'D04215 ROPINIROLE' 1449 'D04217 EPINEPHRINE-PRILOCAINE'
             1450 'D04219 LAMIVUDINE-ZIDOVUDINE' 1451 'D04220 QUETIAPINE'
             1452 'D04221 TIAGABINE' 1453 'D04222 IRBESARTAN'
             1454 'D04223 MOMETASONE NASAL'
             1455 'D04224 INTERFERON ALFACON-1'
             1456 'D04225 HYDROCODONE-IBUPROFEN'
             1457 'D04226 AMINOSALICYLIC ACID' 1458 'D04228 ACETIC ACID OTIC'
             1459 'D04229 GLYCERIN OTIC' 1460 'D04231 VITAMIN A OPHTHALMIC'
             1461 'D04233 TRIAMCINOLONE NASAL'
             1462 'D04235 IPRATROPIUM NASAL' 1463 'D04236 ETHANOL TOPICAL'
             1464 'D04238 AMPHOTERICIN B LIPOSOMAL'
             1465 'D04240 HYLAN G-F 20'
             1466 'D04241 POTASSIUM CHLORIDE-SODIUM CHLORIDE'
             1467 'D04242 SODIUM CHLORIDE NASAL'
             1468 'D04243 LIDOCAINE-OXYTETRACYCLINE'
             1469 'D04245 HYDROCHLOROTHIAZIDE-IRBESARTAN'
             1470 'D04247 PEGASPARGASE' 1471 'D04248 METHYLCELLULOSE'
             1472 'D04249 CELLULOSE' 1473 'D04253 ZOLMITRIPTAN'
             1474 'D04255 RITUXIMAB' 1475 'D04256 CEFDINIR'
             1476 'D04258 CLOPIDOGREL' 1477 'D04260 SIBUTRAMINE'
             1478 'D04261 RALOXIFENE' 1479 'D04263 TROVAFLOXACIN'
             1480 'D04264 BECAPLERMIN TOPICAL' 1481 'D04265 OFLOXACIN OTIC'
             1482 'D04266 EPROSARTAN' 1483 'D04267 REPAGLINIDE'
             1484 'D04269 APAP/CAFFEINE/DIHYDROCODEINE'
             1485 'D04270 FEXOFENADINE-PSEUDOEPHEDRINE'
             1486 'D04271 DICLOFENAC-MISOPROSTOL'
             1487 'D04272 AMOXICILLIN/CLARITHROMYCIN/LANSOPRAZOLE'
             1488 'D04274 FOMEPIZOLE' 1489 'D04275 BECLOMETHASONE NASAL'
             1490 'D04276 BUDESONIDE' 1491 'D04279 FLUNISOLIDE NASAL'
             1492 'D04282 TOLCAPONE' 1493 'D04283 FLUTICASONE NASAL'
             1494 'D04284 FLUTICASONE TOPICAL' 1495 'D04285 NARATRIPTAN'
             1496 'D04286 FENOFIBRATE' 1497 'D04287 CIPROFLOXACIN OTIC'
             1498 'D04288 CIPROFLOXACIN-HYDROCORTISONE OTIC'
             1499 'D04289 MONTELUKAST'
             1500 'D04290 CALCIUM CARBONATE-MAGNESIUM HYDROXIDE'
             1501 'D04291 LEPIRUDIN' 1502 'D04292 LOTEPREDNOL OPHTHALMIC'
             1503 'D04293 HYDROCHLOROTHIAZIDE-VALSARTAN'
             1504 'D04294 TOLTERODINE' 1505 'D04295 OXYMETHOLONE'
             1506 'D04296 STARCH TOPICAL'
             1507 'D04297 PHENYLEPHRINE-PRAMOXINE TOPICAL'
             1508 'D04298 PHENYLEPHRINE TOPICAL' 1509 'D04299 SILDENAFIL'
             1510 'D04300 RISEDRONATE' 1511 'D04301 BRINZOLAMIDE OPHTHALMIC'
             1512 'D04303 DORZOLAMIDE-TIMOLOL OPHTHALMIC'
             1513 'D04305 SACROSIDASE' 1514 'D04311 CAPECITABINE'
             1515 'D04312 PARICALCITOL' 1516 'D04314 BASILIXIMAB'
             1517 'D04315 TIROFIBAN' 1518 'D04316 EPTIFIBATIDE'
             1519 'D04320 DIPHTHERIA/HAEMOPHILUS/PERTUSSIS,ACEL/TETANUS'
             1520 'D04321 INTERFERON ALFA-2B-RIBAVIRIN'
             1521 'D04322 CANDESARTAN' 1522 'D04323 PALIVIZUMAB'
             1523 'D04328 RIZATRIPTAN' 1524 'D04329 SODIUM HYALURONATE'
             1525 'D04331 THALIDOMIDE' 1526 'D04332 CITALOPRAM'
             1527 'D04334 EPHEDRINE-POTASSIUM IODIDE'
             1528 'D04339 DEXTROMETHORPHAN-POTASSIUM GUAIACOLSULFONATE'
             1529 'D04342 INFLIXIMAB' 1530 'D04344 ROTAVIRUS VACCINE'
             1531 'D04345 APAP/CAFFEINE/GUAIFENESIN/PHENYLEPHRINE'
             1532 'D04347 DOXYCYCLINE TOPICAL' 1533 'D04349 LEFLUNOMIDE'
             1534 'D04351 COAL TAR/LACTIC ACID/SALICYLIC ACID TOPICAL'
             1535 'D04355 EFAVIRENZ' 1536 'D04357 TRASTUZUMAB'
             1537 'D04360 HEMIN' 1538 'D04363 SEVELAMER'
             1539 'D04364 TELMISARTAN' 1540 'D04365 ETANERCEPT'
             1541 'D04366 SIMETHICONE COATED CELLULOSE'
             1542 'D04368 TANNIC ACID TOPICAL' 1543 'D04369 INSULIN REGULAR'
             1544 'D04370 INSULIN ISOPHANE' 1545 'D04371 INSULIN ZINC'
             1546 'D04372 INSULIN ZINC EXTENDED' 1547 'D04373 INSULIN LISPRO'
             1548 'D04374 INSULIN ISOPHANE-INSULIN REGULAR'
             1549 'D04375 ESTRADIOL-NORETHINDRONE' 1550 'D04376 ABACAVIR'
             1551 'D04377 THYROTROPIN ALPHA' 1552 'D04378 MODAFINIL'
             1553 'D04379 LYME DISEASE VACCINE' 1554 'D04380 CELECOXIB'
             1555 'D04382 CILOSTAZOL' 1556 'D04386 DENILEUKIN DIFTITOX'
             1557 'D04387 SODIUM FERRIC GLUCONATE COMPLEX'
             1558 'D04389 PENTASTARCH' 1559 'D04391 LIVER DERIVATIVE COMPLEX'
             1560 'D04393 BUTABARBITAL/HYOSCYAMINE/PHENAZOPYRIDINE'
             1561 'D04394 CROMOLYN NASAL' 1562 'D04395 CLOTRIMAZOLE TOPICAL'
             1563 'D04396 CONJUGATED ESTROGENS TOPICAL'
             1564 'D04397 FLUORIDE TOPICAL' 1565 'D04399 NYSTATIN TOPICAL'
             1566 'D04402 CILASTATIN' 1567 'D04406 TYPHOID VACCINE, LIVE'
             1568 'D04407 ECHINACEA' 1569 'D04408 ST. JOHN''S WORT'
             1570 'D04409 CHAMOMILE' 1571 'D04410 FEVERFEW'
             1572 'D04411 GARLIC' 1573 'D04412 GINSENG' 1574 'D04413 GINKGO'
             1575 'D04414 GINGER' 1576 'D04415 SAW PALMETTO'
             1577 'D04416 VALERIAN' 1578 'D04417 CREATINE'
             1579 'D04418 GLUCOSAMINE' 1580 'D04419 CHONDROITIN'
             1581 'D04420 CHONDROITIN-GLUCOSAMINE'
             1582 'D04421 EVENING PRIMROSE' 1583 'D04422 KAVA'
             1584 'D04423 GOLDENSEAL' 1585 'D04425 DEHYDROEPIANDROSTERONE'
             1586 'D04426 RED YEAST RICE' 1587 'D04427 LEVALBUTEROL'
             1588 'D04429 ORLISTAT'
             1589 'D04430 BACITRACIN/NEOMYCIN/POLYMYXIN B/PRAMOXINE TOP'
             1590 'D04431 NEOMYCIN/POLYMYXIN B/PRAMOXINE TOPICAL'
             1591 'D04432 CARBONYL IRON' 1592 'D04433 ROFECOXIB'
             1593 'D04434 ROSIGLITAZONE' 1594 'D04435 DOXERCALCIFEROL'
             1595 'D04436 MALATHION TOPICAL' 1596 'D04440 PERINDOPRIL'
             1597 'D04441 KETOTIFEN OPHTHALMIC' 1598 'D04442 PIOGLITAZONE'
             1599 'D04443 ZANAMIVIR'
             1600 'D04445 CARBETAPENTANE/CHLORPHENIRAMINE/PHENYLEPHRINE'
             1601 'D04446 PHENYLEPHRINE-PYRILAMINE' 1602 'D04447 GANIRELIX'
             1603 'D04448 RABEPRAZOLE' 1604 'D04451 TEMOZOLOMIDE'
             1605 'D04452 ZALEPLON' 1606 'D04453 SIROLIMUS'
             1607 'D04454 EPIRUBICIN' 1608 'D04457 DALFOPRISTIN-QUINUPRISTIN'
             1609 'D04458 PEMIROLAST OPHTHALMIC' 1610 'D04459 DOFETILIDE'
             1611 'D04460 ENTACAPONE' 1612 'D04461 EXEMESTANE'
             1613 'D04462 OSELTAMIVIR' 1614 'D04463 GRAPE SEED OIL'
             1615 'D04464 DONG QUAI' 1616 'D04466 MILK THISTLE'
             1617 'D04467 CAT''S CLAW' 1618 'D04469 BEE POLLEN'
             1619 'D04470 CRANBERRY' 1620 'D04472 BLACK COHOSH'
             1621 'D04473 BLUE COHOSH' 1622 'D04478 WILD YAM'
             1623 'D04479 PENNYROYAL' 1624 'D04481 ROYAL JELLY'
             1625 'D04482 DAMIANA' 1626 'D04483 DANDELION'
             1627 'D04484 SHARK CARTILAGE' 1628 'D04491 FLAX'
             1629 'D04492 FENUGREEK' 1630 'D04497 ASPIRIN-DIPYRIDAMOLE'
             1631 'D04498 NAPROXEN-PSEUDOEPHEDRINE'
             1632 'D04499 LEVETIRACETAM' 1633 'D04500 MOXIFLOXACIN'
             1634 'D04501 AMINOLEVULINIC ACID TOPICAL'
             1635 'D04503 NEDOCROMIL OPHTHALMIC' 1636 'D04504 GATIFLOXACIN'
             1637 'D04505 DEXMEDETOMIDINE'
             1638 'D04506 ESTRADIOL-NORGESTIMATE' 1639 'D04507 BEXAROTENE'
             1640 'D04508 NITRIC OXIDE'
             1641 'D04509 HYDROCHLOROTHIAZIDE-QUINAPRIL'
             1642 'D04510 INSULIN LISPRO-INSULIN LISPRO PROTAMINE'
             1643 'D04512 CEVIMELINE' 1644 'D04513 OXCARBAZEPINE'
             1645 'D04514 PANTOPRAZOLE' 1646 'D04515 GADOVERSETAMIDE'
             1647 'D04516 ALOSETRON' 1648 'D04523 UBIQUINONE'
             1649 'D04524 S-ADENOSYLMETHIONINE' 1650 'D04527 ZONISAMIDE'
             1651 'D04530 STRONTIUM-89 CHLORIDE'
             1652 'D04531 SAMARIUM SM 153 LEXIDRONAM' 1653 'D04532 MELOXICAM'
             1654 'D04533 VERTEPORFIN' 1655 'D04534 LINEZOLID'
             1656 'D04535 ARTICAINE-EPINEPHRINE' 1657 'D04536 ARTICAINE'
             1658 'D04537 RIVASTIGMINE' 1659 'D04538 INSULIN GLARGINE'
             1660 'D04539 FOSINOPRIL-HYDROCHLOROTHIAZIDE'
             1661 'D04540 GEMTUZUMAB' 1662 'D04541 AZELASTINE OPHTHALMIC'
             1663 'D04547 ATOVAQUONE-PROGUANIL' 1664 'D04557 CLOBAZAM'
             1665 'D04572 FORMOTEROL' 1666 'D04597 TETRABENAZINE'
             1667 'D04611 FLUTICASONE-SALMETEROL' 1668 'D04659 TINZAPARIN'
             1669 'D04669 VIGABATRIN'
             1670 'D04674 DIPHTH/HAEMOPHILUS/PERTUSSIS/TETANUS/POLIO'
             1671 'D04675 DIPHTHERIA/PERTUSSIS,ACEL/TETANUS/POLIO'
             1672 'D04685 HEPATITIS A-HEPATITIS B VACCINE'
             1673 'D04689 CALAMINE-DIPHENHYDRAMINE TOPICAL'
             1674 'D04694 TENECTEPLASE' 1675 'D04695 COLESEVELAM'
             1676 'D04697 INSULIN ASPART' 1677 'D04698 ARGATROBAN'
             1678 'D04700 BALSALAZIDE' 1679 'D04702 DOCOSANOL TOPICAL'
             1680 'D04703 GLYBURIDE-METFORMIN'
             1681 'D04704 EFLORNITHINE TOPICAL'
             1682 'D04705 FLUDEOXYGLUCOSE F18'
             1683 'D04707 LEVOFLOXACIN OPHTHALMIC'
             1684 'D04708 ZOLEDRONIC ACID'
             1685 'D04711 CANDESARTAN-HYDROCHLOROTHIAZIDE'
             1686 'D04716 LOPINAVIR' 1687 'D04717 LOPINAVIR-RITONAVIR'
             1688 'D04718 MIFEPRISTONE' 1689 'D04720 ARSENIC TRIOXIDE'
             1690 'D04722 DICLOFENAC TOPICAL'
             1691 'D04723 CALCIUM CARBONATE/FAMOTIDINE/MG HYDROXIDE'
             1692 'D04725 IRON SUCROSE' 1693 'D04726 5-HYDROXYTRYPTOPHAN'
             1694 'D04727 ABACAVIR/LAMIVUDINE/ZIDOVUDINE'
             1695 'D04737 HYDROCHLOROTHIAZIDE-TELMISARTAN'
             1696 'D04738 APAP/DOXYLAMINE/PSEUDOEPHEDRINE'
             1697 'D04740 TACROLIMUS TOPICAL'
             1698 'D04741 CARBETAPENTANE/GUAIFENESIN/PHENYLEPHRINE'
             1699 'D04742 BENZOYL PEROXIDE-CLINDAMYCIN TOPICAL'
             1700 'D04743 NATEGLINIDE' 1701 'D04744 BIVALIRUDIN'
             1702 'D04746 PEGINTERFERON ALFA-2B' 1703 'D04747 ZIPRASIDONE'
             1704 'D04748 CASPOFUNGIN' 1705 'D04749 ESOMEPRAZOLE'
             1706 'D04750 GALANTAMINE'
             1707 'D04752 CARBINOXAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1708 'D04753 TRAVOPROST OPHTHALMIC'
             1709 'D04754 BIMATOPROST OPHTHALMIC'
             1710 'D04755 VALGANCICLOVIR' 1711 'D04756 ALEMTUZUMAB'
             1712 'D04757 ALMOTRIPTAN' 1713 'D04758 IMATINIB'
             1714 'D04760 DROSPIRENONE-ETHINYL ESTRADIOL'
             1715 'D04761 MINOCYCLINE TOPICAL'
             1716 'D04762 METHSCOPOLAMINE-PSEUDOEPHEDRINE'
             1717 'D04763 NESIRITIDE'
             1718 'D04764 CETIRIZINE-PSEUDOEPHEDRINE'
             1719 'D04765 HYDROCORTISONE-LIDOCAINE TOPICAL'
             1720 'D04766 ACETAMINOPHEN-TRAMADOL' 1721 'D04767 CEFDITOREN'
             1722 'D04770 CARBETAPENTANE-CHLORPHENIRAMINE'
             1723 'D04771 DARBEPOETIN ALFA' 1724 'D04772 ETONOGESTREL'
             1725 'D04773 ETHINYL ESTRADIOL-ETONOGESTREL'
             1726 'D04774 TENOFOVIR' 1727 'D04775 ANAKINRA'
             1728 'D04776 FROVATRIPTAN' 1729 'D04777 DEXMETHYLPHENIDATE'
             1730 'D04778 VALDECOXIB'
             1731 'D04779 ETHINYL ESTRADIOL-NORELGESTROMIN'
             1732 'D04782 BOSENTAN' 1733 'D04783 ERTAPENEM'
             1734 'D04784 PIMECROLIMUS TOPICAL' 1735 'D04785 DESLORATADINE'
             1736 'D04786 FONDAPARINUX' 1737 'D04787 LOVASTATIN-NIACIN'
             1738 'D04788 DUTASTERIDE' 1739 'D04789 NITISINONE'
             1740 'D04790 PEGFILGRASTIM'
             1741 'D04791 FLUOCINOLONE/HYDROQUINONE/TRETINOIN TOPICAL'
             1742 'D04792 ASA/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1743 'D04793 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PE'
             1744 'D04794 CARBINOXAMINE/METHSCOPOLAMINE/PSEUDOEPHEDRINE'
             1745 'D04795 BUDESONIDE-FORMOTEROL' 1746 'D04796 PERFLUTREN'
             1747 'D04797 ALFUZOSIN' 1748 'D04798 TEGASEROD'
             1749 'D04799 FULVESTRANT' 1750 'D04800 IFOSFAMIDE-MESNA'
             1751 'D04801 OLMESARTAN' 1752 'D04802 TREPROSTINIL'
             1753 'D04803 VORICONAZOLE' 1754 'D04805 RASBURICASE'
             1755 'D04806 SODIUM OXYBATE' 1756 'D04811 OXALIPLATIN'
             1757 'D04812 ESCITALOPRAM' 1758 'D04814 ADEFOVIR'
             1759 'D04815 EPLERENONE'
             1760 'D04817 DEXCHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             1761 'D04818 DEXCHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             1762 'D04819 BUPRENORPHINE-NALOXONE'
             1763 'D04820 METFORMIN-ROSIGLITAZONE'
             1764 'D04821 PEGINTERFERON ALFA-2A'
             1765 'D04823 GLIPIZIDE-METFORMIN' 1766 'D04824 EZETIMIBE'
             1767 'D04825 ARIPIPRAZOLE' 1768 'D04826 NITAZOXANIDE'
             1769 'D04827 ATOMOXETINE' 1770 'D04828 TERIPARATIDE'
             1771 'D04829 TIOTROPIUM' 1772 'D04831 SMALLPOX VACCINE'
             1773 'D04832 DIPHTHERIA/HEPB/PERTUSSIS,ACEL/POLIO/TETANUS'
             1774 'D04834 CYTARABINE LIPOSOMAL' 1775 'D04835 ADALIMUMAB'
             1776 'D04836 CYCLOSPORINE OPHTHALMIC'
             1777 'D04838 INSULIN ASPART PROTAMINE'
             1778 'D04839 INSULIN ASPART-INSULIN ASPART PROTAMINE'
             1779 'D04843 ALEFACEPT' 1780 'D04844 CAMPHOR-MENTHOL TOPICAL'
             1781 'D04845 IBRITUMOMAB' 1782 'D04849 ELETRIPTAN'
             1783 'D04850 CARBETAPENTANE/PHENYLEPHRINE/PYRILAMINE'
             1784 'D04851 ROSUVASTATIN' 1785 'D04852 BUPIVACAINE-FENTANYL'
             1786 'D04853 ENFUVIRTIDE' 1787 'D04854 PEGVISOMANT'
             1788 'D04855 APREPITANT' 1789 'D04856 BOTULISM ANTITOXIN'
             1790 'D04857 GATIFLOXACIN OPHTHALMIC'
             1791 'D04858 ANTHRAX VACCINE ADSORBED'
             1792 'D04859 GEMIFLOXACIN' 1793 'D04860 MOXIFLOXACIN OPHTHALMIC'
             1794 'D04861 DIPHENHYDRAMINE-PHENYLEPHRINE'
             1795 'D04862 BROMPHENIRAMINE/DM/GUAIFENESIN/PSE'
             1796 'D04863 CHLORPHENIRAMINE/IBUPROFEN/PSEUDOEPHEDRINE'
             1797 'D04864 CARBETAPENTANE-PSEUDOEPHEDRINE'
             1798 'D04866 AGALSIDASE BETA' 1799 'D04868 GEFITINIB'
             1800 'D04869 CHLORPHENIRAMINE/DIHYDROCODEINE/PSE'
             1801 'D04870 DIHYDROCODEINE/GUAIFENESIN/PSEUDOEPHEDRINE'
             1802 'D04871 BORTEZOMIB' 1803 'D04875 BETAINE'
             1804 'D04877 CARBIDOPA/ENTACAPONE/LEVODOPA'
             1805 'D04878 HYDROCHLOROTHIAZIDE-OLMESARTAN'
             1806 'D04879 PHENYLEPHRINE-POTASSIUM GUAIACOLSULFONATE'
             1807 'D04880 BROMPHENIRAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1808 'D04881 OMALIZUMAB' 1809 'D04882 ATAZANAVIR'
             1810 'D04884 EMTRICITABINE' 1811 'D04885 TOSITUMOMAB'
             1812 'D04886 IODINE I 131 TOSITUMOMAB'
             1813 'D04887 BUPIVACAINE-HYDROMORPHONE'
             1814 'D04888 PALONOSETRON'
             1815 'D04890 CIPROFLOXACIN-DEXAMETHASONE OTIC'
             1816 'D04892 INFLUENZA VIRUS VACCINE, LIVE, TRIVALENT'
             1817 'D04893 VARDENAFIL' 1818 'D04894 DAPTOMYCIN'
             1819 'D04895 CARBETAPENTANE/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1820 'D04896 TADALAFIL'
             1821 'D04897 TETRAHYDROZOLINE-ZINC OPHTHALMIC'
             1822 'D04898 EPINASTINE OPHTHALMIC' 1823 'D04899 MEMANTINE'
             1824 'D04900 SALICYLIC ACID-UREA TOPICAL'
             1825 'D04901 FOSAMPRENAVIR' 1826 'D04902 EFALIZUMAB'
             1827 'D04905 BROMPHENIRAMINE/DEXTROMETHORPH/PHENYLEPHRINE'
             1828 'D04913 LANSOPRAZOLE-NAPROXEN'
             1829 'D04914 ESTRADIOL-LEVONORGESTREL'
             1830 'D04915 SERTACONAZOLE TOPICAL' 1831 'D04916 CAPSICUM'
             1832 'D04917 FLUOXETINE-OLANZAPINE'
             1833 'D04920 PNEUMOCOCCAL 7-VALENT CONJUGATE VACCINE'
             1834 'D04921 TETANUS-DIPHTH TOXOIDS (TD) ADULT/ADOL'
             1835 'D04925 DIPHENHYDRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1836 'D04929 TROSPIUM' 1837 'D04933 TELITHROMYCIN'
             1838 'D04935 TINIDAZOLE' 1839 'D04986 ACAMPROSATE'
             1840 'D04991 APOMORPHINE' 1841 'D05029 LUTROPIN ALFA'
             1842 'D05044 BETAMETHASONE-CALCIPOTRIENE TOPICAL'
             1843 'D05047 PEMETREXED' 1844 'D05048 AMLODIPINE-ATORVASTATIN'
             1845 'D05101 CETUXIMAB'
             1846 'D05117 GUAIFENESIN-POTASSIUM GUAIACOLSULFONATE'
             1847 'D05119 DEXTROMETHORPHAN/GG/K GUAIACOLSULFONATE'
             1848 'D05145 ARTEMETHER-LUMEFANTRINE'
             1849 'D05150 CARBINOXAMINE/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1850 'D05214 BEVACIZUMAB' 1851 'D05215 ZINC ACETATE TOPICAL'
             1852 'D05216 DIPHENHYDRAMINE-ZINC ACETATE TOPICAL'
             1853 'D05217 MYCOPHENOLIC ACID' 1854 'D05218 CINACALCET'
             1855 'D05232 ILOPROST' 1856 'D05234 HYALURONAN'
             1857 'D05238 BENZOYL PEROXIDE-UREA TOPICAL'
             1858 'D05262 MOMETASONE' 1859 'D05265 NEBIVOLOL'
             1860 'D05269 CADEXOMER IODINE TOPICAL'
             1861 'D05278 INSULIN GLULISINE'
             1862 'D05283 BRIMONIDINE-TIMOLOL OPHTHALMIC'
             1863 'D05292 APAP/CAFFEINE/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1864 'D05293 AZACITIDINE' 1865 'D05294 RIFAXIMIN'
             1866 'D05303 CHLORPHENIRAMINE-CODEINE'
             1867 'D05332 PITCHER PLANT'
             1868 'D05334 BROMPHENIRAMINE/CODEINE/PHENYLEPHRINE'
             1869 'D05337 PNEUMOCOCCAL 23-POLYVALENT VACCINE'
             1870 'D05338 DIPHTHERIA-TETANUS TOXOIDS (DT) PED'
             1871 'D05339 HEPATITIS A PEDIATRIC VACCINE'
             1872 'D05340 HEPATITIS A ADULT VACCINE'
             1873 'D05341 HAEMOPHILUS B CONJUGATE (HBOC) VACCINE'
             1874 'D05343 HAEMOPHILUS B CONJUGATE (PRP-T) VACCINE'
             1875 'D05346 GADOBUTROL' 1876 'D05348 EZETIMIBE-SIMVASTATIN'
             1877 'D05349 BISACODYL-PEG 3350 WITH ELECTROLYTES'
             1878 'D05350 POLYETHYLENE GLYCOL 3350'
             1879 'D05351 APAP/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1880 'D05352 EMTRICITABINE-TENOFOVIR'
             1881 'D05354 ABACAVIR-LAMIVUDINE' 1882 'D05355 DULOXETINE'
             1883 'D05357 IBANDRONATE'
             1884 'D05361 CARBETAPENTANE-GUAIFENESIN'
             1885 'D05366 APAP/DEXTROMETHORPHAN/DOXYLAMINE'
             1886 'D05383 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1887 'D05384 DEXTROMETHORPHAN/PHENIRAMINE/PHENYLEPHRINE'
             1888 'D05389 BISACODYL-MAGNESIUM CITRATE'
             1889 'D05395 LANTHANUM CARBONATE'
             1890 'D05411 CHLORPHENIRAMINE-METHSCOPOLAMINE'
             1891 'D05412 ERLOTINIB' 1892 'D05413 SOLIFENACIN'
             1893 'D05414 NATALIZUMAB' 1894 'D05415 IBUPROFEN-OXYCODONE'
             1895 'D05416 CHLORDIAZEPOXIDE-METHSCOPOLAMINE'
             1896 'D05417 PALIFERMIN' 1897 'D05418 PEGAPTANIB OPHTHALMIC'
             1898 'D05420 ALOH/DIPHENHYD/LIDOCAINE/MGOH/SIMETH TOPICAL'
             1899 'D05421 ESZOPICLONE' 1900 'D05422 DARIFENACIN'
             1901 'D05423 CLOFARABINE' 1902 'D05424 ZICONOTIDE'
             1903 'D05425 LOTEPREDNOL-TOBRAMYCIN OPHTHALMIC'
             1904 'D05426 BROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1905 'D05427 PACLITAXEL PROTEIN-BOUND'
             1906 'D05428 GADOBENATE DIMEGLUMINE'
             1907 'D05432 MENINGOCOCCAL CONJUGATE VACCINE'
             1908 'D05433 DIGESTIVE ENZYMES/HYOSCYAMINE/PHENYLTOLOXAMIN'
             1909 'D05434 BROMPHENIRAMINE/CARBETAPENTANE/PHENYLEPHRINE'
             1910 'D05436 INSULIN DETEMIR'
             1911 'D05459 POVIDONE-TETRAHYDROZOLINE OPHTHALMIC'
             1912 'D05461 SODIUM BENZOATE-SODIUM PHENYLACETATE'
             1913 'D05465 CICLESONIDE'
             1914 'D05470 ASCORBIC ACID-IRON POLYSACCHARIDE'
             1915 'D05471 ALPHA-D-GALACTOSIDASE'
             1916 'D05473 DESLORATADINE-PSEUDOEPHEDRINE'
             1917 'D05487 MICAFUNGIN' 1918 'D05488 PRAMLINTIDE'
             1919 'D05508 PREGABALIN' 1920 'D05518 BROMFENAC OPHTHALMIC'
             1921 'D05525 ENTECAVIR'
             1922 'D05526 ALENDRONATE-CHOLECALCIFEROL'
             1923 'D05527 FLUOCINOLONE OPHTHALMIC'
             1924 'D05528 TRICHOPHYTON SKIN TEST' 1925 'D05529 EXENATIDE'
             1926 'D05530 DROSPIRENONE-ESTRADIOL'
             1927 'D05535 HEME IRON POLYPEPTIDE'
             1928 'D05536 APAP/GUAIFENESIN/PSEUDOEPHEDRINE'
             1929 'D05537 TIGECYCLINE' 1930 'D05538 TIPRANAVIR'
             1931 'D05539 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1932 'D05540 HYDRALAZINE-ISOSORBIDE DINITRATE'
             1933 'D05543 DAPSONE TOPICAL'
             1934 'D05544 APAP/GUAIFENESIN/PHENYLEPHRINE'
             1935 'D05578 RAMELTEON'
             1936 'D05583 APAP/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1937 'D05612 RASAGILINE' 1938 'D05626 EVEROLIMUS'
             1939 'D05630 CALCIUM CARBONATE-RISEDRONATE'
             1940 'D05632 BISACODYL/SODIUM BIPHOSPHATE/SODIUM PHOSPHATE'
             1941 'D05633 NEPAFENAC OPHTHALMIC'
             1942 'D05635 METFORMIN-PIOGLITAZONE' 1943 'D05636 MECASERMIN'
             1944 'D05637 LACTOBACILLUS RHAMNOSUS GG'
             1945 'D05644 APAP/CAFFEINE/ISOMETHEPTENE MUCATE'
             1946 'D05645 MEASLES/MUMPS/RUBELLA/VARICELLA VIRUS VACCINE'
             1947 'D05646 SACCHAROMYCES BOULARDII LYO'
             1948 'D05647 FERRIC SUBSULFATE TOPICAL'
             1949 'D05649 CEFTRIAXONE-LIDOCAINE'
             1950 'D05651 SODIUM HYALURONATE TOPICAL'
             1951 'D05654 APAP/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1952 'D05659 DEFERASIROX'
             1953 'D05661 ACETAMINOPHEN-GUAIFENESIN'
             1954 'D05674 GLIMEPIRIDE-ROSIGLITAZONE' 1955 'D05691 SORAFENIB'
             1956 'D05692 MECASERMIN RINFABATE' 1957 'D05694 ABATACEPT'
             1958 'D05696 LENALIDOMIDE' 1959 'D05702 METHYLSULFONYLMETHANE'
             1960 'D05703 CHONDROITIN/GLUCOSAMINE/METHYLSULFONYLMETHANE'
             1961 'D05704 IMMUNE GLOBULIN SUBCUTANEOUS'
             1962 'D05717 SUNITINIB' 1963 'D05719 RANOLAZINE'
             1964 'D05722 GALLIUM CITRATE GA-67' 1965 'D05736 LUBIPROSTONE'
             1966 'D05753 MICONAZOLE-ZINC OXIDE TOPICAL'
             1967 'D05757 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PE'
             1968 'D05765 INSULIN INHALATION, RAPID ACTING'
             1969 'D05768 APAP/PHENIRAMINE/PHENYLEPHRINE'
             1970 'D05770 OMEPRAZOLE-SODIUM BICARBONATE'
             1971 'D05773 L-METHYLFOLATE'
             1972 'D05774 AMMONIUM LACTATE-UREA TOPICAL' 1973 'D05776 IODINE'
             1974 'D05777 IODINE-POTASSIUM IODIDE'
             1975 'D05778 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PE'
             1976 'D05781 TETANUS/DIPHTH/PERTUSS (TDAP) ADULT/ADOL'
             1977 'D05782 DIPHTHERIA/TETANUS/PERTUSSIS (DTAP) PED'
             1978 'D05785 RABIES VACCINE, HUMAN DIPLOID CELL'
             1979 'D05786 RABIES VACCINE, PURIFIED CHICK EMBRYO CELL'
             1980 'D05788 DECITABINE'
             1981 'D05806 FERROUS FUMARATE/FA/IRON POLYSACCHARIDE'
             1982 'D05807 VARENICLINE' 1983 'D05813 ZOSTER VACCINE LIVE'
             1984 'D05814 DEXTROMETHORPHAN-PHENYLEPHRINE'
             1985 'D05815 FLUORESCEIN'
             1986 'D05817 HUMAN PAPILLOMAVIRUS VACCINE'
             1987 'D05819 DIPHENHYDRAMINE-IBUPROFEN' 1988 'D05825 DARUNAVIR'
             1989 'D05830 FERUMOXSIL' 1990 'D05831 DASATINIB'
             1991 'D05835 RANIBIZUMAB OPHTHALMIC'
             1992 'D05847 EFAVIRENZ/EMTRICITABINE/TENOFOVIR'
             1993 'D05848 ROTIGOTINE' 1994 'D05851 LEVOCETIRIZINE'
             1995 'D05853 POSACONAZOLE' 1996 'D05855 IDURSULFASE'
             1997 'D05856 GLIMEPIRIDE-PIOGLITAZONE'
             1998 'D05864 COMPLEMENT C1 ESTERASE INHIBITOR'
             1999 'D05866 GUAR GUM'
             2000 'D05874 ANTIHEMOPHILIC FACTOR-VON WILLEBRAND FACTOR'
             2001 'D05877 DEXTROMETHORPHAN/DIPHENHYDRAMINE/PE'
             2002 'D05878 BENZALKONIUM CHLORIDE-BENZOCAINE TOPICAL'
             2003 'D05879 PANITUMUMAB' 2004 'D05891 VORINOSTAT'
             2005 'D05892 DEXCHLORPHENIRAMINE/DEXTROMETHO/PE/PYRILAMINE'
             2006 'D05893 ARFORMOTEROL'
             2007 'D05894 CALAMINE-ZINC OXIDE TOPICAL'
             2008 'D05896 SITAGLIPTIN'
             2009 'D05897 BENZOYL PEROXIDE-SALICYLIC ACID TOPICAL'
             2010 'D05899 CICLESONIDE NASAL'
             2011 'D05963 COAGULATION FACTOR IX' 2012 'D05964 ALOE VERA'
             2013 'D05973 CLINDAMYCIN-TRETINOIN TOPICAL'
             2014 'D05974 ANTIHEMOPHILIC FACTOR'
             2015 'D06008 BENZYL ALCOHOL TOPICAL'
             2016 'D06032 FLUOCINOLONE OTIC'
             2017 'D06058 DEXBROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             2018 'D06080 APAP/CAFFEINE/MAGNESIUM SALICYLATE'
             2019 'D06214 COLLAGEN' 2020 'D06227 IOXILAN'
             2021 'D06272 DIENOGEST-ESTRADIOL' 2022 'D06297 PALIPERIDONE'
             2023 'D06370 TURMERIC' 2024 'D06392 WHEAT DEXTRIN'
             2025 'D06507 CINNAMON' 2026 'D06635 MILNACIPRAN'
             2027 'D06648 ATROPINE/CPM/HYOSCYAMINE/PSE/SCOPOLAMINE'
             2028 'D06655 ALPHA-LIPOIC ACID'
             2029 'D06662 AMLODIPINE-VALSARTAN'
             2030 'D06663 LISDEXAMFETAMINE' 2031 'D06665 ALISKIREN'
             2032 'D06672 LAPATINIB' 2033 'D06673 ECULIZUMAB'
             2034 'D06720 METFORMIN-SITAGLIPTIN'
             2035 'D06831 RETAPAMULIN TOPICAL'
             2036 'D06833 ACETAMINOPHEN-ASPIRIN'
             2037 'D06834 BISMUTH SUBCITRATE POTASSIUM/METRONIDAZO/TCN'
             2038 'D06835 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             2039 'D06836 TEMSIROLIMUS' 2040 'D06841 AMBRISENTAN'
             2041 'D06842 ARMODAFINIL' 2042 'D06848 LUTEIN'
             2043 'D06851 AZITHROMYCIN OPHTHALMIC' 2044 'D06852 MARAVIROC'
             2045 'D06857 ACETIC/ANTIPYRINE/BENZOCAINE/POLYCOS OTIC'
             2046 'D06862 HELIUM' 2047 'D06864 HELIUM-OXYGEN'
             2048 'D06867 BIOTIN' 2049 'D06868 MENTHOL-ZINC OXIDE TOPICAL'
             2050 'D06872 APAP/CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             2051 'D06891 CHLOROPHYLLIN COPPER COM/PAPAIN/UREA TOPICAL'
             2052 'D06900 COLLAGEN TOPICAL'
             2053 'D06905 AMLODIPINE-OLMESARTAN'
             2054 'D06976 ASA/CHLORPHENIRAMINE/PHENYLEPHRINE'
             2055 'D07048 RALTEGRAVIR' 2056 'D07049 DORIPENEM'
             2057 'D07051 IXABEPILONE'
             2058 'D07055 CHLORPHENIRAMINE/GUAIFENESIN/METHSCOPOLAMI/PE'
             2059 'D07057 NILOTINIB'
             2060 'D07058 SULFACETAMIDE SODIUM/SULFUR/UREA TOPICAL'
             2061 'D07059 CITRIC ACID-POTASSIUM BICARBONATE'
             2062 'D07063 BROMPHENIRAMINE-DIPHENHYDRAMINE'
             2063 'D07065 BENZYL ALCOHOL-ZINC ACETATE TOPICAL'
             2064 'D07068 SAPROPTERIN' 2065 'D07069 RUFINAMIDE'
             2066 'D07075 PERMETHRIN/PIPERONYL BUTOXIDE/PYRETHR TOPICAL'
             2067 'D07076 ETRAVIRINE'
             2068 'D07077 ALISKIREN-HYDROCHLOROTHIAZIDE'
             2069 'D07110 NIACIN-SIMVASTATIN' 2070 'D07113 DESVENLAFAXINE'
             2071 'D07121 BENDAMUSTINE' 2072 'D07130 NAPROXEN-SUMATRIPTAN'
             2073 'D07131 REGADENOSON' 2074 'D07132 OLOPATADINE NASAL'
             2075 'D07134 CERTOLIZUMAB' 2076 'D07135 METHYLNALTREXONE'
             2077 'D07137 DABIGATRAN' 2078 'D07162 FESOTERODINE'
             2079 'D07292 METFORMIN-REPAGLINIDE'
             2080 'D07298 DIFLUPREDNATE OPHTHALMIC'
             2081 'D07300 CHLOPHEDIANOL/DEXCHLORPHENIRAMINE/PSE'
             2082 'D07302 CHLOPHEDIANOL/GUAIFENESIN/PSEUDOEPHEDRINE'
             2083 'D07306 BENZOCAINE-MENTHOL TOPICAL' 2084 'D07309 GENISTEIN'
             2085 'D07312 CLEVIDIPINE' 2086 'D07315 GLUTAMINE'
             2087 'D07320 ROMIPLOSTIM' 2088 'D07347 BIFIDOBACTERIUM INFANTIS'
             2089 'D07349 LACOSAMIDE'
             2090 'D07351 CARBETAPENTANE/PSEUDOEPHEDRINE/PYRILAMINE'
             2091 'D07354 SILODOSIN' 2092 'D07356 RIVAROXABAN'
             2093 'D07357 ELTROMBOPAG' 2094 'D07371 FENOFIBRIC ACID'
             2095 'D07374 BIMATOPROST TOPICAL OPHTHALMIC'
             2096 'D07382 ADAPALENE-BENZOYL PEROXIDE TOPICAL'
             2097 'D07385 HEPARIN FLUSH'
             2098 'D07387 HYDROCORTISONE/SALICYLIC ACID/SULFUR TOPICAL'
             2099 'D07395 DEXLANSOPRAZOLE' 2100 'D07396 USTEKINUMAB'
             2101 'D07397 FEBUXOSTAT'
             2102 'D07405 CARBETAPENTANE/PE/POTASSIUM GUAIACOLSULFONATE'
             2103 'D07409 PRASUGREL' 2104 'D07411 DEGARELIX'
             2105 'D07418 BENZOCAINE-RESORCINOL TOPICAL'
             2106 'D07435 GOLIMUMAB'
             2107 'D07440 AMLODIPINE/HYDROCHLOROTHIAZIDE/VALSARTAN'
             2108 'D07441 ILOPERIDONE' 2109 'D07447 TOLVAPTAN'
             2110 'D07453 TAPENTADOL' 2111 'D07458 DRONEDARONE'
             2112 'D07459 FERUMOXYTOL'
             2113 'D07464 INFLUENZA VIRUS VACCINE, H1N1, INACTIVATED'
             2114 'D07466 LIRAGLUTIDE' 2115 'D07467 SAXAGLIPTIN'
             2116 'D07472 MORPHINE-NALTREXONE' 2117 'D07473 ASENAPINE'
             2118 'D07481 POLY-L-LACTIC ACID'
             2119 'D07482 BEPOTASTINE OPHTHALMIC' 2120 'D07483 TELAVANCIN'
             2121 'D07485 INFLUENZA VIRUS VACCINE, H1N1, LIVE'
             2122 'D07486 ALISKIREN-VALSARTAN'
             2123 'D07491 DIPHENHYDRAMINE/LIDOCAINE/NYSTATIN TOPICAL'
             2124 'D07492 PRALATREXATE' 2125 'D07496 TOCILIZUMAB'
             2126 'D07498 AMLODIPINE-TELMISARTAN' 2127 'D07499 PAZOPANIB'
             2128 'D07505 COPPER' 2129 'D07509 OFATUMUMAB'
             2130 'D07518 SILVER TOPICAL' 2131 'D07546 DALFAMPRIDINE'
             2132 'D07550 DEXTROMETHORPHAN-DOXYLAMINE'
             2133 'D07565 IPILIMUMAB'
             2134 'D07586 PNEUMOCOCCAL 13-VALENT CONJUGATE VACCINE'
             2135 'D07589 BIOFLAVONOIDS-ZINC GLYCINATE'
             2136 'D07631 ESOMEPRAZOLE-NAPROXEN'
             2137 'D07634 DUTASTERIDE-TAMSULOSIN' 2138 'D07637 PITAVASTATIN'
             2139 'D07638 SIPULEUCEL-T' 2140 'D07640 DENOSUMAB'
             2141 'D07642 ANTI-THYMOCYTE GLOBULIN (RABBIT)'
             2142 'D07644 HEPATITIS B ADULT VACCINE'
             2143 'D07645 ONABOTULINUMTOXINA'
             2144 'D07646 ABOBOTULINUMTOXINA' 2145 'D07647 RACEPINEPHRINE'
             2146 'D07658 CABAZITAXEL'
             2147 'D07659 CAFFEINE-MAGNESIUM SALICYLATE'
             2148 'D07660 FORMOTEROL-MOMETASONE'
             2149 'D07668 AMLODIPINE/HYDROCHLOROTHIAZIDE/OLMESARTAN'
             2150 'D07670 ALCAFTADINE OPHTHALMIC' 2151 'D07684 ROFLUMILAST'
             2152 'D07688 PEGLOTICASE'
             2153 'D07691 MAGNESIUM/POTASSIUM/SODIUM SULFATES'
             2154 'D07692 FINGOLIMOD'
             2155 'D07697 DROSPIRENONE/ETHINYL ESTRADIOL/LEVOMEFOLATE'
             2156 'D07705 LURASIDONE' 2157 'D07706 CEFTAROLINE'
             2158 'D07709 METFORMIN-SAXAGLIPTIN' 2159 'D07715 TESAMORELIN'
             2160 'D07716 ERIBULIN' 2161 'D07727 PENICILLIN G BENZATHINE'
             2162 'D07729 PENICILLIN G POTASSIUM'
             2163 'D07730 PENICILLIN V POTASSIUM'
             2164 'D07738 BROMPHENIRAMINE/CHLOPHEDIANOL/PSE'
             2165 'D07740 VILAZODONE' 2166 'D07754 AZILSARTAN'
             2167 'D07756 BELIMUMAB'
             2168 'D07757 LIDOCAINE-SODIUM BICARBONATE'
             2169 'D07761 VANDETANIB' 2170 'D07766 ABIRATERONE'
             2171 'D07767 LINAGLIPTIN' 2172 'D07774 BOCEPREVIR'
             2173 'D07777 TELAPREVIR'
             2174 'D07796 EMTRICITABINE/RILPIVIRINE/TENOFOVIR'
             2175 'D07798 VEMURAFENIB' 2176 'I00031 XYLENE'
             2177 'I00035 TURPENTINE' 2178 'I00039 TRICHLOROETHANE'
             2179 'I00040 TOLUENE' 2180 'I00081 NAPHTHALENE'
             2181 'I00084 METHYLENE CHLORIDE' 2182 'I00088 METHANOL'
             2183 'I00102 FORMALDEHYDE' 2184 'I00106 ETHYLENE GLYCOL'
             2185 'I00108 ETHYL ETHER' 2186 'I00162 ACETONE'
             2187 'I00173 CYANOACRYLATE' 2188 'I00176 ISOBUTYL NITRITE'
             2189 'I00190 AEROSOL SPRAY-NOS' 2190 'I00196 BUTANE'
             2191 'I00198 TRICHLOROFLUOROMETHANE' 2192 'I00200 METHANE'
             2193 'I00201 PETROLEUM HYDROCARBONS'
             2194 'I00203 CARBON TETRACHLORIDE' 2195 'I00207 BUTYL ALCOHOL'
             2196 'I00209 ALPHA TERPINEOL' 2197 'I00210 FREON'
             2198 'I00211 DICHLOROBENZENE' 2199 'I00212 PROPOXUR'
             2200 'I00216 PROPANE' 2201 'I00219 PHENOLIC DISINFECTANTS'
             2202 'I00221 MINERAL SEAL OIL' 2203 'I00238 FLUORINE'
             2204 'I00240 HYDROCARBON' 2205 'I00247 CHLORINATED HYDROCARBONS'
             2206 'I00251 CRESOL' 2207 'I00256 BUTYL ACETATE'
             2208 'I00343 CLEANER/UNKNOWN COMPOSITION'
             2209 'I00345 COSMETIC/UNKNOWN COMPOSITION'
             2210 'I00348 PESTICIDE/UNKNOWN COMPOSITION'
             2211 'I00349 VOLATILE/UNKNOWN COMPONENTS'
             2212 'I00350 PAINT/UNKNOWN COMPOSITION'
             2213 'I00543 TRICHLOROETHANE/TRICHLOROETHYLENE'
             2214 'I00556 PETROLEUM HYDROCARBONS/TRICHLOROETHANE'
             2215 'I01283 ETHANOL-NP' 2216 'I01328 TRICHLOROMETHANE'
             2217 'I01336 FLUORINATED HYDROCARBONS' 2218 'I01337 ISOBUTANE'
             2219 'I01400 CHLORODIFLUOROMETHANE' 2220 'I01425 ETHYL ACETATE'
             2221 'J00001 LYSERGIC ACID DIETHYLAMIDE'
             2222 'J00002 METHYLENEDIOXYMETHAMPHETAMINE'
             2223 'J00004 FLUNITRAZEPAM' 2224 'J00020 BROMELAIN'
             2225 'J00023 NOMIFENSINE MALEATE' 2226 'J00027 MECLOZINE HCL'
             2227 'J00028 NITRAZEPAM' 2228 'J00030 ZOMEPIRAC'
             2229 'J00032 XYLAZINE' 2230 'J00033 VITAMIN K'
             2231 'J00036 L-TRYPTOPHAN' 2232 'J00049 SULFORIDAZINE'
             2233 'J00050 SULFADINE' 2234 'J00053 SALINE'
             2235 'J00061 PRAZEPAM' 2236 'J00064 PHENMETRAZINE HCL'
             2237 'J00066 PHENACETIN' 2238 'J00089 METHACYCLINE'
             2239 'J00090 MERBROMIN' 2240 'J00092 LUTREXIN'
             2241 'J00093 LORMETAZEPAM' 2242 'J00094 LACTOSE'
             2243 'J00095 KETOTIFEN FUMARATE' 2244 'J00096 INFANT FORMULA'
             2245 'J00097 HYDROXY-N-METHYLMORPHINAN'
             2246 'J00104 FENPROPOREX' 2247 'J00110 ERYTHRITYL TETRANITRATE'
             2248 'J00114 DYPYRONE' 2249 'J00120 DIHYDROMORPHINONE'
             2250 'J00122 ALDOSTERONE' 2251 'J00129 CHLOROPYRAMINE'
             2252 'J00148 CARBAMATE' 2253 'J00150 BROMAZEPAM'
             2254 'J00164 ACEPROMAZINE' 2255 'J00168 METHCATHINONE'
             2256 'J00171 CATHINONE' 2257 'J00174 METHYLENEDIOXYAMPHETAMINE'
             2258 'J00177 METHAQUALONE' 2259 'J00178 MESCALINE'
             2260 'J00179 PSILOCYBIN' 2261 'J00180 MORNING GLORY SEEDS'
             2262 'J00192 DATURA SAUVEOLENS'
             2263 'J00215 GAMMA BUTYROLACTONE' 2264 'J00248 EUCALYPTUS OIL'
             2265 'J00249 PEPPER' 2266 'J00263 DIMETHOXYMETHAMPHETAMINE'
             2267 'J00264 DATURA STRAMONIUM' 2268 'J00265 CANTHARIDINE'
             2269 'J00278 ISOPROPAMIDE IODIDE' 2270 'J00280 ALLOBARBITAL'
             2271 'J00290 CLOBENZOREX' 2272 'J00293 AMBROXOL'
             2273 'J00294 TETRAMYCIN' 2274 'J00295 RHODOMYCIN'
             2275 'J00331 ZOPICLONE' 2276 'J00336 MYCADRINE'
             2277 'J00337 POTASSIUM' 2278 'J00339 PYRETHRUM'
             2279 'J00356 ARECOLINE' 2280 'J00358 PHOSPHATIDYLETHANOLAMINE'
             2281 'J00360 CHLORPHENTERMINE' 2282 'J00362 BARBITURIC ACID'
             2283 'J00364 BARBITAL'
             2284 'J00369 BROMO-DIMETHOXYPHENETHYLAMINE'
             2285 'J00500 MARIJUANA/METHAMPHETAMINE'
             2286 'J00501 FORMALDEHYDE/MARIJUANA'
             2287 'J00502 COCAINE/METHAMPHETAMINE'
             2288 'J00504 COCAINE/MARIJUANA' 2289 'J00507 COCAINE/HEROIN'
             2290 'J00510 MARIJUANA/PHENCYCLIDINE'
             2291 'J00511 COCAINE/PHENCYCLIDINE'
             2292 'J00512 LYSERGIC ACID DIETHYLAMIDE/METHAMPHETAMINE'
             2293 'J00513 LYSERGIC ACID DIETHYLAMIDE/PHENCYCLIDINE'
             2294 'J00514 HEROIN/MARIJUANA'
             2295 'J00531 AMOBARBITAL/DEXTROAMPHETAMINE/THYROID DESICCATED'
             2296 'J00533 PENTOBARBITAL/PHENOBARBITAL'
             2297 'J00539 CAFFEINE/EPHEDRINE'
             2298 'J00540 ACETAMINOPHEN/CHLORZOXAZONE'
             2299 'J00558 ASPIRIN/CAFFEINE/CODEINE/PHENACETIN'
 2300 'J00566 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE/DEXTROMETHORPHAN/GUAIFENESIN'
             2301 'J00568 COCAINE/ETHANOL'
             2302 'J00572 SALICYLAMIDE/SCOPOLAMINE'
             2303 'J00577 CODEINE/TERPIN HYDRATE'
             2304 'J00591 ACETAMINOPHEN/CAFFEINE/CODEINE'
             2305 'J00593 AMYLASE/PROTEASE'
             2306 'J00594 ASPIRIN/CAFFEINE/CODEINE'
             2307 'J01003 ANTIFUNGALS-NOS'
             2308 'J01004 ANTIMALARIAL AGENTS-NOS'
             2309 'J01005 ANTITUBERCULOSIS AGENTS-NOS'
             2310 'J01006 ANTIVIRAL AGENTS-NOS'
             2311 'J01008 CEPHALOSPORINS-NOS' 2312 'J01010 MACROLIDES-NOS'
             2313 'J01011 ANTIBIOTICS-NOS' 2314 'J01012 PENICILLINS-NOS'
             2315 'J01013 QUINOLONES-NOS' 2316 'J01014 SULFONAMIDES-NOS'
             2317 'J01015 TETRACYCLINES-NOS'
             2318 'J01016 URINARY ANTI-INFECTIVES-NOS'
             2319 'J01017 AMINOGLYCOSIDES-NOS'
             2320 'J01018 ANTIHYPERLIPIDEMIC AGENTS-NOS'
             2321 'J01026 RADIOPHARMACEUTICALS-NOS'
             2322 'J01028 ANTITOXINS AND ANTIVENINS-NOS'
             2323 'J01029 BACTERIAL VACCINES-NOS'
             2324 'J01030 COLONY STIMULATING FACTORS-NOS'
             2325 'J01031 IMMUNE GLOBULINS-NOS'
             2326 'J01033 RECOMBINANT HUMAN ERYTHROPOIETINS-NOS'
             2327 'J01034 TOXOIDS-NOS' 2328 'J01035 VIRAL VACCINES-NOS'
             2329 'J01037 CARDIOVASCULAR AGENTS-NOS'
             2330 'J01039 ANGIOTENSIN CONVERTING ENZYME INHIBITORS-NOS'
             2331 'J01040 ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING-NOS'
             2332 'J01042 ANTIANGINAL AGENTS-NOS'
             2333 'J01043 ANTIARRHYTHMIC AGENTS-NOS'
             2334 'J01044 BETA-ADRENERGIC BLOCKING AGENTS-NOS'
             2335 'J01045 CALCIUM CHANNEL BLOCKING AGENTS-NOS'
             2336 'J01047 INOTROPIC AGENTS-NOS'
             2337 'J01049 PERIPHERAL VASODILATORS-NOS'
             2338 'J01050 VASODILATORS-NOS' 2339 'J01051 VASOPRESSORS-NOS'
             2340 'J01052 ANTIHYPERTENSIVE COMBINATIONS-NOS'
             2341 'J01053 ANGIOTENSIN II INHIBITORS-NOS'
             2342 'J01056 ANALGESICS-NOS'
             2343 'J01057 NARCOTIC ANALGESICS-NOS'
             2344 'J01058 NONSTEROIDAL ANTI-INFLAMMATORY AGENTS-NOS'
             2345 'J01059 SALICYLATES-NOS' 2346 'J01061 ANTICONVULSANTS-NOS'
             2347 'J01063 ANTIPARKINSON AGENTS-NOS'
             2348 'J01065 BARBITURATES-NOS' 2349 'J01066 BENZODIAZEPINES-NOS'
             2350 'J01067 ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS'
             2351 'J01068 CNS STIMULANTS-NOS'
             2352 'J01069 GENERAL ANESTHETICS-NOS'
             2353 'J01073 ANTIPSYCHOTICS-NOS'
             2354 'J01077 ANTICOAGULANTS-NOS'
             2355 'J01078 ANTIPLATELET AGENTS-NOS'
             2356 'J01081 THROMBOLYTICS-NOS'
             2357 'J01082 GASTROINTESTINAL AGENTS-NOS'
             2358 'J01083 ANTACIDS-NOS'
             2359 'J01084 ANTICHOLINERGICS/ANTISPASMODICS-NOS'
             2360 'J01085 ANTIDIARRHEALS-NOS'
             2361 'J01086 DIGESTIVE ENZYMES-NOS'
             2362 'J01088 GI STIMULANTS-NOS' 2363 'J01089 H2 ANTAGONISTS-NOS'
             2364 'J01090 LAXATIVES-NOS' 2365 'J01092 HORMONES-NOS'
             2366 'J01093 ADRENAL CORTICAL STEROIDS-NOS'
             2367 'J01094 ANTIDIABETIC AGENTS-NOS'
             2368 'J01096 SEX HORMONES-NOS' 2369 'J01098 THYROID DRUGS-NOS'
             2370 'J01099 IMMUNOSUPPRESSIVE AGENTS-NOS'
             2371 'J01101 ANTIDOTES-NOS' 2372 'J01102 CHELATING AGENTS-NOS'
             2373 'J01103 CHOLINERGIC MUSCLE STIMULANTS-NOS'
             2374 'J01104 LOCAL INJECTABLE ANESTHETICS-NOS'
             2375 'J01106 PSORALENS-NOS'
             2376 'J01107 RADIOCONTRAST AGENTS-NOS'
             2377 'J01108 GENITOURINARY TRACT AGENTS-NOS'
             2378 'J01111 IRON PRODUCTS-NOS'
             2379 'J01112 MINERALS AND ELECTROLYTES-NOS'
             2380 'J01113 ORAL NUTRITIONAL SUPPLEMENTS-NOS'
             2381 'J01115 VITAMIN AND MINERAL COMBINATIONS-NOS'
             2382 'J01116 INTRAVENOUS NUTRITIONAL PRODUCTS-NOS'
             2383 'J01118 ANTIHISTAMINES-NOS' 2384 'J01119 ANTITUSSIVES-NOS'
             2385 'J01120 BRONCHODILATORS-NOS'
             2386 'J01122 DECONGESTANTS-NOS' 2387 'J01123 EXPECTORANTS-NOS'
             2388 'J01124 RESPIRATORY AGENTS-NOS'
             2389 'J01125 RESPIRATORY INHALANT PRODUCTS-NOS'
             2390 'J01126 ANTIASTHMATIC COMBINATIONS-NOS'
             2391 'J01127 UPPER RESPIRATORY COMBINATIONS-NOS'
             2392 'J01129 ANORECTAL PREPARATIONS-NOS'
             2393 'J01130 ANTISEPTIC AND GERMICIDES-NOS'
             2394 'J01131 DERMATOLOGICAL AGENTS-NOS'
             2395 'J01134 TOPICAL ANESTHETICS-NOS'
             2396 'J01139 MOUTH AND THROAT PRODUCTS-NOS'
             2397 'J01143 STERILE IRRIGATING SOLUTIONS-NOS'
             2398 'J01145 PLASMA EXPANDERS-NOS'
             2399 'J01165 HMG-COA REDUCTASE INHIBITORS-NOS'
             2400 'J01170 MUSCLE RELAXANTS-NOS'
             2401 'J01174 ANDROGENS AND ANABOLIC STEROIDS-NOS'
             2402 'J01180 NARCOTIC ANALGESIC COMBINATIONS-NOS'
             2403 'J01181 ANTIRHEUMATICS-NOS'
             2404 'J01182 ANTIMIGRAINE AGENTS-NOS'
             2405 'J01183 ANTIGOUT AGENTS-NOS'
             2406 'J01206 BISPHOSPHONATES-NOS'
             2407 'J01208 NUTRACEUTICAL PRODUCTS-NOS'
             2408 'J01209 HERBAL PRODUCTS-NOS'
             2409 'J01229 FIBRIC ACID DERIVATIVES-NOS'
             2410 'J01231 LEUKOTRIENE MODIFIERS-NOS'
             2411 'J01235 NASAL PREPARATIONS-NOS'
             2412 'J01237 ANTIDEPRESSANTS-NOS' 2413 'J01241 ANOREXIANTS-NOS'
             2414 'J01243 INTERFERONS-NOS'
             2415 'J01244 MONOCLONAL ANTIBODIES-NOS'
             2416 'J01247 IMPOTENCE AGENTS-NOS'
             2417 'J01253 VAGINAL PREPARATIONS-NOS'
             2418 'J01254 ANTIPSORIATICS-NOS'
             2419 'J01256 PROTON PUMP INHIBITORS-NOS'
             2420 'J01261 DRUG UNKNOWN' 2421 'J01262 GAMMA HYDROXY BUTYRATE'
             2422 'J01271 PASSION FLOWER' 2423 'J01276 METHAPHENILENE'
             2424 'J01292 CODEINE COMBINATION-NOS'
             2425 'J01294 HALLUCINOGEN-NOS' 2426 'J01295 POLY-DRUGS'
             2427 'J01298 ANTINEOPLASTICS-NOS'
             2428 'J01300 ANTIBIOTICS/ANTINEOPLASTICS-NOS'
             2429 'J01301 HORMONES/ANTINEOPLASTICS-NOS'
             2430 'J01302 DIURETICS-NOS'
             2431 'J01303 ANTIEMETIC/ANTIVERTIGO AGENTS-NOS'
             2432 'J01305 VITAMINS-NOS'
             2433 'J01306 OPHTHALMIC PREPARATIONS-NOS'
             2434 'J01307 OTIC PREPARATIONS-NOS'
             2435 'J01308 ANALGESIC COMBINATIONS-NOS'
             2436 'J01309 COX-2 INHIBITOR-NOS'
             2437 'J01310 SSRI ANTIDEPRESSANTS-NOS'
             2438 'J01311 TRICYCLIC ANTIDEPRESSANTS-NOS'
             2439 'J01312 MONOAMINE OXIDASE INHIBITORS-NOS'
             2440 'J01313 PSYCHOTHERAPEUTIC COMBINATIONS-NOS'
             2441 'J01314 PHENOTHIAZINE ANTIPSYCHOTICS-NOS'
             2442 'J01315 ISOSORBIDE-NOS' 2443 'J01316 IMMUNIZATION-NOS'
             2444 'J01317 PHENCYCLIDINE COMBINATIONS-NOS'
             2445 'J01318 PNEUMOCOCCAL VACCINE' 2446 'J01319 FOLATE'
             2447 'J01320 PENTOBARBITAL/PHENYTOIN'
             2448 'J01322 BARBITAL SODIUM' 2449 'J01323 GADOLINIUM'
             2450 'J01324 HEPATITIS A VACCINE INACTIVATED' 2451 'J01327 ZINC'
             2452 'J01328 4-BROMO-2,5-DIMETHOXYPHENETHYLAMINE'
             2453 'J01329 2,5-DIMETHOXY-4-IODOPHENETHYLAMINE'
             2454 'J01330 AMPHETAMINE/COCAINE'
             2455 'J01331 METHANDROSTENLONE' 2456 'J01332 MARIJUANA/OPIUM'
             2457 'J01333 ALPROSTADIL/PAPAVERINE/PHENTOLAMINE'
             2458 'J01334 CYANIDE/HEROIN/STRYCHNINE'
             2459 'J01338 HYDROXYCODEINONE'
             2460 'J01340 2,5-DIMETHOXY-4-ETHYL-PHENETHYLAMINE'
             2461 'J01341 2,5-DIMETHOXY-4-(N)-PROPYLTHIOPHENETHYLAMINE'
             2462 'J01342 ANTI-RETROVIRAL AGENTS-NOS' 2463 'J01343 AROPLATIN'
             2464 'J01344 IDRAPARINUX'
             2465 'J01345 COCAINE/LYSERGIC ACID DIETHYLAMIDE'
             2466 'J01346 SALVIA DIVINORUM' 2467 'J01348 TIPIFARNIB'
             2468 'J01350 FLUOROURACIL-LEUCOVORIN'
             2469 'J01353 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE'
             2470 'J01354 CARPROFEN'
             2471 'J01355 RIFAMPIN/ISONIAZID/PYRAZINAMIDE/ETHAMBUTOL'
             2472 'J01356 THALLIUM' 2473 'J01357 POLYMYXIN B OTIC'
             2474 'J01358 ALLANTOIN/PRAMOXINE'
             2475 'J01359 COCAINE/MARIJUANA/FORMALDEHYDE'
             2476 'J01360 COCAINE/OPIUM'
            2477 'J01361 CYCLOPHOSPHAMIDE/DOXORUBICIN/VINCRISTINE/PREDNISONE'
             2478 'J01362 DIPHTHERIA/PERTUSISIS/POLIO/HAEMOPHILUS/TETANUS'
             2479 'J01363 ETORICOXIB' 2480 'J01365 FLUPENTHIXOL'
             2481 'J01366 FUSIDIC ACID' 2482 'J01367 HEROIN/METHAMPHETAMINE'
             2483 'J01368 IODINE CONTRAST AGENT'
             2484 'J01369 MARIJUANA/LYSERGIC ACID DIETHYLAMIDE'
             2485 'J01370 METHYLENEDIOXYMETHAMPHETAMINE/PSILOCYBIN'
             2486 'J01371 NEOMYCIN-POLYMYXIN B SULFATE OTIC'
             2487 'J01372 OXALIPLATIN/FLUOROURACIL/LEUCOVORIN'
             2488 'J01373 PHOSPHORUS'
             2489 'J01375 ADRENERGIC BRONCHODILATORS-NOS'
             2490 'J01379 OMEGA-6 POLYUNSATURATED FATTY ACIDS'
             2491 'J01380 TOPICAL ANTIFUNGALS-NOS'
             2492 'J01382 DEXTROMETHORPHAN COMBINATIONS-NOS'
             2493 'J01383 CLENBUTEROL' 2494 'J01386 FENTANYL/HEROIN'
             2495 'J01387 SULFONYLUREAS-NOS'
             2496 'J01388 COCAINE/FORMALDEHYDE'
             2497 'J01389 COCAINE/METHYLENEDIOXYMETHAMPHETAMINE'
             2498 'J01390 CYPROTEREONE ACETATE-ETHINYL ESTRADIOL'
             2499 'J01391 FAT DISSOLVING AGENTS-NOS'
             2500 'J01392 HEROIN/METHYLENEDIOXYMETHAMPHETAMINE'
             2501 'J01393 PROPOLIS' 2502 'J01394 SENNA COMBINATIONS-NOS'
             2503 'J01395 FENFLURAMINE/PHENTERMINE'
             2504 'J01396 ACNE AGENTS-NOS' 2505 'J01401 CLONIXIN'
             2506 'J01404 PROGESTINS-NOS' 2507 'J01405 RABIES VACCINE-NOS'
             2508 'J01411 INFLUENZA VIRUS VACCINE, H1N1-NOS'
             2509 'J01412 ACAI BERRY' 2510 'J01413 ALUM'
             2511 'J01414 AMMONIA' 2512 'J01415 BENZYLPIPERAZINE'
             2513 'J01416 BLUE GREEN ALGAE'
  2514 'J01417 CYCLOPHOSPHAMIDE/DOXORUBICIN/RITUXIMAB/VINCRISTINE/PREDNISONE'
             2515 'J01418 HOODIA' 2516 'J01419 HYALURONIC ACID'
             2517 'J01420 PAPAVERINE/PHENTOLAMINE' 2518 'J01421 STATIN-NOS'
             2519 'J01422 TEA TREE OIL'
             2520 'J01423 TRIFLUOROMETHYLPHENYLPIPERAZINE'
             2521 'J01424 4-METHYLMETHCATHINONE' 2522 'J01426 PHENAZEPAM'
             2523 'J01427 4-BROMO-3,6-DIMETHOXYBENZOCYCLOBUTEN'
             2524 'J01428 SYNTHETIC CANNABINOID' 2525 'J01429 AFATINIB'
             2526 'J01430 AMPHETAMINE/MARIJUANA' 2527 'J01431 AXITINIB'
             2528 'J01432 BLEOMYCIN/DACARBAZINE/DOXORUBICIN/VINBLASTINE'
             2529 'J01433 CAFFEINE COMBINATIONS-NOS'
             2530 'J01434 CAPECITABINE/OXALIPLATIN'
             2531 'J01435 COLLOIDAL SILVER'
             2532 'J01436 DOCETAXEL/FLUOROURACIL/OXALIPLATIN'
             2533 'J01437 DOMPERIDONE'
             2534 'J01438 FLUOROURACIL/IRINOTECAN/LEUCOVORIN'
             2535 'J01439 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE/RITUXIMAB'
             2536 'J01440 KETAMINE/MARIJUANA'
             2537 'J01441 L-TRYPTOPHAN/MELATONIN'
             2538 'J01442 MARIJUANA/OXYCODONE' 2539 'J01443 METAMIZOLE'
             2540 'J01444 3,4-METHYLENEDIOXYPYROVALERONE'
             2541 'J01445 PANOBINOSTAT' 2542 'J01446 PROBIOTICS-NOS'
             2543 'J01447 SPERMICIDES-NOS' 2544 'J01448 TILMICOSIN'
             2545 'J01449 AMPHETAMINES-NOS'
             2546 'J01450 ILLICIT COMBINATIONS-NOS' 2547 'J01451 VITAMIN D'
             2548 'J01454 TRENBOLONE'
             2549 'J01455 H. PYLORI ERADICATION AGENTS-NOS'
             2550 'J01456 SMOKING CESSATION AGENTS-NOS'
             2551 'J01457 4-BROMO-2,5-DIMETHOXYAMPHETAMINE'
             2552 'J01458 PROTEASE INHIBITORS-NOS'
             2553 'J01459 4-METHOXYMETHCATHINONE' 2554 'J01460 ELASTIN'
             2555 'J01461 TALCUM POWDER TOPICAL'
             2556 'J01462 METHYLENEDIOXYMETHAMPHETAMINE/CAFFEINE'
             2557 'J01463 ENERGY DRINK'
             2558 'J01464 CAFFEINE/MULTIVITAMIN NTA' /
   CATID_1_4 -7 'NOT APPLICABLE:(-7)' 1 'ANTI-INFECTIVES:(1)'
             20 'ANTINEOPLASTICS:(20)' 28 'BIOLOGICALS:(28)'
             40 'CARDIOVASCULAR AGENTS:(40)'
             57 'CENTRAL NERVOUS SYSTEM AGENTS:(57)'
             81 'COAGULATION MODIFIERS:(81)'
             87 'GASTROINTESTINAL AGENTS:(87)'
             97 'HORMONES/HORMONE MODIFIERS:(97)'
             105 'MISCELLANEOUS AGENTS:(105)'
             113 'GENITOURINARY TRACT AGENTS:(113)'
             115 'NUTRITIONAL PRODUCTS:(115)' 122 'RESPIRATORY AGENTS:(122)'
             133 'TOPICAL AGENTS:(133)' 153 'PLASMA EXPANDERS:(153)'
             218 'ALTERNATIVE MEDICINES:(218)'
             242 'PSYCHOTHERAPEUTIC AGENTS:(242)'
             254 'IMMUNOLOGIC AGENTS:(254)' 331 'RADIOLOGIC AGENTS:(331)'
             358 'METABOLIC AGENTS:(358)' 365 'MEDICAL GAS:(365)'
             2006 'DRUG UNKNOWN:(2006)' 2041 'NON-PHARMACEUTICAL:(2041)' /
   CATID_2_4 -7 'NOT APPLICABLE:(-7)' 2 'AMEBICIDES:(2)'
             3 'ANTHELMINTICS:(3)' 4 'ANTIFUNGALS:(4)'
             5 'ANTIMALARIAL AGENTS:(5)' 6 'ANTITUBERCULOSIS AGENTS:(6)'
             7 'ANTIVIRAL AGENTS:(7)' 8 'CARBAPENEMS:(8)'
             9 'CEPHALOSPORINS:(9)' 10 'LEPROSTATICS:(10)'
             11 'MACROLIDE DERIVATIVES:(11)'
             12 'MISCELLANEOUS ANTIBIOTICS:(12)' 13 'PENICILLINS:(13)'
             14 'QUINOLONES:(14)' 15 'SULFONAMIDES:(15)'
             16 'TETRACYCLINES:(16)' 17 'URINARY ANTI-INFECTIVES:(17)'
             18 'AMINOGLYCOSIDES:(18)' 19 'ANTIHYPERLIPIDEMIC AGENTS:(19)'
             21 'ALKYLATING AGENTS:(21)' 22 'ANTINEOPLASTIC ANTIBIOTICS:(22)'
             23 'ANTIMETABOLITES:(23)' 24 'ANTINEOPLASTIC HORMONES:(24)'
             25 'MISCELLANEOUS ANTINEOPLASTICS:(25)'
             26 'MITOTIC INHIBITORS:(26)' 27 'RADIOPHARMACEUTICALS:(27)'
             30 'ANTITOXINS AND ANTIVENINS:(30)' 33 'IMMUNE GLOBULINS:(33)'
             34 'IN VIVO DIAGNOSTIC BIOLOGICALS:(34)'
             36 'RECOMBINANT HUMAN ERYTHROPOIETINS:(36)'
             41 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(41)'
             42 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(42)'
             43 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(43)'
             44 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(44)'
             45 'ANTIANGINAL AGENTS:(45)' 46 'ANTIARRHYTHMIC AGENTS:(46)'
             47 'BETA-ADRENERGIC BLOCKING AGENTS:(47)'
             48 'CALCIUM CHANNEL BLOCKING AGENTS:(48)' 49 'DIURETICS:(49)'
             50 'INOTROPIC AGENTS:(50)'
             51 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(51)'
             52 'PERIPHERAL VASODILATORS:(52)' 53 'VASODILATORS:(53)'
             54 'VASOPRESSORS:(54)' 55 'ANTIHYPERTENSIVE COMBINATIONS:(55)'
             56 'ANGIOTENSIN II INHIBITORS:(56)' 58 'ANALGESICS:(58)'
             64 'ANTICONVULSANTS:(64)'
             65 'ANTIEMETIC/ANTIVERTIGO AGENTS:(65)'
             66 'ANTIPARKINSON AGENTS:(66)'
             67 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(67)'
             71 'CNS STIMULANTS:(71)' 72 'GENERAL ANESTHETICS:(72)'
             73 'MUSCLE RELAXANTS:(73)'
             80 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(80)'
             82 'ANTICOAGULANTS:(82)' 83 'ANTIPLATELET AGENTS:(83)'
             84 'HEPARIN ANTAGONISTS:(84)'
             85 'MISCELLANEOUS COAGULATION MODIFIERS:(85)'
             86 'THROMBOLYTICS:(86)' 88 'ANTACIDS:(88)'
             90 'ANTIDIARRHEALS:(90)' 91 'DIGESTIVE ENZYMES:(91)'
             92 'GALLSTONE SOLUBILIZING AGENTS:(92)' 93 'GI STIMULANTS:(93)'
             94 'H2 ANTAGONISTS:(94)' 95 'LAXATIVES:(95)'
             96 'MISCELLANEOUS GI AGENTS:(96)'
             98 'ADRENAL CORTICAL STEROIDS:(98)'
             99 'ANTIDIABETIC AGENTS:(99)' 100 'MISCELLANEOUS HORMONES:(100)'
             101 'SEX HORMONES:(101)' 103 'THYROID HORMONES:(103)'
             104 'IMMUNOSUPPRESSIVE AGENTS:(104)' 106 'ANTIDOTES:(106)'
             107 'CHELATING AGENTS:(107)'
             108 'CHOLINERGIC MUSCLE STIMULANTS:(108)'
             109 'LOCAL INJECTABLE ANESTHETICS:(109)'
             110 'MISCELLANEOUS UNCATEGORIZED AGENTS:(110)'
             111 'PSORALENS:(111)' 112 'RADIOCONTRAST AGENTS:(112)'
             114 'ILLICIT (STREET) DRUGS:(114)' 116 'IRON PRODUCTS:(116)'
             117 'MINERALS AND ELECTROLYTES:(117)'
             118 'ORAL NUTRITIONAL SUPPLEMENTS:(118)' 119 'VITAMINS:(119)'
             120 'VITAMIN AND MINERAL COMBINATIONS:(120)'
             121 'INTRAVENOUS NUTRITIONAL PRODUCTS:(121)'
             123 'ANTIHISTAMINES:(123)' 124 'ANTITUSSIVES:(124)'
             125 'BRONCHODILATORS:(125)' 127 'DECONGESTANTS:(127)'
             128 'EXPECTORANTS:(128)'
             129 'MISCELLANEOUS RESPIRATORY AGENTS:(129)'
             130 'RESPIRATORY INHALANT PRODUCTS:(130)'
             131 'ANTIASTHMATIC COMBINATIONS:(131)'
             132 'UPPER RESPIRATORY COMBINATIONS:(132)'
             134 'ANORECTAL PREPARATIONS:(134)'
             135 'ANTISEPTIC AND GERMICIDES:(135)'
             136 'DERMATOLOGICAL AGENTS:(136)'
             146 'MOUTH AND THROAT PRODUCTS:(146)'
             147 'OPHTHALMIC PREPARATIONS:(147)'
             148 'OTIC PREPARATIONS:(148)'
             150 'STERILE IRRIGATING SOLUTIONS:(150)'
             151 'VAGINAL PREPARATIONS:(151)' 192 'ANTIRHEUMATICS:(192)'
             194 'ANTIGOUT AGENTS:(194)' 219 'NUTRACEUTICAL PRODUCTS:(219)'
             220 'HERBAL PRODUCTS:(220)' 240 'LINCOMYCIN DERIVATIVES:(240)'
             243 'LEUKOTRIENE MODIFIERS:(243)' 247 'NASAL PREPARATIONS:(247)'
             249 'ANTIDEPRESSANTS:(249)' 251 'ANTIPSYCHOTICS:(251)'
             253 'ANOREXIANTS:(253)' 263 'IMPOTENCE AGENTS:(263)'
             264 'URINARY ANTISPASMODICS:(264)'
             265 'URINARY PH MODIFIERS:(265)'
             266 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(266)'
             270 'ANTIPSORIATICS:(270)' 272 'PROTON PUMP INHIBITORS:(272)'
             273 'LUNG SURFACTANTS:(273)' 277 '5-AMINOSALICYLATES:(277)'
             284 'VISCOSUPPLEMENTATION AGENTS:(284)'
             288 '5-ALPHA-REDUCTASE INHIBITORS:(288)'
             289 'ANTIHYPERURICEMIC AGENTS:(289)'
             293 'GLUCOSE ELEVATING AGENTS:(293)' 295 'GROWTH HORMONES:(295)'
             303 'AGENTS FOR PULMONARY HYPERTENSION:(303)'
             312 'CHOLINERGIC AGONISTS:(312)'
             313 'CHOLINESTERASE INHIBITORS:(313)' 315 'GLYCYLCYCLINES:(315)'
             318 'INSULIN-LIKE GROWTH FACTOR:(318)'
             319 'VASOPRESSIN ANTAGONISTS:(319)'
             320 'SMOKING CESSATION AGENTS:(320)'
             324 'ANTINEOPLASTIC INTERFERONS:(324)'
             325 'SCLEROSING AGENTS:(325)' 332 'RADIOLOGIC ADJUNCTS:(332)'
             340 'ALDOSTERONE RECEPTOR ANTAGONISTS:(340)'
             342 'RENIN INHIBITORS:(342)'
             354 'H. PYLORI ERADICATION AGENTS:(354)'
             355 'FUNCTIONAL BOWEL DISORDER AGENTS:(355)'
             357 'GROWTH HORMONE RECEPTOR BLOCKERS:(357)'
             359 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(359)'
             360 'LYSOSOMAL ENZYMES:(360)'
             361 'MISCELLANEOUS METABOLIC AGENTS:(361)'
             363 'PROBIOTICS:(363)' 377 'PROLACTIN INHIBITORS:(377)'
             378 'DRUGS USED IN ALCOHOL DEPENDENCE:(378)'
             383 'ANTINEOPLASTIC DETOXIFYING AGENTS:(383)'
             384 'PLATELET-STIMULATING AGENTS:(384)'
             390 'HEMATOPOIETIC STEM CELL MOBILIZER:(390)'
             397 'MULTIKINASE INHIBITORS:(397)'
             398 'BCR-ABL TYROSINE KINASE INHIBITORS:(398)'
             399 'CD52 MONOCLONAL ANTIBODIES:(399)'
             400 'CD33 MONOCLONAL ANTIBODIES:(400)'
             401 'CD20 MONOCLONAL ANTIBODIES:(401)'
             402 'VEGF/VEGFR INHIBITORS:(402)' 403 'MTOR INHIBITORS:(403)'
             404 'EGFR INHIBITORS:(404)' 405 'HER2 INHIBITORS:(405)'
             406 'GLYCOPEPTIDE ANTIBIOTICS:(406)'
             408 'HISTONE DEACETYLASE INHIBITORS:(408)'
             409 'BONE RESORPTION INHIBITORS:(409)'
             410 'ADRENAL CORTICOSTEROID INHIBITORS:(410)'
             411 'CALCITONIN:(411)' 412 'UTEROTONIC AGENTS:(412)'
             413 'ANTIGONADOTROPIC AGENTS:(413)'
             414 'ANTIDIURETIC HORMONES:(414)'
             416 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(416)'
             417 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(417)'
             418 'PARATHYROID HORMONE AND ANALOGS:(418)'
             419 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(419)'
             422 'ANTITHYROID AGENTS:(422)'
             426 'SYNTHETIC OVULATION STIMULANTS:(426)'
             427 'TOCOLYTIC AGENTS:(427)'
             428 'PROGESTERONE RECEPTOR MODULATORS:(428)'
             431 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(431)'
             433 'CATECHOLAMINES:(433)'
             435 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(435)'
             437 'IMMUNOSTIMULANTS:(437)'
             447 'CD30 MONOCLONAL ANTIBODIES:(447)' 2042 'INHALANT:(2042)'
             2051 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(2051)' /
   CATID_3_4 -7 'NOT APPLICABLE:(-7)' 31 'BACTERIAL VACCINES:(31)'
             32 'COLONY STIMULATING FACTORS:(32)' 38 'VIRAL VACCINES:(38)'
             61 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(61)'
             68 'BARBITURATES:(68)' 69 'BENZODIAZEPINES:(69)'
             70 'MISCELLANEOUS ANXIOLYTICS, SEDATIVES AND HYPNOTICS:(70)'
             74 'NEUROMUSCULAR BLOCKING AGENTS:(74)'
             76 'MISCELLANEOUS ANTIDEPRESSANTS:(76)'
             77 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(77)'
             79 'PSYCHOTHERAPEUTIC COMBINATIONS:(79)'
             89 'ANTICHOLINERGICS/ANTISPASMODICS:(89)'
             102 'CONTRACEPTIVES:(102)' 126 'METHYLXANTHINES:(126)'
             137 'TOPICAL ANTI-INFECTIVES:(137)' 138 'TOPICAL STEROIDS:(138)'
             139 'TOPICAL ANESTHETICS:(139)'
             140 'MISCELLANEOUS TOPICAL AGENTS:(140)'
             141 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(141)'
             143 'TOPICAL ACNE AGENTS:(143)'
             144 'TOPICAL ANTIPSORIATICS:(144)' 149 'SPERMICIDES:(149)'
             154 'LOOP DIURETICS:(154)'
             155 'POTASSIUM-SPARING DIURETICS:(155)'
             156 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(156)'
             157 'CARBONIC ANHYDRASE INHIBITORS:(157)'
             158 'MISCELLANEOUS DIURETICS:(158)'
             159 'FIRST GENERATION CEPHALOSPORINS:(159)'
             160 'SECOND GENERATION CEPHALOSPORINS:(160)'
             161 'THIRD GENERATION CEPHALOSPORINS:(161)'
             162 'FOURTH GENERATION CEPHALOSPORINS:(162)'
             163 'OPHTHALMIC ANTI-INFECTIVES:(163)'
             164 'OPHTHALMIC GLAUCOMA AGENTS:(164)'
             165 'OPHTHALMIC STEROIDS:(165)'
             166 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(166)'
             167 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(167)'
             168 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(168)'
             169 'MISCELLANEOUS OPHTHALMIC AGENTS:(169)'
             170 'OTIC ANTI-INFECTIVES:(170)'
             171 'OTIC STEROIDS WITH ANTI-INFECTIVES:(171)'
             172 'MISCELLANEOUS OTIC AGENTS:(172)'
             173 'HMG-COA REDUCTASE INHIBITORS:(173)'
             174 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(174)'
             175 'PROTEASE INHIBITORS:(175)' 176 'NRTIS:(176)'
             177 'MISCELLANEOUS ANTIVIRALS:(177)'
             178 'SKELETAL MUSCLE RELAXANTS:(178)'
             179 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(179)'
             180 'ADRENERGIC BRONCHODILATORS:(180)'
             181 'BRONCHODILATOR COMBINATIONS:(181)'
             182 'ANDROGENS AND ANABOLIC STEROIDS:(182)'
             183 'ESTROGENS:(183)' 184 'GONADOTROPINS:(184)'
             185 'PROGESTINS:(185)' 186 'SEX HORMONE COMBINATIONS:(186)'
             187 'MISCELLANEOUS SEX HORMONES:(187)'
             193 'ANTIMIGRAINE AGENTS:(193)'
             195 '5HT3 RECEPTOR ANTAGONISTS:(195)'
             196 'PHENOTHIAZINE ANTIEMETICS:(196)'
             197 'ANTICHOLINERGIC ANTIEMETICS:(197)'
             198 'MISCELLANEOUS ANTIEMETICS:(198)'
             199 'HYDANTOIN ANTICONVULSANTS:(199)'
             200 'SUCCINIMIDE ANTICONVULSANTS:(200)'
             201 'BARBITURATE ANTICONVULSANTS:(201)'
             202 'OXAZOLIDINEDIONE ANTICONVULSANTS:(202)'
             203 'BENZODIAZEPINE ANTICONVULSANTS:(203)'
             204 'MISCELLANEOUS ANTICONVULSANTS:(204)'
             205 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(205)'
             206 'MISCELLANEOUS ANTIPARKINSON AGENTS:(206)'
             208 'SSRI ANTIDEPRESSANTS:(208)'
             209 'TRICYCLIC ANTIDEPRESSANTS:(209)'
             210 'PHENOTHIAZINE ANTIPSYCHOTICS:(210)'
             211 'PLATELET AGGREGATION INHIBITORS:(211)'
             212 'GLYCOPROTEIN PLATELET INHIBITORS:(212)'
             213 'SULFONYLUREAS:(213)' 214 'BIGUANIDES:(214)'
             215 'INSULIN:(215)' 216 'ALPHA-GLUCOSIDASE INHIBITORS:(216)'
             217 'BISPHOSPHONATES:(217)'
             222 'PENICILLINASE RESISTANT PENICILLINS:(222)'
             223 'ANTIPSEUDOMONAL PENICILLINS:(223)'
             224 'AMINOPENICILLINS:(224)'
             225 'BETA-LACTAMASE INHIBITORS:(225)'
             226 'NATURAL PENICILLINS:(226)' 227 'NNRTIS:(227)'
             228 'ADAMANTANE ANTIVIRALS:(228)' 229 'PURINE NUCLEOSIDES:(229)'
             230 'AMINOSALICYLATES:(230)'
             231 'NICOTINIC ACID DERIVATIVES:(231)'
             232 'RIFAMYCIN DERIVATIVES:(232)'
             233 'STREPTOMYCES DERIVATIVES:(233)'
             234 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(234)'
             235 'POLYENES:(235)' 236 'AZOLE ANTIFUNGALS:(236)'
             237 'MISCELLANEOUS ANTIFUNGALS:(237)'
             238 'ANTIMALARIAL QUINOLINES:(238)'
             239 'MISCELLANEOUS ANTIMALARIALS:(239)'
             241 'FIBRIC ACID DERIVATIVES:(241)'
             244 'NASAL LUBRICANTS AND IRRIGATIONS:(244)'
             245 'NASAL STEROIDS:(245)'
             246 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(246)'
             248 'TOPICAL EMOLLIENTS:(248)'
             250 'MONOAMINE OXIDASE INHIBITORS:(250)'
             252 'BILE ACID SEQUESTRANTS:(252)' 256 'INTERFERONS:(256)'
             261 'HEPARINS:(261)' 262 'COUMARINS AND INDANEDIONES:(262)'
             267 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(267)'
             268 'VAGINAL ANTI-INFECTIVES:(268)'
             269 'MISCELLANEOUS VAGINAL AGENTS:(269)'
             271 'THIAZOLIDINEDIONES:(271)'
             274 'CARDIOSELECTIVE BETA BLOCKERS:(274)'
             275 'NON-CARDIOSELECTIVE BETA BLOCKERS:(275)'
             276 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(276)'
             278 'COX-2 INHIBITORS:(278)'
             279 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(279)'
             280 'THIOXANTHENES:(280)' 281 'NEURAMINIDASE INHIBITORS:(281)'
             282 'MEGLITINIDES:(282)' 283 'THROMBIN INHIBITORS:(283)'
             285 'FACTOR XA INHIBITORS:(285)' 286 'MYDRIATICS:(286)'
             287 'OPHTHALMIC ANESTHETICS:(287)'
             290 'TOPICAL ANTIBIOTICS:(290)' 291 'TOPICAL ANTIVIRALS:(291)'
             292 'TOPICAL ANTIFUNGALS:(292)'
             296 'INHALED CORTICOSTEROIDS:(296)' 297 'MUCOLYTICS:(297)'
             298 'MAST CELL STABILIZERS:(298)'
             299 'ANTICHOLINERGIC BRONCHODILATORS:(299)'
             300 'CORTICOTROPIN:(300)' 301 'GLUCOCORTICOIDS:(301)'
             302 'MINERALOCORTICOIDS:(302)' 304 'MACROLIDES:(304)'
             305 'KETOLIDES:(305)'
             306 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(306)'
             307 'TETRACYCLIC ANTIDEPRESSANTS:(307)'
             308 'SSNRI ANTIDEPRESSANTS:(308)'
             309 'MISCELLANEOUS ANTIDIABETIC AGENTS:(309)'
             310 'ECHINOCANDINS:(310)'
             311 'DIBENZAZEPINE ANTICONVULSANTS:(311)'
             314 'ANTIDIABETIC COMBINATIONS:(314)'
             316 'CHOLESTEROL ABSORPTION INHIBITORS:(316)'
             317 'ANTIHYPERLIPIDEMIC COMBINATIONS:(317)'
             321 'OPHTHALMIC DIAGNOSTIC AGENTS:(321)'
             322 'OPHTHALMIC SURGICAL AGENTS:(322)'
             327 'ANTIVIRAL COMBINATIONS:(327)'
             328 'ANTIMALARIAL COMBINATIONS:(328)'
             329 'ANTITUBERCULOSIS COMBINATIONS:(329)'
             330 'ANTIVIRAL INTERFERONS:(330)'
             333 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(333)'
             334 'LYMPHATIC STAINING AGENTS:(334)'
             335 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(335)'
             336 'NON-IODINATED CONTRAST MEDIA:(336)'
             337 'ULTRASOUND CONTRAST MEDIA:(337)'
             338 'DIAGNOSTIC RADIOPHARMACEUTICALS:(338)'
             339 'THERAPEUTIC RADIOPHARMACEUTICALS:(339)'
             341 'ATYPICAL ANTIPSYCHOTICS:(341)'
             345 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(345)'
             346 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(346)'
             347 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(347)'
             348 'TRIAZINE ANTICONVULSANTS:(348)'
             349 'CARBAMATE ANTICONVULSANTS:(349)'
             350 'PYRROLIDINE ANTICONVULSANTS:(350)'
             351 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(351)'
             352 'UREA ANTICONVULSANTS:(352)'
             353 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(353)'
             356 'SEROTONINERGIC NEUROENTERIC MODULATORS:(356)'
             362 'CHLORIDE CHANNEL ACTIVATORS:(362)'
             364 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(364)'
             366 'INTEGRASE STRAND TRANSFER INHIBITOR:(366)'
             368 'NON-IONIC IODINATED CONTRAST MEDIA:(368)'
             369 'IONIC IODINATED CONTRAST MEDIA:(369)'
             370 'OTIC STEROIDS:(370)'
             371 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(371)'
             372 'AMYLIN ANALOGS:(372)' 373 'INCRETIN MIMETICS:(373)'
             374 'CARDIAC STRESSING AGENTS:(374)'
             375 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(375)'
             379 'FIFTH GENERATION CEPHALOSPORINS:(379)'
             380 'TOPICAL DEBRIDING AGENTS:(380)'
             381 'TOPICAL DEPIGMENTING AGENTS:(381)'
             382 'TOPICAL ANTIHISTAMINES:(382)'
             385 'GROUP I ANTIARRHYTHMICS:(385)'
             387 'GROUP III ANTIARRHYTHMICS:(387)'
             389 'GROUP V ANTIARRHYTHMICS:(389)' 392 'OTIC ANESTHETICS:(392)'
             393 'CERUMENOLYTICS:(393)' 394 'TOPICAL ASTRINGENTS:(394)'
             395 'TOPICAL KERATOLYTICS:(395)'
             415 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(415)'
             432 'VACCINE COMBINATIONS:(432)'
             439 'OTHER IMMUNOSTIMULANTS:(439)'
             440 'THERAPEUTIC VACCINES:(440)'
             441 'CALCINEURIN INHIBITORS:(441)'
             442 'TNF ALFA INHIBITORS:(442)'
             443 'INTERLEUKIN INHIBITORS:(443)'
             444 'SELECTIVE IMMUNOSUPPRESSANTS:(444)'
             445 'OTHER IMMUNOSUPPRESSANTS:(445)'
             448 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(448)'
             2005 'ALCOHOL IN COMBINATION:(2005)'
             2007 'MISCELLANEOUS BRONCHODILATORS:(2007)'
             2008 'MISCELLANEOUS NASAL PREPARATIONS:(2008)'
             2030 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(2030)'
             2031 'MISCELLANEOUS HALLUCINOGENS:(2031)'
             2032 'ILLICIT MAJOR SUBSTANCE OF ABUSE:(2032)'
             2033 'ILLICIT COMBINATIONS:(2033)'
             2034 'ILLICIT AND OTHER COMBINATIONS:(2034)'
             2036 'MISCELLANEOUS CEPHALOSPORINS:(2036)'
             2043 'VOLATILE AGENT:(2043)' 2044 'NITRITES:(2044)'
             2045 'CHLORO-FLUORO-HYDROCARBONS:(2045)'
             2046 'MISCELLANEOUS MUSCLE RELAXANTS:(2046)'
             2047 'NARCOTIC ANALGESICS/COMBINATIONS:(2047)'
             2048 'SALICYLATES/COMBINATIONS:(2048)'
             2049 'MISCELLANEOUS ANALGESIC/COMBINATIONS:(2049)'
             2050 'ANALGESIC COMBINATIONS NTA:(2050)'
             2052 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(2052)'
             2053 'MISCELLANEOUS MACROLIDE:(2053)'
             2054 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(2054)'
             2055 'MISCELLANEOUS RADIOCONTRAST AGENTS:(2055)'
             2056 'MISCELLANEOUS RADIOPHARMACEUTICALS:(2056)' /
   ROUTE_4   -9 'MISSING:(-9)' -8 'NOT DOCUMENTED:(-8)'
             -7 'NOT APPLICABLE:(-7)' 1 'ORAL:(1)' 2 'INJECTED:(2)'
             3 'INHALED, SNIFFED, SNORTED:(3)' 4 'SMOKED:(4)' 5 'OTHER:(5)'
             6 'TRANSDERMAL:(6)' 98 'MULTIPLE ROUTES FOR THIS DRUG:(98)' /
   TOXTEST_4 -9 'MISSING:(-9)' -7 'NOT APPLICABLE:(-7)'
             1 'CONFIRMED TEST:(1)' 2 'NOT CONFIRMED:(2)' /
   SDLED_1_4 -7 'NOT APPLICABLE:(-7)' 1 'MAJOR SUBSTANCES OF ABUSE:(1)'
             17 'OTHER SUBSTANCES:(17)' /
   SDLED_2_4 -7 'NOT APPLICABLE:(-7)' 2 'ALCOHOL:(2)'
             2.5 'NON-ALCOHOL ILLICITS:(2.5)'
             18 'PSYCHOTHERAPEUTIC AGENTS:(18)' 33 'CNS AGENTS:(33)'
             50 'RESPIRATORY AGENTS:(50)' 57 'CARDIOVASCULAR AGENTS:(57)'
             63 'ALTERNATIVE MEDICINES:(63)' 64 'ANTI-INFECTIVES:(64)'
             65 'ANTINEOPLASTICS:(65)' 66 'BIOLOGICALS:(66)'
             67 'COAGULATION MODIFIERS:(67)'
             68 'GASTROINTESTINAL AGENTS:(68)'
             69 'GENITOURINARY TRACT AGENTS:(69)' 70 'HORMONES:(70)'
             71 'IMMUNOLOGIC AGENTS:(71)' 72 'MEDICAL GAS:(72)'
             73 'METABOLIC AGENTS:(73)' 74 'MISCELLANEOUS AGENTS:(74)'
             75 'NUTRITIONAL PRODUCTS:(75)' 76 'PLASMA EXPANDERS:(76)'
             77 'RADIOLOGIC AGENTS:(77)' 78 'TOPICAL AGENTS:(78)'
             79 'DRUG UNKNOWN:(79)' /
   SDLED_3_4 -7 'NOT APPLICABLEL:(-7.00)' 3 'COCAINE:(3)' 4 'HEROIN:(4)'
             5 'CANNABINOIDS:(5)' 5.5 'STIMULANTS:(5.5)'
             8 'MDMA (ECSTASY):(8)' 8.1 'GHB:(8.1)'
             8.2 'FLUNITRAZEPAM (ROHYPNOL):(8.2)' 9 'KETAMINE:(9)'
             10 'LSD:(10)' 11 'PCP:(11)'
             12 'MISCELLANEOUS HALLUCINOGENS:(12)' 15 'INHALANTS:(15)'
             16 'COMBINATIONS NTA:(16)' 19 'ANTIDEPRESSANTS:(19)'
             24 'ANTIPSYCHOTICS:(24)' 34 'ANALGESICS:(34)'
             43 'ANOREXIANTS:(43)' 44 'ANTICONVULSANTS:(44)'
             45 'ANTIEMETIC/ANTIVERTIGO AGENTS:(45)'
             46 'ANTIPARKINSON AGENTS:(46)'
             46.3 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.3)'
             46.5 'CNS STIMULANTS:(46.5)'
             46.7 'DRUGS USED IN ALCOHOL DEPENDENCE:(46.7)'
             47 'GENERAL ANESTHETICS:(47)' 48 'MUSCLE RELAXANTS:(48)'
             49 'MISCELLANEOUS CNS AGENTS:(49)' 51 'ANTIHISTAMINES:(51)'
             52 'BRONCHODILATORS:(52)' 53 'DECONGESTANTS:(53)'
             54 'EXPECTORANTS:(54)'
             54.5 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(54.5)'
             55 'UPPER RESPIRATORY COMBINATIONS:(55)'
             56 'RESPIRATORY AGENTS NTA:(56)'
             58 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(58)'
             59 'BETA-ADRENERGIC BLOCKING AGENTS:(59)'
             60 'CALCIUM CHANNEL BLOCKING AGENTS:(60)' 61 'DIURETICS:(61)'
             61.3 'RENIN INHIBITORS:(61.3)'
             61.5 'VASOPRESSIN ANTAGONISTS:(61.5)'
             62 'CARDIOVASCULAR AGENTS NTA:(62)'
             63.1 'HERBAL PRODUCTS:(63.1)'
             63.2 'NUTRACEUTICAL PRODUCTS:(63.2)' 63.3 'PROBIOTICS:(63.3)'
             64.01 'AMEBICIDES:(64.01)' 64.02 'AMINOGLYCOSIDES:(64.02)'
             64.03 'ANTHELMINTICS:(64.03)' 64.04 'ANTIFUNGALS:(64.04)'
             64.05 'ANTIMALARIAL AGENTS:(64.05)'
             64.06 'ANTITUBERCULOSIS AGENTS:(64.06)'
             64.07 'ANTIVIRAL AGENTS:(64.07)' 64.08 'CARBAPENEMS:(64.08)'
             64.09 'CEPHALOSPORINS:(64.09)'
             64.1 'GLYCOPEPTIDE ANTIBIOTICS:(64.1)'
             64.11 'GLYCYLCYCLINES:(64.11)' 64.12 'LEPROSTATICS:(64.12)'
             64.13 'LINCOMYCIN DERIVATIVES:(64.13)'
             64.14 'MACROLIDE DERIVATIVES:(64.14)'
             64.15 'PENICILLINS:(64.15)' 64.16 'QUINOLONES:(64.16)'
             64.17 'SULFONAMIDES:(64.17)' 64.18 'TETRACYCLINES:(64.18)'
             64.19 'URINARY ANTI-INFECTIVES:(64.19)'
             64.99 'MISCELLANEOUS ANTIBIOTICS:(64.99)'
             65.01 'ALKYLATING AGENTS:(65.01)'
             65.02 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(65.02)'
             65.03 'ANTIMETABOLITES:(65.03)'
             65.04 'ANTINEOPLASTIC ANTIBIOTICS:(65.04)'
             65.05 'ANTINEOPLASTIC DETOXIFYING AGENTS:(65.05)'
             65.06 'ANTINEOPLASTIC HORMONES:(65.06)'
             65.07 'ANTINEOPLASTIC INTERFERONS:(65.07)'
             65.08 'BCR-ABL TYROSINE KINASE INHIBITORS:(65.08)'
             65.09 'CD20 MONOCLONAL ANTIBODIES:(65.09)'
             65.11 'CD33 MONOCLONAL ANTIBODIES:(65.11)'
             65.12 'CD52 MONOCLONAL ANTIBODIES:(65.12)'
             65.13 'EGFR INHIBITORS:(65.13)' 65.14 'HER2 INHIBITORS:(65.14)'
             65.15 'HISTONE DEACETYLASE INHIBITORS:(65.15)'
             65.16 'MITOTIC INHIBITORS:(65.16)'
             65.17 'MTOR INHIBITORS:(65.17)'
             65.18 'MULTIKINASE INHIBITORS:(65.18)'
             65.2 'VEGF/VEGFR INHIBITORS:(65.2)'
             65.99 'MISCELLANEOUS ANTINEOPLASTICS:(65.99)'
             66.01 'ANTITOXINS AND ANTIVENINS:(66.01)'
             66.04 'IN VIVO DIAGNOSTIC BIOLOGICALS:(66.04)'
             66.05 'RECOMBINANT HUMAN ERYTHROPOIETINS:(66.05)'
             67.01 'ANTICOAGULANTS:(67.01)'
             67.02 'ANTIPLATELET AGENTS:(67.02)'
             67.03 'HEPARIN ANTAGONISTS:(67.03)'
             67.04 'PLATELET-STIMULATING AGENTS:(67.04)'
             67.05 'THROMBOLYTICS:(67.05)'
             67.06 'MISCELLANEOUS COAGULATION MODIFIERS:(67.06)'
             68.01 '5-AMINOSALICYLATES:(68.01)' 68.02 'ANTACIDS:(68.02)'
             68.04 'ANTIDIARRHEALS:(68.04)' 68.05 'DIGESTIVE ENZYMES:(68.05)'
             68.06 'FUNCTIONAL BOWEL DISORDER AGENTS:(68.06)'
             68.07 'GALLSTONE SOLUBILIZING AGENTS:(68.07)'
             68.08 'GI STIMULANTS:(68.08)'
             68.09 'H. PYLORI ERADICATION AGENTS:(68.09)'
             68.1 'H2 ANTAGONISTS:(68.1)' 68.11 'LAXATIVES:(68.11)'
             68.12 'PROTON PUMP INHIBITORS:(68.12)'
             68.13 'MISCELLANEOUS GI AGENTS:(68.13)'
             69.01 'IMPOTENCE AGENTS:(69.01)'
             69.02 'TOCOLYTIC AGENTS:(69.02)'
             69.03 'URINARY ANTISPASMODICS:(69.03)'
             69.04 'URINARY PH MODIFIERS:(69.04)'
             69.05 'UTEROTONIC AGENTS:(69.05)'
             69.99 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(69.99)'
             70.01 '5-ALPHA-REDUCTASE INHIBITORS:(70.01)'
             70.02 'ADRENAL CORTICAL STEROIDS:(70.02)'
             70.05 'ANTIDIURETIC HORMONES:(70.05)'
             70.06 'ANTIGONADOTROPIC AGENTS:(70.06)'
             70.07 'ANTITHYROID AGENTS:(70.07)' 70.09 'CALCITONIN:(70.09)'
             70.11 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(70.11)'
             70.12 'GROWTH HORMONE RECEPTOR BLOCKERS:(70.12)'
             70.13 'GROWTH HORMONES:(70.13)'
             70.15 'INSULIN-LIKE GROWTH FACTOR:(70.15)'
             70.16 'PARATHYROID HORMONE AND ANALOGS:(70.16)'
             70.17 'PROGESTERONE RECEPTOR MODULATORS:(70.17)'
             70.18 'PROLACTIN INHIBITORS:(70.18)'
             70.19 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(70.19)'
             70.2 'SEX HORMONES:(70.2)'
             70.21 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(70.21)'
             70.22 'SYNTHETIC OVULATION STIMULANTS:(70.22)'
             70.23 'THYROID HORMONES:(70.23)'
             70.99 'MISCELLANEOUS HORMONES:(70.99)'
             71.01 'IMMUNE GLOBULINS:(71.01)'
             71.02 'IMMUNOSTIMULANTS:(71.02)'
             71.03 'IMMUNOSUPPRESSIVE AGENTS:(71.03)'
             71.99 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(71.99)'
             73.01 'ANTIDIABETIC AGENTS:(73.01)'
             73.02 'ANTIGOUT AGENTS:(73.02)'
             73.03 'ANTIHYPERLIPIDEMIC AGENTS:(73.03)'
             73.04 'ANTIHYPERURICEMIC AGENTS:(73.04)'
             73.05 'BONE RESORPTION INHIBITORS:(73.05)'
             73.06 'GLUCOSE ELEVATING AGENTS:(73.06)'
             73.07 'LYSOSOMAL ENZYMES:(73.07)'
             73.08 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(73.08)'
             73.99 'MISCELLANEOUS METABOLIC AGENTS:(73.99)'
             74.01 'ANTIDOTES:(74.01)' 74.04 'ANTIPSORIATICS:(74.04)'
             74.05 'ANTIRHEUMATICS:(74.05)' 74.06 'CHELATING AGENTS:(74.06)'
             74.07 'CHOLINERGIC MUSCLE STIMULANTS:(74.07)'
             74.11 'LOCAL INJECTABLE ANESTHETICS:(74.11)'
             74.13 'PSORALENS:(74.13)'
             74.17 'SMOKING CESSATION AGENTS:(74.17)'
             74.18 'VISCOSUPPLEMENTATION AGENTS:(74.18)'
             74.19 'MISCELLANEOUS UNCATEGORIZED AGENTS:(74.19)'
             75.01 'INTRAVENOUS NUTRITIONAL PRODUCTS:(75.01)'
             75.02 'IRON PRODUCTS:(75.02)'
             75.03 'MINERALS AND ELECTROLYTES:(75.03)'
             75.04 'ORAL NUTRITIONAL SUPPLEMENTS:(75.04)'
             75.05 'VITAMIN AND MINERAL COMBINATIONS:(75.05)'
             75.06 'VITAMINS:(75.06)' 77.01 'RADIOCONTRAST AGENTS:(77.01)'
             77.02 'RADIOLOGIC ADJUNCTS:(77.02)'
             77.03 'RADIOPHARMACEUTICALS:(77.03)'
             78.01 'ANORECTAL PREPARATIONS:(78.01)'
             78.02 'ANTISEPTIC AND GERMICIDES:(78.02)'
             78.03 'DERMATOLOGICAL AGENTS:(78.03)'
             78.04 'MOUTH AND THROAT PRODUCTS:(78.04)'
             78.05 'NASAL PREPARATIONS:(78.05)'
             78.06 'OPHTHALMIC PREPARATIONS:(78.06)'
             78.07 'OTIC PREPARATIONS:(78.07)'
             78.08 'STERILE IRRIGATING SOLUTIONS:(78.08)'
             78.09 'VAGINAL PREPARATIONS:(78.09)' /
   SDLED_4_4 -7 'NOT APPLICABLE:(-7.00)' 5.01 'MARIJUANA:(5.01)'
             5.02 'SYNTHETIC CANNABINOIDS:(5.02)' 6 'AMPHETAMINES:(6)'
             7 'METHAMPHETAMINE:(7)' 7.1 'OTHER STIMULANTS:(7.1)'
             20 'MAO INHIBITORS:(20)'
             20.4 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(20.4)'
             20.7 'SSNRI ANTIDEPRESSANTS:(20.7)'
             21 'SSRI ANTIDEPRESSANTS:(21)'
             21.5 'TETRACYCLIC ANTIDEPRESSANTS:(21.5)'
             22 'TRICYCLIC ANTIDEPRESSANTS:(22)'
             23 'MISCELLANEOUS ANTIDEPRESSANTS:(23)'
             25 'ATYPICAL ANTIPSYCHOTICS:(25)'
             26 'PHENOTHIAZINE ANTIPSYCHOTICS:(26)'
             26.5 'PSYCHOTHERAPEUTIC COMBINATIONS:(26.5)'
             26.7 'THIOXANTHENES:(26.7)'
             27 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(27)'
             35 'ANTIMIGRAINE AGENTS:(35)' 36 'COX-2 INHIBITORS:(36)'
             36.5 'OPIATES/OPIOIDS:(36.5)'
             39 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(39)'
             40.5 'SALICYLATES/COMBINATIONS:(40.5)'
             41.5 'MISCELLANEOUS ANALGESICS/COMBINATIONS:(41.5)'
             42.5 'ANALGESIC COMBINATIONS NTA:(42.5)'
             43.01 'PHENYLPROPANOLAMINE:(43.01)'
             43.02 'ANOREXIANTS-NOS:(43.02)' 43.09 'ANOREXIANTS NTA:(43.09)'
             44.01 'BARBITURATE ANTICONVULSANTS:(44.01)'
             44.02 'BENZODIAZEPINE ANTICONVULSANTS:(44.02)'
             44.03 'CARBAMATE ANTICONVULSANTS:(44.03)'
             44.04 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(44.04)'
             44.05 'DIBENZAZEPINE ANTICONVULSANTS:(44.05)'
             44.06 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(44.06)'
             44.07 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(44.07)'
             44.08 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(44.08)'
             44.09 'HYDANTOIN ANTICONVULSANTS:(44.09)'
             44.11 'OXAZOLIDINEDIONE ANTICONVULSANTS:(44.11)'
             44.12 'PYRROLIDINE ANTICONVULSANTS:(44.12)'
             44.13 'SUCCINIMIDE ANTICONVULSANTS:(44.13)'
             44.14 'TRIAZINE ANTICONVULSANTS:(44.14)'
             44.99 'MISCELLANEOUS ANTICONVULSANTS:(44.99)'
             45.01 '5HT3 RECEPTOR ANTAGONISTS:(45.01)'
             45.02 'ANTICHOLINERGIC ANTIEMETICS:(45.02)'
             45.03 'PHENOTHIAZINE ANTIEMETICS:(45.03)'
             45.04 'MISCELLANEOUS ANTIEMETICS:(45.04)'
             46.01 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(46.01)'
             46.02 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(46.02)'
             46.03 'MISCELLANEOUS ANTIPARKINSON AGENTS:(46.03)'
             46.31 'BARBITURATES:(46.31)' 46.32 'BENZODIAZEPINES:(46.32)'
             46.33 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.33)'
             46.501 'AMPHETAMINE-DEXTROAMPHETAMINE:(46.501)'
             46.502 'BENZPHETAMINE:(46.502)' 46.503 'CAFFEINE:(46.503)'
             46.504 'DEXTROAMPHETAMINE:(46.504)'
             46.505 'METHYLPHENIDATE:(46.505)'
             46.509 'CNS STIMULANTS NTA:(46.509)'
             48.01 'NEUROMUSCULAR BLOCKING AGENTS:(48.01)'
             48.02 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(48.02)'
             48.03 'SKELETAL MUSCLE RELAXANTS:(48.03)'
             48.04 'MISCELLANEOUS MUSCLE RELAXANTS:(48.04)'
             49.01 'CHOLINERGIC AGONISTS:(49.01)'
             49.02 'CHOLINESTERASE INHIBITORS:(49.02)'
             49.03 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(49.03)'
             52.01 'ADRENERGIC BRONCHODILATORS:(52.01)'
             52.02 'ANTICHOLINERGIC BRONCHODILATORS:(52.02)'
             52.03 'BRONCHODILATOR COMBINATIONS:(52.03)'
             52.04 'METHYLXANTHINES:(52.04)'
             52.05 'MISCELLANEOUS BRONCHODILATORS:(52.05)'
             56.01 'ANTIASTHMATIC COMBINATIONS:(56.01)'
             56.02 'ANTITUSSIVES:(56.02)'
             56.03 'LEUKOTRIENE MODIFIERS:(56.03)'
             56.05 'RESPIRATORY INHALANT PRODUCTS:(56.05)'
             56.06 'MISCELLANEOUS RESPIRATORY AGENTS:(56.06)'
             58.01 'CLONIDINE:(58.01)'
             58.09 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING NTA:(58.09)'
             59.01 'CARDIOSELECTIVE BETA BLOCKERS:(59.01)'
             59.02 'NON-CARDIOSELECTIVE BETA BLOCKERS:(59.02)'
             59.03 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(59.03)'
             61.01 'CARBONIC ANHYDRASE INHIBITORS:(61.01)'
             61.02 'LOOP DIURETICS:(61.02)'
             61.03 'POTASSIUM-SPARING DIURETICS:(61.03)'
             61.04 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(61.04)'
             61.05 'MISCELLANEOUS DIURETICS:(61.05)'
             62.01 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(62.01)'
             62.02 'AGENTS FOR PULMONARY HYPERTENSION:(62.02)'
             62.03 'ALDOSTERONE RECEPTOR ANTAGONISTS:(62.03)'
             62.04 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(62.04)'
             62.05 'ANGIOTENSIN II INHIBITORS:(62.05)'
             62.06 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(62.06)'
             62.07 'ANTIANGINAL AGENTS:(62.07)'
             62.08 'ANTIARRHYTHMIC AGENTS:(62.08)'
             62.09 'ANTIHYPERTENSIVE COMBINATIONS:(62.09)'
             62.1 'CATECHOLAMINES:(62.1)' 62.11 'INOTROPIC AGENTS:(62.11)'
             62.12 'PERIPHERAL VASODILATORS:(62.12)'
             62.13 'SCLEROSING AGENTS:(62.13)' 62.14 'VASODILATORS:(62.14)'
             62.15 'VASOPRESSORS:(62.15)'
             62.99 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(62.99)'
             64.041 'AZOLE ANTIFUNGALS:(64.041)'
             64.042 'ECHINOCANDINS:(64.042)' 64.043 'POLYENES:(64.043)'
             64.044 'MISCELLANEOUS ANTIFUNGALS:(64.044)'
             64.051 'ANTIMALARIAL COMBINATIONS:(64.051)'
             64.052 'ANTIMALARIAL QUINOLINES:(64.052)'
             64.053 'MISCELLANEOUS ANTIMALARIALS:(64.053)'
             64.061 'AMINOSALICYLATES:(64.061)'
             64.062 'ANTITUBERCULOSIS COMBINATIONS:(64.062)'
             64.063 'NICOTINIC ACID DERIVATIVES:(64.063)'
             64.064 'RIFAMYCIN DERIVATIVES:(64.064)'
             64.065 'STREPTOMYCES DERIVATIVES:(64.065)'
             64.066 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(64.066)'
             64.0701 'ADAMANTANE ANTIVIRALS:(64.0701)'
             64.0702 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(64.0702)'
             64.0703 'ANTIVIRAL COMBINATIONS:(64.0703)'
             64.0704 'ANTIVIRAL INTERFERONS:(64.0704)'
             64.0705 'INTEGRASE STRAND TRANSFER INHIBITOR:(64.0705)'
             64.0706 'NEURAMINIDASE INHIBITORS:(64.0706)'
             64.0707 'NNRTIS:(64.0707)' 64.0708 'NRTIS:(64.0708)'
             64.0709 'PROTEASE INHIBITORS:(64.0709)'
             64.071 'PURINE NUCLEOSIDES:(64.071)'
             64.0711 'MISCELLANEOUS ANTIVIRALS:(64.0711)'
             64.091 'FIRST GENERATION CEPHALOSPORINS:(64.091)'
             64.092 'SECOND GENERATION CEPHALOSPORINS:(64.092)'
             64.093 'THIRD GENERATION CEPHALOSPORINS:(64.093)'
             64.094 'FOURTH GENERATION CEPHALOSPORINS:(64.094)'
             64.095 'FIFTH GENERATION CEPHALOSPORINS:(64.095)'
             64.096 'MISCELLANEOUS CEPHALOSPORINS:(64.096)'
             64.141 'KETOLIDES:(64.141)' 64.142 'MACROLIDES:(64.142)'
             64.143 'MISCELLANEOUS MACROLIDES:(64.143)'
             64.151 'AMINOPENICILLINS:(64.151)'
             64.152 'ANTIPSEUDOMONAL PENICILLINS:(64.152)'
             64.153 'BETA-LACTAMASE INHIBITORS:(64.153)'
             64.154 'NATURAL PENICILLINS:(64.154)'
             64.155 'PENICILLINASE RESISTANT PENICILLINS:(64.155)'
             67.011 'COUMARINS AND INDANEDIONES:(67.011)'
             67.012 'FACTOR XA INHIBITORS:(67.012)'
             67.013 'HEPARINS:(67.013)' 67.014 'THROMBIN INHIBITORS:(67.014)'
             67.021 'GLYCOPROTEIN PLATELET INHIBITORS:(67.021)'
             67.022 'PLATELET AGGREGATION INHIBITORS:(67.022)'
             68.061 'ANTICHOLINERGICS/ANTISPASMODICS:(68.061)'
             68.062 'CHLORIDE CHANNEL ACTIVATORS:(68.062)'
             68.063 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(68.063)'
             68.064 'SEROTONINERGIC NEUROENTERIC MODULATORS:(68.064)'
             70.021 'CORTICOTROPIN:(70.021)'
             70.022 'GLUCOCORTICOIDS:(70.022)'
             70.023 'MINERALOCORTICOIDS:(70.023)'
             70.029 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(70.029)'
             70.202 'ANDROGENS AND ANABOLIC STEROIDS:(70.202)'
             70.203 'CONTRACEPTIVES:(70.203)' 70.204 'ESTROGENS:(70.204)'
             70.205 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(70.205)'
             70.206 'GONADOTROPINS:(70.206)' 70.207 'PROGESTINS:(70.207)'
             70.208 'SEX HORMONE COMBINATIONS:(70.208)'
             70.209 'MISCELLANEOUS SEX HORMONES:(70.209)'
             71.021 'BACTERIAL VACCINES:(71.021)'
             71.022 'COLONY STIMULATING FACTORS:(71.022)'
             71.023 'INTERFERONS:(71.023)'
             71.025 'THERAPEUTIC VACCINES:(71.025)'
             71.026 'VACCINE COMBINATIONS:(71.026)'
             71.027 'VIRAL VACCINES:(71.027)'
             71.029 'OTHER IMMUNOSTIMULANTS:(71.029)'
             71.031 'CALCINEURIN INHIBITORS:(71.031)'
             71.032 'INTERLEUKIN INHIBITORS:(71.032)'
             71.033 'SELECTIVE IMMUNOSUPPRESSANTS:(71.033)'
             71.034 'TNF ALFA INHIBITORS:(71.034)'
             71.039 'OTHER IMMUNOSUPPRESSANTS:(71.039)'
             73.0101 'ALPHA-GLUCOSIDASE INHIBITORS:(73.0101)'
             73.0102 'AMYLIN ANALOGS:(73.0102)'
             73.0103 'ANTIDIABETIC COMBINATIONS:(73.0103)'
             73.0104 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(73.0104)'
             73.0105 'INCRETIN MIMETICS:(73.0105)'
             73.0106 'INSULIN:(73.0106)' 73.0107 'MEGLITINIDES:(73.0107)'
             73.0108 'BIGUANIDES:(73.0108)' 73.0109 'SULFONYLUREAS:(73.0109)'
             73.011 'THIAZOLIDINEDIONES:(73.011)'
             73.019 'MISCELLANEOUS ANTIDIABETIC AGENTS:(73.019)'
             73.031 'ANTIHYPERLIPIDEMIC COMBINATIONS:(73.031)'
             73.032 'BILE ACID SEQUESTRANTS:(73.032)'
             73.033 'CHOLESTEROL ABSORPTION INHIBITORS:(73.033)'
             73.034 'FIBRIC ACID DERIVATIVES:(73.034)'
             73.035 'HMG-COA REDUCTASE INHIBITORS:(73.035)'
             73.036 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(73.036)'
             73.051 'BISPHOSPHONATES:(73.051)'
             73.059 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(73.059)'
             77.011 'IONIC IODINATED CONTRAST MEDIA:(77.011)'
             77.012 'LYMPHATIC STAINING AGENTS:(77.012)'
             77.013 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(77.013)'
             77.014 'NON-IODINATED CONTRAST MEDIA:(77.014)'
             77.015 'NON-IONIC IODINATED CONTRAST MEDIA:(77.015)'
             77.016 'ULTRASOUND CONTRAST MEDIA:(77.016)'
             77.017 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(77.017)'
             77.019 'MISCELLANEOUS RADIOCONTRAST AGENTS:(77.019)'
             77.021 'CARDIAC STRESSING AGENTS:(77.021)'
             77.031 'DIAGNOSTIC RADIOPHARMACEUTICALS:(77.031)'
             77.032 'THERAPEUTIC RADIOPHARMACEUTICALS:(77.032)'
             77.033 'MISCELLANEOUS RADIOPHARMACEUTICALS:(77.033)'
             78.0301 'TOPICAL ACNE AGENTS:(78.0301)'
             78.0302 'TOPICAL ANESTHETICS:(78.0302)'
             78.0303 'TOPICAL ANTIBIOTICS:(78.0303)'
             78.0304 'TOPICAL ANTIFUNGALS:(78.0304)'
             78.0305 'TOPICAL ANTIHISTAMINES:(78.0305)'
             78.0306 'TOPICAL ANTI-INFECTIVES:(78.0306)'
             78.0307 'TOPICAL ANTIPSORIATICS:(78.0307)'
             78.0308 'TOPICAL ANTIVIRALS:(78.0308)'
             78.0309 'TOPICAL ASTRINGENTS:(78.0309)'
             78.031 'TOPICAL DEBRIDING AGENTS:(78.031)'
             78.0311 'TOPICAL DEPIGMENTING AGENTS:(78.0311)'
             78.0312 'TOPICAL EMOLLIENTS:(78.0312)'
             78.0313 'TOPICAL KERATOLYTICS:(78.0313)'
             78.0314 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(78.0314)'
             78.0315 'TOPICAL STEROIDS:(78.0315)'
             78.0316 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(78.0316)'
             78.0399 'MISCELLANEOUS TOPICAL AGENTS:(78.0399)'
             78.051 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(78.051)'
             78.053 'NASAL LUBRICANTS AND IRRIGATIONS:(78.053)'
             78.054 'NASAL STEROIDS:(78.054)'
             78.055 'MISCELLANEOUS NASAL PREPARATIONS:(78.055)'
             78.0602 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(78.0602)'
             78.061 'MYDRIATICS:(78.061)'
             78.062 'OPHTHALMIC ANESTHETICS:(78.062)'
             78.063 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(78.063)'
             78.064 'OPHTHALMIC ANTI-INFECTIVES:(78.064)'
             78.065 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(78.065)'
             78.066 'OPHTHALMIC DIAGNOSTIC AGENTS:(78.066)'
             78.067 'OPHTHALMIC GLAUCOMA AGENTS:(78.067)'
             78.068 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(78.068)'
             78.069 'OPHTHALMIC STEROIDS:(78.069)'
             78.0691 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(78.0691)'
             78.0692 'OPHTHALMIC SURGICAL AGENTS:(78.0692)'
             78.0693 'MISCELLANEOUS OPHTHALMIC AGENTS:(78.0693)'
             78.071 'CERUMENOLYTICS:(78.071)'
             78.072 'OTIC ANESTHETICS:(78.072)'
             78.073 'OTIC ANTI-INFECTIVES:(78.073)'
             78.074 'OTIC STEROIDS:(78.074)'
             78.075 'OTIC STEROIDS WITH ANTI-INFECTIVES:(78.075)'
             78.076 'MISCELLANEOUS OTIC AGENTS:(78.076)'
             78.091 'SPERMICIDES:(78.091)'
             78.092 'VAGINAL ANTI-INFECTIVES:(78.092)'
             78.093 'MISCELLANEOUS VAGINAL AGENTS:(78.093)' /
   SDLED_5_4 -7 'NOT APPLICABLE' 20.41 'NEFAZODONE:(20.41)'
             20.42 'TRAZODONE:(20.42)' 20.71 'DESVENLAFAXINE:(20.71)'
             20.72 'DULOXETINE:(20.72)' 20.73 'VENLAFAXINE:(20.73)'
             20.79 'SSNRI ANTIDEPRESSANTS NTA:(20.79)'
             21.01 'CITALOPRAM:(21.01)' 21.02 'FLUOXETINE:(21.02)'
             21.03 'FLUVOXAMINE:(21.03)' 21.04 'PAROXETINE:(21.04)'
             21.05 'SERTRALINE:(21.05)'
             21.09 'SSRI ANTIDEPRESSANTS NTA:(21.09)'
             21.51 'MAPROTILINE:(21.51)' 21.52 'MIRTAZAPINE:(21.52)'
             22.01 'AMITRIPTYLINE:(22.01)' 22.02 'DESIPRAMINE:(22.02)'
             22.03 'DOXEPIN:(22.03)' 22.04 'IMIPRAMINE:(22.04)'
             22.05 'NORTRIPTYLINE:(22.05)'
             22.06 'TRICYCLIC ANTIDEPRESSANTS-NOS:(22.06)'
             22.09 'TRICYCLIC ANTIDEPRESSANTS NTA:(22.09)'
             23.01 'BUPROPION:(23.01)' 23.06 'ANTIDEPRESSANTS-NOS:(23.06)'
             23.09 'MISCELLANEOUS ANTIDEPRESSANTS NTA:(23.09)'
             25.01 'CLOZAPINE:(25.01)' 25.02 'OLANZAPINE:(25.02)'
             25.03 'QUETIAPINE:(25.03)' 25.04 'RISPERIDONE:(25.04)'
             25.09 'ATYPICAL ANTIPSYCHOTICS NTA:(25.09)'
             26.01 'CHLORPROMAZINE:(26.01)' 26.02 'FLUPHENAZINE:(26.02)'
             26.03 'PERPHENAZINE:(26.03)' 26.04 'PROCHLORPERAZINE:(26.04)'
             26.05 'THIORIDAZINE:(26.05)' 26.06 'TRIFLUPROMAZINE:(26.06)'
             26.09 'PHENOTHIAZINE ANTIPSYCHOTICS NTA:(26.09)'
             27.01 'HALOPERIDOL:(27.01)' 27.02 'LITHIUM:(27.02)'
             27.09 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS NTA:(27.09)'
             36.75 'OPIATES/OPIOIDS, UNSPECIFIED:(36.75)'
             37.5 'NARCOTIC ANALGESICS:(37.5)'
             39.01 'IBUPROFEN/COMBINATIONS:(39.01)'
             39.02 'NAPROXEN/COMBINATIONS:(39.02)'
             39.03 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS NTA:(39.03)'
             40.501 'ASPIRIN/COMBINATIONS:(40.501)'
             40.502 'SALICYLATES-NOS:(40.502)'
             40.503 'SALICYLATES/COMBINATIONS NTA:(40.503)'
             41.501 'ACETAMINOPHEN/COMBINATIONS:(41.501)'
             41.502 'TRAMADOL/COMBINATIONS:(41.502)'
             41.505 'ANALGESICS-NOS:(41.505)'
             41.506 'MISCELLANEOUS ANALGESIC/COMBINATIONS NTA:(41.506)'
             44.041 'TOPIRAMATE:(44.041)'
           44.049 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS NTA:(44.049)'
             44.051 'CARBAMAZEPINE:(44.051)' 44.052 'OXCARBAZEPINE:(44.052)'
             44.053 'RUFINAMIDE:(44.053)' 44.061 'DIVALPROEX SODIUM:(44.061)'
             44.062 'VALPROIC ACID:(44.062)' 44.071 'GABAPENTIN:(44.071)'
             44.079 'GAMMA-AMINOBUTYRIC ACID ANALOGS NTA:(44.079)'
             44.091 'PHENYTOIN:(44.091)'
             44.099 'HYDANTOIN ANTICONVULSANTS NTA:(44.099)'
             46.011 'BENZTROPINE:(46.011)'
             46.019 'ANTICHOLINERGIC ANTIPARKINSON AGENTS NTA:(46.019)'
             46.3101 'PHENOBARBITAL:(46.3101)'
             46.3102 'BARBITURATES-NOS:(46.3102)'
             46.3109 'BARBITURATES NTA:(46.3109)'
             46.3201 'ALPRAZOLAM:(46.3201)'
             46.3202 'CHLORDIAZEPOXIDE:(46.3202)'
             46.3203 'CLONAZEPAM:(46.3203)' 46.3204 'CLORAZEPATE:(46.3204)'
             46.3205 'DIAZEPAM:(46.3205)' 46.3206 'FLURAZEPAM:(46.3206)'
             46.3207 'LORAZEPAM:(46.3207)' 46.3208 'OXAZEPAM:(46.3208)'
             46.3209 'TEMAZEPAM:(46.3209)' 46.321 'TRIAZOLAM:(46.321)'
             46.3211 'BENZODIAZEPINES-NOS:(46.3211)'
             46.3219 'BENZODIAZEPINES NTA:(46.3219)'
             46.3301 'BUSPIRONE:(46.3301)'
             46.3302 'CHLORAL HYDRATE:(46.3302)'
             46.3303 'DIPHENHYDRAMINE:(46.3303)'
             46.3304 'DOXYLAMINE:(46.3304)' 46.3305 'HYDROXYZINE:(46.3305)'
             46.3306 'ZOLPIDEM:(46.3306)'
             46.3307 'ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS:(46.3307)'
          46.3309 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS NTA:(46.3309)'
             46.5091 'CAFFEINE/MULTIVITAMIN:(46.5091)'
             46.5092 'OTHER CNS STIMULANTS NTA:(46.5092)'
             48.031 'CARISOPRODOL:(48.031)' 48.032 'CHLORZOXAZONE:(48.032)'
             48.033 'CYCLOBENZAPRINE:(48.033)' 48.034 'METAXALONE:(48.034)'
             48.035 'METHOCARBAMOL:(48.035)' 48.036 'TIZANIDINE:(48.036)'
             48.039 'SKELETAL MUSCLE RELAXANTS NTA:(48.039)'
             56.052 'INHALED CORTICOSTEROIDS:(56.052)'
             56.053 'MAST CELL STABILIZERS:(56.053)'
             56.054 'MUCOLYTICS:(56.054)'
             56.059 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(56.059)'
             59.011 'ATENOLOL:(59.011)'
             59.019 'CARDIOSELECTIVE BETA BLOCKERS NTA:(59.019)'
             59.021 'PROPRANOLOL:(59.021)'
             59.029 'NON-CARDIOSELECTIVE BETA BLOCKERS NTA:(59.029)'
             62.081 'GROUP I ANTIARRHYTHMICS:(62.081)'
             62.083 'GROUP III ANTIARRHYTHMICS:(62.083)'
             62.085 'GROUP V ANTIARRHYTHMICS:(62.085)'
             62.089 'ANTIARRHYTHMIC AGENTS NTA:(62.089)'
             62.151 'EPHEDRINE:(62.151)' 62.159 'VASOPRESSORS NTA:(62.159)' /
   SDLED_6_4 -7 'NOT APPLICABLE:(-7)'
             37.5005 'BUPRENORPHINE/COMBINATIONS:(37.5005)'
             37.501 'CODEINE/COMBINATIONS:(37.501)'
             37.502 'DIHYDROCODEINE/COMBINATIONS:(37.502)'
             37.503 'FENTANYL/COMBINATIONS:(37.503)'
             37.504 'HYDROCODONE/COMBINATIONS:(37.504)'
             37.5045 'HYDROMORPHONE/COMBINATIONS:(37.5045)'
             37.505 'MEPERIDINE/COMBINATIONS:(37.505)'
             37.506 'METHADONE:(37.506)'
             37.507 'MORPHINE/COMBINATIONS:(37.507)'
             37.508 'OPIUM/COMBINATIONS:(37.508)'
             37.509 'OXYCODONE/COMBINATIONS:(37.509)'
             37.51 'PENTAZOCINE/COMBINATIONS:(37.51)'
             37.511 'PHENACETIN/COMBINATIONS:(37.511)'
             37.512 'PROPOXYPHENE/COMBINATIONS:(37.512)'
             37.514 'ALL OTHER NARCOTIC ANALGESICS/COMBINATIONS NTA:(37.514)'
             41.503 'TRAMADOL:(41.503)'
             41.504 'ACETAMINOPHEN-TRAMADOL:(41.504)' /
   DRUGID_5  -7 'NOT APPLICABLE' 1 'D00001 ACYCLOVIR' 2 'D00002 AMIODARONE'
             3 'D00003 AMPICILLIN' 4 'D00004 ATENOLOL' 5 'D00006 CAPTOPRIL'
             6 'D00007 CEFAZOLIN' 7 'D00008 CEFOTAXIME'
             8 'D00009 CEFTAZIDIME' 9 'D00010 CEFTIZOXIME'
             10 'D00011 CIPROFLOXACIN' 11 'D00012 CODEINE'
             12 'D00013 ENALAPRIL' 13 'D00014 GENTAMICIN'
             14 'D00015 IBUPROFEN' 15 'D00016 LABETALOL'
             16 'D00017 MEPERIDINE' 17 'D00018 NADOLOL' 18 'D00019 NAPROXEN'
             19 'D00020 QUINIDINE' 20 'D00021 RANITIDINE'
             21 'D00022 WARFARIN' 22 'D00023 ALLOPURINOL'
             23 'D00024 AZATHIOPRINE' 24 'D00025 CHLORAMPHENICOL'
             25 'D00026 FENOPROFEN' 26 'D00027 HALOPERIDOL'
             27 'D00028 KETOPROFEN' 28 'D00029 NAFCILLIN'
             29 'D00030 PENTAMIDINE' 30 'D00031 PROBENECID'
             31 'D00032 PROPRANOLOL' 32 'D00033 SULINDAC'
             33 'D00034 ZIDOVUDINE' 34 'D00035 CHLOROQUINE'
             35 'D00036 CYCLOPHOSPHAMIDE' 36 'D00037 DOXYCYCLINE'
             37 'D00038 FLUCYTOSINE' 38 'D00039 INDOMETHACIN'
             39 'D00040 OXAZEPAM' 40 'D00041 TETRACYCLINE'
             41 'D00042 CHLORPROPAMIDE' 42 'D00043 CLINDAMYCIN'
             43 'D00044 CLONIDINE' 44 'D00045 DILTIAZEM'
             45 'D00046 ERYTHROMYCIN' 46 'D00047 RIFAMPIN'
             47 'D00048 VERAPAMIL' 48 'D00049 ACETAMINOPHEN'
             49 'D00050 METHADONE' 50 'D00051 NIFEDIPINE'
             51 'D00052 CEFTRIAXONE' 52 'D00053 CEPHRADINE'
             53 'D00054 TOLMETIN' 54 'D00055 CEFOTETAN'
             55 'D00056 CEFUROXIME' 56 'D00057 PIPERACILLIN'
             57 'D00058 CARBAMAZEPINE' 58 'D00059 LIDOCAINE'
             59 'D00060 METHOTREXATE' 60 'D00061 LITHIUM'
             61 'D00062 CEFAMANDOLE' 62 'D00064 CHLORPROMAZINE'
             63 'D00065 FOSCARNET' 64 'D00066 GANCICLOVIR'
             65 'D00067 AZTREONAM' 66 'D00068 ETHAMBUTOL'
             67 'D00069 TOBRAMYCIN' 68 'D00070 FUROSEMIDE'
             69 'D00071 FLUCONAZOLE' 70 'D00072 CEFIXIME'
             71 'D00073 CEFPROZIL' 72 'D00074 CEFOPERAZONE'
             73 'D00075 PROCAINAMIDE' 74 'D00077 AMPHOTERICIN B'
             75 'D00078 DIDANOSINE' 76 'D00079 CYCLOSPORINE'
             77 'D00080 CEFADROXIL' 78 'D00081 CEFACLOR'
             79 'D00082 IMIPENEM-CILASTATIN' 80 'D00083 VALPROIC ACID'
             81 'D00084 PREDNISOLONE' 82 'D00085 RIBAVIRIN'
             83 'D00086 AMANTADINE' 84 'D00087 AMIKACIN'
             85 'D00088 AMOXICILLIN' 86 'D00089 AMOXICILLIN-CLAVULANATE'
             87 'D00090 AMPICILLIN-SULBACTAM' 88 'D00091 AZITHROMYCIN'
             89 'D00092 CARBENICILLIN' 90 'D00093 CEFMETAZOLE'
             91 'D00094 CEFOXITIN' 92 'D00095 CEFPODOXIME'
             93 'D00096 CEPHALEXIN' 94 'D00097 CLARITHROMYCIN'
             95 'D00098 DAPSONE' 96 'D00099 ENOXACIN'
             97 'D00100 GRISEOFULVIN' 98 'D00101 ISONIAZID'
             99 'D00102 ITRACONAZOLE' 100 'D00103 KETOCONAZOLE'
             101 'D00104 LOMEFLOXACIN' 102 'D00105 LORACARBEF'
             103 'D00106 METHENAMINE' 104 'D00107 METHICILLIN'
             105 'D00108 METRONIDAZOLE' 106 'D00109 MEZLOCILLIN'
             107 'D00110 MINOCYCLINE' 108 'D00112 NITROFURANTOIN'
             109 'D00113 NORFLOXACIN' 110 'D00114 OFLOXACIN'
             111 'D00115 OXACILLIN' 112 'D00116 PENICILLIN'
             113 'D00117 PYRAZINAMIDE' 114 'D00118 SULFADIAZINE'
             115 'D00119 SULFAMETHOXAZOLE' 116 'D00120 SULFISOXAZOLE'
             117 'D00121 TICARCILLIN' 118 'D00122 TICARCILLIN-CLAVULANATE'
             119 'D00123 TRIMETHOPRIM'
             120 'D00124 SULFAMETHOXAZOLE-TRIMETHOPRIM'
             121 'D00125 VANCOMYCIN' 122 'D00128 ACEBUTOLOL'
             123 'D00129 DIAZOXIDE' 124 'D00132 HYDRALAZINE'
             125 'D00133 METHYLDOPA' 126 'D00134 METOPROLOL'
             127 'D00135 MINOXIDIL' 128 'D00137 PINDOLOL'
             129 'D00138 PRAZOSIN' 130 'D00139 TIMOLOL'
             131 'D00140 CIMETIDINE' 132 'D00141 FAMOTIDINE'
             133 'D00142 THEOPHYLLINE' 134 'D00143 PHENYTOIN'
             135 'D00144 NORTRIPTYLINE' 136 'D00145 DESIPRAMINE'
             137 'D00146 AMITRIPTYLINE' 138 'D00147 CHLORAL HYDRATE'
             139 'D00148 DIAZEPAM' 140 'D00149 LORAZEPAM'
             141 'D00150 COLCHICINE' 142 'D00152 CLOXACILLIN'
             143 'D00153 DICLOXACILLIN' 144 'D00154 MEBENDAZOLE'
             145 'D00155 MICONAZOLE' 146 'D00157 NALIDIXIC ACID'
             147 'D00158 QUINACRINE' 148 'D00159 STREPTOMYCIN'
             149 'D00161 ACETAZOLAMIDE' 150 'D00164 ADENOSINE'
             151 'D00167 ALFENTANIL' 152 'D00168 ALPRAZOLAM'
             153 'D00169 AMILORIDE' 154 'D00170 ASPIRIN'
             155 'D00171 AMOBARBITAL' 156 'D00172 INAMRINONE'
             157 'D00173 ATRACURIUM' 158 'D00174 ATROPINE'
             159 'D00175 BENZTROPINE' 160 'D00176 BETAXOLOL'
             161 'D00177 BLEOMYCIN' 162 'D00178 BROMOCRIPTINE'
             163 'D00179 BUMETANIDE' 164 'D00180 BUPIVACAINE'
             165 'D00181 BUPROPION' 166 'D00182 BUSPIRONE'
             167 'D00183 BUSULFAN' 168 'D00184 CARBIDOPA'
             169 'D00185 CARBOPLATIN' 170 'D00186 CEPHALOTHIN'
             171 'D00187 CEPHAPIRIN' 172 'D00188 CHLORAMBUCIL'
             173 'D00189 CHLORDIAZEPOXIDE' 174 'D00190 CHLOROTHIAZIDE'
             175 'D00191 CHLORPHENIRAMINE' 176 'D00192 CHLORTHALIDONE'
             177 'D00193 CHOLESTYRAMINE' 178 'D00195 CISPLATIN'
             179 'D00197 CLONAZEPAM' 180 'D00198 CLORAZEPATE'
             181 'D00199 CLOZAPINE' 182 'D00200 CROMOLYN'
             183 'D00201 CYTARABINE' 184 'D00202 DACARBAZINE'
             185 'D00203 DACTINOMYCIN' 186 'D00204 DANAZOL'
             187 'D00205 DAUNORUBICIN' 188 'D00206 DEXAMETHASONE'
             189 'D00207 DEXTROMETHORPHAN' 190 'D00208 DIFLUNISAL'
             191 'D00209 DIGITOXIN' 192 'D00210 DIGOXIN'
             193 'D00211 DIHYDROERGOTAMINE' 194 'D00212 DIPHENHYDRAMINE'
             195 'D00213 DIPYRIDAMOLE' 196 'D00214 DISOPYRAMIDE'
             197 'D00215 DOBUTAMINE' 198 'D00216 DOPAMINE'
             199 'D00217 DOXEPIN' 200 'D00218 DOXORUBICIN'
             201 'D00219 DROPERIDOL' 202 'D00220 EDROPHONIUM'
             203 'D00222 ERGOTAMINE' 204 'D00223 EPOETIN ALFA'
             205 'D00224 ESMOLOL' 206 'D00226 ETHCHLORVYNOL'
             207 'D00227 ETHOSUXIMIDE' 208 'D00229 ETHINYL ESTRADIOL'
             209 'D00230 ETOPOSIDE' 210 'D00231 FELODIPINE'
             211 'D00233 FENTANYL' 212 'D00234 FLECAINIDE'
             213 'D00235 FLUOROURACIL' 214 'D00236 FLUOXETINE'
             215 'D00237 FLUPHENAZINE' 216 'D00238 FLURAZEPAM'
             217 'D00239 FLURBIPROFEN' 218 'D00240 FLUTAMIDE'
             219 'D00241 FOLIC ACID' 220 'D00242 FOSINOPRIL'
             221 'D00243 FURAZOLIDONE' 222 'D00245 GEMFIBROZIL'
             223 'D00246 GLIPIZIDE' 224 'D00248 GLYBURIDE'
             225 'D00250 GOLD SODIUM THIOMALATE' 226 'D00252 HEPARIN'
             227 'D00253 HYDROCHLOROTHIAZIDE' 228 'D00254 HYDROCORTISONE'
             229 'D00255 HYDROMORPHONE' 230 'D00256 IDARUBICIN'
             231 'D00257 IFOSFAMIDE' 232 'D00259 IMIPRAMINE'
             233 'D00260 INDAPAMIDE' 234 'D00262 INSULIN'
             235 'D00265 IPRATROPIUM' 236 'D00267 ISOFLURANE'
             237 'D00268 ISOSORBIDE DINITRATE'
             238 'D00269 ISOSORBIDE MONONITRATE' 239 'D00270 ISRADIPINE'
             240 'D00271 KANAMYCIN' 241 'D00272 KETAMINE'
             242 'D00273 KETOROLAC' 243 'D00275 LEUCOVORIN'
             244 'D00276 LEVAMISOLE' 245 'D00277 LEVODOPA'
             246 'D00278 LEVOTHYROXINE' 247 'D00279 LINCOMYCIN'
             248 'D00280 LOVASTATIN' 249 'D00282 MANNITOL'
             250 'D00283 MECLOFENAMATE' 251 'D00284 MEDROXYPROGESTERONE'
             252 'D00285 MEFENAMIC ACID' 253 'D00286 MEFLOQUINE'
             254 'D00287 MELPHALAN' 255 'D00288 MEPROBAMATE'
             256 'D00289 MERCAPTOPURINE' 257 'D00290 METHIMAZOLE'
             258 'D00292 METHSUXIMIDE' 259 'D00293 METHYLPREDNISOLONE'
             260 'D00295 METHYLTESTOSTERONE'
             261 'D00297 METIPRANOLOL OPHTHALMIC' 262 'D00298 METOCLOPRAMIDE'
             263 'D00299 METOLAZONE' 264 'D00300 MEXILETINE'
             265 'D00301 MIDAZOLAM' 266 'D00302 MILRINONE'
             267 'D00303 MISOPROSTOL' 268 'D00305 MITOMYCIN'
             269 'D00306 MITOXANTRONE' 270 'D00307 MORICIZINE'
             271 'D00308 MORPHINE' 272 'D00310 NABUMETONE'
             273 'D00311 NALOXONE' 274 'D00312 NEOMYCIN'
             275 'D00313 NEOSTIGMINE' 276 'D00314 NIACIN'
             277 'D00315 NICARDIPINE' 278 'D00316 NICOTINE'
             279 'D00318 NIMODIPINE' 280 'D00321 NITROGLYCERIN'
             281 'D00322 NIZATIDINE' 282 'D00323 NOREPINEPHRINE'
             283 'D00325 OMEPRAZOLE' 284 'D00328 OXYBUTYNIN'
             285 'D00329 OXYCODONE' 286 'D00330 PANCURONIUM'
             287 'D00331 PARAAMINOBENZOIC ACID' 288 'D00332 PENBUTOLOL'
             289 'D00333 PENICILLAMINE' 290 'D00334 PENTAZOCINE'
             291 'D00335 PENTOBARBITAL' 292 'D00336 PENTOXIFYLLINE'
             293 'D00337 PHENAZOPYRIDINE' 294 'D00340 PHENOBARBITAL'
             295 'D00341 PHENYLBUTAZONE' 296 'D00342 PHYSOSTIGMINE'
             297 'D00343 PIROXICAM' 298 'D00344 POLYMYXIN B SULFATE'
             299 'D00345 POTASSIUM CHLORIDE'
             300 'D00346 POVIDONE IODINE TOPICAL' 301 'D00348 PRAVASTATIN'
             302 'D00349 PRAZIQUANTEL' 303 'D00350 PREDNISONE'
             304 'D00351 PRIMAQUINE' 305 'D00352 PRIMIDONE'
             306 'D00353 PROBUCOL' 307 'D00354 PROCARBAZINE'
             308 'D00355 PROCHLORPERAZINE' 309 'D00356 PROMAZINE'
             310 'D00358 PROPAFENONE' 311 'D00359 PROPANTHELINE'
             312 'D00360 PROPOXYPHENE' 313 'D00361 PROPYLTHIOURACIL'
             314 'D00362 PROTAMINE' 315 'D00363 PYRIDOSTIGMINE'
             316 'D00364 PYRIMETHAMINE' 317 'D00365 QUINAPRIL'
             318 'D00366 QUININE' 319 'D00367 RESERPINE'
             320 'D00368 SECOBARBITAL' 321 'D00370 OCTREOTIDE'
             322 'D00371 SOTALOL' 323 'D00373 SPIRONOLACTONE'
             324 'D00374 STREPTOKINASE' 325 'D00375 STREPTOZOCIN'
             326 'D00376 SUCCINYLCHOLINE' 327 'D00377 SUCRALFATE'
             328 'D00378 SUFENTANIL' 329 'D00379 SULFASALAZINE'
             330 'D00381 TAMOXIFEN' 331 'D00384 TEMAZEPAM'
             332 'D00386 TERAZOSIN' 333 'D00387 TERFENADINE'
             334 'D00388 THIOPENTAL' 335 'D00389 THIORIDAZINE'
             336 'D00391 THIOTHIXENE' 337 'D00393 TOLAZAMIDE'
             338 'D00394 TOLBUTAMIDE' 339 'D00395 TRAZODONE'
             340 'D00396 TRIAMTERENE' 341 'D00397 TRIAZOLAM'
             342 'D00398 VASOPRESSIN' 343 'D00399 VECURONIUM'
             344 'D00400 VINBLASTINE' 345 'D00401 VINCRISTINE'
             346 'D00402 VITAMIN A' 347 'D00405 VITAMIN E'
             348 'D00409 RIBOFLAVIN' 349 'D00412 PYRIDOXINE'
             350 'D00413 CYANOCOBALAMIN' 351 'D00417 BIOFLAVONOIDS'
             352 'D00425 CALCIUM CARBONATE' 353 'D00426 ASCORBIC ACID'
             354 'D00427 POTASSIUM PHOSPHATE-SODIUM PHOSPHATE'
             355 'D00428 FLUORIDE' 356 'D00438 SODIUM CHLORIDE'
             357 'D00439 CITRIC ACID-POTASSIUM CITRATE'
             358 'D00440 SODIUM BICARBONATE' 359 'D00468 MAGNESIUM SULFATE'
             360 'D00471 SODIUM ACETATE' 361 'D00472 TROMETHAMINE'
             362 'D00475 SODIUM PHOSPHATE' 363 'D00476 AMMONIUM CHLORIDE'
             364 'D00481 AMMONIUM MOLYBDATE TETRAHYDRATE'
             365 'D00484 SELENIUM' 366 'D00485 IODINE TOPICAL'
             367 'D00487 GLUTAMIC ACID' 368 'D00488 LYSINE'
             369 'D00491 LEVOCARNITINE' 370 'D00496 INOSITOL'
             371 'D00497 OMEGA-3 POLYUNSATURATED FATTY ACIDS'
             372 'D00512 FILGRASTIM' 373 'D00513 SARGRAMOSTIM'
             374 'D00514 TICLOPIDINE' 375 'D00519 ANISINDIONE'
             376 'D00521 ALTEPLASE' 377 'D00523 UROKINASE'
             378 'D00524 ANTITHROMBIN III'
             379 'D00525 ANTIHEMOPHILIC FACTOR (OBSOLETE)'
             380 'D00526 ANTI-INHIBITOR COAGULANT COMPLEX'
             381 'D00527 FACTOR IX COMPLEX (OBSOLETE)'
             382 'D00528 AMINOCAPROIC ACID' 383 'D00529 TRANEXAMIC ACID'
             384 'D00534 ESTRONE' 385 'D00537 ESTRADIOL'
             386 'D00541 CONJUGATED ESTROGENS'
             387 'D00542 ESTERIFIED ESTROGENS' 388 'D00543 ESTROPIPATE'
             389 'D00546 DIETHYLSTILBESTROL' 390 'D00550 PROGESTERONE'
             391 'D00554 HYDROXYPROGESTERONE' 392 'D00555 NORETHINDRONE'
             393 'D00557 LEVONORGESTREL' 394 'D00558 TESTOSTERONE'
             395 'D00562 FLUOXYMESTERONE' 396 'D00563 FINASTERIDE'
             397 'D00565 STANOZOLOL' 398 'D00566 OXANDROLONE'
             399 'D00568 NANDROLONE' 400 'D00569 CLOMIPHENE'
             401 'D00570 UROFOLLITROPIN' 402 'D00571 MENOTROPINS'
             403 'D00572 CHORIONIC GONADOTROPIN (HCG)' 404 'D00574 NAFARELIN'
             405 'D00575 HISTRELIN' 406 'D00576 SOMATREM'
             407 'D00577 SOMATROPIN' 408 'D00578 ARGININE'
             409 'D00583 DESMOPRESSIN' 410 'D00584 OXYTOCIN'
             411 'D00586 ERGONOVINE' 412 'D00587 METHYLERGONOVINE'
             413 'D00589 DINOPROSTONE TOPICAL' 414 'D00592 METYRAPONE'
             415 'D00593 GLUCAGON' 416 'D00595 GLUCOSE'
             417 'D00598 CALCITONIN' 418 'D00599 ETIDRONATE'
             419 'D00601 PAMIDRONATE' 420 'D00602 GALLIUM NITRATE'
             421 'D00603 RITODRINE' 422 'D00604 CORTICOTROPIN'
             423 'D00607 COSYNTROPIN' 424 'D00608 FLUDROCORTISONE'
             425 'D00609 CORTISONE' 426 'D00620 TRIAMCINOLONE'
             427 'D00626 DEXAMETHASONE TOPICAL' 428 'D00628 BETAMETHASONE'
             429 'D00640 METHAZOLAMIDE' 430 'D00641 BENDROFLUMETHIAZIDE'
             431 'D00643 METHYCLOTHIAZIDE' 432 'D00644 BENZTHIAZIDE'
             433 'D00645 HYDROFLUMETHIAZIDE' 434 'D00646 TRICHLORMETHIAZIDE'
             435 'D00647 POLYTHIAZIDE' 436 'D00649 ETHACRYNIC ACID'
             437 'D00651 UREA TOPICAL' 438 'D00652 GLYCERIN'
             439 'D00653 ISOSORBIDE' 440 'D00655 THYROID DESICCATED'
             441 'D00658 LIOTHYRONINE' 442 'D00659 LIOTRIX'
             443 'D00666 AMYL NITRITE' 444 'D00683 LIDOCAINE TOPICAL'
             445 'D00688 BEPRIDIL' 446 'D00689 AMLODIPINE'
             447 'D00693 ISOXSUPRINE' 448 'D00695 PAPAVERINE'
             449 'D00696 ETHAVERINE' 450 'D00697 ISOPROTERENOL'
             451 'D00699 EPINEPHRINE' 452 'D00700 EPHEDRINE'
             453 'D00703 METHOXAMINE' 454 'D00704 PHENYLEPHRINE'
             455 'D00708 CARTEOLOL' 456 'D00709 BISOPROLOL'
             457 'D00717 GUANFACINE' 458 'D00726 DOXAZOSIN'
             459 'D00728 RAMIPRIL' 460 'D00730 BENAZEPRIL'
             461 'D00732 LISINOPRIL' 462 'D00733 PHENTOLAMINE'
             463 'D00734 PHENOXYBENZAMINE' 464 'D00735 METYROSINE'
             465 'D00739 MECAMYLAMINE'
             466 'D00743 SODIUM POLYSTYRENE SULFONATE'
             467 'D00744 COLESTIPOL' 468 'D00746 SIMVASTATIN'
             469 'D00747 DEXTROTHYROXINE SODIUM' 470 'D00749 ALBUTEROL'
             471 'D00750 METAPROTERENOL' 472 'D00752 TERBUTALINE'
             473 'D00755 PIRBUTEROL' 474 'D00758 AMINOPHYLLINE'
             475 'D00759 DYPHYLLINE' 476 'D00760 BECLOMETHASONE'
             477 'D00761 FLUNISOLIDE' 478 'D00762 ACETYLCYSTEINE'
             479 'D00765 CROMOLYN OPHTHALMIC'
             480 'D00767 PHENYLPROPANOLAMINE' 481 'D00769 PSEUDOEPHEDRINE'
             482 'D00771 NAPHAZOLINE OPHTHALMIC'
             483 'D00772 OXYMETAZOLINE NASAL'
             484 'D00773 TETRAHYDROZOLINE OPHTHALMIC'
             485 'D00774 XYLOMETAZOLINE NASAL'
             486 'D00775 ALPHA 1-PROTEINASE INHIBITOR'
             487 'D00780 CLEMASTINE' 488 'D00782 PYRILAMINE'
             489 'D00784 DEXCHLORPHENIRAMINE' 490 'D00785 BROMPHENIRAMINE'
             491 'D00786 TRIPROLIDINE' 492 'D00787 PROMETHAZINE'
             493 'D00788 TRIMEPRAZINE' 494 'D00789 METHDILAZINE'
             495 'D00790 CYPROHEPTADINE' 496 'D00791 AZATADINE'
             497 'D00793 PHENINDAMINE' 498 'D00796 BENZONATATE'
             499 'D00797 GUAIFENESIN' 500 'D00800 POTASSIUM IODIDE'
             501 'D00801 CAFFEINE' 502 'D00802 DOXAPRAM'
             503 'D00803 AMPHETAMINE' 504 'D00804 DEXTROAMPHETAMINE'
             505 'D00805 METHAMPHETAMINE' 506 'D00806 PHENTERMINE'
             507 'D00807 BENZPHETAMINE' 508 'D00809 PHENDIMETRAZINE'
             509 'D00810 DIETHYLPROPION' 510 'D00811 MAZINDOL'
             511 'D00812 FENFLURAMINE' 512 'D00813 BENZOCAINE TOPICAL'
             513 'D00814 METHOTRIMEPRAZINE' 514 'D00817 HYDROXYCHLOROQUINE'
             515 'D00824 OPIUM' 516 'D00825 LEVORPHANOL'
             517 'D00833 OXYMORPHONE' 518 'D00838 BUTORPHANOL'
             519 'D00839 NALBUPHINE' 520 'D00840 BUPRENORPHINE'
             521 'D00842 SALSALATE' 522 'D00846 MAGNESIUM SALICYLATE'
             523 'D00848 DICLOFENAC' 524 'D00851 ETODOLAC'
             525 'D00853 OXAPROZIN' 526 'D00855 PERPHENAZINE'
             527 'D00857 THIETHYLPERAZINE' 528 'D00858 CYCLIZINE'
             529 'D00859 MECLIZINE' 530 'D00861 DIMENHYDRINATE'
             531 'D00862 TRIMETHOBENZAMIDE' 532 'D00866 DRONABINOL'
             533 'D00867 ONDANSETRON' 534 'D00873 TRIMIPRAMINE'
             535 'D00874 AMOXAPINE' 536 'D00875 PROTRIPTYLINE'
             537 'D00876 CLOMIPRAMINE' 538 'D00877 MAPROTILINE'
             539 'D00880 SERTRALINE' 540 'D00882 ISOCARBOXAZID'
             541 'D00883 PHENELZINE' 542 'D00884 TRANYLCYPROMINE'
             543 'D00889 MESORIDAZINE' 544 'D00890 TRIFLUOPERAZINE'
             545 'D00896 MOLINDONE' 546 'D00897 LOXAPINE'
             547 'D00898 PIMOZIDE' 548 'D00900 METHYLPHENIDATE'
             549 'D00901 PEMOLINE' 550 'D00902 ERGOLOID MESYLATES'
             551 'D00907 HYDROXYZINE' 552 'D00909 CHLORMEZANONE'
             553 'D00910 ZOLPIDEM' 554 'D00911 PARALDEHYDE'
             555 'D00912 ACETYLCARBROMAL' 556 'D00915 ESTAZOLAM'
             557 'D00917 QUAZEPAM' 558 'D00919 MEPHOBARBITAL'
             559 'D00923 BUTABARBITAL' 560 'D00929 METHOHEXITAL'
             561 'D00931 ETOMIDATE' 562 'D00933 PROPOFOL'
             563 'D00934 NITROUS OXIDE' 564 'D00942 ETHOTOIN'
             565 'D00943 PHENSUXIMIDE' 566 'D00944 PARAMETHADIONE'
             567 'D00960 CARISOPRODOL' 568 'D00962 CHLORZOXAZONE'
             569 'D00963 CYCLOBENZAPRINE' 570 'D00964 METAXALONE'
             571 'D00965 METHOCARBAMOL' 572 'D00966 ORPHENADRINE'
             573 'D00967 BACLOFEN' 574 'D00968 DANTROLENE'
             575 'D00969 PROCYCLIDINE' 576 'D00970 TRIHEXYPHENIDYL'
             577 'D00972 BIPERIDEN' 578 'D00976 SELEGILINE'
             579 'D00977 PERGOLIDE' 580 'D00978 ALUMINUM HYDROXIDE'
             581 'D00980 DIHYDROXYALUMINUM SODIUM CARBONATE'
             582 'D00982 MAGNESIUM HYDROXIDE' 583 'D00984 MAGALDRATE'
             584 'D00985 HYOSCYAMINE' 585 'D00986 SCOPOLAMINE'
             586 'D00988 BELLADONNA' 587 'D00989 METHSCOPOLAMINE'
             588 'D00991 CLIDINIUM' 589 'D00992 GLYCOPYRROLATE'
             590 'D00999 DICYCLOMINE' 591 'D01002 PANCRELIPASE'
             592 'D01003 PANCREATIN' 593 'D01005 URSODIOL'
             594 'D01008 MAGNESIUM CITRATE' 595 'D01009 SODIUM BIPHOSPHATE'
             596 'D01010 CASCARA SAGRADA' 597 'D01012 PHENOLPHTHALEIN'
             598 'D01013 SENNA' 599 'D01014 CASTOR OIL'
             600 'D01015 BISACODYL' 601 'D01017 POLYCARBOPHIL'
             602 'D01018 PSYLLIUM' 603 'D01019 MINERAL OIL'
             604 'D01021 DOCUSATE'
             605 'D01023 POLYETHYLENE GLYCOL 3350 WITH ELECTROLYTES'
             606 'D01024 LACTULOSE' 607 'D01025 LOPERAMIDE'
             608 'D01026 BISMUTH SUBSALICYLATE' 609 'D01027 SIMETHICONE'
             610 'D01028 CHARCOAL' 611 'D01030 DEHYDROCHOLIC ACID'
             612 'D01031 MESALAMINE' 613 'D01032 OLSALAZINE'
             614 'D01068 DEMECLOCYCLINE' 615 'D01070 OXYTETRACYCLINE'
             616 'D01090 SULFAMETHIZOLE' 617 'D01097 RIFABUTIN'
             618 'D01100 ETHIONAMIDE' 619 'D01101 CYCLOSERINE'
             620 'D01104 PAROMOMYCIN' 621 'D01105 IODOQUINOL'
             622 'D01112 COLISTIN SULFATE OTIC' 623 'D01113 COLISTIMETHATE'
             624 'D01115 BACITRACIN' 625 'D01120 ATOVAQUONE'
             626 'D01121 CLOFAZIMINE' 627 'D01123 PYRANTEL'
             628 'D01124 PIPERAZINE' 629 'D01128 METHYLENE BLUE'
             630 'D01129 CINOXACIN' 631 'D01133 IMMUNE GLOBULIN INTRAVENOUS'
             632 'D01135 IMMUNE GLOBULIN INTRAMUSCULAR'
             633 'D01136 HEPATITIS B IMMUNE GLOBULIN'
             634 'D01138 VARICELLA ZOSTER IMMUNE GLOBULIN'
             635 'D01139 RHO (D) IMMUNE GLOBULIN'
             636 'D01141 LYMPHOCYTE IMMUNE GLOBULIN, ANTI-THY (OBS)'
             637 'D01142 DIPHTHERIA ANTITOXIN'
             638 'D01144 ANTIVENIN (CROTALIDAE) POLYVALENT'
             639 'D01146 ANTIVENIN (BLACK WIDOW SPIDER)'
             640 'D01147 RABIES VACCINE (OBSOLETE)'
             641 'D01148 RABIES IMMUNE GLOBULIN, HUMAN' 642 'D01150 BCG'
             643 'D01152 STAPHAGE LYSATE (SPL)'
             644 'D01153 MENINGOCOCCAL POLYSACCHARIDE VACCINE'
             645 'D01156 TYPHOID VACCINE, INACTIVATED'
             646 'D01158 HAEMOPHILUS B CONJUGATE VACCINE (OBSOLETE)'
             647 'D01159 MEASLES VIRUS VACCINE'
             648 'D01160 RUBELLA VIRUS VACCINE'
             649 'D01161 MUMPS VIRUS VACCINE'
             650 'D01162 POLIOVIRUS VACCINE, LIVE, TRIVALENT'
             651 'D01163 POLIOVIRUS VACCINE, INACTIVATED'
             652 'D01164 INFLUENZA VIRUS VACCINE, INACTIVATED'
             653 'D01165 YELLOW FEVER VACCINE'
             654 'D01166 HEPATITIS B VACCINE (OBSOLETE)'
             655 'D01168 TETANUS TOXOID'
             656 'D01171 TUBERCULIN PURIFIED PROTEIN DERIVATIVE'
             657 'D01184 DIPIVEFRIN OPHTHALMIC'
             658 'D01187 LEVOBUNOLOL OPHTHALMIC'
             659 'D01188 ACETYLCHOLINE OPHTHALMIC'
             660 'D01191 PILOCARPINE OPHTHALMIC'
             661 'D01195 ECHOTHIOPHATE IODIDE OPHTHALMIC'
             662 'D01199 HOMATROPINE OPHTHALMIC'
             663 'D01200 TROPICAMIDE OPHTHALMIC'
             664 'D01201 CYCLOPENTOLATE OPHTHALMIC'
             665 'D01204 SUPROFEN OPHTHALMIC'
             666 'D01208 SULFACETAMIDE SODIUM OPHTHALMIC'
             667 'D01210 YELLOW MERCURIC OXIDE OPHTHALMIC'
             668 'D01215 TRIFLURIDINE OPHTHALMIC' 669 'D01217 TETRACAINE'
             670 'D01218 PROPARACAINE OPHTHALMIC'
             671 'D01219 FLUORESCEIN OPHTHALMIC'
             672 'D01222 SODIUM HYALURONATE OPHTHALMIC'
             673 'D01225 BORIC ACID TOPICAL'
             674 'D01226 HYDROXYPROPYL METHYLCELLULOSE OPHTHALMIC'
             675 'D01227 BOTULINUM TOXIN TYPE A (OBSOLETE)'
             676 'D01231 CHLORHEXIDINE TOPICAL'
             677 'D01232 CARBAMIDE PEROXIDE TOPICAL' 678 'D01233 NYSTATIN'
             679 'D01234 BUTOCONAZOLE TOPICAL'
             680 'D01235 TIOCONAZOLE TOPICAL' 681 'D01236 CLOTRIMAZOLE'
             682 'D01238 TERCONAZOLE TOPICAL'
             683 'D01239 GENTIAN VIOLET TOPICAL'
             684 'D01240 SULFANILAMIDE TOPICAL'
             685 'D01241 CLINDAMYCIN TOPICAL'
             686 'D01242 NONOXYNOL 9 TOPICAL' 687 'D01243 OCTOXYNOL TOPICAL'
             688 'D01244 TRETINOIN TOPICAL' 689 'D01245 ISOTRETINOIN'
             690 'D01246 BENZOYL PEROXIDE TOPICAL'
             691 'D01254 ANTHRALIN TOPICAL'
             692 'D01257 NITROFURAZONE TOPICAL' 693 'D01258 MAFENIDE TOPICAL'
             694 'D01259 SILVER SULFADIAZINE TOPICAL'
             695 'D01263 PYRITHIONE ZINC TOPICAL'
             696 'D01265 SULFACETAMIDE SODIUM TOPICAL'
             697 'D01266 CHLOROXINE TOPICAL' 698 'D01267 MUPIROCIN TOPICAL'
             699 'D01271 ECONAZOLE TOPICAL' 700 'D01272 CICLOPIROX TOPICAL'
             701 'D01273 TRIACETIN TOPICAL' 702 'D01274 TOLNAFTATE TOPICAL'
             703 'D01275 SULCONAZOLE TOPICAL' 704 'D01277 NAFTIFINE TOPICAL'
             705 'D01278 LINDANE TOPICAL' 706 'D01279 PERMETHRIN TOPICAL'
             707 'D01280 CROTAMITON TOPICAL'
             708 'D01282 ALCLOMETASONE TOPICAL'
             709 'D01288 CLOBETASOL TOPICAL'
             710 'D01289 CLOCORTOLONE TOPICAL' 711 'D01290 DESONIDE TOPICAL'
             712 'D01291 DESOXIMETASONE TOPICAL'
             713 'D01292 DIFLORASONE TOPICAL'
             714 'D01293 FLUOCINOLONE TOPICAL'
             715 'D01294 FLUOCINONIDE TOPICAL'
             716 'D01295 FLURANDRENOLIDE TOPICAL' 717 'D01296 FLUTICASONE'
             718 'D01298 HALOBETASOL TOPICAL' 719 'D01300 MOMETASONE TOPICAL'
             720 'D01301 DIBUCAINE TOPICAL' 721 'D01302 BUTAMBEN TOPICAL'
             722 'D01303 PRAMOXINE TOPICAL' 723 'D01305 DYCLONINE TOPICAL'
             724 'D01306 COCAINE TOPICAL' 725 'D01307 SALICYLIC ACID TOPICAL'
             726 'D01308 PODOPHYLLUM RESIN TOPICAL'
             727 'D01309 PODOFILOX TOPICAL'
             728 'D01313 TRICHLOROACETIC ACID TOPICAL'
             729 'D01314 SUTILAINS TOPICAL' 730 'D01315 COLLAGENASE TOPICAL'
             731 'D01316 MASOPROCOL TOPICAL'
             732 'D01319 HYDROQUINONE TOPICAL'
             733 'D01320 FORMALDEHYDE TOPICAL' 734 'D01321 CAPSAICIN TOPICAL'
             735 'D01322 ALUMINUM CHLORIDE HEXAHYDRATE TOPICAL'
             736 'D01323 MONOBENZONE TOPICAL' 737 'D01325 ARNICA TOPICAL'
             738 'D01332 HEXACHLOROPHENE TOPICAL'
             739 'D01333 BENZALKONIUM CHLORIDE TOPICAL'
             740 'D01335 SODIUM HYPOCHLORITE TOPICAL'
             741 'D01338 PHYSIOLOGICAL IRRIGATING SOLUTION'
             742 'D01339 MECHLORETHAMINE' 743 'D01341 LOMUSTINE'
             744 'D01342 CARMUSTINE' 745 'D01344 FLOXURIDINE'
             746 'D01345 THIOGUANINE' 747 'D01346 FLUDARABINE'
             748 'D01348 MEGESTROL' 749 'D01351 ESTRAMUSTINE'
             750 'D01353 LEUPROLIDE' 751 'D01354 GOSERELIN'
             752 'D01356 PENTOSTATIN' 753 'D01361 PLICAMYCIN'
             754 'D01368 INTERFERON ALFA-2A' 755 'D01369 INTERFERON ALFA-2B'
             756 'D01372 ALTRETAMINE' 757 'D01373 HYDROXYUREA'
             758 'D01375 ALDESLEUKIN' 759 'D01376 PACLITAXEL'
             760 'D01378 MITOTANE' 761 'D01379 ASPARAGINASE ESCHERICHIA COLI'
             762 'D01382 ETHANOLAMINE OLEATE'
             763 'D01383 SODIUM TETRADECYL SULFATE'
             764 'D01384 MORRHUATE SODIUM' 765 'D01385 BETA-CAROTENE'
             766 'D01386 YOHIMBINE' 767 'D01387 ALPROSTADIL'
             768 'D01389 DISULFIRAM' 769 'D01393 HYALURONIDASE'
             770 'D01394 PROCAINE' 771 'D01395 CHLOROPROCAINE'
             772 'D01396 PRILOCAINE' 773 'D01398 MEPIVACAINE'
             774 'D01402 DEFEROXAMINE' 775 'D01404 SODIUM THIOSULFATE'
             776 'D01406 NALTREXONE' 777 'D01407 FLUMAZENIL'
             778 'D01409 PRALIDOXIME' 779 'D01410 DIGOXIN IMMUNE FAB'
             780 'D01411 MESNA' 781 'D01413 IPECAC' 782 'D01416 TRIENTINE'
             783 'D01417 SUCCIMER' 784 'D01420 AMBENONIUM'
             785 'D01422 GUANIDINE' 786 'D01423 POTASSIUM CITRATE'
             787 'D01424 POTASSIUM ACID PHOSPHATE' 788 'D01425 FLAVOXATE'
             789 'D01427 BETHANECHOL' 790 'D01431 DIMETHYL SULFOXIDE'
             791 'D01433 ACETOHYDROXAMIC ACID' 792 'D01434 METHOXSALEN'
             793 'D01438 IOPANOIC ACID' 794 'D01445 BARIUM SULFATE'
             795 'D01451 GADOPENTETATE DIMEGLUMINE' 796 'D01452 IODAMIDE'
             797 'D01456 IOHEXOL' 798 'D01461 IOPAMIDOL'
             799 'D01469 IOVERSOL' 800 'D01472 METRIZAMIDE'
             801 'D01473 DIATRIZOATE' 802 'D01475 IOTHALAMATE'
             803 'D01476 ETHIODIZED OIL' 804 'D01482 ISOSULFAN BLUE'
             805 'D02373 PHOSPHORATED CARBOHYDRATE SOLUTION'
             806 'D02374 DESFLURANE' 807 'D02375 PLASMA PROTEIN FRACTION'
             808 'D02376 ALBUMIN HUMAN' 809 'D02378 HETASTARCH'
             810 'D02381 POTASSIUM PERCHLORATE' 811 'D03001 CLADRIBINE'
             812 'D03003 DIPHTHERIA-TETANUS TOXOIDS (OBSOLETE)'
             813 'D03004 DIPHTHERIA/PERTUSSIS, WHOLE CELL/TETANUS'
             814 'D03006 MEASLES-RUBELLA VIRUS VACCINE'
             815 'D03007 MEASLES/MUMPS/RUBELLA VIRUS VACCINE'
             816 'D03008 INTERFERON GAMMA-1B' 817 'D03034 NORGESTREL'
             818 'D03041 ENOXAPARIN' 819 'D03050 LORATADINE'
             820 'D03051 INTERFERON BETA-1B'
             821 'D03052 HYDROCHLOROTHIAZIDE-TRIAMTERENE'
             822 'D03054 AMYLASE' 823 'D03056 ATTAPULGITE'
             824 'D03058 BENZOIC ACID' 825 'D03061 BUTALBITAL'
             826 'D03062 CASANTHRANOL' 827 'D03066 CITRIC ACID'
             828 'D03068 DICHLORALPHENAZONE' 829 'D03075 HYDROCODONE'
             830 'D03077 ISOMETHEPTENE MUCATE' 831 'D03085 PEPSIN'
             832 'D03086 PHENIRAMINE' 833 'D03089 PHENYLTOLOXAMINE'
             834 'D03094 SALICYLAMIDE' 835 'D03096 SODIUM BENZOATE'
             836 'D03097 SODIUM BORATE TOPICAL' 837 'D03098 SODIUM CITRATE'
             838 'D03109 JAPANESE ENCEPHALITIS VIRUS VACCINE NAKAYAMA'
             839 'D03110 DIPHTH/PERTUSSIS, ACEL/TETANUS (OBSOLETE)'
             840 'D03112 NEDOCROMIL'
             841 'D03113 DEXTRAN, LOW MOLECULAR WEIGHT'
             842 'D03114 DEXTRAN, HIGH MOLECULAR WEIGHT'
             843 'D03116 BISMUTH SUBGALLATE' 844 'D03118 MUROMONAB-CD3'
             845 'D03125 DIHYDROTACHYSTEROL' 846 'D03126 CALCITRIOL'
             847 'D03128 ERGOCALCIFEROL' 848 'D03129 CHOLECALCIFEROL'
             849 'D03130 THIAMINE' 850 'D03133 HYDROXOCOBALAMIN'
             851 'D03135 PHYTONADIONE' 852 'D03136 VITAMIN A & D TOPICAL'
             853 'D03137 CALCIUM-VITAMIN D' 854 'D03140 MULTIVITAMIN'
             855 'D03141 MULTIVITAMIN WITH IRON'
             856 'D03143 MULTIVITAMIN WITH FLUORIDE'
             857 'D03145 MULTIVITAMIN WITH MINERALS'
             858 'D03148 MULTIVITAMIN, PRENATAL' 859 'D03152 TRIFLUPROMAZINE'
             860 'D03154 DOXYLAMINE' 861 'D03157 PAROXETINE'
             862 'D03158 RIMANTADINE' 863 'D03159 CHOLINE'
             864 'D03160 SUMATRIPTAN' 865 'D03162 ALCOHOL (ETHANOL)'
             866 'D03165 PIPERACILLIN-TAZOBACTAM' 867 'D03166 CISAPRIDE'
             868 'D03168 DIHYDROCODEINE' 869 'D03169 TRIMETREXATE'
             870 'D03170 FELBAMATE' 871 'D03171 GRANISETRON'
             872 'D03173 DORNASE ALFA' 873 'D03176 TACRINE'
             874 'D03180 RISPERIDONE' 875 'D03181 VENLAFAXINE'
             876 'D03182 GABAPENTIN' 877 'D03183 FLUVASTATIN'
             878 'D03187 LEVOMETHADYL ACETATE' 879 'D03189 TORSEMIDE'
             880 'D03190 OXICONAZOLE TOPICAL'
             881 'D03191 TERBINAFINE TOPICAL' 882 'D03192 ZINC OXIDE TOPICAL'
             883 'D03193 AMILORIDE-HYDROCHLOROTHIAZIDE'
             884 'D03195 MICONAZOLE TOPICAL' 885 'D03196 GENTAMICIN TOPICAL'
             886 'D03197 BETAMETHASONE TOPICAL'
             887 'D03200 ERYTHROMYCIN TOPICAL' 888 'D03201 ACYCLOVIR TOPICAL'
             889 'D03202 KETOCONAZOLE TOPICAL' 890 'D03203 MINOXIDIL TOPICAL'
             891 'D03204 FLUOROURACIL TOPICAL'
             892 'D03205 HYDROCORTISONE TOPICAL'
             893 'D03206 TRIAMCINOLONE TOPICAL'
             894 'D03207 AMPHOTERICIN B TOPICAL'
             895 'D03208 METRONIDAZOLE TOPICAL'
             896 'D03210 SELENIUM SULFIDE TOPICAL'
             897 'D03211 CIPROFLOXACIN OPHTHALMIC'
             898 'D03212 ATROPINE OPHTHALMIC'
             899 'D03213 DICLOFENAC OPHTHALMIC'
             900 'D03214 KETOROLAC OPHTHALMIC'
             901 'D03221 PREDNISOLONE OPHTHALMIC'
             902 'D03222 TOBRAMYCIN OPHTHALMIC' 903 'D03224 NEOMYCIN TOPICAL'
             904 'D03226 SALIVA SUBSTITUTES'
             905 'D03227 FLUOROMETHOLONE OPHTHALMIC'
             906 'D03228 LODOXAMIDE OPHTHALMIC'
             907 'D03229 LEVOCABASTINE OPHTHALMIC'
             908 'D03231 TRIPLE SULFA TOPICAL'
             909 'D03232 VITAMINS A, D, AND E TOPICAL'
             910 'D03233 VITAMIN E TOPICAL'
             911 'D03238 ETHINYL ESTRADIOL-NORETHINDRONE'
             912 'D03240 MESTRANOL-NORETHINDRONE'
             913 'D03241 ETHINYL ESTRADIOL-NORGESTREL'
             914 'D03242 ETHINYL ESTRADIOL-LEVONORGESTREL'
             915 'D03245 ESTERIFIED ESTROGENS-METHYLTESTOSTERONE'
             916 'D03247 HYDROCHLOROTHIAZIDE-SPIRONOLACTONE'
             917 'D03251 HYDROCHLOROTHIAZIDE-RESERPINE'
             918 'D03255 BENDROFLUMETHIAZIDE-RAUWOLFIA SERPENTINA'
             919 'D03256 HYDRALAZINE/HYDROCHLOROTHIAZIDE/RESERPINE'
             920 'D03257 HYDRALAZINE-HYDROCHLOROTHIAZIDE'
             921 'D03258 ATENOLOL-CHLORTHALIDONE'
             922 'D03259 BENDROFLUMETHIAZIDE-NADOLOL'
             923 'D03260 HYDROCHLOROTHIAZIDE-TIMOLOL'
             924 'D03261 HYDROCHLOROTHIAZIDE-PROPRANOLOL'
             925 'D03263 HYDROCHLOROTHIAZIDE-METHYLDOPA'
             926 'D03264 HYDROCHLOROTHIAZIDE-METOPROLOL'
             927 'D03265 BENAZEPRIL-HYDROCHLOROTHIAZIDE'
             928 'D03266 HYDROCHLOROTHIAZIDE-LISINOPRIL'
             929 'D03267 CHLORTHALIDONE-CLONIDINE'
             930 'D03271 PHENIRAMINE-PHENYLEPHRINE NASAL'
             931 'D03273 GUAIFENESIN-THEOPHYLLINE'
             932 'D03274 AMINOPHYLLINE-GUAIFENESIN'
             933 'D03276 DYPHYLLINE-GUAIFENESIN'
             934 'D03277 POTASSIUM IODIDE-THEOPHYLLINE'
             935 'D03280 EPHEDRINE/PHENOBARBITAL/THEOPHYLLINE'
             936 'D03283 EPHEDRINE/HYDROXYZINE/THEOPHYLLINE'
             937 'D03289 ACETAMINOPHEN-PSEUDOEPHEDRINE'
             938 'D03292 IBUPROFEN-PSEUDOEPHEDRINE' 939 'D03293 APAP/ASA/PPA'
             940 'D03296 ACETAMINOPHEN-CHLORPHENIRAMINE'
             941 'D03297 ACETAMINOPHEN-PHENYLTOLOXAMINE'
             942 'D03298 CHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             943 'D03299 CHLORPHENIRAMINE-PHENYLPROPANOLAMINE'
             944 'D03300 CHLORPHENIRAMINE-PHENYLEPHRINE'
             945 'D03301 BROMPHENIRAMINE-PSEUDOEPHEDRINE'
             946 'D03302 BROMPHENIRAMINE-PHENYLPROPANOLAMINE'
             947 'D03303 CLEMASTINE-PHENYLPROPANOLAMINE'
             948 'D03306 CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             949 'D03307 CHLORPHENIRAMINE/PHENINDAMINE/PPA'
             950 'D03308 PHENIRAMINE/PPA/PHENYLTOLOXAMINE/PYRILAMINE'
             951 'D03310 CHLORPHENIRAMINE/PE/PPA/PHENYLTOLOXAMINE'
             952 'D03311 BROMPHENIRAMINE-PHENYLEPHRINE'
             953 'D03312 DIPHENHYDRAMINE-PSEUDOEPHEDRINE'
             954 'D03313 CHLORPHENIRAMINE/PHENYLEPHRINE/PYRILAMINE'
             955 'D03316 PSEUDOEPHEDRINE-TRIPROLIDINE'
             956 'D03317 PHENYLEPHRINE-PROMETHAZINE'
             957 'D03318 PHENIRAMINE/PPA/PYRILAMINE'
             958 'D03319 APAP/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             959 'D03320 APAP/CHLORPHENIRAMINE/PSEUDOEPHEDRINE'
             960 'D03321 APAP/BROMPHENIRAMINE/PSEUDOEPHEDRINE'
             961 'D03322 ASA/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             962 'D03329 ASA/DIPHENHYDRAMINE/PPA'
             963 'D03330 APAP/PSEUDOEPHEDRINE/TRIPROLIDINE'
             964 'D03331 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE'
             965 'D03336 APAP/CPM/PHENYLEPHRINE/PPA/PYRILAMINE'
             966 'D03338 CHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             967 'D03340 HOMATROPINE-HYDROCODONE'
             968 'D03341 CODEINE-PSEUDOEPHEDRINE'
             969 'D03342 APAP/DEXTROMETHORPHAN/PSEUDOEPHEDRINE'
             970 'D03347 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             971 'D03349 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PSE'
             972 'D03351 ASA/BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             973 'D03352 HYDROCODONE-PSEUDOEPHEDRINE'
             974 'D03353 HYDROCODONE-PHENYLPROPANOLAMINE'
             975 'D03354 DEXTROMETHORPHAN-PSEUDOEPHEDRINE'
             976 'D03355 DEXTROMETHORPHAN-PHENYLPROPANOLAMINE'
             977 'D03356 CHLORPHENIRAMINE-HYDROCODONE'
             978 'D03357 CODEINE-PROMETHAZINE'
             979 'D03359 CHLORPHENIRAMINE-DEXTROMETHORPHAN'
             980 'D03360 DEXTROMETHORPHAN-PROMETHAZINE'
             981 'D03361 CHLORPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             982 'D03362 CHLORPHENIRAMINE/CODEINE/PSEUDOEPHEDRINE'
             983 'D03364 CODEINE/PHENYLEPHRINE/PROMETHAZINE'
             984 'D03366 HYDROCODONE/PHENYLEPHRINE/PYRILAMINE'
             985 'D03368 BROMPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             986 'D03369 CHLORPHENIRAMINE/DEXTROMETHORP/PHENYLEPHRINE'
             987 'D03370 CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             988 'D03371 DEXTROMETHORPHAN/PHENYLEPHRINE/PYRILAMINE'
             989 'D03372 BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             990 'D03378 ACETAMINOPHEN-DEXTROMETHORPHAN'
             991 'D03379 GUAIFENESIN-PSEUDOEPHEDRINE'
             992 'D03380 EPHEDRINE-GUAIFENESIN'
             993 'D03381 GUAIFENESIN-PHENYLEPHRINE'
             994 'D03382 GUAIFENESIN-PHENYLPROPANOLAMINE'
             995 'D03383 GUAIFENESIN/PHENYLEPHRINE/PPA'
             996 'D03388 ETHINYL ESTRADIOL-ETHYNODIOL'
             997 'D03389 ESTRADIOL-TESTOSTERONE'
             998 'D03392 CHLORPHENIRAMINE/GUAIFENESIN/PHENYLEPHRINE'
             999 'D03393 CODEINE-GUAIFENESIN'
             1000 'D03396 GUAIFENESIN-HYDROCODONE'
             1001 'D03397 GUAIFENESIN-HYDROMORPHONE'
             1002 'D03398 CODEINE/GUAIFENESIN/PSE'
             1003 'D03400 DEXTROMETHORPHAN-GUAIFENESIN'
             1004 'D03403 GUAIFENESIN/HYDROCODONE/PHENYLEPHRINE'
             1005 'D03404 GUAIFENESIN/HYDROCODONE/PSEUDOEPHEDRINE'
             1006 'D03407 CODEINE/GUAIFENESIN/PHENYLPROPANOLAMINE'
             1007 'D03408 DEXTROMETHORPHAN/GUAIFENESIN/PHENYLEPHRINE'
             1008 'D03409 DEXTROMETHORPHAN/GUAIFENESIN/PSEUDOEPHEDRINE'
             1009 'D03411 DEXTROMETHORPHAN/GUAIFENESIN/PPA'
             1010 'D03416 CHLORPHENIRAMINE/HYDROCODONE/PSE'
             1011 'D03419 CHLORPHENIRAMINE/DM/GUAIFENESIN/PHENYLEPHRINE'
             1012 'D03423 ACETAMINOPHEN-CODEINE'
             1013 'D03424 ASPIRIN-CODEINE'
             1014 'D03425 APAP/BUTALBITAL/CAFFEINE/CODEINE'
             1015 'D03426 ASA/BUTALBITAL/CAFFEINE/CODEINE'
             1016 'D03428 ACETAMINOPHEN-HYDROCODONE'
             1017 'D03430 ASA/CAFFEINE/DIHYDROCODEINE'
             1018 'D03431 ACETAMINOPHEN-OXYCODONE'
             1019 'D03432 ASPIRIN-OXYCODONE'
             1020 'D03433 MEPERIDINE-PROMETHAZINE'
             1021 'D03434 ACETAMINOPHEN-PROPOXYPHENE'
             1022 'D03435 ASA/CAFFEINE/PROPOXYPHENE'
             1023 'D03436 BELLADONNA-OPIUM'
             1024 'D03437 APAP/ASA/CAFFEINE/SALICYLAMIDE'
             1025 'D03439 APAP/ASA/CAFFEINE'
             1026 'D03443 APAP/AL HYDROXIDE/ASA/CAFFEINE/MG HYDROXIDE'
             1027 'D03445 ACETAMINOPHEN-DIPHENHYDRAMINE'
             1028 'D03447 ASA/CAFFEINE/SALICYLAMIDE'
             1029 'D03448 ASPIRIN-MEPROBAMATE' 1030 'D03449 ASPIRIN-CAFFEINE'
             1031 'D03453 ASPIRIN-PHENYLTOLOXAMINE'
             1032 'D03454 MAGNESIUM SALICYLATE-PHENYLTOLOXAMINE'
             1033 'D03455 APAP/BUTALBITAL/CAFFEINE'
             1034 'D03456 ACETAMINOPHEN-BUTALBITAL'
             1035 'D03457 ASA/BUTALBITAL/CAFFEINE'
             1036 'D03459 APAP/DICHLORALPHENAZONE/ISOMETHEPTENE'
             1037 'D03462 AMITRIPTYLINE-CHLORDIAZEPOXIDE'
             1038 'D03463 AMITRIPTYLINE-PERPHENAZINE'
             1039 'D03464 DROPERIDOL-FENTANYL'
             1040 'D03468 ASPIRIN-METHOCARBAMOL'
             1041 'D03469 ASPIRIN-CARISOPRODOL'
             1042 'D03470 ASA/CARISOPRODOL/CODEINE'
             1043 'D03472 ASA/CAFFEINE/ORPHENADRINE'
             1044 'D03473 CARBIDOPA-LEVODOPA'
             1045 'D03474 ALUMINUM HYDROXIDE-MAGNESIUM HYDROXIDE'
             1046 'D03478 AL HYDROXIDE/MG HYDROXIDE/SIMETHICONE'
             1047 'D03480 CA CARBONATE/MG HYDROXIDE/SIMETHICONE'
             1048 'D03485 ATROPINE/HYOSCYAMINE/PB/SCOPOLAMINE'
             1049 'D03486 BELLADONNA-BUTABARBITAL'
             1050 'D03492 CHLORDIAZEPOXIDE-CLIDINIUM'
             1051 'D03495 BELLADONNA/ERGOTAMINE/PHENOBARBITAL'
             1052 'D03496 DOCUSATE-SENNA'
             1053 'D03497 DOCUSATE-PHENOLPHTHALEIN'
             1054 'D03498 CASANTHRANOL-DOCUSATE'
             1055 'D03505 ATROPINE-DIFENOXIN'
             1056 'D03506 ATROPINE-DIPHENOXYLATE'
             1057 'D03508 ISONIAZID-RIFAMPIN'
             1058 'D03509 ERYTHROMYCIN-SULFISOXAZOLE'
             1059 'D03511 PHENAZOPYRIDINE-SULFAMETHOXAZOLE'
             1060 'D03513 METHENAMINE-SODIUM ACID PHOSPHATE'
             1061 'D03517 BENZOIC ACID/METHENAMINE/SODIUM SALICYLATE'
             1062 'D03520 NAPHAZOLINE-PHENIRAMINE OPHTHALMIC'
             1063 'D03521 CYCLOPENTOLATE-PHENYLEPHRINE OPHTHALMIC'
             1064 'D03523 HYDROXYAMPHETAMINE-TROPICAMIDE OPHTHALMIC'
             1065 'D03524 BACITRACIN/NEOMYCIN/POLYMYXIN B TOPICAL'
             1066 'D03525 GRAMICIDIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1067 'D03526 NEOMYCIN-POLYMYXIN B SULFATE TOPICAL'
             1068 'D03527 BACITRACIN-POLYMYXIN B TOPICAL'
             1069 'D03529 POLYMYXIN B-TRIMETHOPRIM OPHTHALMIC'
             1070 'D03533 NEOMYCIN/POLYMYXIN B/PREDNISOLONE OPHTHALMIC'
             1071 'D03536 DEXAMETHASONE-TOBRAMYCIN OPHTHALMIC'
             1072 'D03537 DEXAMETHASONE/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1073 'D03541 PREDNISOLONE-SULFACETAMIDE SODIUM OPHTHALMIC'
             1074 'D03542 FLUORESCEIN-PROPARACAINE OPHTHALMIC'
             1075 'D03543 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OTIC'
             1076 'D03544 HYDROCORTISONE-POLYMYXIN B OTIC'
             1077 'D03546 HYDROCORTISONE-PRAMOXINE TOPICAL'
             1078 'D03552 CLIOQUINOL-HYDROCORTISONE TOPICAL'
             1079 'D03553 CLIOQUINOL/HYDROCORTISONE/PRAMOXINE TOPICAL'
             1080 'D03561 BETAMETHASONE-CLOTRIMAZOLE TOPICAL'
             1081 'D03562 NYSTATIN-TRIAMCINOLONE TOPICAL'
             1082 'D03566 CAPTOPRIL-HYDROCHLOROTHIAZIDE'
             1083 'D03569 CARBINOXAMINE'
             1084 'D03570 CARBINOXAMINE-PSEUDOEPHEDRINE'
             1085 'D03572 CARAMIPHEN-PHENYLPROPANOLAMINE'
             1086 'D03576 BROMODIPHENHYDRAMINE-CODEINE'
             1087 'D03577 CARBINOXAMINE/DEXTROMETHORPHAN/PSE'
             1088 'D03584 CODEINE/PHENIRAMINE/PHENYLEPHRINE/NA CITRATE'
             1089 'D03585 PAMABROM' 1090 'D03586 APAP/PAMABROM/PYRILAMINE'
             1091 'D03588 MAGNESIUM CARBONATE'
             1092 'D03591 ALGINIC ACID/AL HYDROXIDE/MG CARBONATE'
             1093 'D03596 ALGINIC ACID/AL HYDROXIDE/MG TRISILICATE'
             1094 'D03600 POTASSIUM BICARBONATE' 1095 'D03613 PSYLLIUM-SENNA'
             1096 'D03618 HYOSCYAMINE/METHENAM/M-BLUE/PHENYL SALICYL'
             1097 'D03620 ANTAZOLINE-NAPHAZOLINE OPHTHALMIC'
             1098 'D03622 BENOXINATE-FLUORESCEIN OPHTHALMIC'
             1099 'D03623 ACETIC ACID TOPICAL' 1100 'D03624 ANTIPYRINE OTIC'
             1101 'D03625 ACETIC ACID-HYDROCORTISONE OTIC'
             1102 'D03627 ANTIPYRINE-BENZOCAINE OTIC'
             1103 'D03628 ANTIPYRINE/BENZOCAINE/PHENYLEPHRINE OTIC'
             1104 'D03630 ANHYDROUS CALCIUM IODIDE-CODEINE'
             1105 'D03632 CETYLPYRIDINIUM TOPICAL'
             1106 'D03634 BENZOCAINE-CETYLPYRIDINIUM TOPICAL'
             1107 'D03640 BUDESONIDE NASAL' 1108 'D03641 PETROLATUM TOPICAL'
             1109 'D03644 LACTOBACILLUS ACIDOPHILUS'
             1110 'D03646 LACTOBACILLUS ACIDOPHILUS AND BULGARICUS'
             1111 'D03647 ISOPROPYL ALCOHOL TOPICAL'
             1112 'D03648 OPHTHALMIC IRRIGATION, INTRAOCULAR'
             1113 'D03649 BENZOIN TOPICAL'
             1114 'D03650 CANDIDA ALBICANS EXTRACT'
             1115 'D03651 CHOLINE SALICYLATE-MAGNESIUM SALICYLATE'
             1116 'D03652 COLCHICINE-PROBENECID'
             1117 'D03653 CALAMINE TOPICAL'
             1118 'D03655 LIDOCAINE-PRILOCAINE TOPICAL'
             1119 'D03656 ETHYL CHLORIDE TOPICAL'
             1120 'D03659 FIBRINOLYSIN AND DESOXYRIBONUCLEASE TOPICAL'
             1121 'D03660 MULTIVITAMIN WITH IRON AND FLUORIDE'
             1122 'D03661 DOCUSATE-FERROUS FUMARATE' 1123 'D03663 LECITHIN'
             1124 'D03664 PHENOL TOPICAL' 1125 'D03665 MENTHOL TOPICAL'
             1126 'D03666 MENTHOL-PHENOL TOPICAL' 1127 'D03667 METHACHOLINE'
             1128 'D03668 METHYL SALICYLATE TOPICAL' 1129 'D03674 PECTIN'
             1130 'D03676 NALOXONE-PENTAZOCINE'
             1131 'D03678 NAPHAZOLINE-ZINC OPHTHALMIC'
             1132 'D03680 ASA/CITRIC ACID/NA BICARB'
             1133 'D03681 OPHTHALMIC IRRIGATION, EXTRAOCULAR'
             1134 'D03682 ACETAMINOPHEN-PENTAZOCINE'
             1135 'D03684 THROMBIN TOPICAL'
             1136 'D03686 UNDECYLENIC ACID TOPICAL'
             1137 'D03687 ALUMINUM ACETATE TOPICAL'
             1138 'D03688 ALUMINUM SULFATE TOPICAL'
             1139 'D03689 CALCIUM ACETATE'
             1140 'D03690 ALUMINUM SULFATE-CALCIUM ACETATE TOPICAL'
             1141 'D03691 BENZOCAINE/PHENOL/POVIDONE IODINE TOPICAL'
             1142 'D03693 ICHTHAMMOL TOPICAL'
             1143 'D03694 MEDRYSONE OPHTHALMIC'
             1144 'D03695 PRAMOXINE-ZINC OXIDE TOPICAL'
             1145 'D03696 BENZYL BENZOATE TOPICAL'
             1146 'D03701 CORN STARCH TOPICAL' 1147 'D03702 SULFUR TOPICAL'
             1148 'D03703 COAL TAR TOPICAL'
             1149 'D03705 SALICYLIC ACID-SULFUR TOPICAL'
             1150 'D03707 ALOE VERA TOPICAL'
             1151 'D03708 LANOLIN-MINERAL OIL TOPICAL'
             1152 'D03710 ALLANTOIN/CAMPHOR/PHENOL TOPICAL'
             1153 'D03712 CAMPHOR TOPICAL'
             1154 'D03713 CAMPHOR-PHENOL TOPICAL'
             1155 'D03716 CITRIC ACID/GLUCONODELTA-LACTONE/MG CARBONATE'
             1156 'D03721 SODIUM IODIDE'
             1157 'D03724 FAT EMULSION, INTRAVENOUS'
             1158 'D03725 INTRAVENOUS ELECTROLYTE SOLUTION'
             1159 'D03735 TRIETHANOLAMINE POLYPEPTIDE OLEATE OTIC'
             1160 'D03738 TETRACYCLINE TOPICAL' 1161 'D03739 NIACINAMIDE'
             1162 'D03740 ENALAPRIL-HYDROCHLOROTHIAZIDE'
             1163 'D03743 PYRIMETHAMINE-SULFADOXINE'
             1164 'D03744 BISOPROLOL-HYDROCHLOROTHIAZIDE'
             1165 'D03750 DEXBROMPHENIRAMINE'
             1166 'D03751 DEXBROMPHENIRAMINE-PSEUDOEPHEDRINE'
             1167 'D03752 TACROLIMUS'
             1168 'D03754 ACRIVASTINE-PSEUDOEPHEDRINE'
             1169 'D03756 BACITRACIN TOPICAL' 1170 'D03759 SALMETEROL'
             1171 'D03760 DIPHENHYDRAMINE TOPICAL'
             1172 'D03761 LANOLIN TOPICAL' 1173 'D03762 WITCH HAZEL TOPICAL'
             1174 'D03763 GLYCERIN-PHENOL TOPICAL'
             1175 'D03764 GLYCERIN-WITCH HAZEL TOPICAL'
             1176 'D03766 ROCURONIUM' 1177 'D03767 IRON DEXTRAN'
             1178 'D03768 OCULAR LUBRICANT' 1179 'D03770 EMOLLIENTS, TOPICAL'
             1180 'D03773 STAVUDINE' 1181 'D03774 DOXEPIN TOPICAL'
             1182 'D03775 FAMCICLOVIR' 1183 'D03777 POTASSIUM ACETATE'
             1184 'D03780 DESOGESTREL'
             1185 'D03781 ETHINYL ESTRADIOL-NORGESTIMATE'
             1186 'D03782 DESOGESTREL-ETHINYL ESTRADIOL'
             1187 'D03783 BUPIVACAINE-EPINEPHRINE'
             1188 'D03784 EPINEPHRINE-LIDOCAINE'
             1189 'D03788 CALCIPOTRIENE TOPICAL'
             1190 'D03789 POTASSIUM GLUCONATE'
             1191 'D03790 POTASSIUM PHOSPHATE'
             1192 'D03796 MAGNESIUM CHLORIDE' 1193 'D03797 MAGNESIUM OXIDE'
             1194 'D03798 MAGNESIUM GLUCONATE' 1195 'D03799 CALCIUM CHLORIDE'
             1196 'D03800 CALCIUM GLUCONATE' 1197 'D03802 CALCIUM LACTATE'
             1198 'D03803 CALCIUM PHOSPHATE, TRIBASIC'
             1199 'D03804 FLUVOXAMINE' 1200 'D03805 DORZOLAMIDE OPHTHALMIC'
             1201 'D03806 ALBENDAZOLE' 1202 'D03807 METFORMIN'
             1203 'D03808 NEFAZODONE' 1204 'D03809 LAMOTRIGINE'
             1205 'D03810 VINORELBINE' 1206 'D03811 ABCIXIMAB'
             1207 'D03812 DALTEPARIN'
             1208 'D03818 LORATADINE-PSEUDOEPHEDRINE'
             1209 'D03819 CONJUGATED ESTROGENS-MEDROXYPROGESTERONE'
             1210 'D03821 LOSARTAN' 1211 'D03822 FERROUS GLUCONATE'
             1212 'D03823 IRON POLYSACCHARIDE' 1213 'D03824 FERROUS SULFATE'
             1214 'D03825 NISOLDIPINE' 1215 'D03826 TRAMADOL'
             1216 'D03827 CETIRIZINE' 1217 'D03828 LANSOPRAZOLE'
             1218 'D03829 AMLODIPINE-BENAZEPRIL'
             1219 'D03830 HYDROCHLOROTHIAZIDE-LOSARTAN'
             1220 'D03831 NILUTAMIDE' 1221 'D03832 VARICELLA VIRUS VACCINE'
             1222 'D03833 DIVALPROEX SODIUM' 1223 'D03834 NALMEFENE'
             1224 'D03835 MOEXIPRIL' 1225 'D03836 ACITRETIN'
             1226 'D03838 VALACYCLOVIR' 1227 'D03839 MYCOPHENOLATE MOFETIL'
             1228 'D03840 IOPROMIDE' 1229 'D03841 DEXRAZOXANE'
             1230 'D03842 EPOPROSTENOL' 1231 'D03843 GADOTERIDOL'
             1232 'D03844 DIRITHROMYCIN' 1233 'D03845 SEVOFLURANE'
             1234 'D03846 ACARBOSE' 1235 'D03847 CARVEDILOL'
             1236 'D03848 AZELAIC ACID TOPICAL' 1237 'D03849 ALENDRONATE'
             1238 'D03850 BICALUTAMIDE'
             1239 'D03857 BENZOYL PEROXIDE-ERYTHROMYCIN TOPICAL'
             1240 'D03858 LAMIVUDINE' 1241 'D03860 SAQUINAVIR'
             1242 'D03862 MAGNESIUM AMINO ACIDS CHELATE'
             1243 'D03863 TRETINOIN' 1244 'D03864 GLIMEPIRIDE'
             1245 'D03866 CALCIUM CITRATE'
             1246 'D03867 CALCIUM CARBONATE-SODIUM FLUORIDE'
             1247 'D03868 AMIFOSTINE' 1248 'D03869 RILUZOLE'
             1249 'D03870 AMPHOTERICIN B LIPID COMPLEX'
             1250 'D03872 PORFIMER' 1251 'D03873 ANASTROZOLE'
             1252 'D03874 CEFTIBUTEN' 1253 'D03877 HEROIN'
             1254 'D03878 COCAINE' 1255 'D03879 MARIJUANA'
             1256 'D03880 PHENCYCLIDINE'
             1257 'D03881 RESPIRATORY SYNCYTIAL VIRUS IMMUNE GLOBULIN'
             1258 'D03882 CEFEPIME'
             1259 'D03883 AL HYDROXIDE/ASA/CA CARBONATE/MG HYDROXIDE'
             1260 'D03884 TROLAMINE SALICYLATE TOPICAL'
             1261 'D03888 BENZOCAINE/BUTAMBEN/TETRACAINE TOPICAL'
             1262 'D03892 HISTAMINE PHOSPHATE' 1263 'D03894 KAOLIN-PECTIN'
             1264 'D03895 SINCALIDE' 1265 'D03897 LACTASE'
             1266 'D03898 SODIUM CHLORIDE, HYPERTONIC, OPHTHALMIC'
             1267 'D03904 BALSAM PERU/CASTOR OIL/TRYPSIN TOPICAL'
             1268 'D03905 ISOPROTERENOL-PHENYLEPHRINE'
             1269 'D03906 PHENIRAMINE/PHENYLTOLOXAMINE/PYRILAMINE'
             1270 'D03908 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             1271 'D03911 CHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1272 'D03913 APAP/DEXTROMETHORPHAN/PSE/PYRILAMINE'
             1273 'D03915 HYDROCODONE-POTASSIUM GUAIACOLSULFONATE'
             1274 'D03920 FERROUS FUMARATE'
             1275 'D03922 ACETAMINOPHEN-CAFFEINE'
             1276 'D03923 ACETAMINOPHEN-PHENYLEPHRINE'
             1277 'D03926 APAP/CAFFEINE/PYRILAMINE'
             1278 'D03927 BACITRACIN OPHTHALMIC'
             1279 'D03929 AMINOPHYLLINE/AMOBARBITAL/EPHEDRINE'
             1280 'D03946 ASCORBIC ACID-FERROUS FUMARATE'
             1281 'D03951 CITRIC ACID/K CITRATE/NA CITRATE'
             1282 'D03952 CITRIC ACID-SODIUM CITRATE'
             1283 'D03953 ELECTROLYTE REPLACEMENT SOLUTIONS, ORAL'
             1284 'D03954 FERROUS FUMARATE-FOLIC ACID'
             1285 'D03957 CALCIUM/FERROUS FUMARATE/VITAMIN D'
             1286 'D03962 POTASSIUM BICARBONATE-POTASSIUM CITRATE'
             1287 'D03963 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1288 'D03964 BACITRACIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1289 'D03965 BACITRACIN-POLYMYXIN B OPHTHALMIC'
             1290 'D03966 BENZOYL PEROXIDE-SULFUR TOPICAL'
             1291 'D03968 DEXAMETHASONE OPHTHALMIC'
             1292 'D03971 EPINEPHRINE OPHTHALMIC'
             1293 'D03973 ERYTHROMYCIN OPHTHALMIC'
             1294 'D03974 GENTAMICIN OPHTHALMIC'
             1295 'D03975 GLYCERIN OPHTHALMIC'
             1296 'D03976 HYDROCORTISONE OTIC'
             1297 'D03977 OFLOXACIN OPHTHALMIC'
             1298 'D03978 OXYMETAZOLINE OPHTHALMIC'
             1299 'D03979 SCOPOLAMINE OPHTHALMIC'
             1300 'D03980 SULFISOXAZOLE OPHTHALMIC'
             1301 'D03981 TETRACAINE OPHTHALMIC'
             1302 'D03982 TETRACAINE TOPICAL' 1303 'D03984 RITONAVIR'
             1304 'D03985 INDINAVIR' 1305 'D03989 BORIC ACID OPHTHALMIC'
             1306 'D03990 CARBAMIDE PEROXIDE OTIC'
             1307 'D03992 CHLORAMPHENICOL OPHTHALMIC'
             1308 'D03993 CHLORTETRACYCLINE OPHTHALMIC'
             1309 'D03994 COLLOIDAL OATMEAL TOPICAL'
             1310 'D03998 STERILE WATER'
             1311 'D04002 PIPERONYL BUTOXIDE-PYRETHRINS TOPICAL'
             1312 'D04003 HYDROGEN PEROXIDE TOPICAL'
             1313 'D04004 DOXORUBICIN LIPOSOMAL'
             1314 'D04005 AMOBARBITAL-SECOBARBITAL'
             1315 'D04006 DEXFENFLURAMINE' 1316 'D04008 TRANDOLAPRIL'
             1317 'D04009 DOCETAXEL' 1318 'D04010 GEMCITABINE'
             1319 'D04011 INTERFERON BETA-1A' 1320 'D04012 TERBINAFINE'
             1321 'D04014 TOPOTECAN' 1322 'D04015 ADAPALENE TOPICAL'
             1323 'D04016 IODIXANOL' 1324 'D04017 LATANOPROST OPHTHALMIC'
             1325 'D04021 BENZOIC ACID-SALICYLIC ACID TOPICAL'
             1326 'D04025 MIRTAZAPINE' 1327 'D04026 IRINOTECAN'
             1328 'D04027 MEROPENEM' 1329 'D04028 CIDOFOVIR'
             1330 'D04029 NEVIRAPINE' 1331 'D04031 PILOCARPINE'
             1332 'D04032 SULFACETAMIDE SODIUM-SULFUR TOPICAL'
             1333 'D04034 REMIFENTANIL'
             1334 'D04035 AMPHETAMINE-DEXTROAMPHETAMINE'
             1335 'D04036 CAFFEINE-SODIUM BENZOATE'
             1336 'D04037 TIMOLOL OPHTHALMIC'
             1337 'D04038 BETAXOLOL OPHTHALMIC'
             1338 'D04039 CARTEOLOL OPHTHALMIC' 1339 'D04040 FEXOFENADINE'
             1340 'D04041 FOSPHENYTOIN'
             1341 'D04043 FOLLICLE STIMULATING HORMONE'
             1342 'D04044 RESORCINOL TOPICAL'
             1343 'D04045 RESORCINOL-SULFUR TOPICAL' 1344 'D04047 MIDODRINE'
             1345 'D04048 BRIMONIDINE OPHTHALMIC'
             1346 'D04049 AMMONIUM LACTATE TOPICAL' 1347 'D04050 OLANZAPINE'
             1348 'D04051 ROPIVACAINE'
             1349 'D04052 PENTOSAN POLYSULFATE SODIUM'
             1350 'D04053 ZAFIRLUKAST' 1351 'D04054 PENCICLOVIR TOPICAL'
             1352 'D04056 ZINC GLUCONATE' 1353 'D04057 ZINC SULFATE'
             1354 'D04058 MELATONIN'
             1355 'D04059 HAEMOPHILUS B-HEPATITIS B VACCINE'
             1356 'D04060 DILTIAZEM-ENALAPRIL'
             1357 'D04061 BISMUTH SUBSALICYLATE/METRONIDAZOLE/TCN'
             1358 'D04062 BENTOQUATAM TOPICAL'
             1359 'D04063 BUTENAFINE TOPICAL'
             1360 'D04065 TRANDOLAPRIL-VERAPAMIL'
             1361 'D04066 ALBUTEROL-IPRATROPIUM' 1362 'D04067 RETEPLASE'
             1363 'D04068 AZELASTINE NASAL'
             1364 'D04070 SODIUM PHENYLBUTYRATE'
             1365 'D04075 CHLOROXYLENOL TOPICAL'
             1366 'D04076 CHLOROXYLENOL/HYDROCORTISONE/PRAMOXINE OTIC'
             1367 'D04083 GADODIAMIDE' 1368 'D04084 GLYCINE IRRIGATION'
             1369 'D04090 LACTIC ACID TOPICAL'
             1370 'D04093 HYDROCORTISONE-IODOQUINOL TOPICAL'
             1371 'D04095 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OPHTH'
             1372 'D04096 IMIGLUCERASE' 1373 'D04099 DONEPEZIL'
             1374 'D04100 AMPHOTERICIN B CHOLESTERYL SULFATE'
             1375 'D04101 IVERMECTIN' 1376 'D04102 TIZANIDINE'
             1377 'D04103 ZILEUTON' 1378 'D04105 ATORVASTATIN'
             1379 'D04106 FOSFOMYCIN' 1380 'D04107 AMLEXANOX TOPICAL'
             1381 'D04109 LEVOFLOXACIN' 1382 'D04110 MIGLITOL'
             1383 'D04111 GLATIRAMER' 1384 'D04112 CABERGOLINE'
             1385 'D04113 VALSARTAN' 1386 'D04115 TOPIRAMATE'
             1387 'D04116 ENALAPRIL-FELODIPINE'
             1388 'D04117 OLOPATADINE OPHTHALMIC' 1389 'D04118 NELFINAVIR'
             1390 'D04119 DELAVIRDINE' 1391 'D04120 CAFFEINE-ERGOTAMINE'
             1392 'D04121 TAMSULOSIN' 1393 'D04122 TROGLITAZONE'
             1394 'D04123 ZINC ACETATE' 1395 'D04125 IMIQUIMOD TOPICAL'
             1396 'D04126 ANAGRELIDE' 1397 'D04128 LVP SOLUTION'
             1398 'D04130 LVP SOLUTION WITH HYPERTONIC SALINE'
             1399 'D04131 PARENTERAL NUTRITION SOLUTION'
             1400 'D04132 PARENTERAL NUTRITION SOLUTION W/ELECTROLYTES'
             1401 'D04133 NEOMYCIN OPHTHALMIC'
             1402 'D04134 POLYMYXIN B OPHTHALMIC'
             1403 'D04135 PHENYLEPHRINE OPHTHALMIC' 1404 'D04137 TOREMIFENE'
             1405 'D04138 TAZAROTENE TOPICAL' 1406 'D04139 MIBEFRADIL'
             1407 'D04141 HYDROCHLOROTHIAZIDE-MOEXIPRIL'
             1408 'D04142 CHROMIUM PICOLINATE'
             1409 'D04143 ACETAMINOPHEN-PAMABROM' 1410 'D04145 PRAMIPEXOLE'
             1411 'D04147 NAPHAZOLINE NASAL' 1412 'D04150 BROMFENAC'
             1413 'D04151 BENZOCAINE-TRIMETHOBENZAMIDE'
             1414 'D04152 HYDROCODONE-PHENYLEPHRINE'
             1415 'D04153 PHENAZOPYRIDINE-SULFISOXAZOLE'
             1416 'D04155 ASPIRIN-DIPHENHYDRAMINE' 1417 'D04156 LETROZOLE'
             1418 'D04157 LOPERAMIDE-SIMETHICONE' 1419 'D04159 SORBITOL'
             1420 'D04160 SODIUM BIPHOSPHATE-SODIUM PHOSPHATE'
             1421 'D04161 SECRETIN' 1422 'D04163 FERROUS SULFATE-FOLIC ACID'
             1423 'D04166 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PSE'
             1424 'D04168 APAP/DIPHENHYDRAMINE/PSEUDOEPHEDRINE'
             1425 'D04172 CALAMINE-PRAMOXINE TOPICAL'
             1426 'D04175 DIPHENHYDRAMINE-MAGNESIUM SALICYLATE'
             1427 'D04177 FAT SUPPLEMENT, ORAL'
             1428 'D04178 CALCIUM HYDROXIDE TOPICAL'
             1429 'D04184 POTASSIUM AMINOBENZOATE'
             1430 'D04185 POTASSIUM BICARBONATE-SODIUM BICARBONATE'
             1431 'D04186 PHENYLEPHRINE NASAL'
             1432 'D04189 TRIPELENNAMINE TOPICAL'
             1433 'D04190 PAPAIN TOPICAL' 1434 'D04191 PAPAIN-UREA TOPICAL'
             1435 'D04192 COLISTIN/HC/NEOMYCIN/THONZONIUM OTIC'
             1436 'D04193 LEVMETAMFETAMINE NASAL'
             1437 'D04194 PROPYLHEXEDRINE NASAL' 1438 'D04195 CHLOROPHYLLIN'
             1439 'D04196 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B TOPICAL'
             1440 'D04197 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B TOPICAL'
             1441 'D04204 COPPER SULFATE'
             1442 'D04205 POVIDONE IODINE OPHTHALMIC'
             1443 'D04206 TETRAHYDROZOLINE NASAL'
             1444 'D04208 SILVER NITRATE TOPICAL'
             1445 'D04209 METHOXSALEN TOPICAL'
             1446 'D04210 ESTRADIOL TOPICAL' 1447 'D04214 DOLASETRON'
             1448 'D04215 ROPINIROLE' 1449 'D04217 EPINEPHRINE-PRILOCAINE'
             1450 'D04219 LAMIVUDINE-ZIDOVUDINE' 1451 'D04220 QUETIAPINE'
             1452 'D04221 TIAGABINE' 1453 'D04222 IRBESARTAN'
             1454 'D04223 MOMETASONE NASAL'
             1455 'D04224 INTERFERON ALFACON-1'
             1456 'D04225 HYDROCODONE-IBUPROFEN'
             1457 'D04226 AMINOSALICYLIC ACID' 1458 'D04228 ACETIC ACID OTIC'
             1459 'D04229 GLYCERIN OTIC' 1460 'D04231 VITAMIN A OPHTHALMIC'
             1461 'D04233 TRIAMCINOLONE NASAL'
             1462 'D04235 IPRATROPIUM NASAL' 1463 'D04236 ETHANOL TOPICAL'
             1464 'D04238 AMPHOTERICIN B LIPOSOMAL'
             1465 'D04240 HYLAN G-F 20'
             1466 'D04241 POTASSIUM CHLORIDE-SODIUM CHLORIDE'
             1467 'D04242 SODIUM CHLORIDE NASAL'
             1468 'D04243 LIDOCAINE-OXYTETRACYCLINE'
             1469 'D04245 HYDROCHLOROTHIAZIDE-IRBESARTAN'
             1470 'D04247 PEGASPARGASE' 1471 'D04248 METHYLCELLULOSE'
             1472 'D04249 CELLULOSE' 1473 'D04253 ZOLMITRIPTAN'
             1474 'D04255 RITUXIMAB' 1475 'D04256 CEFDINIR'
             1476 'D04258 CLOPIDOGREL' 1477 'D04260 SIBUTRAMINE'
             1478 'D04261 RALOXIFENE' 1479 'D04263 TROVAFLOXACIN'
             1480 'D04264 BECAPLERMIN TOPICAL' 1481 'D04265 OFLOXACIN OTIC'
             1482 'D04266 EPROSARTAN' 1483 'D04267 REPAGLINIDE'
             1484 'D04269 APAP/CAFFEINE/DIHYDROCODEINE'
             1485 'D04270 FEXOFENADINE-PSEUDOEPHEDRINE'
             1486 'D04271 DICLOFENAC-MISOPROSTOL'
             1487 'D04272 AMOXICILLIN/CLARITHROMYCIN/LANSOPRAZOLE'
             1488 'D04274 FOMEPIZOLE' 1489 'D04275 BECLOMETHASONE NASAL'
             1490 'D04276 BUDESONIDE' 1491 'D04279 FLUNISOLIDE NASAL'
             1492 'D04282 TOLCAPONE' 1493 'D04283 FLUTICASONE NASAL'
             1494 'D04284 FLUTICASONE TOPICAL' 1495 'D04285 NARATRIPTAN'
             1496 'D04286 FENOFIBRATE' 1497 'D04287 CIPROFLOXACIN OTIC'
             1498 'D04288 CIPROFLOXACIN-HYDROCORTISONE OTIC'
             1499 'D04289 MONTELUKAST'
             1500 'D04290 CALCIUM CARBONATE-MAGNESIUM HYDROXIDE'
             1501 'D04291 LEPIRUDIN' 1502 'D04292 LOTEPREDNOL OPHTHALMIC'
             1503 'D04293 HYDROCHLOROTHIAZIDE-VALSARTAN'
             1504 'D04294 TOLTERODINE' 1505 'D04295 OXYMETHOLONE'
             1506 'D04296 STARCH TOPICAL'
             1507 'D04297 PHENYLEPHRINE-PRAMOXINE TOPICAL'
             1508 'D04298 PHENYLEPHRINE TOPICAL' 1509 'D04299 SILDENAFIL'
             1510 'D04300 RISEDRONATE' 1511 'D04301 BRINZOLAMIDE OPHTHALMIC'
             1512 'D04303 DORZOLAMIDE-TIMOLOL OPHTHALMIC'
             1513 'D04305 SACROSIDASE' 1514 'D04311 CAPECITABINE'
             1515 'D04312 PARICALCITOL' 1516 'D04314 BASILIXIMAB'
             1517 'D04315 TIROFIBAN' 1518 'D04316 EPTIFIBATIDE'
             1519 'D04320 DIPHTHERIA/HAEMOPHILUS/PERTUSSIS,ACEL/TETANUS'
             1520 'D04321 INTERFERON ALFA-2B-RIBAVIRIN'
             1521 'D04322 CANDESARTAN' 1522 'D04323 PALIVIZUMAB'
             1523 'D04328 RIZATRIPTAN' 1524 'D04329 SODIUM HYALURONATE'
             1525 'D04331 THALIDOMIDE' 1526 'D04332 CITALOPRAM'
             1527 'D04334 EPHEDRINE-POTASSIUM IODIDE'
             1528 'D04339 DEXTROMETHORPHAN-POTASSIUM GUAIACOLSULFONATE'
             1529 'D04342 INFLIXIMAB' 1530 'D04344 ROTAVIRUS VACCINE'
             1531 'D04345 APAP/CAFFEINE/GUAIFENESIN/PHENYLEPHRINE'
             1532 'D04347 DOXYCYCLINE TOPICAL' 1533 'D04349 LEFLUNOMIDE'
             1534 'D04351 COAL TAR/LACTIC ACID/SALICYLIC ACID TOPICAL'
             1535 'D04355 EFAVIRENZ' 1536 'D04357 TRASTUZUMAB'
             1537 'D04360 HEMIN' 1538 'D04363 SEVELAMER'
             1539 'D04364 TELMISARTAN' 1540 'D04365 ETANERCEPT'
             1541 'D04366 SIMETHICONE COATED CELLULOSE'
             1542 'D04368 TANNIC ACID TOPICAL' 1543 'D04369 INSULIN REGULAR'
             1544 'D04370 INSULIN ISOPHANE' 1545 'D04371 INSULIN ZINC'
             1546 'D04372 INSULIN ZINC EXTENDED' 1547 'D04373 INSULIN LISPRO'
             1548 'D04374 INSULIN ISOPHANE-INSULIN REGULAR'
             1549 'D04375 ESTRADIOL-NORETHINDRONE' 1550 'D04376 ABACAVIR'
             1551 'D04377 THYROTROPIN ALPHA' 1552 'D04378 MODAFINIL'
             1553 'D04379 LYME DISEASE VACCINE' 1554 'D04380 CELECOXIB'
             1555 'D04382 CILOSTAZOL' 1556 'D04386 DENILEUKIN DIFTITOX'
             1557 'D04387 SODIUM FERRIC GLUCONATE COMPLEX'
             1558 'D04389 PENTASTARCH' 1559 'D04391 LIVER DERIVATIVE COMPLEX'
             1560 'D04393 BUTABARBITAL/HYOSCYAMINE/PHENAZOPYRIDINE'
             1561 'D04394 CROMOLYN NASAL' 1562 'D04395 CLOTRIMAZOLE TOPICAL'
             1563 'D04396 CONJUGATED ESTROGENS TOPICAL'
             1564 'D04397 FLUORIDE TOPICAL' 1565 'D04399 NYSTATIN TOPICAL'
             1566 'D04402 CILASTATIN' 1567 'D04406 TYPHOID VACCINE, LIVE'
             1568 'D04407 ECHINACEA' 1569 'D04408 ST. JOHN''S WORT'
             1570 'D04409 CHAMOMILE' 1571 'D04410 FEVERFEW'
             1572 'D04411 GARLIC' 1573 'D04412 GINSENG' 1574 'D04413 GINKGO'
             1575 'D04414 GINGER' 1576 'D04415 SAW PALMETTO'
             1577 'D04416 VALERIAN' 1578 'D04417 CREATINE'
             1579 'D04418 GLUCOSAMINE' 1580 'D04419 CHONDROITIN'
             1581 'D04420 CHONDROITIN-GLUCOSAMINE'
             1582 'D04421 EVENING PRIMROSE' 1583 'D04422 KAVA'
             1584 'D04423 GOLDENSEAL' 1585 'D04425 DEHYDROEPIANDROSTERONE'
             1586 'D04426 RED YEAST RICE' 1587 'D04427 LEVALBUTEROL'
             1588 'D04429 ORLISTAT'
             1589 'D04430 BACITRACIN/NEOMYCIN/POLYMYXIN B/PRAMOXINE TOP'
             1590 'D04431 NEOMYCIN/POLYMYXIN B/PRAMOXINE TOPICAL'
             1591 'D04432 CARBONYL IRON' 1592 'D04433 ROFECOXIB'
             1593 'D04434 ROSIGLITAZONE' 1594 'D04435 DOXERCALCIFEROL'
             1595 'D04436 MALATHION TOPICAL' 1596 'D04440 PERINDOPRIL'
             1597 'D04441 KETOTIFEN OPHTHALMIC' 1598 'D04442 PIOGLITAZONE'
             1599 'D04443 ZANAMIVIR'
             1600 'D04445 CARBETAPENTANE/CHLORPHENIRAMINE/PHENYLEPHRINE'
             1601 'D04446 PHENYLEPHRINE-PYRILAMINE' 1602 'D04447 GANIRELIX'
             1603 'D04448 RABEPRAZOLE' 1604 'D04451 TEMOZOLOMIDE'
             1605 'D04452 ZALEPLON' 1606 'D04453 SIROLIMUS'
             1607 'D04454 EPIRUBICIN' 1608 'D04457 DALFOPRISTIN-QUINUPRISTIN'
             1609 'D04458 PEMIROLAST OPHTHALMIC' 1610 'D04459 DOFETILIDE'
             1611 'D04460 ENTACAPONE' 1612 'D04461 EXEMESTANE'
             1613 'D04462 OSELTAMIVIR' 1614 'D04463 GRAPE SEED OIL'
             1615 'D04464 DONG QUAI' 1616 'D04466 MILK THISTLE'
             1617 'D04467 CAT''S CLAW' 1618 'D04469 BEE POLLEN'
             1619 'D04470 CRANBERRY' 1620 'D04472 BLACK COHOSH'
             1621 'D04473 BLUE COHOSH' 1622 'D04478 WILD YAM'
             1623 'D04479 PENNYROYAL' 1624 'D04481 ROYAL JELLY'
             1625 'D04482 DAMIANA' 1626 'D04483 DANDELION'
             1627 'D04484 SHARK CARTILAGE' 1628 'D04491 FLAX'
             1629 'D04492 FENUGREEK' 1630 'D04497 ASPIRIN-DIPYRIDAMOLE'
             1631 'D04498 NAPROXEN-PSEUDOEPHEDRINE'
             1632 'D04499 LEVETIRACETAM' 1633 'D04500 MOXIFLOXACIN'
             1634 'D04501 AMINOLEVULINIC ACID TOPICAL'
             1635 'D04503 NEDOCROMIL OPHTHALMIC' 1636 'D04504 GATIFLOXACIN'
             1637 'D04505 DEXMEDETOMIDINE'
             1638 'D04506 ESTRADIOL-NORGESTIMATE' 1639 'D04507 BEXAROTENE'
             1640 'D04508 NITRIC OXIDE'
             1641 'D04509 HYDROCHLOROTHIAZIDE-QUINAPRIL'
             1642 'D04510 INSULIN LISPRO-INSULIN LISPRO PROTAMINE'
             1643 'D04512 CEVIMELINE' 1644 'D04513 OXCARBAZEPINE'
             1645 'D04514 PANTOPRAZOLE' 1646 'D04515 GADOVERSETAMIDE'
             1647 'D04516 ALOSETRON' 1648 'D04523 UBIQUINONE'
             1649 'D04524 S-ADENOSYLMETHIONINE' 1650 'D04527 ZONISAMIDE'
             1651 'D04530 STRONTIUM-89 CHLORIDE'
             1652 'D04531 SAMARIUM SM 153 LEXIDRONAM' 1653 'D04532 MELOXICAM'
             1654 'D04533 VERTEPORFIN' 1655 'D04534 LINEZOLID'
             1656 'D04535 ARTICAINE-EPINEPHRINE' 1657 'D04536 ARTICAINE'
             1658 'D04537 RIVASTIGMINE' 1659 'D04538 INSULIN GLARGINE'
             1660 'D04539 FOSINOPRIL-HYDROCHLOROTHIAZIDE'
             1661 'D04540 GEMTUZUMAB' 1662 'D04541 AZELASTINE OPHTHALMIC'
             1663 'D04547 ATOVAQUONE-PROGUANIL' 1664 'D04557 CLOBAZAM'
             1665 'D04572 FORMOTEROL' 1666 'D04597 TETRABENAZINE'
             1667 'D04611 FLUTICASONE-SALMETEROL' 1668 'D04659 TINZAPARIN'
             1669 'D04669 VIGABATRIN'
             1670 'D04674 DIPHTH/HAEMOPHILUS/PERTUSSIS/TETANUS/POLIO'
             1671 'D04675 DIPHTHERIA/PERTUSSIS,ACEL/TETANUS/POLIO'
             1672 'D04685 HEPATITIS A-HEPATITIS B VACCINE'
             1673 'D04689 CALAMINE-DIPHENHYDRAMINE TOPICAL'
             1674 'D04694 TENECTEPLASE' 1675 'D04695 COLESEVELAM'
             1676 'D04697 INSULIN ASPART' 1677 'D04698 ARGATROBAN'
             1678 'D04700 BALSALAZIDE' 1679 'D04702 DOCOSANOL TOPICAL'
             1680 'D04703 GLYBURIDE-METFORMIN'
             1681 'D04704 EFLORNITHINE TOPICAL'
             1682 'D04705 FLUDEOXYGLUCOSE F18'
             1683 'D04707 LEVOFLOXACIN OPHTHALMIC'
             1684 'D04708 ZOLEDRONIC ACID'
             1685 'D04711 CANDESARTAN-HYDROCHLOROTHIAZIDE'
             1686 'D04716 LOPINAVIR' 1687 'D04717 LOPINAVIR-RITONAVIR'
             1688 'D04718 MIFEPRISTONE' 1689 'D04720 ARSENIC TRIOXIDE'
             1690 'D04722 DICLOFENAC TOPICAL'
             1691 'D04723 CALCIUM CARBONATE/FAMOTIDINE/MG HYDROXIDE'
             1692 'D04725 IRON SUCROSE' 1693 'D04726 5-HYDROXYTRYPTOPHAN'
             1694 'D04727 ABACAVIR/LAMIVUDINE/ZIDOVUDINE'
             1695 'D04737 HYDROCHLOROTHIAZIDE-TELMISARTAN'
             1696 'D04738 APAP/DOXYLAMINE/PSEUDOEPHEDRINE'
             1697 'D04740 TACROLIMUS TOPICAL'
             1698 'D04741 CARBETAPENTANE/GUAIFENESIN/PHENYLEPHRINE'
             1699 'D04742 BENZOYL PEROXIDE-CLINDAMYCIN TOPICAL'
             1700 'D04743 NATEGLINIDE' 1701 'D04744 BIVALIRUDIN'
             1702 'D04746 PEGINTERFERON ALFA-2B' 1703 'D04747 ZIPRASIDONE'
             1704 'D04748 CASPOFUNGIN' 1705 'D04749 ESOMEPRAZOLE'
             1706 'D04750 GALANTAMINE'
             1707 'D04752 CARBINOXAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1708 'D04753 TRAVOPROST OPHTHALMIC'
             1709 'D04754 BIMATOPROST OPHTHALMIC'
             1710 'D04755 VALGANCICLOVIR' 1711 'D04756 ALEMTUZUMAB'
             1712 'D04757 ALMOTRIPTAN' 1713 'D04758 IMATINIB'
             1714 'D04760 DROSPIRENONE-ETHINYL ESTRADIOL'
             1715 'D04761 MINOCYCLINE TOPICAL'
             1716 'D04762 METHSCOPOLAMINE-PSEUDOEPHEDRINE'
             1717 'D04763 NESIRITIDE'
             1718 'D04764 CETIRIZINE-PSEUDOEPHEDRINE'
             1719 'D04765 HYDROCORTISONE-LIDOCAINE TOPICAL'
             1720 'D04766 ACETAMINOPHEN-TRAMADOL' 1721 'D04767 CEFDITOREN'
             1722 'D04770 CARBETAPENTANE-CHLORPHENIRAMINE'
             1723 'D04771 DARBEPOETIN ALFA' 1724 'D04772 ETONOGESTREL'
             1725 'D04773 ETHINYL ESTRADIOL-ETONOGESTREL'
             1726 'D04774 TENOFOVIR' 1727 'D04775 ANAKINRA'
             1728 'D04776 FROVATRIPTAN' 1729 'D04777 DEXMETHYLPHENIDATE'
             1730 'D04778 VALDECOXIB'
             1731 'D04779 ETHINYL ESTRADIOL-NORELGESTROMIN'
             1732 'D04782 BOSENTAN' 1733 'D04783 ERTAPENEM'
             1734 'D04784 PIMECROLIMUS TOPICAL' 1735 'D04785 DESLORATADINE'
             1736 'D04786 FONDAPARINUX' 1737 'D04787 LOVASTATIN-NIACIN'
             1738 'D04788 DUTASTERIDE' 1739 'D04789 NITISINONE'
             1740 'D04790 PEGFILGRASTIM'
             1741 'D04791 FLUOCINOLONE/HYDROQUINONE/TRETINOIN TOPICAL'
             1742 'D04792 ASA/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1743 'D04793 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PE'
             1744 'D04794 CARBINOXAMINE/METHSCOPOLAMINE/PSEUDOEPHEDRINE'
             1745 'D04795 BUDESONIDE-FORMOTEROL' 1746 'D04796 PERFLUTREN'
             1747 'D04797 ALFUZOSIN' 1748 'D04798 TEGASEROD'
             1749 'D04799 FULVESTRANT' 1750 'D04800 IFOSFAMIDE-MESNA'
             1751 'D04801 OLMESARTAN' 1752 'D04802 TREPROSTINIL'
             1753 'D04803 VORICONAZOLE' 1754 'D04805 RASBURICASE'
             1755 'D04806 SODIUM OXYBATE' 1756 'D04811 OXALIPLATIN'
             1757 'D04812 ESCITALOPRAM' 1758 'D04814 ADEFOVIR'
             1759 'D04815 EPLERENONE'
             1760 'D04817 DEXCHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             1761 'D04818 DEXCHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             1762 'D04819 BUPRENORPHINE-NALOXONE'
             1763 'D04820 METFORMIN-ROSIGLITAZONE'
             1764 'D04821 PEGINTERFERON ALFA-2A'
             1765 'D04823 GLIPIZIDE-METFORMIN' 1766 'D04824 EZETIMIBE'
             1767 'D04825 ARIPIPRAZOLE' 1768 'D04826 NITAZOXANIDE'
             1769 'D04827 ATOMOXETINE' 1770 'D04828 TERIPARATIDE'
             1771 'D04829 TIOTROPIUM' 1772 'D04831 SMALLPOX VACCINE'
             1773 'D04832 DIPHTHERIA/HEPB/PERTUSSIS,ACEL/POLIO/TETANUS'
             1774 'D04834 CYTARABINE LIPOSOMAL' 1775 'D04835 ADALIMUMAB'
             1776 'D04836 CYCLOSPORINE OPHTHALMIC'
             1777 'D04838 INSULIN ASPART PROTAMINE'
             1778 'D04839 INSULIN ASPART-INSULIN ASPART PROTAMINE'
             1779 'D04843 ALEFACEPT' 1780 'D04844 CAMPHOR-MENTHOL TOPICAL'
             1781 'D04845 IBRITUMOMAB' 1782 'D04849 ELETRIPTAN'
             1783 'D04850 CARBETAPENTANE/PHENYLEPHRINE/PYRILAMINE'
             1784 'D04851 ROSUVASTATIN' 1785 'D04852 BUPIVACAINE-FENTANYL'
             1786 'D04853 ENFUVIRTIDE' 1787 'D04854 PEGVISOMANT'
             1788 'D04855 APREPITANT' 1789 'D04856 BOTULISM ANTITOXIN'
             1790 'D04857 GATIFLOXACIN OPHTHALMIC'
             1791 'D04858 ANTHRAX VACCINE ADSORBED'
             1792 'D04859 GEMIFLOXACIN' 1793 'D04860 MOXIFLOXACIN OPHTHALMIC'
             1794 'D04861 DIPHENHYDRAMINE-PHENYLEPHRINE'
             1795 'D04862 BROMPHENIRAMINE/DM/GUAIFENESIN/PSE'
             1796 'D04863 CHLORPHENIRAMINE/IBUPROFEN/PSEUDOEPHEDRINE'
             1797 'D04864 CARBETAPENTANE-PSEUDOEPHEDRINE'
             1798 'D04866 AGALSIDASE BETA' 1799 'D04868 GEFITINIB'
             1800 'D04869 CHLORPHENIRAMINE/DIHYDROCODEINE/PSE'
             1801 'D04870 DIHYDROCODEINE/GUAIFENESIN/PSEUDOEPHEDRINE'
             1802 'D04871 BORTEZOMIB' 1803 'D04875 BETAINE'
             1804 'D04877 CARBIDOPA/ENTACAPONE/LEVODOPA'
             1805 'D04878 HYDROCHLOROTHIAZIDE-OLMESARTAN'
             1806 'D04879 PHENYLEPHRINE-POTASSIUM GUAIACOLSULFONATE'
             1807 'D04880 BROMPHENIRAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1808 'D04881 OMALIZUMAB' 1809 'D04882 ATAZANAVIR'
             1810 'D04884 EMTRICITABINE' 1811 'D04885 TOSITUMOMAB'
             1812 'D04886 IODINE I 131 TOSITUMOMAB'
             1813 'D04887 BUPIVACAINE-HYDROMORPHONE'
             1814 'D04888 PALONOSETRON'
             1815 'D04890 CIPROFLOXACIN-DEXAMETHASONE OTIC'
             1816 'D04892 INFLUENZA VIRUS VACCINE, LIVE, TRIVALENT'
             1817 'D04893 VARDENAFIL' 1818 'D04894 DAPTOMYCIN'
             1819 'D04895 CARBETAPENTANE/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1820 'D04896 TADALAFIL'
             1821 'D04897 TETRAHYDROZOLINE-ZINC OPHTHALMIC'
             1822 'D04898 EPINASTINE OPHTHALMIC' 1823 'D04899 MEMANTINE'
             1824 'D04900 SALICYLIC ACID-UREA TOPICAL'
             1825 'D04901 FOSAMPRENAVIR' 1826 'D04902 EFALIZUMAB'
             1827 'D04905 BROMPHENIRAMINE/DEXTROMETHORPH/PHENYLEPHRINE'
             1828 'D04913 LANSOPRAZOLE-NAPROXEN'
             1829 'D04914 ESTRADIOL-LEVONORGESTREL'
             1830 'D04915 SERTACONAZOLE TOPICAL' 1831 'D04916 CAPSICUM'
             1832 'D04917 FLUOXETINE-OLANZAPINE'
             1833 'D04920 PNEUMOCOCCAL 7-VALENT CONJUGATE VACCINE'
             1834 'D04921 TETANUS-DIPHTH TOXOIDS (TD) ADULT/ADOL'
             1835 'D04925 DIPHENHYDRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1836 'D04929 TROSPIUM' 1837 'D04933 TELITHROMYCIN'
             1838 'D04935 TINIDAZOLE' 1839 'D04986 ACAMPROSATE'
             1840 'D04991 APOMORPHINE' 1841 'D05029 LUTROPIN ALFA'
             1842 'D05044 BETAMETHASONE-CALCIPOTRIENE TOPICAL'
             1843 'D05047 PEMETREXED' 1844 'D05048 AMLODIPINE-ATORVASTATIN'
             1845 'D05101 CETUXIMAB'
             1846 'D05117 GUAIFENESIN-POTASSIUM GUAIACOLSULFONATE'
             1847 'D05119 DEXTROMETHORPHAN/GG/K GUAIACOLSULFONATE'
             1848 'D05145 ARTEMETHER-LUMEFANTRINE'
             1849 'D05150 CARBINOXAMINE/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1850 'D05214 BEVACIZUMAB' 1851 'D05215 ZINC ACETATE TOPICAL'
             1852 'D05216 DIPHENHYDRAMINE-ZINC ACETATE TOPICAL'
             1853 'D05217 MYCOPHENOLIC ACID' 1854 'D05218 CINACALCET'
             1855 'D05232 ILOPROST' 1856 'D05234 HYALURONAN'
             1857 'D05238 BENZOYL PEROXIDE-UREA TOPICAL'
             1858 'D05262 MOMETASONE' 1859 'D05265 NEBIVOLOL'
             1860 'D05269 CADEXOMER IODINE TOPICAL'
             1861 'D05278 INSULIN GLULISINE'
             1862 'D05283 BRIMONIDINE-TIMOLOL OPHTHALMIC'
             1863 'D05292 APAP/CAFFEINE/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1864 'D05293 AZACITIDINE' 1865 'D05294 RIFAXIMIN'
             1866 'D05303 CHLORPHENIRAMINE-CODEINE'
             1867 'D05332 PITCHER PLANT'
             1868 'D05334 BROMPHENIRAMINE/CODEINE/PHENYLEPHRINE'
             1869 'D05337 PNEUMOCOCCAL 23-POLYVALENT VACCINE'
             1870 'D05338 DIPHTHERIA-TETANUS TOXOIDS (DT) PED'
             1871 'D05339 HEPATITIS A PEDIATRIC VACCINE'
             1872 'D05340 HEPATITIS A ADULT VACCINE'
             1873 'D05341 HAEMOPHILUS B CONJUGATE (HBOC) VACCINE'
             1874 'D05343 HAEMOPHILUS B CONJUGATE (PRP-T) VACCINE'
             1875 'D05346 GADOBUTROL' 1876 'D05348 EZETIMIBE-SIMVASTATIN'
             1877 'D05349 BISACODYL-PEG 3350 WITH ELECTROLYTES'
             1878 'D05350 POLYETHYLENE GLYCOL 3350'
             1879 'D05351 APAP/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1880 'D05352 EMTRICITABINE-TENOFOVIR'
             1881 'D05354 ABACAVIR-LAMIVUDINE' 1882 'D05355 DULOXETINE'
             1883 'D05357 IBANDRONATE'
             1884 'D05361 CARBETAPENTANE-GUAIFENESIN'
             1885 'D05366 APAP/DEXTROMETHORPHAN/DOXYLAMINE'
             1886 'D05383 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1887 'D05384 DEXTROMETHORPHAN/PHENIRAMINE/PHENYLEPHRINE'
             1888 'D05389 BISACODYL-MAGNESIUM CITRATE'
             1889 'D05395 LANTHANUM CARBONATE'
             1890 'D05411 CHLORPHENIRAMINE-METHSCOPOLAMINE'
             1891 'D05412 ERLOTINIB' 1892 'D05413 SOLIFENACIN'
             1893 'D05414 NATALIZUMAB' 1894 'D05415 IBUPROFEN-OXYCODONE'
             1895 'D05416 CHLORDIAZEPOXIDE-METHSCOPOLAMINE'
             1896 'D05417 PALIFERMIN' 1897 'D05418 PEGAPTANIB OPHTHALMIC'
             1898 'D05420 ALOH/DIPHENHYD/LIDOCAINE/MGOH/SIMETH TOPICAL'
             1899 'D05421 ESZOPICLONE' 1900 'D05422 DARIFENACIN'
             1901 'D05423 CLOFARABINE' 1902 'D05424 ZICONOTIDE'
             1903 'D05425 LOTEPREDNOL-TOBRAMYCIN OPHTHALMIC'
             1904 'D05426 BROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1905 'D05427 PACLITAXEL PROTEIN-BOUND'
             1906 'D05428 GADOBENATE DIMEGLUMINE'
             1907 'D05432 MENINGOCOCCAL CONJUGATE VACCINE'
             1908 'D05433 DIGESTIVE ENZYMES/HYOSCYAMINE/PHENYLTOLOXAMIN'
             1909 'D05434 BROMPHENIRAMINE/CARBETAPENTANE/PHENYLEPHRINE'
             1910 'D05436 INSULIN DETEMIR'
             1911 'D05459 POVIDONE-TETRAHYDROZOLINE OPHTHALMIC'
             1912 'D05461 SODIUM BENZOATE-SODIUM PHENYLACETATE'
             1913 'D05465 CICLESONIDE'
             1914 'D05470 ASCORBIC ACID-IRON POLYSACCHARIDE'
             1915 'D05471 ALPHA-D-GALACTOSIDASE'
             1916 'D05473 DESLORATADINE-PSEUDOEPHEDRINE'
             1917 'D05487 MICAFUNGIN' 1918 'D05488 PRAMLINTIDE'
             1919 'D05508 PREGABALIN' 1920 'D05518 BROMFENAC OPHTHALMIC'
             1921 'D05525 ENTECAVIR'
             1922 'D05526 ALENDRONATE-CHOLECALCIFEROL'
             1923 'D05527 FLUOCINOLONE OPHTHALMIC'
             1924 'D05528 TRICHOPHYTON SKIN TEST' 1925 'D05529 EXENATIDE'
             1926 'D05530 DROSPIRENONE-ESTRADIOL'
             1927 'D05535 HEME IRON POLYPEPTIDE'
             1928 'D05536 APAP/GUAIFENESIN/PSEUDOEPHEDRINE'
             1929 'D05537 TIGECYCLINE' 1930 'D05538 TIPRANAVIR'
             1931 'D05539 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1932 'D05540 HYDRALAZINE-ISOSORBIDE DINITRATE'
             1933 'D05543 DAPSONE TOPICAL'
             1934 'D05544 APAP/GUAIFENESIN/PHENYLEPHRINE'
             1935 'D05578 RAMELTEON'
             1936 'D05583 APAP/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1937 'D05612 RASAGILINE' 1938 'D05626 EVEROLIMUS'
             1939 'D05630 CALCIUM CARBONATE-RISEDRONATE'
             1940 'D05632 BISACODYL/SODIUM BIPHOSPHATE/SODIUM PHOSPHATE'
             1941 'D05633 NEPAFENAC OPHTHALMIC'
             1942 'D05635 METFORMIN-PIOGLITAZONE' 1943 'D05636 MECASERMIN'
             1944 'D05637 LACTOBACILLUS RHAMNOSUS GG'
             1945 'D05644 APAP/CAFFEINE/ISOMETHEPTENE MUCATE'
             1946 'D05645 MEASLES/MUMPS/RUBELLA/VARICELLA VIRUS VACCINE'
             1947 'D05646 SACCHAROMYCES BOULARDII LYO'
             1948 'D05647 FERRIC SUBSULFATE TOPICAL'
             1949 'D05649 CEFTRIAXONE-LIDOCAINE'
             1950 'D05651 SODIUM HYALURONATE TOPICAL'
             1951 'D05654 APAP/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1952 'D05659 DEFERASIROX'
             1953 'D05661 ACETAMINOPHEN-GUAIFENESIN'
             1954 'D05674 GLIMEPIRIDE-ROSIGLITAZONE' 1955 'D05691 SORAFENIB'
             1956 'D05692 MECASERMIN RINFABATE' 1957 'D05694 ABATACEPT'
             1958 'D05696 LENALIDOMIDE' 1959 'D05702 METHYLSULFONYLMETHANE'
             1960 'D05703 CHONDROITIN/GLUCOSAMINE/METHYLSULFONYLMETHANE'
             1961 'D05704 IMMUNE GLOBULIN SUBCUTANEOUS'
             1962 'D05717 SUNITINIB' 1963 'D05719 RANOLAZINE'
             1964 'D05722 GALLIUM CITRATE GA-67' 1965 'D05736 LUBIPROSTONE'
             1966 'D05753 MICONAZOLE-ZINC OXIDE TOPICAL'
             1967 'D05757 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PE'
             1968 'D05765 INSULIN INHALATION, RAPID ACTING'
             1969 'D05768 APAP/PHENIRAMINE/PHENYLEPHRINE'
             1970 'D05770 OMEPRAZOLE-SODIUM BICARBONATE'
             1971 'D05773 L-METHYLFOLATE'
             1972 'D05774 AMMONIUM LACTATE-UREA TOPICAL' 1973 'D05776 IODINE'
             1974 'D05777 IODINE-POTASSIUM IODIDE'
             1975 'D05778 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PE'
             1976 'D05781 TETANUS/DIPHTH/PERTUSS (TDAP) ADULT/ADOL'
             1977 'D05782 DIPHTHERIA/TETANUS/PERTUSSIS (DTAP) PED'
             1978 'D05785 RABIES VACCINE, HUMAN DIPLOID CELL'
             1979 'D05786 RABIES VACCINE, PURIFIED CHICK EMBRYO CELL'
             1980 'D05788 DECITABINE'
             1981 'D05806 FERROUS FUMARATE/FA/IRON POLYSACCHARIDE'
             1982 'D05807 VARENICLINE' 1983 'D05813 ZOSTER VACCINE LIVE'
             1984 'D05814 DEXTROMETHORPHAN-PHENYLEPHRINE'
             1985 'D05815 FLUORESCEIN'
             1986 'D05817 HUMAN PAPILLOMAVIRUS VACCINE'
             1987 'D05819 DIPHENHYDRAMINE-IBUPROFEN' 1988 'D05825 DARUNAVIR'
             1989 'D05830 FERUMOXSIL' 1990 'D05831 DASATINIB'
             1991 'D05835 RANIBIZUMAB OPHTHALMIC'
             1992 'D05847 EFAVIRENZ/EMTRICITABINE/TENOFOVIR'
             1993 'D05848 ROTIGOTINE' 1994 'D05851 LEVOCETIRIZINE'
             1995 'D05853 POSACONAZOLE' 1996 'D05855 IDURSULFASE'
             1997 'D05856 GLIMEPIRIDE-PIOGLITAZONE'
             1998 'D05864 COMPLEMENT C1 ESTERASE INHIBITOR'
             1999 'D05866 GUAR GUM'
             2000 'D05874 ANTIHEMOPHILIC FACTOR-VON WILLEBRAND FACTOR'
             2001 'D05877 DEXTROMETHORPHAN/DIPHENHYDRAMINE/PE'
             2002 'D05878 BENZALKONIUM CHLORIDE-BENZOCAINE TOPICAL'
             2003 'D05879 PANITUMUMAB' 2004 'D05891 VORINOSTAT'
             2005 'D05892 DEXCHLORPHENIRAMINE/DEXTROMETHO/PE/PYRILAMINE'
             2006 'D05893 ARFORMOTEROL'
             2007 'D05894 CALAMINE-ZINC OXIDE TOPICAL'
             2008 'D05896 SITAGLIPTIN'
             2009 'D05897 BENZOYL PEROXIDE-SALICYLIC ACID TOPICAL'
             2010 'D05899 CICLESONIDE NASAL'
             2011 'D05963 COAGULATION FACTOR IX' 2012 'D05964 ALOE VERA'
             2013 'D05973 CLINDAMYCIN-TRETINOIN TOPICAL'
             2014 'D05974 ANTIHEMOPHILIC FACTOR'
             2015 'D06008 BENZYL ALCOHOL TOPICAL'
             2016 'D06032 FLUOCINOLONE OTIC'
             2017 'D06058 DEXBROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             2018 'D06080 APAP/CAFFEINE/MAGNESIUM SALICYLATE'
             2019 'D06214 COLLAGEN' 2020 'D06227 IOXILAN'
             2021 'D06272 DIENOGEST-ESTRADIOL' 2022 'D06297 PALIPERIDONE'
             2023 'D06370 TURMERIC' 2024 'D06392 WHEAT DEXTRIN'
             2025 'D06507 CINNAMON' 2026 'D06635 MILNACIPRAN'
             2027 'D06648 ATROPINE/CPM/HYOSCYAMINE/PSE/SCOPOLAMINE'
             2028 'D06655 ALPHA-LIPOIC ACID'
             2029 'D06662 AMLODIPINE-VALSARTAN'
             2030 'D06663 LISDEXAMFETAMINE' 2031 'D06665 ALISKIREN'
             2032 'D06672 LAPATINIB' 2033 'D06673 ECULIZUMAB'
             2034 'D06720 METFORMIN-SITAGLIPTIN'
             2035 'D06831 RETAPAMULIN TOPICAL'
             2036 'D06833 ACETAMINOPHEN-ASPIRIN'
             2037 'D06834 BISMUTH SUBCITRATE POTASSIUM/METRONIDAZO/TCN'
             2038 'D06835 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             2039 'D06836 TEMSIROLIMUS' 2040 'D06841 AMBRISENTAN'
             2041 'D06842 ARMODAFINIL' 2042 'D06848 LUTEIN'
             2043 'D06851 AZITHROMYCIN OPHTHALMIC' 2044 'D06852 MARAVIROC'
             2045 'D06857 ACETIC/ANTIPYRINE/BENZOCAINE/POLYCOS OTIC'
             2046 'D06862 HELIUM' 2047 'D06864 HELIUM-OXYGEN'
             2048 'D06867 BIOTIN' 2049 'D06868 MENTHOL-ZINC OXIDE TOPICAL'
             2050 'D06872 APAP/CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             2051 'D06891 CHLOROPHYLLIN COPPER COM/PAPAIN/UREA TOPICAL'
             2052 'D06900 COLLAGEN TOPICAL'
             2053 'D06905 AMLODIPINE-OLMESARTAN'
             2054 'D06976 ASA/CHLORPHENIRAMINE/PHENYLEPHRINE'
             2055 'D07048 RALTEGRAVIR' 2056 'D07049 DORIPENEM'
             2057 'D07051 IXABEPILONE'
             2058 'D07055 CHLORPHENIRAMINE/GUAIFENESIN/METHSCOPOLAMI/PE'
             2059 'D07057 NILOTINIB'
             2060 'D07058 SULFACETAMIDE SODIUM/SULFUR/UREA TOPICAL'
             2061 'D07059 CITRIC ACID-POTASSIUM BICARBONATE'
             2062 'D07063 BROMPHENIRAMINE-DIPHENHYDRAMINE'
             2063 'D07065 BENZYL ALCOHOL-ZINC ACETATE TOPICAL'
             2064 'D07068 SAPROPTERIN' 2065 'D07069 RUFINAMIDE'
             2066 'D07075 PERMETHRIN/PIPERONYL BUTOXIDE/PYRETHR TOPICAL'
             2067 'D07076 ETRAVIRINE'
             2068 'D07077 ALISKIREN-HYDROCHLOROTHIAZIDE'
             2069 'D07110 NIACIN-SIMVASTATIN' 2070 'D07113 DESVENLAFAXINE'
             2071 'D07121 BENDAMUSTINE' 2072 'D07130 NAPROXEN-SUMATRIPTAN'
             2073 'D07131 REGADENOSON' 2074 'D07132 OLOPATADINE NASAL'
             2075 'D07134 CERTOLIZUMAB' 2076 'D07135 METHYLNALTREXONE'
             2077 'D07137 DABIGATRAN' 2078 'D07162 FESOTERODINE'
             2079 'D07292 METFORMIN-REPAGLINIDE'
             2080 'D07298 DIFLUPREDNATE OPHTHALMIC'
             2081 'D07300 CHLOPHEDIANOL/DEXCHLORPHENIRAMINE/PSE'
             2082 'D07302 CHLOPHEDIANOL/GUAIFENESIN/PSEUDOEPHEDRINE'
             2083 'D07306 BENZOCAINE-MENTHOL TOPICAL' 2084 'D07309 GENISTEIN'
             2085 'D07312 CLEVIDIPINE' 2086 'D07315 GLUTAMINE'
             2087 'D07320 ROMIPLOSTIM' 2088 'D07347 BIFIDOBACTERIUM INFANTIS'
             2089 'D07349 LACOSAMIDE'
             2090 'D07351 CARBETAPENTANE/PSEUDOEPHEDRINE/PYRILAMINE'
             2091 'D07354 SILODOSIN' 2092 'D07356 RIVAROXABAN'
             2093 'D07357 ELTROMBOPAG' 2094 'D07371 FENOFIBRIC ACID'
             2095 'D07374 BIMATOPROST TOPICAL OPHTHALMIC'
             2096 'D07382 ADAPALENE-BENZOYL PEROXIDE TOPICAL'
             2097 'D07385 HEPARIN FLUSH'
             2098 'D07387 HYDROCORTISONE/SALICYLIC ACID/SULFUR TOPICAL'
             2099 'D07395 DEXLANSOPRAZOLE' 2100 'D07396 USTEKINUMAB'
             2101 'D07397 FEBUXOSTAT'
             2102 'D07405 CARBETAPENTANE/PE/POTASSIUM GUAIACOLSULFONATE'
             2103 'D07409 PRASUGREL' 2104 'D07411 DEGARELIX'
             2105 'D07418 BENZOCAINE-RESORCINOL TOPICAL'
             2106 'D07435 GOLIMUMAB'
             2107 'D07440 AMLODIPINE/HYDROCHLOROTHIAZIDE/VALSARTAN'
             2108 'D07441 ILOPERIDONE' 2109 'D07447 TOLVAPTAN'
             2110 'D07453 TAPENTADOL' 2111 'D07458 DRONEDARONE'
             2112 'D07459 FERUMOXYTOL'
             2113 'D07464 INFLUENZA VIRUS VACCINE, H1N1, INACTIVATED'
             2114 'D07466 LIRAGLUTIDE' 2115 'D07467 SAXAGLIPTIN'
             2116 'D07472 MORPHINE-NALTREXONE' 2117 'D07473 ASENAPINE'
             2118 'D07481 POLY-L-LACTIC ACID'
             2119 'D07482 BEPOTASTINE OPHTHALMIC' 2120 'D07483 TELAVANCIN'
             2121 'D07485 INFLUENZA VIRUS VACCINE, H1N1, LIVE'
             2122 'D07486 ALISKIREN-VALSARTAN'
             2123 'D07491 DIPHENHYDRAMINE/LIDOCAINE/NYSTATIN TOPICAL'
             2124 'D07492 PRALATREXATE' 2125 'D07496 TOCILIZUMAB'
             2126 'D07498 AMLODIPINE-TELMISARTAN' 2127 'D07499 PAZOPANIB'
             2128 'D07505 COPPER' 2129 'D07509 OFATUMUMAB'
             2130 'D07518 SILVER TOPICAL' 2131 'D07546 DALFAMPRIDINE'
             2132 'D07550 DEXTROMETHORPHAN-DOXYLAMINE'
             2133 'D07565 IPILIMUMAB'
             2134 'D07586 PNEUMOCOCCAL 13-VALENT CONJUGATE VACCINE'
             2135 'D07589 BIOFLAVONOIDS-ZINC GLYCINATE'
             2136 'D07631 ESOMEPRAZOLE-NAPROXEN'
             2137 'D07634 DUTASTERIDE-TAMSULOSIN' 2138 'D07637 PITAVASTATIN'
             2139 'D07638 SIPULEUCEL-T' 2140 'D07640 DENOSUMAB'
             2141 'D07642 ANTI-THYMOCYTE GLOBULIN (RABBIT)'
             2142 'D07644 HEPATITIS B ADULT VACCINE'
             2143 'D07645 ONABOTULINUMTOXINA'
             2144 'D07646 ABOBOTULINUMTOXINA' 2145 'D07647 RACEPINEPHRINE'
             2146 'D07658 CABAZITAXEL'
             2147 'D07659 CAFFEINE-MAGNESIUM SALICYLATE'
             2148 'D07660 FORMOTEROL-MOMETASONE'
             2149 'D07668 AMLODIPINE/HYDROCHLOROTHIAZIDE/OLMESARTAN'
             2150 'D07670 ALCAFTADINE OPHTHALMIC' 2151 'D07684 ROFLUMILAST'
             2152 'D07688 PEGLOTICASE'
             2153 'D07691 MAGNESIUM/POTASSIUM/SODIUM SULFATES'
             2154 'D07692 FINGOLIMOD'
             2155 'D07697 DROSPIRENONE/ETHINYL ESTRADIOL/LEVOMEFOLATE'
             2156 'D07705 LURASIDONE' 2157 'D07706 CEFTAROLINE'
             2158 'D07709 METFORMIN-SAXAGLIPTIN' 2159 'D07715 TESAMORELIN'
             2160 'D07716 ERIBULIN' 2161 'D07727 PENICILLIN G BENZATHINE'
             2162 'D07729 PENICILLIN G POTASSIUM'
             2163 'D07730 PENICILLIN V POTASSIUM'
             2164 'D07738 BROMPHENIRAMINE/CHLOPHEDIANOL/PSE'
             2165 'D07740 VILAZODONE' 2166 'D07754 AZILSARTAN'
             2167 'D07756 BELIMUMAB'
             2168 'D07757 LIDOCAINE-SODIUM BICARBONATE'
             2169 'D07761 VANDETANIB' 2170 'D07766 ABIRATERONE'
             2171 'D07767 LINAGLIPTIN' 2172 'D07774 BOCEPREVIR'
             2173 'D07777 TELAPREVIR'
             2174 'D07796 EMTRICITABINE/RILPIVIRINE/TENOFOVIR'
             2175 'D07798 VEMURAFENIB' 2176 'I00031 XYLENE'
             2177 'I00035 TURPENTINE' 2178 'I00039 TRICHLOROETHANE'
             2179 'I00040 TOLUENE' 2180 'I00081 NAPHTHALENE'
             2181 'I00084 METHYLENE CHLORIDE' 2182 'I00088 METHANOL'
             2183 'I00102 FORMALDEHYDE' 2184 'I00106 ETHYLENE GLYCOL'
             2185 'I00108 ETHYL ETHER' 2186 'I00162 ACETONE'
             2187 'I00173 CYANOACRYLATE' 2188 'I00176 ISOBUTYL NITRITE'
             2189 'I00190 AEROSOL SPRAY-NOS' 2190 'I00196 BUTANE'
             2191 'I00198 TRICHLOROFLUOROMETHANE' 2192 'I00200 METHANE'
             2193 'I00201 PETROLEUM HYDROCARBONS'
             2194 'I00203 CARBON TETRACHLORIDE' 2195 'I00207 BUTYL ALCOHOL'
             2196 'I00209 ALPHA TERPINEOL' 2197 'I00210 FREON'
             2198 'I00211 DICHLOROBENZENE' 2199 'I00212 PROPOXUR'
             2200 'I00216 PROPANE' 2201 'I00219 PHENOLIC DISINFECTANTS'
             2202 'I00221 MINERAL SEAL OIL' 2203 'I00238 FLUORINE'
             2204 'I00240 HYDROCARBON' 2205 'I00247 CHLORINATED HYDROCARBONS'
             2206 'I00251 CRESOL' 2207 'I00256 BUTYL ACETATE'
             2208 'I00343 CLEANER/UNKNOWN COMPOSITION'
             2209 'I00345 COSMETIC/UNKNOWN COMPOSITION'
             2210 'I00348 PESTICIDE/UNKNOWN COMPOSITION'
             2211 'I00349 VOLATILE/UNKNOWN COMPONENTS'
             2212 'I00350 PAINT/UNKNOWN COMPOSITION'
             2213 'I00543 TRICHLOROETHANE/TRICHLOROETHYLENE'
             2214 'I00556 PETROLEUM HYDROCARBONS/TRICHLOROETHANE'
             2215 'I01283 ETHANOL-NP' 2216 'I01328 TRICHLOROMETHANE'
             2217 'I01336 FLUORINATED HYDROCARBONS' 2218 'I01337 ISOBUTANE'
             2219 'I01400 CHLORODIFLUOROMETHANE' 2220 'I01425 ETHYL ACETATE'
             2221 'J00001 LYSERGIC ACID DIETHYLAMIDE'
             2222 'J00002 METHYLENEDIOXYMETHAMPHETAMINE'
             2223 'J00004 FLUNITRAZEPAM' 2224 'J00020 BROMELAIN'
             2225 'J00023 NOMIFENSINE MALEATE' 2226 'J00027 MECLOZINE HCL'
             2227 'J00028 NITRAZEPAM' 2228 'J00030 ZOMEPIRAC'
             2229 'J00032 XYLAZINE' 2230 'J00033 VITAMIN K'
             2231 'J00036 L-TRYPTOPHAN' 2232 'J00049 SULFORIDAZINE'
             2233 'J00050 SULFADINE' 2234 'J00053 SALINE'
             2235 'J00061 PRAZEPAM' 2236 'J00064 PHENMETRAZINE HCL'
             2237 'J00066 PHENACETIN' 2238 'J00089 METHACYCLINE'
             2239 'J00090 MERBROMIN' 2240 'J00092 LUTREXIN'
             2241 'J00093 LORMETAZEPAM' 2242 'J00094 LACTOSE'
             2243 'J00095 KETOTIFEN FUMARATE' 2244 'J00096 INFANT FORMULA'
             2245 'J00097 HYDROXY-N-METHYLMORPHINAN'
             2246 'J00104 FENPROPOREX' 2247 'J00110 ERYTHRITYL TETRANITRATE'
             2248 'J00114 DYPYRONE' 2249 'J00120 DIHYDROMORPHINONE'
             2250 'J00122 ALDOSTERONE' 2251 'J00129 CHLOROPYRAMINE'
             2252 'J00148 CARBAMATE' 2253 'J00150 BROMAZEPAM'
             2254 'J00164 ACEPROMAZINE' 2255 'J00168 METHCATHINONE'
             2256 'J00171 CATHINONE' 2257 'J00174 METHYLENEDIOXYAMPHETAMINE'
             2258 'J00177 METHAQUALONE' 2259 'J00178 MESCALINE'
             2260 'J00179 PSILOCYBIN' 2261 'J00180 MORNING GLORY SEEDS'
             2262 'J00192 DATURA SAUVEOLENS'
             2263 'J00215 GAMMA BUTYROLACTONE' 2264 'J00248 EUCALYPTUS OIL'
             2265 'J00249 PEPPER' 2266 'J00263 DIMETHOXYMETHAMPHETAMINE'
             2267 'J00264 DATURA STRAMONIUM' 2268 'J00265 CANTHARIDINE'
             2269 'J00278 ISOPROPAMIDE IODIDE' 2270 'J00280 ALLOBARBITAL'
             2271 'J00290 CLOBENZOREX' 2272 'J00293 AMBROXOL'
             2273 'J00294 TETRAMYCIN' 2274 'J00295 RHODOMYCIN'
             2275 'J00331 ZOPICLONE' 2276 'J00336 MYCADRINE'
             2277 'J00337 POTASSIUM' 2278 'J00339 PYRETHRUM'
             2279 'J00356 ARECOLINE' 2280 'J00358 PHOSPHATIDYLETHANOLAMINE'
             2281 'J00360 CHLORPHENTERMINE' 2282 'J00362 BARBITURIC ACID'
             2283 'J00364 BARBITAL'
             2284 'J00369 BROMO-DIMETHOXYPHENETHYLAMINE'
             2285 'J00500 MARIJUANA/METHAMPHETAMINE'
             2286 'J00501 FORMALDEHYDE/MARIJUANA'
             2287 'J00502 COCAINE/METHAMPHETAMINE'
             2288 'J00504 COCAINE/MARIJUANA' 2289 'J00507 COCAINE/HEROIN'
             2290 'J00510 MARIJUANA/PHENCYCLIDINE'
             2291 'J00511 COCAINE/PHENCYCLIDINE'
             2292 'J00512 LYSERGIC ACID DIETHYLAMIDE/METHAMPHETAMINE'
             2293 'J00513 LYSERGIC ACID DIETHYLAMIDE/PHENCYCLIDINE'
             2294 'J00514 HEROIN/MARIJUANA'
             2295 'J00531 AMOBARBITAL/DEXTROAMPHETAMINE/THYROID DESICCATED'
             2296 'J00533 PENTOBARBITAL/PHENOBARBITAL'
             2297 'J00539 CAFFEINE/EPHEDRINE'
             2298 'J00540 ACETAMINOPHEN/CHLORZOXAZONE'
             2299 'J00558 ASPIRIN/CAFFEINE/CODEINE/PHENACETIN'
 2300 'J00566 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE/DEXTROMETHORPHAN/GUAIFENESIN'
             2301 'J00568 COCAINE/ETHANOL'
             2302 'J00572 SALICYLAMIDE/SCOPOLAMINE'
             2303 'J00577 CODEINE/TERPIN HYDRATE'
             2304 'J00591 ACETAMINOPHEN/CAFFEINE/CODEINE'
             2305 'J00593 AMYLASE/PROTEASE'
             2306 'J00594 ASPIRIN/CAFFEINE/CODEINE'
             2307 'J01003 ANTIFUNGALS-NOS'
             2308 'J01004 ANTIMALARIAL AGENTS-NOS'
             2309 'J01005 ANTITUBERCULOSIS AGENTS-NOS'
             2310 'J01006 ANTIVIRAL AGENTS-NOS'
             2311 'J01008 CEPHALOSPORINS-NOS' 2312 'J01010 MACROLIDES-NOS'
             2313 'J01011 ANTIBIOTICS-NOS' 2314 'J01012 PENICILLINS-NOS'
             2315 'J01013 QUINOLONES-NOS' 2316 'J01014 SULFONAMIDES-NOS'
             2317 'J01015 TETRACYCLINES-NOS'
             2318 'J01016 URINARY ANTI-INFECTIVES-NOS'
             2319 'J01017 AMINOGLYCOSIDES-NOS'
             2320 'J01018 ANTIHYPERLIPIDEMIC AGENTS-NOS'
             2321 'J01026 RADIOPHARMACEUTICALS-NOS'
             2322 'J01028 ANTITOXINS AND ANTIVENINS-NOS'
             2323 'J01029 BACTERIAL VACCINES-NOS'
             2324 'J01030 COLONY STIMULATING FACTORS-NOS'
             2325 'J01031 IMMUNE GLOBULINS-NOS'
             2326 'J01033 RECOMBINANT HUMAN ERYTHROPOIETINS-NOS'
             2327 'J01034 TOXOIDS-NOS' 2328 'J01035 VIRAL VACCINES-NOS'
             2329 'J01037 CARDIOVASCULAR AGENTS-NOS'
             2330 'J01039 ANGIOTENSIN CONVERTING ENZYME INHIBITORS-NOS'
             2331 'J01040 ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING-NOS'
             2332 'J01042 ANTIANGINAL AGENTS-NOS'
             2333 'J01043 ANTIARRHYTHMIC AGENTS-NOS'
             2334 'J01044 BETA-ADRENERGIC BLOCKING AGENTS-NOS'
             2335 'J01045 CALCIUM CHANNEL BLOCKING AGENTS-NOS'
             2336 'J01047 INOTROPIC AGENTS-NOS'
             2337 'J01049 PERIPHERAL VASODILATORS-NOS'
             2338 'J01050 VASODILATORS-NOS' 2339 'J01051 VASOPRESSORS-NOS'
             2340 'J01052 ANTIHYPERTENSIVE COMBINATIONS-NOS'
             2341 'J01053 ANGIOTENSIN II INHIBITORS-NOS'
             2342 'J01056 ANALGESICS-NOS'
             2343 'J01057 NARCOTIC ANALGESICS-NOS'
             2344 'J01058 NONSTEROIDAL ANTI-INFLAMMATORY AGENTS-NOS'
             2345 'J01059 SALICYLATES-NOS' 2346 'J01061 ANTICONVULSANTS-NOS'
             2347 'J01063 ANTIPARKINSON AGENTS-NOS'
             2348 'J01065 BARBITURATES-NOS' 2349 'J01066 BENZODIAZEPINES-NOS'
             2350 'J01067 ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS'
             2351 'J01068 CNS STIMULANTS-NOS'
             2352 'J01069 GENERAL ANESTHETICS-NOS'
             2353 'J01073 ANTIPSYCHOTICS-NOS'
             2354 'J01077 ANTICOAGULANTS-NOS'
             2355 'J01078 ANTIPLATELET AGENTS-NOS'
             2356 'J01081 THROMBOLYTICS-NOS'
             2357 'J01082 GASTROINTESTINAL AGENTS-NOS'
             2358 'J01083 ANTACIDS-NOS'
             2359 'J01084 ANTICHOLINERGICS/ANTISPASMODICS-NOS'
             2360 'J01085 ANTIDIARRHEALS-NOS'
             2361 'J01086 DIGESTIVE ENZYMES-NOS'
             2362 'J01088 GI STIMULANTS-NOS' 2363 'J01089 H2 ANTAGONISTS-NOS'
             2364 'J01090 LAXATIVES-NOS' 2365 'J01092 HORMONES-NOS'
             2366 'J01093 ADRENAL CORTICAL STEROIDS-NOS'
             2367 'J01094 ANTIDIABETIC AGENTS-NOS'
             2368 'J01096 SEX HORMONES-NOS' 2369 'J01098 THYROID DRUGS-NOS'
             2370 'J01099 IMMUNOSUPPRESSIVE AGENTS-NOS'
             2371 'J01101 ANTIDOTES-NOS' 2372 'J01102 CHELATING AGENTS-NOS'
             2373 'J01103 CHOLINERGIC MUSCLE STIMULANTS-NOS'
             2374 'J01104 LOCAL INJECTABLE ANESTHETICS-NOS'
             2375 'J01106 PSORALENS-NOS'
             2376 'J01107 RADIOCONTRAST AGENTS-NOS'
             2377 'J01108 GENITOURINARY TRACT AGENTS-NOS'
             2378 'J01111 IRON PRODUCTS-NOS'
             2379 'J01112 MINERALS AND ELECTROLYTES-NOS'
             2380 'J01113 ORAL NUTRITIONAL SUPPLEMENTS-NOS'
             2381 'J01115 VITAMIN AND MINERAL COMBINATIONS-NOS'
             2382 'J01116 INTRAVENOUS NUTRITIONAL PRODUCTS-NOS'
             2383 'J01118 ANTIHISTAMINES-NOS' 2384 'J01119 ANTITUSSIVES-NOS'
             2385 'J01120 BRONCHODILATORS-NOS'
             2386 'J01122 DECONGESTANTS-NOS' 2387 'J01123 EXPECTORANTS-NOS'
             2388 'J01124 RESPIRATORY AGENTS-NOS'
             2389 'J01125 RESPIRATORY INHALANT PRODUCTS-NOS'
             2390 'J01126 ANTIASTHMATIC COMBINATIONS-NOS'
             2391 'J01127 UPPER RESPIRATORY COMBINATIONS-NOS'
             2392 'J01129 ANORECTAL PREPARATIONS-NOS'
             2393 'J01130 ANTISEPTIC AND GERMICIDES-NOS'
             2394 'J01131 DERMATOLOGICAL AGENTS-NOS'
             2395 'J01134 TOPICAL ANESTHETICS-NOS'
             2396 'J01139 MOUTH AND THROAT PRODUCTS-NOS'
             2397 'J01143 STERILE IRRIGATING SOLUTIONS-NOS'
             2398 'J01145 PLASMA EXPANDERS-NOS'
             2399 'J01165 HMG-COA REDUCTASE INHIBITORS-NOS'
             2400 'J01170 MUSCLE RELAXANTS-NOS'
             2401 'J01174 ANDROGENS AND ANABOLIC STEROIDS-NOS'
             2402 'J01180 NARCOTIC ANALGESIC COMBINATIONS-NOS'
             2403 'J01181 ANTIRHEUMATICS-NOS'
             2404 'J01182 ANTIMIGRAINE AGENTS-NOS'
             2405 'J01183 ANTIGOUT AGENTS-NOS'
             2406 'J01206 BISPHOSPHONATES-NOS'
             2407 'J01208 NUTRACEUTICAL PRODUCTS-NOS'
             2408 'J01209 HERBAL PRODUCTS-NOS'
             2409 'J01229 FIBRIC ACID DERIVATIVES-NOS'
             2410 'J01231 LEUKOTRIENE MODIFIERS-NOS'
             2411 'J01235 NASAL PREPARATIONS-NOS'
             2412 'J01237 ANTIDEPRESSANTS-NOS' 2413 'J01241 ANOREXIANTS-NOS'
             2414 'J01243 INTERFERONS-NOS'
             2415 'J01244 MONOCLONAL ANTIBODIES-NOS'
             2416 'J01247 IMPOTENCE AGENTS-NOS'
             2417 'J01253 VAGINAL PREPARATIONS-NOS'
             2418 'J01254 ANTIPSORIATICS-NOS'
             2419 'J01256 PROTON PUMP INHIBITORS-NOS'
             2420 'J01261 DRUG UNKNOWN' 2421 'J01262 GAMMA HYDROXY BUTYRATE'
             2422 'J01271 PASSION FLOWER' 2423 'J01276 METHAPHENILENE'
             2424 'J01292 CODEINE COMBINATION-NOS'
             2425 'J01294 HALLUCINOGEN-NOS' 2426 'J01295 POLY-DRUGS'
             2427 'J01298 ANTINEOPLASTICS-NOS'
             2428 'J01300 ANTIBIOTICS/ANTINEOPLASTICS-NOS'
             2429 'J01301 HORMONES/ANTINEOPLASTICS-NOS'
             2430 'J01302 DIURETICS-NOS'
             2431 'J01303 ANTIEMETIC/ANTIVERTIGO AGENTS-NOS'
             2432 'J01305 VITAMINS-NOS'
             2433 'J01306 OPHTHALMIC PREPARATIONS-NOS'
             2434 'J01307 OTIC PREPARATIONS-NOS'
             2435 'J01308 ANALGESIC COMBINATIONS-NOS'
             2436 'J01309 COX-2 INHIBITOR-NOS'
             2437 'J01310 SSRI ANTIDEPRESSANTS-NOS'
             2438 'J01311 TRICYCLIC ANTIDEPRESSANTS-NOS'
             2439 'J01312 MONOAMINE OXIDASE INHIBITORS-NOS'
             2440 'J01313 PSYCHOTHERAPEUTIC COMBINATIONS-NOS'
             2441 'J01314 PHENOTHIAZINE ANTIPSYCHOTICS-NOS'
             2442 'J01315 ISOSORBIDE-NOS' 2443 'J01316 IMMUNIZATION-NOS'
             2444 'J01317 PHENCYCLIDINE COMBINATIONS-NOS'
             2445 'J01318 PNEUMOCOCCAL VACCINE' 2446 'J01319 FOLATE'
             2447 'J01320 PENTOBARBITAL/PHENYTOIN'
             2448 'J01322 BARBITAL SODIUM' 2449 'J01323 GADOLINIUM'
             2450 'J01324 HEPATITIS A VACCINE INACTIVATED' 2451 'J01327 ZINC'
             2452 'J01328 4-BROMO-2,5-DIMETHOXYPHENETHYLAMINE'
             2453 'J01329 2,5-DIMETHOXY-4-IODOPHENETHYLAMINE'
             2454 'J01330 AMPHETAMINE/COCAINE'
             2455 'J01331 METHANDROSTENLONE' 2456 'J01332 MARIJUANA/OPIUM'
             2457 'J01333 ALPROSTADIL/PAPAVERINE/PHENTOLAMINE'
             2458 'J01334 CYANIDE/HEROIN/STRYCHNINE'
             2459 'J01338 HYDROXYCODEINONE'
             2460 'J01340 2,5-DIMETHOXY-4-ETHYL-PHENETHYLAMINE'
             2461 'J01341 2,5-DIMETHOXY-4-(N)-PROPYLTHIOPHENETHYLAMINE'
             2462 'J01342 ANTI-RETROVIRAL AGENTS-NOS' 2463 'J01343 AROPLATIN'
             2464 'J01344 IDRAPARINUX'
             2465 'J01345 COCAINE/LYSERGIC ACID DIETHYLAMIDE'
             2466 'J01346 SALVIA DIVINORUM' 2467 'J01348 TIPIFARNIB'
             2468 'J01350 FLUOROURACIL-LEUCOVORIN'
             2469 'J01353 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE'
             2470 'J01354 CARPROFEN'
             2471 'J01355 RIFAMPIN/ISONIAZID/PYRAZINAMIDE/ETHAMBUTOL'
             2472 'J01356 THALLIUM' 2473 'J01357 POLYMYXIN B OTIC'
             2474 'J01358 ALLANTOIN/PRAMOXINE'
             2475 'J01359 COCAINE/MARIJUANA/FORMALDEHYDE'
             2476 'J01360 COCAINE/OPIUM'
            2477 'J01361 CYCLOPHOSPHAMIDE/DOXORUBICIN/VINCRISTINE/PREDNISONE'
             2478 'J01362 DIPHTHERIA/PERTUSISIS/POLIO/HAEMOPHILUS/TETANUS'
             2479 'J01363 ETORICOXIB' 2480 'J01365 FLUPENTHIXOL'
             2481 'J01366 FUSIDIC ACID' 2482 'J01367 HEROIN/METHAMPHETAMINE'
             2483 'J01368 IODINE CONTRAST AGENT'
             2484 'J01369 MARIJUANA/LYSERGIC ACID DIETHYLAMIDE'
             2485 'J01370 METHYLENEDIOXYMETHAMPHETAMINE/PSILOCYBIN'
             2486 'J01371 NEOMYCIN-POLYMYXIN B SULFATE OTIC'
             2487 'J01372 OXALIPLATIN/FLUOROURACIL/LEUCOVORIN'
             2488 'J01373 PHOSPHORUS'
             2489 'J01375 ADRENERGIC BRONCHODILATORS-NOS'
             2490 'J01379 OMEGA-6 POLYUNSATURATED FATTY ACIDS'
             2491 'J01380 TOPICAL ANTIFUNGALS-NOS'
             2492 'J01382 DEXTROMETHORPHAN COMBINATIONS-NOS'
             2493 'J01383 CLENBUTEROL' 2494 'J01386 FENTANYL/HEROIN'
             2495 'J01387 SULFONYLUREAS-NOS'
             2496 'J01388 COCAINE/FORMALDEHYDE'
             2497 'J01389 COCAINE/METHYLENEDIOXYMETHAMPHETAMINE'
             2498 'J01390 CYPROTEREONE ACETATE-ETHINYL ESTRADIOL'
             2499 'J01391 FAT DISSOLVING AGENTS-NOS'
             2500 'J01392 HEROIN/METHYLENEDIOXYMETHAMPHETAMINE'
             2501 'J01393 PROPOLIS' 2502 'J01394 SENNA COMBINATIONS-NOS'
             2503 'J01395 FENFLURAMINE/PHENTERMINE'
             2504 'J01396 ACNE AGENTS-NOS' 2505 'J01401 CLONIXIN'
             2506 'J01404 PROGESTINS-NOS' 2507 'J01405 RABIES VACCINE-NOS'
             2508 'J01411 INFLUENZA VIRUS VACCINE, H1N1-NOS'
             2509 'J01412 ACAI BERRY' 2510 'J01413 ALUM'
             2511 'J01414 AMMONIA' 2512 'J01415 BENZYLPIPERAZINE'
             2513 'J01416 BLUE GREEN ALGAE'
  2514 'J01417 CYCLOPHOSPHAMIDE/DOXORUBICIN/RITUXIMAB/VINCRISTINE/PREDNISONE'
             2515 'J01418 HOODIA' 2516 'J01419 HYALURONIC ACID'
             2517 'J01420 PAPAVERINE/PHENTOLAMINE' 2518 'J01421 STATIN-NOS'
             2519 'J01422 TEA TREE OIL'
             2520 'J01423 TRIFLUOROMETHYLPHENYLPIPERAZINE'
             2521 'J01424 4-METHYLMETHCATHINONE' 2522 'J01426 PHENAZEPAM'
             2523 'J01427 4-BROMO-3,6-DIMETHOXYBENZOCYCLOBUTEN'
             2524 'J01428 SYNTHETIC CANNABINOID' 2525 'J01429 AFATINIB'
             2526 'J01430 AMPHETAMINE/MARIJUANA' 2527 'J01431 AXITINIB'
             2528 'J01432 BLEOMYCIN/DACARBAZINE/DOXORUBICIN/VINBLASTINE'
             2529 'J01433 CAFFEINE COMBINATIONS-NOS'
             2530 'J01434 CAPECITABINE/OXALIPLATIN'
             2531 'J01435 COLLOIDAL SILVER'
             2532 'J01436 DOCETAXEL/FLUOROURACIL/OXALIPLATIN'
             2533 'J01437 DOMPERIDONE'
             2534 'J01438 FLUOROURACIL/IRINOTECAN/LEUCOVORIN'
             2535 'J01439 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE/RITUXIMAB'
             2536 'J01440 KETAMINE/MARIJUANA'
             2537 'J01441 L-TRYPTOPHAN/MELATONIN'
             2538 'J01442 MARIJUANA/OXYCODONE' 2539 'J01443 METAMIZOLE'
             2540 'J01444 3,4-METHYLENEDIOXYPYROVALERONE'
             2541 'J01445 PANOBINOSTAT' 2542 'J01446 PROBIOTICS-NOS'
             2543 'J01447 SPERMICIDES-NOS' 2544 'J01448 TILMICOSIN'
             2545 'J01449 AMPHETAMINES-NOS'
             2546 'J01450 ILLICIT COMBINATIONS-NOS' 2547 'J01451 VITAMIN D'
             2548 'J01454 TRENBOLONE'
             2549 'J01455 H. PYLORI ERADICATION AGENTS-NOS'
             2550 'J01456 SMOKING CESSATION AGENTS-NOS'
             2551 'J01457 4-BROMO-2,5-DIMETHOXYAMPHETAMINE'
             2552 'J01458 PROTEASE INHIBITORS-NOS'
             2553 'J01459 4-METHOXYMETHCATHINONE' 2554 'J01460 ELASTIN'
             2555 'J01461 TALCUM POWDER TOPICAL'
             2556 'J01462 METHYLENEDIOXYMETHAMPHETAMINE/CAFFEINE'
             2557 'J01463 ENERGY DRINK'
             2558 'J01464 CAFFEINE/MULTIVITAMIN NTA' /
   CATID_1_5 -7 'NOT APPLICABLE:(-7)' 1 'ANTI-INFECTIVES:(1)'
             20 'ANTINEOPLASTICS:(20)' 28 'BIOLOGICALS:(28)'
             40 'CARDIOVASCULAR AGENTS:(40)'
             57 'CENTRAL NERVOUS SYSTEM AGENTS:(57)'
             81 'COAGULATION MODIFIERS:(81)'
             87 'GASTROINTESTINAL AGENTS:(87)'
             97 'HORMONES/HORMONE MODIFIERS:(97)'
             105 'MISCELLANEOUS AGENTS:(105)'
             113 'GENITOURINARY TRACT AGENTS:(113)'
             115 'NUTRITIONAL PRODUCTS:(115)' 122 'RESPIRATORY AGENTS:(122)'
             133 'TOPICAL AGENTS:(133)' 153 'PLASMA EXPANDERS:(153)'
             218 'ALTERNATIVE MEDICINES:(218)'
             242 'PSYCHOTHERAPEUTIC AGENTS:(242)'
             254 'IMMUNOLOGIC AGENTS:(254)' 331 'RADIOLOGIC AGENTS:(331)'
             358 'METABOLIC AGENTS:(358)' 365 'MEDICAL GAS:(365)'
             2006 'DRUG UNKNOWN:(2006)' 2041 'NON-PHARMACEUTICAL:(2041)' /
   CATID_2_5 -7 'NOT APPLICABLE:(-7)' 2 'AMEBICIDES:(2)'
             3 'ANTHELMINTICS:(3)' 4 'ANTIFUNGALS:(4)'
             5 'ANTIMALARIAL AGENTS:(5)' 6 'ANTITUBERCULOSIS AGENTS:(6)'
             7 'ANTIVIRAL AGENTS:(7)' 8 'CARBAPENEMS:(8)'
             9 'CEPHALOSPORINS:(9)' 10 'LEPROSTATICS:(10)'
             11 'MACROLIDE DERIVATIVES:(11)'
             12 'MISCELLANEOUS ANTIBIOTICS:(12)' 13 'PENICILLINS:(13)'
             14 'QUINOLONES:(14)' 15 'SULFONAMIDES:(15)'
             16 'TETRACYCLINES:(16)' 17 'URINARY ANTI-INFECTIVES:(17)'
             18 'AMINOGLYCOSIDES:(18)' 19 'ANTIHYPERLIPIDEMIC AGENTS:(19)'
             21 'ALKYLATING AGENTS:(21)' 22 'ANTINEOPLASTIC ANTIBIOTICS:(22)'
             23 'ANTIMETABOLITES:(23)' 24 'ANTINEOPLASTIC HORMONES:(24)'
             25 'MISCELLANEOUS ANTINEOPLASTICS:(25)'
             26 'MITOTIC INHIBITORS:(26)' 27 'RADIOPHARMACEUTICALS:(27)'
             30 'ANTITOXINS AND ANTIVENINS:(30)' 33 'IMMUNE GLOBULINS:(33)'
             34 'IN VIVO DIAGNOSTIC BIOLOGICALS:(34)'
             36 'RECOMBINANT HUMAN ERYTHROPOIETINS:(36)'
             41 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(41)'
             42 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(42)'
             43 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(43)'
             44 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(44)'
             45 'ANTIANGINAL AGENTS:(45)' 46 'ANTIARRHYTHMIC AGENTS:(46)'
             47 'BETA-ADRENERGIC BLOCKING AGENTS:(47)'
             48 'CALCIUM CHANNEL BLOCKING AGENTS:(48)' 49 'DIURETICS:(49)'
             50 'INOTROPIC AGENTS:(50)'
             51 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(51)'
             52 'PERIPHERAL VASODILATORS:(52)' 53 'VASODILATORS:(53)'
             54 'VASOPRESSORS:(54)' 55 'ANTIHYPERTENSIVE COMBINATIONS:(55)'
             56 'ANGIOTENSIN II INHIBITORS:(56)' 58 'ANALGESICS:(58)'
             64 'ANTICONVULSANTS:(64)'
             65 'ANTIEMETIC/ANTIVERTIGO AGENTS:(65)'
             66 'ANTIPARKINSON AGENTS:(66)'
             67 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(67)'
             71 'CNS STIMULANTS:(71)' 72 'GENERAL ANESTHETICS:(72)'
             73 'MUSCLE RELAXANTS:(73)'
             80 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(80)'
             82 'ANTICOAGULANTS:(82)' 83 'ANTIPLATELET AGENTS:(83)'
             84 'HEPARIN ANTAGONISTS:(84)'
             85 'MISCELLANEOUS COAGULATION MODIFIERS:(85)'
             86 'THROMBOLYTICS:(86)' 88 'ANTACIDS:(88)'
             90 'ANTIDIARRHEALS:(90)' 91 'DIGESTIVE ENZYMES:(91)'
             92 'GALLSTONE SOLUBILIZING AGENTS:(92)' 93 'GI STIMULANTS:(93)'
             94 'H2 ANTAGONISTS:(94)' 95 'LAXATIVES:(95)'
             96 'MISCELLANEOUS GI AGENTS:(96)'
             98 'ADRENAL CORTICAL STEROIDS:(98)'
             99 'ANTIDIABETIC AGENTS:(99)' 100 'MISCELLANEOUS HORMONES:(100)'
             101 'SEX HORMONES:(101)' 103 'THYROID HORMONES:(103)'
             104 'IMMUNOSUPPRESSIVE AGENTS:(104)' 106 'ANTIDOTES:(106)'
             107 'CHELATING AGENTS:(107)'
             108 'CHOLINERGIC MUSCLE STIMULANTS:(108)'
             109 'LOCAL INJECTABLE ANESTHETICS:(109)'
             110 'MISCELLANEOUS UNCATEGORIZED AGENTS:(110)'
             111 'PSORALENS:(111)' 112 'RADIOCONTRAST AGENTS:(112)'
             114 'ILLICIT (STREET) DRUGS:(114)' 116 'IRON PRODUCTS:(116)'
             117 'MINERALS AND ELECTROLYTES:(117)'
             118 'ORAL NUTRITIONAL SUPPLEMENTS:(118)' 119 'VITAMINS:(119)'
             120 'VITAMIN AND MINERAL COMBINATIONS:(120)'
             121 'INTRAVENOUS NUTRITIONAL PRODUCTS:(121)'
             123 'ANTIHISTAMINES:(123)' 124 'ANTITUSSIVES:(124)'
             125 'BRONCHODILATORS:(125)' 127 'DECONGESTANTS:(127)'
             128 'EXPECTORANTS:(128)'
             129 'MISCELLANEOUS RESPIRATORY AGENTS:(129)'
             130 'RESPIRATORY INHALANT PRODUCTS:(130)'
             131 'ANTIASTHMATIC COMBINATIONS:(131)'
             132 'UPPER RESPIRATORY COMBINATIONS:(132)'
             134 'ANORECTAL PREPARATIONS:(134)'
             135 'ANTISEPTIC AND GERMICIDES:(135)'
             136 'DERMATOLOGICAL AGENTS:(136)'
             146 'MOUTH AND THROAT PRODUCTS:(146)'
             147 'OPHTHALMIC PREPARATIONS:(147)'
             148 'OTIC PREPARATIONS:(148)'
             150 'STERILE IRRIGATING SOLUTIONS:(150)'
             151 'VAGINAL PREPARATIONS:(151)' 192 'ANTIRHEUMATICS:(192)'
             194 'ANTIGOUT AGENTS:(194)' 219 'NUTRACEUTICAL PRODUCTS:(219)'
             220 'HERBAL PRODUCTS:(220)' 240 'LINCOMYCIN DERIVATIVES:(240)'
             243 'LEUKOTRIENE MODIFIERS:(243)' 247 'NASAL PREPARATIONS:(247)'
             249 'ANTIDEPRESSANTS:(249)' 251 'ANTIPSYCHOTICS:(251)'
             253 'ANOREXIANTS:(253)' 263 'IMPOTENCE AGENTS:(263)'
             264 'URINARY ANTISPASMODICS:(264)'
             265 'URINARY PH MODIFIERS:(265)'
             266 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(266)'
             270 'ANTIPSORIATICS:(270)' 272 'PROTON PUMP INHIBITORS:(272)'
             273 'LUNG SURFACTANTS:(273)' 277 '5-AMINOSALICYLATES:(277)'
             284 'VISCOSUPPLEMENTATION AGENTS:(284)'
             288 '5-ALPHA-REDUCTASE INHIBITORS:(288)'
             289 'ANTIHYPERURICEMIC AGENTS:(289)'
             293 'GLUCOSE ELEVATING AGENTS:(293)' 295 'GROWTH HORMONES:(295)'
             303 'AGENTS FOR PULMONARY HYPERTENSION:(303)'
             312 'CHOLINERGIC AGONISTS:(312)'
             313 'CHOLINESTERASE INHIBITORS:(313)' 315 'GLYCYLCYCLINES:(315)'
             318 'INSULIN-LIKE GROWTH FACTOR:(318)'
             319 'VASOPRESSIN ANTAGONISTS:(319)'
             320 'SMOKING CESSATION AGENTS:(320)'
             324 'ANTINEOPLASTIC INTERFERONS:(324)'
             325 'SCLEROSING AGENTS:(325)' 332 'RADIOLOGIC ADJUNCTS:(332)'
             340 'ALDOSTERONE RECEPTOR ANTAGONISTS:(340)'
             342 'RENIN INHIBITORS:(342)'
             354 'H. PYLORI ERADICATION AGENTS:(354)'
             355 'FUNCTIONAL BOWEL DISORDER AGENTS:(355)'
             357 'GROWTH HORMONE RECEPTOR BLOCKERS:(357)'
             359 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(359)'
             360 'LYSOSOMAL ENZYMES:(360)'
             361 'MISCELLANEOUS METABOLIC AGENTS:(361)'
             363 'PROBIOTICS:(363)' 377 'PROLACTIN INHIBITORS:(377)'
             378 'DRUGS USED IN ALCOHOL DEPENDENCE:(378)'
             383 'ANTINEOPLASTIC DETOXIFYING AGENTS:(383)'
             384 'PLATELET-STIMULATING AGENTS:(384)'
             390 'HEMATOPOIETIC STEM CELL MOBILIZER:(390)'
             397 'MULTIKINASE INHIBITORS:(397)'
             398 'BCR-ABL TYROSINE KINASE INHIBITORS:(398)'
             399 'CD52 MONOCLONAL ANTIBODIES:(399)'
             400 'CD33 MONOCLONAL ANTIBODIES:(400)'
             401 'CD20 MONOCLONAL ANTIBODIES:(401)'
             402 'VEGF/VEGFR INHIBITORS:(402)' 403 'MTOR INHIBITORS:(403)'
             404 'EGFR INHIBITORS:(404)' 405 'HER2 INHIBITORS:(405)'
             406 'GLYCOPEPTIDE ANTIBIOTICS:(406)'
             408 'HISTONE DEACETYLASE INHIBITORS:(408)'
             409 'BONE RESORPTION INHIBITORS:(409)'
             410 'ADRENAL CORTICOSTEROID INHIBITORS:(410)'
             411 'CALCITONIN:(411)' 412 'UTEROTONIC AGENTS:(412)'
             413 'ANTIGONADOTROPIC AGENTS:(413)'
             414 'ANTIDIURETIC HORMONES:(414)'
             416 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(416)'
             417 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(417)'
             418 'PARATHYROID HORMONE AND ANALOGS:(418)'
             419 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(419)'
             422 'ANTITHYROID AGENTS:(422)'
             426 'SYNTHETIC OVULATION STIMULANTS:(426)'
             427 'TOCOLYTIC AGENTS:(427)'
             428 'PROGESTERONE RECEPTOR MODULATORS:(428)'
             431 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(431)'
             433 'CATECHOLAMINES:(433)'
             435 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(435)'
             437 'IMMUNOSTIMULANTS:(437)'
             447 'CD30 MONOCLONAL ANTIBODIES:(447)' 2042 'INHALANT:(2042)'
             2051 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(2051)' /
   CATID_3_5 -7 'NOT APPLICABLE:(-7)' 31 'BACTERIAL VACCINES:(31)'
             32 'COLONY STIMULATING FACTORS:(32)' 38 'VIRAL VACCINES:(38)'
             61 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(61)'
             68 'BARBITURATES:(68)' 69 'BENZODIAZEPINES:(69)'
             70 'MISCELLANEOUS ANXIOLYTICS, SEDATIVES AND HYPNOTICS:(70)'
             74 'NEUROMUSCULAR BLOCKING AGENTS:(74)'
             76 'MISCELLANEOUS ANTIDEPRESSANTS:(76)'
             77 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(77)'
             79 'PSYCHOTHERAPEUTIC COMBINATIONS:(79)'
             89 'ANTICHOLINERGICS/ANTISPASMODICS:(89)'
             102 'CONTRACEPTIVES:(102)' 126 'METHYLXANTHINES:(126)'
             137 'TOPICAL ANTI-INFECTIVES:(137)' 138 'TOPICAL STEROIDS:(138)'
             139 'TOPICAL ANESTHETICS:(139)'
             140 'MISCELLANEOUS TOPICAL AGENTS:(140)'
             141 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(141)'
             143 'TOPICAL ACNE AGENTS:(143)'
             144 'TOPICAL ANTIPSORIATICS:(144)' 149 'SPERMICIDES:(149)'
             154 'LOOP DIURETICS:(154)'
             155 'POTASSIUM-SPARING DIURETICS:(155)'
             156 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(156)'
             157 'CARBONIC ANHYDRASE INHIBITORS:(157)'
             158 'MISCELLANEOUS DIURETICS:(158)'
             159 'FIRST GENERATION CEPHALOSPORINS:(159)'
             160 'SECOND GENERATION CEPHALOSPORINS:(160)'
             161 'THIRD GENERATION CEPHALOSPORINS:(161)'
             162 'FOURTH GENERATION CEPHALOSPORINS:(162)'
             163 'OPHTHALMIC ANTI-INFECTIVES:(163)'
             164 'OPHTHALMIC GLAUCOMA AGENTS:(164)'
             165 'OPHTHALMIC STEROIDS:(165)'
             166 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(166)'
             167 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(167)'
             168 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(168)'
             169 'MISCELLANEOUS OPHTHALMIC AGENTS:(169)'
             170 'OTIC ANTI-INFECTIVES:(170)'
             171 'OTIC STEROIDS WITH ANTI-INFECTIVES:(171)'
             172 'MISCELLANEOUS OTIC AGENTS:(172)'
             173 'HMG-COA REDUCTASE INHIBITORS:(173)'
             174 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(174)'
             175 'PROTEASE INHIBITORS:(175)' 176 'NRTIS:(176)'
             177 'MISCELLANEOUS ANTIVIRALS:(177)'
             178 'SKELETAL MUSCLE RELAXANTS:(178)'
             179 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(179)'
             180 'ADRENERGIC BRONCHODILATORS:(180)'
             181 'BRONCHODILATOR COMBINATIONS:(181)'
             182 'ANDROGENS AND ANABOLIC STEROIDS:(182)'
             183 'ESTROGENS:(183)' 184 'GONADOTROPINS:(184)'
             185 'PROGESTINS:(185)' 186 'SEX HORMONE COMBINATIONS:(186)'
             187 'MISCELLANEOUS SEX HORMONES:(187)'
             193 'ANTIMIGRAINE AGENTS:(193)'
             195 '5HT3 RECEPTOR ANTAGONISTS:(195)'
             196 'PHENOTHIAZINE ANTIEMETICS:(196)'
             197 'ANTICHOLINERGIC ANTIEMETICS:(197)'
             198 'MISCELLANEOUS ANTIEMETICS:(198)'
             199 'HYDANTOIN ANTICONVULSANTS:(199)'
             200 'SUCCINIMIDE ANTICONVULSANTS:(200)'
             201 'BARBITURATE ANTICONVULSANTS:(201)'
             202 'OXAZOLIDINEDIONE ANTICONVULSANTS:(202)'
             203 'BENZODIAZEPINE ANTICONVULSANTS:(203)'
             204 'MISCELLANEOUS ANTICONVULSANTS:(204)'
             205 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(205)'
             206 'MISCELLANEOUS ANTIPARKINSON AGENTS:(206)'
             208 'SSRI ANTIDEPRESSANTS:(208)'
             209 'TRICYCLIC ANTIDEPRESSANTS:(209)'
             210 'PHENOTHIAZINE ANTIPSYCHOTICS:(210)'
             211 'PLATELET AGGREGATION INHIBITORS:(211)'
             212 'GLYCOPROTEIN PLATELET INHIBITORS:(212)'
             213 'SULFONYLUREAS:(213)' 214 'BIGUANIDES:(214)'
             215 'INSULIN:(215)' 216 'ALPHA-GLUCOSIDASE INHIBITORS:(216)'
             217 'BISPHOSPHONATES:(217)'
             222 'PENICILLINASE RESISTANT PENICILLINS:(222)'
             223 'ANTIPSEUDOMONAL PENICILLINS:(223)'
             224 'AMINOPENICILLINS:(224)'
             225 'BETA-LACTAMASE INHIBITORS:(225)'
             226 'NATURAL PENICILLINS:(226)' 227 'NNRTIS:(227)'
             228 'ADAMANTANE ANTIVIRALS:(228)' 229 'PURINE NUCLEOSIDES:(229)'
             230 'AMINOSALICYLATES:(230)'
             231 'NICOTINIC ACID DERIVATIVES:(231)'
             232 'RIFAMYCIN DERIVATIVES:(232)'
             233 'STREPTOMYCES DERIVATIVES:(233)'
             234 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(234)'
             235 'POLYENES:(235)' 236 'AZOLE ANTIFUNGALS:(236)'
             237 'MISCELLANEOUS ANTIFUNGALS:(237)'
             238 'ANTIMALARIAL QUINOLINES:(238)'
             239 'MISCELLANEOUS ANTIMALARIALS:(239)'
             241 'FIBRIC ACID DERIVATIVES:(241)'
             244 'NASAL LUBRICANTS AND IRRIGATIONS:(244)'
             245 'NASAL STEROIDS:(245)'
             246 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(246)'
             248 'TOPICAL EMOLLIENTS:(248)'
             250 'MONOAMINE OXIDASE INHIBITORS:(250)'
             252 'BILE ACID SEQUESTRANTS:(252)' 256 'INTERFERONS:(256)'
             261 'HEPARINS:(261)' 262 'COUMARINS AND INDANEDIONES:(262)'
             267 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(267)'
             268 'VAGINAL ANTI-INFECTIVES:(268)'
             269 'MISCELLANEOUS VAGINAL AGENTS:(269)'
             271 'THIAZOLIDINEDIONES:(271)'
             274 'CARDIOSELECTIVE BETA BLOCKERS:(274)'
             275 'NON-CARDIOSELECTIVE BETA BLOCKERS:(275)'
             276 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(276)'
             278 'COX-2 INHIBITORS:(278)'
             279 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(279)'
             280 'THIOXANTHENES:(280)' 281 'NEURAMINIDASE INHIBITORS:(281)'
             282 'MEGLITINIDES:(282)' 283 'THROMBIN INHIBITORS:(283)'
             285 'FACTOR XA INHIBITORS:(285)' 286 'MYDRIATICS:(286)'
             287 'OPHTHALMIC ANESTHETICS:(287)'
             290 'TOPICAL ANTIBIOTICS:(290)' 291 'TOPICAL ANTIVIRALS:(291)'
             292 'TOPICAL ANTIFUNGALS:(292)'
             296 'INHALED CORTICOSTEROIDS:(296)' 297 'MUCOLYTICS:(297)'
             298 'MAST CELL STABILIZERS:(298)'
             299 'ANTICHOLINERGIC BRONCHODILATORS:(299)'
             300 'CORTICOTROPIN:(300)' 301 'GLUCOCORTICOIDS:(301)'
             302 'MINERALOCORTICOIDS:(302)' 304 'MACROLIDES:(304)'
             305 'KETOLIDES:(305)'
             306 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(306)'
             307 'TETRACYCLIC ANTIDEPRESSANTS:(307)'
             308 'SSNRI ANTIDEPRESSANTS:(308)'
             309 'MISCELLANEOUS ANTIDIABETIC AGENTS:(309)'
             310 'ECHINOCANDINS:(310)'
             311 'DIBENZAZEPINE ANTICONVULSANTS:(311)'
             314 'ANTIDIABETIC COMBINATIONS:(314)'
             316 'CHOLESTEROL ABSORPTION INHIBITORS:(316)'
             317 'ANTIHYPERLIPIDEMIC COMBINATIONS:(317)'
             321 'OPHTHALMIC DIAGNOSTIC AGENTS:(321)'
             322 'OPHTHALMIC SURGICAL AGENTS:(322)'
             327 'ANTIVIRAL COMBINATIONS:(327)'
             328 'ANTIMALARIAL COMBINATIONS:(328)'
             329 'ANTITUBERCULOSIS COMBINATIONS:(329)'
             330 'ANTIVIRAL INTERFERONS:(330)'
             333 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(333)'
             334 'LYMPHATIC STAINING AGENTS:(334)'
             335 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(335)'
             336 'NON-IODINATED CONTRAST MEDIA:(336)'
             337 'ULTRASOUND CONTRAST MEDIA:(337)'
             338 'DIAGNOSTIC RADIOPHARMACEUTICALS:(338)'
             339 'THERAPEUTIC RADIOPHARMACEUTICALS:(339)'
             341 'ATYPICAL ANTIPSYCHOTICS:(341)'
             345 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(345)'
             346 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(346)'
             347 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(347)'
             348 'TRIAZINE ANTICONVULSANTS:(348)'
             349 'CARBAMATE ANTICONVULSANTS:(349)'
             350 'PYRROLIDINE ANTICONVULSANTS:(350)'
             351 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(351)'
             352 'UREA ANTICONVULSANTS:(352)'
             353 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(353)'
             356 'SEROTONINERGIC NEUROENTERIC MODULATORS:(356)'
             362 'CHLORIDE CHANNEL ACTIVATORS:(362)'
             364 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(364)'
             366 'INTEGRASE STRAND TRANSFER INHIBITOR:(366)'
             368 'NON-IONIC IODINATED CONTRAST MEDIA:(368)'
             369 'IONIC IODINATED CONTRAST MEDIA:(369)'
             370 'OTIC STEROIDS:(370)'
             371 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(371)'
             372 'AMYLIN ANALOGS:(372)' 373 'INCRETIN MIMETICS:(373)'
             374 'CARDIAC STRESSING AGENTS:(374)'
             375 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(375)'
             379 'FIFTH GENERATION CEPHALOSPORINS:(379)'
             380 'TOPICAL DEBRIDING AGENTS:(380)'
             381 'TOPICAL DEPIGMENTING AGENTS:(381)'
             382 'TOPICAL ANTIHISTAMINES:(382)'
             385 'GROUP I ANTIARRHYTHMICS:(385)'
             387 'GROUP III ANTIARRHYTHMICS:(387)'
             389 'GROUP V ANTIARRHYTHMICS:(389)' 392 'OTIC ANESTHETICS:(392)'
             393 'CERUMENOLYTICS:(393)' 394 'TOPICAL ASTRINGENTS:(394)'
             395 'TOPICAL KERATOLYTICS:(395)'
             415 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(415)'
             432 'VACCINE COMBINATIONS:(432)'
             439 'OTHER IMMUNOSTIMULANTS:(439)'
             440 'THERAPEUTIC VACCINES:(440)'
             441 'CALCINEURIN INHIBITORS:(441)'
             442 'TNF ALFA INHIBITORS:(442)'
             443 'INTERLEUKIN INHIBITORS:(443)'
             444 'SELECTIVE IMMUNOSUPPRESSANTS:(444)'
             445 'OTHER IMMUNOSUPPRESSANTS:(445)'
             448 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(448)'
             2005 'ALCOHOL IN COMBINATION:(2005)'
             2007 'MISCELLANEOUS BRONCHODILATORS:(2007)'
             2008 'MISCELLANEOUS NASAL PREPARATIONS:(2008)'
             2030 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(2030)'
             2031 'MISCELLANEOUS HALLUCINOGENS:(2031)'
             2032 'ILLICIT MAJOR SUBSTANCE OF ABUSE:(2032)'
             2033 'ILLICIT COMBINATIONS:(2033)'
             2034 'ILLICIT AND OTHER COMBINATIONS:(2034)'
             2036 'MISCELLANEOUS CEPHALOSPORINS:(2036)'
             2043 'VOLATILE AGENT:(2043)' 2044 'NITRITES:(2044)'
             2045 'CHLORO-FLUORO-HYDROCARBONS:(2045)'
             2046 'MISCELLANEOUS MUSCLE RELAXANTS:(2046)'
             2047 'NARCOTIC ANALGESICS/COMBINATIONS:(2047)'
             2048 'SALICYLATES/COMBINATIONS:(2048)'
             2049 'MISCELLANEOUS ANALGESIC/COMBINATIONS:(2049)'
             2050 'ANALGESIC COMBINATIONS NTA:(2050)'
             2052 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(2052)'
             2053 'MISCELLANEOUS MACROLIDE:(2053)'
             2054 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(2054)'
             2055 'MISCELLANEOUS RADIOCONTRAST AGENTS:(2055)'
             2056 'MISCELLANEOUS RADIOPHARMACEUTICALS:(2056)' /
   ROUTE_5   -9 'MISSING:(-9)' -8 'NOT DOCUMENTED:(-8)'
             -7 'NOT APPLICABLE:(-7)' 1 'ORAL:(1)' 2 'INJECTED:(2)'
             3 'INHALED, SNIFFED, SNORTED:(3)' 4 'SMOKED:(4)' 5 'OTHER:(5)'
             6 'TRANSDERMAL:(6)' 98 'MULTIPLE ROUTES FOR THIS DRUG:(98)' /
   TOXTEST_5 -9 'MISSING:(-9)' -7 'NOT APPLICABLE:(-7)'
             1 'CONFIRMED TEST:(1)' 2 'NOT CONFIRMED:(2)' /
   SDLED_1_5 -7 'NOT APPLICABLE:(-7)' 1 'MAJOR SUBSTANCES OF ABUSE:(1)'
             17 'OTHER SUBSTANCES:(17)' /
   SDLED_2_5 -7 'NOT APPLICABLE:(-7)' 2 'ALCOHOL:(2)'
             2.5 'NON-ALCOHOL ILLICITS:(2.5)'
             18 'PSYCHOTHERAPEUTIC AGENTS:(18)' 33 'CNS AGENTS:(33)'
             50 'RESPIRATORY AGENTS:(50)' 57 'CARDIOVASCULAR AGENTS:(57)'
             63 'ALTERNATIVE MEDICINES:(63)' 64 'ANTI-INFECTIVES:(64)'
             65 'ANTINEOPLASTICS:(65)' 66 'BIOLOGICALS:(66)'
             67 'COAGULATION MODIFIERS:(67)'
             68 'GASTROINTESTINAL AGENTS:(68)'
             69 'GENITOURINARY TRACT AGENTS:(69)' 70 'HORMONES:(70)'
             71 'IMMUNOLOGIC AGENTS:(71)' 72 'MEDICAL GAS:(72)'
             73 'METABOLIC AGENTS:(73)' 74 'MISCELLANEOUS AGENTS:(74)'
             75 'NUTRITIONAL PRODUCTS:(75)' 76 'PLASMA EXPANDERS:(76)'
             77 'RADIOLOGIC AGENTS:(77)' 78 'TOPICAL AGENTS:(78)'
             79 'DRUG UNKNOWN:(79)' /
   SDLED_3_5 -7 'NOT APPLICABLEL:(-7.00)' 3 'COCAINE:(3)' 4 'HEROIN:(4)'
             5 'CANNABINOIDS:(5)' 5.5 'STIMULANTS:(5.5)'
             8 'MDMA (ECSTASY):(8)' 8.1 'GHB:(8.1)'
             8.2 'FLUNITRAZEPAM (ROHYPNOL):(8.2)' 9 'KETAMINE:(9)'
             10 'LSD:(10)' 11 'PCP:(11)'
             12 'MISCELLANEOUS HALLUCINOGENS:(12)' 15 'INHALANTS:(15)'
             16 'COMBINATIONS NTA:(16)' 19 'ANTIDEPRESSANTS:(19)'
             24 'ANTIPSYCHOTICS:(24)' 34 'ANALGESICS:(34)'
             43 'ANOREXIANTS:(43)' 44 'ANTICONVULSANTS:(44)'
             45 'ANTIEMETIC/ANTIVERTIGO AGENTS:(45)'
             46 'ANTIPARKINSON AGENTS:(46)'
             46.3 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.3)'
             46.5 'CNS STIMULANTS:(46.5)'
             46.7 'DRUGS USED IN ALCOHOL DEPENDENCE:(46.7)'
             47 'GENERAL ANESTHETICS:(47)' 48 'MUSCLE RELAXANTS:(48)'
             49 'MISCELLANEOUS CNS AGENTS:(49)' 51 'ANTIHISTAMINES:(51)'
             52 'BRONCHODILATORS:(52)' 53 'DECONGESTANTS:(53)'
             54 'EXPECTORANTS:(54)'
             54.5 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(54.5)'
             55 'UPPER RESPIRATORY COMBINATIONS:(55)'
             56 'RESPIRATORY AGENTS NTA:(56)'
             58 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(58)'
             59 'BETA-ADRENERGIC BLOCKING AGENTS:(59)'
             60 'CALCIUM CHANNEL BLOCKING AGENTS:(60)' 61 'DIURETICS:(61)'
             61.3 'RENIN INHIBITORS:(61.3)'
             61.5 'VASOPRESSIN ANTAGONISTS:(61.5)'
             62 'CARDIOVASCULAR AGENTS NTA:(62)'
             63.1 'HERBAL PRODUCTS:(63.1)'
             63.2 'NUTRACEUTICAL PRODUCTS:(63.2)' 63.3 'PROBIOTICS:(63.3)'
             64.01 'AMEBICIDES:(64.01)' 64.02 'AMINOGLYCOSIDES:(64.02)'
             64.03 'ANTHELMINTICS:(64.03)' 64.04 'ANTIFUNGALS:(64.04)'
             64.05 'ANTIMALARIAL AGENTS:(64.05)'
             64.06 'ANTITUBERCULOSIS AGENTS:(64.06)'
             64.07 'ANTIVIRAL AGENTS:(64.07)' 64.08 'CARBAPENEMS:(64.08)'
             64.09 'CEPHALOSPORINS:(64.09)'
             64.1 'GLYCOPEPTIDE ANTIBIOTICS:(64.1)'
             64.11 'GLYCYLCYCLINES:(64.11)' 64.12 'LEPROSTATICS:(64.12)'
             64.13 'LINCOMYCIN DERIVATIVES:(64.13)'
             64.14 'MACROLIDE DERIVATIVES:(64.14)'
             64.15 'PENICILLINS:(64.15)' 64.16 'QUINOLONES:(64.16)'
             64.17 'SULFONAMIDES:(64.17)' 64.18 'TETRACYCLINES:(64.18)'
             64.19 'URINARY ANTI-INFECTIVES:(64.19)'
             64.99 'MISCELLANEOUS ANTIBIOTICS:(64.99)'
             65.01 'ALKYLATING AGENTS:(65.01)'
             65.02 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(65.02)'
             65.03 'ANTIMETABOLITES:(65.03)'
             65.04 'ANTINEOPLASTIC ANTIBIOTICS:(65.04)'
             65.05 'ANTINEOPLASTIC DETOXIFYING AGENTS:(65.05)'
             65.06 'ANTINEOPLASTIC HORMONES:(65.06)'
             65.07 'ANTINEOPLASTIC INTERFERONS:(65.07)'
             65.08 'BCR-ABL TYROSINE KINASE INHIBITORS:(65.08)'
             65.09 'CD20 MONOCLONAL ANTIBODIES:(65.09)'
             65.11 'CD33 MONOCLONAL ANTIBODIES:(65.11)'
             65.12 'CD52 MONOCLONAL ANTIBODIES:(65.12)'
             65.13 'EGFR INHIBITORS:(65.13)' 65.14 'HER2 INHIBITORS:(65.14)'
             65.15 'HISTONE DEACETYLASE INHIBITORS:(65.15)'
             65.16 'MITOTIC INHIBITORS:(65.16)'
             65.17 'MTOR INHIBITORS:(65.17)'
             65.18 'MULTIKINASE INHIBITORS:(65.18)'
             65.2 'VEGF/VEGFR INHIBITORS:(65.2)'
             65.99 'MISCELLANEOUS ANTINEOPLASTICS:(65.99)'
             66.01 'ANTITOXINS AND ANTIVENINS:(66.01)'
             66.04 'IN VIVO DIAGNOSTIC BIOLOGICALS:(66.04)'
             66.05 'RECOMBINANT HUMAN ERYTHROPOIETINS:(66.05)'
             67.01 'ANTICOAGULANTS:(67.01)'
             67.02 'ANTIPLATELET AGENTS:(67.02)'
             67.03 'HEPARIN ANTAGONISTS:(67.03)'
             67.04 'PLATELET-STIMULATING AGENTS:(67.04)'
             67.05 'THROMBOLYTICS:(67.05)'
             67.06 'MISCELLANEOUS COAGULATION MODIFIERS:(67.06)'
             68.01 '5-AMINOSALICYLATES:(68.01)' 68.02 'ANTACIDS:(68.02)'
             68.04 'ANTIDIARRHEALS:(68.04)' 68.05 'DIGESTIVE ENZYMES:(68.05)'
             68.06 'FUNCTIONAL BOWEL DISORDER AGENTS:(68.06)'
             68.07 'GALLSTONE SOLUBILIZING AGENTS:(68.07)'
             68.08 'GI STIMULANTS:(68.08)'
             68.09 'H. PYLORI ERADICATION AGENTS:(68.09)'
             68.1 'H2 ANTAGONISTS:(68.1)' 68.11 'LAXATIVES:(68.11)'
             68.12 'PROTON PUMP INHIBITORS:(68.12)'
             68.13 'MISCELLANEOUS GI AGENTS:(68.13)'
             69.01 'IMPOTENCE AGENTS:(69.01)'
             69.02 'TOCOLYTIC AGENTS:(69.02)'
             69.03 'URINARY ANTISPASMODICS:(69.03)'
             69.04 'URINARY PH MODIFIERS:(69.04)'
             69.05 'UTEROTONIC AGENTS:(69.05)'
             69.99 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(69.99)'
             70.01 '5-ALPHA-REDUCTASE INHIBITORS:(70.01)'
             70.02 'ADRENAL CORTICAL STEROIDS:(70.02)'
             70.05 'ANTIDIURETIC HORMONES:(70.05)'
             70.06 'ANTIGONADOTROPIC AGENTS:(70.06)'
             70.07 'ANTITHYROID AGENTS:(70.07)' 70.09 'CALCITONIN:(70.09)'
             70.11 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(70.11)'
             70.12 'GROWTH HORMONE RECEPTOR BLOCKERS:(70.12)'
             70.13 'GROWTH HORMONES:(70.13)'
             70.15 'INSULIN-LIKE GROWTH FACTOR:(70.15)'
             70.16 'PARATHYROID HORMONE AND ANALOGS:(70.16)'
             70.17 'PROGESTERONE RECEPTOR MODULATORS:(70.17)'
             70.18 'PROLACTIN INHIBITORS:(70.18)'
             70.19 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(70.19)'
             70.2 'SEX HORMONES:(70.2)'
             70.21 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(70.21)'
             70.22 'SYNTHETIC OVULATION STIMULANTS:(70.22)'
             70.23 'THYROID HORMONES:(70.23)'
             70.99 'MISCELLANEOUS HORMONES:(70.99)'
             71.01 'IMMUNE GLOBULINS:(71.01)'
             71.02 'IMMUNOSTIMULANTS:(71.02)'
             71.03 'IMMUNOSUPPRESSIVE AGENTS:(71.03)'
             71.99 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(71.99)'
             73.01 'ANTIDIABETIC AGENTS:(73.01)'
             73.02 'ANTIGOUT AGENTS:(73.02)'
             73.03 'ANTIHYPERLIPIDEMIC AGENTS:(73.03)'
             73.04 'ANTIHYPERURICEMIC AGENTS:(73.04)'
             73.05 'BONE RESORPTION INHIBITORS:(73.05)'
             73.06 'GLUCOSE ELEVATING AGENTS:(73.06)'
             73.07 'LYSOSOMAL ENZYMES:(73.07)'
             73.08 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(73.08)'
             73.99 'MISCELLANEOUS METABOLIC AGENTS:(73.99)'
             74.01 'ANTIDOTES:(74.01)' 74.04 'ANTIPSORIATICS:(74.04)'
             74.05 'ANTIRHEUMATICS:(74.05)' 74.06 'CHELATING AGENTS:(74.06)'
             74.07 'CHOLINERGIC MUSCLE STIMULANTS:(74.07)'
             74.11 'LOCAL INJECTABLE ANESTHETICS:(74.11)'
             74.13 'PSORALENS:(74.13)'
             74.17 'SMOKING CESSATION AGENTS:(74.17)'
             74.18 'VISCOSUPPLEMENTATION AGENTS:(74.18)'
             74.19 'MISCELLANEOUS UNCATEGORIZED AGENTS:(74.19)'
             75.01 'INTRAVENOUS NUTRITIONAL PRODUCTS:(75.01)'
             75.02 'IRON PRODUCTS:(75.02)'
             75.03 'MINERALS AND ELECTROLYTES:(75.03)'
             75.04 'ORAL NUTRITIONAL SUPPLEMENTS:(75.04)'
             75.05 'VITAMIN AND MINERAL COMBINATIONS:(75.05)'
             75.06 'VITAMINS:(75.06)' 77.01 'RADIOCONTRAST AGENTS:(77.01)'
             77.02 'RADIOLOGIC ADJUNCTS:(77.02)'
             77.03 'RADIOPHARMACEUTICALS:(77.03)'
             78.01 'ANORECTAL PREPARATIONS:(78.01)'
             78.02 'ANTISEPTIC AND GERMICIDES:(78.02)'
             78.03 'DERMATOLOGICAL AGENTS:(78.03)'
             78.04 'MOUTH AND THROAT PRODUCTS:(78.04)'
             78.05 'NASAL PREPARATIONS:(78.05)'
             78.06 'OPHTHALMIC PREPARATIONS:(78.06)'
             78.07 'OTIC PREPARATIONS:(78.07)'
             78.08 'STERILE IRRIGATING SOLUTIONS:(78.08)'
             78.09 'VAGINAL PREPARATIONS:(78.09)' /
   SDLED_4_5 -7 'NOT APPLICABLE:(-7.00)' 5.01 'MARIJUANA:(5.01)'
             5.02 'SYNTHETIC CANNABINOIDS:(5.02)' 6 'AMPHETAMINES:(6)'
             7 'METHAMPHETAMINE:(7)' 7.1 'OTHER STIMULANTS:(7.1)'
             20 'MAO INHIBITORS:(20)'
             20.4 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(20.4)'
             20.7 'SSNRI ANTIDEPRESSANTS:(20.7)'
             21 'SSRI ANTIDEPRESSANTS:(21)'
             21.5 'TETRACYCLIC ANTIDEPRESSANTS:(21.5)'
             22 'TRICYCLIC ANTIDEPRESSANTS:(22)'
             23 'MISCELLANEOUS ANTIDEPRESSANTS:(23)'
             25 'ATYPICAL ANTIPSYCHOTICS:(25)'
             26 'PHENOTHIAZINE ANTIPSYCHOTICS:(26)'
             26.5 'PSYCHOTHERAPEUTIC COMBINATIONS:(26.5)'
             26.7 'THIOXANTHENES:(26.7)'
             27 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(27)'
             35 'ANTIMIGRAINE AGENTS:(35)' 36 'COX-2 INHIBITORS:(36)'
             36.5 'OPIATES/OPIOIDS:(36.5)'
             39 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(39)'
             40.5 'SALICYLATES/COMBINATIONS:(40.5)'
             41.5 'MISCELLANEOUS ANALGESICS/COMBINATIONS:(41.5)'
             42.5 'ANALGESIC COMBINATIONS NTA:(42.5)'
             43.01 'PHENYLPROPANOLAMINE:(43.01)'
             43.02 'ANOREXIANTS-NOS:(43.02)' 43.09 'ANOREXIANTS NTA:(43.09)'
             44.01 'BARBITURATE ANTICONVULSANTS:(44.01)'
             44.02 'BENZODIAZEPINE ANTICONVULSANTS:(44.02)'
             44.03 'CARBAMATE ANTICONVULSANTS:(44.03)'
             44.04 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(44.04)'
             44.05 'DIBENZAZEPINE ANTICONVULSANTS:(44.05)'
             44.06 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(44.06)'
             44.07 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(44.07)'
             44.08 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(44.08)'
             44.09 'HYDANTOIN ANTICONVULSANTS:(44.09)'
             44.11 'OXAZOLIDINEDIONE ANTICONVULSANTS:(44.11)'
             44.12 'PYRROLIDINE ANTICONVULSANTS:(44.12)'
             44.13 'SUCCINIMIDE ANTICONVULSANTS:(44.13)'
             44.14 'TRIAZINE ANTICONVULSANTS:(44.14)'
             44.99 'MISCELLANEOUS ANTICONVULSANTS:(44.99)'
             45.01 '5HT3 RECEPTOR ANTAGONISTS:(45.01)'
             45.02 'ANTICHOLINERGIC ANTIEMETICS:(45.02)'
             45.03 'PHENOTHIAZINE ANTIEMETICS:(45.03)'
             45.04 'MISCELLANEOUS ANTIEMETICS:(45.04)'
             46.01 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(46.01)'
             46.02 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(46.02)'
             46.03 'MISCELLANEOUS ANTIPARKINSON AGENTS:(46.03)'
             46.31 'BARBITURATES:(46.31)' 46.32 'BENZODIAZEPINES:(46.32)'
             46.33 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.33)'
             46.501 'AMPHETAMINE-DEXTROAMPHETAMINE:(46.501)'
             46.502 'BENZPHETAMINE:(46.502)' 46.503 'CAFFEINE:(46.503)'
             46.504 'DEXTROAMPHETAMINE:(46.504)'
             46.505 'METHYLPHENIDATE:(46.505)'
             46.509 'CNS STIMULANTS NTA:(46.509)'
             48.01 'NEUROMUSCULAR BLOCKING AGENTS:(48.01)'
             48.02 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(48.02)'
             48.03 'SKELETAL MUSCLE RELAXANTS:(48.03)'
             48.04 'MISCELLANEOUS MUSCLE RELAXANTS:(48.04)'
             49.01 'CHOLINERGIC AGONISTS:(49.01)'
             49.02 'CHOLINESTERASE INHIBITORS:(49.02)'
             49.03 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(49.03)'
             52.01 'ADRENERGIC BRONCHODILATORS:(52.01)'
             52.02 'ANTICHOLINERGIC BRONCHODILATORS:(52.02)'
             52.03 'BRONCHODILATOR COMBINATIONS:(52.03)'
             52.04 'METHYLXANTHINES:(52.04)'
             52.05 'MISCELLANEOUS BRONCHODILATORS:(52.05)'
             56.01 'ANTIASTHMATIC COMBINATIONS:(56.01)'
             56.02 'ANTITUSSIVES:(56.02)'
             56.03 'LEUKOTRIENE MODIFIERS:(56.03)'
             56.05 'RESPIRATORY INHALANT PRODUCTS:(56.05)'
             56.06 'MISCELLANEOUS RESPIRATORY AGENTS:(56.06)'
             58.01 'CLONIDINE:(58.01)'
             58.09 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING NTA:(58.09)'
             59.01 'CARDIOSELECTIVE BETA BLOCKERS:(59.01)'
             59.02 'NON-CARDIOSELECTIVE BETA BLOCKERS:(59.02)'
             59.03 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(59.03)'
             61.01 'CARBONIC ANHYDRASE INHIBITORS:(61.01)'
             61.02 'LOOP DIURETICS:(61.02)'
             61.03 'POTASSIUM-SPARING DIURETICS:(61.03)'
             61.04 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(61.04)'
             61.05 'MISCELLANEOUS DIURETICS:(61.05)'
             62.01 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(62.01)'
             62.02 'AGENTS FOR PULMONARY HYPERTENSION:(62.02)'
             62.03 'ALDOSTERONE RECEPTOR ANTAGONISTS:(62.03)'
             62.04 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(62.04)'
             62.05 'ANGIOTENSIN II INHIBITORS:(62.05)'
             62.06 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(62.06)'
             62.07 'ANTIANGINAL AGENTS:(62.07)'
             62.08 'ANTIARRHYTHMIC AGENTS:(62.08)'
             62.09 'ANTIHYPERTENSIVE COMBINATIONS:(62.09)'
             62.1 'CATECHOLAMINES:(62.1)' 62.11 'INOTROPIC AGENTS:(62.11)'
             62.12 'PERIPHERAL VASODILATORS:(62.12)'
             62.13 'SCLEROSING AGENTS:(62.13)' 62.14 'VASODILATORS:(62.14)'
             62.15 'VASOPRESSORS:(62.15)'
             62.99 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(62.99)'
             64.041 'AZOLE ANTIFUNGALS:(64.041)'
             64.042 'ECHINOCANDINS:(64.042)' 64.043 'POLYENES:(64.043)'
             64.044 'MISCELLANEOUS ANTIFUNGALS:(64.044)'
             64.051 'ANTIMALARIAL COMBINATIONS:(64.051)'
             64.052 'ANTIMALARIAL QUINOLINES:(64.052)'
             64.053 'MISCELLANEOUS ANTIMALARIALS:(64.053)'
             64.061 'AMINOSALICYLATES:(64.061)'
             64.062 'ANTITUBERCULOSIS COMBINATIONS:(64.062)'
             64.063 'NICOTINIC ACID DERIVATIVES:(64.063)'
             64.064 'RIFAMYCIN DERIVATIVES:(64.064)'
             64.065 'STREPTOMYCES DERIVATIVES:(64.065)'
             64.066 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(64.066)'
             64.0701 'ADAMANTANE ANTIVIRALS:(64.0701)'
             64.0702 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(64.0702)'
             64.0703 'ANTIVIRAL COMBINATIONS:(64.0703)'
             64.0704 'ANTIVIRAL INTERFERONS:(64.0704)'
             64.0705 'INTEGRASE STRAND TRANSFER INHIBITOR:(64.0705)'
             64.0706 'NEURAMINIDASE INHIBITORS:(64.0706)'
             64.0707 'NNRTIS:(64.0707)' 64.0708 'NRTIS:(64.0708)'
             64.0709 'PROTEASE INHIBITORS:(64.0709)'
             64.071 'PURINE NUCLEOSIDES:(64.071)'
             64.0711 'MISCELLANEOUS ANTIVIRALS:(64.0711)'
             64.091 'FIRST GENERATION CEPHALOSPORINS:(64.091)'
             64.092 'SECOND GENERATION CEPHALOSPORINS:(64.092)'
             64.093 'THIRD GENERATION CEPHALOSPORINS:(64.093)'
             64.094 'FOURTH GENERATION CEPHALOSPORINS:(64.094)'
             64.095 'FIFTH GENERATION CEPHALOSPORINS:(64.095)'
             64.096 'MISCELLANEOUS CEPHALOSPORINS:(64.096)'
             64.141 'KETOLIDES:(64.141)' 64.142 'MACROLIDES:(64.142)'
             64.143 'MISCELLANEOUS MACROLIDES:(64.143)'
             64.151 'AMINOPENICILLINS:(64.151)'
             64.152 'ANTIPSEUDOMONAL PENICILLINS:(64.152)'
             64.153 'BETA-LACTAMASE INHIBITORS:(64.153)'
             64.154 'NATURAL PENICILLINS:(64.154)'
             64.155 'PENICILLINASE RESISTANT PENICILLINS:(64.155)'
             67.011 'COUMARINS AND INDANEDIONES:(67.011)'
             67.012 'FACTOR XA INHIBITORS:(67.012)'
             67.013 'HEPARINS:(67.013)' 67.014 'THROMBIN INHIBITORS:(67.014)'
             67.021 'GLYCOPROTEIN PLATELET INHIBITORS:(67.021)'
             67.022 'PLATELET AGGREGATION INHIBITORS:(67.022)'
             68.061 'ANTICHOLINERGICS/ANTISPASMODICS:(68.061)'
             68.062 'CHLORIDE CHANNEL ACTIVATORS:(68.062)'
             68.063 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(68.063)'
             68.064 'SEROTONINERGIC NEUROENTERIC MODULATORS:(68.064)'
             70.021 'CORTICOTROPIN:(70.021)'
             70.022 'GLUCOCORTICOIDS:(70.022)'
             70.023 'MINERALOCORTICOIDS:(70.023)'
             70.029 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(70.029)'
             70.202 'ANDROGENS AND ANABOLIC STEROIDS:(70.202)'
             70.203 'CONTRACEPTIVES:(70.203)' 70.204 'ESTROGENS:(70.204)'
             70.205 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(70.205)'
             70.206 'GONADOTROPINS:(70.206)' 70.207 'PROGESTINS:(70.207)'
             70.208 'SEX HORMONE COMBINATIONS:(70.208)'
             70.209 'MISCELLANEOUS SEX HORMONES:(70.209)'
             71.021 'BACTERIAL VACCINES:(71.021)'
             71.022 'COLONY STIMULATING FACTORS:(71.022)'
             71.023 'INTERFERONS:(71.023)'
             71.025 'THERAPEUTIC VACCINES:(71.025)'
             71.026 'VACCINE COMBINATIONS:(71.026)'
             71.027 'VIRAL VACCINES:(71.027)'
             71.029 'OTHER IMMUNOSTIMULANTS:(71.029)'
             71.031 'CALCINEURIN INHIBITORS:(71.031)'
             71.032 'INTERLEUKIN INHIBITORS:(71.032)'
             71.033 'SELECTIVE IMMUNOSUPPRESSANTS:(71.033)'
             71.034 'TNF ALFA INHIBITORS:(71.034)'
             71.039 'OTHER IMMUNOSUPPRESSANTS:(71.039)'
             73.0101 'ALPHA-GLUCOSIDASE INHIBITORS:(73.0101)'
             73.0102 'AMYLIN ANALOGS:(73.0102)'
             73.0103 'ANTIDIABETIC COMBINATIONS:(73.0103)'
             73.0104 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(73.0104)'
             73.0105 'INCRETIN MIMETICS:(73.0105)'
             73.0106 'INSULIN:(73.0106)' 73.0107 'MEGLITINIDES:(73.0107)'
             73.0108 'BIGUANIDES:(73.0108)' 73.0109 'SULFONYLUREAS:(73.0109)'
             73.011 'THIAZOLIDINEDIONES:(73.011)'
             73.019 'MISCELLANEOUS ANTIDIABETIC AGENTS:(73.019)'
             73.031 'ANTIHYPERLIPIDEMIC COMBINATIONS:(73.031)'
             73.032 'BILE ACID SEQUESTRANTS:(73.032)'
             73.033 'CHOLESTEROL ABSORPTION INHIBITORS:(73.033)'
             73.034 'FIBRIC ACID DERIVATIVES:(73.034)'
             73.035 'HMG-COA REDUCTASE INHIBITORS:(73.035)'
             73.036 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(73.036)'
             73.051 'BISPHOSPHONATES:(73.051)'
             73.059 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(73.059)'
             77.011 'IONIC IODINATED CONTRAST MEDIA:(77.011)'
             77.012 'LYMPHATIC STAINING AGENTS:(77.012)'
             77.013 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(77.013)'
             77.014 'NON-IODINATED CONTRAST MEDIA:(77.014)'
             77.015 'NON-IONIC IODINATED CONTRAST MEDIA:(77.015)'
             77.016 'ULTRASOUND CONTRAST MEDIA:(77.016)'
             77.017 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(77.017)'
             77.019 'MISCELLANEOUS RADIOCONTRAST AGENTS:(77.019)'
             77.021 'CARDIAC STRESSING AGENTS:(77.021)'
             77.031 'DIAGNOSTIC RADIOPHARMACEUTICALS:(77.031)'
             77.032 'THERAPEUTIC RADIOPHARMACEUTICALS:(77.032)'
             77.033 'MISCELLANEOUS RADIOPHARMACEUTICALS:(77.033)'
             78.0301 'TOPICAL ACNE AGENTS:(78.0301)'
             78.0302 'TOPICAL ANESTHETICS:(78.0302)'
             78.0303 'TOPICAL ANTIBIOTICS:(78.0303)'
             78.0304 'TOPICAL ANTIFUNGALS:(78.0304)'
             78.0305 'TOPICAL ANTIHISTAMINES:(78.0305)'
             78.0306 'TOPICAL ANTI-INFECTIVES:(78.0306)'
             78.0307 'TOPICAL ANTIPSORIATICS:(78.0307)'
             78.0308 'TOPICAL ANTIVIRALS:(78.0308)'
             78.0309 'TOPICAL ASTRINGENTS:(78.0309)'
             78.031 'TOPICAL DEBRIDING AGENTS:(78.031)'
             78.0311 'TOPICAL DEPIGMENTING AGENTS:(78.0311)'
             78.0312 'TOPICAL EMOLLIENTS:(78.0312)'
             78.0313 'TOPICAL KERATOLYTICS:(78.0313)'
             78.0314 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(78.0314)'
             78.0315 'TOPICAL STEROIDS:(78.0315)'
             78.0316 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(78.0316)'
             78.0399 'MISCELLANEOUS TOPICAL AGENTS:(78.0399)'
             78.051 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(78.051)'
             78.053 'NASAL LUBRICANTS AND IRRIGATIONS:(78.053)'
             78.054 'NASAL STEROIDS:(78.054)'
             78.055 'MISCELLANEOUS NASAL PREPARATIONS:(78.055)'
             78.0602 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(78.0602)'
             78.061 'MYDRIATICS:(78.061)'
             78.062 'OPHTHALMIC ANESTHETICS:(78.062)'
             78.063 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(78.063)'
             78.064 'OPHTHALMIC ANTI-INFECTIVES:(78.064)'
             78.065 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(78.065)'
             78.066 'OPHTHALMIC DIAGNOSTIC AGENTS:(78.066)'
             78.067 'OPHTHALMIC GLAUCOMA AGENTS:(78.067)'
             78.068 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(78.068)'
             78.069 'OPHTHALMIC STEROIDS:(78.069)'
             78.0691 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(78.0691)'
             78.0692 'OPHTHALMIC SURGICAL AGENTS:(78.0692)'
             78.0693 'MISCELLANEOUS OPHTHALMIC AGENTS:(78.0693)'
             78.071 'CERUMENOLYTICS:(78.071)'
             78.072 'OTIC ANESTHETICS:(78.072)'
             78.073 'OTIC ANTI-INFECTIVES:(78.073)'
             78.074 'OTIC STEROIDS:(78.074)'
             78.075 'OTIC STEROIDS WITH ANTI-INFECTIVES:(78.075)'
             78.076 'MISCELLANEOUS OTIC AGENTS:(78.076)'
             78.091 'SPERMICIDES:(78.091)'
             78.092 'VAGINAL ANTI-INFECTIVES:(78.092)'
             78.093 'MISCELLANEOUS VAGINAL AGENTS:(78.093)' /
   SDLED_5_5 -7 'NOT APPLICABLE' 20.41 'NEFAZODONE:(20.41)'
             20.42 'TRAZODONE:(20.42)' 20.71 'DESVENLAFAXINE:(20.71)'
             20.72 'DULOXETINE:(20.72)' 20.73 'VENLAFAXINE:(20.73)'
             20.79 'SSNRI ANTIDEPRESSANTS NTA:(20.79)'
             21.01 'CITALOPRAM:(21.01)' 21.02 'FLUOXETINE:(21.02)'
             21.03 'FLUVOXAMINE:(21.03)' 21.04 'PAROXETINE:(21.04)'
             21.05 'SERTRALINE:(21.05)'
             21.09 'SSRI ANTIDEPRESSANTS NTA:(21.09)'
             21.51 'MAPROTILINE:(21.51)' 21.52 'MIRTAZAPINE:(21.52)'
             22.01 'AMITRIPTYLINE:(22.01)' 22.02 'DESIPRAMINE:(22.02)'
             22.03 'DOXEPIN:(22.03)' 22.04 'IMIPRAMINE:(22.04)'
             22.05 'NORTRIPTYLINE:(22.05)'
             22.06 'TRICYCLIC ANTIDEPRESSANTS-NOS:(22.06)'
             22.09 'TRICYCLIC ANTIDEPRESSANTS NTA:(22.09)'
             23.01 'BUPROPION:(23.01)' 23.06 'ANTIDEPRESSANTS-NOS:(23.06)'
             23.09 'MISCELLANEOUS ANTIDEPRESSANTS NTA:(23.09)'
             25.01 'CLOZAPINE:(25.01)' 25.02 'OLANZAPINE:(25.02)'
             25.03 'QUETIAPINE:(25.03)' 25.04 'RISPERIDONE:(25.04)'
             25.09 'ATYPICAL ANTIPSYCHOTICS NTA:(25.09)'
             26.01 'CHLORPROMAZINE:(26.01)' 26.02 'FLUPHENAZINE:(26.02)'
             26.03 'PERPHENAZINE:(26.03)' 26.04 'PROCHLORPERAZINE:(26.04)'
             26.05 'THIORIDAZINE:(26.05)' 26.06 'TRIFLUPROMAZINE:(26.06)'
             26.09 'PHENOTHIAZINE ANTIPSYCHOTICS NTA:(26.09)'
             27.01 'HALOPERIDOL:(27.01)' 27.02 'LITHIUM:(27.02)'
             27.09 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS NTA:(27.09)'
             36.75 'OPIATES/OPIOIDS, UNSPECIFIED:(36.75)'
             37.5 'NARCOTIC ANALGESICS:(37.5)'
             39.01 'IBUPROFEN/COMBINATIONS:(39.01)'
             39.02 'NAPROXEN/COMBINATIONS:(39.02)'
             39.03 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS NTA:(39.03)'
             40.501 'ASPIRIN/COMBINATIONS:(40.501)'
             40.502 'SALICYLATES-NOS:(40.502)'
             40.503 'SALICYLATES/COMBINATIONS NTA:(40.503)'
             41.501 'ACETAMINOPHEN/COMBINATIONS:(41.501)'
             41.502 'TRAMADOL/COMBINATIONS:(41.502)'
             41.505 'ANALGESICS-NOS:(41.505)'
             41.506 'MISCELLANEOUS ANALGESIC/COMBINATIONS NTA:(41.506)'
             44.041 'TOPIRAMATE:(44.041)'
           44.049 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS NTA:(44.049)'
             44.051 'CARBAMAZEPINE:(44.051)' 44.052 'OXCARBAZEPINE:(44.052)'
             44.053 'RUFINAMIDE:(44.053)' 44.061 'DIVALPROEX SODIUM:(44.061)'
             44.062 'VALPROIC ACID:(44.062)' 44.071 'GABAPENTIN:(44.071)'
             44.079 'GAMMA-AMINOBUTYRIC ACID ANALOGS NTA:(44.079)'
             44.091 'PHENYTOIN:(44.091)'
             44.099 'HYDANTOIN ANTICONVULSANTS NTA:(44.099)'
             46.011 'BENZTROPINE:(46.011)'
             46.019 'ANTICHOLINERGIC ANTIPARKINSON AGENTS NTA:(46.019)'
             46.3101 'PHENOBARBITAL:(46.3101)'
             46.3102 'BARBITURATES-NOS:(46.3102)'
             46.3109 'BARBITURATES NTA:(46.3109)'
             46.3201 'ALPRAZOLAM:(46.3201)'
             46.3202 'CHLORDIAZEPOXIDE:(46.3202)'
             46.3203 'CLONAZEPAM:(46.3203)' 46.3204 'CLORAZEPATE:(46.3204)'
             46.3205 'DIAZEPAM:(46.3205)' 46.3206 'FLURAZEPAM:(46.3206)'
             46.3207 'LORAZEPAM:(46.3207)' 46.3208 'OXAZEPAM:(46.3208)'
             46.3209 'TEMAZEPAM:(46.3209)' 46.321 'TRIAZOLAM:(46.321)'
             46.3211 'BENZODIAZEPINES-NOS:(46.3211)'
             46.3219 'BENZODIAZEPINES NTA:(46.3219)'
             46.3301 'BUSPIRONE:(46.3301)'
             46.3302 'CHLORAL HYDRATE:(46.3302)'
             46.3303 'DIPHENHYDRAMINE:(46.3303)'
             46.3304 'DOXYLAMINE:(46.3304)' 46.3305 'HYDROXYZINE:(46.3305)'
             46.3306 'ZOLPIDEM:(46.3306)'
             46.3307 'ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS:(46.3307)'
          46.3309 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS NTA:(46.3309)'
             46.5091 'CAFFEINE/MULTIVITAMIN:(46.5091)'
             46.5092 'OTHER CNS STIMULANTS NTA:(46.5092)'
             48.031 'CARISOPRODOL:(48.031)' 48.032 'CHLORZOXAZONE:(48.032)'
             48.033 'CYCLOBENZAPRINE:(48.033)' 48.034 'METAXALONE:(48.034)'
             48.035 'METHOCARBAMOL:(48.035)' 48.036 'TIZANIDINE:(48.036)'
             48.039 'SKELETAL MUSCLE RELAXANTS NTA:(48.039)'
             56.052 'INHALED CORTICOSTEROIDS:(56.052)'
             56.053 'MAST CELL STABILIZERS:(56.053)'
             56.054 'MUCOLYTICS:(56.054)'
             56.059 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(56.059)'
             59.011 'ATENOLOL:(59.011)'
             59.019 'CARDIOSELECTIVE BETA BLOCKERS NTA:(59.019)'
             59.021 'PROPRANOLOL:(59.021)'
             59.029 'NON-CARDIOSELECTIVE BETA BLOCKERS NTA:(59.029)'
             62.081 'GROUP I ANTIARRHYTHMICS:(62.081)'
             62.083 'GROUP III ANTIARRHYTHMICS:(62.083)'
             62.085 'GROUP V ANTIARRHYTHMICS:(62.085)'
             62.089 'ANTIARRHYTHMIC AGENTS NTA:(62.089)'
             62.151 'EPHEDRINE:(62.151)' 62.159 'VASOPRESSORS NTA:(62.159)' /
   SDLED_6_5 -7 'NOT APPLICABLE:(-7)'
             37.5005 'BUPRENORPHINE/COMBINATIONS:(37.5005)'
             37.501 'CODEINE/COMBINATIONS:(37.501)'
             37.502 'DIHYDROCODEINE/COMBINATIONS:(37.502)'
             37.503 'FENTANYL/COMBINATIONS:(37.503)'
             37.504 'HYDROCODONE/COMBINATIONS:(37.504)'
             37.5045 'HYDROMORPHONE/COMBINATIONS:(37.5045)'
             37.505 'MEPERIDINE/COMBINATIONS:(37.505)'
             37.506 'METHADONE:(37.506)'
             37.507 'MORPHINE/COMBINATIONS:(37.507)'
             37.508 'OPIUM/COMBINATIONS:(37.508)'
             37.509 'OXYCODONE/COMBINATIONS:(37.509)'
             37.51 'PENTAZOCINE/COMBINATIONS:(37.51)'
             37.511 'PHENACETIN/COMBINATIONS:(37.511)'
             37.512 'PROPOXYPHENE/COMBINATIONS:(37.512)'
             37.514 'ALL OTHER NARCOTIC ANALGESICS/COMBINATIONS NTA:(37.514)'
             41.503 'TRAMADOL:(41.503)'
             41.504 'ACETAMINOPHEN-TRAMADOL:(41.504)' /
   DRUGID_6  -7 'NOT APPLICABLE' 1 'D00001 ACYCLOVIR' 2 'D00002 AMIODARONE'
             3 'D00003 AMPICILLIN' 4 'D00004 ATENOLOL' 5 'D00006 CAPTOPRIL'
             6 'D00007 CEFAZOLIN' 7 'D00008 CEFOTAXIME'
             8 'D00009 CEFTAZIDIME' 9 'D00010 CEFTIZOXIME'
             10 'D00011 CIPROFLOXACIN' 11 'D00012 CODEINE'
             12 'D00013 ENALAPRIL' 13 'D00014 GENTAMICIN'
             14 'D00015 IBUPROFEN' 15 'D00016 LABETALOL'
             16 'D00017 MEPERIDINE' 17 'D00018 NADOLOL' 18 'D00019 NAPROXEN'
             19 'D00020 QUINIDINE' 20 'D00021 RANITIDINE'
             21 'D00022 WARFARIN' 22 'D00023 ALLOPURINOL'
             23 'D00024 AZATHIOPRINE' 24 'D00025 CHLORAMPHENICOL'
             25 'D00026 FENOPROFEN' 26 'D00027 HALOPERIDOL'
             27 'D00028 KETOPROFEN' 28 'D00029 NAFCILLIN'
             29 'D00030 PENTAMIDINE' 30 'D00031 PROBENECID'
             31 'D00032 PROPRANOLOL' 32 'D00033 SULINDAC'
             33 'D00034 ZIDOVUDINE' 34 'D00035 CHLOROQUINE'
             35 'D00036 CYCLOPHOSPHAMIDE' 36 'D00037 DOXYCYCLINE'
             37 'D00038 FLUCYTOSINE' 38 'D00039 INDOMETHACIN'
             39 'D00040 OXAZEPAM' 40 'D00041 TETRACYCLINE'
             41 'D00042 CHLORPROPAMIDE' 42 'D00043 CLINDAMYCIN'
             43 'D00044 CLONIDINE' 44 'D00045 DILTIAZEM'
             45 'D00046 ERYTHROMYCIN' 46 'D00047 RIFAMPIN'
             47 'D00048 VERAPAMIL' 48 'D00049 ACETAMINOPHEN'
             49 'D00050 METHADONE' 50 'D00051 NIFEDIPINE'
             51 'D00052 CEFTRIAXONE' 52 'D00053 CEPHRADINE'
             53 'D00054 TOLMETIN' 54 'D00055 CEFOTETAN'
             55 'D00056 CEFUROXIME' 56 'D00057 PIPERACILLIN'
             57 'D00058 CARBAMAZEPINE' 58 'D00059 LIDOCAINE'
             59 'D00060 METHOTREXATE' 60 'D00061 LITHIUM'
             61 'D00062 CEFAMANDOLE' 62 'D00064 CHLORPROMAZINE'
             63 'D00065 FOSCARNET' 64 'D00066 GANCICLOVIR'
             65 'D00067 AZTREONAM' 66 'D00068 ETHAMBUTOL'
             67 'D00069 TOBRAMYCIN' 68 'D00070 FUROSEMIDE'
             69 'D00071 FLUCONAZOLE' 70 'D00072 CEFIXIME'
             71 'D00073 CEFPROZIL' 72 'D00074 CEFOPERAZONE'
             73 'D00075 PROCAINAMIDE' 74 'D00077 AMPHOTERICIN B'
             75 'D00078 DIDANOSINE' 76 'D00079 CYCLOSPORINE'
             77 'D00080 CEFADROXIL' 78 'D00081 CEFACLOR'
             79 'D00082 IMIPENEM-CILASTATIN' 80 'D00083 VALPROIC ACID'
             81 'D00084 PREDNISOLONE' 82 'D00085 RIBAVIRIN'
             83 'D00086 AMANTADINE' 84 'D00087 AMIKACIN'
             85 'D00088 AMOXICILLIN' 86 'D00089 AMOXICILLIN-CLAVULANATE'
             87 'D00090 AMPICILLIN-SULBACTAM' 88 'D00091 AZITHROMYCIN'
             89 'D00092 CARBENICILLIN' 90 'D00093 CEFMETAZOLE'
             91 'D00094 CEFOXITIN' 92 'D00095 CEFPODOXIME'
             93 'D00096 CEPHALEXIN' 94 'D00097 CLARITHROMYCIN'
             95 'D00098 DAPSONE' 96 'D00099 ENOXACIN'
             97 'D00100 GRISEOFULVIN' 98 'D00101 ISONIAZID'
             99 'D00102 ITRACONAZOLE' 100 'D00103 KETOCONAZOLE'
             101 'D00104 LOMEFLOXACIN' 102 'D00105 LORACARBEF'
             103 'D00106 METHENAMINE' 104 'D00107 METHICILLIN'
             105 'D00108 METRONIDAZOLE' 106 'D00109 MEZLOCILLIN'
             107 'D00110 MINOCYCLINE' 108 'D00112 NITROFURANTOIN'
             109 'D00113 NORFLOXACIN' 110 'D00114 OFLOXACIN'
             111 'D00115 OXACILLIN' 112 'D00116 PENICILLIN'
             113 'D00117 PYRAZINAMIDE' 114 'D00118 SULFADIAZINE'
             115 'D00119 SULFAMETHOXAZOLE' 116 'D00120 SULFISOXAZOLE'
             117 'D00121 TICARCILLIN' 118 'D00122 TICARCILLIN-CLAVULANATE'
             119 'D00123 TRIMETHOPRIM'
             120 'D00124 SULFAMETHOXAZOLE-TRIMETHOPRIM'
             121 'D00125 VANCOMYCIN' 122 'D00128 ACEBUTOLOL'
             123 'D00129 DIAZOXIDE' 124 'D00132 HYDRALAZINE'
             125 'D00133 METHYLDOPA' 126 'D00134 METOPROLOL'
             127 'D00135 MINOXIDIL' 128 'D00137 PINDOLOL'
             129 'D00138 PRAZOSIN' 130 'D00139 TIMOLOL'
             131 'D00140 CIMETIDINE' 132 'D00141 FAMOTIDINE'
             133 'D00142 THEOPHYLLINE' 134 'D00143 PHENYTOIN'
             135 'D00144 NORTRIPTYLINE' 136 'D00145 DESIPRAMINE'
             137 'D00146 AMITRIPTYLINE' 138 'D00147 CHLORAL HYDRATE'
             139 'D00148 DIAZEPAM' 140 'D00149 LORAZEPAM'
             141 'D00150 COLCHICINE' 142 'D00152 CLOXACILLIN'
             143 'D00153 DICLOXACILLIN' 144 'D00154 MEBENDAZOLE'
             145 'D00155 MICONAZOLE' 146 'D00157 NALIDIXIC ACID'
             147 'D00158 QUINACRINE' 148 'D00159 STREPTOMYCIN'
             149 'D00161 ACETAZOLAMIDE' 150 'D00164 ADENOSINE'
             151 'D00167 ALFENTANIL' 152 'D00168 ALPRAZOLAM'
             153 'D00169 AMILORIDE' 154 'D00170 ASPIRIN'
             155 'D00171 AMOBARBITAL' 156 'D00172 INAMRINONE'
             157 'D00173 ATRACURIUM' 158 'D00174 ATROPINE'
             159 'D00175 BENZTROPINE' 160 'D00176 BETAXOLOL'
             161 'D00177 BLEOMYCIN' 162 'D00178 BROMOCRIPTINE'
             163 'D00179 BUMETANIDE' 164 'D00180 BUPIVACAINE'
             165 'D00181 BUPROPION' 166 'D00182 BUSPIRONE'
             167 'D00183 BUSULFAN' 168 'D00184 CARBIDOPA'
             169 'D00185 CARBOPLATIN' 170 'D00186 CEPHALOTHIN'
             171 'D00187 CEPHAPIRIN' 172 'D00188 CHLORAMBUCIL'
             173 'D00189 CHLORDIAZEPOXIDE' 174 'D00190 CHLOROTHIAZIDE'
             175 'D00191 CHLORPHENIRAMINE' 176 'D00192 CHLORTHALIDONE'
             177 'D00193 CHOLESTYRAMINE' 178 'D00195 CISPLATIN'
             179 'D00197 CLONAZEPAM' 180 'D00198 CLORAZEPATE'
             181 'D00199 CLOZAPINE' 182 'D00200 CROMOLYN'
             183 'D00201 CYTARABINE' 184 'D00202 DACARBAZINE'
             185 'D00203 DACTINOMYCIN' 186 'D00204 DANAZOL'
             187 'D00205 DAUNORUBICIN' 188 'D00206 DEXAMETHASONE'
             189 'D00207 DEXTROMETHORPHAN' 190 'D00208 DIFLUNISAL'
             191 'D00209 DIGITOXIN' 192 'D00210 DIGOXIN'
             193 'D00211 DIHYDROERGOTAMINE' 194 'D00212 DIPHENHYDRAMINE'
             195 'D00213 DIPYRIDAMOLE' 196 'D00214 DISOPYRAMIDE'
             197 'D00215 DOBUTAMINE' 198 'D00216 DOPAMINE'
             199 'D00217 DOXEPIN' 200 'D00218 DOXORUBICIN'
             201 'D00219 DROPERIDOL' 202 'D00220 EDROPHONIUM'
             203 'D00222 ERGOTAMINE' 204 'D00223 EPOETIN ALFA'
             205 'D00224 ESMOLOL' 206 'D00226 ETHCHLORVYNOL'
             207 'D00227 ETHOSUXIMIDE' 208 'D00229 ETHINYL ESTRADIOL'
             209 'D00230 ETOPOSIDE' 210 'D00231 FELODIPINE'
             211 'D00233 FENTANYL' 212 'D00234 FLECAINIDE'
             213 'D00235 FLUOROURACIL' 214 'D00236 FLUOXETINE'
             215 'D00237 FLUPHENAZINE' 216 'D00238 FLURAZEPAM'
             217 'D00239 FLURBIPROFEN' 218 'D00240 FLUTAMIDE'
             219 'D00241 FOLIC ACID' 220 'D00242 FOSINOPRIL'
             221 'D00243 FURAZOLIDONE' 222 'D00245 GEMFIBROZIL'
             223 'D00246 GLIPIZIDE' 224 'D00248 GLYBURIDE'
             225 'D00250 GOLD SODIUM THIOMALATE' 226 'D00252 HEPARIN'
             227 'D00253 HYDROCHLOROTHIAZIDE' 228 'D00254 HYDROCORTISONE'
             229 'D00255 HYDROMORPHONE' 230 'D00256 IDARUBICIN'
             231 'D00257 IFOSFAMIDE' 232 'D00259 IMIPRAMINE'
             233 'D00260 INDAPAMIDE' 234 'D00262 INSULIN'
             235 'D00265 IPRATROPIUM' 236 'D00267 ISOFLURANE'
             237 'D00268 ISOSORBIDE DINITRATE'
             238 'D00269 ISOSORBIDE MONONITRATE' 239 'D00270 ISRADIPINE'
             240 'D00271 KANAMYCIN' 241 'D00272 KETAMINE'
             242 'D00273 KETOROLAC' 243 'D00275 LEUCOVORIN'
             244 'D00276 LEVAMISOLE' 245 'D00277 LEVODOPA'
             246 'D00278 LEVOTHYROXINE' 247 'D00279 LINCOMYCIN'
             248 'D00280 LOVASTATIN' 249 'D00282 MANNITOL'
             250 'D00283 MECLOFENAMATE' 251 'D00284 MEDROXYPROGESTERONE'
             252 'D00285 MEFENAMIC ACID' 253 'D00286 MEFLOQUINE'
             254 'D00287 MELPHALAN' 255 'D00288 MEPROBAMATE'
             256 'D00289 MERCAPTOPURINE' 257 'D00290 METHIMAZOLE'
             258 'D00292 METHSUXIMIDE' 259 'D00293 METHYLPREDNISOLONE'
             260 'D00295 METHYLTESTOSTERONE'
             261 'D00297 METIPRANOLOL OPHTHALMIC' 262 'D00298 METOCLOPRAMIDE'
             263 'D00299 METOLAZONE' 264 'D00300 MEXILETINE'
             265 'D00301 MIDAZOLAM' 266 'D00302 MILRINONE'
             267 'D00303 MISOPROSTOL' 268 'D00305 MITOMYCIN'
             269 'D00306 MITOXANTRONE' 270 'D00307 MORICIZINE'
             271 'D00308 MORPHINE' 272 'D00310 NABUMETONE'
             273 'D00311 NALOXONE' 274 'D00312 NEOMYCIN'
             275 'D00313 NEOSTIGMINE' 276 'D00314 NIACIN'
             277 'D00315 NICARDIPINE' 278 'D00316 NICOTINE'
             279 'D00318 NIMODIPINE' 280 'D00321 NITROGLYCERIN'
             281 'D00322 NIZATIDINE' 282 'D00323 NOREPINEPHRINE'
             283 'D00325 OMEPRAZOLE' 284 'D00328 OXYBUTYNIN'
             285 'D00329 OXYCODONE' 286 'D00330 PANCURONIUM'
             287 'D00331 PARAAMINOBENZOIC ACID' 288 'D00332 PENBUTOLOL'
             289 'D00333 PENICILLAMINE' 290 'D00334 PENTAZOCINE'
             291 'D00335 PENTOBARBITAL' 292 'D00336 PENTOXIFYLLINE'
             293 'D00337 PHENAZOPYRIDINE' 294 'D00340 PHENOBARBITAL'
             295 'D00341 PHENYLBUTAZONE' 296 'D00342 PHYSOSTIGMINE'
             297 'D00343 PIROXICAM' 298 'D00344 POLYMYXIN B SULFATE'
             299 'D00345 POTASSIUM CHLORIDE'
             300 'D00346 POVIDONE IODINE TOPICAL' 301 'D00348 PRAVASTATIN'
             302 'D00349 PRAZIQUANTEL' 303 'D00350 PREDNISONE'
             304 'D00351 PRIMAQUINE' 305 'D00352 PRIMIDONE'
             306 'D00353 PROBUCOL' 307 'D00354 PROCARBAZINE'
             308 'D00355 PROCHLORPERAZINE' 309 'D00356 PROMAZINE'
             310 'D00358 PROPAFENONE' 311 'D00359 PROPANTHELINE'
             312 'D00360 PROPOXYPHENE' 313 'D00361 PROPYLTHIOURACIL'
             314 'D00362 PROTAMINE' 315 'D00363 PYRIDOSTIGMINE'
             316 'D00364 PYRIMETHAMINE' 317 'D00365 QUINAPRIL'
             318 'D00366 QUININE' 319 'D00367 RESERPINE'
             320 'D00368 SECOBARBITAL' 321 'D00370 OCTREOTIDE'
             322 'D00371 SOTALOL' 323 'D00373 SPIRONOLACTONE'
             324 'D00374 STREPTOKINASE' 325 'D00375 STREPTOZOCIN'
             326 'D00376 SUCCINYLCHOLINE' 327 'D00377 SUCRALFATE'
             328 'D00378 SUFENTANIL' 329 'D00379 SULFASALAZINE'
             330 'D00381 TAMOXIFEN' 331 'D00384 TEMAZEPAM'
             332 'D00386 TERAZOSIN' 333 'D00387 TERFENADINE'
             334 'D00388 THIOPENTAL' 335 'D00389 THIORIDAZINE'
             336 'D00391 THIOTHIXENE' 337 'D00393 TOLAZAMIDE'
             338 'D00394 TOLBUTAMIDE' 339 'D00395 TRAZODONE'
             340 'D00396 TRIAMTERENE' 341 'D00397 TRIAZOLAM'
             342 'D00398 VASOPRESSIN' 343 'D00399 VECURONIUM'
             344 'D00400 VINBLASTINE' 345 'D00401 VINCRISTINE'
             346 'D00402 VITAMIN A' 347 'D00405 VITAMIN E'
             348 'D00409 RIBOFLAVIN' 349 'D00412 PYRIDOXINE'
             350 'D00413 CYANOCOBALAMIN' 351 'D00417 BIOFLAVONOIDS'
             352 'D00425 CALCIUM CARBONATE' 353 'D00426 ASCORBIC ACID'
             354 'D00427 POTASSIUM PHOSPHATE-SODIUM PHOSPHATE'
             355 'D00428 FLUORIDE' 356 'D00438 SODIUM CHLORIDE'
             357 'D00439 CITRIC ACID-POTASSIUM CITRATE'
             358 'D00440 SODIUM BICARBONATE' 359 'D00468 MAGNESIUM SULFATE'
             360 'D00471 SODIUM ACETATE' 361 'D00472 TROMETHAMINE'
             362 'D00475 SODIUM PHOSPHATE' 363 'D00476 AMMONIUM CHLORIDE'
             364 'D00481 AMMONIUM MOLYBDATE TETRAHYDRATE'
             365 'D00484 SELENIUM' 366 'D00485 IODINE TOPICAL'
             367 'D00487 GLUTAMIC ACID' 368 'D00488 LYSINE'
             369 'D00491 LEVOCARNITINE' 370 'D00496 INOSITOL'
             371 'D00497 OMEGA-3 POLYUNSATURATED FATTY ACIDS'
             372 'D00512 FILGRASTIM' 373 'D00513 SARGRAMOSTIM'
             374 'D00514 TICLOPIDINE' 375 'D00519 ANISINDIONE'
             376 'D00521 ALTEPLASE' 377 'D00523 UROKINASE'
             378 'D00524 ANTITHROMBIN III'
             379 'D00525 ANTIHEMOPHILIC FACTOR (OBSOLETE)'
             380 'D00526 ANTI-INHIBITOR COAGULANT COMPLEX'
             381 'D00527 FACTOR IX COMPLEX (OBSOLETE)'
             382 'D00528 AMINOCAPROIC ACID' 383 'D00529 TRANEXAMIC ACID'
             384 'D00534 ESTRONE' 385 'D00537 ESTRADIOL'
             386 'D00541 CONJUGATED ESTROGENS'
             387 'D00542 ESTERIFIED ESTROGENS' 388 'D00543 ESTROPIPATE'
             389 'D00546 DIETHYLSTILBESTROL' 390 'D00550 PROGESTERONE'
             391 'D00554 HYDROXYPROGESTERONE' 392 'D00555 NORETHINDRONE'
             393 'D00557 LEVONORGESTREL' 394 'D00558 TESTOSTERONE'
             395 'D00562 FLUOXYMESTERONE' 396 'D00563 FINASTERIDE'
             397 'D00565 STANOZOLOL' 398 'D00566 OXANDROLONE'
             399 'D00568 NANDROLONE' 400 'D00569 CLOMIPHENE'
             401 'D00570 UROFOLLITROPIN' 402 'D00571 MENOTROPINS'
             403 'D00572 CHORIONIC GONADOTROPIN (HCG)' 404 'D00574 NAFARELIN'
             405 'D00575 HISTRELIN' 406 'D00576 SOMATREM'
             407 'D00577 SOMATROPIN' 408 'D00578 ARGININE'
             409 'D00583 DESMOPRESSIN' 410 'D00584 OXYTOCIN'
             411 'D00586 ERGONOVINE' 412 'D00587 METHYLERGONOVINE'
             413 'D00589 DINOPROSTONE TOPICAL' 414 'D00592 METYRAPONE'
             415 'D00593 GLUCAGON' 416 'D00595 GLUCOSE'
             417 'D00598 CALCITONIN' 418 'D00599 ETIDRONATE'
             419 'D00601 PAMIDRONATE' 420 'D00602 GALLIUM NITRATE'
             421 'D00603 RITODRINE' 422 'D00604 CORTICOTROPIN'
             423 'D00607 COSYNTROPIN' 424 'D00608 FLUDROCORTISONE'
             425 'D00609 CORTISONE' 426 'D00620 TRIAMCINOLONE'
             427 'D00626 DEXAMETHASONE TOPICAL' 428 'D00628 BETAMETHASONE'
             429 'D00640 METHAZOLAMIDE' 430 'D00641 BENDROFLUMETHIAZIDE'
             431 'D00643 METHYCLOTHIAZIDE' 432 'D00644 BENZTHIAZIDE'
             433 'D00645 HYDROFLUMETHIAZIDE' 434 'D00646 TRICHLORMETHIAZIDE'
             435 'D00647 POLYTHIAZIDE' 436 'D00649 ETHACRYNIC ACID'
             437 'D00651 UREA TOPICAL' 438 'D00652 GLYCERIN'
             439 'D00653 ISOSORBIDE' 440 'D00655 THYROID DESICCATED'
             441 'D00658 LIOTHYRONINE' 442 'D00659 LIOTRIX'
             443 'D00666 AMYL NITRITE' 444 'D00683 LIDOCAINE TOPICAL'
             445 'D00688 BEPRIDIL' 446 'D00689 AMLODIPINE'
             447 'D00693 ISOXSUPRINE' 448 'D00695 PAPAVERINE'
             449 'D00696 ETHAVERINE' 450 'D00697 ISOPROTERENOL'
             451 'D00699 EPINEPHRINE' 452 'D00700 EPHEDRINE'
             453 'D00703 METHOXAMINE' 454 'D00704 PHENYLEPHRINE'
             455 'D00708 CARTEOLOL' 456 'D00709 BISOPROLOL'
             457 'D00717 GUANFACINE' 458 'D00726 DOXAZOSIN'
             459 'D00728 RAMIPRIL' 460 'D00730 BENAZEPRIL'
             461 'D00732 LISINOPRIL' 462 'D00733 PHENTOLAMINE'
             463 'D00734 PHENOXYBENZAMINE' 464 'D00735 METYROSINE'
             465 'D00739 MECAMYLAMINE'
             466 'D00743 SODIUM POLYSTYRENE SULFONATE'
             467 'D00744 COLESTIPOL' 468 'D00746 SIMVASTATIN'
             469 'D00747 DEXTROTHYROXINE SODIUM' 470 'D00749 ALBUTEROL'
             471 'D00750 METAPROTERENOL' 472 'D00752 TERBUTALINE'
             473 'D00755 PIRBUTEROL' 474 'D00758 AMINOPHYLLINE'
             475 'D00759 DYPHYLLINE' 476 'D00760 BECLOMETHASONE'
             477 'D00761 FLUNISOLIDE' 478 'D00762 ACETYLCYSTEINE'
             479 'D00765 CROMOLYN OPHTHALMIC'
             480 'D00767 PHENYLPROPANOLAMINE' 481 'D00769 PSEUDOEPHEDRINE'
             482 'D00771 NAPHAZOLINE OPHTHALMIC'
             483 'D00772 OXYMETAZOLINE NASAL'
             484 'D00773 TETRAHYDROZOLINE OPHTHALMIC'
             485 'D00774 XYLOMETAZOLINE NASAL'
             486 'D00775 ALPHA 1-PROTEINASE INHIBITOR'
             487 'D00780 CLEMASTINE' 488 'D00782 PYRILAMINE'
             489 'D00784 DEXCHLORPHENIRAMINE' 490 'D00785 BROMPHENIRAMINE'
             491 'D00786 TRIPROLIDINE' 492 'D00787 PROMETHAZINE'
             493 'D00788 TRIMEPRAZINE' 494 'D00789 METHDILAZINE'
             495 'D00790 CYPROHEPTADINE' 496 'D00791 AZATADINE'
             497 'D00793 PHENINDAMINE' 498 'D00796 BENZONATATE'
             499 'D00797 GUAIFENESIN' 500 'D00800 POTASSIUM IODIDE'
             501 'D00801 CAFFEINE' 502 'D00802 DOXAPRAM'
             503 'D00803 AMPHETAMINE' 504 'D00804 DEXTROAMPHETAMINE'
             505 'D00805 METHAMPHETAMINE' 506 'D00806 PHENTERMINE'
             507 'D00807 BENZPHETAMINE' 508 'D00809 PHENDIMETRAZINE'
             509 'D00810 DIETHYLPROPION' 510 'D00811 MAZINDOL'
             511 'D00812 FENFLURAMINE' 512 'D00813 BENZOCAINE TOPICAL'
             513 'D00814 METHOTRIMEPRAZINE' 514 'D00817 HYDROXYCHLOROQUINE'
             515 'D00824 OPIUM' 516 'D00825 LEVORPHANOL'
             517 'D00833 OXYMORPHONE' 518 'D00838 BUTORPHANOL'
             519 'D00839 NALBUPHINE' 520 'D00840 BUPRENORPHINE'
             521 'D00842 SALSALATE' 522 'D00846 MAGNESIUM SALICYLATE'
             523 'D00848 DICLOFENAC' 524 'D00851 ETODOLAC'
             525 'D00853 OXAPROZIN' 526 'D00855 PERPHENAZINE'
             527 'D00857 THIETHYLPERAZINE' 528 'D00858 CYCLIZINE'
             529 'D00859 MECLIZINE' 530 'D00861 DIMENHYDRINATE'
             531 'D00862 TRIMETHOBENZAMIDE' 532 'D00866 DRONABINOL'
             533 'D00867 ONDANSETRON' 534 'D00873 TRIMIPRAMINE'
             535 'D00874 AMOXAPINE' 536 'D00875 PROTRIPTYLINE'
             537 'D00876 CLOMIPRAMINE' 538 'D00877 MAPROTILINE'
             539 'D00880 SERTRALINE' 540 'D00882 ISOCARBOXAZID'
             541 'D00883 PHENELZINE' 542 'D00884 TRANYLCYPROMINE'
             543 'D00889 MESORIDAZINE' 544 'D00890 TRIFLUOPERAZINE'
             545 'D00896 MOLINDONE' 546 'D00897 LOXAPINE'
             547 'D00898 PIMOZIDE' 548 'D00900 METHYLPHENIDATE'
             549 'D00901 PEMOLINE' 550 'D00902 ERGOLOID MESYLATES'
             551 'D00907 HYDROXYZINE' 552 'D00909 CHLORMEZANONE'
             553 'D00910 ZOLPIDEM' 554 'D00911 PARALDEHYDE'
             555 'D00912 ACETYLCARBROMAL' 556 'D00915 ESTAZOLAM'
             557 'D00917 QUAZEPAM' 558 'D00919 MEPHOBARBITAL'
             559 'D00923 BUTABARBITAL' 560 'D00929 METHOHEXITAL'
             561 'D00931 ETOMIDATE' 562 'D00933 PROPOFOL'
             563 'D00934 NITROUS OXIDE' 564 'D00942 ETHOTOIN'
             565 'D00943 PHENSUXIMIDE' 566 'D00944 PARAMETHADIONE'
             567 'D00960 CARISOPRODOL' 568 'D00962 CHLORZOXAZONE'
             569 'D00963 CYCLOBENZAPRINE' 570 'D00964 METAXALONE'
             571 'D00965 METHOCARBAMOL' 572 'D00966 ORPHENADRINE'
             573 'D00967 BACLOFEN' 574 'D00968 DANTROLENE'
             575 'D00969 PROCYCLIDINE' 576 'D00970 TRIHEXYPHENIDYL'
             577 'D00972 BIPERIDEN' 578 'D00976 SELEGILINE'
             579 'D00977 PERGOLIDE' 580 'D00978 ALUMINUM HYDROXIDE'
             581 'D00980 DIHYDROXYALUMINUM SODIUM CARBONATE'
             582 'D00982 MAGNESIUM HYDROXIDE' 583 'D00984 MAGALDRATE'
             584 'D00985 HYOSCYAMINE' 585 'D00986 SCOPOLAMINE'
             586 'D00988 BELLADONNA' 587 'D00989 METHSCOPOLAMINE'
             588 'D00991 CLIDINIUM' 589 'D00992 GLYCOPYRROLATE'
             590 'D00999 DICYCLOMINE' 591 'D01002 PANCRELIPASE'
             592 'D01003 PANCREATIN' 593 'D01005 URSODIOL'
             594 'D01008 MAGNESIUM CITRATE' 595 'D01009 SODIUM BIPHOSPHATE'
             596 'D01010 CASCARA SAGRADA' 597 'D01012 PHENOLPHTHALEIN'
             598 'D01013 SENNA' 599 'D01014 CASTOR OIL'
             600 'D01015 BISACODYL' 601 'D01017 POLYCARBOPHIL'
             602 'D01018 PSYLLIUM' 603 'D01019 MINERAL OIL'
             604 'D01021 DOCUSATE'
             605 'D01023 POLYETHYLENE GLYCOL 3350 WITH ELECTROLYTES'
             606 'D01024 LACTULOSE' 607 'D01025 LOPERAMIDE'
             608 'D01026 BISMUTH SUBSALICYLATE' 609 'D01027 SIMETHICONE'
             610 'D01028 CHARCOAL' 611 'D01030 DEHYDROCHOLIC ACID'
             612 'D01031 MESALAMINE' 613 'D01032 OLSALAZINE'
             614 'D01068 DEMECLOCYCLINE' 615 'D01070 OXYTETRACYCLINE'
             616 'D01090 SULFAMETHIZOLE' 617 'D01097 RIFABUTIN'
             618 'D01100 ETHIONAMIDE' 619 'D01101 CYCLOSERINE'
             620 'D01104 PAROMOMYCIN' 621 'D01105 IODOQUINOL'
             622 'D01112 COLISTIN SULFATE OTIC' 623 'D01113 COLISTIMETHATE'
             624 'D01115 BACITRACIN' 625 'D01120 ATOVAQUONE'
             626 'D01121 CLOFAZIMINE' 627 'D01123 PYRANTEL'
             628 'D01124 PIPERAZINE' 629 'D01128 METHYLENE BLUE'
             630 'D01129 CINOXACIN' 631 'D01133 IMMUNE GLOBULIN INTRAVENOUS'
             632 'D01135 IMMUNE GLOBULIN INTRAMUSCULAR'
             633 'D01136 HEPATITIS B IMMUNE GLOBULIN'
             634 'D01138 VARICELLA ZOSTER IMMUNE GLOBULIN'
             635 'D01139 RHO (D) IMMUNE GLOBULIN'
             636 'D01141 LYMPHOCYTE IMMUNE GLOBULIN, ANTI-THY (OBS)'
             637 'D01142 DIPHTHERIA ANTITOXIN'
             638 'D01144 ANTIVENIN (CROTALIDAE) POLYVALENT'
             639 'D01146 ANTIVENIN (BLACK WIDOW SPIDER)'
             640 'D01147 RABIES VACCINE (OBSOLETE)'
             641 'D01148 RABIES IMMUNE GLOBULIN, HUMAN' 642 'D01150 BCG'
             643 'D01152 STAPHAGE LYSATE (SPL)'
             644 'D01153 MENINGOCOCCAL POLYSACCHARIDE VACCINE'
             645 'D01156 TYPHOID VACCINE, INACTIVATED'
             646 'D01158 HAEMOPHILUS B CONJUGATE VACCINE (OBSOLETE)'
             647 'D01159 MEASLES VIRUS VACCINE'
             648 'D01160 RUBELLA VIRUS VACCINE'
             649 'D01161 MUMPS VIRUS VACCINE'
             650 'D01162 POLIOVIRUS VACCINE, LIVE, TRIVALENT'
             651 'D01163 POLIOVIRUS VACCINE, INACTIVATED'
             652 'D01164 INFLUENZA VIRUS VACCINE, INACTIVATED'
             653 'D01165 YELLOW FEVER VACCINE'
             654 'D01166 HEPATITIS B VACCINE (OBSOLETE)'
             655 'D01168 TETANUS TOXOID'
             656 'D01171 TUBERCULIN PURIFIED PROTEIN DERIVATIVE'
             657 'D01184 DIPIVEFRIN OPHTHALMIC'
             658 'D01187 LEVOBUNOLOL OPHTHALMIC'
             659 'D01188 ACETYLCHOLINE OPHTHALMIC'
             660 'D01191 PILOCARPINE OPHTHALMIC'
             661 'D01195 ECHOTHIOPHATE IODIDE OPHTHALMIC'
             662 'D01199 HOMATROPINE OPHTHALMIC'
             663 'D01200 TROPICAMIDE OPHTHALMIC'
             664 'D01201 CYCLOPENTOLATE OPHTHALMIC'
             665 'D01204 SUPROFEN OPHTHALMIC'
             666 'D01208 SULFACETAMIDE SODIUM OPHTHALMIC'
             667 'D01210 YELLOW MERCURIC OXIDE OPHTHALMIC'
             668 'D01215 TRIFLURIDINE OPHTHALMIC' 669 'D01217 TETRACAINE'
             670 'D01218 PROPARACAINE OPHTHALMIC'
             671 'D01219 FLUORESCEIN OPHTHALMIC'
             672 'D01222 SODIUM HYALURONATE OPHTHALMIC'
             673 'D01225 BORIC ACID TOPICAL'
             674 'D01226 HYDROXYPROPYL METHYLCELLULOSE OPHTHALMIC'
             675 'D01227 BOTULINUM TOXIN TYPE A (OBSOLETE)'
             676 'D01231 CHLORHEXIDINE TOPICAL'
             677 'D01232 CARBAMIDE PEROXIDE TOPICAL' 678 'D01233 NYSTATIN'
             679 'D01234 BUTOCONAZOLE TOPICAL'
             680 'D01235 TIOCONAZOLE TOPICAL' 681 'D01236 CLOTRIMAZOLE'
             682 'D01238 TERCONAZOLE TOPICAL'
             683 'D01239 GENTIAN VIOLET TOPICAL'
             684 'D01240 SULFANILAMIDE TOPICAL'
             685 'D01241 CLINDAMYCIN TOPICAL'
             686 'D01242 NONOXYNOL 9 TOPICAL' 687 'D01243 OCTOXYNOL TOPICAL'
             688 'D01244 TRETINOIN TOPICAL' 689 'D01245 ISOTRETINOIN'
             690 'D01246 BENZOYL PEROXIDE TOPICAL'
             691 'D01254 ANTHRALIN TOPICAL'
             692 'D01257 NITROFURAZONE TOPICAL' 693 'D01258 MAFENIDE TOPICAL'
             694 'D01259 SILVER SULFADIAZINE TOPICAL'
             695 'D01263 PYRITHIONE ZINC TOPICAL'
             696 'D01265 SULFACETAMIDE SODIUM TOPICAL'
             697 'D01266 CHLOROXINE TOPICAL' 698 'D01267 MUPIROCIN TOPICAL'
             699 'D01271 ECONAZOLE TOPICAL' 700 'D01272 CICLOPIROX TOPICAL'
             701 'D01273 TRIACETIN TOPICAL' 702 'D01274 TOLNAFTATE TOPICAL'
             703 'D01275 SULCONAZOLE TOPICAL' 704 'D01277 NAFTIFINE TOPICAL'
             705 'D01278 LINDANE TOPICAL' 706 'D01279 PERMETHRIN TOPICAL'
             707 'D01280 CROTAMITON TOPICAL'
             708 'D01282 ALCLOMETASONE TOPICAL'
             709 'D01288 CLOBETASOL TOPICAL'
             710 'D01289 CLOCORTOLONE TOPICAL' 711 'D01290 DESONIDE TOPICAL'
             712 'D01291 DESOXIMETASONE TOPICAL'
             713 'D01292 DIFLORASONE TOPICAL'
             714 'D01293 FLUOCINOLONE TOPICAL'
             715 'D01294 FLUOCINONIDE TOPICAL'
             716 'D01295 FLURANDRENOLIDE TOPICAL' 717 'D01296 FLUTICASONE'
             718 'D01298 HALOBETASOL TOPICAL' 719 'D01300 MOMETASONE TOPICAL'
             720 'D01301 DIBUCAINE TOPICAL' 721 'D01302 BUTAMBEN TOPICAL'
             722 'D01303 PRAMOXINE TOPICAL' 723 'D01305 DYCLONINE TOPICAL'
             724 'D01306 COCAINE TOPICAL' 725 'D01307 SALICYLIC ACID TOPICAL'
             726 'D01308 PODOPHYLLUM RESIN TOPICAL'
             727 'D01309 PODOFILOX TOPICAL'
             728 'D01313 TRICHLOROACETIC ACID TOPICAL'
             729 'D01314 SUTILAINS TOPICAL' 730 'D01315 COLLAGENASE TOPICAL'
             731 'D01316 MASOPROCOL TOPICAL'
             732 'D01319 HYDROQUINONE TOPICAL'
             733 'D01320 FORMALDEHYDE TOPICAL' 734 'D01321 CAPSAICIN TOPICAL'
             735 'D01322 ALUMINUM CHLORIDE HEXAHYDRATE TOPICAL'
             736 'D01323 MONOBENZONE TOPICAL' 737 'D01325 ARNICA TOPICAL'
             738 'D01332 HEXACHLOROPHENE TOPICAL'
             739 'D01333 BENZALKONIUM CHLORIDE TOPICAL'
             740 'D01335 SODIUM HYPOCHLORITE TOPICAL'
             741 'D01338 PHYSIOLOGICAL IRRIGATING SOLUTION'
             742 'D01339 MECHLORETHAMINE' 743 'D01341 LOMUSTINE'
             744 'D01342 CARMUSTINE' 745 'D01344 FLOXURIDINE'
             746 'D01345 THIOGUANINE' 747 'D01346 FLUDARABINE'
             748 'D01348 MEGESTROL' 749 'D01351 ESTRAMUSTINE'
             750 'D01353 LEUPROLIDE' 751 'D01354 GOSERELIN'
             752 'D01356 PENTOSTATIN' 753 'D01361 PLICAMYCIN'
             754 'D01368 INTERFERON ALFA-2A' 755 'D01369 INTERFERON ALFA-2B'
             756 'D01372 ALTRETAMINE' 757 'D01373 HYDROXYUREA'
             758 'D01375 ALDESLEUKIN' 759 'D01376 PACLITAXEL'
             760 'D01378 MITOTANE' 761 'D01379 ASPARAGINASE ESCHERICHIA COLI'
             762 'D01382 ETHANOLAMINE OLEATE'
             763 'D01383 SODIUM TETRADECYL SULFATE'
             764 'D01384 MORRHUATE SODIUM' 765 'D01385 BETA-CAROTENE'
             766 'D01386 YOHIMBINE' 767 'D01387 ALPROSTADIL'
             768 'D01389 DISULFIRAM' 769 'D01393 HYALURONIDASE'
             770 'D01394 PROCAINE' 771 'D01395 CHLOROPROCAINE'
             772 'D01396 PRILOCAINE' 773 'D01398 MEPIVACAINE'
             774 'D01402 DEFEROXAMINE' 775 'D01404 SODIUM THIOSULFATE'
             776 'D01406 NALTREXONE' 777 'D01407 FLUMAZENIL'
             778 'D01409 PRALIDOXIME' 779 'D01410 DIGOXIN IMMUNE FAB'
             780 'D01411 MESNA' 781 'D01413 IPECAC' 782 'D01416 TRIENTINE'
             783 'D01417 SUCCIMER' 784 'D01420 AMBENONIUM'
             785 'D01422 GUANIDINE' 786 'D01423 POTASSIUM CITRATE'
             787 'D01424 POTASSIUM ACID PHOSPHATE' 788 'D01425 FLAVOXATE'
             789 'D01427 BETHANECHOL' 790 'D01431 DIMETHYL SULFOXIDE'
             791 'D01433 ACETOHYDROXAMIC ACID' 792 'D01434 METHOXSALEN'
             793 'D01438 IOPANOIC ACID' 794 'D01445 BARIUM SULFATE'
             795 'D01451 GADOPENTETATE DIMEGLUMINE' 796 'D01452 IODAMIDE'
             797 'D01456 IOHEXOL' 798 'D01461 IOPAMIDOL'
             799 'D01469 IOVERSOL' 800 'D01472 METRIZAMIDE'
             801 'D01473 DIATRIZOATE' 802 'D01475 IOTHALAMATE'
             803 'D01476 ETHIODIZED OIL' 804 'D01482 ISOSULFAN BLUE'
             805 'D02373 PHOSPHORATED CARBOHYDRATE SOLUTION'
             806 'D02374 DESFLURANE' 807 'D02375 PLASMA PROTEIN FRACTION'
             808 'D02376 ALBUMIN HUMAN' 809 'D02378 HETASTARCH'
             810 'D02381 POTASSIUM PERCHLORATE' 811 'D03001 CLADRIBINE'
             812 'D03003 DIPHTHERIA-TETANUS TOXOIDS (OBSOLETE)'
             813 'D03004 DIPHTHERIA/PERTUSSIS, WHOLE CELL/TETANUS'
             814 'D03006 MEASLES-RUBELLA VIRUS VACCINE'
             815 'D03007 MEASLES/MUMPS/RUBELLA VIRUS VACCINE'
             816 'D03008 INTERFERON GAMMA-1B' 817 'D03034 NORGESTREL'
             818 'D03041 ENOXAPARIN' 819 'D03050 LORATADINE'
             820 'D03051 INTERFERON BETA-1B'
             821 'D03052 HYDROCHLOROTHIAZIDE-TRIAMTERENE'
             822 'D03054 AMYLASE' 823 'D03056 ATTAPULGITE'
             824 'D03058 BENZOIC ACID' 825 'D03061 BUTALBITAL'
             826 'D03062 CASANTHRANOL' 827 'D03066 CITRIC ACID'
             828 'D03068 DICHLORALPHENAZONE' 829 'D03075 HYDROCODONE'
             830 'D03077 ISOMETHEPTENE MUCATE' 831 'D03085 PEPSIN'
             832 'D03086 PHENIRAMINE' 833 'D03089 PHENYLTOLOXAMINE'
             834 'D03094 SALICYLAMIDE' 835 'D03096 SODIUM BENZOATE'
             836 'D03097 SODIUM BORATE TOPICAL' 837 'D03098 SODIUM CITRATE'
             838 'D03109 JAPANESE ENCEPHALITIS VIRUS VACCINE NAKAYAMA'
             839 'D03110 DIPHTH/PERTUSSIS, ACEL/TETANUS (OBSOLETE)'
             840 'D03112 NEDOCROMIL'
             841 'D03113 DEXTRAN, LOW MOLECULAR WEIGHT'
             842 'D03114 DEXTRAN, HIGH MOLECULAR WEIGHT'
             843 'D03116 BISMUTH SUBGALLATE' 844 'D03118 MUROMONAB-CD3'
             845 'D03125 DIHYDROTACHYSTEROL' 846 'D03126 CALCITRIOL'
             847 'D03128 ERGOCALCIFEROL' 848 'D03129 CHOLECALCIFEROL'
             849 'D03130 THIAMINE' 850 'D03133 HYDROXOCOBALAMIN'
             851 'D03135 PHYTONADIONE' 852 'D03136 VITAMIN A & D TOPICAL'
             853 'D03137 CALCIUM-VITAMIN D' 854 'D03140 MULTIVITAMIN'
             855 'D03141 MULTIVITAMIN WITH IRON'
             856 'D03143 MULTIVITAMIN WITH FLUORIDE'
             857 'D03145 MULTIVITAMIN WITH MINERALS'
             858 'D03148 MULTIVITAMIN, PRENATAL' 859 'D03152 TRIFLUPROMAZINE'
             860 'D03154 DOXYLAMINE' 861 'D03157 PAROXETINE'
             862 'D03158 RIMANTADINE' 863 'D03159 CHOLINE'
             864 'D03160 SUMATRIPTAN' 865 'D03162 ALCOHOL (ETHANOL)'
             866 'D03165 PIPERACILLIN-TAZOBACTAM' 867 'D03166 CISAPRIDE'
             868 'D03168 DIHYDROCODEINE' 869 'D03169 TRIMETREXATE'
             870 'D03170 FELBAMATE' 871 'D03171 GRANISETRON'
             872 'D03173 DORNASE ALFA' 873 'D03176 TACRINE'
             874 'D03180 RISPERIDONE' 875 'D03181 VENLAFAXINE'
             876 'D03182 GABAPENTIN' 877 'D03183 FLUVASTATIN'
             878 'D03187 LEVOMETHADYL ACETATE' 879 'D03189 TORSEMIDE'
             880 'D03190 OXICONAZOLE TOPICAL'
             881 'D03191 TERBINAFINE TOPICAL' 882 'D03192 ZINC OXIDE TOPICAL'
             883 'D03193 AMILORIDE-HYDROCHLOROTHIAZIDE'
             884 'D03195 MICONAZOLE TOPICAL' 885 'D03196 GENTAMICIN TOPICAL'
             886 'D03197 BETAMETHASONE TOPICAL'
             887 'D03200 ERYTHROMYCIN TOPICAL' 888 'D03201 ACYCLOVIR TOPICAL'
             889 'D03202 KETOCONAZOLE TOPICAL' 890 'D03203 MINOXIDIL TOPICAL'
             891 'D03204 FLUOROURACIL TOPICAL'
             892 'D03205 HYDROCORTISONE TOPICAL'
             893 'D03206 TRIAMCINOLONE TOPICAL'
             894 'D03207 AMPHOTERICIN B TOPICAL'
             895 'D03208 METRONIDAZOLE TOPICAL'
             896 'D03210 SELENIUM SULFIDE TOPICAL'
             897 'D03211 CIPROFLOXACIN OPHTHALMIC'
             898 'D03212 ATROPINE OPHTHALMIC'
             899 'D03213 DICLOFENAC OPHTHALMIC'
             900 'D03214 KETOROLAC OPHTHALMIC'
             901 'D03221 PREDNISOLONE OPHTHALMIC'
             902 'D03222 TOBRAMYCIN OPHTHALMIC' 903 'D03224 NEOMYCIN TOPICAL'
             904 'D03226 SALIVA SUBSTITUTES'
             905 'D03227 FLUOROMETHOLONE OPHTHALMIC'
             906 'D03228 LODOXAMIDE OPHTHALMIC'
             907 'D03229 LEVOCABASTINE OPHTHALMIC'
             908 'D03231 TRIPLE SULFA TOPICAL'
             909 'D03232 VITAMINS A, D, AND E TOPICAL'
             910 'D03233 VITAMIN E TOPICAL'
             911 'D03238 ETHINYL ESTRADIOL-NORETHINDRONE'
             912 'D03240 MESTRANOL-NORETHINDRONE'
             913 'D03241 ETHINYL ESTRADIOL-NORGESTREL'
             914 'D03242 ETHINYL ESTRADIOL-LEVONORGESTREL'
             915 'D03245 ESTERIFIED ESTROGENS-METHYLTESTOSTERONE'
             916 'D03247 HYDROCHLOROTHIAZIDE-SPIRONOLACTONE'
             917 'D03251 HYDROCHLOROTHIAZIDE-RESERPINE'
             918 'D03255 BENDROFLUMETHIAZIDE-RAUWOLFIA SERPENTINA'
             919 'D03256 HYDRALAZINE/HYDROCHLOROTHIAZIDE/RESERPINE'
             920 'D03257 HYDRALAZINE-HYDROCHLOROTHIAZIDE'
             921 'D03258 ATENOLOL-CHLORTHALIDONE'
             922 'D03259 BENDROFLUMETHIAZIDE-NADOLOL'
             923 'D03260 HYDROCHLOROTHIAZIDE-TIMOLOL'
             924 'D03261 HYDROCHLOROTHIAZIDE-PROPRANOLOL'
             925 'D03263 HYDROCHLOROTHIAZIDE-METHYLDOPA'
             926 'D03264 HYDROCHLOROTHIAZIDE-METOPROLOL'
             927 'D03265 BENAZEPRIL-HYDROCHLOROTHIAZIDE'
             928 'D03266 HYDROCHLOROTHIAZIDE-LISINOPRIL'
             929 'D03267 CHLORTHALIDONE-CLONIDINE'
             930 'D03271 PHENIRAMINE-PHENYLEPHRINE NASAL'
             931 'D03273 GUAIFENESIN-THEOPHYLLINE'
             932 'D03274 AMINOPHYLLINE-GUAIFENESIN'
             933 'D03276 DYPHYLLINE-GUAIFENESIN'
             934 'D03277 POTASSIUM IODIDE-THEOPHYLLINE'
             935 'D03280 EPHEDRINE/PHENOBARBITAL/THEOPHYLLINE'
             936 'D03283 EPHEDRINE/HYDROXYZINE/THEOPHYLLINE'
             937 'D03289 ACETAMINOPHEN-PSEUDOEPHEDRINE'
             938 'D03292 IBUPROFEN-PSEUDOEPHEDRINE' 939 'D03293 APAP/ASA/PPA'
             940 'D03296 ACETAMINOPHEN-CHLORPHENIRAMINE'
             941 'D03297 ACETAMINOPHEN-PHENYLTOLOXAMINE'
             942 'D03298 CHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             943 'D03299 CHLORPHENIRAMINE-PHENYLPROPANOLAMINE'
             944 'D03300 CHLORPHENIRAMINE-PHENYLEPHRINE'
             945 'D03301 BROMPHENIRAMINE-PSEUDOEPHEDRINE'
             946 'D03302 BROMPHENIRAMINE-PHENYLPROPANOLAMINE'
             947 'D03303 CLEMASTINE-PHENYLPROPANOLAMINE'
             948 'D03306 CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             949 'D03307 CHLORPHENIRAMINE/PHENINDAMINE/PPA'
             950 'D03308 PHENIRAMINE/PPA/PHENYLTOLOXAMINE/PYRILAMINE'
             951 'D03310 CHLORPHENIRAMINE/PE/PPA/PHENYLTOLOXAMINE'
             952 'D03311 BROMPHENIRAMINE-PHENYLEPHRINE'
             953 'D03312 DIPHENHYDRAMINE-PSEUDOEPHEDRINE'
             954 'D03313 CHLORPHENIRAMINE/PHENYLEPHRINE/PYRILAMINE'
             955 'D03316 PSEUDOEPHEDRINE-TRIPROLIDINE'
             956 'D03317 PHENYLEPHRINE-PROMETHAZINE'
             957 'D03318 PHENIRAMINE/PPA/PYRILAMINE'
             958 'D03319 APAP/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             959 'D03320 APAP/CHLORPHENIRAMINE/PSEUDOEPHEDRINE'
             960 'D03321 APAP/BROMPHENIRAMINE/PSEUDOEPHEDRINE'
             961 'D03322 ASA/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             962 'D03329 ASA/DIPHENHYDRAMINE/PPA'
             963 'D03330 APAP/PSEUDOEPHEDRINE/TRIPROLIDINE'
             964 'D03331 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE'
             965 'D03336 APAP/CPM/PHENYLEPHRINE/PPA/PYRILAMINE'
             966 'D03338 CHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             967 'D03340 HOMATROPINE-HYDROCODONE'
             968 'D03341 CODEINE-PSEUDOEPHEDRINE'
             969 'D03342 APAP/DEXTROMETHORPHAN/PSEUDOEPHEDRINE'
             970 'D03347 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             971 'D03349 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PSE'
             972 'D03351 ASA/BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             973 'D03352 HYDROCODONE-PSEUDOEPHEDRINE'
             974 'D03353 HYDROCODONE-PHENYLPROPANOLAMINE'
             975 'D03354 DEXTROMETHORPHAN-PSEUDOEPHEDRINE'
             976 'D03355 DEXTROMETHORPHAN-PHENYLPROPANOLAMINE'
             977 'D03356 CHLORPHENIRAMINE-HYDROCODONE'
             978 'D03357 CODEINE-PROMETHAZINE'
             979 'D03359 CHLORPHENIRAMINE-DEXTROMETHORPHAN'
             980 'D03360 DEXTROMETHORPHAN-PROMETHAZINE'
             981 'D03361 CHLORPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             982 'D03362 CHLORPHENIRAMINE/CODEINE/PSEUDOEPHEDRINE'
             983 'D03364 CODEINE/PHENYLEPHRINE/PROMETHAZINE'
             984 'D03366 HYDROCODONE/PHENYLEPHRINE/PYRILAMINE'
             985 'D03368 BROMPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             986 'D03369 CHLORPHENIRAMINE/DEXTROMETHORP/PHENYLEPHRINE'
             987 'D03370 CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             988 'D03371 DEXTROMETHORPHAN/PHENYLEPHRINE/PYRILAMINE'
             989 'D03372 BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             990 'D03378 ACETAMINOPHEN-DEXTROMETHORPHAN'
             991 'D03379 GUAIFENESIN-PSEUDOEPHEDRINE'
             992 'D03380 EPHEDRINE-GUAIFENESIN'
             993 'D03381 GUAIFENESIN-PHENYLEPHRINE'
             994 'D03382 GUAIFENESIN-PHENYLPROPANOLAMINE'
             995 'D03383 GUAIFENESIN/PHENYLEPHRINE/PPA'
             996 'D03388 ETHINYL ESTRADIOL-ETHYNODIOL'
             997 'D03389 ESTRADIOL-TESTOSTERONE'
             998 'D03392 CHLORPHENIRAMINE/GUAIFENESIN/PHENYLEPHRINE'
             999 'D03393 CODEINE-GUAIFENESIN'
             1000 'D03396 GUAIFENESIN-HYDROCODONE'
             1001 'D03397 GUAIFENESIN-HYDROMORPHONE'
             1002 'D03398 CODEINE/GUAIFENESIN/PSE'
             1003 'D03400 DEXTROMETHORPHAN-GUAIFENESIN'
             1004 'D03403 GUAIFENESIN/HYDROCODONE/PHENYLEPHRINE'
             1005 'D03404 GUAIFENESIN/HYDROCODONE/PSEUDOEPHEDRINE'
             1006 'D03407 CODEINE/GUAIFENESIN/PHENYLPROPANOLAMINE'
             1007 'D03408 DEXTROMETHORPHAN/GUAIFENESIN/PHENYLEPHRINE'
             1008 'D03409 DEXTROMETHORPHAN/GUAIFENESIN/PSEUDOEPHEDRINE'
             1009 'D03411 DEXTROMETHORPHAN/GUAIFENESIN/PPA'
             1010 'D03416 CHLORPHENIRAMINE/HYDROCODONE/PSE'
             1011 'D03419 CHLORPHENIRAMINE/DM/GUAIFENESIN/PHENYLEPHRINE'
             1012 'D03423 ACETAMINOPHEN-CODEINE'
             1013 'D03424 ASPIRIN-CODEINE'
             1014 'D03425 APAP/BUTALBITAL/CAFFEINE/CODEINE'
             1015 'D03426 ASA/BUTALBITAL/CAFFEINE/CODEINE'
             1016 'D03428 ACETAMINOPHEN-HYDROCODONE'
             1017 'D03430 ASA/CAFFEINE/DIHYDROCODEINE'
             1018 'D03431 ACETAMINOPHEN-OXYCODONE'
             1019 'D03432 ASPIRIN-OXYCODONE'
             1020 'D03433 MEPERIDINE-PROMETHAZINE'
             1021 'D03434 ACETAMINOPHEN-PROPOXYPHENE'
             1022 'D03435 ASA/CAFFEINE/PROPOXYPHENE'
             1023 'D03436 BELLADONNA-OPIUM'
             1024 'D03437 APAP/ASA/CAFFEINE/SALICYLAMIDE'
             1025 'D03439 APAP/ASA/CAFFEINE'
             1026 'D03443 APAP/AL HYDROXIDE/ASA/CAFFEINE/MG HYDROXIDE'
             1027 'D03445 ACETAMINOPHEN-DIPHENHYDRAMINE'
             1028 'D03447 ASA/CAFFEINE/SALICYLAMIDE'
             1029 'D03448 ASPIRIN-MEPROBAMATE' 1030 'D03449 ASPIRIN-CAFFEINE'
             1031 'D03453 ASPIRIN-PHENYLTOLOXAMINE'
             1032 'D03454 MAGNESIUM SALICYLATE-PHENYLTOLOXAMINE'
             1033 'D03455 APAP/BUTALBITAL/CAFFEINE'
             1034 'D03456 ACETAMINOPHEN-BUTALBITAL'
             1035 'D03457 ASA/BUTALBITAL/CAFFEINE'
             1036 'D03459 APAP/DICHLORALPHENAZONE/ISOMETHEPTENE'
             1037 'D03462 AMITRIPTYLINE-CHLORDIAZEPOXIDE'
             1038 'D03463 AMITRIPTYLINE-PERPHENAZINE'
             1039 'D03464 DROPERIDOL-FENTANYL'
             1040 'D03468 ASPIRIN-METHOCARBAMOL'
             1041 'D03469 ASPIRIN-CARISOPRODOL'
             1042 'D03470 ASA/CARISOPRODOL/CODEINE'
             1043 'D03472 ASA/CAFFEINE/ORPHENADRINE'
             1044 'D03473 CARBIDOPA-LEVODOPA'
             1045 'D03474 ALUMINUM HYDROXIDE-MAGNESIUM HYDROXIDE'
             1046 'D03478 AL HYDROXIDE/MG HYDROXIDE/SIMETHICONE'
             1047 'D03480 CA CARBONATE/MG HYDROXIDE/SIMETHICONE'
             1048 'D03485 ATROPINE/HYOSCYAMINE/PB/SCOPOLAMINE'
             1049 'D03486 BELLADONNA-BUTABARBITAL'
             1050 'D03492 CHLORDIAZEPOXIDE-CLIDINIUM'
             1051 'D03495 BELLADONNA/ERGOTAMINE/PHENOBARBITAL'
             1052 'D03496 DOCUSATE-SENNA'
             1053 'D03497 DOCUSATE-PHENOLPHTHALEIN'
             1054 'D03498 CASANTHRANOL-DOCUSATE'
             1055 'D03505 ATROPINE-DIFENOXIN'
             1056 'D03506 ATROPINE-DIPHENOXYLATE'
             1057 'D03508 ISONIAZID-RIFAMPIN'
             1058 'D03509 ERYTHROMYCIN-SULFISOXAZOLE'
             1059 'D03511 PHENAZOPYRIDINE-SULFAMETHOXAZOLE'
             1060 'D03513 METHENAMINE-SODIUM ACID PHOSPHATE'
             1061 'D03517 BENZOIC ACID/METHENAMINE/SODIUM SALICYLATE'
             1062 'D03520 NAPHAZOLINE-PHENIRAMINE OPHTHALMIC'
             1063 'D03521 CYCLOPENTOLATE-PHENYLEPHRINE OPHTHALMIC'
             1064 'D03523 HYDROXYAMPHETAMINE-TROPICAMIDE OPHTHALMIC'
             1065 'D03524 BACITRACIN/NEOMYCIN/POLYMYXIN B TOPICAL'
             1066 'D03525 GRAMICIDIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1067 'D03526 NEOMYCIN-POLYMYXIN B SULFATE TOPICAL'
             1068 'D03527 BACITRACIN-POLYMYXIN B TOPICAL'
             1069 'D03529 POLYMYXIN B-TRIMETHOPRIM OPHTHALMIC'
             1070 'D03533 NEOMYCIN/POLYMYXIN B/PREDNISOLONE OPHTHALMIC'
             1071 'D03536 DEXAMETHASONE-TOBRAMYCIN OPHTHALMIC'
             1072 'D03537 DEXAMETHASONE/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1073 'D03541 PREDNISOLONE-SULFACETAMIDE SODIUM OPHTHALMIC'
             1074 'D03542 FLUORESCEIN-PROPARACAINE OPHTHALMIC'
             1075 'D03543 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OTIC'
             1076 'D03544 HYDROCORTISONE-POLYMYXIN B OTIC'
             1077 'D03546 HYDROCORTISONE-PRAMOXINE TOPICAL'
             1078 'D03552 CLIOQUINOL-HYDROCORTISONE TOPICAL'
             1079 'D03553 CLIOQUINOL/HYDROCORTISONE/PRAMOXINE TOPICAL'
             1080 'D03561 BETAMETHASONE-CLOTRIMAZOLE TOPICAL'
             1081 'D03562 NYSTATIN-TRIAMCINOLONE TOPICAL'
             1082 'D03566 CAPTOPRIL-HYDROCHLOROTHIAZIDE'
             1083 'D03569 CARBINOXAMINE'
             1084 'D03570 CARBINOXAMINE-PSEUDOEPHEDRINE'
             1085 'D03572 CARAMIPHEN-PHENYLPROPANOLAMINE'
             1086 'D03576 BROMODIPHENHYDRAMINE-CODEINE'
             1087 'D03577 CARBINOXAMINE/DEXTROMETHORPHAN/PSE'
             1088 'D03584 CODEINE/PHENIRAMINE/PHENYLEPHRINE/NA CITRATE'
             1089 'D03585 PAMABROM' 1090 'D03586 APAP/PAMABROM/PYRILAMINE'
             1091 'D03588 MAGNESIUM CARBONATE'
             1092 'D03591 ALGINIC ACID/AL HYDROXIDE/MG CARBONATE'
             1093 'D03596 ALGINIC ACID/AL HYDROXIDE/MG TRISILICATE'
             1094 'D03600 POTASSIUM BICARBONATE' 1095 'D03613 PSYLLIUM-SENNA'
             1096 'D03618 HYOSCYAMINE/METHENAM/M-BLUE/PHENYL SALICYL'
             1097 'D03620 ANTAZOLINE-NAPHAZOLINE OPHTHALMIC'
             1098 'D03622 BENOXINATE-FLUORESCEIN OPHTHALMIC'
             1099 'D03623 ACETIC ACID TOPICAL' 1100 'D03624 ANTIPYRINE OTIC'
             1101 'D03625 ACETIC ACID-HYDROCORTISONE OTIC'
             1102 'D03627 ANTIPYRINE-BENZOCAINE OTIC'
             1103 'D03628 ANTIPYRINE/BENZOCAINE/PHENYLEPHRINE OTIC'
             1104 'D03630 ANHYDROUS CALCIUM IODIDE-CODEINE'
             1105 'D03632 CETYLPYRIDINIUM TOPICAL'
             1106 'D03634 BENZOCAINE-CETYLPYRIDINIUM TOPICAL'
             1107 'D03640 BUDESONIDE NASAL' 1108 'D03641 PETROLATUM TOPICAL'
             1109 'D03644 LACTOBACILLUS ACIDOPHILUS'
             1110 'D03646 LACTOBACILLUS ACIDOPHILUS AND BULGARICUS'
             1111 'D03647 ISOPROPYL ALCOHOL TOPICAL'
             1112 'D03648 OPHTHALMIC IRRIGATION, INTRAOCULAR'
             1113 'D03649 BENZOIN TOPICAL'
             1114 'D03650 CANDIDA ALBICANS EXTRACT'
             1115 'D03651 CHOLINE SALICYLATE-MAGNESIUM SALICYLATE'
             1116 'D03652 COLCHICINE-PROBENECID'
             1117 'D03653 CALAMINE TOPICAL'
             1118 'D03655 LIDOCAINE-PRILOCAINE TOPICAL'
             1119 'D03656 ETHYL CHLORIDE TOPICAL'
             1120 'D03659 FIBRINOLYSIN AND DESOXYRIBONUCLEASE TOPICAL'
             1121 'D03660 MULTIVITAMIN WITH IRON AND FLUORIDE'
             1122 'D03661 DOCUSATE-FERROUS FUMARATE' 1123 'D03663 LECITHIN'
             1124 'D03664 PHENOL TOPICAL' 1125 'D03665 MENTHOL TOPICAL'
             1126 'D03666 MENTHOL-PHENOL TOPICAL' 1127 'D03667 METHACHOLINE'
             1128 'D03668 METHYL SALICYLATE TOPICAL' 1129 'D03674 PECTIN'
             1130 'D03676 NALOXONE-PENTAZOCINE'
             1131 'D03678 NAPHAZOLINE-ZINC OPHTHALMIC'
             1132 'D03680 ASA/CITRIC ACID/NA BICARB'
             1133 'D03681 OPHTHALMIC IRRIGATION, EXTRAOCULAR'
             1134 'D03682 ACETAMINOPHEN-PENTAZOCINE'
             1135 'D03684 THROMBIN TOPICAL'
             1136 'D03686 UNDECYLENIC ACID TOPICAL'
             1137 'D03687 ALUMINUM ACETATE TOPICAL'
             1138 'D03688 ALUMINUM SULFATE TOPICAL'
             1139 'D03689 CALCIUM ACETATE'
             1140 'D03690 ALUMINUM SULFATE-CALCIUM ACETATE TOPICAL'
             1141 'D03691 BENZOCAINE/PHENOL/POVIDONE IODINE TOPICAL'
             1142 'D03693 ICHTHAMMOL TOPICAL'
             1143 'D03694 MEDRYSONE OPHTHALMIC'
             1144 'D03695 PRAMOXINE-ZINC OXIDE TOPICAL'
             1145 'D03696 BENZYL BENZOATE TOPICAL'
             1146 'D03701 CORN STARCH TOPICAL' 1147 'D03702 SULFUR TOPICAL'
             1148 'D03703 COAL TAR TOPICAL'
             1149 'D03705 SALICYLIC ACID-SULFUR TOPICAL'
             1150 'D03707 ALOE VERA TOPICAL'
             1151 'D03708 LANOLIN-MINERAL OIL TOPICAL'
             1152 'D03710 ALLANTOIN/CAMPHOR/PHENOL TOPICAL'
             1153 'D03712 CAMPHOR TOPICAL'
             1154 'D03713 CAMPHOR-PHENOL TOPICAL'
             1155 'D03716 CITRIC ACID/GLUCONODELTA-LACTONE/MG CARBONATE'
             1156 'D03721 SODIUM IODIDE'
             1157 'D03724 FAT EMULSION, INTRAVENOUS'
             1158 'D03725 INTRAVENOUS ELECTROLYTE SOLUTION'
             1159 'D03735 TRIETHANOLAMINE POLYPEPTIDE OLEATE OTIC'
             1160 'D03738 TETRACYCLINE TOPICAL' 1161 'D03739 NIACINAMIDE'
             1162 'D03740 ENALAPRIL-HYDROCHLOROTHIAZIDE'
             1163 'D03743 PYRIMETHAMINE-SULFADOXINE'
             1164 'D03744 BISOPROLOL-HYDROCHLOROTHIAZIDE'
             1165 'D03750 DEXBROMPHENIRAMINE'
             1166 'D03751 DEXBROMPHENIRAMINE-PSEUDOEPHEDRINE'
             1167 'D03752 TACROLIMUS'
             1168 'D03754 ACRIVASTINE-PSEUDOEPHEDRINE'
             1169 'D03756 BACITRACIN TOPICAL' 1170 'D03759 SALMETEROL'
             1171 'D03760 DIPHENHYDRAMINE TOPICAL'
             1172 'D03761 LANOLIN TOPICAL' 1173 'D03762 WITCH HAZEL TOPICAL'
             1174 'D03763 GLYCERIN-PHENOL TOPICAL'
             1175 'D03764 GLYCERIN-WITCH HAZEL TOPICAL'
             1176 'D03766 ROCURONIUM' 1177 'D03767 IRON DEXTRAN'
             1178 'D03768 OCULAR LUBRICANT' 1179 'D03770 EMOLLIENTS, TOPICAL'
             1180 'D03773 STAVUDINE' 1181 'D03774 DOXEPIN TOPICAL'
             1182 'D03775 FAMCICLOVIR' 1183 'D03777 POTASSIUM ACETATE'
             1184 'D03780 DESOGESTREL'
             1185 'D03781 ETHINYL ESTRADIOL-NORGESTIMATE'
             1186 'D03782 DESOGESTREL-ETHINYL ESTRADIOL'
             1187 'D03783 BUPIVACAINE-EPINEPHRINE'
             1188 'D03784 EPINEPHRINE-LIDOCAINE'
             1189 'D03788 CALCIPOTRIENE TOPICAL'
             1190 'D03789 POTASSIUM GLUCONATE'
             1191 'D03790 POTASSIUM PHOSPHATE'
             1192 'D03796 MAGNESIUM CHLORIDE' 1193 'D03797 MAGNESIUM OXIDE'
             1194 'D03798 MAGNESIUM GLUCONATE' 1195 'D03799 CALCIUM CHLORIDE'
             1196 'D03800 CALCIUM GLUCONATE' 1197 'D03802 CALCIUM LACTATE'
             1198 'D03803 CALCIUM PHOSPHATE, TRIBASIC'
             1199 'D03804 FLUVOXAMINE' 1200 'D03805 DORZOLAMIDE OPHTHALMIC'
             1201 'D03806 ALBENDAZOLE' 1202 'D03807 METFORMIN'
             1203 'D03808 NEFAZODONE' 1204 'D03809 LAMOTRIGINE'
             1205 'D03810 VINORELBINE' 1206 'D03811 ABCIXIMAB'
             1207 'D03812 DALTEPARIN'
             1208 'D03818 LORATADINE-PSEUDOEPHEDRINE'
             1209 'D03819 CONJUGATED ESTROGENS-MEDROXYPROGESTERONE'
             1210 'D03821 LOSARTAN' 1211 'D03822 FERROUS GLUCONATE'
             1212 'D03823 IRON POLYSACCHARIDE' 1213 'D03824 FERROUS SULFATE'
             1214 'D03825 NISOLDIPINE' 1215 'D03826 TRAMADOL'
             1216 'D03827 CETIRIZINE' 1217 'D03828 LANSOPRAZOLE'
             1218 'D03829 AMLODIPINE-BENAZEPRIL'
             1219 'D03830 HYDROCHLOROTHIAZIDE-LOSARTAN'
             1220 'D03831 NILUTAMIDE' 1221 'D03832 VARICELLA VIRUS VACCINE'
             1222 'D03833 DIVALPROEX SODIUM' 1223 'D03834 NALMEFENE'
             1224 'D03835 MOEXIPRIL' 1225 'D03836 ACITRETIN'
             1226 'D03838 VALACYCLOVIR' 1227 'D03839 MYCOPHENOLATE MOFETIL'
             1228 'D03840 IOPROMIDE' 1229 'D03841 DEXRAZOXANE'
             1230 'D03842 EPOPROSTENOL' 1231 'D03843 GADOTERIDOL'
             1232 'D03844 DIRITHROMYCIN' 1233 'D03845 SEVOFLURANE'
             1234 'D03846 ACARBOSE' 1235 'D03847 CARVEDILOL'
             1236 'D03848 AZELAIC ACID TOPICAL' 1237 'D03849 ALENDRONATE'
             1238 'D03850 BICALUTAMIDE'
             1239 'D03857 BENZOYL PEROXIDE-ERYTHROMYCIN TOPICAL'
             1240 'D03858 LAMIVUDINE' 1241 'D03860 SAQUINAVIR'
             1242 'D03862 MAGNESIUM AMINO ACIDS CHELATE'
             1243 'D03863 TRETINOIN' 1244 'D03864 GLIMEPIRIDE'
             1245 'D03866 CALCIUM CITRATE'
             1246 'D03867 CALCIUM CARBONATE-SODIUM FLUORIDE'
             1247 'D03868 AMIFOSTINE' 1248 'D03869 RILUZOLE'
             1249 'D03870 AMPHOTERICIN B LIPID COMPLEX'
             1250 'D03872 PORFIMER' 1251 'D03873 ANASTROZOLE'
             1252 'D03874 CEFTIBUTEN' 1253 'D03877 HEROIN'
             1254 'D03878 COCAINE' 1255 'D03879 MARIJUANA'
             1256 'D03880 PHENCYCLIDINE'
             1257 'D03881 RESPIRATORY SYNCYTIAL VIRUS IMMUNE GLOBULIN'
             1258 'D03882 CEFEPIME'
             1259 'D03883 AL HYDROXIDE/ASA/CA CARBONATE/MG HYDROXIDE'
             1260 'D03884 TROLAMINE SALICYLATE TOPICAL'
             1261 'D03888 BENZOCAINE/BUTAMBEN/TETRACAINE TOPICAL'
             1262 'D03892 HISTAMINE PHOSPHATE' 1263 'D03894 KAOLIN-PECTIN'
             1264 'D03895 SINCALIDE' 1265 'D03897 LACTASE'
             1266 'D03898 SODIUM CHLORIDE, HYPERTONIC, OPHTHALMIC'
             1267 'D03904 BALSAM PERU/CASTOR OIL/TRYPSIN TOPICAL'
             1268 'D03905 ISOPROTERENOL-PHENYLEPHRINE'
             1269 'D03906 PHENIRAMINE/PHENYLTOLOXAMINE/PYRILAMINE'
             1270 'D03908 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             1271 'D03911 CHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1272 'D03913 APAP/DEXTROMETHORPHAN/PSE/PYRILAMINE'
             1273 'D03915 HYDROCODONE-POTASSIUM GUAIACOLSULFONATE'
             1274 'D03920 FERROUS FUMARATE'
             1275 'D03922 ACETAMINOPHEN-CAFFEINE'
             1276 'D03923 ACETAMINOPHEN-PHENYLEPHRINE'
             1277 'D03926 APAP/CAFFEINE/PYRILAMINE'
             1278 'D03927 BACITRACIN OPHTHALMIC'
             1279 'D03929 AMINOPHYLLINE/AMOBARBITAL/EPHEDRINE'
             1280 'D03946 ASCORBIC ACID-FERROUS FUMARATE'
             1281 'D03951 CITRIC ACID/K CITRATE/NA CITRATE'
             1282 'D03952 CITRIC ACID-SODIUM CITRATE'
             1283 'D03953 ELECTROLYTE REPLACEMENT SOLUTIONS, ORAL'
             1284 'D03954 FERROUS FUMARATE-FOLIC ACID'
             1285 'D03957 CALCIUM/FERROUS FUMARATE/VITAMIN D'
             1286 'D03962 POTASSIUM BICARBONATE-POTASSIUM CITRATE'
             1287 'D03963 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1288 'D03964 BACITRACIN/NEOMYCIN/POLYMYXIN B OPHTHALMIC'
             1289 'D03965 BACITRACIN-POLYMYXIN B OPHTHALMIC'
             1290 'D03966 BENZOYL PEROXIDE-SULFUR TOPICAL'
             1291 'D03968 DEXAMETHASONE OPHTHALMIC'
             1292 'D03971 EPINEPHRINE OPHTHALMIC'
             1293 'D03973 ERYTHROMYCIN OPHTHALMIC'
             1294 'D03974 GENTAMICIN OPHTHALMIC'
             1295 'D03975 GLYCERIN OPHTHALMIC'
             1296 'D03976 HYDROCORTISONE OTIC'
             1297 'D03977 OFLOXACIN OPHTHALMIC'
             1298 'D03978 OXYMETAZOLINE OPHTHALMIC'
             1299 'D03979 SCOPOLAMINE OPHTHALMIC'
             1300 'D03980 SULFISOXAZOLE OPHTHALMIC'
             1301 'D03981 TETRACAINE OPHTHALMIC'
             1302 'D03982 TETRACAINE TOPICAL' 1303 'D03984 RITONAVIR'
             1304 'D03985 INDINAVIR' 1305 'D03989 BORIC ACID OPHTHALMIC'
             1306 'D03990 CARBAMIDE PEROXIDE OTIC'
             1307 'D03992 CHLORAMPHENICOL OPHTHALMIC'
             1308 'D03993 CHLORTETRACYCLINE OPHTHALMIC'
             1309 'D03994 COLLOIDAL OATMEAL TOPICAL'
             1310 'D03998 STERILE WATER'
             1311 'D04002 PIPERONYL BUTOXIDE-PYRETHRINS TOPICAL'
             1312 'D04003 HYDROGEN PEROXIDE TOPICAL'
             1313 'D04004 DOXORUBICIN LIPOSOMAL'
             1314 'D04005 AMOBARBITAL-SECOBARBITAL'
             1315 'D04006 DEXFENFLURAMINE' 1316 'D04008 TRANDOLAPRIL'
             1317 'D04009 DOCETAXEL' 1318 'D04010 GEMCITABINE'
             1319 'D04011 INTERFERON BETA-1A' 1320 'D04012 TERBINAFINE'
             1321 'D04014 TOPOTECAN' 1322 'D04015 ADAPALENE TOPICAL'
             1323 'D04016 IODIXANOL' 1324 'D04017 LATANOPROST OPHTHALMIC'
             1325 'D04021 BENZOIC ACID-SALICYLIC ACID TOPICAL'
             1326 'D04025 MIRTAZAPINE' 1327 'D04026 IRINOTECAN'
             1328 'D04027 MEROPENEM' 1329 'D04028 CIDOFOVIR'
             1330 'D04029 NEVIRAPINE' 1331 'D04031 PILOCARPINE'
             1332 'D04032 SULFACETAMIDE SODIUM-SULFUR TOPICAL'
             1333 'D04034 REMIFENTANIL'
             1334 'D04035 AMPHETAMINE-DEXTROAMPHETAMINE'
             1335 'D04036 CAFFEINE-SODIUM BENZOATE'
             1336 'D04037 TIMOLOL OPHTHALMIC'
             1337 'D04038 BETAXOLOL OPHTHALMIC'
             1338 'D04039 CARTEOLOL OPHTHALMIC' 1339 'D04040 FEXOFENADINE'
             1340 'D04041 FOSPHENYTOIN'
             1341 'D04043 FOLLICLE STIMULATING HORMONE'
             1342 'D04044 RESORCINOL TOPICAL'
             1343 'D04045 RESORCINOL-SULFUR TOPICAL' 1344 'D04047 MIDODRINE'
             1345 'D04048 BRIMONIDINE OPHTHALMIC'
             1346 'D04049 AMMONIUM LACTATE TOPICAL' 1347 'D04050 OLANZAPINE'
             1348 'D04051 ROPIVACAINE'
             1349 'D04052 PENTOSAN POLYSULFATE SODIUM'
             1350 'D04053 ZAFIRLUKAST' 1351 'D04054 PENCICLOVIR TOPICAL'
             1352 'D04056 ZINC GLUCONATE' 1353 'D04057 ZINC SULFATE'
             1354 'D04058 MELATONIN'
             1355 'D04059 HAEMOPHILUS B-HEPATITIS B VACCINE'
             1356 'D04060 DILTIAZEM-ENALAPRIL'
             1357 'D04061 BISMUTH SUBSALICYLATE/METRONIDAZOLE/TCN'
             1358 'D04062 BENTOQUATAM TOPICAL'
             1359 'D04063 BUTENAFINE TOPICAL'
             1360 'D04065 TRANDOLAPRIL-VERAPAMIL'
             1361 'D04066 ALBUTEROL-IPRATROPIUM' 1362 'D04067 RETEPLASE'
             1363 'D04068 AZELASTINE NASAL'
             1364 'D04070 SODIUM PHENYLBUTYRATE'
             1365 'D04075 CHLOROXYLENOL TOPICAL'
             1366 'D04076 CHLOROXYLENOL/HYDROCORTISONE/PRAMOXINE OTIC'
             1367 'D04083 GADODIAMIDE' 1368 'D04084 GLYCINE IRRIGATION'
             1369 'D04090 LACTIC ACID TOPICAL'
             1370 'D04093 HYDROCORTISONE-IODOQUINOL TOPICAL'
             1371 'D04095 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B OPHTH'
             1372 'D04096 IMIGLUCERASE' 1373 'D04099 DONEPEZIL'
             1374 'D04100 AMPHOTERICIN B CHOLESTERYL SULFATE'
             1375 'D04101 IVERMECTIN' 1376 'D04102 TIZANIDINE'
             1377 'D04103 ZILEUTON' 1378 'D04105 ATORVASTATIN'
             1379 'D04106 FOSFOMYCIN' 1380 'D04107 AMLEXANOX TOPICAL'
             1381 'D04109 LEVOFLOXACIN' 1382 'D04110 MIGLITOL'
             1383 'D04111 GLATIRAMER' 1384 'D04112 CABERGOLINE'
             1385 'D04113 VALSARTAN' 1386 'D04115 TOPIRAMATE'
             1387 'D04116 ENALAPRIL-FELODIPINE'
             1388 'D04117 OLOPATADINE OPHTHALMIC' 1389 'D04118 NELFINAVIR'
             1390 'D04119 DELAVIRDINE' 1391 'D04120 CAFFEINE-ERGOTAMINE'
             1392 'D04121 TAMSULOSIN' 1393 'D04122 TROGLITAZONE'
             1394 'D04123 ZINC ACETATE' 1395 'D04125 IMIQUIMOD TOPICAL'
             1396 'D04126 ANAGRELIDE' 1397 'D04128 LVP SOLUTION'
             1398 'D04130 LVP SOLUTION WITH HYPERTONIC SALINE'
             1399 'D04131 PARENTERAL NUTRITION SOLUTION'
             1400 'D04132 PARENTERAL NUTRITION SOLUTION W/ELECTROLYTES'
             1401 'D04133 NEOMYCIN OPHTHALMIC'
             1402 'D04134 POLYMYXIN B OPHTHALMIC'
             1403 'D04135 PHENYLEPHRINE OPHTHALMIC' 1404 'D04137 TOREMIFENE'
             1405 'D04138 TAZAROTENE TOPICAL' 1406 'D04139 MIBEFRADIL'
             1407 'D04141 HYDROCHLOROTHIAZIDE-MOEXIPRIL'
             1408 'D04142 CHROMIUM PICOLINATE'
             1409 'D04143 ACETAMINOPHEN-PAMABROM' 1410 'D04145 PRAMIPEXOLE'
             1411 'D04147 NAPHAZOLINE NASAL' 1412 'D04150 BROMFENAC'
             1413 'D04151 BENZOCAINE-TRIMETHOBENZAMIDE'
             1414 'D04152 HYDROCODONE-PHENYLEPHRINE'
             1415 'D04153 PHENAZOPYRIDINE-SULFISOXAZOLE'
             1416 'D04155 ASPIRIN-DIPHENHYDRAMINE' 1417 'D04156 LETROZOLE'
             1418 'D04157 LOPERAMIDE-SIMETHICONE' 1419 'D04159 SORBITOL'
             1420 'D04160 SODIUM BIPHOSPHATE-SODIUM PHOSPHATE'
             1421 'D04161 SECRETIN' 1422 'D04163 FERROUS SULFATE-FOLIC ACID'
             1423 'D04166 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PSE'
             1424 'D04168 APAP/DIPHENHYDRAMINE/PSEUDOEPHEDRINE'
             1425 'D04172 CALAMINE-PRAMOXINE TOPICAL'
             1426 'D04175 DIPHENHYDRAMINE-MAGNESIUM SALICYLATE'
             1427 'D04177 FAT SUPPLEMENT, ORAL'
             1428 'D04178 CALCIUM HYDROXIDE TOPICAL'
             1429 'D04184 POTASSIUM AMINOBENZOATE'
             1430 'D04185 POTASSIUM BICARBONATE-SODIUM BICARBONATE'
             1431 'D04186 PHENYLEPHRINE NASAL'
             1432 'D04189 TRIPELENNAMINE TOPICAL'
             1433 'D04190 PAPAIN TOPICAL' 1434 'D04191 PAPAIN-UREA TOPICAL'
             1435 'D04192 COLISTIN/HC/NEOMYCIN/THONZONIUM OTIC'
             1436 'D04193 LEVMETAMFETAMINE NASAL'
             1437 'D04194 PROPYLHEXEDRINE NASAL' 1438 'D04195 CHLOROPHYLLIN'
             1439 'D04196 BACITRACIN/HC/NEOMYCIN/POLYMYXIN B TOPICAL'
             1440 'D04197 HYDROCORTISONE/NEOMYCIN/POLYMYXIN B TOPICAL'
             1441 'D04204 COPPER SULFATE'
             1442 'D04205 POVIDONE IODINE OPHTHALMIC'
             1443 'D04206 TETRAHYDROZOLINE NASAL'
             1444 'D04208 SILVER NITRATE TOPICAL'
             1445 'D04209 METHOXSALEN TOPICAL'
             1446 'D04210 ESTRADIOL TOPICAL' 1447 'D04214 DOLASETRON'
             1448 'D04215 ROPINIROLE' 1449 'D04217 EPINEPHRINE-PRILOCAINE'
             1450 'D04219 LAMIVUDINE-ZIDOVUDINE' 1451 'D04220 QUETIAPINE'
             1452 'D04221 TIAGABINE' 1453 'D04222 IRBESARTAN'
             1454 'D04223 MOMETASONE NASAL'
             1455 'D04224 INTERFERON ALFACON-1'
             1456 'D04225 HYDROCODONE-IBUPROFEN'
             1457 'D04226 AMINOSALICYLIC ACID' 1458 'D04228 ACETIC ACID OTIC'
             1459 'D04229 GLYCERIN OTIC' 1460 'D04231 VITAMIN A OPHTHALMIC'
             1461 'D04233 TRIAMCINOLONE NASAL'
             1462 'D04235 IPRATROPIUM NASAL' 1463 'D04236 ETHANOL TOPICAL'
             1464 'D04238 AMPHOTERICIN B LIPOSOMAL'
             1465 'D04240 HYLAN G-F 20'
             1466 'D04241 POTASSIUM CHLORIDE-SODIUM CHLORIDE'
             1467 'D04242 SODIUM CHLORIDE NASAL'
             1468 'D04243 LIDOCAINE-OXYTETRACYCLINE'
             1469 'D04245 HYDROCHLOROTHIAZIDE-IRBESARTAN'
             1470 'D04247 PEGASPARGASE' 1471 'D04248 METHYLCELLULOSE'
             1472 'D04249 CELLULOSE' 1473 'D04253 ZOLMITRIPTAN'
             1474 'D04255 RITUXIMAB' 1475 'D04256 CEFDINIR'
             1476 'D04258 CLOPIDOGREL' 1477 'D04260 SIBUTRAMINE'
             1478 'D04261 RALOXIFENE' 1479 'D04263 TROVAFLOXACIN'
             1480 'D04264 BECAPLERMIN TOPICAL' 1481 'D04265 OFLOXACIN OTIC'
             1482 'D04266 EPROSARTAN' 1483 'D04267 REPAGLINIDE'
             1484 'D04269 APAP/CAFFEINE/DIHYDROCODEINE'
             1485 'D04270 FEXOFENADINE-PSEUDOEPHEDRINE'
             1486 'D04271 DICLOFENAC-MISOPROSTOL'
             1487 'D04272 AMOXICILLIN/CLARITHROMYCIN/LANSOPRAZOLE'
             1488 'D04274 FOMEPIZOLE' 1489 'D04275 BECLOMETHASONE NASAL'
             1490 'D04276 BUDESONIDE' 1491 'D04279 FLUNISOLIDE NASAL'
             1492 'D04282 TOLCAPONE' 1493 'D04283 FLUTICASONE NASAL'
             1494 'D04284 FLUTICASONE TOPICAL' 1495 'D04285 NARATRIPTAN'
             1496 'D04286 FENOFIBRATE' 1497 'D04287 CIPROFLOXACIN OTIC'
             1498 'D04288 CIPROFLOXACIN-HYDROCORTISONE OTIC'
             1499 'D04289 MONTELUKAST'
             1500 'D04290 CALCIUM CARBONATE-MAGNESIUM HYDROXIDE'
             1501 'D04291 LEPIRUDIN' 1502 'D04292 LOTEPREDNOL OPHTHALMIC'
             1503 'D04293 HYDROCHLOROTHIAZIDE-VALSARTAN'
             1504 'D04294 TOLTERODINE' 1505 'D04295 OXYMETHOLONE'
             1506 'D04296 STARCH TOPICAL'
             1507 'D04297 PHENYLEPHRINE-PRAMOXINE TOPICAL'
             1508 'D04298 PHENYLEPHRINE TOPICAL' 1509 'D04299 SILDENAFIL'
             1510 'D04300 RISEDRONATE' 1511 'D04301 BRINZOLAMIDE OPHTHALMIC'
             1512 'D04303 DORZOLAMIDE-TIMOLOL OPHTHALMIC'
             1513 'D04305 SACROSIDASE' 1514 'D04311 CAPECITABINE'
             1515 'D04312 PARICALCITOL' 1516 'D04314 BASILIXIMAB'
             1517 'D04315 TIROFIBAN' 1518 'D04316 EPTIFIBATIDE'
             1519 'D04320 DIPHTHERIA/HAEMOPHILUS/PERTUSSIS,ACEL/TETANUS'
             1520 'D04321 INTERFERON ALFA-2B-RIBAVIRIN'
             1521 'D04322 CANDESARTAN' 1522 'D04323 PALIVIZUMAB'
             1523 'D04328 RIZATRIPTAN' 1524 'D04329 SODIUM HYALURONATE'
             1525 'D04331 THALIDOMIDE' 1526 'D04332 CITALOPRAM'
             1527 'D04334 EPHEDRINE-POTASSIUM IODIDE'
             1528 'D04339 DEXTROMETHORPHAN-POTASSIUM GUAIACOLSULFONATE'
             1529 'D04342 INFLIXIMAB' 1530 'D04344 ROTAVIRUS VACCINE'
             1531 'D04345 APAP/CAFFEINE/GUAIFENESIN/PHENYLEPHRINE'
             1532 'D04347 DOXYCYCLINE TOPICAL' 1533 'D04349 LEFLUNOMIDE'
             1534 'D04351 COAL TAR/LACTIC ACID/SALICYLIC ACID TOPICAL'
             1535 'D04355 EFAVIRENZ' 1536 'D04357 TRASTUZUMAB'
             1537 'D04360 HEMIN' 1538 'D04363 SEVELAMER'
             1539 'D04364 TELMISARTAN' 1540 'D04365 ETANERCEPT'
             1541 'D04366 SIMETHICONE COATED CELLULOSE'
             1542 'D04368 TANNIC ACID TOPICAL' 1543 'D04369 INSULIN REGULAR'
             1544 'D04370 INSULIN ISOPHANE' 1545 'D04371 INSULIN ZINC'
             1546 'D04372 INSULIN ZINC EXTENDED' 1547 'D04373 INSULIN LISPRO'
             1548 'D04374 INSULIN ISOPHANE-INSULIN REGULAR'
             1549 'D04375 ESTRADIOL-NORETHINDRONE' 1550 'D04376 ABACAVIR'
             1551 'D04377 THYROTROPIN ALPHA' 1552 'D04378 MODAFINIL'
             1553 'D04379 LYME DISEASE VACCINE' 1554 'D04380 CELECOXIB'
             1555 'D04382 CILOSTAZOL' 1556 'D04386 DENILEUKIN DIFTITOX'
             1557 'D04387 SODIUM FERRIC GLUCONATE COMPLEX'
             1558 'D04389 PENTASTARCH' 1559 'D04391 LIVER DERIVATIVE COMPLEX'
             1560 'D04393 BUTABARBITAL/HYOSCYAMINE/PHENAZOPYRIDINE'
             1561 'D04394 CROMOLYN NASAL' 1562 'D04395 CLOTRIMAZOLE TOPICAL'
             1563 'D04396 CONJUGATED ESTROGENS TOPICAL'
             1564 'D04397 FLUORIDE TOPICAL' 1565 'D04399 NYSTATIN TOPICAL'
             1566 'D04402 CILASTATIN' 1567 'D04406 TYPHOID VACCINE, LIVE'
             1568 'D04407 ECHINACEA' 1569 'D04408 ST. JOHN''S WORT'
             1570 'D04409 CHAMOMILE' 1571 'D04410 FEVERFEW'
             1572 'D04411 GARLIC' 1573 'D04412 GINSENG' 1574 'D04413 GINKGO'
             1575 'D04414 GINGER' 1576 'D04415 SAW PALMETTO'
             1577 'D04416 VALERIAN' 1578 'D04417 CREATINE'
             1579 'D04418 GLUCOSAMINE' 1580 'D04419 CHONDROITIN'
             1581 'D04420 CHONDROITIN-GLUCOSAMINE'
             1582 'D04421 EVENING PRIMROSE' 1583 'D04422 KAVA'
             1584 'D04423 GOLDENSEAL' 1585 'D04425 DEHYDROEPIANDROSTERONE'
             1586 'D04426 RED YEAST RICE' 1587 'D04427 LEVALBUTEROL'
             1588 'D04429 ORLISTAT'
             1589 'D04430 BACITRACIN/NEOMYCIN/POLYMYXIN B/PRAMOXINE TOP'
             1590 'D04431 NEOMYCIN/POLYMYXIN B/PRAMOXINE TOPICAL'
             1591 'D04432 CARBONYL IRON' 1592 'D04433 ROFECOXIB'
             1593 'D04434 ROSIGLITAZONE' 1594 'D04435 DOXERCALCIFEROL'
             1595 'D04436 MALATHION TOPICAL' 1596 'D04440 PERINDOPRIL'
             1597 'D04441 KETOTIFEN OPHTHALMIC' 1598 'D04442 PIOGLITAZONE'
             1599 'D04443 ZANAMIVIR'
             1600 'D04445 CARBETAPENTANE/CHLORPHENIRAMINE/PHENYLEPHRINE'
             1601 'D04446 PHENYLEPHRINE-PYRILAMINE' 1602 'D04447 GANIRELIX'
             1603 'D04448 RABEPRAZOLE' 1604 'D04451 TEMOZOLOMIDE'
             1605 'D04452 ZALEPLON' 1606 'D04453 SIROLIMUS'
             1607 'D04454 EPIRUBICIN' 1608 'D04457 DALFOPRISTIN-QUINUPRISTIN'
             1609 'D04458 PEMIROLAST OPHTHALMIC' 1610 'D04459 DOFETILIDE'
             1611 'D04460 ENTACAPONE' 1612 'D04461 EXEMESTANE'
             1613 'D04462 OSELTAMIVIR' 1614 'D04463 GRAPE SEED OIL'
             1615 'D04464 DONG QUAI' 1616 'D04466 MILK THISTLE'
             1617 'D04467 CAT''S CLAW' 1618 'D04469 BEE POLLEN'
             1619 'D04470 CRANBERRY' 1620 'D04472 BLACK COHOSH'
             1621 'D04473 BLUE COHOSH' 1622 'D04478 WILD YAM'
             1623 'D04479 PENNYROYAL' 1624 'D04481 ROYAL JELLY'
             1625 'D04482 DAMIANA' 1626 'D04483 DANDELION'
             1627 'D04484 SHARK CARTILAGE' 1628 'D04491 FLAX'
             1629 'D04492 FENUGREEK' 1630 'D04497 ASPIRIN-DIPYRIDAMOLE'
             1631 'D04498 NAPROXEN-PSEUDOEPHEDRINE'
             1632 'D04499 LEVETIRACETAM' 1633 'D04500 MOXIFLOXACIN'
             1634 'D04501 AMINOLEVULINIC ACID TOPICAL'
             1635 'D04503 NEDOCROMIL OPHTHALMIC' 1636 'D04504 GATIFLOXACIN'
             1637 'D04505 DEXMEDETOMIDINE'
             1638 'D04506 ESTRADIOL-NORGESTIMATE' 1639 'D04507 BEXAROTENE'
             1640 'D04508 NITRIC OXIDE'
             1641 'D04509 HYDROCHLOROTHIAZIDE-QUINAPRIL'
             1642 'D04510 INSULIN LISPRO-INSULIN LISPRO PROTAMINE'
             1643 'D04512 CEVIMELINE' 1644 'D04513 OXCARBAZEPINE'
             1645 'D04514 PANTOPRAZOLE' 1646 'D04515 GADOVERSETAMIDE'
             1647 'D04516 ALOSETRON' 1648 'D04523 UBIQUINONE'
             1649 'D04524 S-ADENOSYLMETHIONINE' 1650 'D04527 ZONISAMIDE'
             1651 'D04530 STRONTIUM-89 CHLORIDE'
             1652 'D04531 SAMARIUM SM 153 LEXIDRONAM' 1653 'D04532 MELOXICAM'
             1654 'D04533 VERTEPORFIN' 1655 'D04534 LINEZOLID'
             1656 'D04535 ARTICAINE-EPINEPHRINE' 1657 'D04536 ARTICAINE'
             1658 'D04537 RIVASTIGMINE' 1659 'D04538 INSULIN GLARGINE'
             1660 'D04539 FOSINOPRIL-HYDROCHLOROTHIAZIDE'
             1661 'D04540 GEMTUZUMAB' 1662 'D04541 AZELASTINE OPHTHALMIC'
             1663 'D04547 ATOVAQUONE-PROGUANIL' 1664 'D04557 CLOBAZAM'
             1665 'D04572 FORMOTEROL' 1666 'D04597 TETRABENAZINE'
             1667 'D04611 FLUTICASONE-SALMETEROL' 1668 'D04659 TINZAPARIN'
             1669 'D04669 VIGABATRIN'
             1670 'D04674 DIPHTH/HAEMOPHILUS/PERTUSSIS/TETANUS/POLIO'
             1671 'D04675 DIPHTHERIA/PERTUSSIS,ACEL/TETANUS/POLIO'
             1672 'D04685 HEPATITIS A-HEPATITIS B VACCINE'
             1673 'D04689 CALAMINE-DIPHENHYDRAMINE TOPICAL'
             1674 'D04694 TENECTEPLASE' 1675 'D04695 COLESEVELAM'
             1676 'D04697 INSULIN ASPART' 1677 'D04698 ARGATROBAN'
             1678 'D04700 BALSALAZIDE' 1679 'D04702 DOCOSANOL TOPICAL'
             1680 'D04703 GLYBURIDE-METFORMIN'
             1681 'D04704 EFLORNITHINE TOPICAL'
             1682 'D04705 FLUDEOXYGLUCOSE F18'
             1683 'D04707 LEVOFLOXACIN OPHTHALMIC'
             1684 'D04708 ZOLEDRONIC ACID'
             1685 'D04711 CANDESARTAN-HYDROCHLOROTHIAZIDE'
             1686 'D04716 LOPINAVIR' 1687 'D04717 LOPINAVIR-RITONAVIR'
             1688 'D04718 MIFEPRISTONE' 1689 'D04720 ARSENIC TRIOXIDE'
             1690 'D04722 DICLOFENAC TOPICAL'
             1691 'D04723 CALCIUM CARBONATE/FAMOTIDINE/MG HYDROXIDE'
             1692 'D04725 IRON SUCROSE' 1693 'D04726 5-HYDROXYTRYPTOPHAN'
             1694 'D04727 ABACAVIR/LAMIVUDINE/ZIDOVUDINE'
             1695 'D04737 HYDROCHLOROTHIAZIDE-TELMISARTAN'
             1696 'D04738 APAP/DOXYLAMINE/PSEUDOEPHEDRINE'
             1697 'D04740 TACROLIMUS TOPICAL'
             1698 'D04741 CARBETAPENTANE/GUAIFENESIN/PHENYLEPHRINE'
             1699 'D04742 BENZOYL PEROXIDE-CLINDAMYCIN TOPICAL'
             1700 'D04743 NATEGLINIDE' 1701 'D04744 BIVALIRUDIN'
             1702 'D04746 PEGINTERFERON ALFA-2B' 1703 'D04747 ZIPRASIDONE'
             1704 'D04748 CASPOFUNGIN' 1705 'D04749 ESOMEPRAZOLE'
             1706 'D04750 GALANTAMINE'
             1707 'D04752 CARBINOXAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1708 'D04753 TRAVOPROST OPHTHALMIC'
             1709 'D04754 BIMATOPROST OPHTHALMIC'
             1710 'D04755 VALGANCICLOVIR' 1711 'D04756 ALEMTUZUMAB'
             1712 'D04757 ALMOTRIPTAN' 1713 'D04758 IMATINIB'
             1714 'D04760 DROSPIRENONE-ETHINYL ESTRADIOL'
             1715 'D04761 MINOCYCLINE TOPICAL'
             1716 'D04762 METHSCOPOLAMINE-PSEUDOEPHEDRINE'
             1717 'D04763 NESIRITIDE'
             1718 'D04764 CETIRIZINE-PSEUDOEPHEDRINE'
             1719 'D04765 HYDROCORTISONE-LIDOCAINE TOPICAL'
             1720 'D04766 ACETAMINOPHEN-TRAMADOL' 1721 'D04767 CEFDITOREN'
             1722 'D04770 CARBETAPENTANE-CHLORPHENIRAMINE'
             1723 'D04771 DARBEPOETIN ALFA' 1724 'D04772 ETONOGESTREL'
             1725 'D04773 ETHINYL ESTRADIOL-ETONOGESTREL'
             1726 'D04774 TENOFOVIR' 1727 'D04775 ANAKINRA'
             1728 'D04776 FROVATRIPTAN' 1729 'D04777 DEXMETHYLPHENIDATE'
             1730 'D04778 VALDECOXIB'
             1731 'D04779 ETHINYL ESTRADIOL-NORELGESTROMIN'
             1732 'D04782 BOSENTAN' 1733 'D04783 ERTAPENEM'
             1734 'D04784 PIMECROLIMUS TOPICAL' 1735 'D04785 DESLORATADINE'
             1736 'D04786 FONDAPARINUX' 1737 'D04787 LOVASTATIN-NIACIN'
             1738 'D04788 DUTASTERIDE' 1739 'D04789 NITISINONE'
             1740 'D04790 PEGFILGRASTIM'
             1741 'D04791 FLUOCINOLONE/HYDROQUINONE/TRETINOIN TOPICAL'
             1742 'D04792 ASA/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1743 'D04793 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PE'
             1744 'D04794 CARBINOXAMINE/METHSCOPOLAMINE/PSEUDOEPHEDRINE'
             1745 'D04795 BUDESONIDE-FORMOTEROL' 1746 'D04796 PERFLUTREN'
             1747 'D04797 ALFUZOSIN' 1748 'D04798 TEGASEROD'
             1749 'D04799 FULVESTRANT' 1750 'D04800 IFOSFAMIDE-MESNA'
             1751 'D04801 OLMESARTAN' 1752 'D04802 TREPROSTINIL'
             1753 'D04803 VORICONAZOLE' 1754 'D04805 RASBURICASE'
             1755 'D04806 SODIUM OXYBATE' 1756 'D04811 OXALIPLATIN'
             1757 'D04812 ESCITALOPRAM' 1758 'D04814 ADEFOVIR'
             1759 'D04815 EPLERENONE'
             1760 'D04817 DEXCHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             1761 'D04818 DEXCHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             1762 'D04819 BUPRENORPHINE-NALOXONE'
             1763 'D04820 METFORMIN-ROSIGLITAZONE'
             1764 'D04821 PEGINTERFERON ALFA-2A'
             1765 'D04823 GLIPIZIDE-METFORMIN' 1766 'D04824 EZETIMIBE'
             1767 'D04825 ARIPIPRAZOLE' 1768 'D04826 NITAZOXANIDE'
             1769 'D04827 ATOMOXETINE' 1770 'D04828 TERIPARATIDE'
             1771 'D04829 TIOTROPIUM' 1772 'D04831 SMALLPOX VACCINE'
             1773 'D04832 DIPHTHERIA/HEPB/PERTUSSIS,ACEL/POLIO/TETANUS'
             1774 'D04834 CYTARABINE LIPOSOMAL' 1775 'D04835 ADALIMUMAB'
             1776 'D04836 CYCLOSPORINE OPHTHALMIC'
             1777 'D04838 INSULIN ASPART PROTAMINE'
             1778 'D04839 INSULIN ASPART-INSULIN ASPART PROTAMINE'
             1779 'D04843 ALEFACEPT' 1780 'D04844 CAMPHOR-MENTHOL TOPICAL'
             1781 'D04845 IBRITUMOMAB' 1782 'D04849 ELETRIPTAN'
             1783 'D04850 CARBETAPENTANE/PHENYLEPHRINE/PYRILAMINE'
             1784 'D04851 ROSUVASTATIN' 1785 'D04852 BUPIVACAINE-FENTANYL'
             1786 'D04853 ENFUVIRTIDE' 1787 'D04854 PEGVISOMANT'
             1788 'D04855 APREPITANT' 1789 'D04856 BOTULISM ANTITOXIN'
             1790 'D04857 GATIFLOXACIN OPHTHALMIC'
             1791 'D04858 ANTHRAX VACCINE ADSORBED'
             1792 'D04859 GEMIFLOXACIN' 1793 'D04860 MOXIFLOXACIN OPHTHALMIC'
             1794 'D04861 DIPHENHYDRAMINE-PHENYLEPHRINE'
             1795 'D04862 BROMPHENIRAMINE/DM/GUAIFENESIN/PSE'
             1796 'D04863 CHLORPHENIRAMINE/IBUPROFEN/PSEUDOEPHEDRINE'
             1797 'D04864 CARBETAPENTANE-PSEUDOEPHEDRINE'
             1798 'D04866 AGALSIDASE BETA' 1799 'D04868 GEFITINIB'
             1800 'D04869 CHLORPHENIRAMINE/DIHYDROCODEINE/PSE'
             1801 'D04870 DIHYDROCODEINE/GUAIFENESIN/PSEUDOEPHEDRINE'
             1802 'D04871 BORTEZOMIB' 1803 'D04875 BETAINE'
             1804 'D04877 CARBIDOPA/ENTACAPONE/LEVODOPA'
             1805 'D04878 HYDROCHLOROTHIAZIDE-OLMESARTAN'
             1806 'D04879 PHENYLEPHRINE-POTASSIUM GUAIACOLSULFONATE'
             1807 'D04880 BROMPHENIRAMINE/HYDROCODONE/PSEUDOEPHEDRINE'
             1808 'D04881 OMALIZUMAB' 1809 'D04882 ATAZANAVIR'
             1810 'D04884 EMTRICITABINE' 1811 'D04885 TOSITUMOMAB'
             1812 'D04886 IODINE I 131 TOSITUMOMAB'
             1813 'D04887 BUPIVACAINE-HYDROMORPHONE'
             1814 'D04888 PALONOSETRON'
             1815 'D04890 CIPROFLOXACIN-DEXAMETHASONE OTIC'
             1816 'D04892 INFLUENZA VIRUS VACCINE, LIVE, TRIVALENT'
             1817 'D04893 VARDENAFIL' 1818 'D04894 DAPTOMYCIN'
             1819 'D04895 CARBETAPENTANE/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1820 'D04896 TADALAFIL'
             1821 'D04897 TETRAHYDROZOLINE-ZINC OPHTHALMIC'
             1822 'D04898 EPINASTINE OPHTHALMIC' 1823 'D04899 MEMANTINE'
             1824 'D04900 SALICYLIC ACID-UREA TOPICAL'
             1825 'D04901 FOSAMPRENAVIR' 1826 'D04902 EFALIZUMAB'
             1827 'D04905 BROMPHENIRAMINE/DEXTROMETHORPH/PHENYLEPHRINE'
             1828 'D04913 LANSOPRAZOLE-NAPROXEN'
             1829 'D04914 ESTRADIOL-LEVONORGESTREL'
             1830 'D04915 SERTACONAZOLE TOPICAL' 1831 'D04916 CAPSICUM'
             1832 'D04917 FLUOXETINE-OLANZAPINE'
             1833 'D04920 PNEUMOCOCCAL 7-VALENT CONJUGATE VACCINE'
             1834 'D04921 TETANUS-DIPHTH TOXOIDS (TD) ADULT/ADOL'
             1835 'D04925 DIPHENHYDRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1836 'D04929 TROSPIUM' 1837 'D04933 TELITHROMYCIN'
             1838 'D04935 TINIDAZOLE' 1839 'D04986 ACAMPROSATE'
             1840 'D04991 APOMORPHINE' 1841 'D05029 LUTROPIN ALFA'
             1842 'D05044 BETAMETHASONE-CALCIPOTRIENE TOPICAL'
             1843 'D05047 PEMETREXED' 1844 'D05048 AMLODIPINE-ATORVASTATIN'
             1845 'D05101 CETUXIMAB'
             1846 'D05117 GUAIFENESIN-POTASSIUM GUAIACOLSULFONATE'
             1847 'D05119 DEXTROMETHORPHAN/GG/K GUAIACOLSULFONATE'
             1848 'D05145 ARTEMETHER-LUMEFANTRINE'
             1849 'D05150 CARBINOXAMINE/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1850 'D05214 BEVACIZUMAB' 1851 'D05215 ZINC ACETATE TOPICAL'
             1852 'D05216 DIPHENHYDRAMINE-ZINC ACETATE TOPICAL'
             1853 'D05217 MYCOPHENOLIC ACID' 1854 'D05218 CINACALCET'
             1855 'D05232 ILOPROST' 1856 'D05234 HYALURONAN'
             1857 'D05238 BENZOYL PEROXIDE-UREA TOPICAL'
             1858 'D05262 MOMETASONE' 1859 'D05265 NEBIVOLOL'
             1860 'D05269 CADEXOMER IODINE TOPICAL'
             1861 'D05278 INSULIN GLULISINE'
             1862 'D05283 BRIMONIDINE-TIMOLOL OPHTHALMIC'
             1863 'D05292 APAP/CAFFEINE/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1864 'D05293 AZACITIDINE' 1865 'D05294 RIFAXIMIN'
             1866 'D05303 CHLORPHENIRAMINE-CODEINE'
             1867 'D05332 PITCHER PLANT'
             1868 'D05334 BROMPHENIRAMINE/CODEINE/PHENYLEPHRINE'
             1869 'D05337 PNEUMOCOCCAL 23-POLYVALENT VACCINE'
             1870 'D05338 DIPHTHERIA-TETANUS TOXOIDS (DT) PED'
             1871 'D05339 HEPATITIS A PEDIATRIC VACCINE'
             1872 'D05340 HEPATITIS A ADULT VACCINE'
             1873 'D05341 HAEMOPHILUS B CONJUGATE (HBOC) VACCINE'
             1874 'D05343 HAEMOPHILUS B CONJUGATE (PRP-T) VACCINE'
             1875 'D05346 GADOBUTROL' 1876 'D05348 EZETIMIBE-SIMVASTATIN'
             1877 'D05349 BISACODYL-PEG 3350 WITH ELECTROLYTES'
             1878 'D05350 POLYETHYLENE GLYCOL 3350'
             1879 'D05351 APAP/PHENYLTOLOXAMINE/SALICYLAMIDE'
             1880 'D05352 EMTRICITABINE-TENOFOVIR'
             1881 'D05354 ABACAVIR-LAMIVUDINE' 1882 'D05355 DULOXETINE'
             1883 'D05357 IBANDRONATE'
             1884 'D05361 CARBETAPENTANE-GUAIFENESIN'
             1885 'D05366 APAP/DEXTROMETHORPHAN/DOXYLAMINE'
             1886 'D05383 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN'
             1887 'D05384 DEXTROMETHORPHAN/PHENIRAMINE/PHENYLEPHRINE'
             1888 'D05389 BISACODYL-MAGNESIUM CITRATE'
             1889 'D05395 LANTHANUM CARBONATE'
             1890 'D05411 CHLORPHENIRAMINE-METHSCOPOLAMINE'
             1891 'D05412 ERLOTINIB' 1892 'D05413 SOLIFENACIN'
             1893 'D05414 NATALIZUMAB' 1894 'D05415 IBUPROFEN-OXYCODONE'
             1895 'D05416 CHLORDIAZEPOXIDE-METHSCOPOLAMINE'
             1896 'D05417 PALIFERMIN' 1897 'D05418 PEGAPTANIB OPHTHALMIC'
             1898 'D05420 ALOH/DIPHENHYD/LIDOCAINE/MGOH/SIMETH TOPICAL'
             1899 'D05421 ESZOPICLONE' 1900 'D05422 DARIFENACIN'
             1901 'D05423 CLOFARABINE' 1902 'D05424 ZICONOTIDE'
             1903 'D05425 LOTEPREDNOL-TOBRAMYCIN OPHTHALMIC'
             1904 'D05426 BROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             1905 'D05427 PACLITAXEL PROTEIN-BOUND'
             1906 'D05428 GADOBENATE DIMEGLUMINE'
             1907 'D05432 MENINGOCOCCAL CONJUGATE VACCINE'
             1908 'D05433 DIGESTIVE ENZYMES/HYOSCYAMINE/PHENYLTOLOXAMIN'
             1909 'D05434 BROMPHENIRAMINE/CARBETAPENTANE/PHENYLEPHRINE'
             1910 'D05436 INSULIN DETEMIR'
             1911 'D05459 POVIDONE-TETRAHYDROZOLINE OPHTHALMIC'
             1912 'D05461 SODIUM BENZOATE-SODIUM PHENYLACETATE'
             1913 'D05465 CICLESONIDE'
             1914 'D05470 ASCORBIC ACID-IRON POLYSACCHARIDE'
             1915 'D05471 ALPHA-D-GALACTOSIDASE'
             1916 'D05473 DESLORATADINE-PSEUDOEPHEDRINE'
             1917 'D05487 MICAFUNGIN' 1918 'D05488 PRAMLINTIDE'
             1919 'D05508 PREGABALIN' 1920 'D05518 BROMFENAC OPHTHALMIC'
             1921 'D05525 ENTECAVIR'
             1922 'D05526 ALENDRONATE-CHOLECALCIFEROL'
             1923 'D05527 FLUOCINOLONE OPHTHALMIC'
             1924 'D05528 TRICHOPHYTON SKIN TEST' 1925 'D05529 EXENATIDE'
             1926 'D05530 DROSPIRENONE-ESTRADIOL'
             1927 'D05535 HEME IRON POLYPEPTIDE'
             1928 'D05536 APAP/GUAIFENESIN/PSEUDOEPHEDRINE'
             1929 'D05537 TIGECYCLINE' 1930 'D05538 TIPRANAVIR'
             1931 'D05539 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PSE'
             1932 'D05540 HYDRALAZINE-ISOSORBIDE DINITRATE'
             1933 'D05543 DAPSONE TOPICAL'
             1934 'D05544 APAP/GUAIFENESIN/PHENYLEPHRINE'
             1935 'D05578 RAMELTEON'
             1936 'D05583 APAP/DEXTROMETHORPHAN/PHENYLEPHRINE'
             1937 'D05612 RASAGILINE' 1938 'D05626 EVEROLIMUS'
             1939 'D05630 CALCIUM CARBONATE-RISEDRONATE'
             1940 'D05632 BISACODYL/SODIUM BIPHOSPHATE/SODIUM PHOSPHATE'
             1941 'D05633 NEPAFENAC OPHTHALMIC'
             1942 'D05635 METFORMIN-PIOGLITAZONE' 1943 'D05636 MECASERMIN'
             1944 'D05637 LACTOBACILLUS RHAMNOSUS GG'
             1945 'D05644 APAP/CAFFEINE/ISOMETHEPTENE MUCATE'
             1946 'D05645 MEASLES/MUMPS/RUBELLA/VARICELLA VIRUS VACCINE'
             1947 'D05646 SACCHAROMYCES BOULARDII LYO'
             1948 'D05647 FERRIC SUBSULFATE TOPICAL'
             1949 'D05649 CEFTRIAXONE-LIDOCAINE'
             1950 'D05651 SODIUM HYALURONATE TOPICAL'
             1951 'D05654 APAP/DIPHENHYDRAMINE/PHENYLEPHRINE'
             1952 'D05659 DEFERASIROX'
             1953 'D05661 ACETAMINOPHEN-GUAIFENESIN'
             1954 'D05674 GLIMEPIRIDE-ROSIGLITAZONE' 1955 'D05691 SORAFENIB'
             1956 'D05692 MECASERMIN RINFABATE' 1957 'D05694 ABATACEPT'
             1958 'D05696 LENALIDOMIDE' 1959 'D05702 METHYLSULFONYLMETHANE'
             1960 'D05703 CHONDROITIN/GLUCOSAMINE/METHYLSULFONYLMETHANE'
             1961 'D05704 IMMUNE GLOBULIN SUBCUTANEOUS'
             1962 'D05717 SUNITINIB' 1963 'D05719 RANOLAZINE'
             1964 'D05722 GALLIUM CITRATE GA-67' 1965 'D05736 LUBIPROSTONE'
             1966 'D05753 MICONAZOLE-ZINC OXIDE TOPICAL'
             1967 'D05757 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PE'
             1968 'D05765 INSULIN INHALATION, RAPID ACTING'
             1969 'D05768 APAP/PHENIRAMINE/PHENYLEPHRINE'
             1970 'D05770 OMEPRAZOLE-SODIUM BICARBONATE'
             1971 'D05773 L-METHYLFOLATE'
             1972 'D05774 AMMONIUM LACTATE-UREA TOPICAL' 1973 'D05776 IODINE'
             1974 'D05777 IODINE-POTASSIUM IODIDE'
             1975 'D05778 APAP/DEXTROMETHORPHAN/GUAIFENESIN/PE'
             1976 'D05781 TETANUS/DIPHTH/PERTUSS (TDAP) ADULT/ADOL'
             1977 'D05782 DIPHTHERIA/TETANUS/PERTUSSIS (DTAP) PED'
             1978 'D05785 RABIES VACCINE, HUMAN DIPLOID CELL'
             1979 'D05786 RABIES VACCINE, PURIFIED CHICK EMBRYO CELL'
             1980 'D05788 DECITABINE'
             1981 'D05806 FERROUS FUMARATE/FA/IRON POLYSACCHARIDE'
             1982 'D05807 VARENICLINE' 1983 'D05813 ZOSTER VACCINE LIVE'
             1984 'D05814 DEXTROMETHORPHAN-PHENYLEPHRINE'
             1985 'D05815 FLUORESCEIN'
             1986 'D05817 HUMAN PAPILLOMAVIRUS VACCINE'
             1987 'D05819 DIPHENHYDRAMINE-IBUPROFEN' 1988 'D05825 DARUNAVIR'
             1989 'D05830 FERUMOXSIL' 1990 'D05831 DASATINIB'
             1991 'D05835 RANIBIZUMAB OPHTHALMIC'
             1992 'D05847 EFAVIRENZ/EMTRICITABINE/TENOFOVIR'
             1993 'D05848 ROTIGOTINE' 1994 'D05851 LEVOCETIRIZINE'
             1995 'D05853 POSACONAZOLE' 1996 'D05855 IDURSULFASE'
             1997 'D05856 GLIMEPIRIDE-PIOGLITAZONE'
             1998 'D05864 COMPLEMENT C1 ESTERASE INHIBITOR'
             1999 'D05866 GUAR GUM'
             2000 'D05874 ANTIHEMOPHILIC FACTOR-VON WILLEBRAND FACTOR'
             2001 'D05877 DEXTROMETHORPHAN/DIPHENHYDRAMINE/PE'
             2002 'D05878 BENZALKONIUM CHLORIDE-BENZOCAINE TOPICAL'
             2003 'D05879 PANITUMUMAB' 2004 'D05891 VORINOSTAT'
             2005 'D05892 DEXCHLORPHENIRAMINE/DEXTROMETHO/PE/PYRILAMINE'
             2006 'D05893 ARFORMOTEROL'
             2007 'D05894 CALAMINE-ZINC OXIDE TOPICAL'
             2008 'D05896 SITAGLIPTIN'
             2009 'D05897 BENZOYL PEROXIDE-SALICYLIC ACID TOPICAL'
             2010 'D05899 CICLESONIDE NASAL'
             2011 'D05963 COAGULATION FACTOR IX' 2012 'D05964 ALOE VERA'
             2013 'D05973 CLINDAMYCIN-TRETINOIN TOPICAL'
             2014 'D05974 ANTIHEMOPHILIC FACTOR'
             2015 'D06008 BENZYL ALCOHOL TOPICAL'
             2016 'D06032 FLUOCINOLONE OTIC'
             2017 'D06058 DEXBROMPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             2018 'D06080 APAP/CAFFEINE/MAGNESIUM SALICYLATE'
             2019 'D06214 COLLAGEN' 2020 'D06227 IOXILAN'
             2021 'D06272 DIENOGEST-ESTRADIOL' 2022 'D06297 PALIPERIDONE'
             2023 'D06370 TURMERIC' 2024 'D06392 WHEAT DEXTRIN'
             2025 'D06507 CINNAMON' 2026 'D06635 MILNACIPRAN'
             2027 'D06648 ATROPINE/CPM/HYOSCYAMINE/PSE/SCOPOLAMINE'
             2028 'D06655 ALPHA-LIPOIC ACID'
             2029 'D06662 AMLODIPINE-VALSARTAN'
             2030 'D06663 LISDEXAMFETAMINE' 2031 'D06665 ALISKIREN'
             2032 'D06672 LAPATINIB' 2033 'D06673 ECULIZUMAB'
             2034 'D06720 METFORMIN-SITAGLIPTIN'
             2035 'D06831 RETAPAMULIN TOPICAL'
             2036 'D06833 ACETAMINOPHEN-ASPIRIN'
             2037 'D06834 BISMUTH SUBCITRATE POTASSIUM/METRONIDAZO/TCN'
             2038 'D06835 DEXCHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             2039 'D06836 TEMSIROLIMUS' 2040 'D06841 AMBRISENTAN'
             2041 'D06842 ARMODAFINIL' 2042 'D06848 LUTEIN'
             2043 'D06851 AZITHROMYCIN OPHTHALMIC' 2044 'D06852 MARAVIROC'
             2045 'D06857 ACETIC/ANTIPYRINE/BENZOCAINE/POLYCOS OTIC'
             2046 'D06862 HELIUM' 2047 'D06864 HELIUM-OXYGEN'
             2048 'D06867 BIOTIN' 2049 'D06868 MENTHOL-ZINC OXIDE TOPICAL'
             2050 'D06872 APAP/CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             2051 'D06891 CHLOROPHYLLIN COPPER COM/PAPAIN/UREA TOPICAL'
             2052 'D06900 COLLAGEN TOPICAL'
             2053 'D06905 AMLODIPINE-OLMESARTAN'
             2054 'D06976 ASA/CHLORPHENIRAMINE/PHENYLEPHRINE'
             2055 'D07048 RALTEGRAVIR' 2056 'D07049 DORIPENEM'
             2057 'D07051 IXABEPILONE'
             2058 'D07055 CHLORPHENIRAMINE/GUAIFENESIN/METHSCOPOLAMI/PE'
             2059 'D07057 NILOTINIB'
             2060 'D07058 SULFACETAMIDE SODIUM/SULFUR/UREA TOPICAL'
             2061 'D07059 CITRIC ACID-POTASSIUM BICARBONATE'
             2062 'D07063 BROMPHENIRAMINE-DIPHENHYDRAMINE'
             2063 'D07065 BENZYL ALCOHOL-ZINC ACETATE TOPICAL'
             2064 'D07068 SAPROPTERIN' 2065 'D07069 RUFINAMIDE'
             2066 'D07075 PERMETHRIN/PIPERONYL BUTOXIDE/PYRETHR TOPICAL'
             2067 'D07076 ETRAVIRINE'
             2068 'D07077 ALISKIREN-HYDROCHLOROTHIAZIDE'
             2069 'D07110 NIACIN-SIMVASTATIN' 2070 'D07113 DESVENLAFAXINE'
             2071 'D07121 BENDAMUSTINE' 2072 'D07130 NAPROXEN-SUMATRIPTAN'
             2073 'D07131 REGADENOSON' 2074 'D07132 OLOPATADINE NASAL'
             2075 'D07134 CERTOLIZUMAB' 2076 'D07135 METHYLNALTREXONE'
             2077 'D07137 DABIGATRAN' 2078 'D07162 FESOTERODINE'
             2079 'D07292 METFORMIN-REPAGLINIDE'
             2080 'D07298 DIFLUPREDNATE OPHTHALMIC'
             2081 'D07300 CHLOPHEDIANOL/DEXCHLORPHENIRAMINE/PSE'
             2082 'D07302 CHLOPHEDIANOL/GUAIFENESIN/PSEUDOEPHEDRINE'
             2083 'D07306 BENZOCAINE-MENTHOL TOPICAL' 2084 'D07309 GENISTEIN'
             2085 'D07312 CLEVIDIPINE' 2086 'D07315 GLUTAMINE'
             2087 'D07320 ROMIPLOSTIM' 2088 'D07347 BIFIDOBACTERIUM INFANTIS'
             2089 'D07349 LACOSAMIDE'
             2090 'D07351 CARBETAPENTANE/PSEUDOEPHEDRINE/PYRILAMINE'
             2091 'D07354 SILODOSIN' 2092 'D07356 RIVAROXABAN'
             2093 'D07357 ELTROMBOPAG' 2094 'D07371 FENOFIBRIC ACID'
             2095 'D07374 BIMATOPROST TOPICAL OPHTHALMIC'
             2096 'D07382 ADAPALENE-BENZOYL PEROXIDE TOPICAL'
             2097 'D07385 HEPARIN FLUSH'
             2098 'D07387 HYDROCORTISONE/SALICYLIC ACID/SULFUR TOPICAL'
             2099 'D07395 DEXLANSOPRAZOLE' 2100 'D07396 USTEKINUMAB'
             2101 'D07397 FEBUXOSTAT'
             2102 'D07405 CARBETAPENTANE/PE/POTASSIUM GUAIACOLSULFONATE'
             2103 'D07409 PRASUGREL' 2104 'D07411 DEGARELIX'
             2105 'D07418 BENZOCAINE-RESORCINOL TOPICAL'
             2106 'D07435 GOLIMUMAB'
             2107 'D07440 AMLODIPINE/HYDROCHLOROTHIAZIDE/VALSARTAN'
             2108 'D07441 ILOPERIDONE' 2109 'D07447 TOLVAPTAN'
             2110 'D07453 TAPENTADOL' 2111 'D07458 DRONEDARONE'
             2112 'D07459 FERUMOXYTOL'
             2113 'D07464 INFLUENZA VIRUS VACCINE, H1N1, INACTIVATED'
             2114 'D07466 LIRAGLUTIDE' 2115 'D07467 SAXAGLIPTIN'
             2116 'D07472 MORPHINE-NALTREXONE' 2117 'D07473 ASENAPINE'
             2118 'D07481 POLY-L-LACTIC ACID'
             2119 'D07482 BEPOTASTINE OPHTHALMIC' 2120 'D07483 TELAVANCIN'
             2121 'D07485 INFLUENZA VIRUS VACCINE, H1N1, LIVE'
             2122 'D07486 ALISKIREN-VALSARTAN'
             2123 'D07491 DIPHENHYDRAMINE/LIDOCAINE/NYSTATIN TOPICAL'
             2124 'D07492 PRALATREXATE' 2125 'D07496 TOCILIZUMAB'
             2126 'D07498 AMLODIPINE-TELMISARTAN' 2127 'D07499 PAZOPANIB'
             2128 'D07505 COPPER' 2129 'D07509 OFATUMUMAB'
             2130 'D07518 SILVER TOPICAL' 2131 'D07546 DALFAMPRIDINE'
             2132 'D07550 DEXTROMETHORPHAN-DOXYLAMINE'
             2133 'D07565 IPILIMUMAB'
             2134 'D07586 PNEUMOCOCCAL 13-VALENT CONJUGATE VACCINE'
             2135 'D07589 BIOFLAVONOIDS-ZINC GLYCINATE'
             2136 'D07631 ESOMEPRAZOLE-NAPROXEN'
             2137 'D07634 DUTASTERIDE-TAMSULOSIN' 2138 'D07637 PITAVASTATIN'
             2139 'D07638 SIPULEUCEL-T' 2140 'D07640 DENOSUMAB'
             2141 'D07642 ANTI-THYMOCYTE GLOBULIN (RABBIT)'
             2142 'D07644 HEPATITIS B ADULT VACCINE'
             2143 'D07645 ONABOTULINUMTOXINA'
             2144 'D07646 ABOBOTULINUMTOXINA' 2145 'D07647 RACEPINEPHRINE'
             2146 'D07658 CABAZITAXEL'
             2147 'D07659 CAFFEINE-MAGNESIUM SALICYLATE'
             2148 'D07660 FORMOTEROL-MOMETASONE'
             2149 'D07668 AMLODIPINE/HYDROCHLOROTHIAZIDE/OLMESARTAN'
             2150 'D07670 ALCAFTADINE OPHTHALMIC' 2151 'D07684 ROFLUMILAST'
             2152 'D07688 PEGLOTICASE'
             2153 'D07691 MAGNESIUM/POTASSIUM/SODIUM SULFATES'
             2154 'D07692 FINGOLIMOD'
             2155 'D07697 DROSPIRENONE/ETHINYL ESTRADIOL/LEVOMEFOLATE'
             2156 'D07705 LURASIDONE' 2157 'D07706 CEFTAROLINE'
             2158 'D07709 METFORMIN-SAXAGLIPTIN' 2159 'D07715 TESAMORELIN'
             2160 'D07716 ERIBULIN' 2161 'D07727 PENICILLIN G BENZATHINE'
             2162 'D07729 PENICILLIN G POTASSIUM'
             2163 'D07730 PENICILLIN V POTASSIUM'
             2164 'D07738 BROMPHENIRAMINE/CHLOPHEDIANOL/PSE'
             2165 'D07740 VILAZODONE' 2166 'D07754 AZILSARTAN'
             2167 'D07756 BELIMUMAB'
             2168 'D07757 LIDOCAINE-SODIUM BICARBONATE'
             2169 'D07761 VANDETANIB' 2170 'D07766 ABIRATERONE'
             2171 'D07767 LINAGLIPTIN' 2172 'D07774 BOCEPREVIR'
             2173 'D07777 TELAPREVIR'
             2174 'D07796 EMTRICITABINE/RILPIVIRINE/TENOFOVIR'
             2175 'D07798 VEMURAFENIB' 2176 'I00031 XYLENE'
             2177 'I00035 TURPENTINE' 2178 'I00039 TRICHLOROETHANE'
             2179 'I00040 TOLUENE' 2180 'I00081 NAPHTHALENE'
             2181 'I00084 METHYLENE CHLORIDE' 2182 'I00088 METHANOL'
             2183 'I00102 FORMALDEHYDE' 2184 'I00106 ETHYLENE GLYCOL'
             2185 'I00108 ETHYL ETHER' 2186 'I00162 ACETONE'
             2187 'I00173 CYANOACRYLATE' 2188 'I00176 ISOBUTYL NITRITE'
             2189 'I00190 AEROSOL SPRAY-NOS' 2190 'I00196 BUTANE'
             2191 'I00198 TRICHLOROFLUOROMETHANE' 2192 'I00200 METHANE'
             2193 'I00201 PETROLEUM HYDROCARBONS'
             2194 'I00203 CARBON TETRACHLORIDE' 2195 'I00207 BUTYL ALCOHOL'
             2196 'I00209 ALPHA TERPINEOL' 2197 'I00210 FREON'
             2198 'I00211 DICHLOROBENZENE' 2199 'I00212 PROPOXUR'
             2200 'I00216 PROPANE' 2201 'I00219 PHENOLIC DISINFECTANTS'
             2202 'I00221 MINERAL SEAL OIL' 2203 'I00238 FLUORINE'
             2204 'I00240 HYDROCARBON' 2205 'I00247 CHLORINATED HYDROCARBONS'
             2206 'I00251 CRESOL' 2207 'I00256 BUTYL ACETATE'
             2208 'I00343 CLEANER/UNKNOWN COMPOSITION'
             2209 'I00345 COSMETIC/UNKNOWN COMPOSITION'
             2210 'I00348 PESTICIDE/UNKNOWN COMPOSITION'
             2211 'I00349 VOLATILE/UNKNOWN COMPONENTS'
             2212 'I00350 PAINT/UNKNOWN COMPOSITION'
             2213 'I00543 TRICHLOROETHANE/TRICHLOROETHYLENE'
             2214 'I00556 PETROLEUM HYDROCARBONS/TRICHLOROETHANE'
             2215 'I01283 ETHANOL-NP' 2216 'I01328 TRICHLOROMETHANE'
             2217 'I01336 FLUORINATED HYDROCARBONS' 2218 'I01337 ISOBUTANE'
             2219 'I01400 CHLORODIFLUOROMETHANE' 2220 'I01425 ETHYL ACETATE'
             2221 'J00001 LYSERGIC ACID DIETHYLAMIDE'
             2222 'J00002 METHYLENEDIOXYMETHAMPHETAMINE'
             2223 'J00004 FLUNITRAZEPAM' 2224 'J00020 BROMELAIN'
             2225 'J00023 NOMIFENSINE MALEATE' 2226 'J00027 MECLOZINE HCL'
             2227 'J00028 NITRAZEPAM' 2228 'J00030 ZOMEPIRAC'
             2229 'J00032 XYLAZINE' 2230 'J00033 VITAMIN K'
             2231 'J00036 L-TRYPTOPHAN' 2232 'J00049 SULFORIDAZINE'
             2233 'J00050 SULFADINE' 2234 'J00053 SALINE'
             2235 'J00061 PRAZEPAM' 2236 'J00064 PHENMETRAZINE HCL'
             2237 'J00066 PHENACETIN' 2238 'J00089 METHACYCLINE'
             2239 'J00090 MERBROMIN' 2240 'J00092 LUTREXIN'
             2241 'J00093 LORMETAZEPAM' 2242 'J00094 LACTOSE'
             2243 'J00095 KETOTIFEN FUMARATE' 2244 'J00096 INFANT FORMULA'
             2245 'J00097 HYDROXY-N-METHYLMORPHINAN'
             2246 'J00104 FENPROPOREX' 2247 'J00110 ERYTHRITYL TETRANITRATE'
             2248 'J00114 DYPYRONE' 2249 'J00120 DIHYDROMORPHINONE'
             2250 'J00122 ALDOSTERONE' 2251 'J00129 CHLOROPYRAMINE'
             2252 'J00148 CARBAMATE' 2253 'J00150 BROMAZEPAM'
             2254 'J00164 ACEPROMAZINE' 2255 'J00168 METHCATHINONE'
             2256 'J00171 CATHINONE' 2257 'J00174 METHYLENEDIOXYAMPHETAMINE'
             2258 'J00177 METHAQUALONE' 2259 'J00178 MESCALINE'
             2260 'J00179 PSILOCYBIN' 2261 'J00180 MORNING GLORY SEEDS'
             2262 'J00192 DATURA SAUVEOLENS'
             2263 'J00215 GAMMA BUTYROLACTONE' 2264 'J00248 EUCALYPTUS OIL'
             2265 'J00249 PEPPER' 2266 'J00263 DIMETHOXYMETHAMPHETAMINE'
             2267 'J00264 DATURA STRAMONIUM' 2268 'J00265 CANTHARIDINE'
             2269 'J00278 ISOPROPAMIDE IODIDE' 2270 'J00280 ALLOBARBITAL'
             2271 'J00290 CLOBENZOREX' 2272 'J00293 AMBROXOL'
             2273 'J00294 TETRAMYCIN' 2274 'J00295 RHODOMYCIN'
             2275 'J00331 ZOPICLONE' 2276 'J00336 MYCADRINE'
             2277 'J00337 POTASSIUM' 2278 'J00339 PYRETHRUM'
             2279 'J00356 ARECOLINE' 2280 'J00358 PHOSPHATIDYLETHANOLAMINE'
             2281 'J00360 CHLORPHENTERMINE' 2282 'J00362 BARBITURIC ACID'
             2283 'J00364 BARBITAL'
             2284 'J00369 BROMO-DIMETHOXYPHENETHYLAMINE'
             2285 'J00500 MARIJUANA/METHAMPHETAMINE'
             2286 'J00501 FORMALDEHYDE/MARIJUANA'
             2287 'J00502 COCAINE/METHAMPHETAMINE'
             2288 'J00504 COCAINE/MARIJUANA' 2289 'J00507 COCAINE/HEROIN'
             2290 'J00510 MARIJUANA/PHENCYCLIDINE'
             2291 'J00511 COCAINE/PHENCYCLIDINE'
             2292 'J00512 LYSERGIC ACID DIETHYLAMIDE/METHAMPHETAMINE'
             2293 'J00513 LYSERGIC ACID DIETHYLAMIDE/PHENCYCLIDINE'
             2294 'J00514 HEROIN/MARIJUANA'
             2295 'J00531 AMOBARBITAL/DEXTROAMPHETAMINE/THYROID DESICCATED'
             2296 'J00533 PENTOBARBITAL/PHENOBARBITAL'
             2297 'J00539 CAFFEINE/EPHEDRINE'
             2298 'J00540 ACETAMINOPHEN/CHLORZOXAZONE'
             2299 'J00558 ASPIRIN/CAFFEINE/CODEINE/PHENACETIN'
 2300 'J00566 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE/DEXTROMETHORPHAN/GUAIFENESIN'
             2301 'J00568 COCAINE/ETHANOL'
             2302 'J00572 SALICYLAMIDE/SCOPOLAMINE'
             2303 'J00577 CODEINE/TERPIN HYDRATE'
             2304 'J00591 ACETAMINOPHEN/CAFFEINE/CODEINE'
             2305 'J00593 AMYLASE/PROTEASE'
             2306 'J00594 ASPIRIN/CAFFEINE/CODEINE'
             2307 'J01003 ANTIFUNGALS-NOS'
             2308 'J01004 ANTIMALARIAL AGENTS-NOS'
             2309 'J01005 ANTITUBERCULOSIS AGENTS-NOS'
             2310 'J01006 ANTIVIRAL AGENTS-NOS'
             2311 'J01008 CEPHALOSPORINS-NOS' 2312 'J01010 MACROLIDES-NOS'
             2313 'J01011 ANTIBIOTICS-NOS' 2314 'J01012 PENICILLINS-NOS'
             2315 'J01013 QUINOLONES-NOS' 2316 'J01014 SULFONAMIDES-NOS'
             2317 'J01015 TETRACYCLINES-NOS'
             2318 'J01016 URINARY ANTI-INFECTIVES-NOS'
             2319 'J01017 AMINOGLYCOSIDES-NOS'
             2320 'J01018 ANTIHYPERLIPIDEMIC AGENTS-NOS'
             2321 'J01026 RADIOPHARMACEUTICALS-NOS'
             2322 'J01028 ANTITOXINS AND ANTIVENINS-NOS'
             2323 'J01029 BACTERIAL VACCINES-NOS'
             2324 'J01030 COLONY STIMULATING FACTORS-NOS'
             2325 'J01031 IMMUNE GLOBULINS-NOS'
             2326 'J01033 RECOMBINANT HUMAN ERYTHROPOIETINS-NOS'
             2327 'J01034 TOXOIDS-NOS' 2328 'J01035 VIRAL VACCINES-NOS'
             2329 'J01037 CARDIOVASCULAR AGENTS-NOS'
             2330 'J01039 ANGIOTENSIN CONVERTING ENZYME INHIBITORS-NOS'
             2331 'J01040 ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING-NOS'
             2332 'J01042 ANTIANGINAL AGENTS-NOS'
             2333 'J01043 ANTIARRHYTHMIC AGENTS-NOS'
             2334 'J01044 BETA-ADRENERGIC BLOCKING AGENTS-NOS'
             2335 'J01045 CALCIUM CHANNEL BLOCKING AGENTS-NOS'
             2336 'J01047 INOTROPIC AGENTS-NOS'
             2337 'J01049 PERIPHERAL VASODILATORS-NOS'
             2338 'J01050 VASODILATORS-NOS' 2339 'J01051 VASOPRESSORS-NOS'
             2340 'J01052 ANTIHYPERTENSIVE COMBINATIONS-NOS'
             2341 'J01053 ANGIOTENSIN II INHIBITORS-NOS'
             2342 'J01056 ANALGESICS-NOS'
             2343 'J01057 NARCOTIC ANALGESICS-NOS'
             2344 'J01058 NONSTEROIDAL ANTI-INFLAMMATORY AGENTS-NOS'
             2345 'J01059 SALICYLATES-NOS' 2346 'J01061 ANTICONVULSANTS-NOS'
             2347 'J01063 ANTIPARKINSON AGENTS-NOS'
             2348 'J01065 BARBITURATES-NOS' 2349 'J01066 BENZODIAZEPINES-NOS'
             2350 'J01067 ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS'
             2351 'J01068 CNS STIMULANTS-NOS'
             2352 'J01069 GENERAL ANESTHETICS-NOS'
             2353 'J01073 ANTIPSYCHOTICS-NOS'
             2354 'J01077 ANTICOAGULANTS-NOS'
             2355 'J01078 ANTIPLATELET AGENTS-NOS'
             2356 'J01081 THROMBOLYTICS-NOS'
             2357 'J01082 GASTROINTESTINAL AGENTS-NOS'
             2358 'J01083 ANTACIDS-NOS'
             2359 'J01084 ANTICHOLINERGICS/ANTISPASMODICS-NOS'
             2360 'J01085 ANTIDIARRHEALS-NOS'
             2361 'J01086 DIGESTIVE ENZYMES-NOS'
             2362 'J01088 GI STIMULANTS-NOS' 2363 'J01089 H2 ANTAGONISTS-NOS'
             2364 'J01090 LAXATIVES-NOS' 2365 'J01092 HORMONES-NOS'
             2366 'J01093 ADRENAL CORTICAL STEROIDS-NOS'
             2367 'J01094 ANTIDIABETIC AGENTS-NOS'
             2368 'J01096 SEX HORMONES-NOS' 2369 'J01098 THYROID DRUGS-NOS'
             2370 'J01099 IMMUNOSUPPRESSIVE AGENTS-NOS'
             2371 'J01101 ANTIDOTES-NOS' 2372 'J01102 CHELATING AGENTS-NOS'
             2373 'J01103 CHOLINERGIC MUSCLE STIMULANTS-NOS'
             2374 'J01104 LOCAL INJECTABLE ANESTHETICS-NOS'
             2375 'J01106 PSORALENS-NOS'
             2376 'J01107 RADIOCONTRAST AGENTS-NOS'
             2377 'J01108 GENITOURINARY TRACT AGENTS-NOS'
             2378 'J01111 IRON PRODUCTS-NOS'
             2379 'J01112 MINERALS AND ELECTROLYTES-NOS'
             2380 'J01113 ORAL NUTRITIONAL SUPPLEMENTS-NOS'
             2381 'J01115 VITAMIN AND MINERAL COMBINATIONS-NOS'
             2382 'J01116 INTRAVENOUS NUTRITIONAL PRODUCTS-NOS'
             2383 'J01118 ANTIHISTAMINES-NOS' 2384 'J01119 ANTITUSSIVES-NOS'
             2385 'J01120 BRONCHODILATORS-NOS'
             2386 'J01122 DECONGESTANTS-NOS' 2387 'J01123 EXPECTORANTS-NOS'
             2388 'J01124 RESPIRATORY AGENTS-NOS'
             2389 'J01125 RESPIRATORY INHALANT PRODUCTS-NOS'
             2390 'J01126 ANTIASTHMATIC COMBINATIONS-NOS'
             2391 'J01127 UPPER RESPIRATORY COMBINATIONS-NOS'
             2392 'J01129 ANORECTAL PREPARATIONS-NOS'
             2393 'J01130 ANTISEPTIC AND GERMICIDES-NOS'
             2394 'J01131 DERMATOLOGICAL AGENTS-NOS'
             2395 'J01134 TOPICAL ANESTHETICS-NOS'
             2396 'J01139 MOUTH AND THROAT PRODUCTS-NOS'
             2397 'J01143 STERILE IRRIGATING SOLUTIONS-NOS'
             2398 'J01145 PLASMA EXPANDERS-NOS'
             2399 'J01165 HMG-COA REDUCTASE INHIBITORS-NOS'
             2400 'J01170 MUSCLE RELAXANTS-NOS'
             2401 'J01174 ANDROGENS AND ANABOLIC STEROIDS-NOS'
             2402 'J01180 NARCOTIC ANALGESIC COMBINATIONS-NOS'
             2403 'J01181 ANTIRHEUMATICS-NOS'
             2404 'J01182 ANTIMIGRAINE AGENTS-NOS'
             2405 'J01183 ANTIGOUT AGENTS-NOS'
             2406 'J01206 BISPHOSPHONATES-NOS'
             2407 'J01208 NUTRACEUTICAL PRODUCTS-NOS'
             2408 'J01209 HERBAL PRODUCTS-NOS'
             2409 'J01229 FIBRIC ACID DERIVATIVES-NOS'
             2410 'J01231 LEUKOTRIENE MODIFIERS-NOS'
             2411 'J01235 NASAL PREPARATIONS-NOS'
             2412 'J01237 ANTIDEPRESSANTS-NOS' 2413 'J01241 ANOREXIANTS-NOS'
             2414 'J01243 INTERFERONS-NOS'
             2415 'J01244 MONOCLONAL ANTIBODIES-NOS'
             2416 'J01247 IMPOTENCE AGENTS-NOS'
             2417 'J01253 VAGINAL PREPARATIONS-NOS'
             2418 'J01254 ANTIPSORIATICS-NOS'
             2419 'J01256 PROTON PUMP INHIBITORS-NOS'
             2420 'J01261 DRUG UNKNOWN' 2421 'J01262 GAMMA HYDROXY BUTYRATE'
             2422 'J01271 PASSION FLOWER' 2423 'J01276 METHAPHENILENE'
             2424 'J01292 CODEINE COMBINATION-NOS'
             2425 'J01294 HALLUCINOGEN-NOS' 2426 'J01295 POLY-DRUGS'
             2427 'J01298 ANTINEOPLASTICS-NOS'
             2428 'J01300 ANTIBIOTICS/ANTINEOPLASTICS-NOS'
             2429 'J01301 HORMONES/ANTINEOPLASTICS-NOS'
             2430 'J01302 DIURETICS-NOS'
             2431 'J01303 ANTIEMETIC/ANTIVERTIGO AGENTS-NOS'
             2432 'J01305 VITAMINS-NOS'
             2433 'J01306 OPHTHALMIC PREPARATIONS-NOS'
             2434 'J01307 OTIC PREPARATIONS-NOS'
             2435 'J01308 ANALGESIC COMBINATIONS-NOS'
             2436 'J01309 COX-2 INHIBITOR-NOS'
             2437 'J01310 SSRI ANTIDEPRESSANTS-NOS'
             2438 'J01311 TRICYCLIC ANTIDEPRESSANTS-NOS'
             2439 'J01312 MONOAMINE OXIDASE INHIBITORS-NOS'
             2440 'J01313 PSYCHOTHERAPEUTIC COMBINATIONS-NOS'
             2441 'J01314 PHENOTHIAZINE ANTIPSYCHOTICS-NOS'
             2442 'J01315 ISOSORBIDE-NOS' 2443 'J01316 IMMUNIZATION-NOS'
             2444 'J01317 PHENCYCLIDINE COMBINATIONS-NOS'
             2445 'J01318 PNEUMOCOCCAL VACCINE' 2446 'J01319 FOLATE'
             2447 'J01320 PENTOBARBITAL/PHENYTOIN'
             2448 'J01322 BARBITAL SODIUM' 2449 'J01323 GADOLINIUM'
             2450 'J01324 HEPATITIS A VACCINE INACTIVATED' 2451 'J01327 ZINC'
             2452 'J01328 4-BROMO-2,5-DIMETHOXYPHENETHYLAMINE'
             2453 'J01329 2,5-DIMETHOXY-4-IODOPHENETHYLAMINE'
             2454 'J01330 AMPHETAMINE/COCAINE'
             2455 'J01331 METHANDROSTENLONE' 2456 'J01332 MARIJUANA/OPIUM'
             2457 'J01333 ALPROSTADIL/PAPAVERINE/PHENTOLAMINE'
             2458 'J01334 CYANIDE/HEROIN/STRYCHNINE'
             2459 'J01338 HYDROXYCODEINONE'
             2460 'J01340 2,5-DIMETHOXY-4-ETHYL-PHENETHYLAMINE'
             2461 'J01341 2,5-DIMETHOXY-4-(N)-PROPYLTHIOPHENETHYLAMINE'
             2462 'J01342 ANTI-RETROVIRAL AGENTS-NOS' 2463 'J01343 AROPLATIN'
             2464 'J01344 IDRAPARINUX'
             2465 'J01345 COCAINE/LYSERGIC ACID DIETHYLAMIDE'
             2466 'J01346 SALVIA DIVINORUM' 2467 'J01348 TIPIFARNIB'
             2468 'J01350 FLUOROURACIL-LEUCOVORIN'
             2469 'J01353 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE'
             2470 'J01354 CARPROFEN'
             2471 'J01355 RIFAMPIN/ISONIAZID/PYRAZINAMIDE/ETHAMBUTOL'
             2472 'J01356 THALLIUM' 2473 'J01357 POLYMYXIN B OTIC'
             2474 'J01358 ALLANTOIN/PRAMOXINE'
             2475 'J01359 COCAINE/MARIJUANA/FORMALDEHYDE'
             2476 'J01360 COCAINE/OPIUM'
            2477 'J01361 CYCLOPHOSPHAMIDE/DOXORUBICIN/VINCRISTINE/PREDNISONE'
             2478 'J01362 DIPHTHERIA/PERTUSISIS/POLIO/HAEMOPHILUS/TETANUS'
             2479 'J01363 ETORICOXIB' 2480 'J01365 FLUPENTHIXOL'
             2481 'J01366 FUSIDIC ACID' 2482 'J01367 HEROIN/METHAMPHETAMINE'
             2483 'J01368 IODINE CONTRAST AGENT'
             2484 'J01369 MARIJUANA/LYSERGIC ACID DIETHYLAMIDE'
             2485 'J01370 METHYLENEDIOXYMETHAMPHETAMINE/PSILOCYBIN'
             2486 'J01371 NEOMYCIN-POLYMYXIN B SULFATE OTIC'
             2487 'J01372 OXALIPLATIN/FLUOROURACIL/LEUCOVORIN'
             2488 'J01373 PHOSPHORUS'
             2489 'J01375 ADRENERGIC BRONCHODILATORS-NOS'
             2490 'J01379 OMEGA-6 POLYUNSATURATED FATTY ACIDS'
             2491 'J01380 TOPICAL ANTIFUNGALS-NOS'
             2492 'J01382 DEXTROMETHORPHAN COMBINATIONS-NOS'
             2493 'J01383 CLENBUTEROL' 2494 'J01386 FENTANYL/HEROIN'
             2495 'J01387 SULFONYLUREAS-NOS'
             2496 'J01388 COCAINE/FORMALDEHYDE'
             2497 'J01389 COCAINE/METHYLENEDIOXYMETHAMPHETAMINE'
             2498 'J01390 CYPROTEREONE ACETATE-ETHINYL ESTRADIOL'
             2499 'J01391 FAT DISSOLVING AGENTS-NOS'
             2500 'J01392 HEROIN/METHYLENEDIOXYMETHAMPHETAMINE'
             2501 'J01393 PROPOLIS' 2502 'J01394 SENNA COMBINATIONS-NOS'
             2503 'J01395 FENFLURAMINE/PHENTERMINE'
             2504 'J01396 ACNE AGENTS-NOS' 2505 'J01401 CLONIXIN'
             2506 'J01404 PROGESTINS-NOS' 2507 'J01405 RABIES VACCINE-NOS'
             2508 'J01411 INFLUENZA VIRUS VACCINE, H1N1-NOS'
             2509 'J01412 ACAI BERRY' 2510 'J01413 ALUM'
             2511 'J01414 AMMONIA' 2512 'J01415 BENZYLPIPERAZINE'
             2513 'J01416 BLUE GREEN ALGAE'
  2514 'J01417 CYCLOPHOSPHAMIDE/DOXORUBICIN/RITUXIMAB/VINCRISTINE/PREDNISONE'
             2515 'J01418 HOODIA' 2516 'J01419 HYALURONIC ACID'
             2517 'J01420 PAPAVERINE/PHENTOLAMINE' 2518 'J01421 STATIN-NOS'
             2519 'J01422 TEA TREE OIL'
             2520 'J01423 TRIFLUOROMETHYLPHENYLPIPERAZINE'
             2521 'J01424 4-METHYLMETHCATHINONE' 2522 'J01426 PHENAZEPAM'
             2523 'J01427 4-BROMO-3,6-DIMETHOXYBENZOCYCLOBUTEN'
             2524 'J01428 SYNTHETIC CANNABINOID' 2525 'J01429 AFATINIB'
             2526 'J01430 AMPHETAMINE/MARIJUANA' 2527 'J01431 AXITINIB'
             2528 'J01432 BLEOMYCIN/DACARBAZINE/DOXORUBICIN/VINBLASTINE'
             2529 'J01433 CAFFEINE COMBINATIONS-NOS'
             2530 'J01434 CAPECITABINE/OXALIPLATIN'
             2531 'J01435 COLLOIDAL SILVER'
             2532 'J01436 DOCETAXEL/FLUOROURACIL/OXALIPLATIN'
             2533 'J01437 DOMPERIDONE'
             2534 'J01438 FLUOROURACIL/IRINOTECAN/LEUCOVORIN'
             2535 'J01439 IFOSFAMIDE/CARBOPLATIN/ETOPOSIDE/RITUXIMAB'
             2536 'J01440 KETAMINE/MARIJUANA'
             2537 'J01441 L-TRYPTOPHAN/MELATONIN'
             2538 'J01442 MARIJUANA/OXYCODONE' 2539 'J01443 METAMIZOLE'
             2540 'J01444 3,4-METHYLENEDIOXYPYROVALERONE'
             2541 'J01445 PANOBINOSTAT' 2542 'J01446 PROBIOTICS-NOS'
             2543 'J01447 SPERMICIDES-NOS' 2544 'J01448 TILMICOSIN'
             2545 'J01449 AMPHETAMINES-NOS'
             2546 'J01450 ILLICIT COMBINATIONS-NOS' 2547 'J01451 VITAMIN D'
             2548 'J01454 TRENBOLONE'
             2549 'J01455 H. PYLORI ERADICATION AGENTS-NOS'
             2550 'J01456 SMOKING CESSATION AGENTS-NOS'
             2551 'J01457 4-BROMO-2,5-DIMETHOXYAMPHETAMINE'
             2552 'J01458 PROTEASE INHIBITORS-NOS'
             2553 'J01459 4-METHOXYMETHCATHINONE' 2554 'J01460 ELASTIN'
             2555 'J01461 TALCUM POWDER TOPICAL'
             2556 'J01462 METHYLENEDIOXYMETHAMPHETAMINE/CAFFEINE'
             2557 'J01463 ENERGY DRINK'
             2558 'J01464 CAFFEINE/MULTIVITAMIN NTA' /
   CATID_1_6 -7 'NOT APPLICABLE:(-7)' 1 'ANTI-INFECTIVES:(1)'
             20 'ANTINEOPLASTICS:(20)' 28 'BIOLOGICALS:(28)'
             40 'CARDIOVASCULAR AGENTS:(40)'
             57 'CENTRAL NERVOUS SYSTEM AGENTS:(57)'
             81 'COAGULATION MODIFIERS:(81)'
             87 'GASTROINTESTINAL AGENTS:(87)'
             97 'HORMONES/HORMONE MODIFIERS:(97)'
             105 'MISCELLANEOUS AGENTS:(105)'
             113 'GENITOURINARY TRACT AGENTS:(113)'
             115 'NUTRITIONAL PRODUCTS:(115)' 122 'RESPIRATORY AGENTS:(122)'
             133 'TOPICAL AGENTS:(133)' 153 'PLASMA EXPANDERS:(153)'
             218 'ALTERNATIVE MEDICINES:(218)'
             242 'PSYCHOTHERAPEUTIC AGENTS:(242)'
             254 'IMMUNOLOGIC AGENTS:(254)' 331 'RADIOLOGIC AGENTS:(331)'
             358 'METABOLIC AGENTS:(358)' 365 'MEDICAL GAS:(365)'
             2006 'DRUG UNKNOWN:(2006)' 2041 'NON-PHARMACEUTICAL:(2041)' /
   CATID_2_6 -7 'NOT APPLICABLE:(-7)' 2 'AMEBICIDES:(2)'
             3 'ANTHELMINTICS:(3)' 4 'ANTIFUNGALS:(4)'
             5 'ANTIMALARIAL AGENTS:(5)' 6 'ANTITUBERCULOSIS AGENTS:(6)'
             7 'ANTIVIRAL AGENTS:(7)' 8 'CARBAPENEMS:(8)'
             9 'CEPHALOSPORINS:(9)' 10 'LEPROSTATICS:(10)'
             11 'MACROLIDE DERIVATIVES:(11)'
             12 'MISCELLANEOUS ANTIBIOTICS:(12)' 13 'PENICILLINS:(13)'
             14 'QUINOLONES:(14)' 15 'SULFONAMIDES:(15)'
             16 'TETRACYCLINES:(16)' 17 'URINARY ANTI-INFECTIVES:(17)'
             18 'AMINOGLYCOSIDES:(18)' 19 'ANTIHYPERLIPIDEMIC AGENTS:(19)'
             21 'ALKYLATING AGENTS:(21)' 22 'ANTINEOPLASTIC ANTIBIOTICS:(22)'
             23 'ANTIMETABOLITES:(23)' 24 'ANTINEOPLASTIC HORMONES:(24)'
             25 'MISCELLANEOUS ANTINEOPLASTICS:(25)'
             26 'MITOTIC INHIBITORS:(26)' 27 'RADIOPHARMACEUTICALS:(27)'
             30 'ANTITOXINS AND ANTIVENINS:(30)' 33 'IMMUNE GLOBULINS:(33)'
             34 'IN VIVO DIAGNOSTIC BIOLOGICALS:(34)'
             36 'RECOMBINANT HUMAN ERYTHROPOIETINS:(36)'
             41 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(41)'
             42 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(42)'
             43 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(43)'
             44 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(44)'
             45 'ANTIANGINAL AGENTS:(45)' 46 'ANTIARRHYTHMIC AGENTS:(46)'
             47 'BETA-ADRENERGIC BLOCKING AGENTS:(47)'
             48 'CALCIUM CHANNEL BLOCKING AGENTS:(48)' 49 'DIURETICS:(49)'
             50 'INOTROPIC AGENTS:(50)'
             51 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(51)'
             52 'PERIPHERAL VASODILATORS:(52)' 53 'VASODILATORS:(53)'
             54 'VASOPRESSORS:(54)' 55 'ANTIHYPERTENSIVE COMBINATIONS:(55)'
             56 'ANGIOTENSIN II INHIBITORS:(56)' 58 'ANALGESICS:(58)'
             64 'ANTICONVULSANTS:(64)'
             65 'ANTIEMETIC/ANTIVERTIGO AGENTS:(65)'
             66 'ANTIPARKINSON AGENTS:(66)'
             67 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(67)'
             71 'CNS STIMULANTS:(71)' 72 'GENERAL ANESTHETICS:(72)'
             73 'MUSCLE RELAXANTS:(73)'
             80 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(80)'
             82 'ANTICOAGULANTS:(82)' 83 'ANTIPLATELET AGENTS:(83)'
             84 'HEPARIN ANTAGONISTS:(84)'
             85 'MISCELLANEOUS COAGULATION MODIFIERS:(85)'
             86 'THROMBOLYTICS:(86)' 88 'ANTACIDS:(88)'
             90 'ANTIDIARRHEALS:(90)' 91 'DIGESTIVE ENZYMES:(91)'
             92 'GALLSTONE SOLUBILIZING AGENTS:(92)' 93 'GI STIMULANTS:(93)'
             94 'H2 ANTAGONISTS:(94)' 95 'LAXATIVES:(95)'
             96 'MISCELLANEOUS GI AGENTS:(96)'
             98 'ADRENAL CORTICAL STEROIDS:(98)'
             99 'ANTIDIABETIC AGENTS:(99)' 100 'MISCELLANEOUS HORMONES:(100)'
             101 'SEX HORMONES:(101)' 103 'THYROID HORMONES:(103)'
             104 'IMMUNOSUPPRESSIVE AGENTS:(104)' 106 'ANTIDOTES:(106)'
             107 'CHELATING AGENTS:(107)'
             108 'CHOLINERGIC MUSCLE STIMULANTS:(108)'
             109 'LOCAL INJECTABLE ANESTHETICS:(109)'
             110 'MISCELLANEOUS UNCATEGORIZED AGENTS:(110)'
             111 'PSORALENS:(111)' 112 'RADIOCONTRAST AGENTS:(112)'
             114 'ILLICIT (STREET) DRUGS:(114)' 116 'IRON PRODUCTS:(116)'
             117 'MINERALS AND ELECTROLYTES:(117)'
             118 'ORAL NUTRITIONAL SUPPLEMENTS:(118)' 119 'VITAMINS:(119)'
             120 'VITAMIN AND MINERAL COMBINATIONS:(120)'
             121 'INTRAVENOUS NUTRITIONAL PRODUCTS:(121)'
             123 'ANTIHISTAMINES:(123)' 124 'ANTITUSSIVES:(124)'
             125 'BRONCHODILATORS:(125)' 127 'DECONGESTANTS:(127)'
             128 'EXPECTORANTS:(128)'
             129 'MISCELLANEOUS RESPIRATORY AGENTS:(129)'
             130 'RESPIRATORY INHALANT PRODUCTS:(130)'
             131 'ANTIASTHMATIC COMBINATIONS:(131)'
             132 'UPPER RESPIRATORY COMBINATIONS:(132)'
             134 'ANORECTAL PREPARATIONS:(134)'
             135 'ANTISEPTIC AND GERMICIDES:(135)'
             136 'DERMATOLOGICAL AGENTS:(136)'
             146 'MOUTH AND THROAT PRODUCTS:(146)'
             147 'OPHTHALMIC PREPARATIONS:(147)'
             148 'OTIC PREPARATIONS:(148)'
             150 'STERILE IRRIGATING SOLUTIONS:(150)'
             151 'VAGINAL PREPARATIONS:(151)' 192 'ANTIRHEUMATICS:(192)'
             194 'ANTIGOUT AGENTS:(194)' 219 'NUTRACEUTICAL PRODUCTS:(219)'
             220 'HERBAL PRODUCTS:(220)' 240 'LINCOMYCIN DERIVATIVES:(240)'
             243 'LEUKOTRIENE MODIFIERS:(243)' 247 'NASAL PREPARATIONS:(247)'
             249 'ANTIDEPRESSANTS:(249)' 251 'ANTIPSYCHOTICS:(251)'
             253 'ANOREXIANTS:(253)' 263 'IMPOTENCE AGENTS:(263)'
             264 'URINARY ANTISPASMODICS:(264)'
             265 'URINARY PH MODIFIERS:(265)'
             266 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(266)'
             270 'ANTIPSORIATICS:(270)' 272 'PROTON PUMP INHIBITORS:(272)'
             273 'LUNG SURFACTANTS:(273)' 277 '5-AMINOSALICYLATES:(277)'
             284 'VISCOSUPPLEMENTATION AGENTS:(284)'
             288 '5-ALPHA-REDUCTASE INHIBITORS:(288)'
             289 'ANTIHYPERURICEMIC AGENTS:(289)'
             293 'GLUCOSE ELEVATING AGENTS:(293)' 295 'GROWTH HORMONES:(295)'
             303 'AGENTS FOR PULMONARY HYPERTENSION:(303)'
             312 'CHOLINERGIC AGONISTS:(312)'
             313 'CHOLINESTERASE INHIBITORS:(313)' 315 'GLYCYLCYCLINES:(315)'
             318 'INSULIN-LIKE GROWTH FACTOR:(318)'
             319 'VASOPRESSIN ANTAGONISTS:(319)'
             320 'SMOKING CESSATION AGENTS:(320)'
             324 'ANTINEOPLASTIC INTERFERONS:(324)'
             325 'SCLEROSING AGENTS:(325)' 332 'RADIOLOGIC ADJUNCTS:(332)'
             340 'ALDOSTERONE RECEPTOR ANTAGONISTS:(340)'
             342 'RENIN INHIBITORS:(342)'
             354 'H. PYLORI ERADICATION AGENTS:(354)'
             355 'FUNCTIONAL BOWEL DISORDER AGENTS:(355)'
             357 'GROWTH HORMONE RECEPTOR BLOCKERS:(357)'
             359 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(359)'
             360 'LYSOSOMAL ENZYMES:(360)'
             361 'MISCELLANEOUS METABOLIC AGENTS:(361)'
             363 'PROBIOTICS:(363)' 377 'PROLACTIN INHIBITORS:(377)'
             378 'DRUGS USED IN ALCOHOL DEPENDENCE:(378)'
             383 'ANTINEOPLASTIC DETOXIFYING AGENTS:(383)'
             384 'PLATELET-STIMULATING AGENTS:(384)'
             390 'HEMATOPOIETIC STEM CELL MOBILIZER:(390)'
             397 'MULTIKINASE INHIBITORS:(397)'
             398 'BCR-ABL TYROSINE KINASE INHIBITORS:(398)'
             399 'CD52 MONOCLONAL ANTIBODIES:(399)'
             400 'CD33 MONOCLONAL ANTIBODIES:(400)'
             401 'CD20 MONOCLONAL ANTIBODIES:(401)'
             402 'VEGF/VEGFR INHIBITORS:(402)' 403 'MTOR INHIBITORS:(403)'
             404 'EGFR INHIBITORS:(404)' 405 'HER2 INHIBITORS:(405)'
             406 'GLYCOPEPTIDE ANTIBIOTICS:(406)'
             408 'HISTONE DEACETYLASE INHIBITORS:(408)'
             409 'BONE RESORPTION INHIBITORS:(409)'
             410 'ADRENAL CORTICOSTEROID INHIBITORS:(410)'
             411 'CALCITONIN:(411)' 412 'UTEROTONIC AGENTS:(412)'
             413 'ANTIGONADOTROPIC AGENTS:(413)'
             414 'ANTIDIURETIC HORMONES:(414)'
             416 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(416)'
             417 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(417)'
             418 'PARATHYROID HORMONE AND ANALOGS:(418)'
             419 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(419)'
             422 'ANTITHYROID AGENTS:(422)'
             426 'SYNTHETIC OVULATION STIMULANTS:(426)'
             427 'TOCOLYTIC AGENTS:(427)'
             428 'PROGESTERONE RECEPTOR MODULATORS:(428)'
             431 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(431)'
             433 'CATECHOLAMINES:(433)'
             435 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(435)'
             437 'IMMUNOSTIMULANTS:(437)'
             447 'CD30 MONOCLONAL ANTIBODIES:(447)' 2042 'INHALANT:(2042)'
             2051 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(2051)' /
   CATID_3_6 -7 'NOT APPLICABLE:(-7)' 31 'BACTERIAL VACCINES:(31)'
             32 'COLONY STIMULATING FACTORS:(32)' 38 'VIRAL VACCINES:(38)'
             61 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(61)'
             68 'BARBITURATES:(68)' 69 'BENZODIAZEPINES:(69)'
             70 'MISCELLANEOUS ANXIOLYTICS, SEDATIVES AND HYPNOTICS:(70)'
             74 'NEUROMUSCULAR BLOCKING AGENTS:(74)'
             76 'MISCELLANEOUS ANTIDEPRESSANTS:(76)'
             77 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(77)'
             79 'PSYCHOTHERAPEUTIC COMBINATIONS:(79)'
             89 'ANTICHOLINERGICS/ANTISPASMODICS:(89)'
             102 'CONTRACEPTIVES:(102)' 126 'METHYLXANTHINES:(126)'
             137 'TOPICAL ANTI-INFECTIVES:(137)' 138 'TOPICAL STEROIDS:(138)'
             139 'TOPICAL ANESTHETICS:(139)'
             140 'MISCELLANEOUS TOPICAL AGENTS:(140)'
             141 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(141)'
             143 'TOPICAL ACNE AGENTS:(143)'
             144 'TOPICAL ANTIPSORIATICS:(144)' 149 'SPERMICIDES:(149)'
             154 'LOOP DIURETICS:(154)'
             155 'POTASSIUM-SPARING DIURETICS:(155)'
             156 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(156)'
             157 'CARBONIC ANHYDRASE INHIBITORS:(157)'
             158 'MISCELLANEOUS DIURETICS:(158)'
             159 'FIRST GENERATION CEPHALOSPORINS:(159)'
             160 'SECOND GENERATION CEPHALOSPORINS:(160)'
             161 'THIRD GENERATION CEPHALOSPORINS:(161)'
             162 'FOURTH GENERATION CEPHALOSPORINS:(162)'
             163 'OPHTHALMIC ANTI-INFECTIVES:(163)'
             164 'OPHTHALMIC GLAUCOMA AGENTS:(164)'
             165 'OPHTHALMIC STEROIDS:(165)'
             166 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(166)'
             167 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(167)'
             168 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(168)'
             169 'MISCELLANEOUS OPHTHALMIC AGENTS:(169)'
             170 'OTIC ANTI-INFECTIVES:(170)'
             171 'OTIC STEROIDS WITH ANTI-INFECTIVES:(171)'
             172 'MISCELLANEOUS OTIC AGENTS:(172)'
             173 'HMG-COA REDUCTASE INHIBITORS:(173)'
             174 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(174)'
             175 'PROTEASE INHIBITORS:(175)' 176 'NRTIS:(176)'
             177 'MISCELLANEOUS ANTIVIRALS:(177)'
             178 'SKELETAL MUSCLE RELAXANTS:(178)'
             179 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(179)'
             180 'ADRENERGIC BRONCHODILATORS:(180)'
             181 'BRONCHODILATOR COMBINATIONS:(181)'
             182 'ANDROGENS AND ANABOLIC STEROIDS:(182)'
             183 'ESTROGENS:(183)' 184 'GONADOTROPINS:(184)'
             185 'PROGESTINS:(185)' 186 'SEX HORMONE COMBINATIONS:(186)'
             187 'MISCELLANEOUS SEX HORMONES:(187)'
             193 'ANTIMIGRAINE AGENTS:(193)'
             195 '5HT3 RECEPTOR ANTAGONISTS:(195)'
             196 'PHENOTHIAZINE ANTIEMETICS:(196)'
             197 'ANTICHOLINERGIC ANTIEMETICS:(197)'
             198 'MISCELLANEOUS ANTIEMETICS:(198)'
             199 'HYDANTOIN ANTICONVULSANTS:(199)'
             200 'SUCCINIMIDE ANTICONVULSANTS:(200)'
             201 'BARBITURATE ANTICONVULSANTS:(201)'
             202 'OXAZOLIDINEDIONE ANTICONVULSANTS:(202)'
             203 'BENZODIAZEPINE ANTICONVULSANTS:(203)'
             204 'MISCELLANEOUS ANTICONVULSANTS:(204)'
             205 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(205)'
             206 'MISCELLANEOUS ANTIPARKINSON AGENTS:(206)'
             208 'SSRI ANTIDEPRESSANTS:(208)'
             209 'TRICYCLIC ANTIDEPRESSANTS:(209)'
             210 'PHENOTHIAZINE ANTIPSYCHOTICS:(210)'
             211 'PLATELET AGGREGATION INHIBITORS:(211)'
             212 'GLYCOPROTEIN PLATELET INHIBITORS:(212)'
             213 'SULFONYLUREAS:(213)' 214 'BIGUANIDES:(214)'
             215 'INSULIN:(215)' 216 'ALPHA-GLUCOSIDASE INHIBITORS:(216)'
             217 'BISPHOSPHONATES:(217)'
             222 'PENICILLINASE RESISTANT PENICILLINS:(222)'
             223 'ANTIPSEUDOMONAL PENICILLINS:(223)'
             224 'AMINOPENICILLINS:(224)'
             225 'BETA-LACTAMASE INHIBITORS:(225)'
             226 'NATURAL PENICILLINS:(226)' 227 'NNRTIS:(227)'
             228 'ADAMANTANE ANTIVIRALS:(228)' 229 'PURINE NUCLEOSIDES:(229)'
             230 'AMINOSALICYLATES:(230)'
             231 'NICOTINIC ACID DERIVATIVES:(231)'
             232 'RIFAMYCIN DERIVATIVES:(232)'
             233 'STREPTOMYCES DERIVATIVES:(233)'
             234 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(234)'
             235 'POLYENES:(235)' 236 'AZOLE ANTIFUNGALS:(236)'
             237 'MISCELLANEOUS ANTIFUNGALS:(237)'
             238 'ANTIMALARIAL QUINOLINES:(238)'
             239 'MISCELLANEOUS ANTIMALARIALS:(239)'
             241 'FIBRIC ACID DERIVATIVES:(241)'
             244 'NASAL LUBRICANTS AND IRRIGATIONS:(244)'
             245 'NASAL STEROIDS:(245)'
             246 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(246)'
             248 'TOPICAL EMOLLIENTS:(248)'
             250 'MONOAMINE OXIDASE INHIBITORS:(250)'
             252 'BILE ACID SEQUESTRANTS:(252)' 256 'INTERFERONS:(256)'
             261 'HEPARINS:(261)' 262 'COUMARINS AND INDANEDIONES:(262)'
             267 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(267)'
             268 'VAGINAL ANTI-INFECTIVES:(268)'
             269 'MISCELLANEOUS VAGINAL AGENTS:(269)'
             271 'THIAZOLIDINEDIONES:(271)'
             274 'CARDIOSELECTIVE BETA BLOCKERS:(274)'
             275 'NON-CARDIOSELECTIVE BETA BLOCKERS:(275)'
             276 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(276)'
             278 'COX-2 INHIBITORS:(278)'
             279 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(279)'
             280 'THIOXANTHENES:(280)' 281 'NEURAMINIDASE INHIBITORS:(281)'
             282 'MEGLITINIDES:(282)' 283 'THROMBIN INHIBITORS:(283)'
             285 'FACTOR XA INHIBITORS:(285)' 286 'MYDRIATICS:(286)'
             287 'OPHTHALMIC ANESTHETICS:(287)'
             290 'TOPICAL ANTIBIOTICS:(290)' 291 'TOPICAL ANTIVIRALS:(291)'
             292 'TOPICAL ANTIFUNGALS:(292)'
             296 'INHALED CORTICOSTEROIDS:(296)' 297 'MUCOLYTICS:(297)'
             298 'MAST CELL STABILIZERS:(298)'
             299 'ANTICHOLINERGIC BRONCHODILATORS:(299)'
             300 'CORTICOTROPIN:(300)' 301 'GLUCOCORTICOIDS:(301)'
             302 'MINERALOCORTICOIDS:(302)' 304 'MACROLIDES:(304)'
             305 'KETOLIDES:(305)'
             306 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(306)'
             307 'TETRACYCLIC ANTIDEPRESSANTS:(307)'
             308 'SSNRI ANTIDEPRESSANTS:(308)'
             309 'MISCELLANEOUS ANTIDIABETIC AGENTS:(309)'
             310 'ECHINOCANDINS:(310)'
             311 'DIBENZAZEPINE ANTICONVULSANTS:(311)'
             314 'ANTIDIABETIC COMBINATIONS:(314)'
             316 'CHOLESTEROL ABSORPTION INHIBITORS:(316)'
             317 'ANTIHYPERLIPIDEMIC COMBINATIONS:(317)'
             321 'OPHTHALMIC DIAGNOSTIC AGENTS:(321)'
             322 'OPHTHALMIC SURGICAL AGENTS:(322)'
             327 'ANTIVIRAL COMBINATIONS:(327)'
             328 'ANTIMALARIAL COMBINATIONS:(328)'
             329 'ANTITUBERCULOSIS COMBINATIONS:(329)'
             330 'ANTIVIRAL INTERFERONS:(330)'
             333 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(333)'
             334 'LYMPHATIC STAINING AGENTS:(334)'
             335 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(335)'
             336 'NON-IODINATED CONTRAST MEDIA:(336)'
             337 'ULTRASOUND CONTRAST MEDIA:(337)'
             338 'DIAGNOSTIC RADIOPHARMACEUTICALS:(338)'
             339 'THERAPEUTIC RADIOPHARMACEUTICALS:(339)'
             341 'ATYPICAL ANTIPSYCHOTICS:(341)'
             345 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(345)'
             346 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(346)'
             347 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(347)'
             348 'TRIAZINE ANTICONVULSANTS:(348)'
             349 'CARBAMATE ANTICONVULSANTS:(349)'
             350 'PYRROLIDINE ANTICONVULSANTS:(350)'
             351 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(351)'
             352 'UREA ANTICONVULSANTS:(352)'
             353 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(353)'
             356 'SEROTONINERGIC NEUROENTERIC MODULATORS:(356)'
             362 'CHLORIDE CHANNEL ACTIVATORS:(362)'
             364 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(364)'
             366 'INTEGRASE STRAND TRANSFER INHIBITOR:(366)'
             368 'NON-IONIC IODINATED CONTRAST MEDIA:(368)'
             369 'IONIC IODINATED CONTRAST MEDIA:(369)'
             370 'OTIC STEROIDS:(370)'
             371 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(371)'
             372 'AMYLIN ANALOGS:(372)' 373 'INCRETIN MIMETICS:(373)'
             374 'CARDIAC STRESSING AGENTS:(374)'
             375 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(375)'
             379 'FIFTH GENERATION CEPHALOSPORINS:(379)'
             380 'TOPICAL DEBRIDING AGENTS:(380)'
             381 'TOPICAL DEPIGMENTING AGENTS:(381)'
             382 'TOPICAL ANTIHISTAMINES:(382)'
             385 'GROUP I ANTIARRHYTHMICS:(385)'
             387 'GROUP III ANTIARRHYTHMICS:(387)'
             389 'GROUP V ANTIARRHYTHMICS:(389)' 392 'OTIC ANESTHETICS:(392)'
             393 'CERUMENOLYTICS:(393)' 394 'TOPICAL ASTRINGENTS:(394)'
             395 'TOPICAL KERATOLYTICS:(395)'
             415 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(415)'
             432 'VACCINE COMBINATIONS:(432)'
             439 'OTHER IMMUNOSTIMULANTS:(439)'
             440 'THERAPEUTIC VACCINES:(440)'
             441 'CALCINEURIN INHIBITORS:(441)'
             442 'TNF ALFA INHIBITORS:(442)'
             443 'INTERLEUKIN INHIBITORS:(443)'
             444 'SELECTIVE IMMUNOSUPPRESSANTS:(444)'
             445 'OTHER IMMUNOSUPPRESSANTS:(445)'
             448 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(448)'
             2005 'ALCOHOL IN COMBINATION:(2005)'
             2007 'MISCELLANEOUS BRONCHODILATORS:(2007)'
             2008 'MISCELLANEOUS NASAL PREPARATIONS:(2008)'
             2030 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(2030)'
             2031 'MISCELLANEOUS HALLUCINOGENS:(2031)'
             2032 'ILLICIT MAJOR SUBSTANCE OF ABUSE:(2032)'
             2033 'ILLICIT COMBINATIONS:(2033)'
             2034 'ILLICIT AND OTHER COMBINATIONS:(2034)'
             2036 'MISCELLANEOUS CEPHALOSPORINS:(2036)'
             2043 'VOLATILE AGENT:(2043)' 2044 'NITRITES:(2044)'
             2045 'CHLORO-FLUORO-HYDROCARBONS:(2045)'
             2046 'MISCELLANEOUS MUSCLE RELAXANTS:(2046)'
             2047 'NARCOTIC ANALGESICS/COMBINATIONS:(2047)'
             2048 'SALICYLATES/COMBINATIONS:(2048)'
             2049 'MISCELLANEOUS ANALGESIC/COMBINATIONS:(2049)'
             2050 'ANALGESIC COMBINATIONS NTA:(2050)'
             2052 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(2052)'
             2053 'MISCELLANEOUS MACROLIDE:(2053)'
             2054 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(2054)'
             2055 'MISCELLANEOUS RADIOCONTRAST AGENTS:(2055)'
             2056 'MISCELLANEOUS RADIOPHARMACEUTICALS:(2056)' /
   ROUTE_6   -9 'MISSING:(-9)' -8 'NOT DOCUMENTED:(-8)'
             -7 'NOT APPLICABLE:(-7)' 1 'ORAL:(1)' 2 'INJECTED:(2)'
             3 'INHALED, SNIFFED, SNORTED:(3)' 4 'SMOKED:(4)' 5 'OTHER:(5)'
             6 'TRANSDERMAL:(6)' 98 'MULTIPLE ROUTES FOR THIS DRUG:(98)' /
   TOXTEST_6 -9 'MISSING:(-9)' -7 'NOT APPLICABLE:(-7)'
             1 'CONFIRMED TEST:(1)' 2 'NOT CONFIRMED:(2)' /
   SDLED_1_6 -7 'NOT APPLICABLE:(-7)' 1 'MAJOR SUBSTANCES OF ABUSE:(1)'
             17 'OTHER SUBSTANCES:(17)' /
   SDLED_2_6 -7 'NOT APPLICABLE:(-7)' 2 'ALCOHOL:(2)'
             2.5 'NON-ALCOHOL ILLICITS:(2.5)'
             18 'PSYCHOTHERAPEUTIC AGENTS:(18)' 33 'CNS AGENTS:(33)'
             50 'RESPIRATORY AGENTS:(50)' 57 'CARDIOVASCULAR AGENTS:(57)'
             63 'ALTERNATIVE MEDICINES:(63)' 64 'ANTI-INFECTIVES:(64)'
             65 'ANTINEOPLASTICS:(65)' 66 'BIOLOGICALS:(66)'
             67 'COAGULATION MODIFIERS:(67)'
             68 'GASTROINTESTINAL AGENTS:(68)'
             69 'GENITOURINARY TRACT AGENTS:(69)' 70 'HORMONES:(70)'
             71 'IMMUNOLOGIC AGENTS:(71)' 72 'MEDICAL GAS:(72)'
             73 'METABOLIC AGENTS:(73)' 74 'MISCELLANEOUS AGENTS:(74)'
             75 'NUTRITIONAL PRODUCTS:(75)' 76 'PLASMA EXPANDERS:(76)'
             77 'RADIOLOGIC AGENTS:(77)' 78 'TOPICAL AGENTS:(78)'
             79 'DRUG UNKNOWN:(79)' /
   SDLED_3_6 -7 'NOT APPLICABLEL:(-7.00)' 3 'COCAINE:(3)' 4 'HEROIN:(4)'
             5 'CANNABINOIDS:(5)' 5.5 'STIMULANTS:(5.5)'
             8 'MDMA (ECSTASY):(8)' 8.1 'GHB:(8.1)'
             8.2 'FLUNITRAZEPAM (ROHYPNOL):(8.2)' 9 'KETAMINE:(9)'
             10 'LSD:(10)' 11 'PCP:(11)'
             12 'MISCELLANEOUS HALLUCINOGENS:(12)' 15 'INHALANTS:(15)'
             16 'COMBINATIONS NTA:(16)' 19 'ANTIDEPRESSANTS:(19)'
             24 'ANTIPSYCHOTICS:(24)' 34 'ANALGESICS:(34)'
             43 'ANOREXIANTS:(43)' 44 'ANTICONVULSANTS:(44)'
             45 'ANTIEMETIC/ANTIVERTIGO AGENTS:(45)'
             46 'ANTIPARKINSON AGENTS:(46)'
             46.3 'ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.3)'
             46.5 'CNS STIMULANTS:(46.5)'
             46.7 'DRUGS USED IN ALCOHOL DEPENDENCE:(46.7)'
             47 'GENERAL ANESTHETICS:(47)' 48 'MUSCLE RELAXANTS:(48)'
             49 'MISCELLANEOUS CNS AGENTS:(49)' 51 'ANTIHISTAMINES:(51)'
             52 'BRONCHODILATORS:(52)' 53 'DECONGESTANTS:(53)'
             54 'EXPECTORANTS:(54)'
             54.5 'SELECTIVE PHOSPHODIESTERASE-4 INHIBITORS:(54.5)'
             55 'UPPER RESPIRATORY COMBINATIONS:(55)'
             56 'RESPIRATORY AGENTS NTA:(56)'
             58 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING:(58)'
             59 'BETA-ADRENERGIC BLOCKING AGENTS:(59)'
             60 'CALCIUM CHANNEL BLOCKING AGENTS:(60)' 61 'DIURETICS:(61)'
             61.3 'RENIN INHIBITORS:(61.3)'
             61.5 'VASOPRESSIN ANTAGONISTS:(61.5)'
             62 'CARDIOVASCULAR AGENTS NTA:(62)'
             63.1 'HERBAL PRODUCTS:(63.1)'
             63.2 'NUTRACEUTICAL PRODUCTS:(63.2)' 63.3 'PROBIOTICS:(63.3)'
             64.01 'AMEBICIDES:(64.01)' 64.02 'AMINOGLYCOSIDES:(64.02)'
             64.03 'ANTHELMINTICS:(64.03)' 64.04 'ANTIFUNGALS:(64.04)'
             64.05 'ANTIMALARIAL AGENTS:(64.05)'
             64.06 'ANTITUBERCULOSIS AGENTS:(64.06)'
             64.07 'ANTIVIRAL AGENTS:(64.07)' 64.08 'CARBAPENEMS:(64.08)'
             64.09 'CEPHALOSPORINS:(64.09)'
             64.1 'GLYCOPEPTIDE ANTIBIOTICS:(64.1)'
             64.11 'GLYCYLCYCLINES:(64.11)' 64.12 'LEPROSTATICS:(64.12)'
             64.13 'LINCOMYCIN DERIVATIVES:(64.13)'
             64.14 'MACROLIDE DERIVATIVES:(64.14)'
             64.15 'PENICILLINS:(64.15)' 64.16 'QUINOLONES:(64.16)'
             64.17 'SULFONAMIDES:(64.17)' 64.18 'TETRACYCLINES:(64.18)'
             64.19 'URINARY ANTI-INFECTIVES:(64.19)'
             64.99 'MISCELLANEOUS ANTIBIOTICS:(64.99)'
             65.01 'ALKYLATING AGENTS:(65.01)'
             65.02 'ANTI-CTLA-4 MONOCLONAL ANTIBODIES:(65.02)'
             65.03 'ANTIMETABOLITES:(65.03)'
             65.04 'ANTINEOPLASTIC ANTIBIOTICS:(65.04)'
             65.05 'ANTINEOPLASTIC DETOXIFYING AGENTS:(65.05)'
             65.06 'ANTINEOPLASTIC HORMONES:(65.06)'
             65.07 'ANTINEOPLASTIC INTERFERONS:(65.07)'
             65.08 'BCR-ABL TYROSINE KINASE INHIBITORS:(65.08)'
             65.09 'CD20 MONOCLONAL ANTIBODIES:(65.09)'
             65.11 'CD33 MONOCLONAL ANTIBODIES:(65.11)'
             65.12 'CD52 MONOCLONAL ANTIBODIES:(65.12)'
             65.13 'EGFR INHIBITORS:(65.13)' 65.14 'HER2 INHIBITORS:(65.14)'
             65.15 'HISTONE DEACETYLASE INHIBITORS:(65.15)'
             65.16 'MITOTIC INHIBITORS:(65.16)'
             65.17 'MTOR INHIBITORS:(65.17)'
             65.18 'MULTIKINASE INHIBITORS:(65.18)'
             65.2 'VEGF/VEGFR INHIBITORS:(65.2)'
             65.99 'MISCELLANEOUS ANTINEOPLASTICS:(65.99)'
             66.01 'ANTITOXINS AND ANTIVENINS:(66.01)'
             66.04 'IN VIVO DIAGNOSTIC BIOLOGICALS:(66.04)'
             66.05 'RECOMBINANT HUMAN ERYTHROPOIETINS:(66.05)'
             67.01 'ANTICOAGULANTS:(67.01)'
             67.02 'ANTIPLATELET AGENTS:(67.02)'
             67.03 'HEPARIN ANTAGONISTS:(67.03)'
             67.04 'PLATELET-STIMULATING AGENTS:(67.04)'
             67.05 'THROMBOLYTICS:(67.05)'
             67.06 'MISCELLANEOUS COAGULATION MODIFIERS:(67.06)'
             68.01 '5-AMINOSALICYLATES:(68.01)' 68.02 'ANTACIDS:(68.02)'
             68.04 'ANTIDIARRHEALS:(68.04)' 68.05 'DIGESTIVE ENZYMES:(68.05)'
             68.06 'FUNCTIONAL BOWEL DISORDER AGENTS:(68.06)'
             68.07 'GALLSTONE SOLUBILIZING AGENTS:(68.07)'
             68.08 'GI STIMULANTS:(68.08)'
             68.09 'H. PYLORI ERADICATION AGENTS:(68.09)'
             68.1 'H2 ANTAGONISTS:(68.1)' 68.11 'LAXATIVES:(68.11)'
             68.12 'PROTON PUMP INHIBITORS:(68.12)'
             68.13 'MISCELLANEOUS GI AGENTS:(68.13)'
             69.01 'IMPOTENCE AGENTS:(69.01)'
             69.02 'TOCOLYTIC AGENTS:(69.02)'
             69.03 'URINARY ANTISPASMODICS:(69.03)'
             69.04 'URINARY PH MODIFIERS:(69.04)'
             69.05 'UTEROTONIC AGENTS:(69.05)'
             69.99 'MISCELLANEOUS GENITOURINARY TRACT AGENTS:(69.99)'
             70.01 '5-ALPHA-REDUCTASE INHIBITORS:(70.01)'
             70.02 'ADRENAL CORTICAL STEROIDS:(70.02)'
             70.05 'ANTIDIURETIC HORMONES:(70.05)'
             70.06 'ANTIGONADOTROPIC AGENTS:(70.06)'
             70.07 'ANTITHYROID AGENTS:(70.07)' 70.09 'CALCITONIN:(70.09)'
             70.11 'GONADOTROPIN-RELEASING HORMONE ANTAGONISTS:(70.11)'
             70.12 'GROWTH HORMONE RECEPTOR BLOCKERS:(70.12)'
             70.13 'GROWTH HORMONES:(70.13)'
             70.15 'INSULIN-LIKE GROWTH FACTOR:(70.15)'
             70.16 'PARATHYROID HORMONE AND ANALOGS:(70.16)'
             70.17 'PROGESTERONE RECEPTOR MODULATORS:(70.17)'
             70.18 'PROLACTIN INHIBITORS:(70.18)'
             70.19 'SELECTIVE ESTROGEN RECEPTOR MODULATORS:(70.19)'
             70.2 'SEX HORMONES:(70.2)'
             70.21 'SOMATOSTATIN AND SOMATOSTATIN ANALOGS:(70.21)'
             70.22 'SYNTHETIC OVULATION STIMULANTS:(70.22)'
             70.23 'THYROID HORMONES:(70.23)'
             70.99 'MISCELLANEOUS HORMONES:(70.99)'
             71.01 'IMMUNE GLOBULINS:(71.01)'
             71.02 'IMMUNOSTIMULANTS:(71.02)'
             71.03 'IMMUNOSUPPRESSIVE AGENTS:(71.03)'
             71.99 'MISCELLANEOUS IMMUNOLOGIC AGENTS:(71.99)'
             73.01 'ANTIDIABETIC AGENTS:(73.01)'
             73.02 'ANTIGOUT AGENTS:(73.02)'
             73.03 'ANTIHYPERLIPIDEMIC AGENTS:(73.03)'
             73.04 'ANTIHYPERURICEMIC AGENTS:(73.04)'
             73.05 'BONE RESORPTION INHIBITORS:(73.05)'
             73.06 'GLUCOSE ELEVATING AGENTS:(73.06)'
             73.07 'LYSOSOMAL ENZYMES:(73.07)'
             73.08 'PERIPHERALLY ACTING ANTIOBESITY AGENTS:(73.08)'
             73.99 'MISCELLANEOUS METABOLIC AGENTS:(73.99)'
             74.01 'ANTIDOTES:(74.01)' 74.04 'ANTIPSORIATICS:(74.04)'
             74.05 'ANTIRHEUMATICS:(74.05)' 74.06 'CHELATING AGENTS:(74.06)'
             74.07 'CHOLINERGIC MUSCLE STIMULANTS:(74.07)'
             74.11 'LOCAL INJECTABLE ANESTHETICS:(74.11)'
             74.13 'PSORALENS:(74.13)'
             74.17 'SMOKING CESSATION AGENTS:(74.17)'
             74.18 'VISCOSUPPLEMENTATION AGENTS:(74.18)'
             74.19 'MISCELLANEOUS UNCATEGORIZED AGENTS:(74.19)'
             75.01 'INTRAVENOUS NUTRITIONAL PRODUCTS:(75.01)'
             75.02 'IRON PRODUCTS:(75.02)'
             75.03 'MINERALS AND ELECTROLYTES:(75.03)'
             75.04 'ORAL NUTRITIONAL SUPPLEMENTS:(75.04)'
             75.05 'VITAMIN AND MINERAL COMBINATIONS:(75.05)'
             75.06 'VITAMINS:(75.06)' 77.01 'RADIOCONTRAST AGENTS:(77.01)'
             77.02 'RADIOLOGIC ADJUNCTS:(77.02)'
             77.03 'RADIOPHARMACEUTICALS:(77.03)'
             78.01 'ANORECTAL PREPARATIONS:(78.01)'
             78.02 'ANTISEPTIC AND GERMICIDES:(78.02)'
             78.03 'DERMATOLOGICAL AGENTS:(78.03)'
             78.04 'MOUTH AND THROAT PRODUCTS:(78.04)'
             78.05 'NASAL PREPARATIONS:(78.05)'
             78.06 'OPHTHALMIC PREPARATIONS:(78.06)'
             78.07 'OTIC PREPARATIONS:(78.07)'
             78.08 'STERILE IRRIGATING SOLUTIONS:(78.08)'
             78.09 'VAGINAL PREPARATIONS:(78.09)' /
   SDLED_4_6 -7 'NOT APPLICABLE:(-7.00)' 5.01 'MARIJUANA:(5.01)'
             5.02 'SYNTHETIC CANNABINOIDS:(5.02)' 6 'AMPHETAMINES:(6)'
             7 'METHAMPHETAMINE:(7)' 7.1 'OTHER STIMULANTS:(7.1)'
             20 'MAO INHIBITORS:(20)'
             20.4 'PHENYLPIPERAZINE ANTIDEPRESSANTS:(20.4)'
             20.7 'SSNRI ANTIDEPRESSANTS:(20.7)'
             21 'SSRI ANTIDEPRESSANTS:(21)'
             21.5 'TETRACYCLIC ANTIDEPRESSANTS:(21.5)'
             22 'TRICYCLIC ANTIDEPRESSANTS:(22)'
             23 'MISCELLANEOUS ANTIDEPRESSANTS:(23)'
             25 'ATYPICAL ANTIPSYCHOTICS:(25)'
             26 'PHENOTHIAZINE ANTIPSYCHOTICS:(26)'
             26.5 'PSYCHOTHERAPEUTIC COMBINATIONS:(26.5)'
             26.7 'THIOXANTHENES:(26.7)'
             27 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS:(27)'
             35 'ANTIMIGRAINE AGENTS:(35)' 36 'COX-2 INHIBITORS:(36)'
             36.5 'OPIATES/OPIOIDS:(36.5)'
             39 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS:(39)'
             40.5 'SALICYLATES/COMBINATIONS:(40.5)'
             41.5 'MISCELLANEOUS ANALGESICS/COMBINATIONS:(41.5)'
             42.5 'ANALGESIC COMBINATIONS NTA:(42.5)'
             43.01 'PHENYLPROPANOLAMINE:(43.01)'
             43.02 'ANOREXIANTS-NOS:(43.02)' 43.09 'ANOREXIANTS NTA:(43.09)'
             44.01 'BARBITURATE ANTICONVULSANTS:(44.01)'
             44.02 'BENZODIAZEPINE ANTICONVULSANTS:(44.02)'
             44.03 'CARBAMATE ANTICONVULSANTS:(44.03)'
             44.04 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS:(44.04)'
             44.05 'DIBENZAZEPINE ANTICONVULSANTS:(44.05)'
             44.06 'FATTY ACID DERIVATIVE ANTICONVULSANTS:(44.06)'
             44.07 'GAMMA-AMINOBUTYRIC ACID ANALOGS:(44.07)'
             44.08 'GAMMA-AMINOBUTYRIC ACID REUPTAKE INHIBITORS:(44.08)'
             44.09 'HYDANTOIN ANTICONVULSANTS:(44.09)'
             44.11 'OXAZOLIDINEDIONE ANTICONVULSANTS:(44.11)'
             44.12 'PYRROLIDINE ANTICONVULSANTS:(44.12)'
             44.13 'SUCCINIMIDE ANTICONVULSANTS:(44.13)'
             44.14 'TRIAZINE ANTICONVULSANTS:(44.14)'
             44.99 'MISCELLANEOUS ANTICONVULSANTS:(44.99)'
             45.01 '5HT3 RECEPTOR ANTAGONISTS:(45.01)'
             45.02 'ANTICHOLINERGIC ANTIEMETICS:(45.02)'
             45.03 'PHENOTHIAZINE ANTIEMETICS:(45.03)'
             45.04 'MISCELLANEOUS ANTIEMETICS:(45.04)'
             46.01 'ANTICHOLINERGIC ANTIPARKINSON AGENTS:(46.01)'
             46.02 'DOPAMINERGIC ANTIPARKINSONISM AGENTS:(46.02)'
             46.03 'MISCELLANEOUS ANTIPARKINSON AGENTS:(46.03)'
             46.31 'BARBITURATES:(46.31)' 46.32 'BENZODIAZEPINES:(46.32)'
             46.33 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS:(46.33)'
             46.501 'AMPHETAMINE-DEXTROAMPHETAMINE:(46.501)'
             46.502 'BENZPHETAMINE:(46.502)' 46.503 'CAFFEINE:(46.503)'
             46.504 'DEXTROAMPHETAMINE:(46.504)'
             46.505 'METHYLPHENIDATE:(46.505)'
             46.509 'CNS STIMULANTS NTA:(46.509)'
             48.01 'NEUROMUSCULAR BLOCKING AGENTS:(48.01)'
             48.02 'SKELETAL MUSCLE RELAXANT COMBINATIONS:(48.02)'
             48.03 'SKELETAL MUSCLE RELAXANTS:(48.03)'
             48.04 'MISCELLANEOUS MUSCLE RELAXANTS:(48.04)'
             49.01 'CHOLINERGIC AGONISTS:(49.01)'
             49.02 'CHOLINESTERASE INHIBITORS:(49.02)'
             49.03 'MISCELLANEOUS CENTRAL NERVOUS SYSTEM AGENTS:(49.03)'
             52.01 'ADRENERGIC BRONCHODILATORS:(52.01)'
             52.02 'ANTICHOLINERGIC BRONCHODILATORS:(52.02)'
             52.03 'BRONCHODILATOR COMBINATIONS:(52.03)'
             52.04 'METHYLXANTHINES:(52.04)'
             52.05 'MISCELLANEOUS BRONCHODILATORS:(52.05)'
             56.01 'ANTIASTHMATIC COMBINATIONS:(56.01)'
             56.02 'ANTITUSSIVES:(56.02)'
             56.03 'LEUKOTRIENE MODIFIERS:(56.03)'
             56.05 'RESPIRATORY INHALANT PRODUCTS:(56.05)'
             56.06 'MISCELLANEOUS RESPIRATORY AGENTS:(56.06)'
             58.01 'CLONIDINE:(58.01)'
             58.09 'ANTIADRENERGIC AGENTS, CENTRALLY ACTING NTA:(58.09)'
             59.01 'CARDIOSELECTIVE BETA BLOCKERS:(59.01)'
             59.02 'NON-CARDIOSELECTIVE BETA BLOCKERS:(59.02)'
             59.03 'MISCELLANEOUS BETA-ADRENERGIC BLOCKING AGENTS:(59.03)'
             61.01 'CARBONIC ANHYDRASE INHIBITORS:(61.01)'
             61.02 'LOOP DIURETICS:(61.02)'
             61.03 'POTASSIUM-SPARING DIURETICS:(61.03)'
             61.04 'THIAZIDE AND THIAZIDE-LIKE DIURETICS:(61.04)'
             61.05 'MISCELLANEOUS DIURETICS:(61.05)'
             62.01 'AGENTS FOR HYPERTENSIVE EMERGENCIES:(62.01)'
             62.02 'AGENTS FOR PULMONARY HYPERTENSION:(62.02)'
             62.03 'ALDOSTERONE RECEPTOR ANTAGONISTS:(62.03)'
             62.04 'ANGIOTENSIN CONVERTING ENZYME INHIBITORS:(62.04)'
             62.05 'ANGIOTENSIN II INHIBITORS:(62.05)'
             62.06 'ANTIADRENERGIC AGENTS, PERIPHERALLY ACTING:(62.06)'
             62.07 'ANTIANGINAL AGENTS:(62.07)'
             62.08 'ANTIARRHYTHMIC AGENTS:(62.08)'
             62.09 'ANTIHYPERTENSIVE COMBINATIONS:(62.09)'
             62.1 'CATECHOLAMINES:(62.1)' 62.11 'INOTROPIC AGENTS:(62.11)'
             62.12 'PERIPHERAL VASODILATORS:(62.12)'
             62.13 'SCLEROSING AGENTS:(62.13)' 62.14 'VASODILATORS:(62.14)'
             62.15 'VASOPRESSORS:(62.15)'
             62.99 'MISCELLANEOUS CARDIOVASCULAR AGENTS:(62.99)'
             64.041 'AZOLE ANTIFUNGALS:(64.041)'
             64.042 'ECHINOCANDINS:(64.042)' 64.043 'POLYENES:(64.043)'
             64.044 'MISCELLANEOUS ANTIFUNGALS:(64.044)'
             64.051 'ANTIMALARIAL COMBINATIONS:(64.051)'
             64.052 'ANTIMALARIAL QUINOLINES:(64.052)'
             64.053 'MISCELLANEOUS ANTIMALARIALS:(64.053)'
             64.061 'AMINOSALICYLATES:(64.061)'
             64.062 'ANTITUBERCULOSIS COMBINATIONS:(64.062)'
             64.063 'NICOTINIC ACID DERIVATIVES:(64.063)'
             64.064 'RIFAMYCIN DERIVATIVES:(64.064)'
             64.065 'STREPTOMYCES DERIVATIVES:(64.065)'
             64.066 'MISCELLANEOUS ANTITUBERCULOSIS AGENTS:(64.066)'
             64.0701 'ADAMANTANE ANTIVIRALS:(64.0701)'
             64.0702 'ANTIVIRAL CHEMOKINE RECEPTOR ANTAGONIST:(64.0702)'
             64.0703 'ANTIVIRAL COMBINATIONS:(64.0703)'
             64.0704 'ANTIVIRAL INTERFERONS:(64.0704)'
             64.0705 'INTEGRASE STRAND TRANSFER INHIBITOR:(64.0705)'
             64.0706 'NEURAMINIDASE INHIBITORS:(64.0706)'
             64.0707 'NNRTIS:(64.0707)' 64.0708 'NRTIS:(64.0708)'
             64.0709 'PROTEASE INHIBITORS:(64.0709)'
             64.071 'PURINE NUCLEOSIDES:(64.071)'
             64.0711 'MISCELLANEOUS ANTIVIRALS:(64.0711)'
             64.091 'FIRST GENERATION CEPHALOSPORINS:(64.091)'
             64.092 'SECOND GENERATION CEPHALOSPORINS:(64.092)'
             64.093 'THIRD GENERATION CEPHALOSPORINS:(64.093)'
             64.094 'FOURTH GENERATION CEPHALOSPORINS:(64.094)'
             64.095 'FIFTH GENERATION CEPHALOSPORINS:(64.095)'
             64.096 'MISCELLANEOUS CEPHALOSPORINS:(64.096)'
             64.141 'KETOLIDES:(64.141)' 64.142 'MACROLIDES:(64.142)'
             64.143 'MISCELLANEOUS MACROLIDES:(64.143)'
             64.151 'AMINOPENICILLINS:(64.151)'
             64.152 'ANTIPSEUDOMONAL PENICILLINS:(64.152)'
             64.153 'BETA-LACTAMASE INHIBITORS:(64.153)'
             64.154 'NATURAL PENICILLINS:(64.154)'
             64.155 'PENICILLINASE RESISTANT PENICILLINS:(64.155)'
             67.011 'COUMARINS AND INDANEDIONES:(67.011)'
             67.012 'FACTOR XA INHIBITORS:(67.012)'
             67.013 'HEPARINS:(67.013)' 67.014 'THROMBIN INHIBITORS:(67.014)'
             67.021 'GLYCOPROTEIN PLATELET INHIBITORS:(67.021)'
             67.022 'PLATELET AGGREGATION INHIBITORS:(67.022)'
             68.061 'ANTICHOLINERGICS/ANTISPASMODICS:(68.061)'
             68.062 'CHLORIDE CHANNEL ACTIVATORS:(68.062)'
             68.063 'PERIPHERAL OPIOID RECEPTOR ANTAGONISTS:(68.063)'
             68.064 'SEROTONINERGIC NEUROENTERIC MODULATORS:(68.064)'
             70.021 'CORTICOTROPIN:(70.021)'
             70.022 'GLUCOCORTICOIDS:(70.022)'
             70.023 'MINERALOCORTICOIDS:(70.023)'
             70.029 'MISCELLANEOUS ADRENAL CORTICAL STEROIDS:(70.029)'
             70.202 'ANDROGENS AND ANABOLIC STEROIDS:(70.202)'
             70.203 'CONTRACEPTIVES:(70.203)' 70.204 'ESTROGENS:(70.204)'
             70.205 'GONADOTROPIN-RELEASING HORMONE AND ANALOGS:(70.205)'
             70.206 'GONADOTROPINS:(70.206)' 70.207 'PROGESTINS:(70.207)'
             70.208 'SEX HORMONE COMBINATIONS:(70.208)'
             70.209 'MISCELLANEOUS SEX HORMONES:(70.209)'
             71.021 'BACTERIAL VACCINES:(71.021)'
             71.022 'COLONY STIMULATING FACTORS:(71.022)'
             71.023 'INTERFERONS:(71.023)'
             71.025 'THERAPEUTIC VACCINES:(71.025)'
             71.026 'VACCINE COMBINATIONS:(71.026)'
             71.027 'VIRAL VACCINES:(71.027)'
             71.029 'OTHER IMMUNOSTIMULANTS:(71.029)'
             71.031 'CALCINEURIN INHIBITORS:(71.031)'
             71.032 'INTERLEUKIN INHIBITORS:(71.032)'
             71.033 'SELECTIVE IMMUNOSUPPRESSANTS:(71.033)'
             71.034 'TNF ALFA INHIBITORS:(71.034)'
             71.039 'OTHER IMMUNOSUPPRESSANTS:(71.039)'
             73.0101 'ALPHA-GLUCOSIDASE INHIBITORS:(73.0101)'
             73.0102 'AMYLIN ANALOGS:(73.0102)'
             73.0103 'ANTIDIABETIC COMBINATIONS:(73.0103)'
             73.0104 'DIPEPTIDYL PEPTIDASE 4 INHIBITORS:(73.0104)'
             73.0105 'INCRETIN MIMETICS:(73.0105)'
             73.0106 'INSULIN:(73.0106)' 73.0107 'MEGLITINIDES:(73.0107)'
             73.0108 'BIGUANIDES:(73.0108)' 73.0109 'SULFONYLUREAS:(73.0109)'
             73.011 'THIAZOLIDINEDIONES:(73.011)'
             73.019 'MISCELLANEOUS ANTIDIABETIC AGENTS:(73.019)'
             73.031 'ANTIHYPERLIPIDEMIC COMBINATIONS:(73.031)'
             73.032 'BILE ACID SEQUESTRANTS:(73.032)'
             73.033 'CHOLESTEROL ABSORPTION INHIBITORS:(73.033)'
             73.034 'FIBRIC ACID DERIVATIVES:(73.034)'
             73.035 'HMG-COA REDUCTASE INHIBITORS:(73.035)'
             73.036 'MISCELLANEOUS ANTIHYPERLIPIDEMIC AGENTS:(73.036)'
             73.051 'BISPHOSPHONATES:(73.051)'
             73.059 'MISCELLANEOUS BONE RESORPTION INHIBITORS:(73.059)'
             77.011 'IONIC IODINATED CONTRAST MEDIA:(77.011)'
             77.012 'LYMPHATIC STAINING AGENTS:(77.012)'
             77.013 'MAGNETIC RESONANCE IMAGING CONTRAST MEDIA:(77.013)'
             77.014 'NON-IODINATED CONTRAST MEDIA:(77.014)'
             77.015 'NON-IONIC IODINATED CONTRAST MEDIA:(77.015)'
             77.016 'ULTRASOUND CONTRAST MEDIA:(77.016)'
             77.017 'MISCELLANEOUS IODINATED CONTRAST MEDIA:(77.017)'
             77.019 'MISCELLANEOUS RADIOCONTRAST AGENTS:(77.019)'
             77.021 'CARDIAC STRESSING AGENTS:(77.021)'
             77.031 'DIAGNOSTIC RADIOPHARMACEUTICALS:(77.031)'
             77.032 'THERAPEUTIC RADIOPHARMACEUTICALS:(77.032)'
             77.033 'MISCELLANEOUS RADIOPHARMACEUTICALS:(77.033)'
             78.0301 'TOPICAL ACNE AGENTS:(78.0301)'
             78.0302 'TOPICAL ANESTHETICS:(78.0302)'
             78.0303 'TOPICAL ANTIBIOTICS:(78.0303)'
             78.0304 'TOPICAL ANTIFUNGALS:(78.0304)'
             78.0305 'TOPICAL ANTIHISTAMINES:(78.0305)'
             78.0306 'TOPICAL ANTI-INFECTIVES:(78.0306)'
             78.0307 'TOPICAL ANTIPSORIATICS:(78.0307)'
             78.0308 'TOPICAL ANTIVIRALS:(78.0308)'
             78.0309 'TOPICAL ASTRINGENTS:(78.0309)'
             78.031 'TOPICAL DEBRIDING AGENTS:(78.031)'
             78.0311 'TOPICAL DEPIGMENTING AGENTS:(78.0311)'
             78.0312 'TOPICAL EMOLLIENTS:(78.0312)'
             78.0313 'TOPICAL KERATOLYTICS:(78.0313)'
             78.0314 'TOPICAL NON-STEROIDAL ANTI-INFLAMMATORIES:(78.0314)'
             78.0315 'TOPICAL STEROIDS:(78.0315)'
             78.0316 'TOPICAL STEROIDS WITH ANTI-INFECTIVES:(78.0316)'
             78.0399 'MISCELLANEOUS TOPICAL AGENTS:(78.0399)'
             78.051 'NASAL ANTIHISTAMINES AND DECONGESTANTS:(78.051)'
             78.053 'NASAL LUBRICANTS AND IRRIGATIONS:(78.053)'
             78.054 'NASAL STEROIDS:(78.054)'
             78.055 'MISCELLANEOUS NASAL PREPARATIONS:(78.055)'
             78.0602 'ANTI-ANGIOGENIC OPHTHALMIC AGENTS:(78.0602)'
             78.061 'MYDRIATICS:(78.061)'
             78.062 'OPHTHALMIC ANESTHETICS:(78.062)'
             78.063 'OPHTHALMIC ANTIHISTAMINES AND DECONGESTANTS:(78.063)'
             78.064 'OPHTHALMIC ANTI-INFECTIVES:(78.064)'
             78.065 'OPHTHALMIC ANTI-INFLAMMATORY AGENTS:(78.065)'
             78.066 'OPHTHALMIC DIAGNOSTIC AGENTS:(78.066)'
             78.067 'OPHTHALMIC GLAUCOMA AGENTS:(78.067)'
             78.068 'OPHTHALMIC LUBRICANTS AND IRRIGATIONS:(78.068)'
             78.069 'OPHTHALMIC STEROIDS:(78.069)'
             78.0691 'OPHTHALMIC STEROIDS WITH ANTI-INFECTIVES:(78.0691)'
             78.0692 'OPHTHALMIC SURGICAL AGENTS:(78.0692)'
             78.0693 'MISCELLANEOUS OPHTHALMIC AGENTS:(78.0693)'
             78.071 'CERUMENOLYTICS:(78.071)'
             78.072 'OTIC ANESTHETICS:(78.072)'
             78.073 'OTIC ANTI-INFECTIVES:(78.073)'
             78.074 'OTIC STEROIDS:(78.074)'
             78.075 'OTIC STEROIDS WITH ANTI-INFECTIVES:(78.075)'
             78.076 'MISCELLANEOUS OTIC AGENTS:(78.076)'
             78.091 'SPERMICIDES:(78.091)'
             78.092 'VAGINAL ANTI-INFECTIVES:(78.092)'
             78.093 'MISCELLANEOUS VAGINAL AGENTS:(78.093)' /
   SDLED_5_6 -7 'NOT APPLICABLE' 20.41 'NEFAZODONE:(20.41)'
             20.42 'TRAZODONE:(20.42)' 20.71 'DESVENLAFAXINE:(20.71)'
             20.72 'DULOXETINE:(20.72)' 20.73 'VENLAFAXINE:(20.73)'
             20.79 'SSNRI ANTIDEPRESSANTS NTA:(20.79)'
             21.01 'CITALOPRAM:(21.01)' 21.02 'FLUOXETINE:(21.02)'
             21.03 'FLUVOXAMINE:(21.03)' 21.04 'PAROXETINE:(21.04)'
             21.05 'SERTRALINE:(21.05)'
             21.09 'SSRI ANTIDEPRESSANTS NTA:(21.09)'
             21.51 'MAPROTILINE:(21.51)' 21.52 'MIRTAZAPINE:(21.52)'
             22.01 'AMITRIPTYLINE:(22.01)' 22.02 'DESIPRAMINE:(22.02)'
             22.03 'DOXEPIN:(22.03)' 22.04 'IMIPRAMINE:(22.04)'
             22.05 'NORTRIPTYLINE:(22.05)'
             22.06 'TRICYCLIC ANTIDEPRESSANTS-NOS:(22.06)'
             22.09 'TRICYCLIC ANTIDEPRESSANTS NTA:(22.09)'
             23.01 'BUPROPION:(23.01)' 23.06 'ANTIDEPRESSANTS-NOS:(23.06)'
             23.09 'MISCELLANEOUS ANTIDEPRESSANTS NTA:(23.09)'
             25.01 'CLOZAPINE:(25.01)' 25.02 'OLANZAPINE:(25.02)'
             25.03 'QUETIAPINE:(25.03)' 25.04 'RISPERIDONE:(25.04)'
             25.09 'ATYPICAL ANTIPSYCHOTICS NTA:(25.09)'
             26.01 'CHLORPROMAZINE:(26.01)' 26.02 'FLUPHENAZINE:(26.02)'
             26.03 'PERPHENAZINE:(26.03)' 26.04 'PROCHLORPERAZINE:(26.04)'
             26.05 'THIORIDAZINE:(26.05)' 26.06 'TRIFLUPROMAZINE:(26.06)'
             26.09 'PHENOTHIAZINE ANTIPSYCHOTICS NTA:(26.09)'
             27.01 'HALOPERIDOL:(27.01)' 27.02 'LITHIUM:(27.02)'
             27.09 'MISCELLANEOUS ANTIPSYCHOTIC AGENTS NTA:(27.09)'
             36.75 'OPIATES/OPIOIDS, UNSPECIFIED:(36.75)'
             37.5 'NARCOTIC ANALGESICS:(37.5)'
             39.01 'IBUPROFEN/COMBINATIONS:(39.01)'
             39.02 'NAPROXEN/COMBINATIONS:(39.02)'
             39.03 'NONSTEROIDAL ANTI-INFLAMMATORY AGENTS NTA:(39.03)'
             40.501 'ASPIRIN/COMBINATIONS:(40.501)'
             40.502 'SALICYLATES-NOS:(40.502)'
             40.503 'SALICYLATES/COMBINATIONS NTA:(40.503)'
             41.501 'ACETAMINOPHEN/COMBINATIONS:(41.501)'
             41.502 'TRAMADOL/COMBINATIONS:(41.502)'
             41.505 'ANALGESICS-NOS:(41.505)'
             41.506 'MISCELLANEOUS ANALGESIC/COMBINATIONS NTA:(41.506)'
             44.041 'TOPIRAMATE:(44.041)'
           44.049 'CARBONIC ANHYDRASE INHIBITOR ANTICONVULSANTS NTA:(44.049)'
             44.051 'CARBAMAZEPINE:(44.051)' 44.052 'OXCARBAZEPINE:(44.052)'
             44.053 'RUFINAMIDE:(44.053)' 44.061 'DIVALPROEX SODIUM:(44.061)'
             44.062 'VALPROIC ACID:(44.062)' 44.071 'GABAPENTIN:(44.071)'
             44.079 'GAMMA-AMINOBUTYRIC ACID ANALOGS NTA:(44.079)'
             44.091 'PHENYTOIN:(44.091)'
             44.099 'HYDANTOIN ANTICONVULSANTS NTA:(44.099)'
             46.011 'BENZTROPINE:(46.011)'
             46.019 'ANTICHOLINERGIC ANTIPARKINSON AGENTS NTA:(46.019)'
             46.3101 'PHENOBARBITAL:(46.3101)'
             46.3102 'BARBITURATES-NOS:(46.3102)'
             46.3109 'BARBITURATES NTA:(46.3109)'
             46.3201 'ALPRAZOLAM:(46.3201)'
             46.3202 'CHLORDIAZEPOXIDE:(46.3202)'
             46.3203 'CLONAZEPAM:(46.3203)' 46.3204 'CLORAZEPATE:(46.3204)'
             46.3205 'DIAZEPAM:(46.3205)' 46.3206 'FLURAZEPAM:(46.3206)'
             46.3207 'LORAZEPAM:(46.3207)' 46.3208 'OXAZEPAM:(46.3208)'
             46.3209 'TEMAZEPAM:(46.3209)' 46.321 'TRIAZOLAM:(46.321)'
             46.3211 'BENZODIAZEPINES-NOS:(46.3211)'
             46.3219 'BENZODIAZEPINES NTA:(46.3219)'
             46.3301 'BUSPIRONE:(46.3301)'
             46.3302 'CHLORAL HYDRATE:(46.3302)'
             46.3303 'DIPHENHYDRAMINE:(46.3303)'
             46.3304 'DOXYLAMINE:(46.3304)' 46.3305 'HYDROXYZINE:(46.3305)'
             46.3306 'ZOLPIDEM:(46.3306)'
             46.3307 'ANXIOLYTICS, SEDATIVES AND HYPNOTICS-NOS:(46.3307)'
          46.3309 'MISC. ANXIOLYTICS, SEDATIVES, AND HYPNOTICS NTA:(46.3309)'
             46.5091 'CAFFEINE/MULTIVITAMIN:(46.5091)'
             46.5092 'OTHER CNS STIMULANTS NTA:(46.5092)'
             48.031 'CARISOPRODOL:(48.031)' 48.032 'CHLORZOXAZONE:(48.032)'
             48.033 'CYCLOBENZAPRINE:(48.033)' 48.034 'METAXALONE:(48.034)'
             48.035 'METHOCARBAMOL:(48.035)' 48.036 'TIZANIDINE:(48.036)'
             48.039 'SKELETAL MUSCLE RELAXANTS NTA:(48.039)'
             56.052 'INHALED CORTICOSTEROIDS:(56.052)'
             56.053 'MAST CELL STABILIZERS:(56.053)'
             56.054 'MUCOLYTICS:(56.054)'
             56.059 'MISCELLANEOUS RESPIRATORY INHALANT PRODUCTS:(56.059)'
             59.011 'ATENOLOL:(59.011)'
             59.019 'CARDIOSELECTIVE BETA BLOCKERS NTA:(59.019)'
             59.021 'PROPRANOLOL:(59.021)'
             59.029 'NON-CARDIOSELECTIVE BETA BLOCKERS NTA:(59.029)'
             62.081 'GROUP I ANTIARRHYTHMICS:(62.081)'
             62.083 'GROUP III ANTIARRHYTHMICS:(62.083)'
             62.085 'GROUP V ANTIARRHYTHMICS:(62.085)'
             62.089 'ANTIARRHYTHMIC AGENTS NTA:(62.089)'
             62.151 'EPHEDRINE:(62.151)' 62.159 'VASOPRESSORS NTA:(62.159)' /
   SDLED_6_6 -7 'NOT APPLICABLE:(-7)'
             37.5005 'BUPRENORPHINE/COMBINATIONS:(37.5005)'
             37.501 'CODEINE/COMBINATIONS:(37.501)'
             37.502 'DIHYDROCODEINE/COMBINATIONS:(37.502)'
             37.503 'FENTANYL/COMBINATIONS:(37.503)'
             37.504 'HYDROCODONE/COMBINATIONS:(37.504)'
             37.5045 'HYDROMORPHONE/COMBINATIONS:(37.5045)'
             37.505 'MEPERIDINE/COMBINATIONS:(37.505)'
             37.506 'METHADONE:(37.506)'
             37.507 'MORPHINE/COMBINATIONS:(37.507)'
             37.508 'OPIUM/COMBINATIONS:(37.508)'
             37.509 'OXYCODONE/COMBINATIONS:(37.509)'
             37.51 'PENTAZOCINE/COMBINATIONS:(37.51)'
             37.511 'PHENACETIN/COMBINATIONS:(37.511)'
             37.512 'PROPOXYPHENE/COMBINATIONS:(37.512)'
             37.514 'ALL OTHER NARCOTIC ANALGESICS/COMBINATIONS NTA:(37.514)'
             41.503 'TRAMADOL:(41.503)'
             41.504 'ACETAMINOPHEN-TRAMADOL:(41.504)' /
   DRUGID_7  -7 'NOT APPLICABLE' 1 'D00001 ACYCLOVIR' 2 'D00002 AMIODARONE'
             3 'D00003 AMPICILLIN' 4 'D00004 ATENOLOL' 5 'D00006 CAPTOPRIL'
             6 'D00007 CEFAZOLIN' 7 'D00008 CEFOTAXIME'
             8 'D00009 CEFTAZIDIME' 9 'D00010 CEFTIZOXIME'
             10 'D00011 CIPROFLOXACIN' 11 'D00012 CODEINE'
             12 'D00013 ENALAPRIL' 13 'D00014 GENTAMICIN'
             14 'D00015 IBUPROFEN' 15 'D00016 LABETALOL'
             16 'D00017 MEPERIDINE' 17 'D00018 NADOLOL' 18 'D00019 NAPROXEN'
             19 'D00020 QUINIDINE' 20 'D00021 RANITIDINE'
             21 'D00022 WARFARIN' 22 'D00023 ALLOPURINOL'
             23 'D00024 AZATHIOPRINE' 24 'D00025 CHLORAMPHENICOL'
             25 'D00026 FENOPROFEN' 26 'D00027 HALOPERIDOL'
             27 'D00028 KETOPROFEN' 28 'D00029 NAFCILLIN'
             29 'D00030 PENTAMIDINE' 30 'D00031 PROBENECID'
             31 'D00032 PROPRANOLOL' 32 'D00033 SULINDAC'
             33 'D00034 ZIDOVUDINE' 34 'D00035 CHLOROQUINE'
             35 'D00036 CYCLOPHOSPHAMIDE' 36 'D00037 DOXYCYCLINE'
             37 'D00038 FLUCYTOSINE' 38 'D00039 INDOMETHACIN'
             39 'D00040 OXAZEPAM' 40 'D00041 TETRACYCLINE'
             41 'D00042 CHLORPROPAMIDE' 42 'D00043 CLINDAMYCIN'
             43 'D00044 CLONIDINE' 44 'D00045 DILTIAZEM'
             45 'D00046 ERYTHROMYCIN' 46 'D00047 RIFAMPIN'
             47 'D00048 VERAPAMIL' 48 'D00049 ACETAMINOPHEN'
             49 'D00050 METHADONE' 50 'D00051 NIFEDIPINE'
             51 'D00052 CEFTRIAXONE' 52 'D00053 CEPHRADINE'
             53 'D00054 TOLMETIN' 54 'D00055 CEFOTETAN'
             55 'D00056 CEFUROXIME' 56 'D00057 PIPERACILLIN'
             57 'D00058 CARBAMAZEPINE' 58 'D00059 LIDOCAINE'
             59 'D00060 METHOTREXATE' 60 'D00061 LITHIUM'
             61 'D00062 CEFAMANDOLE' 62 'D00064 CHLORPROMAZINE'
             63 'D00065 FOSCARNET' 64 'D00066 GANCICLOVIR'
             65 'D00067 AZTREONAM' 66 'D00068 ETHAMBUTOL'
             67 'D00069 TOBRAMYCIN' 68 'D00070 FUROSEMIDE'
             69 'D00071 FLUCONAZOLE' 70 'D00072 CEFIXIME'
             71 'D00073 CEFPROZIL' 72 'D00074 CEFOPERAZONE'
             73 'D00075 PROCAINAMIDE' 74 'D00077 AMPHOTERICIN B'
             75 'D00078 DIDANOSINE' 76 'D00079 CYCLOSPORINE'
             77 'D00080 CEFADROXIL' 78 'D00081 CEFACLOR'
             79 'D00082 IMIPENEM-CILASTATIN' 80 'D00083 VALPROIC ACID'
             81 'D00084 PREDNISOLONE' 82 'D00085 RIBAVIRIN'
             83 'D00086 AMANTADINE' 84 'D00087 AMIKACIN'
             85 'D00088 AMOXICILLIN' 86 'D00089 AMOXICILLIN-CLAVULANATE'
             87 'D00090 AMPICILLIN-SULBACTAM' 88 'D00091 AZITHROMYCIN'
             89 'D00092 CARBENICILLIN' 90 'D00093 CEFMETAZOLE'
             91 'D00094 CEFOXITIN' 92 'D00095 CEFPODOXIME'
             93 'D00096 CEPHALEXIN' 94 'D00097 CLARITHROMYCIN'
             95 'D00098 DAPSONE' 96 'D00099 ENOXACIN'
             97 'D00100 GRISEOFULVIN' 98 'D00101 ISONIAZID'
             99 'D00102 ITRACONAZOLE' 100 'D00103 KETOCONAZOLE'
             101 'D00104 LOMEFLOXACIN' 102 'D00105 LORACARBEF'
             103 'D00106 METHENAMINE' 104 'D00107 METHICILLIN'
             105 'D00108 METRONIDAZOLE' 106 'D00109 MEZLOCILLIN'
             107 'D00110 MINOCYCLINE' 108 'D00112 NITROFURANTOIN'
             109 'D00113 NORFLOXACIN' 110 'D00114 OFLOXACIN'
             111 'D00115 OXACILLIN' 112 'D00116 PENICILLIN'
             113 'D00117 PYRAZINAMIDE' 114 'D00118 SULFADIAZINE'
             115 'D00119 SULFAMETHOXAZOLE' 116 'D00120 SULFISOXAZOLE'
             117 'D00121 TICARCILLIN' 118 'D00122 TICARCILLIN-CLAVULANATE'
             119 'D00123 TRIMETHOPRIM'
             120 'D00124 SULFAMETHOXAZOLE-TRIMETHOPRIM'
             121 'D00125 VANCOMYCIN' 122 'D00128 ACEBUTOLOL'
             123 'D00129 DIAZOXIDE' 124 'D00132 HYDRALAZINE'
             125 'D00133 METHYLDOPA' 126 'D00134 METOPROLOL'
             127 'D00135 MINOXIDIL' 128 'D00137 PINDOLOL'
             129 'D00138 PRAZOSIN' 130 'D00139 TIMOLOL'
             131 'D00140 CIMETIDINE' 132 'D00141 FAMOTIDINE'
             133 'D00142 THEOPHYLLINE' 134 'D00143 PHENYTOIN'
             135 'D00144 NORTRIPTYLINE' 136 'D00145 DESIPRAMINE'
             137 'D00146 AMITRIPTYLINE' 138 'D00147 CHLORAL HYDRATE'
             139 'D00148 DIAZEPAM' 140 'D00149 LORAZEPAM'
             141 'D00150 COLCHICINE' 142 'D00152 CLOXACILLIN'
             143 'D00153 DICLOXACILLIN' 144 'D00154 MEBENDAZOLE'
             145 'D00155 MICONAZOLE' 146 'D00157 NALIDIXIC ACID'
             147 'D00158 QUINACRINE' 148 'D00159 STREPTOMYCIN'
             149 'D00161 ACETAZOLAMIDE' 150 'D00164 ADENOSINE'
             151 'D00167 ALFENTANIL' 152 'D00168 ALPRAZOLAM'
             153 'D00169 AMILORIDE' 154 'D00170 ASPIRIN'
             155 'D00171 AMOBARBITAL' 156 'D00172 INAMRINONE'
             157 'D00173 ATRACURIUM' 158 'D00174 ATROPINE'
             159 'D00175 BENZTROPINE' 160 'D00176 BETAXOLOL'
             161 'D00177 BLEOMYCIN' 162 'D00178 BROMOCRIPTINE'
             163 'D00179 BUMETANIDE' 164 'D00180 BUPIVACAINE'
             165 'D00181 BUPROPION' 166 'D00182 BUSPIRONE'
             167 'D00183 BUSULFAN' 168 'D00184 CARBIDOPA'
             169 'D00185 CARBOPLATIN' 170 'D00186 CEPHALOTHIN'
             171 'D00187 CEPHAPIRIN' 172 'D00188 CHLORAMBUCIL'
             173 'D00189 CHLORDIAZEPOXIDE' 174 'D00190 CHLOROTHIAZIDE'
             175 'D00191 CHLORPHENIRAMINE' 176 'D00192 CHLORTHALIDONE'
             177 'D00193 CHOLESTYRAMINE' 178 'D00195 CISPLATIN'
             179 'D00197 CLONAZEPAM' 180 'D00198 CLORAZEPATE'
             181 'D00199 CLOZAPINE' 182 'D00200 CROMOLYN'
             183 'D00201 CYTARABINE' 184 'D00202 DACARBAZINE'
             185 'D00203 DACTINOMYCIN' 186 'D00204 DANAZOL'
             187 'D00205 DAUNORUBICIN' 188 'D00206 DEXAMETHASONE'
             189 'D00207 DEXTROMETHORPHAN' 190 'D00208 DIFLUNISAL'
             191 'D00209 DIGITOXIN' 192 'D00210 DIGOXIN'
             193 'D00211 DIHYDROERGOTAMINE' 194 'D00212 DIPHENHYDRAMINE'
             195 'D00213 DIPYRIDAMOLE' 196 'D00214 DISOPYRAMIDE'
             197 'D00215 DOBUTAMINE' 198 'D00216 DOPAMINE'
             199 'D00217 DOXEPIN' 200 'D00218 DOXORUBICIN'
             201 'D00219 DROPERIDOL' 202 'D00220 EDROPHONIUM'
             203 'D00222 ERGOTAMINE' 204 'D00223 EPOETIN ALFA'
             205 'D00224 ESMOLOL' 206 'D00226 ETHCHLORVYNOL'
             207 'D00227 ETHOSUXIMIDE' 208 'D00229 ETHINYL ESTRADIOL'
             209 'D00230 ETOPOSIDE' 210 'D00231 FELODIPINE'
             211 'D00233 FENTANYL' 212 'D00234 FLECAINIDE'
             213 'D00235 FLUOROURACIL' 214 'D00236 FLUOXETINE'
             215 'D00237 FLUPHENAZINE' 216 'D00238 FLURAZEPAM'
             217 'D00239 FLURBIPROFEN' 218 'D00240 FLUTAMIDE'
             219 'D00241 FOLIC ACID' 220 'D00242 FOSINOPRIL'
             221 'D00243 FURAZOLIDONE' 222 'D00245 GEMFIBROZIL'
             223 'D00246 GLIPIZIDE' 224 'D00248 GLYBURIDE'
             225 'D00250 GOLD SODIUM THIOMALATE' 226 'D00252 HEPARIN'
             227 'D00253 HYDROCHLOROTHIAZIDE' 228 'D00254 HYDROCORTISONE'
             229 'D00255 HYDROMORPHONE' 230 'D00256 IDARUBICIN'
             231 'D00257 IFOSFAMIDE' 232 'D00259 IMIPRAMINE'
             233 'D00260 INDAPAMIDE' 234 'D00262 INSULIN'
             235 'D00265 IPRATROPIUM' 236 'D00267 ISOFLURANE'
             237 'D00268 ISOSORBIDE DINITRATE'
             238 'D00269 ISOSORBIDE MONONITRATE' 239 'D00270 ISRADIPINE'
             240 'D00271 KANAMYCIN' 241 'D00272 KETAMINE'
             242 'D00273 KETOROLAC' 243 'D00275 LEUCOVORIN'
             244 'D00276 LEVAMISOLE' 245 'D00277 LEVODOPA'
             246 'D00278 LEVOTHYROXINE' 247 'D00279 LINCOMYCIN'
             248 'D00280 LOVASTATIN' 249 'D00282 MANNITOL'
             250 'D00283 MECLOFENAMATE' 251 'D00284 MEDROXYPROGESTERONE'
             252 'D00285 MEFENAMIC ACID' 253 'D00286 MEFLOQUINE'
             254 'D00287 MELPHALAN' 255 'D00288 MEPROBAMATE'
             256 'D00289 MERCAPTOPURINE' 257 'D00290 METHIMAZOLE'
             258 'D00292 METHSUXIMIDE' 259 'D00293 METHYLPREDNISOLONE'
             260 'D00295 METHYLTESTOSTERONE'
             261 'D00297 METIPRANOLOL OPHTHALMIC' 262 'D00298 METOCLOPRAMIDE'
             263 'D00299 METOLAZONE' 264 'D00300 MEXILETINE'
             265 'D00301 MIDAZOLAM' 266 'D00302 MILRINONE'
             267 'D00303 MISOPROSTOL' 268 'D00305 MITOMYCIN'
             269 'D00306 MITOXANTRONE' 270 'D00307 MORICIZINE'
             271 'D00308 MORPHINE' 272 'D00310 NABUMETONE'
             273 'D00311 NALOXONE' 274 'D00312 NEOMYCIN'
             275 'D00313 NEOSTIGMINE' 276 'D00314 NIACIN'
             277 'D00315 NICARDIPINE' 278 'D00316 NICOTINE'
             279 'D00318 NIMODIPINE' 280 'D00321 NITROGLYCERIN'
             281 'D00322 NIZATIDINE' 282 'D00323 NOREPINEPHRINE'
             283 'D00325 OMEPRAZOLE' 284 'D00328 OXYBUTYNIN'
             285 'D00329 OXYCODONE' 286 'D00330 PANCURONIUM'
             287 'D00331 PARAAMINOBENZOIC ACID' 288 'D00332 PENBUTOLOL'
             289 'D00333 PENICILLAMINE' 290 'D00334 PENTAZOCINE'
             291 'D00335 PENTOBARBITAL' 292 'D00336 PENTOXIFYLLINE'
             293 'D00337 PHENAZOPYRIDINE' 294 'D00340 PHENOBARBITAL'
             295 'D00341 PHENYLBUTAZONE' 296 'D00342 PHYSOSTIGMINE'
             297 'D00343 PIROXICAM' 298 'D00344 POLYMYXIN B SULFATE'
             299 'D00345 POTASSIUM CHLORIDE'
             300 'D00346 POVIDONE IODINE TOPICAL' 301 'D00348 PRAVASTATIN'
             302 'D00349 PRAZIQUANTEL' 303 'D00350 PREDNISONE'
             304 'D00351 PRIMAQUINE' 305 'D00352 PRIMIDONE'
             306 'D00353 PROBUCOL' 307 'D00354 PROCARBAZINE'
             308 'D00355 PROCHLORPERAZINE' 309 'D00356 PROMAZINE'
             310 'D00358 PROPAFENONE' 311 'D00359 PROPANTHELINE'
             312 'D00360 PROPOXYPHENE' 313 'D00361 PROPYLTHIOURACIL'
             314 'D00362 PROTAMINE' 315 'D00363 PYRIDOSTIGMINE'
             316 'D00364 PYRIMETHAMINE' 317 'D00365 QUINAPRIL'
             318 'D00366 QUININE' 319 'D00367 RESERPINE'
             320 'D00368 SECOBARBITAL' 321 'D00370 OCTREOTIDE'
             322 'D00371 SOTALOL' 323 'D00373 SPIRONOLACTONE'
             324 'D00374 STREPTOKINASE' 325 'D00375 STREPTOZOCIN'
             326 'D00376 SUCCINYLCHOLINE' 327 'D00377 SUCRALFATE'
             328 'D00378 SUFENTANIL' 329 'D00379 SULFASALAZINE'
             330 'D00381 TAMOXIFEN' 331 'D00384 TEMAZEPAM'
             332 'D00386 TERAZOSIN' 333 'D00387 TERFENADINE'
             334 'D00388 THIOPENTAL' 335 'D00389 THIORIDAZINE'
             336 'D00391 THIOTHIXENE' 337 'D00393 TOLAZAMIDE'
             338 'D00394 TOLBUTAMIDE' 339 'D00395 TRAZODONE'
             340 'D00396 TRIAMTERENE' 341 'D00397 TRIAZOLAM'
             342 'D00398 VASOPRESSIN' 343 'D00399 VECURONIUM'
             344 'D00400 VINBLASTINE' 345 'D00401 VINCRISTINE'
             346 'D00402 VITAMIN A' 347 'D00405 VITAMIN E'
             348 'D00409 RIBOFLAVIN' 349 'D00412 PYRIDOXINE'
             350 'D00413 CYANOCOBALAMIN' 351 'D00417 BIOFLAVONOIDS'
             352 'D00425 CALCIUM CARBONATE' 353 'D00426 ASCORBIC ACID'
             354 'D00427 POTASSIUM PHOSPHATE-SODIUM PHOSPHATE'
             355 'D00428 FLUORIDE' 356 'D00438 SODIUM CHLORIDE'
             357 'D00439 CITRIC ACID-POTASSIUM CITRATE'
             358 'D00440 SODIUM BICARBONATE' 359 'D00468 MAGNESIUM SULFATE'
             360 'D00471 SODIUM ACETATE' 361 'D00472 TROMETHAMINE'
             362 'D00475 SODIUM PHOSPHATE' 363 'D00476 AMMONIUM CHLORIDE'
             364 'D00481 AMMONIUM MOLYBDATE TETRAHYDRATE'
             365 'D00484 SELENIUM' 366 'D00485 IODINE TOPICAL'
             367 'D00487 GLUTAMIC ACID' 368 'D00488 LYSINE'
             369 'D00491 LEVOCARNITINE' 370 'D00496 INOSITOL'
             371 'D00497 OMEGA-3 POLYUNSATURATED FATTY ACIDS'
             372 'D00512 FILGRASTIM' 373 'D00513 SARGRAMOSTIM'
             374 'D00514 TICLOPIDINE' 375 'D00519 ANISINDIONE'
             376 'D00521 ALTEPLASE' 377 'D00523 UROKINASE'
             378 'D00524 ANTITHROMBIN III'
             379 'D00525 ANTIHEMOPHILIC FACTOR (OBSOLETE)'
             380 'D00526 ANTI-INHIBITOR COAGULANT COMPLEX'
             381 'D00527 FACTOR IX COMPLEX (OBSOLETE)'
             382 'D00528 AMINOCAPROIC ACID' 383 'D00529 TRANEXAMIC ACID'
             384 'D00534 ESTRONE' 385 'D00537 ESTRADIOL'
             386 'D00541 CONJUGATED ESTROGENS'
             387 'D00542 ESTERIFIED ESTROGENS' 388 'D00543 ESTROPIPATE'
             389 'D00546 DIETHYLSTILBESTROL' 390 'D00550 PROGESTERONE'
             391 'D00554 HYDROXYPROGESTERONE' 392 'D00555 NORETHINDRONE'
             393 'D00557 LEVONORGESTREL' 394 'D00558 TESTOSTERONE'
             395 'D00562 FLUOXYMESTERONE' 396 'D00563 FINASTERIDE'
             397 'D00565 STANOZOLOL' 398 'D00566 OXANDROLONE'
             399 'D00568 NANDROLONE' 400 'D00569 CLOMIPHENE'
             401 'D00570 UROFOLLITROPIN' 402 'D00571 MENOTROPINS'
             403 'D00572 CHORIONIC GONADOTROPIN (HCG)' 404 'D00574 NAFARELIN'
             405 'D00575 HISTRELIN' 406 'D00576 SOMATREM'
             407 'D00577 SOMATROPIN' 408 'D00578 ARGININE'
             409 'D00583 DESMOPRESSIN' 410 'D00584 OXYTOCIN'
             411 'D00586 ERGONOVINE' 412 'D00587 METHYLERGONOVINE'
             413 'D00589 DINOPROSTONE TOPICAL' 414 'D00592 METYRAPONE'
             415 'D00593 GLUCAGON' 416 'D00595 GLUCOSE'
             417 'D00598 CALCITONIN' 418 'D00599 ETIDRONATE'
             419 'D00601 PAMIDRONATE' 420 'D00602 GALLIUM NITRATE'
             421 'D00603 RITODRINE' 422 'D00604 CORTICOTROPIN'
             423 'D00607 COSYNTROPIN' 424 'D00608 FLUDROCORTISONE'
             425 'D00609 CORTISONE' 426 'D00620 TRIAMCINOLONE'
             427 'D00626 DEXAMETHASONE TOPICAL' 428 'D00628 BETAMETHASONE'
             429 'D00640 METHAZOLAMIDE' 430 'D00641 BENDROFLUMETHIAZIDE'
             431 'D00643 METHYCLOTHIAZIDE' 432 'D00644 BENZTHIAZIDE'
             433 'D00645 HYDROFLUMETHIAZIDE' 434 'D00646 TRICHLORMETHIAZIDE'
             435 'D00647 POLYTHIAZIDE' 436 'D00649 ETHACRYNIC ACID'
             437 'D00651 UREA TOPICAL' 438 'D00652 GLYCERIN'
             439 'D00653 ISOSORBIDE' 440 'D00655 THYROID DESICCATED'
             441 'D00658 LIOTHYRONINE' 442 'D00659 LIOTRIX'
             443 'D00666 AMYL NITRITE' 444 'D00683 LIDOCAINE TOPICAL'
             445 'D00688 BEPRIDIL' 446 'D00689 AMLODIPINE'
             447 'D00693 ISOXSUPRINE' 448 'D00695 PAPAVERINE'
             449 'D00696 ETHAVERINE' 450 'D00697 ISOPROTERENOL'
             451 'D00699 EPINEPHRINE' 452 'D00700 EPHEDRINE'
             453 'D00703 METHOXAMINE' 454 'D00704 PHENYLEPHRINE'
             455 'D00708 CARTEOLOL' 456 'D00709 BISOPROLOL'
             457 'D00717 GUANFACINE' 458 'D00726 DOXAZOSIN'
             459 'D00728 RAMIPRIL' 460 'D00730 BENAZEPRIL'
             461 'D00732 LISINOPRIL' 462 'D00733 PHENTOLAMINE'
             463 'D00734 PHENOXYBENZAMINE' 464 'D00735 METYROSINE'
             465 'D00739 MECAMYLAMINE'
             466 'D00743 SODIUM POLYSTYRENE SULFONATE'
             467 'D00744 COLESTIPOL' 468 'D00746 SIMVASTATIN'
             469 'D00747 DEXTROTHYROXINE SODIUM' 470 'D00749 ALBUTEROL'
             471 'D00750 METAPROTERENOL' 472 'D00752 TERBUTALINE'
             473 'D00755 PIRBUTEROL' 474 'D00758 AMINOPHYLLINE'
             475 'D00759 DYPHYLLINE' 476 'D00760 BECLOMETHASONE'
             477 'D00761 FLUNISOLIDE' 478 'D00762 ACETYLCYSTEINE'
             479 'D00765 CROMOLYN OPHTHALMIC'
             480 'D00767 PHENYLPROPANOLAMINE' 481 'D00769 PSEUDOEPHEDRINE'
             482 'D00771 NAPHAZOLINE OPHTHALMIC'
             483 'D00772 OXYMETAZOLINE NASAL'
             484 'D00773 TETRAHYDROZOLINE OPHTHALMIC'
             485 'D00774 XYLOMETAZOLINE NASAL'
             486 'D00775 ALPHA 1-PROTEINASE INHIBITOR'
             487 'D00780 CLEMASTINE' 488 'D00782 PYRILAMINE'
             489 'D00784 DEXCHLORPHENIRAMINE' 490 'D00785 BROMPHENIRAMINE'
             491 'D00786 TRIPROLIDINE' 492 'D00787 PROMETHAZINE'
             493 'D00788 TRIMEPRAZINE' 494 'D00789 METHDILAZINE'
             495 'D00790 CYPROHEPTADINE' 496 'D00791 AZATADINE'
             497 'D00793 PHENINDAMINE' 498 'D00796 BENZONATATE'
             499 'D00797 GUAIFENESIN' 500 'D00800 POTASSIUM IODIDE'
             501 'D00801 CAFFEINE' 502 'D00802 DOXAPRAM'
             503 'D00803 AMPHETAMINE' 504 'D00804 DEXTROAMPHETAMINE'
             505 'D00805 METHAMPHETAMINE' 506 'D00806 PHENTERMINE'
             507 'D00807 BENZPHETAMINE' 508 'D00809 PHENDIMETRAZINE'
             509 'D00810 DIETHYLPROPION' 510 'D00811 MAZINDOL'
             511 'D00812 FENFLURAMINE' 512 'D00813 BENZOCAINE TOPICAL'
             513 'D00814 METHOTRIMEPRAZINE' 514 'D00817 HYDROXYCHLOROQUINE'
             515 'D00824 OPIUM' 516 'D00825 LEVORPHANOL'
             517 'D00833 OXYMORPHONE' 518 'D00838 BUTORPHANOL'
             519 'D00839 NALBUPHINE' 520 'D00840 BUPRENORPHINE'
             521 'D00842 SALSALATE' 522 'D00846 MAGNESIUM SALICYLATE'
             523 'D00848 DICLOFENAC' 524 'D00851 ETODOLAC'
             525 'D00853 OXAPROZIN' 526 'D00855 PERPHENAZINE'
             527 'D00857 THIETHYLPERAZINE' 528 'D00858 CYCLIZINE'
             529 'D00859 MECLIZINE' 530 'D00861 DIMENHYDRINATE'
             531 'D00862 TRIMETHOBENZAMIDE' 532 'D00866 DRONABINOL'
             533 'D00867 ONDANSETRON' 534 'D00873 TRIMIPRAMINE'
             535 'D00874 AMOXAPINE' 536 'D00875 PROTRIPTYLINE'
             537 'D00876 CLOMIPRAMINE' 538 'D00877 MAPROTILINE'
             539 'D00880 SERTRALINE' 540 'D00882 ISOCARBOXAZID'
             541 'D00883 PHENELZINE' 542 'D00884 TRANYLCYPROMINE'
             543 'D00889 MESORIDAZINE' 544 'D00890 TRIFLUOPERAZINE'
             545 'D00896 MOLINDONE' 546 'D00897 LOXAPINE'
             547 'D00898 PIMOZIDE' 548 'D00900 METHYLPHENIDATE'
             549 'D00901 PEMOLINE' 550 'D00902 ERGOLOID MESYLATES'
             551 'D00907 HYDROXYZINE' 552 'D00909 CHLORMEZANONE'
             553 'D00910 ZOLPIDEM' 554 'D00911 PARALDEHYDE'
             555 'D00912 ACETYLCARBROMAL' 556 'D00915 ESTAZOLAM'
             557 'D00917 QUAZEPAM' 558 'D00919 MEPHOBARBITAL'
             559 'D00923 BUTABARBITAL' 560 'D00929 METHOHEXITAL'
             561 'D00931 ETOMIDATE' 562 'D00933 PROPOFOL'
             563 'D00934 NITROUS OXIDE' 564 'D00942 ETHOTOIN'
             565 'D00943 PHENSUXIMIDE' 566 'D00944 PARAMETHADIONE'
             567 'D00960 CARISOPRODOL' 568 'D00962 CHLORZOXAZONE'
             569 'D00963 CYCLOBENZAPRINE' 570 'D00964 METAXALONE'
             571 'D00965 METHOCARBAMOL' 572 'D00966 ORPHENADRINE'
             573 'D00967 BACLOFEN' 574 'D00968 DANTROLENE'
             575 'D00969 PROCYCLIDINE' 576 'D00970 TRIHEXYPHENIDYL'
             577 'D00972 BIPERIDEN' 578 'D00976 SELEGILINE'
             579 'D00977 PERGOLIDE' 580 'D00978 ALUMINUM HYDROXIDE'
             581 'D00980 DIHYDROXYALUMINUM SODIUM CARBONATE'
             582 'D00982 MAGNESIUM HYDROXIDE' 583 'D00984 MAGALDRATE'
             584 'D00985 HYOSCYAMINE' 585 'D00986 SCOPOLAMINE'
             586 'D00988 BELLADONNA' 587 'D00989 METHSCOPOLAMINE'
             588 'D00991 CLIDINIUM' 589 'D00992 GLYCOPYRROLATE'
             590 'D00999 DICYCLOMINE' 591 'D01002 PANCRELIPASE'
             592 'D01003 PANCREATIN' 593 'D01005 URSODIOL'
             594 'D01008 MAGNESIUM CITRATE' 595 'D01009 SODIUM BIPHOSPHATE'
             596 'D01010 CASCARA SAGRADA' 597 'D01012 PHENOLPHTHALEIN'
             598 'D01013 SENNA' 599 'D01014 CASTOR OIL'
             600 'D01015 BISACODYL' 601 'D01017 POLYCARBOPHIL'
             602 'D01018 PSYLLIUM' 603 'D01019 MINERAL OIL'
             604 'D01021 DOCUSATE'
             605 'D01023 POLYETHYLENE GLYCOL 3350 WITH ELECTROLYTES'
             606 'D01024 LACTULOSE' 607 'D01025 LOPERAMIDE'
             608 'D01026 BISMUTH SUBSALICYLATE' 609 'D01027 SIMETHICONE'
             610 'D01028 CHARCOAL' 611 'D01030 DEHYDROCHOLIC ACID'
             612 'D01031 MESALAMINE' 613 'D01032 OLSALAZINE'
             614 'D01068 DEMECLOCYCLINE' 615 'D01070 OXYTETRACYCLINE'
             616 'D01090 SULFAMETHIZOLE' 617 'D01097 RIFABUTIN'
             618 'D01100 ETHIONAMIDE' 619 'D01101 CYCLOSERINE'
             620 'D01104 PAROMOMYCIN' 621 'D01105 IODOQUINOL'
             622 'D01112 COLISTIN SULFATE OTIC' 623 'D01113 COLISTIMETHATE'
             624 'D01115 BACITRACIN' 625 'D01120 ATOVAQUONE'
             626 'D01121 CLOFAZIMINE' 627 'D01123 PYRANTEL'
             628 'D01124 PIPERAZINE' 629 'D01128 METHYLENE BLUE'
             630 'D01129 CINOXACIN' 631 'D01133 IMMUNE GLOBULIN INTRAVENOUS'
             632 'D01135 IMMUNE GLOBULIN INTRAMUSCULAR'
             633 'D01136 HEPATITIS B IMMUNE GLOBULIN'
             634 'D01138 VARICELLA ZOSTER IMMUNE GLOBULIN'
             635 'D01139 RHO (D) IMMUNE GLOBULIN'
             636 'D01141 LYMPHOCYTE IMMUNE GLOBULIN, ANTI-THY (OBS)'
             637 'D01142 DIPHTHERIA ANTITOXIN'
             638 'D01144 ANTIVENIN (CROTALIDAE) POLYVALENT'
             639 'D01146 ANTIVENIN (BLACK WIDOW SPIDER)'
             640 'D01147 RABIES VACCINE (OBSOLETE)'
             641 'D01148 RABIES IMMUNE GLOBULIN, HUMAN' 642 'D01150 BCG'
             643 'D01152 STAPHAGE LYSATE (SPL)'
             644 'D01153 MENINGOCOCCAL POLYSACCHARIDE VACCINE'
             645 'D01156 TYPHOID VACCINE, INACTIVATED'
             646 'D01158 HAEMOPHILUS B CONJUGATE VACCINE (OBSOLETE)'
             647 'D01159 MEASLES VIRUS VACCINE'
             648 'D01160 RUBELLA VIRUS VACCINE'
             649 'D01161 MUMPS VIRUS VACCINE'
             650 'D01162 POLIOVIRUS VACCINE, LIVE, TRIVALENT'
             651 'D01163 POLIOVIRUS VACCINE, INACTIVATED'
             652 'D01164 INFLUENZA VIRUS VACCINE, INACTIVATED'
             653 'D01165 YELLOW FEVER VACCINE'
             654 'D01166 HEPATITIS B VACCINE (OBSOLETE)'
             655 'D01168 TETANUS TOXOID'
             656 'D01171 TUBERCULIN PURIFIED PROTEIN DERIVATIVE'
             657 'D01184 DIPIVEFRIN OPHTHALMIC'
             658 'D01187 LEVOBUNOLOL OPHTHALMIC'
             659 'D01188 ACETYLCHOLINE OPHTHALMIC'
             660 'D01191 PILOCARPINE OPHTHALMIC'
             661 'D01195 ECHOTHIOPHATE IODIDE OPHTHALMIC'
             662 'D01199 HOMATROPINE OPHTHALMIC'
             663 'D01200 TROPICAMIDE OPHTHALMIC'
             664 'D01201 CYCLOPENTOLATE OPHTHALMIC'
             665 'D01204 SUPROFEN OPHTHALMIC'
             666 'D01208 SULFACETAMIDE SODIUM OPHTHALMIC'
             667 'D01210 YELLOW MERCURIC OXIDE OPHTHALMIC'
             668 'D01215 TRIFLURIDINE OPHTHALMIC' 669 'D01217 TETRACAINE'
             670 'D01218 PROPARACAINE OPHTHALMIC'
             671 'D01219 FLUORESCEIN OPHTHALMIC'
             672 'D01222 SODIUM HYALURONATE OPHTHALMIC'
             673 'D01225 BORIC ACID TOPICAL'
             674 'D01226 HYDROXYPROPYL METHYLCELLULOSE OPHTHALMIC'
             675 'D01227 BOTULINUM TOXIN TYPE A (OBSOLETE)'
             676 'D01231 CHLORHEXIDINE TOPICAL'
             677 'D01232 CARBAMIDE PEROXIDE TOPICAL' 678 'D01233 NYSTATIN'
             679 'D01234 BUTOCONAZOLE TOPICAL'
             680 'D01235 TIOCONAZOLE TOPICAL' 681 'D01236 CLOTRIMAZOLE'
             682 'D01238 TERCONAZOLE TOPICAL'
             683 'D01239 GENTIAN VIOLET TOPICAL'
             684 'D01240 SULFANILAMIDE TOPICAL'
             685 'D01241 CLINDAMYCIN TOPICAL'
             686 'D01242 NONOXYNOL 9 TOPICAL' 687 'D01243 OCTOXYNOL TOPICAL'
             688 'D01244 TRETINOIN TOPICAL' 689 'D01245 ISOTRETINOIN'
             690 'D01246 BENZOYL PEROXIDE TOPICAL'
             691 'D01254 ANTHRALIN TOPICAL'
             692 'D01257 NITROFURAZONE TOPICAL' 693 'D01258 MAFENIDE TOPICAL'
             694 'D01259 SILVER SULFADIAZINE TOPICAL'
             695 'D01263 PYRITHIONE ZINC TOPICAL'
             696 'D01265 SULFACETAMIDE SODIUM TOPICAL'
             697 'D01266 CHLOROXINE TOPICAL' 698 'D01267 MUPIROCIN TOPICAL'
             699 'D01271 ECONAZOLE TOPICAL' 700 'D01272 CICLOPIROX TOPICAL'
             701 'D01273 TRIACETIN TOPICAL' 702 'D01274 TOLNAFTATE TOPICAL'
             703 'D01275 SULCONAZOLE TOPICAL' 704 'D01277 NAFTIFINE TOPICAL'
             705 'D01278 LINDANE TOPICAL' 706 'D01279 PERMETHRIN TOPICAL'
             707 'D01280 CROTAMITON TOPICAL'
             708 'D01282 ALCLOMETASONE TOPICAL'
             709 'D01288 CLOBETASOL TOPICAL'
             710 'D01289 CLOCORTOLONE TOPICAL' 711 'D01290 DESONIDE TOPICAL'
             712 'D01291 DESOXIMETASONE TOPICAL'
             713 'D01292 DIFLORASONE TOPICAL'
             714 'D01293 FLUOCINOLONE TOPICAL'
             715 'D01294 FLUOCINONIDE TOPICAL'
             716 'D01295 FLURANDRENOLIDE TOPICAL' 717 'D01296 FLUTICASONE'
             718 'D01298 HALOBETASOL TOPICAL' 719 'D01300 MOMETASONE TOPICAL'
             720 'D01301 DIBUCAINE TOPICAL' 721 'D01302 BUTAMBEN TOPICAL'
             722 'D01303 PRAMOXINE TOPICAL' 723 'D01305 DYCLONINE TOPICAL'
             724 'D01306 COCAINE TOPICAL' 725 'D01307 SALICYLIC ACID TOPICAL'
             726 'D01308 PODOPHYLLUM RESIN TOPICAL'
             727 'D01309 PODOFILOX TOPICAL'
             728 'D01313 TRICHLOROACETIC ACID TOPICAL'
             729 'D01314 SUTILAINS TOPICAL' 730 'D01315 COLLAGENASE TOPICAL'
             731 'D01316 MASOPROCOL TOPICAL'
             732 'D01319 HYDROQUINONE TOPICAL'
             733 'D01320 FORMALDEHYDE TOPICAL' 734 'D01321 CAPSAICIN TOPICAL'
             735 'D01322 ALUMINUM CHLORIDE HEXAHYDRATE TOPICAL'
             736 'D01323 MONOBENZONE TOPICAL' 737 'D01325 ARNICA TOPICAL'
             738 'D01332 HEXACHLOROPHENE TOPICAL'
             739 'D01333 BENZALKONIUM CHLORIDE TOPICAL'
             740 'D01335 SODIUM HYPOCHLORITE TOPICAL'
             741 'D01338 PHYSIOLOGICAL IRRIGATING SOLUTION'
             742 'D01339 MECHLORETHAMINE' 743 'D01341 LOMUSTINE'
             744 'D01342 CARMUSTINE' 745 'D01344 FLOXURIDINE'
             746 'D01345 THIOGUANINE' 747 'D01346 FLUDARABINE'
             748 'D01348 MEGESTROL' 749 'D01351 ESTRAMUSTINE'
             750 'D01353 LEUPROLIDE' 751 'D01354 GOSERELIN'
             752 'D01356 PENTOSTATIN' 753 'D01361 PLICAMYCIN'
             754 'D01368 INTERFERON ALFA-2A' 755 'D01369 INTERFERON ALFA-2B'
             756 'D01372 ALTRETAMINE' 757 'D01373 HYDROXYUREA'
             758 'D01375 ALDESLEUKIN' 759 'D01376 PACLITAXEL'
             760 'D01378 MITOTANE' 761 'D01379 ASPARAGINASE ESCHERICHIA COLI'
             762 'D01382 ETHANOLAMINE OLEATE'
             763 'D01383 SODIUM TETRADECYL SULFATE'
             764 'D01384 MORRHUATE SODIUM' 765 'D01385 BETA-CAROTENE'
             766 'D01386 YOHIMBINE' 767 'D01387 ALPROSTADIL'
             768 'D01389 DISULFIRAM' 769 'D01393 HYALURONIDASE'
             770 'D01394 PROCAINE' 771 'D01395 CHLOROPROCAINE'
             772 'D01396 PRILOCAINE' 773 'D01398 MEPIVACAINE'
             774 'D01402 DEFEROXAMINE' 775 'D01404 SODIUM THIOSULFATE'
             776 'D01406 NALTREXONE' 777 'D01407 FLUMAZENIL'
             778 'D01409 PRALIDOXIME' 779 'D01410 DIGOXIN IMMUNE FAB'
             780 'D01411 MESNA' 781 'D01413 IPECAC' 782 'D01416 TRIENTINE'
             783 'D01417 SUCCIMER' 784 'D01420 AMBENONIUM'
             785 'D01422 GUANIDINE' 786 'D01423 POTASSIUM CITRATE'
             787 'D01424 POTASSIUM ACID PHOSPHATE' 788 'D01425 FLAVOXATE'
             789 'D01427 BETHANECHOL' 790 'D01431 DIMETHYL SULFOXIDE'
             791 'D01433 ACETOHYDROXAMIC ACID' 792 'D01434 METHOXSALEN'
             793 'D01438 IOPANOIC ACID' 794 'D01445 BARIUM SULFATE'
             795 'D01451 GADOPENTETATE DIMEGLUMINE' 796 'D01452 IODAMIDE'
             797 'D01456 IOHEXOL' 798 'D01461 IOPAMIDOL'
             799 'D01469 IOVERSOL' 800 'D01472 METRIZAMIDE'
             801 'D01473 DIATRIZOATE' 802 'D01475 IOTHALAMATE'
             803 'D01476 ETHIODIZED OIL' 804 'D01482 ISOSULFAN BLUE'
             805 'D02373 PHOSPHORATED CARBOHYDRATE SOLUTION'
             806 'D02374 DESFLURANE' 807 'D02375 PLASMA PROTEIN FRACTION'
             808 'D02376 ALBUMIN HUMAN' 809 'D02378 HETASTARCH'
             810 'D02381 POTASSIUM PERCHLORATE' 811 'D03001 CLADRIBINE'
             812 'D03003 DIPHTHERIA-TETANUS TOXOIDS (OBSOLETE)'
             813 'D03004 DIPHTHERIA/PERTUSSIS, WHOLE CELL/TETANUS'
             814 'D03006 MEASLES-RUBELLA VIRUS VACCINE'
             815 'D03007 MEASLES/MUMPS/RUBELLA VIRUS VACCINE'
             816 'D03008 INTERFERON GAMMA-1B' 817 'D03034 NORGESTREL'
             818 'D03041 ENOXAPARIN' 819 'D03050 LORATADINE'
             820 'D03051 INTERFERON BETA-1B'
             821 'D03052 HYDROCHLOROTHIAZIDE-TRIAMTERENE'
             822 'D03054 AMYLASE' 823 'D03056 ATTAPULGITE'
             824 'D03058 BENZOIC ACID' 825 'D03061 BUTALBITAL'
             826 'D03062 CASANTHRANOL' 827 'D03066 CITRIC ACID'
             828 'D03068 DICHLORALPHENAZONE' 829 'D03075 HYDROCODONE'
             830 'D03077 ISOMETHEPTENE MUCATE' 831 'D03085 PEPSIN'
             832 'D03086 PHENIRAMINE' 833 'D03089 PHENYLTOLOXAMINE'
             834 'D03094 SALICYLAMIDE' 835 'D03096 SODIUM BENZOATE'
             836 'D03097 SODIUM BORATE TOPICAL' 837 'D03098 SODIUM CITRATE'
             838 'D03109 JAPANESE ENCEPHALITIS VIRUS VACCINE NAKAYAMA'
             839 'D03110 DIPHTH/PERTUSSIS, ACEL/TETANUS (OBSOLETE)'
             840 'D03112 NEDOCROMIL'
             841 'D03113 DEXTRAN, LOW MOLECULAR WEIGHT'
             842 'D03114 DEXTRAN, HIGH MOLECULAR WEIGHT'
             843 'D03116 BISMUTH SUBGALLATE' 844 'D03118 MUROMONAB-CD3'
             845 'D03125 DIHYDROTACHYSTEROL' 846 'D03126 CALCITRIOL'
             847 'D03128 ERGOCALCIFEROL' 848 'D03129 CHOLECALCIFEROL'
             849 'D03130 THIAMINE' 850 'D03133 HYDROXOCOBALAMIN'
             851 'D03135 PHYTONADIONE' 852 'D03136 VITAMIN A & D TOPICAL'
             853 'D03137 CALCIUM-VITAMIN D' 854 'D03140 MULTIVITAMIN'
             855 'D03141 MULTIVITAMIN WITH IRON'
             856 'D03143 MULTIVITAMIN WITH FLUORIDE'
             857 'D03145 MULTIVITAMIN WITH MINERALS'
             858 'D03148 MULTIVITAMIN, PRENATAL' 859 'D03152 TRIFLUPROMAZINE'
             860 'D03154 DOXYLAMINE' 861 'D03157 PAROXETINE'
             862 'D03158 RIMANTADINE' 863 'D03159 CHOLINE'
             864 'D03160 SUMATRIPTAN' 865 'D03162 ALCOHOL (ETHANOL)'
             866 'D03165 PIPERACILLIN-TAZOBACTAM' 867 'D03166 CISAPRIDE'
             868 'D03168 DIHYDROCODEINE' 869 'D03169 TRIMETREXATE'
             870 'D03170 FELBAMATE' 871 'D03171 GRANISETRON'
             872 'D03173 DORNASE ALFA' 873 'D03176 TACRINE'
             874 'D03180 RISPERIDONE' 875 'D03181 VENLAFAXINE'
             876 'D03182 GABAPENTIN' 877 'D03183 FLUVASTATIN'
             878 'D03187 LEVOMETHADYL ACETATE' 879 'D03189 TORSEMIDE'
             880 'D03190 OXICONAZOLE TOPICAL'
             881 'D03191 TERBINAFINE TOPICAL' 882 'D03192 ZINC OXIDE TOPICAL'
             883 'D03193 AMILORIDE-HYDROCHLOROTHIAZIDE'
             884 'D03195 MICONAZOLE TOPICAL' 885 'D03196 GENTAMICIN TOPICAL'
             886 'D03197 BETAMETHASONE TOPICAL'
             887 'D03200 ERYTHROMYCIN TOPICAL' 888 'D03201 ACYCLOVIR TOPICAL'
             889 'D03202 KETOCONAZOLE TOPICAL' 890 'D03203 MINOXIDIL TOPICAL'
             891 'D03204 FLUOROURACIL TOPICAL'
             892 'D03205 HYDROCORTISONE TOPICAL'
             893 'D03206 TRIAMCINOLONE TOPICAL'
             894 'D03207 AMPHOTERICIN B TOPICAL'
             895 'D03208 METRONIDAZOLE TOPICAL'
             896 'D03210 SELENIUM SULFIDE TOPICAL'
             897 'D03211 CIPROFLOXACIN OPHTHALMIC'
             898 'D03212 ATROPINE OPHTHALMIC'
             899 'D03213 DICLOFENAC OPHTHALMIC'
             900 'D03214 KETOROLAC OPHTHALMIC'
             901 'D03221 PREDNISOLONE OPHTHALMIC'
             902 'D03222 TOBRAMYCIN OPHTHALMIC' 903 'D03224 NEOMYCIN TOPICAL'
             904 'D03226 SALIVA SUBSTITUTES'
             905 'D03227 FLUOROMETHOLONE OPHTHALMIC'
             906 'D03228 LODOXAMIDE OPHTHALMIC'
             907 'D03229 LEVOCABASTINE OPHTHALMIC'
             908 'D03231 TRIPLE SULFA TOPICAL'
             909 'D03232 VITAMINS A, D, AND E TOPICAL'
             910 'D03233 VITAMIN E TOPICAL'
             911 'D03238 ETHINYL ESTRADIOL-NORETHINDRONE'
             912 'D03240 MESTRANOL-NORETHINDRONE'
             913 'D03241 ETHINYL ESTRADIOL-NORGESTREL'
             914 'D03242 ETHINYL ESTRADIOL-LEVONORGESTREL'
             915 'D03245 ESTERIFIED ESTROGENS-METHYLTESTOSTERONE'
             916 'D03247 HYDROCHLOROTHIAZIDE-SPIRONOLACTONE'
             917 'D03251 HYDROCHLOROTHIAZIDE-RESERPINE'
             918 'D03255 BENDROFLUMETHIAZIDE-RAUWOLFIA SERPENTINA'
             919 'D03256 HYDRALAZINE/HYDROCHLOROTHIAZIDE/RESERPINE'
             920 'D03257 HYDRALAZINE-HYDROCHLOROTHIAZIDE'
             921 'D03258 ATENOLOL-CHLORTHALIDONE'
             922 'D03259 BENDROFLUMETHIAZIDE-NADOLOL'
             923 'D03260 HYDROCHLOROTHIAZIDE-TIMOLOL'
             924 'D03261 HYDROCHLOROTHIAZIDE-PROPRANOLOL'
             925 'D03263 HYDROCHLOROTHIAZIDE-METHYLDOPA'
             926 'D03264 HYDROCHLOROTHIAZIDE-METOPROLOL'
             927 'D03265 BENAZEPRIL-HYDROCHLOROTHIAZIDE'
             928 'D03266 HYDROCHLOROTHIAZIDE-LISINOPRIL'
             929 'D03267 CHLORTHALIDONE-CLONIDINE'
             930 'D03271 PHENIRAMINE-PHENYLEPHRINE NASAL'
             931 'D03273 GUAIFENESIN-THEOPHYLLINE'
             932 'D03274 AMINOPHYLLINE-GUAIFENESIN'
             933 'D03276 DYPHYLLINE-GUAIFENESIN'
             934 'D03277 POTASSIUM IODIDE-THEOPHYLLINE'
             935 'D03280 EPHEDRINE/PHENOBARBITAL/THEOPHYLLINE'
             936 'D03283 EPHEDRINE/HYDROXYZINE/THEOPHYLLINE'
             937 'D03289 ACETAMINOPHEN-PSEUDOEPHEDRINE'
             938 'D03292 IBUPROFEN-PSEUDOEPHEDRINE' 939 'D03293 APAP/ASA/PPA'
             940 'D03296 ACETAMINOPHEN-CHLORPHENIRAMINE'
             941 'D03297 ACETAMINOPHEN-PHENYLTOLOXAMINE'
             942 'D03298 CHLORPHENIRAMINE-PSEUDOEPHEDRINE'
             943 'D03299 CHLORPHENIRAMINE-PHENYLPROPANOLAMINE'
             944 'D03300 CHLORPHENIRAMINE-PHENYLEPHRINE'
             945 'D03301 BROMPHENIRAMINE-PSEUDOEPHEDRINE'
             946 'D03302 BROMPHENIRAMINE-PHENYLPROPANOLAMINE'
             947 'D03303 CLEMASTINE-PHENYLPROPANOLAMINE'
             948 'D03306 CHLORPHENIRAMINE/PE/PHENYLTOLOXAMINE'
             949 'D03307 CHLORPHENIRAMINE/PHENINDAMINE/PPA'
             950 'D03308 PHENIRAMINE/PPA/PHENYLTOLOXAMINE/PYRILAMINE'
             951 'D03310 CHLORPHENIRAMINE/PE/PPA/PHENYLTOLOXAMINE'
             952 'D03311 BROMPHENIRAMINE-PHENYLEPHRINE'
             953 'D03312 DIPHENHYDRAMINE-PSEUDOEPHEDRINE'
             954 'D03313 CHLORPHENIRAMINE/PHENYLEPHRINE/PYRILAMINE'
             955 'D03316 PSEUDOEPHEDRINE-TRIPROLIDINE'
             956 'D03317 PHENYLEPHRINE-PROMETHAZINE'
             957 'D03318 PHENIRAMINE/PPA/PYRILAMINE'
             958 'D03319 APAP/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             959 'D03320 APAP/CHLORPHENIRAMINE/PSEUDOEPHEDRINE'
             960 'D03321 APAP/BROMPHENIRAMINE/PSEUDOEPHEDRINE'
             961 'D03322 ASA/CHLORPHENIRAMINE/PHENYLPROPANOLAMINE'
             962 'D03329 ASA/DIPHENHYDRAMINE/PPA'
             963 'D03330 APAP/PSEUDOEPHEDRINE/TRIPROLIDINE'
             964 'D03331 APAP/CHLORPHENIRAMINE/PHENYLEPHRINE'
             965 'D03336 APAP/CPM/PHENYLEPHRINE/PPA/PYRILAMINE'
             966 'D03338 CHLORPHENIRAMINE/METHSCOPOLAMINE/PE'
             967 'D03340 HOMATROPINE-HYDROCODONE'
             968 'D03341 CODEINE-PSEUDOEPHEDRINE'
             969 'D03342 APAP/DEXTROMETHORPHAN/PSEUDOEPHEDRINE'
             970 'D03347 APAP/CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             971 'D03349 APAP/DEXTROMETHORPHAN/DOXYLAMINE/PSE'
             972 'D03351 ASA/BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             973 'D03352 HYDROCODONE-PSEUDOEPHEDRINE'
             974 'D03353 HYDROCODONE-PHENYLPROPANOLAMINE'
             975 'D03354 DEXTROMETHORPHAN-PSEUDOEPHEDRINE'
             976 'D03355 DEXTROMETHORPHAN-PHENYLPROPANOLAMINE'
             977 'D03356 CHLORPHENIRAMINE-HYDROCODONE'
             978 'D03357 CODEINE-PROMETHAZINE'
             979 'D03359 CHLORPHENIRAMINE-DEXTROMETHORPHAN'
             980 'D03360 DEXTROMETHORPHAN-PROMETHAZINE'
             981 'D03361 CHLORPHENIRAMINE/HYDROCODONE/PHENYLEPHRINE'
             982 'D03362 CHLORPHENIRAMINE/CODEINE/PSEUDOEPHEDRINE'
             983 'D03364 CODEINE/PHENYLEPHRINE/PROMETHAZINE'
             984 'D03366 HYDROCODONE/PHENYLEPHRINE/PYRILAMINE'
             985 'D03368 BROMPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             986 'D03369 CHLORPHENIRAMINE/DEXTROMETHORP/PHENYLEPHRINE'
             987 'D03370 CHLORPHENIRAMINE/DEXTROMETHORPHAN/PSE'
             988 'D03371 DEXTROMETHORPHAN/PHENYLEPHRINE/PYRILAMINE'
             989 'D03372 BROMPHENIRAMINE/DEXTROMETHORPHAN/PPA'
             990 'D03378 ACETAMINOPHEN-DEXTROMETHORPHAN'
             991 'D03379 GUAIFENESIN-PSEUDOEPHEDRINE'
             992 'D03380 EPHEDRINE-GUAIFENESIN'
             993 'D03381 GUAIFENESIN-PHENYLEPHRINE'
             994 'D03382 GUAIFENESIN-PHENYLPROPANOLAMINE'
             995 'D03383 GUAIFENESIN/PHENYLEPHRINE/PPA'
             996 'D03388 ETHINYL ESTRADIOL-ETHYNODIOL'
             997 'D03389 ESTRADIOL-TESTOSTERONE'
             998 'D03392 CHLORPHENIRAMINE/GUAIFENESIN/PHENYLEPHRINE'
             999 'D03393 CODEINE-GUAIFENESIN'
             1000 'D03396 GUAIFENESIN-HYDROCODONE'
             1001 'D03397 GUAIFENESIN-HYDROMORPHONE'
             1002 'D03398 CODEINE/GUAIFENESIN/PSE'
             1003 'D03400 DEXTROMETHORPHAN-GUAIFENESIN'
             1004 'D03403 GUAIFENESIN/HYDROCODONE/PHENYLEPHRINE'
             1005 'D03404 GUAIFENESIN/HYDROCODONE/PSEUDOEPHEDRINE'
             1006 'D03407 CODEINE/GUAIFENESIN/PHENYLPROPANOLAMINE'
             1007 'D03408 DEXTROMETHORPHAN/GUAIFENESIN/PHENYLEPHRINE'
             1008 'D03409 DEXTROMETHORPHAN/GUAIFENESIN/PSEUDOEPHEDRINE'
             1009 'D03411 DEXTROMETHORPHAN/GUAIFENESIN/PPA'
             1010 'D03416 CHLORPHENIRAMINE